import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import PropTypes from "prop-types";
import React from "react";
import { appendClassName } from "./view-helpers";

function Results(_ref) {
  var children = _ref.children,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["children", "className"]);

  return /*#__PURE__*/React.createElement("ul", _extends({
    className: appendClassName("sui-results-container", className)
  }, rest), children);
}

Results.propTypes = {
  children: PropTypes.node.isRequired,
  className: PropTypes.string
};
export default Results;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9SZXN1bHRzLmpzIl0sIm5hbWVzIjpbIlByb3BUeXBlcyIsIlJlYWN0IiwiYXBwZW5kQ2xhc3NOYW1lIiwiUmVzdWx0cyIsImNoaWxkcmVuIiwiY2xhc3NOYW1lIiwicmVzdCIsInByb3BUeXBlcyIsIm5vZGUiLCJpc1JlcXVpcmVkIiwic3RyaW5nIl0sIm1hcHBpbmdzIjoiOztBQUFBLE9BQU9BLFNBQVAsTUFBc0IsWUFBdEI7QUFDQSxPQUFPQyxLQUFQLE1BQWtCLE9BQWxCO0FBRUEsU0FBU0MsZUFBVCxRQUFnQyxnQkFBaEM7O0FBRUEsU0FBU0MsT0FBVCxPQUFtRDtBQUFBLE1BQWhDQyxRQUFnQyxRQUFoQ0EsUUFBZ0M7QUFBQSxNQUF0QkMsU0FBc0IsUUFBdEJBLFNBQXNCO0FBQUEsTUFBUkMsSUFBUTs7QUFDakQsc0JBQ0U7QUFDRSxJQUFBLFNBQVMsRUFBRUosZUFBZSxDQUFDLHVCQUFELEVBQTBCRyxTQUExQjtBQUQ1QixLQUVNQyxJQUZOLEdBSUdGLFFBSkgsQ0FERjtBQVFEOztBQUVERCxPQUFPLENBQUNJLFNBQVIsR0FBb0I7QUFDbEJILEVBQUFBLFFBQVEsRUFBRUosU0FBUyxDQUFDUSxJQUFWLENBQWVDLFVBRFA7QUFFbEJKLEVBQUFBLFNBQVMsRUFBRUwsU0FBUyxDQUFDVTtBQUZILENBQXBCO0FBS0EsZUFBZVAsT0FBZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcbmltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcblxuaW1wb3J0IHsgYXBwZW5kQ2xhc3NOYW1lIH0gZnJvbSBcIi4vdmlldy1oZWxwZXJzXCI7XG5cbmZ1bmN0aW9uIFJlc3VsdHMoeyBjaGlsZHJlbiwgY2xhc3NOYW1lLCAuLi5yZXN0IH0pIHtcbiAgcmV0dXJuIChcbiAgICA8dWxcbiAgICAgIGNsYXNzTmFtZT17YXBwZW5kQ2xhc3NOYW1lKFwic3VpLXJlc3VsdHMtY29udGFpbmVyXCIsIGNsYXNzTmFtZSl9XG4gICAgICB7Li4ucmVzdH1cbiAgICA+XG4gICAgICB7Y2hpbGRyZW59XG4gICAgPC91bD5cbiAgKTtcbn1cblxuUmVzdWx0cy5wcm9wVHlwZXMgPSB7XG4gIGNoaWxkcmVuOiBQcm9wVHlwZXMubm9kZS5pc1JlcXVpcmVkLFxuICBjbGFzc05hbWU6IFByb3BUeXBlcy5zdHJpbmdcbn07XG5cbmV4cG9ydCBkZWZhdWx0IFJlc3VsdHM7XG4iXX0=