"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fillTextColor = void 0;
var color_calcs_1 = require("./color_calcs");
var color_library_wrappers_1 = require("./color_library_wrappers");
var colors_1 = require("./colors");
function fillTextColor(background, containerBg) {
    if (containerBg === void 0) { containerBg = colors_1.Colors.White.keyword; }
    var backgroundRGBA = (0, color_library_wrappers_1.colorToRgba)(background);
    var containerBgRGBA = (0, color_calcs_1.combineColors)((0, color_library_wrappers_1.colorToRgba)(containerBg), colors_1.Colors.White.rgba);
    var blendedFbBg = (0, color_calcs_1.combineColors)(backgroundRGBA, containerBgRGBA);
    return (0, color_library_wrappers_1.RGBATupleToString)((0, color_calcs_1.highContrastColor)(blendedFbBg));
}
exports.fillTextColor = fillTextColor;
//# sourceMappingURL=fill_text_color.js.map