"use strict";

exports.__esModule = true;
exports.patchFetch = patchFetch;

var _polyfills = require("../polyfills");

var _patchUtils = require("./patch-utils");

var _constants = require("../constants");

var _utils = require("../utils");

function patchFetch(callback) {
  if (!window.fetch || !window.Request) {
    return;
  }

  function scheduleTask(task) {
    task.state = _constants.SCHEDULE;
    callback(_constants.SCHEDULE, task);
  }

  function invokeTask(task) {
    task.state = _constants.INVOKE;
    callback(_constants.INVOKE, task);
  }

  var nativeFetch = window.fetch;

  window.fetch = function (input, init) {
    var fetchSelf = this;
    var args = arguments;
    var request, url;

    if (typeof input === 'string') {
      request = new Request(input, init);
      url = input;
    } else if (input) {
      request = input;
      url = request.url;
    } else {
      return nativeFetch.apply(fetchSelf, args);
    }

    var task = {
      source: _constants.FETCH,
      state: '',
      type: 'macroTask',
      data: {
        target: request,
        method: request.method,
        url: url,
        aborted: false
      }
    };
    return new _polyfills.Promise(function (resolve, reject) {
      _patchUtils.globalState.fetchInProgress = true;
      scheduleTask(task);
      var promise;

      try {
        promise = nativeFetch.apply(fetchSelf, [request]);
      } catch (error) {
        reject(error);
        task.data.error = error;
        invokeTask(task);
        _patchUtils.globalState.fetchInProgress = false;
        return;
      }

      promise.then(function (response) {
        resolve(response);
        (0, _utils.scheduleMicroTask)(function () {
          task.data.response = response;
          invokeTask(task);
        });
      }, function (error) {
        reject(error);
        (0, _utils.scheduleMicroTask)(function () {
          task.data.error = error;
          invokeTask(task);
        });
      });
      _patchUtils.globalState.fetchInProgress = false;
    });
  };
}