/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["watcher_bundle_jsonpfunction"]=window["watcher_bundle_jsonpfunction"]||[]).push([[2],{113:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"TimeBuckets",(function(){return TimeBuckets}));var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var external_kbnSharedDeps_Lodash_default=__webpack_require__.n(external_kbnSharedDeps_Lodash_);var external_kbnSharedDeps_Moment_=__webpack_require__(24);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var public_=__webpack_require__(31);const boundsDescending=[{bound:Infinity,interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"year"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"year")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"month"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(3,"week")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"week"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"week")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"d"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(24,"hour")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(12,"hour"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(6,"hour")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(3,"hour"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(2,"hour")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"hour"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(45,"minute")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(30,"minute"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(20,"minute")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(10,"minute"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(9,"minute")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(5,"minute"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(3,"minute")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"minute"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(45,"second")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(30,"second"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(15,"second")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(10,"second"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(7.5,"second")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(5,"second"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(5,"second")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(1,"second"))},{bound:Number(external_kbnSharedDeps_Moment_default.a.duration(500,"ms")),interval:Number(external_kbnSharedDeps_Moment_default.a.duration(100,"ms"))}];function getPerBucketMs(count,duration){const ms=duration/count;return isFinite(ms)?ms:NaN}function normalizeMinimumInterval(targetMs){const value=isNaN(targetMs)?0:Math.max(Math.floor(targetMs),1);return external_kbnSharedDeps_Moment_default.a.duration(value)}function calcAutoIntervalNear(targetBucketCount,duration){const targetPerBucketMs=getPerBucketMs(targetBucketCount,duration);const lowerBoundIndex=boundsDescending.findIndex(({bound:bound})=>{const boundMs=Number(bound);return boundMs<=targetPerBucketMs});if(lowerBoundIndex!==-1){const nearestInterval=boundsDescending[lowerBoundIndex-1].interval;return external_kbnSharedDeps_Moment_default.a.duration(nearestInterval)}return normalizeMinimumInterval(targetPerBucketMs)}function calcAutoIntervalLessThan(maxBucketCount,duration){const maxPerBucketMs=getPerBucketMs(maxBucketCount,duration);for(const{interval:interval}of boundsDescending){if(interval<=maxPerBucketMs){return external_kbnSharedDeps_Moment_default.a.duration(interval)}}return normalizeMinimumInterval(maxPerBucketMs)}var elastic_datemath=__webpack_require__(43);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);const unitsDesc=elastic_datemath_default.a.unitsDesc;const largeMax=unitsDesc.indexOf("M");function convertDurationToNormalizedEsInterval(duration){for(let i=0;i<unitsDesc.length;i++){const unit=unitsDesc[i];const val=duration.as(unit);if(val>=1&&Math.floor(val)===val){if(i<=largeMax&&val!==1){continue}return{value:val,unit:unit,expression:val+unit}}}const ms=duration.as("ms");return{value:ms,unit:"ms",expression:ms+"ms"}}function convertIntervalToEsInterval(interval){const{value:value,unit:unit}=undefined(interval);return{value:value,unit:unit,expression:interval}}const{parseInterval:parseInterval}=public_["search"].aggs;function isValidMoment(m){return m&&"isValid"in m&&m.isValid()}function TimeBuckets(uiSettings,data){this.data=data;this.getConfig=(...args)=>uiSettings.get(...args);return TimeBuckets.__cached__(this)}TimeBuckets.prototype.setBounds=function(input){if(!input)return this.clearBounds();let bounds;if(external_kbnSharedDeps_Lodash_default.a.isPlainObject(input)){bounds=[input.min,input.max]}else{bounds=Array.isArray(input)?input:[]}const moments=external_kbnSharedDeps_Lodash_default()(bounds).map(external_kbnSharedDeps_Lodash_default.a.ary(external_kbnSharedDeps_Moment_default.a,1)).sortBy(Number);const valid=moments.size()===2&&moments.every(isValidMoment);if(!valid){this.clearBounds();throw new Error("invalid bounds set: "+input)}this._lb=moments.shift();this._ub=moments.pop();if(this.getDuration().asSeconds()<0){throw new TypeError("Intervals must be positive")}};TimeBuckets.prototype.clearBounds=function(){this._lb=this._ub=null};TimeBuckets.prototype.hasBounds=function(){return isValidMoment(this._ub)&&isValidMoment(this._lb)};TimeBuckets.prototype.getBounds=function(){if(!this.hasBounds())return;return{min:this._lb,max:this._ub}};TimeBuckets.prototype.getDuration=function(){if(!this.hasBounds())return;return external_kbnSharedDeps_Moment_default.a.duration(this._ub-this._lb,"ms")};TimeBuckets.prototype.setInterval=function(input){this.originalInterval=input;let interval=input;if(external_kbnSharedDeps_Lodash_default.a.isObject(input)){interval=input.val}if(!interval||interval==="auto"){this._i="auto";return}if(external_kbnSharedDeps_Lodash_default.a.isString(interval)){input=interval;interval=parseInterval(interval);if(+interval===0){interval=null}}if(!external_kbnSharedDeps_Moment_default.a.isDuration(interval)){throw new TypeError('"'+input+'" is not a valid interval.')}this._i=interval};TimeBuckets.prototype.getInterval=function(useNormalizedEsInterval=true){const self=this;const duration=self.getDuration();const parsedInterval=readInterval();if(useNormalizedEsInterval){return decorateInterval(maybeScaleInterval(parsedInterval))}else{return decorateInterval(parsedInterval)}function readInterval(){const interval=self._i;if(external_kbnSharedDeps_Moment_default.a.isDuration(interval))return interval;return calcAutoIntervalNear(self.getConfig(public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET),Number(duration))}function maybeScaleInterval(interval){if(!self.hasBounds())return interval;const maxLength=self.getConfig(public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS);const approxLen=duration/interval;let scaled;if(approxLen>maxLength){scaled=calcAutoIntervalLessThan(maxLength,Number(duration))}else{return interval}if(+scaled===+interval)return interval;decorateInterval(interval);return external_kbnSharedDeps_Lodash_default.a.assign(scaled,{preScaled:interval,scale:interval/scaled,scaled:true})}function decorateInterval(interval){const esInterval=useNormalizedEsInterval?convertDurationToNormalizedEsInterval(interval):convertIntervalToEsInterval(self.originalInterval);interval.esValue=esInterval.value;interval.esUnit=esInterval.unit;interval.expression=esInterval.expression;interval.overflow=duration>interval?external_kbnSharedDeps_Moment_default.a.duration(interval-duration):false;const prettyUnits=external_kbnSharedDeps_Moment_default.a.normalizeUnits(esInterval.unit);if(esInterval.value===1){interval.description=prettyUnits}else{interval.description=esInterval.value+" "+prettyUnits+"s"}return interval}};TimeBuckets.prototype.getScaledDateFormat=function(){const interval=this.getInterval();const rules=this.getConfig("dateFormat:scaled");for(let i=rules.length-1;i>=0;i--){const rule=rules[i];if(!rule[0]||interval>=external_kbnSharedDeps_Moment_default.a.duration(rule[0])){return rule[1]}}return this.getConfig("dateFormat")};TimeBuckets.prototype.getScaledDateFormatter=function(){const fieldFormats=this.data.fieldFormats;const DateFieldFormat=fieldFormats.getType(public_["FIELD_FORMAT_IDS"].DATE);return new DateFieldFormat({pattern:this.getScaledDateFormat()},this.getConfig.bind(this))};TimeBuckets.__cached__=function(self){let cache={};const sameMoment=same(external_kbnSharedDeps_Moment_default.a.isMoment);const sameDuration=same(external_kbnSharedDeps_Moment_default.a.isDuration);const desc={__cached__:{value:self}};const breakers={setBounds:"bounds",clearBounds:"bounds",setInterval:"interval"};const resources={bounds:{setup:function(){return[self._lb,self._ub]},changes:function(prev){return!sameMoment(prev[0],self._lb)||!sameMoment(prev[1],self._ub)}},interval:{setup:function(){return self._i},changes:function(prev){return!sameDuration(prev,this._i)}}};function cachedGetter(prop){return{value:function cachedGetter(...rest){if(cache.hasOwnProperty(prop)){return cache[prop]}return cache[prop]=self[prop](...rest)}}}function cacheBreaker(prop){const resource=resources[breakers[prop]];const setup=resource.setup;const changes=resource.changes;const fn=self[prop];return{value:function cacheBreaker(){const prev=setup.call(self);const ret=fn.apply(self,arguments);if(changes.call(self,prev)){cache={}}return ret}}}function same(checkType){return function(a,b){if(a===b)return true;if(checkType(a)===checkType(b))return+a===+b;return false}}external_kbnSharedDeps_Lodash_default.a.forOwn(TimeBuckets.prototype,(function(fn,prop){if(prop[0]==="_")return;if(breakers.hasOwnProperty(prop)){desc[prop]=cacheBreaker(prop)}else{desc[prop]=cachedGetter(prop)}}));return Object.create(self,desc)}},43:function(module,exports,__webpack_require__){const moment=__webpack_require__(24);const unitsMap={ms:{weight:1,type:"fixed",base:1},s:{weight:2,type:"fixed",base:1e3},m:{weight:3,type:"mixed",base:1e3*60},h:{weight:4,type:"mixed",base:1e3*60*60},d:{weight:5,type:"mixed",base:1e3*60*60*24},w:{weight:6,type:"calendar",base:NaN},M:{weight:7,type:"calendar",base:NaN},y:{weight:9,type:"calendar",base:NaN}};const units=Object.keys(unitsMap).sort((a,b)=>unitsMap[b].weight-unitsMap[a].weight);const unitsDesc=[...units];const unitsAsc=[...units].reverse();const isDate=d=>Object.prototype.toString.call(d)==="[object Date]";const isValidDate=d=>isDate(d)&&!isNaN(d.valueOf());function parse(text,{roundUp:roundUp=false,momentInstance:momentInstance=moment,forceNow:forceNow}={}){if(!text)return undefined;if(momentInstance.isMoment(text))return text;if(isDate(text))return momentInstance(text);if(forceNow!==undefined&&!isValidDate(forceNow)){throw new Error("forceNow must be a valid Date")}let time;let mathString="";let index;let parseString;if(text.substring(0,3)==="now"){time=momentInstance(forceNow);mathString=text.substring("now".length)}else{index=text.indexOf("||");if(index===-1){parseString=text;mathString=""}else{parseString=text.substring(0,index);mathString=text.substring(index+2)}time=momentInstance(parseString)}if(!mathString.length){return time}return parseDateMath(mathString,time,roundUp)}function parseDateMath(mathString,time,roundUp){const dateTime=time;const len=mathString.length;let i=0;while(i<len){const c=mathString.charAt(i++);let type;let num;let unit;if(c==="/"){type=0}else if(c==="+"){type=1}else if(c==="-"){type=2}else{return}if(isNaN(mathString.charAt(i))){num=1}else if(mathString.length===2){num=mathString.charAt(i)}else{const numFrom=i;while(!isNaN(mathString.charAt(i))){i++;if(i>=len)return}num=parseInt(mathString.substring(numFrom,i),10)}if(type===0){if(num!==1){return}}unit=mathString.charAt(i++);for(let j=i;j<len;j++){const unitChar=mathString.charAt(i);if(/[a-z]/i.test(unitChar)){unit+=unitChar;i++}else{break}}if(units.indexOf(unit)===-1){return}else{if(type===0){if(roundUp)dateTime.endOf(unit);else dateTime.startOf(unit)}else if(type===1){dateTime.add(num,unit)}else if(type===2){dateTime.subtract(num,unit)}}}return dateTime}module.exports={parse:parse,unitsMap:Object.freeze(unitsMap),units:Object.freeze(units),unitsAsc:Object.freeze(unitsAsc),unitsDesc:Object.freeze(unitsDesc)}}}]);