/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["uptime_bundle_jsonpfunction"]=window["uptime_bundle_jsonpfunction"]||[]).push([[6],{306:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"default",(function(){return DurationAnomalyAlert}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(32);var state=__webpack_require__(83);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const AnomalyTranslations={criteriaAriaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.anomaly.criteriaExpression.ariaLabel",{defaultMessage:"An expression displaying the criteria for a selected monitor."}),whenMonitor:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.anomaly.criteriaExpression.description",{defaultMessage:"When monitor"}),scoreAriaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.anomaly.scoreExpression.ariaLabel",{defaultMessage:"An expression displaying the criteria for an anomaly alert threshold."}),hasAnomalyWithSeverity:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.anomaly.scoreExpression.description",{defaultMessage:"has anomaly with severity",description:"An expression displaying the criteria for an anomaly alert threshold."})};var alert_expression_popover=__webpack_require__(68);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);var public_=__webpack_require__(21);const warningLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.controls.selectSeverity.warningLabel",{defaultMessage:"warning"});const minorLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.controls.selectSeverity.minorLabel",{defaultMessage:"minor"});const majorLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.controls.selectSeverity.majorLabel",{defaultMessage:"major"});const criticalLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.controls.selectSeverity.criticalLabel",{defaultMessage:"critical"});const optionsMap={[warningLabel]:0,[minorLabel]:25,[majorLabel]:50,[criticalLabel]:75};const SEVERITY_OPTIONS=[{val:0,display:warningLabel,color:Object(public_["getSeverityColor"])(0)},{val:25,display:minorLabel,color:Object(public_["getSeverityColor"])(25)},{val:50,display:majorLabel,color:Object(public_["getSeverityColor"])(50)},{val:75,display:criticalLabel,color:Object(public_["getSeverityColor"])(75)}];function optionValueToThreshold(value){let threshold=SEVERITY_OPTIONS.find(opt=>opt.val===value);if(threshold===undefined){threshold=SEVERITY_OPTIONS[0]}return threshold}const DEFAULT_SEVERITY=SEVERITY_OPTIONS[3];const getSeverityOptions=()=>SEVERITY_OPTIONS.map(({color:color,display:display,val:val})=>({"data-test-subj":`alertAnomaly${display}`,value:display,inputDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:color,style:{lineHeight:"inherit"}},display)),dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:color,style:{lineHeight:"inherit"}},display),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",{className:"euiTextColor--subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.controls.selectSeverity.scoreDetailsDescription",defaultMessage:"score {value} and above",values:{value:val}}))))}));const SelectSeverity=({onChange:onChange,value:value})=>{const[severity,setSeverity]=Object(external_kbnSharedDeps_React_["useState"])(DEFAULT_SEVERITY);const onSeverityChange=valueDisplay=>{const option=optionValueToThreshold(optionsMap[valueDisplay]);setSeverity(option);onChange(option)};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setSeverity(value)},[value]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperSelect"],{hasDividers:true,style:{width:200},options:getSeverityOptions(),valueOfSelected:severity.display,onChange:onSeverityChange,"data-test-subj":"anomalySeveritySelect"})};var selectors=__webpack_require__(37);function AnomalyAlertComponent({setAlertParams:setAlertParams,alertParams:alertParams}){const[severity,setSeverity]=Object(external_kbnSharedDeps_React_["useState"])(DEFAULT_SEVERITY);const monitorIdStore=Object(lib["useSelector"])(selectors["q"]);const monitorId=monitorIdStore||(alertParams===null||alertParams===void 0?void 0:alertParams.monitorId);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setAlertParams("monitorId",monitorId)},[monitorId,setAlertParams]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setAlertParams("severity",severity.val)},[severity,setAlertParams]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(alertParams.severity!==undefined){setSeverity(SEVERITY_OPTIONS.find(({val:val})=>val===alertParams.severity))}},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiExpression"],{description:AnomalyTranslations.whenMonitor,value:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:"eui-displayInlineBlock"},external_kbnSharedDeps_React_default.a.createElement("h5",null,monitorId))})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":AnomalyTranslations.scoreAriaLabel,content:external_kbnSharedDeps_React_default.a.createElement(SelectSeverity,{"data-test-subj":"uptimeAnomalySeverityValue",value:severity,onChange:setSeverity}),"data-test-subj":"uptimeAnomalySeverity",description:AnomalyTranslations.hasAnomalyWithSeverity,id:"severity",value:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{style:{textTransform:"capitalize"},color:Object(public_["getSeverityColor"])(severity.val)},Object(public_["getSeverityType"])(severity.val)),isEnabled:true}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}))}var kibanaReact_public_=__webpack_require__(14);var kibana_service=__webpack_require__(51);function DurationAnomalyAlert({core:core,plugins:plugins,params:params}){kibana_service["a"].core=core;return external_kbnSharedDeps_React_default.a.createElement(lib["Provider"],{store:state["a"]},external_kbnSharedDeps_React_default.a.createElement(kibanaReact_public_["KibanaContextProvider"],{services:{...core,...plugins}},external_kbnSharedDeps_React_default.a.createElement(AnomalyAlertComponent,params)))}},68:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertExpressionPopover}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);const getColor=(isOpen,isEnabled,isInvalid)=>{if(isInvalid===true)return"danger";if(isEnabled===false)return"subdued";return isOpen?"primary":"secondary"};const AlertExpressionPopover=({"aria-label":ariaLabel,content:content,"data-test-subj":dataTestSubj,description:description,isEnabled:isEnabled,isInvalid:isInvalid,id:id,value:value})=>{const[isOpen,setIsOpen]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiPopover"],{id:id,anchorPosition:"downLeft",button:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiExpression"],{"aria-label":ariaLabel,color:getColor(isOpen,isEnabled,isInvalid),"data-test-subj":dataTestSubj,description:description,isActive:isOpen,onClick:isEnabled?()=>setIsOpen(!isOpen):undefined,value:value}),isOpen:isOpen,closePopover:()=>setIsOpen(false)},content)}}}]);