/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["uptime_bundle_jsonpfunction"]=window["uptime_bundle_jsonpfunction"]||[]).push([[5],{286:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(19);var react_1=__webpack_require__(1);var useRafState_1=tslib_1.__importDefault(__webpack_require__(287));var util_1=__webpack_require__(290);var useWindowSize=function(initialWidth,initialHeight){if(initialWidth===void 0){initialWidth=Infinity}if(initialHeight===void 0){initialHeight=Infinity}var _a=useRafState_1.default({width:util_1.isClient?window.innerWidth:initialWidth,height:util_1.isClient?window.innerHeight:initialHeight}),state=_a[0],setState=_a[1];react_1.useEffect((function(){if(util_1.isClient){var handler_1=function(){setState({width:window.innerWidth,height:window.innerHeight})};window.addEventListener("resize",handler_1);return function(){window.removeEventListener("resize",handler_1)}}}),[]);return state};exports.default=useWindowSize},287:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(19);var react_1=__webpack_require__(1);var useUnmount_1=tslib_1.__importDefault(__webpack_require__(288));var useRafState=function(initialState){var frame=react_1.useRef(0);var _a=react_1.useState(initialState),state=_a[0],setState=_a[1];var setRafState=react_1.useCallback((function(value){cancelAnimationFrame(frame.current);frame.current=requestAnimationFrame((function(){setState(value)}))}),[]);useUnmount_1.default((function(){cancelAnimationFrame(frame.current)}));return[state,setRafState]};exports.default=useRafState},288:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(19);var react_1=__webpack_require__(1);var useEffectOnce_1=tslib_1.__importDefault(__webpack_require__(289));var useUnmount=function(fn){var fnRef=react_1.useRef(fn);fnRef.current=fn;useEffectOnce_1.default((function(){return function(){return fnRef.current()}}))};exports.default=useUnmount},289:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(1);var useEffectOnce=function(effect){react_1.useEffect(effect,[])};exports.default=useEffectOnce},290:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isDeepEqual=exports.off=exports.on=exports.isClient=void 0;var tslib_1=__webpack_require__(19);var react_1=tslib_1.__importDefault(__webpack_require__(291));exports.isClient=typeof window==="object";exports.on=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.addEventListener.apply(obj,args)};exports.off=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.removeEventListener.apply(obj,args)};exports.isDeepEqual=react_1.default},291:function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(key==="_owner"&&a.$$typeof){continue}if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},292:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(19);var react_1=__webpack_require__(1);var useTimeoutFn_1=tslib_1.__importDefault(__webpack_require__(293));function useDebounce(fn,ms,deps){if(ms===void 0){ms=0}if(deps===void 0){deps=[]}var _a=useTimeoutFn_1.default(fn,ms),isReady=_a[0],cancel=_a[1],reset=_a[2];react_1.useEffect(reset,deps);return[isReady,cancel]}exports.default=useDebounce},293:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(1);function useTimeoutFn(fn,ms){if(ms===void 0){ms=0}var ready=react_1.useRef(false);var timeout=react_1.useRef();var callback=react_1.useRef(fn);var isReady=react_1.useCallback((function(){return ready.current}),[]);var set=react_1.useCallback((function(){ready.current=false;timeout.current&&clearTimeout(timeout.current);timeout.current=setTimeout((function(){ready.current=true;callback.current()}),ms)}),[ms]);var clear=react_1.useCallback((function(){ready.current=null;timeout.current&&clearTimeout(timeout.current)}),[]);react_1.useEffect((function(){callback.current=fn}),[fn]);react_1.useEffect((function(){set();return clear}),[ms]);return[isReady,clear,set]}exports.default=useTimeoutFn},304:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(20);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const getIntegratedAppAvailability=(capabilities,integratedApps)=>integratedApps.reduce((supportedSolutions,solutionName)=>{supportedSolutions[solutionName]=capabilities[solutionName]&&capabilities[solutionName].show===true;return supportedSolutions},{});var constants=__webpack_require__(34);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var lib=__webpack_require__(32);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);var public_=__webpack_require__(14);var contexts=__webpack_require__(36);var actions=__webpack_require__(33);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var hooks=__webpack_require__(35);var stringify_url_params=__webpack_require__(77);var constants_plugin=__webpack_require__(3);const EMPTY_QUERY="?";function handleBreadcrumbClick(breadcrumbs,navigateToHref){return breadcrumbs.map(bc=>({...bc,...bc.href?{onClick:event=>{if(navigateToHref&&bc.href){event.preventDefault();navigateToHref(bc.href)}}}:{}}))}const makeBaseBreadcrumb=(href,params)=>{if(params){const crumbParams={...params};delete crumbParams.statusFilter;const query=Object(stringify_url_params["a"])(crumbParams,true);href+=query===EMPTY_QUERY?"":query}return{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.breadcrumbs.overviewBreadcrumbText",{defaultMessage:"Uptime"}),href:href}};const useBreadcrumbs=extraCrumbs=>{var _kibana$services$chro,_kibana$services$appl,_kibana$services$appl2,_kibana$services$appl3;const params=Object(hooks["h"])()[0]();const kibana=Object(public_["useKibana"])();const setBreadcrumbs=(_kibana$services$chro=kibana.services.chrome)===null||_kibana$services$chro===void 0?void 0:_kibana$services$chro.setBreadcrumbs;const appPath=(_kibana$services$appl=(_kibana$services$appl2=kibana.services.application)===null||_kibana$services$appl2===void 0?void 0:_kibana$services$appl2.getUrlForApp(constants_plugin["a"].ID))!==null&&_kibana$services$appl!==void 0?_kibana$services$appl:"";const navigate=(_kibana$services$appl3=kibana.services.application)===null||_kibana$services$appl3===void 0?void 0:_kibana$services$appl3.navigateToUrl;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(setBreadcrumbs){setBreadcrumbs(handleBreadcrumbClick([makeBaseBreadcrumb(appPath,params)].concat(extraCrumbs),navigate))}},[appPath,extraCrumbs,navigate,params,setBreadcrumbs])};var observability_public_=__webpack_require__(16);var selectors=__webpack_require__(37);var monitor_list=__webpack_require__(114);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const DEFAULT_PAGE_SIZE=10;const LOCAL_STORAGE_KEY="xpack.uptime.monitorList.pageSize";const getPageSizeValue=()=>{var _localStorage$getItem;const value=parseInt((_localStorage$getItem=localStorage.getItem(LOCAL_STORAGE_KEY))!==null&&_localStorage$getItem!==void 0?_localStorage$getItem:"",10);if(isNaN(value)){return DEFAULT_PAGE_SIZE}return value};const MonitorList=props=>{const{filters:filters}=props;const[pageSize,setPageSize]=Object(external_kbnSharedDeps_React_["useState"])(getPageSizeValue);const dispatch=Object(lib["useDispatch"])();const[getUrlValues]=Object(hooks["h"])();const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,pagination:pagination,statusFilter:statusFilter}=getUrlValues();const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const monitorList=Object(lib["useSelector"])(selectors["r"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(actions["p"])({dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,filters:filters,pageSize:pageSize,pagination:pagination,statusFilter:statusFilter}))},[dispatch,dateRangeStart,dateRangeEnd,filters,lastRefresh,pageSize,pagination,statusFilter]);return external_kbnSharedDeps_React_default.a.createElement(monitor_list["a"],_extends({},props,{monitorList:monitorList,pageSize:pageSize,setPageSize:setPageSize}))};var overview=__webpack_require__(172);var monitor=__webpack_require__(82);var snapshot_container=__webpack_require__(107);const STATUS_CHART_HEIGHT="160px";const StatusPanel=({})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"l"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2},external_kbnSharedDeps_React_default.a.createElement(snapshot_container["a"],{height:STATUS_CHART_HEIGHT})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:10},external_kbnSharedDeps_React_default.a.createElement(monitor["d"],{height:STATUS_CHART_HEIGHT,isResponsive:true}))));var alerts=__webpack_require__(46);const useInitApp=()=>{const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(alerts["j"].get())},[dispatch])};const EuiFlexItemStyled=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"EuiFlexItemStyled",componentId:"sc-1532t7e-0"})(["&&{min-width:598px;@media only screen and (max-width:1128px){min-width:500px;}@media only screen and (max-width:630px){min-width:initial;}}"]);const OverviewPageComponent=external_kbnSharedDeps_React_default.a.memo(({indexPattern:indexPattern,setEsKueryFilters:setEsKueryFilters,loading:loading})=>{const{absoluteDateRangeStart:absoluteDateRangeStart,absoluteDateRangeEnd:absoluteDateRangeEnd,...params}=Object(hooks["c"])();const{search:search,filters:urlFilters}=params;Object(observability_public_["useTrackPageview"])({app:"uptime",path:"overview"});Object(observability_public_["useTrackPageview"])({app:"uptime",path:"overview",delay:15e3});useInitApp();const[esFilters,error]=Object(hooks["f"])(indexPattern,search,urlFilters);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setEsKueryFilters(esFilters!==null&&esFilters!==void 0?esFilters:"")},[esFilters,setEsKueryFilters]);const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(alerts["j"].get());dispatch(alerts["k"].get())},[dispatch]);useBreadcrumbs([]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(overview["a"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",wrap:true,responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1,style:{flexBasis:485}},external_kbnSharedDeps_React_default.a.createElement(overview["c"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.filterBar.ariaLabel",{defaultMessage:"Input filter criteria for the overview page"}),"data-test-subj":"xpack.uptime.filterBar"})),external_kbnSharedDeps_React_default.a.createElement(EuiFlexItemStyled,{grow:true},external_kbnSharedDeps_React_default.a.createElement(overview["b"],{esFilters:esFilters})),error&&!loading&&external_kbnSharedDeps_React_default.a.createElement(overview["d"],{error:error})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(StatusPanel,null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(MonitorList,{filters:esFilters})))});function overview_container_extends(){overview_container_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return overview_container_extends.apply(this,arguments)}const OverviewPage=props=>{const dispatch=Object(lib["useDispatch"])();const setEsKueryFilters=Object(external_kbnSharedDeps_React_["useCallback"])(esFilters=>dispatch(Object(actions["J"])(esFilters)),[dispatch]);const{index_pattern:indexPattern,loading:loading}=Object(lib["useSelector"])(selectors["B"]);return external_kbnSharedDeps_React_default.a.createElement(OverviewPageComponent,overview_container_extends({setEsKueryFilters:setEsKueryFilters,indexPattern:indexPattern,loading:loading},props))};const isUptimeDefaultDateRange=(dateRangeStart,dateRangeEnd)=>{const{DATE_RANGE_START:DATE_RANGE_START,DATE_RANGE_END:DATE_RANGE_END}=constants["e"];return dateRangeStart===DATE_RANGE_START&&dateRangeEnd===DATE_RANGE_END};const UptimeDatePicker=()=>{const[getUrlParams,updateUrl]=Object(hooks["h"])();const{commonlyUsedRanges:commonlyUsedRanges}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const{refreshApp:refreshApp}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{data:data}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["e"]);const sharedTimeState=data===null||data===void 0?void 0:data.query.timefilter.timefilter.getTime();const{autorefreshInterval:autorefreshInterval,autorefreshIsPaused:autorefreshIsPaused,dateRangeStart:start,dateRangeEnd:end}=getUrlParams();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const{from:from,to:to}=sharedTimeState!==null&&sharedTimeState!==void 0?sharedTimeState:{};if(isUptimeDefaultDateRange(start,end)&&(from!==start||to!==end)){updateUrl({dateRangeStart:from,dateRangeEnd:to})}else if(from!==start||to!==end){data===null||data===void 0?void 0:data.query.timefilter.timefilter.setTime({from:start,to:end})}},[]);const euiCommonlyUsedRanges=commonlyUsedRanges?commonlyUsedRanges.map(({from:from,to:to,display:display})=>({start:from,end:to,label:display})):constants["e"].COMMONLY_USED_DATE_RANGES;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{start:start,end:end,commonlyUsedRanges:euiCommonlyUsedRanges,isPaused:autorefreshIsPaused,refreshInterval:autorefreshInterval,onTimeChange:({start:startN,end:endN})=>{var _data$query,_data$query$timefilte;if(data!==null&&data!==void 0&&(_data$query=data.query)!==null&&_data$query!==void 0&&(_data$query$timefilte=_data$query.timefilter)!==null&&_data$query$timefilte!==void 0&&_data$query$timefilte.timefilter){data===null||data===void 0?void 0:data.query.timefilter.timefilter.setTime({from:startN,to:endN})}updateUrl({dateRangeStart:startN,dateRangeEnd:endN});refreshApp()},onRefresh:refreshApp,onRefreshChange:({isPaused:isPaused,refreshInterval:refreshInterval})=>{updateUrl({autorefreshInterval:refreshInterval===undefined?autorefreshInterval:refreshInterval,autorefreshIsPaused:isPaused})}})};var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);const SYNTHETICS_CALLOUT_LS_KEY="xpack.uptime.syntheticsCallout.display";const shouldShowSyntheticsCallout=()=>{let value=localStorage.getItem(SYNTHETICS_CALLOUT_LS_KEY);if(value===null){localStorage.setItem(SYNTHETICS_CALLOUT_LS_KEY,"true");value="true"}return value==="true"};const hideSyntheticsCallout=()=>localStorage.setItem(SYNTHETICS_CALLOUT_LS_KEY,"false");const SyntheticsCallout=()=>{const[shouldShow,setShouldShow]=Object(external_kbnSharedDeps_React_["useState"])(shouldShowSyntheticsCallout());if(!shouldShow){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overview.pageHeader.syntheticsCallout.title",{defaultMessage:"Elastic Synthetics"}),iconType:"beaker"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.overview.pageHeader.syntheticsCallout.content",defaultMessage:"Uptime is now previewing support for scripted multi-step availability checks. This means you can interact with elements of a webpage and check the availability of an entire journey (such as making a purchase or signing into a system) instead of just a simple single page up/down check. Please click below to read more and, if you'd like to be one of the first to use these capabilities, you can download our preview synthetics agent and view your synthetic checks in Uptime."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{href:"https://www.elastic.co/what-is/synthetic-monitoring"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.overview.pageHeader.syntheticsCallout.announcementLink",defaultMessage:"Read announcement"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>{if(shouldShow){hideSyntheticsCallout();setShouldShow(false)}}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.overview.pageHeader.syntheticsCallout.dismissButtonText",defaultMessage:"Dismiss"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}))};const tabs=[{id:constants["o"],name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overviewPage.headerText",{defaultMessage:"Overview",description:`The text that will be displayed in the app's heading when the Overview page loads.`}),dataTestSubj:"uptimeSettingsToOverviewLink"},{id:constants["b"],name:"Certificates",dataTestSubj:"uptimeCertificatesLink"},{id:constants["p"],dataTestSubj:"settings-page-link",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.page_header.settingsLink",{defaultMessage:"Settings"})}];const PageTabs=()=>{const[selectedTabId,setSelectedTabId]=Object(external_kbnSharedDeps_React_["useState"])(null);const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const params=Object(hooks["c"])();const isOverView=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])(constants["o"]);const isSettings=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])(constants["p"]);const isCerts=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])(constants["b"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isOverView!==null&&isOverView!==void 0&&isOverView.isExact){setSelectedTabId(constants["o"])}if(isCerts){setSelectedTabId(constants["b"])}if(isSettings){setSelectedTabId(constants["p"])}if(!(isOverView!==null&&isOverView!==void 0&&isOverView.isExact)&&!isCerts&&!isSettings){setSelectedTabId(null)}},[isCerts,isSettings,isOverView]);const createHrefForTab=id=>{if(selectedTabId===constants["o"]&&id===constants["o"]){return history.createHref({pathname:id})}return history.createHref({pathname:id,search:Object(stringify_url_params["a"])(params,true)})};const renderTabs=()=>tabs.map(({dataTestSubj:dataTestSubj,name:name,id:id},index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:()=>setSelectedTabId(id),isSelected:id===selectedTabId,key:index,"data-test-subj":dataTestSubj,href:createHrefForTab(id)},name));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],{display:"condensed",style:{paddingLeft:16},"data-test-subj":"uptimeTabs"},renderTabs())};const REFRESH_CERT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.certificates.refresh",{defaultMessage:"Refresh"});const settings={breadcrumbText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.settingsBreadcrumbText",{defaultMessage:"Settings"}),editNoticeTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.settings.cannotEditTitle",{defaultMessage:"You do not have permission to edit settings."}),editNoticeText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.settings.cannotEditText",{defaultMessage:"Your user currently has 'Read' permissions for the Uptime app. Enable a permissions-level of 'All' to edit these settings."}),mustBeNumber:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.settings.blankNumberField.error",{defaultMessage:"Must be a number."})};const BLANK_STR=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.settings.blank.error",{defaultMessage:"May not be blank."});const CertRefreshBtn=()=>{const{refreshApp:refreshApp}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{alignItems:"flex-end"},grow:false,"data-test-subj":"certificatesRefreshButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHideFor"],{sizes:["xs"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"refresh",onClick:()=>{refreshApp()},"data-test-subj":"superDatePickerApplyTimeButton"},REFRESH_CERT)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiShowFor"],{sizes:["xs"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"refresh",onClick:()=>{refreshApp()},"data-test-subj":"superDatePickerApplyTimeButton"})))))};var alerts_containers=__webpack_require__(85);var enable_alert=__webpack_require__(178);const isAutogeneratedId=id=>{const autoGeneratedId=/^auto-(icmp|http|tcp|browser)-0X[A-F0-9]{16}.*/;return autoGeneratedId.test(id)};const getPageTitle=(monitorId,selectedMonitor)=>{if(isAutogeneratedId(monitorId)){var _selectedMonitor$url;return(selectedMonitor===null||selectedMonitor===void 0?void 0:(_selectedMonitor$url=selectedMonitor.url)===null||_selectedMonitor$url===void 0?void 0:_selectedMonitor$url.full)||monitorId}return monitorId};const MonitorPageTitle=()=>{var _selectedMonitor$moni,_selectedMonitor$moni2,_selectedMonitor$url2;const monitorId=Object(hooks["d"])();const selectedMonitor=Object(lib["useSelector"])(selectors["t"]);const nameOrId=(selectedMonitor===null||selectedMonitor===void 0?void 0:(_selectedMonitor$moni=selectedMonitor.monitor)===null||_selectedMonitor$moni===void 0?void 0:_selectedMonitor$moni.name)||getPageTitle(monitorId,selectedMonitor);useBreadcrumbs([{text:nameOrId}]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{wrap:false,"data-test-subj":"monitorTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{className:"eui-textNoWrap"},nameOrId)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{justifyContent:"center"}},external_kbnSharedDeps_React_default.a.createElement(enable_alert["a"],{monitorId:monitorId,monitorName:(selectedMonitor===null||selectedMonitor===void 0?void 0:(_selectedMonitor$moni2=selectedMonitor.monitor)===null||_selectedMonitor$moni2===void 0?void 0:_selectedMonitor$moni2.name)||(selectedMonitor===null||selectedMonitor===void 0?void 0:(_selectedMonitor$url2=selectedMonitor.url)===null||_selectedMonitor$url2===void 0?void 0:_selectedMonitor$url2.full)})))};const StyledPicker=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"StyledPicker",componentId:"sc-1hbgv3t-0"})(["&&&{@media only screen and (max-width:1024px) and (min-width:868px){.euiSuperDatePicker__flexWrapper{width:500px;}}@media only screen and (max-width:880px){flex-grow:1;.euiSuperDatePicker__flexWrapper{width:calc(100% + 8px);}}}"]);const PageHeader=({showCertificateRefreshBtn:showCertificateRefreshBtn=false,showDatePicker:showDatePicker=false,showMonitorTitle:showMonitorTitle=false,showTabs:showTabs=false})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(SyntheticsCallout,null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"spaceBetween",wrap:true,responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,showMonitorTitle&&external_kbnSharedDeps_React_default.a.createElement(MonitorPageTitle,null),showTabs&&external_kbnSharedDeps_React_default.a.createElement(PageTabs,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(alerts_containers["b"],null)),showCertificateRefreshBtn&&external_kbnSharedDeps_React_default.a.createElement(CertRefreshBtn,null),showDatePicker&&external_kbnSharedDeps_React_default.a.createElement(StyledPicker,{grow:false,style:{flexBasis:485}},external_kbnSharedDeps_React_default.a.createElement(UptimeDatePicker,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}));var dynamic_settings=__webpack_require__(55);const MonitorPage=()=>{const dispatch=Object(lib["useDispatch"])();useInitApp();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(dynamic_settings["a"])())},[dispatch]);const monitorId=Object(hooks["d"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(actions["M"])(monitorId));dispatch(alerts["k"].get())},[monitorId,dispatch]);Object(observability_public_["useTrackPageview"])({app:"uptime",path:"monitor"});Object(observability_public_["useTrackPageview"])({app:"uptime",path:"monitor",delay:15e3});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(monitor["c"],{monitorId:monitorId}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(monitor["b"],{monitorId:monitorId}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(monitor["e"],null))};var actions_journey=__webpack_require__(57);var external_kbnSharedDeps_Moment_=__webpack_require__(13);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var network_events=__webpack_require__(112);let Timings;(function(Timings){Timings["Blocked"]="blocked";Timings["Dns"]="dns";Timings["Connect"]="connect";Timings["Ssl"]="ssl";Timings["Send"]="send";Timings["Wait"]="wait";Timings["Receive"]="receive"})(Timings||(Timings={}));let Metadata;(function(Metadata){Metadata["BytesDownloadedCompressed"]="bytesDownloadedCompressed";Metadata["CertificateIssuer"]="certificateIssuer";Metadata["CertificateIssueDate"]="certificateIssueDate";Metadata["CertificateExpiryDate"]="certificateExpiryDate";Metadata["CertificateSubject"]="certificateSubject";Metadata["IP"]="ip";Metadata["MimeType"]="mimeType";Metadata["RequestStart"]="requestStart"})(Metadata||(Metadata={}));const FriendlyTimingLabels={[Timings.Blocked]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.blocked",{defaultMessage:"Queued / Blocked"}),[Timings.Dns]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.dns",{defaultMessage:"DNS"}),[Timings.Connect]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.connect",{defaultMessage:"Connecting"}),[Timings.Ssl]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.ssl",{defaultMessage:"TLS"}),[Timings.Send]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.send",{defaultMessage:"Sending request"}),[Timings.Wait]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.wait",{defaultMessage:"Waiting (TTFB)"}),[Timings.Receive]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.timings.receive",{defaultMessage:"Content downloading"})};const FriendlyFlyoutLabels={[Metadata.MimeType]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.contentType",{defaultMessage:"Content type"}),[Metadata.RequestStart]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.requestStart",{defaultMessage:"Request start"}),[Metadata.BytesDownloadedCompressed]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.bytesDownloadedCompressed",{defaultMessage:"Bytes downloaded (compressed)"}),[Metadata.CertificateIssuer]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.certificateIssuer",{defaultMessage:"Issuer"}),[Metadata.CertificateIssueDate]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.certificateIssueDate",{defaultMessage:"Valid from"}),[Metadata.CertificateExpiryDate]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.certificateExpiryDate",{defaultMessage:"Valid until"}),[Metadata.CertificateSubject]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.certificateSubject",{defaultMessage:"Common name"}),[Metadata.IP]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.metadata.ip",{defaultMessage:"IP"})};const TIMING_ORDER=[Timings.Blocked,Timings.Dns,Timings.Connect,Timings.Ssl,Timings.Send,Timings.Wait,Timings.Receive];const META_DATA_ORDER_FLYOUT=[Metadata.MimeType,Timings.Dns,Timings.Connect,Timings.Ssl,Timings.Wait,Timings.Receive];let MimeType;(function(MimeType){MimeType["Html"]="html";MimeType["Script"]="script";MimeType["Stylesheet"]="stylesheet";MimeType["Media"]="media";MimeType["Font"]="font";MimeType["XHR"]="xhr";MimeType["Other"]="other"})(MimeType||(MimeType={}));const FriendlyMimetypeLabels={[MimeType.Html]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.html",{defaultMessage:"HTML"}),[MimeType.Script]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.script",{defaultMessage:"JS"}),[MimeType.Stylesheet]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.stylesheet",{defaultMessage:"CSS"}),[MimeType.Media]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.media",{defaultMessage:"Media"}),[MimeType.Font]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.font",{defaultMessage:"Font"}),[MimeType.XHR]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.xhr",{defaultMessage:"XHR"}),[MimeType.Other]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfallChart.labels.mimeTypes.other",{defaultMessage:"Other"})};const MimeTypesMap={"text/html":MimeType.Html,"application/javascript":MimeType.Script,"text/javascript":MimeType.Script,"text/css":MimeType.Stylesheet,"image/apng":MimeType.Media,"image/bmp":MimeType.Media,"image/gif":MimeType.Media,"image/x-icon":MimeType.Media,"image/jpeg":MimeType.Media,"image/png":MimeType.Media,"image/svg+xml":MimeType.Media,"image/tiff":MimeType.Media,"image/webp":MimeType.Media,"audio/wave":MimeType.Media,"audio/wav":MimeType.Media,"audio/x-wav":MimeType.Media,"audio/x-pn-wav":MimeType.Media,"audio/webm":MimeType.Media,"video/webm":MimeType.Media,"video/mp4":MimeType.Media,"audio/ogg":MimeType.Media,"video/ogg":MimeType.Media,"application/ogg":MimeType.Media,"font/otf":MimeType.Font,"font/ttf":MimeType.Font,"font/woff":MimeType.Font,"font/woff2":MimeType.Font,"application/x-font-opentype":MimeType.Font,"application/font-woff":MimeType.Font,"application/font-woff2":MimeType.Font,"application/vnd.ms-fontobject":MimeType.Font,"application/font-sfnt":MimeType.Font,"application/json":MimeType.XHR};const extractItems=data=>data.sort((a,b)=>a.requestSentTime-b.requestSentTime);const formatValueForDisplay=(value,points=3)=>Number(value).toFixed(points);const getColourForMimeType=mimeType=>{const key=mimeType&&MimeTypesMap[mimeType]?MimeTypesMap[mimeType]:MimeType.Other;return colourPalette[key]};const getFriendlyTooltipValue=({value:value,timing:timing,mimeType:mimeType})=>{let label=FriendlyTimingLabels[timing];if(timing===Timings.Receive&&mimeType){const formattedMimeType=MimeTypesMap[mimeType];label+=` (${FriendlyMimetypeLabels[formattedMimeType]||mimeType})`}return`${label}: ${formatValueForDisplay(value)}ms`};const isHighlightedItem=(item,query,activeFilters=[])=>{var _item$url;if(!query&&(activeFilters===null||activeFilters===void 0?void 0:activeFilters.length)===0){return true}const matchQuery=query?(_item$url=item.url)===null||_item$url===void 0?void 0:_item$url.includes(query):true;const matchFilters=activeFilters.length>0?activeFilters.includes(MimeTypesMap[item.mimeType]):true;return!!(matchQuery&&matchFilters)};const getFriendlyMetadataValue=({value:value,postFix:postFix})=>{if(value===undefined||value===-1){return undefined}let formattedValue=formatValueForDisplay(value);if(postFix){formattedValue=`${formattedValue} ${postFix}`}return formattedValue};const getConnectingTime=(connect,ssl)=>{if(ssl&&connect&&ssl>0){return connect-ssl}else{return connect}};const getSeriesAndDomain=(items,onlyHighlighted=false,query,activeFilters)=>{const getValueForOffset=item=>item.requestSentTime;let zeroOffset=Infinity;items.forEach(i=>zeroOffset=Math.min(zeroOffset,getValueForOffset(i)));const getValue=(timings,timing)=>{if(!timings)return;if(timing===Timings.Connect){return getConnectingTime(timings.connect,timings.ssl)}return timings[timing]};const series=[];const metadata=[];let totalHighlightedRequests=0;items.forEach((item,index)=>{const mimeTypeColour=getColourForMimeType(item.mimeType);const offsetValue=getValueForOffset(item);let currentOffset=offsetValue-zeroOffset;metadata.push(formatMetadata({item:item,index:index,requestStart:currentOffset}));const isHighlighted=isHighlightedItem(item,query,activeFilters);if(isHighlighted){totalHighlightedRequests++}if(!item.timings){series.push({x:index,y0:0,y:0,config:{isHighlighted:isHighlighted,showTooltip:false}});return}let timingValueFound=false;TIMING_ORDER.forEach(timing=>{const value=getValue(item.timings,timing);if(value&&value>=0){timingValueFound=true;const colour=timing===Timings.Receive?mimeTypeColour:colourPalette[timing];const y=currentOffset+value;series.push({x:index,y0:currentOffset,y:y,config:{id:index,colour:colour,isHighlighted:isHighlighted,showTooltip:true,tooltipProps:{value:getFriendlyTooltipValue({value:y-currentOffset,timing:timing,mimeType:item.mimeType}),colour:colour}}});currentOffset=y}});if(!timingValueFound){const total=item.timings.total;const hasTotal=total!==-1;series.push({x:index,y0:hasTotal?currentOffset:0,y:hasTotal?currentOffset+item.timings.total:0,config:{isHighlighted:isHighlighted,colour:hasTotal?mimeTypeColour:"",showTooltip:hasTotal,tooltipProps:hasTotal?{value:getFriendlyTooltipValue({value:total,timing:Timings.Receive,mimeType:item.mimeType}),colour:mimeTypeColour}:undefined}})}});const yValues=series.map(serie=>serie.y);const domain={min:0,max:Math.max(...yValues)};let filteredSeries=series;if(onlyHighlighted){filteredSeries=series.filter(item=>item.config.isHighlighted)}return{series:filteredSeries,domain:domain,metadata:metadata,totalHighlightedRequests:totalHighlightedRequests}};const formatHeaders=headers=>{if(typeof headers==="undefined"){return undefined}return Object.keys(headers).map(key=>({name:key,value:`${headers[key]}`}))};const formatMetadata=({item:item,index:index,requestStart:requestStart})=>{const{bytesDownloadedCompressed:bytesDownloadedCompressed,certificates:certificates,ip:ip,mimeType:mimeType,requestHeaders:requestHeaders,responseHeaders:responseHeaders,url:url}=item;const{dns:dns,connect:connect,ssl:ssl,wait:wait,receive:receive,total:total}=item.timings||{};const contentDownloaded=receive&&receive>0?receive:total;return{x:index,url:url,requestHeaders:formatHeaders(requestHeaders),responseHeaders:formatHeaders(responseHeaders),certificates:certificates?[{name:FriendlyFlyoutLabels[Metadata.CertificateIssuer],value:certificates.issuer},{name:FriendlyFlyoutLabels[Metadata.CertificateIssueDate],value:certificates.validFrom?external_kbnSharedDeps_Moment_default()(certificates.validFrom).format("L LT"):undefined},{name:FriendlyFlyoutLabels[Metadata.CertificateExpiryDate],value:certificates.validTo?external_kbnSharedDeps_Moment_default()(certificates.validTo).format("L LT"):undefined},{name:FriendlyFlyoutLabels[Metadata.CertificateSubject],value:certificates.subjectName}]:undefined,details:[{name:FriendlyFlyoutLabels[Metadata.MimeType],value:mimeType},{name:FriendlyFlyoutLabels[Metadata.RequestStart],value:getFriendlyMetadataValue({value:requestStart,postFix:"ms"})},{name:FriendlyTimingLabels[Timings.Dns],value:getFriendlyMetadataValue({value:dns,postFix:"ms"})},{name:FriendlyTimingLabels[Timings.Connect],value:getFriendlyMetadataValue({value:getConnectingTime(connect,ssl),postFix:"ms"})},{name:FriendlyTimingLabels[Timings.Ssl],value:getFriendlyMetadataValue({value:ssl,postFix:"ms"})},{name:FriendlyTimingLabels[Timings.Wait],value:getFriendlyMetadataValue({value:wait,postFix:"ms"})},{name:FriendlyTimingLabels[Timings.Receive],value:getFriendlyMetadataValue({value:contentDownloaded,postFix:"ms"})},{name:FriendlyFlyoutLabels[Metadata.BytesDownloadedCompressed],value:getFriendlyMetadataValue({value:bytesDownloadedCompressed?bytesDownloadedCompressed/1e3:undefined,postFix:"KB"})},{name:FriendlyFlyoutLabels[Metadata.IP],value:ip}]}};const getSidebarItems=(items,onlyHighlighted,query,activeFilters)=>{const sideBarItems=items.map((item,index)=>{const isHighlighted=isHighlightedItem(item,query,activeFilters);const offsetIndex=index+1;const{url:url,status:status,method:method}=item;return{url:url,status:status,method:method,isHighlighted:isHighlighted,offsetIndex:offsetIndex,index:index}});if(onlyHighlighted){return sideBarItems.filter(item=>item.isHighlighted)}return sideBarItems};const getLegendItems=()=>{let timingItems=[];Object.values(Timings).forEach(timing=>{if(timing===Timings.Receive){return}timingItems=[...timingItems,{name:FriendlyTimingLabels[timing],colour:TIMING_PALETTE[timing]}]});let mimeTypeItems=[];Object.values(MimeType).forEach(mimeType=>{mimeTypeItems=[...mimeTypeItems,{name:FriendlyMimetypeLabels[mimeType],colour:MIME_TYPE_PALETTE[mimeType]}]});return[...timingItems,...mimeTypeItems]};const SAFE_PALETTE=Object(external_kbnSharedDeps_ElasticEui_["euiPaletteColorBlind"])({rotations:2});const buildTimingPalette=()=>{const palette=Object.values(Timings).reduce((acc,value)=>{switch(value){case Timings.Blocked:acc[value]=SAFE_PALETTE[16];break;case Timings.Dns:acc[value]=SAFE_PALETTE[0];break;case Timings.Connect:acc[value]=SAFE_PALETTE[7];break;case Timings.Ssl:acc[value]=SAFE_PALETTE[17];break;case Timings.Send:acc[value]=SAFE_PALETTE[2];break;case Timings.Wait:acc[value]=SAFE_PALETTE[11];break;case Timings.Receive:acc[value]=SAFE_PALETTE[0];break}return acc},{});return palette};const TIMING_PALETTE=buildTimingPalette();const buildMimeTypePalette=()=>{const palette=Object.values(MimeType).reduce((acc,value)=>{switch(value){case MimeType.Html:acc[value]=SAFE_PALETTE[19];break;case MimeType.Script:acc[value]=SAFE_PALETTE[3];break;case MimeType.Stylesheet:acc[value]=SAFE_PALETTE[4];break;case MimeType.Media:acc[value]=SAFE_PALETTE[5];break;case MimeType.Font:acc[value]=SAFE_PALETTE[8];break;case MimeType.Other:acc[value]=SAFE_PALETTE[9];break}return acc},{});return palette};const MIME_TYPE_PALETTE=buildMimeTypePalette();const colourPalette={...TIMING_PALETTE,...MIME_TYPE_PALETTE};var useWindowSize=__webpack_require__(286);var useWindowSize_default=__webpack_require__.n(useWindowSize);const WaterfallContext=Object(external_kbnSharedDeps_React_["createContext"])({});const WaterfallProvider=({children:children,data:data,onElementClick:onElementClick,onProjectionClick:onProjectionClick,onSidebarClick:onSidebarClick,showOnlyHighlightedNetworkRequests:showOnlyHighlightedNetworkRequests,sidebarItems:sidebarItems,legendItems:legendItems,metadata:metadata,renderTooltipItem:renderTooltipItem,totalNetworkRequests:totalNetworkRequests,highlightedNetworkRequests:highlightedNetworkRequests,fetchedNetworkRequests:fetchedNetworkRequests})=>external_kbnSharedDeps_React_default.a.createElement(WaterfallContext.Provider,{value:{data:data,showOnlyHighlightedNetworkRequests:showOnlyHighlightedNetworkRequests,sidebarItems:sidebarItems,legendItems:legendItems,metadata:metadata,onElementClick:onElementClick,onProjectionClick:onProjectionClick,onSidebarClick:onSidebarClick,renderTooltipItem:renderTooltipItem,totalNetworkRequests:totalNetworkRequests,highlightedNetworkRequests:highlightedNetworkRequests,fetchedNetworkRequests:fetchedNetworkRequests}},children);const useWaterfallContext=()=>Object(external_kbnSharedDeps_React_["useContext"])(WaterfallContext);var polished_lib=__webpack_require__(161);const BAR_HEIGHT=32;const MAIN_GROW_SIZE=8;const SIDEBAR_GROW_SIZE=2;const FIXED_AXIS_HEIGHT=32;const CANVAS_MAX_ITEMS=150;const CHART_LEGEND_PADDING=33;var common_=__webpack_require__(18);const StyledScrollDiv=common_["euiStyled"].div`
  &::-webkit-scrollbar {
    height: ${({theme:theme})=>theme.eui.euiScrollBar};
    width: ${({theme:theme})=>theme.eui.euiScrollBar};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({theme:theme})=>Object(polished_lib["rgba"])(theme.eui.euiColorDarkShade,.5)};
    border: ${({theme:theme})=>theme.eui.euiScrollBarCorner} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;const WaterfallChartOuterContainer=Object(common_["euiStyled"])(StyledScrollDiv)`
  height: ${props=>props.height?`${props.height}`:"auto"};
  overflow-y: ${props=>props.height?"scroll":"visible"};
  overflow-x: hidden;
`;const WaterfallChartFixedTopContainer=Object(common_["euiStyled"])(StyledScrollDiv)`
  position: sticky;
  top: 0;
  z-index: ${props=>props.theme.eui.euiZLevel4};
  overflow-y: scroll;
  overflow-x: hidden;
`;const WaterfallChartAxisOnlyContainer=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"])`
  margin-left: -16px;
`;const WaterfallChartTopContainer=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"])`
`;const WaterfallChartFixedTopContainerSidebarCover=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPanel"])`
  height: 100%;
  border-radius: 0 !important;
  border: none;
`;const WaterfallChartFilterContainer=common_["euiStyled"].div`
  && {
    padding: 16px;
    z-index: ${props=>props.theme.eui.euiZLevel5};
    border-bottom: 0.3px solid ${props=>props.theme.eui.euiColorLightShade};
  }
`;const WaterfallChartFixedAxisContainer=common_["euiStyled"].div`
  height: ${FIXED_AXIS_HEIGHT}px;
  z-index: ${props=>props.theme.eui.euiZLevel4};
  height: 100%;
`;const WaterfallChartSidebarWrapper=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"])`
  z-index: ${props=>props.theme.eui.euiZLevel5};
  min-width: 0;
`;const WaterfallChartSidebarContainer=common_["euiStyled"].div`
  height: ${props=>`${props.height}px`};
  overflow-y: hidden;
`;const WaterfallChartSidebarContainerInnerPanel=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPanel"])`
  border: 0;
  height: 100%;
`;const WaterfallChartSidebarContainerFlexGroup=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"])`
  height: 100%;
`;const WaterfallChartSidebarFlexItem=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"])`
  min-width: 0;
  padding-left: ${props=>props.theme.eui.paddingSizes.m};
  padding-right: ${props=>props.theme.eui.paddingSizes.m};
  justify-content: space-around;
`;const SideBarItemHighlighter=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"])`
  opacity: ${props=>props.isHighlighted?1:.4};
  height: 100%;
`;const WaterfallChartChartContainer=common_["euiStyled"].div`
  width: 100%;
  height: ${props=>`${props.height+FIXED_AXIS_HEIGHT-4}px`};
  margin-top: -${FIXED_AXIS_HEIGHT-4}px;
  z-index: ${props=>Math.round(props.theme.eui.euiZLevel3/(props.chartIndex+1))};
`;const WaterfallChartLegendContainer=common_["euiStyled"].div`
  position: sticky;
  bottom: 0;
  z-index: ${props=>props.theme.eui.euiZLevel4};
  background-color: ${props=>props.theme.eui.euiColorLightestShade};
  padding: ${props=>props.theme.eui.paddingSizes.xs};
  font-size: ${props=>props.theme.eui.euiFontSizeXS};
  box-shadow: 0px -1px 4px 0px ${props=>props.theme.eui.euiColorLightShade};
`;const WaterfallChartTooltip=common_["euiStyled"].div`
  background-color: ${props=>props.theme.eui.euiColorDarkestShade};
  border-radius: ${props=>props.theme.eui.euiBorderRadius};
  color: ${props=>props.theme.eui.euiColorLightestShade};
  padding: ${props=>props.theme.eui.paddingSizes.s};
`;const NetworkRequestsTotalStyle=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiText"])`
  line-height: 28px;
  padding: 0 ${props=>props.theme.eui.paddingSizes.m};
  border-bottom: 0.3px solid ${props=>props.theme.eui.euiColorLightShade};
  z-index: ${props=>props.theme.eui.euiZLevel5};
`;const RelativeContainer=common_["euiStyled"].div`
    position: relative;
`;const Sidebar=({items:items,render:render})=>{const{onSidebarClick:onSidebarClick}=useWaterfallContext();const handleSidebarClick=Object(external_kbnSharedDeps_React_["useMemo"])(()=>onSidebarClick,[onSidebarClick]);return external_kbnSharedDeps_React_default.a.createElement(WaterfallChartSidebarWrapper,{grow:SIDEBAR_GROW_SIZE},external_kbnSharedDeps_React_default.a.createElement(WaterfallChartSidebarContainer,{height:items.length*FIXED_AXIS_HEIGHT,"data-test-subj":"wfSidebarContainer"},external_kbnSharedDeps_React_default.a.createElement(WaterfallChartSidebarContainerInnerPanel,{paddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(WaterfallChartSidebarContainerFlexGroup,{direction:"column",gutterSize:"none",responsive:false},items.map((item,index)=>external_kbnSharedDeps_React_default.a.createElement(WaterfallChartSidebarFlexItem,{key:index},render(item,index,handleSidebarClick)))))))};const StyledFlexItem=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"])`
  margin-right: ${props=>props.theme.eui.paddingSizes.m};
  max-width: 7%;
  min-width: 160px;
`;const Legend=({items:items,render:render})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",wrap:true},items.map((item,index)=>external_kbnSharedDeps_React_default.a.createElement(StyledFlexItem,{key:index},render(item,index))));const useBarCharts=({data:data})=>{const[charts,setCharts]=Object(external_kbnSharedDeps_React_["useState"])([]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const chartsN=[];if((data===null||data===void 0?void 0:data.length)>0){let chartIndex=0;const uniqueResources=new Set;let lastIndex;data.forEach(item=>{if(uniqueResources.size===CANVAS_MAX_ITEMS&&item.x>lastIndex){chartIndex++;uniqueResources.clear()}uniqueResources.add(item.x);lastIndex=item.x;if(!chartsN[chartIndex]){chartsN.push([item]);return}chartsN[chartIndex].push(item)})}setCharts(chartsN)},[data]);return charts};var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(17);var external_kbnSharedDeps_ElasticEuiChartsTheme_=__webpack_require__(24);const useChartTheme=()=>{const[darkMode]=Object(public_["useUiSetting$"])("theme:darkMode");const theme=Object(external_kbnSharedDeps_React_["useMemo"])(()=>darkMode?external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_DARK"].theme:external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_LIGHT"].theme,[darkMode]);return theme};const getChartHeight=data=>{const noOfXBars=new Set(data.map(item=>item.x)).size;return noOfXBars*BAR_HEIGHT};const Tooltip=tooltipInfo=>{const{data:data,renderTooltipItem:renderTooltipItem}=useWaterfallContext();const relevantItems=data.filter(item=>{var _tooltipInfo$header;return item.x===((_tooltipInfo$header=tooltipInfo.header)===null||_tooltipInfo$header===void 0?void 0:_tooltipInfo$header.value)&&item.config.showTooltip&&item.config.tooltipProps});return relevantItems.length?external_kbnSharedDeps_React_default.a.createElement(WaterfallChartTooltip,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"none"},relevantItems.map((item,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index},renderTooltipItem(item.config.tooltipProps))))):null};const WaterfallBarChart=({chartData:chartData,tickFormat:tickFormat,domain:domain,barStyleAccessor:barStyleAccessor,index:index})=>{const theme=useChartTheme();const{onElementClick:onElementClick,onProjectionClick:onProjectionClick}=useWaterfallContext();const handleElementClick=Object(external_kbnSharedDeps_React_["useMemo"])(()=>onElementClick,[onElementClick]);const handleProjectionClick=Object(external_kbnSharedDeps_React_["useMemo"])(()=>onProjectionClick,[onProjectionClick]);const memoizedTickFormat=Object(external_kbnSharedDeps_React_["useCallback"])(tickFormat,[tickFormat]);return external_kbnSharedDeps_React_default.a.createElement(WaterfallChartChartContainer,{height:getChartHeight(chartData),chartIndex:index,"data-test-subj":"wfDataOnlyBarChart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{className:"data-chart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{showLegend:false,rotation:90,tooltip:{customTooltip:Tooltip},theme:theme,onProjectionClick:handleProjectionClick,onElementClick:handleElementClick}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{"aria-hidden":true,id:"time",position:external_kbnSharedDeps_ElasticCharts_["Position"].Top,tickFormat:memoizedTickFormat,domain:domain,showGridLines:true,style:{axisLine:{visible:false}}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{id:"waterfallItems",xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Ordinal,yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,xAccessor:"x",yAccessors:["y"],y0Accessors:["y0"],styleAccessor:barStyleAccessor,data:chartData})))};const WaterfallChartFixedAxis=({tickFormat:tickFormat,domain:domain,barStyleAccessor:barStyleAccessor})=>{const theme=useChartTheme();return external_kbnSharedDeps_React_default.a.createElement(WaterfallChartFixedAxisContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{className:"axis-only-chart","data-test-subj":"axisOnlyChart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{showLegend:false,rotation:90,tooltip:{type:external_kbnSharedDeps_ElasticCharts_["TooltipType"].None},theme:theme}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"time",position:external_kbnSharedDeps_ElasticCharts_["Position"].Top,tickFormat:tickFormat,domain:domain,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{"aria-hidden":true,id:"waterfallItems",xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,xAccessor:"x",yAccessors:["y"],y0Accessors:["y0"],styleAccessor:barStyleAccessor,data:[{x:0,y0:0,y1:1}]})))};const NetworkRequestsTotal=({totalNetworkRequests:totalNetworkRequests,fetchedNetworkRequests:fetchedNetworkRequests,highlightedNetworkRequests:highlightedNetworkRequests,showHighlightedNetworkRequests:showHighlightedNetworkRequests})=>external_kbnSharedDeps_React_default.a.createElement(NetworkRequestsTotalStyle,{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.waterfall.requestsTotalMessage",defaultMessage:"{numNetworkRequests} network requests",values:{numNetworkRequests:totalNetworkRequests>fetchedNetworkRequests?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.waterfall.requestsTotalMessage.first",defaultMessage:"First {count}",values:{count:`${fetchedNetworkRequests}/${totalNetworkRequests}`}}):totalNetworkRequests}})," ",showHighlightedNetworkRequests&&highlightedNetworkRequests>=0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.waterfall.requestsHighlightedMessage",defaultMessage:"({numHighlightedRequests} match the filter)",values:{numHighlightedRequests:highlightedNetworkRequests}})),totalNetworkRequests>fetchedNetworkRequests&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{type:"iInCircle",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.requestsTotalMessage.info",{defaultMessage:"Waterfall view only shows up to 1000 requests"})}));const WaterfallChart=({tickFormat:tickFormat,domain:domain,barStyleAccessor:barStyleAccessor,renderSidebarItem:renderSidebarItem,renderLegendItem:renderLegendItem,renderFilter:renderFilter,renderFlyout:renderFlyout,maxHeight:maxHeight="800px",fullHeight:fullHeight=false})=>{const{data:data,showOnlyHighlightedNetworkRequests:showOnlyHighlightedNetworkRequests,sidebarItems:sidebarItems,legendItems:legendItems,totalNetworkRequests:totalNetworkRequests,highlightedNetworkRequests:highlightedNetworkRequests,fetchedNetworkRequests:fetchedNetworkRequests}=useWaterfallContext();const{width:width}=useWindowSize_default()();const chartWrapperDivRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const legendDivRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const[height,setHeight]=Object(external_kbnSharedDeps_React_["useState"])(maxHeight);const shouldRenderSidebar=!!(sidebarItems&&renderSidebarItem);const shouldRenderLegend=!!(legendItems&&legendItems.length>0&&renderLegendItem);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(fullHeight&&chartWrapperDivRef.current&&legendDivRef.current){const chartOffset=chartWrapperDivRef.current.getBoundingClientRect().top;const legendOffset=legendDivRef.current.getBoundingClientRect().height;setHeight(`calc(100vh - ${chartOffset+CHART_LEGEND_PADDING+legendOffset}px)`)}},[chartWrapperDivRef,fullHeight,legendDivRef,width]);const chartsToDisplay=useBarCharts({data:data});return external_kbnSharedDeps_React_default.a.createElement(RelativeContainer,null,external_kbnSharedDeps_React_default.a.createElement(WaterfallChartFixedTopContainer,null,external_kbnSharedDeps_React_default.a.createElement(WaterfallChartTopContainer,{gutterSize:"none",responsive:false},shouldRenderSidebar&&external_kbnSharedDeps_React_default.a.createElement(WaterfallChartSidebarWrapper,{grow:SIDEBAR_GROW_SIZE},external_kbnSharedDeps_React_default.a.createElement(WaterfallChartFixedTopContainerSidebarCover,{paddingSize:"none",hasShadow:false}),external_kbnSharedDeps_React_default.a.createElement(NetworkRequestsTotal,{totalNetworkRequests:totalNetworkRequests,highlightedNetworkRequests:highlightedNetworkRequests,fetchedNetworkRequests:fetchedNetworkRequests,showHighlightedNetworkRequests:showOnlyHighlightedNetworkRequests}),renderFilter&&external_kbnSharedDeps_React_default.a.createElement(WaterfallChartFilterContainer,null,renderFilter())),external_kbnSharedDeps_React_default.a.createElement(WaterfallChartAxisOnlyContainer,{grow:shouldRenderSidebar?MAIN_GROW_SIZE:true,"data-test-subj":"axisOnlyWrapper"},external_kbnSharedDeps_React_default.a.createElement(WaterfallChartFixedAxis,{domain:domain,barStyleAccessor:barStyleAccessor,tickFormat:tickFormat})))),external_kbnSharedDeps_React_default.a.createElement(WaterfallChartOuterContainer,{height:height,"data-test-subj":"waterfallOuterContainer",ref:chartWrapperDivRef},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",responsive:false},shouldRenderSidebar&&external_kbnSharedDeps_React_default.a.createElement(Sidebar,{items:sidebarItems,render:renderSidebarItem}),external_kbnSharedDeps_React_default.a.createElement(WaterfallChartAxisOnlyContainer,{grow:shouldRenderSidebar?MAIN_GROW_SIZE:true,"data-test-subj":"dataOnlyWrapper"},chartsToDisplay.map((chartData,ind)=>external_kbnSharedDeps_React_default.a.createElement(WaterfallBarChart,{index:ind,key:ind,chartData:chartData,domain:domain,barStyleAccessor:barStyleAccessor,tickFormat:tickFormat}))))),shouldRenderLegend&&external_kbnSharedDeps_React_default.a.createElement(WaterfallChartLegendContainer,{ref:legendDivRef},external_kbnSharedDeps_React_default.a.createElement(Legend,{items:legendItems,render:renderLegendItem})),renderFlyout&&renderFlyout())};const OuterContainer=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"OuterContainer",componentId:"sc-1hshpy5-0"})(["position:relative;display:inline-flex;align-items:center;.euiToolTipAnchor{min-width:0;}"]);const InnerContainer=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"InnerContainer",componentId:"sc-1hshpy5-1"})(["overflow:hidden;display:flex;align-items:center;"]);const FirstChunk=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"FirstChunk",componentId:"sc-1hshpy5-2"})(["text-overflow:ellipsis;white-space:nowrap;overflow:hidden;line-height:","px;text-align:left;"],FIXED_AXIS_HEIGHT);const LastChunk=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"LastChunk",componentId:"sc-1hshpy5-3"})(["flex-shrink:0;line-height:","px;text-align:left;"],FIXED_AXIS_HEIGHT);const StyledButton=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"]).withConfig({displayName:"StyledButton",componentId:"sc-1hshpy5-4"})(["&&&{height:auto;border:none;.euiButtonContent{display:inline-block;padding:0;}}"]);const getChunks=text=>{const END_CHARS=12;const chars=text.split("");const splitPoint=chars.length-END_CHARS>0?chars.length-END_CHARS:null;const endChars=splitPoint?chars.splice(splitPoint):[];return{first:chars.join(""),last:endChars.join("")}};const MiddleTruncatedText=({ariaLabel:ariaLabel,text:text,onClick:onClick,setButtonRef:setButtonRef,url:url})=>{const chunks=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getChunks(text),[text]);return external_kbnSharedDeps_React_default.a.createElement(OuterContainer,{"aria-label":ariaLabel,"data-test-subj":"middleTruncatedTextContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"middleTruncatedTextSROnly"},text)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:text,position:"top","data-test-subj":"middleTruncatedTextToolTip"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,onClick?external_kbnSharedDeps_React_default.a.createElement(StyledButton,{onClick:onClick,"data-test-subj":"middleTruncatedTextButton",buttonRef:setButtonRef},external_kbnSharedDeps_React_default.a.createElement(InnerContainer,null,external_kbnSharedDeps_React_default.a.createElement(FirstChunk,null,chunks.first),external_kbnSharedDeps_React_default.a.createElement(LastChunk,null,chunks.last))):external_kbnSharedDeps_React_default.a.createElement(InnerContainer,{"aria-hidden":true},external_kbnSharedDeps_React_default.a.createElement(FirstChunk,null,chunks.first),external_kbnSharedDeps_React_default.a.createElement(LastChunk,null,chunks.last)))),external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:url,external:true,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.waterfall.resource.externalLink",defaultMessage:"Open resource in new tab"}))))))};const useFlyout=metadata=>{const[isFlyoutVisible,setIsFlyoutVisible]=Object(external_kbnSharedDeps_React_["useState"])(false);const[flyoutData,setFlyoutData]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[currentSidebarItemRef,setCurrentSidebarItemRef]=Object(external_kbnSharedDeps_React_["useState"])();const handleFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(flyoutEntry=>{setFlyoutData(flyoutEntry);setIsFlyoutVisible(true)},[setIsFlyoutVisible,setFlyoutData]);const onFlyoutClose=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _currentSidebarItemRe;setIsFlyoutVisible(false);currentSidebarItemRef===null||currentSidebarItemRef===void 0?void 0:(_currentSidebarItemRe=currentSidebarItemRef.current)===null||_currentSidebarItemRe===void 0?void 0:_currentSidebarItemRe.focus()},[currentSidebarItemRef,setIsFlyoutVisible]);const onBarClick=Object(external_kbnSharedDeps_React_["useCallback"])(([elementData])=>{setIsFlyoutVisible(false);const{datum:datum}=elementData[0];const metadataEntry=metadata[datum.config.id];handleFlyout(metadataEntry)},[metadata,handleFlyout]);const onProjectionClick=Object(external_kbnSharedDeps_React_["useCallback"])(projectionData=>{setIsFlyoutVisible(false);const{x:x}=projectionData;if(typeof x==="number"&&x>=0){const metadataEntry=metadata[x];handleFlyout(metadataEntry)}},[metadata,handleFlyout]);const onSidebarClick=Object(external_kbnSharedDeps_React_["useCallback"])(({buttonRef:buttonRef,networkItemIndex:networkItemIndex})=>{if(isFlyoutVisible&&buttonRef===currentSidebarItemRef){setIsFlyoutVisible(false)}else{const metadataEntry=metadata[networkItemIndex];setCurrentSidebarItemRef(buttonRef);handleFlyout(metadataEntry)}},[currentSidebarItemRef,handleFlyout,isFlyoutVisible,metadata,setIsFlyoutVisible]);return{flyoutData:flyoutData,onBarClick:onBarClick,onProjectionClick:onProjectionClick,onSidebarClick:onSidebarClick,isFlyoutVisible:isFlyoutVisible,onFlyoutClose:onFlyoutClose}};var types=__webpack_require__(70);var useDebounce=__webpack_require__(292);var useDebounce_default=__webpack_require__.n(useDebounce);const FILTER_REQUESTS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.searchBox.placeholder",{defaultMessage:"Filter network requests"});const FILTER_SCREENREADER_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.filterGroup.filterScreenreaderLabel",{defaultMessage:"Filter by"});const FILTER_REMOVE_SCREENREADER_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.filterGroup.removeFilterScreenReaderLabel",{defaultMessage:"Remove filter by"});const FILTER_POPOVER_OPEN_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.synthetics.waterfall.filters.popover",{defaultMessage:"Click to open waterfall filters"});const FILTER_COLLAPSE_REQUESTS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.synthetics.waterfall.filters.collapseRequestsLabel",{defaultMessage:"Collapse to only show matching requests"});const SIDEBAR_FILTER_MATCHES_SCREENREADER_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.sidebar.filterMatchesScreenReaderLabel",{defaultMessage:"Resource matches filter"});const MIME_FILTERS=[{label:FriendlyMimetypeLabels[MimeType.XHR],mimeType:MimeType.XHR},{label:FriendlyMimetypeLabels[MimeType.Html],mimeType:MimeType.Html},{label:FriendlyMimetypeLabels[MimeType.Script],mimeType:MimeType.Script},{label:FriendlyMimetypeLabels[MimeType.Stylesheet],mimeType:MimeType.Stylesheet},{label:FriendlyMimetypeLabels[MimeType.Font],mimeType:MimeType.Font},{label:FriendlyMimetypeLabels[MimeType.Media],mimeType:MimeType.Media}];const WaterfallFilter=({query:query,setQuery:setQuery,activeFilters:activeFilters,setActiveFilters:setActiveFilters,onlyHighlighted:onlyHighlighted,setOnlyHighlighted:setOnlyHighlighted})=>{const[value,setValue]=Object(external_kbnSharedDeps_React_["useState"])(query);const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const trackMetric=Object(observability_public_["useUiTracker"])({app:"uptime"});const toggleFilters=val=>{setActiveFilters(prevState=>prevState.includes(val)?prevState.filter(filter=>filter!==val):[...prevState,val])};useDebounce_default()(()=>{setQuery(value)},250,[value]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!(query||activeFilters.length>0)){setOnlyHighlighted(false)}},[activeFilters.length,setOnlyHighlighted,query]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(query){trackMetric({metric:"waterfall_filter_input_changed",metricType:observability_public_["METRIC_TYPE"].CLICK})}},[query,trackMetric]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(onlyHighlighted){trackMetric({metric:"waterfall_filter_collapse_checked",metricType:observability_public_["METRIC_TYPE"].CLICK})}},[onlyHighlighted,trackMetric]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(activeFilters.length>0){trackMetric({metric:`waterfall_filters_applied_changed`,metricType:observability_public_["METRIC_TYPE"].CLICK})}},[activeFilters,trackMetric]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{fullWidth:true,"aria-label":FILTER_REQUESTS_LABEL,placeholder:FILTER_REQUESTS_LABEL,onChange:evt=>{setValue(evt.target.value)},value:value})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":FILTER_POPOVER_OPEN_LABEL,iconType:"filter",onClick:()=>setIsPopoverOpen(prevState=>!prevState),color:activeFilters.length>0?"primary":"text",isSelected:activeFilters.length>0}),isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),anchorPosition:"rightCenter"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,MIME_FILTERS.map(({label:label,mimeType:mimeType})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{hasActiveFilters:activeFilters.includes(mimeType),onClick:()=>toggleFilters(mimeType),key:label,withNext:true,"aria-label":`${activeFilters.includes(mimeType)?FILTER_REMOVE_SCREENREADER_LABEL:FILTER_SCREENREADER_LABEL} ${label}`},label))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{compressed:true,disabled:!(query||activeFilters.length>0),id:"onlyHighlighted",label:FILTER_COLLAPSE_REQUESTS_LABEL,checked:onlyHighlighted,onChange:e=>{setOnlyHighlighted(e.target.checked)}}))))};const StyledText=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiText"]).withConfig({displayName:"StyledText",componentId:"xutqs2-0"})(["width:100%;"]);class waterfall_flyout_table_TableWithoutHeader extends external_kbnSharedDeps_ElasticEui_["EuiBasicTable"]{renderTableHead(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null)}}const Table=props=>{const{rows:rows,title:title}=props;const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{field:"name",name:"",sortable:false,render:(_name,item)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("strong",null,item.name))},{field:"value",name:"",sortable:false,render:(_name,item)=>{var _item$value;return external_kbnSharedDeps_React_default.a.createElement(StyledText,{size:"xs",textAlign:"right"},(_item$value=item.value)!==null&&_item$value!==void 0?_item$value:"--")}}],[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(waterfall_flyout_table_TableWithoutHeader,{tableLayout:"fixed",compressed:true,responsive:false,columns:columns,items:rows}))};const DETAILS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.flyout.details",{defaultMessage:"Details"});const CERTIFICATES=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.flyout.certificates",{defaultMessage:"Certificate headers"});const REQUEST_HEADERS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.flyout.requestHeaders",{defaultMessage:"Request headers"});const RESPONSE_HEADERS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.waterfall.flyout.responseHeaders",{defaultMessage:"Response headers"});const FlyoutContainer=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyout"]).withConfig({displayName:"FlyoutContainer",componentId:"sc-9osrcj-0"})(["z-index:",";"],props=>props.theme.eui.euiZLevel5);const WaterfallFlyout=({flyoutData:flyoutData,isFlyoutVisible:isFlyoutVisible,onFlyoutClose:onFlyoutClose})=>{const flyoutRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const trackMetric=Object(observability_public_["useUiTracker"])({app:"uptime"});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isFlyoutVisible&&flyoutData&&flyoutRef.current){var _flyoutRef$current;(_flyoutRef$current=flyoutRef.current)===null||_flyoutRef$current===void 0?void 0:_flyoutRef$current.focus()}},[flyoutData,isFlyoutVisible,flyoutRef]);if(!flyoutData||!isFlyoutVisible){return null}const{url:url,details:details,certificates:certificates,requestHeaders:requestHeaders,responseHeaders:responseHeaders}=flyoutData;trackMetric({metric:"waterfall_flyout",metricType:observability_public_["METRIC_TYPE"].CLICK});return external_kbnSharedDeps_React_default.a.createElement("div",{"tab-index":-1,ref:flyoutRef,"data-test-subj":"waterfallFlyout","aria-labelledby":"flyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(FlyoutContainer,{size:"s",onClose:onFlyoutClose},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"flyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(MiddleTruncatedText,{text:url,url:url,ariaLabel:url}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(Table,{rows:details,title:DETAILS}),!!requestHeaders&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(Table,{rows:requestHeaders,title:REQUEST_HEADERS})),!!responseHeaders&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(Table,{rows:responseHeaders,title:RESPONSE_HEADERS})),!!certificates&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(Table,{rows:certificates,title:CERTIFICATES})))))};const WaterfallSidebarItem=({item:item,renderFilterScreenReaderText:renderFilterScreenReaderText,onClick:onClick})=>{const[buttonRef,setButtonRef]=Object(external_kbnSharedDeps_React_["useState"])();const{status:status,offsetIndex:offsetIndex,index:index,isHighlighted:isHighlighted,url:url}=item;const handleSidebarClick=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(onClick){return()=>onClick({buttonRef:buttonRef,networkItemIndex:index})}},[buttonRef,index,onClick]);const setRef=Object(external_kbnSharedDeps_React_["useCallback"])(ref=>setButtonRef(ref),[setButtonRef]);const isErrorStatusCode=statusCode=>{const is400=statusCode>=400&&statusCode<=499;const is500=statusCode>=500&&statusCode<=599;const isSpecific300=statusCode===301||statusCode===307||statusCode===308;return is400||is500||isSpecific300};const text=`${offsetIndex}. ${item.url}`;const ariaLabel=`${isHighlighted&&renderFilterScreenReaderText?`${SIDEBAR_FILTER_MATCHES_SCREENREADER_LABEL} `:""}${text}`;return external_kbnSharedDeps_React_default.a.createElement(SideBarItemHighlighter,{isHighlighted:isHighlighted,"data-test-subj":isHighlighted?"sideBarHighlightedItem":"sideBarDimmedItem"},!status||!isErrorStatusCode(status)?external_kbnSharedDeps_React_default.a.createElement(MiddleTruncatedText,{text:text,url:url,ariaLabel:ariaLabel,onClick:handleSidebarClick,setButtonRef:setRef}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{minWidth:0}},external_kbnSharedDeps_React_default.a.createElement(MiddleTruncatedText,{text:text,url:url,ariaLabel:ariaLabel,onClick:handleSidebarClick,setButtonRef:setRef})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"danger"},status))))};const waterfall_chart_wrapper_renderLegendItem=item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:item.colour,className:"eui-textNoWrap"},item.name);const WaterfallChartWrapper=({data:data,total:total})=>{const[query,setQuery]=Object(external_kbnSharedDeps_React_["useState"])("");const[activeFilters,setActiveFilters]=Object(external_kbnSharedDeps_React_["useState"])([]);const[onlyHighlighted,setOnlyHighlighted]=Object(external_kbnSharedDeps_React_["useState"])(false);const[networkData]=Object(external_kbnSharedDeps_React_["useState"])(data);const hasFilters=activeFilters.length>0;const{series:series,domain:domain,metadata:metadata,totalHighlightedRequests:totalHighlightedRequests}=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getSeriesAndDomain(networkData,onlyHighlighted,query,activeFilters),[networkData,query,activeFilters,onlyHighlighted]);const sidebarItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getSidebarItems(networkData,onlyHighlighted,query,activeFilters),[networkData,query,activeFilters,onlyHighlighted]);const legendItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLegendItems(),[]);const{flyoutData:flyoutData,onBarClick:onBarClick,onProjectionClick:onProjectionClick,onSidebarClick:onSidebarClick,isFlyoutVisible:isFlyoutVisible,onFlyoutClose:onFlyoutClose}=useFlyout(metadata);const renderFilter=Object(external_kbnSharedDeps_React_["useCallback"])(()=>external_kbnSharedDeps_React_default.a.createElement(WaterfallFilter,{query:query,setQuery:setQuery,activeFilters:activeFilters,setActiveFilters:setActiveFilters,onlyHighlighted:onlyHighlighted,setOnlyHighlighted:setOnlyHighlighted}),[activeFilters,setActiveFilters,onlyHighlighted,setOnlyHighlighted,query,setQuery]);const renderFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>external_kbnSharedDeps_React_default.a.createElement(WaterfallFlyout,{flyoutData:flyoutData,onFlyoutClose:onFlyoutClose,isFlyoutVisible:isFlyoutVisible}),[flyoutData,isFlyoutVisible,onFlyoutClose]);const renderSidebarItem=Object(external_kbnSharedDeps_React_["useCallback"])(item=>external_kbnSharedDeps_React_default.a.createElement(WaterfallSidebarItem,{item:item,renderFilterScreenReaderText:hasFilters&&!onlyHighlighted,onClick:onSidebarClick}),[hasFilters,onlyHighlighted,onSidebarClick]);Object(observability_public_["useTrackMetric"])({app:"uptime",metric:"waterfall_chart_view",metricType:observability_public_["METRIC_TYPE"].COUNT});Object(observability_public_["useTrackMetric"])({app:"uptime",metric:"waterfall_chart_view",metricType:observability_public_["METRIC_TYPE"].COUNT,delay:15e3});return external_kbnSharedDeps_React_default.a.createElement(WaterfallProvider,{totalNetworkRequests:total,fetchedNetworkRequests:networkData.length,highlightedNetworkRequests:totalHighlightedRequests,data:series,onElementClick:Object(external_kbnSharedDeps_React_["useCallback"])(onBarClick,[onBarClick]),onProjectionClick:Object(external_kbnSharedDeps_React_["useCallback"])(onProjectionClick,[onProjectionClick]),onSidebarClick:onSidebarClick,showOnlyHighlightedNetworkRequests:onlyHighlighted,sidebarItems:sidebarItems,legendItems:legendItems,metadata:metadata,renderTooltipItem:Object(external_kbnSharedDeps_React_["useCallback"])(tooltipProps=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:String(tooltipProps===null||tooltipProps===void 0?void 0:tooltipProps.colour)},tooltipProps===null||tooltipProps===void 0?void 0:tooltipProps.value),[])},external_kbnSharedDeps_React_default.a.createElement(WaterfallChart,{tickFormat:Object(external_kbnSharedDeps_React_["useCallback"])(d=>`${Number(d).toFixed(0)} ms`,[]),domain:domain,barStyleAccessor:Object(external_kbnSharedDeps_React_["useCallback"])(datum=>{if(!datum.datum.config.isHighlighted){return{rect:{fill:datum.datum.config.colour,opacity:"0.1"}}}return datum.datum.config.colour},[]),renderSidebarItem:renderSidebarItem,renderLegendItem:waterfall_chart_wrapper_renderLegendItem,renderFlyout:renderFlyout,renderFilter:renderFilter,fullHeight:true}))};const NO_DATA_TEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.stepDetail.waterfallNoData",{defaultMessage:"No waterfall data could be found for this step"});const WaterfallChartContainer=({checkGroup:checkGroup,stepIndex:stepIndex})=>{var _networkEvents2;const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(checkGroup&&stepIndex){dispatch(Object(network_events["a"])({checkGroup:checkGroup,stepIndex:stepIndex}))}},[dispatch,stepIndex,checkGroup]);const _networkEvents=Object(lib["useSelector"])(selectors["u"]);const networkEvents=(_networkEvents2=_networkEvents[checkGroup!==null&&checkGroup!==void 0?checkGroup:""])===null||_networkEvents2===void 0?void 0:_networkEvents2[stepIndex];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!networkEvents||networkEvents.loading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl"}))),networkEvents&&!networkEvents.loading&&networkEvents.events.length===0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{textAlign:"center"},external_kbnSharedDeps_React_default.a.createElement("p",null,NO_DATA_TEXT)))),networkEvents&&!networkEvents.loading&&networkEvents.events.length>0&&external_kbnSharedDeps_React_default.a.createElement(WaterfallChartWrapper,{data:extractItems(networkEvents.events),total:networkEvents.total}))};const PREVIOUS_CHECK_BUTTON_TEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.stepDetail.previousCheckButtonText",{defaultMessage:"Previous check"});const NEXT_CHECK_BUTTON_TEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.stepDetail.nextCheckButtonText",{defaultMessage:"Next check"});const StepDetail=({dateFormat:dateFormat,stepName:stepName,checkGroup:checkGroup,stepIndex:stepIndex,totalSteps:totalSteps,hasPreviousStep:hasPreviousStep,hasNextStep:hasNextStep,handlePreviousStep:handlePreviousStep,handleNextStep:handleNextStep,handlePreviousRun:handlePreviousRun,handleNextRun:handleNextRun,previousCheckGroup:previousCheckGroup,nextCheckGroup:nextCheckGroup,checkTimestamp:checkTimestamp})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",responsive:false,wrap:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h1",null,stepName))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:handlePreviousStep,disabled:!hasPreviousStep,iconType:"arrowLeft"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.stepDetail.totalSteps",defaultMessage:"Step {stepIndex} of {totalSteps}",values:{stepIndex:stepIndex,totalSteps:totalSteps}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:handleNextStep,disabled:!hasNextStep,iconType:"arrowRight"})))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"flexEnd",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:handlePreviousRun,disabled:!previousCheckGroup,iconType:"arrowLeft","aria-label":PREVIOUS_CHECK_BUTTON_TEXT},PREVIOUS_CHECK_BUTTON_TEXT)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_Moment_default()(checkTimestamp).format(dateFormat))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:handleNextRun,disabled:!nextCheckGroup,iconType:"arrowRight",iconSide:"right","aria-label":NEXT_CHECK_BUTTON_TEXT},NEXT_CHECK_BUTTON_TEXT))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(WaterfallChartContainer,{checkGroup:checkGroup,stepIndex:stepIndex}));const useMonitorBreadcrumb=({journey:journey,activeStep:activeStep})=>{var _kibana$services$appl,_kibana$services$appl2,_activeStep$monitor,_journey$details,_journey$details2;const[dateFormat]=Object(public_["useUiSetting$"])("dateFormat");const kibana=Object(public_["useKibana"])();const appPath=(_kibana$services$appl=(_kibana$services$appl2=kibana.services.application)===null||_kibana$services$appl2===void 0?void 0:_kibana$services$appl2.getUrlForApp(constants_plugin["a"].ID))!==null&&_kibana$services$appl!==void 0?_kibana$services$appl:"";useBreadcrumbs([...activeStep!==null&&activeStep!==void 0&&activeStep.monitor?[{text:(activeStep===null||activeStep===void 0?void 0:(_activeStep$monitor=activeStep.monitor)===null||_activeStep$monitor===void 0?void 0:_activeStep$monitor.name)||(activeStep===null||activeStep===void 0?void 0:activeStep.monitor.id),href:`${appPath}/monitor/${btoa(activeStep===null||activeStep===void 0?void 0:activeStep.monitor.id)}`}]:[],...journey!==null&&journey!==void 0&&(_journey$details=journey.details)!==null&&_journey$details!==void 0&&_journey$details.timestamp?[{text:external_kbnSharedDeps_Moment_default()(journey===null||journey===void 0?void 0:(_journey$details2=journey.details)===null||_journey$details2===void 0?void 0:_journey$details2.timestamp).format(dateFormat)}]:[]])};const NO_STEP_DATA=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.stepDetail.noData",{defaultMessage:"No data could be found for this step"});const StepDetailContainer=({checkGroup:checkGroup,stepIndex:stepIndex})=>{var _journey$details2,_journey$details2$nex,_journey$details4,_journey$details4$pre,_activeStep$synthetic,_activeStep$synthetic2,_journey$details5,_journey$details5$pre,_journey$details6,_journey$details6$nex,_journey$details7;const dispatch=Object(lib["useDispatch"])();const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const[dateFormat]=Object(public_["useUiSetting$"])("dateFormat");Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(checkGroup){dispatch(Object(actions_journey["a"])({checkGroup:checkGroup,syntheticEventTypes:["step/end"]}))}},[dispatch,checkGroup]);const journeys=Object(lib["useSelector"])(selectors["m"]);const journey=journeys[checkGroup!==null&&checkGroup!==void 0?checkGroup:""];const{activeStep:activeStep,hasPreviousStep:hasPreviousStep,hasNextStep:hasNextStep}=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _journey$steps;return{hasPreviousStep:stepIndex>1?true:false,activeStep:journey===null||journey===void 0?void 0:(_journey$steps=journey.steps)===null||_journey$steps===void 0?void 0:_journey$steps.find(step=>{var _step$synthetics,_step$synthetics$step;return((_step$synthetics=step.synthetics)===null||_step$synthetics===void 0?void 0:(_step$synthetics$step=_step$synthetics.step)===null||_step$synthetics$step===void 0?void 0:_step$synthetics$step.index)===stepIndex}),hasNextStep:journey&&journey.steps&&stepIndex<journey.steps.length?true:false}},[stepIndex,journey]);useMonitorBreadcrumb({journey:journey,activeStep:activeStep});const handleNextStep=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{history.push(`/journey/${checkGroup}/step/${stepIndex+1}`)},[history,checkGroup,stepIndex]);const handlePreviousStep=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{history.push(`/journey/${checkGroup}/step/${stepIndex-1}`)},[history,checkGroup,stepIndex]);const handleNextRun=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _journey$details,_journey$details$next;history.push(`/journey/${journey===null||journey===void 0?void 0:(_journey$details=journey.details)===null||_journey$details===void 0?void 0:(_journey$details$next=_journey$details.next)===null||_journey$details$next===void 0?void 0:_journey$details$next.checkGroup}/step/1`)},[history,journey===null||journey===void 0?void 0:(_journey$details2=journey.details)===null||_journey$details2===void 0?void 0:(_journey$details2$nex=_journey$details2.next)===null||_journey$details2$nex===void 0?void 0:_journey$details2$nex.checkGroup]);const handlePreviousRun=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _journey$details3,_journey$details3$pre;history.push(`/journey/${journey===null||journey===void 0?void 0:(_journey$details3=journey.details)===null||_journey$details3===void 0?void 0:(_journey$details3$pre=_journey$details3.previous)===null||_journey$details3$pre===void 0?void 0:_journey$details3$pre.checkGroup}/step/1`)},[history,journey===null||journey===void 0?void 0:(_journey$details4=journey.details)===null||_journey$details4===void 0?void 0:(_journey$details4$pre=_journey$details4.previous)===null||_journey$details4$pre===void 0?void 0:_journey$details4$pre.checkGroup]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,(!journey||journey.loading)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"}))),journey&&!activeStep&&!journey.loading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{textAlign:"center"},external_kbnSharedDeps_React_default.a.createElement("p",null,NO_STEP_DATA)))),journey&&activeStep&&!journey.loading&&external_kbnSharedDeps_React_default.a.createElement(StepDetail,{checkGroup:checkGroup,stepName:(_activeStep$synthetic=activeStep.synthetics)===null||_activeStep$synthetic===void 0?void 0:(_activeStep$synthetic2=_activeStep$synthetic.step)===null||_activeStep$synthetic2===void 0?void 0:_activeStep$synthetic2.name,stepIndex:stepIndex,totalSteps:journey.steps.length,hasPreviousStep:hasPreviousStep,hasNextStep:hasNextStep,handlePreviousStep:handlePreviousStep,handleNextStep:handleNextStep,handleNextRun:handleNextRun,handlePreviousRun:handlePreviousRun,previousCheckGroup:(_journey$details5=journey.details)===null||_journey$details5===void 0?void 0:(_journey$details5$pre=_journey$details5.previous)===null||_journey$details5$pre===void 0?void 0:_journey$details5$pre.checkGroup,nextCheckGroup:(_journey$details6=journey.details)===null||_journey$details6===void 0?void 0:(_journey$details6$nex=_journey$details6.next)===null||_journey$details6$nex===void 0?void 0:_journey$details6$nex.checkGroup,checkTimestamp:(_journey$details7=journey.details)===null||_journey$details7===void 0?void 0:_journey$details7.timestamp,dateFormat:dateFormat})))};const StepDetailPage=()=>{useInitApp();const{checkGroupId:checkGroupId,stepIndex:stepIndex}=Object(external_kbnSharedDeps_ReactRouterDom_["useParams"])();Object(observability_public_["useTrackPageview"])({app:"uptime",path:"stepDetail"});Object(observability_public_["useTrackPageview"])({app:"uptime",path:"stepDetail",delay:15e3});return external_kbnSharedDeps_React_default.a.createElement(StepDetailContainer,{checkGroup:checkGroupId,stepIndex:Number(stepIndex)})};const IndicesForm=({onChange:onChange,loading:loading,formFields:formFields,fieldErrors:fieldErrors,isDisabled:isDisabled})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.indicesSectionTitle",defaultMessage:"Indices"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.heartbeatIndicesTitle",defaultMessage:"Uptime indices"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.heartbeatIndicesDescription",defaultMessage:"Index pattern for matching indices that contain Heartbeat data"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{describedByIds:["heartbeatIndices"],error:fieldErrors===null||fieldErrors===void 0?void 0:fieldErrors.heartbeatIndices,fullWidth:true,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.heartbeatIndicesDefaultValue",defaultMessage:"The default value is {defaultValue}",values:{defaultValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,constants["i"].heartbeatIndices)}}),isInvalid:!!(fieldErrors!==null&&fieldErrors!==void 0&&fieldErrors.heartbeatIndices),label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.heartbeatIndicesLabel",defaultMessage:"Heartbeat indices"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{"data-test-subj":`heartbeat-indices-input-${loading?"loading":"loaded"}`,fullWidth:true,disabled:isDisabled,isLoading:loading,value:(formFields===null||formFields===void 0?void 0:formFields.heartbeatIndices)||"",onChange:event=>onChange({heartbeatIndices:event.currentTarget.value})}))));const certificateFormTranslations={ageInputAriaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.sourceConfiguration.ageLimitThresholdInput.ariaLabel",{defaultMessage:"An input that controls the maximum number of days for which a TLS certificate may be valid before Kibana will show a warning."}),expirationInputAriaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.sourceConfiguration.certificateExpirationThresholdInput.ariaLabel",{defaultMessage:"An input that controls the minimum number of days remaining for TLS certificate expiration before Kibana will show a warning."})};const alertFormI18n={inputPlaceHolder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.sourceConfiguration.alertDefaultForm.selectConnector",{defaultMessage:"Please select one or more connectors"})};const CertificateExpirationForm=({loading:loading,onChange:onChange,formFields:formFields,fieldErrors:fieldErrors,isDisabled:isDisabled})=>{var _formFields$certExpir,_formFields$certAgeTh;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.certificationSectionTitle",defaultMessage:"Certificate Expiration"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.expirationThreshold",defaultMessage:"Expiration/Age Thresholds"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.certificateThresholdDescription",defaultMessage:"Change the threshold for displaying and alerting on certificate errors. Note: this will affect any configured alerts."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{describedByIds:["errorState"],error:fieldErrors===null||fieldErrors===void 0?void 0:fieldErrors.expirationThresholdError,fullWidth:true,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.expirationThresholdDefaultValue",defaultMessage:"The default value is {defaultValue}",values:{defaultValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,constants["i"].certExpirationThreshold)}}),isInvalid:!!(fieldErrors!==null&&fieldErrors!==void 0&&fieldErrors.expirationThresholdError),label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.errorStateLabel",defaultMessage:"Expiration threshold"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{"aria-label":certificateFormTranslations.expirationInputAriaLabel,"data-test-subj":`expiration-threshold-input-${loading?"loading":"loaded"}`,fullWidth:true,disabled:isDisabled,isInvalid:!!(fieldErrors!==null&&fieldErrors!==void 0&&fieldErrors.expirationThresholdError),isLoading:loading,value:(_formFields$certExpir=formFields===null||formFields===void 0?void 0:formFields.certExpirationThreshold)!==null&&_formFields$certExpir!==void 0?_formFields$certExpir:"",onChange:e=>onChange({certExpirationThreshold:Number(e.target.value)||undefined})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.ageLimit.units.days",defaultMessage:"Days"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{describedByIds:["warningState"],error:fieldErrors===null||fieldErrors===void 0?void 0:fieldErrors.ageThresholdError,fullWidth:true,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.ageThresholdDefaultValue",defaultMessage:"The default value is {defaultValue}",values:{defaultValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,constants["i"].certAgeThreshold)}}),isInvalid:!!(fieldErrors!==null&&fieldErrors!==void 0&&fieldErrors.ageThresholdError),label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.warningStateLabel",defaultMessage:"Age limit"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{"aria-label":certificateFormTranslations.ageInputAriaLabel,"data-test-subj":`age-threshold-input-${loading?"loading":"loaded"}`,fullWidth:true,disabled:isDisabled,isInvalid:!!(fieldErrors!==null&&fieldErrors!==void 0&&fieldErrors.ageThresholdError),isLoading:loading,value:(_formFields$certAgeTh=formFields===null||formFields===void 0?void 0:formFields.certAgeThreshold)!==null&&_formFields$certAgeTh!==void 0?_formFields$certAgeTh:"",onChange:({target:{value:value}})=>onChange({certAgeThreshold:Number(value)||undefined})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.ageLimit.units.days",defaultMessage:"Days"})))))))};var translations=__webpack_require__(4);var api_alerts=__webpack_require__(177);const ALLOWED_ACTION_TYPES=[".slack",".pagerduty",".server-log",".index",".teams",".servicenow",".jira",".webhook"];const AddConnectorFlyout=({focusInput:focusInput})=>{const[addFlyoutVisible,setAddFlyoutVisibility]=Object(external_kbnSharedDeps_React_["useState"])(false);const{services:{triggersActionsUi:{getAddConnectorFlyout:getAddConnectorFlyout}}}=Object(public_["useKibana"])();const dispatch=Object(lib["useDispatch"])();const{data:actionTypes}=Object(observability_public_["useFetcher"])(()=>Object(api_alerts["c"])(),[]);const ConnectorAddFlyout=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getAddConnectorFlyout({consumer:"uptime",onClose:()=>{dispatch(alerts["j"].get());setAddFlyoutVisibility(false);focusInput()},actionTypes:(actionTypes!==null&&actionTypes!==void 0?actionTypes:[]).filter(actionType=>ALLOWED_ACTION_TYPES.includes(actionType.id))}),[actionTypes]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"plusInCircleFilled",iconSide:"left",onClick:()=>setAddFlyoutVisibility(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.alerts.settings.createConnector",defaultMessage:"Create connector"})),addFlyoutVisible?ConnectorAddFlyout:null)};const ConnectorSpan=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"ConnectorSpan",componentId:"sc-1pkjv5s-0"})([".euiIcon{margin-right:5px;}> img{width:16px;height:20px;}"]);const AlertDefaultsForm=({onChange:onChange,loading:loading,formFields:formFields,fieldErrors:fieldErrors,isDisabled:isDisabled})=>{const{services:{triggersActionsUi:{actionTypeRegistry:actionTypeRegistry}}}=Object(public_["useKibana"])();const{focusConnectorField:focusConnectorField}=Object(hooks["c"])();const updateUrlParams=Object(hooks["h"])()[1];const inputRef=Object(external_kbnSharedDeps_React_["useRef"])(null);useInitApp();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(focusConnectorField&&inputRef.current&&!loading){inputRef.current.focus()}},[focusConnectorField,inputRef,loading]);const{data:data=[]}=Object(lib["useSelector"])(alerts["d"]);const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const onBlur=()=>{if(inputRef.current){const{value:value}=inputRef.current;setError(value.length===0?undefined:`"${value}" is not a valid option`)}if(inputRef.current&&!loading&&focusConnectorField){updateUrlParams({focusConnectorField:undefined})}};const onSearchChange=(value,hasMatchingOptions)=>{setError(value.length===0||hasMatchingOptions?undefined:`"${value}" is not a valid option`)};const options=(data!==null&&data!==void 0?data:[]).filter(action=>ALLOWED_ACTION_TYPES.includes(action.actionTypeId)).map(connectorAction=>({value:connectorAction.id,label:connectorAction.name,"data-test-subj":connectorAction.name}));const renderOption=option=>{var _data$find;const{label:label,value:value}=option;const{actionTypeId:type}=(_data$find=data===null||data===void 0?void 0:data.find(dt=>dt.id===value))!==null&&_data$find!==void 0?_data$find:{};return external_kbnSharedDeps_React_default.a.createElement(ConnectorSpan,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:actionTypeRegistry.get(type).iconClass}),external_kbnSharedDeps_React_default.a.createElement("span",null,label))};const onOptionChange=selectedOptions=>{onChange({defaultConnectors:selectedOptions.map(item=>{const conOpt=data===null||data===void 0?void 0:data.find(dt=>dt.id===item.value);return conOpt.id})})};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.alertDefaults",defaultMessage:"Alert defaults"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.alertConnectors",defaultMessage:"Alert Connectors"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.defaultConnectors.description",defaultMessage:"Default connectors to be used to send an alert."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{describedByIds:["defaultConnectors"],error:error,fullWidth:true,isInvalid:!!error,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.defaultConnectors",defaultMessage:"Default connectors"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:alertFormI18n.inputPlaceHolder,options:options,selectedOptions:options.filter(opt=>{var _formFields$defaultCo;return formFields===null||formFields===void 0?void 0:(_formFields$defaultCo=formFields.defaultConnectors)===null||_formFields$defaultCo===void 0?void 0:_formFields$defaultCo.includes(opt.value)}),inputRef:input=>{inputRef.current=input},onSearchChange:onSearchChange,onBlur:onBlur,isLoading:loading,isDisabled:isDisabled,onChange:onOptionChange,"data-test-subj":`default-connectors-input-${loading?"loading":"loaded"}`,renderOption:renderOption})),external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(AddConnectorFlyout,{focusInput:Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(inputRef.current){inputRef.current.focus()}},[])}))))};const isValidCertVal=val=>{if(val===undefined||isNaN(val)){return settings.mustBeNumber}if(val<=0){return translations["c"]}if(val%1){return translations["b"]}};const getFieldErrors=formFields=>{if(formFields){const{certAgeThreshold:certAgeThreshold,certExpirationThreshold:certExpirationThreshold,heartbeatIndices:heartbeatIndices}=formFields;const indError=heartbeatIndices.match(/^\S+$/)?"":BLANK_STR;const expError=isValidCertVal(certExpirationThreshold);const ageError=isValidCertVal(certAgeThreshold);return{heartbeatIndices:indError,expirationThresholdError:expError,ageThresholdError:ageError}}return null};const isDirtyForm=(formFields,settings)=>(settings===null||settings===void 0?void 0:settings.certAgeThreshold)!==(formFields===null||formFields===void 0?void 0:formFields.certAgeThreshold)||(settings===null||settings===void 0?void 0:settings.certExpirationThreshold)!==(formFields===null||formFields===void 0?void 0:formFields.certExpirationThreshold)||(settings===null||settings===void 0?void 0:settings.heartbeatIndices)!==(formFields===null||formFields===void 0?void 0:formFields.heartbeatIndices)||JSON.stringify(settings===null||settings===void 0?void 0:settings.defaultConnectors)!==JSON.stringify(formFields===null||formFields===void 0?void 0:formFields.defaultConnectors);const SettingsPage=()=>{var _useKibana$services,_useKibana$services$a;const dss=Object(lib["useSelector"])(selectors["A"]);useBreadcrumbs([{text:settings.breadcrumbText}]);const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(dynamic_settings["a"])({}))},[dispatch]);const[formFields,setFormFields]=Object(external_kbnSharedDeps_React_["useState"])(dss.settings?{...dss.settings}:null);if(!dss.loadError&&formFields===null&&dss.settings){setFormFields(Object.assign({},{...dss.settings}))}const fieldErrors=getFieldErrors(formFields);const isFormValid=!(fieldErrors&&Object.values(fieldErrors).find(v=>!!v));const onChangeFormField=changedField=>{if(formFields){setFormFields({...formFields,...changedField})}};const onApply=event=>{event.preventDefault();if(formFields){dispatch(Object(dynamic_settings["d"])(formFields))}};const resetForm=()=>setFormFields(dss.settings?{...dss.settings}:null);const isFormDirty=isDirtyForm(formFields,dss.settings);const canEdit=!!((_useKibana$services=Object(public_["useKibana"])().services)!==null&&_useKibana$services!==void 0&&(_useKibana$services$a=_useKibana$services.application)!==null&&_useKibana$services$a!==void 0&&_useKibana$services$a.capabilities.uptime.configureSettings)||false;const isFormDisabled=dss.loading||!canEdit;const cannotEditNotice=canEdit?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:settings.editNoticeTitle},settings.editNoticeText),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{style:{maxWidth:1e3,margin:"auto"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},cannotEditNotice)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("div",{id:"settings-form"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(IndicesForm,{loading:dss.loading,onChange:onChangeFormField,formFields:formFields,fieldErrors:fieldErrors,isDisabled:isFormDisabled}),external_kbnSharedDeps_React_default.a.createElement(AlertDefaultsForm,{loading:dss.loading,formFields:formFields,onChange:onChangeFormField,fieldErrors:fieldErrors,isDisabled:isFormDisabled}),external_kbnSharedDeps_React_default.a.createElement(CertificateExpirationForm,{loading:dss.loading,onChange:onChangeFormField,formFields:formFields,fieldErrors:fieldErrors,isDisabled:isFormDisabled}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"discardSettingsButton",isDisabled:!isFormDirty||isFormDisabled,onClick:()=>{resetForm()}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.discardSettingsButtonLabel",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"apply-settings-button",onClick:onApply,color:"primary",isDisabled:!isFormDirty||!isFormValid||isFormDisabled,fill:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.sourceConfiguration.applySettingsButtonLabel",defaultMessage:"Apply changes"}))))))))))};const NotFoundPage=()=>{const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"faceNeutral",iconColor:"subdued",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Page not found",id:"xpack.uptime.emptyStateError.notFoundPage"}))),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{href:history.createHref({pathname:"/"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Back to home",id:"xpack.uptime.notFountPage.homeLinkText"}))}))))};var certificates_certificates=__webpack_require__(87);var monitor_page_link=__webpack_require__(103);const CertMonitors=({monitors:monitors})=>external_kbnSharedDeps_React_default.a.createElement("span",null,monitors.map((mon,ind)=>external_kbnSharedDeps_React_default.a.createElement("span",{key:mon.id},ind>0&&", ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:mon.url},external_kbnSharedDeps_React_default.a.createElement(monitor_page_link["a"],{monitorId:mon.id,linkParameters:""},mon.name||mon.id)))));var certificates_translations=__webpack_require__(58);const WrapFieldSearch=external_kbnSharedDeps_StyledComponents_default()("div").withConfig({displayName:"WrapFieldSearch",componentId:"t89f5p-0"})(["max-width:700px;"]);const CertificateSearch=({setSearch:setSearch})=>{const onChange=e=>{setSearch(e.target.value)};return external_kbnSharedDeps_React_default.a.createElement(WrapFieldSearch,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{"data-test-subj":"uptimeCertSearch",placeholder:certificates_translations["m"],onChange:onChange,isClearable:true,"aria-label":certificates_translations["m"],fullWidth:true}))};const DateText=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiText"]).withConfig({displayName:"DateText",componentId:"bpzgap-0"})(["display:inline-block;margin-left:5px;"]);const CertStatus=({cert:cert})=>{const certStatus=Object(hooks["b"])(cert===null||cert===void 0?void 0:cert.not_after,cert===null||cert===void 0?void 0:cert.not_before);const dss=Object(lib["useSelector"])(selectors["A"]);const relativeDate=external_kbnSharedDeps_Moment_default()(cert===null||cert===void 0?void 0:cert.not_after).fromNow();if(certStatus===constants["c"].EXPIRING_SOON){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"warning"},external_kbnSharedDeps_React_default.a.createElement("span",null,certificates_translations["g"],"  ",external_kbnSharedDeps_React_default.a.createElement(DateText,{color:"subdued",size:"xs"},relativeDate)))}if(certStatus===constants["c"].EXPIRED){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"danger"},external_kbnSharedDeps_React_default.a.createElement("span",null,certificates_translations["e"],"  ",external_kbnSharedDeps_React_default.a.createElement(DateText,{color:"subdued",size:"xs"},relativeDate)))}if(certStatus===constants["c"].TOO_OLD){var _dss$settings;const ageThreshold=(_dss$settings=dss.settings)===null||_dss$settings===void 0?void 0:_dss$settings.certAgeThreshold;const oldRelativeDate=external_kbnSharedDeps_Moment_default()(cert===null||cert===void 0?void 0:cert.not_before).add(ageThreshold,"days").fromNow();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"danger"},external_kbnSharedDeps_React_default.a.createElement("span",null,certificates_translations["o"],external_kbnSharedDeps_React_default.a.createElement(DateText,{color:"subdued",size:"xs"},oldRelativeDate)))}const okRelativeDate=external_kbnSharedDeps_Moment_default()(cert===null||cert===void 0?void 0:cert.not_after).fromNow(true);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"success"},external_kbnSharedDeps_React_default.a.createElement("span",null,certificates_translations["l"],"  ",external_kbnSharedDeps_React_default.a.createElement(DateText,{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.certs.status.ok.label",defaultMessage:" for {okRelativeDate}",description:'Denotes an amount of time for which a cert is valid. Example: "OK for 2 days"',values:{okRelativeDate:okRelativeDate}}))))};const EmptyButton=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"]).withConfig({displayName:"EmptyButton",componentId:"y9c88-0"})([".euiButtonEmpty__content{padding-right:0px;}"]);const StyledSpan=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"StyledSpan",componentId:"y9c88-1"})(["margin-right:8px;"]);const FingerprintCol=({cert:cert})=>{var _cert$sha1$toUpperCas,_cert$sha,_cert$sha256$toUpperC,_cert$sha2;const ShaComponent=({text:text,val:val})=>external_kbnSharedDeps_React_default.a.createElement(StyledSpan,{"data-test-subj":val,className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:val},external_kbnSharedDeps_React_default.a.createElement(EmptyButton,null,text," ")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCopy"],{textToCopy:val!==null&&val!==void 0?val:""},copy=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":certificates_translations["c"],onClick:copy,iconType:"copy",title:certificates_translations["c"]})));return external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(ShaComponent,{text:"SHA 1",val:(_cert$sha1$toUpperCas=cert===null||cert===void 0?void 0:(_cert$sha=cert.sha1)===null||_cert$sha===void 0?void 0:_cert$sha.toUpperCase())!==null&&_cert$sha1$toUpperCas!==void 0?_cert$sha1$toUpperCas:""}),external_kbnSharedDeps_React_default.a.createElement(ShaComponent,{text:"SHA 256",val:(_cert$sha256$toUpperC=cert===null||cert===void 0?void 0:(_cert$sha2=cert.sha256)===null||_cert$sha2===void 0?void 0:_cert$sha2.toUpperCase())!==null&&_cert$sha256$toUpperC!==void 0?_cert$sha256$toUpperC:""}))};const CertificateList=({page:page,sort:sort,onChange:onChange})=>{var _certificates$total,_certificates$certs;const{data:certificates,loading:loading}=Object(lib["useSelector"])(certificates_certificates["b"]);const onTableChange=newVal=>{onChange(newVal.page,newVal.sort)};const pagination={pageIndex:page.index,pageSize:page.size,totalItemCount:(_certificates$total=certificates===null||certificates===void 0?void 0:certificates.total)!==null&&_certificates$total!==void 0?_certificates$total:0,pageSizeOptions:[10,25,50,100],hidePerPageOptions:false};const columns=[{field:"not_after",name:certificates_translations["n"],sortable:true,render:(val,item)=>external_kbnSharedDeps_React_default.a.createElement(CertStatus,{cert:item})},{name:certificates_translations["b"],field:"common_name",sortable:true},{name:certificates_translations["j"],field:"monitors",render:monitors=>external_kbnSharedDeps_React_default.a.createElement(CertMonitors,{monitors:monitors})},{name:certificates_translations["i"],field:"issuer",sortable:true},{name:certificates_translations["p"],field:"not_after",sortable:true,render:value=>external_kbnSharedDeps_Moment_default()(value).format("L LT")},{name:certificates_translations["a"],field:"not_before",sortable:true,render:value=>external_kbnSharedDeps_Moment_default()().diff(external_kbnSharedDeps_Moment_default()(value),"days")+" "+certificates_translations["d"]},{name:certificates_translations["h"],field:"sha256",render:(val,item)=>external_kbnSharedDeps_React_default.a.createElement(FingerprintCol,{cert:item})}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{loading:loading,columns:columns,items:(_certificates$certs=certificates===null||certificates===void 0?void 0:certificates.certs)!==null&&_certificates$certs!==void 0?_certificates$certs:[],pagination:pagination,onChange:onTableChange,sorting:{sort:{field:sort.field,direction:sort.direction}},noItemsMessage:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"uptimeCertsEmptyMessage"},certificates_translations["k"])})};const certificates_DEFAULT_PAGE_SIZE=10;const certificates_LOCAL_STORAGE_KEY="xpack.uptime.certList.pageSize";const certificates_getPageSizeValue=()=>{var _localStorage$getItem;const value=parseInt((_localStorage$getItem=localStorage.getItem(certificates_LOCAL_STORAGE_KEY))!==null&&_localStorage$getItem!==void 0?_localStorage$getItem:"",10);if(isNaN(value)){return certificates_DEFAULT_PAGE_SIZE}return value};const CertificatesPage=()=>{var _certificates$total;Object(observability_public_["useTrackPageview"])({app:"uptime",path:"certificates"});Object(observability_public_["useTrackPageview"])({app:"uptime",path:"certificates",delay:15e3});useBreadcrumbs([{text:"Certificates"}]);const[page,setPage]=Object(external_kbnSharedDeps_React_["useState"])({index:0,size:certificates_getPageSizeValue()});const[sort,setSort]=Object(external_kbnSharedDeps_React_["useState"])({field:"not_after",direction:"asc"});const[search,setSearch]=Object(external_kbnSharedDeps_React_["useState"])("");const dispatch=Object(lib["useDispatch"])();const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(dynamic_settings["a"])())},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(certificates_certificates["d"].get({search:search,...page,sortBy:sort.field,direction:sort.direction}))},[dispatch,page,search,sort.direction,sort.field,lastRefresh]);const{data:certificates}=Object(lib["useSelector"])(certificates_certificates["b"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.certificates.heading",defaultMessage:"TLS Certificates ({total})",values:{total:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"uptimeCertTotal"},(_certificates$total=certificates===null||certificates===void 0?void 0:certificates.total)!==null&&_certificates$total!==void 0?_certificates$total:0)}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(CertificateSearch,{setSearch:setSearch}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(CertificateList,{page:page,onChange:(pageVal,sortVal)=>{setPage(pageVal);setSort(sortVal);localStorage.setItem(certificates_LOCAL_STORAGE_KEY,pageVal.size.toString())},sort:sort}))};const baseTitle="Uptime - Kibana";const Routes=[{title:`Monitor | ${baseTitle}`,path:constants["m"],component:MonitorPage,dataTestSubj:"uptimeMonitorPage",telemetryId:hooks["a"].Monitor,headerProps:{showDatePicker:true,showMonitorTitle:true}},{title:`Settings | ${baseTitle}`,path:constants["p"],component:SettingsPage,dataTestSubj:"uptimeSettingsPage",telemetryId:hooks["a"].Settings,headerProps:{showTabs:true}},{title:`Certificates | ${baseTitle}`,path:constants["b"],component:CertificatesPage,dataTestSubj:"uptimeCertificatesPage",telemetryId:hooks["a"].Certificates,headerProps:{showCertificateRefreshBtn:true,showTabs:true}},{title:baseTitle,path:constants["t"],component:StepDetailPage,dataTestSubj:"uptimeStepDetailPage",telemetryId:hooks["a"].StepDetail},{title:baseTitle,path:constants["o"],component:OverviewPage,dataTestSubj:"uptimeOverviewPage",telemetryId:hooks["a"].Overview,headerProps:{showDatePicker:true,showTabs:true}}];const RouteInit=({path:path,title:title,telemetryId:telemetryId})=>{Object(hooks["g"])(telemetryId);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{document.title=title},[path,title]);return null};const PageRouter=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:[...Routes.map(route=>route.path)],exact:true,render:({match:match})=>{const routeProps=Routes.find(route=>(route===null||route===void 0?void 0:route.path)===(match===null||match===void 0?void 0:match.path));return(routeProps===null||routeProps===void 0?void 0:routeProps.headerProps)&&external_kbnSharedDeps_React_default.a.createElement(PageHeader,routeProps===null||routeProps===void 0?void 0:routeProps.headerProps)}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,Routes.map(({title:title,path:path,component:RouteComponent,dataTestSubj:dataTestSubj,telemetryId:telemetryId})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:path,key:telemetryId,exact:true},external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":dataTestSubj},external_kbnSharedDeps_React_default.a.createElement(RouteInit,{title:title,path:path,telemetryId:telemetryId}),external_kbnSharedDeps_React_default.a.createElement(RouteComponent,null)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{component:NotFoundPage})));var overview_alerts=__webpack_require__(71);var state=__webpack_require__(83);var kibana_service=__webpack_require__(51);const ADD_DATA_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.addDataButtonLabel",{defaultMessage:"Add data"});const ActionMenu=({appMountParameters:appMountParameters})=>{var _kibana$services,_kibana$services$appl;const kibana=Object(public_["useKibana"])();return external_kbnSharedDeps_React_default.a.createElement(observability_public_["HeaderMenuPortal"],{setHeaderActionMenu:appMountParameters.setHeaderActionMenu},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexEnd",responsive:false,style:{paddingRight:20}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:(_kibana$services=kibana.services)===null||_kibana$services===void 0?void 0:(_kibana$services$appl=_kibana$services.application)===null||_kibana$services$appl===void 0?void 0:_kibana$services$appl.getUrlForApp("/home#/tutorial/uptimeMonitors"),color:"primary",iconType:"indexOpen"},ADD_DATA_LABEL))))};const Application=props=>{const{basePath:basePath,canSave:canSave,core:core,darkMode:darkMode,i18n:i18nCore,plugins:plugins,renderGlobalHelpControls:renderGlobalHelpControls,setBadge:setBadge,startPlugins:startPlugins,appMountParameters:appMountParameters}=props;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{renderGlobalHelpControls();setBadge(!canSave?{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.badge.readOnly.text",{defaultMessage:"Read only"}),tooltip:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.badge.readOnly.tooltip",{defaultMessage:"Unable to save"}),iconType:"glasses"}:undefined)},[canSave,renderGlobalHelpControls,setBadge]);kibana_service["a"].core=core;state["a"].dispatch(Object(actions["I"])(basePath));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(i18nCore.Context,null,external_kbnSharedDeps_React_default.a.createElement(lib["Provider"],{store:state["a"]},external_kbnSharedDeps_React_default.a.createElement(public_["KibanaContextProvider"],{services:{...core,...plugins,triggersActionsUi:startPlugins.triggersActionsUi}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:appMountParameters.history},external_kbnSharedDeps_React_default.a.createElement(common_["EuiThemeProvider"],{darkMode:darkMode},external_kbnSharedDeps_React_default.a.createElement(contexts["b"],null,external_kbnSharedDeps_React_default.a.createElement(contexts["d"],props,external_kbnSharedDeps_React_default.a.createElement(contexts["h"],{darkMode:darkMode},external_kbnSharedDeps_React_default.a.createElement(contexts["f"],startPlugins,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],{className:"app-wrapper-panel ","data-test-subj":"uptimeApp"},external_kbnSharedDeps_React_default.a.createElement(public_["RedirectAppLinks"],{application:core.application},external_kbnSharedDeps_React_default.a.createElement("main",null,external_kbnSharedDeps_React_default.a.createElement(overview_alerts["c"],null),external_kbnSharedDeps_React_default.a.createElement(PageRouter,null),external_kbnSharedDeps_React_default.a.createElement(ActionMenu,{appMountParameters:appMountParameters}))))))))))))))};const UptimeApp=props=>external_kbnSharedDeps_React_default.a.createElement(Application,props);function renderApp(core,plugins,startPlugins,appMountParameters){var _capabilities$uptime$;const{application:{capabilities:capabilities},chrome:{setBadge:setBadge,setHelpExtension:setHelpExtension},docLinks:{DOC_LINK_VERSION:DOC_LINK_VERSION,ELASTIC_WEBSITE_URL:ELASTIC_WEBSITE_URL},http:{basePath:basePath},i18n:i18n}=core;const{apm:apm,infrastructure:infrastructure,logs:logs}=getIntegratedAppAvailability(capabilities,constants["j"]);const canSave=(_capabilities$uptime$=capabilities.uptime.save)!==null&&_capabilities$uptime$!==void 0?_capabilities$uptime$:false;const props={plugins:plugins,canSave:canSave,core:core,i18n:i18n,startPlugins:startPlugins,basePath:basePath.get(),darkMode:core.uiSettings.get(constants["g"]),commonlyUsedRanges:core.uiSettings.get(constants["h"]),isApmAvailable:apm,isInfraAvailable:infrastructure,isLogsAvailable:logs,renderGlobalHelpControls:()=>setHelpExtension({appName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.header.appName",{defaultMessage:"Uptime"}),links:[{linkType:"documentation",href:`${ELASTIC_WEBSITE_URL}guide/en/uptime/${DOC_LINK_VERSION}/uptime-app-overview.html`},{linkType:"discuss",href:"https://discuss.elastic.co/c/uptime"}]}),setBadge:setBadge,appMountParameters:appMountParameters,setBreadcrumbs:core.chrome.setBreadcrumbs};external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(UptimeApp,props),appMountParameters.element);return()=>{external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(appMountParameters.element)}}},70:function(module,exports){}}]);