/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["uptime_bundle_jsonpfunction"]=window["uptime_bundle_jsonpfunction"]||[]).push([[3],Array(35).concat([function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"d",(function(){return useMonitorId}));__webpack_require__.d(__webpack_exports__,"c",(function(){return use_url_params["a"]}));__webpack_require__.d(__webpack_exports__,"h",(function(){return use_url_params["b"]}));__webpack_require__.d(__webpack_exports__,"a",(function(){return UptimePage}));__webpack_require__.d(__webpack_exports__,"g",(function(){return useUptimeTelemetry}));__webpack_require__.d(__webpack_exports__,"f",(function(){return useUpdateKueryString}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useCertStatus}));__webpack_require__.d(__webpack_exports__,"e",(function(){return useSearchText}));var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);const useMonitorId=()=>{const{monitorId:monitorId}=Object(external_kbnSharedDeps_ReactRouterDom_["useParams"])();return atob(monitorId||"")};var use_url_params=__webpack_require__(62);var external_kbnSharedDeps_React_=__webpack_require__(1);var utils=__webpack_require__(39);var constants=__webpack_require__(34);let UptimePage;(function(UptimePage){UptimePage["Overview"]="Overview";UptimePage["Monitor"]="Monitor";UptimePage["Settings"]="Settings";UptimePage["Certificates"]="Certificates";UptimePage["StepDetail"]="StepDetail";UptimePage["NotFound"]="__not-found__"})(UptimePage||(UptimePage={}));const useUptimeTelemetry=page=>{const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,autorefreshInterval:autorefreshInterval,autorefreshIsPaused:autorefreshIsPaused}=Object(use_url_params["a"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!utils["a"].http)throw new Error("Core http services are not defined");const params={page:page,autorefreshInterval:autorefreshInterval/1e3,dateStart:dateRangeStart,dateEnd:dateRangeEnd,autoRefreshEnabled:!autorefreshIsPaused};utils["a"].post(constants["a"].LOG_PAGE_VIEW,params)},[autorefreshInterval,autorefreshIsPaused,dateRangeEnd,dateRangeStart,page])};var public_=__webpack_require__(23);var lib=__webpack_require__(86);const getKueryString=urlFilters=>{let kueryString="";try{if(urlFilters!==""){const filterMap=new Map(JSON.parse(urlFilters));kueryString=Object(lib["c"])(filterMap)}}catch{kueryString=""}return kueryString};const useUpdateKueryString=(indexPattern,filterQueryString="",urlFilters)=>{const kueryString=getKueryString(urlFilters);const combinedFilterString=Object(lib["a"])(filterQueryString,kueryString);let esFilters;try{if((filterQueryString||urlFilters)&&indexPattern){const ast=public_["esKuery"].fromKueryExpression(combinedFilterString);const elasticsearchQuery=public_["esKuery"].toElasticsearchQuery(ast,indexPattern);esFilters=JSON.stringify(elasticsearchQuery)}return[esFilters]}catch(err){return[urlFilters,err]}};var external_kbnSharedDeps_Moment_=__webpack_require__(13);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var react_redux_lib=__webpack_require__(32);var selectors=__webpack_require__(37);const useCertStatus=(expiryDate,issueDate)=>{var _dss$settings,_dss$settings2;const dss=Object(react_redux_lib["useSelector"])(selectors["A"]);const expiryThreshold=(_dss$settings=dss.settings)===null||_dss$settings===void 0?void 0:_dss$settings.certExpirationThreshold;const ageThreshold=(_dss$settings2=dss.settings)===null||_dss$settings2===void 0?void 0:_dss$settings2.certAgeThreshold;const certValidityDate=new Date(expiryDate!==null&&expiryDate!==void 0?expiryDate:"");const isValidDate=!isNaN(certValidityDate.valueOf());if(!isValidDate){return false}const isExpiringSoon=external_kbnSharedDeps_Moment_default()(certValidityDate).diff(external_kbnSharedDeps_Moment_default()(),"days")<expiryThreshold;const isTooOld=external_kbnSharedDeps_Moment_default()().diff(external_kbnSharedDeps_Moment_default()(issueDate),"days")>ageThreshold;const isExpired=external_kbnSharedDeps_Moment_default()(certValidityDate)<external_kbnSharedDeps_Moment_default()();if(isExpired){return constants["c"].EXPIRED}return isExpiringSoon?constants["c"].EXPIRING_SOON:isTooOld?constants["c"].TOO_OLD:constants["c"].OK};var actions=__webpack_require__(33);const useSearchText=()=>{const dispatch=Object(react_redux_lib["useDispatch"])();const searchText=Object(react_redux_lib["useSelector"])(selectors["w"]);const updateSearchText=Object(external_kbnSharedDeps_React_["useCallback"])(nextSearchText=>dispatch(Object(actions["L"])(nextSearchText)),[dispatch]);return{searchText:searchText,updateSearchText:updateSearchText}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return UptimeRefreshContext}));__webpack_require__.d(__webpack_exports__,"b",(function(){return UptimeRefreshContextProvider}));__webpack_require__.d(__webpack_exports__,"c",(function(){return UptimeSettingsContext}));__webpack_require__.d(__webpack_exports__,"d",(function(){return UptimeSettingsContextProvider}));__webpack_require__.d(__webpack_exports__,"h",(function(){return UptimeThemeContextProvider}));__webpack_require__.d(__webpack_exports__,"g",(function(){return UptimeThemeContext}));__webpack_require__.d(__webpack_exports__,"e",(function(){return UptimeStartupPluginsContext}));__webpack_require__.d(__webpack_exports__,"f",(function(){return UptimeStartupPluginsContextProvider}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);const defaultContext={lastRefresh:0,refreshApp:()=>{throw new Error("App refresh was not initialized, set it when you invoke the context")}};const UptimeRefreshContext=Object(external_kbnSharedDeps_React_["createContext"])(defaultContext);const UptimeRefreshContextProvider=({children:children})=>{const[lastRefresh,setLastRefresh]=Object(external_kbnSharedDeps_React_["useState"])(Date.now());const refreshApp=()=>{const refreshTime=Date.now();setLastRefresh(refreshTime)};const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({lastRefresh:lastRefresh,refreshApp:refreshApp}),[lastRefresh]);return external_kbnSharedDeps_React_default.a.createElement(UptimeRefreshContext.Provider,{value:value,children:children})};var constants=__webpack_require__(34);var hooks=__webpack_require__(35);const{BASE_PATH:BASE_PATH}=constants["f"];const{DATE_RANGE_START:DATE_RANGE_START,DATE_RANGE_END:DATE_RANGE_END}=constants["e"];const uptime_settings_context_defaultContext={basePath:BASE_PATH,dateRangeStart:DATE_RANGE_START,dateRangeEnd:DATE_RANGE_END,isApmAvailable:true,isInfraAvailable:true,isLogsAvailable:true};const UptimeSettingsContext=Object(external_kbnSharedDeps_React_["createContext"])(uptime_settings_context_defaultContext);const UptimeSettingsContextProvider=({children:children,...props})=>{const{basePath:basePath,isApmAvailable:isApmAvailable,isInfraAvailable:isInfraAvailable,isLogsAvailable:isLogsAvailable,commonlyUsedRanges:commonlyUsedRanges}=props;const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd}=Object(hooks["c"])();const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({basePath:basePath,isApmAvailable:isApmAvailable,isInfraAvailable:isInfraAvailable,isLogsAvailable:isLogsAvailable,commonlyUsedRanges:commonlyUsedRanges,dateRangeStart:dateRangeStart!==null&&dateRangeStart!==void 0?dateRangeStart:DATE_RANGE_START,dateRangeEnd:dateRangeEnd!==null&&dateRangeEnd!==void 0?dateRangeEnd:DATE_RANGE_END}),[basePath,isApmAvailable,isInfraAvailable,isLogsAvailable,dateRangeStart,dateRangeEnd,commonlyUsedRanges]);return external_kbnSharedDeps_React_default.a.createElement(UptimeSettingsContext.Provider,{value:value,children:children})};var external_kbnSharedDeps_Theme_euiLightVars_=__webpack_require__(25);var external_kbnSharedDeps_Theme_euiLightVars_default=__webpack_require__.n(external_kbnSharedDeps_Theme_euiLightVars_);var external_kbnSharedDeps_Theme_euiDarkVars_=__webpack_require__(26);var external_kbnSharedDeps_Theme_euiDarkVars_default=__webpack_require__.n(external_kbnSharedDeps_Theme_euiDarkVars_);var external_kbnSharedDeps_ElasticEuiChartsTheme_=__webpack_require__(24);var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(17);const uptime_theme_context_defaultContext={colors:{danger:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorDanger,dangerBehindText:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorVis9_behindText,mean:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorPrimary,range:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiFocusBackgroundColor,success:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorSuccess,warning:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorWarning,gray:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorLightShade,lightestShade:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorLightestShade},chartTheme:{baseTheme:external_kbnSharedDeps_ElasticCharts_["LIGHT_THEME"],theme:external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_LIGHT"].theme}};const UptimeThemeContext=Object(external_kbnSharedDeps_React_["createContext"])(uptime_theme_context_defaultContext);const UptimeThemeContextProvider=({darkMode:darkMode,children:children})=>{let colors;if(darkMode){colors={danger:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorVis9,dangerBehindText:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorVis9_behindText,mean:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorPrimary,gray:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorLightShade,range:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiFocusBackgroundColor,success:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorSuccess,warning:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorWarning,lightestShade:external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorLightestShade}}else{colors={danger:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorVis9,dangerBehindText:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorVis9_behindText,mean:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorPrimary,gray:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorLightShade,range:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiFocusBackgroundColor,success:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorSuccess,warning:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorWarning,lightestShade:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorLightestShade}}const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({colors:colors,chartTheme:{baseTheme:darkMode?external_kbnSharedDeps_ElasticCharts_["DARK_THEME"]:external_kbnSharedDeps_ElasticCharts_["LIGHT_THEME"],theme:darkMode?external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_DARK"].theme:external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_LIGHT"].theme}}),[colors,darkMode]);return external_kbnSharedDeps_React_default.a.createElement(UptimeThemeContext.Provider,{value:value,children:children})};const UptimeStartupPluginsContext=Object(external_kbnSharedDeps_React_["createContext"])({});const UptimeStartupPluginsContextProvider=({children:children,...props})=>external_kbnSharedDeps_React_default.a.createElement(UptimeStartupPluginsContext.Provider,{value:{...props},children:children})},,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=curry;function curried(f,length,acc){return function fn(){var combined=acc.concat(Array.prototype.slice.call(arguments));return combined.length>=length?f.apply(this,combined):curried(f,length,combined)}}function curry(f){return curried(f,f.length,[])}module.exports=exports["default"]},,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(110);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(69);var _rgba2=_interopRequireDefault(_rgba);var _hsl=__webpack_require__(167);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(169);var _hsla2=_interopRequireDefault(_hsla);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var isRgb=function isRgb(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isRgba=function isRgba(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&typeof color.alpha==="number"};var isHsl=function isHsl(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isHsla=function isHsla(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&typeof color.alpha==="number"};var errMsg="Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.";function toColorString(color){if(typeof color!=="object")throw new Error(errMsg);if(isRgba(color))return(0,_rgba2.default)(color);if(isRgb(color))return(0,_rgb2.default)(color);if(isHsla(color))return(0,_hsla2.default)(color);if(isHsl(color))return(0,_hsl2.default)(color);throw new Error(errMsg)}exports.default=toColorString;module.exports=exports["default"]},,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _rgbToHsl=__webpack_require__(256);var _rgbToHsl2=_interopRequireDefault(_rgbToHsl);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function parseToHsl(color){return(0,_rgbToHsl2.default)((0,_parseToRgb2.default)(color))}exports.default=parseToHsl;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"i",(function(){return URL_LABEL}));__webpack_require__.d(__webpack_exports__,"h",(function(){return TAGS_LABEL}));__webpack_require__.d(__webpack_exports__,"g",(function(){return STATUS_UP_LABEL}));__webpack_require__.d(__webpack_exports__,"e",(function(){return STATUS_DOWN_LABEL}));__webpack_require__.d(__webpack_exports__,"d",(function(){return STATUS_COMPLETE_LABEL}));__webpack_require__.d(__webpack_exports__,"f",(function(){return STATUS_FAILED_LABEL}));__webpack_require__.d(__webpack_exports__,"b",(function(){return SECONDS_LABEL}));__webpack_require__.d(__webpack_exports__,"c",(function(){return SEC_LABEL}));__webpack_require__.d(__webpack_exports__,"a",(function(){return MS_LABEL}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const URL_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.table.url.name",{defaultMessage:"Url"});const TAGS_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.table.tags.name",{defaultMessage:"Tags"});const STATUS_UP_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.statusColumn.upLabel",{defaultMessage:"Up"});const STATUS_DOWN_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.statusColumn.downLabel",{defaultMessage:"Down"});const STATUS_COMPLETE_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.statusColumn.completeLabel",{defaultMessage:"Complete"});const STATUS_FAILED_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.statusColumn.failedLabel",{defaultMessage:"Failed"});const SECONDS_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.seconds.label",{defaultMessage:"seconds"});const SEC_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.seconds.shortForm.label",{defaultMessage:"sec"});const MS_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.millisecond.abbreviation.label",{defaultMessage:"ms"})},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"E",(function(){return SECONDS_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"D",(function(){return SECONDS}));__webpack_require__.d(__webpack_exports__,"x",(function(){return MINUTES_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"w",(function(){return MINUTES}));__webpack_require__.d(__webpack_exports__,"t",(function(){return HOURS_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"s",(function(){return HOURS}));__webpack_require__.d(__webpack_exports__,"e",(function(){return DAYS_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"d",(function(){return DAYS}));__webpack_require__.d(__webpack_exports__,"K",(function(){return WEEKS_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"J",(function(){return WEEKS}));__webpack_require__.d(__webpack_exports__,"z",(function(){return MONTHS_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"y",(function(){return MONTHS}));__webpack_require__.d(__webpack_exports__,"M",(function(){return YEARS_TIME_RANGE}));__webpack_require__.d(__webpack_exports__,"L",(function(){return YEARS}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ALERT_KUERY_BAR_ARIA}));__webpack_require__.d(__webpack_exports__,"A",(function(){return OPEN_THE_POPOVER_DOWN_COUNT}));__webpack_require__.d(__webpack_exports__,"o",(function(){return ENTER_NUMBER_OF_DOWN_COUNTS}));__webpack_require__.d(__webpack_exports__,"v",(function(){return MATCHING_MONITORS_DOWN}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ANY_MONITOR_DOWN}));__webpack_require__.d(__webpack_exports__,"B",(function(){return OPEN_THE_POPOVER_TIME_RANGE_VALUE}));__webpack_require__.d(__webpack_exports__,"p",(function(){return ENTER_NUMBER_OF_TIME_UNITS}));__webpack_require__.d(__webpack_exports__,"q",(function(){return ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"r",(function(){return ENTER_NUMBER_OF_TIME_UNITS_VALUE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ENTER_AVAILABILITY_RANGE_ENABLED}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ENTER_AVAILABILITY_RANGE_POPOVER_ARIA_LABEL}));__webpack_require__.d(__webpack_exports__,"j",(function(){return ENTER_AVAILABILITY_RANGE_UNITS_ARIA_LABEL}));__webpack_require__.d(__webpack_exports__,"k",(function(){return ENTER_AVAILABILITY_RANGE_UNITS_DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"l",(function(){return ENTER_AVAILABILITY_THRESHOLD_ARIA_LABEL}));__webpack_require__.d(__webpack_exports__,"m",(function(){return ENTER_AVAILABILITY_THRESHOLD_DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"n",(function(){return ENTER_AVAILABILITY_THRESHOLD_VALUE}));__webpack_require__.d(__webpack_exports__,"h",(function(){return ENTER_AVAILABILITY_RANGE_SELECT_ARIA}));__webpack_require__.d(__webpack_exports__,"i",(function(){return ENTER_AVAILABILITY_RANGE_SELECT_HEADLINE}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ADD_FILTER}));__webpack_require__.d(__webpack_exports__,"u",(function(){return LOCATION}));__webpack_require__.d(__webpack_exports__,"F",(function(){return TAG}));__webpack_require__.d(__webpack_exports__,"C",(function(){return PORT}));__webpack_require__.d(__webpack_exports__,"G",(function(){return TYPE}));__webpack_require__.d(__webpack_exports__,"H",(function(){return TlsTranslations}));__webpack_require__.d(__webpack_exports__,"I",(function(){return ToggleFlyoutTranslations}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const SECONDS_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.secondsOption.ariaLabel",{defaultMessage:'"Seconds" time range select item'});const SECONDS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.seconds",{defaultMessage:"seconds"});const MINUTES_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.minutesOption.ariaLabel",{defaultMessage:'"Minutes" time range select item'});const MINUTES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.minutes",{defaultMessage:"minutes"});const HOURS_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.hoursOption.ariaLabel",{defaultMessage:'"Hours" time range select item'});const HOURS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.hours",{defaultMessage:"hours"});const DAYS_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.daysOption.ariaLabel",{defaultMessage:'"Days" time range select item'});const DAYS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.days",{defaultMessage:"days"});const WEEKS_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.weeksOption.ariaLabel",{defaultMessage:'"Weeks" time range select item'});const WEEKS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.weeks",{defaultMessage:"weeks"});const MONTHS_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.monthsOption.ariaLabel",{defaultMessage:'"Months" time range select item'});const MONTHS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.months",{defaultMessage:"months"});const YEARS_TIME_RANGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.timerangeUnitSelectable.yearsOption.ariaLabel",{defaultMessage:'"Years" time range select item'});const YEARS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeOption.years",{defaultMessage:"years"});const ALERT_KUERY_BAR_ARIA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.filterBar.ariaLabel",{defaultMessage:"Input that allows filtering criteria for the monitor status alert"});const OPEN_THE_POPOVER_DOWN_COUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.numTimesExpression.ariaLabel",{defaultMessage:"Open the popover for down count input"});const ENTER_NUMBER_OF_DOWN_COUNTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.numTimesField.ariaLabel",{defaultMessage:"Enter number of down counts required to trigger the alert"});const MATCHING_MONITORS_DOWN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.numTimesExpression.matchingMonitors.description",{defaultMessage:"matching monitors are down >"});const ANY_MONITOR_DOWN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.numTimesExpression.anyMonitors.description",{defaultMessage:"any monitor is down >"});const OPEN_THE_POPOVER_TIME_RANGE_VALUE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeValueExpression.ariaLabel",{defaultMessage:"Open the popover for time range value field"});const ENTER_NUMBER_OF_TIME_UNITS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeValueField.ariaLabel",{defaultMessage:`Enter the number of time units for the alert's range`});const ENTER_NUMBER_OF_TIME_UNITS_DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeValueField.expression",{defaultMessage:"within"});const ENTER_NUMBER_OF_TIME_UNITS_VALUE=value=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeValueField.value",{defaultMessage:"last {value}",values:{value:value}});const ENTER_AVAILABILITY_RANGE_ENABLED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.isEnabledCheckbox.label",{defaultMessage:"Availability"});const ENTER_AVAILABILITY_RANGE_POPOVER_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.timerangeValueField.popover.ariaLabel",{defaultMessage:"Specify availability tracking time range"});const ENTER_AVAILABILITY_RANGE_UNITS_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.timerangeValueField.ariaLabel",{defaultMessage:`Enter the number of units for the alert's availability check.`});const ENTER_AVAILABILITY_RANGE_UNITS_DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.timerangeValueField.expression",{defaultMessage:"within the last"});const ENTER_AVAILABILITY_THRESHOLD_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.threshold.ariaLabel",{defaultMessage:"Specify availability thresholds for this alert"});const ENTER_AVAILABILITY_THRESHOLD_INPUT_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.threshold.input.ariaLabel",{defaultMessage:"Input an availability threshold to check for this alert"});const ENTER_AVAILABILITY_THRESHOLD_DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.threshold.description",{defaultMessage:"matching monitors are up in",description:"This fragment explains that an alert will fire for monitors matching user-specified criteria"});const ENTER_AVAILABILITY_THRESHOLD_VALUE=value=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.threshold.value",{defaultMessage:"< {value}% of checks",description:"This fragment specifies criteria that will cause an alert to fire for uptime monitors",values:{value:value}});const ENTER_AVAILABILITY_RANGE_SELECT_ARIA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.unit.selectable",{defaultMessage:"Use this select to set the availability range units for this alert"});const ENTER_AVAILABILITY_RANGE_SELECT_HEADLINE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.availability.unit.headline",{defaultMessage:"Select time range unit"});const ADD_FILTER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.addFilter",{defaultMessage:`Add filter`});const LOCATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.addFilter.location",{defaultMessage:`Location`});const TAG=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.addFilter.tag",{defaultMessage:`Tag`});const PORT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.addFilter.port",{defaultMessage:`Port`});const TYPE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.monitorStatus.addFilter.type",{defaultMessage:`Type`});const TlsTranslations={criteriaAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.criteriaExpression.ariaLabel",{defaultMessage:"An expression displaying the criteria for monitor that are watched by this alert"}),criteriaDescription:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.criteriaExpression.description",{defaultMessage:"when",description:'The context of this `when` is in the conditional sense, like "when there are three cookies, eat them all".'}),criteriaValue:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.criteriaExpression.value",{defaultMessage:"any monitor"}),expirationAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.expirationExpression.ariaLabel",{defaultMessage:"An expression displaying the threshold that will trigger the TLS alert for certificate expiration"}),expirationDescription:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.expirationExpression.description",{defaultMessage:"has a certificate expiring within"}),expirationValue:value=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.expirationExpression.value",{defaultMessage:"{value} days",values:{value:value}}),ageAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.ageExpression.ariaLabel",{defaultMessage:"An expressing displaying the threshold that will trigger the TLS alert for old certificates"}),ageDescription:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.ageExpression.description",{defaultMessage:"or older than"}),ageValue:value=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alerts.tls.ageExpression.value",{defaultMessage:"{value} days",values:{value:value}})};const ToggleFlyoutTranslations={toggleButtonAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.alertsPopover.toggleButton.ariaLabel",{defaultMessage:"Open alert context menu"}),openAlertContextPanelAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.openAlertContextPanel.ariaLabel",{defaultMessage:"Open the alert context panel so you can choose an alert type"}),openAlertContextPanelLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.openAlertContextPanel.label",{defaultMessage:"Create alert"}),toggleTlsAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.toggleTlsAlertButton.ariaLabel",{defaultMessage:"Open TLS alert flyout"}),toggleTlsContent:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.toggleTlsAlertButton.content",{defaultMessage:"TLS alert"}),toggleMonitorStatusAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.toggleAlertFlyout.ariaLabel",{defaultMessage:"Open add alert flyout"}),toggleMonitorStatusContent:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.toggleAlertButton.content",{defaultMessage:"Monitor status alert"}),navigateToAlertingUIAriaLabel:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.navigateToAlertingUi",{defaultMessage:"Leave Uptime and go to Alerting Management page"}),navigateToAlertingButtonContent:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.navigateToAlertingButton.content",{defaultMessage:"Manage alerts"})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(109);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _nameToHex=__webpack_require__(255);var _nameToHex2=_interopRequireDefault(_nameToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var hexRegex=/^#[a-fA-F0-9]{6}$/;var reducedHexRegex=/^#[a-fA-F0-9]{3}$/;var rgbRegex=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/;var rgbaRegex=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;var hslRegex=/^hsl\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*\)$/;var hslaRegex=/^hsla\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;function parseToRgb(color){if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}var normalizedColor=(0,_nameToHex2.default)(color);if(normalizedColor.match(hexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[2],16),green:parseInt(""+normalizedColor[3]+normalizedColor[4],16),blue:parseInt(""+normalizedColor[5]+normalizedColor[6],16)}}if(normalizedColor.match(reducedHexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[1],16),green:parseInt(""+normalizedColor[2]+normalizedColor[2],16),blue:parseInt(""+normalizedColor[3]+normalizedColor[3],16)}}var rgbMatched=rgbRegex.exec(normalizedColor);if(rgbMatched){return{red:parseInt(""+rgbMatched[1],10),green:parseInt(""+rgbMatched[2],10),blue:parseInt(""+rgbMatched[3],10)}}var rgbaMatched=rgbaRegex.exec(normalizedColor);if(rgbaMatched){return{red:parseInt(""+rgbaMatched[1],10),green:parseInt(""+rgbaMatched[2],10),blue:parseInt(""+rgbaMatched[3],10),alpha:parseFloat(""+rgbaMatched[4])}}var hslMatched=hslRegex.exec(normalizedColor);if(hslMatched){var hue=parseInt(""+hslMatched[1],10);var saturation=parseInt(""+hslMatched[2],10)/100;var lightness=parseInt(""+hslMatched[3],10)/100;var rgbColorString="rgb("+(0,_hslToRgb2.default)(hue,saturation,lightness)+")";var hslRgbMatched=rgbRegex.exec(rgbColorString);return{red:parseInt(""+hslRgbMatched[1],10),green:parseInt(""+hslRgbMatched[2],10),blue:parseInt(""+hslRgbMatched[3],10)}}var hslaMatched=hslaRegex.exec(normalizedColor);if(hslaMatched){var _hue=parseInt(""+hslaMatched[1],10);var _saturation=parseInt(""+hslaMatched[2],10)/100;var _lightness=parseInt(""+hslaMatched[3],10)/100;var _rgbColorString="rgb("+(0,_hslToRgb2.default)(_hue,_saturation,_lightness)+")";var _hslRgbMatched=rgbRegex.exec(_rgbColorString);return{red:parseInt(""+_hslRgbMatched[1],10),green:parseInt(""+_hslRgbMatched[2],10),blue:parseInt(""+_hslRgbMatched[3],10),alpha:parseFloat(""+hslaMatched[4])}}throw new Error("Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.")}exports.default=parseToRgb;module.exports=exports["default"]},,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _capitalizeString=__webpack_require__(162);var _capitalizeString2=_interopRequireDefault(_capitalizeString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var positionMap=["Top","Right","Bottom","Left"];function generateProperty(property,position){if(!property)return position.toLowerCase();var splitProperty=property.split("-");if(splitProperty.length>1){splitProperty.splice(1,0,position);return splitProperty.reduce((function(acc,val){return""+acc+(0,_capitalizeString2.default)(val)}))}var joinedProperty=property.replace(/([a-z])([A-Z])/g,"$1"+position+"$2");return property===joinedProperty?""+property+position:joinedProperty}function generateStyles(property,valuesWithDefaults){var styles={};for(var i=0;i<valuesWithDefaults.length;i+=1){if(valuesWithDefaults[i]||valuesWithDefaults[i]===0){styles[generateProperty(property,positionMap[i])]=valuesWithDefaults[i]}}return styles}function directionalProperty(property){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}var firstValue=values[0],_values$=values[1],secondValue=_values$===undefined?firstValue:_values$,_values$2=values[2],thirdValue=_values$2===undefined?firstValue:_values$2,_values$3=values[3],fourthValue=_values$3===undefined?secondValue:_values$3;var valuesWithDefaults=[firstValue,secondValue,thirdValue,fourthValue];return generateStyles(property,valuesWithDefaults)}exports.default=directionalProperty;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"l",(function(){return OK}));__webpack_require__.d(__webpack_exports__,"e",(function(){return EXPIRED}));__webpack_require__.d(__webpack_exports__,"g",(function(){return EXPIRES_SOON}));__webpack_require__.d(__webpack_exports__,"f",(function(){return EXPIRES}));__webpack_require__.d(__webpack_exports__,"m",(function(){return SEARCH_CERTS}));__webpack_require__.d(__webpack_exports__,"n",(function(){return STATUS_COL}));__webpack_require__.d(__webpack_exports__,"o",(function(){return TOO_OLD}));__webpack_require__.d(__webpack_exports__,"b",(function(){return COMMON_NAME_COL}));__webpack_require__.d(__webpack_exports__,"j",(function(){return MONITORS_COL}));__webpack_require__.d(__webpack_exports__,"i",(function(){return ISSUED_BY_COL}));__webpack_require__.d(__webpack_exports__,"p",(function(){return VALID_UNTIL_COL}));__webpack_require__.d(__webpack_exports__,"a",(function(){return AGE_COL}));__webpack_require__.d(__webpack_exports__,"d",(function(){return DAYS}));__webpack_require__.d(__webpack_exports__,"h",(function(){return FINGERPRINTS_COL}));__webpack_require__.d(__webpack_exports__,"c",(function(){return COPY_FINGERPRINT}));__webpack_require__.d(__webpack_exports__,"k",(function(){return NO_CERTS_AVAILABLE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const OK=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.ok",{defaultMessage:"OK"});const EXPIRED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.expired",{defaultMessage:"Expired"});const EXPIRES_SOON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.expireSoon",{defaultMessage:"Expires soon"});const EXPIRES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.expires",{defaultMessage:"Expires"});const SEARCH_CERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.searchCerts",{defaultMessage:"Search certificates"});const STATUS_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.status",{defaultMessage:"Status"});const TOO_OLD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.status.old",{defaultMessage:"Too old"});const COMMON_NAME_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.commonName",{defaultMessage:"Common name"});const MONITORS_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.monitors",{defaultMessage:"Monitors"});const ISSUED_BY_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.issuedBy",{defaultMessage:"Issued by"});const VALID_UNTIL_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.validUntil",{defaultMessage:"Valid until"});const AGE_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.ageCol",{defaultMessage:"Age"});const DAYS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.days",{defaultMessage:"days"});const FINGERPRINTS_COL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.expirationDate",{defaultMessage:"Fingerprints"});const COPY_FINGERPRINT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.copyFingerprint",{defaultMessage:"Click to copy fingerprint value"});const NO_CERTS_AVAILABLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.certs.list.empty",{defaultMessage:"No Certificates found. Note: Certificates are only visible for Heartbeat 7.8+"})},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function guard(lowerBoundary,upperBoundary,value){return Math.max(lowerBoundary,Math.min(upperBoundary,value))}exports.default=guard;module.exports=exports["default"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return convertMicrosecondsToMilliseconds}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getApmHref}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getInfraContainerHref}));__webpack_require__.d(__webpack_exports__,"e",(function(){return getInfraIpHref}));__webpack_require__.d(__webpack_exports__,"f",(function(){return getInfraKubernetesHref}));__webpack_require__.d(__webpack_exports__,"g",(function(){return getLoggingContainerHref}));__webpack_require__.d(__webpack_exports__,"h",(function(){return getLoggingIpHref}));__webpack_require__.d(__webpack_exports__,"i",(function(){return getLoggingKubernetesHref}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getChartDateLabel}));__webpack_require__.d(__webpack_exports__,"k",(function(){return seriesHasDownValues}));__webpack_require__.d(__webpack_exports__,"j",(function(){return getSupportedUrlParams}));const NUM_MICROSECONDS_IN_MILLISECOND=1e3;const convertMicrosecondsToMilliseconds=microseconds=>{if(!microseconds&&microseconds!==0)return null;return Math.floor(microseconds/NUM_MICROSECONDS_IN_MILLISECOND)};const addBasePath=(basePath,url)=>`${basePath.length>0?`${basePath}`:""}${url}`;const getApmHref=(summary,basePath,dateRangeStart,dateRangeEnd)=>{var _summary$state,_summary$state$servic,_summary$state$url;const clause=summary!==null&&summary!==void 0&&(_summary$state=summary.state)!==null&&_summary$state!==void 0&&(_summary$state$servic=_summary$state.service)!==null&&_summary$state$servic!==void 0&&_summary$state$servic.name?`service.name: "${summary.state.service.name}"`:`url.domain: "${(_summary$state$url=summary.state.url)===null||_summary$state$url===void 0?void 0:_summary$state$url.domain}"`;return addBasePath(basePath,`/app/apm#/services?kuery=${encodeURI(clause)}&rangeFrom=${dateRangeStart}&rangeTo=${dateRangeEnd}`)};const buildHref=(summaryPings,getData,getHref)=>{const queryValue=summaryPings.map(ping=>getData(ping)).filter(value=>value!==undefined);if(queryValue.length===0){return getHref(undefined)}return queryValue.length===1?getHref(queryValue[0]):getHref(queryValue)};const getInfraContainerHref=(summary,basePath)=>{const getHref=value=>{if(!value){return undefined}const ret=!Array.isArray(value)?value:value[0];return addBasePath(basePath,`/app/metrics/link-to/container-detail/${encodeURIComponent(ret)}`)};return buildHref(summary.state.summaryPings||[],ping=>{var _ping$container;return ping===null||ping===void 0?void 0:(_ping$container=ping.container)===null||_ping$container===void 0?void 0:_ping$container.id},getHref)};const getInfraKubernetesHref=(summary,basePath)=>{const getHref=value=>{if(!value){return undefined}const ret=!Array.isArray(value)?value:value[0];return addBasePath(basePath,`/app/metrics/link-to/pod-detail/${encodeURIComponent(ret)}`)};return buildHref(summary.state.summaryPings||[],ping=>{var _ping$kubernetes,_ping$kubernetes$pod;return ping===null||ping===void 0?void 0:(_ping$kubernetes=ping.kubernetes)===null||_ping$kubernetes===void 0?void 0:(_ping$kubernetes$pod=_ping$kubernetes.pod)===null||_ping$kubernetes$pod===void 0?void 0:_ping$kubernetes$pod.uid},getHref)};const getInfraIpHref=(summary,basePath)=>{const getHref=value=>{if(!value){return undefined}if(!Array.isArray(value)){const expression=encodeURIComponent(`host.ip : ${value}`);return addBasePath(basePath,`/app/metrics/inventory?waffleFilter=(expression:'${expression}',kind:kuery)`)}const ips=value.reduce((str,cur)=>!str?`host.ip : ${cur}`:str+` or host.ip : ${cur}`,"");return ips===""?undefined:addBasePath(basePath,`/app/metrics/inventory?waffleFilter=(expression:'${encodeURIComponent(ips)}',kind:kuery)`)};return buildHref(summary.state.summaryPings||[],ping=>{var _ping$monitor;return ping===null||ping===void 0?void 0:(_ping$monitor=ping.monitor)===null||_ping$monitor===void 0?void 0:_ping$monitor.ip},getHref)};const getLoggingContainerHref=(summary,basePath)=>{const getHref=value=>{if(!value){return undefined}const ret=!Array.isArray(value)?value:value[0];return addBasePath(basePath,`/app/logs?logFilter=${encodeURI(`(expression:'container.id : ${ret}',kind:kuery)`)}`)};return buildHref(summary.state.summaryPings||[],ping=>{var _ping$container;return ping===null||ping===void 0?void 0:(_ping$container=ping.container)===null||_ping$container===void 0?void 0:_ping$container.id},getHref)};const getLoggingKubernetesHref=(summary,basePath)=>{const getHref=value=>{if(!value){return undefined}const ret=!Array.isArray(value)?value:value[0];return addBasePath(basePath,`/app/logs?logFilter=${encodeURI(`(expression:'pod.uid : ${ret}',kind:kuery)`)}`)};return buildHref(summary.state.summaryPings||[],ping=>{var _ping$kubernetes,_ping$kubernetes$pod;return ping===null||ping===void 0?void 0:(_ping$kubernetes=ping.kubernetes)===null||_ping$kubernetes===void 0?void 0:(_ping$kubernetes$pod=_ping$kubernetes.pod)===null||_ping$kubernetes$pod===void 0?void 0:_ping$kubernetes$pod.uid},getHref)};const getLoggingIpHref=(summary,basePath)=>{const getHref=value=>{if(!value){return undefined}const ret=!Array.isArray(value)?value:value[0];return addBasePath(basePath,`/app/logs?logFilter=(expression:'${encodeURIComponent(`host.ip : ${ret}`)}',kind:kuery)`)};return buildHref(summary.state.summaryPings||[],ping=>{var _ping$monitor;return ping===null||ping===void 0?void 0:(_ping$monitor=ping.monitor)===null||_ping$monitor===void 0?void 0:_ping$monitor.ip},getHref)};const isWithinCurrentDate=(dateRangeStart,dateRangeEnd)=>{const today=new Date(Date.now());const min=today.setHours(0,0,0,0).valueOf();const max=today.setHours(23,59,59,999).valueOf();return dateRangeStart>min&&dateRangeStart<max&&dateRangeEnd<max};var constants=__webpack_require__(34);const{EIGHT_MINUTES:EIGHT_MINUTES,FOUR_YEARS:FOUR_YEARS,THIRTY_SIX_HOURS:THIRTY_SIX_HOURS,THREE_WEEKS:THREE_WEEKS,SIX_MONTHS:SIX_MONTHS,NINE_DAYS:NINE_DAYS}=constants["d"];const dateStops=[{key:EIGHT_MINUTES,value:"HH:mm:ss"},{key:THIRTY_SIX_HOURS,value:"HH:mm"},{key:NINE_DAYS,value:"MM-DD HH:mm"},{key:THREE_WEEKS,value:"MM-DD"},{key:SIX_MONTHS,value:"YYYY-MM-DD"},{key:FOUR_YEARS,value:"YYYY-MM"}];const getLabelFormat=delta=>{for(let index=0;index<dateStops.length;index+=1){const{key:key,value:value}=dateStops[index];if(delta<key){return value}}return"yyyy"};const getChartDateLabel=(dateRangeStart,dateRangeEnd)=>{if(dateRangeStart>dateRangeEnd){throw Error(`Invalid date range. Received start value of ${dateRangeStart} and end value of ${dateRangeEnd}.`)}const delta=dateRangeEnd-dateRangeStart;let formatString="";if(delta<constants["d"].THIRTY_SIX_HOURS&&!isWithinCurrentDate(dateRangeStart,dateRangeEnd)){formatString="MM-DD "}return formatString+getLabelFormat(delta)};const seriesHasDownValues=series=>series?series.some(point=>!!point.down):false;const parseIsPaused=(value,defaultValue)=>{if(value==="true"){return true}if(value==="false"){return false}return defaultValue};const parseUrlInt=(value,defaultValue)=>{const parsed=parseInt(value||"",10);return isNaN(parsed)?defaultValue:parsed};var elastic_datemath=__webpack_require__(203);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);const parseAbsoluteDate=(date,defaultValue,options={})=>{const momentWrapper=elastic_datemath_default.a.parse(date,options);if(momentWrapper){return momentWrapper.valueOf()}return defaultValue};const{ABSOLUTE_DATE_RANGE_START:ABSOLUTE_DATE_RANGE_START,ABSOLUTE_DATE_RANGE_END:ABSOLUTE_DATE_RANGE_END,AUTOREFRESH_INTERVAL:AUTOREFRESH_INTERVAL,AUTOREFRESH_IS_PAUSED:AUTOREFRESH_IS_PAUSED,DATE_RANGE_START:DATE_RANGE_START,DATE_RANGE_END:DATE_RANGE_END,SEARCH:SEARCH,FILTERS:FILTERS,STATUS_FILTER:STATUS_FILTER}=constants["e"];const getSupportedUrlParams=params=>{const filteredParams={};Object.keys(params).forEach(key=>{let value;if(params[key]===undefined){value=undefined}else if(Array.isArray(params[key])){value=params[key][0]}else{value=params[key]}filteredParams[key]=value});const{autorefreshInterval:autorefreshInterval,autorefreshIsPaused:autorefreshIsPaused,dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,filters:filters,search:search,statusFilter:statusFilter,pagination:pagination,focusConnectorField:focusConnectorField}=filteredParams;return{pagination:pagination,absoluteDateRangeStart:parseAbsoluteDate(dateRangeStart||DATE_RANGE_START,ABSOLUTE_DATE_RANGE_START),absoluteDateRangeEnd:parseAbsoluteDate(dateRangeEnd||DATE_RANGE_END,ABSOLUTE_DATE_RANGE_END,{roundUp:true}),autorefreshInterval:parseUrlInt(autorefreshInterval,AUTOREFRESH_INTERVAL),autorefreshIsPaused:parseIsPaused(autorefreshIsPaused,AUTOREFRESH_IS_PAUSED),dateRangeStart:dateRangeStart||DATE_RANGE_START,dateRangeEnd:dateRangeEnd||DATE_RANGE_END,filters:filters||FILTERS,search:search||SEARCH,statusFilter:statusFilter||STATUS_FILTER,focusConnectorField:!!focusConnectorField}};var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(32);const MountWithReduxProvider=({children:children,state:state})=>external_kbnSharedDeps_React_default.a.createElement(lib["Provider"],{store:{dispatch:jest.fn(),getState:jest.fn().mockReturnValue(state||{selectedFilters:null}),subscribe:jest.fn(),replaceReducer:jest.fn()}},children)},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useGetUrlParams}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useUrlParams}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var query_string__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(141);var query_string__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(query_string__WEBPACK_IMPORTED_MODULE_1__);var react_router_dom__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(15);var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);var react_redux__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(32);var react_redux__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_3__);var _lib_helper__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(60);var _state_selectors__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(37);var _state_actions_selected_filters__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(142);const getParsedParams=search=>search?Object(query_string__WEBPACK_IMPORTED_MODULE_1__["parse"])(search[0]==="?"?search.slice(1):search,{sort:false}):{};const useGetUrlParams=()=>{const location=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["useLocation"])();const params=getParsedParams(location===null||location===void 0?void 0:location.search);return Object(_lib_helper__WEBPACK_IMPORTED_MODULE_4__["j"])(params)};const getMapFromFilters=value=>{try{return new Map(JSON.parse(value))}catch{return undefined}};const mapMapToObject=map=>{var _map$get,_map$get2,_map$get3,_map$get4;return{locations:(_map$get=map.get("observer.geo.name"))!==null&&_map$get!==void 0?_map$get:[],ports:(_map$get2=map.get("url.port"))!==null&&_map$get2!==void 0?_map$get2:[],schemes:(_map$get3=map.get("monitor.type"))!==null&&_map$get3!==void 0?_map$get3:[],tags:(_map$get4=map.get("tags"))!==null&&_map$get4!==void 0?_map$get4:[]}};const useUrlParams=()=>{const location=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["useLocation"])();const history=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["useHistory"])();const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_3__["useDispatch"])();const selectedFilters=Object(react_redux__WEBPACK_IMPORTED_MODULE_3__["useSelector"])(_state_selectors__WEBPACK_IMPORTED_MODULE_5__["F"]);const{filters:filters}=useGetUrlParams();Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(selectedFilters===null){const filterMap=getMapFromFilters(filters);if(filterMap){dispatch(Object(_state_actions_selected_filters__WEBPACK_IMPORTED_MODULE_6__["b"])(mapMapToObject(filterMap)))}}},[dispatch,filters,selectedFilters]);const updateUrlParams=updatedParams=>{if(!history||!location)return;const{pathname:pathname,search:search}=location;const currentParams=getParsedParams(search);const mergedParams={...currentParams,...updatedParams};history.push({pathname:pathname,search:Object(query_string__WEBPACK_IMPORTED_MODULE_1__["stringify"])(Object.keys(mergedParams).reduce((params,key)=>{const value=mergedParams[key];if(value===undefined||value===""){return params}return{...params,[key]:value}},{}),{sort:false})});const filterMap=getMapFromFilters(mergedParams.filters);if(!filterMap){dispatch(Object(_state_actions_selected_filters__WEBPACK_IMPORTED_MODULE_6__["b"])(null))}else{dispatch(Object(_state_actions_selected_filters__WEBPACK_IMPORTED_MODULE_6__["b"])(mapMapToObject(filterMap)))}};return[useGetUrlParams,updateUrlParams]}},,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertExpressionPopover}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);const getColor=(isOpen,isEnabled,isInvalid)=>{if(isInvalid===true)return"danger";if(isEnabled===false)return"subdued";return isOpen?"primary":"secondary"};const AlertExpressionPopover=({"aria-label":ariaLabel,content:content,"data-test-subj":dataTestSubj,description:description,isEnabled:isEnabled,isInvalid:isInvalid,id:id,value:value})=>{const[isOpen,setIsOpen]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiPopover"],{id:id,anchorPosition:"downLeft",button:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiExpression"],{"aria-label":ariaLabel,color:getColor(isOpen,isEnabled,isInvalid),"data-test-subj":dataTestSubj,description:description,isActive:isOpen,onClick:isEnabled?()=>setIsOpen(!isOpen):undefined,value:value}),isOpen:isOpen,closePopover:()=>setIsOpen(false)},content)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(110);var _rgb2=_interopRequireDefault(_rgb);var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgba(firstValue,secondValue,thirdValue,fourthValue){if(typeof firstValue==="string"&&typeof secondValue==="number"){var rgbValue=(0,_parseToRgb2.default)(firstValue);return"rgba("+rgbValue.red+","+rgbValue.green+","+rgbValue.blue+","+secondValue+")"}else if(typeof firstValue==="number"&&typeof secondValue==="number"&&typeof thirdValue==="number"&&typeof fourthValue==="number"){return fourthValue>=1?(0,_rgb2.default)(firstValue,secondValue,thirdValue):"rgba("+firstValue+","+secondValue+","+thirdValue+","+fourthValue+")"}else if(typeof firstValue==="object"&&secondValue===undefined&&thirdValue===undefined&&fourthValue===undefined){return firstValue.alpha>=1?(0,_rgb2.default)(firstValue.red,firstValue.green,firstValue.blue):"rgba("+firstValue.red+","+firstValue.green+","+firstValue.blue+","+firstValue.alpha+")"}throw new Error("Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).")}exports.default=rgba;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertMonitorStatusComponent}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ToggleAlertFlyoutButtonComponent}));__webpack_require__.d(__webpack_exports__,"c",(function(){return alerts_containers["c"]}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);var translations=__webpack_require__(52);var alert_expression_popover=__webpack_require__(68);const handleAlertFieldNumberChange=(e,isInvalid,setIsInvalid,setFieldValue)=>{const num=parseInt(e.target.value,10);if(isNaN(num)||num<1){setIsInvalid(true)}else{if(isInvalid)setIsInvalid(false);setFieldValue(num)}};const AlertFieldNumber=({"aria-label":ariaLabel,"data-test-subj":dataTestSubj,disabled:disabled,fieldValue:fieldValue,setFieldValue:setFieldValue})=>{const[isInvalid,setIsInvalid]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"aria-label":ariaLabel,compressed:true,"data-test-subj":dataTestSubj,min:1,onChange:e=>handleAlertFieldNumberChange(e,isInvalid,setIsInvalid,setFieldValue),disabled:disabled,value:fieldValue,isInvalid:isInvalid})};const DownNoExpressionSelect=({defaultNumTimes:defaultNumTimes,hasFilters:hasFilters,isEnabled:isEnabled,setAlertParams:setAlertParams})=>{const[numTimes,setNumTimes]=Object(external_kbnSharedDeps_React_["useState"])(defaultNumTimes!==null&&defaultNumTimes!==void 0?defaultNumTimes:5);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setAlertParams("numTimes",numTimes)},[numTimes,setAlertParams]);return external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":translations["A"],content:external_kbnSharedDeps_React_default.a.createElement(AlertFieldNumber,{"aria-label":translations["o"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.numTimesField",disabled:false,fieldValue:numTimes,setFieldValue:setNumTimes}),"data-test-subj":"xpack.uptime.alerts.monitorStatus.numTimesExpression",description:hasFilters?translations["v"]:translations["c"],id:"ping-count",isEnabled:isEnabled,value:`${numTimes} times`})};var filter_popover=__webpack_require__(173);var filter_group_translations=__webpack_require__(154);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const alertFilterLabels={USING:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.using",{defaultMessage:"Using"}),USING_PORT:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.usingPort",{defaultMessage:"Using port"}),ANY_PORT:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.anyPort",{defaultMessage:"any port"}),WITH:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.with",{defaultMessage:"Using"}),WITH_TAG:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.withTag",{defaultMessage:"With tag"}),ANY_TAG:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.anyTag",{defaultMessage:"any tag"}),OF:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.of",{defaultMessage:"Of"}),OF_TYPE:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.ofType",{defaultMessage:"Of type"}),ANY_TYPE:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.anyType",{defaultMessage:"any type"}),FROM:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.from",{defaultMessage:"From"}),FROM_LOCATION:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.fromLocation",{defaultMessage:"From location"}),ANY_LOCATION:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.anyLocation",{defaultMessage:"any location"}),REMOVE_FILTER_LABEL:title=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorExpression.label",{defaultMessage:"Remove filter {title}",values:{title:title}})};const statusExpLabels={ENABLED_CHECKBOX:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.statusEnabledCheck.label",{defaultMessage:"Status check"})};const timeExpLabels={OPEN_TIME_POPOVER:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeUnitExpression.ariaLabel",{defaultMessage:"Open the popover for time range unit select field"}),SELECT_TIME_RANGE_ARIA:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable",{defaultMessage:"Selectable field for the time range units alerts should use"}),SELECT_TIME_RANGE_HEADLINE:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.timerangeSelectionHeader",{defaultMessage:"Select time range unit"})};const filterAriaLabels={PORT:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.port.label",{defaultMessage:`Select port filters to apply to the alert's query.`}),TAG:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.tag.label",{defaultMessage:`Select tag filters to apply to the alert's query.`}),SCHEME:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.scheme.label",{defaultMessage:`Select protocol scheme filters to apply to the alert's query.`}),LOCATION:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.alerts.monitorStatus.filters.location.label",{defaultMessage:`Select location filters to apply to the alert's query.`})};function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const FiltersExpressionsSelect=({alertParams:alertParams,filters:overviewFilters,newFilters:newFilters,onRemoveFilter:onRemoveFilter,setAlertParams:setAlertParams,setUpdatedFieldValues:setUpdatedFieldValues})=>{var _alertParams$filters$,_alertParams$filters,_alertParams$filters$2,_alertParams$filters2,_alertParams$filters$3,_alertParams$filters3,_alertParams$filters$4,_alertParams$filters4,_ports$map;const{tags:tags,ports:ports,schemes:schemes,locations:locations}=overviewFilters;const selectedPorts=(_alertParams$filters$=alertParams===null||alertParams===void 0?void 0:(_alertParams$filters=alertParams.filters)===null||_alertParams$filters===void 0?void 0:_alertParams$filters["url.port"])!==null&&_alertParams$filters$!==void 0?_alertParams$filters$:[];const selectedLocations=(_alertParams$filters$2=alertParams===null||alertParams===void 0?void 0:(_alertParams$filters2=alertParams.filters)===null||_alertParams$filters2===void 0?void 0:_alertParams$filters2["observer.geo.name"])!==null&&_alertParams$filters$2!==void 0?_alertParams$filters$2:[];const selectedSchemes=(_alertParams$filters$3=alertParams===null||alertParams===void 0?void 0:(_alertParams$filters3=alertParams.filters)===null||_alertParams$filters3===void 0?void 0:_alertParams$filters3["monitor.type"])!==null&&_alertParams$filters$3!==void 0?_alertParams$filters$3:[];const selectedTags=(_alertParams$filters$4=alertParams===null||alertParams===void 0?void 0:(_alertParams$filters4=alertParams.filters)===null||_alertParams$filters4===void 0?void 0:_alertParams$filters4.tags)!==null&&_alertParams$filters$4!==void 0?_alertParams$filters$4:[];const onFilterFieldChange=(fieldName,values)=>{if(alertParams.filters&&typeof alertParams.filters!=="string"){setAlertParams("filters",{...alertParams.filters,[fieldName]:values})}else{setAlertParams("filters",Object.assign({},{tags:[],"url.port":[],"observer.geo.name":[],"monitor.type":[]},{[fieldName]:values}))}setUpdatedFieldValues({fieldName:fieldName,values:values})};const monitorFilters=[{"aria-label":filterAriaLabels.PORT,onFilterFieldChange:onFilterFieldChange,loading:false,fieldName:"url.port",id:"filter_port",disabled:(ports===null||ports===void 0?void 0:ports.length)===0,items:(_ports$map=ports===null||ports===void 0?void 0:ports.map(p=>p.toString()))!==null&&_ports$map!==void 0?_ports$map:[],selectedItems:selectedPorts,title:filter_group_translations["a"].PORT,description:selectedPorts.length===0?alertFilterLabels.USING:alertFilterLabels.USING_PORT,value:selectedPorts.length===0?alertFilterLabels.ANY_PORT:selectedPorts===null||selectedPorts===void 0?void 0:selectedPorts.join(",")},{"aria-label":filterAriaLabels.TAG,onFilterFieldChange:onFilterFieldChange,loading:false,fieldName:"tags",id:"filter_tags",disabled:(tags===null||tags===void 0?void 0:tags.length)===0,items:tags!==null&&tags!==void 0?tags:[],selectedItems:selectedTags,title:filter_group_translations["a"].TAG,description:selectedTags.length===0?alertFilterLabels.WITH:alertFilterLabels.WITH_TAG,value:selectedTags.length===0?alertFilterLabels.ANY_TAG:selectedTags===null||selectedTags===void 0?void 0:selectedTags.join(",")},{"aria-label":filterAriaLabels.SCHEME,onFilterFieldChange:onFilterFieldChange,loading:false,fieldName:"monitor.type",id:"filter_scheme",disabled:(schemes===null||schemes===void 0?void 0:schemes.length)===0,items:schemes!==null&&schemes!==void 0?schemes:[],selectedItems:selectedSchemes,title:filter_group_translations["a"].SCHEME,description:selectedSchemes.length===0?alertFilterLabels.OF:alertFilterLabels.OF_TYPE,value:selectedSchemes.length===0?alertFilterLabels.ANY_TYPE:selectedSchemes===null||selectedSchemes===void 0?void 0:selectedSchemes.join(",")},{"aria-label":filterAriaLabels.LOCATION,onFilterFieldChange:onFilterFieldChange,loading:false,fieldName:"observer.geo.name",id:"filter_location",disabled:(locations===null||locations===void 0?void 0:locations.length)===0,items:locations!==null&&locations!==void 0?locations:[],selectedItems:selectedLocations,title:filter_group_translations["a"].LOCATION,description:selectedLocations.length===0?alertFilterLabels.FROM:alertFilterLabels.FROM_LOCATION,value:selectedLocations.length===0?alertFilterLabels.ANY_LOCATION:selectedLocations===null||selectedLocations===void 0?void 0:selectedLocations.join(",")}];const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])({filter_port:false,filter_tags:false,filter_scheme:false,filter_location:false});const filtersToDisplay=monitorFilters.filter(curr=>curr.selectedItems.length>0||(newFilters===null||newFilters===void 0?void 0:newFilters.includes(curr.fieldName)));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,filtersToDisplay.map(({description:description,value:value,...item})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{key:item.id},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(filter_popover["a"],_extends({},item,{btnContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiExpression"],{"aria-label":item["aria-label"],color:"secondary","data-test-subj":"uptimeCreateStatusAlert."+item.id,description:description,value:value,onClick:()=>setIsOpen({...isOpen,[item.id]:!isOpen[item.id]})}),forceOpen:isOpen[item.id],setForceOpen:()=>{setIsOpen({...isOpen,[item.id]:!isOpen[item.id]})}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":alertFilterLabels.REMOVE_FILTER_LABEL(item.title),iconType:"trash",color:"danger",onClick:()=>{onRemoveFilter(item.fieldName);onFilterFieldChange(item.fieldName,[])}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}))};var lib=__webpack_require__(32);var selectors=__webpack_require__(37);var use_filter_update=__webpack_require__(81);function filters_expression_select_container_extends(){filters_expression_select_container_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return filters_expression_select_container_extends.apply(this,arguments)}const FiltersExpressionSelectContainer=props=>{const[updatedFieldValues,setUpdatedFieldValues]=Object(external_kbnSharedDeps_React_["useState"])({fieldName:"",values:[]});Object(use_filter_update["a"])(updatedFieldValues.fieldName,updatedFieldValues.values,props.shouldUpdateUrl);const overviewFilters=Object(lib["useSelector"])(selectors["v"]);return external_kbnSharedDeps_React_default.a.createElement(FiltersExpressionsSelect,filters_expression_select_container_extends({},overviewFilters,props,{setUpdatedFieldValues:setUpdatedFieldValues}))};const TimeUnitSelectable=({"aria-label":ariaLabel,"data-test-subj":dataTestSubj,headlineText:headlineText,onChange:onChange,timeRangeOptions:timeRangeOptions})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,headlineText)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],{"aria-label":ariaLabel,"data-test-subj":dataTestSubj,options:timeRangeOptions,onChange:onChange,singleSelection:true,listProps:{showIcons:true}},list=>list));const DEFAULT_TIMERANGE_UNIT="m";const TimeRangeOptions=[{"aria-label":translations["E"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable.secondsOption",key:"s",label:translations["D"]},{"aria-label":translations["x"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable.minutesOption",key:"m",label:translations["w"]},{"aria-label":translations["t"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable.hoursOption",key:"h",label:translations["s"]},{"aria-label":translations["e"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable.daysOption",key:"d",label:translations["d"]}];const TimeExpressionSelect=({defaultTimerangeCount:defaultTimerangeCount,defaultTimerangeUnit:defaultTimerangeUnit,isEnabled:isEnabled,setAlertParams:setAlertParams})=>{var _timerangeUnitOptions3,_timerangeUnitOptions4;const[numUnits,setNumUnits]=Object(external_kbnSharedDeps_React_["useState"])(defaultTimerangeCount!==null&&defaultTimerangeCount!==void 0?defaultTimerangeCount:15);const[timerangeUnitOptions,setTimerangeUnitOptions]=Object(external_kbnSharedDeps_React_["useState"])(TimeRangeOptions.map(opt=>opt.key===(defaultTimerangeUnit!==null&&defaultTimerangeUnit!==void 0?defaultTimerangeUnit:DEFAULT_TIMERANGE_UNIT)?{...opt,checked:"on"}:opt));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{var _timerangeUnitOptions,_timerangeUnitOptions2;const timerangeUnit=(_timerangeUnitOptions=(_timerangeUnitOptions2=timerangeUnitOptions.find(({checked:checked})=>checked==="on"))===null||_timerangeUnitOptions2===void 0?void 0:_timerangeUnitOptions2.key)!==null&&_timerangeUnitOptions!==void 0?_timerangeUnitOptions:"m";setAlertParams("timerangeUnit",timerangeUnit);setAlertParams("timerangeCount",numUnits)},[numUnits,timerangeUnitOptions,setAlertParams]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":translations["B"],content:external_kbnSharedDeps_React_default.a.createElement(AlertFieldNumber,{"aria-label":translations["p"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeValueField",disabled:false,fieldValue:numUnits,setFieldValue:setNumUnits}),"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeValueExpression",description:translations["q"],id:"timerange",isEnabled:isEnabled,value:translations["r"](numUnits)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":timeExpLabels.OPEN_TIME_POPOVER,content:external_kbnSharedDeps_React_default.a.createElement(TimeUnitSelectable,{"aria-label":timeExpLabels.SELECT_TIME_RANGE_ARIA,"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeUnitSelectable",headlineText:timeExpLabels.SELECT_TIME_RANGE_HEADLINE,onChange:newOptions=>{if(newOptions.reduce((acc,{checked:checked})=>acc||checked==="on",false)){setTimerangeUnitOptions(newOptions)}},timeRangeOptions:timerangeUnitOptions}),"data-test-subj":"xpack.uptime.alerts.monitorStatus.timerangeUnitExpression",description:"",id:"timerange-unit",isEnabled:isEnabled,value:(_timerangeUnitOptions3=(_timerangeUnitOptions4=timerangeUnitOptions.find(({checked:checked})=>checked==="on"))===null||_timerangeUnitOptions4===void 0?void 0:_timerangeUnitOptions4.label.toLowerCase())!==null&&_timerangeUnitOptions3!==void 0?_timerangeUnitOptions3:""})))};const StatusExpressionSelect=({alertParams:alertParams,hasFilters:hasFilters,setAlertParams:setAlertParams})=>{var _alertParams$shouldCh;const[isEnabled,setIsEnabled]=Object(external_kbnSharedDeps_React_["useState"])((_alertParams$shouldCh=alertParams.shouldCheckStatus)!==null&&_alertParams$shouldCh!==void 0?_alertParams$shouldCh:true);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setAlertParams("shouldCheckStatus",isEnabled)},[isEnabled,setAlertParams]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{id:"statusEnabled",label:statusExpLabels.ENABLED_CHECKBOX,checked:isEnabled,onChange:()=>setIsEnabled(!isEnabled)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(DownNoExpressionSelect,{defaultNumTimes:alertParams.numTimes,hasFilters:hasFilters,isEnabled:isEnabled,setAlertParams:setAlertParams})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(TimeExpressionSelect,{defaultTimerangeUnit:alertParams.timerangeUnit,defaultTimerangeCount:alertParams.timerangeCount,isEnabled:isEnabled,setAlertParams:setAlertParams})))};const AddFilterButton=({newFilters:newFilters,onNewFilter:onNewFilter,alertFilters:alertFilters})=>{const[isPopoverOpen,setPopover]=Object(external_kbnSharedDeps_React_["useState"])(false);const getSelectedItems=fieldName=>{var _alertFilters$fieldNa;return(_alertFilters$fieldNa=alertFilters===null||alertFilters===void 0?void 0:alertFilters[fieldName])!==null&&_alertFilters$fieldNa!==void 0?_alertFilters$fieldNa:[]};const onButtonClick=()=>{setPopover(!isPopoverOpen)};const closePopover=()=>{setPopover(false)};const items=[];const allFilters=[{id:"observer.geo.name",label:translations["u"]},{id:"tags",label:translations["F"]},{id:"url.port",label:translations["C"]},{id:"monitor.type",label:translations["G"]}];allFilters.forEach(filter=>{var _getSelectedItems;if(((_getSelectedItems=getSelectedItems(filter.id))===null||_getSelectedItems===void 0?void 0:_getSelectedItems.length)===0&&!newFilters.includes(filter.id)){items.push(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{"data-test-subj":"uptimeAlertAddFilter."+filter.id,key:filter.id,onClick:()=>{closePopover();onNewFilter(filter.id)}},filter.label))}});const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"uptimeCreateAlertAddFilter",disabled:items.length===0,iconType:"plusInCircleFilled",onClick:onButtonClick},translations["a"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"singlePanel",button:button,isOpen:isPopoverOpen,closePopover:closePopover,panelPaddingSize:"none",anchorPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:items}))};const OldAlertCallOut=({isOldAlert:isOldAlert})=>{if(!isOldAlert)return null;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.alerts.monitorStatus.oldAlertCallout.title",defaultMessage:"You may be editing an older alert, some fields may not auto-populate."}),iconType:"alert"}))};const availability_expression_select_TimeRangeOptions=[{"aria-label":translations["e"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit.daysOption",key:"d",label:translations["d"]},{"aria-label":translations["K"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit.weeksOption",key:"w",label:translations["J"]},{"aria-label":translations["z"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit.monthsOption",key:"M",label:translations["y"]},{"aria-label":translations["M"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit.yearsOption",key:"y",label:translations["L"]}];const DEFAULT_RANGE=30;const availability_expression_select_DEFAULT_TIMERANGE_UNIT="d";const DEFAULT_THRESHOLD="99";const isThresholdInvalid=n=>isNaN(n)||n<=0||n>100;const AvailabilityExpressionSelect=({alertParams:alertParams,isOldAlert:isOldAlert,setAlertParams:setAlertParams})=>{var _alertParams$availabi,_alertParams$availabi2,_alertParams$availabi3,_alertParams$availabi4,_alertParams$availabi5,_alertParams$availabi6,_alertParams$shouldCh,_timerangeUnitOptions,_timerangeUnitOptions2;const[range,setRange]=Object(external_kbnSharedDeps_React_["useState"])((_alertParams$availabi=alertParams===null||alertParams===void 0?void 0:(_alertParams$availabi2=alertParams.availability)===null||_alertParams$availabi2===void 0?void 0:_alertParams$availabi2.range)!==null&&_alertParams$availabi!==void 0?_alertParams$availabi:DEFAULT_RANGE);const[rangeUnit,setRangeUnit]=Object(external_kbnSharedDeps_React_["useState"])((_alertParams$availabi3=alertParams===null||alertParams===void 0?void 0:(_alertParams$availabi4=alertParams.availability)===null||_alertParams$availabi4===void 0?void 0:_alertParams$availabi4.rangeUnit)!==null&&_alertParams$availabi3!==void 0?_alertParams$availabi3:availability_expression_select_DEFAULT_TIMERANGE_UNIT);const[threshold,setThreshold]=Object(external_kbnSharedDeps_React_["useState"])((_alertParams$availabi5=alertParams===null||alertParams===void 0?void 0:(_alertParams$availabi6=alertParams.availability)===null||_alertParams$availabi6===void 0?void 0:_alertParams$availabi6.threshold)!==null&&_alertParams$availabi5!==void 0?_alertParams$availabi5:DEFAULT_THRESHOLD);const[isEnabled,setIsEnabled]=Object(external_kbnSharedDeps_React_["useState"])((_alertParams$shouldCh=alertParams===null||alertParams===void 0?void 0:alertParams.shouldCheckAvailability)!==null&&_alertParams$shouldCh!==void 0?_alertParams$shouldCh:!isOldAlert);const[timerangeUnitOptions,setTimerangeUnitOptions]=Object(external_kbnSharedDeps_React_["useState"])(availability_expression_select_TimeRangeOptions.map(opt=>opt.key===availability_expression_select_DEFAULT_TIMERANGE_UNIT?{...opt,checked:"on"}:opt));const thresholdIsInvalid=isThresholdInvalid(Number(threshold));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(thresholdIsInvalid){setAlertParams("availability",undefined);setAlertParams("shouldCheckAvailability",false)}else if(isEnabled){setAlertParams("shouldCheckAvailability",true);setAlertParams("availability",{range:range,rangeUnit:rangeUnit,threshold:threshold})}else{setAlertParams("shouldCheckAvailability",false)}},[isEnabled,range,rangeUnit,setAlertParams,threshold,thresholdIsInvalid]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{id:"availabilityRangeEnabled",label:translations["f"],checked:isEnabled,onChange:()=>setIsEnabled(!isEnabled)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":translations["l"],content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{isInvalid:thresholdIsInvalid,value:threshold,onChange:e=>{setThreshold(e.target.value)}}),"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.threshold",description:translations["m"],id:"threshold",isEnabled:isEnabled,isInvalid:thresholdIsInvalid,value:translations["n"](threshold)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":translations["g"],content:external_kbnSharedDeps_React_default.a.createElement(AlertFieldNumber,{"aria-label":translations["j"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeValueField",disabled:false,fieldValue:range,setFieldValue:setRange}),"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeExpression",description:translations["k"],id:"range",isEnabled:isEnabled,value:`${range}`})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(alert_expression_popover["a"],{"aria-label":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit",content:external_kbnSharedDeps_React_default.a.createElement(TimeUnitSelectable,{"aria-label":translations["h"],"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit.select",headlineText:translations["i"],onChange:newOptions=>{const checkedOption=newOptions.find(({checked:checked})=>checked==="on");if(checkedOption){setTimerangeUnitOptions(newOptions);setRangeUnit(checkedOption.key)}},timeRangeOptions:timerangeUnitOptions}),"data-test-subj":"xpack.uptime.alerts.monitorStatus.availability.timerangeUnit",description:"",id:"availability-unit",isEnabled:isEnabled,value:(_timerangeUnitOptions=(_timerangeUnitOptions2=timerangeUnitOptions.find(({checked:checked})=>checked==="on"))===null||_timerangeUnitOptions2===void 0?void 0:_timerangeUnitOptions2.label.toLowerCase())!==null&&_timerangeUnitOptions!==void 0?_timerangeUnitOptions:""})))))};var overview=__webpack_require__(172);const AlertMonitorStatusComponent=props=>{var _alertParams$filters;const{alertParams:alertParams,hasFilters:hasFilters,isOldAlert:isOldAlert,setAlertParams:setAlertParams,shouldUpdateUrl:shouldUpdateUrl,snapshotCount:snapshotCount,snapshotLoading:snapshotLoading}=props;const alertFilters=(_alertParams$filters=alertParams===null||alertParams===void 0?void 0:alertParams.filters)!==null&&_alertParams$filters!==void 0?_alertParams$filters:{};const[newFilters,setNewFilters]=Object(external_kbnSharedDeps_React_["useState"])(Object.keys(alertFilters).filter(f=>alertFilters[f].length));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(OldAlertCallOut,{isOldAlert:isOldAlert}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(overview["c"],{"aria-label":translations["b"],defaultKuery:alertParams.search,shouldUpdateUrl:shouldUpdateUrl,updateDefaultKuery:value=>setAlertParams("search",value),"data-test-subj":"xpack.uptime.alerts.monitorStatus.filterBar"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(AddFilterButton,{alertFilters:alertParams.filters,newFilters:newFilters,onNewFilter:newFilter=>{setNewFilters([...newFilters,newFilter])}}),external_kbnSharedDeps_React_default.a.createElement(FiltersExpressionSelectContainer,{alertParams:alertParams,newFilters:newFilters,onRemoveFilter:removeFilter=>{if(newFilters.includes(removeFilter)){setNewFilters(newFilters.filter(item=>item!==removeFilter))}},setAlertParams:setAlertParams,shouldUpdateUrl:shouldUpdateUrl}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(StatusExpressionSelect,{alertParams:alertParams,hasFilters:hasFilters,setAlertParams:setAlertParams}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(AvailabilityExpressionSelect,{alertParams:alertParams,isOldAlert:isOldAlert,setAlertParams:setAlertParams}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.alerts.monitorStatus.monitorCallOut.title",defaultMessage:"This alert will apply to approximately {snapshotCount} monitors.",values:{snapshotCount:snapshotLoading?"...":snapshotCount}}),iconType:"iInCircle"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};var public_=__webpack_require__(14);var alerts=__webpack_require__(2);const ALERT_CONTEXT_MAIN_PANEL_ID=0;const ALERT_CONTEXT_SELECT_TYPE_PANEL_ID=1;const ToggleAlertFlyoutButtonComponent=({alertOptions:alertOptions,setAlertFlyoutVisible:setAlertFlyoutVisible})=>{var _kibana$services,_kibana$services$appl;const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const kibana=Object(public_["useKibana"])();const monitorStatusAlertContextMenuItem={"aria-label":translations["I"].toggleMonitorStatusAriaLabel,"data-test-subj":"xpack.uptime.toggleAlertFlyout",name:translations["I"].toggleMonitorStatusContent,onClick:()=>{setAlertFlyoutVisible(alerts["b"].MONITOR_STATUS);setIsOpen(false)}};const tlsAlertContextMenuItem={"aria-label":translations["I"].toggleTlsAriaLabel,"data-test-subj":"xpack.uptime.toggleTlsAlertFlyout",name:translations["I"].toggleTlsContent,onClick:()=>{setAlertFlyoutVisible(alerts["b"].TLS);setIsOpen(false)}};const managementContextItem={"aria-label":translations["I"].navigateToAlertingUIAriaLabel,"data-test-subj":"xpack.uptime.navigateToAlertingUi",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{color:"text",href:(_kibana$services=kibana.services)===null||_kibana$services===void 0?void 0:(_kibana$services$appl=_kibana$services.application)===null||_kibana$services$appl===void 0?void 0:_kibana$services$appl.getUrlForApp("management/insightsAndAlerting/triggersActions/alerts")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.navigateToAlertingButton.content",defaultMessage:"Manage alerts"})),icon:"tableOfContents"};let selectionItems=[];if(!alertOptions){selectionItems=[monitorStatusAlertContextMenuItem,tlsAlertContextMenuItem]}else{alertOptions.forEach(option=>{if(option===alerts["b"].MONITOR_STATUS)selectionItems.push(monitorStatusAlertContextMenuItem);else if(option===alerts["b"].TLS)selectionItems.push(tlsAlertContextMenuItem)})}if(selectionItems.length===1){selectionItems[0].icon="bell"}let panels;if(selectionItems.length===1){panels=[{id:ALERT_CONTEXT_MAIN_PANEL_ID,items:[...selectionItems,managementContextItem]}]}else{panels=[{id:ALERT_CONTEXT_MAIN_PANEL_ID,items:[{"aria-label":translations["I"].openAlertContextPanelAriaLabel,"data-test-subj":"xpack.uptime.openAlertContextPanel",name:translations["I"].openAlertContextPanelLabel,icon:"bell",panel:ALERT_CONTEXT_SELECT_TYPE_PANEL_ID},managementContextItem]},{id:ALERT_CONTEXT_SELECT_TYPE_PANEL_ID,title:"create alerts",items:selectionItems}]}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"aria-label":translations["I"].toggleButtonAriaLabel,"data-test-subj":"xpack.uptime.alertsPopover.toggleButton",iconType:"arrowDown",iconSide:"right",onClick:()=>setIsOpen(!isOpen)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.alerts.toggleAlertFlyoutButtonText",defaultMessage:"Alerts"})),closePopover:()=>setIsOpen(false),isOpen:isOpen,ownFocus:true,panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{initialPanelId:0,panels:panels}))};var uptime_alerts_flyout_wrapper=__webpack_require__(106);var alerts_containers=__webpack_require__(85)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getHealthMessage}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getShortTimeStamp}));__webpack_require__.d(__webpack_exports__,"a",(function(){return MonitorListStatusColumn}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_Moment_=__webpack_require__(13);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);const parseTimestamp=tsValue=>{let parsed=Date.parse(tsValue);if(isNaN(parsed)){parsed=parseInt(tsValue,10)}return external_kbnSharedDeps_Moment_default()(parsed)};var constants=__webpack_require__(34);var contexts=__webpack_require__(36);var common_=__webpack_require__(18);var translations=__webpack_require__(50);const StatusColumnFlexG=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"StatusColumnFlexG",componentId:"sc-10ve8zw-0"})(["@media (max-width:574px){min-width:230px;}"]);const getHealthMessage=status=>{switch(status){case constants["s"].UP:return translations["g"];case constants["s"].DOWN:return translations["e"];default:return null}};const getShortTimeStamp=(timeStamp,relative=false)=>{if(relative){var _moment$locale;const prevLocale=(_moment$locale=external_kbnSharedDeps_Moment_default.a.locale())!==null&&_moment$locale!==void 0?_moment$locale:"en";const shortLocale=external_kbnSharedDeps_Moment_default.a.locale(constants["r"])===constants["r"];if(!shortLocale){external_kbnSharedDeps_Moment_default.a.defineLocale(constants["r"],constants["q"])}let shortTimestamp;if(typeof timeStamp==="string"){shortTimestamp=parseTimestamp(timeStamp).fromNow()}else{shortTimestamp=timeStamp.fromNow()}external_kbnSharedDeps_Moment_default.a.locale(prevLocale);return shortTimestamp}else{if(external_kbnSharedDeps_Moment_default()().diff(timeStamp,"d")>1){return timeStamp.format("ll LTS")}return timeStamp.format("LTS")}};const getLocationStatus=(summaryPings,status)=>{const upPings=new Set;const downPings=new Set;summaryPings.forEach(summaryPing=>{var _summaryPing$observer,_summaryPing$observer2,_summaryPing$observer3;const location=(_summaryPing$observer=summaryPing===null||summaryPing===void 0?void 0:(_summaryPing$observer2=summaryPing.observer)===null||_summaryPing$observer2===void 0?void 0:(_summaryPing$observer3=_summaryPing$observer2.geo)===null||_summaryPing$observer3===void 0?void 0:_summaryPing$observer3.name)!==null&&_summaryPing$observer!==void 0?_summaryPing$observer:constants["u"];if(summaryPing.monitor.status===constants["s"].UP){upPings.add(location)}else if(summaryPing.monitor.status===constants["s"].DOWN){downPings.add(location)}});const upsMessage=upPings.size>0?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.statusColumn.locStatusMessage.tooltip.up",{defaultMessage:"Up in {locs}",values:{locs:[...upPings].join(", ")}}):"";const downMessage=downPings.size>0?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.statusColumn.locStatusMessage.tooltip.down",{defaultMessage:"Down in {locs}",values:{locs:[...downPings].join(", ")}}):"";const absUpChecks=new Set([...upPings].filter(item=>!downPings.has(item)));const totalLocations=absUpChecks.size+downPings.size;let statusMessage="";if(status===constants["s"].DOWN){statusMessage=`${downPings.size}/${totalLocations}`}else{statusMessage=`${absUpChecks.size}/${totalLocations}`}if(totalLocations>1){return{statusMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.statusColumn.locStatusMessage.multiple",{defaultMessage:"in {noLoc} locations",values:{noLoc:statusMessage}}),locTooltip:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("span",null,upsMessage),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement("span",null,downMessage))}}return{statusMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.statusColumn.locStatusMessage",{defaultMessage:"in {noLoc} location",values:{noLoc:statusMessage}}),locTooltip:upsMessage+downMessage}};const MonitorListStatusColumn=({status:status,summaryPings:summaryPings=[],timestamp:tsString})=>{const timestamp=parseTimestamp(tsString);const{colors:{dangerBehindText:dangerBehindText}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const{statusMessage:statusMessage,locTooltip:locTooltip}=getLocationStatus(summaryPings,status);return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(StatusColumnFlexG,{alignItems:"center",gutterSize:"none",wrap:false,responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{flexBasis:40}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{className:"eui-textCenter",color:status===constants["s"].UP?"secondary":dangerBehindText},getHealthMessage(status)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"ghost",size:"xs"},locTooltip)},external_kbnSharedDeps_React_default.a.createElement(PaddedText,{size:"xs",color:"subdued",className:"eui-textNoWrap"},statusMessage,",")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"ghost",size:"xs"},timestamp.toLocaleString())},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued",className:"eui-textNoWrap"},"Checked ",getShortTimeStamp(timestamp)))))};const PaddedText=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiText"])`
  padding-right: ${props=>props.theme.eui.paddingSizes.xs};
`},,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return stringifyUrlParams}));var query_string__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(141);var query_string__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(query_string__WEBPACK_IMPORTED_MODULE_0__);var _common_constants__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(34);const{AUTOREFRESH_INTERVAL:AUTOREFRESH_INTERVAL,AUTOREFRESH_IS_PAUSED:AUTOREFRESH_IS_PAUSED,DATE_RANGE_START:DATE_RANGE_START,DATE_RANGE_END:DATE_RANGE_END,FOCUS_CONNECTOR_FIELD:FOCUS_CONNECTOR_FIELD}=_common_constants__WEBPACK_IMPORTED_MODULE_1__["e"];const stringifyUrlParams=(params,ignoreEmpty=false)=>{if(ignoreEmpty){delete params.absoluteDateRangeStart;delete params.absoluteDateRangeEnd;Object.keys(params).forEach(key=>{const val=params[key];if(val==null||val===""){delete params[key]}if(key==="dateRangeStart"&&val===DATE_RANGE_START){delete params[key]}if(key==="dateRangeEnd"&&val===DATE_RANGE_END){delete params[key]}if(key==="autorefreshIsPaused"&&val===AUTOREFRESH_IS_PAUSED){delete params[key]}if(key==="autorefreshInterval"&&val===AUTOREFRESH_INTERVAL){delete params[key]}if(key==="focusConnectorField"&&val===FOCUS_CONNECTOR_FIELD){delete params[key]}})}return`?${Object(query_string__WEBPACK_IMPORTED_MODULE_0__["stringify"])(params,{sort:false})}`}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return LocationLink}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__);const locationDocsLink="https://www.elastic.co/guide/en/beats/heartbeat/current/configuration-observer-options.html";const LocationLink=({location:location,textSize:textSize})=>location?react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiText"],{size:textSize||"s",grow:false},location):react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiLink"],{href:locationDocsLink,target:"_blank"},_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.uptime.monitorList.geoName.helpLinkAnnotation",{defaultMessage:"Add location",description:"Text that instructs the user to navigate to our docs to add a geographic location to their data"}))},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useFilterUpdate}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _use_url_params__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(62);const useFilterUpdate=(fieldName,values,shouldUpdateUrl=true)=>{const[getUrlParams,updateUrl]=Object(_use_url_params__WEBPACK_IMPORTED_MODULE_1__["b"])();const{filters:currentFilters}=getUrlParams();const onFilterUpdate=filtersKuery=>{if(currentFilters!==filtersKuery&&shouldUpdateUrl){updateUrl({filters:filtersKuery,pagination:""})}};let filterKueries;try{filterKueries=new Map(JSON.parse(currentFilters))}catch{filterKueries=new Map}Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(fieldName){const updatedFilterMap=new Map(filterKueries);updatedFilterMap.set(fieldName,values);Array.from(updatedFilterMap.keys()).forEach(key=>{const value=updatedFilterMap.get(key);if(value&&value.length===0){updatedFilterMap.delete(key)}});const persistedFilters=Array.from(updatedFilterMap);onFilterUpdate(persistedFilters.length===0?"":JSON.stringify(persistedFilters))}},[fieldName,values])}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return PingList}));__webpack_require__.d(__webpack_exports__,"c",(function(){return MonitorStatusDetails}));__webpack_require__.d(__webpack_exports__,"d",(function(){return PingHistogram}));__webpack_require__.d(__webpack_exports__,"a",(function(){return MONITOR_CHART_HEIGHT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return MonitorCharts}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var lib=__webpack_require__(32);var alerts=__webpack_require__(2);var selectors=__webpack_require__(37);var contexts=__webpack_require__(36);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const JOB_CREATED_SUCCESS_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobCreatedNotificationTitle",{defaultMessage:"Job successfully created"});const JOB_CREATED_SUCCESS_MESSAGE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobCreatedNotificationText",{defaultMessage:"The analysis is now running for response duration chart. It might take a while before results are added to the response times graph."});const JOB_CREATION_FAILED=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobCreationFailedNotificationTitle",{defaultMessage:"Job creation failed"});const JOB_CREATION_FAILED_MESSAGE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobCreationFailedNotificationText",{defaultMessage:"Your current license may not allow for creating machine learning jobs, or this job may already exist."});const JOB_DELETION=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobDeletionNotificationTitle",{defaultMessage:"Job deleted"});const JOB_DELETION_SUCCESS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobDeletionSuccessNotificationText",{defaultMessage:"Job is successfully deleted"});const JOB_DELETION_CONFIRMATION=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobDeletionConfirmLabel",{defaultMessage:"Delete anomaly detection job?"});const VIEW_JOB=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.jobCreatedNotificationText.viewJobLinkText",{defaultMessage:"View job"});const EXPLORE_IN_ML_APP=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.durationChart.exploreInMlApp",{defaultMessage:"Explore in ML App"});const ENABLE_ANOMALY_DETECTION=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.enableAnomalyDetectionTitle",{defaultMessage:"Enable anomaly detection"});const ANOMALY_DETECTION=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.anomalyDetectionTitle",{defaultMessage:"Anomaly detection"});const DISABLE_ANOMALY_DETECTION=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.disableAnomalyDetectionTitle",{defaultMessage:"Disable anomaly detection"});const ENABLE_ANOMALY_ALERT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.enableAnomalyAlert",{defaultMessage:"Enable anomaly alert"});const DISABLE_ANOMALY_ALERT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.disableAnomalyAlert",{defaultMessage:"Disable anomaly alert"});const MANAGE_ANOMALY_DETECTION=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.manageAnomalyDetectionTitle",{defaultMessage:"Manage anomaly detection"});const ML_MANAGEMENT_PAGE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.manageMLJobDescription.mlJobsPageLinkText",{defaultMessage:"Machine Learning jobs management page"});const TAKE_SOME_TIME_TEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.manageMLJobDescription.noteText",{defaultMessage:"Note: It might take a few minutes for the job to begin calculating results."});const CREATE_NEW_JOB=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.createNewJobButtonLabel",{defaultMessage:"Create new job"});const CANCEL_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.cancelLabel",{defaultMessage:"Cancel"});const CREAT_ML_JOB_DESC=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.createMLJobDescription",{defaultMessage:`Here you can create a machine learning job to calculate anomaly scores on\n    response durations for Uptime Monitor. Once enabled, the monitor duration chart on the details page\n    will show the expected bounds and annotate the graph with anomalies. You can also potentially\n     identify periods of increased latency across geographical regions.`});const START_TRAIL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.startTrial",{defaultMessage:"Start free 14-day trial"});const START_TRAIL_DESC=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.startTrialDesc",{defaultMessage:"In order to access duration anomaly detection, you have to be subscribed to an Elastic Platinum license."});const ENABLE_MANAGE_JOB=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.ml.enableAnomalyDetectionPanel.enable_or_manage_job",{defaultMessage:"You can enable anomaly detection job or if job is already there you can manage the job or alert."});var url_url=__webpack_require__(224);var url_default=__webpack_require__.n(url_url);var rison=__webpack_require__(230);var rison_default=__webpack_require__.n(rison);var common_lib=__webpack_require__(86);const getMLJobLinkHref=({basePath:basePath,monitorId:monitorId,dateRange:dateRange})=>{const query={ml:{jobIds:[Object(common_lib["b"])(monitorId)]},refreshInterval:{pause:true,value:0},time:dateRange};const queryParams={mlExplorerFilter:{filterActive:true,filteredFields:["monitor.id",monitorId]},mlExplorerSwimlane:{viewByFieldName:"observer.geo.name"}};const path="/explorer";return url_default.a.format({pathname:basePath+"/app/ml",hash:`${path}?_g=${rison_default.a.encode(query)}`+(monitorId?`&_a=${rison_default.a.encode(queryParams)}`:"")})};const MLJobLink=({basePath:basePath,monitorId:monitorId,dateRange:dateRange,children:children})=>{const href=getMLJobLinkHref({basePath:basePath,monitorId:monitorId,dateRange:dateRange});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{children:children,size:"s",href:href,target:"_blank"})};var hooks=__webpack_require__(35);var actions=__webpack_require__(33);var alerts_alerts=__webpack_require__(46);const useAnomalyAlert=()=>{const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const dispatch=Object(lib["useDispatch"])();const monitorId=Object(hooks["d"])();const{data:anomalyAlert}=Object(lib["useSelector"])(alerts_alerts["c"]);const alertFlyoutVisible=Object(lib["useSelector"])(selectors["y"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(alerts_alerts["i"].get({monitorId:monitorId}))},[monitorId,lastRefresh,dispatch,alertFlyoutVisible]);return anomalyAlert};var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);const ConfirmAlertDeletion=({onConfirm:onConfirm,onCancel:onCancel})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:DISABLE_ANOMALY_ALERT,onCancel:onCancel,onConfirm:onConfirm,cancelButtonText:"Cancel",confirmButtonText:"Delete",buttonColor:"danger",defaultFocusedButton:"confirm","data-test-subj":"uptimeMLAlertDeleteConfirmModel"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorDetails.ml.confirmAlertDeleteMessage",defaultMessage:"Are you sure you want to delete the alert for anomalies?"})));var public_=__webpack_require__(14);const UptimeEditAlertFlyoutComponent=({alertFlyoutVisible:alertFlyoutVisible,initialAlert:initialAlert,setAlertFlyoutVisibility:setAlertFlyoutVisibility})=>{const{triggersActionsUi:triggersActionsUi}=Object(public_["useKibana"])().services;const EditAlertFlyout=Object(external_kbnSharedDeps_React_["useMemo"])(()=>triggersActionsUi.getEditAlertFlyout({initialAlert:initialAlert,onClose:()=>{setAlertFlyoutVisibility(false)}}),[initialAlert,setAlertFlyoutVisibility,triggersActionsUi]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,alertFlyoutVisible&&EditAlertFlyout)};const ManageMLJobComponent=({hasMLJob:hasMLJob,onEnableJob:onEnableJob,onJobDelete:onJobDelete})=>{const[isPopOverOpen,setIsPopOverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isFlyoutOpen,setIsFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const canDeleteMLJob=Object(lib["useSelector"])(selectors["c"]);const isMLJobCreating=Object(lib["useSelector"])(selectors["j"]);const isAlertDeleting=Object(lib["useSelector"])(alerts_alerts["m"]);const{loading:isMLJobLoading}=Object(lib["useSelector"])(selectors["f"]);const{loading:isCapbilityLoading}=Object(lib["useSelector"])(selectors["n"]);const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd}=Object(hooks["c"])();const monitorId=Object(hooks["d"])();const dispatch=Object(lib["useDispatch"])();const anomalyAlert=useAnomalyAlert();const[isConfirmAlertDeleteOpen,setIsConfirmAlertDeleteOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const deleteAnomalyAlert=()=>dispatch(alerts_alerts["g"].get({alertId:anomalyAlert===null||anomalyAlert===void 0?void 0:anomalyAlert.id}));const showLoading=isMLJobCreating||isMLJobLoading||isAlertDeleting||isCapbilityLoading;const btnText=hasMLJob?ANOMALY_DETECTION:ENABLE_ANOMALY_DETECTION;const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":hasMLJob?"uptimeManageMLJobBtn":"uptimeEnableAnomalyBtn",onClick:hasMLJob?()=>setIsPopOverOpen(true):onEnableJob,disabled:hasMLJob&&!canDeleteMLJob,isLoading:showLoading,size:"s","aria-label":ENABLE_MANAGE_JOB},showLoading?"":btnText);const panels=[{id:0,title:MANAGE_ANOMALY_DETECTION,items:[{name:EXPLORE_IN_ML_APP,icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"dataVisualizer",size:"m"}),href:getMLJobLinkHref({basePath:basePath,monitorId:monitorId,dateRange:{from:dateRangeStart,to:dateRangeEnd}})},...anomalyAlert?[{name:"Anomaly alert",icon:"bell","data-test-subj":"uptimeManageAnomalyAlertBtn",panel:1}]:[{name:ENABLE_ANOMALY_ALERT,"data-test-subj":"uptimeEnableAnomalyAlertBtn",icon:"bell",onClick:()=>{dispatch(Object(actions["G"])(alerts["b"].DURATION_ANOMALY));dispatch(Object(actions["H"])(true));setIsPopOverOpen(false)}}],{name:DISABLE_ANOMALY_DETECTION,"data-test-subj":"uptimeDeleteMLJobBtn",icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"trash",size:"m"}),onClick:()=>{setIsPopOverOpen(false);onJobDelete()}}]},{id:1,title:"Anomaly alert",items:[{name:"Edit","data-test-subj":"uptimeEditAnomalyAlertBtn",onClick:()=>{setIsFlyoutOpen(true);setIsPopOverOpen(false)}},{name:"Disable","data-test-subj":"uptimeDisableAnomalyAlertBtn",onClick:()=>{setIsConfirmAlertDeleteOpen(true)}}]}];const onCloseFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsFlyoutOpen(false);dispatch(alerts_alerts["i"].get({monitorId:monitorId}))},[dispatch,monitorId]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:button,isOpen:isPopOverOpen,closePopover:()=>setIsPopOverOpen(false),panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{initialPanelId:0,panels:panels,"data-test-subj":"uptimeManageMLContextMenu"})),isConfirmAlertDeleteOpen&&external_kbnSharedDeps_React_default.a.createElement(ConfirmAlertDeletion,{onConfirm:()=>{deleteAnomalyAlert();setIsConfirmAlertDeleteOpen(false)},onCancel:()=>{setIsConfirmAlertDeleteOpen(false)}}),isFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(UptimeEditAlertFlyoutComponent,{initialAlert:anomalyAlert,alertFlyoutVisible:isFlyoutOpen,setAlertFlyoutVisibility:onCloseFlyout}))};var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var helper=__webpack_require__(60);const LocationName=({location:location})=>!!location?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,location):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/beats/heartbeat/current/configuration-observer-options.html",target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.locationName.helpLinkAnnotation",{defaultMessage:"Add location",description:"Text that instructs the user to navigate to our docs to add a geographic location to their data"}));var actions_journey=__webpack_require__(57);var external_kbnSharedDeps_Moment_=__webpack_require__(13);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var constants=__webpack_require__(34);var translations=__webpack_require__(50);const getPingStatusLabel=(status,ping)=>{if(ping.monitor.type===constants["n"].BROWSER){return status==="up"?translations["d"]:translations["f"]}return status==="up"?translations["g"]:translations["e"]};const PingStatusColumn=({pingStatus:pingStatus,item:item})=>{const{colors:{dangerBehindText:dangerBehindText}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const timeStamp=external_kbnSharedDeps_Moment_default()(item.timestamp);let checkedTime="";if(external_kbnSharedDeps_Moment_default()().diff(timeStamp,"d")>1){checkedTime=timeStamp.format("ll LTS")}else{checkedTime=timeStamp.format("LTS")}return external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":`xpack.uptime.pingList.ping-${item.docId}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{className:"eui-textCenter",color:pingStatus===constants["s"].UP?"secondary":dangerBehindText},getPingStatusLabel(pingStatus,item)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.recencyMessage",{values:{fromNow:checkedTime},defaultMessage:"Checked {fromNow}",description:"A string used to inform our users how long ago Heartbeat pinged the selected host."})))};const STATUS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.statusColumnLabel",{defaultMessage:"Status"});const RES_CODE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.responseCodeColumnLabel",{defaultMessage:"Response code"});const ERROR_TYPE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.errorTypeColumnLabel",{defaultMessage:"Error type"});const ERROR_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.errorColumnLabel",{defaultMessage:"Error"});const LOCATION_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.locationNameColumnLabel",{defaultMessage:"Location"});const TIMESTAMP_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.timestampColumnLabel",{defaultMessage:"Timestamp"});const SpanWithMargin=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"SpanWithMargin",componentId:"sc-1r3i6at-0"})(["margin-right:16px;"]);const ResponseCodeColumn=({statusCode:statusCode})=>external_kbnSharedDeps_React_default.a.createElement(SpanWithMargin,null,statusCode?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":"pingResponseCode"},statusCode):"--");var external_kbnSharedDeps_ElasticEuiLibServicesFormat_=__webpack_require__(27);const bodyDocsLink="https://www.elastic.co/guide/en/beats/heartbeat/current/configuration-heartbeat-options.html#monitor-http-response";const DocLinkForBody=()=>{const docsLink=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:bodyDocsLink,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.drawer.body.docsLink",{defaultMessage:"docs",description:"Docs link to set response body"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"s",type:"popout"}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.pingList.expandedRow.response_body.notRecorded",defaultMessage:"Body not recorded. Read our {docsLink} for more information on recording response bodies.",values:{docsLink:docsLink}}))};const ListGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiListGroup"]).withConfig({displayName:"ListGroup",componentId:"oqzcs9-0"})(["&&&{a{padding-left:0;}}"]);const PingRedirects=({monitorStatus:monitorStatus,showTitle:showTitle})=>{var _monitorStatus$url,_monitorStatus$http,_monitorStatus$http$r,_list$length;const monitorUrl=monitorStatus===null||monitorStatus===void 0?void 0:(_monitorStatus$url=monitorStatus.url)===null||_monitorStatus$url===void 0?void 0:_monitorStatus$url.full;const list=monitorStatus===null||monitorStatus===void 0?void 0:(_monitorStatus$http=monitorStatus.http)===null||_monitorStatus$http===void 0?void 0:(_monitorStatus$http$r=_monitorStatus$http.response)===null||_monitorStatus$http$r===void 0?void 0:_monitorStatus$http$r.redirects;const listOfRedirects=[{label:monitorUrl,href:monitorUrl,iconType:"globe",size:"s",target:"_blank",extraAction:{color:"subdued",iconType:"popout",iconSize:"s",alwaysShow:true,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.redirects.openWindow",{defaultMessage:"Link will open in new window."})}}];(list!==null&&list!==void 0?list:[]).forEach(url=>{listOfRedirects.push({label:url,href:url,iconType:"sortDown",size:"s",target:"_blank",extraAction:{color:"subdued",iconType:"popout",iconSize:"s","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.redirects.openWindow",{defaultMessage:"Link will open in new window."}),alwaysShow:true}})});const Panel=showTitle?external_kbnSharedDeps_ElasticEui_["EuiPanel"]:"div";return list?external_kbnSharedDeps_React_default.a.createElement(Panel,{"data-test-subj":"uptimeMonitorPingListRedirectInfo"},showTitle&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.redirects.title",{defaultMessage:"Redirects"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.redirects.description",{defaultMessage:"Heartbeat followed {number} redirects while executing ping.",values:{number:(_list$length=list===null||list===void 0?void 0:list.length)!==null&&_list$length!==void 0?_list$length:0}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(ListGroup,{gutterSize:"none",listItems:listOfRedirects})):null};const EmptyJourney=({checkGroup:checkGroup})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"cross",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.emptyJourney.title",defaultMessage:"There are no steps for this journey"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.emptyJourney.message.heading",defaultMessage:"This journey did not contain any steps."})),!!checkGroup&&external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.emptyJourney.message.checkGroupField",defaultMessage:"The journey's check group is {codeBlock}.",values:{codeBlock:external_kbnSharedDeps_React_default.a.createElement("code",null,checkGroup)}})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.emptyJourney.message.footer",defaultMessage:"There is no further information to display."})))});const CodeBlockAccordion=({buttonContent:buttonContent,children:children,id:id,language:language,overflowHeight:overflowHeight})=>children&&id?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAccordion"],{id:id,buttonContent:buttonContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{isCopyable:true,overflowHeight:overflowHeight,language:language},children)):null;var useIntersection=__webpack_require__(152);var useIntersection_default=__webpack_require__.n(useIntersection);const THUMBNAIL_WIDTH=320;const THUMBNAIL_HEIGHT=180;const POPOVER_IMG_WIDTH=640;const POPOVER_IMG_HEIGHT=360;const StepImage=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiImage"]).withConfig({displayName:"StepImage",componentId:"zv6fae-0"})(["&&&{figcaption{display:none;}width:",",height:",",objectFit:'cover',objectPosition:'center top',}"],THUMBNAIL_WIDTH,THUMBNAIL_HEIGHT);const StepScreenshotDisplay=({checkGroup:checkGroup,screenshotExists:screenshotExists,stepIndex:stepIndex,stepName:stepName})=>{const containerRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const{colors:{lightestShade:pageBackground}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const[isImagePopoverOpen,setIsImagePopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const intersection=useIntersection_default()(containerRef,{root:null,rootMargin:"0px",threshold:1});const[hasIntersected,setHasIntersected]=Object(external_kbnSharedDeps_React_["useState"])(false);const isIntersecting=intersection===null||intersection===void 0?void 0:intersection.isIntersecting;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasIntersected===false&&isIntersecting===true){setHasIntersected(true)}},[hasIntersected,isIntersecting,setHasIntersected]);let content=null;const imgSrc=basePath+`/api/uptime/journey/screenshot/${checkGroup}/${stepIndex}`;if(hasIntersected&&screenshotExists){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{anchorPosition:"rightCenter",button:external_kbnSharedDeps_React_default.a.createElement(StepImage,{allowFullScreen:true,alt:stepName?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.screenshotDisplay.altText",{defaultMessage:'Screenshot for step with name "{stepName}"',values:{stepName:stepName}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.screenshotDisplay.altTextWithoutName",{defaultMessage:"Screenshot"}),caption:`Step:${stepIndex} ${stepName}`,hasShadow:true,url:imgSrc,onMouseEnter:()=>setIsImagePopoverOpen(true),onMouseLeave:()=>setIsImagePopoverOpen(false)}),closePopover:()=>setIsImagePopoverOpen(false),isOpen:isImagePopoverOpen},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiImage"],{alt:stepName?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.screenshotDisplay.thumbnailAltText",{defaultMessage:'Thumbnail screenshot for step with name "{stepName}"',values:{stepName:stepName}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.screenshotDisplay.thumbnailAltTextWithoutName",{defaultMessage:"Thumbnail screenshot"}),url:imgSrc,style:{width:POPOVER_IMG_WIDTH,height:POPOVER_IMG_HEIGHT,objectFit:"contain"}})))}else if(screenshotExists===false){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",direction:"column",style:{paddingTop:"32px"},"data-test-subj":"stepScreenshotImageUnavailable"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"subdued",size:"xxl",type:"image"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.screenshot.noImageMessage",defaultMessage:"No image available"})))))}return external_kbnSharedDeps_React_default.a.createElement("div",{ref:containerRef,style:{backgroundColor:pageBackground,height:THUMBNAIL_HEIGHT,width:THUMBNAIL_WIDTH}},content)};function colorFromStatus(color,status){switch(status){case"succeeded":return color.success;case"failed":return color.dangerBehindText;default:return"default"}}function textFromStatus(status){switch(status){case"succeeded":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.statusBadge.succeededMessage",{defaultMessage:"Succeeded"});case"failed":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.statusBadge.failedMessage",{defaultMessage:"Failed"});case"skipped":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.statusBadge.skippedMessage",{defaultMessage:"Skipped"});default:return null}}const StatusBadge=({status:status})=>{const theme=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:colorFromStatus(theme.colors,status)},textFromStatus(status))};var react_router_helpers=__webpack_require__(174);const StepDetailLink=({children:children,checkGroupId:checkGroupId,stepIndex:stepIndex})=>{const to=`/journey/${checkGroupId}/step/${stepIndex}`;return external_kbnSharedDeps_React_default.a.createElement(react_router_helpers["a"],{"data-test-subj":`step-detail-link`,to:to,size:"s",fill:true,fullWidth:false},children)};const VIEW_PERFORMANCE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.synthetics.performanceBreakDown",{defaultMessage:"View performance breakdown"});const CODE_BLOCK_OVERFLOW_HEIGHT=360;const ExecutedStep=({step:step,index:index,checkGroup:checkGroup})=>{var _step$synthetics,_step$synthetics$step,_step$synthetics2,_step$synthetics2$pay,_step$synthetics3,_step$synthetics4,_step$synthetics4$ste,_step$synthetics5,_step$synthetics5$ste,_step$synthetics6,_step$synthetics6$ste,_step$synthetics7,_step$synthetics7$ste,_step$synthetics8,_step$synthetics8$pay,_step$synthetics9,_step$synthetics9$ste,_step$synthetics10,_step$synthetics10$er,_step$synthetics11,_step$synthetics11$st,_step$synthetics12,_step$synthetics12$er;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("div",{style:{padding:"8px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.executedStep.stepName",defaultMessage:"{stepNumber}. {stepName}",values:{stepNumber:index+1,stepName:(_step$synthetics=step.synthetics)===null||_step$synthetics===void 0?void 0:(_step$synthetics$step=_step$synthetics.step)===null||_step$synthetics$step===void 0?void 0:_step$synthetics$step.name}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(StatusBadge,{status:(_step$synthetics2=step.synthetics)===null||_step$synthetics2===void 0?void 0:(_step$synthetics2$pay=_step$synthetics2.payload)===null||_step$synthetics2$pay===void 0?void 0:_step$synthetics2$pay.status})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(StepScreenshotDisplay,{checkGroup:step.monitor.check_group,screenshotExists:(_step$synthetics3=step.synthetics)===null||_step$synthetics3===void 0?void 0:_step$synthetics3.screenshotExists,stepIndex:(_step$synthetics4=step.synthetics)===null||_step$synthetics4===void 0?void 0:(_step$synthetics4$ste=_step$synthetics4.step)===null||_step$synthetics4$ste===void 0?void 0:_step$synthetics4$ste.index,stepName:(_step$synthetics5=step.synthetics)===null||_step$synthetics5===void 0?void 0:(_step$synthetics5$ste=_step$synthetics5.step)===null||_step$synthetics5$ste===void 0?void 0:_step$synthetics5$ste.name})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,((_step$synthetics6=step.synthetics)===null||_step$synthetics6===void 0?void 0:(_step$synthetics6$ste=_step$synthetics6.step)===null||_step$synthetics6$ste===void 0?void 0:_step$synthetics6$ste.index)&&external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(StepDetailLink,{checkGroupId:checkGroup,stepIndex:step.synthetics.step.index},VIEW_PERFORMANCE),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),external_kbnSharedDeps_React_default.a.createElement(CodeBlockAccordion,{id:((_step$synthetics7=step.synthetics)===null||_step$synthetics7===void 0?void 0:(_step$synthetics7$ste=_step$synthetics7.step)===null||_step$synthetics7$ste===void 0?void 0:_step$synthetics7$ste.name)+String(index),buttonContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.executedStep.scriptHeading",{defaultMessage:"Step script"}),overflowHeight:CODE_BLOCK_OVERFLOW_HEIGHT,language:"javascript"},(_step$synthetics8=step.synthetics)===null||_step$synthetics8===void 0?void 0:(_step$synthetics8$pay=_step$synthetics8.payload)===null||_step$synthetics8$pay===void 0?void 0:_step$synthetics8$pay.source),external_kbnSharedDeps_React_default.a.createElement(CodeBlockAccordion,{id:`${(_step$synthetics9=step.synthetics)===null||_step$synthetics9===void 0?void 0:(_step$synthetics9$ste=_step$synthetics9.step)===null||_step$synthetics9$ste===void 0?void 0:_step$synthetics9$ste.name}_error`,buttonContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.executedStep.errorHeading",{defaultMessage:"Error"}),language:"html",overflowHeight:CODE_BLOCK_OVERFLOW_HEIGHT},(_step$synthetics10=step.synthetics)===null||_step$synthetics10===void 0?void 0:(_step$synthetics10$er=_step$synthetics10.error)===null||_step$synthetics10$er===void 0?void 0:_step$synthetics10$er.message),external_kbnSharedDeps_React_default.a.createElement(CodeBlockAccordion,{id:`${(_step$synthetics11=step.synthetics)===null||_step$synthetics11===void 0?void 0:(_step$synthetics11$st=_step$synthetics11.step)===null||_step$synthetics11$st===void 0?void 0:_step$synthetics11$st.name}_stack`,buttonContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.executedStep.stackTrace",{defaultMessage:"Stack trace"}),language:"html",overflowHeight:CODE_BLOCK_OVERFLOW_HEIGHT},(_step$synthetics12=step.synthetics)===null||_step$synthetics12===void 0?void 0:(_step$synthetics12$er=_step$synthetics12.error)===null||_step$synthetics12$er===void 0?void 0:_step$synthetics12$er.stack))))))};function executed_journey_statusMessage(count){const total=count.succeeded+count.failed+count.skipped;if(count.failed+count.skipped===total){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.journey.allFailedMessage",{defaultMessage:"{total} Steps - all failed or skipped",values:{total:total}})}else if(count.succeeded===total){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.journey.allSucceededMessage",{defaultMessage:"{total} Steps - all succeeded",values:{total:total}})}return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.journey.partialSuccessMessage",{defaultMessage:"{total} Steps - {succeeded} succeeded",values:{succeeded:count.succeeded,total:total}})}function reduceStepStatus(prev,cur){var _cur$synthetics,_cur$synthetics$paylo,_cur$synthetics2,_cur$synthetics2$payl;if(((_cur$synthetics=cur.synthetics)===null||_cur$synthetics===void 0?void 0:(_cur$synthetics$paylo=_cur$synthetics.payload)===null||_cur$synthetics$paylo===void 0?void 0:_cur$synthetics$paylo.status)==="succeeded"){prev.succeeded+=1;return prev}else if(((_cur$synthetics2=cur.synthetics)===null||_cur$synthetics2===void 0?void 0:(_cur$synthetics2$payl=_cur$synthetics2.payload)===null||_cur$synthetics2$payl===void 0?void 0:_cur$synthetics2$payl.status)==="skipped"){prev.skipped+=1;return prev}prev.failed+=1;return prev}function isStepEnd(step){var _step$synthetics;return((_step$synthetics=step.synthetics)===null||_step$synthetics===void 0?void 0:_step$synthetics.type)==="step/end"}const ExecutedJourney=({journey:journey})=>external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.executedJourney.heading",defaultMessage:"Summary information"})),external_kbnSharedDeps_React_default.a.createElement("p",null,executed_journey_statusMessage(journey.steps.filter(isStepEnd).reduce(reduceStepStatus,{failed:0,skipped:0,succeeded:0})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},journey.steps.filter(isStepEnd).map((step,index)=>external_kbnSharedDeps_React_default.a.createElement(ExecutedStep,{key:index,index:index,step:step,checkGroup:journey.checkGroup})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})));const ConsoleEvent=({event:event})=>{var _event$synthetics,_event$synthetics2,_event$synthetics3,_event$synthetics3$pa;const{colors:{danger:danger}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);let typeColor;if(((_event$synthetics=event.synthetics)===null||_event$synthetics===void 0?void 0:_event$synthetics.type)==="stderr"){typeColor=danger}else{typeColor=undefined}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},event.timestamp),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{color:typeColor}},(_event$synthetics2=event.synthetics)===null||_event$synthetics2===void 0?void 0:_event$synthetics2.type),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,(_event$synthetics3=event.synthetics)===null||_event$synthetics3===void 0?void 0:(_event$synthetics3$pa=_event$synthetics3.payload)===null||_event$synthetics3$pa===void 0?void 0:_event$synthetics3$pa.message))};const isConsoleStep=step=>{var _step$synthetics,_step$synthetics2,_step$synthetics3;return((_step$synthetics=step.synthetics)===null||_step$synthetics===void 0?void 0:_step$synthetics.type)==="stderr"||((_step$synthetics2=step.synthetics)===null||_step$synthetics2===void 0?void 0:_step$synthetics2.type)==="stdout"||((_step$synthetics3=step.synthetics)===null||_step$synthetics3===void 0?void 0:_step$synthetics3.type)==="cmd/status"};const ConsoleOutputEventList=({journey:journey})=>external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.consoleStepList.title",defaultMessage:"No steps ran"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.consoleStepList.message",defaultMessage:"This journey failed to run, recorded console output is shown below:"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],null,journey.steps.filter(isConsoleStep).map(consoleEvent=>external_kbnSharedDeps_React_default.a.createElement(ConsoleEvent,{event:consoleEvent,key:consoleEvent.docId+"_console-event-row"}))));const BrowserExpandedRow=({checkGroup:checkGroup})=>{const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(checkGroup){dispatch(Object(actions_journey["a"])({checkGroup:checkGroup}))}},[dispatch,checkGroup]);const journeys=Object(lib["useSelector"])(selectors["m"]);const journey=journeys[checkGroup!==null&&checkGroup!==void 0?checkGroup:""];return external_kbnSharedDeps_React_default.a.createElement(BrowserExpandedRowComponent,{checkGroup:checkGroup,journey:journey})};const stepEnd=step=>{var _step$synthetics;return((_step$synthetics=step.synthetics)===null||_step$synthetics===void 0?void 0:_step$synthetics.type)==="step/end"};const stepConsole=step=>{var _step$synthetics$type,_step$synthetics2;return["stderr","cmd/status"].indexOf((_step$synthetics$type=(_step$synthetics2=step.synthetics)===null||_step$synthetics2===void 0?void 0:_step$synthetics2.type)!==null&&_step$synthetics$type!==void 0?_step$synthetics$type:"")!==-1};const BrowserExpandedRowComponent=({checkGroup:checkGroup,journey:journey})=>{if(!!journey&&journey.loading){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],null))}if(!journey||journey.steps.length===0){return external_kbnSharedDeps_React_default.a.createElement(EmptyJourney,{checkGroup:checkGroup})}if(journey.steps.some(stepEnd))return external_kbnSharedDeps_React_default.a.createElement(ExecutedJourney,{journey:journey});if(journey.steps.some(stepConsole))return external_kbnSharedDeps_React_default.a.createElement(ConsoleOutputEventList,{journey:journey});return null};const PingHeaders=({headers:headers})=>{const headersList=Object.keys(headers).sort().map(header=>({title:header,description:headers[header]}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAccordion"],{id:"responseHeaderAccord",buttonContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.headers.title",{defaultMessage:"Response headers"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{titleProps:{style:{width:"30%",paddingLeft:30}},compressed:true,type:"responsiveColumn",listItems:headersList})))};const BodyDescription=({body:body})=>{const contentBytes=body.content_bytes||0;const bodyBytes=body.bytes||0;const truncatedText=contentBytes>0&&contentBytes<bodyBytes?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.expandedRow.truncated",{defaultMessage:"Showing first {contentBytes} bytes.",values:{contentBytes:contentBytes}}):null;const bodySizeText=bodyBytes>0?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.expandedRow.bodySize",{defaultMessage:"Body size is {bodyBytes}.",values:{bodyBytes:Object(external_kbnSharedDeps_ElasticEuiLibServicesFormat_["formatNumber"])(bodyBytes,"0b")}}):null;const combinedText=[truncatedText,bodySizeText].filter(s=>s).join(" ");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,combinedText)};const BodyExcerpt=({content:content})=>content?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{overflowHeight:250},content):null;const PingListExpandedRowComponent=({ping:ping})=>{var _ping$http,_ping$http$response,_ping$http2,_ping$http2$response,_ping$http3,_ping$http3$response,_ping$http4,_ping$http4$response;const listItems=[];if(ping.monitor.type==="browser"){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{iconType:"beaker",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.experimentalCallout.title",{defaultMessage:"Experimental feature"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(BrowserExpandedRow,{checkGroup:ping.monitor.check_group})))}if(ping.error){listItems.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.expandedRow.error",{defaultMessage:"Error"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,ping.error.message)})}if((_ping$http=ping.http)!==null&&_ping$http!==void 0&&(_ping$http$response=_ping$http.response)!==null&&_ping$http$response!==void 0&&_ping$http$response.body){const body=ping.http.response.body;listItems.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.expandedRow.response_body",{defaultMessage:"Response Body"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(BodyDescription,{body:body}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),body.content?external_kbnSharedDeps_React_default.a.createElement(BodyExcerpt,{content:body.content||""}):external_kbnSharedDeps_React_default.a.createElement(DocLinkForBody,null))})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},(ping===null||ping===void 0?void 0:(_ping$http2=ping.http)===null||_ping$http2===void 0?void 0:(_ping$http2$response=_ping$http2.response)===null||_ping$http2$response===void 0?void 0:_ping$http2$response.redirects)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(PingRedirects,{monitorStatus:ping,showTitle:true})),(ping===null||ping===void 0?void 0:(_ping$http3=ping.http)===null||_ping$http3===void 0?void 0:(_ping$http3$response=_ping$http3.response)===null||_ping$http3$response===void 0?void 0:_ping$http3$response.headers)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(PingHeaders,{headers:ping===null||ping===void 0?void 0:(_ping$http4=ping.http)===null||_ping$http4===void 0?void 0:(_ping$http4$response=_ping$http4.response)===null||_ping$http4$response===void 0?void 0:_ping$http4$response.headers})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:ping!==null&&ping!==void 0&&ping.error?"danger":"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{listItems:listItems}))))};const toggleDetails=(ping,expandedRows,setExpandedRows)=>{if(expandedRows[ping.docId]){delete expandedRows[ping.docId];setExpandedRows({...expandedRows});return}setExpandedRows({...expandedRows,[ping.docId]:external_kbnSharedDeps_React_default.a.createElement(PingListExpandedRowComponent,{ping:ping})})};function rowShouldExpand(item){var _item$http$response$b,_item$http,_item$http$response,_item$http$response$b2;const errorPresent=!!item.error;const httpBodyPresent=(_item$http$response$b=(_item$http=item.http)===null||_item$http===void 0?void 0:(_item$http$response=_item$http.response)===null||_item$http$response===void 0?void 0:(_item$http$response$b2=_item$http$response.body)===null||_item$http$response$b2===void 0?void 0:_item$http$response$b2.bytes)!==null&&_item$http$response$b!==void 0?_item$http$response$b:0>0;const isBrowserMonitor=item.monitor.type==="browser";return errorPresent||httpBodyPresent||isBrowserMonitor}const ExpandRowColumn=({item:item,expandedRows:expandedRows,setExpandedRows:setExpandedRows})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"data-test-subj":"uptimePingListExpandBtn",onClick:()=>toggleDetails(item,expandedRows,setExpandedRows),disabled:!rowShouldExpand(item),"aria-label":expandedRows[item.docId]?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.collapseRow",{defaultMessage:"Collapse"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.expandRow",{defaultMessage:"Expand"}),iconType:expandedRows[item.docId]?"arrowUp":"arrowDown"});const StyledSpan=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"StyledSpan",componentId:"ine95p-0"})(["display:-webkit-box;-webkit-box-orient:vertical;-webkit-line-clamp:3;overflow:hidden;"]);const PingErrorCol=({errorType:errorType,ping:ping})=>{var _ping$error;if(!errorType){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,"--")}return external_kbnSharedDeps_React_default.a.createElement(StyledSpan,null,errorType,":",(_ping$error=ping.error)===null||_ping$error===void 0?void 0:_ping$error.message)};var observability_public_=__webpack_require__(16);var api_journey=__webpack_require__(100);const prevAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.prevStepButton.airaLabel",{defaultMessage:"Previous step"});const nextAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.nextStepButton.ariaLabel",{defaultMessage:"Next step"});const imageLoadingSpinnerAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.imageLoadingSpinner.ariaLabel",{defaultMessage:"An animated spinner indicating the image is loading"});const fullSizeImageAlt=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.thumbnail.fullSize.alt",{defaultMessage:`A larger version of the screenshot for this journey step's thumbnail.`});const formatCaptionContent=(stepNumber,totalSteps)=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.synthetics.pingTimestamp.captionContent",{defaultMessage:"Step: {stepNumber} of {totalSteps}",values:{stepNumber:stepNumber,totalSteps:totalSteps}});const NavButtons=({maxSteps:maxSteps,setIsImagePopoverOpen:setIsImagePopoverOpen,setStepNumber:setStepNumber,stepNumber:stepNumber})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{className:"stepArrows",gutterSize:"s",alignItems:"center",onMouseEnter:()=>setIsImagePopoverOpen(true),style:{position:"absolute",bottom:0,left:30}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{disabled:stepNumber===1,color:"subdued",size:"s",onClick:()=>{setStepNumber(stepNumber-1)},iconType:"arrowLeft","aria-label":prevAriaLabel})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{disabled:stepNumber===maxSteps,color:"subdued",size:"s",onClick:()=>{setStepNumber(stepNumber+1)},iconType:"arrowRight","aria-label":nextAriaLabel})));var common_=__webpack_require__(18);const BorderedText=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiText"])`
  width: 120px;
  text-align: center;
  border: 1px solid ${props=>props.theme.eui.euiColorLightShade};
`;const NoImageAvailable=()=>external_kbnSharedDeps_React_default.a.createElement(BorderedText,{"data-test-subj":"pingTimestampNoImageAvailable"},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.synthetics.screenshot.noImageMessage",defaultMessage:"No image available"})));const NoImageDisplay=({imageCaption:imageCaption,isLoading:isLoading,isPending:isPending})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,isLoading||isPending?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{"aria-label":imageLoadingSpinnerAriaLabel,size:"xl","data-test-subj":"pingTimestampSpinner"}):external_kbnSharedDeps_React_default.a.createElement(NoImageAvailable,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,imageCaption));var monitor_status_column=__webpack_require__(72);const step_image_caption_ImageCaption=common_["euiStyled"].div`
  background-color: ${props=>props.theme.eui.euiColorLightestShade};
  display: inline-block;
  width: 100%;
  text-decoration: none;
`;const StepImageCaption=({captionContent:captionContent,imgSrc:imgSrc,maxSteps:maxSteps,setStepNumber:setStepNumber,stepNumber:stepNumber,timestamp:timestamp,isLoading:isLoading})=>external_kbnSharedDeps_React_default.a.createElement(step_image_caption_ImageCaption,null,external_kbnSharedDeps_React_default.a.createElement("div",{className:"stepArrowsFullScreen"},imgSrc&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{disabled:stepNumber===1,onClick:()=>{setStepNumber(stepNumber-1)},iconType:"arrowLeft","aria-label":prevAriaLabel,isLoading:isLoading},prevAriaLabel)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,captionContent)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{disabled:stepNumber===maxSteps,onClick:()=>{setStepNumber(stepNumber+1)},iconType:"arrowRight",iconSide:"right","aria-label":nextAriaLabel,isLoading:isLoading},nextAriaLabel))),external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textNoWrap"},Object(monitor_status_column["c"])(external_kbnSharedDeps_Moment_default()(timestamp)))));const step_image_popover_POPOVER_IMG_HEIGHT=360;const step_image_popover_POPOVER_IMG_WIDTH=640;const step_image_popover_StepImage=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiImage"]).withConfig({displayName:"StepImage",componentId:"mgs2a6-0"})(["&&&{display:flex;figure.euiImage-isFullScreen{display:flex;div.stepArrowsFullScreen{display:flex;}}}"]);const StepImagePopover=({captionContent:captionContent,imageCaption:imageCaption,imgSrc:imgSrc,isImagePopoverOpen:isImagePopoverOpen})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{anchorPosition:"upCenter",button:external_kbnSharedDeps_React_default.a.createElement(step_image_popover_StepImage,{allowFullScreen:true,alt:captionContent,caption:imageCaption,"data-test-subj":"pingTimestampImage",hasShadow:true,url:imgSrc,size:"s",className:"syntheticsStepImage"}),isOpen:isImagePopoverOpen},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiImage"],{alt:fullSizeImageAlt,url:imgSrc,style:{height:step_image_popover_POPOVER_IMG_HEIGHT,width:step_image_popover_POPOVER_IMG_WIDTH,objectFit:"contain"}}));const StepDiv=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"StepDiv",componentId:"ulyb34-0"})(["figure.euiImage{div.stepArrowsFullScreen{display:none;}}position:relative;div.stepArrows{display:none;}:hover{div.stepArrows{display:flex;}}"]);const PingTimestamp=({timestamp:timestamp,ping:ping})=>{var _stepImages;const[stepNumber,setStepNumber]=Object(external_kbnSharedDeps_React_["useState"])(1);const[isImagePopoverOpen,setIsImagePopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[stepImages,setStepImages]=Object(external_kbnSharedDeps_React_["useState"])([]);const intersectionRef=external_kbnSharedDeps_React_default.a.useRef(null);const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const imgPath=`${basePath}/api/uptime/journey/screenshot/${ping.monitor.check_group}/${stepNumber}`;const intersection=useIntersection_default()(intersectionRef,{root:null,rootMargin:"0px",threshold:1});const{data:data,status:status}=Object(observability_public_["useFetcher"])(()=>{if(intersection&&intersection.intersectionRatio===1&&!stepImages[stepNumber-1])return Object(api_journey["c"])(imgPath)},[intersection===null||intersection===void 0?void 0:intersection.intersectionRatio,stepNumber]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(data){setStepImages(prevState=>[...prevState,data===null||data===void 0?void 0:data.src])}},[data]);const imgSrc=(_stepImages=stepImages===null||stepImages===void 0?void 0:stepImages[stepNumber-1])!==null&&_stepImages!==void 0?_stepImages:data===null||data===void 0?void 0:data.src;const captionContent=formatCaptionContent(stepNumber,data===null||data===void 0?void 0:data.maxSteps);const ImageCaption=external_kbnSharedDeps_React_default.a.createElement(StepImageCaption,{captionContent:captionContent,imgSrc:imgSrc,maxSteps:data===null||data===void 0?void 0:data.maxSteps,setStepNumber:setStepNumber,stepNumber:stepNumber,timestamp:timestamp,isLoading:status===observability_public_["FETCH_STATUS"].LOADING||status===observability_public_["FETCH_STATUS"].PENDING});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(StepDiv,{onMouseEnter:()=>setIsImagePopoverOpen(true),onMouseLeave:()=>setIsImagePopoverOpen(false),ref:intersectionRef},imgSrc?external_kbnSharedDeps_React_default.a.createElement(StepImagePopover,{captionContent:captionContent,imageCaption:ImageCaption,imgSrc:imgSrc,isImagePopoverOpen:isImagePopoverOpen}):external_kbnSharedDeps_React_default.a.createElement(NoImageDisplay,{imageCaption:ImageCaption,isLoading:status===observability_public_["FETCH_STATUS"].LOADING,isPending:status===observability_public_["FETCH_STATUS"].PENDING}),external_kbnSharedDeps_React_default.a.createElement(NavButtons,{maxSteps:data===null||data===void 0?void 0:data.maxSteps,setIsImagePopoverOpen:setIsImagePopoverOpen,setStepNumber:setStepNumber,stepNumber:stepNumber}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textNoWrap"},Object(monitor_status_column["c"])(external_kbnSharedDeps_Moment_default()(timestamp)))))};const FailedStep=({ping:ping,failedSteps:failedSteps})=>{var _failedSteps$steps,_thisFailedStep$synth,_thisFailedStep$synth2,_thisFailedStep$synth3,_thisFailedStep$synth4;const thisFailedStep=failedSteps===null||failedSteps===void 0?void 0:(_failedSteps$steps=failedSteps.steps)===null||_failedSteps$steps===void 0?void 0:_failedSteps$steps.find(fs=>fs.monitor.check_group===ping.monitor.check_group);if(!thisFailedStep){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,"--")}return external_kbnSharedDeps_React_default.a.createElement("div",null,(_thisFailedStep$synth=thisFailedStep.synthetics)===null||_thisFailedStep$synth===void 0?void 0:(_thisFailedStep$synth2=_thisFailedStep$synth.step)===null||_thisFailedStep$synth2===void 0?void 0:_thisFailedStep$synth2.index,". ",(_thisFailedStep$synth3=thisFailedStep.synthetics)===null||_thisFailedStep$synth3===void 0?void 0:(_thisFailedStep$synth4=_thisFailedStep$synth3.step)===null||_thisFailedStep$synth4===void 0?void 0:_thisFailedStep$synth4.name)};var use_selected_filters=__webpack_require__(153);const usePingsList=({pageSize:pageSize,pageIndex:pageIndex})=>{const{error:error,loading:loading,pingList:{pings:pings,total:total}}=Object(lib["useSelector"])(selectors["E"]);const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{dateRangeStart:from,dateRangeEnd:to}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const{statusFilter:statusFilter}=Object(hooks["c"])();const{selectedLocations:selectedLocations}=Object(use_selected_filters["a"])();const dispatch=Object(lib["useDispatch"])();const monitorId=Object(hooks["d"])();const getPings=Object(external_kbnSharedDeps_React_["useCallback"])(params=>dispatch(Object(actions["y"])(params)),[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getPings({monitorId:monitorId,dateRange:{from:from,to:to},locations:JSON.stringify(selectedLocations),index:pageIndex,size:pageSize,status:statusFilter!=="all"?statusFilter:""})},[from,to,getPings,monitorId,lastRefresh,pageIndex,pageSize,statusFilter,selectedLocations]);const{data:data}=Object(observability_public_["useFetcher"])(()=>{if((pings===null||pings===void 0?void 0:pings.length)>0&&pings.find(ping=>ping.monitor.type===constants["n"].BROWSER))return Object(api_journey["b"])({checkGroups:pings.map(ping=>ping.monitor.check_group)})},[pings]);return{error:error,loading:loading,pings:pings,total:total,failedSteps:data}};var status_filter=__webpack_require__(179);var filter_group=__webpack_require__(116);const PingListHeader=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.pingList.checkHistoryTitle",defaultMessage:"History"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(status_filter["a"],null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(filter_group["a"],null)));const ping_list_SpanWithMargin=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"SpanWithMargin",componentId:"ju227x-0"})(["margin-right:16px;"]);const DEFAULT_PAGE_SIZE=10;const ONE_SECOND_AS_MICROS=1e6;const MILLIS_LIMIT=ONE_SECOND_AS_MICROS*1;const formatDuration=durationMicros=>{if(durationMicros<MILLIS_LIMIT){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.durationMsColumnFormatting",{values:{millis:Object(helper["a"])(durationMicros)},defaultMessage:"{millis} ms"})}const seconds=(durationMicros/ONE_SECOND_AS_MICROS).toFixed(0);if(seconds==="1"){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingist.durationSecondsColumnFormatting.singular",{values:{seconds:seconds},defaultMessage:"{seconds} second"})}return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingist.durationSecondsColumnFormatting",{values:{seconds:seconds},defaultMessage:"{seconds} seconds"})};const PingList=()=>{var _pings$;const[pageSize,setPageSize]=Object(external_kbnSharedDeps_React_["useState"])(DEFAULT_PAGE_SIZE);const[pageIndex,setPageIndex]=Object(external_kbnSharedDeps_React_["useState"])(0);const dispatch=Object(lib["useDispatch"])();const pruneJourneysCallback=Object(external_kbnSharedDeps_React_["useCallback"])(checkGroups=>dispatch(Object(actions_journey["d"])(checkGroups)),[dispatch]);const{error:error,loading:loading,pings:pings,total:total,failedSteps:failedSteps}=usePingsList({pageSize:pageSize,pageIndex:pageIndex});const[expandedRows,setExpandedRows]=Object(external_kbnSharedDeps_React_["useState"])({});const expandedIdsToRemove=JSON.stringify(Object.keys(expandedRows).filter(e=>!pings.some(({docId:docId})=>docId===e)));Object(external_kbnSharedDeps_React_["useEffect"])(()=>()=>{dispatch(Object(actions["a"])())},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const parsed=JSON.parse(expandedIdsToRemove);if(parsed.length){parsed.forEach(docId=>{delete expandedRows[docId]});setExpandedRows(expandedRows)}},[expandedIdsToRemove,expandedRows]);const expandedCheckGroups=pings.filter(p=>Object.keys(expandedRows).some(f=>p.docId===f)).map(({monitor:{check_group:cg}})=>cg);const expandedCheckGroupsStr=JSON.stringify(expandedCheckGroups);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{pruneJourneysCallback(JSON.parse(expandedCheckGroupsStr))},[pruneJourneysCallback,expandedCheckGroupsStr]);const hasStatus=pings.reduce((hasHttpStatus,currentPing)=>{var _currentPing$http,_currentPing$http$res;return hasHttpStatus||!!((_currentPing$http=currentPing.http)!==null&&_currentPing$http!==void 0&&(_currentPing$http$res=_currentPing$http.response)!==null&&_currentPing$http$res!==void 0&&_currentPing$http$res.status_code)},false);const monitorType=pings===null||pings===void 0?void 0:(_pings$=pings[0])===null||_pings$===void 0?void 0:_pings$.monitor.type;const columns=[{field:"monitor.status",name:STATUS_LABEL,render:(pingStatus,item)=>external_kbnSharedDeps_React_default.a.createElement(PingStatusColumn,{pingStatus:pingStatus,item:item})},{align:"left",field:"observer.geo.name",name:LOCATION_LABEL,render:location=>external_kbnSharedDeps_React_default.a.createElement(LocationName,{location:location})},...monitorType===constants["n"].BROWSER?[{align:"left",field:"timestamp",name:TIMESTAMP_LABEL,render:(timestamp,item)=>external_kbnSharedDeps_React_default.a.createElement(PingTimestamp,{timestamp:timestamp,ping:item})}]:[],...monitorType!==constants["n"].BROWSER?[{align:"right",dataType:"number",field:"monitor.ip",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.ipAddressColumnLabel",{defaultMessage:"IP"})}]:[],{align:"center",field:"monitor.duration.us",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.durationMsColumnLabel",{defaultMessage:"Duration"}),render:duration=>formatDuration(duration)},{field:"error.type",name:ERROR_LABEL,width:"30%",render:(errorType,item)=>external_kbnSharedDeps_React_default.a.createElement(PingErrorCol,{ping:item,errorType:errorType})},...monitorType===constants["n"].BROWSER?[{field:"monitor.status",align:"left",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.columns.failedStep",{defaultMessage:"Failed step"}),render:(timestamp,item)=>external_kbnSharedDeps_React_default.a.createElement(FailedStep,{ping:item,failedSteps:failedSteps})}]:[],...hasStatus?[{field:"http.response.status_code",align:"right",name:external_kbnSharedDeps_React_default.a.createElement(ping_list_SpanWithMargin,null,RES_CODE_LABEL),render:statusCode=>external_kbnSharedDeps_React_default.a.createElement(ResponseCodeColumn,{statusCode:statusCode})}]:[],{align:"right",width:"24px",isExpander:true,render:item=>external_kbnSharedDeps_React_default.a.createElement(ExpandRowColumn,{item:item,expandedRows:expandedRows,setExpandedRows:setExpandedRows})}];const pagination={initialPageSize:DEFAULT_PAGE_SIZE,pageIndex:pageIndex,pageSize:pageSize,pageSizeOptions:[10,25,50,100],totalItemCount:total};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(PingListHeader,null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{loading:loading,columns:columns,error:error===null||error===void 0?void 0:error.message,isExpandable:true,hasActions:true,items:pings,itemId:"docId",itemIdToExpandedRowMap:expandedRows,pagination:pagination,noItemsMessage:loading?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.pingsLoadingMesssage",{defaultMessage:"Loading history..."}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.pingList.pingsUnavailableMessage",{defaultMessage:"No history found"}),onChange:criteria=>{setPageSize(criteria.page.size);setPageIndex(criteria.page.index)},tableLayout:"auto"}))};var uuid=__webpack_require__(233);var uuid_default=__webpack_require__.n(uuid);var external_kbnSharedDeps_ReactDom_=__webpack_require__(20);var __extends=undefined&&undefined.__extends||function(){var extendStatics=function(d,b){extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return extendStatics(d,b)};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();var createPortalNode=function(){var initialProps={};var parent;var lastPlaceholder;var portalNode=Object.assign(document.createElement("div"),{setPortalProps:function(props){initialProps=props},getInitialPortalProps:function(){return initialProps},mount:function(newParent,newPlaceholder){if(newPlaceholder===lastPlaceholder){return}portalNode.unmount();newParent.replaceChild(portalNode,newPlaceholder);parent=newParent;lastPlaceholder=newPlaceholder},unmount:function(expectedPlaceholder){if(expectedPlaceholder&&expectedPlaceholder!==lastPlaceholder){return}if(parent&&lastPlaceholder){parent.replaceChild(lastPlaceholder,portalNode);parent=undefined;lastPlaceholder=undefined}}});return portalNode};var web_InPortal=function(_super){__extends(InPortal,_super);function InPortal(props){var _this=_super.call(this,props)||this;_this.addPropsChannel=function(){Object.assign(_this.props.node,{setPortalProps:function(props){_this.setState({nodeProps:props})}})};_this.state={nodeProps:_this.props.node.getInitialPortalProps()};return _this}InPortal.prototype.componentDidMount=function(){this.addPropsChannel()};InPortal.prototype.componentDidUpdate=function(){this.addPropsChannel()};InPortal.prototype.render=function(){var _this=this;var _a=this.props,children=_a.children,node=_a.node;return external_kbnSharedDeps_ReactDom_["createPortal"](external_kbnSharedDeps_React_["Children"].map(children,(function(child){if(!external_kbnSharedDeps_React_["isValidElement"](child))return child;return external_kbnSharedDeps_React_["cloneElement"](child,_this.state.nodeProps)})),node)};return InPortal}(external_kbnSharedDeps_React_["PureComponent"]);var web_OutPortal=function(_super){__extends(OutPortal,_super);function OutPortal(props){var _this=_super.call(this,props)||this;_this.placeholderNode=external_kbnSharedDeps_React_["createRef"]();_this.passPropsThroughPortal();return _this}OutPortal.prototype.passPropsThroughPortal=function(){var propsForTarget=Object.assign({},this.props,{node:undefined});this.props.node.setPortalProps(propsForTarget)};OutPortal.prototype.componentDidMount=function(){var node=this.props.node;var placeholder=this.placeholderNode.current;var parent=placeholder.parentNode;node.mount(parent,placeholder);this.passPropsThroughPortal()};OutPortal.prototype.componentDidUpdate=function(){var node=this.props.node;var placeholder=this.placeholderNode.current;var parent=placeholder.parentNode;node.mount(parent,placeholder);this.passPropsThroughPortal()};OutPortal.prototype.componentWillUnmount=function(){var node=this.props.node;node.unmount(this.placeholderNode.current)};OutPortal.prototype.render=function(){return external_kbnSharedDeps_React_["createElement"]("div",{ref:this.placeholderNode})};return OutPortal}(external_kbnSharedDeps_React_["PureComponent"]);const MAP_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.components.embeddables.embeddedMap.embeddablePanelTitle",{defaultMessage:"Monitor Observer Location Map"});var low_poly_layer=__webpack_require__(236);const getLayerList=(upPoints,downPoints,{danger:danger})=>[getLowPolyLayer(),getDownPointsLayer(downPoints,danger),getUpPointsLayer(upPoints)];const getLowPolyLayer=()=>({id:"low_poly_layer",label:"World countries",minZoom:0,maxZoom:24,alpha:1,sourceDescriptor:{id:"b7486535-171b-4d3b-bb2e-33c1a0a2854c",type:"GEOJSON_FILE",__featureCollection:low_poly_layer},visible:true,style:{type:"VECTOR",properties:{fillColor:{type:"STATIC",options:{color:"#cad3e4"}},lineColor:{type:"STATIC",options:{color:"#fff"}},lineWidth:{type:"STATIC",options:{size:0}},iconSize:{type:"STATIC",options:{size:6}}}},type:"VECTOR"});const getDownPointsLayer=(downPoints,dangerColor)=>{const features=downPoints===null||downPoints===void 0?void 0:downPoints.map(point=>({type:"feature",id:point.name,geometry:{type:"Point",coordinates:[+point.location.lon,+point.location.lat]}}));return{id:"down_points",label:"Down Locations",sourceDescriptor:{type:"GEOJSON_FILE",__featureCollection:{features:features,type:"FeatureCollection"}},visible:true,style:{type:"VECTOR",properties:{fillColor:{type:"STATIC",options:{color:dangerColor}},lineColor:{type:"STATIC",options:{color:"#fff"}},lineWidth:{type:"STATIC",options:{size:2}},iconSize:{type:"STATIC",options:{size:6}}}},type:"VECTOR"}};const getUpPointsLayer=upPoints=>{const features=upPoints===null||upPoints===void 0?void 0:upPoints.map(point=>({type:"feature",id:point.name,geometry:{type:"Point",coordinates:[+point.location.lon,+point.location.lat]}}));return{id:"up_points",label:"Up Locations",sourceDescriptor:{type:"GEOJSON_FILE",__featureCollection:{features:features,type:"FeatureCollection"}},visible:true,style:{type:"VECTOR",properties:{fillColor:{type:"STATIC",options:{color:"#98A2B2"}},lineColor:{type:"STATIC",options:{color:"#fff"}},lineWidth:{type:"STATIC",options:{size:2}},iconSize:{type:"STATIC",options:{size:6}}}},type:"VECTOR"}};var maps_public_=__webpack_require__(28);const BadgeItem=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"BadgeItem",componentId:"v6da45-0"})(["white-space:nowrap;display:inline-block;@media (max-width:1042px){display:inline-block;margin-right:16px;}"]);const TagLabel=({color:color,label:label,status:status})=>external_kbnSharedDeps_React_default.a.createElement(BadgeItem,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:status===constants["s"].DOWN?"danger":"secondary"},label));const healthStatusMessageAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.healthStatusMessageAriaLabel",{defaultMessage:"Monitor status"});const typeLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.type.label",{defaultMessage:"Type"});const typeAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.type.ariaLabel",{defaultMessage:"Monitor type"});const monitorUrlLinkAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitorUrlLinkAriaLabel",{defaultMessage:"Monitor URL link"});const durationTextAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.durationTextAriaLabel",{defaultMessage:"Monitor duration in milliseconds"});const timestampFromNowTextAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.timestampFromNowTextAriaLabel",{defaultMessage:"Time since last check"});const loadingMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.loadingMessage",{defaultMessage:"Loading…"});const MonitorIDLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.id",{defaultMessage:"Monitor ID"});const OverallAvailability=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.availability",{defaultMessage:"Overall availability"});const MonitoringFrom=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.monitoringFrom",{defaultMessage:"Monitoring from"});const ChangeToMapView=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.monitoringFrom.listToMap",{defaultMessage:"Change to map view to check availability by location."});const ChangeToListView=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.monitoringFrom.MapToList",{defaultMessage:"Change to list view to check availability by location."});const LocationLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.availabilityReport.location",{defaultMessage:"Location"});const AvailabilityLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.availabilityReport.availability",{defaultMessage:"Availability"});const LastCheckLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorStatusBar.monitor.availabilityReport.lastCheck",{defaultMessage:"Last check"});function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const formatAvailabilityValue=val=>{const result=Math.round(val*100)/100;return result.toFixed(2)};const AvailabilityReporting=({allLocations:allLocations})=>{const[pageIndex,setPageIndex]=Object(external_kbnSharedDeps_React_["useState"])(0);const cols=[{field:"label",name:LocationLabel,truncateText:true,render:(val,item)=>external_kbnSharedDeps_React_default.a.createElement(TagLabel,item)},{field:"availability",name:AvailabilityLabel,align:"right",render:val=>external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.availabilityLabelText",defaultMessage:"{value} %",values:{value:formatAvailabilityValue(val)},description:"A percentage value, like 23.5%"}))},{name:LastCheckLabel,field:"timestamp",align:"right"}];const pageSize=5;const pagination={pageIndex:pageIndex,pageSize:pageSize,totalItemCount:allLocations.length,hidePerPageOptions:true};const onTableChange=({page:page})=>{setPageIndex(page.index)};const paginationProps=allLocations.length>pageSize?{pagination:pagination}:{};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],_extends({responsive:false,compressed:true,columns:cols,items:allLocations.slice(pageIndex*pageSize,pageIndex*pageSize+pageSize),onChange:onTableChange},paginationProps)))};var location_link=__webpack_require__(79);const EuiPopoverRight=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"EuiPopoverRight",componentId:"prkr6c-0"})(["margin-left:auto;margin-bottom:3px;margin-right:5px;"]);const LocationMissingWarning=()=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const togglePopover=()=>{setIsPopoverOpen(!isPopoverOpen)};const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"alert",size:"s",color:"warning",onClick:togglePopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.locationMap.locations.missing.title",defaultMessage:"Geo Information Missing"}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{"data-test-subj":"xpack.uptime.locationMap.locationMissing",gutterSize:"none",responsive:false},external_kbnSharedDeps_React_default.a.createElement(EuiPopoverRight,{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"popover",button:button,isOpen:isPopoverOpen,closePopover:togglePopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{style:{width:"350px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.locationMap.locations.missing.message",defaultMessage:"Important geo location configuration is missing. You can use the {codeBlock} field to create distinctive geographic regions for your uptime checks.",values:{codeBlock:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"observer.geo.??")}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{style:{width:"350px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.locationMap.locations.missing.message1",defaultMessage:"Get more information in our documentation."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(location_link["a"],null)))))};const localKey="xpack.uptime.detailPage.selectedView";const useSelectedView=()=>{var _localStorage$getItem;const getSelectedView=(_localStorage$getItem=localStorage.getItem(localKey))!==null&&_localStorage$getItem!==void 0?_localStorage$getItem:"list";const[selectedView,setSelectedView]=Object(external_kbnSharedDeps_React_["useState"])(getSelectedView);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{localStorage.setItem(localKey,selectedView)},[selectedView]);return{selectedView:selectedView,setSelectedView:setSelectedView}};const ToggleViewButtons=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"ToggleViewButtons",componentId:"sc-17m6v2z-0"})(["margin-left:auto;"]);const ToggleViewBtn=({onChange:onChange})=>{const toggleButtons=[{id:`listBtn`,label:ChangeToMapView,name:"listView",iconType:"list","data-test-subj":"uptimeMonitorToggleListBtn","aria-label":ChangeToMapView},{id:`mapBtn`,label:ChangeToListView,name:"mapView",iconType:"mapMarker","data-test-subj":"uptimeMonitorToggleMapBtn","aria-label":ChangeToListView}];const{selectedView:selectedView,setSelectedView:setSelectedView}=useSelectedView();const onChangeView=optionId=>{const currView=optionId==="listBtn"?"list":"map";setSelectedView(currView);onChange(currView)};return external_kbnSharedDeps_React_["createElement"](ToggleViewButtons,null,external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{options:toggleButtons,idToSelectedMap:{listBtn:selectedView==="list",mapBtn:selectedView==="map"},onChange:id=>onChangeView(id),type:"multi",isIconOnly:true,style:{marginLeft:"auto"},legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.locationAvailabilityViewToggleLegend",{defaultMessage:"View toggle"})}))};const EuiFlexItemTags=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"EuiFlexItemTags",componentId:"zzfwnd-0"})(["width:350px;@media (max-width:1042px){width:100%;}"]);const LocationAvailability=({monitorLocations:monitorLocations})=>{const upPoints=[];const downPoints=[];let isAnyGeoInfoMissing=false;if(monitorLocations!==null&&monitorLocations!==void 0&&monitorLocations.locations){monitorLocations.locations.forEach(({geo:geo,summary:summary})=>{if((geo===null||geo===void 0?void 0:geo.name)===constants["u"]||!(geo!==null&&geo!==void 0&&geo.location)){isAnyGeoInfoMissing=true}else if(!!geo.location.lat&&!!geo.location.lon){if((summary===null||summary===void 0?void 0:summary.down)===0){upPoints.push(geo)}else{downPoints.push(geo)}}})}const{selectedView:initialView}=useSelectedView();const[selectedView,setSelectedView]=Object(external_kbnSharedDeps_React_["useState"])(initialView);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"none",style:{flexGrow:0}},selectedView==="list"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,MonitoringFrom))),selectedView==="map"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,isAnyGeoInfoMissing&&external_kbnSharedDeps_React_default.a.createElement(LocationMissingWarning,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ToggleViewBtn,{onChange:val=>{setSelectedView(val)}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{wrap:true,gutterSize:"none",justifyContent:"flexEnd"},selectedView==="list"&&external_kbnSharedDeps_React_default.a.createElement(EuiFlexItemTags,{grow:true},external_kbnSharedDeps_React_default.a.createElement(LocationStatusTags,{locations:(monitorLocations===null||monitorLocations===void 0?void 0:monitorLocations.locations)||[]})),selectedView==="map"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(LocationMap,{upPoints:upPoints,downPoints:downPoints}))))};var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);const StatusByLocations=({locations:locations})=>{const upLocations=[];const downLocations=[];if(locations)locations.forEach(item=>{if(item.summary.down===0){upLocations.push(item.geo.name)}else{downLocations.push(item.geo.name)}});let statusMessage="";let status="";if(downLocations.length===0){statusMessage=`${locations.length}`;status="Up"}else if(downLocations.length>0){status="Down";statusMessage=`${downLocations.length}/${locations.length}`;if(downLocations.length===locations.length){statusMessage=`${locations.length}`}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,locations.length<=1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorStatusBar.locations.oneLocStatus",values:{status:status,loc:statusMessage},defaultMessage:"{status} in {loc} location"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorStatusBar.locations.upStatus",values:{status:status,loc:statusMessage},defaultMessage:"{status} in {loc} locations"})))};const useStatusBar=()=>{const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{dateRangeStart:dateStart,dateRangeEnd:dateEnd}=Object(hooks["c"])();const dispatch=Object(lib["useDispatch"])();const monitorId=Object(hooks["d"])();const monitorStatus=Object(lib["useSelector"])(selectors["t"]);const monitorLocations=Object(lib["useSelector"])(state=>Object(selectors["s"])(state,monitorId));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(actions["s"])({dateStart:dateStart,dateEnd:dateEnd,monitorId:monitorId}))},[monitorId,dateStart,dateEnd,lastRefresh,dispatch]);return{monitorStatus:monitorStatus,monitorLocations:monitorLocations,monitorId:monitorId}};const RedirectBtn=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"RedirectBtn",componentId:"kqyks9-0"})(["cursor:pointer;"]);const MonitorRedirects=({monitorStatus:monitorStatus})=>{var _monitorStatus$http,_monitorStatus$http$r,_list$length;const list=monitorStatus===null||monitorStatus===void 0?void 0:(_monitorStatus$http=monitorStatus.http)===null||_monitorStatus$http===void 0?void 0:(_monitorStatus$http$r=_monitorStatus$http.response)===null||_monitorStatus$http$r===void 0?void 0:_monitorStatus$http$r.redirects;const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const button=external_kbnSharedDeps_React_default.a.createElement(MonListDescription,null,external_kbnSharedDeps_React_default.a.createElement(RedirectBtn,{className:"euiLink euiLink--primary",onClick:()=>setIsPopoverOpen(!isPopoverOpen),"data-test-subj":"uptimeMonitorRedirectInfo"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.redirects.title.number",{defaultMessage:"{number}",values:{number:(_list$length=list===null||list===void 0?void 0:list.length)!==null&&_list$length!==void 0?_list$length:0}})));return list?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MonListTitle,null,"Redirects"),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:button,isOpen:isPopoverOpen,anchorPosition:"downLeft",closePopover:()=>setIsPopoverOpen(false)},external_kbnSharedDeps_React_default.a.createElement(PingRedirects,{monitorStatus:monitorStatus}))):null};var monitor_tags=__webpack_require__(157);const MonListTitle=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"]).withConfig({displayName:"MonListTitle",componentId:"oausd4-0"})(["&&&{width:30%;max-width:250px;}"]);const MonListDescription=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"]).withConfig({displayName:"MonListDescription",componentId:"oausd4-1"})(["&&&{width:70%;overflow-wrap:anywhere;}"]);const MonitorStatusBar=()=>{var _monitorStatus$url$fu,_monitorStatus$url,_monitorStatus$monito;const{monitorId:monitorId,monitorStatus:monitorStatus,monitorLocations:monitorLocations={}}=useStatusBar();const{locations:locations,up_history:ups,down_history:downs}=monitorLocations;const full=(_monitorStatus$url$fu=monitorStatus===null||monitorStatus===void 0?void 0:(_monitorStatus$url=monitorStatus.url)===null||_monitorStatus$url===void 0?void 0:_monitorStatus$url.full)!==null&&_monitorStatus$url$fu!==void 0?_monitorStatus$url$fu:"";const availability=ups===0&&downs===0||!ups?0:ups/(ups+downs)*100;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(StatusByLocations,{locations:locations!==null&&locations!==void 0?locations:[]})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{type:"column",compressed:true,textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(MonListTitle,null,OverallAvailability),external_kbnSharedDeps_React_default.a.createElement(MonListDescription,{"data-test-subj":"uptimeOverallAvailability"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.availabilityLabelText",defaultMessage:"{value} %",values:{value:formatAvailabilityValue(availability)},description:"A percentage value, like 23.5 %"})),external_kbnSharedDeps_React_default.a.createElement(MonListTitle,null,translations["i"]),external_kbnSharedDeps_React_default.a.createElement(MonListDescription,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"aria-label":monitorUrlLinkAriaLabel,href:full,target:"_blank",external:true},full)),external_kbnSharedDeps_React_default.a.createElement(MonListTitle,null,MonitorIDLabel),external_kbnSharedDeps_React_default.a.createElement(MonListDescription,{"data-test-subj":"monitor-page-title"},monitorId),(monitorStatus===null||monitorStatus===void 0?void 0:(_monitorStatus$monito=monitorStatus.monitor)===null||_monitorStatus$monito===void 0?void 0:_monitorStatus$monito.type)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MonListTitle,{"aria-label":typeAriaLabel},typeLabel),external_kbnSharedDeps_React_default.a.createElement(MonListDescription,{"data-test-subj":"monitor-page-type"},monitorStatus.monitor.type)),external_kbnSharedDeps_React_default.a.createElement(MonListTitle,null,translations["h"]),external_kbnSharedDeps_React_default.a.createElement(MonListDescription,null,external_kbnSharedDeps_React_default.a.createElement(monitor_tags["a"],{ping:monitorStatus})),external_kbnSharedDeps_React_default.a.createElement(MonitorSSLCertificate,{tls:monitorStatus===null||monitorStatus===void 0?void 0:monitorStatus.tls}),external_kbnSharedDeps_React_default.a.createElement(MonitorRedirects,{monitorStatus:monitorStatus})))};var cert_status_column=__webpack_require__(159);const MonitorSSLCertificate=({tls:tls})=>{var _tls$server;let expiry=null;if(tls!==null&&tls!==void 0&&(_tls$server=tls.server)!==null&&_tls$server!==void 0&&_tls$server.x509){expiry=tls.server.x509}else if(tls!==null&&tls!==void 0&&tls.certificate_not_valid_after&&tls!==null&&tls!==void 0&&tls.certificate_not_valid_before){expiry={not_after:tls.certificate_not_valid_after,not_before:tls.certificate_not_valid_before}}if(!expiry){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MonListTitle,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorStatusBar.sslCertificate.title",defaultMessage:"TLS Certificate"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(MonListDescription,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Link"],{to:constants["b"],className:"eui-displayInline"},external_kbnSharedDeps_React_default.a.createElement(cert_status_column["a"],{expiry:expiry,boldStyle:true}))))};const WrapFlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"WrapFlexItem",componentId:"sc-1u6jhtd-0"})(["&&&{@media (max-width:800px){flex-basis:100%;}}"]);const MonitorStatusDetailsComponent=({monitorLocations:monitorLocations})=>{const{refreshApp:refreshApp}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const[isTabActive]=Object(external_kbnSharedDeps_React_["useState"])(document.visibilityState);const onTabActive=()=>{if(document.visibilityState==="visible"&&isTabActive==="hidden"){refreshApp()}};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{document.addEventListener("visibilitychange",onTabActive);return()=>{document.removeEventListener("visibilitychange",onTabActive)}},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"l",wrap:true,responsive:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(MonitorStatusBar,null)),external_kbnSharedDeps_React_default.a.createElement(WrapFlexItem,{grow:1},external_kbnSharedDeps_React_default.a.createElement(LocationAvailability,{monitorLocations:monitorLocations}))))};var monitor=__webpack_require__(80);const MonitorStatusDetails=({monitorId:monitorId})=>{const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{dateRangeStart:dateStart,dateRangeEnd:dateEnd}=Object(hooks["c"])();const dispatch=Object(lib["useDispatch"])();const monitorLocations=Object(lib["useSelector"])(state=>Object(selectors["s"])(state,monitorId));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(monitor["b"])({dateStart:dateStart,dateEnd:dateEnd,monitorId:monitorId}))},[monitorId,dateStart,dateEnd,lastRefresh,dispatch]);return external_kbnSharedDeps_React_default.a.createElement(MonitorStatusDetailsComponent,{monitorLocations:monitorLocations})};const TagContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"TagContainer",componentId:"sc-1hl17ax-0"})(["max-height:246px;overflow:hidden;"]);const LocationStatusTags=({locations:locations})=>{var _moment$locale;const{colors:{gray:gray,danger:danger}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const allLocations=[];const prevLocal=(_moment$locale=external_kbnSharedDeps_Moment_default.a.locale())!==null&&_moment$locale!==void 0?_moment$locale:"en";const shortLocale=external_kbnSharedDeps_Moment_default.a.locale(constants["r"])===constants["r"];if(!shortLocale){external_kbnSharedDeps_Moment_default.a.defineLocale(constants["r"],constants["q"])}locations.forEach(item=>{allLocations.push({label:item.geo.name,timestamp:Object(monitor_status_column["c"])(external_kbnSharedDeps_Moment_default()(new Date(item.timestamp).valueOf())),color:item.summary.down===0?gray:danger,availability:item.up_history/(item.up_history+item.down_history)*100,status:item.summary.down===0?"up":"down"})});external_kbnSharedDeps_Moment_default.a.locale(prevLocal);allLocations.sort((a,b)=>a.label>b.label?1:b.label>a.label?-1:0);if(allLocations.length===0){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(TagContainer,null,external_kbnSharedDeps_React_default.a.createElement(AvailabilityReporting,{allLocations:allLocations})))};const MapToolTipComponent=({closeTooltip:closeTooltip,features:features=[]})=>{var _features$;const{id:featureId,layerId:layerId}=(_features$=features[0])!==null&&_features$!==void 0?_features$:{};const locationName=featureId===null||featureId===void 0?void 0:featureId.toString();const{colors:{gray:gray,danger:danger}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const monitorId=Object(hooks["d"])();const monitorLocations=Object(lib["useSelector"])(state=>Object(selectors["s"])(state,monitorId));if(!locationName||!(monitorLocations!==null&&monitorLocations!==void 0&&monitorLocations.locations)){return null}const{timestamp:timestamp,up_history:ups,down_history:downs}=monitorLocations.locations.find(({geo:geo})=>geo.name===locationName);const availability=ups/(ups+downs)*100;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiOutsideClickDetector"],{onOutsideClick:()=>{if(closeTooltip!=null){closeTooltip()}}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,layerId==="up_points"?external_kbnSharedDeps_React_default.a.createElement(TagLabel,{label:locationName,color:gray,status:"up"}):external_kbnSharedDeps_React_default.a.createElement(TagLabel,{label:locationName,color:danger,status:"down"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{type:"column",textStyle:"reverse",compressed:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,"Availability"),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.mapToolTip.AvailabilityStat.title",{defaultMessage:"{value} %",values:{value:formatAvailabilityValue(availability)},description:"A percentage value like 23.5%"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,LastCheckLabel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_Moment_default()(timestamp).fromNow()))))};const MapToolTip=external_kbnSharedDeps_React_default.a.memo(MapToolTipComponent);var embeddable_public_=__webpack_require__(29);function embedded_map_extends(){embedded_map_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return embedded_map_extends.apply(this,arguments)}const EmbeddedPanel=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"EmbeddedPanel",componentId:"sc-16l7ehq-0"})(["z-index:auto;flex:1;display:flex;flex-direction:column;height:100%;position:relative;.embPanel__content{display:flex;flex:1 1 100%;z-index:1;min-height:0;}&&& .mapboxgl-canvas{animation:none !important;}"]);const EmbeddedMap=external_kbnSharedDeps_React_default.a.memo(({upPoints:upPoints,downPoints:downPoints})=>{const{colors:colors}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const[embeddable,setEmbeddable]=Object(external_kbnSharedDeps_React_["useState"])();const embeddableRoot=Object(external_kbnSharedDeps_React_["useRef"])(null);const{embeddable:embeddablePlugin}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["e"]);if(!embeddablePlugin){throw new Error("Embeddable start plugin not found")}const factory=embeddablePlugin.getEmbeddableFactory(maps_public_["MAP_SAVED_OBJECT_TYPE"]);const portalNode=external_kbnSharedDeps_React_default.a.useMemo(()=>createPortalNode(),[]);const input={id:uuid_default.a.v4(),attributes:{title:""},filters:[],hidePanelTitles:true,refreshConfig:{value:0,pause:false},viewMode:embeddable_public_["ViewMode"].VIEW,isLayerTOCOpen:false,hideFilterActions:true,mapCenter:{lon:11,lat:20,zoom:0},mapSettings:{disableInteractive:true,hideToolbarOverlay:true,hideLayerControl:true,hideViewControl:true}};const renderTooltipContent=({addFilters:addFilters,closeTooltip:closeTooltip,features:features,isLocked:isLocked,getLayerName:getLayerName,loadFeatureProperties:loadFeatureProperties,loadFeatureGeometry:loadFeatureGeometry})=>{const props={addFilters:addFilters,closeTooltip:closeTooltip,isLocked:isLocked,getLayerName:getLayerName,loadFeatureProperties:loadFeatureProperties,loadFeatureGeometry:loadFeatureGeometry};const relevantFeatures=features.filter(item=>item.layerId==="up_points"||item.layerId==="down_points");if(relevantFeatures.length>0){return external_kbnSharedDeps_React_default.a.createElement(web_OutPortal,embedded_map_extends({},props,{node:portalNode,features:relevantFeatures}))}closeTooltip();return null};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{async function setupEmbeddable(){if(!factory){throw new Error("Map embeddable not found.")}const embeddableObject=await factory.create({...input,title:MAP_TITLE});if(embeddableObject&&!Object(embeddable_public_["isErrorEmbeddable"])(embeddableObject)){embeddableObject.setRenderTooltipContent(renderTooltipContent);embeddableObject.setLayerList(getLayerList(upPoints,downPoints,colors))}setEmbeddable(embeddableObject)}setupEmbeddable()},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(embeddable&&!Object(embeddable_public_["isErrorEmbeddable"])(embeddable)){embeddable.setLayerList(getLayerList(upPoints,downPoints,colors))}},[upPoints,downPoints,embeddable,colors]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(embeddableRoot.current&&embeddable){embeddable.render(embeddableRoot.current)}},[embeddable,embeddableRoot]);return external_kbnSharedDeps_React_default.a.createElement(EmbeddedPanel,null,external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"xpack.uptime.locationMap.embeddedPanel",className:"embPanel__content",ref:embeddableRoot}),external_kbnSharedDeps_React_default.a.createElement(web_InPortal,{node:portalNode},external_kbnSharedDeps_React_default.a.createElement(MapToolTipComponent,null)))});EmbeddedMap.displayName="EmbeddedMap";const MapPanel=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"MapPanel",componentId:"bfsrle-0"})(["height:240px;width:520px;margin-right:65px;@media (max-width:574px){height:250px;width:100%;}"]);const LocationMap=({upPoints:upPoints,downPoints:downPoints})=>external_kbnSharedDeps_React_default.a.createElement(MapPanel,null,external_kbnSharedDeps_React_default.a.createElement(EmbeddedMap,{upPoints:upPoints,downPoints:downPoints}));var charts=__webpack_require__(84);const ResponsiveWrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"ResponsiveWrapper",componentId:"sc-1cjalib-0"})(["margin-left:120px;@media (max-width:950px){margin-left:48px;}@media (max-width:767px){margin-left:12px;margin-top:40px;}"]);const withResponsiveWrapper=Component=>({isResponsive:isResponsive,...rest})=>isResponsive?external_kbnSharedDeps_React_default.a.createElement(ResponsiveWrapper,null,external_kbnSharedDeps_React_default.a.createElement(Component,rest)):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"m"},external_kbnSharedDeps_React_default.a.createElement(Component,rest));const Container=({height:height})=>{const{absoluteDateRangeStart:absoluteDateRangeStart,absoluteDateRangeEnd:absoluteDateRangeEnd,dateRangeStart:dateStart,dateRangeEnd:dateEnd}=Object(hooks["c"])();const dispatch=Object(lib["useDispatch"])();const monitorId=Object(hooks["d"])();const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const esKuery=Object(lib["useSelector"])(selectors["d"]);const{loading:loading,pingHistogram:data}=Object(lib["useSelector"])(selectors["D"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(actions["v"])({monitorId:monitorId,dateStart:dateStart,dateEnd:dateEnd,filters:esKuery}))},[dateStart,dateEnd,monitorId,lastRefresh,esKuery,dispatch]);return external_kbnSharedDeps_React_default.a.createElement(charts["d"],{data:data,absoluteStartDate:absoluteDateRangeStart,absoluteEndDate:absoluteDateRangeEnd,height:height,loading:loading})};const PingHistogram=withResponsiveWrapper(Container);const ShowLicenseInfo=()=>{const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(actions["l"].get())},[dispatch]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{"data-test-subj":"uptimeMLLicenseInfo",className:"license-info-trial",title:START_TRAIL,color:"primary",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement("p",null,START_TRAIL_DESC),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",href:basePath+`/app/management/stack/license_management/home`},START_TRAIL)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null))};function MLFlyoutView({isCreatingJob:isCreatingJob,onClickCreate:onClickCreate,onClose:onClose,canCreateMLJob:canCreateMLJob}){const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const hasMlFeature=Object(lib["useSelector"])(selectors["e"]);const isLoadingMLJob=false;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"s","data-test-subj":"uptimeMLFlyout"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,ENABLE_ANOMALY_DETECTION)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,!hasMlFeature&&external_kbnSharedDeps_React_default.a.createElement(ShowLicenseInfo,null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,CREAT_ML_JOB_DESC),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.ml.enableAnomalyDetectionPanel.manageMLJobDescription",defaultMessage:"Once a job is created, you can manage it and see more details in the {mlJobsPageLink}.",values:{mlJobsPageLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:basePath+"/app/ml"},ML_MANAGEMENT_PAGE)}})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("em",null,TAKE_SOME_TIME_TEXT))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>onClose(),disabled:isCreatingJob||isLoadingMLJob},CANCEL_LABEL)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"uptimeMLCreateJobBtn",onClick:()=>onClickCreate(),fill:true,isLoading:isCreatingJob,disabled:isCreatingJob||isLoadingMLJob||!hasMlFeature||!canCreateMLJob},CREATE_NEW_JOB)))))}var dynamic_settings=__webpack_require__(55);var kibana_service=__webpack_require__(51);const showMLJobNotification=(monitorId,basePath,range,success,error)=>{if(success){kibana_service["a"].toasts.addSuccess({title:Object(public_["toMountPoint"])(external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"uptimeMLJobSuccessfullyCreated"},JOB_CREATED_SUCCESS_TITLE)),text:Object(public_["toMountPoint"])(external_kbnSharedDeps_React_default.a.createElement("p",null,JOB_CREATED_SUCCESS_MESSAGE,external_kbnSharedDeps_React_default.a.createElement(MLJobLink,{monitorId:monitorId,basePath:basePath,dateRange:range},VIEW_JOB)))},{toastLifeTimeMs:1e4})}else{kibana_service["a"].toasts.addError(error,{title:JOB_CREATION_FAILED,toastMessage:JOB_CREATION_FAILED_MESSAGE,toastLifeTimeMs:1e4})}};const MachineLearningFlyout=({onClose:onClose})=>{const dispatch=Object(lib["useDispatch"])();const{data:hasMLJob,error:error}=Object(lib["useSelector"])(selectors["g"]);const isMLJobCreating=Object(lib["useSelector"])(selectors["j"]);const{settings:settings}=Object(lib["useSelector"])(selectors["A"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(dynamic_settings["a"])({}))},[dispatch]);const heartbeatIndices=(settings===null||settings===void 0?void 0:settings.heartbeatIndices)||"";const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const{refreshApp:refreshApp}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const monitorId=Object(hooks["d"])();const canCreateMLJob=Object(lib["useSelector"])(selectors["b"])&&heartbeatIndices!=="";const createMLJob=heartbeatIndices?()=>dispatch(actions["b"].get({monitorId:monitorId,heartbeatIndices:heartbeatIndices})):()=>null;const{data:uptimeJobs}=Object(lib["useSelector"])(selectors["f"]);const hasExistingMLJob=!!(uptimeJobs!==null&&uptimeJobs!==void 0&&uptimeJobs.jobsExist);const[isCreatingJob,setIsCreatingJob]=Object(external_kbnSharedDeps_React_["useState"])(false);const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd}=Object(hooks["c"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isCreatingJob&&!isMLJobCreating){if(hasMLJob){showMLJobNotification(monitorId,basePath,{to:dateRangeEnd,from:dateRangeStart},true);const loadMLJob=jobId=>dispatch(actions["h"].get({monitorId:monitorId}));loadMLJob(constants["k"]);refreshApp();dispatch(Object(actions["G"])(alerts["b"].DURATION_ANOMALY));dispatch(Object(actions["H"])(true))}else{showMLJobNotification(monitorId,basePath,{to:dateRangeEnd,from:dateRangeStart},false,error)}setIsCreatingJob(false);onClose()}},[hasMLJob,onClose,isCreatingJob,error,isMLJobCreating,monitorId,dispatch,basePath]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasExistingMLJob&&!isMLJobCreating&&!hasMLJob&&heartbeatIndices){setIsCreatingJob(true);dispatch(actions["b"].get({monitorId:monitorId,heartbeatIndices:heartbeatIndices}))}},[dispatch,hasExistingMLJob,heartbeatIndices,monitorId,hasMLJob]);if(hasExistingMLJob){return null}const createAnomalyJob=()=>{setIsCreatingJob(true);createMLJob()};return external_kbnSharedDeps_React_default.a.createElement(MLFlyoutView,{canCreateMLJob:!!canCreateMLJob,isCreatingJob:isMLJobCreating,onClickCreate:createAnomalyJob,onClose:onClose})};const ConfirmJobDeletion=({loading:loading,onConfirm:onConfirm,onCancel:onCancel})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:JOB_DELETION_CONFIRMATION,onCancel:onCancel,onConfirm:onConfirm,cancelButtonText:"Cancel",confirmButtonText:"Delete",buttonColor:"danger",defaultFocusedButton:"confirm","data-test-subj":"uptimeMLJobDeleteConfirmModel"},!loading?external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorDetails.ml.confirmDeleteMessage",defaultMessage:"Are you sure you want to delete this job?"})):external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorDetails.ml.deleteMessage",defaultMessage:"Deleting jobs..."}),")"),!loading?external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorDetails.ml.deleteJobWarning",defaultMessage:"Deleting a job can be time consuming. It will be deleted in the background and data may not disappear instantly."})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"}));const MLIntegrationComponent=()=>{const[isMlFlyoutOpen,setIsMlFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isConfirmDeleteJobOpen,setIsConfirmDeleteJobOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const{lastRefresh:lastRefresh,refreshApp:refreshApp}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{notifications:notifications}=Object(public_["useKibana"])();const monitorId=Object(hooks["d"])();const dispatch=Object(lib["useDispatch"])();const isMLAvailable=Object(lib["useSelector"])(selectors["e"]);const deleteMLJob=()=>dispatch(actions["c"].get({monitorId:monitorId}));const isMLJobDeleting=Object(lib["useSelector"])(selectors["l"]);const{data:jobDeletionSuccess}=Object(lib["useSelector"])(selectors["k"]);const{data:uptimeJobs}=Object(lib["useSelector"])(selectors["f"]);const hasMLJob=!!(uptimeJobs!==null&&uptimeJobs!==void 0&&uptimeJobs.jobsExist)&&!!uptimeJobs.jobs.find(job=>job.id===Object(common_lib["b"])(monitorId));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isMLAvailable){dispatch(actions["h"].get({monitorId:monitorId}))}},[dispatch,isMLAvailable,monitorId,lastRefresh]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{var _jobDeletionSuccess$g;if(isConfirmDeleteJobOpen&&jobDeletionSuccess!==null&&jobDeletionSuccess!==void 0&&(_jobDeletionSuccess$g=jobDeletionSuccess[Object(common_lib["b"])(monitorId)])!==null&&_jobDeletionSuccess$g!==void 0&&_jobDeletionSuccess$g.deleted){setIsConfirmDeleteJobOpen(false);notifications.toasts.success({title:external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"uptimeMLJobSuccessfullyDeleted"},JOB_DELETION),body:external_kbnSharedDeps_React_default.a.createElement("p",null,JOB_DELETION_SUCCESS),toastLifeTimeMs:3e3});dispatch(Object(actions["F"])());refreshApp()}return()=>{dispatch(Object(actions["F"])())}},[isMLJobDeleting,isConfirmDeleteJobOpen,jobDeletionSuccess,monitorId,refreshApp,notifications.toasts,dispatch]);const onEnableJobClick=()=>{setIsMlFlyoutOpen(true)};const closeFlyout=()=>{setIsMlFlyoutOpen(false)};const confirmDeleteMLJob=()=>{setIsConfirmDeleteJobOpen(true)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ManageMLJobComponent,{hasMLJob:hasMLJob,onEnableJob:onEnableJobClick,onJobDelete:confirmDeleteMLJob}),isMlFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(MachineLearningFlyout,{onClose:closeFlyout}),isConfirmDeleteJobOpen&&external_kbnSharedDeps_React_default.a.createElement(ConfirmJobDeletion,{onConfirm:deleteMLJob,loading:isMLJobDeleting,onCancel:()=>{setIsConfirmDeleteJobOpen(false)}}))};const MonitorDurationComponent=({locationDurationLines:locationDurationLines,anomalies:anomalies,loading:loading,hasMLJob:hasMLJob})=>{var _anomalies$anomalies$,_anomalies$anomalies;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"none",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,hasMLJob?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorCharts.monitorDuration.titleLabelWithAnomaly",defaultMessage:"Monitor duration (Anomalies: {noOfAnomalies})",values:{noOfAnomalies:(_anomalies$anomalies$=anomalies===null||anomalies===void 0?void 0:(_anomalies$anomalies=anomalies.anomalies)===null||_anomalies$anomalies===void 0?void 0:_anomalies$anomalies.length)!==null&&_anomalies$anomalies$!==void 0?_anomalies$anomalies$:0}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorCharts.monitorDuration.titleLabel",defaultMessage:"Monitor duration"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(MLIntegrationComponent,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(charts["b"],{locationDurationLines:locationDurationLines,loading:loading,anomalies:anomalies}))};const MonitorDuration=({monitorId:monitorId})=>{var _durationLines$locati;const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,absoluteDateRangeStart:absoluteDateRangeStart,absoluteDateRangeEnd:absoluteDateRangeEnd}=Object(hooks["c"])();const{durationLines:durationLines,loading:loading}=Object(lib["useSelector"])(selectors["z"]);const isMLAvailable=Object(lib["useSelector"])(selectors["e"]);const{data:mlJobs,loading:jobsLoading}=Object(lib["useSelector"])(selectors["f"]);const hasMLJob=!!(mlJobs!==null&&mlJobs!==void 0&&mlJobs.jobsExist)&&!!mlJobs.jobs.find(job=>job.id===Object(common_lib["b"])(monitorId));const anomalies=Object(lib["useSelector"])(selectors["a"]);const dispatch=Object(lib["useDispatch"])();const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isMLAvailable){const anomalyParams={listOfMonitorIds:[monitorId],dateStart:absoluteDateRangeStart,dateEnd:absoluteDateRangeEnd};dispatch(actions["g"].get(anomalyParams))}},[dateRangeStart,dateRangeEnd,dispatch,lastRefresh,monitorId,isMLAvailable]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const params={monitorId:monitorId,dateStart:dateRangeStart,dateEnd:dateRangeEnd};dispatch(Object(actions["m"])(params))},[dateRangeStart,dateRangeEnd,dispatch,lastRefresh,monitorId]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(actions["l"].get())},[dispatch]);return external_kbnSharedDeps_React_default.a.createElement(MonitorDurationComponent,{anomalies:anomalies,hasMLJob:hasMLJob,loading:loading||jobsLoading,locationDurationLines:(_durationLines$locati=durationLines===null||durationLines===void 0?void 0:durationLines.locationDurationLines)!==null&&_durationLines$locati!==void 0?_durationLines$locati:[]})};const MONITOR_CHART_HEIGHT="248px";const MonitorCharts=({monitorId:monitorId})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(MonitorDuration,{monitorId:monitorId})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(PingHistogram,{height:MONITOR_CHART_HEIGHT,isResponsive:false})))},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DonutChart}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DurationChartComponent}));__webpack_require__.d(__webpack_exports__,"c",(function(){return MonitorBarSeries}));__webpack_require__.d(__webpack_exports__,"d",(function(){return PingHistogramComponent}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(17);const EuiFlexItemReducedMargin=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"EuiFlexItemReducedMargin",componentId:"dnsxwu-0"})(["&&{margin-left:0px;margin-right:0px;}"]);const EuiFlexItemAlignRight=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"EuiFlexItemAlignRight",componentId:"dnsxwu-1"})(["text-align:right;"]);const DonutChartLegendRow=({color:color,content:content,message:message,"data-test-subj":dts})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"l",responsive:false},external_kbnSharedDeps_React_default.a.createElement(EuiFlexItemReducedMargin,{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:color})),external_kbnSharedDeps_React_default.a.createElement(EuiFlexItemReducedMargin,{component:"span",grow:false,"data-test-subj":`${dts}.label`},message),external_kbnSharedDeps_React_default.a.createElement(EuiFlexItemAlignRight,{component:"span","data-test-subj":dts},content));var contexts=__webpack_require__(36);var translations=__webpack_require__(50);const LegendContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"LegendContainer",componentId:"sc-1p5q8f7-0"})(["max-width:150px;min-width:100px;@media (max-width:767px){min-width:0px;max-width:100px;}"]);const DonutChartLegend=({down:down,up:up})=>{const{colors:{gray:gray,danger:danger}}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);return external_kbnSharedDeps_React_default.a.createElement(LegendContainer,null,external_kbnSharedDeps_React_default.a.createElement(DonutChartLegendRow,{color:danger,content:down,message:translations["e"],"data-test-subj":"xpack.uptime.snapshot.donutChart.down"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(DonutChartLegendRow,{color:gray,content:up,message:translations["g"],"data-test-subj":"xpack.uptime.snapshot.donutChart.up"}))};function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const GreenCheckIcon=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiIcon"]).withConfig({displayName:"GreenCheckIcon",componentId:"dqu6a2-0"})(["height:42px;width:42px;color:#017d73;top:51px;left:51px;position:absolute;"]);const DonutChart=({height:height,down:down,up:up})=>{const{colors:{danger:danger,gray:gray},chartTheme:chartTheme}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{position:"relative"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],_extends({size:height,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshot.donutChart.ariaLabel",{defaultMessage:"Pie chart showing the current status. {down} of {total} monitors are down.",values:{down:down,total:up+down}})},chartTheme),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Partition"],{id:"spec_1",data:[{value:down,label:"Down"},{value:up,label:"Up"}],valueAccessor:d=>d.value,layers:[{groupByRollup:d=>d.label,nodeLabel:d=>d,shape:{fillColor:d=>d.dataName==="Down"?danger:gray}}],config:{partitionLayout:external_kbnSharedDeps_ElasticCharts_["PartitionLayout"].sunburst,linkLabel:{maximumSection:Infinity},margin:{top:0,bottom:0,left:0,right:0},idealFontSizeJump:1.1,outerSizeRatio:.9,emptySizeRatio:.4,circlePadding:4}})),down===0&&external_kbnSharedDeps_React_default.a.createElement(GreenCheckIcon,{className:"greenCheckIcon",type:"checkInCircleFilled"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(DonutChartLegend,{down:down,up:up})))};var external_kbnSharedDeps_Moment_=__webpack_require__(13);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);var lib=__webpack_require__(32);var helper=__webpack_require__(60);const ONE_SECOND_AS_MICROS=1e6;const ONE_SECOND_AS_MILLI=1e3;const ONE_MILLI_AS_MICRO=1e3;function milliToSec(ms){return ms/ONE_SECOND_AS_MILLI}function microToSec(micro){return(micro/ONE_SECOND_AS_MICROS).toFixed(0)}function microToMilli(micro){return(micro/ONE_MILLI_AS_MICRO).toFixed(0)}const DurationLineSeriesList=({monitorType:monitorType,lines:lines})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,lines.map(({name:name,line:line})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["LineSeries"],{curve:external_kbnSharedDeps_ElasticCharts_["CurveType"].CURVE_MONOTONE_X,data:line.map(({x:x,y:y})=>[x,y||null]),id:`loc-avg-${name}`,key:`loc-line-${name}`,name:name,xAccessor:0,xScaleType:"time",yAccessors:[1],yScaleToDataExtent:false,yScaleType:"linear",fit:external_kbnSharedDeps_ElasticCharts_["Fit"].Linear,tickFormat:d=>monitorType==="browser"?`${microToSec(d)} ${translations["c"]}`:`${microToMilli(d)} ${translations["a"]}`})));var chart_wrapper=__webpack_require__(120);var hooks=__webpack_require__(35);const getTickFormat=value=>{const parsedNumber=Number(value);if(isNaN(parsedNumber)||value===null){return"N/A"}return parsedNumber.toFixed()};const ChartEmptyState=({title:title,body:body})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h5",null,title)),body:external_kbnSharedDeps_React_default.a.createElement("p",null,body)});const Header=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Header",componentId:"n37rcn-0"})(["font-weight:bold;padding-left:4px;"]);const RecordSeverity=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"RecordSeverity",componentId:"n37rcn-1"})(["font-weight:bold;border-left:4px solid ",";padding-left:2px;"],props=>props.color);const TimeDiv=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"TimeDiv",componentId:"n37rcn-2"})(["font-weight:500;border-bottom:1px solid gray;padding-bottom:2px;"]);const AnnotationTooltip=({details:details})=>{const data=JSON.parse(details);function capitalizeFirstLetter(str){return str.charAt(0).toUpperCase()+str.slice(1)}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(TimeDiv,null,external_kbnSharedDeps_Moment_default()(data.time).format("lll")),external_kbnSharedDeps_React_default.a.createElement(Header,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.charts.mlAnnotation.header",defaultMessage:"Score: {score}",values:{score:data.score.toFixed(2)}})),external_kbnSharedDeps_React_default.a.createElement(RecordSeverity,{color:data.color},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.charts.mlAnnotation.severity",defaultMessage:"Severity: {severity}",values:{severity:capitalizeFirstLetter(data.severity)}})))};var public_=__webpack_require__(21);const DurationAnomaliesBar=({anomalies:anomalies,hiddenLegends:hiddenLegends})=>{const anomalyAnnotations=new Map;Object.keys(public_["ANOMALY_SEVERITY"]).forEach(severityLevel=>{anomalyAnnotations.set(severityLevel.toLowerCase(),{rect:[],color:""})});if(anomalies!==null&&anomalies!==void 0&&anomalies.anomalies){const records=anomalies.anomalies;records.forEach(record=>{var _record$source$observ,_record$source$observ2;let recordObsvLoc=(_record$source$observ=(_record$source$observ2=record.source["observer.geo.name"])===null||_record$source$observ2===void 0?void 0:_record$source$observ2[0])!==null&&_record$source$observ!==void 0?_record$source$observ:"N/A";if(recordObsvLoc===""){recordObsvLoc="N/A"}if(hiddenLegends.length&&hiddenLegends.includes(`loc-avg-${recordObsvLoc}`)){return}const severityLevel=Object(public_["getSeverityType"])(record.severity);const tooltipData={time:record.source.timestamp,score:record.severity,severity:severityLevel,color:Object(public_["getSeverityColor"])(record.severity)};const anomalyRect={coordinates:{x0:external_kbnSharedDeps_Moment_default()(record.source.timestamp).valueOf(),x1:external_kbnSharedDeps_Moment_default()(record.source.timestamp).add(record.source.bucket_span,"s").valueOf()},details:JSON.stringify(tooltipData)};anomalyAnnotations.get(severityLevel).rect.push(anomalyRect);anomalyAnnotations.get(severityLevel).color=Object(public_["getSeverityColor"])(record.severity)})}const getRectStyle=color=>({fill:color,opacity:1,strokeWidth:2,stroke:color});const tooltipFormatter=details=>external_kbnSharedDeps_React_default.a.createElement(AnnotationTooltip,{details:details||""});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,Array.from(anomalyAnnotations).map(([keyIndex,rectAnnotation])=>rectAnnotation.rect.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{dataValues:rectAnnotation.rect,key:keyIndex,id:keyIndex,style:getRectStyle(rectAnnotation.color),renderTooltip:tooltipFormatter}):null))};var components_monitor=__webpack_require__(82);var selectors=__webpack_require__(37);function duration_chart_extends(){duration_chart_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return duration_chart_extends.apply(this,arguments)}const DurationChartComponent=({locationDurationLines:locationDurationLines,anomalies:anomalies,loading:loading})=>{const hasLines=locationDurationLines.length>0;const[getUrlParams,updateUrlParams]=Object(hooks["h"])();const{absoluteDateRangeStart:min,absoluteDateRangeEnd:max}=getUrlParams();const[hiddenLegends,setHiddenLegends]=Object(external_kbnSharedDeps_React_["useState"])([]);const{chartTheme:chartTheme}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const onBrushEnd=({x:x})=>{if(!x){return}const[minX,maxX]=x;updateUrlParams({dateRangeStart:external_kbnSharedDeps_Moment_default()(minX).toISOString(),dateRangeEnd:external_kbnSharedDeps_Moment_default()(maxX).toISOString()})};const legendToggleVisibility=([legendItem])=>{if(legendItem){setHiddenLegends(prevState=>{if(prevState.includes(legendItem.specId)){return[...prevState.filter(item=>item!==legendItem.specId)]}else{return[...prevState,legendItem.specId]}})}};const monitor=Object(lib["useSelector"])(selectors["t"]);return external_kbnSharedDeps_React_default.a.createElement(chart_wrapper["a"],{height:components_monitor["a"],loading:loading},hasLines?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],duration_chart_extends({xDomain:{min:min,max:max},showLegend:true,showLegendExtra:true,legendPosition:external_kbnSharedDeps_ElasticCharts_["Position"].Right,onBrushEnd:onBrushEnd,onLegendItemClick:legendToggleVisibility},chartTheme)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"bottom",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:Object(external_kbnSharedDeps_ElasticCharts_["timeFormatter"])(Object(helper["c"])(min,max))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{domain:{min:0},id:"left",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:d=>getTickFormat(d),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorCharts.durationChart.leftAxis.title",{defaultMessage:"Duration in {unit}",values:{unit:(monitor===null||monitor===void 0?void 0:monitor.monitor.type)==="browser"?translations["b"]:translations["a"]}}),labelFormat:d=>(monitor===null||monitor===void 0?void 0:monitor.monitor.type)==="browser"?`${microToSec(d)}`:`${microToMilli(d)}`}),external_kbnSharedDeps_React_default.a.createElement(DurationLineSeriesList,{lines:locationDurationLines,monitorType:monitor===null||monitor===void 0?void 0:monitor.monitor.type}),external_kbnSharedDeps_React_default.a.createElement(DurationAnomaliesBar,{anomalies:anomalies,hiddenLegends:hiddenLegends})):external_kbnSharedDeps_React_default.a.createElement(ChartEmptyState,{body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.durationChart.emptyPrompt.description",defaultMessage:"This monitor has never been {emphasizedText} during the selected time range.",values:{emphasizedText:external_kbnSharedDeps_React_default.a.createElement("strong",null,"up")}}),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.durationChart.emptyPrompt.title",{defaultMessage:"No duration data available"})}))};const getDateRangeFromChartElement=(elementData,minInterval)=>{const startRange=elementData[0].x;return{dateRangeStart:external_kbnSharedDeps_Moment_default()(startRange).toISOString(),dateRangeEnd:external_kbnSharedDeps_Moment_default()(startRange).add(minInterval,"ms").toISOString()}};function monitor_bar_series_extends(){monitor_bar_series_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return monitor_bar_series_extends.apply(this,arguments)}const MonitorBarSeries=({histogramSeries:histogramSeries,minInterval:minInterval})=>{const{colors:{danger:danger},chartTheme:chartTheme}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const[getUrlParams,updateUrlParams]=Object(hooks["h"])();const{absoluteDateRangeStart:absoluteDateRangeStart,absoluteDateRangeEnd:absoluteDateRangeEnd}=getUrlParams();const onBrushEnd=({x:x})=>{if(!x){return}const[min,max]=x;updateUrlParams({dateRangeStart:external_kbnSharedDeps_Moment_default()(min).toISOString(),dateRangeEnd:external_kbnSharedDeps_Moment_default()(max).toISOString()})};const onBarClicked=([elementData])=>{updateUrlParams(getDateRangeFromChartElement(elementData,minInterval))};const id="downSeries";return Object(helper["k"])(histogramSeries)?external_kbnSharedDeps_React_default.a.createElement("div",{style:{height:50,width:"100%",maxWidth:"1200px",marginRight:15}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],monitor_bar_series_extends({xDomain:{minInterval:minInterval,min:absoluteDateRangeStart,max:absoluteDateRangeEnd},onBrushEnd:onBrushEnd,onElementClick:onBarClicked},chartTheme)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{hide:true,id:"bottom",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,tickFormat:Object(external_kbnSharedDeps_ElasticCharts_["timeFormatter"])(Object(helper["c"])(absoluteDateRangeStart,absoluteDateRangeEnd))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{id:id,color:danger,data:(histogramSeries||[]).map(({timestamp:timestamp,down:down})=>[timestamp,down]),name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.downLineSeries.downLabel",{defaultMessage:"Down checks"}),timeZone:"local",xAccessor:0,xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Time,yAccessors:[1],yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorList.noDownHistory",defaultMessage:"This monitor has never been {emphasizedText} during the selected time range.",values:{emphasizedText:external_kbnSharedDeps_React_default.a.createElement("strong",null,"down")}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"secondary"},"--"))};var external_kbnSharedDeps_ElasticNumeral_=__webpack_require__(30);var external_kbnSharedDeps_ElasticNumeral_default=__webpack_require__.n(external_kbnSharedDeps_ElasticNumeral_);function ping_histogram_extends(){ping_histogram_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return ping_histogram_extends.apply(this,arguments)}const PingHistogramComponent=({absoluteStartDate:absoluteStartDate,absoluteEndDate:absoluteEndDate,data:data,loading:loading=false,height:height})=>{var _data$histogram;const{colors:{danger:danger,gray:gray},chartTheme:chartTheme}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["g"]);const[,updateUrlParams]=Object(hooks["h"])();let content;if(!(data!==null&&data!==void 0&&(_data$histogram=data.histogram)!==null&&_data$histogram!==void 0&&_data$histogram.length)){content=external_kbnSharedDeps_React_default.a.createElement(ChartEmptyState,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshot.noDataTitle",{defaultMessage:"No ping data available"}),body:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshot.noDataDescription",{defaultMessage:"There are no pings in the selected time range."})})}else{const{histogram:histogram,minInterval:minInterval}=data;const onBrushEnd=({x:x})=>{if(!x){return}const[min,max]=x;updateUrlParams({dateRangeStart:external_kbnSharedDeps_Moment_default()(min).toISOString(),dateRangeEnd:external_kbnSharedDeps_Moment_default()(max).toISOString()})};const onBarClicked=([elementData])=>{updateUrlParams(getDateRangeFromChartElement(elementData,minInterval))};const barData=[];histogram.forEach(({x:x,upCount:upCount,downCount:downCount})=>{barData.push({x:x,y:downCount!==null&&downCount!==void 0?downCount:0,type:translations["e"]},{x:x,y:upCount!==null&&upCount!==void 0?upCount:0,type:translations["g"]})});content=external_kbnSharedDeps_React_default.a.createElement(chart_wrapper["a"],{height:height,loading:loading,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshotHistogram.description",{defaultMessage:"Bar Chart showing uptime status over time from {startTime} to {endTime}.",values:{startTime:external_kbnSharedDeps_Moment_default()(new Date(absoluteStartDate).valueOf()).fromNow(),endTime:external_kbnSharedDeps_Moment_default()(new Date(absoluteEndDate).valueOf()).fromNow()}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],ping_histogram_extends({xDomain:{minInterval:minInterval,min:absoluteStartDate,max:absoluteEndDate},showLegend:false,onBrushEnd:onBrushEnd,onElementClick:onBarClicked},chartTheme)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshotHistogram.xAxisId",{defaultMessage:"Ping X Axis"}),position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:false,tickFormat:Object(external_kbnSharedDeps_ElasticCharts_["timeFormatter"])(Object(helper["c"])(absoluteStartDate,absoluteEndDate))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshotHistogram.yAxisId",{defaultMessage:"Ping Y Axis"}),position:"left",tickFormat:d=>external_kbnSharedDeps_ElasticNumeral_default()(d).format("0"),labelFormat:d=>external_kbnSharedDeps_ElasticNumeral_default()(d).format("0a"),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshotHistogram.yAxis.title",{defaultMessage:"Pings",description:"The label on the y-axis of a chart that displays the number of times Heartbeat has pinged a set of services/websites."})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{color:[danger,gray],data:barData,id:translations["e"],name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshotHistogram.series.pings",{defaultMessage:"Monitor Pings"}),stackAccessors:["x"],splitSeriesAccessors:["type"],timeZone:"local",xAccessor:"x",xScaleType:"time",yAccessors:["y"],yScaleType:"linear"})))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.snapshot.pingsOverTimeTitle",defaultMessage:"Pings over time"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),content)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertMonitorStatus}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ToggleAlertFlyoutButton}));__webpack_require__.d(__webpack_exports__,"c",(function(){return UptimeAlertsFlyoutWrapper}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);var lib=__webpack_require__(32);var Either=__webpack_require__(61);var selectors=__webpack_require__(37);var alerts=__webpack_require__(71);var actions=__webpack_require__(33);var runtime_types=__webpack_require__(44);var use_index_pattern=__webpack_require__(160);var hooks=__webpack_require__(35);const AlertMonitorStatus=({enabled:enabled,numTimes:numTimes,setAlertParams:setAlertParams,timerange:timerange,alertParams:alertParams})=>{const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{var _alertParams$filters$,_alertParams$filters,_alertParams$filters$2,_alertParams$filters2,_alertParams$filters$3,_alertParams$filters3,_alertParams$filters$4,_alertParams$filters4;dispatch(Object(actions["d"])({dateRangeStart:"now-24h",dateRangeEnd:"now",locations:(_alertParams$filters$=(_alertParams$filters=alertParams.filters)===null||_alertParams$filters===void 0?void 0:_alertParams$filters["observer.geo.name"])!==null&&_alertParams$filters$!==void 0?_alertParams$filters$:[],ports:(_alertParams$filters$2=(_alertParams$filters2=alertParams.filters)===null||_alertParams$filters2===void 0?void 0:_alertParams$filters2["url.port"])!==null&&_alertParams$filters$2!==void 0?_alertParams$filters$2:[],tags:(_alertParams$filters$3=(_alertParams$filters3=alertParams.filters)===null||_alertParams$filters3===void 0?void 0:_alertParams$filters3.tags)!==null&&_alertParams$filters$3!==void 0?_alertParams$filters$3:[],schemes:(_alertParams$filters$4=(_alertParams$filters4=alertParams.filters)===null||_alertParams$filters4===void 0?void 0:_alertParams$filters4["monitor.type"])!==null&&_alertParams$filters$4!==void 0?_alertParams$filters$4:[]}))},[alertParams,dispatch]);const overviewFilters=Object(lib["useSelector"])(selectors["v"]);const{locations:locations}=Object(lib["useSelector"])(selectors["C"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(alertParams.search){dispatch(Object(actions["L"])(alertParams.search))}},[alertParams,dispatch]);const{index_pattern:indexPattern}=Object(use_index_pattern["a"])();const{count:count,loading:loading}=Object(lib["useSelector"])(selectors["G"]);const esKuery=Object(lib["useSelector"])(selectors["d"]);const[esFilters]=Object(hooks["f"])(indexPattern,alertParams.search,alertParams.filters===undefined||typeof alertParams.filters==="string"?"":JSON.stringify(Array.from(Object.entries(alertParams.filters))));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(actions["J"])(esFilters!==null&&esFilters!==void 0?esFilters:""))},[dispatch,esFilters]);const isOldAlert=external_kbnSharedDeps_React_default.a.useMemo(()=>Object.entries(alertParams).length>0&&!Object(Either["isRight"])(runtime_types["AtomicStatusCheckParamsType"].decode(alertParams))&&!Object(Either["isRight"])(runtime_types["GetMonitorAvailabilityParamsType"].decode(alertParams)),[alertParams]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(actions["B"])({dateRangeStart:"now-24h",dateRangeEnd:"now",filters:esKuery}))},[dispatch,esKuery]);const selectedFilters=Object(lib["useSelector"])(selectors["F"]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!alertParams.filters&&selectedFilters!==null){var _selectedFilters$port,_selectedFilters$loca,_selectedFilters$sche,_selectedFilters$tags;setAlertParams("filters",{"url.port":(_selectedFilters$port=selectedFilters===null||selectedFilters===void 0?void 0:selectedFilters.ports)!==null&&_selectedFilters$port!==void 0?_selectedFilters$port:[],"observer.geo.name":(_selectedFilters$loca=selectedFilters===null||selectedFilters===void 0?void 0:selectedFilters.locations)!==null&&_selectedFilters$loca!==void 0?_selectedFilters$loca:[],"monitor.type":(_selectedFilters$sche=selectedFilters===null||selectedFilters===void 0?void 0:selectedFilters.schemes)!==null&&_selectedFilters$sche!==void 0?_selectedFilters$sche:[],tags:(_selectedFilters$tags=selectedFilters===null||selectedFilters===void 0?void 0:selectedFilters.tags)!==null&&_selectedFilters$tags!==void 0?_selectedFilters$tags:[]})}},[alertParams,setAlertParams,selectedFilters]);const{pathname:pathname}=Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])();const shouldUpdateUrl=Object(external_kbnSharedDeps_React_["useMemo"])(()=>pathname.indexOf("app/uptime")!==-1,[pathname]);return external_kbnSharedDeps_React_default.a.createElement(alerts["a"],{alertParams:alertParams,enabled:enabled,hasFilters:!!(overviewFilters!==null&&overviewFilters!==void 0&&overviewFilters.filters),isOldAlert:isOldAlert,locations:locations||[],numTimes:numTimes,setAlertParams:setAlertParams,shouldUpdateUrl:shouldUpdateUrl,snapshotCount:count.total,snapshotLoading:loading,timerange:timerange})};function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const ToggleAlertFlyoutButton=props=>{const dispatch=Object(lib["useDispatch"])();return external_kbnSharedDeps_React_default.a.createElement(alerts["b"],_extends({},props,{setAlertFlyoutVisible:value=>{if(typeof value==="string"){dispatch(Object(actions["G"])(value));dispatch(Object(actions["H"])(true))}else{dispatch(Object(actions["H"])(value))}}}))};var uptime_alerts_flyout_wrapper=__webpack_require__(106);const UptimeAlertsFlyoutWrapper=()=>{const dispatch=Object(lib["useDispatch"])();const setAddFlyoutVisibility=value=>dispatch(Object(actions["H"])(value));const alertFlyoutVisible=Object(lib["useSelector"])(selectors["y"]);const alertTypeId=Object(lib["useSelector"])(selectors["x"]);return external_kbnSharedDeps_React_default.a.createElement(uptime_alerts_flyout_wrapper["a"],{alertFlyoutVisible:alertFlyoutVisible,alertTypeId:alertTypeId,setAlertFlyoutVisibility:setAddFlyoutVisibility})}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return combineFiltersAndUserSearch}));__webpack_require__.d(__webpack_exports__,"c",(function(){return stringifyKueries}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ml["b"]}));const combineFiltersAndUserSearch=(filters,search)=>{if(!filters&&!search){return""}if(!filters)return search;if(!search)return filters;return`(${filters}) and (${search})`};const stringifyKueries=kueries=>Array.from(kueries.keys()).map(key=>{const value=kueries.get(key);if(!value||value.length===0)return"";return value.reduce((prev,cur,index,array)=>{let expression=`${key}:${cur}`;if(typeof cur!=="number"&&(cur.indexOf(" ")>=0||cur.indexOf(":")>=0)){expression=`${key}:"${cur}"`}if(array.length===1){return expression}else if(array.length>1&&index===0){return`(${expression}`}else if(index+1===array.length){return`${prev} or ${expression})`}return`${prev} or ${expression}`},"")}).reduce((prev,cur,index,array)=>{if(array.length===1||index===0){return cur}else if(cur===""){return prev}else if(prev===""&&!!cur){return cur}return`${prev} and ${cur}`},"");var ml=__webpack_require__(96)},,,,,,,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";var _monitor_list__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(114);var _types__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(102);var _types__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_types__WEBPACK_IMPORTED_MODULE_1__);var _monitor_list_drawer__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(117);__webpack_require__.d(__webpack_exports__,"a",(function(){return _monitor_list_drawer__WEBPACK_IMPORTED_MODULE_2__["b"]}));var _monitor_list_drawer_list_drawer_container__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(113);var _monitor_list_drawer_actions_popover_actions_popover_container__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(104)},function(module,exports){},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MonitorPageLink}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var react_router_dom__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(15);var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);const MonitorPageLink=({children:children,monitorId:monitorId,linkParameters:linkParameters})=>{const getLocationTo=()=>linkParameters?`/monitor/${btoa(monitorId)}/${linkParameters}`:`/monitor/${btoa(monitorId)}`;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiLink"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["Link"],{"data-test-subj":`monitor-page-link-${monitorId}`,to:getLocationTo()},children))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ActionsPopover}));var react_redux__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(32);var react_redux__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_0__);var _state_selectors__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(37);var _state_actions__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(33);var _index__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(117);const mapStateToProps=state=>({popoverState:Object(_state_selectors__WEBPACK_IMPORTED_MODULE_1__["i"])(state)});const mapDispatchToProps=dispatch=>({togglePopoverIsVisible:popoverState=>dispatch(Object(_state_actions__WEBPACK_IMPORTED_MODULE_2__["N"])(popoverState))});const ActionsPopover=Object(react_redux__WEBPACK_IMPORTED_MODULE_0__["connect"])(mapStateToProps,mapDispatchToProps)(_index__WEBPACK_IMPORTED_MODULE_3__["a"])},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return ENABLE_STATUS_ALERT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DISABLE_STATUS_ALERT}));__webpack_require__.d(__webpack_exports__,"c",(function(){return EXPAND_TAGS_LABEL}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const ENABLE_STATUS_ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.enableDownAlert",{defaultMessage:"Enable status alert"});const DISABLE_STATUS_ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.disableDownAlert",{defaultMessage:"Disable status alert"});const EXPAND_TAGS_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.monitorList.tags.expand",{defaultMessage:"Click to view remaining tags"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return UptimeAlertsFlyoutWrapperComponent}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(14);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1__);const UptimeAlertsFlyoutWrapperComponent=({alertFlyoutVisible:alertFlyoutVisible,alertTypeId:alertTypeId,setAlertFlyoutVisibility:setAlertFlyoutVisibility})=>{const{triggersActionsUi:triggersActionsUi}=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1__["useKibana"])().services;const onCloseAlertFlyout=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(()=>setAlertFlyoutVisibility(false),[setAlertFlyoutVisibility]);const AddAlertFlyout=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>triggersActionsUi.getAddAlertFlyout({consumer:"uptime",onClose:onCloseAlertFlyout,alertTypeId:alertTypeId,canChangeTrigger:!alertTypeId}),[onCloseAlertFlyout,alertTypeId]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,alertFlyoutVisible&&AddAlertFlyout)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Snapshot}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_redux__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(32);var react_redux__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);var _hooks__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(35);var _state_actions__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(33);var _snapshot__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(119);var _state_selectors__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(37);var _contexts__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(36);const Snapshot=({height:height})=>{const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd}=Object(_hooks__WEBPACK_IMPORTED_MODULE_2__["c"])();const{lastRefresh:lastRefresh}=Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_contexts__WEBPACK_IMPORTED_MODULE_6__["a"]);const{count:count,loading:loading}=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useSelector"])(_state_selectors__WEBPACK_IMPORTED_MODULE_5__["G"]);const esKuery=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useSelector"])(_state_selectors__WEBPACK_IMPORTED_MODULE_5__["d"]);const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])();Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{dispatch(Object(_state_actions__WEBPACK_IMPORTED_MODULE_3__["B"])({dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,filters:esKuery}))},[dateRangeStart,dateRangeEnd,esKuery,lastRefresh,dispatch]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_snapshot__WEBPACK_IMPORTED_MODULE_4__["a"],{count:count,height:height,loading:loading})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function stripUnit(value){var unitlessValue=parseFloat(value);if(isNaN(unitlessValue))return value;return unitlessValue}exports.default=stripUnit;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function colorToInt(color){return Math.round(color*255)}function convertToInt(red,green,blue){return colorToInt(red)+","+colorToInt(green)+","+colorToInt(blue)}function hslToRgb(hue,saturation,lightness){var convert=arguments.length>3&&arguments[3]!==undefined?arguments[3]:convertToInt;if(saturation===0){return convert(lightness,lightness,lightness)}var huePrime=hue%360/60;var chroma=(1-Math.abs(2*lightness-1))*saturation;var secondComponent=chroma*(1-Math.abs(huePrime%2-1));var red=0;var green=0;var blue=0;if(huePrime>=0&&huePrime<1){red=chroma;green=secondComponent}else if(huePrime>=1&&huePrime<2){red=secondComponent;green=chroma}else if(huePrime>=2&&huePrime<3){green=chroma;blue=secondComponent}else if(huePrime>=3&&huePrime<4){green=secondComponent;blue=chroma}else if(huePrime>=4&&huePrime<5){red=secondComponent;blue=chroma}else if(huePrime>=5&&huePrime<6){red=chroma;blue=secondComponent}var lightnessModification=lightness-chroma/2;var finalRed=red+lightnessModification;var finalGreen=green+lightnessModification;var finalBlue=blue+lightnessModification;return convert(finalRed,finalGreen,finalBlue)}exports.default=hslToRgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _reduceHexValue=__webpack_require__(165);var _reduceHexValue2=_interopRequireDefault(_reduceHexValue);var _numberToHex=__webpack_require__(166);var _numberToHex2=_interopRequireDefault(_numberToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgb(value,green,blue){if(typeof value==="number"&&typeof green==="number"&&typeof blue==="number"){return(0,_reduceHexValue2.default)("#"+(0,_numberToHex2.default)(value)+(0,_numberToHex2.default)(green)+(0,_numberToHex2.default)(blue))}else if(typeof value==="object"&&green===undefined&&blue===undefined){return(0,_reduceHexValue2.default)("#"+(0,_numberToHex2.default)(value.red)+(0,_numberToHex2.default)(value.green)+(0,_numberToHex2.default)(value.blue))}throw new Error("Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).")}exports.default=rgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(69);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function mix(){var weight=arguments.length>0&&arguments[0]!==undefined?arguments[0]:.5;var color=arguments[1];var otherColor=arguments[2];var parsedColor1=(0,_parseToRgb2.default)(color);var color1=_extends({},parsedColor1,{alpha:typeof parsedColor1.alpha==="number"?parsedColor1.alpha:1});var parsedColor2=(0,_parseToRgb2.default)(otherColor);var color2=_extends({},parsedColor2,{alpha:typeof parsedColor2.alpha==="number"?parsedColor2.alpha:1});var alphaDelta=color1.alpha-color2.alpha;var x=weight*2-1;var y=x*alphaDelta===-1?x:x+alphaDelta;var z=1+x*alphaDelta;var weight1=(y/z+1)/2;var weight2=1-weight1;var mixedColor={red:Math.floor(color1.red*weight1+color2.red*weight2),green:Math.floor(color1.green*weight1+color2.green*weight2),blue:Math.floor(color1.blue*weight1+color2.blue*weight2),alpha:color1.alpha+(color2.alpha-color1.alpha)*(weight/1)};return(0,_rgba2.default)(mixedColor)}var curriedMix=(0,_curry2.default)(mix);exports.default=curriedMix;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MonitorListDrawer}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(32);var selectors=__webpack_require__(37);var monitor=__webpack_require__(80);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_Moment_=__webpack_require__(13);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var monitor_page_link=__webpack_require__(103);var hooks=__webpack_require__(35);var stringify_url_params=__webpack_require__(77);const MostRecentError=({error:error,monitorId:monitorId,timestamp:timestamp})=>{const params=Object(hooks["c"])();params.statusFilter="down";const linkParameters=Object(stringify_url_params["a"])(params,true);const timestampStr=timestamp?external_kbnSharedDeps_Moment_default()(new Date(timestamp).valueOf()).fromNow():"";return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.mostRecentError.title",{defaultMessage:"Most recent error ({timestamp})",values:{timestamp:timestampStr},description:"Most Recent Error title in Monitor List Expanded row"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(monitor_page_link["a"],{monitorId:monitorId,linkParameters:linkParameters},error===null||error===void 0?void 0:error.message)))};var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);var location_link=__webpack_require__(79);var constants=__webpack_require__(34);var monitor_status_column=__webpack_require__(72);const MonitorStatusRow=({locationNames:locationNames,status:status})=>{const color=status===constants["s"].UP?"secondary":"danger";let checkListArray=[...locationNames];if(locationNames.has(constants["u"])){checkListArray=checkListArray.filter(item=>item!==constants["u"]);checkListArray.push(constants["u"])}const locations=checkListArray.join(", ");return external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:color},Object(monitor_status_column["b"])(status)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement("span",{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.drawer.statusRowLocationList",{defaultMessage:'A list of locations with "{status}" status when last checked.',values:{status:status}})},locations||"--"),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}))};const MonitorStatusList=({summaryPings:summaryPings})=>{const upChecks=new Set;const downChecks=new Set;summaryPings.forEach(ping=>{var _ping$observer$geo$na,_ping$observer,_ping$observer$geo;const location=(_ping$observer$geo$na=(_ping$observer=ping.observer)===null||_ping$observer===void 0?void 0:(_ping$observer$geo=_ping$observer.geo)===null||_ping$observer$geo===void 0?void 0:_ping$observer$geo.name)!==null&&_ping$observer$geo$na!==void 0?_ping$observer$geo$na:constants["u"];if(ping.monitor.status===constants["s"].UP){upChecks.add(location)}else if(ping.monitor.status===constants["s"].DOWN){downChecks.add(location)}});const absUpChecks=new Set([...upChecks].filter(item=>!downChecks.has(item)));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{style:{maxWidth:1e3}},downChecks.size>0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(MonitorStatusRow,{locationNames:downChecks,status:constants["s"].DOWN})),absUpChecks.size>0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(MonitorStatusRow,{locationNames:absUpChecks,status:constants["s"].UP}))),(downChecks.has(constants["u"])||upChecks.has(constants["u"]))&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorList.drawer.missingLocation",defaultMessage:"Some heartbeat instances do not have a location defined. {link} to your heartbeat configuration.",values:{link:external_kbnSharedDeps_React_default.a.createElement(location_link["a"],null)}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})))};var actions_popover_container=__webpack_require__(104);var contexts=__webpack_require__(36);const LinkGroupList=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiListGroup"]).withConfig({displayName:"LinkGroupList",componentId:"sc-1y6on92-0"})(["&&&{a{padding-left:0;padding-top:0;}}"]);const EnabledAlerts=({monitorAlerts:monitorAlerts,loading:loading})=>{const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const listItems=[];(monitorAlerts!==null&&monitorAlerts!==void 0?monitorAlerts:[]).forEach((alert,ind)=>{listItems.push({label:alert.name,href:basePath+"/app/management/insightsAndAlerting/triggersActions/alert/"+alert.id,size:"s","data-test-subj":"uptimeMonitorListDrawerAlert"+ind})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.enabledAlerts.title",{defaultMessage:"Enabled alerts",description:"Alerts enabled for this monitor"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,listItems.length===0&&!loading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.enabledAlerts.noAlert",{defaultMessage:"No alert is enabled for this monitor."})}),loading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],null):external_kbnSharedDeps_React_default.a.createElement(LinkGroupList,{listItems:listItems,flush:true})))};const MonitorUrl=({monitorUrl:monitorUrl})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.drawer.url",{defaultMessage:"Url"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:monitorUrl,target:"_blank",external:true},monitorUrl)));const MostRecentRun=({summary:summary})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.drawer.mostRecentRun",{defaultMessage:"Most recent test run"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_Moment_default()(summary.state.timestamp).format("LLL").toString())));const ContainerDiv=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"ContainerDiv",componentId:"sc-1todfxn-0"})(["padding:10px;width:100%;"]);function MonitorListDrawerComponent({summary:summary,monitorDetails:monitorDetails,loading:loading}){var _summary$state,_summary$state$url;const monitorUrl=(summary===null||summary===void 0?void 0:(_summary$state=summary.state)===null||_summary$state===void 0?void 0:(_summary$state$url=_summary$state.url)===null||_summary$state$url===void 0?void 0:_summary$state$url.full)||"";return summary&&summary.state.summaryPings?external_kbnSharedDeps_React_default.a.createElement(ContainerDiv,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{style:{maxWidth:1e3}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(MonitorUrl,{monitorUrl:monitorUrl})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(MostRecentRun,{summary:summary})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(actions_popover_container["a"],{summary:summary}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(MonitorStatusList,{summaryPings:summary.state.summaryPings}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(EnabledAlerts,{loading:loading,monitorAlerts:monitorDetails===null||monitorDetails===void 0?void 0:monitorDetails.alerts}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),monitorDetails&&monitorDetails.error&&external_kbnSharedDeps_React_default.a.createElement(MostRecentError,{error:monitorDetails.error,monitorId:summary.monitor_id,timestamp:monitorDetails.timestamp})):null}var alerts_alerts=__webpack_require__(46);const MonitorListDrawer=({summary:summary})=>{var _alerts$data;const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const monitorId=summary===null||summary===void 0?void 0:summary.monitor_id;const{dateRangeStart:dateStart,dateRangeEnd:dateEnd}=Object(hooks["c"])();const monitorDetails=Object(lib["useSelector"])(state=>Object(selectors["p"])(state,summary));const isLoading=Object(lib["useSelector"])(selectors["o"]);const dispatch=Object(lib["useDispatch"])();const{data:alerts,loading:alertsLoading}=Object(lib["useSelector"])(alerts_alerts["b"]);const hasAlert=((_alerts$data=alerts===null||alerts===void 0?void 0:alerts.data)!==null&&_alerts$data!==void 0?_alerts$data:[]).find(alert=>alert.params.search.includes(monitorId));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(monitor["a"].get({dateStart:dateStart,dateEnd:dateEnd,monitorId:monitorId}))},[dateStart,dateEnd,monitorId,dispatch,hasAlert,lastRefresh]);return external_kbnSharedDeps_React_default.a.createElement(MonitorListDrawerComponent,{monitorDetails:monitorDetails,summary:summary,loading:isLoading||alertsLoading})}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MonitorListComponent}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var monitor_status_column=__webpack_require__(72);var charts=__webpack_require__(84);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var hooks=__webpack_require__(35);const OverviewPageLinkButtonIcon=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"]).withConfig({displayName:"OverviewPageLinkButtonIcon",componentId:"ygt868-0"})(["padding-top:12px;"]);const OverviewPageLink=({dataTestSubj:dataTestSubj,direction:direction,pagination:pagination})=>{const[,updateUrlParams]=Object(hooks["h"])();const icon=direction==="prev"?"arrowLeft":"arrowRight";const ariaLabel=direction==="next"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overviewPageLink.next.ariaLabel",{defaultMessage:"Next page of results"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overviewPageLink.prev.ariaLabel",{defaultMessage:"Prev page of results"});const disableLinkLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overviewPageLink.disabled.ariaLabel",{defaultMessage:"A disabled pagination button indicating that there cannot be any further navigation in the monitors list."});return external_kbnSharedDeps_React_default.a.createElement(OverviewPageLinkButtonIcon,{color:"text",onClick:()=>{updateUrlParams({pagination:pagination})},"data-test-subj":dataTestSubj,iconType:icon,"aria-label":!pagination?disableLinkLabel:ariaLabel,disabled:!pagination})};const STATUS_COLUMN_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.statusColumnLabel",{defaultMessage:"Status"});const NAME_COLUMN_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.nameColumnLabel",{defaultMessage:"Name"});const HISTORY_COLUMN_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.monitorHistoryColumnLabel",{defaultMessage:"Downtime history"});const TLS_COLUMN_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.tlsColumnLabel",{defaultMessage:"TLS Certificate"});const getExpandDrawerLabel=id=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.expandDrawerButton.ariaLabel",{defaultMessage:"Expand row for monitor with ID {id}",description:"The user can click a button on this table and expand further details.",values:{id:id}});const getDescriptionLabel=itemsLength=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.table.description",{defaultMessage:"Monitor Status table with columns for Status, Name, URL, IP, Downtime History and Integrations. The table is currently displaying {length} items.",values:{length:itemsLength}});const NO_MONITOR_ITEM_SELECTED=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.noItemForSelectedFiltersMessage",{defaultMessage:"No monitors found for selected filter criteria",description:"This message is show if there are no monitors in the table and some filter or search criteria exists"});const LOADING=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loading",{defaultMessage:"Loading...",description:"Shown when the monitor list is waiting for a server response"});const NO_DATA_MESSAGE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.noItemMessage",{defaultMessage:"No uptime monitors found",description:"This message is shown if the monitors table is rendered but has no items."});const RESPONSE_ANOMALY_SCORE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.anomalyColumn.label",{defaultMessage:"Response Anomaly Score"});const STATUS_ALERT_COLUMN=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.statusAlert.label",{defaultMessage:"Status alert"});var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);const PopoverButton=({setIsOpen:setIsOpen,size:size})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"text","data-test-subj":"xpack.uptime.monitorList.pageSizeSelect.popoverOpen",iconType:"arrowDown",iconSide:"right",onClick:()=>setIsOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorList.pageSizePopoverButtonText",defaultMessage:"Rows per page: {size}",values:{size:size}}));const monitor_list_page_size_select_items=[{"data-test-subj":"xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem10",key:"10 rows",numRows:10},{"data-test-subj":"xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem25",key:"25 rows",numRows:25},{"data-test-subj":"xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem50",key:"50 rows",numRows:50},{"data-test-subj":"xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem100",key:"100 rows",numRows:100}];const LOCAL_STORAGE_KEY="xpack.uptime.monitorList.pageSize";const MonitorListPageSizeSelect=({size:size,setSize:setSize})=>{const[,setUrlParams]=Object(hooks["h"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{localStorage.setItem(LOCAL_STORAGE_KEY,size.toString())},[size]);return external_kbnSharedDeps_React_default.a.createElement(MonitorListPageSizeSelectComponent,{size:size,setSize:setSize,setUrlParams:setUrlParams})};const MonitorListPageSizeSelectComponent=({size:size,setSize:setSize,setUrlParams:setUrlParams})=>{const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(PopoverButton,{setIsOpen:value=>setIsOpen(value),size:size}),isOpen:isOpen,closePopover:()=>setIsOpen(false),anchorPosition:"upLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:monitor_list_page_size_select_items.map(({"data-test-subj":dataTestSubj,key:key,numRows:numRows})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{"data-test-subj":dataTestSubj,key:key,icon:size===numRows?"check":"empty",onClick:()=>{setSize(numRows);setUrlParams({pagination:undefined});setIsOpen(false)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorList.pageSizeSelect.numRowsItemMessage",defaultMessage:"{numRows} rows",values:{numRows:numRows}})))}))};var list_drawer_container=__webpack_require__(113);var cert_status_column=__webpack_require__(159);var status_filter=__webpack_require__(179);const FlexGroupContainer=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"FlexGroupContainer",componentId:"yg3yvo-0"})(["position:relative;"]);const MonitorListHeader=()=>external_kbnSharedDeps_React_default.a.createElement(FlexGroupContainer,{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorList.monitoringStatusTitle",defaultMessage:"Monitors"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(status_filter["a"],null)));var translations=__webpack_require__(50);var enable_alert=__webpack_require__(178);var monitor_name_col=__webpack_require__(158);var monitor_tags=__webpack_require__(157);const noItemsMessage=(loading,filters)=>{if(loading)return LOADING;return!!filters?NO_MONITOR_ITEM_SELECTED:NO_DATA_MESSAGE};const MonitorListComponent=({filters:filters,monitorList:{list:list,error:error,loading:loading},pageSize:pageSize,setPageSize:setPageSize})=>{var _list$summaries,_list$nextPagePaginat,_list$prevPagePaginat,_error$body;const[drawerIds,updateDrawerIds]=Object(external_kbnSharedDeps_React_["useState"])([]);const items=(_list$summaries=list.summaries)!==null&&_list$summaries!==void 0?_list$summaries:[];const nextPagePagination=(_list$nextPagePaginat=list.nextPagePagination)!==null&&_list$nextPagePaginat!==void 0?_list$nextPagePaginat:"";const prevPagePagination=(_list$prevPagePaginat=list.prevPagePagination)!==null&&_list$prevPagePaginat!==void 0?_list$prevPagePaginat:"";const getExpandedRowMap=()=>drawerIds.reduce((map,id)=>({...map,[id]:external_kbnSharedDeps_React_default.a.createElement(list_drawer_container["a"],{summary:items.find(({monitor_id:monitorId})=>monitorId===id)})}),{});const columns=[{align:"left",field:"state.summary.status",name:STATUS_COLUMN_LABEL,mobileOptions:{fullWidth:true},render:(status,{state:{timestamp:timestamp,summaryPings:summaryPings}})=>external_kbnSharedDeps_React_default.a.createElement(monitor_status_column["a"],{status:status,timestamp:timestamp,summaryPings:summaryPings!==null&&summaryPings!==void 0?summaryPings:[]})},{align:"left",field:"state.monitor.name",name:NAME_COLUMN_LABEL,mobileOptions:{fullWidth:true},render:(name,summary)=>external_kbnSharedDeps_React_default.a.createElement(monitor_name_col["a"],{summary:summary}),sortable:true},{align:"left",field:"state.url.full",name:translations["i"],width:"30%",render:url=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:url,target:"_blank",color:"text",external:true},url)},{align:"left",field:"state.monitor.name",name:translations["h"],width:"12%",render:(_name,summary)=>external_kbnSharedDeps_React_default.a.createElement(monitor_tags["a"],{summary:summary})},{align:"left",field:"state.tls.server.x509",name:TLS_COLUMN_LABEL,render:x509=>external_kbnSharedDeps_React_default.a.createElement(cert_status_column["a"],{expiry:x509})},{align:"center",field:"histogram.points",name:HISTORY_COLUMN_LABEL,mobileOptions:{show:false},render:(histogramSeries,summary)=>external_kbnSharedDeps_React_default.a.createElement(charts["c"],{histogramSeries:histogramSeries,minInterval:summary.minInterval})},{align:"center",field:"",name:STATUS_ALERT_COLUMN,width:"100px",render:item=>external_kbnSharedDeps_React_default.a.createElement(enable_alert["a"],{monitorId:item.monitor_id,monitorName:item.state.monitor.name||item.monitor_id})},{align:"right",field:"monitor_id",name:"",sortable:true,isExpander:true,width:"40px",render:id=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":getExpandDrawerLabel(id),"data-test-subj":`xpack.uptime.monitorList.${id}.expandMonitorDetail`,iconType:drawerIds.includes(id)?"arrowUp":"arrowDown",onClick:()=>{if(drawerIds.includes(id)){updateDrawerIds(drawerIds.filter(p=>p!==id))}else{updateDrawerIds([...drawerIds,id])}}})}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(MonitorListHeader,null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{"aria-label":getDescriptionLabel(items.length),error:(error===null||error===void 0?void 0:(_error$body=error.body)===null||_error$body===void 0?void 0:_error$body.message)||(error===null||error===void 0?void 0:error.message),loading:loading,isExpandable:true,hasActions:true,itemId:"monitor_id",itemIdToExpandedRowMap:getExpandedRowMap(),items:items,noItemsMessage:noItemsMessage(loading,filters),columns:columns,tableLayout:"auto"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(MonitorListPageSizeSelect,{size:pageSize,setSize:setPageSize})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(OverviewPageLink,{dataTestSubj:"xpack.uptime.monitorList.prevButton",direction:"prev",pagination:prevPagePagination})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(OverviewPageLink,{dataTestSubj:"xpack.uptime.monitorList.nextButton",direction:"next",pagination:nextPagePagination}))))))}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return FilterGroupComponent}));__webpack_require__.d(__webpack_exports__,"a",(function(){return FilterGroup}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);var filter_popover=__webpack_require__(173);var translations=__webpack_require__(154);var use_filter_update=__webpack_require__(81);var constants=__webpack_require__(34);var use_selected_filters=__webpack_require__(153);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const Container=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"]).withConfig({displayName:"Container",componentId:"o134a8-0"})(["margin-bottom:10px;"]);function isDisabled(array){return array?array.length===0:true}const FilterGroupComponent=({overviewFilters:overviewFilters,loading:loading})=>{var _ports$map;const{locations:locations,ports:ports,schemes:schemes,tags:tags}=overviewFilters;const[updatedFieldValues,setUpdatedFieldValues]=Object(external_kbnSharedDeps_React_["useState"])({fieldName:"",values:[]});Object(use_filter_update["a"])(updatedFieldValues.fieldName,updatedFieldValues.values);const{selectedLocations:selectedLocations,selectedPorts:selectedPorts,selectedSchemes:selectedSchemes,selectedTags:selectedTags}=Object(use_selected_filters["a"])();const onFilterFieldChange=(fieldName,values)=>{setUpdatedFieldValues({fieldName:fieldName,values:values})};const isMonitorPage=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])(constants["m"]);const filterPopoverProps=[{loading:loading,onFilterFieldChange:onFilterFieldChange,fieldName:"observer.geo.name",id:"location",items:locations||[],selectedItems:selectedLocations,title:translations["a"].LOCATION},...!isMonitorPage?[{loading:loading,onFilterFieldChange:onFilterFieldChange,fieldName:"url.port",id:"port",disabled:isDisabled(ports),items:(_ports$map=ports===null||ports===void 0?void 0:ports.map(p=>p.toString()))!==null&&_ports$map!==void 0?_ports$map:[],selectedItems:selectedPorts,title:translations["a"].PORT},{loading:loading,onFilterFieldChange:onFilterFieldChange,fieldName:"monitor.type",id:"scheme",disabled:isDisabled(schemes),items:schemes!==null&&schemes!==void 0?schemes:[],selectedItems:selectedSchemes,title:translations["a"].SCHEME},{loading:loading,onFilterFieldChange:onFilterFieldChange,fieldName:"tags",id:"tags",disabled:isDisabled(tags),items:tags!==null&&tags!==void 0?tags:[],selectedItems:selectedTags,title:translations["a"].TAG}]:[]];return external_kbnSharedDeps_React_default.a.createElement(Container,null,filterPopoverProps.map(item=>external_kbnSharedDeps_React_default.a.createElement(filter_popover["a"],_extends({key:item.id},item))))};var lib=__webpack_require__(32);var hooks=__webpack_require__(35);const filterAllowList=[{name:"ports",fieldName:"url.port"},{name:"locations",fieldName:"observer.geo.name"},{name:"tags",fieldName:"tags"},{name:"schemes",fieldName:"monitor.type"}];const parseFiltersMap=filterMapString=>{if(!filterMapString){return{}}const filterSlices={};try{const map=new Map(JSON.parse(filterMapString));filterAllowList.forEach(({name:name,fieldName:fieldName})=>{var _map$get;filterSlices[name]=(_map$get=map.get(fieldName))!==null&&_map$get!==void 0?_map$get:[]});return filterSlices}catch{throw new Error("Unable to parse invalid filter string")}};var actions=__webpack_require__(33);var contexts=__webpack_require__(36);var selectors=__webpack_require__(37);const FilterGroup=({esFilters:esFilters})=>{const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{filters:overviewFilters,loading:loading}=Object(lib["useSelector"])(selectors["v"]);const esKuery=Object(lib["useSelector"])(selectors["d"]);const{dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,statusFilter:statusFilter,filters:urlFilters}=Object(hooks["c"])();const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{var _filterSelections$loc,_filterSelections$por,_filterSelections$sch,_filterSelections$tag;const filterSelections=parseFiltersMap(urlFilters);dispatch(Object(actions["d"])({dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,locations:(_filterSelections$loc=filterSelections.locations)!==null&&_filterSelections$loc!==void 0?_filterSelections$loc:[],ports:(_filterSelections$por=filterSelections.ports)!==null&&_filterSelections$por!==void 0?_filterSelections$por:[],schemes:(_filterSelections$sch=filterSelections.schemes)!==null&&_filterSelections$sch!==void 0?_filterSelections$sch:[],search:esKuery,statusFilter:statusFilter,tags:(_filterSelections$tag=filterSelections.tags)!==null&&_filterSelections$tag!==void 0?_filterSelections$tag:[]}))},[lastRefresh,dateRangeStart,dateRangeEnd,esKuery,esFilters,statusFilter,urlFilters,dispatch]);return external_kbnSharedDeps_React_default.a.createElement(FilterGroupComponent,{overviewFilters:overviewFilters,loading:loading})}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return location_link["a"]}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ActionsPopoverComponent}));var location_link=__webpack_require__(79);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);const IntegrationLink=({ariaLabel:ariaLabel,href:href,iconType:iconType,message:message,tooltipContent:tooltipContent})=>typeof href==="undefined"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.integrationLink.missingDataMessage",{defaultMessage:"Required data for this integration was not found."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:iconType}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},message))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"aria-label":ariaLabel,href:href},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:tooltipContent,position:"top"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:iconType}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,message)));var helper=__webpack_require__(60);var contexts=__webpack_require__(36);const extractSummaryValues=summary=>{var _summary$state$url$do,_summary$state$url,_summary$state$summar,_firstCheck$kubernete,_firstCheck$kubernete2,_firstCheck$kubernete3,_firstCheck$container,_firstCheck$container2,_firstCheck$monitor$i;const domain=(_summary$state$url$do=(_summary$state$url=summary.state.url)===null||_summary$state$url===void 0?void 0:_summary$state$url.domain)!==null&&_summary$state$url$do!==void 0?_summary$state$url$do:"";const firstCheck=(_summary$state$summar=summary.state.summaryPings)===null||_summary$state$summar===void 0?void 0:_summary$state$summar[0];const podUid=(_firstCheck$kubernete=firstCheck===null||firstCheck===void 0?void 0:(_firstCheck$kubernete2=firstCheck.kubernetes)===null||_firstCheck$kubernete2===void 0?void 0:(_firstCheck$kubernete3=_firstCheck$kubernete2.pod)===null||_firstCheck$kubernete3===void 0?void 0:_firstCheck$kubernete3.uid)!==null&&_firstCheck$kubernete!==void 0?_firstCheck$kubernete:undefined;const containerId=(_firstCheck$container=firstCheck===null||firstCheck===void 0?void 0:(_firstCheck$container2=firstCheck.container)===null||_firstCheck$container2===void 0?void 0:_firstCheck$container2.id)!==null&&_firstCheck$container!==void 0?_firstCheck$container:undefined;const ip=(_firstCheck$monitor$i=firstCheck===null||firstCheck===void 0?void 0:firstCheck.monitor.ip)!==null&&_firstCheck$monitor$i!==void 0?_firstCheck$monitor$i:undefined;return{domain:domain,podUid:podUid,containerId:containerId,ip:ip}};const IntegrationGroup=({summary:summary})=>{const{basePath:basePath,dateRangeStart:dateRangeStart,dateRangeEnd:dateRangeEnd,isApmAvailable:isApmAvailable,isInfraAvailable:isInfraAvailable,isLogsAvailable:isLogsAvailable}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);const{domain:domain,podUid:podUid,containerId:containerId,ip:ip}=extractSummaryValues(summary);return isApmAvailable||isInfraAvailable||isLogsAvailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},isApmAvailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.apmIntegrationAction.description",{defaultMessage:"Search APM for this monitor",description:"This value is shown to users when they hover over an icon that will take them to the APM app."}),href:Object(helper["b"])(summary,basePath,dateRangeStart,dateRangeEnd),iconType:"apmApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.apmIntegrationAction.text",{defaultMessage:"Show APM Data",description:"A message explaining that when the user clicks the associated link, it will navigate to the APM app"}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.observabilityIntegrationsColumn.apmIntegrationLink.tooltip",{defaultMessage:'Click here to check APM for the domain "{domain}" or explicitly defined "service name".',description:"A messsage shown in a tooltip explaining that the nested anchor tag will navigate to the APM app and search for the given URL domain or explicitly defined service name.",values:{domain:domain}})})):null,isInfraAvailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.ip.ariaLabel",{defaultMessage:`Check Infrastructure UI for this montor's ip address`,description:"This value is shown as the aria label value for screen readers."}),href:Object(helper["e"])(summary,basePath),iconType:"metricsApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.ip.message",{defaultMessage:"Show host metrics",description:`A message explaining that this link will take the user to the Infrastructure UI, filtered for this monitor's IP Address`}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.ip.tooltip",{defaultMessage:'Check Infrastructure UI for the IP "{ip}"',values:{ip:Array.isArray(ip)?ip[0]:ip}})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.kubernetes.description",{defaultMessage:`Check Infrastructure UI for this monitor's pod UID`,description:"This value is shown as the aria label value for screen readers."}),href:Object(helper["f"])(summary,basePath),iconType:"metricsApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.kubernetes.message",{defaultMessage:"Show pod metrics",description:"A message explaining that this link will take the user to the Infrastructure UI filtered for the monitor Pod UID."}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.kubernetes.tooltip",{defaultMessage:'Check Infrastructure UI for pod UID "{podUid}".',values:{podUid:podUid}})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.docker.description",{defaultMessage:`Check Infrastructure UI for this monitor's container ID`}),href:Object(helper["d"])(summary,basePath),iconType:"metricsApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.container.message",{defaultMessage:"Show container metrics"}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.infraIntegrationAction.docker.tooltip",{defaultMessage:'Check Infrastructure UI for container ID "{containerId}"',values:{containerId:containerId}})}))):null,isLogsAvailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.ip.description",{defaultMessage:`Check Logging UI for this monitor's ip address`,description:"This value is shown as the aria label for screen readers."}),href:Object(helper["h"])(summary,basePath),iconType:"logsApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.ip.message",{defaultMessage:"Show host logs",description:`A message explaining that this link will take the user to the Infrastructure UI filtered for the monitor's IP Address`}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.ip.tooltip",{defaultMessage:'Check Logging UI for the IP "{ip}"',values:{ip:Array.isArray(ip)?ip[0]:ip}})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.kubernetes.ariaLabel",{defaultMessage:"Show pod logs"}),href:Object(helper["i"])(summary,basePath),iconType:"logsApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.kubernetes.message",{defaultMessage:"Show pod logs"}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.kubernetes.tooltip",{defaultMessage:'Check for logs for pod UID "{podUid}"',values:{podUid:podUid}})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(IntegrationLink,{ariaLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.container.id",{defaultMessage:"Show container logs"}),href:Object(helper["g"])(summary,basePath),iconType:"logsApp",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.container.message",{defaultMessage:"Show container logs"}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.loggingIntegrationAction.container.tooltip",{defaultMessage:'Check Logging UI for container ID "{containerId}"',values:{containerId:containerId}})}))):null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"No integrated applications available",description:"This message is shown when no applications that Uptime links to are enabled in the current space",id:"xpack.uptime.monitorList.integrationGroup.emptyMessage"})};const ActionsPopoverComponent=({summary:summary,popoverState:popoverState,togglePopoverIsVisible:togglePopoverIsVisible})=>{var _summary$state,_summary$state$url;const popoverId=`${summary.monitor_id}_popover`;const monitorUrl=summary===null||summary===void 0?void 0:(_summary$state=summary.state)===null||_summary$state===void 0?void 0:(_summary$state$url=_summary$state.url)===null||_summary$state$url===void 0?void 0:_summary$state$url.full;const isPopoverOpen=!!popoverState&&popoverState.open&&popoverState.id===popoverId;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.observabilityIntegrationsColumn.popoverIconButton.ariaLabel",{defaultMessage:"Opens integrations popover for monitor with url {monitorUrl}",description:"A message explaining that this button opens a popover with links to other apps for a given monitor",values:{monitorUrl:monitorUrl}}),"data-test-subj":`xpack.uptime.monitorList.actionsPopover.${summary.monitor_id}`,onClick:()=>togglePopoverIsVisible({id:popoverId,open:true}),iconType:"arrowDown",iconSide:"right"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.monitorList.observabilityInvestigateColumn.popoverIconButton.label",{defaultMessage:"Investigate"})),closePopover:()=>togglePopoverIsVisible({id:popoverId,open:false}),id:popoverId,isOpen:isPopoverOpen},external_kbnSharedDeps_React_default.a.createElement(IntegrationGroup,{summary:summary}))}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SnapshotComponent}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var charts=__webpack_require__(84);var chart_wrapper=__webpack_require__(120);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const SnapshotHeading=({total:total})=>{const monitorsText=total===1?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshot.monitor",{defaultMessage:"Monitor"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.snapshot.monitors",{defaultMessage:"Monitors"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,total," ",monitorsText))};const SNAPSHOT_CHART_HEIGHT=144;const SnapshotComponent=({count:count,height:height,loading:loading})=>external_kbnSharedDeps_React_default.a.createElement(chart_wrapper["a"],{loading:loading,height:height},external_kbnSharedDeps_React_default.a.createElement(SnapshotHeading,{total:count.total}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(charts["a"],{up:count.up,down:count.down,height:SNAPSHOT_CHART_HEIGHT}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ChartWrapper}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const ChartWrapper=({loading:loading=false,height:height="100%",children:children,...rest})=>{const opacity=loading===true?.3:1;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement("div",_extends({style:{height:height,opacity:opacity,transition:"opacity 0.2s"}},rest),children),loading===true&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround",alignItems:"center",style:{height:height,marginTop:`-${height}`,marginBottom:0}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl"}))))}},,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";const strictUriEncode=__webpack_require__(200);const decodeComponent=__webpack_require__(201);const splitOnFirst=__webpack_require__(202);const isNullOrUndefined=value=>value===null||value===undefined;function encoderForArrayFormat(options){switch(options.arrayFormat){case"index":return key=>(result,value)=>{const index=result.length;if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[",index,"]"].join("")]}return[...result,[encode(key,options),"[",encode(index,options),"]=",encode(value,options)].join("")]};case"bracket":return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[]"].join("")]}return[...result,[encode(key,options),"[]=",encode(value,options)].join("")]};case"comma":case"separator":return key=>(result,value)=>{if(value===null||value===undefined||value.length===0){return result}if(result.length===0){return[[encode(key,options),"=",encode(value,options)].join("")]}return[[result,encode(value,options)].join(options.arrayFormatSeparator)]};default:return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,encode(key,options)]}return[...result,[encode(key,options),"=",encode(value,options)].join("")]}}}function parserForArrayFormat(options){let result;switch(options.arrayFormat){case"index":return(key,value,accumulator)=>{result=/\[(\d*)\]$/.exec(key);key=key.replace(/\[\d*\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]={}}accumulator[key][result[1]]=value};case"bracket":return(key,value,accumulator)=>{result=/(\[\])$/.exec(key);key=key.replace(/\[\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]=[value];return}accumulator[key]=[].concat(accumulator[key],value)};case"comma":case"separator":return(key,value,accumulator)=>{const isArray=typeof value==="string"&&value.split("").indexOf(options.arrayFormatSeparator)>-1;const newValue=isArray?value.split(options.arrayFormatSeparator).map(item=>decode(item,options)):value===null?value:decode(value,options);accumulator[key]=newValue};default:return(key,value,accumulator)=>{if(accumulator[key]===undefined){accumulator[key]=value;return}accumulator[key]=[].concat(accumulator[key],value)}}}function validateArrayFormatSeparator(value){if(typeof value!=="string"||value.length!==1){throw new TypeError("arrayFormatSeparator must be single character string")}}function encode(value,options){if(options.encode){return options.strict?strictUriEncode(value):encodeURIComponent(value)}return value}function decode(value,options){if(options.decode){return decodeComponent(value)}return value}function keysSorter(input){if(Array.isArray(input)){return input.sort()}if(typeof input==="object"){return keysSorter(Object.keys(input)).sort((a,b)=>Number(a)-Number(b)).map(key=>input[key])}return input}function removeHash(input){const hashStart=input.indexOf("#");if(hashStart!==-1){input=input.slice(0,hashStart)}return input}function getHash(url){let hash="";const hashStart=url.indexOf("#");if(hashStart!==-1){hash=url.slice(hashStart)}return hash}function extract(input){input=removeHash(input);const queryStart=input.indexOf("?");if(queryStart===-1){return""}return input.slice(queryStart+1)}function parseValue(value,options){if(options.parseNumbers&&!Number.isNaN(Number(value))&&(typeof value==="string"&&value.trim()!=="")){value=Number(value)}else if(options.parseBooleans&&value!==null&&(value.toLowerCase()==="true"||value.toLowerCase()==="false")){value=value.toLowerCase()==="true"}return value}function parse(input,options){options=Object.assign({decode:true,sort:true,arrayFormat:"none",arrayFormatSeparator:",",parseNumbers:false,parseBooleans:false},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const formatter=parserForArrayFormat(options);const ret=Object.create(null);if(typeof input!=="string"){return ret}input=input.trim().replace(/^[?#&]/,"");if(!input){return ret}for(const param of input.split("&")){let[key,value]=splitOnFirst(options.decode?param.replace(/\+/g," "):param,"=");value=value===undefined?null:["comma","separator"].includes(options.arrayFormat)?value:decode(value,options);formatter(decode(key,options),value,ret)}for(const key of Object.keys(ret)){const value=ret[key];if(typeof value==="object"&&value!==null){for(const k of Object.keys(value)){value[k]=parseValue(value[k],options)}}else{ret[key]=parseValue(value,options)}}if(options.sort===false){return ret}return(options.sort===true?Object.keys(ret).sort():Object.keys(ret).sort(options.sort)).reduce((result,key)=>{const value=ret[key];if(Boolean(value)&&typeof value==="object"&&!Array.isArray(value)){result[key]=keysSorter(value)}else{result[key]=value}return result},Object.create(null))}exports.extract=extract;exports.parse=parse;exports.stringify=(object,options)=>{if(!object){return""}options=Object.assign({encode:true,strict:true,arrayFormat:"none",arrayFormatSeparator:","},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const shouldFilter=key=>options.skipNull&&isNullOrUndefined(object[key])||options.skipEmptyString&&object[key]==="";const formatter=encoderForArrayFormat(options);const objectCopy={};for(const key of Object.keys(object)){if(!shouldFilter(key)){objectCopy[key]=object[key]}}const keys=Object.keys(objectCopy);if(options.sort!==false){keys.sort(options.sort)}return keys.map(key=>{const value=object[key];if(value===undefined){return""}if(value===null){return encode(key,options)}if(Array.isArray(value)){return value.reduce(formatter(key),[]).join("&")}return encode(key,options)+"="+encode(value,options)}).filter(x=>x.length>0).join("&")};exports.parseUrl=(input,options)=>{options=Object.assign({decode:true},options);const[url,hash]=splitOnFirst(input,"#");return Object.assign({url:url.split("?")[0]||"",query:parse(extract(input),options)},options&&options.parseFragmentIdentifier&&hash?{fragmentIdentifier:decode(hash,options)}:{})};exports.stringifyUrl=(input,options)=>{options=Object.assign({encode:true,strict:true},options);const url=removeHash(input.url).split("?")[0]||"";const queryFromUrl=exports.extract(input.url);const parsedQueryFromUrl=exports.parse(queryFromUrl,{sort:false});const query=Object.assign(parsedQueryFromUrl,input.query);let queryString=exports.stringify(query,options);if(queryString){queryString=`?${queryString}`}let hash=getHash(input.url);if(input.fragmentIdentifier){hash=`#${encode(input.fragmentIdentifier,options)}`}return`${url}${queryString}${hash}`}},,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(1);var useIntersection=function(ref,options){var _a=react_1.useState(null),intersectionObserverEntry=_a[0],setIntersectionObserverEntry=_a[1];react_1.useEffect((function(){if(ref.current&&typeof IntersectionObserver==="function"){var handler=function(entries){setIntersectionObserverEntry(entries[0])};var observer_1=new IntersectionObserver(handler,options);observer_1.observe(ref.current);return function(){setIntersectionObserverEntry(null);observer_1.disconnect()}}return function(){}}),[ref.current,options.threshold,options.root,options.rootMargin]);return intersectionObserverEntry};exports.default=useIntersection},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useSelectedFilters}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _use_url_params__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(62);const useSelectedFilters=()=>{const{filters:filters}=Object(_use_url_params__WEBPACK_IMPORTED_MODULE_1__["a"])();return Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>{let selectedFilters;try{selectedFilters=new Map(JSON.parse(filters))}catch{selectedFilters=new Map}return{selectedTags:selectedFilters.get("tags")||[],selectedPorts:selectedFilters.get("url.port")||[],selectedSchemes:selectedFilters.get("monitor.type")||[],selectedLocations:selectedFilters.get("observer.geo.name")||[]}},[filters])}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return filterLabels}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const filterLabels={LOCATION:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.filterBar.options.location.name",{defaultMessage:"Location"}),PORT:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.filterBar.options.portLabel",{defaultMessage:"Port"}),SCHEME:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.filterBar.options.schemeLabel",{defaultMessage:"Scheme"}),TAG:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.uptime.filterBar.options.tagsLabel",{defaultMessage:"Tag"})}},function(module,exports){var getRandomValues=typeof crypto!="undefined"&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||typeof msCrypto!="undefined"&&typeof window.msCrypto.getRandomValues=="function"&&msCrypto.getRandomValues.bind(msCrypto);if(getRandomValues){var rnds8=new Uint8Array(16);module.exports=function whatwgRNG(){getRandomValues(rnds8);return rnds8}}else{var rnds=new Array(16);module.exports=function mathRNG(){for(var i=0,r;i<16;i++){if((i&3)===0)r=Math.random()*4294967296;rnds[i]=r>>>((i&3)<<3)&255}return rnds}}},function(module,exports){var byteToHex=[];for(var i=0;i<256;++i){byteToHex[i]=(i+256).toString(16).substr(1)}function bytesToUuid(buf,offset){var i=offset||0;var bth=byteToHex;return[bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]]].join("")}module.exports=bytesToUuid},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MonitorTags}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_2__);var react_router_dom__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(15);var react_router_dom__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_3__);var _hooks_use_filter_update__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(81);var _hooks__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(35);var _overview_monitor_list_columns_monitor_name_col__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(158);var _overview_monitor_list_columns_translations__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(105);var _common_constants__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(34);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(14);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_9___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_9__);const getTagsFromSummary=summary=>{let tags=new Set;summary.state.summaryPings.forEach(ping=>{var _ping$tags;tags=new Set([...tags,...(_ping$tags=ping===null||ping===void 0?void 0:ping.tags)!==null&&_ping$tags!==void 0?_ping$tags:[]])});return[...tags]};const getTagsFromPing=ping=>{var _ping$tags2;return(_ping$tags2=ping===null||ping===void 0?void 0:ping.tags)!==null&&_ping$tags2!==void 0?_ping$tags2:[]};const getFilterLabel=tag=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_2__["i18n"].translate("xpack.uptime.monitorList.tags.filter",{defaultMessage:"Filter all monitors with tag {tag}",values:{tag:tag}});const MonitorTags=({ping:ping,summary:summary})=>{var _currFilters$get;const history=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useHistory"])();const{services:{docLinks:docLinks}}=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_9__["useKibana"])();const[toDisplay,setToDisplay]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(5);let tags;if(summary){tags=getTagsFromSummary(summary)}else{tags=getTagsFromPing(ping)}const tagsToDisplay=tags.slice(0,toDisplay);const{absoluteDateRangeStart:absoluteDateRangeStart,absoluteDateRangeEnd:absoluteDateRangeEnd,...params}=Object(_hooks__WEBPACK_IMPORTED_MODULE_5__["c"])();const currFilters=Object(_overview_monitor_list_columns_monitor_name_col__WEBPACK_IMPORTED_MODULE_6__["b"])(params.filters);const[filterType,setFilterType]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])((_currFilters$get=currFilters.get("tags"))!==null&&_currFilters$get!==void 0?_currFilters$get:[]);Object(_hooks_use_filter_update__WEBPACK_IMPORTED_MODULE_4__["a"])("tags",filterType);if(tags.length===0){return summary?null:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiLink"],{href:(docLinks===null||docLinks===void 0?void 0:docLinks.links.heartbeat.base)+"/monitor-options.html#monitor-tags",target:"_blank"},"Set tags")}return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiBadgeGroup"],null,tagsToDisplay.map(tag=>summary?react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiBadge"],{key:tag,title:getFilterLabel(tag),onClick:()=>{setFilterType([tag])},onClickAriaLabel:getFilterLabel(tag),color:"hollow",className:"eui-textTruncate",style:{maxWidth:120}},tag):react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiBadge"],{key:tag,color:"hollow",className:"eui-textTruncate",style:{maxWidth:120},href:history.createHref({pathname:_common_constants__WEBPACK_IMPORTED_MODULE_8__["o"],search:`filters=[["tags",["${tag}"]]]`})},tag)),tags.length>toDisplay&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiBadge"],{color:"hollow",onClick:()=>{setToDisplay(tags.length)},onClickAriaLabel:_overview_monitor_list_columns_translations__WEBPACK_IMPORTED_MODULE_7__["c"]},"+",tags.length-5))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return parseCurrentFilters}));__webpack_require__.d(__webpack_exports__,"a",(function(){return MonitorNameColumn}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__);var _common_monitor_page_link__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(103);var _hooks__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(35);var _lib_helper_stringify_url_params__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(77);var _hooks_use_filter_update__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(81);const parseCurrentFilters=filters=>{let parsedFilters;try{parsedFilters=new Map(JSON.parse(filters))}catch{parsedFilters=new Map}return parsedFilters};const MONITOR_TYPES={browser:"Browser",http:"HTTP Ping",tcp:"TCP Ping",icmp:"ICMP Ping"};const MonitorNameColumn=({summary:summary})=>{var _currFilters$get;const params=Object(_hooks__WEBPACK_IMPORTED_MODULE_4__["c"])();const linkParameters=Object(_lib_helper_stringify_url_params__WEBPACK_IMPORTED_MODULE_5__["a"])(params,true);const currFilters=parseCurrentFilters(params.filters);const[filterType,setFilterType]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])((_currFilters$get=currFilters.get("monitor.type"))!==null&&_currFilters$get!==void 0?_currFilters$get:[]);Object(_hooks_use_filter_update__WEBPACK_IMPORTED_MODULE_6__["a"])("monitor.type",filterType);const filterLabel=_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.uptime.monitorList.monitorType.filter",{defaultMessage:"Filter all monitors with type {type}",values:{type:summary.state.monitor.type}});return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_monitor_page_link__WEBPACK_IMPORTED_MODULE_3__["a"],{monitorId:summary.monitor_id,linkParameters:linkParameters},summary.state.monitor.name?summary.state.monitor.name:`Unnamed - ${summary.monitor_id}`),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiButtonEmpty"],{color:"text",title:filterLabel,onClick:()=>{setFilterType([summary.state.monitor.type])},size:"xs",flush:"left",style:{border:"none"}},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiText"],{size:"xs"},MONITOR_TYPES[summary.state.monitor.type]))))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return CertStatusColumn}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var moment__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(13);var moment__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(12);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(10);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__);var _hooks__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(35);var _certificates_translations__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(58);var _common_constants__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(34);const Span=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.span.withConfig({displayName:"Span",componentId:"sc-97hvu6-0"})(["margin-left:5px;vertical-align:middle;"]);const H4Text=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.h4.withConfig({displayName:"H4Text",componentId:"sc-97hvu6-1"})(["&&&{margin:0 0 0 4px;display:inline-block;color:inherit;}"]);const CertStatusColumn=({expiry:expiry,boldStyle:boldStyle=false})=>{const notAfter=expiry===null||expiry===void 0?void 0:expiry.not_after;const certStatus=Object(_hooks__WEBPACK_IMPORTED_MODULE_4__["b"])(notAfter);const relativeDate=moment__WEBPACK_IMPORTED_MODULE_1___default()(notAfter).fromNow();const CertStatus=({color:color,text:text})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiToolTip"],{content:moment__WEBPACK_IMPORTED_MODULE_1___default()(notAfter).format("L LT")},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiText"],{size:"s"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiIcon"],{color:color,type:"lock",size:"s"}),boldStyle?react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(H4Text,null,text," ",relativeDate):react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Span,null,text," ",relativeDate)));if(certStatus===_common_constants__WEBPACK_IMPORTED_MODULE_6__["c"].EXPIRING_SOON){return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(CertStatus,{color:"warning",text:_certificates_translations__WEBPACK_IMPORTED_MODULE_5__["g"]})}if(certStatus===_common_constants__WEBPACK_IMPORTED_MODULE_6__["c"].EXPIRED){return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(CertStatus,{color:"danger",text:_certificates_translations__WEBPACK_IMPORTED_MODULE_5__["e"]})}return certStatus?react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(CertStatus,{color:"success",text:_certificates_translations__WEBPACK_IMPORTED_MODULE_5__["f"]}):react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span",null,"--")}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useIndexPattern}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_redux__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(32);var react_redux__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);var _state_actions__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(33);var _state_selectors__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(37);const useIndexPattern=()=>{const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])();const indexPattern=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useSelector"])(_state_selectors__WEBPACK_IMPORTED_MODULE_3__["B"]);Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(!indexPattern.index_pattern){dispatch(Object(_state_actions__WEBPACK_IMPORTED_MODULE_2__["i"])())}},[indexPattern.index_pattern,dispatch]);return indexPattern}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.wordWrap=exports.triangle=exports.transparentize=exports.transitions=exports.toColorString=exports.tint=exports.timingFunctions=exports.textInputs=exports.stripUnit=exports.size=exports.shade=exports.setSaturation=exports.setLightness=exports.setHue=exports.selection=exports.saturate=exports.rgba=exports.rgb=exports.retinaImage=exports.rem=exports.readableColor=exports.radialGradient=exports.position=exports.placeholder=exports.parseToRgb=exports.parseToHsl=exports.padding=exports.opacify=exports.normalize=exports.modularScale=exports.mix=exports.margin=exports.lighten=exports.hsla=exports.hsl=exports.hiDPI=exports.hideVisually=exports.hideText=exports.invert=exports.grayscale=exports.getLuminance=exports.fontFace=exports.em=exports.ellipsis=exports.directionalProperty=exports.desaturate=exports.darken=exports.complement=exports.clearFix=exports.buttons=exports.borderWidth=exports.borderStyle=exports.borderRadius=exports.borderColor=exports.backgrounds=exports.backgroundImages=exports.animation=exports.adjustHue=undefined;var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);var _em=__webpack_require__(237);var _em2=_interopRequireDefault(_em);var _modularScale=__webpack_require__(239);var _modularScale2=_interopRequireDefault(_modularScale);var _rem=__webpack_require__(240);var _rem2=_interopRequireDefault(_rem);var _stripUnit=__webpack_require__(108);var _stripUnit2=_interopRequireDefault(_stripUnit);var _clearFix=__webpack_require__(241);var _clearFix2=_interopRequireDefault(_clearFix);var _ellipsis=__webpack_require__(242);var _ellipsis2=_interopRequireDefault(_ellipsis);var _fontFace=__webpack_require__(243);var _fontFace2=_interopRequireDefault(_fontFace);var _hideText=__webpack_require__(244);var _hideText2=_interopRequireDefault(_hideText);var _hideVisually=__webpack_require__(245);var _hideVisually2=_interopRequireDefault(_hideVisually);var _hiDPI=__webpack_require__(164);var _hiDPI2=_interopRequireDefault(_hiDPI);var _normalize=__webpack_require__(246);var _normalize2=_interopRequireDefault(_normalize);var _placeholder=__webpack_require__(247);var _placeholder2=_interopRequireDefault(_placeholder);var _radialGradient=__webpack_require__(248);var _radialGradient2=_interopRequireDefault(_radialGradient);var _retinaImage=__webpack_require__(249);var _retinaImage2=_interopRequireDefault(_retinaImage);var _selection=__webpack_require__(250);var _selection2=_interopRequireDefault(_selection);var _timingFunctions=__webpack_require__(251);var _timingFunctions2=_interopRequireDefault(_timingFunctions);var _triangle=__webpack_require__(252);var _triangle2=_interopRequireDefault(_triangle);var _wordWrap=__webpack_require__(253);var _wordWrap2=_interopRequireDefault(_wordWrap);var _adjustHue=__webpack_require__(254);var _adjustHue2=_interopRequireDefault(_adjustHue);var _complement=__webpack_require__(257);var _complement2=_interopRequireDefault(_complement);var _darken=__webpack_require__(258);var _darken2=_interopRequireDefault(_darken);var _desaturate=__webpack_require__(259);var _desaturate2=_interopRequireDefault(_desaturate);var _getLuminance=__webpack_require__(170);var _getLuminance2=_interopRequireDefault(_getLuminance);var _grayscale=__webpack_require__(260);var _grayscale2=_interopRequireDefault(_grayscale);var _hsl=__webpack_require__(167);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(169);var _hsla2=_interopRequireDefault(_hsla);var _invert=__webpack_require__(261);var _invert2=_interopRequireDefault(_invert);var _lighten=__webpack_require__(262);var _lighten2=_interopRequireDefault(_lighten);var _mix=__webpack_require__(111);var _mix2=_interopRequireDefault(_mix);var _opacify=__webpack_require__(263);var _opacify2=_interopRequireDefault(_opacify);var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _readableColor=__webpack_require__(264);var _readableColor2=_interopRequireDefault(_readableColor);var _rgb=__webpack_require__(110);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(69);var _rgba2=_interopRequireDefault(_rgba);var _saturate=__webpack_require__(265);var _saturate2=_interopRequireDefault(_saturate);var _setHue=__webpack_require__(266);var _setHue2=_interopRequireDefault(_setHue);var _setLightness=__webpack_require__(267);var _setLightness2=_interopRequireDefault(_setLightness);var _setSaturation=__webpack_require__(268);var _setSaturation2=_interopRequireDefault(_setSaturation);var _shade=__webpack_require__(269);var _shade2=_interopRequireDefault(_shade);var _tint=__webpack_require__(270);var _tint2=_interopRequireDefault(_tint);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _transparentize=__webpack_require__(271);var _transparentize2=_interopRequireDefault(_transparentize);var _animation=__webpack_require__(272);var _animation2=_interopRequireDefault(_animation);var _backgroundImages=__webpack_require__(273);var _backgroundImages2=_interopRequireDefault(_backgroundImages);var _backgrounds=__webpack_require__(274);var _backgrounds2=_interopRequireDefault(_backgrounds);var _borderColor=__webpack_require__(275);var _borderColor2=_interopRequireDefault(_borderColor);var _borderRadius=__webpack_require__(276);var _borderRadius2=_interopRequireDefault(_borderRadius);var _borderStyle=__webpack_require__(277);var _borderStyle2=_interopRequireDefault(_borderStyle);var _borderWidth=__webpack_require__(278);var _borderWidth2=_interopRequireDefault(_borderWidth);var _buttons=__webpack_require__(279);var _buttons2=_interopRequireDefault(_buttons);var _margin=__webpack_require__(280);var _margin2=_interopRequireDefault(_margin);var _padding=__webpack_require__(281);var _padding2=_interopRequireDefault(_padding);var _position=__webpack_require__(282);var _position2=_interopRequireDefault(_position);var _size=__webpack_require__(283);var _size2=_interopRequireDefault(_size);var _textInputs=__webpack_require__(284);var _textInputs2=_interopRequireDefault(_textInputs);var _transitions=__webpack_require__(285);var _transitions2=_interopRequireDefault(_transitions);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}exports.adjustHue=_adjustHue2.default;exports.animation=_animation2.default;exports.backgroundImages=_backgroundImages2.default;exports.backgrounds=_backgrounds2.default;exports.borderColor=_borderColor2.default;exports.borderRadius=_borderRadius2.default;exports.borderStyle=_borderStyle2.default;exports.borderWidth=_borderWidth2.default;exports.buttons=_buttons2.default;exports.clearFix=_clearFix2.default;exports.complement=_complement2.default;exports.darken=_darken2.default;exports.desaturate=_desaturate2.default;exports.directionalProperty=_directionalProperty2.default;exports.ellipsis=_ellipsis2.default;exports.em=_em2.default;exports.fontFace=_fontFace2.default;exports.getLuminance=_getLuminance2.default;exports.grayscale=_grayscale2.default;exports.invert=_invert2.default;exports.hideText=_hideText2.default;exports.hideVisually=_hideVisually2.default;exports.hiDPI=_hiDPI2.default;exports.hsl=_hsl2.default;exports.hsla=_hsla2.default;exports.lighten=_lighten2.default;exports.margin=_margin2.default;exports.mix=_mix2.default;exports.modularScale=_modularScale2.default;exports.normalize=_normalize2.default;exports.opacify=_opacify2.default;exports.padding=_padding2.default;exports.parseToHsl=_parseToHsl2.default;exports.parseToRgb=_parseToRgb2.default;exports.placeholder=_placeholder2.default;exports.position=_position2.default;exports.radialGradient=_radialGradient2.default;exports.readableColor=_readableColor2.default;exports.rem=_rem2.default;exports.retinaImage=_retinaImage2.default;exports.rgb=_rgb2.default;exports.rgba=_rgba2.default;exports.saturate=_saturate2.default;exports.selection=_selection2.default;exports.setHue=_setHue2.default;exports.setLightness=_setLightness2.default;exports.setSaturation=_setSaturation2.default;exports.shade=_shade2.default;exports.size=_size2.default;exports.stripUnit=_stripUnit2.default;exports.textInputs=_textInputs2.default;exports.timingFunctions=_timingFunctions2.default;exports.tint=_tint2.default;exports.toColorString=_toColorString2.default;exports.transitions=_transitions2.default;exports.transparentize=_transparentize2.default;exports.triangle=_triangle2.default;exports.wordWrap=_wordWrap2.default},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function capitalizeString(string){return string.charAt(0).toUpperCase()+string.slice(1)}exports.default=capitalizeString;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _endsWith=__webpack_require__(238);var _endsWith2=_interopRequireDefault(_endsWith);var _stripUnit=__webpack_require__(108);var _stripUnit2=_interopRequireDefault(_stripUnit);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var pxtoFactory=function pxtoFactory(to){return function(pxval){var base=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"16px";var newPxval=pxval;var newBase=base;if(typeof pxval==="string"){if(!(0,_endsWith2.default)(pxval,"px")){throw new Error('Expected a string ending in "px" or a number passed as the first argument to '+to+'(), got "'+pxval+'" instead.')}newPxval=(0,_stripUnit2.default)(pxval)}if(typeof base==="string"){if(!(0,_endsWith2.default)(base,"px")){throw new Error('Expected a string ending in "px" or a number passed as the second argument to '+to+'(), got "'+base+'" instead.')}newBase=(0,_stripUnit2.default)(base)}if(typeof newPxval==="string"){throw new Error('Passed invalid pixel value ("'+pxval+'") to '+to+'(), please pass a value like "12px" or 12.')}if(typeof newBase==="string"){throw new Error('Passed invalid base value ("'+base+'") to '+to+'(), please pass a value like "12px" or 12.')}return""+newPxval/newBase+to}};exports.default=pxtoFactory;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hiDPI(){var ratio=arguments.length>0&&arguments[0]!==undefined?arguments[0]:1.3;return"\n    @media only screen and (-webkit-min-device-pixel-ratio: "+ratio+"),\n    only screen and (min--moz-device-pixel-ratio: "+ratio+"),\n    only screen and (-o-min-device-pixel-ratio: "+ratio+"/1),\n    only screen and (min-resolution: "+Math.round(ratio*96)+"dpi),\n    only screen and (min-resolution: "+ratio+"dppx)\n  "}exports.default=hiDPI;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var reduceHexValue=function reduceHexValue(value){if(value.length===7&&value[1]===value[2]&&value[3]===value[4]&&value[5]===value[6]){return"#"+value[1]+value[3]+value[5]}return value};exports.default=reduceHexValue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function numberToHex(value){var hex=value.toString(16);return hex.length===1?"0"+hex:hex}exports.default=numberToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToHex=__webpack_require__(168);var _hslToHex2=_interopRequireDefault(_hslToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function hsl(value,saturation,lightness){if(typeof value==="number"&&typeof saturation==="number"&&typeof lightness==="number"){return(0,_hslToHex2.default)(value,saturation,lightness)}else if(typeof value==="object"&&saturation===undefined&&lightness===undefined){return(0,_hslToHex2.default)(value.hue,value.saturation,value.lightness)}throw new Error("Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).")}exports.default=hsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(109);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _reduceHexValue=__webpack_require__(165);var _reduceHexValue2=_interopRequireDefault(_reduceHexValue);var _numberToHex=__webpack_require__(166);var _numberToHex2=_interopRequireDefault(_numberToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function colorToHex(color){return(0,_numberToHex2.default)(Math.round(color*255))}function convertToHex(red,green,blue){return(0,_reduceHexValue2.default)("#"+colorToHex(red)+colorToHex(green)+colorToHex(blue))}function hslToHex(hue,saturation,lightness){return(0,_hslToRgb2.default)(hue,saturation,lightness,convertToHex)}exports.default=hslToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToHex=__webpack_require__(168);var _hslToHex2=_interopRequireDefault(_hslToHex);var _hslToRgb=__webpack_require__(109);var _hslToRgb2=_interopRequireDefault(_hslToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function hsla(value,saturation,lightness,alpha){if(typeof value==="number"&&typeof saturation==="number"&&typeof lightness==="number"&&typeof alpha==="number"){return alpha>=1?(0,_hslToHex2.default)(value,saturation,lightness):"rgba("+(0,_hslToRgb2.default)(value,saturation,lightness)+","+alpha+")"}else if(typeof value==="object"&&saturation===undefined&&lightness===undefined&&alpha===undefined){return value.alpha>=1?(0,_hslToHex2.default)(value.hue,value.saturation,value.lightness):"rgba("+(0,_hslToRgb2.default)(value.hue,value.saturation,value.lightness)+","+value.alpha+")"}throw new Error("Passed invalid arguments to hsla, please pass multiple numbers e.g. hsl(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).")}exports.default=hsla;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getLuminance(color){var rgbColor=(0,_parseToRgb2.default)(color);var _Object$keys$map=Object.keys(rgbColor).map((function(key){var channel=rgbColor[key]/255;return channel<=.03928?channel/12.92:Math.pow((channel+.055)/1.055,2.4)})),r=_Object$keys$map[0],g=_Object$keys$map[1],b=_Object$keys$map[2];return.2126*r+.7152*g+.0722*b}exports.default=getLuminance;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function generateSelectors(template,state){var stateSuffix=state?":"+state:"";return template(stateSuffix)}function statefulSelectors(states,template,stateMap){if(!template)throw new Error("You must provide a template to this method.");if(states.length===0)return generateSelectors(template,null);var selectors=[];for(var i=0;i<states.length;i+=1){if(stateMap&&stateMap.indexOf(states[i])<0){throw new Error("You passed an unsupported selector state to this method.")}selectors.push(generateSelectors(template,states[i]))}selectors=selectors.join(",");return selectors}exports.default=statefulSelectors;module.exports=exports["default"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return EmptyState}));__webpack_require__.d(__webpack_exports__,"b",(function(){return filter_group["a"]}));__webpack_require__.d(__webpack_exports__,"c",(function(){return KueryBar}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ParsingErrorCallout}));var monitor_list=__webpack_require__(101);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const EmptyStateError=({errors:errors})=>{const unauthorized=errors.find(error=>error.message&&error.message.includes("unauthorized"));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",iconColor:"subdued",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},unauthorized?external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.emptyStateError.notAuthorized",{defaultMessage:"You are not authorized to view Uptime data, please contact your system administrator."})):external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.emptyStateError.title",{defaultMessage:"Error"}))),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,!unauthorized&&errors.map(error=>external_kbnSharedDeps_React_default.a.createElement("p",{key:error.body.message||error.message},error.body.message||error.message)))}))))};const EmptyStateLoading=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.emptyState.loadingMessage",{defaultMessage:"Loading…"}))))});var contexts=__webpack_require__(36);const DataOrIndexMissing=({headingMessage:headingMessage,settings:settings})=>{const{basePath:basePath}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["c"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center","data-test-subj":"data-missing"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{flexBasis:700}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"logoUptime",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h3",null,headingMessage)),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.emptyState.configureHeartbeatToGetStartedMessage",defaultMessage:"If you have not setup heartbeat yet, you can setup heartbeat to start monitoring your services."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.emptyState.configureHeartbeatIndexSettings",defaultMessage:"If you have setup heartbeat and confirmed data is being sent to Elasticsearch, update your index pattern settings and insure they are aligned with your Heartbeat config."}))),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,color:"primary",href:`${basePath}/app/home#/tutorial/uptimeMonitors`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.emptyState.viewSetupInstructions",defaultMessage:"View setup instructions"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",href:`${basePath}/app/uptime/settings`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.emptyState.updateIndexPattern",defaultMessage:"Update index pattern settings"}))))}))))};const EmptyStateComponent=({children:children,statesIndexStatus:statesIndexStatus,loading:loading,errors:errors,settings:settings})=>{if(errors!==null&&errors!==void 0&&errors.length){return external_kbnSharedDeps_React_default.a.createElement(EmptyStateError,{errors:errors})}const{indexExists:indexExists,docCount:docCount}=statesIndexStatus!==null&&statesIndexStatus!==void 0?statesIndexStatus:{};if(loading&&(!indexExists||docCount===0||!statesIndexStatus)){return external_kbnSharedDeps_React_default.a.createElement(EmptyStateLoading,null)}if(!indexExists){return external_kbnSharedDeps_React_default.a.createElement(DataOrIndexMissing,{settings:settings,headingMessage:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.emptyState.noIndexTitle",defaultMessage:"No indices found matching pattern {indexName}",values:{indexName:external_kbnSharedDeps_React_default.a.createElement("em",null,settings===null||settings===void 0?void 0:settings.heartbeatIndices)}})})}else if(indexExists&&docCount===0){return external_kbnSharedDeps_React_default.a.createElement(DataOrIndexMissing,{settings:settings,headingMessage:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.emptyState.noDataMessage",defaultMessage:"No uptime data found in index {indexName}",values:{indexName:external_kbnSharedDeps_React_default.a.createElement("em",null,settings===null||settings===void 0?void 0:settings.heartbeatIndices)}})})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children)};var lib=__webpack_require__(32);var actions=__webpack_require__(33);var selectors=__webpack_require__(37);var dynamic_settings=__webpack_require__(55);const EmptyState=({children:children})=>{const{data:data,loading:loading,error:error}=Object(lib["useSelector"])(selectors["h"]);const{lastRefresh:lastRefresh}=Object(external_kbnSharedDeps_React_["useContext"])(contexts["a"]);const{settings:settings}=Object(lib["useSelector"])(selectors["A"]);const heartbeatIndices=(settings===null||settings===void 0?void 0:settings.heartbeatIndices)||"";const dispatch=Object(lib["useDispatch"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!data||(data===null||data===void 0?void 0:data.docCount)===0||(data===null||data===void 0?void 0:data.indexExists)===false){dispatch(actions["E"].get())}},[dispatch,lastRefresh]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(actions["E"].get())},[dispatch,heartbeatIndices]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch(Object(dynamic_settings["a"])())},[dispatch]);return external_kbnSharedDeps_React_default.a.createElement(EmptyStateComponent,{statesIndexStatus:data,loading:loading,errors:error?[error]:undefined,children:children,settings:settings})};var filter_group=__webpack_require__(116);var alerts=__webpack_require__(71);var snapshot=__webpack_require__(119);var snapshot_container=__webpack_require__(107);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(12);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_Lodash_=__webpack_require__(22);var polished_lib=__webpack_require__(161);var common_=__webpack_require__(18);const SuggestionItem=common_["euiStyled"].div`
  background: ${props=>props.selected?props.theme.eui.euiColorLightestShade:"initial"};
`;function getIconColor(type){switch(type){case"field":return"tint5";case"value":return"tint0";case"operator":return"tint1";case"conjunction":return"tint3";case"recentSearch":return"tint10";default:return"tint5"}}function getEuiIconType(type){switch(type){case"field":return"kqlField";case"value":return"kqlValue";case"recentSearch":return"search";case"conjunction":return"kqlSelector";case"operator":return"kqlOperand";default:throw new Error(`Unknown type ${type}`)}}const Suggestion=({innerRef:innerRef,selected:selected,suggestion:suggestion,onClick:onClick,onMouseEnter:onMouseEnter})=>{const childNode=Object(external_kbnSharedDeps_React_["useRef"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(childNode.current){innerRef(childNode.current)}},[childNode]);return external_kbnSharedDeps_React_default.a.createElement(SuggestionItem,{ref:childNode,selected:selected},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuggestItem"],{type:{iconType:getEuiIconType(suggestion.type),color:getIconColor(suggestion.type)},label:suggestion.text,onClick:()=>onClick(suggestion),onMouseEnter:onMouseEnter,description:suggestion.description}))};const unit=16;const units={unit:unit,eighth:unit/8,quarter:unit/4,half:unit/2,minus:unit*.75,plus:unit*1.5,double:unit*2,triple:unit*3,quadruple:unit*4};function px(value){return`${value}px`}const List=common_["euiStyled"].ul`
  width: 100%;
  border: 1px solid ${props=>props.theme.eui.euiColorLightShade};
  border-radius: ${px(units.quarter)};
  background-color: ${props=>props.theme.eui.euiColorEmptyShade};
  z-index: 10;
  max-height: ${px(unit*20)};
  overflow: auto;
  position: absolute;

  &::-webkit-scrollbar {
    height: ${({theme:theme})=>theme.eui.euiScrollBar};
    width: ${({theme:theme})=>theme.eui.euiScrollBar};
  }

  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({theme:theme})=>Object(polished_lib["rgba"])(theme.eui.euiColorDarkShade,.5)};
    border: ${({theme:theme})=>theme.eui.euiScrollBarCorner} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;const Suggestions=({show:show,index:index,onClick:onClick,suggestions:suggestions,onMouseEnter:onMouseEnter,loadMore:loadMore})=>{const[childNodes,setChildNodes]=Object(external_kbnSharedDeps_React_["useState"])([]);const parentNode=Object(external_kbnSharedDeps_React_["useRef"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const scrollIntoView=()=>{const parent=parentNode.current;const child=childNodes[index];if(index==null||!parent||!child){return}const scrollTop=Math.max(Math.min(parent.scrollTop,child.offsetTop),child.offsetTop+child.offsetHeight-parent.offsetHeight);parent.scrollTop=scrollTop};scrollIntoView()},[index,childNodes]);if(!show||Object(external_kbnSharedDeps_Lodash_["isEmpty"])(suggestions)){return null}const handleScroll=()=>{const parent=parentNode.current;if(!loadMore||!parent){return}const position=parent.scrollTop+parent.offsetHeight;const height=parent.scrollHeight;const remaining=height-position;const margin=50;if(!height||!position){return}if(remaining<=margin){loadMore()}};const suggestionsNodes=suggestions.map((suggestion,currIndex)=>{const key=suggestion+"_"+currIndex;return external_kbnSharedDeps_React_default.a.createElement(Suggestion,{innerRef:node=>{const nodes=childNodes;nodes[currIndex]=node;setChildNodes([...nodes])},selected:currIndex===index,suggestion:suggestion,onClick:onClick,onMouseEnter:()=>onMouseEnter(currIndex),key:key})});return external_kbnSharedDeps_React_default.a.createElement(List,{ref:parentNode,onScroll:handleScroll},suggestionsNodes)};const KEY_CODES={LEFT:37,UP:38,RIGHT:39,DOWN:40,ENTER:13,ESC:27,TAB:9};const Typeahead=({initialValue:initialValue,suggestions:suggestions,onChange:onChange,onSubmit:onSubmit,dataTestSubj:dataTestSubj,ariaLabel:ariaLabel,disabled:disabled,isLoading:isLoading,loadMore:loadMore})=>{const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({isSuggestionsVisible:false,index:null,value:"",inputIsPristine:true,lastSubmitted:"",selected:null});const inputRef=Object(external_kbnSharedDeps_React_["useRef"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(state.inputIsPristine&&initialValue){setState(prevState=>({...prevState,value:initialValue}))}},[initialValue]);const incrementIndex=currentIndex=>{let nextIndex=currentIndex+1;if(currentIndex===null||nextIndex>=suggestions.length){nextIndex=0}setState(prevState=>({...prevState,index:nextIndex}))};const decrementIndex=currentIndex=>{let previousIndex=currentIndex-1;if(previousIndex<0){previousIndex=null}setState(prevState=>({...prevState,index:previousIndex}))};const onKeyUp=event=>{const{selectionStart:selectionStart}=event.target;const{value:value}=state;switch(event.keyCode){case KEY_CODES.LEFT:setState(prevState=>({...prevState,isSuggestionsVisible:true}));onChange(value,selectionStart);break;case KEY_CODES.RIGHT:setState(prevState=>({...prevState,isSuggestionsVisible:true}));onChange(value,selectionStart);break}};const onKeyDown=event=>{const{isSuggestionsVisible:isSuggestionsVisible,index:index,value:value}=state;switch(event.keyCode){case KEY_CODES.DOWN:event.preventDefault();if(isSuggestionsVisible){incrementIndex(index)}else{setState(prevState=>({...prevState,isSuggestionsVisible:true,index:0}))}break;case KEY_CODES.UP:event.preventDefault();if(isSuggestionsVisible){decrementIndex(index)}break;case KEY_CODES.ENTER:event.preventDefault();if(isSuggestionsVisible&&suggestions[index]){selectSuggestion(suggestions[index])}else{setState(prevState=>({...prevState,isSuggestionsVisible:false}));onSubmit(value)}break;case KEY_CODES.ESC:event.preventDefault();setState(prevState=>({...prevState,isSuggestionsVisible:false}));break;case KEY_CODES.TAB:setState(prevState=>({...prevState,isSuggestionsVisible:false}));break}};const selectSuggestion=suggestion=>{const nextInputValue=state.value.substr(0,suggestion.start)+suggestion.text+state.value.substr(suggestion.end);setState(prevState=>({...prevState,value:nextInputValue,index:null,selected:suggestion}));onChange(nextInputValue,nextInputValue.length)};const onClickOutside=()=>{if(state.isSuggestionsVisible){setState(prevState=>({...prevState,isSuggestionsVisible:false}));onSuggestionSubmit()}};const onChangeInputValue=event=>{const{value:value,selectionStart:selectionStart}=event.target;const hasValue=Boolean(value.trim());setState(prevState=>({...prevState,value:value,inputIsPristine:false,isSuggestionsVisible:hasValue,index:null}));if(!hasValue){onSubmit(value)}onChange(value,selectionStart)};const onClickInput=event=>{event.stopPropagation();const{selectionStart:selectionStart}=event.target;onChange(state.value,selectionStart)};const onFocus=()=>{setState(prevState=>({...prevState,isSuggestionsVisible:true}))};const onClickSuggestion=suggestion=>{selectSuggestion(suggestion);if(inputRef.current)inputRef.current.focus()};const onMouseEnterSuggestion=index=>{setState(prevState=>({...prevState,index:index}))};const onSuggestionSubmit=()=>{const{value:value,lastSubmitted:lastSubmitted,selected:selected}=state;if(lastSubmitted!==value&&selected&&(selected.type==="value"||selected.text.trim()===": *")){onSubmit(value);setState(prevState=>({...prevState,lastSubmitted:value,selected:null}))}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiOutsideClickDetector"],{onOutsideClick:onClickOutside},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":dataTestSubj,style:{position:"relative"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{"aria-label":ariaLabel,fullWidth:true,style:{backgroundImage:"none"},placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.kueryBar.searchPlaceholder",{defaultMessage:"Search monitor IDs, names, and protocol types..."}),inputRef:node=>{if(node){inputRef.current=node}},disabled:disabled,value:state.value,onKeyDown:onKeyDown,onKeyUp:onKeyUp,onFocus:onFocus,onChange:onChangeInputValue,onClick:onClickInput,autoComplete:"off",spellCheck:false}),isLoading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{size:"xs",color:"accent",position:"absolute",style:{bottom:0,top:"initial"}})),external_kbnSharedDeps_React_default.a.createElement(Suggestions,{show:state.isSuggestionsVisible,suggestions:suggestions,index:state.index,onClick:onClickSuggestion,onMouseEnter:onMouseEnterSuggestion,loadMore:loadMore})))};var public_=__webpack_require__(14);var hooks=__webpack_require__(35);var data_public_=__webpack_require__(23);var use_index_pattern=__webpack_require__(160);const Container=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Container",componentId:"sc-1us6ope-0"})(["margin-bottom:4px;position:relative;"]);function convertKueryToEsQuery(kuery,indexPattern){const ast=data_public_["esKuery"].fromKueryExpression(kuery);return data_public_["esKuery"].toElasticsearchQuery(ast,indexPattern)}function KueryBar({"aria-label":ariaLabel,defaultKuery:defaultKuery,"data-test-subj":dataTestSubj,shouldUpdateUrl:shouldUpdateUrl,updateDefaultKuery:updateDefaultKuery}){const{loading:loading,index_pattern:indexPattern}=Object(use_index_pattern["a"])();const{updateSearchText:updateSearchText}=Object(hooks["e"])();const{services:{data:{autocomplete:autocomplete}}}=Object(public_["useKibana"])();const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({suggestions:[],isLoadingIndexPattern:true});const[suggestionLimit,setSuggestionLimit]=Object(external_kbnSharedDeps_React_["useState"])(15);const[isLoadingSuggestions,setIsLoadingSuggestions]=Object(external_kbnSharedDeps_React_["useState"])(false);let currentRequestCheck;const[getUrlParams,updateUrlParams]=Object(hooks["h"])();const{search:kuery}=getUrlParams();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{updateSearchText(kuery)},[kuery,updateSearchText]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(updateDefaultKuery&&kuery){updateDefaultKuery(kuery)}else if(defaultKuery&&updateDefaultKuery){updateDefaultKuery(defaultKuery)}},[]);const indexPatternMissing=loading&&!indexPattern;async function onChange(inputValue,selectionStart){if(!indexPattern){return}setIsLoadingSuggestions(true);setState({...state,suggestions:[]});setSuggestionLimit(15);const currentRequest=Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])()();currentRequestCheck=currentRequest;try{const suggestions=(await autocomplete.getQuerySuggestions({language:"kuery",indexPatterns:[indexPattern],query:inputValue,selectionStart:selectionStart||0,selectionEnd:selectionStart||0,useTimeRange:true})||[]).filter(suggestion=>!suggestion.text.startsWith("span."));if(currentRequest!==currentRequestCheck){return}setIsLoadingSuggestions(false);setState({...state,suggestions:suggestions})}catch(e){console.error("Error while fetching suggestions",e)}}function onSubmit(inputValue){if(indexPattern===null){return}try{const res=convertKueryToEsQuery(inputValue,indexPattern);if(!res){return}if(shouldUpdateUrl!==false){updateUrlParams({search:inputValue.trim()})}updateSearchText(inputValue);if(updateDefaultKuery){updateDefaultKuery(inputValue)}}catch(e){console.log("Invalid kuery syntax")}}const increaseLimit=()=>{setSuggestionLimit(suggestionLimit+15)};return external_kbnSharedDeps_React_default.a.createElement(Container,null,external_kbnSharedDeps_React_default.a.createElement(Typeahead,{ariaLabel:ariaLabel,dataTestSubj:dataTestSubj,disabled:indexPatternMissing,isLoading:isLoadingSuggestions||loading,initialValue:defaultKuery||kuery,onChange:onChange,onSubmit:onSubmit,suggestions:state.suggestions.slice(0,suggestionLimit),loadMore:increaseLimit,queryExample:""}),indexPatternMissing&&!loading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{style:{display:"inline-block",marginTop:"10px"},title:external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.kueryBar.indexPatternMissingWarningMessage",defaultMessage:"There was an error retrieving the index pattern."})),color:"warning",iconType:"alert",size:"s"}))}const ParsingErrorCallout=({error:error})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overviewPageParsingErrorCallout.title",{defaultMessage:"Parsing error"}),color:"danger",iconType:"alert",style:{width:"100%"}},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.overviewPageParsingErrorCallout.content",defaultMessage:"There was an error parsing the filter query. {content}",values:{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],null,error.message?error.message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overviewPageParsingErrorCallout.noMessage",{defaultMessage:"There was no error message"}))}})))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return FilterPopover}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const UptimeFilterButton=({isDisabled:isDisabled,isSelected:isSelected,numFilters:numFilters,numActiveFilters:numActiveFilters,onClick:onClick,title:title})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.overview.filterButton.label",{defaultMessage:"expands filter group for {title} filter",values:{title:title}}),hasActiveFilters:numActiveFilters!==0,iconType:"arrowDown",isDisabled:isDisabled,isSelected:isSelected,numActiveFilters:numActiveFilters,numFilters:numFilters,onClick:onClick},title);const toggleSelectedItems=(item,tempSelectedItems,setTempSelectedItems)=>{const index=tempSelectedItems.indexOf(item);const nextSelectedItems=[...tempSelectedItems];if(index>=0){nextSelectedItems.splice(index,1)}else{nextSelectedItems.push(item)}setTempSelectedItems(nextSelectedItems)};var monitor_list=__webpack_require__(101);const isItemSelected=(selectedItems,item)=>selectedItems.find(selected=>selected===item)?"on":undefined;const FilterPopover=({fieldName:fieldName,id:id,disabled:disabled,loading:loading,items:allItems,onFilterFieldChange:onFilterFieldChange,selectedItems:selectedItems,title:title,btnContent:btnContent,forceOpen:forceOpen,setForceOpen:setForceOpen})=>{const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[itemsToDisplay,setItemsToDisplay]=Object(external_kbnSharedDeps_React_["useState"])([]);const[searchQuery,setSearchQuery]=Object(external_kbnSharedDeps_React_["useState"])("");const[tempSelectedItems,setTempSelectedItems]=Object(external_kbnSharedDeps_React_["useState"])(selectedItems);const[items,setItems]=Object(external_kbnSharedDeps_React_["useState"])([]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const mItems=selectedItems.concat(allItems!==null&&allItems!==void 0?allItems:[]);const newItems=mItems.filter((item,index)=>mItems.indexOf(item)===index);setItems(newItems);setTempSelectedItems(selectedItems)},[allItems,selectedItems]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(searchQuery!==""){const toDisplay=items.filter(item=>item.indexOf(searchQuery)>=0);setItemsToDisplay(toDisplay)}else{setItemsToDisplay(items)}},[searchQuery,items]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:btnContent!==null&&btnContent!==void 0?btnContent:external_kbnSharedDeps_React_default.a.createElement(UptimeFilterButton,{isDisabled:disabled&&selectedItems.length===0,isSelected:tempSelectedItems.length>0,numFilters:items.length,numActiveFilters:isOpen?tempSelectedItems.length:selectedItems.length,onClick:()=>{if(isOpen){onFilterFieldChange(fieldName,tempSelectedItems)}setIsOpen(!isOpen)},title:title}),closePopover:()=>{setIsOpen(false);onFilterFieldChange(fieldName,tempSelectedItems);if(setForceOpen){setForceOpen(false)}},"data-test-subj":`filter-popover_${id}`,id:id,isOpen:isOpen||forceOpen,ownFocus:true,zIndex:1e4},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{incremental:true,disabled:items.length===0,onSearch:query=>setSearchQuery(query),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.filterPopout.searchMessage.ariaLabel",{defaultMessage:"Search for {title}",values:{title:title.toLowerCase()}}),placeholder:loading?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.filterPopout.loadingMessage",{defaultMessage:"Loading..."}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.filterPopout.searchMessage",{defaultMessage:"Search {title}",values:{title:title.toLowerCase()}})})),!loading&&itemsToDisplay.map(item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.filterPopover.filterItem.label",{defaultMessage:"Filter by {title} {item}.",values:{item:item,title:title}}),checked:isItemSelected(tempSelectedItems,item),"data-test-subj":`filter-popover-item_${item}`,key:item,onClick:()=>toggleSelectedItems(item,tempSelectedItems,setTempSelectedItems)},item)),id==="location"&&items.length===0&&external_kbnSharedDeps_React_default.a.createElement(monitor_list["a"],null))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return ReactRouterEuiLink}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ReactRouterEuiButton}));const letBrowserHandleEvent=event=>event.defaultPrevented||isModifiedEvent(event)||!isLeftClickEvent(event)||isTargetBlank(event);const isModifiedEvent=event=>!!(event.metaKey||event.altKey||event.ctrlKey||event.shiftKey);const isLeftClickEvent=event=>event.button===0;const isTargetBlank=event=>{const element=event.target;const target=element.getAttribute("target");return!!target&&target!=="_self"};var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);const ReactRouterHelperForEui=({to:to,children:children})=>{const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const onClick=event=>{if(letBrowserHandleEvent(event))return;event.preventDefault();history.push(to)};const href=history.createHref({pathname:to});const reactRouterProps={href:href,onClick:onClick};return external_kbnSharedDeps_React_default.a.cloneElement(children,reactRouterProps)};const ReactRouterEuiLink=({to:to,...rest})=>external_kbnSharedDeps_React_default.a.createElement(ReactRouterHelperForEui,{to:to},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],rest));const ReactRouterEuiButton=({to:to,...rest})=>external_kbnSharedDeps_React_default.a.createElement(ReactRouterHelperForEui,{to:to},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],rest));const ReactRouterEuiButtonEmpty=({to:to,...rest})=>external_kbnSharedDeps_React_default.a.createElement(ReactRouterHelperForEui,{to:to},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],rest))},,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return EnableMonitorAlert}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(15);var lib=__webpack_require__(32);var selectors=__webpack_require__(37);var alerts_alerts=__webpack_require__(46);var constants=__webpack_require__(34);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(11);var react_router_helpers=__webpack_require__(174);var translations=__webpack_require__(105);const SETTINGS_LINK_TEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.page_header.settingsLink",{defaultMessage:"Settings"});const DefineAlertConnectors=()=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const onButtonClick=()=>setIsPopoverOpen(val=>!val);const closePopover=()=>setIsPopoverOpen(false);const isMonitorPage=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])(constants["m"]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{id:"defineAlertSettingsSwitch",label:translations["b"],showLabel:!!isMonitorPage,"aria-label":translations["b"],onChange:onButtonClick,checked:false,compressed:!isMonitorPage,"data-test-subj":"uptimeDisplayDefineConnector"}),isOpen:isPopoverOpen,closePopover:closePopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{style:{width:"350px"},"data-test-subj":"uptimeSettingsDefineConnector"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.uptime.monitorList.defineConnector.description",defaultMessage:"To start enabling alerts, please define a default alert action connector in"})," ",external_kbnSharedDeps_React_default.a.createElement(react_router_helpers["b"],{to:constants["p"]+"?focusConnectorField=true","data-test-subj":"uptimeSettingsLink"},SETTINGS_LINK_TEXT)))};const EnableMonitorAlert=({monitorId:monitorId,monitorName:monitorName})=>{var _alerts$data,_hasAlert,_settings$defaultConn2;const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const{settings:settings}=Object(lib["useSelector"])(selectors["A"]);const isMonitorPage=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])(constants["m"]);const dispatch=Object(lib["useDispatch"])();const{data:actionConnectors}=Object(lib["useSelector"])(alerts_alerts["d"]);const{data:alerts,loading:alertsLoading}=Object(lib["useSelector"])(alerts_alerts["b"]);const{data:deletedAlertId}=Object(lib["useSelector"])(alerts_alerts["l"]);const{data:newAlert,error:newAlertError}=Object(lib["useSelector"])(alerts_alerts["n"]);const isNewAlert=newAlert===null||newAlert===void 0?void 0:newAlert.params.search.includes(monitorId);let hasAlert=((_alerts$data=alerts===null||alerts===void 0?void 0:alerts.data)!==null&&_alerts$data!==void 0?_alerts$data:[]).find(alert=>alert.params.search.includes(monitorId));if(isNewAlert){hasAlert=newAlert}if(deletedAlertId===((_hasAlert=hasAlert)===null||_hasAlert===void 0?void 0:_hasAlert.id)){hasAlert=undefined}const defaultActions=(actionConnectors!==null&&actionConnectors!==void 0?actionConnectors:[]).filter(act=>{var _settings$defaultConn;return settings===null||settings===void 0?void 0:(_settings$defaultConn=settings.defaultConnectors)===null||_settings$defaultConn===void 0?void 0:_settings$defaultConn.includes(act.id)});const enableAlert=()=>{dispatch(alerts_alerts["e"].get({defaultActions:defaultActions,monitorId:monitorId,monitorName:monitorName}));setIsLoading(true)};const disableAlert=()=>{if(hasAlert){dispatch(alerts_alerts["f"].get({alertId:hasAlert.id}));setIsLoading(true)}};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setIsLoading(false)},[hasAlert,deletedAlertId,newAlertError]);const hasDefaultConnectors=((_settings$defaultConn2=settings===null||settings===void 0?void 0:settings.defaultConnectors)!==null&&_settings$defaultConn2!==void 0?_settings$defaultConn2:[]).length>0;const showSpinner=isLoading||alertsLoading&&!alerts;const onAlertClick=()=>{if(hasAlert){disableAlert()}else{enableAlert()}};const btnLabel=hasAlert?translations["a"]:translations["b"];return hasDefaultConnectors||hasAlert?external_kbnSharedDeps_React_default.a.createElement("div",{className:"eui-displayInlineBlock",style:{marginRight:10}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:btnLabel},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{id:"enableDisableAlertSwitch",compressed:!isMonitorPage,disabled:showSpinner,label:btnLabel,showLabel:!!isMonitorPage,"aria-label":btnLabel,onChange:onAlertClick,checked:!!hasAlert,"data-test-subj":hasAlert?"uptimeDisableSimpleDownAlert"+monitorId:"uptimeEnableSimpleDownAlert"+monitorId})," ",showSpinner&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{className:"eui-alignMiddle"})))):external_kbnSharedDeps_React_default.a.createElement(DefineAlertConnectors,null)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return StatusFilter}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var hooks=__webpack_require__(35);const FilterStatusButton=({content:content,dataTestSubj:dataTestSubj,isDisabled:isDisabled,isActive:isActive,value:value,withNext:withNext})=>{const[getUrlParams,setUrlParams]=Object(hooks["h"])();const{statusFilter:urlValue}=getUrlParams();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{"data-test-subj":dataTestSubj,hasActiveFilters:isActive,isDisabled:isDisabled,onClick:()=>{const nextFilter={statusFilter:urlValue===value?"":value,pagination:""};setUrlParams(nextFilter)},withNext:withNext},content)};var translations=__webpack_require__(50);const StatusFilter=()=>{const{statusFilter:statusFilter}=Object(hooks["c"])();const ALL="";return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(FilterStatusButton,{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.uptime.filterBar.filterAllLabel",{defaultMessage:"All"}),dataTestSubj:"xpack.uptime.filterBar.filterStatusAll",value:ALL,withNext:true,isActive:statusFilter===""}),external_kbnSharedDeps_React_default.a.createElement(FilterStatusButton,{content:translations["g"],dataTestSubj:"xpack.uptime.filterBar.filterStatusUp",value:"up",withNext:true,isActive:statusFilter==="up"}),external_kbnSharedDeps_React_default.a.createElement(FilterStatusButton,{content:translations["e"],dataTestSubj:"xpack.uptime.filterBar.filterStatusDown",value:"down",withNext:false,isActive:statusFilter==="down"}))}},,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";module.exports=str=>encodeURIComponent(str).replace(/[!'()*]/g,x=>`%${x.charCodeAt(0).toString(16).toUpperCase()}`)},function(module,exports,__webpack_require__){"use strict";var token="%[a-f0-9]{2}";var singleMatcher=new RegExp(token,"gi");var multiMatcher=new RegExp("("+token+")+","gi");function decodeComponents(components,split){try{return decodeURIComponent(components.join(""))}catch(err){}if(components.length===1){return components}split=split||1;var left=components.slice(0,split);var right=components.slice(split);return Array.prototype.concat.call([],decodeComponents(left),decodeComponents(right))}function decode(input){try{return decodeURIComponent(input)}catch(err){var tokens=input.match(singleMatcher);for(var i=1;i<tokens.length;i++){input=decodeComponents(tokens,i).join("");tokens=input.match(singleMatcher)}return input}}function customDecodeURIComponent(input){var replaceMap={"%FE%FF":"��","%FF%FE":"��"};var match=multiMatcher.exec(input);while(match){try{replaceMap[match[0]]=decodeURIComponent(match[0])}catch(err){var result=decode(match[0]);if(result!==match[0]){replaceMap[match[0]]=result}}match=multiMatcher.exec(input)}replaceMap["%C2"]="�";var entries=Object.keys(replaceMap);for(var i=0;i<entries.length;i++){var key=entries[i];input=input.replace(new RegExp(key,"g"),replaceMap[key])}return input}module.exports=function(encodedURI){if(typeof encodedURI!=="string"){throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof encodedURI+"`")}try{encodedURI=encodedURI.replace(/\+/g," ");return decodeURIComponent(encodedURI)}catch(err){return customDecodeURIComponent(encodedURI)}}},function(module,exports,__webpack_require__){"use strict";module.exports=(string,separator)=>{if(!(typeof string==="string"&&typeof separator==="string")){throw new TypeError("Expected the arguments to be of type `string`")}if(separator===""){return[string]}const separatorIndex=string.indexOf(separator);if(separatorIndex===-1){return[string]}return[string.slice(0,separatorIndex),string.slice(separatorIndex+separator.length)]}},function(module,exports,__webpack_require__){const moment=__webpack_require__(13);const unitsMap={ms:{weight:1,type:"fixed",base:1},s:{weight:2,type:"fixed",base:1e3},m:{weight:3,type:"mixed",base:1e3*60},h:{weight:4,type:"mixed",base:1e3*60*60},d:{weight:5,type:"mixed",base:1e3*60*60*24},w:{weight:6,type:"calendar",base:NaN},M:{weight:7,type:"calendar",base:NaN},y:{weight:9,type:"calendar",base:NaN}};const units=Object.keys(unitsMap).sort((a,b)=>unitsMap[b].weight-unitsMap[a].weight);const unitsDesc=[...units];const unitsAsc=[...units].reverse();const isDate=d=>Object.prototype.toString.call(d)==="[object Date]";const isValidDate=d=>isDate(d)&&!isNaN(d.valueOf());function parse(text,{roundUp:roundUp=false,momentInstance:momentInstance=moment,forceNow:forceNow}={}){if(!text)return undefined;if(momentInstance.isMoment(text))return text;if(isDate(text))return momentInstance(text);if(forceNow!==undefined&&!isValidDate(forceNow)){throw new Error("forceNow must be a valid Date")}let time;let mathString="";let index;let parseString;if(text.substring(0,3)==="now"){time=momentInstance(forceNow);mathString=text.substring("now".length)}else{index=text.indexOf("||");if(index===-1){parseString=text;mathString=""}else{parseString=text.substring(0,index);mathString=text.substring(index+2)}time=momentInstance(parseString)}if(!mathString.length){return time}return parseDateMath(mathString,time,roundUp)}function parseDateMath(mathString,time,roundUp){const dateTime=time;const len=mathString.length;let i=0;while(i<len){const c=mathString.charAt(i++);let type;let num;let unit;if(c==="/"){type=0}else if(c==="+"){type=1}else if(c==="-"){type=2}else{return}if(isNaN(mathString.charAt(i))){num=1}else if(mathString.length===2){num=mathString.charAt(i)}else{const numFrom=i;while(!isNaN(mathString.charAt(i))){i++;if(i>=len)return}num=parseInt(mathString.substring(numFrom,i),10)}if(type===0){if(num!==1){return}}unit=mathString.charAt(i++);for(let j=i;j<len;j++){const unitChar=mathString.charAt(i);if(/[a-z]/i.test(unitChar)){unit+=unitChar;i++}else{break}}if(units.indexOf(unit)===-1){return}else{if(type===0){if(roundUp)dateTime.endOf(unit);else dateTime.startOf(unit)}else if(type===1){dateTime.add(num,unit)}else if(type===2){dateTime.subtract(num,unit)}}}return dateTime}module.exports={parse:parse,unitsMap:Object.freeze(unitsMap),units:Object.freeze(units),unitsAsc:Object.freeze(unitsAsc),unitsDesc:Object.freeze(unitsDesc)}},,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";var punycode=__webpack_require__(225);var util=__webpack_require__(226);exports.parse=urlParse;exports.resolve=urlResolve;exports.resolveObject=urlResolveObject;exports.format=urlFormat;exports.Url=Url;function Url(){this.protocol=null;this.slashes=null;this.auth=null;this.host=null;this.port=null;this.hostname=null;this.hash=null;this.search=null;this.query=null;this.pathname=null;this.path=null;this.href=null}var protocolPattern=/^([a-z0-9.+-]+:)/i,portPattern=/:[0-9]*$/,simplePathPattern=/^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,delims=["<",">",'"',"`"," ","\r","\n","\t"],unwise=["{","}","|","\\","^","`"].concat(delims),autoEscape=["'"].concat(unwise),nonHostChars=["%","/","?",";","#"].concat(autoEscape),hostEndingChars=["/","?","#"],hostnameMaxLen=255,hostnamePartPattern=/^[+a-z0-9A-Z_-]{0,63}$/,hostnamePartStart=/^([+a-z0-9A-Z_-]{0,63})(.*)$/,unsafeProtocol={javascript:true,"javascript:":true},hostlessProtocol={javascript:true,"javascript:":true},slashedProtocol={http:true,https:true,ftp:true,gopher:true,file:true,"http:":true,"https:":true,"ftp:":true,"gopher:":true,"file:":true},querystring=__webpack_require__(227);function urlParse(url,parseQueryString,slashesDenoteHost){if(url&&util.isObject(url)&&url instanceof Url)return url;var u=new Url;u.parse(url,parseQueryString,slashesDenoteHost);return u}Url.prototype.parse=function(url,parseQueryString,slashesDenoteHost){if(!util.isString(url)){throw new TypeError("Parameter 'url' must be a string, not "+typeof url)}var queryIndex=url.indexOf("?"),splitter=queryIndex!==-1&&queryIndex<url.indexOf("#")?"?":"#",uSplit=url.split(splitter),slashRegex=/\\/g;uSplit[0]=uSplit[0].replace(slashRegex,"/");url=uSplit.join(splitter);var rest=url;rest=rest.trim();if(!slashesDenoteHost&&url.split("#").length===1){var simplePath=simplePathPattern.exec(rest);if(simplePath){this.path=rest;this.href=rest;this.pathname=simplePath[1];if(simplePath[2]){this.search=simplePath[2];if(parseQueryString){this.query=querystring.parse(this.search.substr(1))}else{this.query=this.search.substr(1)}}else if(parseQueryString){this.search="";this.query={}}return this}}var proto=protocolPattern.exec(rest);if(proto){proto=proto[0];var lowerProto=proto.toLowerCase();this.protocol=lowerProto;rest=rest.substr(proto.length)}if(slashesDenoteHost||proto||rest.match(/^\/\/[^@\/]+@[^@\/]+/)){var slashes=rest.substr(0,2)==="//";if(slashes&&!(proto&&hostlessProtocol[proto])){rest=rest.substr(2);this.slashes=true}}if(!hostlessProtocol[proto]&&(slashes||proto&&!slashedProtocol[proto])){var hostEnd=-1;for(var i=0;i<hostEndingChars.length;i++){var hec=rest.indexOf(hostEndingChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd))hostEnd=hec}var auth,atSign;if(hostEnd===-1){atSign=rest.lastIndexOf("@")}else{atSign=rest.lastIndexOf("@",hostEnd)}if(atSign!==-1){auth=rest.slice(0,atSign);rest=rest.slice(atSign+1);this.auth=decodeURIComponent(auth)}hostEnd=-1;for(var i=0;i<nonHostChars.length;i++){var hec=rest.indexOf(nonHostChars[i]);if(hec!==-1&&(hostEnd===-1||hec<hostEnd))hostEnd=hec}if(hostEnd===-1)hostEnd=rest.length;this.host=rest.slice(0,hostEnd);rest=rest.slice(hostEnd);this.parseHost();this.hostname=this.hostname||"";var ipv6Hostname=this.hostname[0]==="["&&this.hostname[this.hostname.length-1]==="]";if(!ipv6Hostname){var hostparts=this.hostname.split(/\./);for(var i=0,l=hostparts.length;i<l;i++){var part=hostparts[i];if(!part)continue;if(!part.match(hostnamePartPattern)){var newpart="";for(var j=0,k=part.length;j<k;j++){if(part.charCodeAt(j)>127){newpart+="x"}else{newpart+=part[j]}}if(!newpart.match(hostnamePartPattern)){var validParts=hostparts.slice(0,i);var notHost=hostparts.slice(i+1);var bit=part.match(hostnamePartStart);if(bit){validParts.push(bit[1]);notHost.unshift(bit[2])}if(notHost.length){rest="/"+notHost.join(".")+rest}this.hostname=validParts.join(".");break}}}}if(this.hostname.length>hostnameMaxLen){this.hostname=""}else{this.hostname=this.hostname.toLowerCase()}if(!ipv6Hostname){this.hostname=punycode.toASCII(this.hostname)}var p=this.port?":"+this.port:"";var h=this.hostname||"";this.host=h+p;this.href+=this.host;if(ipv6Hostname){this.hostname=this.hostname.substr(1,this.hostname.length-2);if(rest[0]!=="/"){rest="/"+rest}}}if(!unsafeProtocol[lowerProto]){for(var i=0,l=autoEscape.length;i<l;i++){var ae=autoEscape[i];if(rest.indexOf(ae)===-1)continue;var esc=encodeURIComponent(ae);if(esc===ae){esc=escape(ae)}rest=rest.split(ae).join(esc)}}var hash=rest.indexOf("#");if(hash!==-1){this.hash=rest.substr(hash);rest=rest.slice(0,hash)}var qm=rest.indexOf("?");if(qm!==-1){this.search=rest.substr(qm);this.query=rest.substr(qm+1);if(parseQueryString){this.query=querystring.parse(this.query)}rest=rest.slice(0,qm)}else if(parseQueryString){this.search="";this.query={}}if(rest)this.pathname=rest;if(slashedProtocol[lowerProto]&&this.hostname&&!this.pathname){this.pathname="/"}if(this.pathname||this.search){var p=this.pathname||"";var s=this.search||"";this.path=p+s}this.href=this.format();return this};function urlFormat(obj){if(util.isString(obj))obj=urlParse(obj);if(!(obj instanceof Url))return Url.prototype.format.call(obj);return obj.format()}Url.prototype.format=function(){var auth=this.auth||"";if(auth){auth=encodeURIComponent(auth);auth=auth.replace(/%3A/i,":");auth+="@"}var protocol=this.protocol||"",pathname=this.pathname||"",hash=this.hash||"",host=false,query="";if(this.host){host=auth+this.host}else if(this.hostname){host=auth+(this.hostname.indexOf(":")===-1?this.hostname:"["+this.hostname+"]");if(this.port){host+=":"+this.port}}if(this.query&&util.isObject(this.query)&&Object.keys(this.query).length){query=querystring.stringify(this.query)}var search=this.search||query&&"?"+query||"";if(protocol&&protocol.substr(-1)!==":")protocol+=":";if(this.slashes||(!protocol||slashedProtocol[protocol])&&host!==false){host="//"+(host||"");if(pathname&&pathname.charAt(0)!=="/")pathname="/"+pathname}else if(!host){host=""}if(hash&&hash.charAt(0)!=="#")hash="#"+hash;if(search&&search.charAt(0)!=="?")search="?"+search;pathname=pathname.replace(/[?#]/g,(function(match){return encodeURIComponent(match)}));search=search.replace("#","%23");return protocol+host+pathname+search+hash};function urlResolve(source,relative){return urlParse(source,false,true).resolve(relative)}Url.prototype.resolve=function(relative){return this.resolveObject(urlParse(relative,false,true)).format()};function urlResolveObject(source,relative){if(!source)return relative;return urlParse(source,false,true).resolveObject(relative)}Url.prototype.resolveObject=function(relative){if(util.isString(relative)){var rel=new Url;rel.parse(relative,false,true);relative=rel}var result=new Url;var tkeys=Object.keys(this);for(var tk=0;tk<tkeys.length;tk++){var tkey=tkeys[tk];result[tkey]=this[tkey]}result.hash=relative.hash;if(relative.href===""){result.href=result.format();return result}if(relative.slashes&&!relative.protocol){var rkeys=Object.keys(relative);for(var rk=0;rk<rkeys.length;rk++){var rkey=rkeys[rk];if(rkey!=="protocol")result[rkey]=relative[rkey]}if(slashedProtocol[result.protocol]&&result.hostname&&!result.pathname){result.path=result.pathname="/"}result.href=result.format();return result}if(relative.protocol&&relative.protocol!==result.protocol){if(!slashedProtocol[relative.protocol]){var keys=Object.keys(relative);for(var v=0;v<keys.length;v++){var k=keys[v];result[k]=relative[k]}result.href=result.format();return result}result.protocol=relative.protocol;if(!relative.host&&!hostlessProtocol[relative.protocol]){var relPath=(relative.pathname||"").split("/");while(relPath.length&&!(relative.host=relPath.shift()));if(!relative.host)relative.host="";if(!relative.hostname)relative.hostname="";if(relPath[0]!=="")relPath.unshift("");if(relPath.length<2)relPath.unshift("");result.pathname=relPath.join("/")}else{result.pathname=relative.pathname}result.search=relative.search;result.query=relative.query;result.host=relative.host||"";result.auth=relative.auth;result.hostname=relative.hostname||relative.host;result.port=relative.port;if(result.pathname||result.search){var p=result.pathname||"";var s=result.search||"";result.path=p+s}result.slashes=result.slashes||relative.slashes;result.href=result.format();return result}var isSourceAbs=result.pathname&&result.pathname.charAt(0)==="/",isRelAbs=relative.host||relative.pathname&&relative.pathname.charAt(0)==="/",mustEndAbs=isRelAbs||isSourceAbs||result.host&&relative.pathname,removeAllDots=mustEndAbs,srcPath=result.pathname&&result.pathname.split("/")||[],relPath=relative.pathname&&relative.pathname.split("/")||[],psychotic=result.protocol&&!slashedProtocol[result.protocol];if(psychotic){result.hostname="";result.port=null;if(result.host){if(srcPath[0]==="")srcPath[0]=result.host;else srcPath.unshift(result.host)}result.host="";if(relative.protocol){relative.hostname=null;relative.port=null;if(relative.host){if(relPath[0]==="")relPath[0]=relative.host;else relPath.unshift(relative.host)}relative.host=null}mustEndAbs=mustEndAbs&&(relPath[0]===""||srcPath[0]==="")}if(isRelAbs){result.host=relative.host||relative.host===""?relative.host:result.host;result.hostname=relative.hostname||relative.hostname===""?relative.hostname:result.hostname;result.search=relative.search;result.query=relative.query;srcPath=relPath}else if(relPath.length){if(!srcPath)srcPath=[];srcPath.pop();srcPath=srcPath.concat(relPath);result.search=relative.search;result.query=relative.query}else if(!util.isNullOrUndefined(relative.search)){if(psychotic){result.hostname=result.host=srcPath.shift();var authInHost=result.host&&result.host.indexOf("@")>0?result.host.split("@"):false;if(authInHost){result.auth=authInHost.shift();result.host=result.hostname=authInHost.shift()}}result.search=relative.search;result.query=relative.query;if(!util.isNull(result.pathname)||!util.isNull(result.search)){result.path=(result.pathname?result.pathname:"")+(result.search?result.search:"")}result.href=result.format();return result}if(!srcPath.length){result.pathname=null;if(result.search){result.path="/"+result.search}else{result.path=null}result.href=result.format();return result}var last=srcPath.slice(-1)[0];var hasTrailingSlash=(result.host||relative.host||srcPath.length>1)&&(last==="."||last==="..")||last==="";var up=0;for(var i=srcPath.length;i>=0;i--){last=srcPath[i];if(last==="."){srcPath.splice(i,1)}else if(last===".."){srcPath.splice(i,1);up++}else if(up){srcPath.splice(i,1);up--}}if(!mustEndAbs&&!removeAllDots){for(;up--;up){srcPath.unshift("..")}}if(mustEndAbs&&srcPath[0]!==""&&(!srcPath[0]||srcPath[0].charAt(0)!=="/")){srcPath.unshift("")}if(hasTrailingSlash&&srcPath.join("/").substr(-1)!=="/"){srcPath.push("")}var isAbsolute=srcPath[0]===""||srcPath[0]&&srcPath[0].charAt(0)==="/";if(psychotic){result.hostname=result.host=isAbsolute?"":srcPath.length?srcPath.shift():"";var authInHost=result.host&&result.host.indexOf("@")>0?result.host.split("@"):false;if(authInHost){result.auth=authInHost.shift();result.host=result.hostname=authInHost.shift()}}mustEndAbs=mustEndAbs||result.host&&srcPath.length;if(mustEndAbs&&!isAbsolute){srcPath.unshift("")}if(!srcPath.length){result.pathname=null;result.path=null}else{result.pathname=srcPath.join("/")}if(!util.isNull(result.pathname)||!util.isNull(result.search)){result.path=(result.pathname?result.pathname:"")+(result.search?result.search:"")}result.auth=relative.auth||result.auth;result.slashes=result.slashes||relative.slashes;result.href=result.format();return result};Url.prototype.parseHost=function(){var host=this.host;var port=portPattern.exec(host);if(port){port=port[0];if(port!==":"){this.port=port.substr(1)}host=host.substr(0,host.length-port.length)}if(host)this.hostname=host}},function(module,exports,__webpack_require__){(function(module,global){var __WEBPACK_AMD_DEFINE_RESULT__;/*! https://mths.be/punycode v1.4.1 by @mathias */(function(root){var freeExports=true&&exports&&!exports.nodeType&&exports;var freeModule=true&&module&&!module.nodeType&&module;var freeGlobal=typeof global=="object"&&global;if(freeGlobal.global===freeGlobal||freeGlobal.window===freeGlobal||freeGlobal.self===freeGlobal){root=freeGlobal}var punycode,maxInt=2147483647,base=36,tMin=1,tMax=26,skew=38,damp=700,initialBias=72,initialN=128,delimiter="-",regexPunycode=/^xn--/,regexNonASCII=/[^\x20-\x7E]/,regexSeparators=/[\x2E\u3002\uFF0E\uFF61]/g,errors={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},baseMinusTMin=base-tMin,floor=Math.floor,stringFromCharCode=String.fromCharCode,key;function error(type){throw new RangeError(errors[type])}function map(array,fn){var length=array.length;var result=[];while(length--){result[length]=fn(array[length])}return result}function mapDomain(string,fn){var parts=string.split("@");var result="";if(parts.length>1){result=parts[0]+"@";string=parts[1]}string=string.replace(regexSeparators,".");var labels=string.split(".");var encoded=map(labels,fn).join(".");return result+encoded}function ucs2decode(string){var output=[],counter=0,length=string.length,value,extra;while(counter<length){value=string.charCodeAt(counter++);if(value>=55296&&value<=56319&&counter<length){extra=string.charCodeAt(counter++);if((extra&64512)==56320){output.push(((value&1023)<<10)+(extra&1023)+65536)}else{output.push(value);counter--}}else{output.push(value)}}return output}function ucs2encode(array){return map(array,(function(value){var output="";if(value>65535){value-=65536;output+=stringFromCharCode(value>>>10&1023|55296);value=56320|value&1023}output+=stringFromCharCode(value);return output})).join("")}function basicToDigit(codePoint){if(codePoint-48<10){return codePoint-22}if(codePoint-65<26){return codePoint-65}if(codePoint-97<26){return codePoint-97}return base}function digitToBasic(digit,flag){return digit+22+75*(digit<26)-((flag!=0)<<5)}function adapt(delta,numPoints,firstTime){var k=0;delta=firstTime?floor(delta/damp):delta>>1;delta+=floor(delta/numPoints);for(;delta>baseMinusTMin*tMax>>1;k+=base){delta=floor(delta/baseMinusTMin)}return floor(k+(baseMinusTMin+1)*delta/(delta+skew))}function decode(input){var output=[],inputLength=input.length,out,i=0,n=initialN,bias=initialBias,basic,j,index,oldi,w,k,digit,t,baseMinusT;basic=input.lastIndexOf(delimiter);if(basic<0){basic=0}for(j=0;j<basic;++j){if(input.charCodeAt(j)>=128){error("not-basic")}output.push(input.charCodeAt(j))}for(index=basic>0?basic+1:0;index<inputLength;){for(oldi=i,w=1,k=base;;k+=base){if(index>=inputLength){error("invalid-input")}digit=basicToDigit(input.charCodeAt(index++));if(digit>=base||digit>floor((maxInt-i)/w)){error("overflow")}i+=digit*w;t=k<=bias?tMin:k>=bias+tMax?tMax:k-bias;if(digit<t){break}baseMinusT=base-t;if(w>floor(maxInt/baseMinusT)){error("overflow")}w*=baseMinusT}out=output.length+1;bias=adapt(i-oldi,out,oldi==0);if(floor(i/out)>maxInt-n){error("overflow")}n+=floor(i/out);i%=out;output.splice(i++,0,n)}return ucs2encode(output)}function encode(input){var n,delta,handledCPCount,basicLength,bias,j,m,q,k,t,currentValue,output=[],inputLength,handledCPCountPlusOne,baseMinusT,qMinusT;input=ucs2decode(input);inputLength=input.length;n=initialN;delta=0;bias=initialBias;for(j=0;j<inputLength;++j){currentValue=input[j];if(currentValue<128){output.push(stringFromCharCode(currentValue))}}handledCPCount=basicLength=output.length;if(basicLength){output.push(delimiter)}while(handledCPCount<inputLength){for(m=maxInt,j=0;j<inputLength;++j){currentValue=input[j];if(currentValue>=n&&currentValue<m){m=currentValue}}handledCPCountPlusOne=handledCPCount+1;if(m-n>floor((maxInt-delta)/handledCPCountPlusOne)){error("overflow")}delta+=(m-n)*handledCPCountPlusOne;n=m;for(j=0;j<inputLength;++j){currentValue=input[j];if(currentValue<n&&++delta>maxInt){error("overflow")}if(currentValue==n){for(q=delta,k=base;;k+=base){t=k<=bias?tMin:k>=bias+tMax?tMax:k-bias;if(q<t){break}qMinusT=q-t;baseMinusT=base-t;output.push(stringFromCharCode(digitToBasic(t+qMinusT%baseMinusT,0)));q=floor(qMinusT/baseMinusT)}output.push(stringFromCharCode(digitToBasic(q,0)));bias=adapt(delta,handledCPCountPlusOne,handledCPCount==basicLength);delta=0;++handledCPCount}}++delta;++n}return output.join("")}function toUnicode(input){return mapDomain(input,(function(string){return regexPunycode.test(string)?decode(string.slice(4).toLowerCase()):string}))}function toASCII(input){return mapDomain(input,(function(string){return regexNonASCII.test(string)?"xn--"+encode(string):string}))}punycode={version:"1.4.1",ucs2:{decode:ucs2decode,encode:ucs2encode},decode:decode,encode:encode,toASCII:toASCII,toUnicode:toUnicode};if(true){!(__WEBPACK_AMD_DEFINE_RESULT__=function(){return punycode}.call(exports,__webpack_require__,exports,module),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})(this)}).call(this,__webpack_require__(135)(module),__webpack_require__(134))},function(module,exports,__webpack_require__){"use strict";module.exports={isString:function(arg){return typeof arg==="string"},isObject:function(arg){return typeof arg==="object"&&arg!==null},isNull:function(arg){return arg===null},isNullOrUndefined:function(arg){return arg==null}}},function(module,exports,__webpack_require__){"use strict";exports.decode=exports.parse=__webpack_require__(228);exports.encode=exports.stringify=__webpack_require__(229)},function(module,exports,__webpack_require__){"use strict";function hasOwnProperty(obj,prop){return Object.prototype.hasOwnProperty.call(obj,prop)}module.exports=function(qs,sep,eq,options){sep=sep||"&";eq=eq||"=";var obj={};if(typeof qs!=="string"||qs.length===0){return obj}var regexp=/\+/g;qs=qs.split(sep);var maxKeys=1e3;if(options&&typeof options.maxKeys==="number"){maxKeys=options.maxKeys}var len=qs.length;if(maxKeys>0&&len>maxKeys){len=maxKeys}for(var i=0;i<len;++i){var x=qs[i].replace(regexp,"%20"),idx=x.indexOf(eq),kstr,vstr,k,v;if(idx>=0){kstr=x.substr(0,idx);vstr=x.substr(idx+1)}else{kstr=x;vstr=""}k=decodeURIComponent(kstr);v=decodeURIComponent(vstr);if(!hasOwnProperty(obj,k)){obj[k]=v}else if(isArray(obj[k])){obj[k].push(v)}else{obj[k]=[obj[k],v]}}return obj};var isArray=Array.isArray||function(xs){return Object.prototype.toString.call(xs)==="[object Array]"}},function(module,exports,__webpack_require__){"use strict";var stringifyPrimitive=function(v){switch(typeof v){case"string":return v;case"boolean":return v?"true":"false";case"number":return isFinite(v)?v:"";default:return""}};module.exports=function(obj,sep,eq,name){sep=sep||"&";eq=eq||"=";if(obj===null){obj=undefined}if(typeof obj==="object"){return map(objectKeys(obj),(function(k){var ks=encodeURIComponent(stringifyPrimitive(k))+eq;if(isArray(obj[k])){return map(obj[k],(function(v){return ks+encodeURIComponent(stringifyPrimitive(v))})).join(sep)}else{return ks+encodeURIComponent(stringifyPrimitive(obj[k]))}})).join(sep)}if(!name)return"";return encodeURIComponent(stringifyPrimitive(name))+eq+encodeURIComponent(stringifyPrimitive(obj))};var isArray=Array.isArray||function(xs){return Object.prototype.toString.call(xs)==="[object Array]"};function map(xs,f){if(xs.map)return xs.map(f);var res=[];for(var i=0;i<xs.length;i++){res.push(f(xs[i],i))}return res}var objectKeys=Object.keys||function(obj){var res=[];for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key))res.push(key)}return res}},function(module,exports,__webpack_require__){(function(root,factory){if(true){module.exports=factory()}else{}})(typeof self!=="undefined"?self:this,(function(){var rison={};rison.uri_ok={"~":true,"!":true,"*":true,"(":true,")":true,"-":true,_:true,".":true,",":true,":":true,"@":true,$:true,"'":true,"/":true};(function(){var l=[];for(var hi=0;hi<16;hi++){for(var lo=0;lo<16;lo++){if(hi+lo===0)continue;var c=String.fromCharCode(hi*16+lo);if(!/\w|[-_./~]/.test(c))l.push("\\u00"+hi.toString(16)+lo.toString(16))}}rison.not_idchar=l.join("")})();rison.not_idchar=" '!:(),*@$";rison.not_idstart="-0123456789";(function(){var idrx="[^"+rison.not_idstart+rison.not_idchar+"][^"+rison.not_idchar+"]*";rison.id_ok=new RegExp("^"+idrx+"$");rison.next_id=new RegExp(idrx,"g")})();rison.quote=function(x){if(/^[-A-Za-z0-9~!*()_.',:@$/]*$/.test(x))return x;return encodeURIComponent(x).replace(/%2C/g,",").replace(/%3A/g,":").replace(/%40/g,"@").replace(/%24/g,"$").replace(/%2F/g,"/").replace(/%20/g,"+")};(function(){var sq={"'":true,"!":true},enc=function(v){if(v&&typeof v.toJSON==="function")v=v.toJSON();var fn=s[typeof v];if(fn)return fn(v)},s={array:function(x){var a=["!("],b,i,l=x.length,v;for(i=0;i<l;i+=1){v=enc(x[i]);if(typeof v=="string"){if(b){a[a.length]=","}a[a.length]=v;b=true}}a[a.length]=")";return a.join("")},boolean:function(x){if(x)return"!t";return"!f"},null:function(){return"!n"},number:function(x){if(!isFinite(x))return"!n";return String(x).replace(/\+/,"")},object:function(x){if(x){if(x instanceof Array){return s.array(x)}if(typeof x.__prototype__==="object"&&typeof x.__prototype__.encode_rison!=="undefined")return x.encode_rison();var a=["("],b,i,v,ki,ks=[];for(i in x)ks[ks.length]=i;ks.sort();for(ki=0;ki<ks.length;ki++){i=ks[ki];v=enc(x[i]);if(typeof v=="string"){if(b){a[a.length]=","}a.push(s.string(i),":",v);b=true}}a[a.length]=")";return a.join("")}return"!n"},string:function(x){if(x==="")return"''";if(rison.id_ok.test(x))return x;x=x.replace(/(['!])/g,(function(a,b){if(sq[b])return"!"+b;return b}));return"'"+x+"'"},undefined:function(){return}};rison.encode=function(v){return enc(v)};rison.encode_object=function(v){if(typeof v!="object"||v===null||v instanceof Array)throw new Error("rison.encode_object expects an object argument");var r=s[typeof v](v);return r.substring(1,r.length-1)};rison.encode_array=function(v){if(!(v instanceof Array))throw new Error("rison.encode_array expects an array argument");var r=s[typeof v](v);return r.substring(2,r.length-1)};rison.encode_uri=function(v){return rison.quote(s[typeof v](v))}})();rison.decode=function(r){var errcb=function(e){throw Error("rison decoder error: "+e)};if(typeof r!=="string")return errcb("decode input must be a string");var p=new rison.parser(errcb);return p.parse(r)};rison.decode_object=function(r){return rison.decode("("+r+")")};rison.decode_array=function(r){return rison.decode("!("+r+")")};rison.parser=function(errcb){this.errorHandler=errcb};rison.parser.WHITESPACE="";rison.parser.prototype.setOptions=function(options){if(options["errorHandler"])this.errorHandler=options.errorHandler};rison.parser.prototype.parse=function(str){this.string=str;this.index=0;this.message=null;var value=this.readValue();if(!this.message&&this.next())value=this.error("unable to parse string as rison: '"+rison.encode(str)+"'");if(this.message&&this.errorHandler)this.errorHandler(this.message,this.index);return value};rison.parser.prototype.error=function(message){if(typeof console!=="undefined")console.log("rison parser error: ",message);this.message=message;return undefined};rison.parser.prototype.readValue=function(){var c=this.next();var fn=c&&this.table[c];if(fn)return fn.apply(this);var s=this.string;var i=this.index-1;rison.next_id.lastIndex=i;var m=rison.next_id.exec(s);if(m.length>0){var id=m[0];this.index=i+id.length;return id}if(c)return this.error("invalid character: '"+c+"'");return this.error("empty expression")};rison.parser.parse_array=function(parser){var ar=[];var c;while((c=parser.next())!==")"){if(!c)return parser.error("unmatched '!('");if(ar.length){if(c!==",")parser.error("missing ','")}else if(c===","){return parser.error("extra ','")}else--parser.index;var n=parser.readValue();if(typeof n=="undefined")return undefined;ar.push(n)}return ar};rison.parser.bangs={t:true,f:false,n:null,"(":rison.parser.parse_array};rison.parser.prototype.table={"!":function(){var s=this.string;var c=s.charAt(this.index++);if(!c)return this.error('"!" at end of input');var x=rison.parser.bangs[c];if(typeof x=="function"){return x.call(null,this)}else if(typeof x=="undefined"){return this.error('unknown literal: "!'+c+'"')}return x},"(":function(){var o={};var c;var count=0;while((c=this.next())!==")"){if(count){if(c!==",")this.error("missing ','")}else if(c===","){return this.error("extra ','")}else--this.index;var k=this.readValue();if(typeof k==="undefined")return undefined;if(this.next()!==":")return this.error("missing ':'");var v=this.readValue();if(typeof v==="undefined")return undefined;o[k]=v;count++}return o},"'":function(){var s=this.string;var i=this.index;var start=i;var segments=[];var c;while((c=s.charAt(i++))!=="'"){if(!c)return this.error('unmatched "\'"');if(c==="!"){if(start<i-1)segments.push(s.slice(start,i-1));c=s.charAt(i++);if("!'".indexOf(c)>=0){segments.push(c)}else{return this.error('invalid string escape: "!'+c+'"')}start=i}}if(start<i-1)segments.push(s.slice(start,i-1));this.index=i;return segments.length===1?segments[0]:segments.join("")},"-":function(){var s=this.string;var i=this.index;var start=i-1;var state="int";var permittedSigns="-";var transitions={"int+.":"frac","int+e":"exp","frac+e":"exp"};do{var c=s.charAt(i++);if(!c)break;if("0"<=c&&c<="9")continue;if(permittedSigns.indexOf(c)>=0){permittedSigns="";continue}state=transitions[state+"+"+c.toLowerCase()];if(state==="exp")permittedSigns="-"}while(state);this.index=--i;s=s.slice(start,i);if(s==="-")return this.error("invalid number");return Number(s)}};(function(table){for(var i=0;i<=9;i++)table[String(i)]=table["-"]})(rison.parser.prototype.table);rison.parser.prototype.next=function(){var c;var s=this.string;var i=this.index;do{if(i===s.length)return undefined;c=s.charAt(i++)}while(rison.parser.WHITESPACE.indexOf(c)>=0);this.index=i;return c};return rison}))},,,function(module,exports,__webpack_require__){var v1=__webpack_require__(234);var v4=__webpack_require__(235);var uuid=v4;uuid.v1=v1;uuid.v4=v4;module.exports=uuid},function(module,exports,__webpack_require__){var rng=__webpack_require__(155);var bytesToUuid=__webpack_require__(156);var _nodeId;var _clockseq;var _lastMSecs=0;var _lastNSecs=0;function v1(options,buf,offset){var i=buf&&offset||0;var b=buf||[];options=options||{};var node=options.node||_nodeId;var clockseq=options.clockseq!==undefined?options.clockseq:_clockseq;if(node==null||clockseq==null){var seedBytes=rng();if(node==null){node=_nodeId=[seedBytes[0]|1,seedBytes[1],seedBytes[2],seedBytes[3],seedBytes[4],seedBytes[5]]}if(clockseq==null){clockseq=_clockseq=(seedBytes[6]<<8|seedBytes[7])&16383}}var msecs=options.msecs!==undefined?options.msecs:(new Date).getTime();var nsecs=options.nsecs!==undefined?options.nsecs:_lastNSecs+1;var dt=msecs-_lastMSecs+(nsecs-_lastNSecs)/1e4;if(dt<0&&options.clockseq===undefined){clockseq=clockseq+1&16383}if((dt<0||msecs>_lastMSecs)&&options.nsecs===undefined){nsecs=0}if(nsecs>=1e4){throw new Error("uuid.v1(): Can't create more than 10M uuids/sec")}_lastMSecs=msecs;_lastNSecs=nsecs;_clockseq=clockseq;msecs+=122192928e5;var tl=((msecs&268435455)*1e4+nsecs)%4294967296;b[i++]=tl>>>24&255;b[i++]=tl>>>16&255;b[i++]=tl>>>8&255;b[i++]=tl&255;var tmh=msecs/4294967296*1e4&268435455;b[i++]=tmh>>>8&255;b[i++]=tmh&255;b[i++]=tmh>>>24&15|16;b[i++]=tmh>>>16&255;b[i++]=clockseq>>>8|128;b[i++]=clockseq&255;for(var n=0;n<6;++n){b[i+n]=node[n]}return buf?buf:bytesToUuid(b)}module.exports=v1},function(module,exports,__webpack_require__){var rng=__webpack_require__(155);var bytesToUuid=__webpack_require__(156);function v4(options,buf,offset){var i=buf&&offset||0;if(typeof options=="string"){buf=options==="binary"?new Array(16):null;options=null}options=options||{};var rnds=options.random||(options.rng||rng)();rnds[6]=rnds[6]&15|64;rnds[8]=rnds[8]&63|128;if(buf){for(var ii=0;ii<16;++ii){buf[i+ii]=rnds[ii]}}return buf||bytesToUuid(rnds)}module.exports=v4},function(module){module.exports=JSON.parse('{"type":"FeatureCollection","features":[{"type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[[[["34.21666","31.32333"],["35.98361","34.52750"],["34.65943","36.80527"],["32.77166","36.02888"],["29.67722","36.11833"],["27.25500","36.96500"],["27.51166","40.30555"],["33.33860","42.01985"],["38.35582","40.91027"],["41.77609","41.84193"],["41.59748","43.22151"],["45.16512","42.70333"],["47.91547","41.22499"],["49.76062","42.71076"],["49.44831","45.53038"],["47.30249","50.03194"],["52.34180","51.78075"],["55.69249","50.53249"],["58.33777","51.15610"],["57.97027","54.38819"],["59.64166","55.55867"],["57.22169","56.85096"],["59.44912","58.48804"],["59.57756","63.93287"],["66.10887","67.48123"],["64.52222","68.90305"],["67.05498","68.85637"],["69.32735","72.94540"],["73.52553","71.81582"],["80.82610","72.08693"],["80.51860","73.57346"],["89.25278","75.50305"],["97.18359","75.92804"],["104.07138","77.73221"],["111.10387","76.75526"],["113.47054","73.50096"],["118.63443","73.57166"],["131.53580","70.87776"],["137.45190","71.34109"],["141.02414","72.58582"],["149.18524","72.22249"],["152.53830","70.83777"],["159.72968","69.83472"],["170.61194","68.75633"],["170.47189","70.13416"],["180.00000","68.98010"],["180.00000","65.06891"],["179.55373","62.61971"],["173.54178","61.74430"],["170.64194","60.41750"],["163.36023","59.82388"],["161.93858","58.06763"],["163.34996","56.19596"],["156.74524","51.07791"],["155.54413","55.30360"],["155.94206","56.65353"],["161.91248","60.41972"],["159.24747","61.92222"],["152.35718","59.02332"],["143.21109","59.37666"],["137.72580","56.17500"],["137.29327","54.07500"],["141.41483","53.29361"],["140.17609","48.45013"],["135.42233","43.75611"],["133.15485","42.68263"],["131.81052","43.32555"],["129.70204","40.83069"],["127.51763","39.73957"],["129.42944","37.05986"],["129.23749","35.18990"],["126.37556","34.79138"],["126.38860","37.88721"],["124.32395","39.91589"],["121.64804","38.99638"],["121.17747","40.92194"],["118.11053","38.14639"],["120.82054","36.64527"],["120.24873","34.31145"],["121.84693","30.85305"],["120.93526","27.98222"],["119.58074","25.67996"],["116.48172","22.93902"],["112.28194","21.70139"],["107.36693","21.26527"],["105.63857","18.89065"],["108.82916","15.42194"],["109.46186","12.86097"],["109.02168","11.36225"],["104.79893","8.79222"],["104.98177","10.10444"],["100.97635","13.46281"],["99.15082","10.36472"],["100.57809","7.22014"],["103.18192","5.28278"],["103.37455","1.53347"],["101.28574","2.84354"],["100.35553","5.96389"],["98.27415","8.27444"],["98.74720","11.67486"],["97.72457","15.84666"],["95.42859","15.72972"],["93.72436","19.93243"],["91.70444","22.48055"],["86.96332","21.38194"],["86.42123","19.98493"],["80.27943","15.69917"],["79.85811","10.28583"],["76.99860","8.36527"],["74.85526","12.75500"],["73.44748","16.05861"],["72.56485","21.37506"],["70.82513","20.69597"],["66.50005","25.40381"],["61.76083","25.03208"],["57.31909","25.77146"],["56.80888","27.12361"],["54.78846","26.49041"],["51.43027","27.93777"],["50.63916","29.47042"],["47.95943","30.03305"],["48.83887","27.61972"],["51.28236","24.30000"],["53.58777","24.04417"],["55.85944","25.72042"],["57.17131","23.93444"],["59.82861","22.29166"],["57.80569","18.97097"],["55.03194","17.01472"],["52.18916","15.60528"],["45.04232","12.75239"],["43.47888","12.67500"],["42.78933","16.46083"],["40.75694","19.76417"],["39.17486","21.10402"],["39.06277","22.58333"],["35.16055","28.05666"],["34.21666","31.32333"]]],[[["-169.69496","66.06806"],["-173.67308","64.34679"],["-179.32083","65.53012"],["-180.00000","65.06891"],["-180.00000","68.98010"],["-169.69496","66.06806"]]],[[["139.93851","40.42860"],["142.06970","39.54666"],["140.95358","38.14805"],["140.33218","35.12985"],["137.02879","34.56784"],["136.71246","36.75139"],["139.42622","38.15458"],["139.93851","40.42860"]]],[[["119.89259","15.80112"],["120.58527","18.51139"],["122.51833","17.04389"],["121.38026","15.30250"],["119.89259","15.80112"]]],[[["122.32916","7.30833"],["126.18610","9.24277"],["125.37762","6.72361"],["123.45888","7.81055"],["122.32916","7.30833"]]],[[["111.89638","-3.57389"],["110.23193","-2.97111"],["108.84549","0.81056"],["109.64857","2.07341"],["113.01054","3.16055"],["115.37886","4.91167"],["116.75417","7.01805"],["119.27582","5.34500"],["117.27540","3.22000"],["117.87192","1.87667"],["117.44479","-0.52397"],["115.96624","-3.60875"],["113.03471","-2.98972"],["111.89638","-3.57389"]]],[[["102.97601","0.64348"],["103.36081","-0.70222"],["106.05525","-3.03139"],["105.72887","-5.89826"],["102.32610","-4.00611"],["100.90555","-2.31944"],["98.70383","1.55979"],["95.53108","4.68278"],["97.51483","5.24944"],["100.41219","2.29306"],["102.97601","0.64348"]]],[[["120.82723","1.23406"],["120.01999","-0.07528"],["122.47623","-3.16090"],["120.32888","-5.51208"],["119.35491","-5.40007"],["118.88860","-2.89319"],["119.77805","0.22972"],["120.82723","1.23406"]]],[[["136.04913","-2.69806"],["137.87579","-1.47306"],["144.51373","-3.82222"],["145.76639","-5.48528"],["147.46661","-5.97086"],["146.08969","-8.09111"],["144.21738","-7.79465"],["143.36510","-9.01222"],["141.11996","-9.23097"],["139.09454","-7.56181"],["138.06525","-5.40896"],["135.20468","-4.45972"],["132.72275","-2.81722"],["131.25555","-0.82278"],["134.02950","-0.96694"],["134.99495","-3.33653"],["136.04913","-2.69806"]]],[[["110.05640","-7.89751"],["106.56721","-7.41694"],["106.07582","-5.88194"],["110.39360","-6.97903"],["110.05640","-7.89751"]]]]},"properties":{"CONTINENT":"Asia"}},{"type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[[[["-25.28167","71.39166"],["-23.56056","70.10609"],["-26.36333","68.66748"],["-31.99916","68.09526"],["-34.71999","66.33832"],["-41.15541","64.96235"],["-43.08722","60.10027"],["-47.68986","61.00680"],["-50.31562","62.49430"],["-53.23333","65.68283"],["-53.62778","67.81470"],["-50.58930","69.92373"],["-54.68694","72.36721"],["-58.15958","75.50860"],["-68.50056","76.08693"],["-72.55222","78.52110"],["-60.80666","81.87997"],["-30.38833","83.60220"],["-16.00500","80.72859"],["-22.03695","77.68568"],["-19.33681","75.40207"],["-24.46305","73.53581"],["-25.28167","71.39166"]]],[[["-87.64890","76.33804"],["-86.47916","79.76167"],["-90.43666","81.88750"],["-70.26001","83.11388"],["-61.07639","82.32083"],["-78.78194","76.57221"],["-87.64890","76.33804"]]],[[["-123.83389","73.70027"],["-115.31903","73.47707"],["-123.29306","71.14610"],["-123.83389","73.70027"]]],[[["-65.32806","62.66610"],["-68.61583","62.26389"],["-77.33667","65.17609"],["-72.25835","67.24803"],["-77.30506","69.83395"],["-85.87465","70.07943"],["-89.90348","71.35304"],["-89.03958","73.25499"],["-81.57251","73.71971"],["-67.21986","69.94081"],["-67.23819","68.35790"],["-61.26458","66.62609"],["-65.56204","64.73154"],["-65.32806","62.66610"]]],[[["-105.02444","72.21999"],["-100.99973","70.17276"],["-101.85139","68.98442"],["-113.04173","68.49374"],["-116.53221","69.40887"],["-119.13445","71.77457"],["-114.66666","73.37247"],["-105.02444","72.21999"]]],[[["-77.36667","8.67500"],["-77.88972","7.22889"],["-79.69778","8.86666"],["-81.73862","8.16250"],["-85.65668","9.90500"],["-85.66959","11.05500"],["-87.93779","13.15639"],["-91.38474","13.97889"],["-93.93861","16.09389"],["-96.47612","15.64361"],["-103.45001","18.31361"],["-105.67834","20.38305"],["-105.18945","21.43750"],["-106.91570","23.86514"],["-109.43750","25.82027"],["-109.44431","26.71555"],["-112.16195","28.97139"],["-113.09167","31.22972"],["-115.69667","29.77423"],["-117.40944","33.24416"],["-120.60583","34.55860"],["-124.33118","40.27246"],["-124.52444","42.86610"],["-123.87161","45.52898"],["-124.71431","48.39708"],["-124.03510","49.91801"],["-127.17315","50.92221"],["-130.88640","55.70791"],["-133.81302","57.97293"],["-136.65891","58.21652"],["-140.40335","59.69804"],["-146.75543","60.95249"],["-154.23567","58.13069"],["-157.55139","58.38777"],["-165.42244","60.55215"],["-164.40112","63.21499"],["-168.13196","65.66296"],["-161.66779","67.02054"],["-166.82362","68.34873"],["-156.59673","71.35144"],["-151.22986","70.37296"],["-143.21555","70.11026"],["-137.25500","68.94832"],["-127.18096","70.27638"],["-114.06652","68.46970"],["-112.39584","67.67915"],["-98.11124","67.83887"],["-90.43639","68.87442"],["-85.55499","69.85970"],["-81.33570","69.18498"],["-81.50222","67.00096"],["-85.89726","66.16802"],["-87.98736","64.18845"],["-92.71001","62.46583"],["-94.78972","59.09222"],["-92.41875","57.33270"],["-88.81500","56.82444"],["-85.00195","55.29666"],["-82.30777","55.14888"],["-82.27390","52.95638"],["-78.57945","52.11138"],["-79.76181","54.65166"],["-76.67979","56.03645"],["-78.57299","58.62888"],["-77.50835","62.56166"],["-73.68346","62.47999"],["-70.14848","61.08458"],["-67.56610","58.22360"],["-64.74538","60.23075"],["-61.09055","55.84415"],["-57.34969","54.57496"],["-56.95160","51.42458"],["-60.00500","50.24888"],["-66.44903","50.26777"],["-64.21167","48.88499"],["-64.90430","46.84597"],["-63.66708","45.81666"],["-70.19187","43.57555"],["-70.72610","41.72777"],["-74.13390","40.70082"],["-75.96083","37.15221"],["-76.34326","34.88194"],["-78.82750","33.73027"],["-81.48843","31.11347"],["-80.03534","26.79569"],["-81.73659","25.95944"],["-84.01098","30.09764"],["-88.98083","30.41833"],["-94.75417","29.36791"],["-97.56041","26.84208"],["-97.74223","22.01250"],["-95.80112","18.74500"],["-94.46918","18.14625"],["-90.73167","19.36153"],["-90.27972","21.06305"],["-86.82973","21.42923"],["-88.28250","17.62389"],["-88.13696","15.68285"],["-84.26015","15.82597"],["-83.18695","14.32389"],["-83.84751","11.17458"],["-82.24278","9.00236"],["-79.53445","9.62014"],["-77.36667","8.67500"]]],[[["-55.19333","46.98499"],["-59.40361","47.89423"],["-56.68250","51.33943"],["-55.56114","49.36818"],["-52.83465","48.09965"],["-55.19333","46.98499"]]],[[["-73.03644","18.45622"],["-72.79834","19.94278"],["-69.94932","19.67680"],["-68.89528","18.39639"],["-73.03644","18.45622"]]]]},"properties":{"CONTINENT":"North America"}},{"type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[[[["64.52222","68.90305"],["66.10887","67.48123"],["59.57756","63.93287"],["59.44912","58.48804"],["57.22169","56.85096"],["59.64166","55.55867"],["57.97027","54.38819"],["58.33777","51.15610"],["55.69249","50.53249"],["52.34180","51.78075"],["47.30249","50.03194"],["49.44831","45.53038"],["49.76062","42.71076"],["47.91547","41.22499"],["45.16512","42.70333"],["41.59748","43.22151"],["39.94553","43.39693"],["34.70249","46.17582"],["30.83277","46.54832"],["28.78083","44.66096"],["28.01305","41.98222"],["26.36041","40.95388"],["22.59500","40.01221"],["23.96055","38.28166"],["22.15246","37.01854"],["19.30721","40.64531"],["19.59771","41.80611"],["15.15167","44.19639"],["13.02958","41.26014"],["8.74722","44.42805"],["6.16528","43.05055"],["4.05625","43.56277"],["3.20167","41.89278"],["0.99306","41.04805"],["0.20722","38.73221"],["-2.12292","36.73347"],["-5.61361","36.00610"],["-6.95992","37.22184"],["-8.98924","37.02631"],["-9.49083","38.79388"],["-8.66014","40.69111"],["-9.16972","43.18583"],["-1.44389","43.64055"],["-1.11463","46.31658"],["-2.68528","48.50166"],["1.43875","50.10083"],["5.59917","53.30028"],["13.80854","53.85479"],["21.24506","54.95506"],["21.05223","56.81749"],["23.43159","59.95382"],["21.42416","60.57930"],["21.58500","64.43971"],["17.09861","61.60278"],["19.07264","59.73819"],["16.37982","56.66333"],["12.46007","56.29666"],["10.51569","59.30624"],["8.12750","58.09888"],["5.50847","58.66764"],["4.94944","61.41041"],["9.54528","63.76611"],["15.28833","68.03055"],["21.30000","70.24693"],["28.20778","71.07999"],["32.80605","69.30277"],["43.75180","67.31152"],["53.60437","68.90818"],["64.52222","68.90305"]]],[[["-13.49944","65.06915"],["-18.77500","63.39139"],["-22.04556","64.04666"],["-22.42167","66.43332"],["-16.41736","66.27603"],["-13.49944","65.06915"]]],[[["-4.19667","57.48583"],["-0.07931","54.11340"],["0.25389","50.73861"],["-3.43722","50.60500"],["-4.19639","53.20611"],["-2.89979","53.72499"],["-6.22778","56.69722"],["-4.19667","57.48583"]]],[[["12.44167","37.80611"],["15.64794","38.26458"],["15.08139","36.64916"],["12.44167","37.80611"]]]]},"properties":{"CONTINENT":"Europe"}},{"type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[[[["34.21666","31.32333"],["34.90380","29.48671"],["33.93833","26.65528"],["36.88625","22.05319"],["37.43569","18.85389"],["38.58902","18.06680"],["39.71805","15.08805"],["41.17222","14.63069"],["43.32750","12.47673"],["44.27833","10.44778"],["50.09319","11.51458"],["51.14555","10.63361"],["48.00055","4.52306"],["46.02555","2.43722"],["43.48861","0.65000"],["40.12548","-3.26569"],["38.77611","-6.03972"],["40.38777","-11.31778"],["40.57833","-15.49889"],["34.89069","-19.86042"],["35.45611","-24.16945"],["32.81111","-25.61209"],["32.39444","-28.53139"],["27.90000","-33.04056"],["24.82472","-34.20167"],["22.53916","-34.01118"],["20.00000","-34.82200"],["17.84750","-32.83083"],["18.21791","-31.73458"],["15.09500","-26.73528"],["14.51139","-22.55278"],["11.76764","-17.98820"],["11.73125","-15.85070"],["13.84944","-10.95611"],["13.39180","-8.39375"],["11.77417","-4.54264"],["9.70250","-2.44792"],["9.29833","-0.37167"],["9.96514","3.08521"],["8.89861","4.58833"],["5.93583","4.33833"],["4.41021","6.35993"],["1.46889","6.18639"],["-2.05889","4.73083"],["-4.46806","5.29556"],["-7.43639","4.34917"],["-9.23889","5.12278"],["-12.50417","7.38861"],["-13.49313","9.56008"],["-15.00542","10.77194"],["-17.17556","14.65444"],["-16.03945","17.73458"],["-16.91625","21.94542"],["-12.96271","27.92048"],["-11.51195","28.30375"],["-9.64097","30.16500"],["-8.53833","33.25055"],["-6.84306","34.01861"],["-5.91874","35.79065"],["-1.97972","35.07333"],["1.18250","36.51221"],["9.85868","37.32833"],["11.12667","35.24194"],["11.17430","33.21006"],["15.16583","32.39861"],["15.75430","31.38972"],["18.95750","30.27639"],["20.56763","32.56091"],["29.03500","30.82417"],["30.35545","31.50284"],["34.21666","31.32333"]]],[[["48.03140","-14.06341"],["49.94333","-13.03945"],["50.48277","-15.40583"],["49.36833","-18.35139"],["47.13305","-24.92806"],["44.01708","-24.98083"],["43.23888","-22.28250"],["44.48277","-19.96584"],["43.93139","-17.50056"],["44.87360","-16.21028"],["48.03140","-14.06341"]]]]},"properties":{"CONTINENT":"Africa"}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[["-77.88972","7.22889"],["-77.36667","8.67500"],["-75.63432","9.44819"],["-74.86081","11.12549"],["-68.84368","11.44708"],["-68.11424","10.48493"],["-61.87959","10.72833"],["-61.61987","9.90528"],["-57.51919","6.27077"],["-52.97320","5.47305"],["-51.25931","4.15250"],["-49.90320","1.17444"],["-51.92751","-1.33486"],["-48.42722","-1.66028"],["-47.28556","-0.59917"],["-42.23584","-2.83778"],["-39.99875","-2.84653"],["-37.17445","-4.91861"],["-35.47973","-5.16611"],["-34.83129","-6.98180"],["-35.32751","-9.22889"],["-39.05709","-13.38028"],["-38.87195","-15.87417"],["-39.70403","-19.42361"],["-42.03445","-22.91917"],["-44.67521","-23.05570"],["-48.02612","-25.01500"],["-48.84251","-28.61778"],["-52.21764","-31.74500"],["-54.14077","-34.66466"],["-56.15834","-34.92722"],["-56.67834","-36.92361"],["-58.30112","-38.48500"],["-62.06875","-39.50848"],["-62.39001","-40.90195"],["-65.13014","-40.84417"],["-65.24945","-44.31306"],["-67.58435","-46.00030"],["-65.78979","-47.96584"],["-68.94112","-50.38806"],["-68.99014","-51.62445"],["-72.11501","-53.68764"],["-74.28924","-50.48049"],["-74.74139","-47.71146"],["-72.61389","-44.47278"],["-73.99432","-40.96695"],["-73.22404","-39.41688"],["-73.67709","-37.34729"],["-71.44667","-32.66500"],["-71.69585","-30.50667"],["-70.91389","-27.62445"],["-70.05334","-21.42565"],["-70.31202","-18.43750"],["-71.49424","-17.30223"],["-75.05139","-15.46597"],["-76.39480","-13.88417"],["-78.99459","-8.21965"],["-81.17473","-6.08667"],["-81.27640","-4.28083"],["-79.95632","-3.20778"],["-80.91279","-1.03653"],["-80.10084","0.77028"],["-78.88929","1.23837"],["-77.43445","4.03139"],["-77.88972","7.22889"]]]},"properties":{"CONTINENT":"South America"}},{"type":"Feature","geometry":{"type":"MultiPolygon","coordinates":[[[["177.91779","-38.94280"],["175.95523","-41.25528"],["173.75165","-39.27000"],["174.94025","-38.10111"],["177.91779","-38.94280"]]],[[["171.18524","-44.93833"],["169.45801","-46.62333"],["166.47690","-45.80972"],["168.37233","-44.04056"],["171.15166","-42.56042"],["172.63025","-40.51056"],["174.23636","-41.83722"],["171.18524","-44.93833"]]]]},"properties":{"CONTINENT":"Oceania"}},{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[["151.54025","-24.04583"],["153.18192","-25.94944"],["153.62419","-28.66104"],["152.52969","-32.40361"],["151.45456","-33.31681"],["149.97163","-37.52222"],["146.87357","-38.65166"],["143.54295","-38.85923"],["140.52997","-38.00028"],["138.09225","-34.13493"],["135.49586","-34.61708"],["134.18414","-32.48666"],["131.14859","-31.47403"],["125.97227","-32.26674"],["123.73499","-33.77972"],["120.00499","-33.92889"],["117.93414","-35.12534"],["115.00895","-34.26243"],["115.73998","-31.86806"],["113.64346","-26.65431"],["113.38971","-24.42944"],["114.03027","-21.84167"],["116.70749","-20.64917"],["121.02748","-19.59222"],["122.95623","-16.58681"],["126.85790","-13.75097"],["129.08942","-14.89944"],["130.57927","-12.40465"],["132.67198","-11.50813"],["135.23135","-12.29445"],["135.45135","-14.93278"],["136.76581","-15.90445"],["140.83330","-17.45194"],["141.66553","-15.02653"],["141.59412","-12.53167"],["142.78830","-11.08056"],["143.78220","-14.41333"],["145.31580","-14.94555"],["146.27762","-18.88701"],["147.43192","-19.41236"],["150.81912","-22.73194"],["151.54025","-24.04583"]]]},"properties":{"CONTINENT":"Australia"}}]}')},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _pxto=__webpack_require__(163);var _pxto2=_interopRequireDefault(_pxto);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var em=(0,_pxto2.default)("em");exports.default=em;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=function(string,suffix){return string.substr(-suffix.length)===suffix};module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ratioNames=undefined;var _stripUnit=__webpack_require__(108);var _stripUnit2=_interopRequireDefault(_stripUnit);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var ratioNames={minorSecond:1.067,majorSecond:1.125,minorThird:1.2,majorThird:1.25,perfectFourth:1.333,augFourth:1.414,perfectFifth:1.5,minorSixth:1.6,goldenSection:1.618,majorSixth:1.667,minorSeventh:1.778,majorSeventh:1.875,octave:2,majorTenth:2.5,majorEleventh:2.667,majorTwelfth:3,doubleOctave:4};function modularScale(steps){var base=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"1em";var ratio=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"perfectFourth";if(typeof steps!=="number"){throw new Error("Please provide a number of steps to the modularScale helper.")}if(typeof ratio==="string"&&!ratioNames[ratio]){throw new Error("Please pass a number or one of the predefined scales to the modularScale helper as the ratio.")}var realBase=typeof base==="string"?(0,_stripUnit2.default)(base):base;var realRatio=typeof ratio==="string"?ratioNames[ratio]:ratio;if(typeof realBase==="string"){throw new Error('Invalid value passed as base to modularScale, expected number or em string but got "'+base+'"')}return realBase*Math.pow(realRatio,steps)+"em"}exports.ratioNames=ratioNames;exports.default=modularScale},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _pxto=__webpack_require__(163);var _pxto2=_interopRequireDefault(_pxto);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var rem=(0,_pxto2.default)("rem");exports.default=rem;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function clearFix(){var _ref;var parent=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"&";var pseudoSelector=parent+"::after";return _ref={},_ref[pseudoSelector]={clear:"both",content:'""',display:"table"},_ref}exports.default=clearFix;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function ellipsis(){var width=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"100%";return{display:"inline-block",maxWidth:width,overflow:"hidden",textOverflow:"ellipsis",whiteSpace:"nowrap",wordWrap:"normal"}}exports.default=ellipsis;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function generateFileReferences(fontFilePath,fileFormats){var fileFontReferences=fileFormats.map((function(format){return'url("'+fontFilePath+"."+format+'")'}));return fileFontReferences.join(", ")}function generateLocalReferences(localFonts){var localFontReferences=localFonts.map((function(font){return'local("'+font+'")'}));return localFontReferences.join(", ")}function generateSources(fontFilePath,localFonts,fileFormats){var fontReferences=[];if(localFonts)fontReferences.push(generateLocalReferences(localFonts));if(fontFilePath){fontReferences.push(generateFileReferences(fontFilePath,fileFormats))}return fontReferences.join(", ")}function fontFace(_ref){var fontFamily=_ref.fontFamily,fontFilePath=_ref.fontFilePath,fontStretch=_ref.fontStretch,fontStyle=_ref.fontStyle,fontVariant=_ref.fontVariant,fontWeight=_ref.fontWeight,_ref$fileFormats=_ref.fileFormats,fileFormats=_ref$fileFormats===undefined?["eot","woff2","woff","ttf","svg"]:_ref$fileFormats,localFonts=_ref.localFonts,unicodeRange=_ref.unicodeRange;if(!fontFamily)throw new Error("fontFace expects a name of a font-family.");if(!fontFilePath&&!localFonts){throw new Error("fontFace expects either the path to the font file(s) or a name of a local copy.")}if(localFonts&&!Array.isArray(localFonts)){throw new Error("fontFace expects localFonts to be an array.")}if(!Array.isArray(fileFormats)){throw new Error("fontFace expects fileFormats to be an array.")}var fontFaceDeclaration={"@font-face":{fontFamily:fontFamily,src:generateSources(fontFilePath,localFonts,fileFormats),unicodeRange:unicodeRange,fontStretch:fontStretch,fontStyle:fontStyle,fontVariant:fontVariant,fontWeight:fontWeight}};return JSON.parse(JSON.stringify(fontFaceDeclaration))}exports.default=fontFace;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hideText(){return{textIndent:"101%",overflow:"hidden",whiteSpace:"nowrap"}}exports.default=hideText;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hideVisually(){return{border:"0",clip:"rect(0 0 0 0)",clipPath:"inset(50%)",height:"1px",margin:"-1px",overflow:"hidden",padding:"0",position:"absolute",whiteSpace:"nowrap",width:"1px"}}exports.default=hideVisually;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _opinionatedRules,_abbrTitle,_unopinionatedRules;var opinionatedRules=(_opinionatedRules={html:{fontFamily:"sans-serif"},body:{margin:"0"}},_opinionatedRules["a:active,\n  a:hover"]={outlineWidth:"0"},_opinionatedRules["button,\n  input,\n  optgroup,\n  select,\n  textarea"]={fontFamily:"sans-serif",fontSize:"100%",lineHeight:"1.15"},_opinionatedRules);var unopinionatedRules=(_unopinionatedRules={html:{lineHeight:"1.15",textSizeAdjust:"100%"}},_unopinionatedRules["article,\n  aside,\n  footer,\n  header,\n  nav,\n  section"]={display:"block"},_unopinionatedRules.h1={fontSize:"2em",margin:"0.67em 0"},_unopinionatedRules["figcaption,\n  figure,\n  main"]={display:"block"},_unopinionatedRules.figure={margin:"1em 40px"},_unopinionatedRules.hr={boxSizing:"content-box",height:"0",overflow:"visible"},_unopinionatedRules.pre={fontFamily:"monospace, monospace",fontSize:"1em"},_unopinionatedRules.a={"background-color":"transparent","-webkit-text-decoration-skip":"objects"},_unopinionatedRules["abbr[title]"]=(_abbrTitle={borderBottom:"none",textDecoration:"underline"},_abbrTitle["textDecoration"]="underline dotted",_abbrTitle),_unopinionatedRules["b,\n  strong"]={fontWeight:"inherit"},_unopinionatedRules["code,\n  kbd,\n  samp"]={fontFamily:"monospace, monospace",fontSize:"1em"},_unopinionatedRules.dfn={fontStyle:"italic"},_unopinionatedRules.mark={backgroundColor:"#ff0",color:"#000"},_unopinionatedRules.small={fontSize:"80%"},_unopinionatedRules["sub,\n  sup"]={fontSize:"75%",lineHeight:"0",position:"relative",verticalAlign:"baseline"},_unopinionatedRules.sub={bottom:"-0.25em"},_unopinionatedRules.sup={top:"-0.5em"},_unopinionatedRules["audio,\n  video"]={display:"inline-block"},_unopinionatedRules["audio:not([controls])"]={display:"none",height:"0"},_unopinionatedRules.img={borderStyle:"none"},_unopinionatedRules["svg:not(:root)"]={overflow:"hidden"},_unopinionatedRules["button,\n  input,\n  optgroup,\n  select,\n  textarea"]={margin:"0"},_unopinionatedRules["button,\n  input"]={overflow:"visible"},_unopinionatedRules["button,\n  select"]={textTransform:"none"},_unopinionatedRules['button,\n  html [type="button"],\n  [type="reset"],\n  [type="submit"]']={"-webkit-appearance":"button"},_unopinionatedRules['button::-moz-focus-inner,\n  [type="button"]::-moz-focus-inner,\n  [type="reset"]::-moz-focus-inner,\n  [type="submit"]::-moz-focus-inner']={borderStyle:"none",padding:"0"},_unopinionatedRules['button:-moz-focusring,\n  [type="button"]:-moz-focusring,\n  [type="reset"]:-moz-focusring,\n  [type="submit"]:-moz-focusring']={outline:"1px dotted ButtonText"},_unopinionatedRules.fieldset={border:"1px solid #c0c0c0",margin:"0 2px",padding:"0.35em 0.625em 0.75em"},_unopinionatedRules.legend={boxSizing:"border-box",color:"inherit",display:"table",maxWidth:"100%",padding:"0",whiteSpace:"normal"},_unopinionatedRules.progress={display:"inline-block",verticalAlign:"baseline"},_unopinionatedRules.textarea={overflow:"auto"},_unopinionatedRules['[type="checkbox"],\n  [type="radio"]']={boxSizing:"border-box",padding:"0"},_unopinionatedRules['[type="number"]::-webkit-inner-spin-button,\n  [type="number"]::-webkit-outer-spin-button']={height:"auto"},_unopinionatedRules['[type="search"]']={"-webkit-appearance":"textfield",outlineOffset:"-2px"},_unopinionatedRules['[type="search"]::-webkit-search-cancel-button,\n  [type="search"]::-webkit-search-decoration']={"-webkit-appearance":"none"},_unopinionatedRules["::-webkit-file-upload-button"]={"-webkit-appearance":"button",font:"inherit"},_unopinionatedRules["details,\n  menu"]={display:"block"},_unopinionatedRules.summary={display:"list-item"},_unopinionatedRules.canvas={display:"inline-block"},_unopinionatedRules.template={display:"none"},_unopinionatedRules["[hidden]"]={display:"none"},_unopinionatedRules);function mergeRules(baseRules,additionalRules){var mergedRules=_extends({},baseRules);Object.keys(additionalRules).forEach((function(key){if(mergedRules[key]){mergedRules[key]=_extends({},mergedRules[key],additionalRules[key])}else{mergedRules[key]=_extends({},additionalRules[key])}}));return mergedRules}function normalize(excludeOpinionated){if(excludeOpinionated)return unopinionatedRules;return mergeRules(unopinionatedRules,opinionatedRules)}exports.default=normalize;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};function placeholder(styles){var _ref;var parent=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"&";return _ref={},_ref[parent+"::-webkit-input-placeholder"]=_extends({},styles),_ref[parent+":-moz-placeholder"]=_extends({},styles),_ref[parent+"::-moz-placeholder"]=_extends({},styles),_ref[parent+":-ms-input-placeholder"]=_extends({},styles),_ref}exports.default=placeholder;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _templateObject=_taggedTemplateLiteralLoose(["radial-gradient(","","","",")"],["radial-gradient(","","","",")"]);function _taggedTemplateLiteralLoose(strings,raw){strings.raw=raw;return strings}function parseFallback(colorStops){return colorStops[0].split(" ")[0]}function constructGradientValue(literals){var template="";for(var i=0;i<literals.length;i+=1){template+=literals[i];if(i===3&&(arguments.length<=i+1?undefined:arguments[i+1])&&((arguments.length<=1?undefined:arguments[1])||(arguments.length<=2?undefined:arguments[2])||(arguments.length<=3?undefined:arguments[3]))){template=template.slice(0,-1);template+=", "+(arguments.length<=i+1?undefined:arguments[i+1])}else if(i===3&&(arguments.length<=i+1?undefined:arguments[i+1])&&!(arguments.length<=1?undefined:arguments[1])&&!(arguments.length<=2?undefined:arguments[2])&&!(arguments.length<=3?undefined:arguments[3])){template+=""+(arguments.length<=i+1?undefined:arguments[i+1])}else if(arguments.length<=i+1?undefined:arguments[i+1]){template+=(arguments.length<=i+1?undefined:arguments[i+1])+" "}}return template.trim()}function radialGradient(_ref){var colorStops=_ref.colorStops,extent=_ref.extent,fallback=_ref.fallback,position=_ref.position,shape=_ref.shape;if(!colorStops||colorStops.length<2){throw new Error("radialGradient requries at least 2 color-stops to properly render.")}return{backgroundColor:fallback||parseFallback(colorStops),backgroundImage:constructGradientValue(_templateObject,position,shape,extent,colorStops.join(", "))}}exports.default=radialGradient;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hiDPI=__webpack_require__(164);var _hiDPI2=_interopRequireDefault(_hiDPI);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function retinaImage(filename,backgroundSize){var extension=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"png";var _ref;var retinaFilename=arguments[3];var retinaSuffix=arguments.length>4&&arguments[4]!==undefined?arguments[4]:"_2x";if(!filename){throw new Error("Please supply a filename to retinaImage() as the first argument.")}var ext=extension.replace(/^\./,"");var rFilename=retinaFilename?retinaFilename+"."+ext:""+filename+retinaSuffix+"."+ext;return _ref={backgroundImage:"url("+filename+"."+ext+")"},_ref[(0,_hiDPI2.default)()]={backgroundImage:"url("+rFilename+")",backgroundSize:backgroundSize},_ref}exports.default=retinaImage;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};function selection(styles){var _ref;var parent=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"";return _ref={},_ref[parent+"::-moz-selection"]=_extends({},styles),_ref[parent+"::selection"]=_extends({},styles),_ref}exports.default=selection;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var functionsMap={easeInBack:"cubic-bezier(0.600, -0.280, 0.735, 0.045)",easeInCirc:"cubic-bezier(0.600,  0.040, 0.980, 0.335)",easeInCubic:"cubic-bezier(0.550,  0.055, 0.675, 0.190)",easeInExpo:"cubic-bezier(0.950,  0.050, 0.795, 0.035)",easeInQuad:"cubic-bezier(0.550,  0.085, 0.680, 0.530)",easeInQuart:"cubic-bezier(0.895,  0.030, 0.685, 0.220)",easeInQuint:"cubic-bezier(0.755,  0.050, 0.855, 0.060)",easeInSine:"cubic-bezier(0.470,  0.000, 0.745, 0.715)",easeOutBack:"cubic-bezier(0.175,  0.885, 0.320, 1.275)",easeOutCubic:"cubic-bezier(0.215,  0.610, 0.355, 1.000)",easeOutCirc:"cubic-bezier(0.075,  0.820, 0.165, 1.000)",easeOutExpo:"cubic-bezier(0.190,  1.000, 0.220, 1.000)",easeOutQuad:"cubic-bezier(0.250,  0.460, 0.450, 0.940)",easeOutQuart:"cubic-bezier(0.165,  0.840, 0.440, 1.000)",easeOutQuint:"cubic-bezier(0.230,  1.000, 0.320, 1.000)",easeOutSine:"cubic-bezier(0.390,  0.575, 0.565, 1.000)",easeInOutBack:"cubic-bezier(0.680, -0.550, 0.265, 1.550)",easeInOutCirc:"cubic-bezier(0.785,  0.135, 0.150, 0.860)",easeInOutCubic:"cubic-bezier(0.645,  0.045, 0.355, 1.000)",easeInOutExpo:"cubic-bezier(1.000,  0.000, 0.000, 1.000)",easeInOutQuad:"cubic-bezier(0.455,  0.030, 0.515, 0.955)",easeInOutQuart:"cubic-bezier(0.770,  0.000, 0.175, 1.000)",easeInOutQuint:"cubic-bezier(0.860,  0.000, 0.070, 1.000)",easeInOutSine:"cubic-bezier(0.445,  0.050, 0.550, 0.950)"};function timingFunctions(timingFunction){return functionsMap[timingFunction]}exports.default=timingFunctions;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var getBorderWidth=function getBorderWidth(pointingDirection,height,width){switch(pointingDirection){case"top":return"0 "+width/2+"px "+height+"px "+width/2+"px";case"left":return height/2+"px "+width+"px "+height/2+"px 0";case"bottom":return height+"px "+width/2+"px 0 "+width/2+"px";case"right":return height/2+"px 0 "+height/2+"px "+width+"px";default:throw new Error("Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.")}};var reverseDirection={left:"Right",right:"Left",top:"Bottom",bottom:"Top"};function triangle(_ref){var _ref2;var pointingDirection=_ref.pointingDirection,height=_ref.height,width=_ref.width,foregroundColor=_ref.foregroundColor,_ref$backgroundColor=_ref.backgroundColor,backgroundColor=_ref$backgroundColor===undefined?"transparent":_ref$backgroundColor;var unitlessHeight=parseFloat(height);var unitlessWidth=parseFloat(width);if(isNaN(unitlessHeight)||isNaN(unitlessWidth)){throw new Error("Passed an invalid value to `height` or `width`. Please provide a pixel based unit")}return _ref2={borderColor:backgroundColor,width:"0",height:"0",borderWidth:getBorderWidth(pointingDirection,unitlessHeight,unitlessWidth),borderStyle:"solid"},_ref2["border"+reverseDirection[pointingDirection]+"Color"]=foregroundColor+" !important",_ref2}exports.default=triangle;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function wordWrap(){var wrap=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"break-word";var wordBreak=wrap==="break-word"?"break-all":wrap;return{overflowWrap:wrap,wordWrap:wrap,wordBreak:wordBreak}}exports.default=wordWrap;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function adjustHue(degree,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{hue:(hslColor.hue+degree)%360}))}var curriedAdjustHue=(0,_curry2.default)(adjustHue);exports.default=curriedAdjustHue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var namedColorMap={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"639",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};function nameToHex(color){if(typeof color!=="string")return color;var normalizedColorName=color.toLowerCase();return namedColorMap[normalizedColorName]?"#"+namedColorMap[normalizedColorName]:color}exports.default=nameToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function rgbToHsl(color){var red=color.red/255;var green=color.green/255;var blue=color.blue/255;var max=Math.max(red,green,blue);var min=Math.min(red,green,blue);var lightness=(max+min)/2;if(max===min){if(color.alpha!==undefined){return{hue:0,saturation:0,lightness:lightness,alpha:color.alpha}}else{return{hue:0,saturation:0,lightness:lightness}}}var hue=void 0;var delta=max-min;var saturation=lightness>.5?delta/(2-max-min):delta/(max+min);switch(max){case red:hue=(green-blue)/delta+(green<blue?6:0);break;case green:hue=(blue-red)/delta+2;break;default:hue=(red-green)/delta+4;break}hue*=60;if(color.alpha!==undefined){return{hue:hue,saturation:saturation,lightness:lightness,alpha:color.alpha}}return{hue:hue,saturation:saturation,lightness:lightness}}exports.default=rgbToHsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function complement(color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{hue:(hslColor.hue+180)%360}))}exports.default=complement;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(59);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function darken(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{lightness:(0,_guard2.default)(0,1,hslColor.lightness-amount)}))}var curriedDarken=(0,_curry2.default)(darken);exports.default=curriedDarken;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(59);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function desaturate(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{saturation:(0,_guard2.default)(0,1,hslColor.saturation-amount)}))}var curriedDesaturate=(0,_curry2.default)(desaturate);exports.default=curriedDesaturate;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function grayscale(color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{saturation:0}))}exports.default=grayscale;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function invert(color){var value=(0,_parseToRgb2.default)(color);return(0,_toColorString2.default)(_extends({},value,{red:255-value.red,green:255-value.green,blue:255-value.blue}))}exports.default=invert;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(59);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function lighten(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{lightness:(0,_guard2.default)(0,1,hslColor.lightness+amount)}))}var curriedLighten=(0,_curry2.default)(lighten);exports.default=curriedLighten;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(69);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _guard=__webpack_require__(59);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function opacify(amount,color){var parsedColor=(0,_parseToRgb2.default)(color);var alpha=typeof parsedColor.alpha==="number"?parsedColor.alpha:1;var colorWithAlpha=_extends({},parsedColor,{alpha:(0,_guard2.default)(0,1,(alpha*100+amount*100)/100)});return(0,_rgba2.default)(colorWithAlpha)}var curriedOpacify=(0,_curry2.default)(opacify);exports.default=curriedOpacify;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _getLuminance=__webpack_require__(170);var _getLuminance2=_interopRequireDefault(_getLuminance);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function readableColor(color){return(0,_getLuminance2.default)(color)>.179?"#000":"#fff"}var curriedReadableColor=(0,_curry2.default)(readableColor);exports.default=curriedReadableColor;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(59);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function saturate(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{saturation:(0,_guard2.default)(0,1,hslColor.saturation+amount)}))}var curriedSaturate=(0,_curry2.default)(saturate);exports.default=curriedSaturate;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function setHue(hue,color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{hue:hue}))}var curriedSetHue=(0,_curry2.default)(setHue);exports.default=curriedSetHue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function setLightness(lightness,color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{lightness:lightness}))}var curriedSetLightness=(0,_curry2.default)(setLightness);exports.default=curriedSetLightness;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(48);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(45);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function setSaturation(saturation,color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{saturation:saturation}))}var curriedSetSaturation=(0,_curry2.default)(setSaturation);exports.default=curriedSetSaturation;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _mix=__webpack_require__(111);var _mix2=_interopRequireDefault(_mix);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function shade(percentage,color){if(typeof percentage!=="number"||percentage>1||percentage<-1){throw new Error("Passed an incorrect argument to shade, please pass a percentage less than or equal to 1 and larger than or equal to -1.")}if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}return(0,_mix2.default)(percentage,color,"rgb(0, 0, 0)")}var curriedShade=(0,_curry2.default)(shade);exports.default=curriedShade;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _mix=__webpack_require__(111);var _mix2=_interopRequireDefault(_mix);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function tint(percentage,color){if(typeof percentage!=="number"||percentage>1||percentage<-1){throw new Error("Passed an incorrect argument to tint, please pass a percentage less than or equal to 1 and larger than or equal to -1.")}if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}return(0,_mix2.default)(percentage,color,"rgb(255, 255, 255)")}var curriedTint=(0,_curry2.default)(tint);exports.default=curriedTint;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(69);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(53);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _guard=__webpack_require__(59);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(41);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function transparentize(amount,color){var parsedColor=(0,_parseToRgb2.default)(color);var alpha=typeof parsedColor.alpha==="number"?parsedColor.alpha:1;var colorWithAlpha=_extends({},parsedColor,{alpha:(0,_guard2.default)(0,1,(alpha*100-amount*100)/100)});return(0,_rgba2.default)(colorWithAlpha)}var curriedTransparentize=(0,_curry2.default)(transparentize);exports.default=curriedTransparentize;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function animation(){for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}var multiMode=Array.isArray(args[0]);if(!multiMode&&args.length>8){throw new Error("The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation")}var code=args.map((function(arg){if(multiMode&&!Array.isArray(arg)||!multiMode&&Array.isArray(arg)){throw new Error("To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')")}if(Array.isArray(arg)&&arg.length>8){throw new Error("The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation")}return Array.isArray(arg)?arg.join(" "):arg})).join(", ");return{animation:code}}exports.default=animation;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function backgroundImages(){for(var _len=arguments.length,properties=Array(_len),_key=0;_key<_len;_key++){properties[_key]=arguments[_key]}return{backgroundImage:properties.join(", ")}}exports.default=backgroundImages;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function backgrounds(){for(var _len=arguments.length,properties=Array(_len),_key=0;_key<_len;_key++){properties[_key]=arguments[_key]}return{background:properties.join(", ")}}exports.default=backgrounds;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderColor(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["borderColor"].concat(values))}exports.default=borderColor;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _capitalizeString=__webpack_require__(162);var _capitalizeString2=_interopRequireDefault(_capitalizeString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderRadius(side,radius){var uppercaseSide=(0,_capitalizeString2.default)(side);if(!radius&&radius!==0){throw new Error("borderRadius expects a radius value as a string or number as the second argument.")}if(uppercaseSide==="Top"||uppercaseSide==="Bottom"){var _ref;return _ref={},_ref["border"+uppercaseSide+"RightRadius"]=radius,_ref["border"+uppercaseSide+"LeftRadius"]=radius,_ref}if(uppercaseSide==="Left"||uppercaseSide==="Right"){var _ref2;return _ref2={},_ref2["borderTop"+uppercaseSide+"Radius"]=radius,_ref2["borderBottom"+uppercaseSide+"Radius"]=radius,_ref2}throw new Error('borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.')}exports.default=borderRadius;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderStyle(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["borderStyle"].concat(values))}exports.default=borderStyle;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderWidth(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["borderWidth"].concat(values))}exports.default=borderWidth;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _statefulSelectors=__webpack_require__(171);var _statefulSelectors2=_interopRequireDefault(_statefulSelectors);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var stateMap=[undefined,null,"active","focus","hover"];function template(state){return"button"+state+',\n  input[type="button"]'+state+',\n  input[type="reset"]'+state+',\n  input[type="submit"]'+state}function buttons(){for(var _len=arguments.length,states=Array(_len),_key=0;_key<_len;_key++){states[_key]=arguments[_key]}return(0,_statefulSelectors2.default)(states,template,stateMap)}exports.default=buttons;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function margin(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["margin"].concat(values))}exports.default=margin;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function padding(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["padding"].concat(values))}exports.default=padding;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _directionalProperty=__webpack_require__(56);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var positionMap=["absolute","fixed","relative","static","sticky"];function position(positionKeyword){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}if(positionMap.indexOf(positionKeyword)>=0){return _extends({position:positionKeyword},_directionalProperty2.default.apply(undefined,[""].concat(values)))}else{var firstValue=positionKeyword;return _directionalProperty2.default.apply(undefined,["",firstValue].concat(values))}}exports.default=position;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function size(height){var width=arguments.length>1&&arguments[1]!==undefined?arguments[1]:height;return{height:height,width:width}}exports.default=size;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _statefulSelectors=__webpack_require__(171);var _statefulSelectors2=_interopRequireDefault(_statefulSelectors);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var stateMap=[undefined,null,"active","focus","hover"];function template(state){return'input[type="color"]'+state+',\n    input[type="date"]'+state+',\n    input[type="datetime"]'+state+',\n    input[type="datetime-local"]'+state+',\n    input[type="email"]'+state+',\n    input[type="month"]'+state+',\n    input[type="number"]'+state+',\n    input[type="password"]'+state+',\n    input[type="search"]'+state+',\n    input[type="tel"]'+state+',\n    input[type="text"]'+state+',\n    input[type="time"]'+state+',\n    input[type="url"]'+state+',\n    input[type="week"]'+state+",\n    input:not([type])"+state+",\n    textarea"+state}function textInputs(){for(var _len=arguments.length,states=Array(_len),_key=0;_key<_len;_key++){states[_key]=arguments[_key]}return(0,_statefulSelectors2.default)(states,template,stateMap)}exports.default=textInputs;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function transitions(){for(var _len=arguments.length,properties=Array(_len),_key=0;_key<_len;_key++){properties[_key]=arguments[_key]}return{transition:properties.join(", ")}}exports.default=transitions;module.exports=exports["default"]}])]);