/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["triggersActionsUi_bundle_jsonpfunction"]=window["triggersActionsUi_bundle_jsonpfunction"]||[]).push([[7],{71:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"AlertEdit",(function(){return AlertEdit}));__webpack_require__.d(__webpack_exports__,"default",(function(){return AlertEdit}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(8);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__);var lodash__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_4__);var _alert_form__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(147);var _alert_reducer__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(100);var _lib_alert_api__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(92);var _components_health_check__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(102);var _context_health_context__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(94);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(34);var _confirm_alert_close__WEBPACK_IMPORTED_MODULE_11__=__webpack_require__(145);var _has_alert_changed__WEBPACK_IMPORTED_MODULE_12__=__webpack_require__(146);var _lib_value_validators__WEBPACK_IMPORTED_MODULE_13__=__webpack_require__(5);const AlertEdit=({initialAlert:initialAlert,onClose:onClose,reloadAlerts:reloadAlerts,alertTypeRegistry:alertTypeRegistry,actionTypeRegistry:actionTypeRegistry,metadata:metadata})=>{const[{alert:alert},dispatch]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useReducer"])(_alert_reducer__WEBPACK_IMPORTED_MODULE_6__["a"],{alert:Object(lodash__WEBPACK_IMPORTED_MODULE_3__["cloneDeep"])(initialAlert)});const[isSaving,setIsSaving]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const[hasActionsDisabled,setHasActionsDisabled]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const[hasActionsWithBrokenConnector,setHasActionsWithBrokenConnector]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const[isConfirmAlertCloseModalOpen,setIsConfirmAlertCloseModalOpen]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const{http:http,notifications:{toasts:toasts}}=Object(_common_lib_kibana__WEBPACK_IMPORTED_MODULE_10__["b"])().services;const setAlert=value=>{dispatch({command:{type:"setAlert"},payload:{key:"alert",value:value}})};const alertType=alertTypeRegistry.get(alert.alertTypeId);const{alertActionsErrors:alertActionsErrors,alertBaseErrors:alertBaseErrors,alertErrors:alertErrors,alertParamsErrors:alertParamsErrors}=Object(_alert_form__WEBPACK_IMPORTED_MODULE_5__["b"])(alert,actionTypeRegistry,alertType);const checkForChangesAndCloseFlyout=()=>{if(Object(_has_alert_changed__WEBPACK_IMPORTED_MODULE_12__["a"])(alert,initialAlert,true)){setIsConfirmAlertCloseModalOpen(true)}else{onClose()}};async function onSaveAlert(){try{if(Object(_alert_form__WEBPACK_IMPORTED_MODULE_5__["c"])(alert,alertErrors,alertActionsErrors)&&!hasActionsWithBrokenConnector){const newAlert=await Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_7__["t"])({http:http,alert:alert,id:alert.id});toasts.addSuccess(_kbn_i18n__WEBPACK_IMPORTED_MODULE_4__["i18n"].translate("xpack.triggersActionsUI.sections.alertEdit.saveSuccessNotificationText",{defaultMessage:"Updated '{alertName}'",values:{alertName:newAlert.name}}));return newAlert}else{setAlert(Object(_lib_value_validators__WEBPACK_IMPORTED_MODULE_13__["a"])(alert,alertParamsErrors,alertBaseErrors,alertActionsErrors))}}catch(errorRes){var _errorRes$body$messag,_errorRes$body;toasts.addDanger((_errorRes$body$messag=(_errorRes$body=errorRes.body)===null||_errorRes$body===void 0?void 0:_errorRes$body.message)!==null&&_errorRes$body$messag!==void 0?_errorRes$body$messag:_kbn_i18n__WEBPACK_IMPORTED_MODULE_4__["i18n"].translate("xpack.triggersActionsUI.sections.alertEdit.saveErrorNotificationText",{defaultMessage:"Cannot update alert."}))}}return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiPortal"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlyout"],{onClose:checkForChangesAndCloseFlyout,"aria-labelledby":"flyoutAlertEditTitle",size:"m",maxWidth:620},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlyoutHeader"],{hasBorder:true},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiTitle"],{size:"s","data-test-subj":"editAlertFlyoutTitle"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h3",{id:"flyoutTitle"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__["FormattedMessage"],{defaultMessage:"Edit alert",id:"xpack.triggersActionsUI.sections.alertEdit.flyoutTitle"})))),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_context_health_context__WEBPACK_IMPORTED_MODULE_9__["a"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_health_check__WEBPACK_IMPORTED_MODULE_8__["a"],{inFlyout:true,waitForCheck:true},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlyoutBody"],null,hasActionsDisabled&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0__["Fragment"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiCallOut"],{size:"s",color:"danger",iconType:"alert","data-test-subj":"hasActionsDisabled",title:_kbn_i18n__WEBPACK_IMPORTED_MODULE_4__["i18n"].translate("xpack.triggersActionsUI.sections.alertEdit.disabledActionsWarningTitle",{defaultMessage:"This alert has actions that are disabled"})}),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiSpacer"],null)),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_alert_form__WEBPACK_IMPORTED_MODULE_5__["a"],{alert:alert,dispatch:dispatch,errors:alertErrors,actionTypeRegistry:actionTypeRegistry,alertTypeRegistry:alertTypeRegistry,canChangeTrigger:false,setHasActionsDisabled:setHasActionsDisabled,setHasActionsWithBrokenConnector:setHasActionsWithBrokenConnector,operation:"i18n.translate('xpack.triggersActionsUI.sections.alertEdit.operationName', { defaultMessage: 'edit', })",metadata:metadata})),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlyoutFooter"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlexGroup"],{justifyContent:"spaceBetween"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiButtonEmpty"],{"data-test-subj":"cancelSaveEditedAlertButton",onClick:()=>checkForChangesAndCloseFlyout()},_kbn_i18n__WEBPACK_IMPORTED_MODULE_4__["i18n"].translate("xpack.triggersActionsUI.sections.alertEdit.cancelButtonLabel",{defaultMessage:"Cancel"}))),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiButton"],{fill:true,color:"secondary","data-test-subj":"saveEditedAlertButton",type:"submit",iconType:"check",isLoading:isSaving,onClick:async()=>{setIsSaving(true);const savedAlert=await onSaveAlert();setIsSaving(false);if(savedAlert){onClose();if(reloadAlerts){reloadAlerts()}}}},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertEdit.saveButtonLabel",defaultMessage:"Save"}))))))),isConfirmAlertCloseModalOpen&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_confirm_alert_close__WEBPACK_IMPORTED_MODULE_11__["a"],{onConfirm:()=>{setIsConfirmAlertCloseModalOpen(false);onClose()},onCancel:()=>{setIsConfirmAlertCloseModalOpen(false)}})))}}}]);