/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["triggersActionsUi_bundle_jsonpfunction"]=window["triggersActionsUi_bundle_jsonpfunction"]||[]).push([[2],{100:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return alertReducer}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);const alertReducer=(state,action)=>{const{alert:alert}=state;switch(action.command.type){case"setAlert":{const{key:key,value:value}=action.payload;if(key==="alert"){return{...state,alert:value}}else{return state}}case"setProperty":{const{key:key,value:value}=action.payload;if(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert[key],value)){return state}else{return{...state,alert:{...alert,[key]:value}}}}case"setScheduleProperty":{const{key:key,value:value}=action.payload;if(alert.schedule&&Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.schedule[key],value)){return state}else{return{...state,alert:{...alert,schedule:{...alert.schedule,[key]:value}}}}}case"setAlertParams":{const{key:key,value:value}=action.payload;if(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.params[key],value)){return state}else{return{...state,alert:{...alert,params:{...alert.params,[key]:value}}}}}case"setAlertActionParams":{const{key:key,value:value,index:index}=action.payload;if(index===undefined||alert.actions[index]==null||Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.actions[index][key],value)){return state}else{const oldAction=alert.actions.splice(index,1)[0];const updatedAction={...oldAction,params:{...oldAction.params,[key]:value}};alert.actions.splice(index,0,updatedAction);return{...state,alert:{...alert,actions:[...alert.actions]}}}}case"setAlertActionProperty":{const{key:key,value:value,index:index}=action.payload;if(index===undefined||Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.actions[index][key],value)){return state}else{const oldAction=alert.actions.splice(index,1)[0];const updatedAction={...oldAction,[key]:value};alert.actions.splice(index,0,updatedAction);return{...state,alert:{...alert,actions:[...alert.actions]}}}}}}},102:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HealthCheck}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var Option=__webpack_require__(91);var pipeable=__webpack_require__(93);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var alert_api=__webpack_require__(92);var health_check=__webpack_require__(125);var health_context=__webpack_require__(94);var kibana=__webpack_require__(34);var center_justified_spinner=__webpack_require__(36);const TRIGGERS_ACTIONS_UI_API_ROOT="/api/triggers_actions_ui";async function triggersActionsUiHealth({http:http}){return await http.get(`${TRIGGERS_ACTIONS_UI_API_ROOT}/_health`)}const HealthCheck=({children:children,waitForCheck:waitForCheck,inFlyout:inFlyout=false})=>{const{http:http,docLinks:docLinks}=Object(kibana["b"])().services;const{setLoadingHealthCheck:setLoadingHealthCheck}=Object(health_context["b"])();const[alertingHealth,setAlertingHealth]=external_kbnSharedDeps_React_default.a.useState(Option["none"]);external_kbnSharedDeps_React_default.a.useEffect(()=>{(async function(){setLoadingHealthCheck(true);const triggersActionsUiHealthStatus=await triggersActionsUiHealth({http:http});const healthStatus={...triggersActionsUiHealthStatus,isSufficientlySecure:false,hasPermanentEncryptionKey:false};if(healthStatus.isAlertsAvailable){const alertingHealthResult=await Object(alert_api["a"])({http:http});healthStatus.isSufficientlySecure=alertingHealthResult.isSufficientlySecure;healthStatus.hasPermanentEncryptionKey=alertingHealthResult.hasPermanentEncryptionKey}setAlertingHealth(Object(Option["some"])(healthStatus));setLoadingHealthCheck(false)})()},[http,setLoadingHealthCheck]);const className=inFlyout?"alertingFlyoutHealthCheck":"alertingHealthCheck";return Object(pipeable["pipe"])(alertingHealth,Object(Option["fold"])(()=>waitForCheck?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(center_justified_spinner["a"],null)):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children),healthCheck=>healthCheck!==null&&healthCheck!==void 0&&healthCheck.isSufficientlySecure&&healthCheck!==null&&healthCheck!==void 0&&healthCheck.hasPermanentEncryptionKey?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children):!healthCheck.isAlertsAvailable?external_kbnSharedDeps_React_default.a.createElement(AlertsError,{docLinks:docLinks,className:className}):!healthCheck.isSufficientlySecure&&!healthCheck.hasPermanentEncryptionKey?external_kbnSharedDeps_React_default.a.createElement(TlsAndEncryptionError,{docLinks:docLinks,className:className}):!healthCheck.hasPermanentEncryptionKey?external_kbnSharedDeps_React_default.a.createElement(EncryptionError,{docLinks:docLinks,className:className}):external_kbnSharedDeps_React_default.a.createElement(TlsError,{docLinks:docLinks,className:className})))};const EncryptionError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"actionNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.encryptionErrorTitle",defaultMessage:"Encrypted saved objects are not available"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.encryptionErrorBeforeKey",{defaultMessage:"To create an alert, set a value for "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.encryptedSavedObjects.encryptionKey"),external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.encryptionErrorAfterKey",{defaultMessage:" in your kibana.yml file and ensure the Encrypted Saved Objects plugin is enabled. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.generalSettings,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.encryptionErrorAction",{defaultMessage:"Learn how."}))))});const TlsError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"actionNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.tlsErrorTitle",defaultMessage:"You must enable Transport Layer Security"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsError",{defaultMessage:"Alerting relies on API keys, which require TLS between Elasticsearch and Kibana. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.security.kibanaTLS,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsErrorAction",{defaultMessage:"Learn how to enable TLS."}))))});const AlertsError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"alertsNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.alertsErrorTitle",defaultMessage:"You must enable Alerts and Actions"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.alertsError",{defaultMessage:"To create an alert, set alerts and actions plugins enabled. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.generalSettings,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.alertsErrorAction",{defaultMessage:"Learn how to enable Alerts and Actions."}))))});const TlsAndEncryptionError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"actionNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.tlsAndEncryptionErrorTitle",defaultMessage:"Additional setup required"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsAndEncryptionError",{defaultMessage:"You must enable Transport Layer Security between Kibana and Elasticsearch and configure an encryption key in your kibana.yml file. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.setupPrerequisites,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsAndEncryptionErrorAction",{defaultMessage:"Learn how"}))))})},124:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return transformActionVariables}));__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertProvidedActionVariables}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);function transformActionVariables(actionVariables){const alwaysProvidedVars=getAlwaysProvidedActionVariables();const contextVars=actionVariables.context?prefixKeys(actionVariables.context,"context."):[];const paramsVars=prefixKeys(actionVariables.params,"params.");const stateVars=prefixKeys(actionVariables.state,"state.");return alwaysProvidedVars.concat(contextVars,paramsVars,stateVars)}let AlertProvidedActionVariables;(function(AlertProvidedActionVariables){AlertProvidedActionVariables["alertId"]="alertId";AlertProvidedActionVariables["alertName"]="alertName";AlertProvidedActionVariables["spaceId"]="spaceId";AlertProvidedActionVariables["tags"]="tags";AlertProvidedActionVariables["alertInstanceId"]="alertInstanceId"})(AlertProvidedActionVariables||(AlertProvidedActionVariables={}));function prefixKeys(actionVariables,prefix){return actionVariables.map(actionVariable=>({...actionVariable,name:`${prefix}${actionVariable.name}`}))}function getAlwaysProvidedActionVariables(){const result=[];result.push({name:AlertProvidedActionVariables.alertId,description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.alertIdLabel",{defaultMessage:"The id of the alert."})});result.push({name:AlertProvidedActionVariables.alertName,description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.alertNameLabel",{defaultMessage:"The name of the alert."})});result.push({name:AlertProvidedActionVariables.spaceId,description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.spaceIdLabel",{defaultMessage:"The spaceId of the alert."})});result.push({name:AlertProvidedActionVariables.tags,description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.tagsLabel",{defaultMessage:"The tags of the alert."})});result.push({name:"date",description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.dateLabel",{defaultMessage:"The date the alert scheduled the action."})});result.push({name:"alertInstanceId",description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.alertInstanceIdLabel",{defaultMessage:"The alert instance id that scheduled actions for the alert."})});result.push({name:"alertActionGroup",description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.alertActionGroupLabel",{defaultMessage:"The alert action group that was used to scheduled actions for the alert."})});result.push({name:"alertActionSubgroup",description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.alertActionSubgroupLabel",{defaultMessage:"The alert action subgroup that was used to scheduled actions for the alert."})});result.push({name:"alertActionGroupName",description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.alertActionGroupNameLabel",{defaultMessage:"The human readable name of the alert action group that was used to scheduled actions for the alert."})});result.push({name:"kibanaBaseUrl",description:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.actionVariables.kibanaBaseUrlLabel",{defaultMessage:"The configured server.publicBaseUrl value or empty string if not configured."})});return result}},125:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(126);case"v7light":return __webpack_require__(128);case"v8dark":return __webpack_require__(130);case"v8light":return __webpack_require__(132)}},126:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(127);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},127:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},128:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(129);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},129:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},130:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(131);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},131:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},132:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(133);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},133:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},145:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ConfirmAlertClose}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(8);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_3__);const ConfirmAlertClose=({onConfirm:onConfirm,onCancel:onCancel})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiConfirmModal"],{title:_kbn_i18n__WEBPACK_IMPORTED_MODULE_3__["i18n"].translate("xpack.triggersActionsUI.sections.confirmAlertClose.confirmAlertCloseTitle",{defaultMessage:"Discard unsaved changes to alert?"}),onCancel:onCancel,onConfirm:onConfirm,confirmButtonText:_kbn_i18n__WEBPACK_IMPORTED_MODULE_3__["i18n"].translate("xpack.triggersActionsUI.sections.confirmAlertClose.confirmAlertCloseConfirmButtonText",{defaultMessage:"Discard changes"}),cancelButtonText:_kbn_i18n__WEBPACK_IMPORTED_MODULE_3__["i18n"].translate("xpack.triggersActionsUI.sections.confirmAlertClose.confirmAlertCloseCancelButtonText",{defaultMessage:"Cancel"}),defaultFocusedButton:"confirm","data-test-subj":"confirmAlertCloseModal"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p",null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.confirmAlertClose.confirmAlertCloseMessage",defaultMessage:"You can't recover unsaved changes."})))},146:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return hasAlertChanged}));__webpack_require__.d(__webpack_exports__,"b",(function(){return haveAlertParamsChanged}));var fast_deep_equal__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(196);var fast_deep_equal__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(fast_deep_equal__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);const DEEP_COMPARE_FIELDS=["tags","schedule","actions","notifyWhen"];function getNonNullCompareFields(alert){const{name:name,alertTypeId:alertTypeId,throttle:throttle}=alert;return{...!!(name&&name.length>0)?{name:name}:{},...!!(alertTypeId&&alertTypeId.length>0)?{alertTypeId:alertTypeId}:{},...!!(throttle&&throttle.length>0)?{throttle:throttle}:{}}}function hasAlertChanged(a,b,compareParams){let objectsAreEqual=fast_deep_equal__WEBPACK_IMPORTED_MODULE_0___default()(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["pick"])(a,DEEP_COMPARE_FIELDS),Object(lodash__WEBPACK_IMPORTED_MODULE_1__["pick"])(b,DEEP_COMPARE_FIELDS));if(compareParams){objectsAreEqual=objectsAreEqual&&fast_deep_equal__WEBPACK_IMPORTED_MODULE_0___default()(a.params,b.params)}const nonNullCompareFieldsAreEqual=fast_deep_equal__WEBPACK_IMPORTED_MODULE_0___default()(getNonNullCompareFields(a),getNonNullCompareFields(b));return!objectsAreEqual||!nonNullCompareFieldsAreEqual}function haveAlertParamsChanged(a,b){return!fast_deep_equal__WEBPACK_IMPORTED_MODULE_0___default()(a,b)}},147:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getAlertErrors}));__webpack_require__.d(__webpack_exports__,"c",(function(){return isValidAlert}));__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertForm}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_Lodash_=__webpack_require__(4);var parse_duration_=__webpack_require__(70);var alert_api=__webpack_require__(92);var get_time_options=__webpack_require__(21);var action_connector_form=__webpack_require__(22);var common_=__webpack_require__(7);var lib_capabilities=__webpack_require__(87);const SolutionFilter=({solutions:solutions,onChange:onChange})=>{const[selectedValues,setSelectedValues]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(onChange){onChange(selectedValues)}},[selectedValues]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",hasActiveFilters:selectedValues.length>0,numActiveFilters:selectedValues.length,numFilters:selectedValues.length,onClick:()=>setIsPopoverOpen(!isPopoverOpen),"data-test-subj":"solutionsFilterButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.solutionFilterLabel",defaultMessage:"Filter by use case"}))},external_kbnSharedDeps_React_default.a.createElement("div",{className:"euiFilterSelect__items"},[...solutions.entries()].map(([id,title])=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:id,onClick:()=>{const isPreviouslyChecked=selectedValues.includes(id);if(isPreviouslyChecked){setSelectedValues(selectedValues.filter(val=>val!==id))}else{setSelectedValues([...selectedValues,id])}},checked:selectedValues.includes(id)?"on":undefined,"data-test-subj":`solution${id}FilterOption`},title)))))};var alert_form=__webpack_require__(187);var kibana=__webpack_require__(34);var constants=__webpack_require__(3);let EventActionOptions;(function(EventActionOptions){EventActionOptions["TRIGGER"]="trigger";EventActionOptions["RESOLVE"]="resolve";EventActionOptions["ACKNOWLEDGE"]="acknowledge"})(EventActionOptions||(EventActionOptions={}));let SeverityActionOptions;(function(SeverityActionOptions){SeverityActionOptions["CRITICAL"]="critical";SeverityActionOptions["ERROR"]="error";SeverityActionOptions["WARNING"]="warning";SeverityActionOptions["INFO"]="info"})(SeverityActionOptions||(SeverityActionOptions={}));let ServerLogLevelOptions;(function(ServerLogLevelOptions){ServerLogLevelOptions["TRACE"]="trace";ServerLogLevelOptions["DEBUG"]="debug";ServerLogLevelOptions["INFO"]="info";ServerLogLevelOptions["WARN"]="warn";ServerLogLevelOptions["ERROR"]="error";ServerLogLevelOptions["FATAL"]="fatal"})(ServerLogLevelOptions||(ServerLogLevelOptions={}));var action_variables=__webpack_require__(124);const getDefaultsForActionParams=(actionTypeId,actionGroupId,isRecoveryActionGroup)=>{switch(actionTypeId){case".pagerduty":const pagerDutyDefaults={dedupKey:`{{${action_variables["a"].alertId}}}:{{${action_variables["a"].alertInstanceId}}}`,eventAction:EventActionOptions.TRIGGER};if(isRecoveryActionGroup){pagerDutyDefaults.eventAction=EventActionOptions.RESOLVE}return pagerDutyDefaults}};var Option=__webpack_require__(91);var pipeable=__webpack_require__(93);const DEFAULT_NOTIFY_WHEN_VALUE="onActionGroupChange";const NOTIFY_WHEN_OPTIONS=[{value:"onActionGroupChange",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onActionGroupChange.display",{defaultMessage:"Only on status change"}),"data-test-subj":"onActionGroupChange",dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Only on status change",id:"xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onActionGroupChange.label"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Actions run when the alert status changes.",id:"xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onActionGroupChange.description"}))))},{value:"onActiveAlert",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onActiveAlert.display",{defaultMessage:"Every time alert is active"}),"data-test-subj":"onActiveAlert",dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Every time alert is active",id:"xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onActiveAlert.label"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Actions run with every active alert interval.",id:"xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onActiveAlert.description"}))))},{value:"onThrottleInterval",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onThrottleInterval.display",{defaultMessage:"On a custom action interval"}),"data-test-subj":"onThrottleInterval",dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"On a custom action interval",id:"xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onThrottleInterval.label"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Actions run using the interval you set.",id:"xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.onThrottleInterval.description"}))))}];const AlertNotifyWhen=({alert:alert,throttle:throttle,throttleUnit:throttleUnit,onNotifyWhenChange:onNotifyWhenChange,onThrottleChange:onThrottleChange})=>{const[alertThrottle,setAlertThrottle]=Object(external_kbnSharedDeps_React_["useState"])(throttle||1);const[showCustomThrottleOpts,setShowCustomThrottleOpts]=Object(external_kbnSharedDeps_React_["useState"])(false);const[notifyWhenValue,setNotifyWhenValue]=Object(external_kbnSharedDeps_React_["useState"])(DEFAULT_NOTIFY_WHEN_VALUE);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(alert.notifyWhen){setNotifyWhenValue(alert.notifyWhen)}else{setNotifyWhenValue(alert.throttle?"onThrottleInterval":"onActiveAlert")}},[alert]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setShowCustomThrottleOpts(notifyWhenValue==="onThrottleInterval")},[notifyWhenValue]);const onNotifyWhenValueChange=Object(external_kbnSharedDeps_React_["useCallback"])(newValue=>{onThrottleChange(newValue==="onThrottleInterval"?alertThrottle:null,throttleUnit);onNotifyWhenChange(newValue);setNotifyWhenValue(newValue)},[]);const labelForAlertRenotify=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.renotifyFieldLabel",defaultMessage:"Notify"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{position:"right",type:"questionInCircle",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.renotifyWithTooltip",{defaultMessage:"Define how often to repeat the action while the alert is active."})}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:labelForAlertRenotify},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperSelect"],{"data-test-subj":"notifyWhenSelect",options:NOTIFY_WHEN_OPTIONS,valueOfSelected:notifyWhenValue,onChange:onNotifyWhenValueChange}),showCustomThrottleOpts&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{fullWidth:true,min:1,value:alertThrottle,name:"throttle","data-test-subj":"throttleInput",prepend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.alertNotifyWhen.label",{defaultMessage:"Every"}),onChange:e=>{Object(pipeable["pipe"])(Object(Option["some"])(e.target.value.trim()),Object(Option["filter"])(value=>value!==""),Object(Option["map"])(value=>parseInt(value,10)),Object(Option["filter"])(value=>!isNaN(value)),Object(Option["map"])(value=>{setAlertThrottle(value);onThrottleChange(value,throttleUnit)}))}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"throttleUnitInput",value:throttleUnit,options:Object(get_time_options["b"])(throttle!==null&&throttle!==void 0?throttle:1),onChange:e=>{onThrottleChange(throttle,e.target.value)}})))))))))};const getLicenseCheckResult=alertType=>({isEnabled:false,message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.checkAlertTypeEnabled.alertTypeDisabledByLicenseMessage",{defaultMessage:"This alert type requires a {minimumLicenseRequired} license.",values:{minimumLicenseRequired:Object(external_kbnSharedDeps_Lodash_["upperFirst"])(alertType.minimumLicenseRequired)}})});function checkAlertTypeEnabled(alertType){if((alertType===null||alertType===void 0?void 0:alertType.enabledInLicense)===false){return getLicenseCheckResult(alertType)}return{isEnabled:true}}function alertTypeGroupCompare(left,right,groupNames){const groupNameA=left[0];const groupNameB=right[0];const leftAlertTypesList=left[1];const rightAlertTypesList=right[1];const hasEnabledAlertTypeInListLeft=leftAlertTypesList.find(alertTypeItem=>alertTypeItem.checkEnabledResult.isEnabled)!==undefined;const hasEnabledAlertTypeInListRight=rightAlertTypesList.find(alertTypeItem=>alertTypeItem.checkEnabledResult.isEnabled)!==undefined;if(hasEnabledAlertTypeInListLeft&&!hasEnabledAlertTypeInListRight){return-1}if(!hasEnabledAlertTypeInListLeft&&hasEnabledAlertTypeInListRight){return 1}return groupNames?groupNames.get(groupNameA).localeCompare(groupNames.get(groupNameB)):groupNameA.localeCompare(groupNameB)}function alertTypeCompare(a,b){if(a.checkEnabledResult.isEnabled===true&&b.checkEnabledResult.isEnabled===false){return-1}if(a.checkEnabledResult.isEnabled===false&&b.checkEnabledResult.isEnabled===true){return 1}return a.name.localeCompare(b.name)}var common_constants=__webpack_require__(12);var section_loading=__webpack_require__(90);const ENTER_KEY=13;function validateBaseProperties(alertObject){const validationResult={errors:{}};const errors={name:new Array,interval:new Array,alertTypeId:new Array,actionConnectors:new Array};validationResult.errors=errors;if(!alertObject.name){errors.name.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.error.requiredNameText",{defaultMessage:"Name is required."}))}if(alertObject.schedule.interval.length<2){errors.interval.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.error.requiredIntervalText",{defaultMessage:"Check interval is required."}))}if(!alertObject.alertTypeId){errors.alertTypeId.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.error.requiredAlertTypeIdText",{defaultMessage:"Alert type is required."}))}const emptyConnectorActions=alertObject.actions.find(actionItem=>/^\d+$/.test(actionItem.id)&&Object.keys(actionItem.params).length>0);if(emptyConnectorActions!==undefined){errors.actionConnectors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.error.requiredActionConnector",{defaultMessage:"Action connector for {actionTypeId} is required.",values:{actionTypeId:emptyConnectorActions.actionTypeId}}))}return validationResult}function getAlertErrors(alert,actionTypeRegistry,alertTypeModel){const alertParamsErrors=alertTypeModel?alertTypeModel.validate(alert.params).errors:[];const alertBaseErrors=validateBaseProperties(alert).errors;const alertErrors={...alertParamsErrors,...alertBaseErrors};const alertActionsErrors=alert.actions.reduce((prev,alertAction)=>{var _actionTypeRegistry$g;return{...prev,[alertAction.id]:(_actionTypeRegistry$g=actionTypeRegistry.get(alertAction.actionTypeId))===null||_actionTypeRegistry$g===void 0?void 0:_actionTypeRegistry$g.validateParams(alertAction.params).errors}},{});return{alertParamsErrors:alertParamsErrors,alertBaseErrors:alertBaseErrors,alertActionsErrors:alertActionsErrors,alertErrors:alertErrors}}const hasObjectErrors=errors=>!!Object.values(errors).find(errorList=>{if(Object(external_kbnSharedDeps_Lodash_["isObject"])(errorList))return hasObjectErrors(errorList);return errorList.length>=1});function isValidAlert(alertObject,validationResult,actionsErrors){return!hasObjectErrors(validationResult)&&Object.keys(actionsErrors).find(actionErrorsKey=>hasObjectErrors(actionsErrors[actionErrorsKey]))===undefined}function getProducerFeatureName(producer,kibanaFeatures){var _kibanaFeatures$find;return(_kibanaFeatures$find=kibanaFeatures.find(featureItem=>featureItem.id===producer))===null||_kibanaFeatures$find===void 0?void 0:_kibanaFeatures$find.name}const AlertForm=({alert:alert,canChangeTrigger:canChangeTrigger=true,dispatch:dispatch,errors:errors,setHasActionsDisabled:setHasActionsDisabled,setHasActionsWithBrokenConnector:setHasActionsWithBrokenConnector,operation:operation,alertTypeRegistry:alertTypeRegistry,actionTypeRegistry:actionTypeRegistry,metadata:metadata})=>{var _selectedAlertType$re,_alert$notifyWhen;const{http:http,notifications:{toasts:toasts},docLinks:docLinks,application:{capabilities:capabilities},kibanaFeatures:kibanaFeatures,charts:charts,data:data}=Object(kibana["b"])().services;const canShowActions=Object(lib_capabilities["e"])(capabilities);const[alertTypeModel,setAlertTypeModel]=Object(external_kbnSharedDeps_React_["useState"])(null);const[alertInterval,setAlertInterval]=Object(external_kbnSharedDeps_React_["useState"])(alert.schedule.interval?Object(parse_duration_["getDurationNumberInItsUnit"])(alert.schedule.interval):undefined);const[alertIntervalUnit,setAlertIntervalUnit]=Object(external_kbnSharedDeps_React_["useState"])(alert.schedule.interval?Object(parse_duration_["getDurationUnitValue"])(alert.schedule.interval):"m");const[alertThrottle,setAlertThrottle]=Object(external_kbnSharedDeps_React_["useState"])(alert.throttle?Object(parse_duration_["getDurationNumberInItsUnit"])(alert.throttle):null);const[alertThrottleUnit,setAlertThrottleUnit]=Object(external_kbnSharedDeps_React_["useState"])(alert.throttle?Object(parse_duration_["getDurationUnitValue"])(alert.throttle):"h");const[defaultActionGroupId,setDefaultActionGroupId]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[alertTypesIndex,setAlertTypesIndex]=Object(external_kbnSharedDeps_React_["useState"])(null);const[availableAlertTypes,setAvailableAlertTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const[filteredAlertTypes,setFilteredAlertTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const[searchText,setSearchText]=Object(external_kbnSharedDeps_React_["useState"])();const[inputText,setInputText]=Object(external_kbnSharedDeps_React_["useState"])();const[solutions,setSolutions]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[solutionsFilter,setSolutionFilter]=Object(external_kbnSharedDeps_React_["useState"])([]);let hasDisabledByLicenseAlertTypes=false;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{try{const alertTypesResult=await Object(alert_api["l"])({http:http});const index=new Map;for(const alertTypeItem of alertTypesResult){index.set(alertTypeItem.id,alertTypeItem)}if(alert.alertTypeId&&index.has(alert.alertTypeId)){setDefaultActionGroupId(index.get(alert.alertTypeId).defaultActionGroupId)}setAlertTypesIndex(index);const availableAlertTypesResult=getAvailableAlertTypes(alertTypesResult);setAvailableAlertTypes(availableAlertTypesResult);const solutionsResult=availableAlertTypesResult.reduce((result,alertTypeItem)=>{if(!result.has(alertTypeItem.alertType.producer)){var _ref;result.set(alertTypeItem.alertType.producer,(_ref=kibanaFeatures?getProducerFeatureName(alertTypeItem.alertType.producer,kibanaFeatures):Object(external_kbnSharedDeps_Lodash_["capitalize"])(alertTypeItem.alertType.producer))!==null&&_ref!==void 0?_ref:Object(external_kbnSharedDeps_Lodash_["capitalize"])(alertTypeItem.alertType.producer))}return result},new Map);setSolutions(new Map([...solutionsResult.entries()].sort(([,a],[,b])=>a.localeCompare(b))))}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.unableToLoadAlertTypesMessage",{defaultMessage:"Unable to load alert types"})})}})()},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setAlertTypeModel(alert.alertTypeId?alertTypeRegistry.get(alert.alertTypeId):null);if(alert.alertTypeId&&alertTypesIndex&&alertTypesIndex.has(alert.alertTypeId)){setDefaultActionGroupId(alertTypesIndex.get(alert.alertTypeId).defaultActionGroupId)}},[alert,alert.alertTypeId,alertTypesIndex,alertTypeRegistry]);const setAlertProperty=Object(external_kbnSharedDeps_React_["useCallback"])((key,value)=>{dispatch({command:{type:"setProperty"},payload:{key:key,value:value}})},[dispatch]);const setActions=Object(external_kbnSharedDeps_React_["useCallback"])(updatedActions=>setAlertProperty("actions",updatedActions),[setAlertProperty]);const setAlertParams=(key,value)=>{dispatch({command:{type:"setAlertParams"},payload:{key:key,value:value}})};const setScheduleProperty=(key,value)=>{dispatch({command:{type:"setScheduleProperty"},payload:{key:key,value:value}})};const setActionProperty=(key,value,index)=>{dispatch({command:{type:"setAlertActionProperty"},payload:{key:key,value:value,index:index}})};const setActionParamsProperty=Object(external_kbnSharedDeps_React_["useCallback"])((key,value,index)=>{dispatch({command:{type:"setAlertActionParams"},payload:{key:key,value:value,index:index}})},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const searchValue=searchText?searchText.trim().toLocaleLowerCase():null;setFilteredAlertTypes(availableAlertTypes.filter(alertTypeItem=>solutionsFilter.length>0?solutionsFilter.find(item=>alertTypeItem.alertType.producer===item):alertTypeItem).filter(alertTypeItem=>searchValue?alertTypeItem.alertType.name.toString().toLocaleLowerCase().includes(searchValue)||alertTypeItem.alertType.producer.toLocaleLowerCase().includes(searchValue)||alertTypeItem.alertTypeModel.description.toLocaleLowerCase().includes(searchValue):alertTypeItem))},[alertTypeRegistry,availableAlertTypes,searchText,JSON.stringify(solutionsFilter)]);const getAvailableAlertTypes=alertTypesResult=>alertTypeRegistry.list().reduce((arr,alertTypeRegistryItem)=>{const alertType=alertTypesResult.find(item=>alertTypeRegistryItem.id===item.id);if(alertType){arr.push({alertType:alertType,alertTypeModel:alertTypeRegistryItem})}return arr},[]).filter(item=>item.alertType&&Object(lib_capabilities["a"])(alert,item.alertType)).filter(item=>alert.consumer===common_["ALERTS_FEATURE_ID"]?!item.alertTypeModel.requiresAppContext:item.alertType.producer===alert.consumer);const selectedAlertType=alert!==null&&alert!==void 0&&alert.alertTypeId?alertTypesIndex===null||alertTypesIndex===void 0?void 0:alertTypesIndex.get(alert===null||alert===void 0?void 0:alert.alertTypeId):undefined;const recoveryActionGroup=selectedAlertType===null||selectedAlertType===void 0?void 0:(_selectedAlertType$re=selectedAlertType.recoveryActionGroup)===null||_selectedAlertType$re===void 0?void 0:_selectedAlertType$re.id;const getDefaultActionParams=Object(external_kbnSharedDeps_React_["useCallback"])((actionTypeId,actionGroupId)=>getDefaultsForActionParams(actionTypeId,actionGroupId,actionGroupId===recoveryActionGroup),[recoveryActionGroup]);const tagsOptions=alert.tags?alert.tags.map(label=>({label:label})):[];const isActionGroupDisabledForActionType=Object(external_kbnSharedDeps_React_["useCallback"])((alertType,actionGroupId,actionTypeId)=>{var _alertType$recoveryAc;return Object(common_["isActionGroupDisabledForActionTypeId"])(actionGroupId===(alertType===null||alertType===void 0?void 0:(_alertType$recoveryAc=alertType.recoveryActionGroup)===null||_alertType$recoveryAc===void 0?void 0:_alertType$recoveryAc.id)?common_["RecoveredActionGroup"].id:actionGroupId,actionTypeId)},[]);const AlertParamsExpressionComponent=alertTypeModel?alertTypeModel.alertParamsExpression:null;const alertTypesByProducer=filteredAlertTypes.reduce((result,alertTypeValue)=>{const producer=alertTypeValue.alertType.producer;if(producer){const checkEnabledResult=checkAlertTypeEnabled(alertTypeValue.alertType);if(!checkEnabledResult.isEnabled){hasDisabledByLicenseAlertTypes=true}(result[producer]=result[producer]||[]).push({name:alertTypeValue.alertType.name,id:alertTypeValue.alertTypeModel.id,checkEnabledResult:checkEnabledResult,alertTypeItem:alertTypeValue.alertTypeModel})}return result},{});const alertTypeNodes=Object.entries(alertTypesByProducer).sort((a,b)=>alertTypeGroupCompare(a,b,solutions)).map(([solution,items],groupIndex)=>{var _ref2;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:`group${groupIndex}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"center",className:"triggersActionsUI__alertTypeNodeHeading"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{"data-test-subj":`alertType${groupIndex}Group`,size:"xxxs",textTransform:"uppercase"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},(_ref2=kibanaFeatures?getProducerFeatureName(solution,kibanaFeatures):Object(external_kbnSharedDeps_Lodash_["capitalize"])(solution))!==null&&_ref2!==void 0?_ref2:Object(external_kbnSharedDeps_Lodash_["capitalize"])(solution)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiNotificationBadge"],{color:"subdued"},items.length))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{size:"full",margin:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroup"],{flush:true,gutterSize:"m",size:"l",maxWidth:false},items.sort((a,b)=>alertTypeCompare(a,b)).map((item,index)=>{const alertTypeListItemHtml=external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,item.name),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,item.alertTypeItem.description)));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:index},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroupItem"],{"data-test-subj":`${item.id}-SelectOption`,color:"primary",label:item.checkEnabledResult.isEnabled?alertTypeListItemHtml:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top","data-test-subj":`${item.id}-disabledTooltip`,content:item.checkEnabledResult.message},alertTypeListItemHtml),isDisabled:!item.checkEnabledResult.isEnabled,onClick:()=>{setAlertProperty("alertTypeId",item.id);setActions([]);setAlertTypeModel(item.alertTypeItem);setAlertProperty("params",{});if(alertTypesIndex&&alertTypesIndex.has(item.id)){setDefaultActionGroupId(alertTypesIndex.get(item.id).defaultActionGroupId)}}}))})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null))});const alertTypeDetails=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s","data-test-subj":"selectedAlertTypeTitle"},external_kbnSharedDeps_React_default.a.createElement("h5",{id:"selectedAlertTypeTitle"},alert.alertTypeId&&alertTypesIndex&&alertTypesIndex.has(alert.alertTypeId)?alertTypesIndex.get(alert.alertTypeId).name:""))),canChangeTrigger?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"cross",color:"danger","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.changeAlertTypeAriaLabel",{defaultMessage:"Delete"}),onClick:()=>{setAlertProperty("alertTypeId",null);setAlertTypeModel(null);setAlertProperty("params",{})}})):null),(alertTypeModel===null||alertTypeModel===void 0?void 0:alertTypeModel.description)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s","data-test-subj":"alertDescription"},alertTypeModel.description," ",(alertTypeModel===null||alertTypeModel===void 0?void 0:alertTypeModel.documentationUrl)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{external:true,target:"_blank","data-test-subj":"alertDocumentationLink",href:typeof alertTypeModel.documentationUrl==="function"?alertTypeModel.documentationUrl(docLinks):alertTypeModel.documentationUrl},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.documentationLabel",defaultMessage:"Documentation"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),AlertParamsExpressionComponent&&defaultActionGroupId&&alert.alertTypeId&&selectedAlertType?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Suspense"],{fallback:external_kbnSharedDeps_React_default.a.createElement(section_loading["a"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.loadingAlertTypeParamsDescription",defaultMessage:"Loading alert type params…"}))},external_kbnSharedDeps_React_default.a.createElement(AlertParamsExpressionComponent,{alertParams:alert.params,alertInterval:`${alertInterval!==null&&alertInterval!==void 0?alertInterval:1}${alertIntervalUnit}`,alertThrottle:`${alertThrottle!==null&&alertThrottle!==void 0?alertThrottle:1}${alertThrottleUnit}`,alertNotifyWhen:(_alert$notifyWhen=alert.notifyWhen)!==null&&_alert$notifyWhen!==void 0?_alert$notifyWhen:"onActionGroupChange",errors:errors,setAlertParams:setAlertParams,setAlertProperty:setAlertProperty,defaultActionGroupId:defaultActionGroupId,actionGroups:selectedAlertType.actionGroups,metadata:metadata,charts:charts,data:data}))):null,canShowActions&&defaultActionGroupId&&alertTypeModel&&alert.alertTypeId&&selectedAlertType?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,errors.actionConnectors.length>=1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",size:"s",title:errors.actionConnectors}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):null,external_kbnSharedDeps_React_default.a.createElement(action_connector_form["a"],{actions:alert.actions,setHasActionsDisabled:setHasActionsDisabled,setHasActionsWithBrokenConnector:setHasActionsWithBrokenConnector,messageVariables:selectedAlertType.actionVariables,defaultActionGroupId:defaultActionGroupId,isActionGroupDisabledForActionType:(actionGroupId,actionTypeId)=>isActionGroupDisabledForActionType(selectedAlertType,actionGroupId,actionTypeId),actionGroups:selectedAlertType.actionGroups.map(actionGroup=>actionGroup.id===selectedAlertType.recoveryActionGroup.id?{...actionGroup,omitOptionalMessageVariables:true,defaultActionMessage:constants["e"]}:{...actionGroup,defaultActionMessage:alertTypeModel===null||alertTypeModel===void 0?void 0:alertTypeModel.defaultActionMessage}),getDefaultActionParams:getDefaultActionParams,setActionIdByIndex:(id,index)=>setActionProperty("id",id,index),setActionGroupIdByIndex:(group,index)=>setActionProperty("group",group,index),setActions:setActions,setActionParamsProperty:setActionParamsProperty,actionTypeRegistry:actionTypeRegistry})):null);const labelForAlertChecked=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.checkFieldLabel",defaultMessage:"Check every"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{position:"right",type:"questionInCircle",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.checkWithTooltip",{defaultMessage:"Define how often to evaluate the condition."})}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,id:"alertName",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.alertNameLabel",defaultMessage:"Name"}),isInvalid:errors.name.length>0&&alert.name!==undefined,error:errors.name},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,autoFocus:true,isInvalid:errors.name.length>0&&alert.name!==undefined,name:"name","data-test-subj":"alertNameInput",value:alert.name||"",onChange:e=>{setAlertProperty("name",e.target.value)},onBlur:()=>{if(!alert.name){setAlertProperty("name","")}}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.tagsFieldLabel",{defaultMessage:"Tags (optional)"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{noSuggestions:true,fullWidth:true,"data-test-subj":"tagsComboBox",selectedOptions:tagsOptions,onCreateOption:searchValue=>{const newOptions=[...tagsOptions,{label:searchValue}];setAlertProperty("tags",newOptions.map(newOption=>newOption.label))},onChange:selectedOptions=>{setAlertProperty("tags",selectedOptions.map(selectedOption=>selectedOption.label))},onBlur:()=>{if(!alert.tags){setAlertProperty("tags",[])}}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,display:"rowCompressed",label:labelForAlertChecked,isInvalid:errors.interval.length>0,error:errors.interval},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{fullWidth:true,min:1,isInvalid:errors.interval.length>0,value:alertInterval||"",name:"interval","data-test-subj":"intervalInput",onChange:e=>{const interval=e.target.value!==""?parseInt(e.target.value,10):undefined;setAlertInterval(interval);setScheduleProperty("interval",`${e.target.value}${alertIntervalUnit}`)}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{fullWidth:true,value:alertIntervalUnit,options:Object(get_time_options["b"])(alertInterval!==null&&alertInterval!==void 0?alertInterval:1),onChange:e=>{setAlertIntervalUnit(e.target.value);setScheduleProperty("interval",`${alertInterval}${e.target.value}`)},"data-test-subj":"intervalInputUnit"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(AlertNotifyWhen,{alert:alert,throttle:alertThrottle,throttleUnit:alertThrottleUnit,onNotifyWhenChange:Object(external_kbnSharedDeps_React_["useCallback"])(notifyWhen=>{setAlertProperty("notifyWhen",notifyWhen)},[setAlertProperty]),onThrottleChange:Object(external_kbnSharedDeps_React_["useCallback"])((throttle,throttleUnit)=>{setAlertThrottle(throttle);setAlertThrottleUnit(throttleUnit);setAlertProperty("throttle",throttle?`${throttle}${throttleUnit}`:null)},[setAlertProperty])}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),alertTypeModel?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,alertTypeDetails):availableAlertTypes.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,labelAppend:hasDisabledByLicenseAlertTypes&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:common_constants["VIEW_LICENSE_OPTIONS_LINK"],target:"_blank",external:true,className:"actActionForm__getMoreActionsLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Get more alert types",id:"xpack.triggersActionsUI.sections.actionForm.getMoreAlertTypesTitle"}))),label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.alertTypeSelectLabel",defaultMessage:"Select alert type"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{fullWidth:true,"data-test-subj":"alertSearchField",onChange:e=>setInputText(e.target.value),onKeyUp:e=>{if(e.keyCode===ENTER_KEY){setSearchText(inputText)}},placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.searchPlaceholderTitle",{defaultMessage:"Search"})})),solutions?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(SolutionFilter,{key:"solution-filter",solutions:solutions,onChange:selectedSolutions=>setSolutionFilter(selectedSolutions)})):null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),errors.alertTypeId.length>=1&&alert.alertTypeId!==undefined?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",size:"s",title:errors.alertTypeId}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):null,alertTypeNodes):alertTypesIndex?external_kbnSharedDeps_React_default.a.createElement(NoAuthorizedAlertTypes,{operation:operation}):external_kbnSharedDeps_React_default.a.createElement(section_loading["a"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.loadingAlertTypesDescription",defaultMessage:"Loading alert types…"})))};const NoAuthorizedAlertTypes=({operation:operation})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"lock","data-test-subj":"noAuthorizedAlertTypesPrompt",titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.error.noAuthorizedAlertTypesTitle",defaultMessage:"You have not been authorized to {operation} any Alert types",values:{operation:operation}})),body:external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertForm.error.noAuthorizedAlertTypes",defaultMessage:"In order to {operation} an Alert you need to have been granted the appropriate privileges.",values:{operation:operation}})))})},187:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(188);case"v7light":return __webpack_require__(190);case"v8dark":return __webpack_require__(192);case"v8light":return __webpack_require__(194)}},188:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(189);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},189:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".triggersActionsUI__alertTypeNodeHeading {\n  margin-left: 8px;\n  margin-right: 8px; }\n",""]);module.exports=exports},190:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(191);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},191:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".triggersActionsUI__alertTypeNodeHeading {\n  margin-left: 8px;\n  margin-right: 8px; }\n",""]);module.exports=exports},192:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(193);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},193:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".triggersActionsUI__alertTypeNodeHeading {\n  margin-left: 8px;\n  margin-right: 8px; }\n",""]);module.exports=exports},194:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(195);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},195:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".triggersActionsUI__alertTypeNodeHeading {\n  margin-left: 8px;\n  margin-right: 8px; }\n",""]);module.exports=exports},196:function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},90:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SectionLoading}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);const SectionLoading=({children:children})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiEmptyPrompt"],{title:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiLoadingSpinner"],{size:"xl"}),body:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiText"],{color:"subdued"},children),"data-test-subj":"sectionLoading"})},94:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HealthContextProvider}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useHealthContext}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);const defaultHealthContext={loadingHealthCheck:false,setLoadingHealthCheck:loading=>{throw new Error("setLoadingHealthCheck was not initialized, set it when you invoke the context")}};const HealthContext=Object(react__WEBPACK_IMPORTED_MODULE_0__["createContext"])(defaultHealthContext);const HealthContextProvider=({children:children})=>{const[loading,setLoading]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const setLoadingHealthCheck=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(isLoading=>{setLoading(isLoading)},[]);const value=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({loadingHealthCheck:loading,setLoadingHealthCheck:setLoadingHealthCheck}),[loading,setLoadingHealthCheck]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(HealthContext.Provider,{value:value},children)};const useHealthContext=()=>{const ctx=Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(HealthContext);if(!ctx){throw new Error("HealthContext has not been set.")}return ctx}}}]);