/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["triggersActionsUi_bundle_jsonpfunction"]=window["triggersActionsUi_bundle_jsonpfunction"]||[]).push([[18],{279:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"default",(function(){return ResilientParamsFields}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var text_area_with_message_variables=__webpack_require__(88);var text_field_with_message_variables=__webpack_require__(89);var constants=__webpack_require__(3);async function getIncidentTypes({http:http,signal:signal,connectorId:connectorId}){return await http.post(`${constants["a"]}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"incidentTypes",subActionParams:{}}}),signal:signal})}async function getSeverity({http:http,signal:signal,connectorId:connectorId}){return await http.post(`${constants["a"]}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"severity",subActionParams:{}}}),signal:signal})}var translations=__webpack_require__(14);const useGetIncidentTypes=({http:http,toastNotifications:toastNotifications,actionConnector:actionConnector})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[incidentTypes,setIncidentTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{let didCancel=false;const fetchData=async()=>{if(!actionConnector){setIsLoading(false);return}abortCtrl.current=new AbortController;setIsLoading(true);try{const res=await getIncidentTypes({http:http,signal:abortCtrl.current.signal,connectorId:actionConnector.id});if(!didCancel){var _res$data;setIsLoading(false);setIncidentTypes((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:[]);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["k"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel){setIsLoading(false);toastNotifications.addDanger({title:translations["k"],text:error.message})}}};abortCtrl.current.abort();fetchData();return()=>{didCancel=true;setIsLoading(false);abortCtrl.current.abort()}},[http,actionConnector,toastNotifications]);return{incidentTypes:incidentTypes,isLoading:isLoading}};const useGetSeverity=({http:http,toastNotifications:toastNotifications,actionConnector:actionConnector})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[severity,setSeverity]=Object(external_kbnSharedDeps_React_["useState"])([]);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{let didCancel=false;const fetchData=async()=>{if(!actionConnector){setIsLoading(false);return}abortCtrl.current=new AbortController;setIsLoading(true);try{const res=await getSeverity({http:http,signal:abortCtrl.current.signal,connectorId:actionConnector.id});if(!didCancel){var _res$data;setIsLoading(false);setSeverity((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:[]);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["q"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel){setIsLoading(false);toastNotifications.addDanger({title:translations["q"],text:error.message})}}};abortCtrl.current.abort();fetchData();return()=>{didCancel=true;setIsLoading(false);abortCtrl.current.abort()}},[http,actionConnector,toastNotifications]);return{severity:severity,isLoading:isLoading}};var kibana=__webpack_require__(34);const ResilientParamsFields=({actionConnector:actionConnector,actionParams:actionParams,editAction:editAction,errors:errors,index:index,messageVariables:messageVariables})=>{var _actionConnector$id,_incident$severityCod,_incident$name,_incident$description;const{http:http,notifications:{toasts:toasts}}=Object(kibana["b"])().services;const actionConnectorRef=Object(external_kbnSharedDeps_React_["useRef"])((_actionConnector$id=actionConnector===null||actionConnector===void 0?void 0:actionConnector.id)!==null&&_actionConnector$id!==void 0?_actionConnector$id:"");const{incident:incident,comments:comments}=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _actionParams$subActi;return(_actionParams$subActi=actionParams.subActionParams)!==null&&_actionParams$subActi!==void 0?_actionParams$subActi:{incident:{},comments:[]}},[actionParams.subActionParams]);const{isLoading:isLoadingIncidentTypes,incidentTypes:allIncidentTypes}=useGetIncidentTypes({http:http,toastNotifications:toasts,actionConnector:actionConnector});const{isLoading:isLoadingSeverity,severity:severity}=useGetSeverity({http:http,toastNotifications:toasts,actionConnector:actionConnector});const severitySelectOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>severity.map(s=>({value:s.id.toString(),text:s.name})),[severity]);const incidentTypesComboBoxOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>allIncidentTypes?allIncidentTypes.map(type=>({label:type.name,value:type.id.toString()})):[],[allIncidentTypes]);const selectedIncidentTypesComboBoxOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const allIncidentTypesAsObject=allIncidentTypes.reduce((acc,type)=>({...acc,[type.id.toString()]:type.name}),{});return incident.incidentTypes?incident.incidentTypes.map(type=>({label:allIncidentTypesAsObject[type.toString()],value:type.toString()})).filter(type=>type.label!=null):[]},[allIncidentTypes,incident.incidentTypes]);const editSubActionProperty=Object(external_kbnSharedDeps_React_["useCallback"])((key,value)=>{const newProps=key!=="comments"?{incident:{...incident,[key]:value},comments:comments}:{incident:incident,[key]:value};editAction("subActionParams",newProps,index)},[comments,editAction,incident,index]);const editComment=Object(external_kbnSharedDeps_React_["useCallback"])((key,value)=>{if(value.length>0){editSubActionProperty(key,[{commentId:"1",comment:value}])}},[editSubActionProperty]);const incidentTypesOnChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedOptions=>{editSubActionProperty("incidentTypes",selectedOptions.map(selectedOption=>{var _selectedOption$value;return(_selectedOption$value=selectedOption.value)!==null&&_selectedOption$value!==void 0?_selectedOption$value:selectedOption.label}))},[editSubActionProperty]);const incidentTypesOnBlur=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(!incident.incidentTypes){editSubActionProperty("incidentTypes",[])}},[editSubActionProperty,incident.incidentTypes]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(actionConnector!=null&&actionConnectorRef.current!==actionConnector.id){actionConnectorRef.current=actionConnector.id;editAction("subActionParams",{incident:{},comments:[]},index)}},[actionConnector]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!actionParams.subAction){editAction("subAction","pushToService",index)}if(!actionParams.subActionParams){editAction("subActionParams",{incident:{},comments:[]},index)}},[actionParams]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,"Incident")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.builtinActionTypes.resilient.urgencySelectFieldLabel",{defaultMessage:"Incident Type"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{fullWidth:true,isLoading:isLoadingIncidentTypes,isDisabled:isLoadingIncidentTypes,"data-test-subj":"incidentTypeComboBox",options:incidentTypesComboBoxOptions,selectedOptions:selectedIncidentTypesComboBoxOptions,onChange:incidentTypesOnChange,onBlur:incidentTypesOnBlur,isClearable:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.builtinActionTypes.resilient.severity",{defaultMessage:"Severity"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"severitySelect",disabled:isLoadingSeverity,fullWidth:true,hasNoInitialSelection:true,isLoading:isLoadingSeverity,onChange:e=>editSubActionProperty("severityCode",e.target.value),options:severitySelectOptions,value:(_incident$severityCod=incident.severityCode)!==null&&_incident$severityCod!==void 0?_incident$severityCod:undefined})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,error:errors["subActionParams.incident.name"],isInvalid:errors["subActionParams.incident.name"].length>0&&incident.name!==undefined,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.builtinActionTypes.resilient.nameFieldLabel",{defaultMessage:"Name (required)"})},external_kbnSharedDeps_React_default.a.createElement(text_field_with_message_variables["a"],{index:index,editAction:editSubActionProperty,messageVariables:messageVariables,paramsProperty:"name",inputTargetValue:(_incident$name=incident.name)!==null&&_incident$name!==void 0?_incident$name:undefined,errors:errors["subActionParams.incident.name"]})),external_kbnSharedDeps_React_default.a.createElement(text_area_with_message_variables["a"],{index:index,editAction:editSubActionProperty,messageVariables:messageVariables,paramsProperty:"description",inputTargetValue:(_incident$description=incident.description)!==null&&_incident$description!==void 0?_incident$description:undefined,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.builtinActionTypes.resilient.descriptionTextAreaFieldLabel",{defaultMessage:"Description"})}),external_kbnSharedDeps_React_default.a.createElement(text_area_with_message_variables["a"],{index:index,editAction:editComment,messageVariables:messageVariables,paramsProperty:"comments",inputTargetValue:comments&&comments.length>0?comments[0].comment:undefined,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.builtinActionTypes.resilient.commentsTextAreaFieldLabel",{defaultMessage:"Additional comments"})}))}},76:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(79);case"v7light":return __webpack_require__(81);case"v8dark":return __webpack_require__(83);case"v8light":return __webpack_require__(85)}},77:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return templateActionVariable}));function templateActionVariable(variable){return variable.useWithTripleBracesInTemplates?`{{{${variable.name}}}}`:`{{${variable.name}}}`}},78:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AddMessageVariables}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__);var _add_message_variables_scss__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(76);var _add_message_variables_scss__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_add_message_variables_scss__WEBPACK_IMPORTED_MODULE_3__);var _lib__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(77);const AddMessageVariables=({messageVariables:messageVariables,paramsProperty:paramsProperty,onSelectEventHandler:onSelectEventHandler})=>{var _messageVariables$len;const[isVariablesPopoverOpen,setIsVariablesPopoverOpen]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const getMessageVariables=()=>messageVariables===null||messageVariables===void 0?void 0:messageVariables.map((variable,i)=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiContextMenuItem"],{key:variable.name,"data-test-subj":`variableMenuButton-${variable.name}`,icon:"empty",onClick:()=>{onSelectEventHandler(variable);setIsVariablesPopoverOpen(false)}},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiText"],{size:"m","data-test-subj":`variableMenuButton-${i}-templated-name`},Object(_lib__WEBPACK_IMPORTED_MODULE_4__["a"])(variable)),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiText"],{size:"m",color:"subdued"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{className:"euiTextColor--subdued"},variable.description)))));const addVariableButtonTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.triggersActionsUI.components.addMessageVariables.addVariableTitle",{defaultMessage:"Add alert variable"});return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiPopover"],{button:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiButtonIcon"],{id:`${paramsProperty}AddVariableButton`,"data-test-subj":`${paramsProperty}AddVariableButton`,isDisabled:((_messageVariables$len=messageVariables===null||messageVariables===void 0?void 0:messageVariables.length)!==null&&_messageVariables$len!==void 0?_messageVariables$len:0)===0,title:addVariableButtonTitle,onClick:()=>setIsVariablesPopoverOpen(true),iconType:"indexOpen","aria-label":_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.triggersActionsUI.components.addMessageVariables.addVariablePopoverButton",{defaultMessage:"Add variable"})}),isOpen:isVariablesPopoverOpen,closePopover:()=>setIsVariablesPopoverOpen(false),panelPaddingSize:"none",anchorPosition:"downLeft"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiContextMenuPanel"],{className:"messageVariablesPanel",items:getMessageVariables()}))}},79:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(80);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},80:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".messageVariablesPanel {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 320px;\n  max-width: 320px; }\n  .messageVariablesPanel::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .messageVariablesPanel::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .messageVariablesPanel::-webkit-scrollbar-corner, .messageVariablesPanel::-webkit-scrollbar-track {\n    background-color: transparent; }\n",""]);module.exports=exports},81:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(82);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},82:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".messageVariablesPanel {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 320px;\n  max-width: 320px; }\n  .messageVariablesPanel::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .messageVariablesPanel::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .messageVariablesPanel::-webkit-scrollbar-corner, .messageVariablesPanel::-webkit-scrollbar-track {\n    background-color: transparent; }\n",""]);module.exports=exports},83:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(84);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},84:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".messageVariablesPanel {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 320px;\n  max-width: 320px; }\n  .messageVariablesPanel::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .messageVariablesPanel::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .messageVariablesPanel::-webkit-scrollbar-corner, .messageVariablesPanel::-webkit-scrollbar-track {\n    background-color: transparent; }\n",""]);module.exports=exports},85:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(86);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},86:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".messageVariablesPanel {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 320px;\n  max-width: 320px; }\n  .messageVariablesPanel::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .messageVariablesPanel::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .messageVariablesPanel::-webkit-scrollbar-corner, .messageVariablesPanel::-webkit-scrollbar-track {\n    background-color: transparent; }\n",""]);module.exports=exports},88:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return TextAreaWithMessageVariables}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _add_message_variables_scss__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(76);var _add_message_variables_scss__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_add_message_variables_scss__WEBPACK_IMPORTED_MODULE_2__);var _add_message_variables__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(78);var _lib__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(77);const TextAreaWithMessageVariables=({messageVariables:messageVariables,paramsProperty:paramsProperty,index:index,inputTargetValue:inputTargetValue,editAction:editAction,label:label,errors:errors})=>{const[currentTextElement,setCurrentTextElement]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);const onSelectMessageVariable=variable=>{var _currentTextElement$s,_currentTextElement$s2;const templatedVar=Object(_lib__WEBPACK_IMPORTED_MODULE_4__["a"])(variable);const startPosition=(_currentTextElement$s=currentTextElement===null||currentTextElement===void 0?void 0:currentTextElement.selectionStart)!==null&&_currentTextElement$s!==void 0?_currentTextElement$s:0;const endPosition=(_currentTextElement$s2=currentTextElement===null||currentTextElement===void 0?void 0:currentTextElement.selectionEnd)!==null&&_currentTextElement$s2!==void 0?_currentTextElement$s2:0;const newValue=(inputTargetValue!==null&&inputTargetValue!==void 0?inputTargetValue:"").substring(0,startPosition)+templatedVar+(inputTargetValue!==null&&inputTargetValue!==void 0?inputTargetValue:"").substring(endPosition,(inputTargetValue!==null&&inputTargetValue!==void 0?inputTargetValue:"").length);editAction(paramsProperty,newValue,index)};const onChangeWithMessageVariable=e=>{editAction(paramsProperty,e.target.value,index)};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiFormRow"],{fullWidth:true,error:errors,isInvalid:errors&&errors.length>0&&inputTargetValue!==undefined,label:label,labelAppend:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_add_message_variables__WEBPACK_IMPORTED_MODULE_3__["a"],{messageVariables:messageVariables,onSelectEventHandler:onSelectMessageVariable,paramsProperty:paramsProperty})},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiTextArea"],{fullWidth:true,isInvalid:errors&&errors.length>0&&inputTargetValue!==undefined,name:paramsProperty,value:inputTargetValue||"","data-test-subj":`${paramsProperty}TextArea`,onChange:e=>onChangeWithMessageVariable(e),onFocus:e=>{setCurrentTextElement(e.target)},onBlur:()=>{if(!inputTargetValue){editAction(paramsProperty,"",index)}}}))}},89:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return TextFieldWithMessageVariables}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _add_message_variables_scss__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(76);var _add_message_variables_scss__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_add_message_variables_scss__WEBPACK_IMPORTED_MODULE_2__);var _add_message_variables__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(78);var _lib__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(77);const TextFieldWithMessageVariables=({messageVariables:messageVariables,paramsProperty:paramsProperty,index:index,inputTargetValue:inputTargetValue,editAction:editAction,errors:errors,defaultValue:defaultValue})=>{const[currentTextElement,setCurrentTextElement]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);const onSelectMessageVariable=variable=>{var _currentTextElement$s,_currentTextElement$s2;const templatedVar=Object(_lib__WEBPACK_IMPORTED_MODULE_4__["a"])(variable);const startPosition=(_currentTextElement$s=currentTextElement===null||currentTextElement===void 0?void 0:currentTextElement.selectionStart)!==null&&_currentTextElement$s!==void 0?_currentTextElement$s:0;const endPosition=(_currentTextElement$s2=currentTextElement===null||currentTextElement===void 0?void 0:currentTextElement.selectionEnd)!==null&&_currentTextElement$s2!==void 0?_currentTextElement$s2:0;const newValue=(inputTargetValue!==null&&inputTargetValue!==void 0?inputTargetValue:"").substring(0,startPosition)+templatedVar+(inputTargetValue!==null&&inputTargetValue!==void 0?inputTargetValue:"").substring(endPosition,(inputTargetValue!==null&&inputTargetValue!==void 0?inputTargetValue:"").length);editAction(paramsProperty,newValue,index)};const onChangeWithMessageVariable=e=>{editAction(paramsProperty,e.target.value,index)};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiFieldText"],{fullWidth:true,name:paramsProperty,id:`${paramsProperty}Id`,isInvalid:errors&&errors.length>0&&inputTargetValue!==undefined,"data-test-subj":`${paramsProperty}Input`,value:inputTargetValue||"",defaultValue:defaultValue,onChange:e=>onChangeWithMessageVariable(e),onFocus:e=>{setCurrentTextElement(e.target)},onBlur:e=>{if(!inputTargetValue){editAction(paramsProperty,"",index)}},append:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_add_message_variables__WEBPACK_IMPORTED_MODULE_3__["a"],{messageVariables:messageVariables,onSelectEventHandler:onSelectMessageVariable,paramsProperty:paramsProperty})})}}}]);