/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["triggersActionsUi_bundle_jsonpfunction"]=window["triggersActionsUi_bundle_jsonpfunction"]||[]).push([[15],{100:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return alertReducer}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);const alertReducer=(state,action)=>{const{alert:alert}=state;switch(action.command.type){case"setAlert":{const{key:key,value:value}=action.payload;if(key==="alert"){return{...state,alert:value}}else{return state}}case"setProperty":{const{key:key,value:value}=action.payload;if(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert[key],value)){return state}else{return{...state,alert:{...alert,[key]:value}}}}case"setScheduleProperty":{const{key:key,value:value}=action.payload;if(alert.schedule&&Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.schedule[key],value)){return state}else{return{...state,alert:{...alert,schedule:{...alert.schedule,[key]:value}}}}}case"setAlertParams":{const{key:key,value:value}=action.payload;if(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.params[key],value)){return state}else{return{...state,alert:{...alert,params:{...alert.params,[key]:value}}}}}case"setAlertActionParams":{const{key:key,value:value,index:index}=action.payload;if(index===undefined||alert.actions[index]==null||Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.actions[index][key],value)){return state}else{const oldAction=alert.actions.splice(index,1)[0];const updatedAction={...oldAction,params:{...oldAction.params,[key]:value}};alert.actions.splice(index,0,updatedAction);return{...state,alert:{...alert,actions:[...alert.actions]}}}}case"setAlertActionProperty":{const{key:key,value:value,index:index}=action.payload;if(index===undefined||Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEqual"])(alert.actions[index][key],value)){return state}else{const oldAction=alert.actions.splice(index,1)[0];const updatedAction={...oldAction,[key]:value};alert.actions.splice(index,0,updatedAction);return{...state,alert:{...alert,actions:[...alert.actions]}}}}}}},101:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ALERT_STATUS_LICENSE_ERROR}));__webpack_require__.d(__webpack_exports__,"c",(function(){return alertsStatusesTranslationsMapping}));__webpack_require__.d(__webpack_exports__,"b",(function(){return alertsErrorReasonTranslationsMapping}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const ALERT_STATUS_OK=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusOk",{defaultMessage:"Ok"});const ALERT_STATUS_ACTIVE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusActive",{defaultMessage:"Active"});const ALERT_STATUS_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusError",{defaultMessage:"Error"});const ALERT_STATUS_LICENSE_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusLicenseError",{defaultMessage:"License Error"});const ALERT_STATUS_PENDING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusPending",{defaultMessage:"Pending"});const ALERT_STATUS_UNKNOWN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusUnknown",{defaultMessage:"Unknown"});const alertsStatusesTranslationsMapping={ok:ALERT_STATUS_OK,active:ALERT_STATUS_ACTIVE,error:ALERT_STATUS_ERROR,pending:ALERT_STATUS_PENDING,unknown:ALERT_STATUS_UNKNOWN};const ALERT_ERROR_UNKNOWN_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonUnknown",{defaultMessage:"An error occurred for unknown reasons."});const ALERT_ERROR_READING_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonReading",{defaultMessage:"An error occurred when reading the alert."});const ALERT_ERROR_DECRYPTING_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonDecrypting",{defaultMessage:"An error occurred when decrypting the alert."});const ALERT_ERROR_EXECUTION_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonRunning",{defaultMessage:"An error occurred when running the alert."});const ALERT_ERROR_LICENSE_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonLicense",{defaultMessage:"Cannot run alert"});const alertsErrorReasonTranslationsMapping={read:ALERT_ERROR_READING_REASON,decrypt:ALERT_ERROR_DECRYPTING_REASON,execute:ALERT_ERROR_EXECUTION_REASON,unknown:ALERT_ERROR_UNKNOWN_REASON,license:ALERT_ERROR_LICENSE_REASON}},134:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getAlertingSectionBreadcrumb}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getAlertDetailsBreadcrumb}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);var _constants__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(3);const getAlertingSectionBreadcrumb=type=>{switch(type){case"connectors":return{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.connectors.breadcrumbTitle",{defaultMessage:"Connectors"}),href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["h"]}`};case"alerts":return{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.alerts.breadcrumbTitle",{defaultMessage:"Alerts"}),href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["g"]}`};default:return{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.home.breadcrumbTitle",{defaultMessage:"Alerts and Actions"}),href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["i"]}`}}};const getAlertDetailsBreadcrumb=(id,name)=>({text:name,href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["f"].replace(":alertId",id)}`})},135:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getCurrentDocTitle}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const getCurrentDocTitle=page=>{let updatedTitle;switch(page){case"connectors":updatedTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.connectors.breadcrumbTitle",{defaultMessage:"Connectors"});break;case"alerts":updatedTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.alerts.breadcrumbTitle",{defaultMessage:"Alerts"});break;default:updatedTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.home.breadcrumbTitle",{defaultMessage:"Alerts and Actions"})}return updatedTitle}},251:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(252);case"v7light":return __webpack_require__(254);case"v8dark":return __webpack_require__(256);case"v8light":return __webpack_require__(258)}},252:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(253);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},253:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actionsInstanceList__health {\n  width: 100%; }\n  .actionsInstanceList__health .euiFlexItem:last-of-type {\n    max-width: 100%;\n    overflow: hidden !important;\n    text-overflow: ellipsis !important;\n    white-space: nowrap !important;\n    word-wrap: normal !important;\n    min-width: 0;\n    width: 85%; }\n",""]);module.exports=exports},254:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(255);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},255:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actionsInstanceList__health {\n  width: 100%; }\n  .actionsInstanceList__health .euiFlexItem:last-of-type {\n    max-width: 100%;\n    overflow: hidden !important;\n    text-overflow: ellipsis !important;\n    white-space: nowrap !important;\n    word-wrap: normal !important;\n    min-width: 0;\n    width: 85%; }\n",""]);module.exports=exports},256:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(257);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},257:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actionsInstanceList__health {\n  width: 100%; }\n  .actionsInstanceList__health .euiFlexItem:last-of-type {\n    max-width: 100%;\n    overflow: hidden !important;\n    text-overflow: ellipsis !important;\n    white-space: nowrap !important;\n    word-wrap: normal !important;\n    min-width: 0;\n    width: 85%; }\n",""]);module.exports=exports},258:function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(259);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},259:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actionsInstanceList__health {\n  width: 100%; }\n  .actionsInstanceList__health .euiFlexItem:last-of-type {\n    max-width: 100%;\n    overflow: hidden !important;\n    text-overflow: ellipsis !important;\n    white-space: nowrap !important;\n    word-wrap: normal !important;\n    min-width: 0;\n    width: 85%; }\n",""]);module.exports=exports},74:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"AlertDetailsRoute",(function(){return AlertDetailsRoute}));__webpack_require__.d(__webpack_exports__,"getAlertData",(function(){return getAlertData}));__webpack_require__.d(__webpack_exports__,"default",(function(){return AlertDetailsRouteWithApi}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_Lodash_=__webpack_require__(4);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(19);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var common_=__webpack_require__(7);var lib_capabilities=__webpack_require__(87);var breadcrumb=__webpack_require__(134);var doc_title=__webpack_require__(135);var with_bulk_alert_api_operations=__webpack_require__(95);var external_kbnSharedDeps_Moment_=__webpack_require__(38);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_ElasticEuiLibServices_=__webpack_require__(72);var constants=__webpack_require__(3);var alert_instances=__webpack_require__(251);const alertInstancesTableColumns=(onMuteAction,readOnly)=>[{field:"instance",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.columns.instance",{defaultMessage:"Instance"}),sortable:false,truncateText:true,width:"45%","data-test-subj":"alertInstancesTableCell-instance",render:value=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{anchorClassName:"eui-textTruncate",content:value},external_kbnSharedDeps_React_default.a.createElement("span",null,value))},{field:"status",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.columns.status",{defaultMessage:"Status"}),width:"15%",render:(value,instance)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:value.healthColor,className:"actionsInstanceList__health"},value.label,value.actionGroup?` (${value.actionGroup})`:``),sortable:false,"data-test-subj":"alertInstancesTableCell-status"},{field:"start",width:"190px",render:(value,instance)=>value?external_kbnSharedDeps_Moment_default()(value).format("D MMM YYYY @ HH:mm:ss"):"",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.columns.start",{defaultMessage:"Start"}),sortable:false,"data-test-subj":"alertInstancesTableCell-start"},{field:"duration",render:(value,instance)=>value?durationAsString(external_kbnSharedDeps_Moment_default.a.duration(value)):"",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.columns.duration",{defaultMessage:"Duration"}),sortable:false,width:"80px","data-test-subj":"alertInstancesTableCell-duration"},{field:"",align:external_kbnSharedDeps_ElasticEuiLibServices_["RIGHT_ALIGNMENT"],width:"60px",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.columns.mute",{defaultMessage:"Mute"}),render:alertInstance=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:"mute",showLabel:false,compressed:true,checked:alertInstance.isMuted,disabled:readOnly,"data-test-subj":`muteAlertInstanceButton_${alertInstance.instance}`,onChange:()=>onMuteAction(alertInstance)})),sortable:false,"data-test-subj":"alertInstancesTableCell-actions"}];function durationAsString(duration){return[duration.hours(),duration.minutes(),duration.seconds()].map(value=>Object(external_kbnSharedDeps_Lodash_["padStart"])(`${value}`,2,"0")).join(":")}function AlertInstances({alert:alert,alertType:alertType,readOnly:readOnly,alertInstanceSummary:alertInstanceSummary,muteAlertInstance:muteAlertInstance,unmuteAlertInstance:unmuteAlertInstance,requestRefresh:requestRefresh,durationEpoch:durationEpoch=Date.now()}){const[pagination,setPagination]=Object(external_kbnSharedDeps_React_["useState"])({index:0,size:constants["c"]});const alertInstances=Object.entries(alertInstanceSummary.instances).map(([instanceId,instance])=>alertInstanceToListItem(durationEpoch,alertType,instanceId,instance)).sort((leftInstance,rightInstance)=>leftInstance.sortPriority-rightInstance.sortPriority);const pageOfAlertInstances=getPage(alertInstances,pagination);const onMuteAction=async instance=>{await(instance.isMuted?unmuteAlertInstance(alert,instance.instance):muteAlertInstance(alert,instance.instance));requestRefresh()};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xl"}),external_kbnSharedDeps_React_default.a.createElement("input",{type:"hidden","data-test-subj":"alertInstancesDurationEpoch",name:"alertInstancesDurationEpoch",value:durationEpoch}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:pageOfAlertInstances,pagination:{pageIndex:pagination.index,pageSize:pagination.size,totalItemCount:alertInstances.length},onChange:({page:changedPage})=>{setPagination(changedPage)},rowProps:()=>({"data-test-subj":"alert-instance-row"}),cellProps:()=>({"data-test-subj":"cell"}),columns:alertInstancesTableColumns(onMuteAction,readOnly),"data-test-subj":"alertInstancesList",tableLayout:"fixed",className:"alertInstancesList"}))}const AlertInstancesWithApi=Object(with_bulk_alert_api_operations["a"])(AlertInstances);function getPage(items,pagination){return Object(external_kbnSharedDeps_Lodash_["chunk"])(items,pagination.size)[pagination.index]||[]}const ACTIVE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.status.active",{defaultMessage:"Active"});const INACTIVE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.alertInstancesList.status.inactive",{defaultMessage:"OK"});function getActionGroupName(alertType,actionGroupId){var _alertType$actionGrou;actionGroupId=actionGroupId||alertType.defaultActionGroupId;const actionGroup=alertType===null||alertType===void 0?void 0:(_alertType$actionGrou=alertType.actionGroups)===null||_alertType$actionGrou===void 0?void 0:_alertType$actionGrou.find(group=>group.id===actionGroupId);return actionGroup===null||actionGroup===void 0?void 0:actionGroup.name}function alertInstanceToListItem(durationEpoch,alertType,instanceId,instance){const isMuted=!!(instance!==null&&instance!==void 0&&instance.muted);const status=(instance===null||instance===void 0?void 0:instance.status)==="Active"?{label:ACTIVE_LABEL,actionGroup:getActionGroupName(alertType,instance===null||instance===void 0?void 0:instance.actionGroupId),healthColor:"primary"}:{label:INACTIVE_LABEL,healthColor:"subdued"};const start=instance!==null&&instance!==void 0&&instance.activeStartDate?new Date(instance.activeStartDate):undefined;const duration=start?durationEpoch-start.valueOf():0;const sortPriority=getSortPriorityByStatus(instance===null||instance===void 0?void 0:instance.status);return{instance:instanceId,status:status,start:start,duration:duration,isMuted:isMuted,sortPriority:sortPriority}}function getSortPriorityByStatus(status){switch(status){case"Active":return 0;case"OK":return 1}return 2}var kibana=__webpack_require__(34);var center_justified_spinner=__webpack_require__(36);const AlertInstancesRoute=({alert:alert,alertType:alertType,readOnly:readOnly,requestRefresh:requestRefresh,loadAlertInstanceSummary:loadAlertInstanceSummary})=>{const{notifications:{toasts:toasts}}=Object(kibana["b"])().services;const[alertInstanceSummary,setAlertInstanceSummary]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getAlertInstanceSummary(alert.id,loadAlertInstanceSummary,setAlertInstanceSummary,toasts)},[alert]);return alertInstanceSummary?external_kbnSharedDeps_React_default.a.createElement(AlertInstancesWithApi,{requestRefresh:requestRefresh,alert:alert,alertType:alertType,readOnly:readOnly,alertInstanceSummary:alertInstanceSummary}):external_kbnSharedDeps_React_default.a.createElement(center_justified_spinner["a"],null)};async function getAlertInstanceSummary(alertId,loadAlertInstanceSummary,setAlertInstanceSummary,toasts){try{const loadedInstanceSummary=await loadAlertInstanceSummary(alertId);setAlertInstanceSummary(loadedInstanceSummary)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.unableToLoadAlertInstanceSummaryMessage",{defaultMessage:"Unable to load alert instance summary: {message}",values:{message:e.message}})})}}const AlertInstancesRouteWithApi=Object(with_bulk_alert_api_operations["a"])(AlertInstancesRoute);var Option=__webpack_require__(91);var pipeable=__webpack_require__(93);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const NO_NAVIGATION=false;const ViewInApp=({alert:alert})=>{const{application:{navigateToApp:navigateToApp},alerts:maybeAlerting}=Object(kibana["b"])().services;const[alertNavigation,setAlertNavigation]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{Object(pipeable["pipe"])(Object(Option["fromNullable"])(maybeAlerting),Object(Option["fold"])(()=>setAlertNavigation(NO_NAVIGATION),alerts=>alerts.getNavigation(alert.id).then(nav=>nav?setAlertNavigation(nav):setAlertNavigation(NO_NAVIGATION)).catch(()=>{setAlertNavigation(NO_NAVIGATION)})))},[alert.id,maybeAlerting]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],_extends({"data-test-subj":"alertDetails-viewInApp",isLoading:alertNavigation===null,disabled:!hasNavigation(alertNavigation),iconType:"popout"},getNavigationHandler(alertNavigation,alert,navigateToApp)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.viewAlertInAppButtonLabel",defaultMessage:"View in app"}))};function hasNavigation(alertNavigation){return alertNavigation?alertNavigation.hasOwnProperty("state")||alertNavigation.hasOwnProperty("path"):NO_NAVIGATION}function getNavigationHandler(alertNavigation,alert,navigateToApp){return hasNavigation(alertNavigation)?{onClick:()=>{navigateToApp(alert.consumer,alertNavigation)}}:{}}var alert_form=__webpack_require__(15);var translations=__webpack_require__(101);var alert_reducer=__webpack_require__(100);const AlertDetails=({alert:alert,alertType:alertType,actionTypes:actionTypes,disableAlert:disableAlert,enableAlert:enableAlert,unmuteAlert:unmuteAlert,muteAlert:muteAlert,requestRefresh:requestRefresh})=>{var _alert$executionStatu,_alert$executionStatu2;const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{application:{capabilities:capabilities},alertTypeRegistry:alertTypeRegistry,actionTypeRegistry:actionTypeRegistry,setBreadcrumbs:setBreadcrumbs,chrome:chrome,http:http}=Object(kibana["b"])().services;const[{},dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(alert_reducer["a"],{alert:alert});const setInitialAlert=value=>{dispatch({command:{type:"setAlert"},payload:{key:"alert",value:value}})};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setBreadcrumbs([Object(breadcrumb["b"])("alerts"),Object(breadcrumb["a"])(alert.id,alert.name)]);chrome.docTitle.change(Object(doc_title["a"])("alerts"))},[]);const canExecuteActions=Object(lib_capabilities["c"])(capabilities);const canSaveAlert=Object(lib_capabilities["a"])(alert,alertType)&&(canExecuteActions||!canExecuteActions&&alert.actions.length===0);const actionTypesByTypeId=Object(external_kbnSharedDeps_Lodash_["keyBy"])(actionTypes,"id");const hasEditButton=canSaveAlert&&(alertTypeRegistry.has(alert.alertTypeId)?!alertTypeRegistry.get(alert.alertTypeId).requiresAppContext:false);const alertActions=alert.actions;const uniqueActions=Array.from(new Set(alertActions.map(item=>item.actionTypeId)));const[isEnabled,setIsEnabled]=Object(external_kbnSharedDeps_React_["useState"])(alert.enabled);const[isMuted,setIsMuted]=Object(external_kbnSharedDeps_React_["useState"])(alert.muteAll);const[editFlyoutVisible,setEditFlyoutVisibility]=Object(external_kbnSharedDeps_React_["useState"])(false);const[dissmissAlertErrors,setDissmissAlertErrors]=Object(external_kbnSharedDeps_React_["useState"])(false);const setAlert=async()=>{history.push(constants["f"].replace(`:alertId`,alert.id))};const getAlertStatusErrorReasonText=()=>{if(alert.executionStatus.error&&alert.executionStatus.error.reason){return translations["b"][alert.executionStatus.error.reason]}else{return translations["b"].unknown}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"alertDetailsTitle"},alert.name)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"xs"},hasEditButton?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"openEditAlertFlyoutButton",iconType:"pencil",onClick:()=>setEditFlyoutVisibility(true),name:"edit",disabled:!alertType.enabledInLicense},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.editAlertButtonLabel",defaultMessage:"Edit"})),editFlyoutVisible&&external_kbnSharedDeps_React_default.a.createElement(alert_form["e"],{initialAlert:alert,onClose:()=>{setInitialAlert(alert);setEditFlyoutVisibility(false)},actionTypeRegistry:actionTypeRegistry,alertTypeRegistry:alertTypeRegistry,reloadAlerts:setAlert}))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"refreshAlertsButton",iconType:"refresh",onClick:requestRefresh,name:"refresh",color:"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.refreshAlertsButtonLabel",defaultMessage:"Refresh"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ViewInApp,{alert:alert}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{wrap:true,responsive:false,gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.alertTypeTitle",defaultMessage:"Type"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":"alertTypeLabel"},alertType.name)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},uniqueActions&&uniqueActions.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.actionsTex",defaultMessage:"Actions"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{wrap:true,gutterSize:"s"},uniqueActions.map((action,index)=>{var _actionTypesByTypeId$;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index,grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"hollow","data-test-subj":"actionTypeLabel"},(_actionTypesByTypeId$=actionTypesByTypeId[action].name)!==null&&_actionTypesByTypeId$!==void 0?_actionTypesByTypeId$:action))}))):null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",wrap:true,responsive:false,gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{name:"disable",disabled:!canSaveAlert||!alertType.enabledInLicense,checked:!isEnabled,"data-test-subj":"disableSwitch",onChange:async()=>{if(isEnabled){setIsEnabled(false);await disableAlert(alert)}else{setIsEnabled(true);await enableAlert(alert)}requestRefresh()},label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.collapsedItemActons.disableTitle",defaultMessage:"Disable"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{name:"mute",checked:isMuted,disabled:!canSaveAlert||!isEnabled||!alertType.enabledInLicense,"data-test-subj":"muteSwitch",onChange:async()=>{if(isMuted){setIsMuted(false);await unmuteAlert(alert)}else{setIsMuted(true);await muteAlert(alert)}requestRefresh()},label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.collapsedItemActons.muteTitle",defaultMessage:"Mute"})}))))),!dissmissAlertErrors&&alert.executionStatus.status==="error"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger","data-test-subj":"alertErrorBanner",size:"s",title:getAlertStatusErrorReasonText(),iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"danger","data-test-subj":"alertErrorMessageText"},(_alert$executionStatu=alert.executionStatus.error)===null||_alert$executionStatu===void 0?void 0:_alert$executionStatu.message),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",wrap:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"danger",onClick:()=>setDissmissAlertErrors(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.dismissButtonTitle",defaultMessage:"Dismiss"}))),((_alert$executionStatu2=alert.executionStatus.error)===null||_alert$executionStatu2===void 0?void 0:_alert$executionStatu2.reason)===common_["AlertExecutionStatusErrorReasons"].License&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:`${http.basePath.get()}/app/management/stack/license_management`,color:"danger",target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.manageLicensePlanBannerLinkTitle",defaultMessage:"Manage license"}))))))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,alert.enabled?external_kbnSharedDeps_React_default.a.createElement(AlertInstancesRouteWithApi,{requestRefresh:requestRefresh,alert:alert,alertType:alertType,readOnly:!canSaveAlert}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:"Disabled Alert",color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertDetails.alertInstances.disabledAlert",defaultMessage:"This alert is disabled and cannot be displayed. Toggle Disable ↑ to activate it."}))))))))))};const AlertDetailsWithApi=Object(with_bulk_alert_api_operations["a"])(AlertDetails);var value_validators=__webpack_require__(5);var action_connector_api=__webpack_require__(35);function with_actions_api_operations_extends(){with_actions_api_operations_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return with_actions_api_operations_extends.apply(this,arguments)}function withActionOperations(WrappedComponent){return props=>{const{http:http}=Object(kibana["b"])().services;return external_kbnSharedDeps_React_default.a.createElement(WrappedComponent,with_actions_api_operations_extends({},props,{loadActionTypes:async()=>Object(action_connector_api["d"])({http:http})}))}}const AlertDetailsRoute=({match:{params:{alertId:alertId}},loadAlert:loadAlert,loadAlertTypes:loadAlertTypes,loadActionTypes:loadActionTypes})=>{const{http:http,notifications:{toasts:toasts}}=Object(kibana["b"])().services;const[alert,setAlert]=Object(external_kbnSharedDeps_React_["useState"])(null);const[alertType,setAlertType]=Object(external_kbnSharedDeps_React_["useState"])(null);const[actionTypes,setActionTypes]=Object(external_kbnSharedDeps_React_["useState"])(null);const[refreshToken,requestRefresh]=external_kbnSharedDeps_React_default.a.useState();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getAlertData(alertId,loadAlert,loadAlertTypes,loadActionTypes,setAlert,setAlertType,setActionTypes,toasts)},[alertId,http,loadActionTypes,loadAlert,loadAlertTypes,toasts,refreshToken]);return alert&&alertType&&actionTypes?external_kbnSharedDeps_React_default.a.createElement(AlertDetailsWithApi,{alert:alert,alertType:alertType,actionTypes:actionTypes,requestRefresh:async()=>requestRefresh(Date.now())}):external_kbnSharedDeps_React_default.a.createElement(center_justified_spinner["a"],null)};async function getAlertData(alertId,loadAlert,loadAlertTypes,loadActionTypes,setAlert,setAlertType,setActionTypes,toasts){try{const loadedAlert=await loadAlert(alertId);setAlert(loadedAlert);const[loadedAlertType,loadedActionTypes]=await Promise.all([loadAlertTypes().then(types=>types.find(type=>type.id===loadedAlert.alertTypeId)).then(Object(value_validators["d"])(`Invalid Alert Type: ${loadedAlert.alertTypeId}`)),loadActionTypes().then(Object(value_validators["e"])(new Set(loadedAlert.actions.map(action=>action.actionTypeId)),requiredActionType=>`Invalid Action Type: ${requiredActionType}`,action=>action.id))]);setAlertType(loadedAlertType);setActionTypes(loadedActionTypes)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertDetails.unableToLoadAlertMessage",{defaultMessage:"Unable to load alert: {message}",values:{message:e.message}})})}}const AlertDetailsRouteWithApi=withActionOperations(Object(with_bulk_alert_api_operations["a"])(AlertDetailsRoute))},95:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return withBulkAlertOperations}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _lib_alert_api__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(92);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(34);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function withBulkAlertOperations(WrappedComponent){return props=>{const{http:http}=Object(_common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__["b"])().services;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(WrappedComponent,_extends({},props,{muteAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["p"])({http:http,ids:items.filter(item=>!isAlertMuted(item)).map(item=>item.id)}),unmuteAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["s"])({http:http,ids:items.filter(isAlertMuted).map(item=>item.id)}),enableAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["g"])({http:http,ids:items.filter(isAlertDisabled).map(item=>item.id)}),disableAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["e"])({http:http,ids:items.filter(item=>!isAlertDisabled(item)).map(item=>item.id)}),deleteAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["c"])({http:http,ids:items.map(item=>item.id)}),muteAlert:async alert=>{if(!isAlertMuted(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["n"])({http:http,id:alert.id})}},unmuteAlert:async alert=>{if(isAlertMuted(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["q"])({http:http,id:alert.id})}},muteAlertInstance:async(alert,instanceId)=>{if(!isAlertInstanceMuted(alert,instanceId)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["o"])({http:http,id:alert.id,instanceId:instanceId})}},unmuteAlertInstance:async(alert,instanceId)=>{if(isAlertInstanceMuted(alert,instanceId)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["r"])({http:http,id:alert.id,instanceId:instanceId})}},enableAlert:async alert=>{if(isAlertDisabled(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["f"])({http:http,id:alert.id})}},disableAlert:async alert=>{if(!isAlertDisabled(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["d"])({http:http,id:alert.id})}},deleteAlert:async alert=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["c"])({http:http,ids:[alert.id]}),loadAlert:async alertId=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["h"])({http:http,alertId:alertId}),loadAlertState:async alertId=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["k"])({http:http,alertId:alertId}),loadAlertInstanceSummary:async alertId=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["j"])({http:http,alertId:alertId}),loadAlertTypes:async()=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["l"])({http:http}),getHealth:async()=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["a"])({http:http})}))}}function isAlertDisabled(alert){return alert.enabled===false}function isAlertMuted(alert){return alert.muteAll===true}function isAlertInstanceMuted(alert,instanceId){return alert.mutedInstanceIds.findIndex(muted=>muted===instanceId)>=0}}}]);