/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["triggersActionsUi_bundle_jsonpfunction"]=window["triggersActionsUi_bundle_jsonpfunction"]||[]).push([[12],Array(52).concat([function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"EditConectorTabs",(function(){return EditConectorTabs}));__webpack_require__.d(__webpack_exports__,"ConnectorEditFlyout",(function(){return ConnectorEditFlyout}));__webpack_require__.d(__webpack_exports__,"default",(function(){return ConnectorEditFlyout}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var Option=__webpack_require__(91);var action_connector_form=__webpack_require__(96);var pipeable=__webpack_require__(93);const TestConnectorForm=({connector:connector,executeEnabled:executeEnabled,executionResult:executionResult,actionParams:actionParams,setActionParams:setActionParams,onExecutAction:onExecutAction,isExecutingAction:isExecutingAction,actionTypeRegistry:actionTypeRegistry})=>{const actionTypeModel=actionTypeRegistry.get(connector.actionTypeId);const ParamsFieldsComponent=actionTypeModel.actionParamsFields;const actionErrors=actionTypeModel===null||actionTypeModel===void 0?void 0:actionTypeModel.validateParams(actionParams).errors;const hasErrors=!!Object.values(actionErrors).find(errors=>errors.length>0);const steps=[{title:"Create an action",children:ParamsFieldsComponent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Suspense"],{fallback:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})))},external_kbnSharedDeps_React_default.a.createElement(ParamsFieldsComponent,{actionParams:actionParams,index:0,errors:actionErrors,editAction:(field,value)=>setActionParams({...actionParams,[field]:value}),messageVariables:[],actionConnector:connector}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,"This Connector does not require any Action Parameter."))},{title:"Run the action",children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,executeEnabled?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{iconType:"alert",color:"warning"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Save your changes before testing the connector.",id:"xpack.triggersActionsUI.sections.testConnectorForm.executeTestDisabled"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"play",isLoading:isExecutingAction,isDisabled:!executeEnabled||hasErrors||isExecutingAction,"data-test-subj":"executeActionButton",onClick:onExecutAction},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Run",id:"xpack.triggersActionsUI.sections.testConnectorForm.executeTestButton"}))))},{title:"Results",children:Object(pipeable["pipe"])(executionResult,Object(Option["map"])(result=>result.status==="ok"?external_kbnSharedDeps_React_default.a.createElement(SuccessfulExecution,null):external_kbnSharedDeps_React_default.a.createElement(FailedExecussion,{executionResult:result})),Object(Option["getOrElse"])(()=>external_kbnSharedDeps_React_default.a.createElement(AwaitingExecution,null)))}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSteps"],{steps:steps})};const AwaitingExecution=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{"data-test-subj":"executionAwaiting"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"When you run the action, the results will show up here.",id:"xpack.triggersActionsUI.sections.testConnectorForm.awaitingExecutionDescription"})));const SuccessfulExecution=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.testConnectorForm.executionSuccessfulTitle",{defaultMessage:"Action was successful",values:{}}),color:"success","data-test-subj":"executionSuccessfulResult",iconType:"check"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Ensure the results are what you expect.",id:"xpack.triggersActionsUI.sections.testConnectorForm.executionSuccessfulDescription"})));const FailedExecussion=({executionResult:{message:message,serviceMessage:serviceMessage}})=>{const items=[{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.testConnectorForm.executionFailureDescription",{defaultMessage:"The following error was found:"}),description:message!==null&&message!==void 0?message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.testConnectorForm.executionFailureUnknownReason",{defaultMessage:"Unknown reason"})}];if(serviceMessage){items.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.testConnectorForm.executionFailureAdditionalDetails",{defaultMessage:"Details:"}),description:serviceMessage})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.testConnectorForm.executionFailureTitle",{defaultMessage:"Action failed to run"}),"data-test-subj":"executionFailureResult",color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:items}))};var connector_reducer=__webpack_require__(97);var action_connector_api=__webpack_require__(35);var lib_capabilities=__webpack_require__(87);var common=__webpack_require__(27);var connector_edit_flyout=__webpack_require__(115);var kibana=__webpack_require__(34);var value_validators=__webpack_require__(5);let EditConectorTabs;(function(EditConectorTabs){EditConectorTabs["Configuration"]="configuration";EditConectorTabs["Test"]="test"})(EditConectorTabs||(EditConectorTabs={}));const ConnectorEditFlyout=({initialConnector:initialConnector,onClose:onClose,tab:tab=EditConectorTabs.Configuration,reloadConnectors:reloadConnectors,consumer:consumer,actionTypeRegistry:actionTypeRegistry})=>{const{http:http,notifications:{toasts:toasts},docLinks:docLinks,application:{capabilities:capabilities}}=Object(kibana["b"])().services;const getConnectorWithoutSecrets=()=>({...initialConnector,secrets:{}});const canSave=Object(lib_capabilities["d"])(capabilities);const reducer=Object(connector_reducer["a"])();const[{connector:connector},dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(reducer,{connector:getConnectorWithoutSecrets()});const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[selectedTab,setTab]=Object(external_kbnSharedDeps_React_["useState"])(tab);const[hasChanges,setHasChanges]=Object(external_kbnSharedDeps_React_["useState"])(false);const setConnector=value=>{dispatch({command:{type:"setConnector"},payload:{key:"connector",value:value}})};const[testExecutionActionParams,setTestExecutionActionParams]=Object(external_kbnSharedDeps_React_["useState"])({});const[testExecutionResult,setTestExecutionResult]=Object(external_kbnSharedDeps_React_["useState"])(Option["none"]);const[isExecutingAction,setIsExecutinAction]=Object(external_kbnSharedDeps_React_["useState"])(false);const handleSetTab=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setTab(prevTab=>{if(prevTab===EditConectorTabs.Configuration){return EditConectorTabs.Test}if(testExecutionResult!==Option["none"]){setTestExecutionResult(Option["none"])}return EditConectorTabs.Configuration}),[testExecutionResult]);const closeFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setConnector(getConnectorWithoutSecrets());setHasChanges(false);setTestExecutionResult(Option["none"]);onClose()},[onClose]);const actionTypeModel=actionTypeRegistry.get(connector.actionTypeId);const{configErrors:configErrors,connectorBaseErrors:connectorBaseErrors,connectorErrors:connectorErrors,secretsErrors:secretsErrors}=!connector.isPreconfigured?Object(action_connector_form["b"])(connector,actionTypeModel):{configErrors:{},connectorBaseErrors:{},connectorErrors:{},secretsErrors:{}};const hasErrors=!!Object.keys(connectorErrors).find(errorKey=>connectorErrors[errorKey].length>=1);const onActionConnectorSave=async()=>await Object(action_connector_api["f"])({http:http,connector:connector,id:connector.id}).then(savedConnector=>{toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.editConnectorForm.updateSuccessNotificationText",{defaultMessage:"Updated '{connectorName}'",values:{connectorName:savedConnector.name}}));return savedConnector}).catch(errorRes=>{var _errorRes$body$messag,_errorRes$body;toasts.addDanger((_errorRes$body$messag=(_errorRes$body=errorRes.body)===null||_errorRes$body===void 0?void 0:_errorRes$body.message)!==null&&_errorRes$body$messag!==void 0?_errorRes$body$messag:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.editConnectorForm.updateErrorNotificationText",{defaultMessage:"Cannot update a connector."}));return undefined});const flyoutTitle=connector.isPreconfigured?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",{id:"flyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"{connectorName}",id:"xpack.triggersActionsUI.sections.preconfiguredConnectorForm.flyoutTitle",values:{connectorName:initialConnector.name}})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:"Preconfigured","data-test-subj":"preconfiguredBadge",tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.preconfiguredConnectorForm.tooltipContent",{defaultMessage:"This connector is preconfigured and cannot be edited"})}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"{actionDescription}",id:"xpack.triggersActionsUI.sections.editConnectorForm.actionTypeDescription",values:{actionDescription:actionTypeModel.selectMessage}}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",{id:"flyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Edit connector",id:"xpack.triggersActionsUI.sections.editConnectorForm.flyoutPreconfiguredTitle"})));const onExecutAction=()=>{setIsExecutinAction(true);return Object(action_connector_api["c"])({id:connector.id,params:testExecutionActionParams,http:http}).then(result=>{setIsExecutinAction(false);setTestExecutionResult(Object(Option["some"])(result));return result}).catch(ex=>{const result=Object(common["c"])(ex)?ex:{actionId:connector.id,status:"error",message:ex.message};setIsExecutinAction(false);setTestExecutionResult(Object(Option["some"])(result));return result})};const onSaveClicked=async(closeAfterSave=true)=>{if(hasErrors){setConnector(Object(value_validators["b"])(connector,configErrors,secretsErrors,connectorBaseErrors));return}setIsSaving(true);const savedAction=await onActionConnectorSave();setIsSaving(false);if(savedAction){setHasChanges(false);if(closeAfterSave){closeFlyout()}if(reloadConnectors){reloadConnectors()}}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:closeFlyout,"aria-labelledby":"flyoutActionEditTitle",size:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},actionTypeModel?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:actionTypeModel.iconClass,size:"m"})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,flyoutTitle)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],{className:"connectorEditFlyoutTabs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:handleSetTab,"data-test-subj":"configureConnectorTab",isSelected:EditConectorTabs.Configuration===selectedTab},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.editConnectorForm.tabText",{defaultMessage:"Configuration"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:handleSetTab,"data-test-subj":"testConnectorTab",isSelected:EditConectorTabs.Test===selectedTab},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.testConnectorForm.tabText",{defaultMessage:"Test"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,selectedTab===EditConectorTabs.Configuration?!connector.isPreconfigured?external_kbnSharedDeps_React_default.a.createElement(action_connector_form["a"],{connector:connector,errors:connectorErrors,dispatch:changes=>{setHasChanges(true);setTestExecutionResult(Option["none"]);dispatch(changes)},actionTypeRegistry:actionTypeRegistry,consumer:consumer}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.editConnectorForm.descriptionText",{defaultMessage:"This connector is readonly."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.preconfiguredConnectors,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.editConnectorForm.preconfiguredHelpLabel",defaultMessage:"Learn more about preconfigured connectors."}))):external_kbnSharedDeps_React_default.a.createElement(TestConnectorForm,{connector:connector,executeEnabled:!hasChanges,actionParams:testExecutionActionParams,setActionParams:setTestExecutionActionParams,onExecutAction:onExecutAction,isExecutingAction:isExecutingAction,executionResult:testExecutionResult,actionTypeRegistry:actionTypeRegistry})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:closeFlyout,"data-test-subj":"cancelSaveEditedConnectorButton"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.editConnectorForm.cancelButtonLabel",{defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},canSave&&actionTypeModel&&!connector.isPreconfigured?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"secondary","data-test-subj":"saveEditedActionButton",isLoading:isSaving||isExecutingAction,onClick:async()=>{await onSaveClicked(false)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.editConnectorForm.saveButtonLabel",defaultMessage:"Save"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,color:"secondary","data-test-subj":"saveAndCloseEditedActionButton",type:"submit",isLoading:isSaving||isExecutingAction,onClick:async()=>{await onSaveClicked()}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.editConnectorForm.saveAndCloseButtonLabel",defaultMessage:"Save & close"})))):null)))))}},,,,,,,,,,,,,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"TriggersActionsUIHome",(function(){return TriggersActionsUIHome}));__webpack_require__.d(__webpack_exports__,"default",(function(){return TriggersActionsUIHome}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(19);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var constants=__webpack_require__(3);var breadcrumb=__webpack_require__(134);var doc_title=__webpack_require__(135);var lib_capabilities=__webpack_require__(87);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_Lodash_=__webpack_require__(4);var action_connector_api=__webpack_require__(35);var connector_add_flyout=__webpack_require__(54);var connector_edit_flyout=__webpack_require__(52);var kibana=__webpack_require__(34);const DeleteModalConfirmation=({idsToDelete:idsToDelete,apiDeleteCall:apiDeleteCall,onDeleted:onDeleted,onCancel:onCancel,onErrors:onErrors,singleTitle:singleTitle,multipleTitle:multipleTitle,setIsLoadingState:setIsLoadingState})=>{const[deleteModalFlyoutVisible,setDeleteModalVisibility]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setDeleteModalVisibility(idsToDelete.length>0)},[idsToDelete]);const{http:http,notifications:{toasts:toasts}}=Object(kibana["b"])().services;const numIdsToDelete=idsToDelete.length;if(!deleteModalFlyoutVisible){return null}const confirmModalText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.deleteSelectedIdsConfirmModal.descriptionText",{defaultMessage:"You can't recover {numIdsToDelete, plural, one {a deleted {singleTitle}} other {deleted {multipleTitle}}}.",values:{numIdsToDelete:numIdsToDelete,singleTitle:singleTitle,multipleTitle:multipleTitle}});const confirmButtonText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.deleteSelectedIdsConfirmModal.deleteButtonLabel",{defaultMessage:"Delete {numIdsToDelete, plural, one {{singleTitle}} other {# {multipleTitle}}} ",values:{numIdsToDelete:numIdsToDelete,singleTitle:singleTitle,multipleTitle:multipleTitle}});const cancelButtonText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.deleteSelectedIdsConfirmModal.cancelButtonLabel",{defaultMessage:"Cancel"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{buttonColor:"danger","data-test-subj":"deleteIdsConfirmation",title:confirmButtonText,onCancel:()=>{setDeleteModalVisibility(false);onCancel()},onConfirm:async()=>{setDeleteModalVisibility(false);setIsLoadingState(true);const{successes:successes,errors:errors}=await apiDeleteCall({ids:idsToDelete,http:http});setIsLoadingState(false);const numSuccesses=successes.length;const numErrors=errors.length;if(numSuccesses>0){toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.deleteSelectedIdsSuccessNotification.descriptionText",{defaultMessage:"Deleted {numSuccesses, number} {numSuccesses, plural, one {{singleTitle}} other {{multipleTitle}}}",values:{numSuccesses:numSuccesses,singleTitle:singleTitle,multipleTitle:multipleTitle}}))}if(numErrors>0){toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.deleteSelectedIdsErrorNotification.descriptionText",{defaultMessage:"Failed to delete {numErrors, number} {numErrors, plural, one {{singleTitle}} other {{multipleTitle}}}",values:{numErrors:numErrors,singleTitle:singleTitle,multipleTitle:multipleTitle}}));await onErrors()}await onDeleted(successes)},cancelButtonText:cancelButtonText,confirmButtonText:confirmButtonText},confirmModalText)};var check_action_type_enabled=__webpack_require__(98);var actions_connectors_list=__webpack_require__(206);var empty_connectors_prompt=__webpack_require__(215);const EmptyConnectorsPrompt=({onCTAClicked:onCTAClicked})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{"data-test-subj":"createFirstConnectorEmptyPrompt",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"logoSlack",size:"xl",className:"actEmptyConnectorsPrompt__logo"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"logoGmail",size:"xl",className:"actEmptyConnectorsPrompt__logo"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"logoWebhook",size:"xl",className:"actEmptyConnectorsPrompt__logo"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.emptyConnectorsPrompt.addActionEmptyTitle",defaultMessage:"Create your first connector"})))),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.emptyConnectorsPrompt.addActionEmptyBody",defaultMessage:"Configure email, Slack, Elasticsearch, and third-party services that Kibana runs."})),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"createFirstActionButton",key:"create-action",fill:true,iconType:"plusInCircle",iconSide:"left",onClick:onCTAClicked},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.emptyConnectorsPrompt.addActionButtonLabel",defaultMessage:"Create connector"}))});var public_0=__webpack_require__(53);var center_justified_spinner=__webpack_require__(36);const ActionsConnectorsList=()=>{const{http:http,notifications:{toasts:toasts},application:{capabilities:capabilities},actionTypeRegistry:actionTypeRegistry}=Object(kibana["b"])().services;const canDelete=Object(lib_capabilities["b"])(capabilities);const canExecute=Object(lib_capabilities["c"])(capabilities);const canSave=Object(lib_capabilities["d"])(capabilities);const[actionTypesIndex,setActionTypesIndex]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[actions,setActions]=Object(external_kbnSharedDeps_React_["useState"])([]);const[pageIndex,setPageIndex]=Object(external_kbnSharedDeps_React_["useState"])(0);const[selectedItems,setSelectedItems]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isLoadingActionTypes,setIsLoadingActionTypes]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoadingActions,setIsLoadingActions]=Object(external_kbnSharedDeps_React_["useState"])(false);const[addFlyoutVisible,setAddFlyoutVisibility]=Object(external_kbnSharedDeps_React_["useState"])(false);const[editConnectorProps,setEditConnectorProps]=Object(external_kbnSharedDeps_React_["useState"])({});const[connectorsToDelete,setConnectorsToDelete]=Object(external_kbnSharedDeps_React_["useState"])([]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{loadActions()},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{try{setIsLoadingActionTypes(true);const actionTypes=await Object(action_connector_api["d"])({http:http});const index={};for(const actionTypeItem of actionTypes){index[actionTypeItem.id]=actionTypeItem}setActionTypesIndex(index)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadActionTypesMessage",{defaultMessage:"Unable to load action types"})})}finally{setIsLoadingActionTypes(false)}})()},[]);const actionConnectorTableItems=actionTypesIndex?actions.filter(action=>!public_0["DEFAULT_HIDDEN_ACTION_TYPES"].includes(action.actionTypeId)).map(action=>({...action,actionType:actionTypesIndex[action.actionTypeId]?actionTypesIndex[action.actionTypeId].name:action.actionTypeId})):[];const actionTypesList=actionTypesIndex?Object.values(actionTypesIndex).filter(actionType=>!public_0["DEFAULT_HIDDEN_ACTION_TYPES"].includes(actionType.id)).map(actionType=>({value:actionType.id,name:`${actionType.name} (${getActionsCountByActionType(actions,actionType.id)})`})).sort((a,b)=>a.name.localeCompare(b.name)):[];async function loadActions(){setIsLoadingActions(true);try{const actionsResponse=await Object(action_connector_api["e"])({http:http});setActions(actionsResponse)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.unableToLoadActionsMessage",{defaultMessage:"Unable to load connectors"})})}finally{setIsLoadingActions(false)}}async function editItem(actionConnector,tab){setEditConnectorProps({initialConnector:actionConnector,tab:tab})}const actionsTableColumns=[{field:"name","data-test-subj":"connectorsTableCell-name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.nameTitle",{defaultMessage:"Name"}),sortable:false,truncateText:true,render:(value,item)=>{var _actionTypesIndex$ite;const checkEnabledResult=Object(check_action_type_enabled["b"])(actionTypesIndex&&actionTypesIndex[item.actionTypeId]);const link=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":`edit${item.id}`,onClick:()=>editItem(item,connector_edit_flyout["EditConectorTabs"].Configuration),key:item.id,disabled:actionTypesIndex?!((_actionTypesIndex$ite=actionTypesIndex[item.actionTypeId])!==null&&_actionTypesIndex$ite!==void 0&&_actionTypesIndex$ite.enabled):true},value);return checkEnabledResult.isEnabled?link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,link,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{type:"questionInCircle",content:checkEnabledResult.message,position:"right"}))}},{field:"actionType","data-test-subj":"connectorsTableCell-actionType",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actionTypeTitle",{defaultMessage:"Type"}),sortable:false,truncateText:true},{name:"",render:item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",alignItems:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(DeleteOperation,{canDelete:canDelete,item:item,onDelete:()=>setConnectorsToDelete([item.id])}),external_kbnSharedDeps_React_default.a.createElement(RunOperation,{canExecute:canExecute&&actionTypesIndex&&actionTypesIndex[item.actionTypeId],item:item,onRun:()=>editItem(item,connector_edit_flyout["EditConectorTabs"].Test)}))}];const table=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{loading:isLoadingActions||isLoadingActionTypes,items:actionConnectorTableItems,sorting:true,itemId:"id",columns:actionsTableColumns,rowProps:item=>{var _actionTypesIndex$ite2;return{className:!actionTypesIndex||!((_actionTypesIndex$ite2=actionTypesIndex[item.actionTypeId])!==null&&_actionTypesIndex$ite2!==void 0&&_actionTypesIndex$ite2.enabled)?"actConnectorsList__tableRowDisabled":"","data-test-subj":"connectors-row"}},cellProps:item=>{var _actionTypesIndex$ite3;return{"data-test-subj":"cell",className:!actionTypesIndex||!((_actionTypesIndex$ite3=actionTypesIndex[item.actionTypeId])!==null&&_actionTypesIndex$ite3!==void 0&&_actionTypesIndex$ite3.enabled)?"actConnectorsList__tableCellDisabled":""}},"data-test-subj":"actionsTable",pagination:{initialPageIndex:0,pageIndex:pageIndex},onTableChange:({page:page})=>{if(page){setPageIndex(page.index)}},selection:canDelete?{onSelectionChange(updatedSelectedItemsList){setSelectedItems(updatedSelectedItemsList)},selectable:({isPreconfigured:isPreconfigured})=>!isPreconfigured}:undefined,search:{filters:[{type:"field_value_selection",field:"actionTypeId",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.filters.actionTypeIdName",{defaultMessage:"Type"}),multiSelect:"or",options:actionTypesList}],toolsLeft:selectedItems.length===0||!canDelete?[]:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"delete",iconType:"trash",color:"danger","data-test-subj":"bulkDelete",onClick:()=>{setConnectorsToDelete(selectedItems.map(selected=>selected.id))},title:canDelete?undefined:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.buttons.deleteDisabledTitle",{defaultMessage:"Unable to delete connectors"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.actionsConnectorsList.buttons.deleteLabel",defaultMessage:"Delete {count}",values:{count:selectedItems.length}}))],toolsRight:canSave?[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"createActionButton",key:"create-action",fill:true,onClick:()=>setAddFlyoutVisibility(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.actionsConnectorsList.addActionButtonLabel",defaultMessage:"Create connector"}))]:[]}});return external_kbnSharedDeps_React_default.a.createElement("section",{"data-test-subj":"actionsList"},external_kbnSharedDeps_React_default.a.createElement(DeleteModalConfirmation,{onDeleted:deleted=>{if(selectedItems.length===0||selectedItems.length===deleted.length){const updatedActions=actions.filter(action=>action.id&&!connectorsToDelete.includes(action.id));setActions(updatedActions);setSelectedItems([])}setConnectorsToDelete([])},onErrors:async()=>{await loadActions();setConnectorsToDelete([])},onCancel:async()=>{setConnectorsToDelete([])},apiDeleteCall:action_connector_api["b"],idsToDelete:connectorsToDelete,singleTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.singleTitle",{defaultMessage:"connector"}),multipleTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.multipleTitle",{defaultMessage:"connectors"}),setIsLoadingState:isLoading=>setIsLoadingActionTypes(isLoading)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),(isLoadingActions||isLoadingActionTypes)&&external_kbnSharedDeps_React_default.a.createElement(center_justified_spinner["a"],null),actionConnectorTableItems.length!==0&&table,actionConnectorTableItems.length===0&&canSave&&!isLoadingActions&&!isLoadingActionTypes&&external_kbnSharedDeps_React_default.a.createElement(EmptyConnectorsPrompt,{onCTAClicked:()=>setAddFlyoutVisibility(true)}),actionConnectorTableItems.length===0&&!canSave&&external_kbnSharedDeps_React_default.a.createElement(NoPermissionPrompt,null),addFlyoutVisible?external_kbnSharedDeps_React_default.a.createElement(connector_add_flyout["default"],{onClose:()=>{setAddFlyoutVisibility(false)},onTestConnector:connector=>editItem(connector,connector_edit_flyout["EditConectorTabs"].Test),reloadConnectors:loadActions,actionTypeRegistry:actionTypeRegistry}):null,editConnectorProps.initialConnector?external_kbnSharedDeps_React_default.a.createElement(connector_edit_flyout["default"],{key:`${editConnectorProps.initialConnector.id}${editConnectorProps.tab?`:${editConnectorProps.tab}`:``}`,initialConnector:editConnectorProps.initialConnector,tab:editConnectorProps.tab,onClose:()=>{setEditConnectorProps(Object(external_kbnSharedDeps_Lodash_["omit"])(editConnectorProps,"initialConnector"))},reloadConnectors:loadActions,actionTypeRegistry:actionTypeRegistry}):null)};function getActionsCountByActionType(actions,actionTypeId){return actions.filter(action=>action.actionTypeId===actionTypeId).length}const DeleteOperation=({item:item,canDelete:canDelete,onDelete:onDelete})=>{if(item.isPreconfigured){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{"data-test-subj":"preConfiguredTitleMessage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertForm.preconfiguredTitleMessage",{defaultMessage:"Preconfigured"}),tooltipContent:"This connector can't be deleted."}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:canDelete?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionDescription",{defaultMessage:"Delete this connector"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionDisabledDescription",{defaultMessage:"Unable to delete connectors"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{isDisabled:!canDelete,"data-test-subj":"deleteConnector","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.deleteActionName",{defaultMessage:"Delete"}),onClick:onDelete,iconType:"trash"})))};const RunOperation=({item:item,canExecute:canExecute,onRun:onRun})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:canExecute?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorDescription",{defaultMessage:"Run this connector"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorDisabledDescription",{defaultMessage:"Unable to run connectors"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{isDisabled:!canExecute,"data-test-subj":"runConnector","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.actionsConnectorsList.connectorsListTable.columns.actions.runConnectorName",{defaultMessage:"Run"}),onClick:onRun,iconType:"play"})));const NoPermissionPrompt=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.actionsConnectorsList.noPermissionToCreateTitle",defaultMessage:"No permissions to create connectors"})),body:external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"permissionDeniedMessage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.actionsConnectorsList.noPermissionToCreateDescription",defaultMessage:"Contact your system administrator."}))});var alert_form=__webpack_require__(15);const BulkOperationPopover=({children:children})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),"data-test-subj":"bulkAction",panelPaddingSize:"s",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"arrowDown",iconSide:"right",onClick:()=>setIsPopoverOpen(!isPopoverOpen)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.buttonTitle",defaultMessage:"Manage alerts"}))},children&&external_kbnSharedDeps_React_default.a.Children.map(children,child=>external_kbnSharedDeps_React_default.a.isValidElement(child)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.cloneElement(child,{})):child))};var with_bulk_alert_api_operations=__webpack_require__(95);var alert_quick_edit_buttons=__webpack_require__(224);const AlertQuickEditButtons=({selectedItems:selectedItems,onPerformingAction:onPerformingAction=noop,onActionPerformed:onActionPerformed=noop,muteAlerts:muteAlerts,unmuteAlerts:unmuteAlerts,enableAlerts:enableAlerts,disableAlerts:disableAlerts,setAlertsToDelete:setAlertsToDelete})=>{const{notifications:{toasts:toasts}}=Object(kibana["b"])().services;const[isMutingAlerts,setIsMutingAlerts]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isUnmutingAlerts,setIsUnmutingAlerts]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isEnablingAlerts,setIsEnablingAlerts]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isDisablingAlerts,setIsDisablingAlerts]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isDeletingAlerts,setIsDeletingAlerts]=Object(external_kbnSharedDeps_React_["useState"])(false);const allAlertsMuted=selectedItems.every(isAlertMuted);const allAlertsDisabled=selectedItems.every(isAlertDisabled);const isPerformingAction=isMutingAlerts||isUnmutingAlerts||isEnablingAlerts||isDisablingAlerts||isDeletingAlerts;const hasDisabledByLicenseAlertTypes=!!selectedItems.find(alertItem=>!alertItem.enabledInLicense);async function onmMuteAllClick(){onPerformingAction();setIsMutingAlerts(true);try{await muteAlerts(selectedItems)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.failedToMuteAlertsMessage",{defaultMessage:"Failed to mute alert(s)"})})}finally{setIsMutingAlerts(false);onActionPerformed()}}async function onUnmuteAllClick(){onPerformingAction();setIsUnmutingAlerts(true);try{await unmuteAlerts(selectedItems)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.failedToUnmuteAlertsMessage",{defaultMessage:"Failed to unmute alert(s)"})})}finally{setIsUnmutingAlerts(false);onActionPerformed()}}async function onEnableAllClick(){onPerformingAction();setIsEnablingAlerts(true);try{await enableAlerts(selectedItems)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.failedToEnableAlertsMessage",{defaultMessage:"Failed to enable alert(s)"})})}finally{setIsEnablingAlerts(false);onActionPerformed()}}async function onDisableAllClick(){onPerformingAction();setIsDisablingAlerts(true);try{await disableAlerts(selectedItems)}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.failedToDisableAlertsMessage",{defaultMessage:"Failed to disable alert(s)"})})}finally{setIsDisablingAlerts(false);onActionPerformed()}}async function deleteSelectedItems(){onPerformingAction();setIsDeletingAlerts(true);try{setAlertsToDelete(selectedItems.map(selected=>selected.id))}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.failedToDeleteAlertsMessage",{defaultMessage:"Failed to delete alert(s)"})})}finally{setIsDeletingAlerts(false);onActionPerformed()}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"baseline",direction:"column",gutterSize:"none"},!allAlertsMuted&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onmMuteAllClick,isLoading:isMutingAlerts,isDisabled:isPerformingAction||hasDisabledByLicenseAlertTypes,"data-test-subj":"muteAll"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.muteAllTitle",defaultMessage:"Mute"}))),allAlertsMuted&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onUnmuteAllClick,isLoading:isUnmutingAlerts,isDisabled:isPerformingAction||hasDisabledByLicenseAlertTypes,"data-test-subj":"unmuteAll"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.unmuteAllTitle",defaultMessage:"Unmute"}))),allAlertsDisabled&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onEnableAllClick,isLoading:isEnablingAlerts,isDisabled:isPerformingAction||hasDisabledByLicenseAlertTypes,"data-test-subj":"enableAll"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.enableAllTitle",defaultMessage:"Enable"}))),!allAlertsDisabled&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onDisableAllClick,isLoading:isDisablingAlerts,isDisabled:isPerformingAction||hasDisabledByLicenseAlertTypes,"data-test-subj":"disableAll"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.disableAllTitle",defaultMessage:"Disable"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:deleteSelectedItems,isLoading:isDeletingAlerts,iconType:"trash",color:"danger",isDisabled:isPerformingAction,"data-test-subj":"deleteAll",className:"actBulkActionPopover__deleteAll"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.bulkActionPopover.deleteAllTitle",defaultMessage:"Delete"}))))};const AlertQuickEditButtonsWithApi=Object(with_bulk_alert_api_operations["a"])(AlertQuickEditButtons);function isAlertDisabled(alert){return alert.enabled===false}function isAlertMuted(alert){return alert.muteAll===true}function noop(){}var collapsed_item_actions=__webpack_require__(233);const CollapsedItemActions=({item:item,onAlertChanged:onAlertChanged,disableAlert:disableAlert,enableAlert:enableAlert,unmuteAlert:unmuteAlert,muteAlert:muteAlert,setAlertsToDelete:setAlertsToDelete})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{disabled:!item.isEditable,iconType:"boxesVertical",onClick:()=>setIsPopoverOpen(!isPopoverOpen),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.collapsedItemActons.popoverButtonTitle",{defaultMessage:"Actions"})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:button,isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),ownFocus:true,panelPaddingSize:"none","data-test-subj":"collapsedItemActions"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{className:"actCollapsedItemActions",hasFocus:false},external_kbnSharedDeps_React_default.a.createElement("div",{className:"actCollapsedItemActions__item"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{name:"disable",disabled:!item.isEditable||!item.enabledInLicense,compressed:true,checked:!item.enabled,"data-test-subj":"disableSwitch",onChange:async()=>{if(item.enabled){await disableAlert(item)}else{await enableAlert(item)}onAlertChanged()},label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.collapsedItemActons.disableTitle",defaultMessage:"Disable"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.collapsedItemActons.disableHelpText",defaultMessage:"When disabled, the alert is not checked."}))),external_kbnSharedDeps_React_default.a.createElement("div",{className:"actCollapsedItemActions__item"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{name:"mute",checked:item.muteAll,disabled:!(item.isEditable&&item.enabled)||!item.enabledInLicense,compressed:true,"data-test-subj":"muteSwitch",onChange:async()=>{if(item.muteAll){await unmuteAlert(item)}else{await muteAlert(item)}onAlertChanged()},label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.collapsedItemActons.muteTitle",defaultMessage:"Mute"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.collapsedItemActons.muteHelpText",defaultMessage:"When muted, the alert is checked, but no action is performed."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"none"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{disabled:!item.isEditable,"data-test-subj":"deleteAlert",onClick:()=>setAlertsToDelete([item.id])},external_kbnSharedDeps_React_default.a.createElement("div",{className:"actCollapsedItemActions__delete"},external_kbnSharedDeps_React_default.a.createElement("div",{className:"actCollapsedItemActions__deleteIcon"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"danger",type:"trash"})),external_kbnSharedDeps_React_default.a.createElement("div",{className:"actCollapsedItemActions__deleteLabel"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"danger"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.collapsedItemActons.deleteTitle",defaultMessage:"Delete"}))))))))};const CollapsedItemActionsWithApi=Object(with_bulk_alert_api_operations["a"])(CollapsedItemActions);const TypeFilter=({options:options,onChange:onChange})=>{const[selectedValues,setSelectedValues]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(onChange){onChange(selectedValues)}},[selectedValues]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",hasActiveFilters:selectedValues.length>0,numActiveFilters:selectedValues.length,numFilters:selectedValues.length,onClick:()=>setIsPopoverOpen(!isPopoverOpen),"data-test-subj":"alertTypeFilterButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.typeFilterLabel",defaultMessage:"Type"}))},external_kbnSharedDeps_React_default.a.createElement("div",{className:"euiFilterSelect__items"},options.map((groupItem,groupIndex)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:`group${groupIndex}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{"data-test-subj":`alertType${groupIndex}Group`,size:"xxs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,groupItem.groupName)),groupItem.subOptions.map((item,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:index,onClick:()=>{const isPreviouslyChecked=selectedValues.includes(item.value);if(isPreviouslyChecked){setSelectedValues(selectedValues.filter(val=>val!==item.value))}else{setSelectedValues(selectedValues.concat(item.value))}},checked:selectedValues.includes(item.value)?"on":undefined,"data-test-subj":`alertType${item.value}FilterOption`},item.name)))))))};const ActionTypeFilter=({actionTypes:actionTypes,onChange:onChange})=>{const[selectedValues,setSelectedValues]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(onChange){onChange(selectedValues)}},[selectedValues]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",hasActiveFilters:selectedValues.length>0,numActiveFilters:selectedValues.length,numFilters:selectedValues.length,onClick:()=>setIsPopoverOpen(!isPopoverOpen),"data-test-subj":"actionTypeFilterButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.actionTypeFilterLabel",defaultMessage:"Action type"}))},external_kbnSharedDeps_React_default.a.createElement("div",{className:"euiFilterSelect__items"},actionTypes.map(item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:item.id,onClick:()=>{const isPreviouslyChecked=selectedValues.includes(item.id);if(isPreviouslyChecked){setSelectedValues(selectedValues.filter(val=>val!==item.id))}else{setSelectedValues(selectedValues.concat(item.id))}},checked:selectedValues.includes(item.id)?"on":undefined,"data-test-subj":`actionType${item.id}FilterOption`},item.name)))))};var common_=__webpack_require__(7);var translations=__webpack_require__(101);const AlertStatusFilter=({selectedStatuses:selectedStatuses,onChange:onChange})=>{const[selectedValues,setSelectedValues]=Object(external_kbnSharedDeps_React_["useState"])(selectedStatuses);const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(onChange){onChange(selectedValues)}},[selectedValues]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setSelectedValues(selectedStatuses)},[selectedStatuses]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",hasActiveFilters:selectedValues.length>0,numActiveFilters:selectedValues.length,numFilters:selectedValues.length,onClick:()=>setIsPopoverOpen(!isPopoverOpen),"data-test-subj":"alertStatusFilterButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.alertStatusFilterLabel",defaultMessage:"Status"}))},external_kbnSharedDeps_React_default.a.createElement("div",{className:"euiFilterSelect__items"},[...common_["AlertExecutionStatusValues"]].sort().map(item=>{const healthColor=getHealthColor(item);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:item,style:{textTransform:"capitalize"},onClick:()=>{const isPreviouslyChecked=selectedValues.includes(item);if(isPreviouslyChecked){setSelectedValues(selectedValues.filter(val=>val!==item))}else{setSelectedValues(selectedValues.concat(item))}},checked:selectedValues.includes(item)?"on":undefined,"data-test-subj":`alertStatus${item}FilerOption`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:healthColor},translations["c"][item]))}))))};function getHealthColor(status){switch(status){case"active":return"primary";case"error":return"danger";case"ok":return"subdued";case"pending":return"success";default:return"warning"}}var alert_api=__webpack_require__(92);const EmptyPrompt=({onCTAClicked:onCTAClicked})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"createFirstAlertEmptyPrompt",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.emptyPrompt.emptyTitle",defaultMessage:"Create your first alert"})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.emptyPrompt.emptyDesc",defaultMessage:"Receive an alert through email, Slack, or another connector when a condition is met."})),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"createFirstAlertButton",key:"create-action",fill:true,onClick:onCTAClicked},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.emptyPrompt.emptyButton",defaultMessage:"Create alert"}))});var common_constants=__webpack_require__(12);var alerts_list=__webpack_require__(242);const ManageLicenseModal=({licenseType:licenseType,alertTypeId:alertTypeId,onConfirm:onConfirm,onCancel:onCancel})=>{const licenseRequired=Object(external_kbnSharedDeps_Lodash_["capitalize"])(licenseType);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.manageLicense.manageLicenseTitle",{defaultMessage:"{licenseRequired} license required",values:{licenseRequired:licenseRequired}}),onCancel:onCancel,onConfirm:onConfirm,confirmButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.manageLicense.manageLicenseConfirmButtonText",{defaultMessage:"Manage license"}),cancelButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.manageLicense.manageLicenseCancelButtonText",{defaultMessage:"Cancel"}),defaultFocusedButton:"confirm","data-test-subj":"manageLicenseModal"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.manageLicense.manageLicenseMessage",defaultMessage:"Alert {alertTypeId} is disabled because it requires a {licenseRequired} license. Continue to License Management to view upgrade options.",values:{alertTypeId:alertTypeId,licenseRequired:licenseRequired}})))};const ENTER_KEY=13;const AlertsList=()=>{const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{http:http,notifications:{toasts:toasts},application:{capabilities:capabilities},alertTypeRegistry:alertTypeRegistry,actionTypeRegistry:actionTypeRegistry,kibanaFeatures:kibanaFeatures}=Object(kibana["b"])().services;const canExecuteActions=Object(lib_capabilities["c"])(capabilities);const[actionTypes,setActionTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const[selectedIds,setSelectedIds]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isPerformingAction,setIsPerformingAction]=Object(external_kbnSharedDeps_React_["useState"])(false);const[page,setPage]=Object(external_kbnSharedDeps_React_["useState"])({index:0,size:constants["c"]});const[searchText,setSearchText]=Object(external_kbnSharedDeps_React_["useState"])();const[inputText,setInputText]=Object(external_kbnSharedDeps_React_["useState"])();const[typesFilter,setTypesFilter]=Object(external_kbnSharedDeps_React_["useState"])([]);const[actionTypesFilter,setActionTypesFilter]=Object(external_kbnSharedDeps_React_["useState"])([]);const[alertStatusesFilter,setAlertStatusesFilter]=Object(external_kbnSharedDeps_React_["useState"])([]);const[alertFlyoutVisible,setAlertFlyoutVisibility]=Object(external_kbnSharedDeps_React_["useState"])(false);const[dismissAlertErrors,setDismissAlertErrors]=Object(external_kbnSharedDeps_React_["useState"])(false);const[manageLicenseModalOpts,setManageLicenseModalOpts]=Object(external_kbnSharedDeps_React_["useState"])(null);const[alertsStatusesTotal,setAlertsStatusesTotal]=Object(external_kbnSharedDeps_React_["useState"])(common_["AlertExecutionStatusValues"].reduce((prev,status)=>({...prev,[status]:0}),{}));const[alertTypesState,setAlertTypesState]=Object(external_kbnSharedDeps_React_["useState"])({isLoading:false,isInitialized:false,data:new Map});const[alertsState,setAlertsState]=Object(external_kbnSharedDeps_React_["useState"])({isLoading:false,data:[],totalItemCount:0});const[alertsToDelete,setAlertsToDelete]=Object(external_kbnSharedDeps_React_["useState"])([]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{loadAlertsData()},[alertTypesState,page,searchText,JSON.stringify(typesFilter),JSON.stringify(actionTypesFilter),JSON.stringify(alertStatusesFilter)]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{try{setAlertTypesState({...alertTypesState,isLoading:true});const alertTypes=await Object(alert_api["l"])({http:http});const index=new Map;for(const alertType of alertTypes){index.set(alertType.id,alertType)}setAlertTypesState({isLoading:false,data:index,isInitialized:true})}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.unableToLoadAlertTypesMessage",{defaultMessage:"Unable to load alert types"})});setAlertTypesState({...alertTypesState,isLoading:false})}})()},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{try{const result=await Object(action_connector_api["d"])({http:http});setActionTypes(result.filter(({id:id})=>actionTypeRegistry.has(id)&&!common_constants["DEFAULT_HIDDEN_ACTION_TYPES"].includes(id)).sort((a,b)=>a.name.localeCompare(b.name)))}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.unableToLoadActionTypesMessage",{defaultMessage:"Unable to load action types"})})}})()},[]);async function loadAlertsData(){const hasAnyAuthorizedAlertType=alertTypesState.data.size>0;if(hasAnyAuthorizedAlertType){setAlertsState({...alertsState,isLoading:true});try{var _alertsResponse$data;const alertsResponse=await Object(alert_api["m"])({http:http,page:page,searchText:searchText,typesFilter:typesFilter,actionTypesFilter:actionTypesFilter,alertStatusesFilter:alertStatusesFilter});await loadAlertAggs();setAlertsState({isLoading:false,data:alertsResponse.data,totalItemCount:alertsResponse.total});if(!((_alertsResponse$data=alertsResponse.data)!==null&&_alertsResponse$data!==void 0&&_alertsResponse$data.length)&&page.index>0){setPage({...page,index:0})}}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.unableToLoadAlertsMessage",{defaultMessage:"Unable to load alerts"})});setAlertsState({...alertsState,isLoading:false})}}}async function loadAlertAggs(){try{const alertsAggs=await Object(alert_api["i"])({http:http,searchText:searchText,typesFilter:typesFilter,actionTypesFilter:actionTypesFilter,alertStatusesFilter:alertStatusesFilter});if(alertsAggs!==null&&alertsAggs!==void 0&&alertsAggs.alertExecutionStatus){setAlertsStatusesTotal(alertsAggs.alertExecutionStatus)}}catch(e){toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.unableToLoadAlertsStatusesInfoMessage",{defaultMessage:"Unable to load alert statuses info"})})}}const renderAlertExecutionStatus=(executionStatus,item)=>{var _executionStatus$erro,_executionStatus$erro2;const healthColor=getHealthColor(executionStatus.status);const tooltipMessage=executionStatus.status==="error"?`Error: ${executionStatus===null||executionStatus===void 0?void 0:(_executionStatus$erro=executionStatus.error)===null||_executionStatus$erro===void 0?void 0:_executionStatus$erro.message}`:null;const isLicenseError=((_executionStatus$erro2=executionStatus.error)===null||_executionStatus$erro2===void 0?void 0:_executionStatus$erro2.reason)===common_["AlertExecutionStatusErrorReasons"].License;const statusMessage=isLicenseError?translations["a"]:translations["c"][executionStatus.status];const health=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{"data-test-subj":`alertStatus-${executionStatus.status}`,color:healthColor},statusMessage);const healthWithTooltip=tooltipMessage?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{"data-test-subj":"alertStatus-error-tooltip",position:"top",content:tooltipMessage},health):health;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,healthWithTooltip),isLicenseError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs","data-test-subj":"alertStatus-error-license-fix",onClick:()=>{var _alertTypesState$data;return setManageLicenseModalOpts({licenseType:(_alertTypesState$data=alertTypesState.data.get(item.alertTypeId))===null||_alertTypesState$data===void 0?void 0:_alertTypesState$data.minimumLicenseRequired,alertTypeId:item.alertTypeId})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.fixLicenseLink",defaultMessage:"Fix"}))))};const alertsTableColumns=[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.nameTitle",{defaultMessage:"Name"}),sortable:false,truncateText:true,width:"35%","data-test-subj":"alertsTableCell-name",render:(name,alert)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{title:name,onClick:()=>{history.push(constants["f"].replace(`:alertId`,alert.id))}},name)},{field:"executionStatus",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.statusTitle",{defaultMessage:"Status"}),sortable:false,truncateText:false,width:"150px","data-test-subj":"alertsTableCell-status",render:(executionStatus,item)=>renderAlertExecutionStatus(executionStatus,item)},{field:"tagsText",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.tagsText",{defaultMessage:"Tags"}),sortable:false,"data-test-subj":"alertsTableCell-tagsText"},{field:"actionsText",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.actionsText",{defaultMessage:"Actions"}),render:(count,item)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"hollow",key:item.id},count),sortable:false,"data-test-subj":"alertsTableCell-actionsText"},{field:"alertType",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.alertTypeTitle",{defaultMessage:"Type"}),sortable:false,truncateText:true,"data-test-subj":"alertsTableCell-alertType"},{field:"schedule.interval",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertsListTable.columns.intervalTitle",{defaultMessage:"Runs every"}),sortable:false,truncateText:false,"data-test-subj":"alertsTableCell-interval"},{name:"",width:"40px",render(item){return external_kbnSharedDeps_React_default.a.createElement(CollapsedItemActionsWithApi,{key:item.id,item:item,onAlertChanged:()=>loadAlertsData(),setAlertsToDelete:setAlertsToDelete})}}];const authorizedAlertTypes=[...alertTypesState.data.values()];const authorizedToCreateAnyAlerts=authorizedAlertTypes.some(alertType=>{var _alertType$authorized;return(_alertType$authorized=alertType.authorizedConsumers[common_["ALERTS_FEATURE_ID"]])===null||_alertType$authorized===void 0?void 0:_alertType$authorized.all});const getProducerFeatureName=producer=>{var _kibanaFeatures$find;return kibanaFeatures===null||kibanaFeatures===void 0?void 0:(_kibanaFeatures$find=kibanaFeatures.find(featureItem=>featureItem.id===producer))===null||_kibanaFeatures$find===void 0?void 0:_kibanaFeatures$find.name};const groupAlertTypesByProducer=()=>authorizedAlertTypes.reduce((result,alertType)=>{const producer=alertType.producer;(result[producer]=result[producer]||[]).push({value:alertType.id,name:alertType.name});return result},{});const toolsRight=[external_kbnSharedDeps_React_default.a.createElement(TypeFilter,{key:"type-filter",onChange:types=>setTypesFilter(types),options:Object(external_kbnSharedDeps_Lodash_["sortBy"])(Object.entries(groupAlertTypesByProducer())).map(([groupName,alertTypesOptions])=>{var _getProducerFeatureNa;return{groupName:(_getProducerFeatureNa=getProducerFeatureName(groupName))!==null&&_getProducerFeatureNa!==void 0?_getProducerFeatureNa:Object(external_kbnSharedDeps_Lodash_["capitalize"])(groupName),subOptions:alertTypesOptions.sort((a,b)=>a.name.localeCompare(b.name))}})}),external_kbnSharedDeps_React_default.a.createElement(ActionTypeFilter,{key:"action-type-filter",actionTypes:actionTypes,onChange:ids=>setActionTypesFilter(ids)}),external_kbnSharedDeps_React_default.a.createElement(AlertStatusFilter,{key:"alert-status-filter",selectedStatuses:alertStatusesFilter,onChange:ids=>setAlertStatusesFilter(ids)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"refreshAlertsButton",iconType:"refresh",onClick:loadAlertsData,name:"refresh",color:"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.refreshAlertsButtonLabel",defaultMessage:"Refresh"}))];const authorizedToModifySelectedAlerts=selectedIds.length?filterAlertsById(alertsState.data,selectedIds).every(selectedAlert=>Object(lib_capabilities["a"])(selectedAlert,alertTypesState.data.get(selectedAlert.alertTypeId))):false;const table=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},selectedIds.length>0&&authorizedToModifySelectedAlerts&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(BulkOperationPopover,null,external_kbnSharedDeps_React_default.a.createElement(AlertQuickEditButtonsWithApi,{selectedItems:convertAlertsToTableItems(filterAlertsById(alertsState.data,selectedIds),alertTypesState.data,canExecuteActions),onPerformingAction:()=>setIsPerformingAction(true),onActionPerformed:()=>{loadAlertsData();setIsPerformingAction(false)},setAlertsToDelete:setAlertsToDelete}))),authorizedToCreateAnyAlerts?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"create-alert","data-test-subj":"createAlertButton",fill:true,onClick:()=>setAlertFlyoutVisibility(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.addActionButtonLabel",defaultMessage:"Create alert"}))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{fullWidth:true,isClearable:true,"data-test-subj":"alertSearchField",onChange:e=>setInputText(e.target.value),onKeyUp:e=>{if(e.keyCode===ENTER_KEY){setSearchText(inputText)}},placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.searchPlaceholderTitle",{defaultMessage:"Search"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},toolsRight.map((tool,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index,grow:false},tool))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),!dismissAlertErrors&&alertsStatusesTotal.error>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.attentionBannerTitle",defaultMessage:"Error found in {totalStausesError, plural, one {# alert} other {# alerts}}.",values:{totalStausesError:alertsStatusesTotal.error}}),iconType:"alert","data-test-subj":"alertsErrorBanner"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"primary",size:"s",color:"danger",onClick:()=>setAlertStatusesFilter(["error"])},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.viewBunnerButtonLabel",defaultMessage:"View"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"danger",onClick:()=>setDismissAlertErrors(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.dismissBunnerButtonLabel",defaultMessage:"Dismiss"}))))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued","data-test-subj":"totalAlertsCount"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.totalItemsCountDescription",defaultMessage:"Showing: {pageSize} of {totalItemCount} alerts.",values:{totalItemCount:alertsState.totalItemCount,pageSize:alertsState.data.length}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"primary","data-test-subj":"totalActiveAlertsCount"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.totalStausesActiveDescription",defaultMessage:"Active: {totalStausesActive}",values:{totalStausesActive:alertsStatusesTotal.active}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"danger","data-test-subj":"totalErrorAlertsCount"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.totalStausesErrorDescription",defaultMessage:"Error: {totalStausesError}",values:{totalStausesError:alertsStatusesTotal.error}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"subdued","data-test-subj":"totalOkAlertsCount"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.totalStausesOkDescription",defaultMessage:"Ok: {totalStausesOk}",values:{totalStausesOk:alertsStatusesTotal.ok}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"success","data-test-subj":"totalPendingAlertsCount"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.totalStausesPendingDescription",defaultMessage:"Pending: {totalStausesPending}",values:{totalStausesPending:alertsStatusesTotal.pending}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"warning","data-test-subj":"totalUnknownAlertsCount"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.totalStausesUnknownDescription",defaultMessage:"Unknown: {totalStausesUnknown}",values:{totalStausesUnknown:alertsStatusesTotal.unknown}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{loading:alertsState.isLoading||alertTypesState.isLoading||isPerformingAction,items:alertTypesState.isInitialized===false?[]:convertAlertsToTableItems(alertsState.data,alertTypesState.data,canExecuteActions),itemId:"id",columns:alertsTableColumns,rowProps:item=>{var _alertTypesState$data2;return{"data-test-subj":"alert-row",className:!((_alertTypesState$data2=alertTypesState.data.get(item.alertTypeId))!==null&&_alertTypesState$data2!==void 0&&_alertTypesState$data2.enabledInLicense)?"actAlertsList__tableRowDisabled":""}},cellProps:item=>{var _alertTypesState$data3;return{"data-test-subj":"cell",className:!((_alertTypesState$data3=alertTypesState.data.get(item.alertTypeId))!==null&&_alertTypesState$data3!==void 0&&_alertTypesState$data3.enabledInLicense)?"actAlertsList__tableCellDisabled":""}},"data-test-subj":"alertsList",pagination:{pageIndex:page.index,pageSize:page.size,totalItemCount:alertTypesState.isInitialized===false?0:alertsState.totalItemCount},selection:{selectable:alert=>alert.isEditable,onSelectionChange(updatedSelectedItemsList){setSelectedIds(updatedSelectedItemsList.map(item=>item.id))}},onChange:({page:changedPage})=>{setPage(changedPage)}}),manageLicenseModalOpts&&external_kbnSharedDeps_React_default.a.createElement(ManageLicenseModal,{licenseType:manageLicenseModalOpts.licenseType,alertTypeId:manageLicenseModalOpts.alertTypeId,onConfirm:()=>{window.open(`${http.basePath.get()}/app/management/stack/license_management`,"_blank");setManageLicenseModalOpts(null)},onCancel:()=>setManageLicenseModalOpts(null)}));const loadedItems=convertAlertsToTableItems(alertsState.data,alertTypesState.data,canExecuteActions);const isFilterApplied=!(Object(external_kbnSharedDeps_Lodash_["isEmpty"])(searchText)&&Object(external_kbnSharedDeps_Lodash_["isEmpty"])(typesFilter)&&Object(external_kbnSharedDeps_Lodash_["isEmpty"])(actionTypesFilter)&&Object(external_kbnSharedDeps_Lodash_["isEmpty"])(alertStatusesFilter));return external_kbnSharedDeps_React_default.a.createElement("section",{"data-test-subj":"alertsList"},external_kbnSharedDeps_React_default.a.createElement(DeleteModalConfirmation,{onDeleted:async()=>{setAlertsToDelete([]);setSelectedIds([]);await loadAlertsData()},onErrors:async()=>{await loadAlertsData();setAlertsToDelete([])},onCancel:()=>{setAlertsToDelete([])},apiDeleteCall:alert_api["c"],idsToDelete:alertsToDelete,singleTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.singleTitle",{defaultMessage:"alert"}),multipleTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.multipleTitle",{defaultMessage:"alerts"}),setIsLoadingState:isLoading=>{setAlertsState({...alertsState,isLoading:isLoading})}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),loadedItems.length||isFilterApplied?table:alertTypesState.isLoading||alertsState.isLoading?external_kbnSharedDeps_React_default.a.createElement(center_justified_spinner["a"],null):authorizedToCreateAnyAlerts?external_kbnSharedDeps_React_default.a.createElement(EmptyPrompt,{onCTAClicked:()=>setAlertFlyoutVisibility(true)}):noPermissionPrompt,alertFlyoutVisible&&external_kbnSharedDeps_React_default.a.createElement(alert_form["b"],{consumer:common_["ALERTS_FEATURE_ID"],onClose:()=>{setAlertFlyoutVisibility(false)},actionTypeRegistry:actionTypeRegistry,alertTypeRegistry:alertTypeRegistry,reloadAlerts:loadAlertsData}))};const noPermissionPrompt=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.noPermissionToCreateTitle",defaultMessage:"No permissions to create alerts"})),body:external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"permissionDeniedMessage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.sections.alertsList.noPermissionToCreateDescription",defaultMessage:"Contact your system administrator."}))});function filterAlertsById(alerts,ids){return alerts.filter(alert=>ids.includes(alert.id))}function convertAlertsToTableItems(alerts,alertTypesIndex,canExecuteActions){return alerts.map(alert=>{var _alertTypesIndex$get$,_alertTypesIndex$get,_alertTypesIndex$get2;return{...alert,actionsText:alert.actions.length,tagsText:alert.tags.join(", "),alertType:(_alertTypesIndex$get$=(_alertTypesIndex$get=alertTypesIndex.get(alert.alertTypeId))===null||_alertTypesIndex$get===void 0?void 0:_alertTypesIndex$get.name)!==null&&_alertTypesIndex$get$!==void 0?_alertTypesIndex$get$:alert.alertTypeId,isEditable:Object(lib_capabilities["a"])(alert,alertTypesIndex.get(alert.alertTypeId))&&(canExecuteActions||!canExecuteActions&&!alert.actions.length),enabledInLicense:!!((_alertTypesIndex$get2=alertTypesIndex.get(alert.alertTypeId))!==null&&_alertTypesIndex$get2!==void 0&&_alertTypesIndex$get2.enabledInLicense)}})}var health_check=__webpack_require__(102);var health_context=__webpack_require__(94);const TriggersActionsUIHome=({match:{params:{section:section}},history:history})=>{const{chrome:chrome,application:{capabilities:capabilities},setBreadcrumbs:setBreadcrumbs,docLinks:docLinks}=Object(kibana["b"])().services;const canShowActions=Object(lib_capabilities["e"])(capabilities);const tabs=[];tabs.push({id:"alerts",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.home.alertsTabTitle",defaultMessage:"Alerts"})});if(canShowActions){tabs.push({id:"connectors",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.home.connectorsTabTitle",defaultMessage:"Connectors"})})}const onSectionChange=newSection=>{history.push(`/${newSection}`)};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setBreadcrumbs([Object(breadcrumb["b"])(section||"home")]);chrome.docTitle.change(Object(doc_title["a"])(section||"home"))},[section,chrome,setBreadcrumbs]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"appTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.home.appTitle",defaultMessage:"Alerts and Actions"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:docLinks.links.alerting.guide,target:"_blank",iconType:"help","data-test-subj":"documentationLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.home.alertsAndActionsDocsLinkText",defaultMessage:"Documentation"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.home.sectionDescription",defaultMessage:"Detect conditions using alerts, and take actions using connectors."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],null,tabs.map(tab=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:()=>onSectionChange(tab.id),isSelected:tab.id===section,key:tab.id,"data-test-subj":`${tab.id}Tab`},tab.name))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,canShowActions&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:constants["h"],component:()=>external_kbnSharedDeps_React_default.a.createElement(health_context["a"],null,external_kbnSharedDeps_React_default.a.createElement(health_check["a"],{waitForCheck:true},external_kbnSharedDeps_React_default.a.createElement(ActionsConnectorsList,null)))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:constants["g"],component:()=>external_kbnSharedDeps_React_default.a.createElement(health_context["a"],null,external_kbnSharedDeps_React_default.a.createElement(health_check["a"],{inFlyout:true,waitForCheck:true},external_kbnSharedDeps_React_default.a.createElement(AlertsList,null)))}))))}},,,,,,,,,,,,,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HealthContextProvider}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useHealthContext}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);const defaultHealthContext={loadingHealthCheck:false,setLoadingHealthCheck:loading=>{throw new Error("setLoadingHealthCheck was not initialized, set it when you invoke the context")}};const HealthContext=Object(react__WEBPACK_IMPORTED_MODULE_0__["createContext"])(defaultHealthContext);const HealthContextProvider=({children:children})=>{const[loading,setLoading]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const setLoadingHealthCheck=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(isLoading=>{setLoading(isLoading)},[]);const value=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({loadingHealthCheck:loading,setLoadingHealthCheck:setLoadingHealthCheck}),[loading,setLoadingHealthCheck]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(HealthContext.Provider,{value:value},children)};const useHealthContext=()=>{const ctx=Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(HealthContext);if(!ctx){throw new Error("HealthContext has not been set.")}return ctx}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return withBulkAlertOperations}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _lib_alert_api__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(92);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(34);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function withBulkAlertOperations(WrappedComponent){return props=>{const{http:http}=Object(_common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__["b"])().services;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(WrappedComponent,_extends({},props,{muteAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["p"])({http:http,ids:items.filter(item=>!isAlertMuted(item)).map(item=>item.id)}),unmuteAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["s"])({http:http,ids:items.filter(isAlertMuted).map(item=>item.id)}),enableAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["g"])({http:http,ids:items.filter(isAlertDisabled).map(item=>item.id)}),disableAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["e"])({http:http,ids:items.filter(item=>!isAlertDisabled(item)).map(item=>item.id)}),deleteAlerts:async items=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["c"])({http:http,ids:items.map(item=>item.id)}),muteAlert:async alert=>{if(!isAlertMuted(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["n"])({http:http,id:alert.id})}},unmuteAlert:async alert=>{if(isAlertMuted(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["q"])({http:http,id:alert.id})}},muteAlertInstance:async(alert,instanceId)=>{if(!isAlertInstanceMuted(alert,instanceId)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["o"])({http:http,id:alert.id,instanceId:instanceId})}},unmuteAlertInstance:async(alert,instanceId)=>{if(isAlertInstanceMuted(alert,instanceId)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["r"])({http:http,id:alert.id,instanceId:instanceId})}},enableAlert:async alert=>{if(isAlertDisabled(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["f"])({http:http,id:alert.id})}},disableAlert:async alert=>{if(!isAlertDisabled(alert)){return Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["d"])({http:http,id:alert.id})}},deleteAlert:async alert=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["c"])({http:http,ids:[alert.id]}),loadAlert:async alertId=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["h"])({http:http,alertId:alertId}),loadAlertState:async alertId=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["k"])({http:http,alertId:alertId}),loadAlertInstanceSummary:async alertId=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["j"])({http:http,alertId:alertId}),loadAlertTypes:async()=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["l"])({http:http}),getHealth:async()=>Object(_lib_alert_api__WEBPACK_IMPORTED_MODULE_1__["a"])({http:http})}))}}function isAlertDisabled(alert){return alert.enabled===false}function isAlertMuted(alert){return alert.muteAll===true}function isAlertInstanceMuted(alert,instanceId){return alert.mutedInstanceIds.findIndex(muted=>muted===instanceId)>=0}},,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ALERT_STATUS_LICENSE_ERROR}));__webpack_require__.d(__webpack_exports__,"c",(function(){return alertsStatusesTranslationsMapping}));__webpack_require__.d(__webpack_exports__,"b",(function(){return alertsErrorReasonTranslationsMapping}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const ALERT_STATUS_OK=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusOk",{defaultMessage:"Ok"});const ALERT_STATUS_ACTIVE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusActive",{defaultMessage:"Active"});const ALERT_STATUS_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusError",{defaultMessage:"Error"});const ALERT_STATUS_LICENSE_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusLicenseError",{defaultMessage:"License Error"});const ALERT_STATUS_PENDING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusPending",{defaultMessage:"Pending"});const ALERT_STATUS_UNKNOWN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertStatusUnknown",{defaultMessage:"Unknown"});const alertsStatusesTranslationsMapping={ok:ALERT_STATUS_OK,active:ALERT_STATUS_ACTIVE,error:ALERT_STATUS_ERROR,pending:ALERT_STATUS_PENDING,unknown:ALERT_STATUS_UNKNOWN};const ALERT_ERROR_UNKNOWN_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonUnknown",{defaultMessage:"An error occurred for unknown reasons."});const ALERT_ERROR_READING_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonReading",{defaultMessage:"An error occurred when reading the alert."});const ALERT_ERROR_DECRYPTING_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonDecrypting",{defaultMessage:"An error occurred when decrypting the alert."});const ALERT_ERROR_EXECUTION_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonRunning",{defaultMessage:"An error occurred when running the alert."});const ALERT_ERROR_LICENSE_REASON=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.sections.alertsList.alertErrorReasonLicense",{defaultMessage:"Cannot run alert"});const alertsErrorReasonTranslationsMapping={read:ALERT_ERROR_READING_REASON,decrypt:ALERT_ERROR_DECRYPTING_REASON,execute:ALERT_ERROR_EXECUTION_REASON,unknown:ALERT_ERROR_UNKNOWN_REASON,license:ALERT_ERROR_LICENSE_REASON}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HealthCheck}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var Option=__webpack_require__(91);var pipeable=__webpack_require__(93);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var alert_api=__webpack_require__(92);var health_check=__webpack_require__(125);var health_context=__webpack_require__(94);var kibana=__webpack_require__(34);var center_justified_spinner=__webpack_require__(36);const TRIGGERS_ACTIONS_UI_API_ROOT="/api/triggers_actions_ui";async function triggersActionsUiHealth({http:http}){return await http.get(`${TRIGGERS_ACTIONS_UI_API_ROOT}/_health`)}const HealthCheck=({children:children,waitForCheck:waitForCheck,inFlyout:inFlyout=false})=>{const{http:http,docLinks:docLinks}=Object(kibana["b"])().services;const{setLoadingHealthCheck:setLoadingHealthCheck}=Object(health_context["b"])();const[alertingHealth,setAlertingHealth]=external_kbnSharedDeps_React_default.a.useState(Option["none"]);external_kbnSharedDeps_React_default.a.useEffect(()=>{(async function(){setLoadingHealthCheck(true);const triggersActionsUiHealthStatus=await triggersActionsUiHealth({http:http});const healthStatus={...triggersActionsUiHealthStatus,isSufficientlySecure:false,hasPermanentEncryptionKey:false};if(healthStatus.isAlertsAvailable){const alertingHealthResult=await Object(alert_api["a"])({http:http});healthStatus.isSufficientlySecure=alertingHealthResult.isSufficientlySecure;healthStatus.hasPermanentEncryptionKey=alertingHealthResult.hasPermanentEncryptionKey}setAlertingHealth(Object(Option["some"])(healthStatus));setLoadingHealthCheck(false)})()},[http,setLoadingHealthCheck]);const className=inFlyout?"alertingFlyoutHealthCheck":"alertingHealthCheck";return Object(pipeable["pipe"])(alertingHealth,Object(Option["fold"])(()=>waitForCheck?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(center_justified_spinner["a"],null)):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children),healthCheck=>healthCheck!==null&&healthCheck!==void 0&&healthCheck.isSufficientlySecure&&healthCheck!==null&&healthCheck!==void 0&&healthCheck.hasPermanentEncryptionKey?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children):!healthCheck.isAlertsAvailable?external_kbnSharedDeps_React_default.a.createElement(AlertsError,{docLinks:docLinks,className:className}):!healthCheck.isSufficientlySecure&&!healthCheck.hasPermanentEncryptionKey?external_kbnSharedDeps_React_default.a.createElement(TlsAndEncryptionError,{docLinks:docLinks,className:className}):!healthCheck.hasPermanentEncryptionKey?external_kbnSharedDeps_React_default.a.createElement(EncryptionError,{docLinks:docLinks,className:className}):external_kbnSharedDeps_React_default.a.createElement(TlsError,{docLinks:docLinks,className:className})))};const EncryptionError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"actionNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.encryptionErrorTitle",defaultMessage:"Encrypted saved objects are not available"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.encryptionErrorBeforeKey",{defaultMessage:"To create an alert, set a value for "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.encryptedSavedObjects.encryptionKey"),external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.encryptionErrorAfterKey",{defaultMessage:" in your kibana.yml file and ensure the Encrypted Saved Objects plugin is enabled. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.generalSettings,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.encryptionErrorAction",{defaultMessage:"Learn how."}))))});const TlsError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"actionNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.tlsErrorTitle",defaultMessage:"You must enable Transport Layer Security"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsError",{defaultMessage:"Alerting relies on API keys, which require TLS between Elasticsearch and Kibana. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.security.kibanaTLS,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsErrorAction",{defaultMessage:"Learn how to enable TLS."}))))});const AlertsError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"alertsNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.alertsErrorTitle",defaultMessage:"You must enable Alerts and Actions"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.alertsError",{defaultMessage:"To create an alert, set alerts and actions plugins enabled. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.generalSettings,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.alertsErrorAction",{defaultMessage:"Learn how to enable Alerts and Actions."}))))});const TlsAndEncryptionError=({docLinks:docLinks,className:className})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"watchesApp","data-test-subj":"actionNeededEmptyPrompt",className:className,titleSize:"xs",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.triggersActionsUI.components.healthCheck.tlsAndEncryptionErrorTitle",defaultMessage:"Additional setup required"})),body:external_kbnSharedDeps_React_default.a.createElement("div",{className:`${className}__body`},external_kbnSharedDeps_React_default.a.createElement("p",{role:"banner"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsAndEncryptionError",{defaultMessage:"You must enable Transport Layer Security between Kibana and Elasticsearch and configure an encryption key in your kibana.yml file. "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.alerting.setupPrerequisites,external:true,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.triggersActionsUI.components.healthCheck.tlsAndEncryptionErrorAction",{defaultMessage:"Learn how"}))))})},,,,,,,,,,,,,function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(116);case"v7light":return __webpack_require__(118);case"v8dark":return __webpack_require__(120);case"v8light":return __webpack_require__(122)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(117);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".connectorEditFlyoutTabs {\n  margin-bottom: -24px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(119);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".connectorEditFlyoutTabs {\n  margin-bottom: -24px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(121);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".connectorEditFlyoutTabs {\n  margin-bottom: -24px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(123);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".connectorEditFlyoutTabs {\n  margin-bottom: -24px; }\n",""]);module.exports=exports},,function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(126);case"v7light":return __webpack_require__(128);case"v8dark":return __webpack_require__(130);case"v8light":return __webpack_require__(132)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(127);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(129);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(131);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(133);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".alertingHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px; }\n\n.alertingFlyoutHealthCheck__body {\n  padding-left: 32px;\n  padding-right: 32px;\n  margin-top: 16px; }\n",""]);module.exports=exports},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getAlertingSectionBreadcrumb}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getAlertDetailsBreadcrumb}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);var _constants__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(3);const getAlertingSectionBreadcrumb=type=>{switch(type){case"connectors":return{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.connectors.breadcrumbTitle",{defaultMessage:"Connectors"}),href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["h"]}`};case"alerts":return{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.alerts.breadcrumbTitle",{defaultMessage:"Alerts"}),href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["g"]}`};default:return{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.home.breadcrumbTitle",{defaultMessage:"Alerts and Actions"}),href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["i"]}`}}};const getAlertDetailsBreadcrumb=(id,name)=>({text:name,href:`${_constants__WEBPACK_IMPORTED_MODULE_1__["f"].replace(":alertId",id)}`})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getCurrentDocTitle}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const getCurrentDocTitle=page=>{let updatedTitle;switch(page){case"connectors":updatedTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.connectors.breadcrumbTitle",{defaultMessage:"Connectors"});break;case"alerts":updatedTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.alerts.breadcrumbTitle",{defaultMessage:"Alerts"});break;default:updatedTitle=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.triggersActionsUI.home.breadcrumbTitle",{defaultMessage:"Alerts and Actions"})}return updatedTitle}},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(207);case"v7light":return __webpack_require__(209);case"v8dark":return __webpack_require__(211);case"v8light":return __webpack_require__(213)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(208);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actConnectorsList__tableRowDisabled {\n  background-color: #25262E; }\n  .actConnectorsList__tableRowDisabled .actConnectorsList__tableCellDisabled {\n    color: #98A2B3; }\n  .actConnectorsList__tableRowDisabled .euiLink + .euiToolTipAnchor {\n    margin-left: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(210);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actConnectorsList__tableRowDisabled {\n  background-color: #F5F7FA; }\n  .actConnectorsList__tableRowDisabled .actConnectorsList__tableCellDisabled {\n    color: #69707D; }\n  .actConnectorsList__tableRowDisabled .euiLink + .euiToolTipAnchor {\n    margin-left: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(212);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actConnectorsList__tableRowDisabled {\n  background-color: #25262E; }\n  .actConnectorsList__tableRowDisabled .actConnectorsList__tableCellDisabled {\n    color: #98A2B3; }\n  .actConnectorsList__tableRowDisabled .euiLink + .euiToolTipAnchor {\n    margin-left: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(214);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actConnectorsList__tableRowDisabled {\n  background-color: #F5F7FA; }\n  .actConnectorsList__tableRowDisabled .actConnectorsList__tableCellDisabled {\n    color: #69707D; }\n  .actConnectorsList__tableRowDisabled .euiLink + .euiToolTipAnchor {\n    margin-left: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(216);case"v7light":return __webpack_require__(218);case"v8dark":return __webpack_require__(220);case"v8light":return __webpack_require__(222)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(217);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actEmptyConnectorsPrompt__logo + .actEmptyConnectorsPrompt__logo {\n  margin-left: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(219);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actEmptyConnectorsPrompt__logo + .actEmptyConnectorsPrompt__logo {\n  margin-left: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(221);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actEmptyConnectorsPrompt__logo + .actEmptyConnectorsPrompt__logo {\n  margin-left: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(223);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actEmptyConnectorsPrompt__logo + .actEmptyConnectorsPrompt__logo {\n  margin-left: 16px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(225);case"v7light":return __webpack_require__(227);case"v8dark":return __webpack_require__(229);case"v8light":return __webpack_require__(231)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(226);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actBulkActionPopover__deleteAll .euiButtonEmpty__text {\n  padding-top: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(228);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actBulkActionPopover__deleteAll .euiButtonEmpty__text {\n  padding-top: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(230);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actBulkActionPopover__deleteAll .euiButtonEmpty__text {\n  padding-top: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(232);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actBulkActionPopover__deleteAll .euiButtonEmpty__text {\n  padding-top: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(234);case"v7light":return __webpack_require__(236);case"v8dark":return __webpack_require__(238);case"v8light":return __webpack_require__(240)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(235);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actCollapsedItemActions .euiContextMenuItem:hover {\n  text-decoration: none; }\n\n.actCollapsedItemActions__item {\n  padding: 12px; }\n\n.actCollapsedItemActions__delete {\n  display: flex; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteIcon {\n    width: 28px;\n    text-align: center; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteLabel {\n    padding-left: 8px;\n    padding-top: 2px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(237);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actCollapsedItemActions .euiContextMenuItem:hover {\n  text-decoration: none; }\n\n.actCollapsedItemActions__item {\n  padding: 12px; }\n\n.actCollapsedItemActions__delete {\n  display: flex; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteIcon {\n    width: 28px;\n    text-align: center; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteLabel {\n    padding-left: 8px;\n    padding-top: 2px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(239);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actCollapsedItemActions .euiContextMenuItem:hover {\n  text-decoration: none; }\n\n.actCollapsedItemActions__item {\n  padding: 12px; }\n\n.actCollapsedItemActions__delete {\n  display: flex; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteIcon {\n    width: 28px;\n    text-align: center; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteLabel {\n    padding-left: 8px;\n    padding-top: 2px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(241);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actCollapsedItemActions .euiContextMenuItem:hover {\n  text-decoration: none; }\n\n.actCollapsedItemActions__item {\n  padding: 12px; }\n\n.actCollapsedItemActions__delete {\n  display: flex; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteIcon {\n    width: 28px;\n    text-align: center; }\n  .actCollapsedItemActions__delete .actCollapsedItemActions__deleteLabel {\n    padding-left: 8px;\n    padding-top: 2px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(243);case"v7light":return __webpack_require__(245);case"v8dark":return __webpack_require__(247);case"v8light":return __webpack_require__(249)}},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(244);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actAlertsList__tableRowDisabled {\n  background-color: #25262E; }\n  .actAlertsList__tableRowDisabled .actAlertsList__tableCellDisabled {\n    color: #98A2B3; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(246);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actAlertsList__tableRowDisabled {\n  background-color: #F5F7FA; }\n  .actAlertsList__tableRowDisabled .actAlertsList__tableCellDisabled {\n    color: #69707D; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(248);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actAlertsList__tableRowDisabled {\n  background-color: #25262E; }\n  .actAlertsList__tableRowDisabled .actAlertsList__tableCellDisabled {\n    color: #98A2B3; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(25);var content=__webpack_require__(250);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(26);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".actAlertsList__tableRowDisabled {\n  background-color: #F5F7FA; }\n  .actAlertsList__tableRowDisabled .actAlertsList__tableCellDisabled {\n    color: #69707D; }\n",""]);module.exports=exports}])]);