/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["stackAlerts_bundle_jsonpfunction"]=window["stackAlerts_bundle_jsonpfunction"]||[]).push([[3],{46:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"GeoContainmentAlertTypeExpression",(function(){return GeoContainmentAlertTypeExpression}));__webpack_require__.d(__webpack_exports__,"default",(function(){return GeoContainmentAlertTypeExpression}));var external_kbnSharedDeps_React_=__webpack_require__(2);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(7);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var public_=__webpack_require__(9);const ES_GEO_FIELD_TYPES=["geo_point"];const ES_GEO_SHAPE_TYPES=["geo_shape"];function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class geo_index_pattern_select_GeoIndexPatternSelect extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);_defineProperty(this,"_isMounted",false);_defineProperty(this,"state",{noGeoIndexPatternsExist:false});_defineProperty(this,"_onIndexPatternSelect",async indexPatternId=>{if(!indexPatternId||indexPatternId.length===0||!this.props.indexPatternService){return}let indexPattern;try{indexPattern=await this.props.indexPatternService.get(indexPatternId)}catch(err){return}if(this._isMounted&&indexPattern.id===indexPatternId){this.props.onChange(indexPattern)}});_defineProperty(this,"_onNoIndexPatterns",()=>{this.setState({noGeoIndexPatternsExist:true})})}componentWillUnmount(){this._isMounted=false}componentDidMount(){this._isMounted=true}_renderNoIndexPatternWarning(){if(!this.state.noGeoIndexPatternsExist){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.noIndexPattern.messageTitle",{defaultMessage:`Couldn't find any index patterns with geospatial fields`}),color:"warning"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.noIndexPattern.doThisPrefixDescription",defaultMessage:"You'll need to "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:this.props.http.basePath.prepend(`/app/management/kibana/indexPatterns`)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.noIndexPattern.doThisLinkTextDescription",defaultMessage:"create an index pattern"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.noIndexPattern.doThisSuffixDescription",defaultMessage:" with geospatial fields."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.noIndexPattern.hintDescription",defaultMessage:"Don't have any geospatial data sets? "}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:this.props.http.basePath.prepend("/app/home#/tutorial_directory/sampleData")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.noIndexPattern.getStartedLinkText",defaultMessage:"Get started with some sample data sets."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}))}render(){const IndexPatternSelectComponent=this.props.IndexPatternSelectComponent;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,this._renderNoIndexPatternWarning(),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.indexPatternSelectLabel",{defaultMessage:"Index pattern"})},IndexPatternSelectComponent?external_kbnSharedDeps_React_default.a.createElement(IndexPatternSelectComponent,{isDisabled:this.state.noGeoIndexPatternsExist,indexPatternId:this.props.value,onChange:this._onIndexPatternSelect,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.indexPatternSelectPlaceholder",{defaultMessage:"Select index pattern"}),fieldTypes:this.props.includedGeoTypes,onNoIndexPatterns:this._onNoIndexPatterns,isClearable:false}):external_kbnSharedDeps_React_default.a.createElement("div",null)))}}var external_kbnSharedDeps_Lodash_=__webpack_require__(10);var external_kbnSharedDeps_Lodash_default=__webpack_require__.n(external_kbnSharedDeps_Lodash_);function fieldsToOptions(fields){if(!fields){return[]}return fields.map(field=>({value:field,label:field.name})).sort((a,b)=>a.label.toLowerCase().localeCompare(b.label.toLowerCase()))}function SingleFieldSelect({placeholder:placeholder,value:value,onChange:onChange,fields:fields}){function renderOption(option,searchValue,contentClassName){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{className:contentClassName,gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:null},external_kbnSharedDeps_React_default.a.createElement(public_["FieldIcon"],{type:option.value.type,fill:"none"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHighlight"],{search:searchValue},option.label)))}const onSelection=selectedOptions=>{onChange(external_kbnSharedDeps_Lodash_default.a.get(selectedOptions,"0.value.name"))};const selectedOptions=[];if(value&&fields){const selectedField=fields.find(field=>field.name===value);if(selectedField){selectedOptions.push({value:selectedField,label:value})}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{singleSelection:true,options:fieldsToOptions(fields),selectedOptions:selectedOptions,onChange:onSelection,isDisabled:!fields,renderOption:renderOption,isClearable:false,placeholder:placeholder,compressed:true})}const ExpressionWithPopover=({popoverContent:popoverContent,expressionDescription:expressionDescription,defaultValue:defaultValue,value:value,isInvalid:isInvalid})=>{const[popoverOpen,setPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"popoverForExpression",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiExpression"],{display:"columns","data-test-subj":"selectIndexExpression",description:expressionDescription,value:value||defaultValue,isActive:popoverOpen,onClick:()=>setPopoverOpen(true),isInvalid:isInvalid}),isOpen:popoverOpen,closePopover:()=>setPopoverOpen(false),ownFocus:true,anchorPosition:"downLeft",zIndex:8e3,display:"block"},external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"450px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,expressionDescription),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"data-test-subj":"closePopover",iconType:"cross",color:"danger","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.ui.expressionPopover.closePopoverLabel",{defaultMessage:"Close"}),onClick:()=>setPopoverOpen(false)})))),popoverContent))};const EntityIndexExpression=({setAlertParamsDate:setAlertParamsDate,setAlertParamsGeoField:setAlertParamsGeoField,errors:errors,setIndexPattern:setIndexPattern,indexPattern:indexPattern,isInvalid:isInvalid,dateField:timeField,geoField:geoField,data:data})=>{const{http:http}=Object(public_["useKibana"])().services;const IndexPatternSelect=data.ui&&data.ui.IndexPatternSelect||null;const usePrevious=value=>{const ref=Object(external_kbnSharedDeps_React_["useRef"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{ref.current=value});return ref.current};const oldIndexPattern=usePrevious(indexPattern);const fields=Object(external_kbnSharedDeps_React_["useRef"])({dateFields:[],geoFields:[]});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(oldIndexPattern!==indexPattern){fields.current.geoFields=indexPattern.fields.length&&indexPattern.fields.filter(field=>ES_GEO_FIELD_TYPES.includes(field.type))||[];if(fields.current.geoFields.length){setAlertParamsGeoField(fields.current.geoFields[0].name)}fields.current.dateFields=indexPattern.fields.length&&indexPattern.fields.filter(field=>field.type==="date")||[];if(fields.current.dateFields.length){setAlertParamsDate(fields.current.dateFields[0].name)}}},[indexPattern,oldIndexPattern,setAlertParamsDate,setAlertParamsGeoField]);const indexPopover=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"geoIndexPatternSelect",fullWidth:true,error:errors.index},external_kbnSharedDeps_React_default.a.createElement(geo_index_pattern_select_GeoIndexPatternSelect,{onChange:_indexPattern=>{if(!_indexPattern){return}setIndexPattern(_indexPattern)},value:indexPattern.id,IndexPatternSelectComponent:IndexPatternSelect,indexPatternService:data.indexPatterns,http:http,includedGeoTypes:ES_GEO_FIELD_TYPES})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"containmentTimeField",fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.timeFieldLabel",defaultMessage:"Time field"})},external_kbnSharedDeps_React_default.a.createElement(SingleFieldSelect,{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.selectTimeLabel",{defaultMessage:"Select time field"}),value:timeField,onChange:_timeField=>_timeField&&setAlertParamsDate(_timeField),fields:fields.current.dateFields})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"geoField",fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.geofieldLabel",{defaultMessage:"Geospatial field"})},external_kbnSharedDeps_React_default.a.createElement(SingleFieldSelect,{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.selectGeoLabel",{defaultMessage:"Select geo field"}),value:geoField,onChange:_geoField=>_geoField&&setAlertParamsGeoField(_geoField),fields:fields.current.geoFields})));return external_kbnSharedDeps_React_default.a.createElement(ExpressionWithPopover,{isInvalid:isInvalid,value:indexPattern.title,defaultValue:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.entityIndexSelect",{defaultMessage:"Select an index pattern and geo point field"}),popoverContent:indexPopover,expressionDescription:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.entityIndexLabel",{defaultMessage:"index"})})};const EntityByExpression=({errors:errors,entity:entity,setAlertParamsEntity:setAlertParamsEntity,indexFields:indexFields,isInvalid:isInvalid})=>{const ENTITY_TYPES=["string","number","ip"];const usePrevious=value=>{const ref=Object(external_kbnSharedDeps_React_["useRef"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{ref.current=value});return ref.current};const oldIndexFields=usePrevious(indexFields);const fields=Object(external_kbnSharedDeps_React_["useRef"])({indexFields:[]});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!external_kbnSharedDeps_Lodash_default.a.isEqual(oldIndexFields,indexFields)){fields.current.indexFields=indexFields.filter(field=>ENTITY_TYPES.includes(field.type)&&!field.name.startsWith("_"));if(!entity&&fields.current.indexFields.length){setAlertParamsEntity(fields.current.indexFields[0].name)}}},[ENTITY_TYPES,indexFields,oldIndexFields,setAlertParamsEntity,entity]);const indexPopover=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"entitySelect",fullWidth:true,error:errors.index},external_kbnSharedDeps_React_default.a.createElement(SingleFieldSelect,{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.topHitsSplitFieldSelectPlaceholder",{defaultMessage:"Select entity field"}),value:entity,onChange:_entity=>_entity&&setAlertParamsEntity(_entity),fields:fields.current.indexFields}));return external_kbnSharedDeps_React_default.a.createElement(ExpressionWithPopover,{isInvalid:isInvalid,value:entity,defaultValue:"Select entity field",popoverContent:indexPopover,expressionDescription:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.entityByLabel",{defaultMessage:"by"})})};const BoundaryIndexExpression=({alertParams:alertParams,errors:errors,boundaryIndexPattern:boundaryIndexPattern,boundaryNameField:boundaryNameField,setBoundaryIndexPattern:setBoundaryIndexPattern,setBoundaryGeoField:setBoundaryGeoField,setBoundaryNameField:setBoundaryNameField,data:data})=>{const BOUNDARY_NAME_ENTITY_TYPES=["string","number","ip"];const{http:http}=Object(public_["useKibana"])().services;const IndexPatternSelect=data.ui&&data.ui.IndexPatternSelect||null;const{boundaryGeoField:boundaryGeoField}=alertParams;const nothingSelected={name:"<nothing selected>",type:"string"};const usePrevious=value=>{const ref=Object(external_kbnSharedDeps_React_["useRef"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{ref.current=value});return ref.current};const oldIndexPattern=usePrevious(boundaryIndexPattern);const fields=Object(external_kbnSharedDeps_React_["useRef"])({geoFields:[],boundaryNameFields:[]});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(oldIndexPattern!==boundaryIndexPattern){fields.current.geoFields=boundaryIndexPattern.fields.length&&boundaryIndexPattern.fields.filter(field=>ES_GEO_SHAPE_TYPES.includes(field.type))||[];if(fields.current.geoFields.length){setBoundaryGeoField(fields.current.geoFields[0].name)}fields.current.boundaryNameFields=[...boundaryIndexPattern.fields.filter(field=>BOUNDARY_NAME_ENTITY_TYPES.includes(field.type)&&!field.name.startsWith("_")&&!field.name.endsWith("keyword")),nothingSelected];if(fields.current.boundaryNameFields.length){setBoundaryNameField(fields.current.boundaryNameFields[0].name)}}},[BOUNDARY_NAME_ENTITY_TYPES,boundaryIndexPattern,nothingSelected,oldIndexPattern,setBoundaryGeoField,setBoundaryNameField]);const indexPopover=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"geoIndexPatternSelect",fullWidth:true,error:errors.index},external_kbnSharedDeps_React_default.a.createElement(geo_index_pattern_select_GeoIndexPatternSelect,{onChange:_indexPattern=>{if(!_indexPattern){return}setBoundaryIndexPattern(_indexPattern)},value:boundaryIndexPattern.id,IndexPatternSelectComponent:IndexPatternSelect,indexPatternService:data.indexPatterns,http:http,includedGeoTypes:ES_GEO_SHAPE_TYPES})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"geoField",fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.geofieldLabel",{defaultMessage:"Geospatial field"})},external_kbnSharedDeps_React_default.a.createElement(SingleFieldSelect,{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.selectLabel",{defaultMessage:"Select geo field"}),value:boundaryGeoField,onChange:setBoundaryGeoField,fields:fields.current.geoFields})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:"boundaryNameFieldSelect",fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.boundaryNameSelectLabel",{defaultMessage:"Human-readable boundary name (optional)"})},external_kbnSharedDeps_React_default.a.createElement(SingleFieldSelect,{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.boundaryNameSelect",{defaultMessage:"Select boundary name"}),value:boundaryNameField||null,onChange:name=>{setBoundaryNameField(name===nothingSelected.name?undefined:name)},fields:fields.current.boundaryNameFields})));return external_kbnSharedDeps_React_default.a.createElement(ExpressionWithPopover,{defaultValue:"Select an index pattern and geo shape field",value:boundaryIndexPattern.title,popoverContent:indexPopover,expressionDescription:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.indexLabel",{defaultMessage:"index"})})};var data_public_=__webpack_require__(12);const DEFAULT_VALUES={TRACKING_EVENT:"",ENTITY:"",INDEX:"",INDEX_ID:"",DATE_FIELD:"",BOUNDARY_TYPE:"entireIndex",GEO_FIELD:"",BOUNDARY_INDEX:"",BOUNDARY_INDEX_ID:"",BOUNDARY_GEO_FIELD:"",BOUNDARY_NAME_FIELD:"",DELAY_OFFSET_WITH_UNITS:"0m"};function validateQuery(query){try{query.language==="kuery"?data_public_["esKuery"].fromKueryExpression(query.query):data_public_["esQuery"].luceneStringToDsl(query.query)}catch(err){return false}return true}const GeoContainmentAlertTypeExpression=({alertParams:alertParams,alertInterval:alertInterval,setAlertParams:setAlertParams,setAlertProperty:setAlertProperty,errors:errors,data:data})=>{const{index:index,indexId:indexId,indexQuery:indexQuery,geoField:geoField,entity:entity,dateField:dateField,boundaryType:boundaryType,boundaryIndexTitle:boundaryIndexTitle,boundaryIndexId:boundaryIndexId,boundaryIndexQuery:boundaryIndexQuery,boundaryGeoField:boundaryGeoField,boundaryNameField:boundaryNameField}=alertParams;const[indexPattern,_setIndexPattern]=Object(external_kbnSharedDeps_React_["useState"])({id:"",fields:[],title:""});const setIndexPattern=_indexPattern=>{if(_indexPattern){_setIndexPattern(_indexPattern);if(_indexPattern.title){setAlertParams("index",_indexPattern.title)}if(_indexPattern.id){setAlertParams("indexId",_indexPattern.id)}}};const[indexQueryInput,setIndexQueryInput]=Object(external_kbnSharedDeps_React_["useState"])(indexQuery||{query:"",language:"kuery"});const[boundaryIndexPattern,_setBoundaryIndexPattern]=Object(external_kbnSharedDeps_React_["useState"])({id:"",fields:[],title:""});const setBoundaryIndexPattern=_indexPattern=>{if(_indexPattern){_setBoundaryIndexPattern(_indexPattern);if(_indexPattern.title){setAlertParams("boundaryIndexTitle",_indexPattern.title)}if(_indexPattern.id){setAlertParams("boundaryIndexId",_indexPattern.id)}}};const[boundaryIndexQueryInput,setBoundaryIndexQueryInput]=Object(external_kbnSharedDeps_React_["useState"])(boundaryIndexQuery||{query:"",language:"kuery"});const hasExpressionErrors=false;const expressionErrorMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.stackAlerts.geoContainment.fixErrorInExpressionBelowValidationMessage",{defaultMessage:"Expression contains errors."});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const initToDefaultParams=async()=>{setAlertProperty("params",{...alertParams,index:index!==null&&index!==void 0?index:DEFAULT_VALUES.INDEX,indexId:indexId!==null&&indexId!==void 0?indexId:DEFAULT_VALUES.INDEX_ID,entity:entity!==null&&entity!==void 0?entity:DEFAULT_VALUES.ENTITY,dateField:dateField!==null&&dateField!==void 0?dateField:DEFAULT_VALUES.DATE_FIELD,boundaryType:boundaryType!==null&&boundaryType!==void 0?boundaryType:DEFAULT_VALUES.BOUNDARY_TYPE,geoField:geoField!==null&&geoField!==void 0?geoField:DEFAULT_VALUES.GEO_FIELD,boundaryIndexTitle:boundaryIndexTitle!==null&&boundaryIndexTitle!==void 0?boundaryIndexTitle:DEFAULT_VALUES.BOUNDARY_INDEX,boundaryIndexId:boundaryIndexId!==null&&boundaryIndexId!==void 0?boundaryIndexId:DEFAULT_VALUES.BOUNDARY_INDEX_ID,boundaryGeoField:boundaryGeoField!==null&&boundaryGeoField!==void 0?boundaryGeoField:DEFAULT_VALUES.BOUNDARY_GEO_FIELD,boundaryNameField:boundaryNameField!==null&&boundaryNameField!==void 0?boundaryNameField:DEFAULT_VALUES.BOUNDARY_NAME_FIELD});if(!data.indexPatterns){return}if(indexId){const _indexPattern=await data.indexPatterns.get(indexId);setIndexPattern(_indexPattern)}if(boundaryIndexId){const _boundaryIndexPattern=await data.indexPatterns.get(boundaryIndexId);setBoundaryIndexPattern(_boundaryIndexPattern)}};initToDefaultParams()},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,hasExpressionErrors?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",size:"s",title:expressionErrorMessage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.selectEntity",defaultMessage:"Select entity"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(EntityIndexExpression,{dateField:dateField,geoField:geoField,errors:errors,setAlertParamsDate:_date=>setAlertParams("dateField",_date),setAlertParamsGeoField:_geoField=>setAlertParams("geoField",_geoField),setAlertProperty:setAlertProperty,setIndexPattern:setIndexPattern,indexPattern:indexPattern,isInvalid:!indexId||!dateField||!geoField,data:data}),external_kbnSharedDeps_React_default.a.createElement(EntityByExpression,{errors:errors,entity:entity,setAlertParamsEntity:entityName=>setAlertParams("entity",entityName),indexFields:indexPattern.fields,isInvalid:indexId&&dateField&&geoField?!entity:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(data_public_["QueryStringInput"],{disableAutoFocus:true,bubbleSubmitEvent:true,indexPatterns:indexPattern?[indexPattern]:[],query:indexQueryInput,onChange:query=>{if(query.language){if(validateQuery(query)){setAlertParams("indexQuery",query)}setIndexQueryInput(query)}}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.stackAlerts.geoContainment.selectBoundaryIndex",defaultMessage:"Select boundary"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(BoundaryIndexExpression,{alertParams:alertParams,errors:errors,boundaryIndexPattern:boundaryIndexPattern,setBoundaryIndexPattern:setBoundaryIndexPattern,setBoundaryGeoField:_geoField=>_geoField&&setAlertParams("boundaryGeoField",_geoField),setBoundaryNameField:_boundaryNameField=>_boundaryNameField?setAlertParams("boundaryNameField",_boundaryNameField):setAlertParams("boundaryNameField",""),boundaryNameField:boundaryNameField,data:data}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(data_public_["QueryStringInput"],{disableAutoFocus:true,bubbleSubmitEvent:true,indexPatterns:boundaryIndexPattern?[boundaryIndexPattern]:[],query:boundaryIndexQueryInput,onChange:query=>{if(query.language){if(validateQuery(query)){setAlertParams("boundaryIndexQuery",query)}setBoundaryIndexQueryInput(query)}}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}))}}}]);