/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["snapshotRestore_bundle_jsonpfunction"]=window["snapshotRestore_bundle_jsonpfunction"]||[]).push([[1],{31:function(module,exports){ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],(function(acequire,exports,module){"use strict";exports.isDark=false;exports.cssClass="ace-tm";exports.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}';var dom=acequire("../lib/dom");dom.importCssString(exports.cssText,exports.cssClass)}))},32:function(module,exports,__webpack_require__){"use strict";const strictUriEncode=__webpack_require__(33);const decodeComponent=__webpack_require__(34);const splitOnFirst=__webpack_require__(35);const isNullOrUndefined=value=>value===null||value===undefined;function encoderForArrayFormat(options){switch(options.arrayFormat){case"index":return key=>(result,value)=>{const index=result.length;if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[",index,"]"].join("")]}return[...result,[encode(key,options),"[",encode(index,options),"]=",encode(value,options)].join("")]};case"bracket":return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[]"].join("")]}return[...result,[encode(key,options),"[]=",encode(value,options)].join("")]};case"comma":case"separator":return key=>(result,value)=>{if(value===null||value===undefined||value.length===0){return result}if(result.length===0){return[[encode(key,options),"=",encode(value,options)].join("")]}return[[result,encode(value,options)].join(options.arrayFormatSeparator)]};default:return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,encode(key,options)]}return[...result,[encode(key,options),"=",encode(value,options)].join("")]}}}function parserForArrayFormat(options){let result;switch(options.arrayFormat){case"index":return(key,value,accumulator)=>{result=/\[(\d*)\]$/.exec(key);key=key.replace(/\[\d*\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]={}}accumulator[key][result[1]]=value};case"bracket":return(key,value,accumulator)=>{result=/(\[\])$/.exec(key);key=key.replace(/\[\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]=[value];return}accumulator[key]=[].concat(accumulator[key],value)};case"comma":case"separator":return(key,value,accumulator)=>{const isArray=typeof value==="string"&&value.split("").indexOf(options.arrayFormatSeparator)>-1;const newValue=isArray?value.split(options.arrayFormatSeparator).map(item=>decode(item,options)):value===null?value:decode(value,options);accumulator[key]=newValue};default:return(key,value,accumulator)=>{if(accumulator[key]===undefined){accumulator[key]=value;return}accumulator[key]=[].concat(accumulator[key],value)}}}function validateArrayFormatSeparator(value){if(typeof value!=="string"||value.length!==1){throw new TypeError("arrayFormatSeparator must be single character string")}}function encode(value,options){if(options.encode){return options.strict?strictUriEncode(value):encodeURIComponent(value)}return value}function decode(value,options){if(options.decode){return decodeComponent(value)}return value}function keysSorter(input){if(Array.isArray(input)){return input.sort()}if(typeof input==="object"){return keysSorter(Object.keys(input)).sort((a,b)=>Number(a)-Number(b)).map(key=>input[key])}return input}function removeHash(input){const hashStart=input.indexOf("#");if(hashStart!==-1){input=input.slice(0,hashStart)}return input}function getHash(url){let hash="";const hashStart=url.indexOf("#");if(hashStart!==-1){hash=url.slice(hashStart)}return hash}function extract(input){input=removeHash(input);const queryStart=input.indexOf("?");if(queryStart===-1){return""}return input.slice(queryStart+1)}function parseValue(value,options){if(options.parseNumbers&&!Number.isNaN(Number(value))&&(typeof value==="string"&&value.trim()!=="")){value=Number(value)}else if(options.parseBooleans&&value!==null&&(value.toLowerCase()==="true"||value.toLowerCase()==="false")){value=value.toLowerCase()==="true"}return value}function parse(input,options){options=Object.assign({decode:true,sort:true,arrayFormat:"none",arrayFormatSeparator:",",parseNumbers:false,parseBooleans:false},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const formatter=parserForArrayFormat(options);const ret=Object.create(null);if(typeof input!=="string"){return ret}input=input.trim().replace(/^[?#&]/,"");if(!input){return ret}for(const param of input.split("&")){let[key,value]=splitOnFirst(options.decode?param.replace(/\+/g," "):param,"=");value=value===undefined?null:["comma","separator"].includes(options.arrayFormat)?value:decode(value,options);formatter(decode(key,options),value,ret)}for(const key of Object.keys(ret)){const value=ret[key];if(typeof value==="object"&&value!==null){for(const k of Object.keys(value)){value[k]=parseValue(value[k],options)}}else{ret[key]=parseValue(value,options)}}if(options.sort===false){return ret}return(options.sort===true?Object.keys(ret).sort():Object.keys(ret).sort(options.sort)).reduce((result,key)=>{const value=ret[key];if(Boolean(value)&&typeof value==="object"&&!Array.isArray(value)){result[key]=keysSorter(value)}else{result[key]=value}return result},Object.create(null))}exports.extract=extract;exports.parse=parse;exports.stringify=(object,options)=>{if(!object){return""}options=Object.assign({encode:true,strict:true,arrayFormat:"none",arrayFormatSeparator:","},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const shouldFilter=key=>options.skipNull&&isNullOrUndefined(object[key])||options.skipEmptyString&&object[key]==="";const formatter=encoderForArrayFormat(options);const objectCopy={};for(const key of Object.keys(object)){if(!shouldFilter(key)){objectCopy[key]=object[key]}}const keys=Object.keys(objectCopy);if(options.sort!==false){keys.sort(options.sort)}return keys.map(key=>{const value=object[key];if(value===undefined){return""}if(value===null){return encode(key,options)}if(Array.isArray(value)){return value.reduce(formatter(key),[]).join("&")}return encode(key,options)+"="+encode(value,options)}).filter(x=>x.length>0).join("&")};exports.parseUrl=(input,options)=>{options=Object.assign({decode:true},options);const[url,hash]=splitOnFirst(input,"#");return Object.assign({url:url.split("?")[0]||"",query:parse(extract(input),options)},options&&options.parseFragmentIdentifier&&hash?{fragmentIdentifier:decode(hash,options)}:{})};exports.stringifyUrl=(input,options)=>{options=Object.assign({encode:true,strict:true},options);const url=removeHash(input.url).split("?")[0]||"";const queryFromUrl=exports.extract(input.url);const parsedQueryFromUrl=exports.parse(queryFromUrl,{sort:false});const query=Object.assign(parsedQueryFromUrl,input.query);let queryString=exports.stringify(query,options);if(queryString){queryString=`?${queryString}`}let hash=getHash(input.url);if(input.fragmentIdentifier){hash=`#${encode(input.fragmentIdentifier,options)}`}return`${url}${queryString}${hash}`}},33:function(module,exports,__webpack_require__){"use strict";module.exports=str=>encodeURIComponent(str).replace(/[!'()*]/g,x=>`%${x.charCodeAt(0).toString(16).toUpperCase()}`)},34:function(module,exports,__webpack_require__){"use strict";var token="%[a-f0-9]{2}";var singleMatcher=new RegExp(token,"gi");var multiMatcher=new RegExp("("+token+")+","gi");function decodeComponents(components,split){try{return decodeURIComponent(components.join(""))}catch(err){}if(components.length===1){return components}split=split||1;var left=components.slice(0,split);var right=components.slice(split);return Array.prototype.concat.call([],decodeComponents(left),decodeComponents(right))}function decode(input){try{return decodeURIComponent(input)}catch(err){var tokens=input.match(singleMatcher);for(var i=1;i<tokens.length;i++){input=decodeComponents(tokens,i).join("");tokens=input.match(singleMatcher)}return input}}function customDecodeURIComponent(input){var replaceMap={"%FE%FF":"��","%FF%FE":"��"};var match=multiMatcher.exec(input);while(match){try{replaceMap[match[0]]=decodeURIComponent(match[0])}catch(err){var result=decode(match[0]);if(result!==match[0]){replaceMap[match[0]]=result}}match=multiMatcher.exec(input)}replaceMap["%C2"]="�";var entries=Object.keys(replaceMap);for(var i=0;i<entries.length;i++){var key=entries[i];input=input.replace(new RegExp(key,"g"),replaceMap[key])}return input}module.exports=function(encodedURI){if(typeof encodedURI!=="string"){throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof encodedURI+"`")}try{encodedURI=encodedURI.replace(/\+/g," ");return decodeURIComponent(encodedURI)}catch(err){return customDecodeURIComponent(encodedURI)}}},35:function(module,exports,__webpack_require__){"use strict";module.exports=(string,separator)=>{if(!(typeof string==="string"&&typeof separator==="string")){throw new TypeError("Expected the arguments to be of type `string`")}if(separator===""){return[string]}const separatorIndex=string.indexOf(separator);if(separatorIndex===-1){return[string]}return[string.slice(0,separatorIndex),string.slice(separatorIndex+separator.length)]}},36:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"mountManagementSection",(function(){return mountManagementSection}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(4);var services_http=__webpack_require__(3);var services_text=__webpack_require__(9);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class breadcrumb_BreadcrumbService{constructor(){_defineProperty(this,"breadcrumbs",{management:[],home:[],snapshots:[],repositories:[],policies:[],restore_status:[],repositoryAdd:[],repositoryEdit:[],restoreSnapshot:[],policyAdd:[],policyEdit:[]});_defineProperty(this,"setBreadcrumbsHandler",void 0)}setup(setBreadcrumbsHandler){this.setBreadcrumbsHandler=setBreadcrumbsHandler;this.breadcrumbs.home=[{text:services_text["a"].breadcrumbs.home,href:linkToHome()}];this.breadcrumbs.snapshots=[...this.breadcrumbs.home,{text:services_text["a"].breadcrumbs.snapshots,href:linkToSnapshots()}];this.breadcrumbs.repositories=[...this.breadcrumbs.home,{text:services_text["a"].breadcrumbs.repositories,href:linkToRepositories()}];this.breadcrumbs.policies=[...this.breadcrumbs.home,{text:services_text["a"].breadcrumbs.policies,href:linkToPolicies()}];this.breadcrumbs.restore_status=[...this.breadcrumbs.home,{text:services_text["a"].breadcrumbs.restore_status,href:linkToRestoreStatus()}];this.breadcrumbs.repositoryAdd=[...this.breadcrumbs.repositories,{text:services_text["a"].breadcrumbs.repositoryAdd}];this.breadcrumbs.repositoryEdit=[...this.breadcrumbs.repositories,{text:services_text["a"].breadcrumbs.repositoryEdit}];this.breadcrumbs.restoreSnapshot=[...this.breadcrumbs.snapshots,{text:services_text["a"].breadcrumbs.restoreSnapshot}];this.breadcrumbs.policyAdd=[...this.breadcrumbs.policies,{text:services_text["a"].breadcrumbs.policyAdd}];this.breadcrumbs.policyEdit=[...this.breadcrumbs.policies,{text:services_text["a"].breadcrumbs.policyEdit}]}setBreadcrumbs(type){if(!this.setBreadcrumbsHandler){throw new Error(`BreadcrumbService#setup() must be called first!`)}const newBreadcrumbs=this.breadcrumbs[type]?[...this.breadcrumbs[type]]:[...this.breadcrumbs.home];const lastBreadcrumb=newBreadcrumbs.pop();newBreadcrumbs.push({...lastBreadcrumb,href:undefined});this.setBreadcrumbsHandler(newBreadcrumbs)}}const breadcrumbService=new breadcrumb_BreadcrumbService;function doc_title_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class doc_title_DocTitleService{constructor(){doc_title_defineProperty(this,"changeDocTitleHandler",()=>{})}setup(_changeDocTitleHandler){this.changeDocTitleHandler=_changeDocTitleHandler}setTitle(page){if(!page||page==="home"){this.changeDocTitleHandler(`${services_text["a"].breadcrumbs.home}`)}else if(services_text["a"].breadcrumbs[page]){this.changeDocTitleHandler(`${services_text["a"].breadcrumbs[page]} - ${services_text["a"].breadcrumbs.home}`)}}}const docTitleService=new doc_title_DocTitleService;function linkToHome(){return`/`}function linkToRepositories(){return`/repositories`}function linkToRepository(repositoryName){return encodeURI(`/repositories/${encodeURIComponent(repositoryName)}`)}function linkToEditRepository(repositoryName){return encodeURI(`/edit_repository/${encodeURIComponent(repositoryName)}`)}function linkToAddRepository(redirect){return encodeURI(`/add_repository${redirect?`?redirect=${encodeURIComponent(redirect)}`:""}`)}function linkToSnapshots(repositoryName,policyName){if(repositoryName){return encodeURI(`/snapshots?repository=${encodeURIComponent(repositoryName)}`)}if(policyName){return encodeURI(`/snapshots?policy=${encodeURIComponent(policyName)}`)}return`/snapshots`}function linkToSnapshot(repositoryName,snapshotName){return encodeURI(`/snapshots/${encodeURIComponent(repositoryName)}/${encodeURIComponent(snapshotName)}`)}function linkToRestoreSnapshot(repositoryName,snapshotName){return encodeURI(`/restore/${encodeURIComponent(repositoryName)}/${encodeURIComponent(snapshotName)}`)}function linkToPolicies(){return`/policies`}function linkToPolicy(policyName){return encodeURI(`/policies/${encodeURIComponent(policyName)}`)}function linkToEditPolicy(policyName){return encodeURI(`/edit_policy/${encodeURIComponent(policyName)}`)}function linkToAddPolicy(){return`/add_policy`}function linkToRestoreStatus(){return`/restore_status`}var constants=__webpack_require__(0);var application_constants=__webpack_require__(1);function documentation_links_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class documentation_links_DocumentationLinksService{constructor(){documentation_links_defineProperty(this,"esDocBasePath","");documentation_links_defineProperty(this,"esPluginDocBasePath","")}setup(docLinks){const{DOC_LINK_VERSION:DOC_LINK_VERSION,ELASTIC_WEBSITE_URL:ELASTIC_WEBSITE_URL}=docLinks;const docsBase=`${ELASTIC_WEBSITE_URL}guide/en`;this.esDocBasePath=`${docsBase}/elasticsearch/reference/${DOC_LINK_VERSION}/`;this.esPluginDocBasePath=`${docsBase}/elasticsearch/plugins/${DOC_LINK_VERSION}/`}getRepositoryPluginDocUrl(){return`${this.esPluginDocBasePath}${application_constants["h"].plugins}`}getRepositoryTypeDocUrl(type){switch(type){case constants["f"].fs:return`${this.esDocBasePath}${application_constants["h"].fs}`;case constants["f"].url:return`${this.esDocBasePath}${application_constants["h"].url}`;case constants["f"].source:return`${this.esDocBasePath}${application_constants["h"].source}`;case constants["f"].s3:return`${this.esPluginDocBasePath}${application_constants["h"].s3}`;case constants["f"].hdfs:return`${this.esPluginDocBasePath}${application_constants["h"].hdfs}`;case constants["f"].azure:return`${this.esPluginDocBasePath}${application_constants["h"].azure}`;case constants["f"].gcs:return`${this.esPluginDocBasePath}${application_constants["h"].gcs}`;default:return`${this.esDocBasePath}${application_constants["h"].default}`}}getSnapshotDocUrl(){return`${this.esDocBasePath}snapshots-take-snapshot.html`}getRestoreDocUrl(){return`${this.esDocBasePath}snapshots-restore-snapshot.html`}getRestoreIndexSettingsUrl(){return`${this.esDocBasePath}snapshots-restore-snapshot.html#_changing_index_settings_during_restore`}getIndexSettingsUrl(){return`${this.esDocBasePath}index-modules.html`}getDateMathIndexNamesUrl(){return`${this.esDocBasePath}date-math-index-names.html`}getSlmUrl(){return`${this.esDocBasePath}slm-api-put.html`}getCronUrl(){return`${this.esDocBasePath}trigger-schedule.html#schedule-cron`}}const documentationLinksService=new documentation_links_DocumentationLinksService;var external_kbnSharedDeps_React_=__webpack_require__(23);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(29);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(27);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(24);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(25);var shared_imports=__webpack_require__(8);const AppContext=Object(external_kbnSharedDeps_React_["createContext"])(undefined);const AppContextProvider=({children:children,value:value})=>external_kbnSharedDeps_React_default.a.createElement(AppContext.Provider,{value:value},children);const AppContextConsumer=AppContext.Consumer;const useAppContext=()=>{const ctx=Object(external_kbnSharedDeps_React_["useContext"])(AppContext);if(!ctx){throw new Error('"useAppContext" can only be called inside of AppContext.Provider!')}return ctx};const useServices=()=>useAppContext().services;const useCore=()=>useAppContext().core;const useConfig=()=>useAppContext().config;const useToastNotifications=()=>{const{notifications:{toasts:toastNotifications}}=useCore();return toastNotifications};const DataPlaceholder=({data:data,children:children})=>{const{i18n:i18n}=useServices();if(data!=null){return children}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,i18n.translate("xpack.snapshotRestore.dataPlaceholderLabel",{defaultMessage:"-"}))};const FormattedDateTime=({epochMs:epochMs,type:type})=>{const date=new Date(epochMs);const formattedDate=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedDate"],{value:date,year:"numeric",month:"short",day:"2-digit"});const formattedTime=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedTime"],{value:date,timeZoneName:"short"});if(type){return type==="date"?formattedDate:formattedTime}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,formattedDate," ",formattedTime)};const RepositoryDeleteProvider=({children:children})=>{const{i18n:i18n}=useServices();const toastNotifications=useToastNotifications();const[repositoryNames,setRepositoryNames]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const deleteRepositoryPrompt=(names,onSuccess=(()=>undefined))=>{if(!names||!names.length){throw new Error("No repository names specified for deletion")}setIsModalOpen(true);setRepositoryNames(names);onSuccessCallback.current=onSuccess};const closeModal=()=>{setIsModalOpen(false);setRepositoryNames([])};const deleteRepository=()=>{const repositoriesToDelete=[...repositoryNames];Object(services_http["e"])(repositoriesToDelete).then(({data:data,error:error})=>{const{itemsDeleted:itemsDeleted,errors:errors}=data||{itemsDeleted:undefined,errors:undefined};if(itemsDeleted&&itemsDeleted.length){const hasMultipleSuccesses=itemsDeleted.length>1;const successMessage=hasMultipleSuccesses?i18n.translate("xpack.snapshotRestore.deleteRepository.successMultipleNotificationTitle",{defaultMessage:"Removed {count} repositories",values:{count:itemsDeleted.length}}):i18n.translate("xpack.snapshotRestore.deleteRepository.successSingleNotificationTitle",{defaultMessage:"Removed repository '{name}'",values:{name:itemsDeleted[0]}});toastNotifications.addSuccess(successMessage);if(onSuccessCallback.current){onSuccessCallback.current([...itemsDeleted])}}if(error||errors&&errors.length){const hasMultipleErrors=errors&&errors.length>1||error&&repositoriesToDelete.length>1;const errorMessage=hasMultipleErrors?i18n.translate("xpack.snapshotRestore.deleteRepository.errorMultipleNotificationTitle",{defaultMessage:"Error removing {count} repositories",values:{count:errors&&errors.length||repositoriesToDelete.length}}):i18n.translate("xpack.snapshotRestore.deleteRepository.errorSingleNotificationTitle",{defaultMessage:"Error removing repository '{name}'",values:{name:errors&&errors[0].name||repositoriesToDelete[0]}});toastNotifications.addDanger(errorMessage)}});closeModal()};const renderModal=()=>{if(!isModalOpen){return null}const isSingle=repositoryNames.length===1;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.deleteSingleTitle",defaultMessage:"Remove repository '{name}'?",values:{name:repositoryNames[0]}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.deleteMultipleTitle",defaultMessage:"Remove {count} repositories?",values:{count:repositoryNames.length}}),onCancel:closeModal,onConfirm:deleteRepository,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.confirmSingleButtonLabel",defaultMessage:"Remove repository"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.confirmMultipleButtonLabel",defaultMessage:"Remove repositories"}),buttonColor:"danger","data-test-subj":"deleteRepositoryConfirmation"},isSingle?external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.deleteSingleDescription",defaultMessage:"The snapshots in this repository will still exist, but Elasticsearch won’t have access to them. Adjust policies that use this repository to prevent scheduled snapshots from failing."})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.deleteMultipleListDescription",defaultMessage:"You are about to remove these repositories:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,repositoryNames.map(name=>external_kbnSharedDeps_React_default.a.createElement("li",{key:name},name))),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteRepository.confirmModal.deleteMultipleDescription",defaultMessage:"The snapshots in these repositories will still exist, but Elasticsearch won't have access to them. Adjust policies that use these repositories to prevent scheduled snapshots from failing."}))))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(deleteRepositoryPrompt),renderModal())};const flatten=(source,path=[])=>{if(!(source instanceof Object)){return{[path.join(".")]:source}}return Object.keys(source).reduce((result,key)=>{const flattened=flatten(source[key],[...path,key]);return{...result,...flattened}},{})};const removeUndefinedSettings=settings=>Object.entries(settings).reduce((sts,[key,value])=>{if(value!==undefined){sts[key]=value}return sts},{});function serializeRestoreSettings(restoreSettings){const{indices:indices,renamePattern:renamePattern,renameReplacement:renameReplacement,includeGlobalState:includeGlobalState,partial:partial,indexSettings:indexSettings,ignoreIndexSettings:ignoreIndexSettings,ignoreUnavailable:ignoreUnavailable}=restoreSettings;let parsedIndexSettings;if(indexSettings){try{parsedIndexSettings=JSON.parse(indexSettings)}catch(e){}}const settings={indices:indices,rename_pattern:renamePattern,rename_replacement:renameReplacement,include_global_state:includeGlobalState,partial:partial,index_settings:parsedIndexSettings,ignore_index_settings:ignoreIndexSettings,ignore_unavailable:ignoreUnavailable};return removeUndefinedSettings(settings)}function deserializeRestoreSettings(restoreSettingsEs){const{indices:indices,rename_pattern:renamePattern,rename_replacement:renameReplacement,include_global_state:includeGlobalState,partial:partial,index_settings:indexSettings,ignore_index_settings:ignoreIndexSettings,ignore_unavailable:ignoreUnavailable}=restoreSettingsEs;const settings={indices:indices,renamePattern:renamePattern,renameReplacement:renameReplacement,includeGlobalState:includeGlobalState,partial:partial,indexSettings:indexSettings?JSON.stringify(indexSettings):undefined,ignoreIndexSettings:ignoreIndexSettings,ignoreUnavailable:ignoreUnavailable};return removeUndefinedSettings(settings)}var external_kbnSharedDeps_Lodash_=__webpack_require__(28);const deserializeTime=time=>{const timeUnits=Object.values(constants["g"]);const timeUnit=timeUnits.find(unit=>{const unitIndex=time.indexOf(unit);return unitIndex!==-1&&unitIndex===time.length-1});if(timeUnit){const timeValue=Number(time.replace(timeUnit,""));if(!isNaN(timeValue)){return{timeValue:timeValue,timeUnit:timeUnit}}}return{}};const serializeTime=(timeValue,timeUnit)=>`${timeValue}${timeUnit}`;const csvToArray=indices=>indices&&Array.isArray(indices)?indices:typeof indices==="string"?indices.split(","):undefined;function deserializeSnapshotDetails(repository,snapshotDetailsEs,managedRepository,successfulSnapshots){if(!snapshotDetailsEs||typeof snapshotDetailsEs!=="object"){throw new Error("Unable to deserialize snapshot details")}const{snapshot:snapshot,uuid:uuid,version_id:versionId,version:version,indices:indices=[],data_streams:dataStreams=[],include_global_state:includeGlobalState,state:state,start_time:startTime,start_time_in_millis:startTimeInMillis,end_time:endTime,end_time_in_millis:endTimeInMillis,duration_in_millis:durationInMillis,failures:failures=[],shards:shards,metadata:{policy:policyName}={policy:undefined}}=snapshotDetailsEs;const indexToFailuresMap=failures.reduce((map,failure)=>{const{index:index,...rest}=failure;if(!map[index]){map[index]={index:index,failures:[]}}map[index].failures.push(rest);return map},{});Object.keys(indexToFailuresMap).forEach(index=>{indexToFailuresMap[index].failures=Object(external_kbnSharedDeps_Lodash_["sortBy"])(indexToFailuresMap[index].failures,({shard:shard})=>shard)});const indexFailures=Object(external_kbnSharedDeps_Lodash_["sortBy"])(Object.values(indexToFailuresMap),({index:index})=>index);const snapshotDetails={repository:repository,snapshot:snapshot,uuid:uuid,versionId:versionId,version:version,indices:[...indices].sort(),dataStreams:[...dataStreams].sort(),includeGlobalState:includeGlobalState,state:state,startTime:startTime,startTimeInMillis:startTimeInMillis,endTime:endTime,endTimeInMillis:endTimeInMillis,durationInMillis:durationInMillis,indexFailures:indexFailures,shards:shards,managedRepository:managedRepository};if(successfulSnapshots&&successfulSnapshots.length){snapshotDetails.isLastSuccessfulSnapshot=successfulSnapshots[0].snapshot===snapshot}if(policyName){snapshotDetails.policyName=policyName}return snapshotDetails}function deserializeSnapshotConfig(snapshotConfigEs){const{indices:indices,ignore_unavailable:ignoreUnavailable,include_global_state:includeGlobalState,partial:partial,metadata:metadata}=snapshotConfigEs;const snapshotConfig={indices:indices,ignoreUnavailable:ignoreUnavailable,includeGlobalState:includeGlobalState,partial:partial,metadata:metadata};return Object.entries(snapshotConfig).reduce((config,[key,value])=>{if(value!==undefined){config[key]=value}return config},{})}function serializeSnapshotConfig(snapshotConfig){const{indices:indices,ignoreUnavailable:ignoreUnavailable,includeGlobalState:includeGlobalState,partial:partial,metadata:metadata}=snapshotConfig;const maybeIndicesArray=csvToArray(indices);const snapshotConfigEs={indices:maybeIndicesArray,ignore_unavailable:ignoreUnavailable,include_global_state:includeGlobalState,partial:partial,metadata:metadata};return Object.entries(snapshotConfigEs).reduce((config,[key,value])=>{if(value!==undefined){config[key]=value}return config},{})}function deserializeSnapshotRetention(snapshotRetentionEs){const{expire_after:expireAfter,max_count:maxCount,min_count:minCount}=snapshotRetentionEs;let expireAfterValue;let expireAfterUnit;if(expireAfter){const{timeValue:timeValue,timeUnit:timeUnit}=deserializeTime(expireAfter);if(timeValue&&timeUnit){expireAfterValue=timeValue;expireAfterUnit=timeUnit}}const snapshotRetention={expireAfterValue:expireAfterValue,expireAfterUnit:expireAfterUnit,maxCount:maxCount,minCount:minCount};return Object.entries(snapshotRetention).reduce((retention,[key,value])=>{if(value!==undefined){retention[key]=value}return retention},{})}function serializeSnapshotRetention(snapshotRetention){const{expireAfterValue:expireAfterValue,expireAfterUnit:expireAfterUnit,minCount:minCount,maxCount:maxCount}=snapshotRetention;const snapshotRetentionEs={expire_after:expireAfterValue&&expireAfterUnit?serializeTime(expireAfterValue,expireAfterUnit):undefined,min_count:!minCount?undefined:minCount,max_count:!maxCount?undefined:maxCount};const flattenedSnapshotRetentionEs=Object.entries(snapshotRetentionEs).reduce((retention,[key,value])=>{if(value!==undefined){retention[key]=value}return retention},{});return Object.entries(flattenedSnapshotRetentionEs).length?flattenedSnapshotRetentionEs:undefined}const deserializePolicy=(name,esPolicy,managedPolicies)=>{const{version:version,modified_date:modifiedDate,modified_date_millis:modifiedDateMillis,policy:{name:snapshotName,schedule:schedule,repository:repository,config:config,retention:retention},next_execution:nextExecution,next_execution_millis:nextExecutionMillis,last_failure:lastFailure,last_success:lastSuccess,in_progress:inProgress,stats:stats}=esPolicy;const policy={name:name,version:version,modifiedDate:modifiedDate,modifiedDateMillis:modifiedDateMillis,snapshotName:snapshotName,schedule:schedule,repository:repository,nextExecution:nextExecution,nextExecutionMillis:nextExecutionMillis,isManagedPolicy:managedPolicies.includes(name)};if(config){policy.config=deserializeSnapshotConfig(config)}if(retention){policy.retention=deserializeSnapshotRetention(retention)}if(lastFailure){const{snapshot_name:failureSnapshotName,time:failureTime,time_string:failureTimeString,details:failureDetails}=lastFailure;let jsonFailureDetails;try{jsonFailureDetails=JSON.parse(failureDetails)}catch(e){}policy.lastFailure={snapshotName:failureSnapshotName,time:failureTime,timeString:failureTimeString,details:jsonFailureDetails||failureDetails}}if(lastSuccess){const{snapshot_name:successSnapshotName,time:successTime,time_string:successTimeString}=lastSuccess;policy.lastSuccess={snapshotName:successSnapshotName,time:successTime,timeString:successTimeString}}if(inProgress){const{name:inProgressSnapshotName}=inProgress;policy.inProgress={snapshotName:inProgressSnapshotName}}if(stats){const{snapshots_taken:snapshotsTaken,snapshots_failed:snapshotsFailed,snapshots_deleted:snapshotsDeleted,snapshot_deletion_failures:snapshotDeletionFailures}=stats;policy.stats={snapshotsTaken:snapshotsTaken,snapshotsFailed:snapshotsFailed,snapshotsDeleted:snapshotsDeleted,snapshotDeletionFailures:snapshotDeletionFailures}}return policy};const serializePolicy=policy=>{const{snapshotName:name,schedule:schedule,repository:repository,config:config,retention:retention}=policy;const policyEs={name:name,schedule:schedule,repository:repository};if(config){policyEs.config=serializeSnapshotConfig(config)}if(retention){const serializedRetention=serializeSnapshotRetention(retention);if(serializedRetention){policyEs.retention=serializeSnapshotRetention(retention)}}return policyEs};const isDataStreamBackingIndex=indexName=>indexName.startsWith(".ds");const INVALID_NAME_CHARS=['"',"*","\\","<","|",",",">","/","?"];const isStringEmpty=str=>str?!Boolean(str.trim()):true;const doesStringContainChar=(string,char)=>{const chars=Array.isArray(char)?char:[char];const total=chars.length;let containsChar=false;let charFound=null;for(let i=0;i<total;i++){if(string.includes(chars[i])){containsChar=true;charFound=chars[i];break}}return{containsChar:containsChar,charFound:charFound}};const validateRepository=(repository,validateSettings=true)=>{const{name:name,type:type,settings:settings}=repository;const{i18n:i18n}=services_text["a"];const validation={isValid:true,errors:{}};if(validateSettings){const settingsValidation=validateRepositorySettings(type,settings);if(Object.keys(settingsValidation).length){validation.errors.settings=settingsValidation}}if(isStringEmpty(name)){validation.errors.name=[i18n.translate("xpack.snapshotRestore.repositoryValidation.nameRequired",{defaultMessage:"Repository name is required."})]}if(name.includes(" ")){validation.errors.name=[i18n.translate("xpack.snapshotRestore.repositoryValidation.nameValidation.errorSpace",{defaultMessage:"Spaces are not allowed in the name."})]}const nameCharValidation=doesStringContainChar(name,INVALID_NAME_CHARS);if(nameCharValidation.containsChar){validation.errors.name=[i18n.translate("xpack.snapshotRestore.repositoryValidation.nameValidation.invalidCharacter",{defaultMessage:'Character "{char}" is not allowed in the name.',values:{char:nameCharValidation.charFound}})]}if(isStringEmpty(type)||type===constants["f"].source&&isStringEmpty(settings.delegateType)){validation.errors.type=[i18n.translate("xpack.snapshotRestore.repositoryValidation.delegateTypeRequired",{defaultMessage:"Type is required."})]}if(Object.keys(validation.errors).length){validation.isValid=false}return validation};const validateRepositorySettings=(type,settings)=>{switch(type){case constants["f"].fs:return validateFSRepositorySettings(settings);case constants["f"].url:return validateReadonlyRepositorySettings(settings);case constants["f"].source:return validateRepositorySettings(settings.delegateType,settings);case constants["f"].s3:return validateS3RepositorySettings(settings);case constants["f"].gcs:return validateGCSRepositorySettings(settings);case constants["f"].hdfs:return validateHDFSRepositorySettings(settings);default:return{}}};const validateFSRepositorySettings=settings=>{const i18n=services_text["a"].i18n;const validation={};const{location:location}=settings;if(isStringEmpty(location)){validation.location=[i18n.translate("xpack.snapshotRestore.repositoryValidation.locationRequired",{defaultMessage:"Location is required."})]}return validation};const validateReadonlyRepositorySettings=settings=>{const i18n=services_text["a"].i18n;const validation={};const{url:url}=settings;if(isStringEmpty(url)){validation.url=[i18n.translate("xpack.snapshotRestore.repositoryValidation.urlRequired",{defaultMessage:"URL is required."})]}return validation};const validateS3RepositorySettings=settings=>{const i18n=services_text["a"].i18n;const validation={};const{bucket:bucket}=settings;if(isStringEmpty(bucket)){validation.bucket=[i18n.translate("xpack.snapshotRestore.repositoryValidation.bucketRequired",{defaultMessage:"Bucket is required."})]}return validation};const validateGCSRepositorySettings=settings=>{const i18n=services_text["a"].i18n;const validation={};const{bucket:bucket}=settings;if(isStringEmpty(bucket)){validation.bucket=[i18n.translate("xpack.snapshotRestore.repositoryValidation.bucketRequired",{defaultMessage:"Bucket is required."})]}return validation};const validateHDFSRepositorySettings=settings=>{const i18n=services_text["a"].i18n;const validation={};const{uri:uri,path:path}=settings;if(isStringEmpty(uri)){validation.uri=[i18n.translate("xpack.snapshotRestore.repositoryValidation.uriRequired",{defaultMessage:"URI is required."})]}if(isStringEmpty(path)){validation.path=[i18n.translate("xpack.snapshotRestore.repositoryValidation.pathRequired",{defaultMessage:"Path is required."})]}return validation};const validate_restore_isStringEmpty=str=>str?!Boolean(str.trim()):true;const validateRestore=restoreSettings=>{const i18n=services_text["a"].i18n;const{indices:indices,renamePattern:renamePattern,renameReplacement:renameReplacement,indexSettings:indexSettings,ignoreIndexSettings:ignoreIndexSettings}=restoreSettings;const validation={isValid:true,errors:{indices:[],renamePattern:[],renameReplacement:[],indexSettings:[],ignoreIndexSettings:[]}};if(typeof indices==="string"&&indices.trim().length===0){validation.errors.indices.push(i18n.translate("xpack.snapshotRestore.restoreValidation.indexPatternRequiredError",{defaultMessage:"At least one index pattern is required."}))}if(Array.isArray(indices)&&indices.length===0){validation.errors.indices.push(i18n.translate("xpack.snapshotRestore.restoreValidation.indicesRequiredError",{defaultMessage:"You must select at least one data stream or index."}))}if(renamePattern!==undefined&&validate_restore_isStringEmpty(renamePattern)){validation.errors.renamePattern.push(i18n.translate("xpack.snapshotRestore.restoreValidation.renamePatternRequiredError",{defaultMessage:"Capture pattern is required."}))}if(renameReplacement!==undefined&&validate_restore_isStringEmpty(renameReplacement)){validation.errors.renameReplacement.push(i18n.translate("xpack.snapshotRestore.restoreValidation.renameReplacementRequiredError",{defaultMessage:"Replacement pattern is required."}))}if(typeof indexSettings==="string"){try{const parsedIndexSettings=JSON.parse(indexSettings);const modifiedSettings=Object.keys(parsedIndexSettings);const modifiedSettingsCount=modifiedSettings.length;const unmodifiableSettings=modifiedSettingsCount>0?modifiedSettings.filter(setting=>application_constants["M"].includes(setting)):null;if(modifiedSettingsCount===0){validation.errors.indexSettings.push(i18n.translate("xpack.snapshotRestore.restoreValidation.indexSettingsRequiredError",{defaultMessage:"At least one setting is required."}))}if(unmodifiableSettings&&unmodifiableSettings.length>0){validation.errors.indexSettings.push(i18n.translate("xpack.snapshotRestore.restoreValidation.indexSettingsNotModifiableError",{defaultMessage:"You can’t modify: {settings}",values:{settings:unmodifiableSettings.map((setting,index)=>index===0?`${setting} `:setting)}}))}}catch(e){validation.errors.indexSettings.push(i18n.translate("xpack.snapshotRestore.restoreValidation.indexSettingsInvalidError",{defaultMessage:"Invalid JSON format"}))}}if(Array.isArray(ignoreIndexSettings)){const ignoredSettingsCount=ignoreIndexSettings.length;const unremovableSettings=ignoredSettingsCount>0?ignoreIndexSettings.filter(setting=>application_constants["N"].includes(setting)):null;if(ignoredSettingsCount===0){validation.errors.ignoreIndexSettings.push(i18n.translate("xpack.snapshotRestore.restoreValidation.ignoreIndexSettingsRequiredError",{defaultMessage:"At least one setting is required."}))}if(unremovableSettings&&unremovableSettings.length>0){validation.errors.ignoreIndexSettings.push(i18n.translate("xpack.snapshotRestore.restoreValidation.indexSettingsNotRemovableError",{defaultMessage:"You can’t reset: {settings}",values:{settings:unremovableSettings.map((setting,index)=>index===0?`${setting} `:setting)}}))}}validation.errors=Object.entries(validation.errors).filter(([key,value])=>value.length>0).reduce((errs,[key,value])=>{errs[key]=value;return errs},{});if(Object.keys(validation.errors).length>0){validation.isValid=false}return validation};const validate_policy_isStringEmpty=str=>str?!Boolean(str.trim()):true;const isSnapshotNameNotLowerCase=str=>{const strExcludeDate=str.substring(0,str.search("{"))+str.substring(str.search("}>")+1,str.length);return strExcludeDate!==strExcludeDate.toLowerCase()?true:false};const validatePolicy=(policy,validationHelperData)=>{const i18n=services_text["a"].i18n;const{name:name,snapshotName:snapshotName,schedule:schedule,repository:repository,config:config,retention:retention}=policy;const{managedRepository:managedRepository,isEditing:isEditing,policyName:policyName,validateIndicesCount:validateIndicesCount,repositoryDoesNotExist:repositoryDoesNotExist}=validationHelperData;const validation={isValid:true,errors:{name:[],snapshotName:[],schedule:[],repository:[],dataStreams:[],indices:[],expireAfterValue:[],minCount:[],maxCount:[]}};if(validate_policy_isStringEmpty(name)){validation.errors.name.push(i18n.translate("xpack.snapshotRestore.policyValidation.nameRequiredErroMessage",{defaultMessage:"Policy name is required."}))}if(validate_policy_isStringEmpty(snapshotName)){validation.errors.snapshotName.push(i18n.translate("xpack.snapshotRestore.policyValidation.snapshotNameRequiredErrorMessage",{defaultMessage:"Snapshot name is required."}))}if(isSnapshotNameNotLowerCase(snapshotName)){validation.errors.snapshotName.push(i18n.translate("xpack.snapshotRestore.policyValidation.snapshotNameLowerCaseErrorMessage",{defaultMessage:"Snapshot name needs to be lowercase."}))}if(validate_policy_isStringEmpty(schedule)){validation.errors.schedule.push(i18n.translate("xpack.snapshotRestore.policyValidation.scheduleRequiredErrorMessage",{defaultMessage:"Schedule is required."}))}if(validate_policy_isStringEmpty(repository)||repositoryDoesNotExist){validation.errors.repository.push(i18n.translate("xpack.snapshotRestore.policyValidation.repositoryRequiredErrorMessage",{defaultMessage:"Repository is required."}))}if(validateIndicesCount&&config&&typeof config.indices==="string"&&config.indices.trim().length===0){validation.errors.indices.push(i18n.translate("xpack.snapshotRestore.policyValidation.indexPatternRequiredErrorMessage",{defaultMessage:"At least one index pattern is required."}))}if(validateIndicesCount&&config&&Array.isArray(config.indices)&&config.indices.length===0){validation.errors.indices.push(i18n.translate("xpack.snapshotRestore.policyValidation.indicesRequiredErrorMessage",{defaultMessage:"You must select at least one data stream or index."}))}if(retention&&retention.minCount&&retention.maxCount&&retention.minCount>retention.maxCount){validation.errors.minCount.push(i18n.translate("xpack.snapshotRestore.policyValidation.invalidMinCountErrorMessage",{defaultMessage:"Minimum count cannot be greater than maximum count."}))}if(managedRepository&&managedRepository.name===repository&&managedRepository.policy&&!(isEditing&&managedRepository.policy===policyName)){validation.errors.repository.push(i18n.translate("xpack.snapshotRestore.policyValidation.invalidRepoErrorMessage",{defaultMessage:'Policy "{policyName}" is already associated with this repository.',values:{policyName:managedRepository.policy}}))}if(retention&&retention.expireAfterValue&&retention.expireAfterValue<0){validation.errors.expireAfterValue.push(i18n.translate("xpack.snapshotRestore.policyValidation.invalidNegativeDeleteAfterErrorMessage",{defaultMessage:"Delete after cannot be negative."}))}if(retention&&retention.minCount&&retention.minCount<0){validation.errors.minCount.push(i18n.translate("xpack.snapshotRestore.policyValidation.invalidNegativeMinCountErrorMessage",{defaultMessage:"Minimum count cannot be negative."}))}if(retention&&retention.maxCount&&retention.maxCount<0){validation.errors.maxCount.push(i18n.translate("xpack.snapshotRestore.policyValidation.invalidNegativeMaxCountErrorMessage",{defaultMessage:"Maximum count cannot be negative."}))}validation.errors=Object.entries(validation.errors).filter(([key,value])=>value.length>0).reduce((errs,[key,value])=>{errs[key]=value;return errs},{});if(Object.keys(validation.errors).length>0){validation.isValid=false}return validation};const RepositoryFormStepOne=({repository:repository,onNext:onNext,updateRepository:updateRepository,validation:validation})=>{const{error:repositoryTypesError,isLoading:repositoryTypesLoading,data:repositoryTypes=[]}=Object(services_http["t"])();const hasValidationErrors=!validation.isValid;const onTypeChange=newType=>{if(repository.type===constants["f"].source){updateRepository({settings:{delegateType:newType}})}else{updateRepository({type:newType,settings:{}})}};const pluginDocLink=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getRepositoryPluginDocUrl(),target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.typePluginsDocLinkText",defaultMessage:"Learn more about plugins."}));const renderNameField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.nameDescriptionTitle",defaultMessage:"Repository name"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.nameDescription",defaultMessage:"A unique name for the repository."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.nameLabel",defaultMessage:"Name"}),isInvalid:Boolean(hasValidationErrors&&validation.errors.name),error:validation.errors.name,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:repository.name,fullWidth:true,onChange:e=>{updateRepository({name:e.target.value})},"data-test-subj":"nameInput"})));const renderTypeCard=(type,index)=>{const isSelectedType=(repository.type===constants["f"].source?repository.settings.delegateType:repository.type)===type;const displayName=services_text["a"].getRepositoryTypeName(type);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCard"],{title:displayName,icon:external_kbnSharedDeps_React_default.a.createElement(RepositoryTypeLogo,{type:type,size:"l"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null),footer:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:documentationLinksService.getRepositoryTypeDocUrl(type),target:"_blank",size:"xs",iconType:"iInCircle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.typeDocsLinkText",defaultMessage:"Learn more"})),selectable:{onClick:()=>onTypeChange(type),isSelected:isSelectedType},"data-test-subj":`${type}RepositoryType`}))};const renderTypes=()=>{if(repositoryTypesError){return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.loadingRepositoryTypesErrorMessage",defaultMessage:"Error loading repository types"}),error:repositoryTypesError})}if(repositoryTypesLoading){return external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.loadingRepositoryTypesDescription",defaultMessage:"Loading repository types…"}))}if(!repositoryTypes.length){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.noRepositoryTypesErrorTitle",defaultMessage:"No repository types available"}),color:"warning","data-test-subj":"noRepositoryTypesError"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.noRepositoryTypesErrorMessage",defaultMessage:"You can install plugins to enable different repository types. {docLink}",values:{docLink:pluginDocLink}}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:4},repositoryTypes.map((type,index)=>renderTypeCard(type,index)))};const renderTypeField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.typeDescriptionTitle",defaultMessage:"Repository type"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{id:"repositoryTypeDescription",size:"s",color:"subdued"},repositoryTypes.includes(constants["f"].fs)&&repositoryTypes.includes(constants["f"].url)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.defaultTypeDescription",defaultMessage:"Elasticsearch supports file system and read-only URL repositories. Additional types require plugins. {docLink}",values:{docLink:pluginDocLink}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.cloudTypeDescription",defaultMessage:"Elasticsearch provides core plugins for custom repositories. {docLink}",values:{docLink:pluginDocLink}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,describedByIds:["repositoryTypeDescription"],fullWidth:true,isInvalid:Boolean(hasValidationErrors&&validation.errors.type),error:validation.errors.type},renderTypes()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}));const renderSourceOnlyToggle=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDescriptionTitle",defaultMessage:"Source-only snapshots"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDescription",defaultMessage:"Creates source-only snapshots that take up to 50% less space. {docLink}",values:{docLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getRepositoryTypeDocUrl(constants["f"].source),target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.sourceOnlyDocLinkText",defaultMessage:"Learn more about source-only repositories."}))}})),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.sourceOnlyLabel",defaultMessage:"Source-only snapshots"}),checked:repository.type===constants["f"].source,onChange:e=>{if(e.target.checked){updateRepository({type:constants["f"].source,settings:{...repository.settings,delegateType:repository.type}})}else{const{settings:{delegateType:delegateType,...rest}}=repository;updateRepository({type:delegateType||null,settings:rest})}},"data-test-subj":"sourceOnlyToggle"})));const renderActions=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",onClick:onNext,fill:true,iconType:"arrowRight",iconSide:"right","data-test-subj":"nextButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.nextButtonLabel",defaultMessage:"Next"}));const renderFormValidationError=()=>{if(!hasValidationErrors){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.validationErrorTitle",defaultMessage:"Fix errors before continuing."}),color:"danger","data-test-subj":"repositoryFormError"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,renderNameField(),renderTypeField(),renderSourceOnlyToggle(),renderFormValidationError(),renderActions())};const AzureSettings=({repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})=>{const{settings:{client:client,container:container,basePath:basePath,compress:compress,chunkSize:chunkSize,readonly:readonly,locationMode:locationMode,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec}}=repository;const hasErrors=Boolean(Object.keys(settingErrors).length);const locationModeOptions=["primary_only","secondary_only"].map(option=>({value:option,text:option}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.clientTitle",defaultMessage:"Client"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.clientDescription",defaultMessage:"The name of the Azure client."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.clientLabel",defaultMessage:"Client"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.client),error:settingErrors.client},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:client||"",fullWidth:true,onChange:e=>{updateRepositorySettings({client:e.target.value})},"data-test-subj":"clientInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.containerTitle",defaultMessage:"Container"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.containerDescription",defaultMessage:"The name of the Azure container to use for snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.containerLabel",defaultMessage:"Container"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.container),error:settingErrors.container},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:container||"",fullWidth:true,onChange:e=>{updateRepositorySettings({container:e.target.value})},"data-test-subj":"containerInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.basePathTitle",defaultMessage:"Base path"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.basePathDescription",defaultMessage:"The container path to the repository data."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.basePathLabel",defaultMessage:"Base path"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.basePath),error:settingErrors.basePath},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:basePath||"",fullWidth:true,onChange:e=>{updateRepositorySettings({basePath:e.target.value})},"data-test-subj":"basePathInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.compressTitle",defaultMessage:"Snapshot compression"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.compressDescription",defaultMessage:"Compresses the index mapping and setting files for snapshots. Data files are not compressed."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.compress),error:settingErrors.compress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.compressLabel",defaultMessage:"Compress snapshots"}),checked:!(compress===false),onChange:e=>{updateRepositorySettings({compress:e.target.checked})},"data-test-subj":"compressToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.chunkSizeTitle",defaultMessage:"Chunk size"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.chunkSizeDescription",defaultMessage:"Breaks files into smaller units when taking snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.chunkSizeLabel",defaultMessage:"Chunk size"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.chunkSize),error:settingErrors.chunkSize,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:chunkSize||"",fullWidth:true,onChange:e=>{updateRepositorySettings({chunkSize:e.target.value})},"data-test-subj":"chunkSizeInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.maxSnapshotBytesTitle",defaultMessage:"Max snapshot bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.maxSnapshotBytesDescription",defaultMessage:"The rate for creating snapshots for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxSnapshotBytesPerSec),error:settingErrors.maxSnapshotBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxSnapshotBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxSnapshotBytesPerSec:e.target.value})},"data-test-subj":"maxSnapshotBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.maxRestoreBytesTitle",defaultMessage:"Max restore bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.maxRestoreBytesDescription",defaultMessage:"The snapshot restore rate for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxRestoreBytesPerSec),error:settingErrors.maxRestoreBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxRestoreBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxRestoreBytesPerSec:e.target.value})},"data-test-subj":"maxRestoreBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.locationModeTitle",defaultMessage:"Location mode"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.locationModeDescription",defaultMessage:"The primary or secondary location. If secondary, read-only is true."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.locationModeLabel",defaultMessage:"Location mode"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.locationMode),error:settingErrors.locationMode},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:locationModeOptions,value:locationMode||locationModeOptions[0].value,onChange:e=>{updateRepositorySettings({locationMode:e.target.value,readonly:e.target.value===locationModeOptions[1].value?true:readonly})},fullWidth:true,"data-test-subj":"locationModeSelect"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.readonlyTitle",defaultMessage:"Read-only"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.readonlyDescription",defaultMessage:"Only one cluster should have write access to this repository. All other clusters should be read-only."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.readonly),error:settingErrors.readonly},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{disabled:locationMode===locationModeOptions[1].value,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeAzure.readonlyLabel",defaultMessage:"Read-only repository"}),checked:!!readonly,onChange:e=>{updateRepositorySettings({readonly:locationMode===locationModeOptions[1].value?true:e.target.checked})},"data-test-subj":"readOnlyToggle"}))))};const FSSettings=({repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})=>{const{settings:{location:location,compress:compress,chunkSize:chunkSize,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec,readonly:readonly}}=repository;const hasErrors=Boolean(Object.keys(settingErrors).length);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.locationTitle",defaultMessage:"File system location"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryFor.typeFS.locationDescription",defaultMessage:"The location must be registered in the {settingKey} setting on all master and data nodes.",values:{settingKey:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"path.repo")}})),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.locationLabel",defaultMessage:"Location (required)"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.location),error:settingErrors.location},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:location||"",fullWidth:true,onChange:e=>{updateRepositorySettings({location:e.target.value})},"data-test-subj":"locationInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.compressTitle",defaultMessage:"Snapshot compression"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.compressDescription",defaultMessage:"Compresses the index mapping and setting files for snapshots. Data files are not compressed."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.compress),error:settingErrors.compress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.compressLabel",defaultMessage:"Compress snapshots"}),checked:!!compress,onChange:e=>{updateRepositorySettings({compress:e.target.checked})},"data-test-subj":"compressToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.chunkSizeTitle",defaultMessage:"Chunk size"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.chunkSizeDescription",defaultMessage:"Breaks files into smaller units when taking snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.chunkSizeLabel",defaultMessage:"Chunk size"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.chunkSize),error:settingErrors.chunkSize,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:chunkSize||"",fullWidth:true,onChange:e=>{updateRepositorySettings({chunkSize:e.target.value})},"data-test-subj":"chunkSizeInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.maxSnapshotBytesTitle",defaultMessage:"Max snapshot bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.maxSnapshotBytesDescription",defaultMessage:"The rate for creating snapshots for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxSnapshotBytesPerSec),error:settingErrors.maxSnapshotBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxSnapshotBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxSnapshotBytesPerSec:e.target.value})},"data-test-subj":"maxSnapshotBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.maxRestoreBytesTitle",defaultMessage:"Max restore bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.maxRestoreBytesDescription",defaultMessage:"The snapshot restore rate for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxRestoreBytesPerSec),error:settingErrors.maxRestoreBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxRestoreBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxRestoreBytesPerSec:e.target.value})},"data-test-subj":"maxRestoreBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.readonlyTitle",defaultMessage:"Read-only"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.readonlyDescription",defaultMessage:"Only one cluster should have write access to this repository. All other clusters should be read-only."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.readonly),error:settingErrors.readonly},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeFS.readonlyLabel",defaultMessage:"Read-only repository"}),checked:!!readonly,onChange:e=>{updateRepositorySettings({readonly:e.target.checked})},"data-test-subj":"readOnlyToggle"}))))};const GCSSettings=({repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})=>{const{settings:{bucket:bucket,client:client,basePath:basePath,compress:compress,chunkSize:chunkSize,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec,readonly:readonly}}=repository;const hasErrors=Boolean(Object.keys(settingErrors).length);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.clientTitle",defaultMessage:"Client"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.clientDescription",defaultMessage:"The name of the Google Cloud Storage client."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.clientLabel",defaultMessage:"Client"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.client),error:settingErrors.client},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:client||"",fullWidth:true,onChange:e=>{updateRepositorySettings({client:e.target.value})},"data-test-subj":"clientInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.bucketTitle",defaultMessage:"Bucket"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.bucketDescription",defaultMessage:"The name of the Google Cloud Storage bucket to use for snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.bucketLabel",defaultMessage:"Bucket (required)"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.bucket),error:settingErrors.bucket},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:bucket||"",fullWidth:true,onChange:e=>{updateRepositorySettings({bucket:e.target.value})},"data-test-subj":"bucketInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.basePathTitle",defaultMessage:"Base path"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.basePathDescription",defaultMessage:"The bucket path to the repository data."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.basePathLabel",defaultMessage:"Base path"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.basePath),error:settingErrors.basePath},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:basePath||"",fullWidth:true,onChange:e=>{updateRepositorySettings({basePath:e.target.value})},"data-test-subj":"basePathInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.compressTitle",defaultMessage:"Compress snapshots"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.compressDescription",defaultMessage:"Compresses the index mapping and setting files for snapshots. Data files are not compressed."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.compress),error:settingErrors.compress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.compressLabel",defaultMessage:"Compress snapshots"}),checked:!(compress===false),onChange:e=>{updateRepositorySettings({compress:e.target.checked})},"data-test-subj":"compressToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.chunkSizeTitle",defaultMessage:"Chunk size"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.chunkSizeDescription",defaultMessage:"Breaks files into smaller units when taking snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.chunkSizeLabel",defaultMessage:"Chunk size"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.chunkSize),error:settingErrors.chunkSize,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:chunkSize||"",fullWidth:true,onChange:e=>{updateRepositorySettings({chunkSize:e.target.value})},"data-test-subj":"chunkSizeInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.maxSnapshotBytesTitle",defaultMessage:"Max snapshot bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.maxSnapshotBytesDescription",defaultMessage:"The rate for creating snapshots for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxSnapshotBytesPerSec),error:settingErrors.maxSnapshotBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxSnapshotBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxSnapshotBytesPerSec:e.target.value})},"data-test-subj":"maxSnapshotBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.maxRestoreBytesTitle",defaultMessage:"Max restore bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.maxRestoreBytesDescription",defaultMessage:"The snapshot restore rate for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxRestoreBytesPerSec),error:settingErrors.maxRestoreBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxRestoreBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxRestoreBytesPerSec:e.target.value})},"data-test-subj":"maxRestoreBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.readonlyTitle",defaultMessage:"Read-only"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.readonlyDescription",defaultMessage:"Only one cluster should have write access to this repository. All other clusters should be read-only."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.readonly),error:settingErrors.readonly},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeGCS.readonlyLabel",defaultMessage:"Read-only repository"}),checked:!!readonly,onChange:e=>{updateRepositorySettings({readonly:e.target.checked})},"data-test-subj":"readOnlyToggle"}))))};const HDFSSettings=({repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})=>{const{name:name,settings:{delegateType:delegateType,uri:uri,path:path,loadDefaults:loadDefaults,compress:compress,chunkSize:chunkSize,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec,readonly:readonly,"security.principal":securityPrincipal,...rest}}=repository;const hasErrors=Boolean(Object.keys(settingErrors).length);const[additionalConf,setAdditionalConf]=Object(external_kbnSharedDeps_React_["useState"])(JSON.stringify(rest,null,2));const[isConfInvalid,setIsConfInvalid]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.uriTitle",defaultMessage:"URI"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.uriDescription",defaultMessage:"The URI address for HDFS."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.uriLabel",defaultMessage:"URI (required)"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.uri),error:settingErrors.uri},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{prepend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",id:"hdfsRepositoryUriProtocolDescription"},"hdfs://"),defaultValue:uri?uri.split("hdfs://")[1]:"",fullWidth:true,onChange:e=>{updateRepositorySettings({uri:e.target.value?`hdfs://${e.target.value}`:""})},"aria-describedby":"hdfsRepositoryUriProtocolDescription","data-test-subj":"uriInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.pathTitle",defaultMessage:"Path"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.pathDescription",defaultMessage:"The file path where data is stored."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.pathLabel",defaultMessage:"Path (required)"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.path),error:settingErrors.path},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:path||"",fullWidth:true,onChange:e=>{updateRepositorySettings({path:e.target.value})},"data-test-subj":"pathInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.loadDefaultsTitle",defaultMessage:"Load defaults"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.loadDefaultsDescription",defaultMessage:"Loads the default Hadoop configuration."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.loadDefaults),error:settingErrors.loadDefaults},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.loadDefaultsLabel",defaultMessage:"Load defaults"}),checked:!(loadDefaults===false),onChange:e=>{updateRepositorySettings({loadDefaults:e.target.checked})},"data-test-subj":"loadDefaultsToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.compressTitle",defaultMessage:"Snapshot compression"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.compressDescription",defaultMessage:"Compresses the index mapping and setting files for snapshots. Data files are not compressed."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.compress),error:settingErrors.compress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.compressLabel",defaultMessage:"Compress snapshots"}),checked:!(compress===false),onChange:e=>{updateRepositorySettings({compress:e.target.checked})},"data-test-subj":"compressToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.chunkSizeTitle",defaultMessage:"Chunk size"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.chunkSizeDescription",defaultMessage:"Breaks files into smaller units when taking snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.chunkSizeLabel",defaultMessage:"Chunk size"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.chunkSize),error:settingErrors.chunkSize,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:chunkSize||"",fullWidth:true,onChange:e=>{updateRepositorySettings({chunkSize:e.target.value})},"data-test-subj":"chunkSizeInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.securityPrincipalTitle",defaultMessage:"Security principal"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.securityPrincipalDescription",defaultMessage:"The Kerberos principal to use when connecting to a secured HDFS cluster."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.securityPrincipalLabel",defaultMessage:"Security principal"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.securityPrincipal),error:settingErrors.securityPrincipal},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:securityPrincipal||"",fullWidth:true,onChange:e=>{updateRepositorySettings({"security.principal":e.target.value})},"data-test-subj":"securityPrincipalInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.configurationTitle",defaultMessage:"Configuration"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.configurationDescription",defaultMessage:"Additional JSON format configuration parameters to add to the Hadoop configuration. Only client-oriented properties from the Hadoop core and HDFS files are recognized."})),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.configurationLabel",defaultMessage:"Configuration"}),fullWidth:true,isInvalid:isConfInvalid,error:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.configurationFormatError",defaultMessage:"Invalid JSON format"}),helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.configurationKeyDescription",defaultMessage:"Keys should be in the format {confKeyFormat}.",values:{confKeyFormat:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"conf.<key>")}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{mode:"json",theme:"textmate",width:"100%",value:additionalConf,setOptions:{showLineNumbers:false,tabSize:2,maxLines:Infinity},editorProps:{$blockScrolling:Infinity},showGutter:false,minLines:6,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.snapshotRestore.repositoryForm.typeHDFS.configurationAriaLabel",{defaultMessage:`Additional configuration for HDFS repository '{name}'`,values:{name:name}}),onChange:value=>{setAdditionalConf(value);try{const parsedConf=JSON.parse(value);setIsConfInvalid(false);updateRepositorySettings({delegateType:delegateType,uri:uri,path:path,loadDefaults:loadDefaults,compress:compress,chunkSize:chunkSize,"security.principal":securityPrincipal,...parsedConf},true)}catch(e){setIsConfInvalid(true)}},"data-test-subj":"codeEditor"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.maxSnapshotBytesTitle",defaultMessage:"Max snapshot bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.maxSnapshotBytesDescription",defaultMessage:"The rate for creating snapshots for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxSnapshotBytesPerSec),error:settingErrors.maxSnapshotBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxSnapshotBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxSnapshotBytesPerSec:e.target.value})},"data-test-subj":"maxSnapshotBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.maxRestoreBytesTitle",defaultMessage:"Max restore bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.maxRestoreBytesDescription",defaultMessage:"The snapshot restore rate for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxRestoreBytesPerSec),error:settingErrors.maxRestoreBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxRestoreBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxRestoreBytesPerSec:e.target.value})},"data-test-subj":"maxRestoreBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.readonlyTitle",defaultMessage:"Read-only"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.readonlyDescription",defaultMessage:"Only one cluster should have write access to this repository. All other clusters should be read-only."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.readonly),error:settingErrors.readonly},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeHDFS.readonlyLabel",defaultMessage:"Read-only repository"}),checked:!!readonly,onChange:e=>{updateRepositorySettings({readonly:e.target.checked})},"data-test-subj":"readOnlyToggle"}))))};const ReadonlySettings=({repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})=>{const{settings:{url:url}}=repository;const hasErrors=Boolean(Object.keys(settingErrors).length);function getSchemeHelpText(scheme){switch(scheme){case"http":case"https":case"ftp":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeReadonly.urlAllowedDescription",defaultMessage:"This URL must be registered in the {settingKey} setting.",values:{settingKey:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"repositories.url.allowed_urls")}});case"file":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeReadonly.urlFilePathDescription",defaultMessage:"This file location must be registered in the {settingKey} setting.",values:{settingKey:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"path.repo")}});default:return null}}const schemeOptions=[{value:"http",text:"http://"},{value:"https",text:"https://"},{value:"ftp",text:"ftp://"},{value:"file",text:"file://"}];const[selectedScheme,selectScheme]=Object(external_kbnSharedDeps_React_["useState"])(url?url.split("://")[0]:"http");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeReadonly.urlTitle",defaultMessage:"URL"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeReadonly.urlDescription",defaultMessage:"The location of the snapshots."})),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeReadonly.urlSchemeLabel",defaultMessage:"Scheme"}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:schemeOptions,value:selectedScheme,onChange:e=>selectScheme(e.target.value),"aria-controls":"readonlyRepositoryUrlHelp","data-test-subj":"schemeSelect"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeReadonly.urlLabel",defaultMessage:"Path (required)"}),fullWidth:true,describedByIds:["readonlyRepositoryUrlHelp"],isInvalid:Boolean(hasErrors&&settingErrors.url),error:settingErrors.url},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:url?url.split("://")[1]:"",fullWidth:true,onChange:e=>{updateRepositorySettings({url:`${selectedScheme}://${e.target.value}`})},"data-test-subj":"urlInput"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormHelpText"],{id:"readonlyRepositoryUrlHelp","aria-live":"polite"},getSchemeHelpText(selectedScheme)))))};const S3Settings=({repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})=>{const{settings:{bucket:bucket,client:client,basePath:basePath,compress:compress,chunkSize:chunkSize,serverSideEncryption:serverSideEncryption,bufferSize:bufferSize,cannedAcl:cannedAcl,storageClass:storageClass,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec,readonly:readonly}}=repository;const cannedAclOptions=["private","public-read","public-read-write","authenticated-read","log-delivery-write","bucket-owner-read","bucket-owner-full-control"].map(option=>({value:option,text:option}));const hasErrors=Boolean(Object.keys(settingErrors).length);const storageClassOptions=["standard","reduced_redundancy","standard_ia"].map(option=>({value:option,text:option}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.clientTitle",defaultMessage:"Client"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.clientDescription",defaultMessage:"The name of the AWS S3 client."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.clientLabel",defaultMessage:"Client"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.client),error:settingErrors.client},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:client||"",fullWidth:true,onChange:e=>{updateRepositorySettings({client:e.target.value})},"data-test-subj":"clientInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.bucketTitle",defaultMessage:"Bucket"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.bucketDescription",defaultMessage:"The name of the AWS S3 bucket to use for snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.bucketLabel",defaultMessage:"Bucket (required)"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.bucket),error:settingErrors.bucket},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:bucket||"",fullWidth:true,onChange:e=>{updateRepositorySettings({bucket:e.target.value})},"data-test-subj":"bucketInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.basePathTitle",defaultMessage:"Base path"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.basePathDescription",defaultMessage:"The bucket path to the repository data."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.basePathLabel",defaultMessage:"Base path"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.basePath),error:settingErrors.basePath},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:basePath||"",fullWidth:true,onChange:e=>{updateRepositorySettings({basePath:e.target.value})},"data-test-subj":"basePathInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.compressTitle",defaultMessage:"Snapshot compression"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.compressDescription",defaultMessage:"Compresses the index mapping and setting files for snapshots. Data files are not compressed."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.compress),error:settingErrors.compress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.compressLabel",defaultMessage:"Compress snapshots"}),checked:!(compress===false),onChange:e=>{updateRepositorySettings({compress:e.target.checked})},"data-test-subj":"compressToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.chunkSizeTitle",defaultMessage:"Chunk size"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.chunkSizeDescription",defaultMessage:"Breaks files into smaller units when taking snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.chunkSizeLabel",defaultMessage:"Chunk size"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.chunkSize),error:settingErrors.chunkSize,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:chunkSize||"",fullWidth:true,onChange:e=>{updateRepositorySettings({chunkSize:e.target.value})},"data-test-subj":"chunkSizeInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.serverSideEncryptionTitle",defaultMessage:"Server-side encryption"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.serverSideEncryptionDescription",defaultMessage:"Encrypts files on the server using AES256 algorithm."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.serverSideEncryption),error:settingErrors.serverSideEncryption},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.serverSideEncryptionLabel",defaultMessage:"Server-side encryption"}),checked:!!serverSideEncryption,onChange:e=>{updateRepositorySettings({serverSideEncryption:e.target.checked})},"data-test-subj":"serverSideEncryptionToggle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeTitle",defaultMessage:"Buffer size"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeDescription",defaultMessage:"Beyond this minimum threshold, the S3 repository will use the AWS Multipart Upload API to split the chunk into several parts and upload each in its own request."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.bufferSizeLabel",defaultMessage:"Buffer size"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.bufferSize),error:settingErrors.bufferSize,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:bufferSize||"",fullWidth:true,onChange:e=>{updateRepositorySettings({bufferSize:e.target.value})},"data-test-subj":"bufferSizeInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.cannedAclTitle",defaultMessage:"Canned ACL"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.cannedAclDescription",defaultMessage:"The canned ACL to add to new S3 buckets and objects."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.cannedAclLabel",defaultMessage:"Canned ACL"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.cannedAcl),error:settingErrors.cannedAcl},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:cannedAclOptions,value:cannedAcl||cannedAclOptions[0].value,onChange:e=>{updateRepositorySettings({cannedAcl:e.target.value})},fullWidth:true,"data-test-subj":"cannedAclSelect"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.storageClassTitle",defaultMessage:"Storage class"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.storageClassDescription",defaultMessage:"The storage class for new objects in the S3 repository."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.storageClassLabel",defaultMessage:"Storage class"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.storageClass),error:settingErrors.storageClass},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:storageClassOptions,value:storageClass||storageClassOptions[0].value,onChange:e=>{updateRepositorySettings({storageClass:e.target.value})},fullWidth:true,"data-test-subj":"storageClassSelect"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.maxSnapshotBytesTitle",defaultMessage:"Max snapshot bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.maxSnapshotBytesDescription",defaultMessage:"The rate for creating snapshots for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxSnapshotBytesPerSec),error:settingErrors.maxSnapshotBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxSnapshotBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxSnapshotBytesPerSec:e.target.value})},"data-test-subj":"maxSnapshotBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.maxRestoreBytesTitle",defaultMessage:"Max restore bytes per second"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.maxRestoreBytesDescription",defaultMessage:"The snapshot restore rate for each node."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.maxRestoreBytesPerSec),error:settingErrors.maxRestoreBytesPerSec,helpText:services_text["a"].getSizeNotationHelpText()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:maxRestoreBytesPerSec||"",fullWidth:true,onChange:e=>{updateRepositorySettings({maxRestoreBytesPerSec:e.target.value})},"data-test-subj":"maxRestoreBytesInput"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.readonlyTitle",defaultMessage:"Read-only"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.readonlyDescription",defaultMessage:"Only one cluster should have write access to this repository. All other clusters should be read-only."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,isInvalid:Boolean(hasErrors&&settingErrors.readonly),error:settingErrors.readonly},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.typeS3.readonlyLabel",defaultMessage:"Read-only repository"}),checked:!!readonly,onChange:e=>{updateRepositorySettings({readonly:e.target.checked})},"data-test-subj":"readOnlyToggle"}))))};const TypeSettings=({repository:repository,updateRepository:updateRepository,settingErrors:settingErrors})=>{const{i18n:i18n}=useServices();const{type:type,settings:settings}=repository;const updateRepositorySettings=(updatedSettings,replaceSettings)=>{if(replaceSettings){updateRepository({settings:updatedSettings})}else{updateRepository({settings:{...settings,...updatedSettings}})}};const typeSettingsMap={[constants["f"].fs]:FSSettings,[constants["f"].url]:ReadonlySettings,[constants["f"].azure]:AzureSettings,[constants["f"].gcs]:GCSSettings,[constants["f"].hdfs]:HDFSSettings,[constants["f"].s3]:S3Settings};const renderTypeSettings=repositoryType=>{if(!repositoryType){return null}const RepositorySettings=typeSettingsMap[repositoryType];if(RepositorySettings){return external_kbnSharedDeps_React_default.a.createElement(RepositorySettings,{repository:repository,updateRepositorySettings:updateRepositorySettings,settingErrors:settingErrors})}return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.errorUnknownRepositoryTypesTitle",defaultMessage:"Unknown repository type"}),error:{error:i18n.translate("xpack.snapshotRestore.repositoryForm.errorUnknownRepositoryTypesMessage",{defaultMessage:`The repository type '{type}' is not supported.`,values:{type:repositoryType}})}})};return type===constants["f"].source?renderTypeSettings(settings.delegateType):renderTypeSettings(type)};const RepositoryFormStepTwo=({repository:repository,isManagedRepository:isManagedRepository,isEditing:isEditing,isSaving:isSaving,onSave:onSave,updateRepository:updateRepository,validation:validation,saveError:saveError,onBack:onBack})=>{const hasValidationErrors=!validation.isValid;const{name:name,type:type,settings:{delegateType:delegateType}}=repository;const typeForDocs=type===constants["f"].source?delegateType:type;const renderSettings=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.fields.settingsTitle",defaultMessage:"{repositoryName} settings",values:{repositoryName:`'${name}'`}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getRepositoryTypeDocUrl(typeForDocs),target:"_blank",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.repositoryTypeDocLink",defaultMessage:"{repositoryType} repository docs",values:{repositoryType:services_text["a"].getRepositoryTypeName(typeForDocs)}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(TypeSettings,{repository:repository,updateRepository:updateRepository,settingErrors:hasValidationErrors&&validation.errors.settings?validation.errors.settings:{}}));const renderActions=()=>{const saveLabel=isEditing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.saveButtonLabel",defaultMessage:"Save"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.registerButtonLabel",defaultMessage:"Register"});const savingLabel=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.savingButtonLabel",defaultMessage:"Saving…"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",alignItems:"center"},isEditing?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",iconType:"arrowLeft",onClick:onBack,"data-test-subj":"backButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.backButtonLabel",defaultMessage:"Back"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:isManagedRepository?"warning":"secondary",iconType:"check",onClick:onSave,fill:isManagedRepository?false:true,"data-test-subj":"submitButton",isLoading:isSaving},isSaving?savingLabel:saveLabel)))};const renderFormValidationError=()=>{if(!hasValidationErrors){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryForm.validationErrorTitle",defaultMessage:"Fix errors before continuing."}),color:"danger",iconType:"cross","data-test-subj":"repositoryFormError"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};const renderSaveError=()=>{if(!saveError){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,saveError,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};return external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"stepTwo"},renderSettings(),renderFormValidationError(),renderSaveError(),renderActions())};const RepositoryForm=({repository:originalRepository,isManagedRepository:isManagedRepository,isEditing:isEditing,isSaving:isSaving,saveError:saveError,clearSaveError:clearSaveError,onSave:onSave})=>{const[currentStep,setCurrentStep]=Object(external_kbnSharedDeps_React_["useState"])(isEditing?2:1);const[repository,setRepository]=Object(external_kbnSharedDeps_React_["useState"])({...originalRepository,settings:{...originalRepository.settings}});const[validation,setValidation]=Object(external_kbnSharedDeps_React_["useState"])({isValid:true,errors:{}});const updateRepository=updatedFields=>{const newRepository={...repository,...updatedFields};setRepository(newRepository)};const saveRepository=()=>{const newValidation=validateRepository(repository,true);const{isValid:isValid}=newValidation;setValidation(newValidation);if(isValid){onSave(repository)}};const goToNextStep=()=>{const newValidation=validateRepository(repository,false);const{isValid:isValid}=newValidation;setValidation(newValidation);if(isValid){setCurrentStep(2)}};const goToPreviousStep=()=>{if(isEditing){return}setValidation({isValid:true,errors:{}});setCurrentStep(1);clearSaveError()};const hasValidationErrors=!validation.isValid;const validationErrors=Object.entries(flatten(validation.errors)).reduce((acc,[key,value])=>[...acc,value],[]);const renderStepOne=()=>external_kbnSharedDeps_React_default.a.createElement(RepositoryFormStepOne,{repository:repository,onNext:()=>goToNextStep(),updateRepository:updateRepository,validation:validation});const renderStepTwo=()=>external_kbnSharedDeps_React_default.a.createElement(RepositoryFormStepTwo,{repository:repository,isManagedRepository:isManagedRepository,isEditing:isEditing,isSaving:isSaving,onSave:saveRepository,updateRepository:updateRepository,validation:validation,saveError:saveError,onBack:()=>goToPreviousStep()});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{isInvalid:hasValidationErrors,error:validationErrors,"data-test-subj":"repositoryForm"},currentStep===1&&!isEditing?renderStepOne():renderStepTwo())};RepositoryForm.defaultProps={isEditing:false,isSaving:false};const RepositoryVerificationBadge=({verificationResults:verificationResults})=>{if(!verificationResults){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryVerification.verificationUnknownValue",defaultMessage:"Unknown"}))}if(verificationResults.valid){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"success"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryVerification.verificationSuccessfulValue",defaultMessage:"Connected"}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryVerification.verificationErrorValue",defaultMessage:"Not connected"}))};function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const RepositoryTypeLogo=({type:type,...rest})=>{const typeLogoMap={[constants["f"].fs]:"storage",[constants["f"].url]:"eye",[constants["f"].azure]:"logoAzure",[constants["f"].gcs]:"logoGCP",[constants["f"].hdfs]:"logoApache",[constants["f"].s3]:"logoAWS"};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],_extends({type:typeLogoMap[type]||"folderOpen"},rest))};const SectionLoading=({inline:inline,children:children,...rest})=>{if(inline){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexStart",alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],rest,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},children))))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"}),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},children),"data-test-subj":"sectionLoading"})};const SnapshotDeleteProvider=({children:children})=>{const{i18n:i18n}=useServices();const toastNotifications=useToastNotifications();const[snapshotIds,setSnapshotIds]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isDeleting,setIsDeleting]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const deleteSnapshotPrompt=(ids,onSuccess=(()=>undefined))=>{if(!ids||!ids.length){throw new Error("No snapshot IDs specified for deletion")}setIsModalOpen(true);setSnapshotIds(ids);onSuccessCallback.current=onSuccess};const closeModal=()=>{setIsModalOpen(false);setSnapshotIds([])};const deleteSnapshot=()=>{const snapshotsToDelete=[...snapshotIds];setIsDeleting(true);Object(services_http["f"])(snapshotsToDelete).then(({data:data,error:error})=>{const{itemsDeleted:itemsDeleted,errors:errors}=data||{itemsDeleted:undefined,errors:undefined};closeModal();setIsDeleting(false);if(itemsDeleted&&itemsDeleted.length){const hasMultipleSuccesses=itemsDeleted.length>1;const successMessage=hasMultipleSuccesses?i18n.translate("xpack.snapshotRestore.deleteSnapshot.successMultipleNotificationTitle",{defaultMessage:"Deleted {count} snapshots",values:{count:itemsDeleted.length}}):i18n.translate("xpack.snapshotRestore.deleteSnapshot.successSingleNotificationTitle",{defaultMessage:"Deleted snapshot '{name}'",values:{name:itemsDeleted[0].snapshot}});toastNotifications.addSuccess(successMessage);if(onSuccessCallback.current){onSuccessCallback.current([...itemsDeleted])}}if(error||errors&&errors.length){const hasMultipleErrors=errors&&errors.length>1||error&&snapshotsToDelete.length>1;const errorMessage=hasMultipleErrors?i18n.translate("xpack.snapshotRestore.deleteSnapshot.errorMultipleNotificationTitle",{defaultMessage:"Error deleting {count} snapshots",values:{count:errors&&errors.length||snapshotsToDelete.length}}):i18n.translate("xpack.snapshotRestore.deleteSnapshot.errorSingleNotificationTitle",{defaultMessage:"Error deleting snapshot '{name}'",values:{name:errors&&errors[0].id.snapshot||snapshotsToDelete[0].snapshot}});toastNotifications.addDanger(errorMessage)}})};const renderModal=()=>{if(!isModalOpen){return null}const isSingle=snapshotIds.length===1;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteSingleTitle",defaultMessage:"Delete snapshot '{name}'?",values:{name:snapshotIds[0].snapshot}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteMultipleTitle",defaultMessage:"Delete {count} snapshots?",values:{count:snapshotIds.length}}),onCancel:closeModal,onConfirm:deleteSnapshot,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.confirmButtonLabel",defaultMessage:"Delete {count, plural, one {snapshot} other {snapshots}}",values:{count:snapshotIds.length}}),confirmButtonDisabled:isDeleting,buttonColor:"danger","data-test-subj":"srdeleteSnapshotConfirmationModal"},!isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteMultipleListDescription",defaultMessage:"You are about to delete these snapshots:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,snapshotIds.map(({snapshot:snapshot,repository:repository})=>external_kbnSharedDeps_React_default.a.createElement("li",{key:`${repository}/${snapshot}`},snapshot)))):null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.deleteMultipleDescription",defaultMessage:"Restore operations associated with {count, plural, one {this snapshot} other {these snapshots}} will stop.",values:{count:snapshotIds.length}})),!isSingle&&isDeleting?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"warning",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.deletingCalloutTitle",defaultMessage:"Deleting snapshots"}))))},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deleteSnapshot.confirmModal.deletingCalloutDescription",defaultMessage:"This may take a few minutes."})))):null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(deleteSnapshotPrompt),renderModal())};const orderDataStreamsAndIndices=({dataStreams:dataStreams,indices:indices})=>dataStreams.concat(indices);const DataStreamBadge=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":"dataStreamBadge",color:"primary"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.snapshotRestore.policyForm.setSettings.dataStreamBadgeContent",{defaultMessage:"Data stream"}));const i18nTexts={callout:{title:count=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.snapshotRestore.restoreForm.dataStreamsWarningCallOut.title",{defaultMessage:"This snapshot contains {count, plural, one {a data stream} other {data streams}}",values:{count:count}}),body:()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.dataStreamsWarningCallOut.body",defaultMessage:"Each data stream requires a matching index template. Please ensure any restored data streams have a matching index template. You can restore index templates by restoring the global cluster state. However, this may overwrite existing templates, cluster settings, ingest pipelines, and lifecycle policies. {learnMoreLink} about restoring snapshots that contain data streams.",values:{learnMoreLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{target:"_blank",href:documentationLinksService.getSnapshotDocUrl()},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.snapshotRestore.restoreForm.dataStreamsWarningCallOut.body.learnMoreLink",{defaultMessage:"Learn more"}))}})}};const DataStreamsGlobalStateCallOut=({dataStreamsCount:dataStreamsCount})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{"data-test-subj":"dataStreamWarningCallOut",title:i18nTexts.callout.title(dataStreamsCount),iconType:"alert",color:"warning"},i18nTexts.callout.body());const DataStreamsAndIndicesListHelpText=({onSelectionChange:onSelectionChange,selectedIndicesAndDataStreams:selectedIndicesAndDataStreams,indices:indices,dataStreams:dataStreams})=>{if(selectedIndicesAndDataStreams.length===0){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.noDataStreamsOrIndicesHelpText",defaultMessage:"Nothing will be restored. {selectAllLink}",values:{selectAllLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{onSelectionChange("all")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.selectAllIndicesLink",defaultMessage:"Select all"}))}})}const indicesCount=selectedIndicesAndDataStreams.reduce((acc,v)=>indices.includes(v)?acc+1:acc,0);const dataStreamsCount=selectedIndicesAndDataStreams.reduce((acc,v)=>dataStreams.includes(v)?acc+1:acc,0);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.selectDataStreamsAndIndicesHelpText",defaultMessage:"{indicesCount} {indicesCount, plural, one {index} other {indices}} and {dataStreamsCount} {dataStreamsCount, plural, one {data stream} other {data streams}} will be restored. {deselectAllLink}",values:{dataStreamsCount:dataStreamsCount,indicesCount:indicesCount,deselectAllLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"deselectIndicesLink",onClick:()=>{onSelectionChange("none")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.deselectAllIndicesLink",defaultMessage:"Deselect all"}))}})};const RestoreSnapshotStepLogistics=({snapshotDetails:snapshotDetails,restoreSettings:restoreSettings,updateRestoreSettings:updateRestoreSettings,errors:errors})=>{var _csvToArray;const{i18n:i18n}=useServices();const{indices:unfilteredSnapshotIndices,dataStreams:snapshotDataStreams=[],includeGlobalState:snapshotIncludeGlobalState}=snapshotDetails;const snapshotIndices=unfilteredSnapshotIndices.filter(index=>!isDataStreamBackingIndex(index));const snapshotIndicesAndDataStreams=snapshotIndices.concat(snapshotDataStreams);const comboBoxOptions=orderDataStreamsAndIndices({dataStreams:snapshotDataStreams.map(dataStream=>({label:dataStream,value:{isDataStream:true,name:dataStream}})),indices:snapshotIndices.map(index=>({label:index,value:{isDataStream:false,name:index}}))});const{indices:restoreIndices,renamePattern:renamePattern,renameReplacement:renameReplacement,partial:partial,includeGlobalState:includeGlobalState}=restoreSettings;const[isAllIndicesAndDataStreams,setIsAllIndicesAndDataStreams]=Object(external_kbnSharedDeps_React_["useState"])(!Boolean(restoreIndices));const[indicesAndDataStreamsOptions,setIndicesAndDataStreamsOptions]=Object(external_kbnSharedDeps_React_["useState"])(()=>orderDataStreamsAndIndices({dataStreams:snapshotDataStreams.map(dataStream=>({label:dataStream,append:external_kbnSharedDeps_React_default.a.createElement(DataStreamBadge,null),checked:isAllIndicesAndDataStreams||typeof restoreIndices==="string"||Array.isArray(restoreIndices)&&restoreIndices.includes(dataStream)?"on":undefined})),indices:snapshotIndices.map(index=>({label:index,checked:isAllIndicesAndDataStreams||typeof restoreIndices==="string"||Array.isArray(restoreIndices)&&restoreIndices.includes(index)?"on":undefined}))}));const[selectIndicesMode,setSelectIndicesMode]=Object(external_kbnSharedDeps_React_["useState"])(typeof restoreIndices==="string"||snapshotIndicesAndDataStreams.length>100?"custom":"list");const[restoreIndexPatterns,setRestoreIndexPatterns]=Object(external_kbnSharedDeps_React_["useState"])(typeof restoreIndices==="string"?restoreIndices.split(","):[]);const[isRenamingIndices,setIsRenamingIndices]=Object(external_kbnSharedDeps_React_["useState"])(Boolean(renamePattern||renameReplacement));const[cachedRestoreSettings,setCachedRestoreSettings]=Object(external_kbnSharedDeps_React_["useState"])({indices:[...snapshotIndicesAndDataStreams],renamePattern:"",renameReplacement:""});return external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"snapshotRestoreStepLogistics",className:"snapshotRestore__restoreForm__stepLogistics"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogisticsTitle",defaultMessage:"Restore details"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getRestoreDocUrl(),target:"_blank",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.docsButtonLabel",defaultMessage:"Snapshot and Restore docs"})))),snapshotDataStreams.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(DataStreamsGlobalStateCallOut,{dataStreamsCount:snapshotDataStreams.length})):undefined,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesTitle",defaultMessage:"Data streams and indices"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesDescription",defaultMessage:"Creates new data streams and indices if they don’t exist. Opens existing indices, including backing indices for a data stream, if they are closed and have the same number of shards as the snapshot index."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.allDataStreamsAndIndicesLabel",defaultMessage:"All data streams and indices, including system indices"}),checked:isAllIndicesAndDataStreams,onChange:e=>{const isChecked=e.target.checked;setIsAllIndicesAndDataStreams(isChecked);if(isChecked){updateRestoreSettings({indices:undefined})}else{updateRestoreSettings({indices:selectIndicesMode==="custom"?restoreIndexPatterns.join(","):[...cachedRestoreSettings.indices||[]]})}}}),isAllIndicesAndDataStreams?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{className:"snapshotRestore__restoreForm__stepLogistics__indicesFieldWrapper",label:selectIndicesMode==="list"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.selectDataStreamsAndIndicesLabel",defaultMessage:"Select data streams and indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setSelectIndicesMode("custom");updateRestoreSettings({indices:restoreIndexPatterns.join(",")})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.indicesToggleCustomLink",defaultMessage:"Use index patterns"})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.indicesPatternLabel",defaultMessage:"Index patterns"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setSelectIndicesMode("list");updateRestoreSettings({indices:cachedRestoreSettings.indices})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.dataStreamsAndIndicesToggleListLink",defaultMessage:"Select data streams and indices"})))),helpText:selectIndicesMode==="list"?external_kbnSharedDeps_React_default.a.createElement(DataStreamsAndIndicesListHelpText,{onSelectionChange:selection=>{if(selection==="all"){indicesAndDataStreamsOptions.forEach(option=>{option.checked="on"});updateRestoreSettings({indices:[...snapshotIndicesAndDataStreams]});setCachedRestoreSettings({...cachedRestoreSettings,indices:[...snapshotIndicesAndDataStreams]})}else{indicesAndDataStreamsOptions.forEach(option=>{option.checked=undefined});updateRestoreSettings({indices:[]});setCachedRestoreSettings({...cachedRestoreSettings,indices:[]})}},selectedIndicesAndDataStreams:(_csvToArray=csvToArray(restoreIndices))!==null&&_csvToArray!==void 0?_csvToArray:[],indices:snapshotIndices,dataStreams:snapshotDataStreams}):null,isInvalid:Boolean(errors.indices),error:errors.indices},selectIndicesMode==="list"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],{allowExclusions:false,options:indicesAndDataStreamsOptions,onChange:options=>{const newSelectedIndices=[];options.forEach(({label:label,checked:checked})=>{if(checked==="on"){newSelectedIndices.push(label)}});setIndicesAndDataStreamsOptions(options);updateRestoreSettings({indices:[...newSelectedIndices]});setCachedRestoreSettings({...cachedRestoreSettings,indices:[...newSelectedIndices]})},searchable:true,height:300},(list,search)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"s",hasShadow:false},search,list)):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{options:comboBoxOptions,renderOption:({value:value})=>value!==null&&value!==void 0&&value.isDataStream?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,justifyContent:"spaceBetween",alignItems:"center",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,value.name),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(DataStreamBadge,null))):value===null||value===void 0?void 0:value.name,placeholder:i18n.translate("xpack.snapshotRestore.restoreForm.stepLogistics.indicesPatternPlaceholder",{defaultMessage:"Enter index patterns, i.e. logstash-*"}),selectedOptions:restoreIndexPatterns.map(pattern=>({label:pattern})),onCreateOption:pattern=>{if(!pattern.trim().length){return}const newPatterns=[...restoreIndexPatterns,pattern];setRestoreIndexPatterns(newPatterns);updateRestoreSettings({indices:newPatterns.join(",")})},onChange:patterns=>{const newPatterns=patterns.map(({label:label})=>label);setRestoreIndexPatterns(newPatterns);updateRestoreSettings({indices:newPatterns.join(",")})}})))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesTitle",defaultMessage:"Rename data streams and indices"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesDescription",defaultMessage:"Renames data streams and indices on restore. Ensure that a matching index template exists for renamed data streams."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.renameDataStreamsAndIndicesLabel",defaultMessage:"Rename data streams and indices"}),checked:isRenamingIndices,onChange:e=>{const isChecked=e.target.checked;setIsRenamingIndices(isChecked);if(isChecked){updateRestoreSettings({renamePattern:cachedRestoreSettings.renamePattern,renameReplacement:cachedRestoreSettings.renameReplacement})}else{updateRestoreSettings({renamePattern:undefined,renameReplacement:undefined})}}}),!isRenamingIndices?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.renamePatternLabel",defaultMessage:"Capture pattern"}),helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.renamePatternHelpText",defaultMessage:"Use regular expressions"}),isInvalid:Boolean(errors.renamePattern),error:errors.renamePattern},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{value:renamePattern,placeholder:"data_(.+)",onChange:e=>{setCachedRestoreSettings({...cachedRestoreSettings,renamePattern:e.target.value});updateRestoreSettings({renamePattern:e.target.value})}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.renameReplacementLabel",defaultMessage:"Replacement pattern"}),isInvalid:Boolean(errors.renameReplacement),error:errors.renameReplacement},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{value:renameReplacement,placeholder:"restored_data_$1",onChange:e=>{setCachedRestoreSettings({...cachedRestoreSettings,renameReplacement:e.target.value});updateRestoreSettings({renameReplacement:e.target.value})}})))))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.partialTitle",defaultMessage:"Partial restore"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.partialDescription",defaultMessage:"Allows restore of indices that don’t have snapshots of all shards."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.partialLabel",defaultMessage:"Partial restore"}),checked:partial===undefined?false:partial,onChange:e=>updateRestoreSettings({partial:e.target.checked})}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateTitle",defaultMessage:"Restore global state"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateDescription",defaultMessage:"Restores templates that don’t currently exist in the cluster and overrides templates with the same name. Also restores persistent settings."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true,helpText:snapshotIncludeGlobalState?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateDisabledDescription",defaultMessage:"Not available for this snapshot."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepLogistics.includeGlobalStateLabel",defaultMessage:"Restore global state"}),checked:includeGlobalState===undefined?false:includeGlobalState,onChange:e=>updateRestoreSettings({includeGlobalState:e.target.checked}),disabled:!snapshotIncludeGlobalState}))))};const RestoreSnapshotStepSettings=({restoreSettings:restoreSettings,updateRestoreSettings:updateRestoreSettings,snapshotDetails:snapshotDetails,errors:errors})=>{const{i18n:i18n}=useServices();const{indexSettings:indexSettings,ignoreIndexSettings:ignoreIndexSettings}=restoreSettings;const{dataStreams:dataStreams}=snapshotDetails;const[isUsingIndexSettings,setIsUsingIndexSettings]=Object(external_kbnSharedDeps_React_["useState"])(Boolean(indexSettings));const[isUsingIgnoreIndexSettings,setIsUsingIgnoreIndexSettings]=Object(external_kbnSharedDeps_React_["useState"])(Boolean(ignoreIndexSettings));const[cachedRestoreSettings,setCachedRestoreSettings]=Object(external_kbnSharedDeps_React_["useState"])({indexSettings:indexSettings||"{}",ignoreIndexSettings:ignoreIndexSettings?[...ignoreIndexSettings]:[]});const[ignoreIndexSettingsOptions,setIgnoreIndexSettingsOptions]=Object(external_kbnSharedDeps_React_["useState"])([...new Set((ignoreIndexSettings||[]).concat([...application_constants["g"]].sort()))].map(setting=>({label:setting})));const indexSettingsDocLink=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getIndexSettingsUrl(),target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsDocLinkText",defaultMessage:"Learn more."}));return external_kbnSharedDeps_React_default.a.createElement("div",{className:"snapshotRestore__restoreForm__stepSettings"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettingsTitle",defaultMessage:"Index settings"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getRestoreIndexSettingsUrl(),target:"_blank",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.docsButtonLabel",defaultMessage:"Index settings docs"})))),dataStreams!==null&&dataStreams!==void 0&&dataStreams.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{iconType:"help",title:i18n.translate("xpack.snapshotRestore.restoreForm.stepSettings.dataStreamsCallout.title",{defaultMessage:"Backing indices"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.dataStreamsCallout.description",defaultMessage:"These settings also apply to the backing indices of data streams."}))):undefined,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsTitle",defaultMessage:"Modify index settings"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsDescription",defaultMessage:"Overrides index settings during restore. {docLink}",values:{docLink:indexSettingsDocLink}}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{"data-test-subj":"modifyIndexSettingsSwitch",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsLabel",defaultMessage:"Modify index settings"}),checked:isUsingIndexSettings,onChange:e=>{const isChecked=e.target.checked;if(isChecked){setIsUsingIndexSettings(true);updateRestoreSettings({indexSettings:cachedRestoreSettings.indexSettings})}else{setIsUsingIndexSettings(false);updateRestoreSettings({indexSettings:undefined})}}}),!isUsingIndexSettings?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsEditorLabel",defaultMessage:"Index settings"}),fullWidth:true,isInvalid:Boolean(errors.indexSettings),error:errors.indexSettings,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsEditorDescription",defaultMessage:"Use JSON format: {format}",values:{format:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,'{ "index.number_of_replicas": 0 }')}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{mode:"json",theme:"textmate",width:"100%",value:indexSettings,setOptions:{showLineNumbers:false,tabSize:2,maxLines:Infinity},editorProps:{$blockScrolling:Infinity},showGutter:false,minLines:6,maxLines:15,"aria-label":i18n.translate("xpack.snapshotRestore.restoreForm.stepSettings.indexSettingsAriaLabel",{defaultMessage:"Index settings to modify"}),onChange:value=>{updateRestoreSettings({indexSettings:value});setCachedRestoreSettings({...cachedRestoreSettings,indexSettings:value})}})))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsTitle",defaultMessage:"Reset index settings"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsDescription",defaultMessage:"Resets selected settings to default during restore. {docLink}",values:{docLink:indexSettingsDocLink}}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsLabel",defaultMessage:"Reset index settings"}),checked:isUsingIgnoreIndexSettings,onChange:e=>{const isChecked=e.target.checked;if(isChecked){setIsUsingIgnoreIndexSettings(true);updateRestoreSettings({ignoreIndexSettings:[...cachedRestoreSettings.ignoreIndexSettings||[]]})}else{setIsUsingIgnoreIndexSettings(false);updateRestoreSettings({ignoreIndexSettings:undefined})}}}),!isUsingIgnoreIndexSettings?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepSettings.selectIgnoreIndexSettingsLabel",defaultMessage:"Select settings"}),isInvalid:Boolean(errors.ignoreIndexSettings),error:errors.ignoreIndexSettings},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:i18n.translate("xpack.snapshotRestore.restoreForm.stepSettings.ignoreIndexSettingsPlaceholder",{defaultMessage:"Select or type index settings"}),options:ignoreIndexSettingsOptions,selectedOptions:ignoreIndexSettings?ignoreIndexSettingsOptions.filter(({label:label})=>ignoreIndexSettings.includes(label)):[],onChange:selectedOptions=>{const newIgnoreIndexSettings=selectedOptions.map(({label:label})=>label);updateRestoreSettings({ignoreIndexSettings:newIgnoreIndexSettings});setCachedRestoreSettings({...cachedRestoreSettings,ignoreIndexSettings:newIgnoreIndexSettings})},onCreateOption:(newIndexSetting,flattenedOptions)=>{const normalizedSettingName=newIndexSetting.trim().toLowerCase();if(!normalizedSettingName){return}const isCustomSetting=!Boolean(flattenedOptions.find(({label:label})=>label===normalizedSettingName));if(isCustomSetting){setIgnoreIndexSettingsOptions([{label:normalizedSettingName},...ignoreIndexSettingsOptions])}updateRestoreSettings({ignoreIndexSettings:[...ignoreIndexSettings||[],normalizedSettingName]});setCachedRestoreSettings({...cachedRestoreSettings,ignoreIndexSettings:[...ignoreIndexSettings||[],normalizedSettingName]})},isClearable:true})))))))};const maximumItemPreviewCount=10;const useCollapsibleList=({items:items})=>{var _csvToArray;const[isShowingFullList,setIsShowingFullList]=Object(external_kbnSharedDeps_React_["useState"])(false);const itemsArray=(_csvToArray=csvToArray(items))!==null&&_csvToArray!==void 0?_csvToArray:[];const displayItems=items===undefined?"all":itemsArray.slice(0,isShowingFullList?Infinity:maximumItemPreviewCount);const hiddenItemsCount=itemsArray.length>maximumItemPreviewCount?itemsArray.length-maximumItemPreviewCount:0;return{items:displayItems,hiddenItemsCount:hiddenItemsCount,setIsShowingFullList:setIsShowingFullList,isShowingFullList:isShowingFullList}};const CollapsibleIndicesList=({indices:indices})=>{const{hiddenItemsCount:hiddenItemsCount,isShowingFullList:isShowingFullList,items:items,setIsShowingFullList:setIsShowingFullList}=useCollapsibleList({items:indices});return items==="all"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.indicesList.allIndicesValue",defaultMessage:"All indices"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("ul",null,items.map(index=>external_kbnSharedDeps_React_default.a.createElement("li",{key:index},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("span",null,index)))))),hiddenItemsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>isShowingFullList?setIsShowingFullList(false):setIsShowingFullList(true)},isShowingFullList?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.indicesList.indicesCollapseAllLink",defaultMessage:"Hide {count, plural, one {# index} other {# indices}}",values:{count:hiddenItemsCount}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.indicesList.indicesExpandAllLink",defaultMessage:"Show {count, plural, one {# index} other {# indices}}",values:{count:hiddenItemsCount}})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:isShowingFullList?"arrowUp":"arrowDown"}))):null)};const RestoreSnapshotStepReview=({restoreSettings:restoreSettings,updateCurrentStep:updateCurrentStep})=>{const{i18n:i18n}=useServices();const{indices:restoreIndices,renamePattern:renamePattern,renameReplacement:renameReplacement,partial:partial,includeGlobalState:includeGlobalState,ignoreIndexSettings:ignoreIndexSettings}=restoreSettings;const serializedRestoreSettings=serializeRestoreSettings(restoreSettings);const{index_settings:serializedIndexSettings}=serializedRestoreSettings;const renderSummaryTab=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.sectionLogisticsTitle",defaultMessage:"Logistics"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.editStepTooltip",defaultMessage:"Edit"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>updateCurrentStep(1)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"pencil"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.dataStreamsAndIndicesLabel",defaultMessage:"Data streams and indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(CollapsibleIndicesList,{indices:restoreIndices}))))),renamePattern||renameReplacement?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.sectionRenameTitle",defaultMessage:"Rename indices"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,renamePattern?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.renamePatternLabel",defaultMessage:"Capture pattern"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,renamePattern))):null,renameReplacement?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.renameReplacementLabel",defaultMessage:"Replacement pattern"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,renameReplacement))):null)):null,partial!==undefined||includeGlobalState!==undefined?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,partial!==undefined?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.partialLabel",defaultMessage:"Partial restore"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,partial?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.partialTrueValue",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.partialFalseValue",defaultMessage:"No"})))):null,includeGlobalState!==undefined?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.includeGlobalStateLabel",defaultMessage:"Restore global state"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,includeGlobalState?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.includeGlobalStateTrueValue",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.includeGlobalStateFalseValue",defaultMessage:"No"})))):null):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.sectionSettingsTitle",defaultMessage:"Index settings"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.editStepTooltip",defaultMessage:"Edit"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>updateCurrentStep(2)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"pencil"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),serializedIndexSettings||ignoreIndexSettings?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,serializedIndexSettings?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{maxWidth:"50%"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.indexSettingsLabel",defaultMessage:"Modify"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2,gutterSize:"none"},Object.entries(serializedIndexSettings).map(([setting,value])=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:setting},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("strong",null,setting))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("span",null," ",value))))))))):null,ignoreIndexSettings?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.ignoreIndexSettingsLabel",defaultMessage:"Reset"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("ul",null,ignoreIndexSettings.map(setting=>external_kbnSharedDeps_React_default.a.createElement("li",{key:setting},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("span",null,setting))))))))):null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReview.summaryTab.noSettingsValue",defaultMessage:"No index setting modifications"}));const renderJsonTab=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{mode:"json",theme:"textmate",isReadOnly:true,setOptions:{maxLines:Infinity},value:JSON.stringify(serializedRestoreSettings,null,2),editorProps:{$blockScrolling:Infinity},"aria-label":i18n.translate("xpack.snapshotRestore.restoreForm.stepReview.jsonTab.jsonAriaLabel",{defaultMessage:"Restore settings to be executed"})}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.stepReviewTitle",defaultMessage:"Review restore details"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabbedContent"],{tabs:[{id:"summary",name:i18n.translate("xpack.snapshotRestore.restoreForm.stepReview.summaryTabTitle",{defaultMessage:"Summary"}),content:renderSummaryTab()},{id:"json",name:i18n.translate("xpack.snapshotRestore.restoreForm.stepReview.jsonTabTitle",{defaultMessage:"JSON"}),content:renderJsonTab()}]}))};const RestoreSnapshotNavigation=({currentStep:currentStep,maxCompletedStep:maxCompletedStep,updateCurrentStep:updateCurrentStep})=>{const{i18n:i18n}=useServices();const steps=[{title:i18n.translate("xpack.snapshotRestore.restoreForm.navigation.stepLogisticsName",{defaultMessage:"Logistics"}),isComplete:maxCompletedStep>=1,isSelected:currentStep===1,onClick:()=>updateCurrentStep(1)},{title:i18n.translate("xpack.snapshotRestore.restoreForm.navigation.stepSettingsName",{defaultMessage:"Index settings"}),isComplete:maxCompletedStep>=2,isSelected:currentStep===2,disabled:maxCompletedStep<1,onClick:()=>updateCurrentStep(2)},{title:i18n.translate("xpack.snapshotRestore.restoreForm.navigation.stepReviewName",{defaultMessage:"Review"}),isComplete:maxCompletedStep>=2,isSelected:currentStep===3,disabled:maxCompletedStep<2,onClick:()=>updateCurrentStep(3)}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStepsHorizontal"],{steps:steps})};const RestoreSnapshotForm=({snapshotDetails:snapshotDetails,isSaving:isSaving,saveError:saveError,clearSaveError:clearSaveError,onSave:onSave})=>{const[currentStep,setCurrentStep]=Object(external_kbnSharedDeps_React_["useState"])(1);const[maxCompletedStep,setMaxCompletedStep]=Object(external_kbnSharedDeps_React_["useState"])(0);const stepMap={1:RestoreSnapshotStepLogistics,2:RestoreSnapshotStepSettings,3:RestoreSnapshotStepReview};const CurrentStepForm=stepMap[currentStep];const[restoreSettings,setRestoreSettings]=Object(external_kbnSharedDeps_React_["useState"])({});const[validation,setValidation]=Object(external_kbnSharedDeps_React_["useState"])({isValid:true,errors:{}});const updateRestoreSettings=updatedSettings=>{const newRestoreSettings={...restoreSettings,...updatedSettings};const newValidation=validateRestore(newRestoreSettings);setRestoreSettings(newRestoreSettings);setValidation(newValidation)};const updateCurrentStep=step=>{if(maxCompletedStep<step-1){return}setCurrentStep(step);setMaxCompletedStep(step-1);clearSaveError()};const onBack=()=>{const previousStep=currentStep-1;setCurrentStep(previousStep);setMaxCompletedStep(previousStep-1);clearSaveError()};const onNext=()=>{if(!validation.isValid){return}const nextStep=currentStep+1;setMaxCompletedStep(Math.max(currentStep,maxCompletedStep));setCurrentStep(nextStep)};const executeRestore=()=>{if(validation.isValid){onSave(restoreSettings)}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(RestoreSnapshotNavigation,{currentStep:currentStep,maxCompletedStep:maxCompletedStep,updateCurrentStep:updateCurrentStep}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{"data-test-subj":"restoreSnapshotsForm"},external_kbnSharedDeps_React_default.a.createElement(CurrentStepForm,{snapshotDetails:snapshotDetails,restoreSettings:restoreSettings,updateRestoreSettings:updateRestoreSettings,errors:validation.errors,updateCurrentStep:updateCurrentStep}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),saveError?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,saveError,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,currentStep>1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"arrowLeft",onClick:()=>onBack(),disabled:!validation.isValid,"data-test-subj":"backButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.backButtonLabel",defaultMessage:"Back"}))):null,currentStep<3?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"arrowRight",onClick:()=>onNext(),disabled:!validation.isValid,"data-test-subj":"nextButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.nextButtonLabel",defaultMessage:"Next"}))):null,currentStep===3?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,color:"secondary",iconType:"check",onClick:()=>executeRestore(),isLoading:isSaving},isSaving?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.savingButtonLabel",defaultMessage:"Restoring…"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreForm.submitButtonLabel",defaultMessage:"Restore snapshot"}))):null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};const PolicyExecuteProvider=({children:children})=>{const{i18n:i18n}=useServices();const toastNotifications=useToastNotifications();const[policyName,setPolicyName]=Object(external_kbnSharedDeps_React_["useState"])("");const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const executePolicyPrompt=(name,onSuccess=(()=>undefined))=>{if(!name||!name.length){throw new Error("No policy name specified for execution")}setIsModalOpen(true);setPolicyName(name);onSuccessCallback.current=onSuccess};const closeModal=()=>{setIsModalOpen(false);setPolicyName("")};const executePolicy=()=>{Object(services_http["i"])(policyName).then(({data:data,error:error})=>{const{snapshotName:snapshotName}=data||{snapshotName:undefined};if(snapshotName){const successMessage=i18n.translate("xpack.snapshotRestore.executePolicy.successNotificationTitle",{defaultMessage:"Policy '{name}' is running",values:{name:policyName}});toastNotifications.addSuccess(successMessage);if(onSuccessCallback.current){onSuccessCallback.current()}}if(error){const errorMessage=i18n.translate("xpack.snapshotRestore.executePolicy.errorNotificationTitle",{defaultMessage:"Error running policy '{name}'",values:{name:policyName}});toastNotifications.addDanger(errorMessage)}});closeModal()};const renderModal=()=>{if(!isModalOpen){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.executePolicy.confirmModal.executePolicyTitle",defaultMessage:"Run '{name}' now?",values:{name:policyName}}),onCancel:closeModal,onConfirm:executePolicy,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.executePolicy.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.executePolicy.confirmModal.confirmButtonLabel",defaultMessage:"Run policy"}),"data-test-subj":"srExecutePolicyConfirmationModal"})};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(executePolicyPrompt),renderModal())};const PolicyDeleteProvider=({children:children})=>{const{i18n:i18n}=useServices();const toastNotifications=useToastNotifications();const[policyNames,setPolicyNames]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const deletePolicyPrompt=(names,onSuccess=(()=>undefined))=>{if(!names||!names.length){throw new Error("No policy names specified for deletion")}setIsModalOpen(true);setPolicyNames(names);onSuccessCallback.current=onSuccess};const closeModal=()=>{setIsModalOpen(false);setPolicyNames([])};const deletePolicy=()=>{const policiesToDelete=[...policyNames];Object(services_http["d"])(policiesToDelete).then(({data:data,error:error})=>{const{itemsDeleted:itemsDeleted,errors:errors}=data||{itemsDeleted:undefined,errors:undefined};if(itemsDeleted&&itemsDeleted.length){const hasMultipleSuccesses=itemsDeleted.length>1;const successMessage=hasMultipleSuccesses?i18n.translate("xpack.snapshotRestore.deletePolicy.successMultipleNotificationTitle",{defaultMessage:"Deleted {count} policies",values:{count:itemsDeleted.length}}):i18n.translate("xpack.snapshotRestore.deletePolicy.successSingleNotificationTitle",{defaultMessage:"Deleted policy '{name}'",values:{name:itemsDeleted[0]}});toastNotifications.addSuccess(successMessage);if(onSuccessCallback.current){onSuccessCallback.current([...itemsDeleted])}}if(error||errors&&errors.length){const hasMultipleErrors=errors&&errors.length>1||error&&policiesToDelete.length>1;const errorMessage=hasMultipleErrors?i18n.translate("xpack.snapshotRestore.deletePolicy.errorMultipleNotificationTitle",{defaultMessage:"Error deleting {count} policies",values:{count:errors&&errors.length||policiesToDelete.length}}):i18n.translate("xpack.snapshotRestore.deletePolicy.errorSingleNotificationTitle",{defaultMessage:"Error deleting policy '{name}'",values:{name:errors&&errors[0].name||policiesToDelete[0]}});toastNotifications.addDanger(errorMessage)}});closeModal()};const renderModal=()=>{if(!isModalOpen){return null}const isSingle=policyNames.length===1;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deletePolicy.confirmModal.deleteSingleTitle",defaultMessage:"Delete policy '{name}'?",values:{name:policyNames[0]}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deletePolicy.confirmModal.deleteMultipleTitle",defaultMessage:"Delete {count} policies?",values:{count:policyNames.length}}),onCancel:closeModal,onConfirm:deletePolicy,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deletePolicy.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deletePolicy.confirmModal.confirmButtonLabel",defaultMessage:"Delete {count, plural, one {policy} other {policies}}",values:{count:policyNames.length}}),buttonColor:"danger","data-test-subj":"srdeletePolicyConfirmationModal"},!isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.deletePolicy.confirmModal.deleteMultipleListDescription",defaultMessage:"You are about to delete these policies:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,policyNames.map(name=>external_kbnSharedDeps_React_default.a.createElement("li",{key:name},name)))):null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(deletePolicyPrompt),renderModal())};const CollapsibleDataStreamsList=({dataStreams:dataStreams})=>{const{isShowingFullList:isShowingFullList,setIsShowingFullList:setIsShowingFullList,items:items,hiddenItemsCount:hiddenItemsCount}=useCollapsibleList({items:dataStreams});return items==="all"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.dataStreamsList.allDataStreamsValue",defaultMessage:"All data streams"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("ul",null,items.map(dataStream=>external_kbnSharedDeps_React_default.a.createElement("li",{key:dataStream},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("span",null,dataStream)))))),hiddenItemsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>isShowingFullList?setIsShowingFullList(false):setIsShowingFullList(true)},isShowingFullList?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.dataStreamsList.dataStreamsCollapseAllLink",defaultMessage:"Hide {count, plural, one {# data stream} other {# data streams}}",values:{count:hiddenItemsCount}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.dataStreamsList.dataStreamsExpandAllLink",defaultMessage:"Show {count, plural, one {# data stream} other {# data streams}}",values:{count:hiddenItemsCount}})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:isShowingFullList?"arrowUp":"arrowDown"}))):null)};const RetentionSettingsUpdateModalProvider=({children:children})=>{const{i18n:i18n}=useServices();const toastNotifications=useToastNotifications();const[retentionSchedule,setRetentionSchedule]=Object(external_kbnSharedDeps_React_["useState"])(application_constants["e"]);const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isEditing,setIsEditing]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[saveError,setSaveError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[isAdvancedCronVisible,setIsAdvancedCronVisible]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const[simpleCron,setSimpleCron]=Object(external_kbnSharedDeps_React_["useState"])({expression:application_constants["e"],frequency:application_constants["d"]});const[fieldToPreferredValueMap,setFieldToPreferredValueMap]=Object(external_kbnSharedDeps_React_["useState"])({});const[isInvalid,setIsInvalid]=Object(external_kbnSharedDeps_React_["useState"])(false);const updateRetentionPrompt=(originalRetentionSchedule,onSuccess=(()=>undefined))=>{setIsModalOpen(true);setIsAdvancedCronVisible(Boolean(originalRetentionSchedule&&originalRetentionSchedule!==application_constants["e"]));if(originalRetentionSchedule){setIsEditing(true);setRetentionSchedule(originalRetentionSchedule)}onSuccessCallback.current=onSuccess};const closeModal=()=>{setIsModalOpen(false)};const updateRetentionSetting=async()=>{if(!retentionSchedule){setIsInvalid(true);return}setIsSaving(true);setSaveError(null);const{error:error}=await Object(services_http["n"])(retentionSchedule);setIsSaving(false);if(error){setSaveError(error)}else{closeModal();toastNotifications.addSuccess(i18n.translate("xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionSuccessMessage",{defaultMessage:"Retention schedule updated"}));if(onSuccessCallback.current){onSuccessCallback.current()}}};const renderModal=()=>{if(!isModalOpen){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:closeModal},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,isEditing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionEditTitle",defaultMessage:"Edit retention schedule"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionAddTitle",defaultMessage:"Add retention schedule"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,saveError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionErrorTitle",defaultMessage:"Error saving retention schedule"}),color:"danger",iconType:"alert"},saveError.data&&saveError.data.message?external_kbnSharedDeps_React_default.a.createElement("p",null,saveError.data.message):null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})),isAdvancedCronVisible?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionScheduleLabel",defaultMessage:"Retention schedule"}),isInvalid:isInvalid,error:i18n.translate("xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionScheduleFieldErrorMessage",{defaultMessage:"Retention schedule is required."}),helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionHelpText",defaultMessage:"Use cron expression. {docLink}",values:{docLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getCronUrl(),target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionHelpTextDocLinkText",defaultMessage:"Learn more."}))}}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:retentionSchedule,fullWidth:true,onChange:e=>setRetentionSchedule(e.target.value)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setIsAdvancedCronVisible(false);setRetentionSchedule(simpleCron.expression)},"data-test-subj":"showBasicCronLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionBasicLabel",defaultMessage:"Create basic interval"})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(shared_imports["b"],{fieldToPreferredValueMap:fieldToPreferredValueMap,cronExpression:simpleCron.expression,frequency:simpleCron.frequency,onChange:({cronExpression:expression,frequency:frequency,fieldToPreferredValueMap:newFieldToPreferredValueMap})=>{setSimpleCron({expression:expression,frequency:frequency});setFieldToPreferredValueMap(newFieldToPreferredValueMap);setRetentionSchedule(expression)}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setIsAdvancedCronVisible(true)},"data-test-subj":"showAdvancedCronLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionAdvancedLabel",defaultMessage:"Create cron expression"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:closeModal},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionCancelButtonLabel",defaultMessage:"Cancel"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:updateRetentionSetting,fill:true,isLoading:isSaving},isEditing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionEditButtonLabel",defaultMessage:"Save changes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.policyUpdateRetentionSaveButtonLabel",defaultMessage:"Schedule"}))))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(updateRetentionPrompt),renderModal())};const RetentionExecuteModalProvider=({children:children})=>{const{i18n:i18n}=useServices();const toastNotifications=useToastNotifications();const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const executeRetentionPrompt=()=>{setIsModalOpen(true)};const closeModal=()=>{setIsModalOpen(false)};const executeRetention=()=>{Object(services_http["k"])().then(({error:error})=>{if(error){const errorMessage=i18n.translate("xpack.snapshotRestore.executeRetention.errorMessage",{defaultMessage:"Error running retention"});toastNotifications.addDanger(errorMessage)}else{const successMessage=i18n.translate("xpack.snapshotRestore.executeRetention.successMessage",{defaultMessage:"Retention is running"});toastNotifications.addSuccess(successMessage)}});closeModal()};const renderModal=()=>{if(!isModalOpen){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.executeRetention.confirmModal.executeRetentionTitle",defaultMessage:"Run snapshot retention now?"}),onCancel:closeModal,onConfirm:executeRetention,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.executeRetention.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.executeRetention.confirmModal.confirmButtonLabel",defaultMessage:"Run retention"}),"data-test-subj":"executeRetentionModal"})};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,children(executeRetentionPrompt),renderModal())};var public_=__webpack_require__(26);function step_logistics_extends(){step_logistics_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return step_logistics_extends.apply(this,arguments)}const PolicyStepLogistics=({policy:policy,updatePolicy:updatePolicy,isEditing:isEditing,currentUrl:currentUrl,errors:errors})=>{const{error:errorLoadingRepositories,isLoading:isLoadingRepositories,data:{repositories:repositories,managedRepository:managedRepository}={repositories:[],managedRepository:{name:undefined}},resendRequest:reloadRepositories}=Object(services_http["r"])();const{i18n:i18n,history:history}=useServices();const[showRepositoryNotFoundWarning,setShowRepositoryNotFoundWarning]=Object(external_kbnSharedDeps_React_["useState"])(false);const[touched,setTouched]=Object(external_kbnSharedDeps_React_["useState"])({name:false,snapshotName:false,repository:false,schedule:false});const[simpleCron,setSimpleCron]=Object(external_kbnSharedDeps_React_["useState"])({expression:application_constants["c"],frequency:application_constants["b"]});const[isAdvancedCronVisible,setIsAdvancedCronVisible]=Object(external_kbnSharedDeps_React_["useState"])(Boolean(policy.schedule&&policy.schedule!==application_constants["c"]));const[fieldToPreferredValueMap,setFieldToPreferredValueMap]=Object(external_kbnSharedDeps_React_["useState"])({});const renderNameField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.nameDescriptionTitle",defaultMessage:"Policy name"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.nameDescription",defaultMessage:"A unique identifier for this policy."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.nameLabel",defaultMessage:"Name"}),isInvalid:touched.name&&Boolean(errors.name),error:errors.name,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:policy.name,fullWidth:true,onBlur:()=>setTouched({...touched,name:true}),onChange:e=>{updatePolicy({name:e.target.value},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})},placeholder:i18n.translate("xpack.snapshotRestore.policyForm.stepLogistics.namePlaceholder",{defaultMessage:"daily-snapshots",description:"Example SLM policy name. Similar to index names, do not use spaces in translation."}),"data-test-subj":"nameInput",disabled:isEditing})));const renderRepositoryField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.repositoryDescriptionTitle",defaultMessage:"Repository"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.repositoryDescription",defaultMessage:"The repository where you want to store the snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policyRepositoryLabel",defaultMessage:"Repository"}),isInvalid:touched.repository&&Boolean(errors.repository),error:errors.repository,fullWidth:true},renderRepositorySelect()));const renderRepositorySelect=()=>{if(isLoadingRepositories){return external_kbnSharedDeps_React_default.a.createElement(SectionLoading,{inline:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.loadingRepositoriesDescription",defaultMessage:"Loading repositories…"}))}if(errorLoadingRepositories){return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.loadingRepositoriesErrorMessage",defaultMessage:"Error loading repositories"}),error:errorLoadingRepositories,actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>reloadRepositories(),color:"danger",iconType:"refresh","data-test-subj":"reloadRepositoriesButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.reloadRepositoriesButtonLabel",defaultMessage:"Reload repositories"}))})}if(repositories.length===0){return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.noRepositoriesErrorTitle",defaultMessage:"You don't have any repositories"}),error:{error:i18n.translate("xpack.snapshotRestore.policyForm.noRepositoriesErrorMessage",{defaultMessage:"You must register a repository to store your snapshots."})},actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],step_logistics_extends({},Object(public_["reactRouterNavigate"])(history,linkToAddRepository(currentUrl)),{color:"danger",iconType:"plusInCircle","data-test-subj":"addRepositoryButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.addRepositoryButtonLabel",defaultMessage:"Register a repository"}))})}else{if(!policy.repository){updatePolicy({repository:repositories[0].name},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})}}const doesRepositoryExist=!!policy.repository&&repositories.some(r=>r.name===policy.repository);if(!doesRepositoryExist&&!errors.repository){updatePolicy(policy,{repositoryDoesNotExist:true})}if(showRepositoryNotFoundWarning!==!doesRepositoryExist){setShowRepositoryNotFoundWarning(!doesRepositoryExist)}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:repositories.map(({name:name})=>({value:name,text:name})),hasNoInitialSelection:!doesRepositoryExist,value:!doesRepositoryExist?"":policy.repository,onBlur:()=>setTouched({...touched,repository:true}),onChange:e=>{updatePolicy({repository:e.target.value},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})},fullWidth:true,"data-test-subj":"repositorySelect"})};const renderSnapshotNameField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.snapshotNameDescriptionTitle",defaultMessage:"Snapshot name"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.snapshotNameDescription",defaultMessage:"The name for the snapshots. A unique identifier is automatically added to each name."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameLabel",defaultMessage:"Snapshot name"}),isInvalid:touched.snapshotName&&Boolean(errors.snapshotName),error:errors.snapshotName,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameHelpText",defaultMessage:"Supports date math expressions. {docLink}",values:{docLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getDateMathIndexNamesUrl(),target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNameHelpTextDocLink",defaultMessage:"Learn more."}))}}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:policy.snapshotName,fullWidth:true,onChange:e=>{updatePolicy({snapshotName:e.target.value},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})},onBlur:()=>setTouched({...touched,snapshotName:true}),placeholder:i18n.translate("xpack.snapshotRestore.policyForm.stepLogistics.policySnapshotNamePlaceholder",{defaultMessage:"<daily-snap-\\{now/d\\}>",description:"Example date math snapshot name. Keeping the same syntax is important: <SOME-TRANSLATION-{now/d}>"}),"data-test-subj":"snapshotNameInput"})));const renderScheduleField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.scheduleDescriptionTitle",defaultMessage:"Schedule"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.scheduleDescription",defaultMessage:"The frequency at which to take the snapshots."}),fullWidth:true},isAdvancedCronVisible?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleLabel",defaultMessage:"Schedule"}),isInvalid:touched.schedule&&Boolean(errors.schedule),error:errors.schedule,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleHelpText",defaultMessage:"Use cron expression. {docLink}",values:{docLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getCronUrl(),target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleHelpTextDocLink",defaultMessage:"Learn more."}))}}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{defaultValue:policy.schedule,fullWidth:true,onChange:e=>{updatePolicy({schedule:e.target.value},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})},onBlur:()=>setTouched({...touched,schedule:true}),placeholder:application_constants["c"],"data-test-subj":"advancedCronInput"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setIsAdvancedCronVisible(false);updatePolicy({schedule:simpleCron.expression},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})},"data-test-subj":"showBasicCronLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleButtonBasicLabel",defaultMessage:"Create basic interval"})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(shared_imports["b"],{frequencyBlockList:["MINUTE"],fieldToPreferredValueMap:fieldToPreferredValueMap,cronExpression:simpleCron.expression,frequency:simpleCron.frequency,onChange:({cronExpression:expression,frequency:frequency,fieldToPreferredValueMap:newFieldToPreferredValueMap})=>{setSimpleCron({expression:expression,frequency:frequency});setFieldToPreferredValueMap(newFieldToPreferredValueMap);updatePolicy({schedule:expression},{managedRepository:managedRepository,isEditing:isEditing,policyName:policy.name})}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setIsAdvancedCronVisible(true)},"data-test-subj":"showAdvancedCronLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.policyScheduleButtonAdvancedLabel",defaultMessage:"Create cron expression"})))));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogisticsTitle",defaultMessage:"Logistics"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getSlmUrl(),target:"_blank",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.docsButtonLabel",defaultMessage:"Logistics docs"})))),showRepositoryNotFoundWarning&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{"data-test-subj":"repositoryNotFoundWarning",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.selectRepository.policyRepositoryNotFoundTitle",defaultMessage:"Repository not found"}),color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepLogistics.selectRepository.policyRepositoryNotFoundDescription",defaultMessage:"Repository {repo} does not exist. Please select an existing repository.",values:{repo:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,policy.repository)}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),renderNameField(),renderSnapshotNameField(),renderRepositoryField(),renderScheduleField())};const mapSelectionToIndicesOptions=({allSelected:allSelected,selection:selection,dataStreams:dataStreams,indices:indices})=>orderDataStreamsAndIndices({dataStreams:dataStreams.map(dataStream=>({label:dataStream,append:external_kbnSharedDeps_React_default.a.createElement(DataStreamBadge,null),checked:allSelected||selection.includes(dataStream)?"on":undefined})),indices:indices.map(index=>({label:index,checked:allSelected||selection.includes(index)?"on":undefined}))});const determineListMode=({configuredIndices:configuredIndices,indices:indices,dataStreams:dataStreams})=>{const indicesAndDataStreams=indices.concat(dataStreams);return typeof configuredIndices==="string"||indicesAndDataStreams.length>100||Array.isArray(configuredIndices)&&!configuredIndices.every(c=>indicesAndDataStreams.some(i=>i===c))?"custom":"list"};const data_streams_and_indices_list_help_text_DataStreamsAndIndicesListHelpText=({onSelectionChange:onSelectionChange,selectedIndicesAndDataStreams:selectedIndicesAndDataStreams,indices:indices,dataStreams:dataStreams})=>{if(selectedIndicesAndDataStreams.length===0){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.noDataStreamsOrIndicesHelpText",defaultMessage:"Nothing will be backed up. {selectAllLink}",values:{selectAllLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{onSelectionChange("all")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.selectAllIndicesLink",defaultMessage:"Select all"}))}})}const indicesCount=selectedIndicesAndDataStreams.reduce((acc,v)=>indices.includes(v)?acc+1:acc,0);const dataStreamsCount=selectedIndicesAndDataStreams.reduce((acc,v)=>dataStreams.includes(v)?acc+1:acc,0);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.selectDataStreamsIndicesHelpText",defaultMessage:"{indicesCount} {indicesCount, plural, one {index} other {indices}} and {dataStreamsCount} {dataStreamsCount, plural, one {data stream} other {data streams}} will be backed up. {deselectAllLink}",values:{dataStreamsCount:dataStreamsCount,indicesCount:indicesCount,deselectAllLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"deselectIndicesLink",onClick:()=>{onSelectionChange("none")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.deselectAllIndicesLink",defaultMessage:"Deselect all"}))}})};const IndicesAndDataStreamsField=({isManagedPolicy:isManagedPolicy,dataStreams:dataStreams,indices:indices,policy:policy,onUpdate:_onUpdate,errors:errors})=>{const{i18n:i18n}=useServices();const{config:config={}}=policy;const indicesAndDataStreams=indices.concat(dataStreams);const[isAllIndices,setIsAllIndices]=Object(external_kbnSharedDeps_React_["useState"])(config.indices==null||Array.isArray(config.indices)&&config.indices.length===0);const onUpdate=data=>{_onUpdate(data,{validateIndicesCount:!isAllIndices})};const[indicesAndDataStreamsSelection,setIndicesAndDataStreamsSelection]=Object(external_kbnSharedDeps_React_["useState"])(()=>Array.isArray(config.indices)&&!isAllIndices?indicesAndDataStreams.filter(i=>config.indices.includes(i)):[...indicesAndDataStreams]);const[indicesAndDataStreamsOptions,setIndicesAndDataStreamsOptions]=Object(external_kbnSharedDeps_React_["useState"])(()=>mapSelectionToIndicesOptions({selection:indicesAndDataStreamsSelection,dataStreams:dataStreams,indices:indices,allSelected:isAllIndices||typeof config.indices==="string"}));const[selectIndicesMode,setSelectIndicesMode]=Object(external_kbnSharedDeps_React_["useState"])(()=>determineListMode({configuredIndices:config.indices,dataStreams:dataStreams,indices:indices}));const[indexPatterns,setIndexPatterns]=Object(external_kbnSharedDeps_React_["useState"])(()=>typeof config.indices==="string"?config.indices.split(","):Array.isArray(config.indices)&&config.indices?config.indices:[]);const indicesSwitch=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.allDataStreamsAndIndicesLabel",defaultMessage:"All data streams and indices, including system indices"}),checked:isAllIndices,disabled:isManagedPolicy,"data-test-subj":"allIndicesToggle",onChange:e=>{const isChecked=e.target.checked;setIsAllIndices(isChecked);if(isChecked){setIndicesAndDataStreamsSelection(indicesAndDataStreams);setIndicesAndDataStreamsOptions(mapSelectionToIndicesOptions({allSelected:isAllIndices||typeof config.indices==="string",dataStreams:dataStreams,indices:indices,selection:indicesAndDataStreamsSelection}));onUpdate({indices:undefined})}else{_onUpdate({indices:selectIndicesMode==="custom"?indexPatterns.join(","):[...indicesAndDataStreamsSelection||[]]},{validateIndicesCount:true})}}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesTitle",defaultMessage:"Data streams and indices"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesDescription",defaultMessage:"To back up indices and data streams, manually select them or define index patterns to dynamically match them."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,isManagedPolicy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"left",content:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.indicesTooltip",defaultMessage:"Cloud-managed policies require all indices."}))},indicesSwitch):indicesSwitch,isAllIndices?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{className:"snapshotRestore__policyForm__stepSettings__indicesFieldWrapper",label:selectIndicesMode==="list"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.selectIndicesLabel",defaultMessage:"Select indices and data streams"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{setSelectIndicesMode("custom");onUpdate({indices:indexPatterns.join(",")})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.indicesToggleCustomLink",defaultMessage:"Use index patterns"})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.indicesPatternLabel",defaultMessage:"Index patterns"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"selectIndicesLink",onClick:()=>{setSelectIndicesMode("list");onUpdate({indices:indicesAndDataStreamsSelection})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.dataStreamsAndIndicesToggleListLink",defaultMessage:"Select data streams and indices"})))),helpText:selectIndicesMode==="list"?external_kbnSharedDeps_React_default.a.createElement(data_streams_and_indices_list_help_text_DataStreamsAndIndicesListHelpText,{onSelectionChange:selection=>{if(selection==="all"){indicesAndDataStreamsOptions.forEach(option=>{option.checked="on"});onUpdate({indices:[...indicesAndDataStreams]});setIndicesAndDataStreamsSelection([...indicesAndDataStreams])}else{indicesAndDataStreamsOptions.forEach(option=>{option.checked=undefined});onUpdate({indices:[]});setIndicesAndDataStreamsSelection([])}},selectedIndicesAndDataStreams:indicesAndDataStreamsSelection,indices:indices,dataStreams:dataStreams}):null,isInvalid:Boolean(errors.indices),error:errors.indices},selectIndicesMode==="list"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],{allowExclusions:false,"data-test-subj":"indicesAndDataStreamsList",options:indicesAndDataStreamsOptions,onChange:options=>{const newSelectedIndices=[];options.forEach(({label:label,checked:checked})=>{if(checked==="on"){newSelectedIndices.push(label)}});setIndicesAndDataStreamsOptions(options);onUpdate({indices:newSelectedIndices});setIndicesAndDataStreamsSelection(newSelectedIndices)},searchable:true,height:300},(list,search)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"s",hasShadow:false},search,list)):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{options:orderDataStreamsAndIndices({indices:indices.map(index=>({label:index,value:{isDataStream:false}})),dataStreams:dataStreams.map(dataStream=>({label:dataStream,value:{isDataStream:true}}))}),renderOption:({label:label,value:value})=>{if(value!==null&&value!==void 0&&value.isDataStream){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},label),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(DataStreamBadge,null)))}return label},placeholder:i18n.translate("xpack.snapshotRestore.policyForm.stepSettings.indicesPatternPlaceholder",{defaultMessage:"Enter index patterns, i.e. logstash-*"}),selectedOptions:indexPatterns.map(pattern=>({label:pattern})),onCreateOption:pattern=>{if(!pattern.trim().length){return}const newPatterns=[...indexPatterns,pattern];setIndexPatterns(newPatterns);onUpdate({indices:newPatterns.join(",")})},onChange:patterns=>{const newPatterns=patterns.map(({label:label})=>label);setIndexPatterns(newPatterns);onUpdate({indices:newPatterns.join(",")})}}))))))};const PolicyStepSettings=({policy:policy,indices:indices,dataStreams:dataStreams,updatePolicy:updatePolicy,errors:errors})=>{const{config:config={},isManagedPolicy:isManagedPolicy}=policy;const updatePolicyConfig=(updatedFields,validationHelperData={})=>{const newConfig={...config,...updatedFields};updatePolicy({config:newConfig},validationHelperData)};const renderIgnoreUnavailableField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.ignoreUnavailableDescriptionTitle",defaultMessage:"Ignore unavailable indices"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.ignoreUnavailableDescription",defaultMessage:"Ignores indices that are unavailable when taking the snapshot. Otherwise, the entire snapshot will fail."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{"data-test-subj":"ignoreUnavailableIndicesToggle",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.ignoreUnavailableLabel",defaultMessage:"Ignore unavailable indices"}),checked:Boolean(config.ignoreUnavailable),onChange:e=>{updatePolicyConfig({ignoreUnavailable:e.target.checked})}})));const renderPartialField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.partialDescriptionTitle",defaultMessage:"Allow partial indices"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.partialDescription",defaultMessage:"Allows snapshots of indices with primary shards that are unavailable. Otherwise, the entire snapshot will fail."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{"data-test-subj":"partialIndicesToggle",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.partialIndicesToggleSwitch",defaultMessage:"Allow partial indices"}),checked:Boolean(config.partial),onChange:e=>{updatePolicyConfig({partial:e.target.checked})}})));const renderIncludeGlobalStateField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.includeGlobalStateDescriptionTitle",defaultMessage:"Include global state"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.includeGlobalStateDescription",defaultMessage:"Stores the global cluster state as part of the snapshot."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{hasEmptyLabelSpace:true,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{"data-test-subj":"globalStateToggle",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.policyIncludeGlobalStateLabel",defaultMessage:"Include global state"}),checked:config.includeGlobalState===undefined||config.includeGlobalState,onChange:e=>{updatePolicyConfig({includeGlobalState:e.target.checked})}})));return external_kbnSharedDeps_React_default.a.createElement("div",{className:"snapshotRestore__policyForm__stepSettings"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettingsTitle",defaultMessage:"Snapshot settings"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getSnapshotDocUrl(),target:"_blank",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepSettings.docsButtonLabel",defaultMessage:"Snapshot settings docs"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(IndicesAndDataStreamsField,{isManagedPolicy:isManagedPolicy,errors:errors,dataStreams:dataStreams,indices:indices,policy:policy,onUpdate:updatePolicyConfig}),renderIgnoreUnavailableField(),renderPartialField(),renderIncludeGlobalStateField())};const getExpirationTimeOptions=(unitSize="0")=>Object.entries(constants["g"]).map(([_key,value])=>({text:services_text["a"].getTimeUnitLabel(value,unitSize),value:value}));const PolicyStepRetention=({policy:policy,updatePolicy:updatePolicy,errors:errors})=>{const{retention:retention={}}=policy;const updatePolicyRetention=(updatedFields,validationHelperData={})=>{const newRetention={...retention,...updatedFields};updatePolicy({retention:newRetention},validationHelperData)};const[touched,setTouched]=Object(external_kbnSharedDeps_React_["useState"])({expireAfterValue:false,minCount:false,maxCount:false});const renderExpireAfterField=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.expirationTitle",defaultMessage:"Expiration"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.expirationDescription",defaultMessage:"The time to wait before deleting snapshots."}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.expireAfterLabel",defaultMessage:"Delete after"}),isInvalid:touched.expireAfterValue&&Boolean(errors.expireAfterValue),error:errors.expireAfterValue,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{value:retention.expireAfterValue||"",onBlur:()=>setTouched({...touched,expireAfterValue:true}),onChange:e=>{const value=e.target.value;updatePolicyRetention({expireAfterValue:value!==""?Number(value):value})},"data-test-subj":"expireAfterValueInput",min:0})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{value:retention.expireAfterUnit,options:getExpirationTimeOptions(retention.expireAfterValue?retention.expireAfterValue.toString():undefined),onChange:e=>{updatePolicyRetention({expireAfterUnit:e.target.value})},"data-test-subj":"expireAfterUnitSelect"})))));const renderCountFields=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.countTitle",defaultMessage:"Snapshots to retain"}))),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.countDescription",defaultMessage:"The minimum and maximum number of snapshots to store in your cluster. It should not exceed {maxNumber}.",values:{maxNumber:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"200")}}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.minCountLabel",defaultMessage:"Mininum count"}),isInvalid:touched.minCount&&Boolean(errors.minCount),error:errors.minCount,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{fullWidth:true,value:retention.minCount||"",onBlur:()=>setTouched({...touched,minCount:true}),onChange:e=>{const value=e.target.value;updatePolicyRetention({minCount:value!==""?Number(value):value})},"data-test-subj":"minCountInput",min:0}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.maxCountLabel",defaultMessage:"Maximum count"}),isInvalid:touched.maxCount&&Boolean(errors.maxCount),error:errors.maxCount,fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{fullWidth:true,value:retention.maxCount||"",onBlur:()=>setTouched({...touched,maxCount:true}),onChange:e=>{const value=e.target.value;updatePolicyRetention({maxCount:value!==""?Number(value):value})},"data-test-subj":"maxCountInput",min:0})))));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetentionTitle",defaultMessage:"Snapshot retention (optional)"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getSlmUrl(),target:"_blank",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepRetention.docsButtonLabel",defaultMessage:"Snapshot retention docs"})))),renderExpireAfterField(),renderCountFields())};const PolicyStepReview=({policy:policy,updateCurrentStep:updateCurrentStep})=>{const{i18n:i18n}=useServices();const{name:name,snapshotName:snapshotName,schedule:schedule,repository:repository,config:config,retention:retention}=policy;const{indices:indices,includeGlobalState:includeGlobalState,ignoreUnavailable:ignoreUnavailable,partial:partial}=config||{indices:undefined,includeGlobalState:undefined,ignoreUnavailable:undefined,partial:undefined};const serializedPolicy=serializePolicy(policy);const{retention:serializedRetention}=serializedPolicy;const EditStepTooltip=({step:step})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.editStepTooltip",defaultMessage:"Edit"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>updateCurrentStep(step)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"pencil","aria-label":i18n.translate("xpack.snapshotRestore.policyForm.stepReview.editIconAriaLabel",{defaultMessage:"Edit step"})})));const renderSummaryTab=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.sectionLogisticsTitle",defaultMessage:"Logistics"})," ",external_kbnSharedDeps_React_default.a.createElement(EditStepTooltip,{step:1}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.nameLabel",defaultMessage:"Policy name"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,name))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.snapshotNameLabel",defaultMessage:"Snapshot name"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,snapshotName)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.repositoryLabel",defaultMessage:"Repository"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,repository))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.scheduleLabel",defaultMessage:"Schedule"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,schedule)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.sectionSettingsTitle",defaultMessage:"Snapshot settings"})," ",external_kbnSharedDeps_React_default.a.createElement(EditStepTooltip,{step:2}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.dataStreamsAndIndicesLabel",defaultMessage:"Data streams and indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(CollapsibleIndicesList,{indices:indices})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.ignoreUnavailableLabel",defaultMessage:"Ignore unavailable indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,ignoreUnavailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.ignoreUnavailableTrueLabel",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.ignoreUnavailableFalseLabel",defaultMessage:"No"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.partialIndicesLabel",defaultMessage:"Allow partial indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,partial?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.partialTrueLabel",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.partialFalseLabel",defaultMessage:"No"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.includeGlobalStateLabel",defaultMessage:"Include global state"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,includeGlobalState===false?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.includeGlobalStateFalseLabel",defaultMessage:"No"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.summaryTab.includeGlobalStateTrueLabel",defaultMessage:"Yes"}))))),serializedRetention?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.retentionTab.sectionRetentionTitle",defaultMessage:"Snapshot retention"})," ",external_kbnSharedDeps_React_default.a.createElement(EditStepTooltip,{step:3}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},retention.expireAfterValue&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.retentionTab.expireAfterLabel",defaultMessage:"Delete after"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,retention.expireAfterValue,retention.expireAfterUnit)),retention.minCount&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.retentionTab.minCountLabel",defaultMessage:"Min count"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,retention.minCount)),retention.maxCount&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReview.retentionTab.maxCountLabel",defaultMessage:"Max count"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,retention.maxCount)))):null);const renderRequestTab=()=>{const endpoint=`PUT _slm/policy/${name}`;const json=JSON.stringify(serializedPolicy,null,2);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"json",isCopyable:true},`${endpoint}\n${json}`))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.stepReviewTitle",defaultMessage:"Review policy"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabbedContent"],{tabs:[{id:"summary",name:i18n.translate("xpack.snapshotRestore.policyForm.stepReview.summaryTabTitle",{defaultMessage:"Summary"}),content:renderSummaryTab()},{id:"json",name:i18n.translate("xpack.snapshotRestore.policyForm.stepReview.requestTabTitle",{defaultMessage:"Request"}),content:renderRequestTab()}]}))};const PolicyNavigation=({currentStep:currentStep,maxCompletedStep:maxCompletedStep,updateCurrentStep:updateCurrentStep,isFormValid:isFormValid})=>{const{i18n:i18n}=useServices();const steps=[{title:i18n.translate("xpack.snapshotRestore.policyForm.navigation.stepLogisticsName",{defaultMessage:"Logistics"}),isComplete:maxCompletedStep>=1,isSelected:currentStep===1,disabled:!isFormValid&&currentStep!==1,onClick:()=>updateCurrentStep(1)},{title:i18n.translate("xpack.snapshotRestore.policyForm.navigation.stepSettingsName",{defaultMessage:"Snapshot settings"}),isComplete:maxCompletedStep>=2,isSelected:currentStep===2,disabled:maxCompletedStep<1||!isFormValid&&currentStep!==2,onClick:()=>updateCurrentStep(2)},{title:i18n.translate("xpack.snapshotRestore.policyForm.navigation.stepRetentionName",{defaultMessage:"Snapshot retention"}),isComplete:maxCompletedStep>=3,isSelected:currentStep===3,disabled:maxCompletedStep<2||!isFormValid&&currentStep!==3,onClick:()=>updateCurrentStep(3)},{title:i18n.translate("xpack.snapshotRestore.policyForm.navigation.stepReviewName",{defaultMessage:"Review"}),isComplete:maxCompletedStep>=3,isSelected:currentStep===4,disabled:maxCompletedStep<3||!isFormValid&&currentStep!==4,onClick:()=>updateCurrentStep(4)}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStepsHorizontal"],{steps:steps})};const PolicyForm=({policy:originalPolicy,dataStreams:dataStreams,indices:indices,currentUrl:currentUrl,isEditing:isEditing,isSaving:isSaving,saveError:saveError,clearSaveError:clearSaveError,onCancel:onCancel,onSave:onSave})=>{var _originalPolicy$reten,_originalPolicy$reten2;const[currentStep,setCurrentStep]=Object(external_kbnSharedDeps_React_["useState"])(1);const[maxCompletedStep,setMaxCompletedStep]=Object(external_kbnSharedDeps_React_["useState"])(0);const stepMap={1:PolicyStepLogistics,2:PolicyStepSettings,3:PolicyStepRetention,4:PolicyStepReview};const CurrentStepForm=stepMap[currentStep];const[policy,setPolicy]=Object(external_kbnSharedDeps_React_["useState"])({...originalPolicy,config:{...originalPolicy.config||{}},retention:{...originalPolicy.retention,expireAfterUnit:(_originalPolicy$reten=(_originalPolicy$reten2=originalPolicy.retention)===null||_originalPolicy$reten2===void 0?void 0:_originalPolicy$reten2.expireAfterUnit)!==null&&_originalPolicy$reten!==void 0?_originalPolicy$reten:constants["g"].DAY}});const isEditingManagedPolicy=Boolean(isEditing&&policy.isManagedPolicy);const[validation,setValidation]=Object(external_kbnSharedDeps_React_["useState"])({isValid:true,errors:{}});const updatePolicy=(updatedFields,validationHelperData={})=>{const newPolicy={...policy,...updatedFields};const newValidation=validatePolicy(newPolicy,validationHelperData);setPolicy(newPolicy);setValidation(newValidation)};const updateCurrentStep=step=>{if(maxCompletedStep<step-1){return}setCurrentStep(step);setMaxCompletedStep(step-1);clearSaveError()};const onBack=()=>{const previousStep=currentStep-1;setCurrentStep(previousStep);setMaxCompletedStep(previousStep-1);clearSaveError()};const onNext=()=>{if(!validation.isValid){return}const nextStep=currentStep+1;setMaxCompletedStep(Math.max(currentStep,maxCompletedStep));setCurrentStep(nextStep)};const savePolicy=()=>{if(validation.isValid){onSave(policy)}};const lastStep=Object.keys(stepMap).length;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(PolicyNavigation,{currentStep:currentStep,maxCompletedStep:maxCompletedStep,updateCurrentStep:updateCurrentStep,isFormValid:validation.isValid}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(CurrentStepForm,{policy:policy,indices:indices,dataStreams:dataStreams,updatePolicy:updatePolicy,isEditing:isEditing,currentUrl:currentUrl,errors:validation.errors,updateCurrentStep:updateCurrentStep}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),saveError?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,saveError,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,currentStep>1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"arrowLeft",onClick:()=>onBack(),disabled:!validation.isValid},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.backButtonLabel",defaultMessage:"Back"}))):null,currentStep<lastStep?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"arrowRight",onClick:()=>onNext(),iconSide:"right",disabled:!validation.isValid,"data-test-subj":"nextButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.nextButtonLabel",defaultMessage:"Next"}))):null,currentStep===lastStep?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:!isEditingManagedPolicy,color:isEditingManagedPolicy?"warning":"secondary",iconType:"check",onClick:()=>savePolicy(),isLoading:isSaving,"data-test-subj":"submitButton"},isSaving?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.savingButtonLabel",defaultMessage:"Saving…"}):isEditing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.saveButtonLabel",defaultMessage:"Save policy"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.createButtonLabel",defaultMessage:"Create policy"}))):null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>onCancel()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyForm.cancelButtonLabel",defaultMessage:"Cancel"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};const attemptToURIDecode=value=>{let result;try{result=decodeURI(value);result=decodeURIComponent(result)}catch(e1){try{result=decodeURIComponent(value)}catch(e2){result=value}}return result};const useDecodedParams=()=>{const params=Object(external_kbnSharedDeps_ReactRouterDom_["useParams"])();const decodedParams={};for(const[key,value]of Object.entries(params)){if(value){decodedParams[key]=attemptToURIDecode(value)}}return decodedParams};var textmate=__webpack_require__(31);const AzureDetails=({repository:repository})=>{const{settings:{client:client,container:container,basePath:basePath,compress:compress,chunkSize:chunkSize,readonly:readonly,locationMode:locationMode,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec}}=repository;const listItems=[];if(client!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.clientLabel",defaultMessage:"Client"}),description:client})}if(container!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.containerLabel",defaultMessage:"Container"}),description:container})}if(basePath!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.basePathLabel",defaultMessage:"Base path"}),description:basePath})}if(compress!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.compressLabel",defaultMessage:"Snapshot compression"}),description:String(compress)})}if(chunkSize!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.chunkSizeLabel",defaultMessage:"Chunk size"}),description:String(chunkSize)})}if(maxSnapshotBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),description:maxSnapshotBytesPerSec})}if(maxRestoreBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),description:maxRestoreBytesPerSec})}if(readonly!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.readonlyLabel",defaultMessage:"Read-only"}),description:String(readonly)})}if(locationMode!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeAzure.locationModeLabel",defaultMessage:"Location mode"}),description:locationMode})}if(!listItems.length){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:listItems}))};const DefaultDetails=({repository:{name:name,settings:settings}})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{mode:"json",theme:"textmate",width:"100%",isReadOnly:true,value:JSON.stringify(settings,null,2),setOptions:{showLineNumbers:false,tabSize:2,maxLines:Infinity},editorProps:{$blockScrolling:Infinity},showGutter:false,minLines:6,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.snapshotRestore.repositoryDetails.genericSettingsDescription",{defaultMessage:`Readonly settings for repository '{name}'`,values:{name:name}})}));const FSDetails=({repository:repository})=>{const{settings:{location:location,compress:compress,chunkSize:chunkSize,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec,readonly:readonly}}=repository;const listItems=[{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeFS.locationLabel",defaultMessage:"Location"}),description:location}];if(compress!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeFS.compressLabel",defaultMessage:"Snapshot compression"}),description:String(compress)})}if(chunkSize!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeFS.chunkSizeLabel",defaultMessage:"Chunk size"}),description:String(chunkSize)})}if(maxSnapshotBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeFS.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),description:maxSnapshotBytesPerSec})}if(maxRestoreBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeFS.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),description:maxRestoreBytesPerSec})}if(readonly!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeFS.readonlyLabel",defaultMessage:"Read-only"}),description:String(readonly)})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:listItems}))};const GCSDetails=({repository:repository})=>{const{settings:{bucket:bucket,client:client,basePath:basePath,compress:compress,chunkSize:chunkSize,readonly:readonly,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec}}=repository;const listItems=[{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.bucketLabel",defaultMessage:"Bucket"}),description:bucket||""}];if(client!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.clientLabel",defaultMessage:"Client"}),description:client})}if(basePath!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.basePathLabel",defaultMessage:"Base path"}),description:basePath})}if(compress!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.compressLabel",defaultMessage:"Snapshot compression"}),description:String(compress)})}if(chunkSize!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.chunkSizeLabel",defaultMessage:"Chunk size"}),description:String(chunkSize)})}if(maxSnapshotBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),description:maxSnapshotBytesPerSec})}if(maxRestoreBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),description:maxRestoreBytesPerSec})}if(readonly!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeGCS.readonlyLabel",defaultMessage:"Read-only"}),description:String(readonly)})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:listItems}))};const HDFSDetails=({repository:repository})=>{const{settings:settings}=repository;const{uri:uri,path:path,loadDefaults:loadDefaults,compress:compress,chunkSize:chunkSize,readonly:readonly,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec,maxRestoreBytesPerSec:maxRestoreBytesPerSec,"security.principal":securityPrincipal,...rest}=settings;const listItems=[{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.uriLabel",defaultMessage:"URI"}),description:uri||""},{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.pathLabel",defaultMessage:"Path"}),description:path||""}];if(loadDefaults!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.loadDefaultsLabel",defaultMessage:"Load defaults"}),description:String(loadDefaults)})}if(compress!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.compressLabel",defaultMessage:"Snapshot compression"}),description:String(compress)})}if(chunkSize!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.chunkSizeLabel",defaultMessage:"Chunk size"}),description:String(chunkSize)})}if(maxSnapshotBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),description:maxSnapshotBytesPerSec})}if(maxRestoreBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),description:maxRestoreBytesPerSec})}if(readonly!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.readonlyLabel",defaultMessage:"Read-only"}),description:String(readonly)})}if(securityPrincipal!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeHDFS.securityPrincipalLabel",defaultMessage:"Security principal"}),description:securityPrincipal})}Object.keys(rest).forEach(key=>{listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,key),description:String(settings[key])})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:listItems}))};const ReadonlyDetails=({repository:repository})=>{const{settings:{url:url}}=repository;const listItems=[{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeReadonly.urlLabel",defaultMessage:"URL"}),description:url}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:listItems}))};const S3Details=({repository:repository})=>{const{settings:{bucket:bucket,client:client,basePath:basePath,compress:compress,chunkSize:chunkSize,serverSideEncryption:serverSideEncryption,bufferSize:bufferSize,cannedAcl:cannedAcl,storageClass:storageClass,readonly:readonly,maxRestoreBytesPerSec:maxRestoreBytesPerSec,maxSnapshotBytesPerSec:maxSnapshotBytesPerSec}}=repository;const listItems=[{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.bucketLabel",defaultMessage:"Bucket"}),description:bucket||""}];if(client!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.clientLabel",defaultMessage:"Client"}),description:client})}if(basePath!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.basePathLabel",defaultMessage:"Base path"}),description:basePath})}if(compress!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.compressLabel",defaultMessage:"Snapshot compression"}),description:String(compress)})}if(chunkSize!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.chunkSizeLabel",defaultMessage:"Chunk size"}),description:String(chunkSize)})}if(serverSideEncryption!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.serverSideEncryptionLabel",defaultMessage:"Server-side encryption"}),description:String(serverSideEncryption)})}if(bufferSize!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.bufferSizeLabel",defaultMessage:"Buffer size"}),description:bufferSize})}if(cannedAcl!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.cannedAclLabel",defaultMessage:"Canned ACL"}),description:cannedAcl})}if(storageClass!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.storageClassLabel",defaultMessage:"Storage class"}),description:storageClass})}if(maxSnapshotBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.maxSnapshotBytesLabel",defaultMessage:"Max snapshot bytes per second"}),description:maxSnapshotBytesPerSec})}if(maxRestoreBytesPerSec!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.maxRestoreBytesLabel",defaultMessage:"Max restore bytes per second"}),description:maxRestoreBytesPerSec})}if(readonly!==undefined){listItems.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeS3.readonlyLabel",defaultMessage:"Read-only"}),description:String(readonly)})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.settingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse",listItems:listItems}))};const TypeDetails=({repository:repository})=>{const{type:type,settings:settings}=repository;switch(type){case constants["f"].fs:return external_kbnSharedDeps_React_default.a.createElement(FSDetails,{repository:repository});case constants["f"].url:return external_kbnSharedDeps_React_default.a.createElement(ReadonlyDetails,{repository:repository});case constants["f"].source:const{delegateType:delegateType}=settings;const delegatedRepository={...repository,type:delegateType};return external_kbnSharedDeps_React_default.a.createElement(TypeDetails,{repository:delegatedRepository});case constants["f"].azure:return external_kbnSharedDeps_React_default.a.createElement(AzureDetails,{repository:repository});case constants["f"].gcs:return external_kbnSharedDeps_React_default.a.createElement(GCSDetails,{repository:repository});case constants["f"].hdfs:return external_kbnSharedDeps_React_default.a.createElement(HDFSDetails,{repository:repository});case constants["f"].s3:return external_kbnSharedDeps_React_default.a.createElement(S3Details,{repository:repository});default:return external_kbnSharedDeps_React_default.a.createElement(DefaultDetails,{repository:repository})}};function repository_details_extends(){repository_details_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return repository_details_extends.apply(this,arguments)}const RepositoryDetails=({repositoryName:repositoryName,onClose:onClose,onRepositoryDeleted:onRepositoryDeleted})=>{const{i18n:i18n,history:history}=useServices();const{error:error,data:repositoryDetails}=Object(services_http["s"])(repositoryName);const[verification,setVerification]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[cleanup,setCleanup]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[isLoadingVerification,setIsLoadingVerification]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoadingCleanup,setIsLoadingCleanup]=Object(external_kbnSharedDeps_React_["useState"])(false);const verifyRepository=async()=>{setIsLoadingVerification(true);const{data:data}=await Object(services_http["y"])(repositoryName);setVerification(data.verification);setIsLoadingVerification(false)};const cleanupRepository=async()=>{setIsLoadingCleanup(true);const{data:data}=await Object(services_http["c"])(repositoryName);setCleanup(data.cleanup);setIsLoadingCleanup(false)};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setVerification(undefined);setIsLoadingVerification(false);setCleanup(undefined);setIsLoadingCleanup(false)},[repositoryName]);const renderBody=()=>{if(repositoryDetails){return renderRepository()}if(error){return renderError()}return renderLoading()};const renderLoading=()=>external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.loadingRepositoryDescription",defaultMessage:"Loading repository…"}));const renderError=()=>{const notFound=error.status===404;const errorObject=notFound?{data:{error:i18n.translate("xpack.snapshotRestore.repositoryDetails.repositoryNotFoundErrorMessage",{defaultMessage:`The repository '{name}' does not exist.`,values:{name:repositoryName}})}}:error;return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.loadingRepositoryErrorTitle",defaultMessage:"Error loading repository"}),error:errorObject})};const renderSnapshotCount=()=>{const{snapshots:snapshots}=repositoryDetails;if(!Number.isInteger(snapshots.count)){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.noSnapshotInformationDescription",defaultMessage:"No snapshot information"})}if(snapshots.count===0){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.zeroSnapshotsDescription",defaultMessage:"Repository has no snapshots"})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToSnapshots(repositoryName)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.snapshotsDescription",defaultMessage:"{count} {count, plural, one {snapshot} other {snapshots}} found",values:{count:snapshots.count}}))};const renderRepository=()=>{const{repository:repository,isManagedRepository:isManagedRepository}=repositoryDetails;if(!repository){return null}const{type:type}=repository;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,isManagedRepository?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",color:"warning",iconType:"iInCircle",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.managedRepositoryWarningTitle",defaultMessage:"This is a managed repository used by other systems. Any changes you make might affect how these systems operate."})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.typeTitle",defaultMessage:"Repository type"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"repositoryType"},type===constants["f"].source?services_text["a"].getRepositoryTypeName(type,repository.settings.delegateType):services_text["a"].getRepositoryTypeName(type))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:documentationLinksService.getRepositoryTypeDocUrl(type),target:"_blank",iconType:"help","data-test-subj":"documentationLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.repositoryTypeDocLink",defaultMessage:"Repository docs"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.snapshotsTitle",defaultMessage:"Snapshots"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"snapshotCount"},renderSnapshotCount()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(TypeDetails,{repository:repository}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),renderVerification(),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),renderCleanup())};const renderVerification=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.verificationTitle",defaultMessage:"Verification status"}))),verification?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(RepositoryVerificationBadge,{verificationResults:verification}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.verificationDetailsTitle",defaultMessage:"Details"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),verification?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"json","data-test-subj":"verificationCodeBlock"},JSON.stringify(verification.valid?verification.response:verification.error,null,2)):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:verifyRepository,color:"primary",isLoading:isLoadingVerification},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.verifyButtonLabel",defaultMessage:"Verify repository"}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:verifyRepository,color:"primary",isLoading:isLoadingVerification,"data-test-subj":"verifyRepositoryButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.verifyButtonLabel",defaultMessage:"Verify repository"}))));const renderCleanup=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.cleanupTitle",defaultMessage:"Repository cleanup"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.cleanupRepositoryMessage",defaultMessage:"You can clean up a repository to delete any unreferenced data from a snapshot. This may provide storage space savings. Note: If you regularly delete snapshots, this functionality will likely not be as beneficial and should be used less frequently."}))),cleanup?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),cleanup.cleaned?external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.cleanupDetailsTitle",defaultMessage:"Details"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"json","data-test-subj":"cleanupCodeBlock"},JSON.stringify(cleanup.response,null,2))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",iconType:"alert",title:i18n.translate("xpack.snapshotRestore.repositoryDetails.cleanupErrorTitle",{defaultMessage:"Sorry, there was an error cleaning the repository."})},external_kbnSharedDeps_React_default.a.createElement("p",null,cleanup.error?JSON.stringify(cleanup.error):i18n.translate("xpack.snapshotRestore.repositoryDetails.cleanupUnknownError",{defaultMessage:"503: Unknown error"})))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:cleanupRepository,color:"primary",isLoading:isLoadingCleanup,"data-test-subj":"cleanupRepositoryButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.cleanupButtonLabel",defaultMessage:"Clean up repository"})));const renderFooter=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"cross",flush:"left",onClick:onClose,"data-test-subj":"srRepositoryDetailsFlyoutCloseButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.closeButtonLabel",defaultMessage:"Close"}))),repositoryDetails?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RepositoryDeleteProvider,null,deleteRepositoryPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"danger","data-test-subj":"srRepositoryDetailsDeleteActionButton",onClick:()=>deleteRepositoryPrompt([repositoryName],onRepositoryDeleted),isDisabled:repositoryDetails.isManagedRepository,title:repositoryDetails.isManagedRepository?i18n.translate("xpack.snapshotRestore.repositoryDetails.removeManagedRepositoryButtonTitle",{defaultMessage:"You cannot delete a managed repository."}):undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.removeButtonLabel",defaultMessage:"Remove"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],repository_details_extends({},Object(public_["reactRouterNavigate"])(history,linkToEditRepository(repositoryName)),{fill:true,color:"primary"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryDetails.editButtonLabel",defaultMessage:"Edit"}))))):null);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,"data-test-subj":"repositoryDetail","aria-labelledby":"srRepositoryDetailsFlyoutTitle",size:"m",maxWidth:550},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"srRepositoryDetailsFlyoutTitle","data-test-subj":"title"},repositoryName))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],{"data-test-subj":"content"},renderBody()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,renderFooter()))};function repository_table_extends(){repository_table_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return repository_table_extends.apply(this,arguments)}const RepositoryTable=({repositories:repositories,managedRepository:managedRepository,reload:reload,openRepositoryDetailsUrl:openRepositoryDetailsUrl,onRepositoryDeleted:onRepositoryDeleted})=>{const{i18n:i18n,uiMetricService:uiMetricService,history:history}=useServices();const[selectedItems,setSelectedItems]=Object(external_kbnSharedDeps_React_["useState"])([]);const columns=[{field:"name",name:i18n.translate("xpack.snapshotRestore.repositoryList.table.nameColumnTitle",{defaultMessage:"Name"}),truncateText:true,sortable:true,render:name=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],repository_table_extends({},Object(public_["reactRouterNavigate"])(history,openRepositoryDetailsUrl(name),()=>uiMetricService.trackUiMetric(application_constants["z"])),{"data-test-subj":"repositoryLink"}),name),"  ",managedRepository===name?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.table.managedRepositoryBadgeLabel",defaultMessage:"This is a managed repository"}),position:"right"}):null)},{field:"type",name:i18n.translate("xpack.snapshotRestore.repositoryList.table.typeColumnTitle",{defaultMessage:"Type"}),truncateText:true,sortable:true,render:(type,repository)=>{if(type===constants["f"].source){return services_text["a"].getRepositoryTypeName(type,repository.settings.delegateType)}return services_text["a"].getRepositoryTypeName(type)}},{field:"actions",name:i18n.translate("xpack.snapshotRestore.repositoryList.table.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:({name:name})=>{const label=i18n.translate("xpack.snapshotRestore.repositoryList.table.actionEditTooltip",{defaultMessage:"Edit"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],repository_table_extends({"aria-label":i18n.translate("xpack.snapshotRestore.repositoryList.table.actionEditAriaLabel",{defaultMessage:"Edit repository `{name}`",values:{name:name}}),iconType:"pencil",color:"primary"},Object(public_["reactRouterNavigate"])(history,linkToEditRepository(name)),{"data-test-subj":"editRepositoryButton"})))}},{render:({name:name})=>external_kbnSharedDeps_React_default.a.createElement(RepositoryDeleteProvider,null,deleteRepositoryPrompt=>{const label=name!==managedRepository?i18n.translate("xpack.snapshotRestore.repositoryList.table.actionRemoveTooltip",{defaultMessage:"Remove"}):i18n.translate("xpack.snapshotRestore.repositoryList.table.deleteManagedRepositoryTooltip",{defaultMessage:"You cannot delete a managed repository."});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":i18n.translate("xpack.snapshotRestore.repositoryList.table.actionRemoveAriaLabel",{defaultMessage:"Remove repository `{name}`",values:{name:name}}),iconType:"trash",color:"danger","data-test-subj":"deleteRepositoryButton",onClick:()=>deleteRepositoryPrompt([name],onRepositoryDeleted),isDisabled:Boolean(name===managedRepository)}))})}],width:"100px"}];const sorting={sort:{field:"name",direction:"asc"}};const pagination={initialPageSize:20,pageSizeOptions:[10,20,50]};const selection={onSelectionChange:newSelectedItems=>setSelectedItems(newSelectedItems),selectable:({name:name})=>Boolean(name!==managedRepository),selectableMessage:selectable=>{if(!selectable){return i18n.translate("xpack.snapshotRestore.repositoryList.table.deleteManagedRepositoryTooltip",{defaultMessage:"You cannot delete a managed repository."})}return""}};const search={toolsLeft:selectedItems.length?external_kbnSharedDeps_React_default.a.createElement(RepositoryDeleteProvider,null,deleteRepositoryPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>deleteRepositoryPrompt(selectedItems.map(repository=>repository.name),onRepositoryDeleted),color:"danger","data-test-subj":"srRepositoryListBulkDeleteActionButton"},selectedItems.length===1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.table.deleteSingleRepositoryButton",defaultMessage:"Remove repository"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.table.deleteMultipleRepositoriesButton",defaultMessage:"Remove repositories"}))):undefined,toolsRight:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"reloadButton",color:"secondary",iconType:"refresh",onClick:reload,"data-test-subj":"reloadButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.table.reloadRepositoriesButton",defaultMessage:"Reload"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],repository_table_extends({key:"registerRepo"},Object(public_["reactRouterNavigate"])(history,linkToAddRepository(name)),{fill:true,iconType:"plusInCircle","data-test-subj":"registerRepositoryButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.addRepositoryButtonLabel",defaultMessage:"Register a repository"}))],box:{incremental:true,schema:true},filters:[{type:"field_value_selection",field:"type",name:i18n.translate("xpack.snapshotRestore.repositoryList.table.typeFilterLabel",{defaultMessage:"Type"}),multiSelect:false,options:Object.keys(repositories.reduce((typeMap,repository)=>{typeMap[repository.type]=true;return typeMap},{})).map(type=>({value:type,view:services_text["a"].getRepositoryTypeName(type)}))}]};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{items:repositories,itemId:"name",columns:columns,search:search,sorting:sorting,selection:selection,pagination:pagination,isSelectable:true,rowProps:()=>({"data-test-subj":"row"}),cellProps:(item,field)=>({"data-test-subj":`${field.name}_cell`}),"data-test-subj":"repositoryTable"})};function repository_list_extends(){repository_list_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return repository_list_extends.apply(this,arguments)}const RepositoryList=({history:history})=>{const{repositoryName:repositoryName}=useDecodedParams();const{error:error,isLoading:isLoading,data:{repositories:repositories,managedRepository:managedRepository}={repositories:undefined,managedRepository:{name:undefined}},resendRequest:reload}=Object(services_http["r"])();const{uiMetricService:uiMetricService}=useServices();const openRepositoryDetailsUrl=newRepositoryName=>linkToRepository(newRepositoryName);const closeRepositoryDetails=()=>{history.push(`${application_constants["a"]}/repositories`)};const onRepositoryDeleted=repositoriesDeleted=>{if(repositoryName&&repositoriesDeleted.includes(repositoryName)){closeRepositoryDetails()}if(repositoriesDeleted.length){reload()}};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{uiMetricService.trackUiMetric(application_constants["y"])},[uiMetricService]);let content;if(isLoading){content=external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.loadingRepositoriesDescription",defaultMessage:"Loading repositories…"}))}else if(error){content=external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.LoadingRepositoriesErrorMessage",defaultMessage:"Error loading repositories"}),error:error})}else if(repositories&&repositories.length===0){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.emptyPromptTitle",defaultMessage:"Register your first repository"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryList.emptyPromptDescription",defaultMessage:"Create a place where your snapshots will live."}))),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],repository_list_extends({},Object(public_["reactRouterNavigate"])(history,linkToAddRepository()),{fill:true,iconType:"plusInCircle","data-test-subj":"registerRepositoryButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addRepositoryButtonLabel",defaultMessage:"Register a repository"})),"data-test-subj":"emptyPrompt"})}else{content=external_kbnSharedDeps_React_default.a.createElement(RepositoryTable,{repositories:repositories||[],managedRepository:managedRepository===null||managedRepository===void 0?void 0:managedRepository.name,reload:reload,openRepositoryDetailsUrl:openRepositoryDetailsUrl,onRepositoryDeleted:onRepositoryDeleted})}return external_kbnSharedDeps_React_default.a.createElement("section",{"data-test-subj":"repositoryList"},repositoryName?external_kbnSharedDeps_React_default.a.createElement(RepositoryDetails,{repositoryName:repositoryName,onClose:closeRepositoryDetails,onRepositoryDeleted:onRepositoryDeleted}):null,content)};var query_string=__webpack_require__(32);const SnapshotState=({state:state})=>{const{i18n:i18n}=useServices();const stateMap={[application_constants["i"].IN_PROGRESS]:{icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}),label:i18n.translate("xpack.snapshotRestore.snapshotState.inProgressLabel",{defaultMessage:"Taking snapshot…"})},[application_constants["i"].SUCCESS]:{icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"success",type:"check"}),label:i18n.translate("xpack.snapshotRestore.snapshotState.completeLabel",{defaultMessage:"Snapshot complete"})},[application_constants["i"].FAILED]:{icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"danger",type:"cross"}),label:i18n.translate("xpack.snapshotRestore.snapshotState.failedLabel",{defaultMessage:"Snapshot failed"})},[application_constants["i"].PARTIAL]:{icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"warning",type:"alert"}),label:i18n.translate("xpack.snapshotRestore.snapshotState.partialLabel",{defaultMessage:"Partial failure"}),tip:i18n.translate("xpack.snapshotRestore.snapshotState.partialTipDescription",{defaultMessage:`Global cluster state was stored, but at least one shard wasn't stored successfully. See the 'Failed indices' tab.`})},[application_constants["i"].INCOMPATIBLE]:{icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"warning",type:"alert"}),label:i18n.translate("xpack.snapshotRestore.snapshotState.incompatibleLabel",{defaultMessage:"Incompatible version"}),tip:i18n.translate("xpack.snapshotRestore.snapshotState.incompatibleTipDescription",{defaultMessage:`Snapshot was created with a version of Elasticsearch incompatible with the cluster's version.`})}};if(!stateMap[state]){return state}const{icon:icon,label:label,tip:tip}=stateMap[state];const iconTip=tip&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:tip}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},icon),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("div",null,label,iconTip)))};const TabSummary=({snapshotDetails:snapshotDetails})=>{const{versionId:versionId,version:version,includeGlobalState:includeGlobalState,dataStreams:dataStreams,indices:indices,state:state,startTimeInMillis:startTimeInMillis,endTimeInMillis:endTimeInMillis,durationInMillis:durationInMillis,uuid:uuid,policyName:policyName}=snapshotDetails;const{history:history}=useServices();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"version"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemVersionLabel",defaultMessage:"Version / Version ID"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},version," / ",versionId)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"uuid"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemUuidLabel",defaultMessage:"UUID"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},uuid))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"state"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemStateLabel",defaultMessage:"State"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(SnapshotState,{state:state}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"includeGlobalState"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemIncludeGlobalStateLabel",defaultMessage:"Includes global state"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},includeGlobalState?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemIncludeGlobalStateYesLabel",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemIncludeGlobalStateNoLabel",defaultMessage:"No"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"indices"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemIndicesLabel",defaultMessage:"Indices ({indicesCount})",values:{indicesCount:indices.length}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(CollapsibleIndicesList,{indices:indices})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"dataStreams"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemDataStreamsLabel",defaultMessage:"Data streams ({dataStreamsCount})",values:{dataStreamsCount:dataStreams.length}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(CollapsibleDataStreamsList,{dataStreams:dataStreams})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"startTime"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemStartTimeLabel",defaultMessage:"Start time"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(DataPlaceholder,{data:startTimeInMillis},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:startTimeInMillis})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"endTime"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemEndTimeLabel",defaultMessage:"End time"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},state===application_constants["i"].IN_PROGRESS?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}):external_kbnSharedDeps_React_default.a.createElement(DataPlaceholder,{data:endTimeInMillis},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:endTimeInMillis}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"duration"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemDurationLabel",defaultMessage:"Duration"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},state===application_constants["i"].IN_PROGRESS?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}):external_kbnSharedDeps_React_default.a.createElement(DataPlaceholder,{data:durationInMillis},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.itemDurationValueLabel","data-test-subj":"srSnapshotDetailsDurationValue",defaultMessage:"{seconds} {seconds, plural, one {second} other {seconds}}",values:{seconds:Math.ceil(durationInMillis/1e3)}})))),policyName?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"policy"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.createdByLabel",defaultMessage:"Created by"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToPolicy(policyName)),policyName))):null))};const TabFailures=({indexFailures:indexFailures,snapshotState:snapshotState})=>{if(!indexFailures.length){if(snapshotState===application_constants["i"].IN_PROGRESS){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.snapshotIsBeingCreatedMessage",defaultMessage:"Snapshot is being created."})}else{return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.noIndexFailuresMessage",defaultMessage:"All indices were stored successfully."})}}return indexFailures.map((indexObject,count)=>{const{index:index,failures:failures}=indexObject;return external_kbnSharedDeps_React_default.a.createElement("div",{key:index,"data-test-subj":"indexFailure"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs","data-test-subj":"index"},external_kbnSharedDeps_React_default.a.createElement("h3",null,index)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),failures.map((failure,failuresCount)=>{const{status:status,reason:reason,shard_id:shardId}=failure;return external_kbnSharedDeps_React_default.a.createElement("div",{key:`${shardId}${reason}`,"data-test-subj":"failure"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs","data-test-subj":"shard"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.failureShardTitle",defaultMessage:"Shard {shardId}",values:{shardId:shardId}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{paddingSize:"s","data-test-subj":"reason",language:"text"},`${status}: ${reason}`),failuresCount<failures.length-1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}):undefined)}),count<indexFailures.length-1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}):undefined)})};function snapshot_details_extends(){snapshot_details_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return snapshot_details_extends.apply(this,arguments)}const TAB_SUMMARY="summary";const TAB_FAILURES="failures";const panelTypeToUiMetricMap={[TAB_SUMMARY]:application_constants["J"],[TAB_FAILURES]:application_constants["I"]};const SnapshotDetails=({repositoryName:repositoryName,snapshotId:snapshotId,onClose:onClose,onSnapshotDeleted:onSnapshotDeleted})=>{const{i18n:i18n,uiMetricService:uiMetricService,history:history}=useServices();const{error:error,data:snapshotDetails}=Object(services_http["w"])(repositoryName,snapshotId);const[activeTab,setActiveTab]=Object(external_kbnSharedDeps_React_["useState"])(TAB_SUMMARY);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setActiveTab(TAB_SUMMARY)},[repositoryName,snapshotId]);let tabs;let content;if(snapshotDetails){const{indexFailures:indexFailures,state:snapshotState}=snapshotDetails;const tabOptions=[{id:TAB_SUMMARY,name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.summaryTabTitle",defaultMessage:"Summary"})},{id:TAB_FAILURES,name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.failuresTabTitle",defaultMessage:"Failed indices ({failuresCount})",values:{failuresCount:indexFailures.length}})}];tabs=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],null,tabOptions.map(tab=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:()=>{uiMetricService.trackUiMetric(panelTypeToUiMetricMap[tab.id]);setActiveTab(tab.id)},isSelected:tab.id===activeTab,key:tab.id,"data-test-subj":"tab"},tab.name))));if(activeTab===TAB_SUMMARY){content=external_kbnSharedDeps_React_default.a.createElement(TabSummary,{snapshotDetails:snapshotDetails})}else if(activeTab===TAB_FAILURES){content=external_kbnSharedDeps_React_default.a.createElement(TabFailures,{snapshotState:snapshotState,indexFailures:indexFailures})}}else if(error){const notFound=error.status===404;const errorObject=notFound?{data:{error:i18n.translate("xpack.snapshotRestore.snapshotDetails.errorSnapshotNotFound",{defaultMessage:`Either the snapshot '{snapshotId}' doesn't exist in the repository '{repositoryName}' or the repository doesn't exist.`,values:{snapshotId:snapshotId,repositoryName:repositoryName}})}}:error;content=external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.errorLoadingRepositoryTitle",defaultMessage:"Error loading repository"}),error:errorObject})}else{content=external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.loadingSnapshotDescription",defaultMessage:"Loading snapshot…"}))}const renderFooter=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"cross",flush:"left",onClick:onClose,"data-test-subj":"closeButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.closeButtonLabel",defaultMessage:"Close"}))),snapshotDetails?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(SnapshotDeleteProvider,null,deleteSnapshotPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"danger","data-test-subj":"srSnapshotDetailsDeleteActionButton",onClick:()=>deleteSnapshotPrompt([{repository:repositoryName,snapshot:snapshotId}],onSnapshotDeleted),isDisabled:snapshotDetails.managedRepository&&snapshotDetails.isLastSuccessfulSnapshot,title:snapshotDetails.managedRepository&&snapshotDetails.isLastSuccessfulSnapshot?i18n.translate("xpack.snapshotRestore.snapshotDetails.deleteManagedRepositorySnapshotButtonTitle",{defaultMessage:"You cannot delete the last successful snapshot stored in a managed repository."}):undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.deleteButtonLabel",defaultMessage:"Delete"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],snapshot_details_extends({},Object(public_["reactRouterNavigate"])(history,linkToRestoreSnapshot(repositoryName,snapshotId)),{fill:true,color:"primary",isDisabled:snapshotDetails.state!==application_constants["i"].SUCCESS&&snapshotDetails.state!==application_constants["i"].PARTIAL}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.restoreButtonLabel",defaultMessage:"Restore"}))))):null);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,"data-test-subj":"snapshotDetail","aria-labelledby":"srSnapshotDetailsFlyoutTitle",size:"m",maxWidth:550},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h2",{id:"srSnapshotDetailsFlyoutTitle","data-test-subj":"detailTitle"},snapshotId),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("small",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],snapshot_details_extends({},Object(public_["reactRouterNavigate"])(history,linkToRepository(repositoryName)),{"data-test-subj":"repositoryLink"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotDetails.repositoryTitle",defaultMessage:"'{repositoryName}' repository",values:{repositoryName:repositoryName}}))))),tabs),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],{"data-test-subj":"content"},content),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,renderFooter()))};function snapshot_table_extends(){snapshot_table_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return snapshot_table_extends.apply(this,arguments)}const getLastSuccessfulManagedSnapshot=snapshots=>{const successfulSnapshots=snapshots.filter(({state:state,repository:repository,managedRepository:managedRepository})=>repository===managedRepository&&state==="SUCCESS").sort((a,b)=>+new Date(b.endTime)-+new Date(a.endTime));return successfulSnapshots[0]};const SnapshotTable=({snapshots:snapshots,repositories:repositories,reload:reload,openSnapshotDetailsUrl:openSnapshotDetailsUrl,onSnapshotDeleted:onSnapshotDeleted,repositoryFilter:repositoryFilter,policyFilter:policyFilter})=>{const{i18n:i18n,uiMetricService:uiMetricService,history:history}=useServices();const[selectedItems,setSelectedItems]=Object(external_kbnSharedDeps_React_["useState"])([]);const lastSuccessfulManagedSnapshot=getLastSuccessfulManagedSnapshot(snapshots);const columns=[{field:"snapshot",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.snapshotColumnTitle",{defaultMessage:"Snapshot"}),truncateText:true,sortable:true,render:(snapshotId,snapshot)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],snapshot_table_extends({},Object(public_["reactRouterNavigate"])(history,openSnapshotDetailsUrl(snapshot.repository,snapshotId),()=>uiMetricService.trackUiMetric(application_constants["L"])),{"data-test-subj":"snapshotLink"}),snapshotId)},{field:"repository",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.repositoryColumnTitle",{defaultMessage:"Repository"}),truncateText:true,sortable:true,render:repositoryName=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],snapshot_table_extends({},Object(public_["reactRouterNavigate"])(history,linkToRepository(repositoryName)),{"data-test-subj":"repositoryLink"}),repositoryName)},{field:"indices",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.indicesColumnTitle",{defaultMessage:"Indices"}),truncateText:true,sortable:true,width:"100px",render:indices=>indices.length},{field:"shards.total",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.shardsColumnTitle",{defaultMessage:"Shards"}),truncateText:true,sortable:true,width:"100px",render:totalShards=>totalShards},{field:"shards.failed",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.failedShardsColumnTitle",{defaultMessage:"Failed shards"}),truncateText:true,sortable:true,width:"100px",render:failedShards=>failedShards},{field:"startTimeInMillis",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.startTimeColumnTitle",{defaultMessage:"Date created"}),truncateText:true,sortable:true,render:startTimeInMillis=>external_kbnSharedDeps_React_default.a.createElement(DataPlaceholder,{data:startTimeInMillis},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:startTimeInMillis}))},{field:"durationInMillis",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.durationColumnTitle",{defaultMessage:"Duration"}),truncateText:true,sortable:true,width:"100px",render:(durationInMillis,{state:state})=>{if(state===application_constants["i"].IN_PROGRESS){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})}return external_kbnSharedDeps_React_default.a.createElement(DataPlaceholder,{data:durationInMillis},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.table.durationColumnValueLabel",defaultMessage:"{seconds}s",values:{seconds:Math.ceil(durationInMillis/1e3)}}))}},{name:i18n.translate("xpack.snapshotRestore.snapshotList.table.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:({snapshot:snapshot,repository:repository,state:state})=>{const canRestore=state===application_constants["i"].SUCCESS||state===application_constants["i"].PARTIAL;const label=canRestore?i18n.translate("xpack.snapshotRestore.snapshotList.table.actionRestoreTooltip",{defaultMessage:"Restore"}):state===application_constants["i"].IN_PROGRESS?i18n.translate("xpack.snapshotRestore.snapshotList.table.actionRestoreDisabledInProgressTooltip",{defaultMessage:`Can't restore in-progress snapshot`}):i18n.translate("xpack.snapshotRestore.snapshotList.table.actionRestoreDisabledInvalidTooltip",{defaultMessage:`Can't restore invalid snapshot`});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],snapshot_table_extends({"aria-label":i18n.translate("xpack.snapshotRestore.snapshotList.table.actionRestoreAriaLabel",{defaultMessage:"Store snapshot `{name}`",values:{name:snapshot}}),iconType:"importAction",color:"primary","data-test-subj":"srsnapshotListRestoreActionButton"},Object(public_["reactRouterNavigate"])(history,linkToRestoreSnapshot(repository,snapshot)),{isDisabled:!canRestore})))}},{render:({snapshot:snapshot,repository:repository})=>external_kbnSharedDeps_React_default.a.createElement(SnapshotDeleteProvider,null,deleteSnapshotPrompt=>{const isDeleteDisabled=Boolean(lastSuccessfulManagedSnapshot)?snapshot===lastSuccessfulManagedSnapshot.snapshot:false;const label=isDeleteDisabled?i18n.translate("xpack.snapshotRestore.snapshotList.table.deleteManagedRepositorySnapshotTooltip",{defaultMessage:"You must store the last successful snapshot in a managed repository."}):i18n.translate("xpack.snapshotRestore.snapshotList.table.actionDeleteTooltip",{defaultMessage:"Delete"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":i18n.translate("xpack.snapshotRestore.snapshotList.table.actionDeleteAriaLabel",{defaultMessage:`Delete snapshot '{name}'`,values:{name:snapshot}}),iconType:"trash",color:"danger","data-test-subj":"srsnapshotListDeleteActionButton",onClick:()=>deleteSnapshotPrompt([{snapshot:snapshot,repository:repository}],onSnapshotDeleted),isDisabled:isDeleteDisabled}))})}],width:"100px"}];const sorting={sort:{field:"startTimeInMillis",direction:"desc"}};const pagination={initialPageSize:20,pageSizeOptions:[10,20,50]};const searchSchema={fields:{repository:{type:"string"},policyName:{type:"string"}}};const selection={onSelectionChange:newSelectedItems=>setSelectedItems(newSelectedItems),selectable:({snapshot:snapshot})=>Boolean(lastSuccessfulManagedSnapshot)?snapshot!==lastSuccessfulManagedSnapshot.snapshot:true,selectableMessage:selectable=>{if(!selectable){return i18n.translate("xpack.snapshotRestore.snapshotList.table.deleteManagedRepositorySnapshotDescription",{defaultMessage:"You must retain the last successful snapshot in a managed repository."})}return""}};const search={toolsLeft:selectedItems.length?external_kbnSharedDeps_React_default.a.createElement(SnapshotDeleteProvider,null,deleteSnapshotPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>deleteSnapshotPrompt(selectedItems.map(({snapshot:snapshot,repository:repository})=>({snapshot:snapshot,repository:repository})),onSnapshotDeleted),color:"danger","data-test-subj":"srSnapshotListBulkDeleteActionButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.table.deleteSnapshotButton",defaultMessage:"Delete {count, plural, one {snapshot} other {snapshots}}",values:{count:selectedItems.length}}))):undefined,toolsRight:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"secondary",iconType:"refresh",onClick:reload,"data-test-subj":"reloadButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.table.reloadSnapshotsButton",defaultMessage:"Reload"})),box:{incremental:true,schema:searchSchema},filters:[{type:"field_value_selection",field:"repository",name:i18n.translate("xpack.snapshotRestore.snapshotList.table.repositoryFilterLabel",{defaultMessage:"Repository"}),multiSelect:false,options:repositories.map(repository=>({value:repository,view:repository}))}],defaultQuery:policyFilter?external_kbnSharedDeps_ElasticEui_["Query"].parse(`policyName="${policyFilter}"`,{schema:{...searchSchema,strict:true}}):repositoryFilter?external_kbnSharedDeps_ElasticEui_["Query"].parse(`repository="${repositoryFilter}"`,{schema:{...searchSchema,strict:true}}):""};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{items:snapshots,itemId:"uuid",columns:columns,search:search,sorting:sorting,isSelectable:true,selection:selection,pagination:pagination,rowProps:()=>({"data-test-subj":"row"}),cellProps:()=>({"data-test-subj":"cell"}),"data-test-subj":"snapshotTable"})};function snapshot_list_extends(){snapshot_list_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return snapshot_list_extends.apply(this,arguments)}const SnapshotList=({location:{search:search},history:history})=>{const{repositoryName:repositoryName,snapshotId:snapshotId}=useDecodedParams();const{error:error,isLoading:isLoading,data:{snapshots:snapshots=[],repositories:repositories=[],policies:policies=[],errors:errors={}},resendRequest:reload}=Object(services_http["x"])();const{uiMetricService:uiMetricService}=useServices();const openSnapshotDetailsUrl=(repositoryNameToOpen,snapshotIdToOpen)=>linkToSnapshot(repositoryNameToOpen,snapshotIdToOpen);const closeSnapshotDetails=()=>{history.push(`${application_constants["a"]}/snapshots`)};const onSnapshotDeleted=snapshotsDeleted=>{if(repositoryName&&snapshotId&&snapshotsDeleted.find(({snapshot:snapshot,repository:repository})=>snapshot===snapshotId&&repository===repositoryName)){closeSnapshotDetails()}if(snapshotsDeleted.length){reload()}};const[filteredRepository,setFilteredRepository]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[filteredPolicy,setFilteredPolicy]=Object(external_kbnSharedDeps_React_["useState"])(undefined);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(search){const parsedParams=Object(query_string["parse"])(search.replace(/^\?/,""),{sort:false});const{repository:repository,policy:policy}=parsedParams;if(policy&&policy!==filteredPolicy){setFilteredPolicy(String(policy));history.replace(`${application_constants["a"]}/snapshots`)}else if(repository&&repository!==filteredRepository){setFilteredRepository(String(repository));history.replace(`${application_constants["a"]}/snapshots`)}}},[filteredPolicy,filteredRepository,history,search]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{uiMetricService.trackUiMetric(application_constants["K"])},[uiMetricService]);let content;if(isLoading){content=external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.loadingSnapshotsDescription",defaultMessage:"Loading snapshots…"}))}else if(error){content=external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.loadingSnapshotsErrorMessage",defaultMessage:"Error loading snapshots"}),error:error})}else if(Object.keys(errors).length&&repositories.length===0){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.errorRepositoriesTitle",defaultMessage:"Some repositories contain errors"})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.repositoryWarningDescription",defaultMessage:"Go to {repositoryLink} to fix the errors.",values:{repositoryLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToRepositories()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryWarningLinkText",defaultMessage:"Repositories"}))}}))})}else if(repositories.length===0){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.noRepositoriesTitle",defaultMessage:"Start by registering a repository"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.noRepositoriesDescription",defaultMessage:"You need a place where your snapshots will live."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],snapshot_list_extends({},Object(public_["reactRouterNavigate"])(history,linkToAddRepository()),{fill:true,iconType:"plusInCircle","data-test-subj":"registerRepositoryButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.noRepositoriesAddButtonLabel",defaultMessage:"Register a repository"})))),"data-test-subj":"emptyPrompt"})}else if(snapshots.length===0){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.noSnapshotsTitle",defaultMessage:"You don't have any snapshots yet"})),body:external_kbnSharedDeps_React_default.a.createElement(shared_imports["e"],{privileges:constants["d"].map(name=>`cluster.${name}`)},({hasPrivileges:hasPrivileges})=>hasPrivileges?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.usePolicyDescription",defaultMessage:"Run a Snapshot Lifecycle Policy to create a snapshot. Snapshots can also be created by using {docLink}.",values:{docLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getSnapshotDocUrl(),target:"_blank","data-test-subj":"documentationLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.emptyPrompt.usePolicyDocLinkText",defaultMessage:"the Elasticsearch API"}))}})),external_kbnSharedDeps_React_default.a.createElement("p",null,policies.length===0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],snapshot_list_extends({},Object(public_["reactRouterNavigate"])(history,linkToAddPolicy()),{fill:true,iconType:"plusInCircle","data-test-subj":"addPolicyButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.addPolicyText",defaultMessage:"Create a policy"})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],snapshot_list_extends({},Object(public_["reactRouterNavigate"])(history,linkToPolicies()),{fill:true,iconType:"list","data-test-subj":"goToPoliciesButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.goToPoliciesText",defaultMessage:"View policies"})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.snapshotList.emptyPrompt.noSnapshotsDescription",defaultMessage:"Create a snapshot using the Elasticsearch API."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:documentationLinksService.getSnapshotDocUrl(),target:"_blank","data-test-subj":"documentationLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.emptyPrompt.noSnapshotsDocLinkText",defaultMessage:"Learn how to create a snapshot"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"link"}))))),"data-test-subj":"emptyPrompt"})}else{const repositoryErrorsWarning=Object.keys(errors).length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryWarningTitle",defaultMessage:"Some repositories contain errors"}),color:"warning",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryWarningDescription",defaultMessage:"Snapshots might load slowly. Go to {repositoryLink} to fix the errors.",values:{repositoryLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToRepositories()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.repositoryWarningLinkText",defaultMessage:"Repositories"}))}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):null;content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,repositoryErrorsWarning,external_kbnSharedDeps_React_default.a.createElement(SnapshotTable,{snapshots:snapshots,repositories:repositories,reload:reload,openSnapshotDetailsUrl:openSnapshotDetailsUrl,onSnapshotDeleted:onSnapshotDeleted,repositoryFilter:filteredRepository,policyFilter:filteredPolicy}))}return external_kbnSharedDeps_React_default.a.createElement("section",{"data-test-subj":"snapshotList"},repositoryName&&snapshotId?external_kbnSharedDeps_React_default.a.createElement(SnapshotDetails,{repositoryName:repositoryName,snapshotId:snapshotId,onClose:closeSnapshotDetails,onSnapshotDeleted:onSnapshotDeleted}):null,content)};var external_kbnSharedDeps_ElasticEuiLibServices_=__webpack_require__(30);const ShardsTable=({shards:shards})=>{const{i18n:i18n}=useServices();const Progress=({total:total,restored:restored,percent:percent})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.progressTooltipLabel",{defaultMessage:"{restored} of {total} restored",values:{restored:restored,total:total}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",textAlign:"center",style:{width:"100%"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{value:total===0?1:restored,max:total===0?1:total,size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),percent));const columns=[{field:"id",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.indexColumnTitle",{defaultMessage:"ID"}),width:"40px",render:(id,shard)=>shard.primary?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},id),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"right",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.shardTable.primaryTooltipLabel",defaultMessage:"Primary"})},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.shardTable.primaryAbbreviationText",defaultMessage:"P",description:"Used as an abbreviation for 'Primary', as in 'Primary shard'"}))))):id},{field:"stage",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.stageColumnTitle",{defaultMessage:"Stage"})},{field:"startTimeInMillis",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.startTimeColumnTitle",{defaultMessage:"Start time"}),render:startTimeInMillis=>startTimeInMillis?external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:startTimeInMillis}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})},{field:"stopTimeInMillis",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.endTimeColumnTitle",{defaultMessage:"End time"}),render:stopTimeInMillis=>stopTimeInMillis?external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:stopTimeInMillis}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})},{field:"totalTimeInMillis",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.durationColumnTitle",{defaultMessage:"Duration"}),render:totalTimeInMillis=>totalTimeInMillis?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.shardTable.durationValue",defaultMessage:"{seconds} {seconds, plural, one {second} other {seconds}}",values:{seconds:Math.ceil(totalTimeInMillis/1e3)}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})},{field:"repository",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.repositoryColumnTitle",{defaultMessage:"Repository"})},{field:"snapshot",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.snapshotColumnTitle",{defaultMessage:"Snapshot"})},{field:"version",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.versionColumnTitle",{defaultMessage:"Version"})},{field:"targetHost",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.targetHostColumnTitle",{defaultMessage:"Target host"})},{field:"targetNode",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.targetNodeColumnTitle",{defaultMessage:"Target node"})},{field:"bytesTotal",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.bytesColumnTitle",{defaultMessage:"Bytes"}),render:(bytesTotal,{bytesRecovered:bytesRecovered,bytesPercent:bytesPercent})=>external_kbnSharedDeps_React_default.a.createElement(Progress,{total:bytesTotal,restored:bytesRecovered,percent:bytesPercent})},{field:"filesTotal",name:i18n.translate("xpack.snapshotRestore.restoreList.shardTable.filesColumnTitle",{defaultMessage:"Files"}),render:(filesTotal,{filesRecovered:filesRecovered,filesPercent:filesPercent})=>external_kbnSharedDeps_React_default.a.createElement(Progress,{total:filesTotal,restored:filesRecovered,percent:filesPercent})}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{className:"snapshotRestore__shardsTable",compressed:true,items:shards,columns:columns})};const RestoreTable=external_kbnSharedDeps_React_default.a.memo(({restores:restores})=>{const{i18n:i18n,uiMetricService:uiMetricService}=useServices();const[tableState,setTableState]=Object(external_kbnSharedDeps_React_["useState"])({page:{},sort:{}});const[expandedIndices,setExpandedIndices]=Object(external_kbnSharedDeps_React_["useState"])({});const getPagination=()=>{const{index:pageIndex,size:pageSize}=tableState.page;return{pageIndex:pageIndex!==null&&pageIndex!==void 0?pageIndex:0,pageSize:pageSize!==null&&pageSize!==void 0?pageSize:20,totalItemCount:restores.length,pageSizeOptions:[10,20,50]}};const getSorting=()=>{const{field:sortField,direction:sortDirection}=tableState.sort;return{sort:{field:sortField!==null&&sortField!==void 0?sortField:"isComplete",direction:sortDirection!==null&&sortDirection!==void 0?sortDirection:"asc"}}};const getRestores=()=>{const newRestoresList=[...restores];const{sort:{field:field,direction:direction}}=getSorting();const{pageIndex:pageIndex,pageSize:pageSize}=getPagination();const sortedRestores=Object(external_kbnSharedDeps_Lodash_["orderBy"])(newRestoresList,[field],[direction]);return sortedRestores.slice(pageIndex*pageSize,(pageIndex+1)*pageSize)};const onTableChange=({page:page={},sort:sort={}})=>{setTableState({page:page,sort:sort})};const toggleIndexRestoreDetails=restore=>{const{index:index}=restore;const isExpanded=Boolean(itemIdToExpandedRowMap[index])?false:true;if(isExpanded===true){uiMetricService.trackUiMetric(application_constants["C"])}setExpandedIndices({...itemIdToExpandedRowMap,[index]:isExpanded})};const itemIdToExpandedRowMap=Object(external_kbnSharedDeps_React_["useMemo"])(()=>restores.reduce((acc,restore)=>{const{index:index,shards:shards}=restore;if(expandedIndices[index]){acc[index]=external_kbnSharedDeps_React_default.a.createElement(ShardsTable,{shards:shards})}return acc},{}),[expandedIndices,restores]);const columns=[{field:"index",name:i18n.translate("xpack.snapshotRestore.restoreList.table.indexColumnTitle",{defaultMessage:"Index"}),truncateText:true,sortable:true},{field:"isComplete",name:i18n.translate("xpack.snapshotRestore.restoreList.table.statusColumnTitle",{defaultMessage:"Status"}),truncateText:true,sortable:true,render:isComplete=>isComplete?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"success"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.table.statusColumn.completeLabel",defaultMessage:"Complete"})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.table.statusColumn.inProgressLabel",defaultMessage:"In progress"}))},{field:"latestActivityTimeInMillis",name:i18n.translate("xpack.snapshotRestore.restoreList.table.lastActivityTitle",{defaultMessage:"Last activity"}),truncateText:true,render:(latestActivityTimeInMillis,{isComplete:isComplete})=>isComplete?external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:latestActivityTimeInMillis}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.table.lastActivityColumn.nowLabel",defaultMessage:"now"})},{field:"shards",name:i18n.translate("xpack.snapshotRestore.restoreList.table.shardsCompletedTitle",{defaultMessage:"Shards completed"}),truncateText:true,render:shards=>shards.filter(shard=>Boolean(shard.stopTimeInMillis)).length},{field:"shards",name:i18n.translate("xpack.snapshotRestore.restoreList.table.shardsInProgressTitle",{defaultMessage:"Shards in progress"}),truncateText:true,render:shards=>shards.filter(shard=>!Boolean(shard.stopTimeInMillis)).length},{align:external_kbnSharedDeps_ElasticEuiLibServices_["RIGHT_ALIGNMENT"],width:"40px",isExpander:true,render:item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:()=>toggleIndexRestoreDetails(item),"aria-label":itemIdToExpandedRowMap[item.index]?"Collapse":"Expand",iconType:itemIdToExpandedRowMap[item.index]?"arrowUp":"arrowDown"})}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:getRestores(),itemId:"index",itemIdToExpandedRowMap:itemIdToExpandedRowMap,isExpandable:true,columns:columns,sorting:getSorting(),pagination:getPagination(),onChange:onTableChange,rowProps:restore=>({"data-test-subj":"row",onClick:()=>toggleIndexRestoreDetails(restore)}),cellProps:()=>({"data-test-subj":"cell"}),"data-test-subj":"restoresTable"})});const ONE_SECOND_MS=1e3;const TEN_SECONDS_MS=10*1e3;const THIRTY_SECONDS_MS=30*1e3;const ONE_MINUTE_MS=60*1e3;const FIVE_MINUTES_MS=5*60*1e3;const INTERVAL_OPTIONS=[TEN_SECONDS_MS,THIRTY_SECONDS_MS,ONE_MINUTE_MS,FIVE_MINUTES_MS];const RestoreList=()=>{const[isIntervalMenuOpen,setIsIntervalMenuOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[currentInterval,setCurrentInterval]=Object(external_kbnSharedDeps_React_["useState"])(INTERVAL_OPTIONS[1]);const{error:error,isLoading:isLoading,data:restores=[],isInitialRequest:isInitialRequest,resendRequest:resendRequest}=Object(services_http["u"])(currentInterval);const{uiMetricService:uiMetricService,history:history}=useServices();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{uiMetricService.trackUiMetric(application_constants["D"])},[uiMetricService]);let content;if(isInitialRequest){if(isLoading){content=external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.loadingRestoresDescription",defaultMessage:"Loading restores…"}))}else if(error){content=external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.loadingRestoresErrorMessage",defaultMessage:"Error loading restores"}),error:error})}}else{if(restores&&restores.length===0){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.emptyPromptTitle",defaultMessage:"No restored snapshots"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.emptyPromptDescription",defaultMessage:"Go to {snapshotsLink} to start a restore.",values:{snapshotsLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToSnapshots()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.emptyPromptDescriptionLink",defaultMessage:"Snapshots"}))}}))),"data-test-subj":"emptyPrompt"})}else{content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"flexStart",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"srRestoreListIntervalMenu",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:"arrowDown",iconSide:"right",onClick:()=>setIsIntervalMenuOpen(!isIntervalMenuOpen)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.intervalMenuButtonText",defaultMessage:"Refresh data every {interval}",values:{interval:currentInterval>=ONE_MINUTE_MS?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.intervalMenu.minutesIntervalValue",defaultMessage:"{minutes} {minutes, plural, one {minute} other {minutes}}",values:{minutes:Math.ceil(currentInterval/ONE_MINUTE_MS)}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.intervalMenu.secondsIntervalValue",defaultMessage:"{seconds} {seconds, plural, one {second} other {seconds}}",values:{seconds:Math.ceil(currentInterval/ONE_SECOND_MS)}})}})),isOpen:isIntervalMenuOpen,closePopover:()=>setIsIntervalMenuOpen(false),panelPaddingSize:"none",anchorPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:INTERVAL_OPTIONS.map(interval=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:interval,icon:"empty",onClick:()=>{resendRequest();setCurrentInterval(interval);setIsIntervalMenuOpen(false)}},interval>=ONE_MINUTE_MS?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.intervalMenu.minutesIntervalValue",defaultMessage:"{minutes} {minutes, plural, one {minute} other {minutes}}",values:{minutes:Math.ceil(interval/ONE_MINUTE_MS)}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.intervalMenu.secondsIntervalValue",defaultMessage:"{seconds} {seconds, plural, one {second} other {seconds}}",values:{seconds:Math.ceil(interval/ONE_SECOND_MS)}})))}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}):null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(RestoreTable,{restores:restores}))}}return external_kbnSharedDeps_React_default.a.createElement(shared_imports["e"],{privileges:constants["c"].map(name=>`index.${name}`)},({hasPrivileges:hasPrivileges,privilegesMissing:privilegesMissing})=>hasPrivileges?external_kbnSharedDeps_React_default.a.createElement("section",{"data-test-subj":"restoreList"},content):external_kbnSharedDeps_React_default.a.createElement(shared_imports["c"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.deniedPrivilegeTitle",defaultMessage:"You're missing index privileges"}),message:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreList.deniedPrivilegeDescription",defaultMessage:"To view snapshot restore status, you must have {privilegesCount, plural, one {this index privilege} other {these index privileges}} for one or more indices: {missingPrivileges}.",values:{missingPrivileges:privilegesMissing.index.join(", "),privilegesCount:privilegesMissing.index.length}})}))};const tab_summary_TabSummary=({policy:policy})=>{const{i18n:i18n,history:history}=useServices();const{version:version,name:name,modifiedDateMillis:modifiedDateMillis,snapshotName:snapshotName,repository:repository,schedule:schedule,nextExecutionMillis:nextExecutionMillis,config:config,stats:stats,retention:retention,isManagedPolicy:isManagedPolicy}=policy;const{includeGlobalState:includeGlobalState,ignoreUnavailable:ignoreUnavailable,indices:indices,partial:partial}=config||{includeGlobalState:undefined,ignoreUnavailable:undefined,indices:undefined,partial:undefined};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,isManagedPolicy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",color:"warning",iconType:"iInCircle",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.managedPolicyWarningTitle",defaultMessage:"This is a managed policy used by other systems. Any changes you make might affect how these systems operate."})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})):null,stats&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{title:stats.snapshotsTaken,description:i18n.translate("xpack.snapshotRestore.policyDetails.snapshotsTakenStat",{defaultMessage:"Snapshots"}),titleSize:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{title:stats.snapshotsFailed,description:i18n.translate("xpack.snapshotRestore.policyDetails.snapshotsFailedStat",{defaultMessage:"Failures"}),titleSize:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{title:stats.snapshotsDeleted,description:i18n.translate("xpack.snapshotRestore.policyDetails.snapshotsDeletedStat",{defaultMessage:"Deleted"}),titleSize:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{title:stats.snapshotDeletionFailures,description:i18n.translate("xpack.snapshotRestore.policyDetails.snapshotDeletionFailuresStat",{defaultMessage:"Deletion failures"}),titleSize:"s"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.generalTitle",defaultMessage:"General"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"version"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.versionLabel",defaultMessage:"Version"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},version)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"modified"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.modifiedDateLabel",defaultMessage:"Last modified"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:modifiedDateMillis})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"name"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.snapshotNameLabel",defaultMessage:"Snapshot name"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToSnapshots(undefined,name)),snapshotName))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"repository"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.repositoryLabel",defaultMessage:"Repository"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToRepository(repository)),repository)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"schedule"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.scheduleLabel",defaultMessage:"Schedule"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},schedule)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"execution"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.nextExecutionLabel",defaultMessage:"Next snapshot"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:nextExecutionMillis})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"indices"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.dataStreamsAndIndicesLabel",defaultMessage:"Data streams and indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(CollapsibleIndicesList,{indices:indices}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"includeGlobalState"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.ignoreUnavailableLabel",defaultMessage:"Ignore unavailable indices"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},ignoreUnavailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.ignoreUnavailableTrueLabel",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.ignoreUnavailableFalseLabel",defaultMessage:"No"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"partial"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.partialLabel",defaultMessage:"Allow partial shards"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},partial?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.partialTrueLabel",defaultMessage:"Yes"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.partialFalseLabel",defaultMessage:"No"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"includeGlobalState"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.includeGlobalStateLabel",defaultMessage:"Include global state"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},includeGlobalState===false?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.includeGlobalStateFalseLabel",defaultMessage:"No"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.includeGlobalStateTrueLabel",defaultMessage:"Yes"}))))),retention&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.retentionTitle",defaultMessage:"Retention"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},retention.expireAfterValue&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.expireAfterLabel",defaultMessage:"Delete after"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,retention.expireAfterValue,retention.expireAfterUnit)),retention.minCount&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.minCountLabel",defaultMessage:"Min count"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,retention.minCount)),retention.maxCount&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.maxCountLabel",defaultMessage:"Max count"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,retention.maxCount)))))};const TabHistory=({policy:policy})=>{const{lastSuccess:lastSuccess,lastFailure:lastFailure,nextExecutionMillis:nextExecutionMillis,name:name,repository:repository}=policy;const{history:history}=useServices();const renderLastSuccess=()=>{if(!lastSuccess){return null}const{time:time,snapshotName:snapshotName}=lastSuccess;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastSuccessTitle",defaultMessage:"Last successful snapshot"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"successDate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastSuccess.dateLabel",defaultMessage:"Date"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:time}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"successSnapshot"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastSuccess.snapshotNameLabel",defaultMessage:"Snapshot name"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],Object(public_["reactRouterNavigate"])(history,linkToSnapshot(repository,snapshotName)),snapshotName))))))};const renderLastFailure=()=>{if(!lastFailure){return null}const{time:time,snapshotName:snapshotName,details:details}=lastFailure;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastFailureTitle",defaultMessage:"Last snapshot failure"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"failureDate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastFailure.dateLabel",defaultMessage:"Date"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:time}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"failureSnapshot"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastFailure.snapshotNameLabel",defaultMessage:"Snapshot name"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},snapshotName))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{"data-test-subj":"failureDetails"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{"data-test-subj":"title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.lastFailure.detailsLabel",defaultMessage:"Details"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord","data-test-subj":"value"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{mode:"json",theme:"textmate",width:"100%",isReadOnly:true,value:JSON.stringify(details,null,2),setOptions:{showLineNumbers:false,tabSize:2},editorProps:{$blockScrolling:Infinity},minLines:6,maxLines:12,wrapEnabled:true,showGutter:false,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.snapshotRestore.policyDetails.lastFailure.detailsAriaLabel",{defaultMessage:`Last failure details for policy '{name}'`,values:{name:name}})}))))))};return lastSuccess||lastFailure?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,renderLastSuccess(),lastSuccess&&lastFailure?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null):null,renderLastFailure()):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.noHistoryMessage",defaultMessage:"This policy will run on {date} at {time}.",values:{date:external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:nextExecutionMillis,type:"date"}),time:external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:nextExecutionMillis,type:"time"})}})))};function policy_details_extends(){policy_details_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return policy_details_extends.apply(this,arguments)}const policy_details_TAB_SUMMARY="summary";const TAB_HISTORY="success";const tabToUiMetricMap={[policy_details_TAB_SUMMARY]:application_constants["o"],[TAB_HISTORY]:application_constants["n"]};const PolicyDetails=({policyName:policyName,onClose:onClose,onPolicyDeleted:onPolicyDeleted,onPolicyExecuted:onPolicyExecuted})=>{const{i18n:i18n,uiMetricService:uiMetricService,history:history}=useServices();const{error:error,data:policyDetails,resendRequest:reload}=Object(services_http["q"])(policyName);const[activeTab,setActiveTab]=Object(external_kbnSharedDeps_React_["useState"])(policy_details_TAB_SUMMARY);const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setActiveTab(policy_details_TAB_SUMMARY)},[policyName]);const tabOptions=[{id:policy_details_TAB_SUMMARY,name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.summaryTabTitle",defaultMessage:"Summary"})},{id:TAB_HISTORY,name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.historyTabTitle",defaultMessage:"History"})}];const renderTabs=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],null,tabOptions.map(tab=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:()=>{uiMetricService.trackUiMetric(tabToUiMetricMap[tab.id]);setActiveTab(tab.id)},isSelected:tab.id===activeTab,key:tab.id,"data-test-subj":"tab"},tab.name)));const renderBody=()=>{if(policyDetails){const{policy:policy}=policyDetails;switch(activeTab){case TAB_HISTORY:return external_kbnSharedDeps_React_default.a.createElement(TabHistory,{policy:policy});default:return external_kbnSharedDeps_React_default.a.createElement(tab_summary_TabSummary,{policy:policy})}}if(error){return renderError()}return renderLoading()};const renderLoading=()=>external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.loadingPolicyDescription",defaultMessage:"Loading policy…"}));const renderError=()=>{const notFound=error.status===404;const errorObject=notFound?{data:{error:i18n.translate("xpack.snapshotRestore.policyDetails.policyNotFoundErrorMessage",{defaultMessage:`The policy '{name}' does not exist.`,values:{name:policyName}})}}:error;return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.loadingPolicyErrorTitle",defaultMessage:"Error loading policy"}),error:errorObject})};const renderFooter=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"cross",flush:"left",onClick:onClose,"data-test-subj":"srPolicyDetailsFlyoutCloseButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.closeButtonLabel",defaultMessage:"Close"}))),policyDetails?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PolicyExecuteProvider,null,executePolicyPrompt=>external_kbnSharedDeps_React_default.a.createElement(PolicyDeleteProvider,null,deletePolicyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"policyActionMenu",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"policyActionMenuButton",iconSide:"right",onClick:()=>setIsPopoverOpen(!isPopoverOpen),iconType:"arrowDown",fill:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.manageButtonLabel",defaultMessage:"Manage policy"})),isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),panelPaddingSize:"none",anchorPosition:"rightUp",repositionOnScroll:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{"data-test-subj":"policyActionContextMenu",initialPanelId:0,panels:[{id:0,title:i18n.translate("xpack.snapshotRestore.policyDetails.managePanelTitle",{defaultMessage:"Policy options"}),items:[{name:i18n.translate("xpack.snapshotRestore.policyDetails.executeButtonLabel",{defaultMessage:"Run now"}),icon:"play",onClick:()=>{executePolicyPrompt(policyName,()=>setTimeout(()=>{onPolicyExecuted();reload()},2e3))},disabled:Boolean(policyDetails.policy.inProgress)},{name:i18n.translate("xpack.snapshotRestore.policyDetails.editButtonLabel",{defaultMessage:"Edit"}),icon:"pencil",...Object(public_["reactRouterNavigate"])(history,linkToEditPolicy(policyName))},{name:i18n.translate("xpack.snapshotRestore.policyDetails.deleteButtonLabel",{defaultMessage:"Delete"}),icon:"trash",disabled:policyDetails.policy.isManagedPolicy,onClick:()=>deletePolicyPrompt([policyName],onPolicyDeleted)}]}]}))))):null);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,"data-test-subj":"policyDetail","aria-labelledby":"srPolicyDetailsFlyoutTitle",size:"m",maxWidth:550},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"srPolicyDetailsFlyoutTitle","data-test-subj":"title"},policyName," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"refresh",color:"subdued","aria-label":i18n.translate("xpack.snapshotRestore.policyDetails.reloadButtonAriaLabel",{defaultMessage:"Reload"}),onClick:()=>reload()}))),policyDetails&&policyDetails.policy&&policyDetails.policy.inProgress?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(SectionLoading,{inline:true,size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],policy_details_extends({},Object(public_["reactRouterNavigate"])(history,linkToSnapshot(policyDetails.policy.repository,policyDetails.policy.inProgress.snapshotName)),{"data-test-subj":"inProgressSnapshotLink"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyDetails.inProgressSnapshotLinkText",defaultMessage:"'{snapshotName}' in progress",values:{snapshotName:policyDetails.policy.inProgress.snapshotName}})))):null,renderTabs()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],{"data-test-subj":"content"},renderBody()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,renderFooter()))};function policy_table_extends(){policy_table_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return policy_table_extends.apply(this,arguments)}const PolicyTable=({policies:policies,reload:reload,openPolicyDetailsUrl:openPolicyDetailsUrl,onPolicyDeleted:onPolicyDeleted,onPolicyExecuted:onPolicyExecuted})=>{const{i18n:i18n,uiMetricService:uiMetricService,history:history}=useServices();const[selectedItems,setSelectedItems]=Object(external_kbnSharedDeps_React_["useState"])([]);const columns=[{field:"name",name:i18n.translate("xpack.snapshotRestore.policyList.table.policyNameColumnTitle",{defaultMessage:"Policy"}),truncateText:true,sortable:true,render:(name,{inProgress:inProgress,isManagedPolicy:isManagedPolicy})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],policy_table_extends({},Object(public_["reactRouterNavigate"])(history,openPolicyDetailsUrl(name),()=>uiMetricService.trackUiMetric(application_constants["r"])),{"data-test-subj":"policyLink"}),name)," "),isManagedPolicy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.table.managedPolicyBadgeLabel",defaultMessage:"This is a managed policy"}),position:"right"})):null,inProgress?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:i18n.translate("xpack.snapshotRestore.policyList.table.inProgressTooltip",{defaultMessage:"Snapshot in progress"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}))):null)},{field:"snapshotName",name:i18n.translate("xpack.snapshotRestore.policyList.table.snapshotNameColumnTitle",{defaultMessage:"Snapshot name"}),sortable:true,render:(snapshotName,{lastFailure:lastFailure,lastSuccess:lastSuccess})=>{if(lastSuccess&&lastFailure&&lastFailure.time>lastSuccess.time){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",className:"snapshotRestorePolicyTableSnapshotFailureContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:i18n.translate("xpack.snapshotRestore.policyList.table.lastSnapshotFailedTooltip",{defaultMessage:"Last snapshot failed"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"alert",color:"danger"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},snapshotName)))}return snapshotName}},{field:"repository",name:i18n.translate("xpack.snapshotRestore.policyList.table.repositoryColumnTitle",{defaultMessage:"Repository"}),truncateText:true,sortable:true},{field:"schedule",name:i18n.translate("xpack.snapshotRestore.policyList.table.scheduleColumnTitle",{defaultMessage:"Schedule"}),truncateText:true,sortable:true},{field:"retention",name:i18n.translate("xpack.snapshotRestore.policyList.table.retentionColumnTitle",{defaultMessage:"Retention"}),render:retention=>retention?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"check","aria-label":i18n.translate("xpack.snapshotRestore.policyList.table.retentionColumnAriaLabel",{defaultMessage:"Retention configured"})}):null},{field:"nextExecutionMillis",name:i18n.translate("xpack.snapshotRestore.policyList.table.nextExecutionColumnTitle",{defaultMessage:"Next snapshot"}),truncateText:true,sortable:true,render:nextExecutionMillis=>external_kbnSharedDeps_React_default.a.createElement(FormattedDateTime,{epochMs:nextExecutionMillis})},{name:i18n.translate("xpack.snapshotRestore.policyList.table.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:({name:name,inProgress:inProgress,isManagedPolicy:isManagedPolicy})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PolicyExecuteProvider,null,executePolicyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:Boolean(inProgress)?i18n.translate("xpack.snapshotRestore.policyList.table.actionExecuteDisabledTooltip",{defaultMessage:"Policy is running"}):i18n.translate("xpack.snapshotRestore.policyList.table.actionExecuteTooltip",{defaultMessage:"Run now"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":i18n.translate("xpack.snapshotRestore.policyList.table.actionExecuteAriaLabel",{defaultMessage:`Run '{name}' immediately`,values:{name:name}}),iconType:"play",color:"primary","data-test-subj":"executePolicyButton",onClick:()=>executePolicyPrompt(name,onPolicyExecuted),disabled:Boolean(inProgress)})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:i18n.translate("xpack.snapshotRestore.policyList.table.actionEditTooltip",{defaultMessage:"Edit"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],policy_table_extends({"aria-label":i18n.translate("xpack.snapshotRestore.policyList.table.actionEditAriaLabel",{defaultMessage:`Edit policy '{name}'`,values:{name:name}}),iconType:"pencil",color:"primary"},Object(public_["reactRouterNavigate"])(history,linkToEditPolicy(name)),{"data-test-subj":"editPolicyButton"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PolicyDeleteProvider,null,deletePolicyPrompt=>{const label=!isManagedPolicy?i18n.translate("xpack.snapshotRestore.policyList.table.actionDeleteTooltip",{defaultMessage:"Delete"}):i18n.translate("xpack.snapshotRestore.policyList.table.deleteManagedPolicyTableActionTooltip",{defaultMessage:"You cannot delete a managed policy."});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":i18n.translate("xpack.snapshotRestore.policyList.table.actionDeleteAriaLabel",{defaultMessage:`Delete policy '{name}'`,values:{name:name}}),iconType:"trash",color:"danger","data-test-subj":"deletePolicyButton",onClick:()=>deletePolicyPrompt([name],onPolicyDeleted),isDisabled:isManagedPolicy}))})))}],width:"100px"}];const sorting={sort:{field:"name",direction:"asc"}};const pagination={initialPageSize:20,pageSizeOptions:[10,20,50]};const selection={onSelectionChange:newSelectedItems=>setSelectedItems(newSelectedItems),selectable:({isManagedPolicy:isManagedPolicy})=>!isManagedPolicy,selectableMessage:selectable=>{if(!selectable){return i18n.translate("xpack.snapshotRestore.policyList.table.deleteManagedPolicySelectTooltip",{defaultMessage:"You cannot delete a managed policy."})}return""}};const search={toolsLeft:selectedItems.length?external_kbnSharedDeps_React_default.a.createElement(PolicyDeleteProvider,null,deletePolicyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>deletePolicyPrompt(selectedItems.map(({name:name})=>name),onPolicyDeleted),color:"danger","data-test-subj":"srPolicyListBulkDeleteActionButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.table.deletePolicyButton",defaultMessage:"Delete {count, plural, one {policy} other {policies}}",values:{count:selectedItems.length}}))):undefined,toolsRight:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"reloadPolicies",color:"secondary",iconType:"refresh",onClick:reload,"data-test-subj":"reloadButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.table.reloadPoliciesButton",defaultMessage:"Reload"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],policy_table_extends({key:"createNewPolicy"},Object(public_["reactRouterNavigate"])(history,linkToAddPolicy()),{fill:true,iconType:"plusInCircle","data-test-subj":"createPolicyButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.table.addPolicyButton",defaultMessage:"Create a policy"}))],box:{incremental:true,schema:true},filters:[{type:"field_value_selection",field:"repository",name:i18n.translate("xpack.snapshotRestore.policyList.table.repositoryFilterLabel",{defaultMessage:"Repository"}),multiSelect:false,options:Object.keys(policies.reduce((repositoriesMap,policy)=>{repositoriesMap[policy.repository]=true;return repositoriesMap},{})).map(repository=>({value:repository,view:repository}))}]};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{className:"snapshotRestore__policyTable",items:policies,itemId:"name",columns:columns,search:search,sorting:sorting,selection:selection,pagination:pagination,isSelectable:true,rowProps:()=>({"data-test-subj":"row"}),cellProps:()=>({"data-test-subj":"cell"}),"data-test-subj":"policyTable"})};const PolicyRetentionSchedule=({retentionSettings:retentionSettings,onRetentionScheduleUpdated:onRetentionScheduleUpdated,isLoading:isLoading,error:error})=>{const{i18n:i18n}=useServices();const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const renderRetentionPanel=cronSchedule=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleDescription",defaultMessage:"The cron schedule for retaining snapshots is: {cronSchedule}.",values:{cronSchedule:external_kbnSharedDeps_React_default.a.createElement("strong",null,cronSchedule)}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RetentionExecuteModalProvider,null,executeRetentionPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleExecuteLinkTooltip",defaultMessage:"Run retention now"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"play",onClick:()=>executeRetentionPrompt(),"aria-label":i18n.translate("xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleExecuteLinkAriaLabel",{defaultMessage:"Run retention now"})})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RetentionSettingsUpdateModalProvider,null,updateRetentionPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleEditLinkTooltip",defaultMessage:"Edit retention schedule"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"pencil",onClick:()=>updateRetentionPrompt(cronSchedule,onRetentionScheduleUpdated),"aria-label":i18n.translate("xpack.snapshotRestore.policyRetentionSchedulePanel.retentionScheduleEditLinkAriaLabel",{defaultMessage:"Edit retention schedule"})})))))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null));const renderRetentionNotConfiguredCallout=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.noScheduleConfiguredWarningTitle",defaultMessage:"Retention not scheduled"}),color:"warning",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.noScheduleConfiguredWarningDescription",defaultMessage:"One or more policies have a retention period, but no retention is scheduled."})),external_kbnSharedDeps_React_default.a.createElement(RetentionExecuteModalProvider,null,executeRetentionPrompt=>external_kbnSharedDeps_React_default.a.createElement(RetentionSettingsUpdateModalProvider,null,updateRetentionSettingsPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"retentionActionMenu",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"retentionActionMenuButton",iconSide:"right",color:"warning",onClick:()=>setIsPopoverOpen(!isPopoverOpen),iconType:"arrowDown"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.manageRetentionButtonLabel",defaultMessage:"Manage retention"})),isOpen:isPopoverOpen,closePopover:()=>setIsPopoverOpen(false),panelPaddingSize:"none",anchorPosition:"rightUp",repositionOnScroll:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{"data-test-subj":"retentionActionContextMenu",initialPanelId:0,panels:[{id:0,title:i18n.translate("xpack.snapshotRestore.policyRetentionSchedulePanel.managePanelTitle",{defaultMessage:"Retention options"}),items:[{name:i18n.translate("xpack.snapshotRestore.policyRetentionSchedulePanel.executeButtonLabel",{defaultMessage:"Run now"}),icon:"play",onClick:()=>executeRetentionPrompt()},{name:i18n.translate("xpack.snapshotRestore.policyRetentionSchedulePanel.addButtonLabel",{defaultMessage:"Schedule"}),icon:"plusInCircle",onClick:()=>updateRetentionSettingsPrompt(undefined,onRetentionScheduleUpdated)}]}]}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null));if(isLoading){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{lines:1})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null))}if(error){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.errorFetchingRetentionScheduleTitle",defaultMessage:"Error fetching retention schedule"}),color:"danger",iconType:"alert"},error.data&&error.data.message?external_kbnSharedDeps_React_default.a.createElement("p",null,error.data.message):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"refresh",color:"danger",onClick:onRetentionScheduleUpdated},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyRetentionSchedulePanel.errorFetchingRetentionScheduleReloadButtonLabel",defaultMessage:"Reload"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null))}if(retentionSettings&&retentionSettings.retentionSchedule){return renderRetentionPanel(retentionSettings.retentionSchedule)}return renderRetentionNotConfiguredCallout()};function policy_list_extends(){policy_list_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return policy_list_extends.apply(this,arguments)}const PolicyList=({history:history})=>{const{policyName:policyName}=useDecodedParams();const{error:error,isLoading:isLoading,data:{policies:policies}={policies:undefined},resendRequest:reload}=Object(services_http["p"])();const{uiMetricService:uiMetricService}=useServices();const{isLoading:isLoadingRetentionSettings,error:retentionSettingsError,data:retentionSettings,resendRequest:reloadRetentionSettings}=Object(services_http["v"])();const openPolicyDetailsUrl=newPolicyName=>linkToPolicy(newPolicyName);const closePolicyDetails=()=>{history.push(`${application_constants["a"]}/policies`)};const onPolicyDeleted=policiesDeleted=>{if(policyName&&policiesDeleted.includes(policyName)){closePolicyDetails()}if(policiesDeleted.length){reload()}};const onPolicyExecuted=()=>{reload()};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{uiMetricService.trackUiMetric(application_constants["q"])},[uiMetricService]);let content;if(isLoading){content=external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.loadingPoliciesDescription",defaultMessage:"Loading policies…"}))}else if(error){content=external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.LoadingPoliciesErrorMessage",defaultMessage:"Error loading policies"}),error:error})}else if(policies&&policies.length===0){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.emptyPromptTitle",defaultMessage:"Create your first snapshot policy"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.emptyPromptDescription",defaultMessage:"A policy automates the creation and deletion of snapshots."}))),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],policy_list_extends({},Object(public_["reactRouterNavigate"])(history,linkToAddPolicy()),{fill:true,iconType:"plusInCircle","data-test-subj":"createPolicyButton"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.createPolicyButton",defaultMessage:"Create a policy"})),"data-test-subj":"emptyPrompt"})}else{const policySchedules=policies.map(policy=>policy.schedule);const hasDuplicateSchedules=policySchedules.length>new Set(policySchedules).size;const hasRetention=Boolean(policies.find(policy=>policy.retention));content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,hasDuplicateSchedules?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyScheduleWarningTitle",defaultMessage:"Two or more policies have the same schedule"}),color:"warning",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyScheduleWarningDescription",defaultMessage:"Only one snapshot can be taken at a time. To avoid snapshot failures, edit or delete the policies."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):null,hasRetention?external_kbnSharedDeps_React_default.a.createElement(PolicyRetentionSchedule,{retentionSettings:retentionSettings,onRetentionScheduleUpdated:reloadRetentionSettings,isLoading:isLoadingRetentionSettings,error:retentionSettingsError}):null,external_kbnSharedDeps_React_default.a.createElement(PolicyTable,{policies:policies||[],reload:reload,openPolicyDetailsUrl:openPolicyDetailsUrl,onPolicyDeleted:onPolicyDeleted,onPolicyExecuted:onPolicyExecuted}))}return external_kbnSharedDeps_React_default.a.createElement(shared_imports["e"],{privileges:constants["d"].map(name=>`cluster.${name}`)},({hasPrivileges:hasPrivileges,privilegesMissing:privilegesMissing})=>hasPrivileges?external_kbnSharedDeps_React_default.a.createElement("section",{"data-test-subj":"policyList"},policyName?external_kbnSharedDeps_React_default.a.createElement(PolicyDetails,{policyName:policyName,onClose:closePolicyDetails,onPolicyDeleted:onPolicyDeleted,onPolicyExecuted:onPolicyExecuted}):null,content):external_kbnSharedDeps_React_default.a.createElement(shared_imports["c"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.deniedPrivilegeTitle",defaultMessage:"You're missing cluster privileges"}),message:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.policyList.deniedPrivilegeDescription",defaultMessage:"To manage Snapshot Lifecycle Policies, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",values:{missingPrivileges:privilegesMissing.cluster.join(", "),privilegesCount:privilegesMissing.cluster.length}})}))};const SnapshotRestoreHome=({match:{params:{section:section}},history:history})=>{const{slm_ui:slmUi}=useConfig();const tabs=[{id:"snapshots",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.snapshotsTabTitle",defaultMessage:"Snapshots"})},{id:"repositories",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.repositoriesTabTitle",defaultMessage:"Repositories"})},{id:"restore_status",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.restoreTabTitle",defaultMessage:"Restore Status"})}];if(slmUi.enabled){tabs.splice(2,0,{id:"policies",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.policiesTabTitle",defaultMessage:"Policies"})})}const onSectionChange=newSection=>{history.push(encodeURI(`${application_constants["a"]}/${encodeURIComponent(newSection)}`))};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{breadcrumbService.setBreadcrumbs(section||"home");docTitleService.setTitle(section||"home")},[section]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"appTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.snapshotRestoreTitle",defaultMessage:"Snapshot and Restore"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:documentationLinksService.getRepositoryTypeDocUrl(),target:"_blank",iconType:"help","data-test-subj":"documentationLink"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.snapshotRestoreDocsLinkText",defaultMessage:"Snapshot and Restore docs"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.home.snapshotRestoreDescription",defaultMessage:"Use repositories to store and recover backups of your Elasticsearch indices and clusters."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],null,tabs.map(tab=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{onClick:()=>onSectionChange(tab.id),isSelected:tab.id===section,key:tab.id,"data-test-subj":tab.id.toLowerCase()+"_tab"},tab.name))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`${application_constants["a"]}/repositories/:repositoryName*`,component:RepositoryList}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`${application_constants["a"]}/snapshots`,component:SnapshotList}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`${application_constants["a"]}/snapshots/:repositoryName*/:snapshotId`,component:SnapshotList}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`${application_constants["a"]}/restore_status`,component:RestoreList}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`${application_constants["a"]}/policies/:policyName*`,component:PolicyList}))))};const RepositoryAdd=({history:history,location:{search:search}})=>{const section="repositories";const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[saveError,setSaveError]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{breadcrumbService.setBreadcrumbs("repositoryAdd");docTitleService.setTitle("repositoryAdd")},[]);const onSave=async newRepository=>{setIsSaving(true);setSaveError(null);const{name:name}=newRepository;const{error:error}=await Object(services_http["b"])(newRepository);setIsSaving(false);if(error){setSaveError(error)}else{const{redirect:redirect}=Object(query_string["parse"])(search.replace(/^\?/,""),{sort:false});history.push(redirect?redirect:encodeURI(`${application_constants["a"]}/${encodeURIComponent(section)}/${encodeURIComponent(name)}`))}};const emptyRepository={name:"",type:null,settings:{}};const renderSaveError=()=>saveError?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addRepository.savingRepositoryErrorTitle",defaultMessage:"Cannot register new repository"}),error:saveError,"data-test-subj":"saveRepositoryApiError"}):null;const clearSaveError=()=>{setSaveError(null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"pageTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addRepositoryTitle",defaultMessage:"Register repository"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(RepositoryForm,{repository:emptyRepository,isSaving:isSaving,saveError:renderSaveError(),clearSaveError:clearSaveError,onSave:onSave})))};const RepositoryEdit=({history:history})=>{const{i18n:i18n}=useServices();const{name:name}=useDecodedParams();const section="repositories";Object(external_kbnSharedDeps_React_["useEffect"])(()=>{breadcrumbService.setBreadcrumbs("repositoryEdit");docTitleService.setTitle("repositoryEdit")},[]);const[repository,setRepository]=Object(external_kbnSharedDeps_React_["useState"])({name:"",type:null,settings:{}});const{error:repositoryError,isLoading:loadingRepository,data:repositoryData}=Object(services_http["s"])(name);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(repositoryData&&repositoryData.repository){setRepository(repositoryData.repository)}},[repositoryData]);const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[saveError,setSaveError]=Object(external_kbnSharedDeps_React_["useState"])(null);const onSave=async editedRepository=>{setIsSaving(true);setSaveError(null);const{error:error}=await Object(services_http["h"])(editedRepository);setIsSaving(false);if(error){setSaveError(error)}else{history.push(encodeURI(`${application_constants["a"]}/${encodeURIComponent(section)}/${encodeURIComponent(name)}`))}};const renderLoading=()=>external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editRepository.loadingRepositoryDescription",defaultMessage:"Loading repository details…"}));const renderError=()=>{const notFound=repositoryError.status===404;const errorObject=notFound?{data:{error:i18n.translate("xpack.snapshotRestore.editRepository.repositoryNotFoundErrorMessage",{defaultMessage:`The repository '{name}' does not exist.`,values:{name:name}})}}:repositoryError;return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editRepository.loadingRepositoryErrorTitle",defaultMessage:"Error loading repository details"}),error:errorObject})};const renderSaveError=()=>saveError?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editRepository.savingRepositoryErrorTitle",defaultMessage:"Cannot save repository"}),error:saveError}):null;const clearSaveError=()=>{setSaveError(null)};const renderContent=()=>{if(loadingRepository){return renderLoading()}if(repositoryError){return renderError()}const{isManagedRepository:isManagedRepository}=repositoryData;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,isManagedRepository?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"m",color:"warning",iconType:"iInCircle",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editRepository.managedRepositoryWarningTitle",defaultMessage:"This is a managed repository. Changing this repository might affect other systems that use it. Proceed with caution."})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})):null,external_kbnSharedDeps_React_default.a.createElement(RepositoryForm,{repository:repository,isManagedRepository:isManagedRepository,isEditing:true,isSaving:isSaving,saveError:renderSaveError(),clearSaveError:clearSaveError,onSave:onSave}))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editRepositoryTitle",defaultMessage:"Edit repository"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),renderContent()))};const RestoreSnapshot=({history:history})=>{const{i18n:i18n}=useServices();const{repositoryName:repositoryName,snapshotId:snapshotId}=useDecodedParams();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{breadcrumbService.setBreadcrumbs("restoreSnapshot");docTitleService.setTitle("restoreSnapshot")},[]);const[snapshotDetails,setSnapshotDetails]=Object(external_kbnSharedDeps_React_["useState"])({});const{error:snapshotError,isLoading:loadingSnapshot,data:snapshotData}=Object(services_http["w"])(repositoryName,snapshotId);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(snapshotData){setSnapshotDetails(snapshotData)}},[snapshotData]);const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[saveError,setSaveError]=Object(external_kbnSharedDeps_React_["useState"])(null);const onSave=async restoreSettings=>{setIsSaving(true);setSaveError(null);const{error:error}=await Object(services_http["j"])(repositoryName,snapshotId,restoreSettings);if(error){setIsSaving(false);setSaveError(error)}else{setTimeout(()=>{setIsSaving(false);history.push(`${application_constants["a"]}/restore_status`)},5*1e3)}};const renderLoading=()=>external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreSnapshot.loadingSnapshotDescription",defaultMessage:"Loading snapshot details…"}));const renderError=()=>{const notFound=snapshotError.status===404;const errorObject=notFound?{data:{error:i18n.translate("xpack.snapshotRestore.restoreSnapshot.snapshotNotFoundErrorMessage",{defaultMessage:`The snapshot '{snapshot}' does not exist in repository '{repository}'.`,values:{snapshot:snapshotId,repository:repositoryName}})}}:snapshotError;return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreSnapshot.loadingSnapshotErrorTitle",defaultMessage:"Error loading snapshot details"}),error:errorObject})};const renderSaveError=()=>saveError?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreSnapshot.executeRestoreErrorTitle",defaultMessage:"Unable to restore snapshot"}),error:saveError}):null;const clearSaveError=()=>{setSaveError(null)};const renderContent=()=>{if(loadingSnapshot){return renderLoading()}if(snapshotError){return renderError()}return external_kbnSharedDeps_React_default.a.createElement(RestoreSnapshotForm,{snapshotDetails:snapshotDetails,isSaving:isSaving,saveError:renderSaveError(),clearSaveError:clearSaveError,onSave:onSave})};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.restoreSnapshotTitle",defaultMessage:"Restore '{snapshot}'",values:{snapshot:snapshotId}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),renderContent()))};const PolicyAdd=({history:history,location:{pathname:pathname}})=>{const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[saveError,setSaveError]=Object(external_kbnSharedDeps_React_["useState"])(null);const{error:errorLoadingIndices,isLoading:isLoadingIndices,data:data}=Object(services_http["o"])();const{indices:indices,dataStreams:dataStreams}=data!==null&&data!==void 0?data:{indices:[],dataStreams:[]};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{breadcrumbService.setBreadcrumbs("policyAdd");docTitleService.setTitle("policyAdd")},[]);const onSave=async newPolicy=>{setIsSaving(true);setSaveError(null);const{name:name}=newPolicy;const{error:error}=await Object(services_http["a"])(newPolicy);setIsSaving(false);if(error){setSaveError(error)}else{history.push(encodeURI(`${application_constants["a"]}/policies/${encodeURIComponent(name)}`))}};const onCancel=()=>{history.push(`${application_constants["a"]}/policies`)};const emptyPolicy={name:"",snapshotName:"",schedule:application_constants["c"],repository:"",config:{},retention:{expireAfterValue:"",expireAfterUnit:constants["g"].DAY,maxCount:"",minCount:""},isManagedPolicy:false};const renderSaveError=()=>saveError?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addPolicy.savingPolicyErrorTitle",defaultMessage:"Cannot create new policy"}),error:saveError,"data-test-subj":"savePolicyApiError"}):null;const clearSaveError=()=>{setSaveError(null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"pageTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addPolicyTitle",defaultMessage:"Create policy"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),isLoadingIndices?external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addPolicy.loadingIndicesDescription",defaultMessage:"Loading available indices…"})):errorLoadingIndices?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.addPolicy.LoadingIndicesErrorMessage",defaultMessage:"Error loading available indices"}),error:errorLoadingIndices}):external_kbnSharedDeps_React_default.a.createElement(PolicyForm,{policy:emptyPolicy,indices:indices,dataStreams:dataStreams,currentUrl:pathname,isSaving:isSaving,saveError:renderSaveError(),clearSaveError:clearSaveError,onSave:onSave,onCancel:onCancel})))};const PolicyEdit=({history:history,location:{pathname:pathname}})=>{const{name:name}=useDecodedParams();const{i18n:i18n}=useServices();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{breadcrumbService.setBreadcrumbs("policyEdit");docTitleService.setTitle("policyEdit")},[]);const[policy,setPolicy]=Object(external_kbnSharedDeps_React_["useState"])({name:"",snapshotName:"",schedule:"",repository:"",config:{},retention:{expireAfterValue:"",expireAfterUnit:constants["g"].DAY,maxCount:"",minCount:""},isManagedPolicy:false});const{error:errorLoadingIndices,isLoading:isLoadingIndices,data:indicesData}=Object(services_http["o"])();const{error:errorLoadingPolicy,isLoading:isLoadingPolicy,data:policyData}=Object(services_http["q"])(name);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(policyData!==null&&policyData!==void 0&&policyData.policy){const{policy:policyToEdit}=policyData;const policyFormData={name:policyToEdit.name,snapshotName:policyToEdit.snapshotName,schedule:policyToEdit.schedule,repository:policyToEdit.repository,config:policyToEdit.config,retention:policyToEdit.retention,isManagedPolicy:policyToEdit.isManagedPolicy};setPolicy(policyFormData)}},[policyData]);const[isSaving,setIsSaving]=Object(external_kbnSharedDeps_React_["useState"])(false);const[saveError,setSaveError]=Object(external_kbnSharedDeps_React_["useState"])(null);const onSave=async editedPolicy=>{setIsSaving(true);setSaveError(null);const{error:error}=await Object(services_http["g"])(editedPolicy);setIsSaving(false);if(error){setSaveError(error)}else{history.push(encodeURI(`${application_constants["a"]}/policies/${encodeURIComponent(name)}`))}};const onCancel=()=>{history.push(encodeURI(`${application_constants["a"]}/policies/${encodeURIComponent(name)}`))};const renderLoading=()=>errorLoadingPolicy?external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicy.loadingPolicyDescription",defaultMessage:"Loading policy details…"})):external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicy.loadingIndicesDescription",defaultMessage:"Loading available indices…"}));const renderError=()=>{if(errorLoadingPolicy){const notFound=errorLoadingPolicy.status===404;const errorObject=notFound?{data:{error:i18n.translate("xpack.snapshotRestore.editPolicy.policyNotFoundErrorMessage",{defaultMessage:`The policy '{name}' does not exist.`,values:{name:name}})}}:errorLoadingPolicy;return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicy.loadingPolicyErrorTitle",defaultMessage:"Error loading policy details"}),error:errorObject})}if(errorLoadingIndices){return external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicy.LoadingIndicesErrorMessage",defaultMessage:"Error loading available indices"}),error:errorLoadingIndices})}};const renderSaveError=()=>saveError?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicy.savingPolicyErrorTitle",defaultMessage:"Cannot save policy"}),error:saveError}):null;const clearSaveError=()=>{setSaveError(null)};const renderContent=()=>{if(isLoadingPolicy||isLoadingIndices){return renderLoading()}if(errorLoadingPolicy||errorLoadingIndices){return renderError()}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,policy.isManagedPolicy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"m",color:"warning",iconType:"iInCircle",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicy.managedPolicyWarningTitle",defaultMessage:"This is a managed policy. Changing this policy might affect other systems that use it. Proceed with caution."})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})):null,external_kbnSharedDeps_React_default.a.createElement(PolicyForm,{policy:policy,dataStreams:indicesData.dataStreams,indices:indicesData.indices,currentUrl:pathname,isEditing:true,isSaving:isSaving,saveError:renderSaveError(),clearSaveError:clearSaveError,onSave:onSave,onCancel:onCancel}))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"pageTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.editPolicyTitle",defaultMessage:"Edit policy"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),renderContent()))};const App=()=>{const{slm_ui:slmUi}=useConfig();const{apiError:apiError}=Object(shared_imports["g"])();const sections=["repositories","snapshots","restore_status"];if(slmUi.enabled){sections.push("policies")}const sectionsRegex=sections.join("|");return apiError?external_kbnSharedDeps_React_default.a.createElement(shared_imports["d"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.app.checkingPrivilegesErrorMessage",defaultMessage:"Error fetching user privileges from the server."}),error:apiError}):external_kbnSharedDeps_React_default.a.createElement(shared_imports["e"],{privileges:constants["b"].map(name=>`cluster.${name}`)},({isLoading:isLoading,hasPrivileges:hasPrivileges,privilegesMissing:privilegesMissing})=>isLoading?external_kbnSharedDeps_React_default.a.createElement(SectionLoading,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.app.checkingPrivilegesDescription",defaultMessage:"Checking privileges…"})):hasPrivileges?external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"snapshotRestoreApp"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/add_repository",component:RepositoryAdd}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/edit_repository/:name*",component:RepositoryEdit}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`/:section(${sectionsRegex})/:repositoryName?/:snapshotId*`,component:SnapshotRestoreHome}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{exact:true,from:"/restore/:repositoryName",to:"/snapshots"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/restore/:repositoryName/:snapshotId*",component:RestoreSnapshot}),slmUi.enabled&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/add_policy",component:PolicyAdd}),slmUi.enabled&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/edit_policy/:name*",component:PolicyEdit}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{from:"/",to:`/${application_constants["f"]}`}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{from:"",to:`/${application_constants["f"]}`}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(shared_imports["c"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.app.deniedPrivilegeTitle",defaultMessage:"You're missing cluster privileges"}),message:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.snapshotRestore.app.deniedPrivilegeDescription",defaultMessage:"To use Snapshot and Restore, you must have {privilegesCount, plural, one {this cluster privilege} other {these cluster privileges}}: {missingPrivileges}.",values:{missingPrivileges:privilegesMissing.cluster.join(", "),privilegesCount:privilegesMissing.cluster.length}})})))};const AppProviders=({appDependencies:appDependencies,children:children})=>{const{core:core}=appDependencies;const{i18n:{Context:I18nContext},http:http}=core;return external_kbnSharedDeps_React_default.a.createElement(shared_imports["a"],{httpClient:http,privilegesEndpoint:`${constants["a"]}privileges`},external_kbnSharedDeps_React_default.a.createElement(I18nContext,null,external_kbnSharedDeps_React_default.a.createElement(AppContextProvider,{value:appDependencies},children)))};const AppWithRouter=({history:history})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:history},external_kbnSharedDeps_React_default.a.createElement(App,null));const renderApp=(elem,dependencies)=>{Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(AppProviders,{appDependencies:dependencies},external_kbnSharedDeps_React_default.a.createElement(AppWithRouter,{history:dependencies.services.history})),elem);return()=>{Object(external_kbnSharedDeps_ReactDom_["unmountComponentAtNode"])(elem)}};async function mountManagementSection(coreSetup,services,config,params){const{element:element,setBreadcrumbs:setBreadcrumbs,history:history}=params;const[core]=await coreSetup.getStartServices();const{docLinks:docLinks,chrome:{docTitle:docTitle}}=core;docTitleService.setup(docTitle.change);breadcrumbService.setup(setBreadcrumbs);documentationLinksService.setup(docLinks);const appDependencies={core:core,config:config,services:{httpService:services_http["l"],uiMetricService:services.uiMetricService,i18n:external_kbnSharedDeps_KbnI18n_["i18n"],history:history}};const unmountAppCallback=renderApp(element,appDependencies);return()=>{docTitle.reset();unmountAppCallback()}}}}]);