/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["securitySolution_bundle_jsonpfunction"]=window["securitySolution_bundle_jsonpfunction"]||[]).push([[7],Array(113).concat([function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"g",(function(){return LinkButton}));__webpack_require__.d(__webpack_exports__,"f",(function(){return LinkAnchor}));__webpack_require__.d(__webpack_exports__,"d",(function(){return HostDetailsLink}));__webpack_require__.d(__webpack_exports__,"h",(function(){return NetworkDetailsLink}));__webpack_require__.d(__webpack_exports__,"a",(function(){return CaseDetailsLink}));__webpack_require__.d(__webpack_exports__,"c",(function(){return GoogleLink}));__webpack_require__.d(__webpack_exports__,"i",(function(){return PortOrServiceNameLink}));__webpack_require__.d(__webpack_exports__,"e",(function(){return Ja3FingerprintLink}));__webpack_require__.d(__webpack_exports__,"b",(function(){return CertificateFingerprintLink}));__webpack_require__.d(__webpack_exports__,"j",(function(){return ReputationLink}));__webpack_require__.d(__webpack_exports__,"k",(function(){return WhoIsLink}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var constants=__webpack_require__(2);var field_renderers=__webpack_require__(265);var helpers=__webpack_require__(225);var link_to=__webpack_require__(112);var network=__webpack_require__(182);var kibana=__webpack_require__(104);var validators=__webpack_require__(368);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var translations=__webpack_require__(312);const CASE_DETAILS_LINK_ARIA=detailName=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.case.caseTable.caseDetailsLinkAria",{values:{detailName:detailName},defaultMessage:"click to visit case with title {detailName}"});var types=__webpack_require__(3);const DEFAULT_NUMBER_OF_LINK=5;const LinkButton=({children:children,...props})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],props,children);const LinkAnchor=({children:children,...props})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],props,children);const PortContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"PortContainer",componentId:"sc-1eyd59i-0"})(["& svg{position:relative;top:-1px;}"]);const HostDetailsLinkComponent=({children:children,hostName:hostName,isButton:isButton})=>{const{formatUrl:formatUrl,search:search}=Object(link_to["o"])(types["a"].hosts);const{navigateToApp:navigateToApp}=Object(kibana["h"])().services.application;const goToHostDetails=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{ev.preventDefault();navigateToApp(`${constants["f"]}:${types["a"].hosts}`,{path:Object(link_to["h"])(encodeURIComponent(hostName),search)})},[hostName,navigateToApp,search]);return isButton?external_kbnSharedDeps_React_default.a.createElement(LinkButton,{onClick:goToHostDetails,href:formatUrl(Object(link_to["h"])(encodeURIComponent(hostName)))},children?children:hostName):external_kbnSharedDeps_React_default.a.createElement(LinkAnchor,{onClick:goToHostDetails,href:formatUrl(Object(link_to["h"])(encodeURIComponent(hostName)))},children?children:hostName)};const HostDetailsLink=external_kbnSharedDeps_React_default.a.memo(HostDetailsLinkComponent);const allowedUrlSchemes=["http://","https://"];const ExternalLink=external_kbnSharedDeps_React_default.a.memo(({url:url,children:children,idx:idx,overflowIndexStart:overflowIndexStart=DEFAULT_NUMBER_OF_LINK,allItemsLimit:allItemsLimit=DEFAULT_NUMBER_OF_LINK})=>{const lastVisibleItemIndex=overflowIndexStart-1;const lastItemIndex=allItemsLimit-1;const lastIndexToShow=Math.max(0,Math.min(lastVisibleItemIndex,lastItemIndex));const inAllowlist=allowedUrlSchemes.some(scheme=>url.indexOf(scheme)===0);return url&&inAllowlist&&!Object(validators["a"])(url)&&children?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:url,position:"top","data-test-subj":"externalLinkTooltip"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:url,target:"_blank",rel:"noopener","data-test-subj":"externalLink"},children),!Object(external_kbnSharedDeps_LodashFp_["isNil"])(idx)&&idx<lastIndexToShow&&external_kbnSharedDeps_React_default.a.createElement(Comma,{"data-test-subj":"externalLinkComma"}))):null});ExternalLink.displayName="ExternalLink";const NetworkDetailsLinkComponent=({children:children,ip:ip,flowTarget:flowTarget=network["FlowTarget"].source,isButton:isButton})=>{const{formatUrl:formatUrl,search:search}=Object(link_to["o"])(types["a"].network);const{navigateToApp:navigateToApp}=Object(kibana["h"])().services.application;const goToNetworkDetails=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{ev.preventDefault();navigateToApp(`${constants["f"]}:${types["a"].network}`,{path:Object(link_to["j"])(encodeURIComponent(Object(helpers["c"])(ip)),flowTarget,search)})},[flowTarget,ip,navigateToApp,search]);return isButton?external_kbnSharedDeps_React_default.a.createElement(LinkButton,{href:formatUrl(Object(link_to["j"])(encodeURIComponent(Object(helpers["c"])(ip)))),onClick:goToNetworkDetails},children?children:ip):external_kbnSharedDeps_React_default.a.createElement(LinkAnchor,{onClick:goToNetworkDetails,href:formatUrl(Object(link_to["j"])(encodeURIComponent(Object(helpers["c"])(ip))))},children?children:ip)};const NetworkDetailsLink=external_kbnSharedDeps_React_default.a.memo(NetworkDetailsLinkComponent);const CaseDetailsLinkComponent=({children:children,detailName:detailName,subCaseId:subCaseId,title:title})=>{const{formatUrl:formatUrl,search:search}=Object(link_to["o"])(types["a"].case);const{navigateToApp:navigateToApp}=Object(kibana["h"])().services.application;const goToCaseDetails=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{ev.preventDefault();navigateToApp(`${constants["f"]}:${types["a"].case}`,{path:Object(link_to["b"])({id:detailName,search:search,subCaseId:subCaseId})})},[detailName,navigateToApp,search,subCaseId]);return external_kbnSharedDeps_React_default.a.createElement(LinkAnchor,{onClick:goToCaseDetails,href:formatUrl(Object(link_to["b"])({id:detailName,subCaseId:subCaseId})),"data-test-subj":"case-details-link","aria-label":CASE_DETAILS_LINK_ARIA(title!==null&&title!==void 0?title:detailName)},children?children:detailName)};const CaseDetailsLink=external_kbnSharedDeps_React_default.a.memo(CaseDetailsLinkComponent);CaseDetailsLink.displayName="CaseDetailsLink";const CreateCaseLink=external_kbnSharedDeps_React_default.a.memo(({children:children})=>{const{formatUrl:formatUrl,search:search}=Object(link_to["o"])(types["a"].case);const{navigateToApp:navigateToApp}=Object(kibana["h"])().services.application;const goToCreateCase=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{ev.preventDefault();navigateToApp(`${constants["f"]}:${types["a"].case}`,{path:Object(link_to["f"])(search)})},[navigateToApp,search]);return external_kbnSharedDeps_React_default.a.createElement(LinkAnchor,{onClick:goToCreateCase,href:formatUrl(Object(link_to["f"])())},children)});CreateCaseLink.displayName="CreateCaseLink";const GoogleLink=external_kbnSharedDeps_React_default.a.memo(({children:children,link:link})=>external_kbnSharedDeps_React_default.a.createElement(ExternalLink,{url:`https://www.google.com/search?q=${encodeURIComponent(link)}`},children?children:link));GoogleLink.displayName="GoogleLink";const PortOrServiceNameLink=external_kbnSharedDeps_React_default.a.memo(({children:children,portOrServiceName:portOrServiceName})=>external_kbnSharedDeps_React_default.a.createElement(PortContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"port-or-service-name-link",href:`https://www.iana.org/assignments/service-names-port-numbers/service-names-port-numbers.xhtml?search=${encodeURIComponent(String(portOrServiceName))}`,target:"_blank"},children?children:portOrServiceName)));PortOrServiceNameLink.displayName="PortOrServiceNameLink";const Ja3FingerprintLink=external_kbnSharedDeps_React_default.a.memo(({children:children,ja3Fingerprint:ja3Fingerprint})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"ja3-fingerprint-link",href:`https://sslbl.abuse.ch/ja3-fingerprints/${encodeURIComponent(ja3Fingerprint)}`,target:"_blank"},children?children:ja3Fingerprint));Ja3FingerprintLink.displayName="Ja3FingerprintLink";const CertificateFingerprintLink=external_kbnSharedDeps_React_default.a.memo(({children:children,certificateFingerprint:certificateFingerprint})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"certificate-fingerprint-link",href:`https://sslbl.abuse.ch/ssl-certificates/sha1/${encodeURIComponent(certificateFingerprint)}`,target:"_blank"},children?children:certificateFingerprint));CertificateFingerprintLink.displayName="CertificateFingerprintLink";var DefaultReputationLink;(function(DefaultReputationLink){DefaultReputationLink["virustotal.com"]="virustotal.com";DefaultReputationLink["talosIntelligence.com"]="talosIntelligence.com"})(DefaultReputationLink||(DefaultReputationLink={}));function isDefaultReputationLink(name){return name===DefaultReputationLink["virustotal.com"]||name===DefaultReputationLink["talosIntelligence.com"]}const isReputationLink=rowItem=>rowItem.url_template!==undefined&&rowItem.name!==undefined;const Comma=external_kbnSharedDeps_StyledComponents_default()("span").withConfig({displayName:"Comma",componentId:"sc-1eyd59i-1"})(["margin-right:5px;margin-left:5px;&::after{content:' ,';}"]);Comma.displayName="Comma";const defaultNameMapping={[DefaultReputationLink["virustotal.com"]]:translations["m"],[DefaultReputationLink["talosIntelligence.com"]]:translations["l"]};const ReputationLinkComponent=({overflowIndexStart:overflowIndexStart=DEFAULT_NUMBER_OF_LINK,allItemsLimit:allItemsLimit=DEFAULT_NUMBER_OF_LINK,showDomain:showDomain=false,domain:domain,direction:direction="row"})=>{const[ipReputationLinksSetting]=Object(kibana["l"])(constants["T"]);const ipReputationLinks=Object(external_kbnSharedDeps_React_["useMemo"])(()=>ipReputationLinksSetting===null||ipReputationLinksSetting===void 0?void 0:ipReputationLinksSetting.slice(0,allItemsLimit).filter(({url_template:url_template,name:name})=>!Object(external_kbnSharedDeps_LodashFp_["isNil"])(url_template)&&!Object(external_kbnSharedDeps_LodashFp_["isNil"])(name)&&!Object(validators["a"])(url_template)).map(({name:name,url_template:url_template})=>({name:isDefaultReputationLink(name)?defaultNameMapping[name]:name,url_template:url_template.replace(`{{ip}}`,encodeURIComponent(domain))})),[ipReputationLinksSetting,domain,defaultNameMapping,allItemsLimit]);const renderCallback=Object(external_kbnSharedDeps_React_["useCallback"])(rowItem=>{var _rowItem$name;return isReputationLink(rowItem)&&external_kbnSharedDeps_React_default.a.createElement(ExternalLink,{url:rowItem.url_template,overflowIndexStart:overflowIndexStart,allItemsLimit:allItemsLimit},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,(_rowItem$name=rowItem.name)!==null&&_rowItem$name!==void 0?_rowItem$name:domain))},[allItemsLimit,domain,overflowIndexStart]);return(ipReputationLinks===null||ipReputationLinks===void 0?void 0:ipReputationLinks.length)>0?external_kbnSharedDeps_React_default.a.createElement("section",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",justifyContent:"center",direction:direction,alignItems:"center","data-test-subj":"reputationLinkGroup"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},ipReputationLinks===null||ipReputationLinks===void 0?void 0:ipReputationLinks.slice(0,overflowIndexStart).map(({name:name,url_template:urlTemplate},id)=>external_kbnSharedDeps_React_default.a.createElement(ExternalLink,{allItemsLimit:ipReputationLinks.length,idx:id,overflowIndexStart:overflowIndexStart,url:urlTemplate,"data-test-subj":"externalLinkComponent",key:`reputationLink-${id}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,showDomain?domain:name!==null&&name!==void 0?name:domain)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(field_renderers["c"],{rowItems:ipReputationLinks,idPrefix:"moreReputationLink",render:renderCallback,moreMaxHeight:field_renderers["a"],overflowIndexStart:overflowIndexStart})))):null};ReputationLinkComponent.displayName="ReputationLinkComponent";const ReputationLink=external_kbnSharedDeps_React_default.a.memo(ReputationLinkComponent);const WhoIsLink=external_kbnSharedDeps_React_default.a.memo(({children:children,domain:domain})=>external_kbnSharedDeps_React_default.a.createElement(ExternalLink,{url:`https://www.iana.org/whois?q=${encodeURIComponent(domain)}`},children?children:domain));WhoIsLink.displayName="WhoIsLink"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Content}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DefaultDraggable}));__webpack_require__.d(__webpack_exports__,"c",(function(){return DraggableBadge}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(144);var _drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(116);var _empty_value__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(114);var _timelines_components_timeline_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(126);var _timelines_components_timeline_data_providers_provider__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(164);const tooltipContentIsExplicitlyNull=tooltipContent=>tooltipContent===null;const getDefaultWhenTooltipIsUnspecified=({field:field,tooltipContent:tooltipContent})=>tooltipContent!=null?tooltipContent:field;const Content=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({children:children,field:field,tooltipContent:tooltipContent,value:value})=>!tooltipContentIsExplicitlyNull(tooltipContent)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiToolTip"],{"data-test-subj":`${field}-tooltip`,content:getDefaultWhenTooltipIsUnspecified({tooltipContent:tooltipContent,field:field})},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,children?children:value)):react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,children?children:value));Content.displayName="Content";const DefaultDraggable=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({id:id,field:field,value:value,name:name,children:children,timelineId:timelineId,tooltipContent:tooltipContent,queryValue:queryValue})=>{const dataProviderProp=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>({and:[],enabled:true,id:Object(_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_4__["l"])(id),name:name?name:value!==null&&value!==void 0?value:"",excluded:false,kqlQuery:"",queryMatch:{field:field,value:queryValue?queryValue:value!==null&&value!==void 0?value:"",operator:_timelines_components_timeline_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_6__["c"]}}),[field,id,name,queryValue,value]);const renderCallback=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])((dataProvider,_,snapshot)=>snapshot.isDragging?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_3__["a"],null,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_timelines_components_timeline_data_providers_provider__WEBPACK_IMPORTED_MODULE_7__["a"],{dataProvider:dataProvider})):react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Content,{field:field,tooltipContent:tooltipContent,value:value},children),[children,field,tooltipContent,value]);if(value==null)return null;return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_3__["b"],{dataProvider:dataProviderProp,render:renderCallback,timelineId:timelineId})});DefaultDraggable.displayName="DefaultDraggable";const Badge=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiBadge"]).withConfig({displayName:"Badge",componentId:"ymm8sh-0"})(["vertical-align:top;"]);Badge.displayName="Badge";const DraggableBadgeComponent=({contextId:contextId,eventId:eventId,field:field,value:value,iconType:iconType,name:name,color:color="hollow",children:children,tooltipContent:tooltipContent,queryValue:queryValue})=>value!=null?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(DefaultDraggable,{id:`draggable-badge-default-draggable-${contextId}-${eventId}-${field}-${value}`,field:field,name:name,value:value,tooltipContent:tooltipContent,queryValue:queryValue},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Badge,{iconType:iconType,color:color,title:""},children?children:value!==""?value:Object(_empty_value__WEBPACK_IMPORTED_MODULE_5__["c"])())):null;DraggableBadgeComponent.displayName="DraggableBadgeComponent";const DraggableBadge=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(DraggableBadgeComponent);DraggableBadge.displayName="DraggableBadge"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"k",(function(){return droppableTimelineProvidersPrefix}));__webpack_require__.d(__webpack_exports__,"j",(function(){return droppableTimelineColumnsPrefix}));__webpack_require__.d(__webpack_exports__,"o",(function(){return getDraggableId}));__webpack_require__.d(__webpack_exports__,"n",(function(){return getDraggableFieldId}));__webpack_require__.d(__webpack_exports__,"s",(function(){return getTimelineProviderDroppableId}));__webpack_require__.d(__webpack_exports__,"r",(function(){return getTimelineProviderDraggableId}));__webpack_require__.d(__webpack_exports__,"p",(function(){return getDroppableId}));__webpack_require__.d(__webpack_exports__,"h",(function(){return draggableIsField}));__webpack_require__.d(__webpack_exports__,"l",(function(){return escapeDataProviderId}));__webpack_require__.d(__webpack_exports__,"t",(function(){return providerWasDroppedOnTimeline}));__webpack_require__.d(__webpack_exports__,"u",(function(){return userIsReArrangingProviders}));__webpack_require__.d(__webpack_exports__,"m",(function(){return fieldWasDroppedOnTimelineColumns}));__webpack_require__.d(__webpack_exports__,"f",(function(){return addProviderToTimeline}));__webpack_require__.d(__webpack_exports__,"e",(function(){return addFieldToTimelineColumns}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DRAG_TYPE_FIELD}));__webpack_require__.d(__webpack_exports__,"c",(function(){return IS_DRAGGING_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"d",(function(){return IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"g",(function(){return allowTopN}));__webpack_require__.d(__webpack_exports__,"q",(function(){return getTimelineIdFromColumnDroppableId}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DRAGGABLE_KEYBOARD_WRAPPER_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"i",(function(){return draggableKeyDownHandler}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var _accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(134);var _detections_components_alerts_table_default_config__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(204);var _containers_source__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(175);var _store_actions__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(224);var _timelines_store_timeline__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(108);var _timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(192);var _timelines_components_timeline_data_providers_helpers__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(287);var _common_types_timeline__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(106);const draggableIdPrefix="draggableId";const droppableIdPrefix="droppableId";const draggableContentPrefix=`${draggableIdPrefix}.content.`;const draggableTimelineProvidersPrefix=`${draggableIdPrefix}.timelineProviders.`;const draggableFieldPrefix=`${draggableIdPrefix}.field.`;const droppableContentPrefix=`${droppableIdPrefix}.content.`;const droppableFieldPrefix=`${droppableIdPrefix}.field.`;const droppableTimelineProvidersPrefix=`${droppableIdPrefix}.timelineProviders.`;const droppableTimelineColumnsPrefix=`${droppableIdPrefix}.timelineColumns.`;const droppableTimelineFlyoutBottomBarPrefix=`${droppableIdPrefix}.flyoutButton.`;const getDraggableId=dataProviderId=>`${draggableContentPrefix}${dataProviderId}`;const getDraggableFieldId=({contextId:contextId,fieldId:fieldId})=>`${draggableFieldPrefix}${escapeContextId(contextId)}.${escapeFieldId(fieldId)}`;const getTimelineProviderDroppableId=({groupIndex:groupIndex,timelineId:timelineId})=>`${droppableTimelineProvidersPrefix}${timelineId}.group.${groupIndex}`;const getTimelineProviderDraggableId=({dataProviderId:dataProviderId,groupIndex:groupIndex,timelineId:timelineId})=>`${draggableTimelineProvidersPrefix}${timelineId}.group.${groupIndex}.${dataProviderId}`;const getDroppableId=visualizationPlaceholderId=>`${droppableContentPrefix}${visualizationPlaceholderId}`;const sourceIsContent=result=>result.source.droppableId.startsWith(droppableContentPrefix);const sourceAndDestinationAreSameTimelineProviders=result=>{var _result$source$droppa,_result$destination$d,_result$destination;const regex=/^droppableId\.timelineProviders\.(\S+)\./;const sourceMatches=(_result$source$droppa=result.source.droppableId.match(regex))!==null&&_result$source$droppa!==void 0?_result$source$droppa:[];const destinationMatches=(_result$destination$d=(_result$destination=result.destination)===null||_result$destination===void 0?void 0:_result$destination.droppableId.match(regex))!==null&&_result$destination$d!==void 0?_result$destination$d:[];return sourceMatches.length>=2&&destinationMatches.length>=2&&sourceMatches[1]===destinationMatches[1]};const draggableIsContent=result=>result.draggableId.startsWith(draggableContentPrefix);const draggableIsField=result=>result.draggableId.startsWith(draggableFieldPrefix);const reasonIsDrop=result=>result.reason==="DROP";const destinationIsTimelineProviders=result=>result.destination!=null&&result.destination.droppableId.startsWith(droppableTimelineProvidersPrefix);const destinationIsTimelineColumns=result=>result.destination!=null&&result.destination.droppableId.startsWith(droppableTimelineColumnsPrefix);const destinationIsTimelineButton=result=>result.destination!=null&&result.destination.droppableId.startsWith(droppableTimelineFlyoutBottomBarPrefix);const getProviderIdFromDraggable=result=>result.draggableId.substring(result.draggableId.lastIndexOf(".")+1);const getFieldIdFromDraggable=result=>unEscapeFieldId(result.draggableId.substring(result.draggableId.lastIndexOf(".")+1));const escapeDataProviderId=path=>path.replace(/\./g,"_");const escapeContextId=path=>path.replace(/\./g,"_");const escapeFieldId=path=>path.replace(/\./g,"!!!DOT!!!");const unEscapeFieldId=path=>path.replace(/!!!DOT!!!/g,".");const providerWasDroppedOnTimeline=result=>reasonIsDrop(result)&&draggableIsContent(result)&&sourceIsContent(result)&&destinationIsTimelineProviders(result);const userIsReArrangingProviders=result=>reasonIsDrop(result)&&sourceAndDestinationAreSameTimelineProviders(result);const fieldWasDroppedOnTimelineColumns=result=>reasonIsDrop(result)&&draggableIsField(result)&&destinationIsTimelineColumns(result);const addProviderToTimeline=({activeTimelineDataProviders:activeTimelineDataProviders,dataProviders:dataProviders,dispatch:dispatch,result:result,timelineId:timelineId,noProviderFound:noProviderFound=_store_actions__WEBPACK_IMPORTED_MODULE_4__["b"].noProviderFound,onAddedToTimeline:onAddedToTimeline})=>{const providerId=getProviderIdFromDraggable(result);const providerToAdd=dataProviders[providerId];if(providerToAdd){Object(_timelines_components_timeline_data_providers_helpers__WEBPACK_IMPORTED_MODULE_7__["b"])({dataProviders:activeTimelineDataProviders,destination:result.destination,dispatch:dispatch,onAddedToTimeline:onAddedToTimeline,providerToAdd:providerToAdd,timelineId:timelineId})}else{dispatch(noProviderFound({id:providerId}))}};const linkFields={"signal.rule.name":"signal.rule.id","event.module":"rule.reference"};const addFieldToTimelineColumns=({upsertColumn:upsertColumn=_timelines_store_timeline__WEBPACK_IMPORTED_MODULE_5__["a"].upsertColumn,browserFields:browserFields,dispatch:dispatch,result:result,timelineId:timelineId})=>{var _alertsHeaders$find;const fieldId=getFieldIdFromDraggable(result);const allColumns=Object(_containers_source__WEBPACK_IMPORTED_MODULE_3__["a"])(browserFields);const column=allColumns[fieldId];const initColumnHeader=timelineId===_common_types_timeline__WEBPACK_IMPORTED_MODULE_8__["e"].detectionsPage||timelineId===_common_types_timeline__WEBPACK_IMPORTED_MODULE_8__["e"].detectionsRulesDetailsPage?(_alertsHeaders$find=_detections_components_alerts_table_default_config__WEBPACK_IMPORTED_MODULE_2__["b"].find(c=>c.id===fieldId))!==null&&_alertsHeaders$find!==void 0?_alertsHeaders$find:{}:{};if(column!=null){var _linkFields$fieldId;dispatch(upsertColumn({column:{category:column.category,columnHeaderType:"not-filtered",description:Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isString"])(column.description)?column.description:undefined,example:Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isString"])(column.example)?column.example:undefined,id:fieldId,linkField:(_linkFields$fieldId=linkFields[fieldId])!==null&&_linkFields$fieldId!==void 0?_linkFields$fieldId:undefined,type:column.type,aggregatable:column.aggregatable,width:_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_6__["b"],...initColumnHeader},id:timelineId,index:result.destination!=null?result.destination.index:0}))}else{dispatch(upsertColumn({column:{columnHeaderType:"not-filtered",id:fieldId,width:_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_6__["b"]},id:timelineId,index:result.destination!=null?result.destination.index:0}))}};const DRAG_TYPE_FIELD="drag-type-field";const IS_DRAGGING_CLASS_NAME="is-dragging";const IS_TIMELINE_FIELD_DRAGGING_CLASS_NAME="is-timeline-field-dragging";const allowTopN=({browserField:browserField,fieldName:fieldName})=>{var _browserField$aggrega,_browserField$type;const isAggregatable=(_browserField$aggrega=browserField===null||browserField===void 0?void 0:browserField.aggregatable)!==null&&_browserField$aggrega!==void 0?_browserField$aggrega:false;const fieldType=(_browserField$type=browserField===null||browserField===void 0?void 0:browserField.type)!==null&&_browserField$type!==void 0?_browserField$type:"";const isAllowedType=["boolean","geo-point","geo-shape","ip","keyword","number","numeric","string"].includes(fieldType);const isAllowlistedNonBrowserField=["signal.ancestors.depth","signal.ancestors.id","signal.ancestors.rule","signal.ancestors.type","signal.original_event.action","signal.original_event.category","signal.original_event.code","signal.original_event.created","signal.original_event.dataset","signal.original_event.duration","signal.original_event.end","signal.original_event.hash","signal.original_event.id","signal.original_event.kind","signal.original_event.module","signal.original_event.original","signal.original_event.outcome","signal.original_event.provider","signal.original_event.risk_score","signal.original_event.risk_score_norm","signal.original_event.sequence","signal.original_event.severity","signal.original_event.start","signal.original_event.timezone","signal.original_event.type","signal.original_time","signal.parent.depth","signal.parent.id","signal.parent.index","signal.parent.rule","signal.parent.type","signal.rule.created_by","signal.rule.description","signal.rule.enabled","signal.rule.false_positives","signal.rule.filters","signal.rule.from","signal.rule.id","signal.rule.immutable","signal.rule.index","signal.rule.interval","signal.rule.language","signal.rule.max_signals","signal.rule.name","signal.rule.note","signal.rule.output_index","signal.rule.query","signal.rule.references","signal.rule.risk_score","signal.rule.rule_id","signal.rule.saved_id","signal.rule.severity","signal.rule.size","signal.rule.tags","signal.rule.threat","signal.rule.threat.tactic.id","signal.rule.threat.tactic.name","signal.rule.threat.tactic.reference","signal.rule.threat.technique.id","signal.rule.threat.technique.name","signal.rule.threat.technique.reference","signal.rule.timeline_id","signal.rule.timeline_title","signal.rule.to","signal.rule.type","signal.rule.updated_by","signal.rule.version","signal.status"].includes(fieldName);return isAllowlistedNonBrowserField||isAggregatable&&isAllowedType};const getTimelineIdFromColumnDroppableId=droppableId=>droppableId.slice(droppableId.lastIndexOf(".")+1);const KEYBOARD_DRAG_OFFSET=20;const DRAGGABLE_KEYBOARD_WRAPPER_CLASS_NAME="draggable-keyboard-wrapper";const temporarilyDisableInteractiveChildTabIndexes=draggableElement=>{const interactiveChildren=draggableElement.querySelectorAll("a, button");interactiveChildren.forEach(interactiveChild=>{interactiveChild.setAttribute("tabindex","-1")});setTimeout(()=>{interactiveChildren.forEach(interactiveChild=>{interactiveChild.setAttribute("tabindex","0")})},0)};const draggableKeyDownHandler=({beginDrag:beginDrag,cancelDragActions:cancelDragActions,closePopover:closePopover,draggableElement:draggableElement,dragActions:dragActions,dragToLocation:dragToLocation,endDrag:endDrag,keyboardEvent:keyboardEvent,openPopover:openPopover,setDragActions:setDragActions})=>{let currentPosition=null;switch(keyboardEvent.key){case" ":if(!dragActions){if(closePopover!=null){closePopover()}setDragActions(beginDrag())}else{endDrag(dragActions);setDragActions(null)}break;case"Escape":cancelDragActions();break;case"Tab":temporarilyDisableInteractiveChildTabIndexes(draggableElement);break;case"ArrowUp":currentPosition=draggableElement.getBoundingClientRect();dragToLocation({dragActions:dragActions,position:{x:currentPosition.x,y:currentPosition.y-KEYBOARD_DRAG_OFFSET}});break;case"ArrowDown":currentPosition=draggableElement.getBoundingClientRect();dragToLocation({dragActions:dragActions,position:{x:currentPosition.x,y:currentPosition.y+KEYBOARD_DRAG_OFFSET}});break;case"ArrowLeft":currentPosition=draggableElement.getBoundingClientRect();dragToLocation({dragActions:dragActions,position:{x:currentPosition.x-KEYBOARD_DRAG_OFFSET,y:currentPosition.y}});break;case"ArrowRight":currentPosition=draggableElement.getBoundingClientRect();dragToLocation({dragActions:dragActions,position:{x:currentPosition.x+KEYBOARD_DRAG_OFFSET,y:currentPosition.y}});break;case"Enter":Object(_accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__["v"])(keyboardEvent);if(!dragActions&&openPopover!=null){openPopover()}break;default:break}}},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"i",(function(){return buildGlobalQuery}));__webpack_require__.d(__webpack_exports__,"k",(function(){return combineQueries}));__webpack_require__.d(__webpack_exports__,"h",(function(){return STATEFUL_EVENT_CSS_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"d",(function(){return DEFAULT_ICON_BUTTON_WIDTH}));__webpack_require__.d(__webpack_exports__,"p",(function(){return resolverIsShowing}));__webpack_require__.d(__webpack_exports__,"q",(function(){return showGlobalFilters}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ACTIONS_COLUMN_ARIA_COL_INDEX}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ARIA_COLUMN_INDEX_OFFSET}));__webpack_require__.d(__webpack_exports__,"e",(function(){return EVENTS_COUNT_BUTTON_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"j",(function(){return calculateTotalPages}));__webpack_require__.d(__webpack_exports__,"n",(function(){return onTimelineTabKeyPressed}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ACTIVE_TIMELINE_BUTTON_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"f",(function(){return FLYOUT_BUTTON_BAR_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"g",(function(){return FLYOUT_BUTTON_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"l",(function(){return focusActiveTimelineButton}));__webpack_require__.d(__webpack_exports__,"m",(function(){return focusUtilityBarAction}));__webpack_require__.d(__webpack_exports__,"o",(function(){return resetKeyboardFocus}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var memoize_one__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(222);var memoize_one__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(memoize_one__WEBPACK_IMPORTED_MODULE_1__);var _common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(134);var _common_lib_keury__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(158);var _data_providers_data_provider__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(126);var _styles__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(140);const isNumber=value=>!isNaN(Number(value));const convertDateFieldToQuery=(field,value)=>`${field}: ${isNumber(value)?value:new Date(value).valueOf()}`;const getBaseFields=memoize_one__WEBPACK_IMPORTED_MODULE_1___default()(browserFields=>{const baseFields=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])("base",browserFields);if(baseFields!=null&&baseFields.fields!=null){return Object.keys(baseFields.fields)}return[]});const getBrowserFieldPath=(field,browserFields)=>{const splitFields=field.split(".");const baseFields=getBaseFields(browserFields);if(baseFields.includes(field)){return["base","fields",field]}return[splitFields[0],"fields",field]};const checkIfFieldTypeIsDate=(field,browserFields)=>{const pathBrowserField=getBrowserFieldPath(field,browserFields);const browserField=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(pathBrowserField,browserFields);if(browserField!=null&&browserField.type==="date"){return true}return false};const convertNestedFieldToQuery=(field,value,browserFields)=>{const pathBrowserField=getBrowserFieldPath(field,browserFields);const browserField=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(pathBrowserField,browserFields);const nestedPath=browserField.subType.nested.path;const key=field.replace(`${nestedPath}.`,"");return`${nestedPath}: { ${key}: ${browserField.type==="date"?`"${value}"`:value} }`};const convertNestedFieldToExistQuery=(field,browserFields)=>{const pathBrowserField=getBrowserFieldPath(field,browserFields);const browserField=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(pathBrowserField,browserFields);const nestedPath=browserField.subType.nested.path;const key=field.replace(`${nestedPath}.`,"");return`${nestedPath}: { ${key}: * }`};const checkIfFieldTypeIsNested=(field,browserFields)=>{const pathBrowserField=getBrowserFieldPath(field,browserFields);const browserField=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(pathBrowserField,browserFields);if(browserField!=null&&browserField.subType&&browserField.subType.nested){return true}return false};const buildQueryMatch=(dataProvider,browserFields)=>`${dataProvider.excluded?"NOT ":""}${dataProvider.queryMatch.operator!==_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_4__["b"]&&dataProvider.type!==_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_4__["a"].template?checkIfFieldTypeIsNested(dataProvider.queryMatch.field,browserFields)?convertNestedFieldToQuery(dataProvider.queryMatch.field,dataProvider.queryMatch.value,browserFields):checkIfFieldTypeIsDate(dataProvider.queryMatch.field,browserFields)?convertDateFieldToQuery(dataProvider.queryMatch.field,dataProvider.queryMatch.value):`${dataProvider.queryMatch.field} : ${isNumber(dataProvider.queryMatch.value)?dataProvider.queryMatch.value:Object(_common_lib_keury__WEBPACK_IMPORTED_MODULE_3__["c"])(dataProvider.queryMatch.value)}`:checkIfFieldTypeIsNested(dataProvider.queryMatch.field,browserFields)?convertNestedFieldToExistQuery(dataProvider.queryMatch.field,browserFields):`${dataProvider.queryMatch.field} ${_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_4__["b"]}`}`.trim();const buildGlobalQuery=(dataProviders,browserFields)=>dataProviders.reduce((queries,dataProvider)=>{const flatDataProviders=[dataProvider,...dataProvider.and];const activeDataProviders=flatDataProviders.filter(flatDataProvider=>flatDataProvider.enabled);if(!activeDataProviders.length)return queries;const activeDataProvidersQueries=activeDataProviders.map(activeDataProvider=>buildQueryMatch(activeDataProvider,browserFields));const activeDataProvidersQueryMatch=activeDataProvidersQueries.join(" and ");return[...queries,activeDataProvidersQueryMatch]},[]).filter(queriesItem=>!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(queriesItem)).reduce((globalQuery,queryMatch,index,queries)=>{if(queries.length<=1)return queryMatch;return!index?`(${queryMatch})`:`${globalQuery} or (${queryMatch})`},"");const combineQueries=({config:config,dataProviders:dataProviders,indexPattern:indexPattern,browserFields:browserFields,filters:filters=[],kqlQuery:kqlQuery,kqlMode:kqlMode,isEventViewer:isEventViewer})=>{const kuery={query:"",language:kqlQuery.language};if(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(dataProviders)&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(kqlQuery.query)&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(filters)&&!isEventViewer){return null}else if(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(dataProviders)&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(kqlQuery.query)&&isEventViewer){return{filterQuery:Object(_common_lib_keury__WEBPACK_IMPORTED_MODULE_3__["b"])({config:config,queries:[kuery],indexPattern:indexPattern,filters:filters})}}else if(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(dataProviders)&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(kqlQuery.query)&&!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(filters)){return{filterQuery:Object(_common_lib_keury__WEBPACK_IMPORTED_MODULE_3__["b"])({config:config,queries:[kuery],indexPattern:indexPattern,filters:filters})}}else if(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(dataProviders)&&!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(kqlQuery.query)){kuery.query=`(${kqlQuery.query})`;return{filterQuery:Object(_common_lib_keury__WEBPACK_IMPORTED_MODULE_3__["b"])({config:config,queries:[kuery],indexPattern:indexPattern,filters:filters})}}else if(!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(dataProviders)&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(kqlQuery)){kuery.query=`(${buildGlobalQuery(dataProviders,browserFields)})`;return{filterQuery:Object(_common_lib_keury__WEBPACK_IMPORTED_MODULE_3__["b"])({config:config,queries:[kuery],indexPattern:indexPattern,filters:filters})}}const operatorKqlQuery=kqlMode==="filter"?"and":"or";const postpend=q=>`${!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(q)?` ${operatorKqlQuery} (${q})`:""}`;kuery.query=`((${buildGlobalQuery(dataProviders,browserFields)})${postpend(kqlQuery.query)})`;return{filterQuery:Object(_common_lib_keury__WEBPACK_IMPORTED_MODULE_3__["b"])({config:config,queries:[kuery],indexPattern:indexPattern,filters:filters})}};const STATEFUL_EVENT_CSS_CLASS_NAME="event-column-view";const DEFAULT_ICON_BUTTON_WIDTH=24;const resolverIsShowing=graphEventId=>graphEventId!=null&&graphEventId!=="";const showGlobalFilters=({globalFullScreen:globalFullScreen,graphEventId:graphEventId})=>globalFullScreen&&resolverIsShowing(graphEventId)?false:true;const ACTIONS_COLUMN_ARIA_COL_INDEX="1";const ARIA_COLUMN_INDEX_OFFSET=2;const EVENTS_COUNT_BUTTON_CLASS_NAME="local-events-count-button";const calculateTotalPages=({itemsCount:itemsCount,itemsPerPage:itemsPerPage})=>itemsCount===0||itemsPerPage===0?0:Math.ceil(itemsCount/itemsPerPage);const tableHasFocus=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_2__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${_styles__WEBPACK_IMPORTED_MODULE_5__["a"]}`));const onTimelineTabKeyPressed=({containerElement:containerElement,keyboardEvent:keyboardEvent,onSkipFocusBeforeEventsTable:onSkipFocusBeforeEventsTable,onSkipFocusAfterEventsTable:onSkipFocusAfterEventsTable})=>{const{shiftKey:shiftKey}=keyboardEvent;const eventsTableSkipFocus=Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_2__["m"])({containerElement:containerElement,getFocusedCell:_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_2__["i"],shiftKey:shiftKey,tableHasFocus:tableHasFocus,tableClassName:_styles__WEBPACK_IMPORTED_MODULE_5__["a"]});if(eventsTableSkipFocus!=="SKIP_FOCUS_NOOP"){Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_2__["v"])(keyboardEvent);Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_2__["n"])({onSkipFocusBackwards:onSkipFocusBeforeEventsTable,onSkipFocusForward:onSkipFocusAfterEventsTable,skipFocus:eventsTableSkipFocus})}};const ACTIVE_TIMELINE_BUTTON_CLASS_NAME="active-timeline-button";const FLYOUT_BUTTON_BAR_CLASS_NAME="timeline-flyout-button-bar";const FLYOUT_BUTTON_CLASS_NAME="timeline-flyout-button";const focusActiveTimelineButton=()=>{setTimeout(()=>{var _document$querySelect;(_document$querySelect=document.querySelector(`div.${FLYOUT_BUTTON_BAR_CLASS_NAME} .${ACTIVE_TIMELINE_BUTTON_CLASS_NAME}`))===null||_document$querySelect===void 0?void 0:_document$querySelect.focus()},0)};const focusUtilityBarAction=containerElement=>{var _containerElement$que;containerElement===null||containerElement===void 0?void 0:(_containerElement$que=containerElement.querySelector("div.siemUtilityBar__action:last-of-type button"))===null||_containerElement$que===void 0?void 0:_containerElement$que.focus()};const resetKeyboardFocus=()=>{var _document$querySelect2;(_document$querySelect2=document.querySelector("header.headerGlobalNav a.euiHeaderLogo"))===null||_document$querySelect2===void 0?void 0:_document$querySelect2.focus()}},function(module,__webpack_exports__,__webpack_require__){"use strict";var _common__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(357);__webpack_require__.d(__webpack_exports__,"Direction",(function(){return _common__WEBPACK_IMPORTED_MODULE_0__["a"]}));var _security_solution__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(193);if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["FlowTarget"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["HostsKpiQueries"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["HostsQueries"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["LastEventIndexKey"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkDnsFields"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkHttpFields"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkKpiQueries"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkQueries"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkTlsFields"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["NetworkUsersFields"]}));if(__webpack_require__.o(_security_solution__WEBPACK_IMPORTED_MODULE_1__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _security_solution__WEBPACK_IMPORTED_MODULE_1__["TimelineEventsQueries"]}));var _timeline__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(364);if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["FlowTarget"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["HostsKpiQueries"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["HostsQueries"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["LastEventIndexKey"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkDnsFields"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkHttpFields"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkKpiQueries"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkQueries"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkTlsFields"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["NetworkUsersFields"]}));if(__webpack_require__.o(_timeline__WEBPACK_IMPORTED_MODULE_2__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _timeline__WEBPACK_IMPORTED_MODULE_2__["TimelineEventsQueries"]}))},,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useInitSourcerer}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useSourcererScope}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_redux__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);var _store_sourcerer__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(137);var _store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(117);var _source__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(175);var _detections_components_user_info__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(173);var _timelines_store_timeline__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(108);var _common_types_timeline__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(106);var _hooks_use_selector__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(109);const useInitSourcerer=(scopeId=_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].default)=>{const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])();const initialTimelineSourcerer=Object(react__WEBPACK_IMPORTED_MODULE_0__["useRef"])(true);const initialDetectionSourcerer=Object(react__WEBPACK_IMPORTED_MODULE_0__["useRef"])(true);const{loading:loadingSignalIndex,isSignalIndexExists:isSignalIndexExists,signalIndexName:signalIndexName}=Object(_detections_components_user_info__WEBPACK_IMPORTED_MODULE_5__["c"])();const getConfigIndexPatternsSelector=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["d"].configIndexPatternsSelector(),[]);const ConfigIndexPatterns=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_8__["a"])(getConfigIndexPatternsSelector);const getSignalIndexNameSelector=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["d"].signalIndexNameSelector(),[]);const signalIndexNameSelector=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_8__["a"])(getSignalIndexNameSelector);const getTimelineSelector=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>_timelines_store_timeline__WEBPACK_IMPORTED_MODULE_6__["b"].getTimelineByIdSelector(),[]);const activeTimeline=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_8__["a"])(state=>getTimelineSelector(state,_common_types_timeline__WEBPACK_IMPORTED_MODULE_7__["e"].active));Object(_source__WEBPACK_IMPORTED_MODULE_4__["c"])(scopeId);Object(_source__WEBPACK_IMPORTED_MODULE_4__["c"])(_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].timeline);Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(!loadingSignalIndex&&signalIndexName!=null&&signalIndexNameSelector==null){dispatch(_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["a"].setSignalIndexName({signalIndexName:signalIndexName}))}},[dispatch,loadingSignalIndex,signalIndexName,signalIndexNameSelector]);Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(!loadingSignalIndex&&signalIndexName!=null&&signalIndexNameSelector==null&&(activeTimeline==null||activeTimeline!=null&&activeTimeline.savedObjectId==null)&&initialTimelineSourcerer.current){initialTimelineSourcerer.current=false;dispatch(_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["a"].setSelectedIndexPatterns({id:_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].timeline,selectedPatterns:[...ConfigIndexPatterns,signalIndexName]}))}else if(signalIndexNameSelector!=null&&(activeTimeline==null||activeTimeline!=null&&activeTimeline.savedObjectId==null)&&initialTimelineSourcerer.current){initialTimelineSourcerer.current=false;dispatch(_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["a"].setSelectedIndexPatterns({id:_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].timeline,selectedPatterns:[...ConfigIndexPatterns,signalIndexNameSelector]}))}},[activeTimeline,ConfigIndexPatterns,dispatch,loadingSignalIndex,signalIndexName,signalIndexNameSelector]);Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(scopeId===_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].detections&&isSignalIndexExists&&signalIndexName!=null&&initialDetectionSourcerer.current){initialDetectionSourcerer.current=false;dispatch(_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["a"].setSelectedIndexPatterns({id:scopeId,selectedPatterns:[signalIndexName]}))}else if(scopeId===_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].detections&&signalIndexNameSelector!=null&&initialTimelineSourcerer.current){initialDetectionSourcerer.current=false;dispatch(_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["a"].setSelectedIndexPatterns({id:scopeId,selectedPatterns:[signalIndexNameSelector]}))}},[dispatch,isSignalIndexExists,scopeId,signalIndexName,signalIndexNameSelector])};const useSourcererScope=(scope=_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_3__["SourcererScopeName"].default)=>{const sourcererScopeSelector=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>_store_sourcerer__WEBPACK_IMPORTED_MODULE_2__["d"].getSourcererScopeSelector(),[]);const SourcererScope=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_8__["a"])(state=>sourcererScopeSelector(state,scope));return SourcererScope}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Details}));__webpack_require__.d(__webpack_exports__,"b",(function(){return TokensFlexItem}));__webpack_require__.d(__webpack_exports__,"d",(function(){return isNillEmptyOrNotFinite}));__webpack_require__.d(__webpack_exports__,"c",(function(){return isFileEvent}));__webpack_require__.d(__webpack_exports__,"e",(function(){return isProcessStoppedOrTerminationEvent}));__webpack_require__.d(__webpack_exports__,"f",(function(){return showVia}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var lodash_fp__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);const deleteItemIdx=(data,idx)=>[...data.slice(0,idx),...data.slice(idx+1)];const findItem=(data,field)=>data.findIndex(d=>d.field===field);const getValues=(field,data)=>{const obj=data.find(d=>d.field===field);if(obj!=null&&obj.value!=null){return obj.value}return undefined};const Details=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.withConfig({displayName:"Details",componentId:"sc-1qa889y-0"})(["margin:5px 0 5px 10px;& .euiBadge{margin:2px 0 2px 0;}"]);Details.displayName="Details";const TokensFlexItem=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"]).withConfig({displayName:"TokensFlexItem",componentId:"sc-1qa889y-1"})(["margin-left:3px;"]);TokensFlexItem.displayName="TokensFlexItem";function isNillEmptyOrNotFinite(value){return Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isNumber"])(value)?!isFinite(value):Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(value)}const isFileEvent=({eventCategory:eventCategory,eventDataset:eventDataset})=>(eventCategory===null||eventCategory===void 0?void 0:eventCategory.toLowerCase())==="file"||(eventDataset===null||eventDataset===void 0?void 0:eventDataset.toLowerCase())==="file"||(eventDataset===null||eventDataset===void 0?void 0:eventDataset.toLowerCase())==="endpoint.events.file";const isProcessStoppedOrTerminationEvent=eventAction=>["process_stopped","termination_event"].includes(`${eventAction}`.toLowerCase());const showVia=eventAction=>["created","creation","deleted","deletion","file_create_event","file_delete_event","files-encrypted","load","modification","overwrite","rename"].includes(`${eventAction}`.toLowerCase());const excludeFileNameAndPath=({eventAction:eventAction,eventCategory:eventCategory,eventType:eventType})=>false},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return PreferenceFormattedDate}));__webpack_require__.d(__webpack_exports__,"d",(function(){return PreferenceFormattedDateFromPrimitive}));__webpack_require__.d(__webpack_exports__,"e",(function(){return PreferenceFormattedP1DTDate}));__webpack_require__.d(__webpack_exports__,"a",(function(){return FormattedDate}));__webpack_require__.d(__webpack_exports__,"b",(function(){return FormattedRelativePreferenceDate}));var moment_timezone__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(23);var moment_timezone__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(moment_timezone__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(74);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__);var _lib_kibana__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(104);var _empty_value__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(114);var _localized_date_tooltip__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(359);var _maybe_date__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(582);const PreferenceFormattedDate=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({value:value,dateFormat:dateFormat=Object(_lib_kibana__WEBPACK_IMPORTED_MODULE_3__["e"])()})=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,moment_timezone__WEBPACK_IMPORTED_MODULE_0___default.a.tz(value,Object(_lib_kibana__WEBPACK_IMPORTED_MODULE_3__["i"])()).format(dateFormat)));PreferenceFormattedDate.displayName="PreferenceFormattedDate";const PreferenceFormattedDateFromPrimitive=({value:value})=>{if(value==null){return Object(_empty_value__WEBPACK_IMPORTED_MODULE_4__["f"])(value)}const maybeDate=Object(_maybe_date__WEBPACK_IMPORTED_MODULE_6__["a"])(value);if(!maybeDate.isValid()){return Object(_empty_value__WEBPACK_IMPORTED_MODULE_4__["f"])(value)}const date=maybeDate.toDate();return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(PreferenceFormattedDate,{value:date})};PreferenceFormattedDateFromPrimitive.displayName="PreferenceFormattedDateFromPrimitive";const isP1DTFormatterSetting=formatNameFormatterPair=>Array.isArray(formatNameFormatterPair)&&formatNameFormatterPair[0]==="P1DT"&&formatNameFormatterPair.length===2;const PreferenceFormattedP1DTDate=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({value:value})=>{const FALLBACK_DATE_FORMAT_SCALED_P1DT=["P1DT","YYYY-MM-DD"];const[scaledDateFormatPreference]=Object(_lib_kibana__WEBPACK_IMPORTED_MODULE_3__["l"])("dateFormat:scaled");const maybeP1DTFormatter=Array.isArray(scaledDateFormatPreference)?scaledDateFormatPreference.find(isP1DTFormatterSetting):null;const p1dtFormat=Array.isArray(maybeP1DTFormatter)&&maybeP1DTFormatter.length===2?maybeP1DTFormatter[1]:FALLBACK_DATE_FORMAT_SCALED_P1DT[1];return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(PreferenceFormattedDate,{dateFormat:p1dtFormat,value:value})});PreferenceFormattedP1DTDate.displayName="PreferenceFormattedP1DTDate";const FormattedDate=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({value:value,fieldName:fieldName,className:className=""})=>{if(value==null){return Object(_empty_value__WEBPACK_IMPORTED_MODULE_4__["f"])(value)}const maybeDate=Object(_maybe_date__WEBPACK_IMPORTED_MODULE_6__["a"])(value);return maybeDate.isValid()?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_localized_date_tooltip__WEBPACK_IMPORTED_MODULE_5__["a"],{date:maybeDate.toDate(),fieldName:fieldName,className:className},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(PreferenceFormattedDate,{value:maybeDate.toDate()})):Object(_empty_value__WEBPACK_IMPORTED_MODULE_4__["f"])(value)});FormattedDate.displayName="FormattedDate";const FormattedRelativePreferenceDate=({value:value})=>{if(value==null){return Object(_empty_value__WEBPACK_IMPORTED_MODULE_4__["f"])(value)}const maybeDate=Object(_maybe_date__WEBPACK_IMPORTED_MODULE_6__["a"])(value);if(!maybeDate.isValid()){return Object(_empty_value__WEBPACK_IMPORTED_MODULE_4__["f"])(value)}const date=maybeDate.toDate();return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_localized_date_tooltip__WEBPACK_IMPORTED_MODULE_5__["a"],{date:date},moment_timezone__WEBPACK_IMPORTED_MODULE_0___default()(date).add(1,"hours").isBefore(new Date)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(PreferenceFormattedDate,{"data-test-subj":"preference-time",value:date}):react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__["FormattedRelative"],{"data-test-subj":"relative-time",value:date}))};const FormattedRelativePreferenceLabel=({value:value,preferenceLabel:preferenceLabel,relativeLabel:relativeLabel})=>{if(value==null){return null}const maybeDate=Object(_maybe_date__WEBPACK_IMPORTED_MODULE_6__["a"])(value);if(!maybeDate.isValid()){return null}return moment_timezone__WEBPACK_IMPORTED_MODULE_0___default()(maybeDate.toDate()).add(1,"hours").isBefore(new Date)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,preferenceLabel):react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,relativeLabel)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return BACK_TO_DETECTIONS}));__webpack_require__.d(__webpack_exports__,"X",(function(){return IMPORT_RULE}));__webpack_require__.d(__webpack_exports__,"Cb",(function(){return UPLOAD_VALUE_LISTS}));__webpack_require__.d(__webpack_exports__,"Db",(function(){return UPLOAD_VALUE_LISTS_TOOLTIP}));__webpack_require__.d(__webpack_exports__,"e",(function(){return ADD_NEW_RULE}));__webpack_require__.d(__webpack_exports__,"hb",(function(){return PAGE_TITLE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ADD_PAGE_TITLE}));__webpack_require__.d(__webpack_exports__,"O",(function(){return EDIT_PAGE_TITLE}));__webpack_require__.d(__webpack_exports__,"ib",(function(){return REFRESH}));__webpack_require__.d(__webpack_exports__,"i",(function(){return BATCH_ACTIONS}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ACTIVE}));__webpack_require__.d(__webpack_exports__,"Z",(function(){return INACTIVE}));__webpack_require__.d(__webpack_exports__,"j",(function(){return BATCH_ACTION_ACTIVATE_SELECTED}));__webpack_require__.d(__webpack_exports__,"k",(function(){return BATCH_ACTION_ACTIVATE_SELECTED_ERROR}));__webpack_require__.d(__webpack_exports__,"l",(function(){return BATCH_ACTION_DEACTIVATE_SELECTED}));__webpack_require__.d(__webpack_exports__,"m",(function(){return BATCH_ACTION_DEACTIVATE_SELECTED_ERROR}));__webpack_require__.d(__webpack_exports__,"r",(function(){return BATCH_ACTION_EXPORT_SELECTED}));__webpack_require__.d(__webpack_exports__,"q",(function(){return BATCH_ACTION_DUPLICATE_SELECTED}));__webpack_require__.d(__webpack_exports__,"n",(function(){return BATCH_ACTION_DELETE_SELECTED}));__webpack_require__.d(__webpack_exports__,"p",(function(){return BATCH_ACTION_DELETE_SELECTED_IMMUTABLE}));__webpack_require__.d(__webpack_exports__,"o",(function(){return BATCH_ACTION_DELETE_SELECTED_ERROR}));__webpack_require__.d(__webpack_exports__,"T",(function(){return EXPORT_FILENAME}));__webpack_require__.d(__webpack_exports__,"zb",(function(){return SUCCESSFULLY_EXPORTED_RULES}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ALL_RULES}));__webpack_require__.d(__webpack_exports__,"tb",(function(){return SEARCH_RULES}));__webpack_require__.d(__webpack_exports__,"sb",(function(){return SEARCH_PLACEHOLDER}));__webpack_require__.d(__webpack_exports__,"xb",(function(){return SHOWING_RULES}));__webpack_require__.d(__webpack_exports__,"ub",(function(){return SELECTED_RULES}));__webpack_require__.d(__webpack_exports__,"P",(function(){return EDIT_RULE_SETTINGS}));__webpack_require__.d(__webpack_exports__,"Q",(function(){return EDIT_RULE_SETTINGS_TOOLTIP}));__webpack_require__.d(__webpack_exports__,"L",(function(){return DUPLICATE}));__webpack_require__.d(__webpack_exports__,"M",(function(){return DUPLICATE_RULE}));__webpack_require__.d(__webpack_exports__,"yb",(function(){return SUCCESSFULLY_DUPLICATED_RULES}));__webpack_require__.d(__webpack_exports__,"N",(function(){return DUPLICATE_RULE_ERROR}));__webpack_require__.d(__webpack_exports__,"U",(function(){return EXPORT_RULE}));__webpack_require__.d(__webpack_exports__,"K",(function(){return DELETE_RULE}));__webpack_require__.d(__webpack_exports__,"A",(function(){return COLUMN_RULE}));__webpack_require__.d(__webpack_exports__,"z",(function(){return COLUMN_RISK_SCORE}));__webpack_require__.d(__webpack_exports__,"C",(function(){return COLUMN_SEVERITY}));__webpack_require__.d(__webpack_exports__,"v",(function(){return COLUMN_LAST_COMPLETE_RUN}));__webpack_require__.d(__webpack_exports__,"x",(function(){return COLUMN_LAST_UPDATE}));__webpack_require__.d(__webpack_exports__,"w",(function(){return COLUMN_LAST_RESPONSE}));__webpack_require__.d(__webpack_exports__,"E",(function(){return COLUMN_VERSION}));__webpack_require__.d(__webpack_exports__,"D",(function(){return COLUMN_TAGS}));__webpack_require__.d(__webpack_exports__,"B",(function(){return COLUMN_SEE_ALL_POPOVER}));__webpack_require__.d(__webpack_exports__,"s",(function(){return COLUMN_ACTIVATE}));__webpack_require__.d(__webpack_exports__,"u",(function(){return COLUMN_INDEXING_TIMES}));__webpack_require__.d(__webpack_exports__,"y",(function(){return COLUMN_QUERY_TIMES}));__webpack_require__.d(__webpack_exports__,"t",(function(){return COLUMN_GAP}));__webpack_require__.d(__webpack_exports__,"ob",(function(){return RULES_TAB}));__webpack_require__.d(__webpack_exports__,"bb",(function(){return MONITORING_TAB}));__webpack_require__.d(__webpack_exports__,"S",(function(){return EXCEPTIONS_TAB}));__webpack_require__.d(__webpack_exports__,"G",(function(){return CUSTOM_RULES}));__webpack_require__.d(__webpack_exports__,"R",(function(){return ELASTIC_RULES}));__webpack_require__.d(__webpack_exports__,"Bb",(function(){return TAGS}));__webpack_require__.d(__webpack_exports__,"eb",(function(){return NO_TAGS_AVAILABLE}));__webpack_require__.d(__webpack_exports__,"cb",(function(){return NO_RULES}));__webpack_require__.d(__webpack_exports__,"db",(function(){return NO_RULES_BODY}));__webpack_require__.d(__webpack_exports__,"H",(function(){return DEFINE_RULE}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ABOUT_RULE}));__webpack_require__.d(__webpack_exports__,"rb",(function(){return SCHEDULE_RULE}));__webpack_require__.d(__webpack_exports__,"pb",(function(){return RULE_ACTIONS}));__webpack_require__.d(__webpack_exports__,"I",(function(){return DEFINITION}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ABOUT}));__webpack_require__.d(__webpack_exports__,"qb",(function(){return SCHEDULE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ACTIONS}));__webpack_require__.d(__webpack_exports__,"fb",(function(){return OPTIONAL_FIELD}));__webpack_require__.d(__webpack_exports__,"F",(function(){return CONTINUE}));__webpack_require__.d(__webpack_exports__,"J",(function(){return DELETE}));__webpack_require__.d(__webpack_exports__,"Y",(function(){return IMPORT_RULE_BTN_TITLE}));__webpack_require__.d(__webpack_exports__,"vb",(function(){return SELECT_RULE}));__webpack_require__.d(__webpack_exports__,"ab",(function(){return INITIAL_PROMPT_TEXT}));__webpack_require__.d(__webpack_exports__,"gb",(function(){return OVERWRITE_WITH_SAME_NAME}));__webpack_require__.d(__webpack_exports__,"Ab",(function(){return SUCCESSFULLY_IMPORTED_RULES}));__webpack_require__.d(__webpack_exports__,"V",(function(){return IMPORT_FAILED}));__webpack_require__.d(__webpack_exports__,"W",(function(){return IMPORT_FAILED_DETAILED}));__webpack_require__.d(__webpack_exports__,"lb",(function(){return REFRESH_PROMPT_TITLE}));__webpack_require__.d(__webpack_exports__,"kb",(function(){return REFRESH_PROMPT_CONFIRM}));__webpack_require__.d(__webpack_exports__,"jb",(function(){return REFRESH_PROMPT_BODY}));__webpack_require__.d(__webpack_exports__,"mb",(function(){return REFRESH_RULE_POPOVER_DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"nb",(function(){return REFRESH_RULE_POPOVER_LABEL}));__webpack_require__.d(__webpack_exports__,"wb",(function(){return SHOWING_EXCEPTION_LISTS}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const BACK_TO_DETECTIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.backOptionsHeader",{defaultMessage:"Back to detections"});const IMPORT_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.importRuleTitle",{defaultMessage:"Import rule"});const UPLOAD_VALUE_LISTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.lists.detectionEngine.rules.uploadValueListsButton",{defaultMessage:"Upload value lists"});const UPLOAD_VALUE_LISTS_TOOLTIP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.lists.detectionEngine.rules.uploadValueListsButtonTooltip",{defaultMessage:"Use value lists to create an exception when a field value matches a value found in a list"});const ADD_NEW_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.addNewRuleTitle",{defaultMessage:"Create new rule"});const PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.pageTitle",{defaultMessage:"Detection rules"});const ADD_PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.addPageTitle",{defaultMessage:"Create"});const EDIT_PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.editPageTitle",{defaultMessage:"Edit"});const REFRESH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.refreshTitle",{defaultMessage:"Refresh"});const BATCH_ACTIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActionsTitle",{defaultMessage:"Bulk actions"});const ACTIVE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.activeRuleDescription",{defaultMessage:"active"});const INACTIVE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.inactiveRuleDescription",{defaultMessage:"inactive"});const BATCH_ACTION_ACTIVATE_SELECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.activateSelectedTitle",{defaultMessage:"Activate selected"});const BATCH_ACTION_ACTIVATE_SELECTED_ERROR=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.activateSelectedErrorTitle",{values:{totalRules:totalRules},defaultMessage:"Error activating {totalRules, plural, =1 {rule} other {rules}}"});const BATCH_ACTION_DEACTIVATE_SELECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.deactivateSelectedTitle",{defaultMessage:"Deactivate selected"});const BATCH_ACTION_DEACTIVATE_SELECTED_ERROR=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.deactivateSelectedErrorTitle",{values:{totalRules:totalRules},defaultMessage:"Error deactivating {totalRules, plural, =1 {rule} other {rules}}"});const BATCH_ACTION_EXPORT_SELECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.exportSelectedTitle",{defaultMessage:"Export selected"});const BATCH_ACTION_DUPLICATE_SELECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.duplicateSelectedTitle",{defaultMessage:"Duplicate selected"});const BATCH_ACTION_DELETE_SELECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.deleteSelectedTitle",{defaultMessage:"Delete selected"});const BATCH_ACTION_DELETE_SELECTED_IMMUTABLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.deleteSelectedImmutableTitle",{defaultMessage:"Selection contains immutable rules which cannot be deleted"});const BATCH_ACTION_DELETE_SELECTED_ERROR=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.batchActions.deleteSelectedErrorTitle",{values:{totalRules:totalRules},defaultMessage:"Error deleting {totalRules, plural, =1 {rule} other {rules}}"});const EXPORT_FILENAME=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.exportFilenameTitle",{defaultMessage:"rules_export"});const SUCCESSFULLY_EXPORTED_RULES=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.successfullyExportedRulesTitle",{values:{totalRules:totalRules},defaultMessage:"Successfully exported {totalRules, plural, =0 {all rules} =1 {{totalRules} rule} other {{totalRules} rules}}"});const ALL_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.tableTitle",{defaultMessage:"All rules"});const SEARCH_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.searchAriaLabel",{defaultMessage:"Search rules"});const SEARCH_PLACEHOLDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.searchPlaceholder",{defaultMessage:"e.g. rule name"});const SHOWING_RULES=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.showingRulesTitle",{values:{totalRules:totalRules},defaultMessage:"Showing {totalRules} {totalRules, plural, =1 {rule} other {rules}}"});const SELECTED_RULES=selectedRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.selectedRulesTitle",{values:{selectedRules:selectedRules},defaultMessage:"Selected {selectedRules} {selectedRules, plural, =1 {rule} other {rules}}"});const EDIT_RULE_SETTINGS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.editRuleSettingsDescription",{defaultMessage:"Edit rule settings"});const EDIT_RULE_SETTINGS_TOOLTIP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.editRuleSettingsToolTip",{defaultMessage:"You do not have Kibana Actions privileges"});const DUPLICATE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.duplicateTitle",{defaultMessage:"Duplicate"});const DUPLICATE_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.duplicateRuleDescription",{defaultMessage:"Duplicate rule"});const SUCCESSFULLY_DUPLICATED_RULES=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.successfullyDuplicatedRulesTitle",{values:{totalRules:totalRules},defaultMessage:"Successfully duplicated {totalRules, plural, =1 {{totalRules} rule} other {{totalRules} rules}}"});const DUPLICATE_RULE_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.duplicateRuleErrorDescription",{defaultMessage:"Error duplicating rule"});const EXPORT_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.exportRuleDescription",{defaultMessage:"Export rule"});const DELETE_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.actions.deleteeRuleDescription",{defaultMessage:"Delete rule"});const COLUMN_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.ruleTitle",{defaultMessage:"Rule"});const COLUMN_RISK_SCORE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.riskScoreTitle",{defaultMessage:"Risk score"});const COLUMN_SEVERITY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.severityTitle",{defaultMessage:"Severity"});const COLUMN_LAST_COMPLETE_RUN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.lastRunTitle",{defaultMessage:"Last run"});const COLUMN_LAST_UPDATE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.lastUpdateTitle",{defaultMessage:"Last updated"});const COLUMN_LAST_RESPONSE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.lastResponseTitle",{defaultMessage:"Last response"});const COLUMN_VERSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.versionTitle",{defaultMessage:"Version"});const COLUMN_TAGS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.tagsTitle",{defaultMessage:"Tags"});const COLUMN_SEE_ALL_POPOVER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.tagsPopoverTitle",{defaultMessage:"See all"});const COLUMN_ACTIVATE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.activateTitle",{defaultMessage:"Activated"});const COLUMN_INDEXING_TIMES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.indexingTimes",{defaultMessage:"Indexing Time (ms)"});const COLUMN_QUERY_TIMES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.queryTimes",{defaultMessage:"Query Time (ms)"});const COLUMN_GAP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.gap",{defaultMessage:"Last Gap (if any)"});const COLUMN_LAST_LOOKBACK_DATE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.columns.lastLookBackDate",{defaultMessage:"Last Look-Back Date"});const RULES_TAB=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.tabs.rules",{defaultMessage:"Rules"});const MONITORING_TAB=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.tabs.monitoring",{defaultMessage:"Rule Monitoring"});const EXCEPTIONS_TAB=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.tabs.exceptions",{defaultMessage:"Exception Lists"});const CUSTOM_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.filters.customRulesTitle",{defaultMessage:"Custom rules"});const ELASTIC_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.filters.elasticRulesTitle",{defaultMessage:"Elastic rules"});const TAGS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.filters.tagsLabel",{defaultMessage:"Tags"});const NO_TAGS_AVAILABLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.filters.noTagsAvailableDescription",{defaultMessage:"No tags available"});const NO_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.filters.noRulesTitle",{defaultMessage:"No rules found"});const NO_RULES_BODY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.filters.noRulesBodyTitle",{defaultMessage:"We weren't able to find any rules with the above filters."});const DEFINE_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.defineRuleTitle",{defaultMessage:"Define rule"});const ABOUT_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.aboutRuleTitle",{defaultMessage:"About rule"});const SCHEDULE_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.scheduleRuleTitle",{defaultMessage:"Schedule rule"});const RULE_ACTIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.ruleActionsTitle",{defaultMessage:"Rule actions"});const DEFINITION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.stepDefinitionTitle",{defaultMessage:"Definition"});const ABOUT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.stepAboutTitle",{defaultMessage:"About"});const SCHEDULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.stepScheduleTitle",{defaultMessage:"Schedule"});const ACTIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.stepActionsTitle",{defaultMessage:"Actions"});const OPTIONAL_FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.optionalFieldDescription",{defaultMessage:"Optional"});const CONTINUE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.continueButtonTitle",{defaultMessage:"Continue"});const UPDATE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.updateButtonTitle",{defaultMessage:"Update"});const DELETE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.deleteDescription",{defaultMessage:"Delete"});const IMPORT_RULE_BTN_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.importRuleTitle",{defaultMessage:"Import rule"});const SELECT_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.selectRuleDescription",{defaultMessage:"Select a Security rule (as exported from the Detection Engine view) to import"});const INITIAL_PROMPT_TEXT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.initialPromptTextDescription",{defaultMessage:"Select or drag and drop a valid rules_export.ndjson file"});const OVERWRITE_WITH_SAME_NAME=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.overwriteDescription",{defaultMessage:"Automatically overwrite saved objects with the same rule ID"});const SUCCESSFULLY_IMPORTED_RULES=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.successfullyImportedRulesTitle",{values:{totalRules:totalRules},defaultMessage:"Successfully imported {totalRules} {totalRules, plural, =1 {rule} other {rules}}"});const IMPORT_FAILED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.importFailedTitle",{defaultMessage:"Failed to import rules"});const IMPORT_FAILED_DETAILED=(ruleId,statusCode,message)=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.importRuleModal.importFailedDetailedTitle",{values:{ruleId:ruleId,statusCode:statusCode,message:message},defaultMessage:"Rule ID: {ruleId}\n Status Code: {statusCode}\n Message: {message}"});const REFRESH_PROMPT_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.allRules.refreshPromptTitle",{defaultMessage:"Are you still there?"});const REFRESH_PROMPT_CONFIRM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.allRules.refreshPromptConfirm",{defaultMessage:"Continue"});const REFRESH_PROMPT_BODY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.components.allRules.refreshPromptBody",{defaultMessage:'Rule auto-refresh has been paused. Click "Continue" to resume.'});const REFRESH_RULE_POPOVER_DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.refreshRulePopoverDescription",{defaultMessage:"Automatically refresh table"});const REFRESH_RULE_POPOVER_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.refreshRulePopoverLabel",{defaultMessage:"Refresh settings"});const SHOWING_EXCEPTION_LISTS=totalLists=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.allRules.showingExceptionLists",{values:{totalLists:totalLists},defaultMessage:"Showing {totalLists} {totalLists, plural, =1 {list} other {lists}}"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createFilter}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getDefaultFetchPolicy}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);const createFilter=filterQuery=>Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isString"])(filterQuery)?filterQuery:JSON.stringify(filterQuery);const getDefaultFetchPolicy=()=>"cache-and-network"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return actions}));__webpack_require__.d(__webpack_exports__,"c",(function(){return model}));__webpack_require__.d(__webpack_exports__,"e",(function(){return selectors_namespaceObject}));__webpack_require__.d(__webpack_exports__,"a",(function(){return initialNetworkState}));__webpack_require__.d(__webpack_exports__,"d",(function(){return networkReducer}));var selectors_namespaceObject={};__webpack_require__.r(selectors_namespaceObject);__webpack_require__.d(selectors_namespaceObject,"dnsSelector",(function(){return dnsSelector}));__webpack_require__.d(selectors_namespaceObject,"topNFlowSelector",(function(){return topNFlowSelector}));__webpack_require__.d(selectors_namespaceObject,"tlsSelector",(function(){return tlsSelector}));__webpack_require__.d(selectors_namespaceObject,"topCountriesSelector",(function(){return topCountriesSelector}));__webpack_require__.d(selectors_namespaceObject,"httpSelector",(function(){return httpSelector}));__webpack_require__.d(selectors_namespaceObject,"usersSelector",(function(){return usersSelector}));var actions=__webpack_require__(384);var model=__webpack_require__(248);var lib=__webpack_require__(123);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var network=__webpack_require__(182);var dist=__webpack_require__(236);var search_strategy=__webpack_require__(120);var constants=__webpack_require__(362);const setNetworkPageQueriesActivePageToZero=state=>({...state.page.queries,[model["NetworkTableType"].topCountriesSource]:{...state.page.queries[model["NetworkTableType"].topCountriesSource],activePage:constants["a"]},[model["NetworkTableType"].topCountriesDestination]:{...state.page.queries[model["NetworkTableType"].topCountriesDestination],activePage:constants["a"]},[model["NetworkTableType"].topNFlowSource]:{...state.page.queries[model["NetworkTableType"].topNFlowSource],activePage:constants["a"]},[model["NetworkTableType"].topNFlowDestination]:{...state.page.queries[model["NetworkTableType"].topNFlowDestination],activePage:constants["a"]},[model["NetworkTableType"].dns]:{...state.page.queries[model["NetworkTableType"].dns],activePage:constants["a"]},[model["NetworkTableType"].tls]:{...state.page.queries[model["NetworkTableType"].tls],activePage:constants["a"]},[model["NetworkTableType"].http]:{...state.page.queries[model["NetworkTableType"].http],activePage:constants["a"]}});const setNetworkDetailsQueriesActivePageToZero=state=>({...state.details.queries,[model["NetworkDetailsTableType"].topCountriesSource]:{...state.details.queries[model["NetworkDetailsTableType"].topCountriesSource],activePage:constants["a"]},[model["NetworkDetailsTableType"].topCountriesDestination]:{...state.details.queries[model["NetworkDetailsTableType"].topCountriesDestination],activePage:constants["a"]},[model["NetworkDetailsTableType"].topNFlowSource]:{...state.details.queries[model["NetworkDetailsTableType"].topNFlowSource],activePage:constants["a"]},[model["NetworkDetailsTableType"].topNFlowDestination]:{...state.details.queries[model["NetworkDetailsTableType"].topNFlowDestination],activePage:constants["a"]},[model["NetworkDetailsTableType"].tls]:{...state.details.queries[model["NetworkDetailsTableType"].tls],activePage:constants["a"]},[model["NetworkDetailsTableType"].users]:{...state.details.queries[model["NetworkDetailsTableType"].users],activePage:constants["a"]},[model["NetworkDetailsTableType"].http]:{...state.details.queries[model["NetworkDetailsTableType"].http],activePage:constants["a"]}});const setNetworkQueriesActivePageToZero=(state,type)=>{if(type===model["NetworkType"].page){return setNetworkPageQueriesActivePageToZero(state)}else if(type===model["NetworkType"].details){return setNetworkDetailsQueriesActivePageToZero(state)}throw new Error(`NetworkType ${type} is unknown`)};const initialNetworkState={page:{queries:{[model["NetworkTableType"].topNFlowSource]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_out,direction:search_strategy["Direction"].desc}},[model["NetworkTableType"].topNFlowDestination]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_in,direction:search_strategy["Direction"].desc}},[model["NetworkTableType"].dns]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkDnsFields"].uniqueDomains,direction:search_strategy["Direction"].desc},isPtrIncluded:false},[model["NetworkTableType"].http]:{activePage:constants["a"],limit:constants["b"],sort:{direction:search_strategy["Direction"].desc}},[model["NetworkTableType"].tls]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTlsFields"]._id,direction:search_strategy["Direction"].desc}},[model["NetworkTableType"].topCountriesSource]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_out,direction:search_strategy["Direction"].desc}},[model["NetworkTableType"].topCountriesDestination]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_in,direction:search_strategy["Direction"].desc}},[model["NetworkTableType"].alerts]:{activePage:constants["a"],limit:constants["b"]}}},details:{queries:{[model["NetworkDetailsTableType"].http]:{activePage:constants["a"],limit:constants["b"],sort:{direction:search_strategy["Direction"].desc}},[model["NetworkDetailsTableType"].topCountriesSource]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_out,direction:search_strategy["Direction"].desc}},[model["NetworkDetailsTableType"].topCountriesDestination]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_in,direction:search_strategy["Direction"].desc}},[model["NetworkDetailsTableType"].topNFlowSource]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_out,direction:search_strategy["Direction"].desc}},[model["NetworkDetailsTableType"].topNFlowDestination]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTopTablesFields"].bytes_in,direction:search_strategy["Direction"].desc}},[model["NetworkDetailsTableType"].tls]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkTlsFields"]._id,direction:search_strategy["Direction"].desc}},[model["NetworkDetailsTableType"].users]:{activePage:constants["a"],limit:constants["b"],sort:{field:search_strategy["NetworkUsersFields"].name,direction:search_strategy["Direction"].asc}}},flowTarget:search_strategy["FlowTarget"].source}};const networkReducer=Object(dist["reducerWithInitialState"])(initialNetworkState).case(actions["updateNetworkTable"],(state,{networkType:networkType,tableType:tableType,updates:updates})=>({...state,[networkType]:{...state[networkType],queries:{...state[networkType].queries,[tableType]:{...Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",tableType],state),...updates}}}})).case(actions["setNetworkTablesActivePageToZero"],state=>({...state,page:{...state.page,queries:setNetworkPageQueriesActivePageToZero(state)},details:{...state.details,queries:setNetworkDetailsQueriesActivePageToZero(state)}})).case(actions["setNetworkDetailsTablesActivePageToZero"],state=>({...state,details:{...state.details,queries:setNetworkDetailsQueriesActivePageToZero(state)}})).build();const selectNetworkPage=state=>state.network.page;const selectNetworkDetails=state=>state.network.details;const dnsSelector=()=>Object(lib["createSelector"])(selectNetworkPage,network=>network.queries.dns);const selectTopNFlowByType=(state,networkType,flowTarget)=>{const ft=flowTarget===network["FlowTargetSourceDest"].source?"topNFlowSource":"topNFlowDestination";const nFlowType=networkType===model["NetworkType"].page?model["NetworkTableType"][ft]:model["NetworkDetailsTableType"][ft];return Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",nFlowType],state.network)||Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",nFlowType],initialNetworkState)};const topNFlowSelector=()=>Object(lib["createSelector"])(selectTopNFlowByType,topNFlowQueries=>topNFlowQueries);const selectTlsByType=(state,networkType)=>{const tlsType=networkType===model["NetworkType"].page?model["NetworkTableType"].tls:model["NetworkDetailsTableType"].tls;return Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",tlsType],state.network)||Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",tlsType],initialNetworkState)};const tlsSelector=()=>Object(lib["createSelector"])(selectTlsByType,tlsQueries=>tlsQueries);const selectTopCountriesByType=(state,networkType,flowTarget)=>{const ft=flowTarget===network["FlowTargetSourceDest"].source?"topCountriesSource":"topCountriesDestination";const nFlowType=networkType===model["NetworkType"].page?model["NetworkTableType"][ft]:model["NetworkDetailsTableType"][ft];return Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",nFlowType],state.network)||Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",nFlowType],initialNetworkState)};const topCountriesSelector=()=>Object(lib["createSelector"])(selectTopCountriesByType,topCountriesQueries=>topCountriesQueries);const selectHttpByType=(state,networkType)=>{const httpType=networkType===model["NetworkType"].page?model["NetworkTableType"].http:model["NetworkDetailsTableType"].http;return Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",httpType],state.network)||Object(external_kbnSharedDeps_LodashFp_["get"])([networkType,"queries",httpType],initialNetworkState)};const httpSelector=()=>Object(lib["createSelector"])(selectHttpByType,httpQueries=>httpQueries);const usersSelector=()=>Object(lib["createSelector"])(selectNetworkDetails,network=>network.queries.users)},,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ARIA_COLINDEX_ATTRIBUTE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return DATA_COLINDEX_ATTRIBUTE}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ARIA_ROWINDEX_ATTRIBUTE}));__webpack_require__.d(__webpack_exports__,"d",(function(){return DATA_ROWINDEX_ATTRIBUTE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return FIRST_ARIA_INDEX}));__webpack_require__.d(__webpack_exports__,"f",(function(){return arrayIndexToAriaIndex}));__webpack_require__.d(__webpack_exports__,"p",(function(){return isArrowUp}));__webpack_require__.d(__webpack_exports__,"o",(function(){return isArrowDownOrArrowUp}));__webpack_require__.d(__webpack_exports__,"q",(function(){return isEscape}));__webpack_require__.d(__webpack_exports__,"r",(function(){return isTab}));__webpack_require__.d(__webpack_exports__,"h",(function(){return focusColumn}));__webpack_require__.d(__webpack_exports__,"l",(function(){return getRowRendererClassName}));__webpack_require__.d(__webpack_exports__,"k",(function(){return getNotesContainerClassName}));__webpack_require__.d(__webpack_exports__,"v",(function(){return stopPropagationAndPreventDefault}));__webpack_require__.d(__webpack_exports__,"t",(function(){return onKeyDownFocusHandler}));__webpack_require__.d(__webpack_exports__,"s",(function(){return onFocusReFocusDraggable}));__webpack_require__.d(__webpack_exports__,"g",(function(){return elementOrChildrenHasFocus}));__webpack_require__.d(__webpack_exports__,"u",(function(){return skipFocusInContainerTo}));__webpack_require__.d(__webpack_exports__,"n",(function(){return handleSkipFocus}));__webpack_require__.d(__webpack_exports__,"m",(function(){return getTableSkipFocus}));__webpack_require__.d(__webpack_exports__,"i",(function(){return getFocusedAriaColindexCell}));__webpack_require__.d(__webpack_exports__,"j",(function(){return getFocusedDataColindexCell}));var _drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(116);var _timelines_components_timeline_body_helpers__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(226);var _with_hover_actions__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(289);const ARIA_COLINDEX_ATTRIBUTE="aria-colindex";const DATA_COLINDEX_ATTRIBUTE="data-colindex";const ARIA_ROWINDEX_ATTRIBUTE="aria-rowindex";const DATA_ROWINDEX_ATTRIBUTE="data-rowindex";const FIRST_ARIA_INDEX=1;const ariaIndexToArrayIndex=ariaIndex=>ariaIndex-1;const arrayIndexToAriaIndex=arrayIndex=>arrayIndex+1;const isArrowRightOrArrowLeft=event=>event.key==="ArrowLeft"||event.key==="ArrowRight";const isArrowDown=event=>event.key==="ArrowDown";const isArrowUp=event=>event.key==="ArrowUp";const isArrowDownOrArrowUp=event=>isArrowDown(event)||isArrowUp(event);const isArrowKey=event=>isArrowRightOrArrowLeft(event)||isArrowDownOrArrowUp(event);const isArrowRight=event=>event.key==="ArrowRight";const isEscape=event=>event.key==="Escape";const isHome=event=>event.key==="Home";const isEnd=event=>event.key==="End";const isHomeOrEnd=event=>isHome(event)||isEnd(event);const isPageUp=event=>event.key==="PageUp";const isPageDown=event=>event.key==="PageDown";const isPageDownOrPageUp=event=>isPageDown(event)||isPageUp(event);const isTab=event=>event.key==="Tab";const getFocusOnFromArrowKey=event=>event.key==="ArrowUp"||event.key==="ArrowLeft"?"previous":"next";const getFocusedColumn=({colindexAttribute:colindexAttribute,element:element})=>{var _element$querySelecto;return(_element$querySelecto=element===null||element===void 0?void 0:element.querySelector(`[${colindexAttribute}]:focus-within`))!==null&&_element$querySelecto!==void 0?_element$querySelecto:null};const getColindex=({colindexAttribute:colindexAttribute,element:element})=>(element===null||element===void 0?void 0:element.getAttribute(colindexAttribute))!=null?Number(element===null||element===void 0?void 0:element.getAttribute(colindexAttribute)):null;const getFocusedRow=({rowindexAttribute:rowindexAttribute,element:element})=>{var _element$querySelecto2;return(_element$querySelecto2=element===null||element===void 0?void 0:element.querySelector(`[${rowindexAttribute}]:focus-within`))!==null&&_element$querySelecto2!==void 0?_element$querySelecto2:null};const getRowindex=({rowindexAttribute:rowindexAttribute,element:element})=>(element===null||element===void 0?void 0:element.getAttribute(rowindexAttribute))!=null?Number(element===null||element===void 0?void 0:element.getAttribute(rowindexAttribute)):null;const getRowByAriaRowindex=({ariaRowindex:ariaRowindex,element:element,rowindexAttribute:rowindexAttribute})=>{var _element$querySelecto3;return(_element$querySelecto3=element===null||element===void 0?void 0:element.querySelector(`[${rowindexAttribute}="${ariaRowindex}"]`))!==null&&_element$querySelecto3!==void 0?_element$querySelecto3:null};const getNewAriaColindex=({focusedAriaColindex:focusedAriaColindex,focusOn:focusOn,maxAriaColindex:maxAriaColindex})=>{const newAriaColindex=focusOn==="previous"?focusedAriaColindex-1:focusedAriaColindex+1;if(newAriaColindex<FIRST_ARIA_INDEX){return FIRST_ARIA_INDEX}if(newAriaColindex>maxAriaColindex){return maxAriaColindex}return newAriaColindex};const getElementWithMatchingAriaColindex=({ariaColindex:ariaColindex,colindexAttribute:colindexAttribute,element:element})=>{var _element$querySelecto4;if((element===null||element===void 0?void 0:element.getAttribute(colindexAttribute))===`${ariaColindex}`){return element}return(_element$querySelecto4=element===null||element===void 0?void 0:element.querySelector(`[${colindexAttribute}="${ariaColindex}"]`))!==null&&_element$querySelecto4!==void 0?_element$querySelecto4:null};const getNewAriaRowindex=({focusedAriaRowindex:focusedAriaRowindex,focusOn:focusOn,maxAriaRowindex:maxAriaRowindex})=>{const newAriaRowindex=focusOn==="previous"?focusedAriaRowindex-1:focusedAriaRowindex+1;if(newAriaRowindex<FIRST_ARIA_INDEX){return FIRST_ARIA_INDEX}if(newAriaRowindex>maxAriaRowindex){return maxAriaRowindex}return newAriaRowindex};const getFirstOrLastAriaRowindex=({event:event,maxAriaRowindex:maxAriaRowindex})=>isHome(event)?FIRST_ARIA_INDEX:maxAriaRowindex;const focusColumn=({colindexAttribute:colindexAttribute,containerElement:containerElement,ariaColindex:ariaColindex,ariaRowindex:ariaRowindex,rowindexAttribute:rowindexAttribute})=>{if(containerElement==null){return{newFocusedColumnAriaColindex:null,newFocusedColumn:null}}const row=getRowByAriaRowindex({ariaRowindex:ariaRowindex,element:containerElement,rowindexAttribute:rowindexAttribute});const column=getElementWithMatchingAriaColindex({ariaColindex:ariaColindex,colindexAttribute:colindexAttribute,element:row});if(column!=null){column.focus();return{newFocusedColumnAriaColindex:ariaColindex,newFocusedColumn:column}}return{newFocusedColumnAriaColindex:null,newFocusedColumn:null}};const getRowRendererClassName=ariaRowindex=>`${_timelines_components_timeline_body_helpers__WEBPACK_IMPORTED_MODULE_1__["d"]}-${ariaRowindex}`;const getNotesContainerClassName=ariaRowindex=>`${_timelines_components_timeline_body_helpers__WEBPACK_IMPORTED_MODULE_1__["b"]}-${ariaRowindex}`;const onArrowKeyDown=({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,focusedAriaColindex:focusedAriaColindex,focusedAriaRowindex:focusedAriaRowindex,maxAriaColindex:maxAriaColindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})=>{if(isArrowDown(event)&&event.shiftKey){const firstRowRendererDraggable=containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${getRowRendererClassName(focusedAriaRowindex)} .${_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_0__["a"]}`);if(firstRowRendererDraggable){firstRowRendererDraggable.focus();return}}if(isArrowRight(event)&&event.shiftKey){const firstNoteContent=containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${getNotesContainerClassName(focusedAriaRowindex)} .${_timelines_components_timeline_body_helpers__WEBPACK_IMPORTED_MODULE_1__["c"]}`);if(firstNoteContent){firstNoteContent.focus();return}}const ariaColindex=isArrowRightOrArrowLeft(event)?getNewAriaColindex({focusedAriaColindex:focusedAriaColindex,focusOn:getFocusOnFromArrowKey(event),maxAriaColindex:maxAriaColindex}):focusedAriaColindex;const ariaRowindex=isArrowDownOrArrowUp(event)?getNewAriaRowindex({focusedAriaRowindex:focusedAriaRowindex,focusOn:getFocusOnFromArrowKey(event),maxAriaRowindex:maxAriaRowindex}):focusedAriaRowindex;const{newFocusedColumn:newFocusedColumn,newFocusedColumnAriaColindex:newFocusedColumnAriaColindex}=focusColumn({ariaColindex:ariaColindex,ariaRowindex:ariaRowindex,colindexAttribute:colindexAttribute,containerElement:containerElement,rowindexAttribute:rowindexAttribute});if(onColumnFocused!=null&&newFocusedColumnAriaColindex!=null){onColumnFocused({newFocusedColumn:newFocusedColumn,newFocusedColumnAriaColindex:newFocusedColumnAriaColindex})}};const onHomeEndDown=({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,focusedAriaRowindex:focusedAriaRowindex,maxAriaColindex:maxAriaColindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})=>{const ariaColindex=isHome(event)?FIRST_ARIA_INDEX:maxAriaColindex;const ariaRowindex=event.ctrlKey?getFirstOrLastAriaRowindex({event:event,maxAriaRowindex:maxAriaRowindex}):focusedAriaRowindex;const{newFocusedColumn:newFocusedColumn,newFocusedColumnAriaColindex:newFocusedColumnAriaColindex}=focusColumn({ariaColindex:ariaColindex,ariaRowindex:ariaRowindex,colindexAttribute:colindexAttribute,containerElement:containerElement,rowindexAttribute:rowindexAttribute});if(isHome(event)&&event.ctrlKey){containerElement===null||containerElement===void 0?void 0:containerElement.scrollTo(0,0)}if(onColumnFocused!=null&&newFocusedColumnAriaColindex!=null){onColumnFocused({newFocusedColumn:newFocusedColumn,newFocusedColumnAriaColindex:newFocusedColumnAriaColindex})}};const isRowCompletelyScrolledIntoView=({container:container,row:row})=>{const rect=row.getBoundingClientRect();const top=rect.top;const bottom=rect.bottom;return top>=container.top&&bottom<=container.bottom};const getFirstNonVisibleAriaRowindex=({focusedAriaRowindex:focusedAriaRowindex,element:element,event:event,maxAriaRowindex:maxAriaRowindex,rowindexAttribute:rowindexAttribute})=>{var _element$querySelecto5;const defaultAriaRowindex=isPageUp(event)?FIRST_ARIA_INDEX:maxAriaRowindex;if(element===null){return defaultAriaRowindex}const container=element.getBoundingClientRect();const rows=Array.from((_element$querySelecto5=element.querySelectorAll(`[${rowindexAttribute}]`))!==null&&_element$querySelecto5!==void 0?_element$querySelecto5:[]);if(isPageUp(event)){return arrayIndexToAriaIndex(rows.reduceRight((found,row,i)=>i<ariaIndexToArrayIndex(focusedAriaRowindex)&&found===ariaIndexToArrayIndex(defaultAriaRowindex)&&!isRowCompletelyScrolledIntoView({container:container,row:row})?i:found,ariaIndexToArrayIndex(defaultAriaRowindex)))}else if(isPageDown(event)){return arrayIndexToAriaIndex(rows.reduce((found,row,i)=>i>ariaIndexToArrayIndex(focusedAriaRowindex)&&found===ariaIndexToArrayIndex(defaultAriaRowindex)&&!isRowCompletelyScrolledIntoView({container:container,row:row})?i:found,ariaIndexToArrayIndex(defaultAriaRowindex)))}else{return defaultAriaRowindex}};const onPageDownOrPageUp=({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,focusedAriaColindex:focusedAriaColindex,focusedAriaRowindex:focusedAriaRowindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})=>{const ariaRowindex=getFirstNonVisibleAriaRowindex({element:containerElement,event:event,focusedAriaRowindex:focusedAriaRowindex,maxAriaRowindex:maxAriaRowindex,rowindexAttribute:rowindexAttribute});const{newFocusedColumn:newFocusedColumn,newFocusedColumnAriaColindex:newFocusedColumnAriaColindex}=focusColumn({ariaColindex:focusedAriaColindex,ariaRowindex:ariaRowindex,colindexAttribute:colindexAttribute,containerElement:containerElement,rowindexAttribute:rowindexAttribute});if(onColumnFocused!=null){onColumnFocused({newFocusedColumn:newFocusedColumn,newFocusedColumnAriaColindex:newFocusedColumnAriaColindex})}};const stopPropagationAndPreventDefault=event=>{event.stopPropagation();event.preventDefault()};const onKeyDownFocusHandler=({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,maxAriaColindex:maxAriaColindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})=>{var _getColindex;const focusedAriaColindex=(_getColindex=getColindex({colindexAttribute:colindexAttribute,element:getFocusedColumn({colindexAttribute:colindexAttribute,element:containerElement})}))!==null&&_getColindex!==void 0?_getColindex:FIRST_ARIA_INDEX;const focusedAriaRowindex=getRowindex({rowindexAttribute:rowindexAttribute,element:getFocusedRow({rowindexAttribute:rowindexAttribute,element:containerElement})});if(focusedAriaColindex!=null&&focusedAriaRowindex!=null){if(isArrowKey(event)){stopPropagationAndPreventDefault(event);onArrowKeyDown({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,focusedAriaColindex:focusedAriaColindex,focusedAriaRowindex:focusedAriaRowindex,maxAriaColindex:maxAriaColindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})}else if(isHomeOrEnd(event)){stopPropagationAndPreventDefault(event);onHomeEndDown({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,focusedAriaRowindex:focusedAriaRowindex,maxAriaColindex:maxAriaColindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})}else if(isPageDownOrPageUp(event)){stopPropagationAndPreventDefault(event);onPageDownOrPageUp({colindexAttribute:colindexAttribute,containerElement:containerElement,event:event,focusedAriaColindex:focusedAriaColindex,focusedAriaRowindex:focusedAriaRowindex,maxAriaRowindex:maxAriaRowindex,onColumnFocused:onColumnFocused,rowindexAttribute:rowindexAttribute})}}};const onFocusReFocusDraggable=event=>{var _event$target$querySe;return(_event$target$querySe=event.target.querySelector(`.${_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_0__["a"]}`))===null||_event$target$querySe===void 0?void 0:_event$target$querySe.focus()};const elementOrChildrenHasFocus=element=>element===document.activeElement||(element===null||element===void 0?void 0:element.querySelector(":focus-within"))!=null;const skipFocusInContainerTo=({containerElement:containerElement,className:className})=>{var _containerElement$que;return containerElement===null||containerElement===void 0?void 0:(_containerElement$que=containerElement.querySelector(`.${className}`))===null||_containerElement$que===void 0?void 0:_containerElement$que.focus()};const getFocusableChidren=cell=>{var _cell$querySelectorAl;return Array.from((_cell$querySelectorAl=cell===null||cell===void 0?void 0:cell.querySelectorAll(`button:not([disabled]), button:not([tabIndex="-1"]), .${_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_0__["a"]}`))!==null&&_cell$querySelectorAl!==void 0?_cell$querySelectorAl:[])};const handleSkipFocus=({onSkipFocusBackwards:onSkipFocusBackwards,onSkipFocusForward:onSkipFocusForward,skipFocus:skipFocus})=>{switch(skipFocus){case"SKIP_FOCUS_BACKWARDS":onSkipFocusBackwards();break;case"SKIP_FOCUS_FORWARD":onSkipFocusForward();break;case"SKIP_FOCUS_NOOP":default:break}};const focusedCellHasMoreFocusableChildren=({focusedCell:focusedCell,shiftKey:shiftKey})=>{const focusableChildren=getFocusableChidren(focusedCell);if(focusableChildren.length===0){return false}const firstOrLastChild=shiftKey?focusableChildren[0]:focusableChildren[focusableChildren.length-1];return firstOrLastChild!==document.activeElement};const focusedCellHasAlwaysOpenHoverContent=focusedCell=>(focusedCell===null||focusedCell===void 0?void 0:focusedCell.querySelector(`.${_with_hover_actions__WEBPACK_IMPORTED_MODULE_2__["a"]}`))!=null;const focusedCellIsPlainColumnHeader=focusedCell=>(focusedCell===null||focusedCell===void 0?void 0:focusedCell.getAttribute("role"))==="columnheader"&&!(focusedCell!==null&&focusedCell!==void 0&&focusedCell.classList.contains("siemEventsTable__thGroupActions"));const getTableSkipFocus=({containerElement:containerElement,getFocusedCell:getFocusedCell,shiftKey:shiftKey,tableHasFocus:tableHasFocus,tableClassName:tableClassName})=>{if(tableHasFocus(containerElement)){const focusedCell=getFocusedCell({containerElement:containerElement,tableClassName:tableClassName});if(focusedCell==null){return"SKIP_FOCUS_NOOP"}if(focusedCellHasMoreFocusableChildren({focusedCell:focusedCell,shiftKey:shiftKey})&&!focusedCellIsPlainColumnHeader(focusedCell)){return"SKIP_FOCUS_NOOP"}if(focusedCellHasAlwaysOpenHoverContent(focusedCell)){return"SKIP_FOCUS_NOOP"}return shiftKey?"SKIP_FOCUS_BACKWARDS":"SKIP_FOCUS_FORWARD"}return"SKIP_FOCUS_NOOP"};const getFocusedAriaColindexCell=({containerElement:containerElement,tableClassName:tableClassName})=>{var _containerElement$que2;return(_containerElement$que2=containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${tableClassName} [aria-colindex]:focus-within`))!==null&&_containerElement$que2!==void 0?_containerElement$que2:null};const getFocusedDataColindexCell=({containerElement:containerElement,tableClassName:tableClassName})=>{var _containerElement$que3;return(_containerElement$que3=containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${tableClassName} [data-colindex]:focus-within`))!==null&&_containerElement$que3!==void 0?_containerElement$que3:null}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return manageQuery}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function manageQuery(WrappedComponent){var _WrappedComponent$dis;class ManageQuery extends react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent{componentDidUpdate(prevProps){const{loading:loading,id:id,refetch:refetch,setQuery:setQuery,inspect:inspect=null}=this.props;setQuery({id:id,inspect:inspect,loading:loading,refetch:refetch})}componentWillUnmount(){const{deleteQuery:deleteQuery,id:id}=this.props;if(deleteQuery){deleteQuery({id:id})}}render(){const otherProps=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["omit"])(["refetch","setQuery"],this.props);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(WrappedComponent,otherProps)}}_defineProperty(ManageQuery,"displayName",void 0);ManageQuery.displayName=`ManageQuery (${(_WrappedComponent$dis=WrappedComponent===null||WrappedComponent===void 0?void 0:WrappedComponent.displayName)!==null&&_WrappedComponent$dis!==void 0?_WrappedComponent$dis:"Unknown"})`;return ManageQuery}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SpyRoute}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_router_dom__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(75);var react_router_dom__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_1__);var fast_deep_equal__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(107);var fast_deep_equal__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(fast_deep_equal__WEBPACK_IMPORTED_MODULE_2__);var _use_route_spy__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(292);var _common_constants__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(2);const SpyRouteComponent=Object(react__WEBPACK_IMPORTED_MODULE_0__["memo"])(({location:{pathname:pathname,search:search},history:history,match:{params:{detailName:detailName,tabName:tabName,flowTarget:flowTarget}},pageName:pageName,state:state})=>{const[isInitializing,setIsInitializing]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(true);const[route,dispatch]=Object(_use_route_spy__WEBPACK_IMPORTED_MODULE_3__["a"])();Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(isInitializing&&search!==""){dispatch({type:"updateSearch",search:search});setIsInitializing(false)}else if(search!==""&&search!==route.search){dispatch({type:"updateSearch",search:search})}},[search]);Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{if(pageName&&!fast_deep_equal__WEBPACK_IMPORTED_MODULE_2___default()(route.pathName,pathname)){if(isInitializing&&detailName==null){dispatch({type:"updateRouteWithOutSearch",route:{detailName:detailName,flowTarget:flowTarget,history:history,pageName:pageName,pathName:pathname,state:state,tabName:tabName,...pageName===_common_constants__WEBPACK_IMPORTED_MODULE_4__["bb"].administration?{search:search!==null&&search!==void 0?search:""}:{}}});setIsInitializing(false)}else{dispatch({type:"updateRoute",route:{detailName:detailName,flowTarget:flowTarget,history:history,pageName:pageName,pathName:pathname,search:search,state:state,tabName:tabName}})}}else{if(pageName&&!fast_deep_equal__WEBPACK_IMPORTED_MODULE_2___default()(state,route.state)){dispatch({type:"updateRoute",route:{detailName:detailName,flowTarget:flowTarget,history:history,pageName:pageName,pathName:pathname,search:search,state:state,tabName:tabName}})}}},[pathname,search,pageName,detailName,tabName,flowTarget,state]);return null});const SpyRoute=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_1__["withRouter"])(SpyRouteComponent)},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return WrapperPage}));var classnames__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(286);var classnames__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _containers_use_full_screen__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(139);var _lib_helpers__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(225);var _page_index__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(153);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const Wrapper=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.withConfig({displayName:"Wrapper",componentId:"sc-5fa2oy-0"})(["padding:",";&.siemWrapperPage--fullHeight{height:100%;display:flex;flex-direction:column;flex:1 1 auto;}&.siemWrapperPage--noPadding{padding:0;display:flex;flex-direction:column;flex:1 1 auto;}&.siemWrapperPage--withTimeline{padding-bottom:",";}"],props=>`${props.theme.eui.paddingSizes.l}`,_lib_helpers__WEBPACK_IMPORTED_MODULE_4__["d"]);Wrapper.displayName="Wrapper";const WrapperPageComponent=({children:children,className:className,style:style,noPadding:noPadding,noTimeline:noTimeline,...otherProps})=>{const{globalFullScreen:globalFullScreen,setGlobalFullScreen:setGlobalFullScreen}=Object(_containers_use_full_screen__WEBPACK_IMPORTED_MODULE_3__["a"])();Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{setGlobalFullScreen(false)},[setGlobalFullScreen]);const classes=classnames__WEBPACK_IMPORTED_MODULE_0___default()(className,{siemWrapperPage:true,"siemWrapperPage--noPadding":noPadding,"siemWrapperPage--withTimeline":!noTimeline,"siemWrapperPage--fullHeight":globalFullScreen});return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Wrapper,_extends({className:classes,style:style},otherProps),children,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_page_index__WEBPACK_IMPORTED_MODULE_5__["a"],null))};const WrapperPage=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(WrapperPageComponent)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useGlobalFullScreen}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useTimelineFullScreen}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_redux__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);var _common_constants__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var _hooks_use_selector__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(109);var _store__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(122);var _store_actions__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(224);const resetScroll=()=>{setTimeout(()=>{window.scrollTo(0,0);const kibanaBody=document.querySelector("#kibana-body");if(kibanaBody!=null){kibanaBody.scrollTop=0}const pageContainer=document.querySelector('[data-test-subj="pageContainer"]');if(pageContainer!=null){pageContainer.scrollTop=0}},0)};const useGlobalFullScreen=()=>{var _useShallowEqualSelec;const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])();const globalFullScreen=(_useShallowEqualSelec=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_3__["b"])(_store__WEBPACK_IMPORTED_MODULE_4__["inputsSelectors"].globalFullScreenSelector))!==null&&_useShallowEqualSelec!==void 0?_useShallowEqualSelec:false;const setGlobalFullScreen=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(fullScreen=>{if(fullScreen){document.body.classList.add(_common_constants__WEBPACK_IMPORTED_MODULE_2__["ab"]);resetScroll()}else{document.body.classList.remove(_common_constants__WEBPACK_IMPORTED_MODULE_2__["ab"]);resetScroll()}dispatch(_store_actions__WEBPACK_IMPORTED_MODULE_5__["c"].setFullScreen({id:"global",fullScreen:fullScreen}))},[dispatch]);const memoizedReturn=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({globalFullScreen:globalFullScreen,setGlobalFullScreen:setGlobalFullScreen}),[globalFullScreen,setGlobalFullScreen]);return memoizedReturn};const useTimelineFullScreen=()=>{var _useShallowEqualSelec2;const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])();const timelineFullScreen=(_useShallowEqualSelec2=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_3__["b"])(_store__WEBPACK_IMPORTED_MODULE_4__["inputsSelectors"].timelineFullScreenSelector))!==null&&_useShallowEqualSelec2!==void 0?_useShallowEqualSelec2:false;const setTimelineFullScreen=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(fullScreen=>dispatch(_store_actions__WEBPACK_IMPORTED_MODULE_5__["c"].setFullScreen({id:"timeline",fullScreen:fullScreen})),[dispatch]);const memoizedReturn=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({timelineFullScreen:timelineFullScreen,setTimelineFullScreen:setTimelineFullScreen}),[timelineFullScreen,setTimelineFullScreen]);return memoizedReturn}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"z",(function(){return SELECTOR_TIMELINE_GLOBAL_CONTAINER}));__webpack_require__.d(__webpack_exports__,"C",(function(){return TimelineContainer}));__webpack_require__.d(__webpack_exports__,"B",(function(){return TimelineBodyGlobalStyle}));__webpack_require__.d(__webpack_exports__,"A",(function(){return TimelineBody}));__webpack_require__.d(__webpack_exports__,"a",(function(){return EVENTS_TABLE_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"i",(function(){return EventsTable}));__webpack_require__.d(__webpack_exports__,"s",(function(){return EventsThead}));__webpack_require__.d(__webpack_exports__,"v",(function(){return EventsTrHeader}));__webpack_require__.d(__webpack_exports__,"q",(function(){return EventsThGroupActions}));__webpack_require__.d(__webpack_exports__,"r",(function(){return EventsThGroupData}));__webpack_require__.d(__webpack_exports__,"o",(function(){return EventsTh}));__webpack_require__.d(__webpack_exports__,"p",(function(){return EventsThContent}));__webpack_require__.d(__webpack_exports__,"j",(function(){return EventsTbody}));__webpack_require__.d(__webpack_exports__,"u",(function(){return EventsTrGroup}));__webpack_require__.d(__webpack_exports__,"t",(function(){return EventsTrData}));__webpack_require__.d(__webpack_exports__,"x",(function(){return EventsTrSupplementContainer}));__webpack_require__.d(__webpack_exports__,"w",(function(){return EventsTrSupplement}));__webpack_require__.d(__webpack_exports__,"m",(function(){return EventsTdGroupActions}));__webpack_require__.d(__webpack_exports__,"n",(function(){return EventsTdGroupData}));__webpack_require__.d(__webpack_exports__,"b",(function(){return EVENTS_TD_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"k",(function(){return EventsTd}));__webpack_require__.d(__webpack_exports__,"l",(function(){return EventsTdContent}));__webpack_require__.d(__webpack_exports__,"c",(function(){return EventsHeading}));__webpack_require__.d(__webpack_exports__,"f",(function(){return EventsHeadingTitleButton}));__webpack_require__.d(__webpack_exports__,"g",(function(){return EventsHeadingTitleSpan}));__webpack_require__.d(__webpack_exports__,"d",(function(){return EventsHeadingExtra}));__webpack_require__.d(__webpack_exports__,"e",(function(){return EventsHeadingHandle}));__webpack_require__.d(__webpack_exports__,"h",(function(){return EventsLoading}));__webpack_require__.d(__webpack_exports__,"y",(function(){return HideShowContainer}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var polished__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(180);var polished__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(polished__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _common_components_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(116);var _helpers__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(119);var _translations__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(261);const SELECTOR_TIMELINE_GLOBAL_CONTAINER="securitySolutionTimeline__container";const TimelineContainer=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`${SELECTOR_TIMELINE_GLOBAL_CONTAINER} ${className}`})).withConfig({displayName:"TimelineContainer",componentId:"a7jkpo-0"})(["height:100%;display:flex;flex-direction:column;position:relative;"]);const SELECTOR_TIMELINE_BODY_CLASS_NAME="securitySolutionTimeline__body";const TimelineBodyGlobalStyle=styled_components__WEBPACK_IMPORTED_MODULE_2__["createGlobalStyle"]`
  body.${_common_components_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_3__["d"]} .${SELECTOR_TIMELINE_BODY_CLASS_NAME} {
    overflow: hidden;
  }
`;const TimelineBody=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`${SELECTOR_TIMELINE_BODY_CLASS_NAME} ${className}`})).withConfig({displayName:"TimelineBody",componentId:"a7jkpo-1"})(["height:auto;overflow:auto;scrollbar-width:thin;flex:1;display:block;&::-webkit-scrollbar{height:",";width:",";}&::-webkit-scrollbar-thumb{background-clip:content-box;background-color:",";border:"," solid transparent;}&::-webkit-scrollbar-corner,&::-webkit-scrollbar-track{background-color:transparent;}"],({theme:theme})=>theme.eui.euiScrollBar,({theme:theme})=>theme.eui.euiScrollBar,({theme:theme})=>Object(polished__WEBPACK_IMPORTED_MODULE_1__["rgba"])(theme.eui.euiColorDarkShade,.5),({theme:theme})=>theme.eui.euiScrollBarCorner);TimelineBody.displayName="TimelineBody";const EVENTS_TABLE_CLASS_NAME="siemEventsTable";const EVENTS_TABLE_HEAD_CLASS_NAME="siemEventsTable__thead";const EventsTable=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className="",$columnCount:$columnCount,columnWidths:columnWidths,$activePage:$activePage,$rowCount:$rowCount,$totalPages:$totalPages})=>({"aria-label":Object(_translations__WEBPACK_IMPORTED_MODULE_5__["c"])({activePage:$activePage+1,totalPages:$totalPages}),"aria-colcount":`${$columnCount}`,"aria-rowcount":`${$rowCount+1}`,className:`siemEventsTable ${className}`,role:"grid",style:{minWidth:`${columnWidths}px`},tabindex:"-1"})).withConfig({displayName:"EventsTable",componentId:"a7jkpo-2"})(["padding:3px;"]);const EventsThead=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__thead ${className}`,role:"rowgroup"})).withConfig({displayName:"EventsThead",componentId:"a7jkpo-3"})(["background-color:",";border-bottom:"," solid ",";position:sticky;top:0;z-index:",";"],({theme:theme})=>theme.eui.euiColorEmptyShade,({theme:theme})=>theme.eui.euiBorderWidthThick,({theme:theme})=>theme.eui.euiColorLightShade,({theme:theme})=>theme.eui.euiZLevel1);const EventsTrHeader=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className})=>({"aria-rowindex":"1",className:`siemEventsTable__trHeader ${className}`,role:"row"})).withConfig({displayName:"EventsTrHeader",componentId:"a7jkpo-4"})(["display:flex;"]);const EventsThGroupActions=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({"aria-colindex":`${_helpers__WEBPACK_IMPORTED_MODULE_4__["a"]}`,className:`siemEventsTable__thGroupActions ${className}`,role:"columnheader",tabIndex:"0"})).withConfig({displayName:"EventsThGroupActions",componentId:"a7jkpo-5"})(["display:flex;flex:0 0 ",";min-width:0;padding-left:",";"],({actionsColumnWidth:actionsColumnWidth,isEventViewer:isEventViewer})=>`${!isEventViewer?actionsColumnWidth+4:actionsColumnWidth}px`,({isEventViewer:isEventViewer})=>!isEventViewer?"4px;":"0;");const EventsThGroupData=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__thGroupData ${className}`})).withConfig({displayName:"EventsThGroupData",componentId:"a7jkpo-6"})(["display:flex;> div:hover .siemEventsHeading__handle{display:",";opacity:1;visibility:visible;}"],({isDragging:isDragging})=>isDragging?"none":"block");const EventsTh=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className="",role:role="columnheader"})=>({className:`siemEventsTable__th ${className}`,role:role})).withConfig({displayName:"EventsTh",componentId:"a7jkpo-7"})(["align-items:center;display:flex;flex-shrink:0;min-width:0;.siemEventsTable__thGroupActions &:first-child:last-child{flex:1;}.siemEventsTable__thGroupData &:hover{background-color:",";cursor:move;cursor:grab;}> div:focus{outline:0;}[data-rbd-placeholder-context-id]{display:none !important;}"],({theme:theme})=>theme.eui.euiTableHoverColor);const EventsThContent=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__thContent ${className}`})).withConfig({displayName:"EventsThContent",componentId:"a7jkpo-8"})(["font-size:",";font-weight:",";line-height:",";min-width:0;padding:",";text-align:",";width:",";> button.euiButtonIcon,> .euiToolTipAnchor > button.euiButtonIcon{margin-left:",";}"],({theme:theme})=>theme.eui.euiFontSizeXS,({theme:theme})=>theme.eui.euiFontWeightSemiBold,({theme:theme})=>theme.eui.euiLineHeight,({theme:theme})=>theme.eui.paddingSizes.xs,({textAlign:textAlign})=>textAlign,({width:width})=>width!=null?`${width}px`:"100%",({theme:theme})=>`-${theme.eui.paddingSizes.xs}`);const EventsTbody=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__tbody ${className}`,role:"rowgroup"})).withConfig({displayName:"EventsTbody",componentId:"a7jkpo-9"})(["overflow-x:hidden;"]);const EventsTrGroup=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className="",$ariaRowindex:$ariaRowindex})=>({"aria-rowindex":`${$ariaRowindex}`,className:`siemEventsTable__trGroup ${className}`,role:"row"})).withConfig({displayName:"EventsTrGroup",componentId:"a7jkpo-10"})(["border-bottom:"," solid ",";",";",";",";&:hover{background-color:",";}",""],({theme:theme})=>theme.eui.euiBorderWidthThin,({theme:theme})=>theme.eui.euiColorLightShade,({theme:theme,eventType:eventType,isEvenEqlSequence:isEvenEqlSequence,showLeftBorder:showLeftBorder})=>showLeftBorder?`border-left: 4px solid\n    ${eventType==="raw"?theme.eui.euiColorLightShade:eventType==="eql"&&isEvenEqlSequence?theme.eui.euiColorPrimary:eventType==="eql"&&!isEvenEqlSequence?theme.eui.euiColorAccent:theme.eui.euiColorWarning}`:"",({isBuildingBlockType:isBuildingBlockType})=>isBuildingBlockType?"background: repeating-linear-gradient(127deg, rgba(245, 167, 0, 0.2), rgba(245, 167, 0, 0.2) 1px, rgba(245, 167, 0, 0.05) 2px, rgba(245, 167, 0, 0.05) 10px);":"",({eventType:eventType,isEvenEqlSequence:isEvenEqlSequence})=>eventType==="eql"?isEvenEqlSequence?"background: repeating-linear-gradient(127deg, rgba(0, 107, 180, 0.2), rgba(0, 107, 180, 0.2) 1px, rgba(0, 107, 180, 0.05) 2px, rgba(0, 107, 180, 0.05) 10px);":"background: repeating-linear-gradient(127deg, rgba(221, 10, 115, 0.2), rgba(221, 10, 115, 0.2) 1px, rgba(221, 10, 115, 0.05) 2px, rgba(221, 10, 115, 0.05) 10px);":"",({theme:theme})=>theme.eui.euiTableHoverColor,({isExpanded:isExpanded,theme:theme})=>isExpanded&&`\n    background: ${theme.eui.euiTableSelectedColor};\n\n    &:hover {\n      ${theme.eui.euiTableHoverSelectedColor}\n    }\n  `);const EventsTrData=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__trData ${className}`})).withConfig({displayName:"EventsTrData",componentId:"a7jkpo-11"})(["display:flex;"]);const TIMELINE_EVENT_DETAILS_OFFSET=40;const EventsTrSupplementContainer=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({width:width})=>({role:"dialog",style:{width:`${width-TIMELINE_EVENT_DETAILS_OFFSET}px`}})).withConfig({displayName:"EventsTrSupplementContainer",componentId:"a7jkpo-12"})([""]);const EventsTrSupplement=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__trSupplement ${className}`})).withConfig({displayName:"EventsTrSupplement",componentId:"a7jkpo-13"})(["font-size:",";line-height:",";padding-left:",";.euiAccordion + div{background-color:",";padding:0 ",";border:1px solid ",";border-radius:",";}"],({theme:theme})=>theme.eui.euiFontSizeXS,({theme:theme})=>theme.eui.euiLineHeight,({theme:theme})=>theme.eui.paddingSizes.m,({theme:theme})=>theme.eui.euiColorEmptyShade,({theme:theme})=>theme.eui.paddingSizes.s,({theme:theme})=>theme.eui.euiColorLightShade,({theme:theme})=>theme.eui.paddingSizes.xs);const EventsTdGroupActions=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({"aria-colindex":`${_helpers__WEBPACK_IMPORTED_MODULE_4__["a"]}`,className:`siemEventsTable__tdGroupActions ${className}`,role:"gridcell"})).withConfig({displayName:"EventsTdGroupActions",componentId:"a7jkpo-14"})(["align-items:center;display:flex;flex:0 0 ",";min-width:0;"],({actionsColumnWidth:actionsColumnWidth})=>`${actionsColumnWidth}px`);const EventsTdGroupData=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsTable__tdGroupData ${className}`})).withConfig({displayName:"EventsTdGroupData",componentId:"a7jkpo-15"})(["display:flex;"]);const EVENTS_TD_CLASS_NAME="siemEventsTable__td";const EventsTd=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className="",$ariaColumnIndex:$ariaColumnIndex,width:width})=>{const common={className:`siemEventsTable__td ${className}`,role:"gridcell",style:{flexBasis:width?`${width}px`:"auto"}};return $ariaColumnIndex!=null?{...common,"aria-colindex":`${$ariaColumnIndex}`}:common}).withConfig({displayName:"EventsTd",componentId:"a7jkpo-16"})(["align-items:center;display:flex;flex-shrink:0;min-width:0;.siemEventsTable__tdGroupActions &:first-child:last-child{flex:1;}"]);const EventsTdContent=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className})=>({className:`siemEventsTable__tdContent ${className!=null?className:""}`})).withConfig({displayName:"EventsTdContent",componentId:"a7jkpo-17"})(["font-size:",";line-height:",";min-width:0;padding:",";text-align:",";width:",";button.euiButtonIcon{margin-left:",";}"],({theme:theme})=>theme.eui.euiFontSizeXS,({theme:theme})=>theme.eui.euiLineHeight,({theme:theme})=>theme.eui.paddingSizes.xs,({textAlign:textAlign})=>textAlign,({width:width})=>width!=null?`${width}px`:"100%",({theme:theme})=>`-${theme.eui.paddingSizes.xs}`);const EventsHeading=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsHeading ${className}`})).withConfig({displayName:"EventsHeading",componentId:"a7jkpo-18"})(["align-items:center;display:flex;&:hover{cursor:",";}"],({isLoading:isLoading})=>isLoading?"wait":"grab");const EventsHeadingTitleButton=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.button.attrs(({className:className=""})=>({className:`siemEventsHeading__title siemEventsHeading__title--aggregatable ${className}`,type:"button"})).withConfig({displayName:"EventsHeadingTitleButton",componentId:"a7jkpo-19"})(["align-items:center;display:flex;font-weight:inherit;min-width:0;&:hover,&:focus{color:",";text-decoration:underline;}&:hover{cursor:pointer;}& > * + *{margin-left:",";}"],({theme:theme})=>theme.eui.euiColorPrimary,({theme:theme})=>theme.eui.euiSizeXS);const EventsHeadingTitleSpan=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.span.attrs(({className:className})=>({className:`siemEventsHeading__title siemEventsHeading__title--notAggregatable ${className}`})).withConfig({displayName:"EventsHeadingTitleSpan",componentId:"a7jkpo-20"})(["min-width:0;"]);const EventsHeadingExtra=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsHeading__extra ${className}`})).withConfig({displayName:"EventsHeadingExtra",componentId:"a7jkpo-21"})(["margin-left:auto;margin-right:2px;&.siemEventsHeading__extra--close{opacity:0;transition:all "," ease;visibility:hidden;.siemEventsTable__th:hover &{opacity:1;visibility:visible;}}"],({theme:theme})=>theme.eui.euiAnimSpeedNormal);const EventsHeadingHandle=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({className:className=""})=>({className:`siemEventsHeading__handle ${className}`})).withConfig({displayName:"EventsHeadingHandle",componentId:"a7jkpo-22"})(["background-color:",";height:100%;opacity:0;transition:all "," ease;visibility:hidden;width:",";&:hover{background-color:",";cursor:col-resize;}"],({theme:theme})=>theme.eui.euiBorderColor,({theme:theme})=>theme.eui.euiAnimSpeedNormal,({theme:theme})=>theme.eui.euiBorderWidthThick,({theme:theme})=>theme.eui.euiColorPrimary);const EventsLoading=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiLoadingSpinner"]).withConfig({displayName:"EventsLoading",componentId:"a7jkpo-23"})(["margin:0 2px;vertical-align:middle;"]);const HideShowContainer=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.attrs(({$isVisible:$isVisible=false})=>({style:{display:$isVisible?"block":"none"}})).withConfig({displayName:"HideShowContainer",componentId:"a7jkpo-24"})([""])},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"HostsType",(function(){return HostsType}));__webpack_require__.d(__webpack_exports__,"HostsTableType",(function(){return HostsTableType}));let HostsType;(function(HostsType){HostsType["page"]="page";HostsType["details"]="details"})(HostsType||(HostsType={}));let HostsTableType;(function(HostsTableType){HostsTableType["authentications"]="authentications";HostsTableType["hosts"]="allHosts";HostsTableType["events"]="events";HostsTableType["uncommonProcesses"]="uncommonProcesses";HostsTableType["anomalies"]="anomalies";HostsTableType["alerts"]="alerts"})(HostsTableType||(HostsTableType={}))},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useAppToasts}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _lib_kibana__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(104);var _utils_api__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(340);const useAppToasts=()=>{const toasts=Object(_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["j"])();const addError=Object(react__WEBPACK_IMPORTED_MODULE_0__["useRef"])(toasts.addError.bind(toasts)).current;const addSuccess=Object(react__WEBPACK_IMPORTED_MODULE_0__["useRef"])(toasts.addSuccess.bind(toasts)).current;const addWarning=Object(react__WEBPACK_IMPORTED_MODULE_0__["useRef"])(toasts.addWarning.bind(toasts)).current;const addAppError=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])((error,options)=>addError(error,{...options,toastMessage:error.body.message}),[addError]);const _addError=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])((error,options)=>{if(Object(_utils_api__WEBPACK_IMPORTED_MODULE_2__["a"])(error)){return addAppError(error,options)}else{if(error instanceof Error){return addError(error,options)}else{return addError(new Error(String(error)),options)}}},[addAppError,addError]);return{api:toasts,addError:_addError,addSuccess:addSuccess,addWarning:addWarning}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DragEffects}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DraggableWrapper}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var react_beautiful_dnd__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(240);var react_beautiful_dnd__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_beautiful_dnd__WEBPACK_IMPORTED_MODULE_2__);var react_redux__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_3__);var styled_components__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_4__);var _store_drag_and_drop__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(217);var _timelines_components_row_renderers_browser_constants__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(145);var _truncatable_text__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(266);var _with_hover_actions__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(289);var _draggable_keyboard_wrapper_hook__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(358);var _draggable_wrapper_hover_content__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(759);var _helpers__WEBPACK_IMPORTED_MODULE_11__=__webpack_require__(116);var _provider_container__WEBPACK_IMPORTED_MODULE_12__=__webpack_require__(607);var _translations__WEBPACK_IMPORTED_MODULE_13__=__webpack_require__(452);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const DragEffects=styled_components__WEBPACK_IMPORTED_MODULE_4___default.a.div.withConfig({displayName:"DragEffects",componentId:"m7vcsn-0"})([""]);DragEffects.displayName="DragEffects";class DragDropErrorBoundary extends react__WEBPACK_IMPORTED_MODULE_1___default.a.PureComponent{componentDidCatch(){this.forceUpdate()}render(){return this.props.children}}const Wrapper=styled_components__WEBPACK_IMPORTED_MODULE_4___default.a.div.withConfig({displayName:"Wrapper",componentId:"m7vcsn-1"})(["display:inline-block;max-width:100%;[data-rbd-placeholder-context-id]{display:none !important;}",""],({disabled:disabled})=>disabled&&`\n    [data-rbd-draggable-id]:hover,\n    .euiBadge:hover,\n    .euiBadge__text:hover {\n      cursor: default;\n    }\n  `);Wrapper.displayName="Wrapper";const ProviderContentWrapper=styled_components__WEBPACK_IMPORTED_MODULE_4___default.a.span.withConfig({displayName:"ProviderContentWrapper",componentId:"m7vcsn-2"})(["> span.euiToolTipAnchor{display:block;}"]);const getStyle=(style,snapshot)=>{if(!snapshot.isDropAnimating){return style}return{...style,transitionDuration:"0.00000001s"}};const draggableContainsLinks=draggableElement=>{var _draggableElement$que;const links=(_draggableElement$que=draggableElement===null||draggableElement===void 0?void 0:draggableElement.querySelectorAll(".euiLink"))!==null&&_draggableElement$que!==void 0?_draggableElement$que:[];return links.length>0};const DraggableWrapperComponent=({dataProvider:dataProvider,onFilterAdded:onFilterAdded,render:render,timelineId:timelineId,truncate:truncate})=>{const keyboardHandlerRef=Object(react__WEBPACK_IMPORTED_MODULE_1__["useRef"])(null);const draggableRef=Object(react__WEBPACK_IMPORTED_MODULE_1__["useRef"])(null);const[closePopOverTrigger,setClosePopOverTrigger]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);const[showTopN,setShowTopN]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);const[goGetTimelineId,setGoGetTimelineId]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);const timelineIdFind=Object(_draggable_wrapper_hover_content__WEBPACK_IMPORTED_MODULE_10__["b"])(draggableRef,goGetTimelineId);const[providerRegistered,setProviderRegistered]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);const isDisabled=dataProvider.id.includes(`-${_timelines_components_row_renderers_browser_constants__WEBPACK_IMPORTED_MODULE_6__["a"]}-`);const[hoverActionsOwnFocus,setHoverActionsOwnFocus]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_3__["useDispatch"])();const handleClosePopOverTrigger=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setClosePopOverTrigger(prevClosePopOverTrigger=>!prevClosePopOverTrigger);setHoverActionsOwnFocus(prevHoverActionsOwnFocus=>{if(prevHoverActionsOwnFocus){setTimeout(()=>{var _keyboardHandlerRef$c;(_keyboardHandlerRef$c=keyboardHandlerRef.current)===null||_keyboardHandlerRef$c===void 0?void 0:_keyboardHandlerRef$c.focus()},0)}return false});setTimeout(()=>{setHoverActionsOwnFocus(false)},0)},[keyboardHandlerRef]);const toggleTopN=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setShowTopN(prevShowTopN=>{const newShowTopN=!prevShowTopN;if(newShowTopN===false){handleClosePopOverTrigger()}return newShowTopN})},[handleClosePopOverTrigger]);const registerProvider=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{if(!isDisabled){dispatch(_store_drag_and_drop__WEBPACK_IMPORTED_MODULE_5__["a"].registerProvider({provider:dataProvider}));setProviderRegistered(true)}},[isDisabled,dispatch,dataProvider]);const unRegisterProvider=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>providerRegistered&&dispatch(_store_drag_and_drop__WEBPACK_IMPORTED_MODULE_5__["a"].unRegisterProvider({id:dataProvider.id})),[providerRegistered,dispatch,dataProvider.id]);Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>()=>{unRegisterProvider()},[unRegisterProvider]);const hoverContent=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>{const additionalContent=hoverActionsOwnFocus&&!showTopN&&draggableContainsLinks(draggableRef.current)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ProviderContentWrapper,{"data-test-subj":`draggable-link-content-${dataProvider.queryMatch.field}`},render(dataProvider,null,{isDragging:false,isDropAnimating:false})):null;return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_draggable_wrapper_hover_content__WEBPACK_IMPORTED_MODULE_10__["a"],{additionalContent:additionalContent,closePopOver:handleClosePopOverTrigger,draggableId:Object(_helpers__WEBPACK_IMPORTED_MODULE_11__["o"])(dataProvider.id),field:dataProvider.queryMatch.field,goGetTimelineId:setGoGetTimelineId,onFilterAdded:onFilterAdded,ownFocus:hoverActionsOwnFocus,showTopN:showTopN,timelineId:timelineId!==null&&timelineId!==void 0?timelineId:timelineIdFind,toggleTopN:toggleTopN,value:typeof dataProvider.queryMatch.value!=="number"?dataProvider.queryMatch.value:`${dataProvider.queryMatch.value}`})},[dataProvider,handleClosePopOverTrigger,hoverActionsOwnFocus,onFilterAdded,render,showTopN,timelineId,timelineIdFind,toggleTopN]);const RenderClone=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])((provided,snapshot)=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ConditionalPortal,{registerProvider:registerProvider},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",_extends({},provided.draggableProps,provided.dragHandleProps,{style:getStyle(provided.draggableProps.style,snapshot),ref:provided.innerRef,"data-test-subj":"providerContainer",tabIndex:-1}),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ProviderContentWrapper,{"data-test-subj":`draggable-content-${dataProvider.queryMatch.field}`},render(dataProvider,provided,snapshot)))),[dataProvider,registerProvider,render]);const DraggableContent=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])((provided,snapshot)=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_provider_container__WEBPACK_IMPORTED_MODULE_12__["a"],_extends({},provided.draggableProps,provided.dragHandleProps,{ref:e=>{provided.innerRef(e);draggableRef.current=e},"data-test-subj":"providerContainer",isDragging:snapshot.isDragging,registerProvider:registerProvider,tabIndex:-1}),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiScreenReaderOnly"],{"data-test-subj":"screenReaderOnlyField"},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("p",null,dataProvider.queryMatch.field)),truncate&&!snapshot.isDragging?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_truncatable_text__WEBPACK_IMPORTED_MODULE_7__["a"],{"data-test-subj":"draggable-truncatable-content"},render(dataProvider,provided,snapshot)):react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ProviderContentWrapper,{"data-test-subj":`draggable-content-${dataProvider.queryMatch.field}`},render(dataProvider,provided,snapshot)),!snapshot.isDragging&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiScreenReaderOnly"],{"data-test-subj":"draggableKeyboardInstructionsNotDragging"},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("p",null,_translations__WEBPACK_IMPORTED_MODULE_13__["c"]))),[dataProvider,registerProvider,render,truncate]);const openPopover=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setHoverActionsOwnFocus(true)},[]);const{onBlur:onBlur,onKeyDown:onKeyDown}=Object(_draggable_keyboard_wrapper_hook__WEBPACK_IMPORTED_MODULE_9__["a"])({closePopover:handleClosePopOverTrigger,draggableId:Object(_helpers__WEBPACK_IMPORTED_MODULE_11__["o"])(dataProvider.id),fieldName:dataProvider.queryMatch.field,keyboardHandlerRef:keyboardHandlerRef,openPopover:openPopover});const onFocus=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{if(!hoverActionsOwnFocus){var _keyboardHandlerRef$c2;(_keyboardHandlerRef$c2=keyboardHandlerRef.current)===null||_keyboardHandlerRef$c2===void 0?void 0:_keyboardHandlerRef$c2.focus()}},[hoverActionsOwnFocus,keyboardHandlerRef]);const onCloseRequested=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setShowTopN(false);if(hoverActionsOwnFocus){setHoverActionsOwnFocus(false);setTimeout(()=>{onFocus()},0)}},[onFocus,hoverActionsOwnFocus]);const DroppableContent=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(droppableProvided=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",_extends({ref:droppableProvided.innerRef},droppableProvided.droppableProps),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{className:_helpers__WEBPACK_IMPORTED_MODULE_11__["a"],"data-test-subj":"draggableWrapperKeyboardHandler",onClick:onFocus,onBlur:onBlur,onKeyDown:onKeyDown,ref:keyboardHandlerRef,role:"button",tabIndex:0},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_beautiful_dnd__WEBPACK_IMPORTED_MODULE_2__["Draggable"],{draggableId:Object(_helpers__WEBPACK_IMPORTED_MODULE_11__["o"])(dataProvider.id),index:0,key:Object(_helpers__WEBPACK_IMPORTED_MODULE_11__["o"])(dataProvider.id),isDragDisabled:isDisabled},DraggableContent)),droppableProvided.placeholder),[DraggableContent,dataProvider.id,isDisabled,onBlur,onFocus,onKeyDown]);const content=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Wrapper,{"data-test-subj":"draggableWrapperDiv",disabled:isDisabled},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(DragDropErrorBoundary,null,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react_beautiful_dnd__WEBPACK_IMPORTED_MODULE_2__["Droppable"],{isDropDisabled:true,droppableId:Object(_helpers__WEBPACK_IMPORTED_MODULE_11__["p"])(dataProvider.id),renderClone:RenderClone},DroppableContent))),[DroppableContent,RenderClone,dataProvider.id,isDisabled]);const renderContent=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>content,[content]);if(isDisabled)return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,content);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_with_hover_actions__WEBPACK_IMPORTED_MODULE_8__["b"],{alwaysShow:showTopN||hoverActionsOwnFocus,closePopOverTrigger:closePopOverTrigger,hoverContent:hoverContent,onCloseRequested:onCloseRequested,render:renderContent})};const DraggableWrapper=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(DraggableWrapperComponent);DraggableWrapper.displayName="DraggableWrapper";const ConditionalPortal=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({children:children,registerProvider:registerProvider})=>{Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{registerProvider()},[registerProvider]);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,children)});ConditionalPortal.displayName="ConditionalPortal"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID}));const ROW_RENDERER_BROWSER_EXAMPLE_TIMELINE_ID="row-renderer-example"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HeaderSection}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _inspect__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(189);var _subtitle__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(614);const Header=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.header.attrs(()=>({className:"siemHeaderSection"})).withConfig({displayName:"Header",componentId:"g1ve9j-0"})([""," margin-bottom:",";user-select:text;",""],({height:height})=>height&&Object(styled_components__WEBPACK_IMPORTED_MODULE_2__["css"])(["height:","px;"],height),({height:height,theme:theme})=>height?0:theme.eui.euiSizeL,({border:border})=>border&&Object(styled_components__WEBPACK_IMPORTED_MODULE_2__["css"])(["border-bottom:",";padding-bottom:",";"],({theme:theme})=>theme.eui.euiBorderThin,({theme:theme})=>theme.eui.paddingSizes.l));Header.displayName="Header";const HeaderSectionComponent=({border:border,children:children,height:height,id:id,split:split,subtitle:subtitle,title:title,titleSize:titleSize="m",tooltip:tooltip,growLeftSplit:growLeftSplit=true})=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Header,{"data-test-subj":"header-section",border:border,height:height},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{alignItems:"center"},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:growLeftSplit},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{alignItems:"center",responsive:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],null,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiTitle"],{size:titleSize},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("h2",{"data-test-subj":"header-section-title"},title,tooltip&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null," ",react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiIconTip"],{color:"subdued",content:tooltip,size:"l",type:"iInCircle"})))),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_subtitle__WEBPACK_IMPORTED_MODULE_4__["a"],{"data-test-subj":"header-section-subtitle",items:subtitle})),id&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_inspect__WEBPACK_IMPORTED_MODULE_3__["a"],{queryId:id,inspectIndex:0,title:title})))),children&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{"data-test-subj":"header-section-supplements",grow:split?true:false},children)));const HeaderSection=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(HeaderSectionComponent)},,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return useManageTimeline}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ManageGlobalTimeline}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var lodash_fp__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_1__);var _common_components_events_viewer_translations__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(444);var _timeline_footer_translations__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(588);var _store_timeline_defaults__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(118);const initManageTimeline={};const getTimelineDefaults=id=>({defaultModel:_store_timeline_defaults__WEBPACK_IMPORTED_MODULE_4__["a"],loadingText:_common_components_events_viewer_translations__WEBPACK_IMPORTED_MODULE_2__["b"],footerText:_timeline_footer_translations__WEBPACK_IMPORTED_MODULE_3__["e"],documentType:_timeline_footer_translations__WEBPACK_IMPORTED_MODULE_3__["e"],selectAll:false,id:id,isLoading:false,queryFields:[],title:_common_components_events_viewer_translations__WEBPACK_IMPORTED_MODULE_2__["a"],unit:n=>_common_components_events_viewer_translations__WEBPACK_IMPORTED_MODULE_2__["d"](n)});const reducerManageTimeline=(state,action)=>{switch(action.type){case"INITIALIZE_TIMELINE":return{...state,[action.id]:{...getTimelineDefaults(action.id),...state[action.id],...action.payload}};case"SET_SELECT_ALL":return{...state,[action.id]:{...state[action.id],selectAll:action.payload}};case"SET_IS_LOADING":return{...state,[action.id]:{...state[action.id],isLoading:action.payload}};default:return state}};const useTimelineManager=manageTimelineForTesting=>{const[state,dispatch]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useReducer"])(reducerManageTimeline,manageTimelineForTesting!==null&&manageTimelineForTesting!==void 0?manageTimelineForTesting:initManageTimeline);const initializeTimeline=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(newTimeline=>{dispatch({type:"INITIALIZE_TIMELINE",id:newTimeline.id,payload:newTimeline})},[]);const setIsTimelineLoading=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(({id:id,isLoading:isLoading})=>{dispatch({type:"SET_IS_LOADING",id:id,payload:isLoading})},[]);const setSelectAll=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(({id:id,selectAll:selectAll})=>{dispatch({type:"SET_SELECT_ALL",id:id,payload:selectAll})},[]);const getTimelineFilterManager=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(id=>{var _state$id;return(_state$id=state[id])===null||_state$id===void 0?void 0:_state$id.filterManager},[state]);const getManageTimelineById=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(id=>{if(state[id]!=null){return state[id]}initializeTimeline({id:id});return getTimelineDefaults(id)},[initializeTimeline,state]);const isManagedTimeline=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(id=>state[id]!=null,[state]);return{getManageTimelineById:getManageTimelineById,getTimelineFilterManager:getTimelineFilterManager,initializeTimeline:initializeTimeline,isManagedTimeline:isManagedTimeline,setIsTimelineLoading:setIsTimelineLoading,setSelectAll:setSelectAll}};const init={getManageTimelineById:id=>getTimelineDefaults(id),getTimelineFilterManager:()=>undefined,initializeTimeline:()=>lodash_fp__WEBPACK_IMPORTED_MODULE_1__["noop"],isManagedTimeline:()=>false,setIsTimelineLoading:()=>lodash_fp__WEBPACK_IMPORTED_MODULE_1__["noop"],setSelectAll:()=>lodash_fp__WEBPACK_IMPORTED_MODULE_1__["noop"]};const ManageTimelineContext=Object(react__WEBPACK_IMPORTED_MODULE_0__["createContext"])(init);const useManageTimeline=()=>Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(ManageTimelineContext);const ManageGlobalTimeline=({children:children,manageTimelineForTesting:manageTimelineForTesting})=>{const timelineManager=useTimelineManager(manageTimelineForTesting);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(ManageTimelineContext.Provider,{value:timelineManager},children)}},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return createRule}));__webpack_require__.d(__webpack_exports__,"p",(function(){return updateRule}));__webpack_require__.d(__webpack_exports__,"n",(function(){return patchRule}));__webpack_require__.d(__webpack_exports__,"h",(function(){return fetchRules}));__webpack_require__.d(__webpack_exports__,"g",(function(){return fetchRuleById}));__webpack_require__.d(__webpack_exports__,"o",(function(){return pureFetchRuleById}));__webpack_require__.d(__webpack_exports__,"e",(function(){return enableRules}));__webpack_require__.d(__webpack_exports__,"c",(function(){return deleteRules}));__webpack_require__.d(__webpack_exports__,"d",(function(){return duplicateRules}));__webpack_require__.d(__webpack_exports__,"a",(function(){return createPrepackagedRules}));__webpack_require__.d(__webpack_exports__,"m",(function(){return importRules}));__webpack_require__.d(__webpack_exports__,"f",(function(){return exportRules}));__webpack_require__.d(__webpack_exports__,"k",(function(){return getRuleStatusById}));__webpack_require__.d(__webpack_exports__,"l",(function(){return getRulesStatusByIds}));__webpack_require__.d(__webpack_exports__,"i",(function(){return fetchTags}));__webpack_require__.d(__webpack_exports__,"j",(function(){return getPrePackagedRulesStatus}));var _common_constants__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(104);var _pages_detection_engine_rules_translations__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(128);const createRule=async({rule:rule,signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"],{method:"POST",body:JSON.stringify(rule),signal:signal});const updateRule=async({rule:rule,signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"],{method:"PUT",body:JSON.stringify(rule),signal:signal});const patchRule=async({ruleProperties:ruleProperties,signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"],{method:"PATCH",body:JSON.stringify(ruleProperties),signal:signal});const fetchRules=async({filterOptions:filterOptions={filter:"",sortField:"enabled",sortOrder:"desc",showCustomRules:false,showElasticRules:false,tags:[]},pagination:pagination={page:1,perPage:20,total:0},signal:signal})=>{const showCustomRuleFilter=filterOptions.showCustomRules?[`alert.attributes.tags: "__internal_immutable:false"`]:[];const showElasticRuleFilter=filterOptions.showElasticRules?[`alert.attributes.tags: "__internal_immutable:true"`]:[];const filtersWithoutTags=[...filterOptions.filter.length?[`alert.attributes.name: ${filterOptions.filter}`]:[],...showCustomRuleFilter,...showElasticRuleFilter].join(" AND ");const tags=filterOptions.tags.map(t=>`alert.attributes.tags: "${t.replace(/"/g,'\\"')}"`).join(" AND ");const filterString=filtersWithoutTags!==""&&tags!==""?`${filtersWithoutTags} AND (${tags})`:filtersWithoutTags+tags;const getFieldNameForSortField=field=>field==="name"?`${field}.keyword`:field;const query={page:pagination.page,per_page:pagination.perPage,sort_field:getFieldNameForSortField(filterOptions.sortField),sort_order:filterOptions.sortOrder,...filterString!==""?{filter:filterString}:{}};return _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"]}/_find`,{method:"GET",query:query,signal:signal})};const fetchRuleById=async({id:id,signal:signal})=>pureFetchRuleById({id:id,http:_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http,signal:signal});const pureFetchRuleById=async({id:id,http:http,signal:signal})=>http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"],{method:"GET",query:{id:id},signal:signal});const enableRules=async({ids:ids,enabled:enabled})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"]}/_bulk_update`,{method:"PATCH",body:JSON.stringify(ids.map(id=>({id:id,enabled:enabled})))});const deleteRules=async({ids:ids})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"]}/_bulk_delete`,{method:"POST",body:JSON.stringify(ids.map(id=>({id:id})))});const duplicateRules=async({rules:rules})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"]}/_bulk_create`,{method:"POST",body:JSON.stringify(rules.map(rule=>({...rule,name:`${rule.name} [${_pages_detection_engine_rules_translations__WEBPACK_IMPORTED_MODULE_2__["L"]}]`,created_at:undefined,created_by:undefined,id:undefined,rule_id:undefined,updated_at:undefined,updated_by:undefined,enabled:rule.enabled,immutable:undefined,last_success_at:undefined,last_success_message:undefined,last_failure_at:undefined,last_failure_message:undefined,status:undefined,status_date:undefined})))});const createPrepackagedRules=async({signal:signal})=>{const result=await _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["I"],{method:"PUT",signal:signal});return result};const importRules=async({fileToImport:fileToImport,overwrite:overwrite=false,signal:signal})=>{const formData=new FormData;formData.append("file",fileToImport);return _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"]}/_import`,{method:"POST",headers:{"Content-Type":undefined},query:{overwrite:overwrite},body:formData,signal:signal})};const exportRules=async({excludeExportDetails:excludeExportDetails=false,filename:filename=`${_pages_detection_engine_rules_translations__WEBPACK_IMPORTED_MODULE_2__["T"]}.ndjson`,ids:ids=[],signal:signal})=>{const body=ids.length>0?JSON.stringify({objects:ids.map(rule=>({rule_id:rule}))}):undefined;return _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["M"]}/_export`,{method:"POST",body:body,query:{exclude_export_details:excludeExportDetails,file_name:filename},signal:signal})};const getRuleStatusById=async({id:id,signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["L"],{method:"POST",body:JSON.stringify({ids:[id]}),signal:signal});const getRulesStatusByIds=async({ids:ids,signal:signal})=>{const res=await _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["L"],{method:"POST",body:JSON.stringify({ids:ids}),signal:signal});return res};const fetchTags=async({signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["O"],{method:"GET",signal:signal});const getPrePackagedRulesStatus=async({signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["H"],{method:"GET",signal:signal})},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=curry;function curried(f,length,acc){return function fn(){var combined=acc.concat(Array.prototype.slice.call(arguments));return combined.length>=length?f.apply(this,combined):curried(f,length,combined)}}function curry(f){return curried(f,f.length,[])}module.exports=exports["default"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return convertKueryToElasticSearchQuery}));__webpack_require__.d(__webpack_exports__,"c",(function(){return escapeQueryValue}));__webpack_require__.d(__webpack_exports__,"b",(function(){return convertToBuildEsQuery}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(77);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__);const convertKueryToElasticSearchQuery=(kueryExpression,indexPattern)=>{try{return kueryExpression?JSON.stringify(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__["esKuery"].toElasticsearchQuery(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__["esKuery"].fromKueryExpression(kueryExpression),indexPattern)):""}catch(err){return""}};const convertKueryToDslFilter=(kueryExpression,indexPattern)=>{try{return kueryExpression?_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__["esKuery"].toElasticsearchQuery(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__["esKuery"].fromKueryExpression(kueryExpression),indexPattern):{}}catch(err){return{}}};const escapeQueryValue=(val="")=>{if(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isString"])(val)){if(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(val)){return'""'}return`"${escapeKuery(val)}"`}return val};const escapeWhitespace=val=>val.replace(/\t/g,"\\t").replace(/\r/g,"\\r").replace(/\n/g,"\\n");const escapeSpecialCharacters=val=>val.replace(/["]/g,"\\$&");const escapeKuery=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["flow"])(escapeSpecialCharacters,escapeWhitespace);const convertToBuildEsQuery=({config:config,indexPattern:indexPattern,queries:queries,filters:filters})=>{try{return JSON.stringify(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_1__["esQuery"].buildEsQuery(indexPattern,queries,filters.filter(f=>f.meta.disabled===false),{...config,dateFormatTZ:undefined}))}catch(exp){return""}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useGlobalTime}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var react_redux__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_2__);var _hooks_use_selector__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(109);var _store__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(122);var _store_actions__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(224);const useGlobalTime=(clearAllQuery=true)=>{const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_2__["useDispatch"])();const{from:from,to:to}=Object(_hooks_use_selector__WEBPACK_IMPORTED_MODULE_3__["a"])(state=>Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["pick"])(["from","to"],_store__WEBPACK_IMPORTED_MODULE_4__["inputsSelectors"].globalTimeRangeSelector(state)));const[isInitializing,setIsInitializing]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(true);const setQuery=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(({id:id,inspect:inspect,loading:loading,refetch:refetch})=>dispatch(_store_actions__WEBPACK_IMPORTED_MODULE_5__["c"].setQuery({inputId:"global",id:id,inspect:inspect,loading:loading,refetch:refetch})),[dispatch]);const deleteQuery=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(({id:id})=>dispatch(_store_actions__WEBPACK_IMPORTED_MODULE_5__["c"].deleteOneQuery({inputId:"global",id:id})),[dispatch]);Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{if(isInitializing){setIsInitializing(false)}return()=>{if(clearAllQuery){dispatch(_store_actions__WEBPACK_IMPORTED_MODULE_5__["c"].deleteAllQuery({id:"global"}))}}},[clearAllQuery,dispatch,isInitializing]);const memoizedReturn=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>({isInitializing:isInitializing,from:from,to:to,setQuery:setQuery,deleteQuery:deleteQuery}),[deleteQuery,from,isInitializing,setQuery,to]);return memoizedReturn}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"r",(function(){return DETECTION_LIST}));__webpack_require__.d(__webpack_exports__,"v",(function(){return ENDPOINT_LIST}));__webpack_require__.d(__webpack_exports__,"u",(function(){return EDIT}));__webpack_require__.d(__webpack_exports__,"H",(function(){return REMOVE}));__webpack_require__.d(__webpack_exports__,"l",(function(){return COMMENTS_SHOW}));__webpack_require__.d(__webpack_exports__,"k",(function(){return COMMENTS_HIDE}));__webpack_require__.d(__webpack_exports__,"o",(function(){return DATE_CREATED}));__webpack_require__.d(__webpack_exports__,"n",(function(){return CREATED_BY}));__webpack_require__.d(__webpack_exports__,"m",(function(){return COMMENT_EVENT}));__webpack_require__.d(__webpack_exports__,"E",(function(){return OPERATING_SYSTEM}));__webpack_require__.d(__webpack_exports__,"I",(function(){return SEARCH_DEFAULT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ADD_EXCEPTION_LABEL}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ADD_TO_ENDPOINT_LIST}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ADD_TO_DETECTIONS_LIST}));__webpack_require__.d(__webpack_exports__,"y",(function(){return EXCEPTION_EMPTY_PROMPT_TITLE}));__webpack_require__.d(__webpack_exports__,"z",(function(){return EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY}));__webpack_require__.d(__webpack_exports__,"x",(function(){return EXCEPTION_EMPTY_PROMPT_BODY}));__webpack_require__.d(__webpack_exports__,"A",(function(){return FETCH_LIST_ERROR}));__webpack_require__.d(__webpack_exports__,"p",(function(){return DELETE_EXCEPTION_ERROR}));__webpack_require__.d(__webpack_exports__,"B",(function(){return ITEMS_PER_PAGE}));__webpack_require__.d(__webpack_exports__,"D",(function(){return NUMBER_OF_ITEMS}));__webpack_require__.d(__webpack_exports__,"G",(function(){return REFRESH}));__webpack_require__.d(__webpack_exports__,"J",(function(){return SHOWING_EXCEPTIONS}));__webpack_require__.d(__webpack_exports__,"h",(function(){return AND}));__webpack_require__.d(__webpack_exports__,"F",(function(){return OR}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ADD_COMMENT_PLACEHOLDER}));__webpack_require__.d(__webpack_exports__,"e",(function(){return ADD_TO_CLIPBOARD}));__webpack_require__.d(__webpack_exports__,"q",(function(){return DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"K",(function(){return TOTAL_ITEMS_FETCH_ERROR}));__webpack_require__.d(__webpack_exports__,"j",(function(){return CLEAR_EXCEPTIONS_LABEL}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ADD_EXCEPTION_FETCH_404_ERROR}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ADD_EXCEPTION_FETCH_ERROR}));__webpack_require__.d(__webpack_exports__,"w",(function(){return ERROR}));__webpack_require__.d(__webpack_exports__,"i",(function(){return CANCEL}));__webpack_require__.d(__webpack_exports__,"C",(function(){return MODAL_ERROR_ACCORDION_TEXT}));__webpack_require__.d(__webpack_exports__,"t",(function(){return DISSASOCIATE_LIST_SUCCESS}));__webpack_require__.d(__webpack_exports__,"s",(function(){return DISSASOCIATE_EXCEPTION_LIST_ERROR}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const DETECTION_LIST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.detectionListLabel",{defaultMessage:"Detection list"});const ENDPOINT_LIST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.endpointListLabel",{defaultMessage:"Endpoint list"});const EDIT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.editButtonLabel",{defaultMessage:"Edit"});const REMOVE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.removeButtonLabel",{defaultMessage:"Remove"});const COMMENTS_SHOW=comments=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.showCommentsLabel",{values:{comments:comments},defaultMessage:"Show ({comments}) {comments, plural, =1 {Comment} other {Comments}}"});const COMMENTS_HIDE=comments=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.hideCommentsLabel",{values:{comments:comments},defaultMessage:"Hide ({comments}) {comments, plural, =1 {Comment} other {Comments}}"});const DATE_CREATED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.dateCreatedLabel",{defaultMessage:"Date created"});const CREATED_BY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.createdByLabel",{defaultMessage:"Created by"});const COMMENT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.commentLabel",{defaultMessage:"Comment"});const COMMENT_EVENT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.commentEventLabel",{defaultMessage:"added a comment"});const OPERATING_SYSTEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.operatingSystemLabel",{defaultMessage:"OS"});const SEARCH_DEFAULT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.searchDefaultPlaceholder",{defaultMessage:"Search field (ex: host.name)"});const ADD_EXCEPTION_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.addExceptionLabel",{defaultMessage:"Add new exception"});const ADD_TO_ENDPOINT_LIST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.addToEndpointListLabel",{defaultMessage:"Add Endpoint exception"});const ADD_TO_DETECTIONS_LIST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.addToDetectionsListLabel",{defaultMessage:"Add rule exception"});const EXCEPTION_EMPTY_PROMPT_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.emptyPromptTitle",{defaultMessage:"This rule has no exceptions"});const EXCEPTION_NO_SEARCH_RESULTS_PROMPT_BODY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.noSearchResultsPromptBody",{defaultMessage:"No search results found."});const EXCEPTION_EMPTY_PROMPT_BODY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.emptyPromptBody",{defaultMessage:"You can add exceptions to fine tune the rule so that detection alerts are not created when exception conditions are met. Exceptions improve detection accuracy, which can help reduce the number of false positives."});const FETCH_LIST_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.fetchingListError",{defaultMessage:"Error fetching exceptions"});const DELETE_EXCEPTION_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.deleteExceptionError",{defaultMessage:"Error deleting exception"});const ITEMS_PER_PAGE=items=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.exceptionsPaginationLabel",{values:{items:items},defaultMessage:"Items per page: {items}"});const NUMBER_OF_ITEMS=items=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.paginationNumberOfItemsLabel",{values:{items:items},defaultMessage:"{items} items"});const REFRESH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.utilityRefreshLabel",{defaultMessage:"Refresh"});const SHOWING_EXCEPTIONS=items=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.utilityNumberExceptionsLabel",{values:{items:items},defaultMessage:"Showing {items} {items, plural, =1 {exception} other {exceptions}}"});const FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.fieldDescription",{defaultMessage:"Field"});const OPERATOR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.operatorDescription",{defaultMessage:"Operator"});const VALUE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.valueDescription",{defaultMessage:"Value"});const AND=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.andDescription",{defaultMessage:"AND"});const OR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.orDescription",{defaultMessage:"OR"});const ADD_COMMENT_PLACEHOLDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.addCommentPlaceholder",{defaultMessage:"Add a new comment..."});const ADD_TO_CLIPBOARD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.addToClipboard",{defaultMessage:"Comment"});const DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.descriptionLabel",{defaultMessage:"Description"});const TOTAL_ITEMS_FETCH_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.viewer.fetchTotalsError",{defaultMessage:"Error getting exception item totals"});const CLEAR_EXCEPTIONS_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.clearExceptionsLabel",{defaultMessage:"Remove Exception List"});const ADD_EXCEPTION_FETCH_404_ERROR=listId=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.fetch404Error",{values:{listId:listId},defaultMessage:"The associated exception list ({listId}) no longer exists. Please remove the missing exception list to add additional exceptions to the detection rule."});const ADD_EXCEPTION_FETCH_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.fetchError",{defaultMessage:"Error fetching exception list"});const ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.errorLabel",{defaultMessage:"Error"});const CANCEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.cancelLabel",{defaultMessage:"Cancel"});const MODAL_ERROR_ACCORDION_TEXT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.modalErrorAccordionText",{defaultMessage:"Show rule reference information:"});const DISSASOCIATE_LIST_SUCCESS=id=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.dissasociateListSuccessText",{values:{id:id},defaultMessage:"Exception list ({id}) has successfully been removed"});const DISSASOCIATE_EXCEPTION_LIST_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.dissasociateExceptionListError",{defaultMessage:"Failed to remove exception list"})},function(module,__webpack_exports__,__webpack_require__){"use strict";var _shared_imports__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(110);__webpack_require__.d(__webpack_exports__,"a",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["b"]}));__webpack_require__.d(__webpack_exports__,"b",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["g"]}));__webpack_require__.d(__webpack_exports__,"c",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["h"]}));__webpack_require__.d(__webpack_exports__,"d",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["l"]}));__webpack_require__.d(__webpack_exports__,"e",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["m"]}));__webpack_require__.d(__webpack_exports__,"f",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["p"]}));__webpack_require__.d(__webpack_exports__,"g",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["q"]}));__webpack_require__.d(__webpack_exports__,"h",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["s"]}));__webpack_require__.d(__webpack_exports__,"i",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["u"]}));__webpack_require__.d(__webpack_exports__,"j",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["A"]}));__webpack_require__.d(__webpack_exports__,"k",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["F"]}));__webpack_require__.d(__webpack_exports__,"l",(function(){return _shared_imports__WEBPACK_IMPORTED_MODULE_0__["H"]}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return hasLargeValueList}));__webpack_require__.d(__webpack_exports__,"b",(function(){return hasEqlSequenceQuery}));__webpack_require__.d(__webpack_exports__,"d",(function(){return isEqlRule}));__webpack_require__.d(__webpack_exports__,"g",(function(){return isThresholdRule}));__webpack_require__.d(__webpack_exports__,"e",(function(){return isQueryRule}));__webpack_require__.d(__webpack_exports__,"f",(function(){return isThreatMatchRule}));__webpack_require__.d(__webpack_exports__,"h",(function(){return normalizeThresholdField}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getRuleStatusText}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(19);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);const hasLargeValueItem=exceptionItems=>exceptionItems.some(exceptionItem=>hasLargeValueList(exceptionItem.entries));const hasLargeValueList=entries=>{const found=entries.filter(({type:type})=>type==="list");return found.length>0};const hasNestedEntry=entries=>{const found=entries.filter(({type:type})=>type==="nested");return found.length>0};const hasEqlSequenceQuery=ruleQuery=>{if(ruleQuery!=null){const parsedQuery=ruleQuery.trim().split(/[ \t\r\n]+/);return parsedQuery[0]==="sequence"&&parsedQuery[1]!=="where"}return false};const isEqlRule=ruleType=>ruleType==="eql";const isThresholdRule=ruleType=>ruleType==="threshold";const isQueryRule=ruleType=>ruleType==="query"||ruleType==="saved_query";const isThreatMatchRule=ruleType=>ruleType==="threat_match";const normalizeThresholdField=thresholdField=>Array.isArray(thresholdField)?thresholdField:Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(thresholdField)?[]:[thresholdField];const getRuleStatusText=value=>value==="partial failure"?"warning":value!=null?value:null},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Provider}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _data_provider__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(126);var _provider_item_badge__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(775);const Provider=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({dataProvider:dataProvider})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_provider_item_badge__WEBPACK_IMPORTED_MODULE_3__["a"],{deleteProvider:lodash_fp__WEBPACK_IMPORTED_MODULE_0__["noop"],field:dataProvider.queryMatch.displayField||dataProvider.queryMatch.field,kqlQuery:dataProvider.kqlQuery,isEnabled:dataProvider.enabled,isExcluded:dataProvider.excluded,providerId:dataProvider.id,isPopoverOpen:isPopoverOpen,setIsPopoverOpen:setIsPopoverOpen,toggleExcludedProvider:lodash_fp__WEBPACK_IMPORTED_MODULE_0__["noop"],toggleEnabledProvider:lodash_fp__WEBPACK_IMPORTED_MODULE_0__["noop"],toggleTypeProvider:lodash_fp__WEBPACK_IMPORTED_MODULE_0__["noop"],val:dataProvider.queryMatch.displayValue||dataProvider.queryMatch.value,operator:dataProvider.queryMatch.operator||_data_provider__WEBPACK_IMPORTED_MODULE_2__["c"],type:dataProvider.type||_data_provider__WEBPACK_IMPORTED_MODULE_2__["a"].default})});Provider.displayName="Provider"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useMlCapabilities}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _permissions_ml_capabilities_provider__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(760);const useMlCapabilities=()=>Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_permissions_ml_capabilities_provider__WEBPACK_IMPORTED_MODULE_1__["a"])},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return NotFoundPage}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(74);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__);var _common_components_wrapper_page__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(138);const NotFoundPage=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(()=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_components_wrapper_page__WEBPACK_IMPORTED_MODULE_2__["a"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__["FormattedMessage"],{id:"xpack.securitySolution.pages.fourohfour.noContentFoundDescription",defaultMessage:"No content found"})));NotFoundPage.displayName="NotFoundPage"},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(448);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(288);var _rgba2=_interopRequireDefault(_rgba);var _hsl=__webpack_require__(596);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(598);var _hsla2=_interopRequireDefault(_hsla);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var isRgb=function isRgb(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isRgba=function isRgba(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&typeof color.alpha==="number"};var isHsl=function isHsl(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isHsla=function isHsla(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&typeof color.alpha==="number"};var errMsg="Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.";function toColorString(color){if(typeof color!=="object")throw new Error(errMsg);if(isRgba(color))return(0,_rgba2.default)(color);if(isRgb(color))return(0,_rgb2.default)(color);if(isHsla(color))return(0,_hsla2.default)(color);if(isHsl(color))return(0,_hsl2.default)(color);throw new Error(errMsg)}exports.default=toColorString;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Loader}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var polished__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(180);var polished__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(polished__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);var styled_components__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_3__);const Aside=styled_components__WEBPACK_IMPORTED_MODULE_3___default.a.aside.withConfig({displayName:"Aside",componentId:"sc-10s9ue6-0"})(["padding:",";",""],({theme:theme})=>theme.eui.paddingSizes.m,({overlay:overlay,overlayBackground:overlayBackground,theme:theme})=>overlay&&Object(styled_components__WEBPACK_IMPORTED_MODULE_3__["css"])(["background:",";bottom:0;left:0;position:absolute;right:0;top:0;z-index:",";"],overlayBackground?Object(polished__WEBPACK_IMPORTED_MODULE_1__["rgba"])(overlayBackground,.9):Object(polished__WEBPACK_IMPORTED_MODULE_1__["rgba"])(theme.eui.euiColorEmptyShade,.9),theme.eui.euiZLevel1));Aside.displayName="Aside";const FlexGroup=styled_components__WEBPACK_IMPORTED_MODULE_3___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"]).attrs(()=>({alignItems:"center",direction:"column",gutterSize:"s",justifyContent:"center"})).withConfig({displayName:"FlexGroup",componentId:"sc-10s9ue6-1"})(["",""],({overlay:overlay})=>overlay&&Object(styled_components__WEBPACK_IMPORTED_MODULE_3__["css"])(["height:100%;"]));FlexGroup.displayName="FlexGroup";const Loader=react__WEBPACK_IMPORTED_MODULE_2___default.a.memo(({children:children,overlay:overlay,overlayBackground:overlayBackground,size:size})=>react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(Aside,{overlay:overlay,overlayBackground:overlayBackground},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(FlexGroup,{overlay:{overlay:overlay}},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiLoadingSpinner"],{"data-test-subj":"loading-spinner",size:size})),children&&react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiText"],{color:"subdued",size:"s"},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("p",null,children))))));Loader.displayName="Loader"},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return useUserData}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ManageUserInfo}));__webpack_require__.d(__webpack_exports__,"c",(function(){return useUserInfo}));var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var toasters=__webpack_require__(111);var api=__webpack_require__(281);var translations=__webpack_require__(569);const usePrivilegeUser=()=>{const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[privilegeUser,setPrivilegeUser]=Object(external_kbnSharedDeps_React_["useState"])({isAuthenticated:null,hasEncryptionKey:null,hasIndexManage:null,hasIndexWrite:null,hasIndexUpdateDelete:null,hasIndexMaintenance:null});const[,dispatchToaster]=Object(toasters["h"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{let isSubscribed=true;const abortCtrl=new AbortController;setLoading(true);const fetchData=async()=>{try{const privilege=await Object(api["d"])({signal:abortCtrl.signal});if(isSubscribed&&privilege!=null){if(privilege.index!=null&&Object.keys(privilege.index).length>0){const indexName=Object.keys(privilege.index)[0];setPrivilegeUser({isAuthenticated:privilege.is_authenticated,hasEncryptionKey:privilege.has_encryption_key,hasIndexManage:privilege.index[indexName].manage&&privilege.cluster.manage,hasIndexMaintenance:privilege.index[indexName].maintenance,hasIndexWrite:privilege.index[indexName].create||privilege.index[indexName].create_doc||privilege.index[indexName].index||privilege.index[indexName].write,hasIndexUpdateDelete:privilege.index[indexName].write})}}}catch(error){if(isSubscribed){setPrivilegeUser({isAuthenticated:false,hasEncryptionKey:false,hasIndexManage:false,hasIndexWrite:false,hasIndexUpdateDelete:false,hasIndexMaintenance:false});Object(toasters["g"])({title:translations["a"],error:error,dispatchToaster:dispatchToaster})}}if(isSubscribed){setLoading(false)}};fetchData();return()=>{isSubscribed=false;abortCtrl.abort()}},[dispatchToaster]);return{loading:loading,...privilegeUser}};var use_signal_index=__webpack_require__(283);var kibana=__webpack_require__(104);const initialState={canUserCRUD:null,hasIndexManage:null,hasIndexMaintenance:null,hasIndexWrite:null,hasIndexUpdateDelete:null,isSignalIndexExists:null,isAuthenticated:null,hasEncryptionKey:null,loading:true,signalIndexName:null,signalIndexMappingOutdated:null};const userInfoReducer=(state,action)=>{switch(action.type){case"updateLoading":{return{...state,loading:action.loading}}case"updateHasIndexManage":{return{...state,hasIndexManage:action.hasIndexManage}}case"updateHasIndexMaintenance":{return{...state,hasIndexMaintenance:action.hasIndexMaintenance}}case"updateHasIndexWrite":{return{...state,hasIndexWrite:action.hasIndexWrite}}case"updateHasIndexUpdateDelete":{return{...state,hasIndexUpdateDelete:action.hasIndexUpdateDelete}}case"updateIsSignalIndexExists":{return{...state,isSignalIndexExists:action.isSignalIndexExists}}case"updateIsAuthenticated":{return{...state,isAuthenticated:action.isAuthenticated}}case"updateHasEncryptionKey":{return{...state,hasEncryptionKey:action.hasEncryptionKey}}case"updateCanUserCRUD":{return{...state,canUserCRUD:action.canUserCRUD}}case"updateSignalIndexName":{return{...state,signalIndexName:action.signalIndexName}}case"updateSignalIndexMappingOutdated":{return{...state,signalIndexMappingOutdated:action.signalIndexMappingOutdated}}default:return state}};const StateUserInfoContext=Object(external_kbnSharedDeps_React_["createContext"])([initialState,()=>external_kbnSharedDeps_LodashFp_["noop"]]);const useUserData=()=>Object(external_kbnSharedDeps_React_["useContext"])(StateUserInfoContext);const ManageUserInfo=({children:children})=>external_kbnSharedDeps_React_default.a.createElement(StateUserInfoContext.Provider,{value:Object(external_kbnSharedDeps_React_["useReducer"])(userInfoReducer,initialState)},children);const useUserInfo=()=>{const[{canUserCRUD:canUserCRUD,hasIndexManage:hasIndexManage,hasIndexMaintenance:hasIndexMaintenance,hasIndexWrite:hasIndexWrite,hasIndexUpdateDelete:hasIndexUpdateDelete,isSignalIndexExists:isSignalIndexExists,isAuthenticated:isAuthenticated,hasEncryptionKey:hasEncryptionKey,loading:loading,signalIndexName:signalIndexName,signalIndexMappingOutdated:signalIndexMappingOutdated},dispatch]=useUserData();const{loading:privilegeLoading,isAuthenticated:isApiAuthenticated,hasEncryptionKey:isApiEncryptionKey,hasIndexManage:hasApiIndexManage,hasIndexMaintenance:hasApiIndexMaintenance,hasIndexWrite:hasApiIndexWrite,hasIndexUpdateDelete:hasApiIndexUpdateDelete}=usePrivilegeUser();const{loading:indexNameLoading,signalIndexExists:isApiSignalIndexExists,signalIndexName:apiSignalIndexName,signalIndexMappingOutdated:apiSignalIndexMappingOutdated,createDeSignalIndex:createSignalIndex}=Object(use_signal_index["a"])();const uiCapabilities=Object(kibana["h"])().services.application.capabilities;const capabilitiesCanUserCRUD=typeof uiCapabilities.siem.crud==="boolean"?uiCapabilities.siem.crud:false;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(loading!==(privilegeLoading||indexNameLoading)){dispatch({type:"updateLoading",loading:privilegeLoading||indexNameLoading})}},[dispatch,loading,privilegeLoading,indexNameLoading]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&hasIndexManage!==hasApiIndexManage&&hasApiIndexManage!=null){dispatch({type:"updateHasIndexManage",hasIndexManage:hasApiIndexManage})}},[dispatch,loading,hasIndexManage,hasApiIndexManage]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&hasIndexWrite!==hasApiIndexWrite&&hasApiIndexWrite!=null){dispatch({type:"updateHasIndexWrite",hasIndexWrite:hasApiIndexWrite})}},[dispatch,loading,hasIndexWrite,hasApiIndexWrite]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&hasIndexUpdateDelete!==hasApiIndexUpdateDelete&&hasApiIndexUpdateDelete!=null){dispatch({type:"updateHasIndexUpdateDelete",hasIndexUpdateDelete:hasApiIndexUpdateDelete})}},[dispatch,loading,hasIndexUpdateDelete,hasApiIndexUpdateDelete]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&hasIndexMaintenance!==hasApiIndexMaintenance&&hasApiIndexMaintenance!=null){dispatch({type:"updateHasIndexMaintenance",hasIndexMaintenance:hasApiIndexMaintenance})}},[dispatch,loading,hasIndexMaintenance,hasApiIndexMaintenance]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&isSignalIndexExists!==isApiSignalIndexExists&&isApiSignalIndexExists!=null){dispatch({type:"updateIsSignalIndexExists",isSignalIndexExists:isApiSignalIndexExists})}},[dispatch,loading,isSignalIndexExists,isApiSignalIndexExists]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&isAuthenticated!==isApiAuthenticated&&isApiAuthenticated!=null){dispatch({type:"updateIsAuthenticated",isAuthenticated:isApiAuthenticated})}},[dispatch,loading,isAuthenticated,isApiAuthenticated]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&hasEncryptionKey!==isApiEncryptionKey&&isApiEncryptionKey!=null){dispatch({type:"updateHasEncryptionKey",hasEncryptionKey:isApiEncryptionKey})}},[dispatch,loading,hasEncryptionKey,isApiEncryptionKey]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&canUserCRUD!==capabilitiesCanUserCRUD&&capabilitiesCanUserCRUD!=null){dispatch({type:"updateCanUserCRUD",canUserCRUD:capabilitiesCanUserCRUD})}},[dispatch,loading,canUserCRUD,capabilitiesCanUserCRUD]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&signalIndexName!==apiSignalIndexName&&apiSignalIndexName!=null){dispatch({type:"updateSignalIndexName",signalIndexName:apiSignalIndexName})}},[dispatch,loading,signalIndexName,apiSignalIndexName]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&signalIndexMappingOutdated!==apiSignalIndexMappingOutdated&&apiSignalIndexMappingOutdated!=null){dispatch({type:"updateSignalIndexMappingOutdated",signalIndexMappingOutdated:apiSignalIndexMappingOutdated})}},[dispatch,loading,signalIndexMappingOutdated,apiSignalIndexMappingOutdated]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isAuthenticated&&hasEncryptionKey&&hasIndexManage&&(isSignalIndexExists!=null&&!isSignalIndexExists||signalIndexMappingOutdated!=null&&signalIndexMappingOutdated)&&createSignalIndex!=null){createSignalIndex()}},[createSignalIndex,isAuthenticated,hasEncryptionKey,isSignalIndexExists,hasIndexManage,signalIndexMappingOutdated]);return{loading:loading,isSignalIndexExists:isSignalIndexExists,isAuthenticated:isAuthenticated,hasEncryptionKey:hasEncryptionKey,canUserCRUD:canUserCRUD,hasIndexManage:hasIndexManage,hasIndexMaintenance:hasIndexMaintenance,hasIndexWrite:hasIndexWrite,hasIndexUpdateDelete:hasIndexUpdateDelete,signalIndexName:signalIndexName,signalIndexMappingOutdated:signalIndexMappingOutdated}}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getAllFieldsByName}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useFetchIndex}));__webpack_require__.d(__webpack_exports__,"c",(function(){return useIndexFields}));var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var memoize_one_cjs=__webpack_require__(222);var memoize_one_cjs_default=__webpack_require__.n(memoize_one_cjs);var external_kbnSharedDeps_React_=__webpack_require__(6);var lib=__webpack_require__(105);var external_kbnSharedDeps_Rxjs_=__webpack_require__(15);var kibana=__webpack_require__(104);var index_fields=__webpack_require__(347);var common_=__webpack_require__(79);var use_selector=__webpack_require__(109);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const ERROR_BEAT_FIELDS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.beatFields.errorSearchDescription",{defaultMessage:`An error has occurred on getting beat fields`});const FAIL_BEAT_FIELDS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.beatFields.failSearchDescription",{defaultMessage:`Failed to run search on beat fields`});var sourcerer=__webpack_require__(137);var common=__webpack_require__(357);const getAllBrowserFields=browserFields=>Object.values(browserFields).reduce((acc,namespace)=>[...acc,...Object.values(namespace.fields!=null?namespace.fields:{})],[]);const getAllFieldsByName=browserFields=>Object(external_kbnSharedDeps_LodashFp_["keyBy"])("name",getAllBrowserFields(browserFields));const getIndexFields=memoize_one_cjs_default()((title,fields)=>fields&&fields.length>0?{fields:fields.map(field=>Object(external_kbnSharedDeps_LodashFp_["pick"])(["name","searchable","type","aggregatable","esTypes","subType"],field)),title:title}:{fields:[],title:title},(newArgs,lastArgs)=>newArgs[0]===lastArgs[0]&&newArgs[1].length===lastArgs[1].length);const getBrowserFields=memoize_one_cjs_default()((_title,fields)=>fields.reduce((accumulator,field)=>{if(accumulator[field.category]==null){accumulator[field.category]={}}if(accumulator[field.category].fields==null){accumulator[field.category].fields={}}accumulator[field.category].fields[field.name]=field;return accumulator},{}),(newArgs,lastArgs)=>newArgs[0]===lastArgs[0]);const getDocValueFields=memoize_one_cjs_default()((_title,fields)=>fields&&fields.length>0?fields.reduce((accumulator,field)=>{if(field.readFromDocValues&&accumulator.length<100){return[...accumulator,{field:field.name,format:field.format}]}return accumulator},[]):[],(newArgs,lastArgs)=>newArgs[0]===lastArgs[0]);const indicesExistOrDataTemporarilyUnavailable=indicesExist=>indicesExist||Object(external_kbnSharedDeps_LodashFp_["isUndefined"])(indicesExist);const DEFAULT_BROWSER_FIELDS={};const DEFAULT_INDEX_PATTERNS={fields:[],title:""};const DEFAULT_DOC_VALUE_FIELDS=[];const useFetchIndex=(indexNames,onlyCheckIfIndicesExist=false)=>{const{data:data,notifications:notifications}=Object(kibana["h"])().services;const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);const searchSubscription$=Object(external_kbnSharedDeps_React_["useRef"])(new external_kbnSharedDeps_Rxjs_["Subscription"]);const previousIndexesName=Object(external_kbnSharedDeps_React_["useRef"])([]);const[isLoading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({browserFields:DEFAULT_BROWSER_FIELDS,docValueFields:DEFAULT_DOC_VALUE_FIELDS,indexes:indexNames,indexExists:true,indexPatterns:DEFAULT_INDEX_PATTERNS});const indexFieldsSearch=Object(external_kbnSharedDeps_React_["useCallback"])(iNames=>{const asyncSearch=async()=>{abortCtrl.current=new AbortController;setLoading(true);searchSubscription$.current=data.search.search({indices:iNames,onlyCheckIfIndicesExist:onlyCheckIfIndicesExist},{abortSignal:abortCtrl.current.signal,strategy:"securitySolutionIndexFields"}).subscribe({next:response=>{if(Object(common_["isCompleteResponse"])(response)){const stringifyIndices=response.indicesExist.sort().join();previousIndexesName.current=response.indicesExist;setLoading(false);setState({browserFields:getBrowserFields(stringifyIndices,response.indexFields),docValueFields:getDocValueFields(stringifyIndices,response.indexFields),indexes:response.indicesExist,indexExists:response.indicesExist.length>0,indexPatterns:getIndexFields(stringifyIndices,response.indexFields)});searchSubscription$.current.unsubscribe()}else if(Object(common_["isErrorResponse"])(response)){setLoading(false);notifications.toasts.addWarning(ERROR_BEAT_FIELDS);searchSubscription$.current.unsubscribe()}},error:msg=>{setLoading(false);notifications.toasts.addDanger({text:msg.message,title:FAIL_BEAT_FIELDS});searchSubscription$.current.unsubscribe()}})};searchSubscription$.current.unsubscribe();abortCtrl.current.abort();asyncSearch()},[data.search,notifications.toasts,onlyCheckIfIndicesExist]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!Object(external_kbnSharedDeps_LodashFp_["isEmpty"])(indexNames)&&!Object(external_kbnSharedDeps_LodashFp_["isEqual"])(previousIndexesName.current,indexNames)){indexFieldsSearch(indexNames)}return()=>{searchSubscription$.current.unsubscribe();abortCtrl.current.abort()}},[indexNames,indexFieldsSearch,previousIndexesName]);return[isLoading,state]};const useIndexFields=sourcererScopeName=>{const{data:data,notifications:notifications}=Object(kibana["h"])().services;const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);const searchSubscription$=Object(external_kbnSharedDeps_React_["useRef"])(new external_kbnSharedDeps_Rxjs_["Subscription"]);const dispatch=Object(lib["useDispatch"])();const indexNamesSelectedSelector=Object(external_kbnSharedDeps_React_["useMemo"])(()=>sourcerer["d"].getIndexNamesSelectedSelector(),[]);const{indexNames:indexNames,previousIndexNames:previousIndexNames}=Object(use_selector["a"])(state=>indexNamesSelectedSelector(state,sourcererScopeName));const setLoading=Object(external_kbnSharedDeps_React_["useCallback"])(loading=>{dispatch(sourcerer["a"].setSourcererScopeLoading({id:sourcererScopeName,loading:loading}))},[dispatch,sourcererScopeName]);const indexFieldsSearch=Object(external_kbnSharedDeps_React_["useCallback"])(indicesName=>{const asyncSearch=async()=>{abortCtrl.current=new AbortController;setLoading(true);searchSubscription$.current=data.search.search({indices:indicesName,onlyCheckIfIndicesExist:false},{abortSignal:abortCtrl.current.signal,strategy:"securitySolutionIndexFields"}).subscribe({next:response=>{if(Object(common_["isCompleteResponse"])(response)){const stringifyIndices=response.indicesExist.sort().join();dispatch(sourcerer["a"].setSource({id:sourcererScopeName,payload:{browserFields:getBrowserFields(stringifyIndices,response.indexFields),docValueFields:getDocValueFields(stringifyIndices,response.indexFields),errorMessage:null,id:sourcererScopeName,indexPattern:getIndexFields(stringifyIndices,response.indexFields),indicesExist:response.indicesExist.length>0,loading:false}}));searchSubscription$.current.unsubscribe()}else if(Object(common_["isErrorResponse"])(response)){setLoading(false);notifications.toasts.addWarning(ERROR_BEAT_FIELDS);searchSubscription$.current.unsubscribe()}},error:msg=>{setLoading(false);notifications.toasts.addDanger({text:msg.message,title:FAIL_BEAT_FIELDS});searchSubscription$.current.unsubscribe()}})};searchSubscription$.current.unsubscribe();abortCtrl.current.abort();asyncSearch()},[data.search,dispatch,notifications.toasts,setLoading,sourcererScopeName]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!Object(external_kbnSharedDeps_LodashFp_["isEmpty"])(indexNames)&&previousIndexNames!==indexNames.sort().join()){indexFieldsSearch(indexNames)}return()=>{searchSubscription$.current.unsubscribe();abortCtrl.current.abort()}},[indexNames,indexFieldsSearch,previousIndexNames])}},,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.wordWrap=exports.triangle=exports.transparentize=exports.transitions=exports.toColorString=exports.tint=exports.timingFunctions=exports.textInputs=exports.stripUnit=exports.size=exports.shade=exports.setSaturation=exports.setLightness=exports.setHue=exports.selection=exports.saturate=exports.rgba=exports.rgb=exports.retinaImage=exports.rem=exports.readableColor=exports.radialGradient=exports.position=exports.placeholder=exports.parseToRgb=exports.parseToHsl=exports.padding=exports.opacify=exports.normalize=exports.modularScale=exports.mix=exports.margin=exports.lighten=exports.hsla=exports.hsl=exports.hiDPI=exports.hideVisually=exports.hideText=exports.invert=exports.grayscale=exports.getLuminance=exports.fontFace=exports.em=exports.ellipsis=exports.directionalProperty=exports.desaturate=exports.darken=exports.complement=exports.clearFix=exports.buttons=exports.borderWidth=exports.borderStyle=exports.borderRadius=exports.borderColor=exports.backgrounds=exports.backgroundImages=exports.animation=exports.adjustHue=undefined;var _directionalProperty=__webpack_require__(239);var _directionalProperty2=_interopRequireDefault(_directionalProperty);var _em=__webpack_require__(902);var _em2=_interopRequireDefault(_em);var _modularScale=__webpack_require__(904);var _modularScale2=_interopRequireDefault(_modularScale);var _rem=__webpack_require__(905);var _rem2=_interopRequireDefault(_rem);var _stripUnit=__webpack_require__(446);var _stripUnit2=_interopRequireDefault(_stripUnit);var _clearFix=__webpack_require__(906);var _clearFix2=_interopRequireDefault(_clearFix);var _ellipsis=__webpack_require__(907);var _ellipsis2=_interopRequireDefault(_ellipsis);var _fontFace=__webpack_require__(908);var _fontFace2=_interopRequireDefault(_fontFace);var _hideText=__webpack_require__(909);var _hideText2=_interopRequireDefault(_hideText);var _hideVisually=__webpack_require__(910);var _hideVisually2=_interopRequireDefault(_hideVisually);var _hiDPI=__webpack_require__(593);var _hiDPI2=_interopRequireDefault(_hiDPI);var _normalize=__webpack_require__(911);var _normalize2=_interopRequireDefault(_normalize);var _placeholder=__webpack_require__(912);var _placeholder2=_interopRequireDefault(_placeholder);var _radialGradient=__webpack_require__(913);var _radialGradient2=_interopRequireDefault(_radialGradient);var _retinaImage=__webpack_require__(914);var _retinaImage2=_interopRequireDefault(_retinaImage);var _selection=__webpack_require__(915);var _selection2=_interopRequireDefault(_selection);var _timingFunctions=__webpack_require__(916);var _timingFunctions2=_interopRequireDefault(_timingFunctions);var _triangle=__webpack_require__(917);var _triangle2=_interopRequireDefault(_triangle);var _wordWrap=__webpack_require__(918);var _wordWrap2=_interopRequireDefault(_wordWrap);var _adjustHue=__webpack_require__(919);var _adjustHue2=_interopRequireDefault(_adjustHue);var _complement=__webpack_require__(922);var _complement2=_interopRequireDefault(_complement);var _darken=__webpack_require__(923);var _darken2=_interopRequireDefault(_darken);var _desaturate=__webpack_require__(924);var _desaturate2=_interopRequireDefault(_desaturate);var _getLuminance=__webpack_require__(599);var _getLuminance2=_interopRequireDefault(_getLuminance);var _grayscale=__webpack_require__(925);var _grayscale2=_interopRequireDefault(_grayscale);var _hsl=__webpack_require__(596);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(598);var _hsla2=_interopRequireDefault(_hsla);var _invert=__webpack_require__(926);var _invert2=_interopRequireDefault(_invert);var _lighten=__webpack_require__(927);var _lighten2=_interopRequireDefault(_lighten);var _mix=__webpack_require__(449);var _mix2=_interopRequireDefault(_mix);var _opacify=__webpack_require__(928);var _opacify2=_interopRequireDefault(_opacify);var _parseToHsl=__webpack_require__(181);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _parseToRgb=__webpack_require__(227);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _readableColor=__webpack_require__(929);var _readableColor2=_interopRequireDefault(_readableColor);var _rgb=__webpack_require__(448);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(288);var _rgba2=_interopRequireDefault(_rgba);var _saturate=__webpack_require__(930);var _saturate2=_interopRequireDefault(_saturate);var _setHue=__webpack_require__(931);var _setHue2=_interopRequireDefault(_setHue);var _setLightness=__webpack_require__(932);var _setLightness2=_interopRequireDefault(_setLightness);var _setSaturation=__webpack_require__(933);var _setSaturation2=_interopRequireDefault(_setSaturation);var _shade=__webpack_require__(934);var _shade2=_interopRequireDefault(_shade);var _tint=__webpack_require__(935);var _tint2=_interopRequireDefault(_tint);var _toColorString=__webpack_require__(168);var _toColorString2=_interopRequireDefault(_toColorString);var _transparentize=__webpack_require__(936);var _transparentize2=_interopRequireDefault(_transparentize);var _animation=__webpack_require__(937);var _animation2=_interopRequireDefault(_animation);var _backgroundImages=__webpack_require__(938);var _backgroundImages2=_interopRequireDefault(_backgroundImages);var _backgrounds=__webpack_require__(939);var _backgrounds2=_interopRequireDefault(_backgrounds);var _borderColor=__webpack_require__(940);var _borderColor2=_interopRequireDefault(_borderColor);var _borderRadius=__webpack_require__(941);var _borderRadius2=_interopRequireDefault(_borderRadius);var _borderStyle=__webpack_require__(942);var _borderStyle2=_interopRequireDefault(_borderStyle);var _borderWidth=__webpack_require__(943);var _borderWidth2=_interopRequireDefault(_borderWidth);var _buttons=__webpack_require__(944);var _buttons2=_interopRequireDefault(_buttons);var _margin=__webpack_require__(945);var _margin2=_interopRequireDefault(_margin);var _padding=__webpack_require__(946);var _padding2=_interopRequireDefault(_padding);var _position=__webpack_require__(947);var _position2=_interopRequireDefault(_position);var _size=__webpack_require__(948);var _size2=_interopRequireDefault(_size);var _textInputs=__webpack_require__(949);var _textInputs2=_interopRequireDefault(_textInputs);var _transitions=__webpack_require__(950);var _transitions2=_interopRequireDefault(_transitions);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}exports.adjustHue=_adjustHue2.default;exports.animation=_animation2.default;exports.backgroundImages=_backgroundImages2.default;exports.backgrounds=_backgrounds2.default;exports.borderColor=_borderColor2.default;exports.borderRadius=_borderRadius2.default;exports.borderStyle=_borderStyle2.default;exports.borderWidth=_borderWidth2.default;exports.buttons=_buttons2.default;exports.clearFix=_clearFix2.default;exports.complement=_complement2.default;exports.darken=_darken2.default;exports.desaturate=_desaturate2.default;exports.directionalProperty=_directionalProperty2.default;exports.ellipsis=_ellipsis2.default;exports.em=_em2.default;exports.fontFace=_fontFace2.default;exports.getLuminance=_getLuminance2.default;exports.grayscale=_grayscale2.default;exports.invert=_invert2.default;exports.hideText=_hideText2.default;exports.hideVisually=_hideVisually2.default;exports.hiDPI=_hiDPI2.default;exports.hsl=_hsl2.default;exports.hsla=_hsla2.default;exports.lighten=_lighten2.default;exports.margin=_margin2.default;exports.mix=_mix2.default;exports.modularScale=_modularScale2.default;exports.normalize=_normalize2.default;exports.opacify=_opacify2.default;exports.padding=_padding2.default;exports.parseToHsl=_parseToHsl2.default;exports.parseToRgb=_parseToRgb2.default;exports.placeholder=_placeholder2.default;exports.position=_position2.default;exports.radialGradient=_radialGradient2.default;exports.readableColor=_readableColor2.default;exports.rem=_rem2.default;exports.retinaImage=_retinaImage2.default;exports.rgb=_rgb2.default;exports.rgba=_rgba2.default;exports.saturate=_saturate2.default;exports.selection=_selection2.default;exports.setHue=_setHue2.default;exports.setLightness=_setLightness2.default;exports.setSaturation=_setSaturation2.default;exports.shade=_shade2.default;exports.size=_size2.default;exports.stripUnit=_stripUnit2.default;exports.textInputs=_textInputs2.default;exports.timingFunctions=_timingFunctions2.default;exports.tint=_tint2.default;exports.toColorString=_toColorString2.default;exports.transitions=_transitions2.default;exports.transparentize=_transparentize2.default;exports.triangle=_triangle2.default;exports.wordWrap=_wordWrap2.default},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(227);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _rgbToHsl=__webpack_require__(921);var _rgbToHsl2=_interopRequireDefault(_rgbToHsl);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function parseToHsl(color){return(0,_rgbToHsl2.default)((0,_parseToRgb2.default)(color))}exports.default=parseToHsl;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getRowItemDraggable}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getRowItemDraggables}));__webpack_require__.d(__webpack_exports__,"a",(function(){return OverflowField}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(74);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);var styled_components__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_3__);var _drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(144);var _drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(116);var _empty_value__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(114);var _page__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(153);var _timelines_components_timeline_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(126);var _timelines_components_timeline_data_providers_provider__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(164);const Subtext=styled_components__WEBPACK_IMPORTED_MODULE_3___default.a.div.withConfig({displayName:"Subtext",componentId:"sc-1au6na0-0"})(["font-size:",";"],props=>props.theme.eui.euiFontSizeXS);const getRowItemDraggable=({rowItem:rowItem,attrName:attrName,idPrefix:idPrefix,render:render,dragDisplayValue:dragDisplayValue})=>{if(rowItem!=null){const id=Object(_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_5__["l"])(`${idPrefix}-${attrName}-${rowItem}`);return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_4__["b"],{key:id,dataProvider:{and:[],enabled:true,id:id,name:rowItem,excluded:false,kqlQuery:"",queryMatch:{field:attrName,value:rowItem,displayValue:dragDisplayValue||rowItem,operator:_timelines_components_timeline_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_8__["c"]}},render:(dataProvider,_,snapshot)=>snapshot.isDragging?react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_4__["a"],null,react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_timelines_components_timeline_data_providers_provider__WEBPACK_IMPORTED_MODULE_9__["a"],{dataProvider:dataProvider})):react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,null,render?render(rowItem):Object(_empty_value__WEBPACK_IMPORTED_MODULE_6__["a"])(rowItem))})}else{return Object(_empty_value__WEBPACK_IMPORTED_MODULE_6__["d"])()}};const getRowItemDraggables=({rowItems:rowItems,attrName:attrName,idPrefix:idPrefix,render:render,dragDisplayValue:dragDisplayValue,displayCount:displayCount=5,maxOverflow:maxOverflow=5})=>{if(rowItems!=null&&rowItems.length>0){const draggables=rowItems.slice(0,displayCount).map((rowItem,index)=>{const id=Object(_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_5__["l"])(`${idPrefix}-${attrName}-${rowItem}-${index}`);return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,{key:id},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_4__["b"],{key:id,dataProvider:{and:[],enabled:true,id:id,name:rowItem,excluded:false,kqlQuery:"",queryMatch:{field:attrName,value:rowItem,displayValue:dragDisplayValue||rowItem,operator:_timelines_components_timeline_data_providers_data_provider__WEBPACK_IMPORTED_MODULE_8__["c"]}},render:(dataProvider,_,snapshot)=>snapshot.isDragging?react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_drag_and_drop_draggable_wrapper__WEBPACK_IMPORTED_MODULE_4__["a"],null,react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_timelines_components_timeline_data_providers_provider__WEBPACK_IMPORTED_MODULE_9__["a"],{dataProvider:dataProvider})):react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,null,render?render(rowItem):Object(_empty_value__WEBPACK_IMPORTED_MODULE_6__["a"])(rowItem))}))});return draggables.length>0?react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,null,draggables," ",getRowItemOverflow(rowItems,idPrefix,displayCount,maxOverflow)):Object(_empty_value__WEBPACK_IMPORTED_MODULE_6__["d"])()}else{return Object(_empty_value__WEBPACK_IMPORTED_MODULE_6__["d"])()}};const getRowItemOverflow=(rowItems,idPrefix,overflowIndexStart=5,maxOverflowItems=5)=>react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,null,rowItems.length>overflowIndexStart&&react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(Popover,{count:rowItems.length-overflowIndexStart,idPrefix:idPrefix},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiText"],{size:"xs"},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("ul",null,rowItems.slice(overflowIndexStart,overflowIndexStart+maxOverflowItems).map(rowItem=>react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("li",{key:`${idPrefix}-${rowItem}`},Object(_empty_value__WEBPACK_IMPORTED_MODULE_6__["a"])(rowItem)))),rowItems.length>overflowIndexStart+maxOverflowItems&&react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("p",{"data-test-subj":"popover-additional-overflow"},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiTextColor"],{color:"subdued"},rowItems.length-overflowIndexStart-maxOverflowItems," ",react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__["FormattedMessage"],{id:"xpack.securitySolution.tables.rowItemHelper.moreDescription",defaultMessage:"more not shown"}))))));const PopoverComponent=({children:children,count:count,idPrefix:idPrefix})=>{const[isOpen,setIsOpen]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(false);return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(Subtext,null,react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiPopover"],{button:react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiLink"],{onClick:()=>setIsOpen(!isOpen)},`+${count} More`),closePopover:()=>setIsOpen(!isOpen),id:`${idPrefix}-popover`,isOpen:isOpen,repositionOnScroll:true},children))};PopoverComponent.displayName="PopoverComponent";const Popover=react__WEBPACK_IMPORTED_MODULE_2___default.a.memo(PopoverComponent);Popover.displayName="Popover";const OverflowFieldComponent=({value:value,showToolTip:showToolTip=true,overflowLength:overflowLength=50})=>react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement("span",null,showToolTip?react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiToolTip"],{"data-test-subj":"message-tooltip",content:"message"},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,null,value.substring(0,overflowLength))):react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_2___default.a.Fragment,null,value.substring(0,overflowLength)),value.length>overflowLength&&react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiToolTip"],{content:value},react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_page__WEBPACK_IMPORTED_MODULE_7__["e"],{type:"boxesHorizontal"})));OverflowFieldComponent.displayName="OverflowFieldComponent";const OverflowField=react__WEBPACK_IMPORTED_MODULE_2___default.a.memo(OverflowFieldComponent);OverflowField.displayName="OverflowField"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"W",(function(){return WITH_RESULT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ACCEPTED_A_CONNECTION_VIA}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ATTEMPTED_LOGIN}));__webpack_require__.d(__webpack_exports__,"g",(function(){return DISCONNECTED_VIA}));__webpack_require__.d(__webpack_exports__,"r",(function(){return LOGGED_OUT}));__webpack_require__.d(__webpack_exports__,"A",(function(){return PROCESS_STARTED}));__webpack_require__.d(__webpack_exports__,"B",(function(){return PROCESS_STOPPED}));__webpack_require__.d(__webpack_exports__,"H",(function(){return TERMINATED_PROCESS}));__webpack_require__.d(__webpack_exports__,"e",(function(){return CREATED_FILE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return DELETED_FILE}));__webpack_require__.d(__webpack_exports__,"i",(function(){return EXECUTED_PROCESS}));__webpack_require__.d(__webpack_exports__,"n",(function(){return FORKED_PROCESS}));__webpack_require__.d(__webpack_exports__,"q",(function(){return LOADED_LIBRARY}));__webpack_require__.d(__webpack_exports__,"s",(function(){return MADE_A_HTTP_REQUEST_VIA}));__webpack_require__.d(__webpack_exports__,"t",(function(){return MODIFIED_FILE}));__webpack_require__.d(__webpack_exports__,"u",(function(){return MODIFIED_REGISTRY_KEY}));__webpack_require__.d(__webpack_exports__,"v",(function(){return OVERWROTE_FILE}));__webpack_require__.d(__webpack_exports__,"E",(function(){return RENAMED_FILE}));__webpack_require__.d(__webpack_exports__,"k",(function(){return EXISTING_PROCESS}));__webpack_require__.d(__webpack_exports__,"G",(function(){return SOCKET_OPENED}));__webpack_require__.d(__webpack_exports__,"F",(function(){return SOCKET_CLOSED}));__webpack_require__.d(__webpack_exports__,"m",(function(){return EXISTING_USER}));__webpack_require__.d(__webpack_exports__,"l",(function(){return EXISTING_SOCKET}));__webpack_require__.d(__webpack_exports__,"j",(function(){return EXISTING_PACKAGE}));__webpack_require__.d(__webpack_exports__,"p",(function(){return INVALID}));__webpack_require__.d(__webpack_exports__,"J",(function(){return USER_CHANGED}));__webpack_require__.d(__webpack_exports__,"o",(function(){return HOST_CHANGED}));__webpack_require__.d(__webpack_exports__,"I",(function(){return USER_ADDED}));__webpack_require__.d(__webpack_exports__,"z",(function(){return PROCESS_ERROR}));__webpack_require__.d(__webpack_exports__,"h",(function(){return ERROR}));__webpack_require__.d(__webpack_exports__,"w",(function(){return PACKAGE_INSTALLED}));__webpack_require__.d(__webpack_exports__,"d",(function(){return BOOT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ACCEPTED}));__webpack_require__.d(__webpack_exports__,"y",(function(){return PACKAGE_UPDATED}));__webpack_require__.d(__webpack_exports__,"x",(function(){return PACKAGE_REMOVED}));__webpack_require__.d(__webpack_exports__,"K",(function(){return USER_REMOVED}));__webpack_require__.d(__webpack_exports__,"L",(function(){return VIA}));__webpack_require__.d(__webpack_exports__,"M",(function(){return VIA_PARENT_PROCESS}));__webpack_require__.d(__webpack_exports__,"D",(function(){return RANSOMWARE_WAS_PREVENTED_FROM_ENCRYPTING_FILES}));__webpack_require__.d(__webpack_exports__,"C",(function(){return RANSOMWARE_WAS_DETECTED_ENCRYPTING_FILES}));__webpack_require__.d(__webpack_exports__,"N",(function(){return WAS_DETECTED_CREATING_A_MALICIOUS_FILE}));__webpack_require__.d(__webpack_exports__,"R",(function(){return WAS_PREVENTED_FROM_CREATING_A_MALICIOUS_FILE}));__webpack_require__.d(__webpack_exports__,"P",(function(){return WAS_DETECTED_MODIFYING_A_MALICIOUS_FILE}));__webpack_require__.d(__webpack_exports__,"T",(function(){return WAS_PREVENTED_FROM_MODIFYING_A_MALICIOUS_FILE}));__webpack_require__.d(__webpack_exports__,"Q",(function(){return WAS_DETECTED_RENAMING_A_MALICIOUS_FILE}));__webpack_require__.d(__webpack_exports__,"U",(function(){return WAS_PREVENTED_FROM_RENAMING_A_MALICIOUS_FILE}));__webpack_require__.d(__webpack_exports__,"O",(function(){return WAS_DETECTED_EXECUTING_A_MALICIOUS_PROCESS}));__webpack_require__.d(__webpack_exports__,"S",(function(){return WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS}));__webpack_require__.d(__webpack_exports__,"V",(function(){return WITH_EXIT_CODE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const SESSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.systemDescription",{defaultMessage:"System"});const WITH_RESULT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.withResultDescription",{defaultMessage:"with result"});const WAS_AUTHORIZED_TO_USE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.wasAuthorizedToUseDescription",{defaultMessage:"was authorized to use"});const ACCEPTED_A_CONNECTION_VIA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.acceptedAConnectionViaDescription",{defaultMessage:"accepted a connection via"});const ATTEMPTED_LOGIN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.attemptedLoginDescription",{defaultMessage:"attempted a login via"});const DISCONNECTED_VIA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.disconnectedViaDescription",{defaultMessage:"disconnected via"});const LOGGED_OUT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.loggedOutDescription",{defaultMessage:"logged out via"});const USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.usingDescription",{defaultMessage:"using"});const PROCESS_STARTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.processStartedDescription",{defaultMessage:"started process"});const PROCESS_STOPPED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.processStoppedDescription",{defaultMessage:"stopped process"});const TERMINATED_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.terminatedProcessDescription",{defaultMessage:"terminated process"});const CREATED_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.createdFileDescription",{defaultMessage:"created a file"});const DELETED_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.deletedFileDescription",{defaultMessage:"deleted a file"});const EXECUTED_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.executedProcessDescription",{defaultMessage:"executed process"});const FORKED_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.forkedProcessDescription",{defaultMessage:"forked process"});const LOADED_LIBRARY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.loadedLibraryDescription",{defaultMessage:"loaded library"});const MADE_A_HTTP_REQUEST_VIA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.madeAHttpRequestViaDescription",{defaultMessage:"made a http request via"});const MODIFIED_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.modifiedFileDescription",{defaultMessage:"modified a file"});const MODIFIED_REGISTRY_KEY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.modifiedRegistryKeyDescription",{defaultMessage:"modified registry key"});const OVERWROTE_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.overwroteFileDescription",{defaultMessage:"overwrote a file"});const RENAMED_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.renamedFileDescription",{defaultMessage:"renamed a file"});const EXISTING_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.existingProcessDescription",{defaultMessage:"is running process"});const SOCKET_OPENED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.socketOpenedDescription",{defaultMessage:"opened a socket with"});const SOCKET_CLOSED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.socketClosedDescription",{defaultMessage:"closed a socket with"});const EXISTING_USER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.existingUserDescription",{defaultMessage:"is an existing user"});const EXISTING_SOCKET=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.existingSocketDescription",{defaultMessage:"is using an existing socket from"});const EXISTING_PACKAGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.existingPackageDescription",{defaultMessage:"is using an existing package"});const INVALID=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.invalidDescription",{defaultMessage:"attempted invalid usage of"});const USER_CHANGED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.userChangedDescription",{defaultMessage:"user has changed"});const HOST_CHANGED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.hostDescription",{defaultMessage:"host information"});const USER_ADDED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.userAddedDescription",{defaultMessage:"user was added"});const PROCESS_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.processErrorDescription",{defaultMessage:"encountered a process error with"});const ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.errorDescription",{defaultMessage:"encountered an error with"});const PACKAGE_INSTALLED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.packageInstalledDescription",{defaultMessage:"installed package"});const BOOT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.packageSystemStartedDescription",{defaultMessage:"system started"});const ACCEPTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.acceptedDescription",{defaultMessage:"accepted the user via"});const PACKAGE_UPDATED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.packageUpdatedDescription",{defaultMessage:"updated package"});const PACKAGE_REMOVED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.packageRemovedDescription",{defaultMessage:"removed package"});const USER_REMOVED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.userRemovedDescription",{defaultMessage:"was removed"});const VIA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.viaDescription",{defaultMessage:"via"});const VIA_PARENT_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.viaParentProcessDescription",{defaultMessage:"via parent process"});const RANSOMWARE_WAS_PREVENTED_FROM_ENCRYPTING_FILES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.ransomwareWasPreventedFromeEcryptingFilesDescription",{defaultMessage:"ransomware was prevented from encrypting files"});const RANSOMWARE_WAS_DETECTED_ENCRYPTING_FILES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.ransomwareWasDetectedEcryptingFilesDescription",{defaultMessage:"ransomware was detected encrypting files"});const WAS_DETECTED_CREATING_A_MALICIOUS_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasDetectedCreatingAMaliciousFileDescription",{defaultMessage:"was detected creating a malicious file"});const WAS_PREVENTED_FROM_CREATING_A_MALICIOUS_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasPreventedFromCreatingAMaliciousFileDescription",{defaultMessage:"was prevented from creating a malicious file"});const WAS_DETECTED_MODIFYING_A_MALICIOUS_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasDetectedModifyingAMaliciousFileDescription",{defaultMessage:"was detected modifying a malicious file"});const WAS_PREVENTED_FROM_MODIFYING_A_MALICIOUS_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasPreventedFromModifyingAMaliciousFileDescription",{defaultMessage:"was prevented from modifying a malicious file"});const WAS_DETECTED_RENAMING_A_MALICIOUS_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasDetectedRenamingAMaliciousFileDescription",{defaultMessage:"was detected renaming a malicious file"});const WAS_PREVENTED_FROM_RENAMING_A_MALICIOUS_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasPreventedFromRenamingAMaliciousFileDescription",{defaultMessage:"was prevented from renaming a malicious file"});const WAS_DETECTED_EXECUTING_A_MALICIOUS_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasDetectedExecutingAMaliciousProcessDescription",{defaultMessage:"was detected executing a malicious process"});const WAS_PREVENTED_FROM_EXECUTING_A_MALICIOUS_PROCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.rowRenderer.wasPreventedFromExecutingAMaliciousProcessDescription",{defaultMessage:"was prevented from executing a malicious process"});const WITH_EXIT_CODE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.system.withExitCodeDescription",{defaultMessage:"with exit code"})},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return createGenericSystemRowRenderer}));__webpack_require__.d(__webpack_exports__,"b",(function(){return createEndgameProcessRowRenderer}));__webpack_require__.d(__webpack_exports__,"f",(function(){return createFimRowRenderer}));__webpack_require__.d(__webpack_exports__,"c",(function(){return createEndpointAlertsRowRenderer}));__webpack_require__.d(__webpack_exports__,"d",(function(){return createEndpointLibraryRowRenderer}));__webpack_require__.d(__webpack_exports__,"g",(function(){return createGenericFileRowRenderer}));__webpack_require__.d(__webpack_exports__,"j",(function(){return createSocketRowRenderer}));__webpack_require__.d(__webpack_exports__,"i",(function(){return createSecurityEventRowRenderer}));__webpack_require__.d(__webpack_exports__,"a",(function(){return createDnsRowRenderer}));__webpack_require__.d(__webpack_exports__,"e",(function(){return createEndpointRegistryRowRenderer}));__webpack_require__.d(__webpack_exports__,"k",(function(){return systemRowRenderers}));var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var timeline=__webpack_require__(106);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var helpers=__webpack_require__(125);var netflow=__webpack_require__(229);var draggables=__webpack_require__(115);var process_draggable=__webpack_require__(245);var host_working_dir=__webpack_require__(662);const UserHostWorkingDir=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,eventId:eventId,hostName:hostName,hostNameSeparator:hostNameSeparator="@",userDomain:userDomain,userDomainField:userDomainField="user.domain",userName:userName,userNameField:userNameField="user.name",workingDirectory:workingDirectory})=>userName!=null||userDomain!=null||hostName!=null||workingDirectory!=null?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:userNameField,value:userName,iconType:"user"})),userDomain!=null&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{"data-test-subj":"user-host-working-dir-domain-separator-text",grow:false,component:"span"},"\\"),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:userDomainField,value:userDomain}))),hostName!=null&&userName!=null&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},hostNameSeparator),external_kbnSharedDeps_React_default.a.createElement(host_working_dir["a"],{contextId:contextId,eventId:eventId,hostName:hostName,workingDirectory:workingDirectory})):null);UserHostWorkingDir.displayName="UserHostWorkingDir";var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const ASKED_FOR=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.dns.askedForDescription",{defaultMessage:"asked for"});const RESPONSE_CODE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.dns.responseCodeDescription",{defaultMessage:"response code:"});const VIA=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.dns.viaDescription",{defaultMessage:"via"});const WHICH_RESOLVED_TO=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.dns.whichResolvedToDescription",{defaultMessage:", which resolved to"});const WITH_QUESTION_TYPE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.dns.withQuestionTypeDescription",{defaultMessage:"with question type"});const DnsRequestEventDetailsLine=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,dnsQuestionName:dnsQuestionName,dnsQuestionType:dnsQuestionType,dnsResolvedIp:dnsResolvedIp,dnsResponseCode:dnsResponseCode,eventCode:eventCode,hostName:hostName,id:id,processExecutable:processExecutable,processName:processName,processPid:processPid,userDomain:userDomain,userName:userName,winlogEventId:winlogEventId})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"center",gutterSize:"none",wrap:true},external_kbnSharedDeps_React_default.a.createElement(UserHostWorkingDir,{contextId:contextId,eventId:id,hostName:hostName,userDomain:userDomain,userName:userName,workingDirectory:undefined}),!Object(helpers["d"])(dnsQuestionName)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"asked-for",grow:false},ASKED_FOR),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"dns.question.name",value:dnsQuestionName}))),!Object(helpers["d"])(dnsQuestionType)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"with-question-type",grow:false},WITH_QUESTION_TYPE),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"dns.question.type",value:dnsQuestionType}))),!Object(helpers["d"])(dnsResolvedIp)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"which-resolved-to",grow:false},WHICH_RESOLVED_TO),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"dns.resolved_ip",value:dnsResolvedIp}))),!Object(helpers["d"])(dnsResponseCode)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},"("),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"response-code",grow:false},RESPONSE_CODE),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"dns.response_code",value:dnsResponseCode})),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},")")),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},VIA),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(process_draggable["b"],{contextId:contextId,endgamePid:undefined,endgameProcessName:undefined,eventId:id,processPid:processPid,processName:processName,processExecutable:processExecutable})),(!Object(helpers["d"])(eventCode)||!Object(helpers["d"])(winlogEventId))&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!Object(helpers["d"])(eventCode)?external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"event.code",value:eventCode})):external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,iconType:"logoWindows",field:"winlog.event_id",value:winlogEventId}))))));DnsRequestEventDetailsLine.displayName="DnsRequestEventDetailsLine";const DnsRequestEventDetails=external_kbnSharedDeps_React_default.a.memo(({data:data,contextId:contextId,timelineId:timelineId})=>{const dnsQuestionName=Object(external_kbnSharedDeps_LodashFp_["get"])("dns.question.name[0]",data);const dnsQuestionType=Object(external_kbnSharedDeps_LodashFp_["get"])("dns.question.type[0]",data);const dnsResolvedIp=Object(external_kbnSharedDeps_LodashFp_["get"])("dns.resolved_ip[0]",data);const dnsResponseCode=Object(external_kbnSharedDeps_LodashFp_["get"])("dns.response_code[0]",data);const eventCode=Object(external_kbnSharedDeps_LodashFp_["get"])("event.code[0]",data);const hostName=Object(external_kbnSharedDeps_LodashFp_["get"])("host.name[0]",data);const id=data._id;const processExecutable=Object(external_kbnSharedDeps_LodashFp_["get"])("process.executable[0]",data);const processName=Object(external_kbnSharedDeps_LodashFp_["get"])("process.name[0]",data);const processPid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.pid[0]",data);const userDomain=Object(external_kbnSharedDeps_LodashFp_["get"])("user.domain[0]",data);const userName=Object(external_kbnSharedDeps_LodashFp_["get"])("user.name[0]",data);const winlogEventId=Object(external_kbnSharedDeps_LodashFp_["get"])("winlog.event_id[0]",data);return external_kbnSharedDeps_React_default.a.createElement(helpers["a"],null,external_kbnSharedDeps_React_default.a.createElement(DnsRequestEventDetailsLine,{contextId:contextId,dnsQuestionName:dnsQuestionName,dnsQuestionType:dnsQuestionType,dnsResolvedIp:dnsResolvedIp,dnsResponseCode:dnsResponseCode,eventCode:eventCode,hostName:hostName,id:id,processExecutable:processExecutable,processName:processName,processPid:processPid,userDomain:userDomain,userName:userName,winlogEventId:winlogEventId}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(netflow["a"],{data:data,timelineId:timelineId}))});DnsRequestEventDetails.displayName="DnsRequestEventDetails";const A_LOGIN_WAS_ATTEMPTED_USING_EXPLICIT_CREDENTIALS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.aLoginWasAttemptedUsingExplicitCredentialsDescription",{defaultMessage:"A login was attempted using explicit credentials"});const AS_REQUESTED_BY_SUBJECT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.asRequestedBySubjectDescription",{defaultMessage:"as requested by subject"});const FAILED_TO_LOG_IN=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endpoint.failedToLogInDescription",{defaultMessage:"failed to log in"});const FAILED_TO_LOG_OFF=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endpoint.failedToLogOffDescription",{defaultMessage:"failed to log off"});const LOGGED_OFF=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.loggedOffDescription",{defaultMessage:"logged off"});const LOGON_TYPE_BATCH=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeBatchDescription",{defaultMessage:"Batch"});const LOGON_TYPE_CACHED_INTERACTIVE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeCachedInteractiveDescription",{defaultMessage:"Cached Interactive"});const LOGON_TYPE_INTERACTIVE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeInteractiveDescription",{defaultMessage:"Interactive"});const LOGON_TYPE_NETWORK=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeNetworkDescription",{defaultMessage:"Network"});const LOGON_TYPE_NETWORK_CLEARTEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeNetworkCleartextDescription",{defaultMessage:"Network Cleartext"});const LOGON_TYPE_NEW_CREDENTIALS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeNewCredentialsDescription",{defaultMessage:"New Credentials"});const LOGON_TYPE_REMOTE_INTERACTIVE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeRemoteInteractiveDescription",{defaultMessage:"Remote Interactive"});const LOGON_TYPE_SERVICE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeServiceDescription",{defaultMessage:"Service"});const LOGON_TYPE_UNLOCK=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.logonTypeUnlockDescription",{defaultMessage:"Unlock"});const SUBJECT_LOGON_ID=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.subjectLogonIdDescription",{defaultMessage:"subject logon ID"});const SUCCESSFULLY_LOGGED_IN=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.successfullyLoggedInDescription",{defaultMessage:"successfully logged in"});const TARGET_LOGON_ID=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.targetLogonIdDescription",{defaultMessage:"target logon ID"});const TO=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.toDescription",{defaultMessage:"to"});const USING_LOGON_TYPE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.usingLogonTypeDescription",{defaultMessage:"using logon type"});const translations_VIA=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.viaDescription",{defaultMessage:"via"});const WITH_SPECIAL_PRIVILEGES=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.endgame.withSpecialPrivilegesDescription",{defaultMessage:"With special privileges,"});const getHumanReadableLogonType=endgameLogonType=>{if(Object(helpers["d"])(endgameLogonType)){return""}switch(endgameLogonType){case 2:return LOGON_TYPE_INTERACTIVE;case 3:return LOGON_TYPE_NETWORK;case 4:return LOGON_TYPE_BATCH;case 5:return LOGON_TYPE_SERVICE;case 7:return LOGON_TYPE_UNLOCK;case 8:return LOGON_TYPE_NETWORK_CLEARTEXT;case 9:return LOGON_TYPE_NEW_CREDENTIALS;case 10:return LOGON_TYPE_REMOTE_INTERACTIVE;case 11:return LOGON_TYPE_CACHED_INTERACTIVE;default:return`${endgameLogonType}`}};const getHostNameSeparator=eventAction=>eventAction==="explicit_user_logon"?TO:"@";const getTargetUserAndTargetDomain=eventAction=>eventAction==="explicit_user_logon"||eventAction==="user_logoff";const getUserDomainField=eventAction=>getTargetUserAndTargetDomain(eventAction)?"endgame.target_domain_name":"user.domain";const getUserNameField=eventAction=>getTargetUserAndTargetDomain(eventAction)?"endgame.target_user_name":"user.name";const getEventDetails=({eventAction:eventAction,eventOutcome:eventOutcome})=>{switch(eventAction){case"explicit_user_logon":return"";case"log_off":case"user_logoff":return(eventOutcome===null||eventOutcome===void 0?void 0:eventOutcome.toLowerCase())==="failure"?FAILED_TO_LOG_OFF:LOGGED_OFF;default:return(eventOutcome===null||eventOutcome===void 0?void 0:eventOutcome.toLowerCase())==="failure"?FAILED_TO_LOG_IN:SUCCESSFULLY_LOGGED_IN}};const EndgameSecurityEventDetailsLine=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,endgameLogonType:endgameLogonType,endgameSubjectDomainName:endgameSubjectDomainName,endgameSubjectLogonId:endgameSubjectLogonId,endgameSubjectUserName:endgameSubjectUserName,endgameTargetDomainName:endgameTargetDomainName,endgameTargetLogonId:endgameTargetLogonId,endgameTargetUserName:endgameTargetUserName,eventAction:eventAction,eventCode:eventCode,eventOutcome:eventOutcome,hostName:hostName,id:id,processExecutable:processExecutable,processName:processName,processPid:processPid,userDomain:userDomain,userName:userName,winlogEventId:winlogEventId})=>{const domain=getTargetUserAndTargetDomain(eventAction)?endgameTargetDomainName:userDomain;const eventDetails=getEventDetails({eventAction:eventAction,eventOutcome:eventOutcome});const hostNameSeparator=getHostNameSeparator(eventAction);const user=getTargetUserAndTargetDomain(eventAction)?endgameTargetUserName:userName;const userDomainField=getUserDomainField(eventAction);const userNameField=getUserNameField(eventAction);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"center",gutterSize:"none",wrap:true},eventAction==="admin_logon"&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"with-special-privileges",grow:false},WITH_SPECIAL_PRIVILEGES),eventAction==="explicit_user_logon"&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"a-login-was-attempted",grow:false},A_LOGIN_WAS_ATTEMPTED_USING_EXPLICIT_CREDENTIALS),external_kbnSharedDeps_React_default.a.createElement(UserHostWorkingDir,{contextId:contextId,eventId:id,hostName:hostName,hostNameSeparator:hostNameSeparator,userDomain:domain,userDomainField:userDomainField,userName:user,userNameField:userNameField,workingDirectory:undefined}),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"event-details",grow:false},eventDetails),!Object(helpers["d"])(endgameLogonType)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"using-logon-type",grow:false},USING_LOGON_TYPE),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"endgame.logon_type",queryValue:String(endgameLogonType),value:`${endgameLogonType} - ${getHumanReadableLogonType(endgameLogonType)}`}))),!Object(helpers["d"])(endgameTargetLogonId)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},"("),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"using-logon-type",grow:false},TARGET_LOGON_ID),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"endgame.target_logon_id",value:endgameTargetLogonId})),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},")")),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},translations_VIA),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(process_draggable["b"],{contextId:contextId,endgamePid:undefined,endgameProcessName:undefined,eventId:id,processPid:processPid,processName:processName,processExecutable:processExecutable})),!Object(helpers["d"])(endgameSubjectUserName)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"as-requested-by-subject",grow:false},AS_REQUESTED_BY_SUBJECT),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"endgame.subject_user_name",iconType:"user",value:endgameSubjectUserName}))),endgameSubjectDomainName!=null&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"subject-domain-name-domain-separator-text",grow:false},"\\"),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"endgame.subject_domain_name",value:endgameSubjectDomainName}))),!Object(helpers["d"])(endgameSubjectLogonId)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},"("),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"subject-login-id",grow:false},SUBJECT_LOGON_ID),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"endgame.subject_logon_id",value:endgameSubjectLogonId})),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},")")),(!Object(helpers["d"])(eventCode)||!Object(helpers["d"])(winlogEventId))&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!Object(helpers["d"])(eventCode)?external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"event.code",value:eventCode})):external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,iconType:"logoWindows",field:"winlog.event_id",value:winlogEventId})))))});EndgameSecurityEventDetailsLine.displayName="EndgameSecurityEventDetailsLine";const EndgameSecurityEventDetails=external_kbnSharedDeps_React_default.a.memo(({data:data,contextId:contextId,timelineId:timelineId})=>{const endgameLogonType=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.logon_type[0]",data);const endgameSubjectDomainName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.subject_domain_name[0]",data);const endgameSubjectLogonId=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.subject_logon_id[0]",data);const endgameSubjectUserName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.subject_user_name[0]",data);const endgameTargetLogonId=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.target_logon_id[0]",data);const endgameTargetDomainName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.target_domain_name[0]",data);const endgameTargetUserName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.target_user_name[0]",data);const eventAction=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",data);const eventCode=Object(external_kbnSharedDeps_LodashFp_["get"])("event.code[0]",data);const eventOutcome=Object(external_kbnSharedDeps_LodashFp_["get"])("event.outcome[0]",data);const hostName=Object(external_kbnSharedDeps_LodashFp_["get"])("host.name[0]",data);const id=data._id;const processExecutable=Object(external_kbnSharedDeps_LodashFp_["get"])("process.executable[0]",data);const processName=Object(external_kbnSharedDeps_LodashFp_["get"])("process.name[0]",data);const processPid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.pid[0]",data);const userDomain=Object(external_kbnSharedDeps_LodashFp_["get"])("user.domain[0]",data);const userName=Object(external_kbnSharedDeps_LodashFp_["get"])("user.name[0]",data);const winlogEventId=Object(external_kbnSharedDeps_LodashFp_["get"])("winlog.event_id[0]",data);return external_kbnSharedDeps_React_default.a.createElement(helpers["a"],null,external_kbnSharedDeps_React_default.a.createElement(EndgameSecurityEventDetailsLine,{contextId:contextId,endgameLogonType:endgameLogonType,endgameSubjectDomainName:endgameSubjectDomainName,endgameSubjectLogonId:endgameSubjectLogonId,endgameSubjectUserName:endgameSubjectUserName,endgameTargetDomainName:endgameTargetDomainName,endgameTargetLogonId:endgameTargetLogonId,endgameTargetUserName:endgameTargetUserName,eventAction:eventAction,eventCode:eventCode,eventOutcome:eventOutcome,hostName:hostName,id:id,processExecutable:processExecutable,processName:processName,processPid:processPid,userDomain:userDomain,userName:userName,winlogEventId:winlogEventId}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(netflow["a"],{data:data,timelineId:timelineId}))});EndgameSecurityEventDetails.displayName="EndgameSecurityEventDetails";const registry_translations_VIA=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.registry.viaDescription",{defaultMessage:"via"});const WITH_NEW_VALUE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.body.renderers.registry.withNewValueDescription",{defaultMessage:"with new value"});const RegistryEventDetailsLineComponent=({contextId:contextId,hostName:hostName,id:id,processName:processName,processPid:processPid,registryKey:registryKey,registryPath:registryPath,text:text,userDomain:userDomain,userName:userName})=>{const registryKeyTooltipContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("div",null,"registry.key"),external_kbnSharedDeps_React_default.a.createElement("div",null,registryKey)),[registryKey]);const registryPathTooltipContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("div",null,"registry.path"),external_kbnSharedDeps_React_default.a.createElement("div",null,registryPath)),[registryPath]);if(Object(helpers["d"])(registryKey)){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"center",gutterSize:"none",wrap:true},external_kbnSharedDeps_React_default.a.createElement(UserHostWorkingDir,{contextId:contextId,eventId:id,hostName:hostName,userDomain:userDomain,userName:userName,workingDirectory:undefined}),!Object(helpers["d"])(registryKey)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"text",grow:false},text),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"registry.key",tooltipContent:registryKeyTooltipContent,value:registryKey}))),!Object(helpers["d"])(registryPath)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span","data-test-subj":"with-new-value",grow:false},WITH_NEW_VALUE),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"registry.path",tooltipContent:registryPathTooltipContent,value:registryPath}))),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},registry_translations_VIA),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{component:"span",grow:false},external_kbnSharedDeps_React_default.a.createElement(process_draggable["b"],{contextId:contextId,endgamePid:undefined,endgameProcessName:undefined,eventId:id,processPid:processPid,processName:processName,processExecutable:undefined}))))};const RegistryEventDetailsLine=external_kbnSharedDeps_React_default.a.memo(RegistryEventDetailsLineComponent);const RegistryEventDetailsComponent=({contextId:contextId,data:data,text:text})=>{const hostName=Object(external_kbnSharedDeps_LodashFp_["get"])("host.name[0]",data);const id=data._id;const processName=Object(external_kbnSharedDeps_LodashFp_["get"])("process.name[0]",data);const processPid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.pid[0]",data);const registryKey=Object(external_kbnSharedDeps_LodashFp_["get"])("registry.key[0]",data);const registryPath=Object(external_kbnSharedDeps_LodashFp_["get"])("registry.path[0]",data);const userDomain=Object(external_kbnSharedDeps_LodashFp_["get"])("user.domain[0]",data);const userName=Object(external_kbnSharedDeps_LodashFp_["get"])("user.name[0]",data);if(Object(helpers["d"])(registryKey)){return null}return external_kbnSharedDeps_React_default.a.createElement(helpers["a"],null,external_kbnSharedDeps_React_default.a.createElement(RegistryEventDetailsLine,{contextId:contextId,hostName:hostName,id:id,processName:processName,processPid:processPid,registryKey:registryKey,registryPath:registryPath,text:text,userDomain:userDomain,userName:userName}))};RegistryEventDetailsComponent.displayName="RegistryEventDetailsComponent";const RegistryEventDetails=external_kbnSharedDeps_React_default.a.memo(RegistryEventDetailsComponent);var row_renderer=__webpack_require__(293);var tables_helpers=__webpack_require__(183);var translations=__webpack_require__(185);const Package=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,eventId:eventId,packageName:packageName,packageSummary:packageSummary,packageVersion:packageVersion})=>{if(packageName!=null||packageSummary!=null||packageVersion!=null){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"system.audit.package.name",value:packageName,iconType:"document"})),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"system.audit.package.version",value:packageVersion,iconType:"document"})),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"system.audit.package.summary",value:packageSummary})))}else{return null}});Package.displayName="Package";const AuthSsh=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,eventId:eventId,sshSignature:sshSignature,sshMethod:sshMethod})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,sshSignature!=null&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"system.audit.package.name",value:sshSignature,iconType:"document"})),sshMethod!=null&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"system.audit.package.version",value:sshMethod,iconType:"document"}))));AuthSsh.displayName="AuthSsh";var page=__webpack_require__(153);const SystemGenericLine=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,hostName:hostName,id:id,message:message,outcome:outcome,packageName:packageName,packageSummary:packageSummary,packageVersion:packageVersion,processPid:processPid,processName:processName,processExecutable:processExecutable,sshSignature:sshSignature,sshMethod:sshMethod,text:text,userDomain:userDomain,userName:userName,workingDirectory:workingDirectory})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"center",gutterSize:"none",wrap:true},external_kbnSharedDeps_React_default.a.createElement(UserHostWorkingDir,{contextId:contextId,eventId:id,userDomain:userDomain,userName:userName,hostName:hostName,workingDirectory:workingDirectory}),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},text),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(process_draggable["a"],{contextId:contextId,endgamePid:undefined,endgameProcessName:undefined,eventId:id,processPid:processPid,processName:processName,processExecutable:processExecutable})),outcome!=null&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},translations["W"]),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"event.outcome",queryValue:outcome,value:outcome})),external_kbnSharedDeps_React_default.a.createElement(AuthSsh,{contextId:contextId,eventId:id,sshSignature:sshSignature,sshMethod:sshMethod}),external_kbnSharedDeps_React_default.a.createElement(Package,{contextId:contextId,eventId:id,packageName:packageName,packageSummary:packageSummary,packageVersion:packageVersion})),message!=null&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center",gutterSize:"none",wrap:true},external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(page["b"],{iconType:"editorComment",color:"hollow",title:""},external_kbnSharedDeps_React_default.a.createElement(tables_helpers["a"],{value:message})))))));SystemGenericLine.displayName="SystemGenericLine";const SystemGenericDetails=external_kbnSharedDeps_React_default.a.memo(({data:data,contextId:contextId,text:text,timelineId:timelineId})=>{const id=data._id;const message=data.message!=null?data.message[0]:null;const hostName=Object(external_kbnSharedDeps_LodashFp_["get"])("host.name[0]",data);const userDomain=Object(external_kbnSharedDeps_LodashFp_["get"])("user.domain[0]",data);const userName=Object(external_kbnSharedDeps_LodashFp_["get"])("user.name[0]",data);const outcome=Object(external_kbnSharedDeps_LodashFp_["get"])("event.outcome[0]",data);const packageName=Object(external_kbnSharedDeps_LodashFp_["get"])("system.audit.package.name[0]",data);const packageSummary=Object(external_kbnSharedDeps_LodashFp_["get"])("system.audit.package.summary[0]",data);const packageVersion=Object(external_kbnSharedDeps_LodashFp_["get"])("system.audit.package.version[0]",data);const processPid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.pid[0]",data);const processName=Object(external_kbnSharedDeps_LodashFp_["get"])("process.name[0]",data);const processExecutable=Object(external_kbnSharedDeps_LodashFp_["get"])("process.executable[0]",data);const sshSignature=Object(external_kbnSharedDeps_LodashFp_["get"])("system.auth.ssh.signature[0]",data);const sshMethod=Object(external_kbnSharedDeps_LodashFp_["get"])("system.auth.ssh.method[0]",data);const workingDirectory=Object(external_kbnSharedDeps_LodashFp_["get"])("process.working_directory[0]",data);return external_kbnSharedDeps_React_default.a.createElement(helpers["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericLine,{contextId:contextId,hostName:hostName,id:id,message:message,outcome:outcome,packageName:packageName,packageSummary:packageSummary,packageVersion:packageVersion,processExecutable:processExecutable,processPid:processPid,processName:processName,sshMethod:sshMethod,sshSignature:sshSignature,text:text,userDomain:userDomain,userName:userName,workingDirectory:workingDirectory}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(netflow["a"],{data:data,timelineId:timelineId}))});SystemGenericDetails.displayName="SystemGenericDetails";var renderers_args=__webpack_require__(461);const ExitCodeDraggable=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,endgameExitCode:endgameExitCode,eventId:eventId,processExitCode:processExitCode,text:text})=>{if(Object(helpers["d"])(processExitCode)&&Object(helpers["d"])(endgameExitCode)){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!Object(helpers["d"])(text)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{"data-test-subj":"exit-code-draggable-text",grow:false,component:"span"},text),!Object(helpers["d"])(processExitCode)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"process.exit_code",value:`${processExitCode}`})),!Object(helpers["d"])(endgameExitCode)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"endgame.exit_code",value:endgameExitCode})))});ExitCodeDraggable.displayName="ExitCodeDraggable";var renderers_translations=__webpack_require__(297);const FileDraggable=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,endgameFileName:endgameFileName,endgameFilePath:endgameFilePath,eventId:eventId,fileExtOriginalPath:fileExtOriginalPath,fileName:fileName,filePath:filePath})=>{if(Object(helpers["d"])(fileName)&&Object(helpers["d"])(endgameFileName)&&Object(helpers["d"])(filePath)&&Object(helpers["d"])(endgameFilePath)){return null}const filePathIsKnown=!Object(helpers["d"])(filePath)||!Object(helpers["d"])(endgameFilePath);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!Object(helpers["d"])(fileName)?external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"file.name",value:fileName,iconType:"document"})):!Object(helpers["d"])(endgameFileName)?external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"endgame.file_name",value:endgameFileName,iconType:"document"})):null,filePathIsKnown&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{"data-test-subj":"in",grow:false,component:"span"},renderers_translations["c"]),!Object(helpers["d"])(filePath)?external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"file.path",value:filePath,iconType:"document"})):!Object(helpers["d"])(endgameFilePath)?external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"endgame.file_path",value:endgameFilePath,iconType:"document"})):null,!Object(helpers["d"])(fileExtOriginalPath)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},renderers_translations["b"]),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"file.Ext.original.path",value:fileExtOriginalPath,iconType:"document"}))))});FileDraggable.displayName="FileDraggable";var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);const HashFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"HashFlexGroup",componentId:"dv64zz-0"})(["margin:",";"],({theme:theme})=>theme.eui.euiSizeXS);const FileHash=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,eventId:eventId,fileHashSha256:fileHashSha256})=>{if(Object(helpers["d"])(fileHashSha256)){return null}return external_kbnSharedDeps_React_default.a.createElement(HashFlexGroup,{alignItems:"center",direction:"column",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"div"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"file.hash.sha256",iconType:"number",value:fileHashSha256})))});FileHash.displayName="FileHash";const ParentProcessDraggable=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,endgameParentProcessName:endgameParentProcessName,eventId:eventId,processParentName:processParentName,processParentPid:processParentPid,processPpid:processPpid,text:text})=>{if(Object(helpers["d"])(processParentName)&&Object(helpers["d"])(endgameParentProcessName)){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!Object(helpers["d"])(text)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{"data-test-subj":"parent-process-draggable-text",grow:false,component:"span"},text),!Object(helpers["d"])(processParentName)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"process.parent.name",value:processParentName})),!Object(helpers["d"])(endgameParentProcessName)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"endgame.parent_process_name",value:endgameParentProcessName})),!Object(helpers["d"])(processParentPid)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"process.parent.pid",queryValue:String(processParentPid),value:`(${String(processParentPid)})`})),!Object(helpers["d"])(processPpid)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"process.ppid",queryValue:String(processPpid),value:`(${String(processPpid)})`})))});ParentProcessDraggable.displayName="ParentProcessDraggable";const process_hash_HashFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"HashFlexGroup",componentId:"sc-1qc8g7c-0"})(["margin:",";"],({theme:theme})=>theme.eui.euiSizeXS);const ProcessHash=external_kbnSharedDeps_React_default.a.memo(({contextId:contextId,eventId:eventId,processHashSha256:processHashSha256})=>{if(Object(helpers["d"])(processHashSha256)){return null}return external_kbnSharedDeps_React_default.a.createElement(process_hash_HashFlexGroup,{alignItems:"center",direction:"column",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"div"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:eventId,field:"process.hash.sha256",iconType:"number",value:processHashSha256})))});ProcessHash.displayName="ProcessHash";const SystemGenericFileLine=external_kbnSharedDeps_React_default.a.memo(({args:args,contextId:contextId,endgameExitCode:endgameExitCode,endgameFileName:endgameFileName,endgameFilePath:endgameFilePath,endgameParentProcessName:endgameParentProcessName,endgamePid:endgamePid,endgameProcessName:endgameProcessName,eventAction:eventAction,fileExtOriginalPath:fileExtOriginalPath,fileHashSha256:fileHashSha256,fileName:fileName,filePath:filePath,hostName:hostName,id:id,message:message,outcome:outcome,packageName:packageName,processParentName:processParentName,processParentPid:processParentPid,processExitCode:processExitCode,packageSummary:packageSummary,packageVersion:packageVersion,processExecutable:processExecutable,processHashSha256:processHashSha256,processName:processName,processPid:processPid,processPpid:processPpid,processTitle:processTitle,showMessage:showMessage,skipRedundantFileDetails:skipRedundantFileDetails=false,skipRedundantProcessDetails:skipRedundantProcessDetails=false,sshSignature:sshSignature,sshMethod:sshMethod,text:text,userDomain:userDomain,userName:userName,workingDirectory:workingDirectory})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"center",gutterSize:"none",wrap:true},external_kbnSharedDeps_React_default.a.createElement(UserHostWorkingDir,{eventId:id,contextId:contextId,userDomain:userDomain,userName:userName,workingDirectory:workingDirectory,hostName:hostName}),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},text),!skipRedundantFileDetails&&external_kbnSharedDeps_React_default.a.createElement(FileDraggable,{contextId:contextId,endgameFileName:endgameFileName,endgameFilePath:endgameFilePath,eventId:id,fileExtOriginalPath:fileExtOriginalPath,fileName:fileName,filePath:filePath}),Object(helpers["f"])(eventAction)&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{"data-test-subj":"via",grow:false,component:"span"},translations["L"]),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(process_draggable["b"],{contextId:contextId,endgamePid:endgamePid,endgameProcessName:endgameProcessName,eventId:id,processPid:processPid,processName:processName,processExecutable:processExecutable})),external_kbnSharedDeps_React_default.a.createElement(renderers_args["a"],{args:args,contextId:contextId,eventId:id,processTitle:processTitle}),external_kbnSharedDeps_React_default.a.createElement(ExitCodeDraggable,{contextId:contextId,endgameExitCode:endgameExitCode,eventId:id,processExitCode:processExitCode,text:translations["V"]}),!Object(helpers["e"])(eventAction)&&external_kbnSharedDeps_React_default.a.createElement(ParentProcessDraggable,{contextId:contextId,endgameParentProcessName:endgameParentProcessName,eventId:id,processParentName:processParentName,processParentPid:processParentPid,processPpid:processPpid,text:translations["M"]}),outcome!=null&&external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},translations["W"]),external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(draggables["c"],{contextId:contextId,eventId:id,field:"event.outcome",queryValue:outcome,value:outcome})),external_kbnSharedDeps_React_default.a.createElement(AuthSsh,{contextId:contextId,eventId:id,sshSignature:sshSignature,sshMethod:sshMethod}),external_kbnSharedDeps_React_default.a.createElement(Package,{contextId:contextId,eventId:id,packageName:packageName,packageSummary:packageSummary,packageVersion:packageVersion})),!skipRedundantFileDetails&&external_kbnSharedDeps_React_default.a.createElement(FileHash,{contextId:contextId,eventId:id,fileHashSha256:fileHashSha256}),!skipRedundantProcessDetails&&external_kbnSharedDeps_React_default.a.createElement(ProcessHash,{contextId:contextId,eventId:id,processHashSha256:processHashSha256}),message!=null&&showMessage&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center",gutterSize:"none",wrap:true},external_kbnSharedDeps_React_default.a.createElement(helpers["b"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(page["b"],{iconType:"editorComment",color:"hollow",title:""},external_kbnSharedDeps_React_default.a.createElement(tables_helpers["a"],{value:message})))))));SystemGenericFileLine.displayName="SystemGenericFileLine";const SystemGenericFileDetails=external_kbnSharedDeps_React_default.a.memo(({data:data,contextId:contextId,showMessage:showMessage=true,skipRedundantFileDetails:skipRedundantFileDetails=false,skipRedundantProcessDetails:skipRedundantProcessDetails=false,text:text,timelineId:timelineId})=>{const id=data._id;const message=data.message!=null?data.message[0]:null;const hostName=Object(external_kbnSharedDeps_LodashFp_["get"])("host.name[0]",data);const endgameExitCode=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.exit_code[0]",data);const endgameFileName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.file_name[0]",data);const endgameFilePath=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.file_path[0]",data);const endgameParentProcessName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.parent_process_name[0]",data);const endgamePid=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.pid[0]",data);const endgameProcessName=Object(external_kbnSharedDeps_LodashFp_["get"])("endgame.process_name[0]",data);const eventAction=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",data);const fileExtOriginalPath=Object(external_kbnSharedDeps_LodashFp_["get"])("file.Ext.original.path[0]",data);const fileHashSha256=Object(external_kbnSharedDeps_LodashFp_["get"])("file.hash.sha256[0]",data);const fileName=Object(external_kbnSharedDeps_LodashFp_["get"])("file.name[0]",data);const filePath=Object(external_kbnSharedDeps_LodashFp_["get"])("file.path[0]",data);const userDomain=Object(external_kbnSharedDeps_LodashFp_["get"])("user.domain[0]",data);const userName=Object(external_kbnSharedDeps_LodashFp_["get"])("user.name[0]",data);const outcome=Object(external_kbnSharedDeps_LodashFp_["get"])("event.outcome[0]",data);const packageName=Object(external_kbnSharedDeps_LodashFp_["get"])("system.audit.package.name[0]",data);const packageSummary=Object(external_kbnSharedDeps_LodashFp_["get"])("system.audit.package.summary[0]",data);const packageVersion=Object(external_kbnSharedDeps_LodashFp_["get"])("system.audit.package.version[0]",data);const processExitCode=Object(external_kbnSharedDeps_LodashFp_["get"])("process.exit_code[0]",data);const processParentName=Object(external_kbnSharedDeps_LodashFp_["get"])("process.parent.name[0]",data);const processParentPid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.parent.pid[0]",data);const processHashSha256=Object(external_kbnSharedDeps_LodashFp_["get"])("process.hash.sha256[0]",data);const processPid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.pid[0]",data);const processPpid=Object(external_kbnSharedDeps_LodashFp_["get"])("process.ppid[0]",data);const processName=Object(external_kbnSharedDeps_LodashFp_["get"])("process.name[0]",data);const sshSignature=Object(external_kbnSharedDeps_LodashFp_["get"])("system.auth.ssh.signature[0]",data);const sshMethod=Object(external_kbnSharedDeps_LodashFp_["get"])("system.auth.ssh.method[0]",data);const processExecutable=Object(external_kbnSharedDeps_LodashFp_["get"])("process.executable[0]",data);const processTitle=Object(external_kbnSharedDeps_LodashFp_["get"])("process.title[0]",data);const workingDirectory=Object(external_kbnSharedDeps_LodashFp_["get"])("process.working_directory[0]",data);const args=Object(external_kbnSharedDeps_LodashFp_["get"])("process.args",data);return external_kbnSharedDeps_React_default.a.createElement(helpers["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileLine,{id:id,contextId:contextId,text:text,hostName:hostName,endgameExitCode:endgameExitCode,endgameFileName:endgameFileName,endgameFilePath:endgameFilePath,endgameParentProcessName:endgameParentProcessName,endgamePid:endgamePid,endgameProcessName:endgameProcessName,eventAction:eventAction,fileExtOriginalPath:fileExtOriginalPath,fileHashSha256:fileHashSha256,fileName:fileName,filePath:filePath,userDomain:userDomain,userName:userName,message:message,processExitCode:processExitCode,processParentName:processParentName,processParentPid:processParentPid,processTitle:processTitle,workingDirectory:workingDirectory,args:args,packageName:packageName,packageSummary:packageSummary,packageVersion:packageVersion,processHashSha256:processHashSha256,processName:processName,processPid:processPid,processPpid:processPpid,processExecutable:processExecutable,showMessage:showMessage,skipRedundantFileDetails:skipRedundantFileDetails,skipRedundantProcessDetails:skipRedundantProcessDetails,sshSignature:sshSignature,sshMethod:sshMethod,outcome:outcome}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(netflow["a"],{data:data,timelineId:timelineId}))});SystemGenericFileDetails.displayName="SystemGenericFileDetails";const createGenericSystemRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].system,isInstance:ecs=>{const module=Object(external_kbnSharedDeps_LodashFp_["get"])("event.module[0]",ecs);const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);return module!=null&&module.toLowerCase()==="system"&&action!=null&&action.toLowerCase()===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericDetails,{browserFields:browserFields,data:data,contextId:`${actionName}-${timelineId}`,text:text,timelineId:timelineId}))});const createEndgameProcessRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].system_file,isInstance:ecs=>{const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);const category=Object(external_kbnSharedDeps_LodashFp_["get"])("event.category[0]",ecs);const dataset=Object(external_kbnSharedDeps_LodashFp_["get"])("event.dataset[0]",ecs);return((category===null||category===void 0?void 0:category.toLowerCase())==="process"||(dataset===null||dataset===void 0?void 0:dataset.toLowerCase())==="endpoint.events.process")&&(action===null||action===void 0?void 0:action.toLowerCase())===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileDetails,{browserFields:browserFields,data:data,contextId:`endgame-process-${actionName}-${timelineId}`,showMessage:false,text:text,timelineId:timelineId}))});const createFimRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].system_fim,isInstance:ecs=>{const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);const category=Object(external_kbnSharedDeps_LodashFp_["get"])("event.category[0]",ecs);const dataset=Object(external_kbnSharedDeps_LodashFp_["get"])("event.dataset[0]",ecs);return Object(helpers["c"])({eventCategory:category,eventDataset:dataset})&&(action===null||action===void 0?void 0:action.toLowerCase())===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileDetails,{browserFields:browserFields,data:data,contextId:`fim-${actionName}-${timelineId}`,showMessage:false,text:text,timelineId:timelineId}))});const createEndpointAlertsRowRenderer=({eventAction:eventAction,eventCategory:eventCategory,eventType:eventType,skipRedundantFileDetails:skipRedundantFileDetails=false,skipRedundantProcessDetails:skipRedundantProcessDetails=false,text:text})=>({id:timeline["b"].alerts,isInstance:ecs=>{var _action$includes,_category$includes,_type$includes;const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action",ecs);const category=Object(external_kbnSharedDeps_LodashFp_["get"])("event.category",ecs);const dataset=Object(external_kbnSharedDeps_LodashFp_["get"])("event.dataset[0]",ecs);const type=Object(external_kbnSharedDeps_LodashFp_["get"])("event.type",ecs);const eventActionMatches=(_action$includes=action===null||action===void 0?void 0:action.includes(eventAction))!==null&&_action$includes!==void 0?_action$includes:false;const eventCategoryMatches=(_category$includes=category===null||category===void 0?void 0:category.includes(eventCategory))!==null&&_category$includes!==void 0?_category$includes:false;const eventTypeMatches=(_type$includes=type===null||type===void 0?void 0:type.includes(eventType))!==null&&_type$includes!==void 0?_type$includes:false;return(dataset===null||dataset===void 0?void 0:dataset.toLowerCase())==="endpoint.alerts"&&eventTypeMatches&&eventCategoryMatches&&eventActionMatches},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileDetails,{browserFields:browserFields,data:data,contextId:`endpoint-alerts-row-renderer-${eventAction}-${eventCategory}-${eventType}-${timelineId}`,showMessage:false,skipRedundantFileDetails:skipRedundantFileDetails,skipRedundantProcessDetails:skipRedundantProcessDetails,text:text,timelineId:timelineId}))});const createEndpointLibraryRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].library,isInstance:ecs=>{const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);const dataset=Object(external_kbnSharedDeps_LodashFp_["get"])("event.dataset[0]",ecs);return(dataset===null||dataset===void 0?void 0:dataset.toLowerCase())==="endpoint.events.library"&&(action===null||action===void 0?void 0:action.toLowerCase())===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileDetails,{browserFields:browserFields,data:data,contextId:`library-row-renderer-${actionName}-${timelineId}`,showMessage:false,text:text,timelineId:timelineId}))});const createGenericFileRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].system_file,isInstance:ecs=>{const module=Object(external_kbnSharedDeps_LodashFp_["get"])("event.module[0]",ecs);const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);return module!=null&&module.toLowerCase()==="system"&&action!=null&&action.toLowerCase()===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileDetails,{browserFields:browserFields,data:data,contextId:`${actionName}-${timelineId}`,text:text,timelineId:timelineId}))});const createSocketRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].system_socket,isInstance:ecs=>{const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);return action!=null&&action.toLowerCase()===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(SystemGenericFileDetails,{browserFields:browserFields,data:data,contextId:`socket-${actionName}-${timelineId}`,text:text,timelineId:timelineId}))});const createSecurityEventRowRenderer=({actionName:actionName})=>({id:timeline["b"].system_security_event,isInstance:ecs=>{const category=Object(external_kbnSharedDeps_LodashFp_["get"])("event.category[0]",ecs);const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);const dataset=Object(external_kbnSharedDeps_LodashFp_["get"])("event.dataset[0]",ecs);return((category===null||category===void 0?void 0:category.toLowerCase())==="authentication"||(dataset===null||dataset===void 0?void 0:dataset.toLowerCase())==="endpoint.events.security")&&(action===null||action===void 0?void 0:action.toLowerCase())===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(EndgameSecurityEventDetails,{browserFields:browserFields,data:data,contextId:`authentication-${actionName}-${timelineId}`,timelineId:timelineId}))});const createDnsRowRenderer=()=>({id:timeline["b"].system_dns,isInstance:ecs=>{const dnsQuestionType=Object(external_kbnSharedDeps_LodashFp_["get"])("dns.question.type[0]",ecs);const dnsQuestionName=Object(external_kbnSharedDeps_LodashFp_["get"])("dns.question.name[0]",ecs);return!Object(helpers["d"])(dnsQuestionType)&&!Object(helpers["d"])(dnsQuestionName)},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(DnsRequestEventDetails,{browserFields:browserFields,data:data,contextId:`dns-request-${timelineId}`,timelineId:timelineId}))});const createEndpointRegistryRowRenderer=({actionName:actionName,text:text})=>({id:timeline["b"].registry,isInstance:ecs=>{const action=Object(external_kbnSharedDeps_LodashFp_["get"])("event.action[0]",ecs);const dataset=Object(external_kbnSharedDeps_LodashFp_["get"])("event.dataset[0]",ecs);return(dataset===null||dataset===void 0?void 0:dataset.toLowerCase())==="endpoint.events.registry"&&(action===null||action===void 0?void 0:action.toLowerCase())===actionName},renderRow:({browserFields:browserFields,data:data,timelineId:timelineId})=>external_kbnSharedDeps_React_default.a.createElement(row_renderer["a"],null,external_kbnSharedDeps_React_default.a.createElement(RegistryEventDetails,{browserFields:browserFields,data:data,contextId:`registry-event-${timelineId}`,text:text}))});const systemLoginRowRenderer=createGenericSystemRowRenderer({actionName:"user_login",text:translations["c"]});const systemProcessStartedRowRenderer=createGenericFileRowRenderer({actionName:"process_started",text:translations["A"]});const endgameProcessStartedRowRenderer=createEndgameProcessRowRenderer({actionName:"creation_event",text:translations["A"]});const endpointProcessStartRowRenderer=createEndgameProcessRowRenderer({actionName:"start",text:translations["A"]});const endpointRegistryModificationRowRenderer=createEndpointRegistryRowRenderer({actionName:"modification",text:translations["u"]});const systemProcessStoppedRowRenderer=createGenericFileRowRenderer({actionName:"process_stopped",text:translations["B"]});const endgameProcessTerminationRowRenderer=createEndgameProcessRowRenderer({actionName:"termination_event",text:translations["H"]});const endpointProcessEndRowRenderer=createEndgameProcessRowRenderer({actionName:"end",text:translations["H"]});const endgameFileCreateEventRowRenderer=createFimRowRenderer({actionName:"file_create_event",text:translations["e"]});const endpointFileCreationEventRowRenderer=createFimRowRenderer({actionName:"creation",text:translations["e"]});const fimFileCreateEventRowRenderer=createFimRowRenderer({actionName:"created",text:translations["e"]});const endgameFileDeleteEventRowRenderer=createFimRowRenderer({actionName:"file_delete_event",text:translations["f"]});const endpointFileDeletionEventRowRenderer=createFimRowRenderer({actionName:"deletion",text:translations["f"]});const endpointModificationEventRowRenderer=createFimRowRenderer({actionName:"modification",text:translations["t"]});const endpointFileOverwriteEventRowRenderer=createFimRowRenderer({actionName:"overwrite",text:translations["v"]});const endpointFileRenamedEventRowRenderer=createFimRowRenderer({actionName:"rename",text:translations["E"]});const fimFileDeletedEventRowRenderer=createFimRowRenderer({actionName:"deleted",text:translations["f"]});const systemExistingRowRenderer=createGenericFileRowRenderer({actionName:"existing_process",text:translations["k"]});const endpointAlertCriteria=[{eventAction:"creation",eventCategory:"file",eventType:"denied",skipRedundantProcessDetails:true,text:translations["R"]},{eventAction:"creation",eventCategory:"file",eventType:"allowed",skipRedundantProcessDetails:true,text:translations["N"]},{eventAction:"files-encrypted",eventCategory:"file",eventType:"denied",skipRedundantFileDetails:true,text:translations["D"]},{eventAction:"files-encrypted",eventCategory:"file",eventType:"allowed",skipRedundantFileDetails:true,text:translations["C"]},{eventAction:"modification",eventCategory:"file",eventType:"denied",skipRedundantProcessDetails:true,text:translations["T"]},{eventAction:"modification",eventCategory:"file",eventType:"allowed",skipRedundantProcessDetails:true,text:translations["P"]},{eventAction:"rename",eventCategory:"file",eventType:"denied",skipRedundantProcessDetails:true,text:translations["U"]},{eventAction:"rename",eventCategory:"file",eventType:"allowed",skipRedundantProcessDetails:true,text:translations["Q"]},{eventAction:"execution",eventCategory:"process",eventType:"denied",skipRedundantFileDetails:true,text:translations["S"]},{eventAction:"execution",eventCategory:"process",eventType:"allowed",skipRedundantFileDetails:true,text:translations["O"]}];const endpointAlertsRowRenderers=endpointAlertCriteria.map(criteria=>createEndpointAlertsRowRenderer(criteria));const endpointLibraryLoadRowRenderer=createEndpointLibraryRowRenderer({actionName:"load",text:translations["q"]});const systemSocketOpenedRowRenderer=createSocketRowRenderer({actionName:"socket_opened",text:translations["G"]});const systemSocketClosedRowRenderer=createSocketRowRenderer({actionName:"socket_closed",text:translations["F"]});const endgameIpv4ConnectionAcceptEventRowRenderer=createSocketRowRenderer({actionName:"ipv4_connection_accept_event",text:translations["b"]});const endpointConnectionAcceptedEventRowRenderer=createSocketRowRenderer({actionName:"connection_accepted",text:translations["b"]});const endpointHttpRequestEventRowRenderer=createSocketRowRenderer({actionName:"http_request",text:translations["s"]});const endpointProcessExecRowRenderer=createEndgameProcessRowRenderer({actionName:"exec",text:translations["i"]});const endpointProcessForkRowRenderer=createEndgameProcessRowRenderer({actionName:"fork",text:translations["n"]});const endgameIpv6ConnectionAcceptEventRowRenderer=createSocketRowRenderer({actionName:"ipv6_connection_accept_event",text:translations["b"]});const endgameIpv4DisconnectReceivedEventRowRenderer=createSocketRowRenderer({actionName:"ipv4_disconnect_received_event",text:translations["g"]});const endpointDisconnectReceivedEventRowRenderer=createSocketRowRenderer({actionName:"disconnect_received",text:translations["g"]});const endgameIpv6DisconnectReceivedEventRowRenderer=createSocketRowRenderer({actionName:"ipv6_disconnect_received_event",text:translations["g"]});const endgameAdminLogonRowRenderer=createSecurityEventRowRenderer({actionName:"admin_logon"});const endgameExplicitUserLogonRowRenderer=createSecurityEventRowRenderer({actionName:"explicit_user_logon"});const endgameUserLogoffRowRenderer=createSecurityEventRowRenderer({actionName:"user_logoff"});const endgameUserLogonRowRenderer=createSecurityEventRowRenderer({actionName:"user_logon"});const endpointUserLogOnRowRenderer=createSecurityEventRowRenderer({actionName:"log_on"});const dnsRowRenderer=createDnsRowRenderer();const systemExistingUserRowRenderer=createGenericSystemRowRenderer({actionName:"existing_user",text:translations["m"]});const systemExistingSocketRowRenderer=createGenericFileRowRenderer({actionName:"existing_socket",text:translations["l"]});const systemExistingPackageRowRenderer=createGenericSystemRowRenderer({actionName:"existing_package",text:translations["j"]});const systemInvalidRowRenderer=createGenericFileRowRenderer({actionName:"invalid",text:translations["p"]});const systemUserChangedRowRenderer=createGenericSystemRowRenderer({actionName:"user_changed",text:translations["J"]});const systemHostChangedRowRenderer=createGenericSystemRowRenderer({actionName:"host",text:translations["o"]});const systemUserAddedRowRenderer=createGenericSystemRowRenderer({actionName:"user_added",text:translations["I"]});const systemLogoutRowRenderer=createGenericSystemRowRenderer({actionName:"user_logout",text:translations["r"]});const endpointUserLogOffRowRenderer=createSecurityEventRowRenderer({actionName:"log_off"});const systemProcessErrorRowRenderer=createGenericFileRowRenderer({actionName:"process_error",text:translations["z"]});const systemErrorRowRendererDeprecated=createGenericSystemRowRenderer({actionName:"error:",text:translations["h"]});const systemErrorRowRenderer=createGenericSystemRowRenderer({actionName:"error",text:translations["h"]});const systemPackageInstalledRowRenderer=createGenericSystemRowRenderer({actionName:"package_installed",text:translations["w"]});const systemBootRowRenderer=createGenericSystemRowRenderer({actionName:"boot",text:translations["d"]});const systemAcceptedRowRenderer=createGenericSystemRowRenderer({actionName:"accepted",text:translations["a"]});const systemPackageUpdatedRowRenderer=createGenericSystemRowRenderer({actionName:"package_updated",text:translations["y"]});const systemPackageRemovedRowRenderer=createGenericSystemRowRenderer({actionName:"package_removed",text:translations["x"]});const systemUserRemovedRowRenderer=createGenericSystemRowRenderer({actionName:"user_removed",text:translations["K"]});const systemRowRenderers=[dnsRowRenderer,endgameAdminLogonRowRenderer,endgameExplicitUserLogonRowRenderer,endgameFileCreateEventRowRenderer,endpointFileCreationEventRowRenderer,endgameFileDeleteEventRowRenderer,endpointFileDeletionEventRowRenderer,endpointFileOverwriteEventRowRenderer,endpointFileRenamedEventRowRenderer,...endpointAlertsRowRenderers,endpointLibraryLoadRowRenderer,endpointModificationEventRowRenderer,endpointRegistryModificationRowRenderer,endgameIpv4ConnectionAcceptEventRowRenderer,endpointConnectionAcceptedEventRowRenderer,endpointHttpRequestEventRowRenderer,endpointProcessExecRowRenderer,endpointProcessForkRowRenderer,endgameIpv6ConnectionAcceptEventRowRenderer,endgameIpv4DisconnectReceivedEventRowRenderer,endpointDisconnectReceivedEventRowRenderer,endgameIpv6DisconnectReceivedEventRowRenderer,endgameProcessStartedRowRenderer,endpointProcessStartRowRenderer,endgameProcessTerminationRowRenderer,endpointProcessEndRowRenderer,endgameUserLogoffRowRenderer,endgameUserLogonRowRenderer,endpointUserLogOnRowRenderer,fimFileCreateEventRowRenderer,fimFileDeletedEventRowRenderer,systemAcceptedRowRenderer,systemBootRowRenderer,systemErrorRowRenderer,systemErrorRowRendererDeprecated,systemExistingPackageRowRenderer,systemExistingRowRenderer,systemExistingSocketRowRenderer,systemExistingUserRowRenderer,systemHostChangedRowRenderer,systemInvalidRowRenderer,systemLoginRowRenderer,systemLogoutRowRenderer,endpointUserLogOffRowRenderer,systemPackageInstalledRowRenderer,systemPackageUpdatedRowRenderer,systemPackageRemovedRowRenderer,systemProcessErrorRowRenderer,systemProcessStartedRowRenderer,systemProcessStoppedRowRenderer,systemSocketClosedRowRenderer,systemSocketOpenedRowRenderer,systemUserAddedRowRenderer,systemUserChangedRowRenderer,systemUserRemovedRowRenderer]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AndOrBadge}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const AND=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.andOrBadge.and",{defaultMessage:"AND"});const OR=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.andOrBadge.or",{defaultMessage:"OR"});const RoundBadge=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiBadge"]).withConfig({displayName:"RoundBadge",componentId:"wu3h16-0"})(["align-items:center;border-radius:100%;display:inline-flex;font-size:9px;height:34px;justify-content:center;margin:0 5px 0 5px;padding:7px 6px 4px 6px;user-select:none;width:34px;.euiBadge__content{position:relative;top:-1px;}.euiBadge__text{text-overflow:clip;}"]);RoundBadge.displayName="RoundBadge";const RoundedBadge=({type:type})=>external_kbnSharedDeps_React_default.a.createElement(RoundBadge,{"data-test-subj":"and-or-badge",color:"hollow"},type==="and"?AND:OR);RoundedBadge.displayName="RoundedBadge";const antennaStyles=Object(external_kbnSharedDeps_StyledComponents_["css"])(["background:",";position:relative;width:2px;&:after{background:",";content:'';height:8px;right:-4px;position:absolute;width:10px;clip-path:circle();}"],({theme:theme})=>theme.eui.euiColorLightShade,({theme:theme})=>theme.eui.euiColorLightShade);const TopAntenna=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"TopAntenna",componentId:"sc-10c57g6-0"})([""," &:after{top:0;}"],antennaStyles);const BottomAntenna=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"BottomAntenna",componentId:"sc-10c57g6-1"})([""," &:after{bottom:0;}"],antennaStyles);const RoundedBadgeAntenna=({type:type})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{className:"andBadgeContainer",gutterSize:"none",direction:"column",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(TopAntenna,{"data-test-subj":"andOrBadgeBarTop",grow:1}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RoundedBadge,{type:type})),external_kbnSharedDeps_React_default.a.createElement(BottomAntenna,{"data-test-subj":"andOrBadgeBarBottom",grow:1}));RoundedBadgeAntenna.displayName="RoundedBadgeAntenna";const AndOrBadge=external_kbnSharedDeps_React_default.a.memo(({type:type,includeAntennas:includeAntennas=false})=>includeAntennas?external_kbnSharedDeps_React_default.a.createElement(RoundedBadgeAntenna,{type:type}):external_kbnSharedDeps_React_default.a.createElement(RoundedBadge,{type:type}));AndOrBadge.displayName="AndOrBadge"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return InspectButtonContainer}));__webpack_require__.d(__webpack_exports__,"a",(function(){return InspectButton}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(105);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var store=__webpack_require__(122);var inputs=__webpack_require__(149);var external_kbnSharedDeps_ElasticNumeral_=__webpack_require__(83);var external_kbnSharedDeps_ElasticNumeral_default=__webpack_require__.n(external_kbnSharedDeps_ElasticNumeral_);var constants=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const INSPECT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspectDescription",{defaultMessage:"Inspect"});const CLOSE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.closeTitle",{defaultMessage:"Close"});const SOMETHING_WENT_WRONG=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.somethingWentWrongDescription",{defaultMessage:"Sorry about that, something went wrong."});const INDEX_PATTERN=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.indexPatternLabel",{defaultMessage:"Index pattern"});const INDEX_PATTERN_DESC=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.indexPatternDescription",{defaultMessage:"The index pattern that connected to the Elasticsearch indices. These indices can be configured in Kibana > Advanced Settings."});const QUERY_TIME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.queryTimeLabel",{defaultMessage:"Query time"});const QUERY_TIME_DESC=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.queryTimeDescription",{defaultMessage:"The time it took to process the query. Does not include the time to send the request or parse it in the browser."});const REQUEST_TIMESTAMP=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.reqTimestampLabel",{defaultMessage:"Request timestamp"});const REQUEST_TIMESTAMP_DESC=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.reqTimestampDescription",{defaultMessage:"Time when the start of the request has been logged"});const NO_ALERT_INDEX_FOUND=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.inspect.modal.noAlertIndexFound",{defaultMessage:"No alert index found"});const DescriptionListStyled=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"]).withConfig({displayName:"DescriptionListStyled",componentId:"c8ba4g-0"})(["@media only screen and (min-width:","){.euiDescriptionList__title{width:30% !important;}.euiDescriptionList__description{width:70% !important;}}"],props=>props.theme.eui.euiBreakpoints.s);DescriptionListStyled.displayName="DescriptionListStyled";const MyEuiModal=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiModal"]).withConfig({displayName:"MyEuiModal",componentId:"c8ba4g-1"})([".euiModal__flex{width:60vw;}.euiCodeBlock{height:auto !important;max-width:718px;}"]);MyEuiModal.displayName="MyEuiModal";const parseInspectString=function(objectStringify){try{return JSON.parse(objectStringify)}catch{return null}};const manageStringify=object=>{try{return JSON.stringify(object,null,2)}catch{return SOMETHING_WENT_WRONG}};const formatIndexPatternRequested=(indices=[])=>{if(indices.length===1&&indices[0]===constants["Z"]){return external_kbnSharedDeps_React_default.a.createElement("i",null,NO_ALERT_INDEX_FOUND)}return indices.length>0?indices.filter(i=>i!==constants["Z"]).join(", "):SOMETHING_WENT_WRONG};const ModalInspectQuery=({closeModal:closeModal,isShowing:isShowing=false,request:request,response:response,title:title})=>{var _inspectRequest$index;if(!isShowing||request==null||response==null){return null}const inspectRequest=parseInspectString(request);const inspectResponse=parseInspectString(response);const statistics=[{title:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"index-pattern-title"},INDEX_PATTERN," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"subdued",content:INDEX_PATTERN_DESC,type:"iInCircle"})),description:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"index-pattern-description"},formatIndexPatternRequested((_inspectRequest$index=inspectRequest===null||inspectRequest===void 0?void 0:inspectRequest.index)!==null&&_inspectRequest$index!==void 0?_inspectRequest$index:[]))},{title:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"query-time-title"},QUERY_TIME," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"subdued",content:QUERY_TIME_DESC,type:"iInCircle"})),description:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"query-time-description"},inspectResponse!=null?`${external_kbnSharedDeps_ElasticNumeral_default()(inspectResponse.took).format("0,0")}ms`:SOMETHING_WENT_WRONG)},{title:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"request-timestamp-title"},REQUEST_TIMESTAMP," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"subdued",content:REQUEST_TIMESTAMP_DESC,type:"iInCircle"})),description:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"request-timestamp-description"},(new Date).toISOString())}];const tabs=[{id:"statistics",name:"Statistics",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(DescriptionListStyled,{listItems:statistics,type:"column"}))},{id:"request",name:"Request",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"js",fontSize:"m",paddingSize:"m",color:"dark",overflowHeight:300,isCopyable:true},inspectRequest!=null?manageStringify(inspectRequest.body):SOMETHING_WENT_WRONG))},{id:"response",name:"Response",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"js",fontSize:"m",paddingSize:"m",color:"dark",overflowHeight:300,isCopyable:true},response))}];return external_kbnSharedDeps_React_default.a.createElement(MyEuiModal,{onClose:closeModal,"data-test-subj":"modal-inspect-euiModal"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,INSPECT," ",title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabbedContent"],{tabs:tabs,initialSelectedTab:tabs[0],autoFocus:"selected"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:closeModal,fill:true,"data-test-subj":"modal-inspect-close"},CLOSE)))};const BUTTON_CLASS="inspectButtonComponent";const InspectButtonContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"InspectButtonContainer",componentId:"sc-19urqjc-0"})(["width:100%;display:flex;flex-grow:1;> *{max-width:100%;}.","{pointer-events:none;opacity:0;transition:opacity "," ease;}",""],BUTTON_CLASS,props=>Object(external_kbnSharedDeps_LodashFp_["getOr"])(250,"theme.eui.euiAnimSpeedNormal",props),({show:show})=>show&&Object(external_kbnSharedDeps_StyledComponents_["css"])(["&:hover .","{pointer-events:auto;opacity:1;}"],BUTTON_CLASS));InspectButtonContainer.displayName="InspectButtonContainer";InspectButtonContainer.defaultProps={show:true};const InspectButtonComponent=({compact:compact=false,inputId:inputId="global",inspect:inspect,isDisabled:isDisabled,isInspected:isInspected,loading:loading,inspectIndex:inspectIndex=0,onCloseInspect:onCloseInspect,queryId:queryId="",selectedInspectIndex:selectedInspectIndex,setIsInspected:setIsInspected,title:title=""})=>{const isShowingModal=!loading&&selectedInspectIndex===inspectIndex&&isInspected;const handleClick=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsInspected({id:queryId,inputId:inputId,isInspected:true,selectedInspectIndex:inspectIndex})},[setIsInspected,queryId,inputId,inspectIndex]);const handleCloseModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(onCloseInspect!=null){onCloseInspect()}setIsInspected({id:queryId,inputId:inputId,isInspected:false,selectedInspectIndex:inspectIndex})},[onCloseInspect,setIsInspected,queryId,inputId,inspectIndex]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,inputId==="timeline"&&!compact&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{className:BUTTON_CLASS,"aria-label":INSPECT,"data-test-subj":"inspect-empty-button",color:"text",iconSide:"left",iconType:"inspect",isDisabled:loading||isDisabled,isLoading:loading,onClick:handleClick},INSPECT),(inputId==="global"||compact)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{className:BUTTON_CLASS,"aria-label":INSPECT,"data-test-subj":"inspect-icon-button",iconSize:"m",iconType:"inspect",isDisabled:loading||isDisabled,title:INSPECT,onClick:handleClick}),external_kbnSharedDeps_React_default.a.createElement(ModalInspectQuery,{closeModal:handleCloseModal,isShowing:isShowingModal,request:inspect!=null&&inspect.dsl.length>0?inspect.dsl[inspectIndex]:null,response:inspect!=null&&inspect.response.length>0?inspect.response[inspectIndex]:null,title:title,"data-test-subj":"inspect-modal"}))};const makeMapStateToProps=()=>{const getGlobalQuery=store["inputsSelectors"].globalQueryByIdSelector();const getTimelineQuery=store["inputsSelectors"].timelineQueryByIdSelector();const mapStateToProps=(state,{inputId:inputId="global",queryId:queryId})=>{const props=inputId==="global"?getGlobalQuery(state,queryId):getTimelineQuery(state,queryId);const propsWithoutRefetch=Object(external_kbnSharedDeps_LodashFp_["omit"])("refetch",props);return propsWithoutRefetch};return mapStateToProps};const mapDispatchToProps={setIsInspected:inputs["b"].setInspectionParameter};const connector=Object(lib["connect"])(makeMapStateToProps,mapDispatchToProps);const InspectButton=connector(external_kbnSharedDeps_React_default.a.memo(InspectButtonComponent))},,,,function(module,__webpack_exports__,__webpack_require__){"use strict";var _hosts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(616);if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["FlowTarget"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["HostsKpiQueries"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["HostsQueries"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["LastEventIndexKey"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"MatrixHistogramQuery"))__webpack_require__.d(__webpack_exports__,"MatrixHistogramQuery",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["MatrixHistogramQuery"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"MatrixHistogramType"))__webpack_require__.d(__webpack_exports__,"MatrixHistogramType",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["MatrixHistogramType"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkDnsFields"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkHttpFields"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkKpiQueries"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkQueries"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkTlsFields"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["NetworkUsersFields"]}));if(__webpack_require__.o(_hosts__WEBPACK_IMPORTED_MODULE_0__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _hosts__WEBPACK_IMPORTED_MODULE_0__["TimelineEventsQueries"]}));var _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(291);if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["FlowTarget"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["HostsKpiQueries"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["HostsQueries"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["LastEventIndexKey"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"MatrixHistogramQuery"))__webpack_require__.d(__webpack_exports__,"MatrixHistogramQuery",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["MatrixHistogramQuery"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"MatrixHistogramType"))__webpack_require__.d(__webpack_exports__,"MatrixHistogramType",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["MatrixHistogramType"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkDnsFields"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkHttpFields"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkKpiQueries"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkQueries"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkTlsFields"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["NetworkUsersFields"]}));if(__webpack_require__.o(_matrix_histogram__WEBPACK_IMPORTED_MODULE_1__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _matrix_histogram__WEBPACK_IMPORTED_MODULE_1__["TimelineEventsQueries"]}));var _network__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(182);if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["FlowTarget"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["HostsKpiQueries"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["HostsQueries"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["LastEventIndexKey"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"MatrixHistogramQuery"))__webpack_require__.d(__webpack_exports__,"MatrixHistogramQuery",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["MatrixHistogramQuery"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"MatrixHistogramType"))__webpack_require__.d(__webpack_exports__,"MatrixHistogramType",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["MatrixHistogramType"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkDnsFields"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkHttpFields"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkKpiQueries"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkQueries"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkTlsFields"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["NetworkUsersFields"]}));if(__webpack_require__.o(_network__WEBPACK_IMPORTED_MODULE_2__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _network__WEBPACK_IMPORTED_MODULE_2__["TimelineEventsQueries"]}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return LoadingSpinner}));__webpack_require__.d(__webpack_exports__,"b",(function(){return CATEGORY_PANE_WIDTH}));__webpack_require__.d(__webpack_exports__,"g",(function(){return FIELD_BROWSER_WIDTH}));__webpack_require__.d(__webpack_exports__,"f",(function(){return FIELD_BROWSER_HEIGHT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return FIELDS_PANE_WIDTH}));__webpack_require__.d(__webpack_exports__,"i",(function(){return PANES_FLEX_GROUP_WIDTH}));__webpack_require__.d(__webpack_exports__,"k",(function(){return SEARCH_INPUT_WIDTH}));__webpack_require__.d(__webpack_exports__,"l",(function(){return TABLE_HEIGHT}));__webpack_require__.d(__webpack_exports__,"q",(function(){return getCategoryPaneCategoryClassName}));__webpack_require__.d(__webpack_exports__,"r",(function(){return getFieldBrowserCategoryTitleClassName}));__webpack_require__.d(__webpack_exports__,"s",(function(){return getFieldBrowserSearchInputClassName}));__webpack_require__.d(__webpack_exports__,"t",(function(){return getFieldCount}));__webpack_require__.d(__webpack_exports__,"n",(function(){return filterBrowserFieldsByFieldName}));__webpack_require__.d(__webpack_exports__,"u",(function(){return mergeBrowserFieldsWithDefaultCategory}));__webpack_require__.d(__webpack_exports__,"p",(function(){return getAlertColumnHeader}));__webpack_require__.d(__webpack_exports__,"a",(function(){return CATEGORIES_PANE_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"c",(function(){return CATEGORY_TABLE_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"d",(function(){return CLOSE_BUTTON_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"j",(function(){return RESET_FIELDS_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"m",(function(){return VIEW_ALL_BUTTON_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"w",(function(){return scrollCategoriesPane}));__webpack_require__.d(__webpack_exports__,"o",(function(){return focusSearchInput}));__webpack_require__.d(__webpack_exports__,"v",(function(){return onFieldsBrowserTabPressed}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var lodash_fp__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(134);var _common_types_timeline__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(106);var _detections_components_alerts_table_default_config__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(204);var _timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(142);const LoadingSpinner=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiLoadingSpinner"]).withConfig({displayName:"LoadingSpinner",componentId:"sc-1seln4q-0"})(["cursor:pointer;position:relative;top:3px;"]);LoadingSpinner.displayName="LoadingSpinner";const CATEGORY_PANE_WIDTH=200;const DESCRIPTION_COLUMN_WIDTH=300;const FIELD_COLUMN_WIDTH=200;const FIELD_BROWSER_WIDTH=900;const FIELD_BROWSER_HEIGHT=300;const FIELDS_PANE_WIDTH=670;const HEADER_HEIGHT=40;const PANES_FLEX_GROUP_WIDTH=CATEGORY_PANE_WIDTH+FIELDS_PANE_WIDTH+10;const SEARCH_INPUT_WIDTH=850;const TABLE_HEIGHT=260;const TYPE_COLUMN_WIDTH=50;const getCategoryPaneCategoryClassName=({categoryId:categoryId,timelineId:timelineId})=>`field-browser-category-pane-${categoryId}-${timelineId}`;const getFieldBrowserCategoryTitleClassName=({categoryId:categoryId,timelineId:timelineId})=>`field-browser-category-title-${categoryId}-${timelineId}`;const getFieldBrowserSearchInputClassName=timelineId=>`field-browser-search-input-${timelineId}`;const categoryHasFields=category=>category.fields!=null&&Object.keys(category.fields).length>0;const getFieldCount=category=>category!=null&&category.fields!=null?Object.keys(category.fields).length:0;const filterBrowserFieldsByFieldName=({browserFields:browserFields,substring:substring})=>{const trimmedSubstring=substring.trim();const filteredBrowserFields=Object.keys(browserFields).reduce((filteredCategories,categoryId)=>({...filteredCategories,[categoryId]:{...browserFields[categoryId],fields:Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["filter"])(f=>f.name!=null&&f.name.includes(trimmedSubstring),browserFields[categoryId].fields).reduce((filtered,field)=>({...filtered,[field.name]:field}),{})}}),{});const nonEmptyCategories=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["pickBy"])(category=>categoryHasFields(category),filteredBrowserFields);return nonEmptyCategories};const createVirtualCategory=({browserFields:browserFields,fieldIds:fieldIds})=>({fields:fieldIds.reduce((fields,fieldId)=>{const splitId=fieldId.split(".");return{...fields,[fieldId]:{...Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["get"])([splitId.length>1?splitId[0]:"base","fields",fieldId],browserFields),name:fieldId}}},{})});const mergeBrowserFieldsWithDefaultCategory=browserFields=>({...browserFields,[_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_6__["a"]]:createVirtualCategory({browserFields:browserFields,fieldIds:_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_6__["c"].map(header=>header.id)})});const getAlertColumnHeader=(timelineId,fieldId)=>{var _alertsHeaders$find;return timelineId===_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["e"].detectionsPage||timelineId===_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["e"].detectionsRulesDetailsPage?(_alertsHeaders$find=_detections_components_alerts_table_default_config__WEBPACK_IMPORTED_MODULE_5__["b"].find(c=>c.id===fieldId))!==null&&_alertsHeaders$find!==void 0?_alertsHeaders$find:{}:{}};const CATEGORIES_PANE_CLASS_NAME="categories-pane";const CATEGORY_TABLE_CLASS_NAME="category-table";const CLOSE_BUTTON_CLASS_NAME="close-button";const RESET_FIELDS_CLASS_NAME="reset-fields";const VIEW_ALL_BUTTON_CLASS_NAME="view-all";const categoriesPaneHasFocus=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${CATEGORIES_PANE_CLASS_NAME}`));const categoryTableHasFocus=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${CATEGORY_TABLE_CLASS_NAME}`));const closeButtonHasFocus=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${CLOSE_BUTTON_CLASS_NAME}`));const searchInputHasFocus=({containerElement:containerElement,timelineId:timelineId})=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${getFieldBrowserSearchInputClassName(timelineId)}`));const viewAllHasFocus=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${VIEW_ALL_BUTTON_CLASS_NAME}`));const scrollCategoriesPane=({containerElement:containerElement,selectedCategoryId:selectedCategoryId,timelineId:timelineId})=>{if(selectedCategoryId!==""){var _containerElement$get;const selectedCategories=(_containerElement$get=containerElement===null||containerElement===void 0?void 0:containerElement.getElementsByClassName(getCategoryPaneCategoryClassName({categoryId:selectedCategoryId,timelineId:timelineId})))!==null&&_containerElement$get!==void 0?_containerElement$get:[];if(selectedCategories.length>0){selectedCategories[0].scrollIntoView()}}};const focusCategoriesPane=({containerElement:containerElement,selectedCategoryId:selectedCategoryId,timelineId:timelineId})=>{if(selectedCategoryId!==""){var _containerElement$get2;const selectedCategories=(_containerElement$get2=containerElement===null||containerElement===void 0?void 0:containerElement.getElementsByClassName(getCategoryPaneCategoryClassName({categoryId:selectedCategoryId,timelineId:timelineId})))!==null&&_containerElement$get2!==void 0?_containerElement$get2:[];if(selectedCategories.length>0){selectedCategories[0].focus()}}};const focusCategoryTable=containerElement=>{const firstEntry=containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${CATEGORY_TABLE_CLASS_NAME} [data-colindex="1"]`);if(firstEntry!=null){firstEntry.focus()}else{Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["u"])({containerElement:containerElement,className:CATEGORY_TABLE_CLASS_NAME})}};const focusCloseButton=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["u"])({containerElement:containerElement,className:CLOSE_BUTTON_CLASS_NAME});const focusResetFieldsButton=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["u"])({containerElement:containerElement,className:RESET_FIELDS_CLASS_NAME});const focusSearchInput=({containerElement:containerElement,timelineId:timelineId})=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["u"])({containerElement:containerElement,className:getFieldBrowserSearchInputClassName(timelineId)});const focusViewAllButton=containerElement=>Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["u"])({containerElement:containerElement,className:VIEW_ALL_BUTTON_CLASS_NAME});const onCategoriesPaneFocusChanging=({containerElement:containerElement,shiftKey:shiftKey,timelineId:timelineId})=>shiftKey?focusSearchInput({containerElement:containerElement,timelineId:timelineId}):focusViewAllButton(containerElement);const onCategoryTableFocusChanging=({containerElement:containerElement,shiftKey:shiftKey})=>shiftKey?focusViewAllButton(containerElement):focusCloseButton(containerElement);const onCloseButtonFocusChanging=({containerElement:containerElement,shiftKey:shiftKey})=>shiftKey?focusCategoryTable(containerElement):focusResetFieldsButton(containerElement);const onSearchInputFocusChanging=({containerElement:containerElement,selectedCategoryId:selectedCategoryId,shiftKey:shiftKey,timelineId:timelineId})=>shiftKey?focusResetFieldsButton(containerElement):focusCategoriesPane({containerElement:containerElement,selectedCategoryId:selectedCategoryId,timelineId:timelineId});const onViewAllFocusChanging=({containerElement:containerElement,selectedCategoryId:selectedCategoryId,shiftKey:shiftKey,timelineId:timelineId})=>shiftKey?focusCategoriesPane({containerElement:containerElement,selectedCategoryId:selectedCategoryId,timelineId:timelineId}):focusCategoryTable(containerElement);const onFieldsBrowserTabPressed=({containerElement:containerElement,keyboardEvent:keyboardEvent,selectedCategoryId:selectedCategoryId,timelineId:timelineId})=>{const{shiftKey:shiftKey}=keyboardEvent;if(searchInputHasFocus({containerElement:containerElement,timelineId:timelineId})){Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["v"])(keyboardEvent);onSearchInputFocusChanging({containerElement:containerElement,selectedCategoryId:selectedCategoryId,shiftKey:shiftKey,timelineId:timelineId})}else if(categoriesPaneHasFocus(containerElement)){Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["v"])(keyboardEvent);onCategoriesPaneFocusChanging({containerElement:containerElement,shiftKey:shiftKey,timelineId:timelineId})}else if(viewAllHasFocus(containerElement)){Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["v"])(keyboardEvent);onViewAllFocusChanging({containerElement:containerElement,selectedCategoryId:selectedCategoryId,shiftKey:shiftKey,timelineId:timelineId})}else if(categoryTableHasFocus(containerElement)){Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["v"])(keyboardEvent);onCategoryTableFocusChanging({containerElement:containerElement,shiftKey:shiftKey})}else if(closeButtonHasFocus(containerElement)){Object(_common_components_accessibility_helpers__WEBPACK_IMPORTED_MODULE_3__["v"])(keyboardEvent);onCloseButtonFocusChanging({containerElement:containerElement,shiftKey:shiftKey})}}},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HeaderPage}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var react_router_dom__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(75);var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);var styled_components__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_3__);var _link_icon__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(483);var _subtitle__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(614);var _title__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(716);var _link_to__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(112);var _app_types__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(3);var _sourcerer__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(768);var _store_sourcerer_model__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(117);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const Header=styled_components__WEBPACK_IMPORTED_MODULE_3___default.a.header.attrs({className:"siemHeaderPage"}).withConfig({displayName:"Header",componentId:"fdx6r8-0"})(["",""],({border:border,theme:theme})=>Object(styled_components__WEBPACK_IMPORTED_MODULE_3__["css"])(["margin-bottom:",";",""],theme.eui.euiSizeL,border&&Object(styled_components__WEBPACK_IMPORTED_MODULE_3__["css"])(["border-bottom:",";padding-bottom:",";.euiProgress{top:",";}"],theme.eui.euiBorderThin,theme.eui.paddingSizes.l,theme.eui.paddingSizes.l)));Header.displayName="Header";const FlexItem=styled_components__WEBPACK_IMPORTED_MODULE_3___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"]).withConfig({displayName:"FlexItem",componentId:"fdx6r8-1"})(["display:block;"]);FlexItem.displayName="FlexItem";const LinkBack=styled_components__WEBPACK_IMPORTED_MODULE_3___default.a.div.attrs({className:"siemHeaderPage__linkBack"}).withConfig({displayName:"LinkBack",componentId:"fdx6r8-2"})(["",""],({theme:theme})=>Object(styled_components__WEBPACK_IMPORTED_MODULE_3__["css"])(["font-size:",";line-height:",";margin-bottom:",";"],theme.eui.euiFontSizeXS,theme.eui.euiLineHeight,theme.eui.euiSizeS));LinkBack.displayName="LinkBack";const Badge=styled_components__WEBPACK_IMPORTED_MODULE_3___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiBadge"]).withConfig({displayName:"Badge",componentId:"fdx6r8-3"})(["letter-spacing:0;"]);Badge.displayName="Badge";const HeaderPageComponent=({backOptions:backOptions,backComponent:backComponent,badgeOptions:badgeOptions,border:border,children:children,draggableArguments:draggableArguments,hideSourcerer:hideSourcerer=false,isLoading:isLoading,subtitle:subtitle,subtitle2:subtitle2,title:title,titleNode:titleNode,...rest})=>{var _backOptions$pageId,_backOptions$href2;const history=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["useHistory"])();const{formatUrl:formatUrl}=Object(_link_to__WEBPACK_IMPORTED_MODULE_7__["o"])((_backOptions$pageId=backOptions===null||backOptions===void 0?void 0:backOptions.pageId)!==null&&_backOptions$pageId!==void 0?_backOptions$pageId:_app_types__WEBPACK_IMPORTED_MODULE_8__["a"].overview);const goTo=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(ev=>{ev.preventDefault();if(backOptions){var _backOptions$href;history.push((_backOptions$href=backOptions.href)!==null&&_backOptions$href!==void 0?_backOptions$href:"")}},[backOptions,history]);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(Header,_extends({border:border},rest),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{alignItems:"center"},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(FlexItem,null,backOptions&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(LinkBack,null,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_link_icon__WEBPACK_IMPORTED_MODULE_4__["b"],{dataTestSubj:backOptions.dataTestSubj,onClick:goTo,href:formatUrl((_backOptions$href2=backOptions.href)!==null&&_backOptions$href2!==void 0?_backOptions$href2:""),iconType:"arrowLeft"},backOptions.text)),!backOptions&&backComponent&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,backComponent),titleNode||react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_title__WEBPACK_IMPORTED_MODULE_6__["a"],{draggableArguments:draggableArguments,title:title,badgeOptions:badgeOptions}),subtitle&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_subtitle__WEBPACK_IMPORTED_MODULE_5__["a"],{"data-test-subj":"header-page-subtitle",items:subtitle}),subtitle2&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_subtitle__WEBPACK_IMPORTED_MODULE_5__["a"],{"data-test-subj":"header-page-subtitle-2",items:subtitle2}),border&&isLoading&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiProgress"],{size:"xs",color:"accent"})),children&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(FlexItem,{"data-test-subj":"header-page-supplements",grow:false},children)),!hideSourcerer&&react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_sourcerer__WEBPACK_IMPORTED_MODULE_9__["a"],{scope:_store_sourcerer_model__WEBPACK_IMPORTED_MODULE_10__["SourcererScopeName"].default}))};const HeaderPage=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(HeaderPageComponent)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"A",(function(){return needsRefreshOfListData}));__webpack_require__.d(__webpack_exports__,"q",(function(){return getListResourceState}));__webpack_require__.d(__webpack_exports__,"m",(function(){return getLastLoadedListResourceState}));__webpack_require__.d(__webpack_exports__,"o",(function(){return getListItems}));__webpack_require__.d(__webpack_exports__,"h",(function(){return getCurrentLocationPageIndex}));__webpack_require__.d(__webpack_exports__,"i",(function(){return getCurrentLocationPageSize}));__webpack_require__.d(__webpack_exports__,"r",(function(){return getListTotalItemsCount}));__webpack_require__.d(__webpack_exports__,"p",(function(){return getListPagination}));__webpack_require__.d(__webpack_exports__,"g",(function(){return getCurrentLocation}));__webpack_require__.d(__webpack_exports__,"n",(function(){return getListErrorMessage}));__webpack_require__.d(__webpack_exports__,"z",(function(){return isListLoading}));__webpack_require__.d(__webpack_exports__,"w",(function(){return isDeletionDialogOpen}));__webpack_require__.d(__webpack_exports__,"x",(function(){return isDeletionInProgress}));__webpack_require__.d(__webpack_exports__,"y",(function(){return isDeletionSuccessful}));__webpack_require__.d(__webpack_exports__,"k",(function(){return getDeletionError}));__webpack_require__.d(__webpack_exports__,"l",(function(){return getDeletionSubmissionResourceState}));__webpack_require__.d(__webpack_exports__,"j",(function(){return getDeletionDialogEntry}));__webpack_require__.d(__webpack_exports__,"t",(function(){return isCreationDialogLocation}));__webpack_require__.d(__webpack_exports__,"f",(function(){return getCreationSubmissionResourceState}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getCreationDialogFormEntry}));__webpack_require__.d(__webpack_exports__,"s",(function(){return isCreationDialogFormValid}));__webpack_require__.d(__webpack_exports__,"u",(function(){return isCreationInProgress}));__webpack_require__.d(__webpack_exports__,"v",(function(){return isCreationSuccessful}));__webpack_require__.d(__webpack_exports__,"e",(function(){return getCreationError}));__webpack_require__.d(__webpack_exports__,"c",(function(){return entriesExistState}));__webpack_require__.d(__webpack_exports__,"a",(function(){return checkingIfEntriesExist}));__webpack_require__.d(__webpack_exports__,"b",(function(){return entriesExist}));__webpack_require__.d(__webpack_exports__,"B",(function(){return trustedAppsListPageActive}));var reselect__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(123);var reselect__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(reselect__WEBPACK_IMPORTED_MODULE_0__);var _common_constants__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(121);var _state__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(393);const needsRefreshOfListData=state=>{const freshDataTimestamp=state.listView.freshDataTimestamp;const currentPage=state.listView.listResourceState;const location=state.location;return Boolean(state.active)&&Object(_state__WEBPACK_IMPORTED_MODULE_2__["isOutdatedResourceState"])(currentPage,data=>data.pageIndex===location.page_index&&data.pageSize===location.page_size&&data.timestamp>=freshDataTimestamp)};const getListResourceState=state=>state.listView.listResourceState;const getLastLoadedListResourceState=state=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["getLastLoadedResourceState"])(state.listView.listResourceState);const getListItems=state=>{var _getLastLoadedResourc;return((_getLastLoadedResourc=Object(_state__WEBPACK_IMPORTED_MODULE_2__["getLastLoadedResourceState"])(state.listView.listResourceState))===null||_getLastLoadedResourc===void 0?void 0:_getLastLoadedResourc.data.items)||[]};const getCurrentLocationPageIndex=state=>state.location.page_index;const getCurrentLocationPageSize=state=>state.location.page_size;const getListTotalItemsCount=state=>{var _getLastLoadedResourc2;return((_getLastLoadedResourc2=Object(_state__WEBPACK_IMPORTED_MODULE_2__["getLastLoadedResourceState"])(state.listView.listResourceState))===null||_getLastLoadedResourc2===void 0?void 0:_getLastLoadedResourc2.data.totalItemsCount)||0};const getListPagination=state=>{const lastLoadedResourceState=Object(_state__WEBPACK_IMPORTED_MODULE_2__["getLastLoadedResourceState"])(state.listView.listResourceState);return{pageIndex:state.location.page_index,pageSize:state.location.page_size,totalItemCount:(lastLoadedResourceState===null||lastLoadedResourceState===void 0?void 0:lastLoadedResourceState.data.totalItemsCount)||0,pageSizeOptions:[..._common_constants__WEBPACK_IMPORTED_MODULE_1__["e"]]}};const getCurrentLocation=state=>state.location;const getListErrorMessage=state=>{var _getCurrentResourceEr;return(_getCurrentResourceEr=Object(_state__WEBPACK_IMPORTED_MODULE_2__["getCurrentResourceError"])(state.listView.listResourceState))===null||_getCurrentResourceEr===void 0?void 0:_getCurrentResourceEr.message};const isListLoading=state=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadingResourceState"])(state.listView.listResourceState);const isDeletionDialogOpen=state=>state.deletionDialog.entry!==undefined;const isDeletionInProgress=state=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadingResourceState"])(state.deletionDialog.submissionResourceState);const isDeletionSuccessful=state=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadedResourceState"])(state.deletionDialog.submissionResourceState);const getDeletionError=state=>{const submissionResourceState=state.deletionDialog.submissionResourceState;return Object(_state__WEBPACK_IMPORTED_MODULE_2__["isFailedResourceState"])(submissionResourceState)?submissionResourceState.error:undefined};const getDeletionSubmissionResourceState=state=>state.deletionDialog.submissionResourceState;const getDeletionDialogEntry=state=>state.deletionDialog.entry;const isCreationDialogLocation=state=>state.location.show==="create";const getCreationSubmissionResourceState=state=>state.creationDialog.submissionResourceState;const getCreationDialogFormEntry=state=>{var _state$creationDialog;return(_state$creationDialog=state.creationDialog.formState)===null||_state$creationDialog===void 0?void 0:_state$creationDialog.entry};const isCreationDialogFormValid=state=>{var _state$creationDialog2;return((_state$creationDialog2=state.creationDialog.formState)===null||_state$creationDialog2===void 0?void 0:_state$creationDialog2.isValid)||false};const isCreationInProgress=state=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadingResourceState"])(state.creationDialog.submissionResourceState);const isCreationSuccessful=state=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadedResourceState"])(state.creationDialog.submissionResourceState);const getCreationError=state=>{const submissionResourceState=state.creationDialog.submissionResourceState;return Object(_state__WEBPACK_IMPORTED_MODULE_2__["isFailedResourceState"])(submissionResourceState)?submissionResourceState.error:undefined};const entriesExistState=state=>state.entriesExist;const checkingIfEntriesExist=Object(reselect__WEBPACK_IMPORTED_MODULE_0__["createSelector"])(entriesExistState,doEntriesExists=>!Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadedResourceState"])(doEntriesExists));const entriesExist=Object(reselect__WEBPACK_IMPORTED_MODULE_0__["createSelector"])(entriesExistState,doEntriesExists=>Object(_state__WEBPACK_IMPORTED_MODULE_2__["isLoadedResourceState"])(doEntriesExists)&&doEntriesExists.data);const trustedAppsListPageActive=state=>state.active},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return actions}));__webpack_require__.d(__webpack_exports__,"b",(function(){return model}));__webpack_require__.d(__webpack_exports__,"d",(function(){return selectors_namespaceObject}));__webpack_require__.d(__webpack_exports__,"e",(function(){return initialHostsState}));__webpack_require__.d(__webpack_exports__,"c",(function(){return hostsReducer}));var selectors_namespaceObject={};__webpack_require__.r(selectors_namespaceObject);__webpack_require__.d(selectors_namespaceObject,"authenticationsSelector",(function(){return authenticationsSelector}));__webpack_require__.d(selectors_namespaceObject,"hostsSelector",(function(){return hostsSelector}));__webpack_require__.d(selectors_namespaceObject,"eventsSelector",(function(){return eventsSelector}));__webpack_require__.d(selectors_namespaceObject,"uncommonProcessesSelector",(function(){return uncommonProcessesSelector}));__webpack_require__.d(selectors_namespaceObject,"alertsSelector",(function(){return alertsSelector}));var actions=__webpack_require__(361);var model=__webpack_require__(141);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var lib=__webpack_require__(123);const selectHosts=(state,hostsType)=>Object(external_kbnSharedDeps_LodashFp_["get"])(hostsType,state.hosts);const authenticationsSelector=()=>Object(lib["createSelector"])(selectHosts,hosts=>hosts.queries.authentications);const hostsSelector=()=>Object(lib["createSelector"])(selectHosts,hosts=>hosts.queries[model["HostsTableType"].hosts]);const eventsSelector=()=>Object(lib["createSelector"])(selectHosts,hosts=>hosts.queries.events);const uncommonProcessesSelector=()=>Object(lib["createSelector"])(selectHosts,hosts=>hosts.queries.uncommonProcesses);const alertsSelector=()=>Object(lib["createSelector"])(selectHosts,hosts=>hosts.queries[model["HostsTableType"].alerts]);var dist=__webpack_require__(236);var types=__webpack_require__(133);var constants=__webpack_require__(362);const setHostPageQueriesActivePageToZero=state=>({...state.page.queries,[model["HostsTableType"].authentications]:{...state.page.queries[model["HostsTableType"].authentications],activePage:constants["a"]},[model["HostsTableType"].hosts]:{...state.page.queries[model["HostsTableType"].hosts],activePage:constants["a"]},[model["HostsTableType"].events]:{...state.page.queries[model["HostsTableType"].events],activePage:constants["a"]},[model["HostsTableType"].uncommonProcesses]:{...state.page.queries[model["HostsTableType"].uncommonProcesses],activePage:constants["a"]},[model["HostsTableType"].alerts]:{...state.page.queries[model["HostsTableType"].alerts],activePage:constants["a"]}});const setHostDetailsQueriesActivePageToZero=state=>({...state.details.queries,[model["HostsTableType"].authentications]:{...state.details.queries[model["HostsTableType"].authentications],activePage:constants["a"]},[model["HostsTableType"].hosts]:{...state.details.queries[model["HostsTableType"].hosts],activePage:constants["a"]},[model["HostsTableType"].events]:{...state.details.queries[model["HostsTableType"].events],activePage:constants["a"]},[model["HostsTableType"].uncommonProcesses]:{...state.details.queries[model["HostsTableType"].uncommonProcesses],activePage:constants["a"]},[model["HostsTableType"].alerts]:{...state.page.queries[model["HostsTableType"].alerts],activePage:constants["a"]}});const setHostsQueriesActivePageToZero=(state,type)=>{if(type===model["HostsType"].page){return setHostPageQueriesActivePageToZero(state)}else if(type===model["HostsType"].details){return setHostDetailsQueriesActivePageToZero(state)}throw new Error(`HostsType ${type} is unknown`)};const initialHostsState={page:{queries:{[model["HostsTableType"].authentications]:{activePage:constants["a"],limit:constants["b"]},[model["HostsTableType"].hosts]:{activePage:constants["a"],direction:types["a"].desc,limit:constants["b"],sortField:types["f"].lastSeen},[model["HostsTableType"].events]:{activePage:constants["a"],limit:constants["b"]},[model["HostsTableType"].uncommonProcesses]:{activePage:constants["a"],limit:constants["b"]},[model["HostsTableType"].anomalies]:null,[model["HostsTableType"].alerts]:{activePage:constants["a"],limit:constants["b"]}}},details:{queries:{[model["HostsTableType"].authentications]:{activePage:constants["a"],limit:constants["b"]},[model["HostsTableType"].hosts]:{activePage:constants["a"],direction:types["a"].desc,limit:constants["b"],sortField:types["f"].lastSeen},[model["HostsTableType"].events]:{activePage:constants["a"],limit:constants["b"]},[model["HostsTableType"].uncommonProcesses]:{activePage:constants["a"],limit:constants["b"]},[model["HostsTableType"].anomalies]:null,[model["HostsTableType"].alerts]:{activePage:constants["a"],limit:constants["b"]}}}};const hostsReducer=Object(dist["reducerWithInitialState"])(initialHostsState).case(actions["setHostTablesActivePageToZero"],state=>({...state,page:{...state.page,queries:setHostPageQueriesActivePageToZero(state)},details:{...state.details,queries:setHostDetailsQueriesActivePageToZero(state)}})).case(actions["setHostDetailsTablesActivePageToZero"],state=>({...state,details:{...state.details,queries:setHostDetailsQueriesActivePageToZero(state)}})).case(actions["updateTableActivePage"],(state,{activePage:activePage,hostsType:hostsType,tableType:tableType})=>({...state,[hostsType]:{...state[hostsType],queries:{...state[hostsType].queries,[tableType]:{...state[hostsType].queries[tableType],activePage:activePage}}}})).case(actions["updateTableLimit"],(state,{limit:limit,hostsType:hostsType,tableType:tableType})=>({...state,[hostsType]:{...state[hostsType],queries:{...state[hostsType].queries,[tableType]:{...state[hostsType].queries[tableType],limit:limit}}}})).case(actions["updateHostsSort"],(state,{sort:sort,hostsType:hostsType})=>({...state,[hostsType]:{...state[hostsType],queries:{...state[hostsType].queries,[model["HostsTableType"].hosts]:{...state[hostsType].queries[model["HostsTableType"].hosts],direction:sort.direction,sortField:sort.field}}}})).build()},,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return buildAlertStatusFilter}));__webpack_require__.d(__webpack_exports__,"d",(function(){return buildAlertsRuleIdFilter}));__webpack_require__.d(__webpack_exports__,"e",(function(){return buildShowBuildingBlockFilter}));__webpack_require__.d(__webpack_exports__,"b",(function(){return alertsHeaders}));__webpack_require__.d(__webpack_exports__,"a",(function(){return alertsDefaultModel}));__webpack_require__.d(__webpack_exports__,"f",(function(){return requiredFieldsForActions}));var _common_types_timeline__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(106);var _timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(142);var _timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(192);var _timelines_store_timeline_defaults__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(118);var _translations__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(263);const buildAlertStatusFilter=status=>[{meta:{alias:null,negate:false,disabled:false,type:"phrase",key:"signal.status",params:{query:status}},query:{term:{"signal.status":status}}}];const buildAlertsRuleIdFilter=ruleId=>[{meta:{alias:null,negate:false,disabled:false,type:"phrase",key:"signal.rule.id",params:{query:ruleId}},query:{match_phrase:{"signal.rule.id":ruleId}}}];const buildShowBuildingBlockFilter=showBuildingBlockAlerts=>[...showBuildingBlockAlerts?[]:[{meta:{alias:null,negate:true,disabled:false,type:"exists",key:"signal.rule.building_block_type",value:"exists"},exists:{field:"signal.rule.building_block_type"}}]];const alertsHeaders=[{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"@timestamp",width:_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__["c"]+5},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"signal.rule.name",label:_translations__WEBPACK_IMPORTED_MODULE_4__["k"],linkField:"signal.rule.id",width:_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__["b"]},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"signal.rule.version",label:_translations__WEBPACK_IMPORTED_MODULE_4__["p"],width:95},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"signal.rule.type",label:_translations__WEBPACK_IMPORTED_MODULE_4__["i"],width:100},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"signal.rule.severity",label:_translations__WEBPACK_IMPORTED_MODULE_4__["l"],width:105},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"signal.rule.risk_score",label:_translations__WEBPACK_IMPORTED_MODULE_4__["j"],width:115},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"event.module",linkField:"rule.reference",width:_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__["b"]},{category:"event",columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"event.action",type:"string",aggregatable:true,width:140},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"event.category",width:150},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"host.name",width:120},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"user.name",width:120},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"source.ip",width:120},{columnHeaderType:_timelines_components_timeline_body_column_headers_default_headers__WEBPACK_IMPORTED_MODULE_1__["b"],id:"destination.ip",width:140}];const alertsDefaultModel={..._timelines_store_timeline_defaults__WEBPACK_IMPORTED_MODULE_3__["a"],columns:alertsHeaders,showCheckboxes:true,excludedRowRendererIds:Object.values(_common_types_timeline__WEBPACK_IMPORTED_MODULE_0__["b"])};const requiredFieldsForActions=["@timestamp","signal.status","signal.group.id","signal.original_time","signal.rule.building_block_type","signal.rule.filters","signal.rule.from","signal.rule.language","signal.rule.query","signal.rule.name","signal.rule.to","signal.rule.id","signal.rule.index","signal.rule.type","signal.original_event.kind","signal.original_event.module","file.path","file.Ext.code_signature.subject_name","file.Ext.code_signature.trusted","file.hash.sha256","host.os.family","event.code"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Panel}));var styled_components__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__);const Panel=styled_components__WEBPACK_IMPORTED_MODULE_0___default()(({loading:loading,...props})=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_2__["EuiPanel"],props)).withConfig({displayName:"Panel",componentId:"sc-1bcf9ex-0"})(["position:relative;",""],({loading:loading})=>loading&&`\n    overflow: hidden;\n  `);Panel.displayName="Panel"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return generateTablePaginationOptions}));const generateTablePaginationOptions=(activePage,limit,isBucketSort)=>{const cursorStart=activePage*limit;return{activePage:activePage,cursorStart:cursorStart,fakePossibleCount:4<=activePage&&activePage>0?limit*(activePage+2):limit*5,querySize:isBucketSort?limit:limit+cursorStart}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return CATEGORY}));__webpack_require__.d(__webpack_exports__,"a",(function(){return CATEGORIES}));__webpack_require__.d(__webpack_exports__,"b",(function(){return CATEGORIES_COUNT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return CATEGORY_LINK}));__webpack_require__.d(__webpack_exports__,"d",(function(){return CATEGORY_FIELDS_TABLE_CAPTION}));__webpack_require__.d(__webpack_exports__,"f",(function(){return CLOSE}));__webpack_require__.d(__webpack_exports__,"g",(function(){return CUSTOMIZE_COLUMNS}));__webpack_require__.d(__webpack_exports__,"h",(function(){return DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"i",(function(){return DESCRIPTION_FOR_FIELD}));__webpack_require__.d(__webpack_exports__,"j",(function(){return FIELD}));__webpack_require__.d(__webpack_exports__,"k",(function(){return FIELDS}));__webpack_require__.d(__webpack_exports__,"l",(function(){return FIELDS_COUNT}));__webpack_require__.d(__webpack_exports__,"m",(function(){return FILTER_PLACEHOLDER}));__webpack_require__.d(__webpack_exports__,"n",(function(){return NO_FIELDS_MATCH}));__webpack_require__.d(__webpack_exports__,"o",(function(){return NO_FIELDS_MATCH_INPUT}));__webpack_require__.d(__webpack_exports__,"p",(function(){return RESET_FIELDS}));__webpack_require__.d(__webpack_exports__,"q",(function(){return VIEW_ALL_CATEGORY_FIELDS}));__webpack_require__.d(__webpack_exports__,"s",(function(){return YOU_ARE_IN_A_POPOVER}));__webpack_require__.d(__webpack_exports__,"r",(function(){return VIEW_COLUMN}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const CATEGORY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.categoryLabel",{defaultMessage:"Category"});const CATEGORIES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.categoriesTitle",{defaultMessage:"Categories"});const CATEGORIES_COUNT=totalCount=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.categoriesCountTitle",{values:{totalCount:totalCount},defaultMessage:"{totalCount} {totalCount, plural, =1 {category} other {categories}}"});const CATEGORY_LINK=({category:category,totalCount:totalCount})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.categoryLinkAriaLabel",{values:{category:category,totalCount:totalCount},defaultMessage:"{category} {totalCount} {totalCount, plural, =1 {field} other {fields}}. Click this button to select the {category} category."});const CATEGORY_FIELDS_TABLE_CAPTION=categoryId=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.categoryFieldsTableCaption",{defaultMessage:"category {categoryId} fields",values:{categoryId:categoryId}});const COPY_TO_CLIPBOARD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.copyToClipboard",{defaultMessage:"Copy to Clipboard"});const CLOSE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.closeButton",{defaultMessage:"Close"});const CUSTOMIZE_COLUMNS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.customizeColumnsTitle",{defaultMessage:"Customize Columns"});const DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.descriptionLabel",{defaultMessage:"Description"});const DESCRIPTION_FOR_FIELD=field=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.descriptionForScreenReaderOnly",{values:{field:field},defaultMessage:"Description for field {field}:"});const FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.fieldLabel",{defaultMessage:"Field"});const FIELDS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.fieldsTitle",{defaultMessage:"Columns"});const FIELDS_COUNT=totalCount=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.fieldsCountTitle",{values:{totalCount:totalCount},defaultMessage:"{totalCount} {totalCount, plural, =1 {field} other {fields}}"});const FILTER_PLACEHOLDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.filterPlaceholder",{defaultMessage:"Field name"});const NO_FIELDS_MATCH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.noFieldsMatchLabel",{defaultMessage:"No fields match"});const NO_FIELDS_MATCH_INPUT=searchInput=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.noFieldsMatchInputLabel",{defaultMessage:"No fields match {searchInput}",values:{searchInput:searchInput}});const RESET_FIELDS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.resetFieldsLink",{defaultMessage:"Reset Fields"});const VIEW_ALL_CATEGORY_FIELDS=categoryId=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.viewCategoryTooltip",{defaultMessage:"View all {categoryId} fields",values:{categoryId:categoryId}});const YOU_ARE_IN_A_POPOVER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.youAreInAPopoverScreenReaderOnly",{defaultMessage:"You are in the Customize Columns popup. To exit this popup, press Escape."});const VIEW_COLUMN=field=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.fieldBrowser.viewColumnCheckboxAriaLabel",{values:{field:field},defaultMessage:"View {field} column"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"l",(function(){return getExceptionOperatorSelect}));__webpack_require__.d(__webpack_exports__,"k",(function(){return getEntryValue}));__webpack_require__.d(__webpack_exports__,"j",(function(){return formatOperatingSystems}));__webpack_require__.d(__webpack_exports__,"m",(function(){return getFormattedComments}));__webpack_require__.d(__webpack_exports__,"n",(function(){return getNewExceptionItem}));__webpack_require__.d(__webpack_exports__,"h",(function(){return filterExceptionItems}));__webpack_require__.d(__webpack_exports__,"i",(function(){return formatExceptionItemForUpdate}));__webpack_require__.d(__webpack_exports__,"p",(function(){return prepareExceptionItemsForBulkClose}));__webpack_require__.d(__webpack_exports__,"e",(function(){return enrichNewExceptionItemsWithComments}));__webpack_require__.d(__webpack_exports__,"a",(function(){return buildGetAlertByIdQuery}));__webpack_require__.d(__webpack_exports__,"d",(function(){return enrichExistingExceptionItemWithComments}));__webpack_require__.d(__webpack_exports__,"c",(function(){return enrichExceptionItemsWithOS}));__webpack_require__.d(__webpack_exports__,"q",(function(){return retrieveAlertOsTypes}));__webpack_require__.d(__webpack_exports__,"o",(function(){return lowercaseHashValues}));__webpack_require__.d(__webpack_exports__,"f",(function(){return entryHasListType}));__webpack_require__.d(__webpack_exports__,"g",(function(){return entryHasNonEcsType}));__webpack_require__.d(__webpack_exports__,"b",(function(){return defaultEndpointExceptionItems}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var lodash__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(19);var lodash__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_2__);var moment__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(27);var moment__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_3__);var uuid__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(20);var uuid__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(uuid__WEBPACK_IMPORTED_MODULE_4__);var _translations__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(160);var _autocomplete_operators__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(374);var _shared_imports__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(110);var _common_validate__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(34);var _lib_clipboard_with_copy_to_clipboard__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(610);var _common__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(61);const addIdToEntries=entries=>entries.map(singleEntry=>{if(singleEntry.type==="nested"){return Object(_common__WEBPACK_IMPORTED_MODULE_10__["addIdToItem"])({...singleEntry,entries:singleEntry.entries.map(nestedEntry=>Object(_common__WEBPACK_IMPORTED_MODULE_10__["addIdToItem"])(nestedEntry))})}else{return Object(_common__WEBPACK_IMPORTED_MODULE_10__["addIdToItem"])(singleEntry)}});const getOperatorType=item=>{switch(item.type){case"match":return _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].MATCH;case"match_any":return _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].MATCH_ANY;case"list":return _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].LIST;default:return _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].EXISTS}};const getExceptionOperatorSelect=item=>{if(item.type==="nested"){return _autocomplete_operators__WEBPACK_IMPORTED_MODULE_6__["h"]}else{const operatorType=getOperatorType(item);const foundOperator=_autocomplete_operators__WEBPACK_IMPORTED_MODULE_6__["a"].find(operatorOption=>item.operator===operatorOption.operator&&operatorType===operatorOption.type);return foundOperator!==null&&foundOperator!==void 0?foundOperator:_autocomplete_operators__WEBPACK_IMPORTED_MODULE_6__["h"]}};const getEntryValue=item=>{switch(item.type){case _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].MATCH:case _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].MATCH_ANY:return item.value;case _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].EXISTS:return undefined;case _shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].LIST:return item.list.id;default:return undefined}};const formatOperatingSystems=osTypes=>osTypes.filter(os=>["linux","macos","windows"].includes(os)).map(os=>{if(os==="macos"){return"macOS"}return Object(lodash__WEBPACK_IMPORTED_MODULE_2__["capitalize"])(os)}).join(", ");const getFormattedComments=comments=>comments.map(commentItem=>({username:commentItem.created_by,timestamp:moment__WEBPACK_IMPORTED_MODULE_3___default()(commentItem.created_at).format("on MMM Do YYYY @ HH:mm:ss"),event:_translations__WEBPACK_IMPORTED_MODULE_5__["m"],timelineIcon:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiAvatar"],{size:"l",name:commentItem.created_by.toUpperCase()}),children:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiText"],{size:"s"},commentItem.comment),actions:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_lib_clipboard_with_copy_to_clipboard__WEBPACK_IMPORTED_MODULE_9__["a"],{"data-test-subj":"copy-to-clipboard",text:commentItem.comment,titleSummary:_translations__WEBPACK_IMPORTED_MODULE_5__["e"]})}));const getNewExceptionItem=({listId:listId,namespaceType:namespaceType,ruleName:ruleName})=>({comments:[],description:`${ruleName} - exception list item`,entries:addIdToEntries([{field:"",operator:"included",type:"match",value:""}]),item_id:undefined,list_id:listId,meta:{temporaryUuid:uuid__WEBPACK_IMPORTED_MODULE_4___default.a.v4()},name:`${ruleName} - exception list item`,namespace_type:namespaceType,tags:[],type:"simple"});const filterExceptionItems=exceptions=>exceptions.reduce((acc,exception)=>{const entries=exception.entries.reduce((nestedAcc,singleEntry)=>{const strippedSingleEntry=Object(_common__WEBPACK_IMPORTED_MODULE_10__["removeIdFromItem"])(singleEntry);if(_shared_imports__WEBPACK_IMPORTED_MODULE_7__["q"].is(strippedSingleEntry)){const nestedEntriesArray=strippedSingleEntry.entries.filter(singleNestedEntry=>{const noIdSingleNestedEntry=Object(_common__WEBPACK_IMPORTED_MODULE_10__["removeIdFromItem"])(singleNestedEntry);const[validatedNestedEntry]=Object(_common_validate__WEBPACK_IMPORTED_MODULE_8__["a"])(noIdSingleNestedEntry,_shared_imports__WEBPACK_IMPORTED_MODULE_7__["y"]);return validatedNestedEntry!=null});const noIdNestedEntries=nestedEntriesArray.map(singleNestedEntry=>Object(_common__WEBPACK_IMPORTED_MODULE_10__["removeIdFromItem"])(singleNestedEntry));const[validatedNestedEntry]=Object(_common_validate__WEBPACK_IMPORTED_MODULE_8__["a"])({...strippedSingleEntry,entries:noIdNestedEntries},_shared_imports__WEBPACK_IMPORTED_MODULE_7__["q"]);if(validatedNestedEntry!=null){return[...nestedAcc,{...singleEntry,entries:nestedEntriesArray}]}return nestedAcc}else{const[validatedEntry]=Object(_common_validate__WEBPACK_IMPORTED_MODULE_8__["a"])(strippedSingleEntry,_shared_imports__WEBPACK_IMPORTED_MODULE_7__["r"]);if(validatedEntry!=null){return[...nestedAcc,singleEntry]}return nestedAcc}},[]);const item={...exception,entries:entries};if(_shared_imports__WEBPACK_IMPORTED_MODULE_7__["s"].is(item)){return[...acc,item]}else if(_shared_imports__WEBPACK_IMPORTED_MODULE_7__["o"].is(item)){const{meta:meta,...rest}=item;const itemSansMetaId={...rest,meta:undefined};return[...acc,itemSansMetaId]}else{return acc}},[]);const formatExceptionItemForUpdate=exceptionItem=>{const{created_at:created_at,created_by:created_by,list_id:list_id,tie_breaker_id:tie_breaker_id,updated_at:updated_at,updated_by:updated_by,...fieldsToUpdate}=exceptionItem;return{...fieldsToUpdate}};const prepareExceptionItemsForBulkClose=exceptionItems=>exceptionItems.map(item=>{if(item.entries!==undefined){const newEntries=item.entries.map(itemEntry=>({...itemEntry,field:itemEntry.field.startsWith("event.")?itemEntry.field.replace(/^event./,"signal.original_event."):itemEntry.field}));return{...item,entries:newEntries}}else{return item}});const enrichNewExceptionItemsWithComments=(exceptionItems,comments)=>exceptionItems.map(item=>({...item,comments:comments}));const buildGetAlertByIdQuery=id=>({query:{match:{_id:{query:id||""}}}});const enrichExistingExceptionItemWithComments=(exceptionItem,comments)=>{const formattedComments=comments.map(item=>{if(_shared_imports__WEBPACK_IMPORTED_MODULE_7__["n"].is(item)){const{id:id,comment:existingComment}=item;return{id:id,comment:existingComment}}else{return{comment:item.comment}}});return{...exceptionItem,comments:formattedComments}};const enrichExceptionItemsWithOS=(exceptionItems,osTypes)=>exceptionItems.map(item=>({...item,os_types:osTypes}));const retrieveAlertOsTypes=alertData=>{const osDefaults=["windows","macos"];if(alertData!=null){const os=alertData.host&&alertData.host.os&&alertData.host.os.family;if(os!=null){return _shared_imports__WEBPACK_IMPORTED_MODULE_7__["z"].is(os)?[os]:osDefaults}}return osDefaults};const lowercaseHashValues=exceptionItems=>exceptionItems.map(item=>{const newEntries=item.entries.map(itemEntry=>{if(itemEntry.field.includes(".hash")){if(itemEntry.type==="match"){return{...itemEntry,value:itemEntry.value.toLowerCase()}}else if(itemEntry.type==="match_any"){return{...itemEntry,value:itemEntry.value.map(val=>val.toLowerCase())}}}return itemEntry});return{...item,entries:newEntries}});const entryHasListType=exceptionItems=>{for(const{entries:entries}of exceptionItems){for(const exceptionEntry of entries!==null&&entries!==void 0?entries:[]){if(getOperatorType(exceptionEntry)===_shared_imports__WEBPACK_IMPORTED_MODULE_7__["h"].LIST){return true}}}return false};const getFileCodeSignature=alertData=>{const{file:file}=alertData;const codeSignature=file&&file.Ext&&file.Ext.code_signature;return getCodeSignatureValue(codeSignature)};const getProcessCodeSignature=alertData=>{const{process:process}=alertData;const codeSignature=process&&process.Ext&&process.Ext.code_signature;return getCodeSignatureValue(codeSignature)};const getCodeSignatureValue=codeSignature=>{if(Array.isArray(codeSignature)&&codeSignature.length>0){return codeSignature.map(signature=>{var _signature$subject_na,_signature$trusted$to;return{subjectName:(_signature$subject_na=signature.subject_name)!==null&&_signature$subject_na!==void 0?_signature$subject_na:"",trusted:(_signature$trusted$to=signature.trusted.toString())!==null&&_signature$trusted$to!==void 0?_signature$trusted$to:""}})}else{var _signature$subject_na2,_signature$trusted;const signature=!Array.isArray(codeSignature)?codeSignature:undefined;return[{subjectName:(_signature$subject_na2=signature===null||signature===void 0?void 0:signature.subject_name)!==null&&_signature$subject_na2!==void 0?_signature$subject_na2:"",trusted:(_signature$trusted=signature===null||signature===void 0?void 0:signature.trusted)!==null&&_signature$trusted!==void 0?_signature$trusted:""}]}};const getPrepopulatedEndpointException=({listId:listId,ruleName:ruleName,codeSignature:codeSignature,eventCode:eventCode,listNamespace:listNamespace="agnostic",alertEcsData:alertEcsData})=>{var _file$path,_file$hash$sha,_file$hash;const{file:file}=alertEcsData;const filePath=(_file$path=file===null||file===void 0?void 0:file.path)!==null&&_file$path!==void 0?_file$path:"";const sha256Hash=(_file$hash$sha=file===null||file===void 0?void 0:(_file$hash=file.hash)===null||_file$hash===void 0?void 0:_file$hash.sha256)!==null&&_file$hash$sha!==void 0?_file$hash$sha:"";return{...getNewExceptionItem({listId:listId,namespaceType:listNamespace,ruleName:ruleName}),entries:addIdToEntries([{field:"file.Ext.code_signature",type:"nested",entries:[{field:"subject_name",operator:"included",type:"match",value:codeSignature!=null?codeSignature.subjectName:""},{field:"trusted",operator:"included",type:"match",value:codeSignature!=null?codeSignature.trusted:""}]},{field:"file.path.caseless",operator:"included",type:"match",value:filePath!==null&&filePath!==void 0?filePath:""},{field:"file.hash.sha256",operator:"included",type:"match",value:sha256Hash!==null&&sha256Hash!==void 0?sha256Hash:""},{field:"event.code",operator:"included",type:"match",value:eventCode!==null&&eventCode!==void 0?eventCode:""}])}};const getPrepopulatedRansomwareException=({listId:listId,ruleName:ruleName,codeSignature:codeSignature,eventCode:eventCode,listNamespace:listNamespace="agnostic",alertEcsData:alertEcsData})=>{var _process$hash$sha,_process$hash,_process$executable,_Ransomware$feature;const{process:process,Ransomware:Ransomware}=alertEcsData;const sha256Hash=(_process$hash$sha=process===null||process===void 0?void 0:(_process$hash=process.hash)===null||_process$hash===void 0?void 0:_process$hash.sha256)!==null&&_process$hash$sha!==void 0?_process$hash$sha:"";const executable=(_process$executable=process===null||process===void 0?void 0:process.executable)!==null&&_process$executable!==void 0?_process$executable:"";const ransomwareFeature=(_Ransomware$feature=Ransomware===null||Ransomware===void 0?void 0:Ransomware.feature)!==null&&_Ransomware$feature!==void 0?_Ransomware$feature:"";return{...getNewExceptionItem({listId:listId,namespaceType:listNamespace,ruleName:ruleName}),entries:addIdToEntries([{field:"process.Ext.code_signature",type:"nested",entries:[{field:"subject_name",operator:"included",type:"match",value:codeSignature!=null?codeSignature.subjectName:""},{field:"trusted",operator:"included",type:"match",value:codeSignature!=null?codeSignature.trusted:""}]},{field:"process.executable",operator:"included",type:"match",value:executable!==null&&executable!==void 0?executable:""},{field:"process.hash.sha256",operator:"included",type:"match",value:sha256Hash!==null&&sha256Hash!==void 0?sha256Hash:""},{field:"Ransomware.feature",operator:"included",type:"match",value:ransomwareFeature!==null&&ransomwareFeature!==void 0?ransomwareFeature:""},{field:"event.code",operator:"included",type:"match",value:eventCode!==null&&eventCode!==void 0?eventCode:""}])}};const entryHasNonEcsType=(exceptionItems,indexPatterns)=>{const doesFieldNameExist=exceptionEntry=>indexPatterns.fields.some(({name:name})=>name===exceptionEntry.field);if(exceptionItems.length===0){return false}for(const{entries:entries}of exceptionItems){for(const exceptionEntry of entries!==null&&entries!==void 0?entries:[]){if(exceptionEntry.type==="nested"){for(const nestedExceptionEntry of exceptionEntry.entries){if(doesFieldNameExist(nestedExceptionEntry)===false){return true}}}else if(doesFieldNameExist(exceptionEntry)===false){return true}}}return false};const defaultEndpointExceptionItems=(listId,ruleName,alertEcsData)=>{var _alertEvent$code;const{event:alertEvent}=alertEcsData;const eventCode=(_alertEvent$code=alertEvent===null||alertEvent===void 0?void 0:alertEvent.code)!==null&&_alertEvent$code!==void 0?_alertEvent$code:"";if(eventCode==="ransomware"){return getProcessCodeSignature(alertEcsData).map(codeSignature=>getPrepopulatedRansomwareException({listId:listId,ruleName:ruleName,eventCode:eventCode,codeSignature:codeSignature,alertEcsData:alertEcsData}))}return getFileCodeSignature(alertEcsData).map(codeSignature=>getPrepopulatedEndpointException({listId:listId,ruleName:ruleName,eventCode:eventCode,codeSignature:codeSignature,alertEcsData:alertEcsData}))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return RULE_AND_TIMELINE_FETCH_FAILURE}));__webpack_require__.d(__webpack_exports__,"g",(function(){return RULE_ADD_FAILURE}));__webpack_require__.d(__webpack_exports__,"i",(function(){return RULE_AND_TIMELINE_PREPACKAGED_FAILURE}));__webpack_require__.d(__webpack_exports__,"j",(function(){return RULE_AND_TIMELINE_PREPACKAGED_SUCCESS}));__webpack_require__.d(__webpack_exports__,"k",(function(){return RULE_PREPACKAGED_SUCCESS}));__webpack_require__.d(__webpack_exports__,"m",(function(){return TIMELINE_PREPACKAGED_SUCCESS}));__webpack_require__.d(__webpack_exports__,"l",(function(){return TAG_FETCH_FAILURE}));__webpack_require__.d(__webpack_exports__,"a",(function(){return LOAD_PREPACKAGED_RULES}));__webpack_require__.d(__webpack_exports__,"c",(function(){return LOAD_PREPACKAGED_TIMELINE_TEMPLATES}));__webpack_require__.d(__webpack_exports__,"b",(function(){return LOAD_PREPACKAGED_RULES_AND_TEMPLATES}));__webpack_require__.d(__webpack_exports__,"d",(function(){return RELOAD_MISSING_PREPACKAGED_RULES}));__webpack_require__.d(__webpack_exports__,"f",(function(){return RELOAD_MISSING_PREPACKAGED_TIMELINES}));__webpack_require__.d(__webpack_exports__,"e",(function(){return RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const RULE_AND_TIMELINE_FETCH_FAILURE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.rulesAndTimelines",{defaultMessage:"Failed to fetch Rules and Timelines"});const RULE_ADD_FAILURE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.addRuleFailDescription",{defaultMessage:"Failed to add Rule"});const RULE_AND_TIMELINE_PREPACKAGED_FAILURE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.createPrePackagedRuleAndTimelineFailDescription",{defaultMessage:"Failed to installed pre-packaged rules and timelines from elastic"});const RULE_AND_TIMELINE_PREPACKAGED_SUCCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.createPrePackagedRuleAndTimelineSuccesDescription",{defaultMessage:"Installed pre-packaged rules and timeline templates from elastic"});const RULE_PREPACKAGED_SUCCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.createPrePackagedRuleSuccesDescription",{defaultMessage:"Installed pre-packaged rules from elastic"});const TIMELINE_PREPACKAGED_SUCCESS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.createPrePackagedTimelineSuccesDescription",{defaultMessage:"Installed pre-packaged timeline templates from elastic"});const TAG_FETCH_FAILURE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.containers.detectionEngine.tagFetchFailDescription",{defaultMessage:"Failed to fetch Tags"});const LOAD_PREPACKAGED_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.loadPrePackagedRulesButton",{defaultMessage:"Load Elastic prebuilt rules"});const LOAD_PREPACKAGED_TIMELINE_TEMPLATES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.loadPrePackagedTimelineTemplatesButton",{defaultMessage:"Load Elastic prebuilt timeline templates"});const LOAD_PREPACKAGED_RULES_AND_TEMPLATES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.loadPrePackagedRulesAndTemplatesButton",{defaultMessage:"Load Elastic prebuilt rules and timeline templates"});const RELOAD_MISSING_PREPACKAGED_RULES=missingRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedRulesButton",{values:{missingRules:missingRules},defaultMessage:"Install {missingRules} Elastic prebuilt {missingRules, plural, =1 {rule} other {rules}} "});const RELOAD_MISSING_PREPACKAGED_TIMELINES=missingTimelines=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedTimelinesButton",{values:{missingTimelines:missingTimelines},defaultMessage:"Install {missingTimelines} Elastic prebuilt {missingTimelines, plural, =1 {timeline} other {timelines}} "});const RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES=(missingRules,missingTimelines)=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedRulesAndTimelinesButton",{values:{missingRules:missingRules,missingTimelines:missingTimelines},defaultMessage:"Install {missingRules} Elastic prebuilt {missingRules, plural, =1 {rule} other {rules}} and {missingTimelines} Elastic prebuilt {missingTimelines, plural, =1 {timeline} other {timelines}} "})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return hasMlUserPermissions}));const hasMlUserPermissions=capabilities=>capabilities.capabilities.canGetJobs&&capabilities.capabilities.canGetDatafeeds&&capabilities.capabilities.canGetCalendars},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return OverviewEmpty}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var lodash_fp__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(74);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__);var _common_translations__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(376);var _common_components_empty_page__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(382);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(104);var _common_constants__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(2);var _management_pages_endpoint_hosts_view_hooks__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(274);var _common_hooks_endpoint_use_navigate_to_app_event_handler__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(212);var _common_hooks_endpoint_ingest_enabled__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(383);const OverviewEmptyComponent=()=>{const{http:http,docLinks:docLinks}=Object(_common_lib_kibana__WEBPACK_IMPORTED_MODULE_6__["h"])().services;const basePath=http.basePath.get();const{appId:ingestAppId,appPath:ingestPath,url:ingestUrl}=Object(_management_pages_endpoint_hosts_view_hooks__WEBPACK_IMPORTED_MODULE_8__["c"])("integrations?category=security");const handleOnClick=Object(_common_hooks_endpoint_use_navigate_to_app_event_handler__WEBPACK_IMPORTED_MODULE_9__["a"])(ingestAppId,{path:ingestPath});const{allEnabled:isIngestEnabled}=Object(_common_hooks_endpoint_ingest_enabled__WEBPACK_IMPORTED_MODULE_10__["a"])();const emptyPageActions=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({elasticAgent:{label:_common_translations__WEBPACK_IMPORTED_MODULE_4__["c"],url:ingestUrl,description:_common_translations__WEBPACK_IMPORTED_MODULE_4__["d"],fill:false},beats:{label:_common_translations__WEBPACK_IMPORTED_MODULE_4__["a"],url:`${basePath}${_common_constants__WEBPACK_IMPORTED_MODULE_7__["a"]}`,description:_common_translations__WEBPACK_IMPORTED_MODULE_4__["b"],fill:false},endpoint:{label:_common_translations__WEBPACK_IMPORTED_MODULE_4__["e"],url:`${basePath}${_common_constants__WEBPACK_IMPORTED_MODULE_7__["a"]}`,description:_common_translations__WEBPACK_IMPORTED_MODULE_4__["f"],onClick:handleOnClick,fill:false}}),[basePath,ingestUrl,handleOnClick]);const emptyPageIngestDisabledActions=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["omit"])(["elasticAgent","endpoint"],emptyPageActions),[emptyPageActions]);return isIngestEnabled===true?react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_components_empty_page__WEBPACK_IMPORTED_MODULE_5__["a"],{actions:emptyPageActions,"data-test-subj":"empty-page",message:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__["FormattedMessage"],{id:"xpack.securitySolution.emptyMessage",defaultMessage:"Elastic Security integrates the free and open Elastic SIEM with Endpoint Security to prevent, detect, and respond to threats. To begin, you’ll need to add security solution related data to the Elastic Stack. For additional information, you can view our "}),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiLink"],{href:docLinks.links.siem.gettingStarted,target:"_blank"},_common_translations__WEBPACK_IMPORTED_MODULE_4__["g"])),title:_common_translations__WEBPACK_IMPORTED_MODULE_4__["h"]}):react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_components_empty_page__WEBPACK_IMPORTED_MODULE_5__["a"],{actions:emptyPageIngestDisabledActions,"data-test-subj":"empty-page",message:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__["FormattedMessage"],{id:"xpack.securitySolution.emptyMessage",defaultMessage:"Elastic Security integrates the free and open Elastic SIEM with Endpoint Security to prevent, detect, and respond to threats. To begin, you’ll need to add security solution related data to the Elastic Stack. For additional information, you can view our "}),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiLink"],{href:docLinks.links.siem.gettingStarted,target:"_blank"},_common_translations__WEBPACK_IMPORTED_MODULE_4__["g"])),title:_common_translations__WEBPACK_IMPORTED_MODULE_4__["h"]})};OverviewEmptyComponent.displayName="OverviewEmptyComponent";const OverviewEmpty=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(OverviewEmptyComponent)},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return isJobStarted}));__webpack_require__.d(__webpack_exports__,"b",(function(){return isJobLoading}));__webpack_require__.d(__webpack_exports__,"a",(function(){return isJobFailed}));__webpack_require__.d(__webpack_exports__,"d",(function(){return isMlRule}));const enabledStates=["started","opened"];const loadingStates=["starting","stopping","opening","closing"];const failureStates=["deleted","failed"];const isJobStarted=(jobState,datafeedState)=>enabledStates.includes(jobState)&&enabledStates.includes(datafeedState);const isJobLoading=(jobState,datafeedState)=>loadingStates.includes(jobState)||loadingStates.includes(datafeedState);const isJobFailed=(jobState,datafeedState)=>failureStates.includes(jobState)||failureStates.includes(datafeedState);const isMlRule=ruleType=>ruleType==="machine_learning"},,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return PaginatedTable}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var constants=__webpack_require__(2);var header_section=__webpack_require__(146);var loader=__webpack_require__(170);var toasters=__webpack_require__(111);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const SHOWING=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.paginatedTable.showingSubtitle",{defaultMessage:"Showing"});const ROWS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.paginatedTable.rowsButtonLabel",{defaultMessage:"Rows per page"});const TOAST_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.paginatedTable.tooManyResultsToastTitle",{defaultMessage:" - too many results"});const TOAST_TEXT=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.paginatedTable.tooManyResultsToastText",{defaultMessage:"Narrow your query to better filter the results"});var panel=__webpack_require__(205);var inspect=__webpack_require__(189);const DEFAULT_DATA_TEST_SUBJ="paginated-table";const PaginatedTableComponent=({activePage:activePage,columns:columns,dataTestSubj:dataTestSubj=DEFAULT_DATA_TEST_SUBJ,headerCount:headerCount,headerSupplement:headerSupplement,headerTitle:headerTitle,headerTooltip:headerTooltip,headerUnit:headerUnit,id:id,isInspect:isInspect,itemsPerRow:itemsPerRow,limit:limit,loading:loading,loadPage:loadPage,onChange:onChange=external_kbnSharedDeps_LodashFp_["noop"],pageOfItems:pageOfItems,showMorePagesIndicator:showMorePagesIndicator,sorting:sorting=null,totalCount:totalCount,updateActivePage:updateActivePage,updateLimitPagination:updateLimitPagination})=>{const[myLoading,setMyLoading]=Object(external_kbnSharedDeps_React_["useState"])(loading);const[myActivePage,setActivePage]=Object(external_kbnSharedDeps_React_["useState"])(activePage);const[loadingInitial,setLoadingInitial]=Object(external_kbnSharedDeps_React_["useState"])(headerCount===-1);const[isPopoverOpen,setPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const pageCount=Math.ceil(totalCount/limit);const dispatchToaster=Object(toasters["h"])()[1];Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setActivePage(activePage)},[activePage]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(headerCount>=0&&loadingInitial){setLoadingInitial(false)}},[loadingInitial,headerCount]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setMyLoading(loading)},[loading]);const onButtonClick=()=>{setPopoverOpen(!isPopoverOpen)};const closePopover=()=>{setPopoverOpen(false)};const goToPage=newActivePage=>{if((newActivePage+1)*limit>=constants["A"]){const toast={id:"PaginationWarningMsg",title:headerTitle+TOAST_TITLE,color:"warning",iconType:"alert",toastLifeTimeMs:1e4,text:TOAST_TEXT};return dispatchToaster({type:"addToaster",toast:toast})}setActivePage(newActivePage);loadPage(newActivePage);updateActivePage(newActivePage)};const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",color:"text",iconType:"arrowDown",iconSide:"right",onClick:onButtonClick},`${ROWS}: ${limit}`);const rowItems=itemsPerRow&&itemsPerRow.map(item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:item.text,icon:limit===item.numberOfRow?"check":"empty",onClick:()=>{closePopover();updateLimitPagination(item.numberOfRow);updateActivePage(0)}},item.text));const PaginationWrapper=showMorePagesIndicator?PaginationEuiFlexItem:external_kbnSharedDeps_ElasticEui_["EuiFlexItem"];const tableSorting=Object(external_kbnSharedDeps_React_["useMemo"])(()=>sorting?{sort:{field:sorting.field,direction:sorting.direction}}:undefined,[sorting]);return external_kbnSharedDeps_React_default.a.createElement(inspect["b"],{show:!loadingInitial},external_kbnSharedDeps_React_default.a.createElement(panel["a"],{"data-test-subj":`${dataTestSubj}-loading-${loading}`,loading:loading},external_kbnSharedDeps_React_default.a.createElement(header_section["a"],{id:id,subtitle:!loadingInitial&&`${SHOWING}: ${headerCount>=0?headerCount.toLocaleString():0} ${headerUnit}`,title:headerTitle,tooltip:headerTooltip},!loadingInitial&&headerSupplement),loadingInitial?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{"data-test-subj":"initialLoadingPanelPaginatedTable",lines:10}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(BasicTable,{columns:columns,items:pageOfItems,onChange:onChange,sorting:tableSorting}),external_kbnSharedDeps_React_default.a.createElement(FooterAction,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,itemsPerRow&&itemsPerRow.length>0&&totalCount>=itemsPerRow[0].numberOfRow&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"customizablePagination","data-test-subj":"loadingMoreSizeRowPopover",button:button,isOpen:isPopoverOpen,closePopover:closePopover,panelPaddingSize:"none",repositionOnScroll:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:rowItems,"data-test-subj":"loadingMorePickSizeRow"}))),external_kbnSharedDeps_React_default.a.createElement(PaginationWrapper,{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPagination"],{"data-test-subj":"numberedPagination",pageCount:pageCount,activePage:myActivePage,onPageClick:goToPage}))),(isInspect||myLoading)&&external_kbnSharedDeps_React_default.a.createElement(loader["a"],{"data-test-subj":"loadingPanelPaginatedTable",overlay:true,size:"xl"}))))};const PaginatedTable=Object(external_kbnSharedDeps_React_["memo"])(PaginatedTableComponent);const BasicTable=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"]).withConfig({displayName:"BasicTable",componentId:"sc-53ob89-0"})(["tbody{th,td{vertical-align:top;}.euiTableCellContent{display:block;}}"]);BasicTable.displayName="BasicTable";const FooterAction=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).attrs(()=>({alignItems:"center",responsive:false})).withConfig({displayName:"FooterAction",componentId:"sc-53ob89-1"})(["margin-top:",";"],({theme:theme})=>theme.eui.euiSizeXS);FooterAction.displayName="FooterAction";const PaginationEuiFlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"PaginationEuiFlexItem",componentId:"sc-53ob89-2"})(["@media only screen and (min-width:","){.euiButtonIcon:last-child{margin-left:28px;}.euiPagination{position:relative;}.euiPagination::before{bottom:0;color:",";content:'\\2026';font-size:",";padding:5px ",";position:absolute;right:",";}}"],({theme:theme})=>theme.eui.euiBreakpoints.m,({theme:theme})=>theme.eui.euiButtonColorDisabled,({theme:theme})=>theme.eui.euiFontSizeS,({theme:theme})=>theme.eui.euiSizeS,({theme:theme})=>theme.eui.euiSizeL);PaginationEuiFlexItem.displayName="PaginationEuiFlexItem"},,function(module,exports){var process=module.exports={};var cachedSetTimeout;var cachedClearTimeout;function defaultSetTimout(){throw new Error("setTimeout has not been defined")}function defaultClearTimeout(){throw new Error("clearTimeout has not been defined")}(function(){try{if(typeof setTimeout==="function"){cachedSetTimeout=setTimeout}else{cachedSetTimeout=defaultSetTimout}}catch(e){cachedSetTimeout=defaultSetTimout}try{if(typeof clearTimeout==="function"){cachedClearTimeout=clearTimeout}else{cachedClearTimeout=defaultClearTimeout}}catch(e){cachedClearTimeout=defaultClearTimeout}})();function runTimeout(fun){if(cachedSetTimeout===setTimeout){return setTimeout(fun,0)}if((cachedSetTimeout===defaultSetTimout||!cachedSetTimeout)&&setTimeout){cachedSetTimeout=setTimeout;return setTimeout(fun,0)}try{return cachedSetTimeout(fun,0)}catch(e){try{return cachedSetTimeout.call(null,fun,0)}catch(e){return cachedSetTimeout.call(this,fun,0)}}}function runClearTimeout(marker){if(cachedClearTimeout===clearTimeout){return clearTimeout(marker)}if((cachedClearTimeout===defaultClearTimeout||!cachedClearTimeout)&&clearTimeout){cachedClearTimeout=clearTimeout;return clearTimeout(marker)}try{return cachedClearTimeout(marker)}catch(e){try{return cachedClearTimeout.call(null,marker)}catch(e){return cachedClearTimeout.call(this,marker)}}}var queue=[];var draining=false;var currentQueue;var queueIndex=-1;function cleanUpNextTick(){if(!draining||!currentQueue){return}draining=false;if(currentQueue.length){queue=currentQueue.concat(queue)}else{queueIndex=-1}if(queue.length){drainQueue()}}function drainQueue(){if(draining){return}var timeout=runTimeout(cleanUpNextTick);draining=true;var len=queue.length;while(len){currentQueue=queue;queue=[];while(++queueIndex<len){if(currentQueue){currentQueue[queueIndex].run()}}queueIndex=-1;len=queue.length}currentQueue=null;draining=false;runClearTimeout(timeout)}process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){args[i-1]=arguments[i]}}queue.push(new Item(fun,args));if(queue.length===1&&!draining){runTimeout(drainQueue)}};function Item(fun,array){this.fun=fun;this.array=array}Item.prototype.run=function(){this.fun.apply(null,this.array)};process.title="browser";process.browser=true;process.env={};process.argv=[];process.version="";process.versions={};function noop(){}process.on=noop;process.addListener=noop;process.once=noop;process.off=noop;process.removeListener=noop;process.removeAllListeners=noop;process.emit=noop;process.prependListener=noop;process.prependOnceListener=noop;process.listeners=function(name){return[]};process.binding=function(name){throw new Error("process.binding is not supported")};process.cwd=function(){return"/"};process.chdir=function(dir){throw new Error("process.chdir is not supported")};process.umask=function(){return 0}},,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return encodeIpv6}));__webpack_require__.d(__webpack_exports__,"b",(function(){return decodeIpv6}));__webpack_require__.d(__webpack_exports__,"a",(function(){return asArrayIfExists}));__webpack_require__.d(__webpack_exports__,"d",(function(){return gutterTimeline}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);const encodeIpv6=ip=>ip.replace(/:/g,"-");const decodeIpv6=ip=>ip.replace(/-/g,":");const asArrayIfExists=value=>!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isUndefined"])(value)?Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["castArray"])(value):undefined;const gutterTimeline="70px"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"m",(function(){return omitTypenameAndEmpty}));__webpack_require__.d(__webpack_exports__,"e",(function(){return eventHasNotes}));__webpack_require__.d(__webpack_exports__,"j",(function(){return getPinTooltip}));__webpack_require__.d(__webpack_exports__,"f",(function(){return eventIsPinned}));__webpack_require__.d(__webpack_exports__,"i",(function(){return getPinOnClick}));__webpack_require__.d(__webpack_exports__,"g",(function(){return getEventIdToDataMapping}));__webpack_require__.d(__webpack_exports__,"l",(function(){return isEventBuildingBlockType}));__webpack_require__.d(__webpack_exports__,"k",(function(){return isEvenEqlSequence}));__webpack_require__.d(__webpack_exports__,"h",(function(){return getEventType}));__webpack_require__.d(__webpack_exports__,"a",(function(){return InvestigateInResolverAction}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ROW_RENDERER_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"b",(function(){return NOTES_CONTAINER_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"c",(function(){return NOTE_CONTENT_CLASS_NAME}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var lodash_fp__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_1__);var react_redux__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_2__);var _store_timeline_actions__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(21);var _common_types_timeline__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(106);var _actions_action_icon_item__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(356);var _translations__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(262);const omitTypenameAndEmpty=(k,v)=>k!=="__typename"&&v!=null?v:undefined;const stringifyEvent=ecs=>JSON.stringify(ecs,omitTypenameAndEmpty,2);const eventHasNotes=noteIds=>!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])(noteIds);const getPinTooltip=({isPinned:isPinned,eventHasNotes:eventHasNotes,timelineType:timelineType})=>timelineType===_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["i"].template?_translations__WEBPACK_IMPORTED_MODULE_6__["f"]:isPinned&&eventHasNotes?_translations__WEBPACK_IMPORTED_MODULE_6__["l"]:isPinned?_translations__WEBPACK_IMPORTED_MODULE_6__["k"]:_translations__WEBPACK_IMPORTED_MODULE_6__["q"];const eventIsPinned=({eventId:eventId,pinnedEventIds:pinnedEventIds})=>pinnedEventIds[eventId]===true;const getPinOnClick=({allowUnpinning:allowUnpinning,eventId:eventId,onPinEvent:onPinEvent,onUnPinEvent:onUnPinEvent,isEventPinned:isEventPinned})=>{if(!allowUnpinning){return}if(isEventPinned){onUnPinEvent(eventId)}else{onPinEvent(eventId)}};const getEventIdToDataMapping=(timelineData,eventIds,fieldsToKeep)=>timelineData.reduce((acc,v)=>{const fvm=eventIds.includes(v._id)?{[v._id]:v.data.filter(ti=>fieldsToKeep.includes(ti.field))}:{};return{...acc,...fvm}},{});const isEventBuildingBlockType=event=>{var _event$signal,_event$signal$rule;return!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])((_event$signal=event.signal)===null||_event$signal===void 0?void 0:(_event$signal$rule=_event$signal.rule)===null||_event$signal$rule===void 0?void 0:_event$signal$rule.building_block_type)};const isEvenEqlSequence=event=>{var _event$eql;if(!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])((_event$eql=event.eql)===null||_event$eql===void 0?void 0:_event$eql.sequenceNumber)){try{var _event$eql$sequenceNu,_event$eql2;const sequenceNumber=((_event$eql$sequenceNu=(_event$eql2=event.eql)===null||_event$eql2===void 0?void 0:_event$eql2.sequenceNumber)!==null&&_event$eql$sequenceNu!==void 0?_event$eql$sequenceNu:"").split("-")[0];return parseInt(sequenceNumber,10)%2===0}catch{return false}}return false};const getEventType=event=>{var _event$signal2,_event$signal2$rule,_event$eql3;if(!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])((_event$signal2=event.signal)===null||_event$signal2===void 0?void 0:(_event$signal2$rule=_event$signal2.rule)===null||_event$signal2$rule===void 0?void 0:_event$signal2$rule.id)){return"signal"}else if(!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["isEmpty"])((_event$eql3=event.eql)===null||_event$eql3===void 0?void 0:_event$eql3.parentId)){return"eql"}return"raw"};const isInvestigateInResolverActionEnabled=ecsData=>{var _get;return(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["get"])(["agent","type",0],ecsData)==="endpoint"||Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["get"])(["agent","type",0],ecsData)==="winlogbeat"&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["get"])(["event","module",0],ecsData)==="sysmon")&&((_get=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["get"])(["process","entity_id"],ecsData))===null||_get===void 0?void 0:_get.length)===1&&Object(lodash_fp__WEBPACK_IMPORTED_MODULE_1__["get"])(["process","entity_id",0],ecsData)!==""};const InvestigateInResolverActionComponent=({ariaLabel:ariaLabel=_translations__WEBPACK_IMPORTED_MODULE_6__["a"],timelineId:timelineId,ecsData:ecsData})=>{const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_2__["useDispatch"])();const isDisabled=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>!isInvestigateInResolverActionEnabled(ecsData),[ecsData]);const handleClick=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(()=>{dispatch(Object(_store_timeline_actions__WEBPACK_IMPORTED_MODULE_3__["updateTimelineGraphEventId"])({id:timelineId,graphEventId:ecsData._id}));if(timelineId===_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["e"].active){dispatch(Object(_store_timeline_actions__WEBPACK_IMPORTED_MODULE_3__["setActiveTabTimeline"])({id:timelineId,activeTab:_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["h"].graph}))}},[dispatch,ecsData._id,timelineId]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_actions_action_icon_item__WEBPACK_IMPORTED_MODULE_5__["a"],{ariaLabel:ariaLabel,content:isDisabled?_translations__WEBPACK_IMPORTED_MODULE_6__["g"]:_translations__WEBPACK_IMPORTED_MODULE_6__["a"],dataTestSubj:"investigate-in-resolver",iconType:"analyzeEvent",isDisabled:isDisabled,onClick:handleClick})};InvestigateInResolverActionComponent.displayName="InvestigateInResolverActionComponent";const InvestigateInResolverAction=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(InvestigateInResolverActionComponent);const ROW_RENDERER_CLASS_NAME="row-renderer";const NOTES_CONTAINER_CLASS_NAME="notes-container";const NOTE_CONTENT_CLASS_NAME="note-content"},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(447);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _nameToHex=__webpack_require__(920);var _nameToHex2=_interopRequireDefault(_nameToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var hexRegex=/^#[a-fA-F0-9]{6}$/;var reducedHexRegex=/^#[a-fA-F0-9]{3}$/;var rgbRegex=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/;var rgbaRegex=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;var hslRegex=/^hsl\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*\)$/;var hslaRegex=/^hsla\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;function parseToRgb(color){if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}var normalizedColor=(0,_nameToHex2.default)(color);if(normalizedColor.match(hexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[2],16),green:parseInt(""+normalizedColor[3]+normalizedColor[4],16),blue:parseInt(""+normalizedColor[5]+normalizedColor[6],16)}}if(normalizedColor.match(reducedHexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[1],16),green:parseInt(""+normalizedColor[2]+normalizedColor[2],16),blue:parseInt(""+normalizedColor[3]+normalizedColor[3],16)}}var rgbMatched=rgbRegex.exec(normalizedColor);if(rgbMatched){return{red:parseInt(""+rgbMatched[1],10),green:parseInt(""+rgbMatched[2],10),blue:parseInt(""+rgbMatched[3],10)}}var rgbaMatched=rgbaRegex.exec(normalizedColor);if(rgbaMatched){return{red:parseInt(""+rgbaMatched[1],10),green:parseInt(""+rgbaMatched[2],10),blue:parseInt(""+rgbaMatched[3],10),alpha:parseFloat(""+rgbaMatched[4])}}var hslMatched=hslRegex.exec(normalizedColor);if(hslMatched){var hue=parseInt(""+hslMatched[1],10);var saturation=parseInt(""+hslMatched[2],10)/100;var lightness=parseInt(""+hslMatched[3],10)/100;var rgbColorString="rgb("+(0,_hslToRgb2.default)(hue,saturation,lightness)+")";var hslRgbMatched=rgbRegex.exec(rgbColorString);return{red:parseInt(""+hslRgbMatched[1],10),green:parseInt(""+hslRgbMatched[2],10),blue:parseInt(""+hslRgbMatched[3],10)}}var hslaMatched=hslaRegex.exec(normalizedColor);if(hslaMatched){var _hue=parseInt(""+hslaMatched[1],10);var _saturation=parseInt(""+hslaMatched[2],10)/100;var _lightness=parseInt(""+hslaMatched[3],10)/100;var _rgbColorString="rgb("+(0,_hslToRgb2.default)(_hue,_saturation,_lightness)+")";var _hslRgbMatched=rgbRegex.exec(_rgbColorString);return{red:parseInt(""+_hslRgbMatched[1],10),green:parseInt(""+_hslRgbMatched[2],10),blue:parseInt(""+_hslRgbMatched[3],10),alpha:parseFloat(""+hslaMatched[4])}}throw new Error("Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.")}exports.default=parseToRgb;module.exports=exports["default"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return histogramDateTimeFormatter}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useThrottledResizeObserver}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var use_resize_observer_polyfilled__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(959);var use_resize_observer_polyfilled__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(use_resize_observer_polyfilled__WEBPACK_IMPORTED_MODULE_2__);var _elastic_charts__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(84);var _elastic_charts__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_charts__WEBPACK_IMPORTED_MODULE_3__);var moment_timezone__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(23);var moment_timezone__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(moment_timezone__WEBPACK_IMPORTED_MODULE_4__);const getDaysDiff=(minDate,maxDate)=>{const diff=maxDate.diff(minDate,"days");if(diff<=1&&!minDate.isSame(maxDate)){return 2}return diff};const histogramDateTimeFormatter=(domain,fixedDiff)=>{const diff=fixedDiff!==null&&fixedDiff!==void 0?fixedDiff:getDaysDiff(moment_timezone__WEBPACK_IMPORTED_MODULE_4___default()(domain[0]),moment_timezone__WEBPACK_IMPORTED_MODULE_4___default()(domain[1]));const format=Object(_elastic_charts__WEBPACK_IMPORTED_MODULE_3__["niceTimeFormatByDay"])(diff);return Object(_elastic_charts__WEBPACK_IMPORTED_MODULE_3__["timeFormatter"])(format)};const useThrottledResizeObserver=(wait=100)=>{const[size,setSize]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])({width:0,height:0});const onResize=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["throttle"])(wait,setSize),[wait]);const{ref:ref}=use_resize_observer_polyfilled__WEBPACK_IMPORTED_MODULE_2___default()({onResize:onResize});return{ref:ref,...size}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return NetflowRenderer}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(225);var _certificate_fingerprint__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(525);var _duration__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(365);var _common_components_event_details_event_id__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(655);var _network_components_ip__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(294);var _ja3_fingerprint__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(526);var _netflow__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(753);var _netflow_netflow_columns_duration_event_start_end__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(460);var _network_components_port__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(296);var _network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__=__webpack_require__(458);var _network_components_source_destination_source_destination_arrows__WEBPACK_IMPORTED_MODULE_12__=__webpack_require__(408);var _network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__=__webpack_require__(369);const NetflowRenderer=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({data:data,timelineId:timelineId})=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_netflow__WEBPACK_IMPORTED_MODULE_8__["a"],{contextId:`netflow-renderer-${timelineId}-${data._id}`,destinationBytes:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_source_destination_arrows__WEBPACK_IMPORTED_MODULE_12__["a"],data)),destinationGeoContinentName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["b"],data)),destinationGeoCountryName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["d"],data)),destinationGeoCountryIsoCode:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["c"],data)),destinationGeoRegionName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["e"],data)),destinationGeoCityName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["a"],data)),destinationIp:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_ip__WEBPACK_IMPORTED_MODULE_6__["a"],data)),destinationPackets:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_source_destination_arrows__WEBPACK_IMPORTED_MODULE_12__["b"],data)),destinationPort:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_port__WEBPACK_IMPORTED_MODULE_10__["a"],data)),eventDuration:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_duration__WEBPACK_IMPORTED_MODULE_4__["b"],data)),eventId:Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_common_components_event_details_event_id__WEBPACK_IMPORTED_MODULE_5__["a"],data),eventEnd:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_netflow_netflow_columns_duration_event_start_end__WEBPACK_IMPORTED_MODULE_9__["b"],data)),eventStart:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_netflow_netflow_columns_duration_event_start_end__WEBPACK_IMPORTED_MODULE_9__["c"],data)),networkBytes:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__["a"],data)),networkCommunityId:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__["b"],data)),networkDirection:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__["c"],data)),networkPackets:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__["d"],data)),networkProtocol:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__["e"],data)),sourceBytes:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_source_destination_arrows__WEBPACK_IMPORTED_MODULE_12__["c"],data)),sourceGeoContinentName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["h"],data)),sourceGeoCountryName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["j"],data)),sourceGeoCountryIsoCode:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["i"],data)),sourceGeoRegionName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["k"],data)),sourceGeoCityName:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_geo_fields__WEBPACK_IMPORTED_MODULE_11__["g"],data)),sourceIp:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_ip__WEBPACK_IMPORTED_MODULE_6__["c"],data)),sourcePackets:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_source_destination_arrows__WEBPACK_IMPORTED_MODULE_12__["d"],data)),sourcePort:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_port__WEBPACK_IMPORTED_MODULE_10__["d"],data)),tlsClientCertificateFingerprintSha1:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_certificate_fingerprint__WEBPACK_IMPORTED_MODULE_3__["b"],data)),tlsFingerprintsJa3Hash:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_ja3_fingerprint__WEBPACK_IMPORTED_MODULE_7__["a"],data)),tlsServerCertificateFingerprintSha1:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_certificate_fingerprint__WEBPACK_IMPORTED_MODULE_3__["c"],data)),transport:Object(_common_lib_helpers__WEBPACK_IMPORTED_MODULE_2__["a"])(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])(_network_components_source_destination_field_names__WEBPACK_IMPORTED_MODULE_13__["f"],data)),userName:undefined}));NetflowRenderer.displayName="NetflowRenderer"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return createPortalNode}));__webpack_require__.d(__webpack_exports__,"a",(function(){return InPortal}));__webpack_require__.d(__webpack_exports__,"b",(function(){return OutPortal}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_dom__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(86);var react_dom__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);var __extends=undefined&&undefined.__extends||function(){var extendStatics=function(d,b){extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return extendStatics(d,b)};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();var createPortalNode=function(){var initialProps={};var parent;var lastPlaceholder;var portalNode=Object.assign(document.createElement("div"),{setPortalProps:function(props){initialProps=props},getInitialPortalProps:function(){return initialProps},mount:function(newParent,newPlaceholder){if(newPlaceholder===lastPlaceholder){return}portalNode.unmount();newParent.replaceChild(portalNode,newPlaceholder);parent=newParent;lastPlaceholder=newPlaceholder},unmount:function(expectedPlaceholder){if(expectedPlaceholder&&expectedPlaceholder!==lastPlaceholder){return}if(parent&&lastPlaceholder){parent.replaceChild(lastPlaceholder,portalNode);parent=undefined;lastPlaceholder=undefined}}});return portalNode};var InPortal=function(_super){__extends(InPortal,_super);function InPortal(props){var _this=_super.call(this,props)||this;_this.addPropsChannel=function(){Object.assign(_this.props.node,{setPortalProps:function(props){_this.setState({nodeProps:props})}})};_this.state={nodeProps:_this.props.node.getInitialPortalProps()};return _this}InPortal.prototype.componentDidMount=function(){this.addPropsChannel()};InPortal.prototype.componentDidUpdate=function(){this.addPropsChannel()};InPortal.prototype.render=function(){var _this=this;var _a=this.props,children=_a.children,node=_a.node;return react_dom__WEBPACK_IMPORTED_MODULE_1__["createPortal"](react__WEBPACK_IMPORTED_MODULE_0__["Children"].map(children,(function(child){if(!react__WEBPACK_IMPORTED_MODULE_0__["isValidElement"](child))return child;return react__WEBPACK_IMPORTED_MODULE_0__["cloneElement"](child,_this.state.nodeProps)})),node)};return InPortal}(react__WEBPACK_IMPORTED_MODULE_0__["PureComponent"]);var OutPortal=function(_super){__extends(OutPortal,_super);function OutPortal(props){var _this=_super.call(this,props)||this;_this.placeholderNode=react__WEBPACK_IMPORTED_MODULE_0__["createRef"]();_this.passPropsThroughPortal();return _this}OutPortal.prototype.passPropsThroughPortal=function(){var propsForTarget=Object.assign({},this.props,{node:undefined});this.props.node.setPortalProps(propsForTarget)};OutPortal.prototype.componentDidMount=function(){var node=this.props.node;var placeholder=this.placeholderNode.current;var parent=placeholder.parentNode;node.mount(parent,placeholder);this.passPropsThroughPortal()};OutPortal.prototype.componentDidUpdate=function(){var node=this.props.node;var placeholder=this.placeholderNode.current;var parent=placeholder.parentNode;node.mount(parent,placeholder);this.passPropsThroughPortal()};OutPortal.prototype.componentWillUnmount=function(){var node=this.props.node;node.unmount(this.placeholderNode.current)};OutPortal.prototype.render=function(){return react__WEBPACK_IMPORTED_MODULE_0__["createElement"]("div",{ref:this.placeholderNode})};return OutPortal}(react__WEBPACK_IMPORTED_MODULE_0__["PureComponent"])},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"listData",(function(){return listData}));__webpack_require__.d(__webpack_exports__,"pageIndex",(function(){return pageIndex}));__webpack_require__.d(__webpack_exports__,"pageSize",(function(){return pageSize}));__webpack_require__.d(__webpack_exports__,"totalHits",(function(){return totalHits}));__webpack_require__.d(__webpack_exports__,"listLoading",(function(){return listLoading}));__webpack_require__.d(__webpack_exports__,"listError",(function(){return listError}));__webpack_require__.d(__webpack_exports__,"detailsData",(function(){return detailsData}));__webpack_require__.d(__webpack_exports__,"detailsLoading",(function(){return detailsLoading}));__webpack_require__.d(__webpack_exports__,"detailsError",(function(){return detailsError}));__webpack_require__.d(__webpack_exports__,"policyItems",(function(){return policyItems}));__webpack_require__.d(__webpack_exports__,"policyItemsLoading",(function(){return policyItemsLoading}));__webpack_require__.d(__webpack_exports__,"selectedPolicyId",(function(){return selectedPolicyId}));__webpack_require__.d(__webpack_exports__,"endpointPackageInfo",(function(){return endpointPackageInfo}));__webpack_require__.d(__webpack_exports__,"isAutoRefreshEnabled",(function(){return isAutoRefreshEnabled}));__webpack_require__.d(__webpack_exports__,"autoRefreshInterval",(function(){return autoRefreshInterval}));__webpack_require__.d(__webpack_exports__,"policyVersionInfo",(function(){return policyVersionInfo}));__webpack_require__.d(__webpack_exports__,"areEndpointsEnrolling",(function(){return areEndpointsEnrolling}));__webpack_require__.d(__webpack_exports__,"agentsWithEndpointsTotalError",(function(){return agentsWithEndpointsTotalError}));__webpack_require__.d(__webpack_exports__,"endpointsTotalError",(function(){return endpointsTotalError}));__webpack_require__.d(__webpack_exports__,"endpointPackageVersion",(function(){return endpointPackageVersion}));__webpack_require__.d(__webpack_exports__,"isTransformEnabled",(function(){return isTransformEnabled}));__webpack_require__.d(__webpack_exports__,"patterns",(function(){return patterns}));__webpack_require__.d(__webpack_exports__,"patternsError",(function(){return patternsError}));__webpack_require__.d(__webpack_exports__,"policyResponseTimestamp",(function(){return policyResponseTimestamp}));__webpack_require__.d(__webpack_exports__,"policyResponseConfigurations",(function(){return policyResponseConfigurations}));__webpack_require__.d(__webpack_exports__,"policyResponseFailedOrWarningActionCount",(function(){return policyResponseFailedOrWarningActionCount}));__webpack_require__.d(__webpack_exports__,"policyResponseActions",(function(){return policyResponseActions}));__webpack_require__.d(__webpack_exports__,"policyResponseLoading",(function(){return policyResponseLoading}));__webpack_require__.d(__webpack_exports__,"policyResponseError",(function(){return policyResponseError}));__webpack_require__.d(__webpack_exports__,"isOnEndpointPage",(function(){return isOnEndpointPage}));__webpack_require__.d(__webpack_exports__,"uiQueryParams",(function(){return uiQueryParams}));__webpack_require__.d(__webpack_exports__,"hasSelectedEndpoint",(function(){return hasSelectedEndpoint}));__webpack_require__.d(__webpack_exports__,"showView",(function(){return showView}));__webpack_require__.d(__webpack_exports__,"hostStatusInfo",(function(){return hostStatusInfo}));__webpack_require__.d(__webpack_exports__,"policyResponseStatus",(function(){return policyResponseStatus}));__webpack_require__.d(__webpack_exports__,"nonExistingPolicies",(function(){return nonExistingPolicies}));__webpack_require__.d(__webpack_exports__,"agentPolicies",(function(){return agentPolicies}));__webpack_require__.d(__webpack_exports__,"endpointsExist",(function(){return endpointsExist}));__webpack_require__.d(__webpack_exports__,"searchBarQuery",(function(){return searchBarQuery}));var querystring__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(214);var querystring__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(querystring__WEBPACK_IMPORTED_MODULE_0__);var reselect__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(123);var reselect__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(reselect__WEBPACK_IMPORTED_MODULE_1__);var react_router_dom__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(75);var react_router_dom__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_2__);var rison_node__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(178);var rison_node__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(rison_node__WEBPACK_IMPORTED_MODULE_3__);var _common_endpoint_types__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(39);var _common_routing__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(148);var _common_constants__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(121);const listData=state=>state.hosts;const pageIndex=state=>state.pageIndex;const pageSize=state=>state.pageSize;const totalHits=state=>state.total;const listLoading=state=>state.loading;const listError=state=>state.error;const detailsData=state=>state.details;const detailsLoading=state=>state.detailsLoading;const detailsError=state=>state.detailsError;const policyItems=state=>state.policyItems;const policyItemsLoading=state=>state.policyItemsLoading;const selectedPolicyId=state=>state.selectedPolicyId;const endpointPackageInfo=state=>state.endpointPackageInfo;const isAutoRefreshEnabled=state=>state.isAutoRefreshEnabled;const autoRefreshInterval=state=>state.autoRefreshInterval;const policyVersionInfo=state=>state.policyVersionInfo;const areEndpointsEnrolling=state=>state.agentsWithEndpointsTotal>state.endpointsTotal;const agentsWithEndpointsTotalError=state=>state.agentsWithEndpointsTotalError;const endpointsTotalError=state=>state.endpointsTotalError;const queryStrategyVersion=state=>state.queryStrategyVersion;const endpointPackageVersion=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(endpointPackageInfo,info=>{var _info$version;return(_info$version=info===null||info===void 0?void 0:info.version)!==null&&_info$version!==void 0?_info$version:undefined});const isTransformEnabled=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(queryStrategyVersion,version=>version!==_common_endpoint_types__WEBPACK_IMPORTED_MODULE_4__["d"].VERSION_1);const patterns=state=>state.patterns;const patternsError=state=>state.patternsError;const detailsPolicyAppliedResponse=state=>state.policyResponse&&state.policyResponse.Endpoint.policy.applied;const policyResponseTimestamp=state=>state.policyResponse&&state.policyResponse["@timestamp"];const policyResponseConfigurations=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(detailsPolicyAppliedResponse,applied=>{var _applied$response;return applied===null||applied===void 0?void 0:(_applied$response=applied.response)===null||_applied$response===void 0?void 0:_applied$response.configurations});const policyResponseFailedOrWarningActionCount=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(detailsPolicyAppliedResponse,applied=>{var _applied$response2;const failureOrWarningByConfigType=new Map;if((applied===null||applied===void 0?void 0:(_applied$response2=applied.response)===null||_applied$response2===void 0?void 0:_applied$response2.configurations)!==undefined&&(applied===null||applied===void 0?void 0:applied.actions)!==undefined){Object.entries(applied.response.configurations).map(([key,val])=>{let count=0;for(const action of val.concerned_actions){var _applied$actions$find;const actionStatus=(_applied$actions$find=applied.actions.find(policyActions=>policyActions.name===action))===null||_applied$actions$find===void 0?void 0:_applied$actions$find.status;if(actionStatus===_common_endpoint_types__WEBPACK_IMPORTED_MODULE_4__["b"].failure||actionStatus===_common_endpoint_types__WEBPACK_IMPORTED_MODULE_4__["b"].warning){count+=1}}return failureOrWarningByConfigType.set(key,count)})}return failureOrWarningByConfigType});const policyResponseActions=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(detailsPolicyAppliedResponse,applied=>applied===null||applied===void 0?void 0:applied.actions);const policyResponseLoading=state=>state.policyResponseLoading;const policyResponseError=state=>state.policyResponseError;const isOnEndpointPage=state=>{var _state$location$pathn,_state$location;return Object(react_router_dom__WEBPACK_IMPORTED_MODULE_2__["matchPath"])((_state$location$pathn=(_state$location=state.location)===null||_state$location===void 0?void 0:_state$location.pathname)!==null&&_state$location$pathn!==void 0?_state$location$pathn:"",{path:_common_constants__WEBPACK_IMPORTED_MODULE_6__["f"],exact:true})!==null};const uiQueryParams=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(state=>state.location,location=>{const data={page_index:String(_common_constants__WEBPACK_IMPORTED_MODULE_6__["c"]),page_size:String(_common_constants__WEBPACK_IMPORTED_MODULE_6__["d"])};if(location){const query=querystring__WEBPACK_IMPORTED_MODULE_0___default.a.parse(location.search.slice(1));const paginationParams=Object(_common_routing__WEBPACK_IMPORTED_MODULE_5__["a"])(query);const keys=["selected_endpoint","show","admin_query"];for(const key of keys){const value=typeof query[key]==="string"?query[key]:Array.isArray(query[key])?query[key][query[key].length-1]:undefined;if(value!==undefined){if(key==="show"){if(value==="policy_response"||value==="details"){data[key]=value}}else{data[key]=value}}}data.page_size=String(paginationParams.page_size);data.page_index=String(paginationParams.page_index)}return data});const hasSelectedEndpoint=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(uiQueryParams,({selected_endpoint:selectedEndpoint})=>selectedEndpoint!==undefined);const showView=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(uiQueryParams,searchParams=>searchParams.show==="policy_response"?"policy_response":"details");const hostStatusInfo=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(state=>state.hostStatus,hostStatus=>hostStatus?hostStatus:_common_endpoint_types__WEBPACK_IMPORTED_MODULE_4__["c"].ERROR);const policyResponseStatus=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(state=>state.policyResponse,policyResponse=>{var _policyResponse$Endpo,_policyResponse$Endpo2,_policyResponse$Endpo3;return policyResponse&&(policyResponse===null||policyResponse===void 0?void 0:(_policyResponse$Endpo=policyResponse.Endpoint)===null||_policyResponse$Endpo===void 0?void 0:(_policyResponse$Endpo2=_policyResponse$Endpo.policy)===null||_policyResponse$Endpo2===void 0?void 0:(_policyResponse$Endpo3=_policyResponse$Endpo2.applied)===null||_policyResponse$Endpo3===void 0?void 0:_policyResponse$Endpo3.status)||""});const nonExistingPolicies=state=>state.nonExistingPolicies;const agentPolicies=state=>state.agentPolicies;const endpointsExist=state=>state.endpointsExist;const searchBarQuery=Object(reselect__WEBPACK_IMPORTED_MODULE_1__["createSelector"])(uiQueryParams,({admin_query:adminQuery})=>{const decodedQuery={query:"",language:"kuery"};if(adminQuery){const urlDecodedQuery=Object(rison_node__WEBPACK_IMPORTED_MODULE_3__["decode"])(adminQuery);if(urlDecodedQuery&&typeof urlDecodedQuery.query==="string"){decodedQuery.query=urlDecodedQuery.query}if(urlDecodedQuery&&typeof urlDecodedQuery.language==="string"&&(urlDecodedQuery.language==="kuery"||urlDecodedQuery.language==="lucene")){decodedQuery.language=urlDecodedQuery.language}}return decodedQuery})},,,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _capitalizeString=__webpack_require__(591);var _capitalizeString2=_interopRequireDefault(_capitalizeString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var positionMap=["Top","Right","Bottom","Left"];function generateProperty(property,position){if(!property)return position.toLowerCase();var splitProperty=property.split("-");if(splitProperty.length>1){splitProperty.splice(1,0,position);return splitProperty.reduce((function(acc,val){return""+acc+(0,_capitalizeString2.default)(val)}))}var joinedProperty=property.replace(/([a-z])([A-Z])/g,"$1"+position+"$2");return property===joinedProperty?""+property+position:joinedProperty}function generateStyles(property,valuesWithDefaults){var styles={};for(var i=0;i<valuesWithDefaults.length;i+=1){if(valuesWithDefaults[i]||valuesWithDefaults[i]===0){styles[generateProperty(property,positionMap[i])]=valuesWithDefaults[i]}}return styles}function directionalProperty(property){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}var firstValue=values[0],_values$=values[1],secondValue=_values$===undefined?firstValue:_values$,_values$2=values[2],thirdValue=_values$2===undefined?firstValue:_values$2,_values$3=values[3],fourthValue=_values$3===undefined?secondValue:_values$3;var valuesWithDefaults=[firstValue,secondValue,thirdValue,fourthValue];return generateStyles(property,valuesWithDefaults)}exports.default=directionalProperty;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _interopDefault(ex){return ex&&typeof ex==="object"&&"default"in ex?ex["default"]:ex}var React=__webpack_require__(6);var React__default=_interopDefault(React);var _inheritsLoose=_interopDefault(__webpack_require__(951));var _extends=_interopDefault(__webpack_require__(952));var redux=__webpack_require__(953);var reactRedux=__webpack_require__(105);var useMemoOne=__webpack_require__(954);var cssBoxModel=__webpack_require__(955);var memoizeOne=_interopDefault(__webpack_require__(222));var rafSchd=_interopDefault(__webpack_require__(957));var ReactDOM=_interopDefault(__webpack_require__(86));var isProduction="production"==="production";var spacesAndTabs=/[ \t]{2,}/g;var lineStartWithSpaces=/^[ \t]*/gm;var clean=function clean(value){return value.replace(spacesAndTabs," ").replace(lineStartWithSpaces,"").trim()};var getDevMessage=function getDevMessage(message){return clean("\n  %creact-beautiful-dnd\n\n  %c"+clean(message)+"\n\n  %c👷‍ This is a development only message. It will be removed in production builds.\n")};var getFormattedMessage=function getFormattedMessage(message){return[getDevMessage(message),"color: #00C584; font-size: 1.2em; font-weight: bold;","line-height: 1.5","color: #723874;"]};var isDisabledFlag="__react-beautiful-dnd-disable-dev-warnings";function log(type,message){var _console;if(isProduction){return}if(typeof window!=="undefined"&&window[isDisabledFlag]){return}(_console=console)[type].apply(_console,getFormattedMessage(message))}var warning=log.bind(null,"warn");var error=log.bind(null,"error");function noop(){}function getOptions(shared,fromBinding){return _extends({},shared,{},fromBinding)}function bindEvents(el,bindings,sharedOptions){var unbindings=bindings.map((function(binding){var options=getOptions(sharedOptions,binding.options);el.addEventListener(binding.eventName,binding.fn,options);return function unbind(){el.removeEventListener(binding.eventName,binding.fn,options)}}));return function unbindAll(){unbindings.forEach((function(unbind){unbind()}))}}var isProduction$1="production"==="production";var prefix="Invariant failed";function RbdInvariant(message){this.message=message}RbdInvariant.prototype.toString=function toString(){return this.message};function invariant(condition,message){if(condition){return}if(isProduction$1){throw new RbdInvariant(prefix)}else{throw new RbdInvariant(prefix+": "+(message||""))}}var ErrorBoundary=function(_React$Component){_inheritsLoose(ErrorBoundary,_React$Component);function ErrorBoundary(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_React$Component.call.apply(_React$Component,[this].concat(args))||this;_this.callbacks=null;_this.unbind=noop;_this.onWindowError=function(event){var callbacks=_this.getCallbacks();if(callbacks.isDragging()){callbacks.tryAbort();false?undefined:void 0}var err=event.error;if(err instanceof RbdInvariant){event.preventDefault();if(false){}}};_this.getCallbacks=function(){if(!_this.callbacks){throw new Error("Unable to find AppCallbacks in <ErrorBoundary/>")}return _this.callbacks};_this.setCallbacks=function(callbacks){_this.callbacks=callbacks};return _this}var _proto=ErrorBoundary.prototype;_proto.componentDidMount=function componentDidMount(){this.unbind=bindEvents(window,[{eventName:"error",fn:this.onWindowError}])};_proto.componentWillUnmount=function componentWillUnmount(){this.unbind()};_proto.componentDidCatch=function componentDidCatch(err){if(err instanceof RbdInvariant){if(false){}this.setState({});return}throw err};_proto.render=function render(){return this.props.children(this.setCallbacks)};return ErrorBoundary}(React__default.Component);var dragHandleUsageInstructions="\n  Press space bar to start a drag.\n  When dragging you can use the arrow keys to move the item around and escape to cancel.\n  Some screen readers may require you to be in focus mode or to use your pass through key\n";var position=function position(index){return index+1};var onDragStart=function onDragStart(start){return"\n  You have lifted an item in position "+position(start.source.index)+"\n"};var withLocation=function withLocation(source,destination){var isInHomeList=source.droppableId===destination.droppableId;var startPosition=position(source.index);var endPosition=position(destination.index);if(isInHomeList){return"\n      You have moved the item from position "+startPosition+"\n      to position "+endPosition+"\n    "}return"\n    You have moved the item from position "+startPosition+"\n    in list "+source.droppableId+"\n    to list "+destination.droppableId+"\n    in position "+endPosition+"\n  "};var withCombine=function withCombine(id,source,combine){var inHomeList=source.droppableId===combine.droppableId;if(inHomeList){return"\n      The item "+id+"\n      has been combined with "+combine.draggableId}return"\n      The item "+id+"\n      in list "+source.droppableId+"\n      has been combined with "+combine.draggableId+"\n      in list "+combine.droppableId+"\n    "};var onDragUpdate=function onDragUpdate(update){var location=update.destination;if(location){return withLocation(update.source,location)}var combine=update.combine;if(combine){return withCombine(update.draggableId,update.source,combine)}return"You are over an area that cannot be dropped on"};var returnedToStart=function returnedToStart(source){return"\n  The item has returned to its starting position\n  of "+position(source.index)+"\n"};var onDragEnd=function onDragEnd(result){if(result.reason==="CANCEL"){return"\n      Movement cancelled.\n      "+returnedToStart(result.source)+"\n    "}var location=result.destination;var combine=result.combine;if(location){return"\n      You have dropped the item.\n      "+withLocation(result.source,location)+"\n    "}if(combine){return"\n      You have dropped the item.\n      "+withCombine(result.draggableId,result.source,combine)+"\n    "}return"\n    The item has been dropped while not over a drop area.\n    "+returnedToStart(result.source)+"\n  "};var preset={dragHandleUsageInstructions:dragHandleUsageInstructions,onDragStart:onDragStart,onDragUpdate:onDragUpdate,onDragEnd:onDragEnd};var origin={x:0,y:0};var add=function add(point1,point2){return{x:point1.x+point2.x,y:point1.y+point2.y}};var subtract=function subtract(point1,point2){return{x:point1.x-point2.x,y:point1.y-point2.y}};var isEqual=function isEqual(point1,point2){return point1.x===point2.x&&point1.y===point2.y};var negate=function negate(point){return{x:point.x!==0?-point.x:0,y:point.y!==0?-point.y:0}};var patch=function patch(line,value,otherValue){var _ref;if(otherValue===void 0){otherValue=0}return _ref={},_ref[line]=value,_ref[line==="x"?"y":"x"]=otherValue,_ref};var distance=function distance(point1,point2){return Math.sqrt(Math.pow(point2.x-point1.x,2)+Math.pow(point2.y-point1.y,2))};var closest=function closest(target,points){return Math.min.apply(Math,points.map((function(point){return distance(target,point)})))};var apply=function apply(fn){return function(point){return{x:fn(point.x),y:fn(point.y)}}};var executeClip=function(frame,subject){var result=cssBoxModel.getRect({top:Math.max(subject.top,frame.top),right:Math.min(subject.right,frame.right),bottom:Math.min(subject.bottom,frame.bottom),left:Math.max(subject.left,frame.left)});if(result.width<=0||result.height<=0){return null}return result};var offsetByPosition=function offsetByPosition(spacing,point){return{top:spacing.top+point.y,left:spacing.left+point.x,bottom:spacing.bottom+point.y,right:spacing.right+point.x}};var getCorners=function getCorners(spacing){return[{x:spacing.left,y:spacing.top},{x:spacing.right,y:spacing.top},{x:spacing.left,y:spacing.bottom},{x:spacing.right,y:spacing.bottom}]};var noSpacing={top:0,right:0,bottom:0,left:0};var scroll=function scroll(target,frame){if(!frame){return target}return offsetByPosition(target,frame.scroll.diff.displacement)};var increase=function increase(target,axis,withPlaceholder){if(withPlaceholder&&withPlaceholder.increasedBy){var _extends2;return _extends({},target,(_extends2={},_extends2[axis.end]=target[axis.end]+withPlaceholder.increasedBy[axis.line],_extends2))}return target};var clip=function clip(target,frame){if(frame&&frame.shouldClipSubject){return executeClip(frame.pageMarginBox,target)}return cssBoxModel.getRect(target)};var getSubject=function(_ref){var page=_ref.page,withPlaceholder=_ref.withPlaceholder,axis=_ref.axis,frame=_ref.frame;var scrolled=scroll(page.marginBox,frame);var increased=increase(scrolled,axis,withPlaceholder);var clipped=clip(increased,frame);return{page:page,withPlaceholder:withPlaceholder,active:clipped}};var scrollDroppable=function(droppable,newScroll){!droppable.frame?false?undefined:invariant(false):void 0;var scrollable=droppable.frame;var scrollDiff=subtract(newScroll,scrollable.scroll.initial);var scrollDisplacement=negate(scrollDiff);var frame=_extends({},scrollable,{scroll:{initial:scrollable.scroll.initial,current:newScroll,diff:{value:scrollDiff,displacement:scrollDisplacement},max:scrollable.scroll.max}});var subject=getSubject({page:droppable.subject.page,withPlaceholder:droppable.subject.withPlaceholder,axis:droppable.axis,frame:frame});var result=_extends({},droppable,{frame:frame,subject:subject});return result};function isInteger(value){if(Number.isInteger){return Number.isInteger(value)}return typeof value==="number"&&isFinite(value)&&Math.floor(value)===value}function values(map){if(Object.values){return Object.values(map)}return Object.keys(map).map((function(key){return map[key]}))}function findIndex(list,predicate){if(list.findIndex){return list.findIndex(predicate)}for(var i=0;i<list.length;i++){if(predicate(list[i])){return i}}return-1}function find(list,predicate){if(list.find){return list.find(predicate)}var index=findIndex(list,predicate);if(index!==-1){return list[index]}return undefined}function toArray(list){return Array.prototype.slice.call(list)}var toDroppableMap=memoizeOne((function(droppables){return droppables.reduce((function(previous,current){previous[current.descriptor.id]=current;return previous}),{})}));var toDraggableMap=memoizeOne((function(draggables){return draggables.reduce((function(previous,current){previous[current.descriptor.id]=current;return previous}),{})}));var toDroppableList=memoizeOne((function(droppables){return values(droppables)}));var toDraggableList=memoizeOne((function(draggables){return values(draggables)}));var getDraggablesInsideDroppable=memoizeOne((function(droppableId,draggables){var result=toDraggableList(draggables).filter((function(draggable){return droppableId===draggable.descriptor.droppableId})).sort((function(a,b){return a.descriptor.index-b.descriptor.index}));return result}));function tryGetDestination(impact){if(impact.at&&impact.at.type==="REORDER"){return impact.at.destination}return null}function tryGetCombine(impact){if(impact.at&&impact.at.type==="COMBINE"){return impact.at.combine}return null}var removeDraggableFromList=memoizeOne((function(remove,list){return list.filter((function(item){return item.descriptor.id!==remove.descriptor.id}))}));var moveToNextCombine=function(_ref){var isMovingForward=_ref.isMovingForward,draggable=_ref.draggable,destination=_ref.destination,insideDestination=_ref.insideDestination,previousImpact=_ref.previousImpact;if(!destination.isCombineEnabled){return null}var location=tryGetDestination(previousImpact);if(!location){return null}function getImpact(target){var at={type:"COMBINE",combine:{draggableId:target,droppableId:destination.descriptor.id}};return _extends({},previousImpact,{at:at})}var all=previousImpact.displaced.all;var closestId=all.length?all[0]:null;if(isMovingForward){return closestId?getImpact(closestId):null}var withoutDraggable=removeDraggableFromList(draggable,insideDestination);if(!closestId){if(!withoutDraggable.length){return null}var last=withoutDraggable[withoutDraggable.length-1];return getImpact(last.descriptor.id)}var indexOfClosest=findIndex(withoutDraggable,(function(d){return d.descriptor.id===closestId}));!(indexOfClosest!==-1)?false?undefined:invariant(false):void 0;var proposedIndex=indexOfClosest-1;if(proposedIndex<0){return null}var before=withoutDraggable[proposedIndex];return getImpact(before.descriptor.id)};var isHomeOf=function(draggable,destination){return draggable.descriptor.droppableId===destination.descriptor.id};var noDisplacedBy={point:origin,value:0};var emptyGroups={invisible:{},visible:{},all:[]};var noImpact={displaced:emptyGroups,displacedBy:noDisplacedBy,at:null};var isWithin=function(lowerBound,upperBound){return function(value){return lowerBound<=value&&value<=upperBound}};var isPartiallyVisibleThroughFrame=function(frame){var isWithinVertical=isWithin(frame.top,frame.bottom);var isWithinHorizontal=isWithin(frame.left,frame.right);return function(subject){var isContained=isWithinVertical(subject.top)&&isWithinVertical(subject.bottom)&&isWithinHorizontal(subject.left)&&isWithinHorizontal(subject.right);if(isContained){return true}var isPartiallyVisibleVertically=isWithinVertical(subject.top)||isWithinVertical(subject.bottom);var isPartiallyVisibleHorizontally=isWithinHorizontal(subject.left)||isWithinHorizontal(subject.right);var isPartiallyContained=isPartiallyVisibleVertically&&isPartiallyVisibleHorizontally;if(isPartiallyContained){return true}var isBiggerVertically=subject.top<frame.top&&subject.bottom>frame.bottom;var isBiggerHorizontally=subject.left<frame.left&&subject.right>frame.right;var isTargetBiggerThanFrame=isBiggerVertically&&isBiggerHorizontally;if(isTargetBiggerThanFrame){return true}var isTargetBiggerOnOneAxis=isBiggerVertically&&isPartiallyVisibleHorizontally||isBiggerHorizontally&&isPartiallyVisibleVertically;return isTargetBiggerOnOneAxis}};var isTotallyVisibleThroughFrame=function(frame){var isWithinVertical=isWithin(frame.top,frame.bottom);var isWithinHorizontal=isWithin(frame.left,frame.right);return function(subject){var isContained=isWithinVertical(subject.top)&&isWithinVertical(subject.bottom)&&isWithinHorizontal(subject.left)&&isWithinHorizontal(subject.right);return isContained}};var vertical={direction:"vertical",line:"y",crossAxisLine:"x",start:"top",end:"bottom",size:"height",crossAxisStart:"left",crossAxisEnd:"right",crossAxisSize:"width"};var horizontal={direction:"horizontal",line:"x",crossAxisLine:"y",start:"left",end:"right",size:"width",crossAxisStart:"top",crossAxisEnd:"bottom",crossAxisSize:"height"};var isTotallyVisibleThroughFrameOnAxis=function(axis){return function(frame){var isWithinVertical=isWithin(frame.top,frame.bottom);var isWithinHorizontal=isWithin(frame.left,frame.right);return function(subject){if(axis===vertical){return isWithinVertical(subject.top)&&isWithinVertical(subject.bottom)}return isWithinHorizontal(subject.left)&&isWithinHorizontal(subject.right)}}};var getDroppableDisplaced=function getDroppableDisplaced(target,destination){var displacement=destination.frame?destination.frame.scroll.diff.displacement:origin;return offsetByPosition(target,displacement)};var isVisibleInDroppable=function isVisibleInDroppable(target,destination,isVisibleThroughFrameFn){if(!destination.subject.active){return false}return isVisibleThroughFrameFn(destination.subject.active)(target)};var isVisibleInViewport=function isVisibleInViewport(target,viewport,isVisibleThroughFrameFn){return isVisibleThroughFrameFn(viewport)(target)};var isVisible=function isVisible(_ref){var toBeDisplaced=_ref.target,destination=_ref.destination,viewport=_ref.viewport,withDroppableDisplacement=_ref.withDroppableDisplacement,isVisibleThroughFrameFn=_ref.isVisibleThroughFrameFn;var displacedTarget=withDroppableDisplacement?getDroppableDisplaced(toBeDisplaced,destination):toBeDisplaced;return isVisibleInDroppable(displacedTarget,destination,isVisibleThroughFrameFn)&&isVisibleInViewport(displacedTarget,viewport,isVisibleThroughFrameFn)};var isPartiallyVisible=function isPartiallyVisible(args){return isVisible(_extends({},args,{isVisibleThroughFrameFn:isPartiallyVisibleThroughFrame}))};var isTotallyVisible=function isTotallyVisible(args){return isVisible(_extends({},args,{isVisibleThroughFrameFn:isTotallyVisibleThroughFrame}))};var isTotallyVisibleOnAxis=function isTotallyVisibleOnAxis(args){return isVisible(_extends({},args,{isVisibleThroughFrameFn:isTotallyVisibleThroughFrameOnAxis(args.destination.axis)}))};var getShouldAnimate=function getShouldAnimate(id,last,forceShouldAnimate){if(typeof forceShouldAnimate==="boolean"){return forceShouldAnimate}if(!last){return true}var invisible=last.invisible,visible=last.visible;if(invisible[id]){return false}var previous=visible[id];return previous?previous.shouldAnimate:true};function getTarget(draggable,displacedBy){var marginBox=draggable.page.marginBox;var expandBy={top:displacedBy.point.y,right:0,bottom:0,left:displacedBy.point.x};return cssBoxModel.getRect(cssBoxModel.expand(marginBox,expandBy))}function getDisplacementGroups(_ref){var afterDragging=_ref.afterDragging,destination=_ref.destination,displacedBy=_ref.displacedBy,viewport=_ref.viewport,forceShouldAnimate=_ref.forceShouldAnimate,last=_ref.last;return afterDragging.reduce((function process(groups,draggable){var target=getTarget(draggable,displacedBy);var id=draggable.descriptor.id;groups.all.push(id);var isVisible=isPartiallyVisible({target:target,destination:destination,viewport:viewport,withDroppableDisplacement:true});if(!isVisible){groups.invisible[draggable.descriptor.id]=true;return groups}var shouldAnimate=getShouldAnimate(id,last,forceShouldAnimate);var displacement={draggableId:id,shouldAnimate:shouldAnimate};groups.visible[id]=displacement;return groups}),{all:[],visible:{},invisible:{}})}function getIndexOfLastItem(draggables,options){if(!draggables.length){return 0}var indexOfLastItem=draggables[draggables.length-1].descriptor.index;return options.inHomeList?indexOfLastItem:indexOfLastItem+1}function goAtEnd(_ref){var insideDestination=_ref.insideDestination,inHomeList=_ref.inHomeList,displacedBy=_ref.displacedBy,destination=_ref.destination;var newIndex=getIndexOfLastItem(insideDestination,{inHomeList:inHomeList});return{displaced:emptyGroups,displacedBy:displacedBy,at:{type:"REORDER",destination:{droppableId:destination.descriptor.id,index:newIndex}}}}function calculateReorderImpact(_ref2){var draggable=_ref2.draggable,insideDestination=_ref2.insideDestination,destination=_ref2.destination,viewport=_ref2.viewport,displacedBy=_ref2.displacedBy,last=_ref2.last,index=_ref2.index,forceShouldAnimate=_ref2.forceShouldAnimate;var inHomeList=isHomeOf(draggable,destination);if(index==null){return goAtEnd({insideDestination:insideDestination,inHomeList:inHomeList,displacedBy:displacedBy,destination:destination})}var match=find(insideDestination,(function(item){return item.descriptor.index===index}));if(!match){return goAtEnd({insideDestination:insideDestination,inHomeList:inHomeList,displacedBy:displacedBy,destination:destination})}var withoutDragging=removeDraggableFromList(draggable,insideDestination);var sliceFrom=insideDestination.indexOf(match);var impacted=withoutDragging.slice(sliceFrom);var displaced=getDisplacementGroups({afterDragging:impacted,destination:destination,displacedBy:displacedBy,last:last,viewport:viewport.frame,forceShouldAnimate:forceShouldAnimate});return{displaced:displaced,displacedBy:displacedBy,at:{type:"REORDER",destination:{droppableId:destination.descriptor.id,index:index}}}}function didStartAfterCritical(draggableId,afterCritical){return Boolean(afterCritical.effected[draggableId])}var fromCombine=function(_ref){var isMovingForward=_ref.isMovingForward,destination=_ref.destination,draggables=_ref.draggables,combine=_ref.combine,afterCritical=_ref.afterCritical;if(!destination.isCombineEnabled){return null}var combineId=combine.draggableId;var combineWith=draggables[combineId];var combineWithIndex=combineWith.descriptor.index;var didCombineWithStartAfterCritical=didStartAfterCritical(combineId,afterCritical);if(didCombineWithStartAfterCritical){if(isMovingForward){return combineWithIndex}return combineWithIndex-1}if(isMovingForward){return combineWithIndex+1}return combineWithIndex};var fromReorder=function(_ref){var isMovingForward=_ref.isMovingForward,isInHomeList=_ref.isInHomeList,insideDestination=_ref.insideDestination,location=_ref.location;if(!insideDestination.length){return null}var currentIndex=location.index;var proposedIndex=isMovingForward?currentIndex+1:currentIndex-1;var firstIndex=insideDestination[0].descriptor.index;var lastIndex=insideDestination[insideDestination.length-1].descriptor.index;var upperBound=isInHomeList?lastIndex:lastIndex+1;if(proposedIndex<firstIndex){return null}if(proposedIndex>upperBound){return null}return proposedIndex};var moveToNextIndex=function(_ref){var isMovingForward=_ref.isMovingForward,isInHomeList=_ref.isInHomeList,draggable=_ref.draggable,draggables=_ref.draggables,destination=_ref.destination,insideDestination=_ref.insideDestination,previousImpact=_ref.previousImpact,viewport=_ref.viewport,afterCritical=_ref.afterCritical;var wasAt=previousImpact.at;!wasAt?false?undefined:invariant(false):void 0;if(wasAt.type==="REORDER"){var _newIndex=fromReorder({isMovingForward:isMovingForward,isInHomeList:isInHomeList,location:wasAt.destination,insideDestination:insideDestination});if(_newIndex==null){return null}return calculateReorderImpact({draggable:draggable,insideDestination:insideDestination,destination:destination,viewport:viewport,last:previousImpact.displaced,displacedBy:previousImpact.displacedBy,index:_newIndex})}var newIndex=fromCombine({isMovingForward:isMovingForward,destination:destination,displaced:previousImpact.displaced,draggables:draggables,combine:wasAt.combine,afterCritical:afterCritical});if(newIndex==null){return null}return calculateReorderImpact({draggable:draggable,insideDestination:insideDestination,destination:destination,viewport:viewport,last:previousImpact.displaced,displacedBy:previousImpact.displacedBy,index:newIndex})};var getCombinedItemDisplacement=function(_ref){var displaced=_ref.displaced,afterCritical=_ref.afterCritical,combineWith=_ref.combineWith,displacedBy=_ref.displacedBy;var isDisplaced=Boolean(displaced.visible[combineWith]||displaced.invisible[combineWith]);if(didStartAfterCritical(combineWith,afterCritical)){return isDisplaced?origin:negate(displacedBy.point)}return isDisplaced?displacedBy.point:origin};var whenCombining=function(_ref){var afterCritical=_ref.afterCritical,impact=_ref.impact,draggables=_ref.draggables;var combine=tryGetCombine(impact);!combine?false?undefined:invariant(false):void 0;var combineWith=combine.draggableId;var center=draggables[combineWith].page.borderBox.center;var displaceBy=getCombinedItemDisplacement({displaced:impact.displaced,afterCritical:afterCritical,combineWith:combineWith,displacedBy:impact.displacedBy});return add(center,displaceBy)};var distanceFromStartToBorderBoxCenter=function distanceFromStartToBorderBoxCenter(axis,box){return box.margin[axis.start]+box.borderBox[axis.size]/2};var distanceFromEndToBorderBoxCenter=function distanceFromEndToBorderBoxCenter(axis,box){return box.margin[axis.end]+box.borderBox[axis.size]/2};var getCrossAxisBorderBoxCenter=function getCrossAxisBorderBoxCenter(axis,target,isMoving){return target[axis.crossAxisStart]+isMoving.margin[axis.crossAxisStart]+isMoving.borderBox[axis.crossAxisSize]/2};var goAfter=function goAfter(_ref){var axis=_ref.axis,moveRelativeTo=_ref.moveRelativeTo,isMoving=_ref.isMoving;return patch(axis.line,moveRelativeTo.marginBox[axis.end]+distanceFromStartToBorderBoxCenter(axis,isMoving),getCrossAxisBorderBoxCenter(axis,moveRelativeTo.marginBox,isMoving))};var goBefore=function goBefore(_ref2){var axis=_ref2.axis,moveRelativeTo=_ref2.moveRelativeTo,isMoving=_ref2.isMoving;return patch(axis.line,moveRelativeTo.marginBox[axis.start]-distanceFromEndToBorderBoxCenter(axis,isMoving),getCrossAxisBorderBoxCenter(axis,moveRelativeTo.marginBox,isMoving))};var goIntoStart=function goIntoStart(_ref3){var axis=_ref3.axis,moveInto=_ref3.moveInto,isMoving=_ref3.isMoving;return patch(axis.line,moveInto.contentBox[axis.start]+distanceFromStartToBorderBoxCenter(axis,isMoving),getCrossAxisBorderBoxCenter(axis,moveInto.contentBox,isMoving))};var whenReordering=function(_ref){var impact=_ref.impact,draggable=_ref.draggable,draggables=_ref.draggables,droppable=_ref.droppable,afterCritical=_ref.afterCritical;var insideDestination=getDraggablesInsideDroppable(droppable.descriptor.id,draggables);var draggablePage=draggable.page;var axis=droppable.axis;if(!insideDestination.length){return goIntoStart({axis:axis,moveInto:droppable.page,isMoving:draggablePage})}var displaced=impact.displaced,displacedBy=impact.displacedBy;var closestAfter=displaced.all[0];if(closestAfter){var closest=draggables[closestAfter];if(didStartAfterCritical(closestAfter,afterCritical)){return goBefore({axis:axis,moveRelativeTo:closest.page,isMoving:draggablePage})}var withDisplacement=cssBoxModel.offset(closest.page,displacedBy.point);return goBefore({axis:axis,moveRelativeTo:withDisplacement,isMoving:draggablePage})}var last=insideDestination[insideDestination.length-1];if(last.descriptor.id===draggable.descriptor.id){return draggablePage.borderBox.center}if(didStartAfterCritical(last.descriptor.id,afterCritical)){var page=cssBoxModel.offset(last.page,negate(afterCritical.displacedBy.point));return goAfter({axis:axis,moveRelativeTo:page,isMoving:draggablePage})}return goAfter({axis:axis,moveRelativeTo:last.page,isMoving:draggablePage})};var withDroppableDisplacement=function(droppable,point){var frame=droppable.frame;if(!frame){return point}return add(point,frame.scroll.diff.displacement)};var getResultWithoutDroppableDisplacement=function getResultWithoutDroppableDisplacement(_ref){var impact=_ref.impact,draggable=_ref.draggable,droppable=_ref.droppable,draggables=_ref.draggables,afterCritical=_ref.afterCritical;var original=draggable.page.borderBox.center;var at=impact.at;if(!droppable){return original}if(!at){return original}if(at.type==="REORDER"){return whenReordering({impact:impact,draggable:draggable,draggables:draggables,droppable:droppable,afterCritical:afterCritical})}return whenCombining({impact:impact,draggables:draggables,afterCritical:afterCritical})};var getPageBorderBoxCenterFromImpact=function(args){var withoutDisplacement=getResultWithoutDroppableDisplacement(args);var droppable=args.droppable;var withDisplacement=droppable?withDroppableDisplacement(droppable,withoutDisplacement):withoutDisplacement;return withDisplacement};var scrollViewport=function(viewport,newScroll){var diff=subtract(newScroll,viewport.scroll.initial);var displacement=negate(diff);var frame=cssBoxModel.getRect({top:newScroll.y,bottom:newScroll.y+viewport.frame.height,left:newScroll.x,right:newScroll.x+viewport.frame.width});var updated={frame:frame,scroll:{initial:viewport.scroll.initial,max:viewport.scroll.max,current:newScroll,diff:{value:diff,displacement:displacement}}};return updated};function getDraggables(ids,draggables){return ids.map((function(id){return draggables[id]}))}function tryGetVisible(id,groups){for(var i=0;i<groups.length;i++){var displacement=groups[i].visible[id];if(displacement){return displacement}}return null}var speculativelyIncrease=function(_ref){var impact=_ref.impact,viewport=_ref.viewport,destination=_ref.destination,draggables=_ref.draggables,maxScrollChange=_ref.maxScrollChange;var scrolledViewport=scrollViewport(viewport,add(viewport.scroll.current,maxScrollChange));var scrolledDroppable=destination.frame?scrollDroppable(destination,add(destination.frame.scroll.current,maxScrollChange)):destination;var last=impact.displaced;var withViewportScroll=getDisplacementGroups({afterDragging:getDraggables(last.all,draggables),destination:destination,displacedBy:impact.displacedBy,viewport:scrolledViewport.frame,last:last,forceShouldAnimate:false});var withDroppableScroll=getDisplacementGroups({afterDragging:getDraggables(last.all,draggables),destination:scrolledDroppable,displacedBy:impact.displacedBy,viewport:viewport.frame,last:last,forceShouldAnimate:false});var invisible={};var visible={};var groups=[last,withViewportScroll,withDroppableScroll];last.all.forEach((function(id){var displacement=tryGetVisible(id,groups);if(displacement){visible[id]=displacement;return}invisible[id]=true}));var newImpact=_extends({},impact,{displaced:{all:last.all,invisible:invisible,visible:visible}});return newImpact};var withViewportDisplacement=function(viewport,point){return add(viewport.scroll.diff.displacement,point)};var getClientFromPageBorderBoxCenter=function(_ref){var pageBorderBoxCenter=_ref.pageBorderBoxCenter,draggable=_ref.draggable,viewport=_ref.viewport;var withoutPageScrollChange=withViewportDisplacement(viewport,pageBorderBoxCenter);var offset=subtract(withoutPageScrollChange,draggable.page.borderBox.center);return add(draggable.client.borderBox.center,offset)};var isTotallyVisibleInNewLocation=function(_ref){var draggable=_ref.draggable,destination=_ref.destination,newPageBorderBoxCenter=_ref.newPageBorderBoxCenter,viewport=_ref.viewport,withDroppableDisplacement=_ref.withDroppableDisplacement,_ref$onlyOnMainAxis=_ref.onlyOnMainAxis,onlyOnMainAxis=_ref$onlyOnMainAxis===void 0?false:_ref$onlyOnMainAxis;var changeNeeded=subtract(newPageBorderBoxCenter,draggable.page.borderBox.center);var shifted=offsetByPosition(draggable.page.borderBox,changeNeeded);var args={target:shifted,destination:destination,withDroppableDisplacement:withDroppableDisplacement,viewport:viewport};return onlyOnMainAxis?isTotallyVisibleOnAxis(args):isTotallyVisible(args)};var moveToNextPlace=function(_ref){var isMovingForward=_ref.isMovingForward,draggable=_ref.draggable,destination=_ref.destination,draggables=_ref.draggables,previousImpact=_ref.previousImpact,viewport=_ref.viewport,previousPageBorderBoxCenter=_ref.previousPageBorderBoxCenter,previousClientSelection=_ref.previousClientSelection,afterCritical=_ref.afterCritical;if(!destination.isEnabled){return null}var insideDestination=getDraggablesInsideDroppable(destination.descriptor.id,draggables);var isInHomeList=isHomeOf(draggable,destination);var impact=moveToNextCombine({isMovingForward:isMovingForward,draggable:draggable,destination:destination,insideDestination:insideDestination,previousImpact:previousImpact})||moveToNextIndex({isMovingForward:isMovingForward,isInHomeList:isInHomeList,draggable:draggable,draggables:draggables,destination:destination,insideDestination:insideDestination,previousImpact:previousImpact,viewport:viewport,afterCritical:afterCritical});if(!impact){return null}var pageBorderBoxCenter=getPageBorderBoxCenterFromImpact({impact:impact,draggable:draggable,droppable:destination,draggables:draggables,afterCritical:afterCritical});var isVisibleInNewLocation=isTotallyVisibleInNewLocation({draggable:draggable,destination:destination,newPageBorderBoxCenter:pageBorderBoxCenter,viewport:viewport.frame,withDroppableDisplacement:false,onlyOnMainAxis:true});if(isVisibleInNewLocation){var clientSelection=getClientFromPageBorderBoxCenter({pageBorderBoxCenter:pageBorderBoxCenter,draggable:draggable,viewport:viewport});return{clientSelection:clientSelection,impact:impact,scrollJumpRequest:null}}var distance=subtract(pageBorderBoxCenter,previousPageBorderBoxCenter);var cautious=speculativelyIncrease({impact:impact,viewport:viewport,destination:destination,draggables:draggables,maxScrollChange:distance});return{clientSelection:previousClientSelection,impact:cautious,scrollJumpRequest:distance}};var getKnownActive=function getKnownActive(droppable){var rect=droppable.subject.active;!rect?false?undefined:invariant(false):void 0;return rect};var getBestCrossAxisDroppable=function(_ref){var isMovingForward=_ref.isMovingForward,pageBorderBoxCenter=_ref.pageBorderBoxCenter,source=_ref.source,droppables=_ref.droppables,viewport=_ref.viewport;var active=source.subject.active;if(!active){return null}var axis=source.axis;var isBetweenSourceClipped=isWithin(active[axis.start],active[axis.end]);var candidates=toDroppableList(droppables).filter((function(droppable){return droppable!==source})).filter((function(droppable){return droppable.isEnabled})).filter((function(droppable){return Boolean(droppable.subject.active)})).filter((function(droppable){return isPartiallyVisibleThroughFrame(viewport.frame)(getKnownActive(droppable))})).filter((function(droppable){var activeOfTarget=getKnownActive(droppable);if(isMovingForward){return active[axis.crossAxisEnd]<activeOfTarget[axis.crossAxisEnd]}return activeOfTarget[axis.crossAxisStart]<active[axis.crossAxisStart]})).filter((function(droppable){var activeOfTarget=getKnownActive(droppable);var isBetweenDestinationClipped=isWithin(activeOfTarget[axis.start],activeOfTarget[axis.end]);return isBetweenSourceClipped(activeOfTarget[axis.start])||isBetweenSourceClipped(activeOfTarget[axis.end])||isBetweenDestinationClipped(active[axis.start])||isBetweenDestinationClipped(active[axis.end])})).sort((function(a,b){var first=getKnownActive(a)[axis.crossAxisStart];var second=getKnownActive(b)[axis.crossAxisStart];if(isMovingForward){return first-second}return second-first})).filter((function(droppable,index,array){return getKnownActive(droppable)[axis.crossAxisStart]===getKnownActive(array[0])[axis.crossAxisStart]}));if(!candidates.length){return null}if(candidates.length===1){return candidates[0]}var contains=candidates.filter((function(droppable){var isWithinDroppable=isWithin(getKnownActive(droppable)[axis.start],getKnownActive(droppable)[axis.end]);return isWithinDroppable(pageBorderBoxCenter[axis.line])}));if(contains.length===1){return contains[0]}if(contains.length>1){return contains.sort((function(a,b){return getKnownActive(a)[axis.start]-getKnownActive(b)[axis.start]}))[0]}return candidates.sort((function(a,b){var first=closest(pageBorderBoxCenter,getCorners(getKnownActive(a)));var second=closest(pageBorderBoxCenter,getCorners(getKnownActive(b)));if(first!==second){return first-second}return getKnownActive(a)[axis.start]-getKnownActive(b)[axis.start]}))[0]};var getCurrentPageBorderBoxCenter=function getCurrentPageBorderBoxCenter(draggable,afterCritical){var original=draggable.page.borderBox.center;return didStartAfterCritical(draggable.descriptor.id,afterCritical)?subtract(original,afterCritical.displacedBy.point):original};var getCurrentPageBorderBox=function getCurrentPageBorderBox(draggable,afterCritical){var original=draggable.page.borderBox;return didStartAfterCritical(draggable.descriptor.id,afterCritical)?offsetByPosition(original,negate(afterCritical.displacedBy.point)):original};var getClosestDraggable=function(_ref){var pageBorderBoxCenter=_ref.pageBorderBoxCenter,viewport=_ref.viewport,destination=_ref.destination,insideDestination=_ref.insideDestination,afterCritical=_ref.afterCritical;var sorted=insideDestination.filter((function(draggable){return isTotallyVisible({target:getCurrentPageBorderBox(draggable,afterCritical),destination:destination,viewport:viewport.frame,withDroppableDisplacement:true})})).sort((function(a,b){var distanceToA=distance(pageBorderBoxCenter,withDroppableDisplacement(destination,getCurrentPageBorderBoxCenter(a,afterCritical)));var distanceToB=distance(pageBorderBoxCenter,withDroppableDisplacement(destination,getCurrentPageBorderBoxCenter(b,afterCritical)));if(distanceToA<distanceToB){return-1}if(distanceToB<distanceToA){return 1}return a.descriptor.index-b.descriptor.index}));return sorted[0]||null};var getDisplacedBy=memoizeOne((function getDisplacedBy(axis,displaceBy){var displacement=displaceBy[axis.line];return{value:displacement,point:patch(axis.line,displacement)}}));var getRequiredGrowthForPlaceholder=function getRequiredGrowthForPlaceholder(droppable,placeholderSize,draggables){var axis=droppable.axis;if(droppable.descriptor.mode==="virtual"){return patch(axis.line,placeholderSize[axis.line])}var availableSpace=droppable.subject.page.contentBox[axis.size];var insideDroppable=getDraggablesInsideDroppable(droppable.descriptor.id,draggables);var spaceUsed=insideDroppable.reduce((function(sum,dimension){return sum+dimension.client.marginBox[axis.size]}),0);var requiredSpace=spaceUsed+placeholderSize[axis.line];var needsToGrowBy=requiredSpace-availableSpace;if(needsToGrowBy<=0){return null}return patch(axis.line,needsToGrowBy)};var withMaxScroll=function withMaxScroll(frame,max){return _extends({},frame,{scroll:_extends({},frame.scroll,{max:max})})};var addPlaceholder=function addPlaceholder(droppable,draggable,draggables){var frame=droppable.frame;!!isHomeOf(draggable,droppable)?false?undefined:invariant(false):void 0;!!droppable.subject.withPlaceholder?false?undefined:invariant(false):void 0;var placeholderSize=getDisplacedBy(droppable.axis,draggable.displaceBy).point;var requiredGrowth=getRequiredGrowthForPlaceholder(droppable,placeholderSize,draggables);var added={placeholderSize:placeholderSize,increasedBy:requiredGrowth,oldFrameMaxScroll:droppable.frame?droppable.frame.scroll.max:null};if(!frame){var _subject=getSubject({page:droppable.subject.page,withPlaceholder:added,axis:droppable.axis,frame:droppable.frame});return _extends({},droppable,{subject:_subject})}var maxScroll=requiredGrowth?add(frame.scroll.max,requiredGrowth):frame.scroll.max;var newFrame=withMaxScroll(frame,maxScroll);var subject=getSubject({page:droppable.subject.page,withPlaceholder:added,axis:droppable.axis,frame:newFrame});return _extends({},droppable,{subject:subject,frame:newFrame})};var removePlaceholder=function removePlaceholder(droppable){var added=droppable.subject.withPlaceholder;!added?false?undefined:invariant(false):void 0;var frame=droppable.frame;if(!frame){var _subject2=getSubject({page:droppable.subject.page,axis:droppable.axis,frame:null,withPlaceholder:null});return _extends({},droppable,{subject:_subject2})}var oldMaxScroll=added.oldFrameMaxScroll;!oldMaxScroll?false?undefined:invariant(false):void 0;var newFrame=withMaxScroll(frame,oldMaxScroll);var subject=getSubject({page:droppable.subject.page,axis:droppable.axis,frame:newFrame,withPlaceholder:null});return _extends({},droppable,{subject:subject,frame:newFrame})};var moveToNewDroppable=function(_ref){var previousPageBorderBoxCenter=_ref.previousPageBorderBoxCenter,moveRelativeTo=_ref.moveRelativeTo,insideDestination=_ref.insideDestination,draggable=_ref.draggable,draggables=_ref.draggables,destination=_ref.destination,viewport=_ref.viewport,afterCritical=_ref.afterCritical;if(!moveRelativeTo){if(insideDestination.length){return null}var proposed={displaced:emptyGroups,displacedBy:noDisplacedBy,at:{type:"REORDER",destination:{droppableId:destination.descriptor.id,index:0}}};var proposedPageBorderBoxCenter=getPageBorderBoxCenterFromImpact({impact:proposed,draggable:draggable,droppable:destination,draggables:draggables,afterCritical:afterCritical});var withPlaceholder=isHomeOf(draggable,destination)?destination:addPlaceholder(destination,draggable,draggables);var isVisibleInNewLocation=isTotallyVisibleInNewLocation({draggable:draggable,destination:withPlaceholder,newPageBorderBoxCenter:proposedPageBorderBoxCenter,viewport:viewport.frame,withDroppableDisplacement:false,onlyOnMainAxis:true});return isVisibleInNewLocation?proposed:null}var isGoingBeforeTarget=Boolean(previousPageBorderBoxCenter[destination.axis.line]<=moveRelativeTo.page.borderBox.center[destination.axis.line]);var proposedIndex=function(){var relativeTo=moveRelativeTo.descriptor.index;if(moveRelativeTo.descriptor.id===draggable.descriptor.id){return relativeTo}if(isGoingBeforeTarget){return relativeTo}return relativeTo+1}();var displacedBy=getDisplacedBy(destination.axis,draggable.displaceBy);return calculateReorderImpact({draggable:draggable,insideDestination:insideDestination,destination:destination,viewport:viewport,displacedBy:displacedBy,last:emptyGroups,index:proposedIndex})};var moveCrossAxis=function(_ref){var isMovingForward=_ref.isMovingForward,previousPageBorderBoxCenter=_ref.previousPageBorderBoxCenter,draggable=_ref.draggable,isOver=_ref.isOver,draggables=_ref.draggables,droppables=_ref.droppables,viewport=_ref.viewport,afterCritical=_ref.afterCritical;var destination=getBestCrossAxisDroppable({isMovingForward:isMovingForward,pageBorderBoxCenter:previousPageBorderBoxCenter,source:isOver,droppables:droppables,viewport:viewport});if(!destination){return null}var insideDestination=getDraggablesInsideDroppable(destination.descriptor.id,draggables);var moveRelativeTo=getClosestDraggable({pageBorderBoxCenter:previousPageBorderBoxCenter,viewport:viewport,destination:destination,insideDestination:insideDestination,afterCritical:afterCritical});var impact=moveToNewDroppable({previousPageBorderBoxCenter:previousPageBorderBoxCenter,destination:destination,draggable:draggable,draggables:draggables,moveRelativeTo:moveRelativeTo,insideDestination:insideDestination,viewport:viewport,afterCritical:afterCritical});if(!impact){return null}var pageBorderBoxCenter=getPageBorderBoxCenterFromImpact({impact:impact,draggable:draggable,droppable:destination,draggables:draggables,afterCritical:afterCritical});var clientSelection=getClientFromPageBorderBoxCenter({pageBorderBoxCenter:pageBorderBoxCenter,draggable:draggable,viewport:viewport});return{clientSelection:clientSelection,impact:impact,scrollJumpRequest:null}};var whatIsDraggedOver=function(impact){var at=impact.at;if(!at){return null}if(at.type==="REORDER"){return at.destination.droppableId}return at.combine.droppableId};var getDroppableOver=function getDroppableOver(impact,droppables){var id=whatIsDraggedOver(impact);return id?droppables[id]:null};var moveInDirection=function(_ref){var state=_ref.state,type=_ref.type;var isActuallyOver=getDroppableOver(state.impact,state.dimensions.droppables);var isMainAxisMovementAllowed=Boolean(isActuallyOver);var home=state.dimensions.droppables[state.critical.droppable.id];var isOver=isActuallyOver||home;var direction=isOver.axis.direction;var isMovingOnMainAxis=direction==="vertical"&&(type==="MOVE_UP"||type==="MOVE_DOWN")||direction==="horizontal"&&(type==="MOVE_LEFT"||type==="MOVE_RIGHT");if(isMovingOnMainAxis&&!isMainAxisMovementAllowed){return null}var isMovingForward=type==="MOVE_DOWN"||type==="MOVE_RIGHT";var draggable=state.dimensions.draggables[state.critical.draggable.id];var previousPageBorderBoxCenter=state.current.page.borderBoxCenter;var _state$dimensions=state.dimensions,draggables=_state$dimensions.draggables,droppables=_state$dimensions.droppables;return isMovingOnMainAxis?moveToNextPlace({isMovingForward:isMovingForward,previousPageBorderBoxCenter:previousPageBorderBoxCenter,draggable:draggable,destination:isOver,draggables:draggables,viewport:state.viewport,previousClientSelection:state.current.client.selection,previousImpact:state.impact,afterCritical:state.afterCritical}):moveCrossAxis({isMovingForward:isMovingForward,previousPageBorderBoxCenter:previousPageBorderBoxCenter,draggable:draggable,isOver:isOver,draggables:draggables,droppables:droppables,viewport:state.viewport,afterCritical:state.afterCritical})};function isMovementAllowed(state){return state.phase==="DRAGGING"||state.phase==="COLLECTING"}function isPositionInFrame(frame){var isWithinVertical=isWithin(frame.top,frame.bottom);var isWithinHorizontal=isWithin(frame.left,frame.right);return function run(point){return isWithinVertical(point.y)&&isWithinHorizontal(point.x)}}function getHasOverlap(first,second){return first.left<second.right&&first.right>second.left&&first.top<second.bottom&&first.bottom>second.top}function getFurthestAway(_ref){var pageBorderBox=_ref.pageBorderBox,draggable=_ref.draggable,candidates=_ref.candidates;var startCenter=draggable.page.borderBox.center;var sorted=candidates.map((function(candidate){var axis=candidate.axis;var target=patch(candidate.axis.line,pageBorderBox.center[axis.line],candidate.page.borderBox.center[axis.crossAxisLine]);return{id:candidate.descriptor.id,distance:distance(startCenter,target)}})).sort((function(a,b){return b.distance-a.distance}));return sorted[0]?sorted[0].id:null}function getDroppableOver$1(_ref2){var pageBorderBox=_ref2.pageBorderBox,draggable=_ref2.draggable,droppables=_ref2.droppables;var candidates=toDroppableList(droppables).filter((function(item){if(!item.isEnabled){return false}var active=item.subject.active;if(!active){return false}if(!getHasOverlap(pageBorderBox,active)){return false}if(isPositionInFrame(active)(pageBorderBox.center)){return true}var axis=item.axis;var childCenter=active.center[axis.crossAxisLine];var crossAxisStart=pageBorderBox[axis.crossAxisStart];var crossAxisEnd=pageBorderBox[axis.crossAxisEnd];var isContained=isWithin(active[axis.crossAxisStart],active[axis.crossAxisEnd]);var isStartContained=isContained(crossAxisStart);var isEndContained=isContained(crossAxisEnd);if(!isStartContained&&!isEndContained){return true}if(isStartContained){return crossAxisStart<childCenter}return crossAxisEnd>childCenter}));if(!candidates.length){return null}if(candidates.length===1){return candidates[0].descriptor.id}return getFurthestAway({pageBorderBox:pageBorderBox,draggable:draggable,candidates:candidates})}var offsetRectByPosition=function offsetRectByPosition(rect,point){return cssBoxModel.getRect(offsetByPosition(rect,point))};var withDroppableScroll=function(droppable,area){var frame=droppable.frame;if(!frame){return area}return offsetRectByPosition(area,frame.scroll.diff.value)};function getIsDisplaced(_ref){var displaced=_ref.displaced,id=_ref.id;return Boolean(displaced.visible[id]||displaced.invisible[id])}function atIndex(_ref){var draggable=_ref.draggable,closest=_ref.closest,inHomeList=_ref.inHomeList;if(!closest){return null}if(!inHomeList){return closest.descriptor.index}if(closest.descriptor.index>draggable.descriptor.index){return closest.descriptor.index-1}return closest.descriptor.index}var getReorderImpact=function(_ref2){var targetRect=_ref2.pageBorderBoxWithDroppableScroll,draggable=_ref2.draggable,destination=_ref2.destination,insideDestination=_ref2.insideDestination,last=_ref2.last,viewport=_ref2.viewport,afterCritical=_ref2.afterCritical;var axis=destination.axis;var displacedBy=getDisplacedBy(destination.axis,draggable.displaceBy);var displacement=displacedBy.value;var targetStart=targetRect[axis.start];var targetEnd=targetRect[axis.end];var withoutDragging=removeDraggableFromList(draggable,insideDestination);var closest=find(withoutDragging,(function(child){var id=child.descriptor.id;var childCenter=child.page.borderBox.center[axis.line];var didStartAfterCritical$1=didStartAfterCritical(id,afterCritical);var isDisplaced=getIsDisplaced({displaced:last,id:id});if(didStartAfterCritical$1){if(isDisplaced){return targetEnd<=childCenter}return targetStart<childCenter-displacement}if(isDisplaced){return targetEnd<=childCenter+displacement}return targetStart<childCenter}));var newIndex=atIndex({draggable:draggable,closest:closest,inHomeList:isHomeOf(draggable,destination)});return calculateReorderImpact({draggable:draggable,insideDestination:insideDestination,destination:destination,viewport:viewport,last:last,displacedBy:displacedBy,index:newIndex})};var combineThresholdDivisor=4;var getCombineImpact=function(_ref){var draggable=_ref.draggable,targetRect=_ref.pageBorderBoxWithDroppableScroll,previousImpact=_ref.previousImpact,destination=_ref.destination,insideDestination=_ref.insideDestination,afterCritical=_ref.afterCritical;if(!destination.isCombineEnabled){return null}var axis=destination.axis;var displacedBy=getDisplacedBy(destination.axis,draggable.displaceBy);var displacement=displacedBy.value;var targetStart=targetRect[axis.start];var targetEnd=targetRect[axis.end];var withoutDragging=removeDraggableFromList(draggable,insideDestination);var combineWith=find(withoutDragging,(function(child){var id=child.descriptor.id;var childRect=child.page.borderBox;var childSize=childRect[axis.size];var threshold=childSize/combineThresholdDivisor;var didStartAfterCritical$1=didStartAfterCritical(id,afterCritical);var isDisplaced=getIsDisplaced({displaced:previousImpact.displaced,id:id});if(didStartAfterCritical$1){if(isDisplaced){return targetEnd>childRect[axis.start]+threshold&&targetEnd<childRect[axis.end]-threshold}return targetStart>childRect[axis.start]-displacement+threshold&&targetStart<childRect[axis.end]-displacement-threshold}if(isDisplaced){return targetEnd>childRect[axis.start]+displacement+threshold&&targetEnd<childRect[axis.end]+displacement-threshold}return targetStart>childRect[axis.start]+threshold&&targetStart<childRect[axis.end]-threshold}));if(!combineWith){return null}var impact={displacedBy:displacedBy,displaced:previousImpact.displaced,at:{type:"COMBINE",combine:{draggableId:combineWith.descriptor.id,droppableId:destination.descriptor.id}}};return impact};var getDragImpact=function(_ref){var pageOffset=_ref.pageOffset,draggable=_ref.draggable,draggables=_ref.draggables,droppables=_ref.droppables,previousImpact=_ref.previousImpact,viewport=_ref.viewport,afterCritical=_ref.afterCritical;var pageBorderBox=offsetRectByPosition(draggable.page.borderBox,pageOffset);var destinationId=getDroppableOver$1({pageBorderBox:pageBorderBox,draggable:draggable,droppables:droppables});if(!destinationId){return noImpact}var destination=droppables[destinationId];var insideDestination=getDraggablesInsideDroppable(destination.descriptor.id,draggables);var pageBorderBoxWithDroppableScroll=withDroppableScroll(destination,pageBorderBox);return getCombineImpact({pageBorderBoxWithDroppableScroll:pageBorderBoxWithDroppableScroll,draggable:draggable,previousImpact:previousImpact,destination:destination,insideDestination:insideDestination,afterCritical:afterCritical})||getReorderImpact({pageBorderBoxWithDroppableScroll:pageBorderBoxWithDroppableScroll,draggable:draggable,destination:destination,insideDestination:insideDestination,last:previousImpact.displaced,viewport:viewport,afterCritical:afterCritical})};var patchDroppableMap=function(droppables,updated){var _extends2;return _extends({},droppables,(_extends2={},_extends2[updated.descriptor.id]=updated,_extends2))};var clearUnusedPlaceholder=function clearUnusedPlaceholder(_ref){var previousImpact=_ref.previousImpact,impact=_ref.impact,droppables=_ref.droppables;var last=whatIsDraggedOver(previousImpact);var now=whatIsDraggedOver(impact);if(!last){return droppables}if(last===now){return droppables}var lastDroppable=droppables[last];if(!lastDroppable.subject.withPlaceholder){return droppables}var updated=removePlaceholder(lastDroppable);return patchDroppableMap(droppables,updated)};var recomputePlaceholders=function(_ref2){var draggable=_ref2.draggable,draggables=_ref2.draggables,droppables=_ref2.droppables,previousImpact=_ref2.previousImpact,impact=_ref2.impact;var cleaned=clearUnusedPlaceholder({previousImpact:previousImpact,impact:impact,droppables:droppables});var isOver=whatIsDraggedOver(impact);if(!isOver){return cleaned}var droppable=droppables[isOver];if(isHomeOf(draggable,droppable)){return cleaned}if(droppable.subject.withPlaceholder){return cleaned}var patched=addPlaceholder(droppable,draggable,draggables);return patchDroppableMap(cleaned,patched)};var update=function(_ref){var state=_ref.state,forcedClientSelection=_ref.clientSelection,forcedDimensions=_ref.dimensions,forcedViewport=_ref.viewport,forcedImpact=_ref.impact,scrollJumpRequest=_ref.scrollJumpRequest;var viewport=forcedViewport||state.viewport;var dimensions=forcedDimensions||state.dimensions;var clientSelection=forcedClientSelection||state.current.client.selection;var offset=subtract(clientSelection,state.initial.client.selection);var client={offset:offset,selection:clientSelection,borderBoxCenter:add(state.initial.client.borderBoxCenter,offset)};var page={selection:add(client.selection,viewport.scroll.current),borderBoxCenter:add(client.borderBoxCenter,viewport.scroll.current),offset:add(client.offset,viewport.scroll.diff.value)};var current={client:client,page:page};if(state.phase==="COLLECTING"){return _extends({phase:"COLLECTING"},state,{dimensions:dimensions,viewport:viewport,current:current})}var draggable=dimensions.draggables[state.critical.draggable.id];var newImpact=forcedImpact||getDragImpact({pageOffset:page.offset,draggable:draggable,draggables:dimensions.draggables,droppables:dimensions.droppables,previousImpact:state.impact,viewport:viewport,afterCritical:state.afterCritical});var withUpdatedPlaceholders=recomputePlaceholders({draggable:draggable,impact:newImpact,previousImpact:state.impact,draggables:dimensions.draggables,droppables:dimensions.droppables});var result=_extends({},state,{current:current,dimensions:{draggables:dimensions.draggables,droppables:withUpdatedPlaceholders},impact:newImpact,viewport:viewport,scrollJumpRequest:scrollJumpRequest||null,forceShouldAnimate:scrollJumpRequest?false:null});return result};function getDraggables$1(ids,draggables){return ids.map((function(id){return draggables[id]}))}var recompute=function(_ref){var impact=_ref.impact,viewport=_ref.viewport,draggables=_ref.draggables,destination=_ref.destination,forceShouldAnimate=_ref.forceShouldAnimate;var last=impact.displaced;var afterDragging=getDraggables$1(last.all,draggables);var displaced=getDisplacementGroups({afterDragging:afterDragging,destination:destination,displacedBy:impact.displacedBy,viewport:viewport.frame,forceShouldAnimate:forceShouldAnimate,last:last});return _extends({},impact,{displaced:displaced})};var getClientBorderBoxCenter=function(_ref){var impact=_ref.impact,draggable=_ref.draggable,droppable=_ref.droppable,draggables=_ref.draggables,viewport=_ref.viewport,afterCritical=_ref.afterCritical;var pageBorderBoxCenter=getPageBorderBoxCenterFromImpact({impact:impact,draggable:draggable,draggables:draggables,droppable:droppable,afterCritical:afterCritical});return getClientFromPageBorderBoxCenter({pageBorderBoxCenter:pageBorderBoxCenter,draggable:draggable,viewport:viewport})};var refreshSnap=function(_ref){var state=_ref.state,forcedDimensions=_ref.dimensions,forcedViewport=_ref.viewport;!(state.movementMode==="SNAP")?false?undefined:invariant(false):void 0;var needsVisibilityCheck=state.impact;var viewport=forcedViewport||state.viewport;var dimensions=forcedDimensions||state.dimensions;var draggables=dimensions.draggables,droppables=dimensions.droppables;var draggable=draggables[state.critical.draggable.id];var isOver=whatIsDraggedOver(needsVisibilityCheck);!isOver?false?undefined:invariant(false):void 0;var destination=droppables[isOver];var impact=recompute({impact:needsVisibilityCheck,viewport:viewport,destination:destination,draggables:draggables});var clientSelection=getClientBorderBoxCenter({impact:impact,draggable:draggable,droppable:destination,draggables:draggables,viewport:viewport,afterCritical:state.afterCritical});return update({impact:impact,clientSelection:clientSelection,state:state,dimensions:dimensions,viewport:viewport})};var getHomeLocation=function(descriptor){return{index:descriptor.index,droppableId:descriptor.droppableId}};var getLiftEffect=function(_ref){var draggable=_ref.draggable,home=_ref.home,draggables=_ref.draggables,viewport=_ref.viewport;var displacedBy=getDisplacedBy(home.axis,draggable.displaceBy);var insideHome=getDraggablesInsideDroppable(home.descriptor.id,draggables);var rawIndex=insideHome.indexOf(draggable);!(rawIndex!==-1)?false?undefined:invariant(false):void 0;var afterDragging=insideHome.slice(rawIndex+1);var effected=afterDragging.reduce((function(previous,item){previous[item.descriptor.id]=true;return previous}),{});var afterCritical={inVirtualList:home.descriptor.mode==="virtual",displacedBy:displacedBy,effected:effected};var displaced=getDisplacementGroups({afterDragging:afterDragging,destination:home,displacedBy:displacedBy,last:null,viewport:viewport.frame,forceShouldAnimate:false});var impact={displaced:displaced,displacedBy:displacedBy,at:{type:"REORDER",destination:getHomeLocation(draggable.descriptor)}};return{impact:impact,afterCritical:afterCritical}};var patchDimensionMap=function(dimensions,updated){return{draggables:dimensions.draggables,droppables:patchDroppableMap(dimensions.droppables,updated)}};var start=function start(key){if(false){}};var finish=function finish(key){if(false){}};var offsetDraggable=function(_ref){var draggable=_ref.draggable,offset=_ref.offset,initialWindowScroll=_ref.initialWindowScroll;var client=cssBoxModel.offset(draggable.client,offset);var page=cssBoxModel.withScroll(client,initialWindowScroll);var moved=_extends({},draggable,{placeholder:_extends({},draggable.placeholder,{client:client}),client:client,page:page});return moved};var getFrame=function(droppable){var frame=droppable.frame;!frame?false?undefined:invariant(false):void 0;return frame};var adjustAdditionsForScrollChanges=function(_ref){var additions=_ref.additions,updatedDroppables=_ref.updatedDroppables,viewport=_ref.viewport;var windowScrollChange=viewport.scroll.diff.value;return additions.map((function(draggable){var droppableId=draggable.descriptor.droppableId;var modified=updatedDroppables[droppableId];var frame=getFrame(modified);var droppableScrollChange=frame.scroll.diff.value;var totalChange=add(windowScrollChange,droppableScrollChange);var moved=offsetDraggable({draggable:draggable,offset:totalChange,initialWindowScroll:viewport.scroll.initial});return moved}))};var publishWhileDraggingInVirtual=function(_ref){var state=_ref.state,published=_ref.published;start();var withScrollChange=published.modified.map((function(update){var existing=state.dimensions.droppables[update.droppableId];var scrolled=scrollDroppable(existing,update.scroll);return scrolled}));var droppables=_extends({},state.dimensions.droppables,{},toDroppableMap(withScrollChange));var updatedAdditions=toDraggableMap(adjustAdditionsForScrollChanges({additions:published.additions,updatedDroppables:droppables,viewport:state.viewport}));var draggables=_extends({},state.dimensions.draggables,{},updatedAdditions);published.removals.forEach((function(id){delete draggables[id]}));var dimensions={droppables:droppables,draggables:draggables};var wasOverId=whatIsDraggedOver(state.impact);var wasOver=wasOverId?dimensions.droppables[wasOverId]:null;var draggable=dimensions.draggables[state.critical.draggable.id];var home=dimensions.droppables[state.critical.droppable.id];var _getLiftEffect=getLiftEffect({draggable:draggable,home:home,draggables:draggables,viewport:state.viewport}),onLiftImpact=_getLiftEffect.impact,afterCritical=_getLiftEffect.afterCritical;var previousImpact=wasOver&&wasOver.isCombineEnabled?state.impact:onLiftImpact;var impact=getDragImpact({pageOffset:state.current.page.offset,draggable:dimensions.draggables[state.critical.draggable.id],draggables:dimensions.draggables,droppables:dimensions.droppables,previousImpact:previousImpact,viewport:state.viewport,afterCritical:afterCritical});finish();var draggingState=_extends({phase:"DRAGGING"},state,{phase:"DRAGGING",impact:impact,onLiftImpact:onLiftImpact,dimensions:dimensions,afterCritical:afterCritical,forceShouldAnimate:false});if(state.phase==="COLLECTING"){return draggingState}var dropPending=_extends({phase:"DROP_PENDING"},draggingState,{phase:"DROP_PENDING",reason:state.reason,isWaiting:false});return dropPending};var isSnapping=function isSnapping(state){return state.movementMode==="SNAP"};var postDroppableChange=function postDroppableChange(state,updated,isEnabledChanging){var dimensions=patchDimensionMap(state.dimensions,updated);if(!isSnapping(state)||isEnabledChanging){return update({state:state,dimensions:dimensions})}return refreshSnap({state:state,dimensions:dimensions})};function removeScrollJumpRequest(state){if(state.isDragging&&state.movementMode==="SNAP"){return _extends({phase:"DRAGGING"},state,{scrollJumpRequest:null})}return state}var idle={phase:"IDLE",completed:null,shouldFlush:false};var reducer=function(state,action){if(state===void 0){state=idle}if(action.type==="FLUSH"){return _extends({},idle,{shouldFlush:true})}if(action.type==="INITIAL_PUBLISH"){!(state.phase==="IDLE")?false?undefined:invariant(false):void 0;var _action$payload=action.payload,critical=_action$payload.critical,clientSelection=_action$payload.clientSelection,viewport=_action$payload.viewport,dimensions=_action$payload.dimensions,movementMode=_action$payload.movementMode;var draggable=dimensions.draggables[critical.draggable.id];var home=dimensions.droppables[critical.droppable.id];var client={selection:clientSelection,borderBoxCenter:draggable.client.borderBox.center,offset:origin};var initial={client:client,page:{selection:add(client.selection,viewport.scroll.initial),borderBoxCenter:add(client.selection,viewport.scroll.initial),offset:add(client.selection,viewport.scroll.diff.value)}};var isWindowScrollAllowed=toDroppableList(dimensions.droppables).every((function(item){return!item.isFixedOnPage}));var _getLiftEffect=getLiftEffect({draggable:draggable,home:home,draggables:dimensions.draggables,viewport:viewport}),impact=_getLiftEffect.impact,afterCritical=_getLiftEffect.afterCritical;var result={phase:"DRAGGING",isDragging:true,critical:critical,movementMode:movementMode,dimensions:dimensions,initial:initial,current:initial,isWindowScrollAllowed:isWindowScrollAllowed,impact:impact,afterCritical:afterCritical,onLiftImpact:impact,viewport:viewport,scrollJumpRequest:null,forceShouldAnimate:null};return result}if(action.type==="COLLECTION_STARTING"){if(state.phase==="COLLECTING"||state.phase==="DROP_PENDING"){return state}!(state.phase==="DRAGGING")?false?undefined:invariant(false):void 0;var _result=_extends({phase:"COLLECTING"},state,{phase:"COLLECTING"});return _result}if(action.type==="PUBLISH_WHILE_DRAGGING"){!(state.phase==="COLLECTING"||state.phase==="DROP_PENDING")?false?undefined:invariant(false):void 0;return publishWhileDraggingInVirtual({state:state,published:action.payload})}if(action.type==="MOVE"){if(state.phase==="DROP_PENDING"){return state}!isMovementAllowed(state)?false?undefined:invariant(false):void 0;var _clientSelection=action.payload.client;if(isEqual(_clientSelection,state.current.client.selection)){return state}return update({state:state,clientSelection:_clientSelection,impact:isSnapping(state)?state.impact:null})}if(action.type==="UPDATE_DROPPABLE_SCROLL"){if(state.phase==="DROP_PENDING"){return removeScrollJumpRequest(state)}if(state.phase==="COLLECTING"){return removeScrollJumpRequest(state)}!isMovementAllowed(state)?false?undefined:invariant(false):void 0;var _action$payload2=action.payload,id=_action$payload2.id,newScroll=_action$payload2.newScroll;var target=state.dimensions.droppables[id];if(!target){return state}var scrolled=scrollDroppable(target,newScroll);return postDroppableChange(state,scrolled,false)}if(action.type==="UPDATE_DROPPABLE_IS_ENABLED"){if(state.phase==="DROP_PENDING"){return state}!isMovementAllowed(state)?false?undefined:invariant(false):void 0;var _action$payload3=action.payload,_id=_action$payload3.id,isEnabled=_action$payload3.isEnabled;var _target=state.dimensions.droppables[_id];!_target?false?undefined:invariant(false):void 0;!(_target.isEnabled!==isEnabled)?false?undefined:invariant(false):void 0;var updated=_extends({},_target,{isEnabled:isEnabled});return postDroppableChange(state,updated,true)}if(action.type==="UPDATE_DROPPABLE_IS_COMBINE_ENABLED"){if(state.phase==="DROP_PENDING"){return state}!isMovementAllowed(state)?false?undefined:invariant(false):void 0;var _action$payload4=action.payload,_id2=_action$payload4.id,isCombineEnabled=_action$payload4.isCombineEnabled;var _target2=state.dimensions.droppables[_id2];!_target2?false?undefined:invariant(false):void 0;!(_target2.isCombineEnabled!==isCombineEnabled)?false?undefined:invariant(false):void 0;var _updated=_extends({},_target2,{isCombineEnabled:isCombineEnabled});return postDroppableChange(state,_updated,true)}if(action.type==="MOVE_BY_WINDOW_SCROLL"){if(state.phase==="DROP_PENDING"||state.phase==="DROP_ANIMATING"){return state}!isMovementAllowed(state)?false?undefined:invariant(false):void 0;!state.isWindowScrollAllowed?false?undefined:invariant(false):void 0;var _newScroll=action.payload.newScroll;if(isEqual(state.viewport.scroll.current,_newScroll)){return removeScrollJumpRequest(state)}var _viewport=scrollViewport(state.viewport,_newScroll);if(isSnapping(state)){return refreshSnap({state:state,viewport:_viewport})}return update({state:state,viewport:_viewport})}if(action.type==="UPDATE_VIEWPORT_MAX_SCROLL"){if(!isMovementAllowed(state)){return state}var maxScroll=action.payload.maxScroll;if(isEqual(maxScroll,state.viewport.scroll.max)){return state}var withMaxScroll=_extends({},state.viewport,{scroll:_extends({},state.viewport.scroll,{max:maxScroll})});return _extends({phase:"DRAGGING"},state,{viewport:withMaxScroll})}if(action.type==="MOVE_UP"||action.type==="MOVE_DOWN"||action.type==="MOVE_LEFT"||action.type==="MOVE_RIGHT"){if(state.phase==="COLLECTING"||state.phase==="DROP_PENDING"){return state}!(state.phase==="DRAGGING")?false?undefined:invariant(false):void 0;var _result2=moveInDirection({state:state,type:action.type});if(!_result2){return state}return update({state:state,impact:_result2.impact,clientSelection:_result2.clientSelection,scrollJumpRequest:_result2.scrollJumpRequest})}if(action.type==="DROP_PENDING"){var reason=action.payload.reason;!(state.phase==="COLLECTING")?false?undefined:invariant(false):void 0;var newState=_extends({phase:"DROP_PENDING"},state,{phase:"DROP_PENDING",isWaiting:true,reason:reason});return newState}if(action.type==="DROP_ANIMATE"){var _action$payload5=action.payload,completed=_action$payload5.completed,dropDuration=_action$payload5.dropDuration,newHomeClientOffset=_action$payload5.newHomeClientOffset;!(state.phase==="DRAGGING"||state.phase==="DROP_PENDING")?false?undefined:invariant(false):void 0;var _result3={phase:"DROP_ANIMATING",completed:completed,dropDuration:dropDuration,newHomeClientOffset:newHomeClientOffset,dimensions:state.dimensions};return _result3}if(action.type==="DROP_COMPLETE"){var _completed=action.payload.completed;return{phase:"IDLE",completed:_completed,shouldFlush:false}}return state};var beforeInitialCapture=function beforeInitialCapture(args){return{type:"BEFORE_INITIAL_CAPTURE",payload:args}};var lift=function lift(args){return{type:"LIFT",payload:args}};var initialPublish=function initialPublish(args){return{type:"INITIAL_PUBLISH",payload:args}};var publishWhileDragging=function publishWhileDragging(args){return{type:"PUBLISH_WHILE_DRAGGING",payload:args}};var collectionStarting=function collectionStarting(){return{type:"COLLECTION_STARTING",payload:null}};var updateDroppableScroll=function updateDroppableScroll(args){return{type:"UPDATE_DROPPABLE_SCROLL",payload:args}};var updateDroppableIsEnabled=function updateDroppableIsEnabled(args){return{type:"UPDATE_DROPPABLE_IS_ENABLED",payload:args}};var updateDroppableIsCombineEnabled=function updateDroppableIsCombineEnabled(args){return{type:"UPDATE_DROPPABLE_IS_COMBINE_ENABLED",payload:args}};var move=function move(args){return{type:"MOVE",payload:args}};var moveByWindowScroll=function moveByWindowScroll(args){return{type:"MOVE_BY_WINDOW_SCROLL",payload:args}};var updateViewportMaxScroll=function updateViewportMaxScroll(args){return{type:"UPDATE_VIEWPORT_MAX_SCROLL",payload:args}};var moveUp=function moveUp(){return{type:"MOVE_UP",payload:null}};var moveDown=function moveDown(){return{type:"MOVE_DOWN",payload:null}};var moveRight=function moveRight(){return{type:"MOVE_RIGHT",payload:null}};var moveLeft=function moveLeft(){return{type:"MOVE_LEFT",payload:null}};var flush=function flush(){return{type:"FLUSH",payload:null}};var animateDrop=function animateDrop(args){return{type:"DROP_ANIMATE",payload:args}};var completeDrop=function completeDrop(args){return{type:"DROP_COMPLETE",payload:args}};var drop=function drop(args){return{type:"DROP",payload:args}};var dropPending=function dropPending(args){return{type:"DROP_PENDING",payload:args}};var dropAnimationFinished=function dropAnimationFinished(){return{type:"DROP_ANIMATION_FINISHED",payload:null}};function checkIndexes(insideDestination){if(insideDestination.length<=1){return}var indexes=insideDestination.map((function(d){return d.descriptor.index}));var errors={};for(var i=1;i<indexes.length;i++){var current=indexes[i];var previous=indexes[i-1];if(current!==previous+1){errors[current]=true}}if(!Object.keys(errors).length){return}var formatted=indexes.map((function(index){var hasError=Boolean(errors[index]);return hasError?"[🔥"+index+"]":""+index})).join(", ");false?undefined:void 0}function validateDimensions(critical,dimensions){if(false){var insideDestination}}var lift$1=function(marshal){return function(_ref){var getState=_ref.getState,dispatch=_ref.dispatch;return function(next){return function(action){if(action.type!=="LIFT"){next(action);return}var _action$payload=action.payload,id=_action$payload.id,clientSelection=_action$payload.clientSelection,movementMode=_action$payload.movementMode;var initial=getState();if(initial.phase==="DROP_ANIMATING"){dispatch(completeDrop({completed:initial.completed}))}!(getState().phase==="IDLE")?false?undefined:invariant(false):void 0;dispatch(flush());dispatch(beforeInitialCapture({draggableId:id,movementMode:movementMode}));var scrollOptions={shouldPublishImmediately:movementMode==="SNAP"};var request={draggableId:id,scrollOptions:scrollOptions};var _marshal$startPublish=marshal.startPublishing(request),critical=_marshal$startPublish.critical,dimensions=_marshal$startPublish.dimensions,viewport=_marshal$startPublish.viewport;validateDimensions(critical,dimensions);dispatch(initialPublish({critical:critical,dimensions:dimensions,clientSelection:clientSelection,movementMode:movementMode,viewport:viewport}))}}}};var style=function(marshal){return function(){return function(next){return function(action){if(action.type==="INITIAL_PUBLISH"){marshal.dragging()}if(action.type==="DROP_ANIMATE"){marshal.dropping(action.payload.completed.result.reason)}if(action.type==="FLUSH"||action.type==="DROP_COMPLETE"){marshal.resting()}next(action)}}}};var curves={outOfTheWay:"cubic-bezier(0.2, 0, 0, 1)",drop:"cubic-bezier(.2,1,.1,1)"};var combine={opacity:{drop:0,combining:.7},scale:{drop:.75}};var timings={outOfTheWay:.2,minDropTime:.33,maxDropTime:.55};var outOfTheWayTiming=timings.outOfTheWay+"s "+curves.outOfTheWay;var transitions={fluid:"opacity "+outOfTheWayTiming,snap:"transform "+outOfTheWayTiming+", opacity "+outOfTheWayTiming,drop:function drop(duration){var timing=duration+"s "+curves.drop;return"transform "+timing+", opacity "+timing},outOfTheWay:"transform "+outOfTheWayTiming,placeholder:"height "+outOfTheWayTiming+", width "+outOfTheWayTiming+", margin "+outOfTheWayTiming};var moveTo=function moveTo(offset){return isEqual(offset,origin)?null:"translate("+offset.x+"px, "+offset.y+"px)"};var transforms={moveTo:moveTo,drop:function drop(offset,isCombining){var translate=moveTo(offset);if(!translate){return null}if(!isCombining){return translate}return translate+" scale("+combine.scale.drop+")"}};var minDropTime=timings.minDropTime,maxDropTime=timings.maxDropTime;var dropTimeRange=maxDropTime-minDropTime;var maxDropTimeAtDistance=1500;var cancelDropModifier=.6;var getDropDuration=function(_ref){var current=_ref.current,destination=_ref.destination,reason=_ref.reason;var distance$1=distance(current,destination);if(distance$1<=0){return minDropTime}if(distance$1>=maxDropTimeAtDistance){return maxDropTime}var percentage=distance$1/maxDropTimeAtDistance;var duration=minDropTime+dropTimeRange*percentage;var withDuration=reason==="CANCEL"?duration*cancelDropModifier:duration;return Number(withDuration.toFixed(2))};var getNewHomeClientOffset=function(_ref){var impact=_ref.impact,draggable=_ref.draggable,dimensions=_ref.dimensions,viewport=_ref.viewport,afterCritical=_ref.afterCritical;var draggables=dimensions.draggables,droppables=dimensions.droppables;var droppableId=whatIsDraggedOver(impact);var destination=droppableId?droppables[droppableId]:null;var home=droppables[draggable.descriptor.droppableId];var newClientCenter=getClientBorderBoxCenter({impact:impact,draggable:draggable,draggables:draggables,afterCritical:afterCritical,droppable:destination||home,viewport:viewport});var offset=subtract(newClientCenter,draggable.client.borderBox.center);return offset};var getDropImpact=function(_ref){var draggables=_ref.draggables,reason=_ref.reason,lastImpact=_ref.lastImpact,home=_ref.home,viewport=_ref.viewport,onLiftImpact=_ref.onLiftImpact;if(!lastImpact.at||reason!=="DROP"){var recomputedHomeImpact=recompute({draggables:draggables,impact:onLiftImpact,destination:home,viewport:viewport,forceShouldAnimate:true});return{impact:recomputedHomeImpact,didDropInsideDroppable:false}}if(lastImpact.at.type==="REORDER"){return{impact:lastImpact,didDropInsideDroppable:true}}var withoutMovement=_extends({},lastImpact,{displaced:emptyGroups});return{impact:withoutMovement,didDropInsideDroppable:true}};var drop$1=function(_ref){var getState=_ref.getState,dispatch=_ref.dispatch;return function(next){return function(action){if(action.type!=="DROP"){next(action);return}var state=getState();var reason=action.payload.reason;if(state.phase==="COLLECTING"){dispatch(dropPending({reason:reason}));return}if(state.phase==="IDLE"){return}var isWaitingForDrop=state.phase==="DROP_PENDING"&&state.isWaiting;!!isWaitingForDrop?false?undefined:invariant(false):void 0;!(state.phase==="DRAGGING"||state.phase==="DROP_PENDING")?false?undefined:invariant(false):void 0;var critical=state.critical;var dimensions=state.dimensions;var draggable=dimensions.draggables[state.critical.draggable.id];var _getDropImpact=getDropImpact({reason:reason,lastImpact:state.impact,afterCritical:state.afterCritical,onLiftImpact:state.onLiftImpact,home:state.dimensions.droppables[state.critical.droppable.id],viewport:state.viewport,draggables:state.dimensions.draggables}),impact=_getDropImpact.impact,didDropInsideDroppable=_getDropImpact.didDropInsideDroppable;var destination=didDropInsideDroppable?tryGetDestination(impact):null;var combine=didDropInsideDroppable?tryGetCombine(impact):null;var source={index:critical.draggable.index,droppableId:critical.droppable.id};var result={draggableId:draggable.descriptor.id,type:draggable.descriptor.type,source:source,reason:reason,mode:state.movementMode,destination:destination,combine:combine};var newHomeClientOffset=getNewHomeClientOffset({impact:impact,draggable:draggable,dimensions:dimensions,viewport:state.viewport,afterCritical:state.afterCritical});var completed={critical:state.critical,afterCritical:state.afterCritical,result:result,impact:impact};var isAnimationRequired=!isEqual(state.current.client.offset,newHomeClientOffset)||Boolean(result.combine);if(!isAnimationRequired){dispatch(completeDrop({completed:completed}));return}var dropDuration=getDropDuration({current:state.current.client.offset,destination:newHomeClientOffset,reason:reason});var args={newHomeClientOffset:newHomeClientOffset,dropDuration:dropDuration,completed:completed};dispatch(animateDrop(args))}}};var getWindowScroll=function(){return{x:window.pageXOffset,y:window.pageYOffset}};function getWindowScrollBinding(update){return{eventName:"scroll",options:{passive:true,capture:false},fn:function fn(event){if(event.target!==window&&event.target!==window.document){return}update()}}}function getScrollListener(_ref){var onWindowScroll=_ref.onWindowScroll;function updateScroll(){onWindowScroll(getWindowScroll())}var scheduled=rafSchd(updateScroll);var binding=getWindowScrollBinding(scheduled);var unbind=noop;function isActive(){return unbind!==noop}function start(){!!isActive()?false?undefined:invariant(false):void 0;unbind=bindEvents(window,[binding])}function stop(){!isActive()?false?undefined:invariant(false):void 0;scheduled.cancel();unbind();unbind=noop}return{start:start,stop:stop,isActive:isActive}}var shouldEnd=function shouldEnd(action){return action.type==="DROP_COMPLETE"||action.type==="DROP_ANIMATE"||action.type==="FLUSH"};var scrollListener=function(store){var listener=getScrollListener({onWindowScroll:function onWindowScroll(newScroll){store.dispatch(moveByWindowScroll({newScroll:newScroll}))}});return function(next){return function(action){if(!listener.isActive()&&action.type==="INITIAL_PUBLISH"){listener.start()}if(listener.isActive()&&shouldEnd(action)){listener.stop()}next(action)}}};var getExpiringAnnounce=function(announce){var wasCalled=false;var isExpired=false;var timeoutId=setTimeout((function(){isExpired=true}));var result=function result(message){if(wasCalled){false?undefined:void 0;return}if(isExpired){false?undefined:void 0;return}wasCalled=true;announce(message);clearTimeout(timeoutId)};result.wasCalled=function(){return wasCalled};return result};var getAsyncMarshal=function(){var entries=[];var execute=function execute(timerId){var index=findIndex(entries,(function(item){return item.timerId===timerId}));!(index!==-1)?false?undefined:invariant(false):void 0;var _entries$splice=entries.splice(index,1),entry=_entries$splice[0];entry.callback()};var add=function add(fn){var timerId=setTimeout((function(){return execute(timerId)}));var entry={timerId:timerId,callback:fn};entries.push(entry)};var flush=function flush(){if(!entries.length){return}var shallow=[].concat(entries);entries.length=0;shallow.forEach((function(entry){clearTimeout(entry.timerId);entry.callback()}))};return{add:add,flush:flush}};var areLocationsEqual=function areLocationsEqual(first,second){if(first==null&&second==null){return true}if(first==null||second==null){return false}return first.droppableId===second.droppableId&&first.index===second.index};var isCombineEqual=function isCombineEqual(first,second){if(first==null&&second==null){return true}if(first==null||second==null){return false}return first.draggableId===second.draggableId&&first.droppableId===second.droppableId};var isCriticalEqual=function isCriticalEqual(first,second){if(first===second){return true}var isDraggableEqual=first.draggable.id===second.draggable.id&&first.draggable.droppableId===second.draggable.droppableId&&first.draggable.type===second.draggable.type&&first.draggable.index===second.draggable.index;var isDroppableEqual=first.droppable.id===second.droppable.id&&first.droppable.type===second.droppable.type;return isDraggableEqual&&isDroppableEqual};var withTimings=function withTimings(key,fn){start();fn();finish()};var getDragStart=function getDragStart(critical,mode){return{draggableId:critical.draggable.id,type:critical.droppable.type,source:{droppableId:critical.droppable.id,index:critical.draggable.index},mode:mode}};var execute=function execute(responder,data,announce,getDefaultMessage){if(!responder){announce(getDefaultMessage(data));return}var willExpire=getExpiringAnnounce(announce);var provided={announce:willExpire};responder(data,provided);if(!willExpire.wasCalled()){announce(getDefaultMessage(data))}};var getPublisher=function(getResponders,announce){var asyncMarshal=getAsyncMarshal();var dragging=null;var beforeCapture=function beforeCapture(draggableId,mode){!!dragging?false?undefined:invariant(false):void 0;withTimings("onBeforeCapture",(function(){var fn=getResponders().onBeforeCapture;if(fn){var before={draggableId:draggableId,mode:mode};fn(before)}}))};var beforeStart=function beforeStart(critical,mode){!!dragging?false?undefined:invariant(false):void 0;withTimings("onBeforeDragStart",(function(){var fn=getResponders().onBeforeDragStart;if(fn){fn(getDragStart(critical,mode))}}))};var start=function start(critical,mode){!!dragging?false?undefined:invariant(false):void 0;var data=getDragStart(critical,mode);dragging={mode:mode,lastCritical:critical,lastLocation:data.source,lastCombine:null};asyncMarshal.add((function(){withTimings("onDragStart",(function(){return execute(getResponders().onDragStart,data,announce,preset.onDragStart)}))}))};var update=function update(critical,impact){var location=tryGetDestination(impact);var combine=tryGetCombine(impact);!dragging?false?undefined:invariant(false):void 0;var hasCriticalChanged=!isCriticalEqual(critical,dragging.lastCritical);if(hasCriticalChanged){dragging.lastCritical=critical}var hasLocationChanged=!areLocationsEqual(dragging.lastLocation,location);if(hasLocationChanged){dragging.lastLocation=location}var hasGroupingChanged=!isCombineEqual(dragging.lastCombine,combine);if(hasGroupingChanged){dragging.lastCombine=combine}if(!hasCriticalChanged&&!hasLocationChanged&&!hasGroupingChanged){return}var data=_extends({},getDragStart(critical,dragging.mode),{combine:combine,destination:location});asyncMarshal.add((function(){withTimings("onDragUpdate",(function(){return execute(getResponders().onDragUpdate,data,announce,preset.onDragUpdate)}))}))};var flush=function flush(){!dragging?false?undefined:invariant(false):void 0;asyncMarshal.flush()};var drop=function drop(result){!dragging?false?undefined:invariant(false):void 0;dragging=null;withTimings("onDragEnd",(function(){return execute(getResponders().onDragEnd,result,announce,preset.onDragEnd)}))};var abort=function abort(){if(!dragging){return}var result=_extends({},getDragStart(dragging.lastCritical,dragging.mode),{combine:null,destination:null,reason:"CANCEL"});drop(result)};return{beforeCapture:beforeCapture,beforeStart:beforeStart,start:start,update:update,flush:flush,drop:drop,abort:abort}};var responders=function(getResponders,announce){var publisher=getPublisher(getResponders,announce);return function(store){return function(next){return function(action){if(action.type==="BEFORE_INITIAL_CAPTURE"){publisher.beforeCapture(action.payload.draggableId,action.payload.movementMode);return}if(action.type==="INITIAL_PUBLISH"){var critical=action.payload.critical;publisher.beforeStart(critical,action.payload.movementMode);next(action);publisher.start(critical,action.payload.movementMode);return}if(action.type==="DROP_COMPLETE"){var result=action.payload.completed.result;publisher.flush();next(action);publisher.drop(result);return}next(action);if(action.type==="FLUSH"){publisher.abort();return}var state=store.getState();if(state.phase==="DRAGGING"){publisher.update(state.critical,state.impact)}}}}};var dropAnimationFinish=function(store){return function(next){return function(action){if(action.type!=="DROP_ANIMATION_FINISHED"){next(action);return}var state=store.getState();!(state.phase==="DROP_ANIMATING")?false?undefined:invariant(false):void 0;store.dispatch(completeDrop({completed:state.completed}))}}};var dropAnimationFlushOnScroll=function(store){var unbind=null;var frameId=null;function clear(){if(frameId){cancelAnimationFrame(frameId);frameId=null}if(unbind){unbind();unbind=null}}return function(next){return function(action){if(action.type==="FLUSH"||action.type==="DROP_COMPLETE"||action.type==="DROP_ANIMATION_FINISHED"){clear()}next(action);if(action.type!=="DROP_ANIMATE"){return}var binding={eventName:"scroll",options:{capture:true,passive:false,once:true},fn:function flushDropAnimation(){var state=store.getState();if(state.phase==="DROP_ANIMATING"){store.dispatch(dropAnimationFinished())}}};frameId=requestAnimationFrame((function(){frameId=null;unbind=bindEvents(window,[binding])}))}}};var dimensionMarshalStopper=function(marshal){return function(){return function(next){return function(action){if(action.type==="DROP_COMPLETE"||action.type==="FLUSH"||action.type==="DROP_ANIMATE"){marshal.stopPublishing()}next(action)}}}};var focus=function(marshal){var isWatching=false;return function(){return function(next){return function(action){if(action.type==="INITIAL_PUBLISH"){isWatching=true;marshal.tryRecordFocus(action.payload.critical.draggable.id);next(action);marshal.tryRestoreFocusRecorded();return}next(action);if(!isWatching){return}if(action.type==="FLUSH"){isWatching=false;marshal.tryRestoreFocusRecorded();return}if(action.type==="DROP_COMPLETE"){isWatching=false;var result=action.payload.completed.result;if(result.combine){marshal.tryShiftRecord(result.draggableId,result.combine.draggableId)}marshal.tryRestoreFocusRecorded()}}}}};var shouldStop=function shouldStop(action){return action.type==="DROP_COMPLETE"||action.type==="DROP_ANIMATE"||action.type==="FLUSH"};var autoScroll=function(autoScroller){return function(store){return function(next){return function(action){if(shouldStop(action)){autoScroller.stop();next(action);return}if(action.type==="INITIAL_PUBLISH"){next(action);var state=store.getState();!(state.phase==="DRAGGING")?false?undefined:invariant(false):void 0;autoScroller.start(state);return}next(action);autoScroller.scroll(store.getState())}}}};var pendingDrop=function(store){return function(next){return function(action){next(action);if(action.type!=="PUBLISH_WHILE_DRAGGING"){return}var postActionState=store.getState();if(postActionState.phase!=="DROP_PENDING"){return}if(postActionState.isWaiting){return}store.dispatch(drop({reason:postActionState.reason}))}}};var composeEnhancers=false?undefined:redux.compose;var createStore=function(_ref){var dimensionMarshal=_ref.dimensionMarshal,focusMarshal=_ref.focusMarshal,styleMarshal=_ref.styleMarshal,getResponders=_ref.getResponders,announce=_ref.announce,autoScroller=_ref.autoScroller;return redux.createStore(reducer,composeEnhancers(redux.applyMiddleware(style(styleMarshal),dimensionMarshalStopper(dimensionMarshal),lift$1(dimensionMarshal),drop$1,dropAnimationFinish,dropAnimationFlushOnScroll,pendingDrop,autoScroll(autoScroller),scrollListener,focus(focusMarshal),responders(getResponders,announce))))};var clean$1=function clean(){return{additions:{},removals:{},modified:{}}};function createPublisher(_ref){var registry=_ref.registry,callbacks=_ref.callbacks;var staging=clean$1();var frameId=null;var collect=function collect(){if(frameId){return}callbacks.collectionStarting();frameId=requestAnimationFrame((function(){frameId=null;start();var _staging=staging,additions=_staging.additions,removals=_staging.removals,modified=_staging.modified;var added=Object.keys(additions).map((function(id){return registry.draggable.getById(id).getDimension(origin)})).sort((function(a,b){return a.descriptor.index-b.descriptor.index}));var updated=Object.keys(modified).map((function(id){var entry=registry.droppable.getById(id);var scroll=entry.callbacks.getScrollWhileDragging();return{droppableId:id,scroll:scroll}}));var result={additions:added,removals:Object.keys(removals),modified:updated};staging=clean$1();finish();callbacks.publish(result)}))};var add=function add(entry){var id=entry.descriptor.id;staging.additions[id]=entry;staging.modified[entry.descriptor.droppableId]=true;if(staging.removals[id]){delete staging.removals[id]}collect()};var remove=function remove(entry){var descriptor=entry.descriptor;staging.removals[descriptor.id]=true;staging.modified[descriptor.droppableId]=true;if(staging.additions[descriptor.id]){delete staging.additions[descriptor.id]}collect()};var stop=function stop(){if(!frameId){return}cancelAnimationFrame(frameId);frameId=null;staging=clean$1()};return{add:add,remove:remove,stop:stop}}var getMaxScroll=function(_ref){var scrollHeight=_ref.scrollHeight,scrollWidth=_ref.scrollWidth,height=_ref.height,width=_ref.width;var maxScroll=subtract({x:scrollWidth,y:scrollHeight},{x:width,y:height});var adjustedMaxScroll={x:Math.max(0,maxScroll.x),y:Math.max(0,maxScroll.y)};return adjustedMaxScroll};var getDocumentElement=function(){var doc=document.documentElement;!doc?false?undefined:invariant(false):void 0;return doc};var getMaxWindowScroll=function(){var doc=getDocumentElement();var maxScroll=getMaxScroll({scrollHeight:doc.scrollHeight,scrollWidth:doc.scrollWidth,width:doc.clientWidth,height:doc.clientHeight});return maxScroll};var getViewport=function(){var scroll=getWindowScroll();var maxScroll=getMaxWindowScroll();var top=scroll.y;var left=scroll.x;var doc=getDocumentElement();var width=doc.clientWidth;var height=doc.clientHeight;var right=left+width;var bottom=top+height;var frame=cssBoxModel.getRect({top:top,left:left,right:right,bottom:bottom});var viewport={frame:frame,scroll:{initial:scroll,current:scroll,max:maxScroll,diff:{value:origin,displacement:origin}}};return viewport};var getInitialPublish=function(_ref){var critical=_ref.critical,scrollOptions=_ref.scrollOptions,registry=_ref.registry;start();var viewport=getViewport();var windowScroll=viewport.scroll.current;var home=critical.droppable;var droppables=registry.droppable.getAllByType(home.type).map((function(entry){return entry.callbacks.getDimensionAndWatchScroll(windowScroll,scrollOptions)}));var draggables=registry.draggable.getAllByType(critical.draggable.type).map((function(entry){return entry.getDimension(windowScroll)}));var dimensions={draggables:toDraggableMap(draggables),droppables:toDroppableMap(droppables)};finish();var result={dimensions:dimensions,critical:critical,viewport:viewport};return result};function shouldPublishUpdate(registry,dragging,entry){if(entry.descriptor.id===dragging.id){return false}if(entry.descriptor.type!==dragging.type){return false}var home=registry.droppable.getById(entry.descriptor.droppableId);if(home.descriptor.mode!=="virtual"){false?undefined:void 0;return false}return true}var createDimensionMarshal=function(registry,callbacks){var collection=null;var publisher=createPublisher({callbacks:{publish:callbacks.publishWhileDragging,collectionStarting:callbacks.collectionStarting},registry:registry});var updateDroppableIsEnabled=function updateDroppableIsEnabled(id,isEnabled){!registry.droppable.exists(id)?false?undefined:invariant(false):void 0;if(!collection){return}callbacks.updateDroppableIsEnabled({id:id,isEnabled:isEnabled})};var updateDroppableIsCombineEnabled=function updateDroppableIsCombineEnabled(id,isCombineEnabled){if(!collection){return}!registry.droppable.exists(id)?false?undefined:invariant(false):void 0;callbacks.updateDroppableIsCombineEnabled({id:id,isCombineEnabled:isCombineEnabled})};var updateDroppableScroll=function updateDroppableScroll(id,newScroll){if(!collection){return}!registry.droppable.exists(id)?false?undefined:invariant(false):void 0;callbacks.updateDroppableScroll({id:id,newScroll:newScroll})};var scrollDroppable=function scrollDroppable(id,change){if(!collection){return}registry.droppable.getById(id).callbacks.scroll(change)};var stopPublishing=function stopPublishing(){if(!collection){return}publisher.stop();var home=collection.critical.droppable;registry.droppable.getAllByType(home.type).forEach((function(entry){return entry.callbacks.dragStopped()}));collection.unsubscribe();collection=null};var subscriber=function subscriber(event){!collection?false?undefined:invariant(false):void 0;var dragging=collection.critical.draggable;if(event.type==="ADDITION"){if(shouldPublishUpdate(registry,dragging,event.value)){publisher.add(event.value)}}if(event.type==="REMOVAL"){if(shouldPublishUpdate(registry,dragging,event.value)){publisher.remove(event.value)}}};var startPublishing=function startPublishing(request){!!collection?false?undefined:invariant(false):void 0;var entry=registry.draggable.getById(request.draggableId);var home=registry.droppable.getById(entry.descriptor.droppableId);var critical={draggable:entry.descriptor,droppable:home.descriptor};var unsubscribe=registry.subscribe(subscriber);collection={critical:critical,unsubscribe:unsubscribe};return getInitialPublish({critical:critical,registry:registry,scrollOptions:request.scrollOptions})};var marshal={updateDroppableIsEnabled:updateDroppableIsEnabled,updateDroppableIsCombineEnabled:updateDroppableIsCombineEnabled,scrollDroppable:scrollDroppable,updateDroppableScroll:updateDroppableScroll,startPublishing:startPublishing,stopPublishing:stopPublishing};return marshal};var canStartDrag=function(state,id){if(state.phase==="IDLE"){return true}if(state.phase!=="DROP_ANIMATING"){return false}if(state.completed.result.draggableId===id){return false}return state.completed.result.reason==="DROP"};var scrollWindow=function(change){window.scrollBy(change.x,change.y)};var getScrollableDroppables=memoizeOne((function(droppables){return toDroppableList(droppables).filter((function(droppable){if(!droppable.isEnabled){return false}if(!droppable.frame){return false}return true}))}));var getScrollableDroppableOver=function getScrollableDroppableOver(target,droppables){var maybe=find(getScrollableDroppables(droppables),(function(droppable){!droppable.frame?false?undefined:invariant(false):void 0;return isPositionInFrame(droppable.frame.pageMarginBox)(target)}));return maybe};var getBestScrollableDroppable=function(_ref){var center=_ref.center,destination=_ref.destination,droppables=_ref.droppables;if(destination){var _dimension=droppables[destination];if(!_dimension.frame){return null}return _dimension}var dimension=getScrollableDroppableOver(center,droppables);return dimension};var config={startFromPercentage:.25,maxScrollAtPercentage:.05,maxPixelScroll:28,ease:function ease(percentage){return Math.pow(percentage,2)},durationDampening:{stopDampeningAt:1200,accelerateAt:360}};var getDistanceThresholds=function(container,axis){var startScrollingFrom=container[axis.size]*config.startFromPercentage;var maxScrollValueAt=container[axis.size]*config.maxScrollAtPercentage;var thresholds={startScrollingFrom:startScrollingFrom,maxScrollValueAt:maxScrollValueAt};return thresholds};var getPercentage=function(_ref){var startOfRange=_ref.startOfRange,endOfRange=_ref.endOfRange,current=_ref.current;var range=endOfRange-startOfRange;if(range===0){false?undefined:void 0;return 0}var currentInRange=current-startOfRange;var percentage=currentInRange/range;return percentage};var minScroll=1;var getValueFromDistance=function(distanceToEdge,thresholds){if(distanceToEdge>thresholds.startScrollingFrom){return 0}if(distanceToEdge<=thresholds.maxScrollValueAt){return config.maxPixelScroll}if(distanceToEdge===thresholds.startScrollingFrom){return minScroll}var percentageFromMaxScrollValueAt=getPercentage({startOfRange:thresholds.maxScrollValueAt,endOfRange:thresholds.startScrollingFrom,current:distanceToEdge});var percentageFromStartScrollingFrom=1-percentageFromMaxScrollValueAt;var scroll=config.maxPixelScroll*config.ease(percentageFromStartScrollingFrom);return Math.ceil(scroll)};var accelerateAt=config.durationDampening.accelerateAt;var stopAt=config.durationDampening.stopDampeningAt;var dampenValueByTime=function(proposedScroll,dragStartTime){var startOfRange=dragStartTime;var endOfRange=stopAt;var now=Date.now();var runTime=now-startOfRange;if(runTime>=stopAt){return proposedScroll}if(runTime<accelerateAt){return minScroll}var betweenAccelerateAtAndStopAtPercentage=getPercentage({startOfRange:accelerateAt,endOfRange:endOfRange,current:runTime});var scroll=proposedScroll*config.ease(betweenAccelerateAtAndStopAtPercentage);return Math.ceil(scroll)};var getValue=function(_ref){var distanceToEdge=_ref.distanceToEdge,thresholds=_ref.thresholds,dragStartTime=_ref.dragStartTime,shouldUseTimeDampening=_ref.shouldUseTimeDampening;var scroll=getValueFromDistance(distanceToEdge,thresholds);if(scroll===0){return 0}if(!shouldUseTimeDampening){return scroll}return Math.max(dampenValueByTime(scroll,dragStartTime),minScroll)};var getScrollOnAxis=function(_ref){var container=_ref.container,distanceToEdges=_ref.distanceToEdges,dragStartTime=_ref.dragStartTime,axis=_ref.axis,shouldUseTimeDampening=_ref.shouldUseTimeDampening;var thresholds=getDistanceThresholds(container,axis);var isCloserToEnd=distanceToEdges[axis.end]<distanceToEdges[axis.start];if(isCloserToEnd){return getValue({distanceToEdge:distanceToEdges[axis.end],thresholds:thresholds,dragStartTime:dragStartTime,shouldUseTimeDampening:shouldUseTimeDampening})}return-1*getValue({distanceToEdge:distanceToEdges[axis.start],thresholds:thresholds,dragStartTime:dragStartTime,shouldUseTimeDampening:shouldUseTimeDampening})};var adjustForSizeLimits=function(_ref){var container=_ref.container,subject=_ref.subject,proposedScroll=_ref.proposedScroll;var isTooBigVertically=subject.height>container.height;var isTooBigHorizontally=subject.width>container.width;if(!isTooBigHorizontally&&!isTooBigVertically){return proposedScroll}if(isTooBigHorizontally&&isTooBigVertically){return null}return{x:isTooBigHorizontally?0:proposedScroll.x,y:isTooBigVertically?0:proposedScroll.y}};var clean$2=apply((function(value){return value===0?0:value}));var getScroll=function(_ref){var dragStartTime=_ref.dragStartTime,container=_ref.container,subject=_ref.subject,center=_ref.center,shouldUseTimeDampening=_ref.shouldUseTimeDampening;var distanceToEdges={top:center.y-container.top,right:container.right-center.x,bottom:container.bottom-center.y,left:center.x-container.left};var y=getScrollOnAxis({container:container,distanceToEdges:distanceToEdges,dragStartTime:dragStartTime,axis:vertical,shouldUseTimeDampening:shouldUseTimeDampening});var x=getScrollOnAxis({container:container,distanceToEdges:distanceToEdges,dragStartTime:dragStartTime,axis:horizontal,shouldUseTimeDampening:shouldUseTimeDampening});var required=clean$2({x:x,y:y});if(isEqual(required,origin)){return null}var limited=adjustForSizeLimits({container:container,subject:subject,proposedScroll:required});if(!limited){return null}return isEqual(limited,origin)?null:limited};var smallestSigned=apply((function(value){if(value===0){return 0}return value>0?1:-1}));var getOverlap=function(){var getRemainder=function getRemainder(target,max){if(target<0){return target}if(target>max){return target-max}return 0};return function(_ref){var current=_ref.current,max=_ref.max,change=_ref.change;var targetScroll=add(current,change);var overlap={x:getRemainder(targetScroll.x,max.x),y:getRemainder(targetScroll.y,max.y)};if(isEqual(overlap,origin)){return null}return overlap}}();var canPartiallyScroll=function canPartiallyScroll(_ref2){var rawMax=_ref2.max,current=_ref2.current,change=_ref2.change;var max={x:Math.max(current.x,rawMax.x),y:Math.max(current.y,rawMax.y)};var smallestChange=smallestSigned(change);var overlap=getOverlap({max:max,current:current,change:smallestChange});if(!overlap){return true}if(smallestChange.x!==0&&overlap.x===0){return true}if(smallestChange.y!==0&&overlap.y===0){return true}return false};var canScrollWindow=function canScrollWindow(viewport,change){return canPartiallyScroll({current:viewport.scroll.current,max:viewport.scroll.max,change:change})};var getWindowOverlap=function getWindowOverlap(viewport,change){if(!canScrollWindow(viewport,change)){return null}var max=viewport.scroll.max;var current=viewport.scroll.current;return getOverlap({current:current,max:max,change:change})};var canScrollDroppable=function canScrollDroppable(droppable,change){var frame=droppable.frame;if(!frame){return false}return canPartiallyScroll({current:frame.scroll.current,max:frame.scroll.max,change:change})};var getDroppableOverlap=function getDroppableOverlap(droppable,change){var frame=droppable.frame;if(!frame){return null}if(!canScrollDroppable(droppable,change)){return null}return getOverlap({current:frame.scroll.current,max:frame.scroll.max,change:change})};var getWindowScrollChange=function(_ref){var viewport=_ref.viewport,subject=_ref.subject,center=_ref.center,dragStartTime=_ref.dragStartTime,shouldUseTimeDampening=_ref.shouldUseTimeDampening;var scroll=getScroll({dragStartTime:dragStartTime,container:viewport.frame,subject:subject,center:center,shouldUseTimeDampening:shouldUseTimeDampening});return scroll&&canScrollWindow(viewport,scroll)?scroll:null};var getDroppableScrollChange=function(_ref){var droppable=_ref.droppable,subject=_ref.subject,center=_ref.center,dragStartTime=_ref.dragStartTime,shouldUseTimeDampening=_ref.shouldUseTimeDampening;var frame=droppable.frame;if(!frame){return null}var scroll=getScroll({dragStartTime:dragStartTime,container:frame.pageMarginBox,subject:subject,center:center,shouldUseTimeDampening:shouldUseTimeDampening});return scroll&&canScrollDroppable(droppable,scroll)?scroll:null};var scroll$1=function(_ref){var state=_ref.state,dragStartTime=_ref.dragStartTime,shouldUseTimeDampening=_ref.shouldUseTimeDampening,scrollWindow=_ref.scrollWindow,scrollDroppable=_ref.scrollDroppable;var center=state.current.page.borderBoxCenter;var draggable=state.dimensions.draggables[state.critical.draggable.id];var subject=draggable.page.marginBox;if(state.isWindowScrollAllowed){var viewport=state.viewport;var _change=getWindowScrollChange({dragStartTime:dragStartTime,viewport:viewport,subject:subject,center:center,shouldUseTimeDampening:shouldUseTimeDampening});if(_change){scrollWindow(_change);return}}var droppable=getBestScrollableDroppable({center:center,destination:whatIsDraggedOver(state.impact),droppables:state.dimensions.droppables});if(!droppable){return}var change=getDroppableScrollChange({dragStartTime:dragStartTime,droppable:droppable,subject:subject,center:center,shouldUseTimeDampening:shouldUseTimeDampening});if(change){scrollDroppable(droppable.descriptor.id,change)}};var createFluidScroller=function(_ref){var scrollWindow=_ref.scrollWindow,scrollDroppable=_ref.scrollDroppable;var scheduleWindowScroll=rafSchd(scrollWindow);var scheduleDroppableScroll=rafSchd(scrollDroppable);var dragging=null;var tryScroll=function tryScroll(state){!dragging?false?undefined:invariant(false):void 0;var _dragging=dragging,shouldUseTimeDampening=_dragging.shouldUseTimeDampening,dragStartTime=_dragging.dragStartTime;scroll$1({state:state,scrollWindow:scheduleWindowScroll,scrollDroppable:scheduleDroppableScroll,dragStartTime:dragStartTime,shouldUseTimeDampening:shouldUseTimeDampening})};var start$1=function start$1(state){start();!!dragging?false?undefined:invariant(false):void 0;var dragStartTime=Date.now();var wasScrollNeeded=false;var fakeScrollCallback=function fakeScrollCallback(){wasScrollNeeded=true};scroll$1({state:state,dragStartTime:0,shouldUseTimeDampening:false,scrollWindow:fakeScrollCallback,scrollDroppable:fakeScrollCallback});dragging={dragStartTime:dragStartTime,shouldUseTimeDampening:wasScrollNeeded};finish();if(wasScrollNeeded){tryScroll(state)}};var stop=function stop(){if(!dragging){return}scheduleWindowScroll.cancel();scheduleDroppableScroll.cancel();dragging=null};return{start:start$1,stop:stop,scroll:tryScroll}};var createJumpScroller=function(_ref){var move=_ref.move,scrollDroppable=_ref.scrollDroppable,scrollWindow=_ref.scrollWindow;var moveByOffset=function moveByOffset(state,offset){var client=add(state.current.client.selection,offset);move({client:client})};var scrollDroppableAsMuchAsItCan=function scrollDroppableAsMuchAsItCan(droppable,change){if(!canScrollDroppable(droppable,change)){return change}var overlap=getDroppableOverlap(droppable,change);if(!overlap){scrollDroppable(droppable.descriptor.id,change);return null}var whatTheDroppableCanScroll=subtract(change,overlap);scrollDroppable(droppable.descriptor.id,whatTheDroppableCanScroll);var remainder=subtract(change,whatTheDroppableCanScroll);return remainder};var scrollWindowAsMuchAsItCan=function scrollWindowAsMuchAsItCan(isWindowScrollAllowed,viewport,change){if(!isWindowScrollAllowed){return change}if(!canScrollWindow(viewport,change)){return change}var overlap=getWindowOverlap(viewport,change);if(!overlap){scrollWindow(change);return null}var whatTheWindowCanScroll=subtract(change,overlap);scrollWindow(whatTheWindowCanScroll);var remainder=subtract(change,whatTheWindowCanScroll);return remainder};var jumpScroller=function jumpScroller(state){var request=state.scrollJumpRequest;if(!request){return}var destination=whatIsDraggedOver(state.impact);!destination?false?undefined:invariant(false):void 0;var droppableRemainder=scrollDroppableAsMuchAsItCan(state.dimensions.droppables[destination],request);if(!droppableRemainder){return}var viewport=state.viewport;var windowRemainder=scrollWindowAsMuchAsItCan(state.isWindowScrollAllowed,viewport,droppableRemainder);if(!windowRemainder){return}moveByOffset(state,windowRemainder)};return jumpScroller};var createAutoScroller=function(_ref){var scrollDroppable=_ref.scrollDroppable,scrollWindow=_ref.scrollWindow,move=_ref.move;var fluidScroller=createFluidScroller({scrollWindow:scrollWindow,scrollDroppable:scrollDroppable});var jumpScroll=createJumpScroller({move:move,scrollWindow:scrollWindow,scrollDroppable:scrollDroppable});var scroll=function scroll(state){if(state.phase!=="DRAGGING"){return}if(state.movementMode==="FLUID"){fluidScroller.scroll(state);return}if(!state.scrollJumpRequest){return}jumpScroll(state)};var scroller={scroll:scroll,start:fluidScroller.start,stop:fluidScroller.stop};return scroller};var prefix$1="data-rbd";var dragHandle=function(){var base=prefix$1+"-drag-handle";return{base:base,draggableId:base+"-draggable-id",contextId:base+"-context-id"}}();var draggable=function(){var base=prefix$1+"-draggable";return{base:base,contextId:base+"-context-id",id:base+"-id"}}();var droppable=function(){var base=prefix$1+"-droppable";return{base:base,contextId:base+"-context-id",id:base+"-id"}}();var scrollContainer={contextId:prefix$1+"-scroll-container-context-id"};var makeGetSelector=function makeGetSelector(context){return function(attribute){return"["+attribute+'="'+context+'"]'}};var getStyles=function getStyles(rules,property){return rules.map((function(rule){var value=rule.styles[property];if(!value){return""}return rule.selector+" { "+value+" }"})).join(" ")};var noPointerEvents="pointer-events: none;";var getStyles$1=function(contextId){var getSelector=makeGetSelector(contextId);var dragHandle$1=function(){var grabCursor="\n      cursor: -webkit-grab;\n      cursor: grab;\n    ";return{selector:getSelector(dragHandle.contextId),styles:{always:"\n          -webkit-touch-callout: none;\n          -webkit-tap-highlight-color: rgba(0,0,0,0);\n          touch-action: manipulation;\n        ",resting:grabCursor,dragging:noPointerEvents,dropAnimating:grabCursor}}}();var draggable$1=function(){var transition="\n      transition: "+transitions.outOfTheWay+";\n    ";return{selector:getSelector(draggable.contextId),styles:{dragging:transition,dropAnimating:transition,userCancel:transition}}}();var droppable$1={selector:getSelector(droppable.contextId),styles:{always:"overflow-anchor: none;"}};var body={selector:"body",styles:{dragging:"\n        cursor: grabbing;\n        cursor: -webkit-grabbing;\n        user-select: none;\n        -webkit-user-select: none;\n        -moz-user-select: none;\n        -ms-user-select: none;\n        overflow-anchor: none;\n      "}};var rules=[draggable$1,dragHandle$1,droppable$1,body];return{always:getStyles(rules,"always"),resting:getStyles(rules,"resting"),dragging:getStyles(rules,"dragging"),dropAnimating:getStyles(rules,"dropAnimating"),userCancel:getStyles(rules,"userCancel")}};var useIsomorphicLayoutEffect=typeof window!=="undefined"&&typeof window.document!=="undefined"&&typeof window.document.createElement!=="undefined"?React.useLayoutEffect:React.useEffect;var getHead=function getHead(){var head=document.querySelector("head");!head?false?undefined:invariant(false):void 0;return head};var createStyleEl=function createStyleEl(nonce){var el=document.createElement("style");if(nonce){el.setAttribute("nonce",nonce)}el.type="text/css";return el};function useStyleMarshal(contextId,nonce){var styles=useMemoOne.useMemo((function(){return getStyles$1(contextId)}),[contextId]);var alwaysRef=React.useRef(null);var dynamicRef=React.useRef(null);var setDynamicStyle=useMemoOne.useCallback(memoizeOne((function(proposed){var el=dynamicRef.current;!el?false?undefined:invariant(false):void 0;el.textContent=proposed})),[]);var setAlwaysStyle=useMemoOne.useCallback((function(proposed){var el=alwaysRef.current;!el?false?undefined:invariant(false):void 0;el.textContent=proposed}),[]);useIsomorphicLayoutEffect((function(){!(!alwaysRef.current&&!dynamicRef.current)?false?undefined:invariant(false):void 0;var always=createStyleEl(nonce);var dynamic=createStyleEl(nonce);alwaysRef.current=always;dynamicRef.current=dynamic;always.setAttribute(prefix$1+"-always",contextId);dynamic.setAttribute(prefix$1+"-dynamic",contextId);getHead().appendChild(always);getHead().appendChild(dynamic);setAlwaysStyle(styles.always);setDynamicStyle(styles.resting);return function(){var remove=function remove(ref){var current=ref.current;!current?false?undefined:invariant(false):void 0;getHead().removeChild(current);ref.current=null};remove(alwaysRef);remove(dynamicRef)}}),[nonce,setAlwaysStyle,setDynamicStyle,styles.always,styles.resting,contextId]);var dragging=useMemoOne.useCallback((function(){return setDynamicStyle(styles.dragging)}),[setDynamicStyle,styles.dragging]);var dropping=useMemoOne.useCallback((function(reason){if(reason==="DROP"){setDynamicStyle(styles.dropAnimating);return}setDynamicStyle(styles.userCancel)}),[setDynamicStyle,styles.dropAnimating,styles.userCancel]);var resting=useMemoOne.useCallback((function(){if(!dynamicRef.current){return}setDynamicStyle(styles.resting)}),[setDynamicStyle,styles.resting]);var marshal=useMemoOne.useMemo((function(){return{dragging:dragging,dropping:dropping,resting:resting}}),[dragging,dropping,resting]);return marshal}var getWindowFromEl=function(el){return el&&el.ownerDocument?el.ownerDocument.defaultView:window};function isHtmlElement(el){return el instanceof getWindowFromEl(el).HTMLElement}function findDragHandle(contextId,draggableId){var selector="["+dragHandle.contextId+'="'+contextId+'"]';var possible=toArray(document.querySelectorAll(selector));if(!possible.length){false?undefined:void 0;return null}var handle=find(possible,(function(el){return el.getAttribute(dragHandle.draggableId)===draggableId}));if(!handle){false?undefined:void 0;return null}if(!isHtmlElement(handle)){false?undefined:void 0;return null}return handle}function useFocusMarshal(contextId){var entriesRef=React.useRef({});var recordRef=React.useRef(null);var restoreFocusFrameRef=React.useRef(null);var isMountedRef=React.useRef(false);var register=useMemoOne.useCallback((function register(id,focus){var entry={id:id,focus:focus};entriesRef.current[id]=entry;return function unregister(){var entries=entriesRef.current;var current=entries[id];if(current!==entry){delete entries[id]}}}),[]);var tryGiveFocus=useMemoOne.useCallback((function tryGiveFocus(tryGiveFocusTo){var handle=findDragHandle(contextId,tryGiveFocusTo);if(handle&&handle!==document.activeElement){handle.focus()}}),[contextId]);var tryShiftRecord=useMemoOne.useCallback((function tryShiftRecord(previous,redirectTo){if(recordRef.current===previous){recordRef.current=redirectTo}}),[]);var tryRestoreFocusRecorded=useMemoOne.useCallback((function tryRestoreFocusRecorded(){if(restoreFocusFrameRef.current){return}if(!isMountedRef.current){return}restoreFocusFrameRef.current=requestAnimationFrame((function(){restoreFocusFrameRef.current=null;var record=recordRef.current;if(record){tryGiveFocus(record)}}))}),[tryGiveFocus]);var tryRecordFocus=useMemoOne.useCallback((function tryRecordFocus(id){recordRef.current=null;var focused=document.activeElement;if(!focused){return}if(focused.getAttribute(dragHandle.draggableId)!==id){return}recordRef.current=id}),[]);useIsomorphicLayoutEffect((function(){isMountedRef.current=true;return function clearFrameOnUnmount(){isMountedRef.current=false;var frameId=restoreFocusFrameRef.current;if(frameId){cancelAnimationFrame(frameId)}}}),[]);var marshal=useMemoOne.useMemo((function(){return{register:register,tryRecordFocus:tryRecordFocus,tryRestoreFocusRecorded:tryRestoreFocusRecorded,tryShiftRecord:tryShiftRecord}}),[register,tryRecordFocus,tryRestoreFocusRecorded,tryShiftRecord]);return marshal}function createRegistry(){var entries={draggables:{},droppables:{}};var subscribers=[];function subscribe(cb){subscribers.push(cb);return function unsubscribe(){var index=subscribers.indexOf(cb);if(index===-1){return}subscribers.splice(index,1)}}function notify(event){if(subscribers.length){subscribers.forEach((function(cb){return cb(event)}))}}function findDraggableById(id){return entries.draggables[id]||null}function getDraggableById(id){var entry=findDraggableById(id);!entry?false?undefined:invariant(false):void 0;return entry}var draggableAPI={register:function register(entry){entries.draggables[entry.descriptor.id]=entry;notify({type:"ADDITION",value:entry})},update:function update(entry,last){var current=entries.draggables[last.descriptor.id];if(!current){return}if(current.uniqueId!==entry.uniqueId){return}delete entries.draggables[last.descriptor.id];entries.draggables[entry.descriptor.id]=entry},unregister:function unregister(entry){var draggableId=entry.descriptor.id;var current=findDraggableById(draggableId);if(!current){return}if(entry.uniqueId!==current.uniqueId){return}delete entries.draggables[draggableId];notify({type:"REMOVAL",value:entry})},getById:getDraggableById,findById:findDraggableById,exists:function exists(id){return Boolean(findDraggableById(id))},getAllByType:function getAllByType(type){return values(entries.draggables).filter((function(entry){return entry.descriptor.type===type}))}};function findDroppableById(id){return entries.droppables[id]||null}function getDroppableById(id){var entry=findDroppableById(id);!entry?false?undefined:invariant(false):void 0;return entry}var droppableAPI={register:function register(entry){entries.droppables[entry.descriptor.id]=entry},unregister:function unregister(entry){var current=findDroppableById(entry.descriptor.id);if(!current){return}if(entry.uniqueId!==current.uniqueId){return}delete entries.droppables[entry.descriptor.id]},getById:getDroppableById,findById:findDroppableById,exists:function exists(id){return Boolean(findDroppableById(id))},getAllByType:function getAllByType(type){return values(entries.droppables).filter((function(entry){return entry.descriptor.type===type}))}};function clean(){entries.draggables={};entries.droppables={};subscribers.length=0}return{draggable:draggableAPI,droppable:droppableAPI,subscribe:subscribe,clean:clean}}function useRegistry(){var registry=useMemoOne.useMemo(createRegistry,[]);React.useEffect((function(){return function unmount(){requestAnimationFrame(registry.clean)}}),[registry]);return registry}var StoreContext=React__default.createContext(null);var getBodyElement=function(){var body=document.body;!body?false?undefined:invariant(false):void 0;return body};var visuallyHidden={position:"absolute",width:"1px",height:"1px",margin:"-1px",border:"0",padding:"0",overflow:"hidden",clip:"rect(0 0 0 0)","clip-path":"inset(100%)"};var getId=function getId(contextId){return"rbd-announcement-"+contextId};function useAnnouncer(contextId){var id=useMemoOne.useMemo((function(){return getId(contextId)}),[contextId]);var ref=React.useRef(null);React.useEffect((function setup(){var el=document.createElement("div");ref.current=el;el.id=id;el.setAttribute("aria-live","assertive");el.setAttribute("aria-atomic","true");_extends(el.style,visuallyHidden);getBodyElement().appendChild(el);return function cleanup(){setTimeout((function remove(){var body=getBodyElement();if(body.contains(el)){body.removeChild(el)}if(el===ref.current){ref.current=null}}))}}),[id]);var announce=useMemoOne.useCallback((function(message){var el=ref.current;if(el){el.textContent=message;return}false?undefined:void 0}),[]);return announce}var count=0;var defaults={separator:"::"};function reset(){count=0}function useUniqueId(prefix,options){if(options===void 0){options=defaults}return useMemoOne.useMemo((function(){return""+prefix+options.separator+count++}),[options.separator,prefix])}function getElementId(_ref){var contextId=_ref.contextId,uniqueId=_ref.uniqueId;return"rbd-hidden-text-"+contextId+"-"+uniqueId}function useHiddenTextElement(_ref2){var contextId=_ref2.contextId,text=_ref2.text;var uniqueId=useUniqueId("hidden-text",{separator:"-"});var id=useMemoOne.useMemo((function(){return getElementId({contextId:contextId,uniqueId:uniqueId})}),[uniqueId,contextId]);React.useEffect((function mount(){var el=document.createElement("div");el.id=id;el.textContent=text;el.style.display="none";getBodyElement().appendChild(el);return function unmount(){var body=getBodyElement();if(body.contains(el)){body.removeChild(el)}}}),[id,text]);return id}var AppContext=React__default.createContext(null);var peerDependencies={react:"^16.8.5","react-dom":"^16.8.5"};var semver=/(\d+)\.(\d+)\.(\d+)/;var getVersion=function getVersion(value){var result=semver.exec(value);!(result!=null)?false?undefined:invariant(false):void 0;var major=Number(result[1]);var minor=Number(result[2]);var patch=Number(result[3]);return{major:major,minor:minor,patch:patch,raw:value}};var isSatisfied=function isSatisfied(expected,actual){if(actual.major>expected.major){return true}if(actual.major<expected.major){return false}if(actual.minor>expected.minor){return true}if(actual.minor<expected.minor){return false}return actual.patch>=expected.patch};var checkReactVersion=function(peerDepValue,actualValue){var peerDep=getVersion(peerDepValue);var actual=getVersion(actualValue);if(isSatisfied(peerDep,actual)){return}false?undefined:void 0};var suffix="\n  We expect a html5 doctype: <!doctype html>\n  This is to ensure consistent browser layout and measurement\n\n  More information: https://github.com/atlassian/react-beautiful-dnd/blob/master/docs/guides/doctype.md\n";var checkDoctype=function(doc){var doctype=doc.doctype;if(!doctype){false?undefined:void 0;return}if(doctype.name.toLowerCase()!=="html"){false?undefined:void 0}if(doctype.publicId!==""){false?undefined:void 0}};function useDev(useHook){if(false){}}function useDevSetupWarning(fn,inputs){useDev((function(){React.useEffect((function(){try{fn()}catch(e){error("\n          A setup problem was encountered.\n\n          > "+e.message+"\n        ")}}),inputs)}))}function useStartupValidation(){useDevSetupWarning((function(){checkReactVersion(peerDependencies.react,React__default.version);checkDoctype(document)}),[])}function usePrevious(current){var ref=React.useRef(current);React.useEffect((function(){ref.current=current}));return ref}function create(){var lock=null;function isClaimed(){return Boolean(lock)}function isActive(value){return value===lock}function claim(abandon){!!lock?false?undefined:invariant(false):void 0;var newLock={abandon:abandon};lock=newLock;return newLock}function release(){!lock?false?undefined:invariant(false):void 0;lock=null}function tryAbandon(){if(lock){lock.abandon();release()}}return{isClaimed:isClaimed,isActive:isActive,claim:claim,release:release,tryAbandon:tryAbandon}}var tab=9;var enter=13;var escape=27;var space=32;var pageUp=33;var pageDown=34;var end=35;var home=36;var arrowLeft=37;var arrowUp=38;var arrowRight=39;var arrowDown=40;var _preventedKeys;var preventedKeys=(_preventedKeys={},_preventedKeys[enter]=true,_preventedKeys[tab]=true,_preventedKeys);var preventStandardKeyEvents=function(event){if(preventedKeys[event.keyCode]){event.preventDefault()}};var supportedEventName=function(){var base="visibilitychange";if(typeof document==="undefined"){return base}var candidates=[base,"ms"+base,"webkit"+base,"moz"+base,"o"+base];var supported=find(candidates,(function(eventName){return"on"+eventName in document}));return supported||base}();var primaryButton=0;var sloppyClickThreshold=5;function isSloppyClickThresholdExceeded(original,current){return Math.abs(current.x-original.x)>=sloppyClickThreshold||Math.abs(current.y-original.y)>=sloppyClickThreshold}var idle$1={type:"IDLE"};function getCaptureBindings(_ref){var cancel=_ref.cancel,completed=_ref.completed,getPhase=_ref.getPhase,setPhase=_ref.setPhase;return[{eventName:"mousemove",fn:function fn(event){var button=event.button,clientX=event.clientX,clientY=event.clientY;if(button!==primaryButton){return}var point={x:clientX,y:clientY};var phase=getPhase();if(phase.type==="DRAGGING"){event.preventDefault();phase.actions.move(point);return}!(phase.type==="PENDING")?false?undefined:invariant(false):void 0;var pending=phase.point;if(!isSloppyClickThresholdExceeded(pending,point)){return}event.preventDefault();var actions=phase.actions.fluidLift(point);setPhase({type:"DRAGGING",actions:actions})}},{eventName:"mouseup",fn:function fn(event){var phase=getPhase();if(phase.type!=="DRAGGING"){cancel();return}event.preventDefault();phase.actions.drop({shouldBlockNextClick:true});completed()}},{eventName:"mousedown",fn:function fn(event){if(getPhase().type==="DRAGGING"){event.preventDefault()}cancel()}},{eventName:"keydown",fn:function fn(event){var phase=getPhase();if(phase.type==="PENDING"){cancel();return}if(event.keyCode===escape){event.preventDefault();cancel();return}preventStandardKeyEvents(event)}},{eventName:"resize",fn:cancel},{eventName:"scroll",options:{passive:true,capture:false},fn:function fn(){if(getPhase().type==="PENDING"){cancel()}}},{eventName:"webkitmouseforcedown",fn:function fn(event){var phase=getPhase();!(phase.type!=="IDLE")?false?undefined:invariant(false):void 0;if(phase.actions.shouldRespectForcePress()){cancel();return}event.preventDefault()}},{eventName:supportedEventName,fn:cancel}]}function useMouseSensor(api){var phaseRef=React.useRef(idle$1);var unbindEventsRef=React.useRef(noop);var startCaptureBinding=useMemoOne.useMemo((function(){return{eventName:"mousedown",fn:function onMouseDown(event){if(event.defaultPrevented){return}if(event.button!==primaryButton){return}if(event.ctrlKey||event.metaKey||event.shiftKey||event.altKey){return}var draggableId=api.findClosestDraggableId(event);if(!draggableId){return}var actions=api.tryGetLock(draggableId,stop,{sourceEvent:event});if(!actions){return}event.preventDefault();var point={x:event.clientX,y:event.clientY};unbindEventsRef.current();startPendingDrag(actions,point)}}}),[api]);var preventForcePressBinding=useMemoOne.useMemo((function(){return{eventName:"webkitmouseforcewillbegin",fn:function fn(event){if(event.defaultPrevented){return}var id=api.findClosestDraggableId(event);if(!id){return}var options=api.findOptionsForDraggable(id);if(!options){return}if(options.shouldRespectForcePress){return}if(!api.canGetLock(id)){return}event.preventDefault()}}}),[api]);var listenForCapture=useMemoOne.useCallback((function listenForCapture(){var options={passive:false,capture:true};unbindEventsRef.current=bindEvents(window,[preventForcePressBinding,startCaptureBinding],options)}),[preventForcePressBinding,startCaptureBinding]);var stop=useMemoOne.useCallback((function(){var current=phaseRef.current;if(current.type==="IDLE"){return}phaseRef.current=idle$1;unbindEventsRef.current();listenForCapture()}),[listenForCapture]);var cancel=useMemoOne.useCallback((function(){var phase=phaseRef.current;stop();if(phase.type==="DRAGGING"){phase.actions.cancel({shouldBlockNextClick:true})}if(phase.type==="PENDING"){phase.actions.abort()}}),[stop]);var bindCapturingEvents=useMemoOne.useCallback((function bindCapturingEvents(){var options={capture:true,passive:false};var bindings=getCaptureBindings({cancel:cancel,completed:stop,getPhase:function getPhase(){return phaseRef.current},setPhase:function setPhase(phase){phaseRef.current=phase}});unbindEventsRef.current=bindEvents(window,bindings,options)}),[cancel,stop]);var startPendingDrag=useMemoOne.useCallback((function startPendingDrag(actions,point){!(phaseRef.current.type==="IDLE")?false?undefined:invariant(false):void 0;phaseRef.current={type:"PENDING",point:point,actions:actions};bindCapturingEvents()}),[bindCapturingEvents]);useIsomorphicLayoutEffect((function mount(){listenForCapture();return function unmount(){unbindEventsRef.current()}}),[listenForCapture])}var _scrollJumpKeys;function noop$1(){}var scrollJumpKeys=(_scrollJumpKeys={},_scrollJumpKeys[pageDown]=true,_scrollJumpKeys[pageUp]=true,_scrollJumpKeys[home]=true,_scrollJumpKeys[end]=true,_scrollJumpKeys);function getDraggingBindings(actions,stop){function cancel(){stop();actions.cancel()}function drop(){stop();actions.drop()}return[{eventName:"keydown",fn:function fn(event){if(event.keyCode===escape){event.preventDefault();cancel();return}if(event.keyCode===space){event.preventDefault();drop();return}if(event.keyCode===arrowDown){event.preventDefault();actions.moveDown();return}if(event.keyCode===arrowUp){event.preventDefault();actions.moveUp();return}if(event.keyCode===arrowRight){event.preventDefault();actions.moveRight();return}if(event.keyCode===arrowLeft){event.preventDefault();actions.moveLeft();return}if(scrollJumpKeys[event.keyCode]){event.preventDefault();return}preventStandardKeyEvents(event)}},{eventName:"mousedown",fn:cancel},{eventName:"mouseup",fn:cancel},{eventName:"click",fn:cancel},{eventName:"touchstart",fn:cancel},{eventName:"resize",fn:cancel},{eventName:"wheel",fn:cancel,options:{passive:true}},{eventName:supportedEventName,fn:cancel}]}function useKeyboardSensor(api){var unbindEventsRef=React.useRef(noop$1);var startCaptureBinding=useMemoOne.useMemo((function(){return{eventName:"keydown",fn:function onKeyDown(event){if(event.defaultPrevented){return}if(event.keyCode!==space){return}var draggableId=api.findClosestDraggableId(event);if(!draggableId){return}var preDrag=api.tryGetLock(draggableId,stop,{sourceEvent:event});if(!preDrag){return}event.preventDefault();var isCapturing=true;var actions=preDrag.snapLift();unbindEventsRef.current();function stop(){!isCapturing?false?undefined:invariant(false):void 0;isCapturing=false;unbindEventsRef.current();listenForCapture()}unbindEventsRef.current=bindEvents(window,getDraggingBindings(actions,stop),{capture:true,passive:false})}}}),[api]);var listenForCapture=useMemoOne.useCallback((function tryStartCapture(){var options={passive:false,capture:true};unbindEventsRef.current=bindEvents(window,[startCaptureBinding],options)}),[startCaptureBinding]);useIsomorphicLayoutEffect((function mount(){listenForCapture();return function unmount(){unbindEventsRef.current()}}),[listenForCapture])}var idle$2={type:"IDLE"};var timeForLongPress=120;var forcePressThreshold=.15;function getWindowBindings(_ref){var cancel=_ref.cancel,getPhase=_ref.getPhase;return[{eventName:"orientationchange",fn:cancel},{eventName:"resize",fn:cancel},{eventName:"contextmenu",fn:function fn(event){event.preventDefault()}},{eventName:"keydown",fn:function fn(event){if(getPhase().type!=="DRAGGING"){cancel();return}if(event.keyCode===escape){event.preventDefault()}cancel()}},{eventName:supportedEventName,fn:cancel}]}function getHandleBindings(_ref2){var cancel=_ref2.cancel,completed=_ref2.completed,getPhase=_ref2.getPhase;return[{eventName:"touchmove",options:{capture:false},fn:function fn(event){var phase=getPhase();if(phase.type!=="DRAGGING"){cancel();return}phase.hasMoved=true;var _event$touches$=event.touches[0],clientX=_event$touches$.clientX,clientY=_event$touches$.clientY;var point={x:clientX,y:clientY};event.preventDefault();phase.actions.move(point)}},{eventName:"touchend",fn:function fn(event){var phase=getPhase();if(phase.type!=="DRAGGING"){cancel();return}event.preventDefault();phase.actions.drop({shouldBlockNextClick:true});completed()}},{eventName:"touchcancel",fn:function fn(event){if(getPhase().type!=="DRAGGING"){cancel();return}event.preventDefault();cancel()}},{eventName:"touchforcechange",fn:function fn(event){var phase=getPhase();!(phase.type!=="IDLE")?false?undefined:invariant(false):void 0;var touch=event.touches[0];if(!touch){return}var isForcePress=touch.force>=forcePressThreshold;if(!isForcePress){return}var shouldRespect=phase.actions.shouldRespectForcePress();if(phase.type==="PENDING"){if(shouldRespect){cancel()}return}if(shouldRespect){if(phase.hasMoved){event.preventDefault();return}cancel();return}event.preventDefault()}},{eventName:supportedEventName,fn:cancel}]}function useMouseSensor$1(api){var phaseRef=React.useRef(idle$2);var unbindEventsRef=React.useRef(noop);var getPhase=useMemoOne.useCallback((function getPhase(){return phaseRef.current}),[]);var setPhase=useMemoOne.useCallback((function setPhase(phase){phaseRef.current=phase}),[]);var startCaptureBinding=useMemoOne.useMemo((function(){return{eventName:"touchstart",fn:function onTouchStart(event){if(event.defaultPrevented){return}var draggableId=api.findClosestDraggableId(event);if(!draggableId){return}var actions=api.tryGetLock(draggableId,stop,{sourceEvent:event});if(!actions){return}var touch=event.touches[0];var clientX=touch.clientX,clientY=touch.clientY;var point={x:clientX,y:clientY};unbindEventsRef.current();startPendingDrag(actions,point)}}}),[api]);var listenForCapture=useMemoOne.useCallback((function listenForCapture(){var options={capture:true,passive:false};unbindEventsRef.current=bindEvents(window,[startCaptureBinding],options)}),[startCaptureBinding]);var stop=useMemoOne.useCallback((function(){var current=phaseRef.current;if(current.type==="IDLE"){return}if(current.type==="PENDING"){clearTimeout(current.longPressTimerId)}setPhase(idle$2);unbindEventsRef.current();listenForCapture()}),[listenForCapture,setPhase]);var cancel=useMemoOne.useCallback((function(){var phase=phaseRef.current;stop();if(phase.type==="DRAGGING"){phase.actions.cancel({shouldBlockNextClick:true})}if(phase.type==="PENDING"){phase.actions.abort()}}),[stop]);var bindCapturingEvents=useMemoOne.useCallback((function bindCapturingEvents(){var options={capture:true,passive:false};var args={cancel:cancel,completed:stop,getPhase:getPhase};var unbindTarget=bindEvents(window,getHandleBindings(args),options);var unbindWindow=bindEvents(window,getWindowBindings(args),options);unbindEventsRef.current=function unbindAll(){unbindTarget();unbindWindow()}}),[cancel,getPhase,stop]);var startDragging=useMemoOne.useCallback((function startDragging(){var phase=getPhase();!(phase.type==="PENDING")?false?undefined:invariant(false):void 0;var actions=phase.actions.fluidLift(phase.point);setPhase({type:"DRAGGING",actions:actions,hasMoved:false})}),[getPhase,setPhase]);var startPendingDrag=useMemoOne.useCallback((function startPendingDrag(actions,point){!(getPhase().type==="IDLE")?false?undefined:invariant(false):void 0;var longPressTimerId=setTimeout(startDragging,timeForLongPress);setPhase({type:"PENDING",point:point,actions:actions,longPressTimerId:longPressTimerId});bindCapturingEvents()}),[bindCapturingEvents,getPhase,setPhase,startDragging]);useIsomorphicLayoutEffect((function mount(){listenForCapture();return function unmount(){unbindEventsRef.current();var phase=getPhase();if(phase.type==="PENDING"){clearTimeout(phase.longPressTimerId);setPhase(idle$2)}}}),[getPhase,listenForCapture,setPhase]);useIsomorphicLayoutEffect((function webkitHack(){var unbind=bindEvents(window,[{eventName:"touchmove",fn:function fn(){},options:{capture:false,passive:false}}]);return unbind}),[])}function useValidateSensorHooks(sensorHooks){useDev((function(){var previousRef=usePrevious(sensorHooks);useDevSetupWarning((function(){!(previousRef.current.length===sensorHooks.length)?false?undefined:invariant(false):void 0}))}))}var interactiveTagNames={input:true,button:true,textarea:true,select:true,option:true,optgroup:true,video:true,audio:true};function isAnInteractiveElement(parent,current){if(current==null){return false}var hasAnInteractiveTag=Boolean(interactiveTagNames[current.tagName.toLowerCase()]);if(hasAnInteractiveTag){return true}var attribute=current.getAttribute("contenteditable");if(attribute==="true"||attribute===""){return true}if(current===parent){return false}return isAnInteractiveElement(parent,current.parentElement)}function isEventInInteractiveElement(draggable,event){var target=event.target;if(!isHtmlElement(target)){return false}return isAnInteractiveElement(draggable,target)}var getBorderBoxCenterPosition=function(el){return cssBoxModel.getRect(el.getBoundingClientRect()).center};function isElement(el){return el instanceof getWindowFromEl(el).Element}var supportedMatchesName=function(){var base="matches";if(typeof document==="undefined"){return base}var candidates=[base,"msMatchesSelector","webkitMatchesSelector"];var value=find(candidates,(function(name){return name in Element.prototype}));return value||base}();function closestPonyfill(el,selector){if(el==null){return null}if(el[supportedMatchesName](selector)){return el}return closestPonyfill(el.parentElement,selector)}function closest$1(el,selector){if(el.closest){return el.closest(selector)}return closestPonyfill(el,selector)}function getSelector(contextId){return"["+dragHandle.contextId+'="'+contextId+'"]'}function findClosestDragHandleFromEvent(contextId,event){var target=event.target;if(!isElement(target)){false?undefined:void 0;return null}var selector=getSelector(contextId);var handle=closest$1(target,selector);if(!handle){return null}if(!isHtmlElement(handle)){false?undefined:void 0;return null}return handle}function tryGetClosestDraggableIdFromEvent(contextId,event){var handle=findClosestDragHandleFromEvent(contextId,event);if(!handle){return null}return handle.getAttribute(dragHandle.draggableId)}function findDraggable(contextId,draggableId){var selector="["+draggable.contextId+'="'+contextId+'"]';var possible=toArray(document.querySelectorAll(selector));var draggable$1=find(possible,(function(el){return el.getAttribute(draggable.id)===draggableId}));if(!draggable$1){return null}if(!isHtmlElement(draggable$1)){false?undefined:void 0;return null}return draggable$1}function preventDefault(event){event.preventDefault()}function _isActive(_ref){var expected=_ref.expected,phase=_ref.phase,isLockActive=_ref.isLockActive,shouldWarn=_ref.shouldWarn;if(!isLockActive()){if(shouldWarn){false?undefined:void 0}return false}if(expected!==phase){if(shouldWarn){false?undefined:void 0}return false}return true}function canStart(_ref2){var lockAPI=_ref2.lockAPI,store=_ref2.store,registry=_ref2.registry,draggableId=_ref2.draggableId;if(lockAPI.isClaimed()){return false}var entry=registry.draggable.findById(draggableId);if(!entry){false?undefined:void 0;return false}if(!entry.options.isEnabled){return false}if(!canStartDrag(store.getState(),draggableId)){return false}return true}function tryStart(_ref3){var lockAPI=_ref3.lockAPI,contextId=_ref3.contextId,store=_ref3.store,registry=_ref3.registry,draggableId=_ref3.draggableId,forceSensorStop=_ref3.forceSensorStop,sourceEvent=_ref3.sourceEvent;var shouldStart=canStart({lockAPI:lockAPI,store:store,registry:registry,draggableId:draggableId});if(!shouldStart){return null}var entry=registry.draggable.getById(draggableId);var el=findDraggable(contextId,entry.descriptor.id);if(!el){false?undefined:void 0;return null}if(sourceEvent&&!entry.options.canDragInteractiveElements&&isEventInInteractiveElement(el,sourceEvent)){return null}var lock=lockAPI.claim(forceSensorStop||noop);var phase="PRE_DRAG";function getShouldRespectForcePress(){return entry.options.shouldRespectForcePress}function isLockActive(){return lockAPI.isActive(lock)}function tryDispatch(expected,getAction){if(_isActive({expected:expected,phase:phase,isLockActive:isLockActive,shouldWarn:true})){store.dispatch(getAction())}}var tryDispatchWhenDragging=tryDispatch.bind(null,"DRAGGING");function lift$1(args){function completed(){lockAPI.release();phase="COMPLETED"}if(phase!=="PRE_DRAG"){completed();!(phase==="PRE_DRAG")?false?undefined:invariant(false):void 0}store.dispatch(lift(args.liftActionArgs));phase="DRAGGING";function finish(reason,options){if(options===void 0){options={shouldBlockNextClick:false}}args.cleanup();if(options.shouldBlockNextClick){var unbind=bindEvents(window,[{eventName:"click",fn:preventDefault,options:{once:true,passive:false,capture:true}}]);setTimeout(unbind)}completed();store.dispatch(drop({reason:reason}))}return _extends({isActive:function isActive(){return _isActive({expected:"DRAGGING",phase:phase,isLockActive:isLockActive,shouldWarn:false})},shouldRespectForcePress:getShouldRespectForcePress,drop:function drop(options){return finish("DROP",options)},cancel:function cancel(options){return finish("CANCEL",options)}},args.actions)}function fluidLift(clientSelection){var move$1=rafSchd((function(client){tryDispatchWhenDragging((function(){return move({client:client})}))}));var api=lift$1({liftActionArgs:{id:draggableId,clientSelection:clientSelection,movementMode:"FLUID"},cleanup:function cleanup(){return move$1.cancel()},actions:{move:move$1}});return _extends({},api,{move:move$1})}function snapLift(){var actions={moveUp:function moveUp$1(){return tryDispatchWhenDragging(moveUp)},moveRight:function moveRight$1(){return tryDispatchWhenDragging(moveRight)},moveDown:function moveDown$1(){return tryDispatchWhenDragging(moveDown)},moveLeft:function moveLeft$1(){return tryDispatchWhenDragging(moveLeft)}};return lift$1({liftActionArgs:{id:draggableId,clientSelection:getBorderBoxCenterPosition(el),movementMode:"SNAP"},cleanup:noop,actions:actions})}function abortPreDrag(){var shouldRelease=_isActive({expected:"PRE_DRAG",phase:phase,isLockActive:isLockActive,shouldWarn:true});if(shouldRelease){lockAPI.release()}}var preDrag={isActive:function isActive(){return _isActive({expected:"PRE_DRAG",phase:phase,isLockActive:isLockActive,shouldWarn:false})},shouldRespectForcePress:getShouldRespectForcePress,fluidLift:fluidLift,snapLift:snapLift,abort:abortPreDrag};return preDrag}var defaultSensors=[useMouseSensor,useKeyboardSensor,useMouseSensor$1];function useSensorMarshal(_ref4){var contextId=_ref4.contextId,store=_ref4.store,registry=_ref4.registry,customSensors=_ref4.customSensors,enableDefaultSensors=_ref4.enableDefaultSensors;var useSensors=[].concat(enableDefaultSensors?defaultSensors:[],customSensors||[]);var lockAPI=React.useState((function(){return create()}))[0];var tryAbandonLock=useMemoOne.useCallback((function tryAbandonLock(previous,current){if(previous.isDragging&&!current.isDragging){lockAPI.tryAbandon()}}),[lockAPI]);useIsomorphicLayoutEffect((function listenToStore(){var previous=store.getState();var unsubscribe=store.subscribe((function(){var current=store.getState();tryAbandonLock(previous,current);previous=current}));return unsubscribe}),[lockAPI,store,tryAbandonLock]);useIsomorphicLayoutEffect((function(){return lockAPI.tryAbandon}),[lockAPI.tryAbandon]);var canGetLock=useMemoOne.useCallback((function(draggableId){return canStart({lockAPI:lockAPI,registry:registry,store:store,draggableId:draggableId})}),[lockAPI,registry,store]);var tryGetLock=useMemoOne.useCallback((function(draggableId,forceStop,options){return tryStart({lockAPI:lockAPI,registry:registry,contextId:contextId,store:store,draggableId:draggableId,forceSensorStop:forceStop,sourceEvent:options&&options.sourceEvent?options.sourceEvent:null})}),[contextId,lockAPI,registry,store]);var findClosestDraggableId=useMemoOne.useCallback((function(event){return tryGetClosestDraggableIdFromEvent(contextId,event)}),[contextId]);var findOptionsForDraggable=useMemoOne.useCallback((function(id){var entry=registry.draggable.findById(id);return entry?entry.options:null}),[registry.draggable]);var tryReleaseLock=useMemoOne.useCallback((function tryReleaseLock(){if(!lockAPI.isClaimed()){return}lockAPI.tryAbandon();if(store.getState().phase!=="IDLE"){store.dispatch(flush())}}),[lockAPI,store]);var isLockClaimed=useMemoOne.useCallback(lockAPI.isClaimed,[lockAPI]);var api=useMemoOne.useMemo((function(){return{canGetLock:canGetLock,tryGetLock:tryGetLock,findClosestDraggableId:findClosestDraggableId,findOptionsForDraggable:findOptionsForDraggable,tryReleaseLock:tryReleaseLock,isLockClaimed:isLockClaimed}}),[canGetLock,tryGetLock,findClosestDraggableId,findOptionsForDraggable,tryReleaseLock,isLockClaimed]);useValidateSensorHooks(useSensors);for(var i=0;i<useSensors.length;i++){useSensors[i](api)}}var createResponders=function createResponders(props){return{onBeforeCapture:props.onBeforeCapture,onBeforeDragStart:props.onBeforeDragStart,onDragStart:props.onDragStart,onDragEnd:props.onDragEnd,onDragUpdate:props.onDragUpdate}};function getStore(lazyRef){!lazyRef.current?false?undefined:invariant(false):void 0;return lazyRef.current}function App(props){var contextId=props.contextId,setCallbacks=props.setCallbacks,sensors=props.sensors,nonce=props.nonce,dragHandleUsageInstructions=props.dragHandleUsageInstructions;var lazyStoreRef=React.useRef(null);useStartupValidation();var lastPropsRef=usePrevious(props);var getResponders=useMemoOne.useCallback((function(){return createResponders(lastPropsRef.current)}),[lastPropsRef]);var announce=useAnnouncer(contextId);var dragHandleUsageInstructionsId=useHiddenTextElement({contextId:contextId,text:dragHandleUsageInstructions});var styleMarshal=useStyleMarshal(contextId,nonce);var lazyDispatch=useMemoOne.useCallback((function(action){getStore(lazyStoreRef).dispatch(action)}),[]);var marshalCallbacks=useMemoOne.useMemo((function(){return redux.bindActionCreators({publishWhileDragging:publishWhileDragging,updateDroppableScroll:updateDroppableScroll,updateDroppableIsEnabled:updateDroppableIsEnabled,updateDroppableIsCombineEnabled:updateDroppableIsCombineEnabled,collectionStarting:collectionStarting},lazyDispatch)}),[lazyDispatch]);var registry=useRegistry();var dimensionMarshal=useMemoOne.useMemo((function(){return createDimensionMarshal(registry,marshalCallbacks)}),[registry,marshalCallbacks]);var autoScroller=useMemoOne.useMemo((function(){return createAutoScroller(_extends({scrollWindow:scrollWindow,scrollDroppable:dimensionMarshal.scrollDroppable},redux.bindActionCreators({move:move},lazyDispatch)))}),[dimensionMarshal.scrollDroppable,lazyDispatch]);var focusMarshal=useFocusMarshal(contextId);var store=useMemoOne.useMemo((function(){return createStore({announce:announce,autoScroller:autoScroller,dimensionMarshal:dimensionMarshal,focusMarshal:focusMarshal,getResponders:getResponders,styleMarshal:styleMarshal})}),[announce,autoScroller,dimensionMarshal,focusMarshal,getResponders,styleMarshal]);if(false){}lazyStoreRef.current=store;var tryResetStore=useMemoOne.useCallback((function(){var current=getStore(lazyStoreRef);var state=current.getState();if(state.phase!=="IDLE"){current.dispatch(flush())}}),[]);var isDragging=useMemoOne.useCallback((function(){var state=getStore(lazyStoreRef).getState();return state.isDragging||state.phase==="DROP_ANIMATING"}),[]);var appCallbacks=useMemoOne.useMemo((function(){return{isDragging:isDragging,tryAbort:tryResetStore}}),[isDragging,tryResetStore]);setCallbacks(appCallbacks);var getCanLift=useMemoOne.useCallback((function(id){return canStartDrag(getStore(lazyStoreRef).getState(),id)}),[]);var getIsMovementAllowed=useMemoOne.useCallback((function(){return isMovementAllowed(getStore(lazyStoreRef).getState())}),[]);var appContext=useMemoOne.useMemo((function(){return{marshal:dimensionMarshal,focus:focusMarshal,contextId:contextId,canLift:getCanLift,isMovementAllowed:getIsMovementAllowed,dragHandleUsageInstructionsId:dragHandleUsageInstructionsId,registry:registry}}),[contextId,dimensionMarshal,dragHandleUsageInstructionsId,focusMarshal,getCanLift,getIsMovementAllowed,registry]);useSensorMarshal({contextId:contextId,store:store,registry:registry,customSensors:sensors,enableDefaultSensors:props.enableDefaultSensors!==false});React.useEffect((function(){return tryResetStore}),[tryResetStore]);return React__default.createElement(AppContext.Provider,{value:appContext},React__default.createElement(reactRedux.Provider,{context:StoreContext,store:store},props.children))}var count$1=0;function reset$1(){count$1=0}function useInstanceCount(){return useMemoOne.useMemo((function(){return""+count$1++}),[])}function resetServerContext(){reset$1();reset()}function DragDropContext(props){var contextId=useInstanceCount();var dragHandleUsageInstructions=props.dragHandleUsageInstructions||preset.dragHandleUsageInstructions;return React__default.createElement(ErrorBoundary,null,(function(setCallbacks){return React__default.createElement(App,{nonce:props.nonce,contextId:contextId,setCallbacks:setCallbacks,dragHandleUsageInstructions:dragHandleUsageInstructions,enableDefaultSensors:props.enableDefaultSensors,sensors:props.sensors,onBeforeCapture:props.onBeforeCapture,onBeforeDragStart:props.onBeforeDragStart,onDragStart:props.onDragStart,onDragUpdate:props.onDragUpdate,onDragEnd:props.onDragEnd},props.children)}))}var isEqual$1=function isEqual(base){return function(value){return base===value}};var isScroll=isEqual$1("scroll");var isAuto=isEqual$1("auto");var isVisible$1=isEqual$1("visible");var isEither=function isEither(overflow,fn){return fn(overflow.overflowX)||fn(overflow.overflowY)};var isBoth=function isBoth(overflow,fn){return fn(overflow.overflowX)&&fn(overflow.overflowY)};var isElementScrollable=function isElementScrollable(el){var style=window.getComputedStyle(el);var overflow={overflowX:style.overflowX,overflowY:style.overflowY};return isEither(overflow,isScroll)||isEither(overflow,isAuto)};var isBodyScrollable=function isBodyScrollable(){if(true){return false}var body=getBodyElement();var html=document.documentElement;!html?false?undefined:invariant(false):void 0;if(!isElementScrollable(body)){return false}var htmlStyle=window.getComputedStyle(html);var htmlOverflow={overflowX:htmlStyle.overflowX,overflowY:htmlStyle.overflowY};if(isBoth(htmlOverflow,isVisible$1)){return false}false?undefined:void 0;return false};var getClosestScrollable=function getClosestScrollable(el){if(el==null){return null}if(el===document.body){return isBodyScrollable()?el:null}if(el===document.documentElement){return null}if(!isElementScrollable(el)){return getClosestScrollable(el.parentElement)}return el};var checkForNestedScrollContainers=function(scrollable){if(!scrollable){return}var anotherScrollParent=getClosestScrollable(scrollable.parentElement);if(!anotherScrollParent){return}false?undefined:void 0};var getScroll$1=function(el){return{x:el.scrollLeft,y:el.scrollTop}};var getIsFixed=function getIsFixed(el){if(!el){return false}var style=window.getComputedStyle(el);if(style.position==="fixed"){return true}return getIsFixed(el.parentElement)};var getEnv=function(start){var closestScrollable=getClosestScrollable(start);var isFixedOnPage=getIsFixed(start);return{closestScrollable:closestScrollable,isFixedOnPage:isFixedOnPage}};var getDroppableDimension=function(_ref){var descriptor=_ref.descriptor,isEnabled=_ref.isEnabled,isCombineEnabled=_ref.isCombineEnabled,isFixedOnPage=_ref.isFixedOnPage,direction=_ref.direction,client=_ref.client,page=_ref.page,closest=_ref.closest;var frame=function(){if(!closest){return null}var scrollSize=closest.scrollSize,frameClient=closest.client;var maxScroll=getMaxScroll({scrollHeight:scrollSize.scrollHeight,scrollWidth:scrollSize.scrollWidth,height:frameClient.paddingBox.height,width:frameClient.paddingBox.width});return{pageMarginBox:closest.page.marginBox,frameClient:frameClient,scrollSize:scrollSize,shouldClipSubject:closest.shouldClipSubject,scroll:{initial:closest.scroll,current:closest.scroll,max:maxScroll,diff:{value:origin,displacement:origin}}}}();var axis=direction==="vertical"?vertical:horizontal;var subject=getSubject({page:page,withPlaceholder:null,axis:axis,frame:frame});var dimension={descriptor:descriptor,isCombineEnabled:isCombineEnabled,isFixedOnPage:isFixedOnPage,axis:axis,isEnabled:isEnabled,client:client,page:page,frame:frame,subject:subject};return dimension};var getClient=function getClient(targetRef,closestScrollable){var base=cssBoxModel.getBox(targetRef);if(!closestScrollable){return base}if(targetRef!==closestScrollable){return base}var top=base.paddingBox.top-closestScrollable.scrollTop;var left=base.paddingBox.left-closestScrollable.scrollLeft;var bottom=top+closestScrollable.scrollHeight;var right=left+closestScrollable.scrollWidth;var paddingBox={top:top,right:right,bottom:bottom,left:left};var borderBox=cssBoxModel.expand(paddingBox,base.border);var client=cssBoxModel.createBox({borderBox:borderBox,margin:base.margin,border:base.border,padding:base.padding});return client};var getDimension=function(_ref){var ref=_ref.ref,descriptor=_ref.descriptor,env=_ref.env,windowScroll=_ref.windowScroll,direction=_ref.direction,isDropDisabled=_ref.isDropDisabled,isCombineEnabled=_ref.isCombineEnabled,shouldClipSubject=_ref.shouldClipSubject;var closestScrollable=env.closestScrollable;var client=getClient(ref,closestScrollable);var page=cssBoxModel.withScroll(client,windowScroll);var closest=function(){if(!closestScrollable){return null}var frameClient=cssBoxModel.getBox(closestScrollable);var scrollSize={scrollHeight:closestScrollable.scrollHeight,scrollWidth:closestScrollable.scrollWidth};return{client:frameClient,page:cssBoxModel.withScroll(frameClient,windowScroll),scroll:getScroll$1(closestScrollable),scrollSize:scrollSize,shouldClipSubject:shouldClipSubject}}();var dimension=getDroppableDimension({descriptor:descriptor,isEnabled:!isDropDisabled,isCombineEnabled:isCombineEnabled,isFixedOnPage:env.isFixedOnPage,direction:direction,client:client,page:page,closest:closest});return dimension};var immediate={passive:false};var delayed={passive:true};var getListenerOptions=function(options){return options.shouldPublishImmediately?immediate:delayed};function useRequiredContext(Context){var result=React.useContext(Context);!result?false?undefined:invariant(false):void 0;return result}var getClosestScrollableFromDrag=function getClosestScrollableFromDrag(dragging){return dragging&&dragging.env.closestScrollable||null};function useDroppablePublisher(args){var whileDraggingRef=React.useRef(null);var appContext=useRequiredContext(AppContext);var uniqueId=useUniqueId("droppable");var registry=appContext.registry,marshal=appContext.marshal;var previousRef=usePrevious(args);var descriptor=useMemoOne.useMemo((function(){return{id:args.droppableId,type:args.type,mode:args.mode}}),[args.droppableId,args.mode,args.type]);var publishedDescriptorRef=React.useRef(descriptor);var memoizedUpdateScroll=useMemoOne.useMemo((function(){return memoizeOne((function(x,y){!whileDraggingRef.current?false?undefined:invariant(false):void 0;var scroll={x:x,y:y};marshal.updateDroppableScroll(descriptor.id,scroll)}))}),[descriptor.id,marshal]);var getClosestScroll=useMemoOne.useCallback((function(){var dragging=whileDraggingRef.current;if(!dragging||!dragging.env.closestScrollable){return origin}return getScroll$1(dragging.env.closestScrollable)}),[]);var updateScroll=useMemoOne.useCallback((function(){var scroll=getClosestScroll();memoizedUpdateScroll(scroll.x,scroll.y)}),[getClosestScroll,memoizedUpdateScroll]);var scheduleScrollUpdate=useMemoOne.useMemo((function(){return rafSchd(updateScroll)}),[updateScroll]);var onClosestScroll=useMemoOne.useCallback((function(){var dragging=whileDraggingRef.current;var closest=getClosestScrollableFromDrag(dragging);!(dragging&&closest)?false?undefined:invariant(false):void 0;var options=dragging.scrollOptions;if(options.shouldPublishImmediately){updateScroll();return}scheduleScrollUpdate()}),[scheduleScrollUpdate,updateScroll]);var getDimensionAndWatchScroll=useMemoOne.useCallback((function(windowScroll,options){!!whileDraggingRef.current?false?undefined:invariant(false):void 0;var previous=previousRef.current;var ref=previous.getDroppableRef();!ref?false?undefined:invariant(false):void 0;var env=getEnv(ref);var dragging={ref:ref,descriptor:descriptor,env:env,scrollOptions:options};whileDraggingRef.current=dragging;var dimension=getDimension({ref:ref,descriptor:descriptor,env:env,windowScroll:windowScroll,direction:previous.direction,isDropDisabled:previous.isDropDisabled,isCombineEnabled:previous.isCombineEnabled,shouldClipSubject:!previous.ignoreContainerClipping});var scrollable=env.closestScrollable;if(scrollable){scrollable.setAttribute(scrollContainer.contextId,appContext.contextId);scrollable.addEventListener("scroll",onClosestScroll,getListenerOptions(dragging.scrollOptions));if(false){}}return dimension}),[appContext.contextId,descriptor,onClosestScroll,previousRef]);var getScrollWhileDragging=useMemoOne.useCallback((function(){var dragging=whileDraggingRef.current;var closest=getClosestScrollableFromDrag(dragging);!(dragging&&closest)?false?undefined:invariant(false):void 0;return getScroll$1(closest)}),[]);var dragStopped=useMemoOne.useCallback((function(){var dragging=whileDraggingRef.current;!dragging?false?undefined:invariant(false):void 0;var closest=getClosestScrollableFromDrag(dragging);whileDraggingRef.current=null;if(!closest){return}scheduleScrollUpdate.cancel();closest.removeAttribute(scrollContainer.contextId);closest.removeEventListener("scroll",onClosestScroll,getListenerOptions(dragging.scrollOptions))}),[onClosestScroll,scheduleScrollUpdate]);var scroll=useMemoOne.useCallback((function(change){var dragging=whileDraggingRef.current;!dragging?false?undefined:invariant(false):void 0;var closest=getClosestScrollableFromDrag(dragging);!closest?false?undefined:invariant(false):void 0;closest.scrollTop+=change.y;closest.scrollLeft+=change.x}),[]);var callbacks=useMemoOne.useMemo((function(){return{getDimensionAndWatchScroll:getDimensionAndWatchScroll,getScrollWhileDragging:getScrollWhileDragging,dragStopped:dragStopped,scroll:scroll}}),[dragStopped,getDimensionAndWatchScroll,getScrollWhileDragging,scroll]);var entry=useMemoOne.useMemo((function(){return{uniqueId:uniqueId,descriptor:descriptor,callbacks:callbacks}}),[callbacks,descriptor,uniqueId]);useIsomorphicLayoutEffect((function(){publishedDescriptorRef.current=entry.descriptor;registry.droppable.register(entry);return function(){if(whileDraggingRef.current){false?undefined:void 0;dragStopped()}registry.droppable.unregister(entry)}}),[callbacks,descriptor,dragStopped,entry,marshal,registry.droppable]);useIsomorphicLayoutEffect((function(){if(!whileDraggingRef.current){return}marshal.updateDroppableIsEnabled(publishedDescriptorRef.current.id,!args.isDropDisabled)}),[args.isDropDisabled,marshal]);useIsomorphicLayoutEffect((function(){if(!whileDraggingRef.current){return}marshal.updateDroppableIsCombineEnabled(publishedDescriptorRef.current.id,args.isCombineEnabled)}),[args.isCombineEnabled,marshal])}function noop$2(){}var empty={width:0,height:0,margin:noSpacing};var getSize=function getSize(_ref){var isAnimatingOpenOnMount=_ref.isAnimatingOpenOnMount,placeholder=_ref.placeholder,animate=_ref.animate;if(isAnimatingOpenOnMount){return empty}if(animate==="close"){return empty}return{height:placeholder.client.borderBox.height,width:placeholder.client.borderBox.width,margin:placeholder.client.margin}};var getStyle=function getStyle(_ref2){var isAnimatingOpenOnMount=_ref2.isAnimatingOpenOnMount,placeholder=_ref2.placeholder,animate=_ref2.animate;var size=getSize({isAnimatingOpenOnMount:isAnimatingOpenOnMount,placeholder:placeholder,animate:animate});return{display:placeholder.display,boxSizing:"border-box",width:size.width,height:size.height,marginTop:size.margin.top,marginRight:size.margin.right,marginBottom:size.margin.bottom,marginLeft:size.margin.left,flexShrink:"0",flexGrow:"0",pointerEvents:"none",transition:animate!=="none"?transitions.placeholder:null}};function Placeholder(props){var animateOpenTimerRef=React.useRef(null);var tryClearAnimateOpenTimer=useMemoOne.useCallback((function(){if(!animateOpenTimerRef.current){return}clearTimeout(animateOpenTimerRef.current);animateOpenTimerRef.current=null}),[]);var animate=props.animate,onTransitionEnd=props.onTransitionEnd,onClose=props.onClose,contextId=props.contextId;var _useState=React.useState(props.animate==="open"),isAnimatingOpenOnMount=_useState[0],setIsAnimatingOpenOnMount=_useState[1];React.useEffect((function(){if(!isAnimatingOpenOnMount){return noop$2}if(animate!=="open"){tryClearAnimateOpenTimer();setIsAnimatingOpenOnMount(false);return noop$2}if(animateOpenTimerRef.current){return noop$2}animateOpenTimerRef.current=setTimeout((function(){animateOpenTimerRef.current=null;setIsAnimatingOpenOnMount(false)}));return tryClearAnimateOpenTimer}),[animate,isAnimatingOpenOnMount,tryClearAnimateOpenTimer]);var onSizeChangeEnd=useMemoOne.useCallback((function(event){if(event.propertyName!=="height"){return}onTransitionEnd();if(animate==="close"){onClose()}}),[animate,onClose,onTransitionEnd]);var style=getStyle({isAnimatingOpenOnMount:isAnimatingOpenOnMount,animate:props.animate,placeholder:props.placeholder});return React__default.createElement(props.placeholder.tagName,{style:style,"data-rbd-placeholder-context-id":contextId,onTransitionEnd:onSizeChangeEnd,ref:props.innerRef})}var Placeholder$1=React__default.memo(Placeholder);var DroppableContext=React__default.createContext(null);function checkIsValidInnerRef(el){!(el&&isHtmlElement(el))?false?undefined:invariant(false):void 0}function isBoolean(value){return typeof value==="boolean"}function runChecks(args,checks){checks.forEach((function(check){return check(args)}))}var shared=[function required(_ref){var props=_ref.props;!props.droppableId?false?undefined:invariant(false):void 0;!(typeof props.droppableId==="string")?false?undefined:invariant(false):void 0},function _boolean(_ref2){var props=_ref2.props;!isBoolean(props.isDropDisabled)?false?undefined:invariant(false):void 0;!isBoolean(props.isCombineEnabled)?false?undefined:invariant(false):void 0;!isBoolean(props.ignoreContainerClipping)?false?undefined:invariant(false):void 0},function ref(_ref3){var getDroppableRef=_ref3.getDroppableRef;checkIsValidInnerRef(getDroppableRef())}];var standard=[function placeholder(_ref4){var props=_ref4.props,getPlaceholderRef=_ref4.getPlaceholderRef;if(!props.placeholder){return}var ref=getPlaceholderRef();if(ref){return}false?undefined:void 0}];var virtual=[function hasClone(_ref5){var props=_ref5.props;!props.renderClone?false?undefined:invariant(false):void 0},function hasNoPlaceholder(_ref6){var getPlaceholderRef=_ref6.getPlaceholderRef;!!getPlaceholderRef()?false?undefined:invariant(false):void 0}];function useValidation(args){useDevSetupWarning((function(){runChecks(args,shared);if(args.props.mode==="standard"){runChecks(args,standard)}if(args.props.mode==="virtual"){runChecks(args,virtual)}}))}var AnimateInOut=function(_React$PureComponent){_inheritsLoose(AnimateInOut,_React$PureComponent);function AnimateInOut(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_React$PureComponent.call.apply(_React$PureComponent,[this].concat(args))||this;_this.state={isVisible:Boolean(_this.props.on),data:_this.props.on,animate:_this.props.shouldAnimate&&_this.props.on?"open":"none"};_this.onClose=function(){if(_this.state.animate!=="close"){return}_this.setState({isVisible:false})};return _this}AnimateInOut.getDerivedStateFromProps=function getDerivedStateFromProps(props,state){if(!props.shouldAnimate){return{isVisible:Boolean(props.on),data:props.on,animate:"none"}}if(props.on){return{isVisible:true,data:props.on,animate:"open"}}if(state.isVisible){return{isVisible:true,data:state.data,animate:"close"}}return{isVisible:false,animate:"close",data:null}};var _proto=AnimateInOut.prototype;_proto.render=function render(){if(!this.state.isVisible){return null}var provided={onClose:this.onClose,data:this.state.data,animate:this.state.animate};return this.props.children(provided)};return AnimateInOut}(React__default.PureComponent);var zIndexOptions={dragging:5e3,dropAnimating:4500};var getDraggingTransition=function getDraggingTransition(shouldAnimateDragMovement,dropping){if(dropping){return transitions.drop(dropping.duration)}if(shouldAnimateDragMovement){return transitions.snap}return transitions.fluid};var getDraggingOpacity=function getDraggingOpacity(isCombining,isDropAnimating){if(!isCombining){return null}return isDropAnimating?combine.opacity.drop:combine.opacity.combining};var getShouldDraggingAnimate=function getShouldDraggingAnimate(dragging){if(dragging.forceShouldAnimate!=null){return dragging.forceShouldAnimate}return dragging.mode==="SNAP"};function getDraggingStyle(dragging){var dimension=dragging.dimension;var box=dimension.client;var offset=dragging.offset,combineWith=dragging.combineWith,dropping=dragging.dropping;var isCombining=Boolean(combineWith);var shouldAnimate=getShouldDraggingAnimate(dragging);var isDropAnimating=Boolean(dropping);var transform=isDropAnimating?transforms.drop(offset,isCombining):transforms.moveTo(offset);var style={position:"fixed",top:box.marginBox.top,left:box.marginBox.left,boxSizing:"border-box",width:box.borderBox.width,height:box.borderBox.height,transition:getDraggingTransition(shouldAnimate,dropping),transform:transform,opacity:getDraggingOpacity(isCombining,isDropAnimating),zIndex:isDropAnimating?zIndexOptions.dropAnimating:zIndexOptions.dragging,pointerEvents:"none"};return style}function getSecondaryStyle(secondary){return{transform:transforms.moveTo(secondary.offset),transition:secondary.shouldAnimateDisplacement?null:"none"}}function getStyle$1(mapped){return mapped.type==="DRAGGING"?getDraggingStyle(mapped):getSecondaryStyle(mapped)}function getDimension$1(descriptor,el,windowScroll){if(windowScroll===void 0){windowScroll=origin}var computedStyles=window.getComputedStyle(el);var borderBox=el.getBoundingClientRect();var client=cssBoxModel.calculateBox(borderBox,computedStyles);var page=cssBoxModel.withScroll(client,windowScroll);var placeholder={client:client,tagName:el.tagName.toLowerCase(),display:computedStyles.display};var displaceBy={x:client.marginBox.width,y:client.marginBox.height};var dimension={descriptor:descriptor,placeholder:placeholder,displaceBy:displaceBy,client:client,page:page};return dimension}function useDraggablePublisher(args){var uniqueId=useUniqueId("draggable");var descriptor=args.descriptor,registry=args.registry,getDraggableRef=args.getDraggableRef,canDragInteractiveElements=args.canDragInteractiveElements,shouldRespectForcePress=args.shouldRespectForcePress,isEnabled=args.isEnabled;var options=useMemoOne.useMemo((function(){return{canDragInteractiveElements:canDragInteractiveElements,shouldRespectForcePress:shouldRespectForcePress,isEnabled:isEnabled}}),[canDragInteractiveElements,isEnabled,shouldRespectForcePress]);var getDimension=useMemoOne.useCallback((function(windowScroll){var el=getDraggableRef();!el?false?undefined:invariant(false):void 0;return getDimension$1(descriptor,el,windowScroll)}),[descriptor,getDraggableRef]);var entry=useMemoOne.useMemo((function(){return{uniqueId:uniqueId,descriptor:descriptor,options:options,getDimension:getDimension}}),[descriptor,getDimension,options,uniqueId]);var publishedRef=React.useRef(entry);var isFirstPublishRef=React.useRef(true);useIsomorphicLayoutEffect((function(){registry.draggable.register(publishedRef.current);return function(){return registry.draggable.unregister(publishedRef.current)}}),[registry.draggable]);useIsomorphicLayoutEffect((function(){if(isFirstPublishRef.current){isFirstPublishRef.current=false;return}var last=publishedRef.current;publishedRef.current=entry;registry.draggable.update(entry,last)}),[entry,registry.draggable])}function useValidation$1(props,contextId,getRef){useDevSetupWarning((function(){function prefix(id){return"Draggable[id: "+id+"]: "}var id=props.draggableId;!id?false?undefined:invariant(false):void 0;!(typeof id==="string")?false?undefined:invariant(false):void 0;!isInteger(props.index)?false?undefined:invariant(false):void 0;if(props.mapped.type==="DRAGGING"){return}checkIsValidInnerRef(getRef());if(props.isEnabled){!findDragHandle(contextId,id)?false?undefined:invariant(false):void 0}}))}function useClonePropValidation(isClone){useDev((function(){var initialRef=React.useRef(isClone);useDevSetupWarning((function(){!(isClone===initialRef.current)?false?undefined:invariant(false):void 0}),[isClone])}))}function preventHtml5Dnd(event){event.preventDefault()}function Draggable(props){var ref=React.useRef(null);var setRef=useMemoOne.useCallback((function(el){ref.current=el}),[]);var getRef=useMemoOne.useCallback((function(){return ref.current}),[]);var _useRequiredContext=useRequiredContext(AppContext),contextId=_useRequiredContext.contextId,dragHandleUsageInstructionsId=_useRequiredContext.dragHandleUsageInstructionsId,registry=_useRequiredContext.registry;var _useRequiredContext2=useRequiredContext(DroppableContext),type=_useRequiredContext2.type,droppableId=_useRequiredContext2.droppableId;var descriptor=useMemoOne.useMemo((function(){return{id:props.draggableId,index:props.index,type:type,droppableId:droppableId}}),[props.draggableId,props.index,type,droppableId]);var children=props.children,draggableId=props.draggableId,isEnabled=props.isEnabled,shouldRespectForcePress=props.shouldRespectForcePress,canDragInteractiveElements=props.canDragInteractiveElements,isClone=props.isClone,mapped=props.mapped,dropAnimationFinishedAction=props.dropAnimationFinished;useValidation$1(props,contextId,getRef);useClonePropValidation(isClone);if(!isClone){var forPublisher=useMemoOne.useMemo((function(){return{descriptor:descriptor,registry:registry,getDraggableRef:getRef,canDragInteractiveElements:canDragInteractiveElements,shouldRespectForcePress:shouldRespectForcePress,isEnabled:isEnabled}}),[descriptor,registry,getRef,canDragInteractiveElements,shouldRespectForcePress,isEnabled]);useDraggablePublisher(forPublisher)}var dragHandleProps=useMemoOne.useMemo((function(){return isEnabled?{tabIndex:0,role:"button","aria-describedby":dragHandleUsageInstructionsId,"data-rbd-drag-handle-draggable-id":draggableId,"data-rbd-drag-handle-context-id":contextId,draggable:false,onDragStart:preventHtml5Dnd}:null}),[contextId,dragHandleUsageInstructionsId,draggableId,isEnabled]);var onMoveEnd=useMemoOne.useCallback((function(event){if(mapped.type!=="DRAGGING"){return}if(!mapped.dropping){return}if(event.propertyName!=="transform"){return}dropAnimationFinishedAction()}),[dropAnimationFinishedAction,mapped]);var provided=useMemoOne.useMemo((function(){var style=getStyle$1(mapped);var onTransitionEnd=mapped.type==="DRAGGING"&&mapped.dropping?onMoveEnd:null;var result={innerRef:setRef,draggableProps:{"data-rbd-draggable-context-id":contextId,"data-rbd-draggable-id":draggableId,style:style,onTransitionEnd:onTransitionEnd},dragHandleProps:dragHandleProps};return result}),[contextId,dragHandleProps,draggableId,mapped,onMoveEnd,setRef]);var rubric=useMemoOne.useMemo((function(){return{draggableId:descriptor.id,type:descriptor.type,source:{index:descriptor.index,droppableId:descriptor.droppableId}}}),[descriptor.droppableId,descriptor.id,descriptor.index,descriptor.type]);return children(provided,mapped.snapshot,rubric)}var isStrictEqual=function(a,b){return a===b};var whatIsDraggedOverFromResult=function(result){var combine=result.combine,destination=result.destination;if(destination){return destination.droppableId}if(combine){return combine.droppableId}return null};var getCombineWithFromResult=function getCombineWithFromResult(result){return result.combine?result.combine.draggableId:null};var getCombineWithFromImpact=function getCombineWithFromImpact(impact){return impact.at&&impact.at.type==="COMBINE"?impact.at.combine.draggableId:null};function getDraggableSelector(){var memoizedOffset=memoizeOne((function(x,y){return{x:x,y:y}}));var getMemoizedSnapshot=memoizeOne((function(mode,isClone,draggingOver,combineWith,dropping){return{isDragging:true,isClone:isClone,isDropAnimating:Boolean(dropping),dropAnimation:dropping,mode:mode,draggingOver:draggingOver,combineWith:combineWith,combineTargetFor:null}}));var getMemoizedProps=memoizeOne((function(offset,mode,dimension,isClone,draggingOver,combineWith,forceShouldAnimate){return{mapped:{type:"DRAGGING",dropping:null,draggingOver:draggingOver,combineWith:combineWith,mode:mode,offset:offset,dimension:dimension,forceShouldAnimate:forceShouldAnimate,snapshot:getMemoizedSnapshot(mode,isClone,draggingOver,combineWith,null)}}}));var selector=function selector(state,ownProps){if(state.isDragging){if(state.critical.draggable.id!==ownProps.draggableId){return null}var offset=state.current.client.offset;var dimension=state.dimensions.draggables[ownProps.draggableId];var draggingOver=whatIsDraggedOver(state.impact);var combineWith=getCombineWithFromImpact(state.impact);var forceShouldAnimate=state.forceShouldAnimate;return getMemoizedProps(memoizedOffset(offset.x,offset.y),state.movementMode,dimension,ownProps.isClone,draggingOver,combineWith,forceShouldAnimate)}if(state.phase==="DROP_ANIMATING"){var completed=state.completed;if(completed.result.draggableId!==ownProps.draggableId){return null}var isClone=ownProps.isClone;var _dimension=state.dimensions.draggables[ownProps.draggableId];var result=completed.result;var mode=result.mode;var _draggingOver=whatIsDraggedOverFromResult(result);var _combineWith=getCombineWithFromResult(result);var duration=state.dropDuration;var dropping={duration:duration,curve:curves.drop,moveTo:state.newHomeClientOffset,opacity:_combineWith?combine.opacity.drop:null,scale:_combineWith?combine.scale.drop:null};return{mapped:{type:"DRAGGING",offset:state.newHomeClientOffset,dimension:_dimension,dropping:dropping,draggingOver:_draggingOver,combineWith:_combineWith,mode:mode,forceShouldAnimate:null,snapshot:getMemoizedSnapshot(mode,isClone,_draggingOver,_combineWith,dropping)}}}return null};return selector}function getSecondarySnapshot(combineTargetFor){return{isDragging:false,isDropAnimating:false,isClone:false,dropAnimation:null,mode:null,draggingOver:null,combineTargetFor:combineTargetFor,combineWith:null}}var atRest={mapped:{type:"SECONDARY",offset:origin,combineTargetFor:null,shouldAnimateDisplacement:true,snapshot:getSecondarySnapshot(null)}};function getSecondarySelector(){var memoizedOffset=memoizeOne((function(x,y){return{x:x,y:y}}));var getMemoizedSnapshot=memoizeOne(getSecondarySnapshot);var getMemoizedProps=memoizeOne((function(offset,combineTargetFor,shouldAnimateDisplacement){if(combineTargetFor===void 0){combineTargetFor=null}return{mapped:{type:"SECONDARY",offset:offset,combineTargetFor:combineTargetFor,shouldAnimateDisplacement:shouldAnimateDisplacement,snapshot:getMemoizedSnapshot(combineTargetFor)}}}));var getFallback=function getFallback(combineTargetFor){return combineTargetFor?getMemoizedProps(origin,combineTargetFor,true):null};var getProps=function getProps(ownId,draggingId,impact,afterCritical){var visualDisplacement=impact.displaced.visible[ownId];var isAfterCriticalInVirtualList=Boolean(afterCritical.inVirtualList&&afterCritical.effected[ownId]);var combine=tryGetCombine(impact);var combineTargetFor=combine&&combine.draggableId===ownId?draggingId:null;if(!visualDisplacement){if(!isAfterCriticalInVirtualList){return getFallback(combineTargetFor)}if(impact.displaced.invisible[ownId]){return null}var change=negate(afterCritical.displacedBy.point);var _offset=memoizedOffset(change.x,change.y);return getMemoizedProps(_offset,combineTargetFor,true)}if(isAfterCriticalInVirtualList){return getFallback(combineTargetFor)}var displaceBy=impact.displacedBy.point;var offset=memoizedOffset(displaceBy.x,displaceBy.y);return getMemoizedProps(offset,combineTargetFor,visualDisplacement.shouldAnimate)};var selector=function selector(state,ownProps){if(state.isDragging){if(state.critical.draggable.id===ownProps.draggableId){return null}return getProps(ownProps.draggableId,state.critical.draggable.id,state.impact,state.afterCritical)}if(state.phase==="DROP_ANIMATING"){var completed=state.completed;if(completed.result.draggableId===ownProps.draggableId){return null}return getProps(ownProps.draggableId,completed.result.draggableId,completed.impact,completed.afterCritical)}return null};return selector}var makeMapStateToProps=function makeMapStateToProps(){var draggingSelector=getDraggableSelector();var secondarySelector=getSecondarySelector();var selector=function selector(state,ownProps){return draggingSelector(state,ownProps)||secondarySelector(state,ownProps)||atRest};return selector};var mapDispatchToProps={dropAnimationFinished:dropAnimationFinished};var ConnectedDraggable=reactRedux.connect(makeMapStateToProps,mapDispatchToProps,null,{context:StoreContext,pure:true,areStatePropsEqual:isStrictEqual})(Draggable);function PrivateDraggable(props){var droppableContext=useRequiredContext(DroppableContext);var isUsingCloneFor=droppableContext.isUsingCloneFor;if(isUsingCloneFor===props.draggableId&&!props.isClone){return null}return React__default.createElement(ConnectedDraggable,props)}function PublicDraggable(props){var isEnabled=typeof props.isDragDisabled==="boolean"?!props.isDragDisabled:true;var canDragInteractiveElements=Boolean(props.disableInteractiveElementBlocking);var shouldRespectForcePress=Boolean(props.shouldRespectForcePress);return React__default.createElement(PrivateDraggable,_extends({},props,{isClone:false,isEnabled:isEnabled,canDragInteractiveElements:canDragInteractiveElements,shouldRespectForcePress:shouldRespectForcePress}))}function Droppable(props){var appContext=React.useContext(AppContext);!appContext?false?undefined:invariant(false):void 0;var contextId=appContext.contextId,isMovementAllowed=appContext.isMovementAllowed;var droppableRef=React.useRef(null);var placeholderRef=React.useRef(null);var children=props.children,droppableId=props.droppableId,type=props.type,mode=props.mode,direction=props.direction,ignoreContainerClipping=props.ignoreContainerClipping,isDropDisabled=props.isDropDisabled,isCombineEnabled=props.isCombineEnabled,snapshot=props.snapshot,useClone=props.useClone,updateViewportMaxScroll=props.updateViewportMaxScroll,getContainerForClone=props.getContainerForClone;var getDroppableRef=useMemoOne.useCallback((function(){return droppableRef.current}),[]);var setDroppableRef=useMemoOne.useCallback((function(value){droppableRef.current=value}),[]);var getPlaceholderRef=useMemoOne.useCallback((function(){return placeholderRef.current}),[]);var setPlaceholderRef=useMemoOne.useCallback((function(value){placeholderRef.current=value}),[]);useValidation({props:props,getDroppableRef:getDroppableRef,getPlaceholderRef:getPlaceholderRef});var onPlaceholderTransitionEnd=useMemoOne.useCallback((function(){if(isMovementAllowed()){updateViewportMaxScroll({maxScroll:getMaxWindowScroll()})}}),[isMovementAllowed,updateViewportMaxScroll]);useDroppablePublisher({droppableId:droppableId,type:type,mode:mode,direction:direction,isDropDisabled:isDropDisabled,isCombineEnabled:isCombineEnabled,ignoreContainerClipping:ignoreContainerClipping,getDroppableRef:getDroppableRef});var placeholder=React__default.createElement(AnimateInOut,{on:props.placeholder,shouldAnimate:props.shouldAnimatePlaceholder},(function(_ref){var onClose=_ref.onClose,data=_ref.data,animate=_ref.animate;return React__default.createElement(Placeholder$1,{placeholder:data,onClose:onClose,innerRef:setPlaceholderRef,animate:animate,contextId:contextId,onTransitionEnd:onPlaceholderTransitionEnd})}));var provided=useMemoOne.useMemo((function(){return{innerRef:setDroppableRef,placeholder:placeholder,droppableProps:{"data-rbd-droppable-id":droppableId,"data-rbd-droppable-context-id":contextId}}}),[contextId,droppableId,placeholder,setDroppableRef]);var isUsingCloneFor=useClone?useClone.dragging.draggableId:null;var droppableContext=useMemoOne.useMemo((function(){return{droppableId:droppableId,type:type,isUsingCloneFor:isUsingCloneFor}}),[droppableId,isUsingCloneFor,type]);function getClone(){if(!useClone){return null}var dragging=useClone.dragging,render=useClone.render;var node=React__default.createElement(PrivateDraggable,{draggableId:dragging.draggableId,index:dragging.source.index,isClone:true,isEnabled:true,shouldRespectForcePress:false,canDragInteractiveElements:true},(function(draggableProvided,draggableSnapshot){return render(draggableProvided,draggableSnapshot,dragging)}));return ReactDOM.createPortal(node,getContainerForClone())}return React__default.createElement(DroppableContext.Provider,{value:droppableContext},children(provided,snapshot),getClone())}var isMatchingType=function isMatchingType(type,critical){return type===critical.droppable.type};var getDraggable=function getDraggable(critical,dimensions){return dimensions.draggables[critical.draggable.id]};var makeMapStateToProps$1=function makeMapStateToProps(){var idleWithAnimation={placeholder:null,shouldAnimatePlaceholder:true,snapshot:{isDraggingOver:false,draggingOverWith:null,draggingFromThisWith:null,isUsingPlaceholder:false},useClone:null};var idleWithoutAnimation=_extends({},idleWithAnimation,{shouldAnimatePlaceholder:false});var getDraggableRubric=memoizeOne((function(descriptor){return{draggableId:descriptor.id,type:descriptor.type,source:{index:descriptor.index,droppableId:descriptor.droppableId}}}));var getMapProps=memoizeOne((function(id,isEnabled,isDraggingOverForConsumer,isDraggingOverForImpact,dragging,renderClone){var draggableId=dragging.descriptor.id;var isHome=dragging.descriptor.droppableId===id;if(isHome){var useClone=renderClone?{render:renderClone,dragging:getDraggableRubric(dragging.descriptor)}:null;var _snapshot={isDraggingOver:isDraggingOverForConsumer,draggingOverWith:isDraggingOverForConsumer?draggableId:null,draggingFromThisWith:draggableId,isUsingPlaceholder:true};return{placeholder:dragging.placeholder,shouldAnimatePlaceholder:false,snapshot:_snapshot,useClone:useClone}}if(!isEnabled){return idleWithoutAnimation}if(!isDraggingOverForImpact){return idleWithAnimation}var snapshot={isDraggingOver:isDraggingOverForConsumer,draggingOverWith:draggableId,draggingFromThisWith:null,isUsingPlaceholder:true};return{placeholder:dragging.placeholder,shouldAnimatePlaceholder:true,snapshot:snapshot,useClone:null}}));var selector=function selector(state,ownProps){var id=ownProps.droppableId;var type=ownProps.type;var isEnabled=!ownProps.isDropDisabled;var renderClone=ownProps.renderClone;if(state.isDragging){var critical=state.critical;if(!isMatchingType(type,critical)){return idleWithoutAnimation}var dragging=getDraggable(critical,state.dimensions);var isDraggingOver=whatIsDraggedOver(state.impact)===id;return getMapProps(id,isEnabled,isDraggingOver,isDraggingOver,dragging,renderClone)}if(state.phase==="DROP_ANIMATING"){var completed=state.completed;if(!isMatchingType(type,completed.critical)){return idleWithoutAnimation}var _dragging=getDraggable(completed.critical,state.dimensions);return getMapProps(id,isEnabled,whatIsDraggedOverFromResult(completed.result)===id,whatIsDraggedOver(completed.impact)===id,_dragging,renderClone)}if(state.phase==="IDLE"&&state.completed&&!state.shouldFlush){var _completed=state.completed;if(!isMatchingType(type,_completed.critical)){return idleWithoutAnimation}var wasOver=whatIsDraggedOver(_completed.impact)===id;var wasCombining=Boolean(_completed.impact.at&&_completed.impact.at.type==="COMBINE");var isHome=_completed.critical.droppable.id===id;if(wasOver){return wasCombining?idleWithAnimation:idleWithoutAnimation}if(isHome){return idleWithAnimation}return idleWithoutAnimation}return idleWithoutAnimation};return selector};var mapDispatchToProps$1={updateViewportMaxScroll:updateViewportMaxScroll};function getBody(){!document.body?false?undefined:invariant(false):void 0;return document.body}var defaultProps={mode:"standard",type:"DEFAULT",direction:"vertical",isDropDisabled:false,isCombineEnabled:false,ignoreContainerClipping:false,renderClone:null,getContainerForClone:getBody};var ConnectedDroppable=reactRedux.connect(makeMapStateToProps$1,mapDispatchToProps$1,null,{context:StoreContext,pure:true,areStatePropsEqual:isStrictEqual})(Droppable);ConnectedDroppable.defaultProps=defaultProps;exports.DragDropContext=DragDropContext;exports.Draggable=PublicDraggable;exports.Droppable=ConnectedDroppable;exports.resetServerContext=resetServerContext},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return ADD_TO_FAVORITES}));__webpack_require__.d(__webpack_exports__,"j",(function(){return REMOVE_FROM_FAVORITES}));__webpack_require__.d(__webpack_exports__,"l",(function(){return UNTITLED_TIMELINE}));__webpack_require__.d(__webpack_exports__,"k",(function(){return UNTITLED_TEMPLATE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"i",(function(){return NOTES}));__webpack_require__.d(__webpack_exports__,"h",(function(){return NEW_TIMELINE}));__webpack_require__.d(__webpack_exports__,"g",(function(){return NEW_TEMPLATE_TIMELINE}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ADD_TIMELINE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ATTACH_TO_CASE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return ATTACH_TO_NEW_CASE}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ATTACH_TO_EXISTING_CASE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const TIMELINE_DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.timelineDescription",{defaultMessage:"Timeline Description"});const ADD_TO_FAVORITES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.addToFavoriteButtonLabel",{defaultMessage:"Add to favorites"});const REMOVE_FROM_FAVORITES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.removeFromFavoritesButtonLabel",{defaultMessage:"Remove from favorites"});const UNTITLED_TIMELINE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.untitledTimelinePlaceholder",{defaultMessage:"Untitled timeline"});const UNTITLED_TEMPLATE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.untitledTemplatePlaceholder",{defaultMessage:"Untitled template"});const DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.descriptionPlaceholder",{defaultMessage:"Add a description"});const NOTES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.notesButtonLabel",{defaultMessage:"Notes"});const NEW_TIMELINE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.newTimelineButtonLabel",{defaultMessage:"Create new timeline"});const NEW_TEMPLATE_TIMELINE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.newTemplateTimelineButtonLabel",{defaultMessage:"Create new timeline template"});const ADD_TIMELINE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.addTimelineButtonLabel",{defaultMessage:"Add new timeline or template"});const ATTACH_TIMELINE_TO_NEW_CASE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.newCaseButtonLabel",{defaultMessage:"Attach timeline to new case"});const ATTACH_TO_CASE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.attachToCaseButtonLabel",{defaultMessage:"Attach to case"});const ATTACH_TO_NEW_CASE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.attachToNewCaseButtonLabel",{defaultMessage:"Attach to new case"});const ATTACH_TIMELINE_TO_EXISTING_CASE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.existingCaseButtonLabel",{defaultMessage:"Attach timeline to existing case..."});const ATTACH_TO_EXISTING_CASE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.attachToExistingCaseButtonLabel",{defaultMessage:"Attach to existing case..."});const ATTACH_TIMELINE_TO_CASE_TOOLTIP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.attachTimelineToCaseTooltip",{defaultMessage:"Please provide a title for your timeline in order to attach it to a case"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"Vb",(function(){return SESSION}));__webpack_require__.d(__webpack_exports__,"oc",(function(){return WAS_AUTHORIZED_TO_USE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return ACQUIRED_CREDENTIALS_TO}));__webpack_require__.d(__webpack_exports__,"eb",(function(){return ENDED_FROM}));__webpack_require__.d(__webpack_exports__,"Yb",(function(){return STARTED}));__webpack_require__.d(__webpack_exports__,"db",(function(){return DISPOSED_CREDENTIALS_TO}));__webpack_require__.d(__webpack_exports__,"m",(function(){return ATTEMPTED_LOGIN}));__webpack_require__.d(__webpack_exports__,"pc",(function(){return WITH_RESULT}));__webpack_require__.d(__webpack_exports__,"gb",(function(){return EXECUTED}));__webpack_require__.d(__webpack_exports__,"i",(function(){return AS}));__webpack_require__.d(__webpack_exports__,"T",(function(){return CONNECTED_USING}));__webpack_require__.d(__webpack_exports__,"kc",(function(){return USING}));__webpack_require__.d(__webpack_exports__,"Db",(function(){return OPENED_FILE}));__webpack_require__.d(__webpack_exports__,"y",(function(){return CHANGED_FILE_ATTRIBUTES_OF}));__webpack_require__.d(__webpack_exports__,"A",(function(){return CHANGED_FILE_PERMISSIONS_OF}));__webpack_require__.d(__webpack_exports__,"z",(function(){return CHANGED_FILE_OWNERSHIP_OF}));__webpack_require__.d(__webpack_exports__,"ob",(function(){return LOADED_KERNEL_MODULE}));__webpack_require__.d(__webpack_exports__,"gc",(function(){return UNLOADED_KERNEL_MODULE_OF}));__webpack_require__.d(__webpack_exports__,"V",(function(){return CREATED_DIRECTORY}));__webpack_require__.d(__webpack_exports__,"Bb",(function(){return MOUNTED}));__webpack_require__.d(__webpack_exports__,"Ob",(function(){return RENAMED}));__webpack_require__.d(__webpack_exports__,"S",(function(){return CHECKED_METADATA_OF}));__webpack_require__.d(__webpack_exports__,"Q",(function(){return CHECKED_FILE_SYSTEM_METADATA_OF}));__webpack_require__.d(__webpack_exports__,"dc",(function(){return SYMLINKED}));__webpack_require__.d(__webpack_exports__,"ic",(function(){return UNMOUNTED}));__webpack_require__.d(__webpack_exports__,"Z",(function(){return DELETED}));__webpack_require__.d(__webpack_exports__,"N",(function(){return CHANGED_TIME_STAMP_OF}));__webpack_require__.d(__webpack_exports__,"mb",(function(){return LISTEN_FOR_CONNECTIONS}));__webpack_require__.d(__webpack_exports__,"t",(function(){return BOUND_SOCKET_FROM}));__webpack_require__.d(__webpack_exports__,"Hb",(function(){return RECEIVED_FROM}));__webpack_require__.d(__webpack_exports__,"Ub",(function(){return SENT_TO}));__webpack_require__.d(__webpack_exports__,"lb",(function(){return KILLED_PROCESS_ID_OF}));__webpack_require__.d(__webpack_exports__,"D",(function(){return CHANGED_IDENTITY_USING}));__webpack_require__.d(__webpack_exports__,"M",(function(){return CHANGED_SYSTEM_TIME_WITH}));__webpack_require__.d(__webpack_exports__,"ub",(function(){return MADE_DEVICE_WITH}));__webpack_require__.d(__webpack_exports__,"L",(function(){return CHANGED_SYSTEM_NAME}));__webpack_require__.d(__webpack_exports__,"h",(function(){return ALLOCATED_MEMORY_FOR}));__webpack_require__.d(__webpack_exports__,"Rb",(function(){return SCHEDULED_POLICY_OF}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ADDED_USER_ACCOUNT}));__webpack_require__.d(__webpack_exports__,"u",(function(){return CAUSED_MAC_POLICY_ERROR}));__webpack_require__.d(__webpack_exports__,"nb",(function(){return LOADED_FIREWALL_RULE}));__webpack_require__.d(__webpack_exports__,"H",(function(){return CHANGED_PROMISCUOUS_MODE}));__webpack_require__.d(__webpack_exports__,"rb",(function(){return LOCKED_ACCOUNT}));__webpack_require__.d(__webpack_exports__,"hc",(function(){return UNLOCKED_ACCOUNT}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ADDED_GROUP_ACCOUNT_USING}));__webpack_require__.d(__webpack_exports__,"U",(function(){return CRASHED_PROGRAM}));__webpack_require__.d(__webpack_exports__,"hb",(function(){return EXECUTION_OF_FORBIDDEN_PROGRAM}));__webpack_require__.d(__webpack_exports__,"jc",(function(){return USED_SUSPICIOUS_PROGRAM}));__webpack_require__.d(__webpack_exports__,"ib",(function(){return FAILED_LOGIN_TOO_MANY_TIMES}));__webpack_require__.d(__webpack_exports__,"o",(function(){return ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE}));__webpack_require__.d(__webpack_exports__,"Eb",(function(){return OPENED_TOO_MANY_SESSIONS}));__webpack_require__.d(__webpack_exports__,"n",(function(){return ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR}));__webpack_require__.d(__webpack_exports__,"ec",(function(){return TESTED_FILE_SYSTEM_INTEGRITY}));__webpack_require__.d(__webpack_exports__,"nc",(function(){return VIOLATED_SELINUX_POLICY}));__webpack_require__.d(__webpack_exports__,"lc",(function(){return VIOLATED_APP_ARMOR_POLICY_FROM}));__webpack_require__.d(__webpack_exports__,"B",(function(){return CHANGED_GROUP}));__webpack_require__.d(__webpack_exports__,"P",(function(){return CHANGED_USER_ID}));__webpack_require__.d(__webpack_exports__,"v",(function(){return CHANGED_AUDIT_CONFIGURATION}));__webpack_require__.d(__webpack_exports__,"Jb",(function(){return REFRESHED_CREDENTIALS_FOR}));__webpack_require__.d(__webpack_exports__,"Cb",(function(){return NEGOTIATED_CRYPTO_KEY}));__webpack_require__.d(__webpack_exports__,"X",(function(){return CRYPTO_OFFICER_LOGGED_IN}));__webpack_require__.d(__webpack_exports__,"Y",(function(){return CRYPTO_OFFICER_LOGGED_OUT}));__webpack_require__.d(__webpack_exports__,"ac",(function(){return STARTED_CRYPTO_SESSION}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ACCESS_RESULT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ABORTED_AUDIT_STARTUP}));__webpack_require__.d(__webpack_exports__,"Lb",(function(){return REMOTE_AUDIT_CONNECTED}));__webpack_require__.d(__webpack_exports__,"Mb",(function(){return REMOTE_AUDIT_DISCONNECTED}));__webpack_require__.d(__webpack_exports__,"Wb",(function(){return SHUTDOWN_AUDIT}));__webpack_require__.d(__webpack_exports__,"p",(function(){return AUDIT_ERROR}));__webpack_require__.d(__webpack_exports__,"Ib",(function(){return RECONFIGURED_AUDIT}));__webpack_require__.d(__webpack_exports__,"Pb",(function(){return RESUMED_AUDIT_LOGGING}));__webpack_require__.d(__webpack_exports__,"Qb",(function(){return ROTATED_AUDIT_LOGS}));__webpack_require__.d(__webpack_exports__,"Zb",(function(){return STARTED_AUDIT}));__webpack_require__.d(__webpack_exports__,"ab",(function(){return DELETED_GROUP_ACCOUNT_USING}));__webpack_require__.d(__webpack_exports__,"bb",(function(){return DELETED_USER_ACCOUNT_USING}));__webpack_require__.d(__webpack_exports__,"w",(function(){return CHANGED_AUDIT_FEATURE}));__webpack_require__.d(__webpack_exports__,"Kb",(function(){return RELABELED_FILESYSTEM}));__webpack_require__.d(__webpack_exports__,"q",(function(){return AUTHENTICATED_TO_GROUP}));__webpack_require__.d(__webpack_exports__,"C",(function(){return CHANGED_GROUP_PASSWORD}));__webpack_require__.d(__webpack_exports__,"xb",(function(){return MODIFIED_GROUP_ACCOUNT}));__webpack_require__.d(__webpack_exports__,"jb",(function(){return INITIALIZED_AUDIT_SUBSYSTEM}));__webpack_require__.d(__webpack_exports__,"yb",(function(){return MODIFIED_LEVEL_OF}));__webpack_require__.d(__webpack_exports__,"Fb",(function(){return OVERRODE_LABEL_OF}));__webpack_require__.d(__webpack_exports__,"E",(function(){return CHANGED_LOGIN_ID_TO}));__webpack_require__.d(__webpack_exports__,"tb",(function(){return MAC_PERMISSION}));__webpack_require__.d(__webpack_exports__,"J",(function(){return CHANGED_SELINUX_BOOLEAN}));__webpack_require__.d(__webpack_exports__,"qb",(function(){return LOADED_SELINUX_POLICY}));__webpack_require__.d(__webpack_exports__,"K",(function(){return CHANGED_SELINUX_ENFORCEMENT}));__webpack_require__.d(__webpack_exports__,"j",(function(){return ASSIGNED_USER_ROLE_TO}));__webpack_require__.d(__webpack_exports__,"zb",(function(){return MODIFIED_ROLE}));__webpack_require__.d(__webpack_exports__,"Nb",(function(){return REMOVED_USER_ROLE_FROM}));__webpack_require__.d(__webpack_exports__,"mc",(function(){return VIOLATED_SECCOMP_POLICY_WITH}));__webpack_require__.d(__webpack_exports__,"bc",(function(){return STARTED_SERVICE}));__webpack_require__.d(__webpack_exports__,"cc",(function(){return STOPPED_SERVICE}));__webpack_require__.d(__webpack_exports__,"s",(function(){return BOOTED_SYSTEM}));__webpack_require__.d(__webpack_exports__,"O",(function(){return CHANGED_TO_RUN_LEVEL_WITH}));__webpack_require__.d(__webpack_exports__,"Xb",(function(){return SHUTDOWN_SYSTEM}));__webpack_require__.d(__webpack_exports__,"Tb",(function(){return SENT_TEST}));__webpack_require__.d(__webpack_exports__,"fc",(function(){return UNKNOWN}));__webpack_require__.d(__webpack_exports__,"Sb",(function(){return SENT_MESSAGE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ACCESS_PERMISSION}));__webpack_require__.d(__webpack_exports__,"r",(function(){return AUTHENTICATED_USING}));__webpack_require__.d(__webpack_exports__,"G",(function(){return CHANGED_PASSWORD_WITH}));__webpack_require__.d(__webpack_exports__,"Gb",(function(){return RAN_COMMAND}));__webpack_require__.d(__webpack_exports__,"fb",(function(){return ERROR_FROM}));__webpack_require__.d(__webpack_exports__,"sb",(function(){return LOGGED_OUT}));__webpack_require__.d(__webpack_exports__,"F",(function(){return CHANGED_MAC_CONFIGURATION}));__webpack_require__.d(__webpack_exports__,"pb",(function(){return LOADED_MAC_POLICY}));__webpack_require__.d(__webpack_exports__,"Ab",(function(){return MODIFIED_USER_ACCOUNT}));__webpack_require__.d(__webpack_exports__,"I",(function(){return CHANGED_ROLE_USING}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ACCESS_ERROR}));__webpack_require__.d(__webpack_exports__,"x",(function(){return CHANGED_CONFIGURATION_WITH}));__webpack_require__.d(__webpack_exports__,"kb",(function(){return ISSUED_VM_CONTROL}));__webpack_require__.d(__webpack_exports__,"W",(function(){return CREATED_VM_IMAGE}));__webpack_require__.d(__webpack_exports__,"cb",(function(){return DELETED_VM_IMAGE}));__webpack_require__.d(__webpack_exports__,"R",(function(){return CHECKED_INTEGRITY_OF}));__webpack_require__.d(__webpack_exports__,"k",(function(){return ASSIGNED_VM_ID}));__webpack_require__.d(__webpack_exports__,"vb",(function(){return MIGRATED_VM_FROM}));__webpack_require__.d(__webpack_exports__,"wb",(function(){return MIGRATED_VM_TO}));__webpack_require__.d(__webpack_exports__,"l",(function(){return ASSIGNED_VM_RESOURCE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const SESSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.sessionDescription",{defaultMessage:"Session"});const WAS_AUTHORIZED_TO_USE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.wasAuthorizedToUseDescription",{defaultMessage:"was authorized to use"});const ACQUIRED_CREDENTIALS_TO=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.acquiredCredentialsDescription",{defaultMessage:"acquired credentials to"});const ENDED_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.endedFromDescription",{defaultMessage:"ended from"});const STARTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.startedAtDescription",{defaultMessage:"started"});const DISPOSED_CREDENTIALS_TO=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.disposedCredentialsDescription",{defaultMessage:"disposed credentials to"});const ATTEMPTED_LOGIN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.attemptedLoginDescription",{defaultMessage:"attempted a login via"});const WITH_RESULT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.withResultDescription",{defaultMessage:"with result"});const EXECUTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.executedDescription",{defaultMessage:"executed"});const AS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.asDescription",{defaultMessage:"as"});const CONNECTED_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.connectedUsingDescription",{defaultMessage:"connected using"});const USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.usingDescription",{defaultMessage:"using"});const OPENED_FILE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.OpenedFileDescription",{defaultMessage:"opened file"});const CHANGED_FILE_ATTRIBUTES_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.ChangedFileAttributesOfDescription",{defaultMessage:"changed file attributes of"});const CHANGED_FILE_PERMISSIONS_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedFilePermissionOfDescription",{defaultMessage:"changed file permissions of"});const CHANGED_FILE_OWNERSHIP_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changeidleOwernshipOfDescription",{defaultMessage:"changed file ownership of"});const LOADED_KERNEL_MODULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.loaedKernelModuleOfDescription",{defaultMessage:"loaded kernel module of"});const UNLOADED_KERNEL_MODULE_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.unloadedKernelModuleOfDescription",{defaultMessage:"unloaded kernel module of"});const CREATED_DIRECTORY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.createdDirectoryDescription",{defaultMessage:"created directory"});const MOUNTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.mountedDescription",{defaultMessage:"mounted"});const RENAMED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.renamedDescription",{defaultMessage:"renamed"});const CHECKED_METADATA_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.chedckedMetaDataOfDescription",{defaultMessage:"checked metadata of"});const CHECKED_FILE_SYSTEM_METADATA_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.checkedFileSystemMetadataOfDescription",{defaultMessage:"checked filesystem metadata of"});const SYMLINKED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.symLinkedDescription",{defaultMessage:"symbolically linked"});const UNMOUNTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.unmountedDescription",{defaultMessage:"unmounted"});const DELETED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.deletedDescription",{defaultMessage:"deleted"});const CHANGED_TIME_STAMP_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedTimeStampOfDescription",{defaultMessage:"changed time stamp of"});const LISTEN_FOR_CONNECTIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.ListeningForConnectionsUsingDescription",{defaultMessage:"listening for connections using"});const BOUND_SOCKET_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.boundSocketFromDescription",{defaultMessage:"bound socket from"});const RECEIVED_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.receivedFromDescription",{defaultMessage:"received from"});const SENT_TO=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.sentToDescription",{defaultMessage:"sent to"});const KILLED_PROCESS_ID_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.killedProcessIdDescription",{defaultMessage:"killed process id of"});const CHANGED_IDENTITY_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedIdentityUsingDescription",{defaultMessage:"changed identity using"});const CHANGED_SYSTEM_TIME_WITH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedSystemTimeWithDescription",{defaultMessage:"changed system time with"});const MADE_DEVICE_WITH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.madeDeviceWithDescription",{defaultMessage:"made device with"});const CHANGED_SYSTEM_NAME=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedSystemNameDescription",{defaultMessage:"changed system name"});const ALLOCATED_MEMORY_FOR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.allocatedMemoryForDescription",{defaultMessage:"allocated memory for"});const SCHEDULED_POLICY_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.scheduledPolicyOFDescription",{defaultMessage:"scheduled policy of"});const ADDED_USER_ACCOUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.addedUserAccountDescription",{defaultMessage:"added user account"});const CAUSED_MAC_POLICY_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.causedMacPolicyErrorDescription",{defaultMessage:"caused mac policy error"});const LOADED_FIREWALL_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.loadedFirewallRuleDescription",{defaultMessage:"loaded firewall rule"});const CHANGED_PROMISCUOUS_MODE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.promiscuousModeDescription",{defaultMessage:"changed promiscuous mode on the device using"});const LOCKED_ACCOUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.lockedAccountDescription",{defaultMessage:"locked account"});const UNLOCKED_ACCOUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.unlockedAccountDescription",{defaultMessage:"unlocked account"});const ADDED_GROUP_ACCOUNT_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.adddedGroupAccountUsingDescription",{defaultMessage:"added group account using"});const CRASHED_PROGRAM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.crashedProgramDescription",{defaultMessage:"crashed program"});const EXECUTION_OF_FORBIDDEN_PROGRAM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.executionOfForbiddenProgramDescription",{defaultMessage:"execution of forbidden program"});const USED_SUSPICIOUS_PROGRAM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.suspiciousProgramDescription",{defaultMessage:"used suspicious program"});const FAILED_LOGIN_TOO_MANY_TIMES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.failedLoginTooManyTimesDescription",{defaultMessage:"failed login due to logging in too many times"});const ATTEMPTED_LOGIN_FROM_UNUSUAL_PLACE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.attemptedLoginFromUnusalPlaceDescription",{defaultMessage:"attempted login from unusual place"});const OPENED_TOO_MANY_SESSIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.openedTooManySessionsDescription",{defaultMessage:"opened too many sessions"});const ATTEMPTED_LOGIN_FROM_UNUSUAL_HOUR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.attemptedLoginFromUnusualHourDescription",{defaultMessage:"attempted login from unusual hour"});const TESTED_FILE_SYSTEM_INTEGRITY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.testedFileSystemIntegrityDescription",{defaultMessage:"tested file system integrity"});const VIOLATED_SELINUX_POLICY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.violatedSeLinuxPolicyDescription",{defaultMessage:"violated selinux policy"});const VIOLATED_APP_ARMOR_POLICY_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.violatedAppArmorPolicyFromDescription",{defaultMessage:"violated app armor policy from"});const CHANGED_GROUP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedGroupDescription",{defaultMessage:"changed group"});const CHANGED_USER_ID=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedUserIdDescription",{defaultMessage:"changed user id"});const CHANGED_AUDIT_CONFIGURATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedAuditConfigurationDescription",{defaultMessage:"changed audit configuration"});const REFRESHED_CREDENTIALS_FOR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.refreshedCredentialsForDescription",{defaultMessage:"refreshed credentials for"});const NEGOTIATED_CRYPTO_KEY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.negotiatedCryptoKeyDescription",{defaultMessage:"negotiated crypto key"});const CRYPTO_OFFICER_LOGGED_IN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.cryptoOfficerLoggedInDescription",{defaultMessage:"crypto officer logged in"});const CRYPTO_OFFICER_LOGGED_OUT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.cryptoOfficerLoggedOutDescription",{defaultMessage:"crypto officer logged out"});const STARTED_CRYPTO_SESSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.startedCryptoSessionDescription",{defaultMessage:"started crypto session"});const ACCESS_RESULT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.accessResultDescription",{defaultMessage:"access result"});const ABORTED_AUDIT_STARTUP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.abortedAuditStartupDescription",{defaultMessage:"aborted audit startup"});const REMOTE_AUDIT_CONNECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.remoteAuditConnectedDescription",{defaultMessage:"remote audit connected"});const REMOTE_AUDIT_DISCONNECTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.remoteAuditDisconnectedDescription",{defaultMessage:"remote audit disconnected"});const SHUTDOWN_AUDIT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.shutDownAuditDescription",{defaultMessage:"shutdown audit"});const AUDIT_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.auditErrorDescription",{defaultMessage:"audit error"});const RECONFIGURED_AUDIT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.reconfiguredAuditDescription",{defaultMessage:"reconfigured audit"});const RESUMED_AUDIT_LOGGING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.resumedAuditLoggingDescription",{defaultMessage:"resumed audit logging"});const ROTATED_AUDIT_LOGS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.rotatedAuditLogsDescription",{defaultMessage:"rotated-audit-logs"});const STARTED_AUDIT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.startedAuditDescription",{defaultMessage:"started audit"});const DELETED_GROUP_ACCOUNT_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.deletedGroupAccountUsingDescription",{defaultMessage:"deleted group account using"});const DELETED_USER_ACCOUNT_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.deletedUserAccountUsingDescription",{defaultMessage:"deleted user account using"});const CHANGED_AUDIT_FEATURE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedAuditFeatureDescription",{defaultMessage:"changed audit feature"});const RELABELED_FILESYSTEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.relabeledFileSystemDescription",{defaultMessage:"relabeled filesystem"});const AUTHENTICATED_TO_GROUP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.authenticatedToGroupDescription",{defaultMessage:"authenticated to group"});const CHANGED_GROUP_PASSWORD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedGroupPasswordDescription",{defaultMessage:"changed group password"});const MODIFIED_GROUP_ACCOUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.modifiedGroupAccountDescription",{defaultMessage:"modified group account"});const INITIALIZED_AUDIT_SUBSYSTEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.initializedAuditSubsystemDescription",{defaultMessage:"initialized audit subsystem"});const MODIFIED_LEVEL_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.modifiedLevelOfDescription",{defaultMessage:"modified level of"});const OVERRODE_LABEL_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.overrodeLabelOfDescription",{defaultMessage:"overrode label of"});const CHANGED_LOGIN_ID_TO=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedLoginIdToDescription",{defaultMessage:"changed login id to"});const MAC_PERMISSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.macPermissionDescription",{defaultMessage:"mac permission"});const CHANGED_SELINUX_BOOLEAN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedSeLinuxBooleanDescription",{defaultMessage:"changed selinux boolean"});const LOADED_SELINUX_POLICY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.loadedSeLinuxPolicyDescription",{defaultMessage:"loaded selinux policy"});const CHANGED_SELINUX_ENFORCEMENT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedSelinuxEnforcementDescription",{defaultMessage:"changed selinux enforcement"});const ASSIGNED_USER_ROLE_TO=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.assignedUserRoleToDescription",{defaultMessage:"assigned user role to"});const MODIFIED_ROLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.modifiedRoleDescription",{defaultMessage:"modified role"});const REMOVED_USER_ROLE_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.removedUserRoleFromDescription",{defaultMessage:"removed user role from"});const VIOLATED_SECCOMP_POLICY_WITH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.violatedSeccompPolicyWithDescription",{defaultMessage:"violated seccomp policy with"});const STARTED_SERVICE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.startedServiceDescription",{defaultMessage:"started service"});const STOPPED_SERVICE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.stoppedServiceDescription",{defaultMessage:"stopped service"});const BOOTED_SYSTEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.bootedSystemDescription",{defaultMessage:"booted system"});const CHANGED_TO_RUN_LEVEL_WITH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedToRunLevelWithDescription",{defaultMessage:"changed to run level with"});const SHUTDOWN_SYSTEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.shutdownSystemDescription",{defaultMessage:"shutdown system"});const SENT_TEST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.sentTestDescription",{defaultMessage:"sent test"});const UNKNOWN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.unknownDescription",{defaultMessage:"unknown"});const SENT_MESSAGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.sentMessageDescription",{defaultMessage:"sent message"});const ACCESS_PERMISSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.accessPermissionDescription",{defaultMessage:"access permission"});const AUTHENTICATED_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.authenticatedUsingDescription",{defaultMessage:"authenticated using"});const CHANGED_PASSWORD_WITH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedPasswordWithDescription",{defaultMessage:"changed password with"});const RAN_COMMAND=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.ranCommandDescription",{defaultMessage:"ran command"});const ERROR_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.errorFromDescription",{defaultMessage:"error from"});const LOGGED_OUT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.loggedOutDescription",{defaultMessage:"logged out"});const CHANGED_MAC_CONFIGURATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedMacConfigurationDescription",{defaultMessage:"changed mac configuration"});const LOADED_MAC_POLICY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.loadedMacPolicyDescription",{defaultMessage:"loaded mac policy"});const MODIFIED_USER_ACCOUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.modifiedUserAccountDescription",{defaultMessage:"modified user account"});const CHANGED_ROLE_USING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedRoleUsingDescription",{defaultMessage:"changed role using"});const ACCESS_ERROR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.accessErrorDescription",{defaultMessage:"access error"});const CHANGED_CONFIGURATION_WITH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.changedConfigurationWIthDescription",{defaultMessage:"changed configuration with"});const ISSUED_VM_CONTROL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.issuedVmControlDescription",{defaultMessage:"issued vm control"});const CREATED_VM_IMAGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.createdVmImageDescription",{defaultMessage:"created vm image"});const DELETED_VM_IMAGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.deletedVmImageDescription",{defaultMessage:"deleted vm image"});const CHECKED_INTEGRITY_OF=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.checkedIntegrityOfDescription",{defaultMessage:"checked integrity of"});const ASSIGNED_VM_ID=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.assignedVmIdDescription",{defaultMessage:"assigned vm id"});const MIGRATED_VM_FROM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.migratedVmFromDescription",{defaultMessage:"migrated vm from"});const MIGRATED_VM_TO=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.migratedVmToDescription",{defaultMessage:"migrated vm to"});const ASSIGNED_VM_RESOURCE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.assignedVMResourceDescription",{defaultMessage:"assigned vm resource"})},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ProcessDraggable}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ProcessDraggableWithNonExistentProcess}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _common_components_draggables__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(115);var _helpers__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(125);var _translations__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(297);const ProcessDraggable=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({contextId:contextId,endgamePid:endgamePid,endgameProcessName:endgameProcessName,eventId:eventId,processExecutable:processExecutable,processName:processName,processPid:processPid})=>{if(Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(processName)&&Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(processExecutable)&&Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(endgameProcessName)&&Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(processPid)&&Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(endgamePid)){return null}return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{alignItems:"center",gutterSize:"none"},!Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(processName)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_2__["c"],{contextId:contextId,eventId:eventId,field:"process.name",value:processName,iconType:"console"})):!Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(processExecutable)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_2__["c"],{contextId:contextId,eventId:eventId,field:"process.executable",value:processExecutable,iconType:"console"})):!Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(endgameProcessName)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_2__["c"],{contextId:contextId,eventId:eventId,field:"endgame.process_name",value:endgameProcessName,iconType:"console"})):null,!Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(processPid)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_2__["c"],{contextId:contextId,eventId:eventId,field:"process.pid",queryValue:String(processPid),value:`(${String(processPid)})`})):!Object(_helpers__WEBPACK_IMPORTED_MODULE_3__["d"])(endgamePid)?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_2__["c"],{contextId:contextId,eventId:eventId,field:"endgame.pid",queryValue:String(endgamePid),value:`(${String(endgamePid)})`})):null)});ProcessDraggable.displayName="ProcessDraggable";const ProcessDraggableWithNonExistentProcess=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({contextId:contextId,endgamePid:endgamePid,endgameProcessName:endgameProcessName,eventId:eventId,processExecutable:processExecutable,processName:processName,processPid:processPid})=>{if(endgamePid==null&&endgameProcessName==null&&processExecutable==null&&processName==null&&processPid==null){return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,_translations__WEBPACK_IMPORTED_MODULE_4__["e"])}else{return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ProcessDraggable,{contextId:contextId,endgamePid:endgamePid,endgameProcessName:endgameProcessName,eventId:eventId,processExecutable:processExecutable,processName:processName,processPid:processPid})}});ProcessDraggableWithNonExistentProcess.displayName="ProcessDraggableWithNonExistentProcess"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return scoreIntervalToDateTime}));var moment__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(27);var moment__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);const scoreIntervalToDateTime=(score,interval)=>{if(interval==="second"||interval==="minute"||interval==="hour"){return{from:moment__WEBPACK_IMPORTED_MODULE_0___default()(score.time).subtract(1,"hour").toISOString(),to:moment__WEBPACK_IMPORTED_MODULE_0___default()(score.time).add(1,"hour").toISOString()}}else{return{from:moment__WEBPACK_IMPORTED_MODULE_0___default()(score.time).subtract(1,"day").toISOString(),to:moment__WEBPACK_IMPORTED_MODULE_0___default()(score.time).add(1,"day").toISOString()}}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"NetworkType",(function(){return NetworkType}));__webpack_require__.d(__webpack_exports__,"NetworkTableType",(function(){return NetworkTableType}));__webpack_require__.d(__webpack_exports__,"NetworkDetailsTableType",(function(){return NetworkDetailsTableType}));let NetworkType;(function(NetworkType){NetworkType["page"]="page";NetworkType["details"]="details"})(NetworkType||(NetworkType={}));let NetworkTableType;(function(NetworkTableType){NetworkTableType["alerts"]="alerts";NetworkTableType["dns"]="dns";NetworkTableType["http"]="http";NetworkTableType["topCountriesDestination"]="topCountriesDestination";NetworkTableType["topCountriesSource"]="topCountriesSource";NetworkTableType["topNFlowDestination"]="topNFlowDestination";NetworkTableType["topNFlowSource"]="topNFlowSource";NetworkTableType["tls"]="tls"})(NetworkTableType||(NetworkTableType={}));let NetworkDetailsTableType;(function(NetworkDetailsTableType){NetworkDetailsTableType["http"]="http";NetworkDetailsTableType["tls"]="tls";NetworkDetailsTableType["topCountriesDestination"]="topCountriesDestination";NetworkDetailsTableType["topCountriesSource"]="topCountriesSource";NetworkDetailsTableType["topNFlowDestination"]="topNFlowDestination";NetworkDetailsTableType["topNFlowSource"]="topNFlowSource";NetworkDetailsTableType["users"]="users"})(NetworkDetailsTableType||(NetworkDetailsTableType={}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return BREADCRUMB_TITLE}));__webpack_require__.d(__webpack_exports__,"m",(function(){return PAGE_TITLE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return LAST_ALERT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ALERT}));__webpack_require__.d(__webpack_exports__,"c",(function(){return BUTTON_MANAGE_RULES}));__webpack_require__.d(__webpack_exports__,"l",(function(){return NO_INDEX_TITLE}));__webpack_require__.d(__webpack_exports__,"j",(function(){return NEEDS_SIGNALS_AND_LISTS_INDEXES}));__webpack_require__.d(__webpack_exports__,"k",(function(){return NEEDS_SIGNALS_INDEX}));__webpack_require__.d(__webpack_exports__,"i",(function(){return NEEDS_LISTS_INDEXES}));__webpack_require__.d(__webpack_exports__,"h",(function(){return NEEDS_INDEX_PERMISSIONS}));__webpack_require__.d(__webpack_exports__,"d",(function(){return GO_TO_DOCUMENTATION}));__webpack_require__.d(__webpack_exports__,"o",(function(){return USER_UNAUTHENTICATED_TITLE}));__webpack_require__.d(__webpack_exports__,"n",(function(){return USER_UNAUTHENTICATED_MSG_BODY}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ML_RULES_DISABLED_MESSAGE}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ML_RULES_UNAVAILABLE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const BREADCRUMB_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.detectionsBreadcrumbTitle",{defaultMessage:"Detections"});const PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.detectionsPageTitle",{defaultMessage:"Detection alerts"});const LAST_ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.lastSignalTitle",{defaultMessage:"Last alert"});const TOTAL_SIGNAL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.totalSignalTitle",{defaultMessage:"Total"});const SIGNAL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.signalTitle",{defaultMessage:"Detected alerts"});const ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alertTitle",{defaultMessage:"Detection alerts"});const BUTTON_MANAGE_RULES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.buttonManageRules",{defaultMessage:"Manage detection rules"});const PANEL_SUBTITLE_SHOWING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.panelSubtitleShowing",{defaultMessage:"Showing"});const EMPTY_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.emptyTitle",{defaultMessage:"It looks like you don’t have any indices relevant to the detection engine in the Security application"});const EMPTY_ACTION_BEATS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.emptyActionBeats",{defaultMessage:"View setup instructions"});const EMPTY_ACTION_SECONDARY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.emptyActionSecondary",{defaultMessage:"Go to documentation"});const NO_INDEX_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.noIndexTitle",{defaultMessage:"Let’s set up your detection engine"});const NEEDS_SIGNALS_AND_LISTS_INDEXES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.needsSignalsAndListsIndexesMessage",{defaultMessage:"You need permissions for the signals and lists indices."});const NEEDS_SIGNALS_INDEX=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.needsSignalsIndexMessage",{defaultMessage:"You need permissions for the signals index."});const NEEDS_LISTS_INDEXES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.needsListsIndexesMessage",{defaultMessage:"You need permissions for the lists indices."});const NEEDS_INDEX_PERMISSIONS=additionalContext=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.needsIndexPermissionsMessage",{values:{additionalContext:additionalContext},defaultMessage:"To use the detection engine, a user with the required cluster and index privileges must first access this page. {additionalContext} For more help, contact your Elastic Stack administrator."});const GO_TO_DOCUMENTATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.goToDocumentationButton",{defaultMessage:"View documentation"});const USER_UNAUTHENTICATED_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.userUnauthenticatedTitle",{defaultMessage:"Detection engine permissions required"});const USER_UNAUTHENTICATED_MSG_BODY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.userUnauthenticatedMsgBody",{defaultMessage:"You do not have the required permissions for viewing the detection engine. For more help, contact your administrator."});const ML_RULES_DISABLED_MESSAGE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.mlRulesDisabledMessageTitle",{defaultMessage:"ML rules require Platinum License and ML Admin Permissions"});const ML_RULES_UNAVAILABLE=totalRules=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.mlUnavailableTitle",{values:{totalRules:totalRules},defaultMessage:"{totalRules} {totalRules, plural, =1 {rule requires} other {rules require}} Machine Learning to enable."})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return RuleStep}));let RuleStep;(function(RuleStep){RuleStep["defineRule"]="define-rule";RuleStep["aboutRule"]="about-rule";RuleStep["scheduleRule"]="schedule-rule";RuleStep["ruleActions"]="rule-actions"})(RuleStep||(RuleStep={}))},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return FiltersGlobal}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var web=__webpack_require__(231);var use_global_header_portal=__webpack_require__(722);const Wrapper=external_kbnSharedDeps_StyledComponents_default.a.aside.withConfig({displayName:"Wrapper",componentId:"z1qy4y-0"})(["position:relative;z-index:",";background:",";border-bottom:",";padding:"," ",";"],({theme:theme})=>theme.eui.euiZNavigation,({theme:theme})=>theme.eui.euiColorEmptyShade,({theme:theme})=>theme.eui.euiBorderThin,({theme:theme})=>theme.eui.paddingSizes.m,({theme:theme})=>theme.eui.paddingSizes.l);Wrapper.displayName="Wrapper";const FiltersGlobalContainer=external_kbnSharedDeps_StyledComponents_default.a.header.withConfig({displayName:"FiltersGlobalContainer",componentId:"z1qy4y-1"})(["display:",";"],({show:show})=>show?"block":"none");FiltersGlobalContainer.displayName="FiltersGlobalContainer";const FiltersGlobal=external_kbnSharedDeps_React_default.a.memo(({children:children,show:show=true})=>{const{globalHeaderPortalNode:globalHeaderPortalNode}=Object(use_global_header_portal["a"])();return external_kbnSharedDeps_React_default.a.createElement(web["a"],{node:globalHeaderPortalNode},external_kbnSharedDeps_React_default.a.createElement(FiltersGlobalContainer,{"data-test-subj":"filters-global-container",show:show},external_kbnSharedDeps_React_default.a.createElement(Wrapper,{className:"siemFiltersGlobal"},children)))});FiltersGlobal.displayName="FiltersGlobal"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SiemSearchBar}));var fp=__webpack_require__(464);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(105);var external_kbnSharedDeps_Rxjs_=__webpack_require__(15);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var fast_deep_equal=__webpack_require__(107);var fast_deep_equal_default=__webpack_require__.n(fast_deep_equal);var inputs=__webpack_require__(149);var super_date_picker=__webpack_require__(244);var reselect_lib=__webpack_require__(123);var selectors=__webpack_require__(184);const getFilterQuery=inputState=>inputState.query;const getSavedQuery=inputState=>inputState.savedQuery;const filterQuerySelector=()=>Object(reselect_lib["createSelector"])(getFilterQuery,filterQuery=>filterQuery);const savedQuerySelector=()=>Object(reselect_lib["createSelector"])(getSavedQuery,savedQuery=>savedQuery);var store=__webpack_require__(198);var network_store=__webpack_require__(130);var timeline=__webpack_require__(108);var kibana=__webpack_require__(104);const APP_STATE_STORAGE_KEY="securitySolution.searchBar.appState";const SearchBarContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"SearchBarContainer",componentId:"diqkkh-0"})([".globalQueryBar{padding:0px;}"]);const SearchBarComponent=Object(external_kbnSharedDeps_React_["memo"])(({end:end,filterQuery:filterQuery,fromStr:fromStr,id:id,indexPattern:indexPattern,isLoading:isLoading=false,queries:queries,savedQuery:savedQuery,setSavedQuery:setSavedQuery,setSearchBarFilter:setSearchBarFilter,start:start,toStr:toStr,updateSearch:updateSearch,dataTestSubj:dataTestSubj})=>{const{data:{query:{timefilter:{timefilter:timefilter},filterManager:filterManager},ui:{SearchBar:SearchBar}},storage:storage}=Object(kibana["h"])().services;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(fromStr!=null&&toStr!=null){timefilter.setTime({from:fromStr,to:toStr})}else if(start!=null&&end!=null){timefilter.setTime({from:new Date(start).toISOString(),to:new Date(end).toISOString()})}},[end,fromStr,start,timefilter,toStr]);const onQuerySubmit=Object(external_kbnSharedDeps_React_["useCallback"])(payload=>{const isQuickSelection=payload.dateRange.from.includes("now")||payload.dateRange.to.includes("now");let updateSearchBar={id:id,end:toStr!=null?toStr:new Date(end).toISOString(),start:fromStr!=null?fromStr:new Date(start).toISOString(),isInvalid:false,isQuickSelection:isQuickSelection,updateTime:false,filterManager:filterManager};let isStateUpdated=false;if(isQuickSelection&&(fromStr!==payload.dateRange.from||toStr!==payload.dateRange.to)||!isQuickSelection&&(start!==Object(super_date_picker["c"])(payload.dateRange.from)||end!==Object(super_date_picker["c"])(payload.dateRange.to))){isStateUpdated=true;updateSearchBar.updateTime=true;updateSearchBar.end=payload.dateRange.to;updateSearchBar.start=payload.dateRange.from}if(payload.query!=null&&!fast_deep_equal_default()(payload.query,filterQuery)){isStateUpdated=true;updateSearchBar=Object(fp["set"])("query",payload.query,updateSearchBar)}if(!isStateUpdated){if(isQuickSelection&&payload.dateRange.to!==payload.dateRange.from){updateSearchBar.updateTime=true;updateSearchBar.end=payload.dateRange.to;updateSearchBar.start=payload.dateRange.from}else{queries.forEach(q=>q.refetch&&q.refetch())}}window.setTimeout(()=>updateSearch(updateSearchBar),0)},[id,toStr,end,fromStr,start,filterManager,filterQuery,queries,updateSearch]);const onRefresh=Object(external_kbnSharedDeps_React_["useCallback"])(payload=>{if(payload.dateRange.from.includes("now")||payload.dateRange.to.includes("now")){updateSearch({id:id,end:payload.dateRange.to,start:payload.dateRange.from,isInvalid:false,isQuickSelection:true,updateTime:true,filterManager:filterManager})}else{queries.forEach(q=>q.refetch&&q.refetch())}},[updateSearch,id,filterManager,queries]);const onSaved=Object(external_kbnSharedDeps_React_["useCallback"])(newSavedQuery=>{setSavedQuery({id:id,savedQuery:newSavedQuery})},[id,setSavedQuery]);const onSavedQueryUpdated=Object(external_kbnSharedDeps_React_["useCallback"])(savedQueryUpdated=>{const isQuickSelection=savedQueryUpdated.attributes.timefilter?savedQueryUpdated.attributes.timefilter.from.includes("now")||savedQueryUpdated.attributes.timefilter.to.includes("now"):false;let updateSearchBar={id:id,filters:savedQueryUpdated.attributes.filters||[],end:toStr!=null?toStr:new Date(end).toISOString(),start:fromStr!=null?fromStr:new Date(start).toISOString(),isInvalid:false,isQuickSelection:isQuickSelection,updateTime:false,filterManager:filterManager};if(savedQueryUpdated.attributes.timefilter){updateSearchBar.end=savedQueryUpdated.attributes.timefilter?savedQueryUpdated.attributes.timefilter.to:updateSearchBar.end;updateSearchBar.start=savedQueryUpdated.attributes.timefilter?savedQueryUpdated.attributes.timefilter.from:updateSearchBar.start;updateSearchBar.updateTime=true}updateSearchBar=Object(fp["set"])("query",savedQueryUpdated.attributes.query,updateSearchBar);updateSearchBar=Object(fp["set"])("savedQuery",savedQueryUpdated,updateSearchBar);updateSearch(updateSearchBar)},[id,toStr,end,fromStr,start,filterManager,updateSearch]);const onClearSavedQuery=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(savedQuery!=null){updateSearch({id:id,filters:[],end:toStr!=null?toStr:new Date(end).toISOString(),start:fromStr!=null?fromStr:new Date(start).toISOString(),isInvalid:false,isQuickSelection:false,updateTime:false,query:{query:"",language:savedQuery.attributes.query.language},resetSavedQuery:true,savedQuery:undefined,filterManager:filterManager})}},[savedQuery,updateSearch,id,toStr,end,fromStr,start,filterManager]);const saveAppStateToStorage=Object(external_kbnSharedDeps_React_["useCallback"])(filters=>storage.set(APP_STATE_STORAGE_KEY,filters),[storage]);const getAppStateFromStorage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _storage$get;return(_storage$get=storage.get(APP_STATE_STORAGE_KEY))!==null&&_storage$get!==void 0?_storage$get:[]},[storage]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{let isSubscribed=true;const subscriptions=new external_kbnSharedDeps_Rxjs_["Subscription"];subscriptions.add(filterManager.getUpdates$().subscribe({next:()=>{if(isSubscribed){saveAppStateToStorage(filterManager.getAppFilters());setSearchBarFilter({id:id,filters:filterManager.getFilters()})}}}));filterManager.setAppFilters(getAppStateFromStorage());setSearchBarFilter({id:id,filters:filterManager.getFilters()});return()=>{isSubscribed=false;subscriptions.unsubscribe()}},[]);const indexPatterns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[indexPattern],[indexPattern]);return external_kbnSharedDeps_React_default.a.createElement(SearchBarContainer,{"data-test-subj":`${id}DatePicker`},external_kbnSharedDeps_React_default.a.createElement(SearchBar,{appName:"siem",isLoading:isLoading,indexPatterns:indexPatterns,query:filterQuery,onClearSavedQuery:onClearSavedQuery,onQuerySubmit:onQuerySubmit,onRefresh:onRefresh,onSaved:onSaved,onSavedQueryUpdated:onSavedQueryUpdated,savedQuery:savedQuery,showFilterBar:true,showDatePicker:true,showQueryBar:true,showQueryInput:true,showSaveQuery:true,dataTestSubj:dataTestSubj}))},(prevProps,nextProps)=>prevProps.end===nextProps.end&&prevProps.filterQuery===nextProps.filterQuery&&prevProps.fromStr===nextProps.fromStr&&prevProps.id===nextProps.id&&prevProps.isLoading===nextProps.isLoading&&prevProps.savedQuery===nextProps.savedQuery&&prevProps.setSavedQuery===nextProps.setSavedQuery&&prevProps.setSearchBarFilter===nextProps.setSearchBarFilter&&prevProps.start===nextProps.start&&prevProps.toStr===nextProps.toStr&&prevProps.updateSearch===nextProps.updateSearch&&prevProps.dataTestSubj===nextProps.dataTestSubj&&fast_deep_equal_default()(prevProps.indexPattern,nextProps.indexPattern)&&fast_deep_equal_default()(prevProps.queries,nextProps.queries));const makeMapStateToProps=()=>{const getEndSelector=Object(selectors["b"])();const getFromStrSelector=Object(selectors["c"])();const getIsLoadingSelector=Object(selectors["d"])();const getQueriesSelector=Object(selectors["h"])();const getStartSelector=Object(selectors["i"])();const getToStrSelector=Object(selectors["j"])();const getFilterQuerySelector=filterQuerySelector();const getSavedQuerySelector=savedQuerySelector();return(state,{id:id})=>{const inputsRange=Object(external_kbnSharedDeps_LodashFp_["getOr"])({},`inputs.${id}`,state);return{end:getEndSelector(inputsRange),fromStr:getFromStrSelector(inputsRange),filterQuery:getFilterQuerySelector(inputsRange),isLoading:getIsLoadingSelector(inputsRange),queries:getQueriesSelector(state,id),savedQuery:getSavedQuerySelector(inputsRange),start:getStartSelector(inputsRange),toStr:getToStrSelector(inputsRange)}}};SearchBarComponent.displayName="SiemSearchBar";const dispatchUpdateSearch=dispatch=>({end:end,filters:filters,id:id,isQuickSelection:isQuickSelection,query:query,resetSavedQuery:resetSavedQuery,savedQuery:savedQuery,start:start,timelineId:timelineId,filterManager:filterManager,updateTime:updateTime=false})=>{if(updateTime){const fromDate=Object(super_date_picker["c"])(start);let toDate=Object(super_date_picker["c"])(end,{roundUp:true});if(isQuickSelection){if(end===start){dispatch(inputs["b"].setAbsoluteRangeDatePicker({id:id,fromStr:start,toStr:end,from:fromDate,to:toDate}))}else{dispatch(inputs["b"].setRelativeRangeDatePicker({id:id,fromStr:start,toStr:end,from:fromDate,to:toDate}))}}else{toDate=Object(super_date_picker["c"])(end);dispatch(inputs["b"].setAbsoluteRangeDatePicker({id:id,from:Object(super_date_picker["c"])(start),to:Object(super_date_picker["c"])(end)}))}if(timelineId!=null){dispatch(timeline["a"].updateRange({id:timelineId,start:fromDate,end:toDate}))}}if(query!=null){dispatch(inputs["b"].setFilterQuery({id:id,...query}))}if(filters!=null){filterManager.setFilters(filters)}if(savedQuery!=null||resetSavedQuery){dispatch(inputs["b"].setSavedQuery({id:id,savedQuery:savedQuery}))}dispatch(store["a"].setHostTablesActivePageToZero());dispatch(network_store["b"].setNetworkTablesActivePageToZero())};const mapDispatchToProps=dispatch=>({updateSearch:dispatchUpdateSearch(dispatch),setSavedQuery:({id:id,savedQuery:savedQuery})=>dispatch(inputs["b"].setSavedQuery({id:id,savedQuery:savedQuery})),setSearchBarFilter:({id:id,filters:filters})=>dispatch(inputs["b"].setSearchBarFilter({id:id,filters:filters}))});const connector=Object(lib["connect"])(makeMapStateToProps,mapDispatchToProps);const SiemSearchBar=connector(SearchBarComponent)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MatrixHistogram}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var lib=__webpack_require__(105);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const STACK_BY=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.components.histogram.stackByOptions.stackByLabel",{defaultMessage:"Stack by"});var barchart=__webpack_require__(453);var header_section=__webpack_require__(146);var matrix_loader=__webpack_require__(615);var panel=__webpack_require__(205);var utils=__webpack_require__(454);var matrix_histogram=__webpack_require__(790);var components_inspect=__webpack_require__(189);var actions=__webpack_require__(151);const DEFAULT_PANEL_HEIGHT=300;const HeaderChildrenFlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"HeaderChildrenFlexItem",componentId:"b0xfci-0"})(["margin-left:24px;"]);const HistogramPanel=external_kbnSharedDeps_StyledComponents_default()(panel["a"]).withConfig({displayName:"HistogramPanel",componentId:"b0xfci-1"})(["display:flex;flex-direction:column;",""],({height:height})=>height!=null?`min-height: ${height}px;`:"");const MatrixHistogramComponent=({chartHeight:chartHeight,defaultStackByOption:defaultStackByOption,docValueFields:docValueFields,endDate:endDate,errorMessage:errorMessage,filterQuery:filterQuery,headerChildren:headerChildren,histogramType:histogramType,hideHistogramIfEmpty:hideHistogramIfEmpty=false,id:id,indexNames:indexNames,isPtrIncluded:isPtrIncluded,legendPosition:legendPosition,mapping:mapping,panelHeight:panelHeight=DEFAULT_PANEL_HEIGHT,setAbsoluteRangeDatePickerTarget:setAbsoluteRangeDatePickerTarget="global",setQuery:setQuery,showLegend:showLegend,showSpacer:showSpacer=true,stackByOptions:stackByOptions,startDate:startDate,subtitle:subtitle,timelineId:timelineId,title:title,titleSize:titleSize,yTickFormatter:yTickFormatter})=>{const dispatch=Object(lib["useDispatch"])();const handleBrushEnd=Object(external_kbnSharedDeps_React_["useCallback"])(({x:x})=>{if(!x){return}const[min,max]=x;dispatch(Object(actions["setAbsoluteRangeDatePicker"])({id:setAbsoluteRangeDatePickerTarget,from:new Date(min).toISOString(),to:new Date(max).toISOString()}))},[dispatch,setAbsoluteRangeDatePickerTarget]);const barchartConfigs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(utils["b"])({chartHeight:chartHeight,from:startDate,legendPosition:legendPosition,to:endDate,onBrushEnd:handleBrushEnd,yTickFormatter:yTickFormatter,showLegend:showLegend}),[chartHeight,startDate,legendPosition,endDate,handleBrushEnd,yTickFormatter,showLegend]);const[isInitialLoading,setIsInitialLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[selectedStackByOption,setSelectedStackByOption]=Object(external_kbnSharedDeps_React_["useState"])(defaultStackByOption);const setSelectedChartOptionCallback=Object(external_kbnSharedDeps_React_["useCallback"])(event=>{var _stackByOptions$find;setSelectedStackByOption((_stackByOptions$find=stackByOptions.find(co=>co.value===event.target.value))!==null&&_stackByOptions$find!==void 0?_stackByOptions$find:defaultStackByOption)},[defaultStackByOption,stackByOptions]);const[loading,{data:data,inspect:inspect,totalCount:totalCount,refetch:refetch}]=Object(matrix_histogram["a"])({endDate:endDate,errorMessage:errorMessage,filterQuery:filterQuery,histogramType:histogramType,indexNames:indexNames,startDate:startDate,stackByField:selectedStackByOption.value,isPtrIncluded:isPtrIncluded,docValueFields:docValueFields});const titleWithStackByField=Object(external_kbnSharedDeps_React_["useMemo"])(()=>title!=null&&typeof title==="function"?title(selectedStackByOption):title,[title,selectedStackByOption]);const subtitleWithCounts=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(isInitialLoading){return null}if(typeof subtitle==="function"){return totalCount>=0?subtitle(totalCount):null}return subtitle},[isInitialLoading,subtitle,totalCount]);const hideHistogram=Object(external_kbnSharedDeps_React_["useMemo"])(()=>totalCount<=0&&hideHistogramIfEmpty?true:false,[totalCount,hideHistogramIfEmpty]);const barChartData=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(utils["c"])(data,mapping),[data,mapping]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!loading&&!isInitialLoading){setQuery({id:id,inspect:inspect,loading:loading,refetch:refetch})}if(isInitialLoading&&!!barChartData&&data){setIsInitialLoading(false)}},[setQuery,id,inspect,loading,refetch,isInitialLoading,barChartData,data,setIsInitialLoading]);if(hideHistogram){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(components_inspect["b"],{show:!isInitialLoading},external_kbnSharedDeps_React_default.a.createElement(HistogramPanel,{"data-test-subj":`${id}Panel`,height:panelHeight},loading&&!isInitialLoading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{"data-test-subj":"initialLoadingPanelMatrixOverTime",size:"xs",position:"absolute",color:"accent"}),external_kbnSharedDeps_React_default.a.createElement(header_section["a"],{id:id,title:titleWithStackByField,titleSize:titleSize,subtitle:subtitleWithCounts},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},stackByOptions.length>1&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{onChange:setSelectedChartOptionCallback,options:stackByOptions,prepend:STACK_BY,value:selectedStackByOption===null||selectedStackByOption===void 0?void 0:selectedStackByOption.value})),external_kbnSharedDeps_React_default.a.createElement(HeaderChildrenFlexItem,{grow:false},headerChildren))),isInitialLoading?external_kbnSharedDeps_React_default.a.createElement(matrix_loader["a"],null):external_kbnSharedDeps_React_default.a.createElement(barchart["a"],{barChart:barChartData,configs:barchartConfigs,stackByField:selectedStackByOption.value,timelineId:timelineId}))),showSpacer&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{"data-test-subj":"spacer",size:"l"}))};const MatrixHistogram=external_kbnSharedDeps_React_default.a.memo(MatrixHistogramComponent)},,,,,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function guard(lowerBoundary,upperBoundary,value){return Math.max(lowerBoundary,Math.min(upperBoundary,value))}exports.default=guard;module.exports=exports["default"]},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"j",(function(){return NOTES_TOOLTIP}));__webpack_require__.d(__webpack_exports__,"i",(function(){return NOTES_DISABLE_TOOLTIP}));__webpack_require__.d(__webpack_exports__,"q",(function(){return UNPINNED}));__webpack_require__.d(__webpack_exports__,"k",(function(){return PINNED}));__webpack_require__.d(__webpack_exports__,"l",(function(){return PINNED_WITH_NOTES}));__webpack_require__.d(__webpack_exports__,"o",(function(){return SORTED_ASCENDING}));__webpack_require__.d(__webpack_exports__,"p",(function(){return SORTED_DESCENDING}));__webpack_require__.d(__webpack_exports__,"f",(function(){return DISABLE_PIN}));__webpack_require__.d(__webpack_exports__,"r",(function(){return VIEW_DETAILS}));__webpack_require__.d(__webpack_exports__,"s",(function(){return VIEW_DETAILS_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ACTION_INVESTIGATE_IN_RESOLVER}));__webpack_require__.d(__webpack_exports__,"e",(function(){return CHECKBOX_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"n",(function(){return SEND_ALERT_TO_TIMELINE_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ADD_NOTES_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"m",(function(){return PIN_EVENT_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ATTACH_ALERT_TO_CASE_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"h",(function(){return MORE_ACTIONS_FOR_ROW}));__webpack_require__.d(__webpack_exports__,"g",(function(){return INVESTIGATE_IN_RESOLVER_DISABLED}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const NOTES_TOOLTIP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.notes.addOrViewNotesForThisEventTooltip",{defaultMessage:"Add notes for this event"});const NOTES_DISABLE_TOOLTIP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.notes.disableEventTooltip",{defaultMessage:"Notes may not be added here while editing a template timeline"});const COPY_TO_CLIPBOARD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.copyToClipboardButtonLabel",{defaultMessage:"Copy to Clipboard"});const UNPINNED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.pinning.unpinnedTooltip",{defaultMessage:"Unpinned event"});const PINNED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.pinning.pinnedTooltip",{defaultMessage:"Pinned event"});const PINNED_WITH_NOTES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.pinning.pinnnedWithNotesTooltip",{defaultMessage:"This event cannot be unpinned because it has notes"});const SORTED_ASCENDING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.sort.sortedAscendingTooltip",{defaultMessage:"Sorted ascending"});const SORTED_DESCENDING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.sort.sortedDescendingTooltip",{defaultMessage:"Sorted descending"});const DISABLE_PIN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.pinning.disablePinnnedTooltip",{defaultMessage:"This event may not be pinned while editing a template timeline"});const VIEW_DETAILS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.viewDetailsAriaLabel",{defaultMessage:"View details"});const VIEW_DETAILS_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.viewDetailsForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues},defaultMessage:"View details for the alert or event in row {ariaRowindex}, with columns {columnValues}"});const EXPAND_EVENT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.expandEventTooltip",{defaultMessage:"View details"});const COLLAPSE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.collapseAriaLabel",{defaultMessage:"Collapse"});const ACTION_INVESTIGATE_IN_RESOLVER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.investigateInResolverTooltip",{defaultMessage:"Analyze event"});const CHECKBOX_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues,checked:checked})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.checkboxForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,checked:checked,columnValues:columnValues},defaultMessage:"{checked, select, false {unchecked} true {checked}} checkbox for the alert or event in row {ariaRowindex}, with columns {columnValues}"});const ACTION_INVESTIGATE_IN_RESOLVER_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.investigateInResolverForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues},defaultMessage:"Analyze the alert or event in row {ariaRowindex}, with columns {columnValues}"});const SEND_ALERT_TO_TIMELINE_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.sendAlertToTimelineForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues},defaultMessage:"Send the alert in row {ariaRowindex} to timeline, with columns {columnValues}"});const ADD_NOTES_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.addNotesForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues},defaultMessage:"Add notes for the event in row {ariaRowindex} to timeline, with columns {columnValues}"});const PIN_EVENT_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues,isEventPinned:isEventPinned})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.pinEventForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues,isEventPinned:isEventPinned},defaultMessage:"{isEventPinned, select, false {Pin} true {Unpin}} the event in row {ariaRowindex} to timeline, with columns {columnValues}"});const TIMELINE_TOGGLE_BUTTON_ARIA_LABEL=({isOpen:isOpen,title:title})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.properties.timelineToggleButtonAriaLabel",{values:{isOpen:isOpen,title:title},defaultMessage:"{isOpen, select, false {Open} true {Close} other {Toggle}} timeline {title}"});const ATTACH_ALERT_TO_CASE_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.attachAlertToCaseForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues},defaultMessage:"Attach the alert or event in row {ariaRowindex} to a case, with columns {columnValues}"});const MORE_ACTIONS_FOR_ROW=({ariaRowindex:ariaRowindex,columnValues:columnValues})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.moreActionsForRowAriaLabel",{values:{ariaRowindex:ariaRowindex,columnValues:columnValues},defaultMessage:"Select more actions for the alert or event in row {ariaRowindex}, with columns {columnValues}"});const INVESTIGATE_IN_RESOLVER_DISABLED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.body.actions.investigateInResolverDisabledTooltip",{defaultMessage:"This event cannot be analyzed since it has incompatible field mappings"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return ALERTS_DOCUMENT_TYPE}));__webpack_require__.d(__webpack_exports__,"A",(function(){return OPEN_ALERTS}));__webpack_require__.d(__webpack_exports__,"q",(function(){return CLOSED_ALERTS}));__webpack_require__.d(__webpack_exports__,"t",(function(){return IN_PROGRESS_ALERTS}));__webpack_require__.d(__webpack_exports__,"w",(function(){return LOADING_ALERTS}));__webpack_require__.d(__webpack_exports__,"B",(function(){return TOTAL_COUNT_OF_ALERTS}));__webpack_require__.d(__webpack_exports__,"k",(function(){return ALERTS_HEADERS_RULE}));__webpack_require__.d(__webpack_exports__,"p",(function(){return ALERTS_HEADERS_VERSION}));__webpack_require__.d(__webpack_exports__,"i",(function(){return ALERTS_HEADERS_METHOD}));__webpack_require__.d(__webpack_exports__,"l",(function(){return ALERTS_HEADERS_SEVERITY}));__webpack_require__.d(__webpack_exports__,"j",(function(){return ALERTS_HEADERS_RISK_SCORE}));__webpack_require__.d(__webpack_exports__,"n",(function(){return ALERTS_HEADERS_THRESHOLD_COUNT}));__webpack_require__.d(__webpack_exports__,"o",(function(){return ALERTS_HEADERS_THRESHOLD_TERMS}));__webpack_require__.d(__webpack_exports__,"m",(function(){return ALERTS_HEADERS_THRESHOLD_CARDINALITY}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ACTION_OPEN_ALERT}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ACTION_CLOSE_ALERT}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ACTION_IN_PROGRESS_ALERT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ACTION_INVESTIGATE_IN_TIMELINE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ACTION_ADD_EXCEPTION}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ACTION_ADD_ENDPOINT_EXCEPTION}));__webpack_require__.d(__webpack_exports__,"s",(function(){return CLOSED_ALERT_SUCCESS_TOAST}));__webpack_require__.d(__webpack_exports__,"z",(function(){return OPENED_ALERT_SUCCESS_TOAST}));__webpack_require__.d(__webpack_exports__,"v",(function(){return IN_PROGRESS_ALERT_SUCCESS_TOAST}));__webpack_require__.d(__webpack_exports__,"r",(function(){return CLOSED_ALERT_FAILED_TOAST}));__webpack_require__.d(__webpack_exports__,"y",(function(){return OPENED_ALERT_FAILED_TOAST}));__webpack_require__.d(__webpack_exports__,"u",(function(){return IN_PROGRESS_ALERT_FAILED_TOAST}));__webpack_require__.d(__webpack_exports__,"x",(function(){return MORE_ACTIONS}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.pageTitle",{defaultMessage:"Detection engine"});const ALERTS_DOCUMENT_TYPE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.documentTypeTitle",{defaultMessage:"Alerts"});const OPEN_ALERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.openAlertsTitle",{defaultMessage:"Open"});const CLOSED_ALERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.closedAlertsTitle",{defaultMessage:"Closed"});const IN_PROGRESS_ALERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.inProgressAlertsTitle",{defaultMessage:"In progress"});const LOADING_ALERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.loadingAlertsTitle",{defaultMessage:"Loading Alerts"});const TOTAL_COUNT_OF_ALERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.totalCountOfAlertsTitle",{defaultMessage:"alerts"});const ALERTS_HEADERS_RULE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleTitle",{defaultMessage:"Rule"});const ALERTS_HEADERS_VERSION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.versionTitle",{defaultMessage:"Version"});const ALERTS_HEADERS_METHOD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.methodTitle",{defaultMessage:"Method"});const ALERTS_HEADERS_SEVERITY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.severityTitle",{defaultMessage:"Severity"});const ALERTS_HEADERS_RISK_SCORE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.riskScoreTitle",{defaultMessage:"Risk Score"});const ALERTS_HEADERS_THRESHOLD_COUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdCount",{defaultMessage:"Threshold Count"});const ALERTS_HEADERS_THRESHOLD_TERMS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdTerms",{defaultMessage:"Threshold Terms"});const ALERTS_HEADERS_THRESHOLD_CARDINALITY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdCardinality",{defaultMessage:"Threshold Cardinality"});const ACTION_OPEN_ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.openAlertTitle",{defaultMessage:"Open alert"});const ACTION_CLOSE_ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.closeAlertTitle",{defaultMessage:"Close alert"});const ACTION_IN_PROGRESS_ALERT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.inProgressAlertTitle",{defaultMessage:"Mark in progress"});const ACTION_INVESTIGATE_IN_TIMELINE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.investigateInTimelineTitle",{defaultMessage:"Investigate in timeline"});const ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.investigateInTimelineAriaLabel",{defaultMessage:"Send alert to timeline"});const ACTION_ADD_EXCEPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.addException",{defaultMessage:"Add rule exception"});const ACTION_ADD_ENDPOINT_EXCEPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.actions.addEndpointException",{defaultMessage:"Add Endpoint exception"});const CLOSED_ALERT_SUCCESS_TOAST=totalAlerts=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.closedAlertSuccessToastMessage",{values:{totalAlerts:totalAlerts},defaultMessage:"Successfully closed {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}."});const OPENED_ALERT_SUCCESS_TOAST=totalAlerts=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.openedAlertSuccessToastMessage",{values:{totalAlerts:totalAlerts},defaultMessage:"Successfully opened {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}."});const IN_PROGRESS_ALERT_SUCCESS_TOAST=totalAlerts=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.inProgressAlertSuccessToastMessage",{values:{totalAlerts:totalAlerts},defaultMessage:"Successfully marked {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}} as in progress."});const CLOSED_ALERT_FAILED_TOAST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.closedAlertFailedToastMessage",{defaultMessage:"Failed to close alert(s)."});const OPENED_ALERT_FAILED_TOAST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.openedAlertFailedToastMessage",{defaultMessage:"Failed to open alert(s)"});const IN_PROGRESS_ALERT_FAILED_TOAST=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.inProgressAlertFailedToastMessage",{defaultMessage:"Failed to mark alert(s) as in progress"});const MORE_ACTIONS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.detectionEngine.alerts.moreActionsAriaLabel",{defaultMessage:"More actions"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return DELETE_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"f",(function(){return DROP_ANYTHING}));__webpack_require__.d(__webpack_exports__,"g",(function(){return EDIT_MENU_ITEM}));__webpack_require__.d(__webpack_exports__,"h",(function(){return EDIT_TITLE}));__webpack_require__.d(__webpack_exports__,"i",(function(){return EXCLUDE_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"j",(function(){return EXISTS_LABEL}));__webpack_require__.d(__webpack_exports__,"k",(function(){return FILTER_FOR_FIELD_PRESENT}));__webpack_require__.d(__webpack_exports__,"c",(function(){return CONVERT_TO_FIELD}));__webpack_require__.d(__webpack_exports__,"d",(function(){return CONVERT_TO_TEMPLATE_FIELD}));__webpack_require__.d(__webpack_exports__,"n",(function(){return HIGHLIGHTED}));__webpack_require__.d(__webpack_exports__,"m",(function(){return HERE_TO_BUILD_AN}));__webpack_require__.d(__webpack_exports__,"o",(function(){return INCLUDE_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"p",(function(){return NOT}));__webpack_require__.d(__webpack_exports__,"q",(function(){return QUERY}));__webpack_require__.d(__webpack_exports__,"t",(function(){return RE_ENABLE_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"s",(function(){return REMOVE_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"u",(function(){return SHOW_OPTIONS_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"w",(function(){return TEMPORARILY_DISABLE_DATA_PROVIDER}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ADD_FIELD_LABEL}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ADD_TEMPLATE_FIELD_LABEL}));__webpack_require__.d(__webpack_exports__,"v",(function(){return TEMPLATE_FIELD_LABEL}));__webpack_require__.d(__webpack_exports__,"r",(function(){return QUERY_AREA_ARIA_LABEL}));__webpack_require__.d(__webpack_exports__,"l",(function(){return GROUP_AREA_ARIA_LABEL}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const AND=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.and",{defaultMessage:"AND"});const COPY_TO_CLIPBOARD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.copyToClipboardTooltip",{defaultMessage:"Copy to Clipboard"});const DELETE_DATA_PROVIDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.deleteDataProvider",{defaultMessage:"Delete"});const DROP_HERE_TO_ADD_AN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.dropHereToAddAnLabel",{defaultMessage:"Drop here to add an"});const DROP_HERE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.dropHere",{defaultMessage:"Drop here"});const DROP_ANYTHING=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.dropAnything",{defaultMessage:"Drop anything"});const EDIT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.edit",{defaultMessage:"Edit"});const EDIT_MENU_ITEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.editMenuItem",{defaultMessage:"Edit filter"});const EDIT_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.editTitle",{defaultMessage:"EDIT FILTER"});const EXCLUDE_DATA_PROVIDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.excludeDataProvider",{defaultMessage:"Exclude results"});const EXISTS_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.existsLabel",{defaultMessage:"exists"});const FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.fieldLabel",{defaultMessage:"Field"});const FILTER_FOR_FIELD_PRESENT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.filterForFieldPresentLabel",{defaultMessage:"Filter for field present"});const CONVERT_TO_FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.convertToFieldLabel",{defaultMessage:"Convert to field"});const CONVERT_TO_TEMPLATE_FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.convertToTemplateFieldLabel",{defaultMessage:"Convert to template field"});const HIGHLIGHTED=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.highlighted",{defaultMessage:"highlighted"});const HERE_TO_BUILD_AN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.hereToBuildAn",{defaultMessage:"here to build an"});const TO_BUILD_AN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.toBuildAn",{defaultMessage:"to build an"});const INCLUDE_DATA_PROVIDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.includeDataProvider",{defaultMessage:"Include results"});const NOT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.not",{defaultMessage:"NOT"});const OR=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.or",{defaultMessage:"or"});const QUERY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.query",{defaultMessage:"query"});const TOGGLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.toggle",{defaultMessage:"toggle"});const RE_ENABLE_DATA_PROVIDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.reEnableDataProvider",{defaultMessage:"Re-enable"});const REMOVE_DATA_PROVIDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.removeDataProvider",{defaultMessage:"Remove Data Provider"});const SHOW_OPTIONS_DATA_PROVIDER=({field:field,value:value})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.showOptionsDataProviderAriaLabel",{values:{field:field,value:value},defaultMessage:"{field} {value} Press enter for options, or press space to begin dragging"});const TEMPORARILY_DISABLE_DATA_PROVIDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.temporaryDisableDataProvider",{defaultMessage:"Temporarily disable"});const VALUE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.valuePlaceholder",{defaultMessage:"value"});const VALUE_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.valueAriaLabel",{defaultMessage:"value"});const ADD_FIELD_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.addFieldPopoverButtonLabel",{defaultMessage:"Add field"});const ADD_TEMPLATE_FIELD_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.addTemplateFieldPopoverButtonLabel",{defaultMessage:"Add template field"});const TEMPLATE_FIELD_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.templateFieldLabel",{defaultMessage:"Template field"});const QUERY_AREA_ARIA_LABEL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.queryAreaAriaLabel",{defaultMessage:"You are in the timeline query area, which contains groups of data providers that query for events"});const GROUP_AREA_ARIA_LABEL=group=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.dataProviders.groupAreaAriaLabel",{values:{group:group},defaultMessage:"You are in group {group}"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"d",(function(){return IpOverviewId}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DEFAULT_MORE_MAX_HEIGHT}));__webpack_require__.d(__webpack_exports__,"i",(function(){return locationRenderer}));__webpack_require__.d(__webpack_exports__,"f",(function(){return dateRenderer}));__webpack_require__.d(__webpack_exports__,"e",(function(){return autonomousSystemRenderer}));__webpack_require__.d(__webpack_exports__,"g",(function(){return hostIdRenderer}));__webpack_require__.d(__webpack_exports__,"h",(function(){return hostNameRenderer}));__webpack_require__.d(__webpack_exports__,"k",(function(){return whoisRenderer}));__webpack_require__.d(__webpack_exports__,"j",(function(){return reputationRenderer}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DefaultFieldRenderer}));__webpack_require__.d(__webpack_exports__,"c",(function(){return DefaultFieldRendererOverflow}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(74);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__);var lodash_fp__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_2__);var react__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);var styled_components__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_4__);var _common_components_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(116);var _common_components_draggables__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(115);var _common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(114);var _common_components_formatted_date__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(127);var _common_components_links__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(113);var _common_components_page__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__(153);var _network_components_details_translations__WEBPACK_IMPORTED_MODULE_11__=__webpack_require__(312);const DraggableContainerFlexGroup=styled_components__WEBPACK_IMPORTED_MODULE_4___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"]).withConfig({displayName:"DraggableContainerFlexGroup",componentId:"sc-1lhdirr-0"})(["flex-grow:unset;"]);const IpOverviewId="ip-overview";const DEFAULT_MORE_MAX_HEIGHT="200px";const locationRenderer=(fieldNames,data,contextID)=>fieldNames.length>0&&fieldNames.every(fieldName=>Object(lodash_fp__WEBPACK_IMPORTED_MODULE_2__["getOr"])(null,fieldName,data))?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{alignItems:"center",gutterSize:"none","data-test-subj":"location-field"},fieldNames.map((fieldName,index)=>{const locationValue=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_2__["getOr"])("",fieldName,data);return react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3__["Fragment"],{key:`${IpOverviewId}-${fieldName}`},index?", ":"",react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_6__["b"],{id:`location-renderer-default-draggable-${IpOverviewId}-${contextID?`${contextID}-`:""}${fieldName}`,field:fieldName,value:locationValue})))})):Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])();const dateRenderer=timestamp=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_formatted_date__WEBPACK_IMPORTED_MODULE_8__["b"],{value:timestamp});const autonomousSystemRenderer=(as,flowTarget,contextID)=>as&&as.organization&&as.organization.name&&as.number?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{alignItems:"center",gutterSize:"none"},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_6__["b"],{id:`autonomous-system-renderer-default-draggable-${IpOverviewId}-${contextID?`${contextID}-`:""}${flowTarget}.as.organization.name`,field:`${flowTarget}.as.organization.name`,value:as.organization.name})),react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},"/"),react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_6__["b"],{id:`autonomous-system-renderer-default-draggable-${IpOverviewId}-${contextID?`${contextID}-`:""}${flowTarget}.as.number`,field:`${flowTarget}.as.number`,value:`${as.number}`}))):Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])();const hostIdRenderer=({contextID:contextID,host:host,ipFilter:ipFilter,noLink:noLink})=>host.id&&host.ip&&(ipFilter==null||host.ip.includes(ipFilter))?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3___default.a.Fragment,null,host.name&&host.name[0]!=null?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_6__["b"],{id:`host-id-renderer-default-draggable-${IpOverviewId}-${contextID?`${contextID}-`:""}host-id`,field:"host.id",value:host.id[0]},noLink?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3___default.a.Fragment,null,host.id):react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_links__WEBPACK_IMPORTED_MODULE_9__["d"],{hostName:host.name[0]},host.id)):react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3___default.a.Fragment,null,host.id)):Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])();const hostNameRenderer=(host,ipFilter,contextID)=>host&&host.name&&host.name[0]&&host.ip&&(!(ipFilter!=null)||host.ip.includes(ipFilter))?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_6__["b"],{id:`host-name-renderer-default-draggable-${IpOverviewId}-${contextID?`${contextID}-`:""}host-name`,field:"host.name",value:host.name[0]},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_links__WEBPACK_IMPORTED_MODULE_9__["d"],{hostName:host.name[0]},host.name?host.name:Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])())):Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])();const whoisRenderer=ip=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_links__WEBPACK_IMPORTED_MODULE_9__["k"],{domain:ip},_network_components_details_translations__WEBPACK_IMPORTED_MODULE_11__["n"]);const reputationRenderer=ip=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_links__WEBPACK_IMPORTED_MODULE_9__["j"],{domain:ip,direction:"column"});const DefaultFieldRendererComponent=({attrName:attrName,displayCount:displayCount=1,idPrefix:idPrefix,moreMaxHeight:moreMaxHeight=DEFAULT_MORE_MAX_HEIGHT,render:render,rowItems:rowItems})=>{if(rowItems!=null&&rowItems.length>0){const draggables=rowItems.slice(0,displayCount).map((rowItem,index)=>{const id=Object(_common_components_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_5__["l"])(`default-field-renderer-default-draggable-${idPrefix}-${attrName}-${rowItem}`);return react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{key:id,grow:false},index!==0&&react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3___default.a.Fragment,null,",",react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_page__WEBPACK_IMPORTED_MODULE_10__["h"],null)),typeof rowItem==="string"&&react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_6__["b"],{id:id,field:attrName,value:rowItem},render?render(rowItem):rowItem))});return draggables.length>0?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(DraggableContainerFlexGroup,{alignItems:"center",gutterSize:"none",component:"span"},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},draggables," "),react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(DefaultFieldRendererOverflow,{rowItems:rowItems,idPrefix:idPrefix,render:render,overflowIndexStart:displayCount,moreMaxHeight:moreMaxHeight}))):Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])()}else{return Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_7__["d"])()}};const DefaultFieldRenderer=react__WEBPACK_IMPORTED_MODULE_3___default.a.memo(DefaultFieldRendererComponent);DefaultFieldRenderer.displayName="DefaultFieldRenderer";const MoreContainer=react__WEBPACK_IMPORTED_MODULE_3___default.a.memo(({idPrefix:idPrefix,render:render,rowItems:rowItems,moreMaxHeight:moreMaxHeight,overflowIndexStart:overflowIndexStart})=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("div",{"data-test-subj":"more-container",style:{maxHeight:moreMaxHeight,overflow:"auto",paddingRight:"2px"}},rowItems.slice(overflowIndexStart).map((rowItem,i)=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiText"],{key:`${idPrefix}-${rowItem}-${i}`,size:"s"},render?render(rowItem):rowItem))));MoreContainer.displayName="MoreContainer";const DefaultFieldRendererOverflow=react__WEBPACK_IMPORTED_MODULE_3___default.a.memo(({idPrefix:idPrefix,moreMaxHeight:moreMaxHeight,overflowIndexStart:overflowIndexStart=5,render:render,rowItems:rowItems})=>{const[isOpen,setIsOpen]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(false);const togglePopover=Object(react__WEBPACK_IMPORTED_MODULE_3__["useCallback"])(()=>setIsOpen(currentIsOpen=>!currentIsOpen),[]);const button=Object(react__WEBPACK_IMPORTED_MODULE_3__["useMemo"])(()=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3___default.a.Fragment,null," ,",react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiButtonEmpty"],{size:"xs",onClick:togglePopover},`+${rowItems.length-overflowIndexStart} `,react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__["FormattedMessage"],{id:"xpack.securitySolution.fieldRenderers.moreLabel",defaultMessage:"More"}))),[togglePopover,overflowIndexStart,rowItems.length]);return react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},rowItems.length>overflowIndexStart&&react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiPopover"],{id:"popover",button:button,isOpen:isOpen,closePopover:togglePopover,repositionOnScroll:true},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(MoreContainer,{idPrefix:idPrefix,render:render,rowItems:rowItems,moreMaxHeight:moreMaxHeight,overflowIndexStart:overflowIndexStart})))});DefaultFieldRendererOverflow.displayName="DefaultFieldRendererOverflow"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return TruncatableText}));var styled_components__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_0__);const TruncatableText=styled_components__WEBPACK_IMPORTED_MODULE_0___default.a.span.withConfig({displayName:"TruncatableText",componentId:"tq7217-0"})(["&,& *{display:inline-block;max-width:100%;overflow:hidden;text-overflow:ellipsis;vertical-align:top;white-space:nowrap;}"]);TruncatableText.displayName="TruncatableText"},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"i",(function(){return PAGE_TITLE}));__webpack_require__.d(__webpack_exports__,"d",(function(){return NAVIGATION_ALL_HOSTS_TITLE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return NAVIGATION_AUTHENTICATIONS_TITLE}));__webpack_require__.d(__webpack_exports__,"h",(function(){return NAVIGATION_UNCOMMON_PROCESSES_TITLE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return NAVIGATION_ANOMALIES_TITLE}));__webpack_require__.d(__webpack_exports__,"g",(function(){return NAVIGATION_EVENTS_TITLE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return NAVIGATION_ALERTS_TITLE}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ERROR_FETCHING_AUTHENTICATIONS_DATA}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ERROR_FETCHING_EVENTS_DATA}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const KQL_PLACEHOLDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.kqlPlaceholder",{defaultMessage:'e.g. host.name: "foo"'});const PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.pageTitle",{defaultMessage:"Hosts"});const NAVIGATION_ALL_HOSTS_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigation.allHostsTitle",{defaultMessage:"All hosts"});const NAVIGATION_AUTHENTICATIONS_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigation.authenticationsTitle",{defaultMessage:"Authentications"});const NAVIGATION_UNCOMMON_PROCESSES_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigation.uncommonProcessesTitle",{defaultMessage:"Uncommon processes"});const NAVIGATION_ANOMALIES_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigation.anomaliesTitle",{defaultMessage:"Anomalies"});const NAVIGATION_EVENTS_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigation.eventsTitle",{defaultMessage:"Events"});const NAVIGATION_ALERTS_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigation.alertsTitle",{defaultMessage:"External alerts"});const ERROR_FETCHING_AUTHENTICATIONS_DATA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigaton.matrixHistogram.errorFetchingAuthenticationsData",{defaultMessage:"Failed to query authentications data"});const ERROR_FETCHING_EVENTS_DATA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.hosts.navigaton.matrixHistogram.errorFetchingEventsData",{defaultMessage:"Failed to query events data"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return PreferenceFormattedBytes}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_numeral__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(83);var _elastic_numeral__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_numeral__WEBPACK_IMPORTED_MODULE_1__);var _common_constants__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var _lib_kibana__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(104);const formatBytes=(value,format)=>_elastic_numeral__WEBPACK_IMPORTED_MODULE_1___default()(value).format(format);const useFormatBytes=()=>{const[bytesFormat]=Object(_lib_kibana__WEBPACK_IMPORTED_MODULE_3__["l"])(_common_constants__WEBPACK_IMPORTED_MODULE_2__["p"]);return value=>formatBytes(value,bytesFormat)};const PreferenceFormattedBytesComponent=({value:value})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,useFormatBytes()(value));PreferenceFormattedBytesComponent.displayName="PreferenceFormattedBytesComponent";const PreferenceFormattedBytes=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(PreferenceFormattedBytesComponent);PreferenceFormattedBytes.displayName="PreferenceFormattedBytes"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return useEventDetailsWidthContext}));__webpack_require__.d(__webpack_exports__,"a",(function(){return EventDetailsWidthProvider}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _utils__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(228);const EventDetailsWidthContext=Object(react__WEBPACK_IMPORTED_MODULE_0__["createContext"])(0);const useEventDetailsWidthContext=()=>Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(EventDetailsWidthContext);const EventDetailsWidthProvider=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(({children:children})=>{const{ref:ref,width:width}=Object(_utils__WEBPACK_IMPORTED_MODULE_1__["b"])();return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(EventDetailsWidthContext.Provider,{value:width},children),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{ref:ref}))});EventDetailsWidthProvider.displayName="EventDetailsWidthProvider"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return hasMlLicense}));const hasMlLicense=capabilities=>capabilities.isPlatinumOrTrialLicense},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return useEndpointSelector}));__webpack_require__.d(__webpack_exports__,"c",(function(){return useIngestUrl}));__webpack_require__.d(__webpack_exports__,"a",(function(){return useAgentDetailsIngestUrl}));var react_redux__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(104);var _common_constants__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(121);function useEndpointSelector(selector){return Object(react_redux__WEBPACK_IMPORTED_MODULE_0__["useSelector"])((function(state){return selector(state[_common_constants__WEBPACK_IMPORTED_MODULE_3__["l"]][_common_constants__WEBPACK_IMPORTED_MODULE_3__["k"]])}))}const useIngestUrl=subpath=>{const{services:services}=Object(_common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__["h"])();return Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>{const appPath=`#/${subpath}`;return{url:`${services.application.getUrlForApp("fleet")}${appPath}`,appId:"fleet",appPath:appPath}},[services.application,subpath])};const useAgentDetailsIngestUrl=agentId=>{const{services:services}=Object(_common_lib_kibana__WEBPACK_IMPORTED_MODULE_2__["h"])();return Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>{const appPath=`#/fleet/agents/${agentId}/activity`;return{url:`${services.application.getUrlForApp("fleet")}${appPath}`,appId:"fleet",appPath:appPath}},[services.application,agentId])}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return NetworkRouteType}));let NetworkRouteType;(function(NetworkRouteType){NetworkRouteType["flows"]="flows";NetworkRouteType["dns"]="dns";NetworkRouteType["anomalies"]="anomalies";NetworkRouteType["tls"]="tls";NetworkRouteType["http"]="http";NetworkRouteType["alerts"]="external-alerts"})(NetworkRouteType||(NetworkRouteType={}))},,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DetailsPanel}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(105);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var timeline=__webpack_require__(108);var defaults=__webpack_require__(118);var types_timeline=__webpack_require__(106);var use_selector=__webpack_require__(109);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var fast_deep_equal=__webpack_require__(107);var fast_deep_equal_default=__webpack_require__.n(fast_deep_equal);var polished_lib=__webpack_require__(180);var helpers=__webpack_require__(134);var add_timeline_button=__webpack_require__(797);var source=__webpack_require__(175);var column_headers_helpers=__webpack_require__(443);var draggable_wrapper=__webpack_require__(144);var droppable_wrapper=__webpack_require__(450);var drag_and_drop_helpers=__webpack_require__(116);var field_badge=__webpack_require__(462);var field_items=__webpack_require__(527);var tables_helpers=__webpack_require__(183);var default_headers=__webpack_require__(142);var constants=__webpack_require__(192);var renderers_constants=__webpack_require__(457);var formatted_field=__webpack_require__(402);var event_details_helpers=__webpack_require__(298);var translations=__webpack_require__(370);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const HoverActionsContainer=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).withConfig({displayName:"HoverActionsContainer",componentId:"bbzzvi-0"})(["align-items:center;display:flex;flex-direction:row;height:25px;justify-content:center;left:5px;position:absolute;top:-10px;width:30px;"]);HoverActionsContainer.displayName="HoverActionsContainer";const FullWidthFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"FullWidthFlexGroup",componentId:"bbzzvi-1"})(["width:100%;"]);const FullWidthFlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FullWidthFlexItem",componentId:"bbzzvi-2"})(["width:100%;"]);const getColumns=({browserFields:browserFields,columnHeaders:columnHeaders,eventId:eventId,onUpdateColumns:onUpdateColumns,contextId:contextId,timelineId:timelineId,toggleColumn:toggleColumn,getLinkValue:getLinkValue})=>[{field:"field",name:"",sortable:false,truncateText:false,width:"30px",render:(field,data)=>{const label=data.isObjectArray?translations["f"](field):translations["k"](field);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{"aria-label":label,checked:columnHeaders.findIndex(c=>c.id===field)!==-1,"data-test-subj":`toggle-field-${field}`,"data-colindex":1,id:field,onChange:()=>toggleColumn({columnHeaderType:default_headers["b"],id:field,width:constants["b"]}),disabled:data.isObjectArray&&data.type!=="geo_point"}))}},{field:"field",name:translations["c"],sortable:true,truncateText:false,render:(field,data)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:data.type},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{"data-test-subj":"field-type-icon",type:Object(event_details_helpers["d"])(data.type)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},data.isObjectArray&&data.type!=="geo_point"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,field):external_kbnSharedDeps_React_default.a.createElement(droppable_wrapper["a"],{droppableId:Object(drag_and_drop_helpers["p"])(`event-details-field-droppable-wrapper-${contextId}-${eventId}-${data.category}-${field}`),key:Object(drag_and_drop_helpers["p"])(`event-details-field-droppable-wrapper-${contextId}-${eventId}-${data.category}-${field}`),isDropDisabled:true,type:drag_and_drop_helpers["b"],renderClone:provided=>external_kbnSharedDeps_React_default.a.createElement("div",_extends({},provided.draggableProps,provided.dragHandleProps,{ref:provided.innerRef,tabIndex:-1}),external_kbnSharedDeps_React_default.a.createElement(draggable_wrapper["a"],null,external_kbnSharedDeps_React_default.a.createElement(field_badge["a"],{fieldId:field})))},external_kbnSharedDeps_React_default.a.createElement(field_items["a"],{browserFields:browserFields,categoryId:data.category,fieldName:field,fieldCategory:data.category,onUpdateColumns:onUpdateColumns,timelineId:timelineId,toggleColumn:toggleColumn}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{"aria-label":translations["b"],type:"iInCircle",color:"subdued",content:`${data.description||""} ${Object(event_details_helpers["c"])(data.example)}`})))},{field:"values",name:translations["j"],sortable:true,truncateText:false,render:(values,data)=>external_kbnSharedDeps_React_default.a.createElement(FullWidthFlexGroup,{direction:"column",alignItems:"flexStart",component:"span",gutterSize:"none"},values!=null&&values.map((value,i)=>external_kbnSharedDeps_React_default.a.createElement(FullWidthFlexItem,{grow:false,component:"span",key:`event-details-value-flex-item-${contextId}-${eventId}-${data.field}-${i}-${value}`},external_kbnSharedDeps_React_default.a.createElement("div",{"data-colindex":3,onFocus:helpers["s"],role:"button",tabIndex:0},data.field===renderers_constants["g"]?external_kbnSharedDeps_React_default.a.createElement(tables_helpers["a"],{value:value}):external_kbnSharedDeps_React_default.a.createElement(formatted_field["a"],{contextId:`event-details-value-formatted-field-value-${contextId}-${eventId}-${data.field}-${i}-${value}`,eventId:eventId,fieldFormat:data.format,fieldName:data.field,fieldType:data.type,isObjectArray:data.isObjectArray,value:value,linkValue:getLinkValue(data.field)})))))},{field:"valuesConcatenated",name:translations["a"],render:()=>null,sortable:false,truncateText:true,width:"1px"}];const TableWrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"TableWrapper",componentId:"sc-1mn70y-0"})(["display:flex;flex:1;overflow:hidden;> div{display:flex;flex-direction:column;flex:1;overflow:hidden;> .euiFlexGroup:first-of-type{flex:0;}}"]);const StyledEuiInMemoryTable=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"]).withConfig({displayName:"StyledEuiInMemoryTable",componentId:"sc-1mn70y-1"})(["flex:1;overflow:auto;&::-webkit-scrollbar{height:",";width:",";}&::-webkit-scrollbar-thumb{background-clip:content-box;background-color:",";border:"," solid transparent;}&::-webkit-scrollbar-corner,&::-webkit-scrollbar-track{background-color:transparent;}"],({theme:theme})=>theme.eui.euiScrollBar,({theme:theme})=>theme.eui.euiScrollBar,({theme:theme})=>Object(polished_lib["rgba"])(theme.eui.euiColorDarkShade,.5),({theme:theme})=>theme.eui.euiScrollBarCorner);const getAriaRowindex=timelineEventsDetailsItem=>timelineEventsDetailsItem.ariaRowindex!=null?{"data-rowindex":timelineEventsDetailsItem.ariaRowindex}:{};const EventFieldsBrowser=external_kbnSharedDeps_React_default.a.memo(({browserFields:browserFields,data:data,eventId:eventId,timelineTabType:timelineTabType,timelineId:timelineId})=>{const containerElement=Object(external_kbnSharedDeps_React_["useRef"])(null);const dispatch=Object(lib["useDispatch"])();const getTimeline=Object(external_kbnSharedDeps_React_["useMemo"])(()=>timeline["b"].getTimelineByIdSelector(),[]);const fieldsByName=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(source["a"])(browserFields),[browserFields]);const items=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_LodashFp_["sortBy"])(["field"],data).map((item,i)=>({...item,...fieldsByName[item.field],valuesConcatenated:item.values!=null?item.values.join():"",ariaRowindex:Object(helpers["f"])(i)})),[data,fieldsByName]);const columnHeaders=Object(use_selector["a"])(state=>{var _getTimeline;const{columns:columns}=(_getTimeline=getTimeline(state,timelineId))!==null&&_getTimeline!==void 0?_getTimeline:defaults["a"];return Object(column_headers_helpers["b"])(columns,browserFields)});const getLinkValue=Object(external_kbnSharedDeps_React_["useCallback"])(field=>{var _columnHeaders$find;const linkField=((_columnHeaders$find=columnHeaders.find(col=>col.id===field))!==null&&_columnHeaders$find!==void 0?_columnHeaders$find:{}).linkField;if(!linkField){return null}const linkFieldData=(data!==null&&data!==void 0?data:[]).find(d=>d.field===linkField);const linkFieldValue=Object(external_kbnSharedDeps_LodashFp_["getOr"])(null,"originalValue",linkFieldData);return Array.isArray(linkFieldValue)?linkFieldValue[0]:linkFieldValue},[data,columnHeaders]);const toggleColumn=Object(external_kbnSharedDeps_React_["useCallback"])(column=>{if(columnHeaders.some(c=>c.id===column.id)){dispatch(timeline["a"].removeColumn({columnId:column.id,id:timelineId}))}else{dispatch(timeline["a"].upsertColumn({column:column,id:timelineId,index:1}))}},[columnHeaders,dispatch,timelineId]);const onUpdateColumns=Object(external_kbnSharedDeps_React_["useCallback"])(columns=>dispatch(timeline["a"].updateColumns({id:timelineId,columns:columns})),[dispatch,timelineId]);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getColumns({browserFields:browserFields,columnHeaders:columnHeaders,eventId:eventId,onUpdateColumns:onUpdateColumns,contextId:`event-fields-browser-for-${timelineId}-${timelineTabType}`,timelineId:timelineId,toggleColumn:toggleColumn,getLinkValue:getLinkValue}),[browserFields,columnHeaders,eventId,onUpdateColumns,timelineId,timelineTabType,toggleColumn,getLinkValue]);const focusSearchInput=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _containerElement$cur,_containerElement$cur2;(_containerElement$cur=containerElement.current)===null||_containerElement$cur===void 0?void 0:(_containerElement$cur2=_containerElement$cur.querySelector('input[type="search"]'))===null||_containerElement$cur2===void 0?void 0:_containerElement$cur2.focus()},[]);const focusAddTimelineButton=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _document$querySelect;(_document$querySelect=document.querySelector(`.${add_timeline_button["a"]}`))===null||_document$querySelect===void 0?void 0:_document$querySelect.focus()},[]);const onKeyDown=Object(external_kbnSharedDeps_React_["useCallback"])(keyboardEvent=>{if(Object(helpers["r"])(keyboardEvent)){Object(event_details_helpers["e"])({containerElement:containerElement.current,keyboardEvent:keyboardEvent,onSkipFocusBeforeEventsTable:focusSearchInput,onSkipFocusAfterEventsTable:focusAddTimelineButton})}else{Object(helpers["t"])({colindexAttribute:helpers["c"],containerElement:containerElement===null||containerElement===void 0?void 0:containerElement.current,event:keyboardEvent,maxAriaColindex:3,maxAriaRowindex:data.length,onColumnFocused:external_kbnSharedDeps_LodashFp_["noop"],rowindexAttribute:helpers["d"]})}},[data,focusAddTimelineButton,focusSearchInput]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{focusSearchInput()},[focusSearchInput]);return external_kbnSharedDeps_React_default.a.createElement(TableWrapper,{onKeyDown:onKeyDown,ref:containerElement},external_kbnSharedDeps_React_default.a.createElement(StyledEuiInMemoryTable,{className:event_details_helpers["a"],items:items,columns:columns,pagination:false,rowProps:getAriaRowindex,search:event_details_helpers["f"],sorting:false}))});EventFieldsBrowser.displayName="EventFieldsBrowser";var fp=__webpack_require__(464);var body_helpers=__webpack_require__(226);const EuiCodeEditorContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"EuiCodeEditorContainer",componentId:"sc-4gfrjz-0"})([".euiCodeEditorWrapper{position:absolute;}"]);const EDITOR_SET_OPTIONS={fontSize:"12px"};const JsonView=external_kbnSharedDeps_React_default.a.memo(({data:data})=>{const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>JSON.stringify(buildJsonView(data),body_helpers["m"],2),[data]);return external_kbnSharedDeps_React_default.a.createElement(EuiCodeEditorContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{"data-test-subj":"jsonView",isReadOnly:true,mode:"javascript",setOptions:EDITOR_SET_OPTIONS,value:value,width:"100%",height:"100%"}))});JsonView.displayName="JsonView";const buildJsonView=data=>data.sort((a,b)=>a.field.localeCompare(b.field)).reduce((accumulator,item)=>Object(fp["set"])(item.field,Array.isArray(item.originalValue)?item.originalValue.join():item.originalValue,accumulator),{});var alerts_table_translations=__webpack_require__(263);var components_ip=__webpack_require__(294);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const READ_MORE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.alertDetails.summary.readMore",{defaultMessage:"Read More"});const READ_LESS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.alertDetails.summary.readLess",{defaultMessage:"Read Less"});const LINE_CLAMP=3;const LINE_CLAMP_HEIGHT=5.5;const StyledLineClamp=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"StyledLineClamp",componentId:"sc-1bgugwj-0"})(["display:-webkit-box;-webkit-line-clamp:",";-webkit-box-orient:vertical;overflow:hidden;max-height:",";height:",";"],LINE_CLAMP,`${LINE_CLAMP_HEIGHT}em`,`${LINE_CLAMP_HEIGHT}em`);const ReadMore=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"]).withConfig({displayName:"ReadMore",componentId:"sc-1bgugwj-1"})(["span.euiButtonContent{padding:0;}"]);const ExpandedContent=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"ExpandedContent",componentId:"sc-1bgugwj-2"})(["max-height:33vh;overflow-wrap:break-word;overflow-x:hidden;overflow-y:auto;"]);const LineClampComponent=({content:content})=>{const[isOverflow,setIsOverflow]=Object(external_kbnSharedDeps_React_["useState"])(null);const[isExpanded,setIsExpanded]=Object(external_kbnSharedDeps_React_["useState"])(null);const descriptionRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const toggleReadMore=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsExpanded(prevState=>!prevState)},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{var _descriptionRef$curre;if(content!=null&&(descriptionRef===null||descriptionRef===void 0?void 0:(_descriptionRef$curre=descriptionRef.current)===null||_descriptionRef$curre===void 0?void 0:_descriptionRef$curre.clientHeight)!=null){var _descriptionRef$curre2,_descriptionRef$curre3,_descriptionRef$curre4,_descriptionRef$curre5,_ref,_descriptionRef$curre6,_descriptionRef$curre7,_descriptionRef$curre8;if(((_descriptionRef$curre2=descriptionRef===null||descriptionRef===void 0?void 0:(_descriptionRef$curre3=descriptionRef.current)===null||_descriptionRef$curre3===void 0?void 0:_descriptionRef$curre3.scrollHeight)!==null&&_descriptionRef$curre2!==void 0?_descriptionRef$curre2:0)>((_descriptionRef$curre4=descriptionRef===null||descriptionRef===void 0?void 0:(_descriptionRef$curre5=descriptionRef.current)===null||_descriptionRef$curre5===void 0?void 0:_descriptionRef$curre5.clientHeight)!==null&&_descriptionRef$curre4!==void 0?_descriptionRef$curre4:0)){setIsOverflow(true)}if(((_ref=content==null||(descriptionRef===null||descriptionRef===void 0?void 0:(_descriptionRef$curre6=descriptionRef.current)===null||_descriptionRef$curre6===void 0?void 0:_descriptionRef$curre6.scrollHeight))!==null&&_ref!==void 0?_ref:0)<=((_descriptionRef$curre7=descriptionRef===null||descriptionRef===void 0?void 0:(_descriptionRef$curre8=descriptionRef.current)===null||_descriptionRef$curre8===void 0?void 0:_descriptionRef$curre8.clientHeight)!==null&&_descriptionRef$curre7!==void 0?_descriptionRef$curre7:0)){setIsOverflow(false)}}},[content]);if(!content){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isExpanded?external_kbnSharedDeps_React_default.a.createElement(ExpandedContent,{"data-test-subj":"expanded-line-clamp"},external_kbnSharedDeps_React_default.a.createElement("p",null,content)):isOverflow==null||isOverflow===true?external_kbnSharedDeps_React_default.a.createElement(StyledLineClamp,{"data-test-subj":"styled-line-clamp",ref:descriptionRef},content):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{"data-test-subj":"default-line-clamp"},content),isOverflow&&external_kbnSharedDeps_React_default.a.createElement(ReadMore,{onClick:toggleReadMore,size:"s","data-test-subj":"summary-view-readmore"},isExpanded?READ_LESS:READ_MORE))};const LineClamp=external_kbnSharedDeps_React_default.a.memo(LineClampComponent);var use_rule_async=__webpack_require__(378);const fields=[{id:"signal.status"},{id:"@timestamp"},{id:renderers_constants["j"],linkField:"signal.rule.id",label:alerts_table_translations["k"]},{id:"signal.rule.severity",label:alerts_table_translations["l"]},{id:"signal.rule.risk_score",label:alerts_table_translations["j"]},{id:"host.name"},{id:"user.name"},{id:components_ip["c"],fieldType:renderers_constants["f"]},{id:components_ip["a"],fieldType:renderers_constants["f"]},{id:"signal.threshold_result.count",label:alerts_table_translations["n"]},{id:"signal.threshold_result.terms",label:alerts_table_translations["o"]},{id:"signal.threshold_result.cardinality",label:alerts_table_translations["m"]}];const summary_view_StyledEuiInMemoryTable=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"]).withConfig({displayName:"StyledEuiInMemoryTable",componentId:"amvwc3-0"})([".euiTableHeaderCell{border:none;}.euiTableRowCell{border:none;}"]);const StyledEuiDescriptionList=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"]).withConfig({displayName:"StyledEuiDescriptionList",componentId:"amvwc3-1"})(["padding:24px 4px 4px;"]);const getTitle=title=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,title));getTitle.displayName="getTitle";const getDescription=({contextId:contextId,eventId:eventId,fieldName:fieldName,value:value,fieldType:fieldType="",linkValue:linkValue})=>external_kbnSharedDeps_React_default.a.createElement(formatted_field["a"],{contextId:`alert-details-value-formatted-field-value-${contextId}-${eventId}-${fieldName}-${value}`,eventId:eventId,fieldName:fieldName,fieldType:fieldType,value:value,linkValue:linkValue});const getSummary=({data:data,browserFields:browserFields,timelineId:timelineId,eventId:eventId})=>data!=null?fields.reduce((acc,item)=>{var _item$fieldType,_item$label;const field=data.find(d=>d.field===item.id);if(!field){return acc}const linkValueField=item.linkField!=null&&data.find(d=>d.field===item.linkField);const linkValue=Object(external_kbnSharedDeps_LodashFp_["getOr"])(null,"originalValue.0",linkValueField);const value=Object(external_kbnSharedDeps_LodashFp_["getOr"])(null,"originalValue.0",field);const category=field.category;const fieldType=Object(external_kbnSharedDeps_LodashFp_["get"])(`${category}.fields.${field.field}.type`,browserFields);const description={contextId:timelineId,eventId:eventId,fieldName:item.id,value:value,fieldType:(_item$fieldType=item.fieldType)!==null&&_item$fieldType!==void 0?_item$fieldType:fieldType,linkValue:linkValue!==null&&linkValue!==void 0?linkValue:undefined};if(item.id==="signal.threshold_result.terms"){try{const terms=Object(external_kbnSharedDeps_LodashFp_["getOr"])(null,"originalValue",field);const parsedValue=terms.map(term=>JSON.parse(term));const thresholdTerms=(parsedValue!==null&&parsedValue!==void 0?parsedValue:[]).map(entry=>({title:`${entry.field} [threshold]`,description:{...description,value:entry.value}}));return[...acc,...thresholdTerms]}catch(err){return acc}}if(item.id==="signal.threshold_result.cardinality"){try{const parsedValue=JSON.parse(value);return[...acc,{title:alerts_table_translations["m"],description:{...description,value:`count(${parsedValue.field}) == ${parsedValue.value}`}}]}catch(err){return acc}}return[...acc,{title:(_item$label=item.label)!==null&&_item$label!==void 0?_item$label:item.id,description:description}]},[]):[];const summaryColumns=[{field:"title",truncateText:false,render:getTitle,width:"120px",name:""},{field:"description",truncateText:false,render:getDescription,name:""}];const SummaryViewComponent=({data:data,eventId:eventId,timelineId:timelineId,browserFields:browserFields})=>{const ruleId=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _item$originalValue;const item=data.find(d=>d.field==="signal.rule.id");return Array.isArray(item===null||item===void 0?void 0:item.originalValue)?item===null||item===void 0?void 0:item.originalValue[0]:(_item$originalValue=item===null||item===void 0?void 0:item.originalValue)!==null&&_item$originalValue!==void 0?_item$originalValue:null},[data]);const{rule:maybeRule}=Object(use_rule_async["a"])(ruleId);const summaryList=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getSummary({browserFields:browserFields,data:data,eventId:eventId,timelineId:timelineId}),[browserFields,data,eventId,timelineId]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(summary_view_StyledEuiInMemoryTable,{"data-test-subj":"summary-view",items:summaryList,columns:summaryColumns,compressed:true}),(maybeRule===null||maybeRule===void 0?void 0:maybeRule.note)&&external_kbnSharedDeps_React_default.a.createElement(StyledEuiDescriptionList,{"data-test-subj":"summary-view-guide",compressed:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,translations["d"]),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(LineClamp,{content:maybeRule===null||maybeRule===void 0?void 0:maybeRule.note}))))};const SummaryView=external_kbnSharedDeps_React_default.a.memo(SummaryViewComponent);let EventsViewType;(function(EventsViewType){EventsViewType["tableView"]="table-view";EventsViewType["jsonView"]="json-view";EventsViewType["summaryView"]="summary-view"})(EventsViewType||(EventsViewType={}));const StyledEuiTabbedContent=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiTabbedContent"]).withConfig({displayName:"StyledEuiTabbedContent",componentId:"sc-5ll1tb-0"})(["display:flex;flex:1;flex-direction:column;overflow:hidden;> [role='tabpanel']{display:flex;flex:1;flex-direction:column;overflow:hidden;}"]);const TabContentWrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"TabContentWrapper",componentId:"sc-5ll1tb-1"})(["height:100%;position:relative;"]);const EventDetailsComponent=({browserFields:browserFields,data:data,id:id,view:view,onViewSelected:onViewSelected,timelineTabType:timelineTabType,timelineId:timelineId,isAlert:isAlert})=>{const handleTabClick=Object(external_kbnSharedDeps_React_["useCallback"])(e=>onViewSelected(e.id),[onViewSelected]);const alerts=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{id:EventsViewType.summaryView,name:translations["h"],content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(SummaryView,{data:data,eventId:id,browserFields:browserFields,timelineId:timelineId}))}],[data,id,browserFields,timelineId]);const tabs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[...isAlert?alerts:[],{id:EventsViewType.tableView,name:translations["i"],content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(EventFieldsBrowser,{browserFields:browserFields,data:data,eventId:id,timelineId:timelineId,timelineTabType:timelineTabType}))},{id:EventsViewType.jsonView,name:translations["e"],content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(TabContentWrapper,null,external_kbnSharedDeps_React_default.a.createElement(JsonView,{data:data})))}],[alerts,browserFields,data,id,isAlert,timelineId,timelineTabType]);const selectedTab=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _tabs$find;return(_tabs$find=tabs.find(t=>t.id===view))!==null&&_tabs$find!==void 0?_tabs$find:tabs[0]},[tabs,view]);return external_kbnSharedDeps_React_default.a.createElement(StyledEuiTabbedContent,{"data-test-subj":"eventDetails",tabs:tabs,selectedTab:selectedTab,onTabClick:handleTabClick})};EventDetailsComponent.displayName="EventDetailsComponent";const EventDetails=external_kbnSharedDeps_React_default.a.memo(EventDetailsComponent);const MESSAGE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.expandableEvent.messageTitle",{defaultMessage:"Message"});const CLOSE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.expandableEvent.closeEventDetailsLabel",{defaultMessage:"close"});const EVENT_DETAILS_PLACEHOLDER=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.expandableEvent.placeholder",{defaultMessage:"Select an event to show event details"});const EVENT_DETAILS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.expandableEvent.eventTitleLabel",{defaultMessage:"Event details"});const ALERT_DETAILS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.expandableEvent.alertTitleLabel",{defaultMessage:"Alert details"});const StyledEuiFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"StyledEuiFlexGroup",componentId:"v6xric-0"})(["flex:0 1 auto;",""],({theme:theme})=>`margin-top: ${theme.eui.euiSizeS};`);const StyledFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"StyledFlexGroup",componentId:"v6xric-1"})(["height:100%;"]);const StyledEuiFlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"StyledEuiFlexItem",componentId:"v6xric-2"})(["&.euiFlexItem{flex:1 0 0;overflow:hidden;}"]);const ExpandableEventTitle=external_kbnSharedDeps_React_default.a.memo(({isAlert:isAlert,loading:loading,handleOnEventClosed:handleOnEventClosed})=>external_kbnSharedDeps_React_default.a.createElement(StyledEuiFlexGroup,{gutterSize:"none",justifyContent:"spaceBetween",wrap:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},!loading?external_kbnSharedDeps_React_default.a.createElement("h4",null,isAlert?ALERT_DETAILS:EVENT_DETAILS):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null))),handleOnEventClosed&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"cross","aria-label":CLOSE,onClick:handleOnEventClosed}))));ExpandableEventTitle.displayName="ExpandableEventTitle";const ExpandableEvent=external_kbnSharedDeps_React_default.a.memo(({browserFields:browserFields,event:event,timelineId:timelineId,timelineTabType:timelineTabType,isAlert:isAlert,loading:loading,detailsData:detailsData})=>{const[view,setView]=Object(external_kbnSharedDeps_React_["useState"])(EventsViewType.summaryView);const message=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(detailsData){const messageField=Object(external_kbnSharedDeps_LodashFp_["find"])({category:"base",field:"message"},detailsData);if(messageField!==null&&messageField!==void 0&&messageField.originalValue){return Array.isArray(messageField===null||messageField===void 0?void 0:messageField.originalValue)?messageField===null||messageField===void 0?void 0:messageField.originalValue.join():messageField===null||messageField===void 0?void 0:messageField.originalValue}}return null},[detailsData]);if(!event.eventId){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},EVENT_DETAILS_PLACEHOLDER)}if(loading){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{lines:10})}return external_kbnSharedDeps_React_default.a.createElement(StyledFlexGroup,{direction:"column",gutterSize:"none"},message&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{"data-test-subj":"event-message",compressed:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,MESSAGE),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(LineClamp,{content:message}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})),external_kbnSharedDeps_React_default.a.createElement(StyledEuiFlexItem,{grow:true},external_kbnSharedDeps_React_default.a.createElement(EventDetails,{browserFields:browserFields,data:detailsData,id:event.eventId,isAlert:isAlert,onViewSelected:setView,timelineTabType:timelineTabType,timelineId:timelineId,view:view})))});ExpandableEvent.displayName="ExpandableEvent";var external_kbnSharedDeps_Rxjs_=__webpack_require__(15);var kibana=__webpack_require__(104);var search_strategy=__webpack_require__(120);var public_=__webpack_require__(77);const useTimelineEventsDetails=({docValueFields:docValueFields,indexName:indexName,eventId:eventId,skip:skip})=>{const{data:data,notifications:notifications}=Object(kibana["h"])().services;const refetch=Object(external_kbnSharedDeps_React_["useRef"])(external_kbnSharedDeps_LodashFp_["noop"]);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);const searchSubscription$=Object(external_kbnSharedDeps_React_["useRef"])(new external_kbnSharedDeps_Rxjs_["Subscription"]);const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[timelineDetailsRequest,setTimelineDetailsRequest]=Object(external_kbnSharedDeps_React_["useState"])(null);const[timelineDetailsResponse,setTimelineDetailsResponse]=Object(external_kbnSharedDeps_React_["useState"])(null);const timelineDetailsSearch=Object(external_kbnSharedDeps_React_["useCallback"])(request=>{if(request==null||skip||Object(external_kbnSharedDeps_LodashFp_["isEmpty"])(request.eventId)){return}const asyncSearch=async()=>{abortCtrl.current=new AbortController;setLoading(true);searchSubscription$.current=data.search.search(request,{strategy:"securitySolutionTimelineSearchStrategy",abortSignal:abortCtrl.current.signal}).subscribe({next:response=>{if(Object(public_["isCompleteResponse"])(response)){setLoading(false);setTimelineDetailsResponse(response.data||[]);searchSubscription$.current.unsubscribe()}else if(Object(public_["isErrorResponse"])(response)){setLoading(false);notifications.toasts.addWarning("An error has occurred");searchSubscription$.current.unsubscribe()}},error:msg=>{setLoading(false);notifications.toasts.addDanger({title:"Failed to run search",text:msg.message});searchSubscription$.current.unsubscribe()}})};searchSubscription$.current.unsubscribe();abortCtrl.current.abort();asyncSearch();refetch.current=asyncSearch},[data.search,notifications.toasts,skip]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setTimelineDetailsRequest(prevRequest=>{const myRequest={...prevRequest!==null&&prevRequest!==void 0?prevRequest:{},docValueFields:docValueFields,indexName:indexName,eventId:eventId,factoryQueryType:search_strategy["TimelineEventsQueries"].details};if(!fast_deep_equal_default()(prevRequest,myRequest)){return myRequest}return prevRequest})},[docValueFields,eventId,indexName]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{timelineDetailsSearch(timelineDetailsRequest);return()=>{searchSubscription$.current.unsubscribe();abortCtrl.current.abort()}},[timelineDetailsRequest,timelineDetailsSearch]);return[loading,timelineDetailsResponse]};const StyledEuiFlyoutBody=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"]).withConfig({displayName:"StyledEuiFlyoutBody",componentId:"j5hzyj-0"})([".euiFlyoutBody__overflow{display:flex;flex:1;overflow:hidden;.euiFlyoutBody__overflowContent{flex:1;overflow:hidden;padding:",";}}"],({theme:theme})=>`${theme.eui.paddingSizes.xs} ${theme.eui.paddingSizes.m} 64px`);const EventDetailsPanelComponent=({browserFields:browserFields,docValueFields:docValueFields,expandedEvent:expandedEvent,handleOnEventClosed:handleOnEventClosed,isFlyoutView:isFlyoutView,tabType:tabType,timelineId:timelineId})=>{var _expandedEvent$indexN,_expandedEvent$eventI;const[loading,detailsData]=useTimelineEventsDetails({docValueFields:docValueFields,indexName:(_expandedEvent$indexN=expandedEvent.indexName)!==null&&_expandedEvent$indexN!==void 0?_expandedEvent$indexN:"",eventId:(_expandedEvent$eventI=expandedEvent.eventId)!==null&&_expandedEvent$eventI!==void 0?_expandedEvent$eventI:"",skip:!expandedEvent.eventId});const isAlert=Object(external_kbnSharedDeps_LodashFp_["some"])({category:"signal",field:"signal.rule.id"},detailsData);if(!(expandedEvent!==null&&expandedEvent!==void 0&&expandedEvent.eventId)){return null}return isFlyoutView?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(ExpandableEventTitle,{isAlert:isAlert,loading:loading})),external_kbnSharedDeps_React_default.a.createElement(StyledEuiFlyoutBody,null,external_kbnSharedDeps_React_default.a.createElement(ExpandableEvent,{browserFields:browserFields,detailsData:detailsData,event:expandedEvent,isAlert:isAlert,loading:loading,timelineId:timelineId,timelineTabType:"flyout"}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ExpandableEventTitle,{isAlert:isAlert,loading:loading,handleOnEventClosed:handleOnEventClosed}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(ExpandableEvent,{browserFields:browserFields,detailsData:detailsData,event:expandedEvent,isAlert:isAlert,loading:loading,timelineId:timelineId,timelineTabType:tabType}))};const EventDetailsPanel=external_kbnSharedDeps_React_default.a.memo(EventDetailsPanelComponent,(prevProps,nextProps)=>fast_deep_equal_default()(prevProps.browserFields,nextProps.browserFields)&&fast_deep_equal_default()(prevProps.docValueFields,nextProps.docValueFields)&&fast_deep_equal_default()(prevProps.expandedEvent,nextProps.expandedEvent)&&prevProps.timelineId===nextProps.timelineId);var sourcerer=__webpack_require__(137);var links=__webpack_require__(113);var use_global_time=__webpack_require__(159);var containers_sourcerer=__webpack_require__(124);var host_overview=__webpack_require__(755);var actions=__webpack_require__(151);var anomaly_table_provider=__webpack_require__(708);var host_to_criteria=__webpack_require__(710);var score_interval_to_datetime=__webpack_require__(247);var details=__webpack_require__(767);const StyledTitle=external_kbnSharedDeps_StyledComponents_default.a.h4.withConfig({displayName:"StyledTitle",componentId:"sc-18s5s5o-0"})(["word-break:break-all;word-wrap:break-word;white-space:pre-wrap;"]);const ExpandableHostDetailsTitle=({hostName:hostName})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(StyledTitle,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.sidePanel.hostDetails.title",{defaultMessage:"Host details"}),`: ${hostName}`));const ExpandableHostDetailsPageLink=({hostName:hostName})=>external_kbnSharedDeps_React_default.a.createElement(links["d"],{hostName:hostName,isButton:true},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.sidePanel.hostDetails.hostDetailsPageLink",{defaultMessage:"View details page"}));const ExpandableHostDetails=({contextID:contextID,hostName:hostName})=>{const{to:to,from:from,isInitializing:isInitializing}=Object(use_global_time["a"])();const{docValueFields:docValueFields}=Object(containers_sourcerer["b"])();const allExistingIndexNamesSelector=Object(external_kbnSharedDeps_React_["useMemo"])(()=>sourcerer["d"].getAllExistingIndexNamesSelector(),[]);const allPatterns=Object(use_selector["a"])(allExistingIndexNamesSelector);return external_kbnSharedDeps_React_default.a.createElement(details["a"],{indexNames:allPatterns,sourceId:"default",hostName:hostName,skip:isInitializing,startDate:from,endDate:to},({hostOverview:hostOverview,loading:loading,id:id})=>external_kbnSharedDeps_React_default.a.createElement(anomaly_table_provider["a"],{criteriaFields:Object(host_to_criteria["a"])(hostOverview),startDate:from,endDate:to,skip:isInitializing},({isLoadingAnomaliesData:isLoadingAnomaliesData,anomaliesData:anomaliesData})=>external_kbnSharedDeps_React_default.a.createElement(host_overview["a"],{contextID:contextID,docValueFields:docValueFields,id:id,isInDetailsSidePanel:true,data:hostOverview,anomaliesData:anomaliesData,isLoadingAnomaliesData:isLoadingAnomaliesData,indexNames:allPatterns,loading:loading,startDate:from,endDate:to,narrowDateRange:(score,interval)=>{const fromTo=Object(score_interval_to_datetime["a"])(score,interval);Object(actions["setAbsoluteRangeDatePicker"])({id:"global",from:fromTo.from,to:fromTo.to})}})))};const host_details_StyledEuiFlyoutBody=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"]).withConfig({displayName:"StyledEuiFlyoutBody",componentId:"hctd1a-0"})([".euiFlyoutBody__overflow{display:flex;flex:1;overflow:hidden;.euiFlyoutBody__overflowContent{flex:1;overflow-x:hidden;overflow-y:scroll;margin-bottom:64px;padding:",";}}"],({theme:theme})=>`${theme.eui.paddingSizes.xs} ${theme.eui.paddingSizes.m} 0px`);const host_details_StyledEuiFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"StyledEuiFlexGroup",componentId:"hctd1a-1"})(["flex:1 0 auto;"]);const StyledEuiFlexButtonWrapper=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"StyledEuiFlexButtonWrapper",componentId:"hctd1a-2"})(["align-self:flex-start;flex:1 0 auto;"]);const StyledPanelContent=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"StyledPanelContent",componentId:"hctd1a-3"})(["display:block;height:100%;overflow-y:scroll;overflow-x:hidden;"]);const HostDetailsPanel=external_kbnSharedDeps_React_default.a.memo(({contextID:contextID,expandedHost:expandedHost,handleOnHostClosed:handleOnHostClosed,isFlyoutView:isFlyoutView})=>{const{hostName:hostName}=expandedHost;if(!hostName){return null}return isFlyoutView?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(ExpandableHostDetailsTitle,{hostName:hostName})),external_kbnSharedDeps_React_default.a.createElement(host_details_StyledEuiFlyoutBody,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(ExpandableHostDetailsPageLink,{hostName:hostName}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(ExpandableHostDetails,{contextID:contextID,hostName:hostName}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(host_details_StyledEuiFlexGroup,{justifyContent:"spaceBetween",wrap:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ExpandableHostDetailsTitle,{hostName:hostName})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"cross","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.sidePanel.hostDetails.close",{defaultMessage:"close"}),onClick:handleOnHostClosed}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(StyledEuiFlexButtonWrapper,{grow:false},external_kbnSharedDeps_React_default.a.createElement(ExpandableHostDetailsPageLink,{hostName:hostName})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(StyledPanelContent,null,external_kbnSharedDeps_React_default.a.createElement(ExpandableHostDetails,{contextID:contextID,hostName:hostName})))});var components_details=__webpack_require__(711);var network_to_criteria=__webpack_require__(712);var keury=__webpack_require__(158);var store=__webpack_require__(122);var overview_empty=__webpack_require__(211);var containers_details=__webpack_require__(782);var network_store=__webpack_require__(130);var use_anomalies_table_data=__webpack_require__(324);const expandable_network_StyledTitle=external_kbnSharedDeps_StyledComponents_default.a.h4.withConfig({displayName:"StyledTitle",componentId:"rlvmr5-0"})(["word-break:break-all;word-wrap:break-word;white-space:pre-wrap;"]);const ExpandableNetworkDetailsTitle=({ip:ip})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(expandable_network_StyledTitle,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.sidePanel.networkDetails.title",{defaultMessage:"Network details"}),`: ${ip}`));const ExpandableNetworkDetailsPageLink=({expandedNetwork:{ip:ip,flowTarget:flowTarget}})=>external_kbnSharedDeps_React_default.a.createElement(links["h"],{ip:ip,flowTarget:flowTarget,isButton:true},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.sidePanel.networkDetails.networkDetailsPageLink",{defaultMessage:"View details page"}));const ExpandableNetworkDetails=({contextID:contextID,expandedNetwork:expandedNetwork})=>{const{ip:ip,flowTarget:flowTarget}=expandedNetwork;const dispatch=Object(lib["useDispatch"])();const{to:to,from:from,isInitializing:isInitializing}=Object(use_global_time["a"])();const getGlobalQuerySelector=Object(external_kbnSharedDeps_React_["useMemo"])(()=>store["inputsSelectors"].globalQuerySelector(),[]);const getGlobalFiltersQuerySelector=Object(external_kbnSharedDeps_React_["useMemo"])(()=>store["inputsSelectors"].globalFiltersQuerySelector(),[]);const query=Object(use_selector["a"])(getGlobalQuerySelector);const filters=Object(use_selector["a"])(getGlobalFiltersQuerySelector);const type=network_store["c"].NetworkType.details;const narrowDateRange=Object(external_kbnSharedDeps_React_["useCallback"])((score,interval)=>{const fromTo=Object(score_interval_to_datetime["a"])(score,interval);dispatch(Object(actions["setAbsoluteRangeDatePicker"])({id:"global",from:fromTo.from,to:fromTo.to}))},[dispatch]);const{services:{uiSettings:uiSettings}}=Object(kibana["h"])();const{docValueFields:docValueFields,indicesExist:indicesExist,indexPattern:indexPattern,selectedPatterns:selectedPatterns}=Object(containers_sourcerer["b"])();const filterQuery=Object(keury["b"])({config:public_["esQuery"].getEsQueryConfig(uiSettings),indexPattern:indexPattern,queries:[query],filters:filters});const[loading,{id:id,networkDetails:networkDetails}]=Object(containers_details["a"])({docValueFields:docValueFields,skip:isInitializing,filterQuery:filterQuery,indexNames:selectedPatterns,ip:ip});const[isLoadingAnomaliesData,anomaliesData]=Object(use_anomalies_table_data["a"])({criteriaFields:Object(network_to_criteria["a"])(ip,flowTarget),startDate:from,endDate:to,skip:isInitializing});return indicesExist?external_kbnSharedDeps_React_default.a.createElement(components_details["a"],{contextID:contextID,id:id,ip:ip,data:networkDetails,anomaliesData:anomaliesData,loading:loading,isInDetailsSidePanel:true,isLoadingAnomaliesData:isLoadingAnomaliesData,type:type,flowTarget:flowTarget,startDate:from,endDate:to,narrowDateRange:narrowDateRange}):external_kbnSharedDeps_React_default.a.createElement(overview_empty["a"],null)};const network_details_StyledEuiFlyoutBody=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"]).withConfig({displayName:"StyledEuiFlyoutBody",componentId:"uvw88-0"})([".euiFlyoutBody__overflow{display:flex;flex:1;overflow-x:hidden;overflow-y:scroll;.euiFlyoutBody__overflowContent{flex:1;overflow-x:hidden;overflow-y:scroll;padding:",";}}"],({theme:theme})=>`${theme.eui.paddingSizes.xs} ${theme.eui.paddingSizes.m} 64px`);const network_details_StyledEuiFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"StyledEuiFlexGroup",componentId:"uvw88-1"})(["flex:1 0 auto;"]);const network_details_StyledEuiFlexButtonWrapper=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"StyledEuiFlexButtonWrapper",componentId:"uvw88-2"})(["align-self:flex-start;flex:1 0 auto;"]);const network_details_StyledPanelContent=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"StyledPanelContent",componentId:"uvw88-3"})(["display:block;height:100%;overflow-y:scroll;overflow-x:hidden;"]);const NetworkDetailsPanel=external_kbnSharedDeps_React_default.a.memo(({contextID:contextID,expandedNetwork:expandedNetwork,handleOnNetworkClosed:handleOnNetworkClosed,isFlyoutView:isFlyoutView})=>{const{ip:ip}=expandedNetwork;return isFlyoutView?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(ExpandableNetworkDetailsTitle,{ip:ip})),external_kbnSharedDeps_React_default.a.createElement(network_details_StyledEuiFlyoutBody,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(ExpandableNetworkDetailsPageLink,{expandedNetwork:expandedNetwork}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(ExpandableNetworkDetails,{contextID:contextID,expandedNetwork:expandedNetwork}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(network_details_StyledEuiFlexGroup,{justifyContent:"spaceBetween",wrap:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ExpandableNetworkDetailsTitle,{ip:ip})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"cross","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.timeline.sidePanel.networkDetails.close",{defaultMessage:"close"}),onClick:handleOnNetworkClosed}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(network_details_StyledEuiFlexButtonWrapper,{grow:false},external_kbnSharedDeps_React_default.a.createElement(ExpandableNetworkDetailsPageLink,{expandedNetwork:expandedNetwork})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(network_details_StyledPanelContent,null,external_kbnSharedDeps_React_default.a.createElement(ExpandableNetworkDetails,{contextID:contextID,expandedNetwork:expandedNetwork})))});const StyledEuiFlyout=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyout"]).withConfig({displayName:"StyledEuiFlyout",componentId:"sc-1p9fsix-0"})(["z-index:",";"],({theme:theme})=>theme.eui.euiZLevel7);const DetailsPanel=external_kbnSharedDeps_React_default.a.memo(({browserFields:browserFields,docValueFields:docValueFields,handleOnPanelClosed:handleOnPanelClosed,isFlyoutView:isFlyoutView,tabType:tabType,timelineId:timelineId})=>{var _currentTabDetail$par,_currentTabDetail$par2,_currentTabDetail$par3;const dispatch=Object(lib["useDispatch"])();const getTimeline=Object(external_kbnSharedDeps_React_["useMemo"])(()=>timeline["b"].getTimelineByIdSelector(),[]);const expandedDetail=Object(use_selector["a"])(state=>{var _getTimeline;return((_getTimeline=getTimeline(state,timelineId))!==null&&_getTimeline!==void 0?_getTimeline:defaults["a"]).expandedDetail});const defaultOnPanelClose=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{dispatch(timeline["a"].toggleDetailPanel({timelineId:timelineId}))},[dispatch,timelineId]);const activeTab=tabType!==null&&tabType!==void 0?tabType:types_timeline["h"].query;const closePanel=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(handleOnPanelClosed)handleOnPanelClosed();else defaultOnPanelClose()},[defaultOnPanelClose,handleOnPanelClosed]);if(!expandedDetail)return null;const currentTabDetail=expandedDetail[activeTab];if(!(currentTabDetail!==null&&currentTabDetail!==void 0&&currentTabDetail.panelView))return null;let visiblePanel=null;let panelSize="s";const contextID=`${timelineId}-${activeTab}`;if((currentTabDetail===null||currentTabDetail===void 0?void 0:currentTabDetail.panelView)==="eventDetail"&&currentTabDetail!==null&&currentTabDetail!==void 0&&(_currentTabDetail$par=currentTabDetail.params)!==null&&_currentTabDetail$par!==void 0&&_currentTabDetail$par.eventId){panelSize="m";visiblePanel=external_kbnSharedDeps_React_default.a.createElement(EventDetailsPanel,{browserFields:browserFields,docValueFields:docValueFields,expandedEvent:currentTabDetail===null||currentTabDetail===void 0?void 0:currentTabDetail.params,handleOnEventClosed:closePanel,isFlyoutView:isFlyoutView,tabType:activeTab,timelineId:timelineId})}if((currentTabDetail===null||currentTabDetail===void 0?void 0:currentTabDetail.panelView)==="hostDetail"&&currentTabDetail!==null&&currentTabDetail!==void 0&&(_currentTabDetail$par2=currentTabDetail.params)!==null&&_currentTabDetail$par2!==void 0&&_currentTabDetail$par2.hostName){visiblePanel=external_kbnSharedDeps_React_default.a.createElement(HostDetailsPanel,{contextID:contextID,expandedHost:currentTabDetail===null||currentTabDetail===void 0?void 0:currentTabDetail.params,handleOnHostClosed:closePanel,isFlyoutView:isFlyoutView})}if((currentTabDetail===null||currentTabDetail===void 0?void 0:currentTabDetail.panelView)==="networkDetail"&&currentTabDetail!==null&&currentTabDetail!==void 0&&(_currentTabDetail$par3=currentTabDetail.params)!==null&&_currentTabDetail$par3!==void 0&&_currentTabDetail$par3.ip){visiblePanel=external_kbnSharedDeps_React_default.a.createElement(NetworkDetailsPanel,{contextID:contextID,expandedNetwork:currentTabDetail===null||currentTabDetail===void 0?void 0:currentTabDetail.params,handleOnNetworkClosed:closePanel,isFlyoutView:isFlyoutView})}return isFlyoutView?external_kbnSharedDeps_React_default.a.createElement(StyledEuiFlyout,{"data-test-subj":"timeline:details-panel:flyout",size:panelSize,onClose:closePanel},visiblePanel):visiblePanel});DetailsPanel.displayName="DetailsPanel"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return fetchQueryAlerts}));__webpack_require__.d(__webpack_exports__,"e",(function(){return updateAlertStatus}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getSignalIndex}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getUserPrivilege}));__webpack_require__.d(__webpack_exports__,"a",(function(){return createSignalIndex}));var _common_constants__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var _common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(104);const fetchQueryAlerts=async({query:query,signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["K"],{method:"POST",body:JSON.stringify(query),signal:signal});const updateAlertStatus=async({query:query,status:status,signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["N"],{method:"POST",body:JSON.stringify({conflicts:"proceed",status:status,...query}),signal:signal});const getSignalIndex=async({signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["G"],{method:"GET",signal:signal});const getUserPrivilege=async({signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["J"],{method:"GET",signal:signal});const createSignalIndex=async({signal:signal})=>_common_lib_kibana__WEBPACK_IMPORTED_MODULE_1__["b"].get().http.fetch(_common_constants__WEBPACK_IMPORTED_MODULE_0__["G"],{method:"POST",signal:signal})},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useSignalIndex}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _common_components_toasters__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(111);var _api__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(281);var _translations__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(569);var _common_utils_api__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(340);const useSignalIndex=()=>{const[loading,setLoading]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(true);const[signalIndex,setSignalIndex]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])({signalIndexExists:null,signalIndexName:null,signalIndexMappingOutdated:null,createDeSignalIndex:null});const[,dispatchToaster]=Object(_common_components_toasters__WEBPACK_IMPORTED_MODULE_1__["h"])();Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{let isSubscribed=true;const abortCtrl=new AbortController;const fetchData=async()=>{try{setLoading(true);const signal=await Object(_api__WEBPACK_IMPORTED_MODULE_2__["c"])({signal:abortCtrl.signal});if(isSubscribed&&signal!=null){setSignalIndex({signalIndexExists:true,signalIndexName:signal.name,signalIndexMappingOutdated:signal.index_mapping_outdated,createDeSignalIndex:createIndex})}}catch(error){if(isSubscribed){setSignalIndex({signalIndexExists:false,signalIndexName:null,signalIndexMappingOutdated:null,createDeSignalIndex:createIndex});if(Object(_common_utils_api__WEBPACK_IMPORTED_MODULE_4__["b"])(error)&&error.body.status_code!==404){Object(_common_components_toasters__WEBPACK_IMPORTED_MODULE_1__["g"])({title:_translations__WEBPACK_IMPORTED_MODULE_3__["b"],error:error,dispatchToaster:dispatchToaster})}}}if(isSubscribed){setLoading(false)}};const createIndex=async()=>{let isFetchingData=false;try{setLoading(true);await Object(_api__WEBPACK_IMPORTED_MODULE_2__["a"])({signal:abortCtrl.signal});if(isSubscribed){isFetchingData=true;fetchData()}}catch(error){if(isSubscribed){if(Object(_common_utils_api__WEBPACK_IMPORTED_MODULE_4__["b"])(error)&&error.body.status_code===409){fetchData()}else{setSignalIndex({signalIndexExists:false,signalIndexName:null,signalIndexMappingOutdated:null,createDeSignalIndex:createIndex});Object(_common_components_toasters__WEBPACK_IMPORTED_MODULE_1__["g"])({title:_translations__WEBPACK_IMPORTED_MODULE_3__["c"],error:error,dispatchToaster:dispatchToaster})}}}if(isSubscribed&&!isFetchingData){setLoading(false)}};fetchData();return()=>{isSubscribed=false;abortCtrl.abort()}},[dispatchToaster]);return{loading:loading,...signalIndex}}},,,function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;
/*!
  Copyright (c) 2017 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/(function(){"use strict";var hasOwn={}.hasOwnProperty;function classNames(){var classes=[];for(var i=0;i<arguments.length;i++){var arg=arguments[i];if(!arg)continue;var argType=typeof arg;if(argType==="string"||argType==="number"){classes.push(arg)}else if(Array.isArray(arg)&&arg.length){var inner=classNames.apply(null,arg);if(inner){classes.push(inner)}}else if(argType==="object"){for(var key in arg){if(hasOwn.call(arg,key)&&arg[key]){classes.push(key)}}}}return classes.join(" ")}if(true&&module.exports){classNames.default=classNames;module.exports=classNames}else if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return classNames}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})()},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return flattenIntoAndGroups}));__webpack_require__.d(__webpack_exports__,"a",(function(){return EMPTY_GROUP}));__webpack_require__.d(__webpack_exports__,"d",(function(){return reArrangeProviders}));__webpack_require__.d(__webpack_exports__,"b",(function(){return addContentToTimeline}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var _store_timeline_actions__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(21);const omitAnd=provider=>Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["omit"])("and",provider);const reorder=({endIndex:endIndex,group:group,startIndex:startIndex})=>{const groupClone=[...group];const[removed]=groupClone.splice(startIndex,1);groupClone.splice(endIndex,0,removed);return groupClone};const move=({destinationGroup:destinationGroup,moveProviderFromSourceIndex:moveProviderFromSourceIndex,moveProviderToDestinationIndex:moveProviderToDestinationIndex,sourceGroup:sourceGroup})=>{const sourceClone=[...sourceGroup];const destinationClone=[...destinationGroup];const[removed]=sourceClone.splice(moveProviderFromSourceIndex,1);destinationClone.splice(moveProviderToDestinationIndex,0,removed);const deDuplicatedDestinationGroup=destinationClone.filter((provider,i)=>provider.id===removed.id&&i!==moveProviderToDestinationIndex?false:true);return{updatedDestinationGroup:deDuplicatedDestinationGroup,updatedSourcererScope:sourceClone}};const isValidDestination=destination=>destination!=null;const sourceAndDestinationAreSameDroppable=({destination:destination,source:source})=>source.droppableId===destination.droppableId;const flattenIntoAndGroups=dataProviders=>dataProviders.reduce((acc,provider)=>[...acc,[omitAnd(provider),...provider.and]],[]);const reArrangeProvidersInSameGroup=({dataProviderGroups:dataProviderGroups,destination:destination,dispatch:dispatch,source:source,timelineId:timelineId})=>{const groupIndex=getGroupIndexFromDroppableId(source.droppableId);if(indexIsValid({index:groupIndex,dataProviderGroups:dataProviderGroups})){const reorderedGroup=reorder({group:dataProviderGroups[groupIndex],startIndex:source.index,endIndex:destination.index});const updatedGroups=dataProviderGroups.reduce((acc,group,i)=>[...acc,i===groupIndex?[...reorderedGroup]:[...group]],[]);dispatch(Object(_store_timeline_actions__WEBPACK_IMPORTED_MODULE_1__["updateProviders"])({id:timelineId,providers:unFlattenGroups(updatedGroups.filter(g=>g.length))}))}};const getGroupIndexFromDroppableId=droppableId=>Number(droppableId.substring(droppableId.lastIndexOf(".")+1));const indexIsValid=({index:index,dataProviderGroups:dataProviderGroups})=>index>=0&&index<dataProviderGroups.length;const convertDataProviderAnd=dataProvidersAnd=>({...dataProvidersAnd,and:[]});const unFlattenGroups=groups=>groups.reduce((acc,group)=>[...acc,{...group[0],and:group.slice(1)}],[]);const moveProvidersBetweenGroups=({dataProviderGroups:dataProviderGroups,destination:destination,dispatch:dispatch,source:source,timelineId:timelineId})=>{const sourceGroupIndex=getGroupIndexFromDroppableId(source.droppableId);const destinationGroupIndex=getGroupIndexFromDroppableId(destination.droppableId);if(indexIsValid({index:sourceGroupIndex,dataProviderGroups:dataProviderGroups})&&indexIsValid({index:destinationGroupIndex,dataProviderGroups:dataProviderGroups})){const sourceGroup=dataProviderGroups[sourceGroupIndex];const destinationGroup=dataProviderGroups[destinationGroupIndex];const moveProviderFromSourceIndex=source.index;const moveProviderToDestinationIndex=destination.index;const{updatedDestinationGroup:updatedDestinationGroup,updatedSourcererScope:updatedSourcererScope}=move({destinationGroup:destinationGroup,moveProviderFromSourceIndex:moveProviderFromSourceIndex,moveProviderToDestinationIndex:moveProviderToDestinationIndex,sourceGroup:sourceGroup});const updatedGroups=dataProviderGroups.reduce((acc,group,i)=>[...acc,i===sourceGroupIndex?[...updatedSourcererScope]:i===destinationGroupIndex?[...updatedDestinationGroup]:[...group]],[]);dispatch(Object(_store_timeline_actions__WEBPACK_IMPORTED_MODULE_1__["updateProviders"])({id:timelineId,providers:unFlattenGroups(updatedGroups.filter(g=>g.length))}))}};const addProviderToEmptyTimeline=({dispatch:dispatch,onAddedToTimeline:onAddedToTimeline,providerToAdd:providerToAdd,timelineId:timelineId})=>{dispatch(Object(_store_timeline_actions__WEBPACK_IMPORTED_MODULE_1__["updateProviders"])({id:timelineId,providers:[providerToAdd]}));onAddedToTimeline(providerToAdd.name)};const EMPTY_GROUP=[[]];const reArrangeProviders=({dataProviders:dataProviders,destination:destination,dispatch:dispatch,source:source,timelineId:timelineId})=>{if(!isValidDestination(destination)){return}const dataProviderGroups=[...flattenIntoAndGroups(dataProviders),...EMPTY_GROUP];if(sourceAndDestinationAreSameDroppable({source:source,destination:destination})){reArrangeProvidersInSameGroup({dataProviderGroups:dataProviderGroups,destination:destination,dispatch:dispatch,source:source,timelineId:timelineId})}else{moveProvidersBetweenGroups({dataProviderGroups:dataProviderGroups,destination:destination,dispatch:dispatch,source:source,timelineId:timelineId})}};const addProviderToGroup=({dataProviders:dataProviders,destination:destination,dispatch:dispatch,onAddedToTimeline:onAddedToTimeline,providerToAdd:providerToAdd,timelineId:timelineId})=>{const dataProviderGroups=[...flattenIntoAndGroups(dataProviders),...EMPTY_GROUP];if(!isValidDestination(destination)){return}const destinationGroupIndex=getGroupIndexFromDroppableId(destination.droppableId);if(indexIsValid({index:destinationGroupIndex,dataProviderGroups:dataProviderGroups})){const destinationGroup=dataProviderGroups[destinationGroupIndex];const destinationClone=[...destinationGroup];destinationClone.splice(destination.index,0,omitAnd(providerToAdd));const deDuplicatedGroup=destinationClone.filter((provider,i)=>provider.id===providerToAdd.id&&i!==destination.index?false:true);const updatedGroups=dataProviderGroups.reduce((acc,group,i)=>[...acc,i===destinationGroupIndex?[...deDuplicatedGroup]:[...group]],[]);dispatch(Object(_store_timeline_actions__WEBPACK_IMPORTED_MODULE_1__["updateProviders"])({id:timelineId,providers:unFlattenGroups(updatedGroups.filter(g=>g.length))}));onAddedToTimeline(providerToAdd.name)}};const addContentToTimeline=({dataProviders:dataProviders,destination:destination,dispatch:dispatch,onAddedToTimeline:onAddedToTimeline,providerToAdd:providerToAdd,timelineId:timelineId})=>{if(dataProviders.length===0){addProviderToEmptyTimeline({dispatch:dispatch,onAddedToTimeline:onAddedToTimeline,providerToAdd:providerToAdd,timelineId:timelineId})}else{addProviderToGroup({dataProviders:dataProviders,destination:destination,dispatch:dispatch,onAddedToTimeline:onAddedToTimeline,providerToAdd:providerToAdd,timelineId:timelineId})}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(448);var _rgb2=_interopRequireDefault(_rgb);var _parseToRgb=__webpack_require__(227);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgba(firstValue,secondValue,thirdValue,fourthValue){if(typeof firstValue==="string"&&typeof secondValue==="number"){var rgbValue=(0,_parseToRgb2.default)(firstValue);return"rgba("+rgbValue.red+","+rgbValue.green+","+rgbValue.blue+","+secondValue+")"}else if(typeof firstValue==="number"&&typeof secondValue==="number"&&typeof thirdValue==="number"&&typeof fourthValue==="number"){return fourthValue>=1?(0,_rgb2.default)(firstValue,secondValue,thirdValue):"rgba("+firstValue+","+secondValue+","+thirdValue+","+fourthValue+")"}else if(typeof firstValue==="object"&&secondValue===undefined&&thirdValue===undefined&&fourthValue===undefined){return firstValue.alpha>=1?(0,_rgb2.default)(firstValue.red,firstValue.green,firstValue.blue):"rgba("+firstValue.red+","+firstValue.green+","+firstValue.blue+","+firstValue.alpha+")"}throw new Error("Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).")}exports.default=rgba;module.exports=exports["default"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HOVER_ACTIONS_ALWAYS_SHOW_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"b",(function(){return WithHoverActions}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(116);const HOVER_ACTIONS_ALWAYS_SHOW_CLASS_NAME="hover-actions-always-show";const HOVER_INTENT_DELAY=100;const WithHoverActionsPopover=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiPopover"]).withConfig({displayName:"WithHoverActionsPopover",componentId:"sc-16d4hj4-0"})([".euiPopover__anchor{width:100%;}"]);const WithHoverActions=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({alwaysShow:alwaysShow=false,closePopOverTrigger:closePopOverTrigger,hoverContent:hoverContent,onCloseRequested:onCloseRequested,render:render})=>{const[isOpen,setIsOpen]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(hoverContent!=null&&alwaysShow);const[showHoverContent,setShowHoverContent]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(false);const[,setHoverTimeout]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(undefined);const tryClosePopover=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setHoverTimeout(prevHoverTimeout=>{clearTimeout(prevHoverTimeout);return undefined});setShowHoverContent(false);if(onCloseRequested!=null){onCloseRequested()}},[onCloseRequested]);const onMouseEnter=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setHoverTimeout(Number(setTimeout(()=>{if(!document.body.classList.contains(_drag_and_drop_helpers__WEBPACK_IMPORTED_MODULE_3__["c"])){setShowHoverContent(true)}},HOVER_INTENT_DELAY)))},[setHoverTimeout,setShowHoverContent]);const onMouseLeave=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{if(!alwaysShow){tryClosePopover()}},[alwaysShow,tryClosePopover]);const onKeyDown=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(keyboardEvent=>{if(isOpen&&keyboardEvent.key==="Escape"){onMouseLeave()}},[isOpen,onMouseLeave]);const content=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{"data-test-subj":"withHoverActionsButton",onMouseEnter:onMouseEnter},render(showHoverContent)),[onMouseEnter,render,showHoverContent]);Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{setIsOpen(hoverContent!=null&&(showHoverContent||alwaysShow))},[hoverContent,showHoverContent,alwaysShow]);Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{setShowHoverContent(false)},[closePopOverTrigger]);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{className:alwaysShow?HOVER_ACTIONS_ALWAYS_SHOW_CLASS_NAME:"",onMouseLeave:onMouseLeave},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(WithHoverActionsPopover,{anchorPosition:"downCenter",button:content,closePopover:tryClosePopover,hasArrow:false,isOpen:isOpen,ownFocus:false,panelPaddingSize:"none",panelClassName:"withHoverActions__popover",repositionOnScroll:true},isOpen?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{onKeyDown:onKeyDown},hoverContent):null))});WithHoverActions.displayName="WithHoverActions"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AddToFavoritesButton}));__webpack_require__.d(__webpack_exports__,"c",(function(){return NewTimeline}));__webpack_require__.d(__webpack_exports__,"b",(function(){return NOTES_BUTTON_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"d",(function(){return NotesButton}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var react_redux__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_3__);var _common_types_timeline__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(106);var _timelines_store_timeline__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(108);var _common_hooks_use_selector__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(109);var _translations__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(241);var _use_create_timeline__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__(451);var _store_timeline_defaults__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__(118);const NotesCountBadge=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiBadge"]).withConfig({displayName:"NotesCountBadge",componentId:"mazy8j-0"})(["margin-left:5px;"]);NotesCountBadge.displayName="NotesCountBadge";const AddToFavoritesButtonComponent=({timelineId:timelineId})=>{const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_3__["useDispatch"])();const getTimeline=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>_timelines_store_timeline__WEBPACK_IMPORTED_MODULE_5__["b"].getTimelineByIdSelector(),[]);const isFavorite=Object(_common_hooks_use_selector__WEBPACK_IMPORTED_MODULE_6__["b"])(state=>{var _getTimeline;return((_getTimeline=getTimeline(state,timelineId))!==null&&_getTimeline!==void 0?_getTimeline:_store_timeline_defaults__WEBPACK_IMPORTED_MODULE_9__["a"]).isFavorite});const handleClick=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>dispatch(_timelines_store_timeline__WEBPACK_IMPORTED_MODULE_5__["a"].updateIsFavorite({id:timelineId,isFavorite:!isFavorite})),[dispatch,timelineId,isFavorite]);return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiButton"],{isSelected:isFavorite,fill:isFavorite,iconType:isFavorite?"starFilled":"starEmpty",onClick:handleClick,"data-test-subj":`timeline-favorite-${isFavorite?"filled":"empty"}-star`},isFavorite?_translations__WEBPACK_IMPORTED_MODULE_7__["j"]:_translations__WEBPACK_IMPORTED_MODULE_7__["b"])};AddToFavoritesButtonComponent.displayName="AddToFavoritesButtonComponent";const AddToFavoritesButton=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(AddToFavoritesButtonComponent);const NewTimeline=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({closeGearMenu:closeGearMenu,outline:outline=false,timelineId:timelineId,title:title=_translations__WEBPACK_IMPORTED_MODULE_7__["h"]})=>{const{getButton:getButton}=Object(_use_create_timeline__WEBPACK_IMPORTED_MODULE_8__["b"])({timelineId:timelineId,timelineType:_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["i"].default,closeGearMenu:closeGearMenu});const button=getButton({outline:outline,title:title});return button});NewTimeline.displayName="NewTimeline";const NOTES_BUTTON_CLASS_NAME="notes-button";const SmallNotesButton=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({ariaLabel:ariaLabel=_translations__WEBPACK_IMPORTED_MODULE_7__["i"],toggleShowNotes:toggleShowNotes,timelineType:timelineType})=>{const isTemplate=timelineType===_common_types_timeline__WEBPACK_IMPORTED_MODULE_4__["i"].template;return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiButtonIcon"],{"aria-label":ariaLabel,className:NOTES_BUTTON_CLASS_NAME,"data-test-subj":"timeline-notes-button-small",iconType:"editorComment",onClick:toggleShowNotes,isDisabled:isTemplate})});SmallNotesButton.displayName="SmallNotesButton";const NotesButton=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(({ariaLabel:ariaLabel,showNotes:showNotes,timelineType:timelineType,toggleShowNotes:toggleShowNotes,toolTip:toolTip})=>showNotes?react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(SmallNotesButton,{ariaLabel:ariaLabel,toggleShowNotes:toggleShowNotes,timelineType:timelineType}):react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiToolTip"],{content:toolTip||"","data-test-subj":"timeline-notes-tool-tip"},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(SmallNotesButton,{ariaLabel:ariaLabel,toggleShowNotes:toggleShowNotes,timelineType:timelineType})));NotesButton.displayName="NotesButton"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"MatrixHistogramQuery",(function(){return MatrixHistogramQuery}));__webpack_require__.d(__webpack_exports__,"MatrixHistogramType",(function(){return MatrixHistogramType}));var _alerts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(629);var _alerts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_alerts__WEBPACK_IMPORTED_MODULE_0__);if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["FlowTarget"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["HostsKpiQueries"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["HostsQueries"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["LastEventIndexKey"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkDnsFields"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkHttpFields"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkKpiQueries"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkQueries"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkTlsFields"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["NetworkUsersFields"]}));if(__webpack_require__.o(_alerts__WEBPACK_IMPORTED_MODULE_0__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _alerts__WEBPACK_IMPORTED_MODULE_0__["TimelineEventsQueries"]}));var _anomalies__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(630);var _anomalies__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_anomalies__WEBPACK_IMPORTED_MODULE_1__);if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["FlowTarget"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["HostsKpiQueries"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["HostsQueries"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["LastEventIndexKey"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkDnsFields"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkHttpFields"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkKpiQueries"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkQueries"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkTlsFields"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["NetworkUsersFields"]}));if(__webpack_require__.o(_anomalies__WEBPACK_IMPORTED_MODULE_1__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _anomalies__WEBPACK_IMPORTED_MODULE_1__["TimelineEventsQueries"]}));var _authentications__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(631);var _authentications__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_authentications__WEBPACK_IMPORTED_MODULE_2__);if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["FlowTarget"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["HostsKpiQueries"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["HostsQueries"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["LastEventIndexKey"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkDnsFields"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkHttpFields"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkKpiQueries"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkQueries"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkTlsFields"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["NetworkUsersFields"]}));if(__webpack_require__.o(_authentications__WEBPACK_IMPORTED_MODULE_2__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _authentications__WEBPACK_IMPORTED_MODULE_2__["TimelineEventsQueries"]}));var _common__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(632);var _common__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_common__WEBPACK_IMPORTED_MODULE_3__);if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["FlowTarget"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["HostsKpiQueries"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["HostsQueries"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["LastEventIndexKey"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkDnsFields"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkHttpFields"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkKpiQueries"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkQueries"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkTlsFields"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["NetworkUsersFields"]}));if(__webpack_require__.o(_common__WEBPACK_IMPORTED_MODULE_3__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _common__WEBPACK_IMPORTED_MODULE_3__["TimelineEventsQueries"]}));var _dns__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(633);var _dns__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(_dns__WEBPACK_IMPORTED_MODULE_4__);if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["FlowTarget"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["HostsKpiQueries"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["HostsQueries"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["LastEventIndexKey"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkDnsFields"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkHttpFields"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkKpiQueries"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkQueries"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkTlsFields"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["NetworkUsersFields"]}));if(__webpack_require__.o(_dns__WEBPACK_IMPORTED_MODULE_4__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _dns__WEBPACK_IMPORTED_MODULE_4__["TimelineEventsQueries"]}));var _events__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(634);var _events__WEBPACK_IMPORTED_MODULE_5___default=__webpack_require__.n(_events__WEBPACK_IMPORTED_MODULE_5__);if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["FlowTarget"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["HostsKpiQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["HostsQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["LastEventIndexKey"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkDnsFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkHttpFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkKpiQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkTlsFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["NetworkUsersFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_5__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_5__["TimelineEventsQueries"]}));const MatrixHistogramQuery="matrixHistogram";let MatrixHistogramType;(function(MatrixHistogramType){MatrixHistogramType["authentications"]="authentications";MatrixHistogramType["anomalies"]="anomalies";MatrixHistogramType["events"]="events";MatrixHistogramType["alerts"]="alerts";MatrixHistogramType["dns"]="dns"})(MatrixHistogramType||(MatrixHistogramType={}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useRouteSpy}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _helpers__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(589);const useRouteSpy=()=>Object(react__WEBPACK_IMPORTED_MODULE_0__["useContext"])(_helpers__WEBPACK_IMPORTED_MODULE_1__["a"])},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return RowRendererContainer}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _styles__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(140);const RowRendererContainer=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(({children:children})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_styles__WEBPACK_IMPORTED_MODULE_1__["w"],{className:"siemEventsTable__trSupplement--summary"},children));RowRendererContainer.displayName="RowRendererContainer"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return SOURCE_IP_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DESTINATION_IP_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"b",(function(){return Ip}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _timelines_components_timeline_body_renderers_formatted_field__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(402);const SOURCE_IP_FIELD_NAME="source.ip";const DESTINATION_IP_FIELD_NAME="destination.ip";const IP_FIELD_TYPE="ip";const Ip=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(({contextId:contextId,eventId:eventId,fieldName:fieldName,value:value})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_timelines_components_timeline_body_renderers_formatted_field__WEBPACK_IMPORTED_MODULE_1__["a"],{contextId:contextId,"data-test-subj":"formatted-ip",eventId:eventId,fieldName:fieldName,fieldType:IP_FIELD_TYPE,value:value,truncate:true}));Ip.displayName="Ip"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DESTINATION_PORT_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"d",(function(){return SOURCE_PORT_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"b",(function(){return PORT_NAMES}));__webpack_require__.d(__webpack_exports__,"c",(function(){return Port}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _common_components_draggables__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(115);var _common_components_empty_value__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(114);var _common_components_links__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(113);const CLIENT_PORT_FIELD_NAME="client.port";const DESTINATION_PORT_FIELD_NAME="destination.port";const SERVER_PORT_FIELD_NAME="server.port";const SOURCE_PORT_FIELD_NAME="source.port";const URL_PORT_FIELD_NAME="url.port";const PORT_NAMES=[CLIENT_PORT_FIELD_NAME,DESTINATION_PORT_FIELD_NAME,SERVER_PORT_FIELD_NAME,SOURCE_PORT_FIELD_NAME,URL_PORT_FIELD_NAME];const Port=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(({contextId:contextId,eventId:eventId,fieldName:fieldName,value:value})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_1__["b"],{"data-test-subj":"port",field:fieldName,id:`port-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,tooltipContent:fieldName,value:value},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_components_links__WEBPACK_IMPORTED_MODULE_3__["i"],{portOrServiceName:value||Object(_common_components_empty_value__WEBPACK_IMPORTED_MODULE_2__["e"])()})));Port.displayName="Port"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DESTINATION}));__webpack_require__.d(__webpack_exports__,"b",(function(){return FROM_ITS_ORIGINAL_PATH}));__webpack_require__.d(__webpack_exports__,"f",(function(){return SOURCE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return IN}));__webpack_require__.d(__webpack_exports__,"e",(function(){return NON_EXISTENT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return LINK_ELASTIC_ENDPOINT_SECURITY}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const TCP=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.tcp",{defaultMessage:"TCP"});const DESTINATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.destination",{defaultMessage:"Destination"});const FROM_ITS_ORIGINAL_PATH=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.file.fromOriginalPathDescription",{defaultMessage:"from its original path"});const PROTOCOL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.protocol",{defaultMessage:"Protocol"});const SOURCE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.source",{defaultMessage:"Source"});const IN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.inDescription",{defaultMessage:"in"});const NON_EXISTENT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.auditd.nonExistentDescription",{defaultMessage:"an unknown process"});const LINK_ELASTIC_ENDPOINT_SECURITY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.event.module.linkToElasticEndpointSecurityDescription",{defaultMessage:"Open in Endpoint Security"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"f",(function(){return search}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getColumnsWithTimestamp}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getExampleText}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getIconFromType}));__webpack_require__.d(__webpack_exports__,"a",(function(){return EVENT_FIELDS_TABLE_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"e",(function(){return onEventDetailsTabKeyPressed}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);var _accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(134);var _timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(192);var _translations__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(370);const search={box:{incremental:true,placeholder:_translations__WEBPACK_IMPORTED_MODULE_3__["g"],schema:true}};const getColumnHeaderFromBrowserField=({browserField:browserField,width:width=_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__["b"]})=>({category:browserField.category,columnHeaderType:"not-filtered",description:browserField.description!=null?browserField.description:undefined,example:browserField.example!=null?`${browserField.example}`:undefined,id:browserField.name||"",type:browserField.type,aggregatable:browserField.aggregatable,width:width});const getColumnsWithTimestamp=({browserFields:browserFields,category:category})=>{const emptyFields={};const timestamp=Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["get"])("base.fields.@timestamp",browserFields);const categoryFields=[...Object.values(Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["getOr"])(emptyFields,`${category}.fields`,browserFields))];return timestamp!=null&&categoryFields.length?Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["uniqBy"])("id",[getColumnHeaderFromBrowserField({browserField:timestamp,width:_timelines_components_timeline_body_constants__WEBPACK_IMPORTED_MODULE_2__["c"]}),...categoryFields.map(f=>getColumnHeaderFromBrowserField({browserField:f}))]):[]};const getExampleText=example=>!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(example)?`Example: ${example}`:"";const getIconFromType=type=>{switch(type){case"string":case"keyword":return"string";case"number":case"long":return"number";case"date":return"clock";case"ip":case"geo_point":return"globe";case"object":return"questionInCircle";case"float":return"number";default:return"questionInCircle"}};const EVENT_FIELDS_TABLE_CLASS_NAME="event-fields-table";const tableHasFocus=containerElement=>Object(_accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__["g"])(containerElement===null||containerElement===void 0?void 0:containerElement.querySelector(`.${EVENT_FIELDS_TABLE_CLASS_NAME}`));const onEventDetailsTabKeyPressed=({containerElement:containerElement,keyboardEvent:keyboardEvent,onSkipFocusBeforeEventsTable:onSkipFocusBeforeEventsTable,onSkipFocusAfterEventsTable:onSkipFocusAfterEventsTable})=>{const{shiftKey:shiftKey}=keyboardEvent;const eventFieldsTableSkipFocus=Object(_accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__["m"])({containerElement:containerElement,getFocusedCell:_accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__["j"],shiftKey:shiftKey,tableHasFocus:tableHasFocus,tableClassName:EVENT_FIELDS_TABLE_CLASS_NAME});if(eventFieldsTableSkipFocus!=="SKIP_FOCUS_NOOP"){Object(_accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__["v"])(keyboardEvent);Object(_accessibility_helpers__WEBPACK_IMPORTED_MODULE_1__["n"])({onSkipFocusBackwards:onSkipFocusBeforeEventsTable,onSkipFocusForward:onSkipFocusAfterEventsTable,skipFocus:eventFieldsTableSkipFocus})}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return CATEGORY}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"c",(function(){return FIELD}));__webpack_require__.d(__webpack_exports__,"d",(function(){return FULL_SCREEN}));__webpack_require__.d(__webpack_exports__,"e",(function(){return HIDE_COLUMN}));__webpack_require__.d(__webpack_exports__,"g",(function(){return SORT_AZ}));__webpack_require__.d(__webpack_exports__,"h",(function(){return SORT_FIELDS}));__webpack_require__.d(__webpack_exports__,"i",(function(){return SORT_ZA}));__webpack_require__.d(__webpack_exports__,"j",(function(){return TYPE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return REMOVE_COLUMN}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const CATEGORY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.categoryTooltip",{defaultMessage:"Category"});const DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.descriptionTooltip",{defaultMessage:"Description"});const FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.fieldTooltip",{defaultMessage:"Field"});const FULL_SCREEN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.fullScreenButton",{defaultMessage:"Full screen"});const HIDE_COLUMN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.hideColumnLabel",{defaultMessage:"Hide column"});const SORT_AZ=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.sortAZLabel",{defaultMessage:"Sort A-Z"});const SORT_FIELDS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.sortFieldsButton",{defaultMessage:"Sort fields"});const SORT_ZA=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.sortZALabel",{defaultMessage:"Sort Z-A"});const TYPE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.typeTooltip",{defaultMessage:"Type"});const REMOVE_COLUMN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.timeline.flyout.pane.removeColumnButtonLabel",{defaultMessage:"Remove column"})},,function(module,__webpack_exports__,__webpack_require__){"use strict";var _types__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(666);var _types__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_types__WEBPACK_IMPORTED_MODULE_0__);if(__webpack_require__.o(_types__WEBPACK_IMPORTED_MODULE_0__,"MarkdownEditor"))__webpack_require__.d(__webpack_exports__,"MarkdownEditor",(function(){return _types__WEBPACK_IMPORTED_MODULE_0__["MarkdownEditor"]}));if(__webpack_require__.o(_types__WEBPACK_IMPORTED_MODULE_0__,"MarkdownEditorForm"))__webpack_require__.d(__webpack_exports__,"MarkdownEditorForm",(function(){return _types__WEBPACK_IMPORTED_MODULE_0__["MarkdownEditorForm"]}));if(__webpack_require__.o(_types__WEBPACK_IMPORTED_MODULE_0__,"MarkdownRenderer"))__webpack_require__.d(__webpack_exports__,"MarkdownRenderer",(function(){return _types__WEBPACK_IMPORTED_MODULE_0__["MarkdownRenderer"]}));var _renderer__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(791);__webpack_require__.d(__webpack_exports__,"MarkdownRenderer",(function(){return _renderer__WEBPACK_IMPORTED_MODULE_1__["a"]}));var _editor__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(475);__webpack_require__.d(__webpack_exports__,"MarkdownEditor",(function(){return _editor__WEBPACK_IMPORTED_MODULE_2__["a"]}));var _eui_form__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(302);__webpack_require__.d(__webpack_exports__,"MarkdownEditorForm",(function(){return _eui_form__WEBPACK_IMPORTED_MODULE_3__["a"]}))},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return FieldComponent}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _helpers__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(304);const FieldComponent=({placeholder:placeholder,selectedField:selectedField,indexPattern:indexPattern,isLoading:isLoading=false,isDisabled:isDisabled=false,isClearable:isClearable=false,isRequired:isRequired=false,fieldTypeFilter:fieldTypeFilter=[],fieldInputWidth:fieldInputWidth,onChange:onChange})=>{const[touched,setIsTouched]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const{availableFields:availableFields,selectedFields:selectedFields}=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>getComboBoxFields(indexPattern,selectedField,fieldTypeFilter),[indexPattern,selectedField,fieldTypeFilter]);const{comboOptions:comboOptions,labels:labels,selectedComboOptions:selectedComboOptions}=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>getComboBoxProps({availableFields:availableFields,selectedFields:selectedFields}),[availableFields,selectedFields]);const handleValuesChange=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(newOptions=>{const newValues=newOptions.map(({label:label})=>availableFields[labels.indexOf(label)]);onChange(newValues)},[availableFields,labels,onChange]);const handleTouch=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(()=>{setIsTouched(true)},[setIsTouched]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiComboBox"],{placeholder:placeholder,options:comboOptions,selectedOptions:selectedComboOptions,onChange:handleValuesChange,isLoading:isLoading,isDisabled:isDisabled,isClearable:isClearable,isInvalid:isRequired?touched&&selectedField==null:false,onFocus:handleTouch,singleSelection:{asPlainText:true},"data-test-subj":"fieldAutocompleteComboBox",style:fieldInputWidth?{width:`${fieldInputWidth}px`}:{},fullWidth:true})};FieldComponent.displayName="Field";const getComboBoxFields=(indexPattern,selectedField,fieldTypeFilter)=>{const existingFields=getExistingFields(indexPattern);const selectedFields=getSelectedFields(selectedField);const availableFields=getAvailableFields(existingFields,selectedFields,fieldTypeFilter);return{availableFields:availableFields,selectedFields:selectedFields}};const getComboBoxProps=fields=>{const{availableFields:availableFields,selectedFields:selectedFields}=fields;return Object(_helpers__WEBPACK_IMPORTED_MODULE_2__["b"])({options:availableFields,selectedOptions:selectedFields,getLabel:field=>field.name})};const getExistingFields=indexPattern=>indexPattern!=null?indexPattern.fields:[];const getSelectedFields=selectedField=>selectedField?[selectedField]:[];const getAvailableFields=(existingFields,selectedFields,fieldTypeFilter)=>{const fieldsByName=new Map;existingFields.forEach(f=>fieldsByName.set(f.name,f));selectedFields.forEach(f=>fieldsByName.set(f.name,f));const uniqueFields=Array.from(fieldsByName.values());if(fieldTypeFilter.length>0){return uniqueFields.filter(({type:type})=>fieldTypeFilter.includes(type))}return uniqueFields}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return getOperators}));__webpack_require__.d(__webpack_exports__,"d",(function(){return paramIsValid}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getGenericComboBoxProps}));__webpack_require__.d(__webpack_exports__,"a",(function(){return filterFieldToList}));var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(43);var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_datemath__WEBPACK_IMPORTED_MODULE_0__);var _operators__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(374);var _translations__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(377);const getOperators=field=>{if(field==null){return[_operators__WEBPACK_IMPORTED_MODULE_1__["h"]]}else if(field.type==="boolean"){return[_operators__WEBPACK_IMPORTED_MODULE_1__["h"],_operators__WEBPACK_IMPORTED_MODULE_1__["f"],_operators__WEBPACK_IMPORTED_MODULE_1__["e"],_operators__WEBPACK_IMPORTED_MODULE_1__["d"]]}else if(field.type==="nested"){return[_operators__WEBPACK_IMPORTED_MODULE_1__["h"]]}else{return _operators__WEBPACK_IMPORTED_MODULE_1__["a"]}};const checkEmptyValue=(param,field,isRequired,touched)=>{if(isRequired&&touched&&(param==null||param.trim()==="")){return _translations__WEBPACK_IMPORTED_MODULE_2__["b"]}if(field==null||isRequired&&!touched||!isRequired&&(param==null||param==="")){return undefined}return null};const paramIsValid=(param,field,isRequired,touched)=>{if(field==null){return undefined}const emptyValueError=checkEmptyValue(param,field,isRequired,touched);if(emptyValueError!==null){return emptyValueError}switch(field.type){case"date":const moment=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(param!==null&&param!==void 0?param:"");const isDate=Boolean(moment&&moment.isValid());return isDate?undefined:_translations__WEBPACK_IMPORTED_MODULE_2__["a"];case"number":const isNum=param!=null&&param.trim()!==""&&!isNaN(+param);return isNum?undefined:_translations__WEBPACK_IMPORTED_MODULE_2__["d"];default:return undefined}};function getGenericComboBoxProps({options:options,selectedOptions:selectedOptions,getLabel:getLabel}){const newLabels=options.map(getLabel);const newComboOptions=newLabels.map(label=>({label:label}));const newSelectedComboOptions=selectedOptions.map(getLabel).filter(option=>newLabels.indexOf(option)!==-1).map(option=>newComboOptions[newLabels.indexOf(option)]);return{comboOptions:newComboOptions,labels:newLabels,selectedComboOptions:newSelectedComboOptions}}const filterFieldToList=(lists,field)=>{if(field!=null){const{esTypes:esTypes=[]}=field;return lists.filter(({type:type})=>esTypes.some(esType=>typeMatch(type,esType)))}else{return[]}};const typeMatch=(type,esType)=>type===esType||type==="ip_range"&&esType==="ip"||type==="date_range"&&esType==="date"||type==="double_range"&&esType==="double"||type==="float_range"&&esType==="float"||type==="integer_range"&&esType==="integer"||type==="long_range"&&esType==="long"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return transformOutput}));__webpack_require__.d(__webpack_exports__,"a",(function(){return transformInput}));var fp_ts_lib_function__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(12);var fp_ts_lib_function__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(fp_ts_lib_function__WEBPACK_IMPORTED_MODULE_0__);var _common_add_remove_id_to_item__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(30);const transformOutput=rule=>Object(fp_ts_lib_function__WEBPACK_IMPORTED_MODULE_0__["flow"])(removeIdFromThreatMatchArray)(rule);const transformInput=rule=>Object(fp_ts_lib_function__WEBPACK_IMPORTED_MODULE_0__["flow"])(addIdToThreatMatchArray)(rule);const addIdToThreatMatchArray=rule=>{if(rule.type==="threat_match"&&rule.threat_mapping!=null){const threatMapWithId=rule.threat_mapping.map(mapping=>{const newEntries=mapping.entries.map(entry=>Object(_common_add_remove_id_to_item__WEBPACK_IMPORTED_MODULE_1__["a"])(entry));return Object(_common_add_remove_id_to_item__WEBPACK_IMPORTED_MODULE_1__["a"])({entries:newEntries})});return{...rule,threat_mapping:threatMapWithId}}else{return rule}};const removeIdFromThreatMatchArray=rule=>{if(rule.type==="threat_match"&&rule.threat_mapping!=null){const threatMapWithoutId=rule.threat_mapping.map(mapping=>{const newEntries=mapping.entries.map(entry=>Object(_common_add_remove_id_to_item__WEBPACK_IMPORTED_MODULE_1__["b"])(entry));const newMapping=Object(_common_add_remove_id_to_item__WEBPACK_IMPORTED_MODULE_1__["b"])(mapping);return{...newMapping,entries:newEntries}});return{...rule,threat_mapping:threatMapWithoutId}}else{return rule}}},,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return EXIT_FULL_SCREEN_CLASS_NAME}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ExitFullScreen}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _translations__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(463);const EXIT_FULL_SCREEN_CLASS_NAME="exit-full-screen";const StyledEuiButton=styled_components__WEBPACK_IMPORTED_MODULE_2___default()(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiButton"]).withConfig({displayName:"StyledEuiButton",componentId:"sc-4dkrmi-0"})(["margin:",";"],({theme:theme})=>theme.eui.paddingSizes.s);const ExitFullScreenComponent=({fullScreen:fullScreen,setFullScreen:setFullScreen})=>{const exitFullScreen=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(()=>{setFullScreen(false)},[setFullScreen]);const onKeyDown=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(event=>{if(event.key==="Escape"){event.preventDefault();exitFullScreen()}},[exitFullScreen]);if(!fullScreen){return null}return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiWindowEvent"],{event:"keydown",handler:onKeyDown}),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(StyledEuiButton,{className:EXIT_FULL_SCREEN_CLASS_NAME,"data-test-subj":"exit-full-screen",fullWidth:false,iconType:"fullScreen",isDisabled:!fullScreen,onClick:exitFullScreen},_translations__WEBPACK_IMPORTED_MODULE_3__["a"]))};ExitFullScreenComponent.displayName="ExitFullScreenComponent";const ExitFullScreen=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(ExitFullScreenComponent)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getEntries}));const getEntries=entityOrInfluencer=>{const entries=Object.entries(entityOrInfluencer);if(Array.isArray(entries[0])){const[[key,value]]=entries;return[key,value]}else{return[null,null]}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"i",(function(){return LOCATION}));__webpack_require__.d(__webpack_exports__,"c",(function(){return AUTONOMOUS_SYSTEM}));__webpack_require__.d(__webpack_exports__,"j",(function(){return MAX_ANOMALY_SCORE_BY_JOB}));__webpack_require__.d(__webpack_exports__,"d",(function(){return FIRST_SEEN}));__webpack_require__.d(__webpack_exports__,"h",(function(){return LAST_SEEN}));__webpack_require__.d(__webpack_exports__,"e",(function(){return HOST_ID}));__webpack_require__.d(__webpack_exports__,"f",(function(){return HOST_NAME}));__webpack_require__.d(__webpack_exports__,"o",(function(){return WHOIS}));__webpack_require__.d(__webpack_exports__,"n",(function(){return VIEW_WHOIS}));__webpack_require__.d(__webpack_exports__,"k",(function(){return REPUTATION}));__webpack_require__.d(__webpack_exports__,"m",(function(){return VIEW_VIRUS_TOTAL}));__webpack_require__.d(__webpack_exports__,"l",(function(){return VIEW_TALOS_INTELLIGENCE}));__webpack_require__.d(__webpack_exports__,"b",(function(){return AS_SOURCE}));__webpack_require__.d(__webpack_exports__,"a",(function(){return AS_DESTINATION}));__webpack_require__.d(__webpack_exports__,"g",(function(){return INSPECT_TITLE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const LOCATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.locationTitle",{defaultMessage:"Location"});const AUTONOMOUS_SYSTEM=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.autonomousSystemTitle",{defaultMessage:"Autonomous system"});const MAX_ANOMALY_SCORE_BY_JOB=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.maxAnomalyScoreByJobTitle",{defaultMessage:"Max anomaly score by job"});const FIRST_SEEN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.firstSeenTitle",{defaultMessage:"First seen"});const LAST_SEEN=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.lastSeenTitle",{defaultMessage:"Last seen"});const HOST_ID=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.hostIdTitle",{defaultMessage:"Host ID"});const HOST_NAME=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.hostNameTitle",{defaultMessage:"Host name"});const WHOIS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.whoIsTitle",{defaultMessage:"WhoIs"});const VIEW_WHOIS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.viewWhoisTitle",{defaultMessage:"iana.org"});const REPUTATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.ipReputationTitle",{defaultMessage:"Reputation"});const VIEW_VIRUS_TOTAL=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.viewVirusTotalTitle.",{defaultMessage:"virustotal.com"});const VIEW_TALOS_INTELLIGENCE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.viewTalosIntelligenceTitle",{defaultMessage:"talosIntelligence.com"});const AS_SOURCE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.asSourceDropDownOptionLabel",{defaultMessage:"As Source"});const AS_DESTINATION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.asDestinationDropDownOptionLabel",{defaultMessage:"As Destination"});const INSPECT_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.network.ipDetails.ipOverview.inspectTitle",{defaultMessage:"IP overview"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return NEWS_FEED_TITLE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return RECENT_CASES}));__webpack_require__.d(__webpack_exports__,"d",(function(){return RECENT_TIMELINES}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ALERT_COUNT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return TOP}));__webpack_require__.d(__webpack_exports__,"f",(function(){return VIEW_ALERTS}));__webpack_require__.d(__webpack_exports__,"g",(function(){return VIEW_EVENTS}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const EVENTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.eventsTitle",{defaultMessage:"Event count"});const NEWS_FEED_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.newsFeedSidebarTitle",{defaultMessage:"Security news"});const PAGE_TITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.pageTitle",{defaultMessage:"Security"});const PAGE_SUBTITLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.pageSubtitle",{defaultMessage:"Security Information & Event Management with the Elastic Stack"});const RECENT_CASES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.recentCasesSidebarTitle",{defaultMessage:"Recent cases"});const RECENT_TIMELINES=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.recentTimelinesSidebarTitle",{defaultMessage:"Recent timelines"});const ALERT_COUNT=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.signalCountTitle",{defaultMessage:"Detection alert trend"});const TOP=fieldName=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.topNLabel",{values:{fieldName:fieldName},defaultMessage:`Top {fieldName}`});const VIEW_ALERTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.viewAlertsButtonLabel",{defaultMessage:"View alerts"});const VIEW_EVENTS=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.overview.viewEventsButtonLabel",{defaultMessage:"View events"})},,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return isLoadingResourceState}));__webpack_require__.d(__webpack_exports__,"d",(function(){return isLoadedResourceState}));__webpack_require__.d(__webpack_exports__,"c",(function(){return isFailedResourceState}));__webpack_require__.d(__webpack_exports__,"g",(function(){return isStaleResourceState}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getLastLoadedResourceState}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getCurrentResourceError}));__webpack_require__.d(__webpack_exports__,"f",(function(){return isOutdatedResourceState}));const isUninitialisedResourceState=state=>state.type==="UninitialisedResourceState";const isLoadingResourceState=state=>state.type==="LoadingResourceState";const isLoadedResourceState=state=>state.type==="LoadedResourceState";const isFailedResourceState=state=>state.type==="FailedResourceState";const isStaleResourceState=state=>isUninitialisedResourceState(state)||isLoadedResourceState(state)||isFailedResourceState(state);const getLastLoadedResourceState=state=>{if(isLoadedResourceState(state)){return state}else if(isLoadingResourceState(state)){return getLastLoadedResourceState(state.previousState)}else if(isFailedResourceState(state)){return state.lastLoadedState}else{return undefined}};const getCurrentResourceError=state=>isFailedResourceState(state)?state.error:undefined;const isOutdatedResourceState=(state,isFresh)=>isUninitialisedResourceState(state)||isLoadedResourceState(state)&&!isFresh(state.data)||isFailedResourceState(state)&&(!state.lastLoadedState||!isFresh(state.lastLoadedState.data))},function(module,exports){},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return defaultConditionEntry}));__webpack_require__.d(__webpack_exports__,"b",(function(){return defaultNewTrustedApp}));__webpack_require__.d(__webpack_exports__,"d",(function(){return initialDeletionDialogState}));__webpack_require__.d(__webpack_exports__,"c",(function(){return initialCreationDialogState}));__webpack_require__.d(__webpack_exports__,"e",(function(){return initialTrustedAppsPageState}));var _common_endpoint_types__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(39);var _common_constants__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(121);const defaultConditionEntry=()=>({field:_common_endpoint_types__WEBPACK_IMPORTED_MODULE_0__["a"].HASH,operator:"included",type:"match",value:""});const defaultNewTrustedApp=()=>({name:"",os:_common_endpoint_types__WEBPACK_IMPORTED_MODULE_0__["e"].WINDOWS,entries:[defaultConditionEntry()],description:""});const initialDeletionDialogState=()=>({confirmed:false,submissionResourceState:{type:"UninitialisedResourceState"}});const initialCreationDialogState=()=>({confirmed:false,submissionResourceState:{type:"UninitialisedResourceState"}});const initialTrustedAppsPageState=()=>({entriesExist:{type:"UninitialisedResourceState"},listView:{listResourceState:{type:"UninitialisedResourceState"},freshDataTimestamp:Date.now()},deletionDialog:initialDeletionDialogState(),creationDialog:initialCreationDialogState(),location:{page_index:_common_constants__WEBPACK_IMPORTED_MODULE_1__["c"],page_size:_common_constants__WEBPACK_IMPORTED_MODULE_1__["d"],show:undefined,view_type:"grid"},active:false})},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return UtilityBar}));__webpack_require__.d(__webpack_exports__,"b",(function(){return UtilityBarAction}));__webpack_require__.d(__webpack_exports__,"c",(function(){return UtilityBarGroup}));__webpack_require__.d(__webpack_exports__,"d",(function(){return UtilityBarSection}));__webpack_require__.d(__webpack_exports__,"e",(function(){return UtilityBarSpacer}));__webpack_require__.d(__webpack_exports__,"f",(function(){return UtilityBarText}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(73);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);const Bar=external_kbnSharedDeps_StyledComponents_default.a.aside.attrs({className:"siemUtilityBar"}).withConfig({displayName:"Bar",componentId:"sc-1kna171-0"})(["",""],({border:border,theme:theme})=>Object(external_kbnSharedDeps_StyledComponents_["css"])([""," @media only screen and (min-width:","){display:flex;justify-content:space-between;}"],border&&Object(external_kbnSharedDeps_StyledComponents_["css"])(["border-bottom:",";padding-bottom:",";"],theme.eui.euiBorderThin,theme.eui.paddingSizes.s),theme.eui.euiBreakpoints.l));Bar.displayName="Bar";const BarSection=external_kbnSharedDeps_StyledComponents_default.a.div.attrs({className:"siemUtilityBar__section"}).withConfig({displayName:"BarSection",componentId:"sc-1kna171-1"})(["",""],({grow:grow,theme:theme})=>Object(external_kbnSharedDeps_StyledComponents_["css"])(["& + &{margin-top:",";}@media only screen and (min-width:","){display:flex;flex-wrap:wrap;}@media only screen and (min-width:","){& + &{margin-top:0;margin-left:",";}}",""],theme.eui.euiSizeS,theme.eui.euiBreakpoints.m,theme.eui.euiBreakpoints.l,theme.eui.euiSize,grow&&Object(external_kbnSharedDeps_StyledComponents_["css"])(["flex:1;"])));BarSection.displayName="BarSection";const BarGroup=external_kbnSharedDeps_StyledComponents_default.a.div.attrs({className:"siemUtilityBar__group"}).withConfig({displayName:"BarGroup",componentId:"sc-1kna171-2"})(["",""],({grow:grow,theme:theme})=>Object(external_kbnSharedDeps_StyledComponents_["css"])(["align-items:flex-start;display:flex;flex-wrap:wrap;& + &{margin-top:",";}@media only screen and (min-width:","){border-right:",";flex-wrap:nowrap;margin-right:",";padding-right:",";& + &{margin-top:0;}&:last-child{border-right:none;margin-right:0;padding-right:0;}}& > *{margin-right:",";&:last-child{margin-right:0;}}",""],theme.eui.euiSizeS,theme.eui.euiBreakpoints.m,theme.eui.euiBorderThin,theme.eui.paddingSizes.m,theme.eui.paddingSizes.m,theme.eui.euiSize,grow&&Object(external_kbnSharedDeps_StyledComponents_["css"])(["flex:1;"])));BarGroup.displayName="BarGroup";const BarText=external_kbnSharedDeps_StyledComponents_default.a.p.attrs({className:"siemUtilityBar__text"}).withConfig({displayName:"BarText",componentId:"sc-1kna171-3"})(["",""],({theme:theme})=>Object(external_kbnSharedDeps_StyledComponents_["css"])(["color:",";font-size:",";line-height:",";white-space:nowrap;"],theme.eui.euiTextSubduedColor,theme.eui.euiFontSizeXS,theme.eui.euiLineHeight));BarText.displayName="BarText";const BarAction=external_kbnSharedDeps_StyledComponents_default.a.div.attrs({className:"siemUtilityBar__action"}).withConfig({displayName:"BarAction",componentId:"sc-1kna171-4"})(["",""],({theme:theme})=>Object(external_kbnSharedDeps_StyledComponents_["css"])(["font-size:",";line-height:",";"],theme.eui.euiFontSizeXS,theme.eui.euiLineHeight));BarAction.displayName="BarAction";const BarSpacer=external_kbnSharedDeps_StyledComponents_default.a.div.attrs({className:"siemUtilityBar__spacer"}).withConfig({displayName:"BarSpacer",componentId:"sc-1kna171-5"})(["",""],()=>Object(external_kbnSharedDeps_StyledComponents_["css"])(["flex:1;"]));BarSpacer.displayName="BarSpacer";const UtilityBar=external_kbnSharedDeps_React_default.a.memo(({border:border,children:children})=>external_kbnSharedDeps_React_default.a.createElement(Bar,{border:border},children));UtilityBar.displayName="UtilityBar";var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var link_icon=__webpack_require__(483);const Popover=external_kbnSharedDeps_React_default.a.memo(({children:children,color:color,iconSide:iconSide,iconSize:iconSize,iconType:iconType,popoverContent:popoverContent,disabled:disabled,ownFocus:ownFocus})=>{const[popoverState,setPopoverState]=Object(external_kbnSharedDeps_React_["useState"])(false);const closePopover=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setPopoverState(false),[setPopoverState]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:ownFocus,button:external_kbnSharedDeps_React_default.a.createElement(link_icon["b"],{color:color,iconSide:iconSide,iconSize:iconSize,iconType:iconType,onClick:()=>setPopoverState(!popoverState),disabled:disabled},children),closePopover:()=>setPopoverState(false),isOpen:popoverState,repositionOnScroll:true},popoverContent===null||popoverContent===void 0?void 0:popoverContent(closePopover))});Popover.displayName="Popover";const UtilityBarAction=external_kbnSharedDeps_React_default.a.memo(({children:children,color:color,dataTestSubj:dataTestSubj,disabled:disabled,href:href,iconSide:iconSide,iconSize:iconSize,iconType:iconType,ownFocus:ownFocus,onClick:onClick,popoverContent:popoverContent})=>external_kbnSharedDeps_React_default.a.createElement(BarAction,{"data-test-subj":dataTestSubj},popoverContent?external_kbnSharedDeps_React_default.a.createElement(Popover,{disabled:disabled,color:color,iconSide:iconSide,iconSize:iconSize,iconType:iconType,ownFocus:ownFocus,popoverContent:popoverContent},children):external_kbnSharedDeps_React_default.a.createElement(link_icon["b"],{color:color,disabled:disabled,href:href,iconSide:iconSide,iconSize:iconSize,iconType:iconType,onClick:onClick},children)));UtilityBarAction.displayName="UtilityBarAction";const UtilityBarGroup=external_kbnSharedDeps_React_default.a.memo(({grow:grow,children:children})=>external_kbnSharedDeps_React_default.a.createElement(BarGroup,{grow:grow},children));UtilityBarGroup.displayName="UtilityBarGroup";const UtilityBarSection=external_kbnSharedDeps_React_default.a.memo(({grow:grow,children:children})=>external_kbnSharedDeps_React_default.a.createElement(BarSection,{grow:grow},children));UtilityBarSection.displayName="UtilityBarSection";const UtilityBarSpacer=external_kbnSharedDeps_React_default.a.memo(({dataTestSubj:dataTestSubj})=>external_kbnSharedDeps_React_default.a.createElement(BarSpacer,{"data-test-subj":dataTestSubj}));UtilityBarSpacer.displayName="UtilityBarSpacer";const UtilityBarText=external_kbnSharedDeps_React_default.a.memo(({children:children,dataTestSubj:dataTestSubj})=>external_kbnSharedDeps_React_default.a.createElement(BarText,{"data-test-subj":dataTestSubj},children));UtilityBarText.displayName="UtilityBarText"},,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SiemNavigation}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var lib=__webpack_require__(105);var redux=__webpack_require__(177);var fast_deep_equal=__webpack_require__(107);var fast_deep_equal_default=__webpack_require__.n(fast_deep_equal);var kibana=__webpack_require__(104);var use_route_spy=__webpack_require__(292);var helpers=__webpack_require__(243);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var constants=__webpack_require__(2);var utils=__webpack_require__(491);var details=__webpack_require__(749);var link_to=__webpack_require__(112);var translations=__webpack_require__(392);var types=__webpack_require__(3);const getBreadcrumbs=(params,search,getUrlForApp)=>{const queryParameters=!Object(external_kbnSharedDeps_LodashFp_["isEmpty"])(search[0])?search[0]:"";let breadcrumb=[{text:translations["f"],href:getUrlForApp(`${constants["f"]}:${types["a"].case}`,{path:queryParameters})}];if(params.detailName==="create"){breadcrumb=[...breadcrumb,{text:translations["c"],href:getUrlForApp(`${constants["f"]}:${types["a"].case}`,{path:Object(link_to["f"])(queryParameters)})}]}else if(params.detailName!=null){var _params$state$caseTit,_params$state;breadcrumb=[...breadcrumb,{text:(_params$state$caseTit=(_params$state=params.state)===null||_params$state===void 0?void 0:_params$state.caseTitle)!==null&&_params$state$caseTit!==void 0?_params$state$caseTit:"",href:getUrlForApp(`${constants["f"]}:${types["a"].case}`,{path:Object(link_to["b"])({id:params.detailName,search:queryParameters})})}]}return breadcrumb};var rules_utils=__webpack_require__(492);var pages=__webpack_require__(779);var management_pages=__webpack_require__(745);var navigation_helpers=__webpack_require__(456);const setBreadcrumbs=(spyState,chrome,getUrlForApp)=>{const breadcrumbs=getBreadcrumbsForRoute(spyState,getUrlForApp);if(breadcrumbs){chrome.setBreadcrumbs(breadcrumbs)}};const isNetworkRoutes=spyState=>spyState!=null&&spyState.pageName===types["a"].network;const isHostsRoutes=spyState=>spyState!=null&&spyState.pageName===types["a"].hosts;const isTimelinesRoutes=spyState=>spyState!=null&&spyState.pageName===types["a"].timelines;const isCaseRoutes=spyState=>spyState!=null&&spyState.pageName===types["a"].case;const isAlertsRoutes=spyState=>spyState!=null&&spyState.pageName===types["a"].detections;const isAdminRoutes=spyState=>spyState!=null&&spyState.pageName===types["a"].administration;const getBreadcrumbsForRoute=(object,getUrlForApp)=>{const spyState=Object(external_kbnSharedDeps_LodashFp_["omit"])("navTabs",object);const overviewPath=getUrlForApp(constants["f"],{path:types["a"].overview});const siemRootBreadcrumb={text:constants["h"],href:Object(link_to["a"])(overviewPath)};if(isHostsRoutes(spyState)&&object.navTabs){const tempNav={urlKey:"host",isDetailPage:false};let urlStateKeys=[Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.pageName,object.navTabs)];if(spyState.tabName!=null){urlStateKeys=[...urlStateKeys,Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.tabName,object.navTabs)]}return[siemRootBreadcrumb,...Object(utils["a"])(spyState,urlStateKeys.reduce((acc,item)=>[...acc,Object(navigation_helpers["a"])(item,object)],[]),getUrlForApp)]}if(isNetworkRoutes(spyState)&&object.navTabs){const tempNav={urlKey:"network",isDetailPage:false};let urlStateKeys=[Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.pageName,object.navTabs)];if(spyState.tabName!=null){urlStateKeys=[...urlStateKeys,Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.tabName,object.navTabs)]}return[siemRootBreadcrumb,...Object(details["b"])(spyState,urlStateKeys.reduce((acc,item)=>[...acc,Object(navigation_helpers["a"])(item,object)],[]),getUrlForApp)]}if(isAlertsRoutes(spyState)&&object.navTabs){const tempNav={urlKey:"detections",isDetailPage:false};let urlStateKeys=[Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.pageName,object.navTabs)];if(spyState.tabName!=null){urlStateKeys=[...urlStateKeys,Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.tabName,object.navTabs)]}return[siemRootBreadcrumb,...Object(rules_utils["a"])(spyState,urlStateKeys.reduce((acc,item)=>[...acc,Object(navigation_helpers["a"])(item,object)],[]),getUrlForApp)]}if(isCaseRoutes(spyState)&&object.navTabs){const tempNav={urlKey:"case",isDetailPage:false};let urlStateKeys=[Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.pageName,object.navTabs)];if(spyState.tabName!=null){urlStateKeys=[...urlStateKeys,Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.tabName,object.navTabs)]}return[siemRootBreadcrumb,...getBreadcrumbs(spyState,urlStateKeys.reduce((acc,item)=>[...acc,Object(navigation_helpers["a"])(item,object)],[]),getUrlForApp)]}if(isTimelinesRoutes(spyState)&&object.navTabs){const tempNav={urlKey:"timeline",isDetailPage:false};const urlStateKeys=[Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.pageName,object.navTabs)];return[siemRootBreadcrumb,...Object(pages["b"])(spyState,urlStateKeys.reduce((acc,item)=>[...acc,Object(navigation_helpers["a"])(item,object)],[]),getUrlForApp)]}if(isAdminRoutes(spyState)&&object.navTabs){const tempNav={urlKey:"administration",isDetailPage:false};let urlStateKeys=[Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.pageName,object.navTabs)];if(spyState.tabName!=null){urlStateKeys=[...urlStateKeys,Object(external_kbnSharedDeps_LodashFp_["getOr"])(tempNav,spyState.tabName,object.navTabs)]}return[siemRootBreadcrumb,...Object(management_pages["b"])(spyState,urlStateKeys.reduce((acc,item)=>[...acc,Object(navigation_helpers["a"])(item,object)],[]),getUrlForApp)]}if(spyState!=null&&object.navTabs&&spyState.pageName&&object.navTabs[spyState.pageName]){return[siemRootBreadcrumb,{text:object.navTabs[spyState.pageName].name,href:""}]}return null};var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(75);var telemetry=__webpack_require__(44);const TabNavigationItemComponent=({disabled:disabled,href:href,hrefWithSearch:hrefWithSearch,id:id,name:name,isSelected:isSelected,pageId:pageId,urlSearch:urlSearch})=>{const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{navigateToApp:navigateToApp,getUrlForApp:getUrlForApp}=Object(kibana["h"])().services.application;const{formatUrl:formatUrl}=Object(link_to["o"])(pageId!==null&&pageId!==void 0?pageId:id);const handleClick=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{ev.preventDefault();if(id in types["a"]&&pageId==null){navigateToApp(`${constants["f"]}:${id}`,{path:urlSearch})}else{history.push(hrefWithSearch)}Object(telemetry["e"])(telemetry["a"].CLICK,`${telemetry["b"].TAB_CLICKED}${id}`)},[history,hrefWithSearch,id,navigateToApp,pageId,urlSearch]);const appHref=pageId!=null?formatUrl(href):getUrlForApp(`${constants["f"]}:${id}`,{path:urlSearch});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{"data-href":appHref,"data-test-subj":`navigation-${id}`,disabled:disabled,isSelected:isSelected,href:appHref,onClick:handleClick},name)};const TabNavigationItem=external_kbnSharedDeps_React_default.a.memo(TabNavigationItemComponent);const TabNavigationComponent=({display:display,filters:filters,query:query,navTabs:navTabs,pageName:pageName,savedQuery:savedQuery,sourcerer:sourcerer,tabName:tabName,timeline:timeline,timerange:timerange})=>{const mapLocationToTab=Object(external_kbnSharedDeps_React_["useCallback"])(()=>Object(external_kbnSharedDeps_LodashFp_["getOr"])("","id",Object.values(navTabs).find(item=>tabName===item.id&&item.pageId!=null||pageName===item.id&&item.pageId==null)),[pageName,tabName,navTabs]);const[selectedTabId,setSelectedTabId]=Object(external_kbnSharedDeps_React_["useState"])(mapLocationToTab());Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const currentTabSelected=mapLocationToTab();if(currentTabSelected!==selectedTabId){setSelectedTabId(currentTabSelected)}},[pageName,tabName,navTabs,mapLocationToTab,selectedTabId]);const renderTabs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(navTabs).map(tab=>{const isSelected=selectedTabId===tab.id;const search=Object(navigation_helpers["a"])(tab,{filters:filters,query:query,savedQuery:savedQuery,sourcerer:sourcerer,timeline:timeline,timerange:timerange});const hrefWithSearch=tab.href+Object(navigation_helpers["a"])(tab,{filters:filters,query:query,savedQuery:savedQuery,sourcerer:sourcerer,timeline:timeline,timerange:timerange});return external_kbnSharedDeps_React_default.a.createElement(TabNavigationItem,{key:`navigation-${tab.id}`,id:tab.id,href:tab.href,hrefWithSearch:hrefWithSearch,name:tab.name,disabled:tab.disabled,pageId:tab.pageId,isSelected:isSelected,urlSearch:search})}),[navTabs,selectedTabId,filters,query,savedQuery,sourcerer,timeline,timerange]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],{display:display},renderTabs)};TabNavigationComponent.displayName="TabNavigationComponent";const TabNavigation=external_kbnSharedDeps_React_default.a.memo(TabNavigationComponent,(prevProps,nextProps)=>prevProps.display===nextProps.display&&prevProps.pageName===nextProps.pageName&&prevProps.savedQuery===nextProps.savedQuery&&prevProps.tabName===nextProps.tabName&&fast_deep_equal_default()(prevProps.filters,nextProps.filters)&&fast_deep_equal_default()(prevProps.query,nextProps.query)&&fast_deep_equal_default()(prevProps.navTabs,nextProps.navTabs)&&fast_deep_equal_default()(prevProps.sourcerer,nextProps.sourcerer)&&fast_deep_equal_default()(prevProps.timeline,nextProps.timeline)&&fast_deep_equal_default()(prevProps.timerange,nextProps.timerange));TabNavigation.displayName="TabNavigation";const SiemNavigationComponent=({detailName:detailName,display:display,navTabs:navTabs,pageName:pageName,pathName:pathName,search:search,tabName:tabName,urlState:urlState,flowTarget:flowTarget,state:state})=>{const{chrome:chrome,application:{getUrlForApp:getUrlForApp}}=Object(kibana["h"])().services;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(pathName||pageName){setBreadcrumbs({detailName:detailName,filters:urlState.filters,flowTarget:flowTarget,navTabs:navTabs,pageName:pageName,pathName:pathName,query:urlState.query,savedQuery:urlState.savedQuery,search:search,sourcerer:urlState.sourcerer,state:state,tabName:tabName,timeline:urlState.timeline,timerange:urlState.timerange},chrome,getUrlForApp)}},[chrome,pageName,pathName,search,navTabs,urlState,state]);return external_kbnSharedDeps_React_default.a.createElement(TabNavigation,{query:urlState.query,display:display,filters:urlState.filters,navTabs:navTabs,pageName:pageName,pathName:pathName,sourcerer:urlState.sourcerer,savedQuery:urlState.savedQuery,tabName:tabName,timeline:urlState.timeline,timerange:urlState.timerange})};const SiemNavigationRedux=Object(redux["compose"])(Object(lib["connect"])(helpers["f"]))(external_kbnSharedDeps_React_default.a.memo(SiemNavigationComponent,(prevProps,nextProps)=>prevProps.pathName===nextProps.pathName&&prevProps.search===nextProps.search&&fast_deep_equal_default()(prevProps.navTabs,nextProps.navTabs)&&fast_deep_equal_default()(prevProps.urlState,nextProps.urlState)&&fast_deep_equal_default()(prevProps.state,nextProps.state)));const SiemNavigationContainer=props=>{const[routeProps]=Object(use_route_spy["a"])();const stateNavReduxProps={...routeProps,...props};return external_kbnSharedDeps_React_default.a.createElement(SiemNavigationRedux,stateNavReduxProps)};const SiemNavigation=external_kbnSharedDeps_React_default.a.memo(SiemNavigationContainer,(prevProps,nextProps)=>fast_deep_equal_default()(prevProps.navTabs,nextProps.navTabs))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useAnomaliesTableData}));var external_kbnSharedDeps_React_=__webpack_require__(6);var constants=__webpack_require__(2);var kibana=__webpack_require__(104);const anomaliesTableData=async(body,signal)=>kibana["b"].get().http.fetch("/api/ml/results/anomalies_table_data",{method:"POST",body:JSON.stringify(body),asSystemRequest:true,signal:signal});var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const SIEM_TABLE_FETCH_FAILURE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.securitySolution.components.ml.anomaly.errors.anomaliesTableFetchFailureTitle",{defaultMessage:"Anomalies table fetch failure"});var use_app_toasts=__webpack_require__(143);var use_installed_security_jobs=__webpack_require__(513);const influencersOrCriteriaToString=influencers=>influencers==null?"":influencers.reduce((accum,item)=>`${accum}${item.fieldName}:${item.fieldValue}`,"");const getThreshold=(anomalyScore,threshold)=>{if(threshold!==-1){return threshold}else if(anomalyScore==null){return 50}else if(anomalyScore<0){return 0}else if(anomalyScore>100){return 100}else{return Math.floor(anomalyScore)}};const useAnomaliesTableData=({criteriaFields:criteriaFields=[],influencers:influencers=[],startDate:startDate,endDate:endDate,threshold:threshold=-1,skip:skip=false})=>{const[tableData,setTableData]=Object(external_kbnSharedDeps_React_["useState"])(null);const{isMlUser:isMlUser,jobs:jobs}=Object(use_installed_security_jobs["a"])();const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const{addError:addError}=Object(use_app_toasts["a"])();const timeZone=Object(kibana["i"])();const[anomalyScore]=Object(kibana["l"])(constants["m"]);const jobIds=jobs.map(job=>job.id);const startDateMs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new Date(startDate).getTime(),[startDate]);const endDateMs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new Date(endDate).getTime(),[endDate]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{let isSubscribed=true;const abortCtrl=new AbortController;setLoading(true);async function fetchAnomaliesTableData(influencersInput,criteriaFieldsInput,earliestMs,latestMs){if(isMlUser&&!skip&&jobIds.length>0){try{const data=await anomaliesTableData({jobIds:jobIds,criteriaFields:criteriaFieldsInput,aggregationInterval:"auto",threshold:getThreshold(anomalyScore,threshold),earliestMs:earliestMs,latestMs:latestMs,influencers:influencersInput,dateFormatTz:timeZone,maxRecords:500,maxExamples:10},abortCtrl.signal);if(isSubscribed){setTableData(data);setLoading(false)}}catch(error){if(isSubscribed){addError(error,{title:SIEM_TABLE_FETCH_FAILURE});setLoading(false)}}}else if(!isMlUser&&isSubscribed){setLoading(false)}else if(jobIds.length===0&&isSubscribed){setLoading(false)}else if(isSubscribed){setTableData(null);setLoading(true)}}fetchAnomaliesTableData(influencers,criteriaFields,startDateMs,endDateMs);return()=>{isSubscribed=false;abortCtrl.abort()}},[influencersOrCriteriaToString(influencers),influencersOrCriteriaToString(criteriaFields),startDateMs,endDateMs,skip,isMlUser,jobIds.sort().join()]);return[loading,tableData]}},,,,,,function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(331),__webpack_require__(333),__webpack_require__(334)):undefined})(this,(function(exports,apolloUtilities,Observable,printer){"use strict";Observable=Observable&&Observable.hasOwnProperty("default")?Observable["default"]:Observable;var __extends=undefined&&undefined.__extends||function(){var extendStatics=function(d,b){extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)if(b.hasOwnProperty(p))d[p]=b[p]};return extendStatics(d,b)};return function(d,b){extendStatics(d,b);function __(){this.constructor=d}d.prototype=b===null?Object.create(b):(__.prototype=b.prototype,new __)}}();var __assign=undefined&&undefined.__assign||function(){__assign=Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p]}return t};return __assign.apply(this,arguments)};function validateOperation(operation){var OPERATION_FIELDS=["query","operationName","variables","extensions","context"];for(var _i=0,_a=Object.keys(operation);_i<_a.length;_i++){var key=_a[_i];if(OPERATION_FIELDS.indexOf(key)<0){throw new Error("illegal argument: "+key)}}return operation}var LinkError=function(_super){__extends(LinkError,_super);function LinkError(message,link){var _this=_super.call(this,message)||this;_this.link=link;return _this}return LinkError}(Error);function isTerminating(link){return link.request.length<=1}function toPromise(observable){var completed=false;return new Promise((function(resolve,reject){observable.subscribe({next:function(data){if(completed){console.warn("Promise Wrapper does not support multiple results from Observable")}else{completed=true;resolve(data)}},error:reject})}))}var makePromise=toPromise;function fromPromise(promise){return new Observable((function(observer){promise.then((function(value){observer.next(value);observer.complete()})).catch(observer.error.bind(observer))}))}function fromError(errorValue){return new Observable((function(observer){observer.error(errorValue)}))}function transformOperation(operation){var transformedOperation={variables:operation.variables||{},extensions:operation.extensions||{},operationName:operation.operationName,query:operation.query};if(!transformedOperation.operationName){transformedOperation.operationName=typeof transformedOperation.query!=="string"?apolloUtilities.getOperationName(transformedOperation.query):""}return transformedOperation}function createOperation(starting,operation){var context=__assign({},starting);var setContext=function(next){if(typeof next==="function"){context=__assign({},context,next(context))}else{context=__assign({},context,next)}};var getContext=function(){return __assign({},context)};Object.defineProperty(operation,"setContext",{enumerable:false,value:setContext});Object.defineProperty(operation,"getContext",{enumerable:false,value:getContext});Object.defineProperty(operation,"toKey",{enumerable:false,value:function(){return getKey(operation)}});return operation}function getKey(operation){return printer.print(operation.query)+"|"+JSON.stringify(operation.variables)+"|"+operation.operationName}var passthrough=function(op,forward){return forward?forward(op):Observable.of()};var toLink=function(handler){return typeof handler==="function"?new ApolloLink(handler):handler};var empty=function(){return new ApolloLink((function(op,forward){return Observable.of()}))};var from=function(links){if(links.length===0)return empty();return links.map(toLink).reduce((function(x,y){return x.concat(y)}))};var split=function(test,left,right){if(right===void 0){right=new ApolloLink(passthrough)}var leftLink=toLink(left);var rightLink=toLink(right);if(isTerminating(leftLink)&&isTerminating(rightLink)){return new ApolloLink((function(operation){return test(operation)?leftLink.request(operation)||Observable.of():rightLink.request(operation)||Observable.of()}))}else{return new ApolloLink((function(operation,forward){return test(operation)?leftLink.request(operation,forward)||Observable.of():rightLink.request(operation,forward)||Observable.of()}))}};var concat=function(first,second){var firstLink=toLink(first);if(isTerminating(firstLink)){console.warn(new LinkError("You are calling concat on a terminating link, which will have no effect",firstLink));return firstLink}var nextLink=toLink(second);if(isTerminating(nextLink)){return new ApolloLink((function(operation){return firstLink.request(operation,(function(op){return nextLink.request(op)||Observable.of()}))||Observable.of()}))}else{return new ApolloLink((function(operation,forward){return firstLink.request(operation,(function(op){return nextLink.request(op,forward)||Observable.of()}))||Observable.of()}))}};var ApolloLink=function(){function ApolloLink(request){if(request)this.request=request}ApolloLink.prototype.split=function(test,left,right){if(right===void 0){right=new ApolloLink(passthrough)}return this.concat(split(test,left,right))};ApolloLink.prototype.concat=function(next){return concat(this,next)};ApolloLink.prototype.request=function(operation,forward){throw new Error("request is not implemented")};ApolloLink.empty=empty;ApolloLink.from=from;ApolloLink.split=split;ApolloLink.execute=execute;return ApolloLink}();function execute(link,operation){return link.request(createOperation(operation.context,transformOperation(validateOperation(operation))))||Observable.of()}exports.Observable=Observable;exports.createOperation=createOperation;exports.makePromise=makePromise;exports.toPromise=toPromise;exports.fromPromise=fromPromise;exports.fromError=fromError;exports.empty=empty;exports.from=from;exports.split=split;exports.concat=concat;exports.ApolloLink=ApolloLink;exports.execute=execute;Object.defineProperty(exports,"__esModule",{value:true})}))},function(module,exports,__webpack_require__){(function(process){(function(global,factory){true?factory(exports,__webpack_require__(332)):undefined})(this,(function(exports,stringify){"use strict";stringify=stringify&&stringify.hasOwnProperty("default")?stringify["default"]:stringify;var __assign=undefined&&undefined.__assign||Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p]}return t};function isScalarValue(value){return["StringValue","BooleanValue","EnumValue"].indexOf(value.kind)>-1}function isNumberValue(value){return["IntValue","FloatValue"].indexOf(value.kind)>-1}function isStringValue(value){return value.kind==="StringValue"}function isBooleanValue(value){return value.kind==="BooleanValue"}function isIntValue(value){return value.kind==="IntValue"}function isFloatValue(value){return value.kind==="FloatValue"}function isVariable(value){return value.kind==="Variable"}function isObjectValue(value){return value.kind==="ObjectValue"}function isListValue(value){return value.kind==="ListValue"}function isEnumValue(value){return value.kind==="EnumValue"}function isNullValue(value){return value.kind==="NullValue"}function valueToObjectRepresentation(argObj,name,value,variables){if(isIntValue(value)||isFloatValue(value)){argObj[name.value]=Number(value.value)}else if(isBooleanValue(value)||isStringValue(value)){argObj[name.value]=value.value}else if(isObjectValue(value)){var nestedArgObj_1={};value.fields.map((function(obj){return valueToObjectRepresentation(nestedArgObj_1,obj.name,obj.value,variables)}));argObj[name.value]=nestedArgObj_1}else if(isVariable(value)){var variableValue=(variables||{})[value.name.value];argObj[name.value]=variableValue}else if(isListValue(value)){argObj[name.value]=value.values.map((function(listValue){var nestedArgArrayObj={};valueToObjectRepresentation(nestedArgArrayObj,name,listValue,variables);return nestedArgArrayObj[name.value]}))}else if(isEnumValue(value)){argObj[name.value]=value.value}else if(isNullValue(value)){argObj[name.value]=null}else{throw new Error('The inline argument "'+name.value+'" of kind "'+value.kind+'"'+"is not supported. Use variables instead of inline arguments to "+"overcome this limitation.")}}function storeKeyNameFromField(field,variables){var directivesObj=null;if(field.directives){directivesObj={};field.directives.forEach((function(directive){directivesObj[directive.name.value]={};if(directive.arguments){directive.arguments.forEach((function(_a){var name=_a.name,value=_a.value;return valueToObjectRepresentation(directivesObj[directive.name.value],name,value,variables)}))}}))}var argObj=null;if(field.arguments&&field.arguments.length){argObj={};field.arguments.forEach((function(_a){var name=_a.name,value=_a.value;return valueToObjectRepresentation(argObj,name,value,variables)}))}return getStoreKeyName(field.name.value,argObj,directivesObj)}var KNOWN_DIRECTIVES=["connection","include","skip","client","rest","export"];function getStoreKeyName(fieldName,args,directives){if(directives&&directives["connection"]&&directives["connection"]["key"]){if(directives["connection"]["filter"]&&directives["connection"]["filter"].length>0){var filterKeys=directives["connection"]["filter"]?directives["connection"]["filter"]:[];filterKeys.sort();var queryArgs_1=args;var filteredArgs_1={};filterKeys.forEach((function(key){filteredArgs_1[key]=queryArgs_1[key]}));return directives["connection"]["key"]+"("+JSON.stringify(filteredArgs_1)+")"}else{return directives["connection"]["key"]}}var completeFieldName=fieldName;if(args){var stringifiedArgs=stringify(args);completeFieldName+="("+stringifiedArgs+")"}if(directives){Object.keys(directives).forEach((function(key){if(KNOWN_DIRECTIVES.indexOf(key)!==-1)return;if(directives[key]&&Object.keys(directives[key]).length){completeFieldName+="@"+key+"("+JSON.stringify(directives[key])+")"}else{completeFieldName+="@"+key}}))}return completeFieldName}function argumentsObjectFromField(field,variables){if(field.arguments&&field.arguments.length){var argObj_1={};field.arguments.forEach((function(_a){var name=_a.name,value=_a.value;return valueToObjectRepresentation(argObj_1,name,value,variables)}));return argObj_1}return null}function resultKeyNameFromField(field){return field.alias?field.alias.value:field.name.value}function isField(selection){return selection.kind==="Field"}function isInlineFragment(selection){return selection.kind==="InlineFragment"}function isIdValue(idObject){return idObject&&idObject.type==="id"}function toIdValue(idConfig,generated){if(generated===void 0){generated=false}return __assign({type:"id",generated:generated},typeof idConfig==="string"?{id:idConfig,typename:undefined}:idConfig)}function isJsonValue(jsonObject){return jsonObject!=null&&typeof jsonObject==="object"&&jsonObject.type==="json"}function defaultValueFromVariable(node){throw new Error("Variable nodes are not supported by valueFromNode")}function valueFromNode(node,onVariable){if(onVariable===void 0){onVariable=defaultValueFromVariable}switch(node.kind){case"Variable":return onVariable(node);case"NullValue":return null;case"IntValue":return parseInt(node.value,10);case"FloatValue":return parseFloat(node.value);case"ListValue":return node.values.map((function(v){return valueFromNode(v,onVariable)}));case"ObjectValue":{var value={};for(var _i=0,_a=node.fields;_i<_a.length;_i++){var field=_a[_i];value[field.name.value]=valueFromNode(field.value,onVariable)}return value}default:return node.value}}function getDirectiveInfoFromField(field,variables){if(field.directives&&field.directives.length){var directiveObj_1={};field.directives.forEach((function(directive){directiveObj_1[directive.name.value]=argumentsObjectFromField(directive,variables)}));return directiveObj_1}return null}function shouldInclude(selection,variables){if(variables===void 0){variables={}}if(!selection.directives){return true}var res=true;selection.directives.forEach((function(directive){if(directive.name.value!=="skip"&&directive.name.value!=="include"){return}var directiveArguments=directive.arguments||[];var directiveName=directive.name.value;if(directiveArguments.length!==1){throw new Error("Incorrect number of arguments for the @"+directiveName+" directive.")}var ifArgument=directiveArguments[0];if(!ifArgument.name||ifArgument.name.value!=="if"){throw new Error("Invalid argument for the @"+directiveName+" directive.")}var ifValue=directiveArguments[0].value;var evaledValue=false;if(!ifValue||ifValue.kind!=="BooleanValue"){if(ifValue.kind!=="Variable"){throw new Error("Argument for the @"+directiveName+" directive must be a variable or a boolean value.")}else{evaledValue=variables[ifValue.name.value];if(evaledValue===undefined){throw new Error("Invalid variable referenced in @"+directiveName+" directive.")}}}else{evaledValue=ifValue.value}if(directiveName==="skip"){evaledValue=!evaledValue}if(!evaledValue){res=false}}));return res}function flattenSelections(selection){if(!selection.selectionSet||!(selection.selectionSet.selections.length>0))return[selection];return[selection].concat(selection.selectionSet.selections.map((function(selectionNode){return[selectionNode].concat(flattenSelections(selectionNode))})).reduce((function(selections,selected){return selections.concat(selected)}),[]))}function getDirectiveNames(doc){var directiveNames=doc.definitions.filter((function(definition){return definition.selectionSet&&definition.selectionSet.selections})).map((function(x){return flattenSelections(x)})).reduce((function(selections,selected){return selections.concat(selected)}),[]).filter((function(selection){return selection.directives&&selection.directives.length>0})).map((function(selection){return selection.directives})).reduce((function(directives,directive){return directives.concat(directive)}),[]).map((function(directive){return directive.name.value}));return directiveNames}function hasDirectives(names,doc){return getDirectiveNames(doc).some((function(name){return names.indexOf(name)>-1}))}var __assign$1=undefined&&undefined.__assign||Object.assign||function(t){for(var s,i=1,n=arguments.length;i<n;i++){s=arguments[i];for(var p in s)if(Object.prototype.hasOwnProperty.call(s,p))t[p]=s[p]}return t};function getFragmentQueryDocument(document,fragmentName){var actualFragmentName=fragmentName;var fragments=[];document.definitions.forEach((function(definition){if(definition.kind==="OperationDefinition"){throw new Error("Found a "+definition.operation+" operation"+(definition.name?" named '"+definition.name.value+"'":"")+". "+"No operations are allowed when using a fragment as a query. Only fragments are allowed.")}if(definition.kind==="FragmentDefinition"){fragments.push(definition)}}));if(typeof actualFragmentName==="undefined"){if(fragments.length!==1){throw new Error("Found "+fragments.length+" fragments. `fragmentName` must be provided when there is not exactly 1 fragment.")}actualFragmentName=fragments[0].name.value}var query=__assign$1({},document,{definitions:[{kind:"OperationDefinition",operation:"query",selectionSet:{kind:"SelectionSet",selections:[{kind:"FragmentSpread",name:{kind:"Name",value:actualFragmentName}}]}}].concat(document.definitions)});return query}function assign(target){var sources=[];for(var _i=1;_i<arguments.length;_i++){sources[_i-1]=arguments[_i]}sources.forEach((function(source){if(typeof source==="undefined"||source===null){return}Object.keys(source).forEach((function(key){target[key]=source[key]}))}));return target}function getMutationDefinition(doc){checkDocument(doc);var mutationDef=doc.definitions.filter((function(definition){return definition.kind==="OperationDefinition"&&definition.operation==="mutation"}))[0];if(!mutationDef){throw new Error("Must contain a mutation definition.")}return mutationDef}function checkDocument(doc){if(doc.kind!=="Document"){throw new Error('Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a "gql" tag? http://docs.apollostack.com/apollo-client/core.html#gql')}var operations=doc.definitions.filter((function(d){return d.kind!=="FragmentDefinition"})).map((function(definition){if(definition.kind!=="OperationDefinition"){throw new Error('Schema type definitions not allowed in queries. Found: "'+definition.kind+'"')}return definition}));if(operations.length>1){throw new Error("Ambiguous GraphQL document: contains "+operations.length+" operations")}}function getOperationDefinition(doc){checkDocument(doc);return doc.definitions.filter((function(definition){return definition.kind==="OperationDefinition"}))[0]}function getOperationDefinitionOrDie(document){var def=getOperationDefinition(document);if(!def){throw new Error("GraphQL document is missing an operation")}return def}function getOperationName(doc){return doc.definitions.filter((function(definition){return definition.kind==="OperationDefinition"&&definition.name})).map((function(x){return x.name.value}))[0]||null}function getFragmentDefinitions(doc){return doc.definitions.filter((function(definition){return definition.kind==="FragmentDefinition"}))}function getQueryDefinition(doc){var queryDef=getOperationDefinition(doc);if(!queryDef||queryDef.operation!=="query"){throw new Error("Must contain a query definition.")}return queryDef}function getFragmentDefinition(doc){if(doc.kind!=="Document"){throw new Error('Expecting a parsed GraphQL document. Perhaps you need to wrap the query string in a "gql" tag? http://docs.apollostack.com/apollo-client/core.html#gql')}if(doc.definitions.length>1){throw new Error("Fragment must have exactly one definition.")}var fragmentDef=doc.definitions[0];if(fragmentDef.kind!=="FragmentDefinition"){throw new Error("Must be a fragment definition.")}return fragmentDef}function getMainDefinition(queryDoc){checkDocument(queryDoc);var fragmentDefinition;for(var _i=0,_a=queryDoc.definitions;_i<_a.length;_i++){var definition=_a[_i];if(definition.kind==="OperationDefinition"){var operation=definition.operation;if(operation==="query"||operation==="mutation"||operation==="subscription"){return definition}}if(definition.kind==="FragmentDefinition"&&!fragmentDefinition){fragmentDefinition=definition}}if(fragmentDefinition){return fragmentDefinition}throw new Error("Expected a parsed GraphQL query with a query, mutation, subscription, or a fragment.")}function createFragmentMap(fragments){if(fragments===void 0){fragments=[]}var symTable={};fragments.forEach((function(fragment){symTable[fragment.name.value]=fragment}));return symTable}function getDefaultValues(definition){if(definition&&definition.variableDefinitions&&definition.variableDefinitions.length){var defaultValues=definition.variableDefinitions.filter((function(_a){var defaultValue=_a.defaultValue;return defaultValue})).map((function(_a){var variable=_a.variable,defaultValue=_a.defaultValue;var defaultValueObj={};valueToObjectRepresentation(defaultValueObj,variable.name,defaultValue);return defaultValueObj}));return assign.apply(void 0,[{}].concat(defaultValues))}return{}}function variablesInOperation(operation){var names=new Set;if(operation.variableDefinitions){for(var _i=0,_a=operation.variableDefinitions;_i<_a.length;_i++){var definition=_a[_i];names.add(definition.variable.name.value)}}return names}function cloneDeep(value){if(Array.isArray(value)){return value.map((function(item){return cloneDeep(item)}))}if(value!==null&&typeof value==="object"){var nextValue={};for(var key in value){if(value.hasOwnProperty(key)){nextValue[key]=cloneDeep(value[key])}}return nextValue}return value}var TYPENAME_FIELD={kind:"Field",name:{kind:"Name",value:"__typename"}};function isNotEmpty(op,fragments){return op.selectionSet.selections.filter((function(selectionSet){return!(selectionSet&&selectionSet.kind==="FragmentSpread"&&!isNotEmpty(fragments[selectionSet.name.value],fragments))})).length>0}function getDirectiveMatcher(directives){return function directiveMatcher(directive){return directives.some((function(dir){if(dir.name&&dir.name===directive.name.value)return true;if(dir.test&&dir.test(directive))return true;return false}))}}function addTypenameToSelectionSet(selectionSet,isRoot){if(isRoot===void 0){isRoot=false}if(selectionSet.selections){if(!isRoot){var alreadyHasThisField=selectionSet.selections.some((function(selection){return selection.kind==="Field"&&selection.name.value==="__typename"}));if(!alreadyHasThisField){selectionSet.selections.push(TYPENAME_FIELD)}}selectionSet.selections.forEach((function(selection){if(selection.kind==="Field"){if(selection.name.value.lastIndexOf("__",0)!==0&&selection.selectionSet){addTypenameToSelectionSet(selection.selectionSet)}}else if(selection.kind==="InlineFragment"){if(selection.selectionSet){addTypenameToSelectionSet(selection.selectionSet)}}}))}}function removeDirectivesFromSelectionSet(directives,selectionSet){if(!selectionSet.selections)return selectionSet;var agressiveRemove=directives.some((function(dir){return dir.remove}));selectionSet.selections=selectionSet.selections.map((function(selection){if(selection.kind!=="Field"||!selection||!selection.directives)return selection;var directiveMatcher=getDirectiveMatcher(directives);var remove;selection.directives=selection.directives.filter((function(directive){var shouldKeep=!directiveMatcher(directive);if(!remove&&!shouldKeep&&agressiveRemove)remove=true;return shouldKeep}));return remove?null:selection})).filter((function(x){return!!x}));selectionSet.selections.forEach((function(selection){if((selection.kind==="Field"||selection.kind==="InlineFragment")&&selection.selectionSet){removeDirectivesFromSelectionSet(directives,selection.selectionSet)}}));return selectionSet}function removeDirectivesFromDocument(directives,doc){var docClone=cloneDeep(doc);docClone.definitions.forEach((function(definition){removeDirectivesFromSelectionSet(directives,definition.selectionSet)}));var operation=getOperationDefinitionOrDie(docClone);var fragments=createFragmentMap(getFragmentDefinitions(docClone));return isNotEmpty(operation,fragments)?docClone:null}function addTypenameToDocument(doc){checkDocument(doc);var docClone=cloneDeep(doc);docClone.definitions.forEach((function(definition){var isRoot=definition.kind==="OperationDefinition";addTypenameToSelectionSet(definition.selectionSet,isRoot)}));return docClone}var connectionRemoveConfig={test:function(directive){var willRemove=directive.name.value==="connection";if(willRemove){if(!directive.arguments||!directive.arguments.some((function(arg){return arg.name.value==="key"}))){console.warn("Removing an @connection directive even though it does not have a key. "+"You may want to use the key parameter to specify a store key.")}}return willRemove}};function removeConnectionDirectiveFromDocument(doc){checkDocument(doc);return removeDirectivesFromDocument([connectionRemoveConfig],doc)}function hasDirectivesInSelectionSet(directives,selectionSet,nestedCheck){if(nestedCheck===void 0){nestedCheck=true}if(!(selectionSet&&selectionSet.selections)){return false}var matchedSelections=selectionSet.selections.filter((function(selection){return hasDirectivesInSelection(directives,selection,nestedCheck)}));return matchedSelections.length>0}function hasDirectivesInSelection(directives,selection,nestedCheck){if(nestedCheck===void 0){nestedCheck=true}if(selection.kind!=="Field"||!selection){return true}if(!selection.directives){return false}var directiveMatcher=getDirectiveMatcher(directives);var matchedDirectives=selection.directives.filter(directiveMatcher);return matchedDirectives.length>0||nestedCheck&&hasDirectivesInSelectionSet(directives,selection.selectionSet,nestedCheck)}function getDirectivesFromSelectionSet(directives,selectionSet){selectionSet.selections=selectionSet.selections.filter((function(selection){return hasDirectivesInSelection(directives,selection,true)})).map((function(selection){if(hasDirectivesInSelection(directives,selection,false)){return selection}if((selection.kind==="Field"||selection.kind==="InlineFragment")&&selection.selectionSet){selection.selectionSet=getDirectivesFromSelectionSet(directives,selection.selectionSet)}return selection}));return selectionSet}function getDirectivesFromDocument(directives,doc,includeAllFragments){if(includeAllFragments===void 0){includeAllFragments=false}checkDocument(doc);var docClone=cloneDeep(doc);docClone.definitions=docClone.definitions.map((function(definition){if((definition.kind==="OperationDefinition"||definition.kind==="FragmentDefinition"&&!includeAllFragments)&&definition.selectionSet){definition.selectionSet=getDirectivesFromSelectionSet(directives,definition.selectionSet)}return definition}));var operation=getOperationDefinitionOrDie(docClone);var fragments=createFragmentMap(getFragmentDefinitions(docClone));return isNotEmpty(operation,fragments)?docClone:null}function getEnv(){if(typeof process!=="undefined"&&"production"){return"production"}return"development"}function isEnv(env){return getEnv()===env}function isProduction(){return isEnv("production")===true}function isDevelopment(){return isEnv("development")===true}function isTest(){return isEnv("test")===true}function tryFunctionOrLogError(f){try{return f()}catch(e){if(console.error){console.error(e)}}}function graphQLResultHasError(result){return result.errors&&result.errors.length}function isEqual(a,b){if(a===b){return true}if(a instanceof Date&&b instanceof Date){return a.getTime()===b.getTime()}if(a!=null&&typeof a==="object"&&b!=null&&typeof b==="object"){for(var key in a){if(Object.prototype.hasOwnProperty.call(a,key)){if(!Object.prototype.hasOwnProperty.call(b,key)){return false}if(!isEqual(a[key],b[key])){return false}}}for(var key in b){if(!Object.prototype.hasOwnProperty.call(a,key)){return false}}return true}return false}function deepFreeze(o){Object.freeze(o);Object.getOwnPropertyNames(o).forEach((function(prop){if(o[prop]!==null&&(typeof o[prop]==="object"||typeof o[prop]==="function")&&!Object.isFrozen(o[prop])){deepFreeze(o[prop])}}));return o}function maybeDeepFreeze(obj){if(isDevelopment()||isTest()){var symbolIsPolyfilled=typeof Symbol==="function"&&typeof Symbol("")==="string";if(!symbolIsPolyfilled){return deepFreeze(obj)}}return obj}var haveWarned=Object.create({});function warnOnceInDevelopment(msg,type){if(type===void 0){type="warn"}if(isProduction()){return}if(!haveWarned[msg]){if(!isTest()){haveWarned[msg]=true}switch(type){case"error":console.error(msg);break;default:console.warn(msg)}}}function stripSymbols(data){return JSON.parse(JSON.stringify(data))}exports.getDirectiveInfoFromField=getDirectiveInfoFromField;exports.shouldInclude=shouldInclude;exports.flattenSelections=flattenSelections;exports.getDirectiveNames=getDirectiveNames;exports.hasDirectives=hasDirectives;exports.getFragmentQueryDocument=getFragmentQueryDocument;exports.getMutationDefinition=getMutationDefinition;exports.checkDocument=checkDocument;exports.getOperationDefinition=getOperationDefinition;exports.getOperationDefinitionOrDie=getOperationDefinitionOrDie;exports.getOperationName=getOperationName;exports.getFragmentDefinitions=getFragmentDefinitions;exports.getQueryDefinition=getQueryDefinition;exports.getFragmentDefinition=getFragmentDefinition;exports.getMainDefinition=getMainDefinition;exports.createFragmentMap=createFragmentMap;exports.getDefaultValues=getDefaultValues;exports.variablesInOperation=variablesInOperation;exports.removeDirectivesFromDocument=removeDirectivesFromDocument;exports.addTypenameToDocument=addTypenameToDocument;exports.removeConnectionDirectiveFromDocument=removeConnectionDirectiveFromDocument;exports.getDirectivesFromDocument=getDirectivesFromDocument;exports.isScalarValue=isScalarValue;exports.isNumberValue=isNumberValue;exports.valueToObjectRepresentation=valueToObjectRepresentation;exports.storeKeyNameFromField=storeKeyNameFromField;exports.getStoreKeyName=getStoreKeyName;exports.argumentsObjectFromField=argumentsObjectFromField;exports.resultKeyNameFromField=resultKeyNameFromField;exports.isField=isField;exports.isInlineFragment=isInlineFragment;exports.isIdValue=isIdValue;exports.toIdValue=toIdValue;exports.isJsonValue=isJsonValue;exports.valueFromNode=valueFromNode;exports.assign=assign;exports.cloneDeep=cloneDeep;exports.getEnv=getEnv;exports.isEnv=isEnv;exports.isProduction=isProduction;exports.isDevelopment=isDevelopment;exports.isTest=isTest;exports.tryFunctionOrLogError=tryFunctionOrLogError;exports.graphQLResultHasError=graphQLResultHasError;exports.isEqual=isEqual;exports.maybeDeepFreeze=maybeDeepFreeze;exports.warnOnceInDevelopment=warnOnceInDevelopment;exports.stripSymbols=stripSymbols;Object.defineProperty(exports,"__esModule",{value:true})}))}).call(this,__webpack_require__(220))},function(module,exports,__webpack_require__){"use strict";module.exports=function(data,opts){if(!opts)opts={};if(typeof opts==="function")opts={cmp:opts};var cycles=typeof opts.cycles==="boolean"?opts.cycles:false;var cmp=opts.cmp&&function(f){return function(node){return function(a,b){var aobj={key:a,value:node[a]};var bobj={key:b,value:node[b]};return f(aobj,bobj)}}}(opts.cmp);var seen=[];return function stringify(node){if(node&&node.toJSON&&typeof node.toJSON==="function"){node=node.toJSON()}if(node===undefined)return;if(typeof node=="number")return isFinite(node)?""+node:"null";if(typeof node!=="object")return JSON.stringify(node);var i,out;if(Array.isArray(node)){out="[";for(i=0;i<node.length;i++){if(i)out+=",";out+=stringify(node[i])||"null"}return out+"]"}if(node===null)return"null";if(seen.indexOf(node)!==-1){if(cycles)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}var seenIndex=seen.push(node)-1;var keys=Object.keys(node).sort(cmp&&cmp(node));out="";for(i=0;i<keys.length;i++){var key=keys[i];var value=stringify(node[key]);if(!value)continue;if(out)out+=",";out+=JSON.stringify(key)+":"+value}seen.splice(seenIndex,1);return"{"+out+"}"}(data)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(80);var zenObservable_1=__webpack_require__(550);tslib_1.__exportStar(__webpack_require__(550),exports);exports.default=zenObservable_1.Observable},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.print=print;var _visitor=__webpack_require__(335);function print(ast){return(0,_visitor.visit)(ast,{leave:printDocASTReducer})}var printDocASTReducer={Name:function Name(node){return node.value},Variable:function Variable(node){return"$"+node.name},Document:function Document(node){return join(node.definitions,"\n\n")+"\n"},OperationDefinition:function OperationDefinition(node){var op=node.operation;var name=node.name;var varDefs=wrap("(",join(node.variableDefinitions,", "),")");var directives=join(node.directives," ");var selectionSet=node.selectionSet;return!name&&!directives&&!varDefs&&op==="query"?selectionSet:join([op,join([name,varDefs]),directives,selectionSet]," ")},VariableDefinition:function VariableDefinition(_ref){var variable=_ref.variable,type=_ref.type,defaultValue=_ref.defaultValue;return variable+": "+type+wrap(" = ",defaultValue)},SelectionSet:function SelectionSet(_ref2){var selections=_ref2.selections;return block(selections)},Field:function Field(_ref3){var alias=_ref3.alias,name=_ref3.name,args=_ref3.arguments,directives=_ref3.directives,selectionSet=_ref3.selectionSet;return join([wrap("",alias,": ")+name+wrap("(",join(args,", "),")"),join(directives," "),selectionSet]," ")},Argument:function Argument(_ref4){var name=_ref4.name,value=_ref4.value;return name+": "+value},FragmentSpread:function FragmentSpread(_ref5){var name=_ref5.name,directives=_ref5.directives;return"..."+name+wrap(" ",join(directives," "))},InlineFragment:function InlineFragment(_ref6){var typeCondition=_ref6.typeCondition,directives=_ref6.directives,selectionSet=_ref6.selectionSet;return join(["...",wrap("on ",typeCondition),join(directives," "),selectionSet]," ")},FragmentDefinition:function FragmentDefinition(_ref7){var name=_ref7.name,typeCondition=_ref7.typeCondition,variableDefinitions=_ref7.variableDefinitions,directives=_ref7.directives,selectionSet=_ref7.selectionSet;return"fragment "+name+wrap("(",join(variableDefinitions,", "),")")+" "+("on "+typeCondition+" "+wrap("",join(directives," ")," "))+selectionSet},IntValue:function IntValue(_ref8){var value=_ref8.value;return value},FloatValue:function FloatValue(_ref9){var value=_ref9.value;return value},StringValue:function StringValue(_ref10,key){var value=_ref10.value,isBlockString=_ref10.block;return isBlockString?printBlockString(value,key==="description"):JSON.stringify(value)},BooleanValue:function BooleanValue(_ref11){var value=_ref11.value;return value?"true":"false"},NullValue:function NullValue(){return"null"},EnumValue:function EnumValue(_ref12){var value=_ref12.value;return value},ListValue:function ListValue(_ref13){var values=_ref13.values;return"["+join(values,", ")+"]"},ObjectValue:function ObjectValue(_ref14){var fields=_ref14.fields;return"{"+join(fields,", ")+"}"},ObjectField:function ObjectField(_ref15){var name=_ref15.name,value=_ref15.value;return name+": "+value},Directive:function Directive(_ref16){var name=_ref16.name,args=_ref16.arguments;return"@"+name+wrap("(",join(args,", "),")")},NamedType:function NamedType(_ref17){var name=_ref17.name;return name},ListType:function ListType(_ref18){var type=_ref18.type;return"["+type+"]"},NonNullType:function NonNullType(_ref19){var type=_ref19.type;return type+"!"},SchemaDefinition:function SchemaDefinition(_ref20){var directives=_ref20.directives,operationTypes=_ref20.operationTypes;return join(["schema",join(directives," "),block(operationTypes)]," ")},OperationTypeDefinition:function OperationTypeDefinition(_ref21){var operation=_ref21.operation,type=_ref21.type;return operation+": "+type},ScalarTypeDefinition:addDescription((function(_ref22){var name=_ref22.name,directives=_ref22.directives;return join(["scalar",name,join(directives," ")]," ")})),ObjectTypeDefinition:addDescription((function(_ref23){var name=_ref23.name,interfaces=_ref23.interfaces,directives=_ref23.directives,fields=_ref23.fields;return join(["type",name,wrap("implements ",join(interfaces," & ")),join(directives," "),block(fields)]," ")})),FieldDefinition:addDescription((function(_ref24){var name=_ref24.name,args=_ref24.arguments,type=_ref24.type,directives=_ref24.directives;return name+wrap("(",join(args,", "),")")+": "+type+wrap(" ",join(directives," "))})),InputValueDefinition:addDescription((function(_ref25){var name=_ref25.name,type=_ref25.type,defaultValue=_ref25.defaultValue,directives=_ref25.directives;return join([name+": "+type,wrap("= ",defaultValue),join(directives," ")]," ")})),InterfaceTypeDefinition:addDescription((function(_ref26){var name=_ref26.name,directives=_ref26.directives,fields=_ref26.fields;return join(["interface",name,join(directives," "),block(fields)]," ")})),UnionTypeDefinition:addDescription((function(_ref27){var name=_ref27.name,directives=_ref27.directives,types=_ref27.types;return join(["union",name,join(directives," "),types&&types.length!==0?"= "+join(types," | "):""]," ")})),EnumTypeDefinition:addDescription((function(_ref28){var name=_ref28.name,directives=_ref28.directives,values=_ref28.values;return join(["enum",name,join(directives," "),block(values)]," ")})),EnumValueDefinition:addDescription((function(_ref29){var name=_ref29.name,directives=_ref29.directives;return join([name,join(directives," ")]," ")})),InputObjectTypeDefinition:addDescription((function(_ref30){var name=_ref30.name,directives=_ref30.directives,fields=_ref30.fields;return join(["input",name,join(directives," "),block(fields)]," ")})),ScalarTypeExtension:function ScalarTypeExtension(_ref31){var name=_ref31.name,directives=_ref31.directives;return join(["extend scalar",name,join(directives," ")]," ")},ObjectTypeExtension:function ObjectTypeExtension(_ref32){var name=_ref32.name,interfaces=_ref32.interfaces,directives=_ref32.directives,fields=_ref32.fields;return join(["extend type",name,wrap("implements ",join(interfaces," & ")),join(directives," "),block(fields)]," ")},InterfaceTypeExtension:function InterfaceTypeExtension(_ref33){var name=_ref33.name,directives=_ref33.directives,fields=_ref33.fields;return join(["extend interface",name,join(directives," "),block(fields)]," ")},UnionTypeExtension:function UnionTypeExtension(_ref34){var name=_ref34.name,directives=_ref34.directives,types=_ref34.types;return join(["extend union",name,join(directives," "),types&&types.length!==0?"= "+join(types," | "):""]," ")},EnumTypeExtension:function EnumTypeExtension(_ref35){var name=_ref35.name,directives=_ref35.directives,values=_ref35.values;return join(["extend enum",name,join(directives," "),block(values)]," ")},InputObjectTypeExtension:function InputObjectTypeExtension(_ref36){var name=_ref36.name,directives=_ref36.directives,fields=_ref36.fields;return join(["extend input",name,join(directives," "),block(fields)]," ")},DirectiveDefinition:addDescription((function(_ref37){var name=_ref37.name,args=_ref37.arguments,locations=_ref37.locations;return"directive @"+name+wrap("(",join(args,", "),")")+" on "+join(locations," | ")}))};function addDescription(cb){return function(node){return join([node.description,cb(node)],"\n")}}function join(maybeArray,separator){return maybeArray?maybeArray.filter((function(x){return x})).join(separator||""):""}function block(array){return array&&array.length!==0?"{\n"+indent(join(array,"\n"))+"\n}":""}function wrap(start,maybeString,end){return maybeString?start+maybeString+(end||""):""}function indent(maybeString){return maybeString&&"  "+maybeString.replace(/\n/g,"\n  ")}function printBlockString(value,isDescription){var escaped=value.replace(/"""/g,'\\"""');return(value[0]===" "||value[0]==="\t")&&value.indexOf("\n")===-1?'"""'+escaped.replace(/"$/,'"\n')+'"""':'"""\n'+(isDescription?escaped:indent(escaped))+'\n"""'}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.visit=visit;exports.visitInParallel=visitInParallel;exports.visitWithTypeInfo=visitWithTypeInfo;exports.getVisitFn=getVisitFn;var QueryDocumentKeys=exports.QueryDocumentKeys={Name:[],Document:["definitions"],OperationDefinition:["name","variableDefinitions","directives","selectionSet"],VariableDefinition:["variable","type","defaultValue"],Variable:["name"],SelectionSet:["selections"],Field:["alias","name","arguments","directives","selectionSet"],Argument:["name","value"],FragmentSpread:["name","directives"],InlineFragment:["typeCondition","directives","selectionSet"],FragmentDefinition:["name","variableDefinitions","typeCondition","directives","selectionSet"],IntValue:[],FloatValue:[],StringValue:[],BooleanValue:[],NullValue:[],EnumValue:[],ListValue:["values"],ObjectValue:["fields"],ObjectField:["name","value"],Directive:["name","arguments"],NamedType:["name"],ListType:["type"],NonNullType:["type"],SchemaDefinition:["directives","operationTypes"],OperationTypeDefinition:["type"],ScalarTypeDefinition:["description","name","directives"],ObjectTypeDefinition:["description","name","interfaces","directives","fields"],FieldDefinition:["description","name","arguments","type","directives"],InputValueDefinition:["description","name","type","defaultValue","directives"],InterfaceTypeDefinition:["description","name","directives","fields"],UnionTypeDefinition:["description","name","directives","types"],EnumTypeDefinition:["description","name","directives","values"],EnumValueDefinition:["description","name","directives"],InputObjectTypeDefinition:["description","name","directives","fields"],ScalarTypeExtension:["name","directives"],ObjectTypeExtension:["name","interfaces","directives","fields"],InterfaceTypeExtension:["name","directives","fields"],UnionTypeExtension:["name","directives","types"],EnumTypeExtension:["name","directives","values"],InputObjectTypeExtension:["name","directives","fields"],DirectiveDefinition:["description","name","arguments","locations"]};var BREAK=exports.BREAK={};function visit(root,visitor){var visitorKeys=arguments.length>2&&arguments[2]!==undefined?arguments[2]:QueryDocumentKeys;var stack=undefined;var inArray=Array.isArray(root);var keys=[root];var index=-1;var edits=[];var node=undefined;var key=undefined;var parent=undefined;var path=[];var ancestors=[];var newRoot=root;do{index++;var isLeaving=index===keys.length;var isEdited=isLeaving&&edits.length!==0;if(isLeaving){key=ancestors.length===0?undefined:path[path.length-1];node=parent;parent=ancestors.pop();if(isEdited){if(inArray){node=node.slice()}else{var clone={};for(var k in node){if(node.hasOwnProperty(k)){clone[k]=node[k]}}node=clone}var editOffset=0;for(var ii=0;ii<edits.length;ii++){var editKey=edits[ii][0];var editValue=edits[ii][1];if(inArray){editKey-=editOffset}if(inArray&&editValue===null){node.splice(editKey,1);editOffset++}else{node[editKey]=editValue}}}index=stack.index;keys=stack.keys;edits=stack.edits;inArray=stack.inArray;stack=stack.prev}else{key=parent?inArray?index:keys[index]:undefined;node=parent?parent[key]:newRoot;if(node===null||node===undefined){continue}if(parent){path.push(key)}}var result=void 0;if(!Array.isArray(node)){if(!isNode(node)){throw new Error("Invalid AST Node: "+JSON.stringify(node))}var visitFn=getVisitFn(visitor,node.kind,isLeaving);if(visitFn){result=visitFn.call(visitor,node,key,parent,path,ancestors);if(result===BREAK){break}if(result===false){if(!isLeaving){path.pop();continue}}else if(result!==undefined){edits.push([key,result]);if(!isLeaving){if(isNode(result)){node=result}else{path.pop();continue}}}}}if(result===undefined&&isEdited){edits.push([key,node])}if(isLeaving){path.pop()}else{stack={inArray:inArray,index:index,keys:keys,edits:edits,prev:stack};inArray=Array.isArray(node);keys=inArray?node:visitorKeys[node.kind]||[];index=-1;edits=[];if(parent){ancestors.push(parent)}parent=node}}while(stack!==undefined);if(edits.length!==0){newRoot=edits[edits.length-1][1]}return newRoot}function isNode(maybeNode){return Boolean(maybeNode&&typeof maybeNode.kind==="string")}function visitInParallel(visitors){var skipping=new Array(visitors.length);return{enter:function enter(node){for(var i=0;i<visitors.length;i++){if(!skipping[i]){var fn=getVisitFn(visitors[i],node.kind,false);if(fn){var result=fn.apply(visitors[i],arguments);if(result===false){skipping[i]=node}else if(result===BREAK){skipping[i]=BREAK}else if(result!==undefined){return result}}}}},leave:function leave(node){for(var i=0;i<visitors.length;i++){if(!skipping[i]){var fn=getVisitFn(visitors[i],node.kind,true);if(fn){var result=fn.apply(visitors[i],arguments);if(result===BREAK){skipping[i]=BREAK}else if(result!==undefined&&result!==false){return result}}}else if(skipping[i]===node){skipping[i]=null}}}}}function visitWithTypeInfo(typeInfo,visitor){return{enter:function enter(node){typeInfo.enter(node);var fn=getVisitFn(visitor,node.kind,false);if(fn){var result=fn.apply(visitor,arguments);if(result!==undefined){typeInfo.leave(node);if(isNode(result)){typeInfo.enter(result)}}return result}},leave:function leave(node){var fn=getVisitFn(visitor,node.kind,true);var result=void 0;if(fn){result=fn.apply(visitor,arguments)}typeInfo.leave(node);return result}}}function getVisitFn(visitor,kind,isLeaving){var kindVisitor=visitor[kind];if(kindVisitor){if(!isLeaving&&typeof kindVisitor==="function"){return kindVisitor}var kindSpecificVisitor=isLeaving?kindVisitor.leave:kindVisitor.enter;if(typeof kindSpecificVisitor==="function"){return kindSpecificVisitor}}else{var specificVisitor=isLeaving?visitor.leave:visitor.enter;if(specificVisitor){if(typeof specificVisitor==="function"){return specificVisitor}var specificKindVisitor=specificVisitor[kind];if(typeof specificKindVisitor==="function"){return specificKindVisitor}}}}},,,,,,,,,,,,,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ActionIconItem}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _styles__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(140);var _helpers__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(119);const ActionIconItemComponent=({width:width=_helpers__WEBPACK_IMPORTED_MODULE_3__["d"],dataTestSubj:dataTestSubj,content:content,ariaLabel:ariaLabel,iconType:iconType="",isDisabled:isDisabled=false,onClick:onClick,children:children})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_styles__WEBPACK_IMPORTED_MODULE_2__["l"],{textAlign:"center",width:width},children!==null&&children!==void 0?children:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiToolTip"],{"data-test-subj":`${dataTestSubj}-tool-tip`,content:content},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiButtonIcon"],{"aria-label":ariaLabel,"data-test-subj":`${dataTestSubj}-button`,iconType:iconType,isDisabled:isDisabled,onClick:onClick}))));ActionIconItemComponent.displayName="ActionIconItemComponent";const ActionIconItem=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(ActionIconItemComponent)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Direction}));let Direction;(function(Direction){Direction["asc"]="asc";Direction["desc"]="desc"})(Direction||(Direction={}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useDraggableKeyboardWrapper}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _hooks_use_add_to_timeline__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(445);var _helpers__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(116);const useDraggableKeyboardWrapper=({closePopover:closePopover,draggableId:draggableId,fieldName:fieldName,keyboardHandlerRef:keyboardHandlerRef,openPopover:openPopover})=>{const{beginDrag:beginDrag,cancelDrag:cancelDrag,dragToLocation:dragToLocation,endDrag:endDrag,hasDraggableLock:hasDraggableLock}=Object(_hooks_use_add_to_timeline__WEBPACK_IMPORTED_MODULE_1__["a"])({draggableId:draggableId,fieldName:fieldName});const[dragActions,setDragActions]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);const cancelDragActions=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(()=>{setDragActions(prevDragAction=>{if(prevDragAction){cancelDrag(prevDragAction);return null}return prevDragAction})},[cancelDrag]);const onKeyDown=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(keyboardEvent=>{const draggableElement=document.querySelector(`[data-rbd-drag-handle-draggable-id="${draggableId}"]`);if(draggableElement){var _keyboardHandlerRef$c;if(hasDraggableLock()||!hasDraggableLock()&&keyboardEvent.key===" "){keyboardEvent.preventDefault();keyboardEvent.stopPropagation()}Object(_helpers__WEBPACK_IMPORTED_MODULE_2__["i"])({beginDrag:beginDrag,cancelDragActions:cancelDragActions,closePopover:closePopover,dragActions:dragActions,draggableElement:draggableElement,dragToLocation:dragToLocation,endDrag:endDrag,keyboardEvent:keyboardEvent,openPopover:openPopover,setDragActions:setDragActions});(_keyboardHandlerRef$c=keyboardHandlerRef.current)===null||_keyboardHandlerRef$c===void 0?void 0:_keyboardHandlerRef$c.focus()}},[beginDrag,cancelDragActions,closePopover,dragActions,draggableId,dragToLocation,endDrag,hasDraggableLock,keyboardHandlerRef,openPopover,setDragActions]);const memoizedReturn=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({onBlur:cancelDragActions,onKeyDown:onKeyDown}),[cancelDragActions,onKeyDown]);return memoizedReturn}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return LocalizedDateTooltip}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(74);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__);var moment__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(27);var moment__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_2__);var react__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);const LocalizedDateTooltip=react__WEBPACK_IMPORTED_MODULE_3___default.a.memo(({children:children,date:date,fieldName:fieldName,className:className=""})=>react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiToolTip"],{"data-test-subj":"localized-date-tool-tip",anchorClassName:className,content:react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexGroup"],{"data-test-subj":"dates-container",direction:"column",gutterSize:"none"},fieldName!=null?react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement("span",{"data-test-subj":"field-name"},fieldName)):null,react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{grow:false},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_1__["FormattedRelative"],{"data-test-subj":"humanized-relative-date",value:moment__WEBPACK_IMPORTED_MODULE_2___default.a.utc(date).toDate()})),react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{"data-test-subj":"with-day-of-week",grow:false},moment__WEBPACK_IMPORTED_MODULE_2___default.a.utc(date).local().format("llll")),react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiFlexItem"],{"data-test-subj":"with-time-zone-offset-in-hours",grow:false},moment__WEBPACK_IMPORTED_MODULE_2___default()(date).format()))},react__WEBPACK_IMPORTED_MODULE_3___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_3___default.a.Fragment,null,children)));LocalizedDateTooltip.displayName="LocalizedDateTooltip"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return WrappedByAutoSizer}));__webpack_require__.d(__webpack_exports__,"f",(function(){return useTheme}));__webpack_require__.d(__webpack_exports__,"b",(function(){return chartDefaultSettings}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getChartHeight}));__webpack_require__.d(__webpack_exports__,"e",(function(){return getChartWidth}));__webpack_require__.d(__webpack_exports__,"c",(function(){return checkIfAllValuesAreZero}));var _elastic_charts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(84);var _elastic_charts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_charts__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var _common_constants__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(2);var _lib_kibana__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(104);const defaultChartHeight="100%";const defaultChartWidth="100%";const chartDefaultRotation=0;const chartDefaultRendering="canvas";const WrappedByAutoSizerComponent=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.div.withConfig({displayName:"WrappedByAutoSizerComponent",componentId:"k085ek-0"})([""," position:relative;&:hover{z-index:100;}"],style=>`\n    height: ${style.height!=null?style.height:defaultChartHeight};\n  `);WrappedByAutoSizerComponent.displayName="WrappedByAutoSizer";const WrappedByAutoSizer=react__WEBPACK_IMPORTED_MODULE_1___default.a.memo(WrappedByAutoSizerComponent);let SeriesType;(function(SeriesType){SeriesType["BAR"]="bar";SeriesType["AREA"]="area";SeriesType["LINE"]="line"})(SeriesType||(SeriesType={}));const theme={chartMargins:{left:0,right:0,top:4,bottom:0},chartPaddings:{left:0,right:0,top:0,bottom:0},scales:{barsPadding:.05}};const useTheme=()=>{const isDarkMode=Object(_lib_kibana__WEBPACK_IMPORTED_MODULE_4__["k"])(_common_constants__WEBPACK_IMPORTED_MODULE_3__["q"]);const defaultTheme=isDarkMode?_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["DARK_THEME"]:_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["LIGHT_THEME"];const themeValue=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>Object(_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["mergeWithDefaultTheme"])(theme,defaultTheme),[]);return themeValue};const chartDefaultSettings={rotation:chartDefaultRotation,rendering:chartDefaultRendering,animatedData:false,showLegend:false,showLegendExtra:false,debug:false,legendPosition:_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["Position"].Bottom};const getChartHeight=(customHeight,autoSizerHeight)=>{const height=customHeight||autoSizerHeight;return height?`${height}px`:defaultChartHeight};const getChartWidth=(customWidth,autoSizerWidth)=>{const height=customWidth||autoSizerWidth;return height?`${height}px`:defaultChartWidth};const checkIfAllValuesAreZero=data=>Array.isArray(data)&&data.every(series=>Array.isArray(series.value)&&series.value.every(({y:y})=>y===0))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"updateTableActivePage",(function(){return updateTableActivePage}));__webpack_require__.d(__webpack_exports__,"setHostTablesActivePageToZero",(function(){return setHostTablesActivePageToZero}));__webpack_require__.d(__webpack_exports__,"setHostDetailsTablesActivePageToZero",(function(){return setHostDetailsTablesActivePageToZero}));__webpack_require__.d(__webpack_exports__,"updateTableLimit",(function(){return updateTableLimit}));__webpack_require__.d(__webpack_exports__,"updateHostsSort",(function(){return updateHostsSort}));var typescript_fsa__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(42);var typescript_fsa__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(typescript_fsa__WEBPACK_IMPORTED_MODULE_0__);const actionCreator=typescript_fsa__WEBPACK_IMPORTED_MODULE_0___default()("x-pack/security_solution/local/hosts");const updateTableActivePage=actionCreator("UPDATE_HOST_TABLE_ACTIVE_PAGE");const setHostTablesActivePageToZero=actionCreator("SET_HOST_TABLES_ACTIVE_PAGE_TO_ZERO");const setHostDetailsTablesActivePageToZero=actionCreator("SET_HOST_DETAILS_TABLES_ACTIVE_PAGE_TO_ZERO");const updateTableLimit=actionCreator("UPDATE_HOST_TABLE_LIMIT");const updateHostsSort=actionCreator("UPDATE_HOSTS_SORT")},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return DEFAULT_TABLE_LIMIT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DEFAULT_TABLE_ACTIVE_PAGE}));const DEFAULT_TABLE_LIMIT=10;const DEFAULT_TABLE_ACTIVE_PAGE=0},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return HostsKpiChartColors}));let HostsKpiChartColors;(function(HostsKpiChartColors){HostsKpiChartColors["authenticationsSuccess"]="#54B399";HostsKpiChartColors["authenticationsFailure"]="#E7664C";HostsKpiChartColors["uniqueSourceIps"]="#D36086";HostsKpiChartColors["uniqueDestinationIps"]="#9170B8";HostsKpiChartColors["hosts"]="#6092C0"})(HostsKpiChartColors||(HostsKpiChartColors={}))},function(module,__webpack_exports__,__webpack_require__){"use strict";var _events__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(650);if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"FlowTarget"))__webpack_require__.d(__webpack_exports__,"FlowTarget",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["FlowTarget"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"FlowTargetSourceDest"))__webpack_require__.d(__webpack_exports__,"FlowTargetSourceDest",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["FlowTargetSourceDest"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"HostsKpiQueries"))__webpack_require__.d(__webpack_exports__,"HostsKpiQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["HostsKpiQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"HostsQueries"))__webpack_require__.d(__webpack_exports__,"HostsQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["HostsQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"LastEventIndexKey"))__webpack_require__.d(__webpack_exports__,"LastEventIndexKey",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["LastEventIndexKey"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkDirectionEcs"))__webpack_require__.d(__webpack_exports__,"NetworkDirectionEcs",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkDirectionEcs"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkDnsFields"))__webpack_require__.d(__webpack_exports__,"NetworkDnsFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkDnsFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkHttpFields"))__webpack_require__.d(__webpack_exports__,"NetworkHttpFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkHttpFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkKpiQueries"))__webpack_require__.d(__webpack_exports__,"NetworkKpiQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkKpiQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkQueries"))__webpack_require__.d(__webpack_exports__,"NetworkQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkQueries"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkTlsFields"))__webpack_require__.d(__webpack_exports__,"NetworkTlsFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkTlsFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkTopTablesFields"))__webpack_require__.d(__webpack_exports__,"NetworkTopTablesFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkTopTablesFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"NetworkUsersFields"))__webpack_require__.d(__webpack_exports__,"NetworkUsersFields",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["NetworkUsersFields"]}));if(__webpack_require__.o(_events__WEBPACK_IMPORTED_MODULE_0__,"TimelineEventsQueries"))__webpack_require__.d(__webpack_exports__,"TimelineEventsQueries",(function(){return _events__WEBPACK_IMPORTED_MODULE_0__["TimelineEventsQueries"]}))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return EVENT_DURATION_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"a",(function(){return Duration}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _common_components_draggables__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(115);var _formatted_duration__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(801);const EVENT_DURATION_FIELD_NAME="event.duration";const Duration=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(({contextId:contextId,eventId:eventId,fieldName:fieldName,value:value})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_common_components_draggables__WEBPACK_IMPORTED_MODULE_1__["b"],{id:`duration-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,name:name,field:fieldName,tooltipContent:null,value:value},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_formatted_duration__WEBPACK_IMPORTED_MODULE_2__["a"],{maybeDurationNanoseconds:value,tooltipTitle:fieldName})));Duration.displayName="Duration"},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return isUrlInvalid}));var lodash_fp__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var lodash_fp__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash_fp__WEBPACK_IMPORTED_MODULE_0__);const urlExpression=/(https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|www\.[a-zA-Z0-9][a-zA-Z0-9-]+[a-zA-Z0-9]\.[^\s]{2,}|https?:\/\/(?:www\.|(?!www))[a-zA-Z0-9]+\.[^\s]{2,}|www\.[a-zA-Z0-9]+\.[^\s]{2,})/gi;const isUrlInvalid=url=>{if(!Object(lodash_fp__WEBPACK_IMPORTED_MODULE_0__["isEmpty"])(url)&&url!=null&&url.match(urlExpression)==null){return true}return false}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return NETWORK_BYTES_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"b",(function(){return NETWORK_COMMUNITY_ID_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"c",(function(){return NETWORK_DIRECTION_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"d",(function(){return NETWORK_PACKETS_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"e",(function(){return NETWORK_PROTOCOL_FIELD_NAME}));__webpack_require__.d(__webpack_exports__,"f",(function(){return NETWORK_TRANSPORT_FIELD_NAME}));const NETWORK_BYTES_FIELD_NAME="network.bytes";const NETWORK_COMMUNITY_ID_FIELD_NAME="network.community_id";const NETWORK_DIRECTION_FIELD_NAME="network.direction";const NETWORK_PACKETS_FIELD_NAME="network.packets";const NETWORK_PROTOCOL_FIELD_NAME="network.protocol";const NETWORK_TRANSPORT_FIELD_NAME="network.transport"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return SUMMARY}));__webpack_require__.d(__webpack_exports__,"d",(function(){return INVESTIGATION_GUIDE}));__webpack_require__.d(__webpack_exports__,"i",(function(){return TABLE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return JSON_VIEW}));__webpack_require__.d(__webpack_exports__,"c",(function(){return FIELD}));__webpack_require__.d(__webpack_exports__,"j",(function(){return VALUE}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DESCRIPTION}));__webpack_require__.d(__webpack_exports__,"a",(function(){return BLANK}));__webpack_require__.d(__webpack_exports__,"g",(function(){return PLACEHOLDER}));__webpack_require__.d(__webpack_exports__,"k",(function(){return VIEW_COLUMN}));__webpack_require__.d(__webpack_exports__,"f",(function(){return NESTED_COLUMN}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const SUMMARY=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.alertDetails.summary",{defaultMessage:"Summary"});const INVESTIGATION_GUIDE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.alertDetails.summary.investigationGuide",{defaultMessage:"Investigation guide"});const TABLE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.table",{defaultMessage:"Table"});const JSON_VIEW=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.jsonView",{defaultMessage:"JSON View"});const FIELD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.field",{defaultMessage:"Field"});const VALUE=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.value",{defaultMessage:"Value"});const DESCRIPTION=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.description",{defaultMessage:"Description"});const BLANK=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.blank",{defaultMessage:" "});const PLACEHOLDER=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.filter.placeholder",{defaultMessage:"Filter by Field, Value, or Description..."});const COPY_TO_CLIPBOARD=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.copyToClipboard",{defaultMessage:"Copy to Clipboard"});const VIEW_COLUMN=field=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.viewColumnCheckboxAriaLabel",{values:{field:field},defaultMessage:"View {field} column"});const NESTED_COLUMN=field=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.eventDetails.nestedColumnCheckboxAriaLabel",{values:{field:field},defaultMessage:"The {field} field is an object, and is broken down into nested fields which can be added as column"})},,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return isOperator}));__webpack_require__.d(__webpack_exports__,"f",(function(){return isNotOperator}));__webpack_require__.d(__webpack_exports__,"g",(function(){return isOneOfOperator}));__webpack_require__.d(__webpack_exports__,"e",(function(){return existsOperator}));__webpack_require__.d(__webpack_exports__,"d",(function(){return doesNotExistOperator}));__webpack_require__.d(__webpack_exports__,"a",(function(){return EXCEPTION_OPERATORS}));__webpack_require__.d(__webpack_exports__,"c",(function(){return EXCEPTION_OPERATORS_SANS_LISTS}));__webpack_require__.d(__webpack_exports__,"b",(function(){return EXCEPTION_OPERATORS_ONLY_LISTS}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);var _lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(161);const isOperator={message:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.isOperatorLabel",{defaultMessage:"is"}),value:"is",type:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["c"].MATCH,operator:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["b"].INCLUDED};const isNotOperator={message:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.isNotOperatorLabel",{defaultMessage:"is not"}),value:"is_not",type:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["c"].MATCH,operator:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["b"].EXCLUDED};const isOneOfOperator={message:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.isOneOfOperatorLabel",{defaultMessage:"is one of"}),value:"is_one_of",type:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["c"].MATCH_ANY,operator:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["b"].INCLUDED};const isNotOneOfOperator={message:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.securitySolution.exceptions.isNotOneOfOperatorLabel",{defaultMessage:"is not one of"}),value:"is_not_one_of",type:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["c"].MATCH_ANY,operator:_lists_plugin_deps__WEBPACK_IMPORTED_MODULE_1__["b"].EXCLUDED};const existsOper