/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["securitySolution_bundle_jsonpfunction"]=window["securitySolution_bundle_jsonpfunction"]||[]).push([[6],{399:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return metadataCurrentIndexPattern}));__webpack_require__.d(__webpack_exports__,"c",(function(){return TRUSTED_APPS_LIST_API}));__webpack_require__.d(__webpack_exports__,"a",(function(){return TRUSTED_APPS_CREATE_API}));__webpack_require__.d(__webpack_exports__,"b",(function(){return TRUSTED_APPS_DELETE_API}));__webpack_require__.d(__webpack_exports__,"d",(function(){return TRUSTED_APPS_SUMMARY_API}));const eventsIndexPattern="logs-endpoint.events.*";const alertsIndexPattern="logs-endpoint.alerts-*";const metadataIndexPattern="metrics-endpoint.metadata-*";const metadataCurrentIndexPattern="metrics-endpoint.metadata_current_*";const metadataTransformPrefix="endpoint.metadata_current-default";const policyIndexPattern="metrics-endpoint.policy-*";const telemetryIndexPattern="metrics-endpoint.telemetry-*";const LIMITED_CONCURRENCY_ENDPOINT_ROUTE_TAG="endpoint:limited-concurrency";const LIMITED_CONCURRENCY_ENDPOINT_COUNT=100;const TRUSTED_APPS_LIST_API="/api/endpoint/trusted_apps";const TRUSTED_APPS_CREATE_API="/api/endpoint/trusted_apps";const TRUSTED_APPS_DELETE_API="/api/endpoint/trusted_apps/{id}";const TRUSTED_APPS_SUMMARY_API="/api/endpoint/trusted_apps/summary";const BASE_POLICY_RESPONSE_ROUTE=`/api/endpoint/policy_response`;const BASE_POLICY_ROUTE=`/api/endpoint/policy`;const AGENT_POLICY_SUMMARY_ROUTE=`${BASE_POLICY_ROUTE}/summaries`},502:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return initialPolicyDetailsState}));__webpack_require__.d(__webpack_exports__,"b",(function(){return policyDetailsReducer}));var _selectors__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(172);const updatePolicyConfigInPolicyData=(policyData,policyConfig)=>({...policyData,inputs:policyData.inputs.map(input=>({...input,config:input.config&&{...input.config,policy:{...input.config.policy,value:policyConfig}}}))});const initialPolicyDetailsState=()=>({policyItem:undefined,isLoading:false,agentStatusSummary:{error:0,events:0,offline:0,online:0,total:0,other:0}});const policyDetailsReducer=(state=initialPolicyDetailsState(),action)=>{if(action.type==="serverReturnedPolicyDetailsData"||action.type==="serverReturnedUpdatedPolicyDetailsData"){return{...state,...action.payload,isLoading:false}}if(action.type==="serverFailedToReturnPolicyDetailsData"){return{...state,isLoading:false,apiError:action.payload}}if(action.type==="serverReturnedPolicyDetailsAgentSummaryData"){return{...state,...action.payload}}if(action.type==="serverReturnedPolicyDetailsUpdateFailure"){return{...state,isLoading:false,updateStatus:action.payload}}if(action.type==="userClickedPolicyDetailsSaveButton"){return{...state,isLoading:true,updateApiError:undefined}}if(action.type==="licenseChanged"){return{...state,license:action.payload}}if(action.type==="userChangedUrl"){const newState={...state,location:action.payload};const isCurrentlyOnDetailsPage=Object(_selectors__WEBPACK_IMPORTED_MODULE_0__["g"])(newState);const wasPreviouslyOnDetailsPage=Object(_selectors__WEBPACK_IMPORTED_MODULE_0__["g"])(state);const currentLicense=Object(_selectors__WEBPACK_IMPORTED_MODULE_0__["h"])(newState);if(isCurrentlyOnDetailsPage){if(!wasPreviouslyOnDetailsPage){return{...newState,isLoading:true}}return newState}return{...initialPolicyDetailsState(),location:action.payload,license:currentLicense}}if(action.type==="userChangedPolicyConfig"){if(!state.policyItem){return state}const newState={...state,policyItem:{...state.policyItem}};const newPolicy={...Object(_selectors__WEBPACK_IMPORTED_MODULE_0__["c"])(state)};newState.policyItem.inputs[0].config.policy.value=newPolicy;Object.entries(action.payload.policyConfig).forEach(([section,newSettings])=>{newPolicy[section]={...newPolicy[section],...newSettings}});return newState}if(action.type==="userChangedAntivirusRegistration"){if(state.policyItem){const policyConfig=Object(_selectors__WEBPACK_IMPORTED_MODULE_0__["c"])(state);return{...state,policyItem:updatePolicyConfigInPolicyData(state.policyItem,{...policyConfig,windows:{...policyConfig.windows,antivirus_registration:{enabled:action.payload.enabled}}})}}else{return state}}return state}},517:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return service_TrustedAppsHttpService}));var constants=__webpack_require__(399);const resolvePathVariables=(path,variables)=>Object.keys(variables).reduce((acc,paramName)=>acc.replace(new RegExp(`{${paramName}}`,"g"),String(variables[paramName])),path);class service_TrustedAppsHttpService{constructor(http){this.http=http}async getTrustedAppsList(request){return this.http.get(constants["c"],{query:request})}async deleteTrustedApp(request){return this.http.delete(resolvePathVariables(constants["b"],request))}async createTrustedApp(request){return this.http.post(constants["a"],{body:JSON.stringify(request)})}async getTrustedAppsSummary(){return this.http.get(constants["d"])}}},742:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return CurrentLicense}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_redux__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(105);var react_redux__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_redux__WEBPACK_IMPORTED_MODULE_1__);var _hooks_use_license__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(33);const CurrentLicense=Object(react__WEBPACK_IMPORTED_MODULE_0__["memo"])(({children:children})=>{const dispatch=Object(react_redux__WEBPACK_IMPORTED_MODULE_1__["useDispatch"])();Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{var _licenseService$getLi;const subscription=(_licenseService$getLi=_hooks_use_license__WEBPACK_IMPORTED_MODULE_2__["a"].getLicenseInformation$())===null||_licenseService$getLi===void 0?void 0:_licenseService$getLi.subscribe(licenseInformation=>{dispatch({type:"licenseChanged",payload:licenseInformation})});return()=>subscription===null||subscription===void 0?void 0:subscription.unsubscribe()},[dispatch]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,children)});CurrentLicense.displayName="CurrentLicense"},743:function(module,exports){},757:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return managementMiddlewareFactory}));var common_store=__webpack_require__(122);var constants=__webpack_require__(121);var policy_config=__webpack_require__(277);var selectors=__webpack_require__(172);var common_=__webpack_require__(87);const INGEST_API_ROOT=`/api/fleet`;const INGEST_API_PACKAGE_POLICIES=`${INGEST_API_ROOT}/package_policies`;const INGEST_API_AGENT_POLICIES=`${INGEST_API_ROOT}/agent_policies`;const INGEST_API_FLEET_AGENT_STATUS=`${INGEST_API_ROOT}/agent-status`;const INGEST_API_FLEET_AGENTS=`${INGEST_API_ROOT}/agents`;const INGEST_API_EPM_PACKAGES=`${INGEST_API_ROOT}/epm/packages`;const INGEST_API_DELETE_PACKAGE_POLICY=`${INGEST_API_PACKAGE_POLICIES}/delete`;const sendGetEndpointSpecificPackagePolicies=(http,options={})=>{var _options$query;return http.get(INGEST_API_PACKAGE_POLICIES,{...options,query:{...options.query,kuery:`${options!==null&&options!==void 0&&(_options$query=options.query)!==null&&_options$query!==void 0&&_options$query.kuery?`${options.query.kuery} and `:""}${common_["PACKAGE_POLICY_SAVED_OBJECT_TYPE"]}.package.name: endpoint`}})};const sendGetPackagePolicy=(http,packagePolicyId,options)=>http.get(`${INGEST_API_PACKAGE_POLICIES}/${packagePolicyId}`,options);const sendDeletePackagePolicy=(http,body,options)=>http.post(INGEST_API_DELETE_PACKAGE_POLICY,{...options,body:JSON.stringify(body.body)});const sendGetAgentPolicyList=(http,options)=>http.get(INGEST_API_AGENT_POLICIES,options);const sendPutPackagePolicy=(http,packagePolicyId,packagePolicy,options={})=>http.put(`${INGEST_API_PACKAGE_POLICIES}/${packagePolicyId}`,{...options,body:JSON.stringify(packagePolicy)});const sendGetFleetAgentStatusForPolicy=(http,policyId,options={})=>http.get(INGEST_API_FLEET_AGENT_STATUS,{...options,query:{policyId:policyId}});const sendGetFleetAgentsWithEndpoint=(http,options={})=>http.get(INGEST_API_FLEET_AGENTS,{...options,query:{page:1,perPage:1,kuery:'fleet-agents.packages : "endpoint"'}});const sendGetEndpointSecurityPackage=async http=>{const options={query:{category:"security"}};const securityPackages=await http.get(INGEST_API_EPM_PACKAGES,options);const endpointPackageInfo=securityPackages.response.find(epmPackage=>epmPackage.name==="endpoint");if(!endpointPackageInfo){throw new Error("Endpoint package was not found.")}return endpointPackageInfo};const policyDetailsMiddlewareFactory=coreStart=>{const http=coreStart.http;return({getState:getState,dispatch:dispatch})=>next=>async action=>{next(action);const state=getState();if(action.type==="userChangedUrl"&&Object(selectors["g"])(state)){const id=Object(selectors["l"])(state);let policyItem;try{policyItem=(await sendGetPackagePolicy(http,id)).item;if(policyItem.inputs[0].config.policy.value.windows.popup.malware.message===""){policyItem.inputs[0].config.policy.value.windows.popup.malware.message=policy_config["a"];policyItem.inputs[0].config.policy.value.mac.popup.malware.message=policy_config["a"]}if(policyItem.inputs[0].config.policy.value.windows.popup.ransomware.message===""){policyItem.inputs[0].config.policy.value.windows.popup.ransomware.message=policy_config["a"]}}catch(error){dispatch({type:"serverFailedToReturnPolicyDetailsData",payload:error.body||error});return}dispatch({type:"serverReturnedPolicyDetailsData",payload:{policyItem:policyItem}});if(policyItem.policy_id){const{results:results}=await sendGetFleetAgentStatusForPolicy(http,policyItem.policy_id);dispatch({type:"serverReturnedPolicyDetailsAgentSummaryData",payload:{agentStatusSummary:results}})}}else if(action.type==="userClickedPolicyDetailsSaveButton"){const{id:id}=Object(selectors["j"])(state);const updatedPolicyItem=Object(selectors["k"])(state);let apiResponse;try{apiResponse=await sendPutPackagePolicy(http,id,updatedPolicyItem).catch(error=>{if(!error.response||error.response.status!==409){return Promise.reject(error)}return sendGetPackagePolicy(http,id).then(packagePolicy=>{const latestUpdatedPolicyItem=packagePolicy.item;latestUpdatedPolicyItem.inputs[0].config.policy=updatedPolicyItem.inputs[0].config.policy;return sendPutPackagePolicy(http,id,Object(selectors["d"])(latestUpdatedPolicyItem))})})}catch(error){dispatch({type:"serverReturnedPolicyDetailsUpdateFailure",payload:{success:false,error:error.body||error}});return}dispatch({type:"serverReturnedUpdatedPolicyDetailsData",payload:{policyItem:apiResponse.item,updateStatus:{success:true}}})}}};var policy_details_action=__webpack_require__(743);var reducer=__webpack_require__(502);var store_selectors=__webpack_require__(232);var endpoint_constants=__webpack_require__(399);const endpointMiddlewareFactory=(coreStart,depsStart)=>{async function fetchIndexPatterns(){const{indexPatterns:indexPatterns}=depsStart.data;const fields=await indexPatterns.getFieldsForWildcard({pattern:endpoint_constants["e"]});const indexPattern={title:endpoint_constants["e"],fields:fields};return[indexPattern]}return({getState:getState,dispatch:dispatch})=>next=>async action=>{next(action);if((action.type==="userChangedUrl"||action.type==="appRequestedEndpointList")&&Object(store_selectors["isOnEndpointPage"])(getState())&&Object(store_selectors["hasSelectedEndpoint"])(getState())!==true){if(!Object(store_selectors["endpointPackageInfo"])(getState())){try{const packageInfo=await sendGetEndpointSecurityPackage(coreStart.http);dispatch({type:"serverReturnedEndpointPackageInfo",payload:packageInfo})}catch(error){console.error(error)}}const{page_index:pageIndex,page_size:pageSize}=Object(store_selectors["uiQueryParams"])(getState());let endpointResponse;try{const decodedQuery=Object(store_selectors["searchBarQuery"])(getState());endpointResponse=await coreStart.http.post("/api/endpoint/metadata",{body:JSON.stringify({paging_properties:[{page_index:pageIndex},{page_size:pageSize}],filters:{kql:decodedQuery.query}})});endpointResponse.request_page_index=Number(pageIndex);dispatch({type:"serverReturnedEndpointList",payload:endpointResponse});try{const endpointsTotalCount=await endpointsTotal(coreStart.http);dispatch({type:"serverReturnedEndpointsTotal",payload:endpointsTotalCount})}catch(error){dispatch({type:"serverFailedToReturnEndpointsTotal",payload:error})}try{const agentsWithEndpoint=await sendGetFleetAgentsWithEndpoint(coreStart.http);dispatch({type:"serverReturnedAgenstWithEndpointsTotal",payload:agentsWithEndpoint.total})}catch(error){dispatch({type:"serverFailedToReturnAgenstWithEndpointsTotal",payload:error})}try{const ingestPolicies=await getAgentAndPoliciesForEndpointsList(coreStart.http,endpointResponse.hosts,Object(store_selectors["nonExistingPolicies"])(getState()));if((ingestPolicies===null||ingestPolicies===void 0?void 0:ingestPolicies.packagePolicy)!==undefined){dispatch({type:"serverReturnedEndpointNonExistingPolicies",payload:ingestPolicies.packagePolicy})}if((ingestPolicies===null||ingestPolicies===void 0?void 0:ingestPolicies.agentPolicy)!==undefined){dispatch({type:"serverReturnedEndpointAgentPolicies",payload:ingestPolicies.agentPolicy})}}catch(error){console.error(error)}}catch(error){dispatch({type:"serverFailedToReturnEndpointList",payload:error})}if(Object(store_selectors["patterns"])(getState()).length===0&&Object(store_selectors["isTransformEnabled"])(getState())){try{const indexPatterns=await fetchIndexPatterns();if(indexPatterns!==undefined){dispatch({type:"serverReturnedMetadataPatterns",payload:indexPatterns})}}catch(error){dispatch({type:"serverFailedToReturnMetadataPatterns",payload:error})}}if(endpointResponse&&endpointResponse.hosts.length===0){const http=coreStart.http;if(await doEndpointsExist(http)){return}dispatch({type:"serverReturnedEndpointExistValue",payload:false});try{const policyDataResponse=await sendGetEndpointSpecificPackagePolicies(http,{query:{perPage:50,page:1}});dispatch({type:"serverReturnedPoliciesForOnboarding",payload:{policyItems:policyDataResponse.items}})}catch(error){var _error$body;dispatch({type:"serverFailedToReturnPoliciesForOnboarding",payload:(_error$body=error.body)!==null&&_error$body!==void 0?_error$body:error});return}}else{dispatch({type:"serverCancelledPolicyItemsLoading"});dispatch({type:"serverReturnedEndpointExistValue",payload:true})}}if(action.type==="userChangedUrl"&&Object(store_selectors["hasSelectedEndpoint"])(getState())===true){dispatch({type:"serverCancelledPolicyItemsLoading"});if(Object(store_selectors["listData"])(getState()).length===0){const{page_index:pageIndex,page_size:pageSize}=Object(store_selectors["uiQueryParams"])(getState());try{const response=await coreStart.http.post("/api/endpoint/metadata",{body:JSON.stringify({paging_properties:[{page_index:pageIndex},{page_size:pageSize}]})});response.request_page_index=Number(pageIndex);dispatch({type:"serverReturnedEndpointList",payload:response});try{const ingestPolicies=await getAgentAndPoliciesForEndpointsList(coreStart.http,response.hosts,Object(store_selectors["nonExistingPolicies"])(getState()));if((ingestPolicies===null||ingestPolicies===void 0?void 0:ingestPolicies.packagePolicy)!==undefined){dispatch({type:"serverReturnedEndpointNonExistingPolicies",payload:ingestPolicies.packagePolicy})}if((ingestPolicies===null||ingestPolicies===void 0?void 0:ingestPolicies.agentPolicy)!==undefined){dispatch({type:"serverReturnedEndpointAgentPolicies",payload:ingestPolicies.agentPolicy})}}catch(error){console.error(error)}}catch(error){dispatch({type:"serverFailedToReturnEndpointList",payload:error})}}else{dispatch({type:"serverCancelledEndpointListLoading"})}const{selected_endpoint:selectedEndpoint}=Object(store_selectors["uiQueryParams"])(getState());try{const response=await coreStart.http.get(`/api/endpoint/metadata/${selectedEndpoint}`);dispatch({type:"serverReturnedEndpointDetails",payload:response});try{const ingestPolicies=await getAgentAndPoliciesForEndpointsList(coreStart.http,[response],Object(store_selectors["nonExistingPolicies"])(getState()));if(ingestPolicies!==undefined){dispatch({type:"serverReturnedEndpointNonExistingPolicies",payload:ingestPolicies.packagePolicy})}if((ingestPolicies===null||ingestPolicies===void 0?void 0:ingestPolicies.agentPolicy)!==undefined){dispatch({type:"serverReturnedEndpointAgentPolicies",payload:ingestPolicies.agentPolicy})}}catch(error){console.error(error)}}catch(error){dispatch({type:"serverFailedToReturnEndpointDetails",payload:error})}try{const policyResponse=await coreStart.http.get(`/api/endpoint/policy_response`,{query:{agentId:selectedEndpoint}});dispatch({type:"serverReturnedEndpointPolicyResponse",payload:policyResponse})}catch(error){dispatch({type:"serverFailedToReturnEndpointPolicyResponse",payload:error})}}}};const getAgentAndPoliciesForEndpointsList=async(http,hosts,currentNonExistingPolicies)=>{if(hosts.length===0){return}const policyIdsToCheck=Array.from(new Set(hosts.filter(host=>!currentNonExistingPolicies[host.metadata.Endpoint.policy.applied.id]).map(host=>host.metadata.Endpoint.policy.applied.id)));if(policyIdsToCheck.length===0){return}const policiesFound=(await sendGetAgentPolicyList(http,{query:{kuery:`${common_["AGENT_POLICY_SAVED_OBJECT_TYPE"]}.package_policies: (${policyIdsToCheck.join(" or ")})`}})).items.reduce((list,agentPolicy)=>{agentPolicy.package_policies.forEach(packagePolicy=>{list.packagePolicy[packagePolicy]=true;list.agentPolicy[packagePolicy]=agentPolicy.id});return list},{packagePolicy:{},agentPolicy:{}});const nonExistingPackagePoliciesAndExistingAgentPolicies=policyIdsToCheck.reduce((list,policyId)=>{if(policiesFound.packagePolicy[policyId]){list.agentPolicy[policyId]=policiesFound.agentPolicy[policyId];return list}list.packagePolicy[policyId]=true;return list},{packagePolicy:{},agentPolicy:{}});if(Object.keys(nonExistingPackagePoliciesAndExistingAgentPolicies.packagePolicy).length===0&&Object.keys(nonExistingPackagePoliciesAndExistingAgentPolicies.agentPolicy).length===0){return}return nonExistingPackagePoliciesAndExistingAgentPolicies};const endpointsTotal=async http=>{try{return(await http.post("/api/endpoint/metadata",{body:JSON.stringify({paging_properties:[{page_index:0},{page_size:1}]})})).total}catch(error){console.error(`error while trying to check for total endpoints`);console.error(error)}return 0};const doEndpointsExist=async http=>{try{return await endpointsTotal(http)>0}catch(error){console.error(`error while trying to check if endpoints exist`);console.error(error)}return false};var service=__webpack_require__(517);var trusted_apps_state=__webpack_require__(393);var builders=__webpack_require__(319);var trusted_apps_store_selectors=__webpack_require__(197);const createTrustedAppsListResourceStateChangedAction=newState=>({type:"trustedAppsListResourceStateChanged",payload:{newState:newState}});const refreshListIfNeeded=async(store,trustedAppsService)=>{if(Object(trusted_apps_store_selectors["A"])(store.getState())){store.dispatch(createTrustedAppsListResourceStateChangedAction({type:"LoadingResourceState",previousState:Object(trusted_apps_store_selectors["q"])(store.getState())}));try{const pageIndex=Object(trusted_apps_store_selectors["h"])(store.getState());const pageSize=Object(trusted_apps_store_selectors["i"])(store.getState());const response=await trustedAppsService.getTrustedAppsList({page:pageIndex+1,per_page:pageSize});store.dispatch(createTrustedAppsListResourceStateChangedAction({type:"LoadedResourceState",data:{items:response.data,pageIndex:pageIndex,pageSize:pageSize,totalItemsCount:response.total,timestamp:Date.now()}}))}catch(error){store.dispatch(createTrustedAppsListResourceStateChangedAction({type:"FailedResourceState",error:error.body,lastLoadedState:Object(trusted_apps_store_selectors["m"])(store.getState())}))}}};const updateCreationDialogIfNeeded=store=>{const newEntry=Object(trusted_apps_store_selectors["d"])(store.getState());const shouldShow=Object(trusted_apps_store_selectors["t"])(store.getState());if(shouldShow&&!newEntry){store.dispatch({type:"trustedAppCreationDialogStarted",payload:{entry:Object(builders["b"])()}})}else if(!shouldShow&&newEntry){store.dispatch({type:"trustedAppCreationDialogClosed"})}};const createTrustedAppCreationSubmissionResourceStateChanged=newState=>({type:"trustedAppCreationSubmissionResourceStateChanged",payload:{newState:newState}});const submitCreationIfNeeded=async(store,trustedAppsService)=>{const submissionResourceState=Object(trusted_apps_store_selectors["f"])(store.getState());const isValid=Object(trusted_apps_store_selectors["s"])(store.getState());const entry=Object(trusted_apps_store_selectors["d"])(store.getState());if(Object(trusted_apps_state["isStaleResourceState"])(submissionResourceState)&&entry!==undefined&&isValid){store.dispatch(createTrustedAppCreationSubmissionResourceStateChanged({type:"LoadingResourceState",previousState:submissionResourceState}));try{store.dispatch(createTrustedAppCreationSubmissionResourceStateChanged({type:"LoadedResourceState",data:(await trustedAppsService.createTrustedApp(entry)).data}));store.dispatch({type:"trustedAppsListDataOutdated"})}catch(error){store.dispatch(createTrustedAppCreationSubmissionResourceStateChanged({type:"FailedResourceState",error:error.body,lastLoadedState:Object(trusted_apps_state["getLastLoadedResourceState"])(submissionResourceState)}))}}};const createTrustedAppDeletionSubmissionResourceStateChanged=newState=>({type:"trustedAppDeletionSubmissionResourceStateChanged",payload:{newState:newState}});const submitDeletionIfNeeded=async(store,trustedAppsService)=>{const submissionResourceState=Object(trusted_apps_store_selectors["l"])(store.getState());const entry=Object(trusted_apps_store_selectors["j"])(store.getState());if(Object(trusted_apps_state["isStaleResourceState"])(submissionResourceState)&&entry!==undefined){store.dispatch(createTrustedAppDeletionSubmissionResourceStateChanged({type:"LoadingResourceState",previousState:submissionResourceState}));try{await trustedAppsService.deleteTrustedApp({id:entry.id});store.dispatch(createTrustedAppDeletionSubmissionResourceStateChanged({type:"LoadedResourceState",data:null}));store.dispatch({type:"trustedAppDeletionDialogClosed"});store.dispatch({type:"trustedAppsListDataOutdated"})}catch(error){store.dispatch(createTrustedAppDeletionSubmissionResourceStateChanged({type:"FailedResourceState",error:error.body,lastLoadedState:Object(trusted_apps_state["getLastLoadedResourceState"])(submissionResourceState)}))}}};const checkTrustedAppsExistIfNeeded=async(store,trustedAppsService)=>{const currentState=store.getState();const currentEntriesExistState=Object(trusted_apps_store_selectors["c"])(currentState);if(Object(trusted_apps_store_selectors["B"])(currentState)&&!Object(trusted_apps_state["isLoadingResourceState"])(currentEntriesExistState)){const currentListTotal=Object(trusted_apps_store_selectors["r"])(currentState);const currentDoEntriesExist=Object(trusted_apps_store_selectors["b"])(currentState);if(!Object(trusted_apps_state["isLoadedResourceState"])(currentEntriesExistState)||currentListTotal===0&&currentDoEntriesExist||currentListTotal>0&&!currentDoEntriesExist){store.dispatch({type:"trustedAppsExistStateChanged",payload:{type:"LoadingResourceState",previousState:currentEntriesExistState}});let doTheyExist;try{const{total:total}=await trustedAppsService.getTrustedAppsList({page:1,per_page:1});doTheyExist=total>0}catch(e){doTheyExist=true}store.dispatch({type:"trustedAppsExistStateChanged",payload:{type:"LoadedResourceState",data:doTheyExist}})}}};const createTrustedAppsPageMiddleware=trustedAppsService=>store=>next=>async action=>{next(action);if(action.type==="userChangedUrl"||action.type==="trustedAppsListDataOutdated"){await refreshListIfNeeded(store,trustedAppsService);await checkTrustedAppsExistIfNeeded(store,trustedAppsService)}if(action.type==="userChangedUrl"){updateCreationDialogIfNeeded(store)}if(action.type==="trustedAppCreationDialogConfirmed"){await submitCreationIfNeeded(store,trustedAppsService)}if(action.type==="trustedAppDeletionDialogConfirmed"){await submitDeletionIfNeeded(store,trustedAppsService)}};const trustedAppsPageMiddlewareFactory=coreStart=>createTrustedAppsPageMiddleware(new service["a"](coreStart.http));const createSubStateSelector=namespace=>state=>state[constants["l"]][namespace];const managementMiddlewareFactory=(coreStart,depsStart)=>[Object(common_store["substateMiddlewareFactory"])(createSubStateSelector(constants["m"]),policyDetailsMiddlewareFactory(coreStart,depsStart)),Object(common_store["substateMiddlewareFactory"])(createSubStateSelector(constants["k"]),endpointMiddlewareFactory(coreStart,depsStart)),Object(common_store["substateMiddlewareFactory"])(createSubStateSelector(constants["n"]),trustedAppsPageMiddlewareFactory(coreStart,depsStart))]},765:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return managementReducer}));var redux=__webpack_require__(177);var reducer=__webpack_require__(502);var constants=__webpack_require__(121);var selectors=__webpack_require__(232);const initialEndpointListState={hosts:[],pageSize:10,pageIndex:0,total:0,loading:false,error:undefined,details:undefined,detailsLoading:false,detailsError:undefined,policyResponse:undefined,policyResponseLoading:false,policyResponseError:undefined,location:undefined,policyItems:[],selectedPolicyId:undefined,policyItemsLoading:false,endpointPackageInfo:undefined,nonExistingPolicies:{},agentPolicies:{},endpointsExist:true,patterns:[],patternsError:undefined,isAutoRefreshEnabled:true,autoRefreshInterval:constants["a"],agentsWithEndpointsTotal:0,agentsWithEndpointsTotalError:undefined,endpointsTotal:0,endpointsTotalError:undefined,queryStrategyVersion:undefined,policyVersionInfo:undefined,hostStatus:undefined};const endpointListReducer=(state=initialEndpointListState,action)=>{if(action.type==="serverReturnedEndpointList"){const{hosts:hosts,total:total,request_page_size:pageSize,request_page_index:pageIndex,query_strategy_version:queryStrategyVersion,policy_info:policyVersionInfo}=action.payload;return{...state,hosts:hosts,total:total,pageSize:pageSize,pageIndex:pageIndex,queryStrategyVersion:queryStrategyVersion,policyVersionInfo:policyVersionInfo,loading:false,error:undefined}}else if(action.type==="serverFailedToReturnEndpointList"){return{...state,error:action.payload,loading:false}}else if(action.type==="serverReturnedEndpointNonExistingPolicies"){return{...state,nonExistingPolicies:{...state.nonExistingPolicies,...action.payload}}}else if(action.type==="serverReturnedEndpointAgentPolicies"){return{...state,agentPolicies:{...state.agentPolicies,...action.payload}}}else if(action.type==="serverReturnedMetadataPatterns"){return{...state,patterns:action.payload,patternsError:undefined}}else if(action.type==="serverFailedToReturnMetadataPatterns"){return{...state,patternsError:action.payload}}else if(action.type==="serverReturnedEndpointDetails"){return{...state,details:action.payload.metadata,policyVersionInfo:action.payload.policy_info,hostStatus:action.payload.host_status,detailsLoading:false,detailsError:undefined}}else if(action.type==="serverFailedToReturnEndpointDetails"){return{...state,detailsError:action.payload,detailsLoading:false}}else if(action.type==="serverReturnedPoliciesForOnboarding"){return{...state,policyItems:action.payload.policyItems,policyItemsLoading:false}}else if(action.type==="serverFailedToReturnPoliciesForOnboarding"){return{...state,error:action.payload,policyItemsLoading:false}}else if(action.type==="serverReturnedEndpointPolicyResponse"){return{...state,policyResponse:action.payload.policy_response,policyResponseLoading:false,policyResponseError:undefined}}else if(action.type==="serverFailedToReturnEndpointPolicyResponse"){return{...state,policyResponseError:action.payload,policyResponseLoading:false}}else if(action.type==="userSelectedEndpointPolicy"){return{...state,selectedPolicyId:action.payload.selectedPolicyId,policyResponseLoading:false}}else if(action.type==="serverCancelledEndpointListLoading"){return{...state,loading:false}}else if(action.type==="serverCancelledPolicyItemsLoading"){return{...state,policyItemsLoading:false}}else if(action.type==="serverReturnedEndpointPackageInfo"){return{...state,endpointPackageInfo:action.payload}}else if(action.type==="serverReturnedEndpointExistValue"){return{...state,endpointsExist:action.payload}}else if(action.type==="serverReturnedAgenstWithEndpointsTotal"){return{...state,agentsWithEndpointsTotal:action.payload,agentsWithEndpointsTotalError:undefined}}else if(action.type==="serverFailedToReturnAgenstWithEndpointsTotal"){return{...state,agentsWithEndpointsTotalError:action.payload}}else if(action.type==="serverReturnedEndpointsTotal"){return{...state,endpointsTotal:action.payload,endpointsTotalError:undefined}}else if(action.type==="serverFailedToReturnEndpointsTotal"){return{...state,endpointsTotalError:action.payload}}else if(action.type==="userUpdatedEndpointListRefreshOptions"){var _action$payload$isAut,_action$payload$autoR;return{...state,isAutoRefreshEnabled:(_action$payload$isAut=action.payload.isAutoRefreshEnabled)!==null&&_action$payload$isAut!==void 0?_action$payload$isAut:state.isAutoRefreshEnabled,autoRefreshInterval:(_action$payload$autoR=action.payload.autoRefreshInterval)!==null&&_action$payload$autoR!==void 0?_action$payload$autoR:state.autoRefreshInterval}}else if(action.type==="userChangedUrl"){const newState={...state,location:action.payload};const isCurrentlyOnListPage=Object(selectors["isOnEndpointPage"])(newState)&&!Object(selectors["hasSelectedEndpoint"])(newState);const wasPreviouslyOnListPage=Object(selectors["isOnEndpointPage"])(state)&&!Object(selectors["hasSelectedEndpoint"])(state);const isCurrentlyOnDetailsPage=Object(selectors["isOnEndpointPage"])(newState)&&Object(selectors["hasSelectedEndpoint"])(newState);const wasPreviouslyOnDetailsPage=Object(selectors["isOnEndpointPage"])(state)&&Object(selectors["hasSelectedEndpoint"])(state);if(isCurrentlyOnListPage){if(!wasPreviouslyOnListPage){return{...state,location:action.payload,loading:true,policyItemsLoading:true,error:undefined,detailsError:undefined}}}else if(isCurrentlyOnDetailsPage){if(wasPreviouslyOnDetailsPage||wasPreviouslyOnListPage){return{...state,location:action.payload,detailsLoading:true,policyResponseLoading:true,error:undefined,detailsError:undefined,policyResponseError:undefined}}else{return{...state,location:action.payload,loading:true,detailsLoading:true,policyResponseLoading:true,error:undefined,detailsError:undefined,policyResponseError:undefined,policyItemsLoading:true}}}return{...state,location:action.payload,error:undefined,detailsError:undefined,policyResponseError:undefined,endpointsExist:true}}return state};var builders=__webpack_require__(319);var querystring_es3=__webpack_require__(214);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(75);var routing=__webpack_require__(148);var store_selectors=__webpack_require__(197);const isTrustedAppsPageLocation=location=>{var _location$pathname;return Object(external_kbnSharedDeps_ReactRouterDom_["matchPath"])((_location$pathname=location.pathname)!==null&&_location$pathname!==void 0?_location$pathname:"",{path:constants["j"],exact:true})!==null};const trustedAppsListDataOutdated=(state,action)=>({...state,listView:{...state.listView,freshDataTimestamp:Date.now()}});const trustedAppsListResourceStateChanged=(state,action)=>({...state,listView:{...state.listView,listResourceState:action.payload.newState}});const trustedAppDeletionSubmissionResourceStateChanged=(state,action)=>({...state,deletionDialog:{...state.deletionDialog,submissionResourceState:action.payload.newState}});const trustedAppDeletionDialogStarted=(state,action)=>({...state,deletionDialog:{...Object(builders["d"])(),...action.payload}});const trustedAppDeletionDialogConfirmed=state=>({...state,deletionDialog:{...state.deletionDialog,confirmed:true}});const trustedAppDeletionDialogClosed=state=>({...state,deletionDialog:Object(builders["d"])()});const trustedAppCreationSubmissionResourceStateChanged=(state,action)=>({...state,creationDialog:{...state.creationDialog,submissionResourceState:action.payload.newState}});const trustedAppCreationDialogStarted=(state,action)=>({...state,creationDialog:{...Object(builders["c"])(),formState:{...action.payload,isValid:true}}});const trustedAppCreationDialogFormStateUpdated=(state,action)=>({...state,creationDialog:{...state.creationDialog,formState:{...action.payload}}});const trustedAppCreationDialogConfirmed=state=>({...state,creationDialog:{...state.creationDialog,confirmed:true}});const trustedAppCreationDialogClosed=state=>({...state,creationDialog:Object(builders["c"])()});const userChangedUrl=(state,action)=>{if(isTrustedAppsPageLocation(action.payload)){const location=Object(routing["b"])(Object(querystring_es3["parse"])(action.payload.search.slice(1)));return{...state,active:true,location:location}}else{return Object(builders["e"])()}};const updateEntriesExists=(state,{payload:payload})=>{if(Object(store_selectors["c"])(state)!==payload){return{...state,entriesExist:payload}}return state};const trustedAppsPageReducer=(state=Object(builders["e"])(),action)=>{switch(action.type){case"trustedAppsListDataOutdated":return trustedAppsListDataOutdated(state,action);case"trustedAppsListResourceStateChanged":return trustedAppsListResourceStateChanged(state,action);case"trustedAppDeletionSubmissionResourceStateChanged":return trustedAppDeletionSubmissionResourceStateChanged(state,action);case"trustedAppDeletionDialogStarted":return trustedAppDeletionDialogStarted(state,action);case"trustedAppDeletionDialogConfirmed":return trustedAppDeletionDialogConfirmed(state,action);case"trustedAppDeletionDialogClosed":return trustedAppDeletionDialogClosed(state,action);case"trustedAppCreationSubmissionResourceStateChanged":return trustedAppCreationSubmissionResourceStateChanged(state,action);case"trustedAppCreationDialogStarted":return trustedAppCreationDialogStarted(state,action);case"trustedAppCreationDialogFormStateUpdated":return trustedAppCreationDialogFormStateUpdated(state,action);case"trustedAppCreationDialogConfirmed":return trustedAppCreationDialogConfirmed(state,action);case"trustedAppCreationDialogClosed":return trustedAppCreationDialogClosed(state,action);case"userChangedUrl":return userChangedUrl(state,action);case"trustedAppsExistStateChanged":return updateEntriesExists(state,action)}return state};const immutableCombineReducers=redux["combineReducers"];const mockManagementState={[constants["m"]]:Object(reducer["a"])(),[constants["k"]]:initialEndpointListState,[constants["n"]]:Object(builders["e"])()};const managementReducer=immutableCombineReducers({[constants["m"]]:reducer["b"],[constants["k"]]:endpointListReducer,[constants["n"]]:trustedAppsPageReducer})}}]);