/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["securitySolution_bundle_jsonpfunction"]=window["securitySolution_bundle_jsonpfunction"]||[]).push([[19],{103:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"default",(function(){return ResilientFieldsComponent}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var kibana=__webpack_require__(104);const BASE_ACTION_API_PATH="/api/actions";async function getIncidentTypes({http:http,signal:signal,connectorId:connectorId}){return http.post(`${BASE_ACTION_API_PATH}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"incidentTypes",subActionParams:{}}}),signal:signal})}async function getSeverity({http:http,signal:signal,connectorId:connectorId}){return http.post(`${BASE_ACTION_API_PATH}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"severity",subActionParams:{}}}),signal:signal})}var translations=__webpack_require__(32);const useGetIncidentTypes=({http:http,toastNotifications:toastNotifications,connector:connector})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[incidentTypes,setIncidentTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const didCancel=Object(external_kbnSharedDeps_React_["useRef"])(false);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchData=async()=>{if(!connector){setIsLoading(false);return}try{abortCtrl.current=new AbortController;setIsLoading(true);const res=await getIncidentTypes({http:http,signal:abortCtrl.current.signal,connectorId:connector.id});if(!didCancel.current){var _res$data;setIsLoading(false);setIncidentTypes((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:[]);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["a"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel.current){setIsLoading(false);if(error.name!=="AbortError"){toastNotifications.addDanger({title:translations["a"],text:error.message})}}}};didCancel.current=false;abortCtrl.current.abort();fetchData();return()=>{didCancel.current=true;abortCtrl.current.abort()}},[http,connector,toastNotifications]);return{incidentTypes:incidentTypes,isLoading:isLoading}};const useGetSeverity=({http:http,toastNotifications:toastNotifications,connector:connector})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[severity,setSeverity]=Object(external_kbnSharedDeps_React_["useState"])([]);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);const didCancel=Object(external_kbnSharedDeps_React_["useRef"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchData=async()=>{if(!connector){setIsLoading(false);return}try{abortCtrl.current=new AbortController;setIsLoading(true);const res=await getSeverity({http:http,signal:abortCtrl.current.signal,connectorId:connector.id});if(!didCancel.current){var _res$data;setIsLoading(false);setSeverity((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:[]);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["d"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel.current){setIsLoading(false);if(error.name!=="AbortError"){toastNotifications.addDanger({title:translations["d"],text:error.message})}}}};didCancel.current=false;abortCtrl.current.abort();fetchData();return()=>{didCancel.current=true;abortCtrl.current.abort()}},[http,connector,toastNotifications]);return{severity:severity,isLoading:isLoading}};var connectors=__webpack_require__(10);var card=__webpack_require__(251);const ResilientFieldsComponent=({isEdit:isEdit=true,fields:fields,connector:connector,onChange:onChange})=>{const init=Object(external_kbnSharedDeps_React_["useRef"])(true);const{incidentTypes:incidentTypes=null,severityCode:severityCode=null}=fields!==null&&fields!==void 0?fields:{};const{http:http,notifications:notifications}=Object(kibana["h"])().services;const{isLoading:isLoadingIncidentTypes,incidentTypes:allIncidentTypes}=useGetIncidentTypes({http:http,toastNotifications:notifications.toasts,connector:connector});const{isLoading:isLoadingSeverity,severity:severity}=useGetSeverity({http:http,toastNotifications:notifications.toasts,connector:connector});const severitySelectOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>severity.map(s=>({value:s.id.toString(),text:s.name})),[severity]);const incidentTypesComboBoxOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>allIncidentTypes?allIncidentTypes.map(type=>({label:type.name,value:type.id.toString()})):[],[allIncidentTypes]);const listItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _severity$find$name,_severity$find;return[...incidentTypes!=null&&incidentTypes.length>0?[{title:translations["b"],description:allIncidentTypes.filter(type=>incidentTypes.includes(type.id.toString())).map(type=>type.name).join(", ")}]:[],...severityCode!=null&&severityCode.length>0?[{title:translations["e"],description:(_severity$find$name=(_severity$find=severity.find(severityObj=>severityObj.id.toString()===severityCode))===null||_severity$find===void 0?void 0:_severity$find.name)!==null&&_severity$find$name!==void 0?_severity$find$name:""}]:[]]},[incidentTypes,severityCode,allIncidentTypes,severity]);const onFieldChange=Object(external_kbnSharedDeps_React_["useCallback"])((key,value)=>{onChange({...fields,incidentTypes:incidentTypes,severityCode:severityCode,[key]:value})},[incidentTypes,severityCode,onChange,fields]);const selectedIncidentTypesComboBoxOptionsMemo=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const allIncidentTypesAsObject=allIncidentTypes.reduce((acc,type)=>({...acc,[type.id.toString()]:type.name}),{});return incidentTypes?incidentTypes.map(type=>({label:allIncidentTypesAsObject[type.toString()],value:type.toString()})).filter(type=>type.label!=null):[]},[allIncidentTypes,incidentTypes]);const onIncidentChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedOptions=>{onFieldChange("incidentTypes",selectedOptions.map(selectedOption=>{var _selectedOption$value;return(_selectedOption$value=selectedOption.value)!==null&&_selectedOption$value!==void 0?_selectedOption$value:selectedOption.label}))},[onFieldChange]);const onIncidentBlur=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(!incidentTypes){onFieldChange("incidentTypes",[])}},[incidentTypes,onFieldChange]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(init.current){init.current=false;onChange({incidentTypes:incidentTypes,severityCode:severityCode})}},[incidentTypes,onChange,severityCode]);return isEdit?external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"connector-fields-resilient"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:translations["b"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{"data-test-subj":"incidentTypeComboBox",fullWidth:true,isClearable:true,isDisabled:isLoadingIncidentTypes,isLoading:isLoadingIncidentTypes,onBlur:onIncidentBlur,onChange:onIncidentChange,options:incidentTypesComboBoxOptions,placeholder:translations["c"],selectedOptions:selectedIncidentTypesComboBoxOptionsMemo})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:translations["e"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"severitySelect",disabled:isLoadingSeverity,fullWidth:true,hasNoInitialSelection:true,isLoading:isLoadingSeverity,onChange:e=>onFieldChange("severityCode",e.target.value),options:severitySelectOptions,value:severityCode!==null&&severityCode!==void 0?severityCode:undefined})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})):external_kbnSharedDeps_React_default.a.createElement(card["a"],{connectorType:connectors["c"].resilient,isLoading:isLoadingIncidentTypes||isLoadingSeverity,listItems:listItems,title:connector.name})}},251:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ConnectorCard}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var ___WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(40);const StyledText=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.span.withConfig({displayName:"StyledText",componentId:"sc-15m9dva-0"})(["span{display:block;}"]);const ConnectorCardDisplay=({connectorType:connectorType,title:title,listItems:listItems,isLoading:isLoading})=>{const description=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(StyledText,null,listItems.length>0&&listItems.map((item,i)=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span",{"data-test-subj":"card-list-item",key:`${item.title}-${i}`},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("strong",null,`${item.title}: `),item.description))),[listItems]);const icon=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>{var _connectorsConfigurat,_connectorsConfigurat2;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiIcon"],{size:"xl",type:(_connectorsConfigurat=(_connectorsConfigurat2=___WEBPACK_IMPORTED_MODULE_3__["a"][`${connectorType}`])===null||_connectorsConfigurat2===void 0?void 0:_connectorsConfigurat2.logo)!==null&&_connectorsConfigurat!==void 0?_connectorsConfigurat:""})},[connectorType]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,isLoading&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiLoadingSpinner"],{"data-test-subj":"connector-card-loading"}),!isLoading&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiCard"],{"data-test-subj":`connector-card`,description:description,display:"plain",icon:icon,layout:"horizontal",paddingSize:"none",title:title,titleSize:"xs"}))};const ConnectorCard=Object(react__WEBPACK_IMPORTED_MODULE_0__["memo"])(ConnectorCardDisplay)}}]);