/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["securitySolution_bundle_jsonpfunction"]=window["securitySolution_bundle_jsonpfunction"]||[]).push([[18],{102:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"default",(function(){return JiraFieldsComponent}));var external_kbnSharedDeps_React_=__webpack_require__(6);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_LodashFp_=__webpack_require__(7);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(72);var translations=__webpack_require__(22);var connectors=__webpack_require__(10);var kibana=__webpack_require__(104);const BASE_ACTION_API_PATH="/api/actions";async function getIssueTypes({http:http,signal:signal,connectorId:connectorId}){return http.post(`${BASE_ACTION_API_PATH}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"issueTypes",subActionParams:{}}}),signal:signal})}async function getFieldsByIssueType({http:http,signal:signal,connectorId:connectorId,id:id}){return http.post(`${BASE_ACTION_API_PATH}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"fieldsByIssueType",subActionParams:{id:id}}}),signal:signal})}async function getIssues({http:http,signal:signal,connectorId:connectorId,title:title}){return http.post(`${BASE_ACTION_API_PATH}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"issues",subActionParams:{title:title}}}),signal:signal})}async function getIssue({http:http,signal:signal,connectorId:connectorId,id:id}){return http.post(`${BASE_ACTION_API_PATH}/action/${connectorId}/_execute`,{body:JSON.stringify({params:{subAction:"issue",subActionParams:{id:id}}}),signal:signal})}const useGetIssueTypes=({http:http,connector:connector,toastNotifications:toastNotifications,handleIssueType:handleIssueType})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[issueTypes,setIssueTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const didCancel=Object(external_kbnSharedDeps_React_["useRef"])(false);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchData=async()=>{if(!connector){setIsLoading(false);return}try{abortCtrl.current=new AbortController;setIsLoading(true);const res=await getIssueTypes({http:http,signal:abortCtrl.current.signal,connectorId:connector.id});if(!didCancel.current){var _res$data,_res$data2;setIsLoading(false);const asOptions=((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:[]).map(type=>{var _type$name,_type$id;return{text:(_type$name=type.name)!==null&&_type$name!==void 0?_type$name:"",value:(_type$id=type.id)!==null&&_type$id!==void 0?_type$id:""}});setIssueTypes((_res$data2=res.data)!==null&&_res$data2!==void 0?_res$data2:[]);handleIssueType(asOptions);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["e"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel.current){setIsLoading(false);if(error.name!=="AbortError"){toastNotifications.addDanger({title:translations["e"],text:error.message})}}}};didCancel.current=false;abortCtrl.current.abort();fetchData();return()=>{didCancel.current=true;abortCtrl.current.abort()}},[http,connector,toastNotifications]);return{issueTypes:issueTypes,isLoading:isLoading}};const useGetFieldsByIssueType=({http:http,toastNotifications:toastNotifications,connector:connector,issueType:issueType})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const[fields,setFields]=Object(external_kbnSharedDeps_React_["useState"])({});const didCancel=Object(external_kbnSharedDeps_React_["useRef"])(false);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchData=async()=>{if(!connector||!issueType){setIsLoading(false);return}try{abortCtrl.current=new AbortController;setIsLoading(true);const res=await getFieldsByIssueType({http:http,signal:abortCtrl.current.signal,connectorId:connector.id,id:issueType});if(!didCancel.current){var _res$data;setIsLoading(false);setFields((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:{});if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["a"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel.current){setIsLoading(false);if(error.name!=="AbortError"){toastNotifications.addDanger({title:translations["a"],text:error.message})}}}};didCancel.current=false;abortCtrl.current.abort();fetchData();return()=>{didCancel.current=true;abortCtrl.current.abort()}},[http,connector,issueType,toastNotifications]);return{isLoading:isLoading,fields:fields}};const useGetIssues=({http:http,actionConnector:actionConnector,toastNotifications:toastNotifications,query:query})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[issues,setIssues]=Object(external_kbnSharedDeps_React_["useState"])([]);const didCancel=Object(external_kbnSharedDeps_React_["useRef"])(false);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchData=Object(external_kbnSharedDeps_LodashFp_["debounce"])(500,async()=>{if(!actionConnector||Object(external_kbnSharedDeps_LodashFp_["isEmpty"])(query)){setIsLoading(false);return}try{abortCtrl.current=new AbortController;setIsLoading(true);const res=await getIssues({http:http,signal:abortCtrl.current.signal,connectorId:actionConnector.id,title:query!==null&&query!==void 0?query:""});if(!didCancel.current){var _res$data;setIsLoading(false);setIssues((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:[]);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["c"],text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel.current){setIsLoading(false);if(error.name!=="AbortError"){toastNotifications.addDanger({title:translations["c"],text:error.message})}}}});didCancel.current=false;abortCtrl.current.abort();fetchData();return()=>{didCancel.current=true;abortCtrl.current.abort()}},[http,actionConnector,toastNotifications,query]);return{issues:issues,isLoading:isLoading}};const useGetSingleIssue=({http:http,toastNotifications:toastNotifications,actionConnector:actionConnector,id:id})=>{const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[issue,setIssue]=Object(external_kbnSharedDeps_React_["useState"])(null);const didCancel=Object(external_kbnSharedDeps_React_["useRef"])(false);const abortCtrl=Object(external_kbnSharedDeps_React_["useRef"])(new AbortController);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchData=async()=>{if(!actionConnector||!id){setIsLoading(false);return}abortCtrl.current=new AbortController;setIsLoading(true);try{const res=await getIssue({http:http,signal:abortCtrl.current.signal,connectorId:actionConnector.id,id:id});if(!didCancel.current){var _res$data;setIsLoading(false);setIssue((_res$data=res.data)!==null&&_res$data!==void 0?_res$data:null);if(res.status&&res.status==="error"){var _res$serviceMessage;toastNotifications.addDanger({title:translations["b"](id),text:`${(_res$serviceMessage=res.serviceMessage)!==null&&_res$serviceMessage!==void 0?_res$serviceMessage:res.message}`})}}}catch(error){if(!didCancel.current){setIsLoading(false);if(error.name!=="AbortError"){toastNotifications.addDanger({title:translations["b"](id),text:error.message})}}}};didCancel.current=false;abortCtrl.current.abort();fetchData();return()=>{didCancel.current=true;abortCtrl.current.abort()}},[http,actionConnector,id,toastNotifications]);return{isLoading:isLoading,issue:issue}};const SearchIssuesComponent=({selectedValue:selectedValue,actionConnector:actionConnector,onChange:onChange})=>{const[query,setQuery]=Object(external_kbnSharedDeps_React_["useState"])(null);const[selectedOptions,setSelectedOptions]=Object(external_kbnSharedDeps_React_["useState"])([]);const[options,setOptions]=Object(external_kbnSharedDeps_React_["useState"])([]);const{http:http,notifications:notifications}=Object(kibana["h"])().services;const{isLoading:isLoadingIssues,issues:issues}=useGetIssues({http:http,toastNotifications:notifications.toasts,actionConnector:actionConnector,query:query});const{isLoading:isLoadingSingleIssue,issue:singleIssue}=useGetSingleIssue({http:http,toastNotifications:notifications.toasts,actionConnector:actionConnector,id:selectedValue});Object(external_kbnSharedDeps_React_["useEffect"])(()=>setOptions(issues.map(issue=>({label:issue.title,value:issue.key}))),[issues]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isLoadingSingleIssue||singleIssue==null){return}const singleIssueAsOptions=[{label:singleIssue.title,value:singleIssue.key}];setOptions(singleIssueAsOptions);setSelectedOptions(singleIssueAsOptions)},[singleIssue,isLoadingSingleIssue]);const onSearchChange=Object(external_kbnSharedDeps_React_["useCallback"])(searchVal=>{setQuery(searchVal)},[]);const onChangeComboBox=Object(external_kbnSharedDeps_React_["useCallback"])(changedOptions=>{setSelectedOptions(changedOptions);onChange(changedOptions[0].value)},[onChange]);const inputPlaceholder=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isLoadingIssues||isLoadingSingleIssue?translations["i"]:translations["j"],[isLoadingIssues,isLoadingSingleIssue]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{singleSelection:true,fullWidth:true,placeholder:inputPlaceholder,"data-test-subj":"search-parent-issues","aria-label":translations["h"],options:options,isLoading:isLoadingIssues||isLoadingSingleIssue,onSearchChange:onSearchChange,selectedOptions:selectedOptions,onChange:onChangeComboBox})};const SearchIssues=Object(external_kbnSharedDeps_React_["memo"])(SearchIssuesComponent);var card=__webpack_require__(251);const JiraFieldsComponent=({connector:connector,fields:fields,isEdit:isEdit=true,onChange:onChange})=>{const init=Object(external_kbnSharedDeps_React_["useRef"])(true);const{issueType:issueType=null,priority:priority=null,parent:parent=null}=fields!==null&&fields!==void 0?fields:{};const{http:http,notifications:notifications}=Object(kibana["h"])().services;const handleIssueType=Object(external_kbnSharedDeps_React_["useCallback"])(issueTypeSelectOptions=>{if(issueType==null&&issueTypeSelectOptions.length>0){if(isEdit){onChange({issueType:issueTypeSelectOptions[0].value,parent:parent,priority:priority})}}},[isEdit,issueType,onChange,parent,priority]);const{isLoading:isLoadingIssueTypes,issueTypes:issueTypes}=useGetIssueTypes({connector:connector,http:http,toastNotifications:notifications.toasts,handleIssueType:handleIssueType});const issueTypesSelectOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>issueTypes.map(type=>{var _type$name,_type$id;return{text:(_type$name=type.name)!==null&&_type$name!==void 0?_type$name:"",value:(_type$id=type.id)!==null&&_type$id!==void 0?_type$id:""}}),[issueTypes]);const currentIssueType=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!issueType&&issueTypesSelectOptions.length>0){return issueTypesSelectOptions[0].value}else if(issueTypesSelectOptions.length>0&&!issueTypesSelectOptions.some(({value:value})=>value===issueType)){return issueTypesSelectOptions[0].value}return issueType},[issueType,issueTypesSelectOptions]);const{isLoading:isLoadingFields,fields:fieldsByIssueType}=useGetFieldsByIssueType({connector:connector,http:http,issueType:currentIssueType,toastNotifications:notifications.toasts});const hasPriority=Object(external_kbnSharedDeps_React_["useMemo"])(()=>fieldsByIssueType.priority!=null,[fieldsByIssueType]);const hasParent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>fieldsByIssueType.parent!=null,[fieldsByIssueType]);const prioritiesSelectOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _fieldsByIssueType$pr,_fieldsByIssueType$pr2;const priorities=(_fieldsByIssueType$pr=(_fieldsByIssueType$pr2=fieldsByIssueType.priority)===null||_fieldsByIssueType$pr2===void 0?void 0:_fieldsByIssueType$pr2.allowedValues)!==null&&_fieldsByIssueType$pr!==void 0?_fieldsByIssueType$pr:[];return Object(external_kbnSharedDeps_LodashFp_["map"])(p=>({text:p.name,value:p.name}),priorities)},[fieldsByIssueType]);const listItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _issueTypes$find$name,_issueTypes$find;return[...issueType!=null&&issueType.length>0?[{title:translations["d"],description:(_issueTypes$find$name=(_issueTypes$find=issueTypes.find(issue=>issue.id===issueType))===null||_issueTypes$find===void 0?void 0:_issueTypes$find.name)!==null&&_issueTypes$find$name!==void 0?_issueTypes$find$name:""}]:[],...parent!=null&&parent.length>0?[{title:translations["f"],description:parent}]:[],...priority!=null&&priority.length>0?[{title:translations["g"],description:priority}]:[]]},[issueType,issueTypes,parent,priority]);const onFieldChange=Object(external_kbnSharedDeps_React_["useCallback"])((key,value)=>{if(key==="issueType"){return onChange({...fields,issueType:value,priority:null,parent:null})}return onChange({...fields,issueType:currentIssueType,parent:parent,priority:priority,[key]:value})},[currentIssueType,fields,onChange,parent,priority]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(init.current){init.current=false;onChange({issueType:issueType,priority:priority,parent:parent})}},[issueType,onChange,parent,priority]);return isEdit?external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"connector-fields-jira"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:translations["d"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"issueTypeSelect",disabled:isLoadingIssueTypes||isLoadingFields,fullWidth:true,isLoading:isLoadingIssueTypes,onChange:e=>onFieldChange("issueType",e.target.value),options:issueTypesSelectOptions,value:currentIssueType!==null&&currentIssueType!==void 0?currentIssueType:""})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,hasParent&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:translations["f"]},external_kbnSharedDeps_React_default.a.createElement(SearchIssues,{actionConnector:connector,onChange:parentIssueKey=>onFieldChange("parent",parentIssueKey),selectedValue:parent})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})),hasPriority&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:translations["g"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"prioritySelect",disabled:isLoadingIssueTypes||isLoadingFields,fullWidth:true,hasNoInitialSelection:true,isLoading:isLoadingFields,onChange:e=>onFieldChange("priority",e.target.value),options:prioritiesSelectOptions,value:priority!==null&&priority!==void 0?priority:""}))))))):external_kbnSharedDeps_React_default.a.createElement(card["a"],{connectorType:connectors["c"].jira,isLoading:isLoadingIssueTypes||isLoadingFields,listItems:listItems,title:connector.name})}},251:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ConnectorCard}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(72);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var styled_components__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(73);var styled_components__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(styled_components__WEBPACK_IMPORTED_MODULE_2__);var ___WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(40);const StyledText=styled_components__WEBPACK_IMPORTED_MODULE_2___default.a.span.withConfig({displayName:"StyledText",componentId:"sc-15m9dva-0"})(["span{display:block;}"]);const ConnectorCardDisplay=({connectorType:connectorType,title:title,listItems:listItems,isLoading:isLoading})=>{const description=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(StyledText,null,listItems.length>0&&listItems.map((item,i)=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span",{"data-test-subj":"card-list-item",key:`${item.title}-${i}`},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("strong",null,`${item.title}: `),item.description))),[listItems]);const icon=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>{var _connectorsConfigurat,_connectorsConfigurat2;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiIcon"],{size:"xl",type:(_connectorsConfigurat=(_connectorsConfigurat2=___WEBPACK_IMPORTED_MODULE_3__["a"][`${connectorType}`])===null||_connectorsConfigurat2===void 0?void 0:_connectorsConfigurat2.logo)!==null&&_connectorsConfigurat!==void 0?_connectorsConfigurat:""})},[connectorType]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,isLoading&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiLoadingSpinner"],{"data-test-subj":"connector-card-loading"}),!isLoading&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiCard"],{"data-test-subj":`connector-card`,description:description,display:"plain",icon:icon,layout:"horizontal",paddingSize:"none",title:title,titleSize:"xs"}))};const ConnectorCard=Object(react__WEBPACK_IMPORTED_MODULE_0__["memo"])(ConnectorCardDisplay)}}]);