/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["security_bundle_jsonpfunction"]=window["security_bundle_jsonpfunction"]||[]).push([[9],{102:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return RoleComboBox}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var model=__webpack_require__(13);const RoleComboBox=props=>{var _groupedOptions$custo,_groupedOptions$user,_groupedOptions$admin,_groupedOptions$syste,_groupedOptions$depre;const onRolesChange=selectedItems=>{props.onChange(selectedItems.map(item=>item.label))};const roleNameToOption=roleName=>{var _ref,_ref2,_ref3,_ref4,_roleDefinition$metad;const roleDefinition=props.availableRoles.find(role=>role.name===roleName);const isReserved=(_ref=roleDefinition&&Object(model["j"])(roleDefinition))!==null&&_ref!==void 0?_ref:false;const isDeprecated=(_ref2=roleDefinition&&Object(model["g"])(roleDefinition))!==null&&_ref2!==void 0?_ref2:false;const isSystem=(_ref3=roleDefinition&&Object(model["k"])(roleDefinition))!==null&&_ref3!==void 0?_ref3:false;const isAdmin=(_ref4=roleDefinition&&Object(model["f"])(roleDefinition))!==null&&_ref4!==void 0?_ref4:false;return{color:isDeprecated?"warning":isReserved?"primary":undefined,"data-test-subj":`roleOption-${roleName}`,label:roleName,value:{isReserved:isReserved,isDeprecated:isDeprecated,isSystem:isSystem,isAdmin:isAdmin,deprecatedReason:roleDefinition===null||roleDefinition===void 0?void 0:(_roleDefinition$metad=roleDefinition.metadata)===null||_roleDefinition$metad===void 0?void 0:_roleDefinition$metad._deprecated_reason}}};const options=props.availableRoles.map(role=>roleNameToOption(role.name));const selectedOptions=props.selectedRoleNames.map(roleNameToOption);const groupedOptions=options.reduce((acc,option)=>{var _option$value,_option$value2,_option$value3,_option$value4;const type=(_option$value=option.value)!==null&&_option$value!==void 0&&_option$value.isDeprecated?"deprecated":(_option$value2=option.value)!==null&&_option$value2!==void 0&&_option$value2.isSystem?"system":(_option$value3=option.value)!==null&&_option$value3!==void 0&&_option$value3.isAdmin?"admin":(_option$value4=option.value)!==null&&_option$value4!==void 0&&_option$value4.isReserved?"user":"custom";if(!acc[type]){acc[type]=[]}acc[type].push(option);return acc},{});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{"data-test-subj":"rolesDropdown",id:props.id,placeholder:props.placeholder||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.roleComboBox.placeholder",{defaultMessage:"Select roles"}),onChange:onRolesChange,isLoading:props.isLoading,isDisabled:props.isDisabled,options:[{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.roleComboBox.customRoles",{defaultMessage:"Custom roles"}),options:(_groupedOptions$custo=groupedOptions.custom)!==null&&_groupedOptions$custo!==void 0?_groupedOptions$custo:[]},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.roleComboBox.userRoles",{defaultMessage:"User roles"}),options:(_groupedOptions$user=groupedOptions.user)!==null&&_groupedOptions$user!==void 0?_groupedOptions$user:[]},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.roleComboBox.AdminRoles",{defaultMessage:"Admin roles"}),options:(_groupedOptions$admin=groupedOptions.admin)!==null&&_groupedOptions$admin!==void 0?_groupedOptions$admin:[]},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.roleComboBox.systemRoles",{defaultMessage:"System roles"}),options:(_groupedOptions$syste=groupedOptions.system)!==null&&_groupedOptions$syste!==void 0?_groupedOptions$syste:[]},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.roleComboBox.deprecatedRoles",{defaultMessage:"Deprecated roles"}),options:(_groupedOptions$depre=groupedOptions.deprecated)!==null&&_groupedOptions$depre!==void 0?_groupedOptions$depre:[]}],selectedOptions:selectedOptions,renderOption:renderOption})};function renderOption(option){var _option$value5,_option$value6;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,option.label),(_option$value5=option.value)!==null&&_option$value5!==void 0&&_option$value5.isDeprecated?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:option.color},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.roleComboBox.deprecatedBadge",defaultMessage:"deprecated"}))):(_option$value6=option.value)!==null&&_option$value6!==void 0&&_option$value6.isReserved?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:option.color},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.roleComboBox.reservedBadge",defaultMessage:"built in"}))):undefined)}},298:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"EditUserPage",(function(){return EditUserPage}));__webpack_require__.d(__webpack_exports__,"CreateUserPage",(function(){return CreateUserPage}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(3);var useAsyncFn=__webpack_require__(39);var useAsyncFn_default=__webpack_require__.n(useAsyncFn);var public_=__webpack_require__(6);var model=__webpack_require__(13);var user_utils=__webpack_require__(97);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_Lodash_=__webpack_require__(14);var constants=__webpack_require__(15);function useForm(options){const form=useFormState(options);const eventHandlers={onSubmit:event=>{event.preventDefault();form.submit()},onChange:event=>{const{name:name,type:type,checked:checked,value:value}=event.target;if(name){form.setValue(name,type==="checkbox"?checked:value)}},onBlur:event=>{const{name:name}=event.target;if(name){form.setTouched(event.target.name)}}};return[form,eventHandlers]}function useFormState({onSubmit:onSubmit,validate:validate,defaultValues:defaultValues}){const[values,setValues]=Object(external_kbnSharedDeps_React_["useState"])(defaultValues);const[errors,setErrors]=Object(external_kbnSharedDeps_React_["useState"])({});const[touched,setTouched]=Object(external_kbnSharedDeps_React_["useState"])({});const[submitCount,setSubmitCount]=Object(external_kbnSharedDeps_React_["useState"])(0);const[validationState,validateForm]=useAsyncFn_default()(async formValues=>{const nextErrors=await validate(formValues);setErrors(nextErrors);if(Object.keys(nextErrors).length===0){setSubmitCount(0)}return nextErrors},[validate]);const[submitState,submitForm]=useAsyncFn_default()(async formValues=>{const nextErrors=await validateForm(formValues);setTouched(mapDeep(formValues,true));setSubmitCount(submitCount+1);if(Object.keys(nextErrors).length===0){return onSubmit(formValues)}},[validateForm,onSubmit]);return{setValue:async(name,value)=>{const nextValues=setDeep(values,name,value);setValues(nextValues);await validateForm(nextValues)},setTouched:async(name,value=true)=>{setTouched(setDeep(touched,name,value));await validateForm(values)},setError:(name,message)=>{setErrors(setDeep(errors,name,message));setTouched(setDeep(touched,name,true))},reset:nextValues=>{setValues(nextValues);setErrors({});setTouched({});setSubmitCount(0)},submit:()=>submitForm(values),values:values,errors:errors,touched:touched,isValidating:validationState.loading,isSubmitting:submitState.loading,submitError:submitState.error,isInvalid:Object.keys(errors).length>0,isSubmitted:submitCount>0}}function mapDeep(values,value){return Object(external_kbnSharedDeps_Lodash_["cloneDeepWith"])(values,v=>{if(typeof v!=="object"&&v!==null){return value}})}function setDeep(values,name,value){if(Object(external_kbnSharedDeps_Lodash_["get"])(values,name)!==value){return Object(external_kbnSharedDeps_Lodash_["set"])(Object(external_kbnSharedDeps_Lodash_["cloneDeep"])(values),name,value)}return values}function useDocLinks(){const{services:services}=Object(public_["useKibana"])();const{links:links,ELASTIC_WEBSITE_URL:ELASTIC_WEBSITE_URL,DOC_LINK_VERSION:DOC_LINK_VERSION}=services.docLinks;const getDocLink=Object(external_kbnSharedDeps_React_["useCallback"])((app,doc)=>`${ELASTIC_WEBSITE_URL}guide/en/${app}/reference/${DOC_LINK_VERSION}/${doc}`,[ELASTIC_WEBSITE_URL,DOC_LINK_VERSION]);return[links,getDocLink]}const DocLink=({app:app,doc:doc,children:children})=>{const[,getDocLink]=useDocLinks();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getDocLink(app,doc),target:"_blank",external:true},children)};var management_roles=__webpack_require__(24);var role_combo_box=__webpack_require__(102);var management_users=__webpack_require__(18);const THROTTLE_USERS_WAIT=1e4;const defaultDefaultValues={username:"",password:"",confirm_password:"",full_name:"",email:"",roles:[]};const UserForm=({isNewUser:isNewUser=false,isReservedUser:isReservedUser=false,defaultValues:defaultValues=defaultDefaultValues,onSuccess:onSuccess,onCancel:onCancel})=>{var _rolesState$value,_form$values$roles;const{services:services}=Object(public_["useKibana"])();const[rolesState,getRoles]=useAsyncFn_default()(()=>new management_roles["RolesAPIClient"](services.http).getRoles(),[services.http]);const getUsersThrottled=Object(external_kbnSharedDeps_React_["useCallback"])(Object(external_kbnSharedDeps_Lodash_["throttle"])(()=>new management_users["UserAPIClient"](services.http).getUsers(),THROTTLE_USERS_WAIT),[services.http]);const[form,eventHandlers]=useForm({onSubmit:async values=>{const{password:password,confirm_password:confirm_password,...rest}=values;const user=isNewUser?{password:password,...rest}:rest;try{await new management_users["UserAPIClient"](services.http).saveUser(user);services.notifications.toasts.addSuccess(isNewUser?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.createSuccessMessage",{defaultMessage:"Created user '{username}'",values:{username:user.username}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.updateSuccessMessage",{defaultMessage:"Updated user '{username}'",values:{username:user.username}}));onSuccess===null||onSuccess===void 0?void 0:onSuccess()}catch(error){var _body;services.notifications.toasts.addDanger({title:isNewUser?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.createErrorMessage",{defaultMessage:"Could not create user '{username}'",values:{username:user.username}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.updateErrorMessage",{defaultMessage:"Could not update user '{username}'",values:{username:user.username}}),text:((_body=error.body)===null||_body===void 0?void 0:_body.message)||error.message});throw error}},validate:async values=>{const errors={};if(isNewUser){if(!values.username){errors.username=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.usernameRequiredError",{defaultMessage:"Enter a username."})}else if(values.username.length>constants["d"]){errors.username=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.usernameMaxLengthError",{defaultMessage:"Username must not exceed {maxLength} characters.",values:{maxLength:constants["d"]}})}else if(values.username.trim()!==values.username){errors.username=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.usernameWhitespaceError",{defaultMessage:`Username must not contain leading or trailing spaces.`})}else if(!values.username.match(constants["e"])){errors.username=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.usernameInvalidError",{defaultMessage:"Username must contain only letters, numbers, spaces, punctuation, and symbols."})}else{try{const users=await getUsersThrottled();if(users.some(user=>user.username===values.username)){errors.username=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.usernameTakenError",{defaultMessage:"User '{username}' already exists.",values:{username:values.username}})}}catch(error){}}if(!values.password){errors.password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.passwordRequiredError",{defaultMessage:"Enter a password."})}else if(values.password.length<6){errors.password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.passwordInvalidError",{defaultMessage:"Password must be at least 6 characters."})}else if(!values.confirm_password){errors.confirm_password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.confirmPasswordRequiredError",{defaultMessage:"Passwords do not match."})}else if(values.password!==values.confirm_password){errors.confirm_password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.confirmPasswordInvalidError",{defaultMessage:"Passwords do not match."})}}return errors},defaultValues:defaultValues});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{form.reset(defaultValues)},[defaultValues]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getRoles()},[]);const availableRoles=(_rolesState$value=rolesState.value)!==null&&_rolesState$value!==void 0?_rolesState$value:[];const selectedRoleNames=(_form$values$roles=form.values.roles)!==null&&_form$values$roles!==void 0?_form$values$roles:[];const deprecatedRoles=selectedRoleNames.reduce((roles,name)=>{const role=availableRoles.find(r=>r.name===name);if(role&&Object(model["g"])(role)){roles.push(role)}return roles},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{component:"form",error:Object.values(form.errors),isInvalid:form.isInvalid,invalidCallout:form.isSubmitted?"above":"none",onSubmit:eventHandlers.onSubmit,noValidate:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.profileTitle",defaultMessage:"Profile"})),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.profileDescription",{defaultMessage:"Provide personal details."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.usernameLabel",{defaultMessage:"Username"}),helpText:!isNewUser&&!isReservedUser?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.changingUserNameAfterCreationDescription",{defaultMessage:`Username can't be changed once created.`}):undefined,error:form.errors.username,isInvalid:form.touched.username&&!!form.errors.username},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{name:"username","data-test-subj":"userFormUserNameInput",icon:"user",value:form.values.username,isLoading:form.isValidating,isInvalid:form.touched.username&&!!form.errors.username,disabled:!isNewUser,onChange:eventHandlers.onChange,onBlur:eventHandlers.onBlur})),!isReservedUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.fullNameLabel",{defaultMessage:"Full name"}),error:form.errors.full_name,isInvalid:form.touched.full_name&&!!form.errors.full_name},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{name:"full_name","data-test-subj":"userFormFullNameInput",value:form.values.full_name,isInvalid:form.touched.full_name&&!!form.errors.full_name,onChange:eventHandlers.onChange,onBlur:eventHandlers.onBlur})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.emailLabel",{defaultMessage:"Email address"}),error:form.errors.email,isInvalid:form.touched.email&&!!form.errors.email},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{name:"email","data-test-subj":"userFormEmailInput",value:form.values.email,isInvalid:form.touched.email&&!!form.errors.email,onChange:eventHandlers.onChange,onBlur:eventHandlers.onBlur}))):undefined),isNewUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.passwordTitle",defaultMessage:"Password"})),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.passwordDescription",{defaultMessage:"Protect your data with a strong password."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.passwordLabel",{defaultMessage:"Password"}),helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.passwordHelpText",{defaultMessage:"Password must be at least 6 characters."}),error:form.errors.password,isInvalid:form.touched.password&&!!form.errors.password},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{name:"password","data-test-subj":"passwordInput",type:"dual",value:form.values.password,isInvalid:form.touched.password&&!!form.errors.password,autoComplete:"new-password",onChange:eventHandlers.onChange,onBlur:eventHandlers.onBlur})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.confirmPasswordLabel",{defaultMessage:"Confirm password"}),error:form.errors.confirm_password,isInvalid:form.touched.confirm_password&&!!form.errors.confirm_password},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{name:"confirm_password","data-test-subj":"passwordConfirmationInput",type:"dual",value:form.values.confirm_password,isInvalid:form.touched.confirm_password&&!!form.errors.confirm_password,autoComplete:"new-password",onChange:eventHandlers.onChange,onBlur:eventHandlers.onBlur}))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.privilegesTitle",defaultMessage:"Privileges"})),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.privilegesDescription",{defaultMessage:"Assign roles to manage access and permissions."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userForm.rolesLabel",{defaultMessage:"Roles"}),helpText:!isReservedUser&&deprecatedRoles.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"warning"},deprecatedRoles.map(role=>{var _role$metadata,_role$metadata$_depre;return external_kbnSharedDeps_React_default.a.createElement("p",{key:role.name},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.deprecatedRolesAssignedWarning",defaultMessage:"Role '{name}' is deprecated. {reason}.",values:{name:role.name,reason:(_role$metadata=role.metadata)===null||_role$metadata===void 0?void 0:(_role$metadata$_depre=_role$metadata._deprecated_reason)===null||_role$metadata$_depre===void 0?void 0:_role$metadata$_depre.replace(/\[(.+)\]/,"'$1'")}}))})):external_kbnSharedDeps_React_default.a.createElement(DocLink,{app:"elasticsearch",doc:"built-in-roles.html"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.rolesHelpText",defaultMessage:"Learn what privileges individual roles grant."}))},external_kbnSharedDeps_React_default.a.createElement(role_combo_box["a"],{availableRoles:availableRoles,selectedRoleNames:selectedRoleNames,onChange:value=>form.setValue("roles",value),isLoading:rolesState.loading,isDisabled:isReservedUser})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xxl"}),isReservedUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"arrowLeft",onClick:onCancel},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.backToUsersButton",defaultMessage:"Back to users"})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"submit",isLoading:form.isSubmitting,isDisabled:form.isSubmitted&&form.isInvalid,fill:true},isNewUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.createUserButton",defaultMessage:"{isSubmitting, select, true{Creating user…} other{Create user}}",values:{isSubmitting:form.isSubmitting}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.updateUserButton",defaultMessage:"{isSubmitting, select, true{Updating user…} other{Update user}}",values:{isSubmitting:form.isSubmitting}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{flush:"left",isDisabled:form.isSubmitting,onClick:onCancel},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.userForm.cancelButton",defaultMessage:"Cancel"}))))))};var use_current_user=__webpack_require__(31);function useHtmlId(prefix,suffix){return Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])(prefix)(suffix),[prefix,suffix])}function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const FormFlyout=({title:title,submitButtonText:submitButtonText,submitButtonColor:submitButtonColor,onCancel:onCancel,onSubmit:onSubmit,isLoading:isLoading,isDisabled:isDisabled,children:children,initialFocus:initialFocus,...rest})=>{Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(initialFocus&&initialFocus.current){initialFocus.current.focus()}},[initialFocus]);const titleId=useHtmlId("formFlyout","title");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],_extends({onClose:onCancel,"aria-labelledby":titleId},rest),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:titleId},title))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,children),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"formFlyoutCancelButton",flush:"right",isDisabled:isLoading,onClick:onCancel},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.formFlyout.cancelButton",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"formFlyoutSubmitButton",isLoading:isLoading,isDisabled:isDisabled,color:submitButtonColor,fill:true,onClick:onSubmit},submitButtonText))))))};function change_password_flyout_extends(){change_password_flyout_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return change_password_flyout_extends.apply(this,arguments)}const ChangePasswordFlyout=({username:username,defaultValues:defaultValues={current_password:"",password:"",confirm_password:""},onSuccess:onSuccess,onCancel:onCancel})=>{const{services:services}=Object(public_["useKibana"])();const{value:currentUser,loading:isLoading}=Object(use_current_user["b"])();const isCurrentUser=(currentUser===null||currentUser===void 0?void 0:currentUser.username)===username;const isSystemUser=username==="kibana"||username==="kibana_system";const[form,eventHandlers]=useForm({onSubmit:async values=>{try{await new management_users["UserAPIClient"](services.http).changePassword(username,values.password,values.current_password);services.notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.successMessage",{defaultMessage:"Password changed for '{username}'.",values:{username:username}}));onSuccess===null||onSuccess===void 0?void 0:onSuccess()}catch(error){var _body;if(((_body=error.body)===null||_body===void 0?void 0:_body.message)==="security_exception"){form.setError("current_password",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.currentPasswordInvalidError",{defaultMessage:"Invalid password."}))}else{var _body2;services.notifications.toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.errorMessage",{defaultMessage:"Could not change password"}),text:((_body2=error.body)===null||_body2===void 0?void 0:_body2.message)||error.message});throw error}}},validate:async values=>{const errors={};if(isCurrentUser){if(!values.current_password){errors.current_password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.currentPasswordRequiredError",{defaultMessage:"Enter your current password."})}}if(!values.password){errors.password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.passwordRequiredError",{defaultMessage:"Enter a new password."})}else if(values.password.length<6){errors.password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.passwordInvalidError",{defaultMessage:"Password must be at least 6 characters."})}else if(!values.confirm_password){errors.confirm_password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.confirmPasswordRequiredError",{defaultMessage:"Passwords do not match."})}else if(values.password!==values.confirm_password){errors.confirm_password=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.confirmPasswordInvalidError",{defaultMessage:"Passwords do not match."})}return errors},defaultValues:defaultValues});return external_kbnSharedDeps_React_default.a.createElement(FormFlyout,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.title",{defaultMessage:"Change password"}),onCancel:onCancel,onSubmit:form.submit,submitButtonText:isSystemUser?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.confirmSystemPasswordButton",{defaultMessage:"{isSubmitting, select, true{Changing password…} other{Change password}}",values:{isSubmitting:form.isSubmitting}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.confirmButton",{defaultMessage:"{isSubmitting, select, true{Changing password…} other{Change password}}",values:{isSubmitting:form.isSubmitting}}),submitButtonColor:isSystemUser?"danger":undefined,isLoading:form.isSubmitting,isDisabled:isLoading||form.isSubmitted&&form.isInvalid,size:"s",ownFocus:true},isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],change_password_flyout_extends({component:"form",noValidate:true},eventHandlers),isSystemUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.systemUserTitle",{defaultMessage:"This is extremely important!"}),color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.changePasswordFlyout.systemUserWarning",defaultMessage:"Changing this password will prevent Kibana from communicating with Elasticsearch."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.changePasswordFlyout.systemUserDescription",defaultMessage:"Once changed, you must manually update your config file with the new password and restart Kibana."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):undefined,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.userLabel",{defaultMessage:"User"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"user"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,username),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"})))),isCurrentUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.currentPasswordLabel",{defaultMessage:"Current password"}),error:form.errors.current_password,isInvalid:form.touched.current_password&&!!form.errors.current_password},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{name:"current_password",type:"dual",defaultValue:form.values.current_password,isInvalid:form.touched.current_password&&!!form.errors.current_password,autoComplete:"current-password"})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.passwordLabel",{defaultMessage:"New password"}),helpText:"Password must be at least 6 characters.",error:form.errors.password,isInvalid:form.touched.password&&!!form.errors.password},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{name:"password",type:"dual",defaultValue:form.values.password,isInvalid:form.touched.password&&!!form.errors.password,autoComplete:"new-password"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.changePasswordFlyout.confirmPasswordLabel",{defaultMessage:"Confirm password"}),error:form.errors.confirm_password,isInvalid:form.touched.confirm_password&&!!form.errors.confirm_password},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{name:"confirm_password",type:"dual",defaultValue:form.values.confirm_password,isInvalid:form.touched.confirm_password&&!!form.errors.confirm_password,autoComplete:"new-password"})),external_kbnSharedDeps_React_default.a.createElement("input",{type:"submit",hidden:true})))};function confirm_modal_extends(){confirm_modal_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return confirm_modal_extends.apply(this,arguments)}const ConfirmModal=({children:children,confirmButtonColor:buttonColor,confirmButtonText:confirmButtonText,isLoading:isLoading,isDisabled:isDisabled,onCancel:onCancel,onConfirm:onConfirm,title:title,...rest})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],confirm_modal_extends({role:"dialog",title:title,onClose:onCancel},rest),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],{"data-test-subj":"confirmModalBodyText"},children),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"confirmModalCancelButton",flush:"right",isDisabled:isLoading,onClick:onCancel},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.confirmModal.cancelButton",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"confirmModalConfirmButton",color:buttonColor,fill:true,isLoading:isLoading,isDisabled:isDisabled,onClick:onConfirm},confirmButtonText)))));const ConfirmDisableUsers=({usernames:usernames,onCancel:onCancel,onSuccess:onSuccess})=>{const{services:services}=Object(public_["useKibana"])();const isSystemUser=usernames[0]==="kibana"||usernames[0]==="kibana_system";const[state,disableUsers]=useAsyncFn_default()(async()=>{for(const username of usernames){try{await new management_users["UserAPIClient"](services.http).disableUser(username);services.notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDisableUsers.successMessage",{defaultMessage:"Deactivated user '{username}'",values:{username:username}}));onSuccess===null||onSuccess===void 0?void 0:onSuccess()}catch(error){var _body;services.notifications.toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDisableUsers.errorMessage",{defaultMessage:"Could not deactivate user '{username}'",values:{username:username}}),text:((_body=error.body)===null||_body===void 0?void 0:_body.message)||error.message})}}},[services.http]);return external_kbnSharedDeps_React_default.a.createElement(ConfirmModal,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDisableUsers.title",{defaultMessage:"Deactivate {count, plural, one{user '{username}'} other{{count} users}}?",values:{count:usernames.length,username:usernames[0]}}),onCancel:onCancel,onConfirm:disableUsers,confirmButtonText:isSystemUser?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDisableUsers.confirmSystemPasswordButton",{defaultMessage:"{isLoading, select, true{Deactivating user…} other{I understand, deactivate this user}}",values:{isLoading:state.loading}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDisableUsers.confirmButton",{defaultMessage:"{isLoading, select, true{Deactivating {count, plural, one{user} other{users}}…} other{Deactivate {count, plural, one{user} other{users}}}}",values:{count:usernames.length,isLoading:state.loading}}),confirmButtonColor:isSystemUser?"danger":undefined,isLoading:state.loading},isSystemUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDisableUsers.systemUserWarning",defaultMessage:"Deactivating the system user will prevent Kibana from communicating with Elasticsearch."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDisableUsers.systemUserDescription",defaultMessage:"Once deactivated, you must manually update your config file with different user details and restart Kibana."}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDisableUsers.description",defaultMessage:"{count, plural, one{This user} other{These users}} will no longer be able to access Elastic{count, plural, one{.} other{:}}",values:{count:usernames.length}})),usernames.length>1&&external_kbnSharedDeps_React_default.a.createElement("ul",null,usernames.map(username=>external_kbnSharedDeps_React_default.a.createElement("li",{key:username},username)))))};const ConfirmEnableUsers=({usernames:usernames,onCancel:onCancel,onSuccess:onSuccess})=>{const{services:services}=Object(public_["useKibana"])();const[state,enableUsers]=useAsyncFn_default()(async()=>{for(const username of usernames){try{await new management_users["UserAPIClient"](services.http).enableUser(username);services.notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmEnableUsers.successMessage",{defaultMessage:"Activated user '{username}'",values:{username:username}}));onSuccess===null||onSuccess===void 0?void 0:onSuccess()}catch(error){var _body;services.notifications.toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmEnableUsers.errorMessage",{defaultMessage:"Could not activate user '{username}'",values:{username:username}}),text:((_body=error.body)===null||_body===void 0?void 0:_body.message)||error.message})}}},[services.http]);return external_kbnSharedDeps_React_default.a.createElement(ConfirmModal,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmEnableUsers.title",{defaultMessage:"Activate {count, plural, one{user '{username}'} other{{count} users}}?",values:{count:usernames.length,username:usernames[0]}}),onCancel:onCancel,onConfirm:enableUsers,confirmButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmEnableUsers.confirmButton",{defaultMessage:"{isLoading, select, true{Activating {count, plural, one{user} other{users}}…} other{Activate {count, plural, one{user} other{users}}}}",values:{count:usernames.length,isLoading:state.loading}}),isLoading:state.loading},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmEnableUsers.description",defaultMessage:"{count, plural, one{This user} other{These users}} will be able to access Elastic{count, plural, one{.} other{:}}",values:{count:usernames.length}})),usernames.length>1&&external_kbnSharedDeps_React_default.a.createElement("ul",null,usernames.map(username=>external_kbnSharedDeps_React_default.a.createElement("li",{key:username},username)))))};const ConfirmDeleteUsers=({usernames:usernames,onCancel:onCancel,onSuccess:onSuccess})=>{const{services:services}=Object(public_["useKibana"])();const[state,deleteUsers]=useAsyncFn_default()(async()=>{for(const username of usernames){try{await new management_users["UserAPIClient"](services.http).deleteUser(username);services.notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDeleteUsers.successMessage",{defaultMessage:"Deleted user '{username}'",values:{username:username}}));onSuccess===null||onSuccess===void 0?void 0:onSuccess()}catch(error){var _body;services.notifications.toasts.addDanger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDeleteUsers.errorMessage",{defaultMessage:"Could not delete user '{username}'",values:{username:username}}),text:((_body=error.body)===null||_body===void 0?void 0:_body.message)||error.message})}}},[services.http]);return external_kbnSharedDeps_React_default.a.createElement(ConfirmModal,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDeleteUsers.title",{defaultMessage:"Delete {count, plural, one{user '{username}'} other{{count} users}}?",values:{count:usernames.length,username:usernames[0]}}),onCancel:onCancel,onConfirm:deleteUsers,confirmButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDeleteUsers.confirmButton",{defaultMessage:"{isLoading, select, true{Deleting {count, plural, one{user} other{users}}…} other{Delete {count, plural, one{user} other{users}}}}",values:{count:usernames.length,isLoading:state.loading}}),confirmButtonColor:"danger",isLoading:state.loading},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDeleteUsers.description",defaultMessage:"{count, plural, one{This user} other{These users}} will be permanently deleted and access to Elastic removed{count, plural, one{.} other{:}}",values:{count:usernames.length}})),usernames.length>1&&external_kbnSharedDeps_React_default.a.createElement("ul",null,usernames.map(username=>external_kbnSharedDeps_React_default.a.createElement("li",{key:username},username))),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDelete.cannotUndoWarning",defaultMessage:"You can't recover deleted users."}))))};const EditUserPage=({username:username})=>{var _user$metadata,_user$metadata$_depre;const{services:services}=Object(public_["useKibana"])();const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const[{value:user,error:error},getUser]=useAsyncFn_default()(()=>new management_users["UserAPIClient"](services.http).getUser(username),[services.http]);const[action,setAction]=Object(external_kbnSharedDeps_React_["useState"])("none");const backToUsers=()=>history.push("/");Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getUser()},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(error){backToUsers()}},[error]);if(!user){return null}const isReservedUser=Object(user_utils["c"])(user);const isDeprecatedUser=Object(user_utils["b"])(user);const displayName=Object(model["e"])(user);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAvatar"],{name:displayName,size:"xl"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,displayName)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,user.email))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),isDeprecatedUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.deprecatedUserWarning",defaultMessage:"This user is deprecated."}),iconType:"alert",color:"warning"},(_user$metadata=user.metadata)===null||_user$metadata===void 0?void 0:(_user$metadata$_depre=_user$metadata._deprecated_reason)===null||_user$metadata$_depre===void 0?void 0:_user$metadata$_depre.replace(/\[(.+)\]/,"'$1'")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):isReservedUser?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.reservedUserWarning",defaultMessage:"This user is built in and can't be updated or deleted."}),iconType:"lock"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):user.enabled===false?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.disabledUserWarning",defaultMessage:"This user has been deactivated and can't access Elastic."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>setAction("enableUser"),size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.enableUserButton",defaultMessage:"Activate user"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null)):undefined,external_kbnSharedDeps_React_default.a.createElement(UserForm,{isReservedUser:isReservedUser,defaultValues:user,onCancel:backToUsers,onSuccess:backToUsers}),action==="changePassword"?external_kbnSharedDeps_React_default.a.createElement(ChangePasswordFlyout,{username:username,onCancel:()=>setAction("none"),onSuccess:()=>setAction("none")}):action==="disableUser"?external_kbnSharedDeps_React_default.a.createElement(ConfirmDisableUsers,{usernames:[username],onCancel:()=>setAction("none"),onSuccess:()=>{setAction("none");getUser()}}):action==="enableUser"?external_kbnSharedDeps_React_default.a.createElement(ConfirmEnableUsers,{usernames:[username],onCancel:()=>setAction("none"),onSuccess:()=>{setAction("none");getUser()}}):action==="deleteUser"?external_kbnSharedDeps_React_default.a.createElement(ConfirmDeleteUsers,{usernames:[username],onCancel:()=>setAction("none"),onSuccess:backToUsers}):undefined,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{color:"subdued",hasShadow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.changePasswordTitle",defaultMessage:"Change password"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.changePasswordDescription",defaultMessage:"The user will not be able to log in using their previous password."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>setAction("changePassword"),size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.changePasswordButton",defaultMessage:"Change password"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),user.enabled===false?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{color:"subdued",hasShadow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.enableUserTitle",defaultMessage:"Activate user"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.enableUserDescription",defaultMessage:"Allow the user to access Elastic."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>setAction("enableUser"),size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.enableUserButton",defaultMessage:"Activate user"}))))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{color:"subdued",hasShadow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.disableUserTitle",defaultMessage:"Deactivate user"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.disableUserDescription",defaultMessage:"Prevent the user from accessing Elastic."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>setAction("disableUser"),size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.disableUserButton",defaultMessage:"Deactivate user"}))))),!isReservedUser&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{color:"subdued",hasShadow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.deleteUserTitle",defaultMessage:"Delete user"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.deleteUserDescription",defaultMessage:"Permanently delete the user and remove access to Elastic."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>setAction("deleteUser"),size:"s",color:"danger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.editUserPage.deleteUserButton",defaultMessage:"Delete user"}))))))))};const CreateUserPage=()=>{const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const backToUsers=()=>history.push("/");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.createUserPage.title",defaultMessage:"Create user"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(UserForm,{isNewUser:true,onCancel:backToUsers,onSuccess:backToUsers})))}},97:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return isUserReserved}));__webpack_require__.d(__webpack_exports__,"b",(function(){return isUserDeprecated}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getExtendedUserDeprecationNotice}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const isUserReserved=user=>{var _user$metadata$_reser,_user$metadata;return(_user$metadata$_reser=(_user$metadata=user.metadata)===null||_user$metadata===void 0?void 0:_user$metadata._reserved)!==null&&_user$metadata$_reser!==void 0?_user$metadata$_reser:false};const isUserDeprecated=user=>{var _user$metadata$_depre,_user$metadata2;return(_user$metadata$_depre=(_user$metadata2=user.metadata)===null||_user$metadata2===void 0?void 0:_user$metadata2._deprecated)!==null&&_user$metadata$_depre!==void 0?_user$metadata$_depre:false};const getExtendedUserDeprecationNotice=user=>{var _user$metadata$_depre2,_user$metadata3;const reason=(_user$metadata$_depre2=(_user$metadata3=user.metadata)===null||_user$metadata3===void 0?void 0:_user$metadata3._deprecated_reason)!==null&&_user$metadata$_depre2!==void 0?_user$metadata$_depre2:"";return _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.security.management.users.extendedUserDeprecationNotice",{defaultMessage:`The {username} user is deprecated. {reason}`,values:{username:user.username,reason:reason}})}}}]);