/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["security_bundle_jsonpfunction"]=window["security_bundle_jsonpfunction"]||[]).push([[7],{101:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return RoleTableDisplay}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var model=__webpack_require__(13);const RoleTableDisplay=({role:role,navigateToApp:navigateToApp})=>{let content;let path;if(typeof role==="string"){content=external_kbnSharedDeps_React_default.a.createElement("div",null,role);path=`security/roles/edit/${encodeURIComponent(role)}`}else if(Object(model["g"])(role)){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:Object(model["d"])(role),"data-test-subj":"roleDeprecationTooltip"},external_kbnSharedDeps_React_default.a.createElement("div",null,role.name," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"alert",color:"warning",size:"s",className:"eui-alignTop"})));path=`security/roles/edit/${encodeURIComponent(role.name)}`}else{content=external_kbnSharedDeps_React_default.a.createElement("div",null,role.name);path=`security/roles/edit/${encodeURIComponent(role.name)}`}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>navigateToApp("management",{path:path})},content)}},304:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"UsersGridPage",(function(){return users_grid_page_UsersGridPage}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var change_password_form=__webpack_require__(91);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class confirm_delete_users_ConfirmDeleteUsers extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);_defineProperty(this,"deleteUsers",()=>{const{usersToDelete:usersToDelete,callback:callback,userAPIClient:userAPIClient,notifications:notifications}=this.props;const errors=[];usersToDelete.forEach(async username=>{try{await userAPIClient.deleteUser(username);notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDelete.userSuccessfullyDeletedNotificationMessage",{defaultMessage:"Deleted user {username}",values:{username:username}}))}catch(e){errors.push(username);notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDelete.userDeletingErrorNotificationMessage",{defaultMessage:"Error deleting user {username}",values:{username:username}}))}if(callback){callback(usersToDelete,errors)}})})}render(){const{usersToDelete:usersToDelete,onCancel:onCancel}=this.props;const moreThanOne=usersToDelete.length>1;const title=moreThanOne?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDelete.deleteMultipleUsersTitle",{defaultMessage:"Delete {userLength} users",values:{userLength:usersToDelete.length}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDelete.deleteOneUserTitle",{defaultMessage:"Delete user {userLength}",values:{userLength:usersToDelete[0]}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:title,onCancel:onCancel,onConfirm:this.deleteUsers,cancelButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDelete.cancelButtonLabel",{defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.confirmDelete.confirmButtonLabel",{defaultMessage:"Delete"}),buttonColor:"danger"},external_kbnSharedDeps_React_default.a.createElement("div",null,moreThanOne?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDelete.removingUsersDescription",defaultMessage:"You are about to delete these users:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,usersToDelete.map(username=>external_kbnSharedDeps_React_default.a.createElement("li",{key:username},username)))):null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.confirmDelete.removingUsersWarningMessage",defaultMessage:"This operation cannot be undone."}))))}}var user_utils=__webpack_require__(97);var management_badges=__webpack_require__(88);var role_table_display=__webpack_require__(101);var public_=__webpack_require__(6);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function users_grid_page_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class users_grid_page_UsersGridPage extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);users_grid_page_defineProperty(this,"handleDelete",(usernames,errors)=>{const{users:users}=this.state;const filteredUsers=users.filter(({username:username})=>!usernames.includes(username)||errors.includes(username));this.setState({selection:[],showDeleteConfirmation:false,users:filteredUsers,visibleUsers:this.getVisibleUsers(filteredUsers,this.state.filter,this.state.includeReservedUsers)})});users_grid_page_defineProperty(this,"getVisibleUsers",(users,filter,includeReservedUsers)=>users.filter(({username:username,roles:userRoles,full_name:fullName="",email:email="",metadata:metadata={}})=>{const normalized=`${username} ${userRoles.join(" ")} ${fullName} ${email}`.toLowerCase();const normalizedQuery=filter.toLowerCase();return normalized.indexOf(normalizedQuery)!==-1&&(includeReservedUsers||!metadata._reserved)}));users_grid_page_defineProperty(this,"onIncludeReservedUsersChange",e=>{this.setState({includeReservedUsers:e.target.checked,visibleUsers:this.getVisibleUsers(this.state.users,this.state.filter,e.target.checked)})});users_grid_page_defineProperty(this,"getUserStatusBadges",user=>{const enabled=user.enabled;const reserved=Object(user_utils["c"])(user);const deprecated=Object(user_utils["b"])(user);const badges=[];if(!enabled){badges.push(external_kbnSharedDeps_React_default.a.createElement(management_badges["b"],{"data-test-subj":"userDisabled"}))}if(reserved){badges.push(external_kbnSharedDeps_React_default.a.createElement(management_badges["d"],{"data-test-subj":"userReserved",tooltipContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.reservedUserBadgeTooltip",defaultMessage:"Reserved users are built-in and cannot be edited or removed."})}))}if(deprecated){badges.push(external_kbnSharedDeps_React_default.a.createElement(management_badges["a"],{"data-test-subj":"userDeprecated",tooltipContent:Object(user_utils["a"])(user)}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",wrap:true},badges.map((badge,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index,grow:false},badge)))});users_grid_page_defineProperty(this,"onCancelDelete",()=>{this.setState({showDeleteConfirmation:false})});this.state={users:[],visibleUsers:[],roles:[],selection:[],showDeleteConfirmation:false,permissionDenied:false,filter:"",includeReservedUsers:true}}componentDidMount(){this.loadUsersAndRoles()}render(){const{users:users,roles:roles,permissionDenied:permissionDenied,showDeleteConfirmation:showDeleteConfirmation,selection:selection}=this.state;if(permissionDenied){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{horizontalPosition:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.deniedPermissionTitle",defaultMessage:"You need permission to manage users"})),body:external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"permissionDeniedMessage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.permissionDeniedToManageUsersDescription",defaultMessage:"Contact your system administrator."}))})))}const columns=[{field:"username",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.userNameColumnName",{defaultMessage:"User Name"}),sortable:true,truncateText:true,render:username=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],_extends({"data-test-subj":"userRowUserName"},Object(public_["reactRouterNavigate"])(this.props.history,`/edit/${encodeURIComponent(username)}`)),username)},{field:"full_name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.fullNameColumnName",{defaultMessage:"Full Name"}),sortable:true,truncateText:true,render:fullName=>external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"userRowFullName"},fullName)},{field:"email",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.emailAddressColumnName",{defaultMessage:"Email Address"}),sortable:true,truncateText:true,render:email=>external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"userRowEmail"},email)},{field:"roles",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.rolesColumnName",{defaultMessage:"Roles"}),width:"30%",render:rolenames=>{const roleLinks=rolenames.map((rolename,index)=>{var _roles$find;const roleDefinition=(_roles$find=roles===null||roles===void 0?void 0:roles.find(role=>role.name===rolename))!==null&&_roles$find!==void 0?_roles$find:rolename;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,key:rolename},external_kbnSharedDeps_React_default.a.createElement(role_table_display["a"],{role:roleDefinition,navigateToApp:this.props.navigateToApp}))});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{"data-test-subj":"userRowRoles",gutterSize:"s",wrap:true},roleLinks)}},{field:"metadata",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.statusColumnName",{defaultMessage:"Status"}),width:"10%",sortable:({metadata:metadata})=>Boolean(metadata&&metadata._reserved),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.reservedColumnDescription",{defaultMessage:"Reserved users are built-in and cannot be removed. Only the password can be changed."}),render:(metadata,record)=>this.getUserStatusBadges(record)}];const pagination={initialPageSize:20,pageSizeOptions:[10,20,50,100]};const selectionConfig={itemId:"username",selectable:user=>!(user.metadata&&user.metadata._reserved),selectableMessage:selectable=>!selectable?"User is a system user":"",onSelectionChange:updatedSelection=>this.setState({selection:updatedSelection})};const search={toolsLeft:this.renderToolsLeft(),toolsRight:this.renderToolsRight(),box:{incremental:true,"data-test-subj":"searchUsers"},onChange:query=>{this.setState({filter:query.queryText,visibleUsers:this.getVisibleUsers(this.state.users,query.queryText,this.state.includeReservedUsers)})}};const sorting={sort:{field:"username",direction:"asc"}};const rowProps=()=>({"data-test-subj":"userRow"});return external_kbnSharedDeps_React_default.a.createElement("div",{className:"secUsersListingPage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{className:"secUsersListingPage__content"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.usersTitle",defaultMessage:"Users"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],_extends({"data-test-subj":"createUserButton"},Object(public_["reactRouterNavigate"])(this.props.history,`/create`)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.createNewUserButtonLabel",defaultMessage:"Create user"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,showDeleteConfirmation?external_kbnSharedDeps_React_default.a.createElement(confirm_delete_users_ConfirmDeleteUsers,{onCancel:this.onCancelDelete,usersToDelete:selection.map(user=>user.username),callback:this.handleDelete,userAPIClient:this.props.userAPIClient,notifications:this.props.notifications}):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{itemId:"username",tableCaption:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.tableCaption",{defaultMessage:"Users"}),rowHeader:"username",columns:columns,selection:selectionConfig,pagination:pagination,items:this.state.visibleUsers,loading:users.length===0,search:search,sorting:sorting,rowProps:rowProps,isSelectable:true}))))}async loadUsersAndRoles(){try{const[users,roles]=await Promise.all([this.props.userAPIClient.getUsers(),this.props.rolesAPIClient.getRoles()]);this.setState({users:users,roles:roles,visibleUsers:this.getVisibleUsers(users,this.state.filter,this.state.includeReservedUsers)})}catch(e){if(e.body.statusCode===403){this.setState({permissionDenied:true})}else{this.props.notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.fetchingUsersErrorMessage",{defaultMessage:"Error fetching users: {message}",values:{message:e.body.message}}))}}}renderToolsLeft(){const{selection:selection}=this.state;if(selection.length===0){return}const numSelected=selection.length;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"deleteUserButton",color:"danger",onClick:()=>this.setState({showDeleteConfirmation:true})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.deleteUsersButtonLabel",defaultMessage:"Delete {numSelected} user{numSelected, plural, one { } other {s}}",values:{numSelected:numSelected}}))}renderToolsRight(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{"data-test-subj":"showReservedUsersSwitch",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.users.showReservedUsersLabel",defaultMessage:"Show reserved users"}),checked:this.state.includeReservedUsers,onChange:this.onIncludeReservedUsersChange})}}},88:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DeprecatedBadge}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DisabledBadge}));__webpack_require__.d(__webpack_exports__,"c",(function(){return EnabledBadge}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ReservedBadge}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);const OptionalToolTip=props=>{if(props.tooltipContent){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:props.tooltipContent},props.children)}return props.children};const DeprecatedBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.deprecatedBadge",defaultMessage:"Deprecated"})));const DisabledBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"hollow"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.disabledBadge",defaultMessage:"Disabled"})));const EnabledBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"secondary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.enabledBadge",defaultMessage:"Enabled"})));const ReservedBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.reservedBadge",defaultMessage:"Reserved"})))},91:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return change_password_form_ChangePasswordForm}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_Lodash_=__webpack_require__(14);var external_kbnSharedDeps_Lodash_default=__webpack_require__.n(external_kbnSharedDeps_Lodash_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}function getInitialState(){return{shouldValidate:false,currentPassword:"",newPassword:"",confirmPassword:"",currentPasswordError:false,changeInProgress:false}}class change_password_form_ChangePasswordForm extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);_defineProperty(this,"getForm",()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,this.props.isUserChangingOwnPassword&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],_extends({},this.validateCurrentPassword(),{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.currentPasswordLabel",defaultMessage:"Current password"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{autoComplete:"off","data-test-subj":"currentPassword",type:"dual",value:this.state.currentPassword,onChange:this.onCurrentPasswordChange,disabled:this.state.changeInProgress,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],_extends({helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.passwordRequirements",defaultMessage:"Use at least 6 characters."})},this.validateNewPassword(),{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.newPasswordLabel",defaultMessage:"New password"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{autoComplete:"new-password","data-test-subj":"newPassword",type:"dual",value:this.state.newPassword,onChange:this.onNewPasswordChange,disabled:this.state.changeInProgress,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],_extends({},this.validateConfirmPassword(),{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.confirmPasswordLabel",defaultMessage:"Confirm new password"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{autoComplete:"new-password","data-test-subj":"confirmNewPassword",type:"dual",value:this.state.confirmPassword,onChange:this.onConfirmPasswordChange,disabled:this.state.changeInProgress,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:this.onChangePasswordClick,fill:true,isLoading:this.state.changeInProgress,"data-test-subj":"changePasswordButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.saveChangesButtonLabel",defaultMessage:"Change password"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:this.onCancelClick,isDisabled:this.state.changeInProgress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.cancelButtonLabel",defaultMessage:"Reset"})))))));_defineProperty(this,"onCurrentPasswordChange",e=>{this.setState({currentPassword:e.target.value,currentPasswordError:false})});_defineProperty(this,"onNewPasswordChange",e=>{this.setState({newPassword:e.target.value})});_defineProperty(this,"onConfirmPasswordChange",e=>{this.setState({confirmPassword:e.target.value})});_defineProperty(this,"onCancelClick",()=>{this.setState(getInitialState())});_defineProperty(this,"onChangePasswordClick",async()=>{this.setState({shouldValidate:true,currentPasswordError:false},()=>{const{isInvalid:isInvalid}=this.validateForm();if(isInvalid){return}this.setState({changeInProgress:true},()=>this.performPasswordChange())})});_defineProperty(this,"validateCurrentPassword",(shouldValidate=this.state.shouldValidate)=>{if(!shouldValidate||!this.props.isUserChangingOwnPassword){return{isInvalid:false}}if(this.state.currentPasswordError){return{isInvalid:true,error:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.changePasswordForm.invalidPassword",defaultMessage:"Current password is incorrect."})}}if(!this.state.currentPassword){return{isInvalid:true,error:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.currentPasswordRequired",defaultMessage:"Current password is required."})}}return{isInvalid:false}});_defineProperty(this,"validateNewPassword",(shouldValidate=this.state.shouldValidate)=>{const{newPassword:newPassword}=this.state;const minPasswordLength=6;if(shouldValidate&&newPassword.length<minPasswordLength){return{isInvalid:true,error:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.passwordLengthDescription",defaultMessage:"Password is too short."})}}return{isInvalid:false}});_defineProperty(this,"validateConfirmPassword",(shouldValidate=this.state.shouldValidate)=>{const{newPassword:newPassword,confirmPassword:confirmPassword}=this.state;if(shouldValidate&&newPassword!==confirmPassword){return{isInvalid:true,error:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.account.passwordsDoNotMatch",defaultMessage:"Passwords do not match."})}}return{isInvalid:false}});_defineProperty(this,"validateForm",()=>{const validation=[this.validateCurrentPassword(true),this.validateNewPassword(true),this.validateConfirmPassword(true)];const firstFailure=validation.find(result=>result.isInvalid);if(firstFailure){return firstFailure}return{isInvalid:false}});_defineProperty(this,"performPasswordChange",async()=>{try{await this.props.userAPIClient.changePassword(this.props.user.username,this.state.newPassword,this.state.currentPassword);this.handleChangePasswordSuccess()}catch(e){this.handleChangePasswordFailure(e)}finally{this.setState({changeInProgress:false})}});_defineProperty(this,"handleChangePasswordSuccess",()=>{this.props.notifications.toasts.addSuccess({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.account.changePasswordSuccess",{defaultMessage:"Your password has been changed."}),"data-test-subj":"passwordUpdateSuccess"});this.setState({currentPasswordError:false,shouldValidate:false,newPassword:"",currentPassword:"",confirmPassword:""});if(this.props.onChangePassword){this.props.onChangePassword()}});_defineProperty(this,"handleChangePasswordFailure",error=>{if(error.body&&error.body.statusCode===403){this.setState({currentPasswordError:true})}else{this.props.notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.users.editUser.settingPasswordErrorMessage",{defaultMessage:"Error setting password: {message}",values:{message:external_kbnSharedDeps_Lodash_default.a.get(error,"body.message")}}))}});this.state=getInitialState()}render(){return this.getForm()}}},97:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return isUserReserved}));__webpack_require__.d(__webpack_exports__,"b",(function(){return isUserDeprecated}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getExtendedUserDeprecationNotice}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const isUserReserved=user=>{var _user$metadata$_reser,_user$metadata;return(_user$metadata$_reser=(_user$metadata=user.metadata)===null||_user$metadata===void 0?void 0:_user$metadata._reserved)!==null&&_user$metadata$_reser!==void 0?_user$metadata$_reser:false};const isUserDeprecated=user=>{var _user$metadata$_depre,_user$metadata2;return(_user$metadata$_depre=(_user$metadata2=user.metadata)===null||_user$metadata2===void 0?void 0:_user$metadata2._deprecated)!==null&&_user$metadata$_depre!==void 0?_user$metadata$_depre:false};const getExtendedUserDeprecationNotice=user=>{var _user$metadata$_depre2,_user$metadata3;const reason=(_user$metadata$_depre2=(_user$metadata3=user.metadata)===null||_user$metadata3===void 0?void 0:_user$metadata3._deprecated_reason)!==null&&_user$metadata$_depre2!==void 0?_user$metadata$_depre2:"";return _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.security.management.users.extendedUserDeprecationNotice",{defaultMessage:`The {username} user is deprecated. {reason}`,values:{username:user.username,reason:reason}})}}}]);