/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["security_bundle_jsonpfunction"]=window["security_bundle_jsonpfunction"]||[]).push([[15],{299:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"APIKeysGridPage",(function(){return api_keys_grid_page_APIKeysGridPage}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(77);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);var public_=__webpack_require__(78);const PermissionDenied=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{horizontalPosition:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",title:external_kbnSharedDeps_React_default.a.createElement("h2",{"data-test-subj":"apiKeysPermissionDeniedMessage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.deniedPermissionTitle",defaultMessage:"You need permission to manage API keys"})),body:external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"permissionDeniedMessage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.noPermissionToManageRolesDescription",defaultMessage:"Contact your system administrator."}))})));var kibanaReact_public_=__webpack_require__(6);const EmptyPrompt=({isAdmin:isAdmin})=>{const{services:services}=Object(kibanaReact_public_["useKibana"])();const application=services.application;const docLinks=services.docLinks;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"managementApp",title:external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":"noApiKeysHeader"},isAdmin?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.emptyPromptAdminTitle",defaultMessage:"No API keys"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.emptyPromptNonAdminTitle",defaultMessage:"You don't have any API keys"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.emptyPromptDescription",defaultMessage:"You can create an {link} from Console.",values:{link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:docLinks.links.apis.createApiKey,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.emptyPromptDocsLinkMessage",defaultMessage:"API key"}))}}))),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"primary",onClick:()=>application.navigateToApp("dev_tools"),"data-test-subj":"goToConsoleButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.emptyPromptConsoleButtonMessage",defaultMessage:"Go to Console"})),"data-test-subj":"emptyPrompt"})};const NotEnabled=()=>{const docLinks=Object(kibanaReact_public_["useKibana"])().services.docLinks;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysDisabledErrorTitle",defaultMessage:"API keys not enabled in Elasticsearch"}),color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysDisabledErrorDescription",defaultMessage:"Contact your system administrator and refer to the {link} to enable API keys.",values:{link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:`${docLinks.links.security.apiKeyServiceSettings}`,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysDisabledErrorLinkText",defaultMessage:"docs"}))}}))};const InvalidateProvider=({isAdmin:isAdmin,children:children,notifications:notifications,apiKeysAPIClient:apiKeysAPIClient})=>{const[apiKeys,setApiKeys]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const invalidateApiKeyPrompt=(keys,onSuccess=(()=>undefined))=>{if(!keys||!keys.length){throw new Error("No API key IDs specified for invalidation")}setIsModalOpen(true);setApiKeys(keys);onSuccessCallback.current=onSuccess};const closeModal=()=>{setIsModalOpen(false);setApiKeys([])};const invalidateApiKey=async()=>{let result;let error;let errors;try{result=await apiKeysAPIClient.invalidateApiKeys(apiKeys,isAdmin)}catch(e){error=e}closeModal();if(result){const{itemsInvalidated:itemsInvalidated}=result;({errors:errors}=result);if(itemsInvalidated&&itemsInvalidated.length){const hasMultipleSuccesses=itemsInvalidated.length>1;const successMessage=hasMultipleSuccesses?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.successMultipleNotificationTitle",{defaultMessage:"Invalidated {count} API keys",values:{count:itemsInvalidated.length}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.successSingleNotificationTitle",{defaultMessage:"Invalidated API key '{name}'",values:{name:itemsInvalidated[0].name}});notifications.toasts.addSuccess(successMessage);if(onSuccessCallback.current){onSuccessCallback.current([...itemsInvalidated])}}}if(error||errors&&errors.length){const hasMultipleErrors=errors&&errors.length>1||error&&apiKeys.length>1;const errorMessage=hasMultipleErrors?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.errorMultipleNotificationTitle",{defaultMessage:"Error deleting {count} apiKeys",values:{count:errors&&errors.length||apiKeys.length}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.errorSingleNotificationTitle",{defaultMessage:"Error deleting API key '{name}'",values:{name:errors&&errors[0].name||apiKeys[0].name}});notifications.toasts.addDanger(errorMessage)}};const renderModal=()=>{if(!isModalOpen){return null}const isSingle=apiKeys.length===1;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:isSingle?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.confirmModal.invalidateSingleTitle",{defaultMessage:"Invalidate API key '{name}'?",values:{name:apiKeys[0].name}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.confirmModal.invalidateMultipleTitle",{defaultMessage:"Invalidate {count} API keys?",values:{count:apiKeys.length}}),onCancel:closeModal,onConfirm:invalidateApiKey,cancelButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.confirmModal.cancelButtonLabel",{defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.confirmModal.confirmButtonLabel",{defaultMessage:"Invalidate {count, plural, one {API key} other {API keys}}",values:{count:apiKeys.length}}),buttonColor:"danger","data-test-subj":"invalidateApiKeyConfirmationModal"},!isSingle?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.invalidateApiKey.confirmModal.invalidateMultipleListDescription",{defaultMessage:"You are about to invalidate these API keys:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,apiKeys.map(({name:name,id:id})=>external_kbnSharedDeps_React_default.a.createElement("li",{key:id},name)))):null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(invalidateApiKeyPrompt),renderModal())};function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const DATE_FORMAT="MMMM Do YYYY HH:mm:ss";class api_keys_grid_page_APIKeysGridPage extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);_defineProperty(this,"renderTable",()=>{const{apiKeys:apiKeys,selectedItems:selectedItems,isLoadingTable:isLoadingTable,isAdmin:isAdmin}=this.state;const message=isLoadingTable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysTableLoadingMessage",defaultMessage:"Loading API keys…"}):undefined;const sorting={sort:{field:"expiration",direction:"asc"}};const pagination={initialPageSize:20,pageSizeOptions:[10,20,50]};const selection={onSelectionChange:newSelectedItems=>{this.setState({selectedItems:newSelectedItems})}};const search={toolsLeft:selectedItems.length?external_kbnSharedDeps_React_default.a.createElement(InvalidateProvider,{isAdmin:isAdmin,notifications:this.props.notifications,apiKeysAPIClient:this.props.apiKeysAPIClient},invalidateApiKeyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>invalidateApiKeyPrompt(selectedItems.map(({name:name,id:id})=>({name:name,id:id})),this.onApiKeysInvalidated),color:"danger","data-test-subj":"bulkInvalidateActionButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.invalidateApiKeyButton",defaultMessage:"Invalidate {count, plural, one {API key} other {API keys}}",values:{count:selectedItems.length}}))):undefined,toolsRight:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"secondary",iconType:"refresh",onClick:()=>this.reloadApiKeys(),"data-test-subj":"reloadButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.reloadApiKeysButton",defaultMessage:"Reload"})),box:{incremental:true},filters:isAdmin?[{type:"field_value_selection",field:"username",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.userFilterLabel",{defaultMessage:"User"}),multiSelect:false,options:Object.keys(apiKeys.reduce((apiKeysMap,apiKey)=>{apiKeysMap[apiKey.username]=true;return apiKeysMap},{})).map(username=>({value:username,view:username}))},{type:"field_value_selection",field:"realm",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.realmFilterLabel",{defaultMessage:"Realm"}),multiSelect:false,options:Object.keys(apiKeys.reduce((apiKeysMap,apiKey)=>{apiKeysMap[apiKey.realm]=true;return apiKeysMap},{})).map(realm=>({value:realm,view:realm}))}]:undefined};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isAdmin?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.adminText",defaultMessage:"You are an API Key administrator."}),color:"success",iconType:"user",size:"s","data-test-subj":"apiKeyAdminDescriptionCallOut"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})):undefined,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{items:apiKeys,itemId:"id",columns:this.getColumnConfig(),search:search,sorting:sorting,selection:selection,pagination:pagination,loading:isLoadingTable,message:message,isSelectable:true,rowProps:()=>({"data-test-subj":"apiKeyRow"})}))});_defineProperty(this,"getColumnConfig",()=>{const{isAdmin:isAdmin}=this.state;let config=[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.nameColumnName",{defaultMessage:"Name"}),sortable:true}];if(isAdmin){config=config.concat([{field:"username",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.userNameColumnName",{defaultMessage:"User"}),sortable:true},{field:"realm",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.realmColumnName",{defaultMessage:"Realm"}),sortable:true}])}config=config.concat([{field:"creation",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.creationDateColumnName",{defaultMessage:"Created"}),sortable:true,render:creationDateMs=>external_kbnSharedDeps_MomentTimezone_default()(creationDateMs).format(DATE_FORMAT)},{field:"expiration",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.expirationDateColumnName",{defaultMessage:"Expires"}),sortable:true,render:expirationDateMs=>{if(expirationDateMs===undefined){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.expirationDateNeverMessage",{defaultMessage:"Never"}))}return external_kbnSharedDeps_MomentTimezone_default()(expirationDateMs).format(DATE_FORMAT)}},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.statusColumnName",{defaultMessage:"Status"}),render:({expiration:expiration})=>{const now=Date.now();if(now>expiration){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"hollow"},"Expired")}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"secondary"},"Active")}},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.actionsColumnName",{defaultMessage:"Actions"}),actions:[{render:({name:name,id:id})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(InvalidateProvider,{isAdmin:isAdmin,notifications:this.props.notifications,apiKeysAPIClient:this.props.apiKeysAPIClient},invalidateApiKeyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.actionDeleteTooltip",{defaultMessage:"Invalidate"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.actionDeleteAriaLabel",{defaultMessage:`Invalidate '{name}'`,values:{name:name}}),iconType:"minusInCircle",color:"danger","data-test-subj":"invalidateApiKeyButton",onClick:()=>invalidateApiKeyPrompt([{id:id,name:name}],this.onApiKeysInvalidated)})))))}]}]);return config});_defineProperty(this,"onApiKeysInvalidated",apiKeysInvalidated=>{if(apiKeysInvalidated.length){this.reloadApiKeys()}});_defineProperty(this,"initiallyLoadApiKeys",()=>{this.setState({isLoadingApp:true,isLoadingTable:false});this.loadApiKeys()});_defineProperty(this,"reloadApiKeys",()=>{this.setState({apiKeys:[],isLoadingApp:false,isLoadingTable:true});this.loadApiKeys()});_defineProperty(this,"loadApiKeys",async()=>{try{const{isAdmin:isAdmin}=this.state;const{apiKeys:apiKeys}=await this.props.apiKeysAPIClient.getApiKeys(isAdmin);this.setState({apiKeys:apiKeys})}catch(e){this.setState({error:e})}this.setState({isLoadingApp:false,isLoadingTable:false})});this.state={isLoadingApp:true,isLoadingTable:false,isAdmin:false,canManage:false,areApiKeysEnabled:false,apiKeys:[],selectedItems:[],error:undefined}}componentDidMount(){this.checkPrivileges()}render(){const{isLoadingApp:isLoadingApp,isLoadingTable:isLoadingTable,areApiKeysEnabled:areApiKeysEnabled,isAdmin:isAdmin,canManage:canManage,error:error,apiKeys:apiKeys}=this.state;if(isLoadingApp){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(public_["SectionLoading"],{"data-test-subj":"apiKeysSectionLoading"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.loadingApiKeysDescription",defaultMessage:"Loading API keys…"})))}if(!canManage){return external_kbnSharedDeps_React_default.a.createElement(PermissionDenied,null)}if(error){const{body:{error:errorTitle,message:message,statusCode:statusCode}}=error;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.loadingApiKeysErrorTitle",defaultMessage:"Error loading API keys"}),color:"danger",iconType:"alert","data-test-subj":"apiKeysError"},statusCode,": ",errorTitle," - ",message))}if(!areApiKeysEnabled){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(NotEnabled,null))}if(!isLoadingTable&&apiKeys&&apiKeys.length===0){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(EmptyPrompt,{isAdmin:isAdmin}))}const description=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s","data-test-subj":"apiKeysDescriptionText"},external_kbnSharedDeps_React_default.a.createElement("p",null,isAdmin?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysAllDescription",defaultMessage:"View and invalidate API keys. An API key sends requests on behalf of a user."}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysOwnDescription",defaultMessage:"View and invalidate your API keys. An API key sends requests on your behalf."})));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.apiKeys.table.apiKeysTitle",defaultMessage:"API Keys"}))),description)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,this.renderTable()))}async checkPrivileges(){try{const{isAdmin:isAdmin,canManage:canManage,areApiKeysEnabled:areApiKeysEnabled}=await this.props.apiKeysAPIClient.checkPrivileges();this.setState({isAdmin:isAdmin,canManage:canManage,areApiKeysEnabled:areApiKeysEnabled});if(!canManage||!areApiKeysEnabled){this.setState({isLoadingApp:false})}else{this.initiallyLoadApiKeys()}}catch(e){var _e$body$message,_e$body;this.props.notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.apiKeys.table.fetchingApiKeysErrorMessage",{defaultMessage:"Error checking privileges: {message}",values:{message:(_e$body$message=(_e$body=e.body)===null||_e$body===void 0?void 0:_e$body.message)!==null&&_e$body$message!==void 0?_e$body$message:""}}))}}}}}]);