/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["security_bundle_jsonpfunction"]=window["security_bundle_jsonpfunction"]||[]).push([[11],{302:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"RolesGridPage",(function(){return roles_grid_page_RolesGridPage}));var external_kbnSharedDeps_Lodash_=__webpack_require__(14);var external_kbnSharedDeps_Lodash_default=__webpack_require__.n(external_kbnSharedDeps_Lodash_);var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var model=__webpack_require__(13);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class confirm_delete_ConfirmDelete extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);_defineProperty(this,"onConfirmDelete",()=>{this.setState({deleteInProgress:true},()=>{this.deleteRoles()})});_defineProperty(this,"deleteRoles",async()=>{const{rolesToDelete:rolesToDelete,callback:callback,rolesAPIClient:rolesAPIClient,notifications:notifications}=this.props;const errors=[];const deleteOperations=rolesToDelete.map(roleName=>{const deleteRoleTask=async()=>{try{await rolesAPIClient.deleteRole(roleName);notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.confirmDelete.roleSuccessfullyDeletedNotificationMessage",{defaultMessage:"Deleted role {roleName}",values:{roleName:roleName}}))}catch(e){errors.push(roleName);notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.confirmDelete.roleDeletingErrorNotificationMessage",{defaultMessage:"Error deleting role {roleName}",values:{roleName:roleName}}))}};return deleteRoleTask()});await Promise.all(deleteOperations);callback(rolesToDelete,errors)});this.state={deleteInProgress:false}}render(){const{rolesToDelete:rolesToDelete}=this.props;const moreThanOne=rolesToDelete.length>1;const title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.deleteRoleTitle",{defaultMessage:"Delete role{value, plural, one {{roleName}} other {s}}",values:{value:rolesToDelete.length,roleName:` ${rolesToDelete[0]}`}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:this.props.onCancel},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],{"data-test-subj":"confirmModalTitleText"},title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,moreThanOne?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.confirmDelete.removingRolesDescription",defaultMessage:"You are about to delete these roles:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,rolesToDelete.map(roleName=>external_kbnSharedDeps_React_default.a.createElement("li",{key:roleName},roleName)))):null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.deletingRolesWarningMessage",defaultMessage:"You can't undo this operation."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"confirmModalCancelButton",onClick:this.props.onCancel,isDisabled:this.state.deleteInProgress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.confirmDelete.cancelButtonLabel",defaultMessage:"Cancel"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"confirmModalConfirmButton",onClick:this.onConfirmDelete,fill:true,color:"danger",isLoading:this.state.deleteInProgress},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.confirmDelete.deleteButtonLabel",defaultMessage:"Delete"}))))}}const PermissionDenied=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{horizontalPosition:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.deniedPermissionTitle",defaultMessage:"You need permission to manage roles"})),body:external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"permissionDeniedMessage"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.noPermissionToManageRolesDescription",defaultMessage:"Contact your system administrator."}))})));var management_badges=__webpack_require__(88);var public_=__webpack_require__(6);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function roles_grid_page_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const getRoleManagementHref=(action,roleName)=>`/${action}${roleName?`/${encodeURIComponent(roleName)}`:""}`;class roles_grid_page_RolesGridPage extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);roles_grid_page_defineProperty(this,"getPageContent",()=>{const{roles:roles}=this.state;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.roleTitle",defaultMessage:"Roles"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.subtitle",defaultMessage:"Apply roles to groups of users and manage permissions across the stack."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],_extends({"data-test-subj":"createRoleButton"},Object(public_["reactRouterNavigate"])(this.props.history,getRoleManagementHref("edit"))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.createRoleButtonLabel",defaultMessage:"Create role"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,this.state.showDeleteConfirmation?external_kbnSharedDeps_React_default.a.createElement(confirm_delete_ConfirmDelete,{onCancel:this.onCancelDelete,rolesToDelete:this.state.selection.map(role=>role.name),callback:this.handleDelete,notifications:this.props.notifications,rolesAPIClient:this.props.rolesAPIClient}):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{itemId:"name",responsive:false,columns:this.getColumnConfig(),hasActions:true,selection:{selectable:role=>!role.metadata||!role.metadata._reserved,selectableMessage:selectable=>!selectable?"Role is reserved":"",onSelectionChange:selection=>this.setState({selection:selection})},pagination:{initialPageSize:20,pageSizeOptions:[10,20,30,50,100]},items:this.state.visibleRoles,loading:roles.length===0,search:{toolsLeft:this.renderToolsLeft(),toolsRight:this.renderToolsRight(),box:{incremental:true,"data-test-subj":"searchRoles"},onChange:query=>{this.setState({filter:query.queryText,visibleRoles:this.getVisibleRoles(this.state.roles,query.queryText,this.state.includeReservedRoles)})}},sorting:{sort:{field:"name",direction:"asc"}},rowProps:()=>({"data-test-subj":"roleRow"}),isSelectable:true})))});roles_grid_page_defineProperty(this,"getColumnConfig",()=>[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.nameColumnName",{defaultMessage:"Role"}),sortable:true,truncateText:true,render:(name,record)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],_extends({"data-test-subj":"roleRowName"},Object(public_["reactRouterNavigate"])(this.props.history,getRoleManagementHref("edit",name))),name))},{field:"metadata",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.statusColumnName",{defaultMessage:"Status"}),sortable:role=>Object(model["h"])(role)&&!Object(model["g"])(role),render:(metadata,record)=>this.getRoleStatusBadges(record)},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.actionsColumnName",{defaultMessage:"Actions"}),width:"150px",actions:[{available:role=>!Object(model["i"])(role),render:role=>{const title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.editRoleActionName",{defaultMessage:`Edit {roleName}`,values:{roleName:role.name}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],_extends({"aria-label":title,"data-test-subj":`edit-role-action-${role.name}`,title:title,color:"primary",iconType:"pencil"},Object(public_["reactRouterNavigate"])(this.props.history,getRoleManagementHref("edit",role.name))))}},{available:role=>!Object(model["j"])(role),render:role=>{const title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.cloneRoleActionName",{defaultMessage:`Clone {roleName}`,values:{roleName:role.name}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],_extends({"aria-label":title,"data-test-subj":`clone-role-action-${role.name}`,title:title,color:"primary",iconType:"copy"},Object(public_["reactRouterNavigate"])(this.props.history,getRoleManagementHref("clone",role.name))))}}]}]);roles_grid_page_defineProperty(this,"getVisibleRoles",(roles,filter,includeReservedRoles)=>roles.filter(role=>{const normalized=`${role.name}`.toLowerCase();const normalizedQuery=filter.toLowerCase();return normalized.indexOf(normalizedQuery)!==-1&&(includeReservedRoles||!Object(model["j"])(role))}));roles_grid_page_defineProperty(this,"onIncludeReservedRolesChange",e=>{this.setState({includeReservedRoles:e.target.checked,visibleRoles:this.getVisibleRoles(this.state.roles,this.state.filter,e.target.checked)})});roles_grid_page_defineProperty(this,"getRoleStatusBadges",role=>{const enabled=Object(model["h"])(role);const deprecated=Object(model["g"])(role);const reserved=Object(model["j"])(role);const badges=[];if(!enabled){badges.push(external_kbnSharedDeps_React_default.a.createElement(management_badges["b"],{"data-test-subj":"roleDisabled"}))}if(reserved){badges.push(external_kbnSharedDeps_React_default.a.createElement(management_badges["d"],{"data-test-subj":"roleReserved",tooltipContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.reservedRoleBadgeTooltip",defaultMessage:"Reserved roles are built-in and cannot be edited or removed."})}))}if(deprecated){badges.push(external_kbnSharedDeps_React_default.a.createElement(management_badges["a"],{"data-test-subj":"roleDeprecated",tooltipContent:Object(model["d"])(role)}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},badges.map((badge,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index,grow:false},badge)))});roles_grid_page_defineProperty(this,"handleDelete",()=>{this.setState({selection:[],showDeleteConfirmation:false});this.loadRoles()});roles_grid_page_defineProperty(this,"onCancelDelete",()=>{this.setState({showDeleteConfirmation:false})});this.state={roles:[],visibleRoles:[],selection:[],filter:"",showDeleteConfirmation:false,permissionDenied:false,includeReservedRoles:true}}componentDidMount(){this.loadRoles()}render(){const{permissionDenied:permissionDenied}=this.state;return permissionDenied?external_kbnSharedDeps_React_default.a.createElement(PermissionDenied,null):this.getPageContent()}async loadRoles(){try{const roles=await this.props.rolesAPIClient.getRoles();this.setState({roles:roles,visibleRoles:this.getVisibleRoles(roles,this.state.filter,this.state.includeReservedRoles)})}catch(e){if(external_kbnSharedDeps_Lodash_default.a.get(e,"body.statusCode")===403){this.setState({permissionDenied:true})}else{this.props.notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.security.management.roles.fetchingRolesErrorMessage",{defaultMessage:"Error fetching roles: {message}",values:{message:external_kbnSharedDeps_Lodash_default.a.get(e,"body.message","")}}))}}}renderToolsLeft(){const{selection:selection}=this.state;if(selection.length===0){return}const numSelected=selection.length;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"deleteRoleButton",color:"danger",onClick:()=>this.setState({showDeleteConfirmation:true})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.deleteSelectedRolesButtonLabel",defaultMessage:"Delete {numSelected} role{numSelected, plural, one { } other {s}}",values:{numSelected:numSelected}}))}renderToolsRight(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{"data-test-subj":"showReservedRolesSwitch",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.roles.showReservedRolesLabel",defaultMessage:"Show reserved roles"}),checked:this.state.includeReservedRoles,onChange:this.onIncludeReservedRolesChange})}}},88:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DeprecatedBadge}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DisabledBadge}));__webpack_require__.d(__webpack_exports__,"c",(function(){return EnabledBadge}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ReservedBadge}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(5);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);const OptionalToolTip=props=>{if(props.tooltipContent){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:props.tooltipContent},props.children)}return props.children};const DeprecatedBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.deprecatedBadge",defaultMessage:"Deprecated"})));const DisabledBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"hollow"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.disabledBadge",defaultMessage:"Disabled"})));const EnabledBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"secondary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.enabledBadge",defaultMessage:"Enabled"})));const ReservedBadge=props=>external_kbnSharedDeps_React_default.a.createElement(OptionalToolTip,{tooltipContent:props.tooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{"data-test-subj":props["data-test-subj"],color:"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.security.management.reservedBadge",defaultMessage:"Reserved"})))}}]);