/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["reporting_bundle_jsonpfunction"]=window["reporting_bundle_jsonpfunction"]||[]).push([[1],{38:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"mountManagementSection",(function(){return mountManagementSection}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(37);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(1);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(3);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(4);var external_kbnSharedDeps_Lodash_=__webpack_require__(8);var external_kbnSharedDeps_Moment_=__webpack_require__(23);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var constants=__webpack_require__(2);var poller=__webpack_require__(14);var schema_utils=__webpack_require__(15);var license_check=__webpack_require__(9);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class report_error_button_ReportErrorButtonUi extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);_defineProperty(this,"mounted",void 0);_defineProperty(this,"togglePopover",()=>{this.setState(prevState=>({isPopoverOpen:!prevState.isPopoverOpen}));if(!this.state.error){this.loadError()}});_defineProperty(this,"closePopover",()=>{this.setState({isPopoverOpen:false})});_defineProperty(this,"loadError",async()=>{const{record:record,apiClient:apiClient,intl:intl}=this.props;this.setState({isLoading:true});try{const reportContent=await apiClient.getContent(record.id);if(this.mounted){this.setState({isLoading:false,error:reportContent.content})}}catch(kfetchError){if(this.mounted){this.setState({isLoading:false,calloutTitle:intl.formatMessage({id:"xpack.reporting.errorButton.unableToFetchReportContentTitle",defaultMessage:"Unable to fetch report content"}),error:kfetchError.message})}}});this.state={isLoading:false,isPopoverOpen:false,calloutTitle:props.intl.formatMessage({id:"xpack.reporting.errorButton.unableToGenerateReportTitle",defaultMessage:"Unable to generate report"})}}render(){const{record:record,intl:intl}=this.props;if(record.status!==constants["JOB_STATUSES"].FAILED){return null}const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:this.togglePopover,iconType:"alert",color:"danger","aria-label":intl.formatMessage({id:"xpack.reporting.errorButton.showReportErrorAriaLabel",defaultMessage:"Show report error"})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"popover",button:button,isOpen:this.state.isPopoverOpen,closePopover:this.closePopover,anchorPosition:"downRight"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",title:this.state.calloutTitle},external_kbnSharedDeps_React_default.a.createElement("p",null,this.state.error)))}componentWillUnmount(){this.mounted=false}componentDidMount(){this.mounted=true}}const ReportErrorButton=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(report_error_button_ReportErrorButtonUi);class report_delete_button_ReportDeleteButton extends external_kbnSharedDeps_React_["PureComponent"]{constructor(props){super(props);this.state={showConfirm:false}}hideConfirm(){this.setState({showConfirm:false})}showConfirm(){this.setState({showConfirm:true})}renderConfirm(){const{intl:intl,jobsToDelete:jobsToDelete}=this.props;const title=jobsToDelete.length>1?intl.formatMessage({id:"xpack.reporting.listing.table.deleteNumConfirmTitle",defaultMessage:`Delete {num} reports?`},{num:jobsToDelete.length}):intl.formatMessage({id:"xpack.reporting.listing.table.deleteConfirmTitle",defaultMessage:`Delete the "{name}" report?`},{name:jobsToDelete[0].object_title});const message=intl.formatMessage({id:"xpack.reporting.listing.table.deleteConfirmMessage",defaultMessage:`You can't recover deleted reports.`});const confirmButtonText=intl.formatMessage({id:"xpack.reporting.listing.table.deleteConfirmButton",defaultMessage:`Delete`});const cancelButtonText=intl.formatMessage({id:"xpack.reporting.listing.table.deleteCancelButton",defaultMessage:`Cancel`});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:title,onCancel:()=>this.hideConfirm(),onConfirm:()=>this.props.performDelete(),confirmButtonText:confirmButtonText,cancelButtonText:cancelButtonText,defaultFocusedButton:"confirm",buttonColor:"danger"},message)}render(){const{jobsToDelete:jobsToDelete,intl:intl}=this.props;if(jobsToDelete.length===0)return null;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>this.showConfirm(),iconType:"trash",color:"danger","data-test-subj":"deleteReportButton"},intl.formatMessage({id:"xpack.reporting.listing.table.deleteReportButton",defaultMessage:`Delete ({num})`},{num:jobsToDelete.length})),this.state.showConfirm?this.renderConfirm():null)}}const ReportDownloadButton=props=>{const{record:record,apiClient:apiClient,intl:intl}=props;if(record.status!==constants["JOB_STATUSES"].COMPLETED&&record.status!==constants["JOB_STATUSES"].WARNINGS){return null}const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:()=>apiClient.downloadReport(record.id),iconType:"importAction","aria-label":intl.formatMessage({id:"xpack.reporting.listing.table.downloadReportAriaLabel",defaultMessage:"Download report"})});if(record.csv_contains_formulas){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:intl.formatMessage({id:"xpack.reporting.listing.table.csvContainsFormulas",defaultMessage:"Your CSV contains characters which spreadsheet applications can interpret as formulas."})},button)}if(record.max_size_reached){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:intl.formatMessage({id:"xpack.reporting.listing.table.maxSizeReachedTooltip",defaultMessage:"Max size reached, contains partial data."})},button)}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:intl.formatMessage({id:"xpack.reporting.listing.table.downloadReport",defaultMessage:"Download report"})},button)};function report_info_button_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const NA="n/a";const UNKNOWN="unknown";const getDimensions=info=>{const defaultDimensions={width:null,height:null};const{width:width,height:height}=Object(external_kbnSharedDeps_Lodash_["get"])(info,"payload.layout.dimensions",defaultDimensions);if(width&&height){return`Width: ${width} x Height: ${height}`}return NA};class report_info_button_ReportInfoButton extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);report_info_button_defineProperty(this,"mounted",void 0);report_info_button_defineProperty(this,"loadInfo",async()=>{this.setState({isLoading:true});try{const info=await this.props.apiClient.getInfo(this.props.jobId);if(this.mounted){this.setState({isLoading:false,info:info})}}catch(err){if(this.mounted){this.setState({isLoading:false,calloutTitle:"Unable to fetch report info",info:null,error:err})}}});report_info_button_defineProperty(this,"closeFlyout",()=>{this.setState({isFlyoutVisible:false,info:null})});report_info_button_defineProperty(this,"showFlyout",()=>{this.setState({isFlyoutVisible:true});if(!this.state.info){this.loadInfo()}});this.state={isLoading:false,isFlyoutVisible:false,calloutTitle:"Job Info",info:null,error:null};this.closeFlyout=this.closeFlyout.bind(this);this.showFlyout=this.showFlyout.bind(this)}renderInfo(){const{info:info,error:err}=this.state;if(err){return err.message}if(!info){return null}const jobType=info.jobtype||NA;const attempts=info.attempts?info.attempts.toString():NA;const maxAttempts=info.max_attempts?info.max_attempts.toString():NA;const priority=info.priority?info.priority.toString():NA;const timeout=info.timeout?info.timeout.toString():NA;const warnings=info.output&&info.output.warnings?info.output.warnings.join(","):null;const jobInfoDateTimes=[{title:"Created By",description:info.created_by||NA},{title:"Created At",description:info.created_at||NA},{title:"Started At",description:info.started_at||NA},{title:"Completed At",description:info.completed_at||NA},{title:"Processed By",description:info.kibana_name&&info.kibana_id?`${info.kibana_name} (${info.kibana_id})`:UNKNOWN},{title:"Browser Timezone",description:Object(external_kbnSharedDeps_Lodash_["get"])(info,"payload.browserTimezone")||NA}];const jobInfoPayload=[{title:"Title",description:Object(external_kbnSharedDeps_Lodash_["get"])(info,"payload.title")||NA},{title:"Layout",description:Object(external_kbnSharedDeps_Lodash_["get"])(info,"meta.layout")||NA},{title:"Dimensions",description:getDimensions(info)},{title:"Job Type",description:jobType},{title:"Content Type",description:Object(external_kbnSharedDeps_Lodash_["get"])(info,"output.content_type")||NA},{title:"Size in Bytes",description:Object(external_kbnSharedDeps_Lodash_["get"])(info,"output.size")||NA}];const jobInfoStatus=[{title:"Attempts",description:attempts},{title:"Max Attempts",description:maxAttempts},{title:"Priority",description:priority},{title:"Timeout",description:timeout},{title:"Status",description:info.status||NA},{title:"Browser Type",description:constants["USES_HEADLESS_JOB_TYPES"].includes(jobType)?info.browser_type||UNKNOWN:NA}];if(warnings){jobInfoStatus.push({title:"Errors",description:warnings})}const jobInfoParts={datetimes:jobInfoDateTimes,payload:jobInfoPayload,status:jobInfoStatus};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{listItems:jobInfoParts.datetimes,type:"column",align:"center",compressed:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{listItems:jobInfoParts.payload,type:"column",align:"center",compressed:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{listItems:jobInfoParts.status,type:"column",align:"center",compressed:true}))}componentWillUnmount(){this.mounted=false}componentDidMount(){this.mounted=true}render(){let flyout;if(this.state.isFlyoutVisible){flyout=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{ownFocus:true,onClose:this.closeFlyout,size:"s","aria-labelledby":"flyoutTitle","data-test-subj":"reportInfoFlyout"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"flyoutTitle"},this.state.calloutTitle))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,this.renderInfo()))))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:this.showFlyout,iconType:"iInCircle",color:"primary","data-test-subj":"reportInfoButton","aria-label":"Show report info"}),flyout)}}var statuses;(function(statuses){statuses["configStatus"]="configStatus";statuses["chromeStatus"]="chromeStatus";statuses["screenshotStatus"]="screenshotStatus"})(statuses||(statuses={}));const initialState={[statuses.configStatus]:"incomplete",[statuses.chromeStatus]:"incomplete",[statuses.screenshotStatus]:"incomplete",isFlyoutVisible:false,help:[],logs:"",isBusy:false,success:true};const ReportDiagnostic=({apiClient:apiClient})=>{const[state,setStateBase]=Object(external_kbnSharedDeps_React_["useState"])(initialState);const setState=s=>setStateBase({...state,...s});const{configStatus:configStatus,isBusy:isBusy,screenshotStatus:screenshotStatus,chromeStatus:chromeStatus,isFlyoutVisible:isFlyoutVisible,help:help,logs:logs,success:success}=state;const closeFlyout=()=>setState({...initialState,isFlyoutVisible:false});const showFlyout=()=>setState({isFlyoutVisible:true});const apiWrapper=(apiMethod,statusProp)=>()=>{setState({isBusy:true,[statusProp]:"incomplete"});apiMethod().then(response=>{setState({isBusy:false,help:response.help,logs:response.logs,success:response.success,[statusProp]:response.success?"complete":"danger"})}).catch(error=>{setState({isBusy:false,help:[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.listing.diagnosticApiCallFailure",{defaultMessage:`There was a problem running the diagnostic: {error}`,values:{error:error}})],logs:`${error.message}`,success:false,[statusProp]:"danger"})})};const steps=[{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.listing.diagnosticConfigTitle",{defaultMessage:"Verify Kibana configuration"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticConfigMessage",defaultMessage:"Ensure your Kibana configuration is properly set up for reports."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{disabled:isBusy||configStatus==="complete",isLoading:isBusy&&configStatus==="incomplete",onClick:apiWrapper(apiClient.verifyConfig,statuses.configStatus),iconType:configStatus==="complete"?"check":undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticConfigButton",defaultMessage:"Verify configuration"}))),status:!success&&configStatus!=="complete"?"danger":configStatus}];if(configStatus==="complete"){steps.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.listing.diagnosticBrowserTitle",{defaultMessage:"Check browser"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticBrowserMessage",defaultMessage:"Reporting uses a headless browser to generate PDF and PNGs. Validate that the browser can launch successfully."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{disabled:isBusy||chromeStatus==="complete",onClick:apiWrapper(apiClient.verifyBrowser,statuses.chromeStatus),isLoading:isBusy&&chromeStatus==="incomplete",iconType:chromeStatus==="complete"?"check":undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticBrowserButton",defaultMessage:"Check browser"}))),status:!success&&chromeStatus!=="complete"?"danger":chromeStatus})}if(chromeStatus==="complete"){steps.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.listing.diagnosticScreenshotTitle",{defaultMessage:"Check screen capture"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticScreenshotMessage",defaultMessage:"Ensure that the headless browser can capture a screenshot of a page."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{disabled:isBusy||screenshotStatus==="complete",onClick:apiWrapper(apiClient.verifyScreenCapture,statuses.screenshotStatus),isLoading:isBusy&&screenshotStatus==="incomplete",iconType:screenshotStatus==="complete"?"check":undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticScreenshotButton",defaultMessage:"Capture screenshot"}))),status:!success&&screenshotStatus!=="complete"?"danger":screenshotStatus})}if(screenshotStatus==="complete"){steps.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.listing.diagnosticSuccessTitle",{defaultMessage:"All set!"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticSuccessMessage",defaultMessage:"Everything looks good for reporting to function."})),status:!success?"danger":screenshotStatus})}if(!success){steps.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.listing.diagnosticFailureTitle",{defaultMessage:"Something isn't working properly."}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,help.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,help.join("\n")))):null,logs.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticFailureDescription",defaultMessage:"Here are some details about the issue:"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],null,logs)):null),status:"danger"})}let flyout;if(isFlyoutVisible){flyout=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:closeFlyout,"aria-labelledby":"reportingHelperTitle",size:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticTitle",defaultMessage:"Reporting Diagnostics"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticDescription",defaultMessage:"Run diagnostics to automatically troubleshoot common reporting problems."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSteps"],{steps:steps})))}return external_kbnSharedDeps_React_default.a.createElement("div",null,flyout,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",flush:"left",onClick:showFlyout},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.diagnosticButton",defaultMessage:"Run reporting diagnostics"})))};function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function report_listing_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const jobStatusLabelsMap=new Map([[constants["JOB_STATUSES"].PENDING,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.jobStatuses.pendingText",{defaultMessage:"Pending"})],[constants["JOB_STATUSES"].PROCESSING,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.jobStatuses.processingText",{defaultMessage:"Processing"})],[constants["JOB_STATUSES"].COMPLETED,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.jobStatuses.completedText",{defaultMessage:"Completed"})],[constants["JOB_STATUSES"].WARNINGS,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.jobStatuses.warningText",{defaultMessage:"Completed with warnings"})],[constants["JOB_STATUSES"].FAILED,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.jobStatuses.failedText",{defaultMessage:"Failed"})],[constants["JOB_STATUSES"].CANCELLED,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.reporting.jobStatuses.cancelledText",{defaultMessage:"Cancelled"})]]);class report_listing_ReportListingUi extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);report_listing_defineProperty(this,"isInitialJobsFetch",void 0);report_listing_defineProperty(this,"licenseSubscription",void 0);report_listing_defineProperty(this,"mounted",void 0);report_listing_defineProperty(this,"poller",void 0);report_listing_defineProperty(this,"licenseHandler",license=>{const{enableLinks:enableLinks,showLinks:showLinks,message:badLicenseMessage}=Object(license_check["a"])(license.check("reporting","basic"));this.setState({enableLinks:enableLinks,showLinks:showLinks,badLicenseMessage:badLicenseMessage})});report_listing_defineProperty(this,"onSelectionChange",jobs=>{this.setState(current=>({...current,selectedJobs:jobs}))});report_listing_defineProperty(this,"removeRecord",record=>{const{jobs:jobs}=this.state;const filtered=jobs.filter(j=>j.id!==record.id);this.setState(current=>({...current,jobs:filtered}))});report_listing_defineProperty(this,"renderDeleteButton",()=>{const{selectedJobs:selectedJobs}=this.state;if(selectedJobs.length===0)return undefined;const performDelete=async()=>{for(const record of selectedJobs){try{await this.props.apiClient.deleteReport(record.id);this.removeRecord(record);this.props.toasts.addSuccess(this.props.intl.formatMessage({id:"xpack.reporting.listing.table.deleteConfim",defaultMessage:`The {reportTitle} report was deleted`},{reportTitle:record.object_title}))}catch(error){this.props.toasts.addDanger(this.props.intl.formatMessage({id:"xpack.reporting.listing.table.deleteFailedErrorMessage",defaultMessage:`The report was not deleted: {error}`},{error:error}));throw error}}this.setState(()=>({page:0}),this.fetchJobs)};return external_kbnSharedDeps_React_default.a.createElement(report_delete_button_ReportDeleteButton,_extends({jobsToDelete:selectedJobs,performDelete:performDelete},this.props))});report_listing_defineProperty(this,"onTableChange",({page:page})=>{const{index:pageIndex}=page;this.setState(()=>({page:pageIndex}),this.fetchJobs)});report_listing_defineProperty(this,"fetchJobs",async()=>{if(this.isInitialJobsFetch){this.setState(()=>({isLoading:true}))}let jobs;let total;try{jobs=await this.props.apiClient.list(this.state.page);total=await this.props.apiClient.total();this.isInitialJobsFetch=false}catch(fetchError){if(!this.licenseAllowsToShowThisPage()){this.props.toasts.addDanger(this.state.badLicenseMessage);this.props.redirect("management");return}if(fetchError.message==="Failed to fetch"){this.props.toasts.addDanger(fetchError.message||this.props.intl.formatMessage({id:"xpack.reporting.listing.table.requestFailedErrorMessage",defaultMessage:"Request failed"}))}if(this.mounted){this.setState(()=>({isLoading:false,jobs:[],total:0}))}return}if(this.mounted){this.setState(()=>({isLoading:false,total:total,jobs:jobs.map(job=>{const{_source:source}=job;return{id:job._id,type:source.jobtype,object_type:source.payload.objectType,object_title:source.payload.title,created_by:source.created_by,created_at:source.created_at,started_at:source.started_at,completed_at:source.completed_at,status:source.status,statusLabel:jobStatusLabelsMap.get(source.status)||source.status,max_size_reached:source.output?source.output.max_size_reached:false,attempts:source.attempts,max_attempts:source.max_attempts,csv_contains_formulas:Object(external_kbnSharedDeps_Lodash_["get"])(source,"output.csv_contains_formulas"),warnings:source.output?source.output.warnings:undefined}})}))}});report_listing_defineProperty(this,"licenseAllowsToShowThisPage",()=>this.state.showLinks&&this.state.enableLinks);this.state={page:0,total:0,jobs:[],selectedJobs:[],isLoading:false,showLinks:false,enableLinks:false,badLicenseMessage:""};this.isInitialJobsFetch=true}render(){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{horizontalPosition:"center",className:"euiPageBody--restrictWidth-default"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.reportstitle",defaultMessage:"Reports"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.reports.subtitle",defaultMessage:"Get reports generated in Kibana applications."}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),this.renderTable()),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",direction:"rowReverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ReportDiagnostic,{apiClient:this.props.apiClient}))))}componentWillUnmount(){this.mounted=false;this.poller.stop();if(this.licenseSubscription){this.licenseSubscription.unsubscribe()}}componentDidMount(){this.mounted=true;const{pollConfig:pollConfig,license$:license$}=this.props;const pollFrequencyInMillis=Object(schema_utils["a"])(pollConfig.jobsRefresh.interval);this.poller=new poller["a"]({functionToPoll:()=>this.fetchJobs(),pollFrequencyInMillis:pollFrequencyInMillis,trailing:false,continuePollingOnError:true,pollFrequencyErrorMultiplier:pollConfig.jobsRefresh.intervalErrorMultiplier});this.poller.start();this.licenseSubscription=license$.subscribe(this.licenseHandler)}formatDate(timestamp){try{return external_kbnSharedDeps_Moment_default()(timestamp).format("YYYY-MM-DD @ hh:mm A")}catch(error){return timestamp}}renderTable(){const{intl:intl}=this.props;const tableColumns=[{field:"object_title",name:intl.formatMessage({id:"xpack.reporting.listing.tableColumns.reportTitle",defaultMessage:"Report"}),render:(objectTitle,record)=>external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement("div",null,objectTitle),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},record.object_type)))},{field:"created_at",name:intl.formatMessage({id:"xpack.reporting.listing.tableColumns.createdAtTitle",defaultMessage:"Created at"}),render:(createdAt,record)=>{if(record.created_by){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement("div",null,this.formatDate(createdAt)),external_kbnSharedDeps_React_default.a.createElement("span",null,record.created_by))}return this.formatDate(createdAt)}},{field:"status",name:intl.formatMessage({id:"xpack.reporting.listing.tableColumns.statusTitle",defaultMessage:"Status"}),render:(status,record)=>{if(status==="pending"){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.tableValue.statusDetail.pendingStatusReachedText",defaultMessage:"Pending - waiting for job to be processed"}))}let maxSizeReached;if(record.max_size_reached){maxSizeReached=external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.tableValue.statusDetail.maxSizeReachedText",defaultMessage:" - Max size reached"}))}let warnings;if(record.warnings){warnings=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.tableValue.statusDetail.warningsText",defaultMessage:"Errors occurred: see job info for details."})))}let statusTimestamp;if(status===constants["JOB_STATUSES"].PROCESSING&&record.started_at){statusTimestamp=this.formatDate(record.started_at)}else if(record.completed_at&&[constants["JOB_STATUSES"].COMPLETED,constants["JOB_STATUSES"].FAILED,constants["JOB_STATUSES"].WARNINGS].includes(status)){statusTimestamp=this.formatDate(record.completed_at)}let statusLabel=jobStatusLabelsMap.get(status)||status;if(status===constants["JOB_STATUSES"].PROCESSING){statusLabel=statusLabel+` (attempt ${record.attempts} of ${record.max_attempts})`}if(statusTimestamp){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.reporting.listing.tableValue.statusDetail.statusTimestampText",defaultMessage:"{statusLabel} at {statusTimestamp}",values:{statusLabel:statusLabel,statusTimestamp:external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textNoWrap"},statusTimestamp)}}),maxSizeReached,warnings)}return external_kbnSharedDeps_React_default.a.createElement("div",null,statusLabel,maxSizeReached)}},{name:intl.formatMessage({id:"xpack.reporting.listing.tableColumns.actionsTitle",defaultMessage:"Actions"}),actions:[{render:record=>external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(ReportDownloadButton,_extends({},this.props,{record:record})),external_kbnSharedDeps_React_default.a.createElement(ReportErrorButton,_extends({},this.props,{record:record})),external_kbnSharedDeps_React_default.a.createElement(report_info_button_ReportInfoButton,_extends({},this.props,{jobId:record.id})))}]}];const pagination={pageIndex:this.state.page,pageSize:10,totalItemCount:this.state.total,hidePerPageOptions:true};const selection={itemId:"id",onSelectionChange:this.onSelectionChange};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{itemId:"id",items:this.state.jobs,loading:this.state.isLoading,columns:tableColumns,noItemsMessage:this.state.isLoading?intl.formatMessage({id:"xpack.reporting.listing.table.loadingReportsDescription",defaultMessage:"Loading reports"}):intl.formatMessage({id:"xpack.reporting.listing.table.noCreatedReportsDescription",defaultMessage:"No reports have been created"}),pagination:pagination,selection:selection,isSelectable:true,onChange:this.onTableChange,"data-test-subj":"reportJobListing"}),this.state.selectedJobs.length>0?this.renderDeleteButton():null)}}const ReportListing=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(report_listing_ReportListingUi);async function mountManagementSection(coreSetup,coreStart,license$,pollConfig,apiClient,params){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_["createElement"](ReportListing,{toasts:coreSetup.notifications.toasts,license$:license$,pollConfig:pollConfig,redirect:coreStart.application.navigateToApp,apiClient:apiClient})),params.element);return()=>{Object(external_kbnSharedDeps_ReactDom_["unmountComponentAtNode"])(params.element)}}}}]);