/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(function(modules){function webpackJsonpCallback(data){var chunkIds=data[0];var moreModules=data[1];var moduleId,chunkId,i=0,resolves=[];for(;i<chunkIds.length;i++){chunkId=chunkIds[i];if(Object.prototype.hasOwnProperty.call(installedChunks,chunkId)&&installedChunks[chunkId]){resolves.push(installedChunks[chunkId][0])}installedChunks[chunkId]=0}for(moduleId in moreModules){if(Object.prototype.hasOwnProperty.call(moreModules,moduleId)){modules[moduleId]=moreModules[moduleId]}}if(parentJsonpFunction)parentJsonpFunction(data);while(resolves.length){resolves.shift()()}}var installedModules={};var installedChunks={0:0};function jsonpScriptSrc(chunkId){return __webpack_require__.p+"remoteClusters.chunk."+chunkId+".js"}function __webpack_require__(moduleId){if(installedModules[moduleId]){return installedModules[moduleId].exports}var module=installedModules[moduleId]={i:moduleId,l:false,exports:{}};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.l=true;return module.exports}__webpack_require__.e=function requireEnsure(chunkId){var promises=[];var installedChunkData=installedChunks[chunkId];if(installedChunkData!==0){if(installedChunkData){promises.push(installedChunkData[2])}else{var promise=new Promise((function(resolve,reject){installedChunkData=installedChunks[chunkId]=[resolve,reject]}));promises.push(installedChunkData[2]=promise);var script=document.createElement("script");var onScriptComplete;script.charset="utf-8";script.timeout=120;if(__webpack_require__.nc){script.setAttribute("nonce",__webpack_require__.nc)}script.src=jsonpScriptSrc(chunkId);var error=new Error;onScriptComplete=function(event){script.onerror=script.onload=null;clearTimeout(timeout);var chunk=installedChunks[chunkId];if(chunk!==0){if(chunk){var errorType=event&&(event.type==="load"?"missing":event.type);var realSrc=event&&event.target&&event.target.src;error.message="Loading chunk "+chunkId+" failed.\n("+errorType+": "+realSrc+")";error.name="ChunkLoadError";error.type=errorType;error.request=realSrc;chunk[1](error)}installedChunks[chunkId]=undefined}};var timeout=setTimeout((function(){onScriptComplete({type:"timeout",target:script})}),12e4);script.onerror=script.onload=onScriptComplete;document.head.appendChild(script)}}return Promise.all(promises)};__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.d=function(exports,name,getter){if(!__webpack_require__.o(exports,name)){Object.defineProperty(exports,name,{enumerable:true,get:getter})}};__webpack_require__.r=function(exports){if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})};__webpack_require__.t=function(value,mode){if(mode&1)value=__webpack_require__(value);if(mode&8)return value;if(mode&4&&typeof value==="object"&&value&&value.__esModule)return value;var ns=Object.create(null);__webpack_require__.r(ns);Object.defineProperty(ns,"default",{enumerable:true,value:value});if(mode&2&&typeof value!="string")for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns};__webpack_require__.n=function(module){var getter=module&&module.__esModule?function getDefault(){return module["default"]}:function getModuleExports(){return module};__webpack_require__.d(getter,"a",getter);return getter};__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)};__webpack_require__.p="";__webpack_require__.oe=function(err){console.error(err);throw err};var jsonpArray=window["remoteClusters_bundle_jsonpfunction"]=window["remoteClusters_bundle_jsonpfunction"]||[];var oldJsonpFunction=jsonpArray.push.bind(jsonpArray);jsonpArray.push=webpackJsonpCallback;jsonpArray=jsonpArray.slice();for(var i=0;i<jsonpArray.length;i++)webpackJsonpCallback(jsonpArray[i]);var parentJsonpFunction=oldJsonpFunction;return __webpack_require__(__webpack_require__.s=10)})([function(module,exports){module.exports=__kbnSharedDeps__.KbnI18n},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return PLUGIN}));__webpack_require__.d(__webpack_exports__,"a",(function(){return API_BASE_PATH}));__webpack_require__.d(__webpack_exports__,"d",(function(){return SNIFF_MODE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return PROXY_MODE}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const basicLicense="basic";const PLUGIN={minimumLicenseType:basicLicense,getI18nName:()=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.remoteClusters.appName",{defaultMessage:"Remote Clusters"})};const API_BASE_PATH="/api/remote_clusters";const SNIFF_MODE="sniff";const PROXY_MODE="proxy"},function(module,exports){module.exports=__kbnSharedDeps__.MomentTimezone},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return toasts}));__webpack_require__.d(__webpack_exports__,"a",(function(){return fatalError}));__webpack_require__.d(__webpack_exports__,"b",(function(){return init}));let toasts;let fatalError;function init(_toasts,_fatalError){toasts=_toasts;fatalError=_fatalError}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return METRIC_TYPE}));__webpack_require__.d(__webpack_exports__,"b",(function(){return init}));__webpack_require__.d(__webpack_exports__,"c",(function(){return trackUiMetric}));__webpack_require__.d(__webpack_exports__,"d",(function(){return trackUserRequest}));function wrapArray(subj){return Array.isArray(subj)?subj:[subj]}class UnreachableCaseError extends Error{constructor(val){super(`Unreachable case: ${val}`)}}function createUiCounterMetric({type:type,appName:appName,eventName:eventName,count:count=1}){return{type:type,appName:appName,eventName:eventName,count:count}}function trackUsageAgent(appName){const userAgent=window&&window.navigator&&window.navigator.userAgent||"";return{type:METRIC_TYPE.USER_AGENT,appName:appName,userAgent:userAgent}}var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(2);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);function createApplicationUsageMetric(appId,viewId){return{type:METRIC_TYPE.APPLICATION_USAGE,appId:appId,viewId:viewId,startTime:external_kbnSharedDeps_MomentTimezone_default()(),numberOfClicks:0}}let METRIC_TYPE;(function(METRIC_TYPE){METRIC_TYPE["COUNT"]="count";METRIC_TYPE["LOADED"]="loaded";METRIC_TYPE["CLICK"]="click";METRIC_TYPE["USER_AGENT"]="user_agent";METRIC_TYPE["APPLICATION_USAGE"]="application_usage"})(METRIC_TYPE||(METRIC_TYPE={}));function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class ReportStorageManager{constructor(storageKey,storage){_defineProperty(this,"storageKey",void 0);_defineProperty(this,"storage",void 0);this.storageKey=storageKey;this.storage=storage}get(){if(!this.storage)return;return this.storage.get(this.storageKey)}store(report){if(!this.storage)return;this.storage.set(this.storageKey,report)}}function application_usage_tracker_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class application_usage_tracker_ApplicationUsageTracker{constructor(reporter){application_usage_tracker_defineProperty(this,"trackedApplicationViews",{});application_usage_tracker_defineProperty(this,"reporter",void 0);application_usage_tracker_defineProperty(this,"currentAppId",void 0);application_usage_tracker_defineProperty(this,"currentApplicationKeys",[]);application_usage_tracker_defineProperty(this,"beforeUnloadListener",void 0);application_usage_tracker_defineProperty(this,"onVisiblityChangeListener",void 0);this.reporter=reporter}createKey(appId,viewId){return{appId:appId,viewId:viewId}}static serializeKey({appId:appId,viewId:viewId}){return`${appId}-${viewId}`}trackApplications(appKeys){for(const{appId:appId,viewId:viewId}of appKeys.filter(Boolean)){const serializedKey=application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:appId,viewId:viewId});if(typeof this.trackedApplicationViews[serializedKey]!=="undefined"){continue}const metric=createApplicationUsageMetric(appId,viewId);this.trackedApplicationViews[serializedKey]=metric}}attachListeners(){if(typeof window==="undefined"||typeof document==="undefined"){return}this.beforeUnloadListener=()=>{this.flushTrackedViews()};this.onVisiblityChangeListener=()=>{if(document.visibilityState==="visible"){this.resumeTrackingAll()}else if(document.visibilityState==="hidden"){this.pauseTrackingAll()}};window.addEventListener("beforeunload",this.beforeUnloadListener);document.addEventListener("visibilitychange",this.onVisiblityChangeListener)}detachListeners(){if(typeof window==="undefined"||typeof document==="undefined"){return}if(this.beforeUnloadListener){window.removeEventListener("beforeunload",this.beforeUnloadListener)}if(this.onVisiblityChangeListener){document.removeEventListener("visibilitychange",this.onVisiblityChangeListener)}}sendMetricsToReporter(metrics){metrics.forEach(metric=>{this.reporter.reportApplicationUsage(metric)})}updateViewClickCounter(viewId){if(!this.currentAppId){return}const appKey=application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:this.currentAppId,viewId:viewId});if(this.trackedApplicationViews[appKey]){this.trackedApplicationViews[appKey].numberOfClicks++}}flushTrackedViews(){const appViewMetrics=Object.values(this.trackedApplicationViews);this.sendMetricsToReporter(appViewMetrics);this.trackedApplicationViews={}}start(){this.attachListeners()}stop(){this.flushTrackedViews();this.detachListeners()}setCurrentAppId(appId){this.flushTrackedViews();this.currentAppId=appId}trackApplicationViewUsage(viewId){if(!this.currentAppId){return}const appKey=this.createKey(this.currentAppId,viewId);this.trackApplications([appKey])}pauseTrackingAll(){this.currentApplicationKeys=Object.values(this.trackedApplicationViews).map(({appId:appId,viewId:viewId})=>this.createKey(appId,viewId));this.flushTrackedViews()}resumeTrackingAll(){this.trackApplications(this.currentApplicationKeys);this.currentApplicationKeys=[];this.reporter.sendReports()}flushTrackedView(viewId){if(!this.currentAppId){return}const appKey=this.createKey(this.currentAppId,viewId);const serializedKey=application_usage_tracker_ApplicationUsageTracker.serializeKey(appKey);const appViewMetric=this.trackedApplicationViews[serializedKey];this.sendMetricsToReporter([appViewMetric]);delete this.trackedApplicationViews[serializedKey]}}function report_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const REPORT_VERSION=3;class report_ReportManager{constructor(report){report_defineProperty(this,"report",void 0);this.report=report||report_ReportManager.createReport()}static createReport(){return{reportVersion:REPORT_VERSION}}clearReport(){this.report=report_ReportManager.createReport()}isReportEmpty(){const{uiCounter:uiCounter,userAgent:userAgent,application_usage:appUsage}=this.report;const noUiCounters=!uiCounter||Object.keys(uiCounter).length===0;const noUserAgents=!userAgent||Object.keys(userAgent).length===0;const noAppUsage=!appUsage||Object.keys(appUsage).length===0;return noUiCounters&&noUserAgents&&noAppUsage}incrementTotal(count,currentTotal){const currentTotalNumber=typeof currentTotal==="number"?currentTotal:0;return count+currentTotalNumber}assignReports(newMetrics){wrapArray(newMetrics).forEach(newMetric=>this.assignReport(this.report,newMetric));return{report:this.report}}static createMetricKey(metric){switch(metric.type){case METRIC_TYPE.USER_AGENT:{const{appName:appName,type:type}=metric;return`${appName}-${type}`}case METRIC_TYPE.CLICK:case METRIC_TYPE.LOADED:case METRIC_TYPE.COUNT:{const{appName:appName,eventName:eventName,type:type}=metric;return`${appName}-${type}-${eventName}`}case METRIC_TYPE.APPLICATION_USAGE:{const{appId:appId,viewId:viewId}=metric;return application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:appId,viewId:viewId})}default:throw new UnreachableCaseError(metric)}}assignReport(report,metric){const key=report_ReportManager.createMetricKey(metric);switch(metric.type){case METRIC_TYPE.USER_AGENT:{const{appName:appName,type:type,userAgent:userAgent}=metric;if(userAgent){report.userAgent={[key]:{key:key,appName:appName,type:type,userAgent:metric.userAgent}}}return}case METRIC_TYPE.CLICK:case METRIC_TYPE.LOADED:case METRIC_TYPE.COUNT:{var _report$uiCounter$key;const{appName:appName,type:type,eventName:eventName,count:count}=metric;report.uiCounter=report.uiCounter||{};const currentTotal=(_report$uiCounter$key=report.uiCounter[key])===null||_report$uiCounter$key===void 0?void 0:_report$uiCounter$key.total;report.uiCounter[key]={key:key,appName:appName,eventName:eventName,type:type,total:this.incrementTotal(count,currentTotal)};return}case METRIC_TYPE.APPLICATION_USAGE:{const{numberOfClicks:numberOfClicks,startTime:startTime,appId:appId,viewId:viewId}=metric;const minutesOnScreen=external_kbnSharedDeps_MomentTimezone_default()().diff(startTime,"minutes",true);report.application_usage=report.application_usage||{};const appExistingData=report.application_usage[key]||{minutesOnScreen:0,numberOfClicks:0,appId:appId,viewId:viewId};report.application_usage[key]={...appExistingData,minutesOnScreen:appExistingData.minutesOnScreen+minutesOnScreen,numberOfClicks:appExistingData.numberOfClicks+numberOfClicks};return}default:throw new UnreachableCaseError(metric)}}}report_defineProperty(report_ReportManager,"REPORT_VERSION",REPORT_VERSION);function reporter_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class reporter_Reporter{constructor(config){reporter_defineProperty(this,"checkInterval",void 0);reporter_defineProperty(this,"interval",void 0);reporter_defineProperty(this,"http",void 0);reporter_defineProperty(this,"reportManager",void 0);reporter_defineProperty(this,"storageManager",void 0);reporter_defineProperty(this,"debug",void 0);reporter_defineProperty(this,"retryCount",0);reporter_defineProperty(this,"maxRetries",3);reporter_defineProperty(this,"start",()=>{if(!this.interval){this.interval=setTimeout(()=>{this.interval=undefined;this.sendReports()},this.checkInterval)}});reporter_defineProperty(this,"reportUiCounter",(appName,type,eventNames,count)=>{const metrics=wrapArray(eventNames).map(eventName=>{this.log(`${type} Metric -> (${appName}:${eventName}):`);const report=createUiCounterMetric({type:type,appName:appName,eventName:eventName,count:count});this.log(report);return report});this.saveToReport(metrics)});reporter_defineProperty(this,"reportUserAgent",appName=>{this.log(`Reporting user-agent.`);const report=trackUsageAgent(appName);this.saveToReport([report])});reporter_defineProperty(this,"sendReports",async()=>{if(!this.reportManager.isReportEmpty()){try{await this.http(this.reportManager.report);this.flushReport()}catch(err){this.log(`Error Sending Metrics Report ${err}`);this.retryCount=this.retryCount+1;const versionMismatch=this.reportManager.report.reportVersion!==report_ReportManager.REPORT_VERSION;if(versionMismatch||this.retryCount>this.maxRetries){this.flushReport()}}}this.start()});const{http:http,storage:storage,debug:debug,checkInterval:checkInterval=9e4,storageKey:storageKey="analytics"}=config;this.http=http;this.checkInterval=checkInterval;this.storageManager=new ReportStorageManager(storageKey,storage);const storedReport=this.storageManager.get();this.reportManager=new report_ReportManager(storedReport);this.debug=!!debug}saveToReport(newMetrics){this.reportManager.assignReports(newMetrics);this.storageManager.store(this.reportManager.report)}flushReport(){this.retryCount=0;this.reportManager.clearReport();this.storageManager.store(this.reportManager.report)}log(message){if(this.debug){console.debug(message)}}reportApplicationUsage(appUsageReport){this.log(`Reporting application usage for ${appUsageReport.appId}, ${appUsageReport.viewId}`);this.saveToReport([appUsageReport])}}var constants=__webpack_require__(5);let usageCollection;function init(_usageCollection){usageCollection=_usageCollection}function trackUiMetric(metricType,name){if(!usageCollection){return}const{reportUiCounter:reportUiCounter}=usageCollection;reportUiCounter(constants["b"],metricType,name)}function trackUserRequest(request,eventName){return request.then(response=>{trackUiMetric(METRIC_TYPE.COUNT,eventName);return response})}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return UIM_APP_NAME}));__webpack_require__.d(__webpack_exports__,"a",(function(){return UIM_APP_LOAD}));__webpack_require__.d(__webpack_exports__,"c",(function(){return UIM_CLUSTER_ADD}));__webpack_require__.d(__webpack_exports__,"f",(function(){return UIM_CLUSTER_UPDATE}));__webpack_require__.d(__webpack_exports__,"d",(function(){return UIM_CLUSTER_REMOVE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return UIM_CLUSTER_REMOVE_MANY}));__webpack_require__.d(__webpack_exports__,"g",(function(){return UIM_SHOW_DETAILS_CLICK}));const CRUD_APP_BASE_PATH="/management/data/remote_clusters";const UIM_APP_NAME="remote_clusters";const UIM_APP_LOAD="app_load";const UIM_CLUSTER_ADD="cluster_add";const UIM_CLUSTER_UPDATE="cluster_update";const UIM_CLUSTER_REMOVE="cluster_remove";const UIM_CLUSTER_REMOVE_MANY="cluster_remove_many";const UIM_SHOW_DETAILS_CLICK="show_details_click"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return init}));__webpack_require__.d(__webpack_exports__,"b",(function(){return setBreadcrumbs}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);let _setBreadcrumbs;let _breadcrumbs;function init(setGlobalBreadcrumbs){_setBreadcrumbs=setGlobalBreadcrumbs;_breadcrumbs={home:{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.remoteClusters.listBreadcrumbTitle",{defaultMessage:"Remote Clusters"}),href:`/list`},add:{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.remoteClusters.addBreadcrumbTitle",{defaultMessage:"Add"})},edit:{text:_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.remoteClusters.editBreadcrumbTitle",{defaultMessage:"Edit"})}}}function setBreadcrumbs(type,queryParams){if(!_breadcrumbs[type]){return}if(type==="home"){_setBreadcrumbs([_breadcrumbs.home])}else{const homeBreadcrumb={text:_breadcrumbs.home.text,href:`${_breadcrumbs.home.href}${queryParams}`};_setBreadcrumbs([homeBreadcrumb,_breadcrumbs[type]])}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return skippingDisconnectedClustersUrl}));__webpack_require__.d(__webpack_exports__,"d",(function(){return remoteClustersUrl}));__webpack_require__.d(__webpack_exports__,"f",(function(){return transportPortUrl}));__webpack_require__.d(__webpack_exports__,"b",(function(){return proxyModeUrl}));__webpack_require__.d(__webpack_exports__,"c",(function(){return proxySettingsUrl}));__webpack_require__.d(__webpack_exports__,"a",(function(){return init}));let skippingDisconnectedClustersUrl;let remoteClustersUrl;let transportPortUrl;let proxyModeUrl;let proxySettingsUrl;function init(docLinks){const{DOC_LINK_VERSION:DOC_LINK_VERSION,ELASTIC_WEBSITE_URL:ELASTIC_WEBSITE_URL}=docLinks;const esDocBasePath=`${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/reference/${DOC_LINK_VERSION}`;skippingDisconnectedClustersUrl=`${esDocBasePath}/modules-cross-cluster-search.html#_skipping_disconnected_clusters`;remoteClustersUrl=`${esDocBasePath}/modules-remote-clusters.html`;transportPortUrl=`${esDocBasePath}/modules-transport.html`;proxyModeUrl=`${esDocBasePath}/modules-remote-clusters.html#proxy-mode`;proxySettingsUrl=`${esDocBasePath}/modules-remote-clusters.html#remote-cluster-proxy-settings`}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return init}));__webpack_require__.d(__webpack_exports__,"b",(function(){return redirect}));let navigateToApp;function init(_navigateToApp){navigateToApp=_navigateToApp}function redirect(path){navigateToApp("management",{path:path})}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return init}));__webpack_require__.d(__webpack_exports__,"d",(function(){return sendPost}));__webpack_require__.d(__webpack_exports__,"c",(function(){return sendGet}));__webpack_require__.d(__webpack_exports__,"e",(function(){return sendPut}));__webpack_require__.d(__webpack_exports__,"b",(function(){return sendDelete}));var _common_constants__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);let _httpClient;function init(httpClient){_httpClient=httpClient}function getFullPath(path){if(path){return`${_common_constants__WEBPACK_IMPORTED_MODULE_0__["a"]}/${path}`}return _common_constants__WEBPACK_IMPORTED_MODULE_0__["a"]}function sendPost(path,payload){return _httpClient.post(getFullPath(path),{body:JSON.stringify(payload)})}function sendGet(path,{asSystemRequest:asSystemRequest}={}){return _httpClient.get(getFullPath(path),{asSystemRequest:asSystemRequest})}function sendPut(path,payload){return _httpClient.put(getFullPath(path),{body:JSON.stringify(payload)})}function sendDelete(path){return _httpClient.delete(getFullPath(path))}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_val_loader_dist_cjs_js_key_remoteClusters_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(11);var _node_modules_val_loader_dist_cjs_js_key_remoteClusters_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_val_loader_dist_cjs_js_key_remoteClusters_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__);__kbnBundles__.define("plugin/remoteClusters/public",__webpack_require__,12)},function(module,exports,__webpack_require__){__webpack_require__.p=window.__kbnPublicPath__["remoteClusters"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"RemoteClustersPluginSetup",(function(){return undefined}));__webpack_require__.d(__webpack_exports__,"plugin",(function(){return public_plugin}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var constants=__webpack_require__(1);var breadcrumb=__webpack_require__(6);var documentation=__webpack_require__(7);var services_http=__webpack_require__(9);var ui_metric=__webpack_require__(4);var notification=__webpack_require__(3);var redirect=__webpack_require__(8);class plugin_RemoteClustersUIPlugin{constructor(initializerContext){this.initializerContext=initializerContext}setup({notifications:{toasts:toasts},http:http,getStartServices:getStartServices},{management:management,usageCollection:usageCollection,cloud:cloud}){const{ui:{enabled:isRemoteClustersUiEnabled}}=this.initializerContext.config.get();if(isRemoteClustersUiEnabled){const esSection=management.sections.section.data;esSection.registerApp({id:"remote_clusters",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.remoteClusters.appTitle",{defaultMessage:"Remote Clusters"}),order:7,mount:async({element:element,setBreadcrumbs:setBreadcrumbs,history:history})=>{const[core]=await getStartServices();const{chrome:{docTitle:docTitle},i18n:{Context:i18nContext},docLinks:docLinks,fatalErrors:fatalErrors}=core;docTitle.change(constants["b"].getI18nName());Object(breadcrumb["a"])(setBreadcrumbs);Object(documentation["a"])(docLinks);Object(ui_metric["b"])(usageCollection);Object(notification["b"])(toasts,fatalErrors);Object(services_http["a"])(http);const isCloudEnabled=Boolean(cloud===null||cloud===void 0?void 0:cloud.isCloudEnabled);const{renderApp:renderApp}=await __webpack_require__.e(1).then(__webpack_require__.bind(null,72));const unmountAppCallback=await renderApp(element,i18nContext,{isCloudEnabled:isCloudEnabled},history);return()=>{docTitle.reset();unmountAppCallback()}}})}return{isUiEnabled:isRemoteClustersUiEnabled}}start({application:application}){const{ui:{enabled:isRemoteClustersUiEnabled}}=this.initializerContext.config.get();if(isRemoteClustersUiEnabled){Object(redirect["a"])(application.navigateToApp)}}stop(){}}const public_plugin=initializerContext=>new plugin_RemoteClustersUIPlugin(initializerContext)},function(module,exports){module.exports=__kbnSharedDeps__.React},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18nReact},function(module,exports){module.exports=__kbnSharedDeps__.ElasticEui},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/kibanaReact/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/esUiShared/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,exports){module.exports=__kbnSharedDeps__.ReactDom},function(module,exports){module.exports=__kbnSharedDeps__.ReactRouterDom},function(module,exports){module.exports=__kbnSharedDeps__.Lodash}]);