/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["painlessLab_bundle_jsonpfunction"]=window["painlessLab_bundle_jsonpfunction"]||[]).push([[1],{25:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(22);var public_=__webpack_require__(20);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);const defaultLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.contextDefaultLabel",{defaultMessage:"Basic"});const filterLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.contextFilterLabel",{defaultMessage:"Filter"});const scoreLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.contextScoreLabel",{defaultMessage:"Score"});const painlessContextOptions=[{value:"painless_test",inputDisplay:defaultLabel,"data-test-subj":"basicButtonDropdown",dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,defaultLabel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",{className:"euiTextColor--subdued"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.context.defaultLabel",{defaultMessage:"The script result will be converted to a string"}))))},{value:"filter",inputDisplay:filterLabel,"data-test-subj":"filterButtonDropdown",dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,filterLabel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",{className:"euiTextColor--subdued"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.context.filterLabel",{defaultMessage:"Use the context of a filter's script query"}))))},{value:"score",inputDisplay:scoreLabel,"data-test-subj":"scoreButtonDropdown",dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,scoreLabel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",{className:"euiTextColor--subdued"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.context.scoreLabel",{defaultMessage:"Use the context of a script_score function in function_score query"}))))}];const exampleScript=`boolean isInCircle(def posX, def posY, def circleX, def circleY, def radius) {\n  double distanceFromCircleCenter = Math.sqrt(Math.pow(circleX - posX, 2) + Math.pow(circleY - posY, 2));\n  return distanceFromCircleCenter <= radius;\n}\n\nboolean isOnCircle(def posX, def posY, def circleX, def circleY, def radius, def thickness, def squashY) {\n  double distanceFromCircleCenter = Math.sqrt(Math.pow(circleX - posX, 2) + Math.pow((circleY - posY) / squashY, 2));\n  return (\n    distanceFromCircleCenter >= radius - thickness\n    && distanceFromCircleCenter <= radius + thickness\n  );\n}\n\ndef result = '';\nint charCount = 0;\n\n// Canvas dimensions\nint width = 31;\nint height = 31;\ndouble halfWidth = Math.floor(width * 0.5);\ndouble halfHeight = Math.floor(height * 0.5);\n\n// Style constants\ndouble strokeWidth = 0.6;\n\n// Smiley face configuration\nint headSize = 13;\ndouble headSquashY = 0.78;\nint eyePositionX = 10;\nint eyePositionY = 12;\nint eyeSize = 1;\nint mouthSize = 15;\nint mouthPositionX = width / 2;\nint mouthPositionY = 5;\nint mouthOffsetY = 11;\n\nfor (int y = 0; y < height; y++) {\n  for (int x = 0; x < width; x++) {\n    boolean isHead = isOnCircle(x, y, halfWidth, halfHeight, headSize, strokeWidth, headSquashY);\n    boolean isLeftEye = isInCircle(x, y, eyePositionX, eyePositionY, eyeSize);\n    boolean isRightEye = isInCircle(x, y, width - eyePositionX - 1, eyePositionY, eyeSize);\n    boolean isMouth = isOnCircle(x, y, mouthPositionX, mouthPositionY, mouthSize, strokeWidth, 1) && y > mouthPositionY + mouthOffsetY;\n\n    if (isLeftEye || isRightEye || isMouth || isHead) {\n      result += "*";\n    } else {\n      result += ".";\n    }\n\n    result += " ";\n\n    // Make sure the smiley face doesn't deform as the container changes width.\n    charCount++;\n    if (charCount % width === 0) {\n      result += "\\\\n";\n    }\n  }\n}\n\nreturn result;`;const initialPayload={context:painlessContextOptions[0].value,code:exampleScript,parameters:`{\n  "string_parameter": "string value",\n  "number_parameter": 1.5,\n  "boolean_parameter": true\n}`,index:"my-index",document:`{\n  "my_field": "field_value"\n}`,query:""};const AppContext=Object(external_kbnSharedDeps_React_["createContext"])(undefined);const validatePayload=payload=>{const{index:index}=payload;const indexExists=Boolean(index||index.trim());return{isValid:indexExists,fields:{index:indexExists}}};const AppContextProvider=({children:children,value:{http:http,links:links,chrome:chrome}})=>{const PAINLESS_LAB_KEY="painlessLabState";const[store,setStore]=Object(external_kbnSharedDeps_React_["useState"])(()=>{const defaultPayload={...initialPayload,...JSON.parse(localStorage.getItem(PAINLESS_LAB_KEY)||"{}")};return{payload:defaultPayload,validation:validatePayload(defaultPayload)}});const updatePayload=changes=>{const nextPayload={...store.payload,...changes};localStorage.setItem(PAINLESS_LAB_KEY,JSON.stringify(nextPayload));setStore({payload:nextPayload,validation:validatePayload(nextPayload)})};return external_kbnSharedDeps_React_default.a.createElement(AppContext.Provider,{value:{updatePayload:updatePayload,store:store,services:{http:http,chrome:chrome},links:links}},children)};const useAppContext=()=>{const ctx=Object(external_kbnSharedDeps_React_["useContext"])(AppContext);if(!ctx){throw new Error("AppContext can only be used inside of AppContextProvider!")}return ctx};let PayloadFormat;(function(PayloadFormat){PayloadFormat["UGLY"]="ugly";PayloadFormat["PRETTY"]="pretty"})(PayloadFormat||(PayloadFormat={}));function prettifyPayload(payload="",indentationLevel=0){const indentation=new Array(indentationLevel+1).join(" ");return payload.replace(/\n/g,`\n${indentation}`)}function formatRequestPayload({code:code,context:context,parameters:parameters,index:index,document:document,query:query},format=PayloadFormat.UGLY){const isAdvancedContext=context==="filter"||context==="score";let formattedCode;let formattedParameters;let formattedContext;let formattedIndex;let formattedDocument;let formattedQuery;if(format===PayloadFormat.UGLY){formattedCode=JSON.stringify(code);formattedParameters=parameters;formattedContext=context;formattedIndex=index;formattedDocument=document;formattedQuery=query}else{formattedCode=`"""${prettifyPayload(code,4)}"""`;formattedParameters=prettifyPayload(parameters,4);formattedContext=prettifyPayload(context,6);formattedIndex=prettifyPayload(index);formattedDocument=prettifyPayload(document,4);formattedQuery=prettifyPayload(query,4)}const requestPayload=`{\n  "script": {\n    "source": ${formattedCode}${parameters?`,\n    "params": ${formattedParameters}`:``}\n  }${isAdvancedContext?`,\n  "context": "${formattedContext}",\n  "context_setup": {\n    "index": "${formattedIndex}",\n    "document": ${formattedDocument}${query&&context==="score"?`,\n    "query": ${formattedQuery}`:""}\n  }`:``}\n}`;return requestPayload}function formatJson(json){try{return JSON.stringify(json,null,2)}catch(e){return`Invalid JSON ${String(json)}`}}function formatResponse(response){if(!response){return""}if(typeof response.result==="string"){return response.result.replace(/\\n/g,"\n")}else if(response.error){return formatExecutionError(response.error)}return formatJson(response)}function formatExecutionError(executionErrorOrError){if(executionErrorOrError instanceof Error){return executionErrorOrError.message}if(executionErrorOrError.script_stack&&executionErrorOrError.caused_by&&executionErrorOrError.position){return`Unhandled Exception ${executionErrorOrError.caused_by.type}\n\n${executionErrorOrError.caused_by.reason}\n\nStack:\n${formatJson(executionErrorOrError.script_stack)}\n`}return formatJson(executionErrorOrError)}var external_kbnSharedDeps_Lodash_=__webpack_require__(23);var constants=__webpack_require__(5);const DEBOUNCE_MS=800;const useSubmitCode=http=>{const currentRequestIdRef=Object(external_kbnSharedDeps_React_["useRef"])(0);const[response,setResponse]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[inProgress,setInProgress]=Object(external_kbnSharedDeps_React_["useState"])(false);const submit=Object(external_kbnSharedDeps_React_["useCallback"])(Object(external_kbnSharedDeps_Lodash_["debounce"])(async config=>{setInProgress(true);const requestId=++currentRequestIdRef.current;try{const result=await http.post(`${constants["a"]}/execute`,{body:JSON.stringify(formatRequestPayload(config,PayloadFormat.UGLY))});if(currentRequestIdRef.current===requestId){setResponse(result);setInProgress(false)}}catch(error){if(currentRequestIdRef.current===requestId){setResponse({error:error});setInProgress(false)}}},DEBOUNCE_MS,{trailing:true}),[http]);return{response:response,inProgress:inProgress,submit:submit}};function OutputTab({response:response}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"json",paddingSize:"s",isCopyable:true},formatResponse(response)))}var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(21);const ParametersTab=()=>{const{store:{payload:payload},updatePayload:updatePayload,links:links}=useAppContext();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.parametersFieldTooltipText",{defaultMessage:'These variables are assigned to the "params" object in your script'})},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.painlessLab.parametersFieldLabel",defaultMessage:"Parameters (JSON)"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),fullWidth:true,labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:links.modulesScriptingPreferParams,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.parametersFieldDocLinkText",{defaultMessage:"Parameters docs"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"s"},external_kbnSharedDeps_React_default.a.createElement(public_["CodeEditor"],{languageId:"json",height:600,value:payload.parameters,onChange:nextParams=>updatePayload({parameters:nextParams}),options:{fontSize:12,minimap:{enabled:false},scrollBeyondLastLine:false,wordWrap:"on",wrappingIndent:"indent",automaticLayout:true},editorDidMount:editor=>{const model=editor.getModel();if(model){model.updateOptions({tabSize:2})}}}))))};const ContextTab=()=>{const{store:{payload:payload,validation:validation},updatePayload:updatePayload,links:links}=useAppContext();const{context:context,document:document,index:index,query:query}=payload;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.contextFieldTooltipText",{defaultMessage:"Different contexts provide different functions on the ctx object"})},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.painlessLab.contextFieldLabel",defaultMessage:"Execution context"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:links.painlessExecuteAPIContexts,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.contextFieldDocLinkText",{defaultMessage:"Context docs"}))),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperSelect"],{options:painlessContextOptions,valueOfSelected:context,onChange:nextContext=>updatePayload({context:nextContext}),itemLayoutAlign:"top",hasDividers:true,fullWidth:true})),["filter","score"].indexOf(context)!==-1&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.indexFieldTooltipText",{defaultMessage:`Index mappings must be compatible with the sample document's fields`})},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.painlessLab.indexFieldLabel",defaultMessage:"Index name"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),fullWidth:true,isInvalid:!validation.fields.index,error:validation.fields.index?[]:[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.indexFieldMissingErrorMessage",{defaultMessage:"Enter an index name"})]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,value:index||"",onChange:e=>{const nextIndex=e.target.value;updatePayload({index:nextIndex})},isInvalid:!validation.fields.index})),"score".indexOf(context)!==-1&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.queryFieldTooltipText",{defaultMessage:"Use query to specify that that _score will be used to calculate score."})},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.painlessLab.queryFieldLabel",defaultMessage:"Query"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:links.esQueryDSL,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.queryFieldDocLinkText",{defaultMessage:"Query DSL docs"}))),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"s"},external_kbnSharedDeps_React_default.a.createElement(public_["CodeEditor"],{languageId:"json",height:150,value:query,onChange:nextQuery=>updatePayload({query:nextQuery}),options:{fontSize:12,minimap:{enabled:false},scrollBeyondLastLine:false,wordWrap:"on",wrappingIndent:"indent",automaticLayout:true}}))),["filter","score"].indexOf(context)!==-1&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.documentFieldTooltipText",{defaultMessage:"Your script can access this document's fields"})},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.painlessLab.documentFieldLabel",defaultMessage:"Sample document (JSON)"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"s"},external_kbnSharedDeps_React_default.a.createElement(public_["CodeEditor"],{languageId:"json",height:400,value:document,onChange:nextDocument=>updatePayload({document:nextDocument}),options:{fontSize:12,minimap:{enabled:false},scrollBeyondLastLine:false,wordWrap:"on",wrappingIndent:"indent",automaticLayout:true}}))))};const OutputPane=({isLoading:isLoading,response:response})=>{const outputTabLabel=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}):response&&response.error?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"alert",color:"danger"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"check",color:"secondary"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.outputTabLabel",{defaultMessage:"Output"})));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{className:"painlessLabRightPane"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabbedContent"],{className:"painlessLabRightPane__tabs","data-test-subj":"painlessTabs",size:"s",tabs:[{id:"output",name:outputTabLabel,content:external_kbnSharedDeps_React_default.a.createElement(OutputTab,{response:response})},{id:"parameters",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.parametersTabLabel",{defaultMessage:"Parameters"}),content:external_kbnSharedDeps_React_default.a.createElement(ParametersTab,null)},{id:"context",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.contextTabLabel",{defaultMessage:"Context"}),content:external_kbnSharedDeps_React_default.a.createElement(ContextTab,null)}]}))};function MainControls({toggleRequestFlyout:toggleRequestFlyout,isRequestFlyoutOpen:isRequestFlyoutOpen,reset:reset,links:links}){const[isHelpOpen,setIsHelpOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const items=[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:"walkthrough",icon:"popout",href:links.painlessWalkthrough,target:"_blank",onClick:()=>setIsHelpOpen(false)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.walkthroughButtonLabel",{defaultMessage:"Walkthrough"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:"api",icon:"popout",href:links.painlessAPIReference,target:"_blank",onClick:()=>setIsHelpOpen(false)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.apiReferenceButtonLabel",{defaultMessage:"API reference"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:"languageSpec",icon:"popout",href:links.painlessLangSpec,target:"_blank",onClick:()=>setIsHelpOpen(false)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.languageSpecButtonLabel",{defaultMessage:"Language spec"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:"reset",icon:"bolt",onClick:()=>{reset();setIsHelpOpen(false)}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.resetButtonLabel",{defaultMessage:"Reset script"}))];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBottomBar"],{paddingSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",justifyContent:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"painlessLabHelpContextMenu",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",iconType:"help",iconSide:"left",color:"ghost",onClick:()=>setIsHelpOpen(!isHelpOpen)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.helpButtonLabel",{defaultMessage:"Help"})),isOpen:isHelpOpen,closePopover:()=>setIsHelpOpen(false),panelPaddingSize:"none",anchorPosition:"upLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:items}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",color:"ghost",onClick:toggleRequestFlyout,"data-test-subj":"btnViewRequest"},isRequestFlyoutOpen?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.hideRequestButtonLabel",{defaultMessage:"Hide API request"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.showRequestButtonLabel",{defaultMessage:"Show API request"})))))}var external_kbnSharedDeps_KbnMonaco_=__webpack_require__(24);function Editor({code:code,onChange:onChange,context:context}){const suggestionProvider=external_kbnSharedDeps_KbnMonaco_["PainlessLang"].getSuggestionProvider(context);return external_kbnSharedDeps_React_default.a.createElement(public_["CodeEditor"],{languageId:external_kbnSharedDeps_KbnMonaco_["PainlessLang"].ID,width:"99%",height:"100%",value:code,onChange:onChange,suggestionProvider:suggestionProvider,options:{fontSize:12,minimap:{enabled:false},scrollBeyondLastLine:false,wordWrap:"on",wrappingIndent:"indent",automaticLayout:true,suggest:{snippetsPreventQuickSuggestions:false}}})}const RequestFlyout=({onClose:onClose,requestBody:requestBody,response:response,links:links})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,maxWidth:640},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.flyoutTitle",{defaultMessage:"API request"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"s",flush:"right",href:links.painlessExecuteAPI,target:"_blank",iconType:"help"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.flyoutDocLink",{defaultMessage:"API documentation"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabbedContent"],{size:"s",tabs:[{id:"request",name:"Request",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"json",paddingSize:"s",isCopyable:true},"POST _scripts/painless/_execute\n",requestBody)},{id:"response",name:"Response",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"json",paddingSize:"s",isCopyable:true},response)}]}),external_kbnSharedDeps_React_default.a.createElement("div",{className:"painlessLabBottomBarPlaceholder"})));const Main=()=>{const{store:{payload:payload,validation:validation},updatePayload:updatePayload,services:{http:http},links:links}=useAppContext();const[isRequestFlyoutOpen,setRequestFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const{inProgress:inProgress,response:response,submit:submit}=useSubmitCode(http);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(validation.isValid){submit(payload)}},[payload,submit,validation.isValid]);const toggleRequestFlyout=()=>{setRequestFlyoutOpen(!isRequestFlyoutOpen)};return external_kbnSharedDeps_React_default.a.createElement("div",{className:"painlessLabMainContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{className:"painlessLabPanelsContainer",responsive:false,gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{className:"painlessLabLeftPane"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{className:"euiScreenReaderOnly"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.painlessLab.title",{defaultMessage:"Painless Lab"}))),external_kbnSharedDeps_React_default.a.createElement(Editor,{context:payload.context,code:payload.code,onChange:nextCode=>updatePayload({code:nextCode})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(OutputPane,{isLoading:inProgress,response:response}))),external_kbnSharedDeps_React_default.a.createElement(MainControls,{links:links,isLoading:inProgress,toggleRequestFlyout:toggleRequestFlyout,isRequestFlyoutOpen:isRequestFlyoutOpen,reset:()=>updatePayload({code:exampleScript})}),isRequestFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(RequestFlyout,{links:links,onClose:()=>setRequestFlyoutOpen(false),requestBody:formatRequestPayload(payload,PayloadFormat.PRETTY),response:response?formatJson(response.result||response.error):""}))};function renderApp(element,{http:http,I18nContext:I18nContext,uiSettings:uiSettings,links:links,chrome:chrome}){if(!element){return()=>undefined}const{Provider:KibanaReactContextProvider}=Object(public_["createKibanaReactContext"])({uiSettings:uiSettings});Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(I18nContext,null,external_kbnSharedDeps_React_default.a.createElement(KibanaReactContextProvider,null,external_kbnSharedDeps_React_default.a.createElement(AppContextProvider,{value:{http:http,links:links,chrome:chrome}},external_kbnSharedDeps_React_default.a.createElement(Main,null)))),element);return()=>Object(external_kbnSharedDeps_ReactDom_["unmountComponentAtNode"])(element)}}}]);