/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["observability_bundle_jsonpfunction"]=window["observability_bundle_jsonpfunction"]||[]).push([[2],{31:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"default",(function(){return CoreVitals}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(1);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);const NO_DATA=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.noData",{defaultMessage:"No data is available."});const LCP_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.lcp",{defaultMessage:"Largest contentful paint"});const FID_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.fip",{defaultMessage:"First input delay"});const CLS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.cls",{defaultMessage:"Cumulative layout shift"});const CV_POOR_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.poor",{defaultMessage:"a poor"});const CV_GOOD_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.good",{defaultMessage:"a good"});const CV_AVERAGE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.average",{defaultMessage:"an average"});const LEGEND_POOR_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.legends.poor",{defaultMessage:"Poor"});const LEGEND_GOOD_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.legends.good",{defaultMessage:"Good"});const LEGEND_NEEDS_IMPROVEMENT_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.legends.needsImprovement",{defaultMessage:"Needs improvement"});const MORE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.more",{defaultMessage:"more"});const LESS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.less",{defaultMessage:"less"});const IS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.is",{defaultMessage:"is"});const TAKES_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.takes",{defaultMessage:"takes"});const LCP_HELP_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.lcp.help",{defaultMessage:"Largest contentful paint measures loading performance. To provide a good user experience, LCP should occur within 2.5 seconds of when the page first starts loading."});const FID_HELP_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.fid.help",{defaultMessage:"First input delay measures interactivity. To provide a good user experience, pages should have a FID of less than 100 milliseconds."});const CLS_HELP_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.cls.help",{defaultMessage:"Cumulative Layout Shift (CLS): measures visual stability. To provide a good user experience, pages should maintain a CLS of less than 0.1."});var external_kbnSharedDeps_StyledComponents_=__webpack_require__(4);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(29);var external_kbnSharedDeps_Theme_euiLightVars_=__webpack_require__(34);var external_kbnSharedDeps_Theme_euiLightVars_default=__webpack_require__.n(external_kbnSharedDeps_Theme_euiLightVars_);var external_kbnSharedDeps_Theme_euiDarkVars_=__webpack_require__(35);var external_kbnSharedDeps_Theme_euiDarkVars_default=__webpack_require__.n(external_kbnSharedDeps_Theme_euiDarkVars_);var public_=__webpack_require__(9);const PaletteLegend=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiHealth"]).withConfig({displayName:"PaletteLegend",componentId:"r7v41l-0"})(["&:hover{cursor:pointer;text-decoration:underline;}"]);const StyledSpan=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"StyledSpan",componentId:"r7v41l-1"})(["&:hover{background-color:",";}"],props=>props.darkMode?external_kbnSharedDeps_Theme_euiDarkVars_default.a.euiColorLightestShade:external_kbnSharedDeps_Theme_euiLightVars_default.a.euiColorLightestShade);function PaletteLegends({ranks:ranks,title:title,onItemHover:onItemHover,thresholds:thresholds,isCls:isCls}){const[darkMode]=Object(public_["useUiSetting$"])("theme:darkMode");const palette=Object(external_kbnSharedDeps_ElasticEui_["euiPaletteForStatus"])(3);const labels=[LEGEND_GOOD_LABEL,LEGEND_NEEDS_IMPROVEMENT_LABEL,LEGEND_POOR_LABEL];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"s"},palette.map((color,ind)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:ind,grow:false,onMouseEnter:()=>{onItemHover(ind)},onMouseLeave:()=>{onItemHover(null)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:getCoreVitalTooltipMessage(thresholds,ind,title,ranks[ind],isCls),position:"bottom"},external_kbnSharedDeps_React_default.a.createElement(StyledSpan,{darkMode:darkMode},external_kbnSharedDeps_React_default.a.createElement(PaletteLegend,{color:color},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.observability.ux.coreVitals.paletteLegend.rankPercentage",defaultMessage:"{labelsInd} ({ranksInd}%)",values:{labelsInd:labels[ind],ranksInd:ranks===null||ranks===void 0?void 0:ranks[ind]}}))))))))}const ColoredSpan=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"ColoredSpan",componentId:"tpi8wf-0"})(["height:16px;width:100%;cursor:pointer;"]);const getSpanStyle=(position,inFocus,hexCode,percentage)=>{let first=position===0||percentage===100;let last=position===2||percentage===100;if(percentage===100){first=true;last=true}const spanStyle={backgroundColor:hexCode,opacity:!inFocus?1:.3};let borderRadius="";if(first){borderRadius="4px 0 0 4px"}if(last){borderRadius="0 4px 4px 0"}if(first&&last){borderRadius="4px"}spanStyle.borderRadius=borderRadius;return spanStyle};function ColorPaletteFlexItem({hexCode:hexCode,inFocus:inFocus,percentage:percentage,tooltip:tooltip,position:position}){const spanStyle=getSpanStyle(position,inFocus,hexCode,percentage);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:hexCode,grow:false,style:{width:percentage+"%"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:tooltip},external_kbnSharedDeps_React_default.a.createElement(ColoredSpan,{style:spanStyle})))}function getCoreVitalTooltipMessage(thresholds,position,title,percentage,isCls){const good=position===0;const bad=position===2;const average=!good&&!bad;return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.dashboard.webVitals.palette.tooltip",{defaultMessage:"{percentage} % of users have {exp} experience because the {title} {isOrTakes} {moreOrLess} than {value}{averageMessage}.",values:{percentage:percentage,isOrTakes:isCls?IS_LABEL:TAKES_LABEL,title:title===null||title===void 0?void 0:title.toLowerCase(),exp:good?CV_GOOD_LABEL:bad?CV_POOR_LABEL:CV_AVERAGE_LABEL,moreOrLess:bad||average?MORE_LABEL:LESS_LABEL,value:good||average?thresholds.good:thresholds.bad,averageMessage:average?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreVitals.averageMessage",{defaultMessage:" and less than {bad}",values:{bad:thresholds.bad}}):""}})}function CoreVitalItem({loading:loading,title:title,value:value,thresholds:thresholds,ranks:ranks=[100,0,0],isCls:isCls,helpLabel:helpLabel}){const palette=Object(external_kbnSharedDeps_ElasticEui_["euiPaletteForStatus"])(3);const[inFocusInd,setInFocusInd]=Object(external_kbnSharedDeps_React_["useState"])(null);const biggestValIndex=ranks.indexOf(Math.max(...ranks));if(!value&&!loading){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCard"],{title:title,isDisabled:true,description:NO_DATA})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{"aria-label":`${title} ${value}`,titleSize:"s",title:value!==null&&value!==void 0?value:"",description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,title,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:helpLabel,type:"questionInCircle"})),titleColor:palette[biggestValIndex],isLoading:loading}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"flexStart",style:{maxWidth:350},responsive:false},palette.map((hexCode,ind)=>external_kbnSharedDeps_React_default.a.createElement(ColorPaletteFlexItem,{hexCode:hexCode,key:hexCode,position:ind,inFocus:inFocusInd!==ind&&inFocusInd!==null,percentage:ranks[ind],tooltip:getCoreVitalTooltipMessage(thresholds,ind,title,ranks[ind],isCls)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(PaletteLegends,{ranks:ranks,thresholds:thresholds,title:title,onItemHover:ind=>{setInFocusInd(ind)},isCls:isCls}))}const CORE_WEB_VITALS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreWebVitals",{defaultMessage:"Core web vitals"});const BROWSER_CORE_WEB_VITALS=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreWebVitals.browser.support",{defaultMessage:"browser support for core web vitals"});function WebCoreVitalsTitle({loading:loading,coreVitalPages:coreVitalPages,totalPageViews:totalPageViews=0,displayTrafficMetric:displayTrafficMetric}){const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isBrowserPopoverOpen,setIsBrowserPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const closePopover=()=>setIsPopoverOpen(false);const closeBrowserPopover=()=>setIsBrowserPopoverOpen(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,CORE_WEB_VITALS,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:()=>setIsPopoverOpen(true),color:"text",iconType:"questionInCircle"}),closePopover:closePopover},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.observability.ux.dashboard.webCoreVitals.help",defaultMessage:"Learn more about"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://web.dev/vitals/",external:true,target:"_blank"},CORE_WEB_VITALS))))))),displayTrafficMetric&&totalPageViews>0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},loading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.observability.ux.dashboard.webCoreVitals.traffic",defaultMessage:"{trafficPerc} of the traffic represented",values:{trafficPerc:external_kbnSharedDeps_React_default.a.createElement("strong",null," ",((coreVitalPages||0)/totalPageViews*100).toFixed(0),"%")}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isBrowserPopoverOpen,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:()=>setIsBrowserPopoverOpen(true),color:"text",iconType:"questionInCircle"}),closePopover:closeBrowserPopover},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.observability.ux.dashboard.webCoreVitals.browser.help",defaultMessage:"Learn more about"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://github.com/GoogleChrome/web-vitals#browser-support",external:true,target:"_blank"},BROWSER_CORE_WEB_VITALS)))))))}const SERVICE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.coreWebVitals.service",{defaultMessage:"Service"});const SERVICE_LABEL_HELP=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.observability.ux.service.help",{defaultMessage:"The RUM service with the most traffic is selected"});function ServiceName({name:name}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},SERVICE_LABEL,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"text","aria-label":SERVICE_LABEL_HELP,type:"questionInCircle",content:SERVICE_LABEL_HELP})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,name)))}function formatToSec(value,fromUnit="MicroSec"){const valueInMs=Number(value!==null&&value!==void 0?value:0)/(fromUnit==="MicroSec"?1e3:1);if(valueInMs<1e3){return valueInMs.toFixed(0)+" ms"}return(valueInMs/1e3).toFixed(2)+" s"}function formatToMilliseconds(value){if(typeof value==="undefined"||value===null){return null}return formatToSec(value,"ms")}const CoreVitalsThresholds={LCP:{good:"2.5s",bad:"4.0s"},FID:{good:"100ms",bad:"300ms"},CLS:{good:"0.1",bad:"0.25"}};function CoreVitals({data:data,loading:loading,displayServiceName:displayServiceName,serviceName:serviceName,totalPageViews:totalPageViews,displayTrafficMetric:displayTrafficMetric=false}){var _cls$toFixed;const{lcp:lcp,lcpRanks:lcpRanks,fid:fid,fidRanks:fidRanks,cls:cls,clsRanks:clsRanks,coreVitalPages:coreVitalPages}=data||{};return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_["createElement"](WebCoreVitalsTitle,{loading:loading,coreVitalPages:coreVitalPages,totalPageViews:totalPageViews,displayTrafficMetric:displayTrafficMetric}),external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),displayServiceName&&external_kbnSharedDeps_React_["createElement"](ServiceName,{name:serviceName}),external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xl",justifyContent:"spaceBetween",wrap:true},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{flexBasis:380}},external_kbnSharedDeps_React_["createElement"](CoreVitalItem,{title:LCP_LABEL,value:formatToMilliseconds(lcp),ranks:lcpRanks,loading:loading,thresholds:CoreVitalsThresholds.LCP,helpLabel:LCP_HELP_LABEL})),external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{flexBasis:380}},external_kbnSharedDeps_React_["createElement"](CoreVitalItem,{title:FID_LABEL,value:formatToMilliseconds(fid),ranks:fidRanks,loading:loading,thresholds:CoreVitalsThresholds.FID,helpLabel:FID_HELP_LABEL})),external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{flexBasis:380}},external_kbnSharedDeps_React_["createElement"](CoreVitalItem,{title:CLS_LABEL,value:(_cls$toFixed=cls===null||cls===void 0?void 0:cls.toFixed(3))!==null&&_cls$toFixed!==void 0?_cls$toFixed:null,ranks:clsRanks,loading:loading,thresholds:CoreVitalsThresholds.CLS,isCls:true,helpLabel:CLS_HELP_LABEL}))))}}}]);