"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLink = exports.AlertingDefaults = void 0;

var _i18n = require("@kbn/i18n");

var _enums = require("../../common/enums");

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

class AlertingDefaults {}

exports.AlertingDefaults = AlertingDefaults;

_defineProperty(AlertingDefaults, "THROTTLE", '1d');

_defineProperty(AlertingDefaults, "SCHEDULE_INTERVAL", '1m');

_defineProperty(AlertingDefaults, "ALERT_STATE", {
  firing: _i18n.i18n.translate('xpack.monitoring.alerts.state.firing', {
    defaultMessage: 'firing'
  })
});

_defineProperty(AlertingDefaults, "ALERT_TYPE", {
  context: {
    internalShortMessage: {
      name: 'internalShortMessage',
      description: _i18n.i18n.translate('xpack.monitoring.alerts.actionVariables.internalShortMessage', {
        defaultMessage: 'The short internal message generated by Elastic.'
      })
    },
    internalFullMessage: {
      name: 'internalFullMessage',
      description: _i18n.i18n.translate('xpack.monitoring.alerts.actionVariables.internalFullMessage', {
        defaultMessage: 'The full internal message generated by Elastic.'
      })
    },
    state: {
      name: 'state',
      description: _i18n.i18n.translate('xpack.monitoring.alerts.actionVariables.state', {
        defaultMessage: 'The current state of the alert.'
      })
    },
    clusterName: {
      name: 'clusterName',
      description: _i18n.i18n.translate('xpack.monitoring.alerts.actionVariables.clusterName', {
        defaultMessage: 'The cluster to which the nodes belong.'
      })
    },
    action: {
      name: 'action',
      description: _i18n.i18n.translate('xpack.monitoring.alerts.actionVariables.action', {
        defaultMessage: 'The recommended action for this alert.'
      })
    },
    actionPlain: {
      name: 'actionPlain',
      description: _i18n.i18n.translate('xpack.monitoring.alerts.actionVariables.actionPlain', {
        defaultMessage: 'The recommended action for this alert, without any markdown.'
      })
    }
  }
});

const createLink = (linkText, linkURL, type = _enums.AlertMessageTokenType.DocLink) => {
  const link = type === _enums.AlertMessageTokenType.DocLink ? {
    partialUrl: linkURL
  } : {
    url: linkURL
  };
  return {
    text: linkText,
    tokens: [{ ...link,
      startToken: '#start_link',
      endToken: '#end_link',
      type
    }]
  };
};

exports.createLink = createLink;