/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["ml_bundle_jsonpfunction"]=window["ml_bundle_jsonpfunction"]||[]).push([[7],{114:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"mlResultsService",(function(){return mlResultsService}));__webpack_require__.d(__webpack_exports__,"mlResultsServiceProvider",(function(){return mlResultsServiceProvider}));var external_kbnSharedDeps_RxjsOperators_=__webpack_require__(21);var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var job_utils=__webpack_require__(64);var validation_utils=__webpack_require__(126);var datafeed_utils=__webpack_require__(221);var anomaly_utils=__webpack_require__(6);var aggregation_types=__webpack_require__(79);var object_utils=__webpack_require__(127);function resultsServiceRxProvider(mlApiServices){return{getMetricData(index,entityFields,query,metricFunction,metricFieldName,summaryCountFieldName,timeFieldName,earliestMs,latestMs,intervalMs,datafeedConfig){const scriptFields=datafeedConfig===null||datafeedConfig===void 0?void 0:datafeedConfig.script_fields;const aggFields=Object(datafeed_utils["c"])(datafeedConfig);const shouldCriteria=[];const mustCriteria=[{range:{[timeFieldName]:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},...query?[query]:[]];entityFields.forEach(entity=>{if(entity.fieldValue.length!==0){mustCriteria.push({term:{[entity.fieldName]:entity.fieldValue}})}else{shouldCriteria.push({bool:{must:[{term:{[entity.fieldName]:""}}]}});shouldCriteria.push({bool:{must_not:[{exists:{field:entity.fieldName}}]}})}});const body={query:{bool:{must:mustCriteria}},size:0,_source:{excludes:[]},aggs:{byTime:{date_histogram:{field:timeFieldName,fixed_interval:`${intervalMs}ms`,min_doc_count:0}}}};if(shouldCriteria.length>0){body.query.bool.should=shouldCriteria;body.query.bool.minimum_should_match=shouldCriteria.length/2}body.aggs.byTime.aggs={};if(metricFieldName!==undefined&&metricFieldName!==""&&metricFunction){const metricAgg={[metricFunction]:{}};if(scriptFields!==undefined&&scriptFields[metricFieldName]!==undefined){metricAgg[metricFunction].script=scriptFields[metricFieldName].script}else{metricAgg[metricFunction].field=metricFieldName}if(metricFunction==="percentiles"){metricAgg[metricFunction].percents=[job_utils["b"]]}if(Object(object_utils["a"])(aggFields)){var _aggFields$accessor$a;const accessor=Object.keys(aggFields)[0];const tempAggs={...(_aggFields$accessor$a=aggFields[accessor].aggs)!==null&&_aggFields$accessor$a!==void 0?_aggFields$accessor$a:aggFields[accessor].aggregations};const foundValue=Object(validation_utils["a"])(tempAggs,metricFieldName);if(foundValue!==undefined){tempAggs.metric=foundValue;delete tempAggs[metricFieldName]}body.aggs.byTime.aggs=tempAggs}else{body.aggs.byTime.aggs.metric=metricAgg}}else{if(summaryCountFieldName!==undefined&&metricFunction===aggregation_types["a"].CARDINALITY){if(typeof aggFields==="object"&&Object.keys(aggFields).length>0){var _aggFields$accessor$a2;const accessor=Object.keys(aggFields)[0];const tempAggs={...(_aggFields$accessor$a2=aggFields[accessor].aggs)!==null&&_aggFields$accessor$a2!==void 0?_aggFields$accessor$a2:aggFields[accessor].aggregations};const foundCardinalityField=Object(validation_utils["a"])(tempAggs,summaryCountFieldName);if(foundCardinalityField!==undefined){tempAggs.metric=foundCardinalityField}body.aggs.byTime.aggs=tempAggs}}}return mlApiServices.esSearch$({index:index,body:body}).pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(resp=>{var _resp$aggregations$by,_resp$aggregations,_resp$aggregations$by2;const obj={success:true,results:{}};const dataByTime=(_resp$aggregations$by=resp===null||resp===void 0?void 0:(_resp$aggregations=resp.aggregations)===null||_resp$aggregations===void 0?void 0:(_resp$aggregations$by2=_resp$aggregations.byTime)===null||_resp$aggregations$by2===void 0?void 0:_resp$aggregations$by2.buckets)!==null&&_resp$aggregations$by!==void 0?_resp$aggregations$by:[];dataByTime.forEach(dataForTime=>{if(metricFunction==="count"){obj.results[dataForTime.key]=dataForTime.doc_count}else{var _dataForTime$metric,_dataForTime$metric2;const value=dataForTime===null||dataForTime===void 0?void 0:(_dataForTime$metric=dataForTime.metric)===null||_dataForTime$metric===void 0?void 0:_dataForTime$metric.value;const values=dataForTime===null||dataForTime===void 0?void 0:(_dataForTime$metric2=dataForTime.metric)===null||_dataForTime$metric2===void 0?void 0:_dataForTime$metric2.values;if(dataForTime.doc_count===0){obj.results[dataForTime.key]=null}else if(value!==undefined){obj.results[dataForTime.key]=value}else if(values!==undefined){const medianValues=values[job_utils["b"]];obj.results[dataForTime.key]=!isNaN(medianValues)?medianValues:null}else{obj.results[dataForTime.key]=null}}});return obj}))},getModelPlotOutput(jobId,detectorIndex,criteriaFields,earliestMs,latestMs,intervalMs,aggType){const obj={success:true,results:{}};const modelAggs=aggType===undefined?{max:"max",min:"min"}:{max:aggType.max,min:aggType.min};const mustCriteria=[{term:{job_id:jobId}},{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];Object(external_kbnSharedDeps_Lodash_["each"])(criteriaFields,criteria=>{mustCriteria.push({term:{[criteria.fieldName]:criteria.fieldValue}})});const shouldCriteria=[{term:{detector_index:detectorIndex}},{bool:{must_not:[{exists:{field:"detector_index"}}]}}];return mlApiServices.results.anomalySearch$({size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:model_plot",analyze_wildcard:true}},{bool:{must:mustCriteria,should:shouldCriteria,minimum_should_match:1}}]}},aggs:{times:{date_histogram:{field:"timestamp",fixed_interval:`${intervalMs}ms`,min_doc_count:0},aggs:{actual:{avg:{field:"actual"}},modelUpper:{[modelAggs.max]:{field:"model_upper"}},modelLower:{[modelAggs.min]:{field:"model_lower"}}}}}}},[jobId]).pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(resp=>{const aggregationsByTime=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","times","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(aggregationsByTime,dataForTime=>{const time=dataForTime.key;const modelUpper=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["modelUpper","value"]);const modelLower=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["modelLower","value"]);const actual=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["actual","value"]);obj.results[time]={actual:actual,modelUpper:modelUpper===undefined||isFinite(modelUpper)===false?null:modelUpper,modelLower:modelLower===undefined||isFinite(modelLower)===false?null:modelLower}});return obj}))},getRecordsForCriteria(jobIds,criteriaFields,threshold,earliestMs,latestMs,maxResults,functionDescription){const obj={success:true,records:[]};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{record_score:{gte:threshold}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}Object(external_kbnSharedDeps_Lodash_["each"])(criteriaFields,criteria=>{boolCriteria.push({term:{[criteria.fieldName]:criteria.fieldValue}})});if(functionDescription!==undefined){const mlFunctionToPlotIfMetric=functionDescription!==undefined?anomaly_utils["b"].toML(functionDescription):functionDescription;boolCriteria.push({term:{function_description:mlFunctionToPlotIfMetric}})}return mlApiServices.results.anomalySearch$({size:maxResults!==undefined?maxResults:100,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}},jobIds).pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(resp=>{if(resp.hits.total.value>0){Object(external_kbnSharedDeps_Lodash_["each"])(resp.hits.hits,hit=>{obj.records.push(hit._source)})}return obj}))},getScheduledEventsByBucket(jobIds,earliestMs,latestMs,intervalMs,maxJobs,maxEvents){const obj={success:true,events:{}};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{exists:{field:"scheduled_events"}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{jobIdFilterStr+=`${i>0?" OR ":""}job_id:${jobId}`});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}return mlApiServices.results.anomalySearch$({size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:bucket",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{jobs:{terms:{field:"job_id",min_doc_count:1,size:maxJobs},aggs:{times:{date_histogram:{field:"timestamp",fixed_interval:`${intervalMs}ms`,min_doc_count:1},aggs:{events:{terms:{field:"scheduled_events",size:maxEvents}}}}}}}}},jobIds).pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(resp=>{const dataByJobId=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","jobs","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(dataByJobId,dataForJob=>{const jobId=dataForJob.key;const resultsForTime={};const dataByTime=Object(external_kbnSharedDeps_Lodash_["get"])(dataForJob,["times","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(dataByTime,dataForTime=>{const time=dataForTime.key;const events=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["events","buckets"]);resultsForTime[time]=events.map(e=>e.key)});obj.events[jobId]=resultsForTime});return obj}))},fetchPartitionFieldsValues(jobId,searchTerm,criteriaFields,earliestMs,latestMs){return mlApiServices.results.fetchPartitionFieldsValues(jobId,searchTerm,criteriaFields,earliestMs,latestMs)}}}var string_utils=__webpack_require__(84);var explorer_constants=__webpack_require__(69);function resultsServiceProvider(mlApiServices){const SAMPLER_TOP_TERMS_SHARD_SIZE=2e4;const ENTITY_AGGREGATION_SIZE=10;const AGGREGATION_MIN_DOC_COUNT=1;const CARDINALITY_PRECISION_THRESHOLD=100;return{getScoresByBucket(jobIds,earliestMs,latestMs,intervalMs,perPage=10,fromPage=1){return new Promise((resolve,reject)=>{var _jobIds$length;const obj={success:true,results:{}};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}mlApiServices.results.anomalySearch({size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:bucket",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{jobsCardinality:{cardinality:{field:"job_id"}},jobId:{terms:{field:"job_id",size:(_jobIds$length=jobIds===null||jobIds===void 0?void 0:jobIds.length)!==null&&_jobIds$length!==void 0?_jobIds$length:1,order:{anomalyScore:"desc"}},aggs:{anomalyScore:{max:{field:"anomaly_score"}},bucketTruncate:{bucket_sort:{from:(fromPage-1)*perPage,size:perPage===0?1:perPage}},byTime:{date_histogram:{field:"timestamp",fixed_interval:`${intervalMs}ms`,min_doc_count:1,extended_bounds:{min:earliestMs,max:latestMs}},aggs:{anomalyScore:{max:{field:"anomaly_score"}}}}}}}}},jobIds).then(resp=>{var _resp$aggregations$jo,_resp$aggregations,_resp$aggregations$jo2;const dataByJobId=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","jobId","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(dataByJobId,dataForJob=>{const jobId=dataForJob.key;const resultsForTime={};const dataByTime=Object(external_kbnSharedDeps_Lodash_["get"])(dataForJob,["byTime","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(dataByTime,dataForTime=>{const value=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["anomalyScore","value"]);if(value!==undefined){const time=dataForTime.key;resultsForTime[time]=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["anomalyScore","value"])}});obj.results[jobId]=resultsForTime});obj.cardinality=(_resp$aggregations$jo=(_resp$aggregations=resp.aggregations)===null||_resp$aggregations===void 0?void 0:(_resp$aggregations$jo2=_resp$aggregations.jobsCardinality)===null||_resp$aggregations$jo2===void 0?void 0:_resp$aggregations$jo2.value)!==null&&_resp$aggregations$jo!==void 0?_resp$aggregations$jo:0;resolve(obj)}).catch(resp=>{reject(resp)})})},getTopInfluencers(jobIds,earliestMs,latestMs,maxFieldValues=explorer_constants["a"],perPage=10,fromPage=1,influencers=[],influencersFilterQuery){return new Promise((resolve,reject)=>{const obj={success:true,influencers:{}};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{influencer_score:{gt:0}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}if(influencersFilterQuery!==undefined){boolCriteria.push(influencersFilterQuery)}if(influencers.length>0){boolCriteria.push({bool:{should:influencers.map(influencer=>({bool:{must:[{term:{influencer_field_name:influencer.fieldName}},{term:{influencer_field_value:influencer.fieldValue}}]}})),minimum_should_match:1}})}mlApiServices.results.anomalySearch({size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:influencer",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{influencerFieldNames:{terms:{field:"influencer_field_name",size:5,order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},influencerFieldValues:{terms:{field:"influencer_field_value",size:!!maxFieldValues?maxFieldValues:explorer_constants["a"],order:{maxAnomalyScore:"desc"}},aggs:{bucketTruncate:{bucket_sort:{from:(fromPage-1)*perPage,size:perPage}},maxAnomalyScore:{max:{field:"influencer_score"}},sumAnomalyScore:{sum:{field:"influencer_score"}}}}}}}}},jobIds).then(resp=>{const fieldNameBuckets=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","influencerFieldNames","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(fieldNameBuckets,nameBucket=>{const fieldName=nameBucket.key;const fieldValues=[];const fieldValueBuckets=Object(external_kbnSharedDeps_Lodash_["get"])(nameBucket,["influencerFieldValues","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(fieldValueBuckets,valueBucket=>{const fieldValueResult={influencerFieldValue:valueBucket.key,maxAnomalyScore:valueBucket.maxAnomalyScore.value,sumAnomalyScore:valueBucket.sumAnomalyScore.value};fieldValues.push(fieldValueResult)});obj.influencers[fieldName]=fieldValues});resolve(obj)}).catch(resp=>{reject(resp)})})},getTopInfluencerValues(jobIds,influencerFieldName,earliestMs,latestMs,maxResults){return new Promise((resolve,reject)=>{const obj={success:true,results:[]};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}mlApiServices.results.anomalySearch({size:0,body:{query:{bool:{filter:[{query_string:{query:`result_type:influencer AND influencer_field_name: ${Object(string_utils["c"])(influencerFieldName)}`,analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{influencerFieldValues:{terms:{field:"influencer_field_value",size:!!maxResults?maxResults:2,order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},sumAnomalyScore:{sum:{field:"influencer_score"}}}}}}},jobIds).then(resp=>{const buckets=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","influencerFieldValues","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(buckets,bucket=>{const result={influencerFieldValue:bucket.key,maxAnomalyScore:bucket.maxAnomalyScore.value,sumAnomalyScore:bucket.sumAnomalyScore.value};obj.results.push(result)});resolve(obj)}).catch(resp=>{reject(resp)})})},getOverallBucketScores(jobIds,topN,earliestMs,latestMs,interval){return new Promise((resolve,reject)=>{const obj={success:true,results:{}};mlApiServices.overallBuckets({jobId:jobIds,topN:topN,bucketSpan:interval,start:earliestMs,end:latestMs}).then(resp=>{const dataByTime=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["overall_buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(dataByTime,dataForTime=>{const value=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["overall_score"]);if(value!==undefined){obj.results[dataForTime.timestamp]=value}});resolve(obj)}).catch(resp=>{reject(resp)})})},getInfluencerValueMaxScoreByTime(jobIds,influencerFieldName,influencerFieldValues,earliestMs,latestMs,intervalMs,maxResults=explorer_constants["a"],perPage=explorer_constants["i"],fromPage=1,influencersFilterQuery){return new Promise((resolve,reject)=>{const obj={success:true,results:{}};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{influencer_score:{gt:0}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+=`job_id:${jobId}`});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}if(influencersFilterQuery!==undefined){boolCriteria.push(influencersFilterQuery)}if(influencerFieldValues&&influencerFieldValues.length>0){let influencerFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(influencerFieldValues,(value,i)=>{if(i>0){influencerFilterStr+=" OR "}if(value.trim().length>0){influencerFilterStr+=`influencer_field_value:${Object(string_utils["c"])(value)}`}else{influencerFilterStr+=`influencer_field_value:"${value}"`}});boolCriteria.push({query_string:{analyze_wildcard:false,query:influencerFilterStr}})}mlApiServices.results.anomalySearch({size:0,body:{query:{bool:{filter:[{query_string:{query:`result_type:influencer AND influencer_field_name: ${Object(string_utils["c"])(influencerFieldName)}`,analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},aggs:{influencerValuesCardinality:{cardinality:{field:"influencer_field_value"}},influencerFieldValues:{terms:{field:"influencer_field_value",size:!!maxResults?maxResults:explorer_constants["a"],order:{maxAnomalyScore:"desc"}},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}},bucketTruncate:{bucket_sort:{from:(fromPage-1)*perPage,size:perPage}},byTime:{date_histogram:{field:"timestamp",fixed_interval:`${intervalMs}ms`,min_doc_count:1},aggs:{maxAnomalyScore:{max:{field:"influencer_score"}}}}}}}}},jobIds).then(resp=>{var _resp$aggregations$in,_resp$aggregations2,_resp$aggregations2$i;const fieldValueBuckets=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","influencerFieldValues","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(fieldValueBuckets,valueBucket=>{const fieldValue=valueBucket.key;const fieldValues={};const timeBuckets=Object(external_kbnSharedDeps_Lodash_["get"])(valueBucket,["byTime","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(timeBuckets,timeBucket=>{const time=timeBucket.key;const score=timeBucket.maxAnomalyScore.value;fieldValues[time]=score});obj.results[fieldValue]=fieldValues});obj.cardinality=(_resp$aggregations$in=(_resp$aggregations2=resp.aggregations)===null||_resp$aggregations2===void 0?void 0:(_resp$aggregations2$i=_resp$aggregations2.influencerValuesCardinality)===null||_resp$aggregations2$i===void 0?void 0:_resp$aggregations2$i.value)!==null&&_resp$aggregations$in!==void 0?_resp$aggregations$in:0;resolve(obj)}).catch(resp=>{reject(resp)})})},getRecordInfluencers(jobIds,threshold,earliestMs,latestMs,maxResults){return new Promise((resolve,reject)=>{const obj={success:true,records:[]};const boolCriteria=[{nested:{path:"influencers",query:{bool:{must:[{exists:{field:"influencers"}}]}}}},{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{record_score:{gte:threshold}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}mlApiServices.results.anomalySearch({size:maxResults!==undefined?maxResults:100,body:{_source:["job_id","detector_index","influencers","record_score"],query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}},jobIds).then(resp=>{if(resp.hits.total.value>0){Object(external_kbnSharedDeps_Lodash_["each"])(resp.hits.hits,hit=>{obj.records.push(hit._source)})}resolve(obj)}).catch(resp=>{reject(resp)})})},getRecordsForInfluencer(jobIds,influencers,threshold,earliestMs,latestMs,maxResults,influencersFilterQuery){return new Promise((resolve,reject)=>{const obj={success:true,records:[]};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{range:{record_score:{gte:threshold}}}];if(jobIds&&jobIds.length>0&&!(jobIds.length===1&&jobIds[0]==="*")){let jobIdFilterStr="";Object(external_kbnSharedDeps_Lodash_["each"])(jobIds,(jobId,i)=>{if(i>0){jobIdFilterStr+=" OR "}jobIdFilterStr+="job_id:";jobIdFilterStr+=jobId});boolCriteria.push({query_string:{analyze_wildcard:false,query:jobIdFilterStr}})}if(influencersFilterQuery!==undefined){boolCriteria.push(influencersFilterQuery)}if(influencers.length>0){boolCriteria.push({bool:{should:influencers.map(influencer=>({nested:{path:"influencers",query:{bool:{must:[{match:{"influencers.influencer_field_name":influencer.fieldName}},{match:{"influencers.influencer_field_values":influencer.fieldValue}}]}}}})),minimum_should_match:1}})}mlApiServices.results.anomalySearch({size:maxResults!==undefined?maxResults:100,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}},jobIds).then(resp=>{if(resp.hits.total.value>0){Object(external_kbnSharedDeps_Lodash_["each"])(resp.hits.hits,hit=>{obj.records.push(hit._source)})}resolve(obj)}).catch(resp=>{reject(resp)})})},getRecordsForDetector(jobId,detectorIndex,checkForInfluencers,influencerFieldName,influencerFieldValue,threshold,earliestMs,latestMs,maxResults){return new Promise((resolve,reject)=>{const obj={success:true,records:[]};const boolCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{term:{job_id:jobId}},{term:{detector_index:detectorIndex}},{range:{record_score:{gte:threshold}}}];if(influencerFieldName&&influencerFieldValue){boolCriteria.push({nested:{path:"influencers",query:{bool:{must:[{match:{"influencers.influencer_field_name":influencerFieldName}},{match:{"influencers.influencer_field_values":influencerFieldValue}}]}}}})}else{if(checkForInfluencers===true){boolCriteria.push({nested:{path:"influencers",query:{bool:{must:[{exists:{field:"influencers"}}]}}}})}}mlApiServices.results.anomalySearch({size:maxResults!==undefined?maxResults:100,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:false}},{bool:{must:boolCriteria}}]}},sort:[{record_score:{order:"desc"}}]}},[jobId]).then(resp=>{if(resp.hits.total.value>0){Object(external_kbnSharedDeps_Lodash_["each"])(resp.hits.hits,hit=>{obj.records.push(hit._source)})}resolve(obj)}).catch(resp=>{reject(resp)})})},getRecords(jobIds,threshold,earliestMs,latestMs,maxResults){return this.getRecordsForInfluencer(jobIds,[],threshold,earliestMs,latestMs,maxResults)},getEventRateData(index,query,timeFieldName,earliestMs,latestMs,intervalMs){return new Promise((resolve,reject)=>{const obj={success:true,results:{}};const mustCriteria=[{range:{[timeFieldName]:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}}];if(query){mustCriteria.push(query)}mlApiServices.esSearch({index:index,size:0,body:{query:{bool:{must:mustCriteria}},_source:{excludes:[]},aggs:{eventRate:{date_histogram:{field:timeFieldName,fixed_interval:`${intervalMs}ms`,min_doc_count:0,extended_bounds:{min:earliestMs,max:latestMs}}}}}}).then(resp=>{const dataByTimeBucket=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","eventRate","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(dataByTimeBucket,dataForTime=>{const time=dataForTime.key;obj.results[time]=dataForTime.doc_count});obj.total=resp.hits.total.value;resolve(obj)}).catch(resp=>{reject(resp)})})},getEventDistributionData(index,splitField,filterField=null,query,metricFunction,metricFieldName,timeFieldName,earliestMs,latestMs,intervalMs){return new Promise((resolve,reject)=>{if(splitField===undefined){return resolve([])}const mustCriteria=[];mustCriteria.push({range:{[timeFieldName]:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}});if(query){mustCriteria.push(query)}if(filterField!==null){mustCriteria.push({term:{[filterField.fieldName]:filterField.fieldValue}})}const body={query:{function_score:{query:{bool:{must:mustCriteria}},functions:[{random_score:{seed:10,field:"_seq_no"}}]}},size:0,_source:{excludes:[]},aggs:{sample:{sampler:{shard_size:SAMPLER_TOP_TERMS_SHARD_SIZE},aggs:{byTime:{date_histogram:{field:timeFieldName,fixed_interval:`${intervalMs}ms`,min_doc_count:AGGREGATION_MIN_DOC_COUNT},aggs:{entities:{terms:{field:splitField.fieldName,size:ENTITY_AGGREGATION_SIZE,min_doc_count:AGGREGATION_MIN_DOC_COUNT}}}}}}}};if(metricFieldName!==undefined&&metricFieldName!==""){body.aggs.sample.aggs.byTime.aggs.entities.aggs={};const metricAgg={[metricFunction]:{field:metricFieldName}};if(metricFunction==="percentiles"){metricAgg[metricFunction].percents=[job_utils["b"]]}if(metricFunction==="cardinality"){metricAgg[metricFunction].precision_threshold=CARDINALITY_PRECISION_THRESHOLD}body.aggs.sample.aggs.byTime.aggs.entities.aggs.metric=metricAgg}mlApiServices.esSearch({index:index,body:body,track_total_hits:true}).then(resp=>{const totalHits=resp.hits.total.value;const successfulShards=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["_shards","successful"],0);let normalizeFactor=1;if(totalHits>successfulShards*SAMPLER_TOP_TERMS_SHARD_SIZE){normalizeFactor=totalHits/(successfulShards*SAMPLER_TOP_TERMS_SHARD_SIZE)}const dataByTime=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","sample","byTime","buckets"],[]);const data=dataByTime.reduce((d,dataForTime)=>{const date=+dataForTime.key;const entities=Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["entities","buckets"],[]);entities.forEach(entity=>{let value=metricFunction==="count"?entity.doc_count:entity.metric.value;if(metricFunction==="count"||metricFunction==="cardinality"||metricFunction==="sum"){value=value*normalizeFactor}d.push({date:date,entity:entity.key,value:value})});return d},[]);resolve(data)}).catch(resp=>{reject(resp)})})},getRecordMaxScoreByTime(jobId,criteriaFields,earliestMs,latestMs,intervalMs,actualPlotFunctionIfMetric){return new Promise((resolve,reject)=>{const obj={success:true,results:{}};const mustCriteria=[{range:{timestamp:{gte:earliestMs,lte:latestMs,format:"epoch_millis"}}},{term:{job_id:jobId}}];Object(external_kbnSharedDeps_Lodash_["each"])(criteriaFields,criteria=>{mustCriteria.push({term:{[criteria.fieldName]:criteria.fieldValue}})});if(actualPlotFunctionIfMetric!==undefined){const mlFunctionToPlotIfMetric=actualPlotFunctionIfMetric!==undefined?anomaly_utils["b"].toML(actualPlotFunctionIfMetric):actualPlotFunctionIfMetric;mustCriteria.push({term:{function_description:mlFunctionToPlotIfMetric}})}mlApiServices.results.anomalySearch({size:0,body:{query:{bool:{filter:[{query_string:{query:"result_type:record",analyze_wildcard:true}},{bool:{must:mustCriteria}}]}},aggs:{times:{date_histogram:{field:"timestamp",fixed_interval:`${intervalMs}ms`,min_doc_count:1},aggs:{recordScore:{max:{field:"record_score"}}}}}}},[jobId]).then(resp=>{const aggregationsByTime=Object(external_kbnSharedDeps_Lodash_["get"])(resp,["aggregations","times","buckets"],[]);Object(external_kbnSharedDeps_Lodash_["each"])(aggregationsByTime,dataForTime=>{const time=dataForTime.key;obj.results[time]={score:Object(external_kbnSharedDeps_Lodash_["get"])(dataForTime,["recordScore","value"])}});resolve(obj)}).catch(resp=>{reject(resp)})})}}}var ml_api_service=__webpack_require__(59);const mlResultsService=mlResultsServiceProvider(ml_api_service["ml"]);function mlResultsServiceProvider(mlApiServices){return{...resultsServiceProvider(mlApiServices),...resultsServiceRxProvider(mlApiServices)}}}}]);