/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["ml_bundle_jsonpfunction"]=window["ml_bundle_jsonpfunction"]||[]).push([[5],{116:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return TIME_FORMAT}));const TIME_FORMAT="YYYY-MM-DD HH:mm:ss"},122:function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(455)()}},154:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SWIM_LANE_LABEL_WIDTH}));__webpack_require__.d(__webpack_exports__,"c",(function(){return isViewBySwimLaneData}));__webpack_require__.d(__webpack_exports__,"b",(function(){return SwimlaneContainer}));var external_kbnSharedDeps_React_=__webpack_require__(10);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(33);var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(37);var external_kbnSharedDeps_Moment_=__webpack_require__(12);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(34);const SwimLanePagination=({cardinality:cardinality,fromPage:fromPage,perPage:perPage,onPaginationChange:onPaginationChange})=>{const componentFromPage=fromPage-1;const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const onButtonClick=()=>setIsPopoverOpen(()=>!isPopoverOpen);const closePopover=()=>setIsPopoverOpen(false);const goToPage=Object(external_kbnSharedDeps_React_["useCallback"])(pageNumber=>{onPaginationChange({fromPage:pageNumber+1})},[]);const setPerPage=Object(external_kbnSharedDeps_React_["useCallback"])(perPageUpdate=>{onPaginationChange({perPage:perPageUpdate})},[]);const pageCount=Math.ceil(cardinality/perPage);const items=[5,10,20,50,100].map(v=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:`${v}_rows`,icon:v===perPage?"check":"empty",onClick:()=>{closePopover();setPerPage(v)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.explorer.swimLaneSelectRowsPerPage",defaultMessage:"{rowsCount} rows",values:{rowsCount:v}})));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",color:"text",iconType:"arrowDown",iconSide:"right",onClick:onButtonClick},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.explorer.swimLaneRowsPerPage",defaultMessage:"Rows per page: {rowsCount}",values:{rowsCount:perPage}})),isOpen:isPopoverOpen,closePopover:closePopover,panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:items}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPagination"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.explorer.swimLanePagination",{defaultMessage:"Anomaly swim lane pagination"}),pageCount:pageCount,activePage:componentFromPage,onPageClick:goToPage})))};var common=__webpack_require__(13);var explorer_constants=__webpack_require__(69);var string_utils=__webpack_require__(84);var chart_tooltip=__webpack_require__(252);var date_utils=__webpack_require__(67);var anomaly_utils=__webpack_require__(6);var _explorer=__webpack_require__(744);var entity_control=__webpack_require__(175);var kibana=__webpack_require__(58);const RESIZE_THROTTLE_TIME_MS=500;const CELL_HEIGHT=30;const LEGEND_HEIGHT=34;const Y_AXIS_HEIGHT=24;const SWIM_LANE_LABEL_WIDTH=200;function isViewBySwimLaneData(arg){return arg&&arg.hasOwnProperty("cardinality")}const SwimLaneTooltip=fieldName=>({values:values})=>{const tooltipData=[];if(values.length===1&&fieldName){const[yAxis]=values;tooltipData.push({skipHeader:true});tooltipData.push({label:fieldName,value:yAxis.value,seriesIdentifier:{key:yAxis.value}})}else if(values.length===3){const[xAxis,yAxis,cell]=values;const formattedDate=Object(date_utils["b"])(parseInt(xAxis.value,10));tooltipData.push({label:formattedDate});if(fieldName!==undefined){tooltipData.push({label:fieldName,value:yAxis.value,seriesIdentifier:{key:yAxis.value}})}tooltipData.push({label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.explorer.swimlane.maxAnomalyScoreLabel",{defaultMessage:"Max anomaly score"}),value:cell.formattedValue,color:cell.color,seriesIdentifier:{key:cell.value}})}return external_kbnSharedDeps_React_default.a.createElement(chart_tooltip["a"],{tooltipData:tooltipData})};const SwimlaneContainer=({id:id,onResize:onResize,perPage:perPage,fromPage:fromPage,swimlaneLimit:swimlaneLimit,onPaginationChange:onPaginationChange,isLoading:isLoading,noDataWarning:noDataWarning,filterActive:filterActive,swimlaneData:swimlaneData,swimlaneType:swimlaneType,selection:selection,onCellsSelection:onCellsSelection,timeBuckets:timeBuckets,maskAll:maskAll,showTimeline:showTimeline=true,"data-test-subj":dataTestSubj})=>{var _swimlaneData$laneLab,_swimlaneData$laneLab2,_swimlaneData$laneLab3;const[chartWidth,setChartWidth]=Object(external_kbnSharedDeps_React_["useState"])(0);const isDarkTheme=!!Object(kibana["h"])().get("theme:darkMode");const containerHeightRef=Object(external_kbnSharedDeps_React_["useRef"])();const resizeHandler=Object(external_kbnSharedDeps_React_["useCallback"])(Object(external_kbnSharedDeps_Lodash_["throttle"])(e=>{const resultNewWidth=e.width-SWIM_LANE_LABEL_WIDTH;setChartWidth(resultNewWidth);onResize(resultNewWidth)},RESIZE_THROTTLE_TIME_MS),[chartWidth]);const swimLanePoints=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const showFilterContext=filterActive===true&&swimlaneType===explorer_constants["h"].OVERALL;if(!(swimlaneData!==null&&swimlaneData!==void 0&&swimlaneData.points)){return[]}const sortedLaneValues=swimlaneData.laneLabels;return swimlaneData.points.map(v=>{const formatted={...v,time:v.time*1e3};if(showFilterContext){formatted.laneLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.explorer.overallSwimlaneUnfilteredLabel",{defaultMessage:"{label} (unfiltered)",values:{label:Object(string_utils["d"])(v.laneLabel)}})}return formatted}).sort((a,b)=>{let aIndex=sortedLaneValues.indexOf(a.laneLabel);let bIndex=sortedLaneValues.indexOf(b.laneLabel);aIndex=aIndex>-1?aIndex:sortedLaneValues.length;bIndex=bIndex>-1?bIndex:sortedLaneValues.length;return aIndex-bIndex}).filter(v=>v.value>0)},[swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.points,filterActive,swimlaneType,swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.laneLabels]);const showSwimlane=(swimlaneData===null||swimlaneData===void 0?void 0:(_swimlaneData$laneLab=swimlaneData.laneLabels)===null||_swimlaneData$laneLab===void 0?void 0:_swimlaneData$laneLab.length)>0&&swimLanePoints.length>0;const isPaginationVisible=(showSwimlane||isLoading)&&swimlaneLimit!==undefined&&onPaginationChange&&fromPage&&perPage;const rowsCount=(_swimlaneData$laneLab2=swimlaneData===null||swimlaneData===void 0?void 0:(_swimlaneData$laneLab3=swimlaneData.laneLabels)===null||_swimlaneData$laneLab3===void 0?void 0:_swimlaneData$laneLab3.length)!==null&&_swimlaneData$laneLab2!==void 0?_swimlaneData$laneLab2:0;const containerHeight=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isLoading?containerHeightRef.current:rowsCount*CELL_HEIGHT+LEGEND_HEIGHT+(true?Y_AXIS_HEIGHT:undefined),[isLoading,rowsCount,showTimeline]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!isLoading){containerHeightRef.current=containerHeight}},[isLoading,containerHeight]);const highlightedData=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!selection||!swimlaneData)return;if((swimlaneType!==selection.type||(swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.fieldName)!==undefined&&swimlaneData.fieldName!==selection.viewByFieldName)&&filterActive===false){return}return{x:selection.times.map(v=>v*1e3),y:selection.lanes}},[selection,swimlaneData,swimlaneType]);const swimLaneConfig=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!showSwimlane)return{};return{onBrushEnd:e=>{onCellsSelection({lanes:e.y,times:e.x.map(v=>v/1e3),type:swimlaneType,viewByFieldName:swimlaneData.fieldName})},grid:{cellHeight:{min:CELL_HEIGHT,max:CELL_HEIGHT},stroke:{width:1,color:"#D3DAE6"}},cell:{maxWidth:"fill",maxHeight:"fill",label:{visible:false},border:{stroke:"#D3DAE6",strokeWidth:0}},yAxisLabel:{visible:true,width:170,fill:`#6a717d`,padding:8,formatter:laneLabel=>laneLabel===""?entity_control["a"]:laneLabel},xAxisLabel:{visible:true,fill:`#98A2B3`,formatter:v=>{timeBuckets.setInterval(`${swimlaneData.interval}s`);const scaledDateFormat=timeBuckets.getScaledDateFormat();return external_kbnSharedDeps_Moment_default()(v).format(scaledDateFormat)}},brushMask:{fill:isDarkTheme?"rgb(30,31,35,80%)":"rgb(247,247,247,50%)"},brushArea:{stroke:isDarkTheme?"rgb(255, 255, 255)":"rgb(105, 112, 125)"},maxLegendHeight:LEGEND_HEIGHT,timeZone:"UTC"}},[showSwimlane,swimlaneType,swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.fieldName,isDarkTheme,timeBuckets,onCellsSelection]);const onElementClick=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const cell=e[0][0];const startTime=cell.datum.x/1e3;const payload={lanes:[String(cell.datum.y)],times:[startTime,startTime+swimlaneData.interval],type:swimlaneType,viewByFieldName:swimlaneData.fieldName};onCellsSelection(payload)},[swimlaneType,swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.fieldName,swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.interval,onCellsSelection]);const tooltipOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({placement:"auto",fallbackPlacements:["left"],boundary:"chart",customTooltip:SwimLaneTooltip(swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.fieldName)}),[swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.fieldName]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiResizeObserver"],{onResize:resizeHandler},resizeRef=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",direction:"column",style:{width:"100%",height:"100%",overflow:"hidden"},ref:resizeRef,"data-test-subj":"mlSwimLaneContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{width:"100%",overflowY:"auto"},grow:false},external_kbnSharedDeps_React_default.a.createElement("div",{style:{height:`${containerHeight}px`,position:"relative"},"data-test-subj":dataTestSubj},showSwimlane&&!isLoading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{className:"mlSwimLaneContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{onElementClick:onElementClick,showLegend:true,legendPosition:"top",xDomain:{min:swimlaneData.earliest*1e3,max:swimlaneData.latest*1e3,minInterval:swimlaneData.interval*1e3},tooltip:tooltipOptions}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Heatmap"],{id:id,colorScale:"threshold",ranges:[common["ANOMALY_THRESHOLD"].LOW,common["ANOMALY_THRESHOLD"].WARNING,common["ANOMALY_THRESHOLD"].MINOR,common["ANOMALY_THRESHOLD"].MAJOR,common["ANOMALY_THRESHOLD"].CRITICAL],colors:[common["SEVERITY_COLORS"].BLANK,common["SEVERITY_COLORS"].LOW,common["SEVERITY_COLORS"].WARNING,common["SEVERITY_COLORS"].MINOR,common["SEVERITY_COLORS"].MAJOR,common["SEVERITY_COLORS"].CRITICAL],data:swimLanePoints,xAccessor:"time",yAccessor:"laneLabel",valueAccessor:"value",highlightedData:highlightedData,valueFormatter:anomaly_utils["f"],xScaleType:"time",ySortPredicate:"dataIndex",config:swimLaneConfig})),isLoading&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{textAlign:"center",style:{position:"absolute",top:"50%",left:"50%",transform:"translate(-50%,-50%)"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl",mono:true,"data-test-subj":"mlSwimLaneLoadingIndicator"})),!isLoading&&!showSwimlane&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{titleSize:"xs",style:{padding:0},title:external_kbnSharedDeps_React_default.a.createElement("h2",null,noDataWarning)}))),isPaginationVisible&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(SwimLanePagination,{cardinality:swimlaneLimit,fromPage:fromPage,perPage:perPage,onPaginationChange:onPaginationChange}))))}},157:function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;
/*!
  Copyright (c) 2017 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/(function(){"use strict";var hasOwn={}.hasOwnProperty;function classNames(){var classes=[];for(var i=0;i<arguments.length;i++){var arg=arguments[i];if(!arg)continue;var argType=typeof arg;if(argType==="string"||argType==="number"){classes.push(arg)}else if(Array.isArray(arg)&&arg.length){var inner=classNames.apply(null,arg);if(inner){classes.push(inner)}}else if(argType==="object"){for(var key in arg){if(hasOwn.call(arg,key)&&arg[key]){classes.push(key)}}}}return classes.join(" ")}if(true&&module.exports){classNames.default=classNames;module.exports=classNames}else if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return classNames}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})()},168:function(module,exports,__webpack_require__){"use strict";var keys=__webpack_require__(360);var hasSymbols=typeof Symbol==="function"&&typeof Symbol("foo")==="symbol";var toStr=Object.prototype.toString;var concat=Array.prototype.concat;var origDefineProperty=Object.defineProperty;var isFunction=function(fn){return typeof fn==="function"&&toStr.call(fn)==="[object Function]"};var arePropertyDescriptorsSupported=function(){var obj={};try{origDefineProperty(obj,"x",{enumerable:false,value:obj});for(var _ in obj){return false}return obj.x===obj}catch(e){return false}};var supportsDescriptors=origDefineProperty&&arePropertyDescriptorsSupported();var defineProperty=function(object,name,value,predicate){if(name in object&&(!isFunction(predicate)||!predicate())){return}if(supportsDescriptors){origDefineProperty(object,name,{configurable:true,enumerable:false,value:value,writable:true})}else{object[name]=value}};var defineProperties=function(object,map){var predicates=arguments.length>2?arguments[2]:{};var props=keys(map);if(hasSymbols){props=concat.call(props,Object.getOwnPropertySymbols(map))}for(var i=0;i<props.length;i+=1){defineProperty(object,props[i],map[props[i]],predicates[props[i]])}};defineProperties.supportsDescriptors=!!supportsDescriptors;module.exports=defineProperties},175:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return EMPTY_FIELD_VALUE_LABEL}));__webpack_require__.d(__webpack_exports__,"b",(function(){return entity_control_EntityControl}));var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var external_kbnSharedDeps_React_=__webpack_require__(10);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(34);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(33);var common=__webpack_require__(13);const EntityConfig=({entity:entity,isModelPlotEnabled:isModelPlotEnabled,config:config,onConfigChange:onConfigChange})=>{var _config$sort,_config$sort2;const[isEntityConfigPopoverOpen,setIsEntityConfigPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const forceSortByName=isModelPlotEnabled&&!(config!==null&&config!==void 0&&config.anomalousOnly);const sortOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{id:"anomaly_score",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.sortByScoreLabel",{defaultMessage:"Anomaly score"}),disabled:forceSortByName},{id:"name",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.sortByNameLabel",{defaultMessage:"Name"})}],[isModelPlotEnabled,config]);const orderOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{id:"asc",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.ascOptionsOrderLabel",{defaultMessage:"asc"})},{id:"desc",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.descOptionsOrderLabel",{defaultMessage:"desc"})}],[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:true,style:{height:"40px"},button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{color:"text",iconSize:"m",iconType:"gear","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.editControlConfiguration",{defaultMessage:"Edit field configuration"}),onClick:()=>{setIsEntityConfigPopoverOpen(!isEntityConfigPopoverOpen)},"data-test-subj":`mlSingleMetricViewerEntitySelectionConfigButton_${entity.fieldName}`}),isOpen:isEntityConfigPopoverOpen,closePopover:()=>{setIsEntityConfigPopoverOpen(false)}},external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":`mlSingleMetricViewerEntitySelectionConfigPopover_${entity.fieldName}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.sortByLabel",defaultMessage:"Sort by"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{options:sortOptions,idSelected:forceSortByName?"name":config===null||config===void 0?void 0:(_config$sort=config.sort)===null||_config$sort===void 0?void 0:_config$sort.by,onChange:id=>{onConfigChange(entity.fieldType,{sort:{order:config.sort.order,by:id}})},compressed:true,"data-test-subj":`mlSingleMetricViewerEntitySelectionConfigSortBy_${entity.fieldName}`})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.orderLabel",defaultMessage:"Order"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{options:orderOptions,idSelected:config===null||config===void 0?void 0:(_config$sort2=config.sort)===null||_config$sort2===void 0?void 0:_config$sort2.order,onChange:id=>{onConfigChange(entity.fieldType,{sort:{by:config.sort.by,order:id}})},compressed:true,"data-test-subj":`mlSingleMetricViewerEntitySelectionConfigOrder_${entity.fieldName}`})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},isModelPlotEnabled?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.anomalousOnlyLabel",defaultMessage:"Anomalous only"}),checked:config.anomalousOnly,onChange:e=>{const isAnomalousOnly=e.target.checked;onConfigChange(entity.fieldType,{anomalousOnly:isAnomalousOnly,sort:{order:config.sort.order,by:config.sort.by}})},compressed:true,"data-test-subj":`mlSingleMetricViewerEntitySelectionConfigAnomalousOnly_${entity.fieldName}`}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.applyTimeRangeLabel",defaultMessage:"Apply time range"}),checked:config.applyTimeRange,onChange:e=>{const applyTimeRange=e.target.checked;onConfigChange(entity.fieldType,{applyTimeRange:applyTimeRange})},compressed:true,"data-test-subj":`mlSingleMetricViewerEntitySelectionConfigAnomalousOnly_${entity.fieldName}`})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{width:"16px"}},isModelPlotEnabled&&!(config!==null&&config!==void 0&&config.anomalousOnly)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.nonAnomalousResultsWithModelPlotInfo",defaultMessage:"The list contains values from the model plot results."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{tabIndex:0,type:"iInCircle",color:"subdued"})):null,!isModelPlotEnabled&&!(config!==null&&config!==void 0&&config.applyTimeRange)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.ignoreTimeRangeInfo",defaultMessage:"The list contains values from all anomalies created during the lifetime of the job."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{tabIndex:0,type:"iInCircle",color:"subdued"})):null))))};function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const EMPTY_FIELD_VALUE_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.emptyPartitionFieldLabel.",{defaultMessage:'"" (empty string)'});class entity_control_EntityControl extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);_defineProperty(this,"inputRef",void 0);_defineProperty(this,"state",{selectedOptions:undefined,options:undefined,isLoading:false,isEntityConfigPopoverOpen:false});_defineProperty(this,"onChange",selectedOptions=>{var _options$0$value,_options$0$value$valu,_options$0$value2;const options=selectedOptions.length>0?selectedOptions:undefined;this.setState({selectedOptions:options});const fieldValue=Array.isArray(options)&&((_options$0$value=options[0].value)===null||_options$0$value===void 0?void 0:_options$0$value.value)!==null?(_options$0$value$valu=(_options$0$value2=options[0].value)===null||_options$0$value2===void 0?void 0:_options$0$value2.value)!==null&&_options$0$value$valu!==void 0?_options$0$value$valu:null:null;this.props.entityFieldValueChanged(this.props.entity,fieldValue)});_defineProperty(this,"onManualInput",inputValue=>{const normalizedSearchValue=inputValue.trim().toLowerCase();if(!normalizedSearchValue){return}const manualInputValue={label:inputValue,value:{value:inputValue}};this.setState({selectedOptions:[manualInputValue]});this.props.entityFieldValueChanged(this.props.entity,inputValue)});_defineProperty(this,"onSearchChange",searchValue=>{this.setState({isLoading:true,options:[]});this.props.onSearchChange(this.props.entity,searchValue)});_defineProperty(this,"renderOption",(option,searchValue)=>{var _option$value;const highlightedLabel=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHighlight"],{search:searchValue},option.label);return(_option$value=option.value)!==null&&_option$value!==void 0&&_option$value.maxRecordScore?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:Object(common["getSeverityColor"])(option.value.maxRecordScore)},highlightedLabel):highlightedLabel})}componentDidUpdate(prevProps){const{entity:entity,forceSelection:forceSelection,isLoading:isLoading,options:propOptions}=this.props;const{options:stateOptions,selectedOptions:selectedOptions}=this.state;const{fieldValue:fieldValue}=entity;let selectedOptionsUpdate=selectedOptions;if(selectedOptions===undefined&&fieldValue!==null||Array.isArray(selectedOptions)&&selectedOptions[0].value!==fieldValue&&fieldValue!==null){selectedOptionsUpdate=[{label:fieldValue===""?EMPTY_FIELD_VALUE_LABEL:fieldValue,value:fieldValue}]}else if(Array.isArray(selectedOptions)&&fieldValue===null){selectedOptionsUpdate=undefined}if(prevProps.isLoading===true&&isLoading===false){this.setState({isLoading:false,selectedOptions:selectedOptionsUpdate})}if(!Object(external_kbnSharedDeps_Lodash_["isEqual"])(propOptions,stateOptions)){this.setState({options:propOptions})}if(forceSelection&&this.inputRef){this.inputRef.focus()}}render(){const{entity:entity,forceSelection:forceSelection,isModelPlotEnabled:isModelPlotEnabled,config:config,onConfigChange:onConfigChange}=this.props;const{isLoading:isLoading,options:options,selectedOptions:selectedOptions}=this.state;const control=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{async:true,isLoading:isLoading,inputRef:input=>{if(input){this.inputRef=input}},style:{minWidth:"300px"},placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.enterValuePlaceholder",{defaultMessage:"Enter value"}),singleSelection:{asPlainText:true},onCreateOption:this.onManualInput,customOptionText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesExplorer.setManualInputHelperText",{defaultMessage:"No matching values"}),options:options,selectedOptions:selectedOptions,onChange:this.onChange,onSearchChange:this.onSearchChange,isClearable:false,renderOption:this.renderOption,"data-test-subj":`mlSingleMetricViewerEntitySelection ${entity.fieldName}`,prepend:external_kbnSharedDeps_React_default.a.createElement(EntityConfig,{entity:entity,isModelPlotEnabled:isModelPlotEnabled,config:config,onConfigChange:onConfigChange})});const selectMessage=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.timeSeriesExplorer.selectFieldMessage",defaultMessage:"Select {fieldName}",values:{fieldName:entity.fieldName}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:entity.fieldName,helpText:forceSelection?selectMessage:null},control))}}},210:function(module,exports){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}module.exports=_interopRequireDefault},211:function(module,exports,__webpack_require__){var _typeof=__webpack_require__(723);function _getRequireWildcardCache(){if(typeof WeakMap!=="function")return null;var cache=new WeakMap;_getRequireWildcardCache=function _getRequireWildcardCache(){return cache};return cache}function _interopRequireWildcard(obj){if(obj&&obj.__esModule){return obj}if(obj===null||_typeof(obj)!=="object"&&typeof obj!=="function"){return{default:obj}}var cache=_getRequireWildcardCache();if(cache&&cache.has(obj)){return cache.get(obj)}var newObj={};var hasPropertyDescriptor=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var key in obj){if(Object.prototype.hasOwnProperty.call(obj,key)){var desc=hasPropertyDescriptor?Object.getOwnPropertyDescriptor(obj,key):null;if(desc&&(desc.get||desc.set)){Object.defineProperty(newObj,key,desc)}else{newObj[key]=obj[key]}}}newObj["default"]=obj;if(cache){cache.set(obj,newObj)}return newObj}module.exports=_interopRequireWildcard},251:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ChartTooltipService}));var rxjs__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(19);var rxjs__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(5);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);var rxjs_operators__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(21);var rxjs_operators__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(rxjs_operators__WEBPACK_IMPORTED_MODULE_2__);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const getChartTooltipDefaultState=()=>({isTooltipVisible:false,tooltipData:[],offset:{x:0,y:0},target:null});class ChartTooltipService{constructor(){_defineProperty(this,"chartTooltip$",new rxjs__WEBPACK_IMPORTED_MODULE_0__["BehaviorSubject"](getChartTooltipDefaultState()));_defineProperty(this,"tooltipState$",this.chartTooltip$.asObservable().pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_2__["distinctUntilChanged"])(lodash__WEBPACK_IMPORTED_MODULE_1__["isEqual"])))}show(tooltipData,target,offset={x:0,y:0}){if(!target){throw new Error("target is required for the tooltip positioning")}this.chartTooltip$.next({...this.chartTooltip$.getValue(),isTooltipVisible:true,offset:offset,tooltipData:tooltipData,target:target})}hide(){this.chartTooltip$.next({...getChartTooltipDefaultState(),isTooltipVisible:false})}}},252:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return FormattedTooltip}));__webpack_require__.d(__webpack_exports__,"b",(function(){return MlTooltipComponent}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(10);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var classnames__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(157);var classnames__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);var react_popper_tooltip__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(714);var react_popper_tooltip__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_popper_tooltip__WEBPACK_IMPORTED_MODULE_2__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(33);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__);var _index_scss__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(705);var _index_scss__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(_index_scss__WEBPACK_IMPORTED_MODULE_4__);var _chart_tooltip_service__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(251);const renderHeader=(headerData,formatter)=>{if(!headerData){return null}return formatter?formatter(headerData):headerData.label};const FormattedTooltip=({tooltipData:tooltipData})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{className:"mlChartTooltip"},tooltipData.length>0&&tooltipData[0].skipHeader===undefined&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{className:"mlChartTooltip__header"},renderHeader(tooltipData[0])),tooltipData.length>1&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{className:"mlChartTooltip__list"},tooltipData.slice(1).map(({label:label,value:value,color:color,isHighlighted:isHighlighted,seriesIdentifier:seriesIdentifier,valueAccessor:valueAccessor})=>{const classes=classnames__WEBPACK_IMPORTED_MODULE_1___default()("mlChartTooltip__item",{echTooltip__rowHighlighted:isHighlighted});const renderValue=Array.isArray(value)?value.map(v=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{key:v},v)):value;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{key:`${seriesIdentifier.key}__${valueAccessor}`,className:classes,style:{borderLeftColor:color}},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiFlexGroup"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiFlexItem"],{className:"eui-textBreakWord mlChartTooltip__label",grow:false},label),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiFlexItem"],{className:"eui-textBreakAll mlChartTooltip__value"},renderValue)))})));const Tooltip=react__WEBPACK_IMPORTED_MODULE_0___default.a.memo(({service:service})=>{const[tooltipData,setData]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])([]);const refCallback=Object(react__WEBPACK_IMPORTED_MODULE_0__["useRef"])();Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{const subscription=service.tooltipState$.subscribe(tooltipState=>{if(refCallback.current&&typeof refCallback.current==="function"){refCallback.current(tooltipState.target)}setData(tooltipState.tooltipData)});return()=>{subscription.unsubscribe()}},[]);const triggerCallback=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(({triggerRef:triggerRef})=>{refCallback.current=triggerRef;return null},[]);const tooltipCallback=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(({tooltipRef:tooltipRef,getTooltipProps:getTooltipProps})=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",getTooltipProps({ref:tooltipRef}),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(FormattedTooltip,{tooltipData:tooltipData})),[tooltipData]);const isTooltipShown=tooltipData.length>0;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react_popper_tooltip__WEBPACK_IMPORTED_MODULE_2___default.a,{modifiers:{preventOverflow:{boundariesElement:"window"}},placement:"right-start",trigger:"none",tooltipShown:isTooltipShown,tooltip:tooltipCallback},triggerCallback)});const MlTooltipComponent=({children:children})=>{const service=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>new _chart_tooltip_service__WEBPACK_IMPORTED_MODULE_5__["a"],[]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Tooltip,{service:service}),children(service))}},253:function(module,exports){function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return self}module.exports=_assertThisInitialized},254:function(module,exports){function _inheritsLoose(subClass,superClass){subClass.prototype=Object.create(superClass.prototype);subClass.prototype.constructor=subClass;subClass.__proto__=superClass}module.exports=_inheritsLoose},255:function(module,exports){function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}module.exports=_defineProperty},256:function(module,exports,__webpack_require__){"use strict";var _interopRequireWildcard=__webpack_require__(211);var _interopRequireDefault=__webpack_require__(210);Object.defineProperty(exports,"__esModule",{value:true});exports.default=exports.ManagerReferenceNodeSetterContext=exports.ManagerReferenceNodeContext=void 0;var _assertThisInitialized2=_interopRequireDefault(__webpack_require__(253));var _inheritsLoose2=_interopRequireDefault(__webpack_require__(254));var _defineProperty2=_interopRequireDefault(__webpack_require__(255));var React=_interopRequireWildcard(__webpack_require__(10));var _createReactContext=_interopRequireDefault(__webpack_require__(739));var ManagerReferenceNodeContext=(0,_createReactContext.default)();exports.ManagerReferenceNodeContext=ManagerReferenceNodeContext;var ManagerReferenceNodeSetterContext=(0,_createReactContext.default)();exports.ManagerReferenceNodeSetterContext=ManagerReferenceNodeSetterContext;var Manager=function(_React$Component){(0,_inheritsLoose2.default)(Manager,_React$Component);function Manager(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_React$Component.call.apply(_React$Component,[this].concat(args))||this;(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"referenceNode",void 0);(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"setReferenceNode",(function(newReferenceNode){if(newReferenceNode&&_this.referenceNode!==newReferenceNode){_this.referenceNode=newReferenceNode;_this.forceUpdate()}}));return _this}var _proto=Manager.prototype;_proto.componentWillUnmount=function componentWillUnmount(){this.referenceNode=null};_proto.render=function render(){return React.createElement(ManagerReferenceNodeContext.Provider,{value:this.referenceNode},React.createElement(ManagerReferenceNodeSetterContext.Provider,{value:this.setReferenceNode},this.props.children))};return Manager}(React.Component);exports.default=Manager},359:function(module,exports){function _extends(){module.exports=_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}module.exports=_extends},360:function(module,exports,__webpack_require__){"use strict";var slice=Array.prototype.slice;var isArgs=__webpack_require__(361);var origKeys=Object.keys;var keysShim=origKeys?function keys(o){return origKeys(o)}:__webpack_require__(727);var originalKeys=Object.keys;keysShim.shim=function shimObjectKeys(){if(Object.keys){var keysWorksWithArguments=function(){var args=Object.keys(arguments);return args&&args.length===arguments.length}(1,2);if(!keysWorksWithArguments){Object.keys=function keys(object){if(isArgs(object)){return originalKeys(slice.call(object))}return originalKeys(object)}}}else{Object.keys=keysShim}return Object.keys||keysShim};module.exports=keysShim},361:function(module,exports,__webpack_require__){"use strict";var toStr=Object.prototype.toString;module.exports=function isArguments(value){var str=toStr.call(value);var isArgs=str==="[object Arguments]";if(!isArgs){isArgs=str!=="[object Array]"&&value!==null&&typeof value==="object"&&typeof value.length==="number"&&value.length>=0&&toStr.call(value.callee)==="[object Function]"}return isArgs}},362:function(module,exports,__webpack_require__){"use strict";var bind=__webpack_require__(363);var GetIntrinsic=__webpack_require__(731);var $apply=GetIntrinsic("%Function.prototype.apply%");var $call=GetIntrinsic("%Function.prototype.call%");var $reflectApply=GetIntrinsic("%Reflect.apply%",true)||bind.call($call,$apply);module.exports=function callBind(){return $reflectApply(bind,$call,arguments)};module.exports.apply=function applyBind(){return $reflectApply(bind,$apply,arguments)}},363:function(module,exports,__webpack_require__){"use strict";var implementation=__webpack_require__(730);module.exports=Function.prototype.bind||implementation},364:function(module,exports,__webpack_require__){"use strict";(function(global){var origSymbol=global.Symbol;var hasSymbolSham=__webpack_require__(732);module.exports=function hasNativeSymbols(){if(typeof origSymbol!=="function"){return false}if(typeof Symbol!=="function"){return false}if(typeof origSymbol("foo")!=="symbol"){return false}if(typeof Symbol("bar")!=="symbol"){return false}return hasSymbolSham()}}).call(this,__webpack_require__(106))},365:function(module,exports,__webpack_require__){"use strict";var numberIsNaN=function(value){return value!==value};module.exports=function is(a,b){if(a===0&&b===0){return 1/a===1/b}if(a===b){return true}if(numberIsNaN(a)&&numberIsNaN(b)){return true}return false}},366:function(module,exports,__webpack_require__){"use strict";var implementation=__webpack_require__(365);module.exports=function getPolyfill(){return typeof Object.is==="function"?Object.is:implementation}},367:function(module,exports,__webpack_require__){"use strict";var $Object=Object;var $TypeError=TypeError;module.exports=function flags(){if(this!=null&&this!==$Object(this)){throw new $TypeError("RegExp.prototype.flags getter called on non-object")}var result="";if(this.global){result+="g"}if(this.ignoreCase){result+="i"}if(this.multiline){result+="m"}if(this.dotAll){result+="s"}if(this.unicode){result+="u"}if(this.sticky){result+="y"}return result}},368:function(module,exports,__webpack_require__){"use strict";var implementation=__webpack_require__(367);var supportsDescriptors=__webpack_require__(168).supportsDescriptors;var $gOPD=Object.getOwnPropertyDescriptor;var $TypeError=TypeError;module.exports=function getPolyfill(){if(!supportsDescriptors){throw new $TypeError("RegExp.prototype.flags requires a true ES5 environment that supports property descriptors")}if(/a/gim.flags==="gim"){var descriptor=$gOPD(RegExp.prototype,"flags");if(descriptor&&typeof descriptor.get==="function"&&typeof/a/.dotAll==="boolean"){return descriptor.get}}return implementation}},369:function(module,exports,__webpack_require__){"use strict";var __DEV__="production"!=="production";var warning=function(){};if(__DEV__){var printWarning=function printWarning(format,args){var len=arguments.length;args=new Array(len>1?len-1:0);for(var key=1;key<len;key++){args[key-1]=arguments[key]}var argIndex=0;var message="Warning: "+format.replace(/%s/g,(function(){return args[argIndex++]}));if(typeof console!=="undefined"){console.error(message)}try{throw new Error(message)}catch(x){}};warning=function(condition,format,args){var len=arguments.length;args=new Array(len>2?len-2:0);for(var key=2;key<len;key++){args[key-2]=arguments[key]}if(format===undefined){throw new Error("`warning(condition, format, ...args)` requires a warning "+"message argument")}if(!condition){printWarning.apply(null,[format].concat(args))}}}module.exports=warning},370:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.setRef=exports.shallowEqual=exports.safeInvoke=exports.unwrapArray=void 0;var unwrapArray=function unwrapArray(arg){return Array.isArray(arg)?arg[0]:arg};exports.unwrapArray=unwrapArray;var safeInvoke=function safeInvoke(fn){if(typeof fn==="function"){for(var _len=arguments.length,args=new Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){args[_key-1]=arguments[_key]}return fn.apply(void 0,args)}};exports.safeInvoke=safeInvoke;var shallowEqual=function shallowEqual(objA,objB){var aKeys=Object.keys(objA);var bKeys=Object.keys(objB);if(bKeys.length!==aKeys.length){return false}for(var i=0;i<bKeys.length;i++){var key=aKeys[i];if(objA[key]!==objB[key]){return false}}return true};exports.shallowEqual=shallowEqual;var setRef=function setRef(ref,node){if(typeof ref==="function"){return safeInvoke(ref,node)}else if(ref!=null){ref.current=node}};exports.setRef=setRef},455:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret=__webpack_require__(456);function emptyFunction(){}function emptyFunctionWithReset(){}emptyFunctionWithReset.resetWarningCache=emptyFunction;module.exports=function(){function shim(props,propName,componentName,location,propFullName,secret){if(secret===ReactPropTypesSecret){return}var err=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use PropTypes.checkPropTypes() to call them. "+"Read more at http://fb.me/use-check-prop-types");err.name="Invariant Violation";throw err}shim.isRequired=shim;function getShim(){return shim}var ReactPropTypes={array:shim,bool:shim,func:shim,number:shim,object:shim,string:shim,symbol:shim,any:shim,arrayOf:getShim,element:shim,elementType:shim,instanceOf:getShim,node:shim,objectOf:getShim,oneOf:getShim,oneOfType:getShim,shape:getShim,exact:getShim,checkPropTypes:emptyFunctionWithReset,resetWarningCache:emptyFunction};ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}},456:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},67:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return formatHumanReadableDate}));__webpack_require__.d(__webpack_exports__,"b",(function(){return formatHumanReadableDateTime}));__webpack_require__.d(__webpack_exports__,"c",(function(){return formatHumanReadableDateTimeSeconds}));__webpack_require__.d(__webpack_exports__,"e",(function(){return validateTimeRange}));__webpack_require__.d(__webpack_exports__,"d",(function(){return timeFormatter}));var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(26);var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_datemath__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(33);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _constants_time_format__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(116);function formatHumanReadableDate(ts){return Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["formatDate"])(ts,"MMMM Do YYYY")}function formatHumanReadableDateTime(ts){return Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["formatDate"])(ts,"MMMM Do YYYY, HH:mm")}function formatHumanReadableDateTimeSeconds(ts){return Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["formatDate"])(ts,"MMMM Do YYYY, HH:mm:ss")}function validateTimeRange(time){if(!time)return false;const momentDateFrom=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(time.from);const momentDateTo=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(time.to);return!!(momentDateFrom&&momentDateFrom.isValid()&&momentDateTo&&momentDateTo.isValid())}const timeFormatter=value=>Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["formatDate"])(value,_constants_time_format__WEBPACK_IMPORTED_MODULE_2__["a"])},705:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(706);case"v7light":return __webpack_require__(708);case"v8dark":return __webpack_require__(710);case"v8light":return __webpack_require__(712)}},706:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(707);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},707:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlChartTooltip {\n  box-shadow: 0 12px 24px 0 rgba(0, 0, 0, 0.1), 0 6px 12px 0 rgba(0, 0, 0, 0.1), 0 4px 4px 0 rgba(0, 0, 0, 0.1), 0 2px 2px 0 rgba(0, 0, 0, 0.1);\n  border-radius: 4px;\n  background-color: black;\n  color: #FFF;\n  z-index: 9000;\n  max-width: 256px;\n  overflow-wrap: break-word;\n  font-size: 12px;\n  font-size: 0.75rem;\n  line-height: 1.5;\n  padding: 8px;\n  font-size: 12px;\n  font-size: 0.75rem;\n  line-height: 1.5;\n  padding: 0;\n  transition: opacity 250ms;\n  pointer-events: none;\n  -webkit-user-select: none;\n          user-select: none;\n  max-width: 512px; }\n  .mlChartTooltip__list {\n    margin: 4px; }\n  .mlChartTooltip__header {\n    font-weight: 700;\n    border-bottom: solid 1px #333333;\n    padding-bottom: 4px;\n    margin-bottom: 4px;\n    padding: 4px 8px; }\n  .mlChartTooltip__item {\n    display: flex;\n    padding: 3px;\n    box-sizing: border-box;\n    border-left: 4px solid transparent; }\n  .mlChartTooltip__label {\n    min-width: 1px; }\n  .mlChartTooltip__value {\n    font-weight: 700;\n    text-align: right;\n    font-feature-settings: 'tnum';\n    margin-left: 8px; }\n  .mlChartTooltip__rowHighlighted {\n    background-color: rgba(255, 255, 255, 0.1); }\n  .mlChartTooltip--hidden {\n    opacity: 0; }\n",""]);module.exports=exports},708:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(709);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},709:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlChartTooltip {\n  box-shadow: 0 12px 24px 0 rgba(0, 0, 0, 0.1), 0 6px 12px 0 rgba(0, 0, 0, 0.1), 0 4px 4px 0 rgba(0, 0, 0, 0.1), 0 2px 2px 0 rgba(0, 0, 0, 0.1);\n  border-radius: 4px;\n  background-color: #404040;\n  color: #FFF;\n  z-index: 9000;\n  max-width: 256px;\n  overflow-wrap: break-word;\n  font-size: 12px;\n  font-size: 0.75rem;\n  line-height: 1.5;\n  padding: 8px;\n  font-size: 12px;\n  font-size: 0.75rem;\n  line-height: 1.5;\n  padding: 0;\n  transition: opacity 250ms;\n  pointer-events: none;\n  -webkit-user-select: none;\n          user-select: none;\n  max-width: 512px; }\n  .mlChartTooltip__list {\n    margin: 4px; }\n  .mlChartTooltip__header {\n    font-weight: 700;\n    border-bottom: solid 1px #595959;\n    padding-bottom: 4px;\n    margin-bottom: 4px;\n    padding: 4px 8px; }\n  .mlChartTooltip__item {\n    display: flex;\n    padding: 3px;\n    box-sizing: border-box;\n    border-left: 4px solid transparent; }\n  .mlChartTooltip__label {\n    min-width: 1px; }\n  .mlChartTooltip__value {\n    font-weight: 700;\n    text-align: right;\n    font-feature-settings: 'tnum';\n    margin-left: 8px; }\n  .mlChartTooltip__rowHighlighted {\n    background-color: rgba(255, 255, 255, 0.1); }\n  .mlChartTooltip--hidden {\n    opacity: 0; }\n",""]);module.exports=exports},710:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(711);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},711:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlChartTooltip {\n  box-shadow: 0 1px 5px rgba(0, 0, 0, 0.25), 0 3.6px 13px rgba(0, 0, 0, 0.175), 0 8.4px 23px rgba(0, 0, 0, 0.15), 0 23px 35px rgba(0, 0, 0, 0.125);\n  border-radius: 6px;\n  background-color: black;\n  color: #FFF;\n  z-index: 9000;\n  max-width: 256px;\n  overflow-wrap: break-word;\n  font-size: 12px;\n  font-size: 0.85714rem;\n  line-height: 1.14286rem;\n  padding: 8px;\n  font-size: 12px;\n  font-size: 0.85714rem;\n  line-height: 1.14286rem;\n  padding: 0;\n  transition: opacity 250ms;\n  pointer-events: none;\n  -webkit-user-select: none;\n          user-select: none;\n  max-width: 512px; }\n  .mlChartTooltip__list {\n    margin: 4px; }\n  .mlChartTooltip__header {\n    font-weight: 700;\n    border-bottom: solid 1px #333333;\n    padding-bottom: 4px;\n    margin-bottom: 4px;\n    padding: 4px 8px; }\n  .mlChartTooltip__item {\n    display: flex;\n    padding: 3px;\n    box-sizing: border-box;\n    border-left: 4px solid transparent; }\n  .mlChartTooltip__label {\n    min-width: 1px; }\n  .mlChartTooltip__value {\n    font-weight: 700;\n    text-align: right;\n    font-feature-settings: 'tnum';\n    margin-left: 8px; }\n  .mlChartTooltip__rowHighlighted {\n    background-color: rgba(255, 255, 255, 0.1); }\n  .mlChartTooltip--hidden {\n    opacity: 0; }\n",""]);module.exports=exports},712:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(713);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},713:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlChartTooltip {\n  box-shadow: 0 1px 5px rgba(0, 0, 0, 0.1), 0 3.6px 13px rgba(0, 0, 0, 0.07), 0 8.4px 23px rgba(0, 0, 0, 0.06), 0 23px 35px rgba(0, 0, 0, 0.05);\n  border-radius: 6px;\n  background-color: #404040;\n  color: #FFF;\n  z-index: 9000;\n  max-width: 256px;\n  overflow-wrap: break-word;\n  font-size: 12px;\n  font-size: 0.85714rem;\n  line-height: 1.14286rem;\n  padding: 8px;\n  font-size: 12px;\n  font-size: 0.85714rem;\n  line-height: 1.14286rem;\n  padding: 0;\n  transition: opacity 250ms;\n  pointer-events: none;\n  -webkit-user-select: none;\n          user-select: none;\n  max-width: 512px; }\n  .mlChartTooltip__list {\n    margin: 4px; }\n  .mlChartTooltip__header {\n    font-weight: 700;\n    border-bottom: solid 1px #595959;\n    padding-bottom: 4px;\n    margin-bottom: 4px;\n    padding: 4px 8px; }\n  .mlChartTooltip__item {\n    display: flex;\n    padding: 3px;\n    box-sizing: border-box;\n    border-left: 4px solid transparent; }\n  .mlChartTooltip__label {\n    min-width: 1px; }\n  .mlChartTooltip__value {\n    font-weight: 700;\n    text-align: right;\n    font-feature-settings: 'tnum';\n    margin-left: 8px; }\n  .mlChartTooltip__rowHighlighted {\n    background-color: rgba(255, 255, 255, 0.1); }\n  .mlChartTooltip--hidden {\n    opacity: 0; }\n",""]);module.exports=exports},714:function(module,exports,__webpack_require__){"use strict";var _objectWithoutPropertiesLoose=__webpack_require__(715);var _extends=__webpack_require__(716);__webpack_require__(717);__webpack_require__(720);var _inheritsLoose=__webpack_require__(721);var React=__webpack_require__(10);var reactDom=__webpack_require__(46);var reactPopper=__webpack_require__(722);var TooltipContext=React.createContext({});var callAll=function callAll(){for(var _len=arguments.length,fns=new Array(_len),_key=0;_key<_len;_key++){fns[_key]=arguments[_key]}return function(){for(var _len2=arguments.length,args=new Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}return fns.forEach((function(fn){return fn&&fn.apply(void 0,args)}))}};var noop=function noop(){};var canUseDOM=function canUseDOM(){return!!(typeof window!=="undefined"&&window.document&&window.document.createElement)};var setRef=function setRef(ref,node){if(typeof ref==="function"){return ref(node)}else if(ref!=null){ref.current=node}};var Tooltip=function(_Component){_inheritsLoose(Tooltip,_Component);function Tooltip(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_Component.call.apply(_Component,[this].concat(args))||this;_this.observer=void 0;_this.tooltipRef=void 0;_this.handleOutsideClick=function(event){if(_this.tooltipRef&&!_this.tooltipRef.contains(event.target)){var parentOutsideClickHandler=_this.context.parentOutsideClickHandler;var _this$props=_this.props,hideTooltip=_this$props.hideTooltip,clearScheduled=_this$props.clearScheduled;clearScheduled();hideTooltip();if(parentOutsideClickHandler){parentOutsideClickHandler(event)}}};_this.handleOutsideRightClick=function(event){if(_this.tooltipRef&&!_this.tooltipRef.contains(event.target)){var parentOutsideRightClickHandler=_this.context.parentOutsideRightClickHandler;var _this$props2=_this.props,hideTooltip=_this$props2.hideTooltip,clearScheduled=_this$props2.clearScheduled;clearScheduled();hideTooltip();if(parentOutsideRightClickHandler){parentOutsideRightClickHandler(event)}}};_this.addOutsideClickHandler=function(){document.body.addEventListener("touchend",_this.handleOutsideClick);document.body.addEventListener("click",_this.handleOutsideClick)};_this.removeOutsideClickHandler=function(){document.body.removeEventListener("touchend",_this.handleOutsideClick);document.body.removeEventListener("click",_this.handleOutsideClick)};_this.addOutsideRightClickHandler=function(){return document.body.addEventListener("contextmenu",_this.handleOutsideRightClick)};_this.removeOutsideRightClickHandler=function(){return document.body.removeEventListener("contextmenu",_this.handleOutsideRightClick)};_this.getTooltipRef=function(node){_this.tooltipRef=node;setRef(_this.props.innerRef,node)};_this.getArrowProps=function(props){if(props===void 0){props={}}return _extends({},props,{style:_extends({},props.style,{},_this.props.arrowProps.style)})};_this.getTooltipProps=function(props){if(props===void 0){props={}}return _extends({},props,{},_this.isTriggeredBy("hover")&&{onMouseEnter:callAll(_this.props.clearScheduled,props.onMouseEnter),onMouseLeave:callAll(_this.props.hideTooltip,props.onMouseLeave)},{style:_extends({},props.style,{},_this.props.style)})};_this.contextValue={isParentNoneTriggered:_this.props.trigger==="none",addParentOutsideClickHandler:_this.addOutsideClickHandler,addParentOutsideRightClickHandler:_this.addOutsideRightClickHandler,parentOutsideClickHandler:_this.handleOutsideClick,parentOutsideRightClickHandler:_this.handleOutsideRightClick,removeParentOutsideClickHandler:_this.removeOutsideClickHandler,removeParentOutsideRightClickHandler:_this.removeOutsideRightClickHandler};return _this}var _proto=Tooltip.prototype;_proto.componentDidMount=function componentDidMount(){var _this2=this;var observer=this.observer=new MutationObserver((function(){_this2.props.scheduleUpdate()}));observer.observe(this.tooltipRef,this.props.mutationObserverOptions);if(this.isTriggeredBy("hover")||this.isTriggeredBy("click")||this.isTriggeredBy("right-click")){var _this$context=this.context,removeParentOutsideClickHandler=_this$context.removeParentOutsideClickHandler,removeParentOutsideRightClickHandler=_this$context.removeParentOutsideRightClickHandler;this.addOutsideClickHandler();this.addOutsideRightClickHandler();if(removeParentOutsideClickHandler){removeParentOutsideClickHandler()}if(removeParentOutsideRightClickHandler){removeParentOutsideRightClickHandler()}}};_proto.componentDidUpdate=function componentDidUpdate(){if(this.props.closeOnOutOfBoundaries&&this.props.outOfBoundaries){this.props.hideTooltip()}};_proto.componentWillUnmount=function componentWillUnmount(){if(this.observer){this.observer.disconnect()}if(this.isTriggeredBy("hover")||this.isTriggeredBy("click")||this.isTriggeredBy("right-click")){var _this$context2=this.context,isParentNoneTriggered=_this$context2.isParentNoneTriggered,addParentOutsideClickHandler=_this$context2.addParentOutsideClickHandler,addParentOutsideRightClickHandler=_this$context2.addParentOutsideRightClickHandler;this.removeOutsideClickHandler();this.removeOutsideRightClickHandler();this.handleOutsideClick=undefined;this.handleOutsideRightClick=undefined;if(!isParentNoneTriggered&&addParentOutsideClickHandler){addParentOutsideClickHandler()}if(!isParentNoneTriggered&&addParentOutsideRightClickHandler){addParentOutsideRightClickHandler()}}};_proto.render=function render(){var _this$props3=this.props,arrowProps=_this$props3.arrowProps,placement=_this$props3.placement,tooltip=_this$props3.tooltip;return React.createElement(TooltipContext.Provider,{value:this.contextValue},tooltip({arrowRef:arrowProps.ref,getArrowProps:this.getArrowProps,getTooltipProps:this.getTooltipProps,placement:placement,tooltipRef:this.getTooltipRef}))};_proto.isTriggeredBy=function isTriggeredBy(event){var trigger=this.props.trigger;return trigger===event||Array.isArray(trigger)&&trigger.includes(event)};return Tooltip}(React.Component);Tooltip.contextType=TooltipContext;var DEFAULT_MODIFIERS={preventOverflow:{boundariesElement:"viewport"}};var DEFAULT_MUTATION_OBSERVER_CONFIG={childList:true,subtree:true};var TooltipTrigger=function(_Component){_inheritsLoose(TooltipTrigger,_Component);function TooltipTrigger(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_Component.call.apply(_Component,[this].concat(args))||this;_this.state={tooltipShown:_this.props.defaultTooltipShown};_this.hideTimeout=void 0;_this.showTimeout=void 0;_this.popperOffset=void 0;_this.setTooltipState=function(state){var cb=function cb(){return _this.props.onVisibilityChange(state.tooltipShown)};_this.isControlled()?cb():_this.setState(state,cb)};_this.clearScheduled=function(){clearTimeout(_this.hideTimeout);clearTimeout(_this.showTimeout)};_this.showTooltip=function(_ref){var pageX=_ref.pageX,pageY=_ref.pageY;_this.clearScheduled();var state={tooltipShown:true};if(_this.props.followCursor){state=_extends({},state,{pageX:pageX,pageY:pageY})}_this.showTimeout=window.setTimeout((function(){return _this.setTooltipState(state)}),_this.props.delayShow)};_this.hideTooltip=function(){_this.clearScheduled();_this.hideTimeout=window.setTimeout((function(){return _this.setTooltipState({tooltipShown:false})}),_this.props.delayHide)};_this.toggleTooltip=function(_ref2){var pageX=_ref2.pageX,pageY=_ref2.pageY;var action=_this.getState()?"hideTooltip":"showTooltip";_this[action]({pageX:pageX,pageY:pageY})};_this.clickToggle=function(event){event.preventDefault();var pageX=event.pageX,pageY=event.pageY;var action=_this.props.followCursor?"showTooltip":"toggleTooltip";_this[action]({pageX:pageX,pageY:pageY})};_this.contextMenuToggle=function(event){event.preventDefault();var pageX=event.pageX,pageY=event.pageY;var action=_this.props.followCursor?"showTooltip":"toggleTooltip";_this[action]({pageX:pageX,pageY:pageY})};_this.getTriggerProps=function(props){if(props===void 0){props={}}return _extends({},props,{},_this.isTriggeredBy("click")&&{onClick:callAll(_this.clickToggle,props.onClick),onTouchEnd:callAll(_this.clickToggle,props.onTouchEnd)},{},_this.isTriggeredBy("right-click")&&{onContextMenu:callAll(_this.contextMenuToggle,props.onContextMenu)},{},_this.isTriggeredBy("hover")&&_extends({onMouseEnter:callAll(_this.showTooltip,props.onMouseEnter),onMouseLeave:callAll(_this.hideTooltip,props.onMouseLeave)},_this.props.followCursor&&{onMouseMove:callAll(_this.showTooltip,props.onMouseMove)}),{},_this.isTriggeredBy("focus")&&{onFocus:callAll(_this.showTooltip,props.onFocus),onBlur:callAll(_this.hideTooltip,props.onBlur)})};return _this}var _proto=TooltipTrigger.prototype;_proto.componentWillUnmount=function componentWillUnmount(){this.clearScheduled()};_proto.render=function render(){var _this2=this;var _this$props=this.props,children=_this$props.children,tooltip=_this$props.tooltip,placement=_this$props.placement,trigger=_this$props.trigger,getTriggerRef=_this$props.getTriggerRef,modifiers=_this$props.modifiers,closeOnOutOfBoundaries=_this$props.closeOnOutOfBoundaries,usePortal=_this$props.usePortal,portalContainer=_this$props.portalContainer,followCursor=_this$props.followCursor,getTooltipRef=_this$props.getTooltipRef,mutationObserverOptions=_this$props.mutationObserverOptions,restProps=_objectWithoutPropertiesLoose(_this$props,["children","tooltip","placement","trigger","getTriggerRef","modifiers","closeOnOutOfBoundaries","usePortal","portalContainer","followCursor","getTooltipRef","mutationObserverOptions"]);var popper=React.createElement(reactPopper.Popper,_extends({innerRef:getTooltipRef,placement:placement,modifiers:_extends({},DEFAULT_MODIFIERS,{},followCursor&&{followCursorModifier:{enabled:true,fn:function fn(data){_this2.popperOffset=data.offsets.popper;return data},order:1e3}},{},modifiers)},restProps),(function(_ref3){var ref=_ref3.ref,style=_ref3.style,placement=_ref3.placement,arrowProps=_ref3.arrowProps,outOfBoundaries=_ref3.outOfBoundaries,scheduleUpdate=_ref3.scheduleUpdate;if(followCursor&&_this2.popperOffset){var _this2$state=_this2.state,pageX=_this2$state.pageX,pageY=_this2$state.pageY;var _this2$popperOffset=_this2.popperOffset,width=_this2$popperOffset.width,height=_this2$popperOffset.height;var x=pageX+width>window.scrollX+document.body.offsetWidth?pageX-width:pageX;var y=pageY+height>window.scrollY+document.body.offsetHeight?pageY-height:pageY;style.transform="translate3d("+x+"px, "+y+"px, 0"}return React.createElement(Tooltip,_extends({arrowProps:arrowProps,closeOnOutOfBoundaries:closeOnOutOfBoundaries,outOfBoundaries:outOfBoundaries,placement:placement,scheduleUpdate:scheduleUpdate,style:style,tooltip:tooltip,trigger:trigger,mutationObserverOptions:mutationObserverOptions},{clearScheduled:_this2.clearScheduled,hideTooltip:_this2.hideTooltip,innerRef:ref}))}));return React.createElement(reactPopper.Manager,null,React.createElement(reactPopper.Reference,{innerRef:getTriggerRef},(function(_ref4){var ref=_ref4.ref;return children({getTriggerProps:_this2.getTriggerProps,triggerRef:ref})})),this.getState()&&(usePortal?reactDom.createPortal(popper,portalContainer):popper))};_proto.isControlled=function isControlled(){return this.props.tooltipShown!==undefined};_proto.getState=function getState(){return this.isControlled()?this.props.tooltipShown:this.state.tooltipShown};_proto.isTriggeredBy=function isTriggeredBy(event){var trigger=this.props.trigger;return trigger===event||Array.isArray(trigger)&&trigger.includes(event)};return TooltipTrigger}(React.Component);TooltipTrigger.defaultProps={closeOnOutOfBoundaries:true,defaultTooltipShown:false,delayHide:0,delayShow:0,followCursor:false,onVisibilityChange:noop,placement:"right",portalContainer:canUseDOM()?document.body:null,trigger:"hover",usePortal:canUseDOM(),mutationObserverOptions:DEFAULT_MUTATION_OBSERVER_CONFIG};module.exports=TooltipTrigger},715:function(module,exports){function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}module.exports=_objectWithoutPropertiesLoose},716:function(module,exports){function _extends(){module.exports=_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}module.exports=_extends},717:function(module,exports,__webpack_require__){var _typeof=__webpack_require__(718);var assertThisInitialized=__webpack_require__(719);function _possibleConstructorReturn(self,call){if(call&&(_typeof(call)==="object"||typeof call==="function")){return call}return assertThisInitialized(self)}module.exports=_possibleConstructorReturn},718:function(module,exports){function _typeof(obj){"@babel/helpers - typeof";if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){module.exports=_typeof=function _typeof(obj){return typeof obj}}else{module.exports=_typeof=function _typeof(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj}}return _typeof(obj)}module.exports=_typeof},719:function(module,exports){function _assertThisInitialized(self){if(self===void 0){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return self}module.exports=_assertThisInitialized},720:function(module,exports){function _getPrototypeOf(o){module.exports=_getPrototypeOf=Object.setPrototypeOf?Object.getPrototypeOf:function _getPrototypeOf(o){return o.__proto__||Object.getPrototypeOf(o)};return _getPrototypeOf(o)}module.exports=_getPrototypeOf},721:function(module,exports){function _inheritsLoose(subClass,superClass){subClass.prototype=Object.create(superClass.prototype);subClass.prototype.constructor=subClass;subClass.__proto__=superClass}module.exports=_inheritsLoose},722:function(module,exports,__webpack_require__){"use strict";var _interopRequireDefault=__webpack_require__(210);var _interopRequireWildcard=__webpack_require__(211);Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"Popper",{enumerable:true,get:function get(){return _Popper.default}});Object.defineProperty(exports,"placements",{enumerable:true,get:function get(){return _Popper.placements}});Object.defineProperty(exports,"Manager",{enumerable:true,get:function get(){return _Manager.default}});Object.defineProperty(exports,"Reference",{enumerable:true,get:function get(){return _Reference.default}});var _Popper=_interopRequireWildcard(__webpack_require__(724));var _Manager=_interopRequireDefault(__webpack_require__(256));var _Reference=_interopRequireDefault(__webpack_require__(742))},723:function(module,exports){function _typeof(obj){"@babel/helpers - typeof";if(typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"){module.exports=_typeof=function _typeof(obj){return typeof obj}}else{module.exports=_typeof=function _typeof(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj}}return _typeof(obj)}module.exports=_typeof},724:function(module,exports,__webpack_require__){"use strict";var _interopRequireWildcard=__webpack_require__(211);var _interopRequireDefault=__webpack_require__(210);Object.defineProperty(exports,"__esModule",{value:true});exports.default=Popper;exports.placements=exports.InnerPopper=void 0;var _objectWithoutPropertiesLoose2=_interopRequireDefault(__webpack_require__(725));var _extends2=_interopRequireDefault(__webpack_require__(359));var _assertThisInitialized2=_interopRequireDefault(__webpack_require__(253));var _inheritsLoose2=_interopRequireDefault(__webpack_require__(254));var _defineProperty2=_interopRequireDefault(__webpack_require__(255));var _deepEqual=_interopRequireDefault(__webpack_require__(726));var React=_interopRequireWildcard(__webpack_require__(10));var _popper=_interopRequireDefault(__webpack_require__(738));var _Manager=__webpack_require__(256);var _utils=__webpack_require__(370);var initialStyle={position:"absolute",top:0,left:0,opacity:0,pointerEvents:"none"};var initialArrowStyle={};var InnerPopper=function(_React$Component){(0,_inheritsLoose2.default)(InnerPopper,_React$Component);function InnerPopper(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_React$Component.call.apply(_React$Component,[this].concat(args))||this;(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"state",{data:undefined,placement:undefined});(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"popperInstance",void 0);(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"popperNode",null);(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"arrowNode",null);(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"setPopperNode",(function(popperNode){if(!popperNode||_this.popperNode===popperNode)return;(0,_utils.setRef)(_this.props.innerRef,popperNode);_this.popperNode=popperNode;_this.updatePopperInstance()}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"setArrowNode",(function(arrowNode){_this.arrowNode=arrowNode}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"updateStateModifier",{enabled:true,order:900,fn:function fn(data){var placement=data.placement;_this.setState({data:data,placement:placement});return data}});(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"getOptions",(function(){return{placement:_this.props.placement,eventsEnabled:_this.props.eventsEnabled,positionFixed:_this.props.positionFixed,modifiers:(0,_extends2.default)({},_this.props.modifiers,{arrow:(0,_extends2.default)({},_this.props.modifiers&&_this.props.modifiers.arrow,{enabled:!!_this.arrowNode,element:_this.arrowNode}),applyStyle:{enabled:false},updateStateModifier:_this.updateStateModifier})}}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"getPopperStyle",(function(){return!_this.popperNode||!_this.state.data?initialStyle:(0,_extends2.default)({position:_this.state.data.offsets.popper.position},_this.state.data.styles)}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"getPopperPlacement",(function(){return!_this.state.data?undefined:_this.state.placement}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"getArrowStyle",(function(){return!_this.arrowNode||!_this.state.data?initialArrowStyle:_this.state.data.arrowStyles}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"getOutOfBoundariesState",(function(){return _this.state.data?_this.state.data.hide:undefined}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"destroyPopperInstance",(function(){if(!_this.popperInstance)return;_this.popperInstance.destroy();_this.popperInstance=null}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"updatePopperInstance",(function(){_this.destroyPopperInstance();var _assertThisInitialize=(0,_assertThisInitialized2.default)(_this),popperNode=_assertThisInitialize.popperNode;var referenceElement=_this.props.referenceElement;if(!referenceElement||!popperNode)return;_this.popperInstance=new _popper.default(referenceElement,popperNode,_this.getOptions())}));(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"scheduleUpdate",(function(){if(_this.popperInstance){_this.popperInstance.scheduleUpdate()}}));return _this}var _proto=InnerPopper.prototype;_proto.componentDidUpdate=function componentDidUpdate(prevProps,prevState){if(this.props.placement!==prevProps.placement||this.props.referenceElement!==prevProps.referenceElement||this.props.positionFixed!==prevProps.positionFixed||!(0,_deepEqual.default)(this.props.modifiers,prevProps.modifiers,{strict:true})){if(false){}this.updatePopperInstance()}else if(this.props.eventsEnabled!==prevProps.eventsEnabled&&this.popperInstance){this.props.eventsEnabled?this.popperInstance.enableEventListeners():this.popperInstance.disableEventListeners()}if(prevState.placement!==this.state.placement){this.scheduleUpdate()}};_proto.componentWillUnmount=function componentWillUnmount(){(0,_utils.setRef)(this.props.innerRef,null);this.destroyPopperInstance()};_proto.render=function render(){return(0,_utils.unwrapArray)(this.props.children)({ref:this.setPopperNode,style:this.getPopperStyle(),placement:this.getPopperPlacement(),outOfBoundaries:this.getOutOfBoundariesState(),scheduleUpdate:this.scheduleUpdate,arrowProps:{ref:this.setArrowNode,style:this.getArrowStyle()}})};return InnerPopper}(React.Component);exports.InnerPopper=InnerPopper;(0,_defineProperty2.default)(InnerPopper,"defaultProps",{placement:"bottom",eventsEnabled:true,referenceElement:undefined,positionFixed:false});var placements=_popper.default.placements;exports.placements=placements;function Popper(_ref){var referenceElement=_ref.referenceElement,props=(0,_objectWithoutPropertiesLoose2.default)(_ref,["referenceElement"]);return React.createElement(_Manager.ManagerReferenceNodeContext.Consumer,null,(function(referenceNode){return React.createElement(InnerPopper,(0,_extends2.default)({referenceElement:referenceElement!==undefined?referenceElement:referenceNode},props))}))}},725:function(module,exports){function _objectWithoutPropertiesLoose(source,excluded){if(source==null)return{};var target={};var sourceKeys=Object.keys(source);var key,i;for(i=0;i<sourceKeys.length;i++){key=sourceKeys[i];if(excluded.indexOf(key)>=0)continue;target[key]=source[key]}return target}module.exports=_objectWithoutPropertiesLoose},726:function(module,exports,__webpack_require__){var objectKeys=__webpack_require__(360);var isArguments=__webpack_require__(728);var is=__webpack_require__(729);var isRegex=__webpack_require__(734);var flags=__webpack_require__(735);var isDate=__webpack_require__(737);var getTime=Date.prototype.getTime;function deepEqual(actual,expected,options){var opts=options||{};if(opts.strict?is(actual,expected):actual===expected){return true}if(!actual||!expected||typeof actual!=="object"&&typeof expected!=="object"){return opts.strict?is(actual,expected):actual==expected}return objEquiv(actual,expected,opts)}function isUndefinedOrNull(value){return value===null||value===undefined}function isBuffer(x){if(!x||typeof x!=="object"||typeof x.length!=="number"){return false}if(typeof x.copy!=="function"||typeof x.slice!=="function"){return false}if(x.length>0&&typeof x[0]!=="number"){return false}return true}function objEquiv(a,b,opts){var i,key;if(typeof a!==typeof b){return false}if(isUndefinedOrNull(a)||isUndefinedOrNull(b)){return false}if(a.prototype!==b.prototype){return false}if(isArguments(a)!==isArguments(b)){return false}var aIsRegex=isRegex(a);var bIsRegex=isRegex(b);if(aIsRegex!==bIsRegex){return false}if(aIsRegex||bIsRegex){return a.source===b.source&&flags(a)===flags(b)}if(isDate(a)&&isDate(b)){return getTime.call(a)===getTime.call(b)}var aIsBuffer=isBuffer(a);var bIsBuffer=isBuffer(b);if(aIsBuffer!==bIsBuffer){return false}if(aIsBuffer||bIsBuffer){if(a.length!==b.length){return false}for(i=0;i<a.length;i++){if(a[i]!==b[i]){return false}}return true}if(typeof a!==typeof b){return false}try{var ka=objectKeys(a);var kb=objectKeys(b)}catch(e){return false}if(ka.length!==kb.length){return false}ka.sort();kb.sort();for(i=ka.length-1;i>=0;i--){if(ka[i]!=kb[i]){return false}}for(i=ka.length-1;i>=0;i--){key=ka[i];if(!deepEqual(a[key],b[key],opts)){return false}}return true}module.exports=deepEqual},727:function(module,exports,__webpack_require__){"use strict";var keysShim;if(!Object.keys){var has=Object.prototype.hasOwnProperty;var toStr=Object.prototype.toString;var isArgs=__webpack_require__(361);var isEnumerable=Object.prototype.propertyIsEnumerable;var hasDontEnumBug=!isEnumerable.call({toString:null},"toString");var hasProtoEnumBug=isEnumerable.call((function(){}),"prototype");var dontEnums=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"];var equalsConstructorPrototype=function(o){var ctor=o.constructor;return ctor&&ctor.prototype===o};var excludedKeys={$applicationCache:true,$console:true,$external:true,$frame:true,$frameElement:true,$frames:true,$innerHeight:true,$innerWidth:true,$onmozfullscreenchange:true,$onmozfullscreenerror:true,$outerHeight:true,$outerWidth:true,$pageXOffset:true,$pageYOffset:true,$parent:true,$scrollLeft:true,$scrollTop:true,$scrollX:true,$scrollY:true,$self:true,$webkitIndexedDB:true,$webkitStorageInfo:true,$window:true};var hasAutomationEqualityBug=function(){if(typeof window==="undefined"){return false}for(var k in window){try{if(!excludedKeys["$"+k]&&has.call(window,k)&&window[k]!==null&&typeof window[k]==="object"){try{equalsConstructorPrototype(window[k])}catch(e){return true}}}catch(e){return true}}return false}();var equalsConstructorPrototypeIfNotBuggy=function(o){if(typeof window==="undefined"||!hasAutomationEqualityBug){return equalsConstructorPrototype(o)}try{return equalsConstructorPrototype(o)}catch(e){return false}};keysShim=function keys(object){var isObject=object!==null&&typeof object==="object";var isFunction=toStr.call(object)==="[object Function]";var isArguments=isArgs(object);var isString=isObject&&toStr.call(object)==="[object String]";var theKeys=[];if(!isObject&&!isFunction&&!isArguments){throw new TypeError("Object.keys called on a non-object")}var skipProto=hasProtoEnumBug&&isFunction;if(isString&&object.length>0&&!has.call(object,0)){for(var i=0;i<object.length;++i){theKeys.push(String(i))}}if(isArguments&&object.length>0){for(var j=0;j<object.length;++j){theKeys.push(String(j))}}else{for(var name in object){if(!(skipProto&&name==="prototype")&&has.call(object,name)){theKeys.push(String(name))}}}if(hasDontEnumBug){var skipConstructor=equalsConstructorPrototypeIfNotBuggy(object);for(var k=0;k<dontEnums.length;++k){if(!(skipConstructor&&dontEnums[k]==="constructor")&&has.call(object,dontEnums[k])){theKeys.push(dontEnums[k])}}}return theKeys}}module.exports=keysShim},728:function(module,exports,__webpack_require__){"use strict";var hasToStringTag=typeof Symbol==="function"&&typeof Symbol.toStringTag==="symbol";var toStr=Object.prototype.toString;var isStandardArguments=function isArguments(value){if(hasToStringTag&&value&&typeof value==="object"&&Symbol.toStringTag in value){return false}return toStr.call(value)==="[object Arguments]"};var isLegacyArguments=function isArguments(value){if(isStandardArguments(value)){return true}return value!==null&&typeof value==="object"&&typeof value.length==="number"&&value.length>=0&&toStr.call(value)!=="[object Array]"&&toStr.call(value.callee)==="[object Function]"};var supportsStandardArguments=function(){return isStandardArguments(arguments)}();isStandardArguments.isLegacyArguments=isLegacyArguments;module.exports=supportsStandardArguments?isStandardArguments:isLegacyArguments},729:function(module,exports,__webpack_require__){"use strict";var define=__webpack_require__(168);var callBind=__webpack_require__(362);var implementation=__webpack_require__(365);var getPolyfill=__webpack_require__(366);var shim=__webpack_require__(733);var polyfill=callBind(getPolyfill(),Object);define(polyfill,{getPolyfill:getPolyfill,implementation:implementation,shim:shim});module.exports=polyfill},730:function(module,exports,__webpack_require__){"use strict";var ERROR_MESSAGE="Function.prototype.bind called on incompatible ";var slice=Array.prototype.slice;var toStr=Object.prototype.toString;var funcType="[object Function]";module.exports=function bind(that){var target=this;if(typeof target!=="function"||toStr.call(target)!==funcType){throw new TypeError(ERROR_MESSAGE+target)}var args=slice.call(arguments,1);var bound;var binder=function(){if(this instanceof bound){var result=target.apply(this,args.concat(slice.call(arguments)));if(Object(result)===result){return result}return this}else{return target.apply(that,args.concat(slice.call(arguments)))}};var boundLength=Math.max(0,target.length-args.length);var boundArgs=[];for(var i=0;i<boundLength;i++){boundArgs.push("$"+i)}bound=Function("binder","return function ("+boundArgs.join(",")+"){ return binder.apply(this,arguments); }")(binder);if(target.prototype){var Empty=function Empty(){};Empty.prototype=target.prototype;bound.prototype=new Empty;Empty.prototype=null}return bound}},731:function(module,exports,__webpack_require__){"use strict";var undefined;var $TypeError=TypeError;var $gOPD=Object.getOwnPropertyDescriptor;if($gOPD){try{$gOPD({},"")}catch(e){$gOPD=null}}var throwTypeError=function(){throw new $TypeError};var ThrowTypeError=$gOPD?function(){try{arguments.callee;return throwTypeError}catch(calleeThrows){try{return $gOPD(arguments,"callee").get}catch(gOPDthrows){return throwTypeError}}}():throwTypeError;var hasSymbols=__webpack_require__(364)();var getProto=Object.getPrototypeOf||function(x){return x.__proto__};var generator;var generatorFunction=generator?getProto(generator):undefined;var asyncFn;var asyncFunction=asyncFn?asyncFn.constructor:undefined;var asyncGen;var asyncGenFunction=asyncGen?getProto(asyncGen):undefined;var asyncGenIterator=asyncGen?asyncGen():undefined;var TypedArray=typeof Uint8Array==="undefined"?undefined:getProto(Uint8Array);var INTRINSICS={"%Array%":Array,"%ArrayBuffer%":typeof ArrayBuffer==="undefined"?undefined:ArrayBuffer,"%ArrayBufferPrototype%":typeof ArrayBuffer==="undefined"?undefined:ArrayBuffer.prototype,"%ArrayIteratorPrototype%":hasSymbols?getProto([][Symbol.iterator]()):undefined,"%ArrayPrototype%":Array.prototype,"%ArrayProto_entries%":Array.prototype.entries,"%ArrayProto_forEach%":Array.prototype.forEach,"%ArrayProto_keys%":Array.prototype.keys,"%ArrayProto_values%":Array.prototype.values,"%AsyncFromSyncIteratorPrototype%":undefined,"%AsyncFunction%":asyncFunction,"%AsyncFunctionPrototype%":asyncFunction?asyncFunction.prototype:undefined,"%AsyncGenerator%":asyncGen?getProto(asyncGenIterator):undefined,"%AsyncGeneratorFunction%":asyncGenFunction,"%AsyncGeneratorPrototype%":asyncGenFunction?asyncGenFunction.prototype:undefined,"%AsyncIteratorPrototype%":asyncGenIterator&&hasSymbols&&Symbol.asyncIterator?asyncGenIterator[Symbol.asyncIterator]():undefined,"%Atomics%":typeof Atomics==="undefined"?undefined:Atomics,"%Boolean%":Boolean,"%BooleanPrototype%":Boolean.prototype,"%DataView%":typeof DataView==="undefined"?undefined:DataView,"%DataViewPrototype%":typeof DataView==="undefined"?undefined:DataView.prototype,"%Date%":Date,"%DatePrototype%":Date.prototype,"%decodeURI%":decodeURI,"%decodeURIComponent%":decodeURIComponent,"%encodeURI%":encodeURI,"%encodeURIComponent%":encodeURIComponent,"%Error%":Error,"%ErrorPrototype%":Error.prototype,"%eval%":eval,"%EvalError%":EvalError,"%EvalErrorPrototype%":EvalError.prototype,"%Float32Array%":typeof Float32Array==="undefined"?undefined:Float32Array,"%Float32ArrayPrototype%":typeof Float32Array==="undefined"?undefined:Float32Array.prototype,"%Float64Array%":typeof Float64Array==="undefined"?undefined:Float64Array,"%Float64ArrayPrototype%":typeof Float64Array==="undefined"?undefined:Float64Array.prototype,"%Function%":Function,"%FunctionPrototype%":Function.prototype,"%Generator%":generator?getProto(generator()):undefined,"%GeneratorFunction%":generatorFunction,"%GeneratorPrototype%":generatorFunction?generatorFunction.prototype:undefined,"%Int8Array%":typeof Int8Array==="undefined"?undefined:Int8Array,"%Int8ArrayPrototype%":typeof Int8Array==="undefined"?undefined:Int8Array.prototype,"%Int16Array%":typeof Int16Array==="undefined"?undefined:Int16Array,"%Int16ArrayPrototype%":typeof Int16Array==="undefined"?undefined:Int8Array.prototype,"%Int32Array%":typeof Int32Array==="undefined"?undefined:Int32Array,"%Int32ArrayPrototype%":typeof Int32Array==="undefined"?undefined:Int32Array.prototype,"%isFinite%":isFinite,"%isNaN%":isNaN,"%IteratorPrototype%":hasSymbols?getProto(getProto([][Symbol.iterator]())):undefined,"%JSON%":typeof JSON==="object"?JSON:undefined,"%JSONParse%":typeof JSON==="object"?JSON.parse:undefined,"%Map%":typeof Map==="undefined"?undefined:Map,"%MapIteratorPrototype%":typeof Map==="undefined"||!hasSymbols?undefined:getProto((new Map)[Symbol.iterator]()),"%MapPrototype%":typeof Map==="undefined"?undefined:Map.prototype,"%Math%":Math,"%Number%":Number,"%NumberPrototype%":Number.prototype,"%Object%":Object,"%ObjectPrototype%":Object.prototype,"%ObjProto_toString%":Object.prototype.toString,"%ObjProto_valueOf%":Object.prototype.valueOf,"%parseFloat%":parseFloat,"%parseInt%":parseInt,"%Promise%":typeof Promise==="undefined"?undefined:Promise,"%PromisePrototype%":typeof Promise==="undefined"?undefined:Promise.prototype,"%PromiseProto_then%":typeof Promise==="undefined"?undefined:Promise.prototype.then,"%Promise_all%":typeof Promise==="undefined"?undefined:Promise.all,"%Promise_reject%":typeof Promise==="undefined"?undefined:Promise.reject,"%Promise_resolve%":typeof Promise==="undefined"?undefined:Promise.resolve,"%Proxy%":typeof Proxy==="undefined"?undefined:Proxy,"%RangeError%":RangeError,"%RangeErrorPrototype%":RangeError.prototype,"%ReferenceError%":ReferenceError,"%ReferenceErrorPrototype%":ReferenceError.prototype,"%Reflect%":typeof Reflect==="undefined"?undefined:Reflect,"%RegExp%":RegExp,"%RegExpPrototype%":RegExp.prototype,"%Set%":typeof Set==="undefined"?undefined:Set,"%SetIteratorPrototype%":typeof Set==="undefined"||!hasSymbols?undefined:getProto((new Set)[Symbol.iterator]()),"%SetPrototype%":typeof Set==="undefined"?undefined:Set.prototype,"%SharedArrayBuffer%":typeof SharedArrayBuffer==="undefined"?undefined:SharedArrayBuffer,"%SharedArrayBufferPrototype%":typeof SharedArrayBuffer==="undefined"?undefined:SharedArrayBuffer.prototype,"%String%":String,"%StringIteratorPrototype%":hasSymbols?getProto(""[Symbol.iterator]()):undefined,"%StringPrototype%":String.prototype,"%Symbol%":hasSymbols?Symbol:undefined,"%SymbolPrototype%":hasSymbols?Symbol.prototype:undefined,"%SyntaxError%":SyntaxError,"%SyntaxErrorPrototype%":SyntaxError.prototype,"%ThrowTypeError%":ThrowTypeError,"%TypedArray%":TypedArray,"%TypedArrayPrototype%":TypedArray?TypedArray.prototype:undefined,"%TypeError%":$TypeError,"%TypeErrorPrototype%":$TypeError.prototype,"%Uint8Array%":typeof Uint8Array==="undefined"?undefined:Uint8Array,"%Uint8ArrayPrototype%":typeof Uint8Array==="undefined"?undefined:Uint8Array.prototype,"%Uint8ClampedArray%":typeof Uint8ClampedArray==="undefined"?undefined:Uint8ClampedArray,"%Uint8ClampedArrayPrototype%":typeof Uint8ClampedArray==="undefined"?undefined:Uint8ClampedArray.prototype,"%Uint16Array%":typeof Uint16Array==="undefined"?undefined:Uint16Array,"%Uint16ArrayPrototype%":typeof Uint16Array==="undefined"?undefined:Uint16Array.prototype,"%Uint32Array%":typeof Uint32Array==="undefined"?undefined:Uint32Array,"%Uint32ArrayPrototype%":typeof Uint32Array==="undefined"?undefined:Uint32Array.prototype,"%URIError%":URIError,"%URIErrorPrototype%":URIError.prototype,"%WeakMap%":typeof WeakMap==="undefined"?undefined:WeakMap,"%WeakMapPrototype%":typeof WeakMap==="undefined"?undefined:WeakMap.prototype,"%WeakSet%":typeof WeakSet==="undefined"?undefined:WeakSet,"%WeakSetPrototype%":typeof WeakSet==="undefined"?undefined:WeakSet.prototype};var bind=__webpack_require__(363);var $replace=bind.call(Function.call,String.prototype.replace);var rePropName=/[^%.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|%$))/g;var reEscapeChar=/\\(\\)?/g;var stringToPath=function stringToPath(string){var result=[];$replace(string,rePropName,(function(match,number,quote,subString){result[result.length]=quote?$replace(subString,reEscapeChar,"$1"):number||match}));return result};var getBaseIntrinsic=function getBaseIntrinsic(name,allowMissing){if(!(name in INTRINSICS)){throw new SyntaxError("intrinsic "+name+" does not exist!")}if(typeof INTRINSICS[name]==="undefined"&&!allowMissing){throw new $TypeError("intrinsic "+name+" exists, but is not available. Please file an issue!")}return INTRINSICS[name]};module.exports=function GetIntrinsic(name,allowMissing){if(typeof name!=="string"||name.length===0){throw new TypeError("intrinsic name must be a non-empty string")}if(arguments.length>1&&typeof allowMissing!=="boolean"){throw new TypeError('"allowMissing" argument must be a boolean')}var parts=stringToPath(name);var value=getBaseIntrinsic("%"+(parts.length>0?parts[0]:"")+"%",allowMissing);for(var i=1;i<parts.length;i+=1){if(value!=null){if($gOPD&&i+1>=parts.length){var desc=$gOPD(value,parts[i]);if(!allowMissing&&!(parts[i]in value)){throw new $TypeError("base intrinsic for "+name+" exists, but the property is not available.")}value=desc?desc.get||desc.value:value[parts[i]]}else{value=value[parts[i]]}}}return value}},732:function(module,exports,__webpack_require__){"use strict";module.exports=function hasSymbols(){if(typeof Symbol!=="function"||typeof Object.getOwnPropertySymbols!=="function"){return false}if(typeof Symbol.iterator==="symbol"){return true}var obj={};var sym=Symbol("test");var symObj=Object(sym);if(typeof sym==="string"){return false}if(Object.prototype.toString.call(sym)!=="[object Symbol]"){return false}if(Object.prototype.toString.call(symObj)!=="[object Symbol]"){return false}var symVal=42;obj[sym]=symVal;for(sym in obj){return false}if(typeof Object.keys==="function"&&Object.keys(obj).length!==0){return false}if(typeof Object.getOwnPropertyNames==="function"&&Object.getOwnPropertyNames(obj).length!==0){return false}var syms=Object.getOwnPropertySymbols(obj);if(syms.length!==1||syms[0]!==sym){return false}if(!Object.prototype.propertyIsEnumerable.call(obj,sym)){return false}if(typeof Object.getOwnPropertyDescriptor==="function"){var descriptor=Object.getOwnPropertyDescriptor(obj,sym);if(descriptor.value!==symVal||descriptor.enumerable!==true){return false}}return true}},733:function(module,exports,__webpack_require__){"use strict";var getPolyfill=__webpack_require__(366);var define=__webpack_require__(168);module.exports=function shimObjectIs(){var polyfill=getPolyfill();define(Object,{is:polyfill},{is:function testObjectIs(){return Object.is!==polyfill}});return polyfill}},734:function(module,exports,__webpack_require__){"use strict";var hasSymbols=__webpack_require__(364)();var hasToStringTag=hasSymbols&&typeof Symbol.toStringTag==="symbol";var hasOwnProperty;var regexExec;var isRegexMarker;var badStringifier;if(hasToStringTag){hasOwnProperty=Function.call.bind(Object.prototype.hasOwnProperty);regexExec=Function.call.bind(RegExp.prototype.exec);isRegexMarker={};var throwRegexMarker=function(){throw isRegexMarker};badStringifier={toString:throwRegexMarker,valueOf:throwRegexMarker};if(typeof Symbol.toPrimitive==="symbol"){badStringifier[Symbol.toPrimitive]=throwRegexMarker}}var toStr=Object.prototype.toString;var gOPD=Object.getOwnPropertyDescriptor;var regexClass="[object RegExp]";module.exports=hasToStringTag?function isRegex(value){if(!value||typeof value!=="object"){return false}var descriptor=gOPD(value,"lastIndex");var hasLastIndexDataProperty=descriptor&&hasOwnProperty(descriptor,"value");if(!hasLastIndexDataProperty){return false}try{regexExec(value,badStringifier)}catch(e){return e===isRegexMarker}}:function isRegex(value){if(!value||typeof value!=="object"&&typeof value!=="function"){return false}return toStr.call(value)===regexClass}},735:function(module,exports,__webpack_require__){"use strict";var define=__webpack_require__(168);var callBind=__webpack_require__(362);var implementation=__webpack_require__(367);var getPolyfill=__webpack_require__(368);var shim=__webpack_require__(736);var flagsBound=callBind(implementation);define(flagsBound,{getPolyfill:getPolyfill,implementation:implementation,shim:shim});module.exports=flagsBound},736:function(module,exports,__webpack_require__){"use strict";var supportsDescriptors=__webpack_require__(168).supportsDescriptors;var getPolyfill=__webpack_require__(368);var gOPD=Object.getOwnPropertyDescriptor;var defineProperty=Object.defineProperty;var TypeErr=TypeError;var getProto=Object.getPrototypeOf;var regex=/a/;module.exports=function shimFlags(){if(!supportsDescriptors||!getProto){throw new TypeErr("RegExp.prototype.flags requires a true ES5 environment that supports property descriptors")}var polyfill=getPolyfill();var proto=getProto(regex);var descriptor=gOPD(proto,"flags");if(!descriptor||descriptor.get!==polyfill){defineProperty(proto,"flags",{configurable:true,enumerable:false,get:polyfill})}return polyfill}},737:function(module,exports,__webpack_require__){"use strict";var getDay=Date.prototype.getDay;var tryDateObject=function tryDateGetDayCall(value){try{getDay.call(value);return true}catch(e){return false}};var toStr=Object.prototype.toString;var dateClass="[object Date]";var hasToStringTag=typeof Symbol==="function"&&typeof Symbol.toStringTag==="symbol";module.exports=function isDateObject(value){if(typeof value!=="object"||value===null){return false}return hasToStringTag?tryDateObject(value):toStr.call(value)===dateClass}},738:function(module,exports,__webpack_require__){(function(global){
/**!
 * @fileOverview Kickass library to create and place poppers near their reference elements.
 * @version 1.15.0
 * @license
 * Copyright (c) 2016 Federico Zivolo and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
(function(global,factory){true?module.exports=factory():undefined})(this,(function(){"use strict";var isBrowser=typeof window!=="undefined"&&typeof document!=="undefined";var longerTimeoutBrowsers=["Edge","Trident","Firefox"];var timeoutDuration=0;for(var i=0;i<longerTimeoutBrowsers.length;i+=1){if(isBrowser&&navigator.userAgent.indexOf(longerTimeoutBrowsers[i])>=0){timeoutDuration=1;break}}function microtaskDebounce(fn){var called=false;return function(){if(called){return}called=true;window.Promise.resolve().then((function(){called=false;fn()}))}}function taskDebounce(fn){var scheduled=false;return function(){if(!scheduled){scheduled=true;setTimeout((function(){scheduled=false;fn()}),timeoutDuration)}}}var supportsMicroTasks=isBrowser&&window.Promise;var debounce=supportsMicroTasks?microtaskDebounce:taskDebounce;function isFunction(functionToCheck){var getType={};return functionToCheck&&getType.toString.call(functionToCheck)==="[object Function]"}function getStyleComputedProperty(element,property){if(element.nodeType!==1){return[]}var window=element.ownerDocument.defaultView;var css=window.getComputedStyle(element,null);return property?css[property]:css}function getParentNode(element){if(element.nodeName==="HTML"){return element}return element.parentNode||element.host}function getScrollParent(element){if(!element){return document.body}switch(element.nodeName){case"HTML":case"BODY":return element.ownerDocument.body;case"#document":return element.body}var _getStyleComputedProp=getStyleComputedProperty(element),overflow=_getStyleComputedProp.overflow,overflowX=_getStyleComputedProp.overflowX,overflowY=_getStyleComputedProp.overflowY;if(/(auto|scroll|overlay)/.test(overflow+overflowY+overflowX)){return element}return getScrollParent(getParentNode(element))}var isIE11=isBrowser&&!!(window.MSInputMethodContext&&document.documentMode);var isIE10=isBrowser&&/MSIE 10/.test(navigator.userAgent);function isIE(version){if(version===11){return isIE11}if(version===10){return isIE10}return isIE11||isIE10}function getOffsetParent(element){if(!element){return document.documentElement}var noOffsetParent=isIE(10)?document.body:null;var offsetParent=element.offsetParent||null;while(offsetParent===noOffsetParent&&element.nextElementSibling){offsetParent=(element=element.nextElementSibling).offsetParent}var nodeName=offsetParent&&offsetParent.nodeName;if(!nodeName||nodeName==="BODY"||nodeName==="HTML"){return element?element.ownerDocument.documentElement:document.documentElement}if(["TH","TD","TABLE"].indexOf(offsetParent.nodeName)!==-1&&getStyleComputedProperty(offsetParent,"position")==="static"){return getOffsetParent(offsetParent)}return offsetParent}function isOffsetContainer(element){var nodeName=element.nodeName;if(nodeName==="BODY"){return false}return nodeName==="HTML"||getOffsetParent(element.firstElementChild)===element}function getRoot(node){if(node.parentNode!==null){return getRoot(node.parentNode)}return node}function findCommonOffsetParent(element1,element2){if(!element1||!element1.nodeType||!element2||!element2.nodeType){return document.documentElement}var order=element1.compareDocumentPosition(element2)&Node.DOCUMENT_POSITION_FOLLOWING;var start=order?element1:element2;var end=order?element2:element1;var range=document.createRange();range.setStart(start,0);range.setEnd(end,0);var commonAncestorContainer=range.commonAncestorContainer;if(element1!==commonAncestorContainer&&element2!==commonAncestorContainer||start.contains(end)){if(isOffsetContainer(commonAncestorContainer)){return commonAncestorContainer}return getOffsetParent(commonAncestorContainer)}var element1root=getRoot(element1);if(element1root.host){return findCommonOffsetParent(element1root.host,element2)}else{return findCommonOffsetParent(element1,getRoot(element2).host)}}function getScroll(element){var side=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"top";var upperSide=side==="top"?"scrollTop":"scrollLeft";var nodeName=element.nodeName;if(nodeName==="BODY"||nodeName==="HTML"){var html=element.ownerDocument.documentElement;var scrollingElement=element.ownerDocument.scrollingElement||html;return scrollingElement[upperSide]}return element[upperSide]}function includeScroll(rect,element){var subtract=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var scrollTop=getScroll(element,"top");var scrollLeft=getScroll(element,"left");var modifier=subtract?-1:1;rect.top+=scrollTop*modifier;rect.bottom+=scrollTop*modifier;rect.left+=scrollLeft*modifier;rect.right+=scrollLeft*modifier;return rect}function getBordersSize(styles,axis){var sideA=axis==="x"?"Left":"Top";var sideB=sideA==="Left"?"Right":"Bottom";return parseFloat(styles["border"+sideA+"Width"],10)+parseFloat(styles["border"+sideB+"Width"],10)}function getSize(axis,body,html,computedStyle){return Math.max(body["offset"+axis],body["scroll"+axis],html["client"+axis],html["offset"+axis],html["scroll"+axis],isIE(10)?parseInt(html["offset"+axis])+parseInt(computedStyle["margin"+(axis==="Height"?"Top":"Left")])+parseInt(computedStyle["margin"+(axis==="Height"?"Bottom":"Right")]):0)}function getWindowSizes(document){var body=document.body;var html=document.documentElement;var computedStyle=isIE(10)&&getComputedStyle(html);return{height:getSize("Height",body,html,computedStyle),width:getSize("Width",body,html,computedStyle)}}var classCallCheck=function(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}};var createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var defineProperty=function(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj};var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};function getClientRect(offsets){return _extends({},offsets,{right:offsets.left+offsets.width,bottom:offsets.top+offsets.height})}function getBoundingClientRect(element){var rect={};try{if(isIE(10)){rect=element.getBoundingClientRect();var scrollTop=getScroll(element,"top");var scrollLeft=getScroll(element,"left");rect.top+=scrollTop;rect.left+=scrollLeft;rect.bottom+=scrollTop;rect.right+=scrollLeft}else{rect=element.getBoundingClientRect()}}catch(e){}var result={left:rect.left,top:rect.top,width:rect.right-rect.left,height:rect.bottom-rect.top};var sizes=element.nodeName==="HTML"?getWindowSizes(element.ownerDocument):{};var width=sizes.width||element.clientWidth||result.right-result.left;var height=sizes.height||element.clientHeight||result.bottom-result.top;var horizScrollbar=element.offsetWidth-width;var vertScrollbar=element.offsetHeight-height;if(horizScrollbar||vertScrollbar){var styles=getStyleComputedProperty(element);horizScrollbar-=getBordersSize(styles,"x");vertScrollbar-=getBordersSize(styles,"y");result.width-=horizScrollbar;result.height-=vertScrollbar}return getClientRect(result)}function getOffsetRectRelativeToArbitraryNode(children,parent){var fixedPosition=arguments.length>2&&arguments[2]!==undefined?arguments[2]:false;var isIE10=isIE(10);var isHTML=parent.nodeName==="HTML";var childrenRect=getBoundingClientRect(children);var parentRect=getBoundingClientRect(parent);var scrollParent=getScrollParent(children);var styles=getStyleComputedProperty(parent);var borderTopWidth=parseFloat(styles.borderTopWidth,10);var borderLeftWidth=parseFloat(styles.borderLeftWidth,10);if(fixedPosition&&isHTML){parentRect.top=Math.max(parentRect.top,0);parentRect.left=Math.max(parentRect.left,0)}var offsets=getClientRect({top:childrenRect.top-parentRect.top-borderTopWidth,left:childrenRect.left-parentRect.left-borderLeftWidth,width:childrenRect.width,height:childrenRect.height});offsets.marginTop=0;offsets.marginLeft=0;if(!isIE10&&isHTML){var marginTop=parseFloat(styles.marginTop,10);var marginLeft=parseFloat(styles.marginLeft,10);offsets.top-=borderTopWidth-marginTop;offsets.bottom-=borderTopWidth-marginTop;offsets.left-=borderLeftWidth-marginLeft;offsets.right-=borderLeftWidth-marginLeft;offsets.marginTop=marginTop;offsets.marginLeft=marginLeft}if(isIE10&&!fixedPosition?parent.contains(scrollParent):parent===scrollParent&&scrollParent.nodeName!=="BODY"){offsets=includeScroll(offsets,parent)}return offsets}function getViewportOffsetRectRelativeToArtbitraryNode(element){var excludeScroll=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var html=element.ownerDocument.documentElement;var relativeOffset=getOffsetRectRelativeToArbitraryNode(element,html);var width=Math.max(html.clientWidth,window.innerWidth||0);var height=Math.max(html.clientHeight,window.innerHeight||0);var scrollTop=!excludeScroll?getScroll(html):0;var scrollLeft=!excludeScroll?getScroll(html,"left"):0;var offset={top:scrollTop-relativeOffset.top+relativeOffset.marginTop,left:scrollLeft-relativeOffset.left+relativeOffset.marginLeft,width:width,height:height};return getClientRect(offset)}function isFixed(element){var nodeName=element.nodeName;if(nodeName==="BODY"||nodeName==="HTML"){return false}if(getStyleComputedProperty(element,"position")==="fixed"){return true}var parentNode=getParentNode(element);if(!parentNode){return false}return isFixed(parentNode)}function getFixedPositionOffsetParent(element){if(!element||!element.parentElement||isIE()){return document.documentElement}var el=element.parentElement;while(el&&getStyleComputedProperty(el,"transform")==="none"){el=el.parentElement}return el||document.documentElement}function getBoundaries(popper,reference,padding,boundariesElement){var fixedPosition=arguments.length>4&&arguments[4]!==undefined?arguments[4]:false;var boundaries={top:0,left:0};var offsetParent=fixedPosition?getFixedPositionOffsetParent(popper):findCommonOffsetParent(popper,reference);if(boundariesElement==="viewport"){boundaries=getViewportOffsetRectRelativeToArtbitraryNode(offsetParent,fixedPosition)}else{var boundariesNode=void 0;if(boundariesElement==="scrollParent"){boundariesNode=getScrollParent(getParentNode(reference));if(boundariesNode.nodeName==="BODY"){boundariesNode=popper.ownerDocument.documentElement}}else if(boundariesElement==="window"){boundariesNode=popper.ownerDocument.documentElement}else{boundariesNode=boundariesElement}var offsets=getOffsetRectRelativeToArbitraryNode(boundariesNode,offsetParent,fixedPosition);if(boundariesNode.nodeName==="HTML"&&!isFixed(offsetParent)){var _getWindowSizes=getWindowSizes(popper.ownerDocument),height=_getWindowSizes.height,width=_getWindowSizes.width;boundaries.top+=offsets.top-offsets.marginTop;boundaries.bottom=height+offsets.top;boundaries.left+=offsets.left-offsets.marginLeft;boundaries.right=width+offsets.left}else{boundaries=offsets}}padding=padding||0;var isPaddingNumber=typeof padding==="number";boundaries.left+=isPaddingNumber?padding:padding.left||0;boundaries.top+=isPaddingNumber?padding:padding.top||0;boundaries.right-=isPaddingNumber?padding:padding.right||0;boundaries.bottom-=isPaddingNumber?padding:padding.bottom||0;return boundaries}function getArea(_ref){var width=_ref.width,height=_ref.height;return width*height}function computeAutoPlacement(placement,refRect,popper,reference,boundariesElement){var padding=arguments.length>5&&arguments[5]!==undefined?arguments[5]:0;if(placement.indexOf("auto")===-1){return placement}var boundaries=getBoundaries(popper,reference,padding,boundariesElement);var rects={top:{width:boundaries.width,height:refRect.top-boundaries.top},right:{width:boundaries.right-refRect.right,height:boundaries.height},bottom:{width:boundaries.width,height:boundaries.bottom-refRect.bottom},left:{width:refRect.left-boundaries.left,height:boundaries.height}};var sortedAreas=Object.keys(rects).map((function(key){return _extends({key:key},rects[key],{area:getArea(rects[key])})})).sort((function(a,b){return b.area-a.area}));var filteredAreas=sortedAreas.filter((function(_ref2){var width=_ref2.width,height=_ref2.height;return width>=popper.clientWidth&&height>=popper.clientHeight}));var computedPlacement=filteredAreas.length>0?filteredAreas[0].key:sortedAreas[0].key;var variation=placement.split("-")[1];return computedPlacement+(variation?"-"+variation:"")}function getReferenceOffsets(state,popper,reference){var fixedPosition=arguments.length>3&&arguments[3]!==undefined?arguments[3]:null;var commonOffsetParent=fixedPosition?getFixedPositionOffsetParent(popper):findCommonOffsetParent(popper,reference);return getOffsetRectRelativeToArbitraryNode(reference,commonOffsetParent,fixedPosition)}function getOuterSizes(element){var window=element.ownerDocument.defaultView;var styles=window.getComputedStyle(element);var x=parseFloat(styles.marginTop||0)+parseFloat(styles.marginBottom||0);var y=parseFloat(styles.marginLeft||0)+parseFloat(styles.marginRight||0);var result={width:element.offsetWidth+y,height:element.offsetHeight+x};return result}function getOppositePlacement(placement){var hash={left:"right",right:"left",bottom:"top",top:"bottom"};return placement.replace(/left|right|bottom|top/g,(function(matched){return hash[matched]}))}function getPopperOffsets(popper,referenceOffsets,placement){placement=placement.split("-")[0];var popperRect=getOuterSizes(popper);var popperOffsets={width:popperRect.width,height:popperRect.height};var isHoriz=["right","left"].indexOf(placement)!==-1;var mainSide=isHoriz?"top":"left";var secondarySide=isHoriz?"left":"top";var measurement=isHoriz?"height":"width";var secondaryMeasurement=!isHoriz?"height":"width";popperOffsets[mainSide]=referenceOffsets[mainSide]+referenceOffsets[measurement]/2-popperRect[measurement]/2;if(placement===secondarySide){popperOffsets[secondarySide]=referenceOffsets[secondarySide]-popperRect[secondaryMeasurement]}else{popperOffsets[secondarySide]=referenceOffsets[getOppositePlacement(secondarySide)]}return popperOffsets}function find(arr,check){if(Array.prototype.find){return arr.find(check)}return arr.filter(check)[0]}function findIndex(arr,prop,value){if(Array.prototype.findIndex){return arr.findIndex((function(cur){return cur[prop]===value}))}var match=find(arr,(function(obj){return obj[prop]===value}));return arr.indexOf(match)}function runModifiers(modifiers,data,ends){var modifiersToRun=ends===undefined?modifiers:modifiers.slice(0,findIndex(modifiers,"name",ends));modifiersToRun.forEach((function(modifier){if(modifier["function"]){console.warn("`modifier.function` is deprecated, use `modifier.fn`!")}var fn=modifier["function"]||modifier.fn;if(modifier.enabled&&isFunction(fn)){data.offsets.popper=getClientRect(data.offsets.popper);data.offsets.reference=getClientRect(data.offsets.reference);data=fn(data,modifier)}}));return data}function update(){if(this.state.isDestroyed){return}var data={instance:this,styles:{},arrowStyles:{},attributes:{},flipped:false,offsets:{}};data.offsets.reference=getReferenceOffsets(this.state,this.popper,this.reference,this.options.positionFixed);data.placement=computeAutoPlacement(this.options.placement,data.offsets.reference,this.popper,this.reference,this.options.modifiers.flip.boundariesElement,this.options.modifiers.flip.padding);data.originalPlacement=data.placement;data.positionFixed=this.options.positionFixed;data.offsets.popper=getPopperOffsets(this.popper,data.offsets.reference,data.placement);data.offsets.popper.position=this.options.positionFixed?"fixed":"absolute";data=runModifiers(this.modifiers,data);if(!this.state.isCreated){this.state.isCreated=true;this.options.onCreate(data)}else{this.options.onUpdate(data)}}function isModifierEnabled(modifiers,modifierName){return modifiers.some((function(_ref){var name=_ref.name,enabled=_ref.enabled;return enabled&&name===modifierName}))}function getSupportedPropertyName(property){var prefixes=[false,"ms","Webkit","Moz","O"];var upperProp=property.charAt(0).toUpperCase()+property.slice(1);for(var i=0;i<prefixes.length;i++){var prefix=prefixes[i];var toCheck=prefix?""+prefix+upperProp:property;if(typeof document.body.style[toCheck]!=="undefined"){return toCheck}}return null}function destroy(){this.state.isDestroyed=true;if(isModifierEnabled(this.modifiers,"applyStyle")){this.popper.removeAttribute("x-placement");this.popper.style.position="";this.popper.style.top="";this.popper.style.left="";this.popper.style.right="";this.popper.style.bottom="";this.popper.style.willChange="";this.popper.style[getSupportedPropertyName("transform")]=""}this.disableEventListeners();if(this.options.removeOnDestroy){this.popper.parentNode.removeChild(this.popper)}return this}function getWindow(element){var ownerDocument=element.ownerDocument;return ownerDocument?ownerDocument.defaultView:window}function attachToScrollParents(scrollParent,event,callback,scrollParents){var isBody=scrollParent.nodeName==="BODY";var target=isBody?scrollParent.ownerDocument.defaultView:scrollParent;target.addEventListener(event,callback,{passive:true});if(!isBody){attachToScrollParents(getScrollParent(target.parentNode),event,callback,scrollParents)}scrollParents.push(target)}function setupEventListeners(reference,options,state,updateBound){state.updateBound=updateBound;getWindow(reference).addEventListener("resize",state.updateBound,{passive:true});var scrollElement=getScrollParent(reference);attachToScrollParents(scrollElement,"scroll",state.updateBound,state.scrollParents);state.scrollElement=scrollElement;state.eventsEnabled=true;return state}function enableEventListeners(){if(!this.state.eventsEnabled){this.state=setupEventListeners(this.reference,this.options,this.state,this.scheduleUpdate)}}function removeEventListeners(reference,state){getWindow(reference).removeEventListener("resize",state.updateBound);state.scrollParents.forEach((function(target){target.removeEventListener("scroll",state.updateBound)}));state.updateBound=null;state.scrollParents=[];state.scrollElement=null;state.eventsEnabled=false;return state}function disableEventListeners(){if(this.state.eventsEnabled){cancelAnimationFrame(this.scheduleUpdate);this.state=removeEventListeners(this.reference,this.state)}}function isNumeric(n){return n!==""&&!isNaN(parseFloat(n))&&isFinite(n)}function setStyles(element,styles){Object.keys(styles).forEach((function(prop){var unit="";if(["width","height","top","right","bottom","left"].indexOf(prop)!==-1&&isNumeric(styles[prop])){unit="px"}element.style[prop]=styles[prop]+unit}))}function setAttributes(element,attributes){Object.keys(attributes).forEach((function(prop){var value=attributes[prop];if(value!==false){element.setAttribute(prop,attributes[prop])}else{element.removeAttribute(prop)}}))}function applyStyle(data){setStyles(data.instance.popper,data.styles);setAttributes(data.instance.popper,data.attributes);if(data.arrowElement&&Object.keys(data.arrowStyles).length){setStyles(data.arrowElement,data.arrowStyles)}return data}function applyStyleOnLoad(reference,popper,options,modifierOptions,state){var referenceOffsets=getReferenceOffsets(state,popper,reference,options.positionFixed);var placement=computeAutoPlacement(options.placement,referenceOffsets,popper,reference,options.modifiers.flip.boundariesElement,options.modifiers.flip.padding);popper.setAttribute("x-placement",placement);setStyles(popper,{position:options.positionFixed?"fixed":"absolute"});return options}function getRoundedOffsets(data,shouldRound){var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var round=Math.round,floor=Math.floor;var noRound=function noRound(v){return v};var referenceWidth=round(reference.width);var popperWidth=round(popper.width);var isVertical=["left","right"].indexOf(data.placement)!==-1;var isVariation=data.placement.indexOf("-")!==-1;var sameWidthParity=referenceWidth%2===popperWidth%2;var bothOddWidth=referenceWidth%2===1&&popperWidth%2===1;var horizontalToInteger=!shouldRound?noRound:isVertical||isVariation||sameWidthParity?round:floor;var verticalToInteger=!shouldRound?noRound:round;return{left:horizontalToInteger(bothOddWidth&&!isVariation&&shouldRound?popper.left-1:popper.left),top:verticalToInteger(popper.top),bottom:verticalToInteger(popper.bottom),right:horizontalToInteger(popper.right)}}var isFirefox=isBrowser&&/Firefox/i.test(navigator.userAgent);function computeStyle(data,options){var x=options.x,y=options.y;var popper=data.offsets.popper;var legacyGpuAccelerationOption=find(data.instance.modifiers,(function(modifier){return modifier.name==="applyStyle"})).gpuAcceleration;if(legacyGpuAccelerationOption!==undefined){console.warn("WARNING: `gpuAcceleration` option moved to `computeStyle` modifier and will not be supported in future versions of Popper.js!")}var gpuAcceleration=legacyGpuAccelerationOption!==undefined?legacyGpuAccelerationOption:options.gpuAcceleration;var offsetParent=getOffsetParent(data.instance.popper);var offsetParentRect=getBoundingClientRect(offsetParent);var styles={position:popper.position};var offsets=getRoundedOffsets(data,window.devicePixelRatio<2||!isFirefox);var sideA=x==="bottom"?"top":"bottom";var sideB=y==="right"?"left":"right";var prefixedProperty=getSupportedPropertyName("transform");var left=void 0,top=void 0;if(sideA==="bottom"){if(offsetParent.nodeName==="HTML"){top=-offsetParent.clientHeight+offsets.bottom}else{top=-offsetParentRect.height+offsets.bottom}}else{top=offsets.top}if(sideB==="right"){if(offsetParent.nodeName==="HTML"){left=-offsetParent.clientWidth+offsets.right}else{left=-offsetParentRect.width+offsets.right}}else{left=offsets.left}if(gpuAcceleration&&prefixedProperty){styles[prefixedProperty]="translate3d("+left+"px, "+top+"px, 0)";styles[sideA]=0;styles[sideB]=0;styles.willChange="transform"}else{var invertTop=sideA==="bottom"?-1:1;var invertLeft=sideB==="right"?-1:1;styles[sideA]=top*invertTop;styles[sideB]=left*invertLeft;styles.willChange=sideA+", "+sideB}var attributes={"x-placement":data.placement};data.attributes=_extends({},attributes,data.attributes);data.styles=_extends({},styles,data.styles);data.arrowStyles=_extends({},data.offsets.arrow,data.arrowStyles);return data}function isModifierRequired(modifiers,requestingName,requestedName){var requesting=find(modifiers,(function(_ref){var name=_ref.name;return name===requestingName}));var isRequired=!!requesting&&modifiers.some((function(modifier){return modifier.name===requestedName&&modifier.enabled&&modifier.order<requesting.order}));if(!isRequired){var _requesting="`"+requestingName+"`";var requested="`"+requestedName+"`";console.warn(requested+" modifier is required by "+_requesting+" modifier in order to work, be sure to include it before "+_requesting+"!")}return isRequired}function arrow(data,options){var _data$offsets$arrow;if(!isModifierRequired(data.instance.modifiers,"arrow","keepTogether")){return data}var arrowElement=options.element;if(typeof arrowElement==="string"){arrowElement=data.instance.popper.querySelector(arrowElement);if(!arrowElement){return data}}else{if(!data.instance.popper.contains(arrowElement)){console.warn("WARNING: `arrow.element` must be child of its popper element!");return data}}var placement=data.placement.split("-")[0];var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var isVertical=["left","right"].indexOf(placement)!==-1;var len=isVertical?"height":"width";var sideCapitalized=isVertical?"Top":"Left";var side=sideCapitalized.toLowerCase();var altSide=isVertical?"left":"top";var opSide=isVertical?"bottom":"right";var arrowElementSize=getOuterSizes(arrowElement)[len];if(reference[opSide]-arrowElementSize<popper[side]){data.offsets.popper[side]-=popper[side]-(reference[opSide]-arrowElementSize)}if(reference[side]+arrowElementSize>popper[opSide]){data.offsets.popper[side]+=reference[side]+arrowElementSize-popper[opSide]}data.offsets.popper=getClientRect(data.offsets.popper);var center=reference[side]+reference[len]/2-arrowElementSize/2;var css=getStyleComputedProperty(data.instance.popper);var popperMarginSide=parseFloat(css["margin"+sideCapitalized],10);var popperBorderSide=parseFloat(css["border"+sideCapitalized+"Width"],10);var sideValue=center-data.offsets.popper[side]-popperMarginSide-popperBorderSide;sideValue=Math.max(Math.min(popper[len]-arrowElementSize,sideValue),0);data.arrowElement=arrowElement;data.offsets.arrow=(_data$offsets$arrow={},defineProperty(_data$offsets$arrow,side,Math.round(sideValue)),defineProperty(_data$offsets$arrow,altSide,""),_data$offsets$arrow);return data}function getOppositeVariation(variation){if(variation==="end"){return"start"}else if(variation==="start"){return"end"}return variation}var placements=["auto-start","auto","auto-end","top-start","top","top-end","right-start","right","right-end","bottom-end","bottom","bottom-start","left-end","left","left-start"];var validPlacements=placements.slice(3);function clockwise(placement){var counter=arguments.length>1&&arguments[1]!==undefined?arguments[1]:false;var index=validPlacements.indexOf(placement);var arr=validPlacements.slice(index+1).concat(validPlacements.slice(0,index));return counter?arr.reverse():arr}var BEHAVIORS={FLIP:"flip",CLOCKWISE:"clockwise",COUNTERCLOCKWISE:"counterclockwise"};function flip(data,options){if(isModifierEnabled(data.instance.modifiers,"inner")){return data}if(data.flipped&&data.placement===data.originalPlacement){return data}var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,options.boundariesElement,data.positionFixed);var placement=data.placement.split("-")[0];var placementOpposite=getOppositePlacement(placement);var variation=data.placement.split("-")[1]||"";var flipOrder=[];switch(options.behavior){case BEHAVIORS.FLIP:flipOrder=[placement,placementOpposite];break;case BEHAVIORS.CLOCKWISE:flipOrder=clockwise(placement);break;case BEHAVIORS.COUNTERCLOCKWISE:flipOrder=clockwise(placement,true);break;default:flipOrder=options.behavior}flipOrder.forEach((function(step,index){if(placement!==step||flipOrder.length===index+1){return data}placement=data.placement.split("-")[0];placementOpposite=getOppositePlacement(placement);var popperOffsets=data.offsets.popper;var refOffsets=data.offsets.reference;var floor=Math.floor;var overlapsRef=placement==="left"&&floor(popperOffsets.right)>floor(refOffsets.left)||placement==="right"&&floor(popperOffsets.left)<floor(refOffsets.right)||placement==="top"&&floor(popperOffsets.bottom)>floor(refOffsets.top)||placement==="bottom"&&floor(popperOffsets.top)<floor(refOffsets.bottom);var overflowsLeft=floor(popperOffsets.left)<floor(boundaries.left);var overflowsRight=floor(popperOffsets.right)>floor(boundaries.right);var overflowsTop=floor(popperOffsets.top)<floor(boundaries.top);var overflowsBottom=floor(popperOffsets.bottom)>floor(boundaries.bottom);var overflowsBoundaries=placement==="left"&&overflowsLeft||placement==="right"&&overflowsRight||placement==="top"&&overflowsTop||placement==="bottom"&&overflowsBottom;var isVertical=["top","bottom"].indexOf(placement)!==-1;var flippedVariationByRef=!!options.flipVariations&&(isVertical&&variation==="start"&&overflowsLeft||isVertical&&variation==="end"&&overflowsRight||!isVertical&&variation==="start"&&overflowsTop||!isVertical&&variation==="end"&&overflowsBottom);var flippedVariationByContent=!!options.flipVariationsByContent&&(isVertical&&variation==="start"&&overflowsRight||isVertical&&variation==="end"&&overflowsLeft||!isVertical&&variation==="start"&&overflowsBottom||!isVertical&&variation==="end"&&overflowsTop);var flippedVariation=flippedVariationByRef||flippedVariationByContent;if(overlapsRef||overflowsBoundaries||flippedVariation){data.flipped=true;if(overlapsRef||overflowsBoundaries){placement=flipOrder[index+1]}if(flippedVariation){variation=getOppositeVariation(variation)}data.placement=placement+(variation?"-"+variation:"");data.offsets.popper=_extends({},data.offsets.popper,getPopperOffsets(data.instance.popper,data.offsets.reference,data.placement));data=runModifiers(data.instance.modifiers,data,"flip")}}));return data}function keepTogether(data){var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var placement=data.placement.split("-")[0];var floor=Math.floor;var isVertical=["top","bottom"].indexOf(placement)!==-1;var side=isVertical?"right":"bottom";var opSide=isVertical?"left":"top";var measurement=isVertical?"width":"height";if(popper[side]<floor(reference[opSide])){data.offsets.popper[opSide]=floor(reference[opSide])-popper[measurement]}if(popper[opSide]>floor(reference[side])){data.offsets.popper[opSide]=floor(reference[side])}return data}function toValue(str,measurement,popperOffsets,referenceOffsets){var split=str.match(/((?:\-|\+)?\d*\.?\d*)(.*)/);var value=+split[1];var unit=split[2];if(!value){return str}if(unit.indexOf("%")===0){var element=void 0;switch(unit){case"%p":element=popperOffsets;break;case"%":case"%r":default:element=referenceOffsets}var rect=getClientRect(element);return rect[measurement]/100*value}else if(unit==="vh"||unit==="vw"){var size=void 0;if(unit==="vh"){size=Math.max(document.documentElement.clientHeight,window.innerHeight||0)}else{size=Math.max(document.documentElement.clientWidth,window.innerWidth||0)}return size/100*value}else{return value}}function parseOffset(offset,popperOffsets,referenceOffsets,basePlacement){var offsets=[0,0];var useHeight=["right","left"].indexOf(basePlacement)!==-1;var fragments=offset.split(/(\+|\-)/).map((function(frag){return frag.trim()}));var divider=fragments.indexOf(find(fragments,(function(frag){return frag.search(/,|\s/)!==-1})));if(fragments[divider]&&fragments[divider].indexOf(",")===-1){console.warn("Offsets separated by white space(s) are deprecated, use a comma (,) instead.")}var splitRegex=/\s*,\s*|\s+/;var ops=divider!==-1?[fragments.slice(0,divider).concat([fragments[divider].split(splitRegex)[0]]),[fragments[divider].split(splitRegex)[1]].concat(fragments.slice(divider+1))]:[fragments];ops=ops.map((function(op,index){var measurement=(index===1?!useHeight:useHeight)?"height":"width";var mergeWithPrevious=false;return op.reduce((function(a,b){if(a[a.length-1]===""&&["+","-"].indexOf(b)!==-1){a[a.length-1]=b;mergeWithPrevious=true;return a}else if(mergeWithPrevious){a[a.length-1]+=b;mergeWithPrevious=false;return a}else{return a.concat(b)}}),[]).map((function(str){return toValue(str,measurement,popperOffsets,referenceOffsets)}))}));ops.forEach((function(op,index){op.forEach((function(frag,index2){if(isNumeric(frag)){offsets[index]+=frag*(op[index2-1]==="-"?-1:1)}}))}));return offsets}function offset(data,_ref){var offset=_ref.offset;var placement=data.placement,_data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var basePlacement=placement.split("-")[0];var offsets=void 0;if(isNumeric(+offset)){offsets=[+offset,0]}else{offsets=parseOffset(offset,popper,reference,basePlacement)}if(basePlacement==="left"){popper.top+=offsets[0];popper.left-=offsets[1]}else if(basePlacement==="right"){popper.top+=offsets[0];popper.left+=offsets[1]}else if(basePlacement==="top"){popper.left+=offsets[0];popper.top-=offsets[1]}else if(basePlacement==="bottom"){popper.left+=offsets[0];popper.top+=offsets[1]}data.popper=popper;return data}function preventOverflow(data,options){var boundariesElement=options.boundariesElement||getOffsetParent(data.instance.popper);if(data.instance.reference===boundariesElement){boundariesElement=getOffsetParent(boundariesElement)}var transformProp=getSupportedPropertyName("transform");var popperStyles=data.instance.popper.style;var top=popperStyles.top,left=popperStyles.left,transform=popperStyles[transformProp];popperStyles.top="";popperStyles.left="";popperStyles[transformProp]="";var boundaries=getBoundaries(data.instance.popper,data.instance.reference,options.padding,boundariesElement,data.positionFixed);popperStyles.top=top;popperStyles.left=left;popperStyles[transformProp]=transform;options.boundaries=boundaries;var order=options.priority;var popper=data.offsets.popper;var check={primary:function primary(placement){var value=popper[placement];if(popper[placement]<boundaries[placement]&&!options.escapeWithReference){value=Math.max(popper[placement],boundaries[placement])}return defineProperty({},placement,value)},secondary:function secondary(placement){var mainSide=placement==="right"?"left":"top";var value=popper[mainSide];if(popper[placement]>boundaries[placement]&&!options.escapeWithReference){value=Math.min(popper[mainSide],boundaries[placement]-(placement==="right"?popper.width:popper.height))}return defineProperty({},mainSide,value)}};order.forEach((function(placement){var side=["left","top"].indexOf(placement)!==-1?"primary":"secondary";popper=_extends({},popper,check[side](placement))}));data.offsets.popper=popper;return data}function shift(data){var placement=data.placement;var basePlacement=placement.split("-")[0];var shiftvariation=placement.split("-")[1];if(shiftvariation){var _data$offsets=data.offsets,reference=_data$offsets.reference,popper=_data$offsets.popper;var isVertical=["bottom","top"].indexOf(basePlacement)!==-1;var side=isVertical?"left":"top";var measurement=isVertical?"width":"height";var shiftOffsets={start:defineProperty({},side,reference[side]),end:defineProperty({},side,reference[side]+reference[measurement]-popper[measurement])};data.offsets.popper=_extends({},popper,shiftOffsets[shiftvariation])}return data}function hide(data){if(!isModifierRequired(data.instance.modifiers,"hide","preventOverflow")){return data}var refRect=data.offsets.reference;var bound=find(data.instance.modifiers,(function(modifier){return modifier.name==="preventOverflow"})).boundaries;if(refRect.bottom<bound.top||refRect.left>bound.right||refRect.top>bound.bottom||refRect.right<bound.left){if(data.hide===true){return data}data.hide=true;data.attributes["x-out-of-boundaries"]=""}else{if(data.hide===false){return data}data.hide=false;data.attributes["x-out-of-boundaries"]=false}return data}function inner(data){var placement=data.placement;var basePlacement=placement.split("-")[0];var _data$offsets=data.offsets,popper=_data$offsets.popper,reference=_data$offsets.reference;var isHoriz=["left","right"].indexOf(basePlacement)!==-1;var subtractLength=["top","left"].indexOf(basePlacement)===-1;popper[isHoriz?"left":"top"]=reference[basePlacement]-(subtractLength?popper[isHoriz?"width":"height"]:0);data.placement=getOppositePlacement(placement);data.offsets.popper=getClientRect(popper);return data}var modifiers={shift:{order:100,enabled:true,fn:shift},offset:{order:200,enabled:true,fn:offset,offset:0},preventOverflow:{order:300,enabled:true,fn:preventOverflow,priority:["left","right","top","bottom"],padding:5,boundariesElement:"scrollParent"},keepTogether:{order:400,enabled:true,fn:keepTogether},arrow:{order:500,enabled:true,fn:arrow,element:"[x-arrow]"},flip:{order:600,enabled:true,fn:flip,behavior:"flip",padding:5,boundariesElement:"viewport",flipVariations:false,flipVariationsByContent:false},inner:{order:700,enabled:false,fn:inner},hide:{order:800,enabled:true,fn:hide},computeStyle:{order:850,enabled:true,fn:computeStyle,gpuAcceleration:true,x:"bottom",y:"right"},applyStyle:{order:900,enabled:true,fn:applyStyle,onLoad:applyStyleOnLoad,gpuAcceleration:undefined}};var Defaults={placement:"bottom",positionFixed:false,eventsEnabled:true,removeOnDestroy:false,onCreate:function onCreate(){},onUpdate:function onUpdate(){},modifiers:modifiers};var Popper=function(){function Popper(reference,popper){var _this=this;var options=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};classCallCheck(this,Popper);this.scheduleUpdate=function(){return requestAnimationFrame(_this.update)};this.update=debounce(this.update.bind(this));this.options=_extends({},Popper.Defaults,options);this.state={isDestroyed:false,isCreated:false,scrollParents:[]};this.reference=reference&&reference.jquery?reference[0]:reference;this.popper=popper&&popper.jquery?popper[0]:popper;this.options.modifiers={};Object.keys(_extends({},Popper.Defaults.modifiers,options.modifiers)).forEach((function(name){_this.options.modifiers[name]=_extends({},Popper.Defaults.modifiers[name]||{},options.modifiers?options.modifiers[name]:{})}));this.modifiers=Object.keys(this.options.modifiers).map((function(name){return _extends({name:name},_this.options.modifiers[name])})).sort((function(a,b){return a.order-b.order}));this.modifiers.forEach((function(modifierOptions){if(modifierOptions.enabled&&isFunction(modifierOptions.onLoad)){modifierOptions.onLoad(_this.reference,_this.popper,_this.options,modifierOptions,_this.state)}}));this.update();var eventsEnabled=this.options.eventsEnabled;if(eventsEnabled){this.enableEventListeners()}this.state.eventsEnabled=eventsEnabled}createClass(Popper,[{key:"update",value:function update$$1(){return update.call(this)}},{key:"destroy",value:function destroy$$1(){return destroy.call(this)}},{key:"enableEventListeners",value:function enableEventListeners$$1(){return enableEventListeners.call(this)}},{key:"disableEventListeners",value:function disableEventListeners$$1(){return disableEventListeners.call(this)}}]);return Popper}();Popper.Utils=(typeof window!=="undefined"?window:global).PopperUtils;Popper.placements=placements;Popper.Defaults=Defaults;return Popper}))}).call(this,__webpack_require__(106))},739:function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;var _react=__webpack_require__(10);var _react2=_interopRequireDefault(_react);var _implementation=__webpack_require__(740);var _implementation2=_interopRequireDefault(_implementation);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}exports.default=_react2.default.createContext||_implementation2.default;module.exports=exports["default"]},740:function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;var _react=__webpack_require__(10);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(122);var _propTypes2=_interopRequireDefault(_propTypes);var _gud=__webpack_require__(741);var _gud2=_interopRequireDefault(_gud);var _warning=__webpack_require__(369);var _warning2=_interopRequireDefault(_warning);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var MAX_SIGNED_31_BIT_INT=1073741823;function objectIs(x,y){if(x===y){return x!==0||1/x===1/y}else{return x!==x&&y!==y}}function createEventEmitter(value){var handlers=[];return{on:function on(handler){handlers.push(handler)},off:function off(handler){handlers=handlers.filter((function(h){return h!==handler}))},get:function get(){return value},set:function set(newValue,changedBits){value=newValue;handlers.forEach((function(handler){return handler(value,changedBits)}))}}}function onlyChild(children){return Array.isArray(children)?children[0]:children}function createReactContext(defaultValue,calculateChangedBits){var _Provider$childContex,_Consumer$contextType;var contextProp="__create-react-context-"+(0,_gud2.default)()+"__";var Provider=function(_Component){_inherits(Provider,_Component);function Provider(){var _temp,_this,_ret;_classCallCheck(this,Provider);for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}return _ret=(_temp=(_this=_possibleConstructorReturn(this,_Component.call.apply(_Component,[this].concat(args))),_this),_this.emitter=createEventEmitter(_this.props.value),_temp),_possibleConstructorReturn(_this,_ret)}Provider.prototype.getChildContext=function getChildContext(){var _ref;return _ref={},_ref[contextProp]=this.emitter,_ref};Provider.prototype.componentWillReceiveProps=function componentWillReceiveProps(nextProps){if(this.props.value!==nextProps.value){var oldValue=this.props.value;var newValue=nextProps.value;var changedBits=void 0;if(objectIs(oldValue,newValue)){changedBits=0}else{changedBits=typeof calculateChangedBits==="function"?calculateChangedBits(oldValue,newValue):MAX_SIGNED_31_BIT_INT;if(false){}changedBits|=0;if(changedBits!==0){this.emitter.set(nextProps.value,changedBits)}}}};Provider.prototype.render=function render(){return this.props.children};return Provider}(_react.Component);Provider.childContextTypes=(_Provider$childContex={},_Provider$childContex[contextProp]=_propTypes2.default.object.isRequired,_Provider$childContex);var Consumer=function(_Component2){_inherits(Consumer,_Component2);function Consumer(){var _temp2,_this2,_ret2;_classCallCheck(this,Consumer);for(var _len2=arguments.length,args=Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}return _ret2=(_temp2=(_this2=_possibleConstructorReturn(this,_Component2.call.apply(_Component2,[this].concat(args))),_this2),_this2.state={value:_this2.getValue()},_this2.onUpdate=function(newValue,changedBits){var observedBits=_this2.observedBits|0;if((observedBits&changedBits)!==0){_this2.setState({value:_this2.getValue()})}},_temp2),_possibleConstructorReturn(_this2,_ret2)}Consumer.prototype.componentWillReceiveProps=function componentWillReceiveProps(nextProps){var observedBits=nextProps.observedBits;this.observedBits=observedBits===undefined||observedBits===null?MAX_SIGNED_31_BIT_INT:observedBits};Consumer.prototype.componentDidMount=function componentDidMount(){if(this.context[contextProp]){this.context[contextProp].on(this.onUpdate)}var observedBits=this.props.observedBits;this.observedBits=observedBits===undefined||observedBits===null?MAX_SIGNED_31_BIT_INT:observedBits};Consumer.prototype.componentWillUnmount=function componentWillUnmount(){if(this.context[contextProp]){this.context[contextProp].off(this.onUpdate)}};Consumer.prototype.getValue=function getValue(){if(this.context[contextProp]){return this.context[contextProp].get()}else{return defaultValue}};Consumer.prototype.render=function render(){return onlyChild(this.props.children)(this.state.value)};return Consumer}(_react.Component);Consumer.contextTypes=(_Consumer$contextType={},_Consumer$contextType[contextProp]=_propTypes2.default.object,_Consumer$contextType);return{Provider:Provider,Consumer:Consumer}}exports.default=createReactContext;module.exports=exports["default"]},741:function(module,exports,__webpack_require__){"use strict";(function(global){var key="__global_unique_id__";module.exports=function(){return global[key]=(global[key]||0)+1}}).call(this,__webpack_require__(106))},742:function(module,exports,__webpack_require__){"use strict";var _interopRequireWildcard=__webpack_require__(211);var _interopRequireDefault=__webpack_require__(210);Object.defineProperty(exports,"__esModule",{value:true});exports.default=Reference;var _extends2=_interopRequireDefault(__webpack_require__(359));var _assertThisInitialized2=_interopRequireDefault(__webpack_require__(253));var _inheritsLoose2=_interopRequireDefault(__webpack_require__(254));var _defineProperty2=_interopRequireDefault(__webpack_require__(255));var React=_interopRequireWildcard(__webpack_require__(10));var _warning=_interopRequireDefault(__webpack_require__(369));var _Manager=__webpack_require__(256);var _utils=__webpack_require__(370);var InnerReference=function(_React$Component){(0,_inheritsLoose2.default)(InnerReference,_React$Component);function InnerReference(){var _this;for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}_this=_React$Component.call.apply(_React$Component,[this].concat(args))||this;(0,_defineProperty2.default)((0,_assertThisInitialized2.default)(_this),"refHandler",(function(node){(0,_utils.setRef)(_this.props.innerRef,node);(0,_utils.safeInvoke)(_this.props.setReferenceNode,node)}));return _this}var _proto=InnerReference.prototype;_proto.componentWillUnmount=function componentWillUnmount(){(0,_utils.setRef)(this.props.innerRef,null)};_proto.render=function render(){(0,_warning.default)(Boolean(this.props.setReferenceNode),"`Reference` should not be used outside of a `Manager` component.");return(0,_utils.unwrapArray)(this.props.children)({ref:this.refHandler})};return InnerReference}(React.Component);function Reference(props){return React.createElement(_Manager.ManagerReferenceNodeSetterContext.Consumer,null,(function(setReferenceNode){return React.createElement(InnerReference,(0,_extends2.default)({setReferenceNode:setReferenceNode},props))}))}},744:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(745);case"v7light":return __webpack_require__(747);case"v8dark":return __webpack_require__(749);case"v8light":return __webpack_require__(751)}},745:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(746);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},746:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".ml-explorer {\n  width: 100%;\n  display: inline-block;\n  color: #98A2B3; }\n  .ml-explorer .mlAnomalyExplorer__filterBar {\n    padding-right: 16px;\n    padding-left: 16px; }\n  .ml-explorer .results-container {\n    padding: 0 0 16px 0; }\n    .ml-explorer .results-container .col-xs-12 {\n      width: calc(100% - 32px);\n      padding-left: 16px; }\n    .ml-explorer .results-container .no-influencers-warning {\n      float: left;\n      padding-top: 4px;\n      padding-left: 16px;\n      color: #98A2B3;\n      font-size: 14px; }\n    .ml-explorer .results-container .panel-title {\n      font-size: 18px;\n      font-weight: 400;\n      color: #98A2B3;\n      display: inline-block;\n      padding-bottom: 4px; }\n    .ml-explorer .results-container .panel-sub-title {\n      color: #98A2B3;\n      font-size: 12px; }\n  .ml-explorer .ml-anomalies-controls {\n    padding-top: 4px; }\n    .ml-explorer .ml-anomalies-controls #show_charts_checkbox_control {\n      padding-top: 24px; }\n\n.mlSwimLaneContainer {\n  /* Override legend styles */ }\n  .mlSwimLaneContainer .echLegendListContainer {\n    height: 34px !important; }\n  .mlSwimLaneContainer .echLegendList {\n    display: flex !important;\n    justify-content: space-between !important;\n    flex-wrap: nowrap;\n    position: absolute;\n    right: 0; }\n",""]);module.exports=exports},747:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(748);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},748:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".ml-explorer {\n  width: 100%;\n  display: inline-block;\n  color: #69707D; }\n  .ml-explorer .mlAnomalyExplorer__filterBar {\n    padding-right: 16px;\n    padding-left: 16px; }\n  .ml-explorer .results-container {\n    padding: 0 0 16px 0; }\n    .ml-explorer .results-container .col-xs-12 {\n      width: calc(100% - 32px);\n      padding-left: 16px; }\n    .ml-explorer .results-container .no-influencers-warning {\n      float: left;\n      padding-top: 4px;\n      padding-left: 16px;\n      color: #69707D;\n      font-size: 14px; }\n    .ml-explorer .results-container .panel-title {\n      font-size: 18px;\n      font-weight: 400;\n      color: #69707D;\n      display: inline-block;\n      padding-bottom: 4px; }\n    .ml-explorer .results-container .panel-sub-title {\n      color: #69707D;\n      font-size: 12px; }\n  .ml-explorer .ml-anomalies-controls {\n    padding-top: 4px; }\n    .ml-explorer .ml-anomalies-controls #show_charts_checkbox_control {\n      padding-top: 24px; }\n\n.mlSwimLaneContainer {\n  /* Override legend styles */ }\n  .mlSwimLaneContainer .echLegendListContainer {\n    height: 34px !important; }\n  .mlSwimLaneContainer .echLegendList {\n    display: flex !important;\n    justify-content: space-between !important;\n    flex-wrap: nowrap;\n    position: absolute;\n    right: 0; }\n",""]);module.exports=exports},749:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(750);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},750:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".ml-explorer {\n  width: 100%;\n  display: inline-block;\n  color: #98A2B3; }\n  .ml-explorer .mlAnomalyExplorer__filterBar {\n    padding-right: 16px;\n    padding-left: 16px; }\n  .ml-explorer .results-container {\n    padding: 0 0 16px 0; }\n    .ml-explorer .results-container .col-xs-12 {\n      width: calc(100% - 32px);\n      padding-left: 16px; }\n    .ml-explorer .results-container .no-influencers-warning {\n      float: left;\n      padding-top: 4px;\n      padding-left: 16px;\n      color: #98A2B3;\n      font-size: 14px; }\n    .ml-explorer .results-container .panel-title {\n      font-size: 16px;\n      font-weight: 400;\n      color: #98A2B3;\n      display: inline-block;\n      padding-bottom: 4px; }\n    .ml-explorer .results-container .panel-sub-title {\n      color: #98A2B3;\n      font-size: 12px; }\n  .ml-explorer .ml-anomalies-controls {\n    padding-top: 4px; }\n    .ml-explorer .ml-anomalies-controls #show_charts_checkbox_control {\n      padding-top: 24px; }\n\n.mlSwimLaneContainer {\n  /* Override legend styles */ }\n  .mlSwimLaneContainer .echLegendListContainer {\n    height: 34px !important; }\n  .mlSwimLaneContainer .echLegendList {\n    display: flex !important;\n    justify-content: space-between !important;\n    flex-wrap: nowrap;\n    position: absolute;\n    right: 0; }\n",""]);module.exports=exports},751:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(752);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},752:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".ml-explorer {\n  width: 100%;\n  display: inline-block;\n  color: #69707D; }\n  .ml-explorer .mlAnomalyExplorer__filterBar {\n    padding-right: 16px;\n    padding-left: 16px; }\n  .ml-explorer .results-container {\n    padding: 0 0 16px 0; }\n    .ml-explorer .results-container .col-xs-12 {\n      width: calc(100% - 32px);\n      padding-left: 16px; }\n    .ml-explorer .results-container .no-influencers-warning {\n      float: left;\n      padding-top: 4px;\n      padding-left: 16px;\n      color: #69707D;\n      font-size: 14px; }\n    .ml-explorer .results-container .panel-title {\n      font-size: 16px;\n      font-weight: 400;\n      color: #69707D;\n      display: inline-block;\n      padding-bottom: 4px; }\n    .ml-explorer .results-container .panel-sub-title {\n      color: #69707D;\n      font-size: 12px; }\n  .ml-explorer .ml-anomalies-controls {\n    padding-top: 4px; }\n    .ml-explorer .ml-anomalies-controls #show_charts_checkbox_control {\n      padding-top: 24px; }\n\n.mlSwimLaneContainer {\n  /* Override legend styles */ }\n  .mlSwimLaneContainer .echLegendListContainer {\n    height: 34px !important; }\n  .mlSwimLaneContainer .echLegendList {\n    display: flex !important;\n    justify-content: space-between !important;\n    flex-wrap: nowrap;\n    position: absolute;\n    right: 0; }\n",""]);module.exports=exports},95:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return getTimeBucketsFromCache}));__webpack_require__.d(__webpack_exports__,"a",(function(){return TimeBuckets}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getBoundsRoundedToInterval}));var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var external_kbnSharedDeps_Moment_=__webpack_require__(12);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var elastic_datemath=__webpack_require__(26);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);const{duration:d}=external_kbnSharedDeps_Moment_default.a;function timeBucketsCalcAutoIntervalProvider(){const roundingRules=[[d(500,"ms"),d(100,"ms")],[d(5,"second"),d(1,"second")],[d(10,"second"),d(5,"second")],[d(15,"second"),d(10,"second")],[d(30,"second"),d(15,"second")],[d(1,"minute"),d(30,"second")],[d(5,"minute"),d(1,"minute")],[d(10,"minute"),d(5,"minute")],[d(15,"minute"),d(10,"minute")],[d(30,"minute"),d(10,"minute")],[d(1,"hour"),d(30,"minute")],[d(2,"hour"),d(1,"hour")],[d(4,"hour"),d(2,"hour")],[d(6,"hour"),d(4,"hour")],[d(8,"hour"),d(6,"hour")],[d(12,"hour"),d(8,"hour")],[d(24,"hour"),d(12,"hour")],[d(2,"d"),d(1,"d")],[d(4,"d"),d(2,"d")],[d(1,"week"),d(4,"d")],[d(1,"month"),d(1,"week")],[d(1,"year"),d(1,"month")],[Infinity,d(1,"year")]];const revRoundingRules=roundingRules.slice(0).reverse();function find(rules,check,last){function pick(buckets,duration){const target=duration/buckets;let lastResp;for(let i=0;i<rules.length;i++){const rule=rules[i];const resp=check(rule[0],rule[1],target);if(resp==null){if(!last){continue}if(lastResp){return lastResp}break}if(!last){return resp}lastResp=resp}const ms=Math.max(Math.floor(target),1);return external_kbnSharedDeps_Moment_default.a.duration(ms,"ms")}return function(buckets,duration){const interval=pick(buckets,duration);if(interval){return external_kbnSharedDeps_Moment_default.a.duration(interval._data)}}}return{near:find(revRoundingRules,(function near(upperBound,lowerBound,target){if(upperBound>target){if(upperBound===Infinity){return lowerBound}const boundMs=upperBound.asMilliseconds();const intervalMs=lowerBound.asMilliseconds();const retInterval=Math.abs(boundMs-target)<=Math.abs(intervalMs)?upperBound:lowerBound;return retInterval}}),true),lessThan:find(revRoundingRules,(function(upperBound,lowerBound,target){if(lowerBound<target){return upperBound!==Infinity?upperBound:lowerBound}})),atLeast:find(revRoundingRules,(function atLeast(upperBound,lowerBound,target){if(lowerBound<=target){return lowerBound}}))}}var parse_interval=__webpack_require__(22);var dependency_cache=__webpack_require__(18);var public_=__webpack_require__(35);const unitsDesc=elastic_datemath_default.a.unitsDesc;const timeUnitsMaxSupportedIndex=unitsDesc.indexOf("w");const calcAuto=timeBucketsCalcAutoIntervalProvider();function getTimeBucketsFromCache(){const uiSettings=Object(dependency_cache["k"])();return new TimeBuckets({[public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS]:uiSettings.get(public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS),[public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET]:uiSettings.get(public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET),dateFormat:uiSettings.get("dateFormat"),"dateFormat:scaled":uiSettings.get("dateFormat:scaled")})}function TimeBuckets(timeBucketsConfig){this._timeBucketsConfig=timeBucketsConfig;this.barTarget=this._timeBucketsConfig[public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET];this.maxBars=this._timeBucketsConfig[public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS]}TimeBuckets.prototype.setBarTarget=function(bt){this.barTarget=bt};TimeBuckets.prototype.setMaxBars=function(mb){this.maxBars=mb};TimeBuckets.prototype.setBounds=function(input){if(!input)return this.clearBounds();let bounds;if(Object(external_kbnSharedDeps_Lodash_["isPlainObject"])(input)){bounds=[input.min,input.max]}else{bounds=Array.isArray(input)?input:[]}const moments=Object(external_kbnSharedDeps_Lodash_["sortBy"])(bounds.map(Object(external_kbnSharedDeps_Lodash_["ary"])(external_kbnSharedDeps_Moment_default.a,1)),Number);const valid=moments.length===2&&moments.every(isValidMoment);if(!valid){this.clearBounds();throw new Error("invalid bounds set: "+input)}this._lb=moments.shift();this._ub=moments.pop();if(this.getDuration().asSeconds()<0){throw new TypeError("Intervals must be positive")}};TimeBuckets.prototype.clearBounds=function(){this._lb=this._ub=null};TimeBuckets.prototype.hasBounds=function(){return isValidMoment(this._ub)&&isValidMoment(this._lb)};TimeBuckets.prototype.getBounds=function(){if(!this.hasBounds())return;return{min:this._lb,max:this._ub}};TimeBuckets.prototype.getDuration=function(){if(!this.hasBounds())return;return external_kbnSharedDeps_Moment_default.a.duration(this._ub-this._lb,"ms")};TimeBuckets.prototype.setInterval=function(input){this.originalInterval=input;let interval=input;if(!interval||interval==="auto"){this._i="auto";return}if(Object(external_kbnSharedDeps_Lodash_["isString"])(interval)){input=interval;interval=Object(parse_interval["a"])(interval);if(+interval===0){interval=null}}if(!external_kbnSharedDeps_Moment_default.a.isDuration(interval)){throw new TypeError('"'+input+'" is not a valid interval.')}this._i=interval};TimeBuckets.prototype.getInterval=function(){const self=this;const duration=self.getDuration();return decorateInterval(maybeScaleInterval(readInterval()),duration);function readInterval(){const interval=self._i;if(external_kbnSharedDeps_Moment_default.a.isDuration(interval))return interval;return calcAuto.near(self.barTarget,duration)}function maybeScaleInterval(interval){if(!self.hasBounds())return interval;const maxLength=self.maxBars;const approxLen=duration/interval;let scaled;if(approxLen>maxLength){scaled=calcAuto.lessThan(maxLength,duration)}else{return interval}if(+scaled===+interval)return interval;decorateInterval(interval,duration);return Object(external_kbnSharedDeps_Lodash_["assign"])(scaled,{preScaled:interval,scale:interval/scaled,scaled:true})}};TimeBuckets.prototype.getIntervalToNearestMultiple=function(divisorSecs){const interval=this.getInterval();const intervalSecs=interval.asSeconds();const remainder=intervalSecs%divisorSecs;if(remainder===0){return interval}let nearestMultiple=remainder>divisorSecs/2?intervalSecs+divisorSecs-remainder:intervalSecs-remainder;nearestMultiple=nearestMultiple===0?divisorSecs:nearestMultiple;const nearestMultipleInt=external_kbnSharedDeps_Moment_default.a.duration(nearestMultiple,"seconds");decorateInterval(nearestMultipleInt,this.getDuration());const preScaled=interval.preScaled;if(preScaled!==undefined&&preScaled<nearestMultipleInt){nearestMultipleInt.preScaled=preScaled;nearestMultipleInt.scale=preScaled/nearestMultipleInt;nearestMultipleInt.scaled=true}return nearestMultipleInt};TimeBuckets.prototype.getScaledDateFormat=function(){const interval=this.getInterval();const rules=this._timeBucketsConfig["dateFormat:scaled"];for(let i=rules.length-1;i>=0;i--){const rule=rules[i];if(!rule[0]||interval>=external_kbnSharedDeps_Moment_default.a.duration(rule[0])){return rule[1]}}return this._timeBucketsConfig.dateFormat};TimeBuckets.prototype.getScaledDateFormatter=function(){const fieldFormats=Object(dependency_cache["c"])();const DateFieldFormat=fieldFormats.getType(public_["FIELD_FORMAT_IDS"].DATE);return new DateFieldFormat({pattern:this.getScaledDateFormat()},this._timeBucketsConfig)};function decorateInterval(interval,originalDuration){const esInterval=calcEsInterval(interval);interval.esValue=esInterval.value;interval.esUnit=esInterval.unit;interval.expression=esInterval.expression;interval.overflow=originalDuration>interval?external_kbnSharedDeps_Moment_default.a.duration(interval-originalDuration):false;const prettyUnits=external_kbnSharedDeps_Moment_default.a.normalizeUnits(esInterval.unit);if(esInterval.value===1){interval.description=prettyUnits}else{interval.description=`${esInterval.value} ${prettyUnits}s`}return interval}function isValidMoment(m){return m&&"isValid"in m&&m.isValid()}function getBoundsRoundedToInterval(bounds,interval,inclusiveEnd=false){const intervalMs=interval.asMilliseconds();const adjustedMinMs=Math.floor(bounds.min.valueOf()/intervalMs)*intervalMs;let adjustedMaxMs=Math.ceil(bounds.max.valueOf()/intervalMs)*intervalMs;if(inclusiveEnd===false){adjustedMaxMs=adjustedMaxMs-1}return{min:external_kbnSharedDeps_Moment_default()(adjustedMinMs),max:external_kbnSharedDeps_Moment_default()(adjustedMaxMs)}}function calcEsInterval(duration){for(let i=0;i<unitsDesc.length;i++){const unit=unitsDesc[i];const val=duration.as(unit);if(val>=1&&Math.floor(val)===val){if(i<=timeUnitsMaxSupportedIndex){continue}return{value:val,unit:unit,expression:val+unit}}}const ms=duration.as("ms");return{value:ms,unit:"ms",expression:ms+"ms"}}}}]);