/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["ml_bundle_jsonpfunction"]=window["ml_bundle_jsonpfunction"]||[]).push([[21],{844:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"EmbeddableSwimLaneContainer",(function(){return EmbeddableSwimLaneContainer}));var external_kbnSharedDeps_React_=__webpack_require__(10);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(33);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(34);var external_kbnSharedDeps_Rxjs_=__webpack_require__(19);var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var external_kbnSharedDeps_RxjsOperators_=__webpack_require__(21);var time_buckets=__webpack_require__(95);var explorer_constants=__webpack_require__(69);var public_=__webpack_require__(35);var parse_interval=__webpack_require__(22);var swimlane_container=__webpack_require__(154);var embeddable_public_=__webpack_require__(41);var constants=__webpack_require__(27);const FETCH_RESULTS_DEBOUNCE_MS=500;function getJobsObservable(embeddableInput,anomalyDetectorService,setErrorHandler){return embeddableInput.pipe(Object(external_kbnSharedDeps_RxjsOperators_["pluck"])("jobIds"),Object(external_kbnSharedDeps_RxjsOperators_["distinctUntilChanged"])(external_kbnSharedDeps_Lodash_["isEqual"]),Object(external_kbnSharedDeps_RxjsOperators_["switchMap"])(jobsIds=>anomalyDetectorService.getJobs$(jobsIds)),Object(external_kbnSharedDeps_RxjsOperators_["catchError"])(e=>{var _e$body;setErrorHandler((_e$body=e.body)!==null&&_e$body!==void 0?_e$body:e);return Object(external_kbnSharedDeps_Rxjs_["of"])(undefined)}))}function useSwimlaneInputResolver(embeddableInput,onInputChange,refresh,services,chartWidth,fromPage){const[{uiSettings:uiSettings},,{anomalyTimelineService:anomalyTimelineService,anomalyDetectorService:anomalyDetectorService}]=services;const[swimlaneData,setSwimlaneData]=Object(external_kbnSharedDeps_React_["useState"])();const[swimlaneType,setSwimlaneType]=Object(external_kbnSharedDeps_React_["useState"])();const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])();const[perPage,setPerPage]=Object(external_kbnSharedDeps_React_["useState"])();const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const chartWidth$=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new external_kbnSharedDeps_Rxjs_["Subject"],[]);const fromPage$=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new external_kbnSharedDeps_Rxjs_["Subject"],[]);const perPage$=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new external_kbnSharedDeps_Rxjs_["Subject"],[]);const timeBuckets=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new time_buckets["a"]({"histogram:maxBars":uiSettings.get(public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS),"histogram:barTarget":uiSettings.get(public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET),dateFormat:uiSettings.get("dateFormat"),"dateFormat:scaled":uiSettings.get("dateFormat:scaled")}),[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const subscription=Object(external_kbnSharedDeps_Rxjs_["combineLatest"])([getJobsObservable(embeddableInput,anomalyDetectorService,setError),embeddableInput,chartWidth$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["skipWhile"])(v=>!v)),fromPage$,perPage$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["startWith"])(undefined),Object(external_kbnSharedDeps_RxjsOperators_["distinctUntilChanged"])((prev,curr)=>prev===undefined&&curr===explorer_constants["i"])),refresh.pipe(Object(external_kbnSharedDeps_RxjsOperators_["startWith"])(null))]).pipe(Object(external_kbnSharedDeps_RxjsOperators_["tap"])(setIsLoading.bind(null,true)),Object(external_kbnSharedDeps_RxjsOperators_["debounceTime"])(FETCH_RESULTS_DEBOUNCE_MS),Object(external_kbnSharedDeps_RxjsOperators_["switchMap"])(([jobs,input,swimlaneContainerWidth,fromPageInput,perPageFromState])=>{if(!jobs){return Object(external_kbnSharedDeps_Rxjs_["of"])(undefined)}const{viewBy:viewBy,swimlaneType:swimlaneTypeInput,perPage:perPageInput,timeRange:timeRange,filters:filters,query:query,viewMode:viewMode}=input;anomalyTimelineService.setTimeRange(timeRange);if(!swimlaneType){setSwimlaneType(swimlaneTypeInput)}const explorerJobs=jobs.map(job=>{const bucketSpan=Object(parse_interval["a"])(job.analysis_config.bucket_span);return{id:job.job_id,selected:true,bucketSpanSeconds:bucketSpan.asSeconds()}});let appliedFilters;try{appliedFilters=processFilters(filters,query)}catch(e){setError(e);return Object(external_kbnSharedDeps_Rxjs_["of"])(undefined)}return Object(external_kbnSharedDeps_Rxjs_["from"])(anomalyTimelineService.loadOverallData(explorerJobs,swimlaneContainerWidth)).pipe(Object(external_kbnSharedDeps_RxjsOperators_["switchMap"])(overallSwimlaneData=>{const{earliest:earliest,latest:latest}=overallSwimlaneData;if(overallSwimlaneData&&swimlaneTypeInput===explorer_constants["h"].VIEW_BY){var _ref;if(perPageFromState===undefined){setPerPage(perPageInput!==null&&perPageInput!==void 0?perPageInput:explorer_constants["i"])}if(viewMode===embeddable_public_["ViewMode"].EDIT&&perPageFromState!==perPageInput){onInputChange({perPage:perPageFromState})}return Object(external_kbnSharedDeps_Rxjs_["from"])(anomalyTimelineService.loadViewBySwimlane([],{earliest:earliest,latest:latest},explorerJobs,viewBy,Object(swimlane_container["c"])(swimlaneData)?swimlaneData.cardinality:explorer_constants["a"],(_ref=perPageFromState!==null&&perPageFromState!==void 0?perPageFromState:perPageInput)!==null&&_ref!==void 0?_ref:explorer_constants["i"],fromPageInput,swimlaneContainerWidth,appliedFilters)).pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(viewBySwimlaneData=>({...viewBySwimlaneData,earliest:earliest,latest:latest})))}return Object(external_kbnSharedDeps_Rxjs_["of"])(overallSwimlaneData)}))}),Object(external_kbnSharedDeps_RxjsOperators_["catchError"])(e=>{setError(e.body);return Object(external_kbnSharedDeps_Rxjs_["of"])(undefined)})).subscribe(data=>{if(data!==undefined){setError(null);setSwimlaneData(data);setIsLoading(false)}});return()=>{subscription.unsubscribe()}},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{fromPage$.next(fromPage)},[fromPage]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(perPage===undefined)return;perPage$.next(perPage)},[perPage]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{chartWidth$.next(chartWidth)},[chartWidth]);return[swimlaneType,swimlaneData,perPage!==null&&perPage!==void 0?perPage:explorer_constants["i"],setPerPage,timeBuckets,isLoading,error]}function processFilters(filters,query){const inputQuery=query.language==="kuery"?public_["esKuery"].toElasticsearchQuery(public_["esKuery"].fromKueryExpression(query.query)):query.query;const must=[inputQuery];const mustNot=[];for(const filter of filters){if(filter.meta.disabled||filter.meta.controlledBy===constants["a"])continue;const{meta:{negate:negate,type:type,key:fieldName}}=filter;let filterQuery=filter.query;if(filterQuery===undefined&&type==="exists"){filterQuery={exists:{field:fieldName}}}if(negate){mustNot.push(filterQuery)}else{must.push(filterQuery)}}return{bool:{must:must,must_not:mustNot}}}var ui_actions=__webpack_require__(152);const EmbeddableSwimLaneContainer=({id:id,embeddableContext:embeddableContext,embeddableInput:embeddableInput,services:services,refresh:refresh,onInputChange:onInputChange,onOutputChange:onOutputChange})=>{const[chartWidth,setChartWidth]=Object(external_kbnSharedDeps_React_["useState"])(0);const[fromPage,setFromPage]=Object(external_kbnSharedDeps_React_["useState"])(1);const[{},{uiActions:uiActions}]=services;const[selectedCells,setSelectedCells]=Object(external_kbnSharedDeps_React_["useState"])();const[swimlaneType,swimlaneData,perPage,setPerPage,timeBuckets,isLoading,error]=useSwimlaneInputResolver(embeddableInput,onInputChange,refresh,services,chartWidth,fromPage);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{onOutputChange({perPage:perPage,fromPage:fromPage,interval:swimlaneData===null||swimlaneData===void 0?void 0:swimlaneData.interval})},[perPage,fromPage,swimlaneData]);const onCellsSelection=Object(external_kbnSharedDeps_React_["useCallback"])(update=>{setSelectedCells(update);if(update){uiActions.getTrigger(ui_actions["a"]).exec({embeddable:embeddableContext,data:update,updateCallback:setSelectedCells.bind(null,undefined)})}},[swimlaneData,perPage,fromPage,setSelectedCells]);if(error){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.swimlaneEmbeddable.errorMessage",defaultMessage:"Unable to load the ML swim lane data"}),color:"danger",iconType:"alert",style:{width:"100%"}},external_kbnSharedDeps_React_default.a.createElement("p",null,error.message))}return external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%",padding:"8px"},"data-test-subj":"mlAnomalySwimlaneEmbeddableWrapper"},external_kbnSharedDeps_React_default.a.createElement(swimlane_container["b"],{id:id,"data-test-subj":`mlSwimLaneEmbeddable_${embeddableContext.id}`,timeBuckets:timeBuckets,swimlaneData:swimlaneData,swimlaneType:swimlaneType,fromPage:fromPage,perPage:perPage,swimlaneLimit:Object(swimlane_container["c"])(swimlaneData)?swimlaneData.cardinality:undefined,onResize:setChartWidth,selection:selectedCells,onCellsSelection:onCellsSelection,onPaginationChange:update=>{if(update.fromPage){setFromPage(update.fromPage)}if(update.perPage){setFromPage(1);setPerPage(update.perPage)}},isLoading:isLoading,noDataWarning:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.swimlaneEmbeddable.noDataFound",defaultMessage:"No anomalies found"})}))};var embeddable_swim_lane_container=__webpack_exports__["default"]=EmbeddableSwimLaneContainer}}]);