/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["ml_bundle_jsonpfunction"]=window["ml_bundle_jsonpfunction"]||[]).push([[17],{371:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"AnomalyTimelineService",(function(){return AnomalyTimelineService}));var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(35);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__);var _util_time_buckets__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(95);var _explorer_explorer_constants__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(69);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class AnomalyTimelineService{constructor(timeFilter,uiSettings,mlResultsService){this.timeFilter=timeFilter;this.mlResultsService=mlResultsService;_defineProperty(this,"timeBuckets",void 0);_defineProperty(this,"_customTimeRange",void 0);this.timeBuckets=new _util_time_buckets__WEBPACK_IMPORTED_MODULE_1__["a"]({"histogram:maxBars":uiSettings.get(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__["UI_SETTINGS"].HISTOGRAM_MAX_BARS),"histogram:barTarget":uiSettings.get(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__["UI_SETTINGS"].HISTOGRAM_BAR_TARGET),dateFormat:uiSettings.get("dateFormat"),"dateFormat:scaled":uiSettings.get("dateFormat:scaled")});this.timeFilter.enableTimeRangeSelector()}setTimeRange(timeRange){this._customTimeRange=timeRange}getSwimlaneBucketInterval(selectedJobs,swimlaneContainerWidth){const bounds=this.getTimeBounds();if(bounds===undefined){throw new Error("timeRangeSelectorEnabled has to be enabled")}this.timeBuckets.setInterval("auto");this.timeBuckets.setBounds(bounds);const intervalSeconds=this.timeBuckets.getInterval().asSeconds();const timerangeSeconds=(bounds.max.valueOf()-bounds.min.valueOf())/1e3;const numBuckets=timerangeSeconds/intervalSeconds;const cellWidth=Math.floor(swimlaneContainerWidth/numBuckets*100)/100;if(cellWidth<8){this.timeBuckets.setInterval(intervalSeconds*2+"s")}const maxBucketSpanSeconds=selectedJobs.reduce((memo,job)=>Math.max(memo,job.bucketSpanSeconds),0);if(maxBucketSpanSeconds>intervalSeconds){this.timeBuckets.setInterval(maxBucketSpanSeconds+"s");this.timeBuckets.setBounds(bounds)}return this.timeBuckets.getInterval()}async loadOverallData(selectedJobs,chartWidth){const interval=this.getSwimlaneBucketInterval(selectedJobs,chartWidth);if(!selectedJobs||!selectedJobs.length){throw new Error("Explorer jobs collection is required")}const bounds=this.getTimeBounds();const searchBounds=Object(_util_time_buckets__WEBPACK_IMPORTED_MODULE_1__["b"])(bounds,interval,false);const selectedJobIds=selectedJobs.map(d=>d.id);const overallBucketsBounds=Object(_util_time_buckets__WEBPACK_IMPORTED_MODULE_1__["b"])(bounds,interval,true);const resp=await this.mlResultsService.getOverallBucketScores(selectedJobIds,1,overallBucketsBounds.min.valueOf(),overallBucketsBounds.max.valueOf(),interval.asSeconds()+"s");const overallSwimlaneData=this.processOverallResults(resp.results,searchBounds,interval.asSeconds());console.log("Explorer overall swim lane data set:",overallSwimlaneData);return overallSwimlaneData}async loadViewBySwimlane(fieldValues,bounds,selectedJobs,viewBySwimlaneFieldName,swimlaneLimit,perPage,fromPage,swimlaneContainerWidth,influencersFilterQuery){const timefilterBounds=this.getTimeBounds();if(timefilterBounds===undefined){throw new Error("timeRangeSelectorEnabled has to be enabled")}const swimlaneBucketInterval=this.getSwimlaneBucketInterval(selectedJobs,swimlaneContainerWidth);const searchBounds=Object(_util_time_buckets__WEBPACK_IMPORTED_MODULE_1__["b"])(timefilterBounds,swimlaneBucketInterval,false);const selectedJobIds=selectedJobs.map(d=>d.id);const intervalMs=swimlaneBucketInterval.asMilliseconds();let response;if(viewBySwimlaneFieldName===_explorer_explorer_constants__WEBPACK_IMPORTED_MODULE_2__["j"]){const jobIds=fieldValues!==undefined&&fieldValues.length>0?fieldValues:selectedJobIds;response=await this.mlResultsService.getScoresByBucket(jobIds,searchBounds.min.valueOf(),searchBounds.max.valueOf(),intervalMs,perPage,fromPage)}else{response=await this.mlResultsService.getInfluencerValueMaxScoreByTime(selectedJobIds,viewBySwimlaneFieldName,fieldValues,searchBounds.min.valueOf(),searchBounds.max.valueOf(),intervalMs,swimlaneLimit,perPage,fromPage,influencersFilterQuery)}if(response===undefined){return}const viewBySwimlaneData=this.processViewByResults(response.results,response.cardinality,fieldValues,bounds,viewBySwimlaneFieldName,swimlaneBucketInterval.asSeconds());console.log("Explorer view by swim lane data set:",viewBySwimlaneData);return viewBySwimlaneData}async loadViewByTopFieldValuesForSelectedTime(earliestMs,latestMs,selectedJobs,viewBySwimlaneFieldName,swimlaneLimit,perPage,fromPage,swimlaneContainerWidth){const selectedJobIds=selectedJobs.map(d=>d.id);if(viewBySwimlaneFieldName!==_explorer_explorer_constants__WEBPACK_IMPORTED_MODULE_2__["j"]){const resp=await this.mlResultsService.getTopInfluencers(selectedJobIds,earliestMs,latestMs,swimlaneLimit,perPage,fromPage);if(resp.influencers[viewBySwimlaneFieldName]===undefined){return[]}const topFieldValues=[];const topInfluencers=resp.influencers[viewBySwimlaneFieldName];if(Array.isArray(topInfluencers)){topInfluencers.forEach(influencerData=>{if(influencerData.maxAnomalyScore>0){topFieldValues.push(influencerData.influencerFieldValue)}})}return topFieldValues}else{const resp=await this.mlResultsService.getScoresByBucket(selectedJobIds,earliestMs,latestMs,this.getSwimlaneBucketInterval(selectedJobs,swimlaneContainerWidth).asMilliseconds(),swimlaneLimit);return Object.keys(resp.results)}}getTimeBounds(){return this._customTimeRange!==undefined?this.timeFilter.calculateBounds(this._customTimeRange):this.timeFilter.getBounds()}processOverallResults(scoresByTime,searchBounds,interval){const overallLabel=_explorer_explorer_constants__WEBPACK_IMPORTED_MODULE_2__["g"];const dataset={laneLabels:[overallLabel],points:[],interval:interval,earliest:searchBounds.min.valueOf()/1e3,latest:searchBounds.max.valueOf()/1e3};Object.entries(scoresByTime).forEach(([timeMs,score])=>{const time=+timeMs/1e3;dataset.points.push({laneLabel:overallLabel,time:time,value:score});dataset.earliest=Math.min(time,dataset.earliest);dataset.latest=Math.max(time+dataset.interval,dataset.latest)});return dataset}processViewByResults(scoresByInfluencerAndTime,cardinality,sortedLaneValues,bounds,viewBySwimlaneFieldName,interval){const dataset={fieldName:viewBySwimlaneFieldName,points:[],laneLabels:[],interval:interval,earliest:bounds.earliest,latest:bounds.latest,cardinality:cardinality};const maxScoreByLaneLabel={};Object.entries(scoresByInfluencerAndTime).forEach(([influencerFieldValue,influencerData])=>{dataset.laneLabels.push(influencerFieldValue);maxScoreByLaneLabel[influencerFieldValue]=0;Object.entries(influencerData).forEach(([timeMs,anomalyScore])=>{const time=+timeMs/1e3;dataset.points.push({laneLabel:influencerFieldValue,time:time,value:anomalyScore});maxScoreByLaneLabel[influencerFieldValue]=Math.max(maxScoreByLaneLabel[influencerFieldValue],anomalyScore)})});const sortValuesLength=sortedLaneValues.length;if(sortValuesLength===0){dataset.laneLabels=dataset.laneLabels.sort((a,b)=>maxScoreByLaneLabel[b]-maxScoreByLaneLabel[a])}else{dataset.laneLabels=dataset.laneLabels.sort((a,b)=>{let aIndex=sortedLaneValues.indexOf(a);let bIndex=sortedLaneValues.indexOf(b);aIndex=aIndex>-1?aIndex:sortValuesLength;bIndex=bIndex>-1?bIndex:sortValuesLength;return aIndex-bIndex})}return dataset}}},95:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return getTimeBucketsFromCache}));__webpack_require__.d(__webpack_exports__,"a",(function(){return TimeBuckets}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getBoundsRoundedToInterval}));var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var external_kbnSharedDeps_Moment_=__webpack_require__(12);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var elastic_datemath=__webpack_require__(26);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);const{duration:d}=external_kbnSharedDeps_Moment_default.a;function timeBucketsCalcAutoIntervalProvider(){const roundingRules=[[d(500,"ms"),d(100,"ms")],[d(5,"second"),d(1,"second")],[d(10,"second"),d(5,"second")],[d(15,"second"),d(10,"second")],[d(30,"second"),d(15,"second")],[d(1,"minute"),d(30,"second")],[d(5,"minute"),d(1,"minute")],[d(10,"minute"),d(5,"minute")],[d(15,"minute"),d(10,"minute")],[d(30,"minute"),d(10,"minute")],[d(1,"hour"),d(30,"minute")],[d(2,"hour"),d(1,"hour")],[d(4,"hour"),d(2,"hour")],[d(6,"hour"),d(4,"hour")],[d(8,"hour"),d(6,"hour")],[d(12,"hour"),d(8,"hour")],[d(24,"hour"),d(12,"hour")],[d(2,"d"),d(1,"d")],[d(4,"d"),d(2,"d")],[d(1,"week"),d(4,"d")],[d(1,"month"),d(1,"week")],[d(1,"year"),d(1,"month")],[Infinity,d(1,"year")]];const revRoundingRules=roundingRules.slice(0).reverse();function find(rules,check,last){function pick(buckets,duration){const target=duration/buckets;let lastResp;for(let i=0;i<rules.length;i++){const rule=rules[i];const resp=check(rule[0],rule[1],target);if(resp==null){if(!last){continue}if(lastResp){return lastResp}break}if(!last){return resp}lastResp=resp}const ms=Math.max(Math.floor(target),1);return external_kbnSharedDeps_Moment_default.a.duration(ms,"ms")}return function(buckets,duration){const interval=pick(buckets,duration);if(interval){return external_kbnSharedDeps_Moment_default.a.duration(interval._data)}}}return{near:find(revRoundingRules,(function near(upperBound,lowerBound,target){if(upperBound>target){if(upperBound===Infinity){return lowerBound}const boundMs=upperBound.asMilliseconds();const intervalMs=lowerBound.asMilliseconds();const retInterval=Math.abs(boundMs-target)<=Math.abs(intervalMs)?upperBound:lowerBound;return retInterval}}),true),lessThan:find(revRoundingRules,(function(upperBound,lowerBound,target){if(lowerBound<target){return upperBound!==Infinity?upperBound:lowerBound}})),atLeast:find(revRoundingRules,(function atLeast(upperBound,lowerBound,target){if(lowerBound<=target){return lowerBound}}))}}var parse_interval=__webpack_require__(22);var dependency_cache=__webpack_require__(18);var public_=__webpack_require__(35);const unitsDesc=elastic_datemath_default.a.unitsDesc;const timeUnitsMaxSupportedIndex=unitsDesc.indexOf("w");const calcAuto=timeBucketsCalcAutoIntervalProvider();function getTimeBucketsFromCache(){const uiSettings=Object(dependency_cache["k"])();return new TimeBuckets({[public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS]:uiSettings.get(public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS),[public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET]:uiSettings.get(public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET),dateFormat:uiSettings.get("dateFormat"),"dateFormat:scaled":uiSettings.get("dateFormat:scaled")})}function TimeBuckets(timeBucketsConfig){this._timeBucketsConfig=timeBucketsConfig;this.barTarget=this._timeBucketsConfig[public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET];this.maxBars=this._timeBucketsConfig[public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS]}TimeBuckets.prototype.setBarTarget=function(bt){this.barTarget=bt};TimeBuckets.prototype.setMaxBars=function(mb){this.maxBars=mb};TimeBuckets.prototype.setBounds=function(input){if(!input)return this.clearBounds();let bounds;if(Object(external_kbnSharedDeps_Lodash_["isPlainObject"])(input)){bounds=[input.min,input.max]}else{bounds=Array.isArray(input)?input:[]}const moments=Object(external_kbnSharedDeps_Lodash_["sortBy"])(bounds.map(Object(external_kbnSharedDeps_Lodash_["ary"])(external_kbnSharedDeps_Moment_default.a,1)),Number);const valid=moments.length===2&&moments.every(isValidMoment);if(!valid){this.clearBounds();throw new Error("invalid bounds set: "+input)}this._lb=moments.shift();this._ub=moments.pop();if(this.getDuration().asSeconds()<0){throw new TypeError("Intervals must be positive")}};TimeBuckets.prototype.clearBounds=function(){this._lb=this._ub=null};TimeBuckets.prototype.hasBounds=function(){return isValidMoment(this._ub)&&isValidMoment(this._lb)};TimeBuckets.prototype.getBounds=function(){if(!this.hasBounds())return;return{min:this._lb,max:this._ub}};TimeBuckets.prototype.getDuration=function(){if(!this.hasBounds())return;return external_kbnSharedDeps_Moment_default.a.duration(this._ub-this._lb,"ms")};TimeBuckets.prototype.setInterval=function(input){this.originalInterval=input;let interval=input;if(!interval||interval==="auto"){this._i="auto";return}if(Object(external_kbnSharedDeps_Lodash_["isString"])(interval)){input=interval;interval=Object(parse_interval["a"])(interval);if(+interval===0){interval=null}}if(!external_kbnSharedDeps_Moment_default.a.isDuration(interval)){throw new TypeError('"'+input+'" is not a valid interval.')}this._i=interval};TimeBuckets.prototype.getInterval=function(){const self=this;const duration=self.getDuration();return decorateInterval(maybeScaleInterval(readInterval()),duration);function readInterval(){const interval=self._i;if(external_kbnSharedDeps_Moment_default.a.isDuration(interval))return interval;return calcAuto.near(self.barTarget,duration)}function maybeScaleInterval(interval){if(!self.hasBounds())return interval;const maxLength=self.maxBars;const approxLen=duration/interval;let scaled;if(approxLen>maxLength){scaled=calcAuto.lessThan(maxLength,duration)}else{return interval}if(+scaled===+interval)return interval;decorateInterval(interval,duration);return Object(external_kbnSharedDeps_Lodash_["assign"])(scaled,{preScaled:interval,scale:interval/scaled,scaled:true})}};TimeBuckets.prototype.getIntervalToNearestMultiple=function(divisorSecs){const interval=this.getInterval();const intervalSecs=interval.asSeconds();const remainder=intervalSecs%divisorSecs;if(remainder===0){return interval}let nearestMultiple=remainder>divisorSecs/2?intervalSecs+divisorSecs-remainder:intervalSecs-remainder;nearestMultiple=nearestMultiple===0?divisorSecs:nearestMultiple;const nearestMultipleInt=external_kbnSharedDeps_Moment_default.a.duration(nearestMultiple,"seconds");decorateInterval(nearestMultipleInt,this.getDuration());const preScaled=interval.preScaled;if(preScaled!==undefined&&preScaled<nearestMultipleInt){nearestMultipleInt.preScaled=preScaled;nearestMultipleInt.scale=preScaled/nearestMultipleInt;nearestMultipleInt.scaled=true}return nearestMultipleInt};TimeBuckets.prototype.getScaledDateFormat=function(){const interval=this.getInterval();const rules=this._timeBucketsConfig["dateFormat:scaled"];for(let i=rules.length-1;i>=0;i--){const rule=rules[i];if(!rule[0]||interval>=external_kbnSharedDeps_Moment_default.a.duration(rule[0])){return rule[1]}}return this._timeBucketsConfig.dateFormat};TimeBuckets.prototype.getScaledDateFormatter=function(){const fieldFormats=Object(dependency_cache["c"])();const DateFieldFormat=fieldFormats.getType(public_["FIELD_FORMAT_IDS"].DATE);return new DateFieldFormat({pattern:this.getScaledDateFormat()},this._timeBucketsConfig)};function decorateInterval(interval,originalDuration){const esInterval=calcEsInterval(interval);interval.esValue=esInterval.value;interval.esUnit=esInterval.unit;interval.expression=esInterval.expression;interval.overflow=originalDuration>interval?external_kbnSharedDeps_Moment_default.a.duration(interval-originalDuration):false;const prettyUnits=external_kbnSharedDeps_Moment_default.a.normalizeUnits(esInterval.unit);if(esInterval.value===1){interval.description=prettyUnits}else{interval.description=`${esInterval.value} ${prettyUnits}s`}return interval}function isValidMoment(m){return m&&"isValid"in m&&m.isValid()}function getBoundsRoundedToInterval(bounds,interval,inclusiveEnd=false){const intervalMs=interval.asMilliseconds();const adjustedMinMs=Math.floor(bounds.min.valueOf()/intervalMs)*intervalMs;let adjustedMaxMs=Math.ceil(bounds.max.valueOf()/intervalMs)*intervalMs;if(inclusiveEnd===false){adjustedMaxMs=adjustedMaxMs-1}return{min:external_kbnSharedDeps_Moment_default()(adjustedMinMs),max:external_kbnSharedDeps_Moment_default()(adjustedMaxMs)}}function calcEsInterval(duration){for(let i=0;i<unitsDesc.length;i++){const unit=unitsDesc[i];const val=duration.as(unit);if(val>=1&&Math.floor(val)===val){if(i<=timeUnitsMaxSupportedIndex){continue}return{value:val,unit:unit,expression:val+unit}}}const ms=duration.as("ms");return{value:ms,unit:"ms",expression:ms+"ms"}}}}]);