/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["ml_bundle_jsonpfunction"]=window["ml_bundle_jsonpfunction"]||[]).push([[12],{101:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DATAFEED_STATE}));__webpack_require__.d(__webpack_exports__,"b",(function(){return FORECAST_REQUEST_STATE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return JOB_STATE}));let DATAFEED_STATE;(function(DATAFEED_STATE){DATAFEED_STATE["STARTED"]="started";DATAFEED_STATE["STARTING"]="starting";DATAFEED_STATE["STOPPED"]="stopped";DATAFEED_STATE["STOPPING"]="stopping";DATAFEED_STATE["DELETED"]="deleted"})(DATAFEED_STATE||(DATAFEED_STATE={}));let FORECAST_REQUEST_STATE;(function(FORECAST_REQUEST_STATE){FORECAST_REQUEST_STATE["FAILED"]="failed";FORECAST_REQUEST_STATE["FINISHED"]="finished";FORECAST_REQUEST_STATE["SCHEDULED"]="scheduled";FORECAST_REQUEST_STATE["STARTED"]="started"})(FORECAST_REQUEST_STATE||(FORECAST_REQUEST_STATE={}));let JOB_STATE;(function(JOB_STATE){JOB_STATE["CLOSED"]="closed";JOB_STATE["CLOSING"]="closing";JOB_STATE["FAILED"]="failed";JOB_STATE["OPENED"]="opened";JOB_STATE["OPENING"]="opening";JOB_STATE["DELETED"]="deleted"})(JOB_STATE||(JOB_STATE={}))},124:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return SEVERITY_OPTIONS}));__webpack_require__.d(__webpack_exports__,"c",(function(){return useTableSeverity}));__webpack_require__.d(__webpack_exports__,"b",(function(){return SelectSeverity}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(10);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(34);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(33);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__);var _common_util_anomaly_utils__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(6);var _util_url_state__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(70);var _common__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(13);const warningLabel=_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.ml.controls.selectSeverity.warningLabel",{defaultMessage:"warning"});const minorLabel=_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.ml.controls.selectSeverity.minorLabel",{defaultMessage:"minor"});const majorLabel=_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.ml.controls.selectSeverity.majorLabel",{defaultMessage:"major"});const criticalLabel=_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.ml.controls.selectSeverity.criticalLabel",{defaultMessage:"critical"});const optionsMap={[warningLabel]:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].LOW,[minorLabel]:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].MINOR,[majorLabel]:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].MAJOR,[criticalLabel]:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].CRITICAL};const SEVERITY_OPTIONS=[{val:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].LOW,display:warningLabel,color:Object(_common_util_anomaly_utils__WEBPACK_IMPORTED_MODULE_4__["i"])(_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].LOW)},{val:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].MINOR,display:minorLabel,color:Object(_common_util_anomaly_utils__WEBPACK_IMPORTED_MODULE_4__["i"])(_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].MINOR)},{val:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].MAJOR,display:majorLabel,color:Object(_common_util_anomaly_utils__WEBPACK_IMPORTED_MODULE_4__["i"])(_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].MAJOR)},{val:_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].CRITICAL,display:criticalLabel,color:Object(_common_util_anomaly_utils__WEBPACK_IMPORTED_MODULE_4__["i"])(_common__WEBPACK_IMPORTED_MODULE_6__["ANOMALY_THRESHOLD"].CRITICAL)}];function optionValueToThreshold(value){let threshold=SEVERITY_OPTIONS.find(opt=>opt.val===value);if(threshold===undefined){threshold=SEVERITY_OPTIONS[0]}return threshold}const TABLE_SEVERITY_DEFAULT=SEVERITY_OPTIONS[0];const useTableSeverity=()=>Object(_util_url_state__WEBPACK_IMPORTED_MODULE_5__["b"])("mlSelectSeverity",TABLE_SEVERITY_DEFAULT);const getSeverityOptions=()=>SEVERITY_OPTIONS.map(({color:color,display:display,val:val})=>({value:display,inputDisplay:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0__["Fragment"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiHealth"],{color:color,style:{lineHeight:"inherit"}},display)),dropdownDisplay:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0__["Fragment"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiHealth"],{color:color,style:{lineHeight:"inherit"}},display),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiSpacer"],{size:"xs"}),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiText"],{size:"xs",color:"subdued"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p",{className:"euiTextColor--subdued"},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__["FormattedMessage"],{id:"xpack.ml.controls.selectSeverity.scoreDetailsDescription",defaultMessage:"score {value} and above",values:{value:val}}))))}));const SelectSeverity=({classNames:classNames}={classNames:""})=>{const[severity,setSeverity]=useTableSeverity();const onChange=valueDisplay=>{setSeverity(optionValueToThreshold(optionsMap[valueDisplay]))};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiSuperSelect"],{className:classNames,hasDividers:true,options:getSeverityOptions(),valueOfSelected:severity.display,onChange:onChange})}},187:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return populateValidationMessages}));__webpack_require__.d(__webpack_exports__,"a",(function(){return invalidTimeIntervalMessage}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);var _common_constants_validation__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(23);var _services_ml_server_info__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(83);function populateValidationMessages(validationResults,basicValidations,jobConfig,datafeedConfig){const limits=Object(_services_ml_server_info__WEBPACK_IMPORTED_MODULE_2__["c"])();if(validationResults.contains("job_id_empty")){basicValidations.jobId.valid=false}else if(validationResults.contains("job_id_invalid")){basicValidations.jobId.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.jobNameAllowedCharactersDescription",{defaultMessage:"Job ID can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});basicValidations.jobId.message=msg}else if(validationResults.contains("job_id_invalid_max_length")){basicValidations.jobId.valid=false;basicValidations.jobId.message=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.jobIdInvalidMaxLengthErrorMessage",{defaultMessage:"Job ID must be no more than {maxLength, plural, one {# character} other {# characters}} long.",values:{maxLength:_common_constants_validation__WEBPACK_IMPORTED_MODULE_1__["b"]}})}else if(validationResults.contains("job_id_already_exists")){basicValidations.jobId.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.jobNameAlreadyExists",{defaultMessage:"Job ID already exists. A job ID cannot be the same as an existing job or group."});basicValidations.jobId.message=msg}if(validationResults.contains("job_group_id_invalid")){basicValidations.groupIds.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.jobGroupAllowedCharactersDescription",{defaultMessage:"Job group names can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; "+"must start and end with an alphanumeric character"});basicValidations.groupIds.message=msg}else if(validationResults.contains("job_group_id_invalid_max_length")){basicValidations.groupIds.valid=false;basicValidations.groupIds.message=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.jobGroupMaxLengthDescription",{defaultMessage:"Job group name must be no more than {maxLength, plural, one {# character} other {# characters}} long.",values:{maxLength:_common_constants_validation__WEBPACK_IMPORTED_MODULE_1__["b"]}})}else if(validationResults.contains("job_group_id_already_exists")){basicValidations.groupIds.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.groupNameAlreadyExists",{defaultMessage:"Group ID already exists. A group ID cannot be the same as an existing job or group."});basicValidations.groupIds.message=msg}if(validationResults.contains("model_memory_limit_units_invalid")){basicValidations.modelMemoryLimit.valid=false;const str=`${_common_constants_validation__WEBPACK_IMPORTED_MODULE_1__["a"].slice(0,_common_constants_validation__WEBPACK_IMPORTED_MODULE_1__["a"].length-1).join(", ")} or ${[..._common_constants_validation__WEBPACK_IMPORTED_MODULE_1__["a"]].pop()}`;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.modelMemoryLimitUnitsInvalidErrorMessage",{defaultMessage:"Model memory limit data unit unrecognized. It must be {str}",values:{str:str}});basicValidations.modelMemoryLimit.message=msg}if(validationResults.contains("model_memory_limit_invalid")){basicValidations.modelMemoryLimit.valid=false;const maxModelMemoryLimit=(limits.max_model_memory_limit||"").toUpperCase();const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.modelMemoryLimitRangeInvalidErrorMessage",{defaultMessage:"Model memory limit cannot be higher than the maximum value of {maxModelMemoryLimit}",values:{maxModelMemoryLimit:maxModelMemoryLimit}});basicValidations.modelMemoryLimit.message=msg}if(validationResults.contains("detectors_duplicates")){basicValidations.duplicateDetectors.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.duplicatedDetectorsErrorMessage",{defaultMessage:"Duplicate detectors were found."});basicValidations.duplicateDetectors.message=msg}if(validationResults.contains("categorizer_detector_missing_per_partition_field")){basicValidations.categorizerMissingPerPartition.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.categorizerMissingPerPartitionFieldMessage",{defaultMessage:'Partition field must be set for detectors that reference "mlcategory" when per-partition categorization is enabled.'});basicValidations.categorizerMissingPerPartition.message=msg}if(validationResults.contains("categorizer_varying_per_partition_fields")){basicValidations.categorizerVaryingPerPartitionField.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.categorizerVaryingPerPartitionFieldNamesMessage",{defaultMessage:'Detectors with keyword "mlcategory" cannot have different partition_field_name when per-partition categorization is enabled.'});basicValidations.categorizerVaryingPerPartitionField.message=msg}if(validationResults.contains("bucket_span_empty")){basicValidations.bucketSpan.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.bucketSpanMustBeSetErrorMessage",{defaultMessage:"Bucket span must be set"});basicValidations.bucketSpan.message=msg}else if(validationResults.contains("bucket_span_invalid")){basicValidations.bucketSpan.valid=false;basicValidations.bucketSpan.message=invalidTimeIntervalMessage(jobConfig.analysis_config.bucket_span)}if(validationResults.contains("query_empty")){basicValidations.query.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.queryCannotBeEmpty",{defaultMessage:"Datafeed query cannot be empty."});basicValidations.query.message=msg}else if(validationResults.contains("query_invalid")){basicValidations.query.valid=false;const msg=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.queryIsInvalidEsQuery",{defaultMessage:"Datafeed query must be a valid elasticsearch query."});basicValidations.query.message=msg}if(validationResults.contains("query_delay_invalid")){basicValidations.queryDelay.valid=false;basicValidations.queryDelay.message=invalidTimeIntervalMessage(datafeedConfig.query_delay)}if(validationResults.contains("frequency_invalid")){basicValidations.frequency.valid=false;basicValidations.frequency.message=invalidTimeIntervalMessage(datafeedConfig.frequency)}if(validationResults.contains("missing_summary_count_field_name")){basicValidations.summaryCountField.valid=false;basicValidations.summaryCountField.message=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.summaryCountFieldMissing",{defaultMessage:"Required field as the datafeed uses aggregations."})}}function invalidTimeIntervalMessage(value){return _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.ml.newJob.wizard.validateJob.frequencyInvalidTimeIntervalFormatErrorMessage",{defaultMessage:"{value} is not a valid time interval format e.g. {thirtySeconds}, {tenMinutes}, {oneHour}, {sevenDays}. It also needs to be higher than zero.",values:{value:value,thirtySeconds:"30s",tenMinutes:"10m",oneHour:"1h",sevenDays:"7d"}})}},249:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(10);var useEffectOnce=function(effect){react_1.useEffect(effect,[])};exports.default=useEffectOnce},771:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(772);case"v7light":return __webpack_require__(774);case"v8dark":return __webpack_require__(776);case"v8light":return __webpack_require__(778)}},772:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(773);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},773:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlSeverityControl .euiRangeLevel--success {\n  background-color: #8BC8FB; }\n\n.mlSeverityControl .euiRangeLevel--primary {\n  background-color: #FDEC25; }\n\n.mlSeverityControl .euiRangeLevel--warning {\n  background-color: #FBA740; }\n\n.mlSeverityControl .euiRangeLevel--danger {\n  background-color: #FE5050; }\n",""]);module.exports=exports},774:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(775);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},775:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlSeverityControl .euiRangeLevel--success {\n  background-color: #8BC8FB; }\n\n.mlSeverityControl .euiRangeLevel--primary {\n  background-color: #FDEC25; }\n\n.mlSeverityControl .euiRangeLevel--warning {\n  background-color: #FBA740; }\n\n.mlSeverityControl .euiRangeLevel--danger {\n  background-color: #FE5050; }\n",""]);module.exports=exports},776:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(777);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},777:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlSeverityControl .euiRangeLevel--success {\n  background-color: #8BC8FB; }\n\n.mlSeverityControl .euiRangeLevel--primary {\n  background-color: #FDEC25; }\n\n.mlSeverityControl .euiRangeLevel--warning {\n  background-color: #FBA740; }\n\n.mlSeverityControl .euiRangeLevel--danger {\n  background-color: #FE5050; }\n",""]);module.exports=exports},778:function(module,exports,__webpack_require__){var api=__webpack_require__(60);var content=__webpack_require__(779);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},779:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(61);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".mlSeverityControl .euiRangeLevel--success {\n  background-color: #8BC8FB; }\n\n.mlSeverityControl .euiRangeLevel--primary {\n  background-color: #FDEC25; }\n\n.mlSeverityControl .euiRangeLevel--warning {\n  background-color: #FBA740; }\n\n.mlSeverityControl .euiRangeLevel--danger {\n  background-color: #FE5050; }\n",""]);module.exports=exports},780:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(38);var useEffectOnce_1=tslib_1.__importDefault(__webpack_require__(249));var useMount=function(fn){useEffectOnce_1.default((function(){fn()}))};exports.default=useMount},83:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return loadMlServerInfo}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getNewJobDefaults}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getNewJobLimits}));__webpack_require__.d(__webpack_exports__,"d",(function(){return isCloud}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getCloudDeploymentId}));var _ml_api_service__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(59);let defaults={anomaly_detectors:{},datafeeds:{}};let limits={};const cloudInfo={cloudId:null,isCloud:false};async function loadMlServerInfo(){try{const resp=await _ml_api_service__WEBPACK_IMPORTED_MODULE_0__["ml"].mlInfo();defaults=resp.defaults;limits=resp.limits;cloudInfo.cloudId=resp.cloudId||null;cloudInfo.isCloud=resp.cloudId!==undefined;return{defaults:defaults,limits:limits,cloudId:cloudInfo}}catch(error){return{defaults:defaults,limits:limits,cloudId:cloudInfo}}}function getNewJobDefaults(){return defaults}function getNewJobLimits(){return limits}function getCloudId(){return cloudInfo.cloudId}function isCloud(){return cloudInfo.isCloud}function getCloudDeploymentId(){return cloudInfo.cloudId===null?null:extractDeploymentId(cloudInfo.cloudId)}function extractDeploymentId(cloudId){const tempCloudId=cloudId.replace(/^(.+)?:/,"");try{const matches=atob(tempCloudId).match(/^.+\$(.+)(?=\$)/);return matches!==null&&matches.length===2?matches[1]:null}catch(error){return null}}},841:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var external_kbnSharedDeps_React_=__webpack_require__(10);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(33);var useMount=__webpack_require__(780);var useMount_default=__webpack_require__.n(useMount);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(34);const JobSelectorControl=({jobsAndGroupIds:jobsAndGroupIds,onChange:onChange,adJobsApiService:adJobsApiService,errors:errors})=>{const[options,setOptions]=Object(external_kbnSharedDeps_React_["useState"])([]);const jobIds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new Set,[]);const groupIds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new Set,[]);const selectedOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(jobsAndGroupIds!==null&&jobsAndGroupIds!==void 0?jobsAndGroupIds:[]).map(v=>({label:v})),[jobsAndGroupIds]);const fetchOptions=Object(external_kbnSharedDeps_React_["useCallback"])(async()=>{try{const{jobIds:jobIdOptions,groupIds:groupIdOptions}=await adJobsApiService.getAllJobAndGroupIds();jobIdOptions.forEach(v=>{jobIds.add(v)});groupIdOptions.forEach(v=>{groupIds.add(v)});setOptions([{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.jobSelector.jobOptionsLabel",{defaultMessage:"Jobs"}),options:jobIdOptions.map(v=>({label:v}))},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.jobSelector.groupOptionsLabel",{defaultMessage:"Groups"}),options:groupIdOptions.map(v=>({label:v}))}])}catch(e){}},[adJobsApiService]);const onSelectionChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectionUpdate=>{const selectedJobIds=[];const selectedGroupIds=[];selectionUpdate.forEach(({label:label})=>{if(jobIds.has(label)){selectedJobIds.push(label)}else if(groupIds.has(label)){selectedGroupIds.push(label)}});onChange({...selectedJobIds.length>0?{jobIds:selectedJobIds}:{},...selectedGroupIds.length>0?{groupIds:selectedGroupIds}:{}})},[jobIds,groupIds]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{fetchOptions()},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.jobSelector.formControlLabel",defaultMessage:"Select jobs or groups"}),isInvalid:!!(errors!==null&&errors!==void 0&&errors.length),error:errors},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{selectedOptions:selectedOptions,options:options,onChange:onSelectionChange,fullWidth:true,"data-test-subj":"mlAnomalyAlertJobSelection",isInvalid:!!(errors!==null&&errors!==void 0&&errors.length)}))};var kibana=__webpack_require__(58);var jobs=__webpack_require__(284);var http_service=__webpack_require__(99);var select_severity=__webpack_require__(124);var common=__webpack_require__(13);var styles=__webpack_require__(771);const MAX_ANOMALY_SCORE=100;const SeverityControl=external_kbnSharedDeps_React_default.a.memo(({value:value,onChange:onChange})=>{const levels=[{min:common["ANOMALY_THRESHOLD"].LOW,max:common["ANOMALY_THRESHOLD"].MINOR-1,color:"success"},{min:common["ANOMALY_THRESHOLD"].MINOR,max:common["ANOMALY_THRESHOLD"].MAJOR-1,color:"primary"},{min:common["ANOMALY_THRESHOLD"].MAJOR,max:common["ANOMALY_THRESHOLD"].CRITICAL,color:"warning"},{min:common["ANOMALY_THRESHOLD"].CRITICAL,max:MAX_ANOMALY_SCORE,color:"danger"}];const toggleButtons=select_severity["a"].map(v=>({value:v.val,label:v.display}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.severitySelector.formControlLabel",defaultMessage:"Select severity threshold"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{className:"mlSeverityControl",fullWidth:true,min:common["ANOMALY_THRESHOLD"].LOW,max:MAX_ANOMALY_SCORE,value:value!==null&&value!==void 0?value:common["ANOMALY_THRESHOLD"].LOW,onChange:e=>{onChange(e.target.value)},showLabels:true,showValue:true,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.severitySelector.formControlLabel",{defaultMessage:"Select severity threshold"}),showTicks:true,ticks:toggleButtons,levels:levels,"data-test-subj":"mlAnomalyAlertScoreSelection"}))});var anomalies=__webpack_require__(1);const ResultTypeSelector=external_kbnSharedDeps_React_default.a.memo(({value:selectedResultType=[],onChange:onChange,availableOption:availableOption})=>{const resultTypeOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{value:anomalies["a"].BUCKET,title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.bucketResultType.title",defaultMessage:"Bucket"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.bucketResultType.description",defaultMessage:"How unusual was the job within the bucket of time?"})},{value:anomalies["a"].RECORD,title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.recordResultType.title",defaultMessage:"Record"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.recordResultType.description",defaultMessage:"What individual anomalies are present in a time range?"})},{value:anomalies["a"].INFLUENCER,title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.influencerResultType.title",defaultMessage:"Influencer"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.influencerResultType.description",defaultMessage:"What are the most unusual entities in a time range?"})}].filter(v=>availableOption.includes(v.value)),[availableOption]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.resultTypeSelector.formControlLabel",defaultMessage:"Result type"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},resultTypeOptions.map(({value:value,title:title,description:description})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:value},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCard"],{title:title,titleSize:"xs",paddingSize:"s",description:external_kbnSharedDeps_React_default.a.createElement("small",null,description),selectable:{onClick:()=>{if(selectedResultType===value){return}onChange(value)},isSelected:value===selectedResultType},"data-test-subj":`mlAnomalyAlertResult_${value}${value===selectedResultType?"_selected":""}`})))))});var app=__webpack_require__(4);const alertingApiProvider=httpService=>({preview(params){const body=JSON.stringify(params);return httpService.http({path:`${app["b"]}/alerting/preview`,method:"POST",body:body})}});var util_validators=__webpack_require__(14);var util=__webpack_require__(187);var alerts=__webpack_require__(28);const AlertInstancePreview=external_kbnSharedDeps_React_default.a.memo(({jobIds:jobIds,timestampIso8601:timestampIso8601,score:score,topInfluencers:topInfluencers,topRecords:topRecords})=>{const listItems=[{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.previewAlert.jobsLabel",{defaultMessage:"Job IDs:"}),description:jobIds.join(", ")},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.previewAlert.timeLabel",{defaultMessage:"Time: "}),description:timestampIso8601},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.previewAlert.scoreLabel",{defaultMessage:"Anomaly score:"}),description:score},...topInfluencers&&topInfluencers.length>0?[{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.previewAlert.topInfluencersLabel",{defaultMessage:"Top influencers:"}),description:external_kbnSharedDeps_React_default.a.createElement("ul",null,topInfluencers.map(i=>external_kbnSharedDeps_React_default.a.createElement("li",{key:i.unique_key},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],{transparentBackground:true},i.influencer_field_name)," ="," ",i.influencer_field_value," [",i.score,"]")))}]:[],...topRecords&&topRecords.length>0?[{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.previewAlert.topRecordsLabel",{defaultMessage:"Top records:"}),description:external_kbnSharedDeps_React_default.a.createElement("ul",null,topRecords.map(i=>external_kbnSharedDeps_React_default.a.createElement("li",{key:i.unique_key},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],{transparentBackground:true},i.function,"(",i.field_name,")")," ",i.by_field_value," ",i.over_field_value," ",i.partition_field_value," [",i.score,"]")))}]:[]];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{type:"row",compressed:true,listItems:listItems})});const PreviewAlertCondition=({alertingApiService:alertingApiService,alertParams:alertParams})=>{var _alertParams$jobSelec,_alertParams$jobSelec2,_alertParams$jobSelec3,_alertParams$jobSelec4;const sampleSize=alerts["a"];const[lookBehindInterval,setLookBehindInterval]=Object(external_kbnSharedDeps_React_["useState"])();const[areResultsVisible,setAreResultVisible]=Object(external_kbnSharedDeps_React_["useState"])(true);const[previewError,setPreviewError]=Object(external_kbnSharedDeps_React_["useState"])();const[previewResponse,setPreviewResponse]=Object(external_kbnSharedDeps_React_["useState"])();const validators=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(common["composeValidators"])(Object(util_validators["e"])(),Object(util_validators["f"])()),[]);const validationErrors=Object(external_kbnSharedDeps_React_["useMemo"])(()=>validators(lookBehindInterval),[lookBehindInterval]);Object(external_kbnSharedDeps_React_["useEffect"])((function resetPreview(){setPreviewResponse(undefined)}),[alertParams]);const testCondition=Object(external_kbnSharedDeps_React_["useCallback"])(async()=>{try{const response=await alertingApiService.preview({alertParams:alertParams,timeRange:lookBehindInterval,sampleSize:sampleSize});setPreviewResponse(response);setPreviewError(undefined)}catch(e){var _e$body;setPreviewResponse(undefined);setPreviewError((_e$body=e.body)!==null&&_e$body!==void 0?_e$body:e)}},[alertParams,lookBehindInterval]);const sampleHits=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!previewResponse)return;return previewResponse.results},[previewResponse]);const isReady=(((_alertParams$jobSelec=alertParams.jobSelection)===null||_alertParams$jobSelec===void 0?void 0:(_alertParams$jobSelec2=_alertParams$jobSelec.jobIds)===null||_alertParams$jobSelec2===void 0?void 0:_alertParams$jobSelec2.length)>0||((_alertParams$jobSelec3=alertParams.jobSelection)===null||_alertParams$jobSelec3===void 0?void 0:(_alertParams$jobSelec4=_alertParams$jobSelec3.groupIds)===null||_alertParams$jobSelec4===void 0?void 0:_alertParams$jobSelec4.length)>0)&&!!alertParams.resultType&&alertParams.severity!==undefined&&validationErrors===null;const isInvalid=lookBehindInterval!==undefined&&!!validationErrors;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.intervalLabel",defaultMessage:"Check the alert condition with an interval"}),isInvalid:isInvalid,error:Object(util["a"])(lookBehindInterval)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:"15d, 6m",value:lookBehindInterval,onChange:e=>{setLookBehindInterval(e.target.value)},isInvalid:isInvalid,"data-test-subj":"mlAnomalyAlertPreviewInterval"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:testCondition,disabled:!isReady,"data-test-subj":"mlAnomalyAlertPreviewButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.testButtonLabel",defaultMessage:"Test"})))),previewError!==undefined&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.previewErrorTitle",defaultMessage:"Unable to load the preview"}),color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,previewError.message))),previewResponse&&sampleHits&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs","data-test-subj":"mlAnomalyAlertPreviewMessage"},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.previewMessage",defaultMessage:"Triggers {alertsCount, plural, one {# time} other {# times}} in the last {interval}",values:{alertsCount:previewResponse.count,interval:lookBehindInterval}})))),sampleHits.length>0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",size:"xs",onClick:setAreResultVisible.bind(null,!areResultsVisible)},areResultsVisible?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.hideResultsButtonLabel",defaultMessage:"Hide results"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.showResultsButtonLabel",defaultMessage:"Show results"})))),areResultsVisible&&sampleHits.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{color:"subdued",borderRadius:"none",hasShadow:false,"data-test-subj":"mlAnomalyAlertPreviewCallout"},external_kbnSharedDeps_React_default.a.createElement("ul",null,sampleHits.map((v,i)=>external_kbnSharedDeps_React_default.a.createElement("li",{key:v.key},external_kbnSharedDeps_React_default.a.createElement(AlertInstancePreview,v),i!==sampleHits.length-1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"xs"}):null))),previewResponse.count>sampleSize?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("b",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.previewAlert.otherValuesLabel",defaultMessage:"and {count, plural, one {# other} other {# others}}",values:{count:previewResponse.count-sampleSize}})))):null):null))};const InterimResultsControl=external_kbnSharedDeps_React_default.a.memo(({value:value,onChange:onChange})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.interimResultsControl.label",defaultMessage:"Include interim results"}),checked:value,onChange:onChange.bind(null,!value)})));var parse_interval=__webpack_require__(22);var states=__webpack_require__(101);var job_utils=__webpack_require__(64);const ConfigValidator=external_kbnSharedDeps_React_default.a.memo(({jobConfigs:jobConfigs=[],alertInterval:alertInterval})=>{const resultBucketSpanInSeconds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(job_utils["s"])(jobConfigs.map(v=>v.analysis_config.bucket_span)),[jobConfigs]);const resultBucketSpanString=resultBucketSpanInSeconds%60===0?`${resultBucketSpanInSeconds/60}m`:`${resultBucketSpanInSeconds}s`;if(jobConfigs.length===0)return null;const alertIntervalInSeconds=Object(parse_interval["a"])(alertInterval).asSeconds();const isAlertIntervalTooHigh=resultBucketSpanInSeconds<alertIntervalInSeconds;const jobWithoutStartedDatafeed=jobConfigs.filter(job=>job.datafeed_config.state!==states["a"].STARTED).map(job=>job.job_id);const configContainsIssues=isAlertIntervalTooHigh||jobWithoutStartedDatafeed.length>0;if(!configContainsIssues)return null;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.alertConditionValidation.title",defaultMessage:"Alert condition contains the following issues:"}),color:"warning",size:"s"},external_kbnSharedDeps_React_default.a.createElement("ul",null,isAlertIntervalTooHigh?external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.alertConditionValidation.alertIntervalTooHighMessage",defaultMessage:"The check interval is greater than the maximum bucket span of the selected jobs. Reduce it to {resultBucketSpan} to avoid excessive delay in receiving notifications.",values:{resultBucketSpan:resultBucketSpanString}})):null,jobWithoutStartedDatafeed.length>0?external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.ml.alertConditionValidation.stoppedDatafeedJobsMessage",defaultMessage:"The datafeed is not started for the following {count, plural, one {job} other {jobs}}: {jobIds}.",values:{count:jobWithoutStartedDatafeed.length,jobIds:jobWithoutStartedDatafeed.join(", ")}})):null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))});const MlAnomalyAlertTrigger=({alertParams:alertParams,setAlertParams:setAlertParams,setAlertProperty:setAlertProperty,errors:errors,alertInterval:alertInterval})=>{const{services:{http:http},notifications:{toasts:toasts}}=Object(kibana["b"])();const mlHttpService=Object(external_kbnSharedDeps_React_["useMemo"])(()=>new http_service["a"](http),[http]);const adJobsApiService=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(jobs["a"])(mlHttpService),[mlHttpService]);const alertingApiService=Object(external_kbnSharedDeps_React_["useMemo"])(()=>alertingApiProvider(mlHttpService),[mlHttpService]);const[jobConfigs,setJobConfigs]=Object(external_kbnSharedDeps_React_["useState"])([]);const onAlertParamChange=Object(external_kbnSharedDeps_React_["useCallback"])(param=>update=>{setAlertParams(param,update)},[]);const jobsAndGroupIds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _alertParams$jobSelec;return Object.values((_alertParams$jobSelec=alertParams.jobSelection)!==null&&_alertParams$jobSelec!==void 0?_alertParams$jobSelec:{}).flat()},[alertParams.jobSelection]);const fetchJobsConfig=Object(external_kbnSharedDeps_React_["useCallback"])(async()=>{try{const jobs=await adJobsApiService.jobs(jobsAndGroupIds);setJobConfigs(jobs)}catch(e){toasts.danger({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.anomalyDetectionAlert.errorFetchingJobs",{defaultMessage:"Unable to fetch jobs configuration"}),body:e.message,toastLifeTimeMs:5e3})}},[jobsAndGroupIds]);const availableResultTypes=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(jobConfigs.length===0)return Object.values(anomalies["a"]);return(jobConfigs!==null&&jobConfigs!==void 0?jobConfigs:[]).some(v=>v.analysis_config.influencers.length>0)?Object.values(anomalies["a"]):[anomalies["a"].BUCKET,anomalies["a"].RECORD]},[jobConfigs]);Object(external_kbnSharedDeps_React_["useEffect"])((function checkJobsConfiguration(){if(jobsAndGroupIds.length===0)return;fetchJobsConfig()}),[jobsAndGroupIds]);useMount_default()((function setDefaults(){const{jobSelection:jobSelection,...rest}=alertParams;if(Object.keys(rest).length===0){setAlertProperty("params",{severity:common["ANOMALY_THRESHOLD"].CRITICAL,resultType:anomalies["a"].BUCKET,includeInterim:false,jobSelection:jobSelection})}}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{"data-test-subj":"mlAnomalyAlertForm"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.anomalyDetectionAlert.betaBadgeLabel",{defaultMessage:"Beta"}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.anomalyDetectionAlert.betaBadgeTooltipContent",{defaultMessage:`Anomaly detection alerts are a beta feature. We'd love to hear your feedback.`})}))),external_kbnSharedDeps_React_default.a.createElement(JobSelectorControl,{jobsAndGroupIds:jobsAndGroupIds,adJobsApiService:adJobsApiService,onChange:Object(external_kbnSharedDeps_React_["useCallback"])(onAlertParamChange("jobSelection"),[]),errors:errors.jobSelection}),external_kbnSharedDeps_React_default.a.createElement(ConfigValidator,{jobConfigs:jobConfigs,alertInterval:alertInterval}),external_kbnSharedDeps_React_default.a.createElement(ResultTypeSelector,{value:alertParams.resultType,availableOption:availableResultTypes,onChange:Object(external_kbnSharedDeps_React_["useCallback"])(onAlertParamChange("resultType"),[])}),external_kbnSharedDeps_React_default.a.createElement(SeverityControl,{value:alertParams.severity,onChange:Object(external_kbnSharedDeps_React_["useCallback"])(onAlertParamChange("severity"),[])}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(InterimResultsControl,{value:alertParams.includeInterim,onChange:Object(external_kbnSharedDeps_React_["useCallback"])(onAlertParamChange("includeInterim"),[])}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(PreviewAlertCondition,{alertingApiService:alertingApiService,alertParams:alertParams}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};var ml_anomaly_alert_trigger=__webpack_exports__["default"]=MlAnomalyAlertTrigger},99:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return http}));__webpack_require__.d(__webpack_exports__,"c",(function(){return http$}));__webpack_require__.d(__webpack_exports__,"a",(function(){return HttpService}));var rxjs__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(19);var rxjs__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(rxjs__WEBPACK_IMPORTED_MODULE_0__);var _util_dependency_cache__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(18);function getResultHeaders(headers){return{"Content-Type":"application/json",...headers}}function getFetchOptions(options){var _options$headers;if(!options.path){throw new Error("URL path is missing")}return{path:options.path,fetchOptions:{asSystemRequest:true,credentials:"same-origin",method:options.method||"GET",...options.body?{body:options.body}:{},...options.query?{query:options.query}:{},headers:getResultHeaders((_options$headers=options.headers)!==null&&_options$headers!==void 0?_options$headers:{})}}}async function http(options){const{path:path,fetchOptions:fetchOptions}=getFetchOptions(options);return Object(_util_dependency_cache__WEBPACK_IMPORTED_MODULE_1__["e"])().fetch(path,fetchOptions)}function http$(options){const{path:path,fetchOptions:fetchOptions}=getFetchOptions(options);return fromHttpHandler(path,fetchOptions)}function fromHttpHandler(input,init){return new rxjs__WEBPACK_IMPORTED_MODULE_0__["Observable"](subscriber=>{const controller=new AbortController;const signal=controller.signal;let abortable=true;let unsubscribed=false;if(init!==null&&init!==void 0&&init.signal){if(init.signal.aborted){controller.abort()}else{init.signal.addEventListener("abort",()=>{if(!signal.aborted){controller.abort()}})}}const perSubscriberInit={...init?init:{},signal:signal};Object(_util_dependency_cache__WEBPACK_IMPORTED_MODULE_1__["e"])().fetch(input,perSubscriberInit).then(response=>{abortable=false;subscriber.next(response);subscriber.complete()}).catch(err=>{abortable=false;if(!unsubscribed){subscriber.error(err)}});return()=>{unsubscribed=true;if(abortable){controller.abort()}}})}class HttpService{constructor(httpStart){this.httpStart=httpStart}getResultHeaders(headers){return{"Content-Type":"application/json",...headers}}getFetchOptions(options){var _options$headers2;if(!options.path){throw new Error("URL path is missing")}return{path:options.path,fetchOptions:{asSystemRequest:true,credentials:"same-origin",method:options.method||"GET",...options.body?{body:options.body}:{},...options.query?{query:options.query}:{},headers:this.getResultHeaders((_options$headers2=options.headers)!==null&&_options$headers2!==void 0?_options$headers2:{})}}}fromHttpHandler(input,init){return new rxjs__WEBPACK_IMPORTED_MODULE_0__["Observable"](subscriber=>{const controller=new AbortController;const signal=controller.signal;let abortable=true;let unsubscribed=false;if(init!==null&&init!==void 0&&init.signal){if(init.signal.aborted){controller.abort()}else{init.signal.addEventListener("abort",()=>{if(!signal.aborted){controller.abort()}})}}const perSubscriberInit={...init?init:{},signal:signal};this.httpStart.fetch(input,perSubscriberInit).then(response=>{abortable=false;subscriber.next(response);subscriber.complete()}).catch(err=>{abortable=false;if(!unsubscribed){subscriber.error(err)}});return()=>{unsubscribed=true;if(abortable){controller.abort()}}})}async http(options){const{path:path,fetchOptions:fetchOptions}=this.getFetchOptions(options);return this.httpStart.fetch(path,fetchOptions)}http$(options){const{path:path,fetchOptions:fetchOptions}=this.getFetchOptions(options);return this.fromHttpHandler(path,fetchOptions)}}}}]);