/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["ml_bundle_jsonpfunction"]=window["ml_bundle_jsonpfunction"]||[]).push([[1],{105:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return EVENT_RATE_FIELD_ID}));__webpack_require__.d(__webpack_exports__,"b",(function(){return METRIC_AGG_TYPE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return mlCategory}));var _src_plugins_data_common__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(44);var _src_plugins_data_common__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_src_plugins_data_common__WEBPACK_IMPORTED_MODULE_0__);var _constants_field_types__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(76);const EVENT_RATE_FIELD_ID="__ml_event_rate_count__";const METRIC_AGG_TYPE="metrics";const mlCategory={id:_constants_field_types__WEBPACK_IMPORTED_MODULE_1__["b"],name:_constants_field_types__WEBPACK_IMPORTED_MODULE_1__["b"],type:_src_plugins_data_common__WEBPACK_IMPORTED_MODULE_0__["ES_FIELD_TYPES"].KEYWORD,aggregatable:false};const RUNTIME_FIELD_TYPES=["keyword","long","double","date","ip","boolean"]},126:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getMostSevereMessageStatus}));__webpack_require__.d(__webpack_exports__,"c",(function(){return isValidJson}));__webpack_require__.d(__webpack_exports__,"a",(function(){return findAggField}));var _constants_validation__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(23);const contains=(arr,str)=>arr.indexOf(str)>=0;function getMostSevereMessageStatus(messages){const statuses=messages.map(m=>m.status);return[_constants_validation__WEBPACK_IMPORTED_MODULE_0__["c"].INFO,_constants_validation__WEBPACK_IMPORTED_MODULE_0__["c"].WARNING,_constants_validation__WEBPACK_IMPORTED_MODULE_0__["c"].ERROR].reduce((previous,current)=>contains(statuses,current)?current:previous,_constants_validation__WEBPACK_IMPORTED_MODULE_0__["c"].SUCCESS)}function isValidJson(json){if(json===null){return false}try{JSON.parse(json);return true}catch(error){return false}}function findAggField(aggs,fieldName,returnParent=false){if(fieldName===undefined)return;let value;Object.keys(aggs).some((function(k){if(k===fieldName){value=returnParent===true?aggs:aggs[k];return true}if(aggs.hasOwnProperty(k)&&aggs[k]!==null&&typeof aggs[k]==="object"){value=findAggField(aggs[k],fieldName,returnParent);return value!==undefined}}));return value}function isValidAggregationField(aggs,fieldName){return findAggField(aggs,fieldName)!==undefined}},127:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return isPopulatedObject}));const isPopulatedObject=arg=>typeof arg==="object"&&arg!==null&&Object.keys(arg).length>0},220:function(module,exports){var process=module.exports={};var cachedSetTimeout;var cachedClearTimeout;function defaultSetTimout(){throw new Error("setTimeout has not been defined")}function defaultClearTimeout(){throw new Error("clearTimeout has not been defined")}(function(){try{if(typeof setTimeout==="function"){cachedSetTimeout=setTimeout}else{cachedSetTimeout=defaultSetTimout}}catch(e){cachedSetTimeout=defaultSetTimout}try{if(typeof clearTimeout==="function"){cachedClearTimeout=clearTimeout}else{cachedClearTimeout=defaultClearTimeout}}catch(e){cachedClearTimeout=defaultClearTimeout}})();function runTimeout(fun){if(cachedSetTimeout===setTimeout){return setTimeout(fun,0)}if((cachedSetTimeout===defaultSetTimout||!cachedSetTimeout)&&setTimeout){cachedSetTimeout=setTimeout;return setTimeout(fun,0)}try{return cachedSetTimeout(fun,0)}catch(e){try{return cachedSetTimeout.call(null,fun,0)}catch(e){return cachedSetTimeout.call(this,fun,0)}}}function runClearTimeout(marker){if(cachedClearTimeout===clearTimeout){return clearTimeout(marker)}if((cachedClearTimeout===defaultClearTimeout||!cachedClearTimeout)&&clearTimeout){cachedClearTimeout=clearTimeout;return clearTimeout(marker)}try{return cachedClearTimeout(marker)}catch(e){try{return cachedClearTimeout.call(null,marker)}catch(e){return cachedClearTimeout.call(this,marker)}}}var queue=[];var draining=false;var currentQueue;var queueIndex=-1;function cleanUpNextTick(){if(!draining||!currentQueue){return}draining=false;if(currentQueue.length){queue=currentQueue.concat(queue)}else{queueIndex=-1}if(queue.length){drainQueue()}}function drainQueue(){if(draining){return}var timeout=runTimeout(cleanUpNextTick);draining=true;var len=queue.length;while(len){currentQueue=queue;queue=[];while(++queueIndex<len){if(currentQueue){currentQueue[queueIndex].run()}}queueIndex=-1;len=queue.length}currentQueue=null;draining=false;runClearTimeout(timeout)}process.nextTick=function(fun){var args=new Array(arguments.length-1);if(arguments.length>1){for(var i=1;i<arguments.length;i++){args[i-1]=arguments[i]}}queue.push(new Item(fun,args));if(queue.length===1&&!draining){runTimeout(drainQueue)}};function Item(fun,array){this.fun=fun;this.array=array}Item.prototype.run=function(){this.fun.apply(null,this.array)};process.title="browser";process.browser=true;process.env={};process.argv=[];process.version="";process.versions={};function noop(){}process.on=noop;process.addListener=noop;process.once=noop;process.off=noop;process.removeListener=noop;process.removeAllListeners=noop;process.emit=noop;process.prependListener=noop;process.prependOnceListener=noop;process.listeners=function(name){return[]};process.binding=function(name){throw new Error("process.binding is not supported")};process.cwd=function(){return"/"};process.chdir=function(dir){throw new Error("process.chdir is not supported")};process.umask=function(){return 0}},221:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getAggregations}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getDatafeedAggregations}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getAggregationBucketsName}));function getAggregations(obj){if((obj===null||obj===void 0?void 0:obj.aggregations)!==undefined)return obj.aggregations;if((obj===null||obj===void 0?void 0:obj.aggs)!==undefined)return obj.aggs;return undefined}const getDatafeedAggregations=datafeedConfig=>getAggregations(datafeedConfig);const getAggregationBucketsName=aggregations=>{if(aggregations!==null&&typeof aggregations==="object"){const keys=Object.keys(aggregations);return keys.length>0?keys[0]:undefined}}},285:function(module,exports,__webpack_require__){(function(process){const debug=typeof process==="object"&&Object({IS_KIBANA_DISTRIBUTABLE:"true"})&&Object({IS_KIBANA_DISTRIBUTABLE:"true"}).NODE_DEBUG&&/\bsemver\b/i.test(Object({IS_KIBANA_DISTRIBUTABLE:"true"}).NODE_DEBUG)?(...args)=>console.error("SEMVER",...args):()=>{};module.exports=debug}).call(this,__webpack_require__(220))},286:function(module,exports){const SEMVER_SPEC_VERSION="2.0.0";const MAX_LENGTH=256;const MAX_SAFE_INTEGER=Number.MAX_SAFE_INTEGER||9007199254740991;const MAX_SAFE_COMPONENT_LENGTH=16;module.exports={SEMVER_SPEC_VERSION:SEMVER_SPEC_VERSION,MAX_LENGTH:MAX_LENGTH,MAX_SAFE_INTEGER:MAX_SAFE_INTEGER,MAX_SAFE_COMPONENT_LENGTH:MAX_SAFE_COMPONENT_LENGTH}},395:function(module,exports,__webpack_require__){const compare=__webpack_require__(396);const gte=(a,b,loose)=>compare(a,b,loose)>=0;module.exports=gte},396:function(module,exports,__webpack_require__){const SemVer=__webpack_require__(397);const compare=(a,b,loose)=>new SemVer(a,loose).compare(new SemVer(b,loose));module.exports=compare},397:function(module,exports,__webpack_require__){const debug=__webpack_require__(285);const{MAX_LENGTH:MAX_LENGTH,MAX_SAFE_INTEGER:MAX_SAFE_INTEGER}=__webpack_require__(286);const{re:re,t:t}=__webpack_require__(398);const{compareIdentifiers:compareIdentifiers}=__webpack_require__(399);class SemVer{constructor(version,options){if(!options||typeof options!=="object"){options={loose:!!options,includePrerelease:false}}if(version instanceof SemVer){if(version.loose===!!options.loose&&version.includePrerelease===!!options.includePrerelease){return version}else{version=version.version}}else if(typeof version!=="string"){throw new TypeError(`Invalid Version: ${version}`)}if(version.length>MAX_LENGTH){throw new TypeError(`version is longer than ${MAX_LENGTH} characters`)}debug("SemVer",version,options);this.options=options;this.loose=!!options.loose;this.includePrerelease=!!options.includePrerelease;const m=version.trim().match(options.loose?re[t.LOOSE]:re[t.FULL]);if(!m){throw new TypeError(`Invalid Version: ${version}`)}this.raw=version;this.major=+m[1];this.minor=+m[2];this.patch=+m[3];if(this.major>MAX_SAFE_INTEGER||this.major<0){throw new TypeError("Invalid major version")}if(this.minor>MAX_SAFE_INTEGER||this.minor<0){throw new TypeError("Invalid minor version")}if(this.patch>MAX_SAFE_INTEGER||this.patch<0){throw new TypeError("Invalid patch version")}if(!m[4]){this.prerelease=[]}else{this.prerelease=m[4].split(".").map(id=>{if(/^[0-9]+$/.test(id)){const num=+id;if(num>=0&&num<MAX_SAFE_INTEGER){return num}}return id})}this.build=m[5]?m[5].split("."):[];this.format()}format(){this.version=`${this.major}.${this.minor}.${this.patch}`;if(this.prerelease.length){this.version+=`-${this.prerelease.join(".")}`}return this.version}toString(){return this.version}compare(other){debug("SemVer.compare",this.version,this.options,other);if(!(other instanceof SemVer)){if(typeof other==="string"&&other===this.version){return 0}other=new SemVer(other,this.options)}if(other.version===this.version){return 0}return this.compareMain(other)||this.comparePre(other)}compareMain(other){if(!(other instanceof SemVer)){other=new SemVer(other,this.options)}return compareIdentifiers(this.major,other.major)||compareIdentifiers(this.minor,other.minor)||compareIdentifiers(this.patch,other.patch)}comparePre(other){if(!(other instanceof SemVer)){other=new SemVer(other,this.options)}if(this.prerelease.length&&!other.prerelease.length){return-1}else if(!this.prerelease.length&&other.prerelease.length){return 1}else if(!this.prerelease.length&&!other.prerelease.length){return 0}let i=0;do{const a=this.prerelease[i];const b=other.prerelease[i];debug("prerelease compare",i,a,b);if(a===undefined&&b===undefined){return 0}else if(b===undefined){return 1}else if(a===undefined){return-1}else if(a===b){continue}else{return compareIdentifiers(a,b)}}while(++i)}compareBuild(other){if(!(other instanceof SemVer)){other=new SemVer(other,this.options)}let i=0;do{const a=this.build[i];const b=other.build[i];debug("prerelease compare",i,a,b);if(a===undefined&&b===undefined){return 0}else if(b===undefined){return 1}else if(a===undefined){return-1}else if(a===b){continue}else{return compareIdentifiers(a,b)}}while(++i)}inc(release,identifier){switch(release){case"premajor":this.prerelease.length=0;this.patch=0;this.minor=0;this.major++;this.inc("pre",identifier);break;case"preminor":this.prerelease.length=0;this.patch=0;this.minor++;this.inc("pre",identifier);break;case"prepatch":this.prerelease.length=0;this.inc("patch",identifier);this.inc("pre",identifier);break;case"prerelease":if(this.prerelease.length===0){this.inc("patch",identifier)}this.inc("pre",identifier);break;case"major":if(this.minor!==0||this.patch!==0||this.prerelease.length===0){this.major++}this.minor=0;this.patch=0;this.prerelease=[];break;case"minor":if(this.patch!==0||this.prerelease.length===0){this.minor++}this.patch=0;this.prerelease=[];break;case"patch":if(this.prerelease.length===0){this.patch++}this.prerelease=[];break;case"pre":if(this.prerelease.length===0){this.prerelease=[0]}else{let i=this.prerelease.length;while(--i>=0){if(typeof this.prerelease[i]==="number"){this.prerelease[i]++;i=-2}}if(i===-1){this.prerelease.push(0)}}if(identifier){if(this.prerelease[0]===identifier){if(isNaN(this.prerelease[1])){this.prerelease=[identifier,0]}}else{this.prerelease=[identifier,0]}}break;default:throw new Error(`invalid increment argument: ${release}`)}this.format();this.raw=this.version;return this}}module.exports=SemVer},398:function(module,exports,__webpack_require__){const{MAX_SAFE_COMPONENT_LENGTH:MAX_SAFE_COMPONENT_LENGTH}=__webpack_require__(286);const debug=__webpack_require__(285);exports=module.exports={};const re=exports.re=[];const src=exports.src=[];const t=exports.t={};let R=0;const createToken=(name,value,isGlobal)=>{const index=R++;debug(index,value);t[name]=index;src[index]=value;re[index]=new RegExp(value,isGlobal?"g":undefined)};createToken("NUMERICIDENTIFIER","0|[1-9]\\d*");createToken("NUMERICIDENTIFIERLOOSE","[0-9]+");createToken("NONNUMERICIDENTIFIER","\\d*[a-zA-Z-][a-zA-Z0-9-]*");createToken("MAINVERSION",`(${src[t.NUMERICIDENTIFIER]})\\.`+`(${src[t.NUMERICIDENTIFIER]})\\.`+`(${src[t.NUMERICIDENTIFIER]})`);createToken("MAINVERSIONLOOSE",`(${src[t.NUMERICIDENTIFIERLOOSE]})\\.`+`(${src[t.NUMERICIDENTIFIERLOOSE]})\\.`+`(${src[t.NUMERICIDENTIFIERLOOSE]})`);createToken("PRERELEASEIDENTIFIER",`(?:${src[t.NUMERICIDENTIFIER]}|${src[t.NONNUMERICIDENTIFIER]})`);createToken("PRERELEASEIDENTIFIERLOOSE",`(?:${src[t.NUMERICIDENTIFIERLOOSE]}|${src[t.NONNUMERICIDENTIFIER]})`);createToken("PRERELEASE",`(?:-(${src[t.PRERELEASEIDENTIFIER]}(?:\\.${src[t.PRERELEASEIDENTIFIER]})*))`);createToken("PRERELEASELOOSE",`(?:-?(${src[t.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t.PRERELEASEIDENTIFIERLOOSE]})*))`);createToken("BUILDIDENTIFIER","[0-9A-Za-z-]+");createToken("BUILD",`(?:\\+(${src[t.BUILDIDENTIFIER]}(?:\\.${src[t.BUILDIDENTIFIER]})*))`);createToken("FULLPLAIN",`v?${src[t.MAINVERSION]}${src[t.PRERELEASE]}?${src[t.BUILD]}?`);createToken("FULL",`^${src[t.FULLPLAIN]}$`);createToken("LOOSEPLAIN",`[v=\\s]*${src[t.MAINVERSIONLOOSE]}${src[t.PRERELEASELOOSE]}?${src[t.BUILD]}?`);createToken("LOOSE",`^${src[t.LOOSEPLAIN]}$`);createToken("GTLT","((?:<|>)?=?)");createToken("XRANGEIDENTIFIERLOOSE",`${src[t.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`);createToken("XRANGEIDENTIFIER",`${src[t.NUMERICIDENTIFIER]}|x|X|\\*`);createToken("XRANGEPLAIN",`[v=\\s]*(${src[t.XRANGEIDENTIFIER]})`+`(?:\\.(${src[t.XRANGEIDENTIFIER]})`+`(?:\\.(${src[t.XRANGEIDENTIFIER]})`+`(?:${src[t.PRERELEASE]})?${src[t.BUILD]}?`+`)?)?`);createToken("XRANGEPLAINLOOSE",`[v=\\s]*(${src[t.XRANGEIDENTIFIERLOOSE]})`+`(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})`+`(?:\\.(${src[t.XRANGEIDENTIFIERLOOSE]})`+`(?:${src[t.PRERELEASELOOSE]})?${src[t.BUILD]}?`+`)?)?`);createToken("XRANGE",`^${src[t.GTLT]}\\s*${src[t.XRANGEPLAIN]}$`);createToken("XRANGELOOSE",`^${src[t.GTLT]}\\s*${src[t.XRANGEPLAINLOOSE]}$`);createToken("COERCE",`${"(^|[^\\d])"+"(\\d{1,"}${MAX_SAFE_COMPONENT_LENGTH}})`+`(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`+`(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`+`(?:$|[^\\d])`);createToken("COERCERTL",src[t.COERCE],true);createToken("LONETILDE","(?:~>?)");createToken("TILDETRIM",`(\\s*)${src[t.LONETILDE]}\\s+`,true);exports.tildeTrimReplace="$1~";createToken("TILDE",`^${src[t.LONETILDE]}${src[t.XRANGEPLAIN]}$`);createToken("TILDELOOSE",`^${src[t.LONETILDE]}${src[t.XRANGEPLAINLOOSE]}$`);createToken("LONECARET","(?:\\^)");createToken("CARETTRIM",`(\\s*)${src[t.LONECARET]}\\s+`,true);exports.caretTrimReplace="$1^";createToken("CARET",`^${src[t.LONECARET]}${src[t.XRANGEPLAIN]}$`);createToken("CARETLOOSE",`^${src[t.LONECARET]}${src[t.XRANGEPLAINLOOSE]}$`);createToken("COMPARATORLOOSE",`^${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]})$|^$`);createToken("COMPARATOR",`^${src[t.GTLT]}\\s*(${src[t.FULLPLAIN]})$|^$`);createToken("COMPARATORTRIM",`(\\s*)${src[t.GTLT]}\\s*(${src[t.LOOSEPLAIN]}|${src[t.XRANGEPLAIN]})`,true);exports.comparatorTrimReplace="$1$2$3";createToken("HYPHENRANGE",`^\\s*(${src[t.XRANGEPLAIN]})`+`\\s+-\\s+`+`(${src[t.XRANGEPLAIN]})`+`\\s*$`);createToken("HYPHENRANGELOOSE",`^\\s*(${src[t.XRANGEPLAINLOOSE]})`+`\\s+-\\s+`+`(${src[t.XRANGEPLAINLOOSE]})`+`\\s*$`);createToken("STAR","(<|>)?=?\\s*\\*");createToken("GTE0","^\\s*>=\\s*0.0.0\\s*$");createToken("GTE0PRE","^\\s*>=\\s*0.0.0-0\\s*$")},399:function(module,exports){const numeric=/^[0-9]+$/;const compareIdentifiers=(a,b)=>{const anum=numeric.test(a);const bnum=numeric.test(b);if(anum&&bnum){a=+a;b=+b}return a===b?0:anum&&!bnum?-1:bnum&&!anum?1:a<b?-1:1};const rcompareIdentifiers=(a,b)=>compareIdentifiers(b,a);module.exports={compareIdentifiers:compareIdentifiers,rcompareIdentifiers:rcompareIdentifiers}},64:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"f",(function(){return calculateDatafeedFrequencyDefaultSeconds}));__webpack_require__.d(__webpack_exports__,"p",(function(){return isTimeSeriesViewJob}));__webpack_require__.d(__webpack_exports__,"o",(function(){return isTimeSeriesViewDetector}));__webpack_require__.d(__webpack_exports__,"k",(function(){return isMappableJob}));__webpack_require__.d(__webpack_exports__,"n",(function(){return isSourceDataChartableForDetector}));__webpack_require__.d(__webpack_exports__,"l",(function(){return isModelPlotChartableForDetector}));__webpack_require__.d(__webpack_exports__,"h",(function(){return getPartitioningFieldNames}));__webpack_require__.d(__webpack_exports__,"m",(function(){return isModelPlotEnabled}));__webpack_require__.d(__webpack_exports__,"j",(function(){return isJobVersionGte}));__webpack_require__.d(__webpack_exports__,"q",(function(){return mlFunctionToESAggregation}));__webpack_require__.d(__webpack_exports__,"i",(function(){return isJobIdValid}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ML_MEDIAN_PERCENTS}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ML_DATA_PREVIEW_COUNT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return basicJobValidation}));__webpack_require__.d(__webpack_exports__,"c",(function(){return basicDatafeedValidation}));__webpack_require__.d(__webpack_exports__,"d",(function(){return basicJobAndDatafeedValidation}));__webpack_require__.d(__webpack_exports__,"v",(function(){return validateModelMemoryLimit}));__webpack_require__.d(__webpack_exports__,"w",(function(){return validateModelMemoryLimitUnits}));__webpack_require__.d(__webpack_exports__,"u",(function(){return validateGroupNames}));__webpack_require__.d(__webpack_exports__,"g",(function(){return getLatestDataOrBucketTimestamp}));__webpack_require__.d(__webpack_exports__,"r",(function(){return processCreatedBy}));__webpack_require__.d(__webpack_exports__,"t",(function(){return splitIndexPatternNames}));__webpack_require__.d(__webpack_exports__,"s",(function(){return resolveBucketSpanInSeconds}));var external_kbnSharedDeps_Lodash_=__webpack_require__(5);var gte=__webpack_require__(395);var gte_default=__webpack_require__.n(gte);var external_kbnSharedDeps_Moment_=__webpack_require__(12);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var external_kbnSharedDeps_ElasticNumeral_=__webpack_require__(42);var external_kbnSharedDeps_ElasticNumeral_default=__webpack_require__.n(external_kbnSharedDeps_ElasticNumeral_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var validation=__webpack_require__(23);var parse_interval=__webpack_require__(22);var validators=__webpack_require__(14);var new_job=__webpack_require__(68);var aggregation_types=__webpack_require__(79);var field_types=__webpack_require__(76);var datafeed_utils=__webpack_require__(221);var validation_utils=__webpack_require__(126);var object_utils=__webpack_require__(127);function isDefined(argument){return argument!==undefined&&argument!==null}function calculateDatafeedFrequencyDefaultSeconds(bucketSpanSeconds){let freq=3600;if(bucketSpanSeconds<=120){freq=60}else if(bucketSpanSeconds<=1200){freq=Math.floor(bucketSpanSeconds/2)}else if(bucketSpanSeconds<=43200){freq=600}return freq}function hasRuntimeMappings(job){const hasDatafeed=Object(object_utils["a"])(job.datafeed_config);if(hasDatafeed){return Object(object_utils["a"])(job.datafeed_config.runtime_mappings)}return false}function isTimeSeriesViewJob(job){return getSingleMetricViewerJobErrorMessage(job)===undefined}function isTimeSeriesViewDetector(job,detectorIndex){return isSourceDataChartableForDetector(job,detectorIndex)||isModelPlotChartableForDetector(job,detectorIndex)}function isMappableJob(job,detectorIndex){let isMappable=false;const{detectors:detectors}=job.analysis_config;if(detectorIndex>=0&&detectorIndex<detectors.length){const dtr=detectors[detectorIndex];const functionName=dtr.function;isMappable=functionName===aggregation_types["b"].LAT_LONG}return isMappable}function isSourceDataChartableForDetector(job,detectorIndex){let isSourceDataChartable=false;const{detectors:detectors}=job.analysis_config;if(detectorIndex>=0&&detectorIndex<detectors.length){var _job$datafeed_config,_job$datafeed_config2;const dtr=detectors[detectorIndex];const functionName=dtr.function;isSourceDataChartable=mlFunctionToESAggregation(functionName)!==null&&dtr.by_field_name!==field_types["b"]&&dtr.partition_field_name!==field_types["b"]&&dtr.over_field_name!==field_types["b"];if(isSourceDataChartable===true&&((_job$datafeed_config=job.datafeed_config)===null||_job$datafeed_config===void 0?void 0:_job$datafeed_config.script_fields)!==null&&typeof((_job$datafeed_config2=job.datafeed_config)===null||_job$datafeed_config2===void 0?void 0:_job$datafeed_config2.script_fields)==="object"){const scriptFields=Object.keys(job.datafeed_config.script_fields);isSourceDataChartable=scriptFields.indexOf(dtr.partition_field_name)===-1&&scriptFields.indexOf(dtr.by_field_name)===-1&&scriptFields.indexOf(dtr.over_field_name)===-1}const hasDatafeed=Object(object_utils["a"])(job.datafeed_config);if(hasDatafeed){const aggs=Object(datafeed_utils["c"])(job.datafeed_config);if(aggs!==undefined){const aggBucketsName=Object(datafeed_utils["a"])(aggs);if(aggBucketsName!==undefined){var _getAggregations;const aggregations=(_getAggregations=Object(datafeed_utils["b"])(aggs[aggBucketsName]))!==null&&_getAggregations!==void 0?_getAggregations:{};const foundField=Object(validation_utils["a"])(aggregations,dtr.field_name,false);if((foundField===null||foundField===void 0?void 0:foundField.bucket_script)!==undefined){return false}}}if(hasRuntimeMappings(job)){return false}}}return isSourceDataChartable}function isModelPlotChartableForDetector(job,detectorIndex){var _job$model_plot_confi,_job$model_plot_confi2;let isModelPlotChartable=false;const modelPlotEnabled=(_job$model_plot_confi=(_job$model_plot_confi2=job.model_plot_config)===null||_job$model_plot_confi2===void 0?void 0:_job$model_plot_confi2.enabled)!==null&&_job$model_plot_confi!==void 0?_job$model_plot_confi:false;const{detectors:detectors}=job.analysis_config;if(detectorIndex>=0&&detectorIndex<detectors.length&&modelPlotEnabled){const dtr=detectors[detectorIndex];const functionName=dtr.function;isModelPlotChartable=functionName!==aggregation_types["b"].RARE&&(mlFunctionToESAggregation(functionName)!==null||[aggregation_types["b"].VARP,aggregation_types["b"].HIGH_VARP,aggregation_types["b"].LOW_VARP,aggregation_types["b"].INFO_CONTENT,aggregation_types["b"].HIGH_INFO_CONTENT,aggregation_types["b"].LOW_INFO_CONTENT].includes(functionName))}return isModelPlotChartable}function getSingleMetricViewerJobErrorMessage(job){var _job$model_plot_confi3;if(hasRuntimeMappings(job)&&!((_job$model_plot_confi3=job.model_plot_config)!==null&&_job$model_plot_confi3!==void 0&&_job$model_plot_confi3.enabled)){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesJob.jobWithRunTimeMessage",{defaultMessage:"the datafeed contains runtime fields and model plot is disabled"})}const isChartableTimeSeriesViewJob=job.analysis_config.detectors.some((detector,idx)=>isTimeSeriesViewDetector(job,idx));if(isChartableTimeSeriesViewJob===false){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.ml.timeSeriesJob.notViewableTimeSeriesJobMessage",{defaultMessage:"not a viewable time series job"})}}function getPartitioningFieldNames(job,detectorIndex){const fieldNames=[];const detector=job.analysis_config.detectors[detectorIndex];if(typeof detector.partition_field_name==="string"){fieldNames.push(detector.partition_field_name)}if(typeof detector.by_field_name==="string"){fieldNames.push(detector.by_field_name)}if(typeof detector.over_field_name==="string"){fieldNames.push(detector.over_field_name)}return fieldNames}function isModelPlotEnabled(job,detectorIndex,entityFields){var _job$model_plot_confi4,_job$model_plot_confi5;let isEnabled=(_job$model_plot_confi4=(_job$model_plot_confi5=job.model_plot_config)===null||_job$model_plot_confi5===void 0?void 0:_job$model_plot_confi5.enabled)!==null&&_job$model_plot_confi4!==void 0?_job$model_plot_confi4:false;if(isEnabled&&entityFields!==undefined&&entityFields.length>0){var _job$model_plot_confi6,_job$model_plot_confi7;const termsStr=(_job$model_plot_confi6=(_job$model_plot_confi7=job.model_plot_config)===null||_job$model_plot_confi7===void 0?void 0:_job$model_plot_confi7.terms)!==null&&_job$model_plot_confi6!==void 0?_job$model_plot_confi6:"";if(termsStr!==""){const detector=job.analysis_config.detectors[detectorIndex];const detectorHasPartitionField=detector.hasOwnProperty("partition_field_name");const detectorHasByField=detector.hasOwnProperty("by_field_name");const terms=termsStr.split(",");if(detectorHasPartitionField){const partitionEntity=entityFields.find(entityField=>entityField.fieldName===detector.partition_field_name);isEnabled=(partitionEntity===null||partitionEntity===void 0?void 0:partitionEntity.fieldValue)!==undefined&&terms.indexOf(String(partitionEntity.fieldValue))!==-1}if(isEnabled===true&&detectorHasByField===true){const byEntity=entityFields.find(entityField=>entityField.fieldName===detector.by_field_name);isEnabled=(byEntity===null||byEntity===void 0?void 0:byEntity.fieldValue)!==undefined&&terms.indexOf(String(byEntity.fieldValue))!==-1}}}return isEnabled}function isJobVersionGte(job,version){var _job$job_version;const jobVersion=(_job$job_version=job.job_version)!==null&&_job$job_version!==void 0?_job$job_version:"0.0.0";return gte_default()(jobVersion,version)}function mlFunctionToESAggregation(functionName){if(functionName===aggregation_types["b"].MEAN||functionName===aggregation_types["b"].HIGH_MEAN||functionName===aggregation_types["b"].LOW_MEAN||functionName===aggregation_types["b"].METRIC){return aggregation_types["a"].AVG}if(functionName===aggregation_types["b"].SUM||functionName===aggregation_types["b"].HIGH_SUM||functionName===aggregation_types["b"].LOW_SUM||functionName===aggregation_types["b"].NON_NULL_SUM||functionName===aggregation_types["b"].LOW_NON_NULL_SUM||functionName===aggregation_types["b"].HIGH_NON_NULL_SUM){return aggregation_types["a"].SUM}if(functionName===aggregation_types["b"].COUNT||functionName===aggregation_types["b"].HIGH_COUNT||functionName===aggregation_types["b"].LOW_COUNT||functionName===aggregation_types["b"].NON_ZERO_COUNT||functionName===aggregation_types["b"].LOW_NON_ZERO_COUNT||functionName===aggregation_types["b"].HIGH_NON_ZERO_COUNT){return aggregation_types["a"].COUNT}if(functionName===aggregation_types["b"].DISTINCT_COUNT||functionName===aggregation_types["b"].LOW_DISTINCT_COUNT||functionName===aggregation_types["b"].HIGH_DISTINCT_COUNT){return aggregation_types["a"].CARDINALITY}if(functionName===aggregation_types["b"].MEDIAN||functionName===aggregation_types["b"].HIGH_MEDIAN||functionName===aggregation_types["b"].LOW_MEDIAN){return aggregation_types["a"].PERCENTILES}if(functionName===aggregation_types["b"].MIN||functionName===aggregation_types["b"].MAX){return functionName}if(functionName===aggregation_types["b"].RARE){return aggregation_types["a"].COUNT}return null}function isJobIdValid(jobId){return/^[a-z0-9\-\_]+$/g.test(jobId)&&!/^([_-].*)?(.*[_-])?$/g.test(jobId)}const ML_MEDIAN_PERCENTS="50.0";const ML_DATA_PREVIEW_COUNT=10;function prefixDatafeedId(datafeedId,prefix){return datafeedId.match(/^datafeed-/)?datafeedId.replace(/^datafeed-/,`datafeed-${prefix}`):`datafeed-${prefix}${datafeedId}`}function getSafeAggregationName(fieldName,index){return fieldName.match(/^[a-zA-Z0-9-_.]+$/)?fieldName:`field_${index}`}function uniqWithIsEqual(arr){return arr.reduce((dedupedArray,value)=>{if(dedupedArray.filter(compareValue=>Object(external_kbnSharedDeps_Lodash_["isEqual"])(compareValue,value)).length===0){dedupedArray.push(value)}return dedupedArray},[])}function basicJobValidation(job,fields,limits,skipMmlChecks=false){const messages=[];let valid=true;if(job){if(Object(external_kbnSharedDeps_Lodash_["isEmpty"])(job.job_id)){messages.push({id:"job_id_empty"});valid=false}else if(isJobIdValid(job.job_id)===false){messages.push({id:"job_id_invalid"});valid=false}else if(Object(validators["b"])(validation["b"])(job.job_id)){messages.push({id:"job_id_invalid_max_length",maxLength:validation["b"]});valid=false}else{messages.push({id:"job_id_valid"})}const{messages:groupsMessages,valid:groupsValid}=validateGroupNames(job);messages.push(...groupsMessages);valid=valid&&groupsValid;if(job.analysis_config.categorization_filters){let v=true;Object(external_kbnSharedDeps_Lodash_["each"])(job.analysis_config.categorization_filters,d=>{try{new RegExp(d)}catch(e){v=false}if(job.analysis_config.categorization_field_name===undefined||job.analysis_config.categorization_field_name===""){v=false}if(d===""){v=false}});if(v){messages.push({id:"categorization_filters_valid"})}else{messages.push({id:"categorization_filters_invalid"});valid=false}}let categorizerDetectorMissingPartitionField=false;if(job.analysis_config.detectors.length===0){messages.push({id:"detectors_empty"});valid=false}else{let v=true;Object(external_kbnSharedDeps_Lodash_["each"])(job.analysis_config.detectors,d=>{var _job$analysis_config$;if(Object(external_kbnSharedDeps_Lodash_["isEmpty"])(d.function)){v=false}const needToHavePartitionFieldName=((_job$analysis_config$=job.analysis_config.per_partition_categorization)===null||_job$analysis_config$===void 0?void 0:_job$analysis_config$.enabled)===true&&(d.by_field_name===field_types["b"]||d.over_field_name===field_types["b"]);if(needToHavePartitionFieldName&&d.partition_field_name===undefined){categorizerDetectorMissingPartitionField=true}});if(v){messages.push({id:"detectors_function_not_empty"})}else{messages.push({id:"detectors_function_empty"});valid=false}if(categorizerDetectorMissingPartitionField){messages.push({id:"categorizer_detector_missing_per_partition_field"});valid=false}}if(job.analysis_config.detectors.length>=2){if(job.analysis_config.per_partition_categorization!==undefined){if(job.analysis_config.per_partition_categorization.enabled||job.analysis_config.per_partition_categorization.stop_on_warn&&Array.isArray(job.analysis_config.detectors)&&job.analysis_config.detectors.length>=2){const categorizationDetectors=job.analysis_config.detectors.filter(d=>d.by_field_name===field_types["b"]||d.over_field_name===field_types["b"]||d.partition_field_name===field_types["b"]);const uniqPartitions=[...new Set(categorizationDetectors.map(d=>d.partition_field_name).filter(name=>name!==undefined))];if(uniqPartitions.length>1){valid=false;messages.push({id:"categorizer_varying_per_partition_fields",fields:uniqPartitions.join(", ")})}}}const compareSubSet=job.analysis_config.detectors.map(d=>Object(external_kbnSharedDeps_Lodash_["pick"])(d,["function","field_name","by_field_name","over_field_name","partition_field_name"]));const dedupedSubSet=uniqWithIsEqual(compareSubSet);if(compareSubSet.length!==dedupedSubSet.length){messages.push({id:"detectors_duplicates"});valid=false}}if(job.analysis_config.bucket_span===""||job.analysis_config.bucket_span===undefined){messages.push({id:"bucket_span_empty"});valid=false}else{if(isValidTimeInterval(job.analysis_config.bucket_span)){messages.push({id:"bucket_span_valid",bucketSpan:job.analysis_config.bucket_span})}else{messages.push({id:"bucket_span_invalid"});valid=false}}if(typeof fields!=="undefined"){const loadedFields=Object.keys(fields);if(loadedFields.length===0){messages.push({id:"index_fields_invalid"});valid=false}else{messages.push({id:"index_fields_valid"})}}if(skipMmlChecks===false){const mml=job.analysis_limits&&job.analysis_limits.model_memory_limit;const{messages:mmlUnitMessages,valid:mmlUnitValid}=validateModelMemoryLimitUnits(mml);messages.push(...mmlUnitMessages);valid=valid&&mmlUnitValid;if(mmlUnitValid){const{messages:mmlMessages,valid:mmlValid}=validateModelMemoryLimit(job,limits);messages.push(...mmlMessages);valid=valid&&mmlValid}}}else{valid=false}return{messages:messages,valid:valid,contains:id=>messages.some(m=>id===m.id),find:id=>messages.find(m=>id===m.id)}}function basicDatafeedValidation(datafeed){const messages=[];let valid=true;if(datafeed){let queryDelayMessage={id:"query_delay_valid"};if(isValidTimeInterval(datafeed.query_delay)===false){queryDelayMessage={id:"query_delay_invalid"};valid=false}messages.push(queryDelayMessage);let frequencyMessage={id:"frequency_valid"};if(isValidTimeInterval(datafeed.frequency)===false){frequencyMessage={id:"frequency_invalid"};valid=false}messages.push(frequencyMessage)}return{messages:messages,valid:valid,contains:id=>messages.some(m=>id===m.id),find:id=>messages.find(m=>id===m.id)}}function basicJobAndDatafeedValidation(job,datafeed){const messages=[];let valid=true;if(datafeed&&job){var _job$analysis_config;const datafeedAggregations=Object(datafeed_utils["c"])(datafeed);if(datafeedAggregations!==undefined&&!((_job$analysis_config=job.analysis_config)!==null&&_job$analysis_config!==void 0&&_job$analysis_config.summary_count_field_name)){valid=false;messages.push({id:"missing_summary_count_field_name"})}}return{messages:messages,valid:valid,contains:id=>messages.some(m=>id===m.id),find:id=>messages.find(m=>id===m.id)}}function validateModelMemoryLimit(job,limits){const messages=[];let valid=true;if(typeof job.analysis_limits!=="undefined"&&typeof job.analysis_limits.model_memory_limit!=="undefined"){if(typeof limits==="object"&&typeof limits.max_model_memory_limit!=="undefined"){const max=limits.max_model_memory_limit.toUpperCase();const mml=job.analysis_limits.model_memory_limit.toUpperCase();const mmlBytes=external_kbnSharedDeps_ElasticNumeral_default()(mml).value();const maxBytes=external_kbnSharedDeps_ElasticNumeral_default()(max).value();if(mmlBytes>maxBytes){messages.push({id:"model_memory_limit_invalid"});valid=false}else{messages.push({id:"model_memory_limit_valid"})}}}return{valid:valid,messages:messages,contains:id=>messages.some(m=>id===m.id),find:id=>messages.find(m=>id===m.id)}}function validateModelMemoryLimitUnits(modelMemoryLimit){const messages=[];let valid=true;if(modelMemoryLimit!==undefined){const mml=String(modelMemoryLimit).toUpperCase();const mmlSplit=mml.match(/\d+(\w+)$/);const unit=mmlSplit&&mmlSplit.length===2?mmlSplit[1]:null;if(unit===null||validation["a"].indexOf(unit)===-1){messages.push({id:"model_memory_limit_units_invalid"});valid=false}else{messages.push({id:"model_memory_limit_units_valid"})}}return{valid:valid,messages:messages,contains:id=>messages.some(m=>id===m.id),find:id=>messages.find(m=>id===m.id)}}function validateGroupNames(job){const{groups:groups=[]}=job;const errorMessages=[...groups.some(group=>!isJobIdValid(group))?[{id:"job_group_id_invalid"}]:[],...groups.some(group=>Object(validators["b"])(validation["b"])(group))?[{id:"job_group_id_invalid_max_length"}]:[]];const valid=errorMessages.length===0;const messages=valid&&groups.length?[{id:"job_group_id_valid"}]:errorMessages;return{valid:valid,messages:messages,contains:id=>messages.some(m=>id===m.id),find:id=>messages.find(m=>id===m.id)}}function parseTimeIntervalForJob(value){if(value===undefined){return null}const interval=Object(parse_interval["a"])(value,true);return interval!==null&&interval.asMilliseconds()!==0&&interval.milliseconds()===0?interval:null}function isValidTimeInterval(value){if(value===undefined){return true}return parseTimeIntervalForJob(value)!==null}function getEarliestDatafeedStartTime(latestRecordTimestamp,latestBucketTimestamp,bucketSpan){if(latestRecordTimestamp!==undefined&&latestBucketTimestamp!==undefined){const adjustedBucketStartTime=bucketSpan?external_kbnSharedDeps_Moment_default()(latestBucketTimestamp).add(bucketSpan).valueOf():latestBucketTimestamp;return Math.max(latestRecordTimestamp,adjustedBucketStartTime)}else{return latestRecordTimestamp!==undefined?latestRecordTimestamp:latestBucketTimestamp}}function getLatestDataOrBucketTimestamp(latestDataTimestamp,latestBucketTimestamp){if(latestDataTimestamp!==undefined&&latestBucketTimestamp!==undefined){return Math.max(latestDataTimestamp,latestBucketTimestamp)}else{return latestDataTimestamp!==undefined?latestDataTimestamp:latestBucketTimestamp}}function processCreatedBy(customSettings){if(Object.values(new_job["a"]).includes(customSettings.created_by)){delete customSettings.created_by}}function splitIndexPatternNames(indexPatternName){return indexPatternName.includes(",")?indexPatternName.split(",").map(i=>i.trim()):[indexPatternName]}function resolveBucketSpanInSeconds(bucketSpans){return Math.max(...bucketSpans.map(b=>Object(parse_interval["a"])(b)).filter(isDefined).map(v=>v.asSeconds()))}},68:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"f",(function(){return JOB_TYPE}));__webpack_require__.d(__webpack_exports__,"a",(function(){return CREATED_BY_LABEL}));__webpack_require__.d(__webpack_exports__,"c",(function(){return DEFAULT_MODEL_MEMORY_LIMIT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return DEFAULT_BUCKET_SPAN}));__webpack_require__.d(__webpack_exports__,"e",(function(){return DEFAULT_RARE_BUCKET_SPAN}));__webpack_require__.d(__webpack_exports__,"d",(function(){return DEFAULT_QUERY_DELAY}));__webpack_require__.d(__webpack_exports__,"g",(function(){return SHARED_RESULTS_INDEX_NAME}));let JOB_TYPE;(function(JOB_TYPE){JOB_TYPE["SINGLE_METRIC"]="single_metric";JOB_TYPE["MULTI_METRIC"]="multi_metric";JOB_TYPE["POPULATION"]="population";JOB_TYPE["ADVANCED"]="advanced";JOB_TYPE["CATEGORIZATION"]="categorization"})(JOB_TYPE||(JOB_TYPE={}));let CREATED_BY_LABEL;(function(CREATED_BY_LABEL){CREATED_BY_LABEL["SINGLE_METRIC"]="single-metric-wizard";CREATED_BY_LABEL["MULTI_METRIC"]="multi-metric-wizard";CREATED_BY_LABEL["POPULATION"]="population-wizard";CREATED_BY_LABEL["CATEGORIZATION"]="categorization-wizard";CREATED_BY_LABEL["APM_TRANSACTION"]="ml-module-apm-transaction"})(CREATED_BY_LABEL||(CREATED_BY_LABEL={}));const DEFAULT_MODEL_MEMORY_LIMIT="10MB";const DEFAULT_BUCKET_SPAN="15m";const DEFAULT_RARE_BUCKET_SPAN="1h";const DEFAULT_QUERY_DELAY="60s";const SHARED_RESULTS_INDEX_NAME="shared"},76:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return ML_JOB_FIELD_TYPES}));__webpack_require__.d(__webpack_exports__,"b",(function(){return MLCATEGORY}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DOC_COUNT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return _DOC_COUNT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return OMIT_FIELDS}));const ML_JOB_FIELD_TYPES={BOOLEAN:"boolean",DATE:"date",GEO_POINT:"geo_point",GEO_SHAPE:"geo_shape",IP:"ip",KEYWORD:"keyword",NUMBER:"number",TEXT:"text",UNKNOWN:"unknown"};const MLCATEGORY="mlcategory";const DOC_COUNT="doc_count";const _DOC_COUNT="_doc_count";const OMIT_FIELDS=["_source","_type","_index","_id","_version","_score"]},79:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return ML_JOB_AGGREGATION}));__webpack_require__.d(__webpack_exports__,"c",(function(){return SPARSE_DATA_AGGREGATIONS}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ES_AGGREGATION}));__webpack_require__.d(__webpack_exports__,"e",(function(){return mlOnlyAggregations}));__webpack_require__.d(__webpack_exports__,"d",(function(){return aggregations}));var _types_fields__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(105);let ML_JOB_AGGREGATION;(function(ML_JOB_AGGREGATION){ML_JOB_AGGREGATION["COUNT"]="count";ML_JOB_AGGREGATION["HIGH_COUNT"]="high_count";ML_JOB_AGGREGATION["LOW_COUNT"]="low_count";ML_JOB_AGGREGATION["NON_ZERO_COUNT"]="non_zero_count";ML_JOB_AGGREGATION["HIGH_NON_ZERO_COUNT"]="high_non_zero_count";ML_JOB_AGGREGATION["LOW_NON_ZERO_COUNT"]="low_non_zero_count";ML_JOB_AGGREGATION["DISTINCT_COUNT"]="distinct_count";ML_JOB_AGGREGATION["HIGH_DISTINCT_COUNT"]="high_distinct_count";ML_JOB_AGGREGATION["LOW_DISTINCT_COUNT"]="low_distinct_count";ML_JOB_AGGREGATION["MIN"]="min";ML_JOB_AGGREGATION["MAX"]="max";ML_JOB_AGGREGATION["MEDIAN"]="median";ML_JOB_AGGREGATION["LOW_MEDIAN"]="low_median";ML_JOB_AGGREGATION["HIGH_MEAN"]="high_mean";ML_JOB_AGGREGATION["MEAN"]="mean";ML_JOB_AGGREGATION["LOW_MEAN"]="low_mean";ML_JOB_AGGREGATION["HIGH_MEDIAN"]="high_median";ML_JOB_AGGREGATION["METRIC"]="metric";ML_JOB_AGGREGATION["VARP"]="varp";ML_JOB_AGGREGATION["HIGH_VARP"]="high_varp";ML_JOB_AGGREGATION["LOW_VARP"]="low_varp";ML_JOB_AGGREGATION["SUM"]="sum";ML_JOB_AGGREGATION["HIGH_SUM"]="high_sum";ML_JOB_AGGREGATION["LOW_SUM"]="low_sum";ML_JOB_AGGREGATION["NON_NULL_SUM"]="non_null_sum";ML_JOB_AGGREGATION["HIGH_NON_NULL_SUM"]="high_non_null_sum";ML_JOB_AGGREGATION["LOW_NON_NULL_SUM"]="low_non_null_sum";ML_JOB_AGGREGATION["RARE"]="rare";ML_JOB_AGGREGATION["FREQ_RARE"]="freq_rare";ML_JOB_AGGREGATION["INFO_CONTENT"]="info_content";ML_JOB_AGGREGATION["HIGH_INFO_CONTENT"]="high_info_content";ML_JOB_AGGREGATION["LOW_INFO_CONTENT"]="low_info_content";ML_JOB_AGGREGATION["TIME_OF_DAY"]="time_of_day";ML_JOB_AGGREGATION["TIME_OF_WEEK"]="time_of_week";ML_JOB_AGGREGATION["LAT_LONG"]="lat_long"})(ML_JOB_AGGREGATION||(ML_JOB_AGGREGATION={}));const SPARSE_DATA_AGGREGATIONS=[ML_JOB_AGGREGATION.NON_ZERO_COUNT,ML_JOB_AGGREGATION.HIGH_NON_ZERO_COUNT,ML_JOB_AGGREGATION.LOW_NON_ZERO_COUNT,ML_JOB_AGGREGATION.NON_NULL_SUM,ML_JOB_AGGREGATION.HIGH_NON_NULL_SUM,ML_JOB_AGGREGATION.LOW_NON_NULL_SUM];let KIBANA_AGGREGATION;(function(KIBANA_AGGREGATION){KIBANA_AGGREGATION["COUNT"]="count";KIBANA_AGGREGATION["AVG"]="avg";KIBANA_AGGREGATION["MAX"]="max";KIBANA_AGGREGATION["MIN"]="min";KIBANA_AGGREGATION["SUM"]="sum";KIBANA_AGGREGATION["MEDIAN"]="median";KIBANA_AGGREGATION["CARDINALITY"]="cardinality"})(KIBANA_AGGREGATION||(KIBANA_AGGREGATION={}));let ES_AGGREGATION;(function(ES_AGGREGATION){ES_AGGREGATION["COUNT"]="count";ES_AGGREGATION["AVG"]="avg";ES_AGGREGATION["MAX"]="max";ES_AGGREGATION["MIN"]="min";ES_AGGREGATION["SUM"]="sum";ES_AGGREGATION["PERCENTILES"]="percentiles";ES_AGGREGATION["CARDINALITY"]="cardinality"})(ES_AGGREGATION||(ES_AGGREGATION={}));function getBasicMlOnlyAggregation(){return{kibanaName:null,dslName:null,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN}}}const mlOnlyAggregations=[{id:ML_JOB_AGGREGATION.NON_ZERO_COUNT,title:"Non zero count",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.HIGH_NON_ZERO_COUNT,title:"High non zero count",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.LOW_NON_ZERO_COUNT,title:"Low non zero count",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.HIGH_DISTINCT_COUNT,title:"High distinct count",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.LOW_DISTINCT_COUNT,title:"Low distinct count",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.METRIC,title:"Metric",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.VARP,title:"varp",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.HIGH_VARP,title:"High varp",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.LOW_VARP,title:"Low varp",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.NON_NULL_SUM,title:"Non null sum",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.HIGH_NON_NULL_SUM,title:"High non null sum",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.LOW_NON_NULL_SUM,title:"Low non null sum",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.RARE,title:"Rare",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.FREQ_RARE,title:"Freq rare",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.INFO_CONTENT,title:"Info content",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.HIGH_INFO_CONTENT,title:"High info content",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.LOW_INFO_CONTENT,title:"Low info content",fields:[],...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.TIME_OF_DAY,title:"Time of day",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.TIME_OF_WEEK,title:"Time of week",...getBasicMlOnlyAggregation()},{id:ML_JOB_AGGREGATION.LAT_LONG,title:"Lat long",fields:[],...getBasicMlOnlyAggregation()}];const aggregations=[{id:ML_JOB_AGGREGATION.COUNT,title:"Count",kibanaName:KIBANA_AGGREGATION.COUNT,dslName:ES_AGGREGATION.COUNT,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN}},{id:ML_JOB_AGGREGATION.HIGH_COUNT,title:"High count",kibanaName:KIBANA_AGGREGATION.COUNT,dslName:ES_AGGREGATION.COUNT,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN}},{id:ML_JOB_AGGREGATION.LOW_COUNT,title:"Low count",kibanaName:KIBANA_AGGREGATION.COUNT,dslName:ES_AGGREGATION.COUNT,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN}},{id:ML_JOB_AGGREGATION.MEAN,title:"Mean",kibanaName:KIBANA_AGGREGATION.AVG,dslName:ES_AGGREGATION.AVG,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.AVG,min:KIBANA_AGGREGATION.AVG},fields:[]},{id:ML_JOB_AGGREGATION.HIGH_MEAN,title:"High mean",kibanaName:KIBANA_AGGREGATION.AVG,dslName:ES_AGGREGATION.AVG,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.AVG,min:KIBANA_AGGREGATION.AVG},fields:[]},{id:ML_JOB_AGGREGATION.LOW_MEAN,title:"Low mean",kibanaName:KIBANA_AGGREGATION.AVG,dslName:ES_AGGREGATION.AVG,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.AVG,min:KIBANA_AGGREGATION.AVG},fields:[]},{id:ML_JOB_AGGREGATION.SUM,title:"Sum",kibanaName:KIBANA_AGGREGATION.SUM,dslName:ES_AGGREGATION.SUM,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.SUM,min:KIBANA_AGGREGATION.SUM},fields:[]},{id:ML_JOB_AGGREGATION.HIGH_SUM,title:"High sum",kibanaName:KIBANA_AGGREGATION.SUM,dslName:ES_AGGREGATION.SUM,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.SUM,min:KIBANA_AGGREGATION.SUM},fields:[]},{id:ML_JOB_AGGREGATION.LOW_SUM,title:"Low sum",kibanaName:KIBANA_AGGREGATION.SUM,dslName:ES_AGGREGATION.SUM,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.SUM,min:KIBANA_AGGREGATION.SUM},fields:[]},{id:ML_JOB_AGGREGATION.MEDIAN,title:"Median",kibanaName:KIBANA_AGGREGATION.MEDIAN,dslName:ES_AGGREGATION.PERCENTILES,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN},fields:[]},{id:ML_JOB_AGGREGATION.HIGH_MEDIAN,title:"High median",kibanaName:KIBANA_AGGREGATION.MEDIAN,dslName:ES_AGGREGATION.PERCENTILES,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN},fields:[]},{id:ML_JOB_AGGREGATION.LOW_MEDIAN,title:"Low median",kibanaName:KIBANA_AGGREGATION.MEDIAN,dslName:ES_AGGREGATION.PERCENTILES,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN},fields:[]},{id:ML_JOB_AGGREGATION.MIN,title:"Min",kibanaName:KIBANA_AGGREGATION.MIN,dslName:ES_AGGREGATION.MIN,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MIN,min:KIBANA_AGGREGATION.MIN},fields:[]},{id:ML_JOB_AGGREGATION.MAX,title:"Max",kibanaName:KIBANA_AGGREGATION.MAX,dslName:ES_AGGREGATION.MAX,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MAX},fields:[]},{id:ML_JOB_AGGREGATION.DISTINCT_COUNT,title:"Distinct count",kibanaName:KIBANA_AGGREGATION.CARDINALITY,dslName:ES_AGGREGATION.CARDINALITY,type:_types_fields__WEBPACK_IMPORTED_MODULE_0__["b"],mlModelPlotAgg:{max:KIBANA_AGGREGATION.MAX,min:KIBANA_AGGREGATION.MIN},fields:[]}]}}]);