"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNewMapPath = getNewMapPath;
exports.getExistingMapPath = getExistingMapPath;
exports.getEditPath = getEditPath;
exports.DEFAULT_PERCENTILES = exports.DATA_MAPPING_FUNCTION = exports.MB_LOOKUP_FUNCTION = exports.VECTOR_SHAPE_TYPE = exports.LAYER_WIZARD_CATEGORY = exports.INITIAL_LOCATION = exports.SPATIAL_FILTERS_LAYER_ID = exports.MVT_FIELD_TYPE = exports.FORMAT_TYPE = exports.SCALING_TYPES = exports.VECTOR_STYLES = exports.DEFAULT_ICON = exports.LABEL_BORDER_SIZES = exports.SYMBOLIZE_AS_TYPES = exports.ORDINAL_DATA_TYPES = exports.CATEGORICAL_DATA_TYPES = exports.COLOR_MAP_TYPE = exports.LAYER_STYLE_TYPE = exports.STYLE_TYPE = exports.COUNT_PROP_NAME = exports.COUNT_PROP_LABEL = exports.DEFAULT_PERCENTILE = exports.TOP_TERM_PERCENTAGE_SUFFIX = exports.GEOCENTROID_AGG_NAME = exports.GEOTILE_GRID_AGG_NAME = exports.SUPER_FINE_ZOOM_DELTA = exports.GRID_RESOLUTION = exports.RENDER_AS = exports.AGG_TYPE = exports.AGG_DELIMITER = exports.DRAW_TYPE = exports.EMPTY_FEATURE_COLLECTION = exports.LAT_INDEX = exports.LON_INDEX = exports.POLYGON_COORDINATES_EXTERIOR_INDEX = exports.GEO_JSON_TYPE = exports.ES_SPATIAL_RELATIONS = exports.ES_GEO_FIELD_TYPES = exports.ES_GEO_FIELD_TYPE = exports.MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER = exports.FEATURE_VISIBLE_PROPERTY_NAME = exports.FEATURE_ID_PROPERTY_NAME = exports.DEFAULT_MAX_BUCKETS_LIMIT = exports.DEFAULT_MAX_INNER_RESULT_WINDOW = exports.DEFAULT_MAX_RESULT_WINDOW = exports.ZOOM_PRECISION = exports.DECIMAL_DEGREES_PRECISION = exports.MAX_ZOOM = exports.MIN_ZOOM = exports.SOURCE_BOUNDS_DATA_REQUEST_ID = exports.SOURCE_FORMATTERS_DATA_REQUEST_ID = exports.SOURCE_META_DATA_REQUEST_ID = exports.SOURCE_DATA_REQUEST_ID = exports.FORMATTERS_DATA_REQUEST_ID_SUFFIX = exports.META_DATA_REQUEST_ID_SUFFIX = exports.JOIN_FIELD_NAME_PREFIX = exports.FIELD_ORIGIN = exports.SOURCE_TYPES = exports.LAYER_TYPE = exports.KBN_IS_CENTROID_FEATURE = exports.KBN_TOO_MANY_FEATURES_IMAGE_ID = exports.KBN_TOO_MANY_FEATURES_PROPERTY = exports.MVT_SOURCE_LAYER_NAME = exports.MVT_GETGRIDTILE_API_PATH = exports.MVT_GETTILE_API_PATH = exports.API_ROOT_PATH = exports.FONTS_API_PATH = exports.INDEX_SETTINGS_API_PATH = exports.GIS_API_PATH = exports.MAP_PATH = exports.MAPS_APP_PATH = exports.INITIAL_LAYERS_KEY = exports.APP_NAME = exports.APP_ICON_SOLUTION = exports.APP_ICON = exports.APP_ID = exports.MAP_SAVED_OBJECT_TYPE = exports.EMS_TILES_VECTOR_TILE_PATH = exports.EMS_TILES_VECTOR_SOURCE_PATH = exports.EMS_TILES_VECTOR_STYLE_PATH = exports.EMS_TILES_RASTER_TILE_PATH = exports.EMS_TILES_RASTER_STYLE_PATH = exports.EMS_TILES_API_PATH = exports.EMS_TILES_CATALOGUE_PATH = exports.EMS_SPRITES_PATH = exports.EMS_GLYPHS_PATH = exports.EMS_FILES_DEFAULT_JSON_PATH = exports.EMS_FILES_API_PATH = exports.EMS_FILES_CATALOGUE_PATH = exports.EMS_CATALOGUE_PATH = exports.EMS_APP_NAME = void 0;

var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */


const EMS_APP_NAME = 'kibana';
exports.EMS_APP_NAME = EMS_APP_NAME;
const EMS_CATALOGUE_PATH = 'ems/catalogue';
exports.EMS_CATALOGUE_PATH = EMS_CATALOGUE_PATH;
const EMS_FILES_CATALOGUE_PATH = 'ems/files';
exports.EMS_FILES_CATALOGUE_PATH = EMS_FILES_CATALOGUE_PATH;
const EMS_FILES_API_PATH = 'ems/files';
exports.EMS_FILES_API_PATH = EMS_FILES_API_PATH;
const EMS_FILES_DEFAULT_JSON_PATH = 'file';
exports.EMS_FILES_DEFAULT_JSON_PATH = EMS_FILES_DEFAULT_JSON_PATH;
const EMS_GLYPHS_PATH = 'fonts';
exports.EMS_GLYPHS_PATH = EMS_GLYPHS_PATH;
const EMS_SPRITES_PATH = 'sprites';
exports.EMS_SPRITES_PATH = EMS_SPRITES_PATH;
const EMS_TILES_CATALOGUE_PATH = 'ems/tiles';
exports.EMS_TILES_CATALOGUE_PATH = EMS_TILES_CATALOGUE_PATH;
const EMS_TILES_API_PATH = 'ems/tiles';
exports.EMS_TILES_API_PATH = EMS_TILES_API_PATH;
const EMS_TILES_RASTER_STYLE_PATH = 'raster/style';
exports.EMS_TILES_RASTER_STYLE_PATH = EMS_TILES_RASTER_STYLE_PATH;
const EMS_TILES_RASTER_TILE_PATH = 'raster/tile';
exports.EMS_TILES_RASTER_TILE_PATH = EMS_TILES_RASTER_TILE_PATH;
const EMS_TILES_VECTOR_STYLE_PATH = 'vector/style';
exports.EMS_TILES_VECTOR_STYLE_PATH = EMS_TILES_VECTOR_STYLE_PATH;
const EMS_TILES_VECTOR_SOURCE_PATH = 'vector/source';
exports.EMS_TILES_VECTOR_SOURCE_PATH = EMS_TILES_VECTOR_SOURCE_PATH;
const EMS_TILES_VECTOR_TILE_PATH = 'vector/tile';
exports.EMS_TILES_VECTOR_TILE_PATH = EMS_TILES_VECTOR_TILE_PATH;
const MAP_SAVED_OBJECT_TYPE = 'map';
exports.MAP_SAVED_OBJECT_TYPE = MAP_SAVED_OBJECT_TYPE;
const APP_ID = 'maps';
exports.APP_ID = APP_ID;
const APP_ICON = 'gisApp';
exports.APP_ICON = APP_ICON;
const APP_ICON_SOLUTION = 'logoKibana';
exports.APP_ICON_SOLUTION = APP_ICON_SOLUTION;

const APP_NAME = _i18n.i18n.translate('xpack.maps.visTypeAlias.title', {
  defaultMessage: 'Maps'
});

exports.APP_NAME = APP_NAME;
const INITIAL_LAYERS_KEY = 'initialLayers';
exports.INITIAL_LAYERS_KEY = INITIAL_LAYERS_KEY;
const MAPS_APP_PATH = `app/${APP_ID}`;
exports.MAPS_APP_PATH = MAPS_APP_PATH;
const MAP_PATH = 'map';
exports.MAP_PATH = MAP_PATH;
const GIS_API_PATH = `api/${APP_ID}`;
exports.GIS_API_PATH = GIS_API_PATH;
const INDEX_SETTINGS_API_PATH = `${GIS_API_PATH}/indexSettings`;
exports.INDEX_SETTINGS_API_PATH = INDEX_SETTINGS_API_PATH;
const FONTS_API_PATH = `${GIS_API_PATH}/fonts`;
exports.FONTS_API_PATH = FONTS_API_PATH;
const API_ROOT_PATH = `/${GIS_API_PATH}`;
exports.API_ROOT_PATH = API_ROOT_PATH;
const MVT_GETTILE_API_PATH = 'mvt/getTile';
exports.MVT_GETTILE_API_PATH = MVT_GETTILE_API_PATH;
const MVT_GETGRIDTILE_API_PATH = 'mvt/getGridTile';
exports.MVT_GETGRIDTILE_API_PATH = MVT_GETGRIDTILE_API_PATH;
const MVT_SOURCE_LAYER_NAME = 'source_layer'; // Identifies vector tile "too many features" feature.
// "too many features" feature is a box showing area that contains too many features for single ES search response

exports.MVT_SOURCE_LAYER_NAME = MVT_SOURCE_LAYER_NAME;
const KBN_TOO_MANY_FEATURES_PROPERTY = '__kbn_too_many_features__';
exports.KBN_TOO_MANY_FEATURES_PROPERTY = KBN_TOO_MANY_FEATURES_PROPERTY;
const KBN_TOO_MANY_FEATURES_IMAGE_ID = '__kbn_too_many_features_image_id__'; // Identifies centroid feature.
// Centroids are a single point for representing lines, multiLines, polygons, and multiPolygons

exports.KBN_TOO_MANY_FEATURES_IMAGE_ID = KBN_TOO_MANY_FEATURES_IMAGE_ID;
const KBN_IS_CENTROID_FEATURE = '__kbn_is_centroid_feature__';
exports.KBN_IS_CENTROID_FEATURE = KBN_IS_CENTROID_FEATURE;
const MAP_BASE_URL = `/${MAPS_APP_PATH}/${MAP_PATH}`;

function getNewMapPath() {
  return MAP_BASE_URL;
}

function getExistingMapPath(id) {
  return `${MAP_BASE_URL}/${id}`;
}

function getEditPath(id) {
  return `/${MAP_PATH}/${id}`;
}

let LAYER_TYPE;
exports.LAYER_TYPE = LAYER_TYPE;

(function (LAYER_TYPE) {
  LAYER_TYPE["TILE"] = "TILE";
  LAYER_TYPE["VECTOR"] = "VECTOR";
  LAYER_TYPE["VECTOR_TILE"] = "VECTOR_TILE";
  LAYER_TYPE["HEATMAP"] = "HEATMAP";
  LAYER_TYPE["BLENDED_VECTOR"] = "BLENDED_VECTOR";
  LAYER_TYPE["TILED_VECTOR"] = "TILED_VECTOR";
})(LAYER_TYPE || (exports.LAYER_TYPE = LAYER_TYPE = {}));

let SOURCE_TYPES;
exports.SOURCE_TYPES = SOURCE_TYPES;

(function (SOURCE_TYPES) {
  SOURCE_TYPES["EMS_TMS"] = "EMS_TMS";
  SOURCE_TYPES["EMS_FILE"] = "EMS_FILE";
  SOURCE_TYPES["ES_GEO_GRID"] = "ES_GEO_GRID";
  SOURCE_TYPES["ES_GEO_LINE"] = "ES_GEO_LINE";
  SOURCE_TYPES["ES_SEARCH"] = "ES_SEARCH";
  SOURCE_TYPES["ES_PEW_PEW"] = "ES_PEW_PEW";
  SOURCE_TYPES["ES_TERM_SOURCE"] = "ES_TERM_SOURCE";
  SOURCE_TYPES["EMS_XYZ"] = "EMS_XYZ";
  SOURCE_TYPES["WMS"] = "WMS";
  SOURCE_TYPES["KIBANA_TILEMAP"] = "KIBANA_TILEMAP";
  SOURCE_TYPES["REGIONMAP_FILE"] = "REGIONMAP_FILE";
  SOURCE_TYPES["GEOJSON_FILE"] = "GEOJSON_FILE";
  SOURCE_TYPES["MVT_SINGLE_LAYER"] = "MVT_SINGLE_LAYER";
  SOURCE_TYPES["TABLE_SOURCE"] = "TABLE_SOURCE";
})(SOURCE_TYPES || (exports.SOURCE_TYPES = SOURCE_TYPES = {}));

let FIELD_ORIGIN;
exports.FIELD_ORIGIN = FIELD_ORIGIN;

(function (FIELD_ORIGIN) {
  FIELD_ORIGIN["SOURCE"] = "source";
  FIELD_ORIGIN["JOIN"] = "join";
})(FIELD_ORIGIN || (exports.FIELD_ORIGIN = FIELD_ORIGIN = {}));

const JOIN_FIELD_NAME_PREFIX = '__kbnjoin__';
exports.JOIN_FIELD_NAME_PREFIX = JOIN_FIELD_NAME_PREFIX;
const META_DATA_REQUEST_ID_SUFFIX = 'meta';
exports.META_DATA_REQUEST_ID_SUFFIX = META_DATA_REQUEST_ID_SUFFIX;
const FORMATTERS_DATA_REQUEST_ID_SUFFIX = 'formatters';
exports.FORMATTERS_DATA_REQUEST_ID_SUFFIX = FORMATTERS_DATA_REQUEST_ID_SUFFIX;
const SOURCE_DATA_REQUEST_ID = 'source';
exports.SOURCE_DATA_REQUEST_ID = SOURCE_DATA_REQUEST_ID;
const SOURCE_META_DATA_REQUEST_ID = `${SOURCE_DATA_REQUEST_ID}_${META_DATA_REQUEST_ID_SUFFIX}`;
exports.SOURCE_META_DATA_REQUEST_ID = SOURCE_META_DATA_REQUEST_ID;
const SOURCE_FORMATTERS_DATA_REQUEST_ID = `${SOURCE_DATA_REQUEST_ID}_${FORMATTERS_DATA_REQUEST_ID_SUFFIX}`;
exports.SOURCE_FORMATTERS_DATA_REQUEST_ID = SOURCE_FORMATTERS_DATA_REQUEST_ID;
const SOURCE_BOUNDS_DATA_REQUEST_ID = `${SOURCE_DATA_REQUEST_ID}_bounds`;
exports.SOURCE_BOUNDS_DATA_REQUEST_ID = SOURCE_BOUNDS_DATA_REQUEST_ID;
const MIN_ZOOM = 0;
exports.MIN_ZOOM = MIN_ZOOM;
const MAX_ZOOM = 24;
exports.MAX_ZOOM = MAX_ZOOM;
const DECIMAL_DEGREES_PRECISION = 5; // meters precision

exports.DECIMAL_DEGREES_PRECISION = DECIMAL_DEGREES_PRECISION;
const ZOOM_PRECISION = 2;
exports.ZOOM_PRECISION = ZOOM_PRECISION;
const DEFAULT_MAX_RESULT_WINDOW = 10000;
exports.DEFAULT_MAX_RESULT_WINDOW = DEFAULT_MAX_RESULT_WINDOW;
const DEFAULT_MAX_INNER_RESULT_WINDOW = 100;
exports.DEFAULT_MAX_INNER_RESULT_WINDOW = DEFAULT_MAX_INNER_RESULT_WINDOW;
const DEFAULT_MAX_BUCKETS_LIMIT = 65535;
exports.DEFAULT_MAX_BUCKETS_LIMIT = DEFAULT_MAX_BUCKETS_LIMIT;
const FEATURE_ID_PROPERTY_NAME = '__kbn__feature_id__';
exports.FEATURE_ID_PROPERTY_NAME = FEATURE_ID_PROPERTY_NAME;
const FEATURE_VISIBLE_PROPERTY_NAME = '__kbn_isvisibleduetojoin__';
exports.FEATURE_VISIBLE_PROPERTY_NAME = FEATURE_VISIBLE_PROPERTY_NAME;
const MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER = '_';
exports.MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER = MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER;
let ES_GEO_FIELD_TYPE; // Using strings instead of ES_GEO_FIELD_TYPE enum to avoid typeing errors where IFieldType.type is compared to value

exports.ES_GEO_FIELD_TYPE = ES_GEO_FIELD_TYPE;

(function (ES_GEO_FIELD_TYPE) {
  ES_GEO_FIELD_TYPE["GEO_POINT"] = "geo_point";
  ES_GEO_FIELD_TYPE["GEO_SHAPE"] = "geo_shape";
})(ES_GEO_FIELD_TYPE || (exports.ES_GEO_FIELD_TYPE = ES_GEO_FIELD_TYPE = {}));

const ES_GEO_FIELD_TYPES = ['geo_point', 'geo_shape'];
exports.ES_GEO_FIELD_TYPES = ES_GEO_FIELD_TYPES;
let ES_SPATIAL_RELATIONS;
exports.ES_SPATIAL_RELATIONS = ES_SPATIAL_RELATIONS;

(function (ES_SPATIAL_RELATIONS) {
  ES_SPATIAL_RELATIONS["INTERSECTS"] = "INTERSECTS";
  ES_SPATIAL_RELATIONS["DISJOINT"] = "DISJOINT";
  ES_SPATIAL_RELATIONS["WITHIN"] = "WITHIN";
})(ES_SPATIAL_RELATIONS || (exports.ES_SPATIAL_RELATIONS = ES_SPATIAL_RELATIONS = {}));

const GEO_JSON_TYPE = {
  POINT: 'Point',
  MULTI_POINT: 'MultiPoint',
  LINE_STRING: 'LineString',
  MULTI_LINE_STRING: 'MultiLineString',
  POLYGON: 'Polygon',
  MULTI_POLYGON: 'MultiPolygon',
  GEOMETRY_COLLECTION: 'GeometryCollection'
};
exports.GEO_JSON_TYPE = GEO_JSON_TYPE;
const POLYGON_COORDINATES_EXTERIOR_INDEX = 0;
exports.POLYGON_COORDINATES_EXTERIOR_INDEX = POLYGON_COORDINATES_EXTERIOR_INDEX;
const LON_INDEX = 0;
exports.LON_INDEX = LON_INDEX;
const LAT_INDEX = 1;
exports.LAT_INDEX = LAT_INDEX;
const EMPTY_FEATURE_COLLECTION = {
  type: 'FeatureCollection',
  features: []
};
exports.EMPTY_FEATURE_COLLECTION = EMPTY_FEATURE_COLLECTION;
let DRAW_TYPE;
exports.DRAW_TYPE = DRAW_TYPE;

(function (DRAW_TYPE) {
  DRAW_TYPE["BOUNDS"] = "BOUNDS";
  DRAW_TYPE["DISTANCE"] = "DISTANCE";
  DRAW_TYPE["POLYGON"] = "POLYGON";
})(DRAW_TYPE || (exports.DRAW_TYPE = DRAW_TYPE = {}));

const AGG_DELIMITER = '_of_';
exports.AGG_DELIMITER = AGG_DELIMITER;
let AGG_TYPE;
exports.AGG_TYPE = AGG_TYPE;

(function (AGG_TYPE) {
  AGG_TYPE["AVG"] = "avg";
  AGG_TYPE["COUNT"] = "count";
  AGG_TYPE["MAX"] = "max";
  AGG_TYPE["MIN"] = "min";
  AGG_TYPE["SUM"] = "sum";
  AGG_TYPE["TERMS"] = "terms";
  AGG_TYPE["PERCENTILE"] = "percentile";
  AGG_TYPE["UNIQUE_COUNT"] = "cardinality";
})(AGG_TYPE || (exports.AGG_TYPE = AGG_TYPE = {}));

let RENDER_AS;
exports.RENDER_AS = RENDER_AS;

(function (RENDER_AS) {
  RENDER_AS["HEATMAP"] = "heatmap";
  RENDER_AS["POINT"] = "point";
  RENDER_AS["GRID"] = "grid";
})(RENDER_AS || (exports.RENDER_AS = RENDER_AS = {}));

let GRID_RESOLUTION;
exports.GRID_RESOLUTION = GRID_RESOLUTION;

(function (GRID_RESOLUTION) {
  GRID_RESOLUTION["COARSE"] = "COARSE";
  GRID_RESOLUTION["FINE"] = "FINE";
  GRID_RESOLUTION["MOST_FINE"] = "MOST_FINE";
  GRID_RESOLUTION["SUPER_FINE"] = "SUPER_FINE";
})(GRID_RESOLUTION || (exports.GRID_RESOLUTION = GRID_RESOLUTION = {}));

const SUPER_FINE_ZOOM_DELTA = 7; // (2 ^ SUPER_FINE_ZOOM_DELTA) ^ 2 =  number of cells in a given tile

exports.SUPER_FINE_ZOOM_DELTA = SUPER_FINE_ZOOM_DELTA;
const GEOTILE_GRID_AGG_NAME = 'gridSplit';
exports.GEOTILE_GRID_AGG_NAME = GEOTILE_GRID_AGG_NAME;
const GEOCENTROID_AGG_NAME = 'gridCentroid';
exports.GEOCENTROID_AGG_NAME = GEOCENTROID_AGG_NAME;
const TOP_TERM_PERCENTAGE_SUFFIX = '__percentage';
exports.TOP_TERM_PERCENTAGE_SUFFIX = TOP_TERM_PERCENTAGE_SUFFIX;
const DEFAULT_PERCENTILE = 50;
exports.DEFAULT_PERCENTILE = DEFAULT_PERCENTILE;

const COUNT_PROP_LABEL = _i18n.i18n.translate('xpack.maps.aggs.defaultCountLabel', {
  defaultMessage: 'count'
});

exports.COUNT_PROP_LABEL = COUNT_PROP_LABEL;
const COUNT_PROP_NAME = 'doc_count';
exports.COUNT_PROP_NAME = COUNT_PROP_NAME;
let STYLE_TYPE;
exports.STYLE_TYPE = STYLE_TYPE;

(function (STYLE_TYPE) {
  STYLE_TYPE["STATIC"] = "STATIC";
  STYLE_TYPE["DYNAMIC"] = "DYNAMIC";
})(STYLE_TYPE || (exports.STYLE_TYPE = STYLE_TYPE = {}));

let LAYER_STYLE_TYPE;
exports.LAYER_STYLE_TYPE = LAYER_STYLE_TYPE;

(function (LAYER_STYLE_TYPE) {
  LAYER_STYLE_TYPE["VECTOR"] = "VECTOR";
  LAYER_STYLE_TYPE["HEATMAP"] = "HEATMAP";
  LAYER_STYLE_TYPE["TILE"] = "TILE";
})(LAYER_STYLE_TYPE || (exports.LAYER_STYLE_TYPE = LAYER_STYLE_TYPE = {}));

let COLOR_MAP_TYPE;
exports.COLOR_MAP_TYPE = COLOR_MAP_TYPE;

(function (COLOR_MAP_TYPE) {
  COLOR_MAP_TYPE["CATEGORICAL"] = "CATEGORICAL";
  COLOR_MAP_TYPE["ORDINAL"] = "ORDINAL";
})(COLOR_MAP_TYPE || (exports.COLOR_MAP_TYPE = COLOR_MAP_TYPE = {}));

const CATEGORICAL_DATA_TYPES = ['string', 'ip', 'boolean'];
exports.CATEGORICAL_DATA_TYPES = CATEGORICAL_DATA_TYPES;
const ORDINAL_DATA_TYPES = ['number', 'date'];
exports.ORDINAL_DATA_TYPES = ORDINAL_DATA_TYPES;
let SYMBOLIZE_AS_TYPES;
exports.SYMBOLIZE_AS_TYPES = SYMBOLIZE_AS_TYPES;

(function (SYMBOLIZE_AS_TYPES) {
  SYMBOLIZE_AS_TYPES["CIRCLE"] = "circle";
  SYMBOLIZE_AS_TYPES["ICON"] = "icon";
})(SYMBOLIZE_AS_TYPES || (exports.SYMBOLIZE_AS_TYPES = SYMBOLIZE_AS_TYPES = {}));

let LABEL_BORDER_SIZES;
exports.LABEL_BORDER_SIZES = LABEL_BORDER_SIZES;

(function (LABEL_BORDER_SIZES) {
  LABEL_BORDER_SIZES["NONE"] = "NONE";
  LABEL_BORDER_SIZES["SMALL"] = "SMALL";
  LABEL_BORDER_SIZES["MEDIUM"] = "MEDIUM";
  LABEL_BORDER_SIZES["LARGE"] = "LARGE";
})(LABEL_BORDER_SIZES || (exports.LABEL_BORDER_SIZES = LABEL_BORDER_SIZES = {}));

const DEFAULT_ICON = 'marker';
exports.DEFAULT_ICON = DEFAULT_ICON;
let VECTOR_STYLES;
exports.VECTOR_STYLES = VECTOR_STYLES;

(function (VECTOR_STYLES) {
  VECTOR_STYLES["SYMBOLIZE_AS"] = "symbolizeAs";
  VECTOR_STYLES["FILL_COLOR"] = "fillColor";
  VECTOR_STYLES["LINE_COLOR"] = "lineColor";
  VECTOR_STYLES["LINE_WIDTH"] = "lineWidth";
  VECTOR_STYLES["ICON"] = "icon";
  VECTOR_STYLES["ICON_SIZE"] = "iconSize";
  VECTOR_STYLES["ICON_ORIENTATION"] = "iconOrientation";
  VECTOR_STYLES["LABEL_TEXT"] = "labelText";
  VECTOR_STYLES["LABEL_COLOR"] = "labelColor";
  VECTOR_STYLES["LABEL_SIZE"] = "labelSize";
  VECTOR_STYLES["LABEL_BORDER_COLOR"] = "labelBorderColor";
  VECTOR_STYLES["LABEL_BORDER_SIZE"] = "labelBorderSize";
})(VECTOR_STYLES || (exports.VECTOR_STYLES = VECTOR_STYLES = {}));

let SCALING_TYPES;
exports.SCALING_TYPES = SCALING_TYPES;

(function (SCALING_TYPES) {
  SCALING_TYPES["LIMIT"] = "LIMIT";
  SCALING_TYPES["CLUSTERS"] = "CLUSTERS";
  SCALING_TYPES["TOP_HITS"] = "TOP_HITS";
  SCALING_TYPES["MVT"] = "MVT";
})(SCALING_TYPES || (exports.SCALING_TYPES = SCALING_TYPES = {}));

let FORMAT_TYPE;
exports.FORMAT_TYPE = FORMAT_TYPE;

(function (FORMAT_TYPE) {
  FORMAT_TYPE["GEOJSON"] = "geojson";
  FORMAT_TYPE["TOPOJSON"] = "topojson";
})(FORMAT_TYPE || (exports.FORMAT_TYPE = FORMAT_TYPE = {}));

let MVT_FIELD_TYPE;
exports.MVT_FIELD_TYPE = MVT_FIELD_TYPE;

(function (MVT_FIELD_TYPE) {
  MVT_FIELD_TYPE["STRING"] = "String";
  MVT_FIELD_TYPE["NUMBER"] = "Number";
})(MVT_FIELD_TYPE || (exports.MVT_FIELD_TYPE = MVT_FIELD_TYPE = {}));

const SPATIAL_FILTERS_LAYER_ID = 'SPATIAL_FILTERS_LAYER_ID';
exports.SPATIAL_FILTERS_LAYER_ID = SPATIAL_FILTERS_LAYER_ID;
let INITIAL_LOCATION;
exports.INITIAL_LOCATION = INITIAL_LOCATION;

(function (INITIAL_LOCATION) {
  INITIAL_LOCATION["LAST_SAVED_LOCATION"] = "LAST_SAVED_LOCATION";
  INITIAL_LOCATION["FIXED_LOCATION"] = "FIXED_LOCATION";
  INITIAL_LOCATION["BROWSER_LOCATION"] = "BROWSER_LOCATION";
  INITIAL_LOCATION["AUTO_FIT_TO_BOUNDS"] = "AUTO_FIT_TO_BOUNDS";
})(INITIAL_LOCATION || (exports.INITIAL_LOCATION = INITIAL_LOCATION = {}));

let LAYER_WIZARD_CATEGORY;
exports.LAYER_WIZARD_CATEGORY = LAYER_WIZARD_CATEGORY;

(function (LAYER_WIZARD_CATEGORY) {
  LAYER_WIZARD_CATEGORY["ELASTICSEARCH"] = "ELASTICSEARCH";
  LAYER_WIZARD_CATEGORY["REFERENCE"] = "REFERENCE";
  LAYER_WIZARD_CATEGORY["SOLUTIONS"] = "SOLUTIONS";
})(LAYER_WIZARD_CATEGORY || (exports.LAYER_WIZARD_CATEGORY = LAYER_WIZARD_CATEGORY = {}));

let VECTOR_SHAPE_TYPE; // https://docs.mapbox.com/mapbox-gl-js/style-spec/expressions/#data-expressions

exports.VECTOR_SHAPE_TYPE = VECTOR_SHAPE_TYPE;

(function (VECTOR_SHAPE_TYPE) {
  VECTOR_SHAPE_TYPE["POINT"] = "POINT";
  VECTOR_SHAPE_TYPE["LINE"] = "LINE";
  VECTOR_SHAPE_TYPE["POLYGON"] = "POLYGON";
})(VECTOR_SHAPE_TYPE || (exports.VECTOR_SHAPE_TYPE = VECTOR_SHAPE_TYPE = {}));

let MB_LOOKUP_FUNCTION;
exports.MB_LOOKUP_FUNCTION = MB_LOOKUP_FUNCTION;

(function (MB_LOOKUP_FUNCTION) {
  MB_LOOKUP_FUNCTION["GET"] = "get";
  MB_LOOKUP_FUNCTION["FEATURE_STATE"] = "feature-state";
})(MB_LOOKUP_FUNCTION || (exports.MB_LOOKUP_FUNCTION = MB_LOOKUP_FUNCTION = {}));

let DATA_MAPPING_FUNCTION;
exports.DATA_MAPPING_FUNCTION = DATA_MAPPING_FUNCTION;

(function (DATA_MAPPING_FUNCTION) {
  DATA_MAPPING_FUNCTION["INTERPOLATE"] = "INTERPOLATE";
  DATA_MAPPING_FUNCTION["PERCENTILES"] = "PERCENTILES";
})(DATA_MAPPING_FUNCTION || (exports.DATA_MAPPING_FUNCTION = DATA_MAPPING_FUNCTION = {}));

const DEFAULT_PERCENTILES = [50, 75, 90, 95, 99];
exports.DEFAULT_PERCENTILES = DEFAULT_PERCENTILES;