/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["logstash_bundle_jsonpfunction"]=window["logstash_bundle_jsonpfunction"]||[]).push([[1],{18:function(module,exports){ace.define("ace/mode/plain_text",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/text_highlight_rules","ace/mode/behaviour"],(function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextMode=acequire("./text").Mode;var TextHighlightRules=acequire("./text_highlight_rules").TextHighlightRules;var Behaviour=acequire("./behaviour").Behaviour;var Mode=function(){this.HighlightRules=TextHighlightRules;this.$behaviour=new Behaviour};oop.inherits(Mode,TextMode);(function(){this.type="text";this.getNextLineIndent=function(state,line,tab){return""};this.$id="ace/mode/plain_text"}).call(Mode.prototype);exports.Mode=Mode}))},19:function(module,exports){ace.define("ace/theme/github",["require","exports","module","ace/lib/dom"],(function(acequire,exports,module){exports.isDark=false;exports.cssClass="ace-github";exports.cssText='.ace-github .ace_gutter {background: #e8e8e8;color: #AAA;}.ace-github  {background: #fff;color: #000;}.ace-github .ace_keyword {font-weight: bold;}.ace-github .ace_string {color: #D14;}.ace-github .ace_variable.ace_class {color: teal;}.ace-github .ace_constant.ace_numeric {color: #099;}.ace-github .ace_constant.ace_buildin {color: #0086B3;}.ace-github .ace_support.ace_function {color: #0086B3;}.ace-github .ace_comment {color: #998;font-style: italic;}.ace-github .ace_variable.ace_language  {color: #0086B3;}.ace-github .ace_paren {font-weight: bold;}.ace-github .ace_boolean {font-weight: bold;}.ace-github .ace_string.ace_regexp {color: #009926;font-weight: normal;}.ace-github .ace_variable.ace_instance {color: teal;}.ace-github .ace_constant.ace_language {font-weight: bold;}.ace-github .ace_cursor {color: black;}.ace-github.ace_focus .ace_marker-layer .ace_active-line {background: rgb(255, 255, 204);}.ace-github .ace_marker-layer .ace_active-line {background: rgb(245, 245, 245);}.ace-github .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-github.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-github.ace_nobold .ace_line > span {font-weight: normal !important;}.ace-github .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-github .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-github .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-github .ace_gutter-active-line {background-color : rgba(0, 0, 0, 0.07);}.ace-github .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-github .ace_invisible {color: #BFBFBF}.ace-github .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-github .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}';var dom=acequire("../lib/dom");dom.importCssString(exports.cssText,exports.cssClass)}))},20:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(17);var react_1=__webpack_require__(12);var useMountedState_1=tslib_1.__importDefault(__webpack_require__(21));var usePromise=function(){var isMounted=useMountedState_1.default();return react_1.useCallback((function(promise){return new Promise((function(resolve,reject){var onValue=function(value){isMounted()&&resolve(value)};var onError=function(error){isMounted()&&reject(error)};promise.then(onValue,onError)}))}),[])};exports.default=usePromise},21:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(12);function useMountedState(){var mountedRef=react_1.useRef(false);var get=react_1.useCallback((function(){return mountedRef.current}),[]);react_1.useEffect((function(){mountedRef.current=true;return function(){mountedRef.current=false}}));return get}exports.default=useMountedState},22:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_kbnSharedDeps_React_=__webpack_require__(12);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(15);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(16);var external_kbnSharedDeps_RxjsOperators_=__webpack_require__(5);var services=__webpack_require__(6);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(14);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(13);function AddRoleAlert(){return external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.addRoleAlert.grantAdditionalPrivilegesTitle",defaultMessage:"Grant additional privileges."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.addRoleAlert.grantAdditionalPrivilegesDescription",defaultMessage:"In Kibana Management, assign the {role} role to your Kibana user.",values:{role:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"monitoring_user")}}))}var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);const PIPELINE_LIST={INITIAL_PAGE_SIZE:20,PAGE_SIZE_OPTIONS:[5,8,20,50],PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelineNotCentrallyManagedTooltip",{defaultMessage:`This pipeline wasn't created using Centralized Configuration Management. It can't be managed or edited here.`}),INFO_ALERTS:{CALL_OUT_TITLE:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.kibanaManagementPipelinesTitle",{defaultMessage:"Only pipelines created in Kibana Management appear here"})}};function AlertCallOut(props){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:PIPELINE_LIST.INFO_ALERTS.CALL_OUT_TITLE,color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.alertCallOut.howToSeeAdditionalPipelinesDescription",defaultMessage:"How can I see additional pipelines?"})),props.children)}function EnableMonitoringAlert(){return external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.enableMonitoringAlert.enableMonitoringTitle",defaultMessage:"Enable monitoring."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.enableMonitoringAlert.enableMonitoringDescription",defaultMessage:"In the {configFileName} file, set {monitoringConfigParam} and {monitoringUiConfigParam} to {trueValue}.",values:{configFileName:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"kibana.yml"),monitoringConfigParam:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.monitoring.enabled"),monitoringUiConfigParam:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.monitoring.ui.enabled"),trueValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"true")}}))}function InfoAlerts({showAddRoleAlert:showAddRoleAlert,showEnableMonitoringAlert:showEnableMonitoringAlert}){return showAddRoleAlert||showEnableMonitoringAlert?external_kbnSharedDeps_React_default.a.createElement(AlertCallOut,null,showAddRoleAlert&&external_kbnSharedDeps_React_default.a.createElement(AddRoleAlert,null),showEnableMonitoringAlert&&external_kbnSharedDeps_React_default.a.createElement(EnableMonitoringAlert,null)):null}function getColumns(openPipeline,clonePipeline){return[{field:"id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelinesTable.idColumnLabel",{defaultMessage:"Id"}),sortable:true,render:(id,{isCentrallyManaged:isCentrallyManaged})=>{const openPipelineClicked=()=>openPipeline(id);return isCentrallyManaged?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:openPipelineClicked,"data-test-subj":"cellId"},id):external_kbnSharedDeps_React_default.a.createElement("span",null,id,"  ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:PIPELINE_LIST.PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT,type:"questionInCircle"}))}},{field:"description",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelinesTable.descriptionColumnLabel",{defaultMessage:"Description"}),render:description=>external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"cellDescription"},description),sortable:true,truncateText:true},{field:"lastModifiedHumanized",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelinesTable.lastModifiedColumnLabel",{defaultMessage:"Last modified"}),render:lastModified=>external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"cellLastModified"},lastModified),sortable:({lastModified:lastModified})=>lastModified.valueOf()},{field:"username",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelinesTable.modifiedByColumnLabel",{defaultMessage:"Modified by"}),render:username=>external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"cellUsername"},username),sortable:true},{field:"id",name:"",render:(id,{isCentrallyManaged:isCentrallyManaged})=>{const cloneClicked=()=>{clonePipeline(id)};return isCentrallyManaged?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":`lnkPipelineClone-${id}`,iconType:"copy",onClick:cloneClicked,size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelinesTable.cloneButtonLabel",defaultMessage:"Clone"})):null},sortable:false,width:"100px"}]}function PipelinesTableUi({clonePipeline:clonePipeline,createPipeline:createPipeline,isReadOnly:isReadOnly,isSelectable:isSelectable,message:message,onDeleteSelectedPipelines:onDeleteSelectedPipelines,onSelectionChange:onSelectionChange,openPipeline:openPipeline,pipelines:pipelines,selection:selection,pageIndex:pageIndex,intl:intl}){const pagination={pageIndex:pageIndex,initialPageSize:PIPELINE_LIST.INITIAL_PAGE_SIZE,totalItemCount:pipelines.length,pageSizeOptions:PIPELINE_LIST.PAGE_SIZE_OPTIONS};const selectableMessage=(selectable,{id:id})=>selectable?intl.formatMessage({id:"xpack.logstash.pipelinesTable.selectablePipelineMessage",defaultMessage:`Select pipeline "{id}"`},{id:id}):PIPELINE_LIST.PIPELINE_NOT_CENTRALLY_MANAGED_TOOLTIP_TEXT;const selectionOptions=isSelectable?{selectable:({isCentrallyManaged:isCentrallyManaged})=>isCentrallyManaged,selectableMessage:selectableMessage,onSelectionChange:onSelectionChange}:null;const deleteButton=selection.length&&!isReadOnly?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"btnDeletePipelines",color:"danger",onClick:onDeleteSelectedPipelines,"data-test-subj":"btnDeletePipeline"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelinesTable.deleteButtonLabel",defaultMessage:"Delete"})):null;const search={box:{incremental:true,"data-test-subj":"filter"},filters:[{type:"field_value_selection",field:"id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelinesTable.filterByIdLabel",{defaultMessage:"Filter by ID"}),multiSelect:false,options:pipelines.map(({id:id})=>({value:id,name:id,view:id}))}],toolsLeft:deleteButton,toolsRight:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{isDisabled:isReadOnly,key:"btnAdd",fill:true,onClick:createPipeline,"data-test-subj":"btnAdd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelinesTable.createPipelineButtonLabel",defaultMessage:"Create pipeline"}))};const columns=getColumns(openPipeline,clonePipeline);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{columns:columns,"data-test-subj":"pipelineTable",isSelectable:isSelectable,itemId:"id",items:pipelines,message:message,pagination:pagination,search:search,selection:selectionOptions,sorting:true,rowProps:{"data-test-subj":"row"}})}const PipelinesTable=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(PipelinesTableUi);function ConfirmDeleteModal({cancelDeletePipelines:cancelDeletePipelines,deleteSelectedPipelines:deleteSelectedPipelines,selection:selection,showConfirmDeleteModal:showConfirmDeleteModal}){if(!showConfirmDeleteModal){return null}const numPipelinesSelected=selection.length;const confirmText=numPipelinesSelected===1?{message:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.deletedPipelineWarningMessage",defaultMessage:"You cannot recover a deleted pipeline"}),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.deletedPipelineConfirmButtonLabel",defaultMessage:"Delete pipeline"}),title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.deletedPipelineTitle",defaultMessage:'Delete pipeline "{id}"',values:{id:selection[0].id}})}:{message:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.deletedPipelinesWarningMessage",defaultMessage:"You cannot recover deleted pipelines."}),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.deletedPipelinesConfirmButtonLabel",defaultMessage:"Delete {numPipelinesSelected} pipelines",values:{numPipelinesSelected:numPipelinesSelected}}),title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.deletedPipelinesTitle",defaultMessage:"Delete {numPipelinesSelected} pipelines",values:{numPipelinesSelected:numPipelinesSelected}})};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{buttonColor:"danger",cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeleteModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:confirmText.button,defaultFocusedButton:external_kbnSharedDeps_ElasticEui_["EUI_MODAL_CANCEL_BUTTON"],onCancel:cancelDeletePipelines,onConfirm:deleteSelectedPipelines,title:confirmText.title},external_kbnSharedDeps_React_default.a.createElement("p",null,confirmText.message))}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class pipeline_list_PipelineListUi extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);_defineProperty(this,"componentDidMount",()=>{const{isReadOnly:isReadOnly,licenseService:licenseService,toastNotifications:toastNotifications}=this.props;this.loadPipelines().then(()=>{if(isReadOnly){toastNotifications.addWarning(licenseService.message)}});this.checkMonitoringAccess()});_defineProperty(this,"getEmptyPrompt",()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.noPipelinesTitle",defaultMessage:"No pipelines"})),titleSize:"xs",body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.noPipelinesDescription",defaultMessage:"There are no pipelines defined."})}));_defineProperty(this,"getErrorPrompt",()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.pipelinesLoadingErrorTitle",defaultMessage:"Error"})),titleSize:"xs",body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.pipelinesLoadingErrorDescription",defaultMessage:"Error encountered while loading pipelines."})}));_defineProperty(this,"loadPipelines",()=>{const{isReadOnly:isReadOnly,licenseService:licenseService,pipelinesService:pipelinesService,toastNotifications:toastNotifications,intl:intl}=this.props;this.setState({message:external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"loadingPipelines"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"})," "," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.pipelinesLoadingMessage",defaultMessage:"Loading pipelines…"}))});return pipelinesService.getPipelineList().then(pipelines=>{this.setState({isLoading:false,isForbidden:false,isSelectable:true,pipelines:pipelines});if(!pipelines.length){this.setState({columns:[],message:this.getEmptyPrompt(),isSelectable:false})}}).catch(err=>{this.setState({isLoading:false,message:this.getErrorPrompt()});return licenseService.checkValidity().then(()=>{if(err.status===403){this.setState({isLoading:false});if(isReadOnly){this.setState({isForbidden:false})}else{this.setState({isForbidden:true})}}else{this.setState({isForbidden:false});toastNotifications.addDanger(intl.formatMessage({id:"xpack.logstash.pipelineList.pipelineLoadingErrorNotification",defaultMessage:`Couldn't load pipeline. Error: "{errStatusText}".`},{errStatusText:err.statusText}))}})})});_defineProperty(this,"checkMonitoringAccess",()=>{const{clusterService:clusterService,monitoringService:monitoringService}=this.props;clusterService.isClusterInfoAvailable().then(isAvailable=>{this.setState({showAddRoleAlert:!isAvailable,showEnableMonitoringAlert:!monitoringService.isMonitoringEnabled()})})});_defineProperty(this,"renderNoPermissionCallOut",()=>{const{isForbidden:isForbidden,isLoading:isLoading}=this.state;return isForbidden&&!isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",iconType:"cross",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.noPermissionToManageTitle",defaultMessage:"You do not have permission to manage Logstash pipelines."})},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.noPermissionToManageDescription",defaultMessage:"Please contact your administrator."}))):null});_defineProperty(this,"hideDeletePipelinesModal",()=>{this.setState({showConfirmDeleteModal:false})});_defineProperty(this,"showDeletePipelinesModal",()=>{this.setState({showConfirmDeleteModal:true})});_defineProperty(this,"cancelDeletePipelines",()=>{this.hideDeletePipelinesModal()});_defineProperty(this,"deleteSelectedPipelines",()=>{this.hideDeletePipelinesModal();const{licenseService:licenseService,pipelinesService:pipelinesService,toastNotifications:toastNotifications,intl:intl}=this.props;const{selection:selection}=this.state;const numPipelinesSelected=selection.length;const pipelineIds=selection.map(({id:id})=>id);return pipelinesService.deletePipelines(pipelineIds).then(results=>{const{numSuccesses:numSuccesses,numErrors:numErrors}=results;if(numSuccesses===1&&numErrors===0){toastNotifications.addSuccess(intl.formatMessage({id:"xpack.logstash.pipelineList.pipelinesSuccessfullyDeletedNotification",defaultMessage:'Deleted "{id}"'},{id:selection[0].id}))}else if(numSuccesses){let text;if(numErrors){text=intl.formatMessage({id:"xpack.logstash.pipelineList.pipelinesCouldNotBeDeletedDescription",defaultMessage:`But {numErrors, plural, one {# Pipeline} other {# Pipelines}} couldn't be deleted.`},{numErrors:numErrors})}toastNotifications.addSuccess({title:intl.formatMessage({id:"xpack.logstash.pipelineList.successfullyDeletedPipelinesNotification",defaultMessage:"Deleted {numSuccesses} out of {numPipelinesSelected, plural, one {# Pipeline} other {# Pipelines}}"},{numSuccesses:numSuccesses,numPipelinesSelected:numPipelinesSelected,numPipelinesSelected:numPipelinesSelected}),text:text})}else if(numErrors){toastNotifications.addError(intl.formatMessage({id:"xpack.logstash.pipelineList.couldNotDeletePipelinesNotification",defaultMessage:"Failed to delete {numErrors, plural, one {# Pipeline} other {# Pipelines}}"},{numErrors:numErrors}))}this.loadPipelines()}).catch(err=>licenseService.checkValidity().then(()=>toastNotifications.addDanger(err)))});_defineProperty(this,"onDeleteSelectedPipelines",()=>{this.showDeletePipelinesModal()});_defineProperty(this,"onSelectionChange",selection=>this.setState({selection:selection}));this.state={columns:[],isForbidden:false,isLoading:true,isSelectable:false,pipelines:[],showAddRoleAlert:false,showConfirmDeleteModal:false,showEnableMonitoringAlert:false,selection:[]}}render(){const{clonePipeline:clonePipeline,createPipeline:createPipeline,isReadOnly:isReadOnly,openPipeline:openPipeline}=this.props;const{isSelectable:isSelectable,message:message,pipelines:pipelines,selection:selection,showConfirmDeleteModal:showConfirmDeleteModal}=this.state;return external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"pipelineList"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{horizontalPosition:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.head",defaultMessage:"Pipelines"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineList.subhead",defaultMessage:"Manage logstash event processing and see the result visually"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),this.renderNoPermissionCallOut(),external_kbnSharedDeps_React_default.a.createElement(PipelinesTable,{clonePipeline:clonePipeline,createPipeline:createPipeline,isReadOnly:isReadOnly,isSelectable:isSelectable,message:message,pipelines:pipelines,selection:selection,onDeleteSelectedPipelines:this.onDeleteSelectedPipelines,onSelectionChange:this.onSelectionChange,openPipeline:openPipeline})),external_kbnSharedDeps_React_default.a.createElement(ConfirmDeleteModal,{cancelDeletePipelines:this.cancelDeletePipelines,deleteSelectedPipelines:this.deleteSelectedPipelines,selection:selection,showConfirmDeleteModal:showConfirmDeleteModal}),external_kbnSharedDeps_React_default.a.createElement(InfoAlerts,{showAddRoleAlert:this.state.showAddRoleAlert,showEnableMonitoringAlert:this.state.showEnableMonitoringAlert}))}}const PipelineList=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(pipeline_list_PipelineListUi);var usePromise=__webpack_require__(20);var usePromise_default=__webpack_require__.n(usePromise);var plain_text=__webpack_require__(18);var github=__webpack_require__(19);var external_kbnSharedDeps_Lodash_=__webpack_require__(0);var tooltips=__webpack_require__(4);const PIPELINE_EDITOR={DELETE_PIPELINE_MODAL_MESSAGE:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.deletePipelineModalMessage",{defaultMessage:"You cannot recover a deleted pipeline."}),ID_REQUIRED_ERR_MSG:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelineIdRequiredMessage",{defaultMessage:"Pipeline ID is required"}),ID_FORMAT_ERR_MSG:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.idFormatErrorMessage",{defaultMessage:"Pipeline ID must begin with a letter or underscore and contain only letters, underscores, dashes, and numbers"}),QUEUE_TYPES:[{"data-test-subj":"selectQueueType-memory",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.queueTypes.memoryLabel",{defaultMessage:"memory"}),value:"memory"},{"data-test-subj":"selectQueueType-persisted",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.queueTypes.persistedLabel",{defaultMessage:"persisted"}),value:"persisted"}],UNITS:[{"data-test-subj":"selectQueueMaxBytesUnits-b",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.units.bytesLabel",{defaultMessage:"bytes"}),value:"b"},{"data-test-subj":"selectQueueMaxBytesUnits-kb",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.units.kilobytesLabel",{defaultMessage:"kilobytes"}),value:"kb"},{"data-test-subj":"selectQueueMaxBytesUnits-mb",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.units.megabytesLabel",{defaultMessage:"megabytes"}),value:"mb"},{"data-test-subj":"selectQueueMaxBytesUnits-gb",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.units.gigabytesLabel",{defaultMessage:"gigabytes"}),value:"gb"},{"data-test-subj":"selectQueueMaxBytesUnits-tb",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.units.terabytesLabel",{defaultMessage:"terabytes"}),value:"tb"},{"data-test-subj":"selectQueueMaxBytesUnits-pb",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.units.petabytesLabel",{defaultMessage:"petabytes"}),value:"pb"}]};function ConfirmDeletePipelineModal({id:id,cancelDeleteModal:cancelDeleteModal,confirmDeletePipeline:confirmDeletePipeline}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{buttonColor:"danger",cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeletePipelineModal.cancelButtonText",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeletePipelineModal.confirmButtonText",defaultMessage:"Delete pipeline"}),defaultFocusedButton:external_kbnSharedDeps_ElasticEui_["EUI_MODAL_CANCEL_BUTTON"],onCancel:cancelDeleteModal,onConfirm:confirmDeletePipeline,title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.confirmDeletePipelineModal.deletePipelineTitle",defaultMessage:"Delete pipeline {id}",values:{id:id}})},external_kbnSharedDeps_React_default.a.createElement("p",null,PIPELINE_EDITOR.DELETE_PIPELINE_MODAL_MESSAGE))}function FormLabelWithIconTip({formRowLabelText:formRowLabelText,formRowTooltipText:formRowTooltipText}){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement("span",null,formRowLabelText)," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:formRowTooltipText,size:"s",type:"questionInCircle"}))}function FlexItemSetting(props){const{formRowLabelText:formRowLabelText,formRowTooltipText:formRowTooltipText}=props;const label=formRowLabelText&&formRowTooltipText?external_kbnSharedDeps_React_default.a.createElement(FormLabelWithIconTip,{formRowLabelText:formRowLabelText,formRowTooltipText:formRowTooltipText}):null;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:label,hasEmptyLabelSpace:!label},props.children))}function pipeline_editor_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class pipeline_editor_PipelineEditorUi extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);pipeline_editor_defineProperty(this,"componentDidMount",()=>{const{licenseService:{isReadOnly:isReadOnly,message:message},toastNotifications:toastNotifications}=this.props;if(isReadOnly){toastNotifications.addWarning(message)}});pipeline_editor_defineProperty(this,"hideConfirmDeleteModal",()=>{this.setState({showConfirmDeleteModal:false})});pipeline_editor_defineProperty(this,"showConfirmDeleteModal",()=>{this.setState({showConfirmDeleteModal:true})});pipeline_editor_defineProperty(this,"onPipelineIdChange",({target:{value:value}})=>{const pipelineIdErrors=[];if(!value){pipelineIdErrors.push(PIPELINE_EDITOR.ID_REQUIRED_ERR_MSG)}if(!this.state.pipelineIdPattern.test(value)){pipelineIdErrors.push(PIPELINE_EDITOR.ID_FORMAT_ERR_MSG)}this.setState({pipelineIdErrors:pipelineIdErrors,showPipelineIdError:!!pipelineIdErrors.length,pipeline:{...this.state.pipeline,id:value}})});pipeline_editor_defineProperty(this,"isSaveDisabled",()=>this.state.showPipelineIdError||Object(external_kbnSharedDeps_Lodash_["isEmpty"])(this.state.pipeline.id));pipeline_editor_defineProperty(this,"onClose",async()=>{await this.props.close()});pipeline_editor_defineProperty(this,"open",async()=>{const{id:id}=this.state.pipeline;if(id){await this.props.open(id)}});pipeline_editor_defineProperty(this,"onPipelineSave",()=>{const{pipelineService:pipelineService,toastNotifications:toastNotifications,intl:intl}=this.props;const{id:id,...pipelineToStore}=this.state.pipeline;return pipelineService.savePipeline({id:id,upstreamJSON:pipelineToStore}).then(()=>{toastNotifications.addSuccess(intl.formatMessage({id:"xpack.logstash.pipelineEditor.pipelineSuccessfullySavedMessage",defaultMessage:'Saved "{id}"'},{id:id}));this.onClose()}).catch(this.notifyOnError)});pipeline_editor_defineProperty(this,"onPipelineDescriptionChange",({target:{value:value}})=>{this.setState({pipeline:{...this.state.pipeline,description:value}})});pipeline_editor_defineProperty(this,"onPipelineChange",e=>{this.setState({pipeline:{...this.state.pipeline,pipeline:e}})});pipeline_editor_defineProperty(this,"handleNumberChange",(settingName,value)=>{const numberValue=parseInt(value,10);this.handleSettingChange(settingName,isNaN(numberValue)?value:numberValue)});pipeline_editor_defineProperty(this,"handleMaxByteNumberChange",value=>{this.setState({maxBytesNumber:parseInt(value,10)});this.handleSettingChange("queue.max_bytes",value+this.state.maxBytesUnit)});pipeline_editor_defineProperty(this,"handleMaxByteUnitChange",value=>{this.setState({maxBytesUnit:value});this.handleSettingChange("queue.max_bytes",this.state.maxBytesNumber+value)});pipeline_editor_defineProperty(this,"handleSettingChange",(settingName,value)=>{const settings={...this.state.pipeline.settings};settings[settingName]=value;this.setState({pipeline:{...this.state.pipeline,settings:settings}})});pipeline_editor_defineProperty(this,"notifyOnError",err=>{const{licenseService:licenseService,toastNotifications:toastNotifications}=this.props;return licenseService.checkValidity().then(()=>{toastNotifications.addError(err,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelineEditor.errorHandlerToastTitle",{defaultMessage:"Pipeline error"})})})});pipeline_editor_defineProperty(this,"deletePipeline",()=>{const{pipeline:{id:id},pipelineService:pipelineService,toastNotifications:toastNotifications,intl:intl}=this.props;this.hideConfirmDeleteModal();return pipelineService.deletePipeline(id).then(()=>{toastNotifications.addSuccess(intl.formatMessage({id:"xpack.logstash.pipelineEditor.pipelineSuccessfullyDeletedMessage",defaultMessage:'Deleted "{id}"'},{id:id}));this.onClose()}).catch(this.notifyOnError)});pipeline_editor_defineProperty(this,"getPipelineHeadingText",()=>{const{clone:clone,id:id,isNewPipeline:isNewPipeline,intl:intl}=this.props;if(!!clone&&id){return intl.formatMessage({id:"xpack.logstash.pipelineEditor.clonePipelineTitle",defaultMessage:'Clone Pipeline "{id}"'},{id:id})}if(!isNewPipeline){return intl.formatMessage({id:"xpack.logstash.pipelineEditor.editPipelineTitle",defaultMessage:'Edit Pipeline "{id}"'},{id:this.state.pipeline.id})}return intl.formatMessage({id:"xpack.logstash.pipelineEditor.createPipelineTitle",defaultMessage:"Create Pipeline"})});const{pipeline:{id:_id,description:description,pipeline:pipeline,settings:_settings}}=this.props;const pipelineWorkersSet=typeof _settings["pipeline.workers"]==="number";const pipelineWorkers=pipelineWorkersSet?_settings["pipeline.workers"]:1;this.state={maxBytesNumber:_settings["queue.max_bytes.number"],maxBytesUnit:_settings["queue.max_bytes.units"],pipeline:{id:_id,description:description,pipeline:pipeline,settings:{"pipeline.batch.delay":_settings["pipeline.batch.delay"],"pipeline.batch.size":_settings["pipeline.batch.size"],"pipeline.workers":pipelineWorkers,"queue.checkpoint.writes":_settings["queue.checkpoint.writes"],"queue.max_bytes":_settings["queue.max_bytes.number"]+_settings["queue.max_bytes.units"],"queue.type":_settings["queue.type"]}},pipelineIdErrors:[],pipelineIdPattern:/^[A-Za-z\_][A-Za-z0-9\-\_]*$/,showConfirmDeleteModal:false,showPipelineIdError:false}}render(){const{intl:intl}=this.props;return external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":`pipelineEdit pipelineEdit-${this.state.pipeline.id}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{style:{width:1100},verticalPosition:"center",horizontalPosition:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,this.getPipelineHeadingText())),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{isInvalid:this.state.showPipelineIdError,error:this.state.pipelineIdErrors},this.props.isNewPipeline&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineEditor.pipelineIdFormRowLabel",defaultMessage:"Pipeline ID"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,"data-test-subj":"inputId",isInvalid:this.state.showPipelineIdError,name:"pipelineId",onBlur:this.onPipelineIdChange,onChange:this.onPipelineIdChange,value:this.state.pipeline.id||""})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineEditor.descriptionFormRowLabel",defaultMessage:"Description"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{"data-test-subj":"inputDescription",fullWidth:true,name:"pipelineDescription",onChange:this.onPipelineDescriptionChange,value:this.state.pipeline.description||""})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineEditor.pipelineFormRowLabel",defaultMessage:"Pipeline"})},external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"acePipeline"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{mode:"plain_text",onChange:this.onPipelineChange,setOptions:{minLines:25,maxLines:Infinity,readOnly:this.props.licenseService.isReadOnly},theme:"github",value:this.state.pipeline.pipeline,width:"1017"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(FormLabelWithIconTip,{formRowLabelText:intl.formatMessage({id:"xpack.logstash.pipelineEditor.pipelineWorkersFormRowLabel",defaultMessage:"Pipeline workers"}),formRowTooltipText:tooltips["a"].settings["pipeline.workers"]})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"data-test-subj":"inputWorkers",onChange:e=>this.handleNumberChange("pipeline.workers",e.target.value),value:this.state.pipeline.settings["pipeline.workers"]})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(FlexItemSetting,{formRowLabelText:intl.formatMessage({id:"xpack.logstash.pipelineEditor.pipelineBatchSizeFormRowLabel",defaultMessage:"Pipeline batch size"}),formRowTooltipText:tooltips["a"].settings["pipeline.batch.size"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"data-test-subj":"inputBatchSize",onChange:e=>this.handleNumberChange("pipeline.batch.size",e.target.value),value:this.state.pipeline.settings["pipeline.batch.size"]})),external_kbnSharedDeps_React_default.a.createElement(FlexItemSetting,{formRowLabelText:intl.formatMessage({id:"xpack.logstash.pipelineEditor.pipelineBatchDelayFormRowLabel",defaultMessage:"Pipeline batch delay"}),formRowTooltipText:tooltips["a"].settings["pipeline.batch.delay"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"data-test-subj":"inputBatchDelay",onChange:e=>this.handleNumberChange("pipeline.batch.delay",e.target.value),value:this.state.pipeline.settings["pipeline.batch.delay"]}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(FlexItemSetting,{formRowLabelText:intl.formatMessage({id:"xpack.logstash.pipelineEditor.queueTypeFormRowLabel",defaultMessage:"Queue type"}),formRowTooltipText:tooltips["a"].settings["queue.type"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"selectQueueType",onChange:e=>this.handleSettingChange("queue.type",e.target.value),options:PIPELINE_EDITOR.QUEUE_TYPES,value:this.state.pipeline.settings["queue.type"]})),external_kbnSharedDeps_React_default.a.createElement(FlexItemSetting,{formRowLabelText:intl.formatMessage({id:"xpack.logstash.pipelineEditor.queueMaxBytesFormRowLabel",defaultMessage:"Queue max bytes"}),formRowTooltipText:tooltips["a"].settings["queue.max_bytes"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"data-test-subj":"inputQueueMaxBytesNumber",onChange:e=>this.handleMaxByteNumberChange(e.target.value),value:this.state.maxBytesNumber})),external_kbnSharedDeps_React_default.a.createElement(FlexItemSetting,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"selectQueueMaxBytesUnits",onChange:e=>this.handleMaxByteUnitChange(e.target.value),options:PIPELINE_EDITOR.UNITS,value:this.state.maxBytesUnit})),external_kbnSharedDeps_React_default.a.createElement(FlexItemSetting,{formRowLabelText:intl.formatMessage({id:"xpack.logstash.pipelineEditor.queueCheckpointWritesFormRowLabel",defaultMessage:"Queue checkpoint writes"}),formRowTooltipText:tooltips["a"].settings["queue.checkpoint.writes"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"data-test-subj":"inputQueueCheckpointWrites",onChange:e=>this.handleNumberChange("queue.checkpoint.writes",e.target.value),value:this.state.pipeline.settings["queue.checkpoint.writes"]})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"btnSavePipeline",fill:true,isDisabled:this.isSaveDisabled(),onClick:this.onPipelineSave},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineEditor.createAndDeployButtonLabel",defaultMessage:"Create and deploy"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"btnCancel",onClick:this.onClose},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineEditor.cancelButtonLabel",defaultMessage:"Cancel"}))),!this.props.isNewPipeline&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"danger","data-test-subj":"btnDeletePipeline",onClick:this.showConfirmDeleteModal},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.logstash.pipelineEditor.deletePipelineButtonLabel",defaultMessage:"Delete pipeline"}))))),this.state.showConfirmDeleteModal&&external_kbnSharedDeps_React_default.a.createElement(ConfirmDeletePipelineModal,{id:this.props.pipeline.id,cancelDeleteModal:this.hideConfirmDeleteModal,confirmDeletePipeline:this.deletePipeline}))}}const PipelineEditor=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(pipeline_editor_PipelineEditorUi);var models_pipeline=__webpack_require__(7);function getPipelineListBreadcrumbs(){return[{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelines.listBreadcrumb",{defaultMessage:"Pipelines"}),href:"#/management/ingest/pipelines"}]}function getPipelineEditBreadcrumbs(pipelineId){return[...getPipelineListBreadcrumbs(),{text:pipelineId}]}function getPipelineCreateBreadcrumbs(){return[...getPipelineListBreadcrumbs(),{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.pipelines.createBreadcrumb",{defaultMessage:"Create"})}]}const usePipeline=(pipelineService,logstashLicenseService,toasts,shouldClone,id)=>{const mounted=usePromise_default()();const[pipeline,setPipeline]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useLayoutEffect"])(()=>{(async()=>{if(!id){return setPipeline(new models_pipeline["a"])}try{const result=await mounted(pipelineService.loadPipeline(id));setPipeline(shouldClone?result.clone:result)}catch(e){await logstashLicenseService.checkValidity();if(e.status!==403){toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.logstash.couldNotLoadPipelineErrorNotification",{defaultMessage:`Couldn't load pipeline. Error: '{errStatusText}'.`,values:{errStatusText:e.statusText}}))}}})()},[pipelineService,id,mounted,shouldClone,logstashLicenseService,toasts]);return pipeline};const PipelineEditView=({pipelineService:pipelineService,logstashLicenseService:logstashLicenseService,toasts:toasts,history:history,setBreadcrumbs:setBreadcrumbs,id:id})=>{const params=new URLSearchParams(history.location.search);const shouldClone=params.get("clone")==="";const pipeline=usePipeline(pipelineService,logstashLicenseService,toasts,shouldClone,id);const close=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{history.push("/")},[history]);const open=Object(external_kbnSharedDeps_React_["useCallback"])(newId=>{history.push(`/pipeline/${newId}/edit`)},[history]);if(!pipeline){return null}const isNewPipeline=!pipeline.id;setBreadcrumbs(isNewPipeline?getPipelineCreateBreadcrumbs():getPipelineEditBreadcrumbs(pipeline.id));return external_kbnSharedDeps_React_default.a.createElement(PipelineEditor,{id:id,clone:shouldClone,close:close,open:open,isNewPipeline:isNewPipeline,pipeline:pipeline,pipelineService:pipelineService,toastNotifications:toasts,licenseService:logstashLicenseService})};const renderApp=async(core,{history:history,element:element,setBreadcrumbs:setBreadcrumbs},isMonitoringEnabled,licenseService$)=>{const logstashLicenseService=await licenseService$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["first"])()).toPromise();const clusterService=new services["a"](core.http);const monitoringService=new services["c"](core.http,isMonitoringEnabled,clusterService);const pipelinesService=new services["e"](core.http,monitoringService);const pipelineService=new services["d"](core.http,pipelinesService);external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(core.i18n.Context,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:history},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:["/",""],exact:true,render:()=>{setBreadcrumbs(getPipelineListBreadcrumbs());return external_kbnSharedDeps_React_default.a.createElement(PipelineList,{clusterService:clusterService,isReadOnly:logstashLicenseService.isReadOnly,isForbidden:true,isLoading:false,licenseService:logstashLicenseService,monitoringService:monitoringService,openPipeline:id=>history.push(`/pipeline/${id}/edit`),clonePipeline:id=>history.push(`/pipeline/${id}/edit?clone`),createPipeline:()=>history.push(`pipeline/new-pipeline`),pipelinesService:pipelinesService,toastNotifications:core.notifications.toasts})}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/pipeline/new-pipeline",exact:true,render:()=>external_kbnSharedDeps_React_default.a.createElement(PipelineEditView,{history:history,setBreadcrumbs:setBreadcrumbs,logstashLicenseService:logstashLicenseService,pipelineService:pipelineService,toasts:core.notifications.toasts})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/pipeline/:id",exact:true,render:({match:match})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:`/pipeline/${match.params.id}/edit`})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/pipeline/:id/edit",exact:true,render:({match:match})=>external_kbnSharedDeps_React_default.a.createElement(PipelineEditView,{history:history,setBreadcrumbs:setBreadcrumbs,logstashLicenseService:logstashLicenseService,pipelineService:pipelineService,toasts:core.notifications.toasts,id:match.params.id})})))),element);return()=>{external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(element)}}}}]);