/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId]){return installedModules[moduleId].exports}var module=installedModules[moduleId]={i:moduleId,l:false,exports:{}};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.l=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.d=function(exports,name,getter){if(!__webpack_require__.o(exports,name)){Object.defineProperty(exports,name,{enumerable:true,get:getter})}};__webpack_require__.r=function(exports){if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})};__webpack_require__.t=function(value,mode){if(mode&1)value=__webpack_require__(value);if(mode&8)return value;if(mode&4&&typeof value==="object"&&value&&value.__esModule)return value;var ns=Object.create(null);__webpack_require__.r(ns);Object.defineProperty(ns,"default",{enumerable:true,value:value});if(mode&2&&typeof value!="string")for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns};__webpack_require__.n=function(module){var getter=module&&module.__esModule?function getDefault(){return module["default"]}:function getModuleExports(){return module};__webpack_require__.d(getter,"a",getter);return getter};__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)};__webpack_require__.p="";return __webpack_require__(__webpack_require__.s=9)})([function(module,exports){module.exports=__kbnSharedDeps__.Rxjs},function(module,exports){module.exports=__kbnSharedDeps__.RxjsOperators},function(module,exports){module.exports=__kbnSharedDeps__.React},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18n},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18nReact},function(module,exports){},function(module,exports){module.exports=__kbnSharedDeps__.ElasticEui},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/kibanaReact/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,exports){module.exports=__kbnSharedDeps__.Lodash},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_val_loader_dist_cjs_js_key_licensing_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(10);var _node_modules_val_loader_dist_cjs_js_key_licensing_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_val_loader_dist_cjs_js_key_licensing_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__);__kbnBundles__.define("plugin/licensing/public",__webpack_require__,11)},function(module,exports,__webpack_require__){__webpack_require__.p=window.__kbnPublicPath__["licensing"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"LICENSE_TYPE",(function(){return LICENSE_TYPE}));__webpack_require__.d(__webpack_exports__,"LicensingPluginSetup",(function(){return types["LicensingPluginSetup"]}));__webpack_require__.d(__webpack_exports__,"LicensingPluginStart",(function(){return types["LicensingPluginStart"]}));__webpack_require__.d(__webpack_exports__,"plugin",(function(){return public_plugin}));var external_kbnSharedDeps_Rxjs_=__webpack_require__(0);var external_kbnSharedDeps_RxjsOperators_=__webpack_require__(1);function hasLicenseInfoChanged(currentLicense,newLicense){if(currentLicense===newLicense)return false;if(!currentLicense)return true;return newLicense.error!==currentLicense.error||newLicense.type!==currentLicense.type||newLicense.status!==currentLicense.status||newLicense.expiryDateInMillis!==currentLicense.expiryDateInMillis||newLicense.isAvailable!==currentLicense.isAvailable}function createLicenseUpdate(triggerRefresh$,stop$,fetcher,initialValues){const manuallyRefresh$=new external_kbnSharedDeps_Rxjs_["Subject"];const fetched$=Object(external_kbnSharedDeps_Rxjs_["merge"])(triggerRefresh$,manuallyRefresh$).pipe(Object(external_kbnSharedDeps_RxjsOperators_["exhaustMap"])(fetcher),Object(external_kbnSharedDeps_RxjsOperators_["share"])());const cached$=fetched$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["takeUntil"])(stop$),Object(external_kbnSharedDeps_RxjsOperators_["publishReplay"])(1));const cachedSubscription=cached$.connect();stop$.subscribe({complete:()=>cachedSubscription.unsubscribe()});const initialValues$=initialValues?Object(external_kbnSharedDeps_Rxjs_["from"])([undefined,initialValues]):Object(external_kbnSharedDeps_Rxjs_["from"])([undefined]);const license$=Object(external_kbnSharedDeps_Rxjs_["merge"])(initialValues$,cached$).pipe(Object(external_kbnSharedDeps_RxjsOperators_["pairwise"])(),Object(external_kbnSharedDeps_RxjsOperators_["filter"])(([previous,next])=>hasLicenseInfoChanged(previous,next)),Object(external_kbnSharedDeps_RxjsOperators_["map"])(([,next])=>next));return{license$:license$,refreshManually(){const licensePromise=fetched$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["take"])(1)).toPromise();manuallyRefresh$.next();return licensePromise}}}var external_kbnSharedDeps_KbnI18n_=__webpack_require__(3);let LICENSE_TYPE;(function(LICENSE_TYPE){LICENSE_TYPE[LICENSE_TYPE["basic"]=10]="basic";LICENSE_TYPE[LICENSE_TYPE["standard"]=20]="standard";LICENSE_TYPE[LICENSE_TYPE["gold"]=30]="gold";LICENSE_TYPE[LICENSE_TYPE["platinum"]=40]="platinum";LICENSE_TYPE[LICENSE_TYPE["enterprise"]=50]="enterprise";LICENSE_TYPE[LICENSE_TYPE["trial"]=60]="trial"})(LICENSE_TYPE||(LICENSE_TYPE={}));function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class license_License{static fromJSON(json){return new license_License(json)}constructor({license:license,features:features,error:error,signature:signature}){_defineProperty(this,"license",void 0);_defineProperty(this,"features",void 0);_defineProperty(this,"error",void 0);_defineProperty(this,"isActive",void 0);_defineProperty(this,"isAvailable",void 0);_defineProperty(this,"uid",void 0);_defineProperty(this,"status",void 0);_defineProperty(this,"expiryDateInMillis",void 0);_defineProperty(this,"type",void 0);_defineProperty(this,"mode",void 0);_defineProperty(this,"signature",void 0);this.isAvailable=Boolean(license);this.license=license;this.features=features;this.error=error;this.signature=signature;if(license){this.uid=license.uid;this.status=license.status;this.expiryDateInMillis=license.expiryDateInMillis;this.type=license.type;this.mode=license.mode}this.isActive=this.status==="active"}toJSON(){return{license:this.license,features:this.features,signature:this.signature}}getUnavailableReason(){if(this.error)return this.error;if(!this.isAvailable){return"X-Pack plugin is not installed on the Elasticsearch cluster."}}hasAtLeast(minimumLicenseRequired){const type=this.type;if(!type){return false}if(!(minimumLicenseRequired in LICENSE_TYPE)){throw new Error(`"${minimumLicenseRequired}" is not a valid license type`)}return LICENSE_TYPE[minimumLicenseRequired]<=LICENSE_TYPE[type]}check(pluginName,minimumLicenseRequired){if(!this.isAvailable){return{state:"unavailable",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.licensing.check.errorUnavailableMessage",{defaultMessage:"You cannot use {pluginName} because license information is not available at this time.",values:{pluginName:pluginName}})}}if(!this.isActive){return{state:"expired",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.licensing.check.errorExpiredMessage",{defaultMessage:"You cannot use {pluginName} because your {licenseType} license has expired.",values:{licenseType:this.type,pluginName:pluginName}})}}if(!this.hasAtLeast(minimumLicenseRequired)){return{state:"invalid",message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.licensing.check.errorUnsupportedMessage",{defaultMessage:"Your {licenseType} license does not support {pluginName}. Please upgrade your license.",values:{licenseType:this.type,pluginName:pluginName}})}}return{state:"valid"}}getFeature(name){if(this.isAvailable&&this.features&&this.features.hasOwnProperty(name)){return{...this.features[name]}}return{isAvailable:false,isEnabled:false}}}var external_kbnSharedDeps_React_=__webpack_require__(2);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(6);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(4);var public_=__webpack_require__(7);const ExpiredBanner=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{iconType:"help",color:"warning","data-test-subj":"licenseExpiredBanner",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.licensing.welcomeBanner.licenseIsExpiredTitle",defaultMessage:"Your {licenseType} license is expired",values:{licenseType:props.type}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.licensing.welcomeBanner.licenseIsExpiredDescription",defaultMessage:"Contact your administrator or {updateYourLicenseLinkText} directly.",values:{updateYourLicenseLinkText:external_kbnSharedDeps_React_default.a.createElement("a",{href:props.uploadUrl},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.licensing.welcomeBanner.licenseIsExpiredDescription.updateYourLicenseLinkText",defaultMessage:"update your license"}))}}));const mountExpiredBanner=props=>Object(public_["toMountPoint"])(external_kbnSharedDeps_React_default.a.createElement(ExpiredBanner,{type:props.type,uploadUrl:props.uploadUrl}));var external_kbnSharedDeps_Lodash_=__webpack_require__(8);function feature_usage_service_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class feature_usage_service_FeatureUsageService{constructor(){feature_usage_service_defineProperty(this,"registrations",[])}setup(){return{register:async(featureName,licenseType)=>{this.registrations.push({featureName:featureName,licenseType:licenseType})}}}start({http:http}){const registrationPromise=http.anonymousPaths.isAnonymous(window.location.pathname)||this.registrations.length===0?Promise.resolve():http.post("/internal/licensing/feature_usage/register",{body:JSON.stringify(this.registrations)});return{notifyUsage:async(featureName,usedAt=Date.now())=>{if(http.anonymousPaths.isAnonymous(window.location.pathname))return;await registrationPromise;const lastUsed=Object(external_kbnSharedDeps_Lodash_["isDate"])(usedAt)?usedAt.getTime():usedAt;await http.post("/internal/licensing/feature_usage/notify",{body:JSON.stringify({featureName:featureName,lastUsed:lastUsed})})}}}}function plugin_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const licensingSessionStorageKey="xpack.licensing";class plugin_LicensingPlugin{constructor(context,storage=sessionStorage){this.storage=storage;plugin_defineProperty(this,"stop$",new external_kbnSharedDeps_Rxjs_["Subject"]);plugin_defineProperty(this,"removeInterceptor",void 0);plugin_defineProperty(this,"internalSubscription",void 0);plugin_defineProperty(this,"isLicenseExpirationBannerShown",false);plugin_defineProperty(this,"infoEndpoint","/api/licensing/info");plugin_defineProperty(this,"coreStart",void 0);plugin_defineProperty(this,"prevSignature",void 0);plugin_defineProperty(this,"refresh",void 0);plugin_defineProperty(this,"license$",void 0);plugin_defineProperty(this,"featureUsage",new feature_usage_service_FeatureUsageService);plugin_defineProperty(this,"fetchLicense",async core=>{try{const response=await core.http.get({path:this.infoEndpoint,asSystemRequest:true});return new license_License({license:response.license,features:response.features,signature:response.signature})}catch(error){return new license_License({error:error.message,signature:""})}})}getSaved(){const raw=this.storage.getItem(licensingSessionStorageKey);if(!raw)return;return license_License.fromJSON(JSON.parse(raw))}save(license){this.storage.setItem(licensingSessionStorageKey,JSON.stringify(license))}removeSaved(){this.storage.removeItem(licensingSessionStorageKey)}setup(core){const signatureUpdated$=new external_kbnSharedDeps_Rxjs_["Subject"];const{license$:license$,refreshManually:refreshManually}=createLicenseUpdate(signatureUpdated$,this.stop$,()=>this.fetchLicense(core),this.getSaved());this.internalSubscription=license$.subscribe(license=>{if(license.isAvailable){this.prevSignature=license.signature;this.save(license)}else{this.prevSignature=undefined;this.removeSaved()}if(license.status==="expired"&&!this.isLicenseExpirationBannerShown&&this.coreStart){this.isLicenseExpirationBannerShown=true;this.showExpiredBanner(license)}});this.removeInterceptor=core.http.intercept({response:async httpResponse=>{if(core.http.anonymousPaths.isAnonymous(window.location.pathname))return httpResponse;if(httpResponse.response){const signatureHeader=httpResponse.response.headers.get("kbn-license-sig");if(typeof signatureHeader==="string"&&this.prevSignature!==signatureHeader){if(!httpResponse.request.url.includes(this.infoEndpoint)){signatureUpdated$.next()}}}return httpResponse}});this.refresh=refreshManually;this.license$=license$;return{refresh:refreshManually,license$:license$,featureUsage:this.featureUsage.setup()}}start(core){this.coreStart=core;if(!this.refresh||!this.license$){throw new Error("Setup has not been completed")}return{refresh:this.refresh,license$:this.license$,featureUsage:this.featureUsage.start({http:core.http})}}stop(){this.stop$.next();this.stop$.complete();if(this.removeInterceptor!==undefined){this.removeInterceptor()}if(this.internalSubscription!==undefined){this.internalSubscription.unsubscribe();this.internalSubscription=undefined}}showExpiredBanner(license){const uploadUrl=this.coreStart.http.basePath.prepend("/app/management/stack/license_management/upload_license");this.coreStart.overlays.banners.add(mountExpiredBanner({type:license.type,uploadUrl:uploadUrl}))}}var types=__webpack_require__(5);const public_plugin=context=>new plugin_LicensingPlugin(context)}]);