/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["lens_bundle_jsonpfunction"]=window["lens_bundle_jsonpfunction"]||[]).push([[0],Array(33).concat([function(module,exports,__webpack_require__){"use strict";var isOldIE=function isOldIE(){var memo;return function memorize(){if(typeof memo==="undefined"){memo=Boolean(window&&document&&document.all&&!window.atob)}return memo}}();var getTarget=function getTarget(){var memo={};return function memorize(target){if(typeof memo[target]==="undefined"){var styleTarget=document.querySelector(target);if(window.HTMLIFrameElement&&styleTarget instanceof window.HTMLIFrameElement){try{styleTarget=styleTarget.contentDocument.head}catch(e){styleTarget=null}}memo[target]=styleTarget}return memo[target]}}();var stylesInDom=[];function getIndexByIdentifier(identifier){var result=-1;for(var i=0;i<stylesInDom.length;i++){if(stylesInDom[i].identifier===identifier){result=i;break}}return result}function modulesToDom(list,options){var idCountMap={};var identifiers=[];for(var i=0;i<list.length;i++){var item=list[i];var id=options.base?item[0]+options.base:item[0];var count=idCountMap[id]||0;var identifier="".concat(id," ").concat(count);idCountMap[id]=count+1;var index=getIndexByIdentifier(identifier);var obj={css:item[1],media:item[2],sourceMap:item[3]};if(index!==-1){stylesInDom[index].references++;stylesInDom[index].updater(obj)}else{stylesInDom.push({identifier:identifier,updater:addStyle(obj,options),references:1})}identifiers.push(identifier)}return identifiers}function insertStyleElement(options){var style=document.createElement("style");var attributes=options.attributes||{};if(typeof attributes.nonce==="undefined"){var nonce=true?__webpack_require__.nc:undefined;if(nonce){attributes.nonce=nonce}}Object.keys(attributes).forEach((function(key){style.setAttribute(key,attributes[key])}));if(typeof options.insert==="function"){options.insert(style)}else{var target=getTarget(options.insert||"head");if(!target){throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.")}target.appendChild(style)}return style}function removeStyleElement(style){if(style.parentNode===null){return false}style.parentNode.removeChild(style)}var replaceText=function replaceText(){var textStore=[];return function replace(index,replacement){textStore[index]=replacement;return textStore.filter(Boolean).join("\n")}}();function applyToSingletonTag(style,index,remove,obj){var css=remove?"":obj.media?"@media ".concat(obj.media," {").concat(obj.css,"}"):obj.css;if(style.styleSheet){style.styleSheet.cssText=replaceText(index,css)}else{var cssNode=document.createTextNode(css);var childNodes=style.childNodes;if(childNodes[index]){style.removeChild(childNodes[index])}if(childNodes.length){style.insertBefore(cssNode,childNodes[index])}else{style.appendChild(cssNode)}}}function applyToTag(style,options,obj){var css=obj.css;var media=obj.media;var sourceMap=obj.sourceMap;if(media){style.setAttribute("media",media)}else{style.removeAttribute("media")}if(sourceMap&&btoa){css+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))))," */")}if(style.styleSheet){style.styleSheet.cssText=css}else{while(style.firstChild){style.removeChild(style.firstChild)}style.appendChild(document.createTextNode(css))}}var singleton=null;var singletonCounter=0;function addStyle(obj,options){var style;var update;var remove;if(options.singleton){var styleIndex=singletonCounter++;style=singleton||(singleton=insertStyleElement(options));update=applyToSingletonTag.bind(null,style,styleIndex,false);remove=applyToSingletonTag.bind(null,style,styleIndex,true)}else{style=insertStyleElement(options);update=applyToTag.bind(null,style,options);remove=function remove(){removeStyleElement(style)}}update(obj);return function updateStyle(newObj){if(newObj){if(newObj.css===obj.css&&newObj.media===obj.media&&newObj.sourceMap===obj.sourceMap){return}update(obj=newObj)}else{remove()}}}module.exports=function(list,options){options=options||{};if(!options.singleton&&typeof options.singleton!=="boolean"){options.singleton=isOldIE()}list=list||[];var lastIdentifiers=modulesToDom(list,options);return function update(newList){newList=newList||[];if(Object.prototype.toString.call(newList)!=="[object Array]"){return}for(var i=0;i<lastIdentifiers.length;i++){var identifier=lastIdentifiers[i];var index=getIndexByIdentifier(identifier);stylesInDom[index].references--}var newLastIdentifiers=modulesToDom(newList,options);for(var _i=0;_i<lastIdentifiers.length;_i++){var _identifier=lastIdentifiers[_i];var _index=getIndexByIdentifier(_identifier);if(stylesInDom[_index].references===0){stylesInDom[_index].updater();stylesInDom.splice(_index,1)}}lastIdentifiers=newLastIdentifiers}}},function(module,exports,__webpack_require__){"use strict";module.exports=function(useSourceMap){var list=[];list.toString=function toString(){return this.map((function(item){var content=cssWithMappingToString(item,useSourceMap);if(item[2]){return"@media ".concat(item[2]," {").concat(content,"}")}return content})).join("")};list.i=function(modules,mediaQuery,dedupe){if(typeof modules==="string"){modules=[[null,modules,""]]}var alreadyImportedModules={};if(dedupe){for(var i=0;i<this.length;i++){var id=this[i][0];if(id!=null){alreadyImportedModules[id]=true}}}for(var _i=0;_i<modules.length;_i++){var item=[].concat(modules[_i]);if(dedupe&&alreadyImportedModules[item[0]]){continue}if(mediaQuery){if(!item[2]){item[2]=mediaQuery}else{item[2]="".concat(mediaQuery," and ").concat(item[2])}}list.push(item)}};return list};function cssWithMappingToString(item,useSourceMap){var content=item[1]||"";var cssMapping=item[3];if(!cssMapping){return content}if(useSourceMap&&typeof btoa==="function"){var sourceMapping=toComment(cssMapping);var sourceURLs=cssMapping.sources.map((function(source){return"/*# sourceURL=".concat(cssMapping.sourceRoot||"").concat(source," */")}));return[content].concat(sourceURLs).concat([sourceMapping]).join("\n")}return[content].join("\n")}function toComment(sourceMap){var base64=btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));var data="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);return"/*# ".concat(data," */")}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return setReportManager}));__webpack_require__.d(__webpack_exports__,"c",(function(){return stopReportManager}));__webpack_require__.d(__webpack_exports__,"e",(function(){return trackUiEvent}));__webpack_require__.d(__webpack_exports__,"d",(function(){return trackSuggestionEvent}));__webpack_require__.d(__webpack_exports__,"a",(function(){return factory_LensReportManager}));var external_kbnSharedDeps_Moment_=__webpack_require__(25);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var common=__webpack_require__(1);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const STORAGE_KEY="lens-ui-telemetry";let reportManager;function setReportManager(newManager){if(reportManager){reportManager.stop()}reportManager=newManager}function stopReportManager(){if(reportManager){reportManager.stop()}}function trackUiEvent(name){if(reportManager){reportManager.trackEvent(name)}}function trackSuggestionEvent(name){if(reportManager){reportManager.trackSuggestionEvent(name)}}class factory_LensReportManager{constructor({storage:storage,http:http}){_defineProperty(this,"events",{});_defineProperty(this,"suggestionEvents",{});_defineProperty(this,"storage",void 0);_defineProperty(this,"http",void 0);_defineProperty(this,"timer",void 0);this.storage=storage;this.http=http;this.readFromStorage();this.timer=setInterval(()=>{this.postToServer()},1e4)}trackEvent(name){this.readFromStorage();this.trackTo(this.events,name)}trackSuggestionEvent(name){this.readFromStorage();this.trackTo(this.suggestionEvents,name)}stop(){if(this.timer){clearInterval(this.timer)}}readFromStorage(){const data=this.storage.get(STORAGE_KEY);if(data&&typeof data.events==="object"&&typeof data.suggestionEvents==="object"){this.events=data.events;this.suggestionEvents=data.suggestionEvents}}async postToServer(){this.readFromStorage();if(Object.keys(this.events).length||Object.keys(this.suggestionEvents).length){try{await this.http.post(`${common["BASE_API_URL"]}/stats`,{body:JSON.stringify({events:this.events,suggestionEvents:this.suggestionEvents})});this.events={};this.suggestionEvents={};this.write()}catch(e){if(e.response&&e.response.status===403){this.stop()}}}}trackTo(target,name){const date=external_kbnSharedDeps_Moment_default()().utc().format("YYYY-MM-DD");if(!target[date]){target[date]={[name]:1}}else if(!target[date][name]){target[date][name]=1}else{target[date][name]+=1}this.write()}write(){this.storage.set(STORAGE_KEY,{events:this.events,suggestionEvents:this.suggestionEvents})}}},function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;
/*!
  Copyright (c) 2017 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/(function(){"use strict";var hasOwn={}.hasOwnProperty;function classNames(){var classes=[];for(var i=0;i<arguments.length;i++){var arg=arguments[i];if(!arg)continue;var argType=typeof arg;if(argType==="string"||argType==="number"){classes.push(arg)}else if(Array.isArray(arg)&&arg.length){var inner=classNames.apply(null,arg);if(inner){classes.push(inner)}}else if(argType==="object"){for(var key in arg){if(hasOwn.call(arg,key)&&arg[key]){classes.push(key)}}}}return classes.join(" ")}if(true&&module.exports){classNames.default=classNames;module.exports=classNames}else if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return classNames}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})()},function(module,__webpack_exports__,__webpack_require__){"use strict";var _providers__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(40);if(__webpack_require__.o(_providers__WEBPACK_IMPORTED_MODULE_0__,"ChildDragDropProvider"))__webpack_require__.d(__webpack_exports__,"ChildDragDropProvider",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["ChildDragDropProvider"]}));if(__webpack_require__.o(_providers__WEBPACK_IMPORTED_MODULE_0__,"DragContext"))__webpack_require__.d(__webpack_exports__,"DragContext",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["DragContext"]}));if(__webpack_require__.o(_providers__WEBPACK_IMPORTED_MODULE_0__,"DragDrop"))__webpack_require__.d(__webpack_exports__,"DragDrop",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["DragDrop"]}));if(__webpack_require__.o(_providers__WEBPACK_IMPORTED_MODULE_0__,"ReorderProvider"))__webpack_require__.d(__webpack_exports__,"ReorderProvider",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["ReorderProvider"]}));if(__webpack_require__.o(_providers__WEBPACK_IMPORTED_MODULE_0__,"RootDragDropProvider"))__webpack_require__.d(__webpack_exports__,"RootDragDropProvider",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["RootDragDropProvider"]}));var _drag_drop__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(50);__webpack_require__.d(__webpack_exports__,"DragDrop",(function(){return _drag_drop__WEBPACK_IMPORTED_MODULE_1__["a"]}))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(24);var react_1=__webpack_require__(3);var useTimeoutFn_1=tslib_1.__importDefault(__webpack_require__(103));function useDebounce(fn,ms,deps){if(ms===void 0){ms=0}if(deps===void 0){deps=[]}var _a=useTimeoutFn_1.default(fn,ms),isReady=_a[0],cancel=_a[1],reset=_a[2];react_1.useEffect(reset,deps);return[isReady,cancel]}exports.default=useDebounce},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});Object.defineProperty(exports,"fromExpression",{enumerable:true,get:function(){return _ast.fromExpression}});Object.defineProperty(exports,"toExpression",{enumerable:true,get:function(){return _ast.toExpression}});Object.defineProperty(exports,"safeElementFromExpression",{enumerable:true,get:function(){return _ast.safeElementFromExpression}});Object.defineProperty(exports,"Fn",{enumerable:true,get:function(){return _fn.Fn}});Object.defineProperty(exports,"getType",{enumerable:true,get:function(){return _get_type.getType}});Object.defineProperty(exports,"castProvider",{enumerable:true,get:function(){return _cast.castProvider}});Object.defineProperty(exports,"parse",{enumerable:true,get:function(){return _grammar.parse}});Object.defineProperty(exports,"getByAlias",{enumerable:true,get:function(){return _get_by_alias.getByAlias}});Object.defineProperty(exports,"Registry",{enumerable:true,get:function(){return _registry.Registry}});Object.defineProperty(exports,"addRegistries",{enumerable:true,get:function(){return _registries.addRegistries}});Object.defineProperty(exports,"register",{enumerable:true,get:function(){return _registries.register}});Object.defineProperty(exports,"registryFactory",{enumerable:true,get:function(){return _registries.registryFactory}});var _ast=__webpack_require__(270);var _fn=__webpack_require__(271);var _get_type=__webpack_require__(41);var _cast=__webpack_require__(273);var _grammar=__webpack_require__(51);var _get_by_alias=__webpack_require__(274);var _registry=__webpack_require__(275);var _registries=__webpack_require__(276)},function(module,__webpack_exports__,__webpack_require__){"use strict";var _providers__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(46);__webpack_require__.d(__webpack_exports__,"ChildDragDropProvider",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["a"]}));__webpack_require__.d(__webpack_exports__,"DragContext",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["b"]}));__webpack_require__.d(__webpack_exports__,"RootDragDropProvider",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["c"]}));__webpack_require__.d(__webpack_exports__,"nextValidDropTarget",(function(){return _providers__WEBPACK_IMPORTED_MODULE_0__["d"]}));var _reorder_provider__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(47);__webpack_require__.d(__webpack_exports__,"ReorderContext",(function(){return _reorder_provider__WEBPACK_IMPORTED_MODULE_1__["a"]}));__webpack_require__.d(__webpack_exports__,"ReorderProvider",(function(){return _reorder_provider__WEBPACK_IMPORTED_MODULE_1__["b"]}));var _types__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(48);var _types__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_types__WEBPACK_IMPORTED_MODULE_2__);if(__webpack_require__.o(_types__WEBPACK_IMPORTED_MODULE_2__,"DragDrop"))__webpack_require__.d(__webpack_exports__,"DragDrop",(function(){return _types__WEBPACK_IMPORTED_MODULE_2__["DragDrop"]}));if(__webpack_require__.o(_types__WEBPACK_IMPORTED_MODULE_2__,"announce"))__webpack_require__.d(__webpack_exports__,"announce",(function(){return _types__WEBPACK_IMPORTED_MODULE_2__["announce"]}));var _announcements__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(49);__webpack_require__.d(__webpack_exports__,"announce",(function(){return _announcements__WEBPACK_IMPORTED_MODULE_3__["a"]}))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getType=getType;function getType(node){if(node==null)return"null";if(typeof node==="object"){if(!node.type)throw new Error("Objects must have a type property");return node.type}return typeof node}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(3);var isPrimitive=function(val){return val!==Object(val)};var useCustomCompareEffect=function(effect,deps,depsEqual){if(false){}var ref=react_1.useRef(undefined);if(!ref.current||!depsEqual(deps,ref.current)){ref.current=deps}react_1.useEffect(effect,ref.current)};exports.default=useCustomCompareEffect},function(module,exports){},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(161);case"v7light":return __webpack_require__(163);case"v8dark":return __webpack_require__(165);case"v8light":return __webpack_require__(167)}},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(178);case"v7light":return __webpack_require__(180);case"v8dark":return __webpack_require__(182);case"v8light":return __webpack_require__(184)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return DragContext}));__webpack_require__.d(__webpack_exports__,"c",(function(){return RootDragDropProvider}));__webpack_require__.d(__webpack_exports__,"d",(function(){return nextValidDropTarget}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ChildDragDropProvider}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(19);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_2__);const DragContext=react__WEBPACK_IMPORTED_MODULE_0___default.a.createContext({dragging:undefined,setDragging:()=>{},keyboardMode:false,setKeyboardMode:()=>{},activeDropTarget:undefined,setActiveDropTarget:()=>{},setA11yMessage:()=>{},dropTargetsByOrder:undefined,registerDropTarget:()=>{}});function RootDragDropProvider({children:children}){const[draggingState,setDraggingState]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])({dragging:undefined});const[keyboardModeState,setKeyboardModeState]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(false);const[a11yMessageState,setA11yMessageState]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])("");const[activeDropTargetState,setActiveDropTargetState]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(undefined);const[dropTargetsByOrderState,setDropTargetsByOrderState]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])({});const setDragging=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>dragging=>setDraggingState({dragging:dragging}),[setDraggingState]);const setA11yMessage=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>message=>setA11yMessageState(message),[setA11yMessageState]);const setActiveDropTarget=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>activeDropTarget=>setActiveDropTargetState(activeDropTarget),[setActiveDropTargetState]);const registerDropTarget=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>(order,dropTarget)=>setDropTargetsByOrderState(s=>({...s,[order.join(",")]:dropTarget})),[setDropTargetsByOrderState]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(ChildDragDropProvider,{keyboardMode:keyboardModeState,setKeyboardMode:setKeyboardModeState,dragging:draggingState.dragging,setA11yMessage:setA11yMessage,setDragging:setDragging,activeDropTarget:activeDropTargetState,setActiveDropTarget:setActiveDropTarget,registerDropTarget:registerDropTarget,dropTargetsByOrder:dropTargetsByOrderState},children),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiScreenReaderOnly"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p",{"aria-live":"assertive","aria-atomic":true},a11yMessageState),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p",{id:`lnsDragDrop-keyboardInstructionsWithReorder`},_kbn_i18n__WEBPACK_IMPORTED_MODULE_2__["i18n"].translate("xpack.lens.dragDrop.keyboardInstructionsReorder",{defaultMessage:`Press space or enter to start dragging. When dragging, use the up/down arrow keys to reorder items in the group and left/right arrow keys to choose drop targets outside of the group. Press space or enter again to finish.`})),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("p",{id:`lnsDragDrop-keyboardInstructions`},_kbn_i18n__WEBPACK_IMPORTED_MODULE_2__["i18n"].translate("xpack.lens.dragDrop.keyboardInstructions",{defaultMessage:`Press space or enter to start dragging. When dragging, use the left/right arrow keys to move between drop targets. Press space or enter again to finish.`})))))}function nextValidDropTarget(dropTargetsByOrder,activeDropTarget,draggingOrder,filterElements=(()=>true),reverse=false){if(!dropTargetsByOrder){return}const filteredTargets=Object.entries(dropTargetsByOrder).filter(([,dropTarget])=>dropTarget&&filterElements(dropTarget));const nextDropTargets=[...filteredTargets,draggingOrder].sort(([orderA],[orderB])=>{const parsedOrderA=orderA.split(",").map(v=>Number(v));const parsedOrderB=orderB.split(",").map(v=>Number(v));const relevantLevel=parsedOrderA.findIndex((v,i)=>parsedOrderA[i]!==parsedOrderB[i]);return parsedOrderA[relevantLevel]-parsedOrderB[relevantLevel]});let currentActiveDropIndex=nextDropTargets.findIndex(([_,dropTarget])=>(dropTarget===null||dropTarget===void 0?void 0:dropTarget.id)===(activeDropTarget===null||activeDropTarget===void 0?void 0:activeDropTarget.id));if(currentActiveDropIndex===-1){currentActiveDropIndex=nextDropTargets.findIndex(([targetOrder])=>targetOrder===draggingOrder[0])}const previousElement=(nextDropTargets.length+currentActiveDropIndex-1)%nextDropTargets.length;const nextElement=(currentActiveDropIndex+1)%nextDropTargets.length;return nextDropTargets[reverse?previousElement:nextElement][1]}function ChildDragDropProvider({dragging:dragging,setDragging:setDragging,setKeyboardMode:setKeyboardMode,keyboardMode:keyboardMode,activeDropTarget:activeDropTarget,setActiveDropTarget:setActiveDropTarget,setA11yMessage:setA11yMessage,registerDropTarget:registerDropTarget,dropTargetsByOrder:dropTargetsByOrder,children:children}){const value=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>({setKeyboardMode:setKeyboardMode,keyboardMode:keyboardMode,dragging:dragging,setDragging:setDragging,activeDropTarget:activeDropTarget,setActiveDropTarget:setActiveDropTarget,setA11yMessage:setA11yMessage,dropTargetsByOrder:dropTargetsByOrder,registerDropTarget:registerDropTarget}),[setDragging,dragging,activeDropTarget,setActiveDropTarget,setKeyboardMode,keyboardMode,setA11yMessage,dropTargetsByOrder,registerDropTarget]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(DragContext.Provider,{value:value},children)}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ReorderContext}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ReorderProvider}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var classnames__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(36);var classnames__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);const ReorderContext=react__WEBPACK_IMPORTED_MODULE_0___default.a.createContext({reorderState:{reorderedItems:[],direction:"-",draggingHeight:40,isReorderOn:false,groupId:""},setReorderState:()=>()=>{}});function ReorderProvider({id:id,children:children,className:className}){const[state,setState]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])({reorderedItems:[],direction:"-",draggingHeight:40,isReorderOn:false,groupId:id});const setReorderState=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>dispatch=>setState(dispatch),[setState]);return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{"data-test-subj":"lnsDragDrop-reorderableGroup",className:classnames__WEBPACK_IMPORTED_MODULE_1___default()(className,{"lnsDragDrop-isActiveGroup":state.isReorderOn&&react__WEBPACK_IMPORTED_MODULE_0___default.a.Children.count(children)>1})},react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(ReorderContext.Provider,{value:{reorderState:state,setReorderState:setReorderState}},children))}},function(module,exports){},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return announce}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);const selectedTargetReplace=({label:label},{label:dropLabel,groupLabel:groupLabel,position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.replace",{defaultMessage:`Replace {dropLabel} in {groupLabel} group at position {position} with {label}. Press space or enter to replace`,values:{label:label,dropLabel:dropLabel,groupLabel:groupLabel,position:position}});const droppedReplace=({label:label},{label:dropLabel,groupLabel:groupLabel,position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.duplicated.replace",{defaultMessage:"Replaced {dropLabel} with {label} in {groupLabel} at position {position}",values:{label:label,dropLabel:dropLabel,groupLabel:groupLabel,position:position}});const announcements={selectedTarget:{reorder:({label:label,groupLabel:groupLabel,position:prevPosition},{position:position})=>prevPosition===position?_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.reorderedBack",{defaultMessage:`{label} returned to its initial position {prevPosition}`,values:{label:label,prevPosition:prevPosition}}):_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.reordered",{defaultMessage:`Reorder {label} in {groupLabel} group from position {prevPosition} to position {position}. Press space or enter to reorder`,values:{groupLabel:groupLabel,label:label,position:position,prevPosition:prevPosition}}),duplicate_in_group:({label:label},{groupLabel:groupLabel,position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.duplicated",{defaultMessage:`Duplicate {label} to {groupLabel} group at position {position}. Press space or enter to duplicate`,values:{label:label,groupLabel:groupLabel,position:position}}),field_replace:selectedTargetReplace,replace_compatible:selectedTargetReplace,replace_incompatible:({label:label},{label:dropLabel,groupLabel:groupLabel,position:position,nextLabel:nextLabel})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.replaceIncompatible",{defaultMessage:`Convert {label} to {nextLabel} and replace {dropLabel} in {groupLabel} group at position {position}. Press space or enter to replace`,values:{label:label,nextLabel:nextLabel,dropLabel:dropLabel,groupLabel:groupLabel,position:position}}),move_incompatible:({label:label},{label:groupLabel,position:position,nextLabel:nextLabel})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.moveIncompatible",{defaultMessage:`Convert {label} to {nextLabel} and move to {groupLabel} group at position {position}. Press space or enter to move`,values:{label:label,nextLabel:nextLabel,groupLabel:groupLabel,position:position}}),move_compatible:({label:label},{groupLabel:groupLabel,position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.moveCompatible",{defaultMessage:`Move {label} to {groupLabel} group at position {position}. Press space or enter to move`,values:{label:label,groupLabel:groupLabel,position:position}})},dropped:{reorder:({label:label,groupLabel:groupLabel,position:prevPosition},{position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.dropped.reordered",{defaultMessage:"Reordered {label} in {groupLabel} group from position {prevPosition} to positon {position}",values:{label:label,groupLabel:groupLabel,position:position,prevPosition:prevPosition}}),duplicate_in_group:({label:label},{groupLabel:groupLabel,position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.dropped.duplicated",{defaultMessage:"Duplicated {label} in {groupLabel} group at position {position}",values:{label:label,groupLabel:groupLabel,position:position}}),field_replace:droppedReplace,replace_compatible:droppedReplace,replace_incompatible:({label:label},{label:dropLabel,groupLabel:groupLabel,position:position,nextLabel:nextLabel})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.dropped.replaceIncompatible",{defaultMessage:"Converted {label} to {nextLabel} and replaced {dropLabel} in {groupLabel} group at position {position}",values:{label:label,nextLabel:nextLabel,dropLabel:dropLabel,groupLabel:groupLabel,position:position}}),move_incompatible:({label:label},{groupLabel:groupLabel,position:position,nextLabel:nextLabel})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.dropped.moveIncompatible",{defaultMessage:"Converted {label} to {nextLabel} and moved to {groupLabel} group at position {position}",values:{label:label,nextLabel:nextLabel,groupLabel:groupLabel,position:position}}),move_compatible:({label:label},{groupLabel:groupLabel,position:position})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.dropped.moveCompatible",{defaultMessage:"Moved {label} to {groupLabel} group at position {position}",values:{label:label,groupLabel:groupLabel,position:position}})}};const defaultAnnouncements={lifted:({label:label})=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.lifted",{defaultMessage:`Lifted {label}`,values:{label:label}}),cancelled:({label:label,groupLabel:groupLabel,position:position})=>{if(!groupLabel||!position){return _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.cancelled",{defaultMessage:"Movement cancelled. {label} returned to its initial position",values:{label:label}})}return _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.cancelledItem",{defaultMessage:"Movement cancelled. {label} returned to {groupLabel} group at position {position}",values:{label:label,groupLabel:groupLabel,position:position}})},noTarget:()=>_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.noSelected",{defaultMessage:`No target selected. Use arrow keys to select a target`}),dropped:({label:label},{groupLabel:dropGroupLabel,position:position,label:dropLabel})=>dropGroupLabel&&position?_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.droppedDefault",{defaultMessage:"Added {label} in {dropGroupLabel} group at position {position}",values:{label:label,dropGroupLabel:dropGroupLabel,position:position}}):_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.droppedNoPosition",{defaultMessage:"Added {label} to {dropLabel}",values:{label:label,dropLabel:dropLabel}}),selectedTarget:({label:label},{label:dropLabel,groupLabel:dropGroupLabel,position:position})=>dropGroupLabel&&position?_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.default",{defaultMessage:`Add {label} to {dropGroupLabel} group at position {position}. Press space or enter to add`,values:{label:label,dropGroupLabel:dropGroupLabel,position:position}}):_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.lens.dragDrop.announce.selectedTarget.defaultNoPosition",{defaultMessage:`Add {label} to {dropLabel}. Press space or enter to add`,values:{dropLabel:dropLabel,label:label}})};const announce={...defaultAnnouncements,dropped:(draggedElement,dropElement,type)=>{var _announcements$droppe,_announcements$droppe2;return type&&((_announcements$droppe=announcements.dropped)===null||_announcements$droppe===void 0?void 0:(_announcements$droppe2=_announcements$droppe[type])===null||_announcements$droppe2===void 0?void 0:_announcements$droppe2.call(_announcements$droppe,draggedElement,dropElement))||defaultAnnouncements.dropped(draggedElement,dropElement)},selectedTarget:(draggedElement,dropElement,type)=>{var _announcements$select,_announcements$select2;return type&&((_announcements$select=announcements.selectedTarget)===null||_announcements$select===void 0?void 0:(_announcements$select2=_announcements$select[type])===null||_announcements$select2===void 0?void 0:_announcements$select2.call(_announcements$select,draggedElement,dropElement))||defaultAnnouncements.selectedTarget(draggedElement,dropElement)}}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return DragDrop}));var _drag_drop_scss__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(186);var _drag_drop_scss__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_drag_drop_scss__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var classnames__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(36);var classnames__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(19);var _elastic_eui__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__);var react_use_lib_useShallowCompareEffect__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(195);var react_use_lib_useShallowCompareEffect__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(react_use_lib_useShallowCompareEffect__WEBPACK_IMPORTED_MODULE_4__);var _providers__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(40);var _lens_ui_telemetry__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(35);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const lnsLayerPanelDimensionMargin=8;const DragDrop=props=>{const{dragging:dragging,setDragging:setDragging,keyboardMode:keyboardMode,registerDropTarget:registerDropTarget,dropTargetsByOrder:dropTargetsByOrder,setKeyboardMode:setKeyboardMode,activeDropTarget:activeDropTarget,setActiveDropTarget:setActiveDropTarget,setA11yMessage:setA11yMessage}=Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_providers__WEBPACK_IMPORTED_MODULE_5__["DragContext"]);const{value:value,draggable:draggable,dropType:dropType,reorderableGroup:reorderableGroup}=props;const isDragging=!!(draggable&&value.id===(dragging===null||dragging===void 0?void 0:dragging.id));const activeDraggingProps=isDragging?{keyboardMode:keyboardMode,activeDropTarget:activeDropTarget,dropTargetsByOrder:dropTargetsByOrder}:undefined;if(draggable&&!dropType){const dragProps={...props,activeDraggingProps:activeDraggingProps,setKeyboardMode:setKeyboardMode,setDragging:setDragging,setActiveDropTarget:setActiveDropTarget,setA11yMessage:setA11yMessage};if(reorderableGroup&&reorderableGroup.length>1){return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ReorderableDrag,_extends({},dragProps,{reorderableGroup:reorderableGroup}))}else{return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(DragInner,dragProps)}}const isActiveDropTarget=Boolean((activeDropTarget===null||activeDropTarget===void 0?void 0:activeDropTarget.id)===value.id);const dropProps={...props,keyboardMode:keyboardMode,setKeyboardMode:setKeyboardMode,dragging:dragging,setDragging:setDragging,isActiveDropTarget:isActiveDropTarget,setActiveDropTarget:setActiveDropTarget,registerDropTarget:registerDropTarget,setA11yMessage:setA11yMessage,isNotDroppable:!!(!dropType&&dragging&&value.id!==dragging.id)};if(reorderableGroup&&reorderableGroup.length>1&&reorderableGroup!==null&&reorderableGroup!==void 0&&reorderableGroup.some(i=>i.id===(dragging===null||dragging===void 0?void 0:dragging.id))){return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(ReorderableDrop,_extends({},dropProps,{reorderableGroup:reorderableGroup}))}return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(DropInner,dropProps)};const DragInner=Object(react__WEBPACK_IMPORTED_MODULE_1__["memo"])((function DragInner({dataTestSubj:dataTestSubj,className:className,value:value,children:children,setDragging:setDragging,setKeyboardMode:setKeyboardMode,setActiveDropTarget:setActiveDropTarget,order:order,activeDraggingProps:activeDraggingProps,dragType:dragType,onDragStart:onDragStart,onDragEnd:onDragEnd,extraKeyboardHandler:extraKeyboardHandler,ariaDescribedBy:ariaDescribedBy,setA11yMessage:setA11yMessage}){const keyboardMode=activeDraggingProps===null||activeDraggingProps===void 0?void 0:activeDraggingProps.keyboardMode;const activeDropTarget=activeDraggingProps===null||activeDraggingProps===void 0?void 0:activeDraggingProps.activeDropTarget;const dropTargetsByOrder=activeDraggingProps===null||activeDraggingProps===void 0?void 0:activeDraggingProps.dropTargetsByOrder;const dragStart=(e,keyboardModeOn)=>{if(e&&"dataTransfer"in e&&e.dataTransfer.getData("text")){return}if(e&&"dataTransfer"in e){e.dataTransfer.setData("text",value.humanData.label)}const currentTarget=e===null||e===void 0?void 0:e.currentTarget;setTimeout(()=>{setDragging({...value,ghost:keyboardModeOn?{children:children,style:{width:currentTarget.offsetWidth,height:currentTarget.offsetHeight}}:undefined});setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].lifted(value.humanData));if(keyboardModeOn){setKeyboardMode(true)}if(onDragStart){onDragStart(currentTarget)}})};const dragEnd=e=>{e===null||e===void 0?void 0:e.stopPropagation();setDragging(undefined);setActiveDropTarget(undefined);setKeyboardMode(false);setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].cancelled(value.humanData));if(onDragEnd){onDragEnd()}};const dropToActiveDropTarget=()=>{if(activeDropTarget){Object(_lens_ui_telemetry__WEBPACK_IMPORTED_MODULE_6__["e"])("drop_total");const{dropType:dropType,humanData:humanData,onDrop:onTargetDrop}=activeDropTarget;setTimeout(()=>setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].dropped(value.humanData,humanData,dropType)));onTargetDrop(value,dropType)}};const setNextTarget=(reversed=false)=>{if(!order){return}const nextTarget=Object(_providers__WEBPACK_IMPORTED_MODULE_5__["nextValidDropTarget"])(dropTargetsByOrder,activeDropTarget,[order.join(",")],el=>(el===null||el===void 0?void 0:el.dropType)!=="reorder",reversed);setActiveDropTarget(nextTarget);setA11yMessage(nextTarget?_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].selectedTarget(value.humanData,nextTarget===null||nextTarget===void 0?void 0:nextTarget.humanData,nextTarget===null||nextTarget===void 0?void 0:nextTarget.dropType):_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].noTarget())};const shouldShowGhostImageInstead=dragType==="move"&&keyboardMode&&activeDropTarget&&activeDropTarget.dropType!=="reorder";return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{className:classnames__WEBPACK_IMPORTED_MODULE_2___default()(className,{"lnsDragDrop-isHidden-noFocus":shouldShowGhostImageInstead}),"data-test-subj":`lnsDragDrop_draggable-${value.humanData.label}`},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["EuiScreenReaderOnly"],{showOnFocus:true},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("button",{"aria-label":value.humanData.label,"aria-describedby":ariaDescribedBy||`lnsDragDrop-keyboardInstructions`,className:"lnsDragDrop__keyboardHandler","data-test-subj":"lnsDragDrop-keyboardHandler",onBlur:()=>{if(activeDraggingProps){dragEnd()}},onKeyDown:e=>{const{key:key}=e;if(key===_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ENTER||key===_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].SPACE){if(activeDropTarget){dropToActiveDropTarget()}if(activeDraggingProps){dragEnd()}else{dragStart(e,true)}}else if(key===_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ESCAPE){if(activeDraggingProps){e.stopPropagation();e.preventDefault();dragEnd()}}if(extraKeyboardHandler){extraKeyboardHandler(e)}if(keyboardMode&&(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_LEFT===key||_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_RIGHT===key)){setNextTarget(!!(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_LEFT===key))}}})),react__WEBPACK_IMPORTED_MODULE_1___default.a.cloneElement(children,{"data-test-subj":dataTestSubj||"lnsDragDrop",className:classnames__WEBPACK_IMPORTED_MODULE_2___default()(children.props.className,"lnsDragDrop","lnsDragDrop-isDraggable",{"lnsDragDrop-isHidden":activeDraggingProps&&dragType==="move"&&!keyboardMode||shouldShowGhostImageInstead}),draggable:true,onDragEnd:dragEnd,onDragStart:dragStart}))}));const DropInner=Object(react__WEBPACK_IMPORTED_MODULE_1__["memo"])((function DropInner(props){const{dataTestSubj:dataTestSubj,className:className,onDrop:onDrop,value:value,children:children,draggable:draggable,dragging:dragging,isNotDroppable:isNotDroppable,dropType:dropType,order:order,getAdditionalClassesOnEnter:getAdditionalClassesOnEnter,getAdditionalClassesOnDroppable:getAdditionalClassesOnDroppable,isActiveDropTarget:isActiveDropTarget,registerDropTarget:registerDropTarget,setActiveDropTarget:setActiveDropTarget,keyboardMode:keyboardMode,setKeyboardMode:setKeyboardMode,setDragging:setDragging,setA11yMessage:setA11yMessage}=props;react_use_lib_useShallowCompareEffect__WEBPACK_IMPORTED_MODULE_4___default()(()=>{if(dropType&&onDrop&&keyboardMode){registerDropTarget(order,{...value,onDrop:onDrop,dropType:dropType});return()=>{registerDropTarget(order,undefined)}}},[order,value,registerDropTarget,dropType,keyboardMode]);const classesOnEnter=getAdditionalClassesOnEnter===null||getAdditionalClassesOnEnter===void 0?void 0:getAdditionalClassesOnEnter(dropType);const classesOnDroppable=getAdditionalClassesOnDroppable===null||getAdditionalClassesOnDroppable===void 0?void 0:getAdditionalClassesOnDroppable(dropType);const classes=classnames__WEBPACK_IMPORTED_MODULE_2___default()("lnsDragDrop",{"lnsDragDrop-isDraggable":draggable,"lnsDragDrop-isDroppable":!draggable,"lnsDragDrop-isDropTarget":dropType&&dropType!=="reorder","lnsDragDrop-isActiveDropTarget":dropType&&isActiveDropTarget&&dropType!=="reorder","lnsDragDrop-isNotDroppable":isNotDroppable},classesOnEnter&&{[classesOnEnter]:isActiveDropTarget},classesOnDroppable&&{[classesOnDroppable]:dropType});const dragOver=e=>{if(!dropType){return}e.preventDefault();if(!isActiveDropTarget&&dragging&&onDrop){setActiveDropTarget({...value,dropType:dropType,onDrop:onDrop});setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].selectedTarget(dragging.humanData,value.humanData,dropType))}};const dragLeave=()=>{setActiveDropTarget(undefined)};const drop=e=>{e.preventDefault();e.stopPropagation();if(onDrop&&dropType&&dragging){Object(_lens_ui_telemetry__WEBPACK_IMPORTED_MODULE_6__["e"])("drop_total");onDrop(dragging,dropType);setTimeout(()=>setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].dropped(dragging.humanData,value.humanData,dropType)))}setDragging(undefined);setActiveDropTarget(undefined);setKeyboardMode(false)};const ghost=isActiveDropTarget&&dropType!=="reorder"&&dragging!==null&&dragging!==void 0&&dragging.ghost?dragging.ghost:undefined;return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_1___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_1___default.a.cloneElement(children,{"data-test-subj":dataTestSubj||"lnsDragDrop",className:classnames__WEBPACK_IMPORTED_MODULE_2___default()(children.props.className,classes,className),onDragOver:dragOver,onDragLeave:dragLeave,onDrop:drop,draggable:draggable}),ghost?react__WEBPACK_IMPORTED_MODULE_1___default.a.cloneElement(ghost.children,{className:classnames__WEBPACK_IMPORTED_MODULE_2___default()(ghost.children.props.className,"lnsDragDrop_ghost"),style:ghost.style}):null)}));const ReorderableDrag=Object(react__WEBPACK_IMPORTED_MODULE_1__["memo"])((function ReorderableDrag(props){const{reorderState:{isReorderOn:isReorderOn,reorderedItems:reorderedItems,direction:direction},setReorderState:setReorderState}=Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_providers__WEBPACK_IMPORTED_MODULE_5__["ReorderContext"]);const{value:value,setActiveDropTarget:setActiveDropTarget,activeDraggingProps:activeDraggingProps,reorderableGroup:reorderableGroup,setA11yMessage:setA11yMessage}=props;const keyboardMode=activeDraggingProps===null||activeDraggingProps===void 0?void 0:activeDraggingProps.keyboardMode;const activeDropTarget=activeDraggingProps===null||activeDraggingProps===void 0?void 0:activeDraggingProps.activeDropTarget;const dropTargetsByOrder=activeDraggingProps===null||activeDraggingProps===void 0?void 0:activeDraggingProps.dropTargetsByOrder;const isDragging=!!activeDraggingProps;const isFocusInGroup=keyboardMode?isDragging&&(!activeDropTarget||reorderableGroup.some(i=>i.id===(activeDropTarget===null||activeDropTarget===void 0?void 0:activeDropTarget.id))):isDragging;Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{setReorderState(s=>({...s,isReorderOn:isFocusInGroup}))},[setReorderState,isFocusInGroup]);const onReorderableDragStart=currentTarget=>{if(currentTarget){const height=currentTarget.offsetHeight+lnsLayerPanelDimensionMargin;setReorderState(s=>({...s,draggingHeight:height}))}};const onReorderableDragEnd=()=>{resetReorderState()};const resetReorderState=()=>setReorderState(s=>({...s,reorderedItems:[]}));const extraKeyboardHandler=e=>{if(isReorderOn&&keyboardMode){e.stopPropagation();e.preventDefault();let activeDropTargetIndex=reorderableGroup.findIndex(i=>i.id===value.id);if(activeDropTarget){const index=reorderableGroup.findIndex(i=>i.id===(activeDropTarget===null||activeDropTarget===void 0?void 0:activeDropTarget.id));if(index!==-1)activeDropTargetIndex=index}if(e.key===_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_LEFT||e.key===_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_RIGHT){resetReorderState();setActiveDropTarget(undefined)}else if(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_DOWN===e.key){if(activeDropTargetIndex<reorderableGroup.length-1){const nextTarget=Object(_providers__WEBPACK_IMPORTED_MODULE_5__["nextValidDropTarget"])(dropTargetsByOrder,activeDropTarget,[props.order.join(",")],el=>(el===null||el===void 0?void 0:el.dropType)==="reorder");onReorderableDragOver(nextTarget)}}else if(_elastic_eui__WEBPACK_IMPORTED_MODULE_3__["keys"].ARROW_UP===e.key){if(activeDropTargetIndex>0){const nextTarget=Object(_providers__WEBPACK_IMPORTED_MODULE_5__["nextValidDropTarget"])(dropTargetsByOrder,activeDropTarget,[props.order.join(",")],el=>(el===null||el===void 0?void 0:el.dropType)==="reorder",true);onReorderableDragOver(nextTarget)}}}};const onReorderableDragOver=target=>{if(!target){setReorderState(s=>({...s,reorderedItems:[]}));setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].selectedTarget(value.humanData,value.humanData,"reorder"));setActiveDropTarget(target);return}const droppingIndex=reorderableGroup.findIndex(i=>i.id===target.id);const draggingIndex=reorderableGroup.findIndex(i=>i.id===(value===null||value===void 0?void 0:value.id));if(draggingIndex===-1){return}setActiveDropTarget(target);setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].selectedTarget(value.humanData,target.humanData,"reorder"));setReorderState(s=>draggingIndex<droppingIndex?{...s,reorderedItems:reorderableGroup.slice(draggingIndex+1,droppingIndex+1),direction:"-"}:{...s,reorderedItems:reorderableGroup.slice(droppingIndex,draggingIndex),direction:"+"})};const areItemsReordered=isDragging&&keyboardMode&&reorderedItems.length;return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{"data-test-subj":"lnsDragDrop-reorderableDrag",className:isDragging?"lnsDragDrop-reorderable lnsDragDrop-translatableDrag":"lnsDragDrop-reorderable",style:areItemsReordered?{transform:`translateY(${direction==="+"?"-":"+"}${reorderedItems.reduce((acc,cur)=>acc+Number(cur.height||0)+lnsLayerPanelDimensionMargin,0)}px)`}:undefined},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(DragInner,_extends({},props,{ariaDescribedBy:"lnsDragDrop-keyboardInstructionsWithReorder",extraKeyboardHandler:extraKeyboardHandler,onDragStart:onReorderableDragStart,onDragEnd:onReorderableDragEnd})))}));const ReorderableDrop=Object(react__WEBPACK_IMPORTED_MODULE_1__["memo"])((function ReorderableDrop(props){const{onDrop:onDrop,value:value,dragging:dragging,setDragging:setDragging,setKeyboardMode:setKeyboardMode,isActiveDropTarget:isActiveDropTarget,setActiveDropTarget:setActiveDropTarget,reorderableGroup:reorderableGroup,setA11yMessage:setA11yMessage,dropType:dropType}=props;const currentIndex=reorderableGroup.findIndex(i=>i.id===value.id);const{reorderState:{isReorderOn:isReorderOn,reorderedItems:reorderedItems,draggingHeight:draggingHeight,direction:direction},setReorderState:setReorderState}=Object(react__WEBPACK_IMPORTED_MODULE_1__["useContext"])(_providers__WEBPACK_IMPORTED_MODULE_5__["ReorderContext"]);const heightRef=react__WEBPACK_IMPORTED_MODULE_1___default.a.useRef(null);const isReordered=isReorderOn&&reorderedItems.some(el=>el.id===value.id)&&reorderedItems.length;Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{var _heightRef$current;if(isReordered&&(_heightRef$current=heightRef.current)!==null&&_heightRef$current!==void 0&&_heightRef$current.clientHeight){setReorderState(s=>({...s,reorderedItems:s.reorderedItems.map(el=>{var _heightRef$current2;return el.id===value.id?{...el,height:(_heightRef$current2=heightRef.current)===null||_heightRef$current2===void 0?void 0:_heightRef$current2.clientHeight}:el})}))}},[isReordered,setReorderState,value.id]);const onReorderableDragOver=e=>{if(!dropType){return}e.preventDefault();if(!isActiveDropTarget&&dropType&&onDrop){setActiveDropTarget({...value,dropType:dropType,onDrop:onDrop})}const draggingIndex=reorderableGroup.findIndex(i=>i.id===(dragging===null||dragging===void 0?void 0:dragging.id));if(!dragging||draggingIndex===-1){return}const droppingIndex=currentIndex;if(draggingIndex===droppingIndex){setReorderState(s=>({...s,reorderedItems:[]}))}setReorderState(s=>draggingIndex<droppingIndex?{...s,reorderedItems:reorderableGroup.slice(draggingIndex+1,droppingIndex+1),direction:"-"}:{...s,reorderedItems:reorderableGroup.slice(droppingIndex,draggingIndex),direction:"+"})};const onReorderableDrop=e=>{e.preventDefault();e.stopPropagation();setActiveDropTarget(undefined);setDragging(undefined);setKeyboardMode(false);if(onDrop&&dropType&&dragging){Object(_lens_ui_telemetry__WEBPACK_IMPORTED_MODULE_6__["e"])("drop_total");onDrop(dragging,"reorder");setTimeout(()=>setA11yMessage(_providers__WEBPACK_IMPORTED_MODULE_5__["announce"].dropped(dragging.humanData,value.humanData,"reorder")))}};return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",null,react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{style:reorderedItems.some(i=>i.id===value.id)?{transform:`translateY(${direction}${draggingHeight}px)`}:undefined,ref:heightRef,"data-test-subj":"lnsDragDrop-translatableDrop",className:"lnsDragDrop-translatableDrop lnsDragDrop-reorderable"},react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(DropInner,props)),react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement("div",{"data-test-subj":"lnsDragDrop-reorderableDropLayer",className:classnames__WEBPACK_IMPORTED_MODULE_2___default()("lnsDragDrop",{["lnsDragDrop__reorderableDrop"]:dragging&&dropType}),onDrop:onReorderableDrop,onDragOver:onReorderableDragOver,onDragLeave:()=>{setReorderState(s=>({...s,reorderedItems:[]}))}}))}))},function(module,exports,__webpack_require__){"use strict";function peg$subclass(child,parent){function ctor(){this.constructor=child}ctor.prototype=parent.prototype;child.prototype=new ctor}function peg$SyntaxError(message,expected,found,location){this.message=message;this.expected=expected;this.found=found;this.location=location;this.name="SyntaxError";if(typeof Error.captureStackTrace==="function"){Error.captureStackTrace(this,peg$SyntaxError)}}peg$subclass(peg$SyntaxError,Error);peg$SyntaxError.buildMessage=function(expected,found){var DESCRIBE_EXPECTATION_FNS={literal:function(expectation){return'"'+literalEscape(expectation.text)+'"'},class:function(expectation){var escapedParts="",i;for(i=0;i<expectation.parts.length;i++){escapedParts+=expectation.parts[i]instanceof Array?classEscape(expectation.parts[i][0])+"-"+classEscape(expectation.parts[i][1]):classEscape(expectation.parts[i])}return"["+(expectation.inverted?"^":"")+escapedParts+"]"},any:function(expectation){return"any character"},end:function(expectation){return"end of input"},other:function(expectation){return expectation.description}};function hex(ch){return ch.charCodeAt(0).toString(16).toUpperCase()}function literalEscape(s){return s.replace(/\\/g,"\\\\").replace(/"/g,'\\"').replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,(function(ch){return"\\x0"+hex(ch)})).replace(/[\x10-\x1F\x7F-\x9F]/g,(function(ch){return"\\x"+hex(ch)}))}function classEscape(s){return s.replace(/\\/g,"\\\\").replace(/\]/g,"\\]").replace(/\^/g,"\\^").replace(/-/g,"\\-").replace(/\0/g,"\\0").replace(/\t/g,"\\t").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/[\x00-\x0F]/g,(function(ch){return"\\x0"+hex(ch)})).replace(/[\x10-\x1F\x7F-\x9F]/g,(function(ch){return"\\x"+hex(ch)}))}function describeExpectation(expectation){return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation)}function describeExpected(expected){var descriptions=new Array(expected.length),i,j;for(i=0;i<expected.length;i++){descriptions[i]=describeExpectation(expected[i])}descriptions.sort();if(descriptions.length>0){for(i=1,j=1;i<descriptions.length;i++){if(descriptions[i-1]!==descriptions[i]){descriptions[j]=descriptions[i];j++}}descriptions.length=j}switch(descriptions.length){case 1:return descriptions[0];case 2:return descriptions[0]+" or "+descriptions[1];default:return descriptions.slice(0,-1).join(", ")+", or "+descriptions[descriptions.length-1]}}function describeFound(found){return found?'"'+literalEscape(found)+'"':"end of input"}return"Expected "+describeExpected(expected)+" but "+describeFound(found)+" found."};function peg$parse(input,options){options=options!==void 0?options:{};var peg$FAILED={},peg$startRuleFunctions={expression:peg$parseexpression,argument:peg$parseargument},peg$startRuleFunction=peg$parseexpression,peg$c0="|",peg$c1=peg$literalExpectation("|",false),peg$c2=function(first,fn){return fn},peg$c3=function(first,rest){return addMeta({type:"expression",chain:[first].concat(rest)},text(),location())},peg$c4=peg$otherExpectation("function"),peg$c5=function(name,arg_list){return addMeta({type:"function",function:name,arguments:arg_list},text(),location())},peg$c6="=",peg$c7=peg$literalExpectation("=",false),peg$c8=function(name,value){return{name:name,value:value}},peg$c9=function(value){return{name:"_",value:value}},peg$c10="$",peg$c11=peg$literalExpectation("$",false),peg$c12="{",peg$c13=peg$literalExpectation("{",false),peg$c14="}",peg$c15=peg$literalExpectation("}",false),peg$c16=function(expression){return expression},peg$c17=function(value){return addMeta(value,text(),location())},peg$c18=function(arg){return arg},peg$c19=function(args){return args.reduce((accumulator,{name:name,value:value})=>({...accumulator,[name]:(accumulator[name]||[]).concat(value)}),{})},peg$c20=/^[a-zA-Z0-9_\-]/,peg$c21=peg$classExpectation([["a","z"],["A","Z"],["0","9"],"_","-"],false,false),peg$c22=function(name){return name.join("")},peg$c23=peg$otherExpectation("literal"),peg$c24='"',peg$c25=peg$literalExpectation('"',false),peg$c26=function(chars){return chars.join("")},peg$c27="'",peg$c28=peg$literalExpectation("'",false),peg$c29=function(string){var result=string.join("");if(result==="null")return null;if(result==="true")return true;if(result==="false")return false;if(isNaN(Number(result)))return result;return Number(result)},peg$c30=/^[ \t\r\n]/,peg$c31=peg$classExpectation([" ","\t","\r","\n"],false,false),peg$c32="\\",peg$c33=peg$literalExpectation("\\",false),peg$c34=/^["'(){}<>[\]$`|= \t\n\r]/,peg$c35=peg$classExpectation(['"',"'","(",")","{","}","<",">","[","]","$","`","|","="," ","\t","\n","\r"],false,false),peg$c36=function(sequence){return sequence},peg$c37=/^[^"'(){}<>[\]$`|= \t\n\r]/,peg$c38=peg$classExpectation(['"',"'","(",")","{","}","<",">","[","]","$","`","|","="," ","\t","\n","\r"],true,false),peg$c39=/^[^"]/,peg$c40=peg$classExpectation(['"'],true,false),peg$c41=/^[^']/,peg$c42=peg$classExpectation(["'"],true,false),peg$currPos=0,peg$savedPos=0,peg$posDetailsCache=[{line:1,column:1}],peg$maxFailPos=0,peg$maxFailExpected=[],peg$silentFails=0,peg$result;if("startRule"in options){if(!(options.startRule in peg$startRuleFunctions)){throw new Error("Can't start parsing from rule \""+options.startRule+'".')}peg$startRuleFunction=peg$startRuleFunctions[options.startRule]}function text(){return input.substring(peg$savedPos,peg$currPos)}function location(){return peg$computeLocation(peg$savedPos,peg$currPos)}function expected(description,location){location=location!==void 0?location:peg$computeLocation(peg$savedPos,peg$currPos);throw peg$buildStructuredError([peg$otherExpectation(description)],input.substring(peg$savedPos,peg$currPos),location)}function error(message,location){location=location!==void 0?location:peg$computeLocation(peg$savedPos,peg$currPos);throw peg$buildSimpleError(message,location)}function peg$literalExpectation(text,ignoreCase){return{type:"literal",text:text,ignoreCase:ignoreCase}}function peg$classExpectation(parts,inverted,ignoreCase){return{type:"class",parts:parts,inverted:inverted,ignoreCase:ignoreCase}}function peg$anyExpectation(){return{type:"any"}}function peg$endExpectation(){return{type:"end"}}function peg$otherExpectation(description){return{type:"other",description:description}}function peg$computePosDetails(pos){var details=peg$posDetailsCache[pos],p;if(details){return details}else{p=pos-1;while(!peg$posDetailsCache[p]){p--}details=peg$posDetailsCache[p];details={line:details.line,column:details.column};while(p<pos){if(input.charCodeAt(p)===10){details.line++;details.column=1}else{details.column++}p++}peg$posDetailsCache[pos]=details;return details}}function peg$computeLocation(startPos,endPos){var startPosDetails=peg$computePosDetails(startPos),endPosDetails=peg$computePosDetails(endPos);return{start:{offset:startPos,line:startPosDetails.line,column:startPosDetails.column},end:{offset:endPos,line:endPosDetails.line,column:endPosDetails.column}}}function peg$fail(expected){if(peg$currPos<peg$maxFailPos){return}if(peg$currPos>peg$maxFailPos){peg$maxFailPos=peg$currPos;peg$maxFailExpected=[]}peg$maxFailExpected.push(expected)}function peg$buildSimpleError(message,location){return new peg$SyntaxError(message,null,null,location)}function peg$buildStructuredError(expected,found,location){return new peg$SyntaxError(peg$SyntaxError.buildMessage(expected,found),expected,found,location)}function peg$parseexpression(){var s0,s1,s2,s3,s4,s5,s6,s7;s0=peg$currPos;s1=peg$parsespace();if(s1===peg$FAILED){s1=null}if(s1!==peg$FAILED){s2=peg$parsefunction();if(s2!==peg$FAILED){s3=[];s4=peg$currPos;if(input.charCodeAt(peg$currPos)===124){s5=peg$c0;peg$currPos++}else{s5=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c1)}}if(s5!==peg$FAILED){s6=peg$parsespace();if(s6===peg$FAILED){s6=null}if(s6!==peg$FAILED){s7=peg$parsefunction();if(s7!==peg$FAILED){peg$savedPos=s4;s5=peg$c2(s2,s7);s4=s5}else{peg$currPos=s4;s4=peg$FAILED}}else{peg$currPos=s4;s4=peg$FAILED}}else{peg$currPos=s4;s4=peg$FAILED}while(s4!==peg$FAILED){s3.push(s4);s4=peg$currPos;if(input.charCodeAt(peg$currPos)===124){s5=peg$c0;peg$currPos++}else{s5=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c1)}}if(s5!==peg$FAILED){s6=peg$parsespace();if(s6===peg$FAILED){s6=null}if(s6!==peg$FAILED){s7=peg$parsefunction();if(s7!==peg$FAILED){peg$savedPos=s4;s5=peg$c2(s2,s7);s4=s5}else{peg$currPos=s4;s4=peg$FAILED}}else{peg$currPos=s4;s4=peg$FAILED}}else{peg$currPos=s4;s4=peg$FAILED}}if(s3!==peg$FAILED){peg$savedPos=s0;s1=peg$c3(s2,s3);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parsefunction(){var s0,s1,s2;peg$silentFails++;s0=peg$currPos;s1=peg$parseidentifier();if(s1!==peg$FAILED){s2=peg$parsearg_list();if(s2!==peg$FAILED){peg$savedPos=s0;s1=peg$c5(s1,s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}peg$silentFails--;if(s0===peg$FAILED){s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c4)}}return s0}function peg$parseargument_assignment(){var s0,s1,s2,s3,s4,s5;s0=peg$currPos;s1=peg$parseidentifier();if(s1!==peg$FAILED){s2=peg$parsespace();if(s2===peg$FAILED){s2=null}if(s2!==peg$FAILED){if(input.charCodeAt(peg$currPos)===61){s3=peg$c6;peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c7)}}if(s3!==peg$FAILED){s4=peg$parsespace();if(s4===peg$FAILED){s4=null}if(s4!==peg$FAILED){s5=peg$parseargument();if(s5!==peg$FAILED){peg$savedPos=s0;s1=peg$c8(s1,s5);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}if(s0===peg$FAILED){s0=peg$currPos;s1=peg$parseargument();if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c9(s1)}s0=s1}return s0}function peg$parseargument(){var s0,s1,s2,s3,s4;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===36){s1=peg$c10;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c11)}}if(s1===peg$FAILED){s1=null}if(s1!==peg$FAILED){if(input.charCodeAt(peg$currPos)===123){s2=peg$c12;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c13)}}if(s2!==peg$FAILED){s3=peg$parseexpression();if(s3!==peg$FAILED){if(input.charCodeAt(peg$currPos)===125){s4=peg$c14;peg$currPos++}else{s4=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c15)}}if(s4!==peg$FAILED){peg$savedPos=s0;s1=peg$c16(s3);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}if(s0===peg$FAILED){s0=peg$currPos;s1=peg$parseliteral();if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c17(s1)}s0=s1}return s0}function peg$parsearg_list(){var s0,s1,s2,s3,s4;s0=peg$currPos;s1=[];s2=peg$currPos;s3=peg$parsespace();if(s3!==peg$FAILED){s4=peg$parseargument_assignment();if(s4!==peg$FAILED){peg$savedPos=s2;s3=peg$c18(s4);s2=s3}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}while(s2!==peg$FAILED){s1.push(s2);s2=peg$currPos;s3=peg$parsespace();if(s3!==peg$FAILED){s4=peg$parseargument_assignment();if(s4!==peg$FAILED){peg$savedPos=s2;s3=peg$c18(s4);s2=s3}else{peg$currPos=s2;s2=peg$FAILED}}else{peg$currPos=s2;s2=peg$FAILED}}if(s1!==peg$FAILED){s2=peg$parsespace();if(s2===peg$FAILED){s2=null}if(s2!==peg$FAILED){peg$savedPos=s0;s1=peg$c19(s1);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}return s0}function peg$parseidentifier(){var s0,s1,s2;s0=peg$currPos;s1=[];if(peg$c20.test(input.charAt(peg$currPos))){s2=input.charAt(peg$currPos);peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c21)}}if(s2!==peg$FAILED){while(s2!==peg$FAILED){s1.push(s2);if(peg$c20.test(input.charAt(peg$currPos))){s2=input.charAt(peg$currPos);peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c21)}}}}else{s1=peg$FAILED}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c22(s1)}s0=s1;return s0}function peg$parseliteral(){var s0,s1;peg$silentFails++;s0=peg$parsephrase();if(s0===peg$FAILED){s0=peg$parseunquoted_string_or_number()}peg$silentFails--;if(s0===peg$FAILED){s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c23)}}return s0}function peg$parsephrase(){var s0,s1,s2,s3;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===34){s1=peg$c24;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c25)}}if(s1!==peg$FAILED){s2=[];s3=peg$parsedq_char();while(s3!==peg$FAILED){s2.push(s3);s3=peg$parsedq_char()}if(s2!==peg$FAILED){if(input.charCodeAt(peg$currPos)===34){s3=peg$c24;peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c25)}}if(s3!==peg$FAILED){peg$savedPos=s0;s1=peg$c26(s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}if(s0===peg$FAILED){s0=peg$currPos;if(input.charCodeAt(peg$currPos)===39){s1=peg$c27;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c28)}}if(s1!==peg$FAILED){s2=[];s3=peg$parsesq_char();while(s3!==peg$FAILED){s2.push(s3);s3=peg$parsesq_char()}if(s2!==peg$FAILED){if(input.charCodeAt(peg$currPos)===39){s3=peg$c27;peg$currPos++}else{s3=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c28)}}if(s3!==peg$FAILED){peg$savedPos=s0;s1=peg$c26(s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}}return s0}function peg$parseunquoted_string_or_number(){var s0,s1,s2;s0=peg$currPos;s1=[];s2=peg$parseunquoted();if(s2!==peg$FAILED){while(s2!==peg$FAILED){s1.push(s2);s2=peg$parseunquoted()}}else{s1=peg$FAILED}if(s1!==peg$FAILED){peg$savedPos=s0;s1=peg$c29(s1)}s0=s1;return s0}function peg$parsespace(){var s0,s1;s0=[];if(peg$c30.test(input.charAt(peg$currPos))){s1=input.charAt(peg$currPos);peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c31)}}if(s1!==peg$FAILED){while(s1!==peg$FAILED){s0.push(s1);if(peg$c30.test(input.charAt(peg$currPos))){s1=input.charAt(peg$currPos);peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c31)}}}}else{s0=peg$FAILED}return s0}function peg$parseunquoted(){var s0,s1,s2;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===92){s1=peg$c32;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c33)}}if(s1!==peg$FAILED){if(peg$c34.test(input.charAt(peg$currPos))){s2=input.charAt(peg$currPos);peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c35)}}if(s2===peg$FAILED){if(input.charCodeAt(peg$currPos)===92){s2=peg$c32;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c33)}}}if(s2!==peg$FAILED){peg$savedPos=s0;s1=peg$c36(s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}if(s0===peg$FAILED){if(peg$c37.test(input.charAt(peg$currPos))){s0=input.charAt(peg$currPos);peg$currPos++}else{s0=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c38)}}}return s0}function peg$parsedq_char(){var s0,s1,s2;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===92){s1=peg$c32;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c33)}}if(s1!==peg$FAILED){if(input.charCodeAt(peg$currPos)===34){s2=peg$c24;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c25)}}if(s2===peg$FAILED){if(input.charCodeAt(peg$currPos)===92){s2=peg$c32;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c33)}}}if(s2!==peg$FAILED){peg$savedPos=s0;s1=peg$c36(s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}if(s0===peg$FAILED){if(peg$c39.test(input.charAt(peg$currPos))){s0=input.charAt(peg$currPos);peg$currPos++}else{s0=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c40)}}}return s0}function peg$parsesq_char(){var s0,s1,s2;s0=peg$currPos;if(input.charCodeAt(peg$currPos)===92){s1=peg$c32;peg$currPos++}else{s1=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c33)}}if(s1!==peg$FAILED){if(input.charCodeAt(peg$currPos)===39){s2=peg$c27;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c28)}}if(s2===peg$FAILED){if(input.charCodeAt(peg$currPos)===92){s2=peg$c32;peg$currPos++}else{s2=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c33)}}}if(s2!==peg$FAILED){peg$savedPos=s0;s1=peg$c36(s2);s0=s1}else{peg$currPos=s0;s0=peg$FAILED}}else{peg$currPos=s0;s0=peg$FAILED}if(s0===peg$FAILED){if(peg$c41.test(input.charAt(peg$currPos))){s0=input.charAt(peg$currPos);peg$currPos++}else{s0=peg$FAILED;if(peg$silentFails===0){peg$fail(peg$c42)}}}return s0}function addMeta(node,text,{start:{offset:start},end:{offset:end}}){if(!options.addMeta)return node;return{node:node,text:text,start:start,end:end}}peg$result=peg$startRuleFunction();if(peg$result!==peg$FAILED&&peg$currPos===input.length){return peg$result}else{if(peg$result!==peg$FAILED&&peg$currPos<input.length){peg$fail(peg$endExpectation())}throw peg$buildStructuredError(peg$maxFailExpected,peg$maxFailPos<input.length?input.charAt(peg$maxFailPos):null,peg$maxFailPos<input.length?peg$computeLocation(peg$maxFailPos,peg$maxFailPos+1):peg$computeLocation(peg$maxFailPos,peg$maxFailPos))}}module.exports={SyntaxError:peg$SyntaxError,parse:peg$parse}},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(277);case"v7light":return __webpack_require__(279);case"v8dark":return __webpack_require__(281);case"v8light":return __webpack_require__(283)}},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(304);case"v7light":return __webpack_require__(306);case"v8dark":return __webpack_require__(308);case"v8light":return __webpack_require__(310)}},function(module,exports,__webpack_require__){(function(root){"use strict";const ipv4Part="(0?\\d+|0x[a-f0-9]+)";const ipv4Regexes={fourOctet:new RegExp(`^${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}$`,"i"),threeOctet:new RegExp(`^${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}$`,"i"),twoOctet:new RegExp(`^${ipv4Part}\\.${ipv4Part}$`,"i"),longValue:new RegExp(`^${ipv4Part}$`,"i")};const octalRegex=new RegExp(`^0[0-7]+$`,"i");const hexRegex=new RegExp(`^0x[a-f0-9]+$`,"i");const zoneIndex="%[0-9a-z]{1,}";const ipv6Part="(?:[0-9a-f]+::?)+";const ipv6Regexes={zoneIndex:new RegExp(zoneIndex,"i"),native:new RegExp(`^(::)?(${ipv6Part})?([0-9a-f]+)?(::)?(${zoneIndex})?$`,"i"),deprecatedTransitional:new RegExp(`^(?:::)(${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}(${zoneIndex})?)$`,"i"),transitional:new RegExp(`^((?:${ipv6Part})|(?:::)(?:${ipv6Part})?)${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}\\.${ipv4Part}(${zoneIndex})?$`,"i")};function expandIPv6(string,parts){if(string.indexOf("::")!==string.lastIndexOf("::")){return null}let colonCount=0;let lastColon=-1;let zoneId=(string.match(ipv6Regexes.zoneIndex)||[])[0];let replacement,replacementCount;if(zoneId){zoneId=zoneId.substring(1);string=string.replace(/%.+$/,"")}while((lastColon=string.indexOf(":",lastColon+1))>=0){colonCount++}if(string.substr(0,2)==="::"){colonCount--}if(string.substr(-2,2)==="::"){colonCount--}if(colonCount>parts){return null}replacementCount=parts-colonCount;replacement=":";while(replacementCount--){replacement+="0:"}string=string.replace("::",replacement);if(string[0]===":"){string=string.slice(1)}if(string[string.length-1]===":"){string=string.slice(0,-1)}parts=function(){const ref=string.split(":");const results=[];for(let i=0;i<ref.length;i++){results.push(parseInt(ref[i],16))}return results}();return{parts:parts,zoneId:zoneId}}function matchCIDR(first,second,partSize,cidrBits){if(first.length!==second.length){throw new Error("ipaddr: cannot match CIDR for objects with different lengths")}let part=0;let shift;while(cidrBits>0){shift=partSize-cidrBits;if(shift<0){shift=0}if(first[part]>>shift!==second[part]>>shift){return false}cidrBits-=partSize;part+=1}return true}function parseIntAuto(string){if(hexRegex.test(string)){return parseInt(string,16)}if(string[0]==="0"&&!isNaN(parseInt(string[1],10))){if(octalRegex.test(string)){return parseInt(string,8)}throw new Error(`ipaddr: cannot parse ${string} as octal`)}return parseInt(string,10)}function padPart(part,length){while(part.length<length){part=`0${part}`}return part}const ipaddr={};ipaddr.IPv4=function(){function IPv4(octets){if(octets.length!==4){throw new Error("ipaddr: ipv4 octet count should be 4")}let i,octet;for(i=0;i<octets.length;i++){octet=octets[i];if(!(0<=octet&&octet<=255)){throw new Error("ipaddr: ipv4 octet should fit in 8 bits")}}this.octets=octets}IPv4.prototype.SpecialRanges={unspecified:[[new IPv4([0,0,0,0]),8]],broadcast:[[new IPv4([255,255,255,255]),32]],multicast:[[new IPv4([224,0,0,0]),4]],linkLocal:[[new IPv4([169,254,0,0]),16]],loopback:[[new IPv4([127,0,0,0]),8]],carrierGradeNat:[[new IPv4([100,64,0,0]),10]],private:[[new IPv4([10,0,0,0]),8],[new IPv4([172,16,0,0]),12],[new IPv4([192,168,0,0]),16]],reserved:[[new IPv4([192,0,0,0]),24],[new IPv4([192,0,2,0]),24],[new IPv4([192,88,99,0]),24],[new IPv4([198,51,100,0]),24],[new IPv4([203,0,113,0]),24],[new IPv4([240,0,0,0]),4]]};IPv4.prototype.kind=function(){return"ipv4"};IPv4.prototype.match=function(other,cidrRange){let ref;if(cidrRange===undefined){ref=other;other=ref[0];cidrRange=ref[1]}if(other.kind()!=="ipv4"){throw new Error("ipaddr: cannot match ipv4 address with non-ipv4 one")}return matchCIDR(this.octets,other.octets,8,cidrRange)};IPv4.prototype.prefixLengthFromSubnetMask=function(){let cidr=0;let stop=false;const zerotable={0:8,128:7,192:6,224:5,240:4,248:3,252:2,254:1,255:0};let i,octet,zeros;for(i=3;i>=0;i-=1){octet=this.octets[i];if(octet in zerotable){zeros=zerotable[octet];if(stop&&zeros!==0){return null}if(zeros!==8){stop=true}cidr+=zeros}else{return null}}return 32-cidr};IPv4.prototype.range=function(){return ipaddr.subnetMatch(this,this.SpecialRanges)};IPv4.prototype.toByteArray=function(){return this.octets.slice(0)};IPv4.prototype.toIPv4MappedAddress=function(){return ipaddr.IPv6.parse(`::ffff:${this.toString()}`)};IPv4.prototype.toNormalizedString=function(){return this.toString()};IPv4.prototype.toString=function(){return this.octets.join(".")};return IPv4}();ipaddr.IPv4.broadcastAddressFromCIDR=function(string){try{const cidr=this.parseCIDR(string);const ipInterfaceOctets=cidr[0].toByteArray();const subnetMaskOctets=this.subnetMaskFromPrefixLength(cidr[1]).toByteArray();const octets=[];let i=0;while(i<4){octets.push(parseInt(ipInterfaceOctets[i],10)|parseInt(subnetMaskOctets[i],10)^255);i++}return new this(octets)}catch(e){throw new Error("ipaddr: the address does not have IPv4 CIDR format")}};ipaddr.IPv4.isIPv4=function(string){return this.parser(string)!==null};ipaddr.IPv4.isValid=function(string){try{new this(this.parser(string));return true}catch(e){return false}};ipaddr.IPv4.isValidFourPartDecimal=function(string){if(ipaddr.IPv4.isValid(string)&&string.match(/^(0|[1-9]\d*)(\.(0|[1-9]\d*)){3}$/)){return true}else{return false}};ipaddr.IPv4.networkAddressFromCIDR=function(string){let cidr,i,ipInterfaceOctets,octets,subnetMaskOctets;try{cidr=this.parseCIDR(string);ipInterfaceOctets=cidr[0].toByteArray();subnetMaskOctets=this.subnetMaskFromPrefixLength(cidr[1]).toByteArray();octets=[];i=0;while(i<4){octets.push(parseInt(ipInterfaceOctets[i],10)&parseInt(subnetMaskOctets[i],10));i++}return new this(octets)}catch(e){throw new Error("ipaddr: the address does not have IPv4 CIDR format")}};ipaddr.IPv4.parse=function(string){const parts=this.parser(string);if(parts===null){throw new Error("ipaddr: string is not formatted like an IPv4 Address")}return new this(parts)};ipaddr.IPv4.parseCIDR=function(string){let match;if(match=string.match(/^(.+)\/(\d+)$/)){const maskLength=parseInt(match[2]);if(maskLength>=0&&maskLength<=32){const parsed=[this.parse(match[1]),maskLength];Object.defineProperty(parsed,"toString",{value:function(){return this.join("/")}});return parsed}}throw new Error("ipaddr: string is not formatted like an IPv4 CIDR range")};ipaddr.IPv4.parser=function(string){let match,part,value;if(match=string.match(ipv4Regexes.fourOctet)){return function(){const ref=match.slice(1,6);const results=[];for(let i=0;i<ref.length;i++){part=ref[i];results.push(parseIntAuto(part))}return results}()}else if(match=string.match(ipv4Regexes.longValue)){value=parseIntAuto(match[1]);if(value>4294967295||value<0){throw new Error("ipaddr: address outside defined range")}return function(){const results=[];let shift;for(shift=0;shift<=24;shift+=8){results.push(value>>shift&255)}return results}().reverse()}else if(match=string.match(ipv4Regexes.twoOctet)){return function(){const ref=match.slice(1,4);const results=[];value=parseIntAuto(ref[1]);if(value>16777215||value<0){throw new Error("ipaddr: address outside defined range")}results.push(parseIntAuto(ref[0]));results.push(value>>16&255);results.push(value>>8&255);results.push(value&255);return results}()}else if(match=string.match(ipv4Regexes.threeOctet)){return function(){const ref=match.slice(1,5);const results=[];value=parseIntAuto(ref[2]);if(value>65535||value<0){throw new Error("ipaddr: address outside defined range")}results.push(parseIntAuto(ref[0]));results.push(parseIntAuto(ref[1]));results.push(value>>8&255);results.push(value&255);return results}()}else{return null}};ipaddr.IPv4.subnetMaskFromPrefixLength=function(prefix){prefix=parseInt(prefix);if(prefix<0||prefix>32){throw new Error("ipaddr: invalid IPv4 prefix length")}const octets=[0,0,0,0];let j=0;const filledOctetCount=Math.floor(prefix/8);while(j<filledOctetCount){octets[j]=255;j++}if(filledOctetCount<4){octets[filledOctetCount]=Math.pow(2,prefix%8)-1<<8-prefix%8}return new this(octets)};ipaddr.IPv6=function(){function IPv6(parts,zoneId){let i,part;if(parts.length===16){this.parts=[];for(i=0;i<=14;i+=2){this.parts.push(parts[i]<<8|parts[i+1])}}else if(parts.length===8){this.parts=parts}else{throw new Error("ipaddr: ipv6 part count should be 8 or 16")}for(i=0;i<this.parts.length;i++){part=this.parts[i];if(!(0<=part&&part<=65535)){throw new Error("ipaddr: ipv6 part should fit in 16 bits")}}if(zoneId){this.zoneId=zoneId}}IPv6.prototype.SpecialRanges={unspecified:[new IPv6([0,0,0,0,0,0,0,0]),128],linkLocal:[new IPv6([65152,0,0,0,0,0,0,0]),10],multicast:[new IPv6([65280,0,0,0,0,0,0,0]),8],loopback:[new IPv6([0,0,0,0,0,0,0,1]),128],uniqueLocal:[new IPv6([64512,0,0,0,0,0,0,0]),7],ipv4Mapped:[new IPv6([0,0,0,0,0,65535,0,0]),96],rfc6145:[new IPv6([0,0,0,0,65535,0,0,0]),96],rfc6052:[new IPv6([100,65435,0,0,0,0,0,0]),96],"6to4":[new IPv6([8194,0,0,0,0,0,0,0]),16],teredo:[new IPv6([8193,0,0,0,0,0,0,0]),32],reserved:[[new IPv6([8193,3512,0,0,0,0,0,0]),32]]};IPv6.prototype.isIPv4MappedAddress=function(){return this.range()==="ipv4Mapped"};IPv6.prototype.kind=function(){return"ipv6"};IPv6.prototype.match=function(other,cidrRange){let ref;if(cidrRange===undefined){ref=other;other=ref[0];cidrRange=ref[1]}if(other.kind()!=="ipv6"){throw new Error("ipaddr: cannot match ipv6 address with non-ipv6 one")}return matchCIDR(this.parts,other.parts,16,cidrRange)};IPv6.prototype.prefixLengthFromSubnetMask=function(){let cidr=0;let stop=false;const zerotable={0:16,32768:15,49152:14,57344:13,61440:12,63488:11,64512:10,65024:9,65280:8,65408:7,65472:6,65504:5,65520:4,65528:3,65532:2,65534:1,65535:0};let part,zeros;for(let i=7;i>=0;i-=1){part=this.parts[i];if(part in zerotable){zeros=zerotable[part];if(stop&&zeros!==0){return null}if(zeros!==16){stop=true}cidr+=zeros}else{return null}}return 128-cidr};IPv6.prototype.range=function(){return ipaddr.subnetMatch(this,this.SpecialRanges)};IPv6.prototype.toByteArray=function(){let part;const bytes=[];const ref=this.parts;for(let i=0;i<ref.length;i++){part=ref[i];bytes.push(part>>8);bytes.push(part&255)}return bytes};IPv6.prototype.toFixedLengthString=function(){const addr=function(){const results=[];for(let i=0;i<this.parts.length;i++){results.push(padPart(this.parts[i].toString(16),4))}return results}.call(this).join(":");let suffix="";if(this.zoneId){suffix=`%${this.zoneId}`}return addr+suffix};IPv6.prototype.toIPv4Address=function(){if(!this.isIPv4MappedAddress()){throw new Error("ipaddr: trying to convert a generic ipv6 address to ipv4")}const ref=this.parts.slice(-2);const high=ref[0];const low=ref[1];return new ipaddr.IPv4([high>>8,high&255,low>>8,low&255])};IPv6.prototype.toNormalizedString=function(){const addr=function(){const results=[];for(let i=0;i<this.parts.length;i++){results.push(this.parts[i].toString(16))}return results}.call(this).join(":");let suffix="";if(this.zoneId){suffix=`%${this.zoneId}`}return addr+suffix};IPv6.prototype.toRFC5952String=function(){const regex=/((^|:)(0(:|$)){2,})/g;const string=this.toNormalizedString();let bestMatchIndex=0;let bestMatchLength=-1;let match;while(match=regex.exec(string)){if(match[0].length>bestMatchLength){bestMatchIndex=match.index;bestMatchLength=match[0].length}}if(bestMatchLength<0){return string}return`${string.substring(0,bestMatchIndex)}::${string.substring(bestMatchIndex+bestMatchLength)}`};IPv6.prototype.toString=function(){return this.toNormalizedString().replace(/((^|:)(0(:|$))+)/,"::")};return IPv6}();ipaddr.IPv6.isIPv6=function(string){return this.parser(string)!==null};ipaddr.IPv6.isValid=function(string){if(typeof string==="string"&&string.indexOf(":")===-1){return false}try{const addr=this.parser(string);new this(addr.parts,addr.zoneId);return true}catch(e){return false}};ipaddr.IPv6.parse=function(string){const addr=this.parser(string);if(addr.parts===null){throw new Error("ipaddr: string is not formatted like an IPv6 Address")}return new this(addr.parts,addr.zoneId)};ipaddr.IPv6.parseCIDR=function(string){let maskLength,match,parsed;if(match=string.match(/^(.+)\/(\d+)$/)){maskLength=parseInt(match[2]);if(maskLength>=0&&maskLength<=128){parsed=[this.parse(match[1]),maskLength];Object.defineProperty(parsed,"toString",{value:function(){return this.join("/")}});return parsed}}throw new Error("ipaddr: string is not formatted like an IPv6 CIDR range")};ipaddr.IPv6.parser=function(string){let addr,i,match,octet,octets,zoneId;if(match=string.match(ipv6Regexes.deprecatedTransitional)){return this.parser(`::ffff:${match[1]}`)}if(ipv6Regexes.native.test(string)){return expandIPv6(string,8)}if(match=string.match(ipv6Regexes.transitional)){zoneId=match[6]||"";addr=expandIPv6(match[1].slice(0,-1)+zoneId,6);if(addr.parts){octets=[parseInt(match[2]),parseInt(match[3]),parseInt(match[4]),parseInt(match[5])];for(i=0;i<octets.length;i++){octet=octets[i];if(!(0<=octet&&octet<=255)){return null}}addr.parts.push(octets[0]<<8|octets[1]);addr.parts.push(octets[2]<<8|octets[3]);return{parts:addr.parts,zoneId:addr.zoneId}}}return null};ipaddr.fromByteArray=function(bytes){const length=bytes.length;if(length===4){return new ipaddr.IPv4(bytes)}else if(length===16){return new ipaddr.IPv6(bytes)}else{throw new Error("ipaddr: the binary input is neither an IPv6 nor IPv4 address")}};ipaddr.isValid=function(string){return ipaddr.IPv6.isValid(string)||ipaddr.IPv4.isValid(string)};ipaddr.parse=function(string){if(ipaddr.IPv6.isValid(string)){return ipaddr.IPv6.parse(string)}else if(ipaddr.IPv4.isValid(string)){return ipaddr.IPv4.parse(string)}else{throw new Error("ipaddr: the address has neither IPv6 nor IPv4 format")}};ipaddr.parseCIDR=function(string){try{return ipaddr.IPv6.parseCIDR(string)}catch(e){try{return ipaddr.IPv4.parseCIDR(string)}catch(e2){throw new Error("ipaddr: the address has neither IPv6 nor IPv4 CIDR format")}}};ipaddr.process=function(string){const addr=this.parse(string);if(addr.kind()==="ipv6"&&addr.isIPv4MappedAddress()){return addr.toIPv4Address()}else{return addr}};ipaddr.subnetMatch=function(address,rangeList,defaultName){let i,rangeName,rangeSubnets,subnet;if(defaultName===undefined||defaultName===null){defaultName="unicast"}for(rangeName in rangeList){if(Object.prototype.hasOwnProperty.call(rangeList,rangeName)){rangeSubnets=rangeList[rangeName];if(rangeSubnets[0]&&!(rangeSubnets[0]instanceof Array)){rangeSubnets=[rangeSubnets]}for(i=0;i<rangeSubnets.length;i++){subnet=rangeSubnets[i];if(address.kind()===subnet[0].kind()&&address.match.apply(address,subnet)){return rangeName}}}}return defaultName};if(true&&module.exports){module.exports=ipaddr}else{root.ipaddr=ipaddr}})(this)},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(56);case"v7light":return __webpack_require__(58);case"v8dark":return __webpack_require__(60);case"v8light":return __webpack_require__(62)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(57);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataTableContainer {\n  height: 100%; }\n\n.lnsTableCell {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important; }\n\n.lnsTableCell--left {\n  text-align: left; }\n\n.lnsTableCell--right {\n  text-align: right; }\n\n.lnsTableCell--center {\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(59);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataTableContainer {\n  height: 100%; }\n\n.lnsTableCell {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important; }\n\n.lnsTableCell--left {\n  text-align: left; }\n\n.lnsTableCell--right {\n  text-align: right; }\n\n.lnsTableCell--center {\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(61);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataTableContainer {\n  height: 100%; }\n\n.lnsTableCell {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important; }\n\n.lnsTableCell--left {\n  text-align: left; }\n\n.lnsTableCell--right {\n  text-align: right; }\n\n.lnsTableCell--center {\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(63);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataTableContainer {\n  height: 100%; }\n\n.lnsTableCell {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important; }\n\n.lnsTableCell--left {\n  text-align: left; }\n\n.lnsTableCell--right {\n  text-align: right; }\n\n.lnsTableCell--center {\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(65);case"v7light":return __webpack_require__(67);case"v8dark":return __webpack_require__(69);case"v8light":return __webpack_require__(71)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(66);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsVisualizationContainer {\n  scrollbar-width: thin;\n  overflow: auto; }\n  .lnsVisualizationContainer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsVisualizationContainer::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsVisualizationContainer::-webkit-scrollbar-corner, .lnsVisualizationContainer::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsExpressionRenderer {\n  scrollbar-width: thin;\n  position: relative;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  overflow: auto; }\n  .lnsExpressionRenderer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsExpressionRenderer::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsExpressionRenderer::-webkit-scrollbar-corner, .lnsExpressionRenderer::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsExpressionRenderer .lnsExpressionRenderer__component {\n    position: static; }\n\n.lnsEmbeddedError {\n  flex-grow: 1;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  overflow: auto; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(68);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsVisualizationContainer {\n  scrollbar-width: thin;\n  overflow: auto; }\n  .lnsVisualizationContainer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsVisualizationContainer::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsVisualizationContainer::-webkit-scrollbar-corner, .lnsVisualizationContainer::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsExpressionRenderer {\n  scrollbar-width: thin;\n  position: relative;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  overflow: auto; }\n  .lnsExpressionRenderer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsExpressionRenderer::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsExpressionRenderer::-webkit-scrollbar-corner, .lnsExpressionRenderer::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsExpressionRenderer .lnsExpressionRenderer__component {\n    position: static; }\n\n.lnsEmbeddedError {\n  flex-grow: 1;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  overflow: auto; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(70);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsVisualizationContainer {\n  scrollbar-width: thin;\n  overflow: auto; }\n  .lnsVisualizationContainer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsVisualizationContainer::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsVisualizationContainer::-webkit-scrollbar-corner, .lnsVisualizationContainer::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsExpressionRenderer {\n  scrollbar-width: thin;\n  position: relative;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  overflow: auto; }\n  .lnsExpressionRenderer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsExpressionRenderer::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsExpressionRenderer::-webkit-scrollbar-corner, .lnsExpressionRenderer::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsExpressionRenderer .lnsExpressionRenderer__component {\n    position: static; }\n\n.lnsEmbeddedError {\n  flex-grow: 1;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  overflow: auto; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(72);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsVisualizationContainer {\n  scrollbar-width: thin;\n  overflow: auto; }\n  .lnsVisualizationContainer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsVisualizationContainer::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsVisualizationContainer::-webkit-scrollbar-corner, .lnsVisualizationContainer::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsExpressionRenderer {\n  scrollbar-width: thin;\n  position: relative;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  overflow: auto; }\n  .lnsExpressionRenderer::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsExpressionRenderer::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsExpressionRenderer::-webkit-scrollbar-corner, .lnsExpressionRenderer::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsExpressionRenderer .lnsExpressionRenderer__component {\n    position: static; }\n\n.lnsEmbeddedError {\n  flex-grow: 1;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  overflow: auto; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(24);var util_1=__webpack_require__(74);var useCustomCompareEffect_1=tslib_1.__importDefault(__webpack_require__(42));var isPrimitive=function(val){return val!==Object(val)};var useDeepCompareEffect=function(effect,deps){if(false){}useCustomCompareEffect_1.default(effect,deps,util_1.isDeepEqual)};exports.default=useDeepCompareEffect},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isDeepEqual=exports.off=exports.on=exports.isClient=void 0;var tslib_1=__webpack_require__(24);var react_1=tslib_1.__importDefault(__webpack_require__(75));exports.isClient=typeof window==="object";exports.on=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.addEventListener.apply(obj,args)};exports.off=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.removeEventListener.apply(obj,args)};exports.isDeepEqual=react_1.default},function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(key==="_owner"&&a.$$typeof){continue}if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(77);case"v7light":return __webpack_require__(79);case"v8dark":return __webpack_require__(81);case"v8light":return __webpack_require__(83)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(78);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsMetricExpression__container {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(80);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsMetricExpression__container {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(82);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsMetricExpression__container {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(84);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsMetricExpression__container {\n  display: flex;\n  flex-direction: column;\n  justify-content: center;\n  align-items: center;\n  width: 100%;\n  height: 100%;\n  text-align: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(86);case"v7light":return __webpack_require__(88);case"v8dark":return __webpack_require__(90);case"v8light":return __webpack_require__(92)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(87);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(89);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(91);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(93);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(95);case"v7light":return __webpack_require__(97);case"v8dark":return __webpack_require__(99);case"v8light":return __webpack_require__(101)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(96);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieToolbar__popover {\n  width: 400px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(98);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieToolbar__popover {\n  width: 400px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(100);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieToolbar__popover {\n  width: 400px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(102);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsPieToolbar__popover {\n  width: 400px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(3);function useTimeoutFn(fn,ms){if(ms===void 0){ms=0}var ready=react_1.useRef(false);var timeout=react_1.useRef();var callback=react_1.useRef(fn);var isReady=react_1.useCallback((function(){return ready.current}),[]);var set=react_1.useCallback((function(){ready.current=false;timeout.current&&clearTimeout(timeout.current);timeout.current=setTimeout((function(){ready.current=true;callback.current()}),ms)}),[ms]);var clear=react_1.useCallback((function(){ready.current=null;timeout.current&&clearTimeout(timeout.current)}),[]);react_1.useEffect((function(){callback.current=fn}),[fn]);react_1.useEffect((function(){set();return clear}),[ms]);return[isReady,clear,set]}exports.default=useTimeoutFn},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(105);case"v7light":return __webpack_require__(107);case"v8dark":return __webpack_require__(109);case"v8light":return __webpack_require__(111)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(106);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n\n.lnsChart__empty {\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(108);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n\n.lnsChart__empty {\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(110);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n\n.lnsChart__empty {\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(112);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyExpression__container {\n  height: 100%;\n  width: 100%;\n  overflow-x: hidden; }\n\n.lnsChart__empty {\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(114);case"v7light":return __webpack_require__(116);case"v8dark":return __webpack_require__(118);case"v8light":return __webpack_require__(120)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(115);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyToolbar__popover {\n  width: 365px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(117);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyToolbar__popover {\n  width: 365px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(119);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyToolbar__popover {\n  width: 365px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(121);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsXyToolbar__popover {\n  width: 365px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var rng=__webpack_require__(123);var bytesToUuid=__webpack_require__(124);function v4(options,buf,offset){var i=buf&&offset||0;if(typeof options=="string"){buf=options==="binary"?new Array(16):null;options=null}options=options||{};var rnds=options.random||(options.rng||rng)();rnds[6]=rnds[6]&15|64;rnds[8]=rnds[8]&63|128;if(buf){for(var ii=0;ii<16;++ii){buf[i+ii]=rnds[ii]}}return buf||bytesToUuid(rnds)}module.exports=v4},function(module,exports){var getRandomValues=typeof crypto!="undefined"&&crypto.getRandomValues&&crypto.getRandomValues.bind(crypto)||typeof msCrypto!="undefined"&&typeof window.msCrypto.getRandomValues=="function"&&msCrypto.getRandomValues.bind(msCrypto);if(getRandomValues){var rnds8=new Uint8Array(16);module.exports=function whatwgRNG(){getRandomValues(rnds8);return rnds8}}else{var rnds=new Array(16);module.exports=function mathRNG(){for(var i=0,r;i<16;i++){if((i&3)===0)r=Math.random()*4294967296;rnds[i]=r>>>((i&3)<<3)&255}return rnds}}},function(module,exports){var byteToHex=[];for(var i=0;i<256;++i){byteToHex[i]=(i+256).toString(16).substr(1)}function bytesToUuid(buf,offset){var i=offset||0;var bth=byteToHex;return[bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],"-",bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]],bth[buf[i++]]].join("")}module.exports=bytesToUuid},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(126);case"v7light":return __webpack_require__(128);case"v8dark":return __webpack_require__(130);case"v8light":return __webpack_require__(132)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(127);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFiltersOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 0.875rem;\n  line-height: 1.5;\n  min-height: 32px;\n  width: 100%; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(129);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFiltersOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 0.875rem;\n  line-height: 1.5;\n  min-height: 32px;\n  width: 100%; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(131);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFiltersOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 1rem;\n  line-height: 1.71429rem;\n  min-height: 32px;\n  width: 100%; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(133);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFiltersOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 1rem;\n  line-height: 1.71429rem;\n  min-height: 32px;\n  width: 100%; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(135);case"v7light":return __webpack_require__(137);case"v8dark":return __webpack_require__(139);case"v8light":return __webpack_require__(141)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(136);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor__filtersEditor {\n  width: 960px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(138);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor__filtersEditor {\n  width: 960px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(140);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor__filtersEditor {\n  width: 960px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(142);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor__filtersEditor {\n  width: 960px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(144);case"v7light":return __webpack_require__(146);case"v8dark":return __webpack_require__(148);case"v8light":return __webpack_require__(150)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(145);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsHelpPopover__panel {\n  max-width: 480px; }\n\n.lnsHelpPopover__content {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 40vh;\n  padding: 12px; }\n  .lnsHelpPopover__content::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsHelpPopover__content::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsHelpPopover__content::-webkit-scrollbar-corner, .lnsHelpPopover__content::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsHelpPopover__buttonIcon {\n  margin-right: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(147);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsHelpPopover__panel {\n  max-width: 480px; }\n\n.lnsHelpPopover__content {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 40vh;\n  padding: 12px; }\n  .lnsHelpPopover__content::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsHelpPopover__content::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsHelpPopover__content::-webkit-scrollbar-corner, .lnsHelpPopover__content::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsHelpPopover__buttonIcon {\n  margin-right: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(149);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsHelpPopover__panel {\n  max-width: 480px; }\n\n.lnsHelpPopover__content {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 40vh;\n  padding: 12px; }\n  .lnsHelpPopover__content::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsHelpPopover__content::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsHelpPopover__content::-webkit-scrollbar-corner, .lnsHelpPopover__content::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsHelpPopover__buttonIcon {\n  margin-right: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(151);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsHelpPopover__panel {\n  max-width: 480px; }\n\n.lnsHelpPopover__content {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  max-height: 40vh;\n  padding: 12px; }\n  .lnsHelpPopover__content::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsHelpPopover__content::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsHelpPopover__content::-webkit-scrollbar-corner, .lnsHelpPopover__content::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsHelpPopover__buttonIcon {\n  margin-right: 4px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(153);case"v7light":return __webpack_require__(155);case"v8dark":return __webpack_require__(157);case"v8light":return __webpack_require__(159)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(154);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsRangesOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 0.875rem;\n  line-height: 1.5;\n  min-height: 32px;\n  width: 100%; }\n\n.lnsRangesOperation__popoverNumberField {\n  width: 14ch; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(156);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsRangesOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 0.875rem;\n  line-height: 1.5;\n  min-height: 32px;\n  width: 100%; }\n\n.lnsRangesOperation__popoverNumberField {\n  width: 14ch; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(158);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsRangesOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 1rem;\n  line-height: 1.71429rem;\n  min-height: 32px;\n  width: 100%; }\n\n.lnsRangesOperation__popoverNumberField {\n  width: 14ch; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(160);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsRangesOperation__popoverButton {\n  overflow-wrap: break-word !important;\n  word-wrap: break-word !important;\n  word-break: break-word;\n  font-size: 14px;\n  font-size: 1rem;\n  line-height: 1.71429rem;\n  min-height: 32px;\n  width: 100%; }\n\n.lnsRangesOperation__popoverNumberField {\n  width: 14ch; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(162);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor {\n  height: 100%; }\n\n.lnsIndexPatternDimensionEditor__section {\n  padding: 8px; }\n\n.lnsIndexPatternDimensionEditor__section--shaded {\n  background-color: #25262E; }\n\n.lnsIndexPatternDimensionEditor__columns {\n  column-count: 2;\n  column-gap: 32px; }\n\n.lnsIndexPatternDimensionEditor__operation {\n  display: block; }\n\n.lnsIndexPatternDimensionEditor__operation .euiListGroupItem__label {\n  width: 100%; }\n\n.lnsIndexPatternDimensionEditor__operation > button {\n  padding-top: 0;\n  padding-bottom: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(164);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor {\n  height: 100%; }\n\n.lnsIndexPatternDimensionEditor__section {\n  padding: 8px; }\n\n.lnsIndexPatternDimensionEditor__section--shaded {\n  background-color: #F5F7FA; }\n\n.lnsIndexPatternDimensionEditor__columns {\n  column-count: 2;\n  column-gap: 32px; }\n\n.lnsIndexPatternDimensionEditor__operation {\n  display: block; }\n\n.lnsIndexPatternDimensionEditor__operation .euiListGroupItem__label {\n  width: 100%; }\n\n.lnsIndexPatternDimensionEditor__operation > button {\n  padding-top: 0;\n  padding-bottom: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(166);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor {\n  height: 100%; }\n\n.lnsIndexPatternDimensionEditor__section {\n  padding: 8px; }\n\n.lnsIndexPatternDimensionEditor__section--shaded {\n  background-color: #25262E; }\n\n.lnsIndexPatternDimensionEditor__columns {\n  column-count: 2;\n  column-gap: 32px; }\n\n.lnsIndexPatternDimensionEditor__operation {\n  display: block; }\n\n.lnsIndexPatternDimensionEditor__operation .euiListGroupItem__label {\n  width: 100%; }\n\n.lnsIndexPatternDimensionEditor__operation > button {\n  padding-top: 0;\n  padding-bottom: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(168);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsIndexPatternDimensionEditor {\n  height: 100%; }\n\n.lnsIndexPatternDimensionEditor__section {\n  padding: 8px; }\n\n.lnsIndexPatternDimensionEditor__section--shaded {\n  background-color: #F5F7FA; }\n\n.lnsIndexPatternDimensionEditor__columns {\n  column-count: 2;\n  column-gap: 32px; }\n\n.lnsIndexPatternDimensionEditor__operation {\n  display: block; }\n\n.lnsIndexPatternDimensionEditor__operation .euiListGroupItem__label {\n  width: 100%; }\n\n.lnsIndexPatternDimensionEditor__operation > button {\n  padding-top: 0;\n  padding-bottom: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(170);case"v7light":return __webpack_require__(172);case"v8dark":return __webpack_require__(174);case"v8light":return __webpack_require__(176)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(171);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnFieldSelect__option--incompatible {\n  color: #343741; }\n\n.lnFieldSelect__option--nonExistant {\n  background-color: #25262E; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(173);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnFieldSelect__option--incompatible {\n  color: #D3DAE6; }\n\n.lnFieldSelect__option--nonExistant {\n  background-color: #F5F7FA; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(175);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnFieldSelect__option--incompatible {\n  color: #343741; }\n\n.lnFieldSelect__option--nonExistant {\n  background-color: #25262E; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(177);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnFieldSelect__option--incompatible {\n  color: #D3DAE6; }\n\n.lnFieldSelect__option--nonExistant {\n  background-color: #F5F7FA; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(179);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsInnerIndexPatternDataPanel {\n  width: 100%;\n  height: 100%;\n  padding: 16px 16px 0; }\n\n.lnsInnerIndexPatternDataPanel__header {\n  display: flex;\n  align-items: center;\n  margin-bottom: 8px; }\n\n.lnsInnerIndexPatternDataPanel__titleTooltip {\n  margin-right: 4px; }\n\n.lnsInnerIndexPatternDataPanel__fieldItems {\n  padding: 4px; }\n\n.lnsInnerIndexPatternDataPanel__textField {\n  padding-right: 40px;\n  padding-left: 40px; }\n\n.lnsInnerIndexPatternDataPanel__filterType {\n  font-size: 14px;\n  padding: 8px;\n  border-bottom: 1px solid #25262E; }\n\n.lnsInnerIndexPatternDataPanel__filterTypeInner {\n  display: flex;\n  align-items: center; }\n  .lnsInnerIndexPatternDataPanel__filterTypeInner .lnsFieldListPanel__fieldIcon {\n    margin-right: 8px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(181);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsInnerIndexPatternDataPanel {\n  width: 100%;\n  height: 100%;\n  padding: 16px 16px 0; }\n\n.lnsInnerIndexPatternDataPanel__header {\n  display: flex;\n  align-items: center;\n  margin-bottom: 8px; }\n\n.lnsInnerIndexPatternDataPanel__titleTooltip {\n  margin-right: 4px; }\n\n.lnsInnerIndexPatternDataPanel__fieldItems {\n  padding: 4px; }\n\n.lnsInnerIndexPatternDataPanel__textField {\n  padding-right: 40px;\n  padding-left: 40px; }\n\n.lnsInnerIndexPatternDataPanel__filterType {\n  font-size: 14px;\n  padding: 8px;\n  border-bottom: 1px solid #F5F7FA; }\n\n.lnsInnerIndexPatternDataPanel__filterTypeInner {\n  display: flex;\n  align-items: center; }\n  .lnsInnerIndexPatternDataPanel__filterTypeInner .lnsFieldListPanel__fieldIcon {\n    margin-right: 8px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(183);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsInnerIndexPatternDataPanel {\n  width: 100%;\n  height: 100%;\n  padding: 16px 16px 0; }\n\n.lnsInnerIndexPatternDataPanel__header {\n  display: flex;\n  align-items: center;\n  margin-bottom: 8px; }\n\n.lnsInnerIndexPatternDataPanel__titleTooltip {\n  margin-right: 4px; }\n\n.lnsInnerIndexPatternDataPanel__fieldItems {\n  padding: 4px; }\n\n.lnsInnerIndexPatternDataPanel__textField {\n  padding-right: 40px;\n  padding-left: 40px; }\n\n.lnsInnerIndexPatternDataPanel__filterType {\n  font-size: 14px;\n  padding: 8px;\n  border-bottom: 1px solid #25262E; }\n\n.lnsInnerIndexPatternDataPanel__filterTypeInner {\n  display: flex;\n  align-items: center; }\n  .lnsInnerIndexPatternDataPanel__filterTypeInner .lnsFieldListPanel__fieldIcon {\n    margin-right: 8px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(185);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsInnerIndexPatternDataPanel {\n  width: 100%;\n  height: 100%;\n  padding: 16px 16px 0; }\n\n.lnsInnerIndexPatternDataPanel__header {\n  display: flex;\n  align-items: center;\n  margin-bottom: 8px; }\n\n.lnsInnerIndexPatternDataPanel__titleTooltip {\n  margin-right: 4px; }\n\n.lnsInnerIndexPatternDataPanel__fieldItems {\n  padding: 4px; }\n\n.lnsInnerIndexPatternDataPanel__textField {\n  padding-right: 40px;\n  padding-left: 40px; }\n\n.lnsInnerIndexPatternDataPanel__filterType {\n  font-size: 14px;\n  padding: 8px;\n  border-bottom: 1px solid #F5F7FA; }\n\n.lnsInnerIndexPatternDataPanel__filterTypeInner {\n  display: flex;\n  align-items: center; }\n  .lnsInnerIndexPatternDataPanel__filterTypeInner .lnsFieldListPanel__fieldIcon {\n    margin-right: 8px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(187);case"v7light":return __webpack_require__(189);case"v8dark":return __webpack_require__(191);case"v8light":return __webpack_require__(193)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(188);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDragDrop {\n  -webkit-user-select: none;\n          user-select: none;\n  transition: background-color 150ms ease-in-out, border-color 150ms ease-in-out; }\n\n.lnsDragDrop_ghost {\n  box-shadow: 0 2px 2px -1px rgba(0, 0, 0, 0.3);\n  background: #25262E;\n  border: 1px dashed transparent;\n  cursor: grab;\n  border: 1px dashed #343741;\n  position: absolute !important;\n  margin: 0 !important;\n  bottom: 100%;\n  width: 100%;\n  left: 0;\n  opacity: .9;\n  transform: translate(-12px, 8px);\n  z-index: 2000;\n  pointer-events: none;\n  box-shadow: 0 0 0 3px rgba(27, 169, 245, 0.3); }\n\n.lnsDragDrop-isDraggable {\n  box-shadow: 0 2px 2px -1px rgba(0, 0, 0, 0.3);\n  background: #25262E;\n  border: 1px dashed transparent;\n  cursor: grab; }\n  .lnsDragDrop-isDraggable:hover {\n    border: 1px dashed #535966; }\n  .lnsDragDrop-isDraggable > .kbnFieldButton__button {\n    cursor: grab; }\n  .lnsDragDrop-isDraggable:focus {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important; }\n\n.lnsDragDrop-isDroppable {\n  border: 1px dashed #343741; }\n\n.lnsDragDrop-isDropTarget {\n  border: 1px dashed #343741;\n  background-color: rgba(84, 179, 153, 0.1); }\n  .lnsDragDrop-isDropTarget > * {\n    pointer-events: none; }\n\n.lnsDragDrop-isActiveGroup {\n  background-color: rgba(84, 179, 153, 0.25); }\n\n.lnsDragDrop-isActiveDropTarget {\n  background-color: rgba(84, 179, 153, 0.25);\n  border: 1px dashed #54B399; }\n\n.lnsDragDrop-isNotDroppable {\n  opacity: .5; }\n\n.lnsDragDrop-isReplacing,\n.lnsDragDrop-isReplacing .lnsLayerPanel__triggerText {\n  text-decoration: line-through; }\n\n.lnsDragDrop-notCompatible {\n  background-color: #2E2D25;\n  border: 1px dashed #343741; }\n  .lnsDragDrop-notCompatible.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(251, 208, 17, 0.25);\n    border-color: #D6BF57; }\n\n.lnsDragDrop__reorderableDrop {\n  position: absolute;\n  width: 100%;\n  top: 0;\n  height: calc(100% + 8px); }\n\n.lnsDragDrop-translatableDrop {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  pointer-events: none; }\n\n.lnsDragDrop-translatableDrag {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  position: relative;\n  z-index: 1000; }\n\n.lnsDragDrop__keyboardHandler {\n  top: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  border-radius: 4px; }\n  .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop__keyboardHandler:focus-within {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important;\n    pointer-events: none; }\n\n.lnsDragDrop-isHidden {\n  opacity: 0; }\n\n.lnsDragDrop-isHidden-noFocus {\n  opacity: 0; }\n  .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus-within {\n    animation: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(190);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDragDrop {\n  -webkit-user-select: none;\n          user-select: none;\n  transition: background-color 150ms ease-in-out, border-color 150ms ease-in-out; }\n\n.lnsDragDrop_ghost {\n  box-shadow: 0 2px 2px -1px rgba(152, 162, 179, 0.3);\n  background: #FFF;\n  border: 1px dashed transparent;\n  cursor: grab;\n  border: 1px dashed #D3DAE6;\n  position: absolute !important;\n  margin: 0 !important;\n  bottom: 100%;\n  width: 100%;\n  left: 0;\n  opacity: .9;\n  transform: translate(-12px, 8px);\n  z-index: 2000;\n  pointer-events: none;\n  box-shadow: 0 0 0 3px rgba(0, 107, 180, 0.3); }\n\n.lnsDragDrop-isDraggable {\n  box-shadow: 0 2px 2px -1px rgba(152, 162, 179, 0.3);\n  background: #FFF;\n  border: 1px dashed transparent;\n  cursor: grab; }\n  .lnsDragDrop-isDraggable:hover {\n    border: 1px dashed #98A2B3; }\n  .lnsDragDrop-isDraggable > .kbnFieldButton__button {\n    cursor: grab; }\n  .lnsDragDrop-isDraggable:focus {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important; }\n\n.lnsDragDrop-isDroppable {\n  border: 1px dashed #D3DAE6; }\n\n.lnsDragDrop-isDropTarget {\n  border: 1px dashed #D3DAE6;\n  background-color: rgba(84, 179, 153, 0.1); }\n  .lnsDragDrop-isDropTarget > * {\n    pointer-events: none; }\n\n.lnsDragDrop-isActiveGroup {\n  background-color: rgba(84, 179, 153, 0.25); }\n\n.lnsDragDrop-isActiveDropTarget {\n  background-color: rgba(84, 179, 153, 0.25);\n  border: 1px dashed #54B399; }\n\n.lnsDragDrop-isNotDroppable {\n  opacity: .5; }\n\n.lnsDragDrop-isReplacing,\n.lnsDragDrop-isReplacing .lnsLayerPanel__triggerText {\n  text-decoration: line-through; }\n\n.lnsDragDrop-notCompatible {\n  background-color: #FFFCDD;\n  border: 1px dashed #D3DAE6; }\n  .lnsDragDrop-notCompatible.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(251, 208, 17, 0.25);\n    border-color: #D6BF57; }\n\n.lnsDragDrop__reorderableDrop {\n  position: absolute;\n  width: 100%;\n  top: 0;\n  height: calc(100% + 8px); }\n\n.lnsDragDrop-translatableDrop {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  pointer-events: none; }\n\n.lnsDragDrop-translatableDrag {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  position: relative;\n  z-index: 1000; }\n\n.lnsDragDrop__keyboardHandler {\n  top: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  border-radius: 4px; }\n  .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop__keyboardHandler:focus-within {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important;\n    pointer-events: none; }\n\n.lnsDragDrop-isHidden {\n  opacity: 0; }\n\n.lnsDragDrop-isHidden-noFocus {\n  opacity: 0; }\n  .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus-within {\n    animation: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(192);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDragDrop {\n  -webkit-user-select: none;\n          user-select: none;\n  transition: background-color 150ms ease-in-out, border-color 150ms ease-in-out; }\n\n.lnsDragDrop_ghost {\n  box-shadow: 0 0.8px 0.8px rgba(0, 0, 0, 0.1), 0 2.3px 2px rgba(0, 0, 0, 0.075);\n  background: #25262E;\n  border: 1px dashed transparent;\n  cursor: grab;\n  border: 1px dashed #343741;\n  position: absolute !important;\n  margin: 0 !important;\n  bottom: 100%;\n  width: 100%;\n  left: 0;\n  opacity: .9;\n  transform: translate(-12px, 8px);\n  z-index: 2000;\n  pointer-events: none;\n  box-shadow: 0 0 0 2px #36A2EF; }\n\n.lnsDragDrop-isDraggable {\n  box-shadow: 0 0.8px 0.8px rgba(0, 0, 0, 0.1), 0 2.3px 2px rgba(0, 0, 0, 0.075);\n  background: #25262E;\n  border: 1px dashed transparent;\n  cursor: grab; }\n  .lnsDragDrop-isDraggable:hover {\n    border: 1px dashed #535966; }\n  .lnsDragDrop-isDraggable > .kbnFieldButton__button {\n    cursor: grab; }\n  .lnsDragDrop-isDraggable:focus {\n    outline: 2px solid currentColor; }\n    .lnsDragDrop-isDraggable:focus:focus-visible {\n      outline-style: auto; }\n    .lnsDragDrop-isDraggable:focus:not(:focus-visible) {\n      outline: none; }\n\n.lnsDragDrop-isDroppable {\n  border: 1px dashed #343741; }\n\n.lnsDragDrop-isDropTarget {\n  border: 1px dashed #343741;\n  background-color: rgba(84, 179, 153, 0.1); }\n  .lnsDragDrop-isDropTarget > * {\n    pointer-events: none; }\n\n.lnsDragDrop-isActiveGroup {\n  background-color: rgba(84, 179, 153, 0.25); }\n\n.lnsDragDrop-isActiveDropTarget {\n  background-color: rgba(84, 179, 153, 0.25);\n  border: 1px dashed #54B399; }\n\n.lnsDragDrop-isNotDroppable {\n  opacity: .5; }\n\n.lnsDragDrop-isReplacing,\n.lnsDragDrop-isReplacing .lnsLayerPanel__triggerText {\n  text-decoration: line-through; }\n\n.lnsDragDrop-notCompatible {\n  background-color: #2E2D25;\n  border: 1px dashed #343741; }\n  .lnsDragDrop-notCompatible.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(251, 208, 17, 0.25);\n    border-color: #D6BF57; }\n\n.lnsDragDrop__reorderableDrop {\n  position: absolute;\n  width: 100%;\n  top: 0;\n  height: calc(100% + 8px); }\n\n.lnsDragDrop-translatableDrop {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  pointer-events: none; }\n\n.lnsDragDrop-translatableDrag {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  position: relative;\n  z-index: 1000; }\n\n.lnsDragDrop__keyboardHandler {\n  top: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  border-radius: 6px; }\n  .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop__keyboardHandler:focus-within {\n    outline: 2px solid currentColor;\n    pointer-events: none; }\n    .lnsDragDrop__keyboardHandler:focus:focus-visible, .lnsDragDrop__keyboardHandler:focus-within:focus-visible {\n      outline-style: auto; }\n    .lnsDragDrop__keyboardHandler:focus:not(:focus-visible), .lnsDragDrop__keyboardHandler:focus-within:not(:focus-visible) {\n      outline: none; }\n\n.lnsDragDrop-isHidden {\n  opacity: 0; }\n\n.lnsDragDrop-isHidden-noFocus {\n  opacity: 0; }\n  .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus-within {\n    animation: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(194);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDragDrop {\n  -webkit-user-select: none;\n          user-select: none;\n  transition: background-color 150ms ease-in-out, border-color 150ms ease-in-out; }\n\n.lnsDragDrop_ghost {\n  box-shadow: 0 0.8px 0.8px rgba(0, 0, 0, 0.04), 0 2.3px 2px rgba(0, 0, 0, 0.03);\n  background: #FFF;\n  border: 1px dashed transparent;\n  cursor: grab;\n  border: 1px dashed #D3DAE6;\n  position: absolute !important;\n  margin: 0 !important;\n  bottom: 100%;\n  width: 100%;\n  left: 0;\n  opacity: .9;\n  transform: translate(-12px, 8px);\n  z-index: 2000;\n  pointer-events: none;\n  box-shadow: 0 0 0 2px #0071c2; }\n\n.lnsDragDrop-isDraggable {\n  box-shadow: 0 0.8px 0.8px rgba(0, 0, 0, 0.04), 0 2.3px 2px rgba(0, 0, 0, 0.03);\n  background: #FFF;\n  border: 1px dashed transparent;\n  cursor: grab; }\n  .lnsDragDrop-isDraggable:hover {\n    border: 1px dashed #98A2B3; }\n  .lnsDragDrop-isDraggable > .kbnFieldButton__button {\n    cursor: grab; }\n  .lnsDragDrop-isDraggable:focus {\n    outline: 2px solid currentColor; }\n    .lnsDragDrop-isDraggable:focus:focus-visible {\n      outline-style: auto; }\n    .lnsDragDrop-isDraggable:focus:not(:focus-visible) {\n      outline: none; }\n\n.lnsDragDrop-isDroppable {\n  border: 1px dashed #D3DAE6; }\n\n.lnsDragDrop-isDropTarget {\n  border: 1px dashed #D3DAE6;\n  background-color: rgba(84, 179, 153, 0.1); }\n  .lnsDragDrop-isDropTarget > * {\n    pointer-events: none; }\n\n.lnsDragDrop-isActiveGroup {\n  background-color: rgba(84, 179, 153, 0.25); }\n\n.lnsDragDrop-isActiveDropTarget {\n  background-color: rgba(84, 179, 153, 0.25);\n  border: 1px dashed #54B399; }\n\n.lnsDragDrop-isNotDroppable {\n  opacity: .5; }\n\n.lnsDragDrop-isReplacing,\n.lnsDragDrop-isReplacing .lnsLayerPanel__triggerText {\n  text-decoration: line-through; }\n\n.lnsDragDrop-notCompatible {\n  background-color: #fff9e8;\n  border: 1px dashed #D3DAE6; }\n  .lnsDragDrop-notCompatible.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(251, 208, 17, 0.25);\n    border-color: #D6BF57; }\n\n.lnsDragDrop__reorderableDrop {\n  position: absolute;\n  width: 100%;\n  top: 0;\n  height: calc(100% + 8px); }\n\n.lnsDragDrop-translatableDrop {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  pointer-events: none; }\n\n.lnsDragDrop-translatableDrag {\n  transform: translateY(0);\n  transition: transform 150ms ease-in-out;\n  position: relative;\n  z-index: 1000; }\n\n.lnsDragDrop__keyboardHandler {\n  top: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n  border-radius: 6px; }\n  .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop__keyboardHandler:focus-within {\n    outline: 2px solid currentColor;\n    pointer-events: none; }\n    .lnsDragDrop__keyboardHandler:focus:focus-visible, .lnsDragDrop__keyboardHandler:focus-within:focus-visible {\n      outline-style: auto; }\n    .lnsDragDrop__keyboardHandler:focus:not(:focus-visible), .lnsDragDrop__keyboardHandler:focus-within:not(:focus-visible) {\n      outline: none; }\n\n.lnsDragDrop-isHidden {\n  opacity: 0; }\n\n.lnsDragDrop-isHidden-noFocus {\n  opacity: 0; }\n  .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus, .lnsDragDrop-isHidden-noFocus .lnsDragDrop__keyboardHandler:focus-within {\n    animation: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(24);var fast_shallow_equal_1=__webpack_require__(196);var useCustomCompareEffect_1=tslib_1.__importDefault(__webpack_require__(42));var isPrimitive=function(val){return val!==Object(val)};var shallowEqualDepsList=function(prevDeps,nextDeps){return prevDeps.every((function(dep,index){return fast_shallow_equal_1.equal(dep,nextDeps[index])}))};var useShallowCompareEffect=function(effect,deps){if(false){}useCustomCompareEffect_1.default(effect,deps,shallowEqualDepsList)};exports.default=useShallowCompareEffect},function(module,exports){var keyList=Object.keys;exports.equal=function equal(a,b){if(a===b)return true;if(!(a instanceof Object)||!(b instanceof Object))return false;var keys=keyList(a);var length=keys.length;for(var i=0;i<length;i++)if(!(keys[i]in b))return false;for(var i=0;i<length;i++)if(a[keys[i]]!==b[keys[i]])return false;return length===keyList(b).length}},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(198);case"v7light":return __webpack_require__(200);case"v8dark":return __webpack_require__(202);case"v8light":return __webpack_require__(204)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(199);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/**\n * 1. Don't cut off the shadow of the field items\n */\n.lnsIndexPatternFieldList {\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  scrollbar-width: thin;\n  margin-left: -16px;\n  /* 1 */\n  position: relative;\n  flex-grow: 1;\n  overflow: auto; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-corner, .lnsIndexPatternFieldList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsIndexPatternFieldList__accordionContainer {\n  padding-top: 8px;\n  position: absolute;\n  top: 0;\n  left: 16px;\n  /* 1 */\n  right: 4px;\n  /* 1 */ }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(201);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/**\n * 1. Don't cut off the shadow of the field items\n */\n.lnsIndexPatternFieldList {\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  scrollbar-width: thin;\n  margin-left: -16px;\n  /* 1 */\n  position: relative;\n  flex-grow: 1;\n  overflow: auto; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-corner, .lnsIndexPatternFieldList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsIndexPatternFieldList__accordionContainer {\n  padding-top: 8px;\n  position: absolute;\n  top: 0;\n  left: 16px;\n  /* 1 */\n  right: 4px;\n  /* 1 */ }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(203);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/**\n * 1. Don't cut off the shadow of the field items\n */\n.lnsIndexPatternFieldList {\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  scrollbar-width: thin;\n  margin-left: -16px;\n  /* 1 */\n  position: relative;\n  flex-grow: 1;\n  overflow: auto; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-corner, .lnsIndexPatternFieldList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsIndexPatternFieldList__accordionContainer {\n  padding-top: 8px;\n  position: absolute;\n  top: 0;\n  left: 16px;\n  /* 1 */\n  right: 4px;\n  /* 1 */ }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(205);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/**\n * 1. Don't cut off the shadow of the field items\n */\n.lnsIndexPatternFieldList {\n  -webkit-mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n          mask-image: linear-gradient(to bottom, rgba(255, 0, 0, 0.1) 0%, red 7.5px, red calc(100% - 7.5px), rgba(255, 0, 0, 0.1) 100%);\n  scrollbar-width: thin;\n  margin-left: -16px;\n  /* 1 */\n  position: relative;\n  flex-grow: 1;\n  overflow: auto; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsIndexPatternFieldList::-webkit-scrollbar-corner, .lnsIndexPatternFieldList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsIndexPatternFieldList__accordionContainer {\n  padding-top: 8px;\n  position: absolute;\n  top: 0;\n  left: 16px;\n  /* 1 */\n  right: 4px;\n  /* 1 */ }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(207);case"v7light":return __webpack_require__(209);case"v8dark":return __webpack_require__(211);case"v8light":return __webpack_require__(213)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(208);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFieldItem {\n  width: 100%; }\n  .lnsFieldItem .lnsFieldItem__infoIcon {\n    visibility: hidden;\n    opacity: 0; }\n  .lnsFieldItem:hover:not([class*='isActive']) {\n    cursor: grab; }\n    .lnsFieldItem:hover:not([class*='isActive']) .lnsFieldItem__infoIcon {\n      visibility: visible;\n      opacity: 1;\n      transition: opacity 150ms ease-in-out 1s; }\n  .lnsFieldItem:focus, .lnsFieldItem:focus-within, .lnsFieldItem.kbnFieldButton-isActive {\n    animation: none !important; }\n  .lnsFieldItem:focus .kbnFieldButton__name span,\n  .lnsFieldItem:focus-within .kbnFieldButton__name span,\n  .lnsFieldItem.kbnFieldButton-isActive .kbnFieldButton__name span {\n    background-color: rgba(96, 146, 192, 0.1) !important;\n    text-decoration: underline !important; }\n\n.kbnFieldButton.lnsDragDrop_ghost .lnsFieldItem__infoIcon {\n  visibility: hidden;\n  opacity: 0; }\n\n.kbnFieldButton__name {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsFieldItem--missing {\n  background: #1D1E24;\n  color: #98A2B3; }\n\n.lnsFieldItem__topValue {\n  margin-bottom: 8px; }\n  .lnsFieldItem__topValue:last-of-type {\n    margin-bottom: 0; }\n\n.lnsFieldItem__topValueProgress {\n  background-color: #25262E; }\n  .lnsFieldItem__topValueProgress::-webkit-progress-bar {\n    background-color: #25262E; }\n\n.lnsFieldItem__fieldPanel {\n  min-width: 260px;\n  max-width: 300px; }\n\n.lnsFieldItem__fieldPanelTitle {\n  text-transform: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(210);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFieldItem {\n  width: 100%; }\n  .lnsFieldItem .lnsFieldItem__infoIcon {\n    visibility: hidden;\n    opacity: 0; }\n  .lnsFieldItem:hover:not([class*='isActive']) {\n    cursor: grab; }\n    .lnsFieldItem:hover:not([class*='isActive']) .lnsFieldItem__infoIcon {\n      visibility: visible;\n      opacity: 1;\n      transition: opacity 150ms ease-in-out 1s; }\n  .lnsFieldItem:focus, .lnsFieldItem:focus-within, .lnsFieldItem.kbnFieldButton-isActive {\n    animation: none !important; }\n  .lnsFieldItem:focus .kbnFieldButton__name span,\n  .lnsFieldItem:focus-within .kbnFieldButton__name span,\n  .lnsFieldItem.kbnFieldButton-isActive .kbnFieldButton__name span {\n    background-color: rgba(96, 146, 192, 0.1) !important;\n    text-decoration: underline !important; }\n\n.kbnFieldButton.lnsDragDrop_ghost .lnsFieldItem__infoIcon {\n  visibility: hidden;\n  opacity: 0; }\n\n.kbnFieldButton__name {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsFieldItem--missing {\n  background: rgba(152, 162, 179, 0.1);\n  color: #69707D; }\n\n.lnsFieldItem__topValue {\n  margin-bottom: 8px; }\n  .lnsFieldItem__topValue:last-of-type {\n    margin-bottom: 0; }\n\n.lnsFieldItem__topValueProgress {\n  background-color: #F5F7FA; }\n  .lnsFieldItem__topValueProgress::-webkit-progress-bar {\n    background-color: #F5F7FA; }\n\n.lnsFieldItem__fieldPanel {\n  min-width: 260px;\n  max-width: 300px; }\n\n.lnsFieldItem__fieldPanelTitle {\n  text-transform: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(212);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFieldItem {\n  width: 100%; }\n  .lnsFieldItem .lnsFieldItem__infoIcon {\n    visibility: hidden;\n    opacity: 0; }\n  .lnsFieldItem:hover:not([class*='isActive']) {\n    cursor: grab; }\n    .lnsFieldItem:hover:not([class*='isActive']) .lnsFieldItem__infoIcon {\n      visibility: visible;\n      opacity: 1;\n      transition: opacity 150ms ease-in-out 1s; }\n  .lnsFieldItem:focus, .lnsFieldItem:focus-within, .lnsFieldItem.kbnFieldButton-isActive {\n    animation: none !important; }\n  .lnsFieldItem:focus .kbnFieldButton__name span,\n  .lnsFieldItem:focus-within .kbnFieldButton__name span,\n  .lnsFieldItem.kbnFieldButton-isActive .kbnFieldButton__name span {\n    background-color: rgba(96, 146, 192, 0.1) !important;\n    text-decoration: underline !important; }\n\n.kbnFieldButton.lnsDragDrop_ghost .lnsFieldItem__infoIcon {\n  visibility: hidden;\n  opacity: 0; }\n\n.kbnFieldButton__name {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsFieldItem--missing {\n  background: #1D1E24;\n  color: #98A2B3; }\n\n.lnsFieldItem__topValue {\n  margin-bottom: 8px; }\n  .lnsFieldItem__topValue:last-of-type {\n    margin-bottom: 0; }\n\n.lnsFieldItem__topValueProgress {\n  background-color: #25262E; }\n  .lnsFieldItem__topValueProgress::-webkit-progress-bar {\n    background-color: #25262E; }\n\n.lnsFieldItem__fieldPanel {\n  min-width: 260px;\n  max-width: 300px; }\n\n.lnsFieldItem__fieldPanelTitle {\n  text-transform: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(214);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFieldItem {\n  width: 100%; }\n  .lnsFieldItem .lnsFieldItem__infoIcon {\n    visibility: hidden;\n    opacity: 0; }\n  .lnsFieldItem:hover:not([class*='isActive']) {\n    cursor: grab; }\n    .lnsFieldItem:hover:not([class*='isActive']) .lnsFieldItem__infoIcon {\n      visibility: visible;\n      opacity: 1;\n      transition: opacity 150ms ease-in-out 1s; }\n  .lnsFieldItem:focus, .lnsFieldItem:focus-within, .lnsFieldItem.kbnFieldButton-isActive {\n    animation: none !important; }\n  .lnsFieldItem:focus .kbnFieldButton__name span,\n  .lnsFieldItem:focus-within .kbnFieldButton__name span,\n  .lnsFieldItem.kbnFieldButton-isActive .kbnFieldButton__name span {\n    background-color: rgba(96, 146, 192, 0.1) !important;\n    text-decoration: underline !important; }\n\n.kbnFieldButton.lnsDragDrop_ghost .lnsFieldItem__infoIcon {\n  visibility: hidden;\n  opacity: 0; }\n\n.kbnFieldButton__name {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsFieldItem--missing {\n  background: rgba(152, 162, 179, 0.1);\n  color: #69707D; }\n\n.lnsFieldItem__topValue {\n  margin-bottom: 8px; }\n  .lnsFieldItem__topValue:last-of-type {\n    margin-bottom: 0; }\n\n.lnsFieldItem__topValueProgress {\n  background-color: #F5F7FA; }\n  .lnsFieldItem__topValueProgress::-webkit-progress-bar {\n    background-color: #F5F7FA; }\n\n.lnsFieldItem__fieldPanel {\n  min-width: 260px;\n  max-width: 300px; }\n\n.lnsFieldItem__fieldPanelTitle {\n  text-transform: none; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){const moment=__webpack_require__(25);const unitsMap={ms:{weight:1,type:"fixed",base:1},s:{weight:2,type:"fixed",base:1e3},m:{weight:3,type:"mixed",base:1e3*60},h:{weight:4,type:"mixed",base:1e3*60*60},d:{weight:5,type:"mixed",base:1e3*60*60*24},w:{weight:6,type:"calendar",base:NaN},M:{weight:7,type:"calendar",base:NaN},y:{weight:9,type:"calendar",base:NaN}};const units=Object.keys(unitsMap).sort((a,b)=>unitsMap[b].weight-unitsMap[a].weight);const unitsDesc=[...units];const unitsAsc=[...units].reverse();const isDate=d=>Object.prototype.toString.call(d)==="[object Date]";const isValidDate=d=>isDate(d)&&!isNaN(d.valueOf());function parse(text,{roundUp:roundUp=false,momentInstance:momentInstance=moment,forceNow:forceNow}={}){if(!text)return undefined;if(momentInstance.isMoment(text))return text;if(isDate(text))return momentInstance(text);if(forceNow!==undefined&&!isValidDate(forceNow)){throw new Error("forceNow must be a valid Date")}let time;let mathString="";let index;let parseString;if(text.substring(0,3)==="now"){time=momentInstance(forceNow);mathString=text.substring("now".length)}else{index=text.indexOf("||");if(index===-1){parseString=text;mathString=""}else{parseString=text.substring(0,index);mathString=text.substring(index+2)}time=momentInstance(parseString)}if(!mathString.length){return time}return parseDateMath(mathString,time,roundUp)}function parseDateMath(mathString,time,roundUp){const dateTime=time;const len=mathString.length;let i=0;while(i<len){const c=mathString.charAt(i++);let type;let num;let unit;if(c==="/"){type=0}else if(c==="+"){type=1}else if(c==="-"){type=2}else{return}if(isNaN(mathString.charAt(i))){num=1}else if(mathString.length===2){num=mathString.charAt(i)}else{const numFrom=i;while(!isNaN(mathString.charAt(i))){i++;if(i>=len)return}num=parseInt(mathString.substring(numFrom,i),10)}if(type===0){if(num!==1){return}}unit=mathString.charAt(i++);for(let j=i;j<len;j++){const unitChar=mathString.charAt(i);if(/[a-z]/i.test(unitChar)){unit+=unitChar;i++}else{break}}if(units.indexOf(unit)===-1){return}else{if(type===0){if(roundUp)dateTime.endOf(unit);else dateTime.startOf(unit)}else if(type===1){dateTime.add(num,unit)}else if(type===2){dateTime.subtract(num,unit)}}}return dateTime}module.exports={parse:parse,unitsMap:Object.freeze(unitsMap),units:Object.freeze(units),unitsAsc:Object.freeze(unitsAsc),unitsDesc:Object.freeze(unitsDesc)}},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(217);case"v7light":return __webpack_require__(219);case"v8dark":return __webpack_require__(221);case"v8light":return __webpack_require__(223)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(218);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataPanelWrapper {\n  flex: 1 0 100%;\n  overflow: hidden;\n  background-color: #000; }\n\n.lnsDataPanelWrapper__switchSource {\n  position: absolute;\n  right: 20px;\n  top: 20px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(220);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataPanelWrapper {\n  flex: 1 0 100%;\n  overflow: hidden;\n  background-color: #F5F7FA; }\n\n.lnsDataPanelWrapper__switchSource {\n  position: absolute;\n  right: 20px;\n  top: 20px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(222);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataPanelWrapper {\n  flex: 1 0 100%;\n  overflow: hidden;\n  background-color: #000; }\n\n.lnsDataPanelWrapper__switchSource {\n  position: absolute;\n  right: 20px;\n  top: 20px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(224);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDataPanelWrapper {\n  flex: 1 0 100%;\n  overflow: hidden;\n  background-color: #F5F7FA; }\n\n.lnsDataPanelWrapper__switchSource {\n  position: absolute;\n  right: 20px;\n  top: 20px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(226);case"v7light":return __webpack_require__(228);case"v8dark":return __webpack_require__(230);case"v8light":return __webpack_require__(232)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(227);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsConfigPanel__addLayerBtn {\n  color: rgba(83, 89, 102, 0.7);\n  box-shadow: none !important;\n  border-color: #343741; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(229);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsConfigPanel__addLayerBtn {\n  color: rgba(152, 162, 179, 0.7);\n  box-shadow: none !important;\n  border-color: #D3DAE6; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(231);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsConfigPanel__addLayerBtn {\n  color: rgba(83, 89, 102, 0.7);\n  box-shadow: none !important;\n  border-color: #343741; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(233);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsConfigPanel__addLayerBtn {\n  color: rgba(152, 162, 179, 0.7);\n  box-shadow: none !important;\n  border-color: #D3DAE6; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(235);case"v7light":return __webpack_require__(237);case"v8dark":return __webpack_require__(239);case"v8light":return __webpack_require__(241)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(236);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsLayerPanel {\n  margin-bottom: 8px; }\n  .lnsLayerPanel:focus:not(:focus-visible) {\n    animation: none !important; }\n\n.lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 58px); }\n\n.lnsLayerPanel__settingsFlexItem:empty + .lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 8px); }\n\n.lnsLayerPanel__settingsFlexItem:empty {\n  margin: 0; }\n\n.lnsLayerPanel__row {\n  background: #25262E;\n  padding: 8px 0;\n  border-radius: 4px; }\n  .lnsLayerPanel__row + .lnsLayerPanel__row {\n    margin-top: 16px; }\n\n.lnsLayerPanel__row--notSupportsMoreColumns {\n  padding-bottom: 0; }\n\n.lnsLayerPanel__group {\n  padding: 8px 0; }\n\n.lnsLayerPanel__group:empty {\n  padding: 0; }\n\n.lnsLayerPanel__groupLabel {\n  padding: 0 8px; }\n\n.lnsLayerPanel__error {\n  padding: 0 8px; }\n\n.lnsLayerPanel__dimension {\n  font-size: 14px;\n  font-size: 0.875rem;\n  line-height: 1.5;\n  border-radius: 4px;\n  display: flex;\n  align-items: center;\n  overflow: hidden;\n  min-height: 40px;\n  position: relative; }\n  .lnsLayerPanel__dimension > div {\n    flex-grow: 1; }\n\n.lnsLayerPanel__dimension--empty {\n  margin-top: 8px; }\n  .lnsLayerPanel__dimension--empty:focus, .lnsLayerPanel__dimension--empty:focus-within {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important; }\n\n.lnsLayerPanel__dimensionContainer {\n  margin: 0 8px 8px;\n  position: relative; }\n  .lnsLayerPanel__dimensionContainer:last-child {\n    margin-bottom: 0; }\n\n.lnsLayerPanel__dimensionRemove {\n  margin-right: 8px; }\n\n.lnsLayerPanel__triggerText {\n  width: 100%;\n  padding: 8px;\n  min-height: 38px;\n  word-break: break-word; }\n\n.lnsLayerPanel__triggerTextLabel {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsLayerPanel__triggerTextContent {\n  justify-content: flex-start;\n  padding: 0 !important;\n  color: #81858f; }\n\n.lnsLayerPanel__styleEditor {\n  padding: 0 8px 8px; }\n\n.lnsLayerPanel__colorIndicator {\n  margin-left: 8px; }\n\n.lnsLayerPanel__paletteContainer {\n  position: absolute;\n  bottom: 0;\n  left: 0;\n  right: 0; }\n\n.lnsLayerPanel__palette {\n  border-radius: 0 0 3px 3px; }\n  .lnsLayerPanel__palette::after {\n    border: none; }\n\n.lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink {\n  width: 100%; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus {\n    background-color: transparent;\n    animation: none !important; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus .lnsLayerPanel__triggerTextLabel,\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus-within .lnsLayerPanel__triggerTextLabel {\n    background-color: rgba(96, 146, 192, 0.1); }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(238);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsLayerPanel {\n  margin-bottom: 8px; }\n  .lnsLayerPanel:focus:not(:focus-visible) {\n    animation: none !important; }\n\n.lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 58px); }\n\n.lnsLayerPanel__settingsFlexItem:empty + .lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 8px); }\n\n.lnsLayerPanel__settingsFlexItem:empty {\n  margin: 0; }\n\n.lnsLayerPanel__row {\n  background: #F5F7FA;\n  padding: 8px 0;\n  border-radius: 4px; }\n  .lnsLayerPanel__row + .lnsLayerPanel__row {\n    margin-top: 16px; }\n\n.lnsLayerPanel__row--notSupportsMoreColumns {\n  padding-bottom: 0; }\n\n.lnsLayerPanel__group {\n  padding: 8px 0; }\n\n.lnsLayerPanel__group:empty {\n  padding: 0; }\n\n.lnsLayerPanel__groupLabel {\n  padding: 0 8px; }\n\n.lnsLayerPanel__error {\n  padding: 0 8px; }\n\n.lnsLayerPanel__dimension {\n  font-size: 14px;\n  font-size: 0.875rem;\n  line-height: 1.5;\n  border-radius: 4px;\n  display: flex;\n  align-items: center;\n  overflow: hidden;\n  min-height: 40px;\n  position: relative; }\n  .lnsLayerPanel__dimension > div {\n    flex-grow: 1; }\n\n.lnsLayerPanel__dimension--empty {\n  margin-top: 8px; }\n  .lnsLayerPanel__dimension--empty:focus, .lnsLayerPanel__dimension--empty:focus-within {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important; }\n\n.lnsLayerPanel__dimensionContainer {\n  margin: 0 8px 8px;\n  position: relative; }\n  .lnsLayerPanel__dimensionContainer:last-child {\n    margin-bottom: 0; }\n\n.lnsLayerPanel__dimensionRemove {\n  margin-right: 8px; }\n\n.lnsLayerPanel__triggerText {\n  width: 100%;\n  padding: 8px;\n  min-height: 38px;\n  word-break: break-word; }\n\n.lnsLayerPanel__triggerTextLabel {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsLayerPanel__triggerTextContent {\n  justify-content: flex-start;\n  padding: 0 !important;\n  color: #6a717d; }\n\n.lnsLayerPanel__styleEditor {\n  padding: 0 8px 8px; }\n\n.lnsLayerPanel__colorIndicator {\n  margin-left: 8px; }\n\n.lnsLayerPanel__paletteContainer {\n  position: absolute;\n  bottom: 0;\n  left: 0;\n  right: 0; }\n\n.lnsLayerPanel__palette {\n  border-radius: 0 0 3px 3px; }\n  .lnsLayerPanel__palette::after {\n    border: none; }\n\n.lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink {\n  width: 100%; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus {\n    background-color: transparent;\n    animation: none !important; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus .lnsLayerPanel__triggerTextLabel,\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus-within .lnsLayerPanel__triggerTextLabel {\n    background-color: rgba(96, 146, 192, 0.1); }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(240);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsLayerPanel {\n  margin-bottom: 8px; }\n  .lnsLayerPanel:focus:not(:focus-visible) {\n    animation: none !important; }\n\n.lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 58px); }\n\n.lnsLayerPanel__settingsFlexItem:empty + .lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 8px); }\n\n.lnsLayerPanel__settingsFlexItem:empty {\n  margin: 0; }\n\n.lnsLayerPanel__row {\n  background: #25262E;\n  padding: 8px 0;\n  border-radius: 6px; }\n  .lnsLayerPanel__row + .lnsLayerPanel__row {\n    margin-top: 16px; }\n\n.lnsLayerPanel__row--notSupportsMoreColumns {\n  padding-bottom: 0; }\n\n.lnsLayerPanel__group {\n  padding: 8px 0; }\n\n.lnsLayerPanel__group:empty {\n  padding: 0; }\n\n.lnsLayerPanel__groupLabel {\n  padding: 0 8px; }\n\n.lnsLayerPanel__error {\n  padding: 0 8px; }\n\n.lnsLayerPanel__dimension {\n  font-size: 14px;\n  font-size: 1rem;\n  line-height: 1.71429rem;\n  border-radius: 6px;\n  display: flex;\n  align-items: center;\n  overflow: hidden;\n  min-height: 40px;\n  position: relative; }\n  .lnsLayerPanel__dimension > div {\n    flex-grow: 1; }\n\n.lnsLayerPanel__dimension--empty {\n  margin-top: 8px; }\n  .lnsLayerPanel__dimension--empty:focus, .lnsLayerPanel__dimension--empty:focus-within {\n    outline: 2px solid currentColor; }\n    .lnsLayerPanel__dimension--empty:focus:focus-visible, .lnsLayerPanel__dimension--empty:focus-within:focus-visible {\n      outline-style: auto; }\n    .lnsLayerPanel__dimension--empty:focus:not(:focus-visible), .lnsLayerPanel__dimension--empty:focus-within:not(:focus-visible) {\n      outline: none; }\n\n.lnsLayerPanel__dimensionContainer {\n  margin: 0 8px 8px;\n  position: relative; }\n  .lnsLayerPanel__dimensionContainer:last-child {\n    margin-bottom: 0; }\n\n.lnsLayerPanel__dimensionRemove {\n  margin-right: 8px; }\n\n.lnsLayerPanel__triggerText {\n  width: 100%;\n  padding: 8px;\n  min-height: 38px;\n  word-break: break-word; }\n\n.lnsLayerPanel__triggerTextLabel {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsLayerPanel__triggerTextContent {\n  justify-content: flex-start;\n  padding: 0 !important;\n  color: #81858f; }\n\n.lnsLayerPanel__styleEditor {\n  padding: 0 8px 8px; }\n\n.lnsLayerPanel__colorIndicator {\n  margin-left: 8px; }\n\n.lnsLayerPanel__paletteContainer {\n  position: absolute;\n  bottom: 0;\n  left: 0;\n  right: 0; }\n\n.lnsLayerPanel__palette {\n  border-radius: 0 0 5px 5px; }\n  .lnsLayerPanel__palette::after {\n    border: none; }\n\n.lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink {\n  width: 100%; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus {\n    background-color: transparent;\n    animation: none !important; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus .lnsLayerPanel__triggerTextLabel,\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus-within .lnsLayerPanel__triggerTextLabel {\n    background-color: rgba(96, 146, 192, 0.1); }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(242);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsLayerPanel {\n  margin-bottom: 8px; }\n  .lnsLayerPanel:focus:not(:focus-visible) {\n    animation: none !important; }\n\n.lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 58px); }\n\n.lnsLayerPanel__settingsFlexItem:empty + .lnsLayerPanel__sourceFlexItem {\n  max-width: calc(100% - 8px); }\n\n.lnsLayerPanel__settingsFlexItem:empty {\n  margin: 0; }\n\n.lnsLayerPanel__row {\n  background: #F5F7FA;\n  padding: 8px 0;\n  border-radius: 6px; }\n  .lnsLayerPanel__row + .lnsLayerPanel__row {\n    margin-top: 16px; }\n\n.lnsLayerPanel__row--notSupportsMoreColumns {\n  padding-bottom: 0; }\n\n.lnsLayerPanel__group {\n  padding: 8px 0; }\n\n.lnsLayerPanel__group:empty {\n  padding: 0; }\n\n.lnsLayerPanel__groupLabel {\n  padding: 0 8px; }\n\n.lnsLayerPanel__error {\n  padding: 0 8px; }\n\n.lnsLayerPanel__dimension {\n  font-size: 14px;\n  font-size: 1rem;\n  line-height: 1.71429rem;\n  border-radius: 6px;\n  display: flex;\n  align-items: center;\n  overflow: hidden;\n  min-height: 40px;\n  position: relative; }\n  .lnsLayerPanel__dimension > div {\n    flex-grow: 1; }\n\n.lnsLayerPanel__dimension--empty {\n  margin-top: 8px; }\n  .lnsLayerPanel__dimension--empty:focus, .lnsLayerPanel__dimension--empty:focus-within {\n    outline: 2px solid currentColor; }\n    .lnsLayerPanel__dimension--empty:focus:focus-visible, .lnsLayerPanel__dimension--empty:focus-within:focus-visible {\n      outline-style: auto; }\n    .lnsLayerPanel__dimension--empty:focus:not(:focus-visible), .lnsLayerPanel__dimension--empty:focus-within:not(:focus-visible) {\n      outline: none; }\n\n.lnsLayerPanel__dimensionContainer {\n  margin: 0 8px 8px;\n  position: relative; }\n  .lnsLayerPanel__dimensionContainer:last-child {\n    margin-bottom: 0; }\n\n.lnsLayerPanel__dimensionRemove {\n  margin-right: 8px; }\n\n.lnsLayerPanel__triggerText {\n  width: 100%;\n  padding: 8px;\n  min-height: 38px;\n  word-break: break-word; }\n\n.lnsLayerPanel__triggerTextLabel {\n  transition: background-color 150ms ease-in-out; }\n\n.lnsLayerPanel__triggerTextContent {\n  justify-content: flex-start;\n  padding: 0 !important;\n  color: #69707D; }\n\n.lnsLayerPanel__styleEditor {\n  padding: 0 8px 8px; }\n\n.lnsLayerPanel__colorIndicator {\n  margin-left: 8px; }\n\n.lnsLayerPanel__paletteContainer {\n  position: absolute;\n  bottom: 0;\n  left: 0;\n  right: 0; }\n\n.lnsLayerPanel__palette {\n  border-radius: 0 0 5px 5px; }\n  .lnsLayerPanel__palette::after {\n    border: none; }\n\n.lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink {\n  width: 100%; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus {\n    background-color: transparent;\n    animation: none !important; }\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus .lnsLayerPanel__triggerTextLabel,\n  .lnsLayerPanel__dimension .lnsLayerPanel__dimensionLink:focus-within .lnsLayerPanel__triggerTextLabel {\n    background-color: rgba(96, 146, 192, 0.1); }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(244);case"v7light":return __webpack_require__(246);case"v8dark":return __webpack_require__(248);case"v8light":return __webpack_require__(250)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(245);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDimensionContainer {\n  border-left: 1px solid #343741;\n  box-shadow: 0 40px 64px 0 rgba(0, 0, 0, 0.1), 0 24px 32px 0 rgba(0, 0, 0, 0.1), 0 16px 16px 0 rgba(0, 0, 0, 0.1), 0 8px 8px 0 rgba(0, 0, 0, 0.1), 0 4px 4px 0 rgba(0, 0, 0, 0.1), 0 2px 2px 0 rgba(0, 0, 0, 0.1);\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  right: 0;\n  height: 100%;\n  z-index: 3000;\n  background: #1D1E24;\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  -webkit-clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n          clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n  position: absolute;\n  right: 0;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  animation: euiFlyout 250ms cubic-bezier(0.694, 0.0482, 0.335, 1); }\n\n.lnsDimensionContainer__footer {\n  padding: 8px; }\n\n.lnsDimensionContainer__header {\n  padding: 8px 4px; }\n\n.lnsDimensionContainer__headerTitle {\n  padding: 8px 4px;\n  cursor: pointer; }\n  .lnsDimensionContainer__headerTitle:hover {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__headerLink:focus-within {\n  background-color: rgba(96, 146, 192, 0.1); }\n  .lnsDimensionContainer__headerLink:focus-within .lnsDimensionContainer__headerTitle {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__backIcon:hover {\n  transform: none !important; }\n\n.lnsDimensionContainer__backIcon:focus {\n  background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(247);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDimensionContainer {\n  border-left: 1px solid #D3DAE6;\n  box-shadow: 0 40px 64px 0 rgba(65, 78, 101, 0.1), 0 24px 32px 0 rgba(65, 78, 101, 0.1), 0 16px 16px 0 rgba(65, 78, 101, 0.1), 0 8px 8px 0 rgba(65, 78, 101, 0.1), 0 4px 4px 0 rgba(65, 78, 101, 0.1), 0 2px 2px 0 rgba(65, 78, 101, 0.1);\n  border-color: #c6cad1;\n  border-top-color: #e3e4e8;\n  border-bottom-color: #aaafba;\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  right: 0;\n  height: 100%;\n  z-index: 3000;\n  background: #FFF;\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  -webkit-clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n          clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n  position: absolute;\n  right: 0;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  animation: euiFlyout 250ms cubic-bezier(0.694, 0.0482, 0.335, 1); }\n\n.lnsDimensionContainer__footer {\n  padding: 8px; }\n\n.lnsDimensionContainer__header {\n  padding: 8px 4px; }\n\n.lnsDimensionContainer__headerTitle {\n  padding: 8px 4px;\n  cursor: pointer; }\n  .lnsDimensionContainer__headerTitle:hover {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__headerLink:focus-within {\n  background-color: rgba(96, 146, 192, 0.1); }\n  .lnsDimensionContainer__headerLink:focus-within .lnsDimensionContainer__headerTitle {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__backIcon:hover {\n  transform: none !important; }\n\n.lnsDimensionContainer__backIcon:focus {\n  background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(249);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDimensionContainer {\n  border-left: none;\n  box-shadow: 0 2.7px 9px rgba(0, 0, 0, 0.325), 0 9.4px 24px rgba(0, 0, 0, 0.225), 0 21.8px 43px rgba(0, 0, 0, 0.2);\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  right: 0;\n  height: 100%;\n  z-index: 3000;\n  background: #1D1E24;\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  -webkit-clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n          clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n  position: absolute;\n  right: 0;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  animation: euiFlyout 250ms cubic-bezier(0.694, 0.0482, 0.335, 1); }\n\n.lnsDimensionContainer__footer {\n  padding: 8px; }\n\n.lnsDimensionContainer__header {\n  padding: 8px 4px; }\n\n.lnsDimensionContainer__headerTitle {\n  padding: 8px 4px;\n  cursor: pointer; }\n  .lnsDimensionContainer__headerTitle:hover {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__headerLink:focus-within {\n  background-color: rgba(96, 146, 192, 0.1); }\n  .lnsDimensionContainer__headerLink:focus-within .lnsDimensionContainer__headerTitle {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__backIcon:hover {\n  transform: none !important; }\n\n.lnsDimensionContainer__backIcon:focus {\n  background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(251);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsDimensionContainer {\n  border-left: none;\n  box-shadow: 0 2.7px 9px rgba(0, 0, 0, 0.13), 0 9.4px 24px rgba(0, 0, 0, 0.09), 0 21.8px 43px rgba(0, 0, 0, 0.08);\n  position: fixed;\n  top: 0;\n  bottom: 0;\n  right: 0;\n  height: 100%;\n  z-index: 3000;\n  background: #FFF;\n  display: flex;\n  flex-direction: column;\n  align-items: stretch;\n  -webkit-clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n          clip-path: polygon(-20% 0, 100% 0, 100% 100%, -20% 100%);\n  position: absolute;\n  right: 0;\n  left: 0;\n  top: 0;\n  bottom: 0;\n  animation: euiFlyout 250ms cubic-bezier(0.694, 0.0482, 0.335, 1); }\n\n.lnsDimensionContainer__footer {\n  padding: 8px; }\n\n.lnsDimensionContainer__header {\n  padding: 8px 4px; }\n\n.lnsDimensionContainer__headerTitle {\n  padding: 8px 4px;\n  cursor: pointer; }\n  .lnsDimensionContainer__headerTitle:hover {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__headerLink:focus-within {\n  background-color: rgba(96, 146, 192, 0.1); }\n  .lnsDimensionContainer__headerLink:focus-within .lnsDimensionContainer__headerTitle {\n    text-decoration: underline; }\n\n.lnsDimensionContainer__backIcon:hover {\n  transform: none !important; }\n\n.lnsDimensionContainer__backIcon:focus {\n  background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(253);case"v7light":return __webpack_require__(255);case"v8dark":return __webpack_require__(257);case"v8light":return __webpack_require__(259)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(254);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFrameLayout {\n  padding: 0;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  flex-direction: column; }\n\n.lnsFrameLayout__pageContent {\n  overflow: hidden;\n  flex-grow: 1;\n  flex-direction: row; }\n\n.lnsFrameLayout__pageBody {\n  scrollbar-width: thin;\n  min-width: 320px;\n  overflow: hidden auto;\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 100%;\n  padding: 16px 16px 0; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-corner, .lnsFrameLayout__pageBody::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsFrameLayout__pageBody:first-child {\n    padding-left: 16px; }\n\n.lnsFrameLayout__sidebar {\n  margin: 0;\n  flex: 1 0 18%;\n  min-width: 304px;\n  display: flex;\n  flex-direction: column;\n  position: relative; }\n\n.lnsFrameLayout__sidebar--right {\n  flex-basis: 25%;\n  background-color: #000;\n  min-width: 320px;\n  max-width: 440px;\n  max-height: 100%; }\n  .lnsFrameLayout__sidebar--right .lnsConfigPanel {\n    scrollbar-width: thin;\n    padding: 16px 4px 16px 16px;\n    overflow-x: hidden;\n    overflow-y: scroll; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-thumb {\n      background-color: rgba(152, 162, 179, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-corner, .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-track {\n      background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(256);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFrameLayout {\n  padding: 0;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  flex-direction: column; }\n\n.lnsFrameLayout__pageContent {\n  overflow: hidden;\n  flex-grow: 1;\n  flex-direction: row; }\n\n.lnsFrameLayout__pageBody {\n  scrollbar-width: thin;\n  min-width: 320px;\n  overflow: hidden auto;\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 100%;\n  padding: 16px 16px 0; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-corner, .lnsFrameLayout__pageBody::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsFrameLayout__pageBody:first-child {\n    padding-left: 16px; }\n\n.lnsFrameLayout__sidebar {\n  margin: 0;\n  flex: 1 0 18%;\n  min-width: 304px;\n  display: flex;\n  flex-direction: column;\n  position: relative; }\n\n.lnsFrameLayout__sidebar--right {\n  flex-basis: 25%;\n  background-color: #F5F7FA;\n  min-width: 320px;\n  max-width: 440px;\n  max-height: 100%; }\n  .lnsFrameLayout__sidebar--right .lnsConfigPanel {\n    scrollbar-width: thin;\n    padding: 16px 4px 16px 16px;\n    overflow-x: hidden;\n    overflow-y: scroll; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-thumb {\n      background-color: rgba(105, 112, 125, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-corner, .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-track {\n      background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(258);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFrameLayout {\n  padding: 0;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  flex-direction: column; }\n\n.lnsFrameLayout__pageContent {\n  overflow: hidden;\n  flex-grow: 1;\n  flex-direction: row; }\n\n.lnsFrameLayout__pageBody {\n  scrollbar-width: thin;\n  min-width: 320px;\n  overflow: hidden auto;\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 100%;\n  padding: 16px 16px 0; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-corner, .lnsFrameLayout__pageBody::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsFrameLayout__pageBody:first-child {\n    padding-left: 16px; }\n\n.lnsFrameLayout__sidebar {\n  margin: 0;\n  flex: 1 0 18%;\n  min-width: 304px;\n  display: flex;\n  flex-direction: column;\n  position: relative; }\n\n.lnsFrameLayout__sidebar--right {\n  flex-basis: 25%;\n  background-color: #000;\n  min-width: 320px;\n  max-width: 440px;\n  max-height: 100%; }\n  .lnsFrameLayout__sidebar--right .lnsConfigPanel {\n    scrollbar-width: thin;\n    padding: 16px 4px 16px 16px;\n    overflow-x: hidden;\n    overflow-y: scroll; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-thumb {\n      background-color: rgba(152, 162, 179, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-corner, .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-track {\n      background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(260);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsFrameLayout {\n  padding: 0;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  overflow: hidden;\n  flex-direction: column; }\n\n.lnsFrameLayout__pageContent {\n  overflow: hidden;\n  flex-grow: 1;\n  flex-direction: row; }\n\n.lnsFrameLayout__pageBody {\n  scrollbar-width: thin;\n  min-width: 320px;\n  overflow: hidden auto;\n  display: flex;\n  flex-direction: column;\n  flex: 1 1 100%;\n  padding: 16px 16px 0; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsFrameLayout__pageBody::-webkit-scrollbar-corner, .lnsFrameLayout__pageBody::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsFrameLayout__pageBody:first-child {\n    padding-left: 16px; }\n\n.lnsFrameLayout__sidebar {\n  margin: 0;\n  flex: 1 0 18%;\n  min-width: 304px;\n  display: flex;\n  flex-direction: column;\n  position: relative; }\n\n.lnsFrameLayout__sidebar--right {\n  flex-basis: 25%;\n  background-color: #F5F7FA;\n  min-width: 320px;\n  max-width: 440px;\n  max-height: 100%; }\n  .lnsFrameLayout__sidebar--right .lnsConfigPanel {\n    scrollbar-width: thin;\n    padding: 16px 4px 16px 16px;\n    overflow-x: hidden;\n    overflow-y: scroll; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-thumb {\n      background-color: rgba(105, 112, 125, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-corner, .lnsFrameLayout__sidebar--right .lnsConfigPanel::-webkit-scrollbar-track {\n      background-color: transparent; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(262);case"v7light":return __webpack_require__(264);case"v8dark":return __webpack_require__(266);case"v8light":return __webpack_require__(268)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(263);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsSuggestionPanel__title {\n  margin-left: 2px; }\n\n.lnsSuggestionPanel__suggestions {\n  scrollbar-width: thin;\n  -webkit-mask-image: linear-gradient(to right, rgba(255, 102, 102, 0.1) 0%, #ff6666 7.5px, #ff6666 calc(100% - 7.5px), rgba(255, 102, 102, 0.1) 100%);\n          mask-image: linear-gradient(to right, rgba(255, 102, 102, 0.1) 0%, #ff6666 7.5px, #ff6666 calc(100% - 7.5px), rgba(255, 102, 102, 0.1) 100%);\n  padding-top: 4px;\n  overflow-x: scroll;\n  overflow-y: hidden;\n  display: flex;\n  padding-left: 4px;\n  margin-left: -4px;\n  padding-bottom: 4px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-corner, .lnsSuggestionPanel__suggestions::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsSuggestionPanel__button {\n  position: relative;\n  flex: 0 0 auto;\n  width: 150px !important;\n  height: 100px;\n  margin-right: 8px;\n  margin-left: 2px;\n  margin-bottom: 2px; }\n  .lnsSuggestionPanel__button:focus {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important;\n    transform: none !important; }\n  .lnsSuggestionPanel__button .lnsSuggestionPanel__expressionRenderer {\n    position: static; }\n\n.lnsSuggestionPanel__button-isSelected {\n  background-color: #25262E !important;\n  border-color: #535966; }\n  .lnsSuggestionPanel__button-isSelected:not(:focus) {\n    box-shadow: none !important; }\n  .lnsSuggestionPanel__button-isSelected:focus {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important; }\n  .lnsSuggestionPanel__button-isSelected:hover {\n    transform: none !important; }\n\n.lnsSuggestionPanel__suggestionIcon {\n  color: #98A2B3;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  padding: 8px; }\n  .lnsSuggestionPanel__suggestionIcon:not(:only-child) {\n    height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__chartWrapper {\n  display: flex;\n  height: 100%;\n  width: 100%;\n  pointer-events: none; }\n\n.lnsSuggestionPanel__chartWrapper--withLabel {\n  height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__buttonLabel {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important;\n  font-size: 12px;\n  font-size: 0.75rem;\n  line-height: 1.5;\n  display: block;\n  font-weight: 700;\n  text-align: center;\n  flex-grow: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(265);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsSuggestionPanel__title {\n  margin-left: 2px; }\n\n.lnsSuggestionPanel__suggestions {\n  scrollbar-width: thin;\n  -webkit-mask-image: linear-gradient(to right, rgba(189, 39, 30, 0.1) 0%, #bd271e 7.5px, #bd271e calc(100% - 7.5px), rgba(189, 39, 30, 0.1) 100%);\n          mask-image: linear-gradient(to right, rgba(189, 39, 30, 0.1) 0%, #bd271e 7.5px, #bd271e calc(100% - 7.5px), rgba(189, 39, 30, 0.1) 100%);\n  padding-top: 4px;\n  overflow-x: scroll;\n  overflow-y: hidden;\n  display: flex;\n  padding-left: 4px;\n  margin-left: -4px;\n  padding-bottom: 4px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-corner, .lnsSuggestionPanel__suggestions::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsSuggestionPanel__button {\n  position: relative;\n  flex: 0 0 auto;\n  width: 150px !important;\n  height: 100px;\n  margin-right: 8px;\n  margin-left: 2px;\n  margin-bottom: 2px; }\n  .lnsSuggestionPanel__button:focus {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important;\n    transform: none !important; }\n  .lnsSuggestionPanel__button .lnsSuggestionPanel__expressionRenderer {\n    position: static; }\n\n.lnsSuggestionPanel__button-isSelected {\n  background-color: #F5F7FA !important;\n  border-color: #98A2B3; }\n  .lnsSuggestionPanel__button-isSelected:not(:focus) {\n    box-shadow: none !important; }\n  .lnsSuggestionPanel__button-isSelected:focus {\n    animation: 350ms cubic-bezier(0.694, 0.0482, 0.335, 1) 1 normal forwards focusRingAnimate !important; }\n  .lnsSuggestionPanel__button-isSelected:hover {\n    transform: none !important; }\n\n.lnsSuggestionPanel__suggestionIcon {\n  color: #69707D;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  padding: 8px; }\n  .lnsSuggestionPanel__suggestionIcon:not(:only-child) {\n    height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__chartWrapper {\n  display: flex;\n  height: 100%;\n  width: 100%;\n  pointer-events: none; }\n\n.lnsSuggestionPanel__chartWrapper--withLabel {\n  height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__buttonLabel {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important;\n  font-size: 12px;\n  font-size: 0.75rem;\n  line-height: 1.5;\n  display: block;\n  font-weight: 700;\n  text-align: center;\n  flex-grow: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(267);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsSuggestionPanel__title {\n  margin-left: 2px; }\n\n.lnsSuggestionPanel__suggestions {\n  scrollbar-width: thin;\n  -webkit-mask-image: linear-gradient(to right, rgba(248, 107, 99, 0.1) 0%, #f86b63 7.5px, #f86b63 calc(100% - 7.5px), rgba(248, 107, 99, 0.1) 100%);\n          mask-image: linear-gradient(to right, rgba(248, 107, 99, 0.1) 0%, #f86b63 7.5px, #f86b63 calc(100% - 7.5px), rgba(248, 107, 99, 0.1) 100%);\n  padding-top: 4px;\n  overflow-x: scroll;\n  overflow-y: hidden;\n  display: flex;\n  padding-left: 4px;\n  margin-left: -4px;\n  padding-bottom: 4px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-corner, .lnsSuggestionPanel__suggestions::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsSuggestionPanel__button {\n  position: relative;\n  flex: 0 0 auto;\n  width: 150px !important;\n  height: 100px;\n  margin-right: 8px;\n  margin-left: 2px;\n  margin-bottom: 2px; }\n  .lnsSuggestionPanel__button:focus {\n    outline: 2px solid currentColor;\n    transform: none !important; }\n    .lnsSuggestionPanel__button:focus:focus-visible {\n      outline-style: auto; }\n    .lnsSuggestionPanel__button:focus:not(:focus-visible) {\n      outline: none; }\n  .lnsSuggestionPanel__button .lnsSuggestionPanel__expressionRenderer {\n    position: static; }\n\n.lnsSuggestionPanel__button-isSelected {\n  background-color: #25262E !important;\n  border-color: #535966; }\n  .lnsSuggestionPanel__button-isSelected:not(:focus) {\n    box-shadow: none !important; }\n  .lnsSuggestionPanel__button-isSelected:focus {\n    outline: 2px solid currentColor; }\n    .lnsSuggestionPanel__button-isSelected:focus:focus-visible {\n      outline-style: auto; }\n    .lnsSuggestionPanel__button-isSelected:focus:not(:focus-visible) {\n      outline: none; }\n  .lnsSuggestionPanel__button-isSelected:hover {\n    transform: none !important; }\n\n.lnsSuggestionPanel__suggestionIcon {\n  color: #98A2B3;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  padding: 8px; }\n  .lnsSuggestionPanel__suggestionIcon:not(:only-child) {\n    height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__chartWrapper {\n  display: flex;\n  height: 100%;\n  width: 100%;\n  pointer-events: none; }\n\n.lnsSuggestionPanel__chartWrapper--withLabel {\n  height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__buttonLabel {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important;\n  font-size: 12px;\n  font-size: 0.85714rem;\n  line-height: 1.14286rem;\n  display: block;\n  font-weight: 700;\n  text-align: center;\n  flex-grow: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(269);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsSuggestionPanel__title {\n  margin-left: 2px; }\n\n.lnsSuggestionPanel__suggestions {\n  scrollbar-width: thin;\n  -webkit-mask-image: linear-gradient(to right, rgba(189, 39, 30, 0.1) 0%, #bd271e 7.5px, #bd271e calc(100% - 7.5px), rgba(189, 39, 30, 0.1) 100%);\n          mask-image: linear-gradient(to right, rgba(189, 39, 30, 0.1) 0%, #bd271e 7.5px, #bd271e calc(100% - 7.5px), rgba(189, 39, 30, 0.1) 100%);\n  padding-top: 4px;\n  overflow-x: scroll;\n  overflow-y: hidden;\n  display: flex;\n  padding-left: 4px;\n  margin-left: -4px;\n  padding-bottom: 4px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsSuggestionPanel__suggestions::-webkit-scrollbar-corner, .lnsSuggestionPanel__suggestions::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsSuggestionPanel__button {\n  position: relative;\n  flex: 0 0 auto;\n  width: 150px !important;\n  height: 100px;\n  margin-right: 8px;\n  margin-left: 2px;\n  margin-bottom: 2px; }\n  .lnsSuggestionPanel__button:focus {\n    outline: 2px solid currentColor;\n    transform: none !important; }\n    .lnsSuggestionPanel__button:focus:focus-visible {\n      outline-style: auto; }\n    .lnsSuggestionPanel__button:focus:not(:focus-visible) {\n      outline: none; }\n  .lnsSuggestionPanel__button .lnsSuggestionPanel__expressionRenderer {\n    position: static; }\n\n.lnsSuggestionPanel__button-isSelected {\n  background-color: #F5F7FA !important;\n  border-color: #98A2B3; }\n  .lnsSuggestionPanel__button-isSelected:not(:focus) {\n    box-shadow: none !important; }\n  .lnsSuggestionPanel__button-isSelected:focus {\n    outline: 2px solid currentColor; }\n    .lnsSuggestionPanel__button-isSelected:focus:focus-visible {\n      outline-style: auto; }\n    .lnsSuggestionPanel__button-isSelected:focus:not(:focus-visible) {\n      outline: none; }\n  .lnsSuggestionPanel__button-isSelected:hover {\n    transform: none !important; }\n\n.lnsSuggestionPanel__suggestionIcon {\n  color: #69707D;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  padding: 8px; }\n  .lnsSuggestionPanel__suggestionIcon:not(:only-child) {\n    height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__chartWrapper {\n  display: flex;\n  height: 100%;\n  width: 100%;\n  pointer-events: none; }\n\n.lnsSuggestionPanel__chartWrapper--withLabel {\n  height: calc(100% - 24px); }\n\n.lnsSuggestionPanel__buttonLabel {\n  max-width: 100%;\n  overflow: hidden !important;\n  text-overflow: ellipsis !important;\n  white-space: nowrap !important;\n  word-wrap: normal !important;\n  font-size: 12px;\n  font-size: 0.85714rem;\n  line-height: 1.14286rem;\n  display: block;\n  font-weight: 700;\n  text-align: center;\n  flex-grow: 0; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.fromExpression=fromExpression;exports.safeElementFromExpression=safeElementFromExpression;exports.toExpression=toExpression;var _get_type=__webpack_require__(41);var _grammar=__webpack_require__(51);function getArgumentString(arg,argKey,level=0){const type=(0,_get_type.getType)(arg);function maybeArgKey(argKey,argString){return argKey==null||argKey==="_"?argString:`${argKey}=${argString}`}if(type==="string"){const escapedArg=arg.replace(/[\\"]/g,"\\$&");return maybeArgKey(argKey,`"${escapedArg}"`)}if(type==="boolean"||type==="null"||type==="number"){return maybeArgKey(argKey,`${arg}`)}if(type==="expression"){return maybeArgKey(argKey,`{${getExpression(arg.chain,level+1)}}`)}throw new Error(`Invalid argument type in AST: ${type}`)}function getExpressionArgs(block,level=0){const args=block.arguments;const hasValidArgs=typeof args==="object"&&args!=null&&!Array.isArray(args);if(!hasValidArgs)throw new Error("Arguments can only be an object");const argKeys=Object.keys(args);const MAX_LINE_LENGTH=80;return argKeys.map(argKey=>args[argKey].reduce((acc,arg)=>{const argString=getArgumentString(arg,argKey,level);const lineLength=acc.split("\n").pop().length;if(level===0&&lineLength+argString.length>MAX_LINE_LENGTH){return`${acc}\n  ${argString}`}if(lineLength>0)return`${acc} ${argString}`;return argString},""))}function fnWithArgs(fnName,args){if(!args||args.length===0)return fnName;return`${fnName} ${args.join(" ")}`}function getExpression(chain,level=0){if(!chain)throw new Error("Expressions must contain a chain");const separator=level>0?" | ":"\n| ";return chain.map(chainObj=>{const type=(0,_get_type.getType)(chainObj);if(type==="function"){const fn=chainObj.function;if(!fn||fn.length===0)throw new Error("Functions must have a function name");const expArgs=getExpressionArgs(chainObj,level);return fnWithArgs(fn,expArgs)}},[]).join(separator)}function fromExpression(expression,type="expression"){try{return(0,_grammar.parse)(String(expression),{startRule:type})}catch(e){throw new Error(`Unable to parse expression: ${e.message}`)}}function safeElementFromExpression(expression){try{return fromExpression(expression)}catch(e){return fromExpression(`markdown\n"## Crud.\nCanvas could not parse this element's expression. I am so sorry this error isn't more useful. I promise it will be soon.\n\nThanks for understanding,\n#### Management\n"`)}}function toExpression(astObj,type="expression"){if(type==="argument")return getArgumentString(astObj);const validType=["expression","function"].includes((0,_get_type.getType)(astObj));if(!validType)throw new Error("Expression must be an expression or argument function");if((0,_get_type.getType)(astObj)==="expression"){if(!Array.isArray(astObj.chain))throw new Error("Expressions must contain a chain");return getExpression(astObj.chain)}const expArgs=getExpressionArgs(astObj);return fnWithArgs(astObj.function,expArgs)}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Fn=Fn;var _lodash=__webpack_require__(20);var _arg=__webpack_require__(272);function Fn(config){this.name=config.name;this.type=config.type;this.aliases=config.aliases||[];this.fn=(...args)=>Promise.resolve(config.fn(...args));this.help=config.help||"";this.args=(0,_lodash.mapValues)(config.args||{},(arg,name)=>new _arg.Arg({name:name,...arg}));this.context=config.context||{};this.accepts=type=>{if(!this.context.types)return true;return(0,_lodash.includes)(this.context.types,type)}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Arg=Arg;var _lodash=__webpack_require__(20);function Arg(config){if(config.name==="_")throw Error("Arg names must not be _. Use it in aliases instead.");this.name=config.name;this.required=config.required||false;this.help=config.help||"";this.types=config.types||[];this.default=config.default;this.aliases=config.aliases||[];this.multi=config.multi==null?false:config.multi;this.resolve=config.resolve==null?true:config.resolve;this.options=config.options||[];this.accepts=type=>{if(!this.types.length)return true;return(0,_lodash.includes)(config.types,type)}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.castProvider=castProvider;var _get_type=__webpack_require__(41);function castProvider(types){return function cast(node,toTypeNames){if(!toTypeNames||toTypeNames.length===0)return node;const fromTypeName=(0,_get_type.getType)(node);if(toTypeNames.includes(fromTypeName))return node;const fromTypeDef=types[fromTypeName];for(let i=0;i<toTypeNames.length;i++){if(fromTypeDef&&fromTypeDef.castsTo(toTypeNames[i])){return fromTypeDef.to(node,toTypeNames[i],types)}const toTypeDef=types[toTypeNames[i]];if(toTypeDef&&toTypeDef.castsFrom(fromTypeName))return toTypeDef.from(node,types)}throw new Error(`Can not cast '${fromTypeName}' to any of '${toTypeNames.join(", ")}'`)}}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.getByAlias=getByAlias;function getByAlias(specs,name){const lowerCaseName=name.toLowerCase();return Object.values(specs).find(({name:name,aliases:aliases})=>{if(name.toLowerCase()===lowerCaseName)return true;return(aliases||[]).some(alias=>alias.toLowerCase()===lowerCaseName)})}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Registry=void 0;var _lodash=__webpack_require__(20);class Registry{constructor(prop="name"){if(typeof prop!=="string")throw new Error("Registry property name must be a string");this._prop=prop;this._indexed=new Object}wrapper(obj){return obj}register(fn){const obj=typeof fn==="function"?fn():fn;if(typeof obj!=="object"||!obj[this._prop]){throw new Error(`Registered functions must return an object with a ${this._prop} property`)}this._indexed[obj[this._prop].toLowerCase()]=this.wrapper(obj)}toJS(){return Object.keys(this._indexed).reduce((acc,key)=>{acc[key]=this.get(key);return acc},{})}toArray(){return Object.keys(this._indexed).map(key=>this.get(key))}get(name){if(name===undefined)return null;const lowerCaseName=name.toLowerCase();return this._indexed[lowerCaseName]?(0,_lodash.clone)(this._indexed[lowerCaseName]):null}getProp(){return this._prop}reset(){this._indexed=new Object}}exports.Registry=Registry},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.addRegistries=addRegistries;exports.register=register;exports.registryFactory=registryFactory;function addRegistries(registries,newRegistries){Object.keys(newRegistries).forEach(registryName=>{if(registries[registryName]){throw new Error(`There is already a registry named "${registryName}".`)}registries[registryName]=newRegistries[registryName]});return registries}function register(registries,specs){Object.keys(specs).forEach(registryName=>{if(!registries[registryName]){throw new Error(`There is no registry named "${registryName}".`)}if(!registries[registryName].register){throw new Error(`Registry "${registryName}" must have a register function.`)}specs[registryName].forEach(f=>registries[registryName].register(f))});return registries}function registryFactory(registries){return{registries(){return registries},register(specs){return register(registries,specs)}}}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(278);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspacePanelWrapper {\n  scrollbar-width: thin;\n  padding: 0 !important;\n  margin-bottom: 16px;\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  min-height: 400px;\n  overflow: visible;\n  border: none;\n  height: 100%; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody {\n    scrollbar-width: thin;\n    flex-grow: 1;\n    display: flex;\n    align-items: stretch;\n    justify-content: stretch; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-thumb {\n      background-color: rgba(152, 162, 179, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-track {\n      background-color: transparent; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody > * {\n      flex: 1 1 100%;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      overflow: hidden; }\n\n.lnsWorkspacePanel__dragDrop {\n  width: 100%;\n  height: 100%;\n  border: 1px solid #343741;\n  border-radius: 4px; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget {\n    border: 1px dashed #343741;\n    background-color: rgba(84, 179, 153, 0.1); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget p {\n      transition: filter 150ms ease-in-out;\n      filter: blur(5px); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget .lnsExpressionRenderer {\n      transition: filter 250ms ease-in-out, opacity 250ms ease-in-out;\n      filter: blur(4px);\n      opacity: .25; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(84, 179, 153, 0.25);\n    border: 1px dashed #54B399; }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget .lnsDropIllustration__hand {\n      animation: lnsWorkspacePanel__illustrationPulseContinuous 1.5s ease-in-out 0s infinite normal forwards; }\n\n.lnsWorkspacePanel__emptyContent {\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transition: background-color 150ms ease-in-out; }\n\n.lnsWorkspacePanelWrapper__toolbar {\n  margin-bottom: 0; }\n\n.lnsDropIllustration__adjustFill {\n  fill: #FFF; }\n\n.lnsWorkspacePanel__dropIllustration {\n  overflow: visible;\n  margin-top: 24px;\n  margin-bottom: 40px;\n  filter: drop-shadow(0 6px 12px rgba(0, 0, 0, 0.2)) drop-shadow(0 4px 4px rgba(0, 0, 0, 0.2)) drop-shadow(0 2px 2px rgba(0, 0, 0, 0.2)); }\n\n.lnsDropIllustration__hand {\n  animation: lnsWorkspacePanel__illustrationPulseArrow 5s ease-in-out 0s infinite normal forwards; }\n\n@keyframes lnsWorkspacePanel__illustrationPulseArrow {\n  0% {\n    transform: translateY(0%); }\n  65% {\n    transform: translateY(0%); }\n  72% {\n    transform: translateY(10%); }\n  79% {\n    transform: translateY(7%); }\n  86% {\n    transform: translateY(10%); }\n  95% {\n    transform: translateY(0); } }\n\n@keyframes lnsWorkspacePanel__illustrationPulseContinuous {\n  0% {\n    transform: translateY(10%); }\n  25% {\n    transform: translateY(15%); }\n  50% {\n    transform: translateY(10%); }\n  75% {\n    transform: translateY(15%); }\n  100% {\n    transform: translateY(10%); } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(280);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspacePanelWrapper {\n  scrollbar-width: thin;\n  padding: 0 !important;\n  margin-bottom: 16px;\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  min-height: 400px;\n  overflow: visible;\n  border: none;\n  height: 100%; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody {\n    scrollbar-width: thin;\n    flex-grow: 1;\n    display: flex;\n    align-items: stretch;\n    justify-content: stretch; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-thumb {\n      background-color: rgba(105, 112, 125, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-track {\n      background-color: transparent; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody > * {\n      flex: 1 1 100%;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      overflow: hidden; }\n\n.lnsWorkspacePanel__dragDrop {\n  width: 100%;\n  height: 100%;\n  border: 1px solid #D3DAE6;\n  border-radius: 4px; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget {\n    border: 1px dashed #D3DAE6;\n    background-color: rgba(84, 179, 153, 0.1); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget p {\n      transition: filter 150ms ease-in-out;\n      filter: blur(5px); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget .lnsExpressionRenderer {\n      transition: filter 250ms ease-in-out, opacity 250ms ease-in-out;\n      filter: blur(4px);\n      opacity: .25; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(84, 179, 153, 0.25);\n    border: 1px dashed #54B399; }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget .lnsDropIllustration__hand {\n      animation: lnsWorkspacePanel__illustrationPulseContinuous 1.5s ease-in-out 0s infinite normal forwards; }\n\n.lnsWorkspacePanel__emptyContent {\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transition: background-color 150ms ease-in-out; }\n\n.lnsWorkspacePanelWrapper__toolbar {\n  margin-bottom: 0; }\n\n.lnsDropIllustration__adjustFill {\n  fill: #000; }\n\n.lnsWorkspacePanel__dropIllustration {\n  overflow: visible;\n  margin-top: 24px;\n  margin-bottom: 40px;\n  filter: drop-shadow(0 6px 12px rgba(152, 162, 179, 0.2)) drop-shadow(0 4px 4px rgba(152, 162, 179, 0.2)) drop-shadow(0 2px 2px rgba(152, 162, 179, 0.2)); }\n\n.lnsDropIllustration__hand {\n  animation: lnsWorkspacePanel__illustrationPulseArrow 5s ease-in-out 0s infinite normal forwards; }\n\n@keyframes lnsWorkspacePanel__illustrationPulseArrow {\n  0% {\n    transform: translateY(0%); }\n  65% {\n    transform: translateY(0%); }\n  72% {\n    transform: translateY(10%); }\n  79% {\n    transform: translateY(7%); }\n  86% {\n    transform: translateY(10%); }\n  95% {\n    transform: translateY(0); } }\n\n@keyframes lnsWorkspacePanel__illustrationPulseContinuous {\n  0% {\n    transform: translateY(10%); }\n  25% {\n    transform: translateY(15%); }\n  50% {\n    transform: translateY(10%); }\n  75% {\n    transform: translateY(15%); }\n  100% {\n    transform: translateY(10%); } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(282);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspacePanelWrapper {\n  scrollbar-width: thin;\n  padding: 0 !important;\n  margin-bottom: 16px;\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  min-height: 400px;\n  overflow: visible;\n  border: none;\n  height: 100%; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody {\n    scrollbar-width: thin;\n    flex-grow: 1;\n    display: flex;\n    align-items: stretch;\n    justify-content: stretch; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-thumb {\n      background-color: rgba(152, 162, 179, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-track {\n      background-color: transparent; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody > * {\n      flex: 1 1 100%;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      overflow: hidden; }\n\n.lnsWorkspacePanel__dragDrop {\n  width: 100%;\n  height: 100%;\n  border: 1px solid #343741;\n  border-radius: 6px; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget {\n    border: 1px dashed #343741;\n    background-color: rgba(84, 179, 153, 0.1); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget p {\n      transition: filter 150ms ease-in-out;\n      filter: blur(5px); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget .lnsExpressionRenderer {\n      transition: filter 250ms ease-in-out, opacity 250ms ease-in-out;\n      filter: blur(4px);\n      opacity: .25; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(84, 179, 153, 0.25);\n    border: 1px dashed #54B399; }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget .lnsDropIllustration__hand {\n      animation: lnsWorkspacePanel__illustrationPulseContinuous 1.5s ease-in-out 0s infinite normal forwards; }\n\n.lnsWorkspacePanel__emptyContent {\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transition: background-color 150ms ease-in-out; }\n\n.lnsWorkspacePanelWrapper__toolbar {\n  margin-bottom: 0; }\n\n.lnsDropIllustration__adjustFill {\n  fill: #FFF; }\n\n.lnsWorkspacePanel__dropIllustration {\n  overflow: visible;\n  margin-top: 24px;\n  margin-bottom: 40px;\n  filter: drop-shadow(0 6px 12px rgba(0, 0, 0, 0.2)) drop-shadow(0 4px 4px rgba(0, 0, 0, 0.2)) drop-shadow(0 2px 2px rgba(0, 0, 0, 0.2)); }\n\n.lnsDropIllustration__hand {\n  animation: lnsWorkspacePanel__illustrationPulseArrow 5s ease-in-out 0s infinite normal forwards; }\n\n@keyframes lnsWorkspacePanel__illustrationPulseArrow {\n  0% {\n    transform: translateY(0%); }\n  65% {\n    transform: translateY(0%); }\n  72% {\n    transform: translateY(10%); }\n  79% {\n    transform: translateY(7%); }\n  86% {\n    transform: translateY(10%); }\n  95% {\n    transform: translateY(0); } }\n\n@keyframes lnsWorkspacePanel__illustrationPulseContinuous {\n  0% {\n    transform: translateY(10%); }\n  25% {\n    transform: translateY(15%); }\n  50% {\n    transform: translateY(10%); }\n  75% {\n    transform: translateY(15%); }\n  100% {\n    transform: translateY(10%); } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(284);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspacePanelWrapper {\n  scrollbar-width: thin;\n  padding: 0 !important;\n  margin-bottom: 16px;\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  min-height: 400px;\n  overflow: visible;\n  border: none;\n  height: 100%; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspacePanelWrapper::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper::-webkit-scrollbar-track {\n    background-color: transparent; }\n  .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody {\n    scrollbar-width: thin;\n    flex-grow: 1;\n    display: flex;\n    align-items: stretch;\n    justify-content: stretch; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar {\n      width: 16px;\n      height: 16px; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-thumb {\n      background-color: rgba(105, 112, 125, 0.5);\n      border: 6px solid transparent;\n      background-clip: content-box; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-corner, .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody::-webkit-scrollbar-track {\n      background-color: transparent; }\n    .lnsWorkspacePanelWrapper .lnsWorkspacePanelWrapper__pageContentBody > * {\n      flex: 1 1 100%;\n      display: flex;\n      align-items: center;\n      justify-content: center;\n      overflow: hidden; }\n\n.lnsWorkspacePanel__dragDrop {\n  width: 100%;\n  height: 100%;\n  border: 1px solid #D3DAE6;\n  border-radius: 6px; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget {\n    border: 1px dashed #D3DAE6;\n    background-color: rgba(84, 179, 153, 0.1); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget p {\n      transition: filter 150ms ease-in-out;\n      filter: blur(5px); }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isDropTarget .lnsExpressionRenderer {\n      transition: filter 250ms ease-in-out, opacity 250ms ease-in-out;\n      filter: blur(4px);\n      opacity: .25; }\n  .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget {\n    background-color: rgba(84, 179, 153, 0.25);\n    border: 1px dashed #54B399; }\n    .lnsWorkspacePanel__dragDrop.lnsDragDrop-isActiveDropTarget .lnsDropIllustration__hand {\n      animation: lnsWorkspacePanel__illustrationPulseContinuous 1.5s ease-in-out 0s infinite normal forwards; }\n\n.lnsWorkspacePanel__emptyContent {\n  position: absolute;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  top: 0;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n  transition: background-color 150ms ease-in-out; }\n\n.lnsWorkspacePanelWrapper__toolbar {\n  margin-bottom: 0; }\n\n.lnsDropIllustration__adjustFill {\n  fill: #000; }\n\n.lnsWorkspacePanel__dropIllustration {\n  overflow: visible;\n  margin-top: 24px;\n  margin-bottom: 40px;\n  filter: drop-shadow(0 6px 12px rgba(0, 0, 0, 0.2)) drop-shadow(0 4px 4px rgba(0, 0, 0, 0.2)) drop-shadow(0 2px 2px rgba(0, 0, 0, 0.2)); }\n\n.lnsDropIllustration__hand {\n  animation: lnsWorkspacePanel__illustrationPulseArrow 5s ease-in-out 0s infinite normal forwards; }\n\n@keyframes lnsWorkspacePanel__illustrationPulseArrow {\n  0% {\n    transform: translateY(0%); }\n  65% {\n    transform: translateY(0%); }\n  72% {\n    transform: translateY(10%); }\n  79% {\n    transform: translateY(7%); }\n  86% {\n    transform: translateY(10%); }\n  95% {\n    transform: translateY(0); } }\n\n@keyframes lnsWorkspacePanel__illustrationPulseContinuous {\n  0% {\n    transform: translateY(10%); }\n  25% {\n    transform: translateY(15%); }\n  50% {\n    transform: translateY(10%); }\n  75% {\n    transform: translateY(15%); }\n  100% {\n    transform: translateY(10%); } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(286);case"v7light":return __webpack_require__(288);case"v8dark":return __webpack_require__(290);case"v8light":return __webpack_require__(292)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(287);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsChartSwitch__header > * {\n  display: flex;\n  align-items: center; }\n\n.lnsChartSwitch__summaryIcon {\n  margin-right: 8px;\n  transform: translateY(-1px);\n  color: #81858f; }\n\nimg.lnsChartSwitch__chartIcon {\n  width: 100%; }\n\n.lnsChartSwitch__search {\n  width: 160px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(289);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsChartSwitch__header > * {\n  display: flex;\n  align-items: center; }\n\n.lnsChartSwitch__summaryIcon {\n  margin-right: 8px;\n  transform: translateY(-1px);\n  color: #6a717d; }\n\nimg.lnsChartSwitch__chartIcon {\n  width: 100%; }\n\n.lnsChartSwitch__search {\n  width: 160px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(291);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsChartSwitch__header > * {\n  display: flex;\n  align-items: center; }\n\n.lnsChartSwitch__summaryIcon {\n  margin-right: 8px;\n  transform: translateY(-1px);\n  color: #81858f; }\n\nimg.lnsChartSwitch__chartIcon {\n  width: 100%; }\n\n.lnsChartSwitch__search {\n  width: 160px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(293);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsChartSwitch__header > * {\n  display: flex;\n  align-items: center; }\n\n.lnsChartSwitch__summaryIcon {\n  margin-right: 8px;\n  transform: translateY(-1px);\n  color: #69707D; }\n\nimg.lnsChartSwitch__chartIcon {\n  width: 100%; }\n\n.lnsChartSwitch__search {\n  width: 160px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(295);case"v7light":return __webpack_require__(297);case"v8dark":return __webpack_require__(299);case"v8light":return __webpack_require__(301)}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(296);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspaceWarning__button {\n  color: #FFCE7A; }\n\n.lnsWorkspaceWarningList {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  max-height: 320px;\n  width: 256px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-corner, .lnsWorkspaceWarningList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsWorkspaceWarningList__item {\n  padding: 16px; }\n  .lnsWorkspaceWarningList__item + .lnsWorkspaceWarningList__item {\n    border-top: 1px solid #343741; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(298);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspaceWarning__button {\n  color: #9b6900; }\n\n.lnsWorkspaceWarningList {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  max-height: 320px;\n  width: 256px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-corner, .lnsWorkspaceWarningList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsWorkspaceWarningList__item {\n  padding: 16px; }\n  .lnsWorkspaceWarningList__item + .lnsWorkspaceWarningList__item {\n    border-top: 1px solid #D3DAE6; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(300);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspaceWarning__button {\n  color: #F3D371; }\n\n.lnsWorkspaceWarningList {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  max-height: 320px;\n  width: 256px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-thumb {\n    background-color: rgba(152, 162, 179, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-corner, .lnsWorkspaceWarningList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsWorkspaceWarningList__item {\n  padding: 16px; }\n  .lnsWorkspaceWarningList__item + .lnsWorkspaceWarningList__item {\n    border-top: 1px solid #343741; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(302);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsWorkspaceWarning__button {\n  color: #8a6a0a; }\n\n.lnsWorkspaceWarningList {\n  scrollbar-width: thin;\n  height: 100%;\n  overflow-y: auto;\n  max-height: 320px;\n  width: 256px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar {\n    width: 16px;\n    height: 16px; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-thumb {\n    background-color: rgba(105, 112, 125, 0.5);\n    border: 6px solid transparent;\n    background-clip: content-box; }\n  .lnsWorkspaceWarningList::-webkit-scrollbar-corner, .lnsWorkspaceWarningList::-webkit-scrollbar-track {\n    background-color: transparent; }\n\n.lnsWorkspaceWarningList__item {\n  padding: 16px; }\n  .lnsWorkspaceWarningList__item + .lnsWorkspaceWarningList__item {\n    border-top: 1px solid #D3DAE6; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(305);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsAppWrapper {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lnsApp {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  overflow: hidden; }\n\n.lnsApp__header {\n  border-bottom: 1px solid #343741; }\n\n.lnsApp__frame {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lensChartIcon__subdued {\n  fill: #81858f; }\n  .euiButton--fill .lensChartIcon__subdued {\n    fill: currentColor; }\n\n.lensChartIcon__accent {\n  fill: #54B399; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(307);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsAppWrapper {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lnsApp {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  overflow: hidden; }\n\n.lnsApp__header {\n  border-bottom: 1px solid #D3DAE6; }\n\n.lnsApp__frame {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lensChartIcon__subdued {\n  fill: #6a717d; }\n  .euiButton--fill .lensChartIcon__subdued {\n    fill: currentColor; }\n\n.lensChartIcon__accent {\n  fill: #54B399; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(309);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsAppWrapper {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lnsApp {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  overflow: hidden; }\n\n.lnsApp__header {\n  border-bottom: 1px solid #343741; }\n\n.lnsApp__frame {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lensChartIcon__subdued {\n  fill: #81858f; }\n  .euiButton--fill .lensChartIcon__subdued {\n    fill: currentColor; }\n\n.lensChartIcon__accent {\n  fill: #54B399; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(33);var content=__webpack_require__(311);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(34);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".lnsAppWrapper {\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lnsApp {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  display: flex;\n  flex-direction: column;\n  height: 100%;\n  overflow: hidden; }\n\n.lnsApp__header {\n  border-bottom: 1px solid #D3DAE6; }\n\n.lnsApp__frame {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  flex-grow: 1; }\n\n.lensChartIcon__subdued {\n  fill: #69707D; }\n  .euiButton--fill .lensChartIcon__subdued {\n    fill: currentColor; }\n\n.lensChartIcon__accent {\n  fill: #54B399; }\n",""]);module.exports=exports},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"getDatatable",(function(){return getDatatable}));__webpack_require__.d(__webpack_exports__,"datatableColumn",(function(){return datatableColumn}));__webpack_require__.d(__webpack_exports__,"getDatatableRenderer",(function(){return getDatatableRenderer}));__webpack_require__.d(__webpack_exports__,"datatableVisualization",(function(){return datatableVisualization}));__webpack_require__.d(__webpack_exports__,"metricChart",(function(){return metricChart}));__webpack_require__.d(__webpack_exports__,"getMetricChartRenderer",(function(){return getMetricChartRenderer}));__webpack_require__.d(__webpack_exports__,"MetricChart",(function(){return MetricChart}));__webpack_require__.d(__webpack_exports__,"metricVisualization",(function(){return metricVisualization}));__webpack_require__.d(__webpack_exports__,"pie",(function(){return pie}));__webpack_require__.d(__webpack_exports__,"getPieRenderer",(function(){return getPieRenderer}));__webpack_require__.d(__webpack_exports__,"getPieVisualization",(function(){return getPieVisualization}));__webpack_require__.d(__webpack_exports__,"xyChart",(function(){return xyChart}));__webpack_require__.d(__webpack_exports__,"calculateMinInterval",(function(){return calculateMinInterval}));__webpack_require__.d(__webpack_exports__,"getXyChartRenderer",(function(){return getXyChartRenderer}));__webpack_require__.d(__webpack_exports__,"XYChartReportable",(function(){return XYChartReportable}));__webpack_require__.d(__webpack_exports__,"XYChart",(function(){return XYChart}));__webpack_require__.d(__webpack_exports__,"legendConfig",(function(){return legendConfig}));__webpack_require__.d(__webpack_exports__,"tickLabelsConfig",(function(){return tickLabelsConfig}));__webpack_require__.d(__webpack_exports__,"gridlinesConfig",(function(){return gridlinesConfig}));__webpack_require__.d(__webpack_exports__,"axisTitlesVisibilityConfig",(function(){return axisTitlesVisibilityConfig}));__webpack_require__.d(__webpack_exports__,"yAxisConfig",(function(){return yAxisConfig}));__webpack_require__.d(__webpack_exports__,"layerConfig",(function(){return layerConfig}));__webpack_require__.d(__webpack_exports__,"visualizationTypes",(function(){return types_visualizationTypes}));__webpack_require__.d(__webpack_exports__,"getXyVisualization",(function(){return getXyVisualization}));__webpack_require__.d(__webpack_exports__,"OperationType",(function(){return undefined}));__webpack_require__.d(__webpack_exports__,"IndexPatternColumn",(function(){return undefined}));__webpack_require__.d(__webpack_exports__,"deleteColumn",(function(){return deleteColumn}));__webpack_require__.d(__webpack_exports__,"columnToOperation",(function(){return columnToOperation}));__webpack_require__.d(__webpack_exports__,"renameColumns",(function(){return renameColumns}));__webpack_require__.d(__webpack_exports__,"supportedFormats",(function(){return supportedFormats}));__webpack_require__.d(__webpack_exports__,"formatColumn",(function(){return formatColumn}));__webpack_require__.d(__webpack_exports__,"getTimeScaleFunction",(function(){return getTimeScaleFunction}));__webpack_require__.d(__webpack_exports__,"counterRate",(function(){return counterRate}));__webpack_require__.d(__webpack_exports__,"unitSuffixesLong",(function(){return unitSuffixesLong}));__webpack_require__.d(__webpack_exports__,"getSuffixFormatter",(function(){return getSuffixFormatter}));__webpack_require__.d(__webpack_exports__,"getIndexPatternDatasource",(function(){return getIndexPatternDatasource}));__webpack_require__.d(__webpack_exports__,"EditorFrame",(function(){return EditorFrame}));__webpack_require__.d(__webpack_exports__,"initializeDatasources",(function(){return initializeDatasources}));__webpack_require__.d(__webpack_exports__,"createDatasourceLayers",(function(){return createDatasourceLayers}));__webpack_require__.d(__webpack_exports__,"persistedStateToExpression",(function(){return persistedStateToExpression}));__webpack_require__.d(__webpack_exports__,"validateDatasourceAndVisualization",(function(){return validateDatasourceAndVisualization}));__webpack_require__.d(__webpack_exports__,"getActiveDatasourceIdFromDoc",(function(){return getActiveDatasourceIdFromDoc}));__webpack_require__.d(__webpack_exports__,"getInitialState",(function(){return getInitialState}));__webpack_require__.d(__webpack_exports__,"reducer",(function(){return reducer}));__webpack_require__.d(__webpack_exports__,"Embeddable",(function(){return embeddable_Embeddable}));__webpack_require__.d(__webpack_exports__,"mountApp",(function(){return mountApp}));__webpack_require__.d(__webpack_exports__,"getLensAttributeService",(function(){return getLensAttributeService}));__webpack_require__.d(__webpack_exports__,"setReportManager",(function(){return lens_ui_telemetry["b"]}));__webpack_require__.d(__webpack_exports__,"stopReportManager",(function(){return lens_ui_telemetry["c"]}));__webpack_require__.d(__webpack_exports__,"trackUiEvent",(function(){return lens_ui_telemetry["e"]}));__webpack_require__.d(__webpack_exports__,"trackSuggestionEvent",(function(){return lens_ui_telemetry["d"]}));__webpack_require__.d(__webpack_exports__,"LensReportManager",(function(){return lens_ui_telemetry["a"]}));var external_kbnSharedDeps_React_=__webpack_require__(3);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(6);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(9);var ipaddr=__webpack_require__(54);var ipaddr_default=__webpack_require__.n(ipaddr);function isIPv6Address(ip){return ip.kind()==="ipv6"}function getSafeIpAddress(ip,directionFactor){if(!ipaddr_default.a.isValid(ip)){return{parts:Array(8).fill(directionFactor*Infinity)}}const parsedIp=ipaddr_default.a.parse(ip);return isIPv6Address(parsedIp)?parsedIp:parsedIp.toIPv4MappedAddress()}function getIPCriteria(sortBy,directionFactor){return(rowA,rowB)=>{const ipAString=rowA[sortBy];const ipBString=rowB[sortBy];const ipA=getSafeIpAddress(ipAString,directionFactor);const ipB=getSafeIpAddress(ipBString,directionFactor);let i=0;let diff=ipA.parts[i]-ipB.parts[i];while(!diff&&i<7){i++;diff=ipA.parts[i]-ipB.parts[i]}if(diff===0){return directionFactor*(ipAString.length-ipBString.length)}return directionFactor*diff}}function getRangeCriteria(sortBy,directionFactor){const openRange={gte:-Infinity,lt:Infinity};return(rowA,rowB)=>{const rangeA={...openRange,...rowA[sortBy]};const rangeB={...openRange,...rowB[sortBy]};const fromComparison=rangeA.gte-rangeB.gte;const toComparison=rangeA.lt-rangeB.lt;return directionFactor*(fromComparison||toComparison)}}function getSortingCriteria(type,sortBy,formatter,direction){const directionFactor=direction==="asc"?1:-1;let criteria;if(["number","date"].includes(type||"")){criteria=(rowA,rowB)=>directionFactor*(rowA[sortBy]-rowB[sortBy])}else if(type==="range"){criteria=getRangeCriteria(sortBy,directionFactor)}else if(type==="ip"){criteria=getIPCriteria(sortBy,directionFactor)}else{criteria=(rowA,rowB)=>{const aString=formatter.convert(rowA[sortBy]);const bString=formatter.convert(rowB[sortBy]);return directionFactor*aString.localeCompare(bString)}}return getUndefinedHandler(sortBy,criteria)}function getUndefinedHandler(sortBy,sortingCriteria){return(rowA,rowB)=>{const valueA=rowA[sortBy];const valueB=rowB[sortBy];if(valueA!=null&&valueB!=null&&!Number.isNaN(valueA)&&!Number.isNaN(valueB)){return sortingCriteria(rowA,rowB)}if(valueA==null||Number.isNaN(valueA)){return 1}if(valueB==null||Number.isNaN(valueB)){return-1}return 0}}var table_basic=__webpack_require__(55);var useDeepCompareEffect=__webpack_require__(73);var useDeepCompareEffect_default=__webpack_require__.n(useDeepCompareEffect);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(19);var visualization_container=__webpack_require__(64);var classnames=__webpack_require__(36);var classnames_default=__webpack_require__.n(classnames);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}function VisualizationContainer({isReady:isReady=true,reportTitle:reportTitle,reportDescription:reportDescription,children:children,className:className,...rest}){const attributes={};if(reportTitle){attributes["data-title"]=reportTitle}if(reportDescription){attributes["data-description"]=reportDescription}return external_kbnSharedDeps_React_default.a.createElement("div",_extends({"data-shared-item":true,"data-render-complete":isReady,className:classnames_default()(className,"lnsVisualizationContainer")},attributes,rest),children)}const EmptyPlaceholder=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:"lnsChart__empty",textAlign:"center",color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:props.icon,color:"subdued",size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.xyVisualization.noDataLabel",defaultMessage:"No results found"}))));function legend_extends(){legend_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return legend_extends.apply(this,arguments)}const EuiIconLegend=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_["createElement"]("svg",legend_extends({width:16,height:16,viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_["createElement"]("title",{id:titleId},title):null,external_kbnSharedDeps_React_["createElement"]("path",{clipRule:"evenodd",fillRule:"evenodd",d:"M2.786.357a.25.25 0 01.428 0l2.559 4.264A.25.25 0 015.558 5H.442a.25.25 0 01-.215-.379L2.786.357zM3 1.944L4.234 4H1.766L3 1.944z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M8.5 2a.5.5 0 000 1h7a.5.5 0 000-1h-7z"}),external_kbnSharedDeps_React_["createElement"]("path",{clipRule:"evenodd",fillRule:"evenodd",d:"M1.5 6a.5.5 0 00-.5.5v3a.5.5 0 00.5.5h3a.5.5 0 00.5-.5v-3a.5.5 0 00-.5-.5h-3zM2 7v2h2V7H2z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M8.5 7.5a.5.5 0 000 1h7a.5.5 0 000-1h-7z"}),external_kbnSharedDeps_React_["createElement"]("path",{clipRule:"evenodd",fillRule:"evenodd",d:"M3 16a2.5 2.5 0 100-5 2.5 2.5 0 000 5zm0-1a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M8.5 13a.5.5 0 000 1h7a.5.5 0 000-1h-7z"}));var public_=__webpack_require__(23);const typeToIconMap={legend:EuiIconLegend,labels:"visText",values:"number",list:"list"};const ToolbarPopover=({children:children,title:title,type:type,isDisabled:isDisabled=false,groupPosition:groupPosition,buttonDataTestSubj:buttonDataTestSubj})=>{const[open,setOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const iconType=typeof type==="string"?typeToIconMap[type]:type;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{panelClassName:"lnsXyToolbar__popover",ownFocus:true,"aria-label":title,button:external_kbnSharedDeps_React_default.a.createElement(public_["ToolbarButton"],{fontWeight:"normal",onClick:()=>{setOpen(!open)},title:title,hasArrow:false,isDisabled:isDisabled,groupPosition:groupPosition,dataTestSubj:buttonDataTestSubj},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:iconType})),isOpen:open,closePopover:()=>{setOpen(false)},anchorPosition:"downRight"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,title),children))};var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(21);const toggleButtonsIcons=[{id:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendPositionBottom",{defaultMessage:"Bottom"}),iconType:"arrowDown"},{id:external_kbnSharedDeps_ElasticCharts_["Position"].Left,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendPositionLeft",{defaultMessage:"Left"}),iconType:"arrowLeft"},{id:external_kbnSharedDeps_ElasticCharts_["Position"].Right,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendPositionRight",{defaultMessage:"Right"}),iconType:"arrowRight"},{id:external_kbnSharedDeps_ElasticCharts_["Position"].Top,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendPositionTop",{defaultMessage:"Top"}),iconType:"arrowUp"}];const LegendSettingsPopover=({legendOptions:legendOptions,mode:mode,onDisplayChange:onDisplayChange,position:position,onPositionChange:onPositionChange,renderNestedLegendSwitch:renderNestedLegendSwitch,nestedLegend:nestedLegend,onNestedLegendChange:onNestedLegendChange=(()=>{})})=>external_kbnSharedDeps_React_default.a.createElement(ToolbarPopover,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendLabel",{defaultMessage:"Legend"}),type:"legend",groupPosition:"right",buttonDataTestSubj:"lnsLegendButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendVisibilityLabel",{defaultMessage:"Display"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{isFullWidth:true,legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendVisibilityLabel",{defaultMessage:"Display"}),"data-test-subj":"lens-legend-display-btn",name:"legendDisplay",buttonSize:"compressed",options:legendOptions,idSelected:legendOptions.find(({value:value})=>value===mode).id,onChange:onDisplayChange})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendPositionLabel",{defaultMessage:"Position"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.legendPositionLabel",{defaultMessage:"Position"}),isDisabled:mode==="hide","data-test-subj":"lens-legend-position-btn",name:"legendPosition",buttonSize:"compressed",options:toggleButtonsIcons,idSelected:position||external_kbnSharedDeps_ElasticCharts_["Position"].Right,onChange:onPositionChange,isIconOnly:true})),renderNestedLegendSwitch&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressedSwitch",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.nestedLegendLabel",{defaultMessage:"Nested"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.nestedLegendLabel",{defaultMessage:"Nested"}),"data-test-subj":"lens-legend-nested-switch",showLabel:false,disabled:mode==="hide",checked:!!nestedLegend,onChange:onNestedLegendChange})));function NativeRenderer({render:render,nativeProps:nativeProps,tag:tag,...rest}){return external_kbnSharedDeps_React_default.a.createElement(tag||"div",{...rest,ref:el=>el&&render(el,nativeProps)})}function PalettePicker({palettes:palettes,activePalette:activePalette,setPalette:setPalette}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.palettePicker.label",{defaultMessage:"Color palette"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPalettePicker"],{"data-test-subj":"lns-palettePicker",compressed:true,palettes:palettes.getAll().filter(({internal:internal})=>!internal).map(({id:id,title:title,getColors:getColors})=>({value:id,title:title,type:"fixed",palette:getColors(10,id===(activePalette===null||activePalette===void 0?void 0:activePalette.name)?activePalette===null||activePalette===void 0?void 0:activePalette.params:undefined)})),onChange:newPalette=>{setPalette({type:"palette",name:newPalette})},valueOfSelected:(activePalette===null||activePalette===void 0?void 0:activePalette.name)||"default",selectionDisplay:"palette"}),activePalette&&palettes.get(activePalette.name).renderEditor&&external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:palettes.get(activePalette.name).renderEditor,nativeProps:{state:activePalette.params,setState:updater=>{setPalette({type:"palette",name:activePalette.name,params:updater(activePalette.params)})}}})))}function chart_datatable_extends(){chart_datatable_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_datatable_extends.apply(this,arguments)}const LensIconChartDatatable=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_datatable_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M11 18a1 1 0 011 1v2a1 1 0 01-1 1H1a1 1 0 01-1-1v-2a1 1 0 011-1h10zm0-6a1 1 0 011 1v2a1 1 0 01-1 1H1a1 1 0 01-1-1v-2a1 1 0 011-1h10zm0-6a1 1 0 011 1v2a1 1 0 01-1 1H1a1 1 0 01-1-1V7a1 1 0 011-1h10zm18-6a1 1 0 011 1v2a1 1 0 01-1 1H1a1 1 0 01-1-1V1a1 1 0 011-1h28z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M20 18a1 1 0 011 1v2a1 1 0 01-.883.993L20 22h-5a1 1 0 01-1-1v-2a1 1 0 011-1h5zm9 0a1 1 0 011 1v2a1 1 0 01-1 1h-5a1 1 0 01-1-1v-2a1 1 0 011-1h5zm-9-6a1 1 0 011 1v2a1 1 0 01-.883.993L20 16h-5a1 1 0 01-1-1v-2a1 1 0 011-1h5zm9 0a1 1 0 011 1v2a1 1 0 01-1 1h-5a1 1 0 01-1-1v-2a1 1 0 011-1h5zm-9-6a1 1 0 011 1v2a1 1 0 01-.883.993L20 10h-5a1 1 0 01-1-1V7a1 1 0 011-1h5zm9 0a1 1 0 011 1v2a1 1 0 01-1 1h-5a1 1 0 01-1-1V7a1 1 0 011-1h5z",className:"lensChartIcon__accent"}));const createGridColumns=(bucketColumns,table,handleFilterClick,isReadOnly,columnConfig,visibleColumns,formatFactory,onColumnResize,onColumnHide)=>{const columnsReverseLookup=table.columns.reduce((memo,{id:id,name:name,meta:meta},i)=>{memo[id]={name:name,index:i,meta:meta};return memo},{});const bucketLookup=new Set(bucketColumns);const getContentData=({rowIndex:rowIndex,columnId:columnId})=>{var _column$meta;const rowValue=table.rows[rowIndex][columnId];const column=columnsReverseLookup[columnId];const contentsIsDefined=rowValue!=null;const cellContent=formatFactory(column===null||column===void 0?void 0:(_column$meta=column.meta)===null||_column$meta===void 0?void 0:_column$meta.params).convert(rowValue);return{rowValue:rowValue,contentsIsDefined:contentsIsDefined,cellContent:cellContent}};return visibleColumns.map(field=>{const filterable=bucketLookup.has(field);const{name:name,index:colIndex}=columnsReverseLookup[field];const cellActions=filterable?[({rowIndex:rowIndex,columnId:columnId,Component:Component,closePopover:closePopover})=>{const{rowValue:rowValue,contentsIsDefined:contentsIsDefined,cellContent:cellContent}=getContentData({rowIndex:rowIndex,columnId:columnId});const filterForText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.tableCellFilter.filterForValueText",{defaultMessage:"Filter for value"});const filterForAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.tableCellFilter.filterForValueAriaLabel",{defaultMessage:"Filter for value: {cellContent}",values:{cellContent:cellContent}});return contentsIsDefined&&external_kbnSharedDeps_React_default.a.createElement(Component,{"aria-label":filterForAriaLabel,"data-test-subj":"lensDatatableFilterFor",onClick:()=>{handleFilterClick(field,rowValue,colIndex,rowIndex);closePopover()},iconType:"plusInCircle"},filterForText)},({rowIndex:rowIndex,columnId:columnId,Component:Component,closePopover:closePopover})=>{const{rowValue:rowValue,contentsIsDefined:contentsIsDefined,cellContent:cellContent}=getContentData({rowIndex:rowIndex,columnId:columnId});const filterOutText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.tableCellFilter.filterOutValueText",{defaultMessage:"Filter out value"});const filterOutAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.tableCellFilter.filterOutValueAriaLabel",{defaultMessage:"Filter out value: {cellContent}",values:{cellContent:cellContent}});return contentsIsDefined&&external_kbnSharedDeps_React_default.a.createElement(Component,{"data-test-subj":"lensDatatableFilterOut","aria-label":filterOutAriaLabel,onClick:()=>{handleFilterClick(field,rowValue,colIndex,rowIndex,true);closePopover()},iconType:"minusInCircle"},filterOutText)}]:undefined;const column=columnConfig.columns.find(({columnId:columnId})=>columnId===field);const initialWidth=column===null||column===void 0?void 0:column.width;const isHidden=column===null||column===void 0?void 0:column.hidden;const columnDefinition={id:field,cellActions:cellActions,display:name,displayAsText:name,actions:{showHide:false,showMoveLeft:false,showMoveRight:false,showSortAsc:isReadOnly?false:{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.sort.ascLabel",{defaultMessage:"Sort ascending"})},showSortDesc:isReadOnly?false:{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.sort.descLabel",{defaultMessage:"Sort descending"})},additional:isReadOnly?undefined:[{color:"text",size:"xs",onClick:()=>onColumnResize({columnId:field,width:undefined}),iconType:"empty",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.resize.reset",{defaultMessage:"Reset width"}),"data-test-subj":"lensDatatableResetWidth",isDisabled:initialWidth==null},{color:"text",size:"xs",onClick:()=>onColumnHide({columnId:field}),iconType:"eyeClosed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.hide.hideLabel",{defaultMessage:"Hide"}),"data-test-subj":"lensDatatableHide",isDisabled:!isHidden&&visibleColumns.length<=1}]}};if(initialWidth){columnDefinition.initialWidth=initialWidth}return columnDefinition})};const createGridCell=(formatters,DataContext)=>({rowIndex:rowIndex,columnId:columnId})=>{var _formatters$columnId;const{table:table,alignments:alignments}=Object(external_kbnSharedDeps_React_["useContext"])(DataContext);const rowValue=table===null||table===void 0?void 0:table.rows[rowIndex][columnId];const content=(_formatters$columnId=formatters[columnId])===null||_formatters$columnId===void 0?void 0:_formatters$columnId.convert(rowValue,"html");const currentAlignment=alignments&&alignments[columnId];const alignmentClassName=`lnsTableCell--${currentAlignment}`;return external_kbnSharedDeps_React_default.a.createElement("div",{dangerouslySetInnerHTML:{__html:content},"data-test-subj":"lnsTableCellContent",className:`lnsTableCell ${alignmentClassName}`})};const desanitizeFilterContext=context=>{const emptyTextValue=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexpattern.emptyTextColumnValue",{defaultMessage:"(empty)"});const result={...context,data:context.data.map(point=>point.value===emptyTextValue?{...point,value:"",table:{...point.table,rows:point.table.rows.map((row,index)=>index===point.row?{...row,[point.table.columns[point.column].id]:""}:row)}}:point)};if(context.timeFieldName){result.timeFieldName=context.timeFieldName}return result};const createGridResizeHandler=(columnConfig,setColumnConfig,onEditAction)=>eventData=>{setColumnConfig({...columnConfig,columns:columnConfig.columns.map(column=>{if(column.columnId===eventData.columnId){return{...column,width:eventData.width}}return column})});return onEditAction({action:"resize",columnId:eventData.columnId,width:eventData.width})};const createGridHideHandler=(columnConfig,setColumnConfig,onEditAction)=>eventData=>{setColumnConfig({...columnConfig,columns:columnConfig.columns.map(column=>{if(column.columnId===eventData.columnId){return{...column,hidden:true}}return column})});return onEditAction({action:"toggle",columnId:eventData.columnId})};const createGridFilterHandler=(tableRef,onClickValue)=>(field,value,colIndex,rowIndex,negate=false)=>{var _col$meta,_col$meta2;const col=tableRef.current.columns[colIndex];const isDate=((_col$meta=col.meta)===null||_col$meta===void 0?void 0:_col$meta.type)==="date";const timeFieldName=negate&&isDate?undefined:col===null||col===void 0?void 0:(_col$meta2=col.meta)===null||_col$meta2===void 0?void 0:_col$meta2.field;const data={negate:negate,data:[{row:rowIndex,column:colIndex,value:value,table:tableRef.current}],timeFieldName:timeFieldName};onClickValue(desanitizeFilterContext(data))};const createGridSortingConfig=(sortBy,sortDirection,onEditAction)=>({columns:!sortBy||sortDirection==="none"?[]:[{id:sortBy,direction:sortDirection}],onSort:sortingCols=>{const newSortValue=sortingCols.length<=1?sortingCols[0]:sortingCols[1];const isNewColumn=sortBy!==((newSortValue===null||newSortValue===void 0?void 0:newSortValue.id)||"");const nextDirection=newSortValue?newSortValue.direction:"none";return onEditAction({action:"sort",columnId:nextDirection!=="none"||isNewColumn?newSortValue===null||newSortValue===void 0?void 0:newSortValue.id:undefined,direction:nextDirection})}});const table_basic_DataContext=external_kbnSharedDeps_React_default.a.createContext({});const gridStyle={border:"horizontal",header:"underline"};const DatatableComponent=props=>{var _props$rowHasRowClick;const[firstTable]=Object.values(props.data.tables);const[columnConfig,setColumnConfig]=Object(external_kbnSharedDeps_React_["useState"])({columns:props.args.columns,sortingColumnId:props.args.sortingColumnId,sortingDirection:props.args.sortingDirection});const[firstLocalTable,updateTable]=Object(external_kbnSharedDeps_React_["useState"])(firstTable);useDeepCompareEffect_default()(()=>{setColumnConfig({columns:props.args.columns,sortingColumnId:props.args.sortingColumnId,sortingDirection:props.args.sortingDirection})},[props.args.columns,props.args.sortingColumnId,props.args.sortingDirection]);useDeepCompareEffect_default()(()=>{updateTable(firstTable)},[firstTable]);const firstTableRef=Object(external_kbnSharedDeps_React_["useRef"])(firstLocalTable);firstTableRef.current=firstLocalTable;const hasAtLeastOneRowClickAction=(_props$rowHasRowClick=props.rowHasRowClickTriggerActions)===null||_props$rowHasRowClick===void 0?void 0:_props$rowHasRowClick.some(x=>x);const{getType:getType,dispatchEvent:dispatchEvent,renderMode:renderMode,formatFactory:formatFactory}=props;const formatters=Object(external_kbnSharedDeps_React_["useMemo"])(()=>firstLocalTable.columns.reduce((map,column)=>{var _column$meta;return{...map,[column.id]:formatFactory((_column$meta=column.meta)===null||_column$meta===void 0?void 0:_column$meta.params)}},{}),[firstLocalTable,formatFactory]);const onClickValue=Object(external_kbnSharedDeps_React_["useCallback"])(data=>{dispatchEvent({name:"filter",data:data})},[dispatchEvent]);const onEditAction=Object(external_kbnSharedDeps_React_["useCallback"])(data=>{if(renderMode==="edit"){dispatchEvent({name:"edit",data:data})}},[dispatchEvent,renderMode]);const onRowContextMenuClick=Object(external_kbnSharedDeps_React_["useCallback"])(data=>{dispatchEvent({name:"tableRowContextMenuClick",data:data})},[dispatchEvent]);const handleFilterClick=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createGridFilterHandler(firstTableRef,onClickValue),[firstTableRef,onClickValue]);const bucketColumns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>columnConfig.columns.filter((_col,index)=>{var _col$meta,_col$meta$sourceParam,_getType;const col=firstTableRef.current.columns[index];return(col===null||col===void 0?void 0:(_col$meta=col.meta)===null||_col$meta===void 0?void 0:(_col$meta$sourceParam=_col$meta.sourceParams)===null||_col$meta$sourceParam===void 0?void 0:_col$meta$sourceParam.type)&&((_getType=getType(col.meta.sourceParams.type))===null||_getType===void 0?void 0:_getType.type)==="buckets"}).map(col=>col.columnId),[firstTableRef,columnConfig,getType]);const isEmpty=firstLocalTable.rows.length===0||bucketColumns.length&&firstTable.rows.every(row=>bucketColumns.every(col=>row[col]==null));const visibleColumns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>columnConfig.columns.filter(col=>!!col.columnId&&!col.hidden).map(col=>col.columnId),[columnConfig]);const{sortingColumnId:sortBy,sortingDirection:sortDirection}=props.args;const isReadOnlySorted=renderMode!=="edit";const onColumnResize=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createGridResizeHandler(columnConfig,setColumnConfig,onEditAction),[onEditAction,setColumnConfig,columnConfig]);const onColumnHide=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createGridHideHandler(columnConfig,setColumnConfig,onEditAction),[onEditAction,setColumnConfig,columnConfig]);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createGridColumns(bucketColumns,firstLocalTable,handleFilterClick,isReadOnlySorted,columnConfig,visibleColumns,formatFactory,onColumnResize,onColumnHide),[bucketColumns,firstLocalTable,handleFilterClick,isReadOnlySorted,columnConfig,visibleColumns,formatFactory,onColumnResize,onColumnHide]);const alignments=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const alignmentMap={};columnConfig.columns.forEach(column=>{if(column.alignment){alignmentMap[column.columnId]=column.alignment}else{var _firstLocalTable$colu;const isNumeric=((_firstLocalTable$colu=firstLocalTable.columns.find(dataColumn=>dataColumn.id===column.columnId))===null||_firstLocalTable$colu===void 0?void 0:_firstLocalTable$colu.meta.type)==="number";alignmentMap[column.columnId]=isNumeric?"right":"left"}});return alignmentMap},[firstLocalTable,columnConfig]);const trailingControlColumns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!hasAtLeastOneRowClickAction||!onRowContextMenuClick){return[]}return[{headerCellRender:()=>null,width:40,id:"trailingControlColumn",rowCellRender:function RowCellRender({rowIndex:rowIndex}){const{rowHasRowClickTriggerActions:rowHasRowClickTriggerActions}=Object(external_kbnSharedDeps_React_["useContext"])(table_basic_DataContext);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.actionsLabel",{defaultMessage:"Show actions"}),iconType:!!rowHasRowClickTriggerActions&&!rowHasRowClickTriggerActions[rowIndex]?"empty":"boxesVertical",color:"text",onClick:()=>{onRowContextMenuClick({rowIndex:rowIndex,table:firstTableRef.current,columns:columnConfig.columns.map(col=>col.columnId)})}})}}]},[firstTableRef,onRowContextMenuClick,columnConfig,hasAtLeastOneRowClickAction]);const renderCellValue=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createGridCell(formatters,table_basic_DataContext),[formatters]);const columnVisibility=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({visibleColumns:visibleColumns,setVisibleColumns:()=>{}}),[visibleColumns]);const sorting=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createGridSortingConfig(sortBy,sortDirection,onEditAction),[onEditAction,sortBy,sortDirection]);if(isEmpty){return external_kbnSharedDeps_React_default.a.createElement(EmptyPlaceholder,{icon:LensIconChartDatatable})}const dataGridAriaLabel=props.args.title||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.defaultAriaLabel",{defaultMessage:"Data table visualization"});return external_kbnSharedDeps_React_default.a.createElement(VisualizationContainer,{className:"lnsDataTableContainer",reportTitle:props.args.title,reportDescription:props.args.description},external_kbnSharedDeps_React_default.a.createElement(table_basic_DataContext.Provider,{value:{table:firstLocalTable,rowHasRowClickTriggerActions:props.rowHasRowClickTriggerActions,alignments:alignments}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDataGrid"],{"aria-label":dataGridAriaLabel,"data-test-subj":"lnsDataTable",columns:columns,columnVisibility:columnVisibility,trailingControlColumns:trailingControlColumns,rowCount:firstLocalTable.rows.length,renderCellValue:renderCellValue,gridStyle:gridStyle,sorting:sorting,onColumnResize:onColumnResize,toolbarVisibility:false})))};function expression_extends(){expression_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return expression_extends.apply(this,arguments)}function isRange(meta){var _meta$params;return(meta===null||meta===void 0?void 0:(_meta$params=meta.params)===null||_meta$params===void 0?void 0:_meta$params.id)==="range"}const getDatatable=({formatFactory:formatFactory})=>({name:"lens_datatable",type:"render",inputTypes:["lens_multitable"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.expressionHelpLabel",{defaultMessage:"Datatable renderer"}),args:{title:{types:["string"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.titleLabel",{defaultMessage:"Title"})},description:{types:["string"],help:""},columns:{types:["lens_datatable_column"],help:"",multi:true},sortingColumnId:{types:["string"],help:""},sortingDirection:{types:["string"],help:""}},fn(data,args,context){const[firstTable]=Object.values(data.tables);const[layerId]=Object.keys(context.inspectorAdapters.tables||{});const formatters={};firstTable.columns.forEach(column=>{var _column$meta;formatters[column.id]=formatFactory((_column$meta=column.meta)===null||_column$meta===void 0?void 0:_column$meta.params)});const{sortingColumnId:sortBy,sortingDirection:sortDirection}=args;const columnsReverseLookup=firstTable.columns.reduce((memo,{id:id,name:name,meta:meta},i)=>{memo[id]={name:name,index:i,meta:meta};return memo},{});if(sortBy&&sortDirection!=="none"){var _columnsReverseLookup,_columnsReverseLookup2,_columnsReverseLookup3;const sortingCriteria=getSortingCriteria(isRange((_columnsReverseLookup=columnsReverseLookup[sortBy])===null||_columnsReverseLookup===void 0?void 0:_columnsReverseLookup.meta)?"range":(_columnsReverseLookup2=columnsReverseLookup[sortBy])===null||_columnsReverseLookup2===void 0?void 0:(_columnsReverseLookup3=_columnsReverseLookup2.meta)===null||_columnsReverseLookup3===void 0?void 0:_columnsReverseLookup3.type,sortBy,formatters[sortBy],sortDirection);context.inspectorAdapters.tables[layerId].rows=(firstTable.rows||[]).slice().sort(sortingCriteria);firstTable.rows=context.inspectorAdapters.tables[layerId].rows}return{type:"render",as:"lens_datatable_renderer",value:{data:data,args:args}}}});const datatableColumn={name:"lens_datatable_column",aliases:[],type:"lens_datatable_column",help:"",inputTypes:["null"],args:{columnId:{types:["string"],help:""},alignment:{types:["string"],help:""},hidden:{types:["boolean"],help:""},width:{types:["number"],help:""}},fn:function fn(input,args){return{type:"lens_datatable_column",...args}}};const getDatatableRenderer=dependencies=>({name:"lens_datatable_renderer",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.visualizationName",{defaultMessage:"Datatable"}),help:"",validate:()=>undefined,reuseDomNode:true,render:async(domNode,config,handlers)=>{const resolvedGetType=await dependencies.getType;const{hasCompatibleActions:hasCompatibleActions}=handlers;let rowHasRowClickTriggerActions=[];if(hasCompatibleActions){const table=Object.values(config.data.tables)[0];if(!!table){rowHasRowClickTriggerActions=await Promise.all(table.rows.map(async(row,rowIndex)=>{try{const hasActions=await hasCompatibleActions({name:"tableRowContextMenuClick",data:{rowIndex:rowIndex,table:table,columns:config.args.columns.map(column=>column.columnId)}});return hasActions}catch{return false}}))}}external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(DatatableComponent,expression_extends({},config,{formatFactory:dependencies.formatFactory,dispatchEvent:handlers.event,renderMode:handlers.getRenderMode(),getType:resolvedGetType,rowHasRowClickTriggerActions:rowHasRowClickTriggerActions}))),domNode,()=>{handlers.done()});handlers.onDestroy(()=>external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(domNode))}});const idPrefix=Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])()();function TableDimensionEditor(props){var _frame$activeData$sta;const{state:state,setState:setState,frame:frame,accessor:accessor}=props;const column=state.columns.find(({columnId:columnId})=>accessor===columnId);if(!column)return null;const currentAlignment=(column===null||column===void 0?void 0:column.alignment)||(frame.activeData&&((_frame$activeData$sta=frame.activeData[state.layerId].columns.find(col=>col.id===accessor))===null||_frame$activeData$sta===void 0?void 0:_frame$activeData$sta.meta.type)==="number"?"right":"left");const visibleColumnsCount=state.columns.filter(c=>!c.hidden).length;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.alignment.label",{defaultMessage:"Text alignment"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{isFullWidth:true,legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.alignment.label",{defaultMessage:"Text alignment"}),"data-test-subj":"lnsDatatable_alignment_groups",name:"alignment",buttonSize:"compressed",options:[{id:`${idPrefix}left`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.left",{defaultMessage:"Left"}),"data-test-subj":"lnsDatatable_alignment_groups_left"},{id:`${idPrefix}center`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.alignment.center",{defaultMessage:"Center"}),"data-test-subj":"lnsDatatable_alignment_groups_center"},{id:`${idPrefix}right`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.alignment.right",{defaultMessage:"Right"}),"data-test-subj":"lnsDatatable_alignment_groups_right"}],idSelected:`${idPrefix}${currentAlignment}`,onChange:id=>{const newMode=id.replace(idPrefix,"");const newColumns=state.columns.map(currentColumn=>{if(currentColumn.columnId===accessor){return{...currentColumn,alignment:newMode}}else{return currentColumn}});setState({...state,columns:newColumns})}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.columnVisibilityLabel",{defaultMessage:"Column hidden in table"}),display:"columnCompressedSwitch"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.table.columnVisibilityLabel",{defaultMessage:"Column hidden in table"}),showLabel:false,"data-test-subj":"lns-table-column-hidden",checked:Boolean(column===null||column===void 0?void 0:column.hidden),disabled:!column.hidden&&visibleColumnsCount<=1,onChange:()=>{const newState={...state,columns:state.columns.map(currentColumn=>{if(currentColumn.columnId===accessor){return{...currentColumn,hidden:!column.hidden}}else{return currentColumn}})};setState(newState)}})))}const datatableVisualization={id:"lnsDatatable",visualizationTypes:[{id:"lnsDatatable",icon:LensIconChartDatatable,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.label",{defaultMessage:"Data table"})}],getVisualizationTypeId(){return"lnsDatatable"},getLayerIds(state){return[state.layerId]},clearLayer(state){return{...state,columns:[]}},getDescription(){return{icon:LensIconChartDatatable,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.label",{defaultMessage:"Data table"})}},switchVisualizationType:(_,state)=>state,initialize(frame,state){return state||{columns:[],layerId:frame.addNewLayer()}},getSuggestions({table:table,state:state,keptLayerIds:keptLayerIds}){if(keptLayerIds.length>1||keptLayerIds.length&&table.layerId!==keptLayerIds[0]||state&&table.changeType==="unchanged"){return[]}const oldColumnSettings={};if(state){state.columns.forEach(column=>{oldColumnSettings[column.columnId]=column})}const title=table.changeType==="unchanged"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.suggestionLabel",{defaultMessage:"As table"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.visualizationOf",{defaultMessage:"Table {operations}",values:{operations:table.label||table.columns.map(col=>col.operation.label).join(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.conjunctionSign",{defaultMessage:" & ",description:"A character that can be used for conjunction of multiple enumarated items. Make sure to include spaces around it if needed."}))}});return[{title:title,score:Math.min(table.columns.length,10)/10*.4,state:{...state||{},layerId:table.layerId,columns:table.columns.map(col=>({...oldColumnSettings[col.columnId]||{},columnId:col.columnId}))},previewIcon:LensIconChartDatatable,hide:true}]},getConfiguration({state:state,frame:frame,layerId:layerId}){const{sortedColumns:sortedColumns,datasource:datasource}=getDataSourceAndSortedColumns(state,frame.datasourceLayers,layerId)||{};const columnMap={};state.columns.forEach(column=>{columnMap[column.columnId]=column});if(!sortedColumns){return{groups:[]}}return{groups:[{groupId:"columns",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.breakdown",{defaultMessage:"Break down by"}),layerId:state.layerId,accessors:sortedColumns.filter(c=>{var _getOperationForColum;return(_getOperationForColum=datasource.getOperationForColumnId(c))===null||_getOperationForColum===void 0?void 0:_getOperationForColum.isBucketed}).map(accessor=>({columnId:accessor,triggerIcon:columnMap[accessor].hidden?"invisible":undefined})),supportsMoreColumns:true,filterOperations:op=>op.isBucketed,dataTestSubj:"lnsDatatable_column",enableDimensionEditor:true},{groupId:"metrics",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatable.metrics",{defaultMessage:"Metrics"}),layerId:state.layerId,accessors:sortedColumns.filter(c=>{var _getOperationForColum2;return!((_getOperationForColum2=datasource.getOperationForColumnId(c))!==null&&_getOperationForColum2!==void 0&&_getOperationForColum2.isBucketed)}).map(accessor=>({columnId:accessor,triggerIcon:columnMap[accessor].hidden?"invisible":undefined})),supportsMoreColumns:true,filterOperations:op=>!op.isBucketed,required:true,dataTestSubj:"lnsDatatable_metrics",enableDimensionEditor:true}]}},setDimension({prevState:prevState,columnId:columnId}){if(prevState.columns.some(column=>column.columnId===columnId)){return prevState}return{...prevState,columns:[...prevState.columns,{columnId:columnId}]}},removeDimension({prevState:prevState,columnId:columnId}){var _prevState$sorting;return{...prevState,columns:prevState.columns.filter(column=>column.columnId!==columnId),sorting:((_prevState$sorting=prevState.sorting)===null||_prevState$sorting===void 0?void 0:_prevState$sorting.columnId)===columnId?undefined:prevState.sorting}},renderDimensionEditor(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(TableDimensionEditor,props)),domElement)},toExpression(state,datasourceLayers,{title:title,description:description}={}){var _state$sorting,_state$sorting2;const{sortedColumns:sortedColumns,datasource:datasource}=getDataSourceAndSortedColumns(state,datasourceLayers,state.layerId)||{};if(sortedColumns!==null&&sortedColumns!==void 0&&sortedColumns.length&&sortedColumns.filter(c=>{var _getOperationForColum3;return!((_getOperationForColum3=datasource.getOperationForColumnId(c))!==null&&_getOperationForColum3!==void 0&&_getOperationForColum3.isBucketed)}).length===0){return null}const columnMap={};state.columns.forEach(column=>{columnMap[column.columnId]=column});const columns=sortedColumns.filter(columnId=>datasource.getOperationForColumnId(columnId)).map(columnId=>columnMap[columnId]);return{type:"expression",chain:[{type:"function",function:"lens_datatable",arguments:{title:[title||""],description:[description||""],columns:columns.map(column=>({type:"expression",chain:[{type:"function",function:"lens_datatable_column",arguments:{columnId:[column.columnId],hidden:typeof column.hidden==="undefined"?[]:[column.hidden],width:typeof column.width==="undefined"?[]:[column.width],alignment:typeof column.alignment==="undefined"?[]:[column.alignment]}}]})),sortingColumnId:[((_state$sorting=state.sorting)===null||_state$sorting===void 0?void 0:_state$sorting.columnId)||""],sortingDirection:[((_state$sorting2=state.sorting)===null||_state$sorting2===void 0?void 0:_state$sorting2.direction)||"none"]}}]}},getErrorMessages(state){return undefined},onEditAction(state,event){switch(event.data.action){case"sort":return{...state,sorting:{columnId:event.data.columnId,direction:event.data.direction}};case"toggle":return{...state,columns:state.columns.map(column=>{if(column.columnId===event.data.columnId){return{...column,hidden:!column.hidden}}else{return column}})};case"resize":const targetWidth=event.data.width;return{...state,columns:state.columns.map(column=>{if(column.columnId===event.data.columnId){return{...column,width:targetWidth}}else{return column}})};default:return state}}};function getDataSourceAndSortedColumns(state,datasourceLayers,layerId){const datasource=datasourceLayers[state.layerId];const originalOrder=datasource.getTableSpec().map(({columnId:columnId})=>columnId);const sortedColumns=Array.from(new Set(originalOrder.concat(state.columns.map(({columnId:columnId})=>columnId))));return{datasource:datasource,sortedColumns:sortedColumns}}var metric_visualization_expression=__webpack_require__(76);var external_kbnSharedDeps_Lodash_=__webpack_require__(20);var external_kbnSharedDeps_Lodash_default=__webpack_require__.n(external_kbnSharedDeps_Lodash_);function auto_scale_extends(){auto_scale_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return auto_scale_extends.apply(this,arguments)}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class auto_scale_AutoScale extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);_defineProperty(this,"child",null);_defineProperty(this,"parent",null);_defineProperty(this,"scale",void 0);_defineProperty(this,"setParent",el=>{if(el&&this.parent!==el){this.parent=el;setTimeout(()=>this.scale())}});_defineProperty(this,"setChild",el=>{if(el&&this.child!==el){this.child=el;setTimeout(()=>this.scale())}});this.scale=external_kbnSharedDeps_Lodash_default.a.throttle(()=>{const scale=computeScale(this.parent,this.child,this.props.minScale);if(this.state.scale!==scale){this.setState({scale:scale})}});this.state={scale:0}}render(){const{children:children,minScale:minScale,...rest}=this.props;const{scale:scale}=this.state;const style=this.props.style||{};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiResizeObserver"],{onResize:this.scale},resizeRef=>external_kbnSharedDeps_React_default.a.createElement("div",auto_scale_extends({},rest,{ref:el=>{this.setParent(el);resizeRef(el)},style:{...style,display:"flex",justifyContent:"center",alignItems:"center",maxWidth:"100%",maxHeight:"100%",overflow:"hidden",lineHeight:1.5}}),external_kbnSharedDeps_React_default.a.createElement("div",{ref:this.setChild,style:{transform:`scale(${scale})`}},children)))}}const MAX_SCALE=1;const MIN_SCALE=.3;function computeScale(parent,child,minScale=MIN_SCALE){if(!parent||!child){return 1}const scaleX=parent.clientWidth/child.clientWidth;const scaleY=parent.clientHeight/child.clientHeight;return Math.max(Math.min(MAX_SCALE,Math.min(scaleX,scaleY)),minScale)}function chart_metric_extends(){chart_metric_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_metric_extends.apply(this,arguments)}const LensIconChartMetric=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_metric_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M25 0a1 1 0 011 1v14a1 1 0 01-1 1H5a1 1 0 01-1-1V1a1 1 0 011-1h20zm-9.878 3c-1.887 0-3.265 1.107-3.26 2.61-.005 1.054.67 1.938 1.672 2.157v.067l-.155.03a2.453 2.453 0 00-1.879 2.394C11.495 11.84 12.997 13 15.122 13c2.105 0 3.612-1.16 3.617-2.742-.005-1.217-.903-2.234-2.035-2.424v-.067l.162-.042c.896-.275 1.507-1.12 1.511-2.116C18.373 4.112 16.994 3 15.122 3zm0 5.542c1.036 0 1.796.665 1.806 1.592-.01.898-.718 1.507-1.806 1.507-1.103 0-1.816-.609-1.806-1.507-.01-.932.755-1.592 1.806-1.592zm0-4.164c.908 0 1.53.561 1.54 1.398-.01.85-.651 1.43-1.54 1.43-.903 0-1.55-.584-1.54-1.43-.01-.837.618-1.398 1.54-1.398z",className:"lensChartIcon__accent"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M1 18h28a1 1 0 011 1v2a1 1 0 01-1 1H1a1 1 0 01-1-1v-2a1 1 0 011-1z",className:"lensChartIcon__subdued"}));function metric_visualization_expression_extends(){metric_visualization_expression_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return metric_visualization_expression_extends.apply(this,arguments)}const metricChart={name:"lens_metric_chart",type:"render",help:"A metric chart",args:{title:{types:["string"],help:"The chart title."},description:{types:["string"],help:""},metricTitle:{types:["string"],help:"The title of the metric shown."},accessor:{types:["string"],help:"The column whose value is being displayed"},mode:{types:["string"],options:["reduced","full"],default:"full",help:"The display mode of the chart - reduced will only show the metric itself without min size"}},inputTypes:["lens_multitable"],fn(data,args){return{type:"render",as:"lens_metric_chart_renderer",value:{data:data,args:args}}}};const getMetricChartRenderer=formatFactory=>({name:"lens_metric_chart_renderer",displayName:"Metric chart",help:"Metric chart renderer",validate:()=>undefined,reuseDomNode:true,render:async(domNode,config,handlers)=>{const resolvedFormatFactory=await formatFactory;external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(MetricChart,metric_visualization_expression_extends({},config,{formatFactory:resolvedFormatFactory}))),domNode,()=>{handlers.done()});handlers.onDestroy(()=>external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(domNode))}});function MetricChart({data:data,args:args,formatFactory:formatFactory}){var _column$meta,_column$meta2;const{metricTitle:metricTitle,title:title,description:description,accessor:accessor,mode:mode}=args;const firstTable=Object.values(data.tables)[0];if(!accessor){return external_kbnSharedDeps_React_default.a.createElement(VisualizationContainer,{reportTitle:title,reportDescription:description,className:"lnsMetricExpression__container"})}if(!firstTable){return external_kbnSharedDeps_React_default.a.createElement(EmptyPlaceholder,{icon:LensIconChartMetric})}const column=firstTable.columns[0];const row=firstTable.rows[0];const shouldShowResults=row[accessor]!=null;if(!shouldShowResults){return external_kbnSharedDeps_React_default.a.createElement(EmptyPlaceholder,{icon:LensIconChartMetric})}const value=column&&(_column$meta=column.meta)!==null&&_column$meta!==void 0&&_column$meta.params?formatFactory((_column$meta2=column.meta)===null||_column$meta2===void 0?void 0:_column$meta2.params).convert(row[accessor]):Number(Number(row[accessor]).toFixed(3)).toString();return external_kbnSharedDeps_React_default.a.createElement(VisualizationContainer,{reportTitle:title,reportDescription:description,className:"lnsMetricExpression__container"},external_kbnSharedDeps_React_default.a.createElement(auto_scale_AutoScale,null,external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"lns_metric_value",style:{fontSize:"60pt",fontWeight:600}},value),mode==="full"&&external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"lns_metric_title",style:{fontSize:"24pt"}},metricTitle)))}function getSuggestions({table:table,state:state,keptLayerIds:keptLayerIds}){if(table.isMultiRow||keptLayerIds.length>1||keptLayerIds.length&&table.layerId!==keptLayerIds[0]||table.columns.length!==1||table.columns[0].operation.dataType!=="number"){return[]}if(state&&table.changeType==="unchanged"){return[]}return[getSuggestion(table)]}function getSuggestion(table){const col=table.columns[0];const title=table.label||col.operation.label;return{title:title,score:.1,previewIcon:LensIconChartMetric,state:{layerId:table.layerId,accessor:col.columnId}}}const toExpression=(state,datasourceLayers,attributes)=>{if(!state.accessor){return null}const[datasource]=Object.values(datasourceLayers);const operation=datasource&&datasource.getOperationForColumnId(state.accessor);return{type:"expression",chain:[{type:"function",function:"lens_metric_chart",arguments:{title:[(attributes===null||attributes===void 0?void 0:attributes.title)||""],description:[(attributes===null||attributes===void 0?void 0:attributes.description)||""],metricTitle:[operation&&operation.label||""],accessor:[state.accessor],mode:[(attributes===null||attributes===void 0?void 0:attributes.mode)||"full"]}}]}};const metricVisualization={id:"lnsMetric",visualizationTypes:[{id:"lnsMetric",icon:LensIconChartMetric,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.metric.label",{defaultMessage:"Metric"})}],getVisualizationTypeId(){return"lnsMetric"},clearLayer(state){return{...state,accessor:undefined}},getLayerIds(state){return[state.layerId]},getDescription(){return{icon:LensIconChartMetric,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.metric.label",{defaultMessage:"Metric"})}},getSuggestions:getSuggestions,initialize(frame,state){return state||{layerId:frame.addNewLayer(),accessor:undefined}},getConfiguration(props){return{groups:[{groupId:"metric",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.metric.label",{defaultMessage:"Metric"}),layerId:props.state.layerId,accessors:props.state.accessor?[{columnId:props.state.accessor}]:[],supportsMoreColumns:!props.state.accessor,filterOperations:op=>!op.isBucketed&&op.dataType==="number"}]}},toExpression:toExpression,toPreviewExpression:(state,datasourceLayers)=>toExpression(state,datasourceLayers,{mode:"reduced"}),setDimension({prevState:prevState,columnId:columnId}){return{...prevState,accessor:columnId}},removeDimension({prevState:prevState}){return{...prevState,accessor:undefined}},getErrorMessages(state){return undefined}};function chart_donut_extends(){chart_donut_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_donut_extends.apply(this,arguments)}const LensIconChartDonut=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_donut_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M19.21 21.119a11 11 0 006.595-8.1c.11-.577-.355-1.082-.942-1.082H20.75c-.477 0-.878.342-1.046.788a5.028 5.028 0 11-6.474-6.474c.447-.168.788-.569.788-1.046V1.094c0-.588-.505-1.053-1.082-.943a11 11 0 106.272 20.968h.002z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M22.778 3.176A11 11 0 0017.084.154C16.507.042 16 .507 16 1.095v4.116c0 .475.34.875.784 1.044l.14.055A5.026 5.026 0 0119.7 9.17c.168.445.568.784 1.044.784h4.115c.588 0 1.053-.506.942-1.084a11 11 0 00-3.023-5.694z",className:"lensChartIcon__accent"}));function chart_pie_extends(){chart_pie_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_pie_extends.apply(this,arguments)}const LensIconChartPie=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_pie_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M17.827 21.189a10.001 10.001 0 005.952-7.148c.124-.578-.343-1.091-.935-1.091H14a1 1 0 01-1-1V3.106c0-.592-.513-1.059-1.092-.935a10 10 0 105.919 19.018z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M22.462 3.538A12.29 12.29 0 0016.094.16C15.512.048 15 .514 15 1.106V10a1 1 0 001 1h8.895c.591 0 1.057-.512.945-1.094a12.288 12.288 0 00-3.378-6.368z",className:"lensChartIcon__accent"}));function chart_treemap_extends(){chart_treemap_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_treemap_extends.apply(this,arguments)}const LensIconChartTreemap=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_treemap_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M0 1a1 1 0 011-1h13a1 1 0 011 1v20a1 1 0 01-1 1H1a1 1 0 01-1-1V1z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M17 1a1 1 0 011-1h11a1 1 0 011 1v12a1 1 0 01-1 1H18a1 1 0 01-1-1V1z",className:"lensChartIcon__accent"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 16H18a1 1 0 00-1 1v4a1 1 0 001 1h11a1 1 0 001-1v-4a1 1 0 00-1-1z",className:"lensChartIcon__subdued"}));const CHART_NAMES={donut:{icon:LensIconChartDonut,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.donutLabel",{defaultMessage:"Donut"})},pie:{icon:LensIconChartPie,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.pielabel",{defaultMessage:"Pie"})},treemap:{icon:LensIconChartTreemap,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.treemaplabel",{defaultMessage:"Treemap"})}};const MAX_PIE_BUCKETS=3;const MAX_TREEMAP_BUCKETS=2;const DEFAULT_PERCENT_DECIMALS=2;function getSliceValue(d,metricColumn){if(typeof d[metricColumn.id]==="number"&&d[metricColumn.id]!==0){return d[metricColumn.id]}return Number.EPSILON}function getFilterContext(clickedLayers,layerColumnIds,table){const matchingIndex=table.rows.findIndex(row=>clickedLayers.every((layer,index)=>{const columnId=layerColumnIds[index];return row[columnId]===layer.groupByRollup}));return{data:clickedLayers.map((clickedLayer,index)=>({column:table.columns.findIndex(col=>col.id===layerColumnIds[index]),row:matchingIndex,value:clickedLayer.groupByRollup,table:table}))}}var pie_visualization_visualization=__webpack_require__(85);const EMPTY_SLICE=Symbol("empty_slice");function PieComponent(props){var _chartTheme$barSeries,_chartTheme$barSeries2,_chartTheme$axes,_chartTheme$axes$axis,_chartTheme$lineSerie,_chartTheme$lineSerie2,_window$_echDebugStat;const[firstTable]=Object.values(props.data.tables);const formatters={};const{chartsThemeService:chartsThemeService,paletteService:paletteService,syncColors:syncColors,onClickValue:onClickValue}=props;const{shape:shape,groups:groups,metric:metric,numberDisplay:numberDisplay,categoryDisplay:categoryDisplay,legendDisplay:legendDisplay,legendPosition:legendPosition,nestedLegend:nestedLegend,percentDecimals:percentDecimals,hideLabels:hideLabels,palette:palette}=props.args;const chartTheme=chartsThemeService.useChartsTheme();const chartBaseTheme=chartsThemeService.useChartsBaseTheme();const isDarkMode=chartsThemeService.useDarkMode();if(!hideLabels){firstTable.columns.forEach(column=>{formatters[column.id]=props.formatFactory(column.meta.params)})}const fillLabel={textInvertible:true,valueFont:{fontWeight:700}};if(numberDisplay==="hidden"){fillLabel.valueFormatter=()=>""}const bucketColumns=firstTable.columns.filter(col=>groups.includes(col.id));const totalSeriesCount=Object(external_kbnSharedDeps_Lodash_["uniq"])(firstTable.rows.map(row=>bucketColumns.map(({id:columnId})=>row[columnId]).join(","))).length;const layers=bucketColumns.map((col,layerIndex)=>({groupByRollup:d=>{var _d$col$id;return(_d$col$id=d[col.id])!==null&&_d$col$id!==void 0?_d$col$id:EMPTY_SLICE},showAccessor:d=>d!==EMPTY_SLICE,nodeLabel:d=>{if(hideLabels||d===EMPTY_SLICE){return""}if(col.meta.params){var _formatters$col$id$co;return(_formatters$col$id$co=formatters[col.id].convert(d))!==null&&_formatters$col$id$co!==void 0?_formatters$col$id$co:""}return String(d)},fillLabel:fillLabel,shape:{fillColor:d=>{const seriesLayers=[];let tempParent=d;while(tempParent.parent&&tempParent.depth>0){seriesLayers.unshift({name:String(tempParent.parent.children[tempParent.sortIndex][0]),rankAtDepth:tempParent.sortIndex,totalSeriesAtDepth:tempParent.parent.children.length});tempParent=tempParent.parent}if(shape==="treemap"){if(layerIndex<bucketColumns.length-1){return isDarkMode?"rgba(0,0,0,0)":"rgba(255,255,255,0)"}if(seriesLayers.length>1){seriesLayers.pop()}}const outputColor=paletteService.get(palette.name).getColor(seriesLayers,{behindText:categoryDisplay!=="hide",maxDepth:bucketColumns.length,totalSeries:totalSeriesCount,syncColors:syncColors},palette.params);return outputColor||"rgba(0,0,0,0)"}}}));const config={partitionLayout:shape==="treemap"?external_kbnSharedDeps_ElasticCharts_["PartitionLayout"].treemap:external_kbnSharedDeps_ElasticCharts_["PartitionLayout"].sunburst,fontFamily:(_chartTheme$barSeries=chartTheme.barSeriesStyle)===null||_chartTheme$barSeries===void 0?void 0:(_chartTheme$barSeries2=_chartTheme$barSeries.displayValue)===null||_chartTheme$barSeries2===void 0?void 0:_chartTheme$barSeries2.fontFamily,outerSizeRatio:1,specialFirstInnermostSector:true,clockwiseSectors:false,minFontSize:10,maxFontSize:16,linkLabel:{maxCount:5,fontSize:11,textColor:(_chartTheme$axes=chartTheme.axes)===null||_chartTheme$axes===void 0?void 0:(_chartTheme$axes$axis=_chartTheme$axes.axisTitle)===null||_chartTheme$axes$axis===void 0?void 0:_chartTheme$axes$axis.fill},sectorLineStroke:(_chartTheme$lineSerie=chartTheme.lineSeriesStyle)===null||_chartTheme$lineSerie===void 0?void 0:(_chartTheme$lineSerie2=_chartTheme$lineSerie.point)===null||_chartTheme$lineSerie2===void 0?void 0:_chartTheme$lineSerie2.fill,sectorLineWidth:1.5,circlePadding:4};if(shape==="treemap"){if(hideLabels||categoryDisplay==="hide"){config.fillLabel={textColor:"rgba(0,0,0,0)"}}}else{config.emptySizeRatio=shape==="donut"?.3:0;if(hideLabels||categoryDisplay==="hide"){config.linkLabel={maxCount:0,maximumSection:Number.POSITIVE_INFINITY}}else if(categoryDisplay==="inside"){config.linkLabel={maxCount:0}}}const metricColumn=firstTable.columns.find(c=>c.id===metric);const percentFormatter=props.formatFactory({id:"percent",params:{pattern:`0,0.[${"0".repeat(percentDecimals!==null&&percentDecimals!==void 0?percentDecimals:DEFAULT_PERCENT_DECIMALS)}]%`}});const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({isReady:false});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setState({isReady:true})},[]);const hasNegative=firstTable.rows.some(row=>{const value=row[metricColumn.id];return typeof value==="number"&&value<0});const isEmpty=firstTable.rows.length===0||firstTable.rows.every(row=>groups.every(colId=>!row[colId]||typeof row[colId]==="undefined"));if(isEmpty){return external_kbnSharedDeps_React_default.a.createElement(EmptyPlaceholder,{icon:LensIconChartDonut})}if(hasNegative){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:"lnsChart__empty",textAlign:"center",color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.pie.pieWithNegativeWarningLabel",defaultMessage:"{chartType} charts can't render with negative values. Try a different chart type.",values:{chartType:CHART_NAMES[shape].label}}))}const onElementClickHandler=args=>{const context=getFilterContext(args[0][0],groups,firstTable);onClickValue(desanitizeFilterContext(context))};return external_kbnSharedDeps_React_default.a.createElement(VisualizationContainer,{reportTitle:props.args.title,reportDescription:props.args.description,className:"lnsPieExpression__container",isReady:state.isReady},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{debugState:(_window$_echDebugStat=window._echDebugStateFlag)!==null&&_window$_echDebugStat!==void 0?_window$_echDebugStat:false,showLegend:!hideLabels&&(legendDisplay==="show"||legendDisplay==="default"&&bucketColumns.length>1&&shape!=="treemap"),legendPosition:legendPosition||external_kbnSharedDeps_ElasticCharts_["Position"].Right,legendMaxDepth:nestedLegend?undefined:1,onElementClick:props.renderMode!=="noInteractivity"?onElementClickHandler:undefined,theme:{...chartTheme,background:{...chartTheme.background,color:undefined}},baseTheme:chartBaseTheme}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Partition"],{id:shape,data:firstTable.rows,valueAccessor:d=>getSliceValue(d,metricColumn),percentFormatter:d=>percentFormatter.convert(d/100),valueGetter:hideLabels||numberDisplay==="value"?undefined:"percent",valueFormatter:d=>hideLabels?"":formatters[metricColumn.id].convert(d),layers:layers,config:config,topGroove:hideLabels||categoryDisplay==="hide"?0:undefined})))}function pie_visualization_expression_extends(){pie_visualization_expression_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return pie_visualization_expression_extends.apply(this,arguments)}const pie={name:"lens_pie",type:"render",help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.expressionHelpLabel",{defaultMessage:"Pie renderer"}),args:{title:{types:["string"],help:"The chart title."},description:{types:["string"],help:""},groups:{types:["string"],multi:true,help:""},metric:{types:["string"],help:""},shape:{types:["string"],options:["pie","donut","treemap"],help:""},hideLabels:{types:["boolean"],help:""},numberDisplay:{types:["string"],options:["hidden","percent","value"],help:""},categoryDisplay:{types:["string"],options:["default","inside","hide"],help:""},legendDisplay:{types:["string"],options:["default","show","hide"],help:""},nestedLegend:{types:["boolean"],help:""},legendPosition:{types:["string"],options:[external_kbnSharedDeps_ElasticCharts_["Position"].Top,external_kbnSharedDeps_ElasticCharts_["Position"].Right,external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,external_kbnSharedDeps_ElasticCharts_["Position"].Left],help:""},percentDecimals:{types:["number"],help:""},palette:{default:`{theme "palette" default={system_palette name="default"} }`,help:"",types:["palette"]}},inputTypes:["lens_multitable"],fn(data,args){return{type:"render",as:"lens_pie_renderer",value:{data:data,args:args}}}};const getPieRenderer=dependencies=>({name:"lens_pie_renderer",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.visualizationName",{defaultMessage:"Pie"}),help:"",validate:()=>undefined,reuseDomNode:true,render:async(domNode,config,handlers)=>{const onClickValue=data=>{handlers.event({name:"filter",data:data})};const formatFactory=await dependencies.formatFactory;external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(MemoizedChart,pie_visualization_expression_extends({},config,{formatFactory:formatFactory,chartsThemeService:dependencies.chartsThemeService,paletteService:dependencies.paletteService,onClickValue:onClickValue,renderMode:handlers.getRenderMode(),syncColors:handlers.isSyncColorsEnabled()}))),domNode,()=>{handlers.done()});handlers.onDestroy(()=>external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(domNode))}});const MemoizedChart=external_kbnSharedDeps_React_default.a.memo(PieComponent);function to_expression_toExpression(state,datasourceLayers,paletteService,attributes={}){return expressionHelper(state,datasourceLayers,paletteService,{...attributes,isPreview:false})}function expressionHelper(state,datasourceLayers,paletteService,attributes={isPreview:false}){var _layer$percentDecimal;const layer=state.layers[0];const datasource=datasourceLayers[layer.layerId];const operations=layer.groups.map(columnId=>({columnId:columnId,operation:datasource.getOperationForColumnId(columnId)})).filter(o=>!!o.operation);if(!layer.metric||!operations.length){return null}return{type:"expression",chain:[{type:"function",function:"lens_pie",arguments:{title:[attributes.title||""],description:[attributes.description||""],shape:[state.shape],hideLabels:[attributes.isPreview],groups:operations.map(o=>o.columnId),metric:[layer.metric],numberDisplay:[layer.numberDisplay],categoryDisplay:[layer.categoryDisplay],legendDisplay:[layer.legendDisplay],legendPosition:[layer.legendPosition||"right"],percentDecimals:[(_layer$percentDecimal=layer.percentDecimals)!==null&&_layer$percentDecimal!==void 0?_layer$percentDecimal:DEFAULT_PERCENT_DECIMALS],nestedLegend:[!!layer.nestedLegend],...state.palette?{palette:[{type:"expression",chain:[{type:"function",function:"theme",arguments:{variable:["palette"],default:[paletteService.get(state.palette.name).toExpression(state.palette.params)]}}]}]}:{}}}]}}function toPreviewExpression(state,datasourceLayers,paletteService){return expressionHelper(state,datasourceLayers,paletteService,{isPreview:true})}function shouldReject({table:table,keptLayerIds:keptLayerIds}){return keptLayerIds.length>1||keptLayerIds.length&&table.layerId!==keptLayerIds[0]||table.changeType==="reorder"||table.columns.some(col=>col.operation.scale==="interval")}function suggestions_suggestions({table:table,state:state,keptLayerIds:keptLayerIds,mainPalette:mainPalette,subVisualizationId:subVisualizationId}){if(shouldReject({table:table,state:state,keptLayerIds:keptLayerIds})){return[]}const[groups,metrics]=Object(external_kbnSharedDeps_Lodash_["partition"])(table.columns,col=>col.operation.isBucketed);if(metrics.length>1||groups.length>Math.max(MAX_PIE_BUCKETS,MAX_TREEMAP_BUCKETS)){return[]}const incompleteConfiguration=metrics.length===0||groups.length===0;const metricColumnId=metrics.length>0?metrics[0].columnId:undefined;if(incompleteConfiguration&&state&&!subVisualizationId){return[]}const results=[];if(groups.length<=MAX_PIE_BUCKETS){let newShape="donut";if(groups.length!==1){newShape="pie"}const baseSuggestion={title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.suggestionLabel",{defaultMessage:"As {chartName}",values:{chartName:CHART_NAMES[newShape].label},description:"chartName is already translated"}),score:state&&state.shape!=="treemap"?.6:.4,state:{shape:newShape,palette:mainPalette||(state===null||state===void 0?void 0:state.palette),layers:[state!==null&&state!==void 0&&state.layers[0]?{...state.layers[0],layerId:table.layerId,groups:groups.map(col=>col.columnId),metric:metricColumnId}:{layerId:table.layerId,groups:groups.map(col=>col.columnId),metric:metricColumnId,numberDisplay:"percent",categoryDisplay:"default",legendDisplay:"default",nestedLegend:false}]},previewIcon:"bullseye",hide:table.changeType==="reduced"||state&&state.shape!=="treemap"};results.push(baseSuggestion);results.push({...baseSuggestion,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.suggestionLabel",{defaultMessage:"As {chartName}",values:{chartName:CHART_NAMES[newShape==="pie"?"donut":"pie"].label},description:"chartName is already translated"}),score:.1,state:{...baseSuggestion.state,shape:newShape==="pie"?"donut":"pie"},hide:true})}if(groups.length<=MAX_TREEMAP_BUCKETS){results.push({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.treemapSuggestionLabel",{defaultMessage:"As Treemap"}),score:(state===null||state===void 0?void 0:state.shape)==="treemap"?.7:.5,state:{shape:"treemap",palette:mainPalette||(state===null||state===void 0?void 0:state.palette),layers:[state!==null&&state!==void 0&&state.layers[0]?{...state.layers[0],layerId:table.layerId,groups:groups.map(col=>col.columnId),metric:metricColumnId,categoryDisplay:state.layers[0].categoryDisplay==="inside"?"default":state.layers[0].categoryDisplay}:{layerId:table.layerId,groups:groups.map(col=>col.columnId),metric:metricColumnId,numberDisplay:"percent",categoryDisplay:"default",legendDisplay:"default",nestedLegend:false}]},previewIcon:"bullseye",hide:table.changeType==="reduced"||!state||state&&state.shape==="treemap"})}return[...results].sort((a,b)=>a.score-b.score).map(suggestion=>({...suggestion,hide:incompleteConfiguration||suggestion.hide}))}var toolbar=__webpack_require__(94);var useDebounce=__webpack_require__(38);var useDebounce_default=__webpack_require__.n(useDebounce);const numberOptions=[{value:"hidden",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.hiddenNumbersLabel",{defaultMessage:"Hide from chart"})},{value:"percent",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.showPercentValuesLabel",{defaultMessage:"Show percent"})},{value:"value",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.showFormatterValuesLabel",{defaultMessage:"Show value"})}];const categoryOptions=[{value:"default",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.showCategoriesLabel",{defaultMessage:"Inside or outside"})},{value:"inside",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.fitInsideOnlyLabel",{defaultMessage:"Inside only"})},{value:"hide",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.categoriesInLegendLabel",{defaultMessage:"Hide labels"})}];const categoryOptionsTreemap=[{value:"default",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.showTreemapCategoriesLabel",{defaultMessage:"Show labels"})},{value:"hide",inputDisplay:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.categoriesInLegendLabel",{defaultMessage:"Hide labels"})}];const toolbar_legendOptions=[{id:"pieLegendDisplay-default",value:"default",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.legendVisibility.auto",{defaultMessage:"Auto"})},{id:"pieLegendDisplay-show",value:"show",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.legendVisibility.show",{defaultMessage:"Show"})},{id:"pieLegendDisplay-hide",value:"hide",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.legendVisibility.hide",{defaultMessage:"Hide"})}];function PieToolbar(props){var _layer$percentDecimal;const{state:state,setState:setState}=props;const layer=state.layers[0];if(!layer){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(ToolbarPopover,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.valuesLabel",{defaultMessage:"Labels"}),type:"labels",groupPosition:"left",buttonDataTestSubj:"lnsLabelsButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.labelPositionLabel",{defaultMessage:"Position"}),fullWidth:true,display:"columnCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperSelect"],{compressed:true,valueOfSelected:layer.categoryDisplay,options:state.shape==="treemap"?categoryOptionsTreemap:categoryOptions,onChange:option=>{setState({...state,layers:[{...layer,categoryDisplay:option}]})}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.numberLabels",{defaultMessage:"Values"}),fullWidth:true,display:"columnCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperSelect"],{compressed:true,disabled:layer.categoryDisplay==="hide",valueOfSelected:layer.categoryDisplay==="hide"?"hidden":layer.numberDisplay,options:numberOptions,onChange:option=>{setState({...state,layers:[{...layer,numberDisplay:option}]})}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pieChart.percentDecimalsLabel",{defaultMessage:"Maximum decimal places for percent"}),fullWidth:true,display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(DecimalPlaceSlider,{value:(_layer$percentDecimal=layer.percentDecimals)!==null&&_layer$percentDecimal!==void 0?_layer$percentDecimal:DEFAULT_PERCENT_DECIMALS,setValue:value=>setState({...state,layers:[{...layer,percentDecimals:value}]})}))),external_kbnSharedDeps_React_default.a.createElement(LegendSettingsPopover,{legendOptions:toolbar_legendOptions,mode:layer.legendDisplay,onDisplayChange:optionId=>{setState({...state,layers:[{...layer,legendDisplay:toolbar_legendOptions.find(({id:id})=>id===optionId).value}]})},position:layer.legendPosition,onPositionChange:id=>{setState({...state,layers:[{...layer,legendPosition:id}]})},renderNestedLegendSwitch:true,nestedLegend:!!layer.nestedLegend,onNestedLegendChange:()=>{setState({...state,layers:[{...layer,nestedLegend:!layer.nestedLegend}]})}}))}const DecimalPlaceSlider=({value:value,setValue:setValue})=>{const[localValue,setLocalValue]=Object(external_kbnSharedDeps_React_["useState"])(value);useDebounce_default()(()=>setValue(localValue),256,[localValue]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{"data-test-subj":"indexPattern-dimension-formatDecimals",value:localValue,min:0,max:10,showInput:true,compressed:true,onChange:e=>{setLocalValue(Number(e.currentTarget.value))}})};function DimensionEditor(props){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(PalettePicker,{palettes:props.paletteService,activePalette:props.state.palette,setPalette:newPalette=>{props.setState({...props.state,palette:newPalette})}}))}function visualization_extends(){visualization_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return visualization_extends.apply(this,arguments)}function newLayerState(layerId){return{layerId:layerId,groups:[],metric:undefined,numberDisplay:"percent",categoryDisplay:"default",legendDisplay:"default",nestedLegend:false}}const bucketedOperations=op=>op.isBucketed;const numberMetricOperations=op=>!op.isBucketed&&op.dataType==="number";const getPieVisualization=({paletteService:paletteService})=>({id:"lnsPie",visualizationTypes:[{id:"donut",icon:CHART_NAMES.donut.icon,label:CHART_NAMES.donut.label},{id:"pie",icon:CHART_NAMES.pie.icon,label:CHART_NAMES.pie.label},{id:"treemap",icon:CHART_NAMES.treemap.icon,label:CHART_NAMES.treemap.label}],getVisualizationTypeId(state){return state.shape},getLayerIds(state){return state.layers.map(l=>l.layerId)},clearLayer(state){return{shape:state.shape,layers:state.layers.map(l=>newLayerState(l.layerId))}},getDescription(state){if(state.shape==="treemap"){return CHART_NAMES.treemap}if(state.shape==="donut"){return CHART_NAMES.donut}return CHART_NAMES.pie},switchVisualizationType:(visualizationTypeId,state)=>({...state,shape:visualizationTypeId}),initialize(frame,state,mainPalette){return state||{shape:"donut",layers:[newLayerState(frame.addNewLayer())],palette:mainPalette}},getMainPalette:state=>state?state.palette:undefined,getSuggestions:suggestions_suggestions,getConfiguration({state:state,frame:frame,layerId:layerId}){const layer=state.layers.find(l=>l.layerId===layerId);if(!layer){return{groups:[]}}const datasource=frame.datasourceLayers[layer.layerId];const originalOrder=datasource.getTableSpec().map(({columnId:columnId})=>columnId).filter(columnId=>columnId!==layer.metric);const sortedColumns=Array.from(new Set(originalOrder.concat(layer.groups))).map(accessor=>({columnId:accessor}));if(sortedColumns.length>0){var _state$palette,_state$palette2;sortedColumns[0]={columnId:sortedColumns[0].columnId,triggerIcon:"colorBy",palette:paletteService.get(((_state$palette=state.palette)===null||_state$palette===void 0?void 0:_state$palette.name)||"default").getColors(10,(_state$palette2=state.palette)===null||_state$palette2===void 0?void 0:_state$palette2.params)}}if(state.shape==="treemap"){return{groups:[{groupId:"groups",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.treemapGroupLabel",{defaultMessage:"Group by"}),layerId:layerId,accessors:sortedColumns,supportsMoreColumns:sortedColumns.length<MAX_TREEMAP_BUCKETS,filterOperations:bucketedOperations,required:true,dataTestSubj:"lnsPie_groupByDimensionPanel",enableDimensionEditor:true},{groupId:"metric",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.groupsizeLabel",{defaultMessage:"Size by"}),layerId:layerId,accessors:layer.metric?[{columnId:layer.metric}]:[],supportsMoreColumns:!layer.metric,filterOperations:numberMetricOperations,required:true,dataTestSubj:"lnsPie_sizeByDimensionPanel"}]}}return{groups:[{groupId:"groups",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.sliceGroupLabel",{defaultMessage:"Slice by"}),layerId:layerId,accessors:sortedColumns,supportsMoreColumns:sortedColumns.length<MAX_PIE_BUCKETS,filterOperations:bucketedOperations,required:true,dataTestSubj:"lnsPie_sliceByDimensionPanel",enableDimensionEditor:true},{groupId:"metric",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pie.groupsizeLabel",{defaultMessage:"Size by"}),layerId:layerId,accessors:layer.metric?[{columnId:layer.metric}]:[],supportsMoreColumns:!layer.metric,filterOperations:numberMetricOperations,required:true,dataTestSubj:"lnsPie_sizeByDimensionPanel"}]}},setDimension({prevState:prevState,layerId:layerId,columnId:columnId,groupId:groupId}){return{...prevState,layers:prevState.layers.map(l=>{if(l.layerId!==layerId){return l}if(groupId==="groups"){return{...l,groups:[...l.groups,columnId]}}return{...l,metric:columnId}})}},removeDimension({prevState:prevState,layerId:layerId,columnId:columnId}){return{...prevState,layers:prevState.layers.map(l=>{if(l.layerId!==layerId){return l}if(l.metric===columnId){return{...l,metric:undefined}}return{...l,groups:l.groups.filter(c=>c!==columnId)}})}},renderDimensionEditor(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(DimensionEditor,visualization_extends({},props,{paletteService:paletteService}))),domElement)},toExpression:(state,layers,attributes)=>to_expression_toExpression(state,layers,paletteService,attributes),toPreviewExpression:(state,layers)=>toPreviewExpression(state,layers,paletteService),renderToolbar(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(PieToolbar,props)),domElement)},getWarningMessages(state,frame){if((state===null||state===void 0?void 0:state.layers.length)===0||!frame.activeData){return}const metricColumnsWithArrayValues=[];for(const layer of state.layers){var _frame$datasourceLaye;const{layerId:layerId,metric:metric}=layer;const rows=frame.activeData[layerId]&&frame.activeData[layerId].rows;if(!rows||!metric){break}const columnToLabel=(_frame$datasourceLaye=frame.datasourceLayers[layerId].getOperationForColumnId(metric))===null||_frame$datasourceLaye===void 0?void 0:_frame$datasourceLaye.label;const hasArrayValues=rows.some(row=>Array.isArray(row[metric]));if(hasArrayValues){metricColumnsWithArrayValues.push(columnToLabel||metric)}}return metricColumnsWithArrayValues.map(label=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,label)," contains array values. Your visualization may not render as expected."))},getErrorMessages(state){return undefined}});var xy_visualization_expression=__webpack_require__(104);function chart_area_extends(){chart_area_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_area_extends.apply(this,arguments)}const LensIconChartArea=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_area_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M30 6v15a1 1 0 01-1 1H1a1 1 0 01-1-1v-2c1 0 3.5-4 6-4s5 3 6 3 3.23-6.994 5.865-6.997C20.5 11 23 11 24 11s3-5 6-5z",className:"lensChartIcon__accent"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M6 1c3 0 5 6 6 6s3.5-3 6-3c1.667 0 2.944 2.333 3.833 6.999l.309.001c-1.013 0-2.27 0-3.593.002h-.684C15.231 11.007 13 18 12 18s-3.5-3-6-3-5 4-6 4V7c1-1.5 3-6 6-6z",className:"lensChartIcon__subdued"}));function chart_area_stacked_extends(){chart_area_stacked_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_area_stacked_extends.apply(this,arguments)}const LensIconChartAreaStacked=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_area_stacked_extends({viewBox:"0 0 30 22",width:31,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M0 15.213l.484.091.813.146.762.129C3.779 15.859 5.09 16 6 16c.986 0 1.712-.25 3.166-.966l.281-.14C10.802 14.217 11.381 14 12 14c.507 0 .988.146 1.89.571l1.209.592c1.28.617 1.977.837 2.901.837 1.028 0 1.75-.349 3.119-1.344l.89-.659C23.034 13.252 23.535 13 24 13c.581 0 1.232.185 2.598.718l1.1.436.568.217c.72.27 1.256.438 1.736.532L30 21a1 1 0 01-1 1H1a1 1 0 01-1-1v-5.787z",className:"lensChartIcon__accent"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M24 1c1.334 0 3.334 1 6 3v8.842l-.324-.098c-.346-.11-.759-.262-1.273-.462l-1.101-.436-.568-.217-.536-.193C25.277 11.118 24.676 11 24 11c-1.028 0-1.75.349-3.119 1.344l-.89.659c-1.024.745-1.524.997-1.99.997-.508 0-.989-.146-1.89-.571l-1.21-.592c-1.28-.617-1.977-.837-2.9-.837-.987 0-1.713.25-3.167.966l-.281.14C7.198 13.783 6.619 14 6 14l-.334-.007c-1.182-.045-3.08-.317-5.665-.815V9c2 0 4.666 1 6 1 2 0 4-4 6-4s4 1 6 1 4-6 6-6z",className:"lensChartIcon__subdued"}));function chart_area_percentage_extends(){chart_area_percentage_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_area_percentage_extends.apply(this,arguments)}const LensIconChartAreaPercentage=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_area_percentage_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M0 13v8a1 1 0 001 1h28a1 1 0 001-1V9.25c-1.251-.929-2.45-1.734-3.493-2.313a11.028 11.028 0 00-1.478-.703C24.592 6.072 24.25 6 24 6c-.262 0-.63.212-1.126.77-.472.53-.952 1.249-1.458 2.007l-.013.02c-.49.736-1.006 1.51-1.53 2.098C19.37 11.462 18.739 12 18 12c-1.062 0-2.112-.263-3.092-.508l-.03-.007C13.869 11.232 12.929 11 12 11c-.337 0-.729.171-1.2.525-.466.35-.94.822-1.446 1.329l-.015.015c-.49.489-1.01 1.01-1.539 1.406-.529.396-1.137.725-1.8.725-.657 0-1.57-.212-2.48-.424l-.058-.014C2.275 14.287 1.032 14 0 14v-1z",className:"lensChartIcon__accent"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 0a1 1 0 011 1v6.012c-1.06-.764-2.085-1.437-3.007-1.95a11.93 11.93 0 00-1.616-.765C24.887 4.115 24.418 4 24 4c-.738 0-1.369.538-1.874 1.105-.523.589-1.039 1.362-1.529 2.098l-.013.02c-.506.758-.985 1.476-1.458 2.007-.495.558-.864.77-1.126.77-.928 0-1.867-.232-2.879-.485l-.029-.007C14.112 9.263 13.062 9 12 9c-.663 0-1.271.328-1.8.725-.528.396-1.05.917-1.538 1.406l-.015.015c-.507.507-.98.98-1.447 1.329-.471.354-.863.525-1.2.525-.528 0-1.328-.183-2.311-.412l-.034-.007C2.507 12.314 1.159 12 .001 12V1a1 1 0 011-1h28z",className:"lensChartIcon__subdued"}));function chart_bar_extends(){chart_bar_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_bar_extends.apply(this,arguments)}const LensIconChartBar=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_bar_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M5 7a1 1 0 011 1v13a1 1 0 01-1 1H1a1 1 0 01-1-1V8a1 1 0 011-1h4zm16-7a1 1 0 011 1v20a1 1 0 01-1 1h-4a1 1 0 01-1-1V1a1 1 0 011-1h4z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M13 11a1 1 0 011 1v9a1 1 0 01-1 1H9a1 1 0 01-1-1v-9a1 1 0 011-1h4zm16-7a1 1 0 011 1v16a1 1 0 01-1 1h-4a1 1 0 01-1-1V5a1 1 0 011-1h4z",className:"lensChartIcon__accent"}));function chart_bar_stacked_extends(){chart_bar_stacked_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_bar_stacked_extends.apply(this,arguments)}const LensIconChartBarStacked=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_bar_stacked_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{className:"lensChartIcon__subdued",d:"M6 13v8a1 1 0 01-1 1H1a1 1 0 01-1-1v-8h6zm8-4v12a1 1 0 01-1 1H9a1 1 0 01-1-1V9h6zm8 4v8a1 1 0 01-1 1h-4a1 1 0 01-1-1v-8h6zm8 1v7a1 1 0 01-1 1h-4a1 1 0 01-1-1v-7h6z"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 1a1 1 0 011 1v10h-6V2a1 1 0 011-1h4zM5 7a1 1 0 011 1v3H0V8a1 1 0 011-1h4zm16-4a1 1 0 011 1v7h-6V4a1 1 0 011-1h4zm-8-3a1 1 0 011 1v6H8V1a1 1 0 011-1h4z",className:"lensChartIcon__accent"}));function chart_bar_percentage_extends(){chart_bar_percentage_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_bar_percentage_extends.apply(this,arguments)}const LensIconChartBarPercentage=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_bar_percentage_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M6 13v8a1 1 0 01-1 1H1a1 1 0 01-1-1v-8h6zm8-4v12a1 1 0 01-1 1H9a1 1 0 01-1-1V9h6zm8 4v8a1 1 0 01-1 1h-4a1 1 0 01-1-1v-8h6zm8 1v7a1 1 0 01-1 1h-4a1 1 0 01-1-1v-7h6z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 0a1 1 0 011 1v11h-6V1a1 1 0 011-1h4zM5 0a1 1 0 011 1v10H0V1a1 1 0 011-1h4zm16 0a1 1 0 011 1v10h-6V1a1 1 0 011-1h4zm-8 0a1 1 0 011 1v6H8V1a1 1 0 011-1h4z",className:"lensChartIcon__accent"}));function chart_bar_horizontal_extends(){chart_bar_horizontal_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_bar_horizontal_extends.apply(this,arguments)}const LensIconChartBarHorizontal=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_bar_horizontal_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 16a1 1 0 011 1v4a1 1 0 01-1 1H1a1 1 0 01-1-1v-4a1 1 0 011-1h28zM22 0a1 1 0 011 1v4a1 1 0 01-1 1H1a1 1 0 01-1-1V1a1 1 0 011-1h21z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M0 9a1 1 0 011-1h15a1 1 0 011 1v4a1 1 0 01-1 1H1a1 1 0 01-1-1V9z",className:"lensChartIcon__accent"}));function chart_bar_horizontal_stacked_extends(){chart_bar_horizontal_stacked_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_bar_horizontal_stacked_extends.apply(this,arguments)}const LensIconChartBarHorizontalStacked=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_bar_horizontal_stacked_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M18 16v6H1a1 1 0 01-1-1v-4a1 1 0 011-1h17zm-3-8v6H1.222C.547 14 0 13.552 0 13V9c0-.552.547-1 1.222-1H15zm1-8v6H1.042C.466 6 0 5.552 0 5V1c0-.552.466-1 1.042-1H16z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 16a1 1 0 011 1v4a1 1 0 01-1 1h-9v-6h9zm-9.222-8C20.453 8 21 8.448 21 9v4c0 .552-.547 1-1.222 1H17V8h2.778zm3.18-8C23.534 0 24 .448 24 1v4c0 .552-.466 1-1.042 1H18V0h4.958z",className:"lensChartIcon__accent"}));function chart_bar_horizontal_percentage_extends(){chart_bar_horizontal_percentage_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_bar_horizontal_percentage_extends.apply(this,arguments)}const LensIconChartBarHorizontalPercentage=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_bar_horizontal_percentage_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M20 16v6H1a1 1 0 01-1-1v-4a1 1 0 011-1h19zm-3-8v6H1.222C.547 14 0 13.552 0 13V9c0-.552.547-1 1.222-1H17zm1-8v6H1.042C.466 6 0 5.552 0 5V1c0-.552.466-1 1.042-1H18z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M29 16a1 1 0 011 1v4a1 1 0 01-1 1h-7v-6h7zm-.222-8C29.453 8 30 8.448 30 9v4c0 .552-.547 1-1.222 1H19V8h9.778zm.18-8C29.534 0 30 .448 30 1v4c0 .552-.466 1-1.042 1H20V0h8.958z",className:"lensChartIcon__accent"}));function chart_line_extends(){chart_line_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_line_extends.apply(this,arguments)}const LensIconChartLine=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_line_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M23.434 16.456c.211.553.406.982.58 1.277l.073.119c.038.058.072.105.101.141.52-.04 1.07-.248 2.13-.77l.235-.117C28.198 16.283 28.953 16 30 16v2c-.507 0-.988.146-1.89.571l-1.209.592C25.621 19.78 24.924 20 24 20l-.174-.005c-1.251-.076-1.805-1.036-2.994-4.993L22.93 15c.18.563.335 1.012.505 1.455zM6 1c1.269 0 1.966.69 3.492 2.939l.774 1.146.272.387.26.358C11.419 6.658 11.788 7 12 7c.466 0 .967-.252 1.99-.997l.891-.659.458-.325C16.424 4.272 17.093 4 18 4c1.377 0 1.925.863 3.168 4.999L19.07 9a26.766 26.766 0 00-.505-1.457c-.24-.631-.46-1.1-.652-1.395l-.051-.074-.045-.06c-.452.064-.988.375-2.007 1.13l-.691.512-.458.325C13.576 8.728 12.907 9 12 9c-1.269 0-1.966-.69-3.492-2.939l-.774-1.146-.272-.387-.26-.358C6.581 3.342 6.213 3 6 3c-.294 0-.885.651-2.017 2.33l-.491.731-.326.475C1.859 8.409 1.175 9 0 9V7c.294 0 .885-.651 2.017-2.33l.491-.731.326-.475C4.141 1.591 4.825 1 6 1z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M0 21c1.123 0 1.852-.477 3.295-1.885l.758-.75.345-.33C5.208 17.275 5.648 17 6 17c.466 0 .967.252 1.99.997l.891.659.458.325C10.424 19.728 11.093 20 12 20c1.325 0 1.996-.772 3.546-3.444l.593-1.028.385-.646C17.328 13.562 17.796 13 18 13h6c1.333 0 1.978-.795 3.452-3.676l.692-1.37.358-.69C29.333 5.7 29.831 5 30 5V3c-1.333 0-1.978.795-3.452 3.676l-.692 1.37-.358.69C24.667 10.3 24.169 11 24 11h-6c-1.325 0-1.996.772-3.546 3.444l-.593 1.028-.385.646C12.672 17.438 12.204 18 12 18c-.466 0-.967-.252-1.99-.997l-.891-.659-.458-.325C7.576 15.272 6.907 15 6 15c-1.123 0-1.852.477-3.295 1.885l-.758.75-.345.33C.792 18.725.352 19 0 19v2z",className:"lensChartIcon__accent"}));const legendConfig={name:"lens_xy_legendConfig",aliases:[],type:"lens_xy_legendConfig",help:`Configure the xy chart's legend`,inputTypes:["null"],args:{isVisible:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.isVisible.help",{defaultMessage:"Specifies whether or not the legend is visible."})},position:{types:["string"],options:[external_kbnSharedDeps_ElasticCharts_["Position"].Top,external_kbnSharedDeps_ElasticCharts_["Position"].Right,external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,external_kbnSharedDeps_ElasticCharts_["Position"].Left],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.position.help",{defaultMessage:"Specifies the legend position."})},showSingleSeries:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.showSingleSeries.help",{defaultMessage:"Specifies whether a legend with just a single entry should be shown"})}},fn:function fn(input,args){return{type:"lens_xy_legendConfig",...args}}};const tickLabelsConfig={name:"lens_xy_tickLabelsConfig",aliases:[],type:"lens_xy_tickLabelsConfig",help:`Configure the xy chart's tick labels appearance`,inputTypes:["null"],args:{x:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.xAxisTickLabels.help",{defaultMessage:"Specifies whether or not the tick labels of the x-axis are visible."})},yLeft:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yLeftAxisTickLabels.help",{defaultMessage:"Specifies whether or not the tick labels of the left y-axis are visible."})},yRight:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yRightAxisTickLabels.help",{defaultMessage:"Specifies whether or not the tick labels of the right y-axis are visible."})}},fn:function fn(input,args){return{type:"lens_xy_tickLabelsConfig",...args}}};const gridlinesConfig={name:"lens_xy_gridlinesConfig",aliases:[],type:"lens_xy_gridlinesConfig",help:`Configure the xy chart's gridlines appearance`,inputTypes:["null"],args:{x:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.xAxisGridlines.help",{defaultMessage:"Specifies whether or not the gridlines of the x-axis are visible."})},yLeft:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yLeftAxisgridlines.help",{defaultMessage:"Specifies whether or not the gridlines of the left y-axis are visible."})},yRight:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yRightAxisgridlines.help",{defaultMessage:"Specifies whether or not the gridlines of the right y-axis are visible."})}},fn:function fn(input,args){return{type:"lens_xy_gridlinesConfig",...args}}};const axisTitlesVisibilityConfig={name:"lens_xy_axisTitlesVisibilityConfig",aliases:[],type:"lens_xy_axisTitlesVisibilityConfig",help:`Configure the xy chart's axis titles appearance`,inputTypes:["null"],args:{x:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.xAxisTitle.help",{defaultMessage:"Specifies whether or not the title of the x-axis are visible."})},yLeft:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yLeftAxisTitle.help",{defaultMessage:"Specifies whether or not the title of the left y-axis are visible."})},yRight:{types:["boolean"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yRightAxisTitle.help",{defaultMessage:"Specifies whether or not the title of the right y-axis are visible."})}},fn:function fn(input,args){return{type:"lens_xy_axisTitlesVisibilityConfig",...args}}};const axisConfig={title:{types:["string"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.title.help",{defaultMessage:"The axis title"})},hide:{types:["boolean"],default:false,help:"Show / hide axis"}};const yAxisConfig={name:"lens_xy_yConfig",aliases:[],type:"lens_xy_yConfig",help:`Configure the behavior of a xy chart's y axis metric`,inputTypes:["null"],args:{forAccessor:{types:["string"],help:"The accessor this configuration is for"},axisMode:{types:["string"],options:["auto","left","right"],help:"The axis mode of the metric"},color:{types:["string"],help:"The color of the series"}},fn:function fn(input,args){return{type:"lens_xy_yConfig",...args}}};const layerConfig={name:"lens_xy_layer",aliases:[],type:"lens_xy_layer",help:`Configure a layer in the xy chart`,inputTypes:["null"],args:{...axisConfig,layerId:{types:["string"],help:""},xAccessor:{types:["string"],help:""},seriesType:{types:["string"],options:["bar","line","area","bar_stacked","area_stacked","bar_percentage_stacked","area_percentage_stacked"],help:"The type of chart to display."},xScaleType:{options:["ordinal","linear","time"],help:"The scale type of the x axis",default:"ordinal"},isHistogram:{types:["boolean"],default:false,help:"Whether to layout the chart as a histogram"},yScaleType:{options:["log","sqrt","linear","time"],help:"The scale type of the y axes",default:"linear"},splitAccessor:{types:["string"],help:"The column to split by",multi:false},accessors:{types:["string"],help:"The columns to display on the y axis.",multi:true},yConfig:{types:["lens_xy_yConfig"],help:"Additional configuration for y axes",multi:true},columnToLabel:{types:["string"],help:"JSON key-value pairs of column ID to label"},palette:{default:`{theme "palette" default={system_palette name="default"} }`,help:"",types:["palette"]}},fn:function fn(input,args){return{type:"lens_xy_layer",...args}}};const types_visualizationTypes=[{id:"bar",icon:LensIconChartBar,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.barLabel",{defaultMessage:"Bar"})},{id:"bar_horizontal",icon:LensIconChartBarHorizontal,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.barHorizontalLabel",{defaultMessage:"H. Bar"}),fullLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.barHorizontalFullLabel",{defaultMessage:"Horizontal bar"})},{id:"bar_stacked",icon:LensIconChartBarStacked,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedBarLabel",{defaultMessage:"Stacked bar"})},{id:"bar_percentage_stacked",icon:LensIconChartBarPercentage,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedPercentageBarLabel",{defaultMessage:"Percentage bar"})},{id:"bar_horizontal_stacked",icon:LensIconChartBarHorizontalStacked,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedBarHorizontalLabel",{defaultMessage:"H. Stacked bar"}),fullLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedBarHorizontalFullLabel",{defaultMessage:"Horizontal stacked bar"})},{id:"bar_horizontal_percentage_stacked",icon:LensIconChartBarHorizontalPercentage,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedPercentageBarHorizontalLabel",{defaultMessage:"H. Percentage bar"}),fullLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedPercentageBarHorizontalFullLabel",{defaultMessage:"Horizontal percentage bar"})},{id:"area",icon:LensIconChartArea,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.areaLabel",{defaultMessage:"Area"})},{id:"area_stacked",icon:LensIconChartAreaStacked,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedAreaLabel",{defaultMessage:"Stacked area"})},{id:"area_percentage_stacked",icon:LensIconChartAreaPercentage,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.stackedPercentageAreaLabel",{defaultMessage:"Percentage area"})},{id:"line",icon:LensIconChartLine,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.lineLabel",{defaultMessage:"Line"})}];function isHorizontalSeries(seriesType){return seriesType==="bar_horizontal"||seriesType==="bar_horizontal_stacked"||seriesType==="bar_horizontal_percentage_stacked"}function isHorizontalChart(layers){return layers.every(l=>isHorizontalSeries(l.seriesType))}function getIconForSeries(type){const definition=types_visualizationTypes.find(t=>t.id===type);if(!definition){throw new Error(`Unknown series type ${type}`)}return definition.icon||"empty"}const getSeriesColor=(layer,accessor)=>{var _layer$yConfig,_layer$yConfig$find;if(layer.splitAccessor){return null}return(layer===null||layer===void 0?void 0:(_layer$yConfig=layer.yConfig)===null||_layer$yConfig===void 0?void 0:(_layer$yConfig$find=_layer$yConfig.find(yConfig=>yConfig.forAccessor===accessor))===null||_layer$yConfig$find===void 0?void 0:_layer$yConfig$find.color)||null};const getColumnToLabelMap=(layer,datasource)=>{const columnToLabel={};layer.accessors.concat(layer.splitAccessor?[layer.splitAccessor]:[]).forEach(accessor=>{const operation=datasource.getOperationForColumnId(accessor);if(operation!==null&&operation!==void 0&&operation.label){columnToLabel[accessor]=operation.label}});return columnToLabel};function hasHistogramSeries(layers=[],datasourceLayers){if(!datasourceLayers){return false}const validLayers=layers.filter(({accessors:accessors})=>accessors.length);return validLayers.some(({layerId:layerId,xAccessor:xAccessor})=>{const xAxisOperation=datasourceLayers[layerId].getOperationForColumnId(xAccessor);return xAxisOperation&&xAxisOperation.isBucketed&&xAxisOperation.scale&&xAxisOperation.scale!=="ordinal"})}var data_public_=__webpack_require__(10);const fittingFunctionDefinitions=[{id:"None",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsTitle.none",{defaultMessage:"Hide"}),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsDescription.none",{defaultMessage:"Do not fill gaps"})},{id:"Zero",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsTitle.zero",{defaultMessage:"Zero"}),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsDescription.zero",{defaultMessage:"Fill gaps with zeros"})},{id:"Linear",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsTitle.linear",{defaultMessage:"Linear"}),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsDescription.linear",{defaultMessage:"Fill gaps with a line"})},{id:"Carry",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsTitle.carry",{defaultMessage:"Last"}),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsDescription.carry",{defaultMessage:"Fill gaps with the last value"})},{id:"Lookahead",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsTitle.lookahead",{defaultMessage:"Next"}),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fittingFunctionsDescription.lookahead",{defaultMessage:"Fill gaps with the next value"})}];function getFitEnum(fittingFunction){if(fittingFunction){return external_kbnSharedDeps_ElasticCharts_["Fit"][fittingFunction]}return external_kbnSharedDeps_ElasticCharts_["Fit"].None}function getFitOptions(fittingFunction){return{type:getFitEnum(fittingFunction)}}function isFormatterCompatible(formatter1,formatter2){return formatter1.id===formatter2.id}function getAxesConfiguration(layers,shouldRotate,tables,formatFactory){const series={auto:[],left:[],right:[]};layers===null||layers===void 0?void 0:layers.forEach(layer=>{const table=tables===null||tables===void 0?void 0:tables[layer.layerId];layer.accessors.forEach(accessor=>{var _layer$yConfig,_layer$yConfig$find,_table$columns$find,_table$columns$find$m;const mode=((_layer$yConfig=layer.yConfig)===null||_layer$yConfig===void 0?void 0:(_layer$yConfig$find=_layer$yConfig.find(yAxisConfig=>yAxisConfig.forAccessor===accessor))===null||_layer$yConfig$find===void 0?void 0:_layer$yConfig$find.axisMode)||"auto";let formatter=(table===null||table===void 0?void 0:(_table$columns$find=table.columns.find(column=>column.id===accessor))===null||_table$columns$find===void 0?void 0:(_table$columns$find$m=_table$columns$find.meta)===null||_table$columns$find$m===void 0?void 0:_table$columns$find$m.params)||{id:"number"};if(layer.seriesType.includes("percentage")&&formatter.id!=="percent"){formatter={id:"percent",params:{pattern:"0.[00]%"}}}series[mode].push({layer:layer.layerId,accessor:accessor,fieldFormat:formatter})})});series.auto.forEach(currentSeries=>{if(series.left.length===0||tables&&series.left.every(leftSeries=>isFormatterCompatible(leftSeries.fieldFormat,currentSeries.fieldFormat))){series.left.push(currentSeries)}else if(series.right.length===0||tables&&series.left.every(leftSeries=>isFormatterCompatible(leftSeries.fieldFormat,currentSeries.fieldFormat))){series.right.push(currentSeries)}else if(series.right.length>=series.left.length){series.left.push(currentSeries)}else{series.right.push(currentSeries)}});const axisGroups=[];if(series.left.length>0){axisGroups.push({groupId:"left",position:shouldRotate?"bottom":"left",formatter:formatFactory===null||formatFactory===void 0?void 0:formatFactory(series.left[0].fieldFormat),series:series.left.map(({fieldFormat:fieldFormat,...currentSeries})=>currentSeries)})}if(series.right.length>0){axisGroups.push({groupId:"right",position:shouldRotate?"top":"right",formatter:formatFactory===null||formatFactory===void 0?void 0:formatFactory(series.right[0].fieldFormat),series:series.right.map(({fieldFormat:fieldFormat,...currentSeries})=>currentSeries)})}return axisGroups}const color_assignment_isPrimitive=value=>value!=null&&typeof value!=="object";function getColorAssignments(layers,data,formatFactory){const layersPerPalette={};layers.forEach(layer=>{var _layer$palette;const palette=((_layer$palette=layer.palette)===null||_layer$palette===void 0?void 0:_layer$palette.name)||"default";if(!layersPerPalette[palette]){layersPerPalette[palette]=[]}layersPerPalette[palette].push(layer)});return Object(external_kbnSharedDeps_Lodash_["mapValues"])(layersPerPalette,paletteLayers=>{const seriesPerLayer=paletteLayers.map((layer,layerIndex)=>{var _data$tables$layer$la;if(!layer.splitAccessor){return{numberOfSeries:layer.accessors.length,splits:[]}}const splitAccessor=layer.splitAccessor;const column=(_data$tables$layer$la=data.tables[layer.layerId])===null||_data$tables$layer$la===void 0?void 0:_data$tables$layer$la.columns.find(({id:id})=>id===splitAccessor);const splits=!column||!data.tables[layer.layerId]?[]:Object(external_kbnSharedDeps_Lodash_["uniq"])(data.tables[layer.layerId].rows.map(row=>{let value=row[splitAccessor];if(value&&!color_assignment_isPrimitive(value)){value=formatFactory(column.meta.params).convert(value)}else{value=String(value)}return value}));return{numberOfSeries:(splits.length||1)*layer.accessors.length,splits:splits}});const totalSeriesCount=seriesPerLayer.reduce((sum,perLayer)=>sum+perLayer.numberOfSeries,0);return{totalSeriesCount:totalSeriesCount,getRank(sortedLayer,seriesKey,yAccessor){const layerIndex=paletteLayers.findIndex(l=>sortedLayer.layerId===l.layerId);const currentSeriesPerLayer=seriesPerLayer[layerIndex];const splitRank=currentSeriesPerLayer.splits.indexOf(seriesKey);return(layerIndex===0?0:seriesPerLayer.slice(0,layerIndex).reduce((sum,perLayer)=>sum+perLayer.numberOfSeries,0))+(sortedLayer.splitAccessor&&splitRank!==-1?splitRank*sortedLayer.accessors.length:0)+sortedLayer.accessors.indexOf(yAccessor)}}})}function getAccessorColorConfig(colorAssignments,frame,layer,paletteService){const layerContainsSplits=Boolean(layer.splitAccessor);const currentPalette=layer.palette||{type:"palette",name:"default"};const totalSeriesCount=colorAssignments[currentPalette.name].totalSeriesCount;return layer.accessors.map(accessor=>{var _layer$yConfig;const currentYConfig=(_layer$yConfig=layer.yConfig)===null||_layer$yConfig===void 0?void 0:_layer$yConfig.find(yConfig=>yConfig.forAccessor===accessor);if(layerContainsSplits){return{columnId:accessor,triggerIcon:"disabled"}}const columnToLabel=getColumnToLabelMap(layer,frame.datasourceLayers[layer.layerId]);const rank=colorAssignments[currentPalette.name].getRank(layer,columnToLabel[accessor]||accessor,accessor);const customColor=(currentYConfig===null||currentYConfig===void 0?void 0:currentYConfig.color)||paletteService.get(currentPalette.name).getColor([{name:columnToLabel[accessor]||accessor,rankAtDepth:rank,totalSeriesAtDepth:totalSeriesCount}],{maxDepth:1,totalSeries:totalSeriesCount},currentPalette.params);return{columnId:accessor,triggerIcon:customColor?"color":"disabled",color:customColor?customColor:undefined}})}function xy_visualization_expression_extends(){xy_visualization_expression_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return xy_visualization_expression_extends.apply(this,arguments)}const xyChart={name:"lens_xy_chart",type:"render",inputTypes:["lens_multitable","kibana_context","null"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.help",{defaultMessage:"An X/Y chart"}),args:{title:{types:["string"],help:"The chart title."},description:{types:["string"],help:""},xTitle:{types:["string"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.xTitle.help",{defaultMessage:"X axis title"})},yTitle:{types:["string"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yLeftTitle.help",{defaultMessage:"Y left axis title"})},yRightTitle:{types:["string"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.yRightTitle.help",{defaultMessage:"Y right axis title"})},legend:{types:["lens_xy_legendConfig"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.legend.help",{defaultMessage:"Configure the chart legend."})},fittingFunction:{types:["string"],options:[...fittingFunctionDefinitions.map(({id:id})=>id)],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.fittingFunction.help",{defaultMessage:"Define how missing values are treated"})},valueLabels:{types:["string"],options:["hide","inside"],help:""},tickLabelsVisibilitySettings:{types:["lens_xy_tickLabelsConfig"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.tickLabelsSettings.help",{defaultMessage:"Show x and y axes tick labels"})},gridlinesVisibilitySettings:{types:["lens_xy_gridlinesConfig"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.gridlinesSettings.help",{defaultMessage:"Show x and y axes gridlines"})},axisTitlesVisibilitySettings:{types:["lens_xy_axisTitlesVisibilityConfig"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisTitlesSettings.help",{defaultMessage:"Show x and y axes titles"})},layers:{types:["lens_xy_layer"],help:"Layers of visual series",multi:true}},fn(data,args){return{type:"render",as:"lens_xy_chart_renderer",value:{data:data,args:args}}}};async function calculateMinInterval({args:{layers:layers},data:data},getIntervalByColumn){const filteredLayers=getFilteredLayers(layers,data);if(filteredLayers.length===0)return;const isTimeViz=data.dateRange&&filteredLayers.every(l=>l.xScaleType==="time");const xColumn=data.tables[filteredLayers[0].layerId].columns.find(column=>column.id===filteredLayers[0].xAccessor);if(!xColumn)return;if(!isTimeViz){const histogramInterval=data_public_["search"].aggs.getNumberHistogramIntervalByDatatableColumn(xColumn);if(typeof histogramInterval==="number"){return histogramInterval}else{return undefined}}const dateMetaData=await getIntervalByColumn(xColumn);if(!dateMetaData)return;const intervalDuration=data_public_["search"].aggs.parseInterval(dateMetaData.interval);if(!intervalDuration)return;return intervalDuration.as("milliseconds")}const getXyChartRenderer=dependencies=>({name:"lens_xy_chart_renderer",displayName:"XY chart",help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.renderer.help",{defaultMessage:"X/Y chart renderer"}),validate:()=>undefined,reuseDomNode:true,render:async(domNode,config,handlers)=>{handlers.onDestroy(()=>external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(domNode));const onClickValue=data=>{handlers.event({name:"filter",data:data})};const onSelectRange=data=>{handlers.event({name:"brush",data:data})};const formatFactory=await dependencies.formatFactory;external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(XYChartReportable,xy_visualization_expression_extends({},config,{formatFactory:formatFactory,chartsThemeService:dependencies.chartsThemeService,paletteService:dependencies.paletteService,timeZone:dependencies.timeZone,minInterval:await calculateMinInterval(config,dependencies.getIntervalByColumn),onClickValue:onClickValue,onSelectRange:onSelectRange,renderMode:handlers.getRenderMode(),syncColors:handlers.isSyncColorsEnabled()}))),domNode,()=>handlers.done())}});function getValueLabelsStyling(isHorizontal){const VALUE_LABELS_MAX_FONTSIZE=15;const VALUE_LABELS_MIN_FONTSIZE=10;const VALUE_LABELS_VERTICAL_OFFSET=-10;const VALUE_LABELS_HORIZONTAL_OFFSET=10;return{displayValue:{fontSize:{min:VALUE_LABELS_MIN_FONTSIZE,max:VALUE_LABELS_MAX_FONTSIZE},fill:{textInverted:true,textBorder:2},alignment:isHorizontal?{vertical:external_kbnSharedDeps_ElasticCharts_["VerticalAlignment"].Middle}:{horizontal:external_kbnSharedDeps_ElasticCharts_["HorizontalAlignment"].Center},offsetX:isHorizontal?VALUE_LABELS_HORIZONTAL_OFFSET:0,offsetY:isHorizontal?0:VALUE_LABELS_VERTICAL_OFFSET}}}function getIconForSeriesType(seriesType){return types_visualizationTypes.find(c=>c.id===seriesType).icon||"empty"}const expression_MemoizedChart=external_kbnSharedDeps_React_default.a.memo(XYChart);function XYChartReportable(props){const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({isReady:false});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setState({isReady:true})},[setState]);return external_kbnSharedDeps_React_default.a.createElement(VisualizationContainer,{className:"lnsXyExpression__container",isReady:state.isReady,reportTitle:props.args.title,reportDescription:props.args.description},external_kbnSharedDeps_React_default.a.createElement(expression_MemoizedChart,props))}function XYChart({data:data,args:args,formatFactory:formatFactory,timeZone:timeZone,chartsThemeService:chartsThemeService,paletteService:paletteService,minInterval:minInterval,onClickValue:onClickValue,onSelectRange:onSelectRange,renderMode:renderMode,syncColors:syncColors}){var _xAxisColumn$meta,_data$dateRange,_data$dateRange2,_window$_echDebugStat;const{legend:legend,layers:layers,fittingFunction:fittingFunction,gridlinesVisibilitySettings:gridlinesVisibilitySettings,valueLabels:valueLabels}=args;const chartTheme=chartsThemeService.useChartsTheme();const chartBaseTheme=chartsThemeService.useChartsBaseTheme();const filteredLayers=getFilteredLayers(layers,data);if(filteredLayers.length===0){const icon=layers.length>0?getIconForSeriesType(layers[0].seriesType):"bar";return external_kbnSharedDeps_React_default.a.createElement(EmptyPlaceholder,{icon:icon})}const xAxisColumn=data.tables[filteredLayers[0].layerId].columns.find(({id:id})=>id===filteredLayers[0].xAccessor);const xAxisFormatter=formatFactory(xAxisColumn&&((_xAxisColumn$meta=xAxisColumn.meta)===null||_xAxisColumn$meta===void 0?void 0:_xAxisColumn$meta.params));const layersAlreadyFormatted={};const safeXAccessorLabelRenderer=value=>xAxisColumn&&layersAlreadyFormatted[xAxisColumn.id]?value:xAxisFormatter.convert(value);const chartHasMoreThanOneSeries=filteredLayers.length>1||filteredLayers.some(layer=>layer.accessors.length>1)||filteredLayers.some(layer=>layer.splitAccessor);const shouldRotate=isHorizontalChart(filteredLayers);const yAxesConfiguration=getAxesConfiguration(filteredLayers,shouldRotate,data.tables,formatFactory);const xTitle=args.xTitle||xAxisColumn&&xAxisColumn.name;const axisTitlesVisibilitySettings=args.axisTitlesVisibilitySettings||{x:true,yLeft:true,yRight:true};const tickLabelsVisibilitySettings=args.tickLabelsVisibilitySettings||{x:true,yLeft:true,yRight:true};const filteredBarLayers=filteredLayers.filter(layer=>layer.seriesType.includes("bar"));const chartHasMoreThanOneBarSeries=filteredBarLayers.length>1||filteredBarLayers.some(layer=>layer.accessors.length>1)||filteredBarLayers.some(layer=>layer.splitAccessor);const isTimeViz=data.dateRange&&filteredLayers.every(l=>l.xScaleType==="time");const isHistogramViz=filteredLayers.every(l=>l.isHistogram);const xDomain={min:isTimeViz?(_data$dateRange=data.dateRange)===null||_data$dateRange===void 0?void 0:_data$dateRange.fromDate.getTime():undefined,max:isTimeViz?(_data$dateRange2=data.dateRange)===null||_data$dateRange2===void 0?void 0:_data$dateRange2.toDate.getTime():undefined,minInterval:minInterval};const getYAxesTitles=(axisSeries,groupId)=>{const yTitle=groupId==="right"?args.yRightTitle:args.yTitle;return yTitle||axisSeries.map(series=>{var _data$tables$series$l;return(_data$tables$series$l=data.tables[series.layer].columns.find(column=>column.id===series.accessor))===null||_data$tables$series$l===void 0?void 0:_data$tables$series$l.name}).filter(name=>Boolean(name))[0]};const getYAxesStyle=groupId=>{const style={tickLabel:{visible:groupId==="right"?tickLabelsVisibilitySettings===null||tickLabelsVisibilitySettings===void 0?void 0:tickLabelsVisibilitySettings.yRight:tickLabelsVisibilitySettings===null||tickLabelsVisibilitySettings===void 0?void 0:tickLabelsVisibilitySettings.yLeft},axisTitle:{visible:groupId==="right"?axisTitlesVisibilitySettings===null||axisTitlesVisibilitySettings===void 0?void 0:axisTitlesVisibilitySettings.yRight:axisTitlesVisibilitySettings===null||axisTitlesVisibilitySettings===void 0?void 0:axisTitlesVisibilitySettings.yLeft}};return style};const shouldShowValueLabels=filteredLayers.every(layer=>!layer.seriesType.includes("stacked"))&&!isHistogramViz;const valueLabelsStyling=shouldShowValueLabels&&valueLabels!=="hide"&&getValueLabelsStyling(shouldRotate);const colorAssignments=getColorAssignments(args.layers,data,formatFactory);const clickHandler=([[geometry,series]])=>{var _table$columns$find,_table$columns$find$m;const xySeries=series;const xyGeometry=geometry;const layer=filteredLayers.find(l=>xySeries.seriesKeys.some(key=>l.accessors.includes(key.toString())));if(!layer){return}const table=data.tables[layer.layerId];const points=[{row:table.rows.findIndex(row=>{if(layer.xAccessor){if(layersAlreadyFormatted[layer.xAccessor]){return xAxisFormatter.convert(row[layer.xAccessor])===xyGeometry.x}return row[layer.xAccessor]===xyGeometry.x}}),column:table.columns.findIndex(col=>col.id===layer.xAccessor),value:xyGeometry.x}];if(xySeries.seriesKeys.length>1){const pointValue=xySeries.seriesKeys[0];points.push({row:table.rows.findIndex(row=>layer.splitAccessor&&row[layer.splitAccessor]===pointValue),column:table.columns.findIndex(col=>col.id===layer.splitAccessor),value:pointValue})}const xAxisFieldName=(_table$columns$find=table.columns.find(el=>el.id===layer.xAccessor))===null||_table$columns$find===void 0?void 0:(_table$columns$find$m=_table$columns$find.meta)===null||_table$columns$find$m===void 0?void 0:_table$columns$find$m.field;const timeFieldName=xDomain&&xAxisFieldName;const context={data:points.map(point=>({row:point.row,column:point.column,value:point.value,table:table})),timeFieldName:timeFieldName};onClickValue(desanitizeFilterContext(context))};const brushHandler=({x:x})=>{var _table$columns$xAxisC,_table$columns$xAxisC2;if(!x){return}const[min,max]=x;if(!xAxisColumn||!isHistogramViz){return}const table=data.tables[filteredLayers[0].layerId];const xAxisColumnIndex=table.columns.findIndex(el=>el.id===filteredLayers[0].xAccessor);const timeFieldName=isTimeViz?(_table$columns$xAxisC=table.columns[xAxisColumnIndex])===null||_table$columns$xAxisC===void 0?void 0:(_table$columns$xAxisC2=_table$columns$xAxisC.meta)===null||_table$columns$xAxisC2===void 0?void 0:_table$columns$xAxisC2.field:undefined;const context={range:[min,max],table:table,column:xAxisColumnIndex,timeFieldName:timeFieldName};onSelectRange(context)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{debugState:(_window$_echDebugStat=window._echDebugStateFlag)!==null&&_window$_echDebugStat!==void 0?_window$_echDebugStat:false,showLegend:legend.isVisible&&!legend.showSingleSeries?chartHasMoreThanOneSeries:legend.isVisible,legendPosition:legend.position,showLegendExtra:false,theme:{...chartTheme,barSeriesStyle:{...chartTheme.barSeriesStyle,...valueLabelsStyling},background:{color:undefined}},baseTheme:chartBaseTheme,tooltip:{headerFormatter:d=>safeXAccessorLabelRenderer(d.value)},rotation:shouldRotate?90:0,xDomain:xDomain,onBrushEnd:renderMode!=="noInteractivity"?brushHandler:undefined,onElementClick:renderMode!=="noInteractivity"?clickHandler:undefined}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"x",position:shouldRotate?external_kbnSharedDeps_ElasticCharts_["Position"].Left:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,title:xTitle,gridLine:{visible:gridlinesVisibilitySettings===null||gridlinesVisibilitySettings===void 0?void 0:gridlinesVisibilitySettings.x,strokeWidth:2},hide:filteredLayers[0].hide||!filteredLayers[0].xAccessor,tickFormat:d=>safeXAccessorLabelRenderer(d),style:{tickLabel:{visible:tickLabelsVisibilitySettings===null||tickLabelsVisibilitySettings===void 0?void 0:tickLabelsVisibilitySettings.x},axisTitle:{visible:axisTitlesVisibilitySettings.x}}}),yAxesConfiguration.map(axis=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{key:axis.groupId,id:axis.groupId,groupId:axis.groupId,position:axis.position,title:getYAxesTitles(axis.series,axis.groupId),gridLine:{visible:axis.groupId==="right"?gridlinesVisibilitySettings===null||gridlinesVisibilitySettings===void 0?void 0:gridlinesVisibilitySettings.yRight:gridlinesVisibilitySettings===null||gridlinesVisibilitySettings===void 0?void 0:gridlinesVisibilitySettings.yLeft},hide:filteredLayers[0].hide,tickFormat:d=>{var _axis$formatter;return((_axis$formatter=axis.formatter)===null||_axis$formatter===void 0?void 0:_axis$formatter.convert(d))||""},style:getYAxesStyle(axis.groupId)})),filteredLayers.flatMap((layer,layerIndex)=>layer.accessors.map((accessor,accessorIndex)=>{const{splitAccessor:splitAccessor,seriesType:seriesType,accessors:accessors,xAccessor:xAccessor,layerId:layerId,columnToLabel:columnToLabel,yScaleType:yScaleType,xScaleType:xScaleType,isHistogram:isHistogram,palette:palette}=layer;const columnToLabelMap=columnToLabel?JSON.parse(columnToLabel):{};const table=data.tables[layerId];const isPrimitive=value=>value!=null&&typeof value!=="object";const tableConverted={...table,rows:table.rows.map(row=>{const newRow={...row};for(const column of table.columns){const record=newRow[column.id];if(record&&!isPrimitive(record)){newRow[column.id]=formatFactory(column.meta.params).convert(record)}}return newRow})};table.columns.reduce((alreadyFormatted,{id:id})=>{if(alreadyFormatted[id]){return alreadyFormatted}alreadyFormatted[id]=table.rows.some((row,i)=>row[id]!==tableConverted.rows[i][id]);return alreadyFormatted},layersAlreadyFormatted);const rows=tableConverted.rows.filter(row=>!(xAccessor&&typeof row[xAccessor]==="undefined")&&!(splitAccessor&&typeof row[splitAccessor]==="undefined"&&typeof row[accessor]==="undefined"));if(!xAccessor){rows.forEach(row=>{row.unifiedX=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.emptyXLabel",{defaultMessage:"(empty)"})})}const yAxis=yAxesConfiguration.find(axisConfiguration=>axisConfiguration.series.find(currentSeries=>currentSeries.accessor===accessor));const seriesProps={splitSeriesAccessors:splitAccessor?[splitAccessor]:[],stackAccessors:seriesType.includes("stacked")?[xAccessor]:[],id:`${splitAccessor}-${accessor}`,xAccessor:xAccessor||"unifiedX",yAccessors:[accessor],data:rows,xScaleType:xAccessor?xScaleType:"ordinal",yScaleType:yScaleType,color:({yAccessor:yAccessor,seriesKeys:seriesKeys})=>{const overwriteColor=getSeriesColor(layer,accessor);if(overwriteColor!==null){return overwriteColor}const colorAssignment=colorAssignments[palette.name];const seriesLayers=[{name:splitAccessor?String(seriesKeys[0]):columnToLabelMap[seriesKeys[0]],totalSeriesAtDepth:colorAssignment.totalSeriesCount,rankAtDepth:colorAssignment.getRank(layer,String(seriesKeys[0]),String(yAccessor))}];return paletteService.get(palette.name).getColor(seriesLayers,{maxDepth:1,behindText:false,totalSeries:colorAssignment.totalSeriesCount,syncColors:syncColors},palette.params)},groupId:yAxis===null||yAxis===void 0?void 0:yAxis.groupId,enableHistogramMode:isHistogram&&(seriesType.includes("stacked")||!splitAccessor)&&(seriesType.includes("stacked")||!seriesType.includes("bar")||!chartHasMoreThanOneBarSeries),stackMode:seriesType.includes("percentage")?external_kbnSharedDeps_ElasticCharts_["StackMode"].Percentage:undefined,timeZone:timeZone,areaSeriesStyle:{point:{visible:!xAccessor,radius:5}},lineSeriesStyle:{point:{visible:!xAccessor,radius:5}},name(d){var _table$columns$find2,_table$columns$find2$,_columnToLabelMap$d$s;const splitHint=(_table$columns$find2=table.columns.find(col=>col.id===splitAccessor))===null||_table$columns$find2===void 0?void 0:(_table$columns$find2$=_table$columns$find2.meta)===null||_table$columns$find2$===void 0?void 0:_table$columns$find2$.params;if(accessors.length>1){const result=d.seriesKeys.map((key,i)=>{var _columnToLabelMap$key;if(i===0&&splitHint&&splitAccessor&&!layersAlreadyFormatted[splitAccessor]){return formatFactory(splitHint).convert(key)}return splitAccessor&&i===0?key:(_columnToLabelMap$key=columnToLabelMap[key])!==null&&_columnToLabelMap$key!==void 0?_columnToLabelMap$key:""}).join(" - ");return result}if(splitHint){if(splitAccessor&&layersAlreadyFormatted[splitAccessor]){return d.seriesKeys[0]}return formatFactory(splitHint).convert(d.seriesKeys[0])}return splitAccessor?d.seriesKeys[0]:(_columnToLabelMap$d$s=columnToLabelMap[d.seriesKeys[0]])!==null&&_columnToLabelMap$d$s!==void 0?_columnToLabelMap$d$s:""}};const index=`${layerIndex}-${accessorIndex}`;switch(seriesType){case"line":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["LineSeries"],xy_visualization_expression_extends({key:index},seriesProps,{fit:getFitOptions(fittingFunction)}));case"bar":case"bar_stacked":case"bar_percentage_stacked":case"bar_horizontal":case"bar_horizontal_stacked":case"bar_horizontal_percentage_stacked":const valueLabelsSettings={displayValueSettings:{valueFormatter:d=>{var _yAxis$formatter;return(yAxis===null||yAxis===void 0?void 0:(_yAxis$formatter=yAxis.formatter)===null||_yAxis$formatter===void 0?void 0:_yAxis$formatter.convert(d))||""},showValueLabel:shouldShowValueLabels&&valueLabels!=="hide",isAlternatingValueLabel:false,isValueContainedInElement:true,hideClippedValue:true}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],xy_visualization_expression_extends({key:index},seriesProps,valueLabelsSettings));case"area_stacked":case"area_percentage_stacked":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["AreaSeries"],xy_visualization_expression_extends({key:index},seriesProps,{fit:getFitOptions(fittingFunction)}));case"area":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["AreaSeries"],xy_visualization_expression_extends({key:index},seriesProps,{fit:getFitOptions(fittingFunction)}));default:return assertNever(seriesType)}})))}function getFilteredLayers(layers,data){return layers.filter(({layerId:layerId,xAccessor:xAccessor,accessors:accessors,splitAccessor:splitAccessor})=>!(!accessors.length||!data.tables[layerId]||data.tables[layerId].rows.length===0||xAccessor&&data.tables[layerId].rows.every(row=>typeof row[xAccessor]==="undefined")||!xAccessor&&splitAccessor&&data.tables[layerId].rows.every(row=>typeof row[splitAccessor]==="undefined")))}function assertNever(x){throw new Error("Unexpected series type: "+x)}const columnSortOrder={document:0,date:1,string:2,ip:3,boolean:4,number:5,histogram:6};function xy_suggestions_getSuggestions({table:table,state:state,keptLayerIds:keptLayerIds,subVisualizationId:subVisualizationId,mainPalette:mainPalette}){const incompleteTable=!table.isMultiRow||table.columns.length<=1||table.columns.every(col=>col.operation.dataType!=="number")||table.columns.some(col=>!columnSortOrder.hasOwnProperty(col.operation.dataType));if(incompleteTable&&table.changeType==="unchanged"&&state){return types_visualizationTypes.map(visType=>{const seriesType=visType.id;return{seriesType:seriesType,score:0,state:{...state,preferredSeriesType:seriesType,layers:state.layers.map(layer=>({...layer,seriesType:seriesType}))},previewIcon:getIconForSeries(seriesType),title:visType.label,hide:true}})}if(incompleteTable&&state&&!subVisualizationId){return[]}const suggestions=getSuggestionForColumns(table,keptLayerIds,state,subVisualizationId,mainPalette);if(suggestions&&suggestions instanceof Array){return suggestions}return suggestions?[suggestions]:[]}function getSuggestionForColumns(table,keptLayerIds,currentState,seriesType,mainPalette){const[buckets,values]=Object(external_kbnSharedDeps_Lodash_["partition"])(table.columns,col=>col.operation.isBucketed);if(buckets.length===1||buckets.length===2){const[x,splitBy]=getBucketMappings(table,currentState);return getSuggestionsForLayer({layerId:table.layerId,changeType:table.changeType,xValue:x,yValues:values,splitBy:splitBy,currentState:currentState,tableLabel:table.label,keptLayerIds:keptLayerIds,requestedSeriesType:seriesType,mainPalette:mainPalette})}else if(buckets.length===0){const[yValues,[xValue,splitBy]]=Object(external_kbnSharedDeps_Lodash_["partition"])(prioritizeColumns(values),col=>col.operation.dataType==="number"&&!col.operation.isBucketed);return getSuggestionsForLayer({layerId:table.layerId,changeType:table.changeType,xValue:xValue,yValues:yValues,splitBy:splitBy,currentState:currentState,tableLabel:table.label,keptLayerIds:keptLayerIds,requestedSeriesType:seriesType,mainPalette:mainPalette})}}function flipSeriesType(seriesType){switch(seriesType){case"bar_horizontal":return"bar";case"bar_horizontal_stacked":return"bar_stacked";case"bar":return"bar_horizontal";case"bar_horizontal_percentage_stacked":return"bar_percentage_stacked";case"bar_percentage_stacked":return"bar_horizontal_percentage_stacked";default:return"bar_horizontal"}}function getBucketMappings(table,currentState){const currentLayer=currentState&&currentState.layers.find(({layerId:layerId})=>layerId===table.layerId);const buckets=table.columns.filter(col=>col.operation.isBucketed);const prioritizedBuckets=prioritizeColumns([...buckets].reverse());if(!currentLayer||table.changeType==="initial"){return prioritizedBuckets}if(table.changeType==="reorder"){return buckets}const currentXColumnIndex=prioritizedBuckets.findIndex(({columnId:columnId})=>columnId===currentLayer.xAccessor);const currentXScaleType=currentXColumnIndex>-1&&prioritizedBuckets[currentXColumnIndex].operation.scale;if(currentXScaleType&&(currentXScaleType==="interval"||prioritizedBuckets[0].operation.scale!=="interval")){const[x]=prioritizedBuckets.splice(currentXColumnIndex,1);prioritizedBuckets.unshift(x)}const currentSplitColumnIndex=prioritizedBuckets.findIndex(({columnId:columnId})=>columnId===currentLayer.splitAccessor);if(currentSplitColumnIndex>-1){const[splitBy]=prioritizedBuckets.splice(currentSplitColumnIndex,1);prioritizedBuckets.push(splitBy)}return prioritizedBuckets}function prioritizeColumns(columns){return[...columns].sort((a,b)=>columnSortOrder[a.operation.dataType]-columnSortOrder[b.operation.dataType])}function getSuggestionsForLayer({layerId:layerId,changeType:changeType,xValue:xValue,yValues:yValues,splitBy:splitBy,currentState:currentState,tableLabel:tableLabel,keptLayerIds:keptLayerIds,requestedSeriesType:requestedSeriesType,mainPalette:mainPalette}){const title=getSuggestionTitle(yValues,xValue,tableLabel);const seriesType=requestedSeriesType||getSeriesType(currentState,layerId,xValue);const options={currentState:currentState,seriesType:seriesType,layerId:layerId,title:title,yValues:yValues,splitBy:splitBy,changeType:changeType,xValue:xValue,keptLayerIds:keptLayerIds,mainPalette:splitBy?mainPalette:undefined};if(!currentState&&changeType==="unchanged"){return types_visualizationTypes.map(visType=>({...buildSuggestion({...options,seriesType:visType.id,hide:visType.id==="bar_stacked"?undefined:true}),title:visType.label})).sort((a,b)=>a.state.preferredSeriesType==="bar_stacked"?-1:1)}const isSameState=currentState&&changeType==="unchanged";if(!isSameState){return buildSuggestion(options)}const sameStateSuggestions=[];if(seriesType.includes("bar")&&(!xValue||xValue.operation.scale==="ordinal")){sameStateSuggestions.push(buildSuggestion({...options,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.flipTitle",{defaultMessage:"Flip"}),seriesType:flipSeriesType(seriesType)}))}else{const newSeriesType=altSeriesType(seriesType);sameStateSuggestions.push(buildSuggestion({...options,seriesType:newSeriesType,title:newSeriesType.startsWith("bar")?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.barChartTitle",{defaultMessage:"Bar chart"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.lineChartTitle",{defaultMessage:"Line chart"})}))}if(seriesType!=="line"&&splitBy&&!seriesType.includes("percentage")){sameStateSuggestions.push(buildSuggestion({...options,seriesType:toggleStackSeriesType(seriesType),title:seriesType.endsWith("stacked")?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.unstackedChartTitle",{defaultMessage:"Unstacked"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.stackedChartTitle",{defaultMessage:"Stacked"})}))}if(seriesType!=="line"&&seriesType.includes("stacked")&&!seriesType.includes("percentage")){var _percentageOptions$xV;const percentageOptions={...options};if(((_percentageOptions$xV=percentageOptions.xValue)===null||_percentageOptions$xV===void 0?void 0:_percentageOptions$xV.operation.scale)==="ordinal"&&!percentageOptions.splitBy){percentageOptions.splitBy=percentageOptions.xValue;delete percentageOptions.xValue}sameStateSuggestions.push(buildSuggestion({...options,hide:!percentageOptions.splitBy,seriesType:asPercentageSeriesType(seriesType),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.asPercentageTitle",{defaultMessage:"Percentage"})}))}return sameStateSuggestions.concat(types_visualizationTypes.filter(visType=>!sameStateSuggestions.find(suggestion=>suggestion.state.preferredSeriesType===visType.id)).map(visType=>({...buildSuggestion({...options,seriesType:visType.id}),hide:true})))}function toggleStackSeriesType(oldSeriesType){switch(oldSeriesType){case"area":return"area_stacked";case"area_stacked":return"area";case"bar":return"bar_stacked";case"bar_stacked":return"bar";default:return oldSeriesType}}function asPercentageSeriesType(oldSeriesType){switch(oldSeriesType){case"area_stacked":return"area_percentage_stacked";case"bar_stacked":return"bar_percentage_stacked";case"bar_horizontal_stacked":return"bar_horizontal_percentage_stacked";default:return oldSeriesType}}function altSeriesType(oldSeriesType){switch(oldSeriesType){case"area":return"line";case"area_stacked":return"bar_stacked";case"bar":return"line";case"bar_stacked":return"line";case"line":default:return"bar_stacked"}}function getSeriesType(currentState,layerId,xValue){const defaultType="bar_stacked";const oldLayer=getExistingLayer(currentState,layerId);const oldLayerSeriesType=oldLayer?oldLayer.seriesType:false;const closestSeriesType=oldLayerSeriesType||currentState&&currentState.preferredSeriesType||defaultType;if(xValue&&xValue.operation.scale&&xValue.operation.scale==="ordinal"){return closestSeriesType.startsWith("bar")?closestSeriesType:defaultType}return closestSeriesType}function getSuggestionTitle(yValues,xValue,tableLabel){const yTitle=yValues.map(col=>col.operation.label).join(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.yAxixConjunctionSign",{defaultMessage:" & ",description:"A character that can be used for conjunction of multiple enumarated items. Make sure to include spaces around it if needed."}));const xTitle=(xValue===null||xValue===void 0?void 0:xValue.operation.label)||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.emptyAxisTitle",{defaultMessage:"(empty)"});const title=tableLabel||((xValue===null||xValue===void 0?void 0:xValue.operation.dataType)==="date"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.dateSuggestion",{defaultMessage:"{yTitle} over {xTitle}",description:'Chart description for charts over time, like "Transfered bytes over log.timestamp"',values:{xTitle:xTitle,yTitle:yTitle}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xySuggestions.nonDateSuggestion",{defaultMessage:"{yTitle} of {xTitle}",description:'Chart description for a value of some groups, like "Top URLs of top 5 countries"',values:{xTitle:xTitle,yTitle:yTitle}}));return title}function buildSuggestion({currentState:currentState,seriesType:seriesType,layerId:layerId,title:title,yValues:yValues,splitBy:splitBy,changeType:changeType,xValue:xValue,keptLayerIds:keptLayerIds,hide:hide,mainPalette:mainPalette}){var _xValue,_xValue2,_splitBy;if(seriesType.includes("percentage")&&((_xValue=xValue)===null||_xValue===void 0?void 0:_xValue.operation.scale)==="ordinal"&&!splitBy){splitBy=xValue;xValue=undefined}const existingLayer=getExistingLayer(currentState,layerId)||{};const accessors=yValues.map(col=>col.columnId);const newLayer={...existingLayer,palette:mainPalette||("palette"in existingLayer?existingLayer.palette:undefined),layerId:layerId,seriesType:seriesType,xAccessor:(_xValue2=xValue)===null||_xValue2===void 0?void 0:_xValue2.columnId,splitAccessor:(_splitBy=splitBy)===null||_splitBy===void 0?void 0:_splitBy.columnId,accessors:accessors,yConfig:"yConfig"in existingLayer&&existingLayer.yConfig?existingLayer.yConfig.filter(({forAccessor:forAccessor})=>accessors.indexOf(forAccessor)!==-1):undefined};const keptLayers=currentState?currentState.layers.filter(layer=>keptLayerIds.includes(layer.layerId)).map(layer=>layer.layerId===layerId?newLayer:layer).map(layer=>({...layer,seriesType:seriesType})):[];const state={legend:currentState?currentState.legend:{isVisible:true,position:external_kbnSharedDeps_ElasticCharts_["Position"].Right},valueLabels:(currentState===null||currentState===void 0?void 0:currentState.valueLabels)||"hide",fittingFunction:(currentState===null||currentState===void 0?void 0:currentState.fittingFunction)||"None",xTitle:currentState===null||currentState===void 0?void 0:currentState.xTitle,yTitle:currentState===null||currentState===void 0?void 0:currentState.yTitle,yRightTitle:currentState===null||currentState===void 0?void 0:currentState.yRightTitle,axisTitlesVisibilitySettings:(currentState===null||currentState===void 0?void 0:currentState.axisTitlesVisibilitySettings)||{x:true,yLeft:true,yRight:true},tickLabelsVisibilitySettings:(currentState===null||currentState===void 0?void 0:currentState.tickLabelsVisibilitySettings)||{x:true,yLeft:true,yRight:true},gridlinesVisibilitySettings:(currentState===null||currentState===void 0?void 0:currentState.gridlinesVisibilitySettings)||{x:true,yLeft:true,yRight:true},preferredSeriesType:seriesType,layers:Object.keys(existingLayer).length?keptLayers:[...keptLayers,newLayer]};return{title:title,score:getScore(yValues,splitBy,changeType),hide:hide!==null&&hide!==void 0?hide:!currentState&&changeType!=="unchanged"&&changeType!=="extended"||currentState&&changeType==="reduced"||yValues.length===0||!xValue&&!splitBy,state:state,previewIcon:getIconForSeries(seriesType)}}function getScore(yValues,splitBy,changeType){const changeFactor=changeType==="unchanged"?.5:1;return((yValues.length>1?2:1)+(splitBy?1:0))/3*changeFactor}function getExistingLayer(currentState,layerId){return currentState&&currentState.layers.find(layer=>layer.layerId===layerId)}var xy_config_panel=__webpack_require__(113);var lens_ui_telemetry=__webpack_require__(35);function axis_bottom_extends(){axis_bottom_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return axis_bottom_extends.apply(this,arguments)}const EuiIconAxisBottom=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_["createElement"]("svg",axis_bottom_extends({width:16,height:16,viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_["createElement"]("title",{id:titleId},title):null,external_kbnSharedDeps_React_["createElement"]("path",{d:"M5 1.5a.5.5 0 111 0v7a.5.5 0 01-1 0v-7zM15.39 11.39a1.5 1.5 0 010 2.12l-2.122 2.122a.5.5 0 11-.707-.707l2.121-2.122a.5.5 0 000-.707l-2.121-2.12a.5.5 0 11.707-.708l2.121 2.121zM3.439 9.269a.5.5 0 010 .707l-2.122 2.121a.5.5 0 000 .707l2.122 2.121a.5.5 0 01-.707.708L.61 13.51a1.5 1.5 0 010-2.121l2.122-2.121a.5.5 0 01.707 0zM8 3a.5.5 0 01.5.5v5a.5.5 0 01-1 0v-5A.5.5 0 018 3zM11 5.5a.5.5 0 00-1 0v3a.5.5 0 001 0v-3z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M3.5 12a.5.5 0 000 1h9a.5.5 0 000-1h-9z"}));function axis_left_extends(){axis_left_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return axis_left_extends.apply(this,arguments)}const EuiIconAxisLeft=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_["createElement"]("svg",axis_left_extends({width:16,height:16,viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_["createElement"]("title",{id:titleId},title):null,external_kbnSharedDeps_React_["createElement"]("path",{d:"M7.378 3.585a.5.5 0 00.353-.854L5.61.611a1.5 1.5 0 00-2.121 0L1.367 2.73a.5.5 0 00.708.707l2.12-2.12a.5.5 0 01.708 0l2.121 2.12a.5.5 0 00.354.147z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M5.046 3.088v4.129l.005.04v5.658a.5.5 0 01-.992.09l-.01-.09V8.786l-.004-.04V3.087a.5.5 0 01.992-.09l.01.09z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M4.55 15.829a1.5 1.5 0 001.06-.44l2.122-2.121a.5.5 0 10-.707-.707l-2.121 2.121a.5.5 0 01-.708 0l-2.12-2.121a.5.5 0 00-.708.707l2.121 2.121a1.5 1.5 0 001.061.44zM13.5 4a.5.5 0 01.5.5v7a.5.5 0 11-1 0v-7a.5.5 0 01.5-.5zM10.5 6.5a.5.5 0 011 0v5a.5.5 0 11-1 0v-5zM8.5 8a.5.5 0 00-.5.5v3a.5.5 0 101 0v-3a.5.5 0 00-.5-.5z"}));function axis_right_extends(){axis_right_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return axis_right_extends.apply(this,arguments)}const EuiIconAxisRight=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_["createElement"]("svg",axis_right_extends({width:16,height:16,viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_["createElement"]("title",{id:titleId},title):null,external_kbnSharedDeps_React_["createElement"]("path",{d:"M8.622 3.585a.5.5 0 01-.353-.854L10.39.611a1.5 1.5 0 012.121 0l2.122 2.12a.5.5 0 11-.707.707l-2.122-2.12a.5.5 0 00-.707 0l-2.121 2.12a.5.5 0 01-.354.147z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M11.95 12.915V8.786l.005-.04V3.087a.5.5 0 00-.992-.09l-.01.09v4.129l-.004.04v5.658a.5.5 0 00.992.09l.01-.09z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M11.45 15.829a1.5 1.5 0 01-1.06-.44l-2.122-2.121a.5.5 0 11.707-.707l2.121 2.121a.5.5 0 00.707 0l2.122-2.121a.5.5 0 01.707.707l-2.121 2.121a1.5 1.5 0 01-1.061.44zM2.5 4a.5.5 0 00-.5.5v7a.5.5 0 101 0v-7a.5.5 0 00-.5-.5zM5.5 6.5a.5.5 0 00-1 0v5a.5.5 0 101 0v-5zM7.5 8a.5.5 0 01.5.5v3a.5.5 0 11-1 0v-3a.5.5 0 01.5-.5z"}));function axis_top_extends(){axis_top_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return axis_top_extends.apply(this,arguments)}const EuiIconAxisTop=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_["createElement"]("svg",axis_top_extends({width:16,height:16,viewBox:"0 0 16 16",fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_["createElement"]("title",{id:titleId},title):null,external_kbnSharedDeps_React_["createElement"]("path",{d:"M4.99991 7.49999C4.99991 7.22384 5.22376 6.99999 5.49991 6.99999C5.77605 6.99999 5.99991 7.22384 5.99991 7.49999V14.5C5.99991 14.7761 5.77605 15 5.49991 15C5.22376 15 4.99991 14.7761 4.99991 14.5V7.49999Z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M15.3893 2.38929C15.6706 2.67059 15.8287 3.05212 15.8287 3.44995C15.8287 3.84777 15.6706 4.2293 15.3893 4.51061L13.268 6.63193C13.1742 6.7257 13.0471 6.77838 12.9145 6.77838C12.7818 6.77838 12.6547 6.7257 12.5609 6.63193C12.4671 6.53816 12.4145 6.41098 12.4145 6.27838C12.4145 6.14577 12.4671 6.01859 12.5609 5.92482L14.6822 3.8035C14.776 3.70973 14.8287 3.58256 14.8287 3.44995C14.8287 3.31734 14.776 3.19016 14.6822 3.09639L12.5609 0.975075C12.4671 0.881307 12.4145 0.754129 12.4145 0.621522C12.4145 0.488914 12.4671 0.361736 12.5609 0.267968C12.6547 0.1742 12.7819 0.121521 12.9145 0.121521C13.0471 0.121521 13.1742 0.1742 13.268 0.267968L15.3893 2.38929Z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M3.43867 0.26864C3.53243 0.362408 3.58511 0.489585 3.58511 0.622193C3.58511 0.754801 3.53243 0.881978 3.43867 0.975746L1.31735 3.09707C1.22358 3.19083 1.1709 3.31801 1.1709 3.45062C1.1709 3.58323 1.22358 3.71041 1.31735 3.80417L3.43867 5.92549C3.53243 6.01926 3.58511 6.14644 3.58511 6.27905C3.58511 6.41166 3.53243 6.53883 3.43867 6.6326C3.3449 6.72637 3.21772 6.77905 3.08511 6.77905C2.9525 6.77905 2.82533 6.72637 2.73156 6.6326L0.610239 4.51128C0.328934 4.22998 0.170898 3.84844 0.170898 3.45062C0.170898 3.0528 0.328934 2.67126 0.610238 2.38996L2.73156 0.26864C2.82533 0.174871 2.9525 0.122192 3.08511 0.122192C3.21772 0.122192 3.3449 0.174871 3.43867 0.26864Z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M7.99991 6.99999C8.27605 6.99999 8.49991 7.22384 8.49991 7.49999V12.5C8.49991 12.7761 8.27605 13 7.99991 13C7.72377 13 7.49991 12.7761 7.49991 12.5V7.49999C7.49991 7.22384 7.72377 6.99999 7.99991 6.99999Z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M10.9999 7.49999C10.9999 7.22384 10.776 6.99999 10.4999 6.99999C10.2238 6.99999 9.99991 7.22384 9.99991 7.49999V10.5C9.99991 10.7761 10.2238 11 10.4999 11C10.776 11 10.9999 10.7761 10.9999 10.5V7.49999Z"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M3.50015 2.99999C3.22401 2.99999 3.00015 3.22384 3.00015 3.49999C3.00015 3.77613 3.22401 3.99999 3.50015 3.99999H12.5002C12.7763 3.99999 13.0002 3.77613 13.0002 3.49999C13.0002 3.22384 12.7763 2.99999 12.5002 2.99999H3.50015Z"}));const popoverConfig=(axis,isHorizontal)=>{switch(axis){case"yLeft":return{icon:isHorizontal?EuiIconAxisBottom:EuiIconAxisLeft,groupPosition:"left",popoverTitle:isHorizontal?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.bottomAxisLabel",{defaultMessage:"Bottom axis"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.leftAxisLabel",{defaultMessage:"Left axis"}),buttonDataTestSubj:"lnsLeftAxisButton"};case"yRight":return{icon:isHorizontal?EuiIconAxisTop:EuiIconAxisRight,groupPosition:"right",popoverTitle:isHorizontal?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.topAxisLabel",{defaultMessage:"Top axis"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.rightAxisLabel",{defaultMessage:"Right axis"}),buttonDataTestSubj:"lnsRightAxisButton"};case"x":default:return{icon:isHorizontal?EuiIconAxisLeft:EuiIconAxisBottom,groupPosition:"center",popoverTitle:isHorizontal?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.leftAxisLabel",{defaultMessage:"Left axis"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.bottomAxisLabel",{defaultMessage:"Bottom axis"}),buttonDataTestSubj:"lnsBottomAxisButton"}}};const AxisSettingsPopover=({layers:layers,axis:axis,axisTitle:axisTitle,updateTitleState:updateTitleState,toggleTickLabelsVisibility:toggleTickLabelsVisibility,toggleGridlinesVisibility:toggleGridlinesVisibility,isDisabled:isDisabled,areTickLabelsVisible:areTickLabelsVisible,areGridlinesVisible:areGridlinesVisible,isAxisTitleVisible:isAxisTitleVisible,toggleAxisTitleVisibility:toggleAxisTitleVisibility})=>{const[title,setTitle]=Object(external_kbnSharedDeps_React_["useState"])(axisTitle);const isHorizontal=layers!==null&&layers!==void 0&&layers.length?isHorizontalChart(layers):false;const config=popoverConfig(axis,isHorizontal);const onTitleChange=value=>{setTitle(value);updateTitleState(value)};return external_kbnSharedDeps_React_default.a.createElement(ToolbarPopover,{title:config.popoverTitle,type:config.icon,groupPosition:config.groupPosition,isDisabled:isDisabled,buttonDataTestSubj:config.buttonDataTestSubj},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisNameLabel",{defaultMessage:"Axis name"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,"data-test-subj":`lnsShowAxisTitleSwitch__${axis}`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.ShowAxisTitleLabel",{defaultMessage:"Show"}),onChange:({target:target})=>toggleAxisTitleVisibility(axis,target.checked),checked:isAxisTitleVisible}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{"data-test-subj":`lns${axis}AxisTitle`,compressed:true,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.overwriteAxisTitle",{defaultMessage:"Overwrite axis title"}),value:title||"",disabled:!isAxisTitleVisible||false,onChange:({target:target})=>onTitleChange(target.value),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.overwriteAxisTitle",{defaultMessage:"Overwrite axis title"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,"data-test-subj":`lnsshow${axis}AxisTickLabels`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.tickLabels",{defaultMessage:"Tick labels"}),onChange:()=>toggleTickLabelsVisibility(axis),checked:areTickLabelsVisible}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,"data-test-subj":`lnsshow${axis}AxisGridlines`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.Gridlines",{defaultMessage:"Gridlines"}),onChange:()=>toggleGridlinesVisibility(axis),checked:areGridlinesVisible}))};const TooltipWrapper=({children:children,condition:condition,tooltipContent:tooltipContent})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,condition?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:tooltipContent,delay:"long"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,children)):children);const getSortedAccessors=(datasource,layer)=>{const originalOrder=datasource.getTableSpec().map(({columnId:columnId})=>columnId).filter(columnId=>layer.accessors.includes(columnId));return Array.from(new Set(originalOrder.concat(layer.accessors)))};const xy_visualization_to_expression_toExpression=(state,datasourceLayers,paletteService,attributes={})=>{if(!state||!state.layers.length){return null}const metadata={};state.layers.forEach(layer=>{metadata[layer.layerId]={};const datasource=datasourceLayers[layer.layerId];datasource.getTableSpec().forEach(column=>{const operation=datasourceLayers[layer.layerId].getOperationForColumnId(column.columnId);metadata[layer.layerId][column.columnId]=operation})});return buildExpression(state,metadata,datasourceLayers,paletteService,attributes)};function to_expression_toPreviewExpression(state,datasourceLayers,paletteService){return xy_visualization_to_expression_toExpression({...state,layers:state.layers.map(layer=>({...layer,hide:true})),legend:{...state.legend,isVisible:false},valueLabels:"hide"},datasourceLayers,paletteService,{})}function getScaleType(metadata,defaultScale){if(!metadata){return defaultScale}if(metadata.scale==="ordinal"){return external_kbnSharedDeps_ElasticCharts_["ScaleType"].Ordinal}if(metadata.scale==="interval"||metadata.scale==="ratio"){return metadata.dataType==="date"?external_kbnSharedDeps_ElasticCharts_["ScaleType"].Time:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear}switch(metadata.dataType){case"boolean":case"string":case"ip":return external_kbnSharedDeps_ElasticCharts_["ScaleType"].Ordinal;case"date":return external_kbnSharedDeps_ElasticCharts_["ScaleType"].Time;default:return external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear}}const buildExpression=(state,metadata,datasourceLayers,paletteService,attributes={})=>{var _state$axisTitlesVisi,_state$axisTitlesVisi2,_state$axisTitlesVisi3,_state$axisTitlesVisi4,_state$axisTitlesVisi5,_state$axisTitlesVisi6,_state$tickLabelsVisi,_state$tickLabelsVisi2,_state$tickLabelsVisi3,_state$tickLabelsVisi4,_state$tickLabelsVisi5,_state$tickLabelsVisi6,_state$gridlinesVisib,_state$gridlinesVisib2,_state$gridlinesVisib3,_state$gridlinesVisib4,_state$gridlinesVisib5,_state$gridlinesVisib6;const validLayers=state.layers.filter(layer=>Boolean(layer.accessors.length)).map(layer=>{if(!datasourceLayers){return layer}const sortedAccessors=getSortedAccessors(datasourceLayers[layer.layerId],layer);return{...layer,accessors:sortedAccessors}});if(!validLayers.length){return null}return{type:"expression",chain:[{type:"function",function:"lens_xy_chart",arguments:{title:[(attributes===null||attributes===void 0?void 0:attributes.title)||""],description:[(attributes===null||attributes===void 0?void 0:attributes.description)||""],xTitle:[state.xTitle||""],yTitle:[state.yTitle||""],yRightTitle:[state.yRightTitle||""],legend:[{type:"expression",chain:[{type:"function",function:"lens_xy_legendConfig",arguments:{isVisible:[state.legend.isVisible],showSingleSeries:state.legend.showSingleSeries?[state.legend.showSingleSeries]:[],position:[state.legend.position]}}]}],fittingFunction:[state.fittingFunction||"None"],axisTitlesVisibilitySettings:[{type:"expression",chain:[{type:"function",function:"lens_xy_axisTitlesVisibilityConfig",arguments:{x:[(_state$axisTitlesVisi=state===null||state===void 0?void 0:(_state$axisTitlesVisi2=state.axisTitlesVisibilitySettings)===null||_state$axisTitlesVisi2===void 0?void 0:_state$axisTitlesVisi2.x)!==null&&_state$axisTitlesVisi!==void 0?_state$axisTitlesVisi:true],yLeft:[(_state$axisTitlesVisi3=state===null||state===void 0?void 0:(_state$axisTitlesVisi4=state.axisTitlesVisibilitySettings)===null||_state$axisTitlesVisi4===void 0?void 0:_state$axisTitlesVisi4.yLeft)!==null&&_state$axisTitlesVisi3!==void 0?_state$axisTitlesVisi3:true],yRight:[(_state$axisTitlesVisi5=state===null||state===void 0?void 0:(_state$axisTitlesVisi6=state.axisTitlesVisibilitySettings)===null||_state$axisTitlesVisi6===void 0?void 0:_state$axisTitlesVisi6.yRight)!==null&&_state$axisTitlesVisi5!==void 0?_state$axisTitlesVisi5:true]}}]}],tickLabelsVisibilitySettings:[{type:"expression",chain:[{type:"function",function:"lens_xy_tickLabelsConfig",arguments:{x:[(_state$tickLabelsVisi=state===null||state===void 0?void 0:(_state$tickLabelsVisi2=state.tickLabelsVisibilitySettings)===null||_state$tickLabelsVisi2===void 0?void 0:_state$tickLabelsVisi2.x)!==null&&_state$tickLabelsVisi!==void 0?_state$tickLabelsVisi:true],yLeft:[(_state$tickLabelsVisi3=state===null||state===void 0?void 0:(_state$tickLabelsVisi4=state.tickLabelsVisibilitySettings)===null||_state$tickLabelsVisi4===void 0?void 0:_state$tickLabelsVisi4.yLeft)!==null&&_state$tickLabelsVisi3!==void 0?_state$tickLabelsVisi3:true],yRight:[(_state$tickLabelsVisi5=state===null||state===void 0?void 0:(_state$tickLabelsVisi6=state.tickLabelsVisibilitySettings)===null||_state$tickLabelsVisi6===void 0?void 0:_state$tickLabelsVisi6.yRight)!==null&&_state$tickLabelsVisi5!==void 0?_state$tickLabelsVisi5:true]}}]}],gridlinesVisibilitySettings:[{type:"expression",chain:[{type:"function",function:"lens_xy_gridlinesConfig",arguments:{x:[(_state$gridlinesVisib=state===null||state===void 0?void 0:(_state$gridlinesVisib2=state.gridlinesVisibilitySettings)===null||_state$gridlinesVisib2===void 0?void 0:_state$gridlinesVisib2.x)!==null&&_state$gridlinesVisib!==void 0?_state$gridlinesVisib:true],yLeft:[(_state$gridlinesVisib3=state===null||state===void 0?void 0:(_state$gridlinesVisib4=state.gridlinesVisibilitySettings)===null||_state$gridlinesVisib4===void 0?void 0:_state$gridlinesVisib4.yLeft)!==null&&_state$gridlinesVisib3!==void 0?_state$gridlinesVisib3:true],yRight:[(_state$gridlinesVisib5=state===null||state===void 0?void 0:(_state$gridlinesVisib6=state.gridlinesVisibilitySettings)===null||_state$gridlinesVisib6===void 0?void 0:_state$gridlinesVisib6.yRight)!==null&&_state$gridlinesVisib5!==void 0?_state$gridlinesVisib5:true]}}]}],valueLabels:[(state===null||state===void 0?void 0:state.valueLabels)||"hide"],layers:validLayers.map(layer=>{const columnToLabel=getColumnToLabelMap(layer,datasourceLayers[layer.layerId]);const xAxisOperation=datasourceLayers&&datasourceLayers[layer.layerId].getOperationForColumnId(layer.xAccessor);const isHistogramDimension=Boolean(xAxisOperation&&xAxisOperation.isBucketed&&xAxisOperation.scale&&xAxisOperation.scale!=="ordinal");return{type:"expression",chain:[{type:"function",function:"lens_xy_layer",arguments:{layerId:[layer.layerId],hide:[Boolean(layer.hide)],xAccessor:layer.xAccessor?[layer.xAccessor]:[],yScaleType:[getScaleType(metadata[layer.layerId][layer.accessors[0]],external_kbnSharedDeps_ElasticCharts_["ScaleType"].Ordinal)],xScaleType:[getScaleType(metadata[layer.layerId][layer.xAccessor],external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear)],isHistogram:[isHistogramDimension],splitAccessor:layer.splitAccessor?[layer.splitAccessor]:[],yConfig:layer.yConfig?layer.yConfig.map(yConfig=>({type:"expression",chain:[{type:"function",function:"lens_xy_yConfig",arguments:{forAccessor:[yConfig.forAccessor],axisMode:yConfig.axisMode?[yConfig.axisMode]:[],color:yConfig.color?[yConfig.color]:[]}}]})):[],seriesType:[layer.seriesType],accessors:layer.accessors,columnToLabel:[JSON.stringify(columnToLabel)],...layer.palette?{palette:[{type:"expression",chain:[{type:"function",function:"theme",arguments:{variable:["palette"],default:[paletteService.get(layer.palette.name).toExpression(layer.palette.params)]}}]}]}:{}}}]}})}}]}};function xy_config_panel_updateLayer(state,layer,index){const newLayers=[...state.layers];newLayers[index]=layer;return{...state,layers:newLayers}}const xy_config_panel_legendOptions=[{id:`xy_legend_auto`,value:"auto",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.legendVisibility.auto",{defaultMessage:"Auto"})},{id:`xy_legend_show`,value:"show",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.legendVisibility.show",{defaultMessage:"Show"})},{id:`xy_legend_hide`,value:"hide",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.legendVisibility.hide",{defaultMessage:"Hide"})}];const valueLabelsOptions=[{id:`value_labels_hide`,value:"hide",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.valueLabelsVisibility.auto",{defaultMessage:"Hide"}),"data-test-subj":"lnsXY_valueLabels_hide"},{id:`value_labels_inside`,value:"inside",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.valueLabelsVisibility.inside",{defaultMessage:"Show"}),"data-test-subj":"lnsXY_valueLabels_inside"}];function LayerContextMenu(props){const{state:state,layerId:layerId}=props;const horizontalOnly=isHorizontalChart(state.layers);const index=state.layers.findIndex(l=>l.layerId===layerId);const layer=state.layers[index];if(!layer){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.chartTypeLabel",{defaultMessage:"Chart type"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.chartTypeLegend",{defaultMessage:"Chart type"}),name:"chartType",className:"eui-displayInlineBlock",options:types_visualizationTypes.filter(t=>isHorizontalSeries(t.id)===horizontalOnly).map(t=>({id:t.id,label:t.label,iconType:t.icon||"empty","data-test-subj":`lnsXY_seriesType-${t.id}`})),idSelected:layer.seriesType,onChange:seriesType=>{Object(lens_ui_telemetry["e"])("xy_change_layer_display");props.setState(xy_config_panel_updateLayer(state,{...layer,seriesType:seriesType},index))},isIconOnly:true}))}function getValueLabelDisableReason({isAreaPercentage:isAreaPercentage,isHistogramSeries:isHistogramSeries}){if(isHistogramSeries){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.valuesHistogramDisabledHelpText",{defaultMessage:"This setting cannot be changed on histograms."})}if(isAreaPercentage){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.valuesPercentageDisabledHelpText",{defaultMessage:"This setting cannot be changed on percentage area charts."})}return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.valuesStackedDisabledHelpText",{defaultMessage:"This setting cannot be changed on stacked or percentage bar charts"})}const xy_config_panel_XyToolbar=Object(external_kbnSharedDeps_React_["memo"])((function XyToolbar(props){var _state$tickLabelsVisi,_state$tickLabelsVisi2,_state$tickLabelsVisi3,_state$tickLabelsVisi4,_state$tickLabelsVisi5,_state$tickLabelsVisi6,_state$gridlinesVisib,_state$gridlinesVisib2,_state$gridlinesVisib3,_state$gridlinesVisib4,_state$gridlinesVisib5,_state$gridlinesVisib6,_state$axisTitlesVisi,_state$axisTitlesVisi2,_state$axisTitlesVisi3,_state$axisTitlesVisi4,_state$axisTitlesVisi5,_state$axisTitlesVisi6;const{state:state,setState:setState,frame:frame}=props;const hasNonBarSeries=state===null||state===void 0?void 0:state.layers.some(({seriesType:seriesType})=>["area_stacked","area","line"].includes(seriesType));const hasBarNotStacked=state===null||state===void 0?void 0:state.layers.some(({seriesType:seriesType})=>["bar","bar_horizontal"].includes(seriesType));const isAreaPercentage=state===null||state===void 0?void 0:state.layers.some(({seriesType:seriesType})=>seriesType==="area_percentage_stacked");const isHistogramSeries=Boolean(hasHistogramSeries(state===null||state===void 0?void 0:state.layers,frame.datasourceLayers));const shouldRotate=state!==null&&state!==void 0&&state.layers.length?isHorizontalChart(state.layers):false;const axisGroups=getAxesConfiguration(state===null||state===void 0?void 0:state.layers,shouldRotate);const tickLabelsVisibilitySettings={x:(_state$tickLabelsVisi=state===null||state===void 0?void 0:(_state$tickLabelsVisi2=state.tickLabelsVisibilitySettings)===null||_state$tickLabelsVisi2===void 0?void 0:_state$tickLabelsVisi2.x)!==null&&_state$tickLabelsVisi!==void 0?_state$tickLabelsVisi:true,yLeft:(_state$tickLabelsVisi3=state===null||state===void 0?void 0:(_state$tickLabelsVisi4=state.tickLabelsVisibilitySettings)===null||_state$tickLabelsVisi4===void 0?void 0:_state$tickLabelsVisi4.yLeft)!==null&&_state$tickLabelsVisi3!==void 0?_state$tickLabelsVisi3:true,yRight:(_state$tickLabelsVisi5=state===null||state===void 0?void 0:(_state$tickLabelsVisi6=state.tickLabelsVisibilitySettings)===null||_state$tickLabelsVisi6===void 0?void 0:_state$tickLabelsVisi6.yRight)!==null&&_state$tickLabelsVisi5!==void 0?_state$tickLabelsVisi5:true};const onTickLabelsVisibilitySettingsChange=optionId=>{const newTickLabelsVisibilitySettings={...tickLabelsVisibilitySettings,...{[optionId]:!tickLabelsVisibilitySettings[optionId]}};setState({...state,tickLabelsVisibilitySettings:newTickLabelsVisibilitySettings})};const gridlinesVisibilitySettings={x:(_state$gridlinesVisib=state===null||state===void 0?void 0:(_state$gridlinesVisib2=state.gridlinesVisibilitySettings)===null||_state$gridlinesVisib2===void 0?void 0:_state$gridlinesVisib2.x)!==null&&_state$gridlinesVisib!==void 0?_state$gridlinesVisib:true,yLeft:(_state$gridlinesVisib3=state===null||state===void 0?void 0:(_state$gridlinesVisib4=state.gridlinesVisibilitySettings)===null||_state$gridlinesVisib4===void 0?void 0:_state$gridlinesVisib4.yLeft)!==null&&_state$gridlinesVisib3!==void 0?_state$gridlinesVisib3:true,yRight:(_state$gridlinesVisib5=state===null||state===void 0?void 0:(_state$gridlinesVisib6=state.gridlinesVisibilitySettings)===null||_state$gridlinesVisib6===void 0?void 0:_state$gridlinesVisib6.yRight)!==null&&_state$gridlinesVisib5!==void 0?_state$gridlinesVisib5:true};const onGridlinesVisibilitySettingsChange=optionId=>{const newGridlinesVisibilitySettings={...gridlinesVisibilitySettings,...{[optionId]:!gridlinesVisibilitySettings[optionId]}};setState({...state,gridlinesVisibilitySettings:newGridlinesVisibilitySettings})};const axisTitlesVisibilitySettings={x:(_state$axisTitlesVisi=state===null||state===void 0?void 0:(_state$axisTitlesVisi2=state.axisTitlesVisibilitySettings)===null||_state$axisTitlesVisi2===void 0?void 0:_state$axisTitlesVisi2.x)!==null&&_state$axisTitlesVisi!==void 0?_state$axisTitlesVisi:true,yLeft:(_state$axisTitlesVisi3=state===null||state===void 0?void 0:(_state$axisTitlesVisi4=state.axisTitlesVisibilitySettings)===null||_state$axisTitlesVisi4===void 0?void 0:_state$axisTitlesVisi4.yLeft)!==null&&_state$axisTitlesVisi3!==void 0?_state$axisTitlesVisi3:true,yRight:(_state$axisTitlesVisi5=state===null||state===void 0?void 0:(_state$axisTitlesVisi6=state.axisTitlesVisibilitySettings)===null||_state$axisTitlesVisi6===void 0?void 0:_state$axisTitlesVisi6.yRight)!==null&&_state$axisTitlesVisi5!==void 0?_state$axisTitlesVisi5:true};const onAxisTitlesVisibilitySettingsChange=(axis,checked)=>{const newAxisTitlesVisibilitySettings={...axisTitlesVisibilitySettings,...{[axis]:checked}};setState({...state,axisTitlesVisibilitySettings:newAxisTitlesVisibilitySettings})};const legendMode=state!==null&&state!==void 0&&state.legend.isVisible&&!(state!==null&&state!==void 0&&state.legend.showSingleSeries)?"auto":!(state!==null&&state!==void 0&&state.legend.isVisible)?"hide":"show";const valueLabelsVisibilityMode=(state===null||state===void 0?void 0:state.valueLabels)||"hide";const isValueLabelsEnabled=!hasNonBarSeries&&hasBarNotStacked&&!isHistogramSeries;const isFittingEnabled=hasNonBarSeries;const valueLabelsDisabledReason=getValueLabelDisableReason({isAreaPercentage:isAreaPercentage,isHistogramSeries:isHistogramSeries});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",responsive:false},external_kbnSharedDeps_React_default.a.createElement(TooltipWrapper,{tooltipContent:valueLabelsDisabledReason,condition:!isValueLabelsEnabled&&!isFittingEnabled},external_kbnSharedDeps_React_default.a.createElement(ToolbarPopover,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.valuesLabel",{defaultMessage:"Values"}),type:"values",groupPosition:"left",buttonDataTestSubj:"lnsValuesButton",isDisabled:!isValueLabelsEnabled&&!isFittingEnabled},isValueLabelsEnabled?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",label:external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.chartValueLabelVisibilityLabel",{defaultMessage:"Labels"}))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{isFullWidth:true,legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.shared.chartValueLabelVisibilityLabel",{defaultMessage:"Labels"}),"data-test-subj":"lnsValueLabelsDisplay",name:"valueLabelsDisplay",buttonSize:"compressed",options:valueLabelsOptions,idSelected:valueLabelsOptions.find(({value:value})=>value===valueLabelsVisibilityMode).id,onChange:modeId=>{const newMode=valueLabelsOptions.find(({id:id})=>id===modeId).value;setState({...state,valueLabels:newMode})}})):null,isFittingEnabled?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.missingValuesLabel",{defaultMessage:"Missing values"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"subdued",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.missingValuesLabelHelpText",{defaultMessage:`By default, Lens hides the gaps in the data. To fill the gap, make a selection.`}),iconProps:{className:"eui-alignTop"},position:"top",size:"s",type:"questionInCircle"}))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperSelect"],{"data-test-subj":"lnsMissingValuesSelect",compressed:true,options:fittingFunctionDefinitions.map(({id:id,title:title,description:description})=>({value:id,dropdownDisplay:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,title),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,description))),inputDisplay:title})),valueOfSelected:(state===null||state===void 0?void 0:state.fittingFunction)||"None",onChange:value=>setState({...state,fittingFunction:value}),itemLayoutAlign:"top",hasDividers:true})):null)),external_kbnSharedDeps_React_default.a.createElement(LegendSettingsPopover,{legendOptions:xy_config_panel_legendOptions,mode:legendMode,onDisplayChange:optionId=>{const newMode=xy_config_panel_legendOptions.find(({id:id})=>id===optionId).value;if(newMode==="auto"){setState({...state,legend:{...state.legend,isVisible:true,showSingleSeries:false}})}else if(newMode==="show"){setState({...state,legend:{...state.legend,isVisible:true,showSingleSeries:true}})}else if(newMode==="hide"){setState({...state,legend:{...state.legend,isVisible:false,showSingleSeries:false}})}},position:state===null||state===void 0?void 0:state.legend.position,onPositionChange:id=>{setState({...state,legend:{...state.legend,position:id}})}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",responsive:false},external_kbnSharedDeps_React_default.a.createElement(TooltipWrapper,{tooltipContent:shouldRotate?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.bottomAxisDisabledHelpText",{defaultMessage:"This setting only applies when bottom axis is enabled."}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.leftAxisDisabledHelpText",{defaultMessage:"This setting only applies when left axis is enabled."}),condition:Object.keys(axisGroups.find(group=>group.groupId==="left")||{}).length===0},external_kbnSharedDeps_React_default.a.createElement(AxisSettingsPopover,{axis:"yLeft",layers:state===null||state===void 0?void 0:state.layers,axisTitle:state===null||state===void 0?void 0:state.yTitle,updateTitleState:value=>setState({...state,yTitle:value}),areTickLabelsVisible:tickLabelsVisibilitySettings.yLeft,toggleTickLabelsVisibility:onTickLabelsVisibilitySettingsChange,areGridlinesVisible:gridlinesVisibilitySettings.yLeft,toggleGridlinesVisibility:onGridlinesVisibilitySettingsChange,isDisabled:Object.keys(axisGroups.find(group=>group.groupId==="left")||{}).length===0,isAxisTitleVisible:axisTitlesVisibilitySettings.yLeft,toggleAxisTitleVisibility:onAxisTitlesVisibilitySettingsChange})),external_kbnSharedDeps_React_default.a.createElement(AxisSettingsPopover,{axis:"x",layers:state===null||state===void 0?void 0:state.layers,axisTitle:state===null||state===void 0?void 0:state.xTitle,updateTitleState:value=>setState({...state,xTitle:value}),areTickLabelsVisible:tickLabelsVisibilitySettings.x,toggleTickLabelsVisibility:onTickLabelsVisibilitySettingsChange,areGridlinesVisible:gridlinesVisibilitySettings.x,toggleGridlinesVisibility:onGridlinesVisibilitySettingsChange,isAxisTitleVisible:axisTitlesVisibilitySettings.x,toggleAxisTitleVisibility:onAxisTitlesVisibilitySettingsChange}),external_kbnSharedDeps_React_default.a.createElement(TooltipWrapper,{tooltipContent:shouldRotate?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.topAxisDisabledHelpText",{defaultMessage:"This setting only applies when top axis is enabled."}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.rightAxisDisabledHelpText",{defaultMessage:"This setting only applies when right axis is enabled."}),condition:Object.keys(axisGroups.find(group=>group.groupId==="right")||{}).length===0},external_kbnSharedDeps_React_default.a.createElement(AxisSettingsPopover,{axis:"yRight",layers:state===null||state===void 0?void 0:state.layers,axisTitle:state===null||state===void 0?void 0:state.yRightTitle,updateTitleState:value=>setState({...state,yRightTitle:value}),areTickLabelsVisible:tickLabelsVisibilitySettings.yRight,toggleTickLabelsVisibility:onTickLabelsVisibilitySettingsChange,areGridlinesVisible:gridlinesVisibilitySettings.yRight,toggleGridlinesVisibility:onGridlinesVisibilitySettingsChange,isDisabled:Object.keys(axisGroups.find(group=>group.groupId==="right")||{}).length===0,isAxisTitleVisible:axisTitlesVisibilitySettings.yRight,toggleAxisTitleVisibility:onAxisTitlesVisibilitySettingsChange})))))}));const xy_config_panel_idPrefix=Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])()();function xy_config_panel_DimensionEditor(props){var _layer$yConfig,_layer$yConfig$find;const{state:state,setState:setState,layerId:layerId,accessor:accessor}=props;const index=state.layers.findIndex(l=>l.layerId===layerId);const layer=state.layers[index];const isHorizontal=isHorizontalChart(state.layers);const axisMode=layer.yConfig&&((_layer$yConfig=layer.yConfig)===null||_layer$yConfig===void 0?void 0:(_layer$yConfig$find=_layer$yConfig.find(yAxisConfig=>yAxisConfig.forAccessor===accessor))===null||_layer$yConfig$find===void 0?void 0:_layer$yConfig$find.axisMode)||"auto";if(props.groupId==="breakdown"){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(PalettePicker,{palettes:props.paletteService,activePalette:layer.palette,setPalette:newPalette=>{setState(xy_config_panel_updateLayer(state,{...layer,palette:newPalette},index))}}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ColorPicker,props),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.label",{defaultMessage:"Axis side"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{isFullWidth:true,legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.label",{defaultMessage:"Axis side"}),"data-test-subj":"lnsXY_axisSide_groups",name:"axisSide",buttonSize:"compressed",options:[{id:`${xy_config_panel_idPrefix}auto`,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.auto",{defaultMessage:"Auto"}),"data-test-subj":"lnsXY_axisSide_groups_auto"},{id:`${xy_config_panel_idPrefix}left`,label:isHorizontal?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.bottom",{defaultMessage:"Bottom"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.left",{defaultMessage:"Left"}),"data-test-subj":"lnsXY_axisSide_groups_left"},{id:`${xy_config_panel_idPrefix}right`,label:isHorizontal?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.top",{defaultMessage:"Top"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.axisSide.right",{defaultMessage:"Right"}),"data-test-subj":"lnsXY_axisSide_groups_right"}],idSelected:`${xy_config_panel_idPrefix}${axisMode}`,onChange:id=>{const newMode=id.replace(xy_config_panel_idPrefix,"");const newYAxisConfigs=[...layer.yConfig||[]];const existingIndex=newYAxisConfigs.findIndex(yAxisConfig=>yAxisConfig.forAccessor===accessor);if(existingIndex!==-1){newYAxisConfigs[existingIndex].axisMode=newMode}else{newYAxisConfigs.push({forAccessor:accessor,axisMode:newMode})}setState(xy_config_panel_updateLayer(state,{...layer,yConfig:newYAxisConfigs},index))}})))}const xy_config_panel_tooltipContent={auto:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configPanel.color.tooltip.auto",{defaultMessage:"Lens automatically picks colors for you unless you specify a custom color."}),custom:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configPanel.color.tooltip.custom",{defaultMessage:"Clear the custom color to return to “Auto” mode."}),disabled:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configPanel.color.tooltip.disabled",{defaultMessage:"Individual series cannot be custom colored when the layer includes a “Break down by.“"})};const ColorPicker=({state:state,setState:setState,layerId:layerId,accessor:accessor,frame:frame,formatFactory:formatFactory,paletteService:paletteService})=>{const index=state.layers.findIndex(l=>l.layerId===layerId);const layer=state.layers[index];const disabled=!!layer.splitAccessor;const overwriteColor=getSeriesColor(layer,accessor);const currentColor=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _mappedAccessors$find;if(overwriteColor||!frame.activeData)return overwriteColor;const datasource=frame.datasourceLayers[layer.layerId];const sortedAccessors=getSortedAccessors(datasource,layer);const colorAssignments=getColorAssignments(state.layers,{tables:frame.activeData},formatFactory);const mappedAccessors=getAccessorColorConfig(colorAssignments,frame,{...layer,accessors:sortedAccessors.filter(sorted=>layer.accessors.includes(sorted))},paletteService);return((_mappedAccessors$find=mappedAccessors.find(a=>a.columnId===accessor))===null||_mappedAccessors$find===void 0?void 0:_mappedAccessors$find.color)||null},[overwriteColor,frame,paletteService,state.layers,accessor,formatFactory,layer]);const[color,setColor]=Object(external_kbnSharedDeps_React_["useState"])(currentColor);const handleColor=(text,output)=>{setColor(text);if(output.isValid||text===""){updateColorInState(text,output)}};const updateColorInState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_Lodash_["debounce"])((text,output)=>{const newYConfigs=[...layer.yConfig||[]];const existingIndex=newYConfigs.findIndex(yConfig=>yConfig.forAccessor===accessor);if(existingIndex!==-1){if(text===""){delete newYConfigs[existingIndex].color}else{newYConfigs[existingIndex].color=output.hex}}else{newYConfigs.push({forAccessor:accessor,color:output.hex})}setState(xy_config_panel_updateLayer(state,{...layer,yConfig:newYConfigs},index))},256),[state,setState,layer,accessor,index]);const colorPicker=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPicker"],{"data-test-subj":"indexPattern-dimension-colorPicker",compressed:true,isClearable:Boolean(overwriteColor),onChange:handleColor,color:disabled?"":color||currentColor,disabled:disabled,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.seriesColor.auto",{defaultMessage:"Auto"}),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.seriesColor.label",{defaultMessage:"Series color"})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{delay:"long",position:"top",content:color&&!disabled?xy_config_panel_tooltipContent.custom:xy_config_panel_tooltipContent.auto},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.seriesColor.label",{defaultMessage:"Series color"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued",size:"s",className:"eui-alignTop"})))},disabled?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:xy_config_panel_tooltipContent.disabled,delay:"long",anchorClassName:"eui-displayBlock"},colorPicker):colorPicker)};function chart_mixed_xy_extends(){chart_mixed_xy_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return chart_mixed_xy_extends.apply(this,arguments)}const LensIconChartMixedXy=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_default.a.createElement("svg",chart_mixed_xy_extends({viewBox:"0 0 30 22",width:30,height:22,fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_default.a.createElement("title",{id:titleId},title):null,external_kbnSharedDeps_React_default.a.createElement("path",{d:"M24 16l.186-.002.345-.02.266-.03.334-.058.193-.043.25-.067.223-.07.215-.074.209-.079.305-.124c.166-.07.34-.148.524-.234l.285-.135 1.202-.588c.428-.203.728-.326.966-.396.146-.044.27-.067.384-.076L30 14v7a1 1 0 01-1 1H1a1 1 0 01-1-1v-2c1 0 3.5-4 6-4s5 3 6 3 3.23-7.994 5.865-7.997L19.032 10l.541 1.205.272.595.29.612c.517 1.069.955 1.842 1.391 2.391.08.1.16.194.241.28.095.101.189.191.283.272l.143.114c.218.164.446.284.69.368.207.071.426.116.662.14l.14.012.154.008L24 16zm6-12v6l-.186.002-.345.02-.266.03-.331.057-.196.044-.25.067-.304.097-.134.047a9.492 9.492 0 00-.386.15l-.128.053c-.166.07-.34.148-.524.234l-.285.135-1.264.618-.352.159-.187.078-.256.095-.178.054a13.872 13.872 0 01-.38-.687l-.16-.311-.233-.47-.016-.472H24c1 0 3-6 6-6z",className:"lensChartIcon__accent"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M30 13c-.507 0-.988.146-1.89.571l-1.209.592C25.621 14.78 24.924 15 24 15c-1.384 0-2.003-.865-3.516-4.206l-.637-1.42-.346-.749-.213-.445C18.572 6.698 18.127 6 18 6c-.466 0-.967.252-1.99.997l-.891.659-.458.325C13.576 8.728 12.907 9 12 9c-1.269 0-1.966-.69-3.492-2.939l-.774-1.146-.272-.387-.26-.358C6.581 3.342 6.213 3 6 3c-.294 0-.885.651-2.017 2.33l-.491.731-.326.475C1.859 8.409 1.175 9 0 9V7c.294 0 .885-.651 2.017-2.33l.491-.731.326-.475C4.141 1.591 4.825 1 6 1c1.269 0 1.966.69 3.492 2.939l.774 1.146.272.387.26.358C11.419 6.658 11.788 7 12 7c.466 0 .967-.252 1.99-.997l.891-.659.458-.325C16.424 4.272 17.093 4 18 4c1.384 0 2.003.865 3.516 4.206l.637 1.42.346.749.213.445C23.428 12.302 23.873 13 24 13c.507 0 .988-.146 1.89-.571l1.209-.592C28.379 11.22 29.076 11 30 11v2z",className:"lensChartIcon__subdued"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M6 13v7.889C6 21.503 5.552 22 5 22H1c-.552 0-1-.497-1-1.111V13a1 1 0 011-1h4a1 1 0 011 1zm8-1v9a1 1 0 01-1 1H9a1 1 0 01-1-1v-9a1 1 0 011-1h4a1 1 0 011 1zm8 5v4a1 1 0 01-1 1h-4a1 1 0 01-1-1v-4a1 1 0 011-1h4a1 1 0 011 1zm8 2v2a1 1 0 01-1 1h-4a1 1 0 01-1-1v-2a1 1 0 011-1h4a1 1 0 011 1z",className:"lensChartIcon__subdued"}));function xy_visualization_visualization_extends(){xy_visualization_visualization_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return xy_visualization_visualization_extends.apply(this,arguments)}const defaultIcon=LensIconChartBarStacked;const defaultSeriesType="bar_stacked";const isNumericMetric=op=>!op.isBucketed&&op.dataType==="number";const visualization_isBucketed=op=>op.isBucketed;function getVisualizationType(state){if(!state.layers.length){var _visualizationTypes$f;return(_visualizationTypes$f=types_visualizationTypes.find(t=>t.id===state.preferredSeriesType))!==null&&_visualizationTypes$f!==void 0?_visualizationTypes$f:types_visualizationTypes[0]}const visualizationType=types_visualizationTypes.find(t=>t.id===state.layers[0].seriesType);const seriesTypes=external_kbnSharedDeps_Lodash_default.a.uniq(state.layers.map(l=>l.seriesType));return visualizationType&&seriesTypes.length===1?visualizationType:"mixed"}function getDescription(state){if(!state){return{icon:defaultIcon,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.xyLabel",{defaultMessage:"XY"})}}const visualizationType=getVisualizationType(state);if(visualizationType==="mixed"&&isHorizontalChart(state.layers)){return{icon:LensIconChartBarHorizontal,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.mixedBarHorizontalLabel",{defaultMessage:"Mixed H. bar"})}}if(visualizationType==="mixed"){return{icon:LensIconChartMixedXy,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.mixedLabel",{defaultMessage:"Mixed XY"})}}return{icon:visualizationType.icon,label:visualizationType.label}}const getXyVisualization=({paletteService:paletteService,data:data})=>({id:"lnsXY",visualizationTypes:types_visualizationTypes,getVisualizationTypeId(state){const type=getVisualizationType(state);return type==="mixed"?type:type.id},getLayerIds(state){return state.layers.map(l=>l.layerId)},removeLayer(state,layerId){return{...state,layers:state.layers.filter(l=>l.layerId!==layerId)}},appendLayer(state,layerId){const usedSeriesTypes=external_kbnSharedDeps_Lodash_default.a.uniq(state.layers.map(layer=>layer.seriesType));return{...state,layers:[...state.layers,visualization_newLayerState(usedSeriesTypes.length===1?usedSeriesTypes[0]:state.preferredSeriesType,layerId)]}},clearLayer(state,layerId){return{...state,layers:state.layers.map(l=>l.layerId!==layerId?l:visualization_newLayerState(state.preferredSeriesType,layerId))}},getDescription(state){const{icon:icon,label:label}=getDescription(state);return{icon:icon||defaultIcon,label:label}},switchVisualizationType(seriesType,state){return{...state,preferredSeriesType:seriesType,layers:state.layers.map(layer=>({...layer,seriesType:seriesType}))}},getSuggestions:xy_suggestions_getSuggestions,initialize(frame,state){return state||{title:"Empty XY chart",legend:{isVisible:true,position:external_kbnSharedDeps_ElasticCharts_["Position"].Right},valueLabels:"hide",preferredSeriesType:defaultSeriesType,layers:[{layerId:frame.addNewLayer(),accessors:[],position:external_kbnSharedDeps_ElasticCharts_["Position"].Top,seriesType:defaultSeriesType,showGridlines:false}]}},getConfiguration({state:state,frame:frame,layerId:layerId}){var _layer$palette,_layer$palette2;const layer=state.layers.find(l=>l.layerId===layerId);if(!layer){return{groups:[]}}const datasource=frame.datasourceLayers[layer.layerId];const sortedAccessors=getSortedAccessors(datasource,layer);let mappedAccessors=sortedAccessors.map(accessor=>({columnId:accessor}));if(frame.activeData){const colorAssignments=getColorAssignments(state.layers,{tables:frame.activeData},data.fieldFormats.deserialize);mappedAccessors=getAccessorColorConfig(colorAssignments,frame,{...layer,accessors:sortedAccessors.filter(sorted=>layer.accessors.includes(sorted))},paletteService)}const isHorizontal=isHorizontalChart(state.layers);return{groups:[{groupId:"x",groupLabel:getAxisName("x",{isHorizontal:isHorizontal}),accessors:layer.xAccessor?[{columnId:layer.xAccessor}]:[],filterOperations:visualization_isBucketed,supportsMoreColumns:!layer.xAccessor,dataTestSubj:"lnsXY_xDimensionPanel"},{groupId:"y",groupLabel:getAxisName("y",{isHorizontal:isHorizontal}),accessors:mappedAccessors,filterOperations:isNumericMetric,supportsMoreColumns:true,required:true,dataTestSubj:"lnsXY_yDimensionPanel",enableDimensionEditor:true},{groupId:"breakdown",groupLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.splitSeries",{defaultMessage:"Break down by"}),accessors:layer.splitAccessor?[{columnId:layer.splitAccessor,triggerIcon:"colorBy",palette:paletteService.get(((_layer$palette=layer.palette)===null||_layer$palette===void 0?void 0:_layer$palette.name)||"default").getColors(10,(_layer$palette2=layer.palette)===null||_layer$palette2===void 0?void 0:_layer$palette2.params)}]:[],filterOperations:visualization_isBucketed,supportsMoreColumns:!layer.splitAccessor,dataTestSubj:"lnsXY_splitDimensionPanel",required:layer.seriesType.includes("percentage"),enableDimensionEditor:true}]}},getMainPalette:state=>{if(!state||state.layers.length===0)return;return state.layers[0].palette},setDimension({prevState:prevState,layerId:layerId,columnId:columnId,groupId:groupId}){const newLayer=prevState.layers.find(l=>l.layerId===layerId);if(!newLayer){return prevState}if(groupId==="x"){newLayer.xAccessor=columnId}if(groupId==="y"){newLayer.accessors=[...newLayer.accessors.filter(a=>a!==columnId),columnId]}if(groupId==="breakdown"){newLayer.splitAccessor=columnId}return{...prevState,layers:prevState.layers.map(l=>l.layerId===layerId?newLayer:l)}},removeDimension({prevState:prevState,layerId:layerId,columnId:columnId}){const newLayer=prevState.layers.find(l=>l.layerId===layerId);if(!newLayer){return prevState}if(newLayer.xAccessor===columnId){delete newLayer.xAccessor}else if(newLayer.splitAccessor===columnId){delete newLayer.splitAccessor;delete newLayer.palette}else if(newLayer.accessors.includes(columnId)){newLayer.accessors=newLayer.accessors.filter(a=>a!==columnId)}if(newLayer.yConfig){newLayer.yConfig=newLayer.yConfig.filter(({forAccessor:forAccessor})=>forAccessor!==columnId)}return{...prevState,layers:prevState.layers.map(l=>l.layerId===layerId?newLayer:l)}},getLayerContextMenuIcon({state:state,layerId:layerId}){const layer=state.layers.find(l=>l.layerId===layerId);const visualizationType=types_visualizationTypes.find(t=>t.id===(layer===null||layer===void 0?void 0:layer.seriesType));return{icon:(visualizationType===null||visualizationType===void 0?void 0:visualizationType.icon)||"gear",label:(visualizationType===null||visualizationType===void 0?void 0:visualizationType.label)||""}},renderLayerContextMenu(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(LayerContextMenu,props)),domElement)},renderToolbar(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(xy_config_panel_XyToolbar,props)),domElement)},renderDimensionEditor(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(xy_config_panel_DimensionEditor,xy_visualization_visualization_extends({},props,{formatFactory:data.fieldFormats.deserialize,paletteService:paletteService}))),domElement)},toExpression:(state,layers,attributes)=>xy_visualization_to_expression_toExpression(state,layers,paletteService,attributes),toPreviewExpression:(state,layers)=>to_expression_toPreviewExpression(state,layers,paletteService),getErrorMessages(state){const hasNoAccessors=({accessors:accessors})=>accessors==null||accessors.length===0;const hasNoSplitAccessor=({splitAccessor:splitAccessor,seriesType:seriesType})=>seriesType.includes("percentage")&&splitAccessor==null;const errors=[];if(state&&state.layers.length>1){const checks=[["Y",hasNoAccessors],["Break down",hasNoSplitAccessor]];const filteredLayers=state.layers.filter(({accessors:accessors,xAccessor:xAccessor,splitAccessor:splitAccessor})=>accessors.length>0||xAccessor!=null||splitAccessor!=null);for(const[dimension,criteria]of checks){const result=validateLayersForDimension(dimension,filteredLayers,criteria);if(!result.valid){errors.push(result.payload)}}}return errors.length?errors:undefined},getWarningMessages(state,frame){if((state===null||state===void 0?void 0:state.layers.length)===0||!frame.activeData){return}const layers=state.layers;const filteredLayers=layers.filter(({accessors:accessors})=>accessors.length>0);const accessorsWithArrayValues=[];for(const layer of filteredLayers){const{layerId:layerId,accessors:accessors}=layer;const rows=frame.activeData[layerId]&&frame.activeData[layerId].rows;if(!rows){break}const columnToLabel=getColumnToLabelMap(layer,frame.datasourceLayers[layerId]);for(const accessor of accessors){const hasArrayValues=rows.some(row=>Array.isArray(row[accessor]));if(hasArrayValues){accessorsWithArrayValues.push(columnToLabel[accessor])}}}return accessorsWithArrayValues.map(label=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,label)," contains array values. Your visualization may not render as expected."))}});function validateLayersForDimension(dimension,layers,missingCriteria){if(layers.every(missingCriteria)||!layers.some(missingCriteria)){return{valid:true}}const layerMissingAccessors=layers.reduce((missing,layer,i)=>{if(missingCriteria(layer)){missing.push(i)}return missing},[]);return{valid:false,payload:getMessageIdsForDimension(dimension,layerMissingAccessors,isHorizontalChart(layers))}}function getAxisName(axis,{isHorizontal:isHorizontal}){const vertical=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.verticalAxisLabel",{defaultMessage:"Vertical axis"});const horizontal=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.horizontalAxisLabel",{defaultMessage:"Horizontal axis"});if(axis==="x"){return isHorizontal?vertical:horizontal}return isHorizontal?horizontal:vertical}function getMessageIdsForDimension(dimension,layers,isHorizontal){const layersList=layers.map(i=>i+1).join(", ");switch(dimension){case"Break down":return{shortMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.dataFailureSplitShort",{defaultMessage:`Missing {axis}.`,values:{axis:"Break down by axis"}}),longMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.dataFailureSplitLong",{defaultMessage:`{layers, plural, one {Layer} other {Layers}} {layersList} {layers, plural, one {requires} other {require}} a field for the {axis}.`,values:{layers:layers.length,layersList:layersList,axis:"Break down by axis"}})};case"Y":return{shortMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.dataFailureYShort",{defaultMessage:`Missing {axis}.`,values:{axis:getAxisName("y",{isHorizontal:isHorizontal})}}),longMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyVisualization.dataFailureYLong",{defaultMessage:`{layers, plural, one {Layer} other {Layers}} {layersList} {layers, plural, one {requires} other {require}} a field for the {axis}.`,values:{layers:layers.length,layersList:layersList,axis:getAxisName("y",{isHorizontal:isHorizontal})}})}}return{shortMessage:"",longMessage:""}}function visualization_newLayerState(seriesType,layerId){return{layerId:layerId,seriesType:seriesType,accessors:[]}}var expressions_public_=__webpack_require__(22);var v4=__webpack_require__(122);var v4_default=__webpack_require__.n(v4);function generateId(){return v4_default()()}function insertOrReplaceColumn(args){if(args.layer.columns[args.columnId]){return replaceColumn(args)}return insertNewColumn(args)}function insertNewColumn({op:op,layer:layer,columnId:columnId,field:field,indexPattern:indexPattern}){var _columnId,_layer$incompleteColu;const operationDefinition=operationDefinitionMap[op];if(!operationDefinition){throw new Error("No suitable operation found for given parameters")}if(layer.columns[columnId]){throw new Error(`Can't insert a column with an ID that is already in use`)}const baseOptions={indexPattern:indexPattern,previousColumn:layer.columns[columnId]};if(operationDefinition.input==="none"){if(field){throw new Error(`Can't create operation ${op} with the provided field ${field.name}`)}const possibleOperation=operationDefinition.getPossibleOperation();const isBucketed=Boolean(possibleOperation.isBucketed);const addOperationFn=isBucketed?addBucket:addMetric;return updateDefaultLabels(addOperationFn(layer,operationDefinition.buildColumn({...baseOptions,layer:layer}),columnId),indexPattern)}if(operationDefinition.input==="fullReference"){if(field){throw new Error(`Reference-based operations can't take a field as input when creating`)}let tempLayer={...layer};const referenceIds=operationDefinition.requiredReferences.map(validation=>{const validOperations=Object.values(operationDefinitionMap).filter(({type:type})=>isOperationAllowedAsReference({validation:validation,operationType:type,indexPattern:indexPattern}));if(!validOperations.length){throw new Error(`Can't create reference, ${op} has a validation function which doesn't allow any operations`)}const newId=generateId();if(validOperations.length===1){const def=validOperations[0];const validFields=def.input==="field"?indexPattern.fields.filter(def.getPossibleOperationForField):[];if(def.input==="none"){tempLayer=insertNewColumn({layer:tempLayer,columnId:newId,op:def.type,indexPattern:indexPattern})}else if(validFields.length===1){tempLayer=insertNewColumn({layer:tempLayer,columnId:newId,op:def.type,indexPattern:indexPattern,field:validFields[0]})}else{tempLayer={...tempLayer,incompleteColumns:{...tempLayer.incompleteColumns,[newId]:{operationType:def.type}}}}}return newId});const possibleOperation=operationDefinition.getPossibleOperation(indexPattern);if(!possibleOperation){throw new Error(`Can't create operation ${op} because it's incompatible with the index pattern`)}const isBucketed=Boolean(possibleOperation.isBucketed);const addOperationFn=isBucketed?addBucket:addMetric;return updateDefaultLabels(addOperationFn(tempLayer,operationDefinition.buildColumn({...baseOptions,layer:tempLayer,referenceIds:referenceIds}),columnId),indexPattern)}const invalidFieldName=(_columnId=((_layer$incompleteColu=layer.incompleteColumns)!==null&&_layer$incompleteColu!==void 0?_layer$incompleteColu:{})[columnId])===null||_columnId===void 0?void 0:_columnId.sourceField;const invalidField=invalidFieldName?indexPattern.getFieldByName(invalidFieldName):undefined;if(!field&&invalidField){const possibleOperation=operationDefinition.getPossibleOperationForField(invalidField);if(!possibleOperation){throw new Error(`Tried to create an invalid operation ${operationDefinition.type} using previously selected field ${invalidField.name}`)}const isBucketed=Boolean(possibleOperation.isBucketed);if(isBucketed){return updateDefaultLabels(addBucket(layer,operationDefinition.buildColumn({...baseOptions,layer:layer,field:invalidField}),columnId),indexPattern)}else{return updateDefaultLabels(addMetric(layer,operationDefinition.buildColumn({...baseOptions,layer:layer,field:invalidField}),columnId),indexPattern)}}else if(!field){var _layer$incompleteColu2;return{...layer,incompleteColumns:{...(_layer$incompleteColu2=layer.incompleteColumns)!==null&&_layer$incompleteColu2!==void 0?_layer$incompleteColu2:{},[columnId]:{operationType:op}}}}const possibleOperation=operationDefinition.getPossibleOperationForField(field);if(!possibleOperation){var _layer$incompleteColu3;return{...layer,incompleteColumns:{...(_layer$incompleteColu3=layer.incompleteColumns)!==null&&_layer$incompleteColu3!==void 0?_layer$incompleteColu3:{},[columnId]:{operationType:op,sourceField:field.name}}}}const isBucketed=Boolean(possibleOperation.isBucketed);const addOperationFn=isBucketed?addBucket:addMetric;return updateDefaultLabels(addOperationFn(layer,operationDefinition.buildColumn({...baseOptions,layer:layer,field:field}),columnId),indexPattern)}function replaceColumn({layer:layer,columnId:columnId,indexPattern:indexPattern,op:op,field:field}){const previousColumn=layer.columns[columnId];if(!previousColumn){throw new Error(`Can't replace column because there is no prior column`)}const isNewOperation=op!==previousColumn.operationType;const operationDefinition=operationDefinitionMap[op];const previousDefinition=operationDefinitionMap[previousColumn.operationType];if(!operationDefinition){throw new Error("No suitable operation found for given parameters")}const baseOptions={columns:layer.columns,indexPattern:indexPattern,previousColumn:previousColumn};if(isNewOperation){let tempLayer={...layer};tempLayer=resetIncomplete(tempLayer,columnId);if(operationDefinition.input==="fullReference"){return applyReferenceTransition({layer:tempLayer,columnId:columnId,previousColumn:previousColumn,op:op,indexPattern:indexPattern})}if(previousDefinition.input==="fullReference"&&previousColumn.references.length===1){const previousReferenceId=previousColumn.references[0];const referenceColumn=layer.columns[previousReferenceId];if(referenceColumn){const referencedOperation=operationDefinitionMap[referenceColumn.operationType];if(referencedOperation.type===op){tempLayer=deleteColumn({layer:tempLayer,columnId:previousReferenceId,indexPattern:indexPattern});tempLayer={...tempLayer,columns:{...tempLayer.columns,[columnId]:copyCustomLabel({...referenceColumn},previousColumn)}};return updateDefaultLabels({...tempLayer,columnOrder:getColumnOrder(tempLayer),columns:adjustColumnReferencesForChangedColumn(tempLayer,columnId)},indexPattern)}else if(!field&&"sourceField"in referenceColumn&&referencedOperation.input==="field"&&operationDefinition.input==="field"){const matchedField=indexPattern.getFieldByName(referenceColumn.sourceField);if(matchedField&&operationDefinition.getPossibleOperationForField(matchedField)){field=matchedField}}}}if(previousDefinition.input==="fullReference"){previousColumn.references.forEach(id=>{tempLayer=deleteColumn({layer:tempLayer,columnId:id,indexPattern:indexPattern})})}if(operationDefinition.input==="none"){let newColumn=operationDefinition.buildColumn({...baseOptions,layer:tempLayer});newColumn=copyCustomLabel(newColumn,previousColumn);const newLayer={...tempLayer,columns:{...tempLayer.columns,[columnId]:newColumn}};return updateDefaultLabels({...tempLayer,columnOrder:getColumnOrder(newLayer),columns:adjustColumnReferencesForChangedColumn(newLayer,columnId)},indexPattern)}if(!field){var _tempLayer$incomplete;if(previousDefinition.input==="fullReference"){tempLayer=deleteColumn({layer:tempLayer,columnId:columnId,indexPattern:indexPattern})}return{...tempLayer,incompleteColumns:{...(_tempLayer$incomplete=tempLayer.incompleteColumns)!==null&&_tempLayer$incomplete!==void 0?_tempLayer$incomplete:{},[columnId]:{operationType:op}}}}const validOperation=operationDefinition.getPossibleOperationForField(field);if(!validOperation){var _tempLayer$incomplete2;return{...tempLayer,incompleteColumns:{...(_tempLayer$incomplete2=tempLayer.incompleteColumns)!==null&&_tempLayer$incomplete2!==void 0?_tempLayer$incomplete2:{},[columnId]:{operationType:op}}}}let newColumn=operationDefinition.buildColumn({...baseOptions,layer:tempLayer,field:field});newColumn=copyCustomLabel(newColumn,previousColumn);const newLayer={...tempLayer,columns:{...tempLayer.columns,[columnId]:newColumn}};return updateDefaultLabels({...tempLayer,columnOrder:getColumnOrder(newLayer),columns:adjustColumnReferencesForChangedColumn(newLayer,columnId)},indexPattern)}else if(operationDefinition.input==="field"&&field&&"sourceField"in previousColumn&&previousColumn.sourceField!==field.name){const newColumn=copyCustomLabel(operationDefinition.onFieldChange(previousColumn,field),previousColumn);const newLayer=resetIncomplete({...layer,columns:{...layer.columns,[columnId]:newColumn}},columnId);return{...newLayer,columnOrder:getColumnOrder(newLayer),columns:adjustColumnReferencesForChangedColumn(newLayer,columnId)}}else{throw new Error("nothing changed")}}function canTransition({layer:layer,columnId:columnId,op:op,field:field,indexPattern:indexPattern,filterOperations:filterOperations}){const previousColumn=layer.columns[columnId];if(!previousColumn){return true}if(previousColumn.operationType===op){return true}try{var _newLayer$incompleteC,_newDefinition$getErr;const newLayer=replaceColumn({layer:layer,columnId:columnId,op:op,field:field,indexPattern:indexPattern});const newDefinition=operationDefinitionMap[op];const newColumn=newLayer.columns[columnId];return Boolean(newColumn)&&!((_newLayer$incompleteC=newLayer.incompleteColumns)!==null&&_newLayer$incompleteC!==void 0&&_newLayer$incompleteC[columnId])&&filterOperations(newColumn)&&!((_newDefinition$getErr=newDefinition.getErrorMessage)!==null&&_newDefinition$getErr!==void 0&&_newDefinition$getErr.call(newDefinition,newLayer,columnId,indexPattern))}catch(e){return false}}function applyReferenceTransition({layer:layer,columnId:columnId,previousColumn:previousColumn,op:op,indexPattern:indexPattern}){const operationDefinition=operationDefinitionMap[op];if(operationDefinition.input!=="fullReference"){throw new Error(`Requirements for transitioning are not met`)}let hasExactMatch=false;let hasFieldMatch=false;const unusedReferencesQueue="references"in previousColumn?[...previousColumn.references]:[];const referenceIds=operationDefinition.requiredReferences.map(validation=>{const newId=generateId();if(unusedReferencesQueue.length){const otherColumn=layer.columns[unusedReferencesQueue[0]];if(isColumnValidAsReference({validation:validation,column:otherColumn})){return unusedReferencesQueue.shift()}}if(!hasExactMatch&&isColumnValidAsReference({validation:validation,column:previousColumn})){hasExactMatch=true;const newLayer={...layer,columns:{...layer.columns,[newId]:{...previousColumn}}};layer={...layer,columnOrder:getColumnOrder(newLayer),columns:adjustColumnReferencesForChangedColumn(newLayer,newId)};return newId}if(validation.input.includes("none")){const validOperations=operationDefinitions.filter(def=>{if(def.input!=="none")return;return isOperationAllowedAsReference({validation:validation,operationType:def.type,indexPattern:indexPattern})});if(validOperations.length===1){layer=insertNewColumn({layer:layer,columnId:newId,op:validOperations[0].type,indexPattern:indexPattern});return newId}}if(!hasFieldMatch&&"sourceField"in previousColumn&&validation.input.includes("field")){const defIgnoringfield=operationDefinitions.filter(def=>def.input==="field"&&isOperationAllowedAsReference({validation:validation,operationType:def.type,indexPattern:indexPattern})).sort(getSortScoreByPriority);const defWithField=defIgnoringfield.filter(def=>{const previousField=indexPattern.getFieldByName(previousColumn.sourceField);if(!previousField)return;return isOperationAllowedAsReference({validation:validation,operationType:def.type,field:previousField,indexPattern:indexPattern})});if(defWithField.length>0){hasFieldMatch=true;layer=insertNewColumn({layer:layer,columnId:newId,op:defWithField[0].type,indexPattern:indexPattern,field:indexPattern.getFieldByName(previousColumn.sourceField)});return newId}else if(defIgnoringfield.length===1){hasFieldMatch=true;layer={...layer,incompleteColumns:{...layer.incompleteColumns,[newId]:{operationType:defIgnoringfield[0].type}}};return newId}}if(unusedReferencesQueue.length){const otherColumn=layer.columns[unusedReferencesQueue[0]];if(otherColumn&&"sourceField"in otherColumn&&validation.input.includes("field")){const previousField=indexPattern.getFieldByName(otherColumn.sourceField);if(previousField){const defWithField=operationDefinitions.filter(def=>def.input==="field"&&isOperationAllowedAsReference({validation:validation,operationType:def.type,field:previousField,indexPattern:indexPattern})).sort(getSortScoreByPriority);if(defWithField.length>0){layer=insertNewColumn({layer:layer,columnId:newId,op:defWithField[0].type,indexPattern:indexPattern,field:previousField});return newId}}}}return newId});if(unusedReferencesQueue.length){unusedReferencesQueue.forEach(id=>{layer=deleteColumn({layer:layer,columnId:id,indexPattern:indexPattern})})}layer={...layer,columns:{...layer.columns,[columnId]:operationDefinition.buildColumn({indexPattern:indexPattern,layer:layer,referenceIds:referenceIds,previousColumn:previousColumn})}};return updateDefaultLabels({...layer,columnOrder:getColumnOrder(layer),columns:adjustColumnReferencesForChangedColumn(layer,columnId)},indexPattern)}function copyCustomLabel(newColumn,previousColumn){const adjustedColumn={...newColumn};if(previousColumn.customLabel){adjustedColumn.customLabel=true;adjustedColumn.label=previousColumn.label}return adjustedColumn}function addBucket(layer,column,addedColumnId){const[buckets,metrics,references]=getExistingColumnGroups(layer);const oldDateHistogramIndex=layer.columnOrder.findIndex(columnId=>layer.columns[columnId].operationType==="date_histogram");let updatedColumnOrder=[];if(oldDateHistogramIndex>-1&&column.operationType==="terms"){updatedColumnOrder=[...buckets.slice(0,oldDateHistogramIndex),addedColumnId,...buckets.slice(oldDateHistogramIndex,buckets.length),...metrics,...references]}else{updatedColumnOrder=[...buckets,addedColumnId,...metrics,...references]}const tempLayer={...resetIncomplete(layer,addedColumnId),columns:{...layer.columns,[addedColumnId]:column},columnOrder:updatedColumnOrder};return{...tempLayer,columnOrder:getColumnOrder(tempLayer)}}function addMetric(layer,column,addedColumnId){const tempLayer={...resetIncomplete(layer,addedColumnId),columns:{...layer.columns,[addedColumnId]:column}};return{...tempLayer,columnOrder:getColumnOrder(tempLayer)}}function getMetricOperationTypes(field){return operationDefinitions.sort(getSortScoreByPriority).filter(definition=>{if(definition.input!=="field")return;const metadata=definition.getPossibleOperationForField(field);return metadata&&!metadata.isBucketed&&metadata.dataType==="number"})}function updateColumnParam({layer:layer,columnId:columnId,paramName:paramName,value:value}){return{...layer,columns:{...layer.columns,[columnId]:{...layer.columns[columnId],params:{...layer.columns[columnId].params,[paramName]:value}}}}}function adjustColumnReferencesForChangedColumn(layer,changedColumnId){const newColumns={...layer.columns};Object.keys(newColumns).forEach(currentColumnId=>{if(currentColumnId!==changedColumnId){const currentColumn=newColumns[currentColumnId];const operationDefinition=operationDefinitionMap[currentColumn.operationType];newColumns[currentColumnId]=operationDefinition.onOtherColumnChanged?operationDefinition.onOtherColumnChanged({...layer,columns:newColumns},currentColumnId,changedColumnId):currentColumn}});return newColumns}function deleteColumn({layer:layer,columnId:columnId,indexPattern:indexPattern}){const column=layer.columns[columnId];if(!column){const newIncomplete={...layer.incompleteColumns||{}};delete newIncomplete[columnId];return{...layer,columnOrder:layer.columnOrder.filter(id=>id!==columnId),incompleteColumns:newIncomplete}}const extraDeletions="references"in column?column.references:[];const hypotheticalColumns={...layer.columns};delete hypotheticalColumns[columnId];let newLayer={...layer,columns:adjustColumnReferencesForChangedColumn({...layer,columns:hypotheticalColumns},columnId)};extraDeletions.forEach(id=>{newLayer=deleteColumn({layer:newLayer,columnId:id,indexPattern:indexPattern})});const newIncomplete={...newLayer.incompleteColumns||{}};delete newIncomplete[columnId];return updateDefaultLabels({...newLayer,columnOrder:getColumnOrder(newLayer),incompleteColumns:newIncomplete},indexPattern)}function getColumnOrder(layer){const entries=Object.entries(layer.columns);entries.sort(([idA],[idB])=>{const indexA=layer.columnOrder.indexOf(idA);const indexB=layer.columnOrder.indexOf(idB);if(indexA>-1&&indexB>-1){return indexA-indexB}else if(indexA>-1){return-1}else{return 1}});const[direct,referenceBased]=external_kbnSharedDeps_Lodash_default.a.partition(entries,([,col])=>operationDefinitionMap[col.operationType].input!=="fullReference");referenceBased.sort(([idA,a],[idB,b])=>{if("references"in a&&a.references.includes(idB)){return 1}if("references"in b&&b.references.includes(idA)){return-1}return 0});const[aggregations,metrics]=external_kbnSharedDeps_Lodash_default.a.partition(direct,([,col])=>col.isBucketed);return aggregations.map(([id])=>id).concat(metrics.map(([id])=>id)).concat(referenceBased.map(([id])=>id))}function getExistingColumnGroups(layer){const[direct,referenced]=Object(external_kbnSharedDeps_Lodash_["partition"])(layer.columnOrder,columnId=>layer.columns[columnId]&&!("references"in layer.columns[columnId]));return[...Object(external_kbnSharedDeps_Lodash_["partition"])(direct,columnId=>{var _layer$columns$column;return(_layer$columns$column=layer.columns[columnId])===null||_layer$columns$column===void 0?void 0:_layer$columns$column.isBucketed}),referenced]}function isColumnTransferable(column,newIndexPattern){return operationDefinitionMap[column.operationType].isTransferable(column,newIndexPattern)}function updateLayerIndexPattern(layer,newIndexPattern){const keptColumns=external_kbnSharedDeps_Lodash_default.a.pickBy(layer.columns,column=>isColumnTransferable(column,newIndexPattern));const newColumns=external_kbnSharedDeps_Lodash_default.a.mapValues(keptColumns,column=>{const operationDefinition=operationDefinitionMap[column.operationType];return operationDefinition.transfer?operationDefinition.transfer(column,newIndexPattern):column});const newColumnOrder=layer.columnOrder.filter(columnId=>newColumns[columnId]);return{...layer,indexPatternId:newIndexPattern.id,columns:newColumns,columnOrder:newColumnOrder}}function getErrorMessages(layer,indexPattern){const errors=Object.entries(layer.columns).flatMap(([columnId,column])=>{const def=operationDefinitionMap[column.operationType];if(def.getErrorMessage){return def.getErrorMessage(layer,columnId,indexPattern)}}).filter(v=>v!=null);return errors.length?errors:undefined}function isReferenced(layer,columnId){const allReferences=Object.values(layer.columns).flatMap(col=>"references"in col?col.references:[]);return allReferences.includes(columnId)}function isOperationAllowedAsReference({operationType:operationType,validation:validation,field:field,indexPattern:indexPattern}){const operationDefinition=operationDefinitionMap[operationType];let hasValidMetadata=true;if(field&&operationDefinition.input==="field"){const metadata=operationDefinition.getPossibleOperationForField(field);hasValidMetadata=Boolean(metadata)&&validation.validateMetadata(metadata)}else if(operationDefinition.input==="none"){const metadata=operationDefinition.getPossibleOperation();hasValidMetadata=Boolean(metadata)&&validation.validateMetadata(metadata)}else if(operationDefinition.input==="fullReference"){const metadata=operationDefinition.getPossibleOperation(indexPattern);hasValidMetadata=Boolean(metadata)&&validation.validateMetadata(metadata)}else{}return validation.input.includes(operationDefinition.input)&&(!validation.specificOperations||validation.specificOperations.includes(operationType))&&hasValidMetadata}function updateDefaultLabels(layer,indexPattern){const copiedColumns={...layer.columns};layer.columnOrder.forEach(id=>{const col=copiedColumns[id];if(!col.customLabel){copiedColumns[id]={...col,label:operationDefinitionMap[col.operationType].getDefaultLabel(col,indexPattern,copiedColumns)}}});return{...layer,columns:copiedColumns}}function resetIncomplete(layer,columnId){var _layer$incompleteColu4;const incompleteColumns={...(_layer$incompleteColu4=layer.incompleteColumns)!==null&&_layer$incompleteColu4!==void 0?_layer$incompleteColu4:{}};delete incompleteColumns[columnId];return{...layer,incompleteColumns:incompleteColumns}}function isColumnValidAsReference({column:column,validation:validation}){if(!column)return false;const operationType=column.operationType;const operationDefinition=operationDefinitionMap[operationType];return validation.input.includes(operationDefinition.input)&&(!validation.specificOperations||validation.specificOperations.includes(operationType))&&validation.validateMetadata(column)}const useDebounceWithOptions=(fn,{skipFirstRender:skipFirstRender}={skipFirstRender:false},ms,deps)=>{const isFirstRender=Object(external_kbnSharedDeps_React_["useRef"])(true);const newDeps=[...deps||[],isFirstRender];return useDebounce_default()(()=>{if(skipFirstRender&&isFirstRender.current){isFirstRender.current=false;return}return fn()},ms,newDeps)};function getInvalidFieldMessage(column,indexPattern){if(!indexPattern){return}const{sourceField:sourceField,operationType:operationType}=column;const field=sourceField?indexPattern.getFieldByName(sourceField):undefined;const operationDefinition=operationType&&operationDefinitionMap[operationType];const isInvalid=Boolean(sourceField&&operationDefinition&&!(field&&(operationDefinition===null||operationDefinition===void 0?void 0:operationDefinition.input)==="field"&&operationDefinition.getPossibleOperationForField(field)!==undefined));return isInvalid?[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldNotFound",{defaultMessage:"Field {invalidField} was not found",values:{invalidField:sourceField}})]:undefined}function getEsAggsSuffix(column){const operationDefinition=operationDefinitionMap[column.operationType];return operationDefinition.input==="field"&&operationDefinition.getEsAggsSuffix?operationDefinition.getEsAggsSuffix(column):""}function getSafeName(name,indexPattern){const field=indexPattern.getFieldByName(name);return field?field.displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.missingFieldLabel",{defaultMessage:"Missing field"})}function isValidNumber(inputValue,integer,upperBound,lowerBound){const inputValueAsNumber=Number(inputValue);return inputValue!==""&&inputValue!==null&&inputValue!==undefined&&!Number.isNaN(inputValueAsNumber)&&Number.isFinite(inputValueAsNumber)&&(!integer||Number.isInteger(inputValueAsNumber))&&(upperBound===undefined||inputValueAsNumber<=upperBound)&&(lowerBound===undefined||inputValueAsNumber>=lowerBound)}const ValuesRangeInput=({value:value,onChange:onChange})=>{const MIN_NUMBER_OF_VALUES=1;const MAX_NUMBER_OF_VALUES=100;const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])(String(value));useDebounceWithOptions(()=>{if(inputValue===""){return}const inputNumber=Number(inputValue);onChange(Math.min(MAX_NUMBER_OF_VALUES,Math.max(inputNumber,MIN_NUMBER_OF_VALUES)))},{skipFirstRender:true},256,[inputValue]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{min:MIN_NUMBER_OF_VALUES,max:MAX_NUMBER_OF_VALUES,step:1,value:inputValue,showInput:true,showLabels:true,compressed:true,onChange:({currentTarget:currentTarget})=>setInputValue(currentTarget.value),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.size",{defaultMessage:"Number of values"})})};function terms_ofName(name){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.termsOf",{defaultMessage:"Top values of {name}",values:{name:name!==null&&name!==void 0?name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.missingFieldLabel",{defaultMessage:"Missing field"})}})}function isSortableByColumn(layer,columnId){const column=layer.columns[columnId];return column&&!column.isBucketed&&column.operationType!=="last_value"&&!("references"in column)&&!isReferenced(layer,columnId)}const DEFAULT_SIZE=3;const supportedTypes=new Set(["string","boolean","number","ip"]);const termsOperation={type:"terms",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms",{defaultMessage:"Top values"}),priority:3,input:"field",getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,aggregatable:aggregatable,type:type})=>{if(supportedTypes.has(type)&&aggregatable&&(!aggregationRestrictions||aggregationRestrictions.terms)){return{dataType:type,isBucketed:true,scale:"ordinal"}}},getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern),isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);return Boolean(newField&&supportedTypes.has(newField.type)&&newField.aggregatable&&(!newField.aggregationRestrictions||newField.aggregationRestrictions.terms)&&(!column.params.otherBucket||!newIndexPattern.hasRestrictions))},buildColumn({layer:layer,field:field,indexPattern:indexPattern}){const existingMetricColumn=Object.entries(layer.columns).filter(([columnId])=>isSortableByColumn(layer,columnId)).map(([id])=>id)[0];const previousBucketsLength=Object.values(layer.columns).filter(col=>col&&col.isBucketed).length;return{label:terms_ofName(field.displayName),dataType:field.type,operationType:"terms",scale:"ordinal",sourceField:field.name,isBucketed:true,params:{size:previousBucketsLength===0?5:DEFAULT_SIZE,orderBy:existingMetricColumn?{type:"column",columnId:existingMetricColumn}:{type:"alphabetical"},orderDirection:existingMetricColumn?"desc":"asc",otherBucket:!indexPattern.hasRestrictions,missingBucket:false}}},toEsAggsFn:(column,columnId,_indexPattern,layer)=>Object(expressions_public_["buildExpressionFunction"])("aggTerms",{id:columnId,enabled:true,schema:"segment",field:column.sourceField,orderBy:column.params.orderBy.type==="alphabetical"?"_key":`${column.params.orderBy.columnId}${getEsAggsSuffix(layer.columns[column.params.orderBy.columnId])}`,order:column.params.orderDirection,size:column.params.size,otherBucket:Boolean(column.params.otherBucket),otherBucketLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.otherLabel",{defaultMessage:"Other"}),missingBucket:column.params.otherBucket&&column.params.missingBucket,missingBucketLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.missingLabel",{defaultMessage:"(missing value)"})}).toAst(),getDefaultLabel:(column,indexPattern)=>{var _indexPattern$getFiel;return terms_ofName((_indexPattern$getFiel=indexPattern.getFieldByName(column.sourceField))===null||_indexPattern$getFiel===void 0?void 0:_indexPattern$getFiel.displayName)},onFieldChange:(oldColumn,field)=>{const newParams={...oldColumn.params};if("format"in newParams&&field.type!=="number"){delete newParams.format}return{...oldColumn,dataType:field.type,label:terms_ofName(field.displayName),sourceField:field.name,params:newParams}},onOtherColumnChanged:(layer,thisColumnId,changedColumnId)=>{const columns=layer.columns;const currentColumn=columns[thisColumnId];if(currentColumn.params.orderBy.type==="column"){const columnSortedBy=columns[currentColumn.params.orderBy.columnId];if(!columnSortedBy||!isSortableByColumn(layer,changedColumnId)){return{...currentColumn,params:{...currentColumn.params,orderBy:{type:"alphabetical"},orderDirection:"asc"}}}}return currentColumn},paramEditor:function ParamEditor({layer:layer,updateLayer:updateLayer,currentColumn:currentColumn,columnId:columnId,indexPattern:indexPattern}){const hasRestrictions=indexPattern.hasRestrictions;const[popoverOpen,setPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const SEPARATOR="$$$";function toValue(orderBy){if(orderBy.type==="alphabetical"){return orderBy.type}return`${orderBy.type}${SEPARATOR}${orderBy.columnId}`}function fromValue(value){if(value==="alphabetical"){return{type:"alphabetical"}}const parts=value.split(SEPARATOR);return{type:"column",columnId:parts[1]}}const orderOptions=Object.entries(layer.columns).filter(([sortId])=>isSortableByColumn(layer,sortId)).map(([sortId,column])=>({value:toValue({type:"column",columnId:sortId}),text:column.label}));orderOptions.push({value:toValue({type:"alphabetical"}),text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderAlphabetical",{defaultMessage:"Alphabetical"})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.size",{defaultMessage:"Number of values"}),display:"columnCompressed",fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(ValuesRangeInput,{value:currentColumn.params.size,onChange:value=>{updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"size",value:value}))}})),!hasRestrictions&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{textAlign:"right"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:true,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:"arrowDown",iconSide:"right",onClick:()=>{setPopoverOpen(!popoverOpen)}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.advancedSettings",{defaultMessage:"Advanced"})),isOpen:popoverOpen,closePopover:()=>{setPopoverOpen(false)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.otherBucketDescription",{defaultMessage:'Group other values as "Other"'}),compressed:true,"data-test-subj":"indexPattern-terms-other-bucket",checked:Boolean(currentColumn.params.otherBucket),onChange:e=>updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"otherBucket",value:e.target.checked}))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.missingBucketDescription",{defaultMessage:"Include documents without this field"}),compressed:true,disabled:!currentColumn.params.otherBucket,"data-test-subj":"indexPattern-terms-missing-bucket",checked:Boolean(currentColumn.params.missingBucket),onChange:e=>updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"missingBucket",value:e.target.checked}))})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderBy",{defaultMessage:"Rank by"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"subdued",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderByHelp",{defaultMessage:`Specifies the dimension the top values are ranked by.`}),iconProps:{className:"eui-alignTop"},position:"top",size:"s",type:"questionInCircle"})),display:"columnCompressed",fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,"data-test-subj":"indexPattern-terms-orderBy",options:orderOptions,value:toValue(currentColumn.params.orderBy),onChange:e=>updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"orderBy",value:fromValue(e.target.value)})),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderBy",{defaultMessage:"Rank by"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderDirection",{defaultMessage:"Rank direction"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{color:"subdued",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderDirectionHelp",{defaultMessage:`Specifies the ranking order of the top values.`}),iconProps:{className:"eui-alignTop"},position:"top",size:"s",type:"questionInCircle"})),display:"columnCompressed",fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,"data-test-subj":"indexPattern-terms-orderDirection",options:[{value:"asc",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderAscending",{defaultMessage:"Ascending"})},{value:"desc",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderDescending",{defaultMessage:"Descending"})}],value:currentColumn.params.orderDirection,onChange:e=>updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"orderDirection",value:e.target.value})),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.terms.orderBy",{defaultMessage:"Rank by"})})))}};var filters_filters=__webpack_require__(125);var filter_popover=__webpack_require__(134);const LabelInput=({value:value,onChange:onChange,placeholder:placeholder,inputRef:inputRef,onSubmit:onSubmit,dataTestSubj:dataTestSubj,compressed:compressed})=>{const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])(value);useDebounce_default()(()=>onChange(inputValue),256,[inputValue]);const handleInputChange=e=>{const val=String(e.target.value);setInputValue(val)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{"data-test-subj":dataTestSubj||"lens-labelInput",value:inputValue,onChange:handleInputChange,fullWidth:true,placeholder:placeholder||"",inputRef:node=>{if(inputRef&&node){inputRef.current=node}},onKeyUp:({key:key})=>{if(external_kbnSharedDeps_ElasticEui_["keys"].ENTER===key&&onSubmit){onSubmit()}},prepend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.labelInput.label",{defaultMessage:"Label"}),compressed:compressed})};const NewBucketButton=({label:label,onClick:onClick})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"lns-newBucket-add",size:"xs",iconType:"plusInCircle",onClick:onClick},label);const BucketContainer=({isInvalid:isInvalid,invalidMessage:invalidMessage,onRemoveClick:onRemoveClick,removeTitle:removeTitle,children:children,dataTestSubj:dataTestSubj,isNotRemovable:isNotRemovable})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"none","data-test-subj":dataTestSubj},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"s",color:isInvalid?"danger":"subdued",type:isInvalid?"alert":"grab",title:isInvalid?invalidMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.customBucketContainer.dragToReorder",{defaultMessage:"Drag to reorder"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},children),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconSize:"s",iconType:"cross",color:"danger","data-test-subj":"lns-customBucketContainer-remove",onClick:onRemoveClick,"aria-label":removeTitle,title:removeTitle,disabled:isNotRemovable}))));const DraggableBucketContainer=({id:id,idx:idx,children:children,...bucketContainerProps})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDraggable"],{style:{marginBottom:4},spacing:"none",index:idx,draggableId:id,disableInteractiveElementBlocking:true},provided=>external_kbnSharedDeps_React_default.a.createElement(BucketContainer,bucketContainerProps,children));const DragDropBuckets=({items:items,onDragStart:onDragStart,onDragEnd:onDragEnd,droppableId:droppableId,children:children})=>{const handleDragEnd=({source:source,destination:destination})=>{if(source&&destination){const newItems=Object(external_kbnSharedDeps_ElasticEui_["euiDragDropReorder"])(items,source.index,destination.index);onDragEnd(newItems)}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDragDropContext"],{onDragEnd:handleDragEnd,onDragStart:onDragStart},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDroppable"],{droppableId:droppableId,spacing:"none"},children))};const FilterPopover=({filter:filter,setFilter:setFilter,indexPattern:indexPattern,Button:Button,initiallyOpen:initiallyOpen})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const inputRef=external_kbnSharedDeps_React_default.a.useRef();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setIsPopoverOpen(initiallyOpen)},[]);const closePopover=()=>{if(isPopoverOpen){setIsPopoverOpen(false)}};const setFilterLabel=label=>setFilter({...filter,label:label});const setFilterQuery=input=>setFilter({...filter,input:input});const getPlaceholder=query=>{if(query===""){return defaultLabel}if(query==="object")return JSON.stringify(query);else{return String(query)}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{"data-test-subj":"indexPattern-filters-existingFilterContainer",anchorClassName:"eui-fullWidth",panelClassName:"lnsIndexPatternDimensionEditor__filtersEditor",isOpen:isPopoverOpen,ownFocus:true,closePopover:()=>closePopover(),button:external_kbnSharedDeps_React_default.a.createElement(Button,{onClick:()=>{setIsPopoverOpen(open=>!open)}})},external_kbnSharedDeps_React_default.a.createElement(QueryInput,{isInvalid:!isQueryValid(filter.input,indexPattern),value:filter.input,indexPattern:indexPattern,onChange:setFilterQuery,onSubmit:()=>{if(inputRef.current)inputRef.current.focus()}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(LabelInput,{value:filter.label||"",onChange:setFilterLabel,placeholder:getPlaceholder(filter.input.query),inputRef:inputRef,onSubmit:()=>closePopover(),dataTestSubj:"indexPattern-filters-label"}))};const QueryInput=({value:value,onChange:onChange,indexPattern:indexPattern,isInvalid:isInvalid,onSubmit:onSubmit})=>{const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])(value);useDebounce_default()(()=>onChange(inputValue),256,[inputValue]);const handleInputChange=input=>{setInputValue(input)};return external_kbnSharedDeps_React_default.a.createElement(data_public_["QueryStringInput"],{dataTestSubj:"indexPattern-filters-queryStringInput",size:"s",isInvalid:isInvalid,bubbleSubmitEvent:false,indexPatterns:[indexPattern],query:inputValue,onChange:handleInputChange,onSubmit:()=>{if(inputValue.query){onSubmit()}},placeholder:inputValue.language==="kuery"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.queryPlaceholderKql",{defaultMessage:"{example}",values:{example:'method : "GET" or status : "404"'}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.queryPlaceholderLucene",{defaultMessage:"{example}",values:{example:"method:GET OR status:404"}}),languageSwitcherPopoverAnchorPosition:"rightDown"})};const filters_generateId=Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])();const filtersLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters",{defaultMessage:"Filters"});const defaultLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.label.placeholder",{defaultMessage:"All records"});const defaultFilter={input:{query:"",language:"kuery"},label:""};const isQueryValid=(input,indexPattern)=>{try{if(input.language==="kuery"){data_public_["esKuery"].toElasticsearchQuery(data_public_["esKuery"].fromKueryExpression(input.query),indexPattern)}else{data_public_["esQuery"].luceneStringToDsl(input.query)}return true}catch(e){return false}};const filtersOperation={type:"filters",displayName:filtersLabel,priority:3,input:"none",isTransferable:()=>true,getDefaultLabel:()=>filtersLabel,buildColumn({previousColumn:previousColumn}){let params={filters:[defaultFilter]};if((previousColumn===null||previousColumn===void 0?void 0:previousColumn.operationType)==="terms"){params={filters:[{label:"",input:{query:`${previousColumn.sourceField} : *`,language:"kuery"}}]}}return{label:filtersLabel,dataType:"string",operationType:"filters",scale:"ordinal",isBucketed:true,params:params}},getPossibleOperation(){return{dataType:"string",isBucketed:true,scale:"ordinal"}},toEsAggsFn:(column,columnId,indexPattern)=>{var _column$params$filter;const validFilters=(_column$params$filter=column.params.filters)===null||_column$params$filter===void 0?void 0:_column$params$filter.filter(f=>isQueryValid(f.input,indexPattern));return Object(expressions_public_["buildExpressionFunction"])("aggFilters",{id:columnId,enabled:true,schema:"segment",filters:JSON.stringify((validFilters===null||validFilters===void 0?void 0:validFilters.length)>0?validFilters:[defaultFilter])}).toAst()},paramEditor:({layer:layer,columnId:columnId,currentColumn:currentColumn,indexPattern:indexPattern,updateLayer:updateLayer,data:data})=>{const filters=currentColumn.params.filters;const setFilters=newFilters=>updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"filters",value:newFilters}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(FilterList,{filters:filters,setFilters:setFilters,indexPattern:indexPattern,defaultQuery:defaultFilter}))}};const FilterList=({filters:filters,setFilters:setFilters,indexPattern:indexPattern,defaultQuery:defaultQuery})=>{const[isOpenByCreation,setIsOpenByCreation]=Object(external_kbnSharedDeps_React_["useState"])(false);const[localFilters,setLocalFilters]=Object(external_kbnSharedDeps_React_["useState"])(()=>filters.map(filter=>({...filter,id:filters_generateId()})));const updateFilters=updatedFilters=>{setFilters(updatedFilters.map(filter=>Object(external_kbnSharedDeps_Lodash_["omit"])(filter,"id")));setLocalFilters(updatedFilters)};const onAddFilter=()=>updateFilters([...localFilters,{...defaultQuery,id:filters_generateId()}]);const onRemoveFilter=id=>updateFilters(localFilters.filter(filter=>filter.id!==id));const onChangeValue=(id,query,label)=>updateFilters(localFilters.map(filter=>filter.id===id?{...filter,input:query,label:label}:filter));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(DragDropBuckets,{onDragEnd:updateFilters,onDragStart:()=>{},droppableId:"FILTERS_DROPPABLE_AREA",items:localFilters},localFilters===null||localFilters===void 0?void 0:localFilters.map((filter,idx)=>{const isInvalid=!isQueryValid(filter.input,indexPattern);return external_kbnSharedDeps_React_default.a.createElement(DraggableBucketContainer,{id:filter.id,key:filter.id,idx:idx,isInvalid:isInvalid,invalidMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.isInvalid",{defaultMessage:"This query is invalid"}),onRemoveClick:()=>onRemoveFilter(filter.id),removeTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.removeFilter",{defaultMessage:"Remove a filter"}),isNotRemovable:localFilters.length===1},external_kbnSharedDeps_React_default.a.createElement(FilterPopover,{"data-test-subj":"indexPattern-filters-existingFilterContainer",initiallyOpen:idx===localFilters.length-1&&isOpenByCreation,indexPattern:indexPattern,filter:filter,setFilter:f=>{onChangeValue(f.id,f.input,f.label)},Button:({onClick:onClick})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{className:"lnsFiltersOperation__popoverButton","data-test-subj":"indexPattern-filters-existingFilterTrigger",onClick:onClick,color:isInvalid?"danger":"text",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.clickToEdit",{defaultMessage:"Click to edit"})},filter.label||filter.input.query||defaultLabel)}))})),external_kbnSharedDeps_React_default.a.createElement(NewBucketButton,{onClick:()=>{onAddFilter();setIsOpenByCreation(true)},label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.filters.addaFilter",{defaultMessage:"Add a filter"})}))};const cardinality_supportedTypes=new Set(["string","boolean","number","ip","date"]);const SCALE="ratio";const OPERATION_TYPE="cardinality";const IS_BUCKETED=false;function cardinality_ofName(name){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.cardinalityOf",{defaultMessage:"Unique count of {name}",values:{name:name}})}const cardinalityOperation={type:OPERATION_TYPE,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.cardinality",{defaultMessage:"Unique count"}),input:"field",getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,aggregatable:aggregatable,type:type})=>{if(cardinality_supportedTypes.has(type)&&aggregatable&&(!aggregationRestrictions||aggregationRestrictions.cardinality)){return{dataType:"number",isBucketed:IS_BUCKETED,scale:SCALE}}},getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern),isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);return Boolean(newField&&cardinality_supportedTypes.has(newField.type)&&newField.aggregatable&&(!newField.aggregationRestrictions||newField.aggregationRestrictions.cardinality))},getDefaultLabel:(column,indexPattern)=>cardinality_ofName(getSafeName(column.sourceField,indexPattern)),buildColumn({field:field,previousColumn:previousColumn}){return{label:cardinality_ofName(field.displayName),dataType:"number",operationType:OPERATION_TYPE,scale:SCALE,sourceField:field.name,isBucketed:IS_BUCKETED,params:(previousColumn===null||previousColumn===void 0?void 0:previousColumn.dataType)==="number"&&previousColumn.params&&"format"in previousColumn.params&&previousColumn.params.format?{format:previousColumn.params.format}:undefined}},toEsAggsFn:(column,columnId)=>Object(expressions_public_["buildExpressionFunction"])("aggCardinality",{id:columnId,enabled:true,schema:"metric",field:column.sourceField}).toAst(),onFieldChange:(oldColumn,field)=>({...oldColumn,label:cardinality_ofName(field.displayName),sourceField:field.name})};function percentile_ofName(name,percentile){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.percentileOf",{defaultMessage:"{percentile, selectordinal, one {#st} two {#nd} few {#rd} other {#th}} percentile of {name}",values:{name:name,percentile:percentile}})}const DEFAULT_PERCENTILE_VALUE=95;const supportedFieldTypes=["number","histogram"];const percentileOperation={type:"percentile",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.percentile",{defaultMessage:"Percentile"}),input:"field",getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,aggregatable:aggregatable,type:fieldType})=>{if(supportedFieldTypes.includes(fieldType)&&aggregatable&&!aggregationRestrictions){return{dataType:"number",isBucketed:false,scale:"ratio"}}},isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);return Boolean(newField&&supportedFieldTypes.includes(newField.type)&&newField.aggregatable&&!newField.aggregationRestrictions)},getDefaultLabel:(column,indexPattern,columns)=>percentile_ofName(getSafeName(column.sourceField,indexPattern),column.params.percentile),buildColumn:({field:field,previousColumn:previousColumn,indexPattern:indexPattern})=>{var _previousColumn$param;const existingFormat=previousColumn!==null&&previousColumn!==void 0&&previousColumn.params&&"format"in(previousColumn===null||previousColumn===void 0?void 0:previousColumn.params)?previousColumn===null||previousColumn===void 0?void 0:(_previousColumn$param=previousColumn.params)===null||_previousColumn$param===void 0?void 0:_previousColumn$param.format:undefined;const existingPercentileParam=(previousColumn===null||previousColumn===void 0?void 0:previousColumn.operationType)==="percentile"&&(previousColumn===null||previousColumn===void 0?void 0:previousColumn.params.percentile);const newPercentileParam=existingPercentileParam||DEFAULT_PERCENTILE_VALUE;return{label:percentile_ofName(getSafeName(field.name,indexPattern),newPercentileParam),dataType:"number",operationType:"percentile",sourceField:field.name,isBucketed:false,scale:"ratio",params:{format:existingFormat,percentile:newPercentileParam}}},onFieldChange:(oldColumn,field)=>({...oldColumn,label:percentile_ofName(field.displayName,oldColumn.params.percentile),sourceField:field.name}),toEsAggsFn:(column,columnId,_indexPattern)=>Object(expressions_public_["buildExpressionFunction"])("aggPercentiles",{id:columnId,enabled:true,schema:"metric",field:column.sourceField,percents:[column.params.percentile]}).toAst(),getEsAggsSuffix:column=>{const value=column.params.percentile;return`.${value}`},getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern),paramEditor:function PercentileParamEditor({layer:layer,updateLayer:updateLayer,currentColumn:currentColumn,columnId:columnId,indexPattern:indexPattern}){const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])(String(currentColumn.params.percentile));const inputValueAsNumber=Number(inputValue);const inputValueIsValid=isValidNumber(inputValue,true,99,1);useDebounceWithOptions(()=>{var _indexPattern$getFiel;if(!inputValueIsValid)return;updateLayer({...layer,columns:{...layer.columns,[columnId]:{...currentColumn,label:currentColumn.customLabel?currentColumn.label:percentile_ofName(((_indexPattern$getFiel=indexPattern.getFieldByName(currentColumn.sourceField))===null||_indexPattern$getFiel===void 0?void 0:_indexPattern$getFiel.displayName)||currentColumn.sourceField,inputValueAsNumber),params:{...currentColumn.params,percentile:inputValueAsNumber}}}})},{skipFirstRender:true},256,[inputValue]);const handleInputChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const val=String(e.target.value);setInputValue(val)},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.percentile.percentileValue",{defaultMessage:"Percentile"}),"data-test-subj":"lns-indexPattern-percentile-form",display:"columnCompressed",fullWidth:true,isInvalid:!inputValueIsValid,error:!inputValueIsValid&&external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.percentile.errorMessage",{defaultMessage:"Percentile has to be an integer between 1 and 99"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{"data-test-subj":"lns-indexPattern-percentile-input",compressed:true,value:inputValue,min:1,max:99,step:1,onChange:handleInputChange}))}};function suffix_formatter_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const unitSuffixes={s:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.suffix.s",{defaultMessage:"/s"}),m:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.suffix.m",{defaultMessage:"/m"}),h:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.suffix.h",{defaultMessage:"/h"}),d:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.suffix.d",{defaultMessage:"/d"})};const unitSuffixesLong={s:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.longSuffix.s",{defaultMessage:"per second"}),m:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.longSuffix.m",{defaultMessage:"per minute"}),h:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.longSuffix.h",{defaultMessage:"per hour"}),d:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.longSuffix.d",{defaultMessage:"per day"})};function getSuffixFormatter(formatFactory){var _class,_temp;return _temp=_class=class SuffixFormatter extends data_public_["FieldFormat"]{constructor(...args){super(...args);suffix_formatter_defineProperty(this,"allowsNumericalAggregations",true);suffix_formatter_defineProperty(this,"textConvert",val=>{const unit=this.param("unit");const suffix=unit?unitSuffixes[unit]:undefined;const nestedFormatter=this.param("id");const nestedParams=this.param("params");const formattedValue=formatFactory({id:nestedFormatter,params:nestedParams}).convert(val);if(formattedValue===""){return""}if(suffix){return`${formattedValue}${suffix}`}return formattedValue})}getParamDefaults(){return{unit:undefined,nestedParams:{}}}},suffix_formatter_defineProperty(_class,"id","suffix"),suffix_formatter_defineProperty(_class,"title",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.fieldFormats.suffix.title",{defaultMessage:"Suffix"})),suffix_formatter_defineProperty(_class,"fieldType",data_public_["KBN_FIELD_TYPES"].NUMBER),_temp}const DEFAULT_TIME_SCALE="s";function adjustTimeScaleLabelSuffix(oldLabel,previousTimeScale,newTimeScale){let cleanedLabel=oldLabel;if(previousTimeScale){const suffixPosition=oldLabel.lastIndexOf(` ${unitSuffixesLong[previousTimeScale]}`);if(suffixPosition!==-1){cleanedLabel=oldLabel.substring(0,suffixPosition)}}if(!newTimeScale){return cleanedLabel}return`${cleanedLabel} ${unitSuffixesLong[newTimeScale]}`}function adjustTimeScaleOnOtherColumnChange(layer,thisColumnId,changedColumnId){const columns=layer.columns;const column=columns[thisColumnId];if(!column.timeScale){return column}const hasDateHistogram=Object.values(columns).some(col=>(col===null||col===void 0?void 0:col.operationType)==="date_histogram");if(hasDateHistogram){return column}if(column.customLabel){return column}return{...column,timeScale:undefined,label:adjustTimeScaleLabelSuffix(column.label,column.timeScale,undefined)}}const typeToFn={min:"aggMin",max:"aggMax",avg:"aggAvg",sum:"aggSum",median:"aggMedian"};const metrics_supportedTypes=["number","histogram"];function buildMetricOperation({type:type,displayName:displayName,ofName:ofName,priority:priority,optionalTimeScaling:optionalTimeScaling}){const labelLookup=(name,column)=>{const label=ofName(name);if(!optionalTimeScaling){return label}return adjustTimeScaleLabelSuffix(label,undefined,column===null||column===void 0?void 0:column.timeScale)};return{type:type,priority:priority,displayName:displayName,input:"field",timeScalingMode:optionalTimeScaling?"optional":undefined,getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,aggregatable:aggregatable,type:fieldType})=>{if(metrics_supportedTypes.includes(fieldType)&&aggregatable&&(!aggregationRestrictions||aggregationRestrictions[type])){return{dataType:"number",isBucketed:false,scale:"ratio"}}},isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);return Boolean(newField&&metrics_supportedTypes.includes(newField.type)&&newField.aggregatable&&(!newField.aggregationRestrictions||newField.aggregationRestrictions[type]))},onOtherColumnChanged:(layer,thisColumnId,changedColumnId)=>optionalTimeScaling?adjustTimeScaleOnOtherColumnChange(layer,thisColumnId,changedColumnId):layer.columns[thisColumnId],getDefaultLabel:(column,indexPattern,columns)=>labelLookup(getSafeName(column.sourceField,indexPattern),column),buildColumn:({field:field,previousColumn:previousColumn})=>({label:labelLookup(field.displayName,previousColumn),dataType:"number",operationType:type,sourceField:field.name,isBucketed:false,scale:"ratio",timeScale:optionalTimeScaling?previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale:undefined,params:previousColumn&&previousColumn.dataType==="number"?previousColumn.params:undefined}),onFieldChange:(oldColumn,field)=>({...oldColumn,label:labelLookup(field.displayName,oldColumn),sourceField:field.name}),toEsAggsFn:(column,columnId,_indexPattern)=>Object(expressions_public_["buildExpressionFunction"])(typeToFn[type],{id:columnId,enabled:true,schema:"metric",field:column.sourceField}).toAst(),getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern)}}const minOperation=buildMetricOperation({type:"min",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.min",{defaultMessage:"Minimum"}),ofName:name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.minOf",{defaultMessage:"Minimum of {name}",values:{name:name}})});const maxOperation=buildMetricOperation({type:"max",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.max",{defaultMessage:"Maximum"}),ofName:name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.maxOf",{defaultMessage:"Maximum of {name}",values:{name:name}})});const averageOperation=buildMetricOperation({type:"avg",priority:2,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.avg",{defaultMessage:"Average"}),ofName:name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.avgOf",{defaultMessage:"Average of {name}",values:{name:name}})});const sumOperation=buildMetricOperation({type:"sum",priority:1,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.sum",{defaultMessage:"Sum"}),ofName:name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.sumOf",{defaultMessage:"Sum of {name}",values:{name:name}}),optionalTimeScaling:true});const medianOperation=buildMetricOperation({type:"median",priority:3,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.median",{defaultMessage:"Median"}),ofName:name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.medianOf",{defaultMessage:"Median of {name}",values:{name:name}})});var help_popover=__webpack_require__(143);const HelpPopoverButton=({children:children,onClick:onClick})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:onClick},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{className:"lnsHelpPopover__buttonIcon",size:"s",type:"help"}),children));const HelpPopover=({anchorPosition:anchorPosition,button:button,children:children,closePopover:closePopover,isOpen:isOpen,title:title})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{anchorPosition:anchorPosition,button:button,className:"lnsHelpPopover",closePopover:closePopover,isOpen:isOpen,ownFocus:true,panelClassName:"lnsHelpPopover__panel",panelPaddingSize:"none"},title&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,title),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:"lnsHelpPopover__content",size:"s"},children));const{isValidInterval:isValidInterval}=data_public_["search"].aggs;const autoInterval="auto";const calendarOnlyIntervals=new Set(["w","M","q","y"]);const dateHistogramOperation={type:"date_histogram",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram",{defaultMessage:"Date histogram"}),input:"field",priority:5,getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern),getHelpMessage:props=>external_kbnSharedDeps_React_default.a.createElement(AutoDateHistogramPopover,props),getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,aggregatable:aggregatable,type:type})=>{if(type==="date"&&aggregatable&&(!aggregationRestrictions||aggregationRestrictions.date_histogram)){return{dataType:"date",isBucketed:true,scale:"interval"}}},getDefaultLabel:(column,indexPattern)=>getSafeName(column.sourceField,indexPattern),buildColumn({field:field}){let interval=autoInterval;let timeZone;if(field.aggregationRestrictions&&field.aggregationRestrictions.date_histogram){interval=restrictedInterval(field.aggregationRestrictions);timeZone=field.aggregationRestrictions.date_histogram.time_zone}return{label:field.displayName,dataType:"date",operationType:"date_histogram",sourceField:field.name,isBucketed:true,scale:"interval",params:{interval:interval,timeZone:timeZone}}},isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);return Boolean(newField&&newField.type==="date"&&newField.aggregatable&&(!newField.aggregationRestrictions||newField.aggregationRestrictions.date_histogram))},transfer:(column,newIndexPattern)=>{var _newField$aggregation;const newField=newIndexPattern.getFieldByName(column.sourceField);if(newField!==null&&newField!==void 0&&(_newField$aggregation=newField.aggregationRestrictions)!==null&&_newField$aggregation!==void 0&&_newField$aggregation.date_histogram){const restrictions=newField.aggregationRestrictions.date_histogram;return{...column,params:{...column.params,timeZone:restrictions.time_zone,interval:restrictedInterval(newField.aggregationRestrictions)}}}return column},onFieldChange:(oldColumn,field)=>({...oldColumn,label:field.displayName,sourceField:field.name}),toEsAggsFn:(column,columnId,indexPattern)=>{var _usedField$aggregatio;const usedField=indexPattern.getFieldByName(column.sourceField);return Object(expressions_public_["buildExpressionFunction"])("aggDateHistogram",{id:columnId,enabled:true,schema:"segment",field:column.sourceField,time_zone:column.params.timeZone,useNormalizedEsInterval:!(usedField!==null&&usedField!==void 0&&(_usedField$aggregatio=usedField.aggregationRestrictions)!==null&&_usedField$aggregatio!==void 0&&_usedField$aggregatio.date_histogram),interval:column.params.interval,drop_partials:false,min_doc_count:0,extended_bounds:JSON.stringify({})}).toAst()},paramEditor:({layer:layer,columnId:columnId,currentColumn:currentColumn,updateLayer:updateLayer,dateRange:dateRange,data:data,indexPattern:indexPattern})=>{const field=currentColumn&&indexPattern.getFieldByName(currentColumn.sourceField);const intervalIsRestricted=field.aggregationRestrictions&&field.aggregationRestrictions.date_histogram;const interval=parseInterval(currentColumn.params.interval);const isValid=isValidInterval(`${interval.value===""?"1":interval.value}${interval.unit}`,restrictedInterval(field.aggregationRestrictions));function onChangeAutoInterval(ev){const{fromDate:fromDate,toDate:toDate}=dateRange;const value=ev.target.checked?data.search.aggs.calculateAutoTimeExpression({from:fromDate,to:toDate})||"1h":autoInterval;updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"interval",value:value}))}const setInterval=newInterval=>{const isCalendarInterval=calendarOnlyIntervals.has(newInterval.unit);const value=`${isCalendarInterval?"1":newInterval.value}${newInterval.unit||"d"}`;updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"interval",value:value}))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!intervalIsRestricted&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed",hasChildLabel:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.autoInterval",{defaultMessage:"Customize time interval"}),checked:currentColumn.params.interval!==autoInterval,onChange:onChangeAutoInterval,compressed:true})),currentColumn.params.interval!==autoInterval&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.minimumInterval",{defaultMessage:"Minimum interval"}),fullWidth:true,display:"rowCompressed"},intervalIsRestricted?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.dateHistogram.restrictedInterval",defaultMessage:"Interval fixed to {intervalValue} due to aggregation restrictions.",values:{intervalValue:currentColumn.params.interval}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{compressed:true,"data-test-subj":"lensDateHistogramValue",value:typeof interval.value==="number"||interval.value===""?interval.value:parseInt(interval.value,10),disabled:calendarOnlyIntervals.has(interval.unit),isInvalid:!isValid,onChange:e=>{setInterval({...interval,value:e.target.value})}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,"data-test-subj":"lensDateHistogramUnit",value:interval.unit,onChange:e=>{setInterval({...interval,unit:e.target.value})},isInvalid:!isValid,options:[{value:"ms",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.milliseconds",{defaultMessage:"milliseconds"})},{value:"s",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.seconds",{defaultMessage:"seconds"})},{value:"m",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.minutes",{defaultMessage:"minutes"})},{value:"h",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.hours",{defaultMessage:"hours"})},{value:"d",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.days",{defaultMessage:"days"})},{value:"w",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.week",{defaultMessage:"week"})},{value:"M",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.month",{defaultMessage:"month"})},{value:"y",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.year",{defaultMessage:"year"})}]}))),!isValid&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"danger","data-test-subj":"lensDateHistogramError"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.invalidInterval",{defaultMessage:"Invalid interval value"}))))))}};function parseInterval(currentInterval){const interval=currentInterval||"";const valueMatch=interval.match(/[\d]+/)||[];const unitMatch=interval.match(/[\D]+/)||[];const result=parseInt(valueMatch[0]||"",10);return{value:isNaN(result)?"":result,unit:unitMatch[0]||"h"}}function restrictedInterval(aggregationRestrictions){if(!aggregationRestrictions||!aggregationRestrictions.date_histogram){return}return aggregationRestrictions.date_histogram.calendar_interval||aggregationRestrictions.date_histogram.fixed_interval}const AutoDateHistogramPopover=({data:data})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const infiniteBound=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.moreThanYear",{defaultMessage:"More than a year"});const upToLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.upTo",{defaultMessage:"Up to"});return external_kbnSharedDeps_React_default.a.createElement(HelpPopover,{anchorPosition:"upCenter",button:external_kbnSharedDeps_React_default.a.createElement(HelpPopoverButton,{onClick:()=>setIsPopoverOpen(!isPopoverOpen)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.autoHelpText",{defaultMessage:"How it works"})),closePopover:()=>setIsPopoverOpen(false),isOpen:isPopoverOpen,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.titleHelp",{defaultMessage:"How auto date histogram works"})},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.autoBasicExplanation",{defaultMessage:"The auto date histogram splits a data field into buckets by interval."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.dateHistogram.autoLongerExplanation",defaultMessage:"To choose the interval, Lens divides the specified time range by the {targetBarSetting} setting. Lens calculates the best interval for your data. For example 30m, 1h, and 12. The maximum number of bars is set by the {maxBarSetting} value.",values:{maxBarSetting:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,data_public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS),targetBarSetting:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,data_public_["UI_SETTINGS"].HISTOGRAM_BAR_TARGET)}})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.autoAdvancedExplanation",{defaultMessage:"The interval follows this logic:"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:data_public_["search"].aggs.boundsDescendingRaw.map(({bound:bound,boundLabel:boundLabel,intervalLabel:intervalLabel})=>({bound:typeof bound==="number"?infiniteBound:`${upToLabel} ${boundLabel}`,interval:intervalLabel})),columns:[{field:"bound",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.autoBoundHeader",{defaultMessage:"Target interval measured"})},{field:"interval",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.dateHistogram.autoIntervalHeader",{defaultMessage:"Interval used"})}]}))};const buildLabelFunction=ofName=>(name,timeScale)=>{const rawLabel=ofName(name);return adjustTimeScaleLabelSuffix(rawLabel,undefined,timeScale)};function checkForDateHistogram(layer,name){const buckets=layer.columnOrder.filter(colId=>layer.columns[colId].isBucketed);const hasDateHistogram=buckets.some(colId=>layer.columns[colId].operationType==="date_histogram");if(hasDateHistogram){return undefined}return[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.calculations.dateHistogramErrorMessage",{defaultMessage:"{name} requires a date histogram to work. Add a date histogram or select a different function.",values:{name:name}})]}function checkReferences(layer,columnId){const column=layer.columns[columnId];const errors=[];column.references.forEach((referenceId,index)=>{if(!layer.columns[referenceId]){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.missingReferenceError",{defaultMessage:'"{dimensionLabel}" is not fully configured',values:{dimensionLabel:column.label}}))}else{const referenceColumn=layer.columns[referenceId];const definition=operationDefinitionMap[column.operationType];if(definition.input!=="fullReference"){throw new Error("inconsistent state - column is not a reference operation")}const requirements=definition.requiredReferences[index];const isValid=isColumnValidAsReference({validation:requirements,column:referenceColumn});if(!isValid){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.invalidReferenceConfiguration",{defaultMessage:'Dimension "{dimensionLabel}" is configured incorrectly',values:{dimensionLabel:column.label}}))}}});return errors.length?errors:undefined}function getErrorsForDateReference(layer,columnId,name){var _checkForDateHistogra,_checkReferences;const dateErrors=(_checkForDateHistogra=checkForDateHistogram(layer,name))!==null&&_checkForDateHistogra!==void 0?_checkForDateHistogra:[];const referenceErrors=(_checkReferences=checkReferences(layer,columnId))!==null&&_checkReferences!==void 0?_checkReferences:[];if(dateErrors.length||referenceErrors.length){return[...dateErrors,...referenceErrors]}return}function hasDateField(indexPattern){return indexPattern.fields.some(field=>field.type==="date")}function dateBasedOperationToExpression(layer,columnId,functionName,additionalArgs={}){const currentColumn=layer.columns[columnId];const buckets=layer.columnOrder.filter(colId=>layer.columns[colId].isBucketed);const dateColumnIndex=buckets.findIndex(colId=>layer.columns[colId].operationType==="date_histogram");buckets.splice(dateColumnIndex,1);return[{type:"function",function:functionName,arguments:{by:buckets,inputColumnId:[currentColumn.references[0]],outputColumnId:[columnId],outputColumnName:[currentColumn.label],...additionalArgs}}]}const counter_rate_ofName=buildLabelFunction(name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.CounterRateOf",{defaultMessage:"Counter rate of {name}",values:{name:name!==null&&name!==void 0?name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.incompleteOperation",{defaultMessage:"(incomplete)"})}}));const counterRateOperation={type:"counter_rate",priority:1,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.counterRate",{defaultMessage:"Counter rate"}),input:"fullReference",selectionStyle:"field",requiredReferences:[{input:["field"],specificOperations:["max"],validateMetadata:meta=>meta.dataType==="number"&&!meta.isBucketed}],getPossibleOperation:indexPattern=>{if(hasDateField(indexPattern)){return{dataType:"number",isBucketed:false,scale:"ratio"}}},getDefaultLabel:(column,indexPattern,columns)=>{const ref=columns[column.references[0]];return counter_rate_ofName(ref&&"sourceField"in ref?ref.sourceField:undefined,column.timeScale)},toExpression:(layer,columnId)=>dateBasedOperationToExpression(layer,columnId,"lens_counter_rate"),buildColumn:({referenceIds:referenceIds,previousColumn:previousColumn,layer:layer})=>{const metric=layer.columns[referenceIds[0]];const timeScale=(previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale)||DEFAULT_TIME_SCALE;return{label:counter_rate_ofName(metric&&"sourceField"in metric?metric.sourceField:undefined,timeScale),dataType:"number",operationType:"counter_rate",isBucketed:false,scale:"ratio",references:referenceIds,timeScale:timeScale,params:(previousColumn===null||previousColumn===void 0?void 0:previousColumn.dataType)==="number"&&previousColumn.params&&"format"in previousColumn.params&&previousColumn.params.format?{format:previousColumn.params.format}:undefined}},isTransferable:(column,newIndexPattern)=>hasDateField(newIndexPattern),getErrorMessage:(layer,columnId)=>getErrorsForDateReference(layer,columnId,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.counterRate",{defaultMessage:"Counter rate"})),getDisabledStatus(indexPattern,layer){var _checkForDateHistogra;return(_checkForDateHistogra=checkForDateHistogram(layer,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.counterRate",{defaultMessage:"Counter rate"})))===null||_checkForDateHistogra===void 0?void 0:_checkForDateHistogra.join(", ")},timeScalingMode:"mandatory"};const cumulative_sum_ofName=name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.cumulativeSumOf",{defaultMessage:"Cumulative sum of {name}",values:{name:name!==null&&name!==void 0?name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.incompleteOperation",{defaultMessage:"(incomplete)"})}});const cumulativeSumOperation={type:"cumulative_sum",priority:1,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.cumulativeSum",{defaultMessage:"Cumulative sum"}),input:"fullReference",selectionStyle:"field",requiredReferences:[{input:["field"],specificOperations:["count","sum"],validateMetadata:meta=>meta.dataType==="number"&&!meta.isBucketed}],getPossibleOperation:indexPattern=>{if(hasDateField(indexPattern)){return{dataType:"number",isBucketed:false,scale:"ratio"}}},getDefaultLabel:(column,indexPattern,columns)=>{const ref=columns[column.references[0]];return cumulative_sum_ofName(ref&&"sourceField"in ref?ref.sourceField:undefined)},toExpression:(layer,columnId)=>dateBasedOperationToExpression(layer,columnId,"cumulative_sum"),buildColumn:({referenceIds:referenceIds,previousColumn:previousColumn,layer:layer})=>{const ref=layer.columns[referenceIds[0]];return{label:cumulative_sum_ofName(ref&&"sourceField"in ref?ref.sourceField:undefined),dataType:"number",operationType:"cumulative_sum",isBucketed:false,scale:"ratio",references:referenceIds,params:(previousColumn===null||previousColumn===void 0?void 0:previousColumn.dataType)==="number"&&previousColumn.params&&"format"in previousColumn.params&&previousColumn.params.format?{format:previousColumn.params.format}:undefined}},isTransferable:()=>true,getErrorMessage:(layer,columnId)=>getErrorsForDateReference(layer,columnId,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.cumulativeSum",{defaultMessage:"Cumulative sum"})),getDisabledStatus(indexPattern,layer){var _checkForDateHistogra;return(_checkForDateHistogra=checkForDateHistogram(layer,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.cumulativeSum",{defaultMessage:"Cumulative sum"})))===null||_checkForDateHistogra===void 0?void 0:_checkForDateHistogra.join(", ")}};const derivative_ofName=buildLabelFunction(name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.derivativeOf",{defaultMessage:"Differences of {name}",values:{name:name!==null&&name!==void 0?name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.incompleteOperation",{defaultMessage:"(incomplete)"})}}));const derivativeOperation={type:"derivative",priority:1,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.derivative",{defaultMessage:"Differences"}),input:"fullReference",selectionStyle:"full",requiredReferences:[{input:["field"],validateMetadata:meta=>meta.dataType==="number"&&!meta.isBucketed}],getPossibleOperation:indexPattern=>{if(hasDateField(indexPattern)){return{dataType:"number",isBucketed:false,scale:"ratio"}}},getDefaultLabel:(column,indexPattern,columns)=>{const ref=columns[column.references[0]];return derivative_ofName(ref&&"sourceField"in ref?ref.sourceField:undefined,column.timeScale)},toExpression:(layer,columnId)=>dateBasedOperationToExpression(layer,columnId,"derivative"),buildColumn:({referenceIds:referenceIds,previousColumn:previousColumn,layer:layer})=>{const ref=layer.columns[referenceIds[0]];return{label:derivative_ofName(ref&&"sourceField"in ref?ref.sourceField:undefined,previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale),dataType:"number",operationType:"derivative",isBucketed:false,scale:"ratio",references:referenceIds,timeScale:previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale,params:(previousColumn===null||previousColumn===void 0?void 0:previousColumn.dataType)==="number"&&previousColumn.params&&"format"in previousColumn.params&&previousColumn.params.format?{format:previousColumn.params.format}:undefined}},isTransferable:(column,newIndexPattern)=>hasDateField(newIndexPattern),onOtherColumnChanged:adjustTimeScaleOnOtherColumnChange,getErrorMessage:(layer,columnId)=>getErrorsForDateReference(layer,columnId,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.derivative",{defaultMessage:"Differences"})),getDisabledStatus(indexPattern,layer){var _checkForDateHistogra;return(_checkForDateHistogra=checkForDateHistogram(layer,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.derivative",{defaultMessage:"Differences"})))===null||_checkForDateHistogra===void 0?void 0:_checkForDateHistogra.join(", ")},timeScalingMode:"optional"};const moving_average_ofName=buildLabelFunction(name=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverageOf",{defaultMessage:"Moving average of {name}",values:{name:name!==null&&name!==void 0?name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.incompleteOperation",{defaultMessage:"(incomplete)"})}}));const movingAverageOperation={type:"moving_average",priority:1,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverage",{defaultMessage:"Moving average"}),input:"fullReference",selectionStyle:"full",requiredReferences:[{input:["field"],validateMetadata:meta=>meta.dataType==="number"&&!meta.isBucketed}],getPossibleOperation:indexPattern=>{if(hasDateField(indexPattern)){return{dataType:"number",isBucketed:false,scale:"ratio"}}},getDefaultLabel:(column,indexPattern,columns)=>{var _columns$column$refer;return moving_average_ofName((_columns$column$refer=columns[column.references[0]])===null||_columns$column$refer===void 0?void 0:_columns$column$refer.label,column.timeScale)},toExpression:(layer,columnId)=>dateBasedOperationToExpression(layer,columnId,"moving_average",{window:[layer.columns[columnId].params.window]}),buildColumn:({referenceIds:referenceIds,previousColumn:previousColumn,layer:layer})=>{const metric=layer.columns[referenceIds[0]];return{label:moving_average_ofName(metric===null||metric===void 0?void 0:metric.label,previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale),dataType:"number",operationType:"moving_average",isBucketed:false,scale:"ratio",references:referenceIds,timeScale:previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale,params:(previousColumn===null||previousColumn===void 0?void 0:previousColumn.dataType)==="number"&&previousColumn.params&&"format"in previousColumn.params&&previousColumn.params.format?{format:previousColumn.params.format,window:5}:{window:5}}},paramEditor:MovingAverageParamEditor,isTransferable:(column,newIndexPattern)=>hasDateField(newIndexPattern),onOtherColumnChanged:adjustTimeScaleOnOtherColumnChange,getErrorMessage:(layer,columnId)=>getErrorsForDateReference(layer,columnId,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverage",{defaultMessage:"Moving average"})),getHelpMessage:()=>external_kbnSharedDeps_React_default.a.createElement(MovingAveragePopup,null),getDisabledStatus(indexPattern,layer){var _checkForDateHistogra;return(_checkForDateHistogra=checkForDateHistogram(layer,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverage",{defaultMessage:"Moving average"})))===null||_checkForDateHistogra===void 0?void 0:_checkForDateHistogra.join(", ")},timeScalingMode:"optional"};function MovingAverageParamEditor({layer:layer,updateLayer:updateLayer,currentColumn:currentColumn,columnId:columnId}){const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])(String(currentColumn.params.window));useDebounceWithOptions(()=>{if(!isValidNumber(inputValue,true,undefined,1))return;const inputNumber=parseInt(inputValue,10);updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"window",value:inputNumber}))},{skipFirstRender:true},256,[inputValue]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverage.window",{defaultMessage:"Window size"}),display:"columnCompressed",fullWidth:true,isInvalid:!isValidNumber(inputValue)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{compressed:true,value:inputValue,onChange:e=>setInputValue(e.target.value),min:1,step:1,isInvalid:!isValidNumber(inputValue)}))}const MovingAveragePopup=()=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(HelpPopover,{anchorPosition:"upCenter",button:external_kbnSharedDeps_React_default.a.createElement(HelpPopoverButton,{onClick:()=>setIsPopoverOpen(!isPopoverOpen)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverage.helpText",{defaultMessage:"How it works"})),closePopover:()=>setIsPopoverOpen(false),isOpen:isPopoverOpen,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.movingAverage.titleHelp",{defaultMessage:"How moving average works"})},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.movingAverage.basicExplanation",defaultMessage:"Moving average slides a window across the data and displays the average value. Moving average is supported only by date histograms."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.movingAverage.longerExplanation",defaultMessage:"To calculate the moving average, Lens uses the mean of the window and applies a skip policy for gaps.  For missing values, the bucket is skipped, and the calculation is performed on the next value."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.movingAverage.tableExplanation",defaultMessage:"For example, given the data [1, 2, 3, 4, 5, 6, 7, 8, 9, 10], you can calculate a simple moving average with a window size of 5:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,external_kbnSharedDeps_React_default.a.createElement("li",null,"(1 + 2 + 3 + 4 + 5) / 5 = 3"),external_kbnSharedDeps_React_default.a.createElement("li",null,"(2 + 3 + 4 + 5 + 6) / 5 = 4"),external_kbnSharedDeps_React_default.a.createElement("li",null,"..."),external_kbnSharedDeps_React_default.a.createElement("li",null,"(5 + 6 + 7 + 8 + 9) / 5 = 7")),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.movingAverage.windowLimitations",defaultMessage:"The window does not include the current value."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.movingAverage.windowInitialPartial",defaultMessage:"The window is partial until it reaches the requested number of items.  For example, with a window size of 5:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,external_kbnSharedDeps_React_default.a.createElement("li",null,"(1 + 2) / 2 = 1.5"),external_kbnSharedDeps_React_default.a.createElement("li",null,"(1 + 2 + 3) / 3 = 2"),external_kbnSharedDeps_React_default.a.createElement("li",null,"(1 + 2 + 3 + 4) / 4 = 2.5"),external_kbnSharedDeps_React_default.a.createElement("li",null,"(1 + 2 + 3 + 4 + 5) / 5 = 3")),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.movingAverage.limitations",defaultMessage:"The first moving average value starts at the second item."})))};const countLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.countOf",{defaultMessage:"Count of records"});const countOperation={type:"count",priority:2,displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.count",{defaultMessage:"Count"}),input:"field",getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern),onFieldChange:(oldColumn,field)=>({...oldColumn,label:adjustTimeScaleLabelSuffix(field.displayName,undefined,oldColumn.timeScale),sourceField:field.name}),getPossibleOperationForField:field=>{if(field.type==="document"){return{dataType:"number",isBucketed:false,scale:"ratio"}}},getDefaultLabel:column=>adjustTimeScaleLabelSuffix(countLabel,undefined,column.timeScale),buildColumn({field:field,previousColumn:previousColumn}){return{label:adjustTimeScaleLabelSuffix(countLabel,undefined,previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale),dataType:"number",operationType:"count",isBucketed:false,scale:"ratio",sourceField:field.name,timeScale:previousColumn===null||previousColumn===void 0?void 0:previousColumn.timeScale,params:(previousColumn===null||previousColumn===void 0?void 0:previousColumn.dataType)==="number"&&previousColumn.params&&"format"in previousColumn.params&&previousColumn.params.format?{format:previousColumn.params.format}:undefined}},onOtherColumnChanged:(layer,thisColumnId,changedColumnId)=>adjustTimeScaleOnOtherColumnChange(layer,thisColumnId,changedColumnId),toEsAggsFn:(column,columnId)=>Object(expressions_public_["buildExpressionFunction"])("aggCount",{id:columnId,enabled:true,schema:"metric"}).toAst(),isTransferable:()=>true,timeScalingMode:"optional"};function last_value_ofName(name){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValueOf",{defaultMessage:"Last value of {name}",values:{name:name}})}const last_value_supportedTypes=new Set(["string","boolean","number","ip"]);function getInvalidSortFieldMessage(sortField,indexPattern){if(!indexPattern){return}const field=indexPattern.getFieldByName(sortField);if(!field){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue.sortFieldNotFound",{defaultMessage:"Field {invalidField} was not found",values:{invalidField:sortField}})}if(field.type!=="date"){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue.invalidTypeSortField",{defaultMessage:"Field {invalidField} is not a date field and cannot be used for sorting",values:{invalidField:sortField}})}}function isTimeFieldNameDateField(indexPattern){return indexPattern.timeFieldName&&indexPattern.fields.find(field=>field.name===indexPattern.timeFieldName&&field.type==="date")}function getDateFields(indexPattern){const dateFields=indexPattern.fields.filter(field=>field.type==="date");if(isTimeFieldNameDateField(indexPattern)){dateFields.sort(({name:nameA},{name:nameB})=>{if(nameA===indexPattern.timeFieldName){return-1}if(nameB===indexPattern.timeFieldName){return 1}return 0})}return dateFields}const lastValueOperation={type:"last_value",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue",{defaultMessage:"Last value"}),getDefaultLabel:(column,indexPattern)=>last_value_ofName(getSafeName(column.sourceField,indexPattern)),input:"field",onFieldChange:(oldColumn,field)=>{const newParams={...oldColumn.params};if("format"in newParams&&field.type!=="number"){delete newParams.format}return{...oldColumn,dataType:field.type,label:last_value_ofName(field.displayName),sourceField:field.name,params:newParams}},getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,type:type})=>{if(last_value_supportedTypes.has(type)&&!aggregationRestrictions){return{dataType:type,isBucketed:false,scale:type==="string"?"ordinal":"ratio"}}},getDisabledStatus(indexPattern){const hasDateFields=indexPattern&&getDateFields(indexPattern).length;if(!hasDateFields){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue.disabled",{defaultMessage:"This function requires the presence of a date field in your index"})}},getErrorMessage(layer,columnId,indexPattern){const column=layer.columns[columnId];let errorMessages=[];const invalidSourceFieldMessage=getInvalidFieldMessage(column,indexPattern);const invalidSortFieldMessage=getInvalidSortFieldMessage(column.params.sortField,indexPattern);if(invalidSourceFieldMessage){errorMessages=[...invalidSourceFieldMessage]}if(invalidSortFieldMessage){errorMessages=[invalidSortFieldMessage]}return errorMessages.length?errorMessages:undefined},buildColumn({field:field,previousColumn:previousColumn,indexPattern:indexPattern}){var _indexPattern$fields$;const sortField=isTimeFieldNameDateField(indexPattern)?indexPattern.timeFieldName:(_indexPattern$fields$=indexPattern.fields.find(f=>f.type==="date"))===null||_indexPattern$fields$===void 0?void 0:_indexPattern$fields$.name;if(!sortField){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.lastValue.missingSortField",{defaultMessage:"This index pattern does not contain any date fields"}))}return{label:last_value_ofName(field.displayName),dataType:field.type,operationType:"last_value",isBucketed:false,scale:field.type==="string"?"ordinal":"ratio",sourceField:field.name,params:{sortField:sortField}}},toEsAggsFn:(column,columnId)=>Object(expressions_public_["buildExpressionFunction"])("aggTopHit",{id:columnId,enabled:true,schema:"metric",field:column.sourceField,aggregate:"concat",size:1,sortOrder:"desc",sortField:column.params.sortField}).toAst(),isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);const newTimeField=newIndexPattern.getFieldByName(column.params.sortField);return Boolean(newField&&newField.type===column.dataType&&!newField.aggregationRestrictions&&(newTimeField===null||newTimeField===void 0?void 0:newTimeField.type)==="date")},paramEditor:({layer:layer,updateLayer:updateLayer,columnId:columnId,currentColumn:currentColumn,indexPattern:indexPattern})=>{var _currentColumn$params,_indexPattern$getFiel;const dateFields=getDateFields(indexPattern);const isSortFieldInvalid=!!getInvalidSortFieldMessage(currentColumn.params.sortField,indexPattern);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue.sortField",{defaultMessage:"Sort by date field"}),display:"columnCompressed",fullWidth:true,error:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.sortField.invalid",{defaultMessage:"Invalid field. Check your index pattern or pick another field."}),isInvalid:isSortFieldInvalid},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue.sortFieldPlaceholder",{defaultMessage:"Sort field"}),compressed:true,isClearable:false,"data-test-subj":"lns-indexPattern-lastValue-sortField",isInvalid:isSortFieldInvalid,singleSelection:{asPlainText:true},"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.lastValue.sortField",{defaultMessage:"Sort by date field"}),options:dateFields===null||dateFields===void 0?void 0:dateFields.map(field=>({value:field.name,label:field.displayName})),onChange:choices=>{if(choices.length===0){return}updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:"sortField",value:choices[0].value}))},selectedOptions:(_currentColumn$params=currentColumn.params)!==null&&_currentColumn$params!==void 0&&_currentColumn$params.sortField?[{label:((_indexPattern$getFiel=indexPattern.getFieldByName(currentColumn.params.sortField))===null||_indexPattern$getFiel===void 0?void 0:_indexPattern$getFiel.displayName)||currentColumn.params.sortField,value:currentColumn.params.sortField}]:[]})))}};var advanced_editor=__webpack_require__(152);const TYPING_DEBOUNCE_TIME=256;const FROM_PLACEHOLDER="−∞";const TO_PLACEHOLDER="+∞";const DEFAULT_INTERVAL=1e3;const AUTO_BARS="auto";const MIN_HISTOGRAM_BARS=1;const SLICES=6;const MODES={Range:"range",Histogram:"histogram"};const advanced_editor_generateId=Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])();const getBetterLabel=(range,formatter)=>range.label||formatter.convert({gte:isValidNumber(range.from)?range.from:-Infinity,lt:isValidNumber(range.to)?range.to:Infinity});const RangePopover=({range:range,setRange:setRange,Button:Button,initiallyOpen:initiallyOpen})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[tempRange,setTempRange]=Object(external_kbnSharedDeps_React_["useState"])(range);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setIsPopoverOpen(initiallyOpen)},[]);const saveRangeAndReset=(newRange,resetRange=false)=>{if(resetRange){setTempRange(range)}setRange(newRange)};const{from:from,to:to,label:label}=tempRange;const lteAppendLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.lessThanOrEqualAppend",{defaultMessage:"≤"});const lteTooltipContent=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.lessThanOrEqualTooltip",{defaultMessage:"Less than or equal to"});const ltPrependLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.lessThanPrepend",{defaultMessage:"<"});const ltTooltipContent=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.lessThanTooltip",{defaultMessage:"Less than"});const onSubmit=()=>{if(isPopoverOpen){setIsPopoverOpen(false)}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{display:"block",ownFocus:true,isOpen:isPopoverOpen,closePopover:onSubmit,button:external_kbnSharedDeps_React_default.a.createElement(Button,{onClick:()=>{setIsPopoverOpen(isOpen=>!isOpen)}}),"data-test-subj":"indexPattern-ranges-popover"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",responsive:false,alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{className:"lnsRangesOperation__popoverNumberField",value:isValidNumber(from)?Number(from):"",onChange:({target:target})=>{const newRange={...tempRange,from:target.value!==""?Number(target.value):-Infinity};setTempRange(newRange);saveRangeAndReset(newRange)},append:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:lteTooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},lteAppendLabel)),compressed:true,placeholder:FROM_PLACEHOLDER,isInvalid:!isValidRange(tempRange)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"sortRight",color:"subdued"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{className:"lnsRangesOperation__popoverNumberField",value:isValidNumber(to)?Number(to):"",onChange:({target:target})=>{const newRange={...tempRange,to:target.value!==""?Number(target.value):Infinity};setTempRange(newRange);saveRangeAndReset(newRange)},prepend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:ltTooltipContent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},ltPrependLabel)),compressed:true,placeholder:TO_PLACEHOLDER,isInvalid:!isValidRange(tempRange),onKeyDown:({key:key})=>{if(external_kbnSharedDeps_ElasticEui_["keys"].ENTER===key&&onSubmit){onSubmit()}}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(LabelInput,{value:label||"",onChange:newLabel=>{const newRange={...tempRange,label:newLabel};setTempRange(newRange);saveRangeAndReset(newRange)},placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.customRangeLabelPlaceholder",{defaultMessage:"Custom label"}),onSubmit:onSubmit,compressed:true,dataTestSubj:"indexPattern-ranges-label"})))};const AdvancedRangeEditor=({ranges:ranges,setRanges:setRanges,onToggleEditor:onToggleEditor,formatter:formatter})=>{const[localRanges,setLocalRanges]=Object(external_kbnSharedDeps_React_["useState"])(()=>ranges.map(range=>({...range,id:advanced_editor_generateId()})));const[isOpenByCreation,setIsOpenByCreation]=Object(external_kbnSharedDeps_React_["useState"])(false);const lastIndex=localRanges.length-1;useDebounceWithOptions(()=>{setRanges(localRanges.map(({id:id,...rest})=>({...rest})))},{skipFirstRender:true},TYPING_DEBOUNCE_TIME,[localRanges]);const addNewRange=()=>{setLocalRanges([...localRanges,{id:advanced_editor_generateId(),from:localRanges[localRanges.length-1].to,to:Infinity,label:""}])};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.customRanges",{defaultMessage:"Ranges"}),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{color:"danger",onClick:onToggleEditor},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"s",type:"cross",color:"danger"})," ",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.customRangesRemoval",{defaultMessage:"Remove custom ranges"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(DragDropBuckets,{onDragEnd:setLocalRanges,onDragStart:()=>{},droppableId:"RANGES_DROPPABLE_AREA",items:localRanges},localRanges.map((range,idx)=>external_kbnSharedDeps_React_default.a.createElement(DraggableBucketContainer,{key:range.id,idx:idx,id:range.id,isInvalid:!isValidRange(range),invalidMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.range.isInvalid",{defaultMessage:"This range is invalid"}),onRemoveClick:()=>{const newRanges=localRanges.filter((_,i)=>i!==idx);setLocalRanges(newRanges)},removeTitle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.deleteRange",{defaultMessage:"Delete range"}),isNotRemovable:localRanges.length===1},external_kbnSharedDeps_React_default.a.createElement(RangePopover,{range:range,initiallyOpen:idx===lastIndex&&isOpenByCreation,setRange:newRange=>{const newRanges=[...localRanges];if(newRange.id===newRanges[idx].id){newRanges[idx]=newRange}else{newRanges.push(newRange)}setLocalRanges(newRanges)},Button:({onClick:onClick})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{color:"text",onClick:onClick,className:"lnsRangesOperation__popoverButton","data-test-subj":"indexPattern-ranges-popover-trigger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",textAlign:"left",color:isValidRange(range)?"default":"danger"},getBetterLabel(range,formatter)))})))),external_kbnSharedDeps_React_default.a.createElement(NewBucketButton,{onClick:()=>{addNewRange();setIsOpenByCreation(true)},label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.addRange",{defaultMessage:"Add range"})})))};const GranularityHelpPopover=()=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(HelpPopover,{anchorPosition:"upCenter",button:external_kbnSharedDeps_React_default.a.createElement(HelpPopoverButton,{onClick:()=>setIsPopoverOpen(!isPopoverOpen)},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.granularityHelpText",{defaultMessage:"How it works"})),closePopover:()=>setIsPopoverOpen(false),isOpen:isPopoverOpen,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.granularityPopoverTitle",{defaultMessage:"How granularity interval works"})},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.granularityPopoverBasicExplanation",{defaultMessage:"Interval granularity divides the field into evenly spaced intervals based on the minimum and maximum values for the field."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.ranges.granularityPopoverExplanation",defaultMessage:'The size of the interval is a "nice" value. When the granularity of the slider changes, the interval stays the same when the “nice” interval is the same. The minimum granularity is 1, and the maximum value is  {setting}. To change the maximum granularity, go to Advanced settings.',values:{setting:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,data_public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS)}})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.granularityPopoverAdvancedExplanation",{defaultMessage:"Intervals are incremented by 10, 5 or 2. For example, an interval can be 100 or 0.2 ."})))};const BaseRangeEditor=({maxBars:maxBars,step:step,maxHistogramBars:maxHistogramBars,onToggleEditor:onToggleEditor,onMaxBarsChange:onMaxBarsChange})=>{const[maxBarsValue,setMaxBarsValue]=Object(external_kbnSharedDeps_React_["useState"])(String(maxBars));useDebounceWithOptions(()=>{onMaxBarsChange(Number(maxBarsValue))},{skipFirstRender:true},TYPING_DEBOUNCE_TIME,[maxBarsValue]);const granularityLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.granularity",{defaultMessage:"Intervals granularity"});const decreaseButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.decreaseButtonLabel",{defaultMessage:"Decrease granularity"});const increaseButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.increaseButtonLabel",{defaultMessage:"Increase granularity"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:granularityLabel,"data-test-subj":"indexPattern-ranges-section-label",labelType:"legend",fullWidth:true,display:"rowCompressed",labelAppend:external_kbnSharedDeps_React_default.a.createElement(GranularityHelpPopover,null)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"xs",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:decreaseButtonLabel,delay:"long"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"minusInCircle",color:"text","data-test-subj":"lns-indexPattern-range-maxBars-minus",onClick:()=>setMaxBarsValue(""+Math.max(Number(maxBarsValue)-step,MIN_HISTOGRAM_BARS)),"aria-label":decreaseButtonLabel}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{compressed:true,fullWidth:true,"aria-label":granularityLabel,"data-test-subj":"lns-indexPattern-range-maxBars-field",min:MIN_HISTOGRAM_BARS,max:maxHistogramBars,step:step,value:maxBarsValue,onChange:({currentTarget:currentTarget})=>setMaxBarsValue(currentTarget.value)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:increaseButtonLabel,delay:"long"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"plusInCircle",color:"text","data-test-subj":"lns-indexPattern-range-maxBars-plus",onClick:()=>setMaxBarsValue(""+Math.min(Number(maxBarsValue)+step,maxHistogramBars)),"aria-label":increaseButtonLabel}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:"controlsHorizontal",onClick:()=>onToggleEditor()},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ranges.customIntervalsToggle",{defaultMessage:"Create custom ranges"})))};const RangeEditor=({setParam:setParam,params:params,maxHistogramBars:maxHistogramBars,maxBars:maxBars,granularityStep:granularityStep,onChangeMode:onChangeMode,rangeFormatter:rangeFormatter})=>{const[isAdvancedEditor,toggleAdvancedEditor]=Object(external_kbnSharedDeps_React_["useState"])(params.type===MODES.Range);if(isAdvancedEditor){return external_kbnSharedDeps_React_default.a.createElement(AdvancedRangeEditor,{ranges:params.ranges,setRanges:ranges=>{setParam("ranges",ranges)},onToggleEditor:()=>{onChangeMode(MODES.Histogram);toggleAdvancedEditor(false)},formatter:rangeFormatter})}return external_kbnSharedDeps_React_default.a.createElement(BaseRangeEditor,{maxBars:maxBars,step:granularityStep,maxHistogramBars:maxHistogramBars,onMaxBarsChange:newMaxBars=>{setParam("maxBars",newMaxBars)},onToggleEditor:()=>{onChangeMode(MODES.Range);toggleAdvancedEditor(true)}})};const supportedFormats={number:{decimalsToPattern:(decimals=2)=>{if(decimals===0){return`0,0`}return`0,0.${"0".repeat(decimals)}`}},percent:{decimalsToPattern:(decimals=2)=>{if(decimals===0){return`0,0%`}return`0,0.${"0".repeat(decimals)}%`}},bytes:{decimalsToPattern:(decimals=2)=>{if(decimals===0){return`0,0b`}return`0,0.${"0".repeat(decimals)}b`}}};const formatColumn={name:"lens_format_column",type:"datatable",help:"",args:{format:{types:["string"],help:"",required:true},columnId:{types:["string"],help:"",required:true},decimals:{types:["number"],help:""},parentFormat:{types:["string"],help:""}},inputTypes:["datatable"],fn(input,{format:format,columnId:columnId,decimals:decimals,parentFormat:parentFormat}){return{...input,columns:input.columns.map(col=>{if(col.id===columnId){var _parsedParentFormat$p;if(!parentFormat){if(supportedFormats[format]){return withParams(col,{id:format,params:{pattern:supportedFormats[format].decimalsToPattern(decimals)}})}else if(format){return withParams(col,{id:format})}else{return col}}const parsedParentFormat=JSON.parse(parentFormat);const parentFormatId=parsedParentFormat.id;const parentFormatParams=(_parsedParentFormat$p=parsedParentFormat.params)!==null&&_parsedParentFormat$p!==void 0?_parsedParentFormat$p:{};if(!parentFormatId){return col}if(format&&supportedFormats[format]){return withParams(col,{id:parentFormatId,params:{id:format,params:{pattern:supportedFormats[format].decimalsToPattern(decimals)},...parentFormatParams}})}if(parentFormatParams){var _col$meta$params,_col$meta$params2,_col$meta$params3,_col$meta$params4;const isNested=isNestedFormat(col.meta.params);const innerParams=isNested?(_col$meta$params=col.meta.params)===null||_col$meta$params===void 0?void 0:_col$meta$params.params:{id:(_col$meta$params2=col.meta.params)===null||_col$meta$params2===void 0?void 0:_col$meta$params2.id,params:(_col$meta$params3=col.meta.params)===null||_col$meta$params3===void 0?void 0:_col$meta$params3.params};const formatId=isNested?(_col$meta$params4=col.meta.params)===null||_col$meta$params4===void 0?void 0:_col$meta$params4.id:parentFormatId;return withParams(col,{...col.meta.params,id:formatId,params:{...innerParams,...parentFormatParams}})}}return col})}}};function isNestedFormat(params){var _params$params;return!!(params!==null&&params!==void 0&&(_params$params=params.params)!==null&&_params$params!==void 0&&_params$params.id)}function withParams(col,params){return{...col,meta:{...col.meta,params:params}}}const isRangeWithin=range=>range.from<=range.to;const isFullRange=range=>isValidNumber(range.from)&&isValidNumber(range.to);const isValidRange=range=>{if(isFullRange(range)){return isRangeWithin(range)}return true};function getFieldDefaultFormat(indexPattern,field){if(field){if(indexPattern.fieldFormatMap&&indexPattern.fieldFormatMap[field.name]){return indexPattern.fieldFormatMap[field.name]}}return undefined}const rangeOperation={type:"range",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.intervals",{defaultMessage:"Intervals"}),priority:4,input:"field",getErrorMessage:(layer,columnId,indexPattern)=>getInvalidFieldMessage(layer.columns[columnId],indexPattern),getPossibleOperationForField:({aggregationRestrictions:aggregationRestrictions,aggregatable:aggregatable,type:type})=>{if(type==="number"&&aggregatable&&(!aggregationRestrictions||aggregationRestrictions.range)){return{dataType:"number",isBucketed:true,scale:"interval"}}},getDefaultLabel:(column,indexPattern)=>{var _indexPattern$getFiel,_indexPattern$getFiel2;return(_indexPattern$getFiel=(_indexPattern$getFiel2=indexPattern.getFieldByName(column.sourceField))===null||_indexPattern$getFiel2===void 0?void 0:_indexPattern$getFiel2.displayName)!==null&&_indexPattern$getFiel!==void 0?_indexPattern$getFiel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.missingFieldLabel",{defaultMessage:"Missing field"})},buildColumn({field:field}){return{label:field.displayName,dataType:"number",operationType:"range",sourceField:field.name,isBucketed:true,scale:"interval",params:{type:MODES.Histogram,ranges:[{from:0,to:DEFAULT_INTERVAL,label:""}],maxBars:AUTO_BARS,format:undefined,parentFormat:undefined}}},isTransferable:(column,newIndexPattern)=>{const newField=newIndexPattern.getFieldByName(column.sourceField);return Boolean(newField&&newField.type==="number"&&newField.aggregatable&&(!newField.aggregationRestrictions||newField.aggregationRestrictions.range))},onFieldChange:(oldColumn,field)=>({...oldColumn,label:field.name,sourceField:field.name}),toEsAggsFn:(column,columnId,indexPattern,layer,uiSettings)=>{const{sourceField:sourceField,params:params}=column;if(params.type===MODES.Range){return Object(expressions_public_["buildExpressionFunction"])("aggRange",{id:columnId,enabled:true,schema:"segment",field:sourceField,ranges:JSON.stringify(params.ranges.filter(isValidRange).map(range=>{if(isFullRange(range)){return range}const partialRange={label:range.label};if(isValidNumber(range.from)){partialRange.from=Number(range.from)}if(isValidNumber(range.to)){partialRange.to=Number(range.to)}return partialRange}))}).toAst()}const maxBarsDefaultValue=(uiSettings.get(data_public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS)-MIN_HISTOGRAM_BARS)/2;return Object(expressions_public_["buildExpressionFunction"])("aggHistogram",{id:columnId,enabled:true,schema:"segment",field:sourceField,maxBars:params.maxBars===AUTO_BARS?maxBarsDefaultValue:params.maxBars,interval:"auto",has_extended_bounds:false,min_doc_count:false,extended_bounds:JSON.stringify({min:"",max:""})}).toAst()},paramEditor:({layer:layer,columnId:columnId,currentColumn:currentColumn,updateLayer:updateLayer,indexPattern:indexPattern,uiSettings:uiSettings,data:data})=>{var _numberFormat$params,_currentColumn$params;const currentField=indexPattern.getFieldByName(currentColumn.sourceField);const numberFormat=currentColumn.params.format;const numberFormatterPattern=numberFormat&&supportedFormats[numberFormat.id]&&supportedFormats[numberFormat.id].decimalsToPattern(((_numberFormat$params=numberFormat.params)===null||_numberFormat$params===void 0?void 0:_numberFormat$params.decimals)||0);const rangeFormatter=data.fieldFormats.deserialize({...currentColumn.params.parentFormat,params:{...(_currentColumn$params=currentColumn.params.parentFormat)===null||_currentColumn$params===void 0?void 0:_currentColumn$params.params,...numberFormat?{id:numberFormat.id,params:{pattern:numberFormatterPattern}}:getFieldDefaultFormat(indexPattern,currentField)}});const MAX_HISTOGRAM_BARS=uiSettings.get(data_public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS);const granularityStep=(MAX_HISTOGRAM_BARS-MIN_HISTOGRAM_BARS)/SLICES;const maxBarsDefaultValue=(MAX_HISTOGRAM_BARS-MIN_HISTOGRAM_BARS)/2;const setParam=(paramName,value)=>{updateLayer(updateColumnParam({layer:layer,columnId:columnId,paramName:paramName,value:value}))};const onChangeMode=newMode=>{const scale=newMode===MODES.Range?"ordinal":"interval";const dataType=newMode===MODES.Range?"string":"number";const parentFormat=newMode===MODES.Range?{id:"range",params:{template:"arrow_right",replaceInfinity:true}}:undefined;updateLayer({...layer,columns:{...layer.columns,[columnId]:{...currentColumn,scale:scale,dataType:dataType,params:{type:newMode,ranges:[{from:0,to:DEFAULT_INTERVAL,label:""}],maxBars:maxBarsDefaultValue,format:currentColumn.params.format,parentFormat:parentFormat}}}})};return external_kbnSharedDeps_React_default.a.createElement(RangeEditor,{setParam:setParam,maxBars:currentColumn.params.maxBars===AUTO_BARS?maxBarsDefaultValue:currentColumn.params.maxBars,granularityStep:granularityStep,params:currentColumn.params,onChangeMode:onChangeMode,maxHistogramBars:uiSettings.get(data_public_["UI_SETTINGS"].HISTOGRAM_MAX_BARS),rangeFormatter:rangeFormatter})}};var column_types=__webpack_require__(43);const internalOperationDefinitions=[filtersOperation,termsOperation,dateHistogramOperation,minOperation,maxOperation,averageOperation,cardinalityOperation,sumOperation,medianOperation,percentileOperation,lastValueOperation,countOperation,rangeOperation,cumulativeSumOperation,counterRateOperation,derivativeOperation,movingAverageOperation];const operationDefinitions=internalOperationDefinitions;const operationDefinitionMap=internalOperationDefinitions.reduce((definitionMap,definition)=>({...definitionMap,[definition.type]:definition}),{});const documentField={displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.records",{defaultMessage:"Records"}),name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.records",{defaultMessage:"Records"}),type:"document",aggregatable:true,searchable:true};function getOperations(){return Object.keys(operationDefinitionMap)}function getOperationDisplay(){const display={};operationDefinitions.forEach(({type:type,displayName:displayName})=>{display[type]={type:type,displayName:displayName}});return display}function getSortScoreByPriority(a,b){return(b.priority||Number.NEGATIVE_INFINITY)-(a.priority||Number.NEGATIVE_INFINITY)}function getOperationTypesForField(field,filterOperations){return operationDefinitions.filter(operationDefinition=>{if(operationDefinition.input!=="field"){return false}const possibleOperation=operationDefinition.getPossibleOperationForField(field);return filterOperations?possibleOperation&&filterOperations(possibleOperation):possibleOperation}).sort(getSortScoreByPriority).map(({type:type})=>type)}let documentOperations;function isDocumentOperation(type){documentOperations=documentOperations||new Set(getOperationTypesForField(documentField));return documentOperations.has(type)}function getAvailableOperationsByMetadata(indexPattern){const operationByMetadata={};const addToMap=(operation,operationMetadata)=>{if(!operationMetadata)return;const key=JSON.stringify(operationMetadata);if(operationByMetadata[key]){operationByMetadata[key].operations.push(operation)}else{operationByMetadata[key]={operationMetaData:operationMetadata,operations:[operation]}}};operationDefinitions.sort(getSortScoreByPriority).forEach(operationDefinition=>{if(operationDefinition.input==="field"){indexPattern.fields.forEach(field=>{addToMap({type:"field",operationType:operationDefinition.type,field:field.name},operationDefinition.getPossibleOperationForField(field))})}else if(operationDefinition.input==="none"){addToMap({type:"none",operationType:operationDefinition.type},operationDefinition.getPossibleOperation())}else if(operationDefinition.input==="fullReference"){const validOperation=operationDefinition.getPossibleOperation(indexPattern);if(validOperation){addToMap({type:"fullReference",operationType:operationDefinition.type},validOperation)}}});return Object.values(operationByMetadata)}const memoizedGetAvailableOperationsByMetadata=Object(external_kbnSharedDeps_Lodash_["memoize"])(getAvailableOperationsByMetadata);var common=__webpack_require__(1);const STORAGE_KEY="lens-settings";const readFromStorage=(storage,key)=>{const data=storage.get(STORAGE_KEY);return data&&data[key]};const writeToStorage=(storage,key,value)=>{storage.set(STORAGE_KEY,{[key]:value})};function fieldExists(existingFields,indexPatternTitle,fieldName){return existingFields[indexPatternTitle]&&existingFields[indexPatternTitle][fieldName]}function getFieldByNameFactory(newFields){const fieldsLookup=Object(external_kbnSharedDeps_Lodash_["keyBy"])(newFields,"name");return name=>fieldsLookup[name]}async function loadIndexPatterns({indexPatternsService:indexPatternsService,patterns:patterns,cache:cache}){const missingIds=patterns.filter(id=>!cache[id]);if(missingIds.length===0){return cache}const indexPatterns=await Promise.all(missingIds.map(id=>indexPatternsService.get(id)));if(memoizedGetAvailableOperationsByMetadata.cache.clear){memoizedGetAvailableOperationsByMetadata.cache.clear()}const indexPatternsObject=indexPatterns.reduce((acc,indexPattern)=>{const newFields=indexPattern.fields.filter(field=>!data_public_["indexPatterns"].isNestedField(field)&&(!!field.aggregatable||!!field.scripted)).map(field=>{const base={name:field.name,displayName:field.displayName,type:field.type,aggregatable:field.aggregatable,searchable:field.searchable,meta:indexPattern.metaFields.includes(field.name),esTypes:field.esTypes,scripted:field.scripted};return base.scripted?{...base,lang:field.lang,script:field.script}:base}).concat(documentField);const{typeMeta:typeMeta,title:title,timeFieldName:timeFieldName,fieldFormatMap:fieldFormatMap}=indexPattern;if(typeMeta!==null&&typeMeta!==void 0&&typeMeta.aggs){const aggs=Object.keys(typeMeta.aggs);newFields.forEach((field,index)=>{const restrictionsObj={};aggs.forEach(agg=>{const restriction=typeMeta.aggs&&typeMeta.aggs[agg]&&typeMeta.aggs[agg][field.name];if(restriction){restrictionsObj[agg]=restriction}});if(Object.keys(restrictionsObj).length){newFields[index]={...field,aggregationRestrictions:restrictionsObj}}})}const currentIndexPattern={id:indexPattern.id,title:title,timeFieldName:timeFieldName,fieldFormatMap:fieldFormatMap&&Object.fromEntries(Object.entries(fieldFormatMap).map(([id,format])=>[id,"toJSON"in format?format.toJSON():format])),fields:newFields,getFieldByName:getFieldByNameFactory(newFields),hasRestrictions:!!(typeMeta!==null&&typeMeta!==void 0&&typeMeta.aggs)};return{[currentIndexPattern.id]:currentIndexPattern,...acc}},{...cache});return indexPatternsObject}const getLastUsedIndexPatternId=(storage,indexPatternRefs)=>{var _indexPatternRefs$fin;const indexPattern=readFromStorage(storage,"indexPatternId");return indexPattern&&((_indexPatternRefs$fin=indexPatternRefs.find(i=>i.id===indexPattern))===null||_indexPatternRefs$fin===void 0?void 0:_indexPatternRefs$fin.id)};const setLastUsedIndexPatternId=(storage,value)=>{writeToStorage(storage,"indexPatternId",value)};const CURRENT_PATTERN_REFERENCE_NAME="indexpattern-datasource-current-indexpattern";function getLayerReferenceName(layerId){return`indexpattern-datasource-layer-${layerId}`}function extractReferences({currentIndexPatternId:currentIndexPatternId,layers:layers}){const savedObjectReferences=[];savedObjectReferences.push({type:"index-pattern",id:currentIndexPatternId,name:CURRENT_PATTERN_REFERENCE_NAME});const persistableLayers={};Object.entries(layers).forEach(([layerId,{indexPatternId:indexPatternId,...persistableLayer}])=>{savedObjectReferences.push({type:"index-pattern",id:indexPatternId,name:getLayerReferenceName(layerId)});persistableLayers[layerId]=persistableLayer});return{savedObjectReferences:savedObjectReferences,state:{layers:persistableLayers}}}function injectReferences(state,references){const layers={};Object.entries(state.layers).forEach(([layerId,persistedLayer])=>{layers[layerId]={...persistedLayer,indexPatternId:references.find(({name:name})=>name===getLayerReferenceName(layerId)).id}});return{currentIndexPatternId:references.find(({name:name})=>name===CURRENT_PATTERN_REFERENCE_NAME).id,layers:layers}}async function loadInitialState({persistedState:persistedState,references:references,savedObjectsClient:savedObjectsClient,defaultIndexPatternId:defaultIndexPatternId,storage:storage,indexPatternsService:indexPatternsService,initialContext:initialContext,options:options}){var _indexPatternRefs$,_initialContext$index;const{isFullEditor:isFullEditor}=options!==null&&options!==void 0?options:{};const indexPatternRefs=await(isFullEditor?loadIndexPatternRefs(savedObjectsClient):[]);const lastUsedIndexPatternId=getLastUsedIndexPatternId(storage,indexPatternRefs);const state=persistedState&&references?injectReferences(persistedState,references):undefined;const requiredPatterns=external_kbnSharedDeps_Lodash_default.a.uniq(state?Object.values(state.layers).map(l=>l.indexPatternId).concat(state.currentIndexPatternId):[lastUsedIndexPatternId||defaultIndexPatternId||((_indexPatternRefs$=indexPatternRefs[0])===null||_indexPatternRefs$===void 0?void 0:_indexPatternRefs$.id)]).filter(Boolean);const currentIndexPatternId=(_initialContext$index=initialContext===null||initialContext===void 0?void 0:initialContext.indexPatternId)!==null&&_initialContext$index!==void 0?_initialContext$index:requiredPatterns[0];if(currentIndexPatternId){setLastUsedIndexPatternId(storage,currentIndexPatternId)}const indexPatterns=await loadIndexPatterns({indexPatternsService:indexPatternsService,cache:{},patterns:initialContext?[initialContext.indexPatternId]:requiredPatterns});if(state){return{...state,currentIndexPatternId:currentIndexPatternId,indexPatternRefs:indexPatternRefs,indexPatterns:indexPatterns,existingFields:{},isFirstExistenceFetch:true}}return{currentIndexPatternId:currentIndexPatternId,indexPatternRefs:indexPatternRefs,indexPatterns:indexPatterns,layers:{},existingFields:{},isFirstExistenceFetch:true}}async function loader_changeIndexPattern({id:id,state:state,setState:setState,onError:onError,storage:storage,indexPatternsService:indexPatternsService}){try{const indexPatterns=await loadIndexPatterns({indexPatternsService:indexPatternsService,cache:state.indexPatterns,patterns:[id]});setState(s=>({...s,layers:isSingleEmptyLayer(state.layers)?external_kbnSharedDeps_Lodash_default.a.mapValues(state.layers,layer=>updateLayerIndexPattern(layer,indexPatterns[id])):state.layers,indexPatterns:{...s.indexPatterns,[id]:indexPatterns[id]},currentIndexPatternId:id}));setLastUsedIndexPatternId(storage,id)}catch(err){onError(err)}}async function changeLayerIndexPattern({indexPatternId:indexPatternId,layerId:layerId,state:state,setState:setState,onError:onError,replaceIfPossible:replaceIfPossible,storage:storage,indexPatternsService:indexPatternsService}){try{const indexPatterns=await loadIndexPatterns({indexPatternsService:indexPatternsService,cache:state.indexPatterns,patterns:[indexPatternId]});setState(s=>({...s,layers:{...s.layers,[layerId]:updateLayerIndexPattern(s.layers[layerId],indexPatterns[indexPatternId])},indexPatterns:{...s.indexPatterns,[indexPatternId]:indexPatterns[indexPatternId]},currentIndexPatternId:replaceIfPossible?indexPatternId:s.currentIndexPatternId}));setLastUsedIndexPatternId(storage,indexPatternId)}catch(err){onError(err)}}async function loadIndexPatternRefs(savedObjectsClient){const result=await savedObjectsClient.find({type:"index-pattern",fields:["title"],perPage:1e4});return result.savedObjects.map(o=>({id:String(o.id),title:o.attributes.title})).sort((a,b)=>a.title.localeCompare(b.title))}async function syncExistingFields({indexPatterns:indexPatterns,dateRange:dateRange,fetchJson:fetchJson,setState:setState,isFirstExistenceFetch:isFirstExistenceFetch,currentIndexPatternTitle:currentIndexPatternTitle,dslQuery:dslQuery,showNoDataPopover:showNoDataPopover}){const existenceRequests=indexPatterns.map(pattern=>{if(pattern.hasRestrictions){return{indexPatternTitle:pattern.title,existingFieldNames:pattern.fields.map(field=>field.name)}}const body={dslQuery:dslQuery,fromDate:dateRange.fromDate,toDate:dateRange.toDate};if(pattern.timeFieldName){body.timeFieldName=pattern.timeFieldName}return fetchJson(`${common["BASE_API_URL"]}/existing_fields/${pattern.id}`,{body:JSON.stringify(body)})});try{const emptinessInfo=await Promise.all(existenceRequests);if(isFirstExistenceFetch){const fieldsCurrentIndexPattern=emptinessInfo.find(info=>info.indexPatternTitle===currentIndexPatternTitle);if(fieldsCurrentIndexPattern&&fieldsCurrentIndexPattern.existingFieldNames.length===0){showNoDataPopover()}}setState(state=>({...state,isFirstExistenceFetch:false,existenceFetchFailed:false,existingFields:emptinessInfo.reduce((acc,info)=>{acc[info.indexPatternTitle]=booleanMap(info.existingFieldNames);return acc},state.existingFields)}))}catch(e){setState(state=>({...state,existenceFetchFailed:true,existingFields:indexPatterns.reduce((acc,pattern)=>{acc[pattern.title]=booleanMap(pattern.fields.map(field=>field.name));return acc},state.existingFields)}))}}function booleanMap(keys){return keys.reduce((acc,key)=>{acc[key]=true;return acc},{})}function isSingleEmptyLayer(layerMap){const layers=Object.values(layerMap);return layers.length===1&&layers[0].columnOrder.length===0}function getExpressionForLayer(layer,indexPattern,uiSettings){const{columns:columns,columnOrder:columnOrder}=layer;if(columnOrder.length===0){return null}const columnEntries=columnOrder.map(colId=>[colId,columns[colId]]);if(columnEntries.length){const aggs=[];const expressions=[];columnEntries.forEach(([colId,col])=>{const def=operationDefinitionMap[col.operationType];if(def.input==="fullReference"){expressions.push(...def.toExpression(layer,colId,indexPattern))}else{aggs.push(Object(expressions_public_["buildExpression"])({type:"expression",chain:[def.toEsAggsFn(col,colId,indexPattern,layer,uiSettings)]}))}});const idMap=columnEntries.reduce((currentIdMap,[colId,column],index)=>{const esAggsId=`col-${columnEntries.length===1?0:index}-${colId}`;const suffix=getEsAggsSuffix(column);return{...currentIdMap,[`${esAggsId}${suffix}`]:{...column,id:colId}}},{});const columnsWithFormatters=columnEntries.filter(([,col])=>col.params&&("format"in col.params&&col.params.format||"parentFormat"in col.params&&col.params.parentFormat));const formatterOverrides=columnsWithFormatters.map(([id,col])=>{var _format$params;const parentFormat="parentFormat"in col.params?col.params.parentFormat:undefined;const format=col.params.format;const base={type:"function",function:"lens_format_column",arguments:{format:format?[format.id]:[""],columnId:[id],decimals:typeof(format===null||format===void 0?void 0:(_format$params=format.params)===null||_format$params===void 0?void 0:_format$params.decimals)==="number"?[format.params.decimals]:[],parentFormat:parentFormat?[JSON.stringify(parentFormat)]:[]}};return base});const firstDateHistogramColumn=columnEntries.find(([,col])=>col.operationType==="date_histogram");const columnsWithTimeScale=firstDateHistogramColumn?columnEntries.filter(([,col])=>col.timeScale&&operationDefinitionMap[col.operationType].timeScalingMode&&operationDefinitionMap[col.operationType].timeScalingMode!=="disabled"):[];const timeScaleFunctions=columnsWithTimeScale.flatMap(([id,col])=>{const scalingCall={type:"function",function:"lens_time_scale",arguments:{dateColumnId:[firstDateHistogramColumn[0]],inputColumnId:[id],outputColumnId:[id],outputColumnName:[col.label],targetUnit:[col.timeScale]}};const formatCall={type:"function",function:"lens_format_column",arguments:{format:[""],columnId:[id],parentFormat:[JSON.stringify({id:"suffix",params:{unit:col.timeScale}})]}};return[scalingCall,formatCall]});const allDateHistogramFields=Object.values(columns).map(column=>column.operationType===dateHistogramOperation.type?column.sourceField:null).filter(field=>Boolean(field));return{type:"expression",chain:[Object(expressions_public_["buildExpressionFunction"])("esaggs",{index:Object(expressions_public_["buildExpression"])([Object(expressions_public_["buildExpressionFunction"])("indexPatternLoad",{id:indexPattern.id})]),aggs:aggs,metricsAtAllLevels:false,partialRows:false,timeFields:allDateHistogramFields}).toAst(),{type:"function",function:"lens_rename_columns",arguments:{idMap:[JSON.stringify(idMap)]}},...expressions,...formatterOverrides,...timeScaleFunctions]}}return null}function indexpattern_datasource_to_expression_toExpression(state,layerId,uiSettings){if(state.layers[layerId]){return getExpressionForLayer(state.layers[layerId],state.indexPatterns[state.layers[layerId].indexPatternId],uiSettings)}return null}function normalizeOperationDataType(type){if(type==="histogram")return"number";return type==="document"?"number":type}function hasField(column){return"sourceField"in column}function sortByField(columns){return[...columns].sort((column1,column2)=>{if(hasField(column1)&&hasField(column2)){return column1.sourceField.localeCompare(column2.sourceField)}return column1.operationType.localeCompare(column2.operationType)})}function isDraggedField(fieldCandidate){return typeof fieldCandidate==="object"&&fieldCandidate!==null&&["id","field","indexPatternId"].every(prop=>prop in fieldCandidate)}function isColumnInvalid(layer,columnId,indexPattern){var _operationDefinition$;const column=layer.columns[columnId];if(!column)return;const operationDefinition=column.operationType&&operationDefinitionMap[column.operationType];const referencesHaveErrors=true&&"references"in column&&Boolean(getReferencesErrors(layer,column,indexPattern).filter(Boolean).length);return!!((_operationDefinition$=operationDefinition.getErrorMessage)!==null&&_operationDefinition$!==void 0&&_operationDefinition$.call(operationDefinition,layer,columnId,indexPattern))||referencesHaveErrors}function getReferencesErrors(layer,column,indexPattern){var _column$references;return(_column$references=column.references)===null||_column$references===void 0?void 0:_column$references.map(referenceId=>{var _layer$columns$refere,_referencedDefinition;const referencedOperation=(_layer$columns$refere=layer.columns[referenceId])===null||_layer$columns$refere===void 0?void 0:_layer$columns$refere.operationType;const referencedDefinition=operationDefinitionMap[referencedOperation];return referencedDefinition===null||referencedDefinition===void 0?void 0:(_referencedDefinition=referencedDefinition.getErrorMessage)===null||_referencedDefinition===void 0?void 0:_referencedDefinition.call(referencedDefinition,layer,referenceId,indexPattern)})}function utils_fieldIsInvalid(column,indexPattern){var _getInvalidFieldMessa;if(!column||!hasField(column)){return false}return!!((_getInvalidFieldMessa=getInvalidFieldMessage(column,indexPattern))!==null&&_getInvalidFieldMessa!==void 0&&_getInvalidFieldMessa.length)}var dimension_editor=__webpack_require__(44);function mergeLayer({state:state,layerId:layerId,newLayer:newLayer}){return{...state,layers:{...state.layers,[layerId]:{...state.layers[layerId],...newLayer}}}}var field_select=__webpack_require__(169);function lens_field_icon_extends(){lens_field_icon_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return lens_field_icon_extends.apply(this,arguments)}function LensFieldIcon({type:type,...rest}){return external_kbnSharedDeps_React_default.a.createElement(public_["FieldIcon"],lens_field_icon_extends({className:"lnsFieldListPanel__fieldIcon",type:normalizeOperationDataType(type)},rest))}function field_select_extends(){field_select_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return field_select_extends.apply(this,arguments)}function FieldSelect({currentIndexPattern:currentIndexPattern,incompleteOperation:incompleteOperation,selectedOperationType:selectedOperationType,selectedField:selectedField,operationSupportMatrix:operationSupportMatrix,onChoose:onChoose,onDeleteColumn:onDeleteColumn,existingFields:existingFields,fieldIsInvalid:fieldIsInvalid,markAllFieldsCompatible:markAllFieldsCompatible,...rest}){var _currentIndexPattern$7;const{operationByField:operationByField}=operationSupportMatrix;const memoizedFieldOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const fields=Object.keys(operationByField).sort();const currentOperationType=incompleteOperation!==null&&incompleteOperation!==void 0?incompleteOperation:selectedOperationType;function isCompatibleWithCurrentOperation(fieldName){return!currentOperationType||operationByField[fieldName].has(currentOperationType)}const[specialFields,normalFields]=external_kbnSharedDeps_Lodash_default.a.partition(fields,field=>{var _currentIndexPattern$;return((_currentIndexPattern$=currentIndexPattern.getFieldByName(field))===null||_currentIndexPattern$===void 0?void 0:_currentIndexPattern$.type)==="document"});const containsData=field=>{var _currentIndexPattern$2;return((_currentIndexPattern$2=currentIndexPattern.getFieldByName(field))===null||_currentIndexPattern$2===void 0?void 0:_currentIndexPattern$2.type)==="document"||fieldExists(existingFields,currentIndexPattern.title,field)};function fieldNamesToOptions(items){return items.filter(field=>{var _currentIndexPattern$3;return(_currentIndexPattern$3=currentIndexPattern.getFieldByName(field))===null||_currentIndexPattern$3===void 0?void 0:_currentIndexPattern$3.displayName}).map(field=>{var _currentIndexPattern$4,_currentIndexPattern$5;return{label:(_currentIndexPattern$4=currentIndexPattern.getFieldByName(field))===null||_currentIndexPattern$4===void 0?void 0:_currentIndexPattern$4.displayName,value:{type:"field",field:field,dataType:(_currentIndexPattern$5=currentIndexPattern.getFieldByName(field))===null||_currentIndexPattern$5===void 0?void 0:_currentIndexPattern$5.type,operationType:currentOperationType&&isCompatibleWithCurrentOperation(field)?currentOperationType:operationByField[field].values().next().value},exists:containsData(field),compatible:markAllFieldsCompatible||isCompatibleWithCurrentOperation(field)}}).sort((a,b)=>{if(a.compatible&&!b.compatible){return-1}if(!a.compatible&&b.compatible){return 1}return 0}).map(({label:label,value:value,compatible:compatible,exists:exists})=>({label:label,value:value,className:classnames_default()({"lnFieldSelect__option--incompatible":!compatible,"lnFieldSelect__option--nonExistant":!exists}),"data-test-subj":`lns-fieldOption${compatible?"":"Incompatible"}-${value.field}`}))}const[metaFields,nonMetaFields]=external_kbnSharedDeps_Lodash_default.a.partition(normalFields,field=>{var _currentIndexPattern$6;return(_currentIndexPattern$6=currentIndexPattern.getFieldByName(field))===null||_currentIndexPattern$6===void 0?void 0:_currentIndexPattern$6.meta});const[availableFields,emptyFields]=external_kbnSharedDeps_Lodash_default.a.partition(nonMetaFields,containsData);const constructFieldsOptions=(fieldsArr,label)=>fieldsArr.length>0&&{label:label,options:fieldNamesToOptions(fieldsArr)};const availableFieldsOptions=constructFieldsOptions(availableFields,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.availableFieldsLabel",{defaultMessage:"Available fields"}));const emptyFieldsOptions=constructFieldsOptions(emptyFields,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.emptyFieldsLabel",{defaultMessage:"Empty fields"}));const metaFieldsOptions=constructFieldsOptions(metaFields,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.metaFieldsLabel",{defaultMessage:"Meta fields"}));return[...fieldNamesToOptions(specialFields),availableFieldsOptions,emptyFieldsOptions,metaFieldsOptions].filter(Boolean)},[incompleteOperation,selectedOperationType,currentIndexPattern,operationByField,existingFields,markAllFieldsCompatible]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],field_select_extends({fullWidth:true,compressed:true,isClearable:false,"data-test-subj":"indexPattern-dimension-field",placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldPlaceholder",{defaultMessage:"Field"}),options:memoizedFieldOptions,isInvalid:Boolean(incompleteOperation||fieldIsInvalid),selectedOptions:selectedOperationType&&selectedField?[{label:fieldIsInvalid?selectedField:(_currentIndexPattern$7=currentIndexPattern.getFieldByName(selectedField))===null||_currentIndexPattern$7===void 0?void 0:_currentIndexPattern$7.displayName,value:{type:"field",field:selectedField}}]:[],singleSelection:{asPlainText:true},onChange:choices=>{if(choices.length===0){onDeleteColumn();return}const choice=choices[0].value;if(choice.field!==selectedField){Object(lens_ui_telemetry["e"])("indexpattern_dimension_field_changed");onChoose(choice)}},renderOption:(option,searchValue)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:null},external_kbnSharedDeps_React_default.a.createElement(LensFieldIcon,{type:option.value.dataType,fill:"none"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHighlight"],{search:searchValue},option.label)))},rest))}function nestColumn(columnOrder,outer,inner){const result=columnOrder.filter(c=>c!==inner);const outerPosition=result.indexOf(outer);result.splice(outerPosition+1,0,inner);return result}function getFieldName(column,getFieldByName){var _getFieldByName;return hasField(column)?((_getFieldByName=getFieldByName(column.sourceField))===null||_getFieldByName===void 0?void 0:_getFieldByName.displayName)||column.sourceField:""}function BucketNestingEditor({columnId:columnId,layer:layer,setColumns:setColumns,getFieldByName:getFieldByName}){const column=layer.columns[columnId];const columns=Object.entries(layer.columns);const aggColumns=columns.filter(([id,c])=>id!==columnId&&c.isBucketed).map(([value,c])=>({value:value,text:c.label,fieldName:getFieldName(c,getFieldByName),operationType:c.operationType}));if(!column||!column.isBucketed||!aggColumns.length){return null}const prevColumn=layer.columnOrder[layer.columnOrder.indexOf(columnId)-1];if(aggColumns.length===1){const[target]=aggColumns;const useAsTopLevelAggCopy=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.useAsTopLevelAgg",{defaultMessage:"Group by this field first"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:useAsTopLevelAggCopy,display:"columnCompressedSwitch"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,label:useAsTopLevelAggCopy,showLabel:false,"data-test-subj":"indexPattern-nesting-switch",name:"nestingSwitch",checked:!prevColumn,onChange:()=>{if(prevColumn){setColumns(nestColumn(layer.columnOrder,columnId,target.value))}else{setColumns(nestColumn(layer.columnOrder,target.value,columnId))}}}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.groupByDropdown",{defaultMessage:"Group by"}),display:"columnCompressed",fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,"data-test-subj":"indexPattern-nesting-select",options:[{value:"",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.nestUnderRoot",{defaultMessage:"Entire data set"})},...aggColumns.map(({value:value,text:text})=>({value:value,text:text}))],value:prevColumn,onChange:e=>setColumns(nestColumn(layer.columnOrder,e.target.value,columnId))}))}const format_selector_supportedFormats={number:{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.numberFormatLabel",{defaultMessage:"Number"})},percent:{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.percentFormatLabel",{defaultMessage:"Percent"})},bytes:{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.bytesFormatLabel",{defaultMessage:"Bytes (1024)"})}};function FormatSelector(props){var _currentFormat$params,_selectedFormat$title;const{selectedColumn:selectedColumn,onChange:onChange}=props;const currentFormat="params"in selectedColumn&&selectedColumn.params&&"format"in selectedColumn.params?selectedColumn.params.format:undefined;const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({decimalPlaces:typeof(currentFormat===null||currentFormat===void 0?void 0:(_currentFormat$params=currentFormat.params)===null||_currentFormat$params===void 0?void 0:_currentFormat$params.decimals)==="number"?currentFormat.params.decimals:2});const selectedFormat=currentFormat!==null&&currentFormat!==void 0&&currentFormat.id?format_selector_supportedFormats[currentFormat.id]:undefined;const defaultOption={value:"",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.defaultFormatLabel",{defaultMessage:"Default"})};const label=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.columnFormatLabel",{defaultMessage:"Value format"});const decimalsLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.decimalPlacesLabel",{defaultMessage:"Decimals"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:label,display:"columnCompressed",fullWidth:true},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{fullWidth:true,compressed:true,isClearable:false,"data-test-subj":"indexPattern-dimension-format","aria-label":label,singleSelection:{asPlainText:true},options:[defaultOption,...Object.entries(format_selector_supportedFormats).map(([id,format])=>{var _format$title;return{value:id,label:(_format$title=format.title)!==null&&_format$title!==void 0?_format$title:id}})],selectedOptions:currentFormat?[{value:currentFormat.id,label:(_selectedFormat$title=selectedFormat===null||selectedFormat===void 0?void 0:selectedFormat.title)!==null&&_selectedFormat$title!==void 0?_selectedFormat$title:currentFormat.id}]:[defaultOption],onChange:choices=>{if(choices.length===0){return}if(!choices[0].value){onChange();return}onChange({id:choices[0].value,params:{decimals:state.decimalPlaces}})}}),currentFormat?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{showInput:"inputWithPopover",min:0,max:20,value:state.decimalPlaces,onChange:e=>{setState({decimalPlaces:Number(e.currentTarget.value)});onChange({id:selectedColumn.params.format.id,params:{decimals:Number(e.currentTarget.value)}})},"data-test-subj":"indexPattern-dimension-formatDecimals",compressed:true,fullWidth:true,prepend:decimalsLabel,"aria-label":decimalsLabel})):null)))}function reference_editor_extends(){reference_editor_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return reference_editor_extends.apply(this,arguments)}const operationPanels=getOperationDisplay();function ReferenceEditor(props){var _incompleteInfo$sourc;const{layer:layer,columnId:columnId,updateLayer:updateLayer,currentIndexPattern:currentIndexPattern,existingFields:existingFields,validation:validation,selectionStyle:selectionStyle,dateRange:dateRange,labelAppend:labelAppend,...services}=props;const column=layer.columns[columnId];const selectedOperationDefinition=column&&operationDefinitionMap[column.operationType];const ParamEditor=selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:selectedOperationDefinition.paramEditor;const incompleteInfo=layer.incompleteColumns?layer.incompleteColumns[columnId]:undefined;const incompleteOperation=incompleteInfo===null||incompleteInfo===void 0?void 0:incompleteInfo.operationType;const incompleteField=(_incompleteInfo$sourc=incompleteInfo===null||incompleteInfo===void 0?void 0:incompleteInfo.sourceField)!==null&&_incompleteInfo$sourc!==void 0?_incompleteInfo$sourc:null;const operationSupportMatrix=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const operationTypes=new Set;const operationWithoutField=new Set;const operationByField={};const fieldByOperation={};Object.values(operationDefinitionMap).sort((op1,op2)=>op1.displayName.localeCompare(op2.displayName)).forEach(op=>{if(op.input==="field"){const allFields=currentIndexPattern.fields.filter(field=>isOperationAllowedAsReference({operationType:op.type,validation:validation,field:field,indexPattern:currentIndexPattern}));if(allFields.length){operationTypes.add(op.type);fieldByOperation[op.type]=new Set(allFields.map(({name:name})=>name));allFields.forEach(field=>{var _operationByField$fie;if(!operationByField[field.name]){operationByField[field.name]=new Set}(_operationByField$fie=operationByField[field.name])===null||_operationByField$fie===void 0?void 0:_operationByField$fie.add(op.type)})}}else if(isOperationAllowedAsReference({operationType:op.type,validation:validation,indexPattern:currentIndexPattern})){operationTypes.add(op.type);operationWithoutField.add(op.type)}});return{operationTypes:operationTypes,operationWithoutField:operationWithoutField,operationByField:operationByField,fieldByOperation:fieldByOperation}},[currentIndexPattern,validation]);const functionOptions=Array.from(operationSupportMatrix.operationTypes).map(operationType=>{var _operationSupportMatr;const def=operationDefinitionMap[operationType];const label=operationPanels[operationType].displayName;const isCompatible=!column||column&&hasField(column)&&def.input==="field"&&((_operationSupportMatr=operationSupportMatrix.fieldByOperation[operationType])===null||_operationSupportMatr===void 0?void 0:_operationSupportMatr.has(column.sourceField))||column&&!hasField(column)&&def.input!=="field";return{label:label,value:operationType,className:"lnsIndexPatternDimensionEditor__operation","data-test-subj":`lns-indexPatternDimension-${operationType}${isCompatible?"":" incompatible"}`}});function onChooseFunction(operationType){if((column===null||column===void 0?void 0:column.operationType)===operationType){return}const possibleFieldNames=operationSupportMatrix.fieldByOperation[operationType];if(column&&"sourceField"in column&&possibleFieldNames!==null&&possibleFieldNames!==void 0&&possibleFieldNames.has(column.sourceField)){updateLayer(insertOrReplaceColumn({layer:layer,columnId:columnId,op:operationType,indexPattern:currentIndexPattern,field:currentIndexPattern.getFieldByName(column.sourceField)}))}else{const possibleField=(possibleFieldNames===null||possibleFieldNames===void 0?void 0:possibleFieldNames.size)===1?currentIndexPattern.getFieldByName(possibleFieldNames.values().next().value):undefined;updateLayer(insertOrReplaceColumn({layer:layer,columnId:columnId,op:operationType,indexPattern:currentIndexPattern,field:possibleField}))}Object(lens_ui_telemetry["e"])(`indexpattern_dimension_operation_${operationType}`);return}const selectedOption=incompleteOperation?[functionOptions.find(({value:value})=>value===incompleteOperation)]:column?[functionOptions.find(({value:value})=>value===column.operationType)]:[];const showOperationInvalid=!column&&!Boolean(incompleteOperation);const showFieldInvalid=Boolean(incompleteOperation)||selectionStyle==="field"&&!column;const showFieldMissingInvalid=!currentIndexPattern.getFieldByName(incompleteField!==null&&incompleteField!==void 0?incompleteField:column===null||column===void 0?void 0:column.sourceField);const showSelectionFunctionInvalid=Boolean(selectedOption.length&&selectedOption[0]==null);if(showSelectionFunctionInvalid){const selectedOperationType=incompleteOperation||column.operationType;const brokenFunctionOption={label:operationPanels[selectedOperationType].displayName,value:selectedOperationType,className:"lnsIndexPatternDimensionEditor__operation","data-test-subj":`lns-indexPatternDimension-${selectedOperationType} incompatible`};functionOptions.push(brokenFunctionOption);selectedOption[0]=brokenFunctionOption}return external_kbnSharedDeps_React_default.a.createElement("div",{id:columnId},external_kbnSharedDeps_React_default.a.createElement("div",null,selectionStyle!=="field"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{"data-test-subj":"indexPattern-subFunction-selection-row",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.chooseSubFunction",{defaultMessage:"Choose a sub-function"}),fullWidth:true,isInvalid:showOperationInvalid||showSelectionFunctionInvalid},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{fullWidth:true,compressed:true,isClearable:false,"data-test-subj":"indexPattern-reference-function",placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.referenceFunctionPlaceholder",{defaultMessage:"Sub-function"}),options:functionOptions,isInvalid:showOperationInvalid||showSelectionFunctionInvalid,selectedOptions:selectedOption,singleSelection:{asPlainText:true},onChange:choices=>{if(choices.length===0){updateLayer(deleteColumn({layer:layer,columnId:columnId,indexPattern:currentIndexPattern}));return}Object(lens_ui_telemetry["e"])("indexpattern_dimension_field_changed");onChooseFunction(choices[0].value)}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})):null,!column||selectedOperationDefinition.input==="field"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{"data-test-subj":"indexPattern-reference-field-selection-row",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.chooseField",{defaultMessage:"Select a field"}),fullWidth:true,isInvalid:showFieldInvalid||showFieldMissingInvalid,labelAppend:labelAppend},external_kbnSharedDeps_React_default.a.createElement(FieldSelect,{fieldIsInvalid:showFieldInvalid||showFieldMissingInvalid,currentIndexPattern:currentIndexPattern,existingFields:existingFields,operationSupportMatrix:operationSupportMatrix,selectedOperationType:column?column.operationType:incompleteOperation,selectedField:incompleteField!==null&&incompleteField!==void 0?incompleteField:column===null||column===void 0?void 0:column.sourceField,incompleteOperation:incompleteOperation,markAllFieldsCompatible:selectionStyle==="field",onDeleteColumn:()=>{updateLayer(deleteColumn({layer:layer,columnId:columnId,indexPattern:currentIndexPattern}))},onChoose:choice=>{updateLayer(insertOrReplaceColumn({layer:layer,columnId:columnId,indexPattern:currentIndexPattern,op:choice.operationType,field:currentIndexPattern.getFieldByName(choice.field)}))}})):null,column&&!incompleteInfo&&ParamEditor&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ParamEditor,reference_editor_extends({updateLayer:updateLayer,currentColumn:column,layer:layer,columnId:columnId,indexPattern:currentIndexPattern,dateRange:dateRange},services)))))}function setTimeScaling(columnId,layer,timeScale){const currentColumn=layer.columns[columnId];const label=currentColumn.customLabel?currentColumn.label:adjustTimeScaleLabelSuffix(currentColumn.label,currentColumn.timeScale,timeScale);return{...layer,columns:{...layer.columns,[columnId]:{...layer.columns[columnId],label:label,timeScale:timeScale}}}}function TimeScaling({selectedColumn:selectedColumn,columnId:columnId,layer:layer,updateLayer:updateLayer}){const[popoverOpen,setPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const hasDateHistogram=layer.columnOrder.some(colId=>layer.columns[colId].operationType==="date_histogram");const selectedOperation=operationDefinitionMap[selectedColumn.operationType];if(!selectedOperation.timeScalingMode||selectedOperation.timeScalingMode==="disabled"||!hasDateHistogram){return null}if(!selectedColumn.timeScale){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{textAlign:"right"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:true,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:"arrowDown",iconSide:"right","data-test-subj":"indexPattern-time-scaling-popover",onClick:()=>{setPopoverOpen(!popoverOpen)}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.timeScale.advancedSettings",{defaultMessage:"Add advanced options"})),isOpen:popoverOpen,closePopover:()=>{setPopoverOpen(false)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"data-test-subj":"indexPattern-time-scaling-enable",color:"text",onClick:()=>{setPopoverOpen(false);updateLayer(setTimeScaling(columnId,layer,DEFAULT_TIME_SCALE))}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.timeScale.enableTimeScale",{defaultMessage:"Normalize by unit"})))))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.timeScale.tooltip",{defaultMessage:"Normalize values to be always shown as rate per specified time unit, regardless of the underlying date interval."})},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.timeScale.label",{defaultMessage:"Normalize by unit"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued",size:"s",className:"eui-alignTop"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,options:Object.entries(unitSuffixesLong).map(([unit,text])=>({value:unit,text:text})),"data-test-subj":"indexPattern-time-scaling-unit",value:selectedColumn.timeScale,onChange:e=>{updateLayer(setTimeScaling(columnId,layer,e.target.value))}})),selectedOperation.timeScalingMode==="optional"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"data-test-subj":"indexPattern-time-scaling-remove",color:"danger","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.timeScale.removeLabel",{defaultMessage:"Remove normalizing by time unit"}),onClick:()=>{updateLayer(setTimeScaling(columnId,layer,undefined))},iconType:"cross"}))))}function dimension_editor_extends(){dimension_editor_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return dimension_editor_extends.apply(this,arguments)}const dimension_editor_operationPanels=getOperationDisplay();const dimension_editor_LabelInput=({value:value,onChange:onChange})=>{const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])(value);const unflushedChanges=Object(external_kbnSharedDeps_React_["useRef"])(false);const initialValue=Object(external_kbnSharedDeps_React_["useRef"])(value);const onChangeDebounced=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const callback=external_kbnSharedDeps_Lodash_default.a.debounce(val=>{onChange(val);unflushedChanges.current=false},256);return val=>{unflushedChanges.current=true;callback(val)}},[onChange]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!unflushedChanges.current&&value!==inputValue){setInputValue(value)}},[value,inputValue]);const handleInputChange=e=>{const val=String(e.target.value);setInputValue(val);onChangeDebounced(val||initialValue.current)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.columnLabel",{defaultMessage:"Display name",description:"Display name of a column of data"}),display:"columnCompressed",fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{compressed:true,"data-test-subj":"indexPattern-label-edit",value:inputValue,onChange:handleInputChange,placeholder:initialValue.current}))};function dimension_editor_DimensionEditor(props){var _state$layers$layerId2,_incompleteInfo$sourc,_selectedOperationDef2;const{selectedColumn:selectedColumn,operationSupportMatrix:operationSupportMatrix,state:state,columnId:columnId,setState:setState,layerId:layerId,currentIndexPattern:currentIndexPattern,hideGrouping:hideGrouping,dateRange:dateRange}=props;const services={data:props.data,uiSettings:props.uiSettings,savedObjectsClient:props.savedObjectsClient,http:props.http,storage:props.storage};const{fieldByOperation:fieldByOperation,operationWithoutField:operationWithoutField}=operationSupportMatrix;const setStateWrapper=layer=>{var _layer$incompleteColu,_operationDefinitionM,_state$layers$layerId;const hasIncompleteColumns=Boolean((_layer$incompleteColu=layer.incompleteColumns)===null||_layer$incompleteColu===void 0?void 0:_layer$incompleteColu[columnId]);const prevOperationType=(_operationDefinitionM=operationDefinitionMap[(_state$layers$layerId=state.layers[layerId].columns[columnId])===null||_state$layers$layerId===void 0?void 0:_state$layers$layerId.operationType])===null||_operationDefinitionM===void 0?void 0:_operationDefinitionM.input;setState(mergeLayer({state:state,layerId:layerId,newLayer:layer}),{shouldReplaceDimension:Boolean(layer.columns[columnId]),shouldRemoveDimension:Boolean(hasIncompleteColumns&&prevOperationType==="fullReference")})};const selectedOperationDefinition=selectedColumn&&operationDefinitionMap[selectedColumn.operationType];const incompleteInfo=((_state$layers$layerId2=state.layers[layerId].incompleteColumns)!==null&&_state$layers$layerId2!==void 0?_state$layers$layerId2:{})[columnId];const incompleteOperation=incompleteInfo===null||incompleteInfo===void 0?void 0:incompleteInfo.operationType;const incompleteField=(_incompleteInfo$sourc=incompleteInfo===null||incompleteInfo===void 0?void 0:incompleteInfo.sourceField)!==null&&_incompleteInfo$sourc!==void 0?_incompleteInfo$sourc:null;const ParamEditor=selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:selectedOperationDefinition.paramEditor;const possibleOperations=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(operationDefinitionMap).sort((op1,op2)=>op1.displayName.localeCompare(op2.displayName)).map(def=>def.type).filter(type=>{var _fieldByOperation$typ;return((_fieldByOperation$typ=fieldByOperation[type])===null||_fieldByOperation$typ===void 0?void 0:_fieldByOperation$typ.size)||operationWithoutField.has(type)}),[fieldByOperation,operationWithoutField]);const operationsWithCompatibility=[...possibleOperations].map(operationType=>{const definition=operationDefinitionMap[operationType];const currentField=selectedColumn&&hasField(selectedColumn)&&currentIndexPattern.getFieldByName(selectedColumn.sourceField);return{operationType:operationType,compatibleWithCurrentField:canTransition({layer:state.layers[layerId],columnId:columnId,op:operationType,indexPattern:currentIndexPattern,field:currentField||undefined,filterOperations:props.filterOperations}),disabledStatus:definition.getDisabledStatus&&definition.getDisabledStatus(state.indexPatterns[state.currentIndexPatternId],state.layers[layerId])}});const currentFieldIsInvalid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>utils_fieldIsInvalid(selectedColumn,currentIndexPattern),[selectedColumn,currentIndexPattern]);const sideNavItems=operationsWithCompatibility.map(({operationType:operationType,compatibleWithCurrentField:compatibleWithCurrentField,disabledStatus:disabledStatus})=>{const isActive=Boolean(incompleteOperation===operationType||!incompleteOperation&&selectedColumn&&selectedColumn.operationType===operationType);let color="primary";if(isActive){color="text"}else if(!compatibleWithCurrentField){color="subdued"}let label=dimension_editor_operationPanels[operationType].displayName;if(isActive&&disabledStatus){label=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:disabledStatus,display:"block",position:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"danger",size:"s"},external_kbnSharedDeps_React_default.a.createElement("strong",null,dimension_editor_operationPanels[operationType].displayName)))}else if(disabledStatus){label=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:disabledStatus,display:"block",position:"left"},external_kbnSharedDeps_React_default.a.createElement("span",null,dimension_editor_operationPanels[operationType].displayName))}else if(isActive){label=external_kbnSharedDeps_React_default.a.createElement("strong",null,dimension_editor_operationPanels[operationType].displayName)}return{id:operationType,label:label,color:color,isActive:isActive,size:"s",isDisabled:!!disabledStatus,className:"lnsIndexPatternDimensionEditor__operation","data-test-subj":`lns-indexPatternDimension-${operationType}${compatibleWithCurrentField?"":" incompatible"}`,[`aria-pressed`]:isActive,onClick(){if(operationDefinitionMap[operationType].input==="none"||operationDefinitionMap[operationType].input==="fullReference"){if((selectedColumn===null||selectedColumn===void 0?void 0:selectedColumn.operationType)===operationType){if(incompleteInfo){setStateWrapper(resetIncomplete(state.layers[layerId],columnId))}return}const newLayer=insertOrReplaceColumn({layer:props.state.layers[props.layerId],indexPattern:currentIndexPattern,columnId:columnId,op:operationType});setStateWrapper(newLayer);Object(lens_ui_telemetry["e"])(`indexpattern_dimension_operation_${operationType}`);return}else if(!selectedColumn||!compatibleWithCurrentField){const possibleFields=fieldByOperation[operationType]||new Set;if(possibleFields.size===1){setStateWrapper(insertOrReplaceColumn({layer:props.state.layers[props.layerId],indexPattern:currentIndexPattern,columnId:columnId,op:operationType,field:currentIndexPattern.getFieldByName(possibleFields.values().next().value)}))}else{setStateWrapper(insertOrReplaceColumn({layer:props.state.layers[props.layerId],indexPattern:currentIndexPattern,columnId:columnId,op:operationType,field:undefined}))}Object(lens_ui_telemetry["e"])(`indexpattern_dimension_operation_${operationType}`);return}if(selectedColumn.operationType===operationType){if(incompleteInfo){setStateWrapper(resetIncomplete(state.layers[layerId],columnId))}return}const newLayer=replaceColumn({layer:props.state.layers[props.layerId],indexPattern:currentIndexPattern,columnId:columnId,op:operationType,field:hasField(selectedColumn)?currentIndexPattern.getFieldByName(selectedColumn.sourceField):undefined});setStateWrapper(newLayer)}}});const fieldErrorMessage=((selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:selectedOperationDefinition.input)!=="fullReference"||incompleteOperation&&operationDefinitionMap[incompleteOperation].input==="field")&&getErrorMessage(selectedColumn,Boolean(incompleteOperation),selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:selectedOperationDefinition.input,currentFieldIsInvalid);return external_kbnSharedDeps_React_default.a.createElement("div",{id:columnId},external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsIndexPatternDimensionEditor__section lnsIndexPatternDimensionEditor__section--shaded"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormLabel"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.functionsLabel",{defaultMessage:"Select a function"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroup"],{className:sideNavItems.length>3?"lnsIndexPatternDimensionEditor__columns":"",gutterSize:"none",listItems:sideNavItems.length%2===1?[...sideNavItems,{label:" "}]:sideNavItems,maxWidth:false})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsIndexPatternDimensionEditor__section lnsIndexPatternDimensionEditor__section--shaded"},!incompleteInfo&&selectedColumn&&"references"in selectedColumn&&(selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:selectedOperationDefinition.input)==="fullReference"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,selectedColumn.references.map((referenceId,index)=>{var _selectedOperationDef;const validation=selectedOperationDefinition.requiredReferences[index];return external_kbnSharedDeps_React_default.a.createElement(ReferenceEditor,dimension_editor_extends({key:index,layer:state.layers[layerId],columnId:referenceId,updateLayer:newLayer=>{setState(mergeLayer({state:state,layerId:layerId,newLayer:newLayer}))},validation:validation,currentIndexPattern:currentIndexPattern,existingFields:state.existingFields,selectionStyle:selectedOperationDefinition.selectionStyle,dateRange:dateRange,labelAppend:selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:(_selectedOperationDef=selectedOperationDefinition.getHelpMessage)===null||_selectedOperationDef===void 0?void 0:_selectedOperationDef.call(selectedOperationDefinition,{data:props.data,uiSettings:props.uiSettings,currentColumn:state.layers[layerId].columns[columnId]})},services))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})):null,!selectedColumn||(selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:selectedOperationDefinition.input)==="field"||incompleteOperation&&operationDefinitionMap[incompleteOperation].input==="field"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{"data-test-subj":"indexPattern-field-selection-row",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.chooseField",{defaultMessage:"Select a field"}),fullWidth:true,isInvalid:Boolean(incompleteOperation||currentFieldIsInvalid),error:fieldErrorMessage,labelAppend:!fieldErrorMessage&&(selectedOperationDefinition===null||selectedOperationDefinition===void 0?void 0:(_selectedOperationDef2=selectedOperationDefinition.getHelpMessage)===null||_selectedOperationDef2===void 0?void 0:_selectedOperationDef2.call(selectedOperationDefinition,{data:props.data,uiSettings:props.uiSettings,currentColumn:state.layers[layerId].columns[columnId]}))},external_kbnSharedDeps_React_default.a.createElement(FieldSelect,{fieldIsInvalid:currentFieldIsInvalid,currentIndexPattern:currentIndexPattern,existingFields:state.existingFields,operationSupportMatrix:operationSupportMatrix,selectedOperationType:selectedColumn?selectedColumn.operationType:incompleteOperation,selectedField:incompleteField?incompleteField:selectedColumn===null||selectedColumn===void 0?void 0:selectedColumn.sourceField,incompleteOperation:incompleteOperation,onDeleteColumn:()=>{setStateWrapper(deleteColumn({layer:state.layers[layerId],columnId:columnId,indexPattern:currentIndexPattern}))},onChoose:choice=>{setStateWrapper(insertOrReplaceColumn({layer:state.layers[layerId],columnId:columnId,indexPattern:currentIndexPattern,op:choice.operationType,field:currentIndexPattern.getFieldByName(choice.field)}))}})):null,!currentFieldIsInvalid&&!incompleteInfo&&selectedColumn&&ParamEditor&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ParamEditor,dimension_editor_extends({layer:state.layers[layerId],updateLayer:setStateWrapper,columnId:columnId,currentColumn:state.layers[layerId].columns[columnId],dateRange:dateRange,indexPattern:currentIndexPattern},services))),!currentFieldIsInvalid&&!incompleteInfo&&selectedColumn&&external_kbnSharedDeps_React_default.a.createElement(TimeScaling,{selectedColumn:selectedColumn,columnId:columnId,layer:state.layers[layerId],updateLayer:setStateWrapper})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),!currentFieldIsInvalid&&external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsIndexPatternDimensionEditor__section"},!incompleteInfo&&selectedColumn&&external_kbnSharedDeps_React_default.a.createElement(dimension_editor_LabelInput,{value:selectedColumn.label,onChange:value=>{setState(mergeLayer({state:state,layerId:layerId,newLayer:{columns:{...state.layers[layerId].columns,[columnId]:{...selectedColumn,label:value,customLabel:true}}}}))}}),!incompleteInfo&&!hideGrouping&&external_kbnSharedDeps_React_default.a.createElement(BucketNestingEditor,{layer:state.layers[props.layerId],columnId:props.columnId,setColumns:columnOrder=>setState(mergeLayer({state:state,layerId:layerId,newLayer:{columnOrder:columnOrder}})),getFieldByName:currentIndexPattern.getFieldByName}),selectedColumn&&(selectedColumn.dataType==="number"||selectedColumn.operationType==="range")?external_kbnSharedDeps_React_default.a.createElement(FormatSelector,{selectedColumn:selectedColumn,onChange:newFormat=>{setState(mergeLayer({state:state,layerId:layerId,newLayer:updateColumnParam({layer:state.layers[layerId],columnId:columnId,paramName:"format",value:newFormat})}))}}):null))}function getErrorMessage(selectedColumn,incompleteOperation,input,fieldInvalid){if(selectedColumn&&incompleteOperation){if(input==="field"){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.invalidOperationLabel",{defaultMessage:"To use this function, select a different field."})}return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.chooseFieldLabel",{defaultMessage:"To use this function, select a field."})}if(fieldInvalid){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.invalidFieldLabel",{defaultMessage:"Invalid field. Check your index pattern or pick another field."})}}const getOperationSupportMatrix=props=>{const layerId=props.layerId;const currentIndexPattern=props.state.indexPatterns[props.state.layers[layerId].indexPatternId];const filteredOperationsByMetadata=memoizedGetAvailableOperationsByMetadata(currentIndexPattern).filter(operation=>props.filterOperations(operation.operationMetaData));const supportedOperationsByField={};const supportedOperationsWithoutField=new Set;const supportedFieldsByOperation={};filteredOperationsByMetadata.forEach(({operations:operations})=>{operations.forEach(operation=>{if(operation.type==="field"){var _supportedOperationsB,_supportedFieldsByOpe;if(!supportedOperationsByField[operation.field]){supportedOperationsByField[operation.field]=new Set}(_supportedOperationsB=supportedOperationsByField[operation.field])===null||_supportedOperationsB===void 0?void 0:_supportedOperationsB.add(operation.operationType);if(!supportedFieldsByOperation[operation.operationType]){supportedFieldsByOperation[operation.operationType]=new Set}(_supportedFieldsByOpe=supportedFieldsByOperation[operation.operationType])===null||_supportedFieldsByOpe===void 0?void 0:_supportedFieldsByOpe.add(operation.field)}else{supportedOperationsWithoutField.add(operation.operationType)}})});return{operationByField:supportedOperationsByField,operationWithoutField:supportedOperationsWithoutField,fieldByOperation:supportedFieldsByOperation}};function dimension_panel_extends(){dimension_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return dimension_panel_extends.apply(this,arguments)}function wrapOnDot(str){return str?str.replace(/\./g,".​"):""}const IndexPatternDimensionTriggerComponent=function IndexPatternDimensionTrigger(props){var _layer$columns$props$;const layerId=props.layerId;const layer=props.state.layers[layerId];const currentIndexPattern=props.state.indexPatterns[layer.indexPatternId];const{columnId:columnId,uniqueLabel:uniqueLabel}=props;const currentColumnHasErrors=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isColumnInvalid(layer,columnId,currentIndexPattern),[layer,columnId,currentIndexPattern]);const selectedColumn=(_layer$columns$props$=layer.columns[props.columnId])!==null&&_layer$columns$props$!==void 0?_layer$columns$props$:null;if(!selectedColumn){return null}const formattedLabel=wrapOnDot(uniqueLabel);if(currentColumnHasErrors){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configure.invalidConfigTooltip",{defaultMessage:"Invalid configuration."}),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configure.invalidConfigTooltipClick",{defaultMessage:"Click for more details."})),anchorClassName:"eui-displayBlock"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"danger",id:columnId,className:"lnsLayerPanel__triggerText","data-test-subj":"lns-dimensionTrigger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"s",type:"alert"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},selectedColumn.label))))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",id:columnId,className:"lnsLayerPanel__triggerText","data-test-subj":"lns-dimensionTrigger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement("span",{className:"lnsLayerPanel__triggerTextLabel"},formattedLabel))))};const IndexPatternDimensionEditorComponent=function IndexPatternDimensionPanel(props){var _props$state$layers$l;const layerId=props.layerId;const currentIndexPattern=props.state.indexPatterns[(_props$state$layers$l=props.state.layers[layerId])===null||_props$state$layers$l===void 0?void 0:_props$state$layers$l.indexPatternId];const operationSupportMatrix=getOperationSupportMatrix(props);const selectedColumn=props.state.layers[layerId].columns[props.columnId]||null;return external_kbnSharedDeps_React_default.a.createElement(dimension_editor_DimensionEditor,dimension_panel_extends({},props,{currentIndexPattern:currentIndexPattern,selectedColumn:selectedColumn,operationSupportMatrix:operationSupportMatrix}))};const dimension_panel_IndexPatternDimensionTrigger=Object(external_kbnSharedDeps_React_["memo"])(IndexPatternDimensionTriggerComponent);const IndexPatternDimensionEditor=Object(external_kbnSharedDeps_React_["memo"])(IndexPatternDimensionEditorComponent);const LENS_EDIT_SORT_ACTION="sort";const LENS_EDIT_RESIZE_ACTION="resize";const LENS_TOGGLE_ACTION="toggle";function isDraggedOperation(operationCandidate){return typeof operationCandidate==="object"&&operationCandidate!==null&&"columnId"in operationCandidate}function isLensFilterEvent(event){return event.name==="filter"}function isLensBrushEvent(event){return event.name==="brush"}function isLensEditEvent(event){return event.name==="edit"}function isLensTableRowContextMenuClickEvent(event){return event.name==="tableRowContextMenuClick"}const operationLabels=getOperationDisplay();function getDropProps(props){const{dragging:dragging}=props;if(!dragging){return}const layerIndexPatternId=props.state.layers[props.layerId].indexPatternId;const currentColumn=props.state.layers[props.layerId].columns[props.columnId];if(isDraggedField(dragging)){const operationsForNewField=getOperationTypesForField(dragging.field,props.filterOperations);if(!!(layerIndexPatternId===dragging.indexPatternId&&operationsForNewField.length)){const highestPriorityOperationLabel=operationLabels[operationsForNewField[0]].displayName;if(!currentColumn){return{dropType:"field_add",nextLabel:highestPriorityOperationLabel}}else if(hasField(currentColumn)&&currentColumn.sourceField!==dragging.field.name||!hasField(currentColumn)){const persistingOperationLabel=currentColumn&&operationsForNewField.includes(currentColumn.operationType)&&operationLabels[currentColumn.operationType].displayName;return{dropType:"field_replace",nextLabel:persistingOperationLabel||highestPriorityOperationLabel}}}return}if(isDraggedOperation(dragging)&&dragging.layerId===props.layerId&&props.columnId!==dragging.columnId){if(props.groupId===dragging.groupId){if(currentColumn){return{dropType:"reorder"}}return{dropType:"duplicate_in_group"}}const op=props.state.layers[dragging.layerId].columns[dragging.columnId];if(!op||currentColumn&&hasField(currentColumn)&&hasField(op)&&currentColumn.sourceField===op.sourceField){return}if(props.filterOperations(op)){if(currentColumn){return{dropType:"replace_compatible"}}else{return{dropType:"move_compatible"}}}const field=hasField(op)&&props.state.indexPatterns[layerIndexPatternId].getFieldByName(op.sourceField);const operationsForNewField=field&&getOperationTypesForField(field,props.filterOperations);if(operationsForNewField&&operationsForNewField!==null&&operationsForNewField!==void 0&&operationsForNewField.length){const highestPriorityOperationLabel=operationLabels[operationsForNewField[0]].displayName;if(currentColumn){const persistingOperationLabel=currentColumn&&operationsForNewField.includes(currentColumn.operationType)&&operationLabels[currentColumn.operationType].displayName;return{dropType:"replace_incompatible",nextLabel:persistingOperationLabel||highestPriorityOperationLabel}}else{return{dropType:"move_incompatible",nextLabel:highestPriorityOperationLabel}}}}}function droppable_onDrop(props){const{droppedItem:droppedItem,dropType:dropType}=props;if(dropType==="field_add"||dropType==="field_replace"){return operationOnDropMap[dropType]({...props,droppedItem:droppedItem})}return operationOnDropMap[dropType]({...props,droppedItem:droppedItem})}const operationOnDropMap={field_add:onFieldDrop,field_replace:onFieldDrop,reorder:onReorderDrop,duplicate_in_group:onSameGroupDuplicateDrop,move_compatible:onMoveDropToCompatibleGroup,replace_compatible:onMoveDropToCompatibleGroup,move_incompatible:onMoveDropToNonCompatibleGroup,replace_incompatible:onMoveDropToNonCompatibleGroup};function reorderElements(items,dest,src){const result=items.filter(c=>c!==src);const destIndex=items.findIndex(c=>c===src);const destPosition=result.indexOf(dest);const srcIndex=items.findIndex(c=>c===dest);result.splice(destIndex<srcIndex?destPosition+1:destPosition,0,src);return result}function onReorderDrop({columnId:columnId,setState:setState,state:state,layerId:layerId,droppedItem:droppedItem}){setState(mergeLayer({state:state,layerId:layerId,newLayer:{columnOrder:reorderElements(state.layers[layerId].columnOrder,columnId,droppedItem.columnId)}}));return true}function onMoveDropToNonCompatibleGroup(props){const{columnId:columnId,setState:setState,state:state,layerId:layerId,droppedItem:droppedItem}=props;const layer=state.layers[layerId];const op={...layer.columns[droppedItem.columnId]};const field=hasField(op)&&state.indexPatterns[layer.indexPatternId].getFieldByName(op.sourceField);if(!field){return false}const operationsForNewField=getOperationTypesForField(field,props.filterOperations);if(!operationsForNewField.length){return false}const currentIndexPattern=state.indexPatterns[layer.indexPatternId];const selectedColumn=layer.columns[columnId]||null;const fieldIsCompatibleWithCurrent=selectedColumn&&operationsForNewField.includes(selectedColumn.operationType);const newLayer=insertOrReplaceColumn({layer:deleteColumn({layer:layer,columnId:droppedItem.columnId,indexPattern:currentIndexPattern}),columnId:columnId,indexPattern:currentIndexPattern,op:fieldIsCompatibleWithCurrent?selectedColumn.operationType:operationsForNewField[0],field:field});Object(lens_ui_telemetry["e"])("drop_onto_dimension");setState(mergeLayer({state:state,layerId:layerId,newLayer:{...newLayer}}));return{deleted:droppedItem.columnId}}function onSameGroupDuplicateDrop({columnId:columnId,setState:setState,state:state,layerId:layerId,droppedItem:droppedItem}){const layer=state.layers[layerId];const op={...layer.columns[droppedItem.columnId]};const newColumns={...layer.columns,[columnId]:op};const newColumnOrder=[...layer.columnOrder];const insertionIndex=op.isBucketed?newColumnOrder.findIndex(id=>!newColumns[id].isBucketed):newColumnOrder.length;newColumnOrder.splice(insertionIndex,0,columnId);setState(mergeLayer({state:state,layerId:layerId,newLayer:{columnOrder:newColumnOrder,columns:newColumns}}));return true}function onMoveDropToCompatibleGroup({columnId:columnId,setState:setState,state:state,layerId:layerId,droppedItem:droppedItem}){const layer=state.layers[layerId];const op={...layer.columns[droppedItem.columnId]};const newColumns={...layer.columns};delete newColumns[droppedItem.columnId];newColumns[columnId]=op;const newColumnOrder=[...layer.columnOrder];const oldIndex=newColumnOrder.findIndex(c=>c===droppedItem.columnId);const newIndex=newColumnOrder.findIndex(c=>c===columnId);if(newIndex===-1){newColumnOrder[oldIndex]=columnId}else{newColumnOrder.splice(oldIndex,1)}setState(mergeLayer({state:state,layerId:layerId,newLayer:{columnOrder:newColumnOrder,columns:newColumns}}));return{deleted:droppedItem.columnId}}function onFieldDrop(props){const{columnId:columnId,setState:setState,state:state,layerId:layerId,droppedItem:droppedItem}=props;const operationsForNewField=getOperationTypesForField(droppedItem.field,props.filterOperations);if(!isDraggedField(droppedItem)||!operationsForNewField.length){return false}const layer=state.layers[layerId];const selectedColumn=layer.columns[columnId]||null;const currentIndexPattern=state.indexPatterns[layer.indexPatternId];const fieldIsCompatibleWithCurrent=selectedColumn&&operationsForNewField.includes(selectedColumn.operationType);const newLayer=insertOrReplaceColumn({layer:layer,columnId:columnId,indexPattern:currentIndexPattern,op:fieldIsCompatibleWithCurrent?selectedColumn.operationType:operationsForNewField[0],field:droppedItem.field});Object(lens_ui_telemetry["e"])("drop_onto_dimension");const hasData=Object.values(state.layers).some(({columns:columns})=>columns.length);Object(lens_ui_telemetry["e"])(hasData?"drop_non_empty":"drop_empty");setState(mergeLayer({state:state,layerId:layerId,newLayer:newLayer}));return true}var datapanel=__webpack_require__(45);var drag_drop=__webpack_require__(37);function Loader(props){const[isProcessing,setIsProcessing]=Object(external_kbnSharedDeps_React_["useState"])(false);const prevRequest=Object(external_kbnSharedDeps_React_["useRef"])(undefined);const nextRequest=Object(external_kbnSharedDeps_React_["useRef"])(undefined);Object(external_kbnSharedDeps_React_["useEffect"])((function performLoad(){if(prevRequest.current){nextRequest.current=performLoad;return}setIsProcessing(true);prevRequest.current=props.load().catch(()=>{}).then(()=>{const reload=nextRequest.current;prevRequest.current=undefined;nextRequest.current=undefined;if(reload){reload()}else{setIsProcessing(false)}})}),props.loadDeps);if(!isProcessing){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{size:"xs",color:"accent",position:"absolute"})}function change_indexpattern_extends(){change_indexpattern_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return change_indexpattern_extends.apply(this,arguments)}function ChangeIndexPattern({indexPatternRefs:indexPatternRefs,indexPatternId:indexPatternId,onChangeIndexPattern:onChangeIndexPattern,trigger:trigger,selectableProps:selectableProps}){const[isPopoverOpen,setPopoverIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const createTrigger=function(){const{label:label,title:title,...rest}=trigger;return external_kbnSharedDeps_React_default.a.createElement(public_["ToolbarButton"],change_indexpattern_extends({title:title,onClick:()=>setPopoverIsOpen(!isPopoverOpen),fullWidth:true},rest),label)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{style:{width:"100%"},button:createTrigger(),isOpen:isPopoverOpen,closePopover:()=>setPopoverIsOpen(false),display:"block",panelPaddingSize:"s",ownFocus:true},external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:320},"data-test-subj":"lnsChangeIndexPatternPopup"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.changeIndexPatternTitle",{defaultMessage:"Change index pattern"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],change_indexpattern_extends({},selectableProps,{searchable:true,singleSelection:"always",options:indexPatternRefs.map(({title:title,id:id})=>({key:id,label:title,value:id,checked:id===indexPatternId?"on":undefined})),onChange:choices=>{const choice=choices.find(({checked:checked})=>checked);Object(lens_ui_telemetry["e"])("indexpattern_changed");onChangeIndexPattern(choice.value);setPopoverIsOpen(false)},searchProps:{compressed:true,...selectableProps?selectableProps.searchProps:undefined}}),(list,search)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,search,list)))))}var field_list=__webpack_require__(197);var field_item=__webpack_require__(206);var elastic_datemath=__webpack_require__(215);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);function debouncedComponent(component,delay=256){const MemoizedComponent=Object(external_kbnSharedDeps_React_["memo"])(component);return props=>{const[cachedProps,setCachedProps]=Object(external_kbnSharedDeps_React_["useState"])(props);const debouncePropsChange=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_Lodash_["debounce"])(setCachedProps,delay),[setCachedProps]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>()=>debouncePropsChange.cancel(),[debouncePropsChange]);debouncePropsChange(props);return external_kbnSharedDeps_React_default.a.createElement(MemoizedComponent,cachedProps)}}function field_item_extends(){field_item_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return field_item_extends.apply(this,arguments)}function field_item_wrapOnDot(str){return str?str.replace(/\./g,".​"):""}const field_item_InnerFieldItem=function InnerFieldItem(props){const{core:core,field:field,indexPattern:indexPattern,highlight:highlight,exists:exists,query:query,dateRange:dateRange,filters:filters,hideDetails:hideDetails,itemIndex:itemIndex,groupIndex:groupIndex,dropOntoWorkspace:dropOntoWorkspace}=props;const[infoIsOpen,setOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const dropOntoWorkspaceAndClose=Object(external_kbnSharedDeps_React_["useCallback"])(droppedField=>{dropOntoWorkspace(droppedField);setOpen(false)},[dropOntoWorkspace,setOpen]);const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])({isLoading:false});function fetchData(){if(state.isLoading||field.type==="document"){return}setState(s=>({...s,isLoading:true}));core.http.post(`/api/lens/index_stats/${indexPattern.title}/field`,{body:JSON.stringify({dslQuery:data_public_["esQuery"].buildEsQuery(indexPattern,query,filters,data_public_["esQuery"].getEsQueryConfig(core.uiSettings)),fromDate:dateRange.fromDate,toDate:dateRange.toDate,timeFieldName:indexPattern.timeFieldName,field:field})}).then(results=>{setState(s=>({...s,isLoading:false,totalDocuments:results.totalDocuments,sampledDocuments:results.sampledDocuments,sampledValues:results.sampledValues,histogram:results.histogram,topValues:results.topValues}))}).catch(()=>{setState(s=>({...s,isLoading:false}))})}function togglePopover(){setOpen(!infoIsOpen);if(!infoIsOpen){Object(lens_ui_telemetry["e"])("indexpattern_field_info_click");fetchData()}}const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({field:field,indexPatternId:indexPattern.id,id:field.name,humanData:{label:field.displayName,position:itemIndex+1}}),[field,indexPattern.id,itemIndex]);const order=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[0,groupIndex,itemIndex],[groupIndex,itemIndex]);const lensFieldIcon=external_kbnSharedDeps_React_default.a.createElement(LensFieldIcon,{type:field.type});const lensInfoIcon=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{anchorClassName:"lnsFieldItem__infoIcon",content:hideDetails?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldItemTooltip",{defaultMessage:"Drag and drop to visualize."}):exists?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldStatsButtonLabel",{defaultMessage:"Click for a field preview, or drag and drop to visualize."}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldStatsButtonEmptyLabel",{defaultMessage:"This field doesn’t have any data but you can still drag and drop to visualize."}),type:"iInCircle",color:"subdued",size:"s"});return external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:true,className:"lnsFieldItem__popoverAnchor",display:"block","data-test-subj":"lnsFieldListPanelField",container:document.querySelector(".application")||undefined,button:external_kbnSharedDeps_React_default.a.createElement(drag_drop["DragDrop"],{draggable:true,order:order,value:value,dataTestSubj:`lnsFieldListPanelField-${field.name}`},external_kbnSharedDeps_React_default.a.createElement(public_["FieldButton"],{className:`lnsFieldItem lnsFieldItem--${field.type} lnsFieldItem--${exists?"exists":"missing"}`,isActive:infoIsOpen,onClick:togglePopover,buttonProps:{["aria-label"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldStatsButtonAriaLabel",{defaultMessage:"Preview {fieldName}: {fieldType}",values:{fieldName:field.displayName,fieldType:field.type}})},fieldIcon:lensFieldIcon,fieldName:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHighlight"],{search:field_item_wrapOnDot(highlight)},field_item_wrapOnDot(field.displayName)),fieldInfoIcon:lensInfoIcon})),isOpen:infoIsOpen,closePopover:()=>setOpen(false),anchorPosition:"rightUp",panelClassName:"lnsFieldItem__fieldPanel",initialFocus:".lnsFieldItem__fieldPanel"},external_kbnSharedDeps_React_default.a.createElement(FieldItemPopoverContents,field_item_extends({},state,props,{dropOntoWorkspace:dropOntoWorkspaceAndClose}))))};const FieldItem=debouncedComponent(field_item_InnerFieldItem);function FieldPanelHeader({indexPatternId:indexPatternId,field:field,hasSuggestionForField:hasSuggestionForField,dropOntoWorkspace:dropOntoWorkspace}){const draggableField={indexPatternId:indexPatternId,id:field.name,field:field,humanData:{label:field.displayName}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxs"},external_kbnSharedDeps_React_default.a.createElement("h5",{className:"eui-textBreakWord lnsFieldItem__fieldPanelTitle"},field.displayName))),external_kbnSharedDeps_React_default.a.createElement(DragToWorkspaceButton,{isEnabled:hasSuggestionForField(draggableField),dropOntoWorkspace:dropOntoWorkspace,field:draggableField}))}function FieldItemPopoverContents(props){const{histogram:histogram,topValues:topValues,indexPattern:indexPattern,field:field,dateRange:dateRange,core:core,sampledValues:sampledValues,chartsThemeService:chartsThemeService,data:{fieldFormats:fieldFormats},dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField,hideDetails:hideDetails}=props;const chartTheme=chartsThemeService.useChartsTheme();const chartBaseTheme=chartsThemeService.useChartsBaseTheme();let histogramDefault=!!props.histogram;const totalValuesCount=topValues&&topValues.buckets.reduce((prev,bucket)=>bucket.count+prev,0);const otherCount=sampledValues&&totalValuesCount?sampledValues-totalValuesCount:0;if(totalValuesCount&&histogram&&histogram.buckets.length&&topValues&&topValues.buckets.length){histogramDefault=otherCount/totalValuesCount>.9}const[showingHistogram,setShowingHistogram]=Object(external_kbnSharedDeps_React_["useState"])(histogramDefault);const panelHeader=external_kbnSharedDeps_React_default.a.createElement(FieldPanelHeader,{indexPatternId:indexPattern.id,field:field,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField});if(hideDetails){return panelHeader}let formatter;if(indexPattern.fieldFormatMap&&indexPattern.fieldFormatMap[field.name]){const FormatType=fieldFormats.getType(indexPattern.fieldFormatMap[field.name].id);if(FormatType){formatter=new FormatType(indexPattern.fieldFormatMap[field.name].params,core.uiSettings.get.bind(core.uiSettings))}else{formatter={convert:data=>JSON.stringify(data)}}}else{formatter=fieldFormats.getDefaultInstance(field.type,field.esTypes)}const fromDate=elastic_datemath_default.a.parse(dateRange.fromDate);const toDate=elastic_datemath_default.a.parse(dateRange.toDate);let title=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null);if(props.isLoading){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],null)}else if((!props.histogram||props.histogram.buckets.length===0)&&(!props.topValues||props.topValues.buckets.length===0)){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,panelHeader),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldStatsNoData",{defaultMessage:"This field is empty because it doesn’t exist in the 500 sampled documents. Adding this field to the configuration may result in a blank chart."})))}if(histogram&&histogram.buckets.length&&topValues&&topValues.buckets.length){title=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{className:"lnsFieldItem__buttonGroup",buttonSize:"compressed",isFullWidth:true,legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldStatsDisplayToggle",{defaultMessage:"Toggle either the"}),options:[{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldTopValuesLabel",{defaultMessage:"Top values"}),id:"topValues"},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldDistributionLabel",{defaultMessage:"Distribution"}),id:"histogram"}],onChange:optionId=>{setShowingHistogram(optionId==="histogram")},idSelected:showingHistogram?"histogram":"topValues"})}else if(field.type==="date"){title=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxxs"},external_kbnSharedDeps_React_default.a.createElement("h6",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldTimeDistributionLabel",{defaultMessage:"Time distribution"})))}else if(topValues&&topValues.buckets.length){title=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xxxs"},external_kbnSharedDeps_React_default.a.createElement("h6",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldTopValuesLabel",{defaultMessage:"Top values"})))}function wrapInPopover(el){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,panelHeader),title?title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),el,props.totalDocuments?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},props.sampledDocuments&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.percentageOfLabel",{defaultMessage:"{percentage}% of",values:{percentage:Math.round(props.sampledDocuments/props.totalDocuments*100)}}))," ",external_kbnSharedDeps_React_default.a.createElement("strong",null,fieldFormats.getDefaultInstance(data_public_["KBN_FIELD_TYPES"].NUMBER,[data_public_["ES_FIELD_TYPES"].INTEGER]).convert(props.totalDocuments))," ",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.ofDocumentsLabel",{defaultMessage:"documents"}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null))}if(histogram&&histogram.buckets.length){const specId=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldStatsCountLabel",{defaultMessage:"Count"});if(field.type==="date"){return wrapInPopover(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{"data-test-subj":"lnsFieldListPanel-histogram",size:{height:200,width:300-32}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{tooltip:{type:external_kbnSharedDeps_ElasticCharts_["TooltipType"].None},theme:chartTheme,baseTheme:chartBaseTheme,xDomain:fromDate&&toDate?{min:fromDate.valueOf(),max:toDate.valueOf(),minInterval:Math.round((toDate.valueOf()-fromDate.valueOf())/10)}:undefined}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"key",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,tickFormat:fromDate&&toDate?Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])([fromDate.valueOf(),toDate.valueOf()]):undefined,showOverlappingTicks:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{data:histogram.buckets,id:specId,xAccessor:"key",yAccessors:["count"],xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Time,yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,timeZone:"local"})))}else if(showingHistogram||!topValues||!topValues.buckets.length){return wrapInPopover(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{"data-test-subj":"lnsFieldListPanel-histogram",size:{height:200,width:"100%"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{rotation:90,tooltip:{type:external_kbnSharedDeps_ElasticCharts_["TooltipType"].None},theme:chartTheme,baseTheme:chartBaseTheme}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"key",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,showOverlappingTicks:true,tickFormat:d=>formatter.convert(d)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{data:histogram.buckets,id:specId,xAccessor:"key",yAccessors:["count"],xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear})))}}if(props.topValues&&props.topValues.buckets.length){const digitsRequired=props.topValues.buckets.some(topValue=>!Number.isInteger(topValue.count/props.sampledValues));return wrapInPopover(external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"lnsFieldListPanel-topValues"},props.topValues.buckets.map(topValue=>{const formatted=formatter.convert(topValue.key);return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsFieldItem__topValue",key:topValue.key},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"stretch",key:topValue.key,gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true,className:"eui-textTruncate"},formatted===""?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("em",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.fieldPanelEmptyStringValue",{defaultMessage:"Empty string"}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:formatted,delay:"long"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued",className:"eui-textTruncate"},formatted))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",textAlign:"left",color:"accent"},(Math.round(topValue.count/props.sampledValues*1e3)/10).toFixed(digitsRequired?1:0),"%"))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{className:"lnsFieldItem__topValueProgress",value:topValue.count/props.sampledValues,max:1,size:"s",color:"accent"}))}),otherCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"stretch",gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true,className:"eui-textTruncate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",className:"eui-textTruncate",color:"subdued"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.otherDocsLabel",{defaultMessage:"Other"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textTruncate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},(Math.round(otherCount/props.sampledValues*1e3)/10).toFixed(digitsRequired?1:0),"%"))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{className:"lnsFieldItem__topValueProgress",value:otherCount/props.sampledValues,max:1,size:"s",color:"subdued"})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null)))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null)}const DragToWorkspaceButton=({field:field,dropOntoWorkspace:dropOntoWorkspace,isEnabled:isEnabled})=>{const buttonTitle=isEnabled?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.moveToWorkspace",{defaultMessage:"Add {field} to workspace",values:{field:field.field.name}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.moveToWorkspaceDisabled",{defaultMessage:"This field can't be added to the workspace automatically. You can still use it directly in the configuration panel."});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:buttonTitle},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":buttonTitle,isDisabled:!isEnabled,iconType:"plusInCircle",onClick:()=>{dropOntoWorkspace(field)}})))};const defaultNoFieldsMessageCopy=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noDataLabel",{defaultMessage:"There are no fields."});const NoFieldsCallout=({existFieldsInIndex:existFieldsInIndex,defaultNoFieldsMessage:defaultNoFieldsMessage=defaultNoFieldsMessageCopy,isAffectedByFieldFilter:isAffectedByFieldFilter=false,isAffectedByTimerange:isAffectedByTimerange=false,isAffectedByGlobalFilter:isAffectedByGlobalFilter=false})=>{if(!existFieldsInIndex){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",color:"warning",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noFieldsLabel",{defaultMessage:"No fields exist in this index pattern."})})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",color:"warning",title:isAffectedByFieldFilter?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noFilteredFieldsLabel",{defaultMessage:"No fields match the selected filters."}):defaultNoFieldsMessage},(isAffectedByTimerange||isAffectedByFieldFilter||isAffectedByGlobalFilter)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noFields.tryText",{defaultMessage:"Try:"})),external_kbnSharedDeps_React_default.a.createElement("ul",null,isAffectedByTimerange&&external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noFields.extendTimeBullet",{defaultMessage:"Extending the time range"})),isAffectedByFieldFilter&&external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noFields.fieldTypeFilterBullet",{defaultMessage:"Using different field filters"})),isAffectedByGlobalFilter&&external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noFields.globalFiltersBullet",{defaultMessage:"Changing the global filters"})))))};function fields_accordion_extends(){fields_accordion_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return fields_accordion_extends.apply(this,arguments)}const FieldsAccordion=Object(external_kbnSharedDeps_React_["memo"])((function InnerFieldsAccordion({initialIsOpen:initialIsOpen,onToggle:onToggle,id:id,label:label,helpTooltip:helpTooltip,hasLoaded:hasLoaded,fieldsCount:fieldsCount,isFiltered:isFiltered,paginatedFields:paginatedFields,fieldProps:fieldProps,renderCallout:renderCallout,exists:exists,hideDetails:hideDetails,showExistenceFetchError:showExistenceFetchError,groupIndex:groupIndex,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}){const renderField=Object(external_kbnSharedDeps_React_["useCallback"])((field,index)=>external_kbnSharedDeps_React_default.a.createElement(FieldItem,fields_accordion_extends({},fieldProps,{key:field.name,field:field,exists:exists(field),hideDetails:hideDetails,itemIndex:index,groupIndex:groupIndex,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField})),[fieldProps,exists,hideDetails,dropOntoWorkspace,hasSuggestionForField,groupIndex]);const renderButton=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const titleClassname=classnames_default()({lnsInnerIndexPatternDataPanel__titleTooltip:!!helpTooltip});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("strong",{className:titleClassname},label),!!helpTooltip&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{"aria-label":helpTooltip,type:"questionInCircle",color:"subdued",size:"s",position:"right",content:helpTooltip,iconProps:{className:"eui-alignTop"}}))},[label,helpTooltip]);const extraAction=Object(external_kbnSharedDeps_React_["useMemo"])(()=>showExistenceFetchError?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.existenceErrorAriaLabel",{defaultMessage:"Existence fetch failed"}),type:"alert",color:"warning",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.existenceErrorLabel",{defaultMessage:"Field information can't be loaded"})}):hasLoaded?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiNotificationBadge"],{size:"m",color:isFiltered?"accent":"subdued"},fieldsCount):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"m"}),[showExistenceFetchError,hasLoaded,isFiltered,fieldsCount]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAccordion"],{initialIsOpen:initialIsOpen,onToggle:onToggle,"data-test-subj":id,id:id,buttonContent:renderButton,extraAction:extraAction},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),hasLoaded&&(!!fieldsCount?external_kbnSharedDeps_React_default.a.createElement("ul",{className:"lnsInnerIndexPatternDataPanel__fieldItems"},paginatedFields&&paginatedFields.map(renderField)):renderCallout))}));function field_list_extends(){field_list_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return field_list_extends.apply(this,arguments)}const PAGINATION_SIZE=50;function getDisplayedFieldsLength(fieldGroups,accordionState){return Object.entries(fieldGroups).filter(([key])=>accordionState[key]).reduce((allFieldCount,[,{fields:fields}])=>allFieldCount+fields.length,0)}const field_list_FieldList=external_kbnSharedDeps_React_default.a.memo((function FieldList({exists:exists,fieldGroups:fieldGroups,existenceFetchFailed:existenceFetchFailed,fieldProps:fieldProps,hasSyncedExistingFields:hasSyncedExistingFields,filter:filter,currentIndexPatternId:currentIndexPatternId,existFieldsInIndex:existFieldsInIndex,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}){const[pageSize,setPageSize]=Object(external_kbnSharedDeps_React_["useState"])(PAGINATION_SIZE);const[scrollContainer,setScrollContainer]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[accordionState,setAccordionState]=Object(external_kbnSharedDeps_React_["useState"])(()=>Object.fromEntries(Object.entries(fieldGroups).filter(([,{showInAccordion:showInAccordion}])=>showInAccordion).map(([key,{isInitiallyOpen:isInitiallyOpen}])=>[key,isInitiallyOpen])));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(scrollContainer){scrollContainer.scrollTop=0;setPageSize(PAGINATION_SIZE)}},[filter.nameFilter,filter.typeFilter,currentIndexPatternId,scrollContainer]);const lazyScroll=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(scrollContainer){const nearBottom=scrollContainer.scrollTop+scrollContainer.clientHeight>scrollContainer.scrollHeight*.9;if(nearBottom){setPageSize(Math.max(PAGINATION_SIZE,Math.min(pageSize+PAGINATION_SIZE*.5,getDisplayedFieldsLength(fieldGroups,accordionState))))}}},[scrollContainer,pageSize,setPageSize,fieldGroups,accordionState]);const paginatedFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{let remainingItems=pageSize;return Object.fromEntries(Object.entries(fieldGroups).filter(([,{showInAccordion:showInAccordion}])=>showInAccordion).map(([key,fieldGroup])=>{if(!accordionState[key]||remainingItems<=0){return[key,[]]}const slicedFieldList=fieldGroup.fields.slice(0,remainingItems);remainingItems=remainingItems-slicedFieldList.length;return[key,slicedFieldList]}))},[pageSize,fieldGroups,accordionState]);return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsIndexPatternFieldList",ref:el=>{if(el&&!el.dataset.dynamicScroll){el.dataset.dynamicScroll="true";setScrollContainer(el)}},onScroll:Object(external_kbnSharedDeps_Lodash_["throttle"])(lazyScroll,100)},external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsIndexPatternFieldList__accordionContainer"},external_kbnSharedDeps_React_default.a.createElement("ul",null,Object.entries(fieldGroups).filter(([,{showInAccordion:showInAccordion}])=>!showInAccordion).flatMap(([,{fields:fields}])=>fields.map((field,index)=>external_kbnSharedDeps_React_default.a.createElement(FieldItem,field_list_extends({},fieldProps,{exists:exists(field),field:field,hideDetails:true,key:field.name,itemIndex:index,groupIndex:0,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),Object.entries(fieldGroups).filter(([,{showInAccordion:showInAccordion}])=>showInAccordion).map(([key,fieldGroup],index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:key},external_kbnSharedDeps_React_default.a.createElement(FieldsAccordion,{dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField,initialIsOpen:Boolean(accordionState[key]),key:key,id:`lnsIndexPattern${key}`,label:fieldGroup.title,helpTooltip:fieldGroup.helpText,exists:exists,hideDetails:fieldGroup.hideDetails,hasLoaded:!!hasSyncedExistingFields,fieldsCount:fieldGroup.fields.length,isFiltered:fieldGroup.fieldCount!==fieldGroup.fields.length,paginatedFields:paginatedFields[key],fieldProps:fieldProps,groupIndex:index+1,onToggle:open=>{setAccordionState(s=>({...s,[key]:open}));const displayedFieldLength=getDisplayedFieldsLength(fieldGroups,{...accordionState,[key]:open});setPageSize(Math.max(PAGINATION_SIZE,Math.min(pageSize*1.5,displayedFieldLength)))},showExistenceFetchError:existenceFetchFailed,renderCallout:external_kbnSharedDeps_React_default.a.createElement(NoFieldsCallout,{isAffectedByGlobalFilter:fieldGroup.isAffectedByGlobalFilter,isAffectedByTimerange:fieldGroup.isAffectedByTimeFilter,isAffectedByFieldFilter:fieldGroup.fieldCount!==fieldGroup.fields.length,existFieldsInIndex:!!existFieldsInIndex,defaultNoFieldsMessage:fieldGroup.defaultNoFieldsMessage})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})))))}));function sortFields(fieldA,fieldB){return fieldA.displayName.localeCompare(fieldB.displayName,undefined,{sensitivity:"base"})}const datapanel_supportedFieldTypes=new Set(["string","number","boolean","date","ip","histogram","document"]);const fieldTypeNames={document:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.record",{defaultMessage:"record"}),string:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.string",{defaultMessage:"string"}),number:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.number",{defaultMessage:"number"}),boolean:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.boolean",{defaultMessage:"boolean"}),date:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.date",{defaultMessage:"date"}),ip:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.ipAddress",{defaultMessage:"IP"}),histogram:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.datatypes.histogram",{defaultMessage:"histogram"})};function buildSafeEsQuery(indexPattern,query,filters,queryConfig){try{return data_public_["esQuery"].buildEsQuery(indexPattern,query,filters,queryConfig)}catch(e){return{bool:{must_not:{match_all:{}}}}}}function IndexPatternDataPanel({setState:setState,state:state,dragDropContext:dragDropContext,core:core,data:data,query:query,filters:filters,dateRange:dateRange,changeIndexPattern:changeIndexPattern,charts:charts,showNoDataPopover:showNoDataPopover,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}){const{indexPatternRefs:indexPatternRefs,indexPatterns:indexPatterns,currentIndexPatternId:currentIndexPatternId}=state;const onChangeIndexPattern=Object(external_kbnSharedDeps_React_["useCallback"])(id=>changeIndexPattern(id,state,setState),[state,setState,changeIndexPattern]);const indexPatternList=Object(external_kbnSharedDeps_Lodash_["uniq"])(Object.values(state.layers).map(l=>l.indexPatternId).concat(currentIndexPatternId)).sort((a,b)=>a.localeCompare(b)).filter(id=>!!indexPatterns[id]).map(id=>({id:id,title:indexPatterns[id].title,timeFieldName:indexPatterns[id].timeFieldName,fields:indexPatterns[id].fields,hasRestrictions:indexPatterns[id].hasRestrictions}));const dslQuery=buildSafeEsQuery(indexPatterns[currentIndexPatternId],query,filters,data_public_["esQuery"].getEsQueryConfig(core.uiSettings));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Loader,{load:()=>syncExistingFields({dateRange:dateRange,setState:setState,isFirstExistenceFetch:state.isFirstExistenceFetch,currentIndexPatternTitle:indexPatterns[currentIndexPatternId].title,showNoDataPopover:showNoDataPopover,indexPatterns:indexPatternList,fetchJson:core.http.post,dslQuery:dslQuery}),loadDeps:[query,filters,dateRange.fromDate,dateRange.toDate,indexPatternList.map(x=>`${x.title}:${x.timeFieldName}`).join(",")]}),Object.keys(indexPatterns).length===0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",className:"lnsInnerIndexPatternDataPanel",direction:"column",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:null},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{"data-test-subj":"indexPattern-no-indexpatterns",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.noPatternsLabel",{defaultMessage:"No index patterns"}),color:"warning",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.indexPattern.noPatternsDescription",defaultMessage:"Please create an index pattern or switch to another data source"}))))):external_kbnSharedDeps_React_default.a.createElement(MemoizedDataPanel,{currentIndexPatternId:currentIndexPatternId,indexPatternRefs:indexPatternRefs,indexPatterns:indexPatterns,query:query,dateRange:dateRange,filters:filters,dragDropContext:dragDropContext,core:core,data:data,charts:charts,onChangeIndexPattern:onChangeIndexPattern,existingFields:state.existingFields,existenceFetchFailed:state.existenceFetchFailed,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}))}const defaultFieldGroups={specialFields:[],availableFields:[],emptyFields:[],metaFields:[]};const fieldFiltersLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.fieldFiltersLabel",{defaultMessage:"Field filters"});const htmlId=Object(external_kbnSharedDeps_ElasticEui_["htmlIdGenerator"])("datapanel");const fieldSearchDescriptionId=htmlId();const datapanel_InnerIndexPatternDataPanel=function InnerIndexPatternDataPanel({currentIndexPatternId:currentIndexPatternId,indexPatternRefs:indexPatternRefs,indexPatterns:indexPatterns,existenceFetchFailed:existenceFetchFailed,query:query,dateRange:dateRange,filters:filters,dragDropContext:dragDropContext,onChangeIndexPattern:onChangeIndexPattern,core:core,data:data,existingFields:existingFields,charts:charts,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}){var _fieldGroups$EmptyFie;const[localState,setLocalState]=Object(external_kbnSharedDeps_React_["useState"])({nameFilter:"",typeFilter:[],isTypeFilterOpen:false,isAvailableAccordionOpen:true,isEmptyAccordionOpen:false,isMetaAccordionOpen:false});const currentIndexPattern=indexPatterns[currentIndexPatternId];const allFields=currentIndexPattern.fields;const clearLocalState=()=>setLocalState(s=>({...s,nameFilter:"",typeFilter:[]}));const hasSyncedExistingFields=existingFields[currentIndexPattern.title];const availableFieldTypes=Object(external_kbnSharedDeps_Lodash_["uniq"])(allFields.map(({type:type})=>type)).filter(type=>type in fieldTypeNames);const fieldInfoUnavailable=existenceFetchFailed||currentIndexPattern.hasRestrictions;const unfilteredFieldGroups=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const containsData=field=>{const overallField=currentIndexPattern.getFieldByName(field.name);return overallField&&fieldExists(existingFields,currentIndexPattern.title,overallField.name)};const allSupportedTypesFields=allFields.filter(field=>datapanel_supportedFieldTypes.has(field.type));const sorted=allSupportedTypesFields.sort(sortFields);let groupedFields;if(!hasSyncedExistingFields){groupedFields={...defaultFieldGroups,...Object(external_kbnSharedDeps_Lodash_["groupBy"])(sorted,field=>{if(field.type==="document"){return"specialFields"}else if(field.meta){return"metaFields"}else{return"emptyFields"}})}}groupedFields={...defaultFieldGroups,...Object(external_kbnSharedDeps_Lodash_["groupBy"])(sorted,field=>{if(field.type==="document"){return"specialFields"}else if(field.meta){return"metaFields"}else if(containsData(field)){return"availableFields"}else return"emptyFields"})};const fieldGroupDefinitions={SpecialFields:{fields:groupedFields.specialFields,fieldCount:1,isAffectedByGlobalFilter:false,isAffectedByTimeFilter:false,isInitiallyOpen:false,showInAccordion:false,title:"",hideDetails:true},AvailableFields:{fields:groupedFields.availableFields,fieldCount:groupedFields.availableFields.length,isInitiallyOpen:true,showInAccordion:true,title:fieldInfoUnavailable?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.allFieldsLabel",{defaultMessage:"All fields"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.availableFieldsLabel",{defaultMessage:"Available fields"}),helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.allFieldsLabelHelp",{defaultMessage:"Available fields have data in the first 500 documents that match your filters. To view all fields, expand Empty fields. Some field types cannot be visualized in Lens, including full text and geographic fields."}),isAffectedByGlobalFilter:!!filters.length,isAffectedByTimeFilter:true,hideDetails:fieldInfoUnavailable,defaultNoFieldsMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noAvailableDataLabel",{defaultMessage:`There are no available fields that contain data.`})},EmptyFields:{fields:groupedFields.emptyFields,fieldCount:groupedFields.emptyFields.length,isAffectedByGlobalFilter:false,isAffectedByTimeFilter:false,isInitiallyOpen:false,showInAccordion:true,hideDetails:false,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.emptyFieldsLabel",{defaultMessage:"Empty fields"}),defaultNoFieldsMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noEmptyDataLabel",{defaultMessage:`There are no empty fields.`}),helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.emptyFieldsLabelHelp",{defaultMessage:"Empty fields did not contain any values in the first 500 documents based on your filters."})},MetaFields:{fields:groupedFields.metaFields,fieldCount:groupedFields.metaFields.length,isAffectedByGlobalFilter:false,isAffectedByTimeFilter:false,isInitiallyOpen:false,showInAccordion:true,hideDetails:false,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.metaFieldsLabel",{defaultMessage:"Meta fields"}),defaultNoFieldsMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.noMetaDataLabel",{defaultMessage:`There are no meta fields.`})}};if(fieldInfoUnavailable){delete fieldGroupDefinitions.EmptyFields}return fieldGroupDefinitions},[allFields,existingFields,currentIndexPattern,hasSyncedExistingFields,fieldInfoUnavailable,filters.length]);const fieldGroups=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const filterFieldGroup=fieldGroup=>fieldGroup.filter(field=>{if(localState.nameFilter.length&&!field.name.toLowerCase().includes(localState.nameFilter.toLowerCase())&&!field.displayName.toLowerCase().includes(localState.nameFilter.toLowerCase())){return false}if(localState.typeFilter.length>0){return localState.typeFilter.includes(field.type)}return true});return Object.fromEntries(Object.entries(unfilteredFieldGroups).map(([name,group])=>[name,{...group,fields:filterFieldGroup(group.fields)}]))},[unfilteredFieldGroups,localState.nameFilter,localState.typeFilter]);const checkFieldExists=Object(external_kbnSharedDeps_React_["useCallback"])(field=>field.type==="document"||fieldExists(existingFields,currentIndexPattern.title,field.name),[existingFields,currentIndexPattern.title]);const{nameFilter:nameFilter,typeFilter:typeFilter}=localState;const filter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({nameFilter:nameFilter,typeFilter:typeFilter}),[nameFilter,typeFilter]);const fieldProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({core:core,data:data,indexPattern:currentIndexPattern,highlight:localState.nameFilter.toLowerCase(),dateRange:dateRange,query:query,filters:filters,chartsThemeService:charts.theme}),[core,data,currentIndexPattern,dateRange,query,filters,localState.nameFilter,charts.theme]);return external_kbnSharedDeps_React_default.a.createElement(drag_drop["ChildDragDropProvider"],dragDropContext,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",className:"lnsInnerIndexPatternDataPanel",direction:"column",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsInnerIndexPatternDataPanel__header"},external_kbnSharedDeps_React_default.a.createElement(ChangeIndexPattern,{"data-test-subj":"indexPattern-switcher",trigger:{label:currentIndexPattern.title,title:currentIndexPattern.title,"data-test-subj":"indexPattern-switch-link",fontWeight:"bold"},indexPatternId:currentIndexPatternId,indexPatternRefs:indexPatternRefs,onChangeIndexPattern:newId=>{onChangeIndexPattern(newId);clearLocalState()}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormControlLayout"],{icon:"search",fullWidth:true,clear:{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.clearFiltersLabel",{defaultMessage:"Clear name and type filters"}),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.clearFiltersLabel",{defaultMessage:"Clear name and type filters"}),onClick:()=>{Object(lens_ui_telemetry["e"])("indexpattern_filters_cleared");clearLocalState()}}},external_kbnSharedDeps_React_default.a.createElement("input",{className:"euiFieldText euiFieldText--fullWidth lnsInnerIndexPatternDataPanel__textField","data-test-subj":"lnsIndexPatternFieldSearch",placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.filterByNameLabel",{defaultMessage:"Search field names",description:"Search the list of fields in the index pattern for the provided text"}),value:localState.nameFilter,onChange:e=>{setLocalState({...localState,nameFilter:e.target.value})},"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.filterByNameLabel",{defaultMessage:"Search field names",description:"Search the list of fields in the index pattern for the provided text"}),"aria-describedby":fieldSearchDescriptionId})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"dataPanelTypeFilter",panelClassName:"euiFilterGroup__popoverPanel",panelPaddingSize:"none",anchorPosition:"rightUp",display:"block",isOpen:localState.isTypeFilterOpen,closePopover:()=>setLocalState(()=>({...localState,isTypeFilterOpen:false})),button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",isSelected:localState.isTypeFilterOpen,numFilters:localState.typeFilter.length,hasActiveFilters:!!localState.typeFilter.length,numActiveFilters:localState.typeFilter.length,"data-test-subj":"lnsIndexPatternFiltersToggle",onClick:()=>{setLocalState(s=>({...s,isTypeFilterOpen:!localState.isTypeFilterOpen}))}},fieldFiltersLabel)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{watchedItemProps:["icon","disabled"],"data-test-subj":"lnsIndexPatternTypeFilterOptions",items:availableFieldTypes.map(type=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{className:"lnsInnerIndexPatternDataPanel__filterType",key:type,icon:localState.typeFilter.includes(type)?"check":"empty","data-test-subj":`typeFilter-${type}`,onClick:()=>{Object(lens_ui_telemetry["e"])("indexpattern_type_filter_toggled");setLocalState(s=>({...s,typeFilter:localState.typeFilter.includes(type)?localState.typeFilter.filter(t=>t!==type):[...localState.typeFilter,type]}))}},external_kbnSharedDeps_React_default.a.createElement("span",{className:"lnsInnerIndexPatternDataPanel__filterTypeInner"},external_kbnSharedDeps_React_default.a.createElement(LensFieldIcon,{type:type})," ",fieldTypeNames[type])))})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("div",{"aria-live":"polite",id:fieldSearchDescriptionId},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatterns.fieldSearchLiveRegion",{defaultMessage:"{availableFields} available {availableFields, plural, one {field} other {fields}}. {emptyFields} empty {emptyFields, plural, one {field} other {fields}}. {metaFields} meta {metaFields, plural, one {field} other {fields}}.",values:{availableFields:fieldGroups.AvailableFields.fields.length,emptyFields:((_fieldGroups$EmptyFie=fieldGroups.EmptyFields)===null||_fieldGroups$EmptyFie===void 0?void 0:_fieldGroups$EmptyFie.fields.length)||0,metaFields:fieldGroups.MetaFields.fields.length}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(field_list_FieldList,{exists:checkFieldExists,fieldProps:fieldProps,fieldGroups:fieldGroups,hasSyncedExistingFields:!!hasSyncedExistingFields,filter:filter,currentIndexPatternId:currentIndexPatternId,existenceFetchFailed:existenceFetchFailed,existFieldsInIndex:!!allFields.length,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}))))};const MemoizedDataPanel=Object(external_kbnSharedDeps_React_["memo"])(datapanel_InnerIndexPatternDataPanel);function indexpattern_suggestions_buildSuggestion({state:state,updatedLayer:updatedLayer,layerId:layerId,label:label,changeType:changeType}){const updatedState=updatedLayer?{...state,layers:{...state.layers,[layerId]:updatedLayer}}:state;const layers=external_kbnSharedDeps_Lodash_default.a.mapValues(updatedState.layers,layer=>({...layer,columns:external_kbnSharedDeps_Lodash_default.a.pick(layer.columns,layer.columnOrder)}));const columnOrder=layers[layerId].columnOrder;const columnMap=layers[layerId].columns;const isMultiRow=Object.values(columnMap).some(column=>column.isBucketed);return{state:{...updatedState,layers:layers},table:{columns:columnOrder.filter(columnId=>!isReferenced(layers[layerId],columnId)).map(columnId=>({columnId:columnId,operation:columnToOperation(columnMap[columnId])})),isMultiRow:isMultiRow,layerId:layerId,changeType:changeType,label:label},keptLayerIds:Object.keys(state.layers)}}function getDatasourceSuggestionsForField(state,indexPatternId,field){const layers=Object.keys(state.layers);const layerIds=layers.filter(id=>state.layers[id].indexPatternId===indexPatternId);if(layerIds.length===0){const newId=generateId();return getEmptyLayerSuggestionsForField(state,newId,indexPatternId,field).concat(getEmptyLayerSuggestionsForField({...state,layers:{}},newId,indexPatternId,field))}else{const mostEmptyLayerId=external_kbnSharedDeps_Lodash_default.a.minBy(layerIds,layerId=>state.layers[layerId].columnOrder.length);if(state.layers[mostEmptyLayerId].columnOrder.length===0){return getEmptyLayerSuggestionsForField(state,mostEmptyLayerId,indexPatternId,field)}else{return getExistingLayerSuggestionsForField(state,mostEmptyLayerId,field)}}}function getDatasourceSuggestionsForVisualizeField(state,indexPatternId,fieldName){const layers=Object.keys(state.layers);const layerIds=layers.filter(id=>state.layers[id].indexPatternId===indexPatternId);const indexPattern=state.indexPatterns[indexPatternId];const field=indexPattern.getFieldByName(fieldName);if(layerIds.length!==0||!field)return[];const newId=generateId();return getEmptyLayerSuggestionsForField(state,newId,indexPatternId,field).concat(getEmptyLayerSuggestionsForField({...state,layers:{}},newId,indexPatternId,field))}function getBucketOperation(field){if(field.type!=="number"){return getOperationTypesForField(field).find(op=>op==="date_histogram"||op==="terms")}}function getExistingLayerSuggestionsForField(state,layerId,field){const layer=state.layers[layerId];const indexPattern=state.indexPatterns[layer.indexPatternId];const operations=getOperationTypesForField(field);const usableAsBucketOperation=getBucketOperation(field);const fieldInUse=Object.values(layer.columns).some(column=>hasField(column)&&column.sourceField===field.name);const suggestions=[];if(usableAsBucketOperation&&!fieldInUse){if(usableAsBucketOperation==="date_histogram"&&layer.columnOrder.some(colId=>layer.columns[colId].operationType==="date_histogram")){const previousDate=layer.columnOrder.find(colId=>layer.columns[colId].operationType==="date_histogram");suggestions.push(indexpattern_suggestions_buildSuggestion({state:state,updatedLayer:replaceColumn({layer:layer,indexPattern:indexPattern,field:field,op:usableAsBucketOperation,columnId:previousDate}),layerId:layerId,changeType:"initial"}))}else{suggestions.push(indexpattern_suggestions_buildSuggestion({state:state,updatedLayer:insertNewColumn({layer:layer,indexPattern:indexPattern,field:field,op:usableAsBucketOperation,columnId:generateId()}),layerId:layerId,changeType:"extended"}))}}if(!usableAsBucketOperation&&operations.length>0&&!fieldInUse){const[metricOperation]=getMetricOperationTypes(field);if(metricOperation){const layerWithNewMetric=insertNewColumn({layer:layer,indexPattern:indexPattern,field:field,columnId:generateId(),op:metricOperation.type});if(layerWithNewMetric){suggestions.push(indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,updatedLayer:layerWithNewMetric,changeType:"extended"}))}const[,metrics,references]=getExistingColumnGroups(layer);if(metrics.length===1&&references.length===0){const layerWithReplacedMetric=replaceColumn({layer:layer,indexPattern:indexPattern,field:field,columnId:metrics[0],op:metricOperation.type});if(layerWithReplacedMetric){suggestions.push(indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,updatedLayer:layerWithReplacedMetric,changeType:"extended"}))}}}}const metricSuggestion=createMetricSuggestion(indexPattern,layerId,state,field);if(metricSuggestion){suggestions.push(metricSuggestion)}return suggestions}function getEmptyLayerSuggestionsForField(state,layerId,indexPatternId,field){const indexPattern=state.indexPatterns[indexPatternId];let newLayer;const bucketOperation=getBucketOperation(field);if(bucketOperation){newLayer=createNewLayerWithBucketAggregation(indexPattern,field,bucketOperation)}else if(indexPattern.timeFieldName&&getOperationTypesForField(field).length>0){newLayer=createNewLayerWithMetricAggregation(indexPattern,field)}const newLayerSuggestions=newLayer?[indexpattern_suggestions_buildSuggestion({state:state,updatedLayer:newLayer,layerId:layerId,changeType:"initial"})]:[];const metricLayer=createMetricSuggestion(indexPattern,layerId,state,field);return metricLayer?newLayerSuggestions.concat(metricLayer):newLayerSuggestions}function createNewLayerWithBucketAggregation(indexPattern,field,operation){return insertNewColumn({op:operation,layer:insertNewColumn({op:"count",layer:{indexPatternId:indexPattern.id,columns:{},columnOrder:[]},columnId:generateId(),field:documentField,indexPattern:indexPattern}),columnId:generateId(),field:field,indexPattern:indexPattern})}function createNewLayerWithMetricAggregation(indexPattern,field){const dateField=indexPattern.getFieldByName(indexPattern.timeFieldName);const[metricOperation]=getMetricOperationTypes(field);if(!metricOperation){return}return insertNewColumn({op:"date_histogram",layer:insertNewColumn({op:metricOperation.type,layer:{indexPatternId:indexPattern.id,columns:{},columnOrder:[]},columnId:generateId(),field:field,indexPattern:indexPattern}),columnId:generateId(),field:dateField,indexPattern:indexPattern})}function getDatasourceSuggestionsFromCurrentState(state){const layers=Object.entries(state.layers||{});if(layers.length>1){return layers.map(([layerId,layer],index)=>{const hasMatchingLayer=layers.some(([otherLayerId,otherLayer])=>otherLayerId!==layerId&&otherLayer.indexPatternId===layer.indexPatternId);const suggestionTitle=hasMatchingLayer?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatternSuggestion.removeLayerPositionLabel",{defaultMessage:"Show only layer {layerNumber}",values:{layerNumber:index+1}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPatternSuggestion.removeLayerLabel",{defaultMessage:"Show only {indexPatternTitle}",values:{indexPatternTitle:state.indexPatterns[layer.indexPatternId].title}});return indexpattern_suggestions_buildSuggestion({state:{...state,layers:{[layerId]:layer}},layerId:layerId,changeType:"layers",label:suggestionTitle})}).concat([indexpattern_suggestions_buildSuggestion({state:state,layerId:layers[0][0],changeType:"unchanged"})])}return external_kbnSharedDeps_Lodash_default.a.flatten(Object.entries(state.layers||{}).filter(([_id,layer])=>layer.columnOrder.length&&layer.indexPatternId).map(([layerId,layer])=>{const indexPattern=state.indexPatterns[layer.indexPatternId];const[buckets,metrics,references]=getExistingColumnGroups(layer);const timeDimension=layer.columnOrder.find(columnId=>layer.columns[columnId].isBucketed&&layer.columns[columnId].dataType==="date");const timeField=indexPattern.timeFieldName&&indexPattern.getFieldByName(indexPattern.timeFieldName);const hasNumericDimension=buckets.length===1&&buckets.some(columnId=>layer.columns[columnId].dataType==="number");const suggestions=[];suggestions.push(indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,changeType:"unchanged"}));if(!references.length&&metrics.length&&buckets.length===0){if(timeField){suggestions.push(createSuggestionWithDefaultDateHistogram(state,layerId,timeField))}suggestions.push(...createAlternativeMetricSuggestions(indexPattern,layerId,state))}else{suggestions.push(...createSimplifiedTableSuggestions(state,layerId));if(!timeDimension&&timeField&&!hasNumericDimension){suggestions.push(createSuggestionWithDefaultDateHistogram(state,layerId,timeField))}if(buckets.length===2){suggestions.push(createChangedNestingSuggestion(state,layerId))}}return suggestions}))}function createChangedNestingSuggestion(state,layerId){var _indexPattern$getFiel,_indexPattern$getFiel2;const layer=state.layers[layerId];const[firstBucket,secondBucket,...rest]=layer.columnOrder;const updatedLayer={...layer,columnOrder:[secondBucket,firstBucket,...rest]};const indexPattern=state.indexPatterns[state.currentIndexPatternId];const firstBucketColumn=layer.columns[firstBucket];const firstBucketLabel=hasField(firstBucketColumn)&&((_indexPattern$getFiel=indexPattern.getFieldByName(firstBucketColumn.sourceField))===null||_indexPattern$getFiel===void 0?void 0:_indexPattern$getFiel.displayName)||"";const secondBucketColumn=layer.columns[secondBucket];const secondBucketLabel=hasField(secondBucketColumn)&&((_indexPattern$getFiel2=indexPattern.getFieldByName(secondBucketColumn.sourceField))===null||_indexPattern$getFiel2===void 0?void 0:_indexPattern$getFiel2.displayName)||"";return indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,updatedLayer:updatedLayer,label:getNestedTitle([secondBucketLabel,firstBucketLabel]),changeType:"reorder"})}function createMetricSuggestion(indexPattern,layerId,state,field){const[operation]=getMetricOperationTypes(field);if(!operation){return}return indexpattern_suggestions_buildSuggestion({layerId:layerId,state:state,changeType:"initial",updatedLayer:insertNewColumn({layer:{indexPatternId:indexPattern.id,columns:{},columnOrder:[]},columnId:generateId(),op:operation.type,field:operation.type==="count"?documentField:field,indexPattern:indexPattern})})}function getNestedTitle([outerBucketLabel,innerBucketLabel]){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexpattern.suggestions.nestingChangeLabel",{defaultMessage:"{innerOperation} for each {outerOperation}",values:{innerOperation:innerBucketLabel,outerOperation:outerBucketLabel}})}function createAlternativeMetricSuggestions(indexPattern,layerId,state){const layer=state.layers[layerId];const suggestions=[];layer.columnOrder.forEach(columnId=>{const column=layer.columns[columnId];if(!hasField(column)){return}const field=indexPattern.getFieldByName(column.sourceField);if(!field){return}const possibleOperations=getMetricOperationTypes(field).filter(({type:type})=>type!==column.operationType);if(possibleOperations.length){const layerWithNewMetric=replaceColumn({layer:layer,indexPattern:indexPattern,field:field,columnId:columnId,op:possibleOperations[0].type});if(layerWithNewMetric){suggestions.push(indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,updatedLayer:layerWithNewMetric,changeType:"initial"}))}}});return suggestions}function createSuggestionWithDefaultDateHistogram(state,layerId,timeField){const layer=state.layers[layerId];const indexPattern=state.indexPatterns[layer.indexPatternId];return indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,updatedLayer:insertNewColumn({layer:layer,indexPattern:indexPattern,field:timeField,op:"date_histogram",columnId:generateId()}),label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexpattern.suggestions.overTimeLabel",{defaultMessage:"Over time"}),changeType:"extended"})}function createSimplifiedTableSuggestions(state,layerId){const layer=state.layers[layerId];const[availableBucketedColumns,availableMetricColumns,availableReferenceColumns]=getExistingColumnGroups(layer);return external_kbnSharedDeps_Lodash_default.a.flatten(availableBucketedColumns.map((_col,index)=>{const bucketedColumns=availableBucketedColumns.slice(0,index+1);const allMetricsSuggestion={...layer,columnOrder:[...bucketedColumns,...availableMetricColumns]};if(availableBucketedColumns.length<=1||availableReferenceColumns.length){return[]}else if(availableMetricColumns.length>1){return[{...layer,columnOrder:[...bucketedColumns,availableMetricColumns[0]]}]}else{return allMetricsSuggestion}})).concat(availableReferenceColumns.length?[]:availableMetricColumns.map(columnId=>({...layer,columnOrder:[columnId]}))).map(updatedLayer=>indexpattern_suggestions_buildSuggestion({state:state,layerId:layerId,updatedLayer:updatedLayer,changeType:"reduced",label:updatedLayer.columnOrder.length===1?getMetricSuggestionTitle(updatedLayer,availableMetricColumns.length===1):undefined}))}function getMetricSuggestionTitle(layer,onlyMetric){const{operationType:operationType,label:label}=layer.columns[layer.columnOrder[0]];return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexpattern.suggestions.overallLabel",{defaultMessage:"{operation} overall",values:{operation:onlyMetric?operationDefinitionMap[operationType].displayName:label},description:"Title of a suggested chart containing only a single numerical metric calculated over all available data"})}function LayerPanel({state:state,layerId:layerId,onChangeIndexPattern:onChangeIndexPattern}){const layer=state.layers[layerId];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(ChangeIndexPattern,{"data-test-subj":"indexPattern-switcher",trigger:{label:state.indexPatterns[layer.indexPatternId].title,title:state.indexPatterns[layer.indexPatternId].title,"data-test-subj":"lns_layerIndexPatternLabel",size:"s",fontWeight:"normal"},indexPatternId:layer.indexPatternId,indexPatternRefs:state.indexPatternRefs,onChangeIndexPattern:onChangeIndexPattern}))}const renameColumns={name:"lens_rename_columns",type:"datatable",help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.renameColumns.help",{defaultMessage:"A helper to rename the columns of a datatable"}),args:{idMap:{types:["string"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.renameColumns.idMap.help",{defaultMessage:"A JSON encoded object in which keys are the old column ids and values are the corresponding new ones. All other columns ids are kept."})}},inputTypes:["datatable"],fn(data,{idMap:encodedIdMap}){const idMap=JSON.parse(encodedIdMap);return{type:"datatable",rows:data.rows.map(row=>{const mappedRow={};Object.entries(idMap).forEach(([fromId,toId])=>{mappedRow[toId.id]=row[fromId]});Object.entries(row).forEach(([id,value])=>{if(id in idMap){mappedRow[idMap[id].id]=sanitizeValue(value)}else{mappedRow[id]=sanitizeValue(value)}});return mappedRow}),columns:data.columns.map(column=>{const mappedItem=idMap[column.id];if(!mappedItem){return column}return{...column,id:mappedItem.id,name:getColumnName(mappedItem,column)}})}}};function getColumnName(originalColumn,newColumn){if(originalColumn&&originalColumn.operationType==="date_histogram"){const fieldName=originalColumn.sourceField;return newColumn.name.replace(fieldName,originalColumn.label)}return originalColumn.label}function sanitizeValue(value){if(value===""){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexpattern.emptyTextColumnValue",{defaultMessage:"(empty)"})}return value}var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(14);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);var common_=__webpack_require__(27);const unitInMs={s:1e3,m:1e3*60,h:1e3*60*60,d:1e3*60*60*24};function getTimeScaleFunction(data){const timeScale={name:"lens_time_scale",type:"datatable",help:"",args:{dateColumnId:{types:["string"],help:"",required:true},inputColumnId:{types:["string"],help:"",required:true},outputColumnId:{types:["string"],help:"",required:true},outputColumnName:{types:["string"],help:""},targetUnit:{types:["string"],options:["s","m","h","d"],help:"",required:true}},inputTypes:["datatable"],async fn(input,{dateColumnId:dateColumnId,inputColumnId:inputColumnId,outputColumnId:outputColumnId,outputColumnName:outputColumnName,targetUnit:targetUnit}){const dateColumnDefinition=input.columns.find(column=>column.id===dateColumnId);if(!dateColumnDefinition){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.timeScale.dateColumnMissingMessage",{defaultMessage:"Specified dateColumnId {columnId} does not exist.",values:{columnId:dateColumnId}}))}const resultColumns=Object(common_["buildResultColumns"])(input,outputColumnId,inputColumnId,outputColumnName,{allowColumnOverwrite:true});if(!resultColumns){return input}const targetUnitInMs=unitInMs[targetUnit];const timeInfo=await data.search.aggs.getDateMetaByDatatableColumn(dateColumnDefinition);const intervalDuration=timeInfo&&data_public_["search"].aggs.parseInterval(timeInfo.interval);if(!timeInfo||!intervalDuration){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.timeScale.timeInfoMissingMessage",{defaultMessage:"Could not fetch date histogram information"}))}const defaultTimezone=external_kbnSharedDeps_MomentTimezone_default()().zoneName();external_kbnSharedDeps_MomentTimezone_default.a.tz.setDefault(timeInfo.timeZone);const timeBounds=timeInfo.timeRange&&data.query.timefilter.timefilter.calculateBounds(timeInfo.timeRange);const result={...input,columns:resultColumns,rows:input.rows.map(row=>{const newRow={...row};let startOfBucket=external_kbnSharedDeps_MomentTimezone_default()(row[dateColumnId]);let endOfBucket=startOfBucket.clone().add(intervalDuration);if(timeBounds&&timeBounds.min){startOfBucket=external_kbnSharedDeps_MomentTimezone_default.a.max(startOfBucket,timeBounds.min)}if(timeBounds&&timeBounds.max){endOfBucket=external_kbnSharedDeps_MomentTimezone_default.a.min(endOfBucket,timeBounds.max)}const bucketSize=endOfBucket.diff(startOfBucket);const factor=bucketSize/targetUnitInMs;const currentValue=newRow[inputColumnId];if(currentValue!=null){newRow[outputColumnId]=Number(currentValue)/factor}return newRow})};external_kbnSharedDeps_MomentTimezone_default.a.tz.setDefault(defaultTimezone);return result}};return timeScale}const counterRate={name:"lens_counter_rate",type:"datatable",inputTypes:["datatable"],help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.counterRate.help",{defaultMessage:"Calculates the counter rate of a column in a data table"}),args:{by:{help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.counterRate.args.byHelpText",{defaultMessage:"Column to split the counter rate calculation by"}),multi:true,types:["string"],required:false},inputColumnId:{help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.counterRate.args.inputColumnIdHelpText",{defaultMessage:"Column to calculate the counter rate of"}),types:["string"],required:true},outputColumnId:{help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.counterRate.args.outputColumnIdHelpText",{defaultMessage:"Column to store the resulting counter rate in"}),types:["string"],required:true},outputColumnName:{help:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.functions.counterRate.args.outputColumnNameHelpText",{defaultMessage:"Name of the column to store the resulting counter rate in"}),types:["string"],required:false}},fn(input,{by:by,inputColumnId:inputColumnId,outputColumnId:outputColumnId,outputColumnName:outputColumnName}){const resultColumns=Object(common_["buildResultColumns"])(input,outputColumnId,inputColumnId,outputColumnName);if(!resultColumns){return input}const previousValues={};return{...input,columns:resultColumns,rows:input.rows.map(row=>{const newRow={...row};const bucketIdentifier=Object(common_["getBucketIdentifier"])(row,by);const previousValue=previousValues[bucketIdentifier];const currentValue=newRow[inputColumnId];if(currentValue!=null&&previousValue!=null){const currentValueAsNumber=Number(currentValue);if(currentValueAsNumber>=previousValue){newRow[outputColumnId]=currentValueAsNumber-previousValue}else{newRow[outputColumnId]=currentValueAsNumber}}else{newRow[outputColumnId]=undefined}if(currentValue!=null){previousValues[bucketIdentifier]=Number(currentValue)}else{previousValues[bucketIdentifier]=undefined}return newRow})}}};function indexpattern_extends(){indexpattern_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return indexpattern_extends.apply(this,arguments)}function columnToOperation(column,uniqueLabel){const{dataType:dataType,label:label,isBucketed:isBucketed,scale:scale}=column;return{dataType:normalizeOperationDataType(dataType),isBucketed:isBucketed,scale:scale,label:uniqueLabel||label}}function getIndexPatternDatasource({core:core,storage:storage,data:data,charts:charts}){const savedObjectsClient=core.savedObjects.client;const uiSettings=core.uiSettings;const onIndexPatternLoadError=err=>core.notifications.toasts.addError(err,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.indexPatternLoadError",{defaultMessage:"Error loading index pattern"})});const indexPatternsService=data.indexPatterns;const handleChangeIndexPattern=(id,state,setState)=>{loader_changeIndexPattern({id:id,state:state,setState:setState,onError:onIndexPatternLoadError,storage:storage,indexPatternsService:indexPatternsService})};const indexPatternDatasource={id:"indexpattern",async initialize(persistedState,references,initialContext,options){return loadInitialState({persistedState:persistedState,references:references,savedObjectsClient:await savedObjectsClient,defaultIndexPatternId:core.uiSettings.get("defaultIndex"),storage:storage,indexPatternsService:indexPatternsService,initialContext:initialContext,options:options})},getPersistableState(state){return extractReferences(state)},insertLayer(state,newLayerId){return{...state,layers:{...state.layers,[newLayerId]:blankLayer(state.currentIndexPatternId)}}},removeLayer(state,layerId){const newLayers={...state.layers};delete newLayers[layerId];return{...state,layers:newLayers}},clearLayer(state,layerId){return{...state,layers:{...state.layers,[layerId]:blankLayer(state.currentIndexPatternId)}}},getLayers(state){return Object.keys(state.layers)},removeColumn({prevState:prevState,layerId:layerId,columnId:columnId}){var _prevState$layers$lay;const indexPattern=prevState.indexPatterns[(_prevState$layers$lay=prevState.layers[layerId])===null||_prevState$layers$lay===void 0?void 0:_prevState$layers$lay.indexPatternId];return mergeLayer({state:prevState,layerId:layerId,newLayer:deleteColumn({layer:prevState.layers[layerId],columnId:columnId,indexPattern:indexPattern})})},toExpression:(state,layerId)=>indexpattern_datasource_to_expression_toExpression(state,layerId,uiSettings),renderDataPanel(domElement,props){Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(IndexPatternDataPanel,indexpattern_extends({changeIndexPattern:handleChangeIndexPattern,data:data,charts:charts},props))),domElement)},uniqueLabels(state){const layers=state.layers;const columnLabelMap={};const counts={};const makeUnique=label=>{let uniqueLabel=label;while(counts[uniqueLabel]>=0){const num=++counts[uniqueLabel];uniqueLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.uniqueLabel",{defaultMessage:"{label} [{num}]",values:{label:label,num:num}})}counts[uniqueLabel]=0;return uniqueLabel};Object.values(layers).forEach(layer=>{if(!layer.columns){return}Object.entries(layer.columns).forEach(([columnId,column])=>{columnLabelMap[columnId]=makeUnique(column.label)})});return columnLabelMap},renderDimensionTrigger:(domElement,props)=>{const columnLabelMap=indexPatternDatasource.uniqueLabels(props.state);Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(public_["KibanaContextProvider"],{services:{appName:"lens",storage:storage,uiSettings:uiSettings,data:data,savedObjects:core.savedObjects,docLinks:core.docLinks}},external_kbnSharedDeps_React_default.a.createElement(dimension_panel_IndexPatternDimensionTrigger,indexpattern_extends({uniqueLabel:columnLabelMap[props.columnId]},props)))),domElement)},renderDimensionEditor:(domElement,props)=>{const columnLabelMap=indexPatternDatasource.uniqueLabels(props.state);Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(public_["KibanaContextProvider"],{services:{appName:"lens",storage:storage,uiSettings:uiSettings,data:data,savedObjects:core.savedObjects,docLinks:core.docLinks,http:core.http}},external_kbnSharedDeps_React_default.a.createElement(IndexPatternDimensionEditor,indexpattern_extends({uiSettings:uiSettings,storage:storage,savedObjectsClient:core.savedObjects.client,http:core.http,data:data,uniqueLabel:columnLabelMap[props.columnId]},props)))),domElement)},renderLayerPanel:(domElement,props)=>{Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(LayerPanel,indexpattern_extends({onChangeIndexPattern:indexPatternId=>{changeLayerIndexPattern({indexPatternId:indexPatternId,setState:props.setState,state:props.state,layerId:props.layerId,onError:onIndexPatternLoadError,replaceIfPossible:true,storage:storage,indexPatternsService:indexPatternsService})}},props)),domElement)},getDropProps:getDropProps,onDrop:droppable_onDrop,updateStateOnCloseDimension:({state:state,layerId:layerId,columnId:columnId})=>{const layer={...state.layers[layerId]};const current=state.layers[layerId].incompleteColumns||{};if(!Object.values(current).length){return}const newIncomplete={...current};delete newIncomplete[columnId];return mergeLayer({state:state,layerId:layerId,newLayer:{...layer,incompleteColumns:newIncomplete}})},getPublicAPI({state:state,layerId:layerId}){const columnLabelMap=indexPatternDatasource.uniqueLabels(state);return{datasourceId:"indexpattern",getTableSpec:()=>state.layers[layerId].columnOrder.filter(colId=>!isReferenced(state.layers[layerId],colId)).map(colId=>({columnId:colId})),getOperationForColumnId:columnId=>{const layer=state.layers[layerId];if(layer&&layer.columns[columnId]){if(!isReferenced(layer,columnId)){return columnToOperation(layer.columns[columnId],columnLabelMap[columnId])}}return null}}},getDatasourceSuggestionsForField(state,draggedField){return isDraggedField(draggedField)?getDatasourceSuggestionsForField(state,draggedField.indexPatternId,draggedField.field):[]},getDatasourceSuggestionsFromCurrentState:getDatasourceSuggestionsFromCurrentState,getDatasourceSuggestionsForVisualizeField:getDatasourceSuggestionsForVisualizeField,getErrorMessages(state,layersGroups){if(!state){return}const layerErrors=Object.values(state.layers).map(layer=>{var _getErrorMessages;return((_getErrorMessages=getErrorMessages(layer,state.indexPatterns[layer.indexPatternId]))!==null&&_getErrorMessages!==void 0?_getErrorMessages:[]).map(message=>({shortMessage:"",longMessage:message}))});if(layerErrors.length<=1){var _layerErrors$;return(_layerErrors$=layerErrors[0])!==null&&_layerErrors$!==void 0&&_layerErrors$.length?layerErrors[0]:undefined}const messages=layerErrors.flatMap((errors,index)=>errors.map(error=>{const{shortMessage:shortMessage,longMessage:longMessage}=error;return{shortMessage:shortMessage?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.layerErrorWrapper",{defaultMessage:"Layer {position} error: {wrappedMessage}",values:{position:index+1,wrappedMessage:shortMessage}}):"",longMessage:longMessage?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.layerErrorWrapper",{defaultMessage:"Layer {position} error: {wrappedMessage}",values:{position:index+1,wrappedMessage:longMessage}}):""}}));return messages.length?messages:undefined}};return indexPatternDatasource}function blankLayer(indexPatternId){return{indexPatternId:indexPatternId,columns:{},columnOrder:[]}}function getActiveDatasourceIdFromDoc(doc){if(!doc){return null}const[initialDatasourceId]=Object.keys(doc.state.datasourceStates);return initialDatasourceId||null}function getInitialDatasourceId(props){return props.initialDatasourceId?props.initialDatasourceId:getActiveDatasourceIdFromDoc(props.doc)}const getInitialState=props=>{const datasourceStates={};if(props.doc){Object.entries(props.doc.state.datasourceStates).forEach(([datasourceId,state])=>{datasourceStates[datasourceId]={isLoading:true,state:state}})}else if(props.initialDatasourceId){datasourceStates[props.initialDatasourceId]={state:null,isLoading:true}}return{title:"",datasourceStates:datasourceStates,activeDatasourceId:getInitialDatasourceId(props),visualization:{state:null,activeId:props.initialVisualizationId}}};const reducer=(state,action)=>{switch(action.type){case"RESET":return action.state;case"UPDATE_TITLE":return{...state,title:action.title};case"UPDATE_STATE":return action.updater(state);case"UPDATE_ACTIVE_DATA":return{...state,activeData:{...action.tables}};case"UPDATE_LAYER":return{...state,datasourceStates:{...state.datasourceStates,[action.datasourceId]:{...state.datasourceStates[action.datasourceId],state:action.updater(state.datasourceStates[action.datasourceId].state,action.layerId)}}};case"VISUALIZATION_LOADED":return{...state,persistedId:action.doc.savedObjectId,title:action.doc.title,description:action.doc.description,datasourceStates:Object.entries(action.doc.state.datasourceStates).reduce((stateMap,[datasourceId,datasourceState])=>({...stateMap,[datasourceId]:{isLoading:true,state:datasourceState}}),{}),activeDatasourceId:getActiveDatasourceIdFromDoc(action.doc),visualization:{...state.visualization,activeId:action.doc.visualizationType,state:action.doc.state.visualization}};case"SWITCH_DATASOURCE":return{...state,datasourceStates:{...state.datasourceStates,[action.newDatasourceId]:state.datasourceStates[action.newDatasourceId]||{state:null,isLoading:true}},activeDatasourceId:action.newDatasourceId};case"SWITCH_VISUALIZATION":return{...state,datasourceStates:"datasourceId"in action&&action.datasourceId?{...state.datasourceStates,[action.datasourceId]:{...state.datasourceStates[action.datasourceId],state:action.datasourceState}}:state.datasourceStates,visualization:{...state.visualization,activeId:action.newVisualizationId,state:action.initialState},stagedPreview:undefined};case"SELECT_SUGGESTION":return{...state,datasourceStates:"datasourceId"in action&&action.datasourceId?{...state.datasourceStates,[action.datasourceId]:{...state.datasourceStates[action.datasourceId],state:action.datasourceState}}:state.datasourceStates,visualization:{...state.visualization,activeId:action.newVisualizationId,state:action.initialState},stagedPreview:state.stagedPreview||{datasourceStates:state.datasourceStates,visualization:state.visualization}};case"ROLLBACK_SUGGESTION":return{...state,...state.stagedPreview||{},stagedPreview:undefined};case"SUBMIT_SUGGESTION":return{...state,stagedPreview:undefined};case"UPDATE_DATASOURCE_STATE":return{...state,datasourceStates:{...state.datasourceStates,[action.datasourceId]:{state:typeof action.updater==="function"?action.updater(state.datasourceStates[action.datasourceId].state):action.updater,isLoading:false}},stagedPreview:action.clearStagedPreview?undefined:state.stagedPreview};case"UPDATE_VISUALIZATION_STATE":if(!state.visualization.activeId){throw new Error("Invariant: visualization state got updated without active visualization")}if(state.visualization.activeId!==action.visualizationId){return state}return{...state,visualization:{...state.visualization,state:typeof action.updater==="function"?action.updater(state.visualization.state):action.updater},stagedPreview:action.clearStagedPreview?undefined:state.stagedPreview};default:return state}};var data_panel_wrapper=__webpack_require__(216);const DataPanelWrapper=Object(external_kbnSharedDeps_React_["memo"])(props=>{const{dispatch:dispatch,activeDatasource:activeDatasource}=props;const setDatasourceState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>updater=>{dispatch({type:"UPDATE_DATASOURCE_STATE",updater:updater,datasourceId:activeDatasource,clearStagedPreview:true})},[dispatch,activeDatasource]);const datasourceProps={dragDropContext:Object(external_kbnSharedDeps_React_["useContext"])(drag_drop["DragContext"]),state:props.datasourceState,setState:setDatasourceState,core:props.core,query:props.query,dateRange:props.dateRange,filters:props.filters,showNoDataPopover:props.showNoDataPopover,dropOntoWorkspace:props.dropOntoWorkspace,hasSuggestionForField:props.hasSuggestionForField};const[showDatasourceSwitcher,setDatasourceSwitcher]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,Object.keys(props.datasourceMap).length>1&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"datasource-switch",className:"lnsDataPanelWrapper__switchSource",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.dataPanelWrapper.switchDatasource",{defaultMessage:"Switch to datasource"}),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.dataPanelWrapper.switchDatasource",{defaultMessage:"Switch to datasource"}),"data-test-subj":"datasource-switch",onClick:()=>setDatasourceSwitcher(true),iconType:"gear"}),isOpen:showDatasourceSwitcher,closePopover:()=>setDatasourceSwitcher(false),panelPaddingSize:"none",anchorPosition:"rightUp"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.dataPanelWrapper.switchDatasource",{defaultMessage:"Switch to datasource"}),items:Object.keys(props.datasourceMap).map(datasourceId=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{key:datasourceId,"data-test-subj":`datasource-switch-${datasourceId}`,icon:props.activeDatasource===datasourceId?"check":"empty",onClick:()=>{setDatasourceSwitcher(false);props.dispatch({type:"SWITCH_DATASOURCE",newDatasourceId:datasourceId})}},datasourceId))})),props.activeDatasource&&!props.datasourceIsLoading&&external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{className:"lnsDataPanelWrapper",render:props.datasourceMap[props.activeDatasource].renderDataPanel,nativeProps:datasourceProps}))});var config_panel=__webpack_require__(225);var layer_panel=__webpack_require__(234);function LayerSettings({layerId:layerId,activeVisualization:activeVisualization,layerConfigProps:layerConfigProps}){var _activeVisualization$;const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);if(!activeVisualization.renderLayerContextMenu){return null}const a11yText=chartType=>{if(chartType){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editLayerSettingsChartType",{defaultMessage:"Edit layer settings, {chartType}",values:{chartType:chartType}})}return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editLayerSettings",{defaultMessage:"Edit layer settings"})};const contextMenuIcon=(_activeVisualization$=activeVisualization.getLayerContextMenuIcon)===null||_activeVisualization$===void 0?void 0:_activeVisualization$.call(activeVisualization,layerConfigProps);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:`lnsLayerPopover_${layerId}`,panelPaddingSize:"m",ownFocus:true,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editLayerSettings",{defaultMessage:"Edit layer settings"})},external_kbnSharedDeps_React_default.a.createElement(public_["ToolbarButton"],{size:"s",iconType:(contextMenuIcon===null||contextMenuIcon===void 0?void 0:contextMenuIcon.icon)||"gear","aria-label":a11yText((contextMenuIcon===null||contextMenuIcon===void 0?void 0:contextMenuIcon.label)||""),title:a11yText((contextMenuIcon===null||contextMenuIcon===void 0?void 0:contextMenuIcon.label)||""),onClick:()=>setIsOpen(!isOpen),"data-test-subj":"lns_layer_settings"})),isOpen:isOpen,closePopover:()=>setIsOpen(false),anchorPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:activeVisualization.renderLayerContextMenu,nativeProps:layerConfigProps}))}var dimension_container=__webpack_require__(243);function DimensionContainer({isOpen:isOpen,groupLabel:groupLabel,handleClose:handleClose,panel:panel}){const[focusTrapIsEnabled,setFocusTrapIsEnabled]=Object(external_kbnSharedDeps_React_["useState"])(false);const closeFlyout=()=>{handleClose();setFocusTrapIsEnabled(false)};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isOpen){setTimeout(()=>{setFocusTrapIsEnabled(true)},255)}},[isOpen]);return isOpen?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFocusTrap"],{disabled:!focusTrapIsEnabled,clickOutsideDisables:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiOutsideClickDetector"],{onOutsideClick:closeFlyout,isDisabled:!isOpen},external_kbnSharedDeps_React_default.a.createElement("div",{role:"dialog","aria-labelledby":"lnsDimensionContainerTitle",className:"lnsDimensionContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,className:"lnsDimensionContainer__header"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"center",className:"lnsDimensionContainer__headerLink",onClick:closeFlyout},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{color:"text","data-test-subj":"lns-indexPattern-dimensionContainerBack",className:"lnsDimensionContainer__backIcon",onClick:closeFlyout,iconType:"sortLeft","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.dimensionContainer.closeConfiguration",{defaultMessage:"Close configuration"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"lnsDimensionContainerTitle",className:"lnsDimensionContainer__headerTitle"},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configure.configurePanelTitle",{defaultMessage:"{groupLabel} configuration",values:{groupLabel:groupLabel}}))))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{className:"eui-yScrollWithShadows",grow:1},panel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],{className:"lnsDimensionContainer__footer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{flush:"left",size:"s",iconType:"cross",onClick:closeFlyout},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.dimensionContainer.close",{defaultMessage:"Close"})))))):null}function RemoveLayerButton({onRemoveLayer:onRemoveLayer,layerIndex:layerIndex,isOnlyLayer:isOnlyLayer}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:"trash",color:"danger","data-test-subj":"lnsLayerRemove","aria-label":isOnlyLayer?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.resetLayerAriaLabel",{defaultMessage:"Reset layer {index}",values:{index:layerIndex+1}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.deleteLayerAriaLabel",{defaultMessage:`Delete layer {index}`,values:{index:layerIndex+1}}),onClick:()=>{const el=document.activeElement;if(el!==null&&el!==void 0&&el.blur){el.blur()}onRemoveLayer()}},isOnlyLayer?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.resetLayer",{defaultMessage:"Reset layer"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.deleteLayer",{defaultMessage:`Delete layer`}))}const empty_dimension_button_label=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.emptyDimensionButton",{defaultMessage:"Empty dimension"});const getAdditionalClassesOnDroppable=dropType=>{if(dropType==="move_incompatible"||dropType==="replace_incompatible"){return"lnsDragDrop-notCompatible"}};function EmptyDimensionButton({group:group,layerDatasource:layerDatasource,layerDatasourceDropProps:layerDatasourceDropProps,layerId:layerId,groupIndex:groupIndex,layerIndex:layerIndex,onClick:onClick,onDrop:onDrop}){const{dragging:dragging}=Object(external_kbnSharedDeps_React_["useContext"])(drag_drop["DragContext"]);const itemIndex=group.accessors.length;const[newColumnId,setNewColumnId]=Object(external_kbnSharedDeps_React_["useState"])(generateId());Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setNewColumnId(generateId())},[itemIndex]);const dropProps=layerDatasource.getDropProps({...layerDatasourceDropProps,dragging:dragging,columnId:newColumnId,filterOperations:group.filterOperations,groupId:group.groupId});const dropType=dropProps===null||dropProps===void 0?void 0:dropProps.dropType;const nextLabel=dropProps===null||dropProps===void 0?void 0:dropProps.nextLabel;const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({columnId:newColumnId,groupId:group.groupId,layerId:layerId,id:newColumnId,dropType:dropType,humanData:{label:empty_dimension_button_label,groupLabel:group.groupLabel,position:itemIndex+1,nextLabel:nextLabel||""}}),[dropType,newColumnId,group.groupId,layerId,group.groupLabel,itemIndex,nextLabel]);const handleOnDrop=external_kbnSharedDeps_React_default.a.useCallback((droppedItem,selectedDropType)=>onDrop(droppedItem,value,selectedDropType),[value,onDrop]);return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__dimensionContainer","data-test-subj":group.dataTestSubj},external_kbnSharedDeps_React_default.a.createElement(drag_drop["DragDrop"],{getAdditionalClassesOnDroppable:getAdditionalClassesOnDroppable,value:value,order:[2,layerIndex,groupIndex,itemIndex],onDrop:handleOnDrop,dropType:dropType},external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__dimension lnsLayerPanel__dimension--empty"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{className:"lnsLayerPanel__triggerText",color:"text",size:"xs",iconType:"plusInCircleFilled",contentProps:{className:"lnsLayerPanel__triggerTextContent"},"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.removeColumnAriaLabel",{defaultMessage:"Drop a field or click to add to {groupLabel}",values:{groupLabel:group.groupLabel}}),"data-test-subj":"lns-empty-dimension",onClick:()=>{onClick(value.columnId)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.configure.emptyConfig",defaultMessage:"Drop a field or click to add"})))))}function color_indicator_extends(){color_indicator_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return color_indicator_extends.apply(this,arguments)}function ColorIndicator({accessorConfig:accessorConfig,children:children}){let indicatorIcon=null;if(accessorConfig.triggerIcon&&accessorConfig.triggerIcon!=="none"){const baseIconProps={size:"s",className:"lnsLayerPanel__colorIndicator"};indicatorIcon=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},accessorConfig.triggerIcon==="color"&&accessorConfig.color&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],color_indicator_extends({},baseIconProps,{color:accessorConfig.color,type:"stopFilled","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.colorIndicatorLabel",{defaultMessage:"Color of this dimension: {hex}",values:{hex:accessorConfig.color}})})),accessorConfig.triggerIcon==="disabled"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],color_indicator_extends({},baseIconProps,{type:"stopSlash",color:"subdued","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.noColorIndicatorLabel",{defaultMessage:"This dimension does not have an individual color"})})),accessorConfig.triggerIcon==="invisible"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],color_indicator_extends({},baseIconProps,{type:"eyeClosed",color:"subdued","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.invisibleIndicatorLabel",{defaultMessage:"This dimension is currently not visible in the chart"})})),accessorConfig.triggerIcon==="colorBy"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],color_indicator_extends({},baseIconProps,{type:"brush",color:"text","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.paletteColorIndicatorLabel",{defaultMessage:"This dimension is using a palette"})})))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"center"},indicatorIcon,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,children))}function PaletteIndicator({accessorConfig:accessorConfig}){if(accessorConfig.triggerIcon!=="colorBy"||!accessorConfig.palette)return null;return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__paletteContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPaletteDisplay"],{className:"lnsLayerPanel__palette",size:"xs",palette:accessorConfig.palette}))}const triggerLinkA11yText=label=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configure.editConfig",{defaultMessage:"Edit {label} configuration",values:{label:label}});function DimensionButton({group:group,children:children,onClick:onClick,onRemoveClick:onRemoveClick,accessorConfig:accessorConfig,label:label}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{className:"lnsLayerPanel__dimensionLink","data-test-subj":"lnsLayerPanel-dimensionLink",onClick:()=>onClick(accessorConfig.columnId),"aria-label":triggerLinkA11yText(label),title:triggerLinkA11yText(label)},external_kbnSharedDeps_React_default.a.createElement(ColorIndicator,{accessorConfig:accessorConfig},children)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{className:"lnsLayerPanel__dimensionRemove","data-test-subj":"indexPattern-dimension-remove",iconType:"cross",iconSize:"s",size:"s",color:"danger","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.removeColumnLabel",{defaultMessage:'Remove configuration from "{groupLabel}"',values:{groupLabel:group.groupLabel}}),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.indexPattern.removeColumnLabel",{defaultMessage:'Remove configuration from "{groupLabel}"',values:{groupLabel:group.groupLabel}}),onClick:()=>onRemoveClick(accessorConfig.columnId)}),external_kbnSharedDeps_React_default.a.createElement(PaletteIndicator,{accessorConfig:accessorConfig}))}const getAdditionalClassesOnEnter=dropType=>{if(dropType==="field_replace"||dropType==="replace_compatible"||dropType==="replace_incompatible"){return"lnsDragDrop-isReplacing"}};const draggable_dimension_button_getAdditionalClassesOnDroppable=dropType=>{if(dropType==="move_incompatible"||dropType==="replace_incompatible"){return"lnsDragDrop-notCompatible"}};function DraggableDimensionButton({layerId:layerId,label:label,accessorIndex:accessorIndex,groupIndex:groupIndex,layerIndex:layerIndex,columnId:columnId,group:group,onDrop:onDrop,children:children,layerDatasourceDropProps:layerDatasourceDropProps,layerDatasource:layerDatasource,registerNewButtonRef:registerNewButtonRef}){const{dragging:dragging}=Object(external_kbnSharedDeps_React_["useContext"])(drag_drop["DragContext"]);const dropProps=layerDatasource.getDropProps({...layerDatasourceDropProps,dragging:dragging,columnId:columnId,filterOperations:group.filterOperations,groupId:group.groupId});const dropType=dropProps===null||dropProps===void 0?void 0:dropProps.dropType;const nextLabel=dropProps===null||dropProps===void 0?void 0:dropProps.nextLabel;const value=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({columnId:columnId,groupId:group.groupId,layerId:layerId,id:columnId,dropType:dropType,humanData:{label:label,groupLabel:group.groupLabel,position:accessorIndex+1,nextLabel:nextLabel||""}}),[columnId,group.groupId,accessorIndex,layerId,dropType,label,group.groupLabel,nextLabel]);const reorderableGroup=Object(external_kbnSharedDeps_React_["useMemo"])(()=>group.accessors.map(g=>({id:g.columnId})),[group.accessors]);const registerNewButtonRefMemoized=Object(external_kbnSharedDeps_React_["useCallback"])(el=>registerNewButtonRef(columnId,el),[registerNewButtonRef,columnId]);const handleOnDrop=external_kbnSharedDeps_React_default.a.useCallback((droppedItem,selectedDropType)=>onDrop(droppedItem,value,selectedDropType),[value,onDrop]);return external_kbnSharedDeps_React_default.a.createElement("div",{ref:registerNewButtonRefMemoized,className:"lnsLayerPanel__dimensionContainer","data-test-subj":group.dataTestSubj},external_kbnSharedDeps_React_default.a.createElement(drag_drop["DragDrop"],{getAdditionalClassesOnEnter:getAdditionalClassesOnEnter,getAdditionalClassesOnDroppable:draggable_dimension_button_getAdditionalClassesOnDroppable,order:[2,layerIndex,groupIndex,accessorIndex],draggable:true,dragType:isDraggedOperation(dragging)?"move":"copy",dropType:dropType,reorderableGroup:reorderableGroup.length>1?reorderableGroup:undefined,value:value,onDrop:handleOnDrop},children))}const getFirstFocusable=el=>{const focusableSelector="button, [href], input, select, textarea, [tabindex]";if(!el){return null}if(el.matches(focusableSelector)){return el}const firstFocusable=el.querySelector(focusableSelector);if(!firstFocusable){return null}return firstFocusable};function useFocusUpdate(ids){const[nextFocusedId,setNextFocusedId]=Object(external_kbnSharedDeps_React_["useState"])(null);const[refsById,setRefsById]=Object(external_kbnSharedDeps_React_["useState"])({});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const element=nextFocusedId&&refsById[nextFocusedId];if(element){const focusable=getFirstFocusable(element);focusable===null||focusable===void 0?void 0:focusable.focus();setNextFocusedId(null)}},[ids,refsById,nextFocusedId]);const registerNewRef=Object(external_kbnSharedDeps_React_["useCallback"])((id,el)=>{if(el){setRefsById(r=>({...r,[id]:el}))}},[]);const removeRef=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{if(ids.length<=1){return setNextFocusedId(id)}const removedIndex=ids.findIndex(l=>l===id);setRefsById(refs=>{const newRefsById={...refs};delete newRefsById[id];return newRefsById});const next=removedIndex===0?ids[1]:ids[removedIndex-1];return setNextFocusedId(next)},[ids]);return{setNextFocusedId:setNextFocusedId,removeRef:removeRef,registerNewRef:registerNewRef}}const initialActiveDimensionState={isNew:false};function layer_panel_LayerPanel(props){const[activeDimension,setActiveDimension]=Object(external_kbnSharedDeps_React_["useState"])(initialActiveDimensionState);const{framePublicAPI:framePublicAPI,layerId:layerId,isOnlyLayer:isOnlyLayer,onRemoveLayer:onRemoveLayer,registerNewLayerRef:registerNewLayerRef,layerIndex:layerIndex,activeVisualization:activeVisualization,updateVisualization:updateVisualization,updateDatasource:updateDatasource}=props;const datasourcePublicAPI=framePublicAPI.datasourceLayers[layerId];Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setActiveDimension(initialActiveDimensionState)},[activeVisualization.id]);const registerLayerRef=Object(external_kbnSharedDeps_React_["useCallback"])(el=>registerNewLayerRef(layerId,el),[layerId,registerNewLayerRef]);const layerVisualizationConfigProps={layerId:layerId,state:props.visualizationState,frame:props.framePublicAPI,dateRange:props.framePublicAPI.dateRange,activeData:props.framePublicAPI.activeData};const datasourceId=datasourcePublicAPI.datasourceId;const layerDatasourceState=props.datasourceStates[datasourceId].state;const layerDatasourceDropProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({layerId:layerId,state:layerDatasourceState,setState:newState=>{updateDatasource(datasourceId,newState)}}),[layerId,layerDatasourceState,datasourceId,updateDatasource]);const layerDatasource=props.datasourceMap[datasourceId];const layerDatasourceConfigProps={...layerDatasourceDropProps,frame:props.framePublicAPI,dateRange:props.framePublicAPI.dateRange,activeData:props.framePublicAPI.activeData};const{groups:groups}=activeVisualization.getConfiguration(layerVisualizationConfigProps);const isEmptyLayer=!groups.some(d=>d.accessors.length>0);const{activeId:activeId,activeGroup:activeGroup}=activeDimension;const columnLabelMap=layerDatasource.uniqueLabels(layerDatasourceConfigProps.state);const{setDimension:setDimension,removeDimension:removeDimension}=activeVisualization;const allAccessors=groups.flatMap(group=>group.accessors.map(accessor=>accessor.columnId));const{setNextFocusedId:setNextFocusedButtonId,removeRef:removeButtonRef,registerNewRef:registerNewButtonRef}=useFocusUpdate(allAccessors);const layerDatasourceOnDrop=layerDatasource.onDrop;const onDrop=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(droppedItem,targetItem,dropType)=>{var _groups$find;if(!dropType){return}const{columnId:columnId,groupId:groupId,layerId:targetLayerId}=targetItem;if(dropType==="reorder"||dropType==="field_replace"||dropType==="field_add"){setNextFocusedButtonId(droppedItem.id)}else{setNextFocusedButtonId(columnId)}const filterOperations=((_groups$find=groups.find(({groupId:gId})=>gId===targetItem.groupId))===null||_groups$find===void 0?void 0:_groups$find.filterOperations)||(()=>false);const dropResult=layerDatasourceOnDrop({...layerDatasourceDropProps,droppedItem:droppedItem,columnId:columnId,layerId:targetLayerId,filterOperations:filterOperations,dropType:dropType});if(dropResult){const newVisState=setDimension({columnId:columnId,groupId:groupId,layerId:targetLayerId,prevState:props.visualizationState});if(typeof dropResult==="object"){updateVisualization(removeDimension({columnId:dropResult.deleted,layerId:targetLayerId,prevState:newVisState}))}else{updateVisualization(newVisState)}}},[groups,layerDatasourceOnDrop,props.visualizationState,updateVisualization,setDimension,removeDimension,layerDatasourceDropProps,setNextFocusedButtonId]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("section",{tabIndex:-1,ref:registerLayerRef,className:"lnsLayerPanel"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{"data-test-subj":`lns-layerPanel-${layerIndex}`,paddingSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"flexStart",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"lnsLayerPanel__settingsFlexItem"},external_kbnSharedDeps_React_default.a.createElement(LayerSettings,{layerId:layerId,layerConfigProps:{...layerVisualizationConfigProps,setState:props.updateVisualization},activeVisualization:activeVisualization})),layerDatasource&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{className:"lnsLayerPanel__sourceFlexItem"},external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:layerDatasource.renderLayerPanel,nativeProps:{layerId:layerId,state:layerDatasourceState,activeData:props.framePublicAPI.activeData,setState:updater=>{const newState=typeof updater==="function"?updater(layerDatasourceState):updater;const nextPublicAPI=layerDatasource.getPublicAPI({state:newState,layerId:layerId});const nextTable=new Set(nextPublicAPI.getTableSpec().map(({columnId:columnId})=>columnId));const removed=datasourcePublicAPI.getTableSpec().map(({columnId:columnId})=>columnId).filter(columnId=>!nextTable.has(columnId));let nextVisState=props.visualizationState;removed.forEach(columnId=>{nextVisState=activeVisualization.removeDimension({layerId:layerId,columnId:columnId,prevState:nextVisState})});props.updateAll(datasourceId,newState,nextVisState)}}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),groups.map((group,groupIndex)=>{const isMissing=!isEmptyLayer&&group.required&&group.accessors.length===0;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{className:group.supportsMoreColumns?"lnsLayerPanel__row":"lnsLayerPanel__row lnsLayerPanel__row--notSupportsMoreColumns",fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__groupLabel"},group.groupLabel),labelType:"legend",key:group.groupId,isInvalid:isMissing,error:isMissing?external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__error"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.requiredDimensionWarningLabel",{defaultMessage:"Required dimension"})):[]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(drag_drop["ReorderProvider"],{id:group.groupId,className:"lnsLayerPanel__group"},group.accessors.map((accessorConfig,accessorIndex)=>{const{columnId:columnId}=accessorConfig;return external_kbnSharedDeps_React_default.a.createElement(DraggableDimensionButton,{registerNewButtonRef:registerNewButtonRef,accessorIndex:accessorIndex,columnId:columnId,group:group,groupIndex:groupIndex,key:columnId,layerDatasourceDropProps:layerDatasourceDropProps,label:columnLabelMap[columnId],layerDatasource:layerDatasource,layerIndex:layerIndex,layerId:layerId,onDrop:onDrop},external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__dimension"},external_kbnSharedDeps_React_default.a.createElement(DimensionButton,{accessorConfig:accessorConfig,label:columnLabelMap[accessorConfig.columnId],group:group,onClick:id=>{setActiveDimension({isNew:false,activeGroup:group,activeId:id})},onRemoveClick:id=>{Object(lens_ui_telemetry["e"])("indexpattern_dimension_removed");props.updateAll(datasourceId,layerDatasource.removeColumn({layerId:layerId,columnId:id,prevState:layerDatasourceState}),activeVisualization.removeDimension({layerId:layerId,columnId:id,prevState:props.visualizationState}));removeButtonRef(id)}},external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:layerDatasource.renderDimensionTrigger,nativeProps:{...layerDatasourceConfigProps,columnId:accessorConfig.columnId,filterOperations:group.filterOperations}}))))})),group.supportsMoreColumns?external_kbnSharedDeps_React_default.a.createElement(EmptyDimensionButton,{group:group,groupIndex:groupIndex,layerId:layerId,layerIndex:layerIndex,layerDatasource:layerDatasource,layerDatasourceDropProps:layerDatasourceDropProps,onClick:id=>{setActiveDimension({activeGroup:group,activeId:id,isNew:true})},onDrop:onDrop}):null))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RemoveLayerButton,{onRemoveLayer:onRemoveLayer,layerIndex:layerIndex,isOnlyLayer:isOnlyLayer}))))),external_kbnSharedDeps_React_default.a.createElement(DimensionContainer,{isOpen:!!activeId,groupLabel:(activeGroup===null||activeGroup===void 0?void 0:activeGroup.groupLabel)||"",handleClose:()=>{if(layerDatasource.updateStateOnCloseDimension){const newState=layerDatasource.updateStateOnCloseDimension({state:layerDatasourceState,layerId:layerId,columnId:activeId});if(newState){props.updateDatasource(datasourceId,newState)}}setActiveDimension(initialActiveDimensionState)},panel:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,activeGroup&&activeId&&external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:layerDatasource.renderDimensionEditor,nativeProps:{...layerDatasourceConfigProps,core:props.core,columnId:activeId,filterOperations:activeGroup.filterOperations,dimensionGroups:groups,setState:(newState,{shouldReplaceDimension:shouldReplaceDimension,shouldRemoveDimension:shouldRemoveDimension}={})=>{if(shouldReplaceDimension||shouldRemoveDimension){props.updateAll(datasourceId,newState,shouldRemoveDimension?activeVisualization.removeDimension({layerId:layerId,columnId:activeId,prevState:props.visualizationState}):activeVisualization.setDimension({layerId:layerId,groupId:activeGroup.groupId,columnId:activeId,prevState:props.visualizationState}))}else{props.updateDatasource(datasourceId,newState)}setActiveDimension({...activeDimension,isNew:false})}}}),activeGroup&&activeId&&!activeDimension.isNew&&activeVisualization.renderDimensionEditor&&(activeGroup===null||activeGroup===void 0?void 0:activeGroup.enableDimensionEditor)&&external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsLayerPanel__styleEditor"},external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:activeVisualization.renderDimensionEditor,nativeProps:{...layerVisualizationConfigProps,groupId:activeGroup.groupId,accessor:activeId,setState:props.updateVisualization}})))}))}function removeLayer(opts){const{state:state,trackUiEvent:trackUiEvent,activeVisualization:activeVisualization,layerId:layerId,datasourceMap:datasourceMap}=opts;const isOnlyLayer=activeVisualization.getLayerIds(state.visualization.state).every(id=>id===opts.layerId);trackUiEvent(isOnlyLayer?"layer_cleared":"layer_removed");return{...state,datasourceStates:external_kbnSharedDeps_Lodash_default.a.mapValues(state.datasourceStates,(datasourceState,datasourceId)=>{const datasource=datasourceMap[datasourceId];return{...datasourceState,state:isOnlyLayer?datasource.clearLayer(datasourceState.state,layerId):datasource.removeLayer(datasourceState.state,layerId)}}),visualization:{...state.visualization,state:isOnlyLayer||!activeVisualization.removeLayer?activeVisualization.clearLayer(state.visualization.state,layerId):activeVisualization.removeLayer(state.visualization.state,layerId)},stagedPreview:undefined}}function appendLayer({trackUiEvent:trackUiEvent,activeVisualization:activeVisualization,state:state,generateId:generateId,activeDatasource:activeDatasource}){trackUiEvent("layer_added");if(!activeVisualization.appendLayer){return state}const layerId=generateId();return{...state,datasourceStates:{...state.datasourceStates,[activeDatasource.id]:{...state.datasourceStates[activeDatasource.id],state:activeDatasource.insertLayer(state.datasourceStates[activeDatasource.id].state,layerId)}},visualization:{...state.visualization,state:activeVisualization.appendLayer(state.visualization.state,layerId)},stagedPreview:undefined}}function config_panel_extends(){config_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return config_panel_extends.apply(this,arguments)}const config_panel_ConfigPanelWrapper=Object(external_kbnSharedDeps_React_["memo"])((function ConfigPanelWrapper(props){const activeVisualization=props.visualizationMap[props.activeVisualizationId||""];const{visualizationState:visualizationState}=props;return activeVisualization&&visualizationState?external_kbnSharedDeps_React_default.a.createElement(LayerPanels,config_panel_extends({},props,{activeVisualization:activeVisualization})):null}));function LayerPanels(props){const{activeVisualization:activeVisualization,visualizationState:visualizationState,dispatch:dispatch,activeDatasourceId:activeDatasourceId,datasourceMap:datasourceMap}=props;const layerIds=activeVisualization.getLayerIds(visualizationState);const{setNextFocusedId:setNextFocusedLayerId,removeRef:removeLayerRef,registerNewRef:registerNewLayerRef}=useFocusUpdate(layerIds);const setVisualizationState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>newState=>{dispatch({type:"UPDATE_VISUALIZATION_STATE",visualizationId:activeVisualization.id,updater:newState,clearStagedPreview:false})},[dispatch,activeVisualization]);const updateDatasource=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(datasourceId,newState)=>{dispatch({type:"UPDATE_DATASOURCE_STATE",updater:()=>newState,datasourceId:datasourceId,clearStagedPreview:false})},[dispatch]);const updateAll=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(datasourceId,newDatasourceState,newVisualizationState)=>{dispatch({type:"UPDATE_STATE",subType:"UPDATE_ALL_STATES",updater:prevState=>({...prevState,datasourceStates:{...prevState.datasourceStates,[datasourceId]:{state:newDatasourceState,isLoading:false}},visualization:{...prevState.visualization,state:newVisualizationState},stagedPreview:undefined})})},[dispatch]);const datasourcePublicAPIs=props.framePublicAPI.datasourceLayers;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{className:"lnsConfigPanel"},layerIds.map((layerId,layerIndex)=>datasourcePublicAPIs[layerId]?external_kbnSharedDeps_React_default.a.createElement(layer_panel_LayerPanel,config_panel_extends({},props,{activeVisualization:activeVisualization,registerNewLayerRef:registerNewLayerRef,key:layerId,layerId:layerId,layerIndex:layerIndex,visualizationState:visualizationState,updateVisualization:setVisualizationState,updateDatasource:updateDatasource,updateAll:updateAll,isOnlyLayer:layerIds.length===1,onRemoveLayer:()=>{dispatch({type:"UPDATE_STATE",subType:"REMOVE_OR_CLEAR_LAYER",updater:state=>removeLayer({activeVisualization:activeVisualization,layerId:layerId,trackUiEvent:lens_ui_telemetry["e"],datasourceMap:datasourceMap,state:state})});removeLayerRef(layerId)}})):null),activeVisualization.appendLayer&&visualizationState&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{className:"eui-fullWidth",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.addLayer",{defaultMessage:"Add a layer"}),content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.addLayerTooltip",{defaultMessage:"Use multiple layers to combine chart types or visualize different index patterns."}),position:"bottom"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{className:"lnsConfigPanel__addLayerBtn",fullWidth:true,size:"s","data-test-subj":"lnsLayerAddButton","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.xyChart.addLayerButton",{defaultMessage:"Add layer"}),onClick:()=>{const id=generateId();dispatch({type:"UPDATE_STATE",subType:"ADD_LAYER",updater:state=>appendLayer({activeVisualization:activeVisualization,generateId:()=>id,trackUiEvent:lens_ui_telemetry["e"],activeDatasource:datasourceMap[activeDatasourceId],state:state})});setNextFocusedLayerId(id)},iconType:"plusInCircleFilled"}))))}var frame_layout=__webpack_require__(252);function FrameLayout(props){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],{className:"lnsFrameLayout"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],{restrictWidth:false,className:"lnsFrameLayout__pageContent","aria-labelledby":"lns_ChartTitle"},external_kbnSharedDeps_React_default.a.createElement("section",{className:"lnsFrameLayout__sidebar","aria-labelledby":"dataPanelId"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("h2",{id:"dataPanelId"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.section.dataPanelLabel",{defaultMessage:"Data panel"}))),props.dataPanel),external_kbnSharedDeps_React_default.a.createElement("section",{className:"lnsFrameLayout__pageBody","aria-labelledby":"workspaceId"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("h2",{id:"workspaceId"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.section.workspaceLabel",{defaultMessage:"Visualization workspace"}))),props.workspacePanel,props.suggestionsPanel),external_kbnSharedDeps_React_default.a.createElement("section",{className:"lnsFrameLayout__sidebar lnsFrameLayout__sidebar--right","aria-labelledby":"configPanel"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("h2",{id:"configPanel"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.section.configPanelLabel",{defaultMessage:"Config panel"}))),props.configPanel)))}var suggestion_panel=__webpack_require__(261);var target_common=__webpack_require__(39);function suggestion_helpers_getSuggestions({datasourceMap:datasourceMap,datasourceStates:datasourceStates,visualizationMap:visualizationMap,activeVisualizationId:activeVisualizationId,subVisualizationId:subVisualizationId,visualizationState:visualizationState,field:field,visualizeTriggerFieldContext:visualizeTriggerFieldContext,activeData:activeData,mainPalette:mainPalette}){const datasources=Object.entries(datasourceMap).filter(([datasourceId])=>datasourceStates[datasourceId]&&!datasourceStates[datasourceId].isLoading);const datasourceTableSuggestions=external_kbnSharedDeps_Lodash_default.a.flatten(datasources.map(([datasourceId,datasource])=>{const datasourceState=datasourceStates[datasourceId].state;let dataSourceSuggestions;if(visualizeTriggerFieldContext){dataSourceSuggestions=datasource.getDatasourceSuggestionsForVisualizeField(datasourceState,visualizeTriggerFieldContext.indexPatternId,visualizeTriggerFieldContext.fieldName)}else if(field){dataSourceSuggestions=datasource.getDatasourceSuggestionsForField(datasourceState,field)}else{dataSourceSuggestions=datasource.getDatasourceSuggestionsFromCurrentState(datasourceState,activeData)}return dataSourceSuggestions.map(suggestion=>({...suggestion,datasourceId:datasourceId}))}));return external_kbnSharedDeps_Lodash_default.a.flatten(Object.entries(visualizationMap).map(([visualizationId,visualization])=>external_kbnSharedDeps_Lodash_default.a.flatten(datasourceTableSuggestions.map(datasourceSuggestion=>{const table=datasourceSuggestion.table;const currentVisualizationState=visualizationId===activeVisualizationId?visualizationState:undefined;const palette=mainPalette||(activeVisualizationId&&visualizationMap[activeVisualizationId]&&visualizationMap[activeVisualizationId].getMainPalette?visualizationMap[activeVisualizationId].getMainPalette(visualizationState):undefined);return getVisualizationSuggestions(visualization,table,visualizationId,datasourceSuggestion,currentVisualizationState,subVisualizationId,palette)})))).sort((a,b)=>b.score-a.score)}function applyVisualizeFieldSuggestions({datasourceMap:datasourceMap,datasourceStates:datasourceStates,visualizationMap:visualizationMap,activeVisualizationId:activeVisualizationId,visualizationState:visualizationState,visualizeTriggerFieldContext:visualizeTriggerFieldContext,dispatch:dispatch}){const suggestions=suggestion_helpers_getSuggestions({datasourceMap:datasourceMap,datasourceStates:datasourceStates,visualizationMap:visualizationMap,activeVisualizationId:activeVisualizationId,visualizationState:visualizationState,visualizeTriggerFieldContext:visualizeTriggerFieldContext});if(suggestions.length){const selectedSuggestion=suggestions.find(s=>s.visualizationId===activeVisualizationId)||suggestions[0];switchToSuggestion(dispatch,selectedSuggestion,"SWITCH_VISUALIZATION")}}function getVisualizationSuggestions(visualization,table,visualizationId,datasourceSuggestion,currentVisualizationState,subVisualizationId,mainPalette){return visualization.getSuggestions({table:table,state:currentVisualizationState,keptLayerIds:datasourceSuggestion.keptLayerIds,subVisualizationId:subVisualizationId,mainPalette:mainPalette}).map(({state:state,...visualizationSuggestion})=>({...visualizationSuggestion,visualizationId:visualizationId,visualizationState:state,keptLayerIds:datasourceSuggestion.keptLayerIds,datasourceState:datasourceSuggestion.state,datasourceId:datasourceSuggestion.datasourceId,columns:table.columns.length,changeType:table.changeType}))}function switchToSuggestion(dispatch,suggestion,type="SELECT_SUGGESTION"){const action={type:type,newVisualizationId:suggestion.visualizationId,initialState:suggestion.visualizationState,datasourceState:suggestion.datasourceState,datasourceId:suggestion.datasourceId};dispatch(action)}function getTopSuggestionForField(datasourceLayers,activeVisualizationId,visualizationMap,visualizationState,datasource,datasourceStates,field){var _visualizationMap$act,_visualizationMap$act2,_visualizationMap$act3;const hasData=Object.values(datasourceLayers).some(datasourceLayer=>datasourceLayer.getTableSpec().length>0);const mainPalette=activeVisualizationId&&(_visualizationMap$act=visualizationMap[activeVisualizationId])!==null&&_visualizationMap$act!==void 0&&_visualizationMap$act.getMainPalette?(_visualizationMap$act2=(_visualizationMap$act3=visualizationMap[activeVisualizationId]).getMainPalette)===null||_visualizationMap$act2===void 0?void 0:_visualizationMap$act2.call(_visualizationMap$act3,visualizationState):undefined;const suggestions=suggestion_helpers_getSuggestions({datasourceMap:{[datasource.id]:datasource},datasourceStates:datasourceStates,visualizationMap:hasData&&activeVisualizationId?{[activeVisualizationId]:visualizationMap[activeVisualizationId]}:visualizationMap,activeVisualizationId:activeVisualizationId,visualizationState:visualizationState,field:field,mainPalette:mainPalette});return suggestions.find(s=>s.visualizationId===activeVisualizationId)||suggestions[0]}function prependDatasourceExpression(visualizationExpression,datasourceMap,datasourceStates){const datasourceExpressions=[];Object.entries(datasourceMap).forEach(([datasourceId,datasource])=>{const state=datasourceStates[datasourceId].state;const layers=datasource.getLayers(datasourceStates[datasourceId].state);layers.forEach(layerId=>{const result=datasource.toExpression(state,layerId);if(result){datasourceExpressions.push([layerId,result])}})});if(datasourceExpressions.length===0||visualizationExpression===null){return null}const parsedDatasourceExpressions=datasourceExpressions.map(([layerId,expr])=>[layerId,typeof expr==="string"?Object(target_common["fromExpression"])(expr):expr]);const datafetchExpression={type:"function",function:"lens_merge_tables",arguments:{layerIds:parsedDatasourceExpressions.map(([id])=>id),tables:parsedDatasourceExpressions.map(([id,expr])=>expr)}};const parsedVisualizationExpression=typeof visualizationExpression==="string"?Object(target_common["fromExpression"])(visualizationExpression):visualizationExpression;return{type:"expression",chain:[{type:"function",function:"kibana",arguments:{}},datafetchExpression,...parsedVisualizationExpression.chain]}}function expression_helpers_buildExpression({visualization:visualization,visualizationState:visualizationState,datasourceMap:datasourceMap,datasourceStates:datasourceStates,datasourceLayers:datasourceLayers,title:title,description:description}){if(visualization===null){return null}const visualizationExpression=visualization.toExpression(visualizationState,datasourceLayers,{title:title,description:description});const completeExpression=prependDatasourceExpression(visualizationExpression,datasourceMap,datasourceStates);return completeExpression}const isRequestError=e=>{if("body"in e){var _e$body,_e$body$attributes,_e$body$attributes$er;return((_e$body=e.body)===null||_e$body===void 0?void 0:(_e$body$attributes=_e$body.attributes)===null||_e$body$attributes===void 0?void 0:(_e$body$attributes$er=_e$body$attributes.error)===null||_e$body$attributes$er===void 0?void 0:_e$body$attributes$er.caused_by)!==undefined}return false};function getNestedErrorClause({type:type,reason:reason,caused_by:causedBy}){if(causedBy){return getNestedErrorClause(causedBy)}return{type:type,reason:reason}}function getOriginalRequestErrorMessage(error){if(error&&"original"in error&&error.original&&isRequestError(error.original)){const rootError=getNestedErrorClause(error.original.body.attributes.error);if(rootError.reason&&rootError.type){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.expressionFailureMessage",{defaultMessage:"Request error: {type}, {reason}",values:{reason:rootError.reason,type:rootError.type}})}}}function getMissingVisualizationTypeError(){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.expressionMissingVisualizationType",{defaultMessage:"Visualization type not found."})}function getMissingCurrentDatasource(){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.expressionMissingDatasource",{defaultMessage:"Could not find datasource for the visualization"})}async function initializeDatasources(datasourceMap,datasourceStates,references,initialContext,options){const states={};await Promise.all(Object.entries(datasourceMap).map(([datasourceId,datasource])=>{if(datasourceStates[datasourceId]){return datasource.initialize(datasourceStates[datasourceId].state||undefined,references,initialContext,options).then(datasourceState=>{states[datasourceId]={isLoading:false,state:datasourceState}})}}));return states}function createDatasourceLayers(datasourceMap,datasourceStates){const datasourceLayers={};Object.keys(datasourceMap).filter(id=>datasourceStates[id]&&!datasourceStates[id].isLoading).forEach(id=>{const datasourceState=datasourceStates[id].state;const datasource=datasourceMap[id];const layers=datasource.getLayers(datasourceState);layers.forEach(layer=>{datasourceLayers[layer]=datasourceMap[id].getPublicAPI({state:datasourceState,layerId:layer})})});return datasourceLayers}async function persistedStateToExpression(datasources,visualizations,doc){const{state:{visualization:visualizationState,datasourceStates:persistedDatasourceStates},visualizationType:visualizationType,references:references,title:title,description:description}=doc;if(!visualizationType){return{ast:null,errors:[{shortMessage:"",longMessage:getMissingVisualizationTypeError()}]}}const visualization=visualizations[visualizationType];const datasourceStates=await initializeDatasources(datasources,Object.fromEntries(Object.entries(persistedDatasourceStates).map(([id,state])=>[id,{isLoading:false,state:state}])),references,undefined,{isFullEditor:false});const datasourceLayers=createDatasourceLayers(datasources,datasourceStates);const datasourceId=getActiveDatasourceIdFromDoc(doc);if(datasourceId==null){return{ast:null,errors:[{shortMessage:"",longMessage:getMissingCurrentDatasource()}]}}const validationResult=validateDatasourceAndVisualization(datasources[datasourceId],datasourceStates[datasourceId].state,visualization,visualizationState,{datasourceLayers:datasourceLayers});return{ast:expression_helpers_buildExpression({title:title,description:description,visualization:visualization,visualizationState:visualizationState,datasourceMap:datasources,datasourceStates:datasourceStates,datasourceLayers:datasourceLayers}),errors:validationResult}}const validateDatasourceAndVisualization=(currentDataSource,currentDatasourceState,currentVisualization,currentVisualizationState,frameAPI)=>{const layersGroups=currentVisualizationState?currentVisualization===null||currentVisualization===void 0?void 0:currentVisualization.getLayerIds(currentVisualizationState).reduce((memo,layerId)=>{const groups=currentVisualization===null||currentVisualization===void 0?void 0:currentVisualization.getConfiguration({frame:frameAPI,layerId:layerId,state:currentVisualizationState}).groups;if(groups){memo[layerId]=groups}return memo},{}):undefined;const datasourceValidationErrors=currentDatasourceState?currentDataSource===null||currentDataSource===void 0?void 0:currentDataSource.getErrorMessages(currentDatasourceState,layersGroups):undefined;const visualizationValidationErrors=currentVisualizationState?currentVisualization===null||currentVisualization===void 0?void 0:currentVisualization.getErrorMessages(currentVisualizationState):undefined;if(datasourceValidationErrors!==null&&datasourceValidationErrors!==void 0&&datasourceValidationErrors.length||visualizationValidationErrors!==null&&visualizationValidationErrors!==void 0&&visualizationValidationErrors.length){return[...datasourceValidationErrors||[],...visualizationValidationErrors||[]]}return undefined};function suggestion_panel_extends(){suggestion_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return suggestion_panel_extends.apply(this,arguments)}const MAX_SUGGESTIONS_DISPLAYED=5;const PreviewRenderer=({withLabel:withLabel,ExpressionRendererComponent:ExpressionRendererComponent,expression:expression,hasError:hasError})=>{const onErrorMessage=external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsSuggestionPanel__suggestionIcon"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{size:"xl",color:"danger",type:"alert","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.previewErrorLabel",{defaultMessage:"Preview rendering failed"}),content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.previewErrorLabel",{defaultMessage:"Preview rendering failed"})}));return external_kbnSharedDeps_React_default.a.createElement("div",{className:classnames_default()("lnsSuggestionPanel__chartWrapper",{"lnsSuggestionPanel__chartWrapper--withLabel":withLabel})},!expression||hasError?onErrorMessage:external_kbnSharedDeps_React_default.a.createElement(ExpressionRendererComponent,{className:"lnsSuggestionPanel__expressionRenderer",padding:"s",expression:expression,debounce:2e3,renderError:()=>onErrorMessage}))};const SuggestionPreview=({preview:preview,ExpressionRenderer:ExpressionRendererComponent,selected:selected,onSelect:onSelect,showTitleAsLabel:showTitleAsLabel})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:preview.title},external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":`lnsSuggestion-${Object(external_kbnSharedDeps_Lodash_["camelCase"])(preview.title)}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{className:classnames_default()("lnsSuggestionPanel__button",{"lnsSuggestionPanel__button-isSelected":selected}),paddingSize:"none","data-test-subj":"lnsSuggestion",onClick:onSelect,"aria-current":!!selected,"aria-label":preview.title},preview.expression||preview.error?external_kbnSharedDeps_React_default.a.createElement(PreviewRenderer,{ExpressionRendererComponent:ExpressionRendererComponent,expression:preview.expression&&Object(target_common["toExpression"])(preview.expression),withLabel:Boolean(showTitleAsLabel),hasError:Boolean(preview.error)}):external_kbnSharedDeps_React_default.a.createElement("span",{className:"lnsSuggestionPanel__suggestionIcon"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"xxl",type:preview.icon})),showTitleAsLabel&&external_kbnSharedDeps_React_default.a.createElement("span",{className:"lnsSuggestionPanel__buttonLabel"},preview.title))));function SuggestionPanel({activeDatasourceId:activeDatasourceId,datasourceMap:datasourceMap,datasourceStates:datasourceStates,activeVisualizationId:activeVisualizationId,visualizationMap:visualizationMap,visualizationState:visualizationState,dispatch:dispatch,frame:frame,ExpressionRenderer:ExpressionRendererComponent,stagedPreview:stagedPreview,plugins:plugins}){const currentDatasourceStates=stagedPreview?stagedPreview.datasourceStates:datasourceStates;const currentVisualizationState=stagedPreview?stagedPreview.visualization.state:visualizationState;const currentVisualizationId=stagedPreview?stagedPreview.visualization.activeId:activeVisualizationId;const{suggestions:suggestions,currentStateExpression:currentStateExpression,currentStateError:currentStateError}=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _currentDatasourceSta;const newSuggestions=suggestion_helpers_getSuggestions({datasourceMap:datasourceMap,datasourceStates:currentDatasourceStates,visualizationMap:visualizationMap,activeVisualizationId:currentVisualizationId,visualizationState:currentVisualizationState,activeData:frame.activeData}).filter(suggestion=>!suggestion.hide).filter(({visualizationId:visualizationId,visualizationState:suggestionVisualizationState,datasourceState:suggestionDatasourceState,datasourceId:suggetionDatasourceId})=>validateDatasourceAndVisualization(suggetionDatasourceId?datasourceMap[suggetionDatasourceId]:null,suggestionDatasourceState,visualizationMap[visualizationId],suggestionVisualizationState,frame)==null).slice(0,MAX_SUGGESTIONS_DISPLAYED).map(suggestion=>({...suggestion,previewExpression:preparePreviewExpression(suggestion,visualizationMap[suggestion.visualizationId],datasourceMap,currentDatasourceStates,frame)}));const validationErrors=validateDatasourceAndVisualization(activeDatasourceId?datasourceMap[activeDatasourceId]:null,activeDatasourceId&&((_currentDatasourceSta=currentDatasourceStates[activeDatasourceId])===null||_currentDatasourceSta===void 0?void 0:_currentDatasourceSta.state),currentVisualizationId?visualizationMap[currentVisualizationId]:null,currentVisualizationState,frame);const newStateExpression=currentVisualizationState&&currentVisualizationId&&!validationErrors?preparePreviewExpression({visualizationState:currentVisualizationState},visualizationMap[currentVisualizationId],datasourceMap,currentDatasourceStates,frame):undefined;return{suggestions:newSuggestions,currentStateExpression:newStateExpression,currentStateError:validationErrors}},[currentDatasourceStates,currentVisualizationState,currentVisualizationId,activeDatasourceId,datasourceMap,visualizationMap]);const context=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({query:frame.query,timeRange:{from:frame.dateRange.fromDate,to:frame.dateRange.toDate},filters:frame.filters}),[frame.query,frame.dateRange.fromDate,frame.dateRange.toDate,frame.filters]);const contextRef=Object(external_kbnSharedDeps_React_["useRef"])(context);contextRef.current=context;const sessionIdRef=Object(external_kbnSharedDeps_React_["useRef"])(frame.searchSessionId);sessionIdRef.current=frame.searchSessionId;const AutoRefreshExpressionRenderer=Object(external_kbnSharedDeps_React_["useMemo"])(()=>props=>external_kbnSharedDeps_React_default.a.createElement(ExpressionRendererComponent,suggestion_panel_extends({},props,{searchContext:contextRef.current,searchSessionId:sessionIdRef.current})),[ExpressionRendererComponent]);const[lastSelectedSuggestion,setLastSelectedSuggestion]=Object(external_kbnSharedDeps_React_["useState"])(-1);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!stagedPreview&&lastSelectedSuggestion!==-1){setLastSelectedSuggestion(-1)}},[stagedPreview]);if(!activeDatasourceId){return null}if(suggestions.length===0){return null}function rollbackToCurrentVisualization(){if(lastSelectedSuggestion!==-1){Object(lens_ui_telemetry["d"])("back_to_current");setLastSelectedSuggestion(-1);dispatch({type:"ROLLBACK_SUGGESTION"})}}return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsSuggestionPanel"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{className:"lnsSuggestionPanel__title",size:"xxs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.editorFrame.suggestionPanelTitle",defaultMessage:"Suggestions"})))),stagedPreview&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.suggestion.refreshSuggestionTooltip",{defaultMessage:"Refresh the suggestions based on the selected visualization."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"lensSubmitSuggestion",size:"xs",iconType:"refresh",onClick:()=>{Object(lens_ui_telemetry["e"])("suggestion_confirmed");dispatch({type:"SUBMIT_SUGGESTION"})}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.sugegstion.refreshSuggestionLabel",{defaultMessage:"Refresh"}))))),external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsSuggestionPanel__suggestions"},currentVisualizationId&&external_kbnSharedDeps_React_default.a.createElement(SuggestionPreview,{preview:{error:currentStateError!=null,expression:currentStateExpression,icon:visualizationMap[currentVisualizationId].getDescription(currentVisualizationState).icon||"empty",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.suggestions.currentVisLabel",{defaultMessage:"Current visualization"})},ExpressionRenderer:AutoRefreshExpressionRenderer,onSelect:rollbackToCurrentVisualization,selected:lastSelectedSuggestion===-1,showTitleAsLabel:true}),suggestions.map((suggestion,index)=>external_kbnSharedDeps_React_default.a.createElement(SuggestionPreview,{preview:{expression:suggestion.previewExpression,icon:suggestion.previewIcon,title:suggestion.title},ExpressionRenderer:AutoRefreshExpressionRenderer,key:index,onSelect:()=>{Object(lens_ui_telemetry["e"])("suggestion_clicked");if(lastSelectedSuggestion===index){rollbackToCurrentVisualization()}else{setLastSelectedSuggestion(index);switchToSuggestion(dispatch,suggestion)}},selected:index===lastSelectedSuggestion}))))}function getPreviewExpression(visualizableState,visualization,datasources,frame){if(!visualization.toPreviewExpression){return null}const suggestionFrameApi={...frame,datasourceLayers:{...frame.datasourceLayers}};if(visualizableState.keptLayerIds&&visualizableState.datasourceId&&visualizableState.datasourceState){const datasource=datasources[visualizableState.datasourceId];const datasourceState=visualizableState.datasourceState;const updatedLayerApis=external_kbnSharedDeps_Lodash_default.a.pick(frame.datasourceLayers,visualizableState.keptLayerIds);const changedLayers=datasource.getLayers(visualizableState.datasourceState);changedLayers.forEach(layerId=>{if(updatedLayerApis[layerId]){updatedLayerApis[layerId]=datasource.getPublicAPI({layerId:layerId,state:datasourceState})}})}return visualization.toPreviewExpression(visualizableState.visualizationState,suggestionFrameApi.datasourceLayers)}function preparePreviewExpression(visualizableState,visualization,datasourceMap,datasourceStates,framePublicAPI){const suggestionDatasourceId=visualizableState.datasourceId;const suggestionDatasourceState=visualizableState.datasourceState;const expression=getPreviewExpression(visualizableState,visualization,datasourceMap,framePublicAPI);if(!expression){return}const expressionWithDatasource=prependDatasourceExpression(expression,datasourceMap,suggestionDatasourceId?{...datasourceStates,[suggestionDatasourceId]:{isLoading:false,state:suggestionDatasourceState}}:datasourceStates);return expressionWithDatasource}var visualizations_public_=__webpack_require__(28);var workspace_panel_wrapper=__webpack_require__(52);var chart_switch=__webpack_require__(285);function VisualizationSummary(props){const visualization=props.visualizationMap[props.visualizationId||""];if(!visualization){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configPanel.selectVisualization",{defaultMessage:"Select a visualization"}))}const description=visualization.getDescription(props.visualizationState);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,description.icon&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"l",className:"lnsChartSwitch__summaryIcon",type:description.icon}),description.label)}const chart_switch_ChartSwitch=Object(external_kbnSharedDeps_React_["memo"])((function ChartSwitch(props){const[flyoutOpen,setFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const commitSelection=selection=>{setFlyoutOpen(false);Object(lens_ui_telemetry["e"])(`chart_switch`);switchToSuggestion(props.dispatch,{...selection,visualizationState:selection.getVisualizationState()},"SWITCH_VISUALIZATION");if(!selection.datasourceId&&!selection.sameDatasources||selection.dataLoss==="everything"){props.framePublicAPI.removeLayers(Object.keys(props.framePublicAPI.datasourceLayers))}};function getSelection(visualizationId,subVisualizationId){const newVisualization=props.visualizationMap[visualizationId];const switchVisType=props.visualizationMap[visualizationId].switchVisualizationType||((_type,initialState)=>initialState);const layers=Object.entries(props.framePublicAPI.datasourceLayers);const containsData=layers.some(([_layerId,datasource])=>datasource.getTableSpec().length>0);if(props.visualizationId===visualizationId&&props.visualizationState&&newVisualization.getVisualizationTypeId(props.visualizationState)===subVisualizationId){return{visualizationId:visualizationId,subVisualizationId:subVisualizationId,dataLoss:"nothing",keptLayerIds:Object.keys(props.framePublicAPI.datasourceLayers),getVisualizationState:()=>switchVisType(subVisualizationId,props.visualizationState),sameDatasources:true}}const topSuggestion=getTopSuggestion(props,visualizationId,newVisualization,subVisualizationId);let dataLoss;if(!containsData){dataLoss="nothing"}else if(!topSuggestion){dataLoss="everything"}else if(layers.length>1&&layers.length!==topSuggestion.keptLayerIds.length){dataLoss="layers"}else if(topSuggestion.columns!==layers[0][1].getTableSpec().length){dataLoss="columns"}else{dataLoss="nothing"}return{visualizationId:visualizationId,subVisualizationId:subVisualizationId,dataLoss:dataLoss,getVisualizationState:topSuggestion?()=>switchVisType(subVisualizationId,newVisualization.initialize(props.framePublicAPI,topSuggestion.visualizationState)):()=>switchVisType(subVisualizationId,newVisualization.initialize(props.framePublicAPI,props.visualizationId===newVisualization.id?props.visualizationState:undefined,props.visualizationId&&props.visualizationMap[props.visualizationId].getMainPalette?props.visualizationMap[props.visualizationId].getMainPalette(props.visualizationState):undefined)),keptLayerIds:topSuggestion?topSuggestion.keptLayerIds:[],datasourceState:topSuggestion?topSuggestion.datasourceState:undefined,datasourceId:topSuggestion?topSuggestion.datasourceId:undefined,sameDatasources:dataLoss==="nothing"&&props.visualizationId===newVisualization.id}}const[searchTerm,setSearchTerm]=Object(external_kbnSharedDeps_React_["useState"])("");const visualizationTypes=Object(external_kbnSharedDeps_React_["useMemo"])(()=>flyoutOpen&&Object(external_kbnSharedDeps_Lodash_["flatten"])(Object.values(props.visualizationMap).map(v=>v.visualizationTypes.map(t=>({visualizationId:v.id,...t,icon:t.icon})))).filter(visualizationType=>visualizationType.label.toLowerCase().includes(searchTerm.toLowerCase())||visualizationType.fullLabel&&visualizationType.fullLabel.toLowerCase().includes(searchTerm.toLowerCase())).map(visualizationType=>({...visualizationType,selection:getSelection(visualizationType.visualizationId,visualizationType.id)})),[flyoutOpen,props.visualizationMap,props.framePublicAPI,props.visualizationId,props.visualizationState,searchTerm]);const popover=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"lnsChartSwitchPopover",ownFocus:true,initialFocus:".lnsChartSwitch__popoverPanel",panelClassName:"lnsChartSwitch__popoverPanel",panelPaddingSize:"s",button:external_kbnSharedDeps_React_default.a.createElement(public_["ToolbarButton"],{onClick:()=>setFlyoutOpen(!flyoutOpen),"data-test-subj":"lnsChartSwitchPopover",fontWeight:"bold"},external_kbnSharedDeps_React_default.a.createElement(VisualizationSummary,props)),isOpen:flyoutOpen,closePopover:()=>setFlyoutOpen(false),anchorPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.configPanel.chartType",{defaultMessage:"Chart type"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{compressed:true,fullWidth:false,className:"lnsChartSwitch__search",value:searchTerm,"data-test-subj":"lnsChartSwitchSearch",onChange:e=>setSearchTerm(e.target.value)})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiKeyPadMenu"],null,(visualizationTypes||[]).map(v=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiKeyPadMenuItem"],{key:`${v.visualizationId}:${v.id}`,label:external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":"visTypeTitle"},v.label),title:v.fullLabel,role:"menuitem","data-test-subj":`lnsChartSwitchPopover_${v.id}`,onClick:()=>commitSelection(v.selection),betaBadgeLabel:v.selection.dataLoss!=="nothing"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.chartSwitch.dataLossLabel",{defaultMessage:"Data loss"}):undefined,betaBadgeTooltipContent:v.selection.dataLoss!=="nothing"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.chartSwitch.dataLossDescription",{defaultMessage:"Switching to this chart will lose some of the configuration"}):undefined,betaBadgeIconType:v.selection.dataLoss!=="nothing"?"alert":undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{className:"lnsChartSwitch__chartIcon",type:v.icon||"empty",size:"l"})))),searchTerm&&(visualizationTypes||[]).length===0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectableMessage"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.chartSwitch.noResults",defaultMessage:"No results found for {term}.",values:{term:external_kbnSharedDeps_React_default.a.createElement("strong",null,searchTerm)}})));return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsChartSwitch__header"},popover)}));function getTopSuggestion(props,visualizationId,newVisualization,subVisualizationId){const mainPalette=props.visualizationId&&props.visualizationMap[props.visualizationId]&&props.visualizationMap[props.visualizationId].getMainPalette?props.visualizationMap[props.visualizationId].getMainPalette(props.visualizationState):undefined;const unfilteredSuggestions=suggestion_helpers_getSuggestions({datasourceMap:props.datasourceMap,datasourceStates:props.datasourceStates,visualizationMap:{[visualizationId]:newVisualization},activeVisualizationId:props.visualizationId,visualizationState:props.visualizationState,subVisualizationId:subVisualizationId,activeData:props.framePublicAPI.activeData,mainPalette:mainPalette});const suggestions=unfilteredSuggestions.filter(suggestion=>suggestion.changeType!=="extended"&&newVisualization.getVisualizationTypeId(suggestion.visualizationState)===subVisualizationId);return suggestions.find(s=>s.changeType==="unchanged")||suggestions.find(s=>s.changeType==="reduced")||suggestions[0]}var warnings_popover=__webpack_require__(294);const WarningsPopover=({children:children})=>{const[isPopoverOpen,setIsPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);if(!children){return null}const onButtonClick=()=>setIsPopoverOpen(isOpen=>!isOpen);const closePopover=()=>setIsPopoverOpen(false);const warningsCount=external_kbnSharedDeps_React_default.a.Children.count(children);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{panelPaddingSize:"none",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onButtonClick,iconType:"alert",className:"lnsWorkspaceWarning__button"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.chartWarnings.number",{defaultMessage:`{warningsCount} {warningsCount, plural, one {warning} other {warnings}}`,values:{warningsCount:warningsCount}})),isOpen:isPopoverOpen,closePopover:closePopover},external_kbnSharedDeps_React_default.a.createElement("ul",{className:"lnsWorkspaceWarningList"},external_kbnSharedDeps_React_default.a.Children.map(children,(child,index)=>external_kbnSharedDeps_React_default.a.createElement("li",{key:index,className:"lnsWorkspaceWarningList__item"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},child)))))};function WorkspacePanelWrapper({children:children,framePublicAPI:framePublicAPI,visualizationState:visualizationState,dispatch:dispatch,title:title,visualizationId:visualizationId,visualizationMap:visualizationMap,datasourceMap:datasourceMap,datasourceStates:datasourceStates}){const activeVisualization=visualizationId?visualizationMap[visualizationId]:null;const setVisualizationState=Object(external_kbnSharedDeps_React_["useCallback"])(newState=>{if(!activeVisualization){return}dispatch({type:"UPDATE_VISUALIZATION_STATE",visualizationId:activeVisualization.id,updater:newState,clearStagedPreview:false})},[dispatch,activeVisualization]);const warningMessages=(activeVisualization===null||activeVisualization===void 0?void 0:activeVisualization.getWarningMessages)&&activeVisualization.getWarningMessages(visualizationState,framePublicAPI);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m",direction:"row",responsive:false,wrap:true,justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",direction:"row",responsive:false,wrap:true,className:"lnsWorkspacePanelWrapper__toolbar"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(chart_switch_ChartSwitch,{"data-test-subj":"lnsChartSwitcher",visualizationMap:visualizationMap,visualizationId:visualizationId,visualizationState:visualizationState,datasourceMap:datasourceMap,datasourceStates:datasourceStates,dispatch:dispatch,framePublicAPI:framePublicAPI})),activeVisualization&&activeVisualization.renderToolbar&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{render:activeVisualization.renderToolbar,nativeProps:{frame:framePublicAPI,state:visualizationState,setState:setVisualizationState}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},warningMessages&&warningMessages.length?external_kbnSharedDeps_React_default.a.createElement(WarningsPopover,null,warningMessages):null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{className:"lnsWorkspacePanelWrapper"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiScreenReaderOnly"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{id:"lns_ChartTitle","data-test-subj":"lns_ChartTitle"},title||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.chartTitle.unsaved",{defaultMessage:"Unsaved visualization"}))),children))}function drop_illustration_extends(){drop_illustration_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return drop_illustration_extends.apply(this,arguments)}const DropIllustration=({title:title,titleId:titleId,...props})=>external_kbnSharedDeps_React_["createElement"]("svg",drop_illustration_extends({width:176,height:176,viewBox:"0 0 176 176",fill:"none",xmlns:"http://www.w3.org/2000/svg","aria-labelledby":titleId},props),title?external_kbnSharedDeps_React_["createElement"]("title",{id:titleId},title):null,external_kbnSharedDeps_React_["createElement"]("path",{d:"M122.155 89.485H12.389v40.796h109.766V89.485z",fill:"#58C5A7"}),external_kbnSharedDeps_React_["createElement"]("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M19.471 91.253c.358-.28.786-.454 1.236-.503A1.664 1.664 0 0122 92.647a1.842 1.842 0 01-1.801 1.375 1.65 1.65 0 01-1.513-1.69c.156-.426.428-.8.785-1.08zm-6.188 3.1c.137 0 .618-.07.646-.275.027-.207-.358-.482-.509-.496a.482.482 0 00-.495.317c-.041.22.206.412.357.454zm-.908 5.197v1.952c.097.108.22.188.357.234a1.156 1.156 0 001.376-1.086c.096-.536-.372-1.018-1.142-1.141-.197-.03-.4-.016-.591.041zm34.375 9.213a.797.797 0 00-.921.371c-.385.619-.33.921.275 1.54-.041.549-.041 1.101 0 1.65a.548.548 0 00.376.522.557.557 0 00.614-.192c.076-.103.16-.203.245-.304.314-.373.64-.759.607-1.332l-.591-.605c.041-.798-.192-1.527-.605-1.65zm-33.096 5.211a.727.727 0 00-.646-.88 2.289 2.289 0 00-.62 0v2.131h.152a.715.715 0 00-.165.275v.468a.44.44 0 00.316.343c.385.097.578-.44.591-.618.014-.179 0-.564-.357-.605h-.055c.395-.257.676-.656.784-1.114zm.261 1.952c-.165-.041-.165-.206-.165-.33a.348.348 0 01.22-.124c.082.042.289.193.192.262a.263.263 0 00-.074.097c-.035.063-.067.122-.173.095zm-1.54 2.613v.632a1.71 1.71 0 001.169.853 1.062 1.062 0 001.107-.45c.078-.118.132-.25.158-.389a1.376 1.376 0 00-1.059-1.568 1.536 1.536 0 00-1.375.922zm1.293 4.304a1.38 1.38 0 001.457-.894 1.513 1.513 0 00-1.182-1.595c-.427 0-.95.522-1.045 1.169a1.112 1.112 0 00.77 1.32zm11.809-1.457c.158.123.29.277.387.453.962.247 1.553.948 1.347 1.705a1.966 1.966 0 01-1.925 1.471 1.898 1.898 0 01-1.375-1.746 1.225 1.225 0 01-.234-.894c.11-.66.784-1.334 1.265-1.251.195.05.377.139.535.262zm4.91.989a1.376 1.376 0 00-1.265.701 1.16 1.16 0 00-.357.151c.038.136.066.274.082.413a2.842 2.842 0 00-.082.33 1.155 1.155 0 001.072 1.375 1.374 1.374 0 001.664-1.375 1.472 1.472 0 00-1.113-1.595zm-4.262 7.164a1.004 1.004 0 00.523.632c.343.124.838-.371.756-.756-.06-.28-.186-.378-.281-.453a.473.473 0 01-.09-.083c-.633-.028-1.032.371-.908.66zm4.386-1.059c.232.136.433.319.591.536.174-.022.349-.026.523-.014a1.01 1.01 0 01.839.935.806.806 0 01-.096.33h-4.126a1.378 1.378 0 01.124-.605c.454-1.045 1.375-1.54 2.145-1.182zm-5.514.536a.904.904 0 00.908-.838c0-.468-.289-.674-.729-.715a.83.83 0 00-.864.43.828.828 0 00-.098.326.75.75 0 00.216.572.753.753 0 00.568.225zm11.688.344c.041-.853.44-1.251 1.127-1.251.757.055 1.458.646 1.43 1.21 0 .288-.453.701-.92.948h-1.156a1.202 1.202 0 01-.481-.907zm14.286-7.205c.124-.22.097-.385-.137-.495-.234-.11-.372-.082-.495.138a.314.314 0 00.01.396c.03.037.07.065.114.085a.316.316 0 00.509-.124zM13.2 130.267h-.825v-6.985c.072-.015.154-.046.245-.08h.001v-.001c.394-.148.945-.355 1.514.37.333.425-.1.878-.317 1.105a1.2 1.2 0 00-.095.105.78.78 0 01.646-.151.74.74 0 01.674.866v.151a1.87 1.87 0 012.447 0 1.702 1.702 0 01-.11-.907.851.851 0 01.839-.784c.742-.055 1.595.701 1.375 1.155-.18.42-.488.771-.88 1.004h.192a.866.866 0 01.77.839 1.55 1.55 0 01-.33 1.003c.66-.151 1.471.702 1.279 1.637-.047.232-.14.452-.275.646h-3.3c-.137-.206-.275-1.664.151-1.898.326-.178.716.077.943.226.07.045.125.081.157.091.113.033.18-.043.283-.163.023-.026.047-.055.075-.085h-.138a2.187 2.187 0 01-.976-.852c-.27.371-.675.622-1.128.701a2.637 2.637 0 01-.632.261 1.628 1.628 0 01-.371-.399 1.841 1.841 0 01-.825-1.636c.02-.123.057-.244.11-.357a.765.765 0 01-.234.123c.12.29-.057.572-.2.8-.055.086-.104.164-.13.232-.045.116.03.18.153.285.14.12.34.291.493.65.289.673-.632 1.595-1.609 1.375h-.096c.098.21.14.442.124.673zm4.895-4.056h-.082a.58.58 0 01-.317-.192c.052.109.089.225.11.343.092-.058.189-.109.289-.151zm22.358-1.87c-.633-.068-1.018.317-1.114 1.073a.179.179 0 00-.083.069 1.374 1.374 0 00.316 1.375 1.23 1.23 0 001.306-.385.782.782 0 00.62-.605 1.843 1.843 0 00-1.045-1.527zm-19.345 1.893a.813.813 0 01-.208-.573.906.906 0 01.963-.77.827.827 0 01.715.977.736.736 0 01-.318.525.75.75 0 01-.604.107.813.813 0 01-.548-.266zm28.575-6.065a1.195 1.195 0 01-.073-.709 1.374 1.374 0 011.32-.426.962.962 0 01.426 1.169.885.885 0 01-.49.525.877.877 0 01-.72-.017 1.192 1.192 0 01-.463-.542zm-32.358-1.919a.55.55 0 00-.605.66c0 .275.151 1.004.536.976.385-.027.756-.646.798-.921.041-.275-.275-.715-.729-.715zm5.795 8.839c.213.248.34.557.365.882-.041.481-.564.812-1.306.812h-.33a1.09 1.09 0 01-.756-1.018c.04-.55.742-1.169 1.21-1.169.318.073.604.246.817.493zm-.937 1.694h-.004.041H22.183zm0 0c-.675.012-1.338.366-1.338.866-.007.206.04.409.138.591h2.392a.734.734 0 000-.165c0-.837-.315-1.222-1.192-1.292zm-2.15-12.114c0 .605.317 1.003.674.907a1.05 1.05 0 00.633-.522c.124-.344-.371-.839-.756-.757-.272.059-.373.179-.452.273a.502.502 0 01-.098.099zm5.34 9.231c.028.082.037.17.023.256-.027.454-.44.756-.715.715-.275-.041-.88-.412-.907-.797-.028-.385.701-.523.976-.523a.535.535 0 01.623.349zm2.127 4.312h.481a.62.62 0 00-.481 0zm-4.648-6.366c.138.083.33.33.234.536-.082.193-.398.22-.55.179-.151-.041-.454-.412-.371-.605.082-.192.55-.192.688-.11zm25.617 6.422l.192-.33a2.2 2.2 0 00.454-.097.856.856 0 00-.083.413h2.984a1.2 1.2 0 00-.445-1.285 1.207 1.207 0 00-.435-.2 1.943 1.943 0 00-1.059 0 .8.8 0 00-.563-.536c-.688-.22-.963-.083-1.375.646-.543.098-1.08.226-1.609.385a.582.582 0 00-.34.318.59.59 0 00-.004.466 2.012 2.012 0 00-1.1.275l3.383-.055zm7.38-16.424a.77.77 0 01-.01-.393c.811-.426 1.1-.426 1.292-.041a.783.783 0 01-.343.963.77.77 0 01-.94-.529zm-3.795 1.45a.885.885 0 01.334.206c.508.316.536.646.412.853-.124.206.316.261.481.123.165-.137.592-.316.99.262.399.577-.233 1.058-.66 1.292-.426.234-.728.33-1.072 0-.16-.154-.321-.182-.505-.215-.21-.037-.452-.079-.76-.321a1.376 1.376 0 01-.261-1.843.9.9 0 01.651-.401.875.875 0 01.39.044zm-17.074 1.155c0-.165-.22-.427-.357-.44-.138-.014-.537 0-.55.412-.013.378.31.398.49.41l.046.003c.165.013.385-.262.371-.385zm4.318 2.447c-.798-.275-1.032-.756-.798-1.375.248-.284.59-.47.962-.522a.756.756 0 01-.618-.605 1.032 1.032 0 01.88-.99.353.353 0 01.268.109.342.342 0 01.09.276c.002.092.012.196.022.302.031.34.065.71-.091.825a.766.766 0 01.316 0c.343.165.522.633.343 1.169-.288.811-.577 1.086-1.374.811zm15.014-7.755c0-.044.009-.093.018-.144.026-.155.055-.326-.141-.419a.303.303 0 00-.44.165c-.069.165-.179.577 0 .687.178.11.55-.192.563-.289zm-5.898 14.011c.07.029.132.077.178.138a1.1 1.1 0 01.798-.124c.536.138.962 1.238.536 1.513a.933.933 0 01-.715 0 .77.77 0 010 .275c-.178.509-.756.66-1.457.371a.955.955 0 01-.206-.11c.027.082-.042.536-.386.468-.343-.069-.343-.427-.343-.592a.315.315 0 01.22-.302.908.908 0 010-.88 1.116 1.116 0 011.375-.757zm-3.685 4.098c.082-.344-.426-.962-.853-1.059a.674.674 0 00-.524.136.668.668 0 00-.246.483c-.096.701 0 1.196.399 1.279a1.38 1.38 0 001.224-.839zm13.166-11.052a.757.757 0 01-.31-.031.849.849 0 01-.481-1.127.685.685 0 01.595-.549.688.688 0 01.285.026.897.897 0 01.577 1.1.767.767 0 01-.666.581zm-22.806 4.809a1.372 1.372 0 01-.81.014 1.168 1.168 0 01-.413-1.499.661.661 0 01.633-.467c.27-.143.576-.201.88-.165.426.082.632.303.632.77-.03.264-.119.518-.261.742v.138c-.169.219-.4.381-.661.467zm-5.169-11.852c.22 0 .412-.206.454-.357.041-.152-.083-.619-.289-.647-.206-.027-.481.358-.481.509 0 .151.096.468.316.495zm.591 2.805c-.096.412-1.058.66-1.375.412-.261-.247-.261-1.402.578-1.416a.932.932 0 01.289 0c.068-.165.26-.412.426-.412a.448.448 0 01.289.398 1.103 1.103 0 01-.207.427 1.22 1.22 0 010 .591zm22.44 7.04c-.027-1.224.426-2.516 2.214-2.228.342.056.672-.045.99-.142.386-.118.753-.231 1.1-.05a2.116 2.116 0 01.949 1.774 2.6 2.6 0 01-1.746 2.598 1.111 1.111 0 01-.867 0c-.19.191-.402.357-.632.495a.987.987 0 01-.564-.756 1.69 1.69 0 01-1.031-.577A1.899 1.899 0 0152.95 121zm-31.061-3.383c0 .495.619.674.907.743.29.069.564-.289.592-.646.027-.358-.275-.825-.633-.729-.048.013-.1.025-.155.038-.344.081-.758.178-.711.594zm-1.733-10.546c.07-.371 1.403-1.059 1.61-.783.233.275.467 1.154-.235 1.347-.7.192-1.443-.192-1.375-.564zm6.958 19.127a1.25 1.25 0 00.77 1.746 1.182 1.182 0 001.526-.536 1.775 1.775 0 00-.949-1.994 1.254 1.254 0 00-1.347.784zm.99-3.658c.027 0 .124.22.124.22-.041.069-.193.289-.261.192-.024-.032-.055-.055-.085-.078-.059-.043-.112-.083-.094-.183.027-.151.288-.151.316-.151zM33 127.077a1.38 1.38 0 00-1.375.674c-.124.317.289 1.004.701 1.155a.6.6 0 00.702-.22 1.512 1.512 0 00.948.757.829.829 0 00.922-.784c.08.046.162.088.247.124a1.148 1.148 0 00.939.009 1.13 1.13 0 00.628-.697 1.372 1.372 0 00-.32-1.666 1.375 1.375 0 00-.532-.287 1.488 1.488 0 00-1.856.661 1.195 1.195 0 00.11 1.045 1.448 1.448 0 00-.866.33c.068-.605-.014-1.004-.248-1.101zm-9.996-16.747c.069.124.22.467.069.591a.533.533 0 01-.592.055c-.179-.069-.344-.467-.179-.646a.634.634 0 01.702 0zm-8.195 2.984h-.275a.809.809 0 00-.44.866c-.006.256.071.507.22.715.239-.06.483-.102.729-.124a.695.695 0 00-.262.523 1.732 1.732 0 001.375 1.622 1.276 1.276 0 001.045-1.182 1.089 1.089 0 00-1.114-1.279 1.74 1.74 0 00-.538-.002c.02-.005.06-.026.071-.108.044-.228-.208-.45-.454-.666-.14-.124-.277-.245-.357-.365zm1.99-6.431c.043.175.044.357.003.532a.897.897 0 01-1.03.585.897.897 0 01-.386-.186 1.04 1.04 0 01-.222-.83 1.036 1.036 0 01.484-.71.99.99 0 01.907.137c.117.136.2.298.244.472zm.884 16.619c.49.176.881.032 1.14-.063.145-.053.248-.091.303-.047.022.018.052.048.089.085.22.218.688.681 1.135.328a1.074 1.074 0 00.426-1.375 1.06 1.06 0 00.949-.743 1.76 1.76 0 000-.66c.162-.105.31-.229.44-.371a1.376 1.376 0 00-.165-2.117 1.538 1.538 0 00-2.255.371c-.394.54-.25.955-.133 1.295.104.3.187.541-.142.754-.316.205-.51.146-.712.085-.247-.075-.508-.154-1.02.231-.936.701-.84 1.939-.055 2.227zm.893-9.377c.206-.096.537.124.537.289.055.178-.014.536-.22.563a.637.637 0 01-.578-.343.441.441 0 01.261-.509zm2.186 1.581a.605.605 0 00.66.715 1.062 1.062 0 00.757-.412c.11-.206-.179-.99-.564-1.031a.796.796 0 00-.852.728zm11.804 8.348c.05-.002.1.007.145.026.087.019.184.035.283.052.343.058.715.121.79.292a.77.77 0 01-.798 1.003 1.043 1.043 0 01-.728-1.1.33.33 0 01.308-.273zm37.311-5.226c-.77-.11-1.636.412-1.677 1.003-.041.592.564 1.114 1.182 1.169a1.208 1.208 0 001.21-1.114c.07-.618-.178-.99-.715-1.058zm-1.503 4.809c.014-.231.082-.456.197-.657a1.38 1.38 0 01.704-.862 1.368 1.368 0 011.111-.059 2.063 2.063 0 011.238 2.103 1.691 1.691 0 01-2.131 1.032 1.521 1.521 0 01-1.006-.88 1.516 1.516 0 01-.113-.677zm4.075-14.325a1.376 1.376 0 00-1.636.413c-.248.481.15 1.182.866 1.526a1.004 1.004 0 001.182-.44 1.209 1.209 0 00-.412-1.499zm-12.26 19.874a1.61 1.61 0 01-.789-.899 1.555 1.555 0 011.251-1.581c.88-.014 1.843.371 1.843 1.004a1.57 1.57 0 01-1.114 1.581 1.613 1.613 0 01-1.19-.105zm6.54-4.707a1.868 1.868 0 00-2.132.866 1.567 1.567 0 00.702 2.062 2.48 2.48 0 002.406-.907 1.608 1.608 0 00-.976-2.021zm-3.819-8.983a1.583 1.583 0 011.11-.092 1.539 1.539 0 01.605 1.884 1.58 1.58 0 01-1.815.385 1.086 1.086 0 01-.674-1.375c.152-.353.427-.637.774-.802zm6.362-1.77c-.577-.275-1.058 0-1.375.743a1.375 1.375 0 00.358 1.526 1.51 1.51 0 001.76-.646 1.375 1.375 0 00-.743-1.623zm-10.725 16.033c.22-.344.674-.344 1.197 0 .149.114.31.211.481.288.17.052.332.126.481.22h-2.269a.633.633 0 01.11-.508zm13.503-2.558a1.183 1.183 0 002.2.674 1.457 1.457 0 00-.578-1.774c-.398-.151-1.443.537-1.622 1.1zm-58.74-17.545a.88.88 0 01.261 0 1.623 1.623 0 011.1 1.581 1.225 1.225 0 01-1.375.784 1.651 1.651 0 01-.921-.357v-1.375c.034-.04.066-.082.097-.123.044-.059.088-.117.137-.166H12.375v-5.115a1.113 1.113 0 011.114 1.54 1.279 1.279 0 000 .715 2.75 2.75 0 01.178 1.87 1.47 1.47 0 01-.357.646zm-.935-4.771v-.66a.55.55 0 010 .66zm1.705-.22a.893.893 0 00.674 1.031.909.909 0 001.017-.701 1.03 1.03 0 00-.756-1.114.883.883 0 00-.935.784zm60.76 13.21c.166.323.21.695.125 1.049a1.508 1.508 0 01-.773.947 1.508 1.508 0 01-1.221.057 1.174 1.174 0 01-.876-1.048c-.012-.163.01-.326.065-.479a1.663 1.663 0 011.898-1.237c.337.135.615.387.781.711zm-10.394 3.551c-.09.552.336.793.785 1.046l.095.054.165-.114c.398-.272.797-.544.591-1.123a.347.347 0 00-.082-.151 2.024 2.024 0 001.155-1.073.853.853 0 00-.605-1.045 1.213 1.213 0 00-.955-.053 1.218 1.218 0 00-.695.658 1.375 1.375 0 00.11 1.183.835.835 0 00-.564.618zm22.15.271c.038.097.049.204.029.307 0 .206-.426.137-.605.082a.549.549 0 01-.316-.522c.055-.206.564-.193.701-.11a.547.547 0 01.19.243zm1.968 5.669a1.195 1.195 0 00-1.375.77c-.22.592-.083 1.004.426 1.21a1.472 1.472 0 001.76-.563 1.377 1.377 0 00-.811-1.417zm-4.895-8.772c.398.069.412.509.288.825-.082.316-.398.564-1.003.316a2.784 2.784 0 00-.06-.228c-.062-.221-.137-.486-.078-.624.083-.193.454-.358.853-.289zm6.325 3.781a.466.466 0 00-.234-.591.5.5 0 00-.426-.027.513.513 0 00-.322.524.509.509 0 00.418.452.527.527 0 00.564-.358zm2.224-2.268a.685.685 0 01.292-.015c.069.014.247.275.151.427l-.038.064c-.103.175-.273.466-.54.321-.237-.13-.177-.396-.14-.557v-.001a.562.562 0 00.017-.102.671.671 0 01.258-.137zm-31.086-.482a.76.76 0 00.423-.446.77.77 0 00-.038-.613c-.123-.247-.48-.563-.728-.55-.619 0-.839.523-.908 1.128l.007.006c.328.301.712.653 1.245.475zm15.712 6.117c-.285-.221-.688-.535-.518-.933.168-.432.608-.341 1.019-.256l.177.036c.454.082.55.481.372.88-.179.398-.647.618-.894.398a3.96 3.96 0 00-.156-.125zm-18.049-18.217c-.22.674.564 1.073.949.921a.809.809 0 00.343-.962.742.742 0 00-1.292.041zm3.892 1.969c.25-.043.506 0 .728.121a1.378 1.378 0 01.66 1.306c-.069.619-.316.88-.963.88h-1.044v.564a1.565 1.565 0 01-.949 1.482 1.574 1.574 0 01-.605.127.975.975 0 01-.715-.248 2.022 2.022 0 01-.591-1.87 1.76 1.76 0 011.553-1.127h.564c.204-.32.444-.615.715-.88.17-.188.398-.313.647-.355zm19.14 10.131c-.798-.481-1.21-.385-1.65.44-.334.624-.556 1.012-.794 1.426l-.238.417c-1.182-.55-1.375-.482-1.554.604.44.509.908.454 1.375 0 1.279.963 2.104.523 2.324-1.168.103-.047.209-.089.316-.124.468-.069.605-.399.647-.811a.85.85 0 00-.427-.784zm-2.198 9.221c.004-.179.045-.355.121-.517.399-.963 1.196-1.444 1.911-1.155a1.757 1.757 0 01.963 1.883 1.733 1.733 0 01-2.145 1.032 1.3 1.3 0 01-.751-.72 1.294 1.294 0 01-.099-.523zm-1.68-15.312a1.084 1.084 0 00-.811.233c-.427.523-.152.99.357 1.472.084-.03.17-.055.253-.081.427-.128.824-.248.847-.799a.757.757 0 00-.646-.825zM28.6 116.641c-.179-.014-.715-.206-.619-.591.11-.371.619-.371.798-.33a.55.55 0 01.426.564c-.041.357-.426.371-.605.357zm11.866-3.891a.82.82 0 00-.632.454.55.55 0 00.495.729c.233 0 .866-.083.907-.606.042-.522-.563-.577-.77-.577zm-3.011 9.57c-.082-.234-.014-.715.151-.811.383-.15.704-.427.908-.784.041-.096.247-.179.357-.179.413.124.468.564.413.715a11.73 11.73 0 01-.192.481 1.228 1.228 0 01.66 1.004c-.015.33-.716.756-1.128.756a.918.918 0 01-.688-.715 1.055 1.055 0 01-.481-.467zm3.699-3.52a.647.647 0 00.481.852.196.196 0 00.096 0 1.6 1.6 0 00.784.495 1.207 1.207 0 001.306-.618 2.025 2.025 0 00-.701-1.884 1.376 1.376 0 00-1.279.619.618.618 0 00-.687.536zM15.252 96.463a.963.963 0 01.67-.213.949.949 0 01.84 1.017.894.894 0 01-.936.784 1.059 1.059 0 01-.921-.976.963.963 0 01.347-.612zm21.53 21.333a1.226 1.226 0 00-1.307.66.866.866 0 00.591 1.059.975.975 0 001.169-.426c.151-.399-.11-1.197-.454-1.293zm-1.238 6.683c.206-.083.687-.138.825 0 .272.314.638.531 1.045.619.083.01.15.122.207.217.02.032.037.061.054.085-.027.413-.192.578-.578.578a7.28 7.28 0 01-1.375-.234c-.206-.069-.522-.316-.522-.495.01-.292.133-.569.344-.77zm9.061-10.354a1.016 1.016 0 00-1.114.577c-.261.839-.096 1.513.426 1.678a1.182 1.182 0 10.688-2.255zm1.99 2.892c.142-.042.285-.085.416-.142a1.378 1.378 0 011.252.303 1.124 1.124 0 01.44 1.072 1.376 1.376 0 01-.936 1.059 1.84 1.84 0 01-1.54-.344c-.219-.179-.272-.366-.321-.539-.019-.065-.037-.129-.063-.19a.839.839 0 010-.756c.106-.27.422-.364.753-.463zm-4.809-1.256a.441.441 0 00.413.371.626.626 0 00.495-.467c0-.206-.303-.358-.509-.358-.206 0-.44.193-.399.454zm2.136 5.613a1.525 1.525 0 01.174-1.075 1.99 1.99 0 012.407-.592 1.667 1.667 0 01.247 2.324 1.373 1.373 0 01-2.241.261 1.525 1.525 0 01-.587-.918zm-7.828-6.534a.65.65 0 00-.547.016.655.655 0 00-.347.424.605.605 0 00.33.839.643.643 0 00.777-.031.645.645 0 00.172-.217.754.754 0 00-.385-1.031zm6.448-3.121c.097-.248.344-.248.523-.248.096 0 .509.206.358.481-.126.229-.385.211-.564.198a1.22 1.22 0 00-.096-.005.325.325 0 01-.208-.163.316.316 0 01-.013-.263zm-1.003-2.585c-.248.509 0 1.265.426 1.375.426.11 1.375-1.004 1.169-1.485-.206-.481-1.348-.399-1.595.11zm-23.224-4.125a.633.633 0 00.577.343c.207 0 .276-.385.22-.563-.054-.179-.33-.385-.536-.289a.442.442 0 00-.261.509zm-2.14-4.767a.815.815 0 01.614-.046c.572.149.582.574.593 1.037.003.094.005.189.012.283-.839.385-1.238.426-1.513 0a1.046 1.046 0 01-.11-.811.815.815 0 01.405-.463zm1.205 11.326c0 .398.124.715.495.797a4.88 4.88 0 002.874-.082c.137-.073.262-.165.371-.275a1.091 1.091 0 00.297-1.148 1.081 1.081 0 00-.93-.736h-.11c.092-.127.153-.273.18-.426a.798.798 0 00-.784-.908.752.752 0 00-.798.366.751.751 0 00-.096.294c-.004.202.034.404.11.591h-.317a1.707 1.707 0 00-1.292 1.527zm4.473-11.346a1.47 1.47 0 011-.342c.742.028 1.512 1.155 1.36 2.062a1.248 1.248 0 01-.992 1.036c-.167.033-.34.031-.506-.004a1.575 1.575 0 01-1.079-.62 1.588 1.588 0 01-.296-1.209c.05-.361.234-.69.513-.923zm2.608 8.829c.138.358 1.375.537 1.54 0a.837.837 0 00-.357-1.058c-.481-.138-1.32.701-1.183 1.058zm2.187 8.451c.176-.041.359-.044.536-.008.563.041 1.155.632 1.1 1.168a1.758 1.758 0 01-1.691 1.375c-.51 0-.908-.687-.908-1.375a1.253 1.253 0 01.963-1.16zm22.398-2.937a.88.88 0 00-1.072.413.736.736 0 00-.054.602.744.744 0 00.411.443.88.88 0 001.073-.413.724.724 0 00-.1-.87.73.73 0 00-.258-.175zM25.878 97.611c-.083-.151-.083-.756.165-.839a.77.77 0 01.7.358.689.689 0 01-.22.632.673.673 0 01-.645-.15zm-2.063 16.156c-.413 0-.921.482-1.045 1.265.033.034.07.081.112.133.113.143.257.326.438.376a.67.67 0 00.289 0c.165.096.398 0 .577-.206a.837.837 0 00.385-.495 1.06 1.06 0 00-.756-1.073zm6.29 6.069c.127-.249.333-.449.585-.569.32-.143.65-.258.99-.343a1.634 1.634 0 01.468 2.268c-.184.267-.466.45-.784.509a1.371 1.371 0 01-1.375-1.059 1.262 1.262 0 01.116-.806z",fill:"#54B399"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M135.905 24.86H26.139v40.796h109.766V24.86z",fill:"#58C5A7"}),external_kbnSharedDeps_React_["createElement"]("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M33.218 26.624c.358-.28.788-.453 1.24-.499a1.664 1.664 0 011.292 1.898 1.842 1.842 0 01-1.801 1.375 1.65 1.65 0 01-1.513-1.692c.154-.427.425-.802.782-1.082zm-6.186 3.104c.138 0 .62-.07.647-.276.027-.206-.358-.48-.509-.495a.482.482 0 00-.495.317c-.041.22.206.412.357.453zm-.907 5.197v1.953c.097.107.22.188.358.233a1.153 1.153 0 001.375-1.086c.11-.536-.372-1.017-1.142-1.141-.198-.03-.4-.016-.591.041zM60.5 44.138a.798.798 0 00-.921.37c-.385.62-.33.922.275 1.54-.04.55-.04 1.102 0 1.65a.55.55 0 00.99.33c.076-.102.16-.202.245-.303.314-.373.64-.759.607-1.333l-.591-.605c.041-.797-.192-1.526-.605-1.65zm-33.096 4.905c.022.1.022.205 0 .306a1.87 1.87 0 01-.798 1.114h.069c.357.04.371.426.357.605-.013.178-.206.715-.59.618a.44.44 0 01-.317-.357v-.454a.715.715 0 01.165-.275h-.151v-2.131c.205-.028.413-.028.619 0a.727.727 0 01.646.574zm.096 1.928c0 .124 0 .289.165.33.106.027.138-.032.173-.095.02-.036.04-.073.075-.097.096-.069-.11-.22-.193-.262a.344.344 0 00-.22.124zm-1.375 3.575v-.632a1.54 1.54 0 011.375-.922 1.374 1.374 0 011.059 1.568 1.06 1.06 0 01-1.265.839 1.72 1.72 0 01-1.169-.853zm2.177 3.479c-.265.162-.576.23-.884.193a1.113 1.113 0 01-.77-1.32c.096-.647.618-1.17 1.044-1.17a1.513 1.513 0 011.183 1.596 1.375 1.375 0 01-.573.7zm11.312-.811a1.373 1.373 0 00-.921-.715c-.482-.083-1.155.591-1.265 1.251-.042.317.042.638.233.894a1.898 1.898 0 001.375 1.746 1.967 1.967 0 001.925-1.471c.206-.756-.385-1.458-1.347-1.705zm3.791.707c.224-.124.477-.183.733-.171a1.47 1.47 0 011.113 1.595 1.374 1.374 0 01-1.663 1.375 1.155 1.155 0 01-1.073-1.375c.021-.112.048-.222.082-.33a2.746 2.746 0 00-.082-.413c.11-.07.23-.121.358-.15.124-.224.309-.407.532-.531zm-3.336 7.365a1.002 1.002 0 01-.194-.372c-.124-.289.275-.688.907-.66.023.03.055.055.09.083.096.075.222.173.282.453.082.385-.413.88-.757.756a1.004 1.004 0 01-.328-.26zm4.783-.895c-.158-.217-.36-.4-.59-.536-.77-.357-1.692.138-2.146 1.182-.086.19-.129.397-.123.605h4.124a.812.812 0 00.097-.33 1.004 1.004 0 00-.839-.934 2.615 2.615 0 00-.523.013zm-5.486-.24a.908.908 0 01-.618.24.758.758 0 01-.784-.797.838.838 0 01.962-.757c.44.042.729.248.729.715a.908.908 0 01-.289.598zm12.197-.667c-.688 0-1.087.398-1.128 1.251a1.21 1.21 0 00.481.907h1.155c.468-.247.922-.66.922-.948.027-.564-.674-1.155-1.43-1.21zm13.02-6.449c.234.11.262.275.138.495a.316.316 0 01-.508.124.316.316 0 01-.124-.482c.124-.22.261-.247.495-.137zm-38.458 8.608h.811a1.376 1.376 0 00-.123-.674h.096c.976.22 1.897-.701 1.608-1.375a1.635 1.635 0 00-.493-.65c-.122-.105-.198-.17-.153-.285.027-.068.076-.146.13-.232.143-.228.32-.51.2-.8a.77.77 0 00.234-.123c-.053.113-.09.234-.11.357a1.841 1.841 0 00.825 1.637c.1.152.226.287.371.398.221-.06.434-.147.633-.261.452-.079.856-.33 1.127-.701.232.376.572.673.977.852h.137l-.075.085c-.103.12-.17.196-.282.163-.033-.01-.087-.046-.157-.091-.228-.149-.618-.404-.944-.225-.426.233-.288 1.69-.15 1.897h3.3c.134-.194.228-.414.274-.646.193-.935-.618-1.788-1.278-1.636.223-.286.34-.641.33-1.004a.852.852 0 00-.77-.839.91.91 0 00-.193 0c.393-.232.7-.584.88-1.004.22-.453-.633-1.21-1.375-1.155a.853.853 0 00-.839.784c-.046.307-.008.62.11.907a1.65 1.65 0 00-1.045-.467 1.677 1.677 0 00-1.375.426v-.151a.77.77 0 00-.674-.88.84.84 0 00-.646.165 1.54 1.54 0 01.085-.09c.219-.22.68-.685.328-1.12-.57-.725-1.12-.518-1.514-.37h-.001c-.09.035-.173.066-.245.081l-.014 7.026zm5.624-4.126h.096c-.03.013-.06.026-.088.04l-.008-.04zm-.303-.192a.577.577 0 00.28.247 1.9 1.9 0 00-.17.097 1.005 1.005 0 00-.11-.344zm21.643-.536c.096-.757.481-1.073 1.114-1.073a1.842 1.842 0 011.044 1.526.783.783 0 01-.618.605 1.224 1.224 0 01-1.306.386 1.375 1.375 0 01-.317-1.444.18.18 0 01.083 0zm-18.439.247a.812.812 0 00.756.839.742.742 0 00.922-.633.853.853 0 00-.716-.99.935.935 0 00-.962.784zm28.71-6.201a1.197 1.197 0 00.536 1.251.88.88 0 001.21-.508.962.962 0 00-.426-1.17 1.374 1.374 0 00-1.32.427zm-32.542-1.18a.55.55 0 01.257-.03c.454 0 .77.44.729.715-.041.275-.413.894-.798.921-.385.028-.536-.701-.536-.976a.55.55 0 01.348-.63zm6.417 9.691a1.526 1.526 0 00-1.182-1.375c-.468-.068-1.17.619-1.21 1.169a1.086 1.086 0 00.756 1.017h.334c-.675.013-1.338.367-1.338.853-.008.21.04.419.138.605h2.392a.723.723 0 000-.165c0-.837-.315-1.222-1.192-1.292h.037-.041c.742 0 1.265-.33 1.306-.812zm-2.777-10.395c-.358.096-.674-.302-.674-.907a.495.495 0 00.098-.099.705.705 0 01.452-.273c.385-.082.88.413.756.757a1.044 1.044 0 01-.633.522zm4.688 8.58a.535.535 0 00-.646-.605c-.275 0-1.004.138-.976.523.027.385.632.756.907.797.275.041.688-.261.715-.715zm2.585 4.057h-.481a.605.605 0 01.481 0zm-4.895-5.83a.468.468 0 00-.233-.537c-.023 0-.057-.002-.099-.006-.187-.015-.521-.041-.589.116-.082.193.22.564.371.605.151.041.468.014.55-.178zM69.6 49.218a.77.77 0 01-.01-.393c.811-.426 1.1-.44 1.292-.041a.783.783 0 01-.344.963.77.77 0 01-.938-.529zm-3.795 1.45a.895.895 0 01.334.206c.508.316.536.646.412.852-.124.207.316.262.481.124.165-.137.591-.316.99.261.399.578-.234 1.06-.66 1.293-.426.234-.729.33-1.072 0-.16-.153-.318-.182-.5-.215a1.493 1.493 0 01-.765-.335 1.375 1.375 0 01-.261-1.829.893.893 0 011.041-.357zM48.73 51.824c0-.165-.22-.426-.357-.44-.138-.014-.537 0-.55.412-.013.378.31.398.49.41.017 0 .032.002.046.003.165.013.385-.262.371-.385zm4.318 2.447c-.798-.275-1.032-.756-.798-1.375.23-.27.545-.454.894-.522a.756.756 0 01-.619-.605 1.031 1.031 0 01.88-.99.331.331 0 01.358.371l.004.02c.082.398.198.96-.005 1.121a.77.77 0 01.317 0c.343.165.632.358.343 1.169-.288.811-.577 1.086-1.374.811zm15.014-7.755c0-.044.009-.093.018-.144.026-.155.055-.326-.141-.42a.303.303 0 00-.44.166c-.069.164-.179.577 0 .687.178.11.55-.193.564-.289zm3.583 7.057a.77.77 0 01-.31-.03.853.853 0 01-.481-1.128.688.688 0 01.88-.523.894.894 0 01.577 1.1.772.772 0 01-.666.581zm-22.806 4.81c-.263.085-.545.09-.81.013a1.169 1.169 0 01-.413-1.498.66.66 0 01.633-.468c.27-.143.576-.201.88-.165.426.082.632.303.632.77a1.76 1.76 0 01-.261.743v.137c-.169.219-.4.382-.661.467zM43.67 46.53c.22 0 .413-.206.454-.358.041-.15-.083-.618-.289-.646-.206-.027-.481.358-.481.509a.481.481 0 00.316.495zm.591 2.805c-.096.413-1.059.66-1.375.413-.261-.248-.261-1.403.578-1.417a.939.939 0 01.288 0c.07-.165.262-.412.427-.412a.454.454 0 01.288.399 1.1 1.1 0 01-.206.426c.049.194.049.397 0 .591zm22.44 7.04c-.027-1.224.427-2.516 2.214-2.227.342.055.672-.046.99-.143.386-.118.753-.231 1.1-.05a2.117 2.117 0 01.949 1.774 2.599 2.599 0 01-1.746 2.599 1.115 1.115 0 01-.867 0c-.19.19-.402.356-.632.494a.99.99 0 01-.564-.756 1.69 1.69 0 01-1.031-.577 1.897 1.897 0 01-.413-1.114zM35.64 52.992c0 .495.619.674.907.743.29.069.564-.289.592-.646.027-.358-.275-.825-.633-.73-.048.014-.1.026-.155.039-.344.081-.758.178-.711.594zm-1.733-10.546c.07-.371 1.403-1.058 1.61-.783.233.275.467 1.155-.235 1.347-.7.193-1.443-.192-1.374-.564zm6.958 19.127a1.253 1.253 0 00.77 1.746 1.182 1.182 0 001.526-.537 1.773 1.773 0 00-.935-1.993 1.266 1.266 0 00-1.361.783zm.99-3.658c.028 0 .124.22.124.22-.041.069-.193.289-.261.193-.024-.033-.055-.056-.085-.079-.059-.043-.112-.083-.094-.183.027-.151.288-.151.316-.151zm4.895 4.538a1.375 1.375 0 00-1.375.673c-.124.317.289 1.004.701 1.155a.605.605 0 00.702-.22 1.499 1.499 0 00.948.756.825.825 0 00.922-.783l.247.123a1.14 1.14 0 001.567-.687 1.375 1.375 0 00-.852-1.953 1.485 1.485 0 00-1.856.66 1.196 1.196 0 00.11 1.045 1.458 1.458 0 00-.866.33c.068-.605-.014-1.003-.248-1.1zm-9.996-16.748c.069.124.22.468.069.591a.535.535 0 01-.592.055c-.178-.069-.343-.467-.178-.646a.633.633 0 01.7 0zm-8.195 2.984h-.275a.811.811 0 00-.44.866c-.006.256.071.507.22.715.239-.06.483-.102.729-.124a.689.689 0 00-.262.523 1.732 1.732 0 001.375 1.622 1.278 1.278 0 001.045-1.182 1.088 1.088 0 00-1.114-1.279 1.734 1.734 0 00-.538-.002c.02-.005.06-.026.071-.108.044-.228-.208-.45-.454-.666-.14-.124-.277-.245-.357-.365zm1.99-6.43c.043.174.044.356.003.531a.893.893 0 01-1.416.399 1.032 1.032 0 01.262-1.54.99.99 0 01.907.137c.117.136.2.298.244.472zm.884 16.618c.49.176.882.032 1.14-.063.145-.053.248-.091.303-.047.022.018.052.048.089.084.22.219.688.682 1.135.329a1.073 1.073 0 00.426-1.375 1.059 1.059 0 00.949-.742 1.76 1.76 0 000-.66c.161-.105.31-.23.44-.372a1.375 1.375 0 00-.165-2.117 1.54 1.54 0 00-2.255.371c-.394.54-.25.957-.132 1.294.104.298.186.535-.143.741-.314.197-.507.143-.709.086-.247-.07-.508-.143-1.024.244-.934.701-.838 1.939-.054 2.227zm.893-9.377c.206-.096.536.124.536.289.055.178-.013.536-.22.563a.62.62 0 01-.577-.357.44.44 0 01.261-.495zm2.187 1.581a.604.604 0 00.66.715 1.058 1.058 0 00.756-.412c.11-.206-.179-.99-.564-1.032a.798.798 0 00-.852.73zm11.803 8.348a.33.33 0 01.145.026c.087.019.184.035.283.052.343.058.715.121.79.292a.772.772 0 01-.798 1.004 1.045 1.045 0 01-.728-1.1.33.33 0 01.308-.274zm37.311-5.227c-.77-.11-1.636.413-1.677 1.004-.041.591.564 1.114 1.182 1.169a1.21 1.21 0 001.21-1.114c.07-.619-.178-.99-.715-1.059zm1.683-9.589c.296-.075.609-.048.889.075a1.21 1.21 0 01.412 1.498 1.004 1.004 0 01-1.182.44c-.715-.343-1.114-1.045-.867-1.526.189-.24.452-.412.748-.487zm-7.54 6.166a1.581 1.581 0 00-1.884.893 1.086 1.086 0 00.674 1.376 1.58 1.58 0 001.815-.386 1.54 1.54 0 00-.605-1.883zm3.877-.935c.317-.743.798-1.018 1.375-.743a1.375 1.375 0 01.743 1.623 1.513 1.513 0 01-1.76.646 1.375 1.375 0 01-.358-1.526zM27.321 45.03h-.261c.174-.175.297-.393.358-.632a2.75 2.75 0 00-.18-1.884 1.224 1.224 0 010-.701 1.114 1.114 0 00-1.113-1.554.55.55 0 000-.66v5.775H26.359a1.559 1.559 0 00-.137.166 2.463 2.463 0 01-.097.123v1.375c.263.21.585.335.921.357.591 0 1.279-.33 1.375-.784a1.623 1.623 0 00-1.1-1.58zm.64-4.34a.894.894 0 01-.131-.651.88.88 0 01.935-.784 1.03 1.03 0 01.756 1.114.907.907 0 01-1.017.701.894.894 0 01-.543-.38zm60.754 13.608a1.512 1.512 0 00-.907-1.76 1.664 1.664 0 00-1.898 1.237 1.17 1.17 0 00.811 1.526 1.497 1.497 0 001.994-1.003zm-9.734 3.548c-.449-.253-.875-.494-.785-1.046a.839.839 0 01.564-.619A1.375 1.375 0 0178.65 55a1.21 1.21 0 011.65-.605.84.84 0 01.605 1.045 2.022 2.022 0 01-1.155 1.073c.04.043.068.094.082.15.206.58-.193.852-.591 1.124l-.165.114-.042-.024-.053-.03zm21.394-.468a.547.547 0 00-.22-.55c-.138-.083-.646-.096-.701.11a.55.55 0 00.316.522c.179.055.605.124.605-.082zm-2.956-3.41c.398.069.412.508.288.825-.082.316-.398.564-1.003.316a2.85 2.85 0 00-.06-.228c-.062-.22-.137-.486-.078-.624.083-.193.454-.358.853-.29zm6.325 3.781a.471.471 0 00-.234-.591.512.512 0 00-.608.094.507.507 0 00.076.771c.061.042.129.07.202.084a.521.521 0 00.564-.358zm2.224-2.268a.675.675 0 01.292-.014c.069.013.247.274.151.426l-.041.07c-.103.177-.273.47-.536.315a.48.48 0 01-.124-.66.673.673 0 01.258-.137zM74.882 55a.769.769 0 00.385-1.059c-.123-.247-.48-.564-.728-.55-.619 0-.839.523-.908 1.128l.007.006c.328.301.712.653 1.244.475zm-1.388-11.179c-.385.151-1.169-.247-.949-.921a.742.742 0 011.293-.041.812.812 0 01-.344.962zm3.671 1.169a1.128 1.128 0 00-1.375.234c-.271.265-.51.56-.715.88h-.564a1.76 1.76 0 00-1.553 1.127 2.021 2.021 0 00.59 1.87.977.977 0 00.716.248 1.567 1.567 0 001.553-1.609v-.564c.127 0 .25.008.37.016.234.015.458.03.675-.016.647 0 .894-.261.963-.88a1.375 1.375 0 00-.66-1.306zm16.761 10.45c.44-.825.853-.921 1.65-.44a.853.853 0 01.427.797c-.042.413-.18.812-.647.812a3.015 3.015 0 00-.316.123c-.22 1.692-1.045 2.132-2.324 1.156-.467.453-.935.508-1.375 0 .179-1.087.372-1.155 1.554-.62l.142-.243c.276-.474.512-.878.89-1.585zM91.7 48.909a1.084 1.084 0 00-.811.233c-.427.523-.152.99.357 1.472.084-.03.17-.055.253-.08.427-.13.824-.25.847-.8a.756.756 0 00-.646-.825zM42.35 52.016c-.179-.014-.715-.22-.619-.591.11-.371.619-.371.798-.33a.55.55 0 01.426.564c-.041.357-.426.371-.605.357zm11.866-3.891a.824.824 0 00-.632.454.55.55 0 00.495.728c.233 0 .866-.082.907-.605.042-.522-.563-.577-.77-.577zm-3.011 9.57c-.082-.234-.014-.715.151-.811a1.8 1.8 0 00.908-.784c.041-.179.247-.179.357-.179.413.124.468.564.413.715-.02.054-.05.109-.08.165-.055.103-.113.21-.113.316a1.223 1.223 0 01.66.99c-.014.344-.715.77-1.127.77a.922.922 0 01-.688-.715 1.06 1.06 0 01-.481-.467zm3.699-3.52a.646.646 0 00.481.853h.096c.207.238.48.41.784.495a1.21 1.21 0 001.306-.62 2.021 2.021 0 00-.701-1.883 1.375 1.375 0 00-1.279.619.619.619 0 00-.687.536zM29.002 31.838a.963.963 0 01.67-.213.949.949 0 01.84 1.017.894.894 0 01-.936.784 1.059 1.059 0 01-.921-.976.963.963 0 01.347-.612zm21.53 21.333a1.224 1.224 0 00-1.376.647.866.866 0 00.592 1.072.977.977 0 001.168-.426c.22-.399-.041-1.197-.385-1.293zm-1.238 6.683c.206-.083.687-.138.825 0 .272.314.638.531 1.045.618.11.014.261.207.261.303-.027.413-.192.578-.578.578a7.184 7.184 0 01-1.375-.234c-.206-.069-.522-.316-.522-.495.01-.292.133-.569.344-.77zM58.355 49.5a1.018 1.018 0 00-1.114.578c-.261.838-.096 1.512.426 1.677a1.512 1.512 0 001.554-.88 1.5 1.5 0 00-.866-1.375zm1.99 2.892c.142-.042.285-.085.416-.142a1.375 1.375 0 011.252.303 1.127 1.127 0 01.44 1.072 1.375 1.375 0 01-.936 1.059 1.842 1.842 0 01-1.54-.344c-.219-.18-.272-.366-.321-.539a1.485 1.485 0 00-.063-.19.84.84 0 010-.756c.106-.27.422-.364.753-.463zm-4.809-1.256a.44.44 0 00.413.371.66.66 0 00.495-.467c0-.206-.303-.358-.509-.358-.206 0-.44.193-.399.454zm2.136 5.613a1.527 1.527 0 01.174-1.075 1.994 1.994 0 012.407-.591 1.663 1.663 0 01.247 2.323 1.376 1.376 0 01-2.241.261 1.527 1.527 0 01-.587-.918zm-7.828-6.534a.66.66 0 00-.894.44.605.605 0 00.33.839.646.646 0 00.949-.248.757.757 0 00-.385-1.031zm6.448-3.121c.097-.248.344-.248.523-.248.096 0 .509.207.358.482-.126.228-.385.21-.564.197-.036-.003-.069-.005-.096-.005a.316.316 0 01-.22-.426zm-1.003-2.585c-.248.508 0 1.265.426 1.375.426.11 1.375-1.004 1.169-1.485-.206-.482-1.348-.399-1.595.11zM32.065 40.37a.619.619 0 00.578.358c.206 0 .274-.386.22-.578-.056-.192-.33-.371-.537-.275a.44.44 0 00-.261.495zm-2.14-4.753a.811.811 0 01.614-.046c.572.149.582.574.593 1.038.003.093.005.188.012.282-.839.385-1.238.427-1.513 0a1.045 1.045 0 01-.11-.811.81.81 0 01.405-.463zm1.205 11.326c0 .398.124.715.495.797a4.88 4.88 0 002.874-.083 1.51 1.51 0 00.371-.274 1.087 1.087 0 00-.633-1.884h-.11c.092-.127.153-.273.18-.427a.797.797 0 00-.785-.907.755.755 0 00-.893.66 1.5 1.5 0 00.11.591h-.316a1.704 1.704 0 00-1.293 1.527zm4.473-11.346a1.47 1.47 0 011-.342c.742.027 1.512 1.155 1.36 2.063a1.253 1.253 0 01-1.498 1.03 1.58 1.58 0 01-1.375-1.828c.05-.36.234-.69.513-.923zm2.608 8.83c.138.357 1.375.535 1.54 0a.866.866 0 00-.357-1.073c-.481-.124-1.32.715-1.183 1.072zm2.187 8.45a1.25 1.25 0 01.536-.008c.564.041 1.155.632 1.1 1.169a1.76 1.76 0 01-1.691 1.375c-.51 0-.908-.688-.908-1.375a1.25 1.25 0 01.963-1.161zm22.398-2.937a.894.894 0 00-1.072.399.754.754 0 00.357 1.059.88.88 0 001.073-.413.729.729 0 00-.358-1.045zM39.627 32.986c-.082-.151-.082-.756.165-.839a.77.77 0 01.702.358.689.689 0 01-.22.632.673.673 0 01-.647-.15zm-2.062 16.157c-.412 0-.921.48-1.045 1.264.033.034.07.08.112.133.113.143.257.326.438.376.096.014.193.014.289 0 .165.097.398 0 .577-.206a.838.838 0 00.385-.495 1.058 1.058 0 00-.756-1.073zm6.29 6.068c.127-.25.333-.449.585-.569.32-.143.65-.258.99-.343a1.639 1.639 0 01.468 2.269c-.184.266-.466.449-.784.508a1.375 1.375 0 01-1.375-1.059 1.265 1.265 0 01.116-.806z",fill:"#54B399"}),external_kbnSharedDeps_React_["createElement"]("path",{d:"M162.085 56.072H50.999V96.87h111.086V56.072z",fill:"#8ADFC8"}),external_kbnSharedDeps_React_["createElement"]("path",{className:"lnsDropIllustration__adjustFill",fillRule:"evenodd",clipRule:"evenodd",d:"M43.574 36.575a8.91 8.91 0 110 17.82 8.91 8.91 0 010-17.82zM23.98 103.166h14.946v14.947H23.98v-14.947zm45.306-34.072L59.14 85.388h20.295L69.286 69.094zm54.288 4.224a2.901 2.901 0 012.197-.292 2.902 2.902 0 011.898 3.589l-3.96 13.516-4.125 12.691c-2.186 7.467-10.326 11.647-18.576 9.227-5.17-1.513-11.564-7.109-12.692-11.592l-3.575-16.156a3.066 3.066 0 011.953-3.712 2.75 2.75 0 013.52 1.939l2.062 6.874.207-.715 1.663-5.65 5.541-19.168a2.864 2.864 0 015.259-.583 2.86 2.86 0 01.242 2.178l-5.212 17.792 2.475.715 6.174-21.134a2.868 2.868 0 012.434-2.048 2.868 2.868 0 012.105.61 2.852 2.852 0 011.057 1.92c.041.374.009.752-.096 1.114l-6.242 21.133 2.475.715L115.5 68.53a2.868 2.868 0 012.434-2.048 2.868 2.868 0 012.105.61 2.852 2.852 0 011.057 1.92c.041.374.009.752-.096 1.113l-5.225 17.751 2.475.715 3.974-13.516c.2-.742.685-1.374 1.35-1.758z"}),external_kbnSharedDeps_React_["createElement"]("path",{className:"lnsDropIllustration__adjustFill lnsDropIllustration__hand",id:"lnsDropIllustrationArrow",d:"M84.688 156.577v-31.021c0-1.17.853-2.118 1.906-2.118s1.906.948 1.906 2.118v31.021l15.617-15.617a1.907 1.907 0 012.696 2.696l-16.175 16.175a5.695 5.695 0 01-3.525 1.652 1.725 1.725 0 01-1.039 0 5.695 5.695 0 01-3.524-1.652l-16.175-16.175a1.907 1.907 0 012.696-2.696l15.617 15.617z"}));function workspace_panel_extends(){workspace_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return workspace_panel_extends.apply(this,arguments)}const workspace_panel_dropProps={value:{id:"lnsWorkspace",humanData:{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.workspaceLabel",{defaultMessage:"Workspace"})}},order:[1,0,0,0]};const workspace_panel_WorkspacePanel=external_kbnSharedDeps_React_default.a.memo((function WorkspacePanel(props){const{getSuggestionForField:getSuggestionForField,...restProps}=props;const dragDropContext=Object(external_kbnSharedDeps_React_["useContext"])(drag_drop["DragContext"]);const suggestionForDraggedField=Object(external_kbnSharedDeps_React_["useMemo"])(()=>dragDropContext.dragging&&getSuggestionForField(dragDropContext.dragging),[dragDropContext.dragging,getSuggestionForField]);return external_kbnSharedDeps_React_default.a.createElement(workspace_panel_InnerWorkspacePanel,workspace_panel_extends({},restProps,{suggestionForDraggedField:suggestionForDraggedField}))}));const workspace_panel_InnerWorkspacePanel=external_kbnSharedDeps_React_default.a.memo((function InnerWorkspacePanel({activeDatasourceId:activeDatasourceId,activeVisualizationId:activeVisualizationId,visualizationMap:visualizationMap,visualizationState:visualizationState,datasourceMap:datasourceMap,datasourceStates:datasourceStates,framePublicAPI:framePublicAPI,dispatch:dispatch,core:core,plugins:plugins,ExpressionRenderer:ExpressionRendererComponent,title:title,visualizeTriggerFieldContext:visualizeTriggerFieldContext,suggestionForDraggedField:suggestionForDraggedField}){const[localState,setLocalState]=Object(external_kbnSharedDeps_React_["useState"])({expressionBuildError:undefined,expandError:false});const activeVisualization=activeVisualizationId?visualizationMap[activeVisualizationId]:null;const configurationValidationError=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _datasourceStates$act;return validateDatasourceAndVisualization(activeDatasourceId?datasourceMap[activeDatasourceId]:null,activeDatasourceId&&((_datasourceStates$act=datasourceStates[activeDatasourceId])===null||_datasourceStates$act===void 0?void 0:_datasourceStates$act.state),activeVisualization,visualizationState,framePublicAPI)},[activeVisualization,visualizationState,activeDatasourceId,datasourceMap,datasourceStates]);const expression=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!(configurationValidationError!==null&&configurationValidationError!==void 0&&configurationValidationError.length)){try{const ast=expression_helpers_buildExpression({visualization:activeVisualization,visualizationState:visualizationState,datasourceMap:datasourceMap,datasourceStates:datasourceStates,datasourceLayers:framePublicAPI.datasourceLayers});if(ast){return Object(target_common["toExpression"])(ast)}else{return null}}catch(e){const buildMessages=activeVisualization===null||activeVisualization===void 0?void 0:activeVisualization.getErrorMessages(visualizationState);const defaultMessage={shortMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.buildExpressionError",{defaultMessage:"An unexpected error occurred while preparing the chart"}),longMessage:e.toString()};setLocalState(s=>({...s,expressionBuildError:buildMessages!==null&&buildMessages!==void 0?buildMessages:[defaultMessage]}))}}},[activeVisualization,visualizationState,datasourceMap,datasourceStates,framePublicAPI.dateRange,framePublicAPI.query,framePublicAPI.filters]);const expressionExists=Boolean(expression);const onEvent=Object(external_kbnSharedDeps_React_["useCallback"])(event=>{if(!plugins.uiActions){return}if(isLensBrushEvent(event)){plugins.uiActions.getTrigger(visualizations_public_["VIS_EVENT_TO_TRIGGER"][event.name]).exec({data:event.data})}if(isLensFilterEvent(event)){plugins.uiActions.getTrigger(visualizations_public_["VIS_EVENT_TO_TRIGGER"][event.name]).exec({data:event.data})}if(isLensEditEvent(event)&&activeVisualization!==null&&activeVisualization!==void 0&&activeVisualization.onEditAction){dispatch({type:"UPDATE_VISUALIZATION_STATE",visualizationId:activeVisualization.id,updater:oldState=>activeVisualization.onEditAction(oldState,event)})}},[plugins.uiActions,dispatch,activeVisualization]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(expressionExists&&localState.expressionBuildError){setLocalState(s=>({...s,expressionBuildError:undefined}))}},[expressionExists,localState.expressionBuildError]);const onDrop=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(suggestionForDraggedField){Object(lens_ui_telemetry["e"])("drop_onto_workspace");Object(lens_ui_telemetry["e"])(expressionExists?"drop_non_empty":"drop_empty");switchToSuggestion(dispatch,suggestionForDraggedField,"SWITCH_VISUALIZATION")}},[suggestionForDraggedField,expressionExists,dispatch]);const renderEmptyWorkspace=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:classnames_default()("lnsWorkspacePanel__emptyContent"),textAlign:"center",color:"subdued","data-test-subj":"empty-workspace",size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,!expressionExists?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.emptyWorkspace",{defaultMessage:"Drop some fields here to start"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.emptyWorkspaceSimple",{defaultMessage:"Drop field here"}))),external_kbnSharedDeps_React_default.a.createElement(DropIllustration,{"aria-hidden":true,className:"lnsWorkspacePanel__dropIllustration"}),!expressionExists&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.emptyWorkspaceHeading",{defaultMessage:"Lens is a new tool for creating visualization"})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("small",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/products/kibana/feedback",target:"_blank",external:true},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.goToForums",{defaultMessage:"Make requests and give feedback"}))))));const renderVisualization=()=>{if(expression===null&&!visualizeTriggerFieldContext){return renderEmptyWorkspace()}return external_kbnSharedDeps_React_default.a.createElement(VisualizationWrapper,{expression:expression,framePublicAPI:framePublicAPI,timefilter:plugins.data.query.timefilter.timefilter,dispatch:dispatch,onEvent:onEvent,setLocalState:setLocalState,localState:{...localState,configurationValidationError:configurationValidationError},ExpressionRendererComponent:ExpressionRendererComponent})};return external_kbnSharedDeps_React_default.a.createElement(WorkspacePanelWrapper,{title:title,framePublicAPI:framePublicAPI,dispatch:dispatch,visualizationState:visualizationState,visualizationId:activeVisualizationId,datasourceStates:datasourceStates,datasourceMap:datasourceMap,visualizationMap:visualizationMap},external_kbnSharedDeps_React_default.a.createElement(drag_drop["DragDrop"],{className:"lnsWorkspacePanel__dragDrop",dataTestSubj:"lnsWorkspace",draggable:false,dropType:suggestionForDraggedField?"field_add":undefined,onDrop:onDrop,value:workspace_panel_dropProps.value,order:workspace_panel_dropProps.order},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],{className:"lnsWorkspacePanelWrapper__pageContentBody"},renderVisualization(),Boolean(suggestionForDraggedField)&&expression!==null&&renderEmptyWorkspace())))}));const InnerVisualizationWrapper=({expression:expression,framePublicAPI:framePublicAPI,timefilter:timefilter,onEvent:onEvent,setLocalState:setLocalState,localState:localState,ExpressionRendererComponent:ExpressionRendererComponent,dispatch:dispatch})=>{var _localState$configura,_localState$expressio;const context=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({query:framePublicAPI.query,timeRange:{from:framePublicAPI.dateRange.fromDate,to:framePublicAPI.dateRange.toDate},filters:framePublicAPI.filters}),[framePublicAPI.query,framePublicAPI.dateRange.fromDate,framePublicAPI.dateRange.toDate,framePublicAPI.filters]);const onData$=Object(external_kbnSharedDeps_React_["useCallback"])((data,inspectorAdapters)=>{if(inspectorAdapters&&inspectorAdapters.tables){dispatch({type:"UPDATE_ACTIVE_DATA",tables:inspectorAdapters.tables.tables})}},[dispatch]);if((_localState$configura=localState.configurationValidationError)!==null&&_localState$configura!==void 0&&_localState$configura.length){let showExtraErrors=null;let showExtraErrorsAction=null;if(localState.configurationValidationError.length>1){if(localState.expandError){showExtraErrors=localState.configurationValidationError.slice(1).map(({longMessage:longMessage})=>external_kbnSharedDeps_React_default.a.createElement("p",{key:longMessage,className:"eui-textBreakAll","data-test-subj":"configuration-failure-error"},longMessage))}else{showExtraErrorsAction=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>{setLocalState(prevState=>({...prevState,expandError:!prevState.expandError}))},"data-test-subj":"configuration-failure-more-errors"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.configurationFailureMoreErrors",{defaultMessage:` +{errors} {errors, plural, one {error} other {errors}}`,values:{errors:localState.configurationValidationError.length-1}}))}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{"data-test-subj":"configuration-failure"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{actions:showExtraErrorsAction,body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",{className:"eui-textBreakAll","data-test-subj":"configuration-failure-error"},localState.configurationValidationError[0].longMessage),showExtraErrors),iconColor:"danger",iconType:"alert"})))}if((_localState$expressio=localState.expressionBuildError)!==null&&_localState$expressio!==void 0&&_localState$expressio.length){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"expression-failure"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.editorFrame.expressionFailure",defaultMessage:"An error occurred in the expression"})),external_kbnSharedDeps_React_default.a.createElement("p",null,localState.expressionBuildError[0].longMessage)),iconColor:"danger",iconType:"alert"})))}return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsExpressionRenderer"},external_kbnSharedDeps_React_default.a.createElement(ExpressionRendererComponent,{className:"lnsExpressionRenderer__component",padding:"m",expression:expression,searchContext:context,searchSessionId:framePublicAPI.searchSessionId,onEvent:onEvent,onData$:onData$,renderMode:"edit",renderError:(errorMessage,error)=>{const visibleErrorMessage=getOriginalRequestErrorMessage(error)||errorMessage;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{actions:visibleErrorMessage?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>{setLocalState(prevState=>({...prevState,expandError:!prevState.expandError}))}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.editorFrame.expandRenderingErrorButton",{defaultMessage:"Show details of error"})):null,body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",{"data-test-subj":"expression-failure"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.editorFrame.dataFailure",defaultMessage:"An error occurred when loading data."})),localState.expandError?external_kbnSharedDeps_React_default.a.createElement("p",{className:"eui-textBreakAll"},visibleErrorMessage):null),iconColor:"danger",iconType:"alert"})))}}))};const VisualizationWrapper=debouncedComponent(InnerVisualizationWrapper);function saved_object_store_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class saved_object_store_SavedObjectIndexStore{constructor(client){saved_object_store_defineProperty(this,"client",void 0);saved_object_store_defineProperty(this,"save",async vis=>{const{savedObjectId:savedObjectId,type:type,references:references,...rest}=vis;const attributes=rest;const result=await(savedObjectId?this.safeUpdate(savedObjectId,attributes,references):this.client.create(common["DOC_TYPE"],attributes,{references:references}));return{...vis,savedObjectId:result.id}});this.client=client}async safeUpdate(savedObjectId,attributes,references){const resetAttributes={};Object.keys(attributes).forEach(key=>{resetAttributes[key]=null});return(await this.client.bulkUpdate([{type:common["DOC_TYPE"],id:savedObjectId,attributes:resetAttributes,references:references},{type:common["DOC_TYPE"],id:savedObjectId,attributes:attributes,references:references}])).savedObjects[1]}async load(savedObjectId){const{type:type,attributes:attributes,references:references,error:error}=await this.client.get(common["DOC_TYPE"],savedObjectId);if(error){throw error}return{...attributes,references:references,savedObjectId:savedObjectId,type:type}}}function extractFilterReferences(filters){const references=[];const persistableFilters=filters.map((filterRow,i)=>{if(!filterRow.meta||!filterRow.meta.index){return filterRow}const refName=`filter-index-pattern-${i}`;references.push({name:refName,type:"index-pattern",id:filterRow.meta.index});const newFilter={...filterRow,meta:{...filterRow.meta,indexRefName:refName}};delete newFilter.meta.index;delete newFilter.meta.value;return newFilter});return{persistableFilters:persistableFilters,references:references}}function injectFilterReferences(filters,references){return filters.map(filterRow=>{if(!filterRow.meta||!filterRow.meta.indexRefName){return filterRow}const{indexRefName:indexRefName,...metaRest}=filterRow.meta;const reference=references.find(ref=>ref.name===indexRefName);if(!reference){throw new Error(`Could not find reference for ${indexRefName}`)}return{...filterRow,meta:{...metaRest,index:reference.id}}})}function getSavedObjectFormat({activeDatasources:activeDatasources,state:state,visualization:visualization,framePublicAPI:framePublicAPI}){const datasourceStates={};const references=[];Object.entries(activeDatasources).forEach(([id,datasource])=>{const{state:persistableState,savedObjectReferences:savedObjectReferences}=datasource.getPersistableState(state.datasourceStates[id].state);datasourceStates[id]=persistableState;references.push(...savedObjectReferences)});const uniqueFilterableIndexPatternIds=external_kbnSharedDeps_Lodash_default.a.uniq(references.filter(({type:type})=>type==="index-pattern").map(({id:id})=>id));const{persistableFilters:persistableFilters,references:filterReferences}=extractFilterReferences(framePublicAPI.filters);references.push(...filterReferences);const expression=expression_helpers_buildExpression({visualization:visualization,visualizationState:state.visualization.state,datasourceMap:activeDatasources,datasourceStates:state.datasourceStates,datasourceLayers:framePublicAPI.datasourceLayers});return{doc:{savedObjectId:state.persistedId,title:state.title,description:state.description,type:"lens",visualizationType:state.visualization.activeId,state:{datasourceStates:datasourceStates,visualization:state.visualization.state,query:framePublicAPI.query,filters:persistableFilters},references:references},filterableIndexPatterns:uniqueFilterableIndexPatternIds,isSaveable:expression!==null,activeData:state.activeData}}function EditorFrame(props){const[state,dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(reducer,props,getInitialState);const[visualizeTriggerFieldContext,setVisualizeTriggerFieldContext]=Object(external_kbnSharedDeps_React_["useState"])(props.initialContext);const{onError:onError}=props;const activeVisualization=state.visualization.activeId&&props.visualizationMap[state.visualization.activeId];const allLoaded=Object.values(state.datasourceStates).every(({isLoading:isLoading})=>typeof isLoading==="boolean"&&!isLoading);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{let isUnmounted=false;if(!allLoaded){var _props$doc;initializeDatasources(props.datasourceMap,state.datasourceStates,(_props$doc=props.doc)===null||_props$doc===void 0?void 0:_props$doc.references,visualizeTriggerFieldContext,{isFullEditor:true}).then(result=>{if(!isUnmounted){Object.entries(result).forEach(([datasourceId,{state:datasourceState}])=>{dispatch({type:"UPDATE_DATASOURCE_STATE",updater:datasourceState,datasourceId:datasourceId})})}}).catch(onError)}return()=>{isUnmounted=true}},[allLoaded,onError]);const datasourceLayers=createDatasourceLayers(props.datasourceMap,state.datasourceStates);const framePublicAPI={datasourceLayers:datasourceLayers,activeData:state.activeData,dateRange:props.dateRange,query:props.query,filters:props.filters,searchSessionId:props.searchSessionId,availablePalettes:props.palettes,addNewLayer(){const newLayerId=generateId();dispatch({type:"UPDATE_LAYER",datasourceId:state.activeDatasourceId,layerId:newLayerId,updater:props.datasourceMap[state.activeDatasourceId].insertLayer});return newLayerId},removeLayers(layerIds){if(activeVisualization&&activeVisualization.removeLayer&&state.visualization.state){dispatch({type:"UPDATE_VISUALIZATION_STATE",visualizationId:activeVisualization.id,updater:layerIds.reduce((acc,layerId)=>activeVisualization.removeLayer?activeVisualization.removeLayer(acc,layerId):acc,state.visualization.state)})}layerIds.forEach(layerId=>{const layerDatasourceId=Object.entries(props.datasourceMap).find(([datasourceId,datasource])=>state.datasourceStates[datasourceId]&&datasource.getLayers(state.datasourceStates[datasourceId].state).includes(layerId))[0];dispatch({type:"UPDATE_LAYER",layerId:layerId,datasourceId:layerDatasourceId,updater:props.datasourceMap[layerDatasourceId].removeLayer})})}};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(props.doc){dispatch({type:"VISUALIZATION_LOADED",doc:{...props.doc,state:{...props.doc.state,visualization:props.doc.visualizationType?props.visualizationMap[props.doc.visualizationType].initialize(framePublicAPI,props.doc.state.visualization):props.doc.state.visualization}}})}else{dispatch({type:"RESET",state:getInitialState(props)})}},[props.doc]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(allLoaded&&state.visualization.state===null&&activeVisualization){const initialVisualizationState=activeVisualization.initialize(framePublicAPI);dispatch({type:"UPDATE_VISUALIZATION_STATE",visualizationId:activeVisualization.id,updater:initialVisualizationState})}},[allLoaded,activeVisualization,state.visualization.state]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(allLoaded&&visualizeTriggerFieldContext&&!props.doc){applyVisualizeFieldSuggestions({datasourceMap:props.datasourceMap,datasourceStates:state.datasourceStates,visualizationMap:props.visualizationMap,activeVisualizationId:state.visualization.activeId,visualizationState:state.visualization.state,visualizeTriggerFieldContext:visualizeTriggerFieldContext,dispatch:dispatch});setVisualizeTriggerFieldContext(undefined)}},[allLoaded]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const activeDatasource=state.activeDatasourceId&&!state.datasourceStates[state.activeDatasourceId].isLoading?props.datasourceMap[state.activeDatasourceId]:undefined;if(!activeDatasource||!activeVisualization){return}props.onChange(getSavedObjectFormat({activeDatasources:Object.keys(state.datasourceStates).reduce((datasourceMap,datasourceId)=>({...datasourceMap,[datasourceId]:props.datasourceMap[datasourceId]}),{}),visualization:activeVisualization,state:state,framePublicAPI:framePublicAPI}))},[activeVisualization,state.datasourceStates,state.visualization,state.activeData,props.query,props.filters,props.savedQuery,state.title]);const getSuggestionForField=external_kbnSharedDeps_React_default.a.useCallback(field=>{const{activeDatasourceId:activeDatasourceId,datasourceStates:datasourceStates}=state;const activeVisualizationId=state.visualization.activeId;const visualizationState=state.visualization.state;const{visualizationMap:visualizationMap,datasourceMap:datasourceMap}=props;if(!field||!activeDatasourceId){return}return getTopSuggestionForField(datasourceLayers,activeVisualizationId,visualizationMap,visualizationState,datasourceMap[activeDatasourceId],datasourceStates,field)},[state.visualization.state,props.datasourceMap,props.visualizationMap,state.activeDatasourceId,state.datasourceStates]);const hasSuggestionForField=Object(external_kbnSharedDeps_React_["useCallback"])(field=>getSuggestionForField(field)!==undefined,[getSuggestionForField]);const dropOntoWorkspace=Object(external_kbnSharedDeps_React_["useCallback"])(field=>{const suggestion=getSuggestionForField(field);if(suggestion){Object(lens_ui_telemetry["e"])("drop_onto_workspace");switchToSuggestion(dispatch,suggestion,"SWITCH_VISUALIZATION")}},[getSuggestionForField]);return external_kbnSharedDeps_React_default.a.createElement(drag_drop["RootDragDropProvider"],null,external_kbnSharedDeps_React_default.a.createElement(FrameLayout,{dataPanel:external_kbnSharedDeps_React_default.a.createElement(DataPanelWrapper,{datasourceMap:props.datasourceMap,activeDatasource:state.activeDatasourceId,datasourceState:state.activeDatasourceId?state.datasourceStates[state.activeDatasourceId].state:null,datasourceIsLoading:state.activeDatasourceId?state.datasourceStates[state.activeDatasourceId].isLoading:true,dispatch:dispatch,core:props.core,query:props.query,dateRange:props.dateRange,filters:props.filters,showNoDataPopover:props.showNoDataPopover,dropOntoWorkspace:dropOntoWorkspace,hasSuggestionForField:hasSuggestionForField}),configPanel:allLoaded&&external_kbnSharedDeps_React_default.a.createElement(config_panel_ConfigPanelWrapper,{activeDatasourceId:state.activeDatasourceId,datasourceMap:props.datasourceMap,datasourceStates:state.datasourceStates,visualizationMap:props.visualizationMap,activeVisualizationId:state.visualization.activeId,dispatch:dispatch,visualizationState:state.visualization.state,framePublicAPI:framePublicAPI,core:props.core}),workspacePanel:allLoaded&&external_kbnSharedDeps_React_default.a.createElement(workspace_panel_WorkspacePanel,{title:state.title,activeDatasourceId:state.activeDatasourceId,activeVisualizationId:state.visualization.activeId,datasourceMap:props.datasourceMap,datasourceStates:state.datasourceStates,framePublicAPI:framePublicAPI,visualizationState:state.visualization.state,visualizationMap:props.visualizationMap,dispatch:dispatch,ExpressionRenderer:props.ExpressionRenderer,core:props.core,plugins:props.plugins,visualizeTriggerFieldContext:visualizeTriggerFieldContext,getSuggestionForField:getSuggestionForField}),suggestionsPanel:allLoaded&&external_kbnSharedDeps_React_default.a.createElement(SuggestionPanel,{frame:framePublicAPI,activeDatasourceId:state.activeDatasourceId,activeVisualizationId:state.visualization.activeId,datasourceMap:props.datasourceMap,datasourceStates:state.datasourceStates,visualizationState:state.visualization.state,visualizationMap:props.visualizationMap,dispatch:dispatch,ExpressionRenderer:props.ExpressionRenderer,stagedPreview:state.stagedPreview,plugins:props.plugins})}))}var external_kbnSharedDeps_RxjsOperators_=__webpack_require__(29);var fast_deep_equal=__webpack_require__(303);var fast_deep_equal_default=__webpack_require__.n(fast_deep_equal);var embeddable_public_=__webpack_require__(5);function VisualizationErrorPanel({errors:errors}){return external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsEmbeddedError"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"alert",iconColor:"danger","data-test-subj":"embeddable-lens-failure",body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,errors?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",null,errors[0].longMessage),errors.length>1?external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.embeddable.moreErrors",defaultMessage:"Edit in Lens editor to see more errors"})):null):external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.embeddable.failure",defaultMessage:"Visualization couldn't be displayed"})))}))}function ExpressionWrapper({ExpressionRenderer:ExpressionRendererComponent,expression:expression,searchContext:searchContext,variables:variables,handleEvent:handleEvent,searchSessionId:searchSessionId,onData$:onData$,renderMode:renderMode,syncColors:syncColors,hasCompatibleActions:hasCompatibleActions,style:style,className:className,errors:errors}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,errors||expression===null||expression===""?external_kbnSharedDeps_React_default.a.createElement(VisualizationErrorPanel,{errors:errors}):external_kbnSharedDeps_React_default.a.createElement("div",{className:classnames_default()("lnsExpressionRenderer",className),style:style},external_kbnSharedDeps_React_default.a.createElement(ExpressionRendererComponent,{className:"lnsExpressionRenderer__component",padding:"s",variables:variables,expression:expression,searchContext:searchContext,searchSessionId:searchSessionId,onData$:onData$,renderMode:renderMode,syncColors:syncColors,renderError:(errorMessage,error)=>external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"expression-renderer-error"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",alignItems:"center",justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"alert",color:"danger"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},getOriginalRequestErrorMessage(error)||errorMessage)))),onEvent:handleEvent,hasCompatibleActions:hasCompatibleActions})))}function embeddable_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class embeddable_Embeddable extends embeddable_public_["Embeddable"]{constructor(deps,initialInput,parent){super(initialInput,{editApp:"lens"},parent);this.deps=deps;embeddable_defineProperty(this,"type",common["DOC_TYPE"]);embeddable_defineProperty(this,"expressionRenderer",void 0);embeddable_defineProperty(this,"savedVis",void 0);embeddable_defineProperty(this,"expression",void 0);embeddable_defineProperty(this,"domNode",void 0);embeddable_defineProperty(this,"subscription",void 0);embeddable_defineProperty(this,"isInitialized",false);embeddable_defineProperty(this,"activeData",void 0);embeddable_defineProperty(this,"errors",void 0);embeddable_defineProperty(this,"externalSearchContext",{});embeddable_defineProperty(this,"updateActiveData",(data,inspectorAdapters)=>{this.activeData=inspectorAdapters});embeddable_defineProperty(this,"hasCompatibleActions",async event=>{if(isLensTableRowContextMenuClickEvent(event)){const{getTriggerCompatibleActions:getTriggerCompatibleActions}=this.deps;if(!getTriggerCompatibleActions){return false}const actions=await getTriggerCompatibleActions(visualizations_public_["VIS_EVENT_TO_TRIGGER"][event.name],{data:event.data,embeddable:this});return actions.length>0}return false});embeddable_defineProperty(this,"handleEvent",event=>{if(!this.deps.getTrigger||this.input.disableTriggers){return}if(isLensBrushEvent(event)){this.deps.getTrigger(visualizations_public_["VIS_EVENT_TO_TRIGGER"][event.name]).exec({data:event.data,embeddable:this})}if(isLensFilterEvent(event)){this.deps.getTrigger(visualizations_public_["VIS_EVENT_TO_TRIGGER"][event.name]).exec({data:event.data,embeddable:this})}if(isLensTableRowContextMenuClickEvent(event)){this.deps.getTrigger(visualizations_public_["VIS_EVENT_TO_TRIGGER"][event.name]).exec({data:event.data,embeddable:this},true)}});embeddable_defineProperty(this,"inputIsRefType",input=>this.deps.attributeService.inputIsRefType(input));embeddable_defineProperty(this,"getInputAsRefType",async()=>{const input=this.deps.attributeService.getExplicitInputFromEmbeddable(this);return this.deps.attributeService.getInputAsRefType(input,{showSaveModal:true,saveModalTitle:this.getTitle()})});embeddable_defineProperty(this,"getInputAsValueType",async()=>{const input=this.deps.attributeService.getExplicitInputFromEmbeddable(this);return this.deps.attributeService.getInputAsValueType(input)});this.expressionRenderer=deps.expressionRenderer;this.initializeSavedVis(initialInput).then(()=>this.onContainerStateChanged(initialInput));this.subscription=this.getUpdated$().subscribe(()=>this.onContainerStateChanged(this.input));const input$=this.getInput$();input$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(input=>{var _input$enhancements;return(_input$enhancements=input.enhancements)===null||_input$enhancements===void 0?void 0:_input$enhancements.dynamicActions}),Object(external_kbnSharedDeps_RxjsOperators_["distinctUntilChanged"])((a,b)=>fast_deep_equal_default()(a,b)),Object(external_kbnSharedDeps_RxjsOperators_["skip"])(1)).subscribe(input=>{this.reload()});input$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(input=>input.viewMode),Object(external_kbnSharedDeps_RxjsOperators_["distinctUntilChanged"])(),Object(external_kbnSharedDeps_RxjsOperators_["skip"])(1)).subscribe(input=>{this.reload()});input$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["distinctUntilChanged"])((a,b)=>fast_deep_equal_default()(["attributes"in a&&a.attributes,"savedObjectId"in a&&a.savedObjectId],["attributes"in b&&b.attributes,"savedObjectId"in b&&b.savedObjectId])),Object(external_kbnSharedDeps_RxjsOperators_["skip"])(1)).subscribe(async input=>{await this.initializeSavedVis(input);this.reload()});this.getUpdated$().pipe(Object(external_kbnSharedDeps_RxjsOperators_["map"])(()=>this.getInput())).pipe(Object(external_kbnSharedDeps_RxjsOperators_["distinctUntilChanged"])((a,b)=>fast_deep_equal_default()([a.filters,a.query,a.timeRange,a.searchSessionId],[b.filters,b.query,b.timeRange,b.searchSessionId])),Object(external_kbnSharedDeps_RxjsOperators_["skip"])(1)).subscribe(async input=>{this.onContainerStateChanged(input)})}supportedTriggers(){if(!this.savedVis){return[]}switch(this.savedVis.visualizationType){case"lnsXY":return[visualizations_public_["VIS_EVENT_TO_TRIGGER"].filter,visualizations_public_["VIS_EVENT_TO_TRIGGER"].brush];case"lnsDatatable":return[visualizations_public_["VIS_EVENT_TO_TRIGGER"].filter,visualizations_public_["VIS_EVENT_TO_TRIGGER"].tableRowContextMenuClick];case"lnsPie":return[visualizations_public_["VIS_EVENT_TO_TRIGGER"].filter];case"lnsMetric":default:return[]}}getInspectorAdapters(){return this.activeData}async initializeSavedVis(input){const attributes=await this.deps.attributeService.unwrapAttributes(input).catch(e=>{this.onFatalError(e);return false});if(!attributes){return}this.savedVis={...attributes,type:this.type,savedObjectId:input===null||input===void 0?void 0:input.savedObjectId};const{ast:ast,errors:errors}=await this.deps.documentToExpression(this.savedVis);this.errors=errors;this.expression=ast?Object(target_common["toExpression"])(ast):null;await this.initializeOutput();this.isInitialized=true}onContainerStateChanged(containerState){if(this.handleContainerStateChanged(containerState))this.reload()}handleContainerStateChanged(containerState){let isDirty=false;const cleanedFilters=containerState.filters?containerState.filters.filter(filter=>!filter.meta.disabled):undefined;if(!external_kbnSharedDeps_Lodash_default.a.isEqual(containerState.timeRange,this.externalSearchContext.timeRange)||!external_kbnSharedDeps_Lodash_default.a.isEqual(containerState.query,this.externalSearchContext.query)||!external_kbnSharedDeps_Lodash_default.a.isEqual(cleanedFilters,this.externalSearchContext.filters)||this.externalSearchContext.searchSessionId!==containerState.searchSessionId){this.externalSearchContext={timeRange:containerState.timeRange,query:containerState.query,filters:cleanedFilters,searchSessionId:containerState.searchSessionId};isDirty=true}return isDirty}render(domNode){this.domNode=domNode;if(!this.savedVis||!this.isInitialized){return}const input=this.getInput();Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(ExpressionWrapper,{ExpressionRenderer:this.expressionRenderer,expression:this.expression||null,errors:this.errors,searchContext:this.getMergedSearchContext(),variables:input.palette?{theme:{palette:input.palette}}:{},searchSessionId:this.externalSearchContext.searchSessionId,handleEvent:this.handleEvent,onData$:this.updateActiveData,renderMode:input.renderMode,syncColors:input.syncColors,hasCompatibleActions:this.hasCompatibleActions,className:input.className,style:input.style}),domNode)}getMergedSearchContext(){var _this$externalSearchC;if(!this.savedVis){throw new Error("savedVis is required for getMergedSearchContext")}const output={timeRange:this.externalSearchContext.timeRange};if(this.externalSearchContext.query){output.query=[this.externalSearchContext.query,this.savedVis.state.query]}else{output.query=[this.savedVis.state.query]}if((_this$externalSearchC=this.externalSearchContext.filters)!==null&&_this$externalSearchC!==void 0&&_this$externalSearchC.length){output.filters=[...this.externalSearchContext.filters,...this.savedVis.state.filters]}else{output.filters=[...this.savedVis.state.filters]}output.filters=injectFilterReferences(output.filters,this.savedVis.references);return output}async reload(){if(!this.savedVis||!this.isInitialized){return}this.handleContainerStateChanged(this.input);if(this.domNode){this.render(this.domNode)}}async initializeOutput(){if(!this.savedVis){return}const promises=external_kbnSharedDeps_Lodash_default.a.uniqBy(this.savedVis.references.filter(({type:type})=>type==="index-pattern"),"id").map(async({id:id})=>{try{return await this.deps.indexPatternService.get(id)}catch(error){return null}}).filter(promise=>Boolean(promise));const indexPatterns=await Promise.all(promises);const input=this.getInput();const title=input.hidePanelTitles?"":input.title||this.savedVis.title;const savedObjectId=input.savedObjectId;this.updateOutput({...this.getOutput(),defaultTitle:this.savedVis.title,editable:this.getIsEditable(),title:title,editPath:Object(common["getEditPath"])(savedObjectId),editUrl:this.deps.basePath.prepend(`/app/lens${Object(common["getEditPath"])(savedObjectId)}`),indexPatterns:indexPatterns})}getIsEditable(){return this.deps.capabilities.canSaveVisualizations||!this.inputIsRefType(this.getInput())&&this.deps.capabilities.canSaveDashboards}getDescription(){return this.savedVis&&this.savedVis.description}destroy(){super.destroy();if(this.domNode){Object(external_kbnSharedDeps_ReactDom_["unmountComponentAtNode"])(this.domNode)}if(this.subscription){this.subscription.unsubscribe()}}}var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(30);var kibanaUtils_public_=__webpack_require__(11);var app=__webpack_require__(53);var share_public_=__webpack_require__(31);var savedObjects_public_=__webpack_require__(26);function getLensTopNavConfig(options){const{actions:actions,showCancel:showCancel,allowByValue:allowByValue,enableExportToCSV:enableExportToCSV,showSaveAndReturn:showSaveAndReturn,savingToLibraryPermitted:savingToLibraryPermitted,savingToDashboardPermitted:savingToDashboardPermitted}=options;const topNavMenu=[];const enableSaveButton=savingToLibraryPermitted||allowByValue&&savingToDashboardPermitted&&!options.isByValueMode&&!options.showSaveAndReturn;const saveButtonLabel=options.isByValueMode?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.addToLibrary",{defaultMessage:"Save to library"}):options.showSaveAndReturn?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveAs",{defaultMessage:"Save as"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.save",{defaultMessage:"Save"});topNavMenu.push({label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.downloadCSV",{defaultMessage:"Download as CSV"}),run:actions.exportToCSV,testId:"lnsApp_downloadCSVButton",description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.downloadButtonAriaLabel",{defaultMessage:"Download the data as CSV file"}),disableButton:!enableExportToCSV});if(showCancel){topNavMenu.push({label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.cancel",{defaultMessage:"Cancel"}),run:actions.cancel,testId:"lnsApp_cancelButton",description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.cancelButtonAriaLabel",{defaultMessage:"Return to the last app without saving changes"})})}topNavMenu.push({label:saveButtonLabel,iconType:!showSaveAndReturn?"save":undefined,emphasize:!showSaveAndReturn,run:actions.showSaveModal,testId:"lnsApp_saveButton",description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveButtonAriaLabel",{defaultMessage:"Save the current lens visualization"}),disableButton:!enableSaveButton});if(showSaveAndReturn){topNavMenu.push({label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveAndReturn",{defaultMessage:"Save and return"}),emphasize:true,iconType:"checkInCircleFilled",run:actions.saveAndReturn,testId:"lnsApp_saveAndReturnButton",disableButton:!savingToDashboardPermitted,description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveAndReturnButtonAriaLabel",{defaultMessage:"Save the current lens visualization and return to the last app"})})}return topNavMenu}function tags_saved_object_save_modal_origin_wrapper_extends(){tags_saved_object_save_modal_origin_wrapper_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return tags_saved_object_save_modal_origin_wrapper_extends.apply(this,arguments)}const TagEnhancedSavedObjectSaveModalOrigin=({initialTags:initialTags,onSave:onSave,savedObjectsTagging:savedObjectsTagging,options:options,...otherProps})=>{const[selectedTags,setSelectedTags]=Object(external_kbnSharedDeps_React_["useState"])(initialTags);const tagSelectorOption=Object(external_kbnSharedDeps_React_["useMemo"])(()=>savedObjectsTagging?external_kbnSharedDeps_React_default.a.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector,{initialSelection:initialTags,onTagsSelected:setSelectedTags}):undefined,[savedObjectsTagging,initialTags]);const tagEnhancedOptions=typeof options==="function"?state=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,tagSelectorOption,options(state)):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,tagSelectorOption,options);const tagEnhancedOnSave=Object(external_kbnSharedDeps_React_["useCallback"])(saveOptions=>{onSave({...saveOptions,newTags:selectedTags})},[onSave,selectedTags]);return external_kbnSharedDeps_React_default.a.createElement(savedObjects_public_["SavedObjectSaveModalOrigin"],tags_saved_object_save_modal_origin_wrapper_extends({},otherProps,{onSave:tagEnhancedOnSave,options:tagEnhancedOptions}))};var presentationUtil_public_=__webpack_require__(32);function tags_saved_object_save_modal_dashboard_wrapper_extends(){tags_saved_object_save_modal_dashboard_wrapper_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return tags_saved_object_save_modal_dashboard_wrapper_extends.apply(this,arguments)}const TagEnhancedSavedObjectSaveModalDashboard=({initialTags:initialTags,onSave:onSave,savedObjectsTagging:savedObjectsTagging,...otherProps})=>{const[selectedTags,setSelectedTags]=Object(external_kbnSharedDeps_React_["useState"])(initialTags);const tagSelectorOption=Object(external_kbnSharedDeps_React_["useMemo"])(()=>savedObjectsTagging?external_kbnSharedDeps_React_default.a.createElement(savedObjectsTagging.ui.components.SavedObjectSaveModalTagSelector,{initialSelection:initialTags,onTagsSelected:setSelectedTags}):undefined,[savedObjectsTagging,initialTags]);const tagEnhancedOptions=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,tagSelectorOption);const tagEnhancedOnSave=Object(external_kbnSharedDeps_React_["useCallback"])(saveOptions=>{onSave({...saveOptions,returnToOrigin:false,newTags:selectedTags})},[onSave,selectedTags]);return external_kbnSharedDeps_React_default.a.createElement(presentationUtil_public_["SavedObjectSaveModalDashboard"],tags_saved_object_save_modal_dashboard_wrapper_extends({},otherProps,{onSave:tagEnhancedOnSave,tagOptions:tagEnhancedOptions}))};const SaveModal=props=>{if(!props.isVisible||!props.lastKnownDoc){return null}const{originatingApp:originatingApp,savingToLibraryPermitted:savingToLibraryPermitted,savedObjectsTagging:savedObjectsTagging,tagsIds:tagsIds,lastKnownDoc:lastKnownDoc,allowByValueEmbeddables:allowByValueEmbeddables,returnToOriginSwitchLabel:returnToOriginSwitchLabel,getAppNameFromId:getAppNameFromId,onClose:onClose,onSave:onSave}=props;if(originatingApp||!allowByValueEmbeddables){return external_kbnSharedDeps_React_default.a.createElement(TagEnhancedSavedObjectSaveModalOrigin,{savedObjectsTagging:savedObjectsTagging,initialTags:tagsIds,originatingApp:originatingApp,onClose:onClose,onSave:saveProps=>onSave(saveProps,{saveToLibrary:true}),getAppNameFromId:getAppNameFromId,documentInfo:{id:lastKnownDoc.savedObjectId,title:lastKnownDoc.title||"",description:lastKnownDoc.description||""},returnToOriginSwitchLabel:returnToOriginSwitchLabel,objectType:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveModalType",{defaultMessage:"Lens visualization"}),"data-test-subj":"lnsApp_saveModalOrigin"})}return external_kbnSharedDeps_React_default.a.createElement(TagEnhancedSavedObjectSaveModalDashboard,{savedObjectsTagging:savedObjectsTagging,initialTags:tagsIds,canSaveByReference:Boolean(savingToLibraryPermitted),onSave:saveProps=>{const saveToLibrary=Boolean(saveProps.addToLibrary);onSave(saveProps,{saveToLibrary:saveToLibrary})},onClose:onClose,documentInfo:{id:savingToLibraryPermitted?lastKnownDoc.savedObjectId:undefined,title:lastKnownDoc.title||"",description:lastKnownDoc.description||""},objectType:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveModalType",{defaultMessage:"Lens visualization"}),"data-test-subj":"lnsApp_saveModalDashboard"})};var external_kbnSharedDeps_Moment_=__webpack_require__(25);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);function containsDynamicMath(dateMathString){return dateMathString.includes("now")}const TIME_LAG_PERCENTAGE_LIMIT=.02;function useTimeRange(data,lastKnownDoc,setState,searchSessionId){const timefilter=data.query.timefilter.timefilter;const{from:from,to:to}=data.query.timefilter.timefilter.getTime();const resolvedDateRange=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const{min:min,max:max}=timefilter.calculateBounds({from:from,to:to});return{fromDate:(min===null||min===void 0?void 0:min.toISOString())||from,toDate:(max===null||max===void 0?void 0:max.toISOString())||to}},[timefilter,searchSessionId,from,to]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const unresolvedTimeRange=timefilter.getTime();if(!containsDynamicMath(unresolvedTimeRange.from)&&!containsDynamicMath(unresolvedTimeRange.to)){return}const{min:min,max:max}=timefilter.getBounds();if(!min||!max){return}const timeRangeLength=external_kbnSharedDeps_Moment_default.a.duration(max.diff(min)).asMilliseconds();const nowDiff=Date.now()-data.nowProvider.get().valueOf();if(nowDiff>timeRangeLength*TIME_LAG_PERCENTAGE_LIMIT){setState(s=>({...s,searchSessionId:data.search.session.start()}))}},[data.nowProvider,data.search.session,timefilter,lastKnownDoc,setState]);return{resolvedDateRange:resolvedDateRange,from:from,to:to}}function App({history:history,onAppLeave:onAppLeave,redirectTo:redirectTo,editorFrame:editorFrame,initialInput:initialInput,incomingState:incomingState,redirectToOrigin:redirectToOrigin,redirectToDashboard:redirectToDashboard,setHeaderActionMenu:setHeaderActionMenu,initialContext:initialContext}){var _state$persistedDoc3,_state$persistedDoc4,_application$capabili;const{data:data,chrome:chrome,overlays:overlays,navigation:navigation,uiSettings:uiSettings,application:application,stateTransfer:stateTransfer,notifications:notifications,attributeService:attributeService,savedObjectsClient:savedObjectsClient,savedObjectsTagging:savedObjectsTagging,getOriginatingAppName:getOriginatingAppName,dashboardFeatureFlag:dashboardFeatureFlag}=Object(public_["useKibana"])().services;const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])(()=>({query:data.query.queryString.getQuery(),filters:!initialContext?data.query.filterManager.getGlobalFilters():data.query.filterManager.getFilters(),isLoading:Boolean(initialInput),indexPatternsForTopNav:[],isLinkedToOriginatingApp:Boolean(incomingState===null||incomingState===void 0?void 0:incomingState.originatingApp),isSaveModalVisible:false,indicateNoData:false,isSaveable:false,searchSessionId:data.search.session.start()}));const{lastKnownDoc:lastKnownDoc}=state;const showNoDataPopover=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setState(prevState=>({...prevState,indicateNoData:true}))},[setState]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(state.indicateNoData){setState(prevState=>({...prevState,indicateNoData:false}))}},[setState,state.indicateNoData,state.query,state.filters,state.indexPatternsForTopNav,state.searchSessionId]);const{resolvedDateRange:resolvedDateRange,from:fromDate,to:toDate}=useTimeRange(data,state.lastKnownDoc,setState,state.searchSessionId);const onError=Object(external_kbnSharedDeps_React_["useCallback"])(e=>notifications.toasts.addDanger({title:e.message}),[notifications.toasts]);const getLastKnownDocWithoutPinnedFilters=Object(external_kbnSharedDeps_React_["useCallback"])((function(){var _lastKnownDoc$state;if(!lastKnownDoc)return undefined;const[pinnedFilters,appFilters]=external_kbnSharedDeps_Lodash_default.a.partition(injectFilterReferences(((_lastKnownDoc$state=lastKnownDoc.state)===null||_lastKnownDoc$state===void 0?void 0:_lastKnownDoc$state.filters)||[],lastKnownDoc.references),data_public_["esFilters"].isFilterPinned);return pinnedFilters!==null&&pinnedFilters!==void 0&&pinnedFilters.length?{...lastKnownDoc,state:{...lastKnownDoc.state,filters:appFilters}}:lastKnownDoc}),[lastKnownDoc]);const getIsByValueMode=Object(external_kbnSharedDeps_React_["useCallback"])(()=>Boolean(dashboardFeatureFlag.allowByValueEmbeddables&&state.isLinkedToOriginatingApp&&!(initialInput!==null&&initialInput!==void 0&&initialInput.savedObjectId)),[dashboardFeatureFlag.allowByValueEmbeddables,state.isLinkedToOriginatingApp,initialInput]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!initialContext){data.query.filterManager.setAppFilters([])}const filterSubscription=data.query.filterManager.getUpdates$().subscribe({next:()=>{setState(s=>({...s,filters:data.query.filterManager.getFilters(),searchSessionId:data.search.session.start()}));Object(lens_ui_telemetry["e"])("app_filters_updated")}});const timeSubscription=data.query.timefilter.timefilter.getTimeUpdate$().subscribe({next:()=>{setState(s=>({...s,searchSessionId:data.search.session.start()}))}});const autoRefreshSubscription=data.query.timefilter.timefilter.getAutoRefreshFetch$().subscribe({next:()=>{setState(s=>({...s,searchSessionId:data.search.session.start()}))}});const kbnUrlStateStorage=Object(kibanaUtils_public_["createKbnUrlStateStorage"])({history:history,useHash:uiSettings.get("state:storeInSessionStorage"),...Object(kibanaUtils_public_["withNotifyOnErrors"])(notifications.toasts)});const{stop:stopSyncingQueryServiceStateWithUrl}=Object(data_public_["syncQueryStateWithUrl"])(data.query,kbnUrlStateStorage);return()=>{stopSyncingQueryServiceStateWithUrl();filterSubscription.unsubscribe();timeSubscription.unsubscribe();autoRefreshSubscription.unsubscribe()}},[data.query.filterManager,data.query.timefilter.timefilter,data.search.session,notifications.toasts,uiSettings,data.query,history,initialContext]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{onAppLeave(actions=>{var _state$persistedDoc,_getLastKnownDocWitho;if(application.capabilities.visualize.save&&!external_kbnSharedDeps_Lodash_default.a.isEqual((_state$persistedDoc=state.persistedDoc)===null||_state$persistedDoc===void 0?void 0:_state$persistedDoc.state,(_getLastKnownDocWitho=getLastKnownDocWithoutPinnedFilters())===null||_getLastKnownDocWitho===void 0?void 0:_getLastKnownDocWitho.state)&&(state.isSaveable||state.persistedDoc)){return actions.confirm(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.unsavedWorkMessage",{defaultMessage:"Leave Lens with unsaved work?"}),external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.unsavedWorkTitle",{defaultMessage:"Unsaved changes"}))}else{return actions.default()}})},[onAppLeave,lastKnownDoc,state.isSaveable,state.persistedDoc,getLastKnownDocWithoutPinnedFilters,application.capabilities.visualize.save]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const isByValueMode=getIsByValueMode();const breadcrumbs=[];if(state.isLinkedToOriginatingApp&&getOriginatingAppName()&&redirectToOrigin){breadcrumbs.push({onClick:()=>{redirectToOrigin()},text:getOriginatingAppName()})}if(!isByValueMode){breadcrumbs.push({href:application.getUrlForApp("visualize"),onClick:e=>{application.navigateToApp("visualize",{path:"/"});e.preventDefault()},text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.breadcrumbsTitle",{defaultMessage:"Visualize Library"})})}let currentDocTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.breadcrumbsCreate",{defaultMessage:"Create"});if(state.persistedDoc){currentDocTitle=isByValueMode?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.breadcrumbsByValue",{defaultMessage:"Edit visualization"}):state.persistedDoc.title}breadcrumbs.push({text:currentDocTitle});chrome.setBreadcrumbs(breadcrumbs)},[dashboardFeatureFlag.allowByValueEmbeddables,state.isLinkedToOriginatingApp,getOriginatingAppName,state.persistedDoc,redirectToOrigin,getIsByValueMode,initialInput,application,chrome]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{var _state$persistedDoc2;if(!initialInput||attributeService.inputIsRefType(initialInput)&&initialInput.savedObjectId===((_state$persistedDoc2=state.persistedDoc)===null||_state$persistedDoc2===void 0?void 0:_state$persistedDoc2.savedObjectId)){return}setState(s=>({...s,isLoading:true}));attributeService.unwrapAttributes(initialInput).then(attributes=>{if(!initialInput){return}const doc={...initialInput,...attributes,type:common["LENS_EMBEDDABLE_TYPE"]};if(attributeService.inputIsRefType(initialInput)){chrome.recentlyAccessed.add(Object(common["getFullPath"])(initialInput.savedObjectId),attributes.title,initialInput.savedObjectId)}getAllIndexPatterns(external_kbnSharedDeps_Lodash_default.a.uniq(doc.references.filter(({type:type})=>type==="index-pattern").map(({id:id})=>id)),data.indexPatterns,notifications).then(indexPatterns=>{data.query.filterManager.setAppFilters(injectFilterReferences(doc.state.filters,doc.references));setState(s=>({...s,isLoading:false,persistedDoc:doc,lastKnownDoc:doc,query:doc.state.query,indexPatternsForTopNav:indexPatterns}))}).catch(e=>{setState(s=>({...s,isLoading:false}));redirectTo()})}).catch(e=>{setState(s=>({...s,isLoading:false}));notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.docLoadingError",{defaultMessage:"Error loading saved document"}));redirectTo()})},[notifications,data.indexPatterns,data.query.filterManager,initialInput,attributeService,redirectTo,chrome.recentlyAccessed,(_state$persistedDoc3=state.persistedDoc)===null||_state$persistedDoc3===void 0?void 0:_state$persistedDoc3.savedObjectId,(_state$persistedDoc4=state.persistedDoc)===null||_state$persistedDoc4===void 0?void 0:_state$persistedDoc4.state]);const tagsIds=state.persistedDoc&&savedObjectsTagging?savedObjectsTagging.ui.getTagIdsFromReferences(state.persistedDoc.references):[];const runSave=async(saveProps,options)=>{if(!lastKnownDoc){return}let references=lastKnownDoc.references;if(savedObjectsTagging){references=savedObjectsTagging.ui.updateTagsReferences(references,saveProps.newTags||tagsIds)}const docToSave={...getLastKnownDocWithoutPinnedFilters(),description:saveProps.newDescription,title:saveProps.newTitle,references:references};if(getIsByValueMode()){docToSave.state.filters.forEach(filter=>{if(typeof filter.meta.value==="function"){delete filter.meta.value}})}const originalInput=saveProps.newCopyOnSave?undefined:initialInput;const originalSavedObjectId=originalInput===null||originalInput===void 0?void 0:originalInput.savedObjectId;if(options.saveToLibrary){try{await Object(savedObjects_public_["checkForDuplicateTitle"])({id:originalSavedObjectId,title:docToSave.title,copyOnSave:saveProps.newCopyOnSave,lastSavedTitle:lastKnownDoc.title,getEsType:()=>"lens",getDisplayName:()=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveModalType",{defaultMessage:"Lens visualization"})},saveProps.isTitleDuplicateConfirmed,saveProps.onTitleDuplicate,{savedObjectsClient:savedObjectsClient,overlays:overlays})}catch(e){return}}try{const newInput=await attributeService.wrapAttributes(docToSave,options.saveToLibrary,originalInput);if(saveProps.returnToOrigin&&redirectToOrigin){onAppLeave(actions=>actions.default());redirectToOrigin({input:newInput,isCopied:saveProps.newCopyOnSave});return}else if(saveProps.dashboardId&&redirectToDashboard){onAppLeave(actions=>actions.default());redirectToDashboard(newInput,saveProps.dashboardId);return}notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.saveVisualization.successNotificationText",{defaultMessage:`Saved '{visTitle}'`,values:{visTitle:docToSave.title}}));if(attributeService.inputIsRefType(newInput)&&newInput.savedObjectId!==originalSavedObjectId){chrome.recentlyAccessed.add(Object(common["getFullPath"])(newInput.savedObjectId),docToSave.title,newInput.savedObjectId);setState(s=>({...s,isSaveModalVisible:false,isLinkedToOriginatingApp:false}));stateTransfer.clearEditorState(common["APP_ID"]);redirectTo(newInput.savedObjectId);return}const newDoc={...docToSave,...newInput};setState(s=>({...s,persistedDoc:newDoc,lastKnownDoc:newDoc,isSaveModalVisible:false,isLinkedToOriginatingApp:false}))}catch(e){console.dir(e);Object(lens_ui_telemetry["e"])("save_failed");setState(s=>({...s,isSaveModalVisible:false}))}};const lastKnownDocRef=Object(external_kbnSharedDeps_React_["useRef"])(state.lastKnownDoc);lastKnownDocRef.current=state.lastKnownDoc;const activeDataRef=Object(external_kbnSharedDeps_React_["useRef"])(state.activeData);activeDataRef.current=state.activeData;const{TopNavMenu:TopNavMenu}=navigation.ui;const savingToLibraryPermitted=Boolean(state.isSaveable&&application.capabilities.visualize.save);const savingToDashboardPermitted=Boolean(state.isSaveable&&((_application$capabili=application.capabilities.dashboard)===null||_application$capabili===void 0?void 0:_application$capabili.showWriteControls));const unsavedTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.unsavedFilename",{defaultMessage:"unsaved"});const topNavConfig=getLensTopNavConfig({showSaveAndReturn:Boolean(state.isLinkedToOriginatingApp&&(dashboardFeatureFlag.allowByValueEmbeddables||Boolean(initialInput))),enableExportToCSV:Boolean(state.isSaveable&&state.activeData&&Object.keys(state.activeData).length),isByValueMode:getIsByValueMode(),allowByValue:dashboardFeatureFlag.allowByValueEmbeddables,showCancel:Boolean(state.isLinkedToOriginatingApp),savingToLibraryPermitted:savingToLibraryPermitted,savingToDashboardPermitted:savingToDashboardPermitted,actions:{exportToCSV:()=>{if(!state.activeData){return}const datatables=Object.values(state.activeData);const content=datatables.reduce((memo,datatable,i)=>{if(datatable){const postFix=datatables.length>1?`-${i+1}`:"";memo[`${(lastKnownDoc===null||lastKnownDoc===void 0?void 0:lastKnownDoc.title)||unsavedTitle}${postFix}.csv`]={content:data_public_["exporters"].datatableToCSV(datatable,{csvSeparator:uiSettings.get("csv:separator",","),quoteValues:uiSettings.get("csv:quoteValues",true),formatFactory:data.fieldFormats.deserialize}),type:data_public_["exporters"].CSV_MIME_TYPE}}return memo},{});if(content){Object(share_public_["downloadMultipleAs"])(content)}},saveAndReturn:()=>{if(savingToDashboardPermitted&&lastKnownDoc){var _ref;onAppLeave(actions=>actions.default());runSave({newTitle:lastKnownDoc.title,newCopyOnSave:false,isTitleDuplicateConfirmed:false,returnToOrigin:true},{saveToLibrary:(_ref=initialInput&&attributeService.inputIsRefType(initialInput))!==null&&_ref!==void 0?_ref:false})}},showSaveModal:()=>{if(savingToDashboardPermitted||savingToLibraryPermitted){setState(s=>({...s,isSaveModalVisible:true}))}},cancel:()=>{if(redirectToOrigin){redirectToOrigin()}}}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsApp"},external_kbnSharedDeps_React_default.a.createElement("div",{className:"lnsApp__header"},external_kbnSharedDeps_React_default.a.createElement(TopNavMenu,{setMenuMountPoint:setHeaderActionMenu,config:topNavConfig,showSearchBar:true,showDatePicker:true,showQueryBar:true,showFilterBar:true,indexPatterns:state.indexPatternsForTopNav,showSaveQuery:Boolean(application.capabilities.visualize.saveQuery),savedQuery:state.savedQuery,"data-test-subj":"lnsApp_topNav",screenTitle:"lens",appName:"lens",onQuerySubmit:payload=>{const{dateRange:dateRange,query:query}=payload;const currentRange=data.query.timefilter.timefilter.getTime();if(dateRange.from!==currentRange.from||dateRange.to!==currentRange.to){data.query.timefilter.timefilter.setTime(dateRange);Object(lens_ui_telemetry["e"])("app_date_change")}else{setState(s=>({...s,searchSessionId:data.search.session.start()}));Object(lens_ui_telemetry["e"])("app_query_change")}setState(s=>({...s,query:query||s.query}))},onSaved:savedQuery=>{setState(s=>({...s,savedQuery:savedQuery}))},onSavedQueryUpdated:savedQuery=>{const savedQueryFilters=savedQuery.attributes.filters||[];const globalFilters=data.query.filterManager.getGlobalFilters();data.query.filterManager.setFilters([...globalFilters,...savedQueryFilters]);setState(s=>({...s,savedQuery:{...savedQuery}}))},onClearSavedQuery:()=>{data.query.filterManager.setFilters(data.query.filterManager.getGlobalFilters());setState(s=>({...s,savedQuery:undefined,filters:data.query.filterManager.getGlobalFilters(),query:data.query.queryString.getDefaultQuery()}))},query:state.query,dateRangeFrom:fromDate,dateRangeTo:toDate,indicateNoData:state.indicateNoData})),(!state.isLoading||state.persistedDoc)&&external_kbnSharedDeps_React_default.a.createElement(MemoizedEditorFrameWrapper,{editorFrame:editorFrame,resolvedDateRange:resolvedDateRange,onError:onError,showNoDataPopover:showNoDataPopover,initialContext:initialContext,setState:setState,data:data,notifications:notifications,query:state.query,filters:state.filters,searchSessionId:state.searchSessionId,isSaveable:state.isSaveable,savedQuery:state.savedQuery,persistedDoc:state.persistedDoc,indexPatterns:state.indexPatternsForTopNav,activeData:activeDataRef,lastKnownDoc:lastKnownDocRef})),external_kbnSharedDeps_React_default.a.createElement(SaveModal,{isVisible:state.isSaveModalVisible,originatingApp:state.isLinkedToOriginatingApp?incomingState===null||incomingState===void 0?void 0:incomingState.originatingApp:undefined,savingToLibraryPermitted:savingToLibraryPermitted,allowByValueEmbeddables:dashboardFeatureFlag.allowByValueEmbeddables,savedObjectsTagging:savedObjectsTagging,tagsIds:tagsIds,onSave:runSave,onClose:()=>{setState(s=>({...s,isSaveModalVisible:false}))},getAppNameFromId:()=>getOriginatingAppName(),lastKnownDoc:lastKnownDoc,returnToOriginSwitchLabel:getIsByValueMode()&&initialInput?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.updatePanel",{defaultMessage:"Update panel on {originatingAppName}",values:{originatingAppName:getOriginatingAppName()}}):undefined}))}const MemoizedEditorFrameWrapper=external_kbnSharedDeps_React_default.a.memo((function EditorFrameWrapper({editorFrame:editorFrame,query:query,filters:filters,searchSessionId:searchSessionId,isSaveable:oldIsSaveable,savedQuery:savedQuery,persistedDoc:persistedDoc,indexPatterns:indexPatternsForTopNav,resolvedDateRange:resolvedDateRange,onError:onError,showNoDataPopover:showNoDataPopover,initialContext:initialContext,setState:setState,data:data,notifications:notifications,lastKnownDoc:lastKnownDoc,activeData:activeDataRef}){return external_kbnSharedDeps_React_default.a.createElement(NativeRenderer,{className:"lnsApp__frame",render:editorFrame.mount,nativeProps:{searchSessionId:searchSessionId,dateRange:resolvedDateRange,query:query,filters:filters,savedQuery:savedQuery,doc:persistedDoc,onError:onError,showNoDataPopover:showNoDataPopover,initialContext:initialContext,onChange:({filterableIndexPatterns:filterableIndexPatterns,doc:doc,isSaveable:isSaveable,activeData:activeData})=>{if(isSaveable!==oldIsSaveable){setState(s=>({...s,isSaveable:isSaveable}))}if(!external_kbnSharedDeps_Lodash_default.a.isEqual(persistedDoc,doc)&&!external_kbnSharedDeps_Lodash_default.a.isEqual(lastKnownDoc.current,doc)){setState(s=>({...s,lastKnownDoc:doc}))}if(!external_kbnSharedDeps_Lodash_default.a.isEqual(activeDataRef.current,activeData)){setState(s=>({...s,activeData:activeData}))}if(indexPatternsForTopNav.length!==filterableIndexPatterns.length||filterableIndexPatterns.some(id=>!indexPatternsForTopNav.find(indexPattern=>indexPattern.id===id))){getAllIndexPatterns(filterableIndexPatterns,data.indexPatterns,notifications).then(indexPatterns=>{if(indexPatterns){setState(s=>({...s,indexPatternsForTopNav:indexPatterns}))}})}}}})}));async function getAllIndexPatterns(ids,indexPatternsService,notifications){try{return await Promise.all(ids.map(id=>indexPatternsService.get(id)))}catch(e){notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.app.indexPatternLoadingError",{defaultMessage:"Error loading index patterns"}));throw new Error(e)}}function addHelpMenuToAppChrome(chrome,docLinks){chrome.setHelpExtension({appName:"Lens",links:[{linkType:"documentation",href:docLinks.links.visualize.lensPanels},{linkType:"github",title:"[Lens]",labels:["Feature:Lens"]}]})}var uiActions_public_=__webpack_require__(2);function mounter_extends(){mounter_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return mounter_extends.apply(this,arguments)}async function mountApp(core,params,mountProps){const{createEditorFrame:createEditorFrame,getByValueFeatureFlag:getByValueFeatureFlag,attributeService:attributeService,getPresentationUtilContext:getPresentationUtilContext}=mountProps;const[coreStart,startDependencies]=await core.getStartServices();const{data:data,navigation:navigation,embeddable:embeddable,savedObjectsTagging:savedObjectsTagging}=startDependencies;const instance=await createEditorFrame();const storage=new kibanaUtils_public_["Storage"](localStorage);const stateTransfer=embeddable===null||embeddable===void 0?void 0:embeddable.getStateTransfer();const historyLocationState=params.history.location.state;const embeddableEditorIncomingState=stateTransfer===null||stateTransfer===void 0?void 0:stateTransfer.getIncomingEditorState(common["APP_ID"]);const lensServices={data:data,storage:storage,navigation:navigation,stateTransfer:stateTransfer,savedObjectsTagging:savedObjectsTagging,attributeService:await attributeService(),http:coreStart.http,chrome:coreStart.chrome,overlays:coreStart.overlays,uiSettings:coreStart.uiSettings,application:coreStart.application,notifications:coreStart.notifications,savedObjectsClient:coreStart.savedObjects.client,getOriginatingAppName:()=>embeddableEditorIncomingState!==null&&embeddableEditorIncomingState!==void 0&&embeddableEditorIncomingState.originatingApp?stateTransfer===null||stateTransfer===void 0?void 0:stateTransfer.getAppNameFromId(embeddableEditorIncomingState.originatingApp):undefined,dashboardFeatureFlag:await getByValueFeatureFlag()};addHelpMenuToAppChrome(coreStart.chrome,coreStart.docLinks);coreStart.chrome.docTitle.change(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.lens.pageTitle",{defaultMessage:"Lens"}));Object(lens_ui_telemetry["b"])(new lens_ui_telemetry["a"]({http:core.http,storage:storage}));const getInitialInput=(id,editByValue)=>{if(editByValue){return embeddableEditorIncomingState===null||embeddableEditorIncomingState===void 0?void 0:embeddableEditorIncomingState.valueInput}if(id){return{savedObjectId:id}}};const redirectTo=(history,savedObjectId)=>{if(!savedObjectId){history.push({pathname:"/",search:history.location.search})}else{history.push({pathname:`/edit/${savedObjectId}`,search:history.location.search})}};const redirectToDashboard=(embeddableInput,dashboardId)=>{if(!lensServices.dashboardFeatureFlag.allowByValueEmbeddables){throw new Error("redirectToDashboard called with by-value embeddables disabled")}const state={input:embeddableInput,type:common["LENS_EMBEDDABLE_TYPE"]};const path=dashboardId==="new"?"#/create":`#/view/${dashboardId}`;stateTransfer.navigateToWithEmbeddablePackage("dashboards",{state:state,path:path})};const redirectToOrigin=props=>{if(!(embeddableEditorIncomingState!==null&&embeddableEditorIncomingState!==void 0&&embeddableEditorIncomingState.originatingApp)){throw new Error("redirectToOrigin called without an originating app")}if(stateTransfer&&props!==null&&props!==void 0&&props.input){const{input:input,isCopied:isCopied}=props;stateTransfer.navigateToWithEmbeddablePackage(embeddableEditorIncomingState===null||embeddableEditorIncomingState===void 0?void 0:embeddableEditorIncomingState.originatingApp,{state:{embeddableId:isCopied?undefined:embeddableEditorIncomingState.embeddableId,type:common["LENS_EMBEDDABLE_TYPE"],input:input}})}else{coreStart.application.navigateToApp(embeddableEditorIncomingState===null||embeddableEditorIncomingState===void 0?void 0:embeddableEditorIncomingState.originatingApp)}};const EditorRenderer=external_kbnSharedDeps_React_default.a.memo(props=>{const redirectCallback=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{redirectTo(props.history,id)},[props.history]);Object(lens_ui_telemetry["e"])("loaded");return external_kbnSharedDeps_React_default.a.createElement(App,{incomingState:embeddableEditorIncomingState,editorFrame:instance,initialInput:getInitialInput(props.id,props.editByValue),redirectTo:redirectCallback,redirectToOrigin:redirectToOrigin,redirectToDashboard:redirectToDashboard,onAppLeave:params.onAppLeave,setHeaderActionMenu:params.setHeaderActionMenu,history:props.history,initialContext:historyLocationState&&historyLocationState.type===uiActions_public_["ACTION_VISUALIZE_LENS_FIELD"]?historyLocationState.payload:undefined})});const EditorRoute=routeProps=>external_kbnSharedDeps_React_default.a.createElement(EditorRenderer,{id:routeProps.match.params.id,history:routeProps.history,editByValue:routeProps.editByValue});function NotFound(){Object(lens_ui_telemetry["e"])("loaded_404");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.lens.app404",defaultMessage:"404 Not Found"})}const unlistenParentHistory=params.history.listen(()=>{window.dispatchEvent(new HashChangeEvent("hashchange"))});params.element.classList.add("lnsAppWrapper");const PresentationUtilContext=await getPresentationUtilContext();Object(external_kbnSharedDeps_ReactDom_["render"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(public_["KibanaContextProvider"],{services:lensServices},external_kbnSharedDeps_React_default.a.createElement(PresentationUtilContext,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["HashRouter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/edit/:id",component:EditorRoute}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:`/${common["LENS_EDIT_BY_VALUE"]}`,render:routeProps=>external_kbnSharedDeps_React_default.a.createElement(EditorRoute,mounter_extends({},routeProps,{editByValue:true}))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:"/",component:EditorRoute}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/",component:NotFound})))))),params.element);return()=>{data.search.session.clear();instance.unmount();Object(external_kbnSharedDeps_ReactDom_["unmountComponentAtNode"])(params.element);unlistenParentHistory()}}function documentToAttributes(doc){delete doc.savedObjectId;delete doc.type;return{...doc}}function getLensAttributeService(core,startDependencies){const savedObjectStore=new saved_object_store_SavedObjectIndexStore(core.savedObjects.client);return startDependencies.embeddable.getAttributeService(common["DOC_TYPE"],{saveMethod:async(attributes,savedObjectId)=>{const savedDoc=await savedObjectStore.save({...attributes,savedObjectId:savedObjectId,type:common["DOC_TYPE"]});return{id:savedDoc.savedObjectId}},unwrapMethod:async savedObjectId=>{const attributes=documentToAttributes(await savedObjectStore.load(savedObjectId));return attributes},checkForDuplicateTitle:props=>{const savedObjectsClient=core.savedObjects.client;const overlays=core.overlays;return Object(savedObjects_public_["checkForDuplicateTitle"])({title:props.newTitle,copyOnSave:false,lastSavedTitle:"",getEsType:()=>common["DOC_TYPE"],getDisplayName:()=>common["DOC_TYPE"]},props.isTitleDuplicateConfirmed,props.onTitleDuplicate,{savedObjectsClient:savedObjectsClient,overlays:overlays})}})}}])]);