/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["infra_bundle_jsonpfunction"]=window["infra_bundle_jsonpfunction"]||[]).push([[9],{100:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return METRIC_EXPLORER_AGGREGATIONS}));__webpack_require__.d(__webpack_exports__,"c",(function(){return metricsExplorerAggregationRT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return metricsExplorerMetricRT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return afterKeyObjectRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return metricsExplorerResponseRT}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);const METRIC_EXPLORER_AGGREGATIONS=["avg","max","min","cardinality","rate","count","sum","p95","p99"];const metricsExplorerAggregationKeys=METRIC_EXPLORER_AGGREGATIONS.reduce((acc,agg)=>({...acc,[agg]:null}),{});const metricsExplorerAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](metricsExplorerAggregationKeys);const metricsExplorerMetricRequiredFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({aggregation:metricsExplorerAggregationRT});const metricsExplorerMetricOptionalFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]])});const metricsExplorerMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([metricsExplorerMetricRequiredFieldsRT,metricsExplorerMetricOptionalFieldsRT]);const timeRangeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],from:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],to:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const metricsExplorerRequestBodyRequiredFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timerange:timeRangeRT,indexPattern:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerMetricRT)});const groupByRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]);const afterKeyObjectRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]));const metricsExplorerRequestBodyOptionalFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({groupBy:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([groupByRT,io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](groupByRT)]),afterKey:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],afterKeyObjectRT]),limit:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]),filterQuery:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]),forceInterval:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],dropLastBucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]});const metricsExplorerRequestBodyRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([metricsExplorerRequestBodyRequiredFieldsRT,metricsExplorerRequestBodyOptionalFieldsRT]);const metricsExplorerPageInfoRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({total:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],afterKey:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],afterKeyObjectRT])});const metricsExplorerColumnTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({date:null,number:null,string:null});const metricsExplorerColumnRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({name:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:metricsExplorerColumnTypeRT});const metricsExplorerRowRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timestamp:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["object"])]))]);const metricsExplorerSeriesRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],columns:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerColumnRT),rows:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerRowRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({keys:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])})]);const metricsExplorerResponseRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({series:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerSeriesRT),pageInfo:metricsExplorerPageInfoRT})},102:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(70);var useEffectOnce_1=tslib_1.__importDefault(__webpack_require__(123));var useMount=function(fn){useEffectOnce_1.default((function(){fn()}))};exports.default=useMount},103:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return convertKueryToElasticSearchQuery}));var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(31);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__);const convertKueryToElasticSearchQuery=(kueryExpression,indexPattern)=>{try{return kueryExpression?JSON.stringify(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__["esKuery"].toElasticsearchQuery(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__["esKuery"].fromKueryExpression(kueryExpression),indexPattern)):""}catch(err){return""}}},111:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useKibanaTimefilterTime}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useSyncKibanaTimeFilterTime}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_use_lib_useUpdateEffect__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(181);var react_use_lib_useUpdateEffect__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_use_lib_useUpdateEffect__WEBPACK_IMPORTED_MODULE_1__);var react_use_lib_useMount__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(102);var react_use_lib_useMount__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react_use_lib_useMount__WEBPACK_IMPORTED_MODULE_2__);var _use_kibana__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(28);const useKibanaTimefilterTime=({from:fromDefault,to:toDefault})=>{const{services:services}=Object(_use_kibana__WEBPACK_IMPORTED_MODULE_3__["b"])();const getTime=Object(react__WEBPACK_IMPORTED_MODULE_0__["useCallback"])(()=>{const timefilterService=services.data.query.timefilter.timefilter;return timefilterService.isTimeTouched()?timefilterService.getTime():{from:fromDefault,to:toDefault}},[services.data.query.timefilter.timefilter,fromDefault,toDefault]);return[getTime,services.data.query.timefilter.timefilter.setTime]};const useSyncKibanaTimeFilterTime=(defaults,currentTimeRange,setTimeRange)=>{const{services:services}=Object(_use_kibana__WEBPACK_IMPORTED_MODULE_3__["b"])();const[getTime,setTime]=useKibanaTimefilterTime(defaults);react_use_lib_useMount__WEBPACK_IMPORTED_MODULE_2___default()(()=>{if(defaults.from!==currentTimeRange.from||defaults.to!==currentTimeRange.to){setTime({from:currentTimeRange.from,to:currentTimeRange.to})}});react_use_lib_useUpdateEffect__WEBPACK_IMPORTED_MODULE_1___default()(()=>{setTime({from:currentTimeRange.from,to:currentTimeRange.to})},[currentTimeRange.from,currentTimeRange.to,setTime]);Object(react__WEBPACK_IMPORTED_MODULE_0__["useEffect"])(()=>{const sub=services.data.query.timefilter.timefilter.getTimeUpdate$().subscribe(()=>{if(setTimeRange){const timeRange=getTime();setTimeRange(timeRange)}});return()=>sub.unsubscribe()},[getTime,setTimeRange,services.data.query.timefilter.timefilter])}},120:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getChartTheme}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getTimelineChartTheme}));var _elastic_charts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(69);var _elastic_charts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_charts__WEBPACK_IMPORTED_MODULE_0__);function getChartTheme(isDarkMode){return isDarkMode?_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["DARK_THEME"]:_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["LIGHT_THEME"]}function getTimelineChartTheme(isDarkMode){return isDarkMode?_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["DARK_THEME"]:Object(_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["mergeWithDefaultTheme"])(TIMELINE_LIGHT_THEME,_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["LIGHT_THEME"])}const TIMELINE_LIGHT_THEME={crosshair:{band:{fill:"#D3DAE6"}},axes:{gridLine:{horizontal:{stroke:"#eaeaea"}}}}},123:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(1);var useEffectOnce=function(effect){react_1.useEffect(effect,[])};exports.default=useEffectOnce},128:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MetricExplorerSeriesChart}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_charts__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(69);var _elastic_charts__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_charts__WEBPACK_IMPORTED_MODULE_1__);var _common_color_palette__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(91);var _helpers_create_metric_label__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(168);var _hooks_use_metrics_explorer_options__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(93);var _helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(129);const MetricExplorerSeriesChart=props=>{if(_hooks_use_metrics_explorer_options__WEBPACK_IMPORTED_MODULE_4__["b"].bar===props.type){return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(MetricsExplorerBarChart,props)}return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(MetricsExplorerAreaChart,props)};const MetricsExplorerAreaChart=({metric:metric,id:id,series:series,type:type,stack:stack,opacity:opacity})=>{const color=metric.color&&Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(metric.color)||Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["a"].color0);const yAccessors=Array.isArray(id)?id.map(i=>Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,i)).slice(id.length-1,id.length):[Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,id)];const y0Accessors=Array.isArray(id)&&id.length>1?id.map(i=>Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,i)).slice(0,1):undefined;const chartId=`series-${series.id}-${yAccessors.join("-")}`;const seriesAreaStyle={line:{strokeWidth:2,visible:true},area:{opacity:opacity||.5,visible:type===_hooks_use_metrics_explorer_options__WEBPACK_IMPORTED_MODULE_4__["b"].area}};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["AreaSeries"],{id:chartId,key:chartId,name:Object(_helpers_create_metric_label__WEBPACK_IMPORTED_MODULE_3__["a"])(metric),xScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Time,yScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Linear,xAccessor:"timestamp",yAccessors:yAccessors,y0Accessors:y0Accessors,data:series.rows,stackAccessors:stack?["timestamp"]:void 0,areaSeriesStyle:seriesAreaStyle,color:color})};const MetricsExplorerBarChart=({metric:metric,id:id,series:series,stack:stack})=>{const color=metric.color&&Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(metric.color)||Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["a"].color0);const yAccessors=Array.isArray(id)?id.map(i=>Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,i)).slice(id.length-1,id.length):[Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,id)];const chartId=`series-${series.id}-${yAccessors.join("-")}`;const seriesBarStyle={rectBorder:{stroke:color,strokeWidth:1,visible:true},rect:{opacity:1}};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["BarSeries"],{id:chartId,key:chartId,name:Object(_helpers_create_metric_label__WEBPACK_IMPORTED_MODULE_3__["a"])(metric),xScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Time,yScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Linear,xAccessor:"timestamp",yAccessors:yAccessors,data:series.rows,stackAccessors:stack?["timestamp"]:void 0,barSeriesStyle:seriesBarStyle,color:color})}},129:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getMetricId}));const getMetricId=(metric,index)=>`metric_${index}`},130:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return calculateDomain}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _get_metric_id__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(129);const getMin=values=>{const minValue=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["min"])(values);return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(minValue)&&Number.isFinite(minValue)?minValue:undefined};const getMax=values=>{const maxValue=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["max"])(values);return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(maxValue)&&Number.isFinite(maxValue)?maxValue:undefined};const calculateDomain=(series,metrics,stacked=false)=>{const values=series.rows.reduce((acc,row)=>{const rowValues=metrics.map((m,index)=>row[Object(_get_metric_id__WEBPACK_IMPORTED_MODULE_1__["a"])(m,index)]||null).filter(v=>Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(v));const minValue=getMin(rowValues);const maxValue=stacked?Object(lodash__WEBPACK_IMPORTED_MODULE_0__["sum"])(rowValues)*1.1:getMax(rowValues);return acc.concat([minValue||null,maxValue||null])},[]).filter(v=>Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(v));return{min:getMin(values)||0,max:getMax(values)||0}}},139:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createFormatterForMetric}));var _common_formatters__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(32);var _lib_lib__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(30);var _metric_to_format__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(167);const createFormatterForMetric=metric=>{if(metric&&metric.field){const format=Object(_metric_to_format__WEBPACK_IMPORTED_MODULE_2__["a"])(metric);if(format===_lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bits&&metric.aggregation==="rate"){return Object(_common_formatters__WEBPACK_IMPORTED_MODULE_0__["b"])(_lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bits,"{{value}}/s")}return Object(_common_formatters__WEBPACK_IMPORTED_MODULE_0__["b"])(format)}return Object(_common_formatters__WEBPACK_IMPORTED_MODULE_0__["b"])(_lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].number)}},167:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metricToFormat}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _lib_lib__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(30);const metricToFormat=metric=>{if(metric&&metric.field){const suffix=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["last"])(metric.field.split(/\./));if(suffix==="pct"){return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].percent}if(suffix==="bytes"&&metric.aggregation==="rate"){return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bits}if(suffix==="bytes"){return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bytes}}return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].number}},168:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createMetricLabel}));const createMetricLabel=metric=>{if(metric.label){return metric.label}return`${metric.aggregation}(${metric.field||""})`}},181:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(1);var useFirstMountState_1=__webpack_require__(182);var useUpdateEffect=function(effect,deps){var isFirstMount=useFirstMountState_1.useFirstMountState();react_1.useEffect((function(){if(!isFirstMount){return effect()}}),deps)};exports.default=useUpdateEffect},182:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.useFirstMountState=void 0;var react_1=__webpack_require__(1);function useFirstMountState(){var isFirst=react_1.useRef(true);if(isFirst.current){isFirst.current=false;return true}return isFirst.current}exports.useFirstMountState=useFirstMountState},205:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MetricsExplorerGroupBy}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(8);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);const MetricsExplorerGroupBy=({options:options,onChange:onChange,fields:fields})=>{const handleChange=Object(react__WEBPACK_IMPORTED_MODULE_2__["useCallback"])(selectedOptions=>{const groupBy=selectedOptions.map(option=>option.label);onChange(groupBy)},[onChange]);const selectedOptions=Array.isArray(options.groupBy)?options.groupBy.map(field=>({label:field})):options.groupBy?[{label:options.groupBy}]:[];return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiComboBox"],{placeholder:_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.metricsExplorer.groupByLabel",{defaultMessage:"Everything"}),"aria-label":_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.metricsExplorer.groupByAriaLabel",{defaultMessage:"Graph per"}),fullWidth:true,singleSelection:false,selectedOptions:selectedOptions,options:fields.filter(f=>f.aggregatable&&f.type==="string").map(f=>({label:f.name})),onChange:handleChange,isClearable:true})}},206:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useMetricsExplorerData}));var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_datemath__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);var _common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(100);var _utils_kuery__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(103);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(3);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5__);var _common_runtime_types__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(13);function isSameOptions(current,next){return Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(current,next)}function useMetricsExplorerData(options,source,derivedIndexPattern,timerange,afterKey,signal,shouldLoadImmediately=true){var _kibana$services$http;const kibana=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5__["useKibana"])();const fetchFn=(_kibana$services$http=kibana.services.http)===null||_kibana$services$http===void 0?void 0:_kibana$services$http.fetch;const[error,setError]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const[loading,setLoading]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(true);const[data,setData]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const[lastOptions,setLastOptions]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const[lastTimerange,setLastTimerange]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const loadData=Object(react__WEBPACK_IMPORTED_MODULE_2__["useCallback"])(()=>{(async()=>{setLoading(true);try{const from=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(timerange.from);const to=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(timerange.to,{roundUp:true});if(!from||!to){throw new Error("Unalble to parse timerange")}if(!fetchFn){throw new Error("HTTP service is unavailable")}if(!source){throw new Error("Source is unavailable")}const response=Object(_common_runtime_types__WEBPACK_IMPORTED_MODULE_6__["b"])(_common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_3__["e"])(await fetchFn("/api/infra/metrics_explorer",{method:"POST",body:JSON.stringify({forceInterval:options.forceInterval,dropLastBucket:options.dropLastBucket!=null?options.dropLastBucket:true,metrics:options.aggregation==="count"?[{aggregation:"count"}]:options.metrics.map(metric=>({aggregation:metric.aggregation,field:metric.field})),groupBy:options.groupBy,afterKey:afterKey,limit:options.limit,indexPattern:source.metricAlias,filterQuery:options.filterQuery&&Object(_utils_kuery__WEBPACK_IMPORTED_MODULE_4__["a"])(options.filterQuery,derivedIndexPattern)||void 0,timerange:{...timerange,field:source.fields.timestamp,from:from.valueOf(),to:to.valueOf()}})}));if(response){if(data&&lastOptions&&data.pageInfo.afterKey!==response.pageInfo.afterKey&&isSameOptions(lastOptions,options)&&Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(timerange,lastTimerange)&&afterKey){const{series:series}=data;setData({...response,series:[...series,...response.series]})}else{setData(response)}setLastOptions(options);setLastTimerange(timerange);setError(null)}}catch(e){setError(e)}setLoading(false)})()},[options,source,timerange,signal,afterKey]);Object(react__WEBPACK_IMPORTED_MODULE_2__["useEffect"])(()=>{if(!shouldLoadImmediately){return}loadData()},[loadData,shouldLoadImmediately]);return{error:error,loading:loading,data:data,loadData:loadData}}},212:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertPreview}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(12);var public_=__webpack_require__(3);var formatters=__webpack_require__(32);var get_interval_in_seconds=__webpack_require__(207);var metrics=__webpack_require__(134);async function getAlertPreview({fetch:fetch,params:params,alertType:alertType}){return await fetch(`${metrics["c"]}`,{method:"POST",body:JSON.stringify({...params,alertType:alertType})})}const AlertPreview=props=>{var _previewError$body;const{alertParams:alertParams,alertInterval:alertInterval,alertThrottle:alertThrottle,alertNotifyWhen:alertNotifyWhen,alertType:alertType,validate:validate,showNoDataResults:showNoDataResults,groupByDisplayName:groupByDisplayName}=props;const{http:http}=Object(public_["useKibana"])().services;const[previewLookbackInterval,setPreviewLookbackInterval]=Object(external_kbnSharedDeps_React_["useState"])("h");const[isPreviewLoading,setIsPreviewLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[previewError,setPreviewError]=Object(external_kbnSharedDeps_React_["useState"])(false);const[previewResult,setPreviewResult]=Object(external_kbnSharedDeps_React_["useState"])(null);const onSelectPreviewLookbackInterval=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{setPreviewLookbackInterval(e.target.value)},[]);const onClickPreview=Object(external_kbnSharedDeps_React_["useCallback"])(async()=>{setIsPreviewLoading(true);setPreviewResult(null);setPreviewError(false);try{const result=await getAlertPreview({fetch:http.fetch,params:{...alertParams,lookback:previewLookbackInterval,alertInterval:alertInterval,alertThrottle:alertThrottle,alertNotifyWhen:alertNotifyWhen,alertOnNoData:showNoDataResults!==null&&showNoDataResults!==void 0?showNoDataResults:false},alertType:alertType});setPreviewResult({...result,groupByDisplayName:groupByDisplayName,previewLookbackInterval:previewLookbackInterval,alertThrottle:alertThrottle})}catch(e){setPreviewError(e)}finally{setIsPreviewLoading(false)}},[alertParams,alertInterval,alertType,alertNotifyWhen,groupByDisplayName,previewLookbackInterval,alertThrottle,showNoDataResults,http]);const previewIntervalError=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const intervalInSeconds=Object(get_interval_in_seconds["a"])(alertInterval);const lookbackInSeconds=Object(get_interval_in_seconds["a"])(`1${previewLookbackInterval}`);if(intervalInSeconds>=lookbackInSeconds){return true}return false},[previewLookbackInterval,alertInterval]);const isPreviewDisabled=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!alertParams.criteria)return false;const validationResult=validate({criteria:alertParams.criteria});const hasValidationErrors=Object.values(validationResult.errors).some(result=>Object.values(result).some(arr=>Array.isArray(arr)&&arr.length));return hasValidationErrors||previewIntervalError},[alertParams.criteria,previewIntervalError,validate]);const showNumberOfNotifications=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!previewResult)return false;if(alertNotifyWhen==="onActiveAlert")return false;const{notifications:notifications,fired:fired,noData:noData,error:error}=previewResult.resultTotals;const unthrottledNotifications=fired+(showNoDataResults?noData+error:0);return unthrottledNotifications>notifications},[previewResult,showNoDataResults,alertNotifyWhen]);const hasWarningThreshold=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _alertParams$criteria,_alertParams$criteria2;return(_alertParams$criteria=(_alertParams$criteria2=alertParams.criteria)===null||_alertParams$criteria2===void 0?void 0:_alertParams$criteria2.some(c=>Reflect.has(c,"warningThreshold")))!==null&&_alertParams$criteria!==void 0?_alertParams$criteria:false},[alertParams]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.previewLabel",{defaultMessage:"Preview"}),fullWidth:true,display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{id:"selectPreviewLookbackInterval",value:previewLookbackInterval,onChange:onSelectPreviewLookbackInterval,options:previewDOMOptions})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{isLoading:isPreviewLoading,isDisabled:isPreviewDisabled,onClick:onClickPreview},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.testAlertCondition",{defaultMessage:"Test alert condition"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),previewResult&&!previewIntervalError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(PreviewTextString,{previewResult:previewResult,hasWarningThreshold:hasWarningThreshold})},showNoDataResults&&previewResult.resultTotals.noData?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewNoDataResult",defaultMessage:"There {wereWas} {boldedResultsNumber} of no data.",values:{wereWas:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.wereWas",defaultMessage:"{plurality, plural, one {was} other {were}}",values:{plurality:previewResult.resultTotals.noData}}),boldedResultsNumber:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertPreviewNoDataResultNumber",{defaultMessage:"{noData, plural, one {# result} other {# results}}",values:{noData:previewResult.resultTotals.noData}}))}}):null," ",previewResult.resultTotals.error?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewErrorResult",defaultMessage:"An error occurred when trying to evaluate some of the data."}):null,showNumberOfNotifications?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewTotalNotifications",defaultMessage:'As a result, this alert would have sent {notifications} based on the selected "notify" setting of "{alertThrottle}."',values:{alertThrottle:alertNotifyWhen==="onThrottleInterval"?previewResult.alertThrottle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertPreviewOnlyOnStatusChange",{defaultMessage:"Only on status change"}),notifications:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertPreviewTotalNotificationsNumber",{defaultMessage:"{notifs, plural, one {# notification} other {# notifications}}",values:{notifs:previewResult.resultTotals.notifications}}))}})):null," ")),previewIntervalError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.previewIntervalTooShortTitle",defaultMessage:"Not enough data"}),color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.previewIntervalTooShortDescription",defaultMessage:"Try selecting a longer preview length, or increase the amount of time in the {checkEvery} field.",values:{checkEvery:external_kbnSharedDeps_React_default.a.createElement("strong",null,"check every")}}))),previewError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),((_previewError$body=previewError.body)===null||_previewError$body===void 0?void 0:_previewError$body.statusCode)===508?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.tooManyBucketsErrorTitle",defaultMessage:"Too much data (>{maxBuckets} results)",values:{maxBuckets:formatters["a"].number(previewError.body.message)}}),color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.tooManyBucketsErrorDescription",defaultMessage:"Try selecting a shorter preview length, or increase the amount of time in the {forTheLast} field.",values:{forTheLast:external_kbnSharedDeps_React_default.a.createElement("strong",null,"FOR THE LAST")}})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewError",defaultMessage:"An error occurred when trying to preview this alert condition"}),color:"danger",iconType:"alert"},previewError.body&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewErrorDesc",defaultMessage:"Please try again later or see details for more information."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAccordion"],{id:"alertErrorDetailsAccordion",buttonContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.errorDetails",defaultMessage:"Details"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],null,previewError.body.message)))))))};const PreviewTextString=({previewResult:previewResult,hasWarningThreshold:hasWarningThreshold})=>{var _previewOptions$find;const instanceCount=hasWarningThreshold?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewResultWithSeverityLevels",defaultMessage:"There {wereWas} {criticalInstances} that satisfied the {boldCritical} conditions, and {warningInstances} that satisfied the {boldWarning} conditions of this alert",values:{wereWas:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.wereWas",defaultMessage:"{plurality, plural, one {was} other {were}}",values:{plurality:previewResult.resultTotals.fired}}),criticalInstances:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.firedTimes",defaultMessage:"{fired, plural, one {# instance} other {# instances}}",values:{fired:previewResult.resultTotals.fired}})),warningInstances:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.firedTimes",defaultMessage:"{fired, plural, one {# instance} other {# instances}}",values:{fired:previewResult.resultTotals.warning}})),boldCritical:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.boldCritical",defaultMessage:"critical"})),boldWarning:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.boldWarning",defaultMessage:"warning"}))}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewResultInstances",defaultMessage:"There {wereWas} {firedTimes} that satisfied the conditions of this alert",values:{wereWas:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.wereWas",defaultMessage:"{plurality, plural, one {was} other {were}}",values:{plurality:previewResult.resultTotals.fired}}),firedTimes:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.firedTimes",defaultMessage:"{fired, plural, one {# instance} other {# instances}}",values:{fired:previewResult.resultTotals.fired}}))}});const groupByText=previewResult.groupByDisplayName?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewGroupBy",defaultMessage:"across {groups}",values:{groups:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewGroups",defaultMessage:"{numberOfGroups, plural, one {# {groupName}} other {# {groupName}s}}",values:{numberOfGroups:previewResult.numberOfGroups,groupName:previewResult.groupByDisplayName}}))}})," "):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null);const lookbackText=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewLookback",defaultMessage:"in the last {lookback}",values:{lookback:(_previewOptions$find=previewOptions.find(e=>e.value===previewResult.previewLookbackInterval))===null||_previewOptions$find===void 0?void 0:_previewOptions$find.shortText}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewResultText",defaultMessage:"{instanceCount} {groupByWithConditionalTrailingSpace}{lookbackText}.",values:{instanceCount:instanceCount,groupByWithConditionalTrailingSpace:groupByText,lookbackText:lookbackText}})};const previewOptions=[{value:"h",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastHourLabel",{defaultMessage:"Last hour"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.hourLabel",{defaultMessage:"hour"})},{value:"d",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastDayLabel",{defaultMessage:"Last day"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.dayLabel",{defaultMessage:"day"})},{value:"w",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastWeekLabel",{defaultMessage:"Last week"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.weekLabel",{defaultMessage:"week"})},{value:"M",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastMonthLabel",{defaultMessage:"Last month"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.monthLabel",{defaultMessage:"month"})}];const previewDOMOptions=previewOptions.map(o=>Object(external_kbnSharedDeps_Lodash_["omit"])(o,"shortText"));const common_previewOptions=[{value:"h",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastHourLabel",{defaultMessage:"Last hour"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.hourLabel",{defaultMessage:"hour"})},{value:"d",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastDayLabel",{defaultMessage:"Last day"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.dayLabel",{defaultMessage:"day"})},{value:"w",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastWeekLabel",{defaultMessage:"Last week"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.weekLabel",{defaultMessage:"week"})},{value:"M",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastMonthLabel",{defaultMessage:"Last month"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.monthLabel",{defaultMessage:"month"})}]},493:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"defaultExpression",(function(){return defaultExpression}));__webpack_require__.d(__webpack_exports__,"Expressions",(function(){return Expressions}));var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(12);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var common=__webpack_require__(212);var metrics=__webpack_require__(134);var common_=__webpack_require__(76);var kuery_bar=__webpack_require__(169);var group_by=__webpack_require__(205);var use_source_via_http=__webpack_require__(178);var kuery=__webpack_require__(103);const correctedPctConvert=(v,decimalToPct)=>{const replacementPattern=decimalToPct?new RegExp(/0?\./):".";const numberOfDigits=String(v).replace(replacementPattern,"").length;const multipliedValue=decimalToPct?v*100:v/100;return parseFloat(multipliedValue.toPrecision(numberOfDigits))};const decimalToPct=v=>correctedPctConvert(v,true);const pctToDecimal=v=>correctedPctConvert(v,false);var kibanaReact_common_=__webpack_require__(11);let AGGREGATION_TYPES;(function(AGGREGATION_TYPES){AGGREGATION_TYPES["COUNT"]="count";AGGREGATION_TYPES["AVERAGE"]="avg";AGGREGATION_TYPES["SUM"]="sum";AGGREGATION_TYPES["MIN"]="min";AGGREGATION_TYPES["MAX"]="max";AGGREGATION_TYPES["RATE"]="rate";AGGREGATION_TYPES["CARDINALITY"]="cardinality";AGGREGATION_TYPES["P95"]="p95";AGGREGATION_TYPES["P99"]="p99"})(AGGREGATION_TYPES||(AGGREGATION_TYPES={}));var types=__webpack_require__(16);var constants_=__webpack_require__(81);const customComparators={...constants_["builtInComparators"],[types["a"].OUTSIDE_RANGE]:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.outsideRangeLabel",{defaultMessage:"Is not between"}),value:types["a"].OUTSIDE_RANGE,requiredValues:2}};const StyledExpressionRow=Object(kibanaReact_common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"])`
  display: flex;
  flex-wrap: wrap;
  align-items: center;
  margin: 0 -4px;
`;const StyledExpression=kibanaReact_common_["euiStyled"].div`
  padding: 0 4px;
`;const StyledHealth=Object(kibanaReact_common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiHealth"])`
  margin-left: 4px;
`;const ExpressionRow=props=>{var _ref,_ref2;const[isExpanded,setRowState]=Object(external_kbnSharedDeps_React_["useState"])(true);const toggleRowState=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setRowState(!isExpanded),[isExpanded]);const{children:children,setAlertParams:setAlertParams,expression:expression,errors:errors,expressionId:expressionId,remove:remove,fields:fields,canDelete:canDelete}=props;const{aggType:aggType=AGGREGATION_TYPES.MAX,metric:metric,comparator:comparator=types["a"].GT,threshold:threshold=[],warningThreshold:warningThreshold=[],warningComparator:warningComparator}=expression;const[displayWarningThreshold,setDisplayWarningThreshold]=Object(external_kbnSharedDeps_React_["useState"])(Boolean(warningThreshold===null||warningThreshold===void 0?void 0:warningThreshold.length));const isMetricPct=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Boolean(metric&&metric.endsWith(".pct")),[metric]);const updateAggType=Object(external_kbnSharedDeps_React_["useCallback"])(at=>{setAlertParams(expressionId,{...expression,aggType:at,metric:at==="count"?undefined:expression.metric})},[expressionId,expression,setAlertParams]);const updateMetric=Object(external_kbnSharedDeps_React_["useCallback"])(m=>{setAlertParams(expressionId,{...expression,metric:m})},[expressionId,expression,setAlertParams]);const updateComparator=Object(external_kbnSharedDeps_React_["useCallback"])(c=>{setAlertParams(expressionId,{...expression,comparator:c})},[expressionId,expression,setAlertParams]);const updateWarningComparator=Object(external_kbnSharedDeps_React_["useCallback"])(c=>{setAlertParams(expressionId,{...expression,warningComparator:c})},[expressionId,expression,setAlertParams]);const convertThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(enteredThreshold=>isMetricPct?enteredThreshold.map(v=>pctToDecimal(v)):enteredThreshold,[isMetricPct]);const updateThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(enteredThreshold=>{const t=convertThreshold(enteredThreshold);if(t.join()!==expression.threshold.join()){setAlertParams(expressionId,{...expression,threshold:t})}},[expressionId,expression,convertThreshold,setAlertParams]);const updateWarningThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(enteredThreshold=>{var _expression$warningTh;const t=convertThreshold(enteredThreshold);if(t.join()!==((_expression$warningTh=expression.warningThreshold)===null||_expression$warningTh===void 0?void 0:_expression$warningTh.join())){setAlertParams(expressionId,{...expression,warningThreshold:t})}},[expressionId,expression,convertThreshold,setAlertParams]);const toggleWarningThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(!displayWarningThreshold){setDisplayWarningThreshold(true);setAlertParams(expressionId,{...expression,warningComparator:comparator,warningThreshold:[]})}else{setDisplayWarningThreshold(false);setAlertParams(expressionId,Object(external_kbnSharedDeps_Lodash_["omit"])(expression,"warningComparator","warningThreshold"))}},[displayWarningThreshold,setDisplayWarningThreshold,setAlertParams,comparator,expression,expressionId]);const criticalThresholdExpression=external_kbnSharedDeps_React_default.a.createElement(ThresholdElement,{comparator:comparator,threshold:threshold,updateComparator:updateComparator,updateThreshold:updateThreshold,errors:(_ref=errors.critical)!==null&&_ref!==void 0?_ref:{},isMetricPct:isMetricPct});const warningThresholdExpression=displayWarningThreshold&&external_kbnSharedDeps_React_default.a.createElement(ThresholdElement,{comparator:warningComparator||comparator,threshold:warningThreshold,updateComparator:updateWarningComparator,updateThreshold:updateWarningThreshold,errors:(_ref2=errors.warning)!==null&&_ref2!==void 0?_ref2:{},isMetricPct:isMetricPct});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:isExpanded?"arrowDown":"arrowRight",onClick:toggleRowState,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.expandRowLabel",{defaultMessage:"Expand row."})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpression,null,external_kbnSharedDeps_React_default.a.createElement(common_["WhenExpression"],{customAggTypesOptions:aggregationType,aggType:aggType,onChangeSelectedAggType:updateAggType})),aggType!=="count"&&external_kbnSharedDeps_React_default.a.createElement(StyledExpression,null,external_kbnSharedDeps_React_default.a.createElement(common_["OfExpression"],{customAggTypesOptions:aggregationType,aggField:metric,fields:fields.map(f=>({normalizedType:f.type,name:f.name})),aggType:aggType,errors:errors,onChangeSelectedAggField:updateMetric,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.ofExpression.helpTextDetail",defaultMessage:"Can't find a metric? {documentationLink}.",values:{documentationLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/observability/current/configure-settings.html",target:"BLANK"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.ofExpression.popoverLinkLabel",defaultMessage:"Learn how to add more data"}))}}),"data-test-subj":"ofExpression"})),!displayWarningThreshold&&criticalThresholdExpression),displayWarningThreshold&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,criticalThresholdExpression,external_kbnSharedDeps_React_default.a.createElement(StyledHealth,{color:"danger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.criticalThreshold",defaultMessage:"Alert"}))),external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,warningThresholdExpression,external_kbnSharedDeps_React_default.a.createElement(StyledHealth,{color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.warningThreshold",defaultMessage:"Warning"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.removeWarningThreshold",{defaultMessage:"Remove warningThreshold"}),iconSize:"s",color:"subdued",iconType:"crossInACircleFilled",onClick:toggleWarningThreshold}))),!displayWarningThreshold&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",flush:"left",size:"xs",iconType:"plusInCircleFilled",onClick:toggleWarningThreshold},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.addWarningThreshold",defaultMessage:"Add warning threshold"}))))),canDelete&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.removeCondition",{defaultMessage:"Remove condition"}),color:"danger",iconType:"trash",onClick:()=>remove(expressionId)}))),isExpanded?external_kbnSharedDeps_React_default.a.createElement("div",{style:{padding:"0 0 0 28px"}},children):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}))};const ThresholdElement=({updateComparator:updateComparator,updateThreshold:updateThreshold,threshold:threshold,isMetricPct:isMetricPct,comparator:comparator,errors:errors})=>{const displayedThreshold=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(isMetricPct)return threshold.map(v=>decimalToPct(v));return threshold},[threshold,isMetricPct]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpression,null,external_kbnSharedDeps_React_default.a.createElement(common_["ThresholdExpression"],{thresholdComparator:comparator||types["a"].GT,threshold:displayedThreshold,customComparators:customComparators,onChangeSelectedThresholdComparator:updateComparator,onChangeSelectedThreshold:updateThreshold,errors:errors})),isMetricPct&&external_kbnSharedDeps_React_default.a.createElement("div",{style:{alignSelf:"center"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},"%")))};const aggregationType={avg:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.avg",{defaultMessage:"Average"}),fieldRequired:true,validNormalizedTypes:["number"],value:AGGREGATION_TYPES.AVERAGE},max:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.max",{defaultMessage:"Max"}),fieldRequired:true,validNormalizedTypes:["number","date"],value:AGGREGATION_TYPES.MAX},min:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.min",{defaultMessage:"Min"}),fieldRequired:true,validNormalizedTypes:["number","date"],value:AGGREGATION_TYPES.MIN},cardinality:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.cardinality",{defaultMessage:"Cardinality"}),fieldRequired:false,value:AGGREGATION_TYPES.CARDINALITY,validNormalizedTypes:["number"]},rate:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.rate",{defaultMessage:"Rate"}),fieldRequired:false,value:AGGREGATION_TYPES.RATE,validNormalizedTypes:["number"]},count:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.count",{defaultMessage:"Document count"}),fieldRequired:false,value:AGGREGATION_TYPES.COUNT,validNormalizedTypes:["number"]},sum:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.sum",{defaultMessage:"Sum"}),fieldRequired:false,value:AGGREGATION_TYPES.SUM,validNormalizedTypes:["number"]},p95:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.p95",{defaultMessage:"95th Percentile"}),fieldRequired:false,value:AGGREGATION_TYPES.P95,validNormalizedTypes:["number"]},p99:{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.aggregationText.p99",{defaultMessage:"99th Percentile"}),fieldRequired:false,value:AGGREGATION_TYPES.P99,validNormalizedTypes:["number"]}};var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(69);var external_kbnSharedDeps_Moment_=__webpack_require__(50);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var color_palette=__webpack_require__(91);var series_chart=__webpack_require__(128);var use_metrics_explorer_options=__webpack_require__(93);var get_chart_theme=__webpack_require__(120);var create_formatter_for_metric=__webpack_require__(139);var calculate_domain=__webpack_require__(130);var use_metrics_explorer_data=__webpack_require__(206);const useMetricsExplorerChartData=(expression,derivedIndexPattern,source,filterQuery,groupBy)=>{const{timeSize:timeSize,timeUnit:timeUnit}=expression||{timeSize:1,timeUnit:"m"};const options=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({limit:1,forceInterval:true,dropLastBucket:false,groupBy:groupBy,filterQuery:filterQuery,metrics:[{field:expression.metric,aggregation:expression.aggType}],aggregation:expression.aggType||"avg"}),[expression.aggType,expression.metric,filterQuery,groupBy]);const timerange=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({interval:`>=${timeSize||1}${timeUnit}`,from:`now-${(timeSize||1)*20}${timeUnit}`,to:"now"}),[timeSize,timeUnit]);return Object(use_metrics_explorer_data["a"])(options,source===null||source===void 0?void 0:source.configuration,derivedIndexPattern,timerange,null,null)};var get_metric_id=__webpack_require__(129);var use_kibana=__webpack_require__(28);const tooltipProps={headerFormatter:tooltipValue=>external_kbnSharedDeps_Moment_default()(tooltipValue.value).format("Y-MM-DD HH:mm:ss.SSS")};const TIME_LABELS={s:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alerts.timeLabels.seconds",{defaultMessage:"seconds"}),m:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alerts.timeLabels.minutes",{defaultMessage:"minutes"}),h:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alerts.timeLabels.hours",{defaultMessage:"hours"}),d:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alerts.timeLabels.days",{defaultMessage:"days"})};const ExpressionChart=({expression:expression,derivedIndexPattern:derivedIndexPattern,source:source,filterQuery:filterQuery,groupBy:groupBy})=>{var _expression$warningTh,_expression$warningTh2;const{loading:loading,data:data}=useMetricsExplorerChartData(expression,derivedIndexPattern,source,filterQuery,groupBy);const{uiSettings:uiSettings}=Object(use_kibana["b"])().services;const metric={field:expression.metric,aggregation:expression.aggType,color:color_palette["a"].color0};const isDarkMode=(uiSettings===null||uiSettings===void 0?void 0:uiSettings.get("theme:darkMode"))||false;const dateFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _first,_last;const firstSeries=Object(external_kbnSharedDeps_Lodash_["first"])(data===null||data===void 0?void 0:data.series);const firstTimestamp=(_first=Object(external_kbnSharedDeps_Lodash_["first"])(firstSeries===null||firstSeries===void 0?void 0:firstSeries.rows))===null||_first===void 0?void 0:_first.timestamp;const lastTimestamp=(_last=Object(external_kbnSharedDeps_Lodash_["last"])(firstSeries===null||firstSeries===void 0?void 0:firstSeries.rows))===null||_last===void 0?void 0:_last.timestamp;if(firstTimestamp==null||lastTimestamp==null){return value=>`${value}`}return Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])([firstTimestamp,lastTimestamp])},[data===null||data===void 0?void 0:data.series]);const yAxisFormater=Object(external_kbnSharedDeps_React_["useCallback"])(Object(create_formatter_for_metric["a"])(metric),[expression]);if(loading||!data){return external_kbnSharedDeps_React_default.a.createElement(EmptyContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alerts.loadingMessage",defaultMessage:"Loading"})))}const criticalThresholds=expression.threshold.slice().sort();const warningThresholds=(_expression$warningTh=(_expression$warningTh2=expression.warningThreshold)===null||_expression$warningTh2===void 0?void 0:_expression$warningTh2.slice().sort())!==null&&_expression$warningTh!==void 0?_expression$warningTh:[];const thresholds=[...criticalThresholds,...warningThresholds].sort();const firstSeries=Object(external_kbnSharedDeps_Lodash_["first"])(data.series);if(!firstSeries||!firstSeries.rows||firstSeries.rows.length===0){return external_kbnSharedDeps_React_default.a.createElement(EmptyContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued","data-test-subj":"noChartData"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alerts.noDataMessage",defaultMessage:"Oops, no chart data available"})))}const series={...firstSeries,rows:firstSeries.rows.map(row=>{const newRow={...row};thresholds.forEach((thresholdValue,index)=>{newRow[Object(get_metric_id["a"])(metric,`threshold_${index}`)]=thresholdValue});return newRow})};const firstTimestamp=Object(external_kbnSharedDeps_Lodash_["first"])(firstSeries.rows).timestamp;const lastTimestamp=Object(external_kbnSharedDeps_Lodash_["last"])(firstSeries.rows).timestamp;const dataDomain=Object(calculate_domain["a"])(series,[metric],false);const domain={max:Math.max(dataDomain.max,Object(external_kbnSharedDeps_Lodash_["last"])(thresholds)||dataDomain.max)*1.1,min:Math.min(dataDomain.min,Object(external_kbnSharedDeps_Lodash_["first"])(thresholds)||dataDomain.min)*.9};if(domain.min===Object(external_kbnSharedDeps_Lodash_["first"])(expression.threshold)){domain.min=domain.min*.9}const opacity=.3;const{timeSize:timeSize,timeUnit:timeUnit}=expression;const timeLabel=TIME_LABELS[timeUnit];const ThresholdAnnotations=({threshold:threshold,sortedThresholds:sortedThresholds,comparator:comparator,color:color,id:id})=>{if(!comparator||!threshold)return null;const isAbove=[types["a"].GT,types["a"].GT_OR_EQ].includes(comparator);const isBelow=[types["a"].LT,types["a"].LT_OR_EQ].includes(comparator);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["LineAnnotation"],{id:`${id}-thresholds`,domainType:external_kbnSharedDeps_ElasticCharts_["AnnotationDomainTypes"].YDomain,dataValues:sortedThresholds.map(t=>({dataValue:t})),style:{line:{strokeWidth:2,stroke:Object(color_palette["b"])(color),opacity:1}}}),sortedThresholds.length===2&&comparator===types["a"].BETWEEN?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{id:`${id}-lower-threshold`,style:{fill:Object(color_palette["b"])(color),opacity:opacity},dataValues:[{coordinates:{x0:firstTimestamp,x1:lastTimestamp,y0:Object(external_kbnSharedDeps_Lodash_["first"])(expression.threshold),y1:Object(external_kbnSharedDeps_Lodash_["last"])(expression.threshold)}}]})):null,sortedThresholds.length===2&&comparator===types["a"].OUTSIDE_RANGE?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{id:`${id}-lower-threshold`,style:{fill:Object(color_palette["b"])(color),opacity:opacity},dataValues:[{coordinates:{x0:firstTimestamp,x1:lastTimestamp,y0:domain.min,y1:Object(external_kbnSharedDeps_Lodash_["first"])(threshold)}}]}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{id:`${id}-upper-threshold`,style:{fill:Object(color_palette["b"])(color),opacity:opacity},dataValues:[{coordinates:{x0:firstTimestamp,x1:lastTimestamp,y0:Object(external_kbnSharedDeps_Lodash_["last"])(threshold),y1:domain.max}}]})):null,isBelow&&Object(external_kbnSharedDeps_Lodash_["first"])(threshold)!=null?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{id:`${id}-upper-threshold`,style:{fill:Object(color_palette["b"])(color),opacity:opacity},dataValues:[{coordinates:{x0:firstTimestamp,x1:lastTimestamp,y0:domain.min,y1:Object(external_kbnSharedDeps_Lodash_["first"])(threshold)}}]}):null,isAbove&&Object(external_kbnSharedDeps_Lodash_["first"])(threshold)!=null?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{id:`${id}-upper-threshold`,style:{fill:Object(color_palette["b"])(color),opacity:opacity},dataValues:[{coordinates:{x0:firstTimestamp,x1:lastTimestamp,y0:Object(external_kbnSharedDeps_Lodash_["first"])(threshold),y1:domain.max}}]}):null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ChartContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].bar,metric:metric,id:"0",series:series,stack:false}),external_kbnSharedDeps_React_default.a.createElement(ThresholdAnnotations,{comparator:expression.comparator,threshold:expression.threshold,sortedThresholds:criticalThresholds,color:color_palette["a"].color1,id:"critical"}),expression.warningComparator&&expression.warningThreshold&&external_kbnSharedDeps_React_default.a.createElement(ThresholdAnnotations,{comparator:expression.warningComparator,threshold:expression.warningThreshold,sortedThresholds:warningThresholds,color:color_palette["a"].color5,id:"warning"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:dateFormatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:yAxisFormater,domain:domain}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{tooltip:tooltipProps,theme:Object(get_chart_theme["a"])(isDarkMode)}))),external_kbnSharedDeps_React_default.a.createElement("div",{style:{textAlign:"center"}},series.id!=="ALL"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alerts.dataTimeRangeLabelWithGrouping",defaultMessage:"Last {lookback} {timeLabel} of data for {id}",values:{id:series.id,timeLabel:timeLabel,lookback:timeSize*20}})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alerts.dataTimeRangeLabel",defaultMessage:"Last {lookback} {timeLabel}",values:{timeLabel:timeLabel,lookback:timeSize*20}}))))};const EmptyContainer=({children:children})=>external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%",height:150,display:"flex",justifyContent:"center",alignItems:"center"}},children);const ChartContainer=({children:children})=>external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%",height:150}},children);var validation=__webpack_require__(41);const FILTER_TYPING_DEBOUNCE_MS=500;const defaultExpression={aggType:metrics["a"].AVERAGE,comparator:metrics["b"].GT,threshold:[],timeSize:1,timeUnit:"m"};const Expressions=props=>{const{setAlertParams:setAlertParams,alertParams:alertParams,errors:errors,alertInterval:alertInterval,alertThrottle:alertThrottle,metadata:metadata,alertNotifyWhen:alertNotifyWhen}=props;const{http:http,notifications:notifications}=Object(use_kibana["b"])().services;const{source:source,createDerivedIndexPattern:createDerivedIndexPattern}=Object(use_source_via_http["a"])({sourceId:"default",type:"metrics",fetch:http.fetch,toastWarning:notifications.toasts.addWarning});const[timeSize,setTimeSize]=Object(external_kbnSharedDeps_React_["useState"])(1);const[timeUnit,setTimeUnit]=Object(external_kbnSharedDeps_React_["useState"])("m");const derivedIndexPattern=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createDerivedIndexPattern("metrics"),[createDerivedIndexPattern]);const options=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _metadata$currentOpti;if(metadata!==null&&metadata!==void 0&&(_metadata$currentOpti=metadata.currentOptions)!==null&&_metadata$currentOpti!==void 0&&_metadata$currentOpti.metrics){return metadata.currentOptions}else{return{metrics:[],aggregation:"avg"}}},[metadata]);const updateParams=Object(external_kbnSharedDeps_React_["useCallback"])((id,e)=>{const exp=alertParams.criteria?alertParams.criteria.slice():[];exp[id]=e;setAlertParams("criteria",exp)},[setAlertParams,alertParams.criteria]);const addExpression=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _alertParams$criteria;const exp=((_alertParams$criteria=alertParams.criteria)===null||_alertParams$criteria===void 0?void 0:_alertParams$criteria.slice())||[];exp.push({...defaultExpression,timeSize:timeSize!==null&&timeSize!==void 0?timeSize:defaultExpression.timeSize,timeUnit:timeUnit!==null&&timeUnit!==void 0?timeUnit:defaultExpression.timeUnit});setAlertParams("criteria",exp)},[setAlertParams,alertParams.criteria,timeSize,timeUnit]);const removeExpression=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{var _alertParams$criteria2;const exp=((_alertParams$criteria2=alertParams.criteria)===null||_alertParams$criteria2===void 0?void 0:_alertParams$criteria2.slice())||[];if(exp.length>1){exp.splice(id,1);setAlertParams("criteria",exp)}},[setAlertParams,alertParams.criteria]);const onFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(filter=>{setAlertParams("filterQueryText",filter);setAlertParams("filterQuery",Object(kuery["a"])(filter,derivedIndexPattern)||"")},[setAlertParams,derivedIndexPattern]);const debouncedOnFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(Object(external_kbnSharedDeps_Lodash_["debounce"])(onFilterChange,FILTER_TYPING_DEBOUNCE_MS),[onFilterChange]);const onGroupByChange=Object(external_kbnSharedDeps_React_["useCallback"])(group=>{setAlertParams("groupBy",group&&group.length?group:"")},[setAlertParams]);const emptyError=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({aggField:[],timeSizeUnit:[],timeWindowSize:[]}),[]);const updateTimeSize=Object(external_kbnSharedDeps_React_["useCallback"])(ts=>{var _alertParams$criteria3;const criteria=((_alertParams$criteria3=alertParams.criteria)===null||_alertParams$criteria3===void 0?void 0:_alertParams$criteria3.map(c=>({...c,timeSize:ts})))||[];setTimeSize(ts||undefined);setAlertParams("criteria",criteria)},[alertParams.criteria,setAlertParams]);const updateTimeUnit=Object(external_kbnSharedDeps_React_["useCallback"])(tu=>{var _alertParams$criteria4;const criteria=((_alertParams$criteria4=alertParams.criteria)===null||_alertParams$criteria4===void 0?void 0:_alertParams$criteria4.map(c=>({...c,timeUnit:tu})))||[];setTimeUnit(tu);setAlertParams("criteria",criteria)},[alertParams.criteria,setAlertParams]);const preFillAlertCriteria=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _md$currentOptions,_md$currentOptions$me;const md=metadata;if(md!==null&&md!==void 0&&(_md$currentOptions=md.currentOptions)!==null&&_md$currentOptions!==void 0&&(_md$currentOptions$me=_md$currentOptions.metrics)!==null&&_md$currentOptions$me!==void 0&&_md$currentOptions$me.length){setAlertParams("criteria",md.currentOptions.metrics.map(metric=>({metric:metric.field,comparator:metrics["b"].GT,threshold:[],timeSize:timeSize,timeUnit:timeUnit,aggType:metric.aggregation})))}else{setAlertParams("criteria",[defaultExpression])}},[metadata,setAlertParams,timeSize,timeUnit]);const preFillAlertFilter=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _md$currentOptions2,_md$currentOptions3;const md=metadata;if(md&&(_md$currentOptions2=md.currentOptions)!==null&&_md$currentOptions2!==void 0&&_md$currentOptions2.filterQuery){setAlertParams("filterQueryText",md.currentOptions.filterQuery);setAlertParams("filterQuery",Object(kuery["a"])(md.currentOptions.filterQuery,derivedIndexPattern)||"")}else if(md&&(_md$currentOptions3=md.currentOptions)!==null&&_md$currentOptions3!==void 0&&_md$currentOptions3.groupBy&&md.series){const{groupBy:groupBy}=md.currentOptions;const filter=Array.isArray(groupBy)?groupBy.map((field,index)=>{var _md$series,_md$series$keys;return`${field}: "${(_md$series=md.series)===null||_md$series===void 0?void 0:(_md$series$keys=_md$series.keys)===null||_md$series$keys===void 0?void 0:_md$series$keys[index]}"`}).join(" and "):`${groupBy}: "${md.series.id}"`;setAlertParams("filterQueryText",filter);setAlertParams("filterQuery",Object(kuery["a"])(filter,derivedIndexPattern)||"")}},[metadata,derivedIndexPattern,setAlertParams]);const preFillAlertGroupBy=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _md$currentOptions4;const md=metadata;if(md&&(_md$currentOptions4=md.currentOptions)!==null&&_md$currentOptions4!==void 0&&_md$currentOptions4.groupBy&&!md.series){setAlertParams("groupBy",md.currentOptions.groupBy)}},[metadata,setAlertParams]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(alertParams.criteria&&alertParams.criteria.length){setTimeSize(alertParams.criteria[0].timeSize);setTimeUnit(alertParams.criteria[0].timeUnit)}else{preFillAlertCriteria()}if(!alertParams.filterQuery){preFillAlertFilter()}if(!alertParams.groupBy){preFillAlertGroupBy()}if(!alertParams.sourceId){setAlertParams("sourceId",(source===null||source===void 0?void 0:source.id)||"default")}},[metadata,source]);const handleFieldSearchChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>onFilterChange(e.target.value),[onFilterChange]);const groupByPreviewDisplayName=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(Array.isArray(alertParams.groupBy))return alertParams.groupBy.join(", ");return alertParams.groupBy},[alertParams.groupBy]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.conditions",defaultMessage:"Conditions"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),alertParams.criteria&&alertParams.criteria.map((e,idx)=>external_kbnSharedDeps_React_default.a.createElement(ExpressionRow,{canDelete:alertParams.criteria&&alertParams.criteria.length>1||false,fields:derivedIndexPattern.fields,remove:removeExpression,addExpression:addExpression,key:idx,expressionId:idx,setAlertParams:updateParams,errors:errors[idx]||emptyError,expression:e||{}},external_kbnSharedDeps_React_default.a.createElement(ExpressionChart,{expression:e,derivedIndexPattern:derivedIndexPattern,source:source,filterQuery:alertParams.filterQueryText,groupBy:alertParams.groupBy}))),external_kbnSharedDeps_React_default.a.createElement("div",{style:{marginLeft:28}},external_kbnSharedDeps_React_default.a.createElement(common_["ForLastExpression"],{timeWindowSize:timeSize,timeWindowUnit:timeUnit,errors:emptyError,onChangeWindowSize:updateTimeSize,onChangeWindowUnit:updateTimeUnit})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",iconSide:"left",flush:"left",iconType:"plusInCircleFilled",onClick:addExpression},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.addCondition",defaultMessage:"Add condition"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{id:"metrics-alert-no-data-toggle",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertOnNoData",{defaultMessage:"Alert me if there's no data"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.noDataHelpText",{defaultMessage:"Enable this to trigger the action if the metric(s) do not report any data over the expected time period, or if the alert fails to query Elasticsearch"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),checked:alertParams.alertOnNoData,onChange:e=>setAlertParams("alertOnNoData",e.target.checked)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.filterLabel",{defaultMessage:"Filter (optional)"}),helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.filterHelpText",{defaultMessage:"Use a KQL expression to limit the scope of your alert trigger."}),fullWidth:true,display:"rowCompressed"},metadata&&external_kbnSharedDeps_React_default.a.createElement(kuery_bar["a"],{derivedIndexPattern:derivedIndexPattern,onChange:debouncedOnFilterChange,onSubmit:onFilterChange,value:alertParams.filterQueryText})||external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{onChange:handleFieldSearchChange,value:alertParams.filterQueryText,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.createAlertPerText",{defaultMessage:"Create alert per (optional)"}),helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.createAlertPerHelpText",{defaultMessage:'Create an alert for every unique value. For example: "host.id" or "cloud.region".'}),fullWidth:true,display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(group_by["a"],{onChange:onGroupByChange,fields:derivedIndexPattern.fields,options:{...options,groupBy:alertParams.groupBy||undefined}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(common["a"],{alertInterval:alertInterval,alertThrottle:alertThrottle,alertNotifyWhen:alertNotifyWhen,alertType:metrics["e"],alertParams:Object(external_kbnSharedDeps_Lodash_["pick"])(alertParams,"criteria","groupBy","filterQuery","sourceId"),showNoDataResults:alertParams.alertOnNoData,validate:validation["a"],groupByDisplayName:groupByPreviewDisplayName}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};var components_expression=__webpack_exports__["default"]=Expressions},89:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return ItemTypeRT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return InventoryVisTypeRT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return InventoryMetricRT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return MetricsUIAggregationRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return SnapshotMetricTypeKeys}));__webpack_require__.d(__webpack_exports__,"f",(function(){return SnapshotMetricTypeRT}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);const ItemTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({host:null,pod:null,container:null,awsEC2:null,awsS3:null,awsSQS:null,awsRDS:null});const InventoryVisTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({line:null,area:null,bar:null});const InventoryFormatterTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({abbreviatedNumber:null,bits:null,bytes:null,number:null,percent:null,highPercision:null});const InventoryMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({hostSystemOverview:null,hostCpuUsage:null,hostFilesystem:null,hostK8sOverview:null,hostK8sCpuCap:null,hostK8sDiskCap:null,hostK8sMemoryCap:null,hostK8sPodCap:null,hostLoad:null,hostMemoryUsage:null,hostNetworkTraffic:null,hostDockerOverview:null,hostDockerInfo:null,hostDockerTop5ByCpu:null,hostDockerTop5ByMemory:null,podOverview:null,podCpuUsage:null,podMemoryUsage:null,podLogUsage:null,podNetworkTraffic:null,containerOverview:null,containerCpuKernel:null,containerCpuUsage:null,containerDiskIOOps:null,containerDiskIOBytes:null,containerMemory:null,containerNetworkTraffic:null,nginxHits:null,nginxRequestRate:null,nginxActiveConnections:null,nginxRequestsPerConnection:null,awsOverview:null,awsCpuUtilization:null,awsNetworkBytes:null,awsNetworkPackets:null,awsDiskioBytes:null,awsDiskioOps:null,awsEC2CpuUtilization:null,awsEC2NetworkTraffic:null,awsEC2DiskIOBytes:null,awsS3TotalRequests:null,awsS3NumberOfObjects:null,awsS3BucketSize:null,awsS3DownloadBytes:null,awsS3UploadBytes:null,awsRDSCpuTotal:null,awsRDSConnections:null,awsRDSQueriesExecuted:null,awsRDSActiveTransactions:null,awsRDSLatency:null,awsSQSMessagesVisible:null,awsSQSMessagesDelayed:null,awsSQSMessagesSent:null,awsSQSMessagesEmpty:null,awsSQSOldestMessage:null,custom:null});const TSVBMetricTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({avg:null,max:null,min:null,calculation:null,cardinality:null,series_agg:null,positive_only:null,derivative:null,count:null,sum:null,cumulative_sum:null});const TSVBMetricModelCountRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("count")});const TSVBMetricModelBasicMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:TSVBMetricTypeRT}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);const TSVBMetricModelVariableRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],name:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const TSVBMetricModelBucketScriptRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],script:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("calculation"),variables:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBMetricModelVariableRT)});const TSVBMetricModelDerivativeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],unit:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("derivative")});const TSVBMetricModelSeriesAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],function:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("series_agg")});const TSVBPercentileItemRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],value:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]});const TSVBMetricModePercentileAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("percentile"),percentiles:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBPercentileItemRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);const TSVBMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([TSVBMetricModelCountRT,TSVBMetricModelBasicMetricRT,TSVBMetricModelBucketScriptRT,TSVBMetricModelDerivativeRT,TSVBMetricModePercentileAggRT,TSVBMetricModelSeriesAggRT]);const TSVBSeriesRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBMetricRT),split_mode:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({terms_field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],terms_size:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],terms_order_by:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],filter:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({query:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],language:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({lucene:null,kuery:null})})})]);const TSVBMetricModelRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:InventoryMetricRT,requires:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]),index_pattern:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])]),interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],time_field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],series:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBSeriesRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({filter:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],map_field_to:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],id_type:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({cloud:null,node:null}),drop_last_bucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]})]);const ESBasicMetricAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]));const ESPercentileAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({percentiles:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],percents:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["number"])})});const ESCaridnalityAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({cardinality:io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],script:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESBucketScriptAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({bucket_script:io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]])),script:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({source:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],lang:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({painless:null,expression:null})})}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({gap_policy:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({skip:null,insert_zeros:null})})])});const ESCumulativeSumAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({cumulative_sum:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESDerivativeAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({derivative:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],gap_policy:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({skip:null,insert_zeros:null}),unit:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESSumBucketAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({sum_bucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESTopHitsAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({top_hits:io_ts__WEBPACK_IMPORTED_MODULE_0__["object"]});const ESTermsWithAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["recursion"]("SnapshotModelRT",()=>io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({terms:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),aggregations:MetricsUIAggregationRT}));const ESAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([ESBasicMetricAggRT,ESPercentileAggRT,ESBucketScriptAggRT,ESCumulativeSumAggRT,ESDerivativeAggRT,ESSumBucketAggRT,ESTermsWithAggregationRT,ESCaridnalityAggRT,ESTopHitsAggRT]);const MetricsUIAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],ESAggregationRT);const SnapshotMetricTypeKeys={count:null,cpu:null,load:null,memory:null,tx:null,rx:null,logRate:null,diskIOReadBytes:null,diskIOWriteBytes:null,s3TotalRequests:null,s3NumberOfObjects:null,s3BucketSize:null,s3DownloadBytes:null,s3UploadBytes:null,rdsConnections:null,rdsQueriesExecuted:null,rdsActiveTransactions:null,rdsLatency:null,sqsMessagesVisible:null,sqsMessagesDelayed:null,sqsMessagesSent:null,sqsMessagesEmpty:null,sqsOldestMessage:null,custom:null};const SnapshotMetricTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](SnapshotMetricTypeKeys)},91:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Color}));__webpack_require__.d(__webpack_exports__,"b",(function(){return colorTransformer}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(8);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);let Color;(function(Color){Color["color0"]="color0";Color["color1"]="color1";Color["color2"]="color2";Color["color3"]="color3";Color["color4"]="color4";Color["color5"]="color5";Color["color6"]="color6";Color["color7"]="color7";Color["color8"]="color8";Color["color9"]="color9"})(Color||(Color={}));const euiPalette=Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["euiPaletteColorBlind"])();const defaultPalette={[Color.color0]:euiPalette[1],[Color.color1]:euiPalette[2],[Color.color2]:euiPalette[0],[Color.color3]:euiPalette[3],[Color.color4]:euiPalette[4],[Color.color5]:euiPalette[5],[Color.color6]:euiPalette[6],[Color.color7]:euiPalette[7],[Color.color8]:euiPalette[8],[Color.color9]:euiPalette[9]};const createPaletteTransformer=palette=>color=>palette[color];const colorTransformer=createPaletteTransformer(defaultPalette);const sampleColor=(usedColors=[])=>{const available=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["difference"])(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["values"])(Color),usedColors);return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["first"])(available)||Color.color0}},93:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return MetricsExplorerChartType}));__webpack_require__.d(__webpack_exports__,"d",(function(){return MetricsExplorerYAxisMode}));__webpack_require__.d(__webpack_exports__,"f",(function(){return metricsExplorerChartOptionsRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return metricExplorerOptionsRT}));__webpack_require__.d(__webpack_exports__,"g",(function(){return metricsExplorerTimeOptionsRT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DEFAULT_METRICS_EXPLORER_VIEW_STATE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return MetricsExplorerOptionsContainer}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);var constate__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(83);var constate__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(constate__WEBPACK_IMPORTED_MODULE_2__);var react__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);var _alerting_use_alert_prefill__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(122);var _common_color_palette__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(91);var _common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(100);var _hooks_use_kibana_timefilter_time__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(111);const metricsExplorerOptionsMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([_common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_6__["d"],io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({rate:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],color:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](Object.fromEntries(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["values"])(_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"]).map(c=>[c,null]))),label:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);let MetricsExplorerChartType;(function(MetricsExplorerChartType){MetricsExplorerChartType["line"]="line";MetricsExplorerChartType["area"]="area";MetricsExplorerChartType["bar"]="bar"})(MetricsExplorerChartType||(MetricsExplorerChartType={}));let MetricsExplorerYAxisMode;(function(MetricsExplorerYAxisMode){MetricsExplorerYAxisMode["fromZero"]="fromZero";MetricsExplorerYAxisMode["auto"]="auto"})(MetricsExplorerYAxisMode||(MetricsExplorerYAxisMode={}));const metricsExplorerChartOptionsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({yAxisMode:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](Object.fromEntries(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["values"])(MetricsExplorerYAxisMode).map(v=>[v,null]))),type:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](Object.fromEntries(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["values"])(MetricsExplorerChartType).map(v=>[v,null]))),stack:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]});const metricExplorerOptionsRequiredRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({aggregation:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerOptionsMetricRT)});const metricExplorerOptionsOptionalRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({limit:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],groupBy:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])]),filterQuery:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],source:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],forceInterval:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],dropLastBucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]});const metricExplorerOptionsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([metricExplorerOptionsRequiredRT,metricExplorerOptionsOptionalRT]);const metricsExplorerTimeOptionsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({from:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],to:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const DEFAULT_TIMERANGE={from:"now-1h",to:"now",interval:">=10s"};const DEFAULT_CHART_OPTIONS={type:MetricsExplorerChartType.line,yAxisMode:MetricsExplorerYAxisMode.fromZero,stack:false};const DEFAULT_METRICS=[{aggregation:"avg",field:"system.cpu.user.pct",color:_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"].color0},{aggregation:"avg",field:"kubernetes.pod.cpu.usage.node.pct",color:_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"].color1},{aggregation:"avg",field:"docker.cpu.total.pct",color:_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"].color2}];const DEFAULT_OPTIONS={aggregation:"avg",metrics:DEFAULT_METRICS,source:"default"};const DEFAULT_METRICS_EXPLORER_VIEW_STATE={options:DEFAULT_OPTIONS,chartOptions:DEFAULT_CHART_OPTIONS,currentTimerange:DEFAULT_TIMERANGE};function parseJsonOrDefault(value,defaultValue){if(!value){return defaultValue}try{return JSON.parse(value)}catch(e){return defaultValue}}function useStateWithLocalStorage(key,defaultState){const storageState=localStorage.getItem(key);const[state,setState]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(parseJsonOrDefault(storageState,defaultState));Object(react__WEBPACK_IMPORTED_MODULE_3__["useEffect"])(()=>{localStorage.setItem(key,JSON.stringify(state))},[key,state]);return[state,setState]}const useMetricsExplorerOptions=()=>{const TIME_DEFAULTS={from:"now-1h",to:"now"};const[getTime]=Object(_hooks_use_kibana_timefilter_time__WEBPACK_IMPORTED_MODULE_7__["a"])(TIME_DEFAULTS);const{from:from,to:to}=getTime();const defaultTimeRange={from:from,to:to,interval:DEFAULT_TIMERANGE.interval};const[options,setOptions]=useStateWithLocalStorage("MetricsExplorerOptions",DEFAULT_OPTIONS);const[currentTimerange,setTimeRange]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(defaultTimeRange);Object(_hooks_use_kibana_timefilter_time__WEBPACK_IMPORTED_MODULE_7__["b"])(TIME_DEFAULTS,{from:currentTimerange.from,to:currentTimerange.to});const[chartOptions,setChartOptions]=useStateWithLocalStorage("MetricsExplorerChartOptions",DEFAULT_CHART_OPTIONS);const[isAutoReloading,setAutoReloading]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(false);const{metricThresholdPrefill:metricThresholdPrefill}=Object(_alerting_use_alert_prefill__WEBPACK_IMPORTED_MODULE_4__["b"])();const prefillContext=Object(react__WEBPACK_IMPORTED_MODULE_3__["useMemo"])(()=>metricThresholdPrefill,[metricThresholdPrefill]);Object(react__WEBPACK_IMPORTED_MODULE_3__["useEffect"])(()=>{if(prefillContext){const{setPrefillOptions:setPrefillOptions}=prefillContext;const{metrics:metrics,groupBy:groupBy,filterQuery:filterQuery}=options;setPrefillOptions({metrics:metrics,groupBy:groupBy,filterQuery:filterQuery})}},[options,prefillContext]);return{defaultViewState:{options:DEFAULT_OPTIONS,chartOptions:DEFAULT_CHART_OPTIONS,currentTimerange:defaultTimeRange},options:options,chartOptions:chartOptions,setChartOptions:setChartOptions,currentTimerange:currentTimerange,isAutoReloading:isAutoReloading,setOptions:setOptions,setTimeRange:setTimeRange,startAutoReload:()=>setAutoReloading(true),stopAutoReload:()=>setAutoReloading(false)}};const MetricsExplorerOptionsContainer=constate__WEBPACK_IMPORTED_MODULE_2___default()(useMetricsExplorerOptions)}}]);