/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["infra_bundle_jsonpfunction"]=window["infra_bundle_jsonpfunction"]||[]).push([[8],{120:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getChartTheme}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getTimelineChartTheme}));var _elastic_charts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(69);var _elastic_charts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_charts__WEBPACK_IMPORTED_MODULE_0__);function getChartTheme(isDarkMode){return isDarkMode?_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["DARK_THEME"]:_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["LIGHT_THEME"]}function getTimelineChartTheme(isDarkMode){return isDarkMode?_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["DARK_THEME"]:Object(_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["mergeWithDefaultTheme"])(TIMELINE_LIGHT_THEME,_elastic_charts__WEBPACK_IMPORTED_MODULE_0__["LIGHT_THEME"])}const TIMELINE_LIGHT_THEME={crosshair:{band:{fill:"#D3DAE6"}},axes:{gridLine:{horizontal:{stroke:"#eaeaea"}}}}},128:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MetricExplorerSeriesChart}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_charts__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(69);var _elastic_charts__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_charts__WEBPACK_IMPORTED_MODULE_1__);var _common_color_palette__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(91);var _helpers_create_metric_label__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(168);var _hooks_use_metrics_explorer_options__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(93);var _helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(129);const MetricExplorerSeriesChart=props=>{if(_hooks_use_metrics_explorer_options__WEBPACK_IMPORTED_MODULE_4__["b"].bar===props.type){return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(MetricsExplorerBarChart,props)}return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(MetricsExplorerAreaChart,props)};const MetricsExplorerAreaChart=({metric:metric,id:id,series:series,type:type,stack:stack,opacity:opacity})=>{const color=metric.color&&Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(metric.color)||Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["a"].color0);const yAccessors=Array.isArray(id)?id.map(i=>Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,i)).slice(id.length-1,id.length):[Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,id)];const y0Accessors=Array.isArray(id)&&id.length>1?id.map(i=>Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,i)).slice(0,1):undefined;const chartId=`series-${series.id}-${yAccessors.join("-")}`;const seriesAreaStyle={line:{strokeWidth:2,visible:true},area:{opacity:opacity||.5,visible:type===_hooks_use_metrics_explorer_options__WEBPACK_IMPORTED_MODULE_4__["b"].area}};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["AreaSeries"],{id:chartId,key:chartId,name:Object(_helpers_create_metric_label__WEBPACK_IMPORTED_MODULE_3__["a"])(metric),xScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Time,yScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Linear,xAccessor:"timestamp",yAccessors:yAccessors,y0Accessors:y0Accessors,data:series.rows,stackAccessors:stack?["timestamp"]:void 0,areaSeriesStyle:seriesAreaStyle,color:color})};const MetricsExplorerBarChart=({metric:metric,id:id,series:series,stack:stack})=>{const color=metric.color&&Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(metric.color)||Object(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["b"])(_common_color_palette__WEBPACK_IMPORTED_MODULE_2__["a"].color0);const yAccessors=Array.isArray(id)?id.map(i=>Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,i)).slice(id.length-1,id.length):[Object(_helpers_get_metric_id__WEBPACK_IMPORTED_MODULE_5__["a"])(metric,id)];const chartId=`series-${series.id}-${yAccessors.join("-")}`;const seriesBarStyle={rectBorder:{stroke:color,strokeWidth:1,visible:true},rect:{opacity:1}};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["BarSeries"],{id:chartId,key:chartId,name:Object(_helpers_create_metric_label__WEBPACK_IMPORTED_MODULE_3__["a"])(metric),xScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Time,yScaleType:_elastic_charts__WEBPACK_IMPORTED_MODULE_1__["ScaleType"].Linear,xAccessor:"timestamp",yAccessors:yAccessors,data:series.rows,stackAccessors:stack?["timestamp"]:void 0,barSeriesStyle:seriesBarStyle,color:color})}},129:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getMetricId}));const getMetricId=(metric,index)=>`metric_${index}`},130:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return calculateDomain}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _get_metric_id__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(129);const getMin=values=>{const minValue=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["min"])(values);return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(minValue)&&Number.isFinite(minValue)?minValue:undefined};const getMax=values=>{const maxValue=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["max"])(values);return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(maxValue)&&Number.isFinite(maxValue)?maxValue:undefined};const calculateDomain=(series,metrics,stacked=false)=>{const values=series.rows.reduce((acc,row)=>{const rowValues=metrics.map((m,index)=>row[Object(_get_metric_id__WEBPACK_IMPORTED_MODULE_1__["a"])(m,index)]||null).filter(v=>Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(v));const minValue=getMin(rowValues);const maxValue=stacked?Object(lodash__WEBPACK_IMPORTED_MODULE_0__["sum"])(rowValues)*1.1:getMax(rowValues);return acc.concat([minValue||null,maxValue||null])},[]).filter(v=>Object(lodash__WEBPACK_IMPORTED_MODULE_0__["isNumber"])(v));return{min:getMin(values)||0,max:getMax(values)||0}}},139:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createFormatterForMetric}));var _common_formatters__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(32);var _lib_lib__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(30);var _metric_to_format__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(167);const createFormatterForMetric=metric=>{if(metric&&metric.field){const format=Object(_metric_to_format__WEBPACK_IMPORTED_MODULE_2__["a"])(metric);if(format===_lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bits&&metric.aggregation==="rate"){return Object(_common_formatters__WEBPACK_IMPORTED_MODULE_0__["b"])(_lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bits,"{{value}}/s")}return Object(_common_formatters__WEBPACK_IMPORTED_MODULE_0__["b"])(format)}return Object(_common_formatters__WEBPACK_IMPORTED_MODULE_0__["b"])(_lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].number)}},164:function(module,exports,__webpack_require__){var getNative=__webpack_require__(150);var nativeCreate=getNative(Object,"create");module.exports=nativeCreate},165:function(module,exports,__webpack_require__){var eq=__webpack_require__(270);function assocIndexOf(array,key){var length=array.length;while(length--){if(eq(array[length][0],key)){return length}}return-1}module.exports=assocIndexOf},166:function(module,exports,__webpack_require__){var isKeyable=__webpack_require__(449);function getMapData(map,key){var data=map.__data__;return isKeyable(key)?data[typeof key=="string"?"string":"hash"]:data.map}module.exports=getMapData},167:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metricToFormat}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _lib_lib__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(30);const metricToFormat=metric=>{if(metric&&metric.field){const suffix=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["last"])(metric.field.split(/\./));if(suffix==="pct"){return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].percent}if(suffix==="bytes"&&metric.aggregation==="rate"){return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bits}if(suffix==="bytes"){return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].bytes}}return _lib_lib__WEBPACK_IMPORTED_MODULE_1__["b"].number}},168:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createMetricLabel}));const createMetricLabel=metric=>{if(metric.label){return metric.label}return`${metric.aggregation}(${metric.field||""})`}},204:function(module,exports,__webpack_require__){var baseGetTag=__webpack_require__(185),isObjectLike=__webpack_require__(149);var symbolTag="[object Symbol]";function isSymbol(value){return typeof value=="symbol"||isObjectLike(value)&&baseGetTag(value)==symbolTag}module.exports=isSymbol},205:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MetricsExplorerGroupBy}));var _elastic_eui__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(8);var _elastic_eui__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);const MetricsExplorerGroupBy=({options:options,onChange:onChange,fields:fields})=>{const handleChange=Object(react__WEBPACK_IMPORTED_MODULE_2__["useCallback"])(selectedOptions=>{const groupBy=selectedOptions.map(option=>option.label);onChange(groupBy)},[onChange]);const selectedOptions=Array.isArray(options.groupBy)?options.groupBy.map(field=>({label:field})):options.groupBy?[{label:options.groupBy}]:[];return react__WEBPACK_IMPORTED_MODULE_2___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_0__["EuiComboBox"],{placeholder:_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.metricsExplorer.groupByLabel",{defaultMessage:"Everything"}),"aria-label":_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.metricsExplorer.groupByAriaLabel",{defaultMessage:"Graph per"}),fullWidth:true,singleSelection:false,selectedOptions:selectedOptions,options:fields.filter(f=>f.aggregatable&&f.type==="string").map(f=>({label:f.name})),onChange:handleChange,isClearable:true})}},206:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useMetricsExplorerData}));var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);var _elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_elastic_datemath__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);var react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);var _common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(100);var _utils_kuery__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(103);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(3);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5__);var _common_runtime_types__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(13);function isSameOptions(current,next){return Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(current,next)}function useMetricsExplorerData(options,source,derivedIndexPattern,timerange,afterKey,signal,shouldLoadImmediately=true){var _kibana$services$http;const kibana=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_5__["useKibana"])();const fetchFn=(_kibana$services$http=kibana.services.http)===null||_kibana$services$http===void 0?void 0:_kibana$services$http.fetch;const[error,setError]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const[loading,setLoading]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(true);const[data,setData]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const[lastOptions,setLastOptions]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const[lastTimerange,setLastTimerange]=Object(react__WEBPACK_IMPORTED_MODULE_2__["useState"])(null);const loadData=Object(react__WEBPACK_IMPORTED_MODULE_2__["useCallback"])(()=>{(async()=>{setLoading(true);try{const from=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(timerange.from);const to=_elastic_datemath__WEBPACK_IMPORTED_MODULE_0___default.a.parse(timerange.to,{roundUp:true});if(!from||!to){throw new Error("Unalble to parse timerange")}if(!fetchFn){throw new Error("HTTP service is unavailable")}if(!source){throw new Error("Source is unavailable")}const response=Object(_common_runtime_types__WEBPACK_IMPORTED_MODULE_6__["b"])(_common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_3__["e"])(await fetchFn("/api/infra/metrics_explorer",{method:"POST",body:JSON.stringify({forceInterval:options.forceInterval,dropLastBucket:options.dropLastBucket!=null?options.dropLastBucket:true,metrics:options.aggregation==="count"?[{aggregation:"count"}]:options.metrics.map(metric=>({aggregation:metric.aggregation,field:metric.field})),groupBy:options.groupBy,afterKey:afterKey,limit:options.limit,indexPattern:source.metricAlias,filterQuery:options.filterQuery&&Object(_utils_kuery__WEBPACK_IMPORTED_MODULE_4__["a"])(options.filterQuery,derivedIndexPattern)||void 0,timerange:{...timerange,field:source.fields.timestamp,from:from.valueOf(),to:to.valueOf()}})}));if(response){if(data&&lastOptions&&data.pageInfo.afterKey!==response.pageInfo.afterKey&&isSameOptions(lastOptions,options)&&Object(lodash__WEBPACK_IMPORTED_MODULE_1__["isEqual"])(timerange,lastTimerange)&&afterKey){const{series:series}=data;setData({...response,series:[...series,...response.series]})}else{setData(response)}setLastOptions(options);setLastTimerange(timerange);setError(null)}}catch(e){setError(e)}setLoading(false)})()},[options,source,timerange,signal,afterKey]);Object(react__WEBPACK_IMPORTED_MODULE_2__["useEffect"])(()=>{if(!shouldLoadImmediately){return}loadData()},[loadData,shouldLoadImmediately]);return{error:error,loading:loading,data:data,loadData:loadData}}},268:function(module,exports,__webpack_require__){exports.set=__webpack_require__(425);exports.setWith=__webpack_require__(458)},269:function(module,exports,__webpack_require__){var assignValue=__webpack_require__(426),castPath=__webpack_require__(428),isFunction=__webpack_require__(224),isIndex=__webpack_require__(456),isObject=__webpack_require__(146),toKey=__webpack_require__(457);function baseSet(object,path,value,customizer){if(!isObject(object)){return object}path=castPath(path,object);var index=-1,length=path.length,lastIndex=length-1,nested=object;while(nested!=null&&++index<length){var key=toKey(path[index]),newValue=value;if(key=="prototype"&&isFunction(nested)){throw new Error("Illegal access of function prototype")}if(index!=lastIndex){var objValue=hasOwnProperty.call(nested,key)?nested[key]:undefined;newValue=customizer?customizer(objValue,key,nested):undefined;if(newValue===undefined){newValue=isObject(objValue)?objValue:isIndex(path[index+1])?[]:{}}}assignValue(nested,key,newValue);nested=nested[key]}return object}module.exports=baseSet},270:function(module,exports){function eq(value,other){return value===other||value!==value&&other!==other}module.exports=eq},280:function(module,exports,__webpack_require__){var cssKeywords=__webpack_require__(479);var reverseKeywords={};for(var key in cssKeywords){if(cssKeywords.hasOwnProperty(key)){reverseKeywords[cssKeywords[key]]=key}}var convert=module.exports={rgb:{channels:3,labels:"rgb"},hsl:{channels:3,labels:"hsl"},hsv:{channels:3,labels:"hsv"},hwb:{channels:3,labels:"hwb"},cmyk:{channels:4,labels:"cmyk"},xyz:{channels:3,labels:"xyz"},lab:{channels:3,labels:"lab"},lch:{channels:3,labels:"lch"},hex:{channels:1,labels:["hex"]},keyword:{channels:1,labels:["keyword"]},ansi16:{channels:1,labels:["ansi16"]},ansi256:{channels:1,labels:["ansi256"]},hcg:{channels:3,labels:["h","c","g"]},apple:{channels:3,labels:["r16","g16","b16"]},gray:{channels:1,labels:["gray"]}};for(var model in convert){if(convert.hasOwnProperty(model)){if(!("channels"in convert[model])){throw new Error("missing channels property: "+model)}if(!("labels"in convert[model])){throw new Error("missing channel labels property: "+model)}if(convert[model].labels.length!==convert[model].channels){throw new Error("channel and label counts mismatch: "+model)}var channels=convert[model].channels;var labels=convert[model].labels;delete convert[model].channels;delete convert[model].labels;Object.defineProperty(convert[model],"channels",{value:channels});Object.defineProperty(convert[model],"labels",{value:labels})}}convert.rgb.hsl=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var min=Math.min(r,g,b);var max=Math.max(r,g,b);var delta=max-min;var h;var s;var l;if(max===min){h=0}else if(r===max){h=(g-b)/delta}else if(g===max){h=2+(b-r)/delta}else if(b===max){h=4+(r-g)/delta}h=Math.min(h*60,360);if(h<0){h+=360}l=(min+max)/2;if(max===min){s=0}else if(l<=.5){s=delta/(max+min)}else{s=delta/(2-max-min)}return[h,s*100,l*100]};convert.rgb.hsv=function(rgb){var rdif;var gdif;var bdif;var h;var s;var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var v=Math.max(r,g,b);var diff=v-Math.min(r,g,b);var diffc=function(c){return(v-c)/6/diff+1/2};if(diff===0){h=s=0}else{s=diff/v;rdif=diffc(r);gdif=diffc(g);bdif=diffc(b);if(r===v){h=bdif-gdif}else if(g===v){h=1/3+rdif-bdif}else if(b===v){h=2/3+gdif-rdif}if(h<0){h+=1}else if(h>1){h-=1}}return[h*360,s*100,v*100]};convert.rgb.hwb=function(rgb){var r=rgb[0];var g=rgb[1];var b=rgb[2];var h=convert.rgb.hsl(rgb)[0];var w=1/255*Math.min(r,Math.min(g,b));b=1-1/255*Math.max(r,Math.max(g,b));return[h,w*100,b*100]};convert.rgb.cmyk=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var c;var m;var y;var k;k=Math.min(1-r,1-g,1-b);c=(1-r-k)/(1-k)||0;m=(1-g-k)/(1-k)||0;y=(1-b-k)/(1-k)||0;return[c*100,m*100,y*100,k*100]};function comparativeDistance(x,y){return Math.pow(x[0]-y[0],2)+Math.pow(x[1]-y[1],2)+Math.pow(x[2]-y[2],2)}convert.rgb.keyword=function(rgb){var reversed=reverseKeywords[rgb];if(reversed){return reversed}var currentClosestDistance=Infinity;var currentClosestKeyword;for(var keyword in cssKeywords){if(cssKeywords.hasOwnProperty(keyword)){var value=cssKeywords[keyword];var distance=comparativeDistance(rgb,value);if(distance<currentClosestDistance){currentClosestDistance=distance;currentClosestKeyword=keyword}}}return currentClosestKeyword};convert.keyword.rgb=function(keyword){return cssKeywords[keyword]};convert.rgb.xyz=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;r=r>.04045?Math.pow((r+.055)/1.055,2.4):r/12.92;g=g>.04045?Math.pow((g+.055)/1.055,2.4):g/12.92;b=b>.04045?Math.pow((b+.055)/1.055,2.4):b/12.92;var x=r*.4124+g*.3576+b*.1805;var y=r*.2126+g*.7152+b*.0722;var z=r*.0193+g*.1192+b*.9505;return[x*100,y*100,z*100]};convert.rgb.lab=function(rgb){var xyz=convert.rgb.xyz(rgb);var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>.008856?Math.pow(x,1/3):7.787*x+16/116;y=y>.008856?Math.pow(y,1/3):7.787*y+16/116;z=z>.008856?Math.pow(z,1/3):7.787*z+16/116;l=116*y-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.hsl.rgb=function(hsl){var h=hsl[0]/360;var s=hsl[1]/100;var l=hsl[2]/100;var t1;var t2;var t3;var rgb;var val;if(s===0){val=l*255;return[val,val,val]}if(l<.5){t2=l*(1+s)}else{t2=l+s-l*s}t1=2*l-t2;rgb=[0,0,0];for(var i=0;i<3;i++){t3=h+1/3*-(i-1);if(t3<0){t3++}if(t3>1){t3--}if(6*t3<1){val=t1+(t2-t1)*6*t3}else if(2*t3<1){val=t2}else if(3*t3<2){val=t1+(t2-t1)*(2/3-t3)*6}else{val=t1}rgb[i]=val*255}return rgb};convert.hsl.hsv=function(hsl){var h=hsl[0];var s=hsl[1]/100;var l=hsl[2]/100;var smin=s;var lmin=Math.max(l,.01);var sv;var v;l*=2;s*=l<=1?l:2-l;smin*=lmin<=1?lmin:2-lmin;v=(l+s)/2;sv=l===0?2*smin/(lmin+smin):2*s/(l+s);return[h,sv*100,v*100]};convert.hsv.rgb=function(hsv){var h=hsv[0]/60;var s=hsv[1]/100;var v=hsv[2]/100;var hi=Math.floor(h)%6;var f=h-Math.floor(h);var p=255*v*(1-s);var q=255*v*(1-s*f);var t=255*v*(1-s*(1-f));v*=255;switch(hi){case 0:return[v,t,p];case 1:return[q,v,p];case 2:return[p,v,t];case 3:return[p,q,v];case 4:return[t,p,v];case 5:return[v,p,q]}};convert.hsv.hsl=function(hsv){var h=hsv[0];var s=hsv[1]/100;var v=hsv[2]/100;var vmin=Math.max(v,.01);var lmin;var sl;var l;l=(2-s)*v;lmin=(2-s)*vmin;sl=s*vmin;sl/=lmin<=1?lmin:2-lmin;sl=sl||0;l/=2;return[h,sl*100,l*100]};convert.hwb.rgb=function(hwb){var h=hwb[0]/360;var wh=hwb[1]/100;var bl=hwb[2]/100;var ratio=wh+bl;var i;var v;var f;var n;if(ratio>1){wh/=ratio;bl/=ratio}i=Math.floor(6*h);v=1-bl;f=6*h-i;if((i&1)!==0){f=1-f}n=wh+f*(v-wh);var r;var g;var b;switch(i){default:case 6:case 0:r=v;g=n;b=wh;break;case 1:r=n;g=v;b=wh;break;case 2:r=wh;g=v;b=n;break;case 3:r=wh;g=n;b=v;break;case 4:r=n;g=wh;b=v;break;case 5:r=v;g=wh;b=n;break}return[r*255,g*255,b*255]};convert.cmyk.rgb=function(cmyk){var c=cmyk[0]/100;var m=cmyk[1]/100;var y=cmyk[2]/100;var k=cmyk[3]/100;var r;var g;var b;r=1-Math.min(1,c*(1-k)+k);g=1-Math.min(1,m*(1-k)+k);b=1-Math.min(1,y*(1-k)+k);return[r*255,g*255,b*255]};convert.xyz.rgb=function(xyz){var x=xyz[0]/100;var y=xyz[1]/100;var z=xyz[2]/100;var r;var g;var b;r=x*3.2406+y*-1.5372+z*-.4986;g=x*-.9689+y*1.8758+z*.0415;b=x*.0557+y*-.204+z*1.057;r=r>.0031308?1.055*Math.pow(r,1/2.4)-.055:r*12.92;g=g>.0031308?1.055*Math.pow(g,1/2.4)-.055:g*12.92;b=b>.0031308?1.055*Math.pow(b,1/2.4)-.055:b*12.92;r=Math.min(Math.max(0,r),1);g=Math.min(Math.max(0,g),1);b=Math.min(Math.max(0,b),1);return[r*255,g*255,b*255]};convert.xyz.lab=function(xyz){var x=xyz[0];var y=xyz[1];var z=xyz[2];var l;var a;var b;x/=95.047;y/=100;z/=108.883;x=x>.008856?Math.pow(x,1/3):7.787*x+16/116;y=y>.008856?Math.pow(y,1/3):7.787*y+16/116;z=z>.008856?Math.pow(z,1/3):7.787*z+16/116;l=116*y-16;a=500*(x-y);b=200*(y-z);return[l,a,b]};convert.lab.xyz=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var x;var y;var z;y=(l+16)/116;x=a/500+y;z=y-b/200;var y2=Math.pow(y,3);var x2=Math.pow(x,3);var z2=Math.pow(z,3);y=y2>.008856?y2:(y-16/116)/7.787;x=x2>.008856?x2:(x-16/116)/7.787;z=z2>.008856?z2:(z-16/116)/7.787;x*=95.047;y*=100;z*=108.883;return[x,y,z]};convert.lab.lch=function(lab){var l=lab[0];var a=lab[1];var b=lab[2];var hr;var h;var c;hr=Math.atan2(b,a);h=hr*360/2/Math.PI;if(h<0){h+=360}c=Math.sqrt(a*a+b*b);return[l,c,h]};convert.lch.lab=function(lch){var l=lch[0];var c=lch[1];var h=lch[2];var a;var b;var hr;hr=h/360*2*Math.PI;a=c*Math.cos(hr);b=c*Math.sin(hr);return[l,a,b]};convert.rgb.ansi16=function(args){var r=args[0];var g=args[1];var b=args[2];var value=1 in arguments?arguments[1]:convert.rgb.hsv(args)[2];value=Math.round(value/50);if(value===0){return 30}var ansi=30+(Math.round(b/255)<<2|Math.round(g/255)<<1|Math.round(r/255));if(value===2){ansi+=60}return ansi};convert.hsv.ansi16=function(args){return convert.rgb.ansi16(convert.hsv.rgb(args),args[2])};convert.rgb.ansi256=function(args){var r=args[0];var g=args[1];var b=args[2];if(r===g&&g===b){if(r<8){return 16}if(r>248){return 231}return Math.round((r-8)/247*24)+232}var ansi=16+36*Math.round(r/255*5)+6*Math.round(g/255*5)+Math.round(b/255*5);return ansi};convert.ansi16.rgb=function(args){var color=args%10;if(color===0||color===7){if(args>50){color+=3.5}color=color/10.5*255;return[color,color,color]}var mult=(~~(args>50)+1)*.5;var r=(color&1)*mult*255;var g=(color>>1&1)*mult*255;var b=(color>>2&1)*mult*255;return[r,g,b]};convert.ansi256.rgb=function(args){if(args>=232){var c=(args-232)*10+8;return[c,c,c]}args-=16;var rem;var r=Math.floor(args/36)/5*255;var g=Math.floor((rem=args%36)/6)/5*255;var b=rem%6/5*255;return[r,g,b]};convert.rgb.hex=function(args){var integer=((Math.round(args[0])&255)<<16)+((Math.round(args[1])&255)<<8)+(Math.round(args[2])&255);var string=integer.toString(16).toUpperCase();return"000000".substring(string.length)+string};convert.hex.rgb=function(args){var match=args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);if(!match){return[0,0,0]}var colorString=match[0];if(match[0].length===3){colorString=colorString.split("").map((function(char){return char+char})).join("")}var integer=parseInt(colorString,16);var r=integer>>16&255;var g=integer>>8&255;var b=integer&255;return[r,g,b]};convert.rgb.hcg=function(rgb){var r=rgb[0]/255;var g=rgb[1]/255;var b=rgb[2]/255;var max=Math.max(Math.max(r,g),b);var min=Math.min(Math.min(r,g),b);var chroma=max-min;var grayscale;var hue;if(chroma<1){grayscale=min/(1-chroma)}else{grayscale=0}if(chroma<=0){hue=0}else if(max===r){hue=(g-b)/chroma%6}else if(max===g){hue=2+(b-r)/chroma}else{hue=4+(r-g)/chroma+4}hue/=6;hue%=1;return[hue*360,chroma*100,grayscale*100]};convert.hsl.hcg=function(hsl){var s=hsl[1]/100;var l=hsl[2]/100;var c=1;var f=0;if(l<.5){c=2*s*l}else{c=2*s*(1-l)}if(c<1){f=(l-.5*c)/(1-c)}return[hsl[0],c*100,f*100]};convert.hsv.hcg=function(hsv){var s=hsv[1]/100;var v=hsv[2]/100;var c=s*v;var f=0;if(c<1){f=(v-c)/(1-c)}return[hsv[0],c*100,f*100]};convert.hcg.rgb=function(hcg){var h=hcg[0]/360;var c=hcg[1]/100;var g=hcg[2]/100;if(c===0){return[g*255,g*255,g*255]}var pure=[0,0,0];var hi=h%1*6;var v=hi%1;var w=1-v;var mg=0;switch(Math.floor(hi)){case 0:pure[0]=1;pure[1]=v;pure[2]=0;break;case 1:pure[0]=w;pure[1]=1;pure[2]=0;break;case 2:pure[0]=0;pure[1]=1;pure[2]=v;break;case 3:pure[0]=0;pure[1]=w;pure[2]=1;break;case 4:pure[0]=v;pure[1]=0;pure[2]=1;break;default:pure[0]=1;pure[1]=0;pure[2]=w}mg=(1-c)*g;return[(c*pure[0]+mg)*255,(c*pure[1]+mg)*255,(c*pure[2]+mg)*255]};convert.hcg.hsv=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1-c);var f=0;if(v>0){f=c/v}return[hcg[0],f*100,v*100]};convert.hcg.hsl=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var l=g*(1-c)+.5*c;var s=0;if(l>0&&l<.5){s=c/(2*l)}else if(l>=.5&&l<1){s=c/(2*(1-l))}return[hcg[0],s*100,l*100]};convert.hcg.hwb=function(hcg){var c=hcg[1]/100;var g=hcg[2]/100;var v=c+g*(1-c);return[hcg[0],(v-c)*100,(1-v)*100]};convert.hwb.hcg=function(hwb){var w=hwb[1]/100;var b=hwb[2]/100;var v=1-b;var c=v-w;var g=0;if(c<1){g=(v-c)/(1-c)}return[hwb[0],c*100,g*100]};convert.apple.rgb=function(apple){return[apple[0]/65535*255,apple[1]/65535*255,apple[2]/65535*255]};convert.rgb.apple=function(rgb){return[rgb[0]/255*65535,rgb[1]/255*65535,rgb[2]/255*65535]};convert.gray.rgb=function(args){return[args[0]/100*255,args[0]/100*255,args[0]/100*255]};convert.gray.hsl=convert.gray.hsv=function(args){return[0,0,args[0]]};convert.gray.hwb=function(gray){return[0,100,gray[0]]};convert.gray.cmyk=function(gray){return[0,0,0,gray[0]]};convert.gray.lab=function(gray){return[gray[0],0,0]};convert.gray.hex=function(gray){var val=Math.round(gray[0]/100*255)&255;var integer=(val<<16)+(val<<8)+val;var string=integer.toString(16).toUpperCase();return"000000".substring(string.length)+string};convert.rgb.gray=function(rgb){var val=(rgb[0]+rgb[1]+rgb[2])/3;return[val/255*100]}},425:function(module,exports,__webpack_require__){var baseSet=__webpack_require__(269);function set(object,path,value){return object==null?object:baseSet(object,path,value)}module.exports=set},426:function(module,exports,__webpack_require__){var baseAssignValue=__webpack_require__(427),eq=__webpack_require__(270);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function assignValue(object,key,value){var objValue=object[key];if(!(hasOwnProperty.call(object,key)&&eq(objValue,value))||value===undefined&&!(key in object)){baseAssignValue(object,key,value)}}module.exports=assignValue},427:function(module,exports,__webpack_require__){var defineProperty=__webpack_require__(223);function baseAssignValue(object,key,value){if(key=="__proto__"&&defineProperty){defineProperty(object,key,{configurable:true,enumerable:true,value:value,writable:true})}else{object[key]=value}}module.exports=baseAssignValue},428:function(module,exports,__webpack_require__){var isArray=__webpack_require__(124),isKey=__webpack_require__(429),stringToPath=__webpack_require__(430),toString=__webpack_require__(453);function castPath(value,object){if(isArray(value)){return value}return isKey(value,object)?[value]:stringToPath(toString(value))}module.exports=castPath},429:function(module,exports,__webpack_require__){var isArray=__webpack_require__(124),isSymbol=__webpack_require__(204);var reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey(value,object){if(isArray(value)){return false}var type=typeof value;if(type=="number"||type=="symbol"||type=="boolean"||value==null||isSymbol(value)){return true}return reIsPlainProp.test(value)||!reIsDeepProp.test(value)||object!=null&&value in Object(object)}module.exports=isKey},430:function(module,exports,__webpack_require__){var memoizeCapped=__webpack_require__(431);var rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var reEscapeChar=/\\(\\)?/g;var stringToPath=memoizeCapped((function(string){var result=[];if(string.charCodeAt(0)===46){result.push("")}string.replace(rePropName,(function(match,number,quote,subString){result.push(quote?subString.replace(reEscapeChar,"$1"):number||match)}));return result}));module.exports=stringToPath},431:function(module,exports,__webpack_require__){var memoize=__webpack_require__(432);var MAX_MEMOIZE_SIZE=500;function memoizeCapped(func){var result=memoize(func,(function(key){if(cache.size===MAX_MEMOIZE_SIZE){cache.clear()}return key}));var cache=result.cache;return result}module.exports=memoizeCapped},432:function(module,exports,__webpack_require__){var MapCache=__webpack_require__(433);var FUNC_ERROR_TEXT="Expected a function";function memoize(func,resolver){if(typeof func!="function"||resolver!=null&&typeof resolver!="function"){throw new TypeError(FUNC_ERROR_TEXT)}var memoized=function(){var args=arguments,key=resolver?resolver.apply(this,args):args[0],cache=memoized.cache;if(cache.has(key)){return cache.get(key)}var result=func.apply(this,args);memoized.cache=cache.set(key,result)||cache;return result};memoized.cache=new(memoize.Cache||MapCache);return memoized}memoize.Cache=MapCache;module.exports=memoize},433:function(module,exports,__webpack_require__){var mapCacheClear=__webpack_require__(434),mapCacheDelete=__webpack_require__(448),mapCacheGet=__webpack_require__(450),mapCacheHas=__webpack_require__(451),mapCacheSet=__webpack_require__(452);function MapCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}MapCache.prototype.clear=mapCacheClear;MapCache.prototype["delete"]=mapCacheDelete;MapCache.prototype.get=mapCacheGet;MapCache.prototype.has=mapCacheHas;MapCache.prototype.set=mapCacheSet;module.exports=MapCache},434:function(module,exports,__webpack_require__){var Hash=__webpack_require__(435),ListCache=__webpack_require__(441),Map=__webpack_require__(447);function mapCacheClear(){this.size=0;this.__data__={hash:new Hash,map:new(Map||ListCache),string:new Hash}}module.exports=mapCacheClear},435:function(module,exports,__webpack_require__){var hashClear=__webpack_require__(436),hashDelete=__webpack_require__(437),hashGet=__webpack_require__(438),hashHas=__webpack_require__(439),hashSet=__webpack_require__(440);function Hash(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}Hash.prototype.clear=hashClear;Hash.prototype["delete"]=hashDelete;Hash.prototype.get=hashGet;Hash.prototype.has=hashHas;Hash.prototype.set=hashSet;module.exports=Hash},436:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(164);function hashClear(){this.__data__=nativeCreate?nativeCreate(null):{};this.size=0}module.exports=hashClear},437:function(module,exports){function hashDelete(key){var result=this.has(key)&&delete this.__data__[key];this.size-=result?1:0;return result}module.exports=hashDelete},438:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(164);var HASH_UNDEFINED="__lodash_hash_undefined__";var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function hashGet(key){var data=this.__data__;if(nativeCreate){var result=data[key];return result===HASH_UNDEFINED?undefined:result}return hasOwnProperty.call(data,key)?data[key]:undefined}module.exports=hashGet},439:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(164);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function hashHas(key){var data=this.__data__;return nativeCreate?data[key]!==undefined:hasOwnProperty.call(data,key)}module.exports=hashHas},440:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(164);var HASH_UNDEFINED="__lodash_hash_undefined__";function hashSet(key,value){var data=this.__data__;this.size+=this.has(key)?0:1;data[key]=nativeCreate&&value===undefined?HASH_UNDEFINED:value;return this}module.exports=hashSet},441:function(module,exports,__webpack_require__){var listCacheClear=__webpack_require__(442),listCacheDelete=__webpack_require__(443),listCacheGet=__webpack_require__(444),listCacheHas=__webpack_require__(445),listCacheSet=__webpack_require__(446);function ListCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}ListCache.prototype.clear=listCacheClear;ListCache.prototype["delete"]=listCacheDelete;ListCache.prototype.get=listCacheGet;ListCache.prototype.has=listCacheHas;ListCache.prototype.set=listCacheSet;module.exports=ListCache},442:function(module,exports){function listCacheClear(){this.__data__=[];this.size=0}module.exports=listCacheClear},443:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(165);var arrayProto=Array.prototype;var splice=arrayProto.splice;function listCacheDelete(key){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){return false}var lastIndex=data.length-1;if(index==lastIndex){data.pop()}else{splice.call(data,index,1)}--this.size;return true}module.exports=listCacheDelete},444:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(165);function listCacheGet(key){var data=this.__data__,index=assocIndexOf(data,key);return index<0?undefined:data[index][1]}module.exports=listCacheGet},445:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(165);function listCacheHas(key){return assocIndexOf(this.__data__,key)>-1}module.exports=listCacheHas},446:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(165);function listCacheSet(key,value){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){++this.size;data.push([key,value])}else{data[index][1]=value}return this}module.exports=listCacheSet},447:function(module,exports,__webpack_require__){var getNative=__webpack_require__(150),root=__webpack_require__(148);var Map=getNative(root,"Map");module.exports=Map},448:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(166);function mapCacheDelete(key){var result=getMapData(this,key)["delete"](key);this.size-=result?1:0;return result}module.exports=mapCacheDelete},449:function(module,exports){function isKeyable(value){var type=typeof value;return type=="string"||type=="number"||type=="symbol"||type=="boolean"?value!=="__proto__":value===null}module.exports=isKeyable},450:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(166);function mapCacheGet(key){return getMapData(this,key).get(key)}module.exports=mapCacheGet},451:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(166);function mapCacheHas(key){return getMapData(this,key).has(key)}module.exports=mapCacheHas},452:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(166);function mapCacheSet(key,value){var data=getMapData(this,key),size=data.size;data.set(key,value);this.size+=data.size==size?0:1;return this}module.exports=mapCacheSet},453:function(module,exports,__webpack_require__){var baseToString=__webpack_require__(454);function toString(value){return value==null?"":baseToString(value)}module.exports=toString},454:function(module,exports,__webpack_require__){var Symbol=__webpack_require__(147),arrayMap=__webpack_require__(455),isArray=__webpack_require__(124),isSymbol=__webpack_require__(204);var INFINITY=1/0;var symbolProto=Symbol?Symbol.prototype:undefined,symbolToString=symbolProto?symbolProto.toString:undefined;function baseToString(value){if(typeof value=="string"){return value}if(isArray(value)){return arrayMap(value,baseToString)+""}if(isSymbol(value)){return symbolToString?symbolToString.call(value):""}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}module.exports=baseToString},455:function(module,exports){function arrayMap(array,iteratee){var index=-1,length=array==null?0:array.length,result=Array(length);while(++index<length){result[index]=iteratee(array[index],index,array)}return result}module.exports=arrayMap},456:function(module,exports){var MAX_SAFE_INTEGER=9007199254740991;var reIsUint=/^(?:0|[1-9]\d*)$/;function isIndex(value,length){var type=typeof value;length=length==null?MAX_SAFE_INTEGER:length;return!!length&&(type=="number"||type!="symbol"&&reIsUint.test(value))&&(value>-1&&value%1==0&&value<length)}module.exports=isIndex},457:function(module,exports,__webpack_require__){var isSymbol=__webpack_require__(204);var INFINITY=1/0;function toKey(value){if(typeof value=="string"||isSymbol(value)){return value}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}module.exports=toKey},458:function(module,exports,__webpack_require__){var baseSet=__webpack_require__(269);function setWith(object,path,value,customizer){customizer=typeof customizer=="function"?customizer:undefined;return object==null?object:baseSet(object,path,value,customizer)}module.exports=setWith},459:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var PathReporter_1=__webpack_require__(460);var Either_1=__webpack_require__(14);exports.ThrowReporter={report:function(validation){if(Either_1.isLeft(validation)){throw new Error(PathReporter_1.PathReporter.report(validation).join("\n"))}}}},460:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _1=__webpack_require__(0);var Either_1=__webpack_require__(14);function stringify(v){if(typeof v==="function"){return _1.getFunctionName(v)}if(typeof v==="number"&&!isFinite(v)){if(isNaN(v)){return"NaN"}return v>0?"Infinity":"-Infinity"}return JSON.stringify(v)}function getContextPath(context){return context.map((function(_a){var key=_a.key,type=_a.type;return key+": "+type.name})).join("/")}function getMessage(e){return e.message!==undefined?e.message:"Invalid value "+stringify(e.value)+" supplied to "+getContextPath(e.context)}function failure(es){return es.map(getMessage)}exports.failure=failure;function success(){return["No errors!"]}exports.success=success;exports.PathReporter={report:Either_1.fold(failure,success)}},461:function(module){module.exports=JSON.parse('{"job_type":"anomaly_detector","groups":["hosts","metrics"],"description":"Metrics: Hosts - Identify unusual spikes in memory usage across hosts.","analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(\'system.memory.actual.used.pct\')","function":"max","field_name":"system.memory.actual.used.pct","custom_rules":[{"actions":["skip_result"],"conditions":[{"applies_to":"actual","operator":"lt","value":0.1}]}]}],"influencers":["host.name"]},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"64mb"},"custom_settings":{"created_by":"ml-module-metrics-ui-hosts","custom_urls":[{"url_name":"Host Metrics","url_value":"metrics/detail/host/$host.name$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},462:function(module){module.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"system.memory"}}]}}}')},463:function(module){module.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Hosts - Identify unusual spikes in inbound traffic across hosts.","groups":["hosts","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_in_derivative)","function":"max","field_name":"bytes_in_derivative"}],"influencers":["host.name"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"created_by":"ml-module-metrics-ui-hosts","custom_urls":[{"url_name":"Host Metrics","url_value":"metrics/detail/host/$host.name$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},464:function(module){module.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"system.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"host.name":{"terms":{"field":"host.name","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_in_max":{"max":{"field":"system.network.in.bytes"}},"bytes_in_derivative":{"derivative":{"buckets_path":"bytes_in_max"}},"positive_only":{"bucket_script":{"buckets_path":{"in_derivative":"bytes_in_derivative.value"},"script":"params.in_derivative > 0.0 ? params.in_derivative : 0.0"}}}}}}}}')},465:function(module){module.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Hosts - Identify unusual spikes in outbound traffic across hosts.","groups":["hosts","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_out_derivative)","function":"max","field_name":"bytes_out_derivative"}],"influencers":["host.name"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"created_by":"ml-module-metrics-ui-hosts","custom_urls":[{"url_name":"Host Metrics","url_value":"metrics/detail/host/$host.name$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},466:function(module){module.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"system.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"host.name":{"terms":{"field":"host.name","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_out_max":{"max":{"field":"system.network.out.bytes"}},"bytes_out_derivative":{"derivative":{"buckets_path":"bytes_out_max"}},"positive_only":{"bucket_script":{"buckets_path":{"out_derivative":"bytes_out_derivative.value"},"script":"params.out_derivative > 0.0 ? params.out_derivative : 0.0"}}}}}}}}')},467:function(module){module.exports=JSON.parse('{"job_type":"anomaly_detector","groups":["k8s","metrics"],"description":"Metrics: Kubernetes - Identify unusual spikes in memory usage across Kubernetes pods.","analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(\'kubernetes.pod.memory.usage.node.pct\')","function":"max","field_name":"kubernetes.pod.memory.usage.node.pct","partition_field_name":"kubernetes.namespace","custom_rules":[{"actions":["skip_result"],"conditions":[{"applies_to":"actual","operator":"lt","value":0.1}]}]}],"influencers":["kubernetes.namespace","kubernetes.node.name","kubernetes.pod.uid"]},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"64mb"},"custom_settings":{"created_by":"ml-module-metrics-ui-k8s","custom_urls":[{"url_name":"Pod Metrics","url_value":"metrics/detail/pod/$kubernetes.pod.uid$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},468:function(module){module.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"kubernetes.pod.uid"}},{"exists":{"field":"kubernetes.pod.memory"}}]}}}')},469:function(module){module.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Kubernetes - Identify unusual spikes in inbound traffic across Kubernetes pods.","groups":["k8s","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_in_derivative)","function":"max","field_name":"bytes_in_derivative","partition_field_name":"kubernetes.namespace"}],"influencers":["kubernetes.namespace","kubernetes.pod.uid"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"created_by":"ml-module-metrics-ui-k8s","custom_urls":[{"url_name":"Pod Metrics","url_value":"metrics/detail/pod/$kubernetes.pod.uid$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},470:function(module){module.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"kubernetes.pod.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"kubernetes.namespace":{"terms":{"field":"kubernetes.namespace","size":25},"aggregations":{"kubernetes.pod.uid":{"terms":{"field":"kubernetes.pod.uid","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_in_max":{"max":{"field":"kubernetes.pod.network.rx.bytes"}},"bytes_in_derivative":{"derivative":{"buckets_path":"bytes_in_max"}},"positive_only":{"bucket_script":{"buckets_path":{"in_derivative":"bytes_in_derivative.value"},"script":"params.in_derivative > 0.0 ? params.in_derivative : 0.0"}}}}}}}}}}')},471:function(module){module.exports=JSON.parse('{"job_type":"anomaly_detector","description":"Metrics: Kubernetes - Identify unusual spikes in outbound traffic across Kubernetes pods.","groups":["k8s","metrics"],"analysis_config":{"bucket_span":"15m","detectors":[{"detector_description":"max(bytes_out_derivative)","function":"max","field_name":"bytes_out_derivative","partition_field_name":"kubernetes.namespace"}],"influencers":["kubernetes.namespace","kubernetes.pod.uid"],"summary_count_field_name":"doc_count"},"data_description":{"time_field":"@timestamp"},"analysis_limits":{"model_memory_limit":"32mb"},"custom_settings":{"created_by":"ml-module-metrics-ui-k8s","custom_urls":[{"url_name":"Pod Metrics","url_value":"metrics/detail/pod/$kubernetes.pod.uid$?metricTime=(autoReload:!f,refreshInterval:5000,time:(from:%27$earliest$%27,interval:%3E%3D1m,to:%27$latest$%27))"}]}}')},472:function(module){module.exports=JSON.parse('{"job_id":"JOB_ID","indices":["INDEX_PATTERN_NAME"],"indices_options":{"allow_no_indices":true},"query":{"bool":{"must":[{"exists":{"field":"kubernetes.pod.network"}}]}},"chunking_config":{"mode":"manual","time_span":"900s"},"aggregations":{"kubernetes.namespace":{"terms":{"field":"kubernetes.namespace","size":25},"aggregations":{"kubernetes.pod.uid":{"terms":{"field":"kubernetes.pod.uid","size":100},"aggregations":{"buckets":{"date_histogram":{"field":"@timestamp","fixed_interval":"5m"},"aggregations":{"@timestamp":{"max":{"field":"@timestamp"}},"bytes_out_max":{"max":{"field":"kubernetes.pod.network.tx.bytes"}},"bytes_out_derivative":{"derivative":{"buckets_path":"bytes_out_max"}},"positive_only":{"bucket_script":{"buckets_path":{"pos_derivative":"bytes_out_derivative.value"},"script":"params.pos_derivative > 0.0 ? params.pos_derivative : 0.0"}}}}}}}}}}')},473:function(module,exports,__webpack_require__){"use strict";var colorString=__webpack_require__(474);var convert=__webpack_require__(478);var _slice=[].slice;var skippedModels=["keyword","gray","hex"];var hashedModelKeys={};Object.keys(convert).forEach((function(model){hashedModelKeys[_slice.call(convert[model].labels).sort().join("")]=model}));var limiters={};function Color(obj,model){if(!(this instanceof Color)){return new Color(obj,model)}if(model&&model in skippedModels){model=null}if(model&&!(model in convert)){throw new Error("Unknown model: "+model)}var i;var channels;if(!obj){this.model="rgb";this.color=[0,0,0];this.valpha=1}else if(obj instanceof Color){this.model=obj.model;this.color=obj.color.slice();this.valpha=obj.valpha}else if(typeof obj==="string"){var result=colorString.get(obj);if(result===null){throw new Error("Unable to parse color from string: "+obj)}this.model=result.model;channels=convert[this.model].channels;this.color=result.value.slice(0,channels);this.valpha=typeof result.value[channels]==="number"?result.value[channels]:1}else if(obj.length){this.model=model||"rgb";channels=convert[this.model].channels;var newArr=_slice.call(obj,0,channels);this.color=zeroArray(newArr,channels);this.valpha=typeof obj[channels]==="number"?obj[channels]:1}else if(typeof obj==="number"){obj&=16777215;this.model="rgb";this.color=[obj>>16&255,obj>>8&255,obj&255];this.valpha=1}else{this.valpha=1;var keys=Object.keys(obj);if("alpha"in obj){keys.splice(keys.indexOf("alpha"),1);this.valpha=typeof obj.alpha==="number"?obj.alpha:0}var hashedKeys=keys.sort().join("");if(!(hashedKeys in hashedModelKeys)){throw new Error("Unable to parse color from object: "+JSON.stringify(obj))}this.model=hashedModelKeys[hashedKeys];var labels=convert[this.model].labels;var color=[];for(i=0;i<labels.length;i++){color.push(obj[labels[i]])}this.color=zeroArray(color)}if(limiters[this.model]){channels=convert[this.model].channels;for(i=0;i<channels;i++){var limit=limiters[this.model][i];if(limit){this.color[i]=limit(this.color[i])}}}this.valpha=Math.max(0,Math.min(1,this.valpha));if(Object.freeze){Object.freeze(this)}}Color.prototype={toString:function(){return this.string()},toJSON:function(){return this[this.model]()},string:function(places){var self=this.model in colorString.to?this:this.rgb();self=self.round(typeof places==="number"?places:1);var args=self.valpha===1?self.color:self.color.concat(this.valpha);return colorString.to[self.model](args)},percentString:function(places){var self=this.rgb().round(typeof places==="number"?places:1);var args=self.valpha===1?self.color:self.color.concat(this.valpha);return colorString.to.rgb.percent(args)},array:function(){return this.valpha===1?this.color.slice():this.color.concat(this.valpha)},object:function(){var result={};var channels=convert[this.model].channels;var labels=convert[this.model].labels;for(var i=0;i<channels;i++){result[labels[i]]=this.color[i]}if(this.valpha!==1){result.alpha=this.valpha}return result},unitArray:function(){var rgb=this.rgb().color;rgb[0]/=255;rgb[1]/=255;rgb[2]/=255;if(this.valpha!==1){rgb.push(this.valpha)}return rgb},unitObject:function(){var rgb=this.rgb().object();rgb.r/=255;rgb.g/=255;rgb.b/=255;if(this.valpha!==1){rgb.alpha=this.valpha}return rgb},round:function(places){places=Math.max(places||0,0);return new Color(this.color.map(roundToPlace(places)).concat(this.valpha),this.model)},alpha:function(val){if(arguments.length){return new Color(this.color.concat(Math.max(0,Math.min(1,val))),this.model)}return this.valpha},red:getset("rgb",0,maxfn(255)),green:getset("rgb",1,maxfn(255)),blue:getset("rgb",2,maxfn(255)),hue:getset(["hsl","hsv","hsl","hwb","hcg"],0,(function(val){return(val%360+360)%360})),saturationl:getset("hsl",1,maxfn(100)),lightness:getset("hsl",2,maxfn(100)),saturationv:getset("hsv",1,maxfn(100)),value:getset("hsv",2,maxfn(100)),chroma:getset("hcg",1,maxfn(100)),gray:getset("hcg",2,maxfn(100)),white:getset("hwb",1,maxfn(100)),wblack:getset("hwb",2,maxfn(100)),cyan:getset("cmyk",0,maxfn(100)),magenta:getset("cmyk",1,maxfn(100)),yellow:getset("cmyk",2,maxfn(100)),black:getset("cmyk",3,maxfn(100)),x:getset("xyz",0,maxfn(100)),y:getset("xyz",1,maxfn(100)),z:getset("xyz",2,maxfn(100)),l:getset("lab",0,maxfn(100)),a:getset("lab",1),b:getset("lab",2),keyword:function(val){if(arguments.length){return new Color(val)}return convert[this.model].keyword(this.color)},hex:function(val){if(arguments.length){return new Color(val)}return colorString.to.hex(this.rgb().round().color)},rgbNumber:function(){var rgb=this.rgb().color;return(rgb[0]&255)<<16|(rgb[1]&255)<<8|rgb[2]&255},luminosity:function(){var rgb=this.rgb().color;var lum=[];for(var i=0;i<rgb.length;i++){var chan=rgb[i]/255;lum[i]=chan<=.03928?chan/12.92:Math.pow((chan+.055)/1.055,2.4)}return.2126*lum[0]+.7152*lum[1]+.0722*lum[2]},contrast:function(color2){var lum1=this.luminosity();var lum2=color2.luminosity();if(lum1>lum2){return(lum1+.05)/(lum2+.05)}return(lum2+.05)/(lum1+.05)},level:function(color2){var contrastRatio=this.contrast(color2);if(contrastRatio>=7.1){return"AAA"}return contrastRatio>=4.5?"AA":""},dark:function(){var rgb=this.rgb().color;var yiq=(rgb[0]*299+rgb[1]*587+rgb[2]*114)/1e3;return yiq<128},light:function(){return!this.dark()},negate:function(){var rgb=this.rgb();for(var i=0;i<3;i++){rgb.color[i]=255-rgb.color[i]}return rgb},lighten:function(ratio){var hsl=this.hsl();hsl.color[2]+=hsl.color[2]*ratio;return hsl},darken:function(ratio){var hsl=this.hsl();hsl.color[2]-=hsl.color[2]*ratio;return hsl},saturate:function(ratio){var hsl=this.hsl();hsl.color[1]+=hsl.color[1]*ratio;return hsl},desaturate:function(ratio){var hsl=this.hsl();hsl.color[1]-=hsl.color[1]*ratio;return hsl},whiten:function(ratio){var hwb=this.hwb();hwb.color[1]+=hwb.color[1]*ratio;return hwb},blacken:function(ratio){var hwb=this.hwb();hwb.color[2]+=hwb.color[2]*ratio;return hwb},grayscale:function(){var rgb=this.rgb().color;var val=rgb[0]*.3+rgb[1]*.59+rgb[2]*.11;return Color.rgb(val,val,val)},fade:function(ratio){return this.alpha(this.valpha-this.valpha*ratio)},opaquer:function(ratio){return this.alpha(this.valpha+this.valpha*ratio)},rotate:function(degrees){var hsl=this.hsl();var hue=hsl.color[0];hue=(hue+degrees)%360;hue=hue<0?360+hue:hue;hsl.color[0]=hue;return hsl},mix:function(mixinColor,weight){var color1=this.rgb();var color2=mixinColor.rgb();var p=weight===undefined?.5:weight;var w=2*p-1;var a=color1.alpha()-color2.alpha();var w1=((w*a===-1?w:(w+a)/(1+w*a))+1)/2;var w2=1-w1;return Color.rgb(w1*color1.red()+w2*color2.red(),w1*color1.green()+w2*color2.green(),w1*color1.blue()+w2*color2.blue(),color1.alpha()*p+color2.alpha()*(1-p))}};Object.keys(convert).forEach((function(model){if(skippedModels.indexOf(model)!==-1){return}var channels=convert[model].channels;Color.prototype[model]=function(){if(this.model===model){return new Color(this)}if(arguments.length){return new Color(arguments,model)}var newAlpha=typeof arguments[channels]==="number"?channels:this.valpha;return new Color(assertArray(convert[this.model][model].raw(this.color)).concat(newAlpha),model)};Color[model]=function(color){if(typeof color==="number"){color=zeroArray(_slice.call(arguments),channels)}return new Color(color,model)}}));function roundTo(num,places){return Number(num.toFixed(places))}function roundToPlace(places){return function(num){return roundTo(num,places)}}function getset(model,channel,modifier){model=Array.isArray(model)?model:[model];model.forEach((function(m){(limiters[m]||(limiters[m]=[]))[channel]=modifier}));model=model[0];return function(val){var result;if(arguments.length){if(modifier){val=modifier(val)}result=this[model]();result.color[channel]=val;return result}result=this[model]().color[channel];if(modifier){result=modifier(result)}return result}}function maxfn(max){return function(v){return Math.max(0,Math.min(max,v))}}function assertArray(val){return Array.isArray(val)?val:[val]}function zeroArray(arr,length){for(var i=0;i<length;i++){if(typeof arr[i]!=="number"){arr[i]=0}}return arr}module.exports=Color},474:function(module,exports,__webpack_require__){var colorNames=__webpack_require__(475);var swizzle=__webpack_require__(476);var reverseNames={};for(var name in colorNames){if(colorNames.hasOwnProperty(name)){reverseNames[colorNames[name]]=name}}var cs=module.exports={to:{},get:{}};cs.get=function(string){var prefix=string.substring(0,3).toLowerCase();var val;var model;switch(prefix){case"hsl":val=cs.get.hsl(string);model="hsl";break;case"hwb":val=cs.get.hwb(string);model="hwb";break;default:val=cs.get.rgb(string);model="rgb";break}if(!val){return null}return{model:model,value:val}};cs.get.rgb=function(string){if(!string){return null}var abbr=/^#([a-f0-9]{3,4})$/i;var hex=/^#([a-f0-9]{6})([a-f0-9]{2})?$/i;var rgba=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/;var per=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/;var keyword=/(\D+)/;var rgb=[0,0,0,1];var match;var i;var hexAlpha;if(match=string.match(hex)){hexAlpha=match[2];match=match[1];for(i=0;i<3;i++){var i2=i*2;rgb[i]=parseInt(match.slice(i2,i2+2),16)}if(hexAlpha){rgb[3]=parseInt(hexAlpha,16)/255}}else if(match=string.match(abbr)){match=match[1];hexAlpha=match[3];for(i=0;i<3;i++){rgb[i]=parseInt(match[i]+match[i],16)}if(hexAlpha){rgb[3]=parseInt(hexAlpha+hexAlpha,16)/255}}else if(match=string.match(rgba)){for(i=0;i<3;i++){rgb[i]=parseInt(match[i+1],0)}if(match[4]){rgb[3]=parseFloat(match[4])}}else if(match=string.match(per)){for(i=0;i<3;i++){rgb[i]=Math.round(parseFloat(match[i+1])*2.55)}if(match[4]){rgb[3]=parseFloat(match[4])}}else if(match=string.match(keyword)){if(match[1]==="transparent"){return[0,0,0,0]}rgb=colorNames[match[1]];if(!rgb){return null}rgb[3]=1;return rgb}else{return null}for(i=0;i<3;i++){rgb[i]=clamp(rgb[i],0,255)}rgb[3]=clamp(rgb[3],0,1);return rgb};cs.get.hsl=function(string){if(!string){return null}var hsl=/^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/;var match=string.match(hsl);if(match){var alpha=parseFloat(match[4]);var h=(parseFloat(match[1])+360)%360;var s=clamp(parseFloat(match[2]),0,100);var l=clamp(parseFloat(match[3]),0,100);var a=clamp(isNaN(alpha)?1:alpha,0,1);return[h,s,l,a]}return null};cs.get.hwb=function(string){if(!string){return null}var hwb=/^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/;var match=string.match(hwb);if(match){var alpha=parseFloat(match[4]);var h=(parseFloat(match[1])%360+360)%360;var w=clamp(parseFloat(match[2]),0,100);var b=clamp(parseFloat(match[3]),0,100);var a=clamp(isNaN(alpha)?1:alpha,0,1);return[h,w,b,a]}return null};cs.to.hex=function(){var rgba=swizzle(arguments);return"#"+hexDouble(rgba[0])+hexDouble(rgba[1])+hexDouble(rgba[2])+(rgba[3]<1?hexDouble(Math.round(rgba[3]*255)):"")};cs.to.rgb=function(){var rgba=swizzle(arguments);return rgba.length<4||rgba[3]===1?"rgb("+Math.round(rgba[0])+", "+Math.round(rgba[1])+", "+Math.round(rgba[2])+")":"rgba("+Math.round(rgba[0])+", "+Math.round(rgba[1])+", "+Math.round(rgba[2])+", "+rgba[3]+")"};cs.to.rgb.percent=function(){var rgba=swizzle(arguments);var r=Math.round(rgba[0]/255*100);var g=Math.round(rgba[1]/255*100);var b=Math.round(rgba[2]/255*100);return rgba.length<4||rgba[3]===1?"rgb("+r+"%, "+g+"%, "+b+"%)":"rgba("+r+"%, "+g+"%, "+b+"%, "+rgba[3]+")"};cs.to.hsl=function(){var hsla=swizzle(arguments);return hsla.length<4||hsla[3]===1?"hsl("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%)":"hsla("+hsla[0]+", "+hsla[1]+"%, "+hsla[2]+"%, "+hsla[3]+")"};cs.to.hwb=function(){var hwba=swizzle(arguments);var a="";if(hwba.length>=4&&hwba[3]!==1){a=", "+hwba[3]}return"hwb("+hwba[0]+", "+hwba[1]+"%, "+hwba[2]+"%"+a+")"};cs.to.keyword=function(rgb){return reverseNames[rgb.slice(0,3)]};function clamp(num,min,max){return Math.min(Math.max(min,num),max)}function hexDouble(num){var str=num.toString(16).toUpperCase();return str.length<2?"0"+str:str}},475:function(module,exports,__webpack_require__){"use strict";module.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},476:function(module,exports,__webpack_require__){"use strict";var isArrayish=__webpack_require__(477);var concat=Array.prototype.concat;var slice=Array.prototype.slice;var swizzle=module.exports=function swizzle(args){var results=[];for(var i=0,len=args.length;i<len;i++){var arg=args[i];if(isArrayish(arg)){results=concat.call(results,slice.call(arg))}else{results.push(arg)}}return results};swizzle.wrap=function(fn){return function(){return fn(swizzle(arguments))}}},477:function(module,exports,__webpack_require__){"use strict";module.exports=function isArrayish(obj){if(!obj||typeof obj==="string"){return false}return obj instanceof Array||Array.isArray(obj)||obj.length>=0&&(obj.splice instanceof Function||Object.getOwnPropertyDescriptor(obj,obj.length-1)&&obj.constructor.name!=="String")}},478:function(module,exports,__webpack_require__){var conversions=__webpack_require__(280);var route=__webpack_require__(480);var convert={};var models=Object.keys(conversions);function wrapRaw(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}if(arguments.length>1){args=Array.prototype.slice.call(arguments)}return fn(args)};if("conversion"in fn){wrappedFn.conversion=fn.conversion}return wrappedFn}function wrapRounded(fn){var wrappedFn=function(args){if(args===undefined||args===null){return args}if(arguments.length>1){args=Array.prototype.slice.call(arguments)}var result=fn(args);if(typeof result==="object"){for(var len=result.length,i=0;i<len;i++){result[i]=Math.round(result[i])}}return result};if("conversion"in fn){wrappedFn.conversion=fn.conversion}return wrappedFn}models.forEach((function(fromModel){convert[fromModel]={};Object.defineProperty(convert[fromModel],"channels",{value:conversions[fromModel].channels});Object.defineProperty(convert[fromModel],"labels",{value:conversions[fromModel].labels});var routes=route(fromModel);var routeModels=Object.keys(routes);routeModels.forEach((function(toModel){var fn=routes[toModel];convert[fromModel][toModel]=wrapRounded(fn);convert[fromModel][toModel].raw=wrapRaw(fn)}))}));module.exports=convert},479:function(module,exports,__webpack_require__){"use strict";module.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},480:function(module,exports,__webpack_require__){var conversions=__webpack_require__(280);function buildGraph(){var graph={};var models=Object.keys(conversions);for(var len=models.length,i=0;i<len;i++){graph[models[i]]={distance:-1,parent:null}}return graph}function deriveBFS(fromModel){var graph=buildGraph();var queue=[fromModel];graph[fromModel].distance=0;while(queue.length){var current=queue.pop();var adjacents=Object.keys(conversions[current]);for(var len=adjacents.length,i=0;i<len;i++){var adjacent=adjacents[i];var node=graph[adjacent];if(node.distance===-1){node.distance=graph[current].distance+1;node.parent=current;queue.unshift(adjacent)}}}return graph}function link(from,to){return function(args){return to(from(args))}}function wrapConversion(toModel,graph){var path=[graph[toModel].parent,toModel];var fn=conversions[graph[toModel].parent][toModel];var cur=graph[toModel].parent;while(graph[cur].parent){path.unshift(graph[cur].parent);fn=link(conversions[graph[cur].parent][cur],fn);cur=graph[cur].parent}fn.conversion=path;return fn}module.exports=function(fromModel){var graph=deriveBFS(fromModel);var conversion={};var models=Object.keys(graph);for(var len=models.length,i=0;i<len;i++){var toModel=models[i];var node=graph[toModel];if(node.parent===null){continue}conversion[toModel]=wrapConversion(toModel,graph)}return conversion}},491:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(18);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(67);var public_=__webpack_require__(33);var public_0=__webpack_require__(219);var _404=__webpack_require__(220);var constate_cjs=__webpack_require__(83);var constate_cjs_default=__webpack_require__.n(constate_cjs);var external_kbnSharedDeps_Moment_=__webpack_require__(50);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var elastic_datemath=__webpack_require__(6);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);var lib=__webpack_require__(0);var pipeable=__webpack_require__(22);var Either=__webpack_require__(14);var lib_function=__webpack_require__(15);var use_url_state=__webpack_require__(104);var url_state=__webpack_require__(110);const parseRange=range=>{const parsedFrom=elastic_datemath_default.a.parse(range.from.toString());const parsedTo=elastic_datemath_default.a.parse(range.to.toString(),{roundUp:true});return{...range,from:parsedFrom&&parsedFrom.valueOf()||external_kbnSharedDeps_Moment_default()().subtract(1,"hour").valueOf(),to:parsedTo&&parsedTo.valueOf()||external_kbnSharedDeps_Moment_default()().valueOf()}};const DEFAULT_TIMERANGE={from:"now-1h",to:"now",interval:">=1m"};const DEFAULT_URL_STATE={time:DEFAULT_TIMERANGE,autoReload:false,refreshInterval:5e3};const useMetricsTime=()=>{const[urlState,setUrlState]=Object(use_url_state["b"])({defaultState:DEFAULT_URL_STATE,decodeUrlState:decodeUrlState,encodeUrlState:encodeUrlState,urlStateKey:"metricTime"});const[isAutoReloading,setAutoReload]=Object(external_kbnSharedDeps_React_["useState"])(urlState.autoReload||false);const[refreshInterval,setRefreshInterval]=Object(external_kbnSharedDeps_React_["useState"])(urlState.refreshInterval||5e3);const[lastRefresh,setLastRefresh]=Object(external_kbnSharedDeps_React_["useState"])(external_kbnSharedDeps_Moment_default()().valueOf());const[timeRange,setTimeRange]=Object(external_kbnSharedDeps_React_["useState"])(urlState.time||DEFAULT_TIMERANGE);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const newState={time:timeRange,autoReload:isAutoReloading,refreshInterval:refreshInterval};return setUrlState(newState)},[isAutoReloading,refreshInterval,setUrlState,timeRange]);const[parsedTimeRange,setParsedTimeRange]=Object(external_kbnSharedDeps_React_["useState"])(parseRange(urlState.time||DEFAULT_TIMERANGE));const updateTimeRange=Object(external_kbnSharedDeps_React_["useCallback"])(range=>{setTimeRange(range);setParsedTimeRange(parseRange(range))},[]);return{timeRange:timeRange,setTimeRange:updateTimeRange,parsedTimeRange:parsedTimeRange,refreshInterval:refreshInterval,setRefreshInterval:setRefreshInterval,isAutoReloading:isAutoReloading,setAutoReload:setAutoReload,lastRefresh:lastRefresh,triggerRefresh:Object(external_kbnSharedDeps_React_["useCallback"])(()=>setLastRefresh(external_kbnSharedDeps_Moment_default()().valueOf()),[setLastRefresh])}};const MetricsTimeInputRT=lib["type"]({from:lib["union"]([lib["string"],lib["number"]]),to:lib["union"]([lib["string"],lib["number"]]),interval:lib["string"]});const MetricsTimeUrlStateRT=lib["partial"]({time:MetricsTimeInputRT,autoReload:lib["boolean"],refreshInterval:lib["number"]});const encodeUrlState=MetricsTimeUrlStateRT.encode;const decodeUrlState=value=>Object(pipeable["pipe"])(MetricsTimeUrlStateRT.decode(value),Object(Either["fold"])(Object(lib_function["constant"])(undefined),lib_function["identity"]));const replaceMetricTimeInQueryString=(from,to)=>Number.isNaN(from)||Number.isNaN(to)?value=>value:Object(url_state["d"])("metricTime",{autoReload:false,time:{interval:">=1m",from:external_kbnSharedDeps_Moment_default()(from).toISOString(),to:external_kbnSharedDeps_Moment_default()(to).toISOString()}});const MetricsTimeContainer=constate_cjs_default()(useMetricsTime);const[MetricsTimeProvider,useMetricsTimeContext]=MetricsTimeContainer;var query_params=__webpack_require__(144);const RedirectToNodeDetail=({match:{params:{nodeId:nodeId,nodeType:nodeType}},location:location})=>{const searchString=replaceMetricTimeInQueryString(Object(query_params["b"])(location),Object(query_params["d"])(location))("");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:`/detail/${nodeType}/${nodeId}?${searchString}`})};const getNodeDetailUrl=({nodeType:nodeType,nodeId:nodeId,to:to,from:from})=>({app:"metrics",pathname:`link-to/${nodeType}-detail/${nodeId}`,search:to&&from?{to:`${to}`,from:`${from}`}:undefined});var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var kibanaReact_public_=__webpack_require__(3);const useHostIpToName=(ipAddress,indexPattern)=>{var _useKibana$services$h;const fetch=(_useKibana$services$h=Object(kibanaReact_public_["useKibana"])().services.http)===null||_useKibana$services$h===void 0?void 0:_useKibana$services$h.fetch;const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loading,setLoadingState]=Object(external_kbnSharedDeps_React_["useState"])(true);const[data,setData]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{setLoadingState(true);setError(null);try{if(!fetch){throw new Error("HTTP service is unavailable")}if(ipAddress&&indexPattern){const response=await fetch("/api/infra/ip_to_host",{method:"POST",body:JSON.stringify({ip:ipAddress,index_pattern:indexPattern})});setLoadingState(false);setData(response)}}catch(err){setLoadingState(false);setError(err)}})()},[ipAddress,indexPattern,fetch]);return{name:data&&data.host||null,loading:loading,error:error}};var loading_page=__webpack_require__(112);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(12);var common_=__webpack_require__(11);var header=__webpack_require__(176);var page=__webpack_require__(96);const DetailPageContent=Object(common_["euiStyled"])(page["c"])`
  overflow: auto;
  background-color: ${props=>props.theme.eui.euiColorLightestShade};
`;const error_Error=({message:message})=>external_kbnSharedDeps_React_default.a.createElement(page["a"],null,external_kbnSharedDeps_React_default.a.createElement(header["a"],null),external_kbnSharedDeps_React_default.a.createElement(DetailPageContent,null,external_kbnSharedDeps_React_default.a.createElement(ErrorPageBody,{message:message})));const ErrorPageBody=({message:message})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],{style:{flex:"1 0 auto"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.errorPage.unexpectedErrorTitle",defaultMessage:"Oops!"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",title:message,iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.errorPage.tryAgainDescription ",defaultMessage:"Please click the back button and try again."}))))));var source_source=__webpack_require__(202);const RedirectToHostDetailViaIP=({match:{params:{hostIp:hostIp}},location:location})=>{const{source:source}=Object(source_source["b"])({sourceId:"default"});const{error:error,name:name}=useHostIpToName(hostIp,source&&source.configuration&&source.configuration.metricAlias||null);if(error){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.linkTo.hostWithIp.error",{defaultMessage:'Host not found with IP address "{hostIp}".',values:{hostIp:hostIp}})})}const searchString=replaceMetricTimeInQueryString(Object(query_params["b"])(location),Object(query_params["d"])(location))("");if(name){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:`/detail/host/${name}?${searchString}`})}return external_kbnSharedDeps_React_default.a.createElement(loading_page["a"],{message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.linkTo.hostWithIp.loading",{defaultMessage:'Loading host with IP address "{hostIp}".',values:{hostIp:hostIp}})})};var inventory_models=__webpack_require__(94);const ITEM_TYPES=inventory_models["c"].map(m=>m.id).join("|");const LinkToMetricsPage=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:`${props.match.url}/:nodeType(${ITEM_TYPES})-detail/:nodeId`,component:RedirectToNodeDetail}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:`${props.match.url}/host-detail-via-ip/:hostIp`,component:RedirectToHostDetailViaIP}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/"}));var document_title=__webpack_require__(113);var help_center_content=__webpack_require__(228);var routed_tabs=__webpack_require__(230);var use_metrics_explorer_options=__webpack_require__(93);var elastic_safer_lodash_set=__webpack_require__(268);var ThrowReporter=__webpack_require__(459);const WithMetricsExplorerOptionsUrlState=()=>{const{options:options,chartOptions:chartOptions,setChartOptions:setChartOptions,currentTimerange:currentTimerange,setOptions:setRawOptions,setTimeRange:setTimeRange}=Object(external_kbnSharedDeps_React_["useContext"])(use_metrics_explorer_options["c"].Context);const setOptions=value=>{setRawOptions(value)};const urlState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({options:options,chartOptions:chartOptions,timerange:currentTimerange}),[options,chartOptions,currentTimerange]);const handleChange=newUrlState=>{if(newUrlState&&newUrlState.options){setOptions(newUrlState.options)}if(newUrlState&&newUrlState.timerange){setTimeRange(newUrlState.timerange)}if(newUrlState&&newUrlState.chartOptions){setChartOptions(newUrlState.chartOptions)}};return external_kbnSharedDeps_React_default.a.createElement(url_state["a"],{urlState:urlState,urlStateKey:"metricsExplorer",mapToUrlState:mapToUrlState,onChange:handleChange,onInitialize:handleChange,populateWithInitialState:true})};function isMetricExplorerOptions(subject){const result=use_metrics_explorer_options["e"].decode(subject);try{ThrowReporter["ThrowReporter"].report(result);return true}catch(e){return false}}function isMetricExplorerChartOptions(subject){const result=use_metrics_explorer_options["f"].decode(subject);try{ThrowReporter["ThrowReporter"].report(result);return true}catch(e){return false}}function isMetricExplorerTimeOption(subject){const result=use_metrics_explorer_options["g"].decode(subject);try{ThrowReporter["ThrowReporter"].report(result);return true}catch(e){return false}}const mapToUrlState=value=>{const finalState={};if(value){if(value.options&&isMetricExplorerOptions(value.options)){value.options.source="url";Object(elastic_safer_lodash_set["set"])(finalState,"options",value.options)}if(value.timerange&&isMetricExplorerTimeOption(value.timerange)){Object(elastic_safer_lodash_set["set"])(finalState,"timerange",value.timerange)}if(value.chartOptions&&isMetricExplorerChartOptions(value.chartOptions)){Object(elastic_safer_lodash_set["set"])(finalState,"chartOptions",value.chartOptions)}return finalState}};var containers_source=__webpack_require__(88);const WithSource=({children:children})=>{const{createSourceConfiguration:createSourceConfiguration,createDerivedIndexPattern:createDerivedIndexPattern,source:source,sourceExists:sourceExists,sourceId:sourceId,metricIndicesExist:metricIndicesExist,logIndicesExist:logIndicesExist,isLoading:isLoading,loadSource:loadSource,hasFailedLoadingSource:hasFailedLoadingSource,loadSourceFailureMessage:loadSourceFailureMessage,updateSourceConfiguration:updateSourceConfiguration,version:version}=Object(external_kbnSharedDeps_React_["useContext"])(containers_source["a"].Context);return children({create:createSourceConfiguration,configuration:source&&source.configuration,createDerivedIndexPattern:createDerivedIndexPattern,exists:sourceExists,hasFailed:hasFailedLoadingSource,isLoading:isLoading,lastFailureMessage:loadSourceFailureMessage,load:loadSource,logIndicesExist:logIndicesExist,metricIndicesExist:metricIndicesExist,sourceId:sourceId,update:updateSourceConfiguration,version:version})};var observability_public_=__webpack_require__(68);var empty_states=__webpack_require__(160);var components_loading=__webpack_require__(138);var no_data=__webpack_require__(198);var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(69);var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var create_formatter_for_metric=__webpack_require__(139);var series_chart=__webpack_require__(128);var triggers_actions_context=__webpack_require__(17);var alerting_metrics=__webpack_require__(134);var use_alert_prefill=__webpack_require__(122);const AlertFlyout=props=>{const{visible:visible,setVisible:setVisible}=props;const{triggersActionsUI:triggersActionsUI}=Object(external_kbnSharedDeps_React_["useContext"])(triggers_actions_context["a"]);const onCloseFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setVisible(false),[setVisible]);const AddAlertFlyout=Object(external_kbnSharedDeps_React_["useMemo"])(()=>triggersActionsUI&&triggersActionsUI.getAddAlertFlyout({consumer:"infrastructure",onClose:onCloseFlyout,canChangeTrigger:false,alertTypeId:alerting_metrics["e"],metadata:{currentOptions:props.options,series:props.series}}),[triggersActionsUI,onCloseFlyout]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,visible&&AddAlertFlyout)};const PrefilledThresholdAlertFlyout=({onClose:onClose})=>{const{metricThresholdPrefill:metricThresholdPrefill}=Object(use_alert_prefill["b"])();const{groupBy:groupBy,filterQuery:filterQuery,metrics:metrics}=metricThresholdPrefill;return external_kbnSharedDeps_React_default.a.createElement(AlertFlyout,{options:{groupBy:groupBy,filterQuery:filterQuery,metrics:metrics},visible:true,setVisible:onClose})};var rison=__webpack_require__(23);var uuid=__webpack_require__(36);var uuid_default=__webpack_require__.n(uuid);var color_palette=__webpack_require__(91);var metric_to_format=__webpack_require__(167);var lib_lib=__webpack_require__(30);var create_metric_label=__webpack_require__(168);const TSVB_WORKAROUND_INDEX_PATTERN="metric*";const metricsExplorerMetricToTSVBMetric=metric=>{if(metric.aggregation==="rate"){const metricId=uuid_default.a.v1();const positiveOnlyId=uuid_default.a.v1();const derivativeId=uuid_default.a.v1();return[{id:metricId,type:"max",field:metric.field||void 0},{id:derivativeId,type:"derivative",field:metricId,unit:"1s"},{id:positiveOnlyId,type:"positive_only",field:derivativeId}]}else if(metric.aggregation==="p95"||metric.aggregation==="p99"){const percentileValue=metric.aggregation==="p95"?"95":"99";return[{id:uuid_default.a.v1(),type:"percentile",field:metric.field,percentiles:[{id:uuid_default.a.v1(),value:percentileValue,mode:"line",percentile:"",shade:.2}]}]}else{return[{id:uuid_default.a.v1(),type:metric.aggregation,field:metric.field||void 0}]}};const mapMetricToSeries=chartOptions=>metric=>{const format=Object(metric_to_format["a"])(metric);return{label:Object(create_metric_label["a"])(metric),axis_position:"right",chart_type:"line",color:metric.color&&Object(color_palette["b"])(metric.color)||Object(color_palette["b"])(color_palette["a"].color0),fill:chartOptions.type===use_metrics_explorer_options["b"].area?.5:0,formatter:format===lib_lib["b"].bits?lib_lib["b"].bytes:format,value_template:"rate"===metric.aggregation?"{{value}}/s":"{{value}}",id:uuid_default.a.v1(),line_width:2,metrics:metricsExplorerMetricToTSVBMetric(metric),point_size:0,separate_axis:0,split_mode:"everything",stacked:chartOptions.stack?"stacked":"none"}};const createFilterFromOptions=(options,series)=>{const filters=[];if(options.filterQuery){filters.push(options.filterQuery)}if(options.groupBy){const id=series.id.replace('"','\\"');const groupByFilters=Array.isArray(options.groupBy)?options.groupBy.map((field,index)=>{if(!series.keys){return null}const value=series.keys[index];if(!value){return null}return`${field}: "${value.replace('"','\\"')}"`}).join(" and "):`${options.groupBy} : "${id}"`;filters.push(groupByFilters)}return{language:"kuery",query:filters.join(" and ")}};const createTSVBIndexPattern=alias=>{if(alias.split(",").length>1){return TSVB_WORKAROUND_INDEX_PATTERN}return alias};const createTSVBLink=(source,options,series,timeRange,chartOptions)=>{const tsvbIndexPattern=createTSVBIndexPattern(source&&source.metricAlias||TSVB_WORKAROUND_INDEX_PATTERN);const appState={filters:[],linked:false,query:{language:"kuery",query:""},uiState:{},vis:{aggs:[],params:{axis_formatter:"number",axis_position:"left",axis_scale:"normal",id:uuid_default.a.v1(),default_index_pattern:tsvbIndexPattern,index_pattern:tsvbIndexPattern,interval:"auto",series:options.metrics.map(mapMetricToSeries(chartOptions)),show_grid:1,show_legend:1,time_field:source&&source.fields.timestamp||"@timestamp",type:"timeseries",filter:createFilterFromOptions(options,series)},title:series.id,type:"metrics"}};if(chartOptions.yAxisMode===use_metrics_explorer_options["d"].fromZero){Object(elastic_safer_lodash_set["set"])(appState,"vis.params.axis_min",0)}const globalState={refreshInterval:{pause:true,value:0},time:{from:timeRange.from,to:timeRange.to}};return{app:"visualize",hash:"/create",search:{type:"metrics",_g:Object(rison["encode"])(globalState),_a:Object(rison["encode"])(appState)}}};var use_link_props=__webpack_require__(29);const fieldToNodeType=(source,groupBy)=>{const fields=Array.isArray(groupBy)?groupBy:[groupBy];if(fields.includes(source.fields.host)){return"host"}if(fields.includes(source.fields.pod)){return"pod"}if(fields.includes(source.fields.container)){return"container"}};const dateMathExpressionToEpoch=(dateMathExpression,roundUp=false)=>{const dateObj=elastic_datemath_default.a.parse(dateMathExpression,{roundUp:roundUp});if(!dateObj)throw new Error(`"${dateMathExpression}" is not a valid time string`);return dateObj.valueOf()};const createNodeDetailLink=(nodeType,nodeId,from,to)=>getNodeDetailUrl({nodeType:nodeType,nodeId:nodeId,from:dateMathExpressionToEpoch(from),to:dateMathExpressionToEpoch(to,true)});const MetricsExplorerChartContextMenu=({onFilter:onFilter,options:options,series:series,source:source,timeRange:timeRange,uiCapabilities:uiCapabilities,chartOptions:chartOptions})=>{var _uiCapabilities$visua;const[isPopoverOpen,setPopoverState]=Object(external_kbnSharedDeps_React_["useState"])(false);const[flyoutVisible,setFlyoutVisible]=Object(external_kbnSharedDeps_React_["useState"])(false);const supportFiltering=options.groupBy!=null&&onFilter!=null;const handleFilter=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(supportFiltering&&onFilter){if(Array.isArray(options.groupBy)){onFilter(options.groupBy.map((field,index)=>{var _series$keys;return`${field}: "${(_series$keys=series.keys)===null||_series$keys===void 0?void 0:_series$keys[index]}"`}).join(" and "))}else{onFilter(`${options.groupBy}: "${series.id}"`)}}setPopoverState(false)},[supportFiltering,onFilter,options,series.keys,series.id]);const filterByItem=supportFiltering?[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.filterByLabel",{defaultMessage:"Add filter"}),icon:"metricsApp",onClick:handleFilter,"data-test-subj":"metricsExplorerAction-AddFilter"}]:[];const nodeType=source&&options.groupBy&&fieldToNodeType(source,options.groupBy);const nodeDetailLinkProps=Object(use_link_props["b"])({app:"metrics",...nodeType?createNodeDetailLink(nodeType,series.id,timeRange.from,timeRange.to):{}});const tsvbLinkProps=Object(use_link_props["b"])({...createTSVBLink(source,options,series,timeRange,chartOptions)});const viewNodeDetail=nodeType?[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.viewNodeDetail",{defaultMessage:"View metrics for {name}",values:{name:nodeType}}),icon:"metricsApp",...nodeType?nodeDetailLinkProps:{},"data-test-subj":"metricsExplorerAction-ViewNodeMetrics"}]:[];const openInVisualize=uiCapabilities!==null&&uiCapabilities!==void 0&&(_uiCapabilities$visua=uiCapabilities.visualize)!==null&&_uiCapabilities$visua!==void 0&&_uiCapabilities$visua.show?[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.openInTSVB",{defaultMessage:"Open in Visualize"}),...tsvbLinkProps,icon:"visualizeApp",disabled:options.metrics.length===0,"data-test-subj":"metricsExplorerAction-OpenInTSVB"}]:[];const itemPanels=[...filterByItem,...openInVisualize,...viewNodeDetail,{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.alerts.createAlertButton",{defaultMessage:"Create alert"}),icon:"bell",onClick(){setFlyoutVisible(true)}}];if(itemPanels.length===0)return null;const panels=[{id:0,title:"Actions",items:itemPanels}];const handleClose=()=>setPopoverState(false);const handleOpen=()=>setPopoverState(true);const actionAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.actionsLabel.aria",{defaultMessage:"Actions for {grouping}",values:{grouping:series.id}});const actionLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.actionsLabel.button",{defaultMessage:"Actions"});const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{contentProps:{"aria-label":actionAriaLabel},onClick:handleOpen,size:"s",iconType:"arrowDown",iconSide:"right"},actionLabel);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{closePopover:handleClose,id:`${series.id}-popover`,button:button,isOpen:isPopoverOpen,panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{initialPanelId:0,panels:panels}),external_kbnSharedDeps_React_default.a.createElement(AlertFlyout,{series:series,options:options,setVisible:setFlyoutVisible,visible:flyoutVisible})))};const MetricsExplorerEmptyChart=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"stats",title:external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.emptyChart.title",defaultMessage:"Chart Data Missing"})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.emptyChart.body",defaultMessage:"Unable to render chart."}))});const MetricsExplorerNoMetrics=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"stats",title:external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.noMetrics.title",defaultMessage:"Missing Metric"})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.noMetrics.body",defaultMessage:"Please choose a metric above."}))});var get_chart_theme=__webpack_require__(120);var use_kibana_ui_setting=__webpack_require__(118);var calculate_domain=__webpack_require__(130);const ALL_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.everything",{defaultMessage:"Everything"});const ChartTitle=({series:series})=>{if(series.keys!=null){const{keys:keys}=series;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs"},keys.map((name,i)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:name},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"m",color:keys.length-1>i?"subdued":"default"},external_kbnSharedDeps_React_default.a.createElement("strong",null,name==="*"?ALL_TITLE:name))),keys.length-1>i&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"m",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("span",null,"/"))))))}return external_kbnSharedDeps_React_default.a.createElement("span",null,series.id)};const MetricsExplorerChart=({source:source,options:options,chartOptions:chartOptions,series:series,title:title,onFilter:onFilter,height:height=200,width:width="100%",timeRange:timeRange,onTimeChange:onTimeChange})=>{var _useKibana$services$a;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const isDarkMode=Object(kibanaReact_public_["useUiSetting"])("theme:darkMode");const{metrics:metrics}=options;const[dateFormat]=Object(use_kibana_ui_setting["a"])("dateFormat");const handleTimeChange=({x:x})=>{if(!x){return}const[from,to]=x;onTimeChange(external_kbnSharedDeps_Moment_default()(from).toISOString(),external_kbnSharedDeps_Moment_default()(to).toISOString())};const dateFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const firstRow=Object(external_kbnSharedDeps_Lodash_["first"])(series.rows);const lastRow=Object(external_kbnSharedDeps_Lodash_["last"])(series.rows);return firstRow&&lastRow?Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])([firstRow.timestamp,lastRow.timestamp]):value=>`${value}`},[series.rows]);const tooltipProps={headerFormatter:Object(external_kbnSharedDeps_React_["useCallback"])(data=>external_kbnSharedDeps_Moment_default()(data.value).format(dateFormat||"Y-MM-DD HH:mm:ss.SSS"),[dateFormat])};const yAxisFormater=Object(external_kbnSharedDeps_React_["useCallback"])(Object(create_formatter_for_metric["a"])(Object(external_kbnSharedDeps_Lodash_["first"])(metrics)),[options]);const dataDomain=Object(calculate_domain["a"])(series,metrics,chartOptions.stack);const domain=chartOptions.yAxisMode===use_metrics_explorer_options["d"].fromZero?{...dataDomain,min:0}:dataDomain;return external_kbnSharedDeps_React_default.a.createElement("div",{style:{padding:24}},options.groupBy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(ChartTitleContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:title,anchorClassName:"metricsExplorerTitleAnchor"},external_kbnSharedDeps_React_default.a.createElement(ChartTitle,{series:series}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerChartContextMenu,{timeRange:timeRange,options:options,chartOptions:chartOptions,series:series,onFilter:onFilter,source:source,uiCapabilities:uiCapabilities})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerChartContextMenu,{options:options,chartOptions:chartOptions,series:series,source:source,timeRange:timeRange,uiCapabilities:uiCapabilities}))),external_kbnSharedDeps_React_default.a.createElement("div",{className:"infrastructureChart",style:{height:height,width:width}},metrics.length&&series.rows.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,metrics.map((metric,id)=>external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:chartOptions.type,key:id,metric:metric,id:id,series:series,stack:chartOptions.stack})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:dateFormatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:yAxisFormater,domain:domain}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{tooltip:tooltipProps,onBrushEnd:handleTimeChange,theme:Object(get_chart_theme["a"])(isDarkMode)})):options.metrics.length>0?external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerEmptyChart,null):external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerNoMetrics,null)))};const ChartTitleContainer=common_["euiStyled"].div`
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  text-align: left;
  flex: 1 1 auto;
  margin: 12px;
`;const MetricsExplorerCharts=({loading:loading,data:data,onLoadMore:onLoadMore,options:options,chartOptions:chartOptions,onRefetch:onRefetch,onFilter:onFilter,source:source,timeRange:timeRange,onTimeChange:onTimeChange})=>{if(loading){return external_kbnSharedDeps_React_default.a.createElement(components_loading["a"],{height:800,width:"100%",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.loadingCharts",{defaultMessage:"Loading charts"})})}if(!data||data.series.length===0){return external_kbnSharedDeps_React_default.a.createElement(no_data["a"],{titleText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.noDataTitle",{defaultMessage:"There is no data to display."}),bodyText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.noDataBodyText",{defaultMessage:"Try adjusting your time, filters or group by settings."}),refetchText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.noDataRefetchText",{defaultMessage:"Check for new data"}),testString:"metrics-explorer-no-data",onRefetch:onRefetch})}const and=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.andLabel",{defaultMessage:'" and "'});return external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{gutterSize:"s",columns:data.series.length===1?1:3},data.series.map(series=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:series.id,style:{minWidth:0}},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerChart,{key:`chart-${series.id}`,onFilter:onFilter,options:options,chartOptions:chartOptions,title:options.groupBy?series.id:null,height:data.series.length>1?200:400,series:series,source:source,timeRange:timeRange,onTimeChange:onTimeChange})))),data.series.length>1?external_kbnSharedDeps_React_default.a.createElement("div",{style:{textAlign:"center",marginBottom:16}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.footerPaginationMessage",defaultMessage:'Displaying {length} of {total} charts grouped by "{groupBy}".',values:{length:data.series.length,total:data.pageInfo.total,groupBy:Array.isArray(options.groupBy)?options.groupBy.join(and):options.groupBy}}))),data.pageInfo.afterKey?external_kbnSharedDeps_React_default.a.createElement("div",{style:{margin:"16px 0"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{isLoading:loading,size:"s",onClick:()=>onLoadMore(data.pageInfo.afterKey||null)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.loadMoreChartsButton",defaultMessage:"Load More Charts"}))):null):null)};var data_public_=__webpack_require__(31);var kuery_bar=__webpack_require__(169);const MetricsExplorerMetrics=({options:options,onChange:onChange,fields:fields,autoFocus:autoFocus=false})=>{const colors=Object.keys(color_palette["a"]);const[shouldFocus,setShouldFocus]=Object(external_kbnSharedDeps_React_["useState"])(autoFocus);const autoFocusInputElement=Object(external_kbnSharedDeps_React_["useCallback"])(inputElement=>{if(inputElement&&shouldFocus){inputElement.focus();setShouldFocus(false)}},[shouldFocus]);const handleChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedOptions=>{onChange(selectedOptions.map((opt,index)=>({aggregation:options.aggregation,field:opt.value,color:colors[index]})))},[onChange,options.aggregation,colors]);const comboOptions=fields.map(field=>({label:field.name,value:field.name}));const selectedOptions=options.metrics.filter(m=>m.aggregation!=="count").map(metric=>({label:metric.field||"",value:metric.field||"",color:Object(color_palette["b"])(metric.color||color_palette["a"].color0)}));const placeholderText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.metricComboBoxPlaceholder",{defaultMessage:"choose a metric to plot"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{"aria-label":placeholderText,isDisabled:options.aggregation==="count",placeholder:placeholderText,fullWidth:true,options:comboOptions,selectedOptions:selectedOptions,onChange:handleChange,isClearable:true,inputRef:autoFocusInputElement})};var group_by=__webpack_require__(205);var metrics_explorer=__webpack_require__(100);const MetricsExplorerAggregationPicker=({options:options,onChange:onChange})=>{const AGGREGATION_LABELS={["avg"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.avg",{defaultMessage:"Average"}),["sum"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.sum",{defaultMessage:"Sum"}),["max"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.max",{defaultMessage:"Max"}),["min"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.min",{defaultMessage:"Min"}),["cardinality"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.cardinality",{defaultMessage:"Cardinality"}),["rate"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.rate",{defaultMessage:"Rate"}),["p95"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.p95",{defaultMessage:"95th Percentile"}),["p99"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.p99",{defaultMessage:"99th Percentile"}),["count"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationLables.count",{defaultMessage:"Document count"})};const handleChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const aggregation=metrics_explorer["c"].is(e.target.value)&&e.target.value||"avg";onChange(aggregation)},[onChange]);const placeholder=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.aggregationSelectLabel",{defaultMessage:"Select an aggregation"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"aria-label":placeholder,placeholder:placeholder,fullWidth:true,value:options.aggregation,options:metrics_explorer["a"].map(k=>({text:AGGREGATION_LABELS[k],value:k})),onChange:handleChange})};const MetricsExplorerChartOptions=({chartOptions:chartOptions,onChange:onChange})=>{const[isPopoverOpen,setPopoverState]=Object(external_kbnSharedDeps_React_["useState"])(false);const handleClosePopover=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setPopoverState(false)},[]);const handleOpenPopover=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setPopoverState(true)},[]);const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconSide:"left",iconType:"eye",onClick:handleOpenPopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.customizeChartOptions",defaultMessage:"Customize"}));const yAxisRadios=[{id:use_metrics_explorer_options["d"].auto,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.autoLabel",{defaultMessage:"Automatic (min to max)"})},{id:use_metrics_explorer_options["d"].fromZero,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.fromZeroLabel",{defaultMessage:"From zero (0 to max)"})}];const typeRadios=[{id:use_metrics_explorer_options["b"].line,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.lineLabel",{defaultMessage:"Line"})},{id:use_metrics_explorer_options["b"].area,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.areaLabel",{defaultMessage:"Area"})},{id:use_metrics_explorer_options["b"].bar,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.barLabel",{defaultMessage:"Bar"})}];const handleYAxisChange=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{onChange({...chartOptions,yAxisMode:id})},[chartOptions,onChange]);const handleTypeChange=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{onChange({...chartOptions,type:id})},[chartOptions,onChange]);const handleStackChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{onChange({...chartOptions,stack:e.target.checked})},[chartOptions,onChange]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"MetricExplorerChartOptionsPopover",button:button,isOpen:isPopoverOpen,closePopover:handleClosePopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.typeLabel",{defaultMessage:"Chart style"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{compressed:true,options:typeRadios,idSelected:chartOptions.type,onChange:handleTypeChange})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.stackLabel",{defaultMessage:"Stack series"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.stackSwitchLabel",{defaultMessage:"Stack"}),checked:chartOptions.stack,onChange:handleStackChange})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.chartOptions.yAxisDomainLabel",{defaultMessage:"Y Axis Domain"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{compressed:true,options:yAxisRadios,idSelected:chartOptions.yAxisMode,onChange:handleYAxisChange}))))};const SavedViewCreateModal=({close:close,save:save,isInvalid:isInvalid})=>{const[viewName,setViewName]=Object(external_kbnSharedDeps_React_["useState"])("");const[includeTime,setIncludeTime]=Object(external_kbnSharedDeps_React_["useState"])(false);const onCheckChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>setIncludeTime(e.target.checked),[]);const textChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>setViewName(e.target.value),[]);const saveView=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{save(viewName,includeTime)},[includeTime,save,viewName]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Save View",id:"xpack.infra.waffle.savedView.createHeader"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{isInvalid:isInvalid,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"}),"data-test-subj":"savedViewViweName",value:viewName,onChange:textChange,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xl"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{id:"saved-view-save-time-checkbox",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Store time with view",id:"xpack.infra.waffle.savedViews.includeTimeFilterLabel"}),checked:includeTime,onChange:onCheckChange}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",grow:false,style:{maxWidth:400}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"This changes the time filter to the currently selected time each time the view is loaded",id:"xpack.infra.waffle.savedViews.includeTimeHelpText"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Cancel",id:"xpack.infra.waffle.savedViews.cancelButton"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",disabled:!viewName,fill:true,onClick:saveView,"data-test-subj":"createSavedViewButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Save",id:"xpack.infra.waffle.savedViews.saveButton"}))))};function SavedViewUpdateModal({close:close,save:save,isInvalid:isInvalid,currentView:currentView}){const[viewName,setViewName]=Object(external_kbnSharedDeps_React_["useState"])(currentView.name);const[includeTime,setIncludeTime]=Object(external_kbnSharedDeps_React_["useState"])(false);const onCheckChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>setIncludeTime(e.target.checked),[]);const textChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>setViewName(e.target.value),[]);const saveView=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{save(viewName,includeTime)},[includeTime,save,viewName]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Update View",id:"xpack.infra.waffle.savedView.updateHeader"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{isInvalid:isInvalid,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"}),"data-test-subj":"savedViewViweName",value:viewName,onChange:textChange,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.savedViews.viewNamePlaceholder",{defaultMessage:"Name"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xl"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{id:"saved-view-save-time-checkbox",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Store time with view",id:"xpack.infra.waffle.savedViews.includeTimeFilterLabel"}),checked:includeTime,onChange:onCheckChange}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",grow:false,style:{maxWidth:400}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"This changes the time filter to the currently selected time each time the view is loaded",id:"xpack.infra.waffle.savedViews.includeTimeHelpText"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Cancel",id:"xpack.infra.waffle.savedViews.cancelButton"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",disabled:!viewName,fill:true,onClick:saveView,"data-test-subj":"updateSavedViewButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Save",id:"xpack.infra.waffle.savedViews.saveButton"}))))}const DeleteConfimation=props=>{const[confirmVisible,setConfirmVisible]=Object(external_kbnSharedDeps_React_["useState"])(false);const showConfirm=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setConfirmVisible(true),[]);const hideConfirm=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setConfirmVisible(false),[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,confirmVisible&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:hideConfirm,"data-test-subj":"hideConfirm"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"cancel",id:"xpack.infra.waffle.savedViews.cancel"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{disabled:props.isDisabled,fill:true,iconType:"trash",color:"danger",onClick:props.confirmedAction,"data-test-subj":"showConfirm"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Delete view?",id:"xpack.infra.openView.actionNames.deleteConfirmation"}))),!confirmVisible&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"trash",color:"danger",onClick:showConfirm}))};function SavedViewManageViewsFlyout({close:close,views:views,defaultViewId:defaultViewId,setView:setView,makeDefault:makeDefault,deleteView:deleteView,loading:loading,sourceIsLoading:sourceIsLoading}){const[inProgressView,setInProgressView]=Object(external_kbnSharedDeps_React_["useState"])(null);const renderName=Object(external_kbnSharedDeps_React_["useCallback"])((name,item)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>{setView(item);close()}},name),[setView,close]);const renderDeleteAction=Object(external_kbnSharedDeps_React_["useCallback"])(item=>{if(item.id==="0"){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null)}return external_kbnSharedDeps_React_default.a.createElement(DeleteConfimation,{isDisabled:item.isDefault,confirmedAction:()=>{deleteView(item.id)}})},[deleteView]);const renderMakeDefaultAction=Object(external_kbnSharedDeps_React_["useCallback"])(item=>{const isDefault=item.id===defaultViewId;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{isLoading:inProgressView===item.id&&sourceIsLoading,iconType:isDefault?"starFilled":"starEmpty",onClick:()=>{setInProgressView(item.id);makeDefault(item.id)}}))},[makeDefault,defaultViewId,sourceIsLoading,inProgressView]);const columns=[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.openView.columnNames.name",{defaultMessage:"Name"}),sortable:true,truncateText:true,render:renderName},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.openView.columnNames.actions",{defaultMessage:"Actions"}),actions:[{available:()=>true,render:renderMakeDefaultAction},{available:item=>true,render:renderDeleteAction}]}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:close,"data-test-subj":"loadViewsFlyout"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Manage saved views",id:"xpack.infra.openView.flyoutHeader"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{items:views,columns:columns,loading:loading,search:true,pagination:true,sorting:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"cancelSavedViewModal",onClick:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Cancel",id:"xpack.infra.openView.cancelButton"})))))}const useFindSavedObject=type=>{const kibana=Object(kibanaReact_public_["useKibana"])();const[data,setData]=Object(external_kbnSharedDeps_React_["useState"])(null);const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const find=Object(external_kbnSharedDeps_React_["useCallback"])((query,searchFields=[])=>{setLoading(true);const fetchData=async()=>{try{var _kibana$services$save;const savedObjectsClient=(_kibana$services$save=kibana.services.savedObjects)===null||_kibana$services$save===void 0?void 0:_kibana$services$save.client;if(!savedObjectsClient){throw new Error("Saved objects client is unavailable")}const d=await savedObjectsClient.find({type:type,search:query,searchFields:searchFields});setError(null);setLoading(false);setData(d)}catch(e){setLoading(false);setError(e)}};fetchData()},[type,kibana.services.savedObjects]);const hasView=async name=>{var _kibana$services$save2;const savedObjectsClient=(_kibana$services$save2=kibana.services.savedObjects)===null||_kibana$services$save2===void 0?void 0:_kibana$services$save2.client;if(!savedObjectsClient){throw new Error("Saved objects client is unavailable")}const objects=await savedObjectsClient.find({type:type});return objects.savedObjects.find(o=>o.attributes.name===name)};return{hasView:hasView,data:data,loading:loading,error:error,find:find}};const useCreateSavedObject=type=>{const kibana=Object(kibanaReact_public_["useKibana"])();const[data,setData]=Object(external_kbnSharedDeps_React_["useState"])(null);const[createdId,setCreatedId]=Object(external_kbnSharedDeps_React_["useState"])(null);const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const create=Object(external_kbnSharedDeps_React_["useCallback"])((attributes,options)=>{setLoading(true);const save=async()=>{try{var _kibana$services$save;const savedObjectsClient=(_kibana$services$save=kibana.services.savedObjects)===null||_kibana$services$save===void 0?void 0:_kibana$services$save.client;if(!savedObjectsClient){throw new Error("Saved objects client is unavailable")}const d=await savedObjectsClient.create(type,attributes,options);setCreatedId(d.id);setError(null);setData(d);setLoading(false)}catch(e){setLoading(false);setError(e)}};save()},[type,kibana.services.savedObjects]);return{data:data,loading:loading,error:error,create:create,createdId:createdId}};const useDeleteSavedObject=type=>{const kibana=Object(kibanaReact_public_["useKibana"])();const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[deletedId,setDeletedId]=Object(external_kbnSharedDeps_React_["useState"])(null);const deleteObject=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{setLoading(true);const dobj=async()=>{try{var _kibana$services$save;await((_kibana$services$save=kibana.services.savedObjects)===null||_kibana$services$save===void 0?void 0:_kibana$services$save.client.delete(type,id));setError(null);setDeletedId(id);setLoading(false)}catch(e){setLoading(false);setError(e)}};dobj()},[type,kibana.services.savedObjects]);return{loading:loading,error:error,deleteObject:deleteObject,deletedId:deletedId}};var source_configuration_form_state=__webpack_require__(289);const useGetSavedObject=type=>{const kibana=Object(kibanaReact_public_["useKibana"])();const[data,setData]=Object(external_kbnSharedDeps_React_["useState"])(null);const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const getObject=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{setLoading(true);const fetchData=async()=>{try{var _kibana$services$save;const savedObjectsClient=(_kibana$services$save=kibana.services.savedObjects)===null||_kibana$services$save===void 0?void 0:_kibana$services$save.client;if(!savedObjectsClient){throw new Error("Saved objects client is unavailable")}const d=await savedObjectsClient.get(type,id);setError(null);setLoading(false);setData(d)}catch(e){setLoading(false);setError(e)}};fetchData()},[type,kibana.services.savedObjects]);return{data:data,loading:loading,error:error,getObject:getObject}};const useUpdateSavedObject=type=>{const kibana=Object(kibanaReact_public_["useKibana"])();const[data,setData]=Object(external_kbnSharedDeps_React_["useState"])(null);const[updatedId,setUpdatedId]=Object(external_kbnSharedDeps_React_["useState"])(null);const[error,setError]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loading,setLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const update=Object(external_kbnSharedDeps_React_["useCallback"])((id,attributes,options)=>{setLoading(true);const save=async()=>{try{var _kibana$services$save;const savedObjectsClient=(_kibana$services$save=kibana.services.savedObjects)===null||_kibana$services$save===void 0?void 0:_kibana$services$save.client;if(!savedObjectsClient){throw new Error("Saved objects client is unavailable")}const d=await savedObjectsClient.update(type,id,attributes,options);setUpdatedId(d.id);setError(null);setData(d);setLoading(false)}catch(e){setLoading(false);setError(e)}};save()},[type,kibana.services.savedObjects]);return{data:data,loading:loading,error:error,update:update,updatedId:updatedId}};const savedViewUrlStateRT=lib["type"]({viewId:lib["string"]});const DEFAULT_SAVED_VIEW_STATE={viewId:"0"};const useSavedView=props=>{const{source:source,isLoading:sourceIsLoading,sourceExists:sourceExists,createSourceConfiguration:createSourceConfiguration,updateSourceConfiguration:updateSourceConfiguration}=Object(external_kbnSharedDeps_React_["useContext"])(containers_source["a"].Context);const{viewType:viewType,defaultViewState:defaultViewState}=props;const{data:data,loading:loading,find:find,error:errorOnFind,hasView:hasView}=useFindSavedObject(viewType);const[urlState,setUrlState]=Object(use_url_state["b"])({defaultState:DEFAULT_SAVED_VIEW_STATE,decodeUrlState:saved_view_decodeUrlState,encodeUrlState:saved_view_encodeUrlState,urlStateKey:"savedView"});const[shouldLoadDefault]=Object(external_kbnSharedDeps_React_["useState"])(props.shouldLoadDefault);const[currentView,setCurrentView]=Object(external_kbnSharedDeps_React_["useState"])(null);const[loadingDefaultView,setLoadingDefaultView]=Object(external_kbnSharedDeps_React_["useState"])(null);const{create:create,error:errorOnCreate,data:createdViewData,createdId:createdId}=useCreateSavedObject(viewType);const{update:update,error:errorOnUpdate,data:updatedViewData,updatedId:updatedId}=useUpdateSavedObject(viewType);const{deleteObject:deleteObject,deletedId:deletedId}=useDeleteSavedObject(viewType);const{getObject:getObject,data:currentViewSavedObject}=useGetSavedObject(viewType);const[createError,setCreateError]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>setCreateError(errorOnCreate),[errorOnCreate]);const deleteView=Object(external_kbnSharedDeps_React_["useCallback"])(id=>deleteObject(id),[deleteObject]);const formState=Object(source_configuration_form_state["a"])(source&&source.configuration);const defaultViewFieldName=Object(external_kbnSharedDeps_React_["useMemo"])(()=>viewType==="inventory-view"?"inventoryDefaultView":"metricsExplorerDefaultView",[viewType]);const makeDefault=Object(external_kbnSharedDeps_React_["useCallback"])(async id=>{if(sourceExists){await updateSourceConfiguration({...formState.formStateChanges,[defaultViewFieldName]:id})}else{await createSourceConfiguration({...formState.formState,[defaultViewFieldName]:id})}},[formState.formState,formState.formStateChanges,sourceExists,defaultViewFieldName,createSourceConfiguration,updateSourceConfiguration]);const saveView=Object(external_kbnSharedDeps_React_["useCallback"])(d=>{const doSave=async()=>{const exists=await hasView(d.name);if(exists){setCreateError(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.errorOnCreate.duplicateViewName",{defaultMessage:`A view with that name already exists.`}));return}create(d)};setCreateError(null);doSave()},[create,hasView]);const updateView=Object(external_kbnSharedDeps_React_["useCallback"])((id,d)=>{const doSave=async()=>{const view=await hasView(d.name);if(view&&view.id!==id){setCreateError(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.errorOnCreate.duplicateViewName",{defaultMessage:`A view with that name already exists.`}));return}update(id,d)};setCreateError(null);doSave()},[update,hasView]);const defaultViewId=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!source||!source.configuration){return""}if(defaultViewFieldName==="inventoryDefaultView"){return source.configuration.inventoryDefaultView}else if(defaultViewFieldName==="metricsExplorerDefaultView"){return source.configuration.metricsExplorerDefaultView}else{return""}},[source,defaultViewFieldName]);const mapToView=Object(external_kbnSharedDeps_React_["useCallback"])(o=>({...o.attributes,id:o.id,isDefault:defaultViewId===o.id}),[defaultViewId]);const savedObjects=Object(external_kbnSharedDeps_React_["useMemo"])(()=>data?data.savedObjects:[],[data]);const views=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const items=[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.defaultViewNameHosts",{defaultMessage:"Default view"}),id:"0",isDefault:!defaultViewId||defaultViewId==="0",...defaultViewState}];savedObjects.forEach(o=>o.type===viewType&&items.push(mapToView(o)));return items},[defaultViewState,savedObjects,viewType,defaultViewId,mapToView]);const createdView=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createdViewData?mapToView(createdViewData):null,[createdViewData,mapToView]);const updatedView=Object(external_kbnSharedDeps_React_["useMemo"])(()=>updatedViewData?mapToView(updatedViewData):null,[updatedViewData,mapToView]);const loadDefaultView=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setLoadingDefaultView(true);getObject(defaultViewId)},[setLoadingDefaultView,getObject,defaultViewId]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentViewSavedObject){setCurrentView(mapToView(currentViewSavedObject));setLoadingDefaultView(false)}},[currentViewSavedObject,defaultViewId,mapToView]);const setDefault=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setCurrentView({name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.defaultViewNameHosts",{defaultMessage:"Default view"}),id:"0",isDefault:!defaultViewId||defaultViewId==="0",...defaultViewState})},[setCurrentView,defaultViewId,defaultViewState]);const loadDefaultViewIfSet=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(defaultViewId!=="0"){loadDefaultView()}else{setDefault();setLoadingDefaultView(false)}},[defaultViewId,loadDefaultView,setDefault,setLoadingDefaultView]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(loadingDefaultView||currentView||!shouldLoadDefault){return}loadDefaultViewIfSet()},[loadDefaultViewIfSet,loadingDefaultView,currentView,shouldLoadDefault]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentView&&urlState.viewId!==currentView.id&&data)setUrlState({viewId:currentView.id})},[urlState,setUrlState,currentView,defaultViewId,data]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!currentView&&!loading&&data){const viewToSet=views.find(v=>v.id===urlState.viewId);if(viewToSet)setCurrentView(viewToSet);else loadDefaultViewIfSet()}},[loading,currentView,data,views,setCurrentView,loadDefaultViewIfSet,urlState.viewId]);return{views:views,saveView:saveView,defaultViewId:defaultViewId,loading:loading,updateView:updateView,updatedView:updatedView,updatedId:updatedId,deletedId:deletedId,createdId:createdId,createdView:createdView,errorOnUpdate:errorOnUpdate,errorOnFind:errorOnFind,errorOnCreate:createError,shouldLoadDefault:shouldLoadDefault,makeDefault:makeDefault,sourceIsLoading:sourceIsLoading,deleteView:deleteView,loadingDefaultView:loadingDefaultView,setCurrentView:setCurrentView,currentView:currentView,loadDefaultView:loadDefaultView,find:find}};const SavedView=constate_cjs_default()(useSavedView);const[SavedViewProvider,useSavedViewContext]=SavedView;const saved_view_encodeUrlState=state=>savedViewUrlStateRT.encode(state);const saved_view_decodeUrlState=value=>{const state=Object(pipeable["pipe"])(savedViewUrlStateRT.decode(value),Object(Either["fold"])(Object(lib_function["constant"])(undefined),lib_function["identity"]));return state};function SavedViewListModal({close:close,views:views,setView:setView,currentView:currentView}){const[options,setOptions]=Object(external_kbnSharedDeps_React_["useState"])(null);const onChange=Object(external_kbnSharedDeps_React_["useCallback"])(opts=>{setOptions(opts)},[]);const loadView=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(!options){close();return}const selected=options.find(o=>o.checked);if(!selected){close();return}setView(views.find(v=>v.id===selected.key));close()},[options,views,setView,close]);const defaultOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>views.map(v=>({label:v.name,key:v.id,checked:(currentView===null||currentView===void 0?void 0:currentView.id)===v.id?"on":undefined})),[views,currentView]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Select a view to load",id:"xpack.infra.waffle.savedView.selectViewHeader"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],{singleSelection:true,searchable:true,options:options||defaultOptions,onChange:onChange,searchProps:{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.searchPlaceholder",{defaultMessage:"Search for saved views"})},listProps:{bordered:true}},(list,search)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,search,external_kbnSharedDeps_React_default.a.createElement("div",{style:{marginTop:20}},list)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{"data-test-subj":"cancelSavedViewModal",onClick:close},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Cancel",id:"xpack.infra.openView.cancelButton"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,color:"primary","data-test-subj":"loadSavedViewModal",onClick:loadView},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Load view",id:"xpack.infra.openView.loadButton"}))))}function SavedViewsToolbarControls(props){const kibana=Object(kibanaReact_public_["useKibana"])();const{views:views,saveView:saveView,loading:loading,updateView:updateView,deletedId:deletedId,deleteView:deleteView,defaultViewId:defaultViewId,makeDefault:makeDefault,sourceIsLoading:sourceIsLoading,find:find,errorOnFind:errorOnFind,errorOnCreate:errorOnCreate,createdView:createdView,updatedView:updatedView,currentView:currentView,setCurrentView:setCurrentView}=useSavedViewContext();const[modalOpen,setModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[viewListModalOpen,setViewListModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isInvalid,setIsInvalid]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isSavedViewMenuOpen,setIsSavedViewMenuOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[createModalOpen,setCreateModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[updateModalOpen,setUpdateModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const hideSavedViewMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsSavedViewMenuOpen(false)},[setIsSavedViewMenuOpen]);const openViewListModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{hideSavedViewMenu();find();setViewListModalOpen(true)},[setViewListModalOpen,find,hideSavedViewMenu]);const closeViewListModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setViewListModalOpen(false)},[setViewListModalOpen]);const openSaveModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{hideSavedViewMenu();setIsInvalid(false);setCreateModalOpen(true)},[hideSavedViewMenu]);const openUpdateModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{hideSavedViewMenu();setIsInvalid(false);setUpdateModalOpen(true)},[hideSavedViewMenu]);const closeModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setModalOpen(false),[]);const closeCreateModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setCreateModalOpen(false),[]);const closeUpdateModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setUpdateModalOpen(false),[]);const loadViews=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{hideSavedViewMenu();find();setModalOpen(true)},[find,hideSavedViewMenu]);const showSavedViewMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsSavedViewMenuOpen(true)},[setIsSavedViewMenuOpen]);const save=Object(external_kbnSharedDeps_React_["useCallback"])((name,hasTime=false)=>{const currentState={...props.viewState,...!hasTime?{time:undefined}:{}};saveView({...currentState,name:name})},[props.viewState,saveView]);const update=Object(external_kbnSharedDeps_React_["useCallback"])((name,hasTime=false)=>{const currentState={...props.viewState,...!hasTime?{time:undefined}:{}};updateView(currentView.id,{...currentState,name:name})},[props.viewState,updateView,currentView]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(errorOnCreate){setIsInvalid(true)}},[errorOnCreate]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(updatedView!==undefined){setCurrentView(updatedView);closeUpdateModal()}},[updatedView,setCurrentView,closeUpdateModal]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(createdView!==undefined){setCurrentView(createdView);closeCreateModal()}},[createdView,setCurrentView,closeCreateModal]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(deletedId!==undefined){find()}},[deletedId,find]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(errorOnCreate){kibana.notifications.toasts.warning(getErrorToast("create",errorOnCreate))}else if(errorOnFind){kibana.notifications.toasts.warning(getErrorToast("find",errorOnFind))}},[errorOnCreate,errorOnFind,kibana]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{style:{cursor:"pointer"},compressed:true,onClick:showSavedViewMenu},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Current view",id:"xpack.infra.savedView.currentView"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,currentView?currentView.name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.unknownView",{defaultMessage:"No view selected"})))))),isOpen:isSavedViewMenuOpen,closePopover:hideSavedViewMenu,anchorPosition:"upCenter"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroup"],{flush:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroupItem"],{iconType:"indexSettings",onClick:loadViews,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.manageViews",{defaultMessage:"Manage views"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroupItem"],{iconType:"refresh",onClick:openUpdateModal,disabled:!currentView||currentView.id==="0",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.updateView",{defaultMessage:"Update view"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroupItem"],{iconType:"importAction",onClick:openViewListModal,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.loadView",{defaultMessage:"Load view"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiListGroupItem"],{iconType:"save",onClick:openSaveModal,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.saveNewView",{defaultMessage:"Save new view"})})))),createModalOpen&&external_kbnSharedDeps_React_default.a.createElement(SavedViewCreateModal,{isInvalid:isInvalid,close:closeCreateModal,save:save}),updateModalOpen&&external_kbnSharedDeps_React_default.a.createElement(SavedViewUpdateModal,{currentView:currentView,isInvalid:isInvalid,close:closeUpdateModal,save:update}),viewListModalOpen&&external_kbnSharedDeps_React_default.a.createElement(SavedViewListModal,{currentView:currentView,views:views,close:closeViewListModal,setView:setCurrentView}),modalOpen&&external_kbnSharedDeps_React_default.a.createElement(SavedViewManageViewsFlyout,{sourceIsLoading:sourceIsLoading,loading:loading,views:views,defaultViewId:defaultViewId,makeDefault:makeDefault,deleteView:deleteView,close:closeModal,setView:setCurrentView}))}const getErrorToast=(type,msg)=>{if(type==="create"){return{toastLifeTimeMs:3e3,title:msg||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.errorOnCreate.title",{defaultMessage:`An error occured saving view.`})}}else if(type==="find"){return{toastLifeTimeMs:3e3,title:msg||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.savedView.findError.title",{defaultMessage:`An error occurred while loading views.`})}}};const mapKibanaQuickRangesToDatePickerRanges=timepickerQuickRanges=>timepickerQuickRanges?timepickerQuickRanges.map(r=>({start:r.from,end:r.to,label:r.display})):[];const ToolbarPanel=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).attrs(()=>({grow:false,paddingSize:"none"}))`
  border-top: none;
  border-right: none;
  border-left: none;
  border-radius: 0;
  padding: ${props=>`12px ${props.theme.eui.paddingSizes.m}`};
`;const MetricsExplorerToolbar=({timeRange:timeRange,derivedIndexPattern:derivedIndexPattern,options:options,onTimeChange:onTimeChange,onRefresh:onRefresh,onGroupByChange:onGroupByChange,onFilterQuerySubmit:onFilterQuerySubmit,onMetricsChange:onMetricsChange,onAggregationChange:onAggregationChange,chartOptions:chartOptions,onChartOptionsChange:onChartOptionsChange})=>{const isDefaultOptions=options.aggregation==="avg"&&options.metrics.length===0;const[timepickerQuickRanges]=Object(use_kibana_ui_setting["a"])(data_public_["UI_SETTINGS"].TIMEPICKER_QUICK_RANGES);const commonlyUsedRanges=mapKibanaQuickRangesToDatePickerRanges(timepickerQuickRanges);return external_kbnSharedDeps_React_default.a.createElement(ToolbarPanel,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:options.aggregation==="count"?2:false},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerAggregationPicker,{fullWidth:true,options:options,onChange:onAggregationChange})),options.aggregation!=="count"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.aggregationLabel",defaultMessage:"of"})),options.aggregation!=="count"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerMetrics,{autoFocus:isDefaultOptions,fields:derivedIndexPattern.fields,options:options,onChange:onMetricsChange})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metricsExplorer.groupByToolbarLabel",defaultMessage:"graph per"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(group_by["a"],{onChange:onGroupByChange,fields:derivedIndexPattern.fields,options:options}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(kuery_bar["a"],{derivedIndexPattern:derivedIndexPattern,onSubmit:onFilterQuerySubmit,value:options.filterQuery})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerChartOptions,{onChange:onChartOptionsChange,chartOptions:chartOptions})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(SavedViewsToolbarControls,{viewState:{options:options,chartOptions:chartOptions,currentTimerange:timeRange}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{marginRight:5}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{start:timeRange.from,end:timeRange.to,onTimeChange:({start:start,end:end})=>onTimeChange(start,end),onRefresh:onRefresh,commonlyUsedRanges:commonlyUsedRanges}))))};var use_metrics_explorer_data=__webpack_require__(206);const useMetricsExplorerState=(source,derivedIndexPattern,shouldLoadImmediately=true)=>{const[refreshSignal,setRefreshSignal]=Object(external_kbnSharedDeps_React_["useState"])(0);const[afterKey,setAfterKey]=Object(external_kbnSharedDeps_React_["useState"])(null);const{defaultViewState:defaultViewState,options:options,currentTimerange:currentTimerange,chartOptions:chartOptions,setChartOptions:setChartOptions,setTimeRange:setTimeRange,setOptions:setOptions}=Object(external_kbnSharedDeps_React_["useContext"])(use_metrics_explorer_options["c"].Context);const{loading:loading,error:error,data:data,loadData:loadData}=Object(use_metrics_explorer_data["a"])(options,source,derivedIndexPattern,currentTimerange,afterKey,refreshSignal,shouldLoadImmediately);const handleRefresh=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setAfterKey(null);setRefreshSignal(refreshSignal+1)},[refreshSignal]);const handleTimeChange=Object(external_kbnSharedDeps_React_["useCallback"])((start,end)=>{setAfterKey(null);setTimeRange({...currentTimerange,from:start,to:end})},[currentTimerange,setTimeRange]);const handleGroupByChange=Object(external_kbnSharedDeps_React_["useCallback"])(groupBy=>{setAfterKey(null);setOptions({...options,groupBy:groupBy||void 0})},[options,setOptions]);const handleFilterQuerySubmit=Object(external_kbnSharedDeps_React_["useCallback"])(query=>{setAfterKey(null);setOptions({...options,filterQuery:query})},[options,setOptions]);const handleMetricsChange=Object(external_kbnSharedDeps_React_["useCallback"])(metrics=>{setAfterKey(null);setOptions({...options,metrics:metrics})},[options,setOptions]);const handleAggregationChange=Object(external_kbnSharedDeps_React_["useCallback"])(aggregation=>{setAfterKey(null);const metrics=aggregation==="count"?[{aggregation:aggregation}]:options.metrics.filter(metric=>metric.aggregation!=="count").map(metric=>({...metric,aggregation:aggregation}));setOptions({...options,aggregation:aggregation,metrics:metrics})},[options,setOptions]);const onViewStateChange=Object(external_kbnSharedDeps_React_["useCallback"])(vs=>{if(vs.chartOptions){setChartOptions(vs.chartOptions)}if(vs.currentTimerange){if(vs.id!=="0"){setTimeRange(vs.currentTimerange)}}if(vs.options){setOptions(vs.options)}},[setChartOptions,setOptions,setTimeRange]);return{loading:loading,error:error,data:data,currentTimerange:currentTimerange,options:options,chartOptions:chartOptions,setChartOptions:setChartOptions,handleAggregationChange:handleAggregationChange,handleMetricsChange:handleMetricsChange,handleFilterQuerySubmit:handleFilterQuerySubmit,handleGroupByChange:handleGroupByChange,handleTimeChange:handleTimeChange,handleRefresh:handleRefresh,handleLoadMore:setAfterKey,defaultViewState:defaultViewState,onViewStateChange:onViewStateChange,loadData:loadData,refreshSignal:refreshSignal,afterKey:afterKey}};const MetricsExplorerPage=({source:source,derivedIndexPattern:derivedIndexPattern})=>{const{loading:loading,error:error,data:data,currentTimerange:currentTimerange,options:options,chartOptions:chartOptions,setChartOptions:setChartOptions,handleAggregationChange:handleAggregationChange,handleMetricsChange:handleMetricsChange,handleFilterQuerySubmit:handleFilterQuerySubmit,handleGroupByChange:handleGroupByChange,handleTimeChange:handleTimeChange,handleRefresh:handleRefresh,handleLoadMore:handleLoadMore,onViewStateChange:onViewStateChange,loadData:loadData}=useMetricsExplorerState(source,derivedIndexPattern,false);const{currentView:currentView,shouldLoadDefault:shouldLoadDefault}=useSavedViewContext();Object(observability_public_["useTrackPageview"])({app:"infra_metrics",path:"metrics_explorer"});Object(observability_public_["useTrackPageview"])({app:"infra_metrics",path:"metrics_explorer",delay:15e3});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentView){onViewStateChange(currentView)}},[currentView,onViewStateChange]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentView!=null||!shouldLoadDefault){loadData()}},[loadData,shouldLoadDefault]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:previousTitle=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.infrastructureMetricsExplorerPage.documentTitle",{defaultMessage:"{previousTitle} | Metrics Explorer",values:{previousTitle:previousTitle}})}),external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerToolbar,{derivedIndexPattern:derivedIndexPattern,timeRange:currentTimerange,options:options,chartOptions:chartOptions,onRefresh:handleRefresh,onTimeChange:handleTimeChange,onGroupByChange:handleGroupByChange,onFilterQuerySubmit:handleFilterQuerySubmit,onMetricsChange:handleMetricsChange,onAggregationChange:handleAggregationChange,onChartOptionsChange:setChartOptions}),error?external_kbnSharedDeps_React_default.a.createElement(empty_states["a"],{titleText:"Whoops!",bodyText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.errorMessage",{defaultMessage:'It looks like the request failed with "{message}"',values:{message:error.message}}),onRefetch:handleRefresh,refetchText:"Try Again"}):external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerCharts,{timeRange:currentTimerange,loading:loading,data:data,source:source,options:options,chartOptions:chartOptions,onLoadMore:handleLoadMore,onFilter:handleFilterQuerySubmit,onRefetch:handleRefresh,onTimeChange:handleTimeChange}))};var use_kibana_timefilter_time=__webpack_require__(111);const DEFAULT_WAFFLE_TIME_STATE={currentTime:Date.now(),isAutoReloading:false};const useWaffleTime=()=>{const[getTime]=Object(use_kibana_timefilter_time["a"])({from:"now",to:"now"});const kibanaTime=elastic_datemath_default.a.parse(getTime().to);const[urlState,setUrlState]=Object(use_url_state["b"])({defaultState:{...DEFAULT_WAFFLE_TIME_STATE,currentTime:kibanaTime?kibanaTime.toDate().getTime():Date.now()},decodeUrlState:use_waffle_time_decodeUrlState,encodeUrlState:use_waffle_time_encodeUrlState,urlStateKey:"waffleTime"});const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])(urlState);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setUrlState(state)},[setUrlState,state]);const{currentTime:currentTime,isAutoReloading:isAutoReloading}=urlState;const startAutoReload=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setState(previous=>({...previous,isAutoReloading:true}))},[setState]);const stopAutoReload=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setState(previous=>({...previous,isAutoReloading:false}))},[setState]);const jumpToTime=Object(external_kbnSharedDeps_React_["useCallback"])(time=>{setState(previous=>({...previous,currentTime:time}))},[setState]);const currentTimeRange={from:currentTime-1e3*60*5,interval:"1m",to:currentTime};return{currentTime:currentTime,currentTimeRange:currentTimeRange,isAutoReloading:isAutoReloading,startAutoReload:startAutoReload,stopAutoReload:stopAutoReload,jumpToTime:jumpToTime,setWaffleTimeState:setState}};const WaffleTimeStateRT=lib["type"]({currentTime:lib["number"],isAutoReloading:lib["boolean"]});const use_waffle_time_encodeUrlState=WaffleTimeStateRT.encode;const use_waffle_time_decodeUrlState=value=>Object(pipeable["pipe"])(WaffleTimeStateRT.decode(value),Object(Either["fold"])(Object(lib_function["constant"])(undefined),lib_function["identity"]));const WaffleTime=constate_cjs_default()(useWaffleTime);const[WaffleTimeProvider,useWaffleTimeContext]=WaffleTime;const WaffleTimeControls=Object(common_["withTheme"])(({theme:theme})=>{const{currentTime:currentTime,isAutoReloading:isAutoReloading,startAutoReload:startAutoReload,stopAutoReload:stopAutoReload,jumpToTime:jumpToTime}=useWaffleTimeContext();const currentMoment=external_kbnSharedDeps_Moment_default()(currentTime);const liveStreamingButton=isAutoReloading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",iconSide:"left",iconType:"pause",onClick:stopAutoReload},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.waffleTime.stopRefreshingButtonLabel",defaultMessage:"Stop refreshing"})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconSide:"left",iconType:"play",onClick:startAutoReload},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.waffleTime.autoRefreshButtonLabel",defaultMessage:"Auto-refresh"}));const handleChangeDate=Object(external_kbnSharedDeps_React_["useCallback"])(time=>{if(time){jumpToTime(time.valueOf())}},[jumpToTime]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{border:theme===null||theme===void 0?void 0:theme.eui.euiFormInputGroupBorder,boxShadow:`0px 3px 2px ${theme===null||theme===void 0?void 0:theme.eui.euiTableActionsBorderColor}, 0px 1px 1px ${theme===null||theme===void 0?void 0:theme.eui.euiTableActionsBorderColor}`,marginRight:theme===null||theme===void 0?void 0:theme.eui.paddingSizes.m},"data-test-subj":"waffleDatePicker"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDatePicker"],{className:"euiFieldText--inGroup",dateFormat:"L LTS",disabled:isAutoReloading,injectTimes:currentMoment?[currentMoment]:[],isLoading:isAutoReloading,onChange:handleChangeDate,popperPlacement:"top-end",selected:currentMoment,shouldCloseOnSelect:true,showTimeSelect:true,timeFormat:"LT"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},liveStreamingButton))});var autocomplete_field=__webpack_require__(288);var with_kuery_autocompletion=__webpack_require__(271);var kuery=__webpack_require__(103);const validateKuery=expression=>{try{data_public_["esKuery"].fromKueryExpression(expression)}catch(err){return false}return true};const DEFAULT_WAFFLE_FILTERS_STATE={kind:"kuery",expression:""};const useWaffleFilters=()=>{const{createDerivedIndexPattern:createDerivedIndexPattern}=Object(containers_source["b"])();const indexPattern=createDerivedIndexPattern("metrics");const[urlState,setUrlState]=Object(use_url_state["b"])({defaultState:DEFAULT_WAFFLE_FILTERS_STATE,decodeUrlState:use_waffle_filters_decodeUrlState,encodeUrlState:use_waffle_filters_encodeUrlState,urlStateKey:"waffleFilter"});const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])(urlState);Object(external_kbnSharedDeps_React_["useEffect"])(()=>setUrlState(state),[setUrlState,state]);const[filterQueryDraft,setFilterQueryDraft]=Object(external_kbnSharedDeps_React_["useState"])(urlState.expression);const filterQueryAsJson=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(kuery["a"])(urlState.expression,indexPattern),[indexPattern,urlState.expression]);const applyFilterQueryFromKueryExpression=Object(external_kbnSharedDeps_React_["useCallback"])(expression=>{setState(previous=>({...previous,kind:"kuery",expression:expression}))},[setState]);const applyFilterQuery=Object(external_kbnSharedDeps_React_["useCallback"])(filterQuery=>{setState(filterQuery);setFilterQueryDraft(filterQuery.expression)},[]);const isFilterQueryDraftValid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>validateKuery(filterQueryDraft),[filterQueryDraft]);const{inventoryPrefill:inventoryPrefill}=Object(use_alert_prefill["b"])();const prefillContext=Object(external_kbnSharedDeps_React_["useMemo"])(()=>inventoryPrefill,[inventoryPrefill]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>prefillContext.setFilterQuery(state.expression),[prefillContext,state]);return{filterQuery:urlState,filterQueryDraft:filterQueryDraft,filterQueryAsJson:filterQueryAsJson,applyFilterQuery:applyFilterQuery,setFilterQueryDraftFromKueryExpression:setFilterQueryDraft,applyFilterQueryFromKueryExpression:applyFilterQueryFromKueryExpression,isFilterQueryDraftValid:isFilterQueryDraftValid,setWaffleFiltersState:applyFilterQuery}};const WaffleFiltersStateRT=lib["type"]({kind:lib["literal"]("kuery"),expression:lib["string"]});const use_waffle_filters_encodeUrlState=WaffleFiltersStateRT.encode;const use_waffle_filters_decodeUrlState=value=>Object(pipeable["pipe"])(WaffleFiltersStateRT.decode(value),Object(Either["fold"])(Object(lib_function["constant"])(undefined),lib_function["identity"]));const WaffleFilters=constate_cjs_default()(useWaffleFilters);const[WaffleFiltersProvider,useWaffleFiltersContext]=WaffleFilters;const SearchBar=()=>{const{createDerivedIndexPattern:createDerivedIndexPattern}=Object(external_kbnSharedDeps_React_["useContext"])(containers_source["a"].Context);const{applyFilterQueryFromKueryExpression:applyFilterQueryFromKueryExpression,filterQueryDraft:filterQueryDraft,isFilterQueryDraftValid:isFilterQueryDraftValid,setFilterQueryDraftFromKueryExpression:setFilterQueryDraftFromKueryExpression}=useWaffleFiltersContext();return external_kbnSharedDeps_React_default.a.createElement(with_kuery_autocompletion["a"],{indexPattern:createDerivedIndexPattern("metrics")},({isLoadingSuggestions:isLoadingSuggestions,loadSuggestions:loadSuggestions,suggestions:suggestions})=>external_kbnSharedDeps_React_default.a.createElement(autocomplete_field["a"],{isLoadingSuggestions:isLoadingSuggestions,isValid:isFilterQueryDraftValid,loadSuggestions:loadSuggestions,onChange:setFilterQueryDraftFromKueryExpression,onSubmit:applyFilterQueryFromKueryExpression,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder",{defaultMessage:"Search for infrastructure data… (e.g. host.name:host-1)"}),suggestions:suggestions,value:filterQueryDraft?filterQueryDraft:"",autoFocus:true}))};const FilterBar=()=>external_kbnSharedDeps_React_default.a.createElement(ToolbarPanel,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"spaceBetween",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(SearchBar,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(WaffleTimeControls,null))));var no_indices=__webpack_require__(161);var source_error_page=__webpack_require__(180);var source_loading_page=__webpack_require__(116);var source_configuration=__webpack_require__(215);var useInterval=__webpack_require__(135);var useInterval_default=__webpack_require__.n(useInterval);var auto_sizer=__webpack_require__(119);const INTERVAL_STRING_RE=new RegExp(`^([\\d\\.]+)\\s*(${elastic_datemath_default.a.units.join("|")})$`);const parseInterval=intervalString=>{if(intervalString){const matches=intervalString.match(INTERVAL_STRING_RE);if(matches){const value=Number(matches[1]);const unit=matches[2];return{value:value,unit:unit}}}throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.parseInterval.errorMessage",{defaultMessage:"{value} is not an interval string",values:{value:intervalString}}))};const ValidUnitRT=lib["keyof"]({seconds:null,minutes:null,hours:null,days:null,weeks:null,months:null,years:null});const UNITS=["seconds","minutes","hours","days","weeks","months","years"];const DISPLAY_STRINGS_FOR_UNITS_PLURAL={seconds:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.seconds.plural",{defaultMessage:"seconds"}),minutes:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.minutes.plural",{defaultMessage:"minutes"}),hours:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.hours.plural",{defaultMessage:"hours"}),days:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.days.plural",{defaultMessage:"days"}),weeks:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.weeks.plural",{defaultMessage:"weeks"}),months:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.months.plural",{defaultMessage:"months"}),years:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.years.plural",{defaultMessage:"years"})};const DISPLAY_STRINGS_FOR_UNITS_SINGULAR={seconds:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.seconds.singular",{defaultMessage:"second"}),minutes:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.minutes.singular",{defaultMessage:"minute"}),hours:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.hours.singular",{defaultMessage:"hour"}),days:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.days.singular",{defaultMessage:"day"}),weeks:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.weeks.singular",{defaultMessage:"week"}),months:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.months.singular",{defaultMessage:"month"}),years:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.durationUnits.years.singular",{defaultMessage:"year"})};const getDisplayableUnit=(value,unit)=>Math.floor(value)===1?DISPLAY_STRINGS_FOR_UNITS_SINGULAR[unit]:DISPLAY_STRINGS_FOR_UNITS_PLURAL[unit];const convertIntervalToString=input=>{const interval=parseInterval(input);if((interval===null||interval===void 0?void 0:interval.unit)==="s"){const duration=external_kbnSharedDeps_Moment_default.a.duration(interval.value,interval.unit);const targetUnit=UNITS.reduce((answer,unit)=>{if(duration.as(unit)>=1){return unit}return answer},"seconds");const durationAsUnit=duration.as(targetUnit);return`${Math.floor(durationAsUnit)} ${getDisplayableUnit(durationAsUnit,targetUnit)}`}};function isInfraWaffleMapStepLegend(subject){return subject.type&&subject.type==="step"}function isInfraWaffleMapGradientLegend(subject){return subject.type&&subject.type==="gradient"}function isWaffleMapGroupWithNodes(subject){return subject&&subject.nodes!=null&&Array.isArray(subject.nodes)}function isWaffleMapGroupWithGroups(subject){return subject&&subject.groups!=null&&Array.isArray(subject.groups)}function createId(path){return path.map(p=>p.value).join("/")}function findOrCreateGroupWithNodes(groups,path){const id=path.length===0?"__all__":createId(path);const firstPath=Object(external_kbnSharedDeps_Lodash_["first"])(path);if(path.length===2&&firstPath){const parentId=firstPath.value;const existingParentGroup=groups.find(g=>g.id===parentId);if(isWaffleMapGroupWithGroups(existingParentGroup)){const existingSubGroup=existingParentGroup.groups.find(g=>g.id===id);if(isWaffleMapGroupWithNodes(existingSubGroup)){return existingSubGroup}}}const lastPath=Object(external_kbnSharedDeps_Lodash_["last"])(path);const existingGroup=groups.find(g=>g.id===id);if(isWaffleMapGroupWithNodes(existingGroup)){return existingGroup}return{id:id,name:id==="__all__"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodesToWaffleMap.groupsWithNodes.allName",{defaultMessage:"All"}):lastPath&&lastPath.label||"Unknown Group",count:0,width:0,squareSize:0,nodes:[]}}function findOrCreateGroupWithGroups(groups,path){const id=path.length===0?"__all__":createId(path);const lastPath=Object(external_kbnSharedDeps_Lodash_["last"])(path);const existingGroup=groups.find(g=>g.id===id);if(isWaffleMapGroupWithGroups(existingGroup)){return existingGroup}return{id:id,name:id==="__all__"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodesToWaffleMap.groupsWithGroups.allName",{defaultMessage:"All"}):lastPath&&lastPath.label||"Unknown Group",count:0,width:0,squareSize:0,groups:[]}}function createWaffleMapNode(node){const nodePathItem=Object(external_kbnSharedDeps_Lodash_["last"])(node.path);if(!nodePathItem){throw new Error("There must be at least one node path item")}return{pathId:node.path.map(p=>p.value).join("/"),path:node.path,id:nodePathItem.value,ip:nodePathItem.ip,name:nodePathItem.label||nodePathItem.value,metrics:node.metrics}}function withoutGroup(group){return subject=>subject.id!==group.id}function nodesToWaffleMap(nodes){return nodes.reduce((groups,node)=>{const waffleNode=createWaffleMapNode(node);if(node.path.length===2){const parentGroup=findOrCreateGroupWithNodes(groups,node.path.slice(0,node.path.length-1));parentGroup.nodes.push(waffleNode);return groups.filter(withoutGroup(parentGroup)).concat([parentGroup])}if(node.path.length===3){const parentGroup=findOrCreateGroupWithNodes(groups,node.path.slice(0,node.path.length-1));parentGroup.nodes.push(waffleNode);const topGroup=findOrCreateGroupWithGroups(groups,node.path.slice(0,node.path.length-2));topGroup.groups=topGroup.groups.filter(withoutGroup(parentGroup)).concat([parentGroup]);return groups.filter(withoutGroup(topGroup)).concat([topGroup])}const allGroup=findOrCreateGroupWithNodes(groups,[]);allGroup.nodes.push(waffleNode);return groups.filter(withoutGroup(allGroup)).concat([allGroup])},[])}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class group_name_GroupName extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(...args){super(...args);_defineProperty(this,"handleClick",event=>{event.preventDefault();const{groupBy:groupBy}=this.props.options;if(groupBy.length===0){return}const currentPath=this.props.isChild&&groupBy.length>1?groupBy[1]:groupBy[0];this.props.onDrilldown(`${currentPath.field}: "${this.props.group.name}"`)})}render(){const{group:group,isChild:isChild}=this.props;const linkStyle={fontSize:isChild?"0.85em":"1em"};return external_kbnSharedDeps_React_default.a.createElement(GroupNameContainer,null,external_kbnSharedDeps_React_default.a.createElement(Inner,{isChild:isChild},external_kbnSharedDeps_React_default.a.createElement(Name,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:group.name},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{style:linkStyle,onClickCapture:this.handleClick},group.name))),external_kbnSharedDeps_React_default.a.createElement(Count,null,group.count)))}}const GroupNameContainer=common_["euiStyled"].div`
  position: relative;
  text-align: center;
  font-size: 16px;
  margin-bottom: 5px;
  top: 20px;
  display: flex;
  justify-content: center;
  padding: 0 10px;
`;const Inner=common_["euiStyled"].div`
  border: 1px solid ${props=>props.theme.eui.euiBorderColor};
  background-color: ${props=>props.isChild?props.theme.eui.euiColorLightestShade:props.theme.eui.euiColorEmptyShade};
  border-radius: 4px;
  box-shadow: 0px 2px 0px 0px ${props=>props.theme.eui.euiBorderColor};
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
`;const Name=common_["euiStyled"].div`
  flex: 1 1 auto;
  padding: 6px 10px;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;const Count=common_["euiStyled"].div`
  flex: 0 0 auto;
  border-left: 1px solid ${props=>props.theme.eui.euiBorderColor};
  padding: 6px 10px;
  font-size: 0.85em;
  font-weight: normal;
`;var polished_lib=__webpack_require__(114);var get_custom_metric_label=__webpack_require__(140);var types=__webpack_require__(89);var runtime_types=__webpack_require__(13);var use_http_request=__webpack_require__(106);var snapshot_api=__webpack_require__(92);function useSnapshot(filterQuery,metrics,groupBy,nodeType,sourceId,currentTime,accountId,region,sendRequestImmediatly=true,timerange){const decodeResponse=response=>Object(pipeable["pipe"])(snapshot_api["g"].decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));timerange=timerange||{interval:"1m",to:currentTime,from:currentTime-1200*1e3,lookbackSize:5};const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/metrics/snapshot","POST",JSON.stringify({metrics:metrics,groupBy:groupBy,nodeType:nodeType,timerange:timerange,filterQuery:filterQuery,sourceId:sourceId,accountId:accountId,region:region,includeTimeseries:true}),decodeResponse);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{if(sendRequestImmediatly){await makeRequest()}})()},[makeRequest,sendRequestImmediatly]);return{error:error&&error.message||null,loading:loading,nodes:response?response.nodes:[],interval:response?response.interval:"60s",reload:makeRequest}}var formatters=__webpack_require__(32);const METRIC_FORMATTERS={["count"]:{formatter:lib_lib["b"].number,template:"{{value}}"},["cpu"]:{formatter:lib_lib["b"].percent,template:"{{value}}"},["memory"]:{formatter:lib_lib["b"].percent,template:"{{value}}"},["rx"]:{formatter:lib_lib["b"].bits,template:"{{value}}/s"},["tx"]:{formatter:lib_lib["b"].bits,template:"{{value}}/s"},["logRate"]:{formatter:lib_lib["b"].abbreviatedNumber,template:"{{value}}/s"},["diskIOReadBytes"]:{formatter:lib_lib["b"].bytes,template:"{{value}}/s"},["diskIOWriteBytes"]:{formatter:lib_lib["b"].bytes,template:"{{value}}/s"},["s3BucketSize"]:{formatter:lib_lib["b"].bytes,template:"{{value}}"},["s3TotalRequests"]:{formatter:lib_lib["b"].abbreviatedNumber,template:"{{value}}"},["s3NumberOfObjects"]:{formatter:lib_lib["b"].abbreviatedNumber,template:"{{value}}"},["s3UploadBytes"]:{formatter:lib_lib["b"].bytes,template:"{{value}}"},["s3DownloadBytes"]:{formatter:lib_lib["b"].bytes,template:"{{value}}"},["sqsOldestMessage"]:{formatter:lib_lib["b"].number,template:"{{value}} seconds"},["rdsLatency"]:{formatter:lib_lib["b"].number,template:"{{value}} ms"}};const createInventoryMetricFormatter=metric=>val=>{if(snapshot_api["d"].is(metric)){const formatter=Object(create_formatter_for_metric["a"])(metric);return formatter(val)}const metricFormatter=Object(external_kbnSharedDeps_Lodash_["get"])(METRIC_FORMATTERS,metric.type,METRIC_FORMATTERS.count);if(val==null){return""}const formatter=Object(formatters["b"])(metricFormatter.formatter,metricFormatter.template);return formatter(val)};var snapshot_metric_i18n=__webpack_require__(170);const fieldToName=field=>{const LOOKUP={"kubernetes.namespace":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.kubernetesNamespace",{defaultMessage:"Namespace"}),"kubernetes.node.name":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.kubernetesNodeName",{defaultMessage:"Node"}),"host.name":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.hostName",{defaultMessage:"Host"}),"cloud.availability_zone":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.availabilityZone",{defaultMessage:"Availability zone"}),"cloud.machine.type":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.machineType",{defaultMessage:"Machine type"}),"cloud.project.id":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.projectID",{defaultMessage:"Project ID"}),"cloud.provider":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.provider",{defaultMessage:"Cloud provider"}),"service.type":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.groupByDisplayNames.serviceType",{defaultMessage:"Service type"})};return LOOKUP[field]||field};const snapshotTypeKeys=Object.keys(types["e"]);const SNAPSHOT_METRIC_TRANSLATIONS=snapshotTypeKeys.reduce((result,metric)=>{var _toMetricOpt;const text=(_toMetricOpt=Object(snapshot_metric_i18n["a"])(metric))===null||_toMetricOpt===void 0?void 0:_toMetricOpt.text;if(text)return{...result,[metric]:text};return result},{});var use_waffle_options=__webpack_require__(101);const ConditionalToolTip=Object(common_["withTheme"])(({theme:theme,hidden:hidden,node:node,children:children,nodeType:nodeType,currentTime:currentTime})=>{const{sourceId:sourceId}=Object(containers_source["b"])();const[timer,setTimer]=Object(external_kbnSharedDeps_React_["useState"])(null);const model=Object(inventory_models["b"])(nodeType);const{customMetrics:customMetrics}=Object(use_waffle_options["d"])();const requestMetrics=model.tooltipMetrics.map(type=>({type:type})).concat(customMetrics);const query=JSON.stringify({bool:{filter:{match_phrase:{[model.fields.id]:node.id}}}});const{nodes:nodes,reload:reload}=useSnapshot(query,requestMetrics,[],nodeType,sourceId,currentTime,"","",false);const handleDataLoad=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{const id=setTimeout(reload,200);setTimer(id)},[reload]);const cancelDataLoad=Object(external_kbnSharedDeps_React_["useCallback"])(()=>timer&&clearTimeout(timer)||void 0,[timer]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>cancelDataLoad,[timer,cancelDataLoad]);if(hidden){return children}const dataNode=Object(external_kbnSharedDeps_Lodash_["first"])(nodes);const metrics=dataNode&&dataNode.metrics||[];const content=external_kbnSharedDeps_React_default.a.createElement("div",{style:{minWidth:200},"data-test-subj":"conditionalTooltipContent"},external_kbnSharedDeps_React_default.a.createElement("div",{style:{borderBottom:`1px solid ${theme===null||theme===void 0?void 0:theme.eui.euiColorMediumShade}`,paddingBottom:theme===null||theme===void 0?void 0:theme.eui.paddingSizes.xs,marginBottom:theme===null||theme===void 0?void 0:theme.eui.paddingSizes.xs}},node.name),metrics.map(metric=>{const metricName=types["f"].is(metric.name)?metric.name:"custom";const name=SNAPSHOT_METRIC_TRANSLATIONS[metricName]||metricName;const customMetric=name==="custom"?customMetrics.find(item=>item.id===metric.name):null;const formatter=customMetric?Object(create_formatter_for_metric["a"])(customMetric):createInventoryMetricFormatter({type:metricName});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",key:metric.name},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1,className:"eui-textTruncate eui-displayBlock"},customMetric?Object(get_custom_metric_label["a"])(customMetric):name),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},metric.value&&formatter(metric.value)||"-"))}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{delay:"regular",position:"right",content:content},external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"conditionalTooltipMouseHandler",onMouseOver:handleDataLoad,onFocus:handleDataLoad,onMouseOut:cancelDataLoad,onBlur:cancelDataLoad},children))});const OPERATOR_TO_FN={[lib_lib["c"].eq]:external_kbnSharedDeps_Lodash_["isEqual"],[lib_lib["c"].lt]:external_kbnSharedDeps_Lodash_["lt"],[lib_lib["c"].lte]:external_kbnSharedDeps_Lodash_["lte"],[lib_lib["c"].gte]:external_kbnSharedDeps_Lodash_["gte"],[lib_lib["c"].gt]:external_kbnSharedDeps_Lodash_["gt"]};const convertToRgbString=color=>Object(polished_lib["toColorString"])(Object(polished_lib["parseToRgb"])(color));const colorFromValue=(legend,value,bounds,defaultColor="rgba(217, 217, 217, 1)")=>{try{if(lib_lib["f"].is(legend)){return convertToRgbString(calculateStepColor(legend.rules,value,defaultColor))}if(lib_lib["a"].is(legend)){return convertToRgbString(calculateGradientColor(legend.rules,value,bounds,defaultColor))}if(lib_lib["g"].is(legend)){return convertToRgbString(calculateSteppedGradientColor(legend.rules,value,bounds,defaultColor))}return defaultColor}catch(error){return defaultColor}};const normalizeValue=(min,max,value)=>(value-min)/(max-min);const calculateSteppedGradientColor=(rules,value,bounds,defaultColor="rgba(217, 217, 217, 1)")=>{var _first$color,_first;const normalizedValue=normalizeValue(bounds.min,bounds.max,Number(value));const steps=rules.length;const lastRule=Object(external_kbnSharedDeps_Lodash_["last"])(rules);if(lastRule&&Object(external_kbnSharedDeps_Lodash_["gte"])(normalizedValue,lastRule.value)){return lastRule.color}return rules.reduce((color,rule)=>{const min=rule.value-1/steps;const max=rule.value;if(Object(external_kbnSharedDeps_Lodash_["gte"])(normalizedValue,min)&&Object(external_kbnSharedDeps_Lodash_["lte"])(normalizedValue,max)){return rule.color}return color},(_first$color=(_first=Object(external_kbnSharedDeps_Lodash_["first"])(rules))===null||_first===void 0?void 0:_first.color)!==null&&_first$color!==void 0?_first$color:defaultColor)};const calculateStepColor=(rules,value,defaultColor="rgba(217, 217, 217, 1)")=>rules.reduce((color,rule)=>{const operatorFn=OPERATOR_TO_FN[rule.operator];if(operatorFn(value,rule.value)){return rule.color}return color},defaultColor);const calculateGradientColor=(rules,value,bounds,defaultColor="rgba(0, 179, 164, 1)")=>{if(rules.length===0){return defaultColor}if(rules.length===1){return Object(external_kbnSharedDeps_Lodash_["last"])(rules).color}const{min:min,max:max}=bounds;const sortedRules=Object(external_kbnSharedDeps_Lodash_["sortBy"])(rules,"value");const normValue=normalizeValue(min,max,Number(value));const startRule=sortedRules.reduce((acc,rule)=>{if(rule.value<=normValue){return rule}return acc},Object(external_kbnSharedDeps_Lodash_["first"])(sortedRules));const endRule=sortedRules.filter(r=>r!==startRule).find(r=>r.value>=normValue);if(!endRule){return startRule.color}const mixValue=normalizeValue(startRule.value,endRule.value,normValue);return Object(polished_lib["mix"])(mixValue,endRule.color,startRule.color)};const OVERLAY_Y_START=266;const OVERLAY_BOTTOM_MARGIN=16;const shared_TabContent=common_["euiStyled"].div`
  padding: ${props=>props.theme.eui.paddingSizes.m};
  flex: 1;
  overflow-y: auto;
  overflow-x: hidden;
`;const ChartHeader=({title:title,metrics:metrics})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h4",null,title))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},metrics.map(chartMetric=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:chartMetric.label},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{key:chartMetric.label,gutterSize:"xs",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:Object(color_palette["b"])(chartMetric.color),type:"dot"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},chartMetric.label))))))));const SYSTEM_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.system",{defaultMessage:"System"});const USER_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.user",{defaultMessage:"User"});const INBOUND_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.inbound",{defaultMessage:"Inbound"});const OUTBOUND_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.outbound",{defaultMessage:"Outbound"});const USED_MEMORY_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.used",{defaultMessage:"Used"});const CACHED_MEMORY_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.cached",{defaultMessage:"Cached"});const FREE_MEMORY_METRIC_NAME=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.free",{defaultMessage:"Free"});const NETWORK_CHART_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.charts.networkTitle",{defaultMessage:"Network"});const MEMORY_CHART_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.charts.memoryTitle",{defaultMessage:"Memory"});const CPU_CHART_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.fcharts.cpuTitle",{defaultMessage:"CPU"});const LOAD_CHART_TITLE=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.charts.loadTitle",{defaultMessage:"Load"});const TimeDropdown=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{fullWidth:true,options:[{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.last15Minutes",{defaultMessage:"Last 15 mintues"}),value:15*60*1e3},{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.lastHour",{defaultMessage:"Last hour"}),value:60*60*1e3},{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.last3Hours",{defaultMessage:"Last 3 hours"}),value:3*60*60*1e3},{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.last24Hours",{defaultMessage:"Last 24 hours"}),value:24*60*60*1e3},{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.metrics.last7Days",{defaultMessage:"Last 7 days"}),value:7*24*60*60*1e3}],value:props.value,onChange:props.onChange});const ONE_HOUR=60*60*1e3;const CHART_SIZE=["100%",160];const TabComponent=props=>{const cpuChartRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const networkChartRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const memoryChartRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const loadChartRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const[time,setTime]=Object(external_kbnSharedDeps_React_["useState"])(ONE_HOUR);const chartRefs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[cpuChartRef,networkChartRef,memoryChartRef,loadChartRef],[cpuChartRef,networkChartRef,memoryChartRef,loadChartRef]);const{sourceId:sourceId,createDerivedIndexPattern:createDerivedIndexPattern}=Object(containers_source["b"])();const{nodeType:nodeType,accountId:accountId,region:region}=Object(use_waffle_options["d"])();const{currentTime:currentTime,options:options,node:node}=props;const derivedIndexPattern=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createDerivedIndexPattern("metrics"),[createDerivedIndexPattern]);let filter=options.fields?`${Object(inventory_models["a"])(nodeType,options.fields).id}: "${node.id}"`:"";if(filter){filter=Object(kuery["a"])(filter,derivedIndexPattern)}const buildCustomMetric=Object(external_kbnSharedDeps_React_["useCallback"])((field,id,aggregation="avg")=>({type:"custom",aggregation:aggregation,field:field,id:id}),[]);const updateTime=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{setTime(Number(e.currentTarget.value))},[setTime]);const{nodes:nodes,reload:reload}=useSnapshot(filter,[{type:"rx"},{type:"tx"},buildCustomMetric("system.cpu.user.pct","user"),buildCustomMetric("system.cpu.system.pct","system"),buildCustomMetric("system.load.1","load1m"),buildCustomMetric("system.load.5","load5m"),buildCustomMetric("system.load.15","load15m"),buildCustomMetric("system.memory.actual.used.bytes","usedMemory"),buildCustomMetric("system.memory.actual.free","freeMemory"),buildCustomMetric("system.cpu.cores","cores","max")],[],nodeType,sourceId,currentTime,accountId,region,false,{interval:"1m",to:currentTime,from:currentTime-time,ignoreLookback:true});const getDomain=Object(external_kbnSharedDeps_React_["useCallback"])((timeseries,ms)=>{const dataDomain=timeseries?Object(calculate_domain["a"])(timeseries,ms,false):null;return dataDomain?{max:dataDomain.max*1.1,min:dataDomain.min}:{max:0,min:0}},[]);const dateFormatter=Object(external_kbnSharedDeps_React_["useCallback"])(timeseries=>{var _first,_last;if(!timeseries)return()=>"";const firstTimestamp=(_first=Object(external_kbnSharedDeps_Lodash_["first"])(timeseries.rows))===null||_first===void 0?void 0:_first.timestamp;const lastTimestamp=(_last=Object(external_kbnSharedDeps_Lodash_["last"])(timeseries.rows))===null||_last===void 0?void 0:_last.timestamp;if(firstTimestamp==null||lastTimestamp==null){return value=>`${value}`}return Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])([firstTimestamp,lastTimestamp])},[]);const networkFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createInventoryMetricFormatter({type:"rx"}),[]);const cpuFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createInventoryMetricFormatter({type:"cpu"}),[]);const memoryFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createInventoryMetricFormatter({type:"s3BucketSize"}),[]);const loadFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createInventoryMetricFormatter({type:"load"}),[]);const mergeTimeseries=Object(external_kbnSharedDeps_React_["useCallback"])((...series)=>{const base=series[0];const otherSeries=series.slice(1);base.rows=base.rows.map((b,rowIdx)=>{const newRow={...b};otherSeries.forEach((o,idx)=>{newRow[`metric_${idx+1}`]=o.rows[rowIdx].metric_0});return newRow});return base},[]);const buildChartMetricLabels=Object(external_kbnSharedDeps_React_["useCallback"])((labels,aggregation)=>{const baseMetric={color:color_palette["a"].color0,aggregation:aggregation,label:"System"};return labels.map((label,idx)=>({...baseMetric,color:color_palette["a"][`color${idx}`],label:label}))},[]);const pointerUpdate=Object(external_kbnSharedDeps_React_["useCallback"])(event=>{chartRefs.forEach(ref=>{if(ref.current){ref.current.dispatchExternalPointerEvent(event)}})},[chartRefs]);const isDarkMode=Object(kibanaReact_public_["useUiSetting"])("theme:darkMode");const tooltipProps={headerFormatter:tooltipValue=>external_kbnSharedDeps_Moment_default()(tooltipValue.value).format("Y-MM-DD HH:mm:ss.SSS")};const getTimeseries=Object(external_kbnSharedDeps_React_["useCallback"])(metricName=>{if(!nodes||!nodes.length){return null}return nodes[0].metrics.find(m=>m.name===metricName).timeseries},[nodes]);const systemMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("system"),[getTimeseries]);const userMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("user"),[getTimeseries]);const rxMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("rx"),[getTimeseries]);const txMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("tx"),[getTimeseries]);const load1mMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("load1m"),[getTimeseries]);const load5mMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("load5m"),[getTimeseries]);const load15mMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("load15m"),[getTimeseries]);const usedMemoryMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("usedMemory"),[getTimeseries]);const freeMemoryMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("freeMemory"),[getTimeseries]);const coresMetricsTs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeseries("cores"),[getTimeseries]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{reload()},[time,reload]);if(!systemMetricsTs||!userMetricsTs||!rxMetricsTs||!txMetricsTs||!load1mMetricsTs||!load5mMetricsTs||!load15mMetricsTs||!usedMemoryMetricsTs||!freeMemoryMetricsTs){return external_kbnSharedDeps_React_default.a.createElement(LoadingPlaceholder,null)}const cpuChartMetrics=buildChartMetricLabels([SYSTEM_METRIC_NAME,USER_METRIC_NAME],"avg");const networkChartMetrics=buildChartMetricLabels([INBOUND_METRIC_NAME,OUTBOUND_METRIC_NAME],"rate");const loadChartMetrics=buildChartMetricLabels(["1m","5m","15m"],"avg");const memoryChartMetrics=buildChartMetricLabels([USED_MEMORY_METRIC_NAME,FREE_MEMORY_METRIC_NAME],"rate");systemMetricsTs.rows=systemMetricsTs.rows.slice().map((r,idx)=>{const metric=r.metric_0;const cores=coresMetricsTs.rows[idx].metric_0;if(metric&&cores){r.metric_0=metric/cores}return r});userMetricsTs.rows=userMetricsTs.rows.slice().map((r,idx)=>{const metric=r.metric_0;const cores=coresMetricsTs.rows[idx].metric_0;if(metric&&cores){r.metric_0=metric/cores}return r});const cpuTimeseries=mergeTimeseries(systemMetricsTs,userMetricsTs);const networkTimeseries=mergeTimeseries(rxMetricsTs,txMetricsTs);const loadTimeseries=mergeTimeseries(load1mMetricsTs,load5mMetricsTs,load15mMetricsTs);const memoryTimeseries=mergeTimeseries(usedMemoryMetricsTs,freeMemoryMetricsTs);const formatter=dateFormatter(rxMetricsTs);return external_kbnSharedDeps_React_default.a.createElement(shared_TabContent,null,external_kbnSharedDeps_React_default.a.createElement(TimeDropdown,{value:time,onChange:updateTime}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2,gutterSize:"l",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(ChartHeader,{title:CPU_CHART_TITLE,metrics:cpuChartMetrics}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{ref:cpuChartRef,size:CHART_SIZE},external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:cpuChartMetrics[0],id:"0",series:systemMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:cpuChartMetrics[1],id:"0",series:userMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:formatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:cpuFormatter,domain:getDomain(cpuTimeseries,cpuChartMetrics),ticks:6,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{onPointerUpdate:pointerUpdate,tooltip:tooltipProps,theme:Object(get_chart_theme["b"])(isDarkMode)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(ChartHeader,{title:LOAD_CHART_TITLE,metrics:loadChartMetrics}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{ref:loadChartRef,size:CHART_SIZE},external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:loadChartMetrics[0],id:"0",series:load1mMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:loadChartMetrics[1],id:"0",series:load5mMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:loadChartMetrics[2],id:"0",series:load15mMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:formatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values1",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:loadFormatter,domain:getDomain(loadTimeseries,loadChartMetrics),ticks:6,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{onPointerUpdate:pointerUpdate,tooltip:tooltipProps,theme:Object(get_chart_theme["b"])(isDarkMode)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(ChartHeader,{title:MEMORY_CHART_TITLE,metrics:memoryChartMetrics}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{ref:memoryChartRef,size:CHART_SIZE},external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:memoryChartMetrics[0],id:"0",series:usedMemoryMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:memoryChartMetrics[1],id:"0",series:freeMemoryMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:formatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:memoryFormatter,domain:getDomain(memoryTimeseries,memoryChartMetrics),ticks:6,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{onPointerUpdate:pointerUpdate,tooltip:tooltipProps,theme:Object(get_chart_theme["b"])(isDarkMode)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(ChartHeader,{title:NETWORK_CHART_TITLE,metrics:networkChartMetrics}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{ref:networkChartRef,size:CHART_SIZE},external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:networkChartMetrics[0],id:"0",series:rxMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].line,metric:networkChartMetrics[1],id:"0",series:txMetricsTs,stack:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:formatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:networkFormatter,domain:getDomain(networkTimeseries,networkChartMetrics),ticks:6,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{onPointerUpdate:pointerUpdate,tooltip:tooltipProps,theme:Object(get_chart_theme["b"])(isDarkMode)})))))};const LoadingPlaceholder=()=>external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%",height:"200px",padding:"16px",display:"flex",alignItems:"center",justifyContent:"center"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl"}));const MetricsTab={id:"metrics",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metrics",{defaultMessage:"Metrics"}),content:TabComponent};var log_stream=__webpack_require__(250);var link_to_logs=__webpack_require__(214);var redirect_to_node_logs=__webpack_require__(145);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const logs_TabComponent=props=>{const[textQuery,setTextQuery]=Object(external_kbnSharedDeps_React_["useState"])("");const endTimestamp=props.currentTime;const startTimestamp=endTimestamp-60*60*1e3;const{nodeType:nodeType}=Object(use_waffle_options["d"])();const{options:options,node:node}=props;const filter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{let query=options.fields?`${Object(inventory_models["a"])(nodeType,options.fields).id}: "${node.id}"`:``;if(textQuery){query+=` and message: ${textQuery}`}return query},[options,nodeType,node.id,textQuery]);const onQueryChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{setTextQuery(e.target.value)},[]);const nodeLogsMenuItemLinkProps=Object(use_link_props["b"])(Object(redirect_to_node_logs["b"])({nodeType:nodeType,nodeId:node.id,time:startTimestamp}));return external_kbnSharedDeps_React_default.a.createElement(shared_TabContent,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{fullWidth:true,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.logs.textFieldPlaceholder",{defaultMessage:"Search for log entries..."}),value:textQuery,isClearable:true,onChange:onQueryChange})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],_extends({size:"xs",flush:"both",iconType:"popout"},nodeLogsMenuItemLinkProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.nodeDetails.logs.openLogsLink",defaultMessage:"Open in Logs"})))),external_kbnSharedDeps_React_default.a.createElement(log_stream["a"],{startTimestamp:startTimestamp,endTimestamp:endTimestamp,query:filter}))};const LogsTab={id:"logs",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.logs",{defaultMessage:"Logs"}),content:logs_TabComponent};var http_api=__webpack_require__(95);function useProcessList(hostTerm,timefield,to,sortBy,searchFilter){const{createDerivedIndexPattern:createDerivedIndexPattern}=Object(containers_source["b"])();const indexPattern=createDerivedIndexPattern("metrics").title;const[inErrorState,setInErrorState]=Object(external_kbnSharedDeps_React_["useState"])(false);const decodeResponse=response=>Object(pipeable["pipe"])(http_api["i"].decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const parsedSortBy=sortBy.name==="runtimeLength"?{...sortBy,name:"startTime"}:sortBy;const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/metrics/process_list","POST",JSON.stringify({hostTerm:hostTerm,timefield:timefield,indexPattern:indexPattern,to:to,sortBy:parsedSortBy,searchFilter:searchFilter}),decodeResponse);Object(external_kbnSharedDeps_React_["useEffect"])(()=>setInErrorState(true),[error]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>setInErrorState(false),[loading]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{makeRequest()},[makeRequest]);return{error:inErrorState,loading:loading,response:response,makeRequest:makeRequest}}function useProcessListParams(props){const{hostTerm:hostTerm,timefield:timefield,to:to}=props;const{createDerivedIndexPattern:createDerivedIndexPattern}=Object(containers_source["b"])();const indexPattern=createDerivedIndexPattern("metrics").title;return{hostTerm:hostTerm,indexPattern:indexPattern,timefield:timefield,to:to}}const ProcessListContext=constate_cjs_default()(useProcessListParams);const[ProcessListContextProvider,useProcessListContext]=ProcessListContext;const STATE_NAMES={running:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateRunning",{defaultMessage:"Running"}),sleeping:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateSleeping",{defaultMessage:"Sleeping"}),dead:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateDead",{defaultMessage:"Dead"}),stopped:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateStopped",{defaultMessage:"Stopped"}),idle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateIdle",{defaultMessage:"Idle"}),zombie:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateZombie",{defaultMessage:"Zombie"}),unknown:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.stateUnknown",{defaultMessage:"Unknown"})};const STATE_ORDER=["running","sleeping","stopped","idle","dead","zombie","unknown"];const SummaryTable=({processSummary:processSummary,isLoading:isLoading})=>{const processCount=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({total:isLoading?-1:processSummary.total,...Object(external_kbnSharedDeps_Lodash_["mapValues"])(STATE_NAMES,()=>isLoading?-1:0),...isLoading?{}:processSummary}),[processSummary,isLoading]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",responsive:false,wrap:true},Object.entries(processCount).map(([field,value])=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{compressed:true},external_kbnSharedDeps_React_default.a.createElement(ColumnTitle,null,columnTitles[field]),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,value===-1?external_kbnSharedDeps_React_default.a.createElement(LoadingSpinner,null):value))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"m"}))};const columnTitles={total:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.headingTotalProcesses",{defaultMessage:"Total processes"}),...STATE_NAMES};const LoadingSpinner=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"]).attrs({size:"m"})`
  margin-top: 2px;
  margin-bottom: 3px;
`;const ColumnTitle=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"])`
  white-space: nowrap;
`;function useProcessListRowChart(command){const[inErrorState,setInErrorState]=Object(external_kbnSharedDeps_React_["useState"])(false);const decodeResponse=response=>Object(pipeable["pipe"])(http_api["h"].decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const{hostTerm:hostTerm,timefield:timefield,indexPattern:indexPattern,to:to}=useProcessListContext();const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/metrics/process_list/chart","POST",JSON.stringify({hostTerm:hostTerm,timefield:timefield,indexPattern:indexPattern,to:to,command:command}),decodeResponse);Object(external_kbnSharedDeps_React_["useEffect"])(()=>setInErrorState(true),[error]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>setInErrorState(false),[loading]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{makeRequest()},[makeRequest]);return{error:inErrorState,loading:loading,response:response,makeRequest:makeRequest}}const ProcessRowCharts=({command:command})=>{const{loading:loading,error:error,response:response}=useProcessListRowChart(command);const isLoading=loading||!response;const cpuChart=error?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"alert",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,failedToLoadChart)}):isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],null):external_kbnSharedDeps_React_default.a.createElement(ProcessChart,{timeseries:response.cpu,color:color_palette["a"].color2,label:cpuMetricLabel});const memoryChart=error?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"alert",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,failedToLoadChart)}):isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],null):external_kbnSharedDeps_React_default.a.createElement(ProcessChart,{timeseries:response.memory,color:color_palette["a"].color0,label:memoryMetricLabel});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,cpuMetricLabel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,cpuChart)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,memoryMetricLabel),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,memoryChart)))};const ProcessChart=({timeseries:timeseries,color:color,label:label})=>{const chartMetric={color:color,aggregation:"avg",label:label};const isDarkMode=Object(kibanaReact_public_["useUiSetting"])("theme:darkMode");const dateFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _first,_last;if(!timeseries)return()=>"";const firstTimestamp=(_first=Object(external_kbnSharedDeps_Lodash_["first"])(timeseries.rows))===null||_first===void 0?void 0:_first.timestamp;const lastTimestamp=(_last=Object(external_kbnSharedDeps_Lodash_["last"])(timeseries.rows))===null||_last===void 0?void 0:_last.timestamp;if(firstTimestamp==null||lastTimestamp==null){return value=>`${value}`}return Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])([firstTimestamp,lastTimestamp])},[timeseries]);const yAxisFormatter=Object(formatters["b"])("percent");const tooltipProps={headerFormatter:tooltipValue=>external_kbnSharedDeps_Moment_default()(tooltipValue.value).format("Y-MM-DD HH:mm:ss.SSS")};const dataDomain=Object(calculate_domain["a"])(timeseries,[chartMetric],false);const domain=dataDomain?{max:dataDomain.max*1.1,min:dataDomain.min}:{max:0,min:0};return external_kbnSharedDeps_React_default.a.createElement(ChartContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].area,metric:chartMetric,id:"0",series:timeseries,stack:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:dateFormatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:yAxisFormatter,domain:domain,ticks:6,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{tooltip:tooltipProps,theme:Object(get_chart_theme["a"])(isDarkMode)})))};const ChartContainer=common_["euiStyled"].div`
  width: 100%;
  height: 140px;
`;const cpuMetricLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCPU",{defaultMessage:"CPU"});const memoryMetricLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelMemory",{defaultMessage:"Memory"});const failedToLoadChart=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.failedToLoadChart",{defaultMessage:"Unable to load chart"});const ProcessRow=({cells:cells,item:item})=>{const[isExpanded,setIsExpanded]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableRow"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableRowCell"],{isExpander:true,textOnly:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:isExpanded?"arrowDown":"arrowRight","aria-expanded":isExpanded,onClick:()=>setIsExpanded(!isExpanded)})),cells),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableRow"],{isExpandable:true,isExpandedRow:isExpanded},isExpanded&&external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{bounds:true},({measureRef:measureRef,bounds:{height:height=0}})=>external_kbnSharedDeps_React_default.a.createElement(ExpandedRowCell,{commandHeight:height},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(ExpandedRowDescriptionList,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement("div",{ref:measureRef},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelCommand",{defaultMessage:"Command"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(ExpandedCommandLine,null,item.command)))),item.apmTrace&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.viewTraceInAPM",{defaultMessage:"View trace in APM"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2,gutterSize:"s",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelPID",{defaultMessage:"PID"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(CodeListItem,null,item.pid))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.expandedRowLabelUser",{defaultMessage:"User"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(CodeListItem,null,item.user))),external_kbnSharedDeps_React_default.a.createElement(ProcessRowCharts,{command:item.command})))))))};const ExpandedRowDescriptionList=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"]).attrs({compressed:true})`
  width: 100%;
`;const CodeListItem=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiCode"]).attrs({transparentBackground:true})`
  padding: 0 !important;
  & code.euiCodeBlock__code {
    white-space: nowrap !important;
    vertical-align: middle;
  }
`;const ExpandedCommandLine=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiCode"]).attrs({transparentBackground:true})`
  padding: 0 !important;
  margin-bottom: ${props=>props.theme.eui.euiSizeS};
`;const ExpandedRowCell=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiTableRowCell"]).attrs({textOnly:false,colSpan:6})`
  height: ${props=>props.commandHeight+240}px;
  padding: 0 ${props=>props.theme.eui.paddingSizes.m};
  background-color: ${props=>props.theme.eui.euiColorLightestShade};
`;const StateBadge=({state:state})=>{switch(state){case"running":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"secondary"},STATE_NAMES.running);case"sleeping":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"default"},STATE_NAMES.sleeping);case"dead":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"danger"},STATE_NAMES.dead);case"stopped":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"warning"},STATE_NAMES.stopped);case"idle":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"primary"},STATE_NAMES.idle);case"zombie":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"danger"},STATE_NAMES.zombie);default:return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"hollow"},STATE_NAMES.unknown)}};function useSortableProperties(sortablePropertyItems,defaultSortProperty,callback){const[sortableProperties]=Object(external_kbnSharedDeps_React_["useState"])(new external_kbnSharedDeps_ElasticEui_["SortableProperties"](sortablePropertyItems,defaultSortProperty));return{updateSortableProperties:Object(external_kbnSharedDeps_React_["useCallback"])(property=>{sortableProperties.sortOn(property);callback(Object(external_kbnSharedDeps_Lodash_["omit"])(sortableProperties.getSortedProperty(),"getValue"))},[sortableProperties,callback])}}const ProcessesTable=({processList:processList,currentTime:currentTime,isLoading:isLoading,sortBy:sortBy,setSortBy:setSortBy,clearSearchBar:clearSearchBar})=>{const{updateSortableProperties:updateSortableProperties}=useSortableProperties([{name:"startTime",getValue:item=>Date.parse(item.startTime),isAscending:true},{name:"cpu",getValue:item=>item.cpu,isAscending:false},{name:"memory",getValue:item=>item.memory,isAscending:false}],"cpu",setSortBy);const currentItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>processList.sort((a,b)=>STATE_ORDER.indexOf(a.state)-STATE_ORDER.indexOf(b.state)),[processList]);if(isLoading)return external_kbnSharedDeps_React_default.a.createElement(processes_table_LoadingPlaceholder,null);if(currentItems.length===0)return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"search",titleSize:"s",title:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.noProcesses",{defaultMessage:"No processes found"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.nodeDetails.noProcessesBody",defaultMessage:"Try modifying your filter. Only processes that are within the configured {metricbeatDocsLink} will display here.",values:{metricbeatDocsLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/beats/metricbeat/current/metricbeat-module-system.html",target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.nodeDetails.noProcessesBody.metricbeatDocsLinkText",defaultMessage:"top N by CPU or Memory"}))}})),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:clearSearchBar},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.noProcessesClearFilters",{defaultMessage:"Clear filters"}))});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTable"],{responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableHeaderCell"],{width:24}),processes_table_columns.map(column=>{var _column$align;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableHeaderCell"],{key:`${String(column.field)}-header`,align:(_column$align=column.align)!==null&&_column$align!==void 0?_column$align:external_kbnSharedDeps_ElasticEui_["LEFT_ALIGNMENT"],width:column.width,onSort:column.sortable?()=>updateSortableProperties(column.field):undefined,isSorted:sortBy.name===column.field,isSortAscending:sortBy.name===column.field&&sortBy.isAscending},column.name)})),external_kbnSharedDeps_React_default.a.createElement(StyledTableBody,null,external_kbnSharedDeps_React_default.a.createElement(ProcessesTableBody,{items:currentItems,currentTime:currentTime}))))};const processes_table_LoadingPlaceholder=()=>external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%",height:"200px",padding:"16px",display:"flex",alignItems:"center",justifyContent:"center"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl"}));const ProcessesTableBody=({items:items,currentTime:currentTime})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,items.map((item,i)=>{const cells=processes_table_columns.map(column=>{var _column$align2,_column$textOnly;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableRowCell"],{key:`${String(column.field)}-${i}`,header:column.name,align:(_column$align2=column.align)!==null&&_column$align2!==void 0?_column$align2:external_kbnSharedDeps_ElasticEui_["LEFT_ALIGNMENT"],textOnly:(_column$textOnly=column.textOnly)!==null&&_column$textOnly!==void 0?_column$textOnly:true},column.render?column.render(item[column.field],currentTime):item[column.field])});return external_kbnSharedDeps_React_default.a.createElement(ProcessRow,{cells:cells,item:item,key:`row-${i}`})}));const StyledTableBody=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiTableBody"])`
  & .euiTableCellContent {
    padding-top: 0;
    padding-bottom: 0;
    
  }
`;const ONE_MINUTE=60*1e3;const processes_table_ONE_HOUR=ONE_MINUTE*60;const RuntimeCell=({startTime:startTime,currentTime:currentTime})=>{const runtimeLength=currentTime-startTime;let remainingRuntimeMS=runtimeLength;const runtimeHours=Math.floor(remainingRuntimeMS/processes_table_ONE_HOUR);remainingRuntimeMS-=runtimeHours*processes_table_ONE_HOUR;const runtimeMinutes=Math.floor(remainingRuntimeMS/ONE_MINUTE);remainingRuntimeMS-=runtimeMinutes*ONE_MINUTE;const runtimeSeconds=Math.floor(remainingRuntimeMS/1e3);remainingRuntimeMS-=runtimeSeconds*1e3;const runtimeDisplayHours=runtimeHours?`${runtimeHours}:`:"";const runtimeDisplayMinutes=runtimeMinutes<10?`0${runtimeMinutes}:`:`${runtimeMinutes}:`;const runtimeDisplaySeconds=runtimeSeconds<10?`0${runtimeSeconds}`:runtimeSeconds;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,`${runtimeDisplayHours}${runtimeDisplayMinutes}${runtimeDisplaySeconds}`)};const processes_table_columns=[{field:"state",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.columnLabelState",{defaultMessage:"State"}),sortable:false,render:state=>external_kbnSharedDeps_React_default.a.createElement(StateBadge,{state:state}),width:84,textOnly:false},{field:"command",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.columnLabelCommand",{defaultMessage:"Command"}),sortable:false,width:"40%",render:command=>external_kbnSharedDeps_React_default.a.createElement(CodeLine,null,command)},{field:"startTime",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.columnLabelTime",{defaultMessage:"Time"}),align:external_kbnSharedDeps_ElasticEui_["RIGHT_ALIGNMENT"],sortable:true,render:(startTime,currentTime)=>external_kbnSharedDeps_React_default.a.createElement(RuntimeCell,{startTime:startTime,currentTime:currentTime})},{field:"cpu",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.columnLabelCPU",{defaultMessage:"CPU"}),sortable:true,render:value=>formatters["a"].percent(value)},{field:"memory",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processes.columnLabelMemory",{defaultMessage:"Mem."}),sortable:true,render:value=>formatters["a"].percent(value)}];const CodeLine=common_["euiStyled"].div`
  font-family: ${props=>props.theme.eui.euiCodeFontFamily};
  font-size: ${props=>props.theme.eui.euiFontSizeS};
  white-space: pre;
  overflow: hidden;
  text-overflow: ellipsis;
`;const parseSearchString=query=>{if(query.trim()===""){return[{match_all:{}}]}const elements=query.split(" ").map(s=>s.trim()).filter(Boolean);const stateFilter=elements.filter(s=>s.startsWith("state="));const cmdlineFilters=elements.filter(s=>!s.startsWith("state="));return[...cmdlineFilters.map(clause=>({query_string:{fields:["system.process.cmdline"],query:`*${escapeReservedCharacters(clause)}*`,minimum_should_match:1}})),...stateFilter.map(state=>({match:{"system.process.state":state.replace("state=","")}}))]};const escapeReservedCharacters=clause=>clause.replace(/([+-=!\(\)\{\}\[\]^"~*?:\\/!]|&&|\|\|)/g,"\\$1");const processes_TabComponent=({currentTime:currentTime,node:node,nodeType:nodeType,options:options})=>{var _ref,_response$processList;const[searchBarState,setSearchBarState]=Object(external_kbnSharedDeps_React_["useState"])(external_kbnSharedDeps_ElasticEui_["Query"].MATCH_ALL);const[searchFilter,setSearchFilter]=Object(external_kbnSharedDeps_React_["useState"])("");const[sortBy,setSortBy]=Object(external_kbnSharedDeps_React_["useState"])({name:"cpu",isAscending:false});const timefield=options.fields.timestamp;const hostTerm=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const field=options.fields&&Reflect.has(options.fields,nodeType)?Reflect.get(options.fields,nodeType):nodeType;return{[field]:node.name}},[options,node,nodeType]);const{loading:loading,error:error,response:response,makeRequest:reload}=useProcessList(hostTerm,timefield,currentTime,sortBy,parseSearchString(searchFilter));const debouncedSearchOnChange=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_Lodash_["debounce"])(queryText=>setSearchFilter(queryText),500),[setSearchFilter]);const searchBarOnChange=Object(external_kbnSharedDeps_React_["useCallback"])(({query:query,queryText:queryText})=>{setSearchBarState(query);debouncedSearchOnChange(queryText)},[setSearchBarState,debouncedSearchOnChange]);const clearSearchBar=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setSearchBarState(external_kbnSharedDeps_ElasticEui_["Query"].MATCH_ALL);setSearchFilter("")},[setSearchBarState,setSearchFilter]);return external_kbnSharedDeps_React_default.a.createElement(shared_TabContent,null,external_kbnSharedDeps_React_default.a.createElement(ProcessListContextProvider,{hostTerm:hostTerm,to:currentTime,timefield:timefield},external_kbnSharedDeps_React_default.a.createElement(SummaryTable,{isLoading:loading,processSummary:(_ref=!error?response===null||response===void 0?void 0:response.summary:null)!==null&&_ref!==void 0?_ref:{total:0}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processesHeader",{defaultMessage:"Top processes"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processesHeader.tooltipLabel",{defaultMessage:"More info"}),size:"m",type:"iInCircle",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processesHeader.tooltipBody",{defaultMessage:"The table below aggregates the top CPU and top memory consuming processes. It does not display all processes."})}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSearchBar"],{query:searchBarState,onChange:searchBarOnChange,box:{incremental:true,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.searchForProcesses",{defaultMessage:"Search for processes…"})},filters:[{type:"field_value_selection",field:"state",name:"State",operator:"exact",multiSelect:false,options:Object.entries(STATE_NAMES).map(([value,view])=>({value:value,view:view}))}]}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),!error?external_kbnSharedDeps_React_default.a.createElement(ProcessesTable,{currentTime:currentTime,isLoading:loading||!response,processList:(_response$processList=response===null||response===void 0?void 0:response.processList)!==null&&_response$processList!==void 0?_response$processList:[],sortBy:sortBy,setSortBy:setSortBy,clearSearchBar:clearSearchBar}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"alert",title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processListError",{defaultMessage:"Unable to load process data"})),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",fill:true,onClick:reload},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.processListRetry",{defaultMessage:"Try again"}))})))};const ProcessesTab={id:"processes",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.nodeDetails.tabs.processes",{defaultMessage:"Processes"}),content:processes_TabComponent};var metadata_api=__webpack_require__(193);var inventory_models_metrics=__webpack_require__(208);const getFilteredMetrics=(requiredMetrics,metadata)=>{const metricMetadata=metadata.filter(data=>data&&data.source==="metrics").map(data=>data&&data.name);return requiredMetrics.filter(metric=>{const metricModelCreator=inventory_models_metrics["a"].tsvb[metric];const metricModel=metricModelCreator("@timestamp","test",">=1m");return metricMetadata.some(m=>m&&metricModel.requires.includes(m))})};function useMetadata(nodeId,nodeType,requiredMetrics,sourceId,timeRange){const decodeResponse=response=>Object(pipeable["pipe"])(metadata_api["a"].decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/infra/metadata","POST",JSON.stringify({nodeId:nodeId,nodeType:nodeType,sourceId:sourceId,timeRange:{from:timeRange.from,to:timeRange.to}}),decodeResponse);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{await makeRequest()})()},[makeRequest]);return{name:response&&response.name||"",filteredRequiredMetrics:response&&getFilteredMetrics(requiredMetrics,response.features)||[],error:error&&error.message||null,loading:loading,metadata:response,cloudId:response&&response.info&&response.info.cloud&&response.info.cloud.instance&&response.info.cloud.instance.id||""}}const getFields=(metadata,group)=>{var _metadata$info,_metadata$info$host,_metadata$info2,_metadata$info2$host,_metadata$info3,_metadata$info3$host,_metadata$info4,_metadata$info4$host,_metadata$info5,_metadata$info5$host,_metadata$info6,_metadata$info6$host,_metadata$info7,_metadata$info7$host,_metadata$info7$host$,_metadata$info8,_metadata$info8$host,_metadata$info8$host$,_metadata$info9,_metadata$info9$host,_metadata$info9$host$,_metadata$info10,_metadata$info10$host,_metadata$info10$host2,_metadata$info11,_metadata$info11$host,_metadata$info11$host2,_metadata$info12,_metadata$info12$host,_metadata$info12$host2,_metadata$info13,_metadata$info13$clou,_metadata$info13$clou2,_metadata$info14,_metadata$info14$clou,_metadata$info14$clou2,_metadata$info15,_metadata$info15$clou,_metadata$info16,_metadata$info16$clou,_metadata$info16$clou2,_metadata$info17,_metadata$info17$clou,_metadata$info17$clou2,_metadata$info18,_metadata$info18$clou,_metadata$info18$clou2,_metadata$info19,_metadata$info19$clou,_metadata$info20,_metadata$info20$clou,_metadata$info21,_metadata$info21$agen,_metadata$info22,_metadata$info22$agen,_metadata$info23,_metadata$info23$agen;switch(group){case"host":return prune([{name:"host.architecture",value:(_metadata$info=metadata.info)===null||_metadata$info===void 0?void 0:(_metadata$info$host=_metadata$info.host)===null||_metadata$info$host===void 0?void 0:_metadata$info$host.architecture},{name:"host.hostname",value:(_metadata$info2=metadata.info)===null||_metadata$info2===void 0?void 0:(_metadata$info2$host=_metadata$info2.host)===null||_metadata$info2$host===void 0?void 0:_metadata$info2$host.name},{name:"host.id",value:(_metadata$info3=metadata.info)===null||_metadata$info3===void 0?void 0:(_metadata$info3$host=_metadata$info3.host)===null||_metadata$info3$host===void 0?void 0:_metadata$info3$host.id},{name:"host.ip",value:(_metadata$info4=metadata.info)===null||_metadata$info4===void 0?void 0:(_metadata$info4$host=_metadata$info4.host)===null||_metadata$info4$host===void 0?void 0:_metadata$info4$host.ip},{name:"host.mac",value:(_metadata$info5=metadata.info)===null||_metadata$info5===void 0?void 0:(_metadata$info5$host=_metadata$info5.host)===null||_metadata$info5$host===void 0?void 0:_metadata$info5$host.mac},{name:"host.name",value:(_metadata$info6=metadata.info)===null||_metadata$info6===void 0?void 0:(_metadata$info6$host=_metadata$info6.host)===null||_metadata$info6$host===void 0?void 0:_metadata$info6$host.name},{name:"host.os.build",value:(_metadata$info7=metadata.info)===null||_metadata$info7===void 0?void 0:(_metadata$info7$host=_metadata$info7.host)===null||_metadata$info7$host===void 0?void 0:(_metadata$info7$host$=_metadata$info7$host.os)===null||_metadata$info7$host$===void 0?void 0:_metadata$info7$host$.build},{name:"host.os.family",value:(_metadata$info8=metadata.info)===null||_metadata$info8===void 0?void 0:(_metadata$info8$host=_metadata$info8.host)===null||_metadata$info8$host===void 0?void 0:(_metadata$info8$host$=_metadata$info8$host.os)===null||_metadata$info8$host$===void 0?void 0:_metadata$info8$host$.family},{name:"host.os.name",value:(_metadata$info9=metadata.info)===null||_metadata$info9===void 0?void 0:(_metadata$info9$host=_metadata$info9.host)===null||_metadata$info9$host===void 0?void 0:(_metadata$info9$host$=_metadata$info9$host.os)===null||_metadata$info9$host$===void 0?void 0:_metadata$info9$host$.name},{name:"host.os.kernel",value:(_metadata$info10=metadata.info)===null||_metadata$info10===void 0?void 0:(_metadata$info10$host=_metadata$info10.host)===null||_metadata$info10$host===void 0?void 0:(_metadata$info10$host2=_metadata$info10$host.os)===null||_metadata$info10$host2===void 0?void 0:_metadata$info10$host2.kernel},{name:"host.os.platform",value:(_metadata$info11=metadata.info)===null||_metadata$info11===void 0?void 0:(_metadata$info11$host=_metadata$info11.host)===null||_metadata$info11$host===void 0?void 0:(_metadata$info11$host2=_metadata$info11$host.os)===null||_metadata$info11$host2===void 0?void 0:_metadata$info11$host2.platform},{name:"host.os.version",value:(_metadata$info12=metadata.info)===null||_metadata$info12===void 0?void 0:(_metadata$info12$host=_metadata$info12.host)===null||_metadata$info12$host===void 0?void 0:(_metadata$info12$host2=_metadata$info12$host.os)===null||_metadata$info12$host2===void 0?void 0:_metadata$info12$host2.version}]);case"cloud":return prune([{name:"cloud.account.id",value:(_metadata$info13=metadata.info)===null||_metadata$info13===void 0?void 0:(_metadata$info13$clou=_metadata$info13.cloud)===null||_metadata$info13$clou===void 0?void 0:(_metadata$info13$clou2=_metadata$info13$clou.account)===null||_metadata$info13$clou2===void 0?void 0:_metadata$info13$clou2.id},{name:"cloud.account.name",value:(_metadata$info14=metadata.info)===null||_metadata$info14===void 0?void 0:(_metadata$info14$clou=_metadata$info14.cloud)===null||_metadata$info14$clou===void 0?void 0:(_metadata$info14$clou2=_metadata$info14$clou.account)===null||_metadata$info14$clou2===void 0?void 0:_metadata$info14$clou2.name},{name:"cloud.availability_zone",value:(_metadata$info15=metadata.info)===null||_metadata$info15===void 0?void 0:(_metadata$info15$clou=_metadata$info15.cloud)===null||_metadata$info15$clou===void 0?void 0:_metadata$info15$clou.availability_zone},{name:"cloud.instance.id",value:(_metadata$info16=metadata.info)===null||_metadata$info16===void 0?void 0:(_metadata$info16$clou=_metadata$info16.cloud)===null||_metadata$info16$clou===void 0?void 0:(_metadata$info16$clou2=_metadata$info16$clou.instance)===null||_metadata$info16$clou2===void 0?void 0:_metadata$info16$clou2.id},{name:"cloud.instance.name",value:(_metadata$info17=metadata.info)===null||_metadata$info17===void 0?void 0:(_metadata$info17$clou=_metadata$info17.cloud)===null||_metadata$info17$clou===void 0?void 0:(_metadata$info17$clou2=_metadata$info17$clou.instance)===null||_metadata$info17$clou2===void 0?void 0:_metadata$info17$clou2.name},{name:"cloud.machine.type",value:(_metadata$info18=metadata.info)===null||_metadata$info18===void 0?void 0:(_metadata$info18$clou=_metadata$info18.cloud)===null||_metadata$info18$clou===void 0?void 0:(_metadata$info18$clou2=_metadata$info18$clou.machine)===null||_metadata$info18$clou2===void 0?void 0:_metadata$info18$clou2.type},{name:"cloud.provider",value:(_metadata$info19=metadata.info)===null||_metadata$info19===void 0?void 0:(_metadata$info19$clou=_metadata$info19.cloud)===null||_metadata$info19$clou===void 0?void 0:_metadata$info19$clou.provider},{name:"cloud.region",value:(_metadata$info20=metadata.info)===null||_metadata$info20===void 0?void 0:(_metadata$info20$clou=_metadata$info20.cloud)===null||_metadata$info20$clou===void 0?void 0:_metadata$info20$clou.region}]);case"agent":return prune([{name:"agent.id",value:(_metadata$info21=metadata.info)===null||_metadata$info21===void 0?void 0:(_metadata$info21$agen=_metadata$info21.agent)===null||_metadata$info21$agen===void 0?void 0:_metadata$info21$agen.id},{name:"agent.version",value:(_metadata$info22=metadata.info)===null||_metadata$info22===void 0?void 0:(_metadata$info22$agen=_metadata$info22.agent)===null||_metadata$info22$agen===void 0?void 0:_metadata$info22$agen.version},{name:"agent.policy",value:(_metadata$info23=metadata.info)===null||_metadata$info23===void 0?void 0:(_metadata$info23$agen=_metadata$info23.agent)===null||_metadata$info23$agen===void 0?void 0:_metadata$info23$agen.policy}])}};const prune=fields=>fields.filter(f=>!!f.value);var react_intl_lib=__webpack_require__(265);const Table=props=>{const{rows:rows,title:title,onClick:onClick}=props;const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{field:"name",name:"",width:"35%",sortable:false,render:(name,item)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("strong",null,item.name))},{field:"value",name:"",width:"65%",sortable:false,render:(_name,item)=>external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.setFilterTooltip",{defaultMessage:"View event with filter"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{color:"subdued",size:"s",iconType:"filter","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.filterAriaLabel",{defaultMessage:"Filter"}),onClick:()=>onClick(item)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,!Array.isArray(item.value)&&item.value,Array.isArray(item.value)&&external_kbnSharedDeps_React_default.a.createElement(ArrayValue,{values:item.value}))))}],[onClick]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(table_TableWithoutHeader,{tableLayout:"fixed",compressed:true,responsive:false,columns:columns,items:rows}))};class table_TableWithoutHeader extends external_kbnSharedDeps_ElasticEui_["EuiBasicTable"]{renderTableHead(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null)}}const ArrayValue=props=>{const{values:values}=props;const[isExpanded,setIsExpanded]=Object(external_kbnSharedDeps_React_["useState"])(false);const expand=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsExpanded(true)},[]);const collapse=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsExpanded(false)},[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!isExpanded&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",responsive:false,alignItems:"baseline",wrap:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},Object(external_kbnSharedDeps_Lodash_["first"])(values)," ... "),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:expand},external_kbnSharedDeps_React_default.a.createElement(react_intl_lib["FormattedMessage"],{id:"xpack.infra.nodeDetails.tabs.metadata.seeMore",defaultMessage:"+{count} more",values:{count:values.length}})))),isExpanded&&external_kbnSharedDeps_React_default.a.createElement("div",null,values.map(v=>external_kbnSharedDeps_React_default.a.createElement("div",{key:v},v)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:collapse},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.seeLess",{defaultMessage:"Show less"}))))};const properties_TabComponent=props=>{const nodeId=props.node.id;const nodeType=props.nodeType;const inventoryModel=Object(inventory_models["b"])(nodeType);const{sourceId:sourceId}=Object(external_kbnSharedDeps_React_["useContext"])(containers_source["a"].Context);const{currentTimeRange:currentTimeRange}=useWaffleTimeContext();const{applyFilterQuery:applyFilterQuery}=useWaffleFiltersContext();const{loading:metadataLoading,metadata:metadata}=useMetadata(nodeId,nodeType,inventoryModel.requiredMetrics,sourceId,currentTimeRange);const hostFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!metadata)return null;return getFields(metadata,"host")},[metadata]);const cloudFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!metadata)return null;return getFields(metadata,"cloud")},[metadata]);const agentFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!metadata)return null;return getFields(metadata,"agent")},[metadata]);const onFilter=Object(external_kbnSharedDeps_React_["useCallback"])(item=>{applyFilterQuery({kind:"kuery",expression:`${item.name}: "${item.value}"`})},[applyFilterQuery]);if(metadataLoading){return external_kbnSharedDeps_React_default.a.createElement(properties_LoadingPlaceholder,null)}return external_kbnSharedDeps_React_default.a.createElement(shared_TabContent,null,hostFields&&hostFields.length>0&&external_kbnSharedDeps_React_default.a.createElement(TableWrapper,null,external_kbnSharedDeps_React_default.a.createElement(Table,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.hostsHeader",{defaultMessage:"Hosts"}),onClick:onFilter,rows:hostFields})),cloudFields&&cloudFields.length>0&&external_kbnSharedDeps_React_default.a.createElement(TableWrapper,null,external_kbnSharedDeps_React_default.a.createElement(Table,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.cloudHeader",{defaultMessage:"Cloud"}),onClick:onFilter,rows:cloudFields})),agentFields&&agentFields.length>0&&external_kbnSharedDeps_React_default.a.createElement(TableWrapper,null,external_kbnSharedDeps_React_default.a.createElement(Table,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.agentHeader",{defaultMessage:"Agent"}),onClick:onFilter,rows:agentFields})))};const TableWrapper=common_["euiStyled"].div`
  &:not(:last-child) {
    margin-bottom: 16px
  }
`;const properties_LoadingPlaceholder=()=>external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"100%",height:"200px",padding:"16px",display:"flex",alignItems:"center",justifyContent:"center"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl"}));const PropertiesTab={id:"properties",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.tabs.metadata.title",{defaultMessage:"Metadata"}),content:properties_TabComponent};const createUptimeLink=(options,nodeType,node)=>{if(nodeType==="host"&&node.ip){return{app:"uptime",hash:"/",search:{search:`host.ip:"${node.ip}"`}}}const field=Object(external_kbnSharedDeps_Lodash_["get"])(options,["fields",nodeType],"");return{app:"uptime",hash:"/",search:{search:`${field?field+":":""}"${node.id}"`}}};const NodeContextPopover=({isOpen:isOpen,node:node,nodeType:nodeType,currentTime:currentTime,options:options,onClose:onClose,openAlertFlyout:openAlertFlyout})=>{const tabConfigs=[MetricsTab,LogsTab,ProcessesTab,PropertiesTab];const inventoryModel=Object(inventory_models["b"])(nodeType);const nodeDetailFrom=currentTime-inventoryModel.metrics.defaultTimeRangeInSeconds*1e3;const tabs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>tabConfigs.map(m=>{const TabContent=m.content;return{...m,content:external_kbnSharedDeps_React_default.a.createElement(TabContent,{node:node,nodeType:nodeType,currentTime:currentTime,options:options})}}),[tabConfigs,node,nodeType,currentTime,options]);const[selectedTab,setSelectedTab]=Object(external_kbnSharedDeps_React_["useState"])(0);const nodeDetailMenuItemLinkProps=Object(use_link_props["b"])({...getNodeDetailUrl({nodeType:nodeType,nodeId:node.id,from:nodeDetailFrom,to:currentTime})});const apmField=nodeType==="host"?"host.hostname":inventoryModel.fields.id;const apmTracesMenuItemLinkProps=Object(use_link_props["b"])({app:"apm",hash:"traces",search:{kuery:`${apmField}:"${node.id}"`}});const uptimeMenuItemLinkProps=Object(use_link_props["b"])(createUptimeLink(options,nodeType,node));if(!isOpen){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiOutsideClickDetector"],{onOutsideClick:onClose},external_kbnSharedDeps_React_default.a.createElement(OverlayPanel,null,external_kbnSharedDeps_React_default.a.createElement(OverlayHeader,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(OverlayTitle,{grow:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,node.name))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:openAlertFlyout,size:"xs",iconSide:"left",flush:"both",iconType:"bell"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.infra.nodeDetails.createAlertLink",defaultMessage:"Create alert"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconSide:"left",iconType:"popout",href:nodeDetailMenuItemLinkProps.href,flush:"both"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.infra.nodeDetails.openAsPage",defaultMessage:"Open as page"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{size:"s",onClick:onClose,iconType:"cross"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],{size:"s"},tabs.map((tab,i)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{key:tab.id,isSelected:i===selectedTab,onClick:()=>setSelectedTab(i)},tab.name)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],apmTracesMenuItemLinkProps,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"popout"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.infra.nodeDetails.apmTabLabel",defaultMessage:"APM"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],uptimeMenuItemLinkProps,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"popout"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.infra.nodeDetails.updtimeTabLabel",defaultMessage:"Uptime"})))),tabs[selectedTab].content)))};const OverlayHeader=common_["euiStyled"].div`
  padding-top: ${props=>props.theme.eui.paddingSizes.m};
  padding-right: ${props=>props.theme.eui.paddingSizes.m};
  padding-left: ${props=>props.theme.eui.paddingSizes.m};
  background-color: ${props=>props.theme.eui.euiPageBackgroundColor};
  box-shadow: inset 0 -1px ${props=>props.theme.eui.euiBorderColor};
`;const OverlayPanel=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).attrs({paddingSize:"none"})`
  display: flex;
  flex-direction: column;
  position: absolute;
  right: 16px;
  top: ${OVERLAY_Y_START}px;
  width: 100%;
  max-width: 720px;
  z-index: 2;
  max-height: calc(100vh - ${OVERLAY_Y_START+OVERLAY_BOTTOM_MARGIN}px);
  overflow: hidden;

  @media (max-width: 752px) {
    border-radius: 0px !important;
    left: 0px;
    right: 0px;
    top: 97px;
    bottom: 0;
    max-height: calc(100vh - 97px);
    max-width: 100%;
  }
`;const OverlayTitle=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"])`
  overflow: hidden;
  & h4 {
    text-overflow: ellipsis;
    overflow: hidden;
    white-space: nowrap;
  }
`;const alert_flyout_AlertFlyout=({options:options,nodeType:nodeType,filter:filter,visible:visible,setVisible:setVisible})=>{const{triggersActionsUI:triggersActionsUI}=Object(external_kbnSharedDeps_React_["useContext"])(triggers_actions_context["a"]);const{inventoryPrefill:inventoryPrefill}=Object(use_alert_prefill["b"])();const{customMetrics:customMetrics}=inventoryPrefill;const onCloseFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setVisible(false),[setVisible]);const AddAlertFlyout=Object(external_kbnSharedDeps_React_["useMemo"])(()=>triggersActionsUI&&triggersActionsUI.getAddAlertFlyout({consumer:"infrastructure",onClose:onCloseFlyout,canChangeTrigger:false,alertTypeId:alerting_metrics["d"],metadata:{options:options,nodeType:nodeType,filter:filter,customMetrics:customMetrics}}),[triggersActionsUI,visible]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,visible&&AddAlertFlyout)};const PrefilledInventoryAlertFlyout=({onClose:onClose})=>{const{inventoryPrefill:inventoryPrefill}=Object(use_alert_prefill["b"])();const{nodeType:nodeType,metric:metric,filterQuery:filterQuery}=inventoryPrefill;return external_kbnSharedDeps_React_default.a.createElement(alert_flyout_AlertFlyout,{options:{metric:metric},nodeType:nodeType,filter:filterQuery,visible:true,setVisible:onClose})};function node_context_menu_extends(){node_context_menu_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return node_context_menu_extends.apply(this,arguments)}const NodeContextMenu=Object(common_["withTheme"])(({options:options,currentTime:currentTime,children:children,node:node,isPopoverOpen:isPopoverOpen,closePopover:closePopover,nodeType:nodeType,popoverPosition:popoverPosition,theme:theme,openNewOverlay:openNewOverlay})=>{var _useKibana$services$a,_uiCapabilities$logs;const[flyoutVisible,setFlyoutVisible]=Object(external_kbnSharedDeps_React_["useState"])(false);const inventoryModel=Object(inventory_models["b"])(nodeType);const nodeDetailFrom=currentTime-inventoryModel.metrics.defaultTimeRangeInSeconds*1e3;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const apmField=nodeType==="host"?"host.hostname":inventoryModel.fields.id;const showDetail=inventoryModel.crosslinkSupport.details;const showLogsLink=inventoryModel.crosslinkSupport.logs&&node.id&&(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$logs=uiCapabilities.logs)===null||_uiCapabilities$logs===void 0?void 0:_uiCapabilities$logs.show);const showAPMTraceLink=inventoryModel.crosslinkSupport.apm&&(uiCapabilities===null||uiCapabilities===void 0?void 0:uiCapabilities.apm)&&(uiCapabilities===null||uiCapabilities===void 0?void 0:uiCapabilities.apm.show);const showUptimeLink=inventoryModel.crosslinkSupport.uptime&&(["pod","container"].includes(nodeType)||node.ip);const inventoryId=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(nodeType==="host"){if(node.ip){return{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"host.ip"),value:node.ip}}}else{if(options.fields){const{id:id}=Object(inventory_models["a"])(nodeType,options.fields);return{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,id),value:node.id}}}return{label:"",value:""}},[nodeType,node.ip,node.id,options.fields]);const nodeLogsMenuItemLinkProps=Object(use_link_props["b"])(Object(redirect_to_node_logs["b"])({nodeType:nodeType,nodeId:node.id,time:currentTime}));const nodeDetailMenuItemLinkProps=Object(use_link_props["b"])({...getNodeDetailUrl({nodeType:nodeType,nodeId:node.id,from:nodeDetailFrom,to:currentTime})});const apmTracesMenuItemLinkProps=Object(use_link_props["b"])({app:"apm",hash:"traces",search:{kuery:`${apmField}:"${node.id}"`}});const uptimeMenuItemLinkProps=Object(use_link_props["b"])(createUptimeLink(options,nodeType,node));const nodeLogsMenuItem={label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeContextMenu.viewLogsName",{defaultMessage:"{inventoryName} logs",values:{inventoryName:inventoryModel.singularDisplayName}}),...nodeLogsMenuItemLinkProps,"data-test-subj":"viewLogsContextMenuItem",isDisabled:!showLogsLink};const nodeDetailMenuItem={label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeContextMenu.viewMetricsName",{defaultMessage:"{inventoryName} metrics",values:{inventoryName:inventoryModel.singularDisplayName}}),...nodeDetailMenuItemLinkProps,isDisabled:!showDetail};const apmTracesMenuItem={label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeContextMenu.viewAPMTraces",{defaultMessage:"{inventoryName} APM traces",values:{inventoryName:inventoryModel.singularDisplayName}}),...apmTracesMenuItemLinkProps,"data-test-subj":"viewApmTracesContextMenuItem",isDisabled:!showAPMTraceLink};const uptimeMenuItem={label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeContextMenu.viewUptimeLink",{defaultMessage:"{inventoryName} in Uptime",values:{inventoryName:inventoryModel.singularDisplayName}}),...uptimeMenuItemLinkProps,isDisabled:!showUptimeLink};const createAlertMenuItem={label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeContextMenu.createAlertLink",{defaultMessage:"Create alert"}),style:{color:(theme===null||theme===void 0?void 0:theme.eui.euiLinkColor)||"#006BB4",fontWeight:500,padding:0},onClick:()=>{setFlyoutVisible(true)}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(observability_public_["ActionMenu"],{closePopover:closePopover,id:`${node.pathId}-popover`,isOpen:isPopoverOpen,button:children,anchorPosition:popoverPosition},external_kbnSharedDeps_React_default.a.createElement("div",{style:{maxWidth:300},"data-test-subj":"nodeContextMenu"},external_kbnSharedDeps_React_default.a.createElement(observability_public_["Section"],null,external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.nodeContextMenu.title",defaultMessage:"{inventoryName} details",values:{inventoryName:inventoryModel.singularDisplayName}})),inventoryId.label&&external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionSubtitle"],null,external_kbnSharedDeps_React_default.a.createElement("div",{style:{wordBreak:"break-all"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.nodeContextMenu.description",defaultMessage:"View details for {label} {value}",values:{label:inventoryId.label,value:inventoryId.value}}))),external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionLinks"],null,external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionLink"],node_context_menu_extends({"data-test-subj":"viewLogsContextMenuItem"},nodeLogsMenuItem)),external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionLink"],nodeDetailMenuItem),external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionLink"],node_context_menu_extends({"data-test-subj":"viewApmTracesContextMenuItem"},apmTracesMenuItem)),external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionLink"],uptimeMenuItem),external_kbnSharedDeps_React_default.a.createElement(observability_public_["SectionLink"],createAlertMenuItem))))),external_kbnSharedDeps_React_default.a.createElement(alert_flyout_AlertFlyout,{filter:options.fields?`${Object(inventory_models["a"])(nodeType,options.fields).id}: "${node.id}"`:"",options:options,nodeType:nodeType,setVisible:setFlyoutVisible,visible:flyoutVisible}))});function node_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const initialState={isPopoverOpen:false,isOverlayOpen:false,isAlertFlyoutVisible:false};class node_Node extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(...args){super(...args);node_defineProperty(this,"state",initialState);node_defineProperty(this,"openAlertFlyout",()=>{this.setState({isOverlayOpen:false,isAlertFlyoutVisible:true})});node_defineProperty(this,"setAlertFlyoutVisible",isOpen=>{this.setState({isAlertFlyoutVisible:isOpen})});node_defineProperty(this,"togglePopover",()=>{const{nodeType:nodeType}=this.props;if(nodeType==="host"){this.toggleNewOverlay()}else{this.setState(prevState=>({isPopoverOpen:!prevState.isPopoverOpen}))}});node_defineProperty(this,"toggleNewOverlay",()=>{this.setState(prevState=>({isPopoverOpen:!prevState.isOverlayOpen===true?false:prevState.isPopoverOpen,isOverlayOpen:!prevState.isOverlayOpen}))});node_defineProperty(this,"closePopover",()=>{if(this.state.isPopoverOpen){this.setState({isPopoverOpen:false})}})}render(){const{nodeType:nodeType,node:node,options:options,squareSize:squareSize,bounds:bounds,formatter:formatter,currentTime:currentTime}=this.props;const{isPopoverOpen:isPopoverOpen,isAlertFlyoutVisible:isAlertFlyoutVisible}=this.state;const metric=Object(external_kbnSharedDeps_Lodash_["first"])(node.metrics);const valueMode=squareSize>70;const ellipsisMode=squareSize>30;const rawValue=metric&&metric.value||0;const color=colorFromValue(options.legend,rawValue,bounds);const value=formatter(rawValue);const nodeAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.node.ariaLabel",{defaultMessage:"{nodeName}, click to open menu",values:{nodeName:node.name}});const nodeBorder=this.state.isOverlayOpen?{border:"solid 4px #000"}:undefined;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(NodeContextMenu,{node:node,nodeType:nodeType,isPopoverOpen:isPopoverOpen,closePopover:this.closePopover,options:options,currentTime:currentTime,popoverPosition:"downCenter",openNewOverlay:this.toggleNewOverlay},external_kbnSharedDeps_React_default.a.createElement(ConditionalToolTip,{currentTime:currentTime,formatter:formatter,hidden:isPopoverOpen,node:node,options:options,nodeType:nodeType},external_kbnSharedDeps_React_default.a.createElement(NodeContainer,{"data-test-subj":"nodeContainer",style:{width:squareSize||0,height:squareSize||0},onClick:this.togglePopover},external_kbnSharedDeps_React_default.a.createElement(SquareOuter,{color:color,style:nodeBorder},external_kbnSharedDeps_React_default.a.createElement(SquareInner,{color:color},valueMode?external_kbnSharedDeps_React_default.a.createElement(ValueInner,{"aria-label":nodeAriaLabel},external_kbnSharedDeps_React_default.a.createElement(Label,{color:color},node.name),external_kbnSharedDeps_React_default.a.createElement(Value,{color:color},value)):ellipsisMode&&external_kbnSharedDeps_React_default.a.createElement(ValueInner,{"aria-label":nodeAriaLabel},external_kbnSharedDeps_React_default.a.createElement(Label,{color:color},"..."))))))),external_kbnSharedDeps_React_default.a.createElement(NodeContextPopover,{openAlertFlyout:this.openAlertFlyout,node:node,nodeType:nodeType,isOpen:this.state.isOverlayOpen,options:options,currentTime:currentTime,onClose:this.toggleNewOverlay}),external_kbnSharedDeps_React_default.a.createElement(alert_flyout_AlertFlyout,{filter:options.fields?`${Object(inventory_models["a"])(nodeType,options.fields).id}: "${node.id}"`:"",options:options,nodeType:nodeType,setVisible:this.setAlertFlyoutVisible,visible:isAlertFlyoutVisible}))}}const NodeContainer=common_["euiStyled"].div`
  position: relative;
`;const SquareOuter=common_["euiStyled"].div`
  position: absolute;
  top: 4px;
  left: 4px;
  bottom: 4px;
  right: 4px;
  background-color: ${props=>Object(polished_lib["darken"])(.1,props.color)};
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`;const SquareInner=common_["euiStyled"].div`
  cursor: pointer;
  position: absolute;
  top: 0;
  right: 0;
  bottom: 2px;
  left: 0;
  border-radius: 3px;
  background-color: ${props=>props.color};
`;const ValueInner=common_["euiStyled"].button`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  display: flex;
  line-height: 1.2em;
  align-items: center;
  align-content: center;
  padding: 1em;
  overflow: hidden;
  flex-wrap: wrap;
  width: 100%;
  border: none;
  &:focus {
    outline: none !important;
    border: ${params=>{var _params$theme;return(_params$theme=params.theme)===null||_params$theme===void 0?void 0:_params$theme.eui.euiFocusRingSize}} solid
      ${params=>{var _params$theme2;return(_params$theme2=params.theme)===null||_params$theme2===void 0?void 0:_params$theme2.eui.euiFocusRingColor}};
    box-shadow: none;
  }
`;const SquareTextContent=common_["euiStyled"].div`
  text-align: center;
  width: 100%;
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
  flex: 1 0 auto;
  color: ${props=>Object(polished_lib["readableColor"])(props.color)};
`;const Value=Object(common_["euiStyled"])(SquareTextContent)`
  font-weight: bold;
  font-size: 0.9em;
  line-height: 1.2em;
`;const Label=Object(common_["euiStyled"])(SquareTextContent)`
  font-size: 0.7em;
  margin-bottom: 0.7em;
`;const GroupOfNodes=({group:group,options:options,formatter:formatter,onDrilldown:onDrilldown,isChild:isChild=false,bounds:bounds,nodeType:nodeType,currentTime:currentTime})=>{const width=group.width>200?group.width:200;return external_kbnSharedDeps_React_default.a.createElement(GroupOfNodesContainer,{style:{width:width}},external_kbnSharedDeps_React_default.a.createElement(group_name_GroupName,{group:group,onDrilldown:onDrilldown,isChild:isChild,options:options}),external_kbnSharedDeps_React_default.a.createElement(Nodes,null,group.nodes.map(node=>external_kbnSharedDeps_React_default.a.createElement(node_Node,{key:`${node.pathId}:${node.name}`,options:options,squareSize:group.squareSize,node:node,formatter:formatter,bounds:bounds,nodeType:nodeType,currentTime:currentTime}))))};const GroupOfNodesContainer=common_["euiStyled"].div`
  margin: 0 10px;
`;const Nodes=common_["euiStyled"].div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${props=>props.theme.eui.euiBorderColor};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`;const GroupOfGroups=props=>external_kbnSharedDeps_React_default.a.createElement(GroupOfGroupsContainer,null,external_kbnSharedDeps_React_default.a.createElement(group_name_GroupName,{group:props.group,onDrilldown:props.onDrilldown,options:props.options}),external_kbnSharedDeps_React_default.a.createElement(Groups,null,props.group.groups.map(group=>external_kbnSharedDeps_React_default.a.createElement(GroupOfNodes,{isChild:true,key:group.id,onDrilldown:props.onDrilldown,options:props.options,group:group,formatter:props.formatter,bounds:props.bounds,nodeType:props.nodeType,currentTime:props.currentTime}))));const GroupOfGroupsContainer=common_["euiStyled"].div`
  margin: 0 10px;
  width: 100%;
`;const Groups=common_["euiStyled"].div`
  display: flex;
  background-color: rgba(0, 0, 0, 0.05);
  flex-wrap: wrap;
  justify-content: center;
  padding: 20px 10px 10px;
  border-radius: 4px;
  border: 1px solid ${props=>props.theme.eui.euiBorderColor};
  box-shadow: 0 1px 7px rgba(0, 0, 0, 0.1);
`;const SCALE_FACTOR=.55;const MAX_SIZE=Infinity;const MIN_SIZE=24;function sizeOfSquares(width,height,totalItems,levels=1){const levelFactor=levels>1?levels*.7:1;const scale=SCALE_FACTOR/levelFactor;const x=width*scale;const y=height*scale;const possibleX=Math.ceil(Math.sqrt(totalItems*x/y));let newX;let newY;if(Math.floor(possibleX*y/x)*possibleX<totalItems){newX=y/Math.ceil(possibleX*y/x)}else{newX=x/possibleX}const possibleY=Math.ceil(Math.sqrt(totalItems*y/x));if(Math.floor(possibleY*x/y)*possibleY<totalItems){newY=x/Math.ceil(x*possibleY/y)}else{newY=y/possibleY}const size=Math.max(newX,newY);return Math.min(Math.max(size,MIN_SIZE),MAX_SIZE)}function getColumns(n,w=1,h=1){const pageRatio=w/h;const ratio=pageRatio>1.2?1.2:pageRatio;const width=Math.ceil(Math.sqrt(n));return Math.ceil(width*ratio)}function getTotalItems(groups){if(!groups){return 0}return groups.reduce((acc,group)=>{if(isWaffleMapGroupWithGroups(group)){return group.groups.reduce((total,subGroup)=>subGroup.nodes.length+total,acc)}if(isWaffleMapGroupWithNodes(group)){return group.nodes.length+acc}return acc},0)}function getLargestCount(groups){if(!groups){return 0}return groups.reduce((total,group)=>{if(isWaffleMapGroupWithGroups(group)){return group.groups.reduce((subTotal,subGroup)=>{if(isWaffleMapGroupWithNodes(subGroup)){return subTotal>subGroup.nodes.length?subTotal:subGroup.nodes.length}return subTotal},total)}if(isWaffleMapGroupWithNodes(group)){return total>group.nodes.length?total:group.nodes.length}return total},0)}const getTotalItemsOfGroup=group=>getTotalItems([group]);function applyWaffleMapLayout(groups,width,height){if(groups.length===0){return[]}const levels=isWaffleMapGroupWithGroups(Object(external_kbnSharedDeps_Lodash_["first"])(groups))?2:1;const totalItems=getTotalItems(groups);const squareSize=Math.round(sizeOfSquares(width,height,totalItems,levels));const largestCount=getLargestCount(groups);return Object(external_kbnSharedDeps_Lodash_["sortBy"])(groups,getTotalItemsOfGroup).reverse().map(group=>{if(isWaffleMapGroupWithGroups(group)){const columns=getColumns(largestCount,width,height);const groupOfNodes=group.groups;const subGroups=Object(external_kbnSharedDeps_Lodash_["sortBy"])(groupOfNodes,getTotalItemsOfGroup).reverse().filter(isWaffleMapGroupWithNodes).map(subGroup=>({...subGroup,count:subGroup.nodes.length,columns:columns,width:columns*squareSize,squareSize:squareSize}));return{...group,groups:subGroups,count:getTotalItems([group]),squareSize:squareSize}}if(isWaffleMapGroupWithNodes(group)){const columns=getColumns(Math.max(group.nodes.length,largestCount),width,height);return{...group,count:group.nodes.length,squareSize:squareSize,width:columns*squareSize}}return group})}const SORT_PATHS={name:node=>Object(external_kbnSharedDeps_Lodash_["last"])(node.path),value:node=>{const metric=Object(external_kbnSharedDeps_Lodash_["first"])(node.metrics);return metric&&metric.value||0}};const sortNodes=(sort,nodes)=>{const sortPath=SORT_PATHS[sort.by];const sortedNodes=Object(external_kbnSharedDeps_Lodash_["sortBy"])(nodes,sortPath);if(sort.direction==="desc"){return sortedNodes.reverse()}return sortedNodes};const Map=({nodes:nodes,options:options,currentTime:currentTime,onFilter:onFilter,formatter:formatter,bounds:bounds,nodeType:nodeType,dataBounds:dataBounds,bottomMargin:bottomMargin,staticHeight:staticHeight})=>{const sortedNodes=sortNodes(options.sort,nodes);const map=nodesToWaffleMap(sortedNodes);return external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{bounds:true},({measureRef:measureRef,bounds:{width:width=0,height:height=0}})=>{const groupsWithLayout=applyWaffleMapLayout(map,width,height);return external_kbnSharedDeps_React_default.a.createElement(WaffleMapOuterContainer,{ref:el=>measureRef(el),bottomMargin:bottomMargin,"data-test-subj":"waffleMap",staticHeight:staticHeight},external_kbnSharedDeps_React_default.a.createElement(WaffleMapInnerContainer,null,groupsWithLayout.map(group=>{if(isWaffleMapGroupWithGroups(group)){return external_kbnSharedDeps_React_default.a.createElement(GroupOfGroups,{onDrilldown:onFilter,key:group.id,options:options,group:group,formatter:formatter,bounds:bounds,nodeType:nodeType,currentTime:currentTime})}if(isWaffleMapGroupWithNodes(group)){return external_kbnSharedDeps_React_default.a.createElement(GroupOfNodes,{key:group.id,options:options,group:group,onDrilldown:onFilter,formatter:formatter,isChild:false,bounds:bounds,nodeType:nodeType,currentTime:currentTime})}})))})};const WaffleMapOuterContainer=common_["euiStyled"].div`
  flex: 1 0 0%;
  display: flex;
  justify-content: flex-start;
  flex-direction: column;
  overflow-x: hidden;
  overflow-y: auto;
  margin-bottom: ${props=>props.bottomMargin}px;
  ${props=>props.staticHeight&&"min-height: 300px;"}
`;const WaffleMapInnerContainer=common_["euiStyled"].div`
  display: flex;
  flex-direction: row;
  flex-wrap: wrap;
  justify-content: center;
  align-content: flex-start;
  padding: 10px;
`;var field_to_display_name=__webpack_require__(272);var common_styles=__webpack_require__(203);const getGroupPaths=path=>{switch(path.length){case 3:return path.slice(0,2);case 2:return path.slice(0,1);default:return[]}};const TableView=props=>{const{nodes:nodes,options:options,formatter:formatter,currentTime:currentTime,nodeType:nodeType}=props;const[openPopovers,setOpenPopovers]=Object(external_kbnSharedDeps_React_["useState"])([]);const openPopoverFor=Object(external_kbnSharedDeps_React_["useCallback"])(id=>()=>{setOpenPopovers([...openPopovers,id])},[openPopovers]);const closePopoverFor=Object(external_kbnSharedDeps_React_["useCallback"])(id=>()=>{if(openPopovers.includes(id)){setOpenPopovers(openPopovers.filter(subject=>subject!==id))}},[openPopovers]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const el=document.getElementsByClassName(common_styles["a"])[0];if(el instanceof HTMLElement){if(openPopovers.length>0){el.style.overflowY="hidden"}else{el.style.overflowY="auto"}}},[openPopovers]);const columns=[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.tableView.columnName.name",{defaultMessage:"Name"}),sortable:true,truncateText:true,textOnly:true,render:(value,item)=>{const tooltipText=item.node.id===value?`${value}`:`${value} (${item.node.id})`;const uniqueID=[...item.node.path.map(p=>p.value),item.node.name].join(":");return external_kbnSharedDeps_React_default.a.createElement(NodeContextMenu,{node:item.node,nodeType:nodeType,closePopover:closePopoverFor(uniqueID),currentTime:currentTime,isPopoverOpen:openPopovers.includes(uniqueID),options:options,popoverPosition:"rightCenter"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:tooltipText},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:openPopoverFor(uniqueID)},value)))}},...options.groupBy.map((grouping,index)=>({field:`group_${index}`,name:Object(field_to_display_name["a"])(grouping&&grouping.field||""),sortable:true,truncateText:true,textOnly:true,render:value=>{const handleClick=()=>props.onFilter(`${grouping.field}:"${value}"`);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:"Set Filter"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:handleClick},value))}})),{field:"value",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.tableView.columnName.last1m",{defaultMessage:"Last 1m"}),sortable:true,truncateText:true,dataType:"number",render:value=>external_kbnSharedDeps_React_default.a.createElement("span",null,formatter(value))},{field:"avg",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.tableView.columnName.avg",{defaultMessage:"Avg"}),sortable:true,truncateText:true,dataType:"number",render:value=>external_kbnSharedDeps_React_default.a.createElement("span",null,formatter(value))},{field:"max",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.tableView.columnName.max",{defaultMessage:"Max"}),sortable:true,truncateText:true,dataType:"number",render:value=>external_kbnSharedDeps_React_default.a.createElement("span",null,formatter(value))}];const items=nodes.map(node=>{const name=Object(external_kbnSharedDeps_Lodash_["last"])(node.path);const metric=Object(external_kbnSharedDeps_Lodash_["first"])(node.metrics);return{name:name&&name.label||"unknown",...getGroupPaths(node.path).reduce((acc,path,index)=>({...acc,[`group_${index}`]:path.label}),{}),value:metric&&metric.value||0,avg:metric&&metric.avg||0,max:metric&&metric.max||0,node:createWaffleMapNode(node)}});const initialSorting={sort:{field:"value",direction:"desc"}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{pagination:true,sorting:initialSorting,items:items,columns:columns})};const calculateBoundsFromNodes=nodes=>{const values=nodes.map(node=>{const metric=Object(external_kbnSharedDeps_Lodash_["first"])(node.metrics);return!metric||!metric.value?0:metric.value});if(values.length===1){values.unshift(0)}const maxValue=Object(external_kbnSharedDeps_Lodash_["max"])(values)||0;const minValue=Object(external_kbnSharedDeps_Lodash_["min"])(values)||0;return{min:Object(external_kbnSharedDeps_Lodash_["isFinite"])(minValue)?minValue:0,max:Object(external_kbnSharedDeps_Lodash_["isFinite"])(maxValue)?maxValue:0}};const NodesOverview=({autoBounds:autoBounds,boundsOverride:boundsOverride,loading:loading,nodes:nodes,nodeType:nodeType,reload:reload,view:view,currentTime:currentTime,options:options,formatter:formatter,onDrilldown:onDrilldown,bottomMargin:bottomMargin,topMargin:topMargin,showLoading:showLoading})=>{const handleDrilldown=Object(external_kbnSharedDeps_React_["useCallback"])(filter=>{onDrilldown({kind:"kuery",expression:filter});return},[onDrilldown]);const noData=!loading&&nodes&&nodes.length===0;if(loading&&showLoading){return external_kbnSharedDeps_React_default.a.createElement(components_loading["a"],{height:"100%",width:"100%",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.loadingDataText",{defaultMessage:"Loading data"})})}else if(noData){return external_kbnSharedDeps_React_default.a.createElement(empty_states["a"],{titleText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.noDataTitle",{defaultMessage:"There is no data to display."}),bodyText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.noDataDescription",{defaultMessage:"Try adjusting your time or filter."}),refetchText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.checkNewDataButtonLabel",{defaultMessage:"Check for new data"}),onRefetch:()=>{reload()},testString:"noMetricsDataPrompt"})}const dataBounds=calculateBoundsFromNodes(nodes);const bounds=autoBounds?dataBounds:boundsOverride;const isStatic=["xs","s"].includes(Object(external_kbnSharedDeps_ElasticEui_["getBreakpoint"])(window.innerWidth));if(view==="table"){return external_kbnSharedDeps_React_default.a.createElement(TableContainer,null,external_kbnSharedDeps_React_default.a.createElement(TableView,{nodeType:nodeType,nodes:nodes,options:options,formatter:formatter,currentTime:currentTime,onFilter:handleDrilldown}))}return external_kbnSharedDeps_React_default.a.createElement(MapContainer,{top:topMargin,positionStatic:isStatic},external_kbnSharedDeps_React_default.a.createElement(Map,{nodeType:nodeType,nodes:nodes,options:options,formatter:formatter,currentTime:currentTime,onFilter:handleDrilldown,bounds:bounds,dataBounds:dataBounds,bottomMargin:bottomMargin,staticHeight:isStatic}))};const TableContainer=common_["euiStyled"].div`
  padding: ${props=>props.theme.eui.paddingSizes.l};
`;const MapContainer=common_["euiStyled"].div`
  position: ${props=>props.positionStatic?"static":"absolute"};
  display: flex;
  top: ${props=>props.top}px;
  right: 0;
  bottom: 0;
  left: 0;
`;var toolbar_items=__webpack_require__(273);var container_toolbar_items=__webpack_require__(274);var pod_toolbar_items=__webpack_require__(275);var aws_ec2_toolbar_items=__webpack_require__(276);var aws_s3_toolbar_items=__webpack_require__(277);var aws_rds_toolbar_items=__webpack_require__(278);var aws_sqs_toolbar_items=__webpack_require__(279);const toolbars={host:toolbar_items["a"],container:container_toolbar_items["a"],pod:pod_toolbar_items["a"],awsEC2:aws_ec2_toolbar_items["a"],awsS3:aws_s3_toolbar_items["a"],awsRDS:aws_rds_toolbar_items["a"],awsSQS:aws_sqs_toolbar_items["a"]};const findToolbar=type=>{const Toolbar=toolbars===null||toolbars===void 0?void 0:toolbars[type];if(!Toolbar){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.findToolbar.error",{defaultMessage:"The toolbar you've attempted to find does not exist."}))}return Toolbar};var toolbar_wrapper=__webpack_require__(290);const CloudAccountRT=lib["type"]({value:lib["string"],name:lib["string"]});const InventoryMetaResponseRT=lib["type"]({accounts:lib["array"](CloudAccountRT),projects:lib["array"](lib["string"]),regions:lib["array"](lib["string"])});const InventoryMetaRequestRT=lib["type"]({sourceId:lib["string"],nodeType:types["c"],currentTime:lib["number"]});function useInventoryMeta(sourceId,nodeType,currentTime){const decodeResponse=response=>Object(pipeable["pipe"])(InventoryMetaResponseRT.decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/infra/inventory/meta","POST",JSON.stringify({sourceId:sourceId,nodeType:nodeType,currentTime:currentTime}),decodeResponse);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{makeRequest()},[makeRequest]);return{error:error,loading:loading,accounts:response?response.accounts:[],regions:response?response.regions:[],makeRequest:makeRequest}}function toolbar_extends(){toolbar_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return toolbar_extends.apply(this,arguments)}const wrapToolbarItems=(ToolbarItems,accounts,regions)=>external_kbnSharedDeps_React_default.a.createElement(toolbar_wrapper["a"],null,props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ToolbarItems,toolbar_extends({},props,{accounts:accounts,regions:regions})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true})));const toolbar_Toolbar=({nodeType:nodeType,currentTime:currentTime})=>{const{sourceId:sourceId}=Object(containers_source["b"])();const{accounts:accounts,regions:regions}=useInventoryMeta(sourceId,nodeType,currentTime);const ToolbarItems=findToolbar(nodeType);return wrapToolbarItems(ToolbarItems,accounts,regions)};const ViewSwitcher=({view:view,onChange:onChange})=>{const buttons=[{id:"map",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.viewSwitcher.mapViewLabel",{defaultMessage:"Map view"}),iconType:"apps"},{id:"table",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.viewSwitcher.tableViewLabel",{defaultMessage:"Table view"}),iconType:"visTable"}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{legend:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.viewSwitcher.lenged",{defaultMessage:"Switch between table and map view"}),options:buttons,color:"text",buttonSize:"m",idSelected:view,onChange:onChange,isIconOnly:true})};const IntervalLabel=({intervalAsString:intervalAsString})=>{if(!intervalAsString){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.homePage.toolbar.showingLastOneMinuteDataText",defaultMessage:"Last {duration} of data for the selected time",values:{duration:intervalAsString}})))};const createColorPalette=(name="cool",steps=10)=>{switch(name){case"temperature":return Object(external_kbnSharedDeps_ElasticEui_["euiPaletteForTemperature"])(steps);case"status":return Object(external_kbnSharedDeps_ElasticEui_["euiPaletteForStatus"])(steps);case"warm":return Object(external_kbnSharedDeps_ElasticEui_["euiPaletteWarm"])(steps);case"positive":return Object(external_kbnSharedDeps_ElasticEui_["euiPalettePositive"])(steps);case"negative":return Object(external_kbnSharedDeps_ElasticEui_["euiPaletteNegative"])(steps);default:return Object(external_kbnSharedDeps_ElasticEui_["euiPaletteCool"])(steps)}};const getColorPalette=(name="cool",steps=10,reverse=false)=>reverse?createColorPalette(name,steps).reverse():createColorPalette(name,steps);const createLegend=(name,steps=10,reverse=false)=>{const paletteColors=getColorPalette(name,steps,reverse);return{type:"steppedGradient",rules:paletteColors.map((color,index)=>({color:color,value:(index+1)/steps}))}};const DEFAULT_WAFFLE_VIEW_STATE={...use_waffle_options["b"],filterQuery:DEFAULT_WAFFLE_FILTERS_STATE,time:DEFAULT_WAFFLE_TIME_STATE.currentTime,autoReload:DEFAULT_WAFFLE_TIME_STATE.isAutoReloading};const useWaffleViewState=()=>{const{metric:metric,groupBy:groupBy,nodeType:nodeType,view:view,customOptions:customOptions,customMetrics:customMetrics,boundsOverride:boundsOverride,autoBounds:autoBounds,accountId:accountId,region:region,legend:legend,sort:sort,setWaffleOptionsState:setWaffleOptionsState}=Object(use_waffle_options["d"])();const{currentTime:currentTime,isAutoReloading:isAutoReloading,setWaffleTimeState:setWaffleTimeState}=useWaffleTimeContext();const{filterQuery:filterQuery,setWaffleFiltersState:setWaffleFiltersState}=useWaffleFiltersContext();const viewState={metric:metric,sort:sort,groupBy:groupBy,nodeType:nodeType,view:view,customOptions:customOptions,customMetrics:customMetrics,boundsOverride:boundsOverride,autoBounds:autoBounds,accountId:accountId,region:region,time:currentTime,autoReload:isAutoReloading,filterQuery:filterQuery,legend:legend};const onViewChange=Object(external_kbnSharedDeps_React_["useCallback"])(newState=>{setWaffleOptionsState({sort:newState.sort,metric:newState.metric,groupBy:newState.groupBy,nodeType:newState.nodeType,view:newState.view,customOptions:newState.customOptions,customMetrics:newState.customMetrics,boundsOverride:newState.boundsOverride,autoBounds:newState.autoBounds,accountId:newState.accountId,region:newState.region,legend:newState.legend});if(newState.time){setWaffleTimeState({currentTime:newState.time,isAutoReloading:newState.autoReload})}setWaffleFiltersState(newState.filterQuery)},[setWaffleOptionsState,setWaffleTimeState,setWaffleFiltersState]);return{viewState:viewState,defaultViewState:DEFAULT_WAFFLE_VIEW_STATE,onViewChange:onViewChange}};var get_interval_in_seconds=__webpack_require__(207);const use_timeline_ONE_MINUTE=60;const use_timeline_ONE_HOUR=use_timeline_ONE_MINUTE*60;const ONE_DAY=use_timeline_ONE_HOUR*24;const ONE_WEEK=ONE_DAY*7;const ONE_MONTH=ONE_DAY*30;const getDisplayInterval=interval=>{if(interval){const intervalInSeconds=Object(get_interval_in_seconds["a"])(interval);if(intervalInSeconds<300)return"5m"}return interval};const getTimeLengthFromInterval=interval=>{if(interval){const intervalInSeconds=Object(get_interval_in_seconds["a"])(interval);const timeLength=intervalInSeconds<=use_timeline_ONE_MINUTE*15?ONE_DAY:intervalInSeconds<=use_timeline_ONE_MINUTE*35?ONE_DAY*3:intervalInSeconds<=use_timeline_ONE_HOUR*2.5?ONE_WEEK:ONE_MONTH;return{timeLength:timeLength,intervalInSeconds:intervalInSeconds}}else{return{timeLength:0,intervalInSeconds:0}}};function useTimeline(filterQuery,metrics,nodeType,sourceId,currentTime,accountId,region,interval,shouldReload){const decodeResponse=response=>Object(pipeable["pipe"])(snapshot_api["g"].decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const displayInterval=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getDisplayInterval(interval),[interval]);const timeLengthResult=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTimeLengthFromInterval(displayInterval),[displayInterval]);const{timeLength:timeLength,intervalInSeconds:intervalInSeconds}=timeLengthResult;const endTime=currentTime+intervalInSeconds*1e3;const startTime=currentTime-timeLength*1e3;const timerange={interval:displayInterval!==null&&displayInterval!==void 0?displayInterval:"",to:endTime,from:startTime,ignoreLookback:true,forceInterval:true};const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/metrics/snapshot","POST",JSON.stringify({metrics:metrics,groupBy:null,nodeType:nodeType,timerange:timerange,filterQuery:filterQuery,sourceId:sourceId,accountId:accountId,region:region,includeTimeseries:true}),decodeResponse);const loadData=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(shouldReload)return makeRequest();return Promise.resolve()},[makeRequest,shouldReload]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{if(timeLength){await loadData()}})()},[loadData,timeLength]);const timeseries=response?Object(external_kbnSharedDeps_Lodash_["first"])(response.nodes.map(node=>{var _first;return(_first=Object(external_kbnSharedDeps_Lodash_["first"])(node.metrics))===null||_first===void 0?void 0:_first.timeseries})):null;return{error:error&&error.message||null,loading:!interval?true:loading,timeseries:timeseries,startTime:startTime,endTime:endTime,reload:makeRequest}}var shared=__webpack_require__(4);const paginationCursorRT=lib["tuple"]([lib["union"]([lib["string"],lib["number"]]),lib["union"]([lib["string"],lib["number"]])]);const anomalyTypeRT=lib["keyof"]({metrics_hosts:null,metrics_k8s:null});const sortOptionsRT=lib["keyof"]({anomalyScore:null,dataset:null,startTime:null});const sortDirectionsRT=lib["keyof"]({asc:null,desc:null});const paginationPreviousPageCursorRT=lib["type"]({searchBefore:paginationCursorRT});const paginationNextPageCursorRT=lib["type"]({searchAfter:paginationCursorRT});const paginationRT=lib["intersection"]([lib["type"]({pageSize:lib["number"]}),lib["partial"]({cursor:lib["union"]([paginationPreviousPageCursorRT,paginationNextPageCursorRT])})]);const sortRT=lib["type"]({field:sortOptionsRT,direction:sortDirectionsRT});const metricRT=lib["keyof"]({memory_usage:null,network_in:null,network_out:null});const INFA_ML_GET_METRICS_HOSTS_ANOMALIES_PATH="/api/infra/infra_ml/results/metrics_hosts_anomalies";const metricsHostAnomalyCommonFieldsRT=lib["type"]({id:lib["string"],anomalyScore:lib["number"],typical:lib["number"],actual:lib["number"],type:anomalyTypeRT,influencers:lib["array"](lib["string"]),duration:lib["number"],startTime:lib["number"],jobId:lib["string"]});const metricsHostsAnomalyRT=metricsHostAnomalyCommonFieldsRT;const getMetricsHostsAnomaliesSuccessReponsePayloadRT=lib["intersection"]([lib["type"]({data:lib["intersection"]([lib["type"]({anomalies:lib["array"](metricsHostsAnomalyRT),hasMoreEntries:lib["boolean"]}),lib["partial"]({paginationCursors:lib["type"]({previousPageCursor:paginationCursorRT,nextPageCursor:paginationCursorRT})})])}),lib["partial"]({timing:shared["c"]})]);const getMetricsHostsAnomaliesRequestPayloadRT=lib["type"]({data:lib["intersection"]([lib["type"]({sourceId:lib["string"],anomalyThreshold:lib["number"],timeRange:shared["d"]}),lib["partial"]({metric:metricRT,pagination:paginationRT,sort:sortRT})])});const INFA_ML_GET_METRICS_K8S_ANOMALIES_PATH="/api/infra/infra_ml/results/metrics_k8s_anomalies";const metricsK8sAnomalyCommonFieldsRT=lib["type"]({id:lib["string"],anomalyScore:lib["number"],typical:lib["number"],actual:lib["number"],type:anomalyTypeRT,influencers:lib["array"](lib["string"]),duration:lib["number"],startTime:lib["number"],jobId:lib["string"]});const metricsK8sAnomalyRT=metricsK8sAnomalyCommonFieldsRT;const getMetricsK8sAnomaliesSuccessReponsePayloadRT=lib["intersection"]([lib["type"]({data:lib["intersection"]([lib["type"]({anomalies:lib["array"](metricsK8sAnomalyRT),hasMoreEntries:lib["boolean"]}),lib["partial"]({paginationCursors:lib["type"]({previousPageCursor:paginationCursorRT,nextPageCursor:paginationCursorRT})})])}),lib["partial"]({timing:shared["c"]})]);const getMetricsK8sAnomaliesRequestPayloadRT=lib["type"]({data:lib["intersection"]([lib["type"]({sourceId:lib["string"],anomalyThreshold:lib["number"],timeRange:shared["d"]}),lib["partial"]({metric:metricRT,pagination:paginationRT,sort:sortRT,datasets:lib["array"](lib["string"])})])});var use_tracked_promise=__webpack_require__(85);var use_kibana=__webpack_require__(28);const stateReducer=(state,action)=>{const resetPagination={page:1,paginationCursor:undefined};switch(action.type){case"changePaginationOptions":return{...state,...resetPagination,...action.payload};case"changeSortOptions":return{...state,...resetPagination,...action.payload};case"changeHasNextPage":return{...state,...action.payload};case"changeLastReceivedCursors":return{...state,...action.payload};case"fetchNextPage":return state.lastReceivedCursors?{...state,page:state.page+1,paginationCursor:{searchAfter:state.lastReceivedCursors.nextPageCursor}}:state;case"fetchPreviousPage":return state.lastReceivedCursors?{...state,page:state.page-1,paginationCursor:{searchBefore:state.lastReceivedCursors.previousPageCursor}}:state;case"changeTimeRange":return{...state,...resetPagination,...action.payload};case"changeFilteredDatasets":return{...state,...resetPagination,...action.payload};default:return state}};const STATE_DEFAULTS={page:1,lastReceivedCursors:undefined,paginationCursor:undefined,hasNextPage:false};const useMetricsHostsAnomaliesResults=({endTime:endTime,startTime:startTime,sourceId:sourceId,anomalyThreshold:anomalyThreshold,defaultSortOptions:defaultSortOptions,defaultPaginationOptions:defaultPaginationOptions,onGetMetricsHostsAnomaliesDatasetsError:onGetMetricsHostsAnomaliesDatasetsError,filteredDatasets:filteredDatasets})=>{const{services:services}=Object(use_kibana["b"])();const initStateReducer=stateDefaults=>({...stateDefaults,paginationOptions:defaultPaginationOptions,sortOptions:defaultSortOptions,filteredDatasets:filteredDatasets,timeRange:{start:startTime,end:endTime}});const[reducerState,dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(stateReducer,STATE_DEFAULTS,initStateReducer);const[metricsHostsAnomalies,setMetricsHostsAnomalies]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getMetricsHostsAnomaliesRequest,getMetricsHostsAnomalies]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async metric=>{const{timeRange:{start:queryStartTime,end:queryEndTime},sortOptions:sortOptions,paginationOptions:paginationOptions,paginationCursor:paginationCursor}=reducerState;return await callGetMetricHostsAnomaliesAPI({sourceId:sourceId,anomalyThreshold:anomalyThreshold,startTime:queryStartTime,endTime:queryEndTime,metric:metric,sort:sortOptions,pagination:{...paginationOptions,cursor:paginationCursor}},services.http.fetch)},onResolve:({data:{anomalies:anomalies,paginationCursors:requestCursors,hasMoreEntries:hasMoreEntries}})=>{const{paginationCursor:paginationCursor}=reducerState;if(requestCursors){dispatch({type:"changeLastReceivedCursors",payload:{lastReceivedCursors:requestCursors}})}if(!paginationCursor||paginationCursor&&"searchAfter"in paginationCursor){dispatch({type:"changeHasNextPage",payload:{hasNextPage:hasMoreEntries}})}else if(paginationCursor&&"searchBefore"in paginationCursor){dispatch({type:"changeHasNextPage",payload:{hasNextPage:true}})}setMetricsHostsAnomalies(anomalies)}},[sourceId,anomalyThreshold,dispatch,reducerState.timeRange,reducerState.sortOptions,reducerState.paginationOptions,reducerState.paginationCursor,reducerState.filteredDatasets]);const changeSortOptions=Object(external_kbnSharedDeps_React_["useCallback"])(nextSortOptions=>{dispatch({type:"changeSortOptions",payload:{sortOptions:nextSortOptions}})},[dispatch]);const changePaginationOptions=Object(external_kbnSharedDeps_React_["useCallback"])(nextPaginationOptions=>{dispatch({type:"changePaginationOptions",payload:{paginationOptions:nextPaginationOptions}})},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch({type:"changeTimeRange",payload:{timeRange:{start:startTime,end:endTime}}})},[startTime,endTime]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch({type:"changeFilteredDatasets",payload:{filteredDatasets:filteredDatasets}})},[filteredDatasets]);const handleFetchNextPage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(reducerState.lastReceivedCursors){dispatch({type:"fetchNextPage"})}},[dispatch,reducerState]);const handleFetchPreviousPage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(reducerState.lastReceivedCursors){dispatch({type:"fetchPreviousPage"})}},[dispatch,reducerState]);const isLoadingMetricsHostsAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getMetricsHostsAnomaliesRequest.state==="pending",[getMetricsHostsAnomaliesRequest.state]);const hasFailedLoadingMetricsHostsAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getMetricsHostsAnomaliesRequest.state==="rejected",[getMetricsHostsAnomaliesRequest.state]);return{metricsHostsAnomalies:metricsHostsAnomalies,getMetricsHostsAnomalies:getMetricsHostsAnomalies,isLoadingMetricsHostsAnomalies:isLoadingMetricsHostsAnomalies,hasFailedLoadingMetricsHostsAnomalies:hasFailedLoadingMetricsHostsAnomalies,changeSortOptions:changeSortOptions,sortOptions:reducerState.sortOptions,changePaginationOptions:changePaginationOptions,paginationOptions:reducerState.paginationOptions,fetchPreviousPage:reducerState.page>1?handleFetchPreviousPage:undefined,fetchNextPage:reducerState.hasNextPage?handleFetchNextPage:undefined,page:reducerState.page}};const callGetMetricHostsAnomaliesAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,anomalyThreshold:anomalyThreshold,startTime:startTime,endTime:endTime,metric:metric,sort:sort,pagination:pagination}=requestArgs;const response=await fetch(INFA_ML_GET_METRICS_HOSTS_ANOMALIES_PATH,{method:"POST",body:JSON.stringify(getMetricsHostsAnomaliesRequestPayloadRT.encode({data:{sourceId:sourceId,anomalyThreshold:anomalyThreshold,timeRange:{startTime:startTime,endTime:endTime},metric:metric,sort:sort,pagination:pagination}}))});return Object(runtime_types["b"])(getMetricsHostsAnomaliesSuccessReponsePayloadRT)(response)};const use_metrics_k8s_anomalies_stateReducer=(state,action)=>{const resetPagination={page:1,paginationCursor:undefined};switch(action.type){case"changePaginationOptions":return{...state,...resetPagination,...action.payload};case"changeSortOptions":return{...state,...resetPagination,...action.payload};case"changeHasNextPage":return{...state,...action.payload};case"changeLastReceivedCursors":return{...state,...action.payload};case"fetchNextPage":return state.lastReceivedCursors?{...state,page:state.page+1,paginationCursor:{searchAfter:state.lastReceivedCursors.nextPageCursor}}:state;case"fetchPreviousPage":return state.lastReceivedCursors?{...state,page:state.page-1,paginationCursor:{searchBefore:state.lastReceivedCursors.previousPageCursor}}:state;case"changeTimeRange":return{...state,...resetPagination,...action.payload};case"changeFilteredDatasets":return{...state,...resetPagination,...action.payload};default:return state}};const use_metrics_k8s_anomalies_STATE_DEFAULTS={page:1,lastReceivedCursors:undefined,paginationCursor:undefined,hasNextPage:false};const useMetricsK8sAnomaliesResults=({endTime:endTime,startTime:startTime,sourceId:sourceId,anomalyThreshold:anomalyThreshold,defaultSortOptions:defaultSortOptions,defaultPaginationOptions:defaultPaginationOptions,onGetMetricsHostsAnomaliesDatasetsError:onGetMetricsHostsAnomaliesDatasetsError,filteredDatasets:filteredDatasets})=>{const{services:services}=Object(use_kibana["b"])();const initStateReducer=stateDefaults=>({...stateDefaults,paginationOptions:defaultPaginationOptions,sortOptions:defaultSortOptions,filteredDatasets:filteredDatasets,timeRange:{start:startTime,end:endTime}});const[reducerState,dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(use_metrics_k8s_anomalies_stateReducer,use_metrics_k8s_anomalies_STATE_DEFAULTS,initStateReducer);const[metricsK8sAnomalies,setMetricsK8sAnomalies]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getMetricsK8sAnomaliesRequest,getMetricsK8sAnomalies]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async metric=>{const{timeRange:{start:queryStartTime,end:queryEndTime},sortOptions:sortOptions,paginationOptions:paginationOptions,paginationCursor:paginationCursor,filteredDatasets:queryFilteredDatasets}=reducerState;return await callGetMetricsK8sAnomaliesAPI({sourceId:sourceId,anomalyThreshold:anomalyThreshold,startTime:queryStartTime,endTime:queryEndTime,metric:metric,sort:sortOptions,pagination:{...paginationOptions,cursor:paginationCursor},datasets:queryFilteredDatasets},services.http.fetch)},onResolve:({data:{anomalies:anomalies,paginationCursors:requestCursors,hasMoreEntries:hasMoreEntries}})=>{const{paginationCursor:paginationCursor}=reducerState;if(requestCursors){dispatch({type:"changeLastReceivedCursors",payload:{lastReceivedCursors:requestCursors}})}if(!paginationCursor||paginationCursor&&"searchAfter"in paginationCursor){dispatch({type:"changeHasNextPage",payload:{hasNextPage:hasMoreEntries}})}else if(paginationCursor&&"searchBefore"in paginationCursor){dispatch({type:"changeHasNextPage",payload:{hasNextPage:true}})}setMetricsK8sAnomalies(anomalies)}},[sourceId,anomalyThreshold,dispatch,reducerState.timeRange,reducerState.sortOptions,reducerState.paginationOptions,reducerState.paginationCursor,reducerState.filteredDatasets]);const changeSortOptions=Object(external_kbnSharedDeps_React_["useCallback"])(nextSortOptions=>{dispatch({type:"changeSortOptions",payload:{sortOptions:nextSortOptions}})},[dispatch]);const changePaginationOptions=Object(external_kbnSharedDeps_React_["useCallback"])(nextPaginationOptions=>{dispatch({type:"changePaginationOptions",payload:{paginationOptions:nextPaginationOptions}})},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch({type:"changeTimeRange",payload:{timeRange:{start:startTime,end:endTime}}})},[startTime,endTime]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch({type:"changeFilteredDatasets",payload:{filteredDatasets:filteredDatasets}})},[filteredDatasets]);const handleFetchNextPage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(reducerState.lastReceivedCursors){dispatch({type:"fetchNextPage"})}},[dispatch,reducerState]);const handleFetchPreviousPage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(reducerState.lastReceivedCursors){dispatch({type:"fetchPreviousPage"})}},[dispatch,reducerState]);const isLoadingMetricsK8sAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getMetricsK8sAnomaliesRequest.state==="pending",[getMetricsK8sAnomaliesRequest.state]);const hasFailedLoadingMetricsK8sAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getMetricsK8sAnomaliesRequest.state==="rejected",[getMetricsK8sAnomaliesRequest.state]);return{metricsK8sAnomalies:metricsK8sAnomalies,getMetricsK8sAnomalies:getMetricsK8sAnomalies,isLoadingMetricsK8sAnomalies:isLoadingMetricsK8sAnomalies,hasFailedLoadingMetricsK8sAnomalies:hasFailedLoadingMetricsK8sAnomalies,changeSortOptions:changeSortOptions,sortOptions:reducerState.sortOptions,changePaginationOptions:changePaginationOptions,paginationOptions:reducerState.paginationOptions,fetchPreviousPage:reducerState.page>1?handleFetchPreviousPage:undefined,fetchNextPage:reducerState.hasNextPage?handleFetchNextPage:undefined,page:reducerState.page}};const callGetMetricsK8sAnomaliesAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,anomalyThreshold:anomalyThreshold,startTime:startTime,endTime:endTime,metric:metric,sort:sort,pagination:pagination,datasets:datasets}=requestArgs;const response=await fetch(INFA_ML_GET_METRICS_K8S_ANOMALIES_PATH,{method:"POST",body:JSON.stringify(getMetricsK8sAnomaliesRequestPayloadRT.encode({data:{sourceId:sourceId,anomalyThreshold:anomalyThreshold,timeRange:{startTime:startTime,endTime:endTime},metric:metric,sort:sort,pagination:pagination,datasets:datasets}}))});return Object(runtime_types["b"])(getMetricsK8sAnomaliesSuccessReponsePayloadRT)(response)};const Timeline=({interval:interval,yAxisFormatter:yAxisFormatter,isVisible:isVisible})=>{var _toMetricOpt,_toMetricOpt2;const{sourceId:sourceId,source:source}=Object(containers_source["b"])();const{metric:metric,nodeType:nodeType,accountId:accountId,region:region}=Object(use_waffle_options["d"])();const{currentTime:currentTime,jumpToTime:jumpToTime,stopAutoReload:stopAutoReload}=useWaffleTimeContext();const{filterQueryAsJson:filterQueryAsJson}=useWaffleFiltersContext();const{loading:loading,error:error,startTime:startTime,endTime:endTime,timeseries:timeseries,reload:reload}=useTimeline(filterQueryAsJson,[metric],nodeType,sourceId,currentTime,accountId,region,interval,isVisible);const anomalyParams={sourceId:"default",anomalyThreshold:(source===null||source===void 0?void 0:source.configuration.anomalyThreshold)||0,startTime:startTime,endTime:endTime,defaultSortOptions:{direction:"desc",field:"anomalyScore"},defaultPaginationOptions:{pageSize:100}};const{metricsHostsAnomalies:metricsHostsAnomalies,getMetricsHostsAnomalies:getMetricsHostsAnomalies}=useMetricsHostsAnomaliesResults(anomalyParams);const{metricsK8sAnomalies:metricsK8sAnomalies,getMetricsK8sAnomalies:getMetricsK8sAnomalies}=useMetricsK8sAnomaliesResults(anomalyParams);const getAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(nodeType==="host"){return getMetricsHostsAnomalies}else if(nodeType==="pod"){return getMetricsK8sAnomalies}},[nodeType,getMetricsK8sAnomalies,getMetricsHostsAnomalies]);const anomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(nodeType==="host"){return metricsHostsAnomalies}else if(nodeType==="pod"){return metricsK8sAnomalies}},[nodeType,metricsHostsAnomalies,metricsK8sAnomalies]);const metricLabel=(_toMetricOpt=Object(snapshot_metric_i18n["a"])(metric.type))===null||_toMetricOpt===void 0?void 0:_toMetricOpt.textLC;const metricPopoverLabel=(_toMetricOpt2=Object(snapshot_metric_i18n["a"])(metric.type))===null||_toMetricOpt2===void 0?void 0:_toMetricOpt2.text;const chartMetric={color:color_palette["a"].color0,aggregation:"avg",label:metricPopoverLabel};const dateFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _first,_last;if(!timeseries)return()=>"";const firstTimestamp=(_first=Object(external_kbnSharedDeps_Lodash_["first"])(timeseries.rows))===null||_first===void 0?void 0:_first.timestamp;const lastTimestamp=(_last=Object(external_kbnSharedDeps_Lodash_["last"])(timeseries.rows))===null||_last===void 0?void 0:_last.timestamp;if(firstTimestamp==null||lastTimestamp==null){return value=>`${value}`}return Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])([firstTimestamp,lastTimestamp])},[timeseries]);const isDarkMode=Object(kibanaReact_public_["useUiSetting"])("theme:darkMode");const tooltipProps={headerFormatter:tooltipValue=>external_kbnSharedDeps_Moment_default()(tooltipValue.value).format("Y-MM-DD HH:mm:ss.SSS")};const dataDomain=timeseries?Object(calculate_domain["a"])(timeseries,[chartMetric],false):null;const domain=dataDomain?{max:dataDomain.max*1.1,min:dataDomain.min}:{max:0,min:0};const onClickPoint=Object(external_kbnSharedDeps_React_["useCallback"])(([[geometryValue]])=>{if(!Array.isArray(geometryValue)){const{x:timestamp}=geometryValue;jumpToTime(timestamp);stopAutoReload()}},[jumpToTime,stopAutoReload]);const anomalyMetricName=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const metricType=metric.type;if(metricType==="memory"){return"memory_usage"}if(metricType==="rx"){return"network_in"}if(metricType==="tx"){return"network_out"}},[metric]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(getAnomalies&&anomalyMetricName){getAnomalies(anomalyMetricName)}},[getAnomalies,anomalyMetricName]);if(loading){return external_kbnSharedDeps_React_default.a.createElement(TimelineContainer,null,external_kbnSharedDeps_React_default.a.createElement(TimelineLoadingContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingChart"],{size:"xl"})))}if(!loading&&(error||!timeseries)){return external_kbnSharedDeps_React_default.a.createElement(TimelineContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"visArea",title:external_kbnSharedDeps_React_default.a.createElement("h4",null,error?errorTitle:noHistoryDataTitle),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",fill:true,onClick:reload},error?retryButtonLabel:checkNewDataButtonLabel)}))}function generateAnnotationData(results){return results.map(anomaly=>{const[val,influencers]=anomaly;return{coordinates:{x0:val,x1:external_kbnSharedDeps_Moment_default()(val).add(15,"minutes").valueOf(),y0:dataDomain===null||dataDomain===void 0?void 0:dataDomain.min,y1:dataDomain===null||dataDomain===void 0?void 0:dataDomain.max},details:influencers.join(",")}})}return external_kbnSharedDeps_React_default.a.createElement(TimelineContainer,null,external_kbnSharedDeps_React_default.a.createElement(TimelineHeader,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.inventoryTimeline.header",defaultMessage:"Average {metricLabel}",values:{metricLabel:metricLabel}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:Object(color_palette["b"])(chartMetric.color),type:"dot"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.inventoryTimeline.header",defaultMessage:"Average {metricLabel}",values:{metricLabel:metricLabel}}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{backgroundColor:"#D36086",height:5,width:10}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.inventoryTimeline.legend.anomalyLabel",defaultMessage:"Anomaly detected"})))))))),external_kbnSharedDeps_React_default.a.createElement(TimelineChartContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,anomalies&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["RectAnnotation"],{id:"anomalies",dataValues:generateAnnotationData(anomalies.map(a=>[a.startTime,a.influencers])),style:{fill:"#D36086"}}),external_kbnSharedDeps_React_default.a.createElement(series_chart["a"],{type:use_metrics_explorer_options["b"].area,metric:chartMetric,id:"0",series:timeseries,stack:false}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:dateFormatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:yAxisFormatter,domain:domain,ticks:6,showGridLines:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{tooltip:tooltipProps,theme:Object(get_chart_theme["b"])(isDarkMode),onElementClick:onClickPoint}))))};const TimelineContainer=common_["euiStyled"].div`
  background-color: ${props=>props.theme.eui.euiPageBackgroundColor};
  border-top: 1px solid ${props=>props.theme.eui.euiColorLightShade};
  height: 220px;
  width: 100%;
  padding: ${props=>props.theme.eui.paddingSizes.s} ${props=>props.theme.eui.paddingSizes.m};
  display: flex;
  flex-direction: column;
`;const TimelineHeader=common_["euiStyled"].div`
  display: flex;
  width: 100%;
  padding: ${props=>props.theme.eui.paddingSizes.s} ${props=>props.theme.eui.paddingSizes.m};
  @media only screen and (max-width: 767px) {
      margin-top: 30px;
  }
`;const TimelineChartContainer=common_["euiStyled"].div`
  padding-left: ${props=>props.theme.eui.paddingSizes.xs};
  width: 100%;
  height: 100%;
`;const TimelineLoadingContainer=common_["euiStyled"].div`
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100%;
`;const noHistoryDataTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryTimeline.noHistoryDataTitle",{defaultMessage:"There is no historical data to display."});const errorTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryTimeline.errorTitle",{defaultMessage:"Unable to show historical data."});const checkNewDataButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryTimeline.checkNewDataButtonLabel",{defaultMessage:"Check for new data"});const retryButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryTimeline.retryButtonLabel",{defaultMessage:"Try again"});const showHistory=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.showHistory",{defaultMessage:"Show history"});const hideHistory=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.hideHistory",{defaultMessage:"Hide history"});const TRANSITION_MS=300;const BottomDrawer=({measureRef:measureRef,width:width,interval:interval,formatter:formatter,children:children})=>{const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const trackDrawerOpen=Object(observability_public_["useUiTracker"])({app:"infra_metrics"});const onClick=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(!isOpen)trackDrawerOpen({metric:"open_timeline_drawer__inventory"});setIsOpen(!isOpen)},[isOpen,trackDrawerOpen]);return external_kbnSharedDeps_React_default.a.createElement(BottomActionContainer,{ref:isOpen?measureRef:null,isOpen:isOpen,outerWidth:width},external_kbnSharedDeps_React_default.a.createElement(BottomActionTopBar,{ref:isOpen?null:measureRef},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ShowHideButton,{"aria-expanded":isOpen,iconType:isOpen?"arrowDown":"arrowRight",onClick:onClick},isOpen?hideHistory:showHistory)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,style:{position:"relative",minWidth:400,height:"16px"}},children),external_kbnSharedDeps_React_default.a.createElement(RightSideSpacer,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{style:{marginTop:0}},external_kbnSharedDeps_React_default.a.createElement(Timeline,{isVisible:isOpen,interval:interval,yAxisFormatter:formatter})))};const BottomActionContainer=common_["euiStyled"].div`
  padding: ${props=>props.theme.eui.paddingSizes.m} 0;
  position: fixed;
  bottom: 0;
  right: 0;
  transition: transform ${TRANSITION_MS}ms;
  transform: translateY(${props=>props.isOpen?0:"224px"});
  width: ${props=>props.outerWidth}px;
`;const BottomActionTopBar=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).attrs({justifyContent:"spaceBetween",alignItems:"center"})`
 margin-bottom: 0;
 height: 48px;
`;const ShowHideButton=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"]).attrs({size:"s"})`
  width: 140px;
`;const RightSideSpacer=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiSpacer"]).attrs({size:"xs"})`
  width: 140px;
`;const createTickRender=(bounds,formatter)=>(rule,index)=>{const value=rule.value===0?bounds.min:bounds.max*rule.value;const style={left:`${rule.value*100}%`};const label=formatter(value);return external_kbnSharedDeps_React_default.a.createElement(GradientLegendTick,{style:style,key:`legend-rule-${index}`},external_kbnSharedDeps_React_default.a.createElement(GradientLegendTickLine,null),external_kbnSharedDeps_React_default.a.createElement(GradientLegendTickLabel,null,label))};const GradientLegend=({legend:legend,bounds:bounds,formatter:formatter})=>{const maxValue=legend.rules.reduce((acc,rule)=>acc<rule.value?rule.value:acc,0);const colorStops=legend.rules.map(rule=>{const percent=rule.value/maxValue*100;return`${rule.color} ${percent}%`});const style={background:`linear-gradient(to right, ${colorStops})`};return external_kbnSharedDeps_React_default.a.createElement(GradientLegendContainer,{style:style},legend.rules.map(createTickRender(bounds,formatter)))};const GradientLegendContainer=common_["euiStyled"].div`
  position: absolute;
  height: 10px;
  bottom: 0;
  left: 0;
  right: 40px;
`;const GradientLegendTick=common_["euiStyled"].div`
  position: absolute;
  bottom: 0;
  top: -18px;
`;const GradientLegendTickLine=common_["euiStyled"].div`
  position: absolute;
  background-color: ${props=>props.theme.eui.euiBorderColor};
  width: 1px;
  left: 0;
  top: 15px;
  bottom: 0;
  ${GradientLegendTick}:first-child {
    top: 2px;
  }
  ${GradientLegendTick}:last-child {
    top: 2px;
  }
`;const GradientLegendTickLabel=common_["euiStyled"].div`
  position: absolute;
  font-size: 11px;
  text-align: center;
  top: 0;
  left: 0;
  white-space: nowrap;
  transform: translate(-50%, 0);
  ${GradientLegendTick}:first-child & {
    padding-left: 5px;
    transform: translate(0, 0);
  }
  ${GradientLegendTick}:last-child & {
    padding-right: 5px;
    transform: translate(-100%, 0);
  }
`;const convertBoundsToPercents=bounds=>({min:bounds.min*100,max:(bounds.max||1)*100});const SwatchLabel=({label:label,color:color})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPickerSwatch"],{color:color})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("strong",null,label))));const PalettePreview=({steps:steps,palette:palette,reverse:reverse})=>{const colors=getColorPalette(palette,steps,reverse);return external_kbnSharedDeps_React_default.a.createElement(Swatches,null,colors.map(color=>external_kbnSharedDeps_React_default.a.createElement(Swatch,{key:color,style:{backgroundColor:color}})))};const Swatch=common_["euiStyled"].div`
  width: 15px;
  height: 12px;
  flex: 0 0 auto;
  &:first-child {
    border-radius: ${props=>props.theme.eui.euiBorderRadius} 0 0 ${props=>props.theme.eui.euiBorderRadius};
  }
  &:last-child {
    border-radius: 0 ${props=>props.theme.eui.euiBorderRadius} ${props=>props.theme.eui.euiBorderRadius} 0;
`;const Swatches=common_["euiStyled"].div`
  display: flex;
`;const PALETTE_NAMES=["temperature","status","cool","warm","positive","negative"];const PALETTE_OPTIONS=PALETTE_NAMES.map(name=>({text:lib_lib["e"][name],value:name}));const LegendControls=({autoBounds:autoBounds,boundsOverride:boundsOverride,onChange:onChange,dataBounds:dataBounds,options:options})=>{const[isPopoverOpen,setPopoverState]=Object(external_kbnSharedDeps_React_["useState"])(false);const[draftAuto,setDraftAuto]=Object(external_kbnSharedDeps_React_["useState"])(autoBounds);const[draftLegend,setLegendOptions]=Object(external_kbnSharedDeps_React_["useState"])(options);const[draftBounds,setDraftBounds]=Object(external_kbnSharedDeps_React_["useState"])(convertBoundsToPercents(boundsOverride));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(draftAuto){setDraftBounds(convertBoundsToPercents(dataBounds))}},[autoBounds,dataBounds,draftAuto,onChange,options]);const buttonComponent=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"controlsHorizontal",color:"text","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.buttonLabel",{defaultMessage:"configure legend"}),onClick:()=>setPopoverState(true)});const handleAutoChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const auto=e.target.checked;setDraftAuto(auto);if(!auto){setDraftBounds(convertBoundsToPercents(boundsOverride))}},[boundsOverride]);const handleReverseColors=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{setLegendOptions(previous=>({...previous,reverseColors:e.target.checked}))},[setLegendOptions]);const handleMaxBounds=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const value=parseFloat(e.currentTarget.value);const max=value<=draftBounds.min?draftBounds.min+1:value>100?100:value;setDraftBounds({...draftBounds,max:max})},[draftBounds]);const handleMinBounds=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const value=parseFloat(e.currentTarget.value);const min=value>=draftBounds.max?draftBounds.max-1:value<0?0:value;setDraftBounds({...draftBounds,min:min})},[draftBounds]);const handleApplyClick=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{onChange({auto:draftAuto,bounds:{min:draftBounds.min/100,max:draftBounds.max/100},legend:draftLegend})},[onChange,draftAuto,draftBounds,draftLegend]);const handleCancelClick=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setDraftBounds(convertBoundsToPercents(boundsOverride));setDraftAuto(autoBounds);setLegendOptions(options);setPopoverState(false)},[autoBounds,boundsOverride,options]);const handleStepsChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const steps=parseInt(e.target.value,10);setLegendOptions(previous=>({...previous,steps:steps}))},[setLegendOptions]);const handlePaletteChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const palette=e.target.value;setLegendOptions(previous=>({...previous,palette:palette}))},[setLegendOptions]);const commited=draftAuto===autoBounds&&boundsOverride.min*100===draftBounds.min&&boundsOverride.max*100===draftBounds.max&&options.steps===draftLegend.steps&&options.reverseColors===draftLegend.reverseColors&&options.palette===draftLegend.palette;const boundsValidRange=draftBounds.min<draftBounds.max;const paletteColors=getColorPalette(draftLegend.palette,draftLegend.steps,draftLegend.reverseColors);const errors=!boundsValidRange?[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legnedControls.boundRangeError",{defaultMessage:"Minimum must be smaller then the maximum"})]:[];return external_kbnSharedDeps_React_default.a.createElement(ControlContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{isOpen:isPopoverOpen,closePopover:handleCancelClick,id:"legendControls",button:buttonComponent},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,"Legend Options"),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],{style:{minWidth:400}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.colorPaletteLabel",{defaultMessage:"Color palette"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:PALETTE_OPTIONS,value:draftLegend.palette,id:"palette",onChange:handlePaletteChange,compressed:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(PalettePreview,{palette:draftLegend.palette,steps:draftLegend.steps,reverse:draftLegend.reverseColors}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"columnCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.stepsLabel",{defaultMessage:"Number of colors"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{id:"steps",min:2,max:18,step:1,value:draftLegend.steps,onChange:handleStepsChange,showValue:true,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,display:"columnCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.reverseDirectionLabel",{defaultMessage:"Reverse direction"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{showLabel:false,name:"reverseColors",label:"reverseColors",checked:draftLegend.reverseColors,onChange:handleReverseColors,compressed:true,style:{position:"relative",top:"8px"}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,display:"columnCompressed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.switchLabel",{defaultMessage:"Auto calculate range"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{showLabel:false,name:"bounds",label:"bounds",checked:draftAuto,onChange:handleAutoChange,compressed:true,style:{position:"relative",top:"8px"}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(SwatchLabel,{color:Object(external_kbnSharedDeps_Lodash_["first"])(paletteColors),label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.minLabel",{defaultMessage:"Minimum"})}),isInvalid:!boundsValidRange,display:"columnCompressed",error:errors},external_kbnSharedDeps_React_default.a.createElement("div",{style:{maxWidth:150}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{disabled:draftAuto,step:1,value:isNaN(draftBounds.min)?"":draftBounds.min,isInvalid:!boundsValidRange,name:"legendMin",onChange:handleMinBounds,append:"%",compressed:true}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,display:"columnCompressed",label:external_kbnSharedDeps_React_default.a.createElement(SwatchLabel,{color:Object(external_kbnSharedDeps_Lodash_["last"])(paletteColors),label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.legendControls.maxLabel",{defaultMessage:"Maxium"})}),isInvalid:!boundsValidRange,error:errors},external_kbnSharedDeps_React_default.a.createElement("div",{style:{maxWidth:150}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{disabled:draftAuto,step:1,isInvalid:!boundsValidRange,value:isNaN(draftBounds.max)?"":draftBounds.max,name:"legendMax",onChange:handleMaxBounds,append:"%",compressed:true}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{type:"submit",size:"s",onClick:handleCancelClick},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.legendControls.cancelButton",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"submit",size:"s",fill:true,disabled:commited||!boundsValidRange,onClick:handleApplyClick},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.legendControls.applyButton",defaultMessage:"Apply"})))))))};const ControlContainer=common_["euiStyled"].div`
  position: absolute;
  top: -20px;
  right: 6px;
  bottom: 0;
`;const OPERATORS={[lib_lib["c"].gte]:">=",[lib_lib["c"].gt]:">",[lib_lib["c"].lte]:"<=",[lib_lib["c"].lt]:"<",[lib_lib["c"].eq]:"="};const createStep=formatter=>(rule,index)=>{const label=rule.label!=null?rule.label:`${OPERATORS[rule.operator]} ${formatter(rule.value)}`;const squareStyle={backgroundColor:Object(polished_lib["darken"])(.4,rule.color)};const squareInnerStyle={backgroundColor:rule.color};return external_kbnSharedDeps_React_default.a.createElement(StepContainer,{key:`legend-step-${index}`},external_kbnSharedDeps_React_default.a.createElement(StepSquare,{style:squareStyle},external_kbnSharedDeps_React_default.a.createElement(StepSquareInner,{style:squareInnerStyle})),external_kbnSharedDeps_React_default.a.createElement(StepLabel,null,label))};const StepLegend=({legend:legend,formatter:formatter})=>external_kbnSharedDeps_React_default.a.createElement(StepLegendContainer,null,legend.rules.map(createStep(formatter)));const StepLegendContainer=common_["euiStyled"].div`
  display: flex;
  padding: 10px 40px 10px 10px;
`;const StepContainer=common_["euiStyled"].div`
  display: flex;
  margin-right: 20px
  align-items: center;
`;const StepSquare=common_["euiStyled"].div`
  position: relative;
  width: 24px;
  height: 24px;
  flex: 0 0 auto;
  margin-right: 5px;
  border-radius: 3px;
  box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.2);
`;const StepSquareInner=common_["euiStyled"].div`
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 2px;
  border-radius: 3px;
`;const StepLabel=common_["euiStyled"].div`
  font-size: 12px;
`;const SteppedGradientLegend=({legend:legend,bounds:bounds,formatter:formatter})=>external_kbnSharedDeps_React_default.a.createElement(LegendContainer,null,external_kbnSharedDeps_React_default.a.createElement(Ticks,null,external_kbnSharedDeps_React_default.a.createElement(TickLabel,{value:0,bounds:bounds,formatter:formatter}),external_kbnSharedDeps_React_default.a.createElement(TickLabel,{value:1,bounds:bounds,formatter:formatter})),external_kbnSharedDeps_React_default.a.createElement(GradientContainer,null,legend.rules.map((rule,index)=>external_kbnSharedDeps_React_default.a.createElement(GradientStep,{key:`step-${index}-${rule.value}`,style:{backgroundColor:rule.color}}))));const TickLabel=({value:value,bounds:bounds,formatter:formatter})=>{const normalizedValue=value===0?bounds.min:bounds.max*value;const style={left:`${value*100}%`};const label=formatter(normalizedValue);return external_kbnSharedDeps_React_default.a.createElement(Tick,{style:style},label)};const GradientStep=common_["euiStyled"].div`
  height: ${props=>props.theme.eui.paddingSizes.s};
  flex: 1 1 auto;
  &:first-child {
    border-radius: ${props=>props.theme.eui.euiBorderRadius} 0 0 ${props=>props.theme.eui.euiBorderRadius};
  }
  &:last-child {
    border-radius: 0 ${props=>props.theme.eui.euiBorderRadius} ${props=>props.theme.eui.euiBorderRadius} 0;
  }
`;const Ticks=common_["euiStyled"].div`
  position: absolute;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
  top: -18px;
`;const Tick=common_["euiStyled"].div`
  position: absolute;
  font-size: 11px;
  text-align: center;
  top: 0;
  left: 0;
  white-space: nowrap;
  transform: translate(-50%, 0);
  &:first-child {
    padding-left: 5px;
    transform: translate(0, 0);
  }
  &:last-child {
    padding-right: 5px;
    transform: translate(-100%, 0);
  }
`;const GradientContainer=common_["euiStyled"].div`
  display: flex;
  flex-direction; row;
  align-items: stretch;
  flex-grow: 1;
`;const LegendContainer=common_["euiStyled"].div`
  position: absolute;
  height: 10px;
  bottom: 0;
  left: 0;
  right: 40px;
`;const Legend=({dataBounds:dataBounds,legend:legend,bounds:bounds,formatter:formatter})=>{const{changeBoundsOverride:changeBoundsOverride,changeAutoBounds:changeAutoBounds,autoBounds:autoBounds,legend:legendOptions,changeLegend:changeLegend,boundsOverride:boundsOverride}=Object(use_waffle_options["d"])();const handleChange=Object(external_kbnSharedDeps_React_["useCallback"])(options=>{changeBoundsOverride(options.bounds);changeAutoBounds(options.auto);changeLegend(options.legend)},[changeBoundsOverride,changeAutoBounds,changeLegend]);return external_kbnSharedDeps_React_default.a.createElement(legend_LegendContainer,null,external_kbnSharedDeps_React_default.a.createElement(LegendControls,{options:legendOptions!=null?legendOptions:use_waffle_options["a"],dataBounds:dataBounds,bounds:bounds,autoBounds:autoBounds,boundsOverride:boundsOverride,onChange:handleChange}),lib_lib["a"].is(legend)&&external_kbnSharedDeps_React_default.a.createElement(GradientLegend,{formatter:formatter,legend:legend,bounds:bounds}),lib_lib["f"].is(legend)&&external_kbnSharedDeps_React_default.a.createElement(StepLegend,{formatter:formatter,legend:legend}),lib_lib["g"].is(legend)&&external_kbnSharedDeps_React_default.a.createElement(SteppedGradientLegend,{formatter:formatter,bounds:bounds,legend:legend}))};const legend_LegendContainer=common_["euiStyled"].div`
  position: absolute;
  bottom: 0px;
  left: 10px;
  right: 10px;
`;const layout_Layout=()=>{var _legend$palette,_legend$steps,_legend$reverseColors,_source$configuration;const[showLoading,setShowLoading]=Object(external_kbnSharedDeps_React_["useState"])(true);const{sourceId:sourceId,source:source}=Object(containers_source["b"])();const{currentView:currentView,shouldLoadDefault:shouldLoadDefault}=useSavedViewContext();const{metric:metric,groupBy:groupBy,sort:sort,nodeType:nodeType,accountId:accountId,region:region,changeView:changeView,view:view,autoBounds:autoBounds,boundsOverride:boundsOverride,legend:legend}=Object(use_waffle_options["d"])();const{currentTime:currentTime,jumpToTime:jumpToTime,isAutoReloading:isAutoReloading}=useWaffleTimeContext();const{filterQueryAsJson:filterQueryAsJson,applyFilterQuery:applyFilterQuery}=useWaffleFiltersContext();const{loading:loading,nodes:nodes,reload:reload,interval:interval}=useSnapshot(filterQueryAsJson,[metric],groupBy,nodeType,sourceId,currentTime,accountId,region,false);const legendPalette=(_legend$palette=legend===null||legend===void 0?void 0:legend.palette)!==null&&_legend$palette!==void 0?_legend$palette:use_waffle_options["a"].palette;const legendSteps=(_legend$steps=legend===null||legend===void 0?void 0:legend.steps)!==null&&_legend$steps!==void 0?_legend$steps:use_waffle_options["a"].steps;const legendReverseColors=(_legend$reverseColors=legend===null||legend===void 0?void 0:legend.reverseColors)!==null&&_legend$reverseColors!==void 0?_legend$reverseColors:use_waffle_options["a"].reverseColors;const options={formatter:lib_lib["b"].percent,formatTemplate:"{{value}}",legend:createLegend(legendPalette,legendSteps,legendReverseColors),metric:metric,sort:sort,fields:source===null||source===void 0?void 0:(_source$configuration=source.configuration)===null||_source$configuration===void 0?void 0:_source$configuration.fields,groupBy:groupBy};useInterval_default()(()=>{if(!loading){jumpToTime(Date.now())}},isAutoReloading?5e3:null);const intervalAsString=convertIntervalToString(interval);const dataBounds=calculateBoundsFromNodes(nodes);const bounds=autoBounds?dataBounds:boundsOverride;const formatter=Object(external_kbnSharedDeps_React_["useCallback"])(createInventoryMetricFormatter(options.metric),[options.metric]);const{viewState:viewState,onViewChange:onViewChange}=useWaffleViewState();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentView){onViewChange(currentView)}},[currentView,onViewChange]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentView!=null||!shouldLoadDefault){reload()}},[reload,shouldLoadDefault]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setShowLoading(true)},[options.metric,nodeType]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const hasNodes=nodes&&nodes.length;setShowLoading(!hasNodes)},[nodes]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(page["c"],null,external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{bounds:true},({measureRef:pageMeasureRef,bounds:{width:width=0}})=>external_kbnSharedDeps_React_default.a.createElement(MainContainer,{ref:pageMeasureRef},external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{bounds:true},({measureRef:topActionMeasureRef,bounds:{height:topActionHeight=0}})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(TopActionContainer,{ref:topActionMeasureRef},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(toolbar_Toolbar,{nodeType:nodeType,currentTime:currentTime}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(IntervalLabel,{intervalAsString:intervalAsString})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ViewSwitcher,{view:view,onChange:changeView}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(SavedViewContainer,null,external_kbnSharedDeps_React_default.a.createElement(SavedViewsToolbarControls,{viewState:viewState}))),external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{bounds:true},({measureRef:measureRef,bounds:{height:height=0}})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(NodesOverview,{nodes:nodes,options:options,nodeType:nodeType,loading:loading,showLoading:showLoading,reload:reload,onDrilldown:applyFilterQuery,currentTime:currentTime,view:view,autoBounds:autoBounds,boundsOverride:boundsOverride,formatter:formatter,bottomMargin:height,topMargin:topActionHeight}),view==="map"&&external_kbnSharedDeps_React_default.a.createElement(BottomDrawer,{measureRef:measureRef,interval:interval,formatter:formatter,width:width},external_kbnSharedDeps_React_default.a.createElement(Legend,{formatter:formatter,bounds:bounds,dataBounds:dataBounds,legend:options.legend}))))))))))};const MainContainer=common_["euiStyled"].div`
  position: relative;
  flex: 1 1 auto;
`;const TopActionContainer=common_["euiStyled"].div`
  padding: ${props=>`12px ${props.theme.eui.paddingSizes.m}`};
`;const SavedViewContainer=common_["euiStyled"].div`
  position: relative;
  z-index: 1;
  padding-left: ${props=>props.theme.eui.paddingSizes.m};
`;function inventory_view_extends(){inventory_view_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return inventory_view_extends.apply(this,arguments)}const SnapshotPage=()=>{var _useKibana$services$a,_uiCapabilities$infra;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const{hasFailedLoadingSource:hasFailedLoadingSource,isLoading:isLoading,loadSourceFailureMessage:loadSourceFailureMessage,loadSource:loadSource,source:source,metricIndicesExist:metricIndicesExist}=Object(external_kbnSharedDeps_React_["useContext"])(containers_source["a"].Context);Object(observability_public_["useTrackPageview"])({app:"infra_metrics",path:"inventory"});Object(observability_public_["useTrackPageview"])({app:"infra_metrics",path:"inventory",delay:15e3});const{source:optionsSource}=Object(use_waffle_options["d"])();const tutorialLinkProps=Object(use_link_props["b"])({app:"home",hash:"/tutorial_directory/metrics"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(page["a"],null,external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:previousTitle=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.infrastructureSnapshotPage.documentTitle",{defaultMessage:"{previousTitle} | Inventory",values:{previousTitle:previousTitle}})}),isLoading&&!source?external_kbnSharedDeps_React_default.a.createElement(source_loading_page["a"],null):metricIndicesExist?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(FilterBar,null),external_kbnSharedDeps_React_default.a.createElement(SavedViewProvider,{shouldLoadDefault:optionsSource==="default",viewType:"inventory-view",defaultViewState:DEFAULT_WAFFLE_VIEW_STATE},external_kbnSharedDeps_React_default.a.createElement(layout_Layout,null))):hasFailedLoadingSource?external_kbnSharedDeps_React_default.a.createElement(source_error_page["a"],{errorMessage:loadSourceFailureMessage||"",retry:loadSource}):external_kbnSharedDeps_React_default.a.createElement(no_indices["a"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.noMetricsIndicesTitle",{defaultMessage:"Looks like you don't have any metrics indices."}),message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.noMetricsIndicesDescription",{defaultMessage:"Let's add some!"}),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],inventory_view_extends({},tutorialLinkProps,{color:"primary",fill:true,"data-test-subj":"infrastructureViewSetupInstructionsButton"}),external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.noMetricsIndicesInstructionsActionLabel",{defaultMessage:"View setup instructions"}))),uiCapabilities!==null&&uiCapabilities!==void 0&&(_uiCapabilities$infra=uiCapabilities.infrastructure)!==null&&_uiCapabilities$infra!==void 0&&_uiCapabilities$infra.configureSource?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(source_configuration["a"],{app:"metrics","data-test-subj":"configureSourceButton"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.configureSourceActionLabel",{defaultMessage:"Change source configuration"}))):null),"data-test-subj":"noMetricsIndicesPrompt"})))};var source_configuration_settings=__webpack_require__(210);const MetricsSettingsPage=()=>{var _useKibana$services$a,_uiCapabilities$infra;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(source_configuration_settings["a"],{shouldAllowEdit:uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$infra=uiCapabilities.infrastructure)===null||_uiCapabilities$infra===void 0?void 0:_uiCapabilities$infra.configureSource}))};var app_navigation=__webpack_require__(229);const MetricsAlertDropdown=()=>{const[popoverOpen,setPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[visibleFlyoutType,setVisibleFlyoutType]=Object(external_kbnSharedDeps_React_["useState"])(null);const closeFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setVisibleFlyoutType(null),[setVisibleFlyoutType]);const manageAlertsLinkProps=Object(use_link_props["b"])({app:"management",pathname:"/insightsAndAlerting/triggersActions/alerts"});const panels=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{id:0,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.alertDropdownTitle",{defaultMessage:"Alerts"}),items:[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.infrastructureDropdownMenu",{defaultMessage:"Infrastructure"}),panel:1},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.metricsDropdownMenu",{defaultMessage:"Metrics"}),panel:2},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.manageAlerts",{defaultMessage:"Manage alerts"}),icon:"tableOfContents",onClick:manageAlertsLinkProps.onClick}]},{id:1,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.infrastructureDropdownTitle",{defaultMessage:"Infrastructure alerts"}),items:[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.createInventoryAlertButton",{defaultMessage:"Create inventory alert"}),onClick:()=>setVisibleFlyoutType("inventory")}]},{id:2,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.metricsDropdownTitle",{defaultMessage:"Metrics alerts"}),items:[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.alerting.createThresholdAlertButton",{defaultMessage:"Create threshold alert"}),onClick:()=>setVisibleFlyoutType("threshold")}]}],[manageAlertsLinkProps,setVisibleFlyoutType]);const closePopover=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setPopoverOpen(false)},[setPopoverOpen]);const openPopover=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setPopoverOpen(true)},[setPopoverOpen]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{panelPaddingSize:"none",anchorPosition:"downLeft",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconSide:"right",iconType:"arrowDown",onClick:openPopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.alerting.alertsButton",defaultMessage:"Alerts"})),isOpen:popoverOpen,closePopover:closePopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{initialPanelId:0,panels:panels})),external_kbnSharedDeps_React_default.a.createElement(metrics_alert_dropdown_AlertFlyout,{visibleFlyoutType:visibleFlyoutType,onClose:closeFlyout}))};const metrics_alert_dropdown_AlertFlyout=({visibleFlyoutType:visibleFlyoutType,onClose:onClose})=>{switch(visibleFlyoutType){case"inventory":return external_kbnSharedDeps_React_default.a.createElement(PrefilledInventoryAlertFlyout,{onClose:onClose});case"threshold":return external_kbnSharedDeps_React_default.a.createElement(PrefilledThresholdAlertFlyout,{onClose:onClose});default:return null}};var infra_ml_capabilities=__webpack_require__(177);var subscription_splash_content=__webpack_require__(216);var log_analysis_setup=__webpack_require__(141);var infra_ml=__webpack_require__(108);const createInitialState=({jobTypes:jobTypes})=>({jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"unknown"}),{}),jobSummaries:[],lastSetupErrorMessages:[],setupStatus:{type:"initializing"}});const createStatusReducer=jobTypes=>(state,action)=>{switch(action.type){case"startedSetup":{return{...state,jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"initializing"}),{}),setupStatus:{type:"pending"}}}case"finishedSetup":{const{datafeedSetupResults:datafeedSetupResults,jobSetupResults:jobSetupResults,jobSummaries:jobSummaries,spaceId:spaceId,sourceId:sourceId}=action;const nextJobStatus=jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:hasSuccessfullyCreatedJob(Object(infra_ml["c"])(spaceId,sourceId,jobType))(jobSetupResults)&&hasSuccessfullyStartedDatafeed(Object(infra_ml["b"])(spaceId,sourceId,jobType))(datafeedSetupResults)?"started":"failed"}),{});const nextSetupStatus=Object.values(nextJobStatus).every(jobState=>jobState==="started")?{type:"succeeded"}:{type:"failed",reasons:[...Object.values(datafeedSetupResults).filter(hasError).map(datafeed=>datafeed.error.msg),...Object.values(jobSetupResults).filter(hasError).map(job=>job.error.msg)]};return{...state,jobStatus:nextJobStatus,jobSummaries:jobSummaries,setupStatus:nextSetupStatus}}case"failedSetup":{return{...state,jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"failed"}),{}),setupStatus:{type:"failed",reasons:["unknown"]}}}case"fetchingJobStatuses":{return{...state,setupStatus:state.setupStatus.type==="unknown"?{type:"initializing"}:state.setupStatus}}case"fetchedJobStatuses":{const{payload:jobSummaries,spaceId:spaceId,sourceId:sourceId}=action;const{setupStatus:setupStatus}=state;const nextJobStatus=jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:getJobStatus(Object(infra_ml["c"])(spaceId,sourceId,jobType))(jobSummaries)}),{});const nextSetupStatus=getSetupStatus(nextJobStatus)(setupStatus);return{...state,jobSummaries:jobSummaries,jobStatus:nextJobStatus,setupStatus:nextSetupStatus}}case"failedFetchingJobStatuses":{return{...state,setupStatus:{type:"unknown"},jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"unknown"}),{})}}case"viewedResults":{return{...state,setupStatus:{type:"skipped",newlyCreated:true}}}default:{return state}}};const hasSuccessfullyCreatedJob=jobId=>jobSetupResponses=>jobSetupResponses.filter(jobSetupResponse=>jobSetupResponse.id===jobId&&jobSetupResponse.success&&!jobSetupResponse.error).length>0;const hasSuccessfullyStartedDatafeed=datafeedId=>datafeedSetupResponses=>datafeedSetupResponses.filter(datafeedSetupResponse=>datafeedSetupResponse.id===datafeedId&&datafeedSetupResponse.success&&datafeedSetupResponse.started&&!datafeedSetupResponse.error).length>0;const getJobStatus=jobId=>jobSummaries=>jobSummaries.filter(jobSummary=>jobSummary.id===jobId).map(jobSummary=>{if(jobSummary.jobState==="failed"||jobSummary.datafeedState===""){return"failed"}else if(jobSummary.jobState==="closed"&&jobSummary.datafeedState==="stopped"&&jobSummary.fullJob&&jobSummary.fullJob.finished_time!=null){return"finished"}else if(jobSummary.jobState==="closed"||jobSummary.jobState==="closing"||jobSummary.datafeedState==="stopped"){return"stopped"}else if(jobSummary.jobState==="opening"){return"initializing"}else if(jobSummary.jobState==="opened"&&jobSummary.datafeedState==="started"){return"started"}return"unknown"})[0]||"missing";const getSetupStatus=everyJobStatus=>previousSetupStatus=>Object.entries(everyJobStatus).reduce((setupStatus,[,jobStatus])=>{if(jobStatus==="missing"){return{type:"required"}}else if(setupStatus.type==="required"||setupStatus.type==="succeeded"){return setupStatus}else if(setupStatus.type==="skipped"||Object(infra_ml["e"])(jobStatus)){return{type:"skipped",newlyCreated:setupStatus.type==="skipped"&&setupStatus.newlyCreated}}return setupStatus},previousSetupStatus);const hasError=value=>value.error!=null;const useModuleStatus=jobTypes=>Object(external_kbnSharedDeps_React_["useReducer"])(createStatusReducer(jobTypes),{jobTypes:jobTypes},createInitialState);const useInfraMLModule=({sourceConfiguration:sourceConfiguration,moduleDescriptor:moduleDescriptor})=>{const{services:services}=Object(use_kibana["b"])();const{spaceId:spaceId,sourceId:sourceId,timestampField:timestampField}=sourceConfiguration;const[moduleStatus,dispatchModuleStatus]=useModuleStatus(moduleDescriptor.jobTypes);const[,fetchJobStatus]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{dispatchModuleStatus({type:"fetchingJobStatuses"});return await moduleDescriptor.getJobSummary(spaceId,sourceId,services.http.fetch)},onResolve:jobResponse=>{dispatchModuleStatus({type:"fetchedJobStatuses",payload:jobResponse,spaceId:spaceId,sourceId:sourceId})},onReject:()=>{dispatchModuleStatus({type:"failedFetchingJobStatuses"})}},[spaceId,sourceId]);const[,setUpModule]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async(selectedIndices,start,end,filter,partitionField)=>{dispatchModuleStatus({type:"startedSetup"});const setupResult=await moduleDescriptor.setUpModule({start:start,end:end,filter:filter,moduleSourceConfiguration:{indices:selectedIndices,sourceId:sourceId,spaceId:spaceId,timestampField:timestampField},partitionField:partitionField},services.http.fetch);const jobSummaries=await moduleDescriptor.getJobSummary(spaceId,sourceId,services.http.fetch);return{setupResult:setupResult,jobSummaries:jobSummaries}},onResolve:({setupResult:{datafeeds:datafeeds,jobs:jobs},jobSummaries:jobSummaries})=>{dispatchModuleStatus({type:"finishedSetup",datafeedSetupResults:datafeeds,jobSetupResults:jobs,jobSummaries:jobSummaries,spaceId:spaceId,sourceId:sourceId})},onReject:()=>{dispatchModuleStatus({type:"failedSetup"})}},[moduleDescriptor.setUpModule,spaceId,sourceId,timestampField]);const[cleanUpModuleRequest,cleanUpModule]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>await moduleDescriptor.cleanUpModule(spaceId,sourceId,services.http.fetch)},[spaceId,sourceId]);const isCleaningUp=Object(external_kbnSharedDeps_React_["useMemo"])(()=>cleanUpModuleRequest.state==="pending",[cleanUpModuleRequest.state]);const cleanUpAndSetUpModule=Object(external_kbnSharedDeps_React_["useCallback"])((selectedIndices,start,end,filter,partitionField)=>{dispatchModuleStatus({type:"startedSetup"});cleanUpModule().then(()=>{setUpModule(selectedIndices,start,end,filter,partitionField)}).catch(()=>{dispatchModuleStatus({type:"failedSetup"})})},[cleanUpModule,dispatchModuleStatus,setUpModule]);const viewResults=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{dispatchModuleStatus({type:"viewedResults"})},[dispatchModuleStatus]);const jobIds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>moduleDescriptor.getJobIds(spaceId,sourceId),[moduleDescriptor,spaceId,sourceId]);return{cleanUpAndSetUpModule:cleanUpAndSetUpModule,cleanUpModule:cleanUpModule,fetchJobStatus:fetchJobStatus,isCleaningUp:isCleaningUp,jobIds:jobIds,jobStatus:moduleStatus.jobStatus,jobSummaries:moduleStatus.jobSummaries,lastSetupErrorMessages:moduleStatus.lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setUpModule:setUpModule,setupStatus:moduleStatus.setupStatus,sourceConfiguration:sourceConfiguration,viewResults:viewResults}};const useInfraMLModuleConfiguration=({moduleDescriptor:moduleDescriptor,sourceConfiguration:sourceConfiguration})=>{const getIsJobConfigurationOutdated=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isJobConfigurationOutdated(moduleDescriptor,sourceConfiguration),[sourceConfiguration,moduleDescriptor]);return{getIsJobConfigurationOutdated:getIsJobConfigurationOutdated}};const isJobConfigurationOutdated=({bucketSpan:bucketSpan},currentSourceConfiguration)=>jobSummary=>{if(!jobSummary.fullJob||!jobSummary.fullJob.custom_settings){return false}const jobConfiguration=jobSummary.fullJob.custom_settings.metrics_source_config;return!(jobConfiguration&&jobConfiguration.bucketSpan===bucketSpan&&jobConfiguration.indexPattern&&isSubset(new Set(jobConfiguration.indexPattern.split(",")),new Set(currentSourceConfiguration.indices))&&jobConfiguration.timestampField===currentSourceConfiguration.timestampField)};const isSubset=(subset,superset)=>Array.from(subset).every(subsetElement=>superset.has(subsetElement));var log_analysis=__webpack_require__(84);const useInfraMLModuleDefinition=({sourceConfiguration:{spaceId:spaceId,sourceId:sourceId},moduleDescriptor:moduleDescriptor})=>{const{services:services}=Object(use_kibana["b"])();const[moduleDefinition,setModuleDefinition]=Object(external_kbnSharedDeps_React_["useState"])();const jobDefinitionByJobId=Object(external_kbnSharedDeps_React_["useMemo"])(()=>moduleDefinition?moduleDefinition.jobs.reduce((accumulatedJobDefinitions,jobDefinition)=>({...accumulatedJobDefinitions,[Object(log_analysis["getJobId"])(spaceId,sourceId,jobDefinition.id)]:jobDefinition}),{}):{},[moduleDefinition,sourceId,spaceId]);const[fetchModuleDefinitionRequest,fetchModuleDefinition]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>await moduleDescriptor.getModuleDefinition(services.http.fetch),onResolve:response=>{setModuleDefinition(response)},onReject:()=>{setModuleDefinition(undefined)}},[moduleDescriptor.getModuleDefinition,spaceId,sourceId]);const getIsJobDefinitionOutdated=Object(external_kbnSharedDeps_React_["useCallback"])(jobSummary=>{var _jobSummary$fullJob$c,_jobSummary$fullJob,_jobSummary$fullJob$c2;const jobDefinition=jobDefinitionByJobId[jobSummary.id];if(jobDefinition==null){return false}const currentRevision=jobDefinition===null||jobDefinition===void 0?void 0:jobDefinition.config.custom_settings.job_revision;return((_jobSummary$fullJob$c=(_jobSummary$fullJob=jobSummary.fullJob)===null||_jobSummary$fullJob===void 0?void 0:(_jobSummary$fullJob$c2=_jobSummary$fullJob.custom_settings)===null||_jobSummary$fullJob$c2===void 0?void 0:_jobSummary$fullJob$c2.job_revision)!==null&&_jobSummary$fullJob$c!==void 0?_jobSummary$fullJob$c:0)<(currentRevision!==null&&currentRevision!==void 0?currentRevision:0)},[jobDefinitionByJobId]);return{fetchModuleDefinition:fetchModuleDefinition,fetchModuleDefinitionRequestState:fetchModuleDefinitionRequest.state,getIsJobDefinitionOutdated:getIsJobDefinitionOutdated,jobDefinitionByJobId:jobDefinitionByJobId,moduleDefinition:moduleDefinition}};const callDeleteJobs=async(requestArgs,fetch)=>{const{spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes}=requestArgs;const deleteJobsResponse=await fetch("/api/ml/jobs/delete_jobs",{method:"POST",body:JSON.stringify(deleteJobsRequestPayloadRT.encode({jobIds:jobTypes.map(jobType=>Object(infra_ml["c"])(spaceId,sourceId,jobType))}))});return Object(runtime_types["b"])(deleteJobsResponsePayloadRT)(deleteJobsResponse)};const callGetJobDeletionTasks=async fetch=>{const jobDeletionTasksResponse=await fetch("/api/ml/jobs/deleting_jobs_tasks");return Object(runtime_types["b"])(getJobDeletionTasksResponsePayloadRT)(jobDeletionTasksResponse)};const callStopDatafeeds=async(requestArgs,fetch)=>{const{spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes}=requestArgs;const stopDatafeedResponse=await fetch("/api/ml/jobs/stop_datafeeds",{method:"POST",body:JSON.stringify(stopDatafeedsRequestPayloadRT.encode({datafeedIds:jobTypes.map(jobType=>Object(infra_ml["b"])(spaceId,sourceId,jobType))}))});return Object(runtime_types["b"])(stopDatafeedsResponsePayloadRT)(stopDatafeedResponse)};const deleteJobsRequestPayloadRT=lib["type"]({jobIds:lib["array"](lib["string"])});const deleteJobsResponsePayloadRT=lib["record"](lib["string"],lib["type"]({deleted:lib["boolean"]}));const getJobDeletionTasksResponsePayloadRT=lib["type"]({jobIds:lib["array"](lib["string"])});const stopDatafeedsRequestPayloadRT=lib["type"]({datafeedIds:lib["array"](lib["string"])});const stopDatafeedsResponsePayloadRT=lib["record"](lib["string"],lib["type"]({stopped:lib["boolean"]}));const cleanUpJobsAndDatafeeds=async(spaceId,sourceId,jobTypes,fetch)=>{try{await callStopDatafeeds({spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes},fetch)}catch(err){var _err$res;if((err===null||err===void 0?void 0:(_err$res=err.res)===null||_err$res===void 0?void 0:_err$res.status)!==404){throw err}}return await deleteJobs(spaceId,sourceId,jobTypes,fetch)};const deleteJobs=async(spaceId,sourceId,jobTypes,fetch)=>{const deleteJobsResponse=await callDeleteJobs({spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes},fetch);await waitUntilJobsAreDeleted(spaceId,sourceId,jobTypes,fetch);return deleteJobsResponse};const waitUntilJobsAreDeleted=async(spaceId,sourceId,jobTypes,fetch)=>{const moduleJobIds=jobTypes.map(jobType=>Object(infra_ml["c"])(spaceId,sourceId,jobType));while(true){const{jobIds:jobIdsBeingDeleted}=await callGetJobDeletionTasks(fetch);const needToWait=jobIdsBeingDeleted.some(jobId=>moduleJobIds.includes(jobId));if(needToWait){await timeout(1e3)}else{return true}}};const timeout=ms=>new Promise(res=>setTimeout(res,ms));const callJobsSummaryAPI=async(requestArgs,fetch)=>{const{spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes}=requestArgs;const response=await fetch("/api/ml/jobs/jobs_summary",{method:"POST",body:JSON.stringify(fetchJobStatusRequestPayloadRT.encode({jobIds:jobTypes.map(jobType=>Object(infra_ml["c"])(spaceId,sourceId,jobType))}))});return Object(runtime_types["b"])(fetchJobStatusResponsePayloadRT)(response)};const fetchJobStatusRequestPayloadRT=lib["type"]({jobIds:lib["array"](lib["string"])});const datafeedStateRT=lib["keyof"]({started:null,stopped:null,stopping:null,"":null});const jobStateRT=lib["keyof"]({closed:null,closing:null,deleting:null,failed:null,opened:null,opening:null});const jobCategorizationStatusRT=lib["keyof"]({ok:null,warn:null});const jobModelSizeStatsRT=lib["type"]({categorization_status:jobCategorizationStatusRT,categorized_doc_count:lib["number"],dead_category_count:lib["number"],frequent_category_count:lib["number"],rare_category_count:lib["number"],total_category_count:lib["number"]});const jobSummaryRT=lib["intersection"]([lib["type"]({id:lib["string"],jobState:jobStateRT}),lib["partial"]({datafeedIndices:lib["array"](lib["string"]),datafeedState:datafeedStateRT,fullJob:lib["partial"]({custom_settings:infra_ml["f"],finished_time:lib["number"],model_size_stats:jobModelSizeStatsRT})})]);const fetchJobStatusResponsePayloadRT=lib["array"](jobSummaryRT);const callGetMlModuleAPI=async(moduleId,fetch)=>{const response=await fetch(`/api/ml/modules/get_module/${moduleId}`,{method:"GET"});return Object(runtime_types["b"])(getMlModuleResponsePayloadRT)(response)};const jobDefinitionRT=lib["type"]({id:lib["string"],config:lib["type"]({custom_settings:log_analysis["jobCustomSettingsRT"]})});const getMlModuleResponsePayloadRT=lib["type"]({id:lib["string"],jobs:lib["array"](jobDefinitionRT)});const callSetupMlModuleAPI=async(requestArgs,fetch)=>{const{moduleId:moduleId,start:start,end:end,spaceId:spaceId,sourceId:sourceId,indexPattern:indexPattern,jobOverrides:jobOverrides=[],datafeedOverrides:datafeedOverrides=[],query:query}=requestArgs;const response=await fetch(`/api/ml/modules/setup/${moduleId}`,{method:"POST",body:JSON.stringify(setupMlModuleRequestPayloadRT.encode({start:start,end:end,indexPatternName:indexPattern,prefix:Object(infra_ml["d"])(spaceId,sourceId),startDatafeed:true,jobOverrides:jobOverrides,datafeedOverrides:datafeedOverrides,query:query}))});return Object(runtime_types["b"])(setupMlModuleResponsePayloadRT)(response)};const setupMlModuleTimeParamsRT=lib["partial"]({start:lib["number"],end:lib["number"]});const setupMlModuleJobOverridesRT=lib["type"]({job_id:lib["string"],custom_settings:infra_ml["f"]});const setupMlModuleDatafeedOverridesRT=lib["object"];const setupMlModuleRequestParamsRT=lib["intersection"]([lib["strict"]({indexPatternName:lib["string"],prefix:lib["string"],startDatafeed:lib["boolean"],jobOverrides:lib["array"](setupMlModuleJobOverridesRT),datafeedOverrides:lib["array"](setupMlModuleDatafeedOverridesRT)}),lib["exact"](lib["partial"]({query:lib["object"]}))]);const setupMlModuleRequestPayloadRT=lib["intersection"]([setupMlModuleTimeParamsRT,setupMlModuleRequestParamsRT]);const setupErrorResponseRT=lib["type"]({msg:lib["string"]});const datafeedSetupResponseRT=lib["intersection"]([lib["type"]({id:lib["string"],started:lib["boolean"],success:lib["boolean"]}),lib["partial"]({error:setupErrorResponseRT})]);const jobSetupResponseRT=lib["intersection"]([lib["type"]({id:lib["string"],success:lib["boolean"]}),lib["partial"]({error:setupErrorResponseRT})]);const setupMlModuleResponsePayloadRT=lib["type"]({datafeeds:lib["array"](datafeedSetupResponseRT),jobs:lib["array"](jobSetupResponseRT)});var hosts_memory_usage=__webpack_require__(461);var datafeed_hosts_memory_usage=__webpack_require__(462);var hosts_network_in=__webpack_require__(463);var datafeed_hosts_network_in=__webpack_require__(464);var hosts_network_out=__webpack_require__(465);var datafeed_hosts_network_out=__webpack_require__(466);const module_descriptor_moduleId="metrics_ui_hosts";const moduleName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.metricsModuleName",{defaultMessage:"Metrics anomanly detection"});const moduleDescription=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.metricsHostModuleDescription",{defaultMessage:"Use Machine Learning to automatically detect anomalous log entry rates."});const getJobIds=(spaceId,sourceId)=>infra_ml["g"].reduce((accumulatedJobIds,jobType)=>({...accumulatedJobIds,[jobType]:Object(infra_ml["c"])(spaceId,sourceId,jobType)}),{});const getJobSummary=async(spaceId,sourceId,fetch)=>{const response=await callJobsSummaryAPI({spaceId:spaceId,sourceId:sourceId,jobTypes:infra_ml["g"]},fetch);const jobIds=Object.values(getJobIds(spaceId,sourceId));return response.filter(jobSummary=>jobIds.includes(jobSummary.id))};const getModuleDefinition=async fetch=>await callGetMlModuleAPI(module_descriptor_moduleId,fetch);const module_descriptor_setUpModule=async(setUpModuleArgs,fetch)=>{const{start:start,end:end,filter:filter,moduleSourceConfiguration:{spaceId:spaceId,sourceId:sourceId,indices:indices,timestampField:timestampField},partitionField:partitionField}=setUpModuleArgs;const indexNamePattern=indices.join(",");const jobIds=["hosts_memory_usage","hosts_network_in","hosts_network_out"];const jobOverrides=jobIds.map(id=>{const{job:defaultJobConfig}=getDefaultJobConfigs(id);const analysis_config={...defaultJobConfig.analysis_config};if(partitionField){analysis_config.detectors[0].partition_field_name=partitionField;if(analysis_config.influencers.indexOf(partitionField)===-1){analysis_config.influencers.push(partitionField)}}return{job_id:id,data_description:{time_field:timestampField},analysis_config:analysis_config,custom_settings:{metrics_source_config:{indexPattern:indexNamePattern,timestampField:timestampField,bucketSpan:infra_ml["a"]}}}});const datafeedOverrides=jobIds.map(id=>{const{datafeed:defaultDatafeedConfig}=getDefaultJobConfigs(id);const config={...defaultDatafeedConfig};if(filter){const query=JSON.parse(filter);config.query.bool={...config.query.bool,...query.bool}}if(!partitionField||id==="hosts_memory_usage"){return{...config,job_id:id}}const aggregations={[partitionField]:{terms:{field:partitionField},aggregations:{...defaultDatafeedConfig.aggregations}}};return{...config,job_id:id,aggregations:aggregations}});return callSetupMlModuleAPI({moduleId:module_descriptor_moduleId,start:start,end:end,spaceId:spaceId,sourceId:sourceId,indexPattern:indexNamePattern,jobOverrides:jobOverrides,datafeedOverrides:datafeedOverrides},fetch)};const getDefaultJobConfigs=jobId=>{switch(jobId){case"hosts_memory_usage":return{datafeed:datafeed_hosts_memory_usage,job:hosts_memory_usage};case"hosts_network_in":return{datafeed:datafeed_hosts_network_in,job:hosts_network_in};case"hosts_network_out":return{datafeed:datafeed_hosts_network_out,job:hosts_network_out}}};const module_descriptor_cleanUpModule=async(spaceId,sourceId,fetch)=>await cleanUpJobsAndDatafeeds(spaceId,sourceId,infra_ml["g"],fetch);const metricHostsModule={moduleId:module_descriptor_moduleId,moduleName:moduleName,moduleDescription:moduleDescription,jobTypes:infra_ml["g"],bucketSpan:infra_ml["a"],getJobIds:getJobIds,getJobSummary:getJobSummary,getModuleDefinition:getModuleDefinition,setUpModule:module_descriptor_setUpModule,cleanUpModule:module_descriptor_cleanUpModule};const useMetricHostsModule=({indexPattern:indexPattern,sourceId:sourceId,spaceId:spaceId,timestampField:timestampField})=>{const sourceConfiguration=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({indices:indexPattern.split(","),sourceId:sourceId,spaceId:spaceId,timestampField:timestampField}),[indexPattern,sourceId,spaceId,timestampField]);const infraMLModule=useInfraMLModule({moduleDescriptor:metricHostsModule,sourceConfiguration:sourceConfiguration});const{getIsJobConfigurationOutdated:getIsJobConfigurationOutdated}=useInfraMLModuleConfiguration({sourceConfiguration:sourceConfiguration,moduleDescriptor:metricHostsModule});const{fetchModuleDefinition:fetchModuleDefinition,getIsJobDefinitionOutdated:getIsJobDefinitionOutdated}=useInfraMLModuleDefinition({sourceConfiguration:sourceConfiguration,moduleDescriptor:metricHostsModule});const hasOutdatedJobConfigurations=Object(external_kbnSharedDeps_React_["useMemo"])(()=>infraMLModule.jobSummaries.some(getIsJobConfigurationOutdated),[getIsJobConfigurationOutdated,infraMLModule.jobSummaries]);const hasOutdatedJobDefinitions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>infraMLModule.jobSummaries.some(getIsJobDefinitionOutdated),[getIsJobDefinitionOutdated,infraMLModule.jobSummaries]);const hasStoppedJobs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(infraMLModule.jobStatus).some(currentJobStatus=>currentJobStatus==="stopped"),[infraMLModule.jobStatus]);return{...infraMLModule,fetchModuleDefinition:fetchModuleDefinition,hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasStoppedJobs:hasStoppedJobs}};const[MetricHostsModuleProvider,useMetricHostsModuleContext]=constate_cjs_default()(useMetricHostsModule);var k8s_memory_usage=__webpack_require__(467);var datafeed_k8s_memory_usage=__webpack_require__(468);var k8s_network_in=__webpack_require__(469);var datafeed_k8s_network_in=__webpack_require__(470);var k8s_network_out=__webpack_require__(471);var datafeed_k8s_network_out=__webpack_require__(472);const DEFAULT_K8S_PARTITION_FIELD="kubernetes.namespace";const metrics_k8s_module_descriptor_moduleId="metrics_ui_k8s";const module_descriptor_moduleName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.metricsModuleName",{defaultMessage:"Metrics anomanly detection"});const module_descriptor_moduleDescription=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.metricsHostModuleDescription",{defaultMessage:"Use Machine Learning to automatically detect anomalous log entry rates."});const module_descriptor_getJobIds=(spaceId,sourceId)=>infra_ml["h"].reduce((accumulatedJobIds,jobType)=>({...accumulatedJobIds,[jobType]:Object(infra_ml["c"])(spaceId,sourceId,jobType)}),{});const module_descriptor_getJobSummary=async(spaceId,sourceId,fetch)=>{const response=await callJobsSummaryAPI({spaceId:spaceId,sourceId:sourceId,jobTypes:infra_ml["h"]},fetch);const jobIds=Object.values(module_descriptor_getJobIds(spaceId,sourceId));return response.filter(jobSummary=>jobIds.includes(jobSummary.id))};const module_descriptor_getModuleDefinition=async fetch=>await callGetMlModuleAPI(metrics_k8s_module_descriptor_moduleId,fetch);const metrics_k8s_module_descriptor_setUpModule=async(setUpModuleArgs,fetch)=>{const{start:start,end:end,filter:filter,moduleSourceConfiguration:{spaceId:spaceId,sourceId:sourceId,indices:indices,timestampField:timestampField},partitionField:partitionField}=setUpModuleArgs;const indexNamePattern=indices.join(",");const jobIds=["k8s_memory_usage","k8s_network_in","k8s_network_out"];const jobOverrides=jobIds.map(id=>{const{job:defaultJobConfig}=module_descriptor_getDefaultJobConfigs(id);const analysis_config={...defaultJobConfig.analysis_config};if(partitionField){analysis_config.detectors[0].partition_field_name=partitionField;if(analysis_config.influencers.indexOf(partitionField)===-1){analysis_config.influencers.push(partitionField)}}return{job_id:id,data_description:{time_field:timestampField},analysis_config:analysis_config,custom_settings:{metrics_source_config:{indexPattern:indexNamePattern,timestampField:timestampField,bucketSpan:infra_ml["a"]}}}});const datafeedOverrides=jobIds.map(id=>{const{datafeed:defaultDatafeedConfig}=module_descriptor_getDefaultJobConfigs(id);const config={...defaultDatafeedConfig};if(filter){const query=JSON.parse(filter);config.query.bool={...config.query.bool,...query.bool}}if(!partitionField||id==="k8s_memory_usage"){return{...config,job_id:id}}const innerAggregation=defaultDatafeedConfig.aggregations[DEFAULT_K8S_PARTITION_FIELD].aggregations;const aggregations={[partitionField]:{terms:{field:partitionField,size:25},aggregations:{...innerAggregation}}};return{...config,job_id:id,aggregations:aggregations}});return callSetupMlModuleAPI({moduleId:metrics_k8s_module_descriptor_moduleId,start:start,end:end,spaceId:spaceId,sourceId:sourceId,indexPattern:indexNamePattern,jobOverrides:jobOverrides,datafeedOverrides:datafeedOverrides},fetch)};const module_descriptor_getDefaultJobConfigs=jobId=>{switch(jobId){case"k8s_memory_usage":return{datafeed:datafeed_k8s_memory_usage,job:k8s_memory_usage};case"k8s_network_in":return{datafeed:datafeed_k8s_network_in,job:k8s_network_in};case"k8s_network_out":return{datafeed:datafeed_k8s_network_out,job:k8s_network_out}}};const metrics_k8s_module_descriptor_cleanUpModule=async(spaceId,sourceId,fetch)=>await cleanUpJobsAndDatafeeds(spaceId,sourceId,infra_ml["h"],fetch);const module_descriptor_metricHostsModule={moduleId:metrics_k8s_module_descriptor_moduleId,moduleName:module_descriptor_moduleName,moduleDescription:module_descriptor_moduleDescription,jobTypes:infra_ml["h"],bucketSpan:infra_ml["a"],getJobIds:module_descriptor_getJobIds,getJobSummary:module_descriptor_getJobSummary,getModuleDefinition:module_descriptor_getModuleDefinition,setUpModule:metrics_k8s_module_descriptor_setUpModule,cleanUpModule:metrics_k8s_module_descriptor_cleanUpModule};const useMetricK8sModule=({indexPattern:indexPattern,sourceId:sourceId,spaceId:spaceId,timestampField:timestampField})=>{const sourceConfiguration=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({indices:indexPattern.split(","),sourceId:sourceId,spaceId:spaceId,timestampField:timestampField}),[indexPattern,sourceId,spaceId,timestampField]);const infraMLModule=useInfraMLModule({moduleDescriptor:module_descriptor_metricHostsModule,sourceConfiguration:sourceConfiguration});const{getIsJobConfigurationOutdated:getIsJobConfigurationOutdated}=useInfraMLModuleConfiguration({sourceConfiguration:sourceConfiguration,moduleDescriptor:module_descriptor_metricHostsModule});const{fetchModuleDefinition:fetchModuleDefinition,getIsJobDefinitionOutdated:getIsJobDefinitionOutdated}=useInfraMLModuleDefinition({sourceConfiguration:sourceConfiguration,moduleDescriptor:module_descriptor_metricHostsModule});const hasOutdatedJobConfigurations=Object(external_kbnSharedDeps_React_["useMemo"])(()=>infraMLModule.jobSummaries.some(getIsJobConfigurationOutdated),[getIsJobConfigurationOutdated,infraMLModule.jobSummaries]);const hasOutdatedJobDefinitions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>infraMLModule.jobSummaries.some(getIsJobDefinitionOutdated),[getIsJobDefinitionOutdated,infraMLModule.jobSummaries]);const hasStoppedJobs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(infraMLModule.jobStatus).some(currentJobStatus=>currentJobStatus==="stopped"),[infraMLModule.jobStatus]);return{...infraMLModule,fetchModuleDefinition:fetchModuleDefinition,hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasStoppedJobs:hasStoppedJobs}};const[MetricK8sModuleProvider,useMetricK8sModuleContext]=constate_cjs_default()(useMetricK8sModule);function flyout_home_extends(){flyout_home_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return flyout_home_extends.apply(this,arguments)}const FlyoutHome=props=>{const[tab]=Object(external_kbnSharedDeps_React_["useState"])("jobs");const{goToSetup:goToSetup}=props;const{fetchJobStatus:fetchHostJobStatus,setupStatus:hostSetupStatus,jobSummaries:hostJobSummaries}=useMetricHostsModuleContext();const{fetchJobStatus:fetchK8sJobStatus,setupStatus:k8sSetupStatus,jobSummaries:k8sJobSummaries}=useMetricK8sModuleContext();const{hasInfraMLCapabilities:hasInfraMLCapabilities,hasInfraMLReadCapabilities:hasInfraMLReadCapabilities,hasInfraMLSetupCapabilities:hasInfraMLSetupCapabilities}=Object(infra_ml_capabilities["c"])();const createHosts=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{goToSetup("hosts")},[goToSetup]);const createK8s=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{goToSetup("kubernetes")},[goToSetup]);const jobIds=[...(k8sJobSummaries||[]).map(k=>k.id),...(hostJobSummaries||[]).map(h=>h.id)];Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasInfraMLReadCapabilities){fetchHostJobStatus();fetchK8sJobStatus()}},[fetchK8sJobStatus,fetchHostJobStatus,hasInfraMLReadCapabilities]);if(!hasInfraMLCapabilities){return external_kbnSharedDeps_React_default.a.createElement(subscription_splash_content["a"],null)}else if(!hasInfraMLReadCapabilities){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["e"],null)}else if(hostSetupStatus.type==="initializing"||k8sSetupStatus.type==="initializing"){return external_kbnSharedDeps_React_default.a.createElement(loading_page["a"],{message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.anomalyFlyout.jobStatusLoadingMessage",{defaultMessage:"Checking status of metrics jobs..."})})}else if(!hasInfraMLSetupCapabilities){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["f"],null)}else{return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Machine Learning anomaly detection",id:"xpack.infra.ml.anomalyFlyout.flyoutHeader"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Anomaly detection is powered by machine learning. Machine learning jobs are available for the following resource types. Enable these jobs to begin detecting anomalies in your infrastructure metrics.",id:"xpack.infra.ml.anomalyFlyout.create.description"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),(hostJobSummaries.length>0||k8sJobSummaries.length>0)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(JobsEnabledCallout,{hasHostJobs:hostJobSummaries.length>0,hasK8sJobs:k8sJobSummaries.length>0,jobIds:jobIds}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})),tab==="jobs"&&external_kbnSharedDeps_React_default.a.createElement(CreateJobTab,{hasHostJobs:hostJobSummaries.length>0,hasK8sJobs:k8sJobSummaries.length>0,hasSetupCapabilities:props.hasSetupCapabilities,createHosts:createHosts,createK8s:createK8s})))}};const JobsEnabledCallout=props=>{let target="";if(props.hasHostJobs&&props.hasK8sJobs){target=`${external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.anomalyFlyout.create.hostTitle",{defaultMessage:"Hosts"})} and ${external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle",{defaultMessage:"Kubernetes"})}`}else if(props.hasHostJobs){target=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.anomalyFlyout.create.hostSuccessTitle",{defaultMessage:"Hosts"})}else if(props.hasK8sJobs){target=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.ml.anomalyFlyout.create.k8sSuccessTitle",{defaultMessage:"Kubernetes"})}const manageJobsLinkProps=Object(use_link_props["b"])({app:"ml",pathname:"/jobs"});const anomaliesUrl=Object(use_link_props["b"])({app:"ml",pathname:`/explorer?_g=${createResultsUrl(props.jobIds)}`});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],flyout_home_extends({},manageJobsLinkProps,{style:{marginRight:5}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Manage jobs",id:"xpack.infra.ml.anomalyFlyout.manageJobs"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],anomaliesUrl,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"View anomalies",id:"xpack.infra.ml.anomalyFlyout.anomaliesTabLabel"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"m",color:"success",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Anomaly detection enabled for {target}",id:"xpack.infra.ml.anomalyFlyout.enabledCallout",values:{target:target}}),iconType:"check"}))};const CreateJobTab=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCard"],{isDisabled:!props.hasSetupCapabilities,icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"storage"}),title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Hosts",id:"xpack.infra.ml.anomalyFlyout.create.hostTitle"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Detect anomalies for memory usage and network traffic on hosts.",id:"xpack.infra.ml.anomalyFlyout.create.hostDescription"}),footer:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,props.hasHostJobs&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.createHosts},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Recreate jobs",id:"xpack.infra.ml.anomalyFlyout.create.recreateButton"})),!props.hasHostJobs&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:props.createHosts},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Enable",id:"xpack.infra.ml.anomalyFlyout.create.createButton"})))})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCard"],{isDisabled:!props.hasSetupCapabilities,icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"logoKubernetes"}),title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Kubernetes Pods",id:"xpack.infra.ml.anomalyFlyout.create.k8sTitle"}),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Detect anomalies for memory usage and network traffic on Kubernetes Pods.",id:"xpack.infra.ml.anomalyFlyout.create.k8sDescription"}),footer:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,props.hasK8sJobs&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.createK8s},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Recreate jobs",id:"xpack.infra.ml.anomalyFlyout.create.recreateButton"})),!props.hasK8sJobs&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:props.createK8s},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Enable",id:"xpack.infra.ml.anomalyFlyout.create.createButton"})))}))));function createResultsUrl(jobIds,mode="absolute"){const idString=jobIds.map(j=>`'${j}'`).join(",");let path="";const from=external_kbnSharedDeps_Moment_default()().subtract(4,"weeks").toISOString();const to=external_kbnSharedDeps_Moment_default()().toISOString();path+=`(ml:(jobIds:!(${idString}))`;path+=`,refreshInterval:(display:Off,pause:!f,value:0),time:(from:'${from}'`;path+=`,to:'${to}'`;if(mode==="invalid"){path+=`,mode:invalid`}path+="))&_a=(query:(query_string:(analyze_wildcard:!t,query:'*')))";return path}var use_source_via_http=__webpack_require__(178);var fixed_datepicker=__webpack_require__(249);const JobSetupScreen=props=>{const[now]=Object(external_kbnSharedDeps_React_["useState"])(()=>external_kbnSharedDeps_Moment_default()());const{goHome:goHome}=props;const[startDate,setStartDate]=Object(external_kbnSharedDeps_React_["useState"])(now.clone().subtract(4,"weeks"));const[partitionField,setPartitionField]=Object(external_kbnSharedDeps_React_["useState"])(null);const h=useMetricHostsModuleContext();const k=useMetricK8sModuleContext();const[filter,setFilter]=Object(external_kbnSharedDeps_React_["useState"])("");const[filterQuery,setFilterQuery]=Object(external_kbnSharedDeps_React_["useState"])("");const{createDerivedIndexPattern:createDerivedIndexPattern}=Object(use_source_via_http["a"])({sourceId:"default",type:"metrics"});const indicies=h.sourceConfiguration.indices;const setupStatus=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(props.jobType==="kubernetes"){return k.setupStatus}else{return h.setupStatus}},[props.jobType,k.setupStatus,h.setupStatus]);const cleanUpAndSetUpModule=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(props.jobType==="kubernetes"){return k.cleanUpAndSetUpModule}else{return h.cleanUpAndSetUpModule}},[props.jobType,k.cleanUpAndSetUpModule,h.cleanUpAndSetUpModule]);const setUpModule=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(props.jobType==="kubernetes"){return k.setUpModule}else{return h.setUpModule}},[props.jobType,k.setUpModule,h.setUpModule]);const hasSummaries=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(props.jobType==="kubernetes"){return k.jobSummaries.length>0}else{return h.jobSummaries.length>0}},[props.jobType,k.jobSummaries,h.jobSummaries]);const derivedIndexPattern=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createDerivedIndexPattern("metrics"),[createDerivedIndexPattern]);const updateStart=Object(external_kbnSharedDeps_React_["useCallback"])(date=>{setStartDate(date)},[]);const createJobs=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(hasSummaries){cleanUpAndSetUpModule(indicies,external_kbnSharedDeps_Moment_default()(startDate).toDate().getTime(),undefined,filterQuery,partitionField?partitionField[0]:undefined)}else{setUpModule(indicies,external_kbnSharedDeps_Moment_default()(startDate).toDate().getTime(),undefined,filterQuery,partitionField?partitionField[0]:undefined)}},[cleanUpAndSetUpModule,filterQuery,setUpModule,hasSummaries,indicies,partitionField,startDate]);const onFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(f=>{setFilter(f||"");setFilterQuery(Object(kuery["a"])(f,derivedIndexPattern)||"")},[derivedIndexPattern]);const debouncedOnFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(Object(external_kbnSharedDeps_Lodash_["debounce"])(onFilterChange,500),[onFilterChange]);const onPartitionFieldChange=Object(external_kbnSharedDeps_React_["useCallback"])(value=>{setPartitionField(value.map(v=>v.label))},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(props.jobType==="kubernetes"){setPartitionField([DEFAULT_K8S_PARTITION_FIELD])}},[props.jobType]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(setupStatus.type==="succeeded"){goHome()}},[setupStatus,goHome]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Enable machine learning for {nodeType}",id:"xpack.infra.ml.aomalyFlyout.jobSetup.flyoutHeader",values:{nodeType:props.jobType}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,setupStatus.type==="pending"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.loadingText",defaultMessage:"Creating ML job..."}))):setupStatus.type==="failed"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.failureText",defaultMessage:"Something went wrong creating the necessary ML jobs."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,onClick:createJobs},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.tryAgainButton",defaultMessage:"Try again"}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.description",defaultMessage:"Settings can not be changed once the jobs are created. You can recreate jobs anytime, however, the previously detected anomalies are removed."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.when.title",defaultMessage:"When does your model begin?"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.when.description",defaultMessage:"By default, machine learning jobs analyze the last 4 weeks of data and continue to run indefinitely."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.when.timePicker.label",defaultMessage:"Start date"})},external_kbnSharedDeps_React_default.a.createElement(fixed_datepicker["a"],{showTimeSelect:true,selected:startDate,onChange:updateStart,maxDate:now}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.partition.title",defaultMessage:"How do you want to partition your data?"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.partition.description",defaultMessage:"Partitions enable you to build independent models for groups of data that share similar behavior. For example, you can partition by machine type or cloud availability zone."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.partition.label",defaultMessage:"Partition field"}),display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.groupByLabel",{defaultMessage:"Everything"}),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsExplorer.groupByAriaLabel",{defaultMessage:"Graph per"}),fullWidth:true,singleSelection:true,selectedOptions:partitionField?partitionField.map(p=>({label:p})):undefined,options:derivedIndexPattern.fields.filter(f=>f.aggregatable&&f.type==="string").map(f=>({label:f.name})),onChange:onPartitionFieldChange,isClearable:true}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.filter.title",defaultMessage:"Filter"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.filter.description",defaultMessage:"By default, machine learning jobs analyze all of your metric data."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.filter.label",defaultMessage:"Filter (optional)"})},external_kbnSharedDeps_React_default.a.createElement(kuery_bar["a"],{derivedIndexPattern:derivedIndexPattern,onSubmit:onFilterChange,onChange:debouncedOnFilterChange,value:filter})))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:props.closeFlyout},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.cancelButton",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,fullWidth:false,onClick:createJobs},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.steps.setupProcess.enableButton",defaultMessage:"Enable jobs"}))))))};var use_kibana_space=__webpack_require__(200);const AnomalyDetectionFlyout=()=>{var _source$configuration,_source$configuration2,_source$configuration3,_source$configuration4;const{hasInfraMLSetupCapabilities:hasInfraMLSetupCapabilities}=Object(infra_ml_capabilities["b"])();const[showFlyout,setShowFlyout]=Object(external_kbnSharedDeps_React_["useState"])(false);const[screenName,setScreenName]=Object(external_kbnSharedDeps_React_["useState"])("home");const[screenParams,setScreenParams]=Object(external_kbnSharedDeps_React_["useState"])(null);const{source:source}=Object(use_source_via_http["a"])({sourceId:"default",type:"metrics"});const{space:space}=Object(use_kibana_space["a"])();const openFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setScreenName("home");setShowFlyout(true)},[]);const openJobSetup=Object(external_kbnSharedDeps_React_["useCallback"])(jobType=>{setScreenName("setup");setScreenParams({jobType:jobType})},[setScreenName]);const closeFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setShowFlyout(false)},[]);if((source===null||source===void 0?void 0:source.configuration.metricAlias)==null||space==null){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconSide:"left",iconType:"inspect",onClick:openFlyout},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.ml.anomalyDetectionButton",defaultMessage:"Anomaly detection"})),showFlyout&&external_kbnSharedDeps_React_default.a.createElement(MetricHostsModuleProvider,{indexPattern:(_source$configuration=source===null||source===void 0?void 0:source.configuration.metricAlias)!==null&&_source$configuration!==void 0?_source$configuration:"",sourceId:"default",spaceId:space.id,timestampField:(_source$configuration2=source===null||source===void 0?void 0:source.configuration.fields.timestamp)!==null&&_source$configuration2!==void 0?_source$configuration2:""},external_kbnSharedDeps_React_default.a.createElement(MetricK8sModuleProvider,{indexPattern:(_source$configuration3=source===null||source===void 0?void 0:source.configuration.metricAlias)!==null&&_source$configuration3!==void 0?_source$configuration3:"",sourceId:"default",spaceId:space.id,timestampField:(_source$configuration4=source===null||source===void 0?void 0:source.configuration.fields.timestamp)!==null&&_source$configuration4!==void 0?_source$configuration4:""},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:closeFlyout,"data-test-subj":"loadMLFlyout"},screenName==="home"&&external_kbnSharedDeps_React_default.a.createElement(FlyoutHome,{hasSetupCapabilities:hasInfraMLSetupCapabilities,goToSetup:openJobSetup}),screenName==="setup"&&external_kbnSharedDeps_React_default.a.createElement(JobSetupScreen,{goHome:openFlyout,closeFlyout:closeFlyout,jobType:screenParams.jobType})))))};var header_action_menu_provider=__webpack_require__(40);function metrics_extends(){metrics_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return metrics_extends.apply(this,arguments)}const ADD_DATA_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricsHeaderAddDataButtonLabel",{defaultMessage:"Add data"});const InfrastructurePage=({match:match})=>{var _useKibana$services$a,_kibana$services,_kibana$services$appl,_uiCapabilities$infra;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const{setHeaderActionMenu:setHeaderActionMenu}=Object(external_kbnSharedDeps_React_["useContext"])(header_action_menu_provider["a"]);const kibana=Object(kibanaReact_public_["useKibana"])();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(containers_source["a"].Provider,{sourceId:"default"},external_kbnSharedDeps_React_default.a.createElement(use_alert_prefill["a"],null,external_kbnSharedDeps_React_default.a.createElement(use_waffle_options["c"],null,external_kbnSharedDeps_React_default.a.createElement(WaffleTimeProvider,null,external_kbnSharedDeps_React_default.a.createElement(WaffleFiltersProvider,null,external_kbnSharedDeps_React_default.a.createElement(infra_ml_capabilities["a"],null,external_kbnSharedDeps_React_default.a.createElement(page["a"],null,external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.documentTitle",{defaultMessage:"Metrics"})}),external_kbnSharedDeps_React_default.a.createElement(help_center_content["a"],{feedbackLink:"https://discuss.elastic.co/c/metrics",appName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.header.infrastructureHelpAppName",{defaultMessage:"Metrics"})}),setHeaderActionMenu&&external_kbnSharedDeps_React_default.a.createElement(observability_public_["HeaderMenuPortal"],{setHeaderActionMenu:setHeaderActionMenu},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"none",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/inventory",component:AnomalyDetectionFlyout})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(MetricsAlertDropdown,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:(_kibana$services=kibana.services)===null||_kibana$services===void 0?void 0:(_kibana$services$appl=_kibana$services.application)===null||_kibana$services$appl===void 0?void 0:_kibana$services$appl.getUrlForApp("/home#/tutorial_directory/metrics"),size:"s",color:"primary",iconType:"indexOpen"},ADD_DATA_LABEL)))),external_kbnSharedDeps_React_default.a.createElement(header["a"],{breadcrumbs:[{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.header.infrastructureTitle",{defaultMessage:"Metrics"})}],readOnlyBadge:!(uiCapabilities!==null&&uiCapabilities!==void 0&&(_uiCapabilities$infra=uiCapabilities.infrastructure)!==null&&_uiCapabilities$infra!==void 0&&_uiCapabilities$infra.save)}),external_kbnSharedDeps_React_default.a.createElement(app_navigation["a"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.header.infrastructureNavigationTitle",{defaultMessage:"Metrics"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(routed_tabs["a"],{tabs:[{app:"metrics",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.inventoryTabTitle",{defaultMessage:"Inventory"}),pathname:"/inventory"},{app:"metrics",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.metricsExplorerTabTitle",{defaultMessage:"Metrics Explorer"}),pathname:"/explorer"},{app:"metrics",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.homePage.settingsTabTitle",{defaultMessage:"Settings"}),pathname:"/settings"}]})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/inventory",component:SnapshotPage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/explorer",render:props=>external_kbnSharedDeps_React_default.a.createElement(WithSource,null,({configuration:configuration,createDerivedIndexPattern:createDerivedIndexPattern})=>external_kbnSharedDeps_React_default.a.createElement(use_metrics_explorer_options["c"].Provider,null,external_kbnSharedDeps_React_default.a.createElement(WithMetricsExplorerOptionsUrlState,null),configuration?external_kbnSharedDeps_React_default.a.createElement(PageContent,{configuration:configuration,createDerivedIndexPattern:createDerivedIndexPattern}):external_kbnSharedDeps_React_default.a.createElement(source_loading_page["a"],null)))}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/settings",component:MetricsSettingsPage}))))))))))};const PageContent=props=>{const{createDerivedIndexPattern:createDerivedIndexPattern,configuration:configuration}=props;const{options:options}=Object(external_kbnSharedDeps_React_["useContext"])(use_metrics_explorer_options["c"].Context);return external_kbnSharedDeps_React_default.a.createElement(SavedViewProvider,{shouldLoadDefault:options.source==="default",viewType:"metrics-explorer-view",defaultViewState:use_metrics_explorer_options["a"]},external_kbnSharedDeps_React_default.a.createElement(MetricsExplorerPage,metrics_extends({derivedIndexPattern:createDerivedIndexPattern("metrics"),source:configuration},props)))};const withMetricPageProviders=Component=>props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(containers_source["a"].Provider,{sourceId:"default"},external_kbnSharedDeps_React_default.a.createElement(MetricsTimeProvider,null,external_kbnSharedDeps_React_default.a.createElement(Component,props))));const NodeDetailsDataPointRT=lib["intersection"]([lib["type"]({timestamp:lib["number"]}),lib["partial"]({value:lib["union"]([lib["number"],lib["null"]])})]);const NodeDetailsDataSeriesRT=lib["type"]({id:lib["string"],label:lib["string"],data:lib["array"](NodeDetailsDataPointRT)});const NodeDetailsMetricDataRT=lib["intersection"]([lib["partial"]({id:lib["union"]([types["a"],lib["null"]])}),lib["type"]({series:lib["array"](NodeDetailsDataSeriesRT)})]);const NodeDetailsMetricDataResponseRT=lib["type"]({metrics:lib["array"](NodeDetailsMetricDataRT)});const NodeDetailsRequestRT=lib["intersection"]([lib["type"]({nodeType:types["c"],nodeId:lib["string"],metrics:lib["array"](types["a"]),timerange:snapshot_api["a"],sourceId:lib["string"]}),lib["partial"]({cloudId:lib["union"]([lib["string"],lib["null"]])})]);function useNodeDetails(metrics,nodeId,nodeType,sourceId,timerange,cloudId){const decodeResponse=response=>Object(pipeable["pipe"])(NodeDetailsMetricDataResponseRT.decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])("/api/metrics/node_details","POST",JSON.stringify({metrics:metrics,nodeId:nodeId,nodeType:nodeType,timerange:timerange,cloudId:cloudId,sourceId:sourceId}),decodeResponse);return{error:error,loading:loading,metrics:response?response.metrics:[],makeRequest:makeRequest}}const MetricsSideNav=({loading:loading,name:name,items:items})=>{const[isOpenOnMobile,setMobileState]=Object(external_kbnSharedDeps_React_["useState"])(false);const toggle=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setMobileState(!isOpenOnMobile)},[isOpenOnMobile]);const content=loading?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSideNav"],{items:items});const mobileContent=loading?null:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSideNav"],{items:items,mobileTitle:name,toggleOpenOnMobile:toggle,isOpenOnMobile:isOpenOnMobile});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageSideBar"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHideFor"],{sizes:["xs","s"]},external_kbnSharedDeps_React_default.a.createElement(SideNavContainer,null,content)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiShowFor"],{sizes:["xs","s"]},mobileContent))};const SideNavContainer=common_["euiStyled"].div`
  position: fixed;
  z-index: 1;
  height: 88vh;
  padding-left: 16px;
  margin-left: -16px;
  overflow-y: auto;
  overflow-x: hidden;
`;const MetricsTimeControls=props=>{const[timepickerQuickRanges]=Object(use_kibana_ui_setting["a"])(data_public_["UI_SETTINGS"].TIMEPICKER_QUICK_RANGES);const{onChangeTimeRange:onChangeTimeRange,onRefresh:onRefresh,currentTimeRange:currentTimeRange,isLiveStreaming:isLiveStreaming,refreshInterval:refreshInterval,setAutoReload:setAutoReload,setRefreshInterval:setRefreshInterval}=props;const commonlyUsedRanges=mapKibanaQuickRangesToDatePickerRanges(timepickerQuickRanges);const handleTimeChange=Object(external_kbnSharedDeps_React_["useCallback"])(({start:start,end:end})=>{onChangeTimeRange({from:start,to:end,interval:">=1m"})},[onChangeTimeRange]);const handleRefreshChange=Object(external_kbnSharedDeps_React_["useCallback"])(({isPaused:isPaused,refreshInterval:_refreshInterval})=>{if(isPaused){setAutoReload(false)}else{setRefreshInterval(_refreshInterval);setAutoReload(true)}},[setAutoReload,setRefreshInterval]);return external_kbnSharedDeps_React_default.a.createElement(MetricsTimeControlsContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{start:currentTimeRange.from.toString(),end:currentTimeRange.to.toString(),isPaused:!isLiveStreaming,refreshInterval:refreshInterval?refreshInterval:0,onTimeChange:handleTimeChange,onRefreshChange:handleRefreshChange,onRefresh:onRefresh,commonlyUsedRanges:commonlyUsedRanges}))};const MetricsTimeControlsContainer=common_["euiStyled"].div`
  max-width: 750px;
`;const SideNavContext=external_kbnSharedDeps_React_default.a.createContext({items:[],addNavItem:item=>{}});const Section=({children:children,metrics:metrics,navLabel:navLabel,sectionLabel:sectionLabel,onChangeRangeTime:onChangeRangeTime,isLiveStreaming:isLiveStreaming,stopLiveStreaming:stopLiveStreaming})=>{const{addNavItem:addNavItem}=Object(external_kbnSharedDeps_React_["useContext"])(SideNavContext);const subNavItems=external_kbnSharedDeps_React_["Children"].toArray(children).reduce((accumulatedChildren,child)=>{var _metrics$find;if(!Object(external_kbnSharedDeps_React_["isValidElement"])(child)){return accumulatedChildren}const metric=(_metrics$find=metrics===null||metrics===void 0?void 0:metrics.find(m=>m.id===child.props.id))!==null&&_metrics$find!==void 0?_metrics$find:null;if(metric===null){return accumulatedChildren}if(!child.props.label){return accumulatedChildren}return[...accumulatedChildren,{id:child.props.id,name:child.props.label,onClick:()=>{const el=document.getElementById(child.props.id);if(el){el.scrollIntoView()}}}]},[]);const childrenWithProps=external_kbnSharedDeps_React_["Children"].map(children,child=>Object(external_kbnSharedDeps_React_["isValidElement"])(child)?Object(external_kbnSharedDeps_React_["cloneElement"])(child,{metrics:metrics,onChangeRangeTime:onChangeRangeTime,isLiveStreaming:isLiveStreaming,stopLiveStreaming:stopLiveStreaming}):null);if(metrics&&subNavItems.length){addNavItem({id:navLabel,name:navLabel,items:subNavItems});return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,sectionLabel)),childrenWithProps)}return null};const SubSection=({id:id,label:label,children:children,metrics:metrics,onChangeRangeTime:onChangeRangeTime,isLiveStreaming:isLiveStreaming,stopLiveStreaming:stopLiveStreaming})=>{const metric=Object(external_kbnSharedDeps_React_["useMemo"])(()=>metrics===null||metrics===void 0?void 0:metrics.find(m=>m.id===id),[id,metrics]);if(!children||!metric){return null}const childrenWithProps=external_kbnSharedDeps_React_["Children"].map(children,child=>{if(Object(external_kbnSharedDeps_React_["isValidElement"])(child)){return Object(external_kbnSharedDeps_React_["cloneElement"])(child,{metric:metric,id:id,onChangeRangeTime:onChangeRangeTime,isLiveStreaming:isLiveStreaming,stopLiveStreaming:stopLiveStreaming})}return null});return external_kbnSharedDeps_React_default.a.createElement("div",{style:{margin:"10px 0 16px 0"},id:id},label?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h4",null,label)):null,childrenWithProps)};var node_modules_color=__webpack_require__(473);var color_default=__webpack_require__.n(node_modules_color);const getFormatter=(formatter="number",template="{{value}}")=>val=>val!=null?Object(formatters["b"])(formatter,template)(val):"";const seriesHasLessThen2DataPoints=series=>series.data.length<2;const getMaxMinTimestamp=metric=>{if(metric.series.some(seriesHasLessThen2DataPoints)){return[0,0]}const values=metric.series.reduce((acc,item)=>{const firstRow=Object(external_kbnSharedDeps_Lodash_["first"])(item.data);const lastRow=Object(external_kbnSharedDeps_Lodash_["last"])(item.data);return acc.concat([firstRow&&firstRow.timestamp||0,lastRow&&lastRow.timestamp||0])},[]);return[Object(external_kbnSharedDeps_Lodash_["min"])(values),Object(external_kbnSharedDeps_Lodash_["max"])(values)]};const getChartName=(seriesOverrides,seriesId,label)=>{if(!seriesOverrides){return label}return Object(external_kbnSharedDeps_Lodash_["get"])(seriesOverrides,[seriesId,"name"],label)};const getChartColor=(seriesOverrides,seriesId)=>{const rawColor=seriesOverrides?Object(external_kbnSharedDeps_Lodash_["get"])(seriesOverrides,[seriesId,"color"]):null;if(!rawColor){return null}const color=new color_default.a(rawColor);return color.hex().toString()};const getChartType=(seriesOverrides,type,seriesId)=>{if(!seriesOverrides||!type){return"line"}const overrideValue=Object(external_kbnSharedDeps_Lodash_["get"])(seriesOverrides,[seriesId,"type"]);if(types["b"].is(overrideValue)){return overrideValue}if(types["b"].is(type)){return type}return"line"};const gauges_section_vis_getFormatter=(defaultFormatter="number",defaultFormatterTemplate="{{value}}",seriesOverrides={},seriesId)=>val=>{if(val==null){return""}const formatter=Object(external_kbnSharedDeps_Lodash_["get"])(seriesOverrides,[seriesId,"formatter"],defaultFormatter);const formatterTemplate=Object(external_kbnSharedDeps_Lodash_["get"])(seriesOverrides,[seriesId,"formatterTemplate"],defaultFormatterTemplate);return Object(formatters["b"])(formatter,formatterTemplate)(val)};const GaugesSectionVis=({id:id,metric:metric,seriesOverrides:seriesOverrides,formatter:formatter,formatterTemplate:formatterTemplate})=>{if(!metric||!id){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(GroupBox,null,metric.series.map(series=>{const lastDataPoint=Object(external_kbnSharedDeps_Lodash_["last"])(series.data);if(!lastDataPoint){return null}const formatterFn=gauges_section_vis_getFormatter(formatter,formatterTemplate,seriesOverrides,series.id);const value=formatterFn(lastDataPoint.value||0);const name=getChartName(seriesOverrides,series.id,series.id);const dataMax=Object(external_kbnSharedDeps_Lodash_["max"])(series.data.map(d=>d.value||0));const gaugeMax=Object(external_kbnSharedDeps_Lodash_["get"])(seriesOverrides,[series.id,"gaugeMax"],dataMax);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:`${id}-${series.id}`,style:{margin:"0.4rem"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{style:{minWidth:"160px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{style:{textAlign:"right"},size:"s"},name),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h1",{style:{textAlign:"right",whiteSpace:"nowrap"}},value)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{value:lastDataPoint.value||0,max:gaugeMax,size:"s",color:"primary"})))})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};const GroupBox=common_["euiStyled"].div`
  display: flex;
  flex-flow: row wrap;
  justify-content: space-evenly;
`;const SeriesChart=props=>{if(props.type==="bar"){return external_kbnSharedDeps_React_default.a.createElement(BarChart,props)}return external_kbnSharedDeps_React_default.a.createElement(AreaChart,props)};const AreaChart=({id:id,color:color,series:series,name:name,type:type,stack:stack})=>{const style={area:{opacity:1,visible:"area"===type},line:{strokeWidth:"area"===type?1:2,visible:true}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["AreaSeries"],{id:id,name:name,xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Time,yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,xAccessor:"timestamp",yAccessors:["value"],data:series.data,areaSeriesStyle:style,color:color?color:void 0,stackAccessors:stack?["timestamp"]:void 0})};const BarChart=({id:id,color:color,series:series,name:name,stack:stack})=>{const style={rectBorder:{stroke:color||void 0,strokeWidth:1,visible:true},rect:{opacity:1}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["BarSeries"],{id:id,name:name,xScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Time,yScaleType:external_kbnSharedDeps_ElasticCharts_["ScaleType"].Linear,xAccessor:"timestamp",yAccessors:["value"],data:series.data,barSeriesStyle:style,color:color?color:void 0,stackAccessors:stack?["timestamp"]:void 0})};const ErrorMessage=({title:title,body:body})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"stats",title:external_kbnSharedDeps_React_default.a.createElement("h3",null,title),body:external_kbnSharedDeps_React_default.a.createElement("p",null,body)});const ChartSectionVis=({id:id,onChangeRangeTime:onChangeRangeTime,metric:metric,stopLiveStreaming:stopLiveStreaming,isLiveStreaming:isLiveStreaming,formatter:formatter,formatterTemplate:formatterTemplate,stacked:stacked,seriesOverrides:seriesOverrides,type:type})=>{const isDarkMode=Object(kibanaReact_public_["useUiSetting"])("theme:darkMode");const[dateFormat]=Object(use_kibana_ui_setting["a"])("dateFormat");const valueFormatter=Object(external_kbnSharedDeps_React_["useCallback"])(getFormatter(formatter,formatterTemplate),[formatter,formatterTemplate]);const dateFormatter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>metric!=null?Object(external_kbnSharedDeps_ElasticCharts_["niceTimeFormatter"])(getMaxMinTimestamp(metric)):undefined,[metric]);const handleTimeChange=Object(external_kbnSharedDeps_React_["useCallback"])(({x:x})=>{if(!x){return}const[from,to]=x;if(onChangeRangeTime){if(isLiveStreaming&&stopLiveStreaming){stopLiveStreaming()}onChangeRangeTime({from:external_kbnSharedDeps_Moment_default()(from).toISOString(),to:external_kbnSharedDeps_Moment_default()(to).toISOString(),interval:">=1m"})}},[onChangeRangeTime,isLiveStreaming,stopLiveStreaming]);const tooltipProps={headerFormatter:Object(external_kbnSharedDeps_React_["useCallback"])(data=>external_kbnSharedDeps_Moment_default()(data.value).format(dateFormat||"Y-MM-DD HH:mm:ss.SSS"),[dateFormat])};if(!id){return null}else if(!metric){return external_kbnSharedDeps_React_default.a.createElement(ErrorMessage,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.chartSection.missingMetricDataText",{defaultMessage:"Missing Data"}),body:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.chartSection.missingMetricDataBody",{defaultMessage:"The data for this chart is missing."})})}else if(metric.series.some(seriesHasLessThen2DataPoints)){return external_kbnSharedDeps_React_default.a.createElement(ErrorMessage,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.chartSection.notEnoughDataPointsToRenderTitle",{defaultMessage:"Not Enough Data"}),body:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.chartSection.notEnoughDataPointsToRenderText",{defaultMessage:"Not enough data points to render chart, try increasing the time range."})})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,external_kbnSharedDeps_React_default.a.createElement("div",{className:"infrastructureChart",style:{height:250,marginBottom:16}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"timestamp",position:external_kbnSharedDeps_ElasticCharts_["Position"].Bottom,showOverlappingTicks:true,tickFormat:dateFormatter}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Axis"],{id:"values",position:external_kbnSharedDeps_ElasticCharts_["Position"].Left,tickFormat:valueFormatter}),metric&&metric.series.map(series=>external_kbnSharedDeps_React_default.a.createElement(SeriesChart,{key:`series-${id}-${series.id}`,id:`series-${id}-${series.id}`,series:series,name:getChartName(seriesOverrides,series.id,series.id),type:getChartType(seriesOverrides,type,series.id),color:getChartColor(seriesOverrides,series.id),stack:stacked})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{tooltip:tooltipProps,onBrushEnd:handleTimeChange,theme:Object(get_chart_theme["a"])(isDarkMode),showLegend:true,showLegendExtra:true,legendPosition:"right"}))))};const aws_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"AWS",sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"AWS Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsOverview"},external_kbnSharedDeps_React_default.a.createElement(GaugesSectionVis,{seriesOverrides:{"cpu-util":{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.cpuUtilizationSeriesLabel",{defaultMessage:"CPU Utilization"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},"status-check-failed":{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.statusCheckFailedLabel",{defaultMessage:"Status check failed"}),color:theme.eui.euiColorFullShade},"packets-in":{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.networkPacketsInLabel",{defaultMessage:"Packets (in)"}),color:theme.eui.euiColorFullShade,formatter:"number"},"packets-out":{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.overviewSection.networkPacketsOutLabel",{defaultMessage:"Packets (out)"}),color:theme.eui.euiColorFullShade,formatter:"number"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsCpuUtilization",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.cpuUtilSection.sectionLabel",{defaultMessage:"CPU Utilization"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"number",seriesOverrides:{"cpu-util":{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.cpuUtilSection.percentSeriesLabel",{defaultMessage:"percent"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsNetworkBytes",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkBytesSection.sectionLabel",{defaultMessage:"Network Traffic"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"bits",formatterTemplate:"{{value}}/s",seriesOverrides:{tx:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkBytesSection.txSeriesLabel",{defaultMessage:"out"})},rx:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkBytesSection.rxSeriesLabel",{defaultMessage:"in"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsNetworkPackets",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkPacketsSection.sectionLabel",{defaultMessage:"Network Packets (Average)"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"number",seriesOverrides:{"packets-out":{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkPacketsSection.packetsOutSeriesLabel",{defaultMessage:"out"})},"packets-in":{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.networkPacketsSection.packetsInSeriesLabel",{defaultMessage:"in"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsDiskioOps",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioOperationsSection.sectionLabel",{defaultMessage:"Disk I/O Operations"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"number",seriesOverrides:{writes:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioOperationsSection.writesSeriesLabel",{defaultMessage:"writes"})},reads:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioOperationsSection.readsSeriesLabel",{defaultMessage:"reads"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsDiskioBytes",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioBytesSection.sectionLabel",{defaultMessage:"Disk I/O Bytes"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"number",seriesOverrides:{writes:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioBytesSection.writesSeriesLabel",{defaultMessage:"writes"})},reads:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.awsMetricsLayout.diskioBytesSection.readsSeriesLabel",{defaultMessage:"reads"})}}})))));const nginx_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"Nginx",sectionLabel:"Nginx",metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"nginxHits",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.nginxMetricsLayout.hitsSection.sectionLabel",{defaultMessage:"Hits"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{stacked:true,type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{"200s":{color:theme.eui.euiColorVis1},"300s":{color:theme.eui.euiColorVis5},"400s":{color:theme.eui.euiColorVis2},"500s":{color:theme.eui.euiColorVis9}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"nginxRequestRate",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.nginxMetricsLayout.requestRateSection.sectionLabel",{defaultMessage:"Request Rate"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"abbreviatedNumber",formatterTemplate:"{{value}}/s",seriesOverrides:{rate:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"nginxActiveConnections",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.nginxMetricsLayout.activeConnectionsSection.sectionLabel",{defaultMessage:"Active Connections"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"abbreviatedNumber",seriesOverrides:{connections:{color:theme.eui.euiColorVis1,type:"bar"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"nginxRequestsPerConnection",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.nginxMetricsLayout.requestsPerConnectionsSection.sectionLabel",{defaultMessage:"Requests per Connections"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{reqPerConns:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.nginxMetricsLayout.requestsPerConnectionsSection.reqsPerConnSeriesLabel",{defaultMessage:"reqs per conn"})}}})))));const MetadataContext=external_kbnSharedDeps_React_default.a.createContext(null);const FIELDS=[{field:"cloud.instance.id",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.instanceId",{defaultMessage:"Instance ID"})},{field:"cloud.provider",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.cloudProvider",{defaultMessage:"Cloud Provider"})},{field:"host.os.name",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.operatinSystem",{defaultMessage:"Operating System"})},{field:"host.os.kernel",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.kernelVersion",{defaultMessage:"Kernel Version"})},{field:"host.hostname",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.hostname",{defaultMessage:"Hostname"})},{field:"host.containerized",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.containerized",{defaultMessage:"Containerized"}),isBoolean:true},{field:"cloud.project.id",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.projectId",{defaultMessage:"Project ID"})},{field:"cloud.availability_zone",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.availabilityZone",{defaultMessage:"Availability Zone"})},{field:"cloud.machine.type",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.machineType",{defaultMessage:"Machine Type"})},{field:"cloud.instance.name",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.instanceName",{defaultMessage:"Instance Name"})}];const getLabelForField=({field:field})=>{const fieldDef=FIELDS.find(f=>f.field===field);if(!fieldDef)return field;return fieldDef.label};const getValueForField=(metadata,{field:field,isBoolean:isBoolean})=>{if(isBoolean){return Object(external_kbnSharedDeps_Lodash_["get"])(metadata.info,field,false)?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.yes",{defaultMessage:"Yes"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.no",{defaultMessage:"No"})}const value=Object(external_kbnSharedDeps_Lodash_["get"])(metadata.info,field,"--");return value};const NUMBER_OF_COLUMNS=4;const MetadataDetails=props=>{const[isOpen,setControlState]=Object(external_kbnSharedDeps_React_["useState"])(false);const toggleIsOpen=Object(external_kbnSharedDeps_React_["useCallback"])(()=>isOpen?setControlState(false):setControlState(true),[isOpen]);const filteredFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(props.fields&&props.fields.length){return props.fields.map(field=>{const fieldDef=FIELDS.find(f=>f.field===field);if(fieldDef){return fieldDef}}).filter(f=>f)}else{return FIELDS}},[props.fields]);const fields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isOpen?filteredFields:filteredFields.slice(0,NUMBER_OF_COLUMNS),[filteredFields,isOpen]);const metadata=Object(external_kbnSharedDeps_React_["useContext"])(MetadataContext);if(!metadata){return null}return external_kbnSharedDeps_React_default.a.createElement(MetadataContainer,null,filteredFields.length>NUMBER_OF_COLUMNS?external_kbnSharedDeps_React_default.a.createElement(Controls,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:isOpen?"arrowUp":"arrowDown",onClick:toggleIsOpen,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.nodeDetails.labels.showMoreDetails",{defaultMessage:"Show more details"})})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:NUMBER_OF_COLUMNS,style:{flexGrow:1},gutterSize:"s"},fields.map(field=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:field.field,style:{minWidth:0}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h5",null,getLabelForField(field))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,getValueForField(metadata,field))))))};const MetadataContainer=common_["euiStyled"].div`
border-top: ${props=>props.theme.eui.euiBorderWidthThin} solid ${props=>props.theme.eui.euiBorderColor};
border-bottom: ${props=>props.theme.eui.euiBorderWidthThin} solid ${props=>props.theme.eui.euiBorderColor};
padding: ${props=>props.theme.eui.paddingSizes.m} 0;
margin-bottom: ${props=>props.theme.eui.paddingSizes.m};
display: flex;
`;const Controls=common_["euiStyled"].div`
flex-grow: 0;
margin-right: ${props=>props.theme.eui.paddingSizes.m};
min-width: 0px;
`;const LayoutContent=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPageContent"])`
  position: relative;
`;const host_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MetadataDetails,{fields:["host.hostname","host.os.name","host.os.kernel","host.containerized","cloud.provider","cloud.availability_zone","cloud.machine.type","cloud.project.id","cloud.instance.id","cloud.instance.name"]}),external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.layoutLabel",{defaultMessage:"Host"}),sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Host Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostSystemOverview"},external_kbnSharedDeps_React_default.a.createElement(GaugesSectionVis,{seriesOverrides:{cpu:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},load:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.loadSeriesLabel",{defaultMessage:"Load (5m)"}),color:theme.eui.euiColorFullShade},memory:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.memoryCapacitySeriesLabel",{defaultMessage:"Memory Usage"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},rx:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.inboundRXSeriesLabel",{defaultMessage:"Inbound (RX)"}),color:theme.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"},tx:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.overviewSection.outboundTXSeriesLabel",{defaultMessage:"Outbound (TX)"}),color:theme.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostCpuUsage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{stacked:true,type:"area",formatter:"percent",seriesOverrides:{user:{color:theme.eui.euiColorVis0},system:{color:theme.eui.euiColorVis2},steal:{color:theme.eui.euiColorVis9},irq:{color:theme.eui.euiColorVis4},softirq:{color:theme.eui.euiColorVis6},iowait:{color:theme.eui.euiColorVis7},nice:{color:theme.eui.euiColorVis5}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostLoad",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.sectionLabel",{defaultMessage:"Load"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{seriesOverrides:{load_1m:{color:theme.eui.euiColorVis0,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.oneMinuteSeriesLabel",{defaultMessage:"1m"})},load_5m:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.fiveMinuteSeriesLabel",{defaultMessage:"5m"})},load_15m:{color:theme.eui.euiColorVis3,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.loadSection.fifteenMinuteSeriesLabel",{defaultMessage:"15m"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostMemoryUsage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{stacked:true,formatter:"bytes",type:"area",seriesOverrides:{used:{color:theme.eui.euiColorVis2},free:{color:theme.eui.euiColorVis0},cache:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostNetworkTraffic",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}}))),external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"Kubernetes",sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Kubernetes Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostK8sOverview"},external_kbnSharedDeps_React_default.a.createElement(GaugesSectionVis,{seriesOverrides:{cpucap:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Capacity"}),color:"secondary",formatter:"percent",gaugeMax:1},load:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.loadSeriesLabel",{defaultMessage:"Load (5m)"}),color:"secondary"},memorycap:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Capacity"}),color:"secondary",formatter:"percent",gaugeMax:1},podcap:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.podCapacitySeriesLabel",{defaultMessage:"Pod Capacity"}),color:"secondary",formatter:"percent",gaugeMax:1},diskcap:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.overviewSection.diskCapacitySeriesLabel",{defaultMessage:"Disk Capacity"}),color:"secondary",formatter:"percent",gaugeMax:1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostK8sCpuCap",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodeCpuCapacitySection.sectionLabel",{defaultMessage:"Node CPU Capacity"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"abbreviatedNumber",seriesOverrides:{capacity:{color:theme.eui.euiColorVis2},used:{color:theme.eui.euiColorVis1,type:"area"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostK8sMemoryCap",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodeMemoryCapacitySection.sectionLabel",{defaultMessage:"Node Memory Capacity"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bytes",seriesOverrides:{capacity:{color:theme.eui.euiColorVis2},used:{color:theme.eui.euiColorVis1,type:"area"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostK8sDiskCap",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodeDiskCapacitySection.sectionLabel",{defaultMessage:"Node Disk Capacity"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bytes",seriesOverrides:{capacity:{color:theme.eui.euiColorVis2},used:{color:theme.eui.euiColorVis1,type:"area"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"hostK8sPodCap",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.kubernetesMetricsLayout.nodePodCapacitySection.sectionLabel",{defaultMessage:"Node Pod Capacity"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"number",seriesOverrides:{capacity:{color:theme.eui.euiColorVis2},used:{color:theme.eui.euiColorVis1,type:"area"}}}))),external_kbnSharedDeps_React_default.a.createElement(aws_Layout,{metrics:metrics,onChangeRangeTime:onChangeRangeTime}),external_kbnSharedDeps_React_default.a.createElement(nginx_Layout,{metrics:metrics,onChangeRangeTime:onChangeRangeTime}))));const pod_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MetadataDetails,null),external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.layoutLabel",{defaultMessage:"Pod"}),sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Pod Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"podOverview"},external_kbnSharedDeps_React_default.a.createElement(GaugesSectionVis,{seriesOverrides:{cpu:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},memory:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Usage"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},rx:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.inboundRXSeriesLabel",{defaultMessage:"Inbound (RX)"}),color:theme.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"},tx:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.overviewSection.outboundTXSeriesLabel",{defaultMessage:"Outbound (TX)"}),color:theme.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"podCpuUsage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"percent",type:"area",seriesOverrides:{cpu:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"podMemoryUsage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"percent",seriesOverrides:{memory:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"podNetworkTraffic",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.podMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}}))),external_kbnSharedDeps_React_default.a.createElement(nginx_Layout,{metrics:metrics,onChangeRangeTime:onChangeRangeTime}))));const container_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MetadataDetails,null),external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.layoutLabel",{defaultMessage:"Container"}),sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Container Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"containerOverview"},external_kbnSharedDeps_React_default.a.createElement(GaugesSectionVis,{seriesOverrides:{cpu:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.cpuUsageSeriesLabel",{defaultMessage:"CPU Usage"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},memory:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.memoryUsageSeriesLabel",{defaultMessage:"Memory Usage"}),color:theme.eui.euiColorFullShade,formatter:"percent",gaugeMax:1},rx:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.inboundRXSeriesLabel",{defaultMessage:"Inbound (RX)"}),color:theme.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"},tx:{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.overviewSection.outboundTXSeriesLabel",{defaultMessage:"Outbound (TX)"}),color:theme.eui.euiColorFullShade,formatter:"bits",formatterTemplate:"{{value}}/s"}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"containerCpuUsage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{stacked:true,type:"area",formatter:"percent",seriesOverrides:{cpu:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"containerMemory",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.memoryUsageSection.sectionLabel",{defaultMessage:"Memory Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{stacked:true,type:"area",formatter:"percent",seriesOverrides:{memory:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"containerNetworkTraffic",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"containerDiskIOOps",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoOpsSection.sectionLabel",{defaultMessage:"Disk IO (Ops)"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatterTemplate:"{{value}}/s",formatter:"number",seriesOverrides:{read:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoOpsSection.readRateSeriesLabel",{defaultMessage:"reads"})},write:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoOpsSection.writeRateSeriesLabel",{defaultMessage:"writes"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"containerDiskIOBytes",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoBytesSection.sectionLabel",{defaultMessage:"Disk IO (Bytes)"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"bytes",formatterTemplate:"{{value}}/s",seriesOverrides:{read:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoBytesSection.readRateSeriesLabel",{defaultMessage:"reads"})},write:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.containerMetricsLayout.diskIoBytesSection.writeRateSeriesLabel",{defaultMessage:"writes"})}}}))))));const aws_ec2_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,theme:theme,onChangeRangeTime:onChangeRangeTime})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(MetadataDetails,{fields:["cloud.instance.id","cloud.provider","cloud.availability_zone","cloud.machine.type","cloud.instance.name","cloud.project.id"]}),external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"AWS EC2",sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.ec2MetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws EC2 Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsEC2CpuUtilization",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.ec2MetricsLayout.cpuUsageSection.sectionLabel",{defaultMessage:"CPU Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{stacked:true,type:"area",formatter:"percent",seriesOverrides:{total:{color:theme.eui.euiColorVis1}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsEC2NetworkTraffic",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.ec2MetricsLayout.networkTrafficSection.sectionLabel",{defaultMessage:"Network Traffic"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bits",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{rx:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkRxRateSeriesLabel",{defaultMessage:"in"})},tx:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.hostMetricsLayout.networkTrafficSection.networkTxRateSeriesLabel",{defaultMessage:"out"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsEC2DiskIOBytes",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.sectionLabel",{defaultMessage:"Disk IO (Bytes)"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{formatter:"bytes",formatterTemplate:"{{value}}/s",type:"area",seriesOverrides:{write:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.writeLabel",{defaultMessage:"writes"})},read:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.ec2MetricsLayout.diskIOBytesSection.readLabel",{defaultMessage:"reads"})}}}))))));const aws_s3_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"AWS S3",sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws S3 Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsS3BucketSize",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.bucketSize.sectionLabel",{defaultMessage:"Bucket Size"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"bytes",seriesOverrides:{bytes:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.bucketSize.chartLabel",{defaultMessage:"Total Bytes"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsS3NumberOfObjects",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.numberOfObjects.sectionLabel",{defaultMessage:"Number of Objects"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{objects:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.numberOfObjects.chartLabel",{defaultMessage:"Objects"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsS3TotalRequests",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.totalRequests.sectionLabel",{defaultMessage:"Total Requests"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{total:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.totalRequests.chartLabel",{defaultMessage:"Requests"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsS3DownloadBytes",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.downloadBytes.sectionLabel",{defaultMessage:"Downloaded Bytes"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"bytes",seriesOverrides:{bytes:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.downloadBytes.chartLabel",{defaultMessage:"Bytes"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsS3UploadBytes",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.uploadBytes.sectionLabel",{defaultMessage:"Uploaded Bytes"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"bytes",seriesOverrides:{bytes:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.s3MetricsLayout.uploadBytes.chartLabel",{defaultMessage:"Bytes"})}}}))))));const aws_rds_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"AWS RDS",sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws RDS Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsRDSCpuTotal",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.sectionLabel",{defaultMessage:"Total CPU Usage"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"area",formatter:"percent",seriesOverrides:{cpu:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.cpuTotal.chartLabel",{defaultMessage:"Total"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsRDSConnections",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.connections.sectionLabel",{defaultMessage:"Connections"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"number",seriesOverrides:{connections:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.connections.chartLabel",{defaultMessage:"Connections"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsRDSQueriesExecuted",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.sectionLabel",{defaultMessage:"Queries Executed"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"number",seriesOverrides:{queries:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.queriesExecuted.chartLabel",{defaultMessage:"Queries"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsRDSActiveTransactions",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.activeTransactions.sectionLabel",{defaultMessage:"Transactions"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"number",seriesOverrides:{active:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.active.chartLabel",{defaultMessage:"Active"})},blocked:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.blocked.chartLabel",{defaultMessage:"Blocked"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsRDSLatency",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.sectionLabel",{defaultMessage:"Latency"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",stacked:true,formatter:"highPercision",formatterTemplate:"{{value}} ms",seriesOverrides:{read:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.read.chartLabel",{defaultMessage:"Read"})},write:{color:theme.eui.euiColorVis2,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.write.chartLabel",{defaultMessage:"Write"})},insert:{color:theme.eui.euiColorVis0,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.insert.chartLabel",{defaultMessage:"Insert"})},update:{color:theme.eui.euiColorVis7,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.update.chartLabel",{defaultMessage:"Update"})},commit:{color:theme.eui.euiColorVis3,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.rdsMetricsLayout.latency.commit.chartLabel",{defaultMessage:"Commit"})}}}))))));const aws_sqs_layout_Layout=Object(common_["withTheme"])(({metrics:metrics,onChangeRangeTime:onChangeRangeTime,theme:theme})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LayoutContent,null,external_kbnSharedDeps_React_default.a.createElement(Section,{navLabel:"AWS SQS",sectionLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.overviewSection.sectionLabel",{defaultMessage:"Aws SQS Overview"}),metrics:metrics,onChangeRangeTime:onChangeRangeTime},external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsSQSMessagesVisible",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesVisible.sectionLabel",{defaultMessage:"Messages Available"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{visible:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesVisible.chartLabel",{defaultMessage:"Available"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsSQSMessagesDelayed",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesDelayed.sectionLabel",{defaultMessage:"Messages Delayed"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{delayed:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesDelayed.chartLabel",{defaultMessage:"Delayed"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsSQSMessagesSent",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesSent.sectionLabel",{defaultMessage:"Messages Added"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{sent:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesSent.chartLabel",{defaultMessage:"Added"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsSQSMessagesEmpty",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesEmpty.sectionLabel",{defaultMessage:"Messages Empty"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{sent:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.messagesEmpty.chartLabel",{defaultMessage:"Empty"})}}})),external_kbnSharedDeps_React_default.a.createElement(SubSection,{id:"awsSQSOldestMessage",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.oldestMessage.sectionLabel",{defaultMessage:"Oldest Message"})},external_kbnSharedDeps_React_default.a.createElement(ChartSectionVis,{type:"bar",formatter:"abbreviatedNumber",seriesOverrides:{oldest:{color:theme.eui.euiColorVis1,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.sqsMetricsLayout.oldestMessage.chartLabel",{defaultMessage:"Age"})}}}))))));const layouts={host:host_layout_Layout,pod:pod_layout_Layout,container:container_layout_Layout,awsEC2:aws_ec2_layout_Layout,awsS3:aws_s3_layout_Layout,awsRDS:aws_rds_layout_Layout,awsSQS:aws_sqs_layout_Layout};const findLayout=type=>{const Layout=layouts===null||layouts===void 0?void 0:layouts[type];if(!Layout){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.findLayout.error",{defaultMessage:"The layout you've attempted to find does not exist"}))}return Layout};const PageBody=({loading:loading,refetch:refetch,type:type,metrics:metrics,onChangeRangeTime:onChangeRangeTime,isLiveStreaming:isLiveStreaming,stopLiveStreaming:stopLiveStreaming})=>{if(loading){return external_kbnSharedDeps_React_default.a.createElement(components_loading["a"],{height:"100vh",width:"auto",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.loadingNodeDataText",{defaultMessage:"Loading data"})})}else if(!loading&&metrics&&metrics.length===0){return external_kbnSharedDeps_React_default.a.createElement(empty_states["a"],{titleText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.emptyViewTitle",{defaultMessage:"There is no data to display."}),bodyText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.emptyViewDescription",{defaultMessage:"Try adjusting your time or filter."}),refetchText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.refetchButtonLabel",{defaultMessage:"Check for new data"}),onRefetch:refetch,testString:"metricsEmptyViewState"})}const Layout=findLayout(type);return external_kbnSharedDeps_React_default.a.createElement(Layout,{metrics:metrics,onChangeRangeTime:onChangeRangeTime,isLiveStreaming:isLiveStreaming,stopLiveStreaming:stopLiveStreaming})};function invalid_node_extends(){invalid_node_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return invalid_node_extends.apply(this,arguments)}const InvalidNodeError=({nodeName:nodeName})=>{const tutorialLinkProps=Object(use_link_props["b"])({app:"home",hash:"/tutorial_directory/metrics"});return external_kbnSharedDeps_React_default.a.createElement(CenteredEmptyPrompt,{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.invalidNodeErrorTitle",defaultMessage:"Looks like {nodeName} isn't collecting any metrics data",values:{nodeName:nodeName}})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.invalidNodeErrorDescription",defaultMessage:"Double check your configuration"})),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],invalid_node_extends({},tutorialLinkProps,{color:"primary",fill:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.homePage.noMetricsIndicesInstructionsActionLabel",defaultMessage:"View setup instructions"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(source_configuration["a"],{app:"metrics","data-test-subj":"configureSourceButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.configureSourceActionLabel",defaultMessage:"Change source configuration"}))))})};const CenteredEmptyPrompt=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"])`
  align-self: center;
`;const PageError=({error:error,name:name})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:previousTitle=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.documentTitleError",{defaultMessage:"{previousTitle} | Uh oh",values:{previousTitle:previousTitle}})}),error.body.statusCode=404?external_kbnSharedDeps_React_default.a.createElement(InvalidNodeError,{nodeName:name}):undefined);const NodeDetailsPage=props=>{const{parsedTimeRange:parsedTimeRange}=props;const{metrics:metrics,loading:loading,makeRequest:makeRequest,error:error}=useNodeDetails(props.requiredMetrics,props.nodeId,props.nodeType,props.sourceId,props.parsedTimeRange,props.cloudId);const refetch=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{makeRequest()},[makeRequest]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{makeRequest()},[makeRequest,parsedTimeRange]);if(error){return external_kbnSharedDeps_React_default.a.createElement(PageError,{error:error,name:props.name})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],{style:{flex:"1 0 auto"}},external_kbnSharedDeps_React_default.a.createElement(MetricsSideNav,{loading:props.metadataLoading,name:props.name,items:props.sideNav}),external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{content:false,bounds:true,detectAnyWindowResize:true},({bounds:{width:width=0}})=>{const w=width?`${width}px`:`100%`;return external_kbnSharedDeps_React_default.a.createElement(MetricsDetailsPageColumn,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],{style:{width:w}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeader"],{style:{flex:"0 0 auto"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeaderSection"],{style:{width:"100%"}},external_kbnSharedDeps_React_default.a.createElement(MetricsTitleTimeRangeContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHideFor"],{sizes:["xs","s"]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h1",null,props.name))),external_kbnSharedDeps_React_default.a.createElement(MetricsTimeControls,{currentTimeRange:props.timeRange,isLiveStreaming:props.isAutoReloading,refreshInterval:props.refreshInterval,setRefreshInterval:props.setRefreshInterval,onChangeTimeRange:props.setTimeRange,setAutoReload:props.setAutoReload,onRefresh:refetch})))),external_kbnSharedDeps_React_default.a.createElement(SideNavContext.Provider,{value:{items:props.sideNav,addNavItem:props.addNavItem}},external_kbnSharedDeps_React_default.a.createElement(MetadataContext.Provider,{value:props.metadata},external_kbnSharedDeps_React_default.a.createElement(PageBody,{loading:metrics.length>0&&props.isAutoReloading?false:loading,refetch:refetch,type:props.nodeType,metrics:metrics,onChangeRangeTime:props.setTimeRange,isLiveStreaming:props.isAutoReloading,stopLiveStreaming:()=>props.setAutoReload(false)})))))}))};const MetricsDetailsPageColumn=common_["euiStyled"].div`
  flex: 1 0 0%;
  display: flex;
  flex-direction: column;
`;const MetricsTitleTimeRangeContainer=common_["euiStyled"].div`
  display: flex;
  flex-flow: row wrap;
  justify-content: space-between;
`;const metric_detail_DetailPageContent=Object(common_["euiStyled"])(page["c"])`
  overflow: auto;
  background-color: ${props=>props.theme.eui.euiColorLightestShade};
`;const MetricDetail=withMetricPageProviders(Object(common_["withTheme"])(({match:match})=>{var _useKibana$services$a,_uiCapabilities$infra;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const nodeId=match.params.node;const nodeType=match.params.type;const inventoryModel=Object(inventory_models["b"])(nodeType);const{sourceId:sourceId}=Object(external_kbnSharedDeps_React_["useContext"])(containers_source["a"].Context);const{timeRange:timeRange,parsedTimeRange:parsedTimeRange,setTimeRange:setTimeRange,refreshInterval:refreshInterval,setRefreshInterval:setRefreshInterval,isAutoReloading:isAutoReloading,setAutoReload:setAutoReload,triggerRefresh:triggerRefresh}=useMetricsTimeContext();const{name:name,filteredRequiredMetrics:filteredRequiredMetrics,loading:metadataLoading,cloudId:cloudId,metadata:metadata}=useMetadata(nodeId,nodeType,inventoryModel.requiredMetrics,sourceId,parsedTimeRange);const[sideNav,setSideNav]=Object(external_kbnSharedDeps_React_["useState"])([]);const addNavItem=external_kbnSharedDeps_React_default.a.useCallback(item=>{if(!sideNav.some(n=>n.id===item.id)){setSideNav([item,...sideNav])}},[sideNav]);const metricsLinkProps=Object(use_link_props["b"])({app:"metrics",pathname:"/"});const breadcrumbs=[{...metricsLinkProps,text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.header.infrastructureTitle",{defaultMessage:"Metrics"})},{text:name}];if(metadataLoading&&!filteredRequiredMetrics.length){return external_kbnSharedDeps_React_default.a.createElement(components_loading["a"],{height:"100vh",width:"100%",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.loadingNodeDataText",{defaultMessage:"Loading data"})})}return external_kbnSharedDeps_React_default.a.createElement(page["a"],null,external_kbnSharedDeps_React_default.a.createElement(header["a"],{breadcrumbs:breadcrumbs,readOnlyBadge:!(uiCapabilities!==null&&uiCapabilities!==void 0&&(_uiCapabilities$infra=uiCapabilities.infrastructure)!==null&&_uiCapabilities$infra!==void 0&&_uiCapabilities$infra.save)}),external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metricDetailPage.documentTitle",{defaultMessage:"Infrastructure | Metrics | {name}",values:{name:name}})}),external_kbnSharedDeps_React_default.a.createElement(metric_detail_DetailPageContent,{"data-test-subj":"infraMetricsPage"},metadata?external_kbnSharedDeps_React_default.a.createElement(NodeDetailsPage,{name:name,requiredMetrics:filteredRequiredMetrics,sourceId:sourceId,timeRange:timeRange,parsedTimeRange:parsedTimeRange,nodeType:nodeType,nodeId:nodeId,cloudId:cloudId,metadataLoading:metadataLoading,isAutoReloading:isAutoReloading,refreshInterval:refreshInterval,sideNav:sideNav,metadata:metadata,addNavItem:addNavItem,setRefreshInterval:setRefreshInterval,setAutoReload:setAutoReload,triggerRefresh:triggerRefresh,setTimeRange:setTimeRange}):null))}));var redirect_with_query_params=__webpack_require__(231);var common_providers=__webpack_require__(39);const renderApp=(core,plugins,{element:element,history:history,setHeaderActionMenu:setHeaderActionMenu})=>{const storage=new public_["Storage"](window.localStorage);Object(common_styles["b"])(element);external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(MetricsApp,{core:core,history:history,plugins:plugins,setHeaderActionMenu:setHeaderActionMenu,storage:storage}),element);return()=>{external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(element)}};const MetricsApp=({core:core,history:history,plugins:plugins,setHeaderActionMenu:setHeaderActionMenu,storage:storage})=>{var _uiCapabilities$infra,_uiCapabilities$infra2,_uiCapabilities$infra3,_uiCapabilities$infra4,_uiCapabilities$infra5;const uiCapabilities=core.application.capabilities;return external_kbnSharedDeps_React_default.a.createElement(common_providers["b"],{core:core,plugins:plugins},external_kbnSharedDeps_React_default.a.createElement(common_providers["a"],{appName:"Metrics UI",setHeaderActionMenu:setHeaderActionMenu,storage:storage,triggersActionsUI:plugins.triggersActionsUi},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:history},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/link-to",component:LinkToMetricsPage}),(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$infra=uiCapabilities.infrastructure)===null||_uiCapabilities$infra===void 0?void 0:_uiCapabilities$infra.show)&&external_kbnSharedDeps_React_default.a.createElement(redirect_with_query_params["a"],{from:"/",exact:true,to:"/inventory"}),(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$infra2=uiCapabilities.infrastructure)===null||_uiCapabilities$infra2===void 0?void 0:_uiCapabilities$infra2.show)&&external_kbnSharedDeps_React_default.a.createElement(redirect_with_query_params["a"],{from:"/snapshot",exact:true,to:"/inventory"}),(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$infra3=uiCapabilities.infrastructure)===null||_uiCapabilities$infra3===void 0?void 0:_uiCapabilities$infra3.show)&&external_kbnSharedDeps_React_default.a.createElement(redirect_with_query_params["a"],{from:"/metrics-explorer",exact:true,to:"/explorer"}),(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$infra4=uiCapabilities.infrastructure)===null||_uiCapabilities$infra4===void 0?void 0:_uiCapabilities$infra4.show)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/detail/:type/:node",component:MetricDetail}),(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$infra5=uiCapabilities.infrastructure)===null||_uiCapabilities$infra5===void 0?void 0:_uiCapabilities$infra5.show)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/",component:InfrastructurePage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{component:_404["a"]})))))}},91:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Color}));__webpack_require__.d(__webpack_exports__,"b",(function(){return colorTransformer}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(8);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);let Color;(function(Color){Color["color0"]="color0";Color["color1"]="color1";Color["color2"]="color2";Color["color3"]="color3";Color["color4"]="color4";Color["color5"]="color5";Color["color6"]="color6";Color["color7"]="color7";Color["color8"]="color8";Color["color9"]="color9"})(Color||(Color={}));const euiPalette=Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["euiPaletteColorBlind"])();const defaultPalette={[Color.color0]:euiPalette[1],[Color.color1]:euiPalette[2],[Color.color2]:euiPalette[0],[Color.color3]:euiPalette[3],[Color.color4]:euiPalette[4],[Color.color5]:euiPalette[5],[Color.color6]:euiPalette[6],[Color.color7]:euiPalette[7],[Color.color8]:euiPalette[8],[Color.color9]:euiPalette[9]};const createPaletteTransformer=palette=>color=>palette[color];const colorTransformer=createPaletteTransformer(defaultPalette);const sampleColor=(usedColors=[])=>{const available=Object(lodash__WEBPACK_IMPORTED_MODULE_0__["difference"])(Object(lodash__WEBPACK_IMPORTED_MODULE_0__["values"])(Color),usedColors);return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["first"])(available)||Color.color0}},93:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return MetricsExplorerChartType}));__webpack_require__.d(__webpack_exports__,"d",(function(){return MetricsExplorerYAxisMode}));__webpack_require__.d(__webpack_exports__,"f",(function(){return metricsExplorerChartOptionsRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return metricExplorerOptionsRT}));__webpack_require__.d(__webpack_exports__,"g",(function(){return metricsExplorerTimeOptionsRT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return DEFAULT_METRICS_EXPLORER_VIEW_STATE}));__webpack_require__.d(__webpack_exports__,"c",(function(){return MetricsExplorerOptionsContainer}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);var lodash__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(21);var lodash__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_1__);var constate__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(83);var constate__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(constate__WEBPACK_IMPORTED_MODULE_2__);var react__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);var _alerting_use_alert_prefill__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(122);var _common_color_palette__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__(91);var _common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__(100);var _hooks_use_kibana_timefilter_time__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__(111);const metricsExplorerOptionsMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([_common_http_api_metrics_explorer__WEBPACK_IMPORTED_MODULE_6__["d"],io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({rate:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],color:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](Object.fromEntries(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["values"])(_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"]).map(c=>[c,null]))),label:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);let MetricsExplorerChartType;(function(MetricsExplorerChartType){MetricsExplorerChartType["line"]="line";MetricsExplorerChartType["area"]="area";MetricsExplorerChartType["bar"]="bar"})(MetricsExplorerChartType||(MetricsExplorerChartType={}));let MetricsExplorerYAxisMode;(function(MetricsExplorerYAxisMode){MetricsExplorerYAxisMode["fromZero"]="fromZero";MetricsExplorerYAxisMode["auto"]="auto"})(MetricsExplorerYAxisMode||(MetricsExplorerYAxisMode={}));const metricsExplorerChartOptionsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({yAxisMode:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](Object.fromEntries(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["values"])(MetricsExplorerYAxisMode).map(v=>[v,null]))),type:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](Object.fromEntries(Object(lodash__WEBPACK_IMPORTED_MODULE_1__["values"])(MetricsExplorerChartType).map(v=>[v,null]))),stack:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]});const metricExplorerOptionsRequiredRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({aggregation:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerOptionsMetricRT)});const metricExplorerOptionsOptionalRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({limit:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],groupBy:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])]),filterQuery:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],source:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],forceInterval:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],dropLastBucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]});const metricExplorerOptionsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([metricExplorerOptionsRequiredRT,metricExplorerOptionsOptionalRT]);const metricsExplorerTimeOptionsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({from:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],to:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const DEFAULT_TIMERANGE={from:"now-1h",to:"now",interval:">=10s"};const DEFAULT_CHART_OPTIONS={type:MetricsExplorerChartType.line,yAxisMode:MetricsExplorerYAxisMode.fromZero,stack:false};const DEFAULT_METRICS=[{aggregation:"avg",field:"system.cpu.user.pct",color:_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"].color0},{aggregation:"avg",field:"kubernetes.pod.cpu.usage.node.pct",color:_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"].color1},{aggregation:"avg",field:"docker.cpu.total.pct",color:_common_color_palette__WEBPACK_IMPORTED_MODULE_5__["a"].color2}];const DEFAULT_OPTIONS={aggregation:"avg",metrics:DEFAULT_METRICS,source:"default"};const DEFAULT_METRICS_EXPLORER_VIEW_STATE={options:DEFAULT_OPTIONS,chartOptions:DEFAULT_CHART_OPTIONS,currentTimerange:DEFAULT_TIMERANGE};function parseJsonOrDefault(value,defaultValue){if(!value){return defaultValue}try{return JSON.parse(value)}catch(e){return defaultValue}}function useStateWithLocalStorage(key,defaultState){const storageState=localStorage.getItem(key);const[state,setState]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(parseJsonOrDefault(storageState,defaultState));Object(react__WEBPACK_IMPORTED_MODULE_3__["useEffect"])(()=>{localStorage.setItem(key,JSON.stringify(state))},[key,state]);return[state,setState]}const useMetricsExplorerOptions=()=>{const TIME_DEFAULTS={from:"now-1h",to:"now"};const[getTime]=Object(_hooks_use_kibana_timefilter_time__WEBPACK_IMPORTED_MODULE_7__["a"])(TIME_DEFAULTS);const{from:from,to:to}=getTime();const defaultTimeRange={from:from,to:to,interval:DEFAULT_TIMERANGE.interval};const[options,setOptions]=useStateWithLocalStorage("MetricsExplorerOptions",DEFAULT_OPTIONS);const[currentTimerange,setTimeRange]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(defaultTimeRange);Object(_hooks_use_kibana_timefilter_time__WEBPACK_IMPORTED_MODULE_7__["b"])(TIME_DEFAULTS,{from:currentTimerange.from,to:currentTimerange.to});const[chartOptions,setChartOptions]=useStateWithLocalStorage("MetricsExplorerChartOptions",DEFAULT_CHART_OPTIONS);const[isAutoReloading,setAutoReloading]=Object(react__WEBPACK_IMPORTED_MODULE_3__["useState"])(false);const{metricThresholdPrefill:metricThresholdPrefill}=Object(_alerting_use_alert_prefill__WEBPACK_IMPORTED_MODULE_4__["b"])();const prefillContext=Object(react__WEBPACK_IMPORTED_MODULE_3__["useMemo"])(()=>metricThresholdPrefill,[metricThresholdPrefill]);Object(react__WEBPACK_IMPORTED_MODULE_3__["useEffect"])(()=>{if(prefillContext){const{setPrefillOptions:setPrefillOptions}=prefillContext;const{metrics:metrics,groupBy:groupBy,filterQuery:filterQuery}=options;setPrefillOptions({metrics:metrics,groupBy:groupBy,filterQuery:filterQuery})}},[options,prefillContext]);return{defaultViewState:{options:DEFAULT_OPTIONS,chartOptions:DEFAULT_CHART_OPTIONS,currentTimerange:defaultTimeRange},options:options,chartOptions:chartOptions,setChartOptions:setChartOptions,currentTimerange:currentTimerange,isAutoReloading:isAutoReloading,setOptions:setOptions,setTimeRange:setTimeRange,startAutoReload:()=>setAutoReloading(true),stopAutoReload:()=>setAutoReloading(false)}};const MetricsExplorerOptionsContainer=constate__WEBPACK_IMPORTED_MODULE_2___default()(useMetricsExplorerOptions)}}]);