/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["infra_bundle_jsonpfunction"]=window["infra_bundle_jsonpfunction"]||[]).push([[4],{106:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useHTTPRequest}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(2);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__);var _utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(85);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(3);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3__);function useHTTPRequest(pathname,method,body,decode=(response=>response),fetch,toastWarning){var _kibana$services$http;const kibana=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3__["useKibana"])();const fetchService=fetch?fetch:(_kibana$services$http=kibana.services.http)===null||_kibana$services$http===void 0?void 0:_kibana$services$http.fetch;const toast=toastWarning?toastWarning:kibana.notifications.toasts.warning;const[response,setResponse]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);const[error,setError]=Object(react__WEBPACK_IMPORTED_MODULE_0__["useState"])(null);const[request,makeRequest]=Object(_utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__["b"])({cancelPreviousOn:"resolution",createPromise:()=>{if(!fetchService){throw new Error("HTTP service is unavailable")}return fetchService(pathname,{method:method,body:body})},onResolve:resp=>setResponse(decode(resp)),onReject:e=>{var _err$response,_err$response2,_err$response3;const err=e;if(e&&e instanceof _utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__["a"]){return}setError(err);toast({toastLifeTimeMs:3e3,title:_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.useHTTPRequest.error.title",{defaultMessage:`Error while fetching resource`}),body:react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",null,err.response?react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5",null,_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.useHTTPRequest.error.status",{defaultMessage:`Error`})),(_err$response=err.response)===null||_err$response===void 0?void 0:_err$response.statusText," (",(_err$response2=err.response)===null||_err$response2===void 0?void 0:_err$response2.status,")",react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5",null,_kbn_i18n__WEBPACK_IMPORTED_MODULE_1__["i18n"].translate("xpack.infra.useHTTPRequest.error.url",{defaultMessage:`URL`})),(_err$response3=err.response)===null||_err$response3===void 0?void 0:_err$response3.url):react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("h5",null,err.message))})}},[pathname,body,method,fetch,toast]);const loading=Object(react__WEBPACK_IMPORTED_MODULE_0__["useMemo"])(()=>{if(request.state==="resolved"&&response===null){return true}return request.state==="pending"},[request.state,response]);return{response:response,error:error,loading:loading,makeRequest:makeRequest}}},122:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertPrefillProvider}));__webpack_require__.d(__webpack_exports__,"b",(function(){return useAlertPrefillContext}));var constate_cjs=__webpack_require__(83);var constate_cjs_default=__webpack_require__.n(constate_cjs);var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var external_kbnSharedDeps_React_=__webpack_require__(1);const useMetricThresholdAlertPrefill=()=>{const[prefillOptionsState,setPrefillOptionsState]=Object(external_kbnSharedDeps_React_["useState"])({groupBy:undefined,filterQuery:undefined,metrics:[]});const{groupBy:groupBy,filterQuery:filterQuery,metrics:metrics}=prefillOptionsState;return{groupBy:groupBy,filterQuery:filterQuery,metrics:metrics,setPrefillOptions(newState){if(!Object(external_kbnSharedDeps_Lodash_["isEqual"])(newState,prefillOptionsState))setPrefillOptionsState(newState)}}};const useInventoryAlertPrefill=()=>{const[nodeType,setNodeType]=Object(external_kbnSharedDeps_React_["useState"])("host");const[filterQuery,setFilterQuery]=Object(external_kbnSharedDeps_React_["useState"])();const[metric,setMetric]=Object(external_kbnSharedDeps_React_["useState"])({type:"cpu"});const[customMetrics,setCustomMetrics]=Object(external_kbnSharedDeps_React_["useState"])([]);return{nodeType:nodeType,filterQuery:filterQuery,metric:metric,customMetrics:customMetrics,setNodeType:setNodeType,setFilterQuery:setFilterQuery,setMetric:setMetric,setCustomMetrics:setCustomMetrics}};const useAlertPrefill=()=>{const metricThresholdPrefill=useMetricThresholdAlertPrefill();const inventoryPrefill=useInventoryAlertPrefill();return{metricThresholdPrefill:metricThresholdPrefill,inventoryPrefill:inventoryPrefill}};const[AlertPrefillProvider,useAlertPrefillContext]=constate_cjs_default()(useAlertPrefill)},134:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"e",(function(){return METRIC_THRESHOLD_ALERT_TYPE_ID}));__webpack_require__.d(__webpack_exports__,"d",(function(){return METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID}));__webpack_require__.d(__webpack_exports__,"b",(function(){return Comparator}));__webpack_require__.d(__webpack_exports__,"a",(function(){return Aggregators}));__webpack_require__.d(__webpack_exports__,"c",(function(){return INFRA_ALERT_PREVIEW_PATH}));var lib=__webpack_require__(0);var types=__webpack_require__(89);const METRIC_THRESHOLD_ALERT_TYPE_ID="metrics.alert.threshold";const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID="metrics.alert.inventory.threshold";const METRIC_ANOMALY_ALERT_TYPE_ID="metrics.alert.anomaly";let Comparator;(function(Comparator){Comparator["GT"]=">";Comparator["LT"]="<";Comparator["GT_OR_EQ"]=">=";Comparator["LT_OR_EQ"]="<=";Comparator["BETWEEN"]="between";Comparator["OUTSIDE_RANGE"]="outside"})(Comparator||(Comparator={}));let Aggregators;(function(Aggregators){Aggregators["COUNT"]="count";Aggregators["AVERAGE"]="avg";Aggregators["SUM"]="sum";Aggregators["MIN"]="min";Aggregators["MAX"]="max";Aggregators["RATE"]="rate";Aggregators["CARDINALITY"]="cardinality";Aggregators["P95"]="p95";Aggregators["P99"]="p99"})(Aggregators||(Aggregators={}));const metricAnomalyNodeTypeRT=lib["union"]([lib["literal"]("hosts"),lib["literal"]("k8s")]);const metricAnomalyMetricRT=lib["union"]([lib["literal"]("memory_usage"),lib["literal"]("network_in"),lib["literal"]("network_out")]);const metricAnomalyInfluencerFilterRT=lib["type"]({fieldName:lib["string"],fieldValue:lib["string"]});const baseAlertRequestParamsRT=lib["intersection"]([lib["partial"]({filterQuery:lib["union"]([lib["string"],lib["undefined"]]),sourceId:lib["string"]}),lib["type"]({lookback:lib["union"]([lib["literal"]("ms"),lib["literal"]("s"),lib["literal"]("m"),lib["literal"]("h"),lib["literal"]("d"),lib["literal"]("w"),lib["literal"]("M"),lib["literal"]("y")]),alertInterval:lib["string"],alertThrottle:lib["string"],alertOnNoData:lib["boolean"],alertNotifyWhen:lib["string"]})]);const metricThresholdAlertPreviewRequestParamsRT=lib["intersection"]([baseAlertRequestParamsRT,lib["partial"]({groupBy:lib["union"]([lib["string"],lib["array"](lib["string"]),lib["undefined"]])}),lib["type"]({alertType:lib["literal"](METRIC_THRESHOLD_ALERT_TYPE_ID),criteria:lib["array"](lib["any"])})]);const inventoryAlertPreviewRequestParamsRT=lib["intersection"]([baseAlertRequestParamsRT,lib["type"]({nodeType:types["c"],alertType:lib["literal"](METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID),criteria:lib["array"](lib["any"])})]);const metricAnomalyAlertPreviewRequestParamsRT=lib["intersection"]([baseAlertRequestParamsRT,lib["type"]({nodeType:metricAnomalyNodeTypeRT,metric:metricAnomalyMetricRT,threshold:lib["number"],alertType:lib["literal"](METRIC_ANOMALY_ALERT_TYPE_ID),spaceId:lib["string"]}),lib["partial"]({influencerFilter:metricAnomalyInfluencerFilterRT})]);const alertPreviewRequestParamsRT=lib["union"]([metricThresholdAlertPreviewRequestParamsRT,inventoryAlertPreviewRequestParamsRT,metricAnomalyAlertPreviewRequestParamsRT]);const alertPreviewSuccessResponsePayloadRT=lib["type"]({numberOfGroups:lib["number"],resultTotals:lib["intersection"]([lib["type"]({fired:lib["number"],noData:lib["number"],error:lib["number"],notifications:lib["number"]}),lib["partial"]({warning:lib["number"]})])});const INFRA_ALERT_PREVIEW_PATH="/api/infra/alerting/preview";const TOO_MANY_BUCKETS_PREVIEW_EXCEPTION="TOO_MANY_BUCKETS_PREVIEW_EXCEPTION";const isTooManyBucketsPreviewException=value=>Boolean(value&&value.TOO_MANY_BUCKETS_PREVIEW_EXCEPTION)},169:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MetricsExplorerKueryBar}));var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(2);var _kbn_i18n__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _containers_with_kuery_autocompletion__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(271);var _components_autocomplete_field__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(288);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(31);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_4__);function validateQuery(query){try{_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_4__["esKuery"].fromKueryExpression(query)}catch(err){return false}return true}const MetricsExplorerKueryBar=({derivedIndexPattern:derivedIndexPattern,onSubmit:onSubmit,onChange:onChange,value:value,placeholder:placeholder,curryLoadSuggestions:curryLoadSuggestions=defaultCurryLoadSuggestions})=>{const[draftQuery,setDraftQuery]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(value||"");const[isValid,setValidation]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(true);Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{if(value){setDraftQuery(value)}},[value]);const handleChange=query=>{setValidation(validateQuery(query));setDraftQuery(query);if(onChange){onChange(query)}};const filteredDerivedIndexPattern={...derivedIndexPattern,fields:derivedIndexPattern.fields};const defaultPlaceholder=_kbn_i18n__WEBPACK_IMPORTED_MODULE_0__["i18n"].translate("xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder",{defaultMessage:"Search for infrastructure data… (e.g. host.name:host-1)"});return react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_containers_with_kuery_autocompletion__WEBPACK_IMPORTED_MODULE_2__["a"],{indexPattern:filteredDerivedIndexPattern},({isLoadingSuggestions:isLoadingSuggestions,loadSuggestions:loadSuggestions,suggestions:suggestions})=>react__WEBPACK_IMPORTED_MODULE_1___default.a.createElement(_components_autocomplete_field__WEBPACK_IMPORTED_MODULE_3__["a"],{"aria-label":placeholder,isLoadingSuggestions:isLoadingSuggestions,isValid:isValid,loadSuggestions:curryLoadSuggestions(loadSuggestions),onChange:handleChange,onSubmit:onSubmit,placeholder:placeholder||defaultPlaceholder,suggestions:suggestions,value:draftQuery}))};const defaultCurryLoadSuggestions=loadSuggestions=>(...args)=>loadSuggestions(...args)},178:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return useSourceViaHttp}));var external_kbnSharedDeps_React_=__webpack_require__(1);var Either=__webpack_require__(14);var lib_function=__webpack_require__(15);var pipeable=__webpack_require__(22);var constate_cjs=__webpack_require__(83);var constate_cjs_default=__webpack_require__.n(constate_cjs);var lib=__webpack_require__(0);var external_kbnSharedDeps_Moment_=__webpack_require__(50);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);const TimestampFromString=new lib["Type"]("TimestampFromString",input=>typeof input==="number",(input,context)=>Object(pipeable["pipe"])(lib["string"].validate(input,context),Object(Either["chain"])(stringInput=>{const momentValue=external_kbnSharedDeps_Moment_default()(stringInput);return momentValue.isValid()?lib["success"](momentValue.valueOf()):lib["failure"](stringInput,context)})),output=>new Date(output).toISOString());const SavedSourceConfigurationFieldsRuntimeType=lib["partial"]({container:lib["string"],host:lib["string"],pod:lib["string"],tiebreaker:lib["string"],timestamp:lib["string"]});const SavedSourceConfigurationTimestampColumnRuntimeType=lib["type"]({timestampColumn:lib["type"]({id:lib["string"]})});const SavedSourceConfigurationMessageColumnRuntimeType=lib["type"]({messageColumn:lib["type"]({id:lib["string"]})});const SavedSourceConfigurationFieldColumnRuntimeType=lib["type"]({fieldColumn:lib["type"]({id:lib["string"],field:lib["string"]})});const SavedSourceConfigurationColumnRuntimeType=lib["union"]([SavedSourceConfigurationTimestampColumnRuntimeType,SavedSourceConfigurationMessageColumnRuntimeType,SavedSourceConfigurationFieldColumnRuntimeType]);const SavedSourceConfigurationRuntimeType=lib["partial"]({name:lib["string"],description:lib["string"],metricAlias:lib["string"],logAlias:lib["string"],inventoryDefaultView:lib["string"],metricsExplorerDefaultView:lib["string"],fields:SavedSourceConfigurationFieldsRuntimeType,logColumns:lib["array"](SavedSourceConfigurationColumnRuntimeType),anomalyThreshold:lib["number"]});const pickSavedSourceConfiguration=value=>{const{name:name,description:description,metricAlias:metricAlias,logAlias:logAlias,fields:fields,inventoryDefaultView:inventoryDefaultView,metricsExplorerDefaultView:metricsExplorerDefaultView,logColumns:logColumns,anomalyThreshold:anomalyThreshold}=value;const{container:container,host:host,pod:pod,tiebreaker:tiebreaker,timestamp:timestamp}=fields;return{name:name,description:description,metricAlias:metricAlias,logAlias:logAlias,inventoryDefaultView:inventoryDefaultView,metricsExplorerDefaultView:metricsExplorerDefaultView,fields:{container:container,host:host,pod:pod,tiebreaker:tiebreaker,timestamp:timestamp},logColumns:logColumns,anomalyThreshold:anomalyThreshold}};const StaticSourceConfigurationFieldsRuntimeType=lib["partial"]({...SavedSourceConfigurationFieldsRuntimeType.props,message:lib["array"](lib["string"])});const StaticSourceConfigurationRuntimeType=lib["partial"]({name:lib["string"],description:lib["string"],metricAlias:lib["string"],logAlias:lib["string"],inventoryDefaultView:lib["string"],metricsExplorerDefaultView:lib["string"],fields:StaticSourceConfigurationFieldsRuntimeType,logColumns:lib["array"](SavedSourceConfigurationColumnRuntimeType),anomalyThreshold:lib["number"]});const SourceConfigurationFieldsRuntimeType=lib["type"]({...StaticSourceConfigurationFieldsRuntimeType.props});const SourceConfigurationRuntimeType=lib["type"]({...SavedSourceConfigurationRuntimeType.props,fields:SourceConfigurationFieldsRuntimeType,logColumns:lib["array"](SavedSourceConfigurationColumnRuntimeType)});const SourceStatusFieldRuntimeType=lib["type"]({name:lib["string"],type:lib["string"],searchable:lib["boolean"],aggregatable:lib["boolean"],displayable:lib["boolean"]});const SourceStatusRuntimeType=lib["type"]({logIndicesExist:lib["boolean"],metricIndicesExist:lib["boolean"],indexFields:lib["array"](SourceStatusFieldRuntimeType)});const SourceRuntimeType=lib["intersection"]([lib["type"]({id:lib["string"],origin:lib["keyof"]({fallback:null,internal:null,stored:null}),configuration:SourceConfigurationRuntimeType}),lib["partial"]({version:lib["string"],updatedAt:lib["number"],status:SourceStatusRuntimeType})]);const SourceResponseRuntimeType=lib["type"]({source:SourceRuntimeType});const SourceConfigurationSavedObjectRuntimeType=lib["intersection"]([lib["type"]({id:lib["string"],attributes:SavedSourceConfigurationRuntimeType}),lib["partial"]({version:lib["string"],updated_at:TimestampFromString})]);var use_http_request=__webpack_require__(106);var runtime_types=__webpack_require__(13);const pickIndexPattern=(source,type)=>{if(!source){return"unknown-index"}if(type==="logs"){return source.configuration.logAlias}if(type==="metrics"){return source.configuration.metricAlias}return`${source.configuration.logAlias},${source.configuration.metricAlias}`};const useSourceViaHttp=({sourceId:sourceId="default",type:type="both",fetch:fetch,toastWarning:toastWarning})=>{const decodeResponse=response=>Object(pipeable["pipe"])(SourceResponseRuntimeType.decode(response),Object(Either["fold"])(Object(runtime_types["c"])(runtime_types["a"]),lib_function["identity"]));const{error:error,loading:loading,response:response,makeRequest:makeRequest}=Object(use_http_request["a"])(`/api/metrics/source/${sourceId}/${type}`,"GET",null,decodeResponse,fetch,toastWarning);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{await makeRequest()})()},[makeRequest]);const createDerivedIndexPattern=Object(external_kbnSharedDeps_React_["useCallback"])((indexType=type)=>({fields:response!==null&&response!==void 0&&response.source.status?response.source.status.indexFields:[],title:pickIndexPattern(response===null||response===void 0?void 0:response.source,indexType)}),[response,type]);const source=Object(external_kbnSharedDeps_React_["useMemo"])(()=>response?response.source:null,[response]);return{createDerivedIndexPattern:createDerivedIndexPattern,source:source,loading:loading,error:error}};const SourceViaHttp=constate_cjs_default()(useSourceViaHttp);const[SourceViaHttpProvider,useSourceViaHttpContext]=SourceViaHttp},207:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return getIntervalInSeconds}));const intervalUnits=["y","M","w","d","h","m","s","ms"];const INTERVAL_STRING_RE=new RegExp("^([0-9\\.]*)\\s*("+intervalUnits.join("|")+")$");const units={ms:.001,s:1,m:60,h:3600,d:86400,w:86400*7,M:86400*30,y:86400*356};const getIntervalInSeconds=interval=>{const matches=interval.match(INTERVAL_STRING_RE);if(matches){return parseFloat(matches[1])*units[matches[2]]}throw new Error("Invalid interval string format.")}},271:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return WithKueryAutocompletion}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(3);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1__);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class WithKueryAutocompletionComponent extends react__WEBPACK_IMPORTED_MODULE_0___default.a.Component{constructor(...args){super(...args);_defineProperty(this,"state",{currentRequest:null,suggestions:[]});_defineProperty(this,"loadSuggestions",async(expression,cursorPosition,maxSuggestions,transformSuggestions)=>{var _this$props$kibana$se;const{indexPattern:indexPattern}=this.props;const language="kuery";const hasQuerySuggestions=(_this$props$kibana$se=this.props.kibana.services.data)===null||_this$props$kibana$se===void 0?void 0:_this$props$kibana$se.autocomplete.hasQuerySuggestions(language);if(!hasQuerySuggestions){return}this.setState({currentRequest:{expression:expression,cursorPosition:cursorPosition},suggestions:[]});const suggestions=await this.props.kibana.services.data.autocomplete.getQuerySuggestions({language:language,query:expression,selectionStart:cursorPosition,selectionEnd:cursorPosition,indexPatterns:[indexPattern],boolFilter:[]})||[];const transformedSuggestions=transformSuggestions?transformSuggestions(suggestions):suggestions;this.setState(state=>state.currentRequest&&state.currentRequest.expression!==expression&&state.currentRequest.cursorPosition!==cursorPosition?state:{...state,currentRequest:null,suggestions:maxSuggestions?transformedSuggestions.slice(0,maxSuggestions):transformedSuggestions})})}render(){const{currentRequest:currentRequest,suggestions:suggestions}=this.state;return this.props.children({isLoadingSuggestions:currentRequest!==null,loadSuggestions:this.loadSuggestions,suggestions:suggestions})}}const WithKueryAutocompletion=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_1__["withKibana"])(WithKueryAutocompletionComponent)},288:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return autocomplete_field_AutocompleteField}));var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var common_=__webpack_require__(11);var external_kbnSharedDeps_Lodash_=__webpack_require__(21);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const asChildFunctionRenderer=(hoc,{onInitialize:onInitialize,onCleanup:onCleanup}={})=>{var _temp;return hoc((_temp=class ChildFunctionRenderer extends external_kbnSharedDeps_React_default.a.Component{constructor(...args){super(...args);_defineProperty(this,"displayName","ChildFunctionRenderer");_defineProperty(this,"getRendererArgs",()=>Object(external_kbnSharedDeps_Lodash_["omit"])(this.props,["children","initializeOnMount","resetOnUnmount"]))}componentDidMount(){if(this.props.initializeOnMount&&onInitialize){onInitialize(this.getRendererArgs())}}componentWillUnmount(){if(this.props.resetOnUnmount&&onCleanup){onCleanup(this.getRendererArgs())}}render(){return this.props.children(this.getRendererArgs())}},_temp))};function composeStateUpdaters(...updaters){return(state,props)=>updaters.reduce((currentState,updater)=>updater(currentState,props)||currentState,state)}var lib=__webpack_require__(114);var public_=__webpack_require__(31);const SuggestionItem=props=>{const{isSelected:isSelected,onClick:onClick,onMouseEnter:onMouseEnter,suggestion:suggestion}=props;return external_kbnSharedDeps_React_default.a.createElement(SuggestionItemContainer,{isSelected:isSelected,onClick:onClick,onMouseEnter:onMouseEnter},external_kbnSharedDeps_React_default.a.createElement(SuggestionItemIconField,{suggestionType:suggestion.type},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:getEuiIconType(suggestion.type)})),external_kbnSharedDeps_React_default.a.createElement(SuggestionItemTextField,null,suggestion.text),external_kbnSharedDeps_React_default.a.createElement(SuggestionItemDescriptionField,null,suggestion.description))};SuggestionItem.defaultProps={isSelected:false};const SuggestionItemContainer=common_["euiStyled"].div`
  display: flex;
  flex-direction: row;
  font-size: ${props=>props.theme.eui.euiFontSizeS};
  height: ${props=>props.theme.eui.euiSizeXL};
  white-space: nowrap;
  background-color: ${props=>props.isSelected?props.theme.eui.euiColorLightestShade:"transparent"};
`;const SuggestionItemField=common_["euiStyled"].div`
  align-items: center;
  cursor: pointer;
  display: flex;
  flex-direction: row;
  height: ${props=>props.theme.eui.euiSizeXL};
  padding: ${props=>props.theme.eui.euiSizeXS};
`;const SuggestionItemIconField=Object(common_["euiStyled"])(SuggestionItemField)`
  background-color: ${props=>Object(lib["transparentize"])(.9,getEuiIconColor(props.theme,props.suggestionType))};
  color: ${props=>getEuiIconColor(props.theme,props.suggestionType)};
  flex: 0 0 auto;
  justify-content: center;
  width: ${props=>props.theme.eui.euiSizeXL};
`;const SuggestionItemTextField=Object(common_["euiStyled"])(SuggestionItemField)`
  flex: 2 0 0;
  font-family: ${props=>props.theme.eui.euiCodeFontFamily};
`;const SuggestionItemDescriptionField=Object(common_["euiStyled"])(SuggestionItemField)`
  flex: 3 0 0;

  p {
    display: inline;

    span {
      font-family: ${props=>props.theme.eui.euiCodeFontFamily};
    }
  }
`;const getEuiIconType=suggestionType=>{switch(suggestionType){case public_["QuerySuggestionTypes"].Field:return"kqlField";case public_["QuerySuggestionTypes"].Value:return"kqlValue";case public_["QuerySuggestionTypes"].RecentSearch:return"search";case public_["QuerySuggestionTypes"].Conjunction:return"kqlSelector";case public_["QuerySuggestionTypes"].Operator:return"kqlOperand";default:return"empty"}};const getEuiIconColor=(theme,suggestionType)=>{switch(suggestionType){case public_["QuerySuggestionTypes"].Field:return theme===null||theme===void 0?void 0:theme.eui.euiColorVis7;case public_["QuerySuggestionTypes"].Value:return theme===null||theme===void 0?void 0:theme.eui.euiColorVis0;case public_["QuerySuggestionTypes"].Operator:return theme===null||theme===void 0?void 0:theme.eui.euiColorVis1;case public_["QuerySuggestionTypes"].Conjunction:return theme===null||theme===void 0?void 0:theme.eui.euiColorVis2;case public_["QuerySuggestionTypes"].RecentSearch:default:return theme===null||theme===void 0?void 0:theme.eui.euiColorMediumShade}};function autocomplete_field_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class autocomplete_field_AutocompleteField extends external_kbnSharedDeps_React_default.a.Component{constructor(...args){super(...args);autocomplete_field_defineProperty(this,"state",{areSuggestionsVisible:false,isFocused:false,selectedIndex:null});autocomplete_field_defineProperty(this,"inputElement",null);autocomplete_field_defineProperty(this,"handleChangeInputRef",element=>{this.inputElement=element});autocomplete_field_defineProperty(this,"handleChange",evt=>{this.changeValue(evt.currentTarget.value)});autocomplete_field_defineProperty(this,"handleKeyDown",evt=>{const{suggestions:suggestions}=this.props;switch(evt.key){case"ArrowUp":evt.preventDefault();if(suggestions.length>0){this.setState(composeStateUpdaters(withSuggestionsVisible,withPreviousSuggestionSelected))}break;case"ArrowDown":evt.preventDefault();if(suggestions.length>0){this.setState(composeStateUpdaters(withSuggestionsVisible,withNextSuggestionSelected))}else{this.updateSuggestions()}break;case"Enter":evt.preventDefault();if(this.state.selectedIndex!==null){this.applySelectedSuggestion()}else{this.submit()}break;case"Escape":evt.preventDefault();this.setState(withSuggestionsHidden);break}});autocomplete_field_defineProperty(this,"handleKeyUp",evt=>{switch(evt.key){case"ArrowLeft":case"ArrowRight":case"Home":case"End":this.updateSuggestions();break}});autocomplete_field_defineProperty(this,"handleFocus",()=>{this.setState(composeStateUpdaters(withSuggestionsVisible,withFocused))});autocomplete_field_defineProperty(this,"handleBlur",()=>{this.setState(composeStateUpdaters(withSuggestionsHidden,withUnfocused))});autocomplete_field_defineProperty(this,"selectSuggestionAt",index=>()=>{this.setState(withSuggestionAtIndexSelected(index))});autocomplete_field_defineProperty(this,"applySelectedSuggestion",()=>{if(this.state.selectedIndex!==null){this.applySuggestionAt(this.state.selectedIndex)()}});autocomplete_field_defineProperty(this,"applySuggestionAt",index=>()=>{const{value:value,suggestions:suggestions}=this.props;const selectedSuggestion=suggestions[index];if(!selectedSuggestion){return}const newValue=value.substr(0,selectedSuggestion.start)+selectedSuggestion.text+value.substr(selectedSuggestion.end);this.setState(withSuggestionsHidden);this.changeValue(newValue);this.focusInputElement()});autocomplete_field_defineProperty(this,"changeValue",value=>{const{onChange:onChange}=this.props;if(onChange){onChange(value)}});autocomplete_field_defineProperty(this,"focusInputElement",()=>{if(this.inputElement){this.inputElement.focus()}});autocomplete_field_defineProperty(this,"showSuggestions",()=>{this.setState(withSuggestionsVisible)});autocomplete_field_defineProperty(this,"submit",()=>{const{isValid:isValid,onSubmit:onSubmit,value:value}=this.props;if(isValid&&onSubmit){onSubmit(value)}this.setState(withSuggestionsHidden)});autocomplete_field_defineProperty(this,"updateSuggestions",()=>{const inputCursorPosition=this.inputElement?this.inputElement.selectionStart||0:0;this.props.loadSuggestions(this.props.value,inputCursorPosition,200)})}render(){const{suggestions:suggestions,isLoadingSuggestions:isLoadingSuggestions,isValid:isValid,placeholder:placeholder,value:value,disabled:disabled,"aria-label":ariaLabel}=this.props;const{areSuggestionsVisible:areSuggestionsVisible,selectedIndex:selectedIndex}=this.state;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiOutsideClickDetector"],{onOutsideClick:this.handleBlur},external_kbnSharedDeps_React_default.a.createElement(AutocompleteContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{fullWidth:true,disabled:disabled,inputRef:this.handleChangeInputRef,isLoading:isLoadingSuggestions,isInvalid:!isValid,onChange:this.handleChange,onFocus:this.handleFocus,onKeyDown:this.handleKeyDown,onKeyUp:this.handleKeyUp,onSearch:this.submit,placeholder:placeholder,value:value,"aria-label":ariaLabel}),areSuggestionsVisible&&!isLoadingSuggestions&&suggestions.length>0?external_kbnSharedDeps_React_default.a.createElement(SuggestionsPanel,null,suggestions.map((suggestion,suggestionIndex)=>external_kbnSharedDeps_React_default.a.createElement(SuggestionItem,{key:suggestion.text,suggestion:suggestion,isSelected:suggestionIndex===selectedIndex,onMouseEnter:this.selectSuggestionAt(suggestionIndex),onClick:this.applySuggestionAt(suggestionIndex)}))):null))}componentDidMount(){if(this.inputElement&&this.props.autoFocus){this.inputElement.focus()}}componentDidUpdate(prevProps){const hasNewValue=prevProps.value!==this.props.value;const hasNewSuggestions=prevProps.suggestions!==this.props.suggestions;if(hasNewValue){this.updateSuggestions()}if(hasNewValue&&this.props.value===""){this.submit()}if(hasNewSuggestions&&this.state.isFocused){this.showSuggestions()}}}const withPreviousSuggestionSelected=(state,props)=>({...state,selectedIndex:props.suggestions.length===0?null:state.selectedIndex!==null?(state.selectedIndex+props.suggestions.length-1)%props.suggestions.length:Math.max(props.suggestions.length-1,0)});const withNextSuggestionSelected=(state,props)=>({...state,selectedIndex:props.suggestions.length===0?null:state.selectedIndex!==null?(state.selectedIndex+1)%props.suggestions.length:0});const withSuggestionAtIndexSelected=suggestionIndex=>(state,props)=>({...state,selectedIndex:props.suggestions.length===0?null:suggestionIndex>=0&&suggestionIndex<props.suggestions.length?suggestionIndex:0});const withSuggestionsVisible=state=>({...state,areSuggestionsVisible:true});const withSuggestionsHidden=state=>({...state,areSuggestionsVisible:false,selectedIndex:null});const withFocused=state=>({...state,isFocused:true});const withUnfocused=state=>({...state,isFocused:false});const AutocompleteContainer=common_["euiStyled"].div`
  position: relative;
`;const SuggestionsPanel=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).attrs(()=>({paddingSize:"none",hasShadow:true}))`
  position: absolute;
  width: 100%;
  margin-top: 2px;
  overflow-x: hidden;
  overflow-y: scroll;
  z-index: ${props=>props.theme.eui.euiZLevel1};
  max-height: 322px;
`}}]);