/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["infra_bundle_jsonpfunction"]=window["infra_bundle_jsonpfunction"]||[]).push([[2],{100:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return METRIC_EXPLORER_AGGREGATIONS}));__webpack_require__.d(__webpack_exports__,"c",(function(){return metricsExplorerAggregationRT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return metricsExplorerMetricRT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return afterKeyObjectRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return metricsExplorerResponseRT}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);const METRIC_EXPLORER_AGGREGATIONS=["avg","max","min","cardinality","rate","count","sum","p95","p99"];const metricsExplorerAggregationKeys=METRIC_EXPLORER_AGGREGATIONS.reduce((acc,agg)=>({...acc,[agg]:null}),{});const metricsExplorerAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](metricsExplorerAggregationKeys);const metricsExplorerMetricRequiredFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({aggregation:metricsExplorerAggregationRT});const metricsExplorerMetricOptionalFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]])});const metricsExplorerMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([metricsExplorerMetricRequiredFieldsRT,metricsExplorerMetricOptionalFieldsRT]);const timeRangeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],from:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],to:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const metricsExplorerRequestBodyRequiredFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timerange:timeRangeRT,indexPattern:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerMetricRT)});const groupByRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]);const afterKeyObjectRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]));const metricsExplorerRequestBodyOptionalFieldsRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({groupBy:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([groupByRT,io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](groupByRT)]),afterKey:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],afterKeyObjectRT]),limit:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]),filterQuery:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]),forceInterval:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],dropLastBucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]});const metricsExplorerRequestBodyRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([metricsExplorerRequestBodyRequiredFieldsRT,metricsExplorerRequestBodyOptionalFieldsRT]);const metricsExplorerPageInfoRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({total:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],afterKey:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],afterKeyObjectRT])});const metricsExplorerColumnTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({date:null,number:null,string:null});const metricsExplorerColumnRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({name:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:metricsExplorerColumnTypeRT});const metricsExplorerRowRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timestamp:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["object"])]))]);const metricsExplorerSeriesRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],columns:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerColumnRT),rows:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerRowRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({keys:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])})]);const metricsExplorerResponseRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({series:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](metricsExplorerSeriesRT),pageInfo:metricsExplorerPageInfoRT})},103:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return convertKueryToElasticSearchQuery}));var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(31);var _src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__);const convertKueryToElasticSearchQuery=(kueryExpression,indexPattern)=>{try{return kueryExpression?JSON.stringify(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__["esKuery"].toElasticsearchQuery(_src_plugins_data_public__WEBPACK_IMPORTED_MODULE_0__["esKuery"].fromKueryExpression(kueryExpression),indexPattern)):""}catch(err){return""}}},104:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return useUrlState}));__webpack_require__.d(__webpack_exports__,"a",(function(){return replaceStateKeyInQueryString}));var query_string__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(34);var query_string__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(query_string__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var rison_node__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(23);var rison_node__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(rison_node__WEBPACK_IMPORTED_MODULE_2__);var react_router_dom__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(67);var react_router_dom__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(react_router_dom__WEBPACK_IMPORTED_MODULE_3__);var _src_plugins_kibana_utils_public__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(33);var _src_plugins_kibana_utils_public__WEBPACK_IMPORTED_MODULE_4___default=__webpack_require__.n(_src_plugins_kibana_utils_public__WEBPACK_IMPORTED_MODULE_4__);const useUrlState=({defaultState:defaultState,decodeUrlState:decodeUrlState,encodeUrlState:encodeUrlState,urlStateKey:urlStateKey,writeDefaultState:writeDefaultState=false})=>{const history=Object(react_router_dom__WEBPACK_IMPORTED_MODULE_3__["useHistory"])();const queryString=history!==null&&history!==void 0&&history.location?getQueryStringFromLocation(history.location):"";const urlStateString=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>{if(!queryString){return}return getParamFromQueryString(queryString,urlStateKey)},[queryString,urlStateKey]);const decodedState=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>decodeUrlState(decodeRisonUrlState(urlStateString)),[decodeUrlState,urlStateString]);const state=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>typeof decodedState!=="undefined"?decodedState:defaultState,[defaultState,decodedState]);const setState=Object(react__WEBPACK_IMPORTED_MODULE_1__["useCallback"])(newState=>{if(!history||!history.location){return}const currentLocation=history.location;const newLocation=replaceQueryStringInLocation(currentLocation,replaceStateKeyInQueryString(urlStateKey,typeof newState!=="undefined"?encodeUrlState(newState):undefined)(getQueryStringFromLocation(currentLocation)));if(newLocation!==currentLocation){history.replace(newLocation)}},[encodeUrlState,history,urlStateKey]);const[shouldInitialize,setShouldInitialize]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(writeDefaultState&&typeof decodedState==="undefined");Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{if(shouldInitialize){setShouldInitialize(false);setState(defaultState)}},[shouldInitialize,setState,defaultState]);return[state,setState]};const decodeRisonUrlState=value=>{try{return value?Object(rison_node__WEBPACK_IMPORTED_MODULE_2__["decode"])(value):undefined}catch(error){if(error instanceof Error&&error.message.startsWith("rison decoder error")){return{}}throw error}};const encodeRisonUrlState=state=>Object(rison_node__WEBPACK_IMPORTED_MODULE_2__["encode"])(state);const getQueryStringFromLocation=location=>location.search.substring(1);const getParamFromQueryString=(queryString,key)=>{const parsedQueryString=Object(query_string__WEBPACK_IMPORTED_MODULE_0__["parse"])(queryString,{sort:false});const queryParam=parsedQueryString[key];return Array.isArray(queryParam)?queryParam[0]:queryParam};const replaceStateKeyInQueryString=(stateKey,urlState)=>queryString=>{const previousQueryValues=Object(query_string__WEBPACK_IMPORTED_MODULE_0__["parse"])(queryString,{sort:false});const newValue=typeof urlState==="undefined"?previousQueryValues:{...previousQueryValues,[stateKey]:encodeRisonUrlState(urlState)};return Object(query_string__WEBPACK_IMPORTED_MODULE_0__["stringify"])(_src_plugins_kibana_utils_public__WEBPACK_IMPORTED_MODULE_4__["url"].encodeQuery(newValue),{sort:false,encode:false})};const replaceQueryStringInLocation=(location,queryString)=>{if(queryString===getQueryStringFromLocation(location)){return location}else{return{...location,search:`?${queryString}`}}}},127:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return MetricsAPISeriesRT}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);var _inventory_models_types__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(89);var _metrics_explorer__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(100);const MetricsAPITimerangeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],from:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],to:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const groupByRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]);const MetricsAPIMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],aggregations:_inventory_models_types__WEBPACK_IMPORTED_MODULE_1__["d"]});const MetricsAPIRequestRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timerange:MetricsAPITimerangeRT,indexPattern:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](MetricsAPIMetricRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({groupBy:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](groupByRT),modules:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]),afterKey:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],_metrics_explorer__WEBPACK_IMPORTED_MODULE_2__["b"]]),limit:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]),filters:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["object"]),dropLastBucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],alignDataToEnd:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]})]);const MetricsAPIPageInfoRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({afterKey:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],_metrics_explorer__WEBPACK_IMPORTED_MODULE_2__["b"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"]]),interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]});const MetricsAPIColumnTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({date:null,number:null,string:null});const MetricsAPIColumnRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({name:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:MetricsAPIColumnTypeRT});const MetricsAPIRowRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timestamp:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"],io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["object"])]))]);const MetricsAPISeriesRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],columns:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](MetricsAPIColumnRT),rows:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](MetricsAPIRowRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({keys:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])})]);const MetricsAPIResponseRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({series:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](MetricsAPISeriesRT),info:MetricsAPIPageInfoRT})},151:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return networkTrafficWithInterfaces}));const networkTrafficWithInterfaces=(id,metricField,interfaceField)=>({[`${id}_interfaces`]:{terms:{field:interfaceField},aggregations:{[`${id}_interface_max`]:{max:{field:metricField}}}},[`${id}_sum_of_interfaces`]:{sum_bucket:{buckets_path:`${id}_interfaces>${id}_interface_max`}},[`${id}_deriv`]:{derivative:{buckets_path:`${id}_sum_of_interfaces`,gap_policy:"skip",unit:"1s"}},[id]:{bucket_script:{buckets_path:{value:`${id}_deriv[normalized_value]`},script:{source:"params.value > 0.0 ? params.value : 0.0",lang:"painless"},gap_policy:"skip"}}})},202:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return useSource}));__webpack_require__.d(__webpack_exports__,"a",(function(){return Source}));__webpack_require__.d(__webpack_exports__,"c",(function(){return useSourceContext}));var constate__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(83);var constate__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(constate__WEBPACK_IMPORTED_MODULE_0__);var react__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(1);var react__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);var _utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(85);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(3);var _src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3__);const pickIndexPattern=(source,type)=>{if(!source){return"unknown-index"}if(type==="logs"){return source.configuration.logAlias}if(type==="metrics"){return source.configuration.metricAlias}return`${source.configuration.logAlias},${source.configuration.metricAlias}`};const DEPENDENCY_ERROR_MESSAGE="Failed to load source: No fetch client available.";const useSource=({sourceId:sourceId})=>{var _kibana$services$http;const kibana=Object(_src_plugins_kibana_react_public__WEBPACK_IMPORTED_MODULE_3__["useKibana"])();const fetchService=(_kibana$services$http=kibana.services.http)===null||_kibana$services$http===void 0?void 0:_kibana$services$http.fetch;const API_URL=`/api/metrics/source/${sourceId}`;const[source,setSource]=Object(react__WEBPACK_IMPORTED_MODULE_1__["useState"])(undefined);const[loadSourceRequest,loadSource]=Object(_utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{if(!fetchService){throw new Error(DEPENDENCY_ERROR_MESSAGE)}return await fetchService(`${API_URL}/metrics`,{method:"GET"})},onResolve:response=>{setSource(response.source)}},[fetchService,sourceId]);const[createSourceConfigurationRequest,createSourceConfiguration]=Object(_utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__["b"])({createPromise:async sourceProperties=>{if(!fetchService){throw new Error(DEPENDENCY_ERROR_MESSAGE)}return await fetchService(API_URL,{method:"PATCH",body:JSON.stringify(sourceProperties)})},onResolve:response=>{if(response){setSource(response.source)}}},[fetchService,sourceId]);const[updateSourceConfigurationRequest,updateSourceConfiguration]=Object(_utils_use_tracked_promise__WEBPACK_IMPORTED_MODULE_2__["b"])({createPromise:async sourceProperties=>{if(!fetchService){throw new Error(DEPENDENCY_ERROR_MESSAGE)}return await fetchService(API_URL,{method:"PATCH",body:JSON.stringify(sourceProperties)})},onResolve:response=>{if(response){setSource(response.source)}}},[fetchService,sourceId]);const createDerivedIndexPattern=type=>({fields:source!==null&&source!==void 0&&source.status?source.status.indexFields:[],title:pickIndexPattern(source,type)});const isLoading=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>[loadSourceRequest.state,createSourceConfigurationRequest.state,updateSourceConfigurationRequest.state].some(state=>state==="pending"),[loadSourceRequest.state,createSourceConfigurationRequest.state,updateSourceConfigurationRequest.state]);const isUninitialized=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>loadSourceRequest.state==="uninitialized",[loadSourceRequest.state]);const sourceExists=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>source?!!source.version:undefined,[source]);const logIndicesExist=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>source&&source.status&&source.status.logIndicesExist,[source]);const metricIndicesExist=Object(react__WEBPACK_IMPORTED_MODULE_1__["useMemo"])(()=>source&&source.status&&source.status.metricIndicesExist,[source]);Object(react__WEBPACK_IMPORTED_MODULE_1__["useEffect"])(()=>{loadSource()},[loadSource,sourceId]);return{createSourceConfiguration:createSourceConfiguration,createDerivedIndexPattern:createDerivedIndexPattern,logIndicesExist:logIndicesExist,isLoading:isLoading,isLoadingSource:loadSourceRequest.state==="pending",isUninitialized:isUninitialized,hasFailedLoadingSource:loadSourceRequest.state==="rejected",loadSource:loadSource,loadSourceFailureMessage:loadSourceRequest.state==="rejected"?`${loadSourceRequest.value}`:undefined,metricIndicesExist:metricIndicesExist,source:source,sourceExists:sourceExists,sourceId:sourceId,updateSourceConfiguration:updateSourceConfiguration,version:source&&source.version?source.version:undefined}};const Source=constate__WEBPACK_IMPORTED_MODULE_0___default()(useSource);const[SourceProvider,useSourceContext]=Source},208:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return inventory_models_metrics_metrics}));var metrics=__webpack_require__(281);const nginxRequestRate=(timeField,indexPattern,interval)=>({id:"nginxRequestRate",requires:["nginx.stubstatus"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"rate",metrics:[{field:"nginx.stubstatus.requests",id:"max-requests",type:"max"},{field:"max-requests",id:"derv-max-requests",type:"derivative",unit:"1s"},{id:"posonly-derv-max-requests",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"derv-max-requests"}],script:"params.rate > 0.0 ? params.rate : 0.0"}],split_mode:"everything"}]});const nginxActiveConnections=(timeField,indexPattern,interval)=>({id:"nginxActiveConnections",requires:["nginx.stubstatus"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"connections",metrics:[{field:"nginx.stubstatus.active",id:"avg-active",type:"avg"}],split_mode:"everything"}]});const nginxHits=(timeField,indexPattern,interval)=>({id:"nginxHits",requires:["nginx.access"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"200s",metrics:[{id:"count-200",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[200 TO 299]",language:"lucene"}},{id:"300s",metrics:[{id:"count-300",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[300 TO 399]",language:"lucene"}},{id:"400s",metrics:[{id:"count-400",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[400 TO 499]",language:"lucene"}},{id:"500s",metrics:[{id:"count-500",type:"count"}],split_mode:"filter",filter:{query:"http.response.status_code:[500 TO 599]",language:"lucene"}}]});const nginxRequestsPerConnection=(timeField,indexPattern,interval)=>({id:"nginxRequestsPerConnection",requires:["nginx.stubstatus"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"reqPerConns",metrics:[{field:"nginx.stubstatus.handled",id:"max-handled",type:"max"},{field:"nginx.stubstatus.requests",id:"max-requests",type:"max"},{id:"reqs-per-connection",type:"calculation",variables:[{id:"var-handled",name:"handled",field:"max-handled"},{id:"var-requests",name:"requests",field:"max-requests"}],script:"params.handled > 0.0 && params.requests > 0.0 ? params.handled / params.requests : 0.0"}],split_mode:"everything"}]});const awsCpuUtilization=(timeField,indexPattern)=>({id:"awsCpuUtilization",requires:["aws.ec2"],map_field_to:"cloud.instance.id",id_type:"cloud",index_pattern:indexPattern,interval:">=5m",time_field:timeField,type:"timeseries",series:[{id:"cpu-util",metrics:[{field:"aws.ec2.cpu.total.pct",id:"avg-cpu-util",type:"avg"}],split_mode:"everything"}]});const awsDiskioBytes=(timeField,indexPattern)=>({id:"awsDiskioBytes",requires:["aws.ec2"],index_pattern:indexPattern,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:timeField,type:"timeseries",series:[{id:"writes",metrics:[{field:"aws.ec2.diskio.write.bytes",id:"sum-diskio-out",type:"sum"},{id:"csum-sum-diskio-out",field:"sum-diskio-out",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-out",unit:"1s",type:"derivative",field:"csum-sum-diskio-out"},{id:"posonly-deriv-csum-sum-diskio-out",field:"deriv-csum-sum-diskio-out",type:"positive_only"}],split_mode:"everything"},{id:"reads",metrics:[{field:"aws.ec2.diskio.read.bytes",id:"sum-diskio-in",type:"sum"},{id:"csum-sum-diskio-in",field:"sum-diskio-in",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-in",unit:"1s",type:"derivative",field:"csum-sum-diskio-in"},{id:"posonly-deriv-csum-sum-diskio-in",field:"deriv-csum-sum-diskio-in",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-diskio-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-diskio-in"}],script:"params.rate * -1"}],split_mode:"everything"}]});const awsDiskioOps=(timeField,indexPattern)=>({id:"awsDiskioOps",requires:["aws.ec2"],index_pattern:indexPattern,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:timeField,type:"timeseries",series:[{id:"writes",metrics:[{field:"aws.ec2.diskio.write.count",id:"sum-diskio-writes",type:"sum"},{id:"csum-sum-diskio-writes",field:"sum-diskio-writes",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-writes",unit:"1s",type:"derivative",field:"csum-sum-diskio-writes"},{id:"posonly-deriv-csum-sum-diskio-writes",field:"deriv-csum-sum-diskio-writes",type:"positive_only"}],split_mode:"everything"},{id:"reads",metrics:[{field:"aws.ec2.diskio.read.count",id:"sum-diskio-reads",type:"sum"},{id:"csum-sum-diskio-reads",field:"sum-diskio-reads",type:"cumulative_sum"},{id:"deriv-csum-sum-diskio-reads",unit:"1s",type:"derivative",field:"csum-sum-diskio-reads"},{id:"posonly-deriv-csum-sum-diskio-reads",field:"deriv-csum-sum-diskio-reads",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-diskio-reads",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-diskio-reads"}],script:"params.rate * -1"}],split_mode:"everything"}]});const awsNetworkBytes=(timeField,indexPattern)=>({id:"awsNetworkBytes",requires:["aws.ec2"],index_pattern:indexPattern,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:timeField,type:"timeseries",series:[{id:"tx",metrics:[{field:"aws.ec2.network.out.bytes",id:"sum-net-out",type:"sum"},{id:"csum-sum-net-out",field:"sum-net-out",type:"cumulative_sum"},{id:"deriv-csum-sum-net-out",unit:"1s",type:"derivative",field:"csum-sum-net-out"},{id:"posonly-deriv-csum-sum-net-out",field:"deriv-csum-sum-net-out",type:"positive_only"}],split_mode:"everything"},{id:"rx",metrics:[{field:"aws.ec2.network.in.bytes",id:"sum-net-in",type:"sum"},{id:"csum-sum-net-in",field:"sum-net-in",type:"cumulative_sum"},{id:"deriv-csum-sum-net-in",unit:"1s",type:"derivative",field:"csum-sum-net-in"},{id:"posonly-deriv-csum-sum-net-in",field:"deriv-csum-sum-net-in",type:"positive_only"},{id:"inverted-posonly-deriv-csum-sum-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"posonly-deriv-csum-sum-net-in"}],script:"params.rate * -1"}],split_mode:"everything"}]});const awsNetworkPackets=(timeField,indexPattern)=>({id:"awsNetworkPackets",requires:["aws.ec2"],index_pattern:indexPattern,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:timeField,type:"timeseries",series:[{id:"packets-out",metrics:[{field:"aws.ec2.network.out.packets",id:"avg-net-out",type:"avg"}],split_mode:"everything"},{id:"packets-in",metrics:[{field:"aws.ec2.network.in.packets",id:"avg-net-in",type:"avg"},{id:"inverted-avg-net-in",type:"calculation",variables:[{id:"var-avg",name:"avg",field:"avg-net-in"}],script:"params.avg * -1"}],split_mode:"everything"}]});const awsOverview=(timeField,indexPattern)=>({id:"awsOverview",requires:["aws.ec2"],index_pattern:indexPattern,map_field_to:"cloud.instance.id",id_type:"cloud",interval:">=5m",time_field:timeField,type:"top_n",series:[{id:"cpu-util",split_mode:"everything",metrics:[{field:"aws.ec2.cpu.total.pct",id:"cpu-total-pct",type:"max"}]},{id:"status-check-failed",split_mode:"everything",metrics:[{field:"aws.ec2.status.check_failed",id:"status-check-failed",type:"max"}]},{id:"packets-out",split_mode:"everything",metrics:[{field:"aws.ec2.network.out.packets",id:"network-out-packets",type:"avg"}]},{id:"packets-in",split_mode:"everything",metrics:[{field:"aws.ec2.network.in.packets",id:"network-in-packets",type:"avg"}]}]});var count=__webpack_require__(227);const metrics_metrics={tsvb:{nginxActiveConnections:nginxActiveConnections,nginxHits:nginxHits,nginxRequestRate:nginxRequestRate,nginxRequestsPerConnection:nginxRequestsPerConnection,awsCpuUtilization:awsCpuUtilization,awsDiskioBytes:awsDiskioBytes,awsDiskioOps:awsDiskioOps,awsNetworkBytes:awsNetworkBytes,awsNetworkPackets:awsNetworkPackets,awsOverview:awsOverview},snapshot:{count:count["a"]},defaultSnapshot:"count",defaultTimeRangeInSeconds:3600};var pod_metrics=__webpack_require__(283);var container_metrics=__webpack_require__(282);var aws_ec2_metrics=__webpack_require__(287);var aws_s3_metrics=__webpack_require__(284);var aws_rds_metrics=__webpack_require__(285);var aws_sqs_metrics=__webpack_require__(286);const inventory_models_metrics_metrics={tsvb:{...metrics["a"].tsvb,...metrics_metrics.tsvb,...pod_metrics["a"].tsvb,...container_metrics["a"].tsvb,...aws_ec2_metrics["a"].tsvb,...aws_s3_metrics["a"].tsvb,...aws_rds_metrics["a"].tsvb,...aws_sqs_metrics["a"].tsvb}}},227:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return count}));const count={count:{bucket_script:{buckets_path:{count:"_count"},script:{source:"count * 1",lang:"expression"},gap_policy:"skip"}}}},281:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));const cpu={cpu_user:{avg:{field:"system.cpu.user.pct"}},cpu_system:{avg:{field:"system.cpu.system.pct"}},cpu_cores:{max:{field:"system.cpu.cores"}},cpu:{bucket_script:{buckets_path:{user:"cpu_user",system:"cpu_system",cores:"cpu_cores"},script:{source:"(params.user + params.system) / params.cores",lang:"painless"},gap_policy:"skip"}}};var count=__webpack_require__(227);const load={load:{avg:{field:"system.load.5"}}};const logRate={count:{bucket_script:{buckets_path:{count:"_count"},script:{source:"count * 1",lang:"expression"},gap_policy:"skip"}},cumsum:{cumulative_sum:{buckets_path:"count"}},logRate:{derivative:{buckets_path:"cumsum",gap_policy:"skip",unit:"1s"}}};const memory={memory:{avg:{field:"system.memory.actual.used.pct"}}};var network_traffic_with_interfaces=__webpack_require__(151);const rx=Object(network_traffic_with_interfaces["a"])("rx","system.network.in.bytes","system.network.name");const tx=Object(network_traffic_with_interfaces["a"])("tx","system.network.out.bytes","system.network.name");const hostSystemOverview=(timeField,indexPattern,interval)=>({id:"hostSystemOverview",requires:["system.cpu","system.memory","system.load","system.network"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"top_n",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"system.cpu.user.pct",id:"avg-cpu-user",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{field:"system.cpu.system.pct",id:"avg-cpu-system",type:"avg"},{id:"calc-user-system-cores",script:"(params.users + params.system) / params.cores",type:"calculation",variables:[{field:"avg-cpu-user",id:"var-users",name:"users"},{field:"avg-cpu-system",id:"var-system",name:"system"},{field:"max-cpu-cores",id:"var-cores",name:"cores"}]}]},{id:"load",split_mode:"everything",metrics:[{field:"system.load.5",id:"avg-load-5m",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"system.memory.actual.used.pct",id:"avg-memory-actual-used",type:"avg"}]},{id:"rx",split_mode:"terms",terms_field:"system.network.name",metrics:[{field:"system.network.in.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}]},{id:"tx",split_mode:"terms",terms_field:"system.network.name",metrics:[{field:"system.network.out.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}]}]});const hostCpuUsage=(timeField,indexPattern,interval)=>({id:"hostCpuUsage",requires:["system.cpu"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"user",metrics:[{field:"system.cpu.user.pct",id:"avg-cpu-user",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-user",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"system",metrics:[{field:"system.cpu.system.pct",id:"avg-cpu-system",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-system",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"steal",metrics:[{field:"system.cpu.steal.pct",id:"avg-cpu-steal",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"avg-cpu-steal",id:"var-avg",name:"avg"},{field:"max-cpu-cores",id:"var-cores",name:"cores"}]}],split_mode:"everything"},{id:"irq",metrics:[{field:"system.cpu.irq.pct",id:"avg-cpu-irq",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-irq",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"softirq",metrics:[{field:"system.cpu.softirq.pct",id:"avg-cpu-softirq",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-softirq",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"iowait",metrics:[{field:"system.cpu.iowait.pct",id:"avg-cpu-iowait",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-iowait",id:"var-avg",name:"avg"}]}],split_mode:"everything"},{id:"nice",metrics:[{field:"system.cpu.nice.pct",id:"avg-cpu-nice",type:"avg"},{field:"system.cpu.cores",id:"max-cpu-cores",type:"max"},{id:"calc-avg-cores",script:"params.avg / params.cores",type:"calculation",variables:[{field:"max-cpu-cores",id:"var-cores",name:"cores"},{field:"avg-cpu-nice",id:"var-avg",name:"avg"}]}],split_mode:"everything"}]});const hostLoad=(timeField,indexPattern,interval)=>({id:"hostLoad",requires:["system.cpu"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"load_1m",metrics:[{field:"system.load.1",id:"avg-load-1m",type:"avg"}],split_mode:"everything"},{id:"load_5m",metrics:[{field:"system.load.5",id:"avg-load-5m",type:"avg"}],split_mode:"everything"},{id:"load_15m",metrics:[{field:"system.load.15",id:"avg-load-15m",type:"avg"}],split_mode:"everything"}]});const hostMemoryUsage=(timeField,indexPattern,interval)=>({id:"hostMemoryUsage",requires:["system.memory"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"free",metrics:[{field:"system.memory.free",id:"avg-memory-free",type:"avg"}],split_mode:"everything"},{id:"used",metrics:[{field:"system.memory.actual.used.bytes",id:"avg-memory-used",type:"avg"}],split_mode:"everything"},{id:"cache",metrics:[{field:"system.memory.actual.used.bytes",id:"avg-memory-actual-used",type:"avg"},{field:"system.memory.used.bytes",id:"avg-memory-used",type:"avg"},{id:"calc-used-actual",script:"params.used - params.actual",type:"calculation",variables:[{field:"avg-memory-actual-used",id:"var-actual",name:"actual"},{field:"avg-memory-used",id:"var-used",name:"used"}]}],split_mode:"everything"}]});const hostNetworkTraffic=(timeField,indexPattern,interval)=>({id:"hostNetworkTraffic",requires:["system.network"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"tx",metrics:[{field:"system.network.out.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"system.network.name"},{id:"rx",metrics:[{field:"system.network.in.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-net-in",id:"var-rate",name:"rate"}]},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"system.network.name"}]});const hostFilesystem=(timeField,indexPattern,interval)=>({id:"hostFilesystem",requires:["system.filesystem"],filter:"system.filesystem.device_name:\\/*",index_pattern:indexPattern,time_field:timeField,interval:interval,type:"timeseries",series:[{id:"used",metrics:[{field:"system.filesystem.used.pct",id:"avg-filesystem-used",type:"avg"}],split_mode:"terms",terms_field:"system.filesystem.device_name",terms_order_by:"used",terms_size:5}]});const hostK8sOverview=(timeField,indexPattern,interval)=>({id:"hostK8sOverview",requires:["kubernetes"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"top_n",series:[{id:"cpucap",split_mode:"everything",metrics:[{field:"kubernetes.node.cpu.allocatable.cores",id:"max-cpu-cap",type:"max"},{field:"kubernetes.node.cpu.usage.nanocores",id:"avg-cpu-usage",type:"avg"},{id:"calc-used-cap",script:"params.used / (params.cap * 1000000000)",type:"calculation",variables:[{field:"max-cpu-cap",id:"var-cap",name:"cap"},{field:"avg-cpu-usage",id:"var-used",name:"used"}]}]},{id:"diskcap",metrics:[{field:"kubernetes.node.fs.capacity.bytes",id:"max-fs-cap",type:"max"},{field:"kubernetes.node.fs.used.bytes",id:"avg-fs-used",type:"avg"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-fs-cap",id:"var-cap",name:"cap"},{field:"avg-fs-used",id:"var-used",name:"used"}]}],split_mode:"everything"},{id:"memorycap",metrics:[{field:"kubernetes.node.memory.allocatable.bytes",id:"max-memory-cap",type:"max"},{field:"kubernetes.node.memory.usage.bytes",id:"avg-memory-usage",type:"avg"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-memory-cap",id:"var-cap",name:"cap"},{field:"avg-memory-usage",id:"var-used",name:"used"}]}],split_mode:"everything"},{id:"podcap",metrics:[{field:"kubernetes.node.pod.capacity.total",id:"max-pod-cap",type:"max"},{field:"kubernetes.pod.uid",id:"card-pod-name",type:"cardinality"},{id:"calc-used-cap",script:"params.used / params.cap",type:"calculation",variables:[{field:"max-pod-cap",id:"var-cap",name:"cap"},{field:"card-pod-name",id:"var-used",name:"used"}]}],split_mode:"everything"}]});const hostK8sCpuCap=(timeField,indexPattern,interval)=>({id:"hostK8sCpuCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.cpu.allocatable.cores",id:"max-cpu-cap",type:"max"},{id:"calc-nanocores",type:"calculation",variables:[{id:"var-cores",field:"max-cpu-cap",name:"cores"}],script:"params.cores * 1000000000"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.cpu.usage.nanocores",id:"avg-cpu-usage",type:"avg"}],split_mode:"everything"}]});const hostK8sPodCap=(timeField,indexPattern,interval)=>({id:"hostK8sPodCap",requires:["kubernetes.node"],map_field_to:"kubernetes.node.name",index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.pod.allocatable.total",id:"max-pod-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.pod.uid",id:"avg-pod",type:"cardinality"}],split_mode:"everything"}]});const hostK8sDiskCap=(timeField,indexPattern,interval)=>({id:"hostK8sDiskCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.fs.capacity.bytes",id:"max-fs-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.fs.used.bytes",id:"avg-fs-used",type:"avg"}],split_mode:"everything"}]});const hostK8sMemoryCap=(timeField,indexPattern,interval)=>({id:"hostK8sMemoryCap",map_field_to:"kubernetes.node.name",requires:["kubernetes.node"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"capacity",metrics:[{field:"kubernetes.node.memory.allocatable.bytes",id:"max-memory-cap",type:"max"}],split_mode:"everything"},{id:"used",metrics:[{field:"kubernetes.node.memory.usage.bytes",id:"avg-memory-usage",type:"avg"}],split_mode:"everything"}]});const hostDockerTop5ByMemory=(timeField,indexPattern,interval)=>({id:"hostDockerTop5ByMemory",requires:["docker.memory"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"avg-memory",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory-metric",type:"avg"}],split_mode:"terms",terms_field:"container.name",terms_order_by:"avg-memory",terms_size:5}]});const hostDockerTop5ByCpu=(timeField,indexPattern,interval)=>({id:"hostDockerTop5ByCpu",requires:["docker.cpu"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"avg-cpu",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-metric",type:"avg"}],split_mode:"terms",terms_field:"container.name",terms_order_by:"avg-cpu",terms_size:5}]});const hostDockerOverview=(timeField,indexPattern,interval)=>({id:"hostDockerOverview",requires:["docker.info"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"top_n",series:[{id:"total",metrics:[{field:"docker.info.containers.total",id:"max-total",type:"max"}],split_mode:"everything"},{id:"running",metrics:[{field:"docker.info.containers.running",id:"max-running",type:"max"}],split_mode:"everything"},{id:"paused",metrics:[{field:"docker.info.containers.paused",id:"max-paused",type:"max"}],split_mode:"everything"},{id:"stopped",metrics:[{field:"docker.info.containers.stopped",id:"max-stopped",type:"max"}],split_mode:"everything"}]});const hostDockerInfo=(timeField,indexPattern,interval)=>({id:"hostDockerInfo",requires:["docker.info"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"running",metrics:[{field:"docker.info.containers.running",id:"max-running",type:"max"}],split_mode:"everything"},{id:"paused",metrics:[{field:"docker.info.containers.paused",id:"max-paused",type:"max"}],split_mode:"everything"},{id:"stopped",metrics:[{field:"docker.info.containers.stopped",id:"max-stopped",type:"max"}],split_mode:"everything"}]});const metrics={tsvb:{hostSystemOverview:hostSystemOverview,hostCpuUsage:hostCpuUsage,hostLoad:hostLoad,hostMemoryUsage:hostMemoryUsage,hostNetworkTraffic:hostNetworkTraffic,hostFilesystem:hostFilesystem,hostK8sOverview:hostK8sOverview,hostK8sCpuCap:hostK8sCpuCap,hostK8sPodCap:hostK8sPodCap,hostK8sDiskCap:hostK8sDiskCap,hostK8sMemoryCap:hostK8sMemoryCap,hostDockerOverview:hostDockerOverview,hostDockerInfo:hostDockerInfo,hostDockerTop5ByMemory:hostDockerTop5ByMemory,hostDockerTop5ByCpu:hostDockerTop5ByCpu},snapshot:{count:count["a"],cpu:cpu,load:load,logRate:logRate,memory:memory,rx:rx,tx:tx},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},282:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));const cpu={cpu:{avg:{field:"docker.cpu.total.pct"}}};const memory={memory:{avg:{field:"docker.memory.usage.pct"}}};var network_traffic_with_interfaces=__webpack_require__(151);const rx=Object(network_traffic_with_interfaces["a"])("rx","docker.network.inbound.bytes","docker.network.interface");const tx=Object(network_traffic_with_interfaces["a"])("tx","docker.network.outbound.bytes","docker.network.interface");const containerOverview=(timeField,indexPattern,interval)=>({id:"containerOverview",requires:["docker"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-total",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory",type:"avg"}]},{id:"tx",split_mode:"everything",metrics:[{field:"docker.network.out.bytes",id:"avg-network-out",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"docker.network.in.bytes",id:"avg-network-in",type:"avg"}]}]});const containerCpuUsage=(timeField,indexPattern,interval)=>({id:"containerCpuUsage",requires:["docker.cpu"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"docker.cpu.total.pct",id:"avg-cpu-total",type:"avg"}]}]});const containerCpuKernel=(timeField,indexPattern,interval)=>({id:"containerCpuKernel",requires:["docker.cpu"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"kernel",split_mode:"everything",metrics:[{field:"docker.cpu.kernel.pct",id:"avg-cpu-kernel",type:"avg"}]}]});const containerDiskIOOps=(timeField,indexPattern,interval)=>({id:"containerDiskIOOps",requires:["docker.disk"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"read",split_mode:"everything",metrics:[{field:"docker.diskio.read.ops",id:"max-diskio-read-ops",type:"max"},{field:"max-diskio-read-ops",id:"deriv-max-diskio-read-ops",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-read-ops",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-read-ops"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"write",split_mode:"everything",metrics:[{field:"docker.diskio.write.ops",id:"max-diskio-write-ops",type:"max"},{field:"max-diskio-write-ops",id:"deriv-max-diskio-write-ops",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-write-ops",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-write-ops"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-diskio-write-ops",id:"var-rate",name:"rate"}]}]}]});const containerDiskIOBytes=(timeField,indexPattern,interval)=>({id:"containerDiskIOBytes",requires:["docker.disk"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"read",split_mode:"everything",metrics:[{field:"docker.diskio.read.bytes",id:"max-diskio-read-bytes",type:"max"},{field:"max-diskio-read-bytes",id:"deriv-max-diskio-read-bytes",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-read-bytes",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-read-bytes"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"write",split_mode:"everything",metrics:[{field:"docker.diskio.write.bytes",id:"max-diskio-write-bytes",type:"max"},{field:"max-diskio-write-bytes",id:"deriv-max-diskio-write-bytes",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-diskio-write-bytes",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-diskio-write-bytes"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-diskio-write-bytes",id:"var-rate",name:"rate"}]}]}]});const containerMemory=(timeField,indexPattern,interval)=>({id:"containerMemory",requires:["docker.memory"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"docker.memory.usage.pct",id:"avg-memory",type:"avg"}]}]});const containerNetworkTraffic=(timeField,indexPattern,interval)=>({id:"containerNetworkTraffic",requires:["docker.network"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"tx",metrics:[{field:"docker.network.outbound.bytes",id:"max-net-out",type:"max"},{field:"max-net-out",id:"deriv-max-net-out",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-out",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-out"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"docker.network.interface"},{id:"rx",metrics:[{field:"docker.network.inbound.bytes",id:"max-net-in",type:"max"},{field:"max-net-in",id:"deriv-max-net-in",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-in",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-net-in"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"calc-invert-rate",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-net-in",id:"var-rate",name:"rate"}]},{function:"sum",id:"seriesagg-sum",type:"series_agg"}],split_mode:"terms",terms_field:"docker.network.interface"}]});const metrics={tsvb:{containerOverview:containerOverview,containerCpuUsage:containerCpuUsage,containerCpuKernel:containerCpuKernel,containerDiskIOOps:containerDiskIOOps,containerDiskIOBytes:containerDiskIOBytes,containerNetworkTraffic:containerNetworkTraffic,containerMemory:containerMemory},snapshot:{cpu:cpu,memory:memory,rx:rx,tx:tx},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},283:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));const cpu={cpu_with_limit:{avg:{field:"kubernetes.pod.cpu.usage.limit.pct"}},cpu_without_limit:{avg:{field:"kubernetes.pod.cpu.usage.node.pct"}},cpu:{bucket_script:{buckets_path:{with_limit:"cpu_with_limit",without_limit:"cpu_without_limit"},script:{source:"params.with_limit > 0.0 ? params.with_limit : params.without_limit",lang:"painless"},gap_policy:"skip"}}};const memory={memory:{avg:{field:"kubernetes.pod.memory.usage.node.pct"}}};const networkTraffic=(id,field)=>({[`${id}_max`]:{max:{field:field}},[`${id}_deriv`]:{derivative:{buckets_path:`${id}_max`,gap_policy:"skip",unit:"1s"}},[id]:{bucket_script:{buckets_path:{value:`${id}_deriv[normalized_value]`},script:{source:"params.value > 0.0 ? params.value : 0.0",lang:"painless"},gap_policy:"skip"}}});const rx=networkTraffic("rx","kubernetes.pod.network.rx.bytes");const tx=networkTraffic("tx","kubernetes.pod.network.tx.bytes");const podOverview=(timeField,indexPattern,interval)=>({id:"podOverview",requires:["kubernetes.pod"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.pod.cpu.usage.node.pct",id:"avg-cpu-usage",type:"avg"}]},{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.pod.memory.usage.node.pct",id:"avg-memory-usage",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.rx.bytes",id:"max-network-rx",type:"max"},{field:"max-network-rx",id:"deriv-max-network-rx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-network-rx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-rx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"tx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.tx.bytes",id:"max-network-tx",type:"max"},{field:"max-network-tx",id:"deriv-max-network-tx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-network-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]}]});const podCpuUsage=(timeField,indexPattern,interval)=>({id:"podCpuUsage",requires:["kubernetes.pod"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"cpu",split_mode:"everything",metrics:[{field:"kubernetes.pod.cpu.usage.node.pct",id:"avg-cpu-without",type:"avg"},{field:"kubernetes.pod.cpu.usage.limit.pct",id:"avg-cpu-with",type:"avg"},{id:"cpu-usage",type:"calculation",variables:[{id:"cpu_with",name:"with_limit",field:"avg-cpu-with"},{id:"cpu_without",name:"without_limit",field:"avg-cpu-without"}],script:"params.with_limit > 0.0 ? params.with_limit : params.without_limit"}]}]});const podLogUsage=(timeField,indexPattern,interval)=>({id:"podLogUsage",requires:["kubernetes.pod"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"logs",split_mode:"everything",metrics:[{field:"kubernetes.container.logs.used.bytes",id:"avg-log-used",type:"avg"},{field:"kubernetes.container.logs.capacity.bytes",id:"max-log-cap",type:"max"},{id:"calc-usage-limit",script:"params.usage / params.limit",type:"calculation",variables:[{field:"avg-log-userd",id:"var-usage",name:"usage"},{field:"max-log-cap",id:"var-limit",name:"limit"}]}]}]});const podMemoryUsage=(timeField,indexPattern,interval)=>({id:"podMemoryUsage",requires:["kubernetes.pod"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"memory",split_mode:"everything",metrics:[{field:"kubernetes.pod.memory.usage.node.pct",id:"avg-memory-usage",type:"avg"}]}]});const podNetworkTraffic=(timeField,indexPattern,interval)=>({id:"podNetworkTraffic",requires:["kubernetes.pod"],index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:[{id:"tx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.tx.bytes",id:"max-network-tx",type:"max"},{field:"max-network-tx",id:"deriv-max-network-tx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"}]},{id:"rx",split_mode:"everything",metrics:[{field:"kubernetes.pod.network.rx.bytes",id:"max-network-rx",type:"max"},{field:"max-network-rx",id:"deriv-max-network-rx",type:"derivative",unit:"1s"},{id:"posonly-deriv-max-net-tx",type:"calculation",variables:[{id:"var-rate",name:"rate",field:"deriv-max-network-tx"}],script:"params.rate > 0.0 ? params.rate : 0.0"},{id:"invert-posonly-deriv-max-network-rx",script:"params.rate * -1",type:"calculation",variables:[{field:"posonly-deriv-max-network-rx",id:"var-rate",name:"rate"}]}]}]});const metrics={tsvb:{podOverview:podOverview,podCpuUsage:podCpuUsage,podLogUsage:podLogUsage,podNetworkTraffic:podNetworkTraffic,podMemoryUsage:podMemoryUsage},snapshot:{cpu:cpu,memory:memory,rx:rx,tx:tx},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:3600}},284:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));var create_tsvb_model=__webpack_require__(86);const awsS3BucketSize=Object(create_tsvb_model["a"])("awsS3BucketSize",["aws.s3_daily_storage"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_daily_storage.bucket.size.bytes",id:"max-bytes",type:"max"}]}],">=86400s",false);const awsS3TotalRequests=Object(create_tsvb_model["a"])("awsS3TotalRequests",["aws.s3_request"],[{id:"total",split_mode:"everything",metrics:[{field:"aws.s3_request.requests.total",id:"max-size",type:"max"}]}],">=300s");const awsS3NumberOfObjects=Object(create_tsvb_model["a"])("awsS3NumberOfObjects",["aws.s3_daily_storage"],[{id:"objects",split_mode:"everything",metrics:[{field:"aws.s3_daily_storage.number_of_objects",id:"max-size",type:"max"}]}],">=86400s",false);const awsS3DownloadBytes=Object(create_tsvb_model["a"])("awsS3DownloadBytes",["aws.s3_request"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_request.downloaded.bytes",id:"max-bytes",type:"max"}]}],">=300s");const awsS3UploadBytes=Object(create_tsvb_model["a"])("awsS3UploadBytes",["aws.s3_request"],[{id:"bytes",split_mode:"everything",metrics:[{field:"aws.s3_request.uploaded.bytes",id:"max-bytes",type:"max"}]}],">=300s");const s3BucketSize={s3BucketSize:{max:{field:"aws.s3_daily_storage.bucket.size.bytes"}}};const s3TotalRequests={s3TotalRequests:{max:{field:"aws.s3_request.requests.total"}}};const s3NumberOfObjects={s3NumberOfObjects:{max:{field:"aws.s3_daily_storage.number_of_objects"}}};const s3DownloadBytes={s3DownloadBytes:{max:{field:"aws.s3_request.downloaded.bytes"}}};const s3UploadBytes={s3UploadBytes:{max:{field:"aws.s3_request.uploaded.bytes"}}};const metrics={tsvb:{awsS3BucketSize:awsS3BucketSize,awsS3TotalRequests:awsS3TotalRequests,awsS3NumberOfObjects:awsS3NumberOfObjects,awsS3DownloadBytes:awsS3DownloadBytes,awsS3UploadBytes:awsS3UploadBytes},snapshot:{s3BucketSize:s3BucketSize,s3NumberOfObjects:s3NumberOfObjects,s3TotalRequests:s3TotalRequests,s3UploadBytes:s3UploadBytes,s3DownloadBytes:s3DownloadBytes},defaultSnapshot:"s3BucketSize",defaultTimeRangeInSeconds:86400*7}},285:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));const cpu={cpu_avg:{avg:{field:"aws.rds.cpu.total.pct"}},cpu:{bucket_script:{buckets_path:{cpu:"cpu_avg"},script:{source:"params.cpu / 100",lang:"painless"},gap_policy:"skip"}}};const rdsLatency={rdsLatency:{avg:{field:"aws.rds.latency.dml"}}};const rdsConnections={rdsConnections:{avg:{field:"aws.rds.database_connections"}}};const rdsQueriesExecuted={rdsQueriesExecuted:{avg:{field:"aws.rds.queries"}}};const rdsActiveTransactions={rdsActiveTransactions:{avg:{field:"aws.rds.transactions.active"}}};var create_tsvb_model=__webpack_require__(86);const awsRDSLatency=Object(create_tsvb_model["a"])("awsRDSLatency",["aws.rds"],[{id:"read",split_mode:"everything",metrics:[{field:"aws.rds.latency.read",id:"avg",type:"avg"}]},{id:"write",split_mode:"everything",metrics:[{field:"aws.rds.latency.write",id:"avg",type:"avg"}]},{id:"insert",split_mode:"everything",metrics:[{field:"aws.rds.latency.insert",id:"avg",type:"avg"}]},{id:"update",split_mode:"everything",metrics:[{field:"aws.rds.latency.update",id:"avg",type:"avg"}]},{id:"commit",split_mode:"everything",metrics:[{field:"aws.rds.latency.commit",id:"avg",type:"avg"}]}]);const awsRDSConnections=Object(create_tsvb_model["a"])("awsRDSConnections",["aws.rds"],[{id:"connections",split_mode:"everything",metrics:[{field:"aws.rds.database_connections",id:"avg-conns",type:"avg"}]}]);const awsRDSCpuTotal=Object(create_tsvb_model["a"])("awsRDSCpuTotal",["aws.rds"],[{id:"cpu",split_mode:"everything",metrics:[{field:"aws.rds.cpu.total.pct",id:"avg-cpu",type:"avg"},{id:"convert-to-percent",script:"params.avg / 100",type:"calculation",variables:[{field:"avg-cpu",id:"var-avg",name:"avg"}]}]}]);const awsRDSQueriesExecuted=Object(create_tsvb_model["a"])("awsRDSQueriesExecuted",["aws.rds"],[{id:"queries",split_mode:"everything",metrics:[{field:"aws.rds.queries",id:"avg-queries",type:"avg"}]}]);const awsRDSActiveTransactions=Object(create_tsvb_model["a"])("awsRDSActiveTransactions",["aws.rds"],[{id:"active",split_mode:"everything",metrics:[{field:"aws.rds.transactions.active",id:"avg",type:"avg"}]},{id:"blocked",split_mode:"everything",metrics:[{field:"aws.rds.transactions.blocked",id:"avg",type:"avg"}]}]);const metrics={tsvb:{awsRDSLatency:awsRDSLatency,awsRDSConnections:awsRDSConnections,awsRDSCpuTotal:awsRDSCpuTotal,awsRDSQueriesExecuted:awsRDSQueriesExecuted,awsRDSActiveTransactions:awsRDSActiveTransactions},snapshot:{cpu:cpu,rdsLatency:rdsLatency,rdsConnections:rdsConnections,rdsQueriesExecuted:rdsQueriesExecuted,rdsActiveTransactions:rdsActiveTransactions},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:14400}},286:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));const sqsMessagesVisible={sqsMessagesVisible:{avg:{field:"aws.sqs.messages.visible"}}};const sqsMessagesDelayed={sqsMessagesDelayed:{max:{field:"aws.sqs.messages.delayed"}}};const sqsMessagesEmpty={sqsMessagesEmpty:{max:{field:"aws.sqs.messages.not_visible"}}};const sqsMessagesSent={sqsMessagesSent:{max:{field:"aws.sqs.messages.sent"}}};const sqsOldestMessage={sqsOldestMessage:{max:{field:"aws.sqs.oldest_message_age.sec"}}};var create_tsvb_model=__webpack_require__(86);const awsSQSMessagesVisible=Object(create_tsvb_model["a"])("awsSQSMessagesVisible",["aws.sqs"],[{id:"visible",split_mode:"everything",metrics:[{field:"aws.sqs.messages.visible",id:"avg-visible",type:"avg"}]}],">=300s");const awsSQSMessagesDelayed=Object(create_tsvb_model["a"])("awsSQSMessagesDelayed",["aws.sqs"],[{id:"delayed",split_mode:"everything",metrics:[{field:"aws.sqs.messages.delayed",id:"avg-delayed",type:"avg"}]}],">=300s");const awsSQSMessagesSent=Object(create_tsvb_model["a"])("awsSQSMessagesSent",["aws.sqs"],[{id:"sent",split_mode:"everything",metrics:[{field:"aws.sqs.messages.sent",id:"avg-sent",type:"avg"}]}],">=300s");const awsSQSMessagesEmpty=Object(create_tsvb_model["a"])("awsSQSMessagesEmpty",["aws.sqs"],[{id:"empty",split_mode:"everything",metrics:[{field:"aws.sqs.messages.not_visible",id:"avg-empty",type:"avg"}]}],">=300s");const awsSQSOldestMessage=Object(create_tsvb_model["a"])("awsSQSOldestMessage",["aws.sqs"],[{id:"oldest",split_mode:"everything",metrics:[{field:"aws.sqs.oldest_message_age.sec",id:"max-oldest",type:"max"}]}],">=300s");const metrics={tsvb:{awsSQSMessagesVisible:awsSQSMessagesVisible,awsSQSMessagesDelayed:awsSQSMessagesDelayed,awsSQSMessagesSent:awsSQSMessagesSent,awsSQSMessagesEmpty:awsSQSMessagesEmpty,awsSQSOldestMessage:awsSQSOldestMessage},snapshot:{sqsMessagesVisible:sqsMessagesVisible,sqsMessagesDelayed:sqsMessagesDelayed,sqsMessagesEmpty:sqsMessagesEmpty,sqsMessagesSent:sqsMessagesSent,sqsOldestMessage:sqsOldestMessage},defaultSnapshot:"sqsMessagesVisible",defaultTimeRangeInSeconds:14400}},287:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return metrics}));const cpu={cpu_avg:{avg:{field:"aws.ec2.cpu.total.pct"}},cpu:{bucket_script:{buckets_path:{cpu:"cpu_avg"},script:{source:"params.cpu / 100",lang:"painless"},gap_policy:"skip"}}};const rx={rx:{avg:{field:"aws.ec2.network.in.bytes_per_sec"}}};const tx={tx:{avg:{field:"aws.ec2.network.in.bytes_per_sec"}}};const diskIOReadBytes={diskIOReadBytes:{avg:{field:"aws.ec2.diskio.read.bytes_per_sec"}}};const diskIOWriteBytes={diskIOWriteBytes:{avg:{field:"aws.ec2.diskio.write.bytes_per_sec"}}};var create_tsvb_model=__webpack_require__(86);const awsEC2CpuUtilization=Object(create_tsvb_model["a"])("awsEC2CpuUtilization",["aws.ec2"],[{id:"total",split_mode:"everything",metrics:[{field:"aws.ec2.cpu.total.pct",id:"avg-cpu",type:"avg"},{id:"convert-to-percent",script:"params.avg / 100",type:"calculation",variables:[{field:"avg-cpu",id:"var-avg",name:"avg"}]}]}]);const awsEC2NetworkTraffic=Object(create_tsvb_model["a"])("awsEC2NetworkTraffic",["aws.ec2"],[{id:"tx",split_mode:"everything",metrics:[{field:"aws.ec2.network.out.bytes_per_sec",id:"avg-tx",type:"avg"}]},{id:"rx",split_mode:"everything",metrics:[{field:"aws.ec2.network.in.bytes_per_sec",id:"avg-rx",type:"avg"},{id:"calculation-rate",type:"calculation",variables:[{id:"rate-var",name:"rate",field:"avg-rx"}],script:"params.rate * -1"}]}]);const awsEC2DiskIOBytes=Object(create_tsvb_model["a"])("awsEC2DiskIOBytes",["aws.ec2"],[{id:"write",split_mode:"everything",metrics:[{field:"aws.ec2.diskio.write.bytes_per_sec",id:"avg-write",type:"avg"}]},{id:"read",split_mode:"everything",metrics:[{field:"aws.ec2.diskio.read.bytes_per_sec",id:"avg-read",type:"avg"},{id:"calculation-rate",type:"calculation",variables:[{id:"rate-var",name:"rate",field:"avg-read"}],script:"params.rate * -1"}]}]);const metrics={tsvb:{awsEC2CpuUtilization:awsEC2CpuUtilization,awsEC2NetworkTraffic:awsEC2NetworkTraffic,awsEC2DiskIOBytes:awsEC2DiskIOBytes},snapshot:{cpu:cpu,rx:rx,tx:tx,diskIOReadBytes:diskIOReadBytes,diskIOWriteBytes:diskIOWriteBytes},defaultSnapshot:"cpu",defaultTimeRangeInSeconds:14400}},86:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createTSVBModel}));const createTSVBModel=(id,requires,series,interval=">=300s",dropLastBucket=true)=>(timeField,indexPattern)=>({id:id,requires:requires,drop_last_bucket:dropLastBucket,index_pattern:indexPattern,interval:interval,time_field:timeField,type:"timeseries",series:series})},88:function(module,__webpack_exports__,__webpack_require__){"use strict";var _source__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(202);__webpack_require__.d(__webpack_exports__,"a",(function(){return _source__WEBPACK_IMPORTED_MODULE_0__["a"]}));__webpack_require__.d(__webpack_exports__,"b",(function(){return _source__WEBPACK_IMPORTED_MODULE_0__["c"]}))},89:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return ItemTypeRT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return InventoryVisTypeRT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return InventoryMetricRT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return MetricsUIAggregationRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return SnapshotMetricTypeKeys}));__webpack_require__.d(__webpack_exports__,"f",(function(){return SnapshotMetricTypeRT}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);const ItemTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({host:null,pod:null,container:null,awsEC2:null,awsS3:null,awsSQS:null,awsRDS:null});const InventoryVisTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({line:null,area:null,bar:null});const InventoryFormatterTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({abbreviatedNumber:null,bits:null,bytes:null,number:null,percent:null,highPercision:null});const InventoryMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({hostSystemOverview:null,hostCpuUsage:null,hostFilesystem:null,hostK8sOverview:null,hostK8sCpuCap:null,hostK8sDiskCap:null,hostK8sMemoryCap:null,hostK8sPodCap:null,hostLoad:null,hostMemoryUsage:null,hostNetworkTraffic:null,hostDockerOverview:null,hostDockerInfo:null,hostDockerTop5ByCpu:null,hostDockerTop5ByMemory:null,podOverview:null,podCpuUsage:null,podMemoryUsage:null,podLogUsage:null,podNetworkTraffic:null,containerOverview:null,containerCpuKernel:null,containerCpuUsage:null,containerDiskIOOps:null,containerDiskIOBytes:null,containerMemory:null,containerNetworkTraffic:null,nginxHits:null,nginxRequestRate:null,nginxActiveConnections:null,nginxRequestsPerConnection:null,awsOverview:null,awsCpuUtilization:null,awsNetworkBytes:null,awsNetworkPackets:null,awsDiskioBytes:null,awsDiskioOps:null,awsEC2CpuUtilization:null,awsEC2NetworkTraffic:null,awsEC2DiskIOBytes:null,awsS3TotalRequests:null,awsS3NumberOfObjects:null,awsS3BucketSize:null,awsS3DownloadBytes:null,awsS3UploadBytes:null,awsRDSCpuTotal:null,awsRDSConnections:null,awsRDSQueriesExecuted:null,awsRDSActiveTransactions:null,awsRDSLatency:null,awsSQSMessagesVisible:null,awsSQSMessagesDelayed:null,awsSQSMessagesSent:null,awsSQSMessagesEmpty:null,awsSQSOldestMessage:null,custom:null});const TSVBMetricTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({avg:null,max:null,min:null,calculation:null,cardinality:null,series_agg:null,positive_only:null,derivative:null,count:null,sum:null,cumulative_sum:null});const TSVBMetricModelCountRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("count")});const TSVBMetricModelBasicMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:TSVBMetricTypeRT}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);const TSVBMetricModelVariableRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],name:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const TSVBMetricModelBucketScriptRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],script:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("calculation"),variables:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBMetricModelVariableRT)});const TSVBMetricModelDerivativeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],unit:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("derivative")});const TSVBMetricModelSeriesAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],function:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("series_agg")});const TSVBPercentileItemRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],value:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]});const TSVBMetricModePercentileAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("percentile"),percentiles:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBPercentileItemRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);const TSVBMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([TSVBMetricModelCountRT,TSVBMetricModelBasicMetricRT,TSVBMetricModelBucketScriptRT,TSVBMetricModelDerivativeRT,TSVBMetricModePercentileAggRT,TSVBMetricModelSeriesAggRT]);const TSVBSeriesRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBMetricRT),split_mode:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({terms_field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],terms_size:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],terms_order_by:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],filter:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({query:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],language:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({lucene:null,kuery:null})})})]);const TSVBMetricModelRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({id:InventoryMetricRT,requires:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]),index_pattern:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"])]),interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],time_field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],type:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],series:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](TSVBSeriesRT)}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({filter:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],map_field_to:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],id_type:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({cloud:null,node:null}),drop_last_bucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]})]);const ESBasicMetricAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]));const ESPercentileAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({percentiles:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],percents:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["number"])})});const ESCaridnalityAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({cardinality:io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],script:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESBucketScriptAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({bucket_script:io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["undefined"],io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]])),script:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({source:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],lang:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({painless:null,expression:null})})}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({gap_policy:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({skip:null,insert_zeros:null})})])});const ESCumulativeSumAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({cumulative_sum:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESDerivativeAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({derivative:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],gap_policy:io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"]({skip:null,insert_zeros:null}),unit:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESSumBucketAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({sum_bucket:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({buckets_path:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})});const ESTopHitsAggRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({top_hits:io_ts__WEBPACK_IMPORTED_MODULE_0__["object"]});const ESTermsWithAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["recursion"]("SnapshotModelRT",()=>io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({terms:io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),aggregations:MetricsUIAggregationRT}));const ESAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([ESBasicMetricAggRT,ESPercentileAggRT,ESBucketScriptAggRT,ESCumulativeSumAggRT,ESDerivativeAggRT,ESSumBucketAggRT,ESTermsWithAggregationRT,ESCaridnalityAggRT,ESTopHitsAggRT]);const MetricsUIAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["record"](io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],ESAggregationRT);const SnapshotMetricTypeKeys={count:null,cpu:null,load:null,memory:null,tx:null,rx:null,logRate:null,diskIOReadBytes:null,diskIOWriteBytes:null,s3TotalRequests:null,s3NumberOfObjects:null,s3BucketSize:null,s3DownloadBytes:null,s3UploadBytes:null,rdsConnections:null,rdsQueriesExecuted:null,rdsActiveTransactions:null,rdsLatency:null,sqsMessagesVisible:null,sqsMessagesDelayed:null,sqsMessagesSent:null,sqsMessagesEmpty:null,sqsOldestMessage:null,custom:null};const SnapshotMetricTypeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](SnapshotMetricTypeKeys)},92:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"g",(function(){return SnapshotNodeResponseRT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return InfraTimerangeInputRT}));__webpack_require__.d(__webpack_exports__,"e",(function(){return SnapshotGroupByRT}));__webpack_require__.d(__webpack_exports__,"b",(function(){return SNAPSHOT_CUSTOM_AGGREGATIONS}));__webpack_require__.d(__webpack_exports__,"c",(function(){return SnapshotCustomAggregationRT}));__webpack_require__.d(__webpack_exports__,"d",(function(){return SnapshotCustomMetricInputRT}));__webpack_require__.d(__webpack_exports__,"f",(function(){return SnapshotMetricInputRT}));var io_ts__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(0);var io_ts__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(io_ts__WEBPACK_IMPORTED_MODULE_0__);var _inventory_models_types__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(89);var _metrics_api__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(127);const SnapshotNodePathRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({value:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],label:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({ip:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]])})]);const SnapshotNodeMetricOptionalRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({value:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]),avg:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]),max:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]),timeseries:_metrics_api__WEBPACK_IMPORTED_MODULE_2__["a"]});const SnapshotNodeMetricRequiredRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({name:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([_inventory_models_types__WEBPACK_IMPORTED_MODULE_1__["f"],io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]])});const SnapshotNodeMetricRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([SnapshotNodeMetricRequiredRT,SnapshotNodeMetricOptionalRT]);const SnapshotNodeRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](SnapshotNodeMetricRT),path:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](SnapshotNodePathRT),name:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const SnapshotNodeResponseRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({nodes:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](SnapshotNodeRT),interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]});const InfraTimerangeInputRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({interval:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],to:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],from:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({lookbackSize:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"],ignoreLookback:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],forceInterval:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"]})]);const SnapshotGroupByRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({label:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]),field:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]])}));const SnapshotNamedMetricInputRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({type:_inventory_models_types__WEBPACK_IMPORTED_MODULE_1__["f"]});const SNAPSHOT_CUSTOM_AGGREGATIONS=["avg","max","min","rate"];const snapshotCustomAggregationKeys=SNAPSHOT_CUSTOM_AGGREGATIONS.reduce((acc,agg)=>({...acc,[agg]:null}),{});const SnapshotCustomAggregationRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["keyof"](snapshotCustomAggregationKeys);const SnapshotCustomMetricInputRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({type:io_ts__WEBPACK_IMPORTED_MODULE_0__["literal"]("custom"),field:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],aggregation:SnapshotCustomAggregationRT,id:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({label:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]})]);const SnapshotMetricInputRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([SnapshotNamedMetricInputRT,SnapshotCustomMetricInputRT]);const SnapshotRequestRT=io_ts__WEBPACK_IMPORTED_MODULE_0__["intersection"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["type"]({timerange:InfraTimerangeInputRT,metrics:io_ts__WEBPACK_IMPORTED_MODULE_0__["array"](SnapshotMetricInputRT),groupBy:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([SnapshotGroupByRT,io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]),nodeType:_inventory_models_types__WEBPACK_IMPORTED_MODULE_1__["c"],sourceId:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"]}),io_ts__WEBPACK_IMPORTED_MODULE_0__["partial"]({accountId:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],region:io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],filterQuery:io_ts__WEBPACK_IMPORTED_MODULE_0__["union"]([io_ts__WEBPACK_IMPORTED_MODULE_0__["string"],io_ts__WEBPACK_IMPORTED_MODULE_0__["null"]]),includeTimeseries:io_ts__WEBPACK_IMPORTED_MODULE_0__["boolean"],overrideCompositeSize:io_ts__WEBPACK_IMPORTED_MODULE_0__["number"]})])},94:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return inventoryModels}));__webpack_require__.d(__webpack_exports__,"b",(function(){return findInventoryModel}));__webpack_require__.d(__webpack_exports__,"a",(function(){return findInventoryFields}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var metrics=__webpack_require__(281);const nginx=["nginxHits","nginxRequestRate","nginxActiveConnections","nginxRequestsPerConnection"];const aws=["awsOverview","awsCpuUtilization","awsNetworkBytes","awsNetworkPackets","awsDiskioOps","awsDiskioBytes"];const host={id:"host",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModel.host.displayName",{defaultMessage:"Hosts"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.host.singularDisplayName",{defaultMessage:"Host"}),requiredModule:"system",crosslinkSupport:{details:true,logs:true,apm:true,uptime:true},fields:{id:"host.name",name:"host.name",ip:"host.ip"},metrics:metrics["a"],requiredMetrics:["hostSystemOverview","hostCpuUsage","hostLoad","hostMemoryUsage","hostNetworkTraffic","hostK8sOverview","hostK8sCpuCap","hostK8sMemoryCap","hostK8sDiskCap","hostK8sPodCap",...aws,...nginx],tooltipMetrics:["cpu","memory","tx","rx"]};var pod_metrics=__webpack_require__(283);const pod={id:"pod",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModel.pod.displayName",{defaultMessage:"Kubernetes Pods"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.pod.singularDisplayName",{defaultMessage:"Kubernetes Pod"}),requiredModule:"kubernetes",crosslinkSupport:{details:true,logs:true,apm:true,uptime:true},fields:{id:"kubernetes.pod.uid",name:"kubernetes.pod.name",ip:"kubernetes.pod.ip"},metrics:pod_metrics["a"],requiredMetrics:["podOverview","podCpuUsage","podMemoryUsage","podNetworkTraffic",...nginx],tooltipMetrics:["cpu","memory","rx","tx"]};var aws_ec2_metrics=__webpack_require__(287);const awsEC2={id:"awsEC2",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsEC2.displayName",{defaultMessage:"EC2 Instances"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsEC2.singularDisplayName",{defaultMessage:"EC2 Instance"}),requiredModule:"aws",crosslinkSupport:{details:true,logs:true,apm:true,uptime:true},metrics:aws_ec2_metrics["a"],fields:{id:"cloud.instance.id",name:"cloud.instance.name",ip:"aws.ec2.instance.public.ip"},requiredMetrics:["awsEC2CpuUtilization","awsEC2NetworkTraffic","awsEC2DiskIOBytes"],tooltipMetrics:["cpu","rx","tx"],nodeFilter:[{term:{"event.dataset":"aws.ec2"}}]};var aws_s3_metrics=__webpack_require__(284);const awsS3={id:"awsS3",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsS3.displayName",{defaultMessage:"S3 Buckets"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsS3.singularDisplayName",{defaultMessage:"S3 Bucket"}),requiredModule:"aws",crosslinkSupport:{details:true,logs:true,apm:false,uptime:false},metrics:aws_s3_metrics["a"],fields:{id:"aws.s3.bucket.name",name:"aws.s3.bucket.name"},requiredMetrics:["awsS3BucketSize","awsS3NumberOfObjects","awsS3TotalRequests","awsS3DownloadBytes","awsS3UploadBytes"],tooltipMetrics:["s3BucketSize","s3NumberOfObjects","s3TotalRequests","s3UploadBytes","s3DownloadBytes"]};var aws_rds_metrics=__webpack_require__(285);const awsRDS={id:"awsRDS",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsRDS.displayName",{defaultMessage:"RDS Databases"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsRDS.singularDisplayName",{defaultMessage:"RDS Database"}),requiredModule:"aws",crosslinkSupport:{details:true,logs:true,apm:false,uptime:false},metrics:aws_rds_metrics["a"],fields:{id:"aws.rds.db_instance.arn",name:"aws.rds.db_instance.identifier"},requiredMetrics:["awsRDSCpuTotal","awsRDSConnections","awsRDSQueriesExecuted","awsRDSActiveTransactions","awsRDSLatency"],tooltipMetrics:["cpu","rdsLatency","rdsConnections","rdsQueriesExecuted","rdsActiveTransactions"]};var aws_sqs_metrics=__webpack_require__(286);const awsSQS={id:"awsSQS",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsSQS.displayName",{defaultMessage:"SQS Queues"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.awsSQS.singularDisplayName",{defaultMessage:"SQS Queue"}),requiredModule:"aws",crosslinkSupport:{details:true,logs:true,apm:false,uptime:false},metrics:aws_sqs_metrics["a"],fields:{id:"aws.sqs.queue.name",name:"aws.sqs.queue.name"},requiredMetrics:["awsSQSMessagesVisible","awsSQSMessagesDelayed","awsSQSMessagesSent","awsSQSMessagesEmpty","awsSQSOldestMessage"],tooltipMetrics:["sqsMessagesVisible","sqsMessagesDelayed","sqsMessagesEmpty","sqsMessagesSent","sqsOldestMessage"]};var container_metrics=__webpack_require__(282);const container={id:"container",displayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModel.container.displayName",{defaultMessage:"Docker Containers"}),singularDisplayName:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModel.container.singularDisplayName",{defaultMessage:"Docker Container"}),requiredModule:"docker",crosslinkSupport:{details:true,logs:true,apm:true,uptime:true},fields:{id:"container.id",name:"container.name",ip:"container.ip_address"},metrics:container_metrics["a"],requiredMetrics:["containerOverview","containerCpuUsage","containerMemory","containerNetworkTraffic","containerDiskIOBytes","containerDiskIOOps"],tooltipMetrics:["cpu","memory","rx","tx"]};var inventory_models_metrics=__webpack_require__(208);const inventoryModels=[host,pod,container,awsEC2,awsS3,awsRDS,awsSQS];const findInventoryModel=type=>{const model=inventoryModels.find(m=>m.id===type);if(!model){throw new Error(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.inventoryModels.findInventoryModel.error",{defaultMessage:"The inventory model you've attempted to find does not exist"}))}return model};const LEGACY_TYPES=["host","pod","container"];const getFieldByType=(type,fields)=>{switch(type){case"pod":return fields.pod;case"host":return fields.host;case"container":return fields.container}};const findInventoryFields=(type,fields)=>{const inventoryModel=findInventoryModel(type);if(fields&&LEGACY_TYPES.includes(type)){const id=getFieldByType(type,fields)||inventoryModel.fields.id;return{...inventoryModel.fields,id:id}}else{return inventoryModel.fields}}}}]);