/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["infra_bundle_jsonpfunction"]=window["infra_bundle_jsonpfunction"]||[]).push([[13],{212:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return AlertPreview}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(12);var public_=__webpack_require__(3);var formatters=__webpack_require__(32);var get_interval_in_seconds=__webpack_require__(207);var metrics=__webpack_require__(134);async function getAlertPreview({fetch:fetch,params:params,alertType:alertType}){return await fetch(`${metrics["c"]}`,{method:"POST",body:JSON.stringify({...params,alertType:alertType})})}const AlertPreview=props=>{var _previewError$body;const{alertParams:alertParams,alertInterval:alertInterval,alertThrottle:alertThrottle,alertNotifyWhen:alertNotifyWhen,alertType:alertType,validate:validate,showNoDataResults:showNoDataResults,groupByDisplayName:groupByDisplayName}=props;const{http:http}=Object(public_["useKibana"])().services;const[previewLookbackInterval,setPreviewLookbackInterval]=Object(external_kbnSharedDeps_React_["useState"])("h");const[isPreviewLoading,setIsPreviewLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[previewError,setPreviewError]=Object(external_kbnSharedDeps_React_["useState"])(false);const[previewResult,setPreviewResult]=Object(external_kbnSharedDeps_React_["useState"])(null);const onSelectPreviewLookbackInterval=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{setPreviewLookbackInterval(e.target.value)},[]);const onClickPreview=Object(external_kbnSharedDeps_React_["useCallback"])(async()=>{setIsPreviewLoading(true);setPreviewResult(null);setPreviewError(false);try{const result=await getAlertPreview({fetch:http.fetch,params:{...alertParams,lookback:previewLookbackInterval,alertInterval:alertInterval,alertThrottle:alertThrottle,alertNotifyWhen:alertNotifyWhen,alertOnNoData:showNoDataResults!==null&&showNoDataResults!==void 0?showNoDataResults:false},alertType:alertType});setPreviewResult({...result,groupByDisplayName:groupByDisplayName,previewLookbackInterval:previewLookbackInterval,alertThrottle:alertThrottle})}catch(e){setPreviewError(e)}finally{setIsPreviewLoading(false)}},[alertParams,alertInterval,alertType,alertNotifyWhen,groupByDisplayName,previewLookbackInterval,alertThrottle,showNoDataResults,http]);const previewIntervalError=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const intervalInSeconds=Object(get_interval_in_seconds["a"])(alertInterval);const lookbackInSeconds=Object(get_interval_in_seconds["a"])(`1${previewLookbackInterval}`);if(intervalInSeconds>=lookbackInSeconds){return true}return false},[previewLookbackInterval,alertInterval]);const isPreviewDisabled=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!alertParams.criteria)return false;const validationResult=validate({criteria:alertParams.criteria});const hasValidationErrors=Object.values(validationResult.errors).some(result=>Object.values(result).some(arr=>Array.isArray(arr)&&arr.length));return hasValidationErrors||previewIntervalError},[alertParams.criteria,previewIntervalError,validate]);const showNumberOfNotifications=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!previewResult)return false;if(alertNotifyWhen==="onActiveAlert")return false;const{notifications:notifications,fired:fired,noData:noData,error:error}=previewResult.resultTotals;const unthrottledNotifications=fired+(showNoDataResults?noData+error:0);return unthrottledNotifications>notifications},[previewResult,showNoDataResults,alertNotifyWhen]);const hasWarningThreshold=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _alertParams$criteria,_alertParams$criteria2;return(_alertParams$criteria=(_alertParams$criteria2=alertParams.criteria)===null||_alertParams$criteria2===void 0?void 0:_alertParams$criteria2.some(c=>Reflect.has(c,"warningThreshold")))!==null&&_alertParams$criteria!==void 0?_alertParams$criteria:false},[alertParams]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.previewLabel",{defaultMessage:"Preview"}),fullWidth:true,display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{id:"selectPreviewLookbackInterval",value:previewLookbackInterval,onChange:onSelectPreviewLookbackInterval,options:previewDOMOptions})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{isLoading:isPreviewLoading,isDisabled:isPreviewDisabled,onClick:onClickPreview},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.testAlertCondition",{defaultMessage:"Test alert condition"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),previewResult&&!previewIntervalError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(PreviewTextString,{previewResult:previewResult,hasWarningThreshold:hasWarningThreshold})},showNoDataResults&&previewResult.resultTotals.noData?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewNoDataResult",defaultMessage:"There {wereWas} {boldedResultsNumber} of no data.",values:{wereWas:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.wereWas",defaultMessage:"{plurality, plural, one {was} other {were}}",values:{plurality:previewResult.resultTotals.noData}}),boldedResultsNumber:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertPreviewNoDataResultNumber",{defaultMessage:"{noData, plural, one {# result} other {# results}}",values:{noData:previewResult.resultTotals.noData}}))}}):null," ",previewResult.resultTotals.error?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewErrorResult",defaultMessage:"An error occurred when trying to evaluate some of the data."}):null,showNumberOfNotifications?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewTotalNotifications",defaultMessage:'As a result, this alert would have sent {notifications} based on the selected "notify" setting of "{alertThrottle}."',values:{alertThrottle:alertNotifyWhen==="onThrottleInterval"?previewResult.alertThrottle:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertPreviewOnlyOnStatusChange",{defaultMessage:"Only on status change"}),notifications:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertPreviewTotalNotificationsNumber",{defaultMessage:"{notifs, plural, one {# notification} other {# notifications}}",values:{notifs:previewResult.resultTotals.notifications}}))}})):null," ")),previewIntervalError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.previewIntervalTooShortTitle",defaultMessage:"Not enough data"}),color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.previewIntervalTooShortDescription",defaultMessage:"Try selecting a longer preview length, or increase the amount of time in the {checkEvery} field.",values:{checkEvery:external_kbnSharedDeps_React_default.a.createElement("strong",null,"check every")}}))),previewError&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),((_previewError$body=previewError.body)===null||_previewError$body===void 0?void 0:_previewError$body.statusCode)===508?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.tooManyBucketsErrorTitle",defaultMessage:"Too much data (>{maxBuckets} results)",values:{maxBuckets:formatters["a"].number(previewError.body.message)}}),color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.tooManyBucketsErrorDescription",defaultMessage:"Try selecting a shorter preview length, or increase the amount of time in the {forTheLast} field.",values:{forTheLast:external_kbnSharedDeps_React_default.a.createElement("strong",null,"FOR THE LAST")}})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewError",defaultMessage:"An error occurred when trying to preview this alert condition"}),color:"danger",iconType:"alert"},previewError.body&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewErrorDesc",defaultMessage:"Please try again later or see details for more information."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAccordion"],{id:"alertErrorDetailsAccordion",buttonContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.errorDetails",defaultMessage:"Details"})))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],null,previewError.body.message)))))))};const PreviewTextString=({previewResult:previewResult,hasWarningThreshold:hasWarningThreshold})=>{var _previewOptions$find;const instanceCount=hasWarningThreshold?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewResultWithSeverityLevels",defaultMessage:"There {wereWas} {criticalInstances} that satisfied the {boldCritical} conditions, and {warningInstances} that satisfied the {boldWarning} conditions of this alert",values:{wereWas:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.wereWas",defaultMessage:"{plurality, plural, one {was} other {were}}",values:{plurality:previewResult.resultTotals.fired}}),criticalInstances:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.firedTimes",defaultMessage:"{fired, plural, one {# instance} other {# instances}}",values:{fired:previewResult.resultTotals.fired}})),warningInstances:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.firedTimes",defaultMessage:"{fired, plural, one {# instance} other {# instances}}",values:{fired:previewResult.resultTotals.warning}})),boldCritical:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.boldCritical",defaultMessage:"critical"})),boldWarning:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.boldWarning",defaultMessage:"warning"}))}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewResultInstances",defaultMessage:"There {wereWas} {firedTimes} that satisfied the conditions of this alert",values:{wereWas:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.wereWas",defaultMessage:"{plurality, plural, one {was} other {were}}",values:{plurality:previewResult.resultTotals.fired}}),firedTimes:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.firedTimes",defaultMessage:"{fired, plural, one {# instance} other {# instances}}",values:{fired:previewResult.resultTotals.fired}}))}});const groupByText=previewResult.groupByDisplayName?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewGroupBy",defaultMessage:"across {groups}",values:{groups:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewGroups",defaultMessage:"{numberOfGroups, plural, one {# {groupName}} other {# {groupName}s}}",values:{numberOfGroups:previewResult.numberOfGroups,groupName:previewResult.groupByDisplayName}}))}})," "):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null);const lookbackText=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewLookback",defaultMessage:"in the last {lookback}",values:{lookback:(_previewOptions$find=previewOptions.find(e=>e.value===previewResult.previewLookbackInterval))===null||_previewOptions$find===void 0?void 0:_previewOptions$find.shortText}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.alertPreviewResultText",defaultMessage:"{instanceCount} {groupByWithConditionalTrailingSpace}{lookbackText}.",values:{instanceCount:instanceCount,groupByWithConditionalTrailingSpace:groupByText,lookbackText:lookbackText}})};const previewOptions=[{value:"h",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastHourLabel",{defaultMessage:"Last hour"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.hourLabel",{defaultMessage:"hour"})},{value:"d",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastDayLabel",{defaultMessage:"Last day"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.dayLabel",{defaultMessage:"day"})},{value:"w",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastWeekLabel",{defaultMessage:"Last week"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.weekLabel",{defaultMessage:"week"})},{value:"M",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastMonthLabel",{defaultMessage:"Last month"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.monthLabel",{defaultMessage:"month"})}];const previewDOMOptions=previewOptions.map(o=>Object(external_kbnSharedDeps_Lodash_["omit"])(o,"shortText"));const common_previewOptions=[{value:"h",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastHourLabel",{defaultMessage:"Last hour"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.hourLabel",{defaultMessage:"hour"})},{value:"d",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastDayLabel",{defaultMessage:"Last day"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.dayLabel",{defaultMessage:"day"})},{value:"w",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastWeekLabel",{defaultMessage:"Last week"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.weekLabel",{defaultMessage:"week"})},{value:"M",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.lastMonthLabel",{defaultMessage:"Last month"}),shortText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.monthLabel",{defaultMessage:"month"})}]},494:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"defaultExpression",(function(){return defaultExpression}));__webpack_require__.d(__webpack_exports__,"Expressions",(function(){return Expressions}));__webpack_require__.d(__webpack_exports__,"ExpressionRow",(function(){return ExpressionRow}));__webpack_require__.d(__webpack_exports__,"nodeTypes",(function(){return nodeTypes}));var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(12);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var snapshot_metric_i18n=__webpack_require__(170);var common=__webpack_require__(212);var alerting_metrics=__webpack_require__(134);var types=__webpack_require__(16);var common_=__webpack_require__(11);var public_common_=__webpack_require__(76);var kuery_bar=__webpack_require__(169);var use_source_via_http=__webpack_require__(178);var toolbar_items=__webpack_require__(279);var aws_ec2_toolbar_items=__webpack_require__(276);var aws_s3_toolbar_items=__webpack_require__(277);var aws_rds_toolbar_items=__webpack_require__(278);var host_toolbar_items=__webpack_require__(273);var container_toolbar_items=__webpack_require__(274);var pod_toolbar_items=__webpack_require__(275);var inventory_models=__webpack_require__(94);var inventory_models_types=__webpack_require__(89);var get_custom_metric_label=__webpack_require__(140);var snapshot_api=__webpack_require__(92);const AGGREGATION_LABELS={["avg"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.aggregationLables.avg",{defaultMessage:"Average"}),["max"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.aggregationLables.max",{defaultMessage:"Max"}),["min"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.aggregationLables.min",{defaultMessage:"Min"}),["rate"]:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.aggregationLables.rate",{defaultMessage:"Rate"})};const aggregationOptions=snapshot_api["b"].map(k=>({text:AGGREGATION_LABELS[k],value:k}));const MetricExpression=({metric:metric,metrics:metrics,customMetric:customMetric,fields:fields,errors:errors,onChange:onChange,onChangeCustom:onChangeCustom,popupPosition:popupPosition})=>{var _errors$metric;const[popoverOpen,setPopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[customMetricTabOpen,setCustomMetricTabOpen]=Object(external_kbnSharedDeps_React_["useState"])((metric===null||metric===void 0?void 0:metric.value)==="custom");const[selectedOption,setSelectedOption]=Object(external_kbnSharedDeps_React_["useState"])(metric===null||metric===void 0?void 0:metric.value);const[fieldDisplayedCustomLabel,setFieldDisplayedCustomLabel]=Object(external_kbnSharedDeps_React_["useState"])(customMetric===null||customMetric===void 0?void 0:customMetric.label);const firstFieldOption={text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.expression.metric.selectFieldLabel",{defaultMessage:"Select a metric"}),value:""};const fieldOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>fields.filter(f=>f.aggregatable&&f.type==="number"&&!((customMetric===null||customMetric===void 0?void 0:customMetric.field)===f.name)).map(f=>({label:f.name})),[fields,customMetric===null||customMetric===void 0?void 0:customMetric.field]);const expressionDisplayValue=Object(external_kbnSharedDeps_React_["useMemo"])(()=>customMetricTabOpen?(customMetric===null||customMetric===void 0?void 0:customMetric.field)&&Object(get_custom_metric_label["a"])(customMetric):(metric===null||metric===void 0?void 0:metric.text)||firstFieldOption.text,[customMetricTabOpen,metric,customMetric,firstFieldOption]);const onChangeTab=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{if(id==="metric-popover-custom"){setCustomMetricTabOpen(true);onChange("custom")}else{setCustomMetricTabOpen(false);onChange(selectedOption)}},[setCustomMetricTabOpen,onChange,selectedOption]);const onAggregationChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const value=e.target.value;const aggValue=snapshot_api["c"].is(value)?value:"avg";const newCustomMetric={...customMetric,aggregation:aggValue};if(snapshot_api["d"].is(newCustomMetric))onChangeCustom(newCustomMetric)},[customMetric,onChangeCustom]);const onFieldChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedOptions=>{const newCustomMetric={...customMetric,field:selectedOptions[0].label};if(snapshot_api["d"].is(newCustomMetric))onChangeCustom(newCustomMetric)},[customMetric,onChangeCustom]);const debouncedOnChangeCustom=Object(external_kbnSharedDeps_Lodash_["debounce"])(onChangeCustom,500);const onLabelChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{setFieldDisplayedCustomLabel(e.target.value);const newCustomMetric={...customMetric,label:e.target.value};if(snapshot_api["d"].is(newCustomMetric))debouncedOnChangeCustom(newCustomMetric)},[customMetric,debouncedOnChangeCustom]);const availablefieldsOptions=metrics.map(m=>({label:m.text,value:m.value}),[]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"metricPopover",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiExpression"],{description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.expression.metric.whenLabel",{defaultMessage:"When"}),value:expressionDisplayValue,isActive:Boolean(popoverOpen||errors.metric&&errors.metric.length>0),onClick:()=>{setPopoverOpen(true)},color:(_errors$metric=errors.metric)!==null&&_errors$metric!==void 0&&_errors$metric.length?"danger":"secondary"}),isOpen:popoverOpen,closePopover:()=>{setPopoverOpen(false)},anchorPosition:popupPosition!==null&&popupPosition!==void 0?popupPosition:"downRight",zIndex:8e3},external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:620}},external_kbnSharedDeps_React_default.a.createElement(ClosablePopoverTitle,{onClose:()=>setPopoverOpen(false)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.expression.metric.popoverTitle",defaultMessage:"Metric"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{isFullWidth:true,buttonSize:"compressed",legend:"Metric type",options:[{id:"metric-popover-default",label:"Default metric"},{id:"metric-popover-custom",label:"Custom metric"}],idSelected:customMetricTabOpen?"metric-popover-custom":"metric-popover-default",onChange:onChangeTab}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),customMetricTabOpen?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{onChange:onAggregationChange,value:(customMetric===null||customMetric===void 0?void 0:customMetric.aggregation)||"avg",options:aggregationOptions,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.of",{defaultMessage:"of"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{fullWidth:true,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.fieldPlaceholder",{defaultMessage:"Select a field"}),singleSelection:{asPlainText:true},selectedOptions:customMetric!==null&&customMetric!==void 0&&customMetric.field?[{label:customMetric.field}]:[],options:fieldOptions,onChange:onFieldChange,isClearable:false,isInvalid:errors.metric.length>0})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.alerting.customMetrics.labelLabel",{defaultMessage:"Metric name (optional)"}),display:"rowCompressed",fullWidth:true,helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.alerting.customMetrics.helpText",{defaultMessage:'Choose a name to help identify your custom metric. Defaults to "<function> of <field name>".'})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{name:"label",placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.waffle.customMetrics.labelPlaceholder",{defaultMessage:'Choose a name to appear in the "Metric" dropdown'}),value:fieldDisplayedCustomLabel,fullWidth:true,onChange:onLabelChange}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{className:"actOf__metricContainer"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{fullWidth:true,singleSelection:{asPlainText:true},"data-test-subj":"availablefieldsOptionsComboBox",isInvalid:errors.metric.length>0,placeholder:firstFieldOption.text,options:availablefieldsOptions,noSuggestions:!availablefieldsOptions.length,selectedOptions:metric?availablefieldsOptions.filter(a=>a.value===metric.value):[],renderOption:o=>o.label,onChange:selectedOptions=>{if(selectedOptions.length>0){onChange(selectedOptions[0].value);setSelectedOption(selectedOptions[0].value)}else{onChange()}}}))))))};const ClosablePopoverTitle=({children:children,onClose:onClose})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,children),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"cross",color:"danger","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel",{defaultMessage:"Close"}),onClick:()=>onClose()}))));const NodeTypeExpression=({value:value,options:options,onChange:onChange,popupPosition:popupPosition})=>{const[aggTypePopoverOpen,setAggTypePopoverOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiExpression"],{"data-test-subj":"nodeTypeExpression",description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.expression.for.descriptionLabel",{defaultMessage:"For"}),value:options[value].text,isActive:aggTypePopoverOpen,onClick:()=>{setAggTypePopoverOpen(true)}}),isOpen:aggTypePopoverOpen,closePopover:()=>{setAggTypePopoverOpen(false)},ownFocus:true,anchorPosition:popupPosition!==null&&popupPosition!==void 0?popupPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(node_type_ClosablePopoverTitle,{onClose:()=>setAggTypePopoverOpen(false)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.expression.for.popoverTitle",defaultMessage:"Node Type"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{"data-test-subj":"forExpressionSelect",value:value,fullWidth:true,onChange:e=>{onChange(e.target.value);setAggTypePopoverOpen(false)},options:Object.values(options).map(o=>o)})))};const node_type_ClosablePopoverTitle=({children:children,onClose:onClose})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,children),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"cross",color:"danger","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel",{defaultMessage:"Close"}),onClick:()=>onClose()}))));var kuery=__webpack_require__(103);var validation=__webpack_require__(42);var use_kibana=__webpack_require__(28);const FILTER_TYPING_DEBOUNCE_MS=500;const defaultExpression={metric:"cpu",comparator:types["a"].GT,threshold:[],timeSize:1,timeUnit:"m",customMetric:{type:"custom",id:"alert-custom-metric",field:"",aggregation:"avg"}};const Expressions=props=>{const{http:http,notifications:notifications}=Object(use_kibana["b"])().services;const{setAlertParams:setAlertParams,alertParams:alertParams,errors:errors,alertInterval:alertInterval,alertThrottle:alertThrottle,metadata:metadata,alertNotifyWhen:alertNotifyWhen}=props;const{source:source,createDerivedIndexPattern:createDerivedIndexPattern}=Object(use_source_via_http["a"])({sourceId:"default",type:"metrics",fetch:http.fetch,toastWarning:notifications.toasts.addWarning});const[timeSize,setTimeSize]=Object(external_kbnSharedDeps_React_["useState"])(1);const[timeUnit,setTimeUnit]=Object(external_kbnSharedDeps_React_["useState"])("m");const derivedIndexPattern=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createDerivedIndexPattern("metrics"),[createDerivedIndexPattern]);const updateParams=Object(external_kbnSharedDeps_React_["useCallback"])((id,e)=>{const exp=alertParams.criteria?alertParams.criteria.slice():[];exp[id]=e;setAlertParams("criteria",exp)},[setAlertParams,alertParams.criteria]);const addExpression=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{var _alertParams$criteria;const exp=((_alertParams$criteria=alertParams.criteria)===null||_alertParams$criteria===void 0?void 0:_alertParams$criteria.slice())||[];exp.push({...defaultExpression,timeSize:timeSize!==null&&timeSize!==void 0?timeSize:defaultExpression.timeSize,timeUnit:timeUnit!==null&&timeUnit!==void 0?timeUnit:defaultExpression.timeUnit});setAlertParams("criteria",exp)},[setAlertParams,alertParams.criteria,timeSize,timeUnit]);const removeExpression=Object(external_kbnSharedDeps_React_["useCallback"])(id=>{const exp=alertParams.criteria.slice();if(exp.length>1){exp.splice(id,1);setAlertParams("criteria",exp)}},[setAlertParams,alertParams.criteria]);const onFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(filter=>{setAlertParams("filterQueryText",filter||"");setAlertParams("filterQuery",Object(kuery["a"])(filter,derivedIndexPattern)||"")},[derivedIndexPattern,setAlertParams]);const debouncedOnFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(Object(external_kbnSharedDeps_Lodash_["debounce"])(onFilterChange,FILTER_TYPING_DEBOUNCE_MS),[onFilterChange]);const emptyError=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({aggField:[],timeSizeUnit:[],timeWindowSize:[]}),[]);const updateTimeSize=Object(external_kbnSharedDeps_React_["useCallback"])(ts=>{const criteria=alertParams.criteria.map(c=>({...c,timeSize:ts}));setTimeSize(ts||undefined);setAlertParams("criteria",criteria)},[alertParams.criteria,setAlertParams]);const updateTimeUnit=Object(external_kbnSharedDeps_React_["useCallback"])(tu=>{const criteria=alertParams.criteria.map(c=>({...c,timeUnit:tu}));setTimeUnit(tu);setAlertParams("criteria",criteria)},[alertParams.criteria,setAlertParams]);const updateNodeType=Object(external_kbnSharedDeps_React_["useCallback"])(nt=>{setAlertParams("nodeType",nt)},[setAlertParams]);const handleFieldSearchChange=Object(external_kbnSharedDeps_React_["useCallback"])(e=>onFilterChange(e.target.value),[onFilterChange]);const preFillAlertCriteria=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{const md=metadata;if(md&&md.options){setAlertParams("criteria",[{...defaultExpression,metric:md.options.metric.type,customMetric:snapshot_api["d"].is(md.options.metric)?md.options.metric:defaultExpression.customMetric}])}else{setAlertParams("criteria",[defaultExpression])}},[metadata,setAlertParams]);const preFillAlertFilter=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{const md=metadata;if(md&&md.filter){setAlertParams("filterQueryText",md.filter);setAlertParams("filterQuery",Object(kuery["a"])(md.filter,derivedIndexPattern)||"")}},[metadata,derivedIndexPattern,setAlertParams]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const md=metadata;if(!alertParams.nodeType){if(md&&md.nodeType){setAlertParams("nodeType",md.nodeType)}else{setAlertParams("nodeType","host")}}if(alertParams.criteria&&alertParams.criteria.length){setTimeSize(alertParams.criteria[0].timeSize);setTimeUnit(alertParams.criteria[0].timeUnit)}else{preFillAlertCriteria()}if(!alertParams.filterQuery){preFillAlertFilter()}if(!alertParams.sourceId){setAlertParams("sourceId",(source===null||source===void 0?void 0:source.id)||"default")}},[metadata,derivedIndexPattern,defaultExpression,source]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.conditions",defaultMessage:"Conditions"}))),external_kbnSharedDeps_React_default.a.createElement(StyledExpression,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,external_kbnSharedDeps_React_default.a.createElement(NodeTypeExpression,{options:nodeTypes,value:alertParams.nodeType||"host",onChange:updateNodeType}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),alertParams.criteria&&alertParams.criteria.map((e,idx)=>external_kbnSharedDeps_React_default.a.createElement(ExpressionRow,{nodeType:alertParams.nodeType,canDelete:alertParams.criteria.length>1,remove:removeExpression,addExpression:addExpression,key:idx,expressionId:idx,setAlertParams:updateParams,errors:errors[idx]||emptyError,expression:e||{},fields:derivedIndexPattern.fields})),external_kbnSharedDeps_React_default.a.createElement(public_common_["ForLastExpression"],{timeWindowSize:timeSize,timeWindowUnit:timeUnit,errors:emptyError,onChangeWindowSize:updateTimeSize,onChangeWindowUnit:updateTimeUnit}),external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",iconSide:"left",flush:"left",iconType:"plusInCircleFilled",onClick:addExpression},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.addCondition",defaultMessage:"Add condition"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{id:"metrics-alert-no-data-toggle",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.alertOnNoData",{defaultMessage:"Alert me if there's no data"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.noDataHelpText",{defaultMessage:"Enable this to trigger the action if the metric(s) do not report any data over the expected time period, or if the alert fails to query Elasticsearch"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"questionInCircle",color:"subdued"}))),checked:alertParams.alertOnNoData,onChange:e=>setAlertParams("alertOnNoData",e.target.checked)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.filterLabel",{defaultMessage:"Filter (optional)"}),helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.filterHelpText",{defaultMessage:"Use a KQL expression to limit the scope of your alert trigger."}),fullWidth:true,display:"rowCompressed"},metadata&&external_kbnSharedDeps_React_default.a.createElement(kuery_bar["a"],{derivedIndexPattern:derivedIndexPattern,onSubmit:onFilterChange,onChange:debouncedOnFilterChange,value:alertParams.filterQueryText})||external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"],{onChange:handleFieldSearchChange,value:alertParams.filterQueryText,fullWidth:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(common["a"],{alertInterval:alertInterval,alertThrottle:alertThrottle,alertNotifyWhen:alertNotifyWhen,alertType:alerting_metrics["d"],alertParams:Object(external_kbnSharedDeps_Lodash_["pick"])(alertParams,"criteria","nodeType","sourceId","filterQuery"),validate:validation["a"],groupByDisplayName:alertParams.nodeType,showNoDataResults:alertParams.alertOnNoData}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))};var components_expression=__webpack_exports__["default"]=Expressions;const StyledExpressionRow=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"])`
  display: flex;
  flex-wrap: wrap;
  margin: 0 -4px;
`;const StyledExpression=common_["euiStyled"].div`
  padding: 0 4px;
`;const StyledHealth=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiHealth"])`
  margin-left: 4px;
`;const ExpressionRow=props=>{var _ref,_ref2,_ofFields$find;const{setAlertParams:setAlertParams,expression:expression,errors:errors,expressionId:expressionId,remove:remove,canDelete:canDelete,fields:fields}=props;const{metric:metric,comparator:comparator=types["a"].GT,threshold:threshold=[],customMetric:customMetric,warningThreshold:warningThreshold=[],warningComparator:warningComparator}=expression;const[displayWarningThreshold,setDisplayWarningThreshold]=Object(external_kbnSharedDeps_React_["useState"])(Boolean(warningThreshold===null||warningThreshold===void 0?void 0:warningThreshold.length));const updateMetric=Object(external_kbnSharedDeps_React_["useCallback"])(m=>{const newMetric=inventory_models_types["f"].is(m)?m:Boolean(m)?"custom":undefined;const newAlertParams={...expression,metric:newMetric};setAlertParams(expressionId,newAlertParams)},[expressionId,expression,setAlertParams]);const updateCustomMetric=Object(external_kbnSharedDeps_React_["useCallback"])(cm=>{if(snapshot_api["d"].is(cm)){setAlertParams(expressionId,{...expression,customMetric:cm})}},[expressionId,expression,setAlertParams]);const updateComparator=Object(external_kbnSharedDeps_React_["useCallback"])(c=>{setAlertParams(expressionId,{...expression,comparator:c})},[expressionId,expression,setAlertParams]);const updateWarningComparator=Object(external_kbnSharedDeps_React_["useCallback"])(c=>{setAlertParams(expressionId,{...expression,warningComparator:c})},[expressionId,expression,setAlertParams]);const updateThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(t=>{if(t.join()!==expression.threshold.join()){setAlertParams(expressionId,{...expression,threshold:t})}},[expressionId,expression,setAlertParams]);const updateWarningThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(t=>{var _expression$warningTh;if(t.join()!==((_expression$warningTh=expression.warningThreshold)===null||_expression$warningTh===void 0?void 0:_expression$warningTh.join())){setAlertParams(expressionId,{...expression,warningThreshold:t})}},[expressionId,expression,setAlertParams]);const toggleWarningThreshold=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(!displayWarningThreshold){setDisplayWarningThreshold(true);setAlertParams(expressionId,{...expression,warningComparator:comparator,warningThreshold:[]})}else{setDisplayWarningThreshold(false);setAlertParams(expressionId,Object(external_kbnSharedDeps_Lodash_["omit"])(expression,"warningComparator","warningThreshold"))}},[displayWarningThreshold,setDisplayWarningThreshold,setAlertParams,comparator,expression,expressionId]);const criticalThresholdExpression=external_kbnSharedDeps_React_default.a.createElement(ThresholdElement,{comparator:comparator,threshold:threshold,updateComparator:updateComparator,updateThreshold:updateThreshold,errors:(_ref=errors.critical)!==null&&_ref!==void 0?_ref:{},metric:metric});const warningThresholdExpression=displayWarningThreshold&&external_kbnSharedDeps_React_default.a.createElement(ThresholdElement,{comparator:warningComparator||comparator,threshold:warningThreshold,updateComparator:updateWarningComparator,updateThreshold:updateWarningThreshold,errors:(_ref2=errors.warning)!==null&&_ref2!==void 0?_ref2:{},metric:metric});const ofFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{let myMetrics=host_toolbar_items["b"];switch(props.nodeType){case"awsEC2":myMetrics=aws_ec2_toolbar_items["b"];break;case"awsRDS":myMetrics=aws_rds_toolbar_items["b"];break;case"awsS3":myMetrics=aws_s3_toolbar_items["b"];break;case"awsSQS":myMetrics=toolbar_items["b"];break;case"host":myMetrics=host_toolbar_items["b"];break;case"pod":myMetrics=pod_toolbar_items["b"];break;case"container":myMetrics=container_toolbar_items["b"];break}return myMetrics.map(snapshot_metric_i18n["a"])},[props.nodeType]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpression,null,external_kbnSharedDeps_React_default.a.createElement(MetricExpression,{metric:{value:metric,text:((_ofFields$find=ofFields.find(v=>(v===null||v===void 0?void 0:v.value)===metric))===null||_ofFields$find===void 0?void 0:_ofFields$find.text)||""},metrics:ofFields.filter(m=>m!==undefined&&m.value!==undefined),onChange:updateMetric,onChangeCustom:updateCustomMetric,errors:errors,customMetric:customMetric,fields:fields})),!displayWarningThreshold&&criticalThresholdExpression),displayWarningThreshold&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,criticalThresholdExpression,external_kbnSharedDeps_React_default.a.createElement(StyledHealth,{color:"danger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.criticalThreshold",defaultMessage:"Alert"}))),external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,warningThresholdExpression,external_kbnSharedDeps_React_default.a.createElement(StyledHealth,{color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.warningThreshold",defaultMessage:"Warning"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.removeWarningThreshold",{defaultMessage:"Remove warningThreshold"}),iconSize:"s",color:"subdued",iconType:"crossInACircleFilled",onClick:toggleWarningThreshold}))),!displayWarningThreshold&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(StyledExpressionRow,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",flush:"left",size:"xs",iconType:"plusInCircleFilled",onClick:toggleWarningThreshold},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.metrics.alertFlyout.addWarningThreshold",defaultMessage:"Add warning threshold"}))))),canDelete&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.metrics.alertFlyout.removeCondition",{defaultMessage:"Remove condition"}),color:"danger",iconType:"trash",onClick:()=>remove(expressionId)}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}))};const ThresholdElement=({updateComparator:updateComparator,updateThreshold:updateThreshold,threshold:threshold,metric:metric,comparator:comparator,errors:errors})=>{var _metricUnit$metric;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StyledExpression,null,external_kbnSharedDeps_React_default.a.createElement(public_common_["ThresholdExpression"],{thresholdComparator:comparator||types["a"].GT,threshold:threshold,onChangeSelectedThresholdComparator:updateComparator,onChangeSelectedThreshold:updateThreshold,errors:errors})),metric&&external_kbnSharedDeps_React_default.a.createElement("div",{style:{alignSelf:"center"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},((_metricUnit$metric=metricUnit[metric])===null||_metricUnit$metric===void 0?void 0:_metricUnit$metric.label)||"")))};const getDisplayNameForType=type=>{const inventoryModel=Object(inventory_models["b"])(type);return inventoryModel.displayName};const nodeTypes={host:{text:getDisplayNameForType("host"),value:"host"},pod:{text:getDisplayNameForType("pod"),value:"pod"},container:{text:getDisplayNameForType("container"),value:"container"},awsEC2:{text:getDisplayNameForType("awsEC2"),value:"awsEC2"},awsS3:{text:getDisplayNameForType("awsS3"),value:"awsS3"},awsRDS:{text:getDisplayNameForType("awsRDS"),value:"awsRDS"},awsSQS:{text:getDisplayNameForType("awsSQS"),value:"awsSQS"}};const metricUnit={count:{label:""},cpu:{label:"%"},memory:{label:"%"},rx:{label:"bits/s"},tx:{label:"bits/s"},logRate:{label:"/s"},diskIOReadBytes:{label:"bytes/s"},diskIOWriteBytes:{label:"bytes/s"},s3BucketSize:{label:"bytes"},s3TotalRequests:{label:""},s3NumberOfObjects:{label:""},s3UploadBytes:{label:"bytes"},s3DownloadBytes:{label:"bytes"},sqsOldestMessage:{label:"seconds"},rdsLatency:{label:"ms"},custom:{label:""}}}}]);