/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["infra_bundle_jsonpfunction"]=window["infra_bundle_jsonpfunction"]||[]).push([[10],{163:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(136),__webpack_require__(391),__webpack_require__(392),__webpack_require__(393),__webpack_require__(263),__webpack_require__(394),__webpack_require__(262)):undefined})(this,(function(exports,d3Array,d3Collection,d3Interpolate,d3Format,d3Time,d3TimeFormat,d3Color){"use strict";var array=Array.prototype;var map$1=array.map;var slice=array.slice;var implicit={name:"implicit"};function ordinal(range$$1){var index=d3Collection.map(),domain=[],unknown=implicit;range$$1=range$$1==null?[]:slice.call(range$$1);function scale(d){var key=d+"",i=index.get(key);if(!i){if(unknown!==implicit)return unknown;index.set(key,i=domain.push(d))}return range$$1[(i-1)%range$$1.length]}scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[],index=d3Collection.map();var i=-1,n=_.length,d,key;while(++i<n)if(!index.has(key=(d=_[i])+""))index.set(key,domain.push(d));return scale};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),scale):range$$1.slice()};scale.unknown=function(_){return arguments.length?(unknown=_,scale):unknown};scale.copy=function(){return ordinal().domain(domain).range(range$$1).unknown(unknown)};return scale}function band(){var scale=ordinal().unknown(undefined),domain=scale.domain,ordinalRange=scale.range,range$$1=[0,1],step,bandwidth,round=false,paddingInner=0,paddingOuter=0,align=.5;delete scale.unknown;function rescale(){var n=domain().length,reverse=range$$1[1]<range$$1[0],start=range$$1[reverse-0],stop=range$$1[1-reverse];step=(stop-start)/Math.max(1,n-paddingInner+paddingOuter*2);if(round)step=Math.floor(step);start+=(stop-start-step*(n-paddingInner))*align;bandwidth=step*(1-paddingInner);if(round)start=Math.round(start),bandwidth=Math.round(bandwidth);var values=d3Array.range(n).map((function(i){return start+step*i}));return ordinalRange(reverse?values.reverse():values)}scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()};scale.range=function(_){return arguments.length?(range$$1=[+_[0],+_[1]],rescale()):range$$1.slice()};scale.rangeRound=function(_){return range$$1=[+_[0],+_[1]],round=true,rescale()};scale.bandwidth=function(){return bandwidth};scale.step=function(){return step};scale.round=function(_){return arguments.length?(round=!!_,rescale()):round};scale.padding=function(_){return arguments.length?(paddingInner=paddingOuter=Math.max(0,Math.min(1,_)),rescale()):paddingInner};scale.paddingInner=function(_){return arguments.length?(paddingInner=Math.max(0,Math.min(1,_)),rescale()):paddingInner};scale.paddingOuter=function(_){return arguments.length?(paddingOuter=Math.max(0,Math.min(1,_)),rescale()):paddingOuter};scale.align=function(_){return arguments.length?(align=Math.max(0,Math.min(1,_)),rescale()):align};scale.copy=function(){return band().domain(domain()).range(range$$1).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align)};return rescale()}function pointish(scale){var copy=scale.copy;scale.padding=scale.paddingOuter;delete scale.paddingInner;delete scale.paddingOuter;scale.copy=function(){return pointish(copy())};return scale}function point(){return pointish(band().paddingInner(1))}var constant=function(x){return function(){return x}};var number=function(x){return+x};var unit=[0,1];function deinterpolateLinear(a,b){return(b-=a=+a)?function(x){return(x-a)/b}:constant(b)}function deinterpolateClamp(deinterpolate){return function(a,b){var d=deinterpolate(a=+a,b=+b);return function(x){return x<=a?0:x>=b?1:d(x)}}}function reinterpolateClamp(reinterpolate){return function(a,b){var r=reinterpolate(a=+a,b=+b);return function(t){return t<=0?a:t>=1?b:r(t)}}}function bimap(domain,range$$1,deinterpolate,reinterpolate){var d0=domain[0],d1=domain[1],r0=range$$1[0],r1=range$$1[1];if(d1<d0)d0=deinterpolate(d1,d0),r0=reinterpolate(r1,r0);else d0=deinterpolate(d0,d1),r0=reinterpolate(r0,r1);return function(x){return r0(d0(x))}}function polymap(domain,range$$1,deinterpolate,reinterpolate){var j=Math.min(domain.length,range$$1.length)-1,d=new Array(j),r=new Array(j),i=-1;if(domain[j]<domain[0]){domain=domain.slice().reverse();range$$1=range$$1.slice().reverse()}while(++i<j){d[i]=deinterpolate(domain[i],domain[i+1]);r[i]=reinterpolate(range$$1[i],range$$1[i+1])}return function(x){var i=d3Array.bisect(domain,x,1,j)-1;return r[i](d[i](x))}}function copy(source,target){return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp())}function continuous(deinterpolate,reinterpolate){var domain=unit,range$$1=unit,interpolate$$1=d3Interpolate.interpolate,clamp=false,piecewise,output,input;function rescale(){piecewise=Math.min(domain.length,range$$1.length)>2?polymap:bimap;output=input=null;return scale}function scale(x){return(output||(output=piecewise(domain,range$$1,clamp?deinterpolateClamp(deinterpolate):deinterpolate,interpolate$$1)))(+x)}scale.invert=function(y){return(input||(input=piecewise(range$$1,domain,deinterpolateLinear,clamp?reinterpolateClamp(reinterpolate):reinterpolate)))(+y)};scale.domain=function(_){return arguments.length?(domain=map$1.call(_,number),rescale()):domain.slice()};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),rescale()):range$$1.slice()};scale.rangeRound=function(_){return range$$1=slice.call(_),interpolate$$1=d3Interpolate.interpolateRound,rescale()};scale.clamp=function(_){return arguments.length?(clamp=!!_,rescale()):clamp};scale.interpolate=function(_){return arguments.length?(interpolate$$1=_,rescale()):interpolate$$1};return rescale()}var tickFormat=function(domain,count,specifier){var start=domain[0],stop=domain[domain.length-1],step=d3Array.tickStep(start,stop,count==null?10:count),precision;specifier=d3Format.formatSpecifier(specifier==null?",f":specifier);switch(specifier.type){case"s":{var value=Math.max(Math.abs(start),Math.abs(stop));if(specifier.precision==null&&!isNaN(precision=d3Format.precisionPrefix(step,value)))specifier.precision=precision;return d3Format.formatPrefix(specifier,value)}case"":case"e":case"g":case"p":case"r":{if(specifier.precision==null&&!isNaN(precision=d3Format.precisionRound(step,Math.max(Math.abs(start),Math.abs(stop)))))specifier.precision=precision-(specifier.type==="e");break}case"f":case"%":{if(specifier.precision==null&&!isNaN(precision=d3Format.precisionFixed(step)))specifier.precision=precision-(specifier.type==="%")*2;break}}return d3Format.format(specifier)};function linearish(scale){var domain=scale.domain;scale.ticks=function(count){var d=domain();return d3Array.ticks(d[0],d[d.length-1],count==null?10:count)};scale.tickFormat=function(count,specifier){return tickFormat(domain(),count,specifier)};scale.nice=function(count){if(count==null)count=10;var d=domain(),i0=0,i1=d.length-1,start=d[i0],stop=d[i1],step;if(stop<start){step=start,start=stop,stop=step;step=i0,i0=i1,i1=step}step=d3Array.tickIncrement(start,stop,count);if(step>0){start=Math.floor(start/step)*step;stop=Math.ceil(stop/step)*step;step=d3Array.tickIncrement(start,stop,count)}else if(step<0){start=Math.ceil(start*step)/step;stop=Math.floor(stop*step)/step;step=d3Array.tickIncrement(start,stop,count)}if(step>0){d[i0]=Math.floor(start/step)*step;d[i1]=Math.ceil(stop/step)*step;domain(d)}else if(step<0){d[i0]=Math.ceil(start*step)/step;d[i1]=Math.floor(stop*step)/step;domain(d)}return scale};return scale}function linear(){var scale=continuous(deinterpolateLinear,d3Interpolate.interpolateNumber);scale.copy=function(){return copy(scale,linear())};return linearish(scale)}function identity(){var domain=[0,1];function scale(x){return+x}scale.invert=scale;scale.domain=scale.range=function(_){return arguments.length?(domain=map$1.call(_,number),scale):domain.slice()};scale.copy=function(){return identity().domain(domain)};return linearish(scale)}var nice=function(domain,interval){domain=domain.slice();var i0=0,i1=domain.length-1,x0=domain[i0],x1=domain[i1],t;if(x1<x0){t=i0,i0=i1,i1=t;t=x0,x0=x1,x1=t}domain[i0]=interval.floor(x0);domain[i1]=interval.ceil(x1);return domain};function deinterpolate(a,b){return(b=Math.log(b/a))?function(x){return Math.log(x/a)/b}:constant(b)}function reinterpolate(a,b){return a<0?function(t){return-Math.pow(-b,t)*Math.pow(-a,1-t)}:function(t){return Math.pow(b,t)*Math.pow(a,1-t)}}function pow10(x){return isFinite(x)?+("1e"+x):x<0?0:x}function powp(base){return base===10?pow10:base===Math.E?Math.exp:function(x){return Math.pow(base,x)}}function logp(base){return base===Math.E?Math.log:base===10&&Math.log10||base===2&&Math.log2||(base=Math.log(base),function(x){return Math.log(x)/base})}function reflect(f){return function(x){return-f(-x)}}function log(){var scale=continuous(deinterpolate,reinterpolate).domain([1,10]),domain=scale.domain,base=10,logs=logp(10),pows=powp(10);function rescale(){logs=logp(base),pows=powp(base);if(domain()[0]<0)logs=reflect(logs),pows=reflect(pows);return scale}scale.base=function(_){return arguments.length?(base=+_,rescale()):base};scale.domain=function(_){return arguments.length?(domain(_),rescale()):domain()};scale.ticks=function(count){var d=domain(),u=d[0],v=d[d.length-1],r;if(r=v<u)i=u,u=v,v=i;var i=logs(u),j=logs(v),p,k,t,n=count==null?10:+count,z=[];if(!(base%1)&&j-i<n){i=Math.round(i)-1,j=Math.round(j)+1;if(u>0)for(;i<j;++i){for(k=1,p=pows(i);k<base;++k){t=p*k;if(t<u)continue;if(t>v)break;z.push(t)}}else for(;i<j;++i){for(k=base-1,p=pows(i);k>=1;--k){t=p*k;if(t<u)continue;if(t>v)break;z.push(t)}}}else{z=d3Array.ticks(i,j,Math.min(j-i,n)).map(pows)}return r?z.reverse():z};scale.tickFormat=function(count,specifier){if(specifier==null)specifier=base===10?".0e":",";if(typeof specifier!=="function")specifier=d3Format.format(specifier);if(count===Infinity)return specifier;if(count==null)count=10;var k=Math.max(1,base*count/scale.ticks().length);return function(d){var i=d/pows(Math.round(logs(d)));if(i*base<base-.5)i*=base;return i<=k?specifier(d):""}};scale.nice=function(){return domain(nice(domain(),{floor:function(x){return pows(Math.floor(logs(x)))},ceil:function(x){return pows(Math.ceil(logs(x)))}}))};scale.copy=function(){return copy(scale,log().base(base))};return scale}function raise(x,exponent){return x<0?-Math.pow(-x,exponent):Math.pow(x,exponent)}function pow(){var exponent=1,scale=continuous(deinterpolate,reinterpolate),domain=scale.domain;function deinterpolate(a,b){return(b=raise(b,exponent)-(a=raise(a,exponent)))?function(x){return(raise(x,exponent)-a)/b}:constant(b)}function reinterpolate(a,b){b=raise(b,exponent)-(a=raise(a,exponent));return function(t){return raise(a+b*t,1/exponent)}}scale.exponent=function(_){return arguments.length?(exponent=+_,domain(domain())):exponent};scale.copy=function(){return copy(scale,pow().exponent(exponent))};return linearish(scale)}function sqrt(){return pow().exponent(.5)}function quantile$1(){var domain=[],range$$1=[],thresholds=[];function rescale(){var i=0,n=Math.max(1,range$$1.length);thresholds=new Array(n-1);while(++i<n)thresholds[i-1]=d3Array.quantile(domain,i/n);return scale}function scale(x){if(!isNaN(x=+x))return range$$1[d3Array.bisect(thresholds,x)]}scale.invertExtent=function(y){var i=range$$1.indexOf(y);return i<0?[NaN,NaN]:[i>0?thresholds[i-1]:domain[0],i<thresholds.length?thresholds[i]:domain[domain.length-1]]};scale.domain=function(_){if(!arguments.length)return domain.slice();domain=[];for(var i=0,n=_.length,d;i<n;++i)if(d=_[i],d!=null&&!isNaN(d=+d))domain.push(d);domain.sort(d3Array.ascending);return rescale()};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),rescale()):range$$1.slice()};scale.quantiles=function(){return thresholds.slice()};scale.copy=function(){return quantile$1().domain(domain).range(range$$1)};return scale}function quantize(){var x0=0,x1=1,n=1,domain=[.5],range$$1=[0,1];function scale(x){if(x<=x)return range$$1[d3Array.bisect(domain,x,0,n)]}function rescale(){var i=-1;domain=new Array(n);while(++i<n)domain[i]=((i+1)*x1-(i-n)*x0)/(n+1);return scale}scale.domain=function(_){return arguments.length?(x0=+_[0],x1=+_[1],rescale()):[x0,x1]};scale.range=function(_){return arguments.length?(n=(range$$1=slice.call(_)).length-1,rescale()):range$$1.slice()};scale.invertExtent=function(y){var i=range$$1.indexOf(y);return i<0?[NaN,NaN]:i<1?[x0,domain[0]]:i>=n?[domain[n-1],x1]:[domain[i-1],domain[i]]};scale.copy=function(){return quantize().domain([x0,x1]).range(range$$1)};return linearish(scale)}function threshold(){var domain=[.5],range$$1=[0,1],n=1;function scale(x){if(x<=x)return range$$1[d3Array.bisect(domain,x,0,n)]}scale.domain=function(_){return arguments.length?(domain=slice.call(_),n=Math.min(domain.length,range$$1.length-1),scale):domain.slice()};scale.range=function(_){return arguments.length?(range$$1=slice.call(_),n=Math.min(domain.length,range$$1.length-1),scale):range$$1.slice()};scale.invertExtent=function(y){var i=range$$1.indexOf(y);return[domain[i-1],domain[i]]};scale.copy=function(){return threshold().domain(domain).range(range$$1)};return scale}var durationSecond=1e3;var durationMinute=durationSecond*60;var durationHour=durationMinute*60;var durationDay=durationHour*24;var durationWeek=durationDay*7;var durationMonth=durationDay*30;var durationYear=durationDay*365;function date(t){return new Date(t)}function number$1(t){return t instanceof Date?+t:+new Date(+t)}function calendar(year,month,week,day,hour,minute,second,millisecond,format$$1){var scale=continuous(deinterpolateLinear,d3Interpolate.interpolateNumber),invert=scale.invert,domain=scale.domain;var formatMillisecond=format$$1(".%L"),formatSecond=format$$1(":%S"),formatMinute=format$$1("%I:%M"),formatHour=format$$1("%I %p"),formatDay=format$$1("%a %d"),formatWeek=format$$1("%b %d"),formatMonth=format$$1("%B"),formatYear=format$$1("%Y");var tickIntervals=[[second,1,durationSecond],[second,5,5*durationSecond],[second,15,15*durationSecond],[second,30,30*durationSecond],[minute,1,durationMinute],[minute,5,5*durationMinute],[minute,15,15*durationMinute],[minute,30,30*durationMinute],[hour,1,durationHour],[hour,3,3*durationHour],[hour,6,6*durationHour],[hour,12,12*durationHour],[day,1,durationDay],[day,2,2*durationDay],[week,1,durationWeek],[month,1,durationMonth],[month,3,3*durationMonth],[year,1,durationYear]];function tickFormat(date){return(second(date)<date?formatMillisecond:minute(date)<date?formatSecond:hour(date)<date?formatMinute:day(date)<date?formatHour:month(date)<date?week(date)<date?formatDay:formatWeek:year(date)<date?formatMonth:formatYear)(date)}function tickInterval(interval,start,stop,step){if(interval==null)interval=10;if(typeof interval==="number"){var target=Math.abs(stop-start)/interval,i=d3Array.bisector((function(i){return i[2]})).right(tickIntervals,target);if(i===tickIntervals.length){step=d3Array.tickStep(start/durationYear,stop/durationYear,interval);interval=year}else if(i){i=tickIntervals[target/tickIntervals[i-1][2]<tickIntervals[i][2]/target?i-1:i];step=i[1];interval=i[0]}else{step=Math.max(d3Array.tickStep(start,stop,interval),1);interval=millisecond}}return step==null?interval:interval.every(step)}scale.invert=function(y){return new Date(invert(y))};scale.domain=function(_){return arguments.length?domain(map$1.call(_,number$1)):domain().map(date)};scale.ticks=function(interval,step){var d=domain(),t0=d[0],t1=d[d.length-1],r=t1<t0,t;if(r)t=t0,t0=t1,t1=t;t=tickInterval(interval,t0,t1,step);t=t?t.range(t0,t1+1):[];return r?t.reverse():t};scale.tickFormat=function(count,specifier){return specifier==null?tickFormat:format$$1(specifier)};scale.nice=function(interval,step){var d=domain();return(interval=tickInterval(interval,d[0],d[d.length-1],step))?domain(nice(d,interval)):scale};scale.copy=function(){return copy(scale,calendar(year,month,week,day,hour,minute,second,millisecond,format$$1))};return scale}var time=function(){return calendar(d3Time.timeYear,d3Time.timeMonth,d3Time.timeWeek,d3Time.timeDay,d3Time.timeHour,d3Time.timeMinute,d3Time.timeSecond,d3Time.timeMillisecond,d3TimeFormat.timeFormat).domain([new Date(2e3,0,1),new Date(2e3,0,2)])};var utcTime=function(){return calendar(d3Time.utcYear,d3Time.utcMonth,d3Time.utcWeek,d3Time.utcDay,d3Time.utcHour,d3Time.utcMinute,d3Time.utcSecond,d3Time.utcMillisecond,d3TimeFormat.utcFormat).domain([Date.UTC(2e3,0,1),Date.UTC(2e3,0,2)])};var colors=function(s){return s.match(/.{6}/g).map((function(x){return"#"+x}))};var category10=colors("1f77b4ff7f0e2ca02cd627289467bd8c564be377c27f7f7fbcbd2217becf");var category20b=colors("393b795254a36b6ecf9c9ede6379398ca252b5cf6bcedb9c8c6d31bd9e39e7ba52e7cb94843c39ad494ad6616be7969c7b4173a55194ce6dbdde9ed6");var category20c=colors("3182bd6baed69ecae1c6dbefe6550dfd8d3cfdae6bfdd0a231a35474c476a1d99bc7e9c0756bb19e9ac8bcbddcdadaeb636363969696bdbdbdd9d9d9");var category20=colors("1f77b4aec7e8ff7f0effbb782ca02c98df8ad62728ff98969467bdc5b0d58c564bc49c94e377c2f7b6d27f7f7fc7c7c7bcbd22dbdb8d17becf9edae5");var cubehelix$1=d3Interpolate.interpolateCubehelixLong(d3Color.cubehelix(300,.5,0),d3Color.cubehelix(-240,.5,1));var warm=d3Interpolate.interpolateCubehelixLong(d3Color.cubehelix(-100,.75,.35),d3Color.cubehelix(80,1.5,.8));var cool=d3Interpolate.interpolateCubehelixLong(d3Color.cubehelix(260,.75,.35),d3Color.cubehelix(80,1.5,.8));var rainbow=d3Color.cubehelix();var rainbow$1=function(t){if(t<0||t>1)t-=Math.floor(t);var ts=Math.abs(t-.5);rainbow.h=360*t-100;rainbow.s=1.5-1.5*ts;rainbow.l=.8-.9*ts;return rainbow+""};function ramp(range$$1){var n=range$$1.length;return function(t){return range$$1[Math.max(0,Math.min(n-1,Math.floor(t*n)))]}}var viridis=ramp(colors("44015444025645045745055946075a46085c460a5d460b5e470d60470e6147106347116447136548146748166848176948186a481a6c481b6d481c6e481d6f481f70482071482173482374482475482576482677482878482979472a7a472c7a472d7b472e7c472f7d46307e46327e46337f463480453581453781453882443983443a83443b84433d84433e85423f854240864241864142874144874045884046883f47883f48893e49893e4a893e4c8a3d4d8a3d4e8a3c4f8a3c508b3b518b3b528b3a538b3a548c39558c39568c38588c38598c375a8c375b8d365c8d365d8d355e8d355f8d34608d34618d33628d33638d32648e32658e31668e31678e31688e30698e306a8e2f6b8e2f6c8e2e6d8e2e6e8e2e6f8e2d708e2d718e2c718e2c728e2c738e2b748e2b758e2a768e2a778e2a788e29798e297a8e297b8e287c8e287d8e277e8e277f8e27808e26818e26828e26828e25838e25848e25858e24868e24878e23888e23898e238a8d228b8d228c8d228d8d218e8d218f8d21908d21918c20928c20928c20938c1f948c1f958b1f968b1f978b1f988b1f998a1f9a8a1e9b8a1e9c891e9d891f9e891f9f881fa0881fa1881fa1871fa28720a38620a48621a58521a68522a78522a88423a98324aa8325ab8225ac8226ad8127ad8128ae8029af7f2ab07f2cb17e2db27d2eb37c2fb47c31b57b32b67a34b67935b77937b87838b9773aba763bbb753dbc743fbc7340bd7242be7144bf7046c06f48c16e4ac16d4cc26c4ec36b50c46a52c56954c56856c66758c7655ac8645cc8635ec96260ca6063cb5f65cb5e67cc5c69cd5b6ccd5a6ece5870cf5773d05675d05477d1537ad1517cd2507fd34e81d34d84d44b86d54989d5488bd6468ed64590d74393d74195d84098d83e9bd93c9dd93ba0da39a2da37a5db36a8db34aadc32addc30b0dd2fb2dd2db5de2bb8de29bade28bddf26c0df25c2df23c5e021c8e020cae11fcde11dd0e11cd2e21bd5e21ad8e219dae319dde318dfe318e2e418e5e419e7e419eae51aece51befe51cf1e51df4e61ef6e620f8e621fbe723fde725"));var magma=ramp(colors("00000401000501010601010802010902020b02020d03030f03031204041405041606051806051a07061c08071e0907200a08220b09240c09260d0a290e0b2b100b2d110c2f120d31130d34140e36150e38160f3b180f3d19103f1a10421c10441d11471e114920114b21114e22115024125325125527125829115a2a115c2c115f2d11612f116331116533106734106936106b38106c390f6e3b0f703d0f713f0f72400f74420f75440f764510774710784910784a10794c117a4e117b4f127b51127c52137c54137d56147d57157e59157e5a167e5c167f5d177f5f187f601880621980641a80651a80671b80681c816a1c816b1d816d1d816e1e81701f81721f817320817521817621817822817922827b23827c23827e24828025828125818326818426818627818827818928818b29818c29818e2a81902a81912b81932b80942c80962c80982d80992d809b2e7f9c2e7f9e2f7fa02f7fa1307ea3307ea5317ea6317da8327daa337dab337cad347cae347bb0357bb2357bb3367ab5367ab73779b83779ba3878bc3978bd3977bf3a77c03a76c23b75c43c75c53c74c73d73c83e73ca3e72cc3f71cd4071cf4070d0416fd2426fd3436ed5446dd6456cd8456cd9466bdb476adc4869de4968df4a68e04c67e24d66e34e65e44f64e55064e75263e85362e95462ea5661eb5760ec5860ed5a5fee5b5eef5d5ef05f5ef1605df2625df2645cf3655cf4675cf4695cf56b5cf66c5cf66e5cf7705cf7725cf8745cf8765cf9785df9795df97b5dfa7d5efa7f5efa815ffb835ffb8560fb8761fc8961fc8a62fc8c63fc8e64fc9065fd9266fd9467fd9668fd9869fd9a6afd9b6bfe9d6cfe9f6dfea16efea36ffea571fea772fea973feaa74feac76feae77feb078feb27afeb47bfeb67cfeb77efeb97ffebb81febd82febf84fec185fec287fec488fec68afec88cfeca8dfecc8ffecd90fecf92fed194fed395fed597fed799fed89afdda9cfddc9efddea0fde0a1fde2a3fde3a5fde5a7fde7a9fde9aafdebacfcecaefceeb0fcf0b2fcf2b4fcf4b6fcf6b8fcf7b9fcf9bbfcfbbdfcfdbf"));var inferno=ramp(colors("00000401000501010601010802010a02020c02020e03021004031204031405041706041907051b08051d09061f0a07220b07240c08260d08290e092b10092d110a30120a32140b34150b37160b39180c3c190c3e1b0c411c0c431e0c451f0c48210c4a230c4c240c4f260c51280b53290b552b0b572d0b592f0a5b310a5c320a5e340a5f3609613809623909633b09643d09653e0966400a67420a68440a68450a69470b6a490b6a4a0c6b4c0c6b4d0d6c4f0d6c510e6c520e6d540f6d550f6d57106e59106e5a116e5c126e5d126e5f136e61136e62146e64156e65156e67166e69166e6a176e6c186e6d186e6f196e71196e721a6e741a6e751b6e771c6d781c6d7a1d6d7c1d6d7d1e6d7f1e6c801f6c82206c84206b85216b87216b88226a8a226a8c23698d23698f24699025689225689326679526679727669827669a28659b29649d29649f2a63a02a63a22b62a32c61a52c60a62d60a82e5fa92e5eab2f5ead305dae305cb0315bb1325ab3325ab43359b63458b73557b93556ba3655bc3754bd3853bf3952c03a51c13a50c33b4fc43c4ec63d4dc73e4cc83f4bca404acb4149cc4248ce4347cf4446d04545d24644d34743d44842d54a41d74b3fd84c3ed94d3dda4e3cdb503bdd513ade5238df5337e05536e15635e25734e35933e45a31e55c30e65d2fe75e2ee8602de9612bea632aeb6429eb6628ec6726ed6925ee6a24ef6c23ef6e21f06f20f1711ff1731df2741cf3761bf37819f47918f57b17f57d15f67e14f68013f78212f78410f8850ff8870ef8890cf98b0bf98c0af98e09fa9008fa9207fa9407fb9606fb9706fb9906fb9b06fb9d07fc9f07fca108fca309fca50afca60cfca80dfcaa0ffcac11fcae12fcb014fcb216fcb418fbb61afbb81dfbba1ffbbc21fbbe23fac026fac228fac42afac62df9c72ff9c932f9cb35f8cd37f8cf3af7d13df7d340f6d543f6d746f5d949f5db4cf4dd4ff4df53f4e156f3e35af3e55df2e661f2e865f2ea69f1ec6df1ed71f1ef75f1f179f2f27df2f482f3f586f3f68af4f88ef5f992f6fa96f8fb9af9fc9dfafda1fcffa4"));var plasma=ramp(colors("0d088710078813078916078a19068c1b068d1d068e20068f2206902406912605912805922a05932c05942e05952f059631059733059735049837049938049a3a049a3c049b3e049c3f049c41049d43039e44039e46039f48039f4903a04b03a14c02a14e02a25002a25102a35302a35502a45601a45801a45901a55b01a55c01a65e01a66001a66100a76300a76400a76600a76700a86900a86a00a86c00a86e00a86f00a87100a87201a87401a87501a87701a87801a87a02a87b02a87d03a87e03a88004a88104a78305a78405a78606a68707a68808a68a09a58b0aa58d0ba58e0ca48f0da4910ea3920fa39410a29511a19613a19814a099159f9a169f9c179e9d189d9e199da01a9ca11b9ba21d9aa31e9aa51f99a62098a72197a82296aa2395ab2494ac2694ad2793ae2892b02991b12a90b22b8fb32c8eb42e8db52f8cb6308bb7318ab83289ba3388bb3488bc3587bd3786be3885bf3984c03a83c13b82c23c81c33d80c43e7fc5407ec6417dc7427cc8437bc9447aca457acb4679cc4778cc4977cd4a76ce4b75cf4c74d04d73d14e72d24f71d35171d45270d5536fd5546ed6556dd7566cd8576bd9586ada5a6ada5b69db5c68dc5d67dd5e66de5f65de6164df6263e06363e16462e26561e26660e3685fe4695ee56a5de56b5de66c5ce76e5be76f5ae87059e97158e97257ea7457eb7556eb7655ec7754ed7953ed7a52ee7b51ef7c51ef7e50f07f4ff0804ef1814df1834cf2844bf3854bf3874af48849f48948f58b47f58c46f68d45f68f44f79044f79143f79342f89441f89540f9973ff9983ef99a3efa9b3dfa9c3cfa9e3bfb9f3afba139fba238fca338fca537fca636fca835fca934fdab33fdac33fdae32fdaf31fdb130fdb22ffdb42ffdb52efeb72dfeb82cfeba2cfebb2bfebd2afebe2afec029fdc229fdc328fdc527fdc627fdc827fdca26fdcb26fccd25fcce25fcd025fcd225fbd324fbd524fbd724fad824fada24f9dc24f9dd25f8df25f8e125f7e225f7e425f6e626f6e826f5e926f5eb27f4ed27f3ee27f3f027f2f227f1f426f1f525f0f724f0f921"));function sequential(interpolator){var x0=0,x1=1,clamp=false;function scale(x){var t=(x-x0)/(x1-x0);return interpolator(clamp?Math.max(0,Math.min(1,t)):t)}scale.domain=function(_){return arguments.length?(x0=+_[0],x1=+_[1],scale):[x0,x1]};scale.clamp=function(_){return arguments.length?(clamp=!!_,scale):clamp};scale.interpolator=function(_){return arguments.length?(interpolator=_,scale):interpolator};scale.copy=function(){return sequential(interpolator).domain([x0,x1]).clamp(clamp)};return linearish(scale)}exports.scaleBand=band;exports.scalePoint=point;exports.scaleIdentity=identity;exports.scaleLinear=linear;exports.scaleLog=log;exports.scaleOrdinal=ordinal;exports.scaleImplicit=implicit;exports.scalePow=pow;exports.scaleSqrt=sqrt;exports.scaleQuantile=quantile$1;exports.scaleQuantize=quantize;exports.scaleThreshold=threshold;exports.scaleTime=time;exports.scaleUtc=utcTime;exports.schemeCategory10=category10;exports.schemeCategory20b=category20b;exports.schemeCategory20c=category20c;exports.schemeCategory20=category20;exports.interpolateCubehelixDefault=cubehelix$1;exports.interpolateRainbow=rainbow$1;exports.interpolateWarm=warm;exports.interpolateCool=cool;exports.interpolateViridis=viridis;exports.interpolateMagma=magma;exports.interpolateInferno=inferno;exports.interpolatePlasma=plasma;exports.scaleSequential=sequential;Object.defineProperty(exports,"__esModule",{value:true})}))},260:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(70);var react_1=__webpack_require__(1);var useSet=function(initialSet){if(initialSet===void 0){initialSet=new Set}var _a=react_1.useState(initialSet),set=_a[0],setSet=_a[1];var stableActions=react_1.useMemo((function(){var add=function(item){return setSet((function(prevSet){return new Set(tslib_1.__spreadArrays(Array.from(prevSet),[item]))}))};var remove=function(item){return setSet((function(prevSet){return new Set(Array.from(prevSet).filter((function(i){return i!==item})))}))};var toggle=function(item){return setSet((function(prevSet){return prevSet.has(item)?new Set(Array.from(prevSet).filter((function(i){return i!==item}))):new Set(tslib_1.__spreadArrays(Array.from(prevSet),[item]))}))};return{add:add,remove:remove,toggle:toggle,reset:function(){return setSet(initialSet)}}}),[setSet]);var utils=tslib_1.__assign({has:react_1.useCallback((function(item){return set.has(item)}),[set])},stableActions);return[set,utils]};exports.default=useSet},262:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function define(constructor,factory,prototype){constructor.prototype=factory.prototype=prototype;prototype.constructor=constructor}function extend(parent,definition){var prototype=Object.create(parent.prototype);for(var key in definition)prototype[key]=definition[key];return prototype}function Color(){}var darker=.7;var brighter=1/darker;var reI="\\s*([+-]?\\d+)\\s*",reN="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",reP="\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",reHex=/^#([0-9a-f]{3,8})$/,reRgbInteger=new RegExp("^rgb\\("+[reI,reI,reI]+"\\)$"),reRgbPercent=new RegExp("^rgb\\("+[reP,reP,reP]+"\\)$"),reRgbaInteger=new RegExp("^rgba\\("+[reI,reI,reI,reN]+"\\)$"),reRgbaPercent=new RegExp("^rgba\\("+[reP,reP,reP,reN]+"\\)$"),reHslPercent=new RegExp("^hsl\\("+[reN,reP,reP]+"\\)$"),reHslaPercent=new RegExp("^hsla\\("+[reN,reP,reP,reN]+"\\)$");var named={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074};define(Color,color,{copy:function(channels){return Object.assign(new this.constructor,this,channels)},displayable:function(){return this.rgb().displayable()},hex:color_formatHex,formatHex:color_formatHex,formatHsl:color_formatHsl,formatRgb:color_formatRgb,toString:color_formatRgb});function color_formatHex(){return this.rgb().formatHex()}function color_formatHsl(){return hslConvert(this).formatHsl()}function color_formatRgb(){return this.rgb().formatRgb()}function color(format){var m,l;format=(format+"").trim().toLowerCase();return(m=reHex.exec(format))?(l=m[1].length,m=parseInt(m[1],16),l===6?rgbn(m):l===3?new Rgb(m>>8&15|m>>4&240,m>>4&15|m&240,(m&15)<<4|m&15,1):l===8?rgba(m>>24&255,m>>16&255,m>>8&255,(m&255)/255):l===4?rgba(m>>12&15|m>>8&240,m>>8&15|m>>4&240,m>>4&15|m&240,((m&15)<<4|m&15)/255):null):(m=reRgbInteger.exec(format))?new Rgb(m[1],m[2],m[3],1):(m=reRgbPercent.exec(format))?new Rgb(m[1]*255/100,m[2]*255/100,m[3]*255/100,1):(m=reRgbaInteger.exec(format))?rgba(m[1],m[2],m[3],m[4]):(m=reRgbaPercent.exec(format))?rgba(m[1]*255/100,m[2]*255/100,m[3]*255/100,m[4]):(m=reHslPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,1):(m=reHslaPercent.exec(format))?hsla(m[1],m[2]/100,m[3]/100,m[4]):named.hasOwnProperty(format)?rgbn(named[format]):format==="transparent"?new Rgb(NaN,NaN,NaN,0):null}function rgbn(n){return new Rgb(n>>16&255,n>>8&255,n&255,1)}function rgba(r,g,b,a){if(a<=0)r=g=b=NaN;return new Rgb(r,g,b,a)}function rgbConvert(o){if(!(o instanceof Color))o=color(o);if(!o)return new Rgb;o=o.rgb();return new Rgb(o.r,o.g,o.b,o.opacity)}function rgb(r,g,b,opacity){return arguments.length===1?rgbConvert(r):new Rgb(r,g,b,opacity==null?1:opacity)}function Rgb(r,g,b,opacity){this.r=+r;this.g=+g;this.b=+b;this.opacity=+opacity}define(Rgb,rgb,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Rgb(this.r*k,this.g*k,this.b*k,this.opacity)},rgb:function(){return this},displayable:function(){return-.5<=this.r&&this.r<255.5&&(-.5<=this.g&&this.g<255.5)&&(-.5<=this.b&&this.b<255.5)&&(0<=this.opacity&&this.opacity<=1)},hex:rgb_formatHex,formatHex:rgb_formatHex,formatRgb:rgb_formatRgb,toString:rgb_formatRgb}));function rgb_formatHex(){return"#"+hex(this.r)+hex(this.g)+hex(this.b)}function rgb_formatRgb(){var a=this.opacity;a=isNaN(a)?1:Math.max(0,Math.min(1,a));return(a===1?"rgb(":"rgba(")+Math.max(0,Math.min(255,Math.round(this.r)||0))+", "+Math.max(0,Math.min(255,Math.round(this.g)||0))+", "+Math.max(0,Math.min(255,Math.round(this.b)||0))+(a===1?")":", "+a+")")}function hex(value){value=Math.max(0,Math.min(255,Math.round(value)||0));return(value<16?"0":"")+value.toString(16)}function hsla(h,s,l,a){if(a<=0)h=s=l=NaN;else if(l<=0||l>=1)h=s=NaN;else if(s<=0)h=NaN;return new Hsl(h,s,l,a)}function hslConvert(o){if(o instanceof Hsl)return new Hsl(o.h,o.s,o.l,o.opacity);if(!(o instanceof Color))o=color(o);if(!o)return new Hsl;if(o instanceof Hsl)return o;o=o.rgb();var r=o.r/255,g=o.g/255,b=o.b/255,min=Math.min(r,g,b),max=Math.max(r,g,b),h=NaN,s=max-min,l=(max+min)/2;if(s){if(r===max)h=(g-b)/s+(g<b)*6;else if(g===max)h=(b-r)/s+2;else h=(r-g)/s+4;s/=l<.5?max+min:2-max-min;h*=60}else{s=l>0&&l<1?0:h}return new Hsl(h,s,l,o.opacity)}function hsl(h,s,l,opacity){return arguments.length===1?hslConvert(h):new Hsl(h,s,l,opacity==null?1:opacity)}function Hsl(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Hsl,hsl,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Hsl(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=this.h%360+(this.h<0)*360,s=isNaN(h)||isNaN(this.s)?0:this.s,l=this.l,m2=l+(l<.5?l:1-l)*s,m1=2*l-m2;return new Rgb(hsl2rgb(h>=240?h-240:h+120,m1,m2),hsl2rgb(h,m1,m2),hsl2rgb(h<120?h+240:h-120,m1,m2),this.opacity)},displayable:function(){return(0<=this.s&&this.s<=1||isNaN(this.s))&&(0<=this.l&&this.l<=1)&&(0<=this.opacity&&this.opacity<=1)},formatHsl:function(){var a=this.opacity;a=isNaN(a)?1:Math.max(0,Math.min(1,a));return(a===1?"hsl(":"hsla(")+(this.h||0)+", "+(this.s||0)*100+"%, "+(this.l||0)*100+"%"+(a===1?")":", "+a+")")}}));function hsl2rgb(h,m1,m2){return(h<60?m1+(m2-m1)*h/60:h<180?m2:h<240?m1+(m2-m1)*(240-h)/60:m1)*255}var deg2rad=Math.PI/180;var rad2deg=180/Math.PI;var K=18,Xn=.96422,Yn=1,Zn=.82521,t0=4/29,t1=6/29,t2=3*t1*t1,t3=t1*t1*t1;function labConvert(o){if(o instanceof Lab)return new Lab(o.l,o.a,o.b,o.opacity);if(o instanceof Hcl)return hcl2lab(o);if(!(o instanceof Rgb))o=rgbConvert(o);var r=rgb2lrgb(o.r),g=rgb2lrgb(o.g),b=rgb2lrgb(o.b),y=xyz2lab((.2225045*r+.7168786*g+.0606169*b)/Yn),x,z;if(r===g&&g===b)x=z=y;else{x=xyz2lab((.4360747*r+.3850649*g+.1430804*b)/Xn);z=xyz2lab((.0139322*r+.0971045*g+.7141733*b)/Zn)}return new Lab(116*y-16,500*(x-y),200*(y-z),o.opacity)}function gray(l,opacity){return new Lab(l,0,0,opacity==null?1:opacity)}function lab(l,a,b,opacity){return arguments.length===1?labConvert(l):new Lab(l,a,b,opacity==null?1:opacity)}function Lab(l,a,b,opacity){this.l=+l;this.a=+a;this.b=+b;this.opacity=+opacity}define(Lab,lab,extend(Color,{brighter:function(k){return new Lab(this.l+K*(k==null?1:k),this.a,this.b,this.opacity)},darker:function(k){return new Lab(this.l-K*(k==null?1:k),this.a,this.b,this.opacity)},rgb:function(){var y=(this.l+16)/116,x=isNaN(this.a)?y:y+this.a/500,z=isNaN(this.b)?y:y-this.b/200;x=Xn*lab2xyz(x);y=Yn*lab2xyz(y);z=Zn*lab2xyz(z);return new Rgb(lrgb2rgb(3.1338561*x-1.6168667*y-.4906146*z),lrgb2rgb(-.9787684*x+1.9161415*y+.033454*z),lrgb2rgb(.0719453*x-.2289914*y+1.4052427*z),this.opacity)}}));function xyz2lab(t){return t>t3?Math.pow(t,1/3):t/t2+t0}function lab2xyz(t){return t>t1?t*t*t:t2*(t-t0)}function lrgb2rgb(x){return 255*(x<=.0031308?12.92*x:1.055*Math.pow(x,1/2.4)-.055)}function rgb2lrgb(x){return(x/=255)<=.04045?x/12.92:Math.pow((x+.055)/1.055,2.4)}function hclConvert(o){if(o instanceof Hcl)return new Hcl(o.h,o.c,o.l,o.opacity);if(!(o instanceof Lab))o=labConvert(o);if(o.a===0&&o.b===0)return new Hcl(NaN,0<o.l&&o.l<100?0:NaN,o.l,o.opacity);var h=Math.atan2(o.b,o.a)*rad2deg;return new Hcl(h<0?h+360:h,Math.sqrt(o.a*o.a+o.b*o.b),o.l,o.opacity)}function lch(l,c,h,opacity){return arguments.length===1?hclConvert(l):new Hcl(h,c,l,opacity==null?1:opacity)}function hcl(h,c,l,opacity){return arguments.length===1?hclConvert(h):new Hcl(h,c,l,opacity==null?1:opacity)}function Hcl(h,c,l,opacity){this.h=+h;this.c=+c;this.l=+l;this.opacity=+opacity}function hcl2lab(o){if(isNaN(o.h))return new Lab(o.l,0,0,o.opacity);var h=o.h*deg2rad;return new Lab(o.l,Math.cos(h)*o.c,Math.sin(h)*o.c,o.opacity)}define(Hcl,hcl,extend(Color,{brighter:function(k){return new Hcl(this.h,this.c,this.l+K*(k==null?1:k),this.opacity)},darker:function(k){return new Hcl(this.h,this.c,this.l-K*(k==null?1:k),this.opacity)},rgb:function(){return hcl2lab(this).rgb()}}));var A=-.14861,B=+1.78277,C=-.29227,D=-.90649,E=+1.97294,ED=E*D,EB=E*B,BC_DA=B*C-D*A;function cubehelixConvert(o){if(o instanceof Cubehelix)return new Cubehelix(o.h,o.s,o.l,o.opacity);if(!(o instanceof Rgb))o=rgbConvert(o);var r=o.r/255,g=o.g/255,b=o.b/255,l=(BC_DA*b+ED*r-EB*g)/(BC_DA+ED-EB),bl=b-l,k=(E*(g-l)-C*bl)/D,s=Math.sqrt(k*k+bl*bl)/(E*l*(1-l)),h=s?Math.atan2(k,bl)*rad2deg-120:NaN;return new Cubehelix(h<0?h+360:h,s,l,o.opacity)}function cubehelix(h,s,l,opacity){return arguments.length===1?cubehelixConvert(h):new Cubehelix(h,s,l,opacity==null?1:opacity)}function Cubehelix(h,s,l,opacity){this.h=+h;this.s=+s;this.l=+l;this.opacity=+opacity}define(Cubehelix,cubehelix,extend(Color,{brighter:function(k){k=k==null?brighter:Math.pow(brighter,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},darker:function(k){k=k==null?darker:Math.pow(darker,k);return new Cubehelix(this.h,this.s,this.l*k,this.opacity)},rgb:function(){var h=isNaN(this.h)?0:(this.h+120)*deg2rad,l=+this.l,a=isNaN(this.s)?0:this.s*l*(1-l),cosh=Math.cos(h),sinh=Math.sin(h);return new Rgb(255*(l+a*(A*cosh+B*sinh)),255*(l+a*(C*cosh+D*sinh)),255*(l+a*(E*cosh)),this.opacity)}}));exports.color=color;exports.cubehelix=cubehelix;exports.gray=gray;exports.hcl=hcl;exports.hsl=hsl;exports.lab=lab;exports.lch=lch;exports.rgb=rgb;Object.defineProperty(exports,"__esModule",{value:true})}))},263:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var t0=new Date,t1=new Date;function newInterval(floori,offseti,count,field){function interval(date){return floori(date=arguments.length===0?new Date:new Date(+date)),date}interval.floor=function(date){return floori(date=new Date(+date)),date};interval.ceil=function(date){return floori(date=new Date(date-1)),offseti(date,1),floori(date),date};interval.round=function(date){var d0=interval(date),d1=interval.ceil(date);return date-d0<d1-date?d0:d1};interval.offset=function(date,step){return offseti(date=new Date(+date),step==null?1:Math.floor(step)),date};interval.range=function(start,stop,step){var range=[],previous;start=interval.ceil(start);step=step==null?1:Math.floor(step);if(!(start<stop)||!(step>0))return range;do{range.push(previous=new Date(+start)),offseti(start,step),floori(start)}while(previous<start&&start<stop);return range};interval.filter=function(test){return newInterval((function(date){if(date>=date)while(floori(date),!test(date))date.setTime(date-1)}),(function(date,step){if(date>=date){if(step<0)while(++step<=0){while(offseti(date,-1),!test(date)){}}else while(--step>=0){while(offseti(date,+1),!test(date)){}}}}))};if(count){interval.count=function(start,end){t0.setTime(+start),t1.setTime(+end);floori(t0),floori(t1);return Math.floor(count(t0,t1))};interval.every=function(step){step=Math.floor(step);return!isFinite(step)||!(step>0)?null:!(step>1)?interval:interval.filter(field?function(d){return field(d)%step===0}:function(d){return interval.count(0,d)%step===0})}}return interval}var millisecond=newInterval((function(){}),(function(date,step){date.setTime(+date+step)}),(function(start,end){return end-start}));millisecond.every=function(k){k=Math.floor(k);if(!isFinite(k)||!(k>0))return null;if(!(k>1))return millisecond;return newInterval((function(date){date.setTime(Math.floor(date/k)*k)}),(function(date,step){date.setTime(+date+step*k)}),(function(start,end){return(end-start)/k}))};var milliseconds=millisecond.range;var durationSecond=1e3;var durationMinute=6e4;var durationHour=36e5;var durationDay=864e5;var durationWeek=6048e5;var second=newInterval((function(date){date.setTime(date-date.getMilliseconds())}),(function(date,step){date.setTime(+date+step*durationSecond)}),(function(start,end){return(end-start)/durationSecond}),(function(date){return date.getUTCSeconds()}));var seconds=second.range;var minute=newInterval((function(date){date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond)}),(function(date,step){date.setTime(+date+step*durationMinute)}),(function(start,end){return(end-start)/durationMinute}),(function(date){return date.getMinutes()}));var minutes=minute.range;var hour=newInterval((function(date){date.setTime(date-date.getMilliseconds()-date.getSeconds()*durationSecond-date.getMinutes()*durationMinute)}),(function(date,step){date.setTime(+date+step*durationHour)}),(function(start,end){return(end-start)/durationHour}),(function(date){return date.getHours()}));var hours=hour.range;var day=newInterval((function(date){date.setHours(0,0,0,0)}),(function(date,step){date.setDate(date.getDate()+step)}),(function(start,end){return(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationDay}),(function(date){return date.getDate()-1}));var days=day.range;function weekday(i){return newInterval((function(date){date.setDate(date.getDate()-(date.getDay()+7-i)%7);date.setHours(0,0,0,0)}),(function(date,step){date.setDate(date.getDate()+step*7)}),(function(start,end){return(end-start-(end.getTimezoneOffset()-start.getTimezoneOffset())*durationMinute)/durationWeek}))}var sunday=weekday(0);var monday=weekday(1);var tuesday=weekday(2);var wednesday=weekday(3);var thursday=weekday(4);var friday=weekday(5);var saturday=weekday(6);var sundays=sunday.range;var mondays=monday.range;var tuesdays=tuesday.range;var wednesdays=wednesday.range;var thursdays=thursday.range;var fridays=friday.range;var saturdays=saturday.range;var month=newInterval((function(date){date.setDate(1);date.setHours(0,0,0,0)}),(function(date,step){date.setMonth(date.getMonth()+step)}),(function(start,end){return end.getMonth()-start.getMonth()+(end.getFullYear()-start.getFullYear())*12}),(function(date){return date.getMonth()}));var months=month.range;var year=newInterval((function(date){date.setMonth(0,1);date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step)}),(function(start,end){return end.getFullYear()-start.getFullYear()}),(function(date){return date.getFullYear()}));year.every=function(k){return!isFinite(k=Math.floor(k))||!(k>0)?null:newInterval((function(date){date.setFullYear(Math.floor(date.getFullYear()/k)*k);date.setMonth(0,1);date.setHours(0,0,0,0)}),(function(date,step){date.setFullYear(date.getFullYear()+step*k)}))};var years=year.range;var utcMinute=newInterval((function(date){date.setUTCSeconds(0,0)}),(function(date,step){date.setTime(+date+step*durationMinute)}),(function(start,end){return(end-start)/durationMinute}),(function(date){return date.getUTCMinutes()}));var utcMinutes=utcMinute.range;var utcHour=newInterval((function(date){date.setUTCMinutes(0,0,0)}),(function(date,step){date.setTime(+date+step*durationHour)}),(function(start,end){return(end-start)/durationHour}),(function(date){return date.getUTCHours()}));var utcHours=utcHour.range;var utcDay=newInterval((function(date){date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step)}),(function(start,end){return(end-start)/durationDay}),(function(date){return date.getUTCDate()-1}));var utcDays=utcDay.range;function utcWeekday(i){return newInterval((function(date){date.setUTCDate(date.getUTCDate()-(date.getUTCDay()+7-i)%7);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCDate(date.getUTCDate()+step*7)}),(function(start,end){return(end-start)/durationWeek}))}var utcSunday=utcWeekday(0);var utcMonday=utcWeekday(1);var utcTuesday=utcWeekday(2);var utcWednesday=utcWeekday(3);var utcThursday=utcWeekday(4);var utcFriday=utcWeekday(5);var utcSaturday=utcWeekday(6);var utcSundays=utcSunday.range;var utcMondays=utcMonday.range;var utcTuesdays=utcTuesday.range;var utcWednesdays=utcWednesday.range;var utcThursdays=utcThursday.range;var utcFridays=utcFriday.range;var utcSaturdays=utcSaturday.range;var utcMonth=newInterval((function(date){date.setUTCDate(1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCMonth(date.getUTCMonth()+step)}),(function(start,end){return end.getUTCMonth()-start.getUTCMonth()+(end.getUTCFullYear()-start.getUTCFullYear())*12}),(function(date){return date.getUTCMonth()}));var utcMonths=utcMonth.range;var utcYear=newInterval((function(date){date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step)}),(function(start,end){return end.getUTCFullYear()-start.getUTCFullYear()}),(function(date){return date.getUTCFullYear()}));utcYear.every=function(k){return!isFinite(k=Math.floor(k))||!(k>0)?null:newInterval((function(date){date.setUTCFullYear(Math.floor(date.getUTCFullYear()/k)*k);date.setUTCMonth(0,1);date.setUTCHours(0,0,0,0)}),(function(date,step){date.setUTCFullYear(date.getUTCFullYear()+step*k)}))};var utcYears=utcYear.range;exports.timeDay=day;exports.timeDays=days;exports.timeFriday=friday;exports.timeFridays=fridays;exports.timeHour=hour;exports.timeHours=hours;exports.timeInterval=newInterval;exports.timeMillisecond=millisecond;exports.timeMilliseconds=milliseconds;exports.timeMinute=minute;exports.timeMinutes=minutes;exports.timeMonday=monday;exports.timeMondays=mondays;exports.timeMonth=month;exports.timeMonths=months;exports.timeSaturday=saturday;exports.timeSaturdays=saturdays;exports.timeSecond=second;exports.timeSeconds=seconds;exports.timeSunday=sunday;exports.timeSundays=sundays;exports.timeThursday=thursday;exports.timeThursdays=thursdays;exports.timeTuesday=tuesday;exports.timeTuesdays=tuesdays;exports.timeWednesday=wednesday;exports.timeWednesdays=wednesdays;exports.timeWeek=sunday;exports.timeWeeks=sundays;exports.timeYear=year;exports.timeYears=years;exports.utcDay=utcDay;exports.utcDays=utcDays;exports.utcFriday=utcFriday;exports.utcFridays=utcFridays;exports.utcHour=utcHour;exports.utcHours=utcHours;exports.utcMillisecond=millisecond;exports.utcMilliseconds=milliseconds;exports.utcMinute=utcMinute;exports.utcMinutes=utcMinutes;exports.utcMonday=utcMonday;exports.utcMondays=utcMondays;exports.utcMonth=utcMonth;exports.utcMonths=utcMonths;exports.utcSaturday=utcSaturday;exports.utcSaturdays=utcSaturdays;exports.utcSecond=second;exports.utcSeconds=seconds;exports.utcSunday=utcSunday;exports.utcSundays=utcSundays;exports.utcThursday=utcThursday;exports.utcThursdays=utcThursdays;exports.utcTuesday=utcTuesday;exports.utcTuesdays=utcTuesdays;exports.utcWednesday=utcWednesday;exports.utcWednesdays=utcWednesdays;exports.utcWeek=utcSunday;exports.utcWeeks=utcSundays;exports.utcYear=utcYear;exports.utcYears=utcYears;Object.defineProperty(exports,"__esModule",{value:true})}))},264:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(70);var react_1=__webpack_require__(1);var useUnmount_1=tslib_1.__importDefault(__webpack_require__(398));var useThrottle=function(value,ms){if(ms===void 0){ms=200}var _a=react_1.useState(value),state=_a[0],setState=_a[1];var timeout=react_1.useRef();var nextValue=react_1.useRef(null);var hasNextValue=react_1.useRef(0);react_1.useEffect((function(){if(!timeout.current){setState(value);var timeoutCallback_1=function(){if(hasNextValue.current){hasNextValue.current=false;setState(nextValue.current);timeout.current=setTimeout(timeoutCallback_1,ms)}else{timeout.current=undefined}};timeout.current=setTimeout(timeoutCallback_1,ms)}else{nextValue.current=value;hasNextValue.current=true}}),[value]);useUnmount_1.default((function(){timeout.current&&clearTimeout(timeout.current)}));return state};exports.default=useThrottle},380:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(70);var util_1=__webpack_require__(381);var useCustomCompareEffect_1=tslib_1.__importDefault(__webpack_require__(383));var isPrimitive=function(val){return val!==Object(val)};var useDeepCompareEffect=function(effect,deps){if(false){}useCustomCompareEffect_1.default(effect,deps,util_1.isDeepEqual)};exports.default=useDeepCompareEffect},381:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isDeepEqual=exports.off=exports.on=exports.isClient=void 0;var tslib_1=__webpack_require__(70);var react_1=tslib_1.__importDefault(__webpack_require__(382));exports.isClient=typeof window==="object";exports.on=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.addEventListener.apply(obj,args)};exports.off=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.removeEventListener.apply(obj,args)};exports.isDeepEqual=react_1.default},382:function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(key==="_owner"&&a.$$typeof){continue}if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},383:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(1);var isPrimitive=function(val){return val!==Object(val)};var useCustomCompareEffect=function(effect,deps,depsEqual){if(false){}var ref=react_1.useRef(undefined);if(!ref.current||!depsEqual(deps,ref.current)){ref.current=deps}react_1.useEffect(effect,ref.current)};exports.default=useCustomCompareEffect},391:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var prefix="$";function Map(){}Map.prototype=map.prototype={constructor:Map,has:function(key){return prefix+key in this},get:function(key){return this[prefix+key]},set:function(key,value){this[prefix+key]=value;return this},remove:function(key){var property=prefix+key;return property in this&&delete this[property]},clear:function(){for(var property in this)if(property[0]===prefix)delete this[property]},keys:function(){var keys=[];for(var property in this)if(property[0]===prefix)keys.push(property.slice(1));return keys},values:function(){var values=[];for(var property in this)if(property[0]===prefix)values.push(this[property]);return values},entries:function(){var entries=[];for(var property in this)if(property[0]===prefix)entries.push({key:property.slice(1),value:this[property]});return entries},size:function(){var size=0;for(var property in this)if(property[0]===prefix)++size;return size},empty:function(){for(var property in this)if(property[0]===prefix)return false;return true},each:function(f){for(var property in this)if(property[0]===prefix)f(this[property],property.slice(1),this)}};function map(object,f){var map=new Map;if(object instanceof Map)object.each((function(value,key){map.set(key,value)}));else if(Array.isArray(object)){var i=-1,n=object.length,o;if(f==null)while(++i<n)map.set(i,object[i]);else while(++i<n)map.set(f(o=object[i],i,object),o)}else if(object)for(var key in object)map.set(key,object[key]);return map}function nest(){var keys=[],sortKeys=[],sortValues,rollup,nest;function apply(array,depth,createResult,setResult){if(depth>=keys.length){if(sortValues!=null)array.sort(sortValues);return rollup!=null?rollup(array):array}var i=-1,n=array.length,key=keys[depth++],keyValue,value,valuesByKey=map(),values,result=createResult();while(++i<n){if(values=valuesByKey.get(keyValue=key(value=array[i])+"")){values.push(value)}else{valuesByKey.set(keyValue,[value])}}valuesByKey.each((function(values,key){setResult(result,key,apply(values,depth,createResult,setResult))}));return result}function entries(map$$1,depth){if(++depth>keys.length)return map$$1;var array,sortKey=sortKeys[depth-1];if(rollup!=null&&depth>=keys.length)array=map$$1.entries();else array=[],map$$1.each((function(v,k){array.push({key:k,values:entries(v,depth)})}));return sortKey!=null?array.sort((function(a,b){return sortKey(a.key,b.key)})):array}return nest={object:function(array){return apply(array,0,createObject,setObject)},map:function(array){return apply(array,0,createMap,setMap)},entries:function(array){return entries(apply(array,0,createMap,setMap),0)},key:function(d){keys.push(d);return nest},sortKeys:function(order){sortKeys[keys.length-1]=order;return nest},sortValues:function(order){sortValues=order;return nest},rollup:function(f){rollup=f;return nest}}}function createObject(){return{}}function setObject(object,key,value){object[key]=value}function createMap(){return map()}function setMap(map$$1,key,value){map$$1.set(key,value)}function Set(){}var proto=map.prototype;Set.prototype=set.prototype={constructor:Set,has:proto.has,add:function(value){value+="";this[prefix+value]=value;return this},remove:proto.remove,clear:proto.clear,values:proto.keys,size:proto.size,empty:proto.empty,each:proto.each};function set(object,f){var set=new Set;if(object instanceof Set)object.each((function(value){set.add(value)}));else if(object){var i=-1,n=object.length;if(f==null)while(++i<n)set.add(object[i]);else while(++i<n)set.add(f(object[i],i,object))}return set}function keys(map){var keys=[];for(var key in map)keys.push(key);return keys}function values(map){var values=[];for(var key in map)values.push(map[key]);return values}function entries(map){var entries=[];for(var key in map)entries.push({key:key,value:map[key]});return entries}exports.nest=nest;exports.set=set;exports.map=map;exports.keys=keys;exports.values=values;exports.entries=entries;Object.defineProperty(exports,"__esModule",{value:true})}))},392:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(262)):undefined})(this,(function(exports,d3Color){"use strict";function basis(t1,v0,v1,v2,v3){var t2=t1*t1,t3=t2*t1;return((1-3*t1+3*t2-t3)*v0+(4-6*t2+3*t3)*v1+(1+3*t1+3*t2-3*t3)*v2+t3*v3)/6}function basis$1(values){var n=values.length-1;return function(t){var i=t<=0?t=0:t>=1?(t=1,n-1):Math.floor(t*n),v1=values[i],v2=values[i+1],v0=i>0?values[i-1]:2*v1-v2,v3=i<n-1?values[i+2]:2*v2-v1;return basis((t-i/n)*n,v0,v1,v2,v3)}}function basisClosed(values){var n=values.length;return function(t){var i=Math.floor(((t%=1)<0?++t:t)*n),v0=values[(i+n-1)%n],v1=values[i%n],v2=values[(i+1)%n],v3=values[(i+2)%n];return basis((t-i/n)*n,v0,v1,v2,v3)}}function constant(x){return function(){return x}}function linear(a,d){return function(t){return a+t*d}}function exponential(a,b,y){return a=Math.pow(a,y),b=Math.pow(b,y)-a,y=1/y,function(t){return Math.pow(a+t*b,y)}}function hue(a,b){var d=b-a;return d?linear(a,d>180||d<-180?d-360*Math.round(d/360):d):constant(isNaN(a)?b:a)}function gamma(y){return(y=+y)===1?nogamma:function(a,b){return b-a?exponential(a,b,y):constant(isNaN(a)?b:a)}}function nogamma(a,b){var d=b-a;return d?linear(a,d):constant(isNaN(a)?b:a)}var rgb=function rgbGamma(y){var color=gamma(y);function rgb(start,end){var r=color((start=d3Color.rgb(start)).r,(end=d3Color.rgb(end)).r),g=color(start.g,end.g),b=color(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){start.r=r(t);start.g=g(t);start.b=b(t);start.opacity=opacity(t);return start+""}}rgb.gamma=rgbGamma;return rgb}(1);function rgbSpline(spline){return function(colors){var n=colors.length,r=new Array(n),g=new Array(n),b=new Array(n),i,color;for(i=0;i<n;++i){color=d3Color.rgb(colors[i]);r[i]=color.r||0;g[i]=color.g||0;b[i]=color.b||0}r=spline(r);g=spline(g);b=spline(b);color.opacity=1;return function(t){color.r=r(t);color.g=g(t);color.b=b(t);return color+""}}}var rgbBasis=rgbSpline(basis$1);var rgbBasisClosed=rgbSpline(basisClosed);function numberArray(a,b){if(!b)b=[];var n=a?Math.min(b.length,a.length):0,c=b.slice(),i;return function(t){for(i=0;i<n;++i)c[i]=a[i]*(1-t)+b[i]*t;return c}}function isNumberArray(x){return ArrayBuffer.isView(x)&&!(x instanceof DataView)}function array(a,b){return(isNumberArray(b)?numberArray:genericArray)(a,b)}function genericArray(a,b){var nb=b?b.length:0,na=a?Math.min(nb,a.length):0,x=new Array(na),c=new Array(nb),i;for(i=0;i<na;++i)x[i]=value(a[i],b[i]);for(;i<nb;++i)c[i]=b[i];return function(t){for(i=0;i<na;++i)c[i]=x[i](t);return c}}function date(a,b){var d=new Date;return a=+a,b=+b,function(t){return d.setTime(a*(1-t)+b*t),d}}function number(a,b){return a=+a,b=+b,function(t){return a*(1-t)+b*t}}function object(a,b){var i={},c={},k;if(a===null||typeof a!=="object")a={};if(b===null||typeof b!=="object")b={};for(k in b){if(k in a){i[k]=value(a[k],b[k])}else{c[k]=b[k]}}return function(t){for(k in i)c[k]=i[k](t);return c}}var reA=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,reB=new RegExp(reA.source,"g");function zero(b){return function(){return b}}function one(b){return function(t){return b(t)+""}}function string(a,b){var bi=reA.lastIndex=reB.lastIndex=0,am,bm,bs,i=-1,s=[],q=[];a=a+"",b=b+"";while((am=reA.exec(a))&&(bm=reB.exec(b))){if((bs=bm.index)>bi){bs=b.slice(bi,bs);if(s[i])s[i]+=bs;else s[++i]=bs}if((am=am[0])===(bm=bm[0])){if(s[i])s[i]+=bm;else s[++i]=bm}else{s[++i]=null;q.push({i:i,x:number(am,bm)})}bi=reB.lastIndex}if(bi<b.length){bs=b.slice(bi);if(s[i])s[i]+=bs;else s[++i]=bs}return s.length<2?q[0]?one(q[0].x):zero(b):(b=q.length,function(t){for(var i=0,o;i<b;++i)s[(o=q[i]).i]=o.x(t);return s.join("")})}function value(a,b){var t=typeof b,c;return b==null||t==="boolean"?constant(b):(t==="number"?number:t==="string"?(c=d3Color.color(b))?(b=c,rgb):string:b instanceof d3Color.color?rgb:b instanceof Date?date:isNumberArray(b)?numberArray:Array.isArray(b)?genericArray:typeof b.valueOf!=="function"&&typeof b.toString!=="function"||isNaN(b)?object:number)(a,b)}function discrete(range){var n=range.length;return function(t){return range[Math.max(0,Math.min(n-1,Math.floor(t*n)))]}}function hue$1(a,b){var i=hue(+a,+b);return function(t){var x=i(t);return x-360*Math.floor(x/360)}}function round(a,b){return a=+a,b=+b,function(t){return Math.round(a*(1-t)+b*t)}}var degrees=180/Math.PI;var identity={translateX:0,translateY:0,rotate:0,skewX:0,scaleX:1,scaleY:1};function decompose(a,b,c,d,e,f){var scaleX,scaleY,skewX;if(scaleX=Math.sqrt(a*a+b*b))a/=scaleX,b/=scaleX;if(skewX=a*c+b*d)c-=a*skewX,d-=b*skewX;if(scaleY=Math.sqrt(c*c+d*d))c/=scaleY,d/=scaleY,skewX/=scaleY;if(a*d<b*c)a=-a,b=-b,skewX=-skewX,scaleX=-scaleX;return{translateX:e,translateY:f,rotate:Math.atan2(b,a)*degrees,skewX:Math.atan(skewX)*degrees,scaleX:scaleX,scaleY:scaleY}}var cssNode,cssRoot,cssView,svgNode;function parseCss(value){if(value==="none")return identity;if(!cssNode)cssNode=document.createElement("DIV"),cssRoot=document.documentElement,cssView=document.defaultView;cssNode.style.transform=value;value=cssView.getComputedStyle(cssRoot.appendChild(cssNode),null).getPropertyValue("transform");cssRoot.removeChild(cssNode);value=value.slice(7,-1).split(",");return decompose(+value[0],+value[1],+value[2],+value[3],+value[4],+value[5])}function parseSvg(value){if(value==null)return identity;if(!svgNode)svgNode=document.createElementNS("http://www.w3.org/2000/svg","g");svgNode.setAttribute("transform",value);if(!(value=svgNode.transform.baseVal.consolidate()))return identity;value=value.matrix;return decompose(value.a,value.b,value.c,value.d,value.e,value.f)}function interpolateTransform(parse,pxComma,pxParen,degParen){function pop(s){return s.length?s.pop()+" ":""}function translate(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push("translate(",null,pxComma,null,pxParen);q.push({i:i-4,x:number(xa,xb)},{i:i-2,x:number(ya,yb)})}else if(xb||yb){s.push("translate("+xb+pxComma+yb+pxParen)}}function rotate(a,b,s,q){if(a!==b){if(a-b>180)b+=360;else if(b-a>180)a+=360;q.push({i:s.push(pop(s)+"rotate(",null,degParen)-2,x:number(a,b)})}else if(b){s.push(pop(s)+"rotate("+b+degParen)}}function skewX(a,b,s,q){if(a!==b){q.push({i:s.push(pop(s)+"skewX(",null,degParen)-2,x:number(a,b)})}else if(b){s.push(pop(s)+"skewX("+b+degParen)}}function scale(xa,ya,xb,yb,s,q){if(xa!==xb||ya!==yb){var i=s.push(pop(s)+"scale(",null,",",null,")");q.push({i:i-4,x:number(xa,xb)},{i:i-2,x:number(ya,yb)})}else if(xb!==1||yb!==1){s.push(pop(s)+"scale("+xb+","+yb+")")}}return function(a,b){var s=[],q=[];a=parse(a),b=parse(b);translate(a.translateX,a.translateY,b.translateX,b.translateY,s,q);rotate(a.rotate,b.rotate,s,q);skewX(a.skewX,b.skewX,s,q);scale(a.scaleX,a.scaleY,b.scaleX,b.scaleY,s,q);a=b=null;return function(t){var i=-1,n=q.length,o;while(++i<n)s[(o=q[i]).i]=o.x(t);return s.join("")}}}var interpolateTransformCss=interpolateTransform(parseCss,"px, ","px)","deg)");var interpolateTransformSvg=interpolateTransform(parseSvg,", ",")",")");var rho=Math.SQRT2,rho2=2,rho4=4,epsilon2=1e-12;function cosh(x){return((x=Math.exp(x))+1/x)/2}function sinh(x){return((x=Math.exp(x))-1/x)/2}function tanh(x){return((x=Math.exp(2*x))-1)/(x+1)}function zoom(p0,p1){var ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2],dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy,i,S;if(d2<epsilon2){S=Math.log(w1/w0)/rho;i=function(t){return[ux0+t*dx,uy0+t*dy,w0*Math.exp(rho*t*S)]}}else{var d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+rho4*d2)/(2*w0*rho2*d1),b1=(w1*w1-w0*w0-rho4*d2)/(2*w1*rho2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1);S=(r1-r0)/rho;i=function(t){var s=t*S,coshr0=cosh(r0),u=w0/(rho2*d1)*(coshr0*tanh(rho*s+r0)-sinh(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/cosh(rho*s+r0)]}}i.duration=S*1e3;return i}function hsl(hue){return function(start,end){var h=hue((start=d3Color.hsl(start)).h,(end=d3Color.hsl(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.s=s(t);start.l=l(t);start.opacity=opacity(t);return start+""}}}var hsl$1=hsl(hue);var hslLong=hsl(nogamma);function lab(start,end){var l=nogamma((start=d3Color.lab(start)).l,(end=d3Color.lab(end)).l),a=nogamma(start.a,end.a),b=nogamma(start.b,end.b),opacity=nogamma(start.opacity,end.opacity);return function(t){start.l=l(t);start.a=a(t);start.b=b(t);start.opacity=opacity(t);return start+""}}function hcl(hue){return function(start,end){var h=hue((start=d3Color.hcl(start)).h,(end=d3Color.hcl(end)).h),c=nogamma(start.c,end.c),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.c=c(t);start.l=l(t);start.opacity=opacity(t);return start+""}}}var hcl$1=hcl(hue);var hclLong=hcl(nogamma);function cubehelix(hue){return function cubehelixGamma(y){y=+y;function cubehelix(start,end){var h=hue((start=d3Color.cubehelix(start)).h,(end=d3Color.cubehelix(end)).h),s=nogamma(start.s,end.s),l=nogamma(start.l,end.l),opacity=nogamma(start.opacity,end.opacity);return function(t){start.h=h(t);start.s=s(t);start.l=l(Math.pow(t,y));start.opacity=opacity(t);return start+""}}cubehelix.gamma=cubehelixGamma;return cubehelix}(1)}var cubehelix$1=cubehelix(hue);var cubehelixLong=cubehelix(nogamma);function piecewise(interpolate,values){var i=0,n=values.length-1,v=values[0],I=new Array(n<0?0:n);while(i<n)I[i]=interpolate(v,v=values[++i]);return function(t){var i=Math.max(0,Math.min(n-1,Math.floor(t*=n)));return I[i](t-i)}}function quantize(interpolator,n){var samples=new Array(n);for(var i=0;i<n;++i)samples[i]=interpolator(i/(n-1));return samples}exports.interpolate=value;exports.interpolateArray=array;exports.interpolateBasis=basis$1;exports.interpolateBasisClosed=basisClosed;exports.interpolateCubehelix=cubehelix$1;exports.interpolateCubehelixLong=cubehelixLong;exports.interpolateDate=date;exports.interpolateDiscrete=discrete;exports.interpolateHcl=hcl$1;exports.interpolateHclLong=hclLong;exports.interpolateHsl=hsl$1;exports.interpolateHslLong=hslLong;exports.interpolateHue=hue$1;exports.interpolateLab=lab;exports.interpolateNumber=number;exports.interpolateNumberArray=numberArray;exports.interpolateObject=object;exports.interpolateRgb=rgb;exports.interpolateRgbBasis=rgbBasis;exports.interpolateRgbBasisClosed=rgbBasisClosed;exports.interpolateRound=round;exports.interpolateString=string;exports.interpolateTransformCss=interpolateTransformCss;exports.interpolateTransformSvg=interpolateTransformSvg;exports.interpolateZoom=zoom;exports.piecewise=piecewise;exports.quantize=quantize;Object.defineProperty(exports,"__esModule",{value:true})}))},393:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";function formatDecimal(x,p){if((i=(x=p?x.toExponential(p-1):x.toExponential()).indexOf("e"))<0)return null;var i,coefficient=x.slice(0,i);return[coefficient.length>1?coefficient[0]+coefficient.slice(2):coefficient,+x.slice(i+1)]}function exponent(x){return x=formatDecimal(Math.abs(x)),x?x[1]:NaN}function formatGroup(grouping,thousands){return function(value,width){var i=value.length,t=[],j=0,g=grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=grouping[j=(j+1)%grouping.length]}return t.reverse().join(thousands)}}function formatNumerals(numerals){return function(value){return value.replace(/[0-9]/g,(function(i){return numerals[+i]}))}}var re=/^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;function formatSpecifier(specifier){if(!(match=re.exec(specifier)))throw new Error("invalid format: "+specifier);var match;return new FormatSpecifier({fill:match[1],align:match[2],sign:match[3],symbol:match[4],zero:match[5],width:match[6],comma:match[7],precision:match[8]&&match[8].slice(1),trim:match[9],type:match[10]})}formatSpecifier.prototype=FormatSpecifier.prototype;function FormatSpecifier(specifier){this.fill=specifier.fill===undefined?" ":specifier.fill+"";this.align=specifier.align===undefined?">":specifier.align+"";this.sign=specifier.sign===undefined?"-":specifier.sign+"";this.symbol=specifier.symbol===undefined?"":specifier.symbol+"";this.zero=!!specifier.zero;this.width=specifier.width===undefined?undefined:+specifier.width;this.comma=!!specifier.comma;this.precision=specifier.precision===undefined?undefined:+specifier.precision;this.trim=!!specifier.trim;this.type=specifier.type===undefined?"":specifier.type+""}FormatSpecifier.prototype.toString=function(){return this.fill+this.align+this.sign+this.symbol+(this.zero?"0":"")+(this.width===undefined?"":Math.max(1,this.width|0))+(this.comma?",":"")+(this.precision===undefined?"":"."+Math.max(0,this.precision|0))+(this.trim?"~":"")+this.type};function formatTrim(s){out:for(var n=s.length,i=1,i0=-1,i1;i<n;++i){switch(s[i]){case".":i0=i1=i;break;case"0":if(i0===0)i0=i;i1=i;break;default:if(!+s[i])break out;if(i0>0)i0=0;break}}return i0>0?s.slice(0,i0)+s.slice(i1+1):s}var prefixExponent;function formatPrefixAuto(x,p){var d=formatDecimal(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1],i=exponent-(prefixExponent=Math.max(-8,Math.min(8,Math.floor(exponent/3)))*3)+1,n=coefficient.length;return i===n?coefficient:i>n?coefficient+new Array(i-n+1).join("0"):i>0?coefficient.slice(0,i)+"."+coefficient.slice(i):"0."+new Array(1-i).join("0")+formatDecimal(x,Math.max(0,p+i-1))[0]}function formatRounded(x,p){var d=formatDecimal(x,p);if(!d)return x+"";var coefficient=d[0],exponent=d[1];return exponent<0?"0."+new Array(-exponent).join("0")+coefficient:coefficient.length>exponent+1?coefficient.slice(0,exponent+1)+"."+coefficient.slice(exponent+1):coefficient+new Array(exponent-coefficient.length+2).join("0")}var formatTypes={"%":function(x,p){return(x*100).toFixed(p)},b:function(x){return Math.round(x).toString(2)},c:function(x){return x+""},d:function(x){return Math.round(x).toString(10)},e:function(x,p){return x.toExponential(p)},f:function(x,p){return x.toFixed(p)},g:function(x,p){return x.toPrecision(p)},o:function(x){return Math.round(x).toString(8)},p:function(x,p){return formatRounded(x*100,p)},r:formatRounded,s:formatPrefixAuto,X:function(x){return Math.round(x).toString(16).toUpperCase()},x:function(x){return Math.round(x).toString(16)}};function identity(x){return x}var map=Array.prototype.map,prefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"];function formatLocale(locale){var group=locale.grouping===undefined||locale.thousands===undefined?identity:formatGroup(map.call(locale.grouping,Number),locale.thousands+""),currencyPrefix=locale.currency===undefined?"":locale.currency[0]+"",currencySuffix=locale.currency===undefined?"":locale.currency[1]+"",decimal=locale.decimal===undefined?".":locale.decimal+"",numerals=locale.numerals===undefined?identity:formatNumerals(map.call(locale.numerals,String)),percent=locale.percent===undefined?"%":locale.percent+"",minus=locale.minus===undefined?"-":locale.minus+"",nan=locale.nan===undefined?"NaN":locale.nan+"";function newFormat(specifier){specifier=formatSpecifier(specifier);var fill=specifier.fill,align=specifier.align,sign=specifier.sign,symbol=specifier.symbol,zero=specifier.zero,width=specifier.width,comma=specifier.comma,precision=specifier.precision,trim=specifier.trim,type=specifier.type;if(type==="n")comma=true,type="g";else if(!formatTypes[type])precision===undefined&&(precision=12),trim=true,type="g";if(zero||fill==="0"&&align==="=")zero=true,fill="0",align="=";var prefix=symbol==="$"?currencyPrefix:symbol==="#"&&/[boxX]/.test(type)?"0"+type.toLowerCase():"",suffix=symbol==="$"?currencySuffix:/[%p]/.test(type)?percent:"";var formatType=formatTypes[type],maybeSuffix=/[defgprs%]/.test(type);precision=precision===undefined?6:/[gprs]/.test(type)?Math.max(1,Math.min(21,precision)):Math.max(0,Math.min(20,precision));function format(value){var valuePrefix=prefix,valueSuffix=suffix,i,n,c;if(type==="c"){valueSuffix=formatType(value)+valueSuffix;value=""}else{value=+value;var valueNegative=value<0||1/value<0;value=isNaN(value)?nan:formatType(Math.abs(value),precision);if(trim)value=formatTrim(value);if(valueNegative&&+value===0&&sign!=="+")valueNegative=false;valuePrefix=(valueNegative?sign==="("?sign:minus:sign==="-"||sign==="("?"":sign)+valuePrefix;valueSuffix=(type==="s"?prefixes[8+prefixExponent/3]:"")+valueSuffix+(valueNegative&&sign==="("?")":"");if(maybeSuffix){i=-1,n=value.length;while(++i<n){if(c=value.charCodeAt(i),48>c||c>57){valueSuffix=(c===46?decimal+value.slice(i+1):value.slice(i))+valueSuffix;value=value.slice(0,i);break}}}}if(comma&&!zero)value=group(value,Infinity);var length=valuePrefix.length+value.length+valueSuffix.length,padding=length<width?new Array(width-length+1).join(fill):"";if(comma&&zero)value=group(padding+value,padding.length?width-valueSuffix.length:Infinity),padding="";switch(align){case"<":value=valuePrefix+value+valueSuffix+padding;break;case"=":value=valuePrefix+padding+value+valueSuffix;break;case"^":value=padding.slice(0,length=padding.length>>1)+valuePrefix+value+valueSuffix+padding.slice(length);break;default:value=padding+valuePrefix+value+valueSuffix;break}return numerals(value)}format.toString=function(){return specifier+""};return format}function formatPrefix(specifier,value){var f=newFormat((specifier=formatSpecifier(specifier),specifier.type="f",specifier)),e=Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3,k=Math.pow(10,-e),prefix=prefixes[8+e/3];return function(value){return f(k*value)+prefix}}return{format:newFormat,formatPrefix:formatPrefix}}var locale;defaultLocale({decimal:".",thousands:",",grouping:[3],currency:["$",""],minus:"-"});function defaultLocale(definition){locale=formatLocale(definition);exports.format=locale.format;exports.formatPrefix=locale.formatPrefix;return locale}function precisionFixed(step){return Math.max(0,-exponent(Math.abs(step)))}function precisionPrefix(step,value){return Math.max(0,Math.max(-8,Math.min(8,Math.floor(exponent(value)/3)))*3-exponent(Math.abs(step)))}function precisionRound(step,max){step=Math.abs(step),max=Math.abs(max)-step;return Math.max(0,exponent(max)-exponent(step))+1}exports.FormatSpecifier=FormatSpecifier;exports.formatDefaultLocale=defaultLocale;exports.formatLocale=formatLocale;exports.formatSpecifier=formatSpecifier;exports.precisionFixed=precisionFixed;exports.precisionPrefix=precisionPrefix;exports.precisionRound=precisionRound;Object.defineProperty(exports,"__esModule",{value:true})}))},394:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(263)):undefined})(this,(function(exports,d3Time){"use strict";function localDate(d){if(0<=d.y&&d.y<100){var date=new Date(-1,d.m,d.d,d.H,d.M,d.S,d.L);date.setFullYear(d.y);return date}return new Date(d.y,d.m,d.d,d.H,d.M,d.S,d.L)}function utcDate(d){if(0<=d.y&&d.y<100){var date=new Date(Date.UTC(-1,d.m,d.d,d.H,d.M,d.S,d.L));date.setUTCFullYear(d.y);return date}return new Date(Date.UTC(d.y,d.m,d.d,d.H,d.M,d.S,d.L))}function newDate(y,m,d){return{y:y,m:m,d:d,H:0,M:0,S:0,L:0}}function formatLocale(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_weekdays=locale.days,locale_shortWeekdays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;var periodRe=formatRe(locale_periods),periodLookup=formatLookup(locale_periods),weekdayRe=formatRe(locale_weekdays),weekdayLookup=formatLookup(locale_weekdays),shortWeekdayRe=formatRe(locale_shortWeekdays),shortWeekdayLookup=formatLookup(locale_shortWeekdays),monthRe=formatRe(locale_months),monthLookup=formatLookup(locale_months),shortMonthRe=formatRe(locale_shortMonths),shortMonthLookup=formatLookup(locale_shortMonths);var formats={a:formatShortWeekday,A:formatWeekday,b:formatShortMonth,B:formatMonth,c:null,d:formatDayOfMonth,e:formatDayOfMonth,f:formatMicroseconds,H:formatHour24,I:formatHour12,j:formatDayOfYear,L:formatMilliseconds,m:formatMonthNumber,M:formatMinutes,p:formatPeriod,q:formatQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatSeconds,u:formatWeekdayNumberMonday,U:formatWeekNumberSunday,V:formatWeekNumberISO,w:formatWeekdayNumberSunday,W:formatWeekNumberMonday,x:null,X:null,y:formatYear,Y:formatFullYear,Z:formatZone,"%":formatLiteralPercent};var utcFormats={a:formatUTCShortWeekday,A:formatUTCWeekday,b:formatUTCShortMonth,B:formatUTCMonth,c:null,d:formatUTCDayOfMonth,e:formatUTCDayOfMonth,f:formatUTCMicroseconds,H:formatUTCHour24,I:formatUTCHour12,j:formatUTCDayOfYear,L:formatUTCMilliseconds,m:formatUTCMonthNumber,M:formatUTCMinutes,p:formatUTCPeriod,q:formatUTCQuarter,Q:formatUnixTimestamp,s:formatUnixTimestampSeconds,S:formatUTCSeconds,u:formatUTCWeekdayNumberMonday,U:formatUTCWeekNumberSunday,V:formatUTCWeekNumberISO,w:formatUTCWeekdayNumberSunday,W:formatUTCWeekNumberMonday,x:null,X:null,y:formatUTCYear,Y:formatUTCFullYear,Z:formatUTCZone,"%":formatLiteralPercent};var parses={a:parseShortWeekday,A:parseWeekday,b:parseShortMonth,B:parseMonth,c:parseLocaleDateTime,d:parseDayOfMonth,e:parseDayOfMonth,f:parseMicroseconds,H:parseHour24,I:parseHour24,j:parseDayOfYear,L:parseMilliseconds,m:parseMonthNumber,M:parseMinutes,p:parsePeriod,q:parseQuarter,Q:parseUnixTimestamp,s:parseUnixTimestampSeconds,S:parseSeconds,u:parseWeekdayNumberMonday,U:parseWeekNumberSunday,V:parseWeekNumberISO,w:parseWeekdayNumberSunday,W:parseWeekNumberMonday,x:parseLocaleDate,X:parseLocaleTime,y:parseYear,Y:parseFullYear,Z:parseZone,"%":parseLiteralPercent};formats.x=newFormat(locale_date,formats);formats.X=newFormat(locale_time,formats);formats.c=newFormat(locale_dateTime,formats);utcFormats.x=newFormat(locale_date,utcFormats);utcFormats.X=newFormat(locale_time,utcFormats);utcFormats.c=newFormat(locale_dateTime,utcFormats);function newFormat(specifier,formats){return function(date){var string=[],i=-1,j=0,n=specifier.length,c,pad,format;if(!(date instanceof Date))date=new Date(+date);while(++i<n){if(specifier.charCodeAt(i)===37){string.push(specifier.slice(j,i));if((pad=pads[c=specifier.charAt(++i)])!=null)c=specifier.charAt(++i);else pad=c==="e"?" ":"0";if(format=formats[c])c=format(date,pad);string.push(c);j=i+1}}string.push(specifier.slice(j,i));return string.join("")}}function newParse(specifier,Z){return function(string){var d=newDate(1900,undefined,1),i=parseSpecifier(d,specifier,string+="",0),week,day;if(i!=string.length)return null;if("Q"in d)return new Date(d.Q);if("s"in d)return new Date(d.s*1e3+("L"in d?d.L:0));if(Z&&!("Z"in d))d.Z=0;if("p"in d)d.H=d.H%12+d.p*12;if(d.m===undefined)d.m="q"in d?d.q:0;if("V"in d){if(d.V<1||d.V>53)return null;if(!("w"in d))d.w=1;if("Z"in d){week=utcDate(newDate(d.y,0,1)),day=week.getUTCDay();week=day>4||day===0?d3Time.utcMonday.ceil(week):d3Time.utcMonday(week);week=d3Time.utcDay.offset(week,(d.V-1)*7);d.y=week.getUTCFullYear();d.m=week.getUTCMonth();d.d=week.getUTCDate()+(d.w+6)%7}else{week=localDate(newDate(d.y,0,1)),day=week.getDay();week=day>4||day===0?d3Time.timeMonday.ceil(week):d3Time.timeMonday(week);week=d3Time.timeDay.offset(week,(d.V-1)*7);d.y=week.getFullYear();d.m=week.getMonth();d.d=week.getDate()+(d.w+6)%7}}else if("W"in d||"U"in d){if(!("w"in d))d.w="u"in d?d.u%7:"W"in d?1:0;day="Z"in d?utcDate(newDate(d.y,0,1)).getUTCDay():localDate(newDate(d.y,0,1)).getDay();d.m=0;d.d="W"in d?(d.w+6)%7+d.W*7-(day+5)%7:d.w+d.U*7-(day+6)%7}if("Z"in d){d.H+=d.Z/100|0;d.M+=d.Z%100;return utcDate(d)}return localDate(d)}}function parseSpecifier(d,specifier,string,j){var i=0,n=specifier.length,m=string.length,c,parse;while(i<n){if(j>=m)return-1;c=specifier.charCodeAt(i++);if(c===37){c=specifier.charAt(i++);parse=parses[c in pads?specifier.charAt(i++):c];if(!parse||(j=parse(d,string,j))<0)return-1}else if(c!=string.charCodeAt(j++)){return-1}}return j}function parsePeriod(d,string,i){var n=periodRe.exec(string.slice(i));return n?(d.p=periodLookup[n[0].toLowerCase()],i+n[0].length):-1}function parseShortWeekday(d,string,i){var n=shortWeekdayRe.exec(string.slice(i));return n?(d.w=shortWeekdayLookup[n[0].toLowerCase()],i+n[0].length):-1}function parseWeekday(d,string,i){var n=weekdayRe.exec(string.slice(i));return n?(d.w=weekdayLookup[n[0].toLowerCase()],i+n[0].length):-1}function parseShortMonth(d,string,i){var n=shortMonthRe.exec(string.slice(i));return n?(d.m=shortMonthLookup[n[0].toLowerCase()],i+n[0].length):-1}function parseMonth(d,string,i){var n=monthRe.exec(string.slice(i));return n?(d.m=monthLookup[n[0].toLowerCase()],i+n[0].length):-1}function parseLocaleDateTime(d,string,i){return parseSpecifier(d,locale_dateTime,string,i)}function parseLocaleDate(d,string,i){return parseSpecifier(d,locale_date,string,i)}function parseLocaleTime(d,string,i){return parseSpecifier(d,locale_time,string,i)}function formatShortWeekday(d){return locale_shortWeekdays[d.getDay()]}function formatWeekday(d){return locale_weekdays[d.getDay()]}function formatShortMonth(d){return locale_shortMonths[d.getMonth()]}function formatMonth(d){return locale_months[d.getMonth()]}function formatPeriod(d){return locale_periods[+(d.getHours()>=12)]}function formatQuarter(d){return 1+~~(d.getMonth()/3)}function formatUTCShortWeekday(d){return locale_shortWeekdays[d.getUTCDay()]}function formatUTCWeekday(d){return locale_weekdays[d.getUTCDay()]}function formatUTCShortMonth(d){return locale_shortMonths[d.getUTCMonth()]}function formatUTCMonth(d){return locale_months[d.getUTCMonth()]}function formatUTCPeriod(d){return locale_periods[+(d.getUTCHours()>=12)]}function formatUTCQuarter(d){return 1+~~(d.getUTCMonth()/3)}return{format:function(specifier){var f=newFormat(specifier+="",formats);f.toString=function(){return specifier};return f},parse:function(specifier){var p=newParse(specifier+="",false);p.toString=function(){return specifier};return p},utcFormat:function(specifier){var f=newFormat(specifier+="",utcFormats);f.toString=function(){return specifier};return f},utcParse:function(specifier){var p=newParse(specifier+="",true);p.toString=function(){return specifier};return p}}}var pads={"-":"",_:" ",0:"0"},numberRe=/^\s*\d+/,percentRe=/^%/,requoteRe=/[\\^$*+?|[\]().{}]/g;function pad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string)}function requote(s){return s.replace(requoteRe,"\\$&")}function formatRe(names){return new RegExp("^(?:"+names.map(requote).join("|")+")","i")}function formatLookup(names){var map={},i=-1,n=names.length;while(++i<n)map[names[i].toLowerCase()]=i;return map}function parseWeekdayNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.w=+n[0],i+n[0].length):-1}function parseWeekdayNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.u=+n[0],i+n[0].length):-1}function parseWeekNumberSunday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.U=+n[0],i+n[0].length):-1}function parseWeekNumberISO(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.V=+n[0],i+n[0].length):-1}function parseWeekNumberMonday(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.W=+n[0],i+n[0].length):-1}function parseFullYear(d,string,i){var n=numberRe.exec(string.slice(i,i+4));return n?(d.y=+n[0],i+n[0].length):-1}function parseYear(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.y=+n[0]+(+n[0]>68?1900:2e3),i+n[0].length):-1}function parseZone(d,string,i){var n=/^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string.slice(i,i+6));return n?(d.Z=n[1]?0:-(n[2]+(n[3]||"00")),i+n[0].length):-1}function parseQuarter(d,string,i){var n=numberRe.exec(string.slice(i,i+1));return n?(d.q=n[0]*3-3,i+n[0].length):-1}function parseMonthNumber(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.m=n[0]-1,i+n[0].length):-1}function parseDayOfMonth(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.d=+n[0],i+n[0].length):-1}function parseDayOfYear(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.m=0,d.d=+n[0],i+n[0].length):-1}function parseHour24(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.H=+n[0],i+n[0].length):-1}function parseMinutes(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.M=+n[0],i+n[0].length):-1}function parseSeconds(d,string,i){var n=numberRe.exec(string.slice(i,i+2));return n?(d.S=+n[0],i+n[0].length):-1}function parseMilliseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+3));return n?(d.L=+n[0],i+n[0].length):-1}function parseMicroseconds(d,string,i){var n=numberRe.exec(string.slice(i,i+6));return n?(d.L=Math.floor(n[0]/1e3),i+n[0].length):-1}function parseLiteralPercent(d,string,i){var n=percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1}function parseUnixTimestamp(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.Q=+n[0],i+n[0].length):-1}function parseUnixTimestampSeconds(d,string,i){var n=numberRe.exec(string.slice(i));return n?(d.s=+n[0],i+n[0].length):-1}function formatDayOfMonth(d,p){return pad(d.getDate(),p,2)}function formatHour24(d,p){return pad(d.getHours(),p,2)}function formatHour12(d,p){return pad(d.getHours()%12||12,p,2)}function formatDayOfYear(d,p){return pad(1+d3Time.timeDay.count(d3Time.timeYear(d),d),p,3)}function formatMilliseconds(d,p){return pad(d.getMilliseconds(),p,3)}function formatMicroseconds(d,p){return formatMilliseconds(d,p)+"000"}function formatMonthNumber(d,p){return pad(d.getMonth()+1,p,2)}function formatMinutes(d,p){return pad(d.getMinutes(),p,2)}function formatSeconds(d,p){return pad(d.getSeconds(),p,2)}function formatWeekdayNumberMonday(d){var day=d.getDay();return day===0?7:day}function formatWeekNumberSunday(d,p){return pad(d3Time.timeSunday.count(d3Time.timeYear(d)-1,d),p,2)}function formatWeekNumberISO(d,p){var day=d.getDay();d=day>=4||day===0?d3Time.timeThursday(d):d3Time.timeThursday.ceil(d);return pad(d3Time.timeThursday.count(d3Time.timeYear(d),d)+(d3Time.timeYear(d).getDay()===4),p,2)}function formatWeekdayNumberSunday(d){return d.getDay()}function formatWeekNumberMonday(d,p){return pad(d3Time.timeMonday.count(d3Time.timeYear(d)-1,d),p,2)}function formatYear(d,p){return pad(d.getFullYear()%100,p,2)}function formatFullYear(d,p){return pad(d.getFullYear()%1e4,p,4)}function formatZone(d){var z=d.getTimezoneOffset();return(z>0?"-":(z*=-1,"+"))+pad(z/60|0,"0",2)+pad(z%60,"0",2)}function formatUTCDayOfMonth(d,p){return pad(d.getUTCDate(),p,2)}function formatUTCHour24(d,p){return pad(d.getUTCHours(),p,2)}function formatUTCHour12(d,p){return pad(d.getUTCHours()%12||12,p,2)}function formatUTCDayOfYear(d,p){return pad(1+d3Time.utcDay.count(d3Time.utcYear(d),d),p,3)}function formatUTCMilliseconds(d,p){return pad(d.getUTCMilliseconds(),p,3)}function formatUTCMicroseconds(d,p){return formatUTCMilliseconds(d,p)+"000"}function formatUTCMonthNumber(d,p){return pad(d.getUTCMonth()+1,p,2)}function formatUTCMinutes(d,p){return pad(d.getUTCMinutes(),p,2)}function formatUTCSeconds(d,p){return pad(d.getUTCSeconds(),p,2)}function formatUTCWeekdayNumberMonday(d){var dow=d.getUTCDay();return dow===0?7:dow}function formatUTCWeekNumberSunday(d,p){return pad(d3Time.utcSunday.count(d3Time.utcYear(d)-1,d),p,2)}function formatUTCWeekNumberISO(d,p){var day=d.getUTCDay();d=day>=4||day===0?d3Time.utcThursday(d):d3Time.utcThursday.ceil(d);return pad(d3Time.utcThursday.count(d3Time.utcYear(d),d)+(d3Time.utcYear(d).getUTCDay()===4),p,2)}function formatUTCWeekdayNumberSunday(d){return d.getUTCDay()}function formatUTCWeekNumberMonday(d,p){return pad(d3Time.utcMonday.count(d3Time.utcYear(d)-1,d),p,2)}function formatUTCYear(d,p){return pad(d.getUTCFullYear()%100,p,2)}function formatUTCFullYear(d,p){return pad(d.getUTCFullYear()%1e4,p,4)}function formatUTCZone(){return"+0000"}function formatLiteralPercent(){return"%"}function formatUnixTimestamp(d){return+d}function formatUnixTimestampSeconds(d){return Math.floor(+d/1e3)}var locale;defaultLocale({dateTime:"%x, %X",date:"%-m/%-d/%Y",time:"%-I:%M:%S %p",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});function defaultLocale(definition){locale=formatLocale(definition);exports.timeFormat=locale.format;exports.timeParse=locale.parse;exports.utcFormat=locale.utcFormat;exports.utcParse=locale.utcParse;return locale}var isoSpecifier="%Y-%m-%dT%H:%M:%S.%LZ";function formatIsoNative(date){return date.toISOString()}var formatIso=Date.prototype.toISOString?formatIsoNative:exports.utcFormat(isoSpecifier);function parseIsoNative(string){var date=new Date(string);return isNaN(date)?null:date}var parseIso=+new Date("2000-01-01T00:00:00.000Z")?parseIsoNative:exports.utcParse(isoSpecifier);exports.isoFormat=formatIso;exports.isoParse=parseIso;exports.timeFormatDefaultLocale=defaultLocale;exports.timeFormatLocale=formatLocale;Object.defineProperty(exports,"__esModule",{value:true})}))},395:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports,__webpack_require__(396)):undefined})(this,(function(exports,d3Path){"use strict";function constant(x){return function constant(){return x}}var abs=Math.abs;var atan2=Math.atan2;var cos=Math.cos;var max=Math.max;var min=Math.min;var sin=Math.sin;var sqrt=Math.sqrt;var epsilon=1e-12;var pi=Math.PI;var halfPi=pi/2;var tau=2*pi;function acos(x){return x>1?0:x<-1?pi:Math.acos(x)}function asin(x){return x>=1?halfPi:x<=-1?-halfPi:Math.asin(x)}function arcInnerRadius(d){return d.innerRadius}function arcOuterRadius(d){return d.outerRadius}function arcStartAngle(d){return d.startAngle}function arcEndAngle(d){return d.endAngle}function arcPadAngle(d){return d&&d.padAngle}function intersect(x0,y0,x1,y1,x2,y2,x3,y3){var x10=x1-x0,y10=y1-y0,x32=x3-x2,y32=y3-y2,t=y32*x10-x32*y10;if(t*t<epsilon)return;t=(x32*(y0-y2)-y32*(x0-x2))/t;return[x0+t*x10,y0+t*y10]}function cornerTangents(x0,y0,x1,y1,r1,rc,cw){var x01=x0-x1,y01=y0-y1,lo=(cw?rc:-rc)/sqrt(x01*x01+y01*y01),ox=lo*y01,oy=-lo*x01,x11=x0+ox,y11=y0+oy,x10=x1+ox,y10=y1+oy,x00=(x11+x10)/2,y00=(y11+y10)/2,dx=x10-x11,dy=y10-y11,d2=dx*dx+dy*dy,r=r1-rc,D=x11*y10-x10*y11,d=(dy<0?-1:1)*sqrt(max(0,r*r*d2-D*D)),cx0=(D*dy-dx*d)/d2,cy0=(-D*dx-dy*d)/d2,cx1=(D*dy+dx*d)/d2,cy1=(-D*dx+dy*d)/d2,dx0=cx0-x00,dy0=cy0-y00,dx1=cx1-x00,dy1=cy1-y00;if(dx0*dx0+dy0*dy0>dx1*dx1+dy1*dy1)cx0=cx1,cy0=cy1;return{cx:cx0,cy:cy0,x01:-ox,y01:-oy,x11:cx0*(r1/r-1),y11:cy0*(r1/r-1)}}function arc(){var innerRadius=arcInnerRadius,outerRadius=arcOuterRadius,cornerRadius=constant(0),padRadius=null,startAngle=arcStartAngle,endAngle=arcEndAngle,padAngle=arcPadAngle,context=null;function arc(){var buffer,r,r0=+innerRadius.apply(this,arguments),r1=+outerRadius.apply(this,arguments),a0=startAngle.apply(this,arguments)-halfPi,a1=endAngle.apply(this,arguments)-halfPi,da=abs(a1-a0),cw=a1>a0;if(!context)context=buffer=d3Path.path();if(r1<r0)r=r1,r1=r0,r0=r;if(!(r1>epsilon))context.moveTo(0,0);else if(da>tau-epsilon){context.moveTo(r1*cos(a0),r1*sin(a0));context.arc(0,0,r1,a0,a1,!cw);if(r0>epsilon){context.moveTo(r0*cos(a1),r0*sin(a1));context.arc(0,0,r0,a1,a0,cw)}}else{var a01=a0,a11=a1,a00=a0,a10=a1,da0=da,da1=da,ap=padAngle.apply(this,arguments)/2,rp=ap>epsilon&&(padRadius?+padRadius.apply(this,arguments):sqrt(r0*r0+r1*r1)),rc=min(abs(r1-r0)/2,+cornerRadius.apply(this,arguments)),rc0=rc,rc1=rc,t0,t1;if(rp>epsilon){var p0=asin(rp/r0*sin(ap)),p1=asin(rp/r1*sin(ap));if((da0-=p0*2)>epsilon)p0*=cw?1:-1,a00+=p0,a10-=p0;else da0=0,a00=a10=(a0+a1)/2;if((da1-=p1*2)>epsilon)p1*=cw?1:-1,a01+=p1,a11-=p1;else da1=0,a01=a11=(a0+a1)/2}var x01=r1*cos(a01),y01=r1*sin(a01),x10=r0*cos(a10),y10=r0*sin(a10);if(rc>epsilon){var x11=r1*cos(a11),y11=r1*sin(a11),x00=r0*cos(a00),y00=r0*sin(a00),oc;if(da<pi&&(oc=intersect(x01,y01,x00,y00,x11,y11,x10,y10))){var ax=x01-oc[0],ay=y01-oc[1],bx=x11-oc[0],by=y11-oc[1],kc=1/sin(acos((ax*bx+ay*by)/(sqrt(ax*ax+ay*ay)*sqrt(bx*bx+by*by)))/2),lc=sqrt(oc[0]*oc[0]+oc[1]*oc[1]);rc0=min(rc,(r0-lc)/(kc-1));rc1=min(rc,(r1-lc)/(kc+1))}}if(!(da1>epsilon))context.moveTo(x01,y01);else if(rc1>epsilon){t0=cornerTangents(x00,y00,x01,y01,r1,rc1,cw);t1=cornerTangents(x11,y11,x10,y10,r1,rc1,cw);context.moveTo(t0.cx+t0.x01,t0.cy+t0.y01);if(rc1<rc)context.arc(t0.cx,t0.cy,rc1,atan2(t0.y01,t0.x01),atan2(t1.y01,t1.x01),!cw);else{context.arc(t0.cx,t0.cy,rc1,atan2(t0.y01,t0.x01),atan2(t0.y11,t0.x11),!cw);context.arc(0,0,r1,atan2(t0.cy+t0.y11,t0.cx+t0.x11),atan2(t1.cy+t1.y11,t1.cx+t1.x11),!cw);context.arc(t1.cx,t1.cy,rc1,atan2(t1.y11,t1.x11),atan2(t1.y01,t1.x01),!cw)}}else context.moveTo(x01,y01),context.arc(0,0,r1,a01,a11,!cw);if(!(r0>epsilon)||!(da0>epsilon))context.lineTo(x10,y10);else if(rc0>epsilon){t0=cornerTangents(x10,y10,x11,y11,r0,-rc0,cw);t1=cornerTangents(x01,y01,x00,y00,r0,-rc0,cw);context.lineTo(t0.cx+t0.x01,t0.cy+t0.y01);if(rc0<rc)context.arc(t0.cx,t0.cy,rc0,atan2(t0.y01,t0.x01),atan2(t1.y01,t1.x01),!cw);else{context.arc(t0.cx,t0.cy,rc0,atan2(t0.y01,t0.x01),atan2(t0.y11,t0.x11),!cw);context.arc(0,0,r0,atan2(t0.cy+t0.y11,t0.cx+t0.x11),atan2(t1.cy+t1.y11,t1.cx+t1.x11),cw);context.arc(t1.cx,t1.cy,rc0,atan2(t1.y11,t1.x11),atan2(t1.y01,t1.x01),!cw)}}else context.arc(0,0,r0,a10,a00,cw)}context.closePath();if(buffer)return context=null,buffer+""||null}arc.centroid=function(){var r=(+innerRadius.apply(this,arguments)+ +outerRadius.apply(this,arguments))/2,a=(+startAngle.apply(this,arguments)+ +endAngle.apply(this,arguments))/2-pi/2;return[cos(a)*r,sin(a)*r]};arc.innerRadius=function(_){return arguments.length?(innerRadius=typeof _==="function"?_:constant(+_),arc):innerRadius};arc.outerRadius=function(_){return arguments.length?(outerRadius=typeof _==="function"?_:constant(+_),arc):outerRadius};arc.cornerRadius=function(_){return arguments.length?(cornerRadius=typeof _==="function"?_:constant(+_),arc):cornerRadius};arc.padRadius=function(_){return arguments.length?(padRadius=_==null?null:typeof _==="function"?_:constant(+_),arc):padRadius};arc.startAngle=function(_){return arguments.length?(startAngle=typeof _==="function"?_:constant(+_),arc):startAngle};arc.endAngle=function(_){return arguments.length?(endAngle=typeof _==="function"?_:constant(+_),arc):endAngle};arc.padAngle=function(_){return arguments.length?(padAngle=typeof _==="function"?_:constant(+_),arc):padAngle};arc.context=function(_){return arguments.length?(context=_==null?null:_,arc):context};return arc}function Linear(context){this._context=context}Linear.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:this._context.lineTo(x,y);break}}};function curveLinear(context){return new Linear(context)}function x(p){return p[0]}function y(p){return p[1]}function line(){var x$1=x,y$1=y,defined=constant(true),context=null,curve=curveLinear,output=null;function line(data){var i,n=data.length,d,defined0=false,buffer;if(context==null)output=curve(buffer=d3Path.path());for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0)output.lineStart();else output.lineEnd()}if(defined0)output.point(+x$1(d,i,data),+y$1(d,i,data))}if(buffer)return output=null,buffer+""||null}line.x=function(_){return arguments.length?(x$1=typeof _==="function"?_:constant(+_),line):x$1};line.y=function(_){return arguments.length?(y$1=typeof _==="function"?_:constant(+_),line):y$1};line.defined=function(_){return arguments.length?(defined=typeof _==="function"?_:constant(!!_),line):defined};line.curve=function(_){return arguments.length?(curve=_,context!=null&&(output=curve(context)),line):curve};line.context=function(_){return arguments.length?(_==null?context=output=null:output=curve(context=_),line):context};return line}function area(){var x0=x,x1=null,y0=constant(0),y1=y,defined=constant(true),context=null,curve=curveLinear,output=null;function area(data){var i,j,k,n=data.length,d,defined0=false,buffer,x0z=new Array(n),y0z=new Array(n);if(context==null)output=curve(buffer=d3Path.path());for(i=0;i<=n;++i){if(!(i<n&&defined(d=data[i],i,data))===defined0){if(defined0=!defined0){j=i;output.areaStart();output.lineStart()}else{output.lineEnd();output.lineStart();for(k=i-1;k>=j;--k){output.point(x0z[k],y0z[k])}output.lineEnd();output.areaEnd()}}if(defined0){x0z[i]=+x0(d,i,data),y0z[i]=+y0(d,i,data);output.point(x1?+x1(d,i,data):x0z[i],y1?+y1(d,i,data):y0z[i])}}if(buffer)return output=null,buffer+""||null}function arealine(){return line().defined(defined).curve(curve).context(context)}area.x=function(_){return arguments.length?(x0=typeof _==="function"?_:constant(+_),x1=null,area):x0};area.x0=function(_){return arguments.length?(x0=typeof _==="function"?_:constant(+_),area):x0};area.x1=function(_){return arguments.length?(x1=_==null?null:typeof _==="function"?_:constant(+_),area):x1};area.y=function(_){return arguments.length?(y0=typeof _==="function"?_:constant(+_),y1=null,area):y0};area.y0=function(_){return arguments.length?(y0=typeof _==="function"?_:constant(+_),area):y0};area.y1=function(_){return arguments.length?(y1=_==null?null:typeof _==="function"?_:constant(+_),area):y1};area.lineX0=area.lineY0=function(){return arealine().x(x0).y(y0)};area.lineY1=function(){return arealine().x(x0).y(y1)};area.lineX1=function(){return arealine().x(x1).y(y0)};area.defined=function(_){return arguments.length?(defined=typeof _==="function"?_:constant(!!_),area):defined};area.curve=function(_){return arguments.length?(curve=_,context!=null&&(output=curve(context)),area):curve};area.context=function(_){return arguments.length?(_==null?context=output=null:output=curve(context=_),area):context};return area}function descending(a,b){return b<a?-1:b>a?1:b>=a?0:NaN}function identity(d){return d}function pie(){var value=identity,sortValues=descending,sort=null,startAngle=constant(0),endAngle=constant(tau),padAngle=constant(0);function pie(data){var i,n=data.length,j,k,sum=0,index=new Array(n),arcs=new Array(n),a0=+startAngle.apply(this,arguments),da=Math.min(tau,Math.max(-tau,endAngle.apply(this,arguments)-a0)),a1,p=Math.min(Math.abs(da)/n,padAngle.apply(this,arguments)),pa=p*(da<0?-1:1),v;for(i=0;i<n;++i){if((v=arcs[index[i]=i]=+value(data[i],i,data))>0){sum+=v}}if(sortValues!=null)index.sort((function(i,j){return sortValues(arcs[i],arcs[j])}));else if(sort!=null)index.sort((function(i,j){return sort(data[i],data[j])}));for(i=0,k=sum?(da-n*pa)/sum:0;i<n;++i,a0=a1){j=index[i],v=arcs[j],a1=a0+(v>0?v*k:0)+pa,arcs[j]={data:data[j],index:i,value:v,startAngle:a0,endAngle:a1,padAngle:p}}return arcs}pie.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(+_),pie):value};pie.sortValues=function(_){return arguments.length?(sortValues=_,sort=null,pie):sortValues};pie.sort=function(_){return arguments.length?(sort=_,sortValues=null,pie):sort};pie.startAngle=function(_){return arguments.length?(startAngle=typeof _==="function"?_:constant(+_),pie):startAngle};pie.endAngle=function(_){return arguments.length?(endAngle=typeof _==="function"?_:constant(+_),pie):endAngle};pie.padAngle=function(_){return arguments.length?(padAngle=typeof _==="function"?_:constant(+_),pie):padAngle};return pie}var curveRadialLinear=curveRadial(curveLinear);function Radial(curve){this._curve=curve}Radial.prototype={areaStart:function(){this._curve.areaStart()},areaEnd:function(){this._curve.areaEnd()},lineStart:function(){this._curve.lineStart()},lineEnd:function(){this._curve.lineEnd()},point:function(a,r){this._curve.point(r*Math.sin(a),r*-Math.cos(a))}};function curveRadial(curve){function radial(context){return new Radial(curve(context))}radial._curve=curve;return radial}function lineRadial(l){var c=l.curve;l.angle=l.x,delete l.x;l.radius=l.y,delete l.y;l.curve=function(_){return arguments.length?c(curveRadial(_)):c()._curve};return l}function lineRadial$1(){return lineRadial(line().curve(curveRadialLinear))}function areaRadial(){var a=area().curve(curveRadialLinear),c=a.curve,x0=a.lineX0,x1=a.lineX1,y0=a.lineY0,y1=a.lineY1;a.angle=a.x,delete a.x;a.startAngle=a.x0,delete a.x0;a.endAngle=a.x1,delete a.x1;a.radius=a.y,delete a.y;a.innerRadius=a.y0,delete a.y0;a.outerRadius=a.y1,delete a.y1;a.lineStartAngle=function(){return lineRadial(x0())},delete a.lineX0;a.lineEndAngle=function(){return lineRadial(x1())},delete a.lineX1;a.lineInnerRadius=function(){return lineRadial(y0())},delete a.lineY0;a.lineOuterRadius=function(){return lineRadial(y1())},delete a.lineY1;a.curve=function(_){return arguments.length?c(curveRadial(_)):c()._curve};return a}function pointRadial(x,y){return[(y=+y)*Math.cos(x-=Math.PI/2),y*Math.sin(x)]}var slice=Array.prototype.slice;function linkSource(d){return d.source}function linkTarget(d){return d.target}function link(curve){var source=linkSource,target=linkTarget,x$1=x,y$1=y,context=null;function link(){var buffer,argv=slice.call(arguments),s=source.apply(this,argv),t=target.apply(this,argv);if(!context)context=buffer=d3Path.path();curve(context,+x$1.apply(this,(argv[0]=s,argv)),+y$1.apply(this,argv),+x$1.apply(this,(argv[0]=t,argv)),+y$1.apply(this,argv));if(buffer)return context=null,buffer+""||null}link.source=function(_){return arguments.length?(source=_,link):source};link.target=function(_){return arguments.length?(target=_,link):target};link.x=function(_){return arguments.length?(x$1=typeof _==="function"?_:constant(+_),link):x$1};link.y=function(_){return arguments.length?(y$1=typeof _==="function"?_:constant(+_),link):y$1};link.context=function(_){return arguments.length?(context=_==null?null:_,link):context};return link}function curveHorizontal(context,x0,y0,x1,y1){context.moveTo(x0,y0);context.bezierCurveTo(x0=(x0+x1)/2,y0,x0,y1,x1,y1)}function curveVertical(context,x0,y0,x1,y1){context.moveTo(x0,y0);context.bezierCurveTo(x0,y0=(y0+y1)/2,x1,y0,x1,y1)}function curveRadial$1(context,x0,y0,x1,y1){var p0=pointRadial(x0,y0),p1=pointRadial(x0,y0=(y0+y1)/2),p2=pointRadial(x1,y0),p3=pointRadial(x1,y1);context.moveTo(p0[0],p0[1]);context.bezierCurveTo(p1[0],p1[1],p2[0],p2[1],p3[0],p3[1])}function linkHorizontal(){return link(curveHorizontal)}function linkVertical(){return link(curveVertical)}function linkRadial(){var l=link(curveRadial$1);l.angle=l.x,delete l.x;l.radius=l.y,delete l.y;return l}var circle={draw:function(context,size){var r=Math.sqrt(size/pi);context.moveTo(r,0);context.arc(0,0,r,0,tau)}};var cross={draw:function(context,size){var r=Math.sqrt(size/5)/2;context.moveTo(-3*r,-r);context.lineTo(-r,-r);context.lineTo(-r,-3*r);context.lineTo(r,-3*r);context.lineTo(r,-r);context.lineTo(3*r,-r);context.lineTo(3*r,r);context.lineTo(r,r);context.lineTo(r,3*r);context.lineTo(-r,3*r);context.lineTo(-r,r);context.lineTo(-3*r,r);context.closePath()}};var tan30=Math.sqrt(1/3),tan30_2=tan30*2;var diamond={draw:function(context,size){var y=Math.sqrt(size/tan30_2),x=y*tan30;context.moveTo(0,-y);context.lineTo(x,0);context.lineTo(0,y);context.lineTo(-x,0);context.closePath()}};var ka=.8908130915292852,kr=Math.sin(pi/10)/Math.sin(7*pi/10),kx=Math.sin(tau/10)*kr,ky=-Math.cos(tau/10)*kr;var star={draw:function(context,size){var r=Math.sqrt(size*ka),x=kx*r,y=ky*r;context.moveTo(0,-r);context.lineTo(x,y);for(var i=1;i<5;++i){var a=tau*i/5,c=Math.cos(a),s=Math.sin(a);context.lineTo(s*r,-c*r);context.lineTo(c*x-s*y,s*x+c*y)}context.closePath()}};var square={draw:function(context,size){var w=Math.sqrt(size),x=-w/2;context.rect(x,x,w,w)}};var sqrt3=Math.sqrt(3);var triangle={draw:function(context,size){var y=-Math.sqrt(size/(sqrt3*3));context.moveTo(0,y*2);context.lineTo(-sqrt3*y,-y);context.lineTo(sqrt3*y,-y);context.closePath()}};var c=-.5,s=Math.sqrt(3)/2,k=1/Math.sqrt(12),a=(k/2+1)*3;var wye={draw:function(context,size){var r=Math.sqrt(size/a),x0=r/2,y0=r*k,x1=x0,y1=r*k+r,x2=-x1,y2=y1;context.moveTo(x0,y0);context.lineTo(x1,y1);context.lineTo(x2,y2);context.lineTo(c*x0-s*y0,s*x0+c*y0);context.lineTo(c*x1-s*y1,s*x1+c*y1);context.lineTo(c*x2-s*y2,s*x2+c*y2);context.lineTo(c*x0+s*y0,c*y0-s*x0);context.lineTo(c*x1+s*y1,c*y1-s*x1);context.lineTo(c*x2+s*y2,c*y2-s*x2);context.closePath()}};var symbols=[circle,cross,diamond,square,star,triangle,wye];function symbol(){var type=constant(circle),size=constant(64),context=null;function symbol(){var buffer;if(!context)context=buffer=d3Path.path();type.apply(this,arguments).draw(context,+size.apply(this,arguments));if(buffer)return context=null,buffer+""||null}symbol.type=function(_){return arguments.length?(type=typeof _==="function"?_:constant(_),symbol):type};symbol.size=function(_){return arguments.length?(size=typeof _==="function"?_:constant(+_),symbol):size};symbol.context=function(_){return arguments.length?(context=_==null?null:_,symbol):context};return symbol}function noop(){}function point(that,x,y){that._context.bezierCurveTo((2*that._x0+that._x1)/3,(2*that._y0+that._y1)/3,(that._x0+2*that._x1)/3,(that._y0+2*that._y1)/3,(that._x0+4*that._x1+x)/6,(that._y0+4*that._y1+y)/6)}function Basis(context){this._context=context}Basis.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN;this._point=0},lineEnd:function(){switch(this._point){case 3:point(this,this._x1,this._y1);case 2:this._context.lineTo(this._x1,this._y1);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;this._context.lineTo((5*this._x0+this._x1)/6,(5*this._y0+this._y1)/6);default:point(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function basis(context){return new Basis(context)}function BasisClosed(context){this._context=context}BasisClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._y0=this._y1=this._y2=this._y3=this._y4=NaN;this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x2,this._y2);this._context.closePath();break}case 2:{this._context.moveTo((this._x2+2*this._x3)/3,(this._y2+2*this._y3)/3);this._context.lineTo((this._x3+2*this._x2)/3,(this._y3+2*this._y2)/3);this._context.closePath();break}case 3:{this.point(this._x2,this._y2);this.point(this._x3,this._y3);this.point(this._x4,this._y4);break}}},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._x2=x,this._y2=y;break;case 1:this._point=2;this._x3=x,this._y3=y;break;case 2:this._point=3;this._x4=x,this._y4=y;this._context.moveTo((this._x0+4*this._x1+x)/6,(this._y0+4*this._y1+y)/6);break;default:point(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function basisClosed(context){return new BasisClosed(context)}function BasisOpen(context){this._context=context}BasisOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=NaN;this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;var x0=(this._x0+4*this._x1+x)/6,y0=(this._y0+4*this._y1+y)/6;this._line?this._context.lineTo(x0,y0):this._context.moveTo(x0,y0);break;case 3:this._point=4;default:point(this,x,y);break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y}};function basisOpen(context){return new BasisOpen(context)}function Bundle(context,beta){this._basis=new Basis(context);this._beta=beta}Bundle.prototype={lineStart:function(){this._x=[];this._y=[];this._basis.lineStart()},lineEnd:function(){var x=this._x,y=this._y,j=x.length-1;if(j>0){var x0=x[0],y0=y[0],dx=x[j]-x0,dy=y[j]-y0,i=-1,t;while(++i<=j){t=i/j;this._basis.point(this._beta*x[i]+(1-this._beta)*(x0+t*dx),this._beta*y[i]+(1-this._beta)*(y0+t*dy))}}this._x=this._y=null;this._basis.lineEnd()},point:function(x,y){this._x.push(+x);this._y.push(+y)}};var bundle=function custom(beta){function bundle(context){return beta===1?new Basis(context):new Bundle(context,beta)}bundle.beta=function(beta){return custom(+beta)};return bundle}(.85);function point$1(that,x,y){that._context.bezierCurveTo(that._x1+that._k*(that._x2-that._x0),that._y1+that._k*(that._y2-that._y0),that._x2+that._k*(that._x1-x),that._y2+that._k*(that._y1-y),that._x2,that._y2)}function Cardinal(context,tension){this._context=context;this._k=(1-tension)/6}Cardinal.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:point$1(this,this._x1,this._y1);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;this._x1=x,this._y1=y;break;case 2:this._point=3;default:point$1(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinal=function custom(tension){function cardinal(context){return new Cardinal(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function CardinalClosed(context,tension){this._context=context;this._k=(1-tension)/6}CardinalClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN;this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x3,this._y3);this._context.closePath();break}case 2:{this._context.lineTo(this._x3,this._y3);this._context.closePath();break}case 3:{this.point(this._x3,this._y3);this.point(this._x4,this._y4);this.point(this._x5,this._y5);break}}},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._x3=x,this._y3=y;break;case 1:this._point=2;this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3;this._x5=x,this._y5=y;break;default:point$1(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinalClosed=function custom(tension){function cardinal(context){return new CardinalClosed(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function CardinalOpen(context,tension){this._context=context;this._k=(1-tension)/6}CardinalOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$1(this,x,y);break}this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var cardinalOpen=function custom(tension){function cardinal(context){return new CardinalOpen(context,tension)}cardinal.tension=function(tension){return custom(+tension)};return cardinal}(0);function point$2(that,x,y){var x1=that._x1,y1=that._y1,x2=that._x2,y2=that._y2;if(that._l01_a>epsilon){var a=2*that._l01_2a+3*that._l01_a*that._l12_a+that._l12_2a,n=3*that._l01_a*(that._l01_a+that._l12_a);x1=(x1*a-that._x0*that._l12_2a+that._x2*that._l01_2a)/n;y1=(y1*a-that._y0*that._l12_2a+that._y2*that._l01_2a)/n}if(that._l23_a>epsilon){var b=2*that._l23_2a+3*that._l23_a*that._l12_a+that._l12_2a,m=3*that._l23_a*(that._l23_a+that._l12_a);x2=(x2*b+that._x1*that._l23_2a-x*that._l12_2a)/m;y2=(y2*b+that._y1*that._l23_2a-y*that._l12_2a)/m}that._context.bezierCurveTo(x1,y1,x2,y2,that._x2,that._y2)}function CatmullRom(context,alpha){this._context=context;this._alpha=alpha}CatmullRom.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x2,this._y2);break;case 3:this.point(this._x2,this._y2);break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRom=function custom(alpha){function catmullRom(context){return alpha?new CatmullRom(context,alpha):new Cardinal(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function CatmullRomClosed(context,alpha){this._context=context;this._alpha=alpha}CatmullRomClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._x0=this._x1=this._x2=this._x3=this._x4=this._x5=this._y0=this._y1=this._y2=this._y3=this._y4=this._y5=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){switch(this._point){case 1:{this._context.moveTo(this._x3,this._y3);this._context.closePath();break}case 2:{this._context.lineTo(this._x3,this._y3);this._context.closePath();break}case 3:{this.point(this._x3,this._y3);this.point(this._x4,this._y4);this.point(this._x5,this._y5);break}}},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;this._x3=x,this._y3=y;break;case 1:this._point=2;this._context.moveTo(this._x4=x,this._y4=y);break;case 2:this._point=3;this._x5=x,this._y5=y;break;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRomClosed=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomClosed(context,alpha):new CardinalClosed(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function CatmullRomOpen(context,alpha){this._context=context;this._alpha=alpha}CatmullRomOpen.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._x2=this._y0=this._y1=this._y2=NaN;this._l01_a=this._l12_a=this._l23_a=this._l01_2a=this._l12_2a=this._l23_2a=this._point=0},lineEnd:function(){if(this._line||this._line!==0&&this._point===3)this._context.closePath();this._line=1-this._line},point:function(x,y){x=+x,y=+y;if(this._point){var x23=this._x2-x,y23=this._y2-y;this._l23_a=Math.sqrt(this._l23_2a=Math.pow(x23*x23+y23*y23,this._alpha))}switch(this._point){case 0:this._point=1;break;case 1:this._point=2;break;case 2:this._point=3;this._line?this._context.lineTo(this._x2,this._y2):this._context.moveTo(this._x2,this._y2);break;case 3:this._point=4;default:point$2(this,x,y);break}this._l01_a=this._l12_a,this._l12_a=this._l23_a;this._l01_2a=this._l12_2a,this._l12_2a=this._l23_2a;this._x0=this._x1,this._x1=this._x2,this._x2=x;this._y0=this._y1,this._y1=this._y2,this._y2=y}};var catmullRomOpen=function custom(alpha){function catmullRom(context){return alpha?new CatmullRomOpen(context,alpha):new CardinalOpen(context,0)}catmullRom.alpha=function(alpha){return custom(+alpha)};return catmullRom}(.5);function LinearClosed(context){this._context=context}LinearClosed.prototype={areaStart:noop,areaEnd:noop,lineStart:function(){this._point=0},lineEnd:function(){if(this._point)this._context.closePath()},point:function(x,y){x=+x,y=+y;if(this._point)this._context.lineTo(x,y);else this._point=1,this._context.moveTo(x,y)}};function linearClosed(context){return new LinearClosed(context)}function sign(x){return x<0?-1:1}function slope3(that,x2,y2){var h0=that._x1-that._x0,h1=x2-that._x1,s0=(that._y1-that._y0)/(h0||h1<0&&-0),s1=(y2-that._y1)/(h1||h0<0&&-0),p=(s0*h1+s1*h0)/(h0+h1);return(sign(s0)+sign(s1))*Math.min(Math.abs(s0),Math.abs(s1),.5*Math.abs(p))||0}function slope2(that,t){var h=that._x1-that._x0;return h?(3*(that._y1-that._y0)/h-t)/2:t}function point$3(that,t0,t1){var x0=that._x0,y0=that._y0,x1=that._x1,y1=that._y1,dx=(x1-x0)/3;that._context.bezierCurveTo(x0+dx,y0+dx*t0,x1-dx,y1-dx*t1,x1,y1)}function MonotoneX(context){this._context=context}MonotoneX.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x0=this._x1=this._y0=this._y1=this._t0=NaN;this._point=0},lineEnd:function(){switch(this._point){case 2:this._context.lineTo(this._x1,this._y1);break;case 3:point$3(this,this._t0,slope2(this,this._t0));break}if(this._line||this._line!==0&&this._point===1)this._context.closePath();this._line=1-this._line},point:function(x,y){var t1=NaN;x=+x,y=+y;if(x===this._x1&&y===this._y1)return;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;break;case 2:this._point=3;point$3(this,slope2(this,t1=slope3(this,x,y)),t1);break;default:point$3(this,this._t0,t1=slope3(this,x,y));break}this._x0=this._x1,this._x1=x;this._y0=this._y1,this._y1=y;this._t0=t1}};function MonotoneY(context){this._context=new ReflectContext(context)}(MonotoneY.prototype=Object.create(MonotoneX.prototype)).point=function(x,y){MonotoneX.prototype.point.call(this,y,x)};function ReflectContext(context){this._context=context}ReflectContext.prototype={moveTo:function(x,y){this._context.moveTo(y,x)},closePath:function(){this._context.closePath()},lineTo:function(x,y){this._context.lineTo(y,x)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._context.bezierCurveTo(y1,x1,y2,x2,y,x)}};function monotoneX(context){return new MonotoneX(context)}function monotoneY(context){return new MonotoneY(context)}function Natural(context){this._context=context}Natural.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=[];this._y=[]},lineEnd:function(){var x=this._x,y=this._y,n=x.length;if(n){this._line?this._context.lineTo(x[0],y[0]):this._context.moveTo(x[0],y[0]);if(n===2){this._context.lineTo(x[1],y[1])}else{var px=controlPoints(x),py=controlPoints(y);for(var i0=0,i1=1;i1<n;++i0,++i1){this._context.bezierCurveTo(px[0][i0],py[0][i0],px[1][i0],py[1][i0],x[i1],y[i1])}}}if(this._line||this._line!==0&&n===1)this._context.closePath();this._line=1-this._line;this._x=this._y=null},point:function(x,y){this._x.push(+x);this._y.push(+y)}};function controlPoints(x){var i,n=x.length-1,m,a=new Array(n),b=new Array(n),r=new Array(n);a[0]=0,b[0]=2,r[0]=x[0]+2*x[1];for(i=1;i<n-1;++i)a[i]=1,b[i]=4,r[i]=4*x[i]+2*x[i+1];a[n-1]=2,b[n-1]=7,r[n-1]=8*x[n-1]+x[n];for(i=1;i<n;++i)m=a[i]/b[i-1],b[i]-=m,r[i]-=m*r[i-1];a[n-1]=r[n-1]/b[n-1];for(i=n-2;i>=0;--i)a[i]=(r[i]-a[i+1])/b[i];b[n-1]=(x[n]+a[n-1])/2;for(i=0;i<n-1;++i)b[i]=2*x[i+1]-a[i+1];return[a,b]}function natural(context){return new Natural(context)}function Step(context,t){this._context=context;this._t=t}Step.prototype={areaStart:function(){this._line=0},areaEnd:function(){this._line=NaN},lineStart:function(){this._x=this._y=NaN;this._point=0},lineEnd:function(){if(0<this._t&&this._t<1&&this._point===2)this._context.lineTo(this._x,this._y);if(this._line||this._line!==0&&this._point===1)this._context.closePath();if(this._line>=0)this._t=1-this._t,this._line=1-this._line},point:function(x,y){x=+x,y=+y;switch(this._point){case 0:this._point=1;this._line?this._context.lineTo(x,y):this._context.moveTo(x,y);break;case 1:this._point=2;default:{if(this._t<=0){this._context.lineTo(this._x,y);this._context.lineTo(x,y)}else{var x1=this._x*(1-this._t)+x*this._t;this._context.lineTo(x1,this._y);this._context.lineTo(x1,y)}break}}this._x=x,this._y=y}};function step(context){return new Step(context,.5)}function stepBefore(context){return new Step(context,0)}function stepAfter(context){return new Step(context,1)}function none(series,order){if(!((n=series.length)>1))return;for(var i=1,j,s0,s1=series[order[0]],n,m=s1.length;i<n;++i){s0=s1,s1=series[order[i]];for(j=0;j<m;++j){s1[j][1]+=s1[j][0]=isNaN(s0[j][1])?s0[j][0]:s0[j][1]}}}function none$1(series){var n=series.length,o=new Array(n);while(--n>=0)o[n]=n;return o}function stackValue(d,key){return d[key]}function stack(){var keys=constant([]),order=none$1,offset=none,value=stackValue;function stack(data){var kz=keys.apply(this,arguments),i,m=data.length,n=kz.length,sz=new Array(n),oz;for(i=0;i<n;++i){for(var ki=kz[i],si=sz[i]=new Array(m),j=0,sij;j<m;++j){si[j]=sij=[0,+value(data[j],ki,j,data)];sij.data=data[j]}si.key=ki}for(i=0,oz=order(sz);i<n;++i){sz[oz[i]].index=i}offset(sz,oz);return sz}stack.keys=function(_){return arguments.length?(keys=typeof _==="function"?_:constant(slice.call(_)),stack):keys};stack.value=function(_){return arguments.length?(value=typeof _==="function"?_:constant(+_),stack):value};stack.order=function(_){return arguments.length?(order=_==null?none$1:typeof _==="function"?_:constant(slice.call(_)),stack):order};stack.offset=function(_){return arguments.length?(offset=_==null?none:_,stack):offset};return stack}function expand(series,order){if(!((n=series.length)>0))return;for(var i,n,j=0,m=series[0].length,y;j<m;++j){for(y=i=0;i<n;++i)y+=series[i][j][1]||0;if(y)for(i=0;i<n;++i)series[i][j][1]/=y}none(series,order)}function diverging(series,order){if(!((n=series.length)>0))return;for(var i,j=0,d,dy,yp,yn,n,m=series[order[0]].length;j<m;++j){for(yp=yn=0,i=0;i<n;++i){if((dy=(d=series[order[i]][j])[1]-d[0])>0){d[0]=yp,d[1]=yp+=dy}else if(dy<0){d[1]=yn,d[0]=yn+=dy}else{d[0]=0,d[1]=dy}}}}function silhouette(series,order){if(!((n=series.length)>0))return;for(var j=0,s0=series[order[0]],n,m=s0.length;j<m;++j){for(var i=0,y=0;i<n;++i)y+=series[i][j][1]||0;s0[j][1]+=s0[j][0]=-y/2}none(series,order)}function wiggle(series,order){if(!((n=series.length)>0)||!((m=(s0=series[order[0]]).length)>0))return;for(var y=0,j=1,s0,m,n;j<m;++j){for(var i=0,s1=0,s2=0;i<n;++i){var si=series[order[i]],sij0=si[j][1]||0,sij1=si[j-1][1]||0,s3=(sij0-sij1)/2;for(var k=0;k<i;++k){var sk=series[order[k]],skj0=sk[j][1]||0,skj1=sk[j-1][1]||0;s3+=skj0-skj1}s1+=sij0,s2+=s3*sij0}s0[j-1][1]+=s0[j-1][0]=y;if(s1)y-=s2/s1}s0[j-1][1]+=s0[j-1][0]=y;none(series,order)}function appearance(series){var peaks=series.map(peak);return none$1(series).sort((function(a,b){return peaks[a]-peaks[b]}))}function peak(series){var i=-1,j=0,n=series.length,vi,vj=-Infinity;while(++i<n)if((vi=+series[i][1])>vj)vj=vi,j=i;return j}function ascending(series){var sums=series.map(sum);return none$1(series).sort((function(a,b){return sums[a]-sums[b]}))}function sum(series){var s=0,i=-1,n=series.length,v;while(++i<n)if(v=+series[i][1])s+=v;return s}function descending$1(series){return ascending(series).reverse()}function insideOut(series){var n=series.length,i,j,sums=series.map(sum),order=appearance(series),top=0,bottom=0,tops=[],bottoms=[];for(i=0;i<n;++i){j=order[i];if(top<bottom){top+=sums[j];tops.push(j)}else{bottom+=sums[j];bottoms.push(j)}}return bottoms.reverse().concat(tops)}function reverse(series){return none$1(series).reverse()}exports.arc=arc;exports.area=area;exports.areaRadial=areaRadial;exports.curveBasis=basis;exports.curveBasisClosed=basisClosed;exports.curveBasisOpen=basisOpen;exports.curveBundle=bundle;exports.curveCardinal=cardinal;exports.curveCardinalClosed=cardinalClosed;exports.curveCardinalOpen=cardinalOpen;exports.curveCatmullRom=catmullRom;exports.curveCatmullRomClosed=catmullRomClosed;exports.curveCatmullRomOpen=catmullRomOpen;exports.curveLinear=curveLinear;exports.curveLinearClosed=linearClosed;exports.curveMonotoneX=monotoneX;exports.curveMonotoneY=monotoneY;exports.curveNatural=natural;exports.curveStep=step;exports.curveStepAfter=stepAfter;exports.curveStepBefore=stepBefore;exports.line=line;exports.lineRadial=lineRadial$1;exports.linkHorizontal=linkHorizontal;exports.linkRadial=linkRadial;exports.linkVertical=linkVertical;exports.pie=pie;exports.pointRadial=pointRadial;exports.radialArea=areaRadial;exports.radialLine=lineRadial$1;exports.stack=stack;exports.stackOffsetDiverging=diverging;exports.stackOffsetExpand=expand;exports.stackOffsetNone=none;exports.stackOffsetSilhouette=silhouette;exports.stackOffsetWiggle=wiggle;exports.stackOrderAppearance=appearance;exports.stackOrderAscending=ascending;exports.stackOrderDescending=descending$1;exports.stackOrderInsideOut=insideOut;exports.stackOrderNone=none$1;exports.stackOrderReverse=reverse;exports.symbol=symbol;exports.symbolCircle=circle;exports.symbolCross=cross;exports.symbolDiamond=diamond;exports.symbolSquare=square;exports.symbolStar=star;exports.symbolTriangle=triangle;exports.symbolWye=wye;exports.symbols=symbols;Object.defineProperty(exports,"__esModule",{value:true})}))},396:function(module,exports,__webpack_require__){(function(global,factory){true?factory(exports):undefined})(this,(function(exports){"use strict";var pi=Math.PI,tau=2*pi,epsilon=1e-6,tauEpsilon=tau-epsilon;function Path(){this._x0=this._y0=this._x1=this._y1=null;this._=""}function path(){return new Path}Path.prototype=path.prototype={constructor:Path,moveTo:function(x,y){this._+="M"+(this._x0=this._x1=+x)+","+(this._y0=this._y1=+y)},closePath:function(){if(this._x1!==null){this._x1=this._x0,this._y1=this._y0;this._+="Z"}},lineTo:function(x,y){this._+="L"+(this._x1=+x)+","+(this._y1=+y)},quadraticCurveTo:function(x1,y1,x,y){this._+="Q"+ +x1+","+ +y1+","+(this._x1=+x)+","+(this._y1=+y)},bezierCurveTo:function(x1,y1,x2,y2,x,y){this._+="C"+ +x1+","+ +y1+","+ +x2+","+ +y2+","+(this._x1=+x)+","+(this._y1=+y)},arcTo:function(x1,y1,x2,y2,r){x1=+x1,y1=+y1,x2=+x2,y2=+y2,r=+r;var x0=this._x1,y0=this._y1,x21=x2-x1,y21=y2-y1,x01=x0-x1,y01=y0-y1,l01_2=x01*x01+y01*y01;if(r<0)throw new Error("negative radius: "+r);if(this._x1===null){this._+="M"+(this._x1=x1)+","+(this._y1=y1)}else if(!(l01_2>epsilon));else if(!(Math.abs(y01*x21-y21*x01)>epsilon)||!r){this._+="L"+(this._x1=x1)+","+(this._y1=y1)}else{var x20=x2-x0,y20=y2-y0,l21_2=x21*x21+y21*y21,l20_2=x20*x20+y20*y20,l21=Math.sqrt(l21_2),l01=Math.sqrt(l01_2),l=r*Math.tan((pi-Math.acos((l21_2+l01_2-l20_2)/(2*l21*l01)))/2),t01=l/l01,t21=l/l21;if(Math.abs(t01-1)>epsilon){this._+="L"+(x1+t01*x01)+","+(y1+t01*y01)}this._+="A"+r+","+r+",0,0,"+ +(y01*x20>x01*y20)+","+(this._x1=x1+t21*x21)+","+(this._y1=y1+t21*y21)}},arc:function(x,y,r,a0,a1,ccw){x=+x,y=+y,r=+r,ccw=!!ccw;var dx=r*Math.cos(a0),dy=r*Math.sin(a0),x0=x+dx,y0=y+dy,cw=1^ccw,da=ccw?a0-a1:a1-a0;if(r<0)throw new Error("negative radius: "+r);if(this._x1===null){this._+="M"+x0+","+y0}else if(Math.abs(this._x1-x0)>epsilon||Math.abs(this._y1-y0)>epsilon){this._+="L"+x0+","+y0}if(!r)return;if(da<0)da=da%tau+tau;if(da>tauEpsilon){this._+="A"+r+","+r+",0,1,"+cw+","+(x-dx)+","+(y-dy)+"A"+r+","+r+",0,1,"+cw+","+(this._x1=x0)+","+(this._y1=y0)}else if(da>epsilon){this._+="A"+r+","+r+",0,"+ +(da>=pi)+","+cw+","+(this._x1=x+r*Math.cos(a1))+","+(this._y1=y+r*Math.sin(a1))}},rect:function(x,y,w,h){this._+="M"+(this._x0=this._x1=+x)+","+(this._y0=this._y1=+y)+"h"+ +w+"v"+ +h+"h"+-w+"Z"},toString:function(){return this._}};exports.path=path;Object.defineProperty(exports,"__esModule",{value:true})}))},397:function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;
/*!
  Copyright (c) 2017 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/(function(){"use strict";var hasOwn={}.hasOwnProperty;function classNames(){var classes=[];for(var i=0;i<arguments.length;i++){var arg=arguments[i];if(!arg)continue;var argType=typeof arg;if(argType==="string"||argType==="number"){classes.push(arg)}else if(Array.isArray(arg)&&arg.length){var inner=classNames.apply(null,arg);if(inner){classes.push(inner)}}else if(argType==="object"){for(var key in arg){if(hasOwn.call(arg,key)&&arg[key]){classes.push(key)}}}}return classes.join(" ")}if(true&&module.exports){classNames.default=classNames;module.exports=classNames}else if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return classNames}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})()},398:function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(70);var react_1=__webpack_require__(1);var useEffectOnce_1=tslib_1.__importDefault(__webpack_require__(123));var useUnmount=function(fn){var fnRef=react_1.useRef(fn);fnRef.current=fn;useEffectOnce_1.default((function(){return function(){return fnRef.current()}}))};exports.default=useUnmount},490:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_kbnSharedDeps_React_=__webpack_require__(1);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(18);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(67);var public_=__webpack_require__(33);var public_0=__webpack_require__(219);var _404=__webpack_require__(220);var link_to_logs=__webpack_require__(214);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var useMount=__webpack_require__(102);var useMount_default=__webpack_require__.n(useMount);var log_threshold=__webpack_require__(48);var kibanaReact_public_=__webpack_require__(3);var document_title=__webpack_require__(113);var header=__webpack_require__(176);var help_center_content=__webpack_require__(228);var app_navigation=__webpack_require__(229);var routed_tabs=__webpack_require__(230);var components_page=__webpack_require__(96);var log_source=__webpack_require__(87);var redirect_with_query_params=__webpack_require__(231);var subscription_splash_content=__webpack_require__(216);var log_analysis=__webpack_require__(84);var loading_page=__webpack_require__(112);var log_analysis_setup=__webpack_require__(141);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(12);var lib=__webpack_require__(0);var runtime_types=__webpack_require__(13);const callJobsSummaryAPI=async(requestArgs,fetch)=>{const{spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes}=requestArgs;const response=await fetch("/api/ml/jobs/jobs_summary",{method:"POST",body:JSON.stringify(fetchJobStatusRequestPayloadRT.encode({jobIds:jobTypes.map(jobType=>Object(log_analysis["getJobId"])(spaceId,sourceId,jobType))}))});return Object(runtime_types["b"])(fetchJobStatusResponsePayloadRT)(response)};const fetchJobStatusRequestPayloadRT=lib["type"]({jobIds:lib["array"](lib["string"])});const datafeedStateRT=lib["keyof"]({started:null,stopped:null,stopping:null,"":null});const jobStateRT=lib["keyof"]({closed:null,closing:null,deleting:null,failed:null,opened:null,opening:null});const jobAnalysisConfigRT=lib["partial"]({per_partition_categorization:lib["intersection"]([lib["type"]({enabled:lib["boolean"]}),lib["partial"]({stop_on_warn:lib["boolean"]})])});const jobCategorizationStatusRT=lib["keyof"]({ok:null,warn:null});const jobModelSizeStatsRT=lib["type"]({categorization_status:jobCategorizationStatusRT,categorized_doc_count:lib["number"],dead_category_count:lib["number"],frequent_category_count:lib["number"],log_time:lib["number"],rare_category_count:lib["number"],total_category_count:lib["number"]});const jobSummaryRT=lib["intersection"]([lib["type"]({id:lib["string"],jobState:jobStateRT}),lib["partial"]({datafeedIndices:lib["array"](lib["string"]),datafeedState:datafeedStateRT,fullJob:lib["partial"]({analysis_config:jobAnalysisConfigRT,create_time:lib["number"],custom_settings:log_analysis["jobCustomSettingsRT"],finished_time:lib["number"],model_size_stats:jobModelSizeStatsRT})})]);const fetchJobStatusResponsePayloadRT=lib["array"](jobSummaryRT);const callGetMlModuleAPI=async(moduleId,fetch)=>{const response=await fetch(`/api/ml/modules/get_module/${moduleId}`,{method:"GET"});return Object(runtime_types["b"])(getMlModuleResponsePayloadRT)(response)};const jobDefinitionRT=lib["type"]({id:lib["string"],config:lib["type"]({custom_settings:log_analysis["jobCustomSettingsRT"]})});const getMlModuleResponsePayloadRT=lib["type"]({id:lib["string"],jobs:lib["array"](jobDefinitionRT)});const callSetupMlModuleAPI=async(requestArgs,fetch)=>{const{moduleId:moduleId,start:start,end:end,spaceId:spaceId,sourceId:sourceId,indexPattern:indexPattern,jobOverrides:jobOverrides=[],datafeedOverrides:datafeedOverrides=[],query:query}=requestArgs;const response=await fetch(`/api/ml/modules/setup/${moduleId}`,{method:"POST",body:JSON.stringify(setupMlModuleRequestPayloadRT.encode({start:start,end:end,indexPatternName:indexPattern,prefix:Object(log_analysis["getJobIdPrefix"])(spaceId,sourceId),startDatafeed:true,jobOverrides:jobOverrides,datafeedOverrides:datafeedOverrides,query:query}))});return Object(runtime_types["b"])(setupMlModuleResponsePayloadRT)(response)};const setupMlModuleTimeParamsRT=lib["partial"]({start:lib["number"],end:lib["number"]});const setupMlModuleJobOverridesRT=lib["type"]({job_id:lib["string"],custom_settings:log_analysis["jobCustomSettingsRT"]});const setupMlModuleDatafeedOverridesRT=lib["object"];const setupMlModuleRequestParamsRT=lib["intersection"]([lib["strict"]({indexPatternName:lib["string"],prefix:lib["string"],startDatafeed:lib["boolean"],jobOverrides:lib["array"](setupMlModuleJobOverridesRT),datafeedOverrides:lib["array"](setupMlModuleDatafeedOverridesRT)}),lib["exact"](lib["partial"]({query:lib["object"]}))]);const setupMlModuleRequestPayloadRT=lib["intersection"]([setupMlModuleTimeParamsRT,setupMlModuleRequestParamsRT]);const setupErrorRT=lib["type"]({reason:lib["string"],type:lib["string"]});const setupErrorResponseRT=lib["type"]({status:lib["number"],error:lib["intersection"]([setupErrorRT,lib["type"]({root_cause:lib["array"](setupErrorRT)})])});const datafeedSetupResponseRT=lib["intersection"]([lib["type"]({id:lib["string"],started:lib["boolean"],success:lib["boolean"]}),lib["partial"]({error:setupErrorResponseRT})]);const jobSetupResponseRT=lib["intersection"]([lib["type"]({id:lib["string"],success:lib["boolean"]}),lib["partial"]({error:setupErrorResponseRT})]);const setupMlModuleResponsePayloadRT=lib["type"]({datafeeds:lib["array"](datafeedSetupResponseRT),jobs:lib["array"](jobSetupResponseRT)});var http_api=__webpack_require__(95);const callValidateDatasetsAPI=async(requestArgs,fetch)=>{const{indices:indices,timestampField:timestampField,startTime:startTime,endTime:endTime}=requestArgs;const response=await fetch(http_api["c"],{method:"POST",body:JSON.stringify(http_api["t"].encode({data:{endTime:endTime,indices:indices,startTime:startTime,timestampField:timestampField}}))});return Object(runtime_types["b"])(http_api["u"])(response)};const callValidateIndicesAPI=async(requestArgs,fetch)=>{const{indices:indices,fields:fields}=requestArgs;const response=await fetch(http_api["d"],{method:"POST",body:JSON.stringify(http_api["w"].encode({data:{indices:indices,fields:fields}}))});return Object(runtime_types["b"])(http_api["x"])(response)};const callDeleteJobs=async(requestArgs,fetch)=>{const{spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes}=requestArgs;const deleteJobsResponse=await fetch("/api/ml/jobs/delete_jobs",{method:"POST",body:JSON.stringify(deleteJobsRequestPayloadRT.encode({jobIds:jobTypes.map(jobType=>Object(log_analysis["getJobId"])(spaceId,sourceId,jobType))}))});return Object(runtime_types["b"])(deleteJobsResponsePayloadRT)(deleteJobsResponse)};const callGetJobDeletionTasks=async fetch=>{const jobDeletionTasksResponse=await fetch("/api/ml/jobs/deleting_jobs_tasks");return Object(runtime_types["b"])(getJobDeletionTasksResponsePayloadRT)(jobDeletionTasksResponse)};const callStopDatafeeds=async(requestArgs,fetch)=>{const{spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes}=requestArgs;const stopDatafeedResponse=await fetch("/api/ml/jobs/stop_datafeeds",{method:"POST",body:JSON.stringify(stopDatafeedsRequestPayloadRT.encode({datafeedIds:jobTypes.map(jobType=>Object(log_analysis["getDatafeedId"])(spaceId,sourceId,jobType))}))});return Object(runtime_types["b"])(stopDatafeedsResponsePayloadRT)(stopDatafeedResponse)};const deleteJobsRequestPayloadRT=lib["type"]({jobIds:lib["array"](lib["string"])});const deleteJobsResponsePayloadRT=lib["record"](lib["string"],lib["type"]({deleted:lib["boolean"]}));const getJobDeletionTasksResponsePayloadRT=lib["type"]({jobIds:lib["array"](lib["string"])});const stopDatafeedsRequestPayloadRT=lib["type"]({datafeedIds:lib["array"](lib["string"])});const stopDatafeedsResponsePayloadRT=lib["record"](lib["string"],lib["type"]({stopped:lib["boolean"]}));const cleanUpJobsAndDatafeeds=async(spaceId,sourceId,jobTypes,fetch)=>{try{await callStopDatafeeds({spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes},fetch)}catch(err){var _err$res;if((err===null||err===void 0?void 0:(_err$res=err.res)===null||_err$res===void 0?void 0:_err$res.status)!==404){throw err}}return await deleteJobs(spaceId,sourceId,jobTypes,fetch)};const deleteJobs=async(spaceId,sourceId,jobTypes,fetch)=>{const deleteJobsResponse=await callDeleteJobs({spaceId:spaceId,sourceId:sourceId,jobTypes:jobTypes},fetch);await waitUntilJobsAreDeleted(spaceId,sourceId,jobTypes,fetch);return deleteJobsResponse};const waitUntilJobsAreDeleted=async(spaceId,sourceId,jobTypes,fetch)=>{const moduleJobIds=jobTypes.map(jobType=>Object(log_analysis["getJobId"])(spaceId,sourceId,jobType));while(true){const{jobIds:jobIdsBeingDeleted}=await callGetJobDeletionTasks(fetch);const needToWait=jobIdsBeingDeleted.some(jobId=>moduleJobIds.includes(jobId));if(needToWait){await timeout(1e3)}else{return true}}};const timeout=ms=>new Promise(res=>setTimeout(res,ms));const module_descriptor_moduleId="logs_ui_categories";const module_descriptor_moduleName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryCategoriesModuleName",{defaultMessage:"Categorization"});const module_descriptor_moduleDescription=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryCategoriesModuleDescription",{defaultMessage:"Use Machine Learning to automatically categorize log messages."});const getJobIds=(spaceId,sourceId)=>log_analysis["logEntryCategoriesJobTypes"].reduce((accumulatedJobIds,jobType)=>({...accumulatedJobIds,[jobType]:Object(log_analysis["getJobId"])(spaceId,sourceId,jobType)}),{});const getJobSummary=async(spaceId,sourceId,fetch)=>{const response=await callJobsSummaryAPI({spaceId:spaceId,sourceId:sourceId,jobTypes:log_analysis["logEntryCategoriesJobTypes"]},fetch);const jobIds=Object.values(getJobIds(spaceId,sourceId));return response.filter(jobSummary=>jobIds.includes(jobSummary.id))};const getModuleDefinition=async fetch=>await callGetMlModuleAPI(module_descriptor_moduleId,fetch);const module_descriptor_setUpModule=async(start,end,datasetFilter,{spaceId:spaceId,sourceId:sourceId,indices:indices,timestampField:timestampField},fetch)=>{const indexNamePattern=indices.join(",");const jobOverrides=[{job_id:"log-entry-categories-count",analysis_config:{bucket_span:`${log_analysis["bucketSpan"]}ms`},data_description:{time_field:timestampField},custom_settings:{logs_source_config:{indexPattern:indexNamePattern,timestampField:timestampField,bucketSpan:log_analysis["bucketSpan"],datasetFilter:datasetFilter}}}];const query={bool:{filter:[...datasetFilter.type==="includeSome"?[{terms:{"event.dataset":datasetFilter.datasets}}]:[],{exists:{field:"message"}}]}};return callSetupMlModuleAPI({moduleId:module_descriptor_moduleId,start:start,end:end,spaceId:spaceId,sourceId:sourceId,indexPattern:indexNamePattern,jobOverrides:jobOverrides,query:query},fetch)};const module_descriptor_cleanUpModule=async(spaceId,sourceId,fetch)=>await cleanUpJobsAndDatafeeds(spaceId,sourceId,log_analysis["logEntryCategoriesJobTypes"],fetch);const module_descriptor_validateSetupIndices=async(indices,timestampField,fetch)=>await callValidateIndicesAPI({indices:indices,fields:[{name:timestampField,validTypes:["date"]},{name:log_analysis["partitionField"],validTypes:["keyword"]},{name:log_analysis["categoriesMessageField"],validTypes:["text"]}]},fetch);const module_descriptor_validateSetupDatasets=async(indices,timestampField,startTime,endTime,fetch)=>await callValidateDatasetsAPI({indices:indices,timestampField:timestampField,startTime:startTime,endTime:endTime},fetch);const logEntryCategoriesModule={moduleId:module_descriptor_moduleId,moduleName:module_descriptor_moduleName,moduleDescription:module_descriptor_moduleDescription,jobTypes:log_analysis["logEntryCategoriesJobTypes"],bucketSpan:log_analysis["bucketSpan"],getJobIds:getJobIds,getJobSummary:getJobSummary,getModuleDefinition:getModuleDefinition,setUpModule:module_descriptor_setUpModule,cleanUpModule:module_descriptor_cleanUpModule,validateSetupDatasets:module_descriptor_validateSetupDatasets,validateSetupIndices:module_descriptor_validateSetupIndices};var constate_cjs=__webpack_require__(83);var constate_cjs_default=__webpack_require__.n(constate_cjs);var use_kibana=__webpack_require__(28);var use_tracked_promise=__webpack_require__(85);const createInitialState=({jobTypes:jobTypes})=>({jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"unknown"}),{}),jobSummaries:[],lastSetupErrorMessages:[],setupStatus:{type:"initializing"}});const createStatusReducer=jobTypes=>(state,action)=>{switch(action.type){case"startedSetup":{return{...state,jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"initializing"}),{}),setupStatus:{type:"pending"}}}case"finishedSetup":{const{datafeedSetupResults:datafeedSetupResults,jobSetupResults:jobSetupResults,jobSummaries:jobSummaries,spaceId:spaceId,sourceId:sourceId}=action;const nextJobStatus=jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:hasSuccessfullyCreatedJob(Object(log_analysis["getJobId"])(spaceId,sourceId,jobType))(jobSetupResults)&&hasSuccessfullyStartedDatafeed(Object(log_analysis["getDatafeedId"])(spaceId,sourceId,jobType))(datafeedSetupResults)?"started":"failed"}),{});const nextSetupStatus=Object.values(nextJobStatus).every(jobState=>jobState==="started")?{type:"succeeded"}:{type:"failed",reasons:[...Object.values(datafeedSetupResults).filter(hasError).map(datafeed=>{var _datafeed$error$error;return(_datafeed$error$error=datafeed.error.error)===null||_datafeed$error$error===void 0?void 0:_datafeed$error$error.reason}),...Object.values(jobSetupResults).filter(hasError).map(job=>{var _job$error$error;return(_job$error$error=job.error.error)===null||_job$error$error===void 0?void 0:_job$error$error.reason})]};return{...state,jobStatus:nextJobStatus,jobSummaries:jobSummaries,setupStatus:nextSetupStatus}}case"failedSetup":{return{...state,jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"failed"}),{}),setupStatus:{type:"failed",reasons:["unknown"]}}}case"fetchingJobStatuses":{return{...state,setupStatus:state.setupStatus.type==="unknown"?{type:"initializing"}:state.setupStatus}}case"fetchedJobStatuses":{const{payload:jobSummaries,spaceId:spaceId,sourceId:sourceId}=action;const{setupStatus:setupStatus}=state;const nextJobStatus=jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:getJobStatus(Object(log_analysis["getJobId"])(spaceId,sourceId,jobType))(jobSummaries)}),{});const nextSetupStatus=getSetupStatus(nextJobStatus)(setupStatus);return{...state,jobSummaries:jobSummaries,jobStatus:nextJobStatus,setupStatus:nextSetupStatus}}case"failedFetchingJobStatuses":{return{...state,setupStatus:{type:"unknown"},jobStatus:jobTypes.reduce((accumulatedJobStatus,jobType)=>({...accumulatedJobStatus,[jobType]:"unknown"}),{})}}case"viewedResults":{return{...state,setupStatus:{type:"skipped",newlyCreated:true}}}default:{return state}}};const hasSuccessfullyCreatedJob=jobId=>jobSetupResponses=>jobSetupResponses.filter(jobSetupResponse=>jobSetupResponse.id===jobId&&jobSetupResponse.success&&!jobSetupResponse.error).length>0;const hasSuccessfullyStartedDatafeed=datafeedId=>datafeedSetupResponses=>datafeedSetupResponses.filter(datafeedSetupResponse=>datafeedSetupResponse.id===datafeedId&&datafeedSetupResponse.success&&datafeedSetupResponse.started&&!datafeedSetupResponse.error).length>0;const getJobStatus=jobId=>jobSummaries=>jobSummaries.filter(jobSummary=>jobSummary.id===jobId).map(jobSummary=>{if(jobSummary.jobState==="failed"||jobSummary.datafeedState===""){return"failed"}else if(jobSummary.jobState==="closed"&&jobSummary.datafeedState==="stopped"&&jobSummary.fullJob&&jobSummary.fullJob.finished_time!=null){return"finished"}else if(jobSummary.jobState==="closed"||jobSummary.jobState==="closing"||jobSummary.datafeedState==="stopped"){return"stopped"}else if(jobSummary.jobState==="opening"){return"initializing"}else if(jobSummary.jobState==="opened"&&jobSummary.datafeedState==="started"){return"started"}return"unknown"})[0]||"missing";const getSetupStatus=everyJobStatus=>previousSetupStatus=>Object.entries(everyJobStatus).reduce((setupStatus,[,jobStatus])=>{if(jobStatus==="missing"){return{type:"required"}}else if(setupStatus.type==="required"||setupStatus.type==="succeeded"){return setupStatus}else if(setupStatus.type==="skipped"||Object(log_analysis["isJobStatusWithResults"])(jobStatus)){return{type:"skipped",newlyCreated:setupStatus.type==="skipped"&&setupStatus.newlyCreated}}return setupStatus},previousSetupStatus);const hasError=value=>value.error!=null;const useModuleStatus=jobTypes=>Object(external_kbnSharedDeps_React_["useReducer"])(createStatusReducer(jobTypes),{jobTypes:jobTypes},createInitialState);var observability_public_=__webpack_require__(68);const useLogAnalysisModule=({sourceConfiguration:sourceConfiguration,moduleDescriptor:moduleDescriptor})=>{const{services:services}=Object(use_kibana["b"])();const{spaceId:spaceId,sourceId:sourceId,timestampField:timestampField}=sourceConfiguration;const[moduleStatus,dispatchModuleStatus]=useModuleStatus(moduleDescriptor.jobTypes);const trackMetric=Object(observability_public_["useUiTracker"])({app:"infra_logs"});const[,fetchJobStatus]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{dispatchModuleStatus({type:"fetchingJobStatuses"});return await moduleDescriptor.getJobSummary(spaceId,sourceId,services.http.fetch)},onResolve:jobResponse=>{dispatchModuleStatus({type:"fetchedJobStatuses",payload:jobResponse,spaceId:spaceId,sourceId:sourceId})},onReject:()=>{dispatchModuleStatus({type:"failedFetchingJobStatuses"})}},[spaceId,sourceId]);const[,setUpModule]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async(selectedIndices,start,end,datasetFilter)=>{dispatchModuleStatus({type:"startedSetup"});const setupResult=await moduleDescriptor.setUpModule(start,end,datasetFilter,{indices:selectedIndices,sourceId:sourceId,spaceId:spaceId,timestampField:timestampField},services.http.fetch);const jobSummaries=await moduleDescriptor.getJobSummary(spaceId,sourceId,services.http.fetch);return{setupResult:setupResult,jobSummaries:jobSummaries}},onResolve:({setupResult:{datafeeds:datafeeds,jobs:jobs},jobSummaries:jobSummaries})=>{if([...datafeeds,...jobs].reduce((acc,resource)=>[...acc,...Object.keys(resource)],[]).some(key=>key==="error")){const reasons=[...datafeeds,...jobs].filter(resource=>resource.error!==undefined).map(resource=>{var _resource$error$error,_resource$error,_resource$error$error2;return(_resource$error$error=(_resource$error=resource.error)===null||_resource$error===void 0?void 0:(_resource$error$error2=_resource$error.error)===null||_resource$error$error2===void 0?void 0:_resource$error$error2.reason)!==null&&_resource$error$error!==void 0?_resource$error$error:""});if(reasons.filter(reason=>reason.includes("because it has no mappings")).length>0){trackMetric({metric:"logs_ml_setup_error_bad_indices_or_mappings"})}else{trackMetric({metric:"logs_ml_setup_error_unknown_cause"})}}dispatchModuleStatus({type:"finishedSetup",datafeedSetupResults:datafeeds,jobSetupResults:jobs,jobSummaries:jobSummaries,spaceId:spaceId,sourceId:sourceId})},onReject:e=>{var _e$body;dispatchModuleStatus({type:"failedSetup"});if((e===null||e===void 0?void 0:(_e$body=e.body)===null||_e$body===void 0?void 0:_e$body.statusCode)===403){trackMetric({metric:"logs_ml_setup_error_lack_of_privileges"})}}},[moduleDescriptor.setUpModule,spaceId,sourceId,timestampField]);const[cleanUpModuleRequest,cleanUpModule]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>await moduleDescriptor.cleanUpModule(spaceId,sourceId,services.http.fetch)},[spaceId,sourceId]);const isCleaningUp=Object(external_kbnSharedDeps_React_["useMemo"])(()=>cleanUpModuleRequest.state==="pending",[cleanUpModuleRequest.state]);const cleanUpAndSetUpModule=Object(external_kbnSharedDeps_React_["useCallback"])((selectedIndices,start,end,datasetFilter)=>{dispatchModuleStatus({type:"startedSetup"});cleanUpModule().then(()=>{setUpModule(selectedIndices,start,end,datasetFilter)}).catch(()=>{dispatchModuleStatus({type:"failedSetup"})})},[cleanUpModule,dispatchModuleStatus,setUpModule]);const viewResults=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{dispatchModuleStatus({type:"viewedResults"})},[dispatchModuleStatus]);const jobIds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>moduleDescriptor.getJobIds(spaceId,sourceId),[moduleDescriptor,spaceId,sourceId]);return{cleanUpAndSetUpModule:cleanUpAndSetUpModule,cleanUpModule:cleanUpModule,fetchJobStatus:fetchJobStatus,isCleaningUp:isCleaningUp,jobIds:jobIds,jobStatus:moduleStatus.jobStatus,jobSummaries:moduleStatus.jobSummaries,lastSetupErrorMessages:moduleStatus.lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setUpModule:setUpModule,setupStatus:moduleStatus.setupStatus,sourceConfiguration:sourceConfiguration,viewResults:viewResults}};const useLogAnalysisModuleConfiguration=({moduleDescriptor:moduleDescriptor,sourceConfiguration:sourceConfiguration})=>{const getIsJobConfigurationOutdated=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isJobConfigurationOutdated(moduleDescriptor,sourceConfiguration),[sourceConfiguration,moduleDescriptor]);return{getIsJobConfigurationOutdated:getIsJobConfigurationOutdated}};const isJobConfigurationOutdated=({bucketSpan:bucketSpan},currentSourceConfiguration)=>jobSummary=>{if(!jobSummary.fullJob||!jobSummary.fullJob.custom_settings){return false}const jobConfiguration=jobSummary.fullJob.custom_settings.logs_source_config;return!(jobConfiguration&&jobConfiguration.bucketSpan===bucketSpan&&jobConfiguration.indexPattern&&isSubset(new Set(jobConfiguration.indexPattern.split(",")),new Set(currentSourceConfiguration.indices))&&jobConfiguration.timestampField===currentSourceConfiguration.timestampField)};const isSubset=(subset,superset)=>Array.from(subset).every(subsetElement=>superset.has(subsetElement));const useLogAnalysisModuleDefinition=({sourceConfiguration:{spaceId:spaceId,sourceId:sourceId},moduleDescriptor:moduleDescriptor})=>{const{services:services}=Object(use_kibana["b"])();const[moduleDefinition,setModuleDefinition]=Object(external_kbnSharedDeps_React_["useState"])();const jobDefinitionByJobId=Object(external_kbnSharedDeps_React_["useMemo"])(()=>moduleDefinition?moduleDefinition.jobs.reduce((accumulatedJobDefinitions,jobDefinition)=>({...accumulatedJobDefinitions,[Object(log_analysis["getJobId"])(spaceId,sourceId,jobDefinition.id)]:jobDefinition}),{}):{},[moduleDefinition,sourceId,spaceId]);const[fetchModuleDefinitionRequest,fetchModuleDefinition]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>await moduleDescriptor.getModuleDefinition(services.http.fetch),onResolve:response=>{setModuleDefinition(response)},onReject:()=>{setModuleDefinition(undefined)}},[moduleDescriptor.getModuleDefinition,spaceId,sourceId]);const getIsJobDefinitionOutdated=Object(external_kbnSharedDeps_React_["useCallback"])(jobSummary=>{var _jobSummary$fullJob$c,_jobSummary$fullJob,_jobSummary$fullJob$c2;const jobDefinition=jobDefinitionByJobId[jobSummary.id];if(jobDefinition==null){return false}const currentRevision=jobDefinition===null||jobDefinition===void 0?void 0:jobDefinition.config.custom_settings.job_revision;return((_jobSummary$fullJob$c=(_jobSummary$fullJob=jobSummary.fullJob)===null||_jobSummary$fullJob===void 0?void 0:(_jobSummary$fullJob$c2=_jobSummary$fullJob.custom_settings)===null||_jobSummary$fullJob$c2===void 0?void 0:_jobSummary$fullJob$c2.job_revision)!==null&&_jobSummary$fullJob$c!==void 0?_jobSummary$fullJob$c:0)<(currentRevision!==null&&currentRevision!==void 0?currentRevision:0)},[jobDefinitionByJobId]);return{fetchModuleDefinition:fetchModuleDefinition,fetchModuleDefinitionRequestState:fetchModuleDefinitionRequest.state,getIsJobDefinitionOutdated:getIsJobDefinitionOutdated,jobDefinitionByJobId:jobDefinitionByJobId,moduleDefinition:moduleDefinition}};var useDeepCompareEffect=__webpack_require__(380);var useDeepCompareEffect_default=__webpack_require__.n(useDeepCompareEffect);const callGetLatestCategoriesDatasetsStatsAPI=async({jobIds:jobIds,startTime:startTime,endTime:endTime,includeCategorizerStatuses:includeCategorizerStatuses},fetch)=>{const response=await fetch(http_api["b"],{method:"POST",body:JSON.stringify(http_api["j"].encode({data:{jobIds:jobIds,timeRange:{startTime:startTime,endTime:endTime},includeCategorizerStatuses:includeCategorizerStatuses}}))});return Object(runtime_types["b"])(http_api["k"])(response)};const useLogEntryCategoriesQuality=({jobSummaries:jobSummaries})=>{const{services:{http:{fetch:fetch}}}=Object(use_kibana["b"])();const[lastestWarnedDatasetsStats,setLatestWarnedDatasetsStats]=Object(external_kbnSharedDeps_React_["useState"])([]);const jobSummariesWithCategoryWarnings=Object(external_kbnSharedDeps_React_["useMemo"])(()=>jobSummaries.filter(isJobWithCategoryWarnings),[jobSummaries]);const jobSummariesWithPartitionedCategoryWarnings=Object(external_kbnSharedDeps_React_["useMemo"])(()=>jobSummariesWithCategoryWarnings.filter(isJobWithPartitionedCategories),[jobSummariesWithCategoryWarnings]);const[fetchLatestWarnedDatasetsStatsRequest,fetchLatestWarnedDatasetsStats]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:statsIntervals=>Promise.all(statsIntervals.map(({jobId:jobId,startTime:startTime,endTime:endTime})=>callGetLatestCategoriesDatasetsStatsAPI({jobIds:[jobId],startTime:startTime,endTime:endTime,includeCategorizerStatuses:["warn"]},fetch))),onResolve:results=>{setLatestWarnedDatasetsStats(results.flatMap(({data:{datasetStats:datasetStats}})=>datasetStats))}},[]);useDeepCompareEffect_default()(()=>{fetchLatestWarnedDatasetsStats(jobSummariesWithPartitionedCategoryWarnings.map(jobSummary=>{var _jobSummary$fullJob$c,_jobSummary$fullJob,_jobSummary$fullJob$m,_jobSummary$fullJob2,_jobSummary$fullJob2$;return{jobId:jobSummary.id,startTime:(_jobSummary$fullJob$c=(_jobSummary$fullJob=jobSummary.fullJob)===null||_jobSummary$fullJob===void 0?void 0:_jobSummary$fullJob.create_time)!==null&&_jobSummary$fullJob$c!==void 0?_jobSummary$fullJob$c:0,endTime:(_jobSummary$fullJob$m=(_jobSummary$fullJob2=jobSummary.fullJob)===null||_jobSummary$fullJob2===void 0?void 0:(_jobSummary$fullJob2$=_jobSummary$fullJob2.model_size_stats)===null||_jobSummary$fullJob2$===void 0?void 0:_jobSummary$fullJob2$.log_time)!==null&&_jobSummary$fullJob$m!==void 0?_jobSummary$fullJob$m:Date.now()}}))},[jobSummariesWithPartitionedCategoryWarnings]);const categoryQualityWarnings=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[...jobSummariesWithCategoryWarnings.filter(jobSummary=>!isJobWithPartitionedCategories(jobSummary)).map(jobSummary=>{var _jobSummary$fullJob3;return{type:"categoryQualityWarning",jobId:jobSummary.id,dataset:"",reasons:(_jobSummary$fullJob3=jobSummary.fullJob)!==null&&_jobSummary$fullJob3!==void 0&&_jobSummary$fullJob3.model_size_stats?getCategoryQualityWarningReasons(jobSummary.fullJob.model_size_stats):[]}}),...lastestWarnedDatasetsStats.map(datasetStats=>({type:"categoryQualityWarning",jobId:datasetStats.job_id,dataset:datasetStats.dataset,reasons:getCategoryQualityWarningReasons(datasetStats)}))],[jobSummariesWithCategoryWarnings,lastestWarnedDatasetsStats]);return{categoryQualityWarnings:categoryQualityWarnings,lastLatestWarnedDatasetsStatsRequestErrors:fetchLatestWarnedDatasetsStatsRequest.state==="rejected"?fetchLatestWarnedDatasetsStatsRequest.value:null,isLoadingCategoryQualityWarnings:fetchLatestWarnedDatasetsStatsRequest.state==="pending"}};const isJobWithCategoryWarnings=jobSummary=>{var _jobSummary$fullJob4,_jobSummary$fullJob4$;return((_jobSummary$fullJob4=jobSummary.fullJob)===null||_jobSummary$fullJob4===void 0?void 0:(_jobSummary$fullJob4$=_jobSummary$fullJob4.model_size_stats)===null||_jobSummary$fullJob4$===void 0?void 0:_jobSummary$fullJob4$.categorization_status)==="warn"};const isJobWithPartitionedCategories=jobSummary=>{var _jobSummary$fullJob$a,_jobSummary$fullJob5,_jobSummary$fullJob5$;return(_jobSummary$fullJob$a=(_jobSummary$fullJob5=jobSummary.fullJob)===null||_jobSummary$fullJob5===void 0?void 0:(_jobSummary$fullJob5$=_jobSummary$fullJob5.analysis_config)===null||_jobSummary$fullJob5$===void 0?void 0:_jobSummary$fullJob5$.per_partition_categorization)!==null&&_jobSummary$fullJob$a!==void 0?_jobSummary$fullJob$a:false};const getCategoryQualityWarningReasons=({categorized_doc_count:categorizedDocCount,dead_category_count:deadCategoryCount,frequent_category_count:frequentCategoryCount,rare_category_count:rareCategoryCount,total_category_count:totalCategoryCount})=>{const rareCategoriesRatio=rareCategoryCount/totalCategoryCount;const categoriesDocumentRatio=totalCategoryCount/categorizedDocCount;const deadCategoriesRatio=deadCategoryCount/totalCategoryCount;return[...totalCategoryCount===1?[{type:"singleCategory"}]:[],...rareCategoriesRatio>=.9?[{type:"manyRareCategories",rareCategoriesRatio:rareCategoriesRatio}]:[],...categorizedDocCount>100&&categoriesDocumentRatio>=.5?[{type:"manyCategories",categoriesDocumentRatio:categoriesDocumentRatio}]:[],...frequentCategoryCount===0?[{type:"noFrequentCategories"}]:[],...deadCategoriesRatio>=.5?[{type:"manyDeadCategories",deadCategoriesRatio:deadCategoriesRatio}]:[]]};const useLogEntryCategoriesModule=({indexPattern:indexPattern,sourceId:sourceId,spaceId:spaceId,timestampField:timestampField})=>{const sourceConfiguration=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({indices:indexPattern.split(","),sourceId:sourceId,spaceId:spaceId,timestampField:timestampField}),[indexPattern,sourceId,spaceId,timestampField]);const logAnalysisModule=useLogAnalysisModule({moduleDescriptor:logEntryCategoriesModule,sourceConfiguration:sourceConfiguration});const{getIsJobConfigurationOutdated:getIsJobConfigurationOutdated}=useLogAnalysisModuleConfiguration({sourceConfiguration:sourceConfiguration,moduleDescriptor:logEntryCategoriesModule});const{fetchModuleDefinition:fetchModuleDefinition,getIsJobDefinitionOutdated:getIsJobDefinitionOutdated}=useLogAnalysisModuleDefinition({sourceConfiguration:sourceConfiguration,moduleDescriptor:logEntryCategoriesModule});const{categoryQualityWarnings:categoryQualityWarnings}=useLogEntryCategoriesQuality({jobSummaries:logAnalysisModule.jobSummaries});const hasOutdatedJobConfigurations=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logAnalysisModule.jobSummaries.some(getIsJobConfigurationOutdated),[getIsJobConfigurationOutdated,logAnalysisModule.jobSummaries]);const hasOutdatedJobDefinitions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logAnalysisModule.jobSummaries.some(getIsJobDefinitionOutdated),[getIsJobDefinitionOutdated,logAnalysisModule.jobSummaries]);const hasStoppedJobs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(logAnalysisModule.jobStatus).some(currentJobStatus=>currentJobStatus==="stopped"),[logAnalysisModule.jobStatus]);return{...logAnalysisModule,categoryQualityWarnings:categoryQualityWarnings,fetchModuleDefinition:fetchModuleDefinition,hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasStoppedJobs:hasStoppedJobs}};const[LogEntryCategoriesModuleProvider,useLogEntryCategoriesModuleContext]=constate_cjs_default()(useLogEntryCategoriesModule);var external_kbnSharedDeps_Lodash_=__webpack_require__(21);var usePrevious=__webpack_require__(194);var usePrevious_default=__webpack_require__.n(usePrevious);const fourWeeksInMs=864e5*7*4;const useAnalysisSetupState=({cleanUpAndSetUpModule:cleanUpAndSetUpModule,moduleDescriptor:{validateSetupDatasets:validateSetupDatasets,validateSetupIndices:validateSetupIndices},setUpModule:setUpModule,sourceConfiguration:sourceConfiguration})=>{const{services:services}=Object(use_kibana["b"])();const[startTime,setStartTime]=Object(external_kbnSharedDeps_React_["useState"])(Date.now()-fourWeeksInMs);const[endTime,setEndTime]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const isTimeRangeValid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>startTime!=null&&endTime!=null?startTime<endTime:true,[endTime,startTime]);const[validatedIndices,setValidatedIndices]=Object(external_kbnSharedDeps_React_["useState"])(sourceConfiguration.indices.map(indexName=>({name:indexName,validity:"unknown"})));const updateIndicesWithValidationErrors=Object(external_kbnSharedDeps_React_["useCallback"])(validationErrors=>setValidatedIndices(availableIndices=>availableIndices.map(previousAvailableIndex=>{const indexValiationErrors=validationErrors.filter(({index:index})=>index===previousAvailableIndex.name);if(indexValiationErrors.length>0){return{validity:"invalid",name:previousAvailableIndex.name,errors:indexValiationErrors}}else if(previousAvailableIndex.validity==="valid"){return{...previousAvailableIndex,validity:"valid",errors:[]}}else{return{validity:"valid",name:previousAvailableIndex.name,isSelected:!Object(log_analysis["isExampleDataIndex"])(previousAvailableIndex.name),availableDatasets:[],datasetFilter:{type:"includeAll"}}}})),[]);const updateIndicesWithAvailableDatasets=Object(external_kbnSharedDeps_React_["useCallback"])(availableDatasets=>setValidatedIndices(availableIndices=>availableIndices.map(previousAvailableIndex=>{if(previousAvailableIndex.validity!=="valid"){return previousAvailableIndex}const availableDatasetsForIndex=availableDatasets.filter(({indexName:indexName})=>indexName===previousAvailableIndex.name);const newAvailableDatasets=availableDatasetsForIndex.flatMap(({datasets:datasets})=>datasets);const newDatasetFilter=availableDatasetsForIndex.length>0?Object(log_analysis["filterDatasetFilter"])(previousAvailableIndex.datasetFilter,dataset=>newAvailableDatasets.includes(dataset)):previousAvailableIndex.datasetFilter;return{...previousAvailableIndex,availableDatasets:newAvailableDatasets,datasetFilter:newDatasetFilter}})),[]);const validIndexNames=Object(external_kbnSharedDeps_React_["useMemo"])(()=>validatedIndices.filter(index=>index.validity==="valid").map(index=>index.name),[validatedIndices]);const selectedIndexNames=Object(external_kbnSharedDeps_React_["useMemo"])(()=>validatedIndices.filter(index=>index.validity==="valid"&&index.isSelected).map(i=>i.name),[validatedIndices]);const datasetFilter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>validatedIndices.flatMap(validatedIndex=>validatedIndex.validity==="valid"?validatedIndex.datasetFilter:{type:"includeAll"}).reduce(log_analysis["combineDatasetFilters"],{type:"includeAll"}),[validatedIndices]);const[validateIndicesRequest,validateIndices]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>await validateSetupIndices(sourceConfiguration.indices,sourceConfiguration.timestampField,services.http.fetch),onResolve:({data:{errors:errors}})=>{updateIndicesWithValidationErrors(errors)},onReject:()=>{setValidatedIndices([])}},[sourceConfiguration.indices,sourceConfiguration.timestampField]);const[validateDatasetsRequest,validateDatasets]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{if(validIndexNames.length===0){return{data:{datasets:[]}}}return await validateSetupDatasets(validIndexNames,sourceConfiguration.timestampField,startTime!==null&&startTime!==void 0?startTime:0,endTime!==null&&endTime!==void 0?endTime:Date.now(),services.http.fetch)},onResolve:({data:{datasets:datasets}})=>{updateIndicesWithAvailableDatasets(datasets)}},[validIndexNames,sourceConfiguration.timestampField,startTime,endTime]);const setUp=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setUpModule(selectedIndexNames,startTime,endTime,datasetFilter),[setUpModule,selectedIndexNames,startTime,endTime,datasetFilter]);const cleanUpAndSetUp=Object(external_kbnSharedDeps_React_["useCallback"])(()=>cleanUpAndSetUpModule(selectedIndexNames,startTime,endTime,datasetFilter),[cleanUpAndSetUpModule,selectedIndexNames,startTime,endTime,datasetFilter]);const isValidating=Object(external_kbnSharedDeps_React_["useMemo"])(()=>validateIndicesRequest.state==="pending"||validateDatasetsRequest.state==="pending",[validateDatasetsRequest.state,validateIndicesRequest.state]);const validationErrors=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(isValidating){return[]}return[...validateIndicesRequest.state==="rejected"||validateDatasetsRequest.state==="rejected"?[{error:"NETWORK_ERROR"}]:[],...validatedIndices.reduce((errors,index)=>index.validity==="invalid"&&selectedIndexNames.includes(index.name)?[...errors,...index.errors]:errors,[]),...selectedIndexNames.length===0?[{error:"TOO_FEW_SELECTED_INDICES"}]:[],...!isTimeRangeValid?[{error:"INVALID_TIME_RANGE"}]:[]]},[isValidating,validateIndicesRequest.state,validateDatasetsRequest.state,validatedIndices,selectedIndexNames,isTimeRangeValid]);const prevStartTime=usePrevious_default()(startTime);const prevEndTime=usePrevious_default()(endTime);const prevValidIndexNames=usePrevious_default()(validIndexNames);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!isTimeRangeValid){return}validateIndices()},[isTimeRangeValid,validateIndices]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!isTimeRangeValid){return}if(startTime!==prevStartTime||endTime!==prevEndTime||!Object(external_kbnSharedDeps_Lodash_["isEqual"])(validIndexNames,prevValidIndexNames)){validateDatasets()}},[endTime,isTimeRangeValid,prevEndTime,prevStartTime,prevValidIndexNames,startTime,validIndexNames,validateDatasets]);return{cleanUpAndSetUp:cleanUpAndSetUp,datasetFilter:datasetFilter,endTime:endTime,isValidating:isValidating,selectedIndexNames:selectedIndexNames,setEndTime:setEndTime,setStartTime:setStartTime,setUp:setUp,startTime:startTime,validatedIndices:validatedIndices,setValidatedIndices:setValidatedIndices,validationErrors:validationErrors}};const useLogEntryCategoriesSetup=()=>{const{categoryQualityWarnings:categoryQualityWarnings,cleanUpAndSetUpModule:cleanUpAndSetUpModule,fetchJobStatus:fetchJobStatus,lastSetupErrorMessages:lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setUpModule:setUpModule,setupStatus:setupStatus,sourceConfiguration:sourceConfiguration,viewResults:viewResults}=useLogEntryCategoriesModuleContext();const{cleanUpAndSetUp:cleanUpAndSetUp,endTime:endTime,isValidating:isValidating,setEndTime:setEndTime,setStartTime:setStartTime,setValidatedIndices:setValidatedIndices,setUp:setUp,startTime:startTime,validatedIndices:validatedIndices,validationErrors:validationErrors}=useAnalysisSetupState({cleanUpAndSetUpModule:cleanUpAndSetUpModule,moduleDescriptor:moduleDescriptor,setUpModule:setUpModule,sourceConfiguration:sourceConfiguration});return{categoryQualityWarnings:categoryQualityWarnings,cleanUpAndSetUp:cleanUpAndSetUp,endTime:endTime,fetchJobStatus:fetchJobStatus,isValidating:isValidating,lastSetupErrorMessages:lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setEndTime:setEndTime,setStartTime:setStartTime,setValidatedIndices:setValidatedIndices,setUp:setUp,setupStatus:setupStatus,startTime:startTime,validatedIndices:validatedIndices,validationErrors:validationErrors,viewResults:viewResults}};var initial_configuration_step=__webpack_require__(172);var process_step=__webpack_require__(173);const LogEntryCategoriesSetupView=({onClose:onClose})=>{const{categoryQualityWarnings:categoryQualityWarnings,cleanUpAndSetUp:cleanUpAndSetUp,endTime:endTime,fetchJobStatus:fetchJobStatus,isValidating:isValidating,lastSetupErrorMessages:lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setEndTime:setEndTime,setStartTime:setStartTime,setValidatedIndices:setValidatedIndices,setUp:setUp,setupStatus:setupStatus,startTime:startTime,validatedIndices:validatedIndices,validationErrors:validationErrors,viewResults:viewResults}=useLogEntryCategoriesSetup();useMount_default()(()=>{fetchJobStatus()});const viewResultsAndClose=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{viewResults();onClose()},[viewResults,onClose]);const steps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[Object(initial_configuration_step["a"])({setStartTime:setStartTime,setEndTime:setEndTime,startTime:startTime,endTime:endTime,isValidating:isValidating,validatedIndices:validatedIndices,setupStatus:setupStatus,setValidatedIndices:setValidatedIndices,validationErrors:validationErrors,previousQualityWarnings:categoryQualityWarnings}),Object(process_step["a"])({cleanUpAndSetUp:cleanUpAndSetUp,errorMessages:lastSetupErrorMessages,isConfigurationValid:validationErrors.length<=0&&!isValidating,setUp:setUp,setupStatus:setupStatus,viewResults:viewResultsAndClose})],[categoryQualityWarnings,cleanUpAndSetUp,endTime,isValidating,lastSetupErrorMessages,setEndTime,setStartTime,setUp,setValidatedIndices,setupStatus,startTime,validatedIndices,validationErrors,viewResultsAndClose]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,moduleDescriptor.moduleName," ")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},moduleDescriptor.moduleDescription),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSteps"],{steps:steps}))};const log_entry_rate_module_descriptor_moduleId="logs_ui_analysis";const log_entry_rate_module_descriptor_moduleName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryRateModuleName",{defaultMessage:"Log rate"});const log_entry_rate_module_descriptor_moduleDescription=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryRateModuleDescription",{defaultMessage:"Use Machine Learning to automatically detect anomalous log entry rates."});const module_descriptor_getJobIds=(spaceId,sourceId)=>log_analysis["logEntryRateJobTypes"].reduce((accumulatedJobIds,jobType)=>({...accumulatedJobIds,[jobType]:Object(log_analysis["getJobId"])(spaceId,sourceId,jobType)}),{});const module_descriptor_getJobSummary=async(spaceId,sourceId,fetch)=>{const response=await callJobsSummaryAPI({spaceId:spaceId,sourceId:sourceId,jobTypes:log_analysis["logEntryRateJobTypes"]},fetch);const jobIds=Object.values(module_descriptor_getJobIds(spaceId,sourceId));return response.filter(jobSummary=>jobIds.includes(jobSummary.id))};const module_descriptor_getModuleDefinition=async fetch=>await callGetMlModuleAPI(log_entry_rate_module_descriptor_moduleId,fetch);const log_entry_rate_module_descriptor_setUpModule=async(start,end,datasetFilter,{spaceId:spaceId,sourceId:sourceId,indices:indices,timestampField:timestampField},fetch)=>{const indexNamePattern=indices.join(",");const jobOverrides=[{job_id:"log-entry-rate",analysis_config:{bucket_span:`${log_analysis["bucketSpan"]}ms`},data_description:{time_field:timestampField},custom_settings:{logs_source_config:{indexPattern:indexNamePattern,timestampField:timestampField,bucketSpan:log_analysis["bucketSpan"]}}}];const query=datasetFilter.type==="includeSome"?{bool:{filter:[{terms:{"event.dataset":datasetFilter.datasets}}]}}:undefined;return callSetupMlModuleAPI({moduleId:log_entry_rate_module_descriptor_moduleId,start:start,end:end,spaceId:spaceId,sourceId:sourceId,indexPattern:indexNamePattern,jobOverrides:jobOverrides,query:query},fetch)};const log_entry_rate_module_descriptor_cleanUpModule=async(spaceId,sourceId,fetch)=>await cleanUpJobsAndDatafeeds(spaceId,sourceId,log_analysis["logEntryRateJobTypes"],fetch);const log_entry_rate_module_descriptor_validateSetupIndices=async(indices,timestampField,fetch)=>await callValidateIndicesAPI({indices:indices,fields:[{name:timestampField,validTypes:["date"]},{name:log_analysis["partitionField"],validTypes:["keyword"]}]},fetch);const log_entry_rate_module_descriptor_validateSetupDatasets=async(indices,timestampField,startTime,endTime,fetch)=>await callValidateDatasetsAPI({indices:indices,timestampField:timestampField,startTime:startTime,endTime:endTime},fetch);const logEntryRateModule={moduleId:log_entry_rate_module_descriptor_moduleId,moduleName:log_entry_rate_module_descriptor_moduleName,moduleDescription:log_entry_rate_module_descriptor_moduleDescription,jobTypes:log_analysis["logEntryRateJobTypes"],bucketSpan:log_analysis["bucketSpan"],getJobIds:module_descriptor_getJobIds,getJobSummary:module_descriptor_getJobSummary,getModuleDefinition:module_descriptor_getModuleDefinition,setUpModule:log_entry_rate_module_descriptor_setUpModule,cleanUpModule:log_entry_rate_module_descriptor_cleanUpModule,validateSetupDatasets:log_entry_rate_module_descriptor_validateSetupDatasets,validateSetupIndices:log_entry_rate_module_descriptor_validateSetupIndices};const useLogEntryRateModule=({indexPattern:indexPattern,sourceId:sourceId,spaceId:spaceId,timestampField:timestampField})=>{const sourceConfiguration=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({indices:indexPattern.split(","),sourceId:sourceId,spaceId:spaceId,timestampField:timestampField}),[indexPattern,sourceId,spaceId,timestampField]);const logAnalysisModule=useLogAnalysisModule({moduleDescriptor:logEntryRateModule,sourceConfiguration:sourceConfiguration});const{getIsJobConfigurationOutdated:getIsJobConfigurationOutdated}=useLogAnalysisModuleConfiguration({sourceConfiguration:sourceConfiguration,moduleDescriptor:logEntryRateModule});const{fetchModuleDefinition:fetchModuleDefinition,getIsJobDefinitionOutdated:getIsJobDefinitionOutdated}=useLogAnalysisModuleDefinition({sourceConfiguration:sourceConfiguration,moduleDescriptor:logEntryRateModule});const hasOutdatedJobConfigurations=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logAnalysisModule.jobSummaries.some(getIsJobConfigurationOutdated),[getIsJobConfigurationOutdated,logAnalysisModule.jobSummaries]);const hasOutdatedJobDefinitions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logAnalysisModule.jobSummaries.some(getIsJobDefinitionOutdated),[getIsJobDefinitionOutdated,logAnalysisModule.jobSummaries]);const hasStoppedJobs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(logAnalysisModule.jobStatus).some(currentJobStatus=>currentJobStatus==="stopped"),[logAnalysisModule.jobStatus]);return{...logAnalysisModule,fetchModuleDefinition:fetchModuleDefinition,hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasStoppedJobs:hasStoppedJobs}};const[LogEntryRateModuleProvider,useLogEntryRateModuleContext]=constate_cjs_default()(useLogEntryRateModule);const useLogEntryRateSetup=()=>{const{cleanUpAndSetUpModule:cleanUpAndSetUpModule,lastSetupErrorMessages:lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setUpModule:setUpModule,setupStatus:setupStatus,sourceConfiguration:sourceConfiguration,viewResults:viewResults}=useLogEntryRateModuleContext();const{cleanUpAndSetUp:cleanUpAndSetUp,endTime:endTime,isValidating:isValidating,setEndTime:setEndTime,setStartTime:setStartTime,setValidatedIndices:setValidatedIndices,setUp:setUp,startTime:startTime,validatedIndices:validatedIndices,validationErrors:validationErrors}=useAnalysisSetupState({cleanUpAndSetUpModule:cleanUpAndSetUpModule,moduleDescriptor:moduleDescriptor,setUpModule:setUpModule,sourceConfiguration:sourceConfiguration});return{cleanUpAndSetUp:cleanUpAndSetUp,endTime:endTime,isValidating:isValidating,lastSetupErrorMessages:lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setEndTime:setEndTime,setStartTime:setStartTime,setValidatedIndices:setValidatedIndices,setUp:setUp,setupStatus:setupStatus,startTime:startTime,validatedIndices:validatedIndices,validationErrors:validationErrors,viewResults:viewResults}};const[LogEntryRateSetupProvider,useLogEntryRateSetupContext]=constate_cjs_default()(useLogEntryRateSetup);const LogEntryRateSetupView=({onClose:onClose})=>{const{cleanUpAndSetUp:cleanUpAndSetUp,endTime:endTime,isValidating:isValidating,lastSetupErrorMessages:lastSetupErrorMessages,moduleDescriptor:moduleDescriptor,setEndTime:setEndTime,setStartTime:setStartTime,setValidatedIndices:setValidatedIndices,setUp:setUp,setupStatus:setupStatus,startTime:startTime,validatedIndices:validatedIndices,validationErrors:validationErrors,viewResults:viewResults}=useLogEntryRateSetup();const viewResultsAndClose=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{viewResults();onClose()},[viewResults,onClose]);const steps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[Object(initial_configuration_step["a"])({setStartTime:setStartTime,setEndTime:setEndTime,startTime:startTime,endTime:endTime,isValidating:isValidating,validatedIndices:validatedIndices,setupStatus:setupStatus,setValidatedIndices:setValidatedIndices,validationErrors:validationErrors}),Object(process_step["a"])({cleanUpAndSetUp:cleanUpAndSetUp,errorMessages:lastSetupErrorMessages,isConfigurationValid:validationErrors.length<=0&&!isValidating,setUp:setUp,setupStatus:setupStatus,viewResults:viewResultsAndClose})],[cleanUpAndSetUp,endTime,isValidating,lastSetupErrorMessages,setEndTime,setStartTime,setUp,setValidatedIndices,setupStatus,startTime,validatedIndices,validationErrors,viewResultsAndClose]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,moduleDescriptor.moduleName," ")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},moduleDescriptor.moduleDescription),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSteps"],{steps:steps}))};const getMlCapabilitiesResponsePayloadRT=lib["type"]({capabilities:lib["type"]({canGetJobs:lib["boolean"],canCreateJob:lib["boolean"],canDeleteJob:lib["boolean"],canOpenJob:lib["boolean"],canCloseJob:lib["boolean"],canForecastJob:lib["boolean"],canGetDatafeeds:lib["boolean"],canStartStopDatafeed:lib["boolean"],canUpdateJob:lib["boolean"],canUpdateDatafeed:lib["boolean"],canPreviewDatafeed:lib["boolean"]}),isPlatinumOrTrialLicense:lib["boolean"],mlFeatureEnabledInSpace:lib["boolean"],upgradeInProgress:lib["boolean"]});const useLogAnalysisCapabilities=()=>{const{services:services}=Object(use_kibana["b"])();const[mlCapabilities,setMlCapabilities]=Object(external_kbnSharedDeps_React_["useState"])(initialMlCapabilities);const[fetchMlCapabilitiesRequest,fetchMlCapabilities]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{const rawResponse=await services.http.fetch("/api/ml/ml_capabilities");return Object(runtime_types["b"])(getMlCapabilitiesResponsePayloadRT)(rawResponse)},onResolve:response=>{setMlCapabilities(response)}},[]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{fetchMlCapabilities()},[fetchMlCapabilities]);const isLoading=Object(external_kbnSharedDeps_React_["useMemo"])(()=>fetchMlCapabilitiesRequest.state==="pending",[fetchMlCapabilitiesRequest.state]);const hasLogAnalysisSetupCapabilities=mlCapabilities.capabilities.canCreateJob;const hasLogAnalysisReadCapabilities=mlCapabilities.capabilities.canGetJobs;const hasLogAnalysisCapabilites=mlCapabilities.isPlatinumOrTrialLicense&&mlCapabilities.mlFeatureEnabledInSpace;return{hasLogAnalysisCapabilites:hasLogAnalysisCapabilites,hasLogAnalysisReadCapabilities:hasLogAnalysisReadCapabilities,hasLogAnalysisSetupCapabilities:hasLogAnalysisSetupCapabilities,isLoading:isLoading}};const[LogAnalysisCapabilitiesProvider,useLogAnalysisCapabilitiesContext]=constate_cjs_default()(useLogAnalysisCapabilities);const initialMlCapabilities={capabilities:{canGetJobs:false,canCreateJob:false,canDeleteJob:false,canOpenJob:false,canCloseJob:false,canForecastJob:false,canGetDatafeeds:false,canStartStopDatafeed:false,canUpdateJob:false,canUpdateDatafeed:false,canPreviewDatafeed:false,canGetCalendars:false,canCreateCalendar:false,canDeleteCalendar:false,canGetFilters:false,canCreateFilter:false,canDeleteFilter:false,canFindFileStructure:false,canGetDataFrameJobs:false,canDeleteDataFrameJob:false,canPreviewDataFrameJob:false,canCreateDataFrameJob:false,canStartStopDataFrameJob:false},isPlatinumOrTrialLicense:false,mlFeatureEnabledInSpace:false,upgradeInProgress:false};var create_job_button=__webpack_require__(218);var utils_=__webpack_require__(78);const LogAnalysisModuleListCard=({jobId:jobId,hasSetupCapabilities:hasSetupCapabilities,moduleDescription:moduleDescription,moduleName:moduleName,moduleStatus:moduleStatus,onViewSetup:onViewSetup})=>{const{services:{ml:ml,application:{navigateToUrl:navigateToUrl},notifications:{toasts:toasts}}}=Object(use_kibana["b"])();const[viewInMlLink,setViewInMlLink]=Object(external_kbnSharedDeps_React_["useState"])("");const getMlUrl=async()=>{if(!ml.urlGenerator){toasts.addWarning({title:Object(utils_["mountReactNode"])(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.mlNotAvailable",defaultMessage:"ML plugin is not available"}))});return}setViewInMlLink(await ml.urlGenerator.createUrl({page:"jobs",pageState:{jobId:jobId}}))};Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getMlUrl()});const navigateToMlApp=async()=>{await navigateToUrl(viewInMlLink)};const moduleIcon=moduleStatus.type==="required"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"xxl",type:"machineLearningApp"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{color:"secondary",size:"xxl",type:"check"});const moduleSetupButton=moduleStatus.type==="required"?external_kbnSharedDeps_React_default.a.createElement(create_job_button["a"],{hasSetupCapabilities:hasSetupCapabilities,onClick:onViewSetup},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.enableAnomalyDetectionButtonLabel",defaultMessage:"Enable anomaly detection"})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(create_job_button["b"],{hasSetupCapabilities:hasSetupCapabilities,onClick:onViewSetup}),viewInMlLink?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:navigateToMlApp},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.viewInMlButtonLabel",defaultMessage:"View in Machine Learning"}))):null);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCard"],{description:moduleDescription,footer:external_kbnSharedDeps_React_default.a.createElement("div",null,moduleSetupButton),icon:moduleIcon,title:moduleName})};const LogAnalysisModuleList=({onViewModuleSetup:onViewModuleSetup})=>{const{hasLogAnalysisSetupCapabilities:hasLogAnalysisSetupCapabilities}=useLogAnalysisCapabilitiesContext();const{setupStatus:logEntryRateSetupStatus,jobIds:logEntryRateJobIds}=useLogEntryRateModuleContext();const{setupStatus:logEntryCategoriesSetupStatus,jobIds:logEntryCategoriesJobIds}=useLogEntryCategoriesModuleContext();const viewLogEntryRateSetupFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{onViewModuleSetup("logs_ui_analysis")},[onViewModuleSetup]);const viewLogEntryCategoriesSetupFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{onViewModuleSetup("logs_ui_categories")},[onViewModuleSetup]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(LogAnalysisModuleListCard,{jobId:logEntryRateJobIds["log-entry-rate"],hasSetupCapabilities:hasLogAnalysisSetupCapabilities,moduleDescription:logEntryRateModule.moduleDescription,moduleName:logEntryRateModule.moduleName,moduleStatus:logEntryRateSetupStatus,onViewSetup:viewLogEntryRateSetupFlyout})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(LogAnalysisModuleListCard,{jobId:logEntryCategoriesJobIds["log-entry-categories-count"],hasSetupCapabilities:hasLogAnalysisSetupCapabilities,moduleDescription:logEntryCategoriesModule.moduleDescription,moduleName:logEntryCategoriesModule.moduleName,moduleStatus:logEntryCategoriesSetupStatus,onViewSetup:viewLogEntryCategoriesSetupFlyout}))))};const moduleIds=["logs_ui_analysis","logs_ui_categories"];const useLogAnalysisSetupFlyoutState=({initialFlyoutView:initialFlyoutView={view:"hidden"}})=>{const[flyoutView,setFlyoutView]=Object(external_kbnSharedDeps_React_["useState"])(initialFlyoutView);const closeFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setFlyoutView({view:"hidden"}),[]);const showModuleList=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setFlyoutView({view:"moduleList"}),[]);const showModuleSetup=Object(external_kbnSharedDeps_React_["useCallback"])(module=>{setFlyoutView({view:"moduleSetup",module:module})},[setFlyoutView]);return{closeFlyout:closeFlyout,flyoutView:flyoutView,setFlyoutView:setFlyoutView,showModuleList:showModuleList,showModuleSetup:showModuleSetup}};const[LogAnalysisSetupFlyoutStateProvider,useLogAnalysisSetupFlyoutStateContext]=constate_cjs_default()(useLogAnalysisSetupFlyoutState);const FLYOUT_HEADING_ID="logAnalysisSetupFlyoutHeading";const LogAnalysisSetupFlyout=({allowedModules:allowedModules=moduleIds})=>{const{closeFlyout:closeFlyout,flyoutView:flyoutView,showModuleList:showModuleList,showModuleSetup:showModuleSetup}=useLogAnalysisSetupFlyoutStateContext();if(flyoutView.view==="hidden"){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{"aria-labelledby":FLYOUT_HEADING_ID,maxWidth:800,onClose:closeFlyout},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",{id:FLYOUT_HEADING_ID},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.setupFlyoutTitle",defaultMessage:"Anomaly detection with Machine Learning"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,flyoutView.view==="moduleList"?external_kbnSharedDeps_React_default.a.createElement(LogAnalysisModuleList,{onViewModuleSetup:showModuleSetup}):flyoutView.view==="moduleSetup"&&allowedModules.includes(flyoutView.module)?external_kbnSharedDeps_React_default.a.createElement(ModuleSetupView,{moduleId:flyoutView.module,onClose:closeFlyout,onViewModuleList:allowedModules.length>1?showModuleList:undefined}):null))};const ModuleSetupView=({moduleId:moduleId,onClose:onClose,onViewModuleList:onViewModuleList})=>{switch(moduleId){case"logs_ui_analysis":return external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyoutSubPage,{onViewModuleList:onViewModuleList},external_kbnSharedDeps_React_default.a.createElement(LogEntryRateSetupView,{onClose:onClose}));case"logs_ui_categories":return external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyoutSubPage,{onViewModuleList:onViewModuleList},external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesSetupView,{onClose:onClose}))}};const LogAnalysisSetupFlyoutSubPage=({children:children,onViewModuleList:onViewModuleList})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart",direction:"column",gutterSize:"none"},onViewModuleList?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{flush:"left",iconSide:"left",iconType:"arrowLeft",onClick:onViewModuleList},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.setupFlyoutGotoListButtonLabel",defaultMessage:"All Machine Learning jobs"}))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,children));var source_error_page=__webpack_require__(180);var source_loading_page=__webpack_require__(116);var elastic_datemath=__webpack_require__(6);var elastic_datemath_default=__webpack_require__.n(elastic_datemath);var external_kbnSharedDeps_Moment_=__webpack_require__(50);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);var useInterval=__webpack_require__(135);var useInterval_default=__webpack_require__.n(useInterval);var common_=__webpack_require__(11);var recreate_job_callout=__webpack_require__(191);const JobConfigurationOutdatedCallout=({hasSetupCapabilities:hasSetupCapabilities,moduleName:moduleName,onRecreateMlJob:onRecreateMlJob})=>external_kbnSharedDeps_React_default.a.createElement(recreate_job_callout["a"],{hasSetupCapabilities:hasSetupCapabilities,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.jobConfigurationOutdatedCalloutTitle",{defaultMessage:"The {moduleName} ML job configuration is outdated",values:{moduleName:moduleName}}),onRecreateMlJob:onRecreateMlJob},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.jobConfigurationOutdatedCalloutMessage",defaultMessage:"The {moduleName} ML job was created using a different source configuration. Recreate the job to apply the current configuration. This removes previously detected anomalies.",values:{moduleName:moduleName},tagName:"p"}));const JobDefinitionOutdatedCallout=({hasSetupCapabilities:hasSetupCapabilities,moduleName:moduleName,onRecreateMlJob:onRecreateMlJob})=>external_kbnSharedDeps_React_default.a.createElement(recreate_job_callout["a"],{hasSetupCapabilities:hasSetupCapabilities,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.jobDefinitionOutdatedCalloutTitle",{defaultMessage:"The {moduleName} ML job definition is outdated",values:{moduleName:moduleName}}),onRecreateMlJob:onRecreateMlJob},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.jobDefinitionOutdatedCalloutMessage",defaultMessage:"A newer version of the {moduleName} ML job is available. Recreate the job to deploy the newer version. This removes previously detected anomalies.",values:{moduleName:moduleName},tagName:"p"}));const JobStoppedCallout=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"primary",title:jobStoppedTitle},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.jobStoppedCalloutMessage",defaultMessage:"The ML job has been stopped manually or due to a lack of resources. New log entries will not be processed until the job has been restarted.",tagName:"p"}));const jobStoppedTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.jobStoppedCalloutTitle",{defaultMessage:"ML job stopped"});var use_link_props=__webpack_require__(29);const AnalyzeInMlButton=({href:href})=>{const{services:{application:application}}=Object(use_kibana["b"])();const handleClick=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{if(!href||!Object(use_link_props["a"])(e))return;application.navigateToUrl(href)},[href,application]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:false,size:"s",onClick:handleClick},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.analyzeInMlButtonLabel",defaultMessage:"Analyze in ML"}))};const FirstUseCallout=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"success",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.onboardingSuccessTitle",{defaultMessage:"Success!"})},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.onboardingSuccessContent",{defaultMessage:"Please allow a few minutes for our machine learning robots to begin collecting data."})));const LogAnalysisJobProblemIndicator=({hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasSetupCapabilities:hasSetupCapabilities,hasStoppedJobs:hasStoppedJobs,isFirstUse:isFirstUse,moduleName:moduleName,onRecreateMlJobForReconfiguration:onRecreateMlJobForReconfiguration,onRecreateMlJobForUpdate:onRecreateMlJobForUpdate})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,hasOutdatedJobDefinitions?external_kbnSharedDeps_React_default.a.createElement(JobDefinitionOutdatedCallout,{hasSetupCapabilities:hasSetupCapabilities,moduleName:moduleName,onRecreateMlJob:onRecreateMlJobForUpdate}):null,hasOutdatedJobConfigurations?external_kbnSharedDeps_React_default.a.createElement(JobConfigurationOutdatedCallout,{hasSetupCapabilities:hasSetupCapabilities,moduleName:moduleName,onRecreateMlJob:onRecreateMlJobForReconfiguration}):null,hasStoppedJobs?external_kbnSharedDeps_React_default.a.createElement(JobStoppedCallout,null):null,isFirstUse?external_kbnSharedDeps_React_default.a.createElement(FirstUseCallout,null):null);var quality_warning_notices=__webpack_require__(248);const CategoryJobNoticesSection=({hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasSetupCapabilities:hasSetupCapabilities,hasStoppedJobs:hasStoppedJobs,isFirstUse:isFirstUse,moduleName:moduleName,onRecreateMlJobForReconfiguration:onRecreateMlJobForReconfiguration,onRecreateMlJobForUpdate:onRecreateMlJobForUpdate,qualityWarnings:qualityWarnings})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LogAnalysisJobProblemIndicator,{hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasSetupCapabilities:hasSetupCapabilities,hasStoppedJobs:hasStoppedJobs,isFirstUse:isFirstUse,moduleName:moduleName,onRecreateMlJobForReconfiguration:onRecreateMlJobForReconfiguration,onRecreateMlJobForUpdate:onRecreateMlJobForUpdate}),external_kbnSharedDeps_React_default.a.createElement(quality_warning_notices["b"],{hasSetupCapabilities:hasSetupCapabilities,qualityWarnings:qualityWarnings,onRecreateMlJob:onRecreateMlJobForReconfiguration}));const useViewLogInContext=props=>{const[contextEntry,setContextEntry]=Object(external_kbnSharedDeps_React_["useState"])();const{startTimestamp:startTimestamp,endTimestamp:endTimestamp,sourceId:sourceId}=props;return[{startTimestamp:startTimestamp,endTimestamp:endTimestamp,sourceId:sourceId,contextEntry:contextEntry},{setContextEntry:setContextEntry}]};const ViewLogInContext=constate_cjs_default()(useViewLogInContext);const getViewportWidth=()=>window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth;const getViewportHeight=()=>window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;function useViewportDimensions(){const[dimensions,setDimensions]=Object(external_kbnSharedDeps_React_["useState"])({width:getViewportWidth(),height:getViewportHeight()});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const updateDimensions=Object(external_kbnSharedDeps_Lodash_["throttle"])(()=>{setDimensions({width:getViewportWidth(),height:getViewportHeight()})},250);window.addEventListener("resize",updateDimensions);return()=>window.removeEventListener("resize",updateDimensions)},[]);return dimensions}var log_stream=__webpack_require__(250);const MODAL_MARGIN=25;const PageViewLogInContext=()=>{const[{contextEntry:contextEntry,startTimestamp:startTimestamp,endTimestamp:endTimestamp,sourceId:sourceId},{setContextEntry:setContextEntry}]=Object(external_kbnSharedDeps_React_["useContext"])(ViewLogInContext.Context);const closeModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setContextEntry(undefined),[setContextEntry]);const{width:vw,height:vh}=useViewportDimensions();const contextQuery=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(contextEntry&&!Object(external_kbnSharedDeps_Lodash_["isEmpty"])(contextEntry.context)){return Object.entries(contextEntry.context).reduce((kuery,[key,value])=>{const currentExpression=`${key} : "${value}"`;if(kuery.length>0){return`${kuery} AND ${currentExpression}`}else{return currentExpression}},"")}},[contextEntry]);if(!contextEntry){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:closeModal,maxWidth:false},external_kbnSharedDeps_React_default.a.createElement(LogInContextWrapper,{width:vw-MODAL_MARGIN*2,height:vh-MODAL_MARGIN*2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",responsive:false,wrap:false,style:{height:"100%"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(LogEntryContext,{context:contextEntry.context})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},external_kbnSharedDeps_React_default.a.createElement(log_stream["a"],{sourceId:sourceId,startTimestamp:startTimestamp,endTimestamp:endTimestamp,query:contextQuery,center:contextEntry.cursor,highlight:contextEntry.id,height:"100%"})))))};const LogInContextWrapper=common_["euiStyled"].div`
  padding: 16px;
  width: ${props=>typeof props.width==="number"?`${props.width}px`:props.width};
  height: ${props=>typeof props.height==="number"?`${props.height}px`:props.height};
  max-height: 75vh; // Same as EuiModal
`;const LogEntryContext=({context:context})=>{let text;if("container.id"in context){text=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.viewInContext.logsFromContainerTitle",defaultMessage:"Displayed logs are from container {container}",values:{container:context["container.id"]}})}if("host.name"in context){const shortenedFilePath=context["log.file.path"].length>45?context["log.file.path"].slice(0,20)+"..."+context["log.file.path"].slice(-25):context["log.file.path"];text=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.viewInContext.logsFromFileTitle",defaultMessage:"Displayed logs are from file {file} and host {host}",values:{file:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:context["log.file.path"]},external_kbnSharedDeps_React_default.a.createElement("span",null,shortenedFilePath)),host:context["host.name"]}})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},text)))};const BetaBadge=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{"aria-label":betaBadgeLabel,label:betaBadgeLabel,tooltipContent:betaBadgeTooltipContent,className:"eui-alignMiddle"});const betaBadgeLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.common.tabBetaBadgeLabel",{defaultMessage:"Beta"});const betaBadgeTooltipContent=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.common.tabBetaBadgeTooltipContent",{defaultMessage:"This feature is under active development. Extra functionality is coming, and some functionality may change."});var loading_overlay_wrapper=__webpack_require__(154);const DatasetsSelector=({availableDatasets:availableDatasets,isLoading:isLoading=false,onChangeDatasetSelection:onChangeDatasetSelection,selectedDatasets:selectedDatasets})=>{const options=Object(external_kbnSharedDeps_React_["useMemo"])(()=>availableDatasets.map(dataset=>({value:dataset,label:Object(log_analysis["getFriendlyNameForPartitionId"])(dataset)})),[availableDatasets]);const selectedOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>options.filter(({value:value})=>value!=null&&selectedDatasets.includes(value)),[options,selectedDatasets]);const handleChange=Object(external_kbnSharedDeps_React_["useCallback"])(newSelectedOptions=>onChangeDatasetSelection(newSelectedOptions.map(({value:value})=>value).filter(isDefined)),[onChangeDatasetSelection]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{"aria-label":datasetFilterPlaceholder,isLoading:isLoading,onChange:handleChange,options:options,placeholder:datasetFilterPlaceholder,selectedOptions:selectedOptions})};const datasetFilterPlaceholder=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.datasetFilterPlaceholder",{defaultMessage:"Filter by datasets"});const isDefined=value=>value!=null;var external_kbnSharedDeps_ElasticNumeral_=__webpack_require__(75);var external_kbnSharedDeps_ElasticNumeral_default=__webpack_require__.n(external_kbnSharedDeps_ElasticNumeral_);var useSet=__webpack_require__(260);var useSet_default=__webpack_require__.n(useSet);const RowExpansionButton=({isExpanded:isExpanded,item:item,onCollapse:onCollapse,onExpand:onExpand})=>{const handleClick=Object(external_kbnSharedDeps_React_["useCallback"])(()=>isExpanded?onCollapse(item):onExpand(item),[isExpanded,item,onCollapse,onExpand]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{onClick:handleClick,"aria-label":isExpanded?collapseAriaLabel:expandAriaLabel,iconType:isExpanded?"arrowUp":"arrowDown"})};const collapseAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.table.collapseRowLabel",{defaultMessage:"Collapse"});const expandAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.table.expandRowLabel",{defaultMessage:"Expand"});var ml_public_=__webpack_require__(73);const AnomalySeverityIndicator=({anomalyScore:anomalyScore})=>{const severityColor=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getColorForAnomalyScore(anomalyScore),[anomalyScore]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:severityColor},Object(ml_public_["getFormattedSeverityScore"])(anomalyScore))};const getColorForAnomalyScore=anomalyScore=>{const severityCategory=Object(log_analysis["getSeverityCategoryForScore"])(anomalyScore);if(severityCategory!=null&&severityCategory in log_analysis["ML_SEVERITY_COLORS"]){return log_analysis["ML_SEVERITY_COLORS"][severityCategory]}else{return"subdued"}};const AnomalySeverityIndicatorList=({datasets:datasets})=>external_kbnSharedDeps_React_default.a.createElement("ul",null,datasets.map(dataset=>{const datasetLabel=Object(log_analysis["getFriendlyNameForPartitionId"])(dataset.name);return external_kbnSharedDeps_React_default.a.createElement("li",{key:datasetLabel},external_kbnSharedDeps_React_default.a.createElement(AnomalySeverityIndicator,{anomalyScore:dataset.maximumAnomalyScore}))}));var http_api_log_analysis=__webpack_require__(107);const callGetLogEntryCategoryExamplesAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,startTime:startTime,endTime:endTime,categoryId:categoryId,exampleCount:exampleCount}=requestArgs;const response=await fetch(http_api_log_analysis["f"],{method:"POST",body:JSON.stringify(http_api_log_analysis["t"].encode({data:{categoryId:categoryId,exampleCount:exampleCount,sourceId:sourceId,timeRange:{startTime:startTime,endTime:endTime}}}))});return Object(runtime_types["b"])(http_api_log_analysis["u"])(response)};const useLogEntryCategoryExamples=({categoryId:categoryId,endTime:endTime,exampleCount:exampleCount,sourceId:sourceId,startTime:startTime})=>{const{services:services}=Object(use_kibana["b"])();const[logEntryCategoryExamples,setLogEntryCategoryExamples]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getLogEntryCategoryExamplesRequest,getLogEntryCategoryExamples]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async()=>await callGetLogEntryCategoryExamplesAPI({sourceId:sourceId,startTime:startTime,endTime:endTime,categoryId:categoryId,exampleCount:exampleCount},services.http.fetch),onResolve:({data:{examples:examples}})=>{setLogEntryCategoryExamples(examples)}},[categoryId,endTime,exampleCount,sourceId,startTime]);const isLoadingLogEntryCategoryExamples=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryCategoryExamplesRequest.state==="pending",[getLogEntryCategoryExamplesRequest.state]);const hasFailedLoadingLogEntryCategoryExamples=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryCategoryExamplesRequest.state==="rejected",[getLogEntryCategoryExamplesRequest.state]);return{getLogEntryCategoryExamples:getLogEntryCategoryExamples,hasFailedLoadingLogEntryCategoryExamples:hasFailedLoadingLogEntryCategoryExamples,isLoadingLogEntryCategoryExamples:isLoadingLogEntryCategoryExamples,logEntryCategoryExamples:logEntryCategoryExamples}};const LogEntryExampleMessagesEmptyIndicator=({onReload:onReload})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryExamples.exampleEmptyDescription",defaultMessage:"No examples found within the selected time range. Increase the log entry retention period to improve message sample availability."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onReload,size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryExamples.exampleEmptyReloadButtonLabel",defaultMessage:"Reload"}))));const LogEntryExampleMessagesFailureIndicator=({onRetry:onRetry})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"danger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryExamples.exampleLoadingFailureDescription",defaultMessage:"Failed to load examples."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onRetry,size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryExamples.exampleLoadingFailureRetryButtonLabel",defaultMessage:"Retry"}))));const LogEntryExampleMessagesLoadingIndicator=({exampleCount:exampleCount})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,Array.from(new Array(exampleCount),(_value,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{key:index,lines:1})));const LogEntryExampleMessages=({isLoading:isLoading,hasFailedLoading:hasFailedLoading,exampleCount:exampleCount,hasResults:hasResults,onReload:onReload,children:children})=>external_kbnSharedDeps_React_default.a.createElement(Wrapper,null,isLoading?external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessagesLoadingIndicator,{exampleCount:exampleCount}):hasFailedLoading?external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessagesFailureIndicator,{onRetry:onReload}):!hasResults?external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessagesEmptyIndicator,{onReload:onReload}):children);const Wrapper=common_["euiStyled"].div`
  align-items: stretch;
  flex-direction: column;
  flex: 1 0 0%;
  overflow: hidden;
  padding-top: 1px; // Buffer for the "Reload" buttons' hover state
`;var rison=__webpack_require__(23);var log_text_stream=__webpack_require__(171);var log_entry_context_menu=__webpack_require__(159);const exampleMessageScale="medium";const exampleTimestampFormat="dateTime";const CategoryExampleMessage=({id:id,dataset:dataset,message:message,timestamp:timestamp,timeRange:timeRange,tiebreaker:tiebreaker,context:context})=>{const trackMetric=Object(observability_public_["useUiTracker"])({app:"infra_logs"});const[,{setContextEntry:setContextEntry}]=Object(external_kbnSharedDeps_React_["useContext"])(ViewLogInContext.Context);const humanFriendlyDataset=Object(log_analysis["getFriendlyNameForPartitionId"])(dataset);const[isHovered,setIsHovered]=Object(external_kbnSharedDeps_React_["useState"])(false);const setHovered=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsHovered(true),[]);const setNotHovered=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsHovered(false),[]);const[isMenuOpen,setIsMenuOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const openMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsMenuOpen(true),[]);const closeMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsMenuOpen(false),[]);const viewInStreamLinkProps=Object(use_link_props["b"])({app:"logs",pathname:"stream",search:{logPosition:Object(rison["encode"])({end:external_kbnSharedDeps_Moment_default()(timeRange.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),position:{tiebreaker:tiebreaker,time:timestamp},start:external_kbnSharedDeps_Moment_default()(timeRange.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),streamLive:false}),flyoutOptions:Object(rison["encode"])({surroundingLogsId:id}),logFilter:Object(rison["encode"])({expression:`${log_analysis["partitionField"]}: ${dataset}`,kind:"kuery"})}});return external_kbnSharedDeps_React_default.a.createElement(log_text_stream["e"],{scale:exampleMessageScale,onMouseEnter:setHovered,onMouseLeave:setNotHovered},external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],columnWidths[timestampColumnId],external_kbnSharedDeps_React_default.a.createElement(log_text_stream["f"],{format:exampleTimestampFormat,time:timestamp})),external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],columnWidths[messageColumnId],external_kbnSharedDeps_React_default.a.createElement(log_text_stream["d"],{columnValue:{columnId:messageColumnId,message:[{field:"message",value:[message],highlights:[]}]},highlights:noHighlights,isActiveHighlight:false,wrapMode:"none"})),external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],columnWidths[datasetColumnId],external_kbnSharedDeps_React_default.a.createElement(log_text_stream["c"],{columnValue:{columnId:datasetColumnId,field:"event.dataset",value:[humanFriendlyDataset],highlights:[]},highlights:noHighlights,isActiveHighlight:false,wrapMode:"none"})),external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],columnWidths[iconColumnId],isHovered||isMenuOpen?external_kbnSharedDeps_React_default.a.createElement(log_entry_context_menu["a"],{isOpen:isMenuOpen,onOpen:openMenu,onClose:closeMenu,items:[{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.categoryExample.viewInStreamText",{defaultMessage:"View in stream"}),onClick:viewInStreamLinkProps.onClick,href:viewInStreamLinkProps.href},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.categoryExample.viewInContextText",{defaultMessage:"View in context"}),onClick:()=>{const logEntry={id:id,index:"",context:context,cursor:{time:timestamp,tiebreaker:tiebreaker},columns:[]};trackMetric({metric:"view_in_context__categories"});setContextEntry(logEntry)}}]}):null))};const noHighlights=[];const timestampColumnId="category-example-timestamp-column";const messageColumnId="category-examples-message-column";const datasetColumnId="category-examples-dataset-column";const iconColumnId="category-examples-icon-column";const columnWidths={[timestampColumnId]:{growWeight:0,shrinkWeight:0,baseWidth:"332px"},[messageColumnId]:{growWeight:1,shrinkWeight:0,baseWidth:"0%"},[datasetColumnId]:{growWeight:0,shrinkWeight:0,baseWidth:"400px"},[iconColumnId]:{growWeight:0,shrinkWeight:0,baseWidth:"32px"}};const exampleMessageColumnConfigurations=[{timestampColumn:{id:timestampColumnId}},{messageColumn:{id:messageColumnId}},{fieldColumn:{field:"event.dataset",id:datasetColumnId}}];const category_details_row_exampleCount=5;const CategoryDetailsRow=({categoryId:categoryId,timeRange:timeRange,sourceId:sourceId})=>{const{getLogEntryCategoryExamples:getLogEntryCategoryExamples,hasFailedLoadingLogEntryCategoryExamples:hasFailedLoadingLogEntryCategoryExamples,isLoadingLogEntryCategoryExamples:isLoadingLogEntryCategoryExamples,logEntryCategoryExamples:logEntryCategoryExamples}=useLogEntryCategoryExamples({categoryId:categoryId,endTime:timeRange.endTime,exampleCount:category_details_row_exampleCount,sourceId:sourceId,startTime:timeRange.startTime});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getLogEntryCategoryExamples()},[getLogEntryCategoryExamples]);return external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessages,{isLoading:isLoadingLogEntryCategoryExamples,hasFailedLoading:hasFailedLoadingLogEntryCategoryExamples,hasResults:logEntryCategoryExamples.length>0,exampleCount:category_details_row_exampleCount,onReload:getLogEntryCategoryExamples},logEntryCategoryExamples.map((example,exampleIndex)=>external_kbnSharedDeps_React_default.a.createElement(CategoryExampleMessage,{key:exampleIndex,id:example.id,dataset:example.dataset,message:example.message,timeRange:timeRange,timestamp:example.timestamp,tiebreaker:example.tiebreaker,context:example.context})))};const RegularExpressionRepresentation=Object(external_kbnSharedDeps_React_["memo"])(({maximumSegmentCount:maximumSegmentCount=30,regularExpression:regularExpression})=>{const segments=regularExpression.split(collapsedRegularExpressionCharacters);return external_kbnSharedDeps_React_default.a.createElement(CategoryPattern,null,segments.slice(0,maximumSegmentCount).map((segment,segmentIndex)=>[segmentIndex>0?external_kbnSharedDeps_React_default.a.createElement(CategoryPatternWildcard,{key:`wildcard-${segmentIndex}`},"⁕"):null,external_kbnSharedDeps_React_default.a.createElement(CategoryPatternSegment,{key:`segment-${segmentIndex}`},segment.replace(escapedRegularExpressionCharacters,"$1"))]),segments.length>maximumSegmentCount?external_kbnSharedDeps_React_default.a.createElement(CategoryPatternWildcard,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.truncatedPatternSegmentDescription",{defaultMessage:"{extraSegmentCount, plural, one {one more segment} other {# more segments}}",values:{extraSegmentCount:segments.length-maximumSegmentCount}})},"…"):null)});const CategoryPattern=common_["euiStyled"].span`
  font-family: ${props=>props.theme.eui.euiCodeFontFamily};
  word-break: break-all;
`;const CategoryPatternWildcard=common_["euiStyled"].span`
  color: ${props=>props.theme.eui.euiColorMediumShade};
`;const CategoryPatternSegment=common_["euiStyled"].span`
  font-weight: bold;
`;const collapsedRegularExpressionCharacters=/\.[+*]\??/g;const escapedRegularExpressionCharacters=/\\([\\^$*+?.()\[\]])/g;var job_parameters=__webpack_require__(153);const AnalyzeCategoryDatasetInMlAction=({categorizationJobId:categorizationJobId,categoryId:categoryId,dataset:dataset,timeRange:timeRange})=>{const{services:{ml:ml,http:http,application:application}}=Object(use_kibana["b"])();const viewAnomalyInMachineLearningLink=Object(ml_public_["useMlHref"])(ml,http.basePath.get(),{page:ml_public_["ML_PAGES"].SINGLE_METRIC_VIEWER,pageState:{jobIds:[categorizationJobId],timeRange:{from:external_kbnSharedDeps_Moment_default()(timeRange.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),to:external_kbnSharedDeps_Moment_default()(timeRange.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),mode:"absolute"},entities:{[job_parameters["i"]]:dataset,mlcategory:`${categoryId}`}}});const handleClick=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{if(!viewAnomalyInMachineLearningLink||!Object(use_link_props["a"])(e))return;application.navigateToUrl(viewAnomalyInMachineLearningLink)},[application,viewAnomalyInMachineLearningLink]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:analyseCategoryDatasetInMlTooltipDescription,delay:"long"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":analyseCategoryDatasetInMlButtonLabel,iconType:"machineLearningApp","data-test-subj":"analyzeCategoryDatasetInMlButton",href:viewAnomalyInMachineLearningLink,onClick:handleClick}))};const analyseCategoryDatasetInMlButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.analyzeCategoryInMlButtonLabel",{defaultMessage:"Analyze in ML"});const analyseCategoryDatasetInMlTooltipDescription=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.analyzeCategoryInMlTooltipDescription",{defaultMessage:"Analyze this category in the ML app."});const DatasetActionsList=({categorizationJobId:categorizationJobId,categoryId:categoryId,datasets:datasets,timeRange:timeRange})=>external_kbnSharedDeps_React_default.a.createElement("ul",null,datasets.map(dataset=>{const datasetLabel=Object(log_analysis["getFriendlyNameForPartitionId"])(dataset.name);return external_kbnSharedDeps_React_default.a.createElement("li",{key:datasetLabel},external_kbnSharedDeps_React_default.a.createElement(AnalyzeCategoryDatasetInMlAction,{categorizationJobId:categorizationJobId,categoryId:categoryId,dataset:dataset.name,timeRange:timeRange}))}));const DatasetsList=({datasets:datasets})=>external_kbnSharedDeps_React_default.a.createElement("ul",null,datasets.map(dataset=>{const datasetLabel=Object(log_analysis["getFriendlyNameForPartitionId"])(dataset.name);return external_kbnSharedDeps_React_default.a.createElement("li",{key:datasetLabel},external_kbnSharedDeps_React_default.a.createElement(DatasetLabel,null,datasetLabel))}));const DatasetLabel=common_["euiStyled"].div`
  display: inline-block;
  margin-bottom: 2.5px;
  margin-top: 1px;
`;const SingleMetricComparison=({currentValue:currentValue,previousValue:previousValue})=>{const changeFactor=currentValue/previousValue-1;if(changeFactor<0){return external_kbnSharedDeps_React_default.a.createElement(NoWrapSpan,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"sortDown",color:"danger"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"danger"},formatPercentage(changeFactor)))}else if(changeFactor>0&&Number.isFinite(changeFactor)){return external_kbnSharedDeps_React_default.a.createElement(NoWrapSpan,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"sortUp",color:"success"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"secondary"},formatPercentage(changeFactor)))}else if(changeFactor>0&&!Number.isFinite(changeFactor)){return external_kbnSharedDeps_React_default.a.createElement(NoWrapSpan,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"sortUp",color:"success"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"secondary"},newCategoryTrendLabel))}return null};const formatPercentage=value=>external_kbnSharedDeps_ElasticNumeral_default()(value).format("+0,0 %");const newCategoryTrendLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.newCategoryTrendLabel",{defaultMessage:"new"});const NoWrapSpan=common_["euiStyled"].span`
  white-space: nowrap;
`;var external_kbnSharedDeps_ElasticCharts_=__webpack_require__(69);var external_kbnSharedDeps_ElasticEuiChartsTheme_=__webpack_require__(79);var use_kibana_ui_setting=__webpack_require__(118);const timestampAccessor="timestamp";const valueAccessor=["value"];const sparklineSize={height:20,width:100};const SingleMetricSparkline=({metric:metric,timeRange:timeRange})=>{const[isDarkMode]=Object(use_kibana_ui_setting["a"])("theme:darkMode");const theme=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_SPARKLINE_THEME_PARTIAL"],isDarkMode?external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_DARK"].theme:external_kbnSharedDeps_ElasticEuiChartsTheme_["EUI_CHARTS_THEME_LIGHT"].theme],[isDarkMode]);const xDomain=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({max:timeRange.endTime,min:timeRange.startTime}),[timeRange]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Chart"],{size:sparklineSize},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["Settings"],{showLegend:false,theme:theme,tooltip:"none",xDomain:xDomain}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticCharts_["AreaSeries"],{data:metric,id:"metric",xAccessor:timestampAccessor,xScaleType:"time",yAccessors:valueAccessor}))};const LogEntryCountSparkline=({currentCount:currentCount,histograms:histograms,timeRange:timeRange})=>{const metric=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _histograms$find$buck,_histograms$find,_histograms$find$buck2;return(_histograms$find$buck=(_histograms$find=histograms.find(histogram=>histogram.histogramId==="history"))===null||_histograms$find===void 0?void 0:(_histograms$find$buck2=_histograms$find.buckets)===null||_histograms$find$buck2===void 0?void 0:_histograms$find$buck2.map(({startTime:timestamp,logEntryCount:value})=>({timestamp:timestamp,value:value})))!==null&&_histograms$find$buck!==void 0?_histograms$find$buck:[]},[histograms]);const referenceCount=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _histograms$find$buck3,_histograms$find2,_histograms$find2$buc,_histograms$find2$buc2;return(_histograms$find$buck3=(_histograms$find2=histograms.find(histogram=>histogram.histogramId==="reference"))===null||_histograms$find2===void 0?void 0:(_histograms$find2$buc=_histograms$find2.buckets)===null||_histograms$find2$buc===void 0?void 0:(_histograms$find2$buc2=_histograms$find2$buc[0])===null||_histograms$find2$buc2===void 0?void 0:_histograms$find2$buc2.logEntryCount)!==null&&_histograms$find$buck3!==void 0?_histograms$find$buck3:0},[histograms]);const overallTimeRange=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({endTime:timeRange.endTime,startTime:timeRange.startTime-(timeRange.endTime-timeRange.startTime)}),[timeRange.endTime,timeRange.startTime]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(SingleMetricSparkline,{metric:metric,timeRange:overallTimeRange}),external_kbnSharedDeps_React_default.a.createElement(SingleMetricComparison,{previousValue:referenceCount,currentValue:currentCount}))};const TopCategoriesTable=Object(common_["euiStyled"])(({categorizationJobId:categorizationJobId,className:className,sourceId:sourceId,timeRange:timeRange,topCategories:topCategories,sortOptions:sortOptions,changeSortOptions:changeSortOptions})=>{const tableSortOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({sort:sortOptions}),[sortOptions]);const handleTableChange=Object(external_kbnSharedDeps_React_["useCallback"])(({sort:sort={}})=>{changeSortOptions(sort)},[changeSortOptions]);const[expandedCategories,{add:expandCategory,remove:collapseCategory}]=useSet_default()(new Set);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>createColumns(timeRange,categorizationJobId,expandedCategories,expandCategory,collapseCategory),[categorizationJobId,collapseCategory,expandCategory,expandedCategories,timeRange]);const expandedRowContentsById=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[...expandedCategories].reduce((aggregatedCategoryRows,categoryId)=>({...aggregatedCategoryRows,[categoryId]:external_kbnSharedDeps_React_default.a.createElement(CategoryDetailsRow,{categoryId:categoryId,sourceId:sourceId,timeRange:timeRange})}),{}),[expandedCategories,sourceId,timeRange]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{columns:columns,itemIdToExpandedRowMap:expandedRowContentsById,itemId:"categoryId",items:topCategories,rowProps:{className:`${className} euiTableRow--topAligned`},onChange:handleTableChange,sorting:tableSortOptions})})`
  &.euiTableRow--topAligned .euiTableRowCell {
    vertical-align: top;
  }
`;const createColumns=(timeRange,categorizationJobId,expandedCategories,expandCategory,collapseCategory)=>[{align:"right",field:"logEntryCount",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.countColumnTitle",{defaultMessage:"Message count"}),sortable:true,render:logEntryCount=>external_kbnSharedDeps_ElasticNumeral_default()(logEntryCount).format("0,0"),width:"120px"},{field:"histograms",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.trendColumnTitle",{defaultMessage:"Trend"}),render:(histograms,item)=>external_kbnSharedDeps_React_default.a.createElement(LogEntryCountSparkline,{currentCount:item.logEntryCount,histograms:histograms,timeRange:timeRange}),width:"220px"},{field:"regularExpression",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.categoryColumnTitle",{defaultMessage:"Category"}),truncateText:true,render:regularExpression=>external_kbnSharedDeps_React_default.a.createElement(RegularExpressionRepresentation,{regularExpression:regularExpression})},{field:"datasets",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.datasetColumnTitle",{defaultMessage:"Datasets"}),render:datasets=>external_kbnSharedDeps_React_default.a.createElement(DatasetsList,{datasets:datasets}),width:"200px"},{align:"right",field:"maximumAnomalyScore",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.maximumAnomalyScoreColumnTitle",{defaultMessage:"Maximum anomaly score"}),sortable:true,render:(_maximumAnomalyScore,item)=>external_kbnSharedDeps_React_default.a.createElement(AnomalySeverityIndicatorList,{datasets:item.datasets}),width:"160px"},{actions:[{render:category=>external_kbnSharedDeps_React_default.a.createElement(DatasetActionsList,{categorizationJobId:categorizationJobId,categoryId:category.categoryId,datasets:category.datasets,timeRange:timeRange})}],width:"40px"},{align:"right",isExpander:true,render:item=>external_kbnSharedDeps_React_default.a.createElement(RowExpansionButton,{isExpanded:expandedCategories.has(item.categoryId),item:item.categoryId,onCollapse:collapseCategory,onExpand:expandCategory}),width:"40px"}];const TopCategoriesSection=({availableDatasets:availableDatasets,hasSetupCapabilities:hasSetupCapabilities,isLoadingDatasets:isLoadingDatasets=false,isLoadingTopCategories:isLoadingTopCategories=false,jobId:jobId,onChangeDatasetSelection:onChangeDatasetSelection,onRequestRecreateMlJob:onRequestRecreateMlJob,selectedDatasets:selectedDatasets,sourceId:sourceId,timeRange:timeRange,topCategories:topCategories,sortOptions:sortOptions,changeSortOptions:changeSortOptions})=>{const{services:{ml:ml,http:http}}=Object(use_kibana["b"])();const analyzeInMlLink=Object(ml_public_["useMlHref"])(ml,http.basePath.get(),{page:ml_public_["ML_PAGES"].ANOMALY_EXPLORER,pageState:{jobIds:[jobId],timeRange:{from:external_kbnSharedDeps_Moment_default()(timeRange.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),to:external_kbnSharedDeps_Moment_default()(timeRange.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),mode:"absolute"}}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m","aria-label":top_categories_section_title},external_kbnSharedDeps_React_default.a.createElement("h1",null,top_categories_section_title," ",external_kbnSharedDeps_React_default.a.createElement(BetaBadge,null)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(create_job_button["b"],{hasSetupCapabilities:hasSetupCapabilities,onClick:onRequestRecreateMlJob,size:"s"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(AnalyzeInMlButton,{href:analyzeInMlLink}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(DatasetsSelector,{availableDatasets:availableDatasets,isLoading:isLoadingDatasets,onChangeDatasetSelection:onChangeDatasetSelection,selectedDatasets:selectedDatasets}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(loading_overlay_wrapper["a"],{isLoading:isLoadingTopCategories,loadingChildren:external_kbnSharedDeps_React_default.a.createElement(LoadingOverlayContent,null)},external_kbnSharedDeps_React_default.a.createElement(TopCategoriesTable,{categorizationJobId:jobId,sourceId:sourceId,timeRange:timeRange,topCategories:topCategories,sortOptions:sortOptions,changeSortOptions:changeSortOptions})))};const top_categories_section_title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.topCategoriesSectionTitle",{defaultMessage:"Log message categories"});const loadingAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.topCategoriesSectionLoadingAriaLabel",{defaultMessage:"Loading message categories"});const LoadingOverlayContent=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl","aria-label":loadingAriaLabel});const callGetTopLogEntryCategoriesAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,startTime:startTime,endTime:endTime,categoryCount:categoryCount,datasets:datasets,sort:sort}=requestArgs;const intervalDuration=endTime-startTime;const response=await fetch(http_api_log_analysis["d"],{method:"POST",body:JSON.stringify(http_api_log_analysis["p"].encode({data:{sourceId:sourceId,timeRange:{startTime:startTime,endTime:endTime},categoryCount:categoryCount,datasets:datasets,histograms:[{id:"history",timeRange:{startTime:startTime-intervalDuration,endTime:endTime},bucketCount:10},{id:"reference",timeRange:{startTime:startTime-intervalDuration,endTime:startTime},bucketCount:1}],sort:sort}}))});return Object(runtime_types["b"])(http_api_log_analysis["q"])(response)};const callGetLogEntryCategoryDatasetsAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,startTime:startTime,endTime:endTime}=requestArgs;const response=await fetch(http_api_log_analysis["e"],{method:"POST",body:JSON.stringify(http_api_log_analysis["r"].encode({data:{sourceId:sourceId,timeRange:{startTime:startTime,endTime:endTime}}}))});return Object(runtime_types["b"])(http_api_log_analysis["s"])(response)};const useLogEntryCategoriesResults=({categoriesCount:categoriesCount,filteredDatasets:filteredDatasets,endTime:endTime,onGetLogEntryCategoryDatasetsError:onGetLogEntryCategoryDatasetsError,onGetTopLogEntryCategoriesError:onGetTopLogEntryCategoriesError,sourceId:sourceId,startTime:startTime})=>{const[sortOptions,setSortOptions]=Object(external_kbnSharedDeps_React_["useState"])({field:"maximumAnomalyScore",direction:"desc"});const{services:services}=Object(use_kibana["b"])();const[topLogEntryCategories,setTopLogEntryCategories]=Object(external_kbnSharedDeps_React_["useState"])([]);const[logEntryCategoryDatasets,setLogEntryCategoryDatasets]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getTopLogEntryCategoriesRequest,getTopLogEntryCategories]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async()=>await callGetTopLogEntryCategoriesAPI({sourceId:sourceId,startTime:startTime,endTime:endTime,categoryCount:categoriesCount,datasets:filteredDatasets,sort:sortOptions},services.http.fetch),onResolve:({data:{categories:categories}})=>{setTopLogEntryCategories(categories)},onReject:error=>{if(error instanceof Error&&!(error instanceof use_tracked_promise["a"])&&onGetTopLogEntryCategoriesError){onGetTopLogEntryCategoriesError(error)}}},[categoriesCount,endTime,filteredDatasets,sourceId,startTime,sortOptions]);const[getLogEntryCategoryDatasetsRequest,getLogEntryCategoryDatasets]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async()=>await callGetLogEntryCategoryDatasetsAPI({sourceId:sourceId,startTime:startTime,endTime:endTime},services.http.fetch),onResolve:({data:{datasets:datasets}})=>{setLogEntryCategoryDatasets(datasets)},onReject:error=>{if(error instanceof Error&&!(error instanceof use_tracked_promise["a"])&&onGetLogEntryCategoryDatasetsError){onGetLogEntryCategoryDatasetsError(error)}}},[categoriesCount,endTime,sourceId,startTime]);const isLoadingTopLogEntryCategories=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getTopLogEntryCategoriesRequest.state==="pending",[getTopLogEntryCategoriesRequest.state]);const isLoadingLogEntryCategoryDatasets=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryCategoryDatasetsRequest.state==="pending",[getLogEntryCategoryDatasetsRequest.state]);const isLoading=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isLoadingTopLogEntryCategories||isLoadingLogEntryCategoryDatasets,[isLoadingLogEntryCategoryDatasets,isLoadingTopLogEntryCategories]);return{getLogEntryCategoryDatasets:getLogEntryCategoryDatasets,getTopLogEntryCategories:getTopLogEntryCategories,isLoading:isLoading,isLoadingLogEntryCategoryDatasets:isLoadingLogEntryCategoryDatasets,isLoadingTopLogEntryCategories:isLoadingTopLogEntryCategories,logEntryCategoryDatasets:logEntryCategoryDatasets,topLogEntryCategories:topLogEntryCategories,sortOptions:sortOptions,changeSortOptions:setSortOptions}};var Either=__webpack_require__(14);var lib_function=__webpack_require__(15);var pipeable=__webpack_require__(22);var use_url_state=__webpack_require__(104);var use_kibana_timefilter_time=__webpack_require__(111);const autoRefreshRT=lib["union"]([lib["type"]({interval:lib["number"],isPaused:lib["boolean"]}),lib["undefined"]]);const stringTimeRangeRT=lib["type"]({startTime:lib["string"],endTime:lib["string"]});const urlTimeRangeRT=lib["union"]([stringTimeRangeRT,lib["undefined"]]);const TIME_RANGE_URL_STATE_KEY="timeRange";const AUTOREFRESH_URL_STATE_KEY="autoRefresh";const TIME_DEFAULTS={from:"now-2w",to:"now"};const useLogEntryCategoriesResultsUrlState=()=>{const[getTime]=Object(use_kibana_timefilter_time["a"])(TIME_DEFAULTS);const{from:start,to:end}=getTime();const[timeRange,setTimeRange]=Object(use_url_state["b"])({defaultState:{startTime:start,endTime:end},decodeUrlState:value=>Object(pipeable["pipe"])(urlTimeRangeRT.decode(value),Object(Either["fold"])(Object(lib_function["constant"])(undefined),lib_function["identity"])),encodeUrlState:urlTimeRangeRT.encode,urlStateKey:TIME_RANGE_URL_STATE_KEY,writeDefaultState:true});Object(use_kibana_timefilter_time["b"])(TIME_DEFAULTS,{from:timeRange.startTime,to:timeRange.endTime});const[autoRefresh,setAutoRefresh]=Object(use_url_state["b"])({defaultState:{isPaused:false,interval:6e4},decodeUrlState:value=>Object(pipeable["pipe"])(autoRefreshRT.decode(value),Object(Either["fold"])(Object(lib_function["constant"])(undefined),lib_function["identity"])),encodeUrlState:autoRefreshRT.encode,urlStateKey:AUTOREFRESH_URL_STATE_KEY,writeDefaultState:true});return{timeRange:timeRange,setTimeRange:setTimeRange,autoRefresh:autoRefresh,setAutoRefresh:setAutoRefresh}};const JOB_STATUS_POLLING_INTERVAL=3e4;const LogEntryCategoriesResultsContent=({onOpenSetup:onOpenSetup})=>{Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_categories_results"});Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_categories_results",delay:15e3});const{hasLogAnalysisSetupCapabilities:hasLogAnalysisSetupCapabilities}=useLogAnalysisCapabilitiesContext();const{fetchJobStatus:fetchJobStatus,fetchModuleDefinition:fetchModuleDefinition,moduleDescriptor:moduleDescriptor,setupStatus:setupStatus,hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasStoppedJobs:hasStoppedJobs,jobIds:jobIds,categoryQualityWarnings:categoryQualityWarnings,sourceConfiguration:{sourceId:sourceId}}=useLogEntryCategoriesModuleContext();const{timeRange:selectedTimeRange,setTimeRange:setSelectedTimeRange,autoRefresh:autoRefresh,setAutoRefresh:setAutoRefresh}=useLogEntryCategoriesResultsUrlState();const[categoryQueryTimeRange,setCategoryQueryTimeRange]=Object(external_kbnSharedDeps_React_["useState"])(()=>({lastChangedTime:Date.now(),timeRange:stringToNumericTimeRange(selectedTimeRange)}));const[categoryQueryDatasets,setCategoryQueryDatasets]=Object(external_kbnSharedDeps_React_["useState"])([]);const{services:services}=Object(kibanaReact_public_["useKibana"])();const showLoadDataErrorNotification=Object(external_kbnSharedDeps_React_["useCallback"])(error=>{var _services$notificatio;(_services$notificatio=services.notifications)===null||_services$notificatio===void 0?void 0:_services$notificatio.toasts.addError(error,{title:loadDataErrorTitle})},[services.notifications]);const{getLogEntryCategoryDatasets:getLogEntryCategoryDatasets,getTopLogEntryCategories:getTopLogEntryCategories,isLoadingLogEntryCategoryDatasets:isLoadingLogEntryCategoryDatasets,isLoadingTopLogEntryCategories:isLoadingTopLogEntryCategories,logEntryCategoryDatasets:logEntryCategoryDatasets,topLogEntryCategories:topLogEntryCategories,sortOptions:sortOptions,changeSortOptions:changeSortOptions}=useLogEntryCategoriesResults({categoriesCount:25,endTime:categoryQueryTimeRange.timeRange.endTime,filteredDatasets:categoryQueryDatasets,onGetTopLogEntryCategoriesError:showLoadDataErrorNotification,sourceId:sourceId,startTime:categoryQueryTimeRange.timeRange.startTime});const handleQueryTimeRangeChange=Object(external_kbnSharedDeps_React_["useCallback"])(({start:startTime,end:endTime})=>{setCategoryQueryTimeRange(previousQueryParameters=>({...previousQueryParameters,timeRange:stringToNumericTimeRange({startTime:startTime,endTime:endTime}),lastChangedTime:Date.now()}))},[setCategoryQueryTimeRange]);const handleSelectedTimeRangeChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedTime=>{if(selectedTime.isInvalid){return}setSelectedTimeRange({startTime:selectedTime.start,endTime:selectedTime.end});handleQueryTimeRangeChange(selectedTime)},[setSelectedTimeRange,handleQueryTimeRangeChange]);const handleAutoRefreshChange=Object(external_kbnSharedDeps_React_["useCallback"])(({isPaused:isPaused,refreshInterval:interval})=>{setAutoRefresh({isPaused:isPaused,interval:interval})},[setAutoRefresh]);const hasResults=Object(external_kbnSharedDeps_React_["useMemo"])(()=>topLogEntryCategories.length>0,[topLogEntryCategories.length]);const isFirstUse=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(setupStatus.type==="skipped"&&!!setupStatus.newlyCreated||setupStatus.type==="succeeded")&&!hasResults,[hasResults,setupStatus]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getTopLogEntryCategories()},[getTopLogEntryCategories,categoryQueryDatasets,categoryQueryTimeRange.lastChangedTime,sortOptions]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getLogEntryCategoryDatasets()},[getLogEntryCategoryDatasets,categoryQueryTimeRange.lastChangedTime]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{fetchModuleDefinition()},[fetchModuleDefinition]);useInterval_default()(()=>{fetchJobStatus()},JOB_STATUS_POLLING_INTERVAL);useInterval_default()(()=>{handleQueryTimeRangeChange({start:selectedTimeRange.startTime,end:selectedTimeRange.endTime})},autoRefresh.isPaused?null:autoRefresh.interval);return external_kbnSharedDeps_React_default.a.createElement(ViewLogInContext.Provider,{sourceId:sourceId,startTimestamp:categoryQueryTimeRange.timeRange.startTime,endTimestamp:categoryQueryTimeRange.timeRange.endTime},external_kbnSharedDeps_React_default.a.createElement(ResultsContentPage,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{start:selectedTimeRange.startTime,end:selectedTimeRange.endTime,onTimeChange:handleSelectedTimeRangeChange,isPaused:autoRefresh.isPaused,refreshInterval:autoRefresh.interval,onRefreshChange:handleAutoRefreshChange})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(CategoryJobNoticesSection,{hasOutdatedJobConfigurations:hasOutdatedJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedJobDefinitions,hasSetupCapabilities:hasLogAnalysisSetupCapabilities,hasStoppedJobs:hasStoppedJobs,isFirstUse:isFirstUse,moduleName:moduleDescriptor.moduleName,onRecreateMlJobForReconfiguration:onOpenSetup,onRecreateMlJobForUpdate:onOpenSetup,qualityWarnings:categoryQualityWarnings})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"m"},external_kbnSharedDeps_React_default.a.createElement(TopCategoriesSection,{availableDatasets:logEntryCategoryDatasets,hasSetupCapabilities:hasLogAnalysisSetupCapabilities,isLoadingDatasets:isLoadingLogEntryCategoryDatasets,isLoadingTopCategories:isLoadingTopLogEntryCategories,jobId:jobIds["log-entry-categories-count"],onChangeDatasetSelection:setCategoryQueryDatasets,onRequestRecreateMlJob:onOpenSetup,selectedDatasets:categoryQueryDatasets,sourceId:sourceId,timeRange:categoryQueryTimeRange.timeRange,topCategories:topLogEntryCategories,sortOptions:sortOptions,changeSortOptions:changeSortOptions}))))),external_kbnSharedDeps_React_default.a.createElement(PageViewLogInContext,null))};const stringToNumericTimeRange=timeRange=>({startTime:external_kbnSharedDeps_Moment_default()(elastic_datemath_default.a.parse(timeRange.startTime,{momentInstance:external_kbnSharedDeps_Moment_default.a})).valueOf(),endTime:external_kbnSharedDeps_Moment_default()(elastic_datemath_default.a.parse(timeRange.endTime,{momentInstance:external_kbnSharedDeps_Moment_default.a,roundUp:true})).valueOf()});const ResultsContentPage=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPage"])`
  flex: 1 0 0%;
  flex-direction: column;

  .euiFlexGroup--responsive > .euiFlexItem {
    flex-basis: auto !important;
  }
`;const loadDataErrorTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.loadDataErrorTitle",{defaultMessage:"Failed to load category data"});const LogEntryCategoriesSetupContent=({onOpenSetup:onOpenSetup})=>{Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_categories_setup"});Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_categories_setup",delay:15e3});return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["a"],{"data-test-subj":"logEntryCategoriesSetupPage"},external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["c"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryCategories.setupTitle",defaultMessage:"Set up log category analysis"})),external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["b"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryCategories.setupDescription",defaultMessage:"To enable log categories, set up a machine learning job."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,onClick:onOpenSetup},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryCategories.showAnalysisSetupButtonLabel",defaultMessage:"ML setup"}))))};const LogEntryCategoriesPageContent=()=>{const{hasFailedLoadingSource:hasFailedLoadingSource,isLoading:isLoading,isUninitialized:isUninitialized,loadSource:loadSource,loadSourceFailureMessage:loadSourceFailureMessage}=Object(log_source["c"])();const{hasLogAnalysisCapabilites:hasLogAnalysisCapabilites,hasLogAnalysisReadCapabilities:hasLogAnalysisReadCapabilities,hasLogAnalysisSetupCapabilities:hasLogAnalysisSetupCapabilities}=useLogAnalysisCapabilitiesContext();const{fetchJobStatus:fetchJobStatus,setupStatus:setupStatus,jobStatus:jobStatus}=useLogEntryCategoriesModuleContext();const{showModuleSetup:showModuleSetup}=useLogAnalysisSetupFlyoutStateContext();const showCategoriesModuleSetup=Object(external_kbnSharedDeps_React_["useCallback"])(()=>showModuleSetup("logs_ui_categories"),[showModuleSetup]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasLogAnalysisReadCapabilities){fetchJobStatus()}},[fetchJobStatus,hasLogAnalysisReadCapabilities]);if(isLoading||isUninitialized){return external_kbnSharedDeps_React_default.a.createElement(source_loading_page["a"],null)}else if(hasFailedLoadingSource){return external_kbnSharedDeps_React_default.a.createElement(source_error_page["a"],{errorMessage:loadSourceFailureMessage!==null&&loadSourceFailureMessage!==void 0?loadSourceFailureMessage:"",retry:loadSource})}else if(!hasLogAnalysisCapabilites){return external_kbnSharedDeps_React_default.a.createElement(subscription_splash_content["a"],null)}else if(!hasLogAnalysisReadCapabilities){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["e"],null)}else if(setupStatus.type==="initializing"){return external_kbnSharedDeps_React_default.a.createElement(loading_page["a"],{message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.logEntryCategories.jobStatusLoadingMessage",{defaultMessage:"Checking status of categorization jobs..."})})}else if(setupStatus.type==="unknown"){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["d"],{retry:fetchJobStatus})}else if(Object(log_analysis["isJobStatusWithResults"])(jobStatus["log-entry-categories-count"])){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesResultsContent,{onOpenSetup:showCategoriesModuleSetup}),external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyout,{allowedModules:allowedSetupModules}))}else if(!hasLogAnalysisSetupCapabilities){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["f"],null)}else{return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesSetupContent,{onOpenSetup:showCategoriesModuleSetup}),external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyout,{allowedModules:allowedSetupModules}))}};const allowedSetupModules=["logs_ui_categories"];var use_kibana_space=__webpack_require__(200);const LogEntryCategoriesPageProviders=({children:children})=>{const{sourceConfiguration:sourceConfiguration,sourceId:sourceId}=Object(log_source["c"])();const{space:space}=Object(use_kibana_space["a"])();if((sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.configuration.logAlias)==null||space==null){return null}return external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesModuleProvider,{indexPattern:sourceConfiguration.configuration.logAlias,sourceId:sourceId,spaceId:space.id,timestampField:sourceConfiguration.configuration.fields.timestamp},external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyoutStateProvider,null,children))};const LogEntryCategoriesPage=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesPageProviders,null,external_kbnSharedDeps_React_default.a.createElement(components_page["a"],{"data-test-subj":"logsLogEntryCategoriesPage"},external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesPageContent,null))));var query_string=__webpack_require__(34);var log_entry=__webpack_require__(133);var common_errors=__webpack_require__(252);const LOG_ENTRY_SEARCH_STRATEGY="infra-log-entry";const logEntrySearchRequestParamsRT=lib["type"]({sourceId:lib["string"],logEntryId:lib["string"]});const logEntryRT=lib["type"]({id:lib["string"],index:lib["string"],fields:lib["array"](log_entry["e"]),cursor:log_entry["d"]});const logEntrySearchResponsePayloadRT=lib["intersection"]([lib["type"]({data:lib["union"]([logEntryRT,lib["null"]])}),lib["partial"]({errors:lib["array"](common_errors["a"])})]);var data_search=__webpack_require__(157);const useLogEntry=({sourceId:sourceId,logEntryId:logEntryId})=>{const{search:fetchLogEntry,requests$:logEntrySearchRequests$}=Object(data_search["useDataSearch"])({getRequest:Object(external_kbnSharedDeps_React_["useCallback"])(()=>!!logEntryId&&!!sourceId?{request:{params:logEntrySearchRequestParamsRT.encode({sourceId:sourceId,logEntryId:logEntryId})},options:{strategy:LOG_ENTRY_SEARCH_STRATEGY}}:null,[sourceId,logEntryId]),parseResponses:parseLogEntrySearchResponses});const{cancelRequest:cancelRequest,isRequestRunning:isRequestRunning,isResponsePartial:isResponsePartial,latestResponseData:latestResponseData,latestResponseErrors:latestResponseErrors,loaded:loaded,total:total}=Object(data_search["useLatestPartialDataSearchResponse"])(logEntrySearchRequests$);return{cancelRequest:cancelRequest,errors:latestResponseErrors,fetchLogEntry:fetchLogEntry,isRequestRunning:isRequestRunning,isResponsePartial:isResponsePartial,loaded:loaded,logEntry:latestResponseData!==null&&latestResponseData!==void 0?latestResponseData:null,total:total}};const parseLogEntrySearchResponses=Object(data_search["normalizeDataSearchResponses"])(null,Object(runtime_types["b"])(logEntrySearchResponsePayloadRT));const CenteredEuiFlyoutBody=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"])`
  & .euiFlyoutBody__overflow {
    display: flex;
    flex-direction: column;
  }

  & .euiFlyoutBody__overflowContent {
    align-items: center;
    align-self: stretch;
    display: flex;
    flex-direction: column;
    flex-grow: 1;
    justify-content: center;
    overflow: hidden;
  }
`;const DataSearchErrorCallout=({errors:errors,onRetry:onRetry,title:title})=>{const calloutColor=errors.some(error=>error.type!=="aborted")?"danger":"warning";return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:calloutColor,iconType:"alert",title:title},errors===null||errors===void 0?void 0:errors.map((error,errorIndex)=>external_kbnSharedDeps_React_default.a.createElement(DataSearchErrorMessage,{key:errorIndex,error:error})),onRetry?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:calloutColor,size:"s",onClick:onRetry},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.dataSearch.loadingErrorRetryButtonLabel",defaultMessage:"Retry"})):null)};const DataSearchErrorMessage=({error:error})=>{if(error.type==="aborted"){return external_kbnSharedDeps_React_default.a.createElement(AbortedRequestErrorMessage,{error:error})}else if(error.type==="shardFailure"){return external_kbnSharedDeps_React_default.a.createElement(ShardFailureErrorMessage,{error:error})}else{return external_kbnSharedDeps_React_default.a.createElement(GenericErrorMessage,{error:error})}};const AbortedRequestErrorMessage=({})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{tagName:"p",id:"xpack.infra.dataSearch.abortedRequestErrorMessage",defaultMessage:"The request was aborted."});const GenericErrorMessage=({error:error})=>{var _error$message;return external_kbnSharedDeps_React_default.a.createElement("p",null,(_error$message=error.message)!==null&&_error$message!==void 0?_error$message:`${error}`)};const ShardFailureErrorMessage=({error:error})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{tagName:"p",id:"xpack.infra.dataSearch.shardFailureErrorMessage",defaultMessage:"Index {indexName}: {errorMessage}",values:{indexName:error.shardInfo.index,errorMessage:error.message}});const DataSearchProgress=({label:label,maxValue:maxValue,onCancel:onCancel,value:value})=>{const valueText=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Number.isFinite(maxValue)&&Number.isFinite(value)?`${value} / ${maxValue}`:undefined,[value,maxValue]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiProgress"],{label:label,size:"s",max:maxValue,value:value,valueText:valueText})),onCancel?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{color:"danger",iconType:"cross",onClick:onCancel,title:cancelButtonLabel,"aria-label":cancelButtonLabel})):null)};const cancelButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.dataSearch.cancelButtonLabel",{defaultMessage:"Cancel request"});var use_visibility_state=__webpack_require__(155);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const UPTIME_FIELDS=["container.id","host.ip","kubernetes.pod.uid"];const LogEntryActionsMenu=({logEntry:logEntry})=>{const{hide:hide,isVisible:isVisible,show:show}=Object(use_visibility_state["a"])(false);const apmLinkDescriptor=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getAPMLink(logEntry),[logEntry]);const uptimeLinkDescriptor=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getUptimeLink(logEntry),[logEntry]);const uptimeLinkProps=Object(use_link_props["b"])({app:"uptime",...uptimeLinkDescriptor?uptimeLinkDescriptor:{}});const apmLinkProps=Object(use_link_props["b"])({app:"apm",...apmLinkDescriptor?apmLinkDescriptor:{}});const menuItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],_extends({"data-test-subj":"logEntryActionsMenuItem uptimeLogEntryActionsMenuItem",disabled:!uptimeLinkDescriptor,icon:"uptimeApp",key:"uptimeLink"},uptimeLinkProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logEntryActionsMenu.uptimeActionLabel",defaultMessage:"View status in Uptime"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],_extends({"data-test-subj":"logEntryActionsMenuItem apmLogEntryActionsMenuItem",disabled:!apmLinkDescriptor,icon:"apmApp",key:"apmLink"},apmLinkProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logEntryActionsMenu.apmActionLabel",defaultMessage:"View in APM"}))],[uptimeLinkDescriptor,apmLinkDescriptor,apmLinkProps,uptimeLinkProps]);const hasMenuItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>menuItems.length>0,[menuItems]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{anchorPosition:"downRight",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"logEntryActionsMenuButton",disabled:!hasMenuItems,iconSide:"right",iconType:"arrowDown",onClick:show},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logEntryActionsMenu.buttonLabel",defaultMessage:"Investigate"})),closePopover:hide,id:"logEntryActionsMenu",isOpen:isVisible,panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:menuItems}))};const getUptimeLink=logEntry=>{const searchExpressions=logEntry.fields.filter(({field:field,value:value})=>value!=null&&UPTIME_FIELDS.includes(field)).reduce((acc,fieldItem)=>{const{field:field,value:value}=fieldItem;return acc.concat(value.map(val=>`${field}:${val}`))},[]);if(searchExpressions.length===0){return undefined}return{app:"uptime",hash:"/",search:{search:`${searchExpressions.join(" or ")}`}}};const getAPMLink=logEntry=>{var _logEntry$fields$find,_logEntry$fields$find2;const traceId=(_logEntry$fields$find=logEntry.fields.find(({field:field,value:value})=>typeof value[0]==="string"&&field==="trace.id"))===null||_logEntry$fields$find===void 0?void 0:(_logEntry$fields$find2=_logEntry$fields$find.value)===null||_logEntry$fields$find2===void 0?void 0:_logEntry$fields$find2[0];if(typeof traceId!=="string"){return undefined}const timestampField=logEntry.fields.find(({field:field})=>field==="@timestamp");const timestamp=timestampField?timestampField.value[0]:null;const{rangeFrom:rangeFrom,rangeTo:rangeTo}=typeof timestamp==="number"?(()=>{const from=new Date(timestamp);const to=new Date(timestamp);from.setMinutes(from.getMinutes()-10);to.setMinutes(to.getMinutes()+10);return{rangeFrom:from.toISOString(),rangeTo:to.toISOString()}})():{rangeFrom:"now-1y",rangeTo:"now"};return{app:"apm",pathname:Object(observability_public_["getApmTraceUrl"])({traceId:traceId,rangeFrom:rangeFrom,rangeTo:rangeTo})}};var field_value=__webpack_require__(213);const LogEntryFieldsTable=({logEntry:logEntry,onSetFieldFilter:onSetFieldFilter})=>{const createSetFilterHandler=Object(external_kbnSharedDeps_React_["useMemo"])(()=>onSetFieldFilter?field=>()=>{onSetFieldFilter===null||onSetFieldFilter===void 0?void 0:onSetFieldFilter(`${field.field}:"${field.value}"`,logEntry.id,logEntry.cursor)}:undefined,[logEntry,onSetFieldFilter]);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{field:"field",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logFlyout.fieldColumnLabel",{defaultMessage:"Field"}),sortable:true},{actions:[{type:"icon",icon:"filter",name:setFilterButtonLabel,description:setFilterButtonDescription,available:()=>!!createSetFilterHandler,onClick:item=>createSetFilterHandler===null||createSetFilterHandler===void 0?void 0:createSetFilterHandler(item)()}]},{field:"value",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logFlyout.valueColumnLabel",{defaultMessage:"Value"}),render:(_name,item)=>external_kbnSharedDeps_React_default.a.createElement(field_value["a"],{highlightTerms:emptyHighlightTerms,isActiveHighlight:false,value:item.value})}],[createSetFilterHandler]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{columns:columns,items:logEntry.fields,search:searchOptions,sorting:initialSortingOptions})};const emptyHighlightTerms=[];const initialSortingOptions={sort:{field:"field",direction:"asc"}};const searchOptions={box:{incremental:true,schema:true}};const setFilterButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logFlyout.filterAriaLabel",{defaultMessage:"Filter"});const setFilterButtonDescription=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logFlyout.setFilterTooltip",{defaultMessage:"View event with filter"});const LogEntryFlyout=({logEntryId:logEntryId,onCloseFlyout:onCloseFlyout,onSetFieldFilter:onSetFieldFilter,sourceId:sourceId})=>{var _logEntryErrors$lengt;const{cancelRequest:cancelLogEntryRequest,errors:logEntryErrors,fetchLogEntry:fetchLogEntry,isRequestRunning:isRequestRunning,loaded:logEntryRequestProgress,logEntry:logEntry,total:logEntryRequestTotal}=useLogEntry({sourceId:sourceId,logEntryId:logEntryId});Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(sourceId&&logEntryId){fetchLogEntry()}},[fetchLogEntry,sourceId,logEntryId]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onCloseFlyout,size:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",{id:"flyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Details for log entry {logEntryId}",id:"xpack.infra.logFlyout.flyoutTitle",values:{logEntryId:logEntryId?external_kbnSharedDeps_React_default.a.createElement("code",null,logEntryId):""}}))),logEntry?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logFlyout.flyoutSubTitle",defaultMessage:"From index {indexName}",values:{indexName:external_kbnSharedDeps_React_default.a.createElement("code",null,logEntry.index)}}))):null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{padding:8},grow:false},logEntry?external_kbnSharedDeps_React_default.a.createElement(LogEntryActionsMenu,{logEntry:logEntry}):null))),isRequestRunning?external_kbnSharedDeps_React_default.a.createElement(CenteredEuiFlyoutBody,null,external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"75%"}},external_kbnSharedDeps_React_default.a.createElement(DataSearchProgress,{label:loadingProgressMessage,maxValue:logEntryRequestTotal,onCancel:cancelLogEntryRequest,value:logEntryRequestProgress}))):logEntry?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],{banner:((_logEntryErrors$lengt=logEntryErrors===null||logEntryErrors===void 0?void 0:logEntryErrors.length)!==null&&_logEntryErrors$lengt!==void 0?_logEntryErrors$lengt:0)>0?external_kbnSharedDeps_React_default.a.createElement(DataSearchErrorCallout,{title:loadingErrorCalloutTitle,errors:logEntryErrors!==null&&logEntryErrors!==void 0?logEntryErrors:[],onRetry:fetchLogEntry}):undefined},external_kbnSharedDeps_React_default.a.createElement(LogEntryFieldsTable,{logEntry:logEntry,onSetFieldFilter:onSetFieldFilter})):external_kbnSharedDeps_React_default.a.createElement(CenteredEuiFlyoutBody,null,external_kbnSharedDeps_React_default.a.createElement("div",{style:{width:"75%"}},external_kbnSharedDeps_React_default.a.createElement(DataSearchErrorCallout,{title:loadingErrorCalloutTitle,errors:logEntryErrors!==null&&logEntryErrors!==void 0?logEntryErrors:[],onRetry:fetchLogEntry}))))};const loadingProgressMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logFlyout.loadingMessage",{defaultMessage:"Searching log entry in shards"});const loadingErrorCalloutTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logFlyout.loadingErrorCalloutTitle",{defaultMessage:"Error while searching the log entry"});var url_state=__webpack_require__(110);let FlyoutVisibility;(function(FlyoutVisibility){FlyoutVisibility["hidden"]="hidden";FlyoutVisibility["visible"]="visible"})(FlyoutVisibility||(FlyoutVisibility={}));const useLogFlyout=()=>{const[isFlyoutOpen,setIsFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[logEntryId,setLogEntryId]=Object(external_kbnSharedDeps_React_["useState"])(null);const[surroundingLogsId,setSurroundingLogsId]=Object(external_kbnSharedDeps_React_["useState"])(null);const closeFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsFlyoutOpen(false),[]);const openFlyout=Object(external_kbnSharedDeps_React_["useCallback"])(newLogEntryId=>{if(newLogEntryId){setLogEntryId(newLogEntryId)}setIsFlyoutOpen(true)},[]);return{isFlyoutOpen:isFlyoutOpen,closeFlyout:closeFlyout,openFlyout:openFlyout,logEntryId:logEntryId,setLogEntryId:setLogEntryId,surroundingLogsId:surroundingLogsId,setSurroundingLogsId:setSurroundingLogsId}};const LogFlyout=constate_cjs_default()(useLogFlyout);const[LogEntryFlyoutProvider,useLogEntryFlyoutContext]=LogFlyout;const WithFlyoutOptionsUrlState=()=>{const{isFlyoutOpen:isFlyoutOpen,openFlyout:openFlyout,closeFlyout:closeFlyout,logEntryId:logEntryId,setLogEntryId:setLogEntryId,surroundingLogsId:surroundingLogsId,setSurroundingLogsId:setSurroundingLogsId}=useLogEntryFlyoutContext();return external_kbnSharedDeps_React_default.a.createElement(url_state["a"],{urlState:{flyoutVisibility:isFlyoutOpen?FlyoutVisibility.visible:FlyoutVisibility.hidden,flyoutId:logEntryId,surroundingLogsId:surroundingLogsId},urlStateKey:"flyoutOptions",mapToUrlState:mapToUrlState,onChange:newUrlState=>{if(newUrlState&&newUrlState.flyoutId){setLogEntryId(newUrlState.flyoutId)}if(newUrlState&&newUrlState.surroundingLogsId){setSurroundingLogsId(newUrlState.surroundingLogsId)}if(newUrlState&&newUrlState.flyoutVisibility===FlyoutVisibility.visible){openFlyout()}if(newUrlState&&newUrlState.flyoutVisibility===FlyoutVisibility.hidden){closeFlyout()}},onInitialize:initialUrlState=>{if(initialUrlState&&initialUrlState.flyoutId){setLogEntryId(initialUrlState.flyoutId)}if(initialUrlState&&initialUrlState.surroundingLogsId){setSurroundingLogsId(initialUrlState.surroundingLogsId)}if(initialUrlState&&initialUrlState.flyoutVisibility===FlyoutVisibility.visible){openFlyout()}if(initialUrlState&&initialUrlState.flyoutVisibility===FlyoutVisibility.hidden){closeFlyout()}}})};const mapToUrlState=value=>value?{flyoutId:mapToFlyoutIdState(value.flyoutId),flyoutVisibility:mapToFlyoutVisibilityState(value.flyoutVisibility),surroundingLogsId:mapToSurroundingLogsIdState(value.surroundingLogsId)}:undefined;const mapToFlyoutIdState=subject=>subject&&Object(external_kbnSharedDeps_Lodash_["isString"])(subject)?subject:undefined;const mapToSurroundingLogsIdState=subject=>subject&&Object(external_kbnSharedDeps_Lodash_["isString"])(subject)?subject:undefined;const mapToFlyoutVisibilityState=subject=>{if(subject){if(subject==="visible"){return FlyoutVisibility.visible}if(subject==="hidden"){return FlyoutVisibility.hidden}}};var embeddable_public_=__webpack_require__(47);var infra_ml=__webpack_require__(108);const MissingEmbeddableFactoryCallout=({embeddableType:embeddableType})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",color:"warning",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.missingEmebeddableFactoryCallout",{defaultMessage:"{embeddableType} embeddable is unavailable. This can happen if the embeddable plugin isn't enabled.",values:{embeddableType:embeddableType}})});const REFRESH_CONFIG={pause:true,value:0};const AnomaliesSwimlaneVisualisation=props=>{const{embeddable:embeddablePlugin}=Object(use_kibana["b"])().services;if(!embeddablePlugin)return null;return external_kbnSharedDeps_React_default.a.createElement(VisualisationContent,props)};const VisualisationContent=({timeRange:timeRange,jobIds:jobIds,selectedDatasets:selectedDatasets})=>{const{embeddable:embeddablePlugin}=Object(use_kibana["b"])().services;const factory=embeddablePlugin===null||embeddablePlugin===void 0?void 0:embeddablePlugin.getEmbeddableFactory(ml_public_["ANOMALY_SWIMLANE_EMBEDDABLE_TYPE"]);const embeddableInput=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({id:"LOG_ENTRY_ANOMALIES_EMBEDDABLE_INSTANCE",jobIds:jobIds,swimlaneType:"viewBy",timeRange:{from:external_kbnSharedDeps_Moment_default()(timeRange.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),to:external_kbnSharedDeps_Moment_default()(timeRange.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ")},refreshConfig:REFRESH_CONFIG,viewBy:infra_ml["i"],filters:[],query:{language:"kuery",query:selectedDatasets.map(dataset=>`${infra_ml["i"]} : ${dataset!==""?dataset:'""'}`).join(" or ")}}),[jobIds,timeRange.startTime,timeRange.endTime,selectedDatasets]);if(!factory){return external_kbnSharedDeps_React_default.a.createElement(MissingEmbeddableFactoryCallout,{embeddableType:ml_public_["ANOMALY_SWIMLANE_EMBEDDABLE_TYPE"]})}return external_kbnSharedDeps_React_default.a.createElement(embeddable_public_["EmbeddableRenderer"],{input:embeddableInput,factory:factory})};var external_kbnSharedDeps_ElasticEuiLibServices_=__webpack_require__(80);const callGetLogEntryExamplesAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,startTime:startTime,endTime:endTime,dataset:dataset,exampleCount:exampleCount,categoryId:categoryId}=requestArgs;const response=await fetch(http_api_log_analysis["g"],{method:"POST",body:JSON.stringify(http_api_log_analysis["v"].encode({data:{dataset:dataset,exampleCount:exampleCount,sourceId:sourceId,timeRange:{startTime:startTime,endTime:endTime},categoryId:categoryId}}))});return Object(runtime_types["b"])(http_api_log_analysis["w"])(response)};const useLogEntryExamples=({dataset:dataset,endTime:endTime,exampleCount:exampleCount,sourceId:sourceId,startTime:startTime,categoryId:categoryId})=>{const{services:services}=Object(use_kibana["b"])();const[logEntryExamples,setLogEntryExamples]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getLogEntryExamplesRequest,getLogEntryExamples]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async()=>await callGetLogEntryExamplesAPI({sourceId:sourceId,startTime:startTime,endTime:endTime,dataset:dataset,exampleCount:exampleCount,categoryId:categoryId},services.http.fetch),onResolve:({data:{examples:examples}})=>{setLogEntryExamples(examples)}},[dataset,endTime,exampleCount,sourceId,startTime]);const isLoadingLogEntryExamples=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryExamplesRequest.state==="pending",[getLogEntryExamplesRequest.state]);const hasFailedLoadingLogEntryExamples=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryExamplesRequest.state==="rejected",[getLogEntryExamplesRequest.state]);return{getLogEntryExamples:getLogEntryExamples,hasFailedLoadingLogEntryExamples:hasFailedLoadingLogEntryExamples,isLoadingLogEntryExamples:isLoadingLogEntryExamples,logEntryExamples:logEntryExamples}};var column_headers=__webpack_require__(258);var source_configuration=__webpack_require__(201);var datetime=__webpack_require__(199);function log_entry_example_extends(){log_entry_example_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return log_entry_example_extends.apply(this,arguments)}const log_entry_example_exampleMessageScale="medium";const log_entry_example_exampleTimestampFormat="time";const MENU_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logAnomalies.logEntryExamplesMenuLabel",{defaultMessage:"View actions for log entry"});const VIEW_DETAILS_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryExamplesViewDetailsLabel",{defaultMessage:"View details"});const VIEW_IN_STREAM_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryExamplesViewInStreamLabel",{defaultMessage:"View in stream"});const VIEW_ANOMALY_IN_ML_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.logEntryExamplesViewAnomalyInMlLabel",{defaultMessage:"View anomaly in machine learning"});const LogEntryExampleMessage=({id:id,dataset:dataset,message:message,timestamp:timestamp,tiebreaker:tiebreaker,timeRange:timeRange,anomaly:anomaly})=>{const{services:{ml:ml,http:http,application:application}}=Object(use_kibana["b"])();const[isHovered,setIsHovered]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isMenuOpen,setIsMenuOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const openMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsMenuOpen(true),[]);const closeMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsMenuOpen(false),[]);const setItemIsHovered=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsHovered(true),[]);const setItemIsNotHovered=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setIsHovered(false),[]);const{openFlyout:openLogEntryFlyout}=useLogEntryFlyoutContext();const humanFriendlyDataset=Object(log_analysis["getFriendlyNameForPartitionId"])(dataset);const viewInStreamLinkProps=Object(use_link_props["b"])({app:"logs",pathname:"stream",search:{logPosition:Object(rison["encode"])({end:external_kbnSharedDeps_Moment_default()(timeRange.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),position:{tiebreaker:tiebreaker,time:timestamp},start:external_kbnSharedDeps_Moment_default()(timeRange.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),streamLive:false}),flyoutOptions:Object(rison["encode"])({surroundingLogsId:id}),...dataset?{logFilter:Object(rison["encode"])({expression:`${job_parameters["i"]}: ${dataset}`,kind:"kuery"})}:{}}});const viewAnomalyInMachineLearningLink=Object(ml_public_["useMlHref"])(ml,http.basePath.get(),{page:ml_public_["ML_PAGES"].SINGLE_METRIC_VIEWER,pageState:{jobIds:[anomaly.jobId],timeRange:{from:external_kbnSharedDeps_Moment_default()(timeRange.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),to:external_kbnSharedDeps_Moment_default()(timeRange.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),mode:"absolute"},entities:{[job_parameters["i"]]:dataset,...Object(log_analysis["isCategoryAnomaly"])(anomaly)?{mlcategory:anomaly.categoryId}:{}}}});const handleMlLinkClick=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{if(!viewAnomalyInMachineLearningLink||!Object(use_link_props["a"])(e))return;application.navigateToUrl(viewAnomalyInMachineLearningLink)},[viewAnomalyInMachineLearningLink,application]);const menuItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!viewInStreamLinkProps.onClick||!viewAnomalyInMachineLearningLink){return undefined}return[{label:VIEW_DETAILS_LABEL,onClick:()=>{openLogEntryFlyout(id)}},{label:VIEW_IN_STREAM_LABEL,onClick:viewInStreamLinkProps.onClick,href:viewInStreamLinkProps.href},{label:VIEW_ANOMALY_IN_ML_LABEL,onClick:handleMlLinkClick,href:viewAnomalyInMachineLearningLink}]},[id,openLogEntryFlyout,viewInStreamLinkProps,viewAnomalyInMachineLearningLink,handleMlLinkClick]);return external_kbnSharedDeps_React_default.a.createElement(log_text_stream["e"],{scale:log_entry_example_exampleMessageScale,onMouseEnter:setItemIsHovered,onMouseLeave:setItemIsNotHovered},external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],log_entry_example_columnWidths[log_entry_example_timestampColumnId],external_kbnSharedDeps_React_default.a.createElement(log_text_stream["f"],{format:log_entry_example_exampleTimestampFormat,time:timestamp})),external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],log_entry_example_columnWidths[log_entry_example_messageColumnId],external_kbnSharedDeps_React_default.a.createElement(log_text_stream["d"],{columnValue:{columnId:log_entry_example_messageColumnId,message:[{field:"message",value:[message],highlights:[]}]},highlights:log_entry_example_noHighlights,isActiveHighlight:false,wrapMode:"none"})),external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],log_entry_example_columnWidths[log_entry_example_datasetColumnId],external_kbnSharedDeps_React_default.a.createElement(log_text_stream["c"],{columnValue:{columnId:log_entry_example_datasetColumnId,field:"event.dataset",value:[humanFriendlyDataset],highlights:[]},highlights:log_entry_example_noHighlights,isActiveHighlight:false,wrapMode:"none"})),external_kbnSharedDeps_React_default.a.createElement(log_text_stream["a"],log_entry_example_extends({key:"logColumn iconLogColumn iconLogColumn:details"},log_entry_example_columnWidths[log_text_stream["h"]]),(isHovered||isMenuOpen)&&menuItems?external_kbnSharedDeps_React_default.a.createElement(log_text_stream["b"],{"aria-label":MENU_LABEL,isOpen:isMenuOpen,onOpen:openMenu,onClose:closeMenu,items:menuItems}):null))};const log_entry_example_noHighlights=[];const log_entry_example_timestampColumnId="log-entry-example-timestamp-column";const log_entry_example_messageColumnId="log-entry-examples-message-column";const log_entry_example_datasetColumnId="log-entry-examples-dataset-column";const DETAIL_FLYOUT_ICON_MIN_WIDTH=32;const COLUMN_PADDING=8;const log_entry_example_columnWidths={[log_entry_example_timestampColumnId]:{growWeight:0,shrinkWeight:0,baseWidth:"122px"},[log_entry_example_messageColumnId]:{growWeight:1,shrinkWeight:0,baseWidth:"0%"},[log_entry_example_datasetColumnId]:{growWeight:0,shrinkWeight:0,baseWidth:"250px"},[log_text_stream["h"]]:{growWeight:0,shrinkWeight:0,baseWidth:`${DETAIL_FLYOUT_ICON_MIN_WIDTH+2*COLUMN_PADDING}px`}};const log_entry_example_exampleMessageColumnConfigurations=[{timestampColumn:{id:log_entry_example_timestampColumnId}},{messageColumn:{id:log_entry_example_messageColumnId}},{fieldColumn:{field:"event.dataset",id:log_entry_example_datasetColumnId}}];const LogEntryExampleMessageHeaders=({dateTime:dateTime})=>external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessageHeadersWrapper,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,log_entry_example_exampleMessageColumnConfigurations.map(columnConfiguration=>{if(Object(source_configuration["c"])(columnConfiguration)){return external_kbnSharedDeps_React_default.a.createElement(column_headers["a"],{key:columnConfiguration.timestampColumn.id,columnWidth:log_entry_example_columnWidths[columnConfiguration.timestampColumn.id],"data-test-subj":"logColumnHeader timestampLogColumnHeader"},Object(datetime["a"])(dateTime))}else if(Object(source_configuration["b"])(columnConfiguration)){return external_kbnSharedDeps_React_default.a.createElement(column_headers["a"],{columnWidth:log_entry_example_columnWidths[columnConfiguration.messageColumn.id],"data-test-subj":"logColumnHeader messageLogColumnHeader",key:columnConfiguration.messageColumn.id},"Message")}else if(Object(source_configuration["a"])(columnConfiguration)){return external_kbnSharedDeps_React_default.a.createElement(column_headers["a"],{columnWidth:log_entry_example_columnWidths[columnConfiguration.fieldColumn.id],"data-test-subj":"logColumnHeader fieldLogColumnHeader",key:columnConfiguration.fieldColumn.id},columnConfiguration.fieldColumn.field)}}),external_kbnSharedDeps_React_default.a.createElement(column_headers["a"],{columnWidth:log_entry_example_columnWidths[log_text_stream["h"]],"data-test-subj":"logColumnHeader contextMenuLogColumnHeader",key:"icon-column-header"},null)));const LogEntryExampleMessageHeadersWrapper=Object(common_["euiStyled"])(column_headers["c"])`
  border-bottom: none;
  box-shadow: none;
  padding-right: 0;
`;const EXAMPLE_COUNT=5;const examplesTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableExamplesTitle",{defaultMessage:"Example log entries"});const AnomaliesTableExpandedRow=({anomaly:anomaly,timeRange:timeRange})=>{const{sourceId:sourceId}=Object(log_source["c"])();const{getLogEntryExamples:getLogEntryExamples,hasFailedLoadingLogEntryExamples:hasFailedLoadingLogEntryExamples,isLoadingLogEntryExamples:isLoadingLogEntryExamples,logEntryExamples:logEntryExamples}=useLogEntryExamples({dataset:anomaly.dataset,endTime:anomaly.startTime+anomaly.duration,exampleCount:EXAMPLE_COUNT,sourceId:sourceId,startTime:anomaly.startTime,categoryId:Object(log_analysis["isCategoryAnomaly"])(anomaly)?anomaly.categoryId:undefined});useMount_default()(()=>{getLogEntryExamples()});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(ExpandedContentWrapper,{direction:"column"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,examplesTitle))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessages,{isLoading:isLoadingLogEntryExamples,hasFailedLoading:hasFailedLoadingLogEntryExamples,hasResults:logEntryExamples.length>0,exampleCount:EXAMPLE_COUNT,onReload:getLogEntryExamples},logEntryExamples.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessageHeaders,{dateTime:logEntryExamples[0].timestamp}),logEntryExamples.map((example,exampleIndex)=>external_kbnSharedDeps_React_default.a.createElement(LogEntryExampleMessage,{key:exampleIndex,id:example.id,dataset:example.dataset,message:example.message,timestamp:example.timestamp,tiebreaker:example.tiebreaker,timeRange:timeRange,anomaly:anomaly}))):null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{titleSize:"xs",title:`${external_kbnSharedDeps_ElasticNumeral_default()(anomaly.typical).format("0.[00]a")} ${external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesExpandedRowTypicalRateTitle",{defaultMessage:"{typicalCount, plural, one {message} other {messages}}",values:{typicalCount:anomaly.typical}})}`,description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesExpandedRowTypicalRateDescription",{defaultMessage:"Typical"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStat"],{titleSize:"xs",title:`${external_kbnSharedDeps_ElasticNumeral_default()(anomaly.actual).format("0.[00]a")} ${external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesExpandedRowActualRateTitle",{defaultMessage:"{actualCount, plural, one {message} other {messages}}",values:{actualCount:anomaly.actual}})}`,description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesExpandedRowActualRateDescription",{defaultMessage:"Actual"})}))))))};const ExpandedContentWrapper=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"])`
  overflow: hidden;
`;const anomalyScoreColumnName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableAnomalyScoreColumnName",{defaultMessage:"Anomaly score"});const anomalyMessageColumnName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableAnomalyMessageName",{defaultMessage:"Anomaly"});const anomalyStartTimeColumnName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableAnomalyStartTime",{defaultMessage:"Start time"});const datasetColumnName=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableAnomalyDatasetName",{defaultMessage:"Dataset"});const AnomaliesTable=({results:results,timeRange:timeRange,changeSortOptions:changeSortOptions,sortOptions:sortOptions,changePaginationOptions:changePaginationOptions,paginationOptions:paginationOptions,fetchNextPage:fetchNextPage,fetchPreviousPage:fetchPreviousPage,page:page,isLoading:isLoading})=>{const[dateFormat]=Object(use_kibana_ui_setting["a"])("dateFormat","Y-MM-DD HH:mm:ss");const tableSortOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({sort:sortOptions}),[sortOptions]);const tableItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>results.map(anomaly=>({id:anomaly.id,dataset:anomaly.dataset,anomalyScore:anomaly.anomalyScore,startTime:anomaly.startTime,type:anomaly.type,typical:anomaly.typical,actual:anomaly.actual,categoryRegex:Object(log_analysis["isCategoryAnomaly"])(anomaly)?anomaly.categoryRegex:undefined})),[results]);const[expandedIds,{add:expandId,remove:collapseId}]=useSet_default()(new Set);const expandedIdsRowContents=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[...expandedIds].reduce((aggregatedRows,id)=>{const anomaly=results.find(_anomaly=>_anomaly.id===id);return{...aggregatedRows,[id]:anomaly?external_kbnSharedDeps_React_default.a.createElement(AnomaliesTableExpandedRow,{anomaly:anomaly,timeRange:timeRange}):null}},{}),[expandedIds,results,timeRange]);const handleTableChange=Object(external_kbnSharedDeps_React_["useCallback"])(({sort:sort={}})=>{changeSortOptions(sort)},[changeSortOptions]);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{field:"anomalyScore",name:anomalyScoreColumnName,sortable:true,truncateText:true,dataType:"number",width:"130px",render:anomalyScore=>external_kbnSharedDeps_React_default.a.createElement(AnomalySeverityIndicator,{anomalyScore:anomalyScore})},{name:anomalyMessageColumnName,truncateText:true,render:item=>external_kbnSharedDeps_React_default.a.createElement(AnomalyMessage,{anomaly:item})},{field:"startTime",name:anomalyStartTimeColumnName,sortable:true,truncateText:true,width:"230px",render:startTime=>external_kbnSharedDeps_Moment_default()(startTime).format(dateFormat)},{field:"dataset",name:datasetColumnName,sortable:true,truncateText:true,width:"200px",render:dataset=>Object(log_analysis["getFriendlyNameForPartitionId"])(dataset)},{align:external_kbnSharedDeps_ElasticEuiLibServices_["RIGHT_ALIGNMENT"],width:"40px",isExpander:true,render:item=>external_kbnSharedDeps_React_default.a.createElement(RowExpansionButton,{isExpanded:expandedIds.has(item.id),item:item.id,onExpand:expandId,onCollapse:collapseId})}],[collapseId,expandId,expandedIds,dateFormat]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(loading_overlay_wrapper["a"],{isLoading:isLoading},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:tableItems,itemId:"id",itemIdToExpandedRowMap:expandedIdsRowContents,isExpandable:true,hasActions:true,columns:columns,sorting:tableSortOptions,onChange:handleTableChange}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(PaginationControls,{fetchNextPage:fetchNextPage,fetchPreviousPage:fetchPreviousPage,page:page,isLoading:isLoading})))};const AnomalyMessage=({anomaly:anomaly})=>{const{type:type,actual:actual,typical:typical}=anomaly;const moreThanExpectedAnomalyMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableMoreThanExpectedAnomalyMessage",{defaultMessage:"more log messages in this {type, select, logRate {dataset} logCategory {category}} than expected",values:{type:type}});const fewerThanExpectedAnomalyMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableFewerThanExpectedAnomalyMessage",{defaultMessage:"fewer log messages in this {type, select, logRate {dataset} logCategory {category}} than expected",values:{type:type}});const isMore=actual>typical;const message=isMore?moreThanExpectedAnomalyMessage:fewerThanExpectedAnomalyMessage;const ratio=isMore?actual/typical:typical/actual;const icon=isMore?"sortUp":"sortDown";const useRatio=ratio!==Infinity;const ratioMessage=useRatio?`${Object(log_analysis["formatOneDecimalPlace"])(ratio)}x`:"";return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",responsive:false,alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,component:"span"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:icon})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{component:"span"},`${ratioMessage} ${message}`,anomaly.categoryRegex&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,": ",external_kbnSharedDeps_React_default.a.createElement(RegularExpressionRepresentation,{regularExpression:anomaly.categoryRegex}))))};const previousPageLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTablePreviousPageLabel",{defaultMessage:"Previous page"});const nextPageLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesTableNextPageLabel",{defaultMessage:"Next page"});const PaginationControls=({fetchPreviousPage:fetchPreviousPage,fetchNextPage:fetchNextPage,page:page,isLoading:isLoading})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"arrowLeft",isDisabled:!fetchPreviousPage||isLoading,onClick:fetchPreviousPage,"aria-label":previousPageLabel}),external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,page)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"arrowRight",isDisabled:!fetchNextPage||isLoading,onClick:fetchNextPage,"aria-label":nextPageLabel}))));const ManageJobsButton=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],props,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.analysis.manageMlJobsButtonLabel",defaultMessage:"Manage ML jobs"}));const AnomaliesResults=({isLoadingAnomaliesResults:isLoadingAnomaliesResults,timeRange:timeRange,onViewModuleList:onViewModuleList,anomalies:anomalies,changeSortOptions:changeSortOptions,sortOptions:sortOptions,changePaginationOptions:changePaginationOptions,paginationOptions:paginationOptions,fetchNextPage:fetchNextPage,fetchPreviousPage:fetchPreviousPage,page:page,selectedDatasets:selectedDatasets,jobIds:jobIds,autoRefresh:autoRefresh})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m","aria-label":anomalies_title},external_kbnSharedDeps_React_default.a.createElement("h1",null,anomalies_title))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ManageJobsButton,{onClick:onViewModuleList,size:"s"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(AnomaliesSwimlaneVisualisation,{jobIds:jobIds,timeRange:timeRange,selectedDatasets:selectedDatasets,autoRefresh:autoRefresh}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!anomalies||anomalies.length===0?external_kbnSharedDeps_React_default.a.createElement(loading_overlay_wrapper["a"],{isLoading:isLoadingAnomaliesResults,loadingChildren:external_kbnSharedDeps_React_default.a.createElement(anomalies_LoadingOverlayContent,null)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomalySectionNoDataTitle",{defaultMessage:"There is no data to display."})),titleSize:"m",body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomalySectionNoDataBody",{defaultMessage:"You may want to adjust your time range."}))})):external_kbnSharedDeps_React_default.a.createElement(AnomaliesTable,{results:anomalies,timeRange:timeRange,changeSortOptions:changeSortOptions,changePaginationOptions:changePaginationOptions,sortOptions:sortOptions,paginationOptions:paginationOptions,fetchNextPage:fetchNextPage,fetchPreviousPage:fetchPreviousPage,page:page,isLoading:isLoadingAnomaliesResults})));const anomalies_title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesSectionTitle",{defaultMessage:"Anomalies"});const anomalies_loadingAriaLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysis.anomaliesSectionLoadingAriaLabel",{defaultMessage:"Loading anomalies"});const anomalies_LoadingOverlayContent=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl","aria-label":anomalies_loadingAriaLabel});const callGetLogEntryAnomaliesAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,startTime:startTime,endTime:endTime,sort:sort,pagination:pagination,datasets:datasets}=requestArgs;const response=await fetch(http_api_log_analysis["c"],{method:"POST",body:JSON.stringify(http_api_log_analysis["n"].encode({data:{sourceId:sourceId,timeRange:{startTime:startTime,endTime:endTime},sort:sort,pagination:pagination,datasets:datasets}}))});return Object(runtime_types["b"])(http_api_log_analysis["o"])(response)};const callGetLogEntryAnomaliesDatasetsAPI=async(requestArgs,fetch)=>{const{sourceId:sourceId,startTime:startTime,endTime:endTime}=requestArgs;const response=await fetch(http_api_log_analysis["b"],{method:"POST",body:JSON.stringify(http_api_log_analysis["l"].encode({data:{sourceId:sourceId,timeRange:{startTime:startTime,endTime:endTime}}}))});return Object(runtime_types["b"])(http_api_log_analysis["m"])(response)};const stateReducer=(state,action)=>{const resetPagination={page:1,paginationCursor:undefined};switch(action.type){case"changePaginationOptions":return{...state,...resetPagination,...action.payload};case"changeSortOptions":return{...state,...resetPagination,...action.payload};case"changeHasNextPage":return{...state,...action.payload};case"changeLastReceivedCursors":return{...state,...action.payload};case"fetchNextPage":return state.lastReceivedCursors?{...state,page:state.page+1,paginationCursor:{searchAfter:state.lastReceivedCursors.nextPageCursor}}:state;case"fetchPreviousPage":return state.lastReceivedCursors?{...state,page:state.page-1,paginationCursor:{searchBefore:state.lastReceivedCursors.previousPageCursor}}:state;case"changeTimeRange":return{...state,...resetPagination,...action.payload};case"changeFilteredDatasets":return{...state,...resetPagination,...action.payload};default:return state}};const STATE_DEFAULTS={page:1,lastReceivedCursors:undefined,paginationCursor:undefined,hasNextPage:false};const useLogEntryAnomaliesResults=({endTime:endTime,startTime:startTime,sourceId:sourceId,defaultSortOptions:defaultSortOptions,defaultPaginationOptions:defaultPaginationOptions,onGetLogEntryAnomaliesDatasetsError:onGetLogEntryAnomaliesDatasetsError,filteredDatasets:filteredDatasets})=>{const initStateReducer=stateDefaults=>({...stateDefaults,paginationOptions:defaultPaginationOptions,sortOptions:defaultSortOptions,filteredDatasets:filteredDatasets,timeRange:{start:startTime,end:endTime}});const{services:services}=Object(use_kibana["b"])();const[reducerState,dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(stateReducer,STATE_DEFAULTS,initStateReducer);const[logEntryAnomalies,setLogEntryAnomalies]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getLogEntryAnomaliesRequest,getLogEntryAnomalies]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async()=>{const{timeRange:{start:queryStartTime,end:queryEndTime},sortOptions:sortOptions,paginationOptions:paginationOptions,paginationCursor:paginationCursor,filteredDatasets:queryFilteredDatasets}=reducerState;return await callGetLogEntryAnomaliesAPI({sourceId:sourceId,startTime:queryStartTime,endTime:queryEndTime,sort:sortOptions,pagination:{...paginationOptions,cursor:paginationCursor},datasets:queryFilteredDatasets},services.http.fetch)},onResolve:({data:{anomalies:anomalies,paginationCursors:requestCursors,hasMoreEntries:hasMoreEntries}})=>{const{paginationCursor:paginationCursor}=reducerState;if(requestCursors){dispatch({type:"changeLastReceivedCursors",payload:{lastReceivedCursors:requestCursors}})}if(!paginationCursor||paginationCursor&&"searchAfter"in paginationCursor){dispatch({type:"changeHasNextPage",payload:{hasNextPage:hasMoreEntries}})}else if(paginationCursor&&"searchBefore"in paginationCursor){dispatch({type:"changeHasNextPage",payload:{hasNextPage:true}})}setLogEntryAnomalies(anomalies)}},[sourceId,dispatch,reducerState.timeRange,reducerState.sortOptions,reducerState.paginationOptions,reducerState.paginationCursor,reducerState.filteredDatasets]);const changeSortOptions=Object(external_kbnSharedDeps_React_["useCallback"])(nextSortOptions=>{dispatch({type:"changeSortOptions",payload:{sortOptions:nextSortOptions}})},[dispatch]);const changePaginationOptions=Object(external_kbnSharedDeps_React_["useCallback"])(nextPaginationOptions=>{dispatch({type:"changePaginationOptions",payload:{paginationOptions:nextPaginationOptions}})},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch({type:"changeTimeRange",payload:{timeRange:{start:startTime,end:endTime}}})},[startTime,endTime]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{dispatch({type:"changeFilteredDatasets",payload:{filteredDatasets:filteredDatasets}})},[filteredDatasets]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{getLogEntryAnomalies()},[getLogEntryAnomalies]);const handleFetchNextPage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(reducerState.lastReceivedCursors){dispatch({type:"fetchNextPage"})}},[dispatch,reducerState]);const handleFetchPreviousPage=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(reducerState.lastReceivedCursors){dispatch({type:"fetchPreviousPage"})}},[dispatch,reducerState]);const isLoadingLogEntryAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryAnomaliesRequest.state==="pending",[getLogEntryAnomaliesRequest.state]);const hasFailedLoadingLogEntryAnomalies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryAnomaliesRequest.state==="rejected",[getLogEntryAnomaliesRequest.state]);const[logEntryAnomaliesDatasets,setLogEntryAnomaliesDatasets]=Object(external_kbnSharedDeps_React_["useState"])([]);const[getLogEntryAnomaliesDatasetsRequest,getLogEntryAnomaliesDatasets]=Object(use_tracked_promise["b"])({cancelPreviousOn:"creation",createPromise:async()=>await callGetLogEntryAnomaliesDatasetsAPI({sourceId:sourceId,startTime:startTime,endTime:endTime},services.http.fetch),onResolve:({data:{datasets:datasets}})=>{setLogEntryAnomaliesDatasets(datasets)},onReject:error=>{if(error instanceof Error&&!(error instanceof use_tracked_promise["a"])&&onGetLogEntryAnomaliesDatasetsError){onGetLogEntryAnomaliesDatasetsError(error)}}},[endTime,sourceId,startTime]);const isLoadingDatasets=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryAnomaliesDatasetsRequest.state==="pending",[getLogEntryAnomaliesDatasetsRequest.state]);const hasFailedLoadingDatasets=Object(external_kbnSharedDeps_React_["useMemo"])(()=>getLogEntryAnomaliesDatasetsRequest.state==="rejected",[getLogEntryAnomaliesDatasetsRequest.state]);useMount_default()(()=>{getLogEntryAnomaliesDatasets()});return{logEntryAnomalies:logEntryAnomalies,getLogEntryAnomalies:getLogEntryAnomalies,isLoadingLogEntryAnomalies:isLoadingLogEntryAnomalies,isLoadingDatasets:isLoadingDatasets,hasFailedLoadingDatasets:hasFailedLoadingDatasets,datasets:logEntryAnomaliesDatasets,hasFailedLoadingLogEntryAnomalies:hasFailedLoadingLogEntryAnomalies,changeSortOptions:changeSortOptions,sortOptions:reducerState.sortOptions,changePaginationOptions:changePaginationOptions,paginationOptions:reducerState.paginationOptions,fetchPreviousPage:reducerState.page>1?handleFetchPreviousPage:undefined,fetchNextPage:reducerState.hasNextPage?handleFetchNextPage:undefined,page:reducerState.page}};const initialState={selectedDatasets:[],selectedDatasetsFilters:[]};function reducer(state,action){switch(action.type){case"changeSelectedDatasets":return{...state,selectedDatasets:action.payload.datasets};case"updateDatasetsFilters":const datasetsToAdd=action.payload.filters.filter(filter=>!state.selectedDatasets.includes(filter.meta.params.query)).map(filter=>filter.meta.params.query);return{...state,selectedDatasets:[...state.selectedDatasets,...datasetsToAdd],selectedDatasetsFilters:action.payload.filters};default:throw new Error("Unknown action")}}const useDatasetFiltering=()=>{const{services:services}=Object(use_kibana["b"])();const[reducerState,dispatch]=Object(external_kbnSharedDeps_React_["useReducer"])(reducer,initialState);const handleSetSelectedDatasets=Object(external_kbnSharedDeps_React_["useCallback"])(datasets=>{dispatch({type:"changeSelectedDatasets",payload:{datasets:datasets}})},[dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const sub=services.data.query.filterManager.getUpdates$().subscribe(()=>{const filters=services.data.query.filterManager.getFilters().filter(filter=>filter.meta.controlledBy&&filter.meta.controlledBy===ml_public_["CONTROLLED_BY_SWIM_LANE_FILTER"]);dispatch({type:"updateDatasetsFilters",payload:{filters:filters}})});return()=>sub.unsubscribe()},[services.data.query.filterManager,dispatch]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const filtersToRemove=reducerState.selectedDatasetsFilters.filter(filter=>!reducerState.selectedDatasets.includes(filter.meta.params.query));if(filtersToRemove.length>0){filtersToRemove.forEach(filter=>{services.data.query.filterManager.removeFilter(filter)})}},[reducerState.selectedDatasets,reducerState.selectedDatasetsFilters,services.data.query.filterManager]);return{selectedDatasets:reducerState.selectedDatasets,setSelectedDatasets:handleSetSelectedDatasets,selectedDatasetsFilters:reducerState.selectedDatasetsFilters}};const use_log_entry_rate_results_url_state_autoRefreshRT=lib["type"]({interval:lib["number"],isPaused:lib["boolean"]});const urlAutoRefreshRT=lib["union"]([use_log_entry_rate_results_url_state_autoRefreshRT,lib["undefined"]]);const decodeAutoRefreshUrlState=Object(runtime_types["b"])(urlAutoRefreshRT);const defaultAutoRefreshState={isPaused:false,interval:3e4};const use_log_entry_rate_results_url_state_stringTimeRangeRT=lib["type"]({startTime:lib["string"],endTime:lib["string"]});const use_log_entry_rate_results_url_state_urlTimeRangeRT=lib["union"]([use_log_entry_rate_results_url_state_stringTimeRangeRT,lib["undefined"]]);const decodeTimeRangeUrlState=Object(runtime_types["b"])(use_log_entry_rate_results_url_state_urlTimeRangeRT);const use_log_entry_rate_results_url_state_TIME_RANGE_URL_STATE_KEY="timeRange";const use_log_entry_rate_results_url_state_AUTOREFRESH_URL_STATE_KEY="autoRefresh";const use_log_entry_rate_results_url_state_TIME_DEFAULTS={from:"now-2w",to:"now"};const useLogAnalysisResultsUrlState=()=>{const[getTime]=Object(use_kibana_timefilter_time["a"])(use_log_entry_rate_results_url_state_TIME_DEFAULTS);const{from:start,to:end}=getTime();const defaultTimeRangeState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({startTime:start,endTime:end}),[start,end]);const[urlTimeRange,setUrlTimeRange]=Object(use_url_state["b"])({defaultState:defaultTimeRangeState,decodeUrlState:decodeTimeRangeUrlState,encodeUrlState:use_log_entry_rate_results_url_state_urlTimeRangeRT.encode,urlStateKey:use_log_entry_rate_results_url_state_TIME_RANGE_URL_STATE_KEY,writeDefaultState:true});const[queryTimeRange,setQueryTimeRange]=Object(external_kbnSharedDeps_React_["useState"])(()=>({value:use_log_entry_rate_results_url_state_stringToNumericTimeRange({start:urlTimeRange.startTime,end:urlTimeRange.endTime}),lastChangedTime:Date.now()}));const handleQueryTimeRangeChange=Object(external_kbnSharedDeps_React_["useCallback"])(({start:startTime,end:endTime})=>{setQueryTimeRange({value:use_log_entry_rate_results_url_state_stringToNumericTimeRange({start:startTime,end:endTime}),lastChangedTime:Date.now()})},[setQueryTimeRange]);const setTimeRange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedTime=>{setUrlTimeRange({startTime:selectedTime.start,endTime:selectedTime.end});handleQueryTimeRangeChange(selectedTime)},[setUrlTimeRange,handleQueryTimeRangeChange]);const handleTimeFilterChange=Object(external_kbnSharedDeps_React_["useCallback"])(newTimeRange=>{const{from:from,to:to}=newTimeRange;setTimeRange({start:from,end:to})},[setTimeRange]);Object(use_kibana_timefilter_time["b"])(use_log_entry_rate_results_url_state_TIME_DEFAULTS,{from:urlTimeRange.startTime,to:urlTimeRange.endTime},handleTimeFilterChange);const[autoRefresh,setAutoRefresh]=Object(use_url_state["b"])({defaultState:defaultAutoRefreshState,decodeUrlState:decodeAutoRefreshUrlState,encodeUrlState:urlAutoRefreshRT.encode,urlStateKey:use_log_entry_rate_results_url_state_AUTOREFRESH_URL_STATE_KEY,writeDefaultState:true});useInterval_default()(()=>{handleQueryTimeRangeChange({start:urlTimeRange.startTime,end:urlTimeRange.endTime})},autoRefresh.isPaused?null:autoRefresh.interval);return{timeRange:queryTimeRange,friendlyTimeRange:urlTimeRange,setTimeRange:setTimeRange,autoRefresh:autoRefresh,setAutoRefresh:setAutoRefresh}};const use_log_entry_rate_results_url_state_stringToNumericTimeRange=timeRange=>({startTime:external_kbnSharedDeps_Moment_default()(elastic_datemath_default.a.parse(timeRange.start,{momentInstance:external_kbnSharedDeps_Moment_default.a})).valueOf(),endTime:external_kbnSharedDeps_Moment_default()(elastic_datemath_default.a.parse(timeRange.end,{momentInstance:external_kbnSharedDeps_Moment_default.a,roundUp:true})).valueOf()});const SORT_DEFAULTS={direction:"desc",field:"anomalyScore"};const PAGINATION_DEFAULTS={pageSize:25};const LogEntryRateResultsContent=()=>{var _useKibana$services$a;Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_rate_results"});Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_rate_results",delay:15e3});const navigateToApp=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.navigateToApp;const{sourceId:sourceId}=Object(log_source["c"])();const{hasLogAnalysisSetupCapabilities:hasLogAnalysisSetupCapabilities}=useLogAnalysisCapabilitiesContext();const{hasOutdatedJobConfigurations:hasOutdatedLogEntryRateJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedLogEntryRateJobDefinitions,hasStoppedJobs:hasStoppedLogEntryRateJobs,moduleDescriptor:logEntryRateModuleDescriptor,setupStatus:logEntryRateSetupStatus,jobStatus:logEntryRateJobStatus,jobIds:logEntryRateJobIds}=useLogEntryRateModuleContext();const{categoryQualityWarnings:categoryQualityWarnings,hasOutdatedJobConfigurations:hasOutdatedLogEntryCategoriesJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedLogEntryCategoriesJobDefinitions,hasStoppedJobs:hasStoppedLogEntryCategoriesJobs,moduleDescriptor:logEntryCategoriesModuleDescriptor,setupStatus:logEntryCategoriesSetupStatus,jobStatus:logEntryCategoriesJobStatus,jobIds:logEntryCategoriesJobIds}=useLogEntryCategoriesModuleContext();const jobIds=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[...Object(log_analysis["isJobStatusWithResults"])(logEntryRateJobStatus["log-entry-rate"])?[logEntryRateJobIds["log-entry-rate"]]:[],...Object(log_analysis["isJobStatusWithResults"])(logEntryCategoriesJobStatus["log-entry-categories-count"])?[logEntryCategoriesJobIds["log-entry-categories-count"]]:[]],[logEntryRateJobIds,logEntryCategoriesJobIds,logEntryRateJobStatus,logEntryCategoriesJobStatus]);const{timeRange:timeRange,friendlyTimeRange:friendlyTimeRange,setTimeRange:setSelectedTimeRange,autoRefresh:autoRefresh,setAutoRefresh:setAutoRefresh}=useLogAnalysisResultsUrlState();const{closeFlyout:closeLogEntryFlyout,isFlyoutOpen:isLogEntryFlyoutOpen,logEntryId:flyoutLogEntryId}=useLogEntryFlyoutContext();const linkToLogStream=Object(external_kbnSharedDeps_React_["useCallback"])((filter,id,timeKey)=>{const params={logPosition:Object(rison["encode"])({end:external_kbnSharedDeps_Moment_default()(timeRange.value.endTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),position:timeKey,start:external_kbnSharedDeps_Moment_default()(timeRange.value.startTime).format("YYYY-MM-DDTHH:mm:ss.SSSZ"),streamLive:false}),flyoutOptions:Object(rison["encode"])({surroundingLogsId:id}),logFilter:Object(rison["encode"])({expression:filter,kind:"kuery"})};navigateToApp===null||navigateToApp===void 0?void 0:navigateToApp("logs",{path:`/stream?${Object(query_string["stringify"])(params)}`})},[timeRange,navigateToApp]);const{selectedDatasets:selectedDatasets,setSelectedDatasets:setSelectedDatasets}=useDatasetFiltering();const{isLoadingLogEntryAnomalies:isLoadingLogEntryAnomalies,logEntryAnomalies:logEntryAnomalies,page:page,fetchNextPage:fetchNextPage,fetchPreviousPage:fetchPreviousPage,changeSortOptions:changeSortOptions,changePaginationOptions:changePaginationOptions,sortOptions:sortOptions,paginationOptions:paginationOptions,datasets:datasets,isLoadingDatasets:isLoadingDatasets}=useLogEntryAnomaliesResults({sourceId:sourceId,startTime:timeRange.value.startTime,endTime:timeRange.value.endTime,defaultSortOptions:SORT_DEFAULTS,defaultPaginationOptions:PAGINATION_DEFAULTS,filteredDatasets:selectedDatasets});const handleAutoRefreshChange=Object(external_kbnSharedDeps_React_["useCallback"])(({isPaused:isPaused,refreshInterval:interval})=>{setAutoRefresh({isPaused:isPaused,interval:interval})},[setAutoRefresh]);const{showModuleList:showModuleList,showModuleSetup:showModuleSetup}=useLogAnalysisSetupFlyoutStateContext();const showLogEntryRateSetup=Object(external_kbnSharedDeps_React_["useCallback"])(()=>showModuleSetup("logs_ui_analysis"),[showModuleSetup]);const showLogEntryCategoriesSetup=Object(external_kbnSharedDeps_React_["useCallback"])(()=>showModuleSetup("logs_ui_categories"),[showModuleSetup]);const hasAnomalyResults=logEntryAnomalies.length>0;const isFirstUse=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(logEntryCategoriesSetupStatus.type==="skipped"&&!!logEntryCategoriesSetupStatus.newlyCreated||logEntryCategoriesSetupStatus.type==="succeeded"||logEntryRateSetupStatus.type==="skipped"&&!!logEntryRateSetupStatus.newlyCreated||logEntryRateSetupStatus.type==="succeeded")&&!hasAnomalyResults,[hasAnomalyResults,logEntryCategoriesSetupStatus,logEntryRateSetupStatus]);const handleSelectedTimeRangeChange=Object(external_kbnSharedDeps_React_["useCallback"])(selectedTime=>{if(selectedTime.isInvalid){return}setSelectedTimeRange(selectedTime)},[setSelectedTimeRange]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(page_results_content_ResultsContentPage,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(DatasetsSelector,{availableDatasets:datasets,isLoading:isLoadingDatasets,selectedDatasets:selectedDatasets,onChangeDatasetSelection:setSelectedDatasets})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{start:friendlyTimeRange.startTime,end:friendlyTimeRange.endTime,onTimeChange:handleSelectedTimeRangeChange,isPaused:autoRefresh.isPaused,refreshInterval:autoRefresh.interval,onRefreshChange:handleAutoRefreshChange})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(LogAnalysisJobProblemIndicator,{hasOutdatedJobConfigurations:hasOutdatedLogEntryRateJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedLogEntryRateJobDefinitions,hasSetupCapabilities:hasLogAnalysisSetupCapabilities,hasStoppedJobs:hasStoppedLogEntryRateJobs,isFirstUse:false,moduleName:logEntryRateModuleDescriptor.moduleName,onRecreateMlJobForReconfiguration:showLogEntryRateSetup,onRecreateMlJobForUpdate:showLogEntryRateSetup}),external_kbnSharedDeps_React_default.a.createElement(CategoryJobNoticesSection,{hasOutdatedJobConfigurations:hasOutdatedLogEntryCategoriesJobConfigurations,hasOutdatedJobDefinitions:hasOutdatedLogEntryCategoriesJobDefinitions,hasSetupCapabilities:hasLogAnalysisSetupCapabilities,hasStoppedJobs:hasStoppedLogEntryCategoriesJobs,isFirstUse:isFirstUse,moduleName:logEntryCategoriesModuleDescriptor.moduleName,onRecreateMlJobForReconfiguration:showLogEntryCategoriesSetup,onRecreateMlJobForUpdate:showLogEntryCategoriesSetup,qualityWarnings:categoryQualityWarnings})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"m"},external_kbnSharedDeps_React_default.a.createElement(AnomaliesResults,{isLoadingAnomaliesResults:isLoadingLogEntryAnomalies,onViewModuleList:showModuleList,anomalies:logEntryAnomalies,timeRange:timeRange.value,page:page,fetchNextPage:fetchNextPage,fetchPreviousPage:fetchPreviousPage,changeSortOptions:changeSortOptions,changePaginationOptions:changePaginationOptions,sortOptions:sortOptions,paginationOptions:paginationOptions,selectedDatasets:selectedDatasets,jobIds:jobIds,autoRefresh:autoRefresh}))))),isLogEntryFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(LogEntryFlyout,{logEntryId:flyoutLogEntryId,onCloseFlyout:closeLogEntryFlyout,onSetFieldFilter:linkToLogStream,sourceId:sourceId}):null)};const page_results_content_ResultsContentPage=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPage"])`
  flex: 1 0 0%;

  .euiFlexGroup--responsive > .euiFlexItem {
    flex-basis: auto !important;
  }
`;const LogEntryRateSetupContent=({onOpenSetup:onOpenSetup})=>{Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_rate_setup"});Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"log_entry_rate_setup",delay:15e3});return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["a"],{"data-test-subj":"logEntryRateSetupPage"},external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["c"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryRate.setupTitle",defaultMessage:"Set up log anomaly analysis"})),external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["b"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryRate.setupDescription",defaultMessage:"To enable log anomalies, set up a machine learning job"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,onClick:onOpenSetup},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.logEntryRate.showAnalysisSetupButtonLabel",defaultMessage:"ML Setup"}))))};const page_content_JOB_STATUS_POLLING_INTERVAL=3e4;const LogEntryRatePageContent=Object(external_kbnSharedDeps_React_["memo"])(()=>{const{hasFailedLoadingSource:hasFailedLoadingSource,isLoading:isLoading,isUninitialized:isUninitialized,loadSource:loadSource,loadSourceFailureMessage:loadSourceFailureMessage}=Object(log_source["c"])();const{hasLogAnalysisCapabilites:hasLogAnalysisCapabilites,hasLogAnalysisReadCapabilities:hasLogAnalysisReadCapabilities,hasLogAnalysisSetupCapabilities:hasLogAnalysisSetupCapabilities}=useLogAnalysisCapabilitiesContext();const{fetchJobStatus:fetchLogEntryCategoriesJobStatus,fetchModuleDefinition:fetchLogEntryCategoriesModuleDefinition,jobStatus:logEntryCategoriesJobStatus,setupStatus:logEntryCategoriesSetupStatus}=useLogEntryCategoriesModuleContext();const{fetchJobStatus:fetchLogEntryRateJobStatus,fetchModuleDefinition:fetchLogEntryRateModuleDefinition,jobStatus:logEntryRateJobStatus,setupStatus:logEntryRateSetupStatus}=useLogEntryRateModuleContext();const{showModuleList:showModuleList}=useLogAnalysisSetupFlyoutStateContext();const fetchAllJobStatuses=Object(external_kbnSharedDeps_React_["useCallback"])(()=>Promise.all([fetchLogEntryCategoriesJobStatus(),fetchLogEntryRateJobStatus()]),[fetchLogEntryCategoriesJobStatus,fetchLogEntryRateJobStatus]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasLogAnalysisReadCapabilities){fetchAllJobStatuses()}},[fetchAllJobStatuses,hasLogAnalysisReadCapabilities]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasLogAnalysisReadCapabilities){fetchLogEntryCategoriesModuleDefinition()}},[fetchLogEntryCategoriesModuleDefinition,hasLogAnalysisReadCapabilities]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(hasLogAnalysisReadCapabilities){fetchLogEntryRateModuleDefinition()}},[fetchLogEntryRateModuleDefinition,hasLogAnalysisReadCapabilities]);useInterval_default()(()=>{if(logEntryCategoriesSetupStatus.type!=="pending"&&hasLogAnalysisReadCapabilities){fetchLogEntryCategoriesJobStatus()}if(logEntryRateSetupStatus.type!=="pending"&&hasLogAnalysisReadCapabilities){fetchLogEntryRateJobStatus()}},page_content_JOB_STATUS_POLLING_INTERVAL);if(isLoading||isUninitialized){return external_kbnSharedDeps_React_default.a.createElement(source_loading_page["a"],null)}else if(hasFailedLoadingSource){return external_kbnSharedDeps_React_default.a.createElement(source_error_page["a"],{errorMessage:loadSourceFailureMessage!==null&&loadSourceFailureMessage!==void 0?loadSourceFailureMessage:"",retry:loadSource})}else if(!hasLogAnalysisCapabilites){return external_kbnSharedDeps_React_default.a.createElement(subscription_splash_content["a"],null)}else if(!hasLogAnalysisReadCapabilities){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["e"],null)}else if(logEntryCategoriesSetupStatus.type==="initializing"||logEntryRateSetupStatus.type==="initializing"){return external_kbnSharedDeps_React_default.a.createElement(loading_page["a"],{message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.analysisPage.loadingMessage",{defaultMessage:"Checking status of analysis jobs..."})})}else if(logEntryCategoriesSetupStatus.type==="unknown"||logEntryRateSetupStatus.type==="unknown"){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["d"],{retry:fetchAllJobStatuses})}else if(Object(log_analysis["isJobStatusWithResults"])(logEntryCategoriesJobStatus["log-entry-categories-count"])||Object(log_analysis["isJobStatusWithResults"])(logEntryRateJobStatus["log-entry-rate"])){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LogEntryRateResultsContent,null),external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyout,null))}else if(!hasLogAnalysisSetupCapabilities){return external_kbnSharedDeps_React_default.a.createElement(log_analysis_setup["f"],null)}else{return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(LogEntryRateSetupContent,{onOpenSetup:showModuleList}),external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyout,null))}});const LogEntryRatePageProviders=({children:children})=>{var _sourceConfiguration$,_sourceConfiguration$2,_sourceConfiguration$3,_sourceConfiguration$4;const{sourceId:sourceId,sourceConfiguration:sourceConfiguration}=Object(log_source["c"])();const{space:space}=Object(use_kibana_space["a"])();if((sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.configuration.logAlias)==null||space==null){return null}return external_kbnSharedDeps_React_default.a.createElement(LogFlyout.Provider,null,external_kbnSharedDeps_React_default.a.createElement(LogEntryRateModuleProvider,{indexPattern:(_sourceConfiguration$=sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.configuration.logAlias)!==null&&_sourceConfiguration$!==void 0?_sourceConfiguration$:"",sourceId:sourceId,spaceId:space.id,timestampField:(_sourceConfiguration$2=sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.configuration.fields.timestamp)!==null&&_sourceConfiguration$2!==void 0?_sourceConfiguration$2:""},external_kbnSharedDeps_React_default.a.createElement(LogEntryCategoriesModuleProvider,{indexPattern:(_sourceConfiguration$3=sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.configuration.logAlias)!==null&&_sourceConfiguration$3!==void 0?_sourceConfiguration$3:"",sourceId:sourceId,spaceId:space.id,timestampField:(_sourceConfiguration$4=sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.configuration.fields.timestamp)!==null&&_sourceConfiguration$4!==void 0?_sourceConfiguration$4:""},external_kbnSharedDeps_React_default.a.createElement(LogAnalysisSetupFlyoutStateProvider,null,children))))};const LogEntryRatePage=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(LogEntryRatePageProviders,null,external_kbnSharedDeps_React_default.a.createElement(components_page["a"],{"data-test-subj":"logsLogEntryRatePage"},external_kbnSharedDeps_React_default.a.createElement(LogEntryRatePageContent,null))));function fields_configuration_panel_extends(){fields_configuration_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return fields_configuration_panel_extends.apply(this,arguments)}const FieldsConfigurationPanel=({isLoading:isLoading,readOnly:readOnly,tiebreakerFieldProps:tiebreakerFieldProps,timestampFieldProps:timestampFieldProps})=>{const isTimestampValueDefault=timestampFieldProps.value==="@timestamp";const isTiebreakerValueDefault=tiebreakerFieldProps.value==="_doc";return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.fieldsSectionTitle",defaultMessage:"Fields"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.sourceConfiguration.deprecationNotice",{defaultMessage:"Deprecation Notice"}),color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.deprecationMessage",defaultMessage:"Configuring these fields have been deprecated and will be removed in 8.0.0. This application is designed to work with {ecsLink}, you should adjust your indexing to use the {documentationLink}.",values:{documentationLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/infrastructure/guide/7.4/infrastructure-metrics.html",target:"BLANK"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.documentedFields",defaultMessage:"documented fields"})),ecsLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/ecs/current/index.html",target:"BLANK"},"ECS")}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.timestampFieldLabel",defaultMessage:"Timestamp"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.timestampFieldDescription",defaultMessage:"Timestamp used to sort log entries"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{error:timestampFieldProps.error,fullWidth:true,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.timestampFieldRecommendedValue",defaultMessage:"The recommended value is {defaultValue}",values:{defaultValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"@timestamp")}}),isInvalid:timestampFieldProps.isInvalid,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.timestampFieldLabel",defaultMessage:"Timestamp"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],fields_configuration_panel_extends({fullWidth:true,disabled:isLoading||isTimestampValueDefault,readOnly:readOnly,isLoading:isLoading},timestampFieldProps)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.tiebreakerFieldLabel",defaultMessage:"Tiebreaker"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.tiebreakerFieldDescription",defaultMessage:"Field used to break ties between two entries with the same timestamp"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{error:tiebreakerFieldProps.error,fullWidth:true,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.tiebreakerFieldRecommendedValue",defaultMessage:"The recommended value is {defaultValue}",values:{defaultValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"_doc")}}),isInvalid:tiebreakerFieldProps.isInvalid,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.tiebreakerFieldLabel",defaultMessage:"Tiebreaker"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],fields_configuration_panel_extends({fullWidth:true,disabled:isLoading||isTiebreakerValueDefault,readOnly:readOnly,isLoading:isLoading},tiebreakerFieldProps)))))};function indices_configuration_panel_extends(){indices_configuration_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return indices_configuration_panel_extends.apply(this,arguments)}const IndicesConfigurationPanel=({isLoading:isLoading,readOnly:readOnly,logAliasFieldProps:logAliasFieldProps})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.indicesSectionTitle",defaultMessage:"Indices"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.logIndicesTitle",defaultMessage:"Log indices"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.logIndicesDescription",defaultMessage:"Index pattern for matching indices that contain log data"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{error:logAliasFieldProps.error,fullWidth:true,helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.logIndicesRecommendedValue",defaultMessage:"The recommended value is {defaultValue}",values:{defaultValue:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"logs-*,filebeat-*")}}),isInvalid:logAliasFieldProps.isInvalid,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.logIndicesLabel",defaultMessage:"Log indices"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],indices_configuration_panel_extends({"data-test-subj":"logIndicesInput",fullWidth:true,disabled:isLoading,isLoading:isLoading,readOnly:readOnly},logAliasFieldProps)))));var name_configuration_panel=__webpack_require__(261);var uuid=__webpack_require__(36);const AddLogColumnButtonAndPopover=({addLogColumn:addLogColumn,availableFields:availableFields,isDisabled:isDisabled})=>{const{isVisible:isOpen,show:openPopover,hide:closePopover}=Object(use_visibility_state["a"])(false);const availableColumnOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{optionProps:{append:external_kbnSharedDeps_React_default.a.createElement(SystemColumnBadge,null),"data-test-subj":"addTimestampLogColumn",key:"timestamp",label:"Timestamp"},columnConfiguration:{timestampColumn:{id:Object(uuid["v4"])()}}},{optionProps:{"data-test-subj":"addMessageLogColumn",append:external_kbnSharedDeps_React_default.a.createElement(SystemColumnBadge,null),key:"message",label:"Message"},columnConfiguration:{messageColumn:{id:Object(uuid["v4"])()}}},...availableFields.map(field=>({optionProps:{"data-test-subj":`addFieldLogColumn addFieldLogColumn:${field}`,key:`field-${field}`,label:field},columnConfiguration:{fieldColumn:{id:Object(uuid["v4"])(),field:field}}}))],[availableFields]);const availableOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>availableColumnOptions.map(availableColumnOption=>availableColumnOption.optionProps),[availableColumnOptions]);const handleColumnSelection=Object(external_kbnSharedDeps_React_["useCallback"])(selectedOptions=>{closePopover();const selectedOptionIndex=selectedOptions.findIndex(selectedOption=>selectedOption.checked==="on");const selectedOption=availableColumnOptions[selectedOptionIndex];addLogColumn(selectedOption.columnConfiguration)},[addLogColumn,availableColumnOptions,closePopover]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{anchorPosition:"downRight",button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"addLogColumnButton",isDisabled:isDisabled,iconType:"plusInCircle",onClick:openPopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.addLogColumnButtonLabel",defaultMessage:"Add column"})),closePopover:closePopover,id:"addLogColumn",isOpen:isOpen,ownFocus:true,panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],{height:600,listProps:selectableListProps,onChange:handleColumnSelection,options:availableOptions,searchable:true,searchProps:searchProps,singleSelection:true},(list,search)=>external_kbnSharedDeps_React_default.a.createElement(SelectableContent,{"data-test-subj":"addLogColumnPopover"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,search),list)))};const searchProps={"data-test-subj":"fieldSearchInput"};const selectableListProps={showIcons:false};const SystemColumnBadge=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.systemColumnBadgeLabel",defaultMessage:"System"}));const SelectableContent=common_["euiStyled"].div`
  width: 400px;
`;function log_columns_configuration_panel_extends(){log_columns_configuration_panel_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return log_columns_configuration_panel_extends.apply(this,arguments)}const LogColumnsConfigurationPanel=({addLogColumn:addLogColumn,moveLogColumn:moveLogColumn,availableFields:availableFields,isLoading:isLoading,logColumnConfiguration:logColumnConfiguration})=>{const onDragEnd=Object(external_kbnSharedDeps_React_["useCallback"])(({source:source,destination:destination})=>destination&&moveLogColumn(source.index,destination.index),[moveLogColumn]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s","data-test-subj":"sourceConfigurationLogColumnsSectionTitle"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.logColumnsSectionTitle",defaultMessage:"Log columns"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(AddLogColumnButtonAndPopover,{addLogColumn:addLogColumn,availableFields:availableFields,isDisabled:isLoading}))),logColumnConfiguration.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDragDropContext"],{onDragEnd:onDragEnd},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDroppable"],{droppableId:"COLUMN_CONFIG_DROPPABLE_AREA"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,logColumnConfiguration.map((column,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDraggable"],{key:`logColumnConfigurationPanel-${column.logColumnConfiguration.id}`,index:index,draggableId:column.logColumnConfiguration.id,customDragHandle:true},provided=>external_kbnSharedDeps_React_default.a.createElement(LogColumnConfigurationPanel,{dragHandleProps:provided.dragHandleProps,logColumnConfigurationProps:column})))))):external_kbnSharedDeps_React_default.a.createElement(LogColumnConfigurationEmptyPrompt,null))};const LogColumnConfigurationPanel=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),props.logColumnConfigurationProps.type==="timestamp"?external_kbnSharedDeps_React_default.a.createElement(TimestampLogColumnConfigurationPanel,props):props.logColumnConfigurationProps.type==="message"?external_kbnSharedDeps_React_default.a.createElement(MessageLogColumnConfigurationPanel,props):external_kbnSharedDeps_React_default.a.createElement(FieldLogColumnConfigurationPanel,{logColumnConfigurationProps:props.logColumnConfigurationProps,dragHandleProps:props.dragHandleProps}));const TimestampLogColumnConfigurationPanel=({logColumnConfigurationProps:logColumnConfigurationProps,dragHandleProps:dragHandleProps})=>external_kbnSharedDeps_React_default.a.createElement(ExplainedLogColumnConfigurationPanel,{fieldName:"Timestamp",helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{tagName:"span",id:"xpack.infra.sourceConfiguration.timestampLogColumnDescription",defaultMessage:"This system field shows the log entry's time as determined by the {timestampSetting} field setting.",values:{timestampSetting:external_kbnSharedDeps_React_default.a.createElement("code",null,"timestamp")}}),removeColumn:logColumnConfigurationProps.remove,dragHandleProps:dragHandleProps});const MessageLogColumnConfigurationPanel=({logColumnConfigurationProps:logColumnConfigurationProps,dragHandleProps:dragHandleProps})=>external_kbnSharedDeps_React_default.a.createElement(ExplainedLogColumnConfigurationPanel,{fieldName:"Message",helpText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{tagName:"span",id:"xpack.infra.sourceConfiguration.messageLogColumnDescription",defaultMessage:"This system field shows the log entry message as derived from the document fields."}),removeColumn:logColumnConfigurationProps.remove,dragHandleProps:dragHandleProps});const FieldLogColumnConfigurationPanel=({logColumnConfigurationProps:{logColumnConfiguration:{field:field},remove:remove},dragHandleProps:dragHandleProps})=>{const fieldLogColumnTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.sourceConfiguration.fieldLogColumnTitle",{defaultMessage:"Field"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{"data-test-subj":`logColumnPanel fieldLogColumnPanel fieldLogColumnPanel:${field}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("div",log_columns_configuration_panel_extends({"data-test-subj":"moveLogColumnHandle"},dragHandleProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"grab"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},fieldLogColumnTitle),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:3},external_kbnSharedDeps_React_default.a.createElement("code",null,field)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RemoveLogColumnButton,{onClick:remove,columnDescription:`${fieldLogColumnTitle} - ${field}`}))))};const ExplainedLogColumnConfigurationPanel=({fieldName:fieldName,helpText:helpText,removeColumn:removeColumn,dragHandleProps:dragHandleProps})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{"data-test-subj":`logColumnPanel systemLogColumnPanel systemLogColumnPanel:${fieldName}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("div",log_columns_configuration_panel_extends({"data-test-subj":"moveLogColumnHandle"},dragHandleProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"grab"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},fieldName),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:3},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},helpText)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(RemoveLogColumnButton,{onClick:removeColumn,columnDescription:String(fieldName)}))));const RemoveLogColumnButton=({onClick:onClick,columnDescription:columnDescription})=>{const removeColumnLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.sourceConfiguration.removeLogColumnButtonLabel",{defaultMessage:"Remove {columnDescription} column",values:{columnDescription:columnDescription}});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{color:"danger","data-test-subj":"removeLogColumnButton",iconType:"trash",onClick:onClick,title:removeColumnLabel,"aria-label":removeColumnLabel})};const LogColumnConfigurationEmptyPrompt=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"list",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.noLogColumnsTitle",defaultMessage:"No columns"})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.noLogColumnsDescription",defaultMessage:"Add a column to this list using the button above."}))});var input_fields=__webpack_require__(162);const useLogIndicesConfigurationFormState=({initialFormState:initialFormState=defaultFormState})=>{const[formStateChanges,setFormStateChanges]=Object(external_kbnSharedDeps_React_["useState"])({});const resetForm=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setFormStateChanges({}),[]);const formState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({...initialFormState,...formStateChanges}),[initialFormState,formStateChanges]);const nameFieldProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(input_fields["a"])({errors:Object(input_fields["c"])(formState.name),name:"name",onChange:name=>setFormStateChanges(changes=>({...changes,name:name})),value:formState.name}),[formState.name]);const logAliasFieldProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(input_fields["a"])({errors:Object(input_fields["c"])(formState.logAlias),name:"logAlias",onChange:logAlias=>setFormStateChanges(changes=>({...changes,logAlias:logAlias})),value:formState.logAlias}),[formState.logAlias]);const tiebreakerFieldFieldProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(input_fields["a"])({errors:Object(input_fields["c"])(formState.tiebreakerField),name:`tiebreakerField`,onChange:tiebreakerField=>setFormStateChanges(changes=>({...changes,tiebreakerField:tiebreakerField})),value:formState.tiebreakerField}),[formState.tiebreakerField]);const timestampFieldFieldProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(input_fields["a"])({errors:Object(input_fields["c"])(formState.timestampField),name:`timestampField`,onChange:timestampField=>setFormStateChanges(changes=>({...changes,timestampField:timestampField})),value:formState.timestampField}),[formState.timestampField]);const fieldProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({name:nameFieldProps,logAlias:logAliasFieldProps,tiebreakerField:tiebreakerFieldFieldProps,timestampField:timestampFieldFieldProps}),[nameFieldProps,logAliasFieldProps,tiebreakerFieldFieldProps,timestampFieldFieldProps]);const errors=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.values(fieldProps).reduce((accumulatedErrors,{error:error})=>[...accumulatedErrors,...error],[]),[fieldProps]);const isFormValid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>errors.length<=0,[errors]);const isFormDirty=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.keys(formStateChanges).length>0,[formStateChanges]);return{errors:errors,fieldProps:fieldProps,formState:formState,formStateChanges:formStateChanges,isFormDirty:isFormDirty,isFormValid:isFormValid,resetForm:resetForm}};const defaultFormState={name:"",description:"",logAlias:"",tiebreakerField:"",timestampField:""};const useLogColumnsConfigurationFormState=({initialFormState:initialFormState=log_columns_configuration_form_state_defaultFormState})=>{const[formStateChanges,setFormStateChanges]=Object(external_kbnSharedDeps_React_["useState"])({});const resetForm=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setFormStateChanges({}),[]);const formState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({...initialFormState,...formStateChanges}),[initialFormState,formStateChanges]);const logColumnConfigurationProps=Object(external_kbnSharedDeps_React_["useMemo"])(()=>formState.logColumns.map(logColumn=>{const remove=()=>setFormStateChanges(changes=>({...changes,logColumns:formState.logColumns.filter(item=>item!==logColumn)}));if(Object(source_configuration["c"])(logColumn)){return{logColumnConfiguration:logColumn.timestampColumn,remove:remove,type:"timestamp"}}else if(Object(source_configuration["b"])(logColumn)){return{logColumnConfiguration:logColumn.messageColumn,remove:remove,type:"message"}}else{return{logColumnConfiguration:logColumn.fieldColumn,remove:remove,type:"field"}}}),[formState.logColumns]);const addLogColumn=Object(external_kbnSharedDeps_React_["useCallback"])(logColumnConfiguration=>setFormStateChanges(changes=>({...changes,logColumns:[...formState.logColumns,logColumnConfiguration]})),[formState.logColumns]);const moveLogColumn=Object(external_kbnSharedDeps_React_["useCallback"])((sourceIndex,destinationIndex)=>{if(destinationIndex>=0&&sourceIndex<=formState.logColumns.length-1){const newLogColumns=[...formState.logColumns];newLogColumns.splice(destinationIndex,0,newLogColumns.splice(sourceIndex,1)[0]);setFormStateChanges(changes=>({...changes,logColumns:newLogColumns}))}},[formState.logColumns]);const errors=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logColumnConfigurationProps.length<=0?[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.logColumnListEmptyErrorMessage",defaultMessage:"The log column list must not be empty."})]:[],[logColumnConfigurationProps]);const isFormValid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>errors.length<=0?true:false,[errors]);const isFormDirty=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.keys(formStateChanges).length>0,[formStateChanges]);return{addLogColumn:addLogColumn,moveLogColumn:moveLogColumn,errors:errors,logColumnConfigurationProps:logColumnConfigurationProps,formState:formState,formStateChanges:formStateChanges,isFormDirty:isFormDirty,isFormValid:isFormValid,resetForm:resetForm}};const log_columns_configuration_form_state_defaultFormState={logColumns:[]};const useLogSourceConfigurationFormState=configuration=>{const indicesConfigurationFormState=useLogIndicesConfigurationFormState({initialFormState:Object(external_kbnSharedDeps_React_["useMemo"])(()=>configuration?{name:configuration.name,description:configuration.description,logAlias:configuration.logAlias,tiebreakerField:configuration.fields.tiebreaker,timestampField:configuration.fields.timestamp}:undefined,[configuration])});const logColumnsConfigurationFormState=useLogColumnsConfigurationFormState({initialFormState:Object(external_kbnSharedDeps_React_["useMemo"])(()=>configuration?{logColumns:configuration.logColumns}:undefined,[configuration])});const errors=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[...indicesConfigurationFormState.errors,...logColumnsConfigurationFormState.errors],[indicesConfigurationFormState.errors,logColumnsConfigurationFormState.errors]);const resetForm=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{indicesConfigurationFormState.resetForm();logColumnsConfigurationFormState.resetForm()},[indicesConfigurationFormState,logColumnsConfigurationFormState]);const isFormDirty=Object(external_kbnSharedDeps_React_["useMemo"])(()=>indicesConfigurationFormState.isFormDirty||logColumnsConfigurationFormState.isFormDirty,[indicesConfigurationFormState.isFormDirty,logColumnsConfigurationFormState.isFormDirty]);const isFormValid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>indicesConfigurationFormState.isFormValid&&logColumnsConfigurationFormState.isFormValid,[indicesConfigurationFormState.isFormValid,logColumnsConfigurationFormState.isFormValid]);const formState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({name:indicesConfigurationFormState.formState.name,description:indicesConfigurationFormState.formState.description,logAlias:indicesConfigurationFormState.formState.logAlias,fields:{tiebreaker:indicesConfigurationFormState.formState.tiebreakerField,timestamp:indicesConfigurationFormState.formState.timestampField},logColumns:logColumnsConfigurationFormState.formState.logColumns}),[indicesConfigurationFormState.formState,logColumnsConfigurationFormState.formState]);const formStateChanges=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({name:indicesConfigurationFormState.formStateChanges.name,description:indicesConfigurationFormState.formStateChanges.description,logAlias:indicesConfigurationFormState.formStateChanges.logAlias,fields:{tiebreaker:indicesConfigurationFormState.formStateChanges.tiebreakerField,timestamp:indicesConfigurationFormState.formStateChanges.timestampField},logColumns:logColumnsConfigurationFormState.formStateChanges.logColumns}),[indicesConfigurationFormState.formStateChanges,logColumnsConfigurationFormState.formStateChanges]);return{addLogColumn:logColumnsConfigurationFormState.addLogColumn,moveLogColumn:logColumnsConfigurationFormState.moveLogColumn,errors:errors,formState:formState,formStateChanges:formStateChanges,isFormDirty:isFormDirty,isFormValid:isFormValid,indicesConfigurationProps:indicesConfigurationFormState.fieldProps,logColumnConfigurationProps:logColumnsConfigurationFormState.logColumnConfigurationProps,resetForm:resetForm}};var navigation_warning_prompt=__webpack_require__(19);const LogsSettingsPage=()=>{var _useKibana$services$a,_uiCapabilities$logs;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const shouldAllowEdit=(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$logs=uiCapabilities.logs)===null||_uiCapabilities$logs===void 0?void 0:_uiCapabilities$logs.configureSource)===true;const{sourceConfiguration:source,sourceStatus:sourceStatus,isLoading:isLoading,isUninitialized:isUninitialized,updateSourceConfiguration:updateSourceConfiguration}=Object(log_source["c"])();const availableFields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _sourceStatus$logInde;return(_sourceStatus$logInde=sourceStatus===null||sourceStatus===void 0?void 0:sourceStatus.logIndexFields.map(field=>field.name))!==null&&_sourceStatus$logInde!==void 0?_sourceStatus$logInde:[]},[sourceStatus]);const{addLogColumn:addLogColumn,moveLogColumn:moveLogColumn,indicesConfigurationProps:indicesConfigurationProps,logColumnConfigurationProps:logColumnConfigurationProps,errors:errors,resetForm:resetForm,isFormDirty:isFormDirty,isFormValid:isFormValid,formStateChanges:formStateChanges}=useLogSourceConfigurationFormState(source===null||source===void 0?void 0:source.configuration);const persistUpdates=Object(external_kbnSharedDeps_React_["useCallback"])(async()=>{await updateSourceConfiguration(formStateChanges);resetForm()},[updateSourceConfiguration,resetForm,formStateChanges]);const isWriteable=Object(external_kbnSharedDeps_React_["useMemo"])(()=>shouldAllowEdit&&source&&source.origin!=="internal",[shouldAllowEdit,source]);if((isLoading||isUninitialized)&&!source){return external_kbnSharedDeps_React_default.a.createElement(source_loading_page["a"],null)}if(!(source!==null&&source!==void 0&&source.configuration)){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],{className:"eui-displayBlock",restrictWidth:true,"data-test-subj":"sourceConfigurationContent"},external_kbnSharedDeps_React_default.a.createElement(navigation_warning_prompt["b"],{prompt:isFormDirty?unsavedFormPromptMessage:undefined}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"l"},external_kbnSharedDeps_React_default.a.createElement(name_configuration_panel["a"],{isLoading:isLoading,nameFieldProps:indicesConfigurationProps.name,readOnly:!isWriteable})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"l"},external_kbnSharedDeps_React_default.a.createElement(IndicesConfigurationPanel,{isLoading:isLoading,logAliasFieldProps:indicesConfigurationProps.logAlias,readOnly:!isWriteable})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"l"},external_kbnSharedDeps_React_default.a.createElement(FieldsConfigurationPanel,{isLoading:isLoading,readOnly:!isWriteable,tiebreakerFieldProps:indicesConfigurationProps.tiebreakerField,timestampFieldProps:indicesConfigurationProps.timestampField})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"l"},external_kbnSharedDeps_React_default.a.createElement(LogColumnsConfigurationPanel,{addLogColumn:addLogColumn,moveLogColumn:moveLogColumn,availableFields:availableFields,isLoading:isLoading,logColumnConfiguration:logColumnConfigurationProps})),errors.length>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger"},external_kbnSharedDeps_React_default.a.createElement("ul",null,errors.map((error,errorIndex)=>external_kbnSharedDeps_React_default.a.createElement("li",{key:errorIndex},error)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,isWriteable&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",isLoading:true,fill:true},"Loading"))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"discardSettingsButton",color:"danger",iconType:"cross",isDisabled:isLoading||!isFormDirty,onClick:()=>{resetForm()}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.discardSettingsButtonLabel",defaultMessage:"Discard"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{"data-test-subj":"applySettingsButton",color:"primary",isDisabled:!isFormDirty||!isFormValid,fill:true,onClick:persistUpdates},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.sourceConfiguration.applySettingsButtonLabel",defaultMessage:"Apply"}))))))))))};const unsavedFormPromptMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logSourceConfiguration.unsavedFormPromptMessage",{defaultMessage:"Are you sure you want to leave? Changes will be lost"});var auto_sizer=__webpack_require__(119);var d3_scale=__webpack_require__(163);var d3_shape=__webpack_require__(395);const DensityChart=({buckets:buckets,start:start,end:end,width:width,height:height})=>{if(start>=end||height<=0||width<=0||buckets.length<=0){return null}const yScale=Object(d3_scale["scaleTime"])().domain([start,end]).range([0,height]);const xMax=Object(external_kbnSharedDeps_Lodash_["max"])(buckets.map(bucket=>bucket.entriesCount))||0;const xScale=Object(d3_scale["scaleLinear"])().domain([0,xMax]).range([0,width]);const path=Object(d3_shape["area"])().x0(xScale(0)).x1(bucket=>xScale(bucket.entriesCount)).y0(bucket=>yScale(bucket.start)).y1(bucket=>yScale(bucket.end)).curve(d3_shape["curveMonotoneY"]);const firstBucket=buckets[0];const lastBucket=buckets[buckets.length-1];const pathBuckets=[{start:start,end:start,entriesCount:firstBucket.entriesCount},...buckets,{start:lastBucket.end,end:lastBucket.end,entriesCount:lastBucket.entriesCount},{start:end,end:end,entriesCount:0}];const pathData=path(pathBuckets);return external_kbnSharedDeps_React_["createElement"]("g",null,external_kbnSharedDeps_React_["createElement"](DensityChartPositiveBackground,{width:width,height:height}),external_kbnSharedDeps_React_["createElement"](PositiveAreaPath,{d:pathData||""}))};const DensityChartPositiveBackground=common_["euiStyled"].rect`
  fill: ${props=>props.theme.darkMode?props.theme.eui.euiColorLightShade:props.theme.eui.euiColorLightestShade};
`;const PositiveAreaPath=common_["euiStyled"].path`
  fill: ${props=>props.theme.darkMode?props.theme.eui.euiColorMediumShade:props.theme.eui.euiColorLightShade};
`;const HighlightedInterval=({className:className,end:end,getPositionOfTime:getPositionOfTime,start:start,targetWidth:targetWidth,width:width,target:target})=>{const yStart=getPositionOfTime(start);const yEnd=getPositionOfTime(end);const yTarget=target&&getPositionOfTime(target);return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_React_["Fragment"],null,yTarget&&external_kbnSharedDeps_React_["createElement"](HighlightTargetMarker,{className:className,x1:0,x2:targetWidth,y1:yTarget,y2:yTarget}),external_kbnSharedDeps_React_["createElement"](HighlightPolygon,{className:className,points:` ${targetWidth},${yStart} ${width},${yStart} ${width},${yEnd}  ${targetWidth},${yEnd}`}))};HighlightedInterval.displayName="HighlightedInterval";const HighlightTargetMarker=common_["euiStyled"].line`
  stroke: ${props=>props.theme.eui.euiColorPrimary};
  stroke-width: 1;
`;const HighlightPolygon=common_["euiStyled"].polygon`
  fill: ${props=>props.theme.eui.euiColorPrimary};
  fill-opacity: 0.3;
  stroke: ${props=>props.theme.eui.euiColorPrimary};
  stroke-width: 1;
`;var classnames=__webpack_require__(397);var classnames_default=__webpack_require__.n(classnames);const POPOVER_ARROW_SIZE=12;class search_marker_tooltip_SearchMarkerTooltip extends external_kbnSharedDeps_React_["PureComponent"]{render(){const{children:children,markerPosition:markerPosition}=this.props;return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_["createElement"]("div",null,external_kbnSharedDeps_React_["createElement"](auto_sizer["a"],{content:false,bounds:true},({measureRef:measureRef,bounds:{width:width,height:height}})=>{const{top:top,left:left}=width&&height?Object(external_kbnSharedDeps_ElasticEui_["calculatePopoverPosition"])(markerPosition,{width:width,height:height},"left",16,["left"]):{left:-9999,top:0};return external_kbnSharedDeps_React_["createElement"]("div",{className:"euiToolTip euiToolTip--left euiToolTipPopover",style:{left:left,top:top},ref:measureRef},external_kbnSharedDeps_React_["createElement"]("div",{className:"euiToolTip__arrow",style:{left:width||0,top:(height||0)/2-POPOVER_ARROW_SIZE/2}}),external_kbnSharedDeps_React_["createElement"]("div",null,children))})))}}function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class search_marker_SearchMarker extends external_kbnSharedDeps_React_["PureComponent"]{constructor(...args){super(...args);_defineProperty(this,"state",{hoveredPosition:null});_defineProperty(this,"handleClick",evt=>{evt.stopPropagation();this.props.jumpToTarget(this.props.bucket.representativeKey)});_defineProperty(this,"handleMouseEnter",evt=>{this.setState({hoveredPosition:evt.currentTarget.getBoundingClientRect()})});_defineProperty(this,"handleMouseLeave",()=>{this.setState({hoveredPosition:null})})}render(){const{bucket:bucket,height:height,width:width}=this.props;const{hoveredPosition:hoveredPosition}=this.state;const bulge=bucket.entriesCount>1?external_kbnSharedDeps_React_["createElement"](SearchMarkerForegroundRect,{x:"-2",y:"-2",width:"4",height:height+2,rx:"2",ry:"2"}):external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_["createElement"](SearchMarkerForegroundRect,{x:"-1",y:"0",width:"2",height:height}),external_kbnSharedDeps_React_["createElement"](SearchMarkerForegroundRect,{x:"-2",y:height/2-2,width:"4",height:"4",rx:"2",ry:"2"}));return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_React_["Fragment"],null,hoveredPosition?external_kbnSharedDeps_React_["createElement"](search_marker_tooltip_SearchMarkerTooltip,{markerPosition:hoveredPosition},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.searchResultTooltip",defaultMessage:"{bucketCount, plural, one {# highlighted entry} other {# highlighted entries}}",values:{bucketCount:bucket.entriesCount}})):null,external_kbnSharedDeps_React_["createElement"](SearchMarkerGroup,{onClick:this.handleClick,onMouseEnter:this.handleMouseEnter,onMouseLeave:this.handleMouseLeave},external_kbnSharedDeps_React_["createElement"](SearchMarkerBackgroundRect,{x:"0",y:"0",width:width,height:height}),bulge))}}const fadeInAnimation=common_["keyframes"]`
  from {
    opacity: 0;
  }
  to {
    opacity: 1;
  }
`;const SearchMarkerGroup=common_["euiStyled"].g`
  animation: ${fadeInAnimation} ${props=>props.theme.eui.euiAnimSpeedExtraSlow} ease-in both;
`;const SearchMarkerBackgroundRect=common_["euiStyled"].rect`
  fill: ${props=>props.theme.eui.euiColorAccent};
  opacity: 0;
  transition: opacity ${props=>props.theme.eui.euiAnimSpeedNormal} ease-in;
  cursor: pointer;

  ${SearchMarkerGroup}:hover & {
    opacity: 0.3;
  }
`;const SearchMarkerForegroundRect=common_["euiStyled"].rect`
  fill: ${props=>props.theme.eui.euiColorAccent};
`;class search_markers_SearchMarkers extends external_kbnSharedDeps_React_["PureComponent"]{render(){const{buckets:buckets,start:start,end:end,width:width,height:height,jumpToTarget:jumpToTarget,className:className}=this.props;const classes=classnames_default()("minimapSearchMarkers",className);if(start>=end||height<=0||Object.keys(buckets).length<=0){return null}const yScale=Object(d3_scale["scaleTime"])().domain([start,end]).range([0,height]);return external_kbnSharedDeps_React_["createElement"]("g",{transform:`translate(${width/2}, 0)`,className:classes},buckets.map(bucket=>external_kbnSharedDeps_React_["createElement"]("g",{key:`${bucket.representativeKey.time}:${bucket.representativeKey.tiebreaker}`,transform:`translate(0, ${yScale(bucket.start)})`},external_kbnSharedDeps_React_["createElement"](search_marker_SearchMarker,{bucket:bucket,height:yScale(bucket.end)-yScale(bucket.start),width:width,jumpToTarget:jumpToTarget}))))}}function getTimeLabelFormat(start,end){const diff=Math.abs(end-start);if(diff<15*1e3){return":%S.%L"}if(diff<16*60*1e3){return"%I:%M:%S"}return}const TimeRuler=({end:end,height:height,start:start,tickCount:tickCount,width:width})=>{const yScale=Object(d3_scale["scaleTime"])().domain([start,end]).range([0,height]);const ticks=yScale.ticks(tickCount);const formatTick=yScale.tickFormat(tickCount,getTimeLabelFormat(start,end));return external_kbnSharedDeps_React_["createElement"]("g",null,ticks.map((tick,tickIndex)=>{const y=yScale(tick);return external_kbnSharedDeps_React_["createElement"]("g",{key:`tick${tickIndex}`},external_kbnSharedDeps_React_["createElement"](TimeRulerTickLabel,{x:0,y:y-4},formatTick(tick)),external_kbnSharedDeps_React_["createElement"](TimeRulerGridLine,{x1:0,y1:y,x2:width,y2:y}))}))};TimeRuler.displayName="TimeRuler";const TimeRulerTickLabel=common_["euiStyled"].text`
  font-size: 9px;
  line-height: ${props=>props.theme.eui.euiLineHeight};
  fill: ${props=>props.theme.eui.euiTextSubduedColor};
  user-select: none;
  pointer-events: none;
`;const TimeRulerGridLine=common_["euiStyled"].line`
  stroke: ${props=>props.theme.darkMode?props.theme.eui.euiColorDarkestShade:props.theme.eui.euiColorDarkShade};
  stroke-opacity: 0.5;
  stroke-width: 1px;
`;function log_minimap_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const TIMERULER_WIDTH=50;function calculateYScale(start,end,height){return Object(d3_scale["scaleLinear"])().domain([start||0,end||0]).range([0,height])}class log_minimap_LogMinimap extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);log_minimap_defineProperty(this,"handleClick",event=>{const minimapTop=event.currentTarget.getBoundingClientRect().top;const clickedYPosition=event.clientY-minimapTop;const clickedTime=Math.floor(this.getYScale().invert(clickedYPosition));this.props.jumpToTarget({tiebreaker:0,time:clickedTime})});log_minimap_defineProperty(this,"getYScale",()=>{const{start:start,end:end,height:height}=this.props;return calculateYScale(start,end,height)});log_minimap_defineProperty(this,"getPositionOfTime",time=>this.getYScale()(time));log_minimap_defineProperty(this,"updateTimeCursor",event=>{const svgPosition=event.currentTarget.getBoundingClientRect();const timeCursorY=event.clientY-svgPosition.top;this.setState({timeCursorY:timeCursorY})});this.state={timeCursorY:0,target:props.target}}render(){const{start:start,end:end,className:className,height:height,highlightedInterval:highlightedInterval,jumpToTarget:jumpToTarget,summaryBuckets:summaryBuckets,summaryHighlightBuckets:summaryHighlightBuckets,width:width}=this.props;const{timeCursorY:timeCursorY,target:target}=this.state;const[minTime,maxTime]=calculateYScale(start,end,height).domain();const tickCount=height?Math.floor(height/50):12;return external_kbnSharedDeps_React_["createElement"](MinimapWrapper,{className:className,height:height,preserveAspectRatio:"none",viewBox:`0 0 ${width} ${height}`,width:width,onClick:this.handleClick,onMouseMove:this.updateTimeCursor},external_kbnSharedDeps_React_["createElement"](MinimapBorder,{x1:TIMERULER_WIDTH,x2:TIMERULER_WIDTH,y1:0,y2:height}),external_kbnSharedDeps_React_["createElement"](TimeRuler,{start:minTime,end:maxTime,width:TIMERULER_WIDTH,height:height,tickCount:tickCount}),external_kbnSharedDeps_React_["createElement"]("g",{transform:`translate(${TIMERULER_WIDTH}, 0)`},external_kbnSharedDeps_React_["createElement"](DensityChart,{buckets:summaryBuckets,start:minTime,end:maxTime,width:width-TIMERULER_WIDTH,height:height}),external_kbnSharedDeps_React_["createElement"](search_markers_SearchMarkers,{buckets:summaryHighlightBuckets||[],start:minTime,end:maxTime,width:width-TIMERULER_WIDTH,height:height,jumpToTarget:jumpToTarget})),highlightedInterval?external_kbnSharedDeps_React_["createElement"](HighlightedInterval,{end:highlightedInterval.end,getPositionOfTime:this.getPositionOfTime,start:highlightedInterval.start,targetWidth:TIMERULER_WIDTH,width:width,target:target}):null,external_kbnSharedDeps_React_["createElement"](TimeCursor,{x1:TIMERULER_WIDTH,x2:width,y1:timeCursorY,y2:timeCursorY}))}}const MinimapBorder=common_["euiStyled"].line`
  stroke: ${props=>props.theme.eui.euiColorMediumShade};
  stroke-width: 1px;
`;const TimeCursor=common_["euiStyled"].line`
  pointer-events: none;
  stroke-width: 1px;
  stroke: ${props=>props.theme.darkMode?props.theme.eui.euiColorDarkestShade:props.theme.eui.euiColorDarkShade};
`;const MinimapWrapper=common_["euiStyled"].svg`
  cursor: pointer;
  fill: ${props=>props.theme.eui.euiColorEmptyShade};
  & ${TimeCursor} {
    visibility: hidden;
  }
  &:hover ${TimeCursor} {
    visibility: visible;
  }
`;var log_filter=__webpack_require__(132);var useThrottle=__webpack_require__(264);var useThrottle_default=__webpack_require__.n(useThrottle);const fetchLogEntriesHighlights=async(requestArgs,fetch)=>{const response=await fetch(http_api["e"],{method:"POST",body:JSON.stringify(http_api["n"].encode(requestArgs))});return Object(runtime_types["b"])(http_api["o"])(response)};const useLogEntryHighlights=(sourceId,sourceVersion,startTimestamp,endTimestamp,centerPoint,size,filterQuery,highlightTerms)=>{const{services:services}=Object(use_kibana["b"])();const[logEntryHighlights,setLogEntryHighlights]=Object(external_kbnSharedDeps_React_["useState"])([]);const[loadLogEntryHighlightsRequest,loadLogEntryHighlights]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{if(!startTimestamp||!endTimestamp||!centerPoint||!highlightTerms.length){throw new Error("Skipping request: Insufficient parameters")}return await fetchLogEntriesHighlights({sourceId:sourceId,startTimestamp:startTimestamp,endTimestamp:endTimestamp,center:centerPoint,size:size,query:filterQuery||undefined,highlightTerms:highlightTerms},services.http.fetch)},onResolve:response=>{setLogEntryHighlights(response.data)}},[sourceId,startTimestamp,endTimestamp,centerPoint,size,filterQuery,highlightTerms]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setLogEntryHighlights([])},[highlightTerms]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(highlightTerms.filter(highlightTerm=>highlightTerm.length>0).length&&startTimestamp&&endTimestamp){loadLogEntryHighlights()}else{setLogEntryHighlights([])}},[endTimestamp,filterQuery,highlightTerms,loadLogEntryHighlights,sourceVersion,startTimestamp]);const logEntryHighlightsById=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logEntryHighlights.reduce((accumulatedLogEntryHighlightsById,highlightData)=>highlightData.entries.reduce((singleHighlightLogEntriesById,entry)=>{const highlightsForId=singleHighlightLogEntriesById[entry.id]||[];return{...singleHighlightLogEntriesById,[entry.id]:[...highlightsForId,entry]}},accumulatedLogEntryHighlightsById),{}),[logEntryHighlights]);return{logEntryHighlights:logEntryHighlights,logEntryHighlightsById:logEntryHighlightsById,loadLogEntryHighlightsRequest:loadLogEntryHighlightsRequest}};const fetchLogSummaryHighlights=async(requestArgs,fetch)=>{const response=await fetch(http_api["f"],{method:"POST",body:JSON.stringify(http_api["p"].encode(requestArgs))});return Object(runtime_types["b"])(http_api["q"])(response)};const SUMMARY_BUCKET_COUNT=100;function useBucketSize(startTimestamp,endTimestamp){const bucketSize=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!startTimestamp||!endTimestamp){return null}return(endTimestamp-startTimestamp)/SUMMARY_BUCKET_COUNT},[startTimestamp,endTimestamp]);return bucketSize}const useLogSummaryHighlights=(sourceId,sourceVersion,startTimestamp,endTimestamp,filterQuery,highlightTerms)=>{const{services:services}=Object(use_kibana["b"])();const[logSummaryHighlights,setLogSummaryHighlights]=Object(external_kbnSharedDeps_React_["useState"])([]);const bucketSize=useBucketSize(startTimestamp,endTimestamp);const[loadLogSummaryHighlightsRequest,loadLogSummaryHighlights]=Object(use_tracked_promise["b"])({cancelPreviousOn:"resolution",createPromise:async()=>{if(!startTimestamp||!endTimestamp||!bucketSize||!highlightTerms.length){throw new Error("Skipping request: Insufficient parameters")}return await fetchLogSummaryHighlights({sourceId:sourceId,startTimestamp:startTimestamp,endTimestamp:endTimestamp,bucketSize:bucketSize,query:filterQuery,highlightTerms:highlightTerms},services.http.fetch)},onResolve:response=>{setLogSummaryHighlights(response.data)}},[sourceId,startTimestamp,endTimestamp,bucketSize,filterQuery,highlightTerms]);const debouncedLoadSummaryHighlights=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_Lodash_["debounce"])(loadLogSummaryHighlights,275),[loadLogSummaryHighlights]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setLogSummaryHighlights([])},[highlightTerms]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(highlightTerms.filter(highlightTerm=>highlightTerm.length>0).length&&startTimestamp&&endTimestamp){debouncedLoadSummaryHighlights()}else{setLogSummaryHighlights([])}},[bucketSize,debouncedLoadSummaryHighlights,filterQuery,highlightTerms,sourceVersion,startTimestamp,endTimestamp]);return{logSummaryHighlights:logSummaryHighlights,loadLogSummaryHighlightsRequest:loadLogSummaryHighlightsRequest}};var utils_log_entry=__webpack_require__(174);const useNextAndPrevious=({highlightTerms:highlightTerms,jumpToTargetPosition:jumpToTargetPosition,logEntryHighlights:logEntryHighlights,visibleMidpoint:visibleMidpoint})=>{const[currentTimeKey,setCurrentTimeKey]=Object(external_kbnSharedDeps_React_["useState"])(null);const entries=Object(external_kbnSharedDeps_React_["useMemo"])(()=>logEntryHighlights&&logEntryHighlights.length>0?logEntryHighlights[0].entries:[],[logEntryHighlights]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{setCurrentTimeKey(null)},[highlightTerms]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentTimeKey){jumpToTargetPosition(currentTimeKey)}},[currentTimeKey,jumpToTargetPosition]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(currentTimeKey===null&&entries.length>0){const initialIndex=visibleMidpoint?clampValue(Object(utils_log_entry["b"])(entries,visibleMidpoint),0,entries.length-1):0;const initialTimeKey=Object(utils_log_entry["c"])(entries[initialIndex]);setCurrentTimeKey(initialTimeKey)}},[currentTimeKey,entries,setCurrentTimeKey,visibleMidpoint]);const indexOfCurrentTimeKey=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(currentTimeKey&&entries.length>0){return Object(utils_log_entry["a"])(entries,currentTimeKey)}else{return null}},[currentTimeKey,entries]);const hasPreviousHighlight=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_Lodash_["isNumber"])(indexOfCurrentTimeKey)&&indexOfCurrentTimeKey>0,[indexOfCurrentTimeKey]);const hasNextHighlight=Object(external_kbnSharedDeps_React_["useMemo"])(()=>entries.length>0&&Object(external_kbnSharedDeps_Lodash_["isNumber"])(indexOfCurrentTimeKey)&&indexOfCurrentTimeKey<entries.length-1,[indexOfCurrentTimeKey,entries]);const goToPreviousHighlight=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(entries.length&&Object(external_kbnSharedDeps_Lodash_["isNumber"])(indexOfCurrentTimeKey)){const previousIndex=indexOfCurrentTimeKey-1;const entryTimeKey=Object(utils_log_entry["c"])(entries[previousIndex]);setCurrentTimeKey(entryTimeKey)}},[indexOfCurrentTimeKey,entries]);const goToNextHighlight=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(entries.length>0&&Object(external_kbnSharedDeps_Lodash_["isNumber"])(indexOfCurrentTimeKey)){const nextIndex=indexOfCurrentTimeKey+1;const entryTimeKey=Object(utils_log_entry["c"])(entries[nextIndex]);setCurrentTimeKey(entryTimeKey)}},[indexOfCurrentTimeKey,entries]);return{currentHighlightKey:currentTimeKey,hasPreviousHighlight:hasPreviousHighlight,hasNextHighlight:hasNextHighlight,goToPreviousHighlight:goToPreviousHighlight,goToNextHighlight:goToNextHighlight}};const clampValue=(value,minValue,maxValue)=>Math.min(Math.max(value,minValue),maxValue);var log_position=__webpack_require__(109);const FETCH_THROTTLE_INTERVAL=3e3;const useLogHighlightsState=({sourceId:sourceId,sourceVersion:sourceVersion,centerCursor:centerCursor,size:size,filterQuery:filterQuery})=>{const[highlightTerms,setHighlightTerms]=Object(external_kbnSharedDeps_React_["useState"])([]);const{visibleMidpoint:visibleMidpoint,jumpToTargetPosition:jumpToTargetPosition,startTimestamp:startTimestamp,endTimestamp:endTimestamp}=Object(external_kbnSharedDeps_React_["useContext"])(log_position["a"].Context);const throttledStartTimestamp=useThrottle_default()(startTimestamp,FETCH_THROTTLE_INTERVAL);const throttledEndTimestamp=useThrottle_default()(endTimestamp,FETCH_THROTTLE_INTERVAL);const{logEntryHighlights:logEntryHighlights,logEntryHighlightsById:logEntryHighlightsById,loadLogEntryHighlightsRequest:loadLogEntryHighlightsRequest}=useLogEntryHighlights(sourceId,sourceVersion,throttledStartTimestamp,throttledEndTimestamp,centerCursor,size,filterQuery,highlightTerms);const{logSummaryHighlights:logSummaryHighlights,loadLogSummaryHighlightsRequest:loadLogSummaryHighlightsRequest}=useLogSummaryHighlights(sourceId,sourceVersion,throttledStartTimestamp,throttledEndTimestamp,filterQuery,highlightTerms);const{currentHighlightKey:currentHighlightKey,hasPreviousHighlight:hasPreviousHighlight,hasNextHighlight:hasNextHighlight,goToPreviousHighlight:goToPreviousHighlight,goToNextHighlight:goToNextHighlight}=useNextAndPrevious({visibleMidpoint:visibleMidpoint,logEntryHighlights:logEntryHighlights,highlightTerms:highlightTerms,jumpToTargetPosition:jumpToTargetPosition});return{highlightTerms:highlightTerms,setHighlightTerms:setHighlightTerms,logEntryHighlights:logEntryHighlights,logEntryHighlightsById:logEntryHighlightsById,logSummaryHighlights:logSummaryHighlights,loadLogEntryHighlightsRequest:loadLogEntryHighlightsRequest,loadLogSummaryHighlightsRequest:loadLogSummaryHighlightsRequest,currentHighlightKey:currentHighlightKey,hasPreviousHighlight:hasPreviousHighlight,hasNextHighlight:hasNextHighlight,goToPreviousHighlight:goToPreviousHighlight,goToNextHighlight:goToNextHighlight}};const LogHighlightsState=constate_cjs_default()(useLogHighlightsState);const createCancellationSignal=()=>{const cancellationSignal={isCancelled:false,cancel:()=>{cancellationSignal.isCancelled=true}};return cancellationSignal};const useCancellableEffect=(effect,deps)=>{Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const cancellationSignal=createCancellationSignal();effect(()=>cancellationSignal.isCancelled);return cancellationSignal.cancel},deps)};const fetchLogSummary=async(requestArgs,fetch)=>{const response=await fetch(http_api["g"],{method:"POST",body:JSON.stringify(http_api["r"].encode(requestArgs))});return Object(runtime_types["b"])(http_api["s"])(response)};const useLogSummary=(sourceId,startTimestamp,endTimestamp,filterQuery)=>{const{services:services}=Object(use_kibana["b"])();const[logSummaryBuckets,setLogSummaryBuckets]=Object(external_kbnSharedDeps_React_["useState"])([]);const bucketSize=useBucketSize(startTimestamp,endTimestamp);useCancellableEffect(getIsCancelled=>{if(startTimestamp===null||endTimestamp===null||bucketSize===null){return}fetchLogSummary({sourceId:sourceId,startTimestamp:startTimestamp,endTimestamp:endTimestamp,bucketSize:bucketSize,query:filterQuery},services.http.fetch).then(response=>{if(!getIsCancelled()){setLogSummaryBuckets(response.data.buckets)}})},[sourceId,filterQuery,startTimestamp,endTimestamp,bucketSize]);return{buckets:logSummaryBuckets,start:startTimestamp,end:endTimestamp}};const with_summary_FETCH_THROTTLE_INTERVAL=3e3;const WithSummary=({children:children})=>{const{sourceId:sourceId}=Object(log_source["c"])();const{filterQuery:filterQuery}=Object(external_kbnSharedDeps_React_["useContext"])(log_filter["a"].Context);const{startTimestamp:startTimestamp,endTimestamp:endTimestamp}=Object(external_kbnSharedDeps_React_["useContext"])(log_position["a"].Context);const throttledStartTimestamp=useThrottle_default()(startTimestamp,with_summary_FETCH_THROTTLE_INTERVAL);const throttledEndTimestamp=useThrottle_default()(endTimestamp,with_summary_FETCH_THROTTLE_INTERVAL);const{buckets:buckets,start:start,end:end}=useLogSummary(sourceId,throttledStartTimestamp,throttledEndTimestamp,filterQuery);return children({buckets:buckets,start:start,end:end})};const useLogViewConfiguration=()=>{const[textScale,setTextScale]=Object(external_kbnSharedDeps_React_["useState"])("medium");const[textWrap,setTextWrap]=Object(external_kbnSharedDeps_React_["useState"])(true);return{availableTextScales:log_view_configuration_availableTextScales,setTextScale:setTextScale,setTextWrap:setTextWrap,textScale:textScale,textWrap:textWrap}};const LogViewConfiguration=constate_cjs_default()(useLogViewConfiguration);const log_view_configuration_availableTextScales=["large","medium","small"];const WithLogTextviewUrlState=()=>{const{textScale:textScale,textWrap:textWrap,setTextScale:setTextScale,setTextWrap:setTextWrap}=Object(external_kbnSharedDeps_React_["useContext"])(LogViewConfiguration.Context);const urlState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({textScale:textScale,wrap:textWrap}),[textScale,textWrap]);return external_kbnSharedDeps_React_default.a.createElement(url_state["a"],{urlState:urlState,urlStateKey:"logTextview",mapToUrlState:with_log_textview_mapToUrlState,onChange:newUrlState=>{if(newUrlState&&newUrlState.textScale){setTextScale(newUrlState.textScale)}if(newUrlState&&typeof newUrlState.wrap!=="undefined"){setTextWrap(newUrlState.wrap)}},onInitialize:newUrlState=>{if(newUrlState&&newUrlState.textScale){setTextScale(newUrlState.textScale)}if(newUrlState&&typeof newUrlState.wrap!=="undefined"){setTextWrap(newUrlState.wrap)}}})};const with_log_textview_mapToUrlState=value=>value?{textScale:mapToTextScaleUrlState(value.textScale),wrap:mapToWrapUrlState(value.wrap)}:undefined;const mapToTextScaleUrlState=value=>log_view_configuration_availableTextScales.includes(value)?value:undefined;const mapToWrapUrlState=value=>typeof value==="boolean"?value:undefined;var data_public_=__webpack_require__(31);const Toolbar=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).attrs(()=>({grow:false,paddingSize:"none"}))`
  border-top: none;
  border-right: none;
  border-left: none;
  border-radius: 0;
  padding: ${props=>props.theme.eui.euiSizeS} ${props=>props.theme.eui.euiSizeL};
`;function log_customization_menu_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class log_customization_menu_LogCustomizationMenu extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);log_customization_menu_defineProperty(this,"state",{isShown:false});log_customization_menu_defineProperty(this,"show",()=>{this.setState({isShown:true})});log_customization_menu_defineProperty(this,"hide",()=>{this.setState({isShown:false})});log_customization_menu_defineProperty(this,"toggleVisibility",()=>{this.setState(state=>({isShown:!state.isShown}))})}render(){const{children:children}=this.props;const{isShown:isShown}=this.state;const menuButton=external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"text",iconType:"eye",onClick:this.toggleVisibility,size:"xs"},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.customizeLogs.customizeButtonLabel",defaultMessage:"Customize"}));return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"customizePopover",button:menuButton,closePopover:this.hide,isOpen:isShown,anchorPosition:"downRight",ownFocus:true},external_kbnSharedDeps_React_["createElement"](CustomizationMenuContent,null,children))}}const CustomizationMenuContent=common_["euiStyled"].div`
  min-width: 200px;
`;const LogDatepicker=({startDateExpression:startDateExpression,endDateExpression:endDateExpression,isStreaming:isStreaming,onUpdateDateRange:onUpdateDateRange,onStartStreaming:onStartStreaming,onStopStreaming:onStopStreaming})=>{const handleTimeChange=Object(external_kbnSharedDeps_React_["useCallback"])(({start:start,end:end,isInvalid:isInvalid})=>{if(onUpdateDateRange&&!isInvalid){onUpdateDateRange({startDateExpression:start,endDateExpression:end})}},[onUpdateDateRange]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{start:startDateExpression,end:endDateExpression,onTimeChange:handleTimeChange,showUpdateButton:false,isDisabled:isStreaming})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},isStreaming?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"primary",iconType:"pause",iconSide:"left",onClick:onStopStreaming},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.stopStreamingButtonLabel",defaultMessage:"Stop streaming"})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"play",iconSide:"left",onClick:onStartStreaming},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.startStreamingButtonLabel",defaultMessage:"Stream live"}))))};const LogHighlightsMenu=({onChange:onChange,isLoading:isLoading,activeHighlights:activeHighlights,hasPreviousHighlight:hasPreviousHighlight,goToPreviousHighlight:goToPreviousHighlight,hasNextHighlight:hasNextHighlight,goToNextHighlight:goToNextHighlight})=>{const{isVisible:isPopoverOpen,hide:closePopover,toggle:togglePopover}=Object(use_visibility_state["a"])(false);const[highlightTerm,_setHighlightTerm]=Object(external_kbnSharedDeps_React_["useState"])("");const debouncedOnChange=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(external_kbnSharedDeps_Lodash_["debounce"])(onChange,275),[onChange]);const setHighlightTerm=Object(external_kbnSharedDeps_React_["useCallback"])(valueOrUpdater=>_setHighlightTerm(previousHighlightTerm=>{const newHighlightTerm=typeof valueOrUpdater==="function"?valueOrUpdater(previousHighlightTerm):valueOrUpdater;if(newHighlightTerm!==previousHighlightTerm){debouncedOnChange([newHighlightTerm])}return newHighlightTerm}),[debouncedOnChange]);const changeHighlightTerm=Object(external_kbnSharedDeps_React_["useCallback"])(e=>{const value=e.target.value;setHighlightTerm(value)},[setHighlightTerm]);const clearHighlightTerm=Object(external_kbnSharedDeps_React_["useCallback"])(()=>setHighlightTerm(""),[setHighlightTerm]);const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"text",size:"xs",iconType:"brush",onClick:togglePopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.highlights.highlightsPopoverButtonLabel",defaultMessage:"Highlights"}),activeHighlights?external_kbnSharedDeps_React_default.a.createElement(ActiveHighlightsIndicator,null):null);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"popover",button:button,isOpen:isPopoverOpen,closePopover:closePopover,ownFocus:true},external_kbnSharedDeps_React_default.a.createElement(LogHighlightsMenuContent,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:termsFieldLabel,fullWidth:true,value:highlightTerm,onChange:changeHighlightTerm,isLoading:isLoading,"aria-label":termsFieldLabel})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":goToPreviousHighlightLabel,iconType:"arrowUp",onClick:goToPreviousHighlight,title:goToPreviousHighlightLabel,isDisabled:!hasPreviousHighlight})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":goToNextHighlightLabel,iconType:"arrowDown",onClick:goToNextHighlight,title:goToNextHighlightLabel,isDisabled:!hasNextHighlight})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":clearTermsButtonLabel,color:"danger",isDisabled:highlightTerm==="",iconType:"trash",onClick:clearHighlightTerm,title:clearTermsButtonLabel})))))};const termsFieldLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.highlights.highlightTermsFieldLabel",{defaultMessage:"Terms to highlight"});const clearTermsButtonLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.highlights.clearHighlightTermsButtonLabel",{defaultMessage:"Clear terms to highlight"});const goToPreviousHighlightLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.highlights.goToPreviousHighlightButtonLabel",{defaultMessage:"Jump to previous highlight"});const goToNextHighlightLabel=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.highlights.goToNextHighlightButtonLabel",{defaultMessage:"Jump to next highlight"});const ActiveHighlightsIndicator=Object(common_["euiStyled"])(external_kbnSharedDeps_ElasticEui_["EuiIcon"]).attrs(({theme:theme})=>({type:"checkInCircleFilled",size:"m",color:theme===null||theme===void 0?void 0:theme.eui.euiColorAccent}))`
  padding-left: ${props=>props.theme.eui.paddingSizes.xs};
`;const LogHighlightsMenuContent=common_["euiStyled"].div`
  width: 300px;
`;function isTextScale(maybeTextScale){return["small","medium","large"].includes(maybeTextScale)}function log_text_scale_controls_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class log_text_scale_controls_LogTextScaleControls extends external_kbnSharedDeps_React_["PureComponent"]{constructor(...args){super(...args);log_text_scale_controls_defineProperty(this,"setTextScale",textScale=>{if(isTextScale(textScale)){this.props.setTextScale(textScale)}})}render(){const{availableTextScales:availableTextScales,textScale:textScale}=this.props;return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.customizeLogs.textSizeFormRowLabel",defaultMessage:"Text Size"})},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{options:availableTextScales.map(availableTextScale=>({id:availableTextScale.toString(),label:external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.customizeLogs.textSizeRadioGroup",defaultMessage:"{textScale, select, small {Small} medium {Medium} large {Large} other {{textScale}} }",values:{textScale:availableTextScale}})})),idSelected:textScale,onChange:this.setTextScale}))}}function log_text_wrap_controls_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class log_text_wrap_controls_LogTextWrapControls extends external_kbnSharedDeps_React_["PureComponent"]{constructor(...args){super(...args);log_text_wrap_controls_defineProperty(this,"toggleWrap",()=>{this.props.setTextWrap(!this.props.wrap)})}render(){const{wrap:wrap}=this.props;return external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.customizeLogs.lineWrappingFormRowLabel",defaultMessage:"Line Wrapping"})},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.infra.logs.customizeLogs.wrapLongLinesSwitchLabel",defaultMessage:"Wrap long lines"}),checked:wrap,onChange:this.toggleWrap}))}}const LogsToolbar=()=>{var _filterQueryDraft$exp,_filterQueryDraft$kin;const{derivedIndexPattern:derivedIndexPattern}=Object(log_source["c"])();const{availableTextScales:availableTextScales,setTextScale:setTextScale,setTextWrap:setTextWrap,textScale:textScale,textWrap:textWrap}=Object(external_kbnSharedDeps_React_["useContext"])(LogViewConfiguration.Context);const{filterQueryDraft:filterQueryDraft,isFilterQueryDraftValid:isFilterQueryDraftValid,applyLogFilterQuery:applyLogFilterQuery,setLogFilterQueryDraft:setLogFilterQueryDraft}=Object(external_kbnSharedDeps_React_["useContext"])(log_filter["a"].Context);const{setSurroundingLogsId:setSurroundingLogsId}=Object(external_kbnSharedDeps_React_["useContext"])(LogFlyout.Context);const{setHighlightTerms:setHighlightTerms,loadLogEntryHighlightsRequest:loadLogEntryHighlightsRequest,highlightTerms:highlightTerms,hasPreviousHighlight:hasPreviousHighlight,hasNextHighlight:hasNextHighlight,goToPreviousHighlight:goToPreviousHighlight,goToNextHighlight:goToNextHighlight}=Object(external_kbnSharedDeps_React_["useContext"])(LogHighlightsState.Context);const{isStreaming:isStreaming,startLiveStreaming:startLiveStreaming,stopLiveStreaming:stopLiveStreaming,startDateExpression:startDateExpression,endDateExpression:endDateExpression,updateDateRange:updateDateRange}=Object(external_kbnSharedDeps_React_["useContext"])(log_position["a"].Context);return external_kbnSharedDeps_React_default.a.createElement(Toolbar,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"spaceBetween",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(data_public_["QueryStringInput"],{disableLanguageSwitcher:true,iconType:"search",indexPatterns:[derivedIndexPattern],isInvalid:!isFilterQueryDraftValid,onChange:expression=>{if(typeof expression.query==="string"){setSurroundingLogsId(null);setLogFilterQueryDraft(expression.query)}},onSubmit:expression=>{if(typeof expression.query==="string"){setSurroundingLogsId(null);applyLogFilterQuery(expression.query)}},placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logsPage.toolbar.kqlSearchFieldPlaceholder",{defaultMessage:"Search for log entries… (e.g. host.name:host-1)"}),query:{query:(_filterQueryDraft$exp=filterQueryDraft===null||filterQueryDraft===void 0?void 0:filterQueryDraft.expression)!==null&&_filterQueryDraft$exp!==void 0?_filterQueryDraft$exp:"",language:(_filterQueryDraft$kin=filterQueryDraft===null||filterQueryDraft===void 0?void 0:filterQueryDraft.kind)!==null&&_filterQueryDraft$kin!==void 0?_filterQueryDraft$kin:"kuery"}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(log_customization_menu_LogCustomizationMenu,null,external_kbnSharedDeps_React_default.a.createElement(log_text_wrap_controls_LogTextWrapControls,{wrap:textWrap,setTextWrap:setTextWrap}),external_kbnSharedDeps_React_default.a.createElement(log_text_scale_controls_LogTextScaleControls,{availableTextScales:availableTextScales,textScale:textScale,setTextScale:setTextScale}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(LogHighlightsMenu,{onChange:setHighlightTerms,isLoading:loadLogEntryHighlightsRequest.state==="pending",activeHighlights:highlightTerms.filter(highlightTerm=>highlightTerm.length>0).length>0,goToPreviousHighlight:goToPreviousHighlight,goToNextHighlight:goToNextHighlight,hasPreviousHighlight:hasPreviousHighlight,hasNextHighlight:hasNextHighlight})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(LogDatepicker,{startDateExpression:startDateExpression,endDateExpression:endDateExpression,onStartStreaming:startLiveStreaming,onStopStreaming:stopLiveStreaming,isStreaming:isStreaming,onUpdateDateRange:updateDateRange}))))};var logs_log_stream=__webpack_require__(209);var datemath=__webpack_require__(24);const PAGE_THRESHOLD=2;const LogsPageLogsContent=()=>{const{sourceConfiguration:sourceConfiguration,sourceId:sourceId}=Object(log_source["c"])();const{textScale:textScale,textWrap:textWrap}=Object(external_kbnSharedDeps_React_["useContext"])(LogViewConfiguration.Context);const{surroundingLogsId:surroundingLogsId,setSurroundingLogsId:setSurroundingLogsId,closeFlyout:closeLogEntryFlyout,openFlyout:openLogEntryFlyout,isFlyoutOpen:isFlyoutOpen,logEntryId:flyoutLogEntryId}=useLogEntryFlyoutContext();const{startTimestamp:startTimestamp,endTimestamp:endTimestamp,isStreaming:isStreaming,targetPosition:targetPosition,visibleMidpointTime:visibleMidpointTime,visibleTimeInterval:visibleTimeInterval,reportVisiblePositions:reportVisiblePositions,jumpToTargetPosition:jumpToTargetPosition,startLiveStreaming:startLiveStreaming,stopLiveStreaming:stopLiveStreaming,startDateExpression:startDateExpression,endDateExpression:endDateExpression,updateDateRange:updateDateRange,lastCompleteDateRangeExpressionUpdate:lastCompleteDateRangeExpressionUpdate}=Object(external_kbnSharedDeps_React_["useContext"])(log_position["a"].Context);const{filterQuery:filterQuery,applyLogFilterQuery:applyLogFilterQuery}=Object(external_kbnSharedDeps_React_["useContext"])(log_filter["a"].Context);const{isReloading:isReloading,entries:entries,topCursor:topCursor,bottomCursor:bottomCursor,hasMoreAfter:hasMoreAfterEnd,hasMoreBefore:hasMoreBeforeStart,isLoadingMore:isLoadingMore,lastLoadedTime:lastLoadedTime,fetchEntries:fetchEntries,fetchPreviousEntries:fetchPreviousEntries,fetchNextEntries:fetchNextEntries,fetchNewestEntries:fetchNewestEntries}=Object(logs_log_stream["c"])();const prevStartTimestamp=usePrevious_default()(startTimestamp);const prevEndTimestamp=usePrevious_default()(endTimestamp);const prevFilterQuery=usePrevious_default()(filterQuery);const prevLastCompleteDateRangeExpressionUpdate=usePrevious_default()(lastCompleteDateRangeExpressionUpdate);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const isFirstLoad=!prevStartTimestamp||!prevEndTimestamp;const completeDateRangeExpressionHasChanged=lastCompleteDateRangeExpressionUpdate!==prevLastCompleteDateRangeExpressionUpdate;const isCenterPointOutsideLoadedRange=targetPosition!=null&&(topCursor!=null&&targetPosition.time<topCursor.time||bottomCursor!=null&&targetPosition.time>bottomCursor.time);const hasQueryChanged=filterQuery!==prevFilterQuery;if(isFirstLoad||completeDateRangeExpressionHasChanged||isCenterPointOutsideLoadedRange||hasQueryChanged){if(isStreaming){fetchNewestEntries()}else{fetchEntries()}}},[fetchEntries,fetchNewestEntries,isStreaming,prevStartTimestamp,prevEndTimestamp,startTimestamp,endTimestamp,targetPosition,topCursor,bottomCursor,filterQuery,prevFilterQuery,lastCompleteDateRangeExpressionUpdate,prevLastCompleteDateRangeExpressionUpdate]);const{logSummaryHighlights:logSummaryHighlights,currentHighlightKey:currentHighlightKey,logEntryHighlightsById:logEntryHighlightsById}=Object(external_kbnSharedDeps_React_["useContext"])(LogHighlightsState.Context);const items=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isReloading?[]:entries.map(logEntry=>createLogEntryStreamItem(logEntry,logEntryHighlightsById[logEntry.id]||[])),[entries,isReloading,logEntryHighlightsById]);const[,{setContextEntry:setContextEntry}]=Object(external_kbnSharedDeps_React_["useContext"])(ViewLogInContext.Context);const handleDateRangeExtension=Object(external_kbnSharedDeps_React_["useCallback"])(newDateRange=>{updateDateRange(newDateRange);if("startDateExpression"in newDateRange&&Object(datemath["c"])(newDateRange.startDateExpression)){fetchPreviousEntries({force:true,extendTo:Object(datemath["a"])(newDateRange.startDateExpression)})}if("endDateExpression"in newDateRange&&Object(datemath["c"])(newDateRange.endDateExpression)){fetchNextEntries({force:true,extendTo:Object(datemath["a"])(newDateRange.endDateExpression)})}},[updateDateRange,fetchPreviousEntries,fetchNextEntries]);const handlePagination=Object(external_kbnSharedDeps_React_["useCallback"])(params=>{reportVisiblePositions(params);if(!params.fromScroll){return}if(isLoadingMore){return}if(params.pagesBeforeStart<PAGE_THRESHOLD){fetchPreviousEntries()}else if(params.pagesAfterEnd<PAGE_THRESHOLD){fetchNextEntries()}},[reportVisiblePositions,isLoadingMore,fetchPreviousEntries,fetchNextEntries]);const setFilter=Object(external_kbnSharedDeps_React_["useCallback"])((filter,flyoutItemId,timeKey)=>{applyLogFilterQuery(filter);if(timeKey){jumpToTargetPosition(timeKey)}setSurroundingLogsId(flyoutItemId);stopLiveStreaming()},[applyLogFilterQuery,jumpToTargetPosition,setSurroundingLogsId,stopLiveStreaming]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(WithLogTextviewUrlState,null),external_kbnSharedDeps_React_default.a.createElement(WithFlyoutOptionsUrlState,null),external_kbnSharedDeps_React_default.a.createElement(LogsToolbar,null),external_kbnSharedDeps_React_default.a.createElement(PageViewLogInContext,null),isFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(LogEntryFlyout,{logEntryId:flyoutLogEntryId,onCloseFlyout:closeLogEntryFlyout,onSetFieldFilter:setFilter,sourceId:sourceId}):null,external_kbnSharedDeps_React_default.a.createElement(components_page["c"],{key:`${sourceId}-${sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.version}`},external_kbnSharedDeps_React_default.a.createElement(log_text_stream["g"],{columnConfigurations:sourceConfiguration&&sourceConfiguration.configuration.logColumns||[],hasMoreAfterEnd:hasMoreAfterEnd,hasMoreBeforeStart:hasMoreBeforeStart,isLoadingMore:isLoadingMore,isReloading:isReloading,isStreaming:isStreaming,items:items,jumpToTarget:jumpToTargetPosition,lastLoadedTime:lastLoadedTime,reloadItems:fetchEntries,reportVisibleInterval:handlePagination,scale:textScale,target:targetPosition,wrap:textWrap,onOpenLogEntryFlyout:openLogEntryFlyout,setContextEntry:setContextEntry,highlightedItem:surroundingLogsId?surroundingLogsId:null,currentHighlightKey:currentHighlightKey,startDateExpression:startDateExpression,endDateExpression:endDateExpression,updateDateRange:handleDateRangeExtension,startLiveStreaming:startLiveStreaming}),external_kbnSharedDeps_React_default.a.createElement(auto_sizer["a"],{content:true,bounds:true,detectAnyWindowResize:"height"},({measureRef:measureRef,bounds:{height:height=0},content:{width:width=0}})=>external_kbnSharedDeps_React_default.a.createElement(LogPageMinimapColumn,{ref:measureRef},external_kbnSharedDeps_React_default.a.createElement(WithSummary,null,({buckets:buckets,start:start,end:end})=>external_kbnSharedDeps_React_default.a.createElement(log_minimap_LogMinimap,{start:start,end:end,height:height,width:width,highlightedInterval:isReloading?null:visibleTimeInterval,jumpToTarget:jumpToTargetPosition,summaryBuckets:buckets,summaryHighlightBuckets:logSummaryHighlights.length>0?logSummaryHighlights[0].buckets:[],target:visibleMidpointTime}))))))};const LogPageMinimapColumn=common_["euiStyled"].div`
  flex: 1 0 0%;
  overflow: hidden;
  min-width: 100px;
  max-width: 100px;
  display: flex;
  flex-direction: column;
`;const createLogEntryStreamItem=(logEntry,highlights)=>({kind:"logEntry",logEntry:logEntry,highlights:highlights});var no_indices=__webpack_require__(161);var components_source_configuration=__webpack_require__(215);function page_no_indices_content_extends(){page_no_indices_content_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return page_no_indices_content_extends.apply(this,arguments)}const LogsPageNoIndicesContent=()=>{var _application$capabili,_application$capabili2;const{services:{application:application}}=Object(kibanaReact_public_["useKibana"])();const canConfigureSource=application!==null&&application!==void 0&&(_application$capabili=application.capabilities)!==null&&_application$capabili!==void 0&&(_application$capabili2=_application$capabili.logs)!==null&&_application$capabili2!==void 0&&_application$capabili2.configureSource?true:false;const tutorialLinkProps=Object(use_link_props["b"])({app:"home",hash:"/tutorial_directory/logging"});return external_kbnSharedDeps_React_default.a.createElement(no_indices["a"],{"data-test-subj":"noLogsIndicesPrompt",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logsPage.noLoggingIndicesTitle",{defaultMessage:"Looks like you don't have any logging indices."}),message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logsPage.noLoggingIndicesDescription",{defaultMessage:"Let's add some!"}),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],page_no_indices_content_extends({},tutorialLinkProps,{color:"primary",fill:true,"data-test-subj":"logsViewSetupInstructionsButton"}),external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logsPage.noLoggingIndicesInstructionsActionLabel",{defaultMessage:"View setup instructions"}))),canConfigureSource?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(components_source_configuration["a"],{app:"logs","data-test-subj":"configureSourceButton"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.configureSourceActionLabel",{defaultMessage:"Change source configuration"}))):null)})};const StreamPageContent=()=>{const{hasFailedLoadingSource:hasFailedLoadingSource,isLoading:isLoading,isUninitialized:isUninitialized,loadSource:loadSource,loadSourceFailureMessage:loadSourceFailureMessage,sourceStatus:sourceStatus}=Object(log_source["c"])();if(isLoading||isUninitialized){return external_kbnSharedDeps_React_default.a.createElement(source_loading_page["a"],null)}else if(hasFailedLoadingSource){return external_kbnSharedDeps_React_default.a.createElement(source_error_page["a"],{errorMessage:loadSourceFailureMessage!==null&&loadSourceFailureMessage!==void 0?loadSourceFailureMessage:"",retry:loadSource})}else if((sourceStatus===null||sourceStatus===void 0?void 0:sourceStatus.logIndexStatus)!=="missing"){return external_kbnSharedDeps_React_default.a.createElement(LogsPageLogsContent,null)}else{return external_kbnSharedDeps_React_default.a.createElement(LogsPageNoIndicesContent,null)}};const StreamPageHeader=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:previousTitle=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.streamPage.documentTitle",{defaultMessage:"{previousTitle} | Stream",values:{previousTitle:previousTitle}})}));const LogFilterStateProvider=({children:children})=>{const{derivedIndexPattern:derivedIndexPattern}=Object(log_source["c"])();return external_kbnSharedDeps_React_default.a.createElement(log_filter["a"].Provider,{indexPattern:derivedIndexPattern},external_kbnSharedDeps_React_default.a.createElement(log_filter["b"],null),children)};const ViewLogInContextProvider=({children:children})=>{const{startTimestamp:startTimestamp,endTimestamp:endTimestamp}=Object(external_kbnSharedDeps_React_["useContext"])(log_position["a"].Context);const{sourceId:sourceId}=Object(log_source["c"])();if(!startTimestamp||!endTimestamp){return null}return external_kbnSharedDeps_React_default.a.createElement(ViewLogInContext.Provider,{startTimestamp:startTimestamp,endTimestamp:endTimestamp,sourceId:sourceId},children)};const LogEntriesStateProvider=({children:children})=>{var _filterQueryAsKuery$e;const{sourceId:sourceId}=Object(log_source["c"])();const{startTimestamp:startTimestamp,endTimestamp:endTimestamp,targetPosition:targetPosition,isInitialized:isInitialized}=Object(external_kbnSharedDeps_React_["useContext"])(log_position["a"].Context);const{filterQueryAsKuery:filterQueryAsKuery}=Object(external_kbnSharedDeps_React_["useContext"])(log_filter["a"].Context);if(!startTimestamp||!endTimestamp){return null}const logStreamProps={sourceId:sourceId,startTimestamp:startTimestamp,endTimestamp:endTimestamp,query:(_filterQueryAsKuery$e=filterQueryAsKuery===null||filterQueryAsKuery===void 0?void 0:filterQueryAsKuery.expression)!==null&&_filterQueryAsKuery$e!==void 0?_filterQueryAsKuery$e:undefined,center:targetPosition!==null&&targetPosition!==void 0?targetPosition:undefined};if(!isInitialized){return null}return external_kbnSharedDeps_React_default.a.createElement(logs_log_stream["a"],logStreamProps,children)};const LogHighlightsStateProvider=({children:children})=>{const{sourceId:sourceId,sourceConfiguration:sourceConfiguration}=Object(log_source["c"])();const{topCursor:topCursor,bottomCursor:bottomCursor,entries:entries}=Object(logs_log_stream["c"])();const{filterQuery:filterQuery}=Object(external_kbnSharedDeps_React_["useContext"])(log_filter["a"].Context);const highlightsProps={sourceId:sourceId,sourceVersion:sourceConfiguration===null||sourceConfiguration===void 0?void 0:sourceConfiguration.version,entriesStart:topCursor,entriesEnd:bottomCursor,centerCursor:entries.length>0?entries[Math.floor(entries.length/2)].cursor:null,size:entries.length,filterQuery:filterQuery};return external_kbnSharedDeps_React_default.a.createElement(LogHighlightsState.Provider,highlightsProps,children)};const LogsPageProviders=({children:children})=>{const{sourceStatus:sourceStatus}=Object(log_source["c"])();if((sourceStatus===null||sourceStatus===void 0?void 0:sourceStatus.logIndexStatus)==="missing"){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,children)}return external_kbnSharedDeps_React_default.a.createElement(LogViewConfiguration.Provider,null,external_kbnSharedDeps_React_default.a.createElement(LogFlyout.Provider,null,external_kbnSharedDeps_React_default.a.createElement(log_position["a"].Provider,null,external_kbnSharedDeps_React_default.a.createElement(log_position["b"],null),external_kbnSharedDeps_React_default.a.createElement(ViewLogInContextProvider,null,external_kbnSharedDeps_React_default.a.createElement(LogFilterStateProvider,null,external_kbnSharedDeps_React_default.a.createElement(LogEntriesStateProvider,null,external_kbnSharedDeps_React_default.a.createElement(LogHighlightsStateProvider,null,children)))))))};const StreamPage=()=>{Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"stream"});Object(observability_public_["useTrackPageview"])({app:"infra_logs",path:"stream",delay:15e3});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(LogsPageProviders,null,external_kbnSharedDeps_React_default.a.createElement(components_page["a"],{"data-test-subj":"infraLogsPage"},external_kbnSharedDeps_React_default.a.createElement(StreamPageHeader,null),external_kbnSharedDeps_React_default.a.createElement(StreamPageContent,null))))};var header_action_menu_provider=__webpack_require__(40);const LogsPageContent=()=>{var _useKibana$services$a,_kibana$services,_kibana$services$appl,_uiCapabilities$logs;const uiCapabilities=(_useKibana$services$a=Object(kibanaReact_public_["useKibana"])().services.application)===null||_useKibana$services$a===void 0?void 0:_useKibana$services$a.capabilities;const{setHeaderActionMenu:setHeaderActionMenu}=Object(external_kbnSharedDeps_React_["useContext"])(header_action_menu_provider["a"]);const{initialize:initialize}=Object(log_source["c"])();const kibana=Object(kibanaReact_public_["useKibana"])();useMount_default()(()=>{initialize()});const streamTab={app:"logs",title:streamTabTitle,pathname:"/stream"};const anomaliesTab={app:"logs",title:anomaliesTabTitle,pathname:"/anomalies"};const logCategoriesTab={app:"logs",title:logCategoriesTabTitle,pathname:"/log-categories"};const settingsTab={app:"logs",title:settingsTabTitle,pathname:"/settings"};return external_kbnSharedDeps_React_default.a.createElement(components_page["a"],null,external_kbnSharedDeps_React_default.a.createElement(document_title["a"],{title:pageTitle}),external_kbnSharedDeps_React_default.a.createElement(help_center_content["a"],{feedbackLink:feedbackLinkUrl,appName:pageTitle}),setHeaderActionMenu&&external_kbnSharedDeps_React_default.a.createElement(observability_public_["HeaderMenuPortal"],{setHeaderActionMenu:setHeaderActionMenu},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"center",responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(log_threshold["a"],null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:(_kibana$services=kibana.services)===null||_kibana$services===void 0?void 0:(_kibana$services$appl=_kibana$services.application)===null||_kibana$services$appl===void 0?void 0:_kibana$services$appl.getUrlForApp("/home#/tutorial_directory/logging"),size:"s",color:"primary",iconType:"indexOpen"},ADD_DATA_LABEL)))),external_kbnSharedDeps_React_default.a.createElement(header["a"],{breadcrumbs:[{text:pageTitle}],readOnlyBadge:!(uiCapabilities!==null&&uiCapabilities!==void 0&&(_uiCapabilities$logs=uiCapabilities.logs)!==null&&_uiCapabilities$logs!==void 0&&_uiCapabilities$logs.save)}),external_kbnSharedDeps_React_default.a.createElement(app_navigation["a"],{"aria-label":pageTitle},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(routed_tabs["a"],{tabs:[streamTab,anomaliesTab,logCategoriesTab,settingsTab]})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:streamTab.pathname,component:StreamPage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:anomaliesTab.pathname,component:LogEntryRatePage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:logCategoriesTab.pathname,component:LogEntryCategoriesPage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:settingsTab.pathname,component:LogsSettingsPage}),external_kbnSharedDeps_React_default.a.createElement(redirect_with_query_params["a"],{from:"/analysis",to:anomaliesTab.pathname,exact:true}),external_kbnSharedDeps_React_default.a.createElement(redirect_with_query_params["a"],{from:"/log-rate",to:anomaliesTab.pathname,exact:true}),external_kbnSharedDeps_React_default.a.createElement(redirect_with_query_params["a"],{from:"/",to:streamTab.pathname,exact:true})))};const pageTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.header.logsTitle",{defaultMessage:"Logs"});const streamTabTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.index.streamTabTitle",{defaultMessage:"Stream"});const anomaliesTabTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.index.anomaliesTabTitle",{defaultMessage:"Anomalies"});const logCategoriesTabTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.index.logCategoriesBetaBadgeTitle",{defaultMessage:"Categories"});const settingsTabTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logs.index.settingsTabTitle",{defaultMessage:"Settings"});const feedbackLinkUrl="https://discuss.elastic.co/c/logs";const ADD_DATA_LABEL=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.infra.logsHeaderAddDataButtonLabel",{defaultMessage:"Add data"});var source_id=__webpack_require__(179);const page_providers_LogsPageProviders=({children:children})=>{const[sourceId]=Object(source_id["b"])();const{services:services}=Object(kibanaReact_public_["useKibana"])();return external_kbnSharedDeps_React_default.a.createElement(log_source["a"],{sourceId:sourceId,fetch:services.http.fetch},external_kbnSharedDeps_React_default.a.createElement(LogAnalysisCapabilitiesProvider,null,children))};const LogsPage=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(page_providers_LogsPageProviders,null,external_kbnSharedDeps_React_default.a.createElement(LogsPageContent,null)));var common_providers=__webpack_require__(39);var common_styles=__webpack_require__(203);const renderApp=(core,plugins,{element:element,history:history,setHeaderActionMenu:setHeaderActionMenu})=>{const storage=new public_["Storage"](window.localStorage);Object(common_styles["b"])(element);external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(LogsApp,{core:core,storage:storage,history:history,plugins:plugins,setHeaderActionMenu:setHeaderActionMenu}),element);return()=>{external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(element)}};const LogsApp=({core:core,history:history,plugins:plugins,setHeaderActionMenu:setHeaderActionMenu,storage:storage})=>{var _uiCapabilities$logs;const uiCapabilities=core.application.capabilities;return external_kbnSharedDeps_React_default.a.createElement(common_providers["b"],{core:core,plugins:plugins},external_kbnSharedDeps_React_default.a.createElement(common_providers["a"],{appName:"Logs UI",setHeaderActionMenu:setHeaderActionMenu,storage:storage,triggersActionsUI:plugins.triggersActionsUi},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:history},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/link-to",component:link_to_logs["a"]}),(uiCapabilities===null||uiCapabilities===void 0?void 0:(_uiCapabilities$logs=uiCapabilities.logs)===null||_uiCapabilities$logs===void 0?void 0:_uiCapabilities$logs.show)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/",component:LogsPage}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{component:_404["a"]})))))}}}]);