/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(function(modules){function webpackJsonpCallback(data){var chunkIds=data[0];var moreModules=data[1];var moduleId,chunkId,i=0,resolves=[];for(;i<chunkIds.length;i++){chunkId=chunkIds[i];if(Object.prototype.hasOwnProperty.call(installedChunks,chunkId)&&installedChunks[chunkId]){resolves.push(installedChunks[chunkId][0])}installedChunks[chunkId]=0}for(moduleId in moreModules){if(Object.prototype.hasOwnProperty.call(moreModules,moduleId)){modules[moduleId]=moreModules[moduleId]}}if(parentJsonpFunction)parentJsonpFunction(data);while(resolves.length){resolves.shift()()}}var installedModules={};var installedChunks={0:0};function jsonpScriptSrc(chunkId){return __webpack_require__.p+"indexLifecycleManagement.chunk."+chunkId+".js"}function __webpack_require__(moduleId){if(installedModules[moduleId]){return installedModules[moduleId].exports}var module=installedModules[moduleId]={i:moduleId,l:false,exports:{}};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.l=true;return module.exports}__webpack_require__.e=function requireEnsure(chunkId){var promises=[];var installedChunkData=installedChunks[chunkId];if(installedChunkData!==0){if(installedChunkData){promises.push(installedChunkData[2])}else{var promise=new Promise((function(resolve,reject){installedChunkData=installedChunks[chunkId]=[resolve,reject]}));promises.push(installedChunkData[2]=promise);var script=document.createElement("script");var onScriptComplete;script.charset="utf-8";script.timeout=120;if(__webpack_require__.nc){script.setAttribute("nonce",__webpack_require__.nc)}script.src=jsonpScriptSrc(chunkId);var error=new Error;onScriptComplete=function(event){script.onerror=script.onload=null;clearTimeout(timeout);var chunk=installedChunks[chunkId];if(chunk!==0){if(chunk){var errorType=event&&(event.type==="load"?"missing":event.type);var realSrc=event&&event.target&&event.target.src;error.message="Loading chunk "+chunkId+" failed.\n("+errorType+": "+realSrc+")";error.name="ChunkLoadError";error.type=errorType;error.request=realSrc;chunk[1](error)}installedChunks[chunkId]=undefined}};var timeout=setTimeout((function(){onScriptComplete({type:"timeout",target:script})}),12e4);script.onerror=script.onload=onScriptComplete;document.head.appendChild(script)}}return Promise.all(promises)};__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.d=function(exports,name,getter){if(!__webpack_require__.o(exports,name)){Object.defineProperty(exports,name,{enumerable:true,get:getter})}};__webpack_require__.r=function(exports){if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})};__webpack_require__.t=function(value,mode){if(mode&1)value=__webpack_require__(value);if(mode&8)return value;if(mode&4&&typeof value==="object"&&value&&value.__esModule)return value;var ns=Object.create(null);__webpack_require__.r(ns);Object.defineProperty(ns,"default",{enumerable:true,value:value});if(mode&2&&typeof value!="string")for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns};__webpack_require__.n=function(module){var getter=module&&module.__esModule?function getDefault(){return module["default"]}:function getModuleExports(){return module};__webpack_require__.d(getter,"a",getter);return getter};__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)};__webpack_require__.p="";__webpack_require__.oe=function(err){console.error(err);throw err};var jsonpArray=window["indexLifecycleManagement_bundle_jsonpfunction"]=window["indexLifecycleManagement_bundle_jsonpfunction"]||[];var oldJsonpFunction=jsonpArray.push.bind(jsonpArray);jsonpArray.push=webpackJsonpCallback;jsonpArray=jsonpArray.slice();for(var i=0;i<jsonpArray.length;i++)webpackJsonpCallback(jsonpArray[i]);var parentJsonpFunction=oldJsonpFunction;return __webpack_require__(__webpack_require__.s=21)})([function(module,exports){module.exports=__kbnSharedDeps__.React},function(module,exports){module.exports=__kbnSharedDeps__.ElasticEui},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18n},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18nReact},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return init}));__webpack_require__.d(__webpack_exports__,"d",(function(){return sendPost}));__webpack_require__.d(__webpack_exports__,"c",(function(){return sendGet}));__webpack_require__.d(__webpack_exports__,"b",(function(){return sendDelete}));__webpack_require__.d(__webpack_exports__,"e",(function(){return useRequest}));var _src_plugins_es_ui_shared_public__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(15);var _src_plugins_es_ui_shared_public__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_src_plugins_es_ui_shared_public__WEBPACK_IMPORTED_MODULE_0__);let _httpClient;function init(httpClient){_httpClient=httpClient}function getFullPath(path){const apiPrefix="/api/index_lifecycle_management";if(path){return`${apiPrefix}/${path}`}return apiPrefix}function sendPost(path,payload,query){return _httpClient.post(getFullPath(path),{body:JSON.stringify(payload),query:query})}function sendGet(path,query){return _httpClient.get(getFullPath(path),{query:query})}function sendDelete(path){return _httpClient.delete(getFullPath(path))}const useRequest=config=>Object(_src_plugins_es_ui_shared_public__WEBPACK_IMPORTED_MODULE_0__["useRequest"])(_httpClient,{...config,path:getFullPath(config.path)})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"n",(function(){return defaultIndexPriority}));__webpack_require__.d(__webpack_exports__,"p",(function(){return defaultRolloverAction}));__webpack_require__.d(__webpack_exports__,"o",(function(){return defaultPolicy}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ui_metric["b"]}));__webpack_require__.d(__webpack_exports__,"j",(function(){return ui_metric["k"]}));__webpack_require__.d(__webpack_exports__,"m",(function(){return ui_metric["n"]}));__webpack_require__.d(__webpack_exports__,"k",(function(){return ui_metric["l"]}));__webpack_require__.d(__webpack_exports__,"h",(function(){return ui_metric["i"]}));__webpack_require__.d(__webpack_exports__,"i",(function(){return ui_metric["j"]}));__webpack_require__.d(__webpack_exports__,"l",(function(){return ui_metric["m"]}));__webpack_require__.d(__webpack_exports__,"b",(function(){return ui_metric["c"]}));__webpack_require__.d(__webpack_exports__,"e",(function(){return ui_metric["f"]}));__webpack_require__.d(__webpack_exports__,"d",(function(){return ui_metric["e"]}));__webpack_require__.d(__webpack_exports__,"c",(function(){return ui_metric["d"]}));__webpack_require__.d(__webpack_exports__,"g",(function(){return ui_metric["h"]}));__webpack_require__.d(__webpack_exports__,"f",(function(){return ui_metric["g"]}));const defaultIndexPriority={hot:"100",warm:"50",cold:"0"};const defaultRolloverAction={max_age:"30d",max_size:"50gb"};const defaultPolicy={name:"",phases:{hot:{actions:{rollover:defaultRolloverAction}}}};var ui_metric=__webpack_require__(17)},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return toasts}));__webpack_require__.d(__webpack_exports__,"a",(function(){return fatalErrors}));__webpack_require__.d(__webpack_exports__,"b",(function(){return init}));let toasts;let fatalErrors;function init(_toasts,_fatalErrors){toasts=_toasts;fatalErrors=_fatalErrors}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return trackUiMetric}));__webpack_require__.d(__webpack_exports__,"b",(function(){return init}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getUiMetricsForPhases}));var _constants__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(5);let trackUiMetric=(metricType,eventName)=>{};function init(usageCollection){if(usageCollection){trackUiMetric=usageCollection.reportUiCounter.bind(usageCollection,_constants__WEBPACK_IMPORTED_MODULE_0__["a"])}}function getUiMetricsForPhases(phases){const phaseUiMetrics=[{metric:_constants__WEBPACK_IMPORTED_MODULE_0__["b"],isTracked:()=>Boolean(phases.cold)},{metric:_constants__WEBPACK_IMPORTED_MODULE_0__["e"],isTracked:()=>Boolean(phases.warm)},{metric:_constants__WEBPACK_IMPORTED_MODULE_0__["d"],isTracked:()=>{const isHotPhasePriorityChanged=phases.hot&&phases.hot.actions.set_priority&&phases.hot.actions.set_priority.priority!==parseInt(_constants__WEBPACK_IMPORTED_MODULE_0__["n"].hot,10);const isWarmPhasePriorityChanged=phases.warm&&phases.warm.actions.set_priority&&phases.warm.actions.set_priority.priority!==parseInt(_constants__WEBPACK_IMPORTED_MODULE_0__["n"].warm,10);const isColdPhasePriorityChanged=phases.cold&&phases.cold.actions.set_priority&&phases.cold.actions.set_priority.priority!==parseInt(_constants__WEBPACK_IMPORTED_MODULE_0__["n"].cold,10);return isHotPhasePriorityChanged||isWarmPhasePriorityChanged||isColdPhasePriorityChanged}},{metric:_constants__WEBPACK_IMPORTED_MODULE_0__["c"],isTracked:()=>phases.cold&&phases.cold.actions.freeze}];return phaseUiMetrics.reduce((tracked,{metric:metric,isTracked:isTracked})=>{if(isTracked()){tracked.push(metric)}return tracked},[])}},function(module,exports){module.exports=__kbnSharedDeps__.Lodash},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"j",(function(){return useLoadNodes}));__webpack_require__.d(__webpack_exports__,"i",(function(){return useLoadNodeDetails}));__webpack_require__.d(__webpack_exports__,"h",(function(){return useLoadIndexTemplates}));__webpack_require__.d(__webpack_exports__,"d",(function(){return loadPolicies}));__webpack_require__.d(__webpack_exports__,"k",(function(){return useLoadPoliciesList}));__webpack_require__.d(__webpack_exports__,"g",(function(){return savePolicy}));__webpack_require__.d(__webpack_exports__,"c",(function(){return deletePolicy}));__webpack_require__.d(__webpack_exports__,"f",(function(){return retryLifecycleForIndex}));__webpack_require__.d(__webpack_exports__,"e",(function(){return removeLifecycleForIndex}));__webpack_require__.d(__webpack_exports__,"a",(function(){return addLifecyclePolicyToIndex}));__webpack_require__.d(__webpack_exports__,"b",(function(){return addLifecyclePolicyToTemplate}));__webpack_require__.d(__webpack_exports__,"l",(function(){return useLoadSnapshotPolicies}));__webpack_require__.d(__webpack_exports__,"m",(function(){return useLoadSnapshotRepositories}));var _kbn_analytics__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(12);var _constants__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(5);var _ui_metric__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(7);var _http__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(4);const useLoadNodes=()=>Object(_http__WEBPACK_IMPORTED_MODULE_3__["e"])({path:`nodes/list`,method:"get",initialData:{nodesByAttributes:{},nodesByRoles:{}}});const useLoadNodeDetails=selectedNodeAttrs=>Object(_http__WEBPACK_IMPORTED_MODULE_3__["e"])({path:`nodes/${selectedNodeAttrs}/details`,method:"get"});const useLoadIndexTemplates=(legacy=false)=>Object(_http__WEBPACK_IMPORTED_MODULE_3__["e"])({path:"templates",query:{legacy:legacy},method:"get",initialData:[]});async function loadPolicies(withIndices){return await Object(_http__WEBPACK_IMPORTED_MODULE_3__["c"])("policies",{withIndices:withIndices})}const useLoadPoliciesList=withIndices=>Object(_http__WEBPACK_IMPORTED_MODULE_3__["e"])({path:`policies`,method:"get",query:{withIndices:withIndices}});async function savePolicy(policy){return await Object(_http__WEBPACK_IMPORTED_MODULE_3__["d"])(`policies`,policy)}async function deletePolicy(policyName){const response=await Object(_http__WEBPACK_IMPORTED_MODULE_3__["b"])(`policies/${encodeURIComponent(policyName)}`);Object(_ui_metric__WEBPACK_IMPORTED_MODULE_2__["c"])(_kbn_analytics__WEBPACK_IMPORTED_MODULE_0__["a"].COUNT,_constants__WEBPACK_IMPORTED_MODULE_1__["k"]);return response}const retryLifecycleForIndex=async indexNames=>{const response=await Object(_http__WEBPACK_IMPORTED_MODULE_3__["d"])(`index/retry`,{indexNames:indexNames});Object(_ui_metric__WEBPACK_IMPORTED_MODULE_2__["c"])(_kbn_analytics__WEBPACK_IMPORTED_MODULE_0__["a"].COUNT,_constants__WEBPACK_IMPORTED_MODULE_1__["g"]);return response};const removeLifecycleForIndex=async indexNames=>{const response=await Object(_http__WEBPACK_IMPORTED_MODULE_3__["d"])(`index/remove`,{indexNames:indexNames});Object(_ui_metric__WEBPACK_IMPORTED_MODULE_2__["c"])(_kbn_analytics__WEBPACK_IMPORTED_MODULE_0__["a"].COUNT,_constants__WEBPACK_IMPORTED_MODULE_1__["l"]);return response};const addLifecyclePolicyToIndex=async body=>{const response=await Object(_http__WEBPACK_IMPORTED_MODULE_3__["d"])(`index/add`,body);Object(_ui_metric__WEBPACK_IMPORTED_MODULE_2__["c"])(_kbn_analytics__WEBPACK_IMPORTED_MODULE_0__["a"].COUNT,_constants__WEBPACK_IMPORTED_MODULE_1__["h"]);return response};const addLifecyclePolicyToTemplate=async(body,legacy=false)=>{const response=await Object(_http__WEBPACK_IMPORTED_MODULE_3__["d"])(`template`,body,{legacy:legacy});Object(_ui_metric__WEBPACK_IMPORTED_MODULE_2__["c"])(_kbn_analytics__WEBPACK_IMPORTED_MODULE_0__["a"].COUNT,_constants__WEBPACK_IMPORTED_MODULE_1__["i"]);return response};const useLoadSnapshotPolicies=()=>Object(_http__WEBPACK_IMPORTED_MODULE_3__["e"])({path:`snapshot_policies`,method:"get",initialData:[]});const useLoadSnapshotRepositories=()=>Object(_http__WEBPACK_IMPORTED_MODULE_3__["e"])({path:`snapshot_repositories`,method:"get"})},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"c",(function(){return phaseToNodePreferenceMap}));__webpack_require__.d(__webpack_exports__,"b",(function(){return PLUGIN}));__webpack_require__.d(__webpack_exports__,"a",(function(){return MIN_SEARCHABLE_SNAPSHOT_LICENSE}));var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);const WARM_PHASE_NODE_PREFERENCE=["data_warm","data_hot"];const COLD_PHASE_NODE_PREFERENCE=["data_cold","data_warm","data_hot"];const phaseToNodePreferenceMap=Object.freeze({warm:WARM_PHASE_NODE_PREFERENCE,cold:COLD_PHASE_NODE_PREFERENCE});const MIN_PLUGIN_LICENSE="basic";const MIN_SEARCHABLE_SNAPSHOT_LICENSE="enterprise";const PLUGIN={ID:"index_lifecycle_management",minimumLicenseType:MIN_PLUGIN_LICENSE,TITLE:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.appTitle",{defaultMessage:"Index Lifecycle Policies"})};const API_BASE_PATH="/api/index_lifecycle_management"},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ROUTES}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getPolicyEditPath}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getPolicyCreatePath}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getPoliciesListPath}));const ROUTES={list:"/policies",edit:"/policies/edit/:policyName?",create:"/policies/edit"};const getPolicyEditPath=policyName=>encodeURI(`/policies/edit/${encodeURIComponent(policyName)}`);const getPolicyCreatePath=()=>ROUTES.create;const getPoliciesListPath=()=>ROUTES.list},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return METRIC_TYPE}));function wrapArray(subj){return Array.isArray(subj)?subj:[subj]}class UnreachableCaseError extends Error{constructor(val){super(`Unreachable case: ${val}`)}}function createUiCounterMetric({type:type,appName:appName,eventName:eventName,count:count=1}){return{type:type,appName:appName,eventName:eventName,count:count}}function trackUsageAgent(appName){const userAgent=window&&window.navigator&&window.navigator.userAgent||"";return{type:METRIC_TYPE.USER_AGENT,appName:appName,userAgent:userAgent}}var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(13);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);function createApplicationUsageMetric(appId,viewId){return{type:METRIC_TYPE.APPLICATION_USAGE,appId:appId,viewId:viewId,startTime:external_kbnSharedDeps_MomentTimezone_default()(),numberOfClicks:0}}let METRIC_TYPE;(function(METRIC_TYPE){METRIC_TYPE["COUNT"]="count";METRIC_TYPE["LOADED"]="loaded";METRIC_TYPE["CLICK"]="click";METRIC_TYPE["USER_AGENT"]="user_agent";METRIC_TYPE["APPLICATION_USAGE"]="application_usage"})(METRIC_TYPE||(METRIC_TYPE={}));function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class ReportStorageManager{constructor(storageKey,storage){_defineProperty(this,"storageKey",void 0);_defineProperty(this,"storage",void 0);this.storageKey=storageKey;this.storage=storage}get(){if(!this.storage)return;return this.storage.get(this.storageKey)}store(report){if(!this.storage)return;this.storage.set(this.storageKey,report)}}function application_usage_tracker_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class application_usage_tracker_ApplicationUsageTracker{constructor(reporter){application_usage_tracker_defineProperty(this,"trackedApplicationViews",{});application_usage_tracker_defineProperty(this,"reporter",void 0);application_usage_tracker_defineProperty(this,"currentAppId",void 0);application_usage_tracker_defineProperty(this,"currentApplicationKeys",[]);application_usage_tracker_defineProperty(this,"beforeUnloadListener",void 0);application_usage_tracker_defineProperty(this,"onVisiblityChangeListener",void 0);this.reporter=reporter}createKey(appId,viewId){return{appId:appId,viewId:viewId}}static serializeKey({appId:appId,viewId:viewId}){return`${appId}-${viewId}`}trackApplications(appKeys){for(const{appId:appId,viewId:viewId}of appKeys.filter(Boolean)){const serializedKey=application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:appId,viewId:viewId});if(typeof this.trackedApplicationViews[serializedKey]!=="undefined"){continue}const metric=createApplicationUsageMetric(appId,viewId);this.trackedApplicationViews[serializedKey]=metric}}attachListeners(){if(typeof window==="undefined"||typeof document==="undefined"){return}this.beforeUnloadListener=()=>{this.flushTrackedViews()};this.onVisiblityChangeListener=()=>{if(document.visibilityState==="visible"){this.resumeTrackingAll()}else if(document.visibilityState==="hidden"){this.pauseTrackingAll()}};window.addEventListener("beforeunload",this.beforeUnloadListener);document.addEventListener("visibilitychange",this.onVisiblityChangeListener)}detachListeners(){if(typeof window==="undefined"||typeof document==="undefined"){return}if(this.beforeUnloadListener){window.removeEventListener("beforeunload",this.beforeUnloadListener)}if(this.onVisiblityChangeListener){document.removeEventListener("visibilitychange",this.onVisiblityChangeListener)}}sendMetricsToReporter(metrics){metrics.forEach(metric=>{this.reporter.reportApplicationUsage(metric)})}updateViewClickCounter(viewId){if(!this.currentAppId){return}const appKey=application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:this.currentAppId,viewId:viewId});if(this.trackedApplicationViews[appKey]){this.trackedApplicationViews[appKey].numberOfClicks++}}flushTrackedViews(){const appViewMetrics=Object.values(this.trackedApplicationViews);this.sendMetricsToReporter(appViewMetrics);this.trackedApplicationViews={}}start(){this.attachListeners()}stop(){this.flushTrackedViews();this.detachListeners()}setCurrentAppId(appId){this.flushTrackedViews();this.currentAppId=appId}trackApplicationViewUsage(viewId){if(!this.currentAppId){return}const appKey=this.createKey(this.currentAppId,viewId);this.trackApplications([appKey])}pauseTrackingAll(){this.currentApplicationKeys=Object.values(this.trackedApplicationViews).map(({appId:appId,viewId:viewId})=>this.createKey(appId,viewId));this.flushTrackedViews()}resumeTrackingAll(){this.trackApplications(this.currentApplicationKeys);this.currentApplicationKeys=[];this.reporter.sendReports()}flushTrackedView(viewId){if(!this.currentAppId){return}const appKey=this.createKey(this.currentAppId,viewId);const serializedKey=application_usage_tracker_ApplicationUsageTracker.serializeKey(appKey);const appViewMetric=this.trackedApplicationViews[serializedKey];this.sendMetricsToReporter([appViewMetric]);delete this.trackedApplicationViews[serializedKey]}}function report_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const REPORT_VERSION=3;class report_ReportManager{constructor(report){report_defineProperty(this,"report",void 0);this.report=report||report_ReportManager.createReport()}static createReport(){return{reportVersion:REPORT_VERSION}}clearReport(){this.report=report_ReportManager.createReport()}isReportEmpty(){const{uiCounter:uiCounter,userAgent:userAgent,application_usage:appUsage}=this.report;const noUiCounters=!uiCounter||Object.keys(uiCounter).length===0;const noUserAgents=!userAgent||Object.keys(userAgent).length===0;const noAppUsage=!appUsage||Object.keys(appUsage).length===0;return noUiCounters&&noUserAgents&&noAppUsage}incrementTotal(count,currentTotal){const currentTotalNumber=typeof currentTotal==="number"?currentTotal:0;return count+currentTotalNumber}assignReports(newMetrics){wrapArray(newMetrics).forEach(newMetric=>this.assignReport(this.report,newMetric));return{report:this.report}}static createMetricKey(metric){switch(metric.type){case METRIC_TYPE.USER_AGENT:{const{appName:appName,type:type}=metric;return`${appName}-${type}`}case METRIC_TYPE.CLICK:case METRIC_TYPE.LOADED:case METRIC_TYPE.COUNT:{const{appName:appName,eventName:eventName,type:type}=metric;return`${appName}-${type}-${eventName}`}case METRIC_TYPE.APPLICATION_USAGE:{const{appId:appId,viewId:viewId}=metric;return application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:appId,viewId:viewId})}default:throw new UnreachableCaseError(metric)}}assignReport(report,metric){const key=report_ReportManager.createMetricKey(metric);switch(metric.type){case METRIC_TYPE.USER_AGENT:{const{appName:appName,type:type,userAgent:userAgent}=metric;if(userAgent){report.userAgent={[key]:{key:key,appName:appName,type:type,userAgent:metric.userAgent}}}return}case METRIC_TYPE.CLICK:case METRIC_TYPE.LOADED:case METRIC_TYPE.COUNT:{var _report$uiCounter$key;const{appName:appName,type:type,eventName:eventName,count:count}=metric;report.uiCounter=report.uiCounter||{};const currentTotal=(_report$uiCounter$key=report.uiCounter[key])===null||_report$uiCounter$key===void 0?void 0:_report$uiCounter$key.total;report.uiCounter[key]={key:key,appName:appName,eventName:eventName,type:type,total:this.incrementTotal(count,currentTotal)};return}case METRIC_TYPE.APPLICATION_USAGE:{const{numberOfClicks:numberOfClicks,startTime:startTime,appId:appId,viewId:viewId}=metric;const minutesOnScreen=external_kbnSharedDeps_MomentTimezone_default()().diff(startTime,"minutes",true);report.application_usage=report.application_usage||{};const appExistingData=report.application_usage[key]||{minutesOnScreen:0,numberOfClicks:0,appId:appId,viewId:viewId};report.application_usage[key]={...appExistingData,minutesOnScreen:appExistingData.minutesOnScreen+minutesOnScreen,numberOfClicks:appExistingData.numberOfClicks+numberOfClicks};return}default:throw new UnreachableCaseError(metric)}}}report_defineProperty(report_ReportManager,"REPORT_VERSION",REPORT_VERSION);function reporter_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class reporter_Reporter{constructor(config){reporter_defineProperty(this,"checkInterval",void 0);reporter_defineProperty(this,"interval",void 0);reporter_defineProperty(this,"http",void 0);reporter_defineProperty(this,"reportManager",void 0);reporter_defineProperty(this,"storageManager",void 0);reporter_defineProperty(this,"debug",void 0);reporter_defineProperty(this,"retryCount",0);reporter_defineProperty(this,"maxRetries",3);reporter_defineProperty(this,"start",()=>{if(!this.interval){this.interval=setTimeout(()=>{this.interval=undefined;this.sendReports()},this.checkInterval)}});reporter_defineProperty(this,"reportUiCounter",(appName,type,eventNames,count)=>{const metrics=wrapArray(eventNames).map(eventName=>{this.log(`${type} Metric -> (${appName}:${eventName}):`);const report=createUiCounterMetric({type:type,appName:appName,eventName:eventName,count:count});this.log(report);return report});this.saveToReport(metrics)});reporter_defineProperty(this,"reportUserAgent",appName=>{this.log(`Reporting user-agent.`);const report=trackUsageAgent(appName);this.saveToReport([report])});reporter_defineProperty(this,"sendReports",async()=>{if(!this.reportManager.isReportEmpty()){try{await this.http(this.reportManager.report);this.flushReport()}catch(err){this.log(`Error Sending Metrics Report ${err}`);this.retryCount=this.retryCount+1;const versionMismatch=this.reportManager.report.reportVersion!==report_ReportManager.REPORT_VERSION;if(versionMismatch||this.retryCount>this.maxRetries){this.flushReport()}}}this.start()});const{http:http,storage:storage,debug:debug,checkInterval:checkInterval=9e4,storageKey:storageKey="analytics"}=config;this.http=http;this.checkInterval=checkInterval;this.storageManager=new ReportStorageManager(storageKey,storage);const storedReport=this.storageManager.get();this.reportManager=new report_ReportManager(storedReport);this.debug=!!debug}saveToReport(newMetrics){this.reportManager.assignReports(newMetrics);this.storageManager.store(this.reportManager.report)}flushReport(){this.retryCount=0;this.reportManager.clearReport();this.storageManager.store(this.reportManager.report)}log(message){if(this.debug){console.debug(message)}}reportApplicationUsage(appUsageReport){this.log(`Reporting application usage for ${appUsageReport.appId}, ${appUsageReport.viewId}`);this.saveToReport([appUsageReport])}}},function(module,exports){module.exports=__kbnSharedDeps__.MomentTimezone},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return showApiError}));var _notification__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(6);function createToastConfig(error,errorTitle){if(error&&error.body){var _attributes$causes;const{error:errorString,statusCode:statusCode,message:errorMessage,attributes:attributes}=error.body;const message=attributes!==null&&attributes!==void 0&&(_attributes$causes=attributes.causes)!==null&&_attributes$causes!==void 0&&_attributes$causes.length?attributes.causes[attributes.causes.length-1]:errorMessage;return{title:errorTitle,text:`${statusCode}: ${errorString}. ${message}`}}}function showApiWarning(error,errorTitle){const toastConfig=createToastConfig(error,errorTitle);if(toastConfig){return _notification__WEBPACK_IMPORTED_MODULE_0__["c"].addWarning(toastConfig)}return _notification__WEBPACK_IMPORTED_MODULE_0__["a"].add(error,errorTitle)}function showApiError(error,errorTitle){const toastConfig=createToastConfig(error,errorTitle);if(toastConfig){return _notification__WEBPACK_IMPORTED_MODULE_0__["c"].addDanger(toastConfig)}_notification__WEBPACK_IMPORTED_MODULE_0__["a"].add(error,errorTitle)}},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/esUiShared/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return init}));__webpack_require__.d(__webpack_exports__,"a",(function(){return createDocLink}));let skippingDisconnectedClustersUrl;let remoteClustersUrl;let transportPortUrl;let _esDocBasePath;function init(esDocBasePath){_esDocBasePath=esDocBasePath}const createDocLink=docPath=>`${_esDocBasePath}${docPath}`},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return UIM_APP_NAME}));__webpack_require__.d(__webpack_exports__,"a",(function(){return UIM_APP_LOAD}));__webpack_require__.d(__webpack_exports__,"k",(function(){return UIM_POLICY_CREATE}));__webpack_require__.d(__webpack_exports__,"n",(function(){return UIM_POLICY_UPDATE}));__webpack_require__.d(__webpack_exports__,"l",(function(){return UIM_POLICY_DELETE}));__webpack_require__.d(__webpack_exports__,"i",(function(){return UIM_POLICY_ATTACH_INDEX}));__webpack_require__.d(__webpack_exports__,"j",(function(){return UIM_POLICY_ATTACH_INDEX_TEMPLATE}));__webpack_require__.d(__webpack_exports__,"m",(function(){return UIM_POLICY_DETACH_INDEX}));__webpack_require__.d(__webpack_exports__,"c",(function(){return UIM_CONFIG_COLD_PHASE}));__webpack_require__.d(__webpack_exports__,"f",(function(){return UIM_CONFIG_WARM_PHASE}));__webpack_require__.d(__webpack_exports__,"e",(function(){return UIM_CONFIG_SET_PRIORITY}));__webpack_require__.d(__webpack_exports__,"d",(function(){return UIM_CONFIG_FREEZE_INDEX}));__webpack_require__.d(__webpack_exports__,"h",(function(){return UIM_INDEX_RETRY_STEP}));__webpack_require__.d(__webpack_exports__,"g",(function(){return UIM_EDIT_CLICK}));const UIM_APP_NAME="index_lifecycle_management";const UIM_APP_LOAD="app_load";const UIM_POLICY_CREATE="policy_create";const UIM_POLICY_UPDATE="policy_update";const UIM_POLICY_DELETE="policy_delete";const UIM_POLICY_ATTACH_INDEX="policy_attach_index";const UIM_POLICY_ATTACH_INDEX_TEMPLATE="policy_attach_index_template";const UIM_POLICY_DETACH_INDEX="policy_detach_index";const UIM_CONFIG_COLD_PHASE="config_cold_phase";const UIM_CONFIG_WARM_PHASE="config_warm_phase";const UIM_CONFIG_SET_PRIORITY="config_set_priority";const UIM_CONFIG_FREEZE_INDEX="config_freeze_index";const UIM_INDEX_RETRY_STEP="index_retry_step";const UIM_EDIT_CLICK="edit_click"},function(module,exports){module.exports=__kbnSharedDeps__.RxjsOperators},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/home/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/management/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_val_loader_dist_cjs_js_key_indexLifecycleManagement_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(22);var _node_modules_val_loader_dist_cjs_js_key_indexLifecycleManagement_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_val_loader_dist_cjs_js_key_indexLifecycleManagement_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__);__kbnBundles__.define("plugin/indexLifecycleManagement/public",__webpack_require__,23)},function(module,exports,__webpack_require__){__webpack_require__.p=window.__kbnPublicPath__["indexLifecycleManagement"]},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"plugin",(function(){return public_plugin}));__webpack_require__.d(__webpack_exports__,"ILM_URL_GENERATOR_ID",(function(){return ILM_URL_GENERATOR_ID}));__webpack_require__.d(__webpack_exports__,"IlmUrlGeneratorState",(function(){return undefined}));var external_kbnSharedDeps_RxjsOperators_=__webpack_require__(18);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(2);var public_=__webpack_require__(19);var constants=__webpack_require__(10);var services_http=__webpack_require__(4);var documentation=__webpack_require__(16);var ui_metric=__webpack_require__(7);var notification=__webpack_require__(6);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const breadcrumbs=function(){const policies=[{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.breadcrumb.homeLabel",{defaultMessage:"Index Lifecycle Management"}),href:`/policies`}];const editPolicy=[...policies,{text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.breadcrumb.editPolicyLabel",{defaultMessage:"Edit policy"}),href:undefined}];return{policies:policies,editPolicy:editPolicy}}();class BreadcrumbService{constructor(){_defineProperty(this,"setBreadcrumbsHandler",void 0)}setup(setBreadcrumbsHandler){this.setBreadcrumbsHandler=setBreadcrumbsHandler}setBreadcrumbs(type){if(!this.setBreadcrumbsHandler){throw new Error(`BreadcrumbService#setup() must be called first!`)}const newBreadcrumbs=breadcrumbs[type]?[...breadcrumbs[type]]:[...breadcrumbs.policies];const lastBreadcrumb=newBreadcrumbs.pop();newBreadcrumbs.push({...lastBreadcrumb,href:undefined});this.setBreadcrumbsHandler(newBreadcrumbs)}}var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_Lodash_=__webpack_require__(8);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(1);var api=__webpack_require__(9);var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(13);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(3);var navigation=__webpack_require__(11);function index_lifecycle_summary_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const getHeaders=()=>[["policy",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.lifecyclePolicyHeader",{defaultMessage:"Lifecycle policy"})],["phase",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentPhaseHeader",{defaultMessage:"Current phase"})],["action",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionHeader",{defaultMessage:"Current action"})],["action_time_millis",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionTimeHeader",{defaultMessage:"Current action time"})],["failed_step",external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.failedStepHeader",{defaultMessage:"Failed step"})]];class index_lifecycle_summary_IndexLifecycleSummary extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);index_lifecycle_summary_defineProperty(this,"toggleStackPopover",()=>{this.setState({showStackPopover:!this.state.showStackPopover})});index_lifecycle_summary_defineProperty(this,"closeStackPopover",()=>{this.setState({showStackPopover:false})});index_lifecycle_summary_defineProperty(this,"togglePhaseExecutionPopover",()=>{this.setState({showPhaseExecutionPopover:!this.state.showPhaseExecutionPopover})});index_lifecycle_summary_defineProperty(this,"closePhaseExecutionPopover",()=>{this.setState({showPhaseExecutionPopover:false})});this.state={showStackPopover:false,showPhaseExecutionPopover:false}}renderStackPopoverButton(ilm){if(!ilm.step_info.stack_trace){return null}const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:this.toggleStackPopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Stack trace",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.stackTraceButton"}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"stackPopover",button:button,isOpen:this.state.showStackPopover,closePopover:this.closeStackPopover},external_kbnSharedDeps_React_default.a.createElement("div",{style:{maxHeight:"400px",width:"900px",overflowY:"scroll"}},external_kbnSharedDeps_React_default.a.createElement("pre",null,ilm.step_info.stack_trace)))}renderPhaseExecutionPopoverButton(ilm){const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:this.togglePhaseExecutionPopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Show definition",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.showPhaseDefinitionButton"}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:"phaseDefinition"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{key:"phaseDefinition_title"},external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Phase definition",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.showPhaseDefinitionDescriptionTitle"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{key:"phaseDefinition_desc"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{key:"phaseExecutionPopover",id:"phaseExecutionPopover",button:button,isOpen:this.state.showPhaseExecutionPopover,closePopover:this.closePhaseExecutionPopover},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopoverTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Phase definition",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.phaseDefinitionTitle"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{lang:"json"},JSON.stringify(ilm.phase_execution,null,2)))))}buildRows(){const{index:{ilm:ilm}}=this.props;const headers=getHeaders();const rows={left:[],right:[]};headers.forEach(([fieldName,label],arrayIndex)=>{const value=ilm[fieldName];let content;if(fieldName==="action_time_millis"){content=external_kbnSharedDeps_MomentTimezone_default()(value).format("YYYY-MM-DD HH:mm:ss")}else if(fieldName==="policy"){content=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:this.props.getUrlForApp("management",{path:`data/index_lifecycle_management/${Object(navigation["d"])(value)}`})},value)}else{content=value}content=content||"-";const cell=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:String(arrayIndex)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{key:fieldName},external_kbnSharedDeps_React_default.a.createElement("strong",null,label)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{key:fieldName+"_desc"},content));if(arrayIndex%2===0){rows.left.push(cell)}else{rows.right.push(cell)}});if(ilm.phase_execution){rows.right.push(this.renderPhaseExecutionPopoverButton(ilm))}return rows}render(){const{index:{ilm:ilm}}=this.props;if(!ilm.managed){return null}const{left:left,right:right}=this.buildRows();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Index lifecycle management",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.summaryTitle"}))),ilm.step_info&&ilm.step_info.type?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Index lifecycle error",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.summaryErrorMessage"}),iconType:"cross"},ilm.step_info.type,": ",ilm.step_info.reason,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),this.renderStackPopoverButton(ilm))):null,ilm.step_info&&ilm.step_info.message&&!ilm.step_info.stack_trace?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"primary",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{defaultMessage:"Action status",id:"xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.actionStatusTitle"})},ilm.step_info.message)):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{type:"column"},left)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{type:"column"},right))))}}var api_errors=__webpack_require__(14);function add_lifecycle_confirm_modal_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class add_lifecycle_confirm_modal_AddLifecyclePolicyConfirmModal extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);add_lifecycle_confirm_modal_defineProperty(this,"addPolicy",async()=>{const{indexName:indexName,closeModal:closeModal,reloadIndices:reloadIndices}=this.props;const{selectedPolicyName:selectedPolicyName,selectedAlias:selectedAlias}=this.state;if(!selectedPolicyName){this.setState({policyErrorMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.noPolicySelectedErrorMessage",{defaultMessage:"You must select a policy."})});return}try{const body={indexName:indexName,policyName:selectedPolicyName,alias:selectedAlias};await Object(api["a"])(body);closeModal();notification["c"].addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyToIndexSuccess",{defaultMessage:"Added policy {policyName} to index {indexName}.",values:{policyName:selectedPolicyName,indexName:indexName}}));reloadIndices()}catch(err){Object(api_errors["a"])(err,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyToIndexError",{defaultMessage:"Error adding policy to index"}))}});add_lifecycle_confirm_modal_defineProperty(this,"renderAliasFormElement",selectedPolicy=>{const{selectedAlias:selectedAlias}=this.state;const{index:index}=this.props;const showAliasSelect=selectedPolicy&&Object(external_kbnSharedDeps_Lodash_["get"])(selectedPolicy,"policy.phases.hot.actions.rollover");if(!showAliasSelect){return null}const{aliases:aliases}=index;if(aliases==="none"){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{style:{maxWidth:400},title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.indexHasNoAliasesWarningTitle",defaultMessage:"Index has no aliases"}),color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.indexHasNoAliasesWarningMessage",defaultMessage:"Policy {policyName} is configured for rollover, but index {indexName} does not have an alias, which is required for rollover.",values:{policyName:selectedPolicy===null||selectedPolicy===void 0?void 0:selectedPolicy.name,indexName:index.name}})))}const aliasOptions=aliases.map(alias=>({text:alias,value:alias}));aliasOptions.unshift({text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.chooseAliasMessage",{defaultMessage:"Choose an alias"}),value:""});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.chooseAliasLabel",defaultMessage:"Index rollover alias"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:aliasOptions,value:selectedAlias,onChange:e=>{this.setState({selectedAlias:e.target.value})}}))});this.state={policies:[],selectedPolicyName:"",selectedAlias:""}}renderForm(){const{policies:policies,selectedPolicyName:selectedPolicyName,policyErrorMessage:policyErrorMessage}=this.state;const selectedPolicy=selectedPolicyName?policies.find(policy=>policy.name===selectedPolicyName):undefined;const options=policies.map(({name:name})=>({value:name,text:name}));options.unshift({value:"",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.choosePolicyMessage",{defaultMessage:"Select a lifecycle policy"})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{isInvalid:!!policyErrorMessage,error:policyErrorMessage,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.choosePolicyLabel",defaultMessage:"Lifecycle policy"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:options,value:selectedPolicyName,onChange:e=>{this.setState({policyErrorMessage:undefined,selectedPolicyName:e.target.value})}})),this.renderAliasFormElement(selectedPolicy))}async componentDidMount(){try{const policies=await Object(api["d"])(false);this.setState({policies:policies})}catch(err){Object(api_errors["a"])(err,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.loadPolicyError",{defaultMessage:"Error loading policy list"}));this.props.closeModal()}}render(){const{policies:policies}=this.state;const{indexName:indexName,closeModal:closeModal,getUrlForApp:getUrlForApp}=this.props;const title=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.modalTitle",defaultMessage:'Add lifecycle policy to "{indexName}"',values:{indexName:indexName}});if(!policies.length){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:closeModal},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{style:{maxWidth:400},title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.noPoliciesWarningTitle",defaultMessage:"No index lifecycle policies defined"}),color:"warning"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getUrlForApp("management",{path:`data/index_lifecycle_management/policies/edit`})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.defineLifecyclePolicyLinkText",defaultMessage:"Define lifecycle policy"}))))))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:title,onCancel:closeModal,onConfirm:this.addPolicy,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.cancelButtonText",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.addLifecyclePolicyConfirmModal.addPolicyButtonText",defaultMessage:"Add policy"})},this.renderForm())}}function remove_lifecycle_confirm_modal_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class remove_lifecycle_confirm_modal_RemoveLifecyclePolicyConfirmModal extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);remove_lifecycle_confirm_modal_defineProperty(this,"removePolicy",async()=>{const{indexNames:indexNames,closeModal:closeModal,reloadIndices:reloadIndices}=this.props;try{await Object(api["e"])(indexNames);closeModal();notification["c"].addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.removeLifecyclePolicyConfirmModal.removePolicySuccess",{defaultMessage:"Removed lifecycle policy from {count, plural, one {index} other {indices}}",values:{count:indexNames.length}}));reloadIndices()}catch(err){Object(api_errors["a"])(err,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexManagementTable.removeLifecyclePolicyConfirmModal.removePolicyToIndexError",{defaultMessage:"Error removing policy"}))}})}render(){const{closeModal:closeModal,indexNames:indexNames}=this.props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.removeLifecyclePolicyConfirmModal.modalTitle",defaultMessage:"Remove lifecycle policy from {count, plural, one {index} other {indices}}",values:{count:indexNames.length}}),onCancel:closeModal,onConfirm:this.removePolicy,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.removeLifecyclePolicyConfirmModal.cancelButtonText",defaultMessage:"Cancel"}),buttonColor:"danger",confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.removeLifecyclePolicyConfirmModal.removePolicyButtonText",defaultMessage:"Remove policy"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.indexLifecycleMgmt.indexManagementTable.removeLifecyclePolicyConfirmModal.removeMessage",defaultMessage:"You are about to remove the index lifecycle policy from {count, plural, one {this index} other {these indices}}. This operation cannot be undone.",values:{count:indexNames.length}})),external_kbnSharedDeps_React_default.a.createElement("ul",null,indexNames.map(indexName=>external_kbnSharedDeps_React_default.a.createElement("li",{key:indexName},indexName)))))}}const stepPath="ilm.step";const retryLifecycleActionExtension=({indices:indices})=>{const allHaveErrors=Object(external_kbnSharedDeps_Lodash_["every"])(indices,index=>index.ilm&&index.ilm.failed_step);if(!allHaveErrors){return null}const indexNames=indices.map(({name:name})=>name);return{requestMethod:api["f"],icon:"play",indexNames:[indexNames],buttonLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.retryIndexLifecycleActionButtonLabel",{defaultMessage:"Retry lifecycle step"}),successMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.retryIndexLifecycleAction.retriedLifecycleMessage",{defaultMessage:"Called retry lifecycle step for: {indexNames}",values:{indexNames:indexNames.map(indexName=>`"${indexName}"`).join(", ")}})}};const removeLifecyclePolicyActionExtension=({indices:indices,reloadIndices:reloadIndices})=>{const allHaveIlm=Object(external_kbnSharedDeps_Lodash_["every"])(indices,index=>index.ilm&&index.ilm.managed);if(!allHaveIlm){return null}const indexNames=indices.map(({name:name})=>name);return{renderConfirmModal:closeModal=>external_kbnSharedDeps_React_default.a.createElement(remove_lifecycle_confirm_modal_RemoveLifecyclePolicyConfirmModal,{indexNames:indexNames,closeModal:closeModal,reloadIndices:reloadIndices}),icon:"stopFilled",indexNames:[indexNames],buttonLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.removeIndexLifecycleActionButtonLabel",{defaultMessage:"Remove lifecycle policy"})}};const addLifecyclePolicyActionExtension=({indices:indices,reloadIndices:reloadIndices,getUrlForApp:getUrlForApp})=>{if(indices.length!==1){return null}const index=indices[0];const hasIlm=index.ilm&&index.ilm.managed;if(hasIlm){return null}const indexName=index.name;return{renderConfirmModal:closeModal=>external_kbnSharedDeps_React_default.a.createElement(add_lifecycle_confirm_modal_AddLifecyclePolicyConfirmModal,{indexName:indexName,closeModal:closeModal,index:index,reloadIndices:reloadIndices,getUrlForApp:getUrlForApp}),icon:"plusInCircle",buttonLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.addLifecyclePolicyActionButtonLabel",{defaultMessage:"Add lifecycle policy"})}};const ilmBannerExtension=indices=>{const{Query:Query}=external_kbnSharedDeps_ElasticEui_["EuiSearchBar"];if(!indices.length){return null}const indicesWithLifecycleErrors=indices.filter(index=>Object(external_kbnSharedDeps_Lodash_["get"])(index,stepPath)==="ERROR");const numIndicesWithLifecycleErrors=indicesWithLifecycleErrors.length;if(!numIndicesWithLifecycleErrors){return null}return{type:"warning",filter:Query.parse(`${stepPath}:ERROR`),filterLabel:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtBanner.filterLabel",{defaultMessage:"Show errors"}),title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtBanner.errorMessage",{defaultMessage:`{ numIndicesWithLifecycleErrors, number}\n          {numIndicesWithLifecycleErrors, plural, one {index has} other {indices have} }\n          lifecycle errors`,values:{numIndicesWithLifecycleErrors:numIndicesWithLifecycleErrors}})}};const ilmSummaryExtension=(index,getUrlForApp)=>external_kbnSharedDeps_React_default.a.createElement(index_lifecycle_summary_IndexLifecycleSummary,{index:index,getUrlForApp:getUrlForApp});const ilmFilterExtension=indices=>{const hasIlm=Object(external_kbnSharedDeps_Lodash_["some"])(indices,index=>index.ilm&&index.ilm.managed);if(!hasIlm){return[]}else{return[{type:"field_value_selection",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.lifecycleStatusLabel",{defaultMessage:"Lifecycle status"}),multiSelect:false,field:"ilm.managed",options:[{value:true,view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.managedLabel",{defaultMessage:"Managed"})},{value:false,view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.unmanagedLabel",{defaultMessage:"Unmanaged"})}]},{type:"field_value_selection",field:"ilm.phase",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.lifecyclePhaseLabel",{defaultMessage:"Lifecycle phase"}),multiSelect:"or",options:[{value:"hot",view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.hotLabel",{defaultMessage:"Hot"})},{value:"warm",view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.warmLabel",{defaultMessage:"Warm"})},{value:"frozen",view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.frozenLabel",{defaultMessage:"Frozen"})},{value:"cold",view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.coldLabel",{defaultMessage:"Cold"})},{value:"delete",view:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.indexMgmtFilter.deleteLabel",{defaultMessage:"Delete"})}]}]}};const addAllExtensions=extensionsService=>{extensionsService.addAction(retryLifecycleActionExtension);extensionsService.addAction(removeLifecyclePolicyActionExtension);extensionsService.addAction(addLifecyclePolicyActionExtension);extensionsService.addBanner(ilmBannerExtension);extensionsService.addSummary(ilmSummaryExtension);extensionsService.addFilter(ilmFilterExtension)};var management_public_=__webpack_require__(20);const ILM_URL_GENERATOR_ID="ILM_URL_GENERATOR_ID";const createIlmUrlGenerator=getAppBasePath=>({id:ILM_URL_GENERATOR_ID,createUrl:async state=>{switch(state.page){case"policy_create":{return`${await getAppBasePath(!!state.absolute)}${Object(navigation["c"])()}`}case"policy_edit":{return`${await getAppBasePath(!!state.absolute)}${Object(navigation["d"])(state.policyName)}`}case"policies_list":{return`${await getAppBasePath(!!state.absolute)}${Object(navigation["b"])()}`}}}});const registerUrlGenerator=(coreSetup,management,share)=>{const getAppBasePath=async(absolute=false)=>{const[coreStart]=await coreSetup.getStartServices();return coreStart.application.getUrlForApp(management_public_["MANAGEMENT_APP_ID"],{path:management.sections.section.data.getApp(constants["b"].ID).basePath,absolute:absolute})};share.urlGenerators.registerUrlGenerator(createIlmUrlGenerator(getAppBasePath))};function plugin_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class plugin_IndexLifecycleManagementPlugin{constructor(initializerContext){this.initializerContext=initializerContext;plugin_defineProperty(this,"breadcrumbService",new BreadcrumbService)}setup(coreSetup,plugins){const{ui:{enabled:isIndexLifecycleManagementUiEnabled}}=this.initializerContext.config.get();if(isIndexLifecycleManagementUiEnabled){const{http:http,notifications:{toasts:toasts},fatalErrors:fatalErrors,getStartServices:getStartServices}=coreSetup;const{usageCollection:usageCollection,management:management,indexManagement:indexManagement,home:home,cloud:cloud,share:share}=plugins;Object(services_http["a"])(http);Object(ui_metric["b"])(usageCollection);Object(notification["b"])(toasts,fatalErrors);management.sections.section.data.registerApp({id:constants["b"].ID,title:constants["b"].TITLE,order:2,mount:async({element:element,history:history,setBreadcrumbs:setBreadcrumbs})=>{const[coreStart,{licensing:licensing}]=await getStartServices();const{chrome:{docTitle:docTitle},i18n:{Context:I18nContext},docLinks:{ELASTIC_WEBSITE_URL:ELASTIC_WEBSITE_URL,DOC_LINK_VERSION:DOC_LINK_VERSION},application:{navigateToApp:navigateToApp,getUrlForApp:getUrlForApp}}=coreStart;const license=await licensing.license$.pipe(Object(external_kbnSharedDeps_RxjsOperators_["first"])()).toPromise();docTitle.change(constants["b"].TITLE);this.breadcrumbService.setup(setBreadcrumbs);Object(documentation["b"])(`${ELASTIC_WEBSITE_URL}guide/en/elasticsearch/reference/${DOC_LINK_VERSION}/`);const{renderApp:renderApp}=await __webpack_require__.e(1).then(__webpack_require__.bind(null,105));const unmountAppCallback=renderApp(element,I18nContext,history,navigateToApp,getUrlForApp,this.breadcrumbService,license,cloud);return()=>{docTitle.reset();unmountAppCallback()}}});if(home){home.featureCatalogue.register({id:constants["b"].ID,title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.featureCatalogueTitle",{defaultMessage:"Manage index lifecycles"}),description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.indexLifecycleMgmt.featureCatalogueDescription",{defaultMessage:"Define lifecycle policies to automatically perform operations as an index ages."}),icon:"indexSettings",path:"/app/management/data/index_lifecycle_management",showOnHomePage:true,category:public_["FeatureCatalogueCategory"].ADMIN,order:640})}if(indexManagement){addAllExtensions(indexManagement.extensionsService)}registerUrlGenerator(coreSetup,management,share)}}start(){}stop(){}}const public_plugin=initializerContext=>new plugin_IndexLifecycleManagementPlugin(initializerContext)},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/esUiShared/static/forms/hook_form_lib");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/esUiShared/static/forms/components");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/kibanaReact/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/esUiShared/static/forms/helpers");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))},function(module,exports){module.exports=__kbnSharedDeps__.Moment},function(module,exports){module.exports=__kbnSharedDeps__.ReactDom},function(module,exports){module.exports=__kbnSharedDeps__.ReactRouterDom},function(module,exports){module.exports=__kbnSharedDeps__.ElasticEuiLibServices},function(module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__);var ns=__kbnBundles__.get("plugin/indexManagement/public");Object.defineProperties(__webpack_exports__,Object.getOwnPropertyDescriptors(ns))}]);