/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */(function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId]){return installedModules[moduleId].exports}var module=installedModules[moduleId]={i:moduleId,l:false,exports:{}};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.l=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.d=function(exports,name,getter){if(!__webpack_require__.o(exports,name)){Object.defineProperty(exports,name,{enumerable:true,get:getter})}};__webpack_require__.r=function(exports){if(typeof Symbol!=="undefined"&&Symbol.toStringTag){Object.defineProperty(exports,Symbol.toStringTag,{value:"Module"})}Object.defineProperty(exports,"__esModule",{value:true})};__webpack_require__.t=function(value,mode){if(mode&1)value=__webpack_require__(value);if(mode&8)return value;if(mode&4&&typeof value==="object"&&value&&value.__esModule)return value;var ns=Object.create(null);__webpack_require__.r(ns);Object.defineProperty(ns,"default",{enumerable:true,value:value});if(mode&2&&typeof value!="string")for(var key in value)__webpack_require__.d(ns,key,function(key){return value[key]}.bind(null,key));return ns};__webpack_require__.n=function(module){var getter=module&&module.__esModule?function getDefault(){return module["default"]}:function getModuleExports(){return module};__webpack_require__.d(getter,"a",getter);return getter};__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)};__webpack_require__.p="";return __webpack_require__(__webpack_require__.s=13)})([function(module,exports){module.exports=__kbnSharedDeps__.React},function(module,exports){module.exports=__kbnSharedDeps__.ElasticEui},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18nReact},function(module,exports){module.exports=__kbnSharedDeps__.KbnI18n},function(module,exports){},function(module,exports,__webpack_require__){"use strict";var isOldIE=function isOldIE(){var memo;return function memorize(){if(typeof memo==="undefined"){memo=Boolean(window&&document&&document.all&&!window.atob)}return memo}}();var getTarget=function getTarget(){var memo={};return function memorize(target){if(typeof memo[target]==="undefined"){var styleTarget=document.querySelector(target);if(window.HTMLIFrameElement&&styleTarget instanceof window.HTMLIFrameElement){try{styleTarget=styleTarget.contentDocument.head}catch(e){styleTarget=null}}memo[target]=styleTarget}return memo[target]}}();var stylesInDom=[];function getIndexByIdentifier(identifier){var result=-1;for(var i=0;i<stylesInDom.length;i++){if(stylesInDom[i].identifier===identifier){result=i;break}}return result}function modulesToDom(list,options){var idCountMap={};var identifiers=[];for(var i=0;i<list.length;i++){var item=list[i];var id=options.base?item[0]+options.base:item[0];var count=idCountMap[id]||0;var identifier="".concat(id," ").concat(count);idCountMap[id]=count+1;var index=getIndexByIdentifier(identifier);var obj={css:item[1],media:item[2],sourceMap:item[3]};if(index!==-1){stylesInDom[index].references++;stylesInDom[index].updater(obj)}else{stylesInDom.push({identifier:identifier,updater:addStyle(obj,options),references:1})}identifiers.push(identifier)}return identifiers}function insertStyleElement(options){var style=document.createElement("style");var attributes=options.attributes||{};if(typeof attributes.nonce==="undefined"){var nonce=true?__webpack_require__.nc:undefined;if(nonce){attributes.nonce=nonce}}Object.keys(attributes).forEach((function(key){style.setAttribute(key,attributes[key])}));if(typeof options.insert==="function"){options.insert(style)}else{var target=getTarget(options.insert||"head");if(!target){throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.")}target.appendChild(style)}return style}function removeStyleElement(style){if(style.parentNode===null){return false}style.parentNode.removeChild(style)}var replaceText=function replaceText(){var textStore=[];return function replace(index,replacement){textStore[index]=replacement;return textStore.filter(Boolean).join("\n")}}();function applyToSingletonTag(style,index,remove,obj){var css=remove?"":obj.media?"@media ".concat(obj.media," {").concat(obj.css,"}"):obj.css;if(style.styleSheet){style.styleSheet.cssText=replaceText(index,css)}else{var cssNode=document.createTextNode(css);var childNodes=style.childNodes;if(childNodes[index]){style.removeChild(childNodes[index])}if(childNodes.length){style.insertBefore(cssNode,childNodes[index])}else{style.appendChild(cssNode)}}}function applyToTag(style,options,obj){var css=obj.css;var media=obj.media;var sourceMap=obj.sourceMap;if(media){style.setAttribute("media",media)}else{style.removeAttribute("media")}if(sourceMap&&btoa){css+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))))," */")}if(style.styleSheet){style.styleSheet.cssText=css}else{while(style.firstChild){style.removeChild(style.firstChild)}style.appendChild(document.createTextNode(css))}}var singleton=null;var singletonCounter=0;function addStyle(obj,options){var style;var update;var remove;if(options.singleton){var styleIndex=singletonCounter++;style=singleton||(singleton=insertStyleElement(options));update=applyToSingletonTag.bind(null,style,styleIndex,false);remove=applyToSingletonTag.bind(null,style,styleIndex,true)}else{style=insertStyleElement(options);update=applyToTag.bind(null,style,options);remove=function remove(){removeStyleElement(style)}}update(obj);return function updateStyle(newObj){if(newObj){if(newObj.css===obj.css&&newObj.media===obj.media&&newObj.sourceMap===obj.sourceMap){return}update(obj=newObj)}else{remove()}}}module.exports=function(list,options){options=options||{};if(!options.singleton&&typeof options.singleton!=="boolean"){options.singleton=isOldIE()}list=list||[];var lastIdentifiers=modulesToDom(list,options);return function update(newList){newList=newList||[];if(Object.prototype.toString.call(newList)!=="[object Array]"){return}for(var i=0;i<lastIdentifiers.length;i++){var identifier=lastIdentifiers[i];var index=getIndexByIdentifier(identifier);stylesInDom[index].references--}var newLastIdentifiers=modulesToDom(newList,options);for(var _i=0;_i<lastIdentifiers.length;_i++){var _identifier=lastIdentifiers[_i];var _index=getIndexByIdentifier(_identifier);if(stylesInDom[_index].references===0){stylesInDom[_index].updater();stylesInDom.splice(_index,1)}}lastIdentifiers=newLastIdentifiers}}},function(module,exports,__webpack_require__){"use strict";module.exports=function(useSourceMap){var list=[];list.toString=function toString(){return this.map((function(item){var content=cssWithMappingToString(item,useSourceMap);if(item[2]){return"@media ".concat(item[2]," {").concat(content,"}")}return content})).join("")};list.i=function(modules,mediaQuery,dedupe){if(typeof modules==="string"){modules=[[null,modules,""]]}var alreadyImportedModules={};if(dedupe){for(var i=0;i<this.length;i++){var id=this[i][0];if(id!=null){alreadyImportedModules[id]=true}}}for(var _i=0;_i<modules.length;_i++){var item=[].concat(modules[_i]);if(dedupe&&alreadyImportedModules[item[0]]){continue}if(mediaQuery){if(!item[2]){item[2]=mediaQuery}else{item[2]="".concat(mediaQuery," and ").concat(item[2])}}list.push(item)}};return list};function cssWithMappingToString(item,useSourceMap){var content=item[1]||"";var cssMapping=item[3];if(!cssMapping){return content}if(useSourceMap&&typeof btoa==="function"){var sourceMapping=toComment(cssMapping);var sourceURLs=cssMapping.sources.map((function(source){return"/*# sourceURL=".concat(cssMapping.sourceRoot||"").concat(source," */")}));return[content].concat(sourceURLs).concat([sourceMapping]).join("\n")}return[content].join("\n")}function toComment(sourceMap){var base64=btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));var data="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);return"/*# ".concat(data," */")}},function(module,exports){module.exports=__kbnSharedDeps__.MomentTimezone},function(module,exports){module.exports=__kbnSharedDeps__.ReactDom},function(module,exports){module.exports=__kbnSharedDeps__.TsLib},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(0);function useMountedState(){var mountedRef=react_1.useRef(false);var get=react_1.useCallback((function(){return mountedRef.current}),[]);react_1.useEffect((function(){mountedRef.current=true;return function(){mountedRef.current=false}}));return get}exports.default=useMountedState},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(9);var react_1=__webpack_require__(0);var useTimeoutFn_1=tslib_1.__importDefault(__webpack_require__(24));function useDebounce(fn,ms,deps){if(ms===void 0){ms=0}if(deps===void 0){deps=[]}var _a=useTimeoutFn_1.default(fn,ms),isReady=_a[0],cancel=_a[1],reset=_a[2];react_1.useEffect(reset,deps);return[isReady,cancel]}exports.default=useDebounce},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(0);var util_1=__webpack_require__(25);var defaultTarget=util_1.isClient?window:null;var isListenerType1=function(target){return!!target.addEventListener};var isListenerType2=function(target){return!!target.on};var useEvent=function(name,handler,target,options){if(target===void 0){target=defaultTarget}react_1.useEffect((function(){if(!handler){return}if(!target){return}if(isListenerType1(target)){target.addEventListener(name,handler,options)}else if(isListenerType2(target)){target.on(name,handler,options)}return function(){if(isListenerType1(target)){target.removeEventListener(name,handler,options)}else if(isListenerType2(target)){target.off(name,handler,options)}}}),[name,handler,target,JSON.stringify(options)])};exports.default=useEvent},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);var _node_modules_val_loader_dist_cjs_js_key_globalSearchBar_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(14);var _node_modules_val_loader_dist_cjs_js_key_globalSearchBar_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(_node_modules_val_loader_dist_cjs_js_key_globalSearchBar_kbn_ui_shared_deps_public_path_module_creator_js__WEBPACK_IMPORTED_MODULE_0__);__kbnBundles__.define("plugin/globalSearchBar/public",__webpack_require__,27)},function(module,exports,__webpack_require__){__webpack_require__.p=window.__kbnPublicPath__["globalSearchBar"]},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(16);case"v7light":return __webpack_require__(18);case"v8dark":return __webpack_require__(20);case"v8light":return __webpack_require__(22)}},function(module,exports,__webpack_require__){var api=__webpack_require__(5);var content=__webpack_require__(17);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(6);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".kbnSearchOption__tagsList {\n  display: inline-block;\n  line-height: 18px !important; }\n  .kbnSearchOption__tagsList .kbnSearchOption__tagsListItem {\n    display: inline-block;\n    max-width: 80px;\n    margin-right: 8px; }\n\n.euiSelectableListItem-isFocused .kbnSearchOption__tagsList {\n  margin-right: 4px;\n  border-right: 1px solid #343741; }\n\n.kbnSearchBar {\n  width: 400px;\n  max-width: 100%;\n  will-change: width; }\n\n@media only screen and (max-width: 574px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 575px) and (max-width: 767px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 992px) and (max-width: 1199px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@media only screen and (min-width: 1200px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@keyframes kbnAnimateSearchBar {\n  from {\n    width: 400px; }\n  to {\n    width: 600px; } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(5);var content=__webpack_require__(19);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(6);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".kbnSearchOption__tagsList {\n  display: inline-block;\n  line-height: 18px !important; }\n  .kbnSearchOption__tagsList .kbnSearchOption__tagsListItem {\n    display: inline-block;\n    max-width: 80px;\n    margin-right: 8px; }\n\n.euiSelectableListItem-isFocused .kbnSearchOption__tagsList {\n  margin-right: 4px;\n  border-right: 1px solid #D3DAE6; }\n\n.kbnSearchBar {\n  width: 400px;\n  max-width: 100%;\n  will-change: width; }\n\n@media only screen and (max-width: 574px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 575px) and (max-width: 767px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 992px) and (max-width: 1199px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@media only screen and (min-width: 1200px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@keyframes kbnAnimateSearchBar {\n  from {\n    width: 400px; }\n  to {\n    width: 600px; } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(5);var content=__webpack_require__(21);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(6);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".kbnSearchOption__tagsList {\n  display: inline-block;\n  line-height: 16px !important; }\n  .kbnSearchOption__tagsList .kbnSearchOption__tagsListItem {\n    display: inline-block;\n    max-width: 80px;\n    margin-right: 8px; }\n\n.euiSelectableListItem-isFocused .kbnSearchOption__tagsList {\n  margin-right: 4px;\n  border-right: 1px solid #343741; }\n\n.kbnSearchBar {\n  width: 400px;\n  max-width: 100%;\n  will-change: width; }\n\n@media only screen and (max-width: 574px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 575px) and (max-width: 767px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 992px) and (max-width: 1199px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@media only screen and (min-width: 1200px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@keyframes kbnAnimateSearchBar {\n  from {\n    width: 400px; }\n  to {\n    width: 600px; } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(5);var content=__webpack_require__(23);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(6);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".kbnSearchOption__tagsList {\n  display: inline-block;\n  line-height: 16px !important; }\n  .kbnSearchOption__tagsList .kbnSearchOption__tagsListItem {\n    display: inline-block;\n    max-width: 80px;\n    margin-right: 8px; }\n\n.euiSelectableListItem-isFocused .kbnSearchOption__tagsList {\n  margin-right: 4px;\n  border-right: 1px solid #D3DAE6; }\n\n.kbnSearchBar {\n  width: 400px;\n  max-width: 100%;\n  will-change: width; }\n\n@media only screen and (max-width: 574px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 575px) and (max-width: 767px) {\n  .kbnSearchOption__tagsList {\n    display: none; } }\n\n@media only screen and (min-width: 992px) and (max-width: 1199px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@media only screen and (min-width: 1200px) {\n  .kbnSearchBar:focus {\n    animation: kbnAnimateSearchBar 150ms forwards; } }\n\n@keyframes kbnAnimateSearchBar {\n  from {\n    width: 400px; }\n  to {\n    width: 600px; } }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(0);function useTimeoutFn(fn,ms){if(ms===void 0){ms=0}var ready=react_1.useRef(false);var timeout=react_1.useRef();var callback=react_1.useRef(fn);var isReady=react_1.useCallback((function(){return ready.current}),[]);var set=react_1.useCallback((function(){ready.current=false;timeout.current&&clearTimeout(timeout.current);timeout.current=setTimeout((function(){ready.current=true;callback.current()}),ms)}),[ms]);var clear=react_1.useCallback((function(){ready.current=null;timeout.current&&clearTimeout(timeout.current)}),[]);react_1.useEffect((function(){callback.current=fn}),[fn]);react_1.useEffect((function(){set();return clear}),[ms]);return[isReady,clear,set]}exports.default=useTimeoutFn},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isDeepEqual=exports.off=exports.on=exports.isClient=void 0;var tslib_1=__webpack_require__(9);var react_1=tslib_1.__importDefault(__webpack_require__(26));exports.isClient=typeof window==="object";exports.on=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.addEventListener.apply(obj,args)};exports.off=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.removeEventListener.apply(obj,args)};exports.isDeepEqual=react_1.default},function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(key==="_owner"&&a.$$typeof){continue}if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"plugin",(function(){return public_plugin}));var external_kbnSharedDeps_React_=__webpack_require__(0);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(8);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(2);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(1);function wrapArray(subj){return Array.isArray(subj)?subj:[subj]}class UnreachableCaseError extends Error{constructor(val){super(`Unreachable case: ${val}`)}}function createUiCounterMetric({type:type,appName:appName,eventName:eventName,count:count=1}){return{type:type,appName:appName,eventName:eventName,count:count}}function trackUsageAgent(appName){const userAgent=window&&window.navigator&&window.navigator.userAgent||"";return{type:METRIC_TYPE.USER_AGENT,appName:appName,userAgent:userAgent}}var external_kbnSharedDeps_MomentTimezone_=__webpack_require__(7);var external_kbnSharedDeps_MomentTimezone_default=__webpack_require__.n(external_kbnSharedDeps_MomentTimezone_);function createApplicationUsageMetric(appId,viewId){return{type:METRIC_TYPE.APPLICATION_USAGE,appId:appId,viewId:viewId,startTime:external_kbnSharedDeps_MomentTimezone_default()(),numberOfClicks:0}}let METRIC_TYPE;(function(METRIC_TYPE){METRIC_TYPE["COUNT"]="count";METRIC_TYPE["LOADED"]="loaded";METRIC_TYPE["CLICK"]="click";METRIC_TYPE["USER_AGENT"]="user_agent";METRIC_TYPE["APPLICATION_USAGE"]="application_usage"})(METRIC_TYPE||(METRIC_TYPE={}));function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class ReportStorageManager{constructor(storageKey,storage){_defineProperty(this,"storageKey",void 0);_defineProperty(this,"storage",void 0);this.storageKey=storageKey;this.storage=storage}get(){if(!this.storage)return;return this.storage.get(this.storageKey)}store(report){if(!this.storage)return;this.storage.set(this.storageKey,report)}}function application_usage_tracker_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class application_usage_tracker_ApplicationUsageTracker{constructor(reporter){application_usage_tracker_defineProperty(this,"trackedApplicationViews",{});application_usage_tracker_defineProperty(this,"reporter",void 0);application_usage_tracker_defineProperty(this,"currentAppId",void 0);application_usage_tracker_defineProperty(this,"currentApplicationKeys",[]);application_usage_tracker_defineProperty(this,"beforeUnloadListener",void 0);application_usage_tracker_defineProperty(this,"onVisiblityChangeListener",void 0);this.reporter=reporter}createKey(appId,viewId){return{appId:appId,viewId:viewId}}static serializeKey({appId:appId,viewId:viewId}){return`${appId}-${viewId}`}trackApplications(appKeys){for(const{appId:appId,viewId:viewId}of appKeys.filter(Boolean)){const serializedKey=application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:appId,viewId:viewId});if(typeof this.trackedApplicationViews[serializedKey]!=="undefined"){continue}const metric=createApplicationUsageMetric(appId,viewId);this.trackedApplicationViews[serializedKey]=metric}}attachListeners(){if(typeof window==="undefined"||typeof document==="undefined"){return}this.beforeUnloadListener=()=>{this.flushTrackedViews()};this.onVisiblityChangeListener=()=>{if(document.visibilityState==="visible"){this.resumeTrackingAll()}else if(document.visibilityState==="hidden"){this.pauseTrackingAll()}};window.addEventListener("beforeunload",this.beforeUnloadListener);document.addEventListener("visibilitychange",this.onVisiblityChangeListener)}detachListeners(){if(typeof window==="undefined"||typeof document==="undefined"){return}if(this.beforeUnloadListener){window.removeEventListener("beforeunload",this.beforeUnloadListener)}if(this.onVisiblityChangeListener){document.removeEventListener("visibilitychange",this.onVisiblityChangeListener)}}sendMetricsToReporter(metrics){metrics.forEach(metric=>{this.reporter.reportApplicationUsage(metric)})}updateViewClickCounter(viewId){if(!this.currentAppId){return}const appKey=application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:this.currentAppId,viewId:viewId});if(this.trackedApplicationViews[appKey]){this.trackedApplicationViews[appKey].numberOfClicks++}}flushTrackedViews(){const appViewMetrics=Object.values(this.trackedApplicationViews);this.sendMetricsToReporter(appViewMetrics);this.trackedApplicationViews={}}start(){this.attachListeners()}stop(){this.flushTrackedViews();this.detachListeners()}setCurrentAppId(appId){this.flushTrackedViews();this.currentAppId=appId}trackApplicationViewUsage(viewId){if(!this.currentAppId){return}const appKey=this.createKey(this.currentAppId,viewId);this.trackApplications([appKey])}pauseTrackingAll(){this.currentApplicationKeys=Object.values(this.trackedApplicationViews).map(({appId:appId,viewId:viewId})=>this.createKey(appId,viewId));this.flushTrackedViews()}resumeTrackingAll(){this.trackApplications(this.currentApplicationKeys);this.currentApplicationKeys=[];this.reporter.sendReports()}flushTrackedView(viewId){if(!this.currentAppId){return}const appKey=this.createKey(this.currentAppId,viewId);const serializedKey=application_usage_tracker_ApplicationUsageTracker.serializeKey(appKey);const appViewMetric=this.trackedApplicationViews[serializedKey];this.sendMetricsToReporter([appViewMetric]);delete this.trackedApplicationViews[serializedKey]}}function report_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const REPORT_VERSION=3;class report_ReportManager{constructor(report){report_defineProperty(this,"report",void 0);this.report=report||report_ReportManager.createReport()}static createReport(){return{reportVersion:REPORT_VERSION}}clearReport(){this.report=report_ReportManager.createReport()}isReportEmpty(){const{uiCounter:uiCounter,userAgent:userAgent,application_usage:appUsage}=this.report;const noUiCounters=!uiCounter||Object.keys(uiCounter).length===0;const noUserAgents=!userAgent||Object.keys(userAgent).length===0;const noAppUsage=!appUsage||Object.keys(appUsage).length===0;return noUiCounters&&noUserAgents&&noAppUsage}incrementTotal(count,currentTotal){const currentTotalNumber=typeof currentTotal==="number"?currentTotal:0;return count+currentTotalNumber}assignReports(newMetrics){wrapArray(newMetrics).forEach(newMetric=>this.assignReport(this.report,newMetric));return{report:this.report}}static createMetricKey(metric){switch(metric.type){case METRIC_TYPE.USER_AGENT:{const{appName:appName,type:type}=metric;return`${appName}-${type}`}case METRIC_TYPE.CLICK:case METRIC_TYPE.LOADED:case METRIC_TYPE.COUNT:{const{appName:appName,eventName:eventName,type:type}=metric;return`${appName}-${type}-${eventName}`}case METRIC_TYPE.APPLICATION_USAGE:{const{appId:appId,viewId:viewId}=metric;return application_usage_tracker_ApplicationUsageTracker.serializeKey({appId:appId,viewId:viewId})}default:throw new UnreachableCaseError(metric)}}assignReport(report,metric){const key=report_ReportManager.createMetricKey(metric);switch(metric.type){case METRIC_TYPE.USER_AGENT:{const{appName:appName,type:type,userAgent:userAgent}=metric;if(userAgent){report.userAgent={[key]:{key:key,appName:appName,type:type,userAgent:metric.userAgent}}}return}case METRIC_TYPE.CLICK:case METRIC_TYPE.LOADED:case METRIC_TYPE.COUNT:{var _report$uiCounter$key;const{appName:appName,type:type,eventName:eventName,count:count}=metric;report.uiCounter=report.uiCounter||{};const currentTotal=(_report$uiCounter$key=report.uiCounter[key])===null||_report$uiCounter$key===void 0?void 0:_report$uiCounter$key.total;report.uiCounter[key]={key:key,appName:appName,eventName:eventName,type:type,total:this.incrementTotal(count,currentTotal)};return}case METRIC_TYPE.APPLICATION_USAGE:{const{numberOfClicks:numberOfClicks,startTime:startTime,appId:appId,viewId:viewId}=metric;const minutesOnScreen=external_kbnSharedDeps_MomentTimezone_default()().diff(startTime,"minutes",true);report.application_usage=report.application_usage||{};const appExistingData=report.application_usage[key]||{minutesOnScreen:0,numberOfClicks:0,appId:appId,viewId:viewId};report.application_usage[key]={...appExistingData,minutesOnScreen:appExistingData.minutesOnScreen+minutesOnScreen,numberOfClicks:appExistingData.numberOfClicks+numberOfClicks};return}default:throw new UnreachableCaseError(metric)}}}report_defineProperty(report_ReportManager,"REPORT_VERSION",REPORT_VERSION);function reporter_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class reporter_Reporter{constructor(config){reporter_defineProperty(this,"checkInterval",void 0);reporter_defineProperty(this,"interval",void 0);reporter_defineProperty(this,"http",void 0);reporter_defineProperty(this,"reportManager",void 0);reporter_defineProperty(this,"storageManager",void 0);reporter_defineProperty(this,"debug",void 0);reporter_defineProperty(this,"retryCount",0);reporter_defineProperty(this,"maxRetries",3);reporter_defineProperty(this,"start",()=>{if(!this.interval){this.interval=setTimeout(()=>{this.interval=undefined;this.sendReports()},this.checkInterval)}});reporter_defineProperty(this,"reportUiCounter",(appName,type,eventNames,count)=>{const metrics=wrapArray(eventNames).map(eventName=>{this.log(`${type} Metric -> (${appName}:${eventName}):`);const report=createUiCounterMetric({type:type,appName:appName,eventName:eventName,count:count});this.log(report);return report});this.saveToReport(metrics)});reporter_defineProperty(this,"reportUserAgent",appName=>{this.log(`Reporting user-agent.`);const report=trackUsageAgent(appName);this.saveToReport([report])});reporter_defineProperty(this,"sendReports",async()=>{if(!this.reportManager.isReportEmpty()){try{await this.http(this.reportManager.report);this.flushReport()}catch(err){this.log(`Error Sending Metrics Report ${err}`);this.retryCount=this.retryCount+1;const versionMismatch=this.reportManager.report.reportVersion!==report_ReportManager.REPORT_VERSION;if(versionMismatch||this.retryCount>this.maxRetries){this.flushReport()}}}this.start()});const{http:http,storage:storage,debug:debug,checkInterval:checkInterval=9e4,storageKey:storageKey="analytics"}=config;this.http=http;this.checkInterval=checkInterval;this.storageManager=new ReportStorageManager(storageKey,storage);const storedReport=this.storageManager.get();this.reportManager=new report_ReportManager(storedReport);this.debug=!!debug}saveToReport(newMetrics){this.reportManager.assignReports(newMetrics);this.storageManager.store(this.reportManager.report)}flushReport(){this.retryCount=0;this.reportManager.clearReport();this.storageManager.store(this.reportManager.report)}log(message){if(this.debug){console.debug(message)}}reportApplicationUsage(appUsageReport){this.log(`Reporting application usage for ${appUsageReport.appId}, ${appUsageReport.viewId}`);this.saveToReport([appUsageReport])}}var external_kbnSharedDeps_KbnI18n_=__webpack_require__(3);var useDebounce=__webpack_require__(11);var useDebounce_default=__webpack_require__.n(useDebounce);var useEvent=__webpack_require__(12);var useEvent_default=__webpack_require__.n(useEvent);var useMountedState=__webpack_require__(10);var useMountedState_default=__webpack_require__.n(useMountedState);const getFieldValueMap=query=>{const fieldMap=new Map;query.ast.clauses.forEach(clause=>{if(clause.type==="field"){var _fieldMap$get;const{field:field,value:value}=clause;fieldMap.set(field,[...(_fieldMap$get=fieldMap.get(field))!==null&&_fieldMap$get!==void 0?_fieldMap$get:[],...Array.isArray(value)?value:[value]])}});return fieldMap};const getSearchTerm=query=>{var _term;let term;if(query.ast.getTermClauses().length){term=query.ast.getTermClauses().map(clause=>clause.value).join(" ").replace(/\s{2,}/g," ").trim()}return(_term=term)!==null&&_term!==void 0&&_term.length?term:undefined};const applyAliases=(valueMap,aliasesMap)=>{const reverseLookup={};Object.entries(aliasesMap).forEach(([canonical,aliases])=>{aliases.forEach(alias=>{reverseLookup[alias]=canonical})});const resultMap=new Map;valueMap.forEach((values,field)=>{var _reverseLookup$field,_resultMap$get;const targetKey=(_reverseLookup$field=reverseLookup[field])!==null&&_reverseLookup$field!==void 0?_reverseLookup$field:field;resultMap.set(targetKey,[...(_resultMap$get=resultMap.get(targetKey))!==null&&_resultMap$get!==void 0?_resultMap$get:[],...values])});return resultMap};const knownFilters=["tag","type"];const aliasMap={tag:["tags"],type:["types"]};const parseSearchParams=term=>{let query;try{query=external_kbnSharedDeps_ElasticEui_["Query"].parse(term)}catch(e){return{term:term,filters:{unknowns:{}}}}const searchTerm=getSearchTerm(query);const filterValues=applyAliases(getFieldValueMap(query),aliasMap);const unknownFilters=[...filterValues.entries()].filter(([key])=>!knownFilters.includes(key)).reduce((unknowns,[key,value])=>({...unknowns,[key]:value}),{});const tags=filterValues.get("tag");const types=filterValues.get("type");return{term:searchTerm,filters:{tags:tags?valuesToString(tags):undefined,types:types?valuesToString(types):undefined,unknowns:unknownFilters}}};const valuesToString=raw=>raw.map(value=>String(value));var search_syntax_types=__webpack_require__(4);const getSuggestions=({searchTerm:searchTerm,searchableTypes:searchableTypes,tagCache:tagCache})=>{const results=[];const suggestionTerm=searchTerm.trim();const matchingType=findIgnoreCase(searchableTypes,suggestionTerm);if(matchingType){const suggestedSearch=escapeIfWhiteSpaces(matchingType);results.push({key:"__type__suggestion__",label:`type: ${matchingType}`,icon:"filter",description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.suggestions.filterByTypeLabel",{defaultMessage:"Filter by type"}),suggestedSearch:`type:${suggestedSearch}`})}if(tagCache&&searchTerm){const matchingTag=tagCache.getState().find(tag=>equalsIgnoreCase(tag.name,suggestionTerm));if(matchingTag){const suggestedSearch=escapeIfWhiteSpaces(matchingTag.name);results.push({key:"__tag__suggestion__",label:`tag: ${matchingTag.name}`,icon:"tag",description:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.suggestions.filterByTagLabel",{defaultMessage:"Filter by tag name"}),suggestedSearch:`tag:${suggestedSearch}`})}}return results};const findIgnoreCase=(array,target)=>{for(const item of array){if(equalsIgnoreCase(item,target)){return item}}return undefined};const equalsIgnoreCase=(a,b)=>a.toLowerCase()===b.toLowerCase();const escapeIfWhiteSpaces=term=>{if(/\s/g.test(term)){return`"${term}"`}return term};var search_bar=__webpack_require__(15);const isMac=navigator.platform.toLowerCase().indexOf("mac")>=0;const setFieldValue=(field,value)=>{const nativeInputValue=Object.getOwnPropertyDescriptor(HTMLInputElement.prototype,"value");const nativeInputValueSetter=nativeInputValue?nativeInputValue.set:undefined;if(nativeInputValueSetter){nativeInputValueSetter.call(field,value)}field.dispatchEvent(new Event("change"))};const clearField=field=>setFieldValue(field,"");const cleanMeta=str=>(str.charAt(0).toUpperCase()+str.slice(1)).replace(/-/g," ");const blurEvent=new FocusEvent("blur");const sortByScore=(a,b)=>{if(a.score<b.score)return 1;if(a.score>b.score)return-1;return 0};const sortByTitle=(a,b)=>{const titleA=a.title.toUpperCase();const titleB=b.title.toUpperCase();if(titleA<titleB)return-1;if(titleA>titleB)return 1;return 0};const TagListWrapper=({children:children})=>external_kbnSharedDeps_React_default.a.createElement("ul",{className:"kbnSearchOption__tagsList","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.searchBar.optionTagListAriaLabel",{defaultMessage:"Tags"})},children);const buildListItem=({color:color,name:name,id:id})=>external_kbnSharedDeps_React_default.a.createElement("li",{className:"kbnSearchOption__tagsListItem",key:id},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:color},name));const tagList=(tags,searchTagIds)=>{const TAGS_TO_SHOW=3;const showOverflow=tags.length>TAGS_TO_SHOW;if(!showOverflow)return external_kbnSharedDeps_React_default.a.createElement(TagListWrapper,null,tags.map(buildListItem));tags.sort(a=>{if(searchTagIds.find(id=>id===a.id))return-1;return 1});const overflowList=tags.splice(TAGS_TO_SHOW);const overflowMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.searchbar.overflowTagsAriaLabel",{defaultMessage:"{n} more {n, plural, one {tag} other {tags}}: {tags}",values:{n:overflowList.length,tags:overflowList.map(({name:name})=>name)}});return external_kbnSharedDeps_React_default.a.createElement(TagListWrapper,null,tags.map(buildListItem),external_kbnSharedDeps_React_default.a.createElement("li",{className:"kbnSearchOption__tagsListItem","aria-label":overflowMessage},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{title:overflowMessage},"+",overflowList.length)))};const resultToOption=(result,searchTagIds,getTag)=>{const{id:id,title:title,url:url,icon:icon,type:type,meta:meta={}}=result;const{tagIds:tagIds=[],categoryLabel:categoryLabel=""}=meta;const useIcon=type==="application";const option={key:id,label:title,url:url,type:type,icon:{type:useIcon&&icon?icon:"empty"},"data-test-subj":`nav-search-option`};if(type==="application")option.meta=[{text:categoryLabel}];else option.meta=[{text:cleanMeta(type)}];if(getTag&&tagIds.length){option.append=tagList(tagIds.map(getTag),searchTagIds)}return option};const suggestionToOption=suggestion=>{const{key:key,label:label,description:description,icon:icon,suggestedSearch:suggestedSearch}=suggestion;return{key:key,label:label,type:"__suggestion__",icon:{type:icon},suggestion:suggestedSearch,meta:[{text:description}],"data-test-subj":`nav-search-option`}};function SearchBar({globalSearch:globalSearch,taggingApi:taggingApi,navigateToUrl:navigateToUrl,trackUiMetric:trackUiMetric,basePathUrl:basePathUrl,darkMode:darkMode}){const isMounted=useMountedState_default()();const[searchValue,setSearchValue]=Object(external_kbnSharedDeps_React_["useState"])("");const[searchTerm,setSearchTerm]=Object(external_kbnSharedDeps_React_["useState"])("");const[searchRef,setSearchRef]=Object(external_kbnSharedDeps_React_["useState"])(null);const[buttonRef,setButtonRef]=Object(external_kbnSharedDeps_React_["useState"])(null);const searchSubscription=Object(external_kbnSharedDeps_React_["useRef"])(null);const[options,_setOptions]=Object(external_kbnSharedDeps_React_["useState"])([]);const[searchableTypes,setSearchableTypes]=Object(external_kbnSharedDeps_React_["useState"])([]);const UNKNOWN_TAG_ID="__unknown__";Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetch=async()=>{const types=await globalSearch.getSearchableTypes();setSearchableTypes(types)};fetch()},[globalSearch]);const loadSuggestions=Object(external_kbnSharedDeps_React_["useCallback"])(term=>getSuggestions({searchTerm:term,searchableTypes:searchableTypes,tagCache:taggingApi===null||taggingApi===void 0?void 0:taggingApi.cache}),[taggingApi,searchableTypes]);const setOptions=Object(external_kbnSharedDeps_React_["useCallback"])((_options,suggestions,searchTagIds=[])=>{if(!isMounted()){return}_setOptions([...suggestions.map(suggestionToOption),..._options.map(option=>{var _searchTagIds$filter;return resultToOption(option,(_searchTagIds$filter=searchTagIds===null||searchTagIds===void 0?void 0:searchTagIds.filter(id=>id!==UNKNOWN_TAG_ID))!==null&&_searchTagIds$filter!==void 0?_searchTagIds$filter:[],taggingApi===null||taggingApi===void 0?void 0:taggingApi.ui.getTag)})])},[isMounted,_setOptions,taggingApi]);useDebounce_default()(()=>{var _rawParams$term;if(searchSubscription.current){searchSubscription.current.unsubscribe();searchSubscription.current=null}const suggestions=loadSuggestions(searchValue);let aggregatedResults=[];if(searchValue.length!==0){trackUiMetric(METRIC_TYPE.COUNT,"search_request")}const rawParams=parseSearchParams(searchValue);const tagIds=taggingApi&&rawParams.filters.tags?rawParams.filters.tags.map(tagName=>{var _taggingApi$ui$getTag;return(_taggingApi$ui$getTag=taggingApi.ui.getTagIdFromName(tagName))!==null&&_taggingApi$ui$getTag!==void 0?_taggingApi$ui$getTag:UNKNOWN_TAG_ID}):undefined;const searchParams={term:rawParams.term,types:rawParams.filters.types,tags:tagIds};setSearchTerm((_rawParams$term=rawParams.term)!==null&&_rawParams$term!==void 0?_rawParams$term:"");searchSubscription.current=globalSearch.find(searchParams,{}).subscribe({next:({results:results})=>{if(searchValue.length>0){aggregatedResults=[...results,...aggregatedResults].sort(sortByScore);setOptions(aggregatedResults,suggestions,searchParams.tags);return}results=results.filter(({type:type})=>type==="application");aggregatedResults=[...results,...aggregatedResults].sort(sortByTitle);setOptions(aggregatedResults,suggestions,searchParams.tags)},error:()=>{trackUiMetric(METRIC_TYPE.COUNT,"unhandled_error")},complete:()=>{}})},350,[searchValue,loadSuggestions]);const onKeyDown=event=>{if(event.key==="/"&&(isMac?event.metaKey:event.ctrlKey)){event.preventDefault();trackUiMetric(METRIC_TYPE.COUNT,"shortcut_used");if(searchRef){searchRef.focus()}else if(buttonRef){buttonRef.children[0].click()}}};const onChange=selection=>{const selected=selection.find(({checked:checked})=>checked==="on");if(!selected){return}const{url:url,type:type,suggestion:suggestion}=selected;if(type==="__suggestion__"){setFieldValue(searchRef,suggestion);setSearchValue(suggestion);return}try{if(type==="application"){var _selected$keys;const key=(_selected$keys=selected.keys)!==null&&_selected$keys!==void 0?_selected$keys:"unknown";trackUiMetric(METRIC_TYPE.CLICK,["user_navigated_to_application",`user_navigated_to_application_${key.toLowerCase().replaceAll(" ","_")}`])}else{trackUiMetric(METRIC_TYPE.CLICK,["user_navigated_to_saved_object",`user_navigated_to_saved_object_${type}`])}}catch(e){console.log("Error trying to track searchbar metrics",e)}navigateToUrl(url);document.activeElement.blur();if(searchRef){clearField(searchRef);searchRef.dispatchEvent(blurEvent)}};const emptyMessage=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectableMessage"],{style:{minHeight:300},"data-test-subj":"nav-search-no-results"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiImage"],{alt:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.searchBar.noResultsImageAlt",{defaultMessage:"Illustration of black hole"}),size:"fullWidth",url:`${basePathUrl}illustration_product_no_search_results_${darkMode?"dark":"light"}.svg`}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.noResultsHeading",defaultMessage:"No results found"}))),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.noResults",defaultMessage:"Try searching for applications, dashboards, visualizations, and more."})));useEvent_default()("keydown",onKeyDown);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectableTemplateSitewide"],{isPreFiltered:true,onChange:onChange,options:options,popoverButtonBreakpoints:["xs","s"],singleSelection:true,renderOption:option=>Object(external_kbnSharedDeps_ElasticEui_["euiSelectableTemplateSitewideRenderOptions"])(option,searchTerm),popoverButton:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHeaderSectionItemButton"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.searchBar.mobileSearchButtonAriaLabel",{defaultMessage:"Site-wide search"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"search",size:"m"})),searchProps:{onKeyUpCapture:e=>setSearchValue(e.currentTarget.value),"data-test-subj":"nav-search-input",inputRef:setSearchRef,compressed:true,className:"kbnSearchBar","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.searchBar.placeholder",{defaultMessage:"Search Elastic"}),placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.globalSearchBar.searchBar.placeholder",{defaultMessage:"Search Elastic"}),onFocus:()=>{trackUiMetric(METRIC_TYPE.COUNT,"search_focus")}},popoverProps:{"data-test-subj":"nav-search-popover",panelClassName:"navSearch__panel",repositionOnScroll:true,buttonRef:setButtonRef},emptyMessage:emptyMessage,noMatchesMessage:emptyMessage,popoverFooter:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"spaceBetween",gutterSize:"s",responsive:false,wrap:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.helpText.helpTextPrefix",defaultMessage:"Filter by"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"type:")," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.helpText.helpTextConjunction",defaultMessage:"or"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"tag:")))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.shortcutDescription.shortcutDetail",defaultMessage:"{shortcutDescription} {commandDescription}",values:{shortcutDescription:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.shortcutDescription.shortcutInstructionDescription",defaultMessage:"Shortcut"}),commandDescription:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,isMac?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.shortcutDescription.macCommandDescription",defaultMessage:"Command + /"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.globalSearchBar.searchBar.shortcutDescription.windowsCommandDescription",defaultMessage:"Control + /"}))}})))))})}class plugin_GlobalSearchBarPlugin{async setup(){return{}}start(core,{globalSearch:globalSearch,savedObjectsTagging:savedObjectsTagging,usageCollection:usageCollection}){const trackUiMetric=usageCollection?usageCollection.reportUiCounter.bind(usageCollection,"global_search_bar"):(metricType,eventName)=>{};core.chrome.navControls.registerCenter({order:1e3,mount:container=>this.mount({container:container,globalSearch:globalSearch,savedObjectsTagging:savedObjectsTagging,navigateToUrl:core.application.navigateToUrl,basePathUrl:core.http.basePath.prepend("/plugins/globalSearchBar/assets/"),darkMode:core.uiSettings.get("theme:darkMode"),trackUiMetric:trackUiMetric})});return{}}mount({container:container,globalSearch:globalSearch,savedObjectsTagging:savedObjectsTagging,navigateToUrl:navigateToUrl,basePathUrl:basePathUrl,darkMode:darkMode,trackUiMetric:trackUiMetric}){external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["I18nProvider"],null,external_kbnSharedDeps_React_default.a.createElement(SearchBar,{globalSearch:globalSearch,navigateToUrl:navigateToUrl,taggingApi:savedObjectsTagging,basePathUrl:basePathUrl,darkMode:darkMode,trackUiMetric:trackUiMetric})),container);return()=>external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(container)}}const public_plugin=()=>new plugin_GlobalSearchBarPlugin}]);