/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["fleet_bundle_jsonpfunction"]=window["fleet_bundle_jsonpfunction"]||[]).push([[2],Array(108).concat([function(module,exports,__webpack_require__){"use strict";module.exports=whitespace;var fromCode=String.fromCharCode;var re=/\s/;function whitespace(character){return re.test(typeof character==="number"?fromCode(character):character.charAt(0))}},,function(module,exports){module.exports=extend;var hasOwnProperty=Object.prototype.hasOwnProperty;function extend(){var target={};for(var i=0;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target}},,function(module,exports){exports=module.exports=trim;function trim(str){if(str.trim)return str.trim();return exports.right(exports.left(str))}exports.left=function(str){if(str.trimLeft)return str.trimLeft();return str.replace(/^\s\s*/,"")};exports.right=function(str){if(str.trimRight)return str.trimRight();var whitespace_pattern=/\s/,i=str.length;while(whitespace_pattern.test(str.charAt(--i)));return str.slice(0,i+1)}},,function(module,exports,__webpack_require__){"use strict";module.exports=decimal;function decimal(character){var code=typeof character==="string"?character.charCodeAt(0):character;return code>=48&&code<=57}},function(module,exports,__webpack_require__){"use strict";module.exports=visit;var visitParents=__webpack_require__(210);var CONTINUE=visitParents.CONTINUE;var SKIP=visitParents.SKIP;var EXIT=visitParents.EXIT;visit.CONTINUE=CONTINUE;visit.SKIP=SKIP;visit.EXIT=EXIT;function visit(tree,test,visitor,reverse){if(typeof test==="function"&&typeof visitor!=="function"){reverse=visitor;visitor=test;test=null}visitParents(tree,test,overload,reverse);function overload(node,parents){var parent=parents[parents.length-1];var index=parent?parent.children.indexOf(node):null;return visitor(node,index,parent)}}},function(module,exports,__webpack_require__){"use strict";var isOldIE=function isOldIE(){var memo;return function memorize(){if(typeof memo==="undefined"){memo=Boolean(window&&document&&document.all&&!window.atob)}return memo}}();var getTarget=function getTarget(){var memo={};return function memorize(target){if(typeof memo[target]==="undefined"){var styleTarget=document.querySelector(target);if(window.HTMLIFrameElement&&styleTarget instanceof window.HTMLIFrameElement){try{styleTarget=styleTarget.contentDocument.head}catch(e){styleTarget=null}}memo[target]=styleTarget}return memo[target]}}();var stylesInDom=[];function getIndexByIdentifier(identifier){var result=-1;for(var i=0;i<stylesInDom.length;i++){if(stylesInDom[i].identifier===identifier){result=i;break}}return result}function modulesToDom(list,options){var idCountMap={};var identifiers=[];for(var i=0;i<list.length;i++){var item=list[i];var id=options.base?item[0]+options.base:item[0];var count=idCountMap[id]||0;var identifier="".concat(id," ").concat(count);idCountMap[id]=count+1;var index=getIndexByIdentifier(identifier);var obj={css:item[1],media:item[2],sourceMap:item[3]};if(index!==-1){stylesInDom[index].references++;stylesInDom[index].updater(obj)}else{stylesInDom.push({identifier:identifier,updater:addStyle(obj,options),references:1})}identifiers.push(identifier)}return identifiers}function insertStyleElement(options){var style=document.createElement("style");var attributes=options.attributes||{};if(typeof attributes.nonce==="undefined"){var nonce=true?__webpack_require__.nc:undefined;if(nonce){attributes.nonce=nonce}}Object.keys(attributes).forEach((function(key){style.setAttribute(key,attributes[key])}));if(typeof options.insert==="function"){options.insert(style)}else{var target=getTarget(options.insert||"head");if(!target){throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.")}target.appendChild(style)}return style}function removeStyleElement(style){if(style.parentNode===null){return false}style.parentNode.removeChild(style)}var replaceText=function replaceText(){var textStore=[];return function replace(index,replacement){textStore[index]=replacement;return textStore.filter(Boolean).join("\n")}}();function applyToSingletonTag(style,index,remove,obj){var css=remove?"":obj.media?"@media ".concat(obj.media," {").concat(obj.css,"}"):obj.css;if(style.styleSheet){style.styleSheet.cssText=replaceText(index,css)}else{var cssNode=document.createTextNode(css);var childNodes=style.childNodes;if(childNodes[index]){style.removeChild(childNodes[index])}if(childNodes.length){style.insertBefore(cssNode,childNodes[index])}else{style.appendChild(cssNode)}}}function applyToTag(style,options,obj){var css=obj.css;var media=obj.media;var sourceMap=obj.sourceMap;if(media){style.setAttribute("media",media)}else{style.removeAttribute("media")}if(sourceMap&&btoa){css+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))))," */")}if(style.styleSheet){style.styleSheet.cssText=css}else{while(style.firstChild){style.removeChild(style.firstChild)}style.appendChild(document.createTextNode(css))}}var singleton=null;var singletonCounter=0;function addStyle(obj,options){var style;var update;var remove;if(options.singleton){var styleIndex=singletonCounter++;style=singleton||(singleton=insertStyleElement(options));update=applyToSingletonTag.bind(null,style,styleIndex,false);remove=applyToSingletonTag.bind(null,style,styleIndex,true)}else{style=insertStyleElement(options);update=applyToTag.bind(null,style,options);remove=function remove(){removeStyleElement(style)}}update(obj);return function updateStyle(newObj){if(newObj){if(newObj.css===obj.css&&newObj.media===obj.media&&newObj.sourceMap===obj.sourceMap){return}update(obj=newObj)}else{remove()}}}module.exports=function(list,options){options=options||{};if(!options.singleton&&typeof options.singleton!=="boolean"){options.singleton=isOldIE()}list=list||[];var lastIdentifiers=modulesToDom(list,options);return function update(newList){newList=newList||[];if(Object.prototype.toString.call(newList)!=="[object Array]"){return}for(var i=0;i<lastIdentifiers.length;i++){var identifier=lastIdentifiers[i];var index=getIndexByIdentifier(identifier);stylesInDom[index].references--}var newLastIdentifiers=modulesToDom(newList,options);for(var _i=0;_i<lastIdentifiers.length;_i++){var _identifier=lastIdentifiers[_i];var _index=getIndexByIdentifier(_identifier);if(stylesInDom[_index].references===0){stylesInDom[_index].updater();stylesInDom.splice(_index,1)}}lastIdentifiers=newLastIdentifiers}}},function(module,exports,__webpack_require__){"use strict";module.exports=function(useSourceMap){var list=[];list.toString=function toString(){return this.map((function(item){var content=cssWithMappingToString(item,useSourceMap);if(item[2]){return"@media ".concat(item[2]," {").concat(content,"}")}return content})).join("")};list.i=function(modules,mediaQuery,dedupe){if(typeof modules==="string"){modules=[[null,modules,""]]}var alreadyImportedModules={};if(dedupe){for(var i=0;i<this.length;i++){var id=this[i][0];if(id!=null){alreadyImportedModules[id]=true}}}for(var _i=0;_i<modules.length;_i++){var item=[].concat(modules[_i]);if(dedupe&&alreadyImportedModules[item[0]]){continue}if(mediaQuery){if(!item[2]){item[2]=mediaQuery}else{item[2]="".concat(mediaQuery," and ").concat(item[2])}}list.push(item)}};return list};function cssWithMappingToString(item,useSourceMap){var content=item[1]||"";var cssMapping=item[3];if(!cssMapping){return content}if(useSourceMap&&typeof btoa==="function"){var sourceMapping=toComment(cssMapping);var sourceURLs=cssMapping.sources.map((function(source){return"/*# sourceURL=".concat(cssMapping.sourceRoot||"").concat(source," */")}));return[content].concat(sourceURLs).concat([sourceMapping]).join("\n")}return[content].join("\n")}function toComment(sourceMap){var base64=btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));var data="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);return"/*# ".concat(data," */")}},,,,function(module,exports,__webpack_require__){"use strict";function _toConsumableArray(arr){return _arrayWithoutHoles(arr)||_iterableToArray(arr)||_nonIterableSpread()}function _nonIterableSpread(){throw new TypeError("Invalid attempt to spread non-iterable instance")}function _iterableToArray(iter){if(Symbol.iterator in Object(iter)||Object.prototype.toString.call(iter)==="[object Arguments]")return Array.from(iter)}function _arrayWithoutHoles(arr){if(Array.isArray(arr)){for(var i=0,arr2=new Array(arr.length);i<arr.length;i++){arr2[i]=arr[i]}return arr2}}var xtend=__webpack_require__(110);var unified=__webpack_require__(178);var parse=__webpack_require__(191);var PropTypes=__webpack_require__(247);var addListMetadata=__webpack_require__(250);var naiveHtml=__webpack_require__(252);var disallowNode=__webpack_require__(253);var astToReact=__webpack_require__(254);var wrapTableRows=__webpack_require__(257);var getDefinitions=__webpack_require__(258);var uriTransformer=__webpack_require__(259);var defaultRenderers=__webpack_require__(260);var symbols=__webpack_require__(261);var allTypes=Object.keys(defaultRenderers);var ReactMarkdown=function ReactMarkdown(props){var src=props.source||props.children||"";var parserOptions=props.parserOptions;if(props.allowedTypes&&props.disallowedTypes){throw new Error("Only one of `allowedTypes` and `disallowedTypes` should be defined")}var renderers=xtend(defaultRenderers,props.renderers);var plugins=[[parse,parserOptions]].concat(props.plugins||[]);var parser=plugins.reduce(applyParserPlugin,unified());var rawAst=parser.parse(src);var renderProps=xtend(props,{renderers:renderers,definitions:getDefinitions(rawAst)});var astPlugins=determineAstPlugins(props);var transformedAst=parser.runSync(rawAst);var ast=astPlugins.reduce((function(node,plugin){return plugin(node,renderProps)}),transformedAst);return astToReact(ast,renderProps)};function applyParserPlugin(parser,plugin){return Array.isArray(plugin)?parser.use.apply(parser,_toConsumableArray(plugin)):parser.use(plugin)}function determineAstPlugins(props){var plugins=[wrapTableRows,addListMetadata()];var disallowedTypes=props.disallowedTypes;if(props.allowedTypes){disallowedTypes=allTypes.filter((function(type){return type!=="root"&&props.allowedTypes.indexOf(type)===-1}))}var removalMethod=props.unwrapDisallowed?"unwrap":"remove";if(disallowedTypes&&disallowedTypes.length>0){plugins.push(disallowNode.ofType(disallowedTypes,removalMethod))}if(props.allowNode){plugins.push(disallowNode.ifNotMatch(props.allowNode,removalMethod))}var renderHtml=!props.escapeHtml&&!props.skipHtml;var hasHtmlParser=(props.astPlugins||[]).some((function(item){var plugin=Array.isArray(item)?item[0]:item;return plugin.identity===symbols.HtmlParser}));if(renderHtml&&!hasHtmlParser){plugins.push(naiveHtml)}return props.astPlugins?plugins.concat(props.astPlugins):plugins}ReactMarkdown.defaultProps={renderers:{},escapeHtml:true,skipHtml:false,sourcePos:false,rawSourcePos:false,transformLinkUri:uriTransformer,astPlugins:[],plugins:[],parserOptions:{}};ReactMarkdown.propTypes={className:PropTypes.string,source:PropTypes.string,children:PropTypes.string,sourcePos:PropTypes.bool,rawSourcePos:PropTypes.bool,escapeHtml:PropTypes.bool,skipHtml:PropTypes.bool,allowNode:PropTypes.func,allowedTypes:PropTypes.arrayOf(PropTypes.oneOf(allTypes)),disallowedTypes:PropTypes.arrayOf(PropTypes.oneOf(allTypes)),transformLinkUri:PropTypes.oneOfType([PropTypes.func,PropTypes.bool]),linkTarget:PropTypes.oneOfType([PropTypes.func,PropTypes.string]),transformImageUri:PropTypes.func,astPlugins:PropTypes.arrayOf(PropTypes.func),unwrapDisallowed:PropTypes.bool,renderers:PropTypes.object,plugins:PropTypes.array,parserOptions:PropTypes.object};ReactMarkdown.types=allTypes;ReactMarkdown.renderers=defaultRenderers;ReactMarkdown.uriTransformer=uriTransformer;module.exports=ReactMarkdown},function(module,exports,__webpack_require__){"use strict";var legacy=__webpack_require__(199);var invalid=__webpack_require__(200);var decimal=__webpack_require__(114);var hexadecimal=__webpack_require__(201);var alphanumerical=__webpack_require__(202);var decodeEntity=__webpack_require__(203);module.exports=parseEntities;var own={}.hasOwnProperty;var fromCharCode=String.fromCharCode;var noop=Function.prototype;var defaults={warning:null,reference:null,text:null,warningContext:null,referenceContext:null,textContext:null,position:{},additional:null,attribute:false,nonTerminated:true};var NAMED="named";var HEXADECIMAL="hexadecimal";var DECIMAL="decimal";var BASE={};BASE[HEXADECIMAL]=16;BASE[DECIMAL]=10;var TESTS={};TESTS[NAMED]=alphanumerical;TESTS[DECIMAL]=decimal;TESTS[HEXADECIMAL]=hexadecimal;var NAMED_NOT_TERMINATED=1;var NUMERIC_NOT_TERMINATED=2;var NAMED_EMPTY=3;var NUMERIC_EMPTY=4;var NAMED_UNKNOWN=5;var NUMERIC_DISALLOWED=6;var NUMERIC_PROHIBITED=7;var MESSAGES={};MESSAGES[NAMED_NOT_TERMINATED]="Named character references must be terminated by a semicolon";MESSAGES[NUMERIC_NOT_TERMINATED]="Numeric character references must be terminated by a semicolon";MESSAGES[NAMED_EMPTY]="Named character references cannot be empty";MESSAGES[NUMERIC_EMPTY]="Numeric character references cannot be empty";MESSAGES[NAMED_UNKNOWN]="Named character references must be known";MESSAGES[NUMERIC_DISALLOWED]="Numeric character references cannot be disallowed";MESSAGES[NUMERIC_PROHIBITED]="Numeric character references cannot be outside the permissible Unicode range";function parseEntities(value,options){var settings={};var option;var key;if(!options){options={}}for(key in defaults){option=options[key];settings[key]=option===null||option===undefined?defaults[key]:option}if(settings.position.indent||settings.position.start){settings.indent=settings.position.indent||[];settings.position=settings.position.start}return parse(value,settings)}function parse(value,settings){var additional=settings.additional;var nonTerminated=settings.nonTerminated;var handleText=settings.text;var handleReference=settings.reference;var handleWarning=settings.warning;var textContext=settings.textContext;var referenceContext=settings.referenceContext;var warningContext=settings.warningContext;var pos=settings.position;var indent=settings.indent||[];var length=value.length;var index=0;var lines=-1;var column=pos.column||1;var line=pos.line||1;var queue="";var result=[];var entityCharacters;var namedEntity;var terminated;var characters;var character;var reference;var following;var warning;var reason;var output;var entity;var begin;var start;var type;var test;var prev;var next;var diff;var end;prev=now();warning=handleWarning?parseError:noop;index--;length++;while(++index<length){if(character==="\n"){column=indent[lines]||1}character=at(index);if(character!=="&"){if(character==="\n"){line++;lines++;column=0}if(character){queue+=character;column++}else{flush()}}else{following=at(index+1);if(following==="\t"||following==="\n"||following==="\f"||following===" "||following==="<"||following==="&"||following===""||additional&&following===additional){queue+=character;column++;continue}start=index+1;begin=start;end=start;if(following!=="#"){type=NAMED}else{end=++begin;following=at(end);if(following==="x"||following==="X"){type=HEXADECIMAL;end=++begin}else{type=DECIMAL}}entityCharacters="";entity="";characters="";test=TESTS[type];end--;while(++end<length){following=at(end);if(!test(following)){break}characters+=following;if(type===NAMED&&own.call(legacy,characters)){entityCharacters=characters;entity=legacy[characters]}}terminated=at(end)===";";if(terminated){end++;namedEntity=type===NAMED?decodeEntity(characters):false;if(namedEntity){entityCharacters=characters;entity=namedEntity}}diff=1+end-start;if(!terminated&&!nonTerminated){}else if(!characters){if(type!==NAMED){warning(NUMERIC_EMPTY,diff)}}else if(type===NAMED){if(terminated&&!entity){warning(NAMED_UNKNOWN,1)}else{if(entityCharacters!==characters){end=begin+entityCharacters.length;diff=1+end-begin;terminated=false}if(!terminated){reason=entityCharacters?NAMED_NOT_TERMINATED:NAMED_EMPTY;if(!settings.attribute){warning(reason,diff)}else{following=at(end);if(following==="="){warning(reason,diff);entity=null}else if(alphanumerical(following)){entity=null}else{warning(reason,diff)}}}}reference=entity}else{if(!terminated){warning(NUMERIC_NOT_TERMINATED,diff)}reference=parseInt(characters,BASE[type]);if(prohibited(reference)){warning(NUMERIC_PROHIBITED,diff);reference="�"}else if(reference in invalid){warning(NUMERIC_DISALLOWED,diff);reference=invalid[reference]}else{output="";if(disallowed(reference)){warning(NUMERIC_DISALLOWED,diff)}if(reference>65535){reference-=65536;output+=fromCharCode(reference>>>(10&1023)|55296);reference=56320|reference&1023}reference=output+fromCharCode(reference)}}if(!reference){characters=value.slice(start-1,end);queue+=characters;column+=characters.length;index=end-1}else{flush();prev=now();index=end-1;column+=end-start+1;result.push(reference);next=now();next.offset++;if(handleReference){handleReference.call(referenceContext,reference,{start:prev,end:next},value.slice(start-1,end))}prev=next}}}return result.join("");function now(){return{line:line,column:column,offset:index+(pos.offset||0)}}function parseError(code,offset){var position=now();position.column+=offset;position.offset+=offset;handleWarning.call(warningContext,MESSAGES[code],position,code)}function at(position){return value.charAt(position)}function flush(){if(queue){result.push(queue);if(handleText){handleText.call(textContext,queue,{start:prev,end:now()})}queue=""}}}function prohibited(code){return code>=55296&&code<=57343||code>1114111}function disallowed(code){return code>=1&&code<=8||code===11||code>=13&&code<=31||code>=127&&code<=159||code>=64976&&code<=65007||(code&65535)===65535||(code&65535)===65534}},function(module,exports,__webpack_require__){"use strict";
/*!
 * repeat-string <https://github.com/jonschlinkert/repeat-string>
 *
 * Copyright (c) 2014-2015, Jon Schlinkert.
 * Licensed under the MIT License.
 */var res="";var cache;module.exports=repeat;function repeat(str,num){if(typeof str!=="string"){throw new TypeError("expected a string")}if(num===1)return str;if(num===2)return str+str;var max=str.length*num;if(cache!==str||typeof cache==="undefined"){cache=str;res=""}else if(res.length>=max){return res.substr(0,max)}while(max>res.length&&num>1){if(num&1){res+=str}num>>=1;str+=str}res+=str;res=res.substr(0,max);return res}},function(module,exports,__webpack_require__){"use strict";module.exports=trimTrailingLines;var line="\n";function trimTrailingLines(value){var val=String(value);var index=val.length;while(val.charAt(--index)===line){}return val.slice(0,index+1)}},function(module,exports,__webpack_require__){"use strict";module.exports=interrupt;function interrupt(interruptors,tokenizers,ctx,params){var bools=["pedantic","commonmark"];var count=bools.length;var length=interruptors.length;var index=-1;var interruptor;var config;var fn;var offset;var bool;var ignore;while(++index<length){interruptor=interruptors[index];config=interruptor[1]||{};fn=interruptor[0];offset=-1;ignore=false;while(++offset<count){bool=bools[offset];if(config[bool]!==undefined&&config[bool]!==ctx.options[bool]){ignore=true;break}}if(ignore){continue}if(tokenizers[fn].apply(ctx,params)){return true}}return false}},function(module,exports,__webpack_require__){"use strict";var collapseWhiteSpace=__webpack_require__(223);module.exports=normalize;function normalize(value){return collapseWhiteSpace(value).toLowerCase()}},,,,,,,,,function(module,exports,__webpack_require__){(function(process){function normalizeArray(parts,allowAboveRoot){var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}if(allowAboveRoot){for(;up--;up){parts.unshift("..")}}return parts}exports.resolve=function(){var resolvedPath="",resolvedAbsolute=false;for(var i=arguments.length-1;i>=-1&&!resolvedAbsolute;i--){var path=i>=0?arguments[i]:process.cwd();if(typeof path!=="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){continue}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=path.charAt(0)==="/"}resolvedPath=normalizeArray(filter(resolvedPath.split("/"),(function(p){return!!p})),!resolvedAbsolute).join("/");return(resolvedAbsolute?"/":"")+resolvedPath||"."};exports.normalize=function(path){var isAbsolute=exports.isAbsolute(path),trailingSlash=substr(path,-1)==="/";path=normalizeArray(filter(path.split("/"),(function(p){return!!p})),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path};exports.isAbsolute=function(path){return path.charAt(0)==="/"};exports.join=function(){var paths=Array.prototype.slice.call(arguments,0);return exports.normalize(filter(paths,(function(p,index){if(typeof p!=="string"){throw new TypeError("Arguments to path.join must be strings")}return p})).join("/"))};exports.relative=function(from,to){from=exports.resolve(from).substr(1);to=exports.resolve(to).substr(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")};exports.sep="/";exports.delimiter=":";exports.dirname=function(path){if(typeof path!=="string")path=path+"";if(path.length===0)return".";var code=path.charCodeAt(0);var hasRoot=code===47;var end=-1;var matchedSlash=true;for(var i=path.length-1;i>=1;--i){code=path.charCodeAt(i);if(code===47){if(!matchedSlash){end=i;break}}else{matchedSlash=false}}if(end===-1)return hasRoot?"/":".";if(hasRoot&&end===1){return"/"}return path.slice(0,end)};function basename(path){if(typeof path!=="string")path=path+"";var start=0;var end=-1;var matchedSlash=true;var i;for(i=path.length-1;i>=0;--i){if(path.charCodeAt(i)===47){if(!matchedSlash){start=i+1;break}}else if(end===-1){matchedSlash=false;end=i+1}}if(end===-1)return"";return path.slice(start,end)}exports.basename=function(path,ext){var f=basename(path);if(ext&&f.substr(-1*ext.length)===ext){f=f.substr(0,f.length-ext.length)}return f};exports.extname=function(path){if(typeof path!=="string")path=path+"";var startDot=-1;var startPart=0;var end=-1;var matchedSlash=true;var preDotState=0;for(var i=path.length-1;i>=0;--i){var code=path.charCodeAt(i);if(code===47){if(!matchedSlash){startPart=i+1;break}continue}if(end===-1){matchedSlash=false;end=i+1}if(code===46){if(startDot===-1)startDot=i;else if(preDotState!==1)preDotState=1}else if(startDot!==-1){preDotState=-1}}if(startDot===-1||end===-1||preDotState===0||preDotState===1&&startDot===end-1&&startDot===startPart+1){return""}return path.slice(startDot,end)};function filter(xs,f){if(xs.filter)return xs.filter(f);var res=[];for(var i=0;i<xs.length;i++){if(f(xs[i],i,xs))res.push(xs[i])}return res}var substr="ab".substr(-1)==="b"?function(str,start,len){return str.substr(start,len)}:function(str,start,len){if(start<0)start=str.length+start;return str.substr(start,len)}}).call(this,__webpack_require__(62))},function(module,exports,__webpack_require__){"use strict";module.exports=alphabetical;function alphabetical(character){var code=typeof character==="string"?character.charCodeAt(0):character;return code>=97&&code<=122||code>=65&&code<=90}},function(module,exports,__webpack_require__){"use strict";module.exports={position:true,gfm:true,commonmark:false,footnotes:false,pedantic:false,blocks:__webpack_require__(207)}},function(module,exports,__webpack_require__){"use strict";module.exports=indentation;var characters={" ":1,"\t":4};function indentation(value){var index=0;var indent=0;var character=value.charAt(index);var stops={};var size;while(character in characters){size=characters[character];indent+=size;if(size>1){indent=Math.floor(indent/size)*size}stops[indent]=index;character=value.charAt(++index)}return{indent:indent,stops:stops}}},function(module,exports,__webpack_require__){"use strict";var attributeName="[a-zA-Z_:][a-zA-Z0-9:._-]*";var unquoted="[^\"'=<>`\\u0000-\\u0020]+";var singleQuoted="'[^']*'";var doubleQuoted='"[^"]*"';var attributeValue="(?:"+unquoted+"|"+singleQuoted+"|"+doubleQuoted+")";var attribute="(?:\\s+"+attributeName+"(?:\\s*=\\s*"+attributeValue+")?)";var openTag="<[A-Za-z][A-Za-z0-9\\-]*"+attribute+"*\\s*\\/?>";var closeTag="<\\/[A-Za-z][A-Za-z0-9\\-]*\\s*>";var comment="\x3c!----\x3e|\x3c!--(?:-?[^>-])(?:-?[^-])*--\x3e";var processing="<[?].*?[?]>";var declaration="<![A-Za-z]+\\s+[^>]*>";var cdata="<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";exports.openCloseTag=new RegExp("^(?:"+openTag+"|"+closeTag+")");exports.tag=new RegExp("^(?:"+openTag+"|"+closeTag+"|"+comment+"|"+processing+"|"+declaration+"|"+cdata+")")},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){return value.indexOf("<",fromIndex)}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){var link=value.indexOf("[",fromIndex);var image=value.indexOf("![",fromIndex);if(image===-1){return link}return link<image?link:image}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var react_1=__webpack_require__(2);var useIsomorphicLayoutEffect=typeof window!=="undefined"?react_1.useLayoutEffect:react_1.useEffect;exports.default=useIsomorphicLayoutEffect},,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,exports,__webpack_require__){"use strict";var extend=__webpack_require__(179);var bail=__webpack_require__(180);var vfile=__webpack_require__(181);var trough=__webpack_require__(187);var string=__webpack_require__(188);var func=__webpack_require__(189);var plain=__webpack_require__(190);module.exports=unified().freeze();var slice=[].slice;var own={}.hasOwnProperty;var pipeline=trough().use(pipelineParse).use(pipelineRun).use(pipelineStringify);function pipelineParse(p,ctx){ctx.tree=p.parse(ctx.file)}function pipelineRun(p,ctx,next){p.run(ctx.tree,ctx.file,done);function done(err,tree,file){if(err){next(err)}else{ctx.tree=tree;ctx.file=file;next()}}}function pipelineStringify(p,ctx){ctx.file.contents=p.stringify(ctx.tree,ctx.file)}function unified(){var attachers=[];var transformers=trough();var namespace={};var frozen=false;var freezeIndex=-1;processor.data=data;processor.freeze=freeze;processor.attachers=attachers;processor.use=use;processor.parse=parse;processor.stringify=stringify;processor.run=run;processor.runSync=runSync;processor.process=process;processor.processSync=processSync;return processor;function processor(){var destination=unified();var length=attachers.length;var index=-1;while(++index<length){destination.use.apply(null,attachers[index])}destination.data(extend(true,{},namespace));return destination}function freeze(){var values;var plugin;var options;var transformer;if(frozen){return processor}while(++freezeIndex<attachers.length){values=attachers[freezeIndex];plugin=values[0];options=values[1];transformer=null;if(options===false){continue}if(options===true){values[1]=undefined}transformer=plugin.apply(processor,values.slice(1));if(func(transformer)){transformers.use(transformer)}}frozen=true;freezeIndex=Infinity;return processor}function data(key,value){if(string(key)){if(arguments.length===2){assertUnfrozen("data",frozen);namespace[key]=value;return processor}return own.call(namespace,key)&&namespace[key]||null}if(key){assertUnfrozen("data",frozen);namespace=key;return processor}return namespace}function use(value){var settings;assertUnfrozen("use",frozen);if(value===null||value===undefined){}else if(func(value)){addPlugin.apply(null,arguments)}else if(typeof value==="object"){if("length"in value){addList(value)}else{addPreset(value)}}else{throw new Error("Expected usable value, not `"+value+"`")}if(settings){namespace.settings=extend(namespace.settings||{},settings)}return processor;function addPreset(result){addList(result.plugins);if(result.settings){settings=extend(settings||{},result.settings)}}function add(value){if(func(value)){addPlugin(value)}else if(typeof value==="object"){if("length"in value){addPlugin.apply(null,value)}else{addPreset(value)}}else{throw new Error("Expected usable value, not `"+value+"`")}}function addList(plugins){var length;var index;if(plugins===null||plugins===undefined){}else if(typeof plugins==="object"&&"length"in plugins){length=plugins.length;index=-1;while(++index<length){add(plugins[index])}}else{throw new Error("Expected a list of plugins, not `"+plugins+"`")}}function addPlugin(plugin,value){var entry=find(plugin);if(entry){if(plain(entry[1])&&plain(value)){value=extend(entry[1],value)}entry[1]=value}else{attachers.push(slice.call(arguments))}}}function find(plugin){var length=attachers.length;var index=-1;var entry;while(++index<length){entry=attachers[index];if(entry[0]===plugin){return entry}}}function parse(doc){var file=vfile(doc);var Parser;freeze();Parser=processor.Parser;assertParser("parse",Parser);if(newable(Parser)){return new Parser(String(file),file).parse()}return Parser(String(file),file)}function run(node,file,cb){assertNode(node);freeze();if(!cb&&func(file)){cb=file;file=null}if(!cb){return new Promise(executor)}executor(null,cb);function executor(resolve,reject){transformers.run(node,vfile(file),done);function done(err,tree,file){tree=tree||node;if(err){reject(err)}else if(resolve){resolve(tree)}else{cb(null,tree,file)}}}}function runSync(node,file){var complete=false;var result;run(node,file,done);assertDone("runSync","run",complete);return result;function done(err,tree){complete=true;bail(err);result=tree}}function stringify(node,doc){var file=vfile(doc);var Compiler;freeze();Compiler=processor.Compiler;assertCompiler("stringify",Compiler);assertNode(node);if(newable(Compiler)){return new Compiler(node,file).compile()}return Compiler(node,file)}function process(doc,cb){freeze();assertParser("process",processor.Parser);assertCompiler("process",processor.Compiler);if(!cb){return new Promise(executor)}executor(null,cb);function executor(resolve,reject){var file=vfile(doc);pipeline.run(processor,{file:file},done);function done(err){if(err){reject(err)}else if(resolve){resolve(file)}else{cb(null,file)}}}}function processSync(doc){var complete=false;var file;freeze();assertParser("processSync",processor.Parser);assertCompiler("processSync",processor.Compiler);file=vfile(doc);process(file,done);assertDone("processSync","process",complete);return file;function done(err){complete=true;bail(err)}}}function newable(value){return func(value)&&keys(value.prototype)}function keys(value){var key;for(key in value){return true}return false}function assertParser(name,Parser){if(!func(Parser)){throw new Error("Cannot `"+name+"` without `Parser`")}}function assertCompiler(name,Compiler){if(!func(Compiler)){throw new Error("Cannot `"+name+"` without `Compiler`")}}function assertUnfrozen(name,frozen){if(frozen){throw new Error("Cannot invoke `"+name+"` on a frozen processor.\n"+"Create a new processor first, by invoking it: "+"use `processor()` instead of `processor`.")}}function assertNode(node){if(!node||!string(node.type)){throw new Error("Expected node, got `"+node+"`")}}function assertDone(name,asyncName,complete){if(!complete){throw new Error("`"+name+"` finished async. Use `"+asyncName+"` instead")}}},function(module,exports,__webpack_require__){"use strict";var hasOwn=Object.prototype.hasOwnProperty;var toStr=Object.prototype.toString;var defineProperty=Object.defineProperty;var gOPD=Object.getOwnPropertyDescriptor;var isArray=function isArray(arr){if(typeof Array.isArray==="function"){return Array.isArray(arr)}return toStr.call(arr)==="[object Array]"};var isPlainObject=function isPlainObject(obj){if(!obj||toStr.call(obj)!=="[object Object]"){return false}var hasOwnConstructor=hasOwn.call(obj,"constructor");var hasIsPrototypeOf=obj.constructor&&obj.constructor.prototype&&hasOwn.call(obj.constructor.prototype,"isPrototypeOf");if(obj.constructor&&!hasOwnConstructor&&!hasIsPrototypeOf){return false}var key;for(key in obj){}return typeof key==="undefined"||hasOwn.call(obj,key)};var setProperty=function setProperty(target,options){if(defineProperty&&options.name==="__proto__"){defineProperty(target,options.name,{enumerable:true,configurable:true,value:options.newValue,writable:true})}else{target[options.name]=options.newValue}};var getProperty=function getProperty(obj,name){if(name==="__proto__"){if(!hasOwn.call(obj,name)){return void 0}else if(gOPD){return gOPD(obj,name).value}}return obj[name]};module.exports=function extend(){var options,name,src,copy,copyIsArray,clone;var target=arguments[0];var i=1;var length=arguments.length;var deep=false;if(typeof target==="boolean"){deep=target;target=arguments[1]||{};i=2}if(target==null||typeof target!=="object"&&typeof target!=="function"){target={}}for(;i<length;++i){options=arguments[i];if(options!=null){for(name in options){src=getProperty(target,name);copy=getProperty(options,name);if(target!==copy){if(deep&&copy&&(isPlainObject(copy)||(copyIsArray=isArray(copy)))){if(copyIsArray){copyIsArray=false;clone=src&&isArray(src)?src:[]}else{clone=src&&isPlainObject(src)?src:{}}setProperty(target,{name:name,newValue:extend(deep,clone,copy)})}else if(typeof copy!=="undefined"){setProperty(target,{name:name,newValue:copy})}}}}}return target}},function(module,exports,__webpack_require__){"use strict";module.exports=bail;function bail(err){if(err){throw err}}},function(module,exports,__webpack_require__){"use strict";var VMessage=__webpack_require__(182);var VFile=__webpack_require__(184);module.exports=VFile;var proto=VFile.prototype;proto.message=message;proto.info=info;proto.fail=fail;proto.warn=message;function message(reason,position,origin){var filePath=this.path;var message=new VMessage(reason,position,origin);if(filePath){message.name=filePath+":"+message.name;message.file=filePath}message.fatal=false;this.messages.push(message);return message}function fail(){var message=this.message.apply(this,arguments);message.fatal=true;throw message}function info(){var message=this.message.apply(this,arguments);message.fatal=null;return message}},function(module,exports,__webpack_require__){"use strict";var stringify=__webpack_require__(183);module.exports=VMessage;function VMessagePrototype(){}VMessagePrototype.prototype=Error.prototype;VMessage.prototype=new VMessagePrototype;var proto=VMessage.prototype;proto.file="";proto.name="";proto.reason="";proto.message="";proto.stack="";proto.fatal=null;proto.column=null;proto.line=null;function VMessage(reason,position,origin){var parts;var range;var location;if(typeof position==="string"){origin=position;position=null}parts=parseOrigin(origin);range=stringify(position)||"1:1";location={start:{line:null,column:null},end:{line:null,column:null}};if(position&&position.position){position=position.position}if(position){if(position.start){location=position;position=position.start}else{location.start=position}}if(reason.stack){this.stack=reason.stack;reason=reason.message}this.message=reason;this.name=range;this.reason=reason;this.line=position?position.line:null;this.column=position?position.column:null;this.location=location;this.source=parts[0];this.ruleId=parts[1]}function parseOrigin(origin){var result=[null,null];var index;if(typeof origin==="string"){index=origin.indexOf(":");if(index===-1){result[1]=origin}else{result[0]=origin.slice(0,index);result[1]=origin.slice(index+1)}}return result}},function(module,exports,__webpack_require__){"use strict";var own={}.hasOwnProperty;module.exports=stringify;function stringify(value){if(!value||typeof value!=="object"){return null}if(own.call(value,"position")||own.call(value,"type")){return location(value.position)}if(own.call(value,"start")||own.call(value,"end")){return location(value)}if(own.call(value,"line")||own.call(value,"column")){return position(value)}return null}function position(pos){if(!pos||typeof pos!=="object"){pos={}}return index(pos.line)+":"+index(pos.column)}function location(loc){if(!loc||typeof loc!=="object"){loc={}}return position(loc.start)+"-"+position(loc.end)}function index(value){return value&&typeof value==="number"?value:1}},function(module,exports,__webpack_require__){"use strict";(function(process){var path=__webpack_require__(135);var replace=__webpack_require__(185);var buffer=__webpack_require__(186);module.exports=VFile;var own={}.hasOwnProperty;var proto=VFile.prototype;proto.toString=toString;var order=["history","path","basename","stem","extname","dirname"];function VFile(options){var prop;var index;var length;if(!options){options={}}else if(typeof options==="string"||buffer(options)){options={contents:options}}else if("message"in options&&"messages"in options){return options}if(!(this instanceof VFile)){return new VFile(options)}this.data={};this.messages=[];this.history=[];this.cwd=process.cwd();index=-1;length=order.length;while(++index<length){prop=order[index];if(own.call(options,prop)){this[prop]=options[prop]}}for(prop in options){if(order.indexOf(prop)===-1){this[prop]=options[prop]}}}Object.defineProperty(proto,"path",{get:function(){return this.history[this.history.length-1]},set:function(path){assertNonEmpty(path,"path");if(path!==this.path){this.history.push(path)}}});Object.defineProperty(proto,"dirname",{get:function(){return typeof this.path==="string"?path.dirname(this.path):undefined},set:function(dirname){assertPath(this.path,"dirname");this.path=path.join(dirname||"",this.basename)}});Object.defineProperty(proto,"basename",{get:function(){return typeof this.path==="string"?path.basename(this.path):undefined},set:function(basename){assertNonEmpty(basename,"basename");assertPart(basename,"basename");this.path=path.join(this.dirname||"",basename)}});Object.defineProperty(proto,"extname",{get:function(){return typeof this.path==="string"?path.extname(this.path):undefined},set:function(extname){var ext=extname||"";assertPart(ext,"extname");assertPath(this.path,"extname");if(ext){if(ext.charAt(0)!=="."){throw new Error("`extname` must start with `.`")}if(ext.indexOf(".",1)!==-1){throw new Error("`extname` cannot contain multiple dots")}}this.path=replace(this.path,ext)}});Object.defineProperty(proto,"stem",{get:function(){return typeof this.path==="string"?path.basename(this.path,this.extname):undefined},set:function(stem){assertNonEmpty(stem,"stem");assertPart(stem,"stem");this.path=path.join(this.dirname||"",stem+(this.extname||""))}});function toString(encoding){var value=this.contents||"";return buffer(value)?value.toString(encoding):String(value)}function assertPart(part,name){if(part.indexOf(path.sep)!==-1){throw new Error("`"+name+"` cannot be a path: did not expect `"+path.sep+"`")}}function assertNonEmpty(part,name){if(!part){throw new Error("`"+name+"` cannot be empty")}}function assertPath(path,name){if(!path){throw new Error("Setting `"+name+"` requires `path` to be set too")}}}).call(this,__webpack_require__(62))},function(module,exports,__webpack_require__){"use strict";var path=__webpack_require__(135);function replaceExt(npath,ext){if(typeof npath!=="string"){return npath}if(npath.length===0){return npath}var nFileName=path.basename(npath,path.extname(npath))+ext;return path.join(path.dirname(npath),nFileName)}module.exports=replaceExt},function(module,exports){
/*!
 * Determine if an object is a Buffer
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
module.exports=function(obj){return obj!=null&&(isBuffer(obj)||isSlowBuffer(obj)||!!obj._isBuffer)};function isBuffer(obj){return!!obj.constructor&&typeof obj.constructor.isBuffer==="function"&&obj.constructor.isBuffer(obj)}function isSlowBuffer(obj){return typeof obj.readFloatLE==="function"&&typeof obj.slice==="function"&&isBuffer(obj.slice(0,0))}},function(module,exports,__webpack_require__){"use strict";module.exports=trough;var slice=[].slice;function trough(){var fns=[];var middleware={};middleware.run=run;middleware.use=use;return middleware;function run(){var index=-1;var input=slice.call(arguments,0,-1);var done=arguments[arguments.length-1];if(typeof done!=="function"){throw new Error("Expected function as last argument, not "+done)}next.apply(null,[null].concat(input));function next(err){var fn=fns[++index];var params=slice.call(arguments,0);var values=params.slice(1);var length=input.length;var pos=-1;if(err){done(err);return}while(++pos<length){if(values[pos]===null||values[pos]===undefined){values[pos]=input[pos]}}input=values;if(fn){wrap(fn,next).apply(null,input)}else{done.apply(null,[null].concat(input))}}}function use(fn){if(typeof fn!=="function"){throw new Error("Expected `fn` to be a function, not "+fn)}fns.push(fn);return middleware}}function wrap(fn,next){var invoked;return wrapped;function wrapped(){var params=slice.call(arguments,0);var callback=fn.length>params.length;var result;if(callback){params.push(done)}try{result=fn.apply(null,params)}catch(err){if(callback&&invoked){throw err}return done(err)}if(!callback){if(result&&typeof result.then==="function"){result.then(then,done)}else if(result instanceof Error){done(result)}else{then(result)}}}function done(){if(!invoked){invoked=true;next.apply(null,arguments)}}function then(value){done(null,value)}}},function(module,exports){var toString=Object.prototype.toString;module.exports=isString;function isString(obj){return toString.call(obj)==="[object String]"}},function(module,exports){module.exports=function isFunction(fn){return Object.prototype.toString.call(fn)==="[object Function]"}},function(module,exports,__webpack_require__){"use strict";var toString=Object.prototype.toString;module.exports=function(x){var prototype;return toString.call(x)==="[object Object]"&&(prototype=Object.getPrototypeOf(x),prototype===null||prototype===Object.getPrototypeOf({}))}},function(module,exports,__webpack_require__){"use strict";var unherit=__webpack_require__(192);var xtend=__webpack_require__(110);var Parser=__webpack_require__(194);module.exports=parse;parse.Parser=Parser;function parse(options){var Local=unherit(Parser);Local.prototype.options=xtend(Local.prototype.options,this.data("settings"),options);this.Parser=Local}},function(module,exports,__webpack_require__){"use strict";
/**
 * @author Titus Wormer
 * @copyright 2015 Titus Wormer
 * @license MIT
 * @module unherit
 * @fileoverview Create a custom constructor which can be modified
 *   without affecting the original class.
 */var xtend=__webpack_require__(110);var inherits=__webpack_require__(193);module.exports=unherit;function unherit(Super){var result;var key;var value;inherits(Of,Super);inherits(From,Of);result=Of.prototype;for(key in result){value=result[key];if(value&&typeof value==="object"){result[key]="concat"in value?value.concat():xtend(value)}}return Of;function From(parameters){return Super.apply(this,parameters)}function Of(){if(!(this instanceof Of)){return new From(arguments)}return Super.apply(this,arguments)}}},function(module,exports){if(typeof Object.create==="function"){module.exports=function inherits(ctor,superCtor){if(superCtor){ctor.super_=superCtor;ctor.prototype=Object.create(superCtor.prototype,{constructor:{value:ctor,enumerable:false,writable:true,configurable:true}})}}}else{module.exports=function inherits(ctor,superCtor){if(superCtor){ctor.super_=superCtor;var TempCtor=function(){};TempCtor.prototype=superCtor.prototype;ctor.prototype=new TempCtor;ctor.prototype.constructor=ctor}}}},function(module,exports,__webpack_require__){"use strict";var xtend=__webpack_require__(110);var toggle=__webpack_require__(195);var vfileLocation=__webpack_require__(196);var unescape=__webpack_require__(197);var decode=__webpack_require__(198);var tokenizer=__webpack_require__(204);module.exports=Parser;function Parser(doc,file){this.file=file;this.offset={};this.options=xtend(this.options);this.setOptions({});this.inList=false;this.inBlock=false;this.inLink=false;this.atStart=true;this.toOffset=vfileLocation(file).toOffset;this.unescape=unescape(this,"escape");this.decode=decode(this)}var proto=Parser.prototype;proto.setOptions=__webpack_require__(205);proto.parse=__webpack_require__(208);proto.options=__webpack_require__(137);proto.exitStart=toggle("atStart",true);proto.enterList=toggle("inList",false);proto.enterLink=toggle("inLink",false);proto.enterBlock=toggle("inBlock",false);proto.interruptParagraph=[["thematicBreak"],["atxHeading"],["fencedCode"],["blockquote"],["html"],["setextHeading",{commonmark:false}],["definition",{commonmark:false}],["footnote",{commonmark:false}]];proto.interruptList=[["atxHeading",{pedantic:false}],["fencedCode",{pedantic:false}],["thematicBreak",{pedantic:false}],["definition",{commonmark:false}],["footnote",{commonmark:false}]];proto.interruptBlockquote=[["indentedCode",{commonmark:true}],["fencedCode",{commonmark:true}],["atxHeading",{commonmark:true}],["setextHeading",{commonmark:true}],["thematicBreak",{commonmark:true}],["html",{commonmark:true}],["list",{commonmark:true}],["definition",{commonmark:false}],["footnote",{commonmark:false}]];proto.blockTokenizers={newline:__webpack_require__(212),indentedCode:__webpack_require__(213),fencedCode:__webpack_require__(214),blockquote:__webpack_require__(215),atxHeading:__webpack_require__(216),thematicBreak:__webpack_require__(217),list:__webpack_require__(218),setextHeading:__webpack_require__(220),html:__webpack_require__(221),footnote:__webpack_require__(222),definition:__webpack_require__(224),table:__webpack_require__(225),paragraph:__webpack_require__(226)};proto.inlineTokenizers={escape:__webpack_require__(227),autoLink:__webpack_require__(229),url:__webpack_require__(230),html:__webpack_require__(232),link:__webpack_require__(233),reference:__webpack_require__(234),strong:__webpack_require__(235),emphasis:__webpack_require__(237),deletion:__webpack_require__(240),code:__webpack_require__(242),break:__webpack_require__(244),text:__webpack_require__(246)};proto.blockMethods=keys(proto.blockTokenizers);proto.inlineMethods=keys(proto.inlineTokenizers);proto.tokenizeBlock=tokenizer("block");proto.tokenizeInline=tokenizer("inline");proto.tokenizeFactory=tokenizer;function keys(value){var result=[];var key;for(key in value){result.push(key)}return result}},function(module,exports,__webpack_require__){"use strict";
/**
 * @author Titus Wormer
 * @copyright 2016 Titus Wormer
 * @license MIT
 * @module state-toggle
 * @fileoverview Enter/exit a state.
 */module.exports=factory;function factory(key,state,ctx){return function(){var context=ctx||this;var current=context[key];context[key]=!state;return function(){context[key]=current}}}},function(module,exports,__webpack_require__){"use strict";module.exports=factory;function factory(file){var contents=indices(String(file));return{toPosition:offsetToPositionFactory(contents),toOffset:positionToOffsetFactory(contents)}}function offsetToPositionFactory(indices){return offsetToPosition;function offsetToPosition(offset){var index=-1;var length=indices.length;if(offset<0){return{}}while(++index<length){if(indices[index]>offset){return{line:index+1,column:offset-(indices[index-1]||0)+1,offset:offset}}}return{}}}function positionToOffsetFactory(indices){return positionToOffset;function positionToOffset(position){var line=position&&position.line;var column=position&&position.column;if(!isNaN(line)&&!isNaN(column)&&line-1 in indices){return(indices[line-2]||0)+column-1||0}return-1}}function indices(value){var result=[];var index=value.indexOf("\n");while(index!==-1){result.push(index+1);index=value.indexOf("\n",index+1)}result.push(value.length+1);return result}},function(module,exports,__webpack_require__){"use strict";module.exports=factory;function factory(ctx,key){return unescape;function unescape(value){var prev=0;var index=value.indexOf("\\");var escape=ctx[key];var queue=[];var character;while(index!==-1){queue.push(value.slice(prev,index));prev=index+1;character=value.charAt(prev);if(!character||escape.indexOf(character)===-1){queue.push("\\")}index=value.indexOf("\\",prev)}queue.push(value.slice(prev));return queue.join("")}}},function(module,exports,__webpack_require__){"use strict";var xtend=__webpack_require__(110);var entities=__webpack_require__(122);module.exports=factory;function factory(ctx){decoder.raw=decodeRaw;return decoder;function normalize(position){var offsets=ctx.offset;var line=position.line;var result=[];while(++line){if(!(line in offsets)){break}result.push((offsets[line]||0)+1)}return{start:position,indent:result}}function handleWarning(reason,position,code){if(code===3){return}ctx.file.message(reason,position)}function decoder(value,position,handler){entities(value,{position:normalize(position),warning:handleWarning,text:handler,reference:handler,textContext:ctx,referenceContext:ctx})}function decodeRaw(value,position,options){return entities(value,xtend(options,{position:normalize(position),warning:handleWarning}))}}},function(module){module.exports=JSON.parse('{"AElig":"Æ","AMP":"&","Aacute":"Á","Acirc":"Â","Agrave":"À","Aring":"Å","Atilde":"Ã","Auml":"Ä","COPY":"©","Ccedil":"Ç","ETH":"Ð","Eacute":"É","Ecirc":"Ê","Egrave":"È","Euml":"Ë","GT":">","Iacute":"Í","Icirc":"Î","Igrave":"Ì","Iuml":"Ï","LT":"<","Ntilde":"Ñ","Oacute":"Ó","Ocirc":"Ô","Ograve":"Ò","Oslash":"Ø","Otilde":"Õ","Ouml":"Ö","QUOT":"\\"","REG":"®","THORN":"Þ","Uacute":"Ú","Ucirc":"Û","Ugrave":"Ù","Uuml":"Ü","Yacute":"Ý","aacute":"á","acirc":"â","acute":"´","aelig":"æ","agrave":"à","amp":"&","aring":"å","atilde":"ã","auml":"ä","brvbar":"¦","ccedil":"ç","cedil":"¸","cent":"¢","copy":"©","curren":"¤","deg":"°","divide":"÷","eacute":"é","ecirc":"ê","egrave":"è","eth":"ð","euml":"ë","frac12":"½","frac14":"¼","frac34":"¾","gt":">","iacute":"í","icirc":"î","iexcl":"¡","igrave":"ì","iquest":"¿","iuml":"ï","laquo":"«","lt":"<","macr":"¯","micro":"µ","middot":"·","nbsp":" ","not":"¬","ntilde":"ñ","oacute":"ó","ocirc":"ô","ograve":"ò","ordf":"ª","ordm":"º","oslash":"ø","otilde":"õ","ouml":"ö","para":"¶","plusmn":"±","pound":"£","quot":"\\"","raquo":"»","reg":"®","sect":"§","shy":"­","sup1":"¹","sup2":"²","sup3":"³","szlig":"ß","thorn":"þ","times":"×","uacute":"ú","ucirc":"û","ugrave":"ù","uml":"¨","uuml":"ü","yacute":"ý","yen":"¥","yuml":"ÿ"}')},function(module){module.exports=JSON.parse('{"0":"�","128":"€","130":"‚","131":"ƒ","132":"„","133":"…","134":"†","135":"‡","136":"ˆ","137":"‰","138":"Š","139":"‹","140":"Œ","142":"Ž","145":"‘","146":"’","147":"“","148":"”","149":"•","150":"–","151":"—","152":"˜","153":"™","154":"š","155":"›","156":"œ","158":"ž","159":"Ÿ"}')},function(module,exports,__webpack_require__){"use strict";module.exports=hexadecimal;function hexadecimal(character){var code=typeof character==="string"?character.charCodeAt(0):character;return code>=97&&code<=102||code>=65&&code<=70||code>=48&&code<=57}},function(module,exports,__webpack_require__){"use strict";var alphabetical=__webpack_require__(136);var decimal=__webpack_require__(114);module.exports=alphanumerical;function alphanumerical(character){return alphabetical(character)||decimal(character)}},function(module,exports,__webpack_require__){"use strict";var el;module.exports=decodeEntity;function decodeEntity(characters){var entity="&"+characters+";";var char;el=el||document.createElement("i");el.innerHTML=entity;char=el.textContent;if(char.slice(-1)===";"&&characters!=="semi"){return false}return char===entity?false:char}},function(module,exports,__webpack_require__){"use strict";module.exports=factory;var MERGEABLE_NODES={text:mergeText,blockquote:mergeBlockquote};function mergeable(node){var start;var end;if(node.type!=="text"||!node.position){return true}start=node.position.start;end=node.position.end;return start.line!==end.line||end.column-start.column===node.value.length}function mergeText(prev,node){prev.value+=node.value;return prev}function mergeBlockquote(prev,node){if(this.options.commonmark){return node}prev.children=prev.children.concat(node.children);return prev}function factory(type){return tokenize;function tokenize(value,location){var self=this;var offset=self.offset;var tokens=[];var methods=self[type+"Methods"];var tokenizers=self[type+"Tokenizers"];var line=location.line;var column=location.column;var index;var length;var method;var name;var matched;var valueLength;if(!value){return tokens}eat.now=now;eat.file=self.file;updatePosition("");while(value){index=-1;length=methods.length;matched=false;while(++index<length){name=methods[index];method=tokenizers[name];if(method&&(!method.onlyAtStart||self.atStart)&&(!method.notInList||!self.inList)&&(!method.notInBlock||!self.inBlock)&&(!method.notInLink||!self.inLink)){valueLength=value.length;method.apply(self,[eat,value]);matched=valueLength!==value.length;if(matched){break}}}if(!matched){self.file.fail(new Error("Infinite loop"),eat.now())}}self.eof=now();return tokens;function updatePosition(subvalue){var lastIndex=-1;var index=subvalue.indexOf("\n");while(index!==-1){line++;lastIndex=index;index=subvalue.indexOf("\n",index+1)}if(lastIndex===-1){column+=subvalue.length}else{column=subvalue.length-lastIndex}if(line in offset){if(lastIndex!==-1){column+=offset[line]}else if(column<=offset[line]){column=offset[line]+1}}}function getOffset(){var indentation=[];var pos=line+1;return function(){var last=line+1;while(pos<last){indentation.push((offset[pos]||0)+1);pos++}return indentation}}function now(){var pos={line:line,column:column};pos.offset=self.toOffset(pos);return pos}function Position(start){this.start=start;this.end=now()}function validateEat(subvalue){if(value.substring(0,subvalue.length)!==subvalue){self.file.fail(new Error("Incorrectly eaten value: please report this "+"warning on http://git.io/vg5Ft"),now())}}function position(){var before=now();return update;function update(node,indent){var prev=node.position;var start=prev?prev.start:before;var combined=[];var n=prev&&prev.end.line;var l=before.line;node.position=new Position(start);if(prev&&indent&&prev.indent){combined=prev.indent;if(n<l){while(++n<l){combined.push((offset[n]||0)+1)}combined.push(before.column)}indent=combined.concat(indent)}node.position.indent=indent||[];return node}}function add(node,parent){var children=parent?parent.children:tokens;var prev=children[children.length-1];if(prev&&node.type===prev.type&&node.type in MERGEABLE_NODES&&mergeable(prev)&&mergeable(node)){node=MERGEABLE_NODES[node.type].call(self,prev,node)}if(node!==prev){children.push(node)}if(self.atStart&&tokens.length!==0){self.exitStart()}return node}function eat(subvalue){var indent=getOffset();var pos=position();var current=now();validateEat(subvalue);apply.reset=reset;reset.test=test;apply.test=test;value=value.substring(subvalue.length);updatePosition(subvalue);indent=indent();return apply;function apply(node,parent){return pos(add(pos(node),parent),indent)}function reset(){var node=apply.apply(null,arguments);line=current.line;column=current.column;value=subvalue+value;return node}function test(){var result=pos({});line=current.line;column=current.column;value=subvalue+value;return result.position}}}}},function(module,exports,__webpack_require__){"use strict";var xtend=__webpack_require__(110);var escapes=__webpack_require__(206);var defaults=__webpack_require__(137);module.exports=setOptions;function setOptions(options){var self=this;var current=self.options;var key;var value;if(options==null){options={}}else if(typeof options==="object"){options=xtend(options)}else{throw new Error("Invalid value `"+options+"` "+"for setting `options`")}for(key in defaults){value=options[key];if(value==null){value=current[key]}if(key!=="blocks"&&typeof value!=="boolean"||key==="blocks"&&typeof value!=="object"){throw new Error("Invalid value `"+value+"` for setting `options."+key+"`")}options[key]=value}self.options=options;self.escape=escapes(options);return self}},function(module,exports,__webpack_require__){"use strict";module.exports=escapes;var defaults=["\\","`","*","{","}","[","]","(",")","#","+","-",".","!","_",">"];var gfm=defaults.concat(["~","|"]);var commonmark=gfm.concat(["\n",'"',"$","%","&","'",",","/",":",";","<","=","?","@","^"]);escapes.default=defaults;escapes.gfm=gfm;escapes.commonmark=commonmark;function escapes(options){var settings=options||{};if(settings.commonmark){return commonmark}return settings.gfm?gfm:defaults}},function(module){module.exports=JSON.parse('["address","article","aside","base","basefont","blockquote","body","caption","center","col","colgroup","dd","details","dialog","dir","div","dl","dt","fieldset","figcaption","figure","footer","form","frame","frameset","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","iframe","legend","li","link","main","menu","menuitem","meta","nav","noframes","ol","optgroup","option","p","param","pre","section","source","title","summary","table","tbody","td","tfoot","th","thead","title","tr","track","ul"]')},function(module,exports,__webpack_require__){"use strict";var xtend=__webpack_require__(110);var removePosition=__webpack_require__(209);module.exports=parse;var C_NEWLINE="\n";var EXPRESSION_LINE_BREAKS=/\r\n|\r/g;function parse(){var self=this;var value=String(self.file);var start={line:1,column:1,offset:0};var content=xtend(start);var node;value=value.replace(EXPRESSION_LINE_BREAKS,C_NEWLINE);if(value.charCodeAt(0)===65279){value=value.slice(1);content.column++;content.offset++}node={type:"root",children:self.tokenizeBlock(value,content),position:{start:start,end:self.eof||xtend(start)}};if(!self.options.position){removePosition(node,true)}return node}},function(module,exports,__webpack_require__){"use strict";var visit=__webpack_require__(115);module.exports=removePosition;function removePosition(node,force){visit(node,force?hard:soft);return node}function hard(node){delete node.position}function soft(node){node.position=undefined}},function(module,exports,__webpack_require__){"use strict";module.exports=visitParents;var convert=__webpack_require__(211);var CONTINUE=true;var SKIP="skip";var EXIT=false;visitParents.CONTINUE=CONTINUE;visitParents.SKIP=SKIP;visitParents.EXIT=EXIT;function visitParents(tree,test,visitor,reverse){var is;if(typeof test==="function"&&typeof visitor!=="function"){reverse=visitor;visitor=test;test=null}is=convert(test);one(tree,null,[]);function one(node,index,parents){var result=[];var subresult;if(!test||is(node,index,parents[parents.length-1]||null)){result=toResult(visitor(node,parents));if(result[0]===EXIT){return result}}if(node.children&&result[0]!==SKIP){subresult=toResult(all(node.children,parents.concat(node)));return subresult[0]===EXIT?subresult:result}return result}function all(children,parents){var min=-1;var step=reverse?-1:1;var index=(reverse?children.length:min)+step;var result;while(index>min&&index<children.length){result=one(children[index],index,parents);if(result[0]===EXIT){return result}index=typeof result[1]==="number"?result[1]:index+step}}}function toResult(value){if(value!==null&&typeof value==="object"&&"length"in value){return value}if(typeof value==="number"){return[CONTINUE,value]}return[value]}},function(module,exports,__webpack_require__){"use strict";module.exports=convert;function convert(test){if(typeof test==="string"){return typeFactory(test)}if(test===null||test===undefined){return ok}if(typeof test==="object"){return("length"in test?anyFactory:matchesFactory)(test)}if(typeof test==="function"){return test}throw new Error("Expected function, string, or object as test")}function convertAll(tests){var results=[];var length=tests.length;var index=-1;while(++index<length){results[index]=convert(tests[index])}return results}function matchesFactory(test){return matches;function matches(node){var key;for(key in test){if(node[key]!==test[key]){return false}}return true}}function anyFactory(tests){var checks=convertAll(tests);var length=checks.length;return matches;function matches(){var index=-1;while(++index<length){if(checks[index].apply(this,arguments)){return true}}return false}}function typeFactory(test){return type;function type(node){return Boolean(node&&node.type===test)}}function ok(){return true}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);module.exports=newline;function newline(eat,value,silent){var character=value.charAt(0);var length;var subvalue;var queue;var index;if(character!=="\n"){return}if(silent){return true}index=1;length=value.length;subvalue=character;queue="";while(index<length){character=value.charAt(index);if(!whitespace(character)){break}queue+=character;if(character==="\n"){subvalue+=queue;queue=""}index++}eat(subvalue)}},function(module,exports,__webpack_require__){"use strict";var repeat=__webpack_require__(123);var trim=__webpack_require__(124);module.exports=indentedCode;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var CODE_INDENT_COUNT=4;var CODE_INDENT=repeat(C_SPACE,CODE_INDENT_COUNT);function indentedCode(eat,value,silent){var index=-1;var length=value.length;var subvalue="";var content="";var subvalueQueue="";var contentQueue="";var character;var blankQueue;var indent;while(++index<length){character=value.charAt(index);if(indent){indent=false;subvalue+=subvalueQueue;content+=contentQueue;subvalueQueue="";contentQueue="";if(character===C_NEWLINE){subvalueQueue=character;contentQueue=character}else{subvalue+=character;content+=character;while(++index<length){character=value.charAt(index);if(!character||character===C_NEWLINE){contentQueue=character;subvalueQueue=character;break}subvalue+=character;content+=character}}}else if(character===C_SPACE&&value.charAt(index+1)===character&&value.charAt(index+2)===character&&value.charAt(index+3)===character){subvalueQueue+=CODE_INDENT;index+=3;indent=true}else if(character===C_TAB){subvalueQueue+=character;indent=true}else{blankQueue="";while(character===C_TAB||character===C_SPACE){blankQueue+=character;character=value.charAt(++index)}if(character!==C_NEWLINE){break}subvalueQueue+=blankQueue+character;contentQueue+=character}}if(content){if(silent){return true}return eat(subvalue)({type:"code",lang:null,value:trim(content)})}}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(124);module.exports=fencedCode;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_TILDE="~";var C_TICK="`";var MIN_FENCE_COUNT=3;var CODE_INDENT_COUNT=4;function fencedCode(eat,value,silent){var self=this;var settings=self.options;var length=value.length+1;var index=0;var subvalue="";var fenceCount;var marker;var character;var flag;var queue;var content;var exdentedContent;var closing;var exdentedClosing;var indent;var now;if(!settings.gfm){return}while(index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){break}subvalue+=character;index++}indent=index;character=value.charAt(index);if(character!==C_TILDE&&character!==C_TICK){return}index++;marker=character;fenceCount=1;subvalue+=character;while(index<length){character=value.charAt(index);if(character!==marker){break}subvalue+=character;fenceCount++;index++}if(fenceCount<MIN_FENCE_COUNT){return}while(index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){break}subvalue+=character;index++}flag="";queue="";while(index<length){character=value.charAt(index);if(character===C_NEWLINE||character===C_TILDE||character===C_TICK){break}if(character===C_SPACE||character===C_TAB){queue+=character}else{flag+=queue+character;queue=""}index++}character=value.charAt(index);if(character&&character!==C_NEWLINE){return}if(silent){return true}now=eat.now();now.column+=subvalue.length;now.offset+=subvalue.length;subvalue+=flag;flag=self.decode.raw(self.unescape(flag),now);if(queue){subvalue+=queue}queue="";closing="";exdentedClosing="";content="";exdentedContent="";while(index<length){character=value.charAt(index);content+=closing;exdentedContent+=exdentedClosing;closing="";exdentedClosing="";if(character!==C_NEWLINE){content+=character;exdentedClosing+=character;index++;continue}if(content){closing+=character;exdentedClosing+=character}else{subvalue+=character}queue="";index++;while(index<length){character=value.charAt(index);if(character!==C_SPACE){break}queue+=character;index++}closing+=queue;exdentedClosing+=queue.slice(indent);if(queue.length>=CODE_INDENT_COUNT){continue}queue="";while(index<length){character=value.charAt(index);if(character!==marker){break}queue+=character;index++}closing+=queue;exdentedClosing+=queue;if(queue.length<fenceCount){continue}queue="";while(index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){break}closing+=character;exdentedClosing+=character;index++}if(!character||character===C_NEWLINE){break}}subvalue+=content+closing;return eat(subvalue)({type:"code",lang:flag||null,value:trim(exdentedContent)})}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(112);var interrupt=__webpack_require__(125);module.exports=blockquote;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_GT=">";function blockquote(eat,value,silent){var self=this;var offsets=self.offset;var tokenizers=self.blockTokenizers;var interruptors=self.interruptBlockquote;var now=eat.now();var currentLine=now.line;var length=value.length;var values=[];var contents=[];var indents=[];var add;var index=0;var character;var rest;var nextIndex;var content;var line;var startIndex;var prefixed;var exit;while(index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){break}index++}if(value.charAt(index)!==C_GT){return}if(silent){return true}index=0;while(index<length){nextIndex=value.indexOf(C_NEWLINE,index);startIndex=index;prefixed=false;if(nextIndex===-1){nextIndex=length}while(index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){break}index++}if(value.charAt(index)===C_GT){index++;prefixed=true;if(value.charAt(index)===C_SPACE){index++}}else{index=startIndex}content=value.slice(index,nextIndex);if(!prefixed&&!trim(content)){index=startIndex;break}if(!prefixed){rest=value.slice(index);if(interrupt(interruptors,tokenizers,self,[eat,rest,true])){break}}line=startIndex===index?content:value.slice(startIndex,nextIndex);indents.push(index-startIndex);values.push(line);contents.push(content);index=nextIndex+1}index=-1;length=indents.length;add=eat(values.join(C_NEWLINE));while(++index<length){offsets[currentLine]=(offsets[currentLine]||0)+indents[index];currentLine++}exit=self.enterBlock();contents=self.tokenizeBlock(contents.join(C_NEWLINE),now);exit();return add({type:"blockquote",children:contents})}},function(module,exports,__webpack_require__){"use strict";module.exports=atxHeading;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_HASH="#";var MAX_ATX_COUNT=6;function atxHeading(eat,value,silent){var self=this;var settings=self.options;var length=value.length+1;var index=-1;var now=eat.now();var subvalue="";var content="";var character;var queue;var depth;while(++index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){index--;break}subvalue+=character}depth=0;while(++index<=length){character=value.charAt(index);if(character!==C_HASH){index--;break}subvalue+=character;depth++}if(depth>MAX_ATX_COUNT){return}if(!depth||!settings.pedantic&&value.charAt(index+1)===C_HASH){return}length=value.length+1;queue="";while(++index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){index--;break}queue+=character}if(!settings.pedantic&&queue.length===0&&character&&character!==C_NEWLINE){return}if(silent){return true}subvalue+=queue;queue="";content="";while(++index<length){character=value.charAt(index);if(!character||character===C_NEWLINE){break}if(character!==C_SPACE&&character!==C_TAB&&character!==C_HASH){content+=queue+character;queue="";continue}while(character===C_SPACE||character===C_TAB){queue+=character;character=value.charAt(++index)}while(character===C_HASH){queue+=character;character=value.charAt(++index)}while(character===C_SPACE||character===C_TAB){queue+=character;character=value.charAt(++index)}index--}now.column+=subvalue.length;now.offset+=subvalue.length;subvalue+=content+queue;return eat(subvalue)({type:"heading",depth:depth,children:self.tokenizeInline(content,now)})}},function(module,exports,__webpack_require__){"use strict";module.exports=thematicBreak;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_ASTERISK="*";var C_UNDERSCORE="_";var C_DASH="-";var THEMATIC_BREAK_MARKER_COUNT=3;function thematicBreak(eat,value,silent){var index=-1;var length=value.length+1;var subvalue="";var character;var marker;var markerCount;var queue;while(++index<length){character=value.charAt(index);if(character!==C_TAB&&character!==C_SPACE){break}subvalue+=character}if(character!==C_ASTERISK&&character!==C_DASH&&character!==C_UNDERSCORE){return}marker=character;subvalue+=character;markerCount=1;queue="";while(++index<length){character=value.charAt(index);if(character===marker){markerCount++;subvalue+=queue+marker;queue=""}else if(character===C_SPACE){queue+=character}else if(markerCount>=THEMATIC_BREAK_MARKER_COUNT&&(!character||character===C_NEWLINE)){subvalue+=queue;if(silent){return true}return eat(subvalue)({type:"thematicBreak"})}else{return}}}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(112);var repeat=__webpack_require__(123);var decimal=__webpack_require__(114);var getIndent=__webpack_require__(138);var removeIndent=__webpack_require__(219);var interrupt=__webpack_require__(125);module.exports=list;var C_ASTERISK="*";var C_UNDERSCORE="_";var C_PLUS="+";var C_DASH="-";var C_DOT=".";var C_SPACE=" ";var C_NEWLINE="\n";var C_TAB="\t";var C_PAREN_CLOSE=")";var C_X_LOWER="x";var TAB_SIZE=4;var EXPRESSION_LOOSE_LIST_ITEM=/\n\n(?!\s*$)/;var EXPRESSION_TASK_ITEM=/^\[([ \t]|x|X)][ \t]/;var EXPRESSION_BULLET=/^([ \t]*)([*+-]|\d+[.)])( {1,4}(?! )| |\t|$|(?=\n))([^\n]*)/;var EXPRESSION_PEDANTIC_BULLET=/^([ \t]*)([*+-]|\d+[.)])([ \t]+)/;var EXPRESSION_INITIAL_INDENT=/^( {1,4}|\t)?/gm;var LIST_UNORDERED_MARKERS={};LIST_UNORDERED_MARKERS[C_ASTERISK]=true;LIST_UNORDERED_MARKERS[C_PLUS]=true;LIST_UNORDERED_MARKERS[C_DASH]=true;var LIST_ORDERED_MARKERS={};LIST_ORDERED_MARKERS[C_DOT]=true;var LIST_ORDERED_COMMONMARK_MARKERS={};LIST_ORDERED_COMMONMARK_MARKERS[C_DOT]=true;LIST_ORDERED_COMMONMARK_MARKERS[C_PAREN_CLOSE]=true;function list(eat,value,silent){var self=this;var commonmark=self.options.commonmark;var pedantic=self.options.pedantic;var tokenizers=self.blockTokenizers;var interuptors=self.interruptList;var markers;var index=0;var length=value.length;var start=null;var size=0;var queue;var ordered;var character;var marker;var nextIndex;var startIndex;var prefixed;var currentMarker;var content;var line;var prevEmpty;var empty;var items;var allLines;var emptyLines;var item;var enterTop;var exitBlockquote;var isLoose;var node;var now;var end;var indented;while(index<length){character=value.charAt(index);if(character===C_TAB){size+=TAB_SIZE-size%TAB_SIZE}else if(character===C_SPACE){size++}else{break}index++}if(size>=TAB_SIZE){return}character=value.charAt(index);markers=commonmark?LIST_ORDERED_COMMONMARK_MARKERS:LIST_ORDERED_MARKERS;if(LIST_UNORDERED_MARKERS[character]===true){marker=character;ordered=false}else{ordered=true;queue="";while(index<length){character=value.charAt(index);if(!decimal(character)){break}queue+=character;index++}character=value.charAt(index);if(!queue||markers[character]!==true){return}start=parseInt(queue,10);marker=character}character=value.charAt(++index);if(character!==C_SPACE&&character!==C_TAB){return}if(silent){return true}index=0;items=[];allLines=[];emptyLines=[];while(index<length){nextIndex=value.indexOf(C_NEWLINE,index);startIndex=index;prefixed=false;indented=false;if(nextIndex===-1){nextIndex=length}end=index+TAB_SIZE;size=0;while(index<length){character=value.charAt(index);if(character===C_TAB){size+=TAB_SIZE-size%TAB_SIZE}else if(character===C_SPACE){size++}else{break}index++}if(size>=TAB_SIZE){indented=true}if(item&&size>=item.indent){indented=true}character=value.charAt(index);currentMarker=null;if(!indented){if(LIST_UNORDERED_MARKERS[character]===true){currentMarker=character;index++;size++}else{queue="";while(index<length){character=value.charAt(index);if(!decimal(character)){break}queue+=character;index++}character=value.charAt(index);index++;if(queue&&markers[character]===true){currentMarker=character;size+=queue.length+1}}if(currentMarker){character=value.charAt(index);if(character===C_TAB){size+=TAB_SIZE-size%TAB_SIZE;index++}else if(character===C_SPACE){end=index+TAB_SIZE;while(index<end){if(value.charAt(index)!==C_SPACE){break}index++;size++}if(index===end&&value.charAt(index)===C_SPACE){index-=TAB_SIZE-1;size-=TAB_SIZE-1}}else if(character!==C_NEWLINE&&character!==""){currentMarker=null}}}if(currentMarker){if(!pedantic&&marker!==currentMarker){break}prefixed=true}else{if(!commonmark&&!indented&&value.charAt(startIndex)===C_SPACE){indented=true}else if(commonmark&&item){indented=size>=item.indent||size>TAB_SIZE}prefixed=false;index=startIndex}line=value.slice(startIndex,nextIndex);content=startIndex===index?line:value.slice(index,nextIndex);if(currentMarker===C_ASTERISK||currentMarker===C_UNDERSCORE||currentMarker===C_DASH){if(tokenizers.thematicBreak.call(self,eat,line,true)){break}}prevEmpty=empty;empty=!trim(content).length;if(indented&&item){item.value=item.value.concat(emptyLines,line);allLines=allLines.concat(emptyLines,line);emptyLines=[]}else if(prefixed){if(emptyLines.length!==0){item.value.push("");item.trail=emptyLines.concat()}item={value:[line],indent:size,trail:[]};items.push(item);allLines=allLines.concat(emptyLines,line);emptyLines=[]}else if(empty){if(prevEmpty){break}emptyLines.push(line)}else{if(prevEmpty){break}if(interrupt(interuptors,tokenizers,self,[eat,line,true])){break}item.value=item.value.concat(emptyLines,line);allLines=allLines.concat(emptyLines,line);emptyLines=[]}index=nextIndex+1}node=eat(allLines.join(C_NEWLINE)).reset({type:"list",ordered:ordered,start:start,loose:null,children:[]});enterTop=self.enterList();exitBlockquote=self.enterBlock();isLoose=false;index=-1;length=items.length;while(++index<length){item=items[index].value.join(C_NEWLINE);now=eat.now();item=eat(item)(listItem(self,item,now),node);if(item.loose){isLoose=true}item=items[index].trail.join(C_NEWLINE);if(index!==length-1){item+=C_NEWLINE}eat(item)}enterTop();exitBlockquote();node.loose=isLoose;return node}function listItem(ctx,value,position){var offsets=ctx.offset;var fn=ctx.options.pedantic?pedanticListItem:normalListItem;var checked=null;var task;var indent;value=fn.apply(null,arguments);if(ctx.options.gfm){task=value.match(EXPRESSION_TASK_ITEM);if(task){indent=task[0].length;checked=task[1].toLowerCase()===C_X_LOWER;offsets[position.line]+=indent;value=value.slice(indent)}}return{type:"listItem",loose:EXPRESSION_LOOSE_LIST_ITEM.test(value)||value.charAt(value.length-1)===C_NEWLINE,checked:checked,children:ctx.tokenizeBlock(value,position)}}function pedanticListItem(ctx,value,position){var offsets=ctx.offset;var line=position.line;value=value.replace(EXPRESSION_PEDANTIC_BULLET,replacer);line=position.line;return value.replace(EXPRESSION_INITIAL_INDENT,replacer);function replacer($0){offsets[line]=(offsets[line]||0)+$0.length;line++;return""}}function normalListItem(ctx,value,position){var offsets=ctx.offset;var line=position.line;var max;var bullet;var rest;var lines;var trimmedLines;var index;var length;value=value.replace(EXPRESSION_BULLET,replacer);lines=value.split(C_NEWLINE);trimmedLines=removeIndent(value,getIndent(max).indent).split(C_NEWLINE);trimmedLines[0]=rest;offsets[line]=(offsets[line]||0)+bullet.length;line++;index=0;length=lines.length;while(++index<length){offsets[line]=(offsets[line]||0)+lines[index].length-trimmedLines[index].length;line++}return trimmedLines.join(C_NEWLINE);function replacer($0,$1,$2,$3,$4){bullet=$1+$2+$3;rest=$4;if(Number($2)<10&&bullet.length%2===1){$2=C_SPACE+$2}max=$1+repeat(C_SPACE,$2.length)+$3;return max+rest}}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(112);var repeat=__webpack_require__(123);var getIndent=__webpack_require__(138);module.exports=indentation;var C_SPACE=" ";var C_NEWLINE="\n";var C_TAB="\t";function indentation(value,maximum){var values=value.split(C_NEWLINE);var position=values.length+1;var minIndent=Infinity;var matrix=[];var index;var indentation;var stops;var padding;values.unshift(repeat(C_SPACE,maximum)+"!");while(position--){indentation=getIndent(values[position]);matrix[position]=indentation.stops;if(trim(values[position]).length===0){continue}if(indentation.indent){if(indentation.indent>0&&indentation.indent<minIndent){minIndent=indentation.indent}}else{minIndent=Infinity;break}}if(minIndent!==Infinity){position=values.length;while(position--){stops=matrix[position];index=minIndent;while(index&&!(index in stops)){index--}if(trim(values[position]).length!==0&&minIndent&&index!==minIndent){padding=C_TAB}else{padding=""}values[position]=padding+values[position].slice(index in stops?stops[index]+1:0)}}values.shift();return values.join(C_NEWLINE)}},function(module,exports,__webpack_require__){"use strict";module.exports=setextHeading;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_EQUALS="=";var C_DASH="-";var MAX_HEADING_INDENT=3;var SETEXT_MARKERS={};SETEXT_MARKERS[C_EQUALS]=1;SETEXT_MARKERS[C_DASH]=2;function setextHeading(eat,value,silent){var self=this;var now=eat.now();var length=value.length;var index=-1;var subvalue="";var content;var queue;var character;var marker;var depth;while(++index<length){character=value.charAt(index);if(character!==C_SPACE||index>=MAX_HEADING_INDENT){index--;break}subvalue+=character}content="";queue="";while(++index<length){character=value.charAt(index);if(character===C_NEWLINE){index--;break}if(character===C_SPACE||character===C_TAB){queue+=character}else{content+=queue+character;queue=""}}now.column+=subvalue.length;now.offset+=subvalue.length;subvalue+=content+queue;character=value.charAt(++index);marker=value.charAt(++index);if(character!==C_NEWLINE||!SETEXT_MARKERS[marker]){return}subvalue+=character;queue=marker;depth=SETEXT_MARKERS[marker];while(++index<length){character=value.charAt(index);if(character!==marker){if(character!==C_NEWLINE){return}index--;break}queue+=character}if(silent){return true}return eat(subvalue+queue)({type:"heading",depth:depth,children:self.tokenizeInline(content,now)})}},function(module,exports,__webpack_require__){"use strict";var openCloseTag=__webpack_require__(139).openCloseTag;module.exports=blockHTML;var C_TAB="\t";var C_SPACE=" ";var C_NEWLINE="\n";var C_LT="<";function blockHTML(eat,value,silent){var self=this;var blocks=self.options.blocks;var length=value.length;var index=0;var next;var line;var offset;var character;var count;var sequence;var subvalue;var sequences=[[/^<(script|pre|style)(?=(\s|>|$))/i,/<\/(script|pre|style)>/i,true],[/^<!--/,/-->/,true],[/^<\?/,/\?>/,true],[/^<![A-Za-z]/,/>/,true],[/^<!\[CDATA\[/,/\]\]>/,true],[new RegExp("^</?("+blocks.join("|")+")(?=(\\s|/?>|$))","i"),/^$/,true],[new RegExp(openCloseTag.source+"\\s*$"),/^$/,false]];while(index<length){character=value.charAt(index);if(character!==C_TAB&&character!==C_SPACE){break}index++}if(value.charAt(index)!==C_LT){return}next=value.indexOf(C_NEWLINE,index+1);next=next===-1?length:next;line=value.slice(index,next);offset=-1;count=sequences.length;while(++offset<count){if(sequences[offset][0].test(line)){sequence=sequences[offset];break}}if(!sequence){return}if(silent){return sequence[2]}index=next;if(!sequence[1].test(line)){while(index<length){next=value.indexOf(C_NEWLINE,index+1);next=next===-1?length:next;line=value.slice(index+1,next);if(sequence[1].test(line)){if(line){index=next}break}index=next}}subvalue=value.slice(0,index);return eat(subvalue)({type:"html",value:subvalue})}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var normalize=__webpack_require__(126);module.exports=footnoteDefinition;footnoteDefinition.notInList=true;footnoteDefinition.notInBlock=true;var C_BACKSLASH="\\";var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_BRACKET_OPEN="[";var C_BRACKET_CLOSE="]";var C_CARET="^";var C_COLON=":";var EXPRESSION_INITIAL_TAB=/^( {4}|\t)?/gm;function footnoteDefinition(eat,value,silent){var self=this;var offsets=self.offset;var index;var length;var subvalue;var now;var currentLine;var content;var queue;var subqueue;var character;var identifier;var add;var exit;if(!self.options.footnotes){return}index=0;length=value.length;subvalue="";now=eat.now();currentLine=now.line;while(index<length){character=value.charAt(index);if(!whitespace(character)){break}subvalue+=character;index++}if(value.charAt(index)!==C_BRACKET_OPEN||value.charAt(index+1)!==C_CARET){return}subvalue+=C_BRACKET_OPEN+C_CARET;index=subvalue.length;queue="";while(index<length){character=value.charAt(index);if(character===C_BRACKET_CLOSE){break}else if(character===C_BACKSLASH){queue+=character;index++;character=value.charAt(index)}queue+=character;index++}if(!queue||value.charAt(index)!==C_BRACKET_CLOSE||value.charAt(index+1)!==C_COLON){return}if(silent){return true}identifier=normalize(queue);subvalue+=queue+C_BRACKET_CLOSE+C_COLON;index=subvalue.length;while(index<length){character=value.charAt(index);if(character!==C_TAB&&character!==C_SPACE){break}subvalue+=character;index++}now.column+=subvalue.length;now.offset+=subvalue.length;queue="";content="";subqueue="";while(index<length){character=value.charAt(index);if(character===C_NEWLINE){subqueue=character;index++;while(index<length){character=value.charAt(index);if(character!==C_NEWLINE){break}subqueue+=character;index++}queue+=subqueue;subqueue="";while(index<length){character=value.charAt(index);if(character!==C_SPACE){break}subqueue+=character;index++}if(subqueue.length===0){break}queue+=subqueue}if(queue){content+=queue;queue=""}content+=character;index++}subvalue+=content;content=content.replace(EXPRESSION_INITIAL_TAB,(function(line){offsets[currentLine]=(offsets[currentLine]||0)+line.length;currentLine++;return""}));add=eat(subvalue);exit=self.enterBlock();content=self.tokenizeBlock(content,now);exit();return add({type:"footnoteDefinition",identifier:identifier,children:content})}},function(module,exports,__webpack_require__){"use strict";module.exports=collapse;function collapse(value){return String(value).replace(/\s+/g," ")}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var normalize=__webpack_require__(126);module.exports=definition;definition.notInList=true;definition.notInBlock=true;var C_DOUBLE_QUOTE='"';var C_SINGLE_QUOTE="'";var C_BACKSLASH="\\";var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var C_BRACKET_OPEN="[";var C_BRACKET_CLOSE="]";var C_PAREN_OPEN="(";var C_PAREN_CLOSE=")";var C_COLON=":";var C_LT="<";var C_GT=">";function definition(eat,value,silent){var self=this;var commonmark=self.options.commonmark;var index=0;var length=value.length;var subvalue="";var beforeURL;var beforeTitle;var queue;var character;var test;var identifier;var url;var title;while(index<length){character=value.charAt(index);if(character!==C_SPACE&&character!==C_TAB){break}subvalue+=character;index++}character=value.charAt(index);if(character!==C_BRACKET_OPEN){return}index++;subvalue+=character;queue="";while(index<length){character=value.charAt(index);if(character===C_BRACKET_CLOSE){break}else if(character===C_BACKSLASH){queue+=character;index++;character=value.charAt(index)}queue+=character;index++}if(!queue||value.charAt(index)!==C_BRACKET_CLOSE||value.charAt(index+1)!==C_COLON){return}identifier=queue;subvalue+=queue+C_BRACKET_CLOSE+C_COLON;index=subvalue.length;queue="";while(index<length){character=value.charAt(index);if(character!==C_TAB&&character!==C_SPACE&&character!==C_NEWLINE){break}subvalue+=character;index++}character=value.charAt(index);queue="";beforeURL=subvalue;if(character===C_LT){index++;while(index<length){character=value.charAt(index);if(!isEnclosedURLCharacter(character)){break}queue+=character;index++}character=value.charAt(index);if(character===isEnclosedURLCharacter.delimiter){subvalue+=C_LT+queue+character;index++}else{if(commonmark){return}index-=queue.length+1;queue=""}}if(!queue){while(index<length){character=value.charAt(index);if(!isUnclosedURLCharacter(character)){break}queue+=character;index++}subvalue+=queue}if(!queue){return}url=queue;queue="";while(index<length){character=value.charAt(index);if(character!==C_TAB&&character!==C_SPACE&&character!==C_NEWLINE){break}queue+=character;index++}character=value.charAt(index);test=null;if(character===C_DOUBLE_QUOTE){test=C_DOUBLE_QUOTE}else if(character===C_SINGLE_QUOTE){test=C_SINGLE_QUOTE}else if(character===C_PAREN_OPEN){test=C_PAREN_CLOSE}if(!test){queue="";index=subvalue.length}else if(queue){subvalue+=queue+character;index=subvalue.length;queue="";while(index<length){character=value.charAt(index);if(character===test){break}if(character===C_NEWLINE){index++;character=value.charAt(index);if(character===C_NEWLINE||character===test){return}queue+=C_NEWLINE}queue+=character;index++}character=value.charAt(index);if(character!==test){return}beforeTitle=subvalue;subvalue+=queue+character;index++;title=queue;queue=""}else{return}while(index<length){character=value.charAt(index);if(character!==C_TAB&&character!==C_SPACE){break}subvalue+=character;index++}character=value.charAt(index);if(!character||character===C_NEWLINE){if(silent){return true}beforeURL=eat(beforeURL).test().end;url=self.decode.raw(self.unescape(url),beforeURL,{nonTerminated:false});if(title){beforeTitle=eat(beforeTitle).test().end;title=self.decode.raw(self.unescape(title),beforeTitle)}return eat(subvalue)({type:"definition",identifier:normalize(identifier),title:title||null,url:url})}}function isEnclosedURLCharacter(character){return character!==C_GT&&character!==C_BRACKET_OPEN&&character!==C_BRACKET_CLOSE}isEnclosedURLCharacter.delimiter=C_GT;function isUnclosedURLCharacter(character){return character!==C_BRACKET_OPEN&&character!==C_BRACKET_CLOSE&&!whitespace(character)}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);module.exports=table;var C_BACKSLASH="\\";var C_TICK="`";var C_DASH="-";var C_PIPE="|";var C_COLON=":";var C_SPACE=" ";var C_NEWLINE="\n";var C_TAB="\t";var MIN_TABLE_COLUMNS=1;var MIN_TABLE_ROWS=2;var TABLE_ALIGN_LEFT="left";var TABLE_ALIGN_CENTER="center";var TABLE_ALIGN_RIGHT="right";var TABLE_ALIGN_NONE=null;function table(eat,value,silent){var self=this;var index;var alignments;var alignment;var subvalue;var row;var length;var lines;var queue;var character;var hasDash;var align;var cell;var preamble;var count;var opening;var now;var position;var lineCount;var line;var rows;var table;var lineIndex;var pipeIndex;var first;if(!self.options.gfm){return}index=0;lineCount=0;length=value.length+1;lines=[];while(index<length){lineIndex=value.indexOf(C_NEWLINE,index);pipeIndex=value.indexOf(C_PIPE,index+1);if(lineIndex===-1){lineIndex=value.length}if(pipeIndex===-1||pipeIndex>lineIndex){if(lineCount<MIN_TABLE_ROWS){return}break}lines.push(value.slice(index,lineIndex));lineCount++;index=lineIndex+1}subvalue=lines.join(C_NEWLINE);alignments=lines.splice(1,1)[0]||[];index=0;length=alignments.length;lineCount--;alignment=false;align=[];while(index<length){character=alignments.charAt(index);if(character===C_PIPE){hasDash=null;if(alignment===false){if(first===false){return}}else{align.push(alignment);alignment=false}first=false}else if(character===C_DASH){hasDash=true;alignment=alignment||TABLE_ALIGN_NONE}else if(character===C_COLON){if(alignment===TABLE_ALIGN_LEFT){alignment=TABLE_ALIGN_CENTER}else if(hasDash&&alignment===TABLE_ALIGN_NONE){alignment=TABLE_ALIGN_RIGHT}else{alignment=TABLE_ALIGN_LEFT}}else if(!whitespace(character)){return}index++}if(alignment!==false){align.push(alignment)}if(align.length<MIN_TABLE_COLUMNS){return}if(silent){return true}position=-1;rows=[];table=eat(subvalue).reset({type:"table",align:align,children:rows});while(++position<lineCount){line=lines[position];row={type:"tableRow",children:[]};if(position){eat(C_NEWLINE)}eat(line).reset(row,table);length=line.length+1;index=0;queue="";cell="";preamble=true;count=null;opening=null;while(index<length){character=line.charAt(index);if(character===C_TAB||character===C_SPACE){if(cell){queue+=character}else{eat(character)}index++;continue}if(character===""||character===C_PIPE){if(preamble){eat(character)}else{if(character&&opening){queue+=character;index++;continue}if((cell||character)&&!preamble){subvalue=cell;if(queue.length>1){if(character){subvalue+=queue.slice(0,queue.length-1);queue=queue.charAt(queue.length-1)}else{subvalue+=queue;queue=""}}now=eat.now();eat(subvalue)({type:"tableCell",children:self.tokenizeInline(cell,now)},row)}eat(queue+character);queue="";cell=""}}else{if(queue){cell+=queue;queue=""}cell+=character;if(character===C_BACKSLASH&&index!==length-2){cell+=line.charAt(index+1);index++}if(character===C_TICK){count=1;while(line.charAt(index+1)===character){cell+=character;index++;count++}if(!opening){opening=count}else if(count>=opening){opening=0}}}preamble=false;index++}if(!position){eat(C_NEWLINE+alignments)}}return table}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(112);var decimal=__webpack_require__(114);var trimTrailingLines=__webpack_require__(124);var interrupt=__webpack_require__(125);module.exports=paragraph;var C_NEWLINE="\n";var C_TAB="\t";var C_SPACE=" ";var TAB_SIZE=4;function paragraph(eat,value,silent){var self=this;var settings=self.options;var commonmark=settings.commonmark;var gfm=settings.gfm;var tokenizers=self.blockTokenizers;var interruptors=self.interruptParagraph;var index=value.indexOf(C_NEWLINE);var length=value.length;var position;var subvalue;var character;var size;var now;while(index<length){if(index===-1){index=length;break}if(value.charAt(index+1)===C_NEWLINE){break}if(commonmark){size=0;position=index+1;while(position<length){character=value.charAt(position);if(character===C_TAB){size=TAB_SIZE;break}else if(character===C_SPACE){size++}else{break}position++}if(size>=TAB_SIZE){index=value.indexOf(C_NEWLINE,index+1);continue}}subvalue=value.slice(index+1);if(interrupt(interruptors,tokenizers,self,[eat,subvalue,true])){break}if(tokenizers.list.call(self,eat,subvalue,true)&&(self.inList||commonmark||gfm&&!decimal(trim.left(subvalue).charAt(0)))){break}position=index;index=value.indexOf(C_NEWLINE,index+1);if(index!==-1&&trim(value.slice(position,index))===""){index=position;break}}subvalue=value.slice(0,index);if(trim(subvalue)===""){eat(subvalue);return null}if(silent){return true}now=eat.now();subvalue=trimTrailingLines(subvalue);return eat(subvalue)({type:"paragraph",children:self.tokenizeInline(subvalue,now)})}},function(module,exports,__webpack_require__){"use strict";var locate=__webpack_require__(228);module.exports=escape;escape.locator=locate;function escape(eat,value,silent){var self=this;var character;var node;if(value.charAt(0)==="\\"){character=value.charAt(1);if(self.escape.indexOf(character)!==-1){if(silent){return true}if(character==="\n"){node={type:"break"}}else{node={type:"text",value:character}}return eat("\\"+character)(node)}}}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){return value.indexOf("\\",fromIndex)}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var decode=__webpack_require__(122);var locate=__webpack_require__(140);module.exports=autoLink;autoLink.locator=locate;autoLink.notInLink=true;var C_LT="<";var C_GT=">";var C_AT_SIGN="@";var C_SLASH="/";var MAILTO="mailto:";var MAILTO_LENGTH=MAILTO.length;function autoLink(eat,value,silent){var self;var subvalue;var length;var index;var queue;var character;var hasAtCharacter;var link;var now;var content;var tokenizers;var exit;if(value.charAt(0)!==C_LT){return}self=this;subvalue="";length=value.length;index=0;queue="";hasAtCharacter=false;link="";index++;subvalue=C_LT;while(index<length){character=value.charAt(index);if(whitespace(character)||character===C_GT||character===C_AT_SIGN||character===":"&&value.charAt(index+1)===C_SLASH){break}queue+=character;index++}if(!queue){return}link+=queue;queue="";character=value.charAt(index);link+=character;index++;if(character===C_AT_SIGN){hasAtCharacter=true}else{if(character!==":"||value.charAt(index+1)!==C_SLASH){return}link+=C_SLASH;index++}while(index<length){character=value.charAt(index);if(whitespace(character)||character===C_GT){break}queue+=character;index++}character=value.charAt(index);if(!queue||character!==C_GT){return}if(silent){return true}link+=queue;content=link;subvalue+=link+character;now=eat.now();now.column++;now.offset++;if(hasAtCharacter){if(link.slice(0,MAILTO_LENGTH).toLowerCase()===MAILTO){content=content.substr(MAILTO_LENGTH);now.column+=MAILTO_LENGTH;now.offset+=MAILTO_LENGTH}else{link=MAILTO+link}}tokenizers=self.inlineTokenizers;self.inlineTokenizers={text:tokenizers.text};exit=self.enterLink();content=self.tokenizeInline(content,now);self.inlineTokenizers=tokenizers;exit();return eat(subvalue)({type:"link",title:null,url:decode(link,{nonTerminated:false}),children:content})}},function(module,exports,__webpack_require__){"use strict";var decode=__webpack_require__(122);var whitespace=__webpack_require__(108);var locate=__webpack_require__(231);module.exports=url;url.locator=locate;url.notInLink=true;var C_BRACKET_OPEN="[";var C_BRACKET_CLOSE="]";var C_PAREN_OPEN="(";var C_PAREN_CLOSE=")";var C_LT="<";var C_AT_SIGN="@";var HTTP_PROTOCOL="http://";var HTTPS_PROTOCOL="https://";var MAILTO_PROTOCOL="mailto:";var PROTOCOLS=[HTTP_PROTOCOL,HTTPS_PROTOCOL,MAILTO_PROTOCOL];var PROTOCOLS_LENGTH=PROTOCOLS.length;function url(eat,value,silent){var self=this;var subvalue;var content;var character;var index;var position;var protocol;var match;var length;var queue;var parenCount;var nextCharacter;var exit;if(!self.options.gfm){return}subvalue="";index=-1;length=PROTOCOLS_LENGTH;while(++index<length){protocol=PROTOCOLS[index];match=value.slice(0,protocol.length);if(match.toLowerCase()===protocol){subvalue=match;break}}if(!subvalue){return}index=subvalue.length;length=value.length;queue="";parenCount=0;while(index<length){character=value.charAt(index);if(whitespace(character)||character===C_LT){break}if(character==="."||character===","||character===":"||character===";"||character==='"'||character==="'"||character===")"||character==="]"){nextCharacter=value.charAt(index+1);if(!nextCharacter||whitespace(nextCharacter)){break}}if(character===C_PAREN_OPEN||character===C_BRACKET_OPEN){parenCount++}if(character===C_PAREN_CLOSE||character===C_BRACKET_CLOSE){parenCount--;if(parenCount<0){break}}queue+=character;index++}if(!queue){return}subvalue+=queue;content=subvalue;if(protocol===MAILTO_PROTOCOL){position=queue.indexOf(C_AT_SIGN);if(position===-1||position===length-1){return}content=content.substr(MAILTO_PROTOCOL.length)}if(silent){return true}exit=self.enterLink();content=self.tokenizeInline(content,eat.now());exit();return eat(subvalue)({type:"link",title:null,url:decode(subvalue,{nonTerminated:false}),children:content})}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;var PROTOCOLS=["https://","http://","mailto:"];function locate(value,fromIndex){var length=PROTOCOLS.length;var index=-1;var min=-1;var position;if(!this.options.gfm){return-1}while(++index<length){position=value.indexOf(PROTOCOLS[index],fromIndex);if(position!==-1&&(position<min||min===-1)){min=position}}return min}},function(module,exports,__webpack_require__){"use strict";var alphabetical=__webpack_require__(136);var locate=__webpack_require__(140);var tag=__webpack_require__(139).tag;module.exports=inlineHTML;inlineHTML.locator=locate;var EXPRESSION_HTML_LINK_OPEN=/^<a /i;var EXPRESSION_HTML_LINK_CLOSE=/^<\/a>/i;function inlineHTML(eat,value,silent){var self=this;var length=value.length;var character;var subvalue;if(value.charAt(0)!=="<"||length<3){return}character=value.charAt(1);if(!alphabetical(character)&&character!=="?"&&character!=="!"&&character!=="/"){return}subvalue=value.match(tag);if(!subvalue){return}if(silent){return true}subvalue=subvalue[0];if(!self.inLink&&EXPRESSION_HTML_LINK_OPEN.test(subvalue)){self.inLink=true}else if(self.inLink&&EXPRESSION_HTML_LINK_CLOSE.test(subvalue)){self.inLink=false}return eat(subvalue)({type:"html",value:subvalue})}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var locate=__webpack_require__(141);module.exports=link;link.locator=locate;var own={}.hasOwnProperty;var C_BACKSLASH="\\";var C_BRACKET_OPEN="[";var C_BRACKET_CLOSE="]";var C_PAREN_OPEN="(";var C_PAREN_CLOSE=")";var C_LT="<";var C_GT=">";var C_TICK="`";var C_DOUBLE_QUOTE='"';var C_SINGLE_QUOTE="'";var LINK_MARKERS={};LINK_MARKERS[C_DOUBLE_QUOTE]=C_DOUBLE_QUOTE;LINK_MARKERS[C_SINGLE_QUOTE]=C_SINGLE_QUOTE;var COMMONMARK_LINK_MARKERS={};COMMONMARK_LINK_MARKERS[C_DOUBLE_QUOTE]=C_DOUBLE_QUOTE;COMMONMARK_LINK_MARKERS[C_SINGLE_QUOTE]=C_SINGLE_QUOTE;COMMONMARK_LINK_MARKERS[C_PAREN_OPEN]=C_PAREN_CLOSE;function link(eat,value,silent){var self=this;var subvalue="";var index=0;var character=value.charAt(0);var pedantic=self.options.pedantic;var commonmark=self.options.commonmark;var gfm=self.options.gfm;var closed;var count;var opening;var beforeURL;var beforeTitle;var subqueue;var hasMarker;var markers;var isImage;var content;var marker;var length;var title;var depth;var queue;var url;var now;var exit;var node;if(character==="!"){isImage=true;subvalue=character;character=value.charAt(++index)}if(character!==C_BRACKET_OPEN){return}if(!isImage&&self.inLink){return}subvalue+=character;queue="";index++;length=value.length;now=eat.now();depth=0;now.column+=index;now.offset+=index;while(index<length){character=value.charAt(index);subqueue=character;if(character===C_TICK){count=1;while(value.charAt(index+1)===C_TICK){subqueue+=character;index++;count++}if(!opening){opening=count}else if(count>=opening){opening=0}}else if(character===C_BACKSLASH){index++;subqueue+=value.charAt(index)}else if((!opening||gfm)&&character===C_BRACKET_OPEN){depth++}else if((!opening||gfm)&&character===C_BRACKET_CLOSE){if(depth){depth--}else{if(!pedantic){while(index<length){character=value.charAt(index+1);if(!whitespace(character)){break}subqueue+=character;index++}}if(value.charAt(index+1)!==C_PAREN_OPEN){return}subqueue+=C_PAREN_OPEN;closed=true;index++;break}}queue+=subqueue;subqueue="";index++}if(!closed){return}content=queue;subvalue+=queue+subqueue;index++;while(index<length){character=value.charAt(index);if(!whitespace(character)){break}subvalue+=character;index++}character=value.charAt(index);markers=commonmark?COMMONMARK_LINK_MARKERS:LINK_MARKERS;queue="";beforeURL=subvalue;if(character===C_LT){index++;beforeURL+=C_LT;while(index<length){character=value.charAt(index);if(character===C_GT){break}if(commonmark&&character==="\n"){return}queue+=character;index++}if(value.charAt(index)!==C_GT){return}subvalue+=C_LT+queue+C_GT;url=queue;index++}else{character=null;subqueue="";while(index<length){character=value.charAt(index);if(subqueue&&own.call(markers,character)){break}if(whitespace(character)){if(!pedantic){break}subqueue+=character}else{if(character===C_PAREN_OPEN){depth++}else if(character===C_PAREN_CLOSE){if(depth===0){break}depth--}queue+=subqueue;subqueue="";if(character===C_BACKSLASH){queue+=C_BACKSLASH;character=value.charAt(++index)}queue+=character}index++}subvalue+=queue;url=queue;index=subvalue.length}queue="";while(index<length){character=value.charAt(index);if(!whitespace(character)){break}queue+=character;index++}character=value.charAt(index);subvalue+=queue;if(queue&&own.call(markers,character)){index++;subvalue+=character;queue="";marker=markers[character];beforeTitle=subvalue;if(commonmark){while(index<length){character=value.charAt(index);if(character===marker){break}if(character===C_BACKSLASH){queue+=C_BACKSLASH;character=value.charAt(++index)}index++;queue+=character}character=value.charAt(index);if(character!==marker){return}title=queue;subvalue+=queue+character;index++;while(index<length){character=value.charAt(index);if(!whitespace(character)){break}subvalue+=character;index++}}else{subqueue="";while(index<length){character=value.charAt(index);if(character===marker){if(hasMarker){queue+=marker+subqueue;subqueue=""}hasMarker=true}else if(!hasMarker){queue+=character}else if(character===C_PAREN_CLOSE){subvalue+=queue+marker+subqueue;title=queue;break}else if(whitespace(character)){subqueue+=character}else{queue+=marker+subqueue+character;subqueue="";hasMarker=false}index++}}}if(value.charAt(index)!==C_PAREN_CLOSE){return}if(silent){return true}subvalue+=C_PAREN_CLOSE;url=self.decode.raw(self.unescape(url),eat(beforeURL).test().end,{nonTerminated:false});if(title){beforeTitle=eat(beforeTitle).test().end;title=self.decode.raw(self.unescape(title),beforeTitle)}node={type:isImage?"image":"link",title:title||null,url:url};if(isImage){node.alt=self.decode.raw(self.unescape(content),now)||null}else{exit=self.enterLink();node.children=self.tokenizeInline(content,now);exit()}return eat(subvalue)(node)}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var locate=__webpack_require__(141);var normalize=__webpack_require__(126);module.exports=reference;reference.locator=locate;var T_LINK="link";var T_IMAGE="image";var T_FOOTNOTE="footnote";var REFERENCE_TYPE_SHORTCUT="shortcut";var REFERENCE_TYPE_COLLAPSED="collapsed";var REFERENCE_TYPE_FULL="full";var C_CARET="^";var C_BACKSLASH="\\";var C_BRACKET_OPEN="[";var C_BRACKET_CLOSE="]";function reference(eat,value,silent){var self=this;var character=value.charAt(0);var index=0;var length=value.length;var subvalue="";var intro="";var type=T_LINK;var referenceType=REFERENCE_TYPE_SHORTCUT;var content;var identifier;var now;var node;var exit;var queue;var bracketed;var depth;if(character==="!"){type=T_IMAGE;intro=character;character=value.charAt(++index)}if(character!==C_BRACKET_OPEN){return}index++;intro+=character;queue="";if(self.options.footnotes&&value.charAt(index)===C_CARET){if(type===T_IMAGE){return}intro+=C_CARET;index++;type=T_FOOTNOTE}depth=0;while(index<length){character=value.charAt(index);if(character===C_BRACKET_OPEN){bracketed=true;depth++}else if(character===C_BRACKET_CLOSE){if(!depth){break}depth--}if(character===C_BACKSLASH){queue+=C_BACKSLASH;character=value.charAt(++index)}queue+=character;index++}subvalue=queue;content=queue;character=value.charAt(index);if(character!==C_BRACKET_CLOSE){return}index++;subvalue+=character;queue="";while(index<length){character=value.charAt(index);if(!whitespace(character)){break}queue+=character;index++}character=value.charAt(index);if(type!==T_FOOTNOTE&&character===C_BRACKET_OPEN){identifier="";queue+=character;index++;while(index<length){character=value.charAt(index);if(character===C_BRACKET_OPEN||character===C_BRACKET_CLOSE){break}if(character===C_BACKSLASH){identifier+=C_BACKSLASH;character=value.charAt(++index)}identifier+=character;index++}character=value.charAt(index);if(character===C_BRACKET_CLOSE){referenceType=identifier?REFERENCE_TYPE_FULL:REFERENCE_TYPE_COLLAPSED;queue+=identifier+character;index++}else{identifier=""}subvalue+=queue;queue=""}else{if(!content){return}identifier=content}if(referenceType!==REFERENCE_TYPE_FULL&&bracketed){return}subvalue=intro+subvalue;if(type===T_LINK&&self.inLink){return null}if(silent){return true}if(type===T_FOOTNOTE&&content.indexOf(" ")!==-1){return eat(subvalue)({type:"footnote",children:this.tokenizeInline(content,eat.now())})}now=eat.now();now.column+=intro.length;now.offset+=intro.length;identifier=referenceType===REFERENCE_TYPE_FULL?identifier:content;node={type:type+"Reference",identifier:normalize(identifier)};if(type===T_LINK||type===T_IMAGE){node.referenceType=referenceType}if(type===T_LINK){exit=self.enterLink();node.children=self.tokenizeInline(content,now);exit()}else if(type===T_IMAGE){node.alt=self.decode.raw(self.unescape(content),now)||null}return eat(subvalue)(node)}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(112);var whitespace=__webpack_require__(108);var locate=__webpack_require__(236);module.exports=strong;strong.locator=locate;var C_ASTERISK="*";var C_UNDERSCORE="_";function strong(eat,value,silent){var self=this;var index=0;var character=value.charAt(index);var now;var pedantic;var marker;var queue;var subvalue;var length;var prev;if(character!==C_ASTERISK&&character!==C_UNDERSCORE||value.charAt(++index)!==character){return}pedantic=self.options.pedantic;marker=character;subvalue=marker+marker;length=value.length;index++;queue="";character="";if(pedantic&&whitespace(value.charAt(index))){return}while(index<length){prev=character;character=value.charAt(index);if(character===marker&&value.charAt(index+1)===marker&&(!pedantic||!whitespace(prev))){character=value.charAt(index+2);if(character!==marker){if(!trim(queue)){return}if(silent){return true}now=eat.now();now.column+=2;now.offset+=2;return eat(subvalue+queue+subvalue)({type:"strong",children:self.tokenizeInline(queue,now)})}}if(!pedantic&&character==="\\"){queue+=character;character=value.charAt(++index)}queue+=character;index++}}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){var asterisk=value.indexOf("**",fromIndex);var underscore=value.indexOf("__",fromIndex);if(underscore===-1){return asterisk}if(asterisk===-1){return underscore}return underscore<asterisk?underscore:asterisk}},function(module,exports,__webpack_require__){"use strict";var trim=__webpack_require__(112);var word=__webpack_require__(238);var whitespace=__webpack_require__(108);var locate=__webpack_require__(239);module.exports=emphasis;emphasis.locator=locate;var C_ASTERISK="*";var C_UNDERSCORE="_";function emphasis(eat,value,silent){var self=this;var index=0;var character=value.charAt(index);var now;var pedantic;var marker;var queue;var subvalue;var length;var prev;if(character!==C_ASTERISK&&character!==C_UNDERSCORE){return}pedantic=self.options.pedantic;subvalue=character;marker=character;length=value.length;index++;queue="";character="";if(pedantic&&whitespace(value.charAt(index))){return}while(index<length){prev=character;character=value.charAt(index);if(character===marker&&(!pedantic||!whitespace(prev))){character=value.charAt(++index);if(character!==marker){if(!trim(queue)||prev===marker){return}if(!pedantic&&marker===C_UNDERSCORE&&word(character)){queue+=marker;continue}if(silent){return true}now=eat.now();now.column++;now.offset++;return eat(subvalue+queue+marker)({type:"emphasis",children:self.tokenizeInline(queue,now)})}queue+=marker}if(!pedantic&&character==="\\"){queue+=character;character=value.charAt(++index)}queue+=character;index++}}},function(module,exports,__webpack_require__){"use strict";module.exports=wordCharacter;var fromCode=String.fromCharCode;var re=/\w/;function wordCharacter(character){return re.test(typeof character==="number"?fromCode(character):character.charAt(0))}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){var asterisk=value.indexOf("*",fromIndex);var underscore=value.indexOf("_",fromIndex);if(underscore===-1){return asterisk}if(asterisk===-1){return underscore}return underscore<asterisk?underscore:asterisk}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var locate=__webpack_require__(241);module.exports=strikethrough;strikethrough.locator=locate;var C_TILDE="~";var DOUBLE="~~";function strikethrough(eat,value,silent){var self=this;var character="";var previous="";var preceding="";var subvalue="";var index;var length;var now;if(!self.options.gfm||value.charAt(0)!==C_TILDE||value.charAt(1)!==C_TILDE||whitespace(value.charAt(2))){return}index=1;length=value.length;now=eat.now();now.column+=2;now.offset+=2;while(++index<length){character=value.charAt(index);if(character===C_TILDE&&previous===C_TILDE&&(!preceding||!whitespace(preceding))){if(silent){return true}return eat(DOUBLE+subvalue+DOUBLE)({type:"delete",children:self.tokenizeInline(subvalue,now)})}subvalue+=previous;preceding=previous;previous=character}}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){return value.indexOf("~~",fromIndex)}},function(module,exports,__webpack_require__){"use strict";var whitespace=__webpack_require__(108);var locate=__webpack_require__(243);module.exports=inlineCode;inlineCode.locator=locate;var C_TICK="`";function inlineCode(eat,value,silent){var length=value.length;var index=0;var queue="";var tickQueue="";var contentQueue;var subqueue;var count;var openingCount;var subvalue;var character;var found;var next;while(index<length){if(value.charAt(index)!==C_TICK){break}queue+=C_TICK;index++}if(!queue){return}subvalue=queue;openingCount=index;queue="";next=value.charAt(index);count=0;while(index<length){character=next;next=value.charAt(index+1);if(character===C_TICK){count++;tickQueue+=character}else{count=0;queue+=character}if(count&&next!==C_TICK){if(count===openingCount){subvalue+=queue+tickQueue;found=true;break}queue+=tickQueue;tickQueue=""}index++}if(!found){if(openingCount%2!==0){return}queue=""}if(silent){return true}contentQueue="";subqueue="";length=queue.length;index=-1;while(++index<length){character=queue.charAt(index);if(whitespace(character)){subqueue+=character;continue}if(subqueue){if(contentQueue){contentQueue+=subqueue}subqueue=""}contentQueue+=character}return eat(subvalue)({type:"inlineCode",value:contentQueue})}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){return value.indexOf("`",fromIndex)}},function(module,exports,__webpack_require__){"use strict";var locate=__webpack_require__(245);module.exports=hardBreak;hardBreak.locator=locate;var MIN_BREAK_LENGTH=2;function hardBreak(eat,value,silent){var length=value.length;var index=-1;var queue="";var character;while(++index<length){character=value.charAt(index);if(character==="\n"){if(index<MIN_BREAK_LENGTH){return}if(silent){return true}queue+=character;return eat(queue)({type:"break"})}if(character!==" "){return}queue+=character}}},function(module,exports,__webpack_require__){"use strict";module.exports=locate;function locate(value,fromIndex){var index=value.indexOf("\n",fromIndex);while(index>fromIndex){if(value.charAt(index-1)!==" "){break}index--}return index}},function(module,exports,__webpack_require__){"use strict";module.exports=text;function text(eat,value,silent){var self=this;var methods;var tokenizers;var index;var length;var subvalue;var position;var tokenizer;var name;var min;var now;if(silent){return true}methods=self.inlineMethods;length=methods.length;tokenizers=self.inlineTokenizers;index=-1;min=value.length;while(++index<length){name=methods[index];if(name==="text"||!tokenizers[name]){continue}tokenizer=tokenizers[name].locator;if(!tokenizer){eat.file.fail("Missing locator: `"+name+"`")}position=tokenizer.call(self,value,1);if(position!==-1&&position<min){min=position}}subvalue=value.slice(0,min);now=eat.now();self.decode(subvalue,now,(function(content,position,source){eat(source||content)({type:"text",value:content})}))}},function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(248)()}},function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret=__webpack_require__(249);function emptyFunction(){}function emptyFunctionWithReset(){}emptyFunctionWithReset.resetWarningCache=emptyFunction;module.exports=function(){function shim(props,propName,componentName,location,propFullName,secret){if(secret===ReactPropTypesSecret){return}var err=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use PropTypes.checkPropTypes() to call them. "+"Read more at http://fb.me/use-check-prop-types");err.name="Invariant Violation";throw err}shim.isRequired=shim;function getShim(){return shim}var ReactPropTypes={array:shim,bool:shim,func:shim,number:shim,object:shim,string:shim,symbol:shim,any:shim,arrayOf:getShim,element:shim,elementType:shim,instanceOf:getShim,node:shim,objectOf:getShim,oneOf:getShim,oneOfType:getShim,shape:getShim,exact:getShim,checkPropTypes:emptyFunctionWithReset,resetWarningCache:emptyFunction};ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}},function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},function(module,exports,__webpack_require__){var visitWithParents=__webpack_require__(251);function addListMetadata(){return function(ast){visitWithParents(ast,"list",(function(listNode,parents){var depth=0,i,n;for(i=0,n=parents.length;i<n;i++){if(parents[i].type==="list")depth+=1}for(i=0,n=listNode.children.length;i<n;i++){var child=listNode.children[i];child.index=i;child.ordered=listNode.ordered}listNode.depth=depth}));return ast}}module.exports=addListMetadata},function(module,exports,__webpack_require__){"use strict";module.exports=visitParents;function visitParents(tree,type,visitor){var stack=[];if(typeof type==="function"){visitor=type;type=null}one(tree);function one(node){var result;if(!type||node.type===type){result=visitor(node,stack.concat())}if(node.children&&result!==false){return all(node.children,node)}return result}function all(children,parent){var length=children.length;var index=-1;var child;stack.push(parent);while(++index<length){child=children[index];if(child&&one(child)===false){return false}}stack.pop();return true}}},function(module,exports,__webpack_require__){"use strict";var visit=__webpack_require__(115);var type="virtualHtml";var selfClosingRe=/^<(area|base|br|col|embed|hr|img|input|keygen|link|meta|param|source|track|wbr)\s*\/?>$/i;var simpleTagRe=/^<(\/?)([a-z]+)\s*>$/;module.exports=function(tree){var open;var currentParent;visit(tree,"html",(function(node,index,parent){if(currentParent!==parent){open=[];currentParent=parent}var selfClosing=getSelfClosing(node);if(selfClosing){parent.children.splice(index,1,{type:type,tag:selfClosing,position:node.position});return true}var current=getSimpleTag(node,parent);if(!current){return true}var matching=findAndPull(open,current.tag);if(matching){parent.children.splice(index,0,virtual(current,matching,parent))}else if(!current.opening){open.push(current)}return true}),true);return tree};function findAndPull(open,matchingTag){var i=open.length;while(i--){if(open[i].tag===matchingTag){return open.splice(i,1)[0]}}return false}function getSimpleTag(node,parent){var match=node.value.match(simpleTagRe);return match?{tag:match[2],opening:!match[1],node:node}:false}function getSelfClosing(node){var match=node.value.match(selfClosingRe);return match?match[1]:false}function virtual(fromNode,toNode,parent){var fromIndex=parent.children.indexOf(fromNode.node);var toIndex=parent.children.indexOf(toNode.node);var extracted=parent.children.splice(fromIndex,toIndex-fromIndex+1);var children=extracted.slice(1,-1);return{type:type,children:children,tag:fromNode.tag,position:{start:fromNode.node.position.start,end:toNode.node.position.end,indent:[]}}}},function(module,exports,__webpack_require__){"use strict";var visit=__webpack_require__(115);exports.ofType=function(types,mode){return function(node){types.forEach((function(type){return visit(node,type,disallow,true)}));return node};function disallow(node,index,parent){if(parent){untangle(node,index,parent,mode)}}};exports.ifNotMatch=function(allowNode,mode){return function(node){visit(node,disallow,true);return node};function disallow(node,index,parent){if(parent&&!allowNode(node,index,parent)){untangle(node,index,parent,mode)}}};function untangle(node,index,parent,mode){if(mode==="remove"){parent.children.splice(index,1)}else if(mode==="unwrap"){var args=[index,1];if(node.children){args=args.concat(node.children)}Array.prototype.splice.apply(parent.children,args)}}},function(module,exports,__webpack_require__){"use strict";var React=__webpack_require__(2);var xtend=__webpack_require__(110);var ReactIs=__webpack_require__(255);var defaultNodePosition={start:{line:1,column:1,offset:0},end:{line:1,column:1,offset:0}};function astToReact(node,options){var parent=arguments.length>2&&arguments[2]!==undefined?arguments[2]:{};var index=arguments.length>3&&arguments[3]!==undefined?arguments[3]:0;var renderer=options.renderers[node.type];if(node.position===undefined){node.position=parent.node&&parent.node.position||defaultNodePosition}var pos=node.position.start;var key=[node.type,pos.line,pos.column,index].join("-");if(!ReactIs.isValidElementType(renderer)){throw new Error("Renderer for type `".concat(node.type,"` not defined or is not renderable"))}var nodeProps=getNodeProps(node,key,options,renderer,parent,index);return React.createElement(renderer,nodeProps,nodeProps.children||resolveChildren()||undefined);function resolveChildren(){return node.children&&node.children.map((function(childNode,i){return astToReact(childNode,options,{node:node,props:nodeProps},i)}))}}function getNodeProps(node,key,opts,renderer,parent,index){var props={key:key};var isTagRenderer=typeof renderer==="string";if(opts.sourcePos&&node.position){props["data-sourcepos"]=flattenPosition(node.position)}if(opts.rawSourcePos&&!isTagRenderer){props.sourcePosition=node.position}if(opts.includeNodeIndex&&parent.node&&parent.node.children&&!isTagRenderer){props.index=parent.node.children.indexOf(node);props.parentChildCount=parent.node.children.length}var ref=node.identifier!==null&&node.identifier!==undefined?opts.definitions[node.identifier]||{}:null;switch(node.type){case"root":assignDefined(props,{className:opts.className});break;case"text":props.nodeKey=key;props.children=node.value;break;case"heading":props.level=node.depth;break;case"list":props.start=node.start;props.ordered=node.ordered;props.tight=!node.loose;props.depth=node.depth;break;case"listItem":props.checked=node.checked;props.tight=!node.loose;props.ordered=node.ordered;props.index=node.index;props.children=getListItemChildren(node,parent).map((function(childNode,i){return astToReact(childNode,opts,{node:node,props:props},i)}));break;case"definition":assignDefined(props,{identifier:node.identifier,title:node.title,url:node.url});break;case"code":assignDefined(props,{language:node.lang&&node.lang.split(/\s/,1)[0]});break;case"inlineCode":props.children=node.value;props.inline=true;break;case"link":assignDefined(props,{title:node.title||undefined,target:typeof opts.linkTarget==="function"?opts.linkTarget(node.url,node.children,node.title):opts.linkTarget,href:opts.transformLinkUri?opts.transformLinkUri(node.url,node.children,node.title):node.url});break;case"image":assignDefined(props,{alt:node.alt||undefined,title:node.title||undefined,src:opts.transformImageUri?opts.transformImageUri(node.url,node.children,node.title,node.alt):node.url});break;case"linkReference":assignDefined(props,xtend(ref,{href:opts.transformLinkUri?opts.transformLinkUri(ref.href):ref.href}));break;case"imageReference":assignDefined(props,{src:opts.transformImageUri&&ref.href?opts.transformImageUri(ref.href,node.children,ref.title,node.alt):ref.href,title:ref.title||undefined,alt:node.alt||undefined});break;case"table":case"tableHead":case"tableBody":props.columnAlignment=node.align;break;case"tableRow":props.isHeader=parent.node.type==="tableHead";props.columnAlignment=parent.props.columnAlignment;break;case"tableCell":assignDefined(props,{isHeader:parent.props.isHeader,align:parent.props.columnAlignment[index]});break;case"virtualHtml":props.tag=node.tag;break;case"html":props.isBlock=node.position.start.line!==node.position.end.line;props.escapeHtml=opts.escapeHtml;props.skipHtml=opts.skipHtml;break;case"parsedHtml":{var parsedChildren;if(node.children){parsedChildren=node.children.map((function(child,i){return astToReact(child,opts,{node:node,props:props},i)}))}props.escapeHtml=opts.escapeHtml;props.skipHtml=opts.skipHtml;props.element=mergeNodeChildren(node,parsedChildren);break}default:assignDefined(props,xtend(node,{type:undefined,position:undefined,children:undefined}))}if(!isTagRenderer&&node.value){props.value=node.value}return props}function assignDefined(target,attrs){for(var key in attrs){if(typeof attrs[key]!=="undefined"){target[key]=attrs[key]}}}function mergeNodeChildren(node,parsedChildren){var el=node.element;if(Array.isArray(el)){var Fragment=React.Fragment||"div";return React.createElement(Fragment,null,el)}if(el.props.children||parsedChildren){var children=React.Children.toArray(el.props.children).concat(parsedChildren);return React.cloneElement(el,null,children)}return React.cloneElement(el,null)}function flattenPosition(pos){return[pos.start.line,":",pos.start.column,"-",pos.end.line,":",pos.end.column].map(String).join("")}function getListItemChildren(node,parent){if(node.loose){return node.children}if(parent.node&&node.index>0&&parent.node.children[node.index-1].loose){return node.children}return unwrapParagraphs(node)}function unwrapParagraphs(node){return node.children.reduce((function(array,child){return array.concat(child.type==="paragraph"?child.children||[]:[child])}),[])}module.exports=astToReact},function(module,exports,__webpack_require__){"use strict";if(true){module.exports=__webpack_require__(256)}else{}},function(module,exports,__webpack_require__){"use strict";
/** @license React v16.13.1
 * react-is.production.min.js
 *
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */var b="function"===typeof Symbol&&Symbol.for,c=b?Symbol.for("react.element"):60103,d=b?Symbol.for("react.portal"):60106,e=b?Symbol.for("react.fragment"):60107,f=b?Symbol.for("react.strict_mode"):60108,g=b?Symbol.for("react.profiler"):60114,h=b?Symbol.for("react.provider"):60109,k=b?Symbol.for("react.context"):60110,l=b?Symbol.for("react.async_mode"):60111,m=b?Symbol.for("react.concurrent_mode"):60111,n=b?Symbol.for("react.forward_ref"):60112,p=b?Symbol.for("react.suspense"):60113,q=b?Symbol.for("react.suspense_list"):60120,r=b?Symbol.for("react.memo"):60115,t=b?Symbol.for("react.lazy"):60116,v=b?Symbol.for("react.block"):60121,w=b?Symbol.for("react.fundamental"):60117,x=b?Symbol.for("react.responder"):60118,y=b?Symbol.for("react.scope"):60119;function z(a){if("object"===typeof a&&null!==a){var u=a.$$typeof;switch(u){case c:switch(a=a.type,a){case l:case m:case e:case g:case f:case p:return a;default:switch(a=a&&a.$$typeof,a){case k:case n:case t:case r:case h:return a;default:return u}}case d:return u}}}function A(a){return z(a)===m}exports.AsyncMode=l;exports.ConcurrentMode=m;exports.ContextConsumer=k;exports.ContextProvider=h;exports.Element=c;exports.ForwardRef=n;exports.Fragment=e;exports.Lazy=t;exports.Memo=r;exports.Portal=d;exports.Profiler=g;exports.StrictMode=f;exports.Suspense=p;exports.isAsyncMode=function(a){return A(a)||z(a)===l};exports.isConcurrentMode=A;exports.isContextConsumer=function(a){return z(a)===k};exports.isContextProvider=function(a){return z(a)===h};exports.isElement=function(a){return"object"===typeof a&&null!==a&&a.$$typeof===c};exports.isForwardRef=function(a){return z(a)===n};exports.isFragment=function(a){return z(a)===e};exports.isLazy=function(a){return z(a)===t};exports.isMemo=function(a){return z(a)===r};exports.isPortal=function(a){return z(a)===d};exports.isProfiler=function(a){return z(a)===g};exports.isStrictMode=function(a){return z(a)===f};exports.isSuspense=function(a){return z(a)===p};exports.isValidElementType=function(a){return"string"===typeof a||"function"===typeof a||a===e||a===m||a===g||a===f||a===p||a===q||"object"===typeof a&&null!==a&&(a.$$typeof===t||a.$$typeof===r||a.$$typeof===h||a.$$typeof===k||a.$$typeof===n||a.$$typeof===w||a.$$typeof===x||a.$$typeof===y||a.$$typeof===v)};exports.typeOf=z},function(module,exports,__webpack_require__){"use strict";var visit=__webpack_require__(115);module.exports=function(node){visit(node,"table",wrap);return node};function wrap(table){var children=table.children;table.children=[{type:"tableHead",align:table.align,children:[children[0]],position:children[0].position}];if(children.length>1){table.children.push({type:"tableBody",align:table.align,children:children.slice(1),position:{start:children[1].position.start,end:children[children.length-1].position.end}})}}},function(module,exports,__webpack_require__){"use strict";module.exports=function getDefinitions(node){var defs=arguments.length>1&&arguments[1]!==undefined?arguments[1]:{};return(node.children||[]).reduce((function(definitions,child){if(child.type==="definition"){definitions[child.identifier]={href:child.url,title:child.title}}return getDefinitions(child,definitions)}),defs)}},function(module,exports,__webpack_require__){"use strict";var protocols=["http","https","mailto","tel"];module.exports=function uriTransformer(uri){var url=(uri||"").trim();var first=url.charAt(0);if(first==="#"||first==="/"){return url}var colon=url.indexOf(":");if(colon===-1){return url}var length=protocols.length;var index=-1;while(++index<length){var protocol=protocols[index];if(colon===protocol.length&&url.slice(0,protocol.length).toLowerCase()===protocol){return url}}index=url.indexOf("?");if(index!==-1&&colon>index){return url}index=url.indexOf("#");if(index!==-1&&colon>index){return url}return"javascript:void(0)"}},function(module,exports,__webpack_require__){"use strict";var xtend=__webpack_require__(110);var React=__webpack_require__(2);var supportsStringRender=parseInt((React.version||"16").slice(0,2),10)>=16;var createElement=React.createElement;module.exports={break:"br",paragraph:"p",emphasis:"em",strong:"strong",thematicBreak:"hr",blockquote:"blockquote",delete:"del",link:"a",image:"img",linkReference:"a",imageReference:"img",table:SimpleRenderer.bind(null,"table"),tableHead:SimpleRenderer.bind(null,"thead"),tableBody:SimpleRenderer.bind(null,"tbody"),tableRow:SimpleRenderer.bind(null,"tr"),tableCell:TableCell,root:Root,text:TextRenderer,list:List,listItem:ListItem,definition:NullRenderer,heading:Heading,inlineCode:InlineCode,code:CodeBlock,html:Html,virtualHtml:VirtualHtml,parsedHtml:ParsedHtml};function TextRenderer(props){return supportsStringRender?props.children:createElement("span",null,props.children)}function Root(props){var useFragment=!props.className;var root=useFragment?React.Fragment||"div":"div";return createElement(root,useFragment?null:props,props.children)}function SimpleRenderer(tag,props){return createElement(tag,getCoreProps(props),props.children)}function TableCell(props){var style=props.align?{textAlign:props.align}:undefined;var coreProps=getCoreProps(props);return createElement(props.isHeader?"th":"td",style?xtend({style:style},coreProps):coreProps,props.children)}function Heading(props){return createElement("h".concat(props.level),getCoreProps(props),props.children)}function List(props){var attrs=getCoreProps(props);if(props.start!==null&&props.start!==1&&props.start!==undefined){attrs.start=props.start.toString()}return createElement(props.ordered?"ol":"ul",attrs,props.children)}function ListItem(props){var checkbox=null;if(props.checked!==null&&props.checked!==undefined){var checked=props.checked;checkbox=createElement("input",{type:"checkbox",checked:checked,readOnly:true})}return createElement("li",getCoreProps(props),checkbox,props.children)}function CodeBlock(props){var className=props.language&&"language-".concat(props.language);var code=createElement("code",className?{className:className}:null,props.value);return createElement("pre",getCoreProps(props),code)}function InlineCode(props){return createElement("code",getCoreProps(props),props.children)}function Html(props){if(props.skipHtml){return null}var tag=props.isBlock?"div":"span";if(props.escapeHtml){var comp=React.Fragment||tag;return createElement(comp,null,props.value)}var nodeProps={dangerouslySetInnerHTML:{__html:props.value}};return createElement(tag,nodeProps)}function ParsedHtml(props){return props["data-sourcepos"]?React.cloneElement(props.element,{"data-sourcepos":props["data-sourcepos"]}):props.element}function VirtualHtml(props){return createElement(props.tag,getCoreProps(props),props.children)}function NullRenderer(){return null}function getCoreProps(props){return props["data-sourcepos"]?{"data-sourcepos":props["data-sourcepos"]}:{}}},function(module,exports,__webpack_require__){"use strict";var HtmlParser="__RMD_HTML_PARSER__";exports.HtmlParser=typeof Symbol==="undefined"?HtmlParser:Symbol(HtmlParser)},function(module,exports){ace.define("ace/mode/yaml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextHighlightRules=acequire("./text_highlight_rules").TextHighlightRules;var YamlHighlightRules=function(){this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"list.markup",regex:/^(?:-{3}|\.{3})\s*(?=#|$)/},{token:"list.markup",regex:/^\s*[\-?](?:$|\s)/},{token:"constant",regex:"!![\\w//]+"},{token:"constant.language",regex:"[&\\*][a-zA-Z0-9-_]+"},{token:["meta.tag","keyword"],regex:/^(\s*\w.*?)(:(?=\s|$))/},{token:["meta.tag","keyword"],regex:/(\w+?)(\s*:(?=\s|$))/},{token:"keyword.operator",regex:"<<\\w*:\\w*"},{token:"keyword.operator",regex:"-\\s*(?=[{])"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:/[|>][-+\d\s]*$/,onMatch:function(val,state,stack,line){var indent=/^\s*/.exec(line)[0];if(stack.length<1){stack.push(this.next)}else{stack[0]="mlString"}if(stack.length<2){stack.push(indent.length)}else{stack[1]=indent.length}return this.token},next:"mlString"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"constant.numeric",regex:/(\b|[+\-\.])[\d_]+(?:(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)(?=[^\d-\w]|$)/},{token:"constant.numeric",regex:/[+\-]?\.inf\b|NaN\b|0x[\dA-Fa-f_]+|0b[10_]+/},{token:"constant.language.boolean",regex:"\\b(?:true|false|TRUE|FALSE|True|False|yes|no)\\b"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:/[^\s,:\[\]\{\}]+/}],mlString:[{token:"indent",regex:/^\s*$/},{token:"indent",regex:/^\s*/,onMatch:function(val,state,stack){var curIndent=stack[1];if(curIndent>=val.length){this.next="start";stack.splice(0)}else{this.next="mlString"}return this.token},next:"mlString"},{token:"string",regex:".+"}]};this.normalizeRules()};oop.inherits(YamlHighlightRules,TextHighlightRules);exports.YamlHighlightRules=YamlHighlightRules}));ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],(function(acequire,exports,module){"use strict";var Range=acequire("../range").Range;var MatchingBraceOutdent=function(){};(function(){this.checkOutdent=function(line,input){if(!/^\s+$/.test(line))return false;return/^\s*\}/.test(input)};this.autoOutdent=function(doc,row){var line=doc.getLine(row);var match=line.match(/^(\s*\})/);if(!match)return 0;var column=match[1].length;var openBracePos=doc.findMatchingBracket({row:row,column:column});if(!openBracePos||openBracePos.row==row)return 0;var indent=this.$getIndent(doc.getLine(openBracePos.row));doc.replace(new Range(row,0,row,column-1),indent)};this.$getIndent=function(line){return line.match(/^\s*/)[0]}}).call(MatchingBraceOutdent.prototype);exports.MatchingBraceOutdent=MatchingBraceOutdent}));ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],(function(acequire,exports,module){"use strict";var oop=acequire("../../lib/oop");var BaseFoldMode=acequire("./fold_mode").FoldMode;var Range=acequire("../../range").Range;var FoldMode=exports.FoldMode=function(){};oop.inherits(FoldMode,BaseFoldMode);(function(){this.getFoldWidgetRange=function(session,foldStyle,row){var range=this.indentationBlock(session,row);if(range)return range;var re=/\S/;var line=session.getLine(row);var startLevel=line.search(re);if(startLevel==-1||line[startLevel]!="#")return;var startColumn=line.length;var maxRow=session.getLength();var startRow=row;var endRow=row;while(++row<maxRow){line=session.getLine(row);var level=line.search(re);if(level==-1)continue;if(line[level]!="#")break;endRow=row}if(endRow>startRow){var endColumn=session.getLine(endRow).length;return new Range(startRow,startColumn,endRow,endColumn)}};this.getFoldWidget=function(session,foldStyle,row){var line=session.getLine(row);var indent=line.search(/\S/);var next=session.getLine(row+1);var prev=session.getLine(row-1);var prevIndent=prev.search(/\S/);var nextIndent=next.search(/\S/);if(indent==-1){session.foldWidgets[row-1]=prevIndent!=-1&&prevIndent<nextIndent?"start":"";return""}if(prevIndent==-1){if(indent==nextIndent&&line[indent]=="#"&&next[indent]=="#"){session.foldWidgets[row-1]="";session.foldWidgets[row+1]="";return"start"}}else if(prevIndent==indent&&line[indent]=="#"&&prev[indent]=="#"){if(session.getLine(row-2).search(/\S/)==-1){session.foldWidgets[row-1]="start";session.foldWidgets[row+1]="";return""}}if(prevIndent!=-1&&prevIndent<indent)session.foldWidgets[row-1]="start";else session.foldWidgets[row-1]="";if(indent<nextIndent)return"start";else return""}}).call(FoldMode.prototype)}));ace.define("ace/mode/yaml",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/yaml_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/coffee"],(function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextMode=acequire("./text").Mode;var YamlHighlightRules=acequire("./yaml_highlight_rules").YamlHighlightRules;var MatchingBraceOutdent=acequire("./matching_brace_outdent").MatchingBraceOutdent;var FoldMode=acequire("./folding/coffee").FoldMode;var Mode=function(){this.HighlightRules=YamlHighlightRules;this.$outdent=new MatchingBraceOutdent;this.foldingRules=new FoldMode;this.$behaviour=this.$defaultBehaviour};oop.inherits(Mode,TextMode);(function(){this.lineCommentStart=["#","//"];this.getNextLineIndent=function(state,line,tab){var indent=this.$getIndent(line);if(state=="start"){var match=line.match(/^.*[\{\(\[]\s*$/);if(match){indent+=tab}}return indent};this.checkOutdent=function(state,line,input){return this.$outdent.checkOutdent(line,input)};this.autoOutdent=function(state,doc,row){this.$outdent.autoOutdent(doc,row)};this.$id="ace/mode/yaml"}).call(Mode.prototype);exports.Mode=Mode}))},function(module,exports){ace.define("ace/theme/textmate",["require","exports","module","ace/lib/dom"],(function(acequire,exports,module){"use strict";exports.isDark=false;exports.cssClass="ace-tm";exports.cssText='.ace-tm .ace_gutter {background: #f0f0f0;color: #333;}.ace-tm .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-tm .ace_fold {background-color: #6B72E6;}.ace-tm {background-color: #FFFFFF;color: black;}.ace-tm .ace_cursor {color: black;}.ace-tm .ace_invisible {color: rgb(191, 191, 191);}.ace-tm .ace_storage,.ace-tm .ace_keyword {color: blue;}.ace-tm .ace_constant {color: rgb(197, 6, 11);}.ace-tm .ace_constant.ace_buildin {color: rgb(88, 72, 246);}.ace-tm .ace_constant.ace_language {color: rgb(88, 92, 246);}.ace-tm .ace_constant.ace_library {color: rgb(6, 150, 14);}.ace-tm .ace_invalid {background-color: rgba(255, 0, 0, 0.1);color: red;}.ace-tm .ace_support.ace_function {color: rgb(60, 76, 114);}.ace-tm .ace_support.ace_constant {color: rgb(6, 150, 14);}.ace-tm .ace_support.ace_type,.ace-tm .ace_support.ace_class {color: rgb(109, 121, 222);}.ace-tm .ace_keyword.ace_operator {color: rgb(104, 118, 135);}.ace-tm .ace_string {color: rgb(3, 106, 7);}.ace-tm .ace_comment {color: rgb(76, 136, 107);}.ace-tm .ace_comment.ace_doc {color: rgb(0, 102, 255);}.ace-tm .ace_comment.ace_doc.ace_tag {color: rgb(128, 159, 191);}.ace-tm .ace_constant.ace_numeric {color: rgb(0, 0, 205);}.ace-tm .ace_variable {color: rgb(49, 132, 149);}.ace-tm .ace_xml-pe {color: rgb(104, 104, 91);}.ace-tm .ace_entity.ace_name.ace_function {color: #0000A2;}.ace-tm .ace_heading {color: rgb(12, 7, 255);}.ace-tm .ace_list {color:rgb(185, 6, 144);}.ace-tm .ace_meta.ace_tag {color:rgb(0, 22, 142);}.ace-tm .ace_string.ace_regex {color: rgb(255, 0, 0)}.ace-tm .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-tm.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-tm .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-tm .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-tm .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-tm .ace_marker-layer .ace_active-line {background: rgba(0, 0, 0, 0.07);}.ace-tm .ace_gutter-active-line {background-color : #dcdcdc;}.ace-tm .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-tm .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}';var dom=acequire("../lib/dom");dom.importCssString(exports.cssText,exports.cssClass)}))},function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(265);case"v7light":return __webpack_require__(267);case"v8dark":return __webpack_require__(269);case"v8light":return __webpack_require__(271)}},function(module,exports,__webpack_require__){var api=__webpack_require__(116);var content=__webpack_require__(266);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(117);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".fleet__epm__shiftNavTabs {\n  margin-left: 184px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(116);var content=__webpack_require__(268);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(117);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".fleet__epm__shiftNavTabs {\n  margin-left: 184px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(116);var content=__webpack_require__(270);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(117);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".fleet__epm__shiftNavTabs {\n  margin-left: 184px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){var api=__webpack_require__(116);var content=__webpack_require__(272);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(117);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,".fleet__epm__shiftNavTabs {\n  margin-left: 184px; }\n",""]);module.exports=exports},function(module,exports,__webpack_require__){(function(root,factory){if(true){module.exports=factory()}else{}})(typeof self!=="undefined"?self:this,(function(){var rison={};rison.uri_ok={"~":true,"!":true,"*":true,"(":true,")":true,"-":true,_:true,".":true,",":true,":":true,"@":true,$:true,"'":true,"/":true};(function(){var l=[];for(var hi=0;hi<16;hi++){for(var lo=0;lo<16;lo++){if(hi+lo===0)continue;var c=String.fromCharCode(hi*16+lo);if(!/\w|[-_./~]/.test(c))l.push("\\u00"+hi.toString(16)+lo.toString(16))}}rison.not_idchar=l.join("")})();rison.not_idchar=" '!:(),*@$";rison.not_idstart="-0123456789";(function(){var idrx="[^"+rison.not_idstart+rison.not_idchar+"][^"+rison.not_idchar+"]*";rison.id_ok=new RegExp("^"+idrx+"$");rison.next_id=new RegExp(idrx,"g")})();rison.quote=function(x){if(/^[-A-Za-z0-9~!*()_.',:@$/]*$/.test(x))return x;return encodeURIComponent(x).replace(/%2C/g,",").replace(/%3A/g,":").replace(/%40/g,"@").replace(/%24/g,"$").replace(/%2F/g,"/").replace(/%20/g,"+")};(function(){var sq={"'":true,"!":true},enc=function(v){if(v&&typeof v.toJSON==="function")v=v.toJSON();var fn=s[typeof v];if(fn)return fn(v)},s={array:function(x){var a=["!("],b,i,l=x.length,v;for(i=0;i<l;i+=1){v=enc(x[i]);if(typeof v=="string"){if(b){a[a.length]=","}a[a.length]=v;b=true}}a[a.length]=")";return a.join("")},boolean:function(x){if(x)return"!t";return"!f"},null:function(){return"!n"},number:function(x){if(!isFinite(x))return"!n";return String(x).replace(/\+/,"")},object:function(x){if(x){if(x instanceof Array){return s.array(x)}if(typeof x.__prototype__==="object"&&typeof x.__prototype__.encode_rison!=="undefined")return x.encode_rison();var a=["("],b,i,v,ki,ks=[];for(i in x)ks[ks.length]=i;ks.sort();for(ki=0;ki<ks.length;ki++){i=ks[ki];v=enc(x[i]);if(typeof v=="string"){if(b){a[a.length]=","}a.push(s.string(i),":",v);b=true}}a[a.length]=")";return a.join("")}return"!n"},string:function(x){if(x==="")return"''";if(rison.id_ok.test(x))return x;x=x.replace(/(['!])/g,(function(a,b){if(sq[b])return"!"+b;return b}));return"'"+x+"'"},undefined:function(){return}};rison.encode=function(v){return enc(v)};rison.encode_object=function(v){if(typeof v!="object"||v===null||v instanceof Array)throw new Error("rison.encode_object expects an object argument");var r=s[typeof v](v);return r.substring(1,r.length-1)};rison.encode_array=function(v){if(!(v instanceof Array))throw new Error("rison.encode_array expects an array argument");var r=s[typeof v](v);return r.substring(2,r.length-1)};rison.encode_uri=function(v){return rison.quote(s[typeof v](v))}})();rison.decode=function(r){var errcb=function(e){throw Error("rison decoder error: "+e)};if(typeof r!=="string")return errcb("decode input must be a string");var p=new rison.parser(errcb);return p.parse(r)};rison.decode_object=function(r){return rison.decode("("+r+")")};rison.decode_array=function(r){return rison.decode("!("+r+")")};rison.parser=function(errcb){this.errorHandler=errcb};rison.parser.WHITESPACE="";rison.parser.prototype.setOptions=function(options){if(options["errorHandler"])this.errorHandler=options.errorHandler};rison.parser.prototype.parse=function(str){this.string=str;this.index=0;this.message=null;var value=this.readValue();if(!this.message&&this.next())value=this.error("unable to parse string as rison: '"+rison.encode(str)+"'");if(this.message&&this.errorHandler)this.errorHandler(this.message,this.index);return value};rison.parser.prototype.error=function(message){if(typeof console!=="undefined")console.log("rison parser error: ",message);this.message=message;return undefined};rison.parser.prototype.readValue=function(){var c=this.next();var fn=c&&this.table[c];if(fn)return fn.apply(this);var s=this.string;var i=this.index-1;rison.next_id.lastIndex=i;var m=rison.next_id.exec(s);if(m.length>0){var id=m[0];this.index=i+id.length;return id}if(c)return this.error("invalid character: '"+c+"'");return this.error("empty expression")};rison.parser.parse_array=function(parser){var ar=[];var c;while((c=parser.next())!==")"){if(!c)return parser.error("unmatched '!('");if(ar.length){if(c!==",")parser.error("missing ','")}else if(c===","){return parser.error("extra ','")}else--parser.index;var n=parser.readValue();if(typeof n=="undefined")return undefined;ar.push(n)}return ar};rison.parser.bangs={t:true,f:false,n:null,"(":rison.parser.parse_array};rison.parser.prototype.table={"!":function(){var s=this.string;var c=s.charAt(this.index++);if(!c)return this.error('"!" at end of input');var x=rison.parser.bangs[c];if(typeof x=="function"){return x.call(null,this)}else if(typeof x=="undefined"){return this.error('unknown literal: "!'+c+'"')}return x},"(":function(){var o={};var c;var count=0;while((c=this.next())!==")"){if(count){if(c!==",")this.error("missing ','")}else if(c===","){return this.error("extra ','")}else--this.index;var k=this.readValue();if(typeof k==="undefined")return undefined;if(this.next()!==":")return this.error("missing ':'");var v=this.readValue();if(typeof v==="undefined")return undefined;o[k]=v;count++}return o},"'":function(){var s=this.string;var i=this.index;var start=i;var segments=[];var c;while((c=s.charAt(i++))!=="'"){if(!c)return this.error('unmatched "\'"');if(c==="!"){if(start<i-1)segments.push(s.slice(start,i-1));c=s.charAt(i++);if("!'".indexOf(c)>=0){segments.push(c)}else{return this.error('invalid string escape: "!'+c+'"')}start=i}}if(start<i-1)segments.push(s.slice(start,i-1));this.index=i;return segments.length===1?segments[0]:segments.join("")},"-":function(){var s=this.string;var i=this.index;var start=i-1;var state="int";var permittedSigns="-";var transitions={"int+.":"frac","int+e":"exp","frac+e":"exp"};do{var c=s.charAt(i++);if(!c)break;if("0"<=c&&c<="9")continue;if(permittedSigns.indexOf(c)>=0){permittedSigns="";continue}state=transitions[state+"+"+c.toLowerCase()];if(state==="exp")permittedSigns="-"}while(state);this.index=--i;s=s.slice(start,i);if(s==="-")return this.error("invalid number");return Number(s)}};(function(table){for(var i=0;i<=9;i++)table[String(i)]=table["-"]})(rison.parser.prototype.table);rison.parser.prototype.next=function(){var c;var s=this.string;var i=this.index;do{if(i===s.length)return undefined;c=s.charAt(i++)}while(rison.parser.WHITESPACE.indexOf(c)>=0);this.index=i;return c};return rison}))},function(module,exports,__webpack_require__){const compare=__webpack_require__(64);const gte=(a,b,loose)=>compare(a,b,loose)>=0;module.exports=gte},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(98);var react_1=__webpack_require__(2);var useIsomorphicLayoutEffect_1=tslib_1.__importDefault(__webpack_require__(142));var util_1=__webpack_require__(276);var defaultState={x:0,y:0,width:0,height:0,top:0,left:0,bottom:0,right:0};var useMeasure=function(){var _a=react_1.useState(null),element=_a[0],ref=_a[1];var _b=react_1.useState(defaultState),rect=_b[0],setRect=_b[1];var observer=react_1.useMemo((function(){return new window.ResizeObserver((function(entries){if(entries[0]){var _a=entries[0].contentRect,x=_a.x,y=_a.y,width=_a.width,height=_a.height,top_1=_a.top,left=_a.left,bottom=_a.bottom,right=_a.right;setRect({x:x,y:y,width:width,height:height,top:top_1,left:left,bottom:bottom,right:right})}}))}),[]);useIsomorphicLayoutEffect_1.default((function(){if(!element)return;observer.observe(element);return function(){observer.disconnect()}}),[element]);return[ref,rect]};var useMeasureMock=function(){return[function(){},defaultState]};exports.default=util_1.isClient&&!!window.ResizeObserver?useMeasure:useMeasureMock},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.isDeepEqual=exports.off=exports.on=exports.isClient=void 0;var tslib_1=__webpack_require__(98);var react_1=tslib_1.__importDefault(__webpack_require__(277));exports.isClient=typeof window==="object";exports.on=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.addEventListener.apply(obj,args)};exports.off=function(obj){var args=[];for(var _i=1;_i<arguments.length;_i++){args[_i-1]=arguments[_i]}return obj.removeEventListener.apply(obj,args)};exports.isDeepEqual=react_1.default},function(module,exports,__webpack_require__){"use strict";module.exports=function equal(a,b){if(a===b)return true;if(a&&b&&typeof a=="object"&&typeof b=="object"){if(a.constructor!==b.constructor)return false;var length,i,keys;if(Array.isArray(a)){length=a.length;if(length!=b.length)return false;for(i=length;i--!==0;)if(!equal(a[i],b[i]))return false;return true}if(a.constructor===RegExp)return a.source===b.source&&a.flags===b.flags;if(a.valueOf!==Object.prototype.valueOf)return a.valueOf()===b.valueOf();if(a.toString!==Object.prototype.toString)return a.toString()===b.toString();keys=Object.keys(a);length=keys.length;if(length!==Object.keys(b).length)return false;for(i=length;i--!==0;)if(!Object.prototype.hasOwnProperty.call(b,keys[i]))return false;for(i=length;i--!==0;){var key=keys[i];if(key==="_owner"&&a.$$typeof){continue}if(!equal(a[key],b[key]))return false}return true}return a!==a&&b!==b}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var tslib_1=__webpack_require__(98);var react_1=__webpack_require__(2);var useIsomorphicLayoutEffect_1=tslib_1.__importDefault(__webpack_require__(142));function useObservable(observable$,initialValue){var _a=react_1.useState(initialValue),value=_a[0],update=_a[1];useIsomorphicLayoutEffect_1.default((function(){var s=observable$.subscribe(update);return function(){return s.unsubscribe()}}),[observable$]);return value}exports.default=useObservable},function(module,exports,__webpack_require__){"use strict";if(true){module.exports=__webpack_require__(280)}else{}},function(module,exports,__webpack_require__){"use strict";function _interopDefault(n){return n&&"object"==typeof n&&"default"in n?n.default:n}Object.defineProperty(exports,"__esModule",{value:!0});var resolvePathname=_interopDefault(__webpack_require__(281)),valueEqual=_interopDefault(__webpack_require__(282));__webpack_require__(283);var invariant=_interopDefault(__webpack_require__(284));function _extends(){return(_extends=Object.assign||function(n){for(var t=1;t<arguments.length;t++){var e=arguments[t];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(n[a]=e[a])}return n}).apply(this,arguments)}function addLeadingSlash(n){return"/"===n.charAt(0)?n:"/"+n}function stripLeadingSlash(n){return"/"===n.charAt(0)?n.substr(1):n}function hasBasename(n,t){return new RegExp("^"+t+"(\\/|\\?|#|$)","i").test(n)}function stripBasename(n,t){return hasBasename(n,t)?n.substr(t.length):n}function stripTrailingSlash(n){return"/"===n.charAt(n.length-1)?n.slice(0,-1):n}function parsePath(n){var t=n||"/",e="",a="",o=t.indexOf("#");-1!==o&&(a=t.substr(o),t=t.substr(0,o));var r=t.indexOf("?");return-1!==r&&(e=t.substr(r),t=t.substr(0,r)),{pathname:t,search:"?"===e?"":e,hash:"#"===a?"":a}}function createPath(n){var t=n.pathname,e=n.search,a=n.hash,o=t||"/";return e&&"?"!==e&&(o+="?"===e.charAt(0)?e:"?"+e),a&&"#"!==a&&(o+="#"===a.charAt(0)?a:"#"+a),o}function createLocation(n,t,e,a){var o;"string"==typeof n?(o=parsePath(n)).state=t:(void 0===(o=_extends({},n)).pathname&&(o.pathname=""),o.search?"?"!==o.search.charAt(0)&&(o.search="?"+o.search):o.search="",o.hash?"#"!==o.hash.charAt(0)&&(o.hash="#"+o.hash):o.hash="",void 0!==t&&void 0===o.state&&(o.state=t));try{o.pathname=decodeURI(o.pathname)}catch(n){throw n instanceof URIError?new URIError('Pathname "'+o.pathname+'" could not be decoded. This is likely caused by an invalid percent-encoding.'):n}return e&&(o.key=e),a?o.pathname?"/"!==o.pathname.charAt(0)&&(o.pathname=resolvePathname(o.pathname,a.pathname)):o.pathname=a.pathname:o.pathname||(o.pathname="/"),o}function locationsAreEqual(n,t){return n.pathname===t.pathname&&n.search===t.search&&n.hash===t.hash&&n.key===t.key&&valueEqual(n.state,t.state)}function createTransitionManager(){var r=null;var a=[];return{setPrompt:function(n){return r=n,function(){r===n&&(r=null)}},confirmTransitionTo:function(n,t,e,a){if(null!=r){var o="function"==typeof r?r(n,t):r;"string"==typeof o?"function"==typeof e?e(o,a):a(!0):a(!1!==o)}else a(!0)},appendListener:function(n){var t=!0;function e(){t&&n.apply(void 0,arguments)}return a.push(e),function(){t=!1,a=a.filter((function(n){return n!==e}))}},notifyListeners:function(){for(var n=arguments.length,t=new Array(n),e=0;e<n;e++)t[e]=arguments[e];a.forEach((function(n){return n.apply(void 0,t)}))}}}var canUseDOM=!("undefined"==typeof window||!window.document||!window.document.createElement);function getConfirmation(n,t){t(window.confirm(n))}function supportsHistory(){var n=window.navigator.userAgent;return(-1===n.indexOf("Android 2.")&&-1===n.indexOf("Android 4.0")||-1===n.indexOf("Mobile Safari")||-1!==n.indexOf("Chrome")||-1!==n.indexOf("Windows Phone"))&&(window.history&&"pushState"in window.history)}function supportsPopStateOnHashChange(){return-1===window.navigator.userAgent.indexOf("Trident")}function supportsGoWithoutReloadUsingHash(){return-1===window.navigator.userAgent.indexOf("Firefox")}function isExtraneousPopstateEvent(n){void 0===n.state&&navigator.userAgent.indexOf("CriOS")}var PopStateEvent="popstate",HashChangeEvent="hashchange";function getHistoryState(){try{return window.history.state||{}}catch(n){return{}}}function createBrowserHistory(n){void 0===n&&(n={}),canUseDOM||invariant(!1);var c=window.history,s=supportsHistory(),t=!supportsPopStateOnHashChange(),e=n,a=e.forceRefresh,h=void 0!==a&&a,o=e.getUserConfirmation,u=void 0===o?getConfirmation:o,r=e.keyLength,i=void 0===r?6:r,f=n.basename?stripTrailingSlash(addLeadingSlash(n.basename)):"";function l(n){var t=n||{},e=t.key,a=t.state,o=window.location,r=o.pathname+o.search+o.hash;return f&&(r=stripBasename(r,f)),createLocation(r,a,e)}function d(){return Math.random().toString(36).substr(2,i)}var v=createTransitionManager();function p(n){_extends(T,n),T.length=c.length,v.notifyListeners(T.location,T.action)}function g(n){isExtraneousPopstateEvent(n)||w(l(n.state))}function P(){w(l(getHistoryState()))}var m=!1;function w(t){if(m)m=!1,p();else{v.confirmTransitionTo(t,"POP",u,(function(n){n?p({action:"POP",location:t}):function(n){var t=T.location,e=H.indexOf(t.key);-1===e&&(e=0);var a=H.indexOf(n.key);-1===a&&(a=0);var o=e-a;o&&(m=!0,L(o))}(t)}))}}var y=l(getHistoryState()),H=[y.key];function x(n){return f+createPath(n)}function L(n){c.go(n)}var O=0;function E(n){1===(O+=n)&&1===n?(window.addEventListener(PopStateEvent,g),t&&window.addEventListener(HashChangeEvent,P)):0===O&&(window.removeEventListener(PopStateEvent,g),t&&window.removeEventListener(HashChangeEvent,P))}var S=!1;var T={length:c.length,action:"POP",location:y,createHref:x,push:function(n,t){var i=createLocation(n,t,d(),T.location);v.confirmTransitionTo(i,"PUSH",u,(function(n){if(n){var t=x(i),e=i.key,a=i.state;if(s)if(c.pushState({key:e,state:a},null,t),h)window.location.href=t;else{var o=H.indexOf(T.location.key),r=H.slice(0,-1===o?0:o+1);r.push(i.key),H=r,p({action:"PUSH",location:i})}else window.location.href=t}}))},replace:function(n,t){var r="REPLACE",i=createLocation(n,t,d(),T.location);v.confirmTransitionTo(i,r,u,(function(n){if(n){var t=x(i),e=i.key,a=i.state;if(s)if(c.replaceState({key:e,state:a},null,t),h)window.location.replace(t);else{var o=H.indexOf(T.location.key);-1!==o&&(H[o]=i.key),p({action:r,location:i})}else window.location.replace(t)}}))},go:L,goBack:function(){L(-1)},goForward:function(){L(1)},block:function(n){void 0===n&&(n=!1);var t=v.setPrompt(n);return S||(E(1),S=!0),function(){return S&&(S=!1,E(-1)),t()}},listen:function(n){var t=v.appendListener(n);return E(1),function(){E(-1),t()}}};return T}var HashChangeEvent$1="hashchange",HashPathCoders={hashbang:{encodePath:function(n){return"!"===n.charAt(0)?n:"!/"+stripLeadingSlash(n)},decodePath:function(n){return"!"===n.charAt(0)?n.substr(1):n}},noslash:{encodePath:stripLeadingSlash,decodePath:addLeadingSlash},slash:{encodePath:addLeadingSlash,decodePath:addLeadingSlash}};function getHashPath(){var n=window.location.href,t=n.indexOf("#");return-1===t?"":n.substring(t+1)}function pushHashPath(n){window.location.hash=n}function replaceHashPath(n){var t=window.location.href.indexOf("#");window.location.replace(window.location.href.slice(0,0<=t?t:0)+"#"+n)}function createHashHistory(n){void 0===n&&(n={}),canUseDOM||invariant(!1);var t=window.history,e=(supportsGoWithoutReloadUsingHash(),n),a=e.getUserConfirmation,i=void 0===a?getConfirmation:a,o=e.hashType,r=void 0===o?"slash":o,c=n.basename?stripTrailingSlash(addLeadingSlash(n.basename)):"",s=HashPathCoders[r],h=s.encodePath,u=s.decodePath;function f(){var n=u(getHashPath());return c&&(n=stripBasename(n,c)),createLocation(n)}var l=createTransitionManager();function d(n){_extends(E,n),E.length=t.length,l.notifyListeners(E.location,E.action)}var v=!1,p=null;function g(){var n=getHashPath(),t=h(n);if(n!==t)replaceHashPath(t);else{var e=f(),a=E.location;if(!v&&locationsAreEqual(a,e))return;if(p===createPath(e))return;p=null,function(t){if(v)v=!1,d();else{l.confirmTransitionTo(t,"POP",i,(function(n){n?d({action:"POP",location:t}):function(n){var t=E.location,e=y.lastIndexOf(createPath(t));-1===e&&(e=0);var a=y.lastIndexOf(createPath(n));-1===a&&(a=0);var o=e-a;o&&(v=!0,H(o))}(t)}))}}(e)}}var P=getHashPath(),m=h(P);P!==m&&replaceHashPath(m);var w=f(),y=[createPath(w)];function H(n){t.go(n)}var x=0;function L(n){1===(x+=n)&&1===n?window.addEventListener(HashChangeEvent$1,g):0===x&&window.removeEventListener(HashChangeEvent$1,g)}var O=!1;var E={length:t.length,action:"POP",location:w,createHref:function(n){return"#"+h(c+createPath(n))},push:function(n,t){var r=createLocation(n,void 0,void 0,E.location);l.confirmTransitionTo(r,"PUSH",i,(function(n){if(n){var t=createPath(r),e=h(c+t);if(getHashPath()!==e){p=t,pushHashPath(e);var a=y.lastIndexOf(createPath(E.location)),o=y.slice(0,-1===a?0:a+1);o.push(t),y=o,d({action:"PUSH",location:r})}else d()}}))},replace:function(n,t){var o="REPLACE",r=createLocation(n,void 0,void 0,E.location);l.confirmTransitionTo(r,o,i,(function(n){if(n){var t=createPath(r),e=h(c+t);getHashPath()!==e&&(p=t,replaceHashPath(e));var a=y.indexOf(createPath(E.location));-1!==a&&(y[a]=t),d({action:o,location:r})}}))},go:H,goBack:function(){H(-1)},goForward:function(){H(1)},block:function(n){void 0===n&&(n=!1);var t=l.setPrompt(n);return O||(L(1),O=!0),function(){return O&&(O=!1,L(-1)),t()}},listen:function(n){var t=l.appendListener(n);return L(1),function(){L(-1),t()}}};return E}function clamp(n,t,e){return Math.min(Math.max(n,t),e)}function createMemoryHistory(n){void 0===n&&(n={});var t=n,o=t.getUserConfirmation,e=t.initialEntries,a=void 0===e?["/"]:e,r=t.initialIndex,i=void 0===r?0:r,c=t.keyLength,s=void 0===c?6:c,h=createTransitionManager();function u(n){_extends(g,n),g.length=g.entries.length,h.notifyListeners(g.location,g.action)}function f(){return Math.random().toString(36).substr(2,s)}var l=clamp(i,0,a.length-1),d=a.map((function(n){return createLocation(n,void 0,"string"==typeof n?f():n.key||f())})),v=createPath;function p(n){var t=clamp(g.index+n,0,g.entries.length-1),e=g.entries[t];h.confirmTransitionTo(e,"POP",o,(function(n){n?u({action:"POP",location:e,index:t}):u()}))}var g={length:d.length,action:"POP",location:d[l],index:l,entries:d,createHref:v,push:function(n,t){var a=createLocation(n,t,f(),g.location);h.confirmTransitionTo(a,"PUSH",o,(function(n){if(n){var t=g.index+1,e=g.entries.slice(0);e.length>t?e.splice(t,e.length-t,a):e.push(a),u({action:"PUSH",location:a,index:t,entries:e})}}))},replace:function(n,t){var e="REPLACE",a=createLocation(n,t,f(),g.location);h.confirmTransitionTo(a,e,o,(function(n){n&&(g.entries[g.index]=a,u({action:e,location:a}))}))},go:p,goBack:function(){p(-1)},goForward:function(){p(1)},canGo:function(n){var t=g.index+n;return 0<=t&&t<g.entries.length},block:function(n){return void 0===n&&(n=!1),h.setPrompt(n)},listen:function(n){return h.appendListener(n)}};return g}exports.createBrowserHistory=createBrowserHistory,exports.createHashHistory=createHashHistory,exports.createMemoryHistory=createMemoryHistory,exports.createLocation=createLocation,exports.locationsAreEqual=locationsAreEqual,exports.parsePath=parsePath,exports.createPath=createPath},function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;function isAbsolute(pathname){return pathname.charAt(0)==="/"}function spliceOne(list,index){for(var i=index,k=i+1,n=list.length;k<n;i+=1,k+=1){list[i]=list[k]}list.pop()}function resolvePathname(to){var from=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"";var toParts=to&&to.split("/")||[];var fromParts=from&&from.split("/")||[];var isToAbs=to&&isAbsolute(to);var isFromAbs=from&&isAbsolute(from);var mustEndAbs=isToAbs||isFromAbs;if(to&&isAbsolute(to)){fromParts=toParts}else if(toParts.length){fromParts.pop();fromParts=fromParts.concat(toParts)}if(!fromParts.length)return"/";var hasTrailingSlash=void 0;if(fromParts.length){var last=fromParts[fromParts.length-1];hasTrailingSlash=last==="."||last===".."||last===""}else{hasTrailingSlash=false}var up=0;for(var i=fromParts.length;i>=0;i--){var part=fromParts[i];if(part==="."){spliceOne(fromParts,i)}else if(part===".."){spliceOne(fromParts,i);up++}else if(up){spliceOne(fromParts,i);up--}}if(!mustEndAbs)for(;up--;up){fromParts.unshift("..")}if(mustEndAbs&&fromParts[0]!==""&&(!fromParts[0]||!isAbsolute(fromParts[0])))fromParts.unshift("");var result=fromParts.join("/");if(hasTrailingSlash&&result.substr(-1)!=="/")result+="/";return result}exports.default=resolvePathname;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};function valueEqual(a,b){if(a===b)return true;if(a==null||b==null)return false;if(Array.isArray(a)){return Array.isArray(b)&&a.length===b.length&&a.every((function(item,index){return valueEqual(item,b[index])}))}var aType=typeof a==="undefined"?"undefined":_typeof(a);var bType=typeof b==="undefined"?"undefined":_typeof(b);if(aType!==bType)return false;if(aType==="object"){var aValue=a.valueOf();var bValue=b.valueOf();if(aValue!==a||bValue!==b)return valueEqual(aValue,bValue);var aKeys=Object.keys(a);var bKeys=Object.keys(b);if(aKeys.length!==bKeys.length)return false;return aKeys.every((function(key){return valueEqual(a[key],b[key])}))}return false}exports.default=valueEqual;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var isProduction="production"==="production";function warning(condition,message){if(!isProduction){if(condition){return}var text="Warning: "+message;if(typeof console!=="undefined"){console.warn(text)}try{throw Error(text)}catch(x){}}}module.exports=warning},function(module,exports,__webpack_require__){"use strict";var isProduction="production"==="production";var prefix="Invariant failed";function invariant(condition,message){if(condition){return}if(isProduction){throw new Error(prefix)}else{throw new Error(prefix+": "+(message||""))}}module.exports=invariant},,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"ProtectedRoute",(function(){return ProtectedRoute}));__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));__webpack_require__.d(__webpack_exports__,"teardownFleet",(function(){return teardownFleet}));var external_kbnSharedDeps_React_=__webpack_require__(2);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(101);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(96);var hooks=__webpack_require__(106);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(10);var node_modules_history=__webpack_require__(279);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(94);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(4);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(95);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var useObservable=__webpack_require__(278);var useObservable_default=__webpack_require__.n(useObservable);const Loading=({size:size})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:size||"xl"})));const error_Error=({title:title,error:error})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:title,color:"danger",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement("p",null,typeof error==="string"?error:error.message));function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const Container=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Container",componentId:"h7yryh-0"})(["border-bottom:",";background-color:",";"],props=>props.theme.eui.euiBorderThin,props=>props.theme.eui.euiPageBackgroundColor);const Wrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Wrapper",componentId:"h7yryh-1"})(["max-width:","px;margin-left:auto;margin-right:auto;padding-top:",";padding-left:",";padding-right:",";"],props=>props.maxWidth||1200,props=>props.theme.eui.paddingSizes.xl,props=>props.theme.eui.paddingSizes.m,props=>props.theme.eui.paddingSizes.m);const Tabs=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiTabs"]).withConfig({displayName:"Tabs",componentId:"h7yryh-2"})(["top:1px;&:before{height:0px;}"]);const HeaderColumns=Object(external_kbnSharedDeps_React_["memo"])(({leftColumn:leftColumn,rightColumn:rightColumn,rightColumnGrow:rightColumnGrow})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},leftColumn?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,leftColumn):null,rightColumn?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:rightColumnGrow},rightColumn):null));const Header=({leftColumn:leftColumn,rightColumn:rightColumn,rightColumnGrow:rightColumnGrow,tabs:tabs,maxWidth:maxWidth,tabsClassName:tabsClassName,"data-test-subj":dataTestSubj})=>external_kbnSharedDeps_React_default.a.createElement(Container,{"data-test-subj":dataTestSubj},external_kbnSharedDeps_React_default.a.createElement(Wrapper,{maxWidth:maxWidth},external_kbnSharedDeps_React_default.a.createElement(HeaderColumns,{leftColumn:leftColumn,rightColumn:rightColumn,rightColumnGrow:rightColumnGrow}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,tabs?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(Tabs,{className:tabsClassName},tabs.map(props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],_extends({},props,{key:props.id}),props.name)))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})))));const AlphaFlyout=({onClose:onClose})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"m",maxWidth:640},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"AlphaMessagingFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"AlphaMessagingFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessaging.flyoutTitle",defaultMessage:"About this release"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessaging.introText",defaultMessage:"Fleet is under active development and is not intended for use in production environments. This beta release is designed for users to test and offer feedback about Fleet and the new Elastic Agent. This plugin is not subject to the support SLA."})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessaging.feedbackText",defaultMessage:"Read our {docsLink} or go to our {forumLink} for questions or feedback.",values:{docsLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/fleet/current/index.html",external:true,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessaging.docsLink",defaultMessage:"documentation"})),forumLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://ela.st/fleet-forum",external:true,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessaging.forumLink",defaultMessage:"Discuss forum"}))}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onClose,flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessging.closeFlyoutLabel",defaultMessage:"Close"}))));const Message=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiText"]).attrs(props=>({color:"subdued",textAlign:"center",size:"s"})).withConfig({displayName:"Message",componentId:"lt2gk4-0"})(["padding:",";margin-top:auto;"],props=>props.theme.eui.paddingSizes.m);const AlphaMessaging=()=>{const[isAlphaFlyoutOpen,setIsAlphaFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Message,null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessageTitle",defaultMessage:"Beta release"}))," – ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessageDescription",defaultMessage:"Fleet is not recommended for production environments."})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{color:"subdued",onClick:()=>setIsAlphaFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.alphaMessageLinkText",defaultMessage:"See more details."})))),isAlphaFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(AlphaFlyout,{onClose:()=>setIsAlphaFlyoutOpen(false)}))};function package_icon_extends(){package_icon_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return package_icon_extends.apply(this,arguments)}const PackageIcon=({packageName:packageName,version:version,icons:icons,tryApi:tryApi,...euiIconProps})=>{const iconType=Object(hooks["ib"])({packageName:packageName,version:version,icons:icons,tryApi:tryApi});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],package_icon_extends({size:"s",type:iconType},euiIconProps))};function context_menu_actions_extends(){context_menu_actions_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return context_menu_actions_extends.apply(this,arguments)}const ContextMenuActions=external_kbnSharedDeps_React_default.a.memo(({button:button,onChange:onChange,isOpen:isOpen,...props})=>{const[isOpenState,setIsOpenState]=Object(external_kbnSharedDeps_React_["useState"])(false);const handleCloseMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(onChange){onChange(false)}else{setIsOpenState(false)}},[setIsOpenState,onChange]);const handleToggleMenu=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(onChange){onChange(!isOpen)}else{setIsOpenState(!isOpenState)}},[isOpenState,onChange,isOpen]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{anchorPosition:"downRight",panelPaddingSize:"none",button:button?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],context_menu_actions_extends({},button.props,{onClick:handleToggleMenu}),button.children):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:"boxesHorizontal",onClick:handleToggleMenu,"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.genericActionsMenuText",{defaultMessage:"Open"})}),isOpen:isOpen===undefined?isOpenState:isOpen,closePopover:handleCloseMenu},"items"in props?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],{items:props.items}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{panels:props.panels,initialPanelId:0}))});var public_=__webpack_require__(99);var constants=__webpack_require__(11);const HIDDEN_FIELDS=[`${constants["d"]}.actions`,"_id","_index"];const SearchBar=({value:value,fieldPrefix:fieldPrefix,onChange:onChange,placeholder:placeholder,indexPattern:indexPattern=constants["h"]})=>{const{data:data}=Object(hooks["mb"])();const[indexPatternFields,setIndexPatternFields]=Object(external_kbnSharedDeps_React_["useState"])();const isQueryValid=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!value||value===""){return true}try{public_["esKuery"].fromKueryExpression(value);return true}catch(e){return false}},[value]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchFields=async()=>{try{const _fields=await data.indexPatterns.getFieldsForWildcard({pattern:indexPattern});const fields=(_fields||[]).filter(field=>{if(!fieldPrefix||field.name.startsWith(fieldPrefix)){for(const hiddenField of HIDDEN_FIELDS){if(field.name.startsWith(hiddenField)){return false}}return true}});setIndexPatternFields(fields)}catch(err){setIndexPatternFields(undefined)}};fetchFields()},[data.indexPatterns,fieldPrefix,indexPattern]);return external_kbnSharedDeps_React_default.a.createElement(public_["QueryStringInput"],{iconType:"search",disableLanguageSwitcher:true,indexPatterns:indexPatternFields?[{title:indexPattern,fields:indexPatternFields}]:[],query:{query:value,language:"kuery"},isInvalid:!isQueryValid,disableAutoFocus:true,placeholder:placeholder,onChange:newQuery=>{onChange(newQuery.query)},onSubmit:newQuery=>{onChange(newQuery.query,true)}})};var js_yaml=__webpack_require__(29);var outputs=__webpack_require__(120);var common=__webpack_require__(1);function settings_flyout_extends(){settings_flyout_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return settings_flyout_extends.apply(this,arguments)}const URL_REGEX=/^(https?):\/\/[^\s$.?#].[^\s]*$/gm;function useSettingsForm(outputId,onSuccess){const[isLoading,setIsloading]=external_kbnSharedDeps_React_default.a.useState(false);const{notifications:notifications}=Object(hooks["mb"])();const kibanaUrlsInput=Object(hooks["L"])([],value=>{if(value.length===0){return[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.kibanaUrlEmptyError",{defaultMessage:"At least one URL is required"})]}if(value.some(v=>!v.match(URL_REGEX))){return[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.kibanaUrlError",{defaultMessage:"Invalid URL"})]}if(Object(common["isDiffPathProtocol"])(value)){return[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.kibanaUrlDifferentPathOrProtocolError",{defaultMessage:"Protocol and path must be the same for each URL"})]}});const elasticsearchUrlInput=Object(hooks["L"])([],value=>{if(value.some(v=>!v.match(URL_REGEX))){return[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.elasticHostError",{defaultMessage:"Invalid URL"})]}});const additionalYamlConfigInput=Object(hooks["db"])("",value=>{try{Object(js_yaml["safeLoad"])(value);return}catch(error){return[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.invalidYamlFormatErrorMessage",{defaultMessage:"Invalid YAML: {reason}",values:{reason:error.message}})]}});return{isLoading:isLoading,onSubmit:async()=>{if(!kibanaUrlsInput.validate()||!elasticsearchUrlInput.validate()||!additionalYamlConfigInput.validate()){return}try{setIsloading(true);if(!outputId){throw new Error("Unable to load outputs")}const outputResponse=await Object(outputs["a"])(outputId,{hosts:elasticsearchUrlInput.value,config_yaml:additionalYamlConfigInput.value});if(outputResponse.error){throw outputResponse.error}const settingsResponse=await Object(hooks["D"])({kibana_urls:kibanaUrlsInput.value});if(settingsResponse.error){throw settingsResponse.error}notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.success.message",{defaultMessage:"Settings saved"}));setIsloading(false);onSuccess()}catch(error){setIsloading(false);notifications.toasts.addError(error,{title:"Error"})}},inputs:{kibanaUrls:kibanaUrlsInput,elasticsearchUrl:elasticsearchUrlInput,additionalYamlConfig:additionalYamlConfigInput}}}const SettingFlyout=({onClose:onClose})=>{var _settingsRequest$data,_outputsRequest$data,_outputsRequest$data$;const settingsRequest=Object(hooks["cb"])();const settings=settingsRequest===null||settingsRequest===void 0?void 0:(_settingsRequest$data=settingsRequest.data)===null||_settingsRequest$data===void 0?void 0:_settingsRequest$data.item;const outputsRequest=Object(outputs["b"])();const output=(_outputsRequest$data=outputsRequest.data)===null||_outputsRequest$data===void 0?void 0:(_outputsRequest$data$=_outputsRequest$data.items)===null||_outputsRequest$data$===void 0?void 0:_outputsRequest$data$[0];const{inputs:inputs,onSubmit:onSubmit,isLoading:isLoading}=useSettingsForm(output===null||output===void 0?void 0:output.id,onClose);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(output){inputs.elasticsearchUrl.setValue(output.hosts||[]);inputs.additionalYamlConfig.setValue(output.config_yaml||`# YAML settings here will be added to the Elasticsearch output section of each policy`)}},[output]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(settings){inputs.kibanaUrls.setValue(settings.kibana_urls)}},[settings]);const body=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{options:[{id:"enabled",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.autoUpgradeEnabledLabel",{defaultMessage:"Automatically update agent binaries to use the latest minor version."})},{id:"disabled",disabled:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.autoUpgradeDisabledLabel",{defaultMessage:"Manually manage agent binary versions. Requires a Gold subscription."})}],idSelected:"enabled",onChange:id=>{},legend:{children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.autoUpgradeFieldLabel",defaultMessage:"Elastic Agent binary version"})))}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRadioGroup"],{options:[{id:"enabled",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.integrationUpgradeEnabledFieldLabel",{defaultMessage:"Automatically update integrations to the latest version to get the latest assets. You might need to update agent policies to use new features."})},{id:"disabled",disabled:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.integrationUpgradeDisabledFieldLabel",{defaultMessage:"Manually manage integration versions yourself."})}],idSelected:"enabled",onChange:id=>{},legend:{children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.integrationUpgradeFieldLabel",defaultMessage:"Integration version"})))}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.globalOutputTitle",defaultMessage:"Global output"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.globalOutputDescription",defaultMessage:"Specify where to send data. These settings are applied to all Elastic Agent policies."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],settings_flyout_extends({label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.kibanaUrlLabel",{defaultMessage:"Kibana URL"})},inputs.kibanaUrls.formRowProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],settings_flyout_extends({noSuggestions:true},inputs.kibanaUrls.props)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],settings_flyout_extends({label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.elasticsearchUrlLabel",{defaultMessage:"Elasticsearch URL"})},inputs.elasticsearchUrl.formRowProps),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],settings_flyout_extends({noSuggestions:true},inputs.elasticsearchUrl.props)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],settings_flyout_extends({},inputs.additionalYamlConfig.formRowProps,{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.settings.additionalYamlConfig",{defaultMessage:"Elasticsearch output configuration"}),fullWidth:true}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],settings_flyout_extends({width:"100%",mode:"yaml",theme:"textmate",setOptions:{minLines:10,maxLines:30,tabSize:2,showGutter:false}},inputs.additionalYamlConfig.props,{onChange:inputs.additionalYamlConfig.setValue})))));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"l",maxWidth:640},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"IngestManagerSettingsFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"IngestManagerSettingsFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.flyoutTitle",defaultMessage:"Fleet settings"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,body),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onClose,flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.cancelButtonLabel",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onSubmit,iconType:"save",isLoading:isLoading},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.settings.saveButtonLabel",defaultMessage:"Save settings"}))))))};function link_and_revision_extends(){link_and_revision_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return link_and_revision_extends.apply(this,arguments)}const MIN_WIDTH={minWidth:0};const NO_WRAP_WHITE_SPACE={whiteSpace:"nowrap"};const LinkAndRevision=Object(external_kbnSharedDeps_React_["memo"])(({revision:revision,className:className,...euiLinkProps})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"baseline",style:MIN_WIDTH,responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textTruncate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],link_and_revision_extends({className:`eui-textTruncate ${className!==null&&className!==void 0?className:""}`},euiLinkProps))),revision&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs",style:NO_WRAP_WHITE_SPACE},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyNameLink.revisionNumber",defaultMessage:"rev. {revNumber}",values:{revNumber:revision}})))));const IntraAppStateContext=external_kbnSharedDeps_React_default.a.createContext({forRoute:""});const wasHandled=new WeakSet;const IntraAppStateProvider=Object(external_kbnSharedDeps_React_["memo"])(({kibanaScopedHistory:kibanaScopedHistory,children:children})=>{const internalAppToAppState=Object(external_kbnSharedDeps_React_["useMemo"])(()=>({forRoute:new URL(`${kibanaScopedHistory.location.hash.substr(1)}`,"http://localhost").pathname,routeState:kibanaScopedHistory.location.state}),[kibanaScopedHistory.location.state,kibanaScopedHistory.location.hash]);return external_kbnSharedDeps_React_default.a.createElement(IntraAppStateContext.Provider,{value:internalAppToAppState},children)});function useIntraAppState(){const location=Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])();const intraAppState=Object(external_kbnSharedDeps_React_["useContext"])(IntraAppStateContext);if(!intraAppState){throw new Error("Hook called outside of IntraAppStateContext")}return Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(location.pathname===intraAppState.forRoute&&!wasHandled.has(intraAppState)){wasHandled.add(intraAppState);return intraAppState.routeState}return location.state},[intraAppState,location.pathname,location.state])}var epm_hooks=__webpack_require__(109);const default_Container=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Container",componentId:"sc-1ascj29-0"})(["min-height:calc( 100vh - ","px );background:",";display:flex;flex-direction:column;"],props=>parseFloat(props.theme.eui.euiHeaderHeightCompensation)*2,props=>props.theme.eui.euiColorEmptyShade);const default_Wrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Wrapper",componentId:"sc-1ascj29-1"})(["display:flex;flex-direction:column;flex:1;"]);const Nav=external_kbnSharedDeps_StyledComponents_default.a.nav.withConfig({displayName:"Nav",componentId:"sc-1ascj29-2"})(["background:",";border-bottom:",";padding:",";.euiTabs{padding-left:3px;margin-left:-3px;}"],props=>props.theme.eui.euiColorEmptyShade,props=>props.theme.eui.euiBorderThin,props=>`${props.theme.eui.euiSize} ${props.theme.eui.euiSizeL} ${props.theme.eui.euiSize} ${props.theme.eui.euiSizeL}`);const DefaultLayout=({showSettings:showSettings=true,section:section,children:children})=>{const{getHref:getHref}=Object(hooks["hb"])();const{agents:agents}=Object(hooks["M"])();const[isSettingsFlyoutOpen,setIsSettingsFlyoutOpen]=external_kbnSharedDeps_React_default.a.useState(false);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isSettingsFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(SettingFlyout,{onClose:()=>{setIsSettingsFlyoutOpen(false)}}),external_kbnSharedDeps_React_default.a.createElement(default_Container,null,external_kbnSharedDeps_React_default.a.createElement(default_Wrapper,null,external_kbnSharedDeps_React_default.a.createElement(Nav,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"l",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],{display:"condensed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:section==="overview",href:getHref("overview")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.overviewLinkText",defaultMessage:"Overview"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:section==="epm",href:getHref("integrations_all")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.epmLinkText",defaultMessage:"Integrations"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:section==="agent_policy",href:getHref("policies_list")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.policiesLinkText",defaultMessage:"Policies"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:section==="fleet",href:getHref("fleet"),disabled:!(agents!==null&&agents!==void 0&&agents.enabled)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.agentsLinkText",defaultMessage:"Agents"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:section==="data_stream",href:getHref("data_streams")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.dataStreamsLinkText",defaultMessage:"Data streams"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",direction:"row"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"popout",href:"https://ela.st/fleet-feedback",target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.sendFeedbackButton",defaultMessage:"Send feedback"}))),showSettings?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"gear",onClick:()=>setIsSettingsFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.appNavigation.settingsButton",defaultMessage:"Settings"}))):null)))),children),external_kbnSharedDeps_React_default.a.createElement(AlphaMessaging,null)))};const Page=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiPage"]).withConfig({displayName:"Page",componentId:"m0w1fb-0"})(["background:",";width:100%;align-self:center;margin-left:0;margin-right:0;flex:1;"],props=>props.theme.eui.euiColorEmptyShade);const ContentWrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"ContentWrapper",componentId:"m0w1fb-1"})(["height:100%;"]);const WithoutHeaderLayout=({restrictWidth:restrictWidth,children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(Page,{restrictWidth:restrictWidth||1200},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(ContentWrapper,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),children))));function with_header_extends(){with_header_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return with_header_extends.apply(this,arguments)}const WithHeaderLayout=({restrictWidth:restrictWidth,restrictHeaderWidth:restrictHeaderWidth,children:children,"data-test-subj":dataTestSubj,...rest})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(Header,with_header_extends({maxWidth:restrictHeaderWidth,"data-test-subj":dataTestSubj?`${dataTestSubj}_header`:undefined},rest)),external_kbnSharedDeps_React_default.a.createElement(Page,{restrictWidth:restrictWidth||1200,"data-test-subj":dataTestSubj?`${dataTestSubj}_page`:undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(ContentWrapper,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),children))));var services=__webpack_require__(107);const AgentPolicyDeleteProvider=({children:children})=>{const{notifications:notifications}=Object(hooks["mb"])();const{agents:{enabled:isFleetEnabled}}=Object(hooks["M"])();const[agentPolicy,setAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])();const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoadingAgentsCount,setIsLoadingAgentsCount]=Object(external_kbnSharedDeps_React_["useState"])(false);const[agentsCount,setAgentsCount]=Object(external_kbnSharedDeps_React_["useState"])(0);const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const deleteAgentPolicyPrompt=(agentPolicyToDelete,onSuccess=(()=>undefined))=>{if(!agentPolicyToDelete){throw new Error("No agent policy specified for deletion")}setIsModalOpen(true);setAgentPolicy(agentPolicyToDelete);fetchAgentsCount(agentPolicyToDelete);onSuccessCallback.current=onSuccess};const closeModal=()=>{setAgentPolicy(undefined);setIsLoading(false);setIsLoadingAgentsCount(false);setIsModalOpen(false)};const deleteAgentPolicy=async()=>{setIsLoading(true);try{const{data:data}=await Object(hooks["h"])({agentPolicyId:agentPolicy});if(data){notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deleteAgentPolicy.successSingleNotificationTitle",{defaultMessage:"Deleted agent policy '{id}'",values:{id:data.name||data.id}}));if(onSuccessCallback.current){onSuccessCallback.current(agentPolicy)}}else{notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deleteAgentPolicy.failureSingleNotificationTitle",{defaultMessage:"Error deleting agent policy '{id}'",values:{id:agentPolicy}}))}}catch(e){notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deleteAgentPolicy.fatalErrorNotificationTitle",{defaultMessage:"Error deleting agent policy"}))}closeModal()};const fetchAgentsCount=async agentPolicyToCheck=>{if(!isFleetEnabled||isLoadingAgentsCount){return}setIsLoadingAgentsCount(true);const{data:data}=await Object(hooks["F"])({path:`/api/fleet/agents`,method:"get",query:{kuery:`${constants["d"]}.policy_id : ${agentPolicyToCheck}`}});setAgentsCount((data===null||data===void 0?void 0:data.total)||0);setIsLoadingAgentsCount(false)};const renderModal=()=>{if(!isModalOpen){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.deletePolicyTitle",defaultMessage:"Delete this agent policy?"}),onCancel:closeModal,onConfirm:deleteAgentPolicy,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:isLoading||isLoadingAgentsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.loadingButtonLabel",defaultMessage:"Loading…"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.confirmButtonLabel",defaultMessage:"Delete policy"}),buttonColor:"danger",confirmButtonDisabled:isLoading||isLoadingAgentsCount||!!agentsCount},isLoadingAgentsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.loadingAgentsCountMessage",defaultMessage:"Checking amount of affected agents…"}):agentsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentsTitle",{defaultMessage:"Policy in use"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.affectedAgentsMessage",defaultMessage:"{agentsCount, plural, one {# agent is} other {# agents are}} assigned to this agent policy. Unassign these agents before deleting this policy.",values:{agentsCount:agentsCount}})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deleteAgentPolicy.confirmModal.irreversibleMessage",defaultMessage:"This action cannot be undone."}))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(deleteAgentPolicyPrompt),renderModal())};const StyledEuiAccordion=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiAccordion"]).withConfig({displayName:"StyledEuiAccordion",componentId:"sc-1njiai8-0"})([".ingest-active-button{color:",";}"],props=>props.theme.eui.euiColorPrimary);const agentPolicyFormValidation=agentPolicy=>{var _agentPolicy$name;const errors={};const namespaceValidation=Object(services["n"])(agentPolicy.namespace||"");if(!((_agentPolicy$name=agentPolicy.name)!==null&&_agentPolicy$name!==void 0&&_agentPolicy$name.trim())){errors.name=[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.nameRequiredErrorMessage",defaultMessage:"Agent policy name is required"})]}if(!namespaceValidation.valid&&namespaceValidation.error){errors.namespace=[namespaceValidation.error]}return errors};const AgentPolicyForm=({agentPolicy:agentPolicy,updateAgentPolicy:updateAgentPolicy,withSysMonitoring:withSysMonitoring,updateSysMonitoring:updateSysMonitoring,validation:validation,isEditing:isEditing=false,onDelete:onDelete=(()=>{})})=>{const[touchedFields,setTouchedFields]=Object(external_kbnSharedDeps_React_["useState"])({});const fields=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{name:"name",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.nameFieldLabel",defaultMessage:"Name"}),placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyForm.nameFieldPlaceholder",{defaultMessage:"Choose a name"})},{name:"description",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.descriptionFieldLabel",defaultMessage:"Description"}),placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyForm.descriptionFieldPlaceholder",{defaultMessage:"How will this policy be used?"})}],[]);const generalSettingsWrapper=children=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyForm.generalSettingsGroupTitle",defaultMessage:"General settings"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyForm.generalSettingsGroupDescription",defaultMessage:"Choose a name and description for your agent policy."})},children);const generalFields=fields.map(({name:name,label:label,placeholder:placeholder})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,key:name,label:label,error:touchedFields[name]&&validation[name]?validation[name]:null,isInvalid:Boolean(touchedFields[name]&&validation[name])},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,value:agentPolicy[name],onChange:e=>updateAgentPolicy({[name]:e.target.value}),isInvalid:Boolean(touchedFields[name]&&validation[name]),onBlur:()=>setTouchedFields({...touchedFields,[name]:true}),placeholder:placeholder})));const advancedOptionsContent=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.namespaceFieldLabel",defaultMessage:"Default namespace"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.namespaceFieldDescription",defaultMessage:"Apply a default namespace to integrations that use this policy. Integrations can specify their own namespaces."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,error:touchedFields.namespace&&validation.namespace?validation.namespace:null,isInvalid:Boolean(touchedFields.namespace&&validation.namespace)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{fullWidth:true,singleSelection:true,noSuggestions:true,selectedOptions:agentPolicy.namespace?[{label:agentPolicy.namespace}]:[],onCreateOption:value=>{updateAgentPolicy({namespace:value})},onChange:selectedOptions=>{updateAgentPolicy({namespace:selectedOptions.length?selectedOptions[0]:""})},isInvalid:Boolean(touchedFields.namespace&&validation.namespace),onBlur:()=>setTouchedFields({...touchedFields,namespace:true})}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.monitoringLabel",defaultMessage:"Agent monitoring"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.monitoringDescription",defaultMessage:"Collect data about your agents for debugging and tracking performance."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckboxGroup"],{options:[{id:common["dataTypes"].Logs,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.monitoringLogsFieldLabel",defaultMessage:"Collect agent logs"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyForm.monitoringLogsTooltipText",{defaultMessage:"Collect logs from Elastic Agents that use this policy."}),position:"right",type:"iInCircle",color:"subdued"}))},{id:common["dataTypes"].Metrics,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.monitoringMetricsFieldLabel",defaultMessage:"Collect agent metrics"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyForm.monitoringMetricsTooltipText",{defaultMessage:"Collect metrics from Elastic Agents that use this policy."}),position:"right",type:"iInCircle",color:"subdued"}))}],idToSelectedMap:(agentPolicy.monitoring_enabled||[]).reduce((acc,key)=>{acc[key]=true;return acc},{logs:false,metrics:false}),onChange:id=>{if(id!==common["dataTypes"].Logs&&id!==common["dataTypes"].Metrics){return}const hasLogs=agentPolicy.monitoring_enabled&&agentPolicy.monitoring_enabled.indexOf(id)>=0;const previousValues=agentPolicy.monitoring_enabled||[];updateAgentPolicy({monitoring_enabled:hasLogs?previousValues.filter(type=>type!==id):[...previousValues,id]})}})),isEditing&&"id"in agentPolicy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyForm.deletePolicyGroupTitle",defaultMessage:"Delete policy"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyForm.deletePolicyGroupDescription",defaultMessage:"Existing data will not be deleted."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(AgentPolicyDeleteProvider,null,deleteAgentPolicyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"danger",disabled:Boolean(agentPolicy.is_default),onClick:()=>deleteAgentPolicyPrompt(agentPolicy.id,onDelete)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyForm.deletePolicyActionText",defaultMessage:"Delete policy"}))),agentPolicy.is_default?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyForm.unableToDeleteDefaultPolicyText",defaultMessage:"Default policy cannot be deleted"}))):null)}):null);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,!isEditing?generalFields:generalSettingsWrapper(generalFields),!isEditing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.systemMonitoringFieldLabel",defaultMessage:"System monitoring"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{id:"agentPolicyFormSystemMonitoringCheckbox",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.systemMonitoringText",defaultMessage:"Collect system metrics"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyForm.systemMonitoringTooltipText",{defaultMessage:"Enable this option to bootstrap your policy with an integration that collects system metrics and information."}),position:"right",type:"iInCircle",color:"subdued"})),checked:withSysMonitoring,onChange:()=>{updateSysMonitoring(!withSysMonitoring)}})):null,!isEditing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}),external_kbnSharedDeps_React_default.a.createElement(StyledEuiAccordion,{id:"advancedOptions",buttonContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyForm.advancedOptionsToggleLabel",defaultMessage:"Advanced options"}),buttonClassName:"ingest-active-button"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),advancedOptionsContent)):advancedOptionsContent)};const AgentPolicyCopyProvider=({children:children})=>{const{notifications:notifications}=Object(hooks["mb"])();const[agentPolicy,setAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])();const[newAgentPolicy,setNewAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])();const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const copyAgentPolicyPrompt=(agentPolicyToCopy,onSuccess=(()=>undefined))=>{if(!agentPolicyToCopy){throw new Error("No agent policy specified to copy")}setIsModalOpen(true);setAgentPolicy(agentPolicyToCopy);setNewAgentPolicy({name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.copyAgentPolicy.confirmModal.defaultNewPolicyName",{defaultMessage:"{name} (copy)",values:{name:agentPolicyToCopy.name}}),description:agentPolicyToCopy.description});onSuccessCallback.current=onSuccess};const closeModal=()=>{setAgentPolicy(undefined);setNewAgentPolicy(undefined);setIsLoading(false);setIsModalOpen(false)};const copyAgentPolicy=async()=>{setIsLoading(true);try{const{data:data}=await Object(hooks["e"])(agentPolicy.id,newAgentPolicy);if(data){notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.copyAgentPolicy.successNotificationTitle",{defaultMessage:"Agent policy copied"}));if(onSuccessCallback.current){onSuccessCallback.current(data.item)}}else{notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.copyAgentPolicy.failureNotificationTitle",{defaultMessage:"Error copying agent policy '{id}'",values:{id:agentPolicy.id}}))}}catch(e){notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.copyAgentPolicy.fatalErrorNotificationTitle",{defaultMessage:"Error copying agent policy"}))}closeModal()};const renderModal=()=>{if(!isModalOpen||!agentPolicy||!newAgentPolicy){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textBreakWord"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.copyAgentPolicy.confirmModal.copyPolicyTitle",defaultMessage:"Copy '{name}' agent policy",values:{name:agentPolicy.name}})),onCancel:closeModal,onConfirm:copyAgentPolicy,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.copyAgentPolicy.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.copyAgentPolicy.confirmModal.confirmButtonLabel",defaultMessage:"Copy policy"}),confirmButtonDisabled:isLoading||!newAgentPolicy.name.trim()},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.copyAgentPolicy.confirmModal.copyPolicyPrompt",defaultMessage:"Choose a name and description for your new agent policy."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.copyAgentPolicy.confirmModal.newNameLabel",defaultMessage:"New policy name"}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,value:newAgentPolicy.name,onChange:e=>setNewAgentPolicy({...newAgentPolicy,name:e.target.value})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.copyAgentPolicy.confirmModal.newDescriptionLabel",defaultMessage:"Description"}),fullWidth:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{fullWidth:true,value:newAgentPolicy.description,onChange:e=>setNewAgentPolicy({...newAgentPolicy,description:e.target.value})})))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(copyAgentPolicyPrompt),renderModal())};const PackagePolicyDeleteProvider=({agentPolicy:agentPolicy,children:children})=>{const{notifications:notifications}=Object(hooks["mb"])();const{agents:{enabled:isFleetEnabled}}=Object(hooks["M"])();const[packagePolicies,setPackagePolicies]=Object(external_kbnSharedDeps_React_["useState"])([]);const[isModalOpen,setIsModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoadingAgentsCount,setIsLoadingAgentsCount]=Object(external_kbnSharedDeps_React_["useState"])(false);const[agentsCount,setAgentsCount]=Object(external_kbnSharedDeps_React_["useState"])(0);const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const onSuccessCallback=Object(external_kbnSharedDeps_React_["useRef"])(null);const fetchAgentsCount=Object(external_kbnSharedDeps_React_["useMemo"])(()=>async()=>{if(isLoadingAgentsCount||!isFleetEnabled){return}setIsLoadingAgentsCount(true);const{data:data}=await Object(hooks["F"])({path:constants["b"].LIST_PATTERN,method:"get",query:{page:1,perPage:1,kuery:`${constants["d"]}.policy_id : ${agentPolicy.id}`}});setAgentsCount((data===null||data===void 0?void 0:data.total)||0);setIsLoadingAgentsCount(false)},[agentPolicy.id,isFleetEnabled,isLoadingAgentsCount]);const deletePackagePoliciesPrompt=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(packagePoliciesToDelete,onSuccess=(()=>undefined))=>{if(!Array.isArray(packagePoliciesToDelete)||packagePoliciesToDelete.length===0){throw new Error("No package policies specified for deletion")}setIsModalOpen(true);setPackagePolicies(packagePoliciesToDelete);fetchAgentsCount();onSuccessCallback.current=onSuccess},[fetchAgentsCount]);const closeModal=Object(external_kbnSharedDeps_React_["useMemo"])(()=>()=>{setPackagePolicies([]);setIsLoading(false);setIsLoadingAgentsCount(false);setIsModalOpen(false)},[]);const deletePackagePolicies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>async()=>{setIsLoading(true);try{const{data:data}=await Object(hooks["j"])({packagePolicyIds:packagePolicies});const successfulResults=(data===null||data===void 0?void 0:data.filter(result=>result.success))||[];const failedResults=(data===null||data===void 0?void 0:data.filter(result=>!result.success))||[];if(successfulResults.length){const hasMultipleSuccesses=successfulResults.length>1;const successMessage=hasMultipleSuccesses?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deletePackagePolicy.successMultipleNotificationTitle",{defaultMessage:"Deleted {count} integrations",values:{count:successfulResults.length}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deletePackagePolicy.successSingleNotificationTitle",{defaultMessage:"Deleted integration '{id}'",values:{id:successfulResults[0].name||successfulResults[0].id}});notifications.toasts.addSuccess(successMessage)}if(failedResults.length){const hasMultipleFailures=failedResults.length>1;const failureMessage=hasMultipleFailures?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deletePackagePolicy.failureMultipleNotificationTitle",{defaultMessage:"Error deleting {count} integrations",values:{count:failedResults.length}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deletePackagePolicy.failureSingleNotificationTitle",{defaultMessage:"Error deleting integration '{id}'",values:{id:failedResults[0].id}});notifications.toasts.addDanger(failureMessage)}if(onSuccessCallback.current){onSuccessCallback.current(successfulResults.map(result=>result.id))}}catch(e){notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.deletePackagePolicy.fatalErrorNotificationTitle",{defaultMessage:"Error deleting integration"}))}closeModal()},[closeModal,packagePolicies,notifications.toasts]);const renderModal=()=>{if(!isModalOpen){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.deleteMultipleTitle",defaultMessage:"Delete {count, plural, one {integration} other {# integrations}}?",values:{count:packagePolicies.length}}),onCancel:closeModal,onConfirm:deletePackagePolicies,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:isLoading||isLoadingAgentsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.loadingButtonLabel",defaultMessage:"Loading…"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.confirmButtonLabel",defaultMessage:"Delete {agentPoliciesCount, plural, one {integration} other {integrations}}",values:{agentPoliciesCount:packagePolicies.length}}),buttonColor:"danger",confirmButtonDisabled:isLoading||isLoadingAgentsCount},isLoadingAgentsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.loadingAgentsCountMessage",defaultMessage:"Checking affected agents…"}):agentsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentsTitle",defaultMessage:"This action will affect {agentsCount} {agentsCount, plural, one {agent} other {agents}}.",values:{agentsCount:agentsCount}})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.affectedAgentsMessage",defaultMessage:"Fleet has detected that {agentPolicyName} is already in use by some of your agents.",values:{agentPolicyName:external_kbnSharedDeps_React_default.a.createElement("strong",null,agentPolicy.name)}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})):null,!isLoadingAgentsCount&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.deletePackagePolicy.confirmModal.generalMessage",defaultMessage:"This action can not be undone. Are you sure you wish to continue?"}))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,children(deletePackagePoliciesPrompt),renderModal())};const FlyoutBody=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"]).withConfig({displayName:"FlyoutBody",componentId:"l5rkdh-0"})([".euiFlyoutBody__overflowContent{padding:0;}"]);const AgentPolicyYamlFlyout=Object(external_kbnSharedDeps_React_["memo"])(({policyId:policyId,onClose:onClose})=>{const core=Object(hooks["mb"])();const{isLoading:isLoadingYaml,data:yamlData,error:error}=Object(hooks["W"])(policyId);const{data:agentPolicyData}=Object(hooks["V"])(policyId);const body=isLoadingYaml?external_kbnSharedDeps_React_default.a.createElement(Loading,null):error?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.ErrorGettingFullAgentPolicy",defaultMessage:"Error loading agent policy"}),color:"danger",iconType:"alert"},error.message):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"yaml",isCopyable:true,fontSize:"m",whiteSpace:"pre"},Object(services["j"])(yamlData.item));const downloadLink=core.http.basePath.prepend(services["b"].getInfoFullDownloadPath(policyId));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"l",maxWidth:640},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"IngestManagerAgentPolicyYamlFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"IngestManagerAgentPolicyYamlFlyoutTitle"},agentPolicyData!==null&&agentPolicyData!==void 0&&agentPolicyData.item?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.yamlflyoutTitleWithName",defaultMessage:"'{name}' agent policy",values:{name:agentPolicyData.item.name}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.yamlflyoutTitleWithoutName",defaultMessage:"Agent policy"})))),external_kbnSharedDeps_React_default.a.createElement(FlyoutBody,null,body),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onClose,flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.yamlFlyoutCloseButtonLabel",defaultMessage:"Close"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{href:downloadLink,iconType:"download",isDisabled:Boolean(isLoadingYaml&&!yamlData)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.yamlDownloadButtonLabel",defaultMessage:"Download policy"}))))))});function linked_agent_count_extends(){linked_agent_count_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return linked_agent_count_extends.apply(this,arguments)}const LinkedAgentCount=Object(external_kbnSharedDeps_React_["memo"])(({count:count,agentPolicyId:agentPolicyId,...otherEuiLinkProps})=>{const{getHref:getHref}=Object(hooks["hb"])();return count>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],linked_agent_count_extends({},otherEuiLinkProps,{href:getHref("fleet_agent_list",{kuery:`${constants["d"]}.policy_id : ${agentPolicyId}`})}),count):external_kbnSharedDeps_React_default.a.createElement("span",{"data-test-subj":otherEuiLinkProps["data-test-subj"],className:otherEuiLinkProps.className},count)});const ConfirmDeployAgentPolicyModal=({onConfirm:onConfirm,onCancel:onCancel,agentCount:agentCount,agentPolicy:agentPolicy})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicy.confirmModalTitle",defaultMessage:"Save and deploy changes"}),onCancel:onCancel,onConfirm:onConfirm,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicy.confirmModalCancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicy.confirmModalConfirmButtonLabel",defaultMessage:"Save and deploy changes"}),buttonColor:"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{iconType:"iInCircle",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicy.confirmModalCalloutTitle",{defaultMessage:"This action will update {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:agentCount}})},external_kbnSharedDeps_React_default.a.createElement("div",{className:"eui-textBreakWord"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicy.confirmModalCalloutDescription",defaultMessage:"Fleet has detected that the selected agent policy, {policyName}, is already in use by some of your agents. As a result of this action, Fleet will deploy updates to all agents that use this policy.",values:{policyName:external_kbnSharedDeps_React_default.a.createElement("b",null,agentPolicy.name)}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicy.confirmModalDescription",defaultMessage:"This action can not be undone. Are you sure you wish to continue?"}));const DangerEuiContextMenuItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"]).withConfig({displayName:"DangerEuiContextMenuItem",componentId:"sc-1kxx75b-0"})(["color:",";"],props=>props.theme.eui.euiTextColors.danger);const loading_Loading=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"})));const AgentPolicyPackageBadges=({agentPolicyId:agentPolicyId,hideTitle:hideTitle})=>{const agentPolicyRequest=Object(hooks["V"])(agentPolicyId);const agentPolicy=agentPolicyRequest.data?agentPolicyRequest.data.item:null;const packages=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!agentPolicy){return}const uniquePackages=new Map;agentPolicy.package_policies.forEach(({package:pkg})=>{if(!pkg){return}if(!uniquePackages.has(pkg.name)||uniquePackages.get(pkg.name).version<pkg.version){uniquePackages.set(pkg.name,pkg)}});return[...uniquePackages.values()]},[agentPolicy]);if(!agentPolicy||!packages){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!hideTitle&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentReassignPolicy.policyDescription",defaultMessage:"The selected agent policy will collect data for {count, plural, one {{countValue} integration} other {{countValue} integrations}}:",values:{count:packages.length,countValue:external_kbnSharedDeps_React_default.a.createElement("b",null,packages.length)}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"})),packages.map((pkg,idx)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{key:idx,color:"hollow"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"row",gutterSize:"xs",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{packageName:pkg.name,version:pkg.version,size:"s",tryApi:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},pkg.title)))))};const AgentReassignAgentPolicyFlyout=({onClose:onClose,agents:agents})=>{const{notifications:notifications}=Object(hooks["mb"])();const isSingleAgent=Array.isArray(agents)&&agents.length===1;const[selectedAgentPolicyId,setSelectedAgentPolicyId]=Object(external_kbnSharedDeps_React_["useState"])(isSingleAgent?agents[0].policy_id:undefined);const agentPoliciesRequest=Object(hooks["O"])({page:1,perPage:1e3});const agentPolicies=agentPoliciesRequest.data?agentPoliciesRequest.data.items:[];Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!selectedAgentPolicyId&&agentPolicies[0]){setSelectedAgentPolicyId(agentPolicies[0].id)}},[agentPolicies,selectedAgentPolicyId]);const[isSubmitting,setIsSubmitting]=Object(external_kbnSharedDeps_React_["useState"])(false);async function onSubmit(){try{setIsSubmitting(true);if(!selectedAgentPolicyId){throw new Error("No selected agent policy id")}const res=isSingleAgent?await Object(hooks["C"])(agents[0].id,{policy_id:selectedAgentPolicyId}):await Object(hooks["y"])({policy_id:selectedAgentPolicyId,agents:Array.isArray(agents)?agents.map(agent=>agent.id):agents});if(res.error){throw res.error}setIsSubmitting(false);const successMessage=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentReassignPolicy.successSingleNotificationTitle",{defaultMessage:"Agent policy reassigned"});notifications.toasts.addSuccess(successMessage);onClose()}catch(error){setIsSubmitting(false);notifications.toasts.addError(error,{title:"Unable to reassign agent policy"})}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"l",maxWidth:640},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"FleetAgentReassigmentFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"FleetAgentReassigmentFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentReassignPolicy.flyoutTitle",defaultMessage:"Assign new agent policy"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentReassignPolicy.flyoutDescription",defaultMessage:"Choose a new agent policy to assign the selected {count, plural, one {agent} other {agents}} to.",values:{count:isSingleAgent?1:0}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{fullWidth:true,label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentReassignPolicy.selectPolicyLabel",{defaultMessage:"Agent policy"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{fullWidth:true,isLoading:agentPoliciesRequest.isLoading,options:agentPolicies.map(agentPolicy=>({value:agentPolicy.id,text:agentPolicy.name})),value:selectedAgentPolicyId,onChange:e=>setSelectedAgentPolicyId(e.target.value)})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),selectedAgentPolicyId&&external_kbnSharedDeps_React_default.a.createElement(AgentPolicyPackageBadges,{agentPolicyId:selectedAgentPolicyId})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onClose,flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentReassignPolicy.cancelButtonLabel",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{disabled:isSingleAgent&&selectedAgentPolicyId===agents[0].policy_id,fill:true,onClick:onSubmit,isLoading:isSubmitting},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentReassignPolicy.continueButtonLabel",defaultMessage:"Assign policy"}))))))};const CommandCode=external_kbnSharedDeps_StyledComponents_default.a.pre.withConfig({displayName:"CommandCode",componentId:"sc-1hf7c98-0"})({overflow:"scroll"});const ManualInstructions=({kibanaUrl:kibanaUrl,apiKey:apiKey,kibanaCASha256:kibanaCASha256})=>{const enrollArgs=`--kibana-url=${kibanaUrl} --enrollment-token=${apiKey.api_key}${kibanaCASha256?` --ca_sha256=${kibanaCASha256}`:""}`;const linuxMacCommand=`./elastic-agent install -f ${enrollArgs}`;const windowsCommand=`.\\elastic-agent.exe install -f ${enrollArgs}`;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentInstructions.descriptionText",defaultMessage:"From the agent directory, run the appropriate command to install, enroll, and start an Elastic Agent. You can reuse these commands to set up agents on more than one host. Requires administrator privileges."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentInstructions.linuxMacOSTitle",defaultMessage:"Linux, macOS"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{fontSize:"m",isCopyable:true,paddingSize:"m"},external_kbnSharedDeps_React_default.a.createElement(CommandCode,null,linuxMacCommand)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentInstructions.windowsTitle",defaultMessage:"Windows"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{fontSize:"m",isCopyable:true,paddingSize:"m"},external_kbnSharedDeps_React_default.a.createElement(CommandCode,null,windowsCommand)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentInstructions.moreInstructionsText",defaultMessage:"See the {link} for RPM / DEB deploy instructions.",values:{link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{target:"_blank",external:true,href:"https://www.elastic.co/guide/en/fleet/current/elastic-agent-installation-configuration.html"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentInstructions.moreInstructionsLink",defaultMessage:"Elastic Agent docs"}))}})))};const EnrollmentStepAgentPolicy=props=>{const{notifications:notifications}=Object(hooks["mb"])();const{withKeySelection:withKeySelection,agentPolicies:agentPolicies,onAgentPolicyChange:onAgentPolicyChange}=props;const onKeyChange=props.withKeySelection&&props.onKeyChange;const[isAuthenticationSettingsOpen,setIsAuthenticationSettingsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[enrollmentAPIKeys,setEnrollmentAPIKeys]=Object(external_kbnSharedDeps_React_["useState"])([]);const[selectedState,setSelectedState]=Object(external_kbnSharedDeps_React_["useState"])({});Object(external_kbnSharedDeps_React_["useEffect"])((function triggerOnAgentPolicyChangeEffect(){if(onAgentPolicyChange&&selectedState.agentPolicyId){onAgentPolicyChange(selectedState.agentPolicyId)}}),[selectedState.agentPolicyId,onAgentPolicyChange]);Object(external_kbnSharedDeps_React_["useEffect"])((function triggerOnKeyChangeEffect(){if(!withKeySelection||!onKeyChange){return}if(selectedState.enrollmentAPIKeyId){onKeyChange(selectedState.enrollmentAPIKeyId)}}),[withKeySelection,onKeyChange,selectedState.enrollmentAPIKeyId]);Object(external_kbnSharedDeps_React_["useEffect"])((function useDefaultAgentPolicyEffect(){if(agentPolicies&&agentPolicies.length&&!selectedState.agentPolicyId){if(agentPolicies.length===1){setSelectedState({...selectedState,agentPolicyId:agentPolicies[0].id});return}const defaultAgentPolicy=agentPolicies.find(agentPolicy=>agentPolicy.is_default);if(defaultAgentPolicy){setSelectedState({...selectedState,agentPolicyId:defaultAgentPolicy.id})}}}),[agentPolicies,selectedState]);Object(external_kbnSharedDeps_React_["useEffect"])((function useEnrollmentKeysForAgentPolicyEffect(){if(!withKeySelection){return}if(!selectedState.agentPolicyId){setEnrollmentAPIKeys([]);return}async function fetchEnrollmentAPIKeys(){try{const res=await Object(hooks["m"])({page:1,perPage:constants["l"]});if(res.error){throw res.error}if(!res.data){throw new Error("No data while fetching enrollment API keys")}setEnrollmentAPIKeys(res.data.list.filter(key=>key.policy_id===selectedState.agentPolicyId&&key.active===true))}catch(error){notifications.toasts.addError(error,{title:"Error"})}}fetchEnrollmentAPIKeys()}),[withKeySelection,selectedState.agentPolicyId,notifications.toasts]);Object(external_kbnSharedDeps_React_["useEffect"])((function useDefaultEnrollmentKeyForAgentPolicyEffect(){if(!withKeySelection){return}if(!selectedState.enrollmentAPIKeyId&&enrollmentAPIKeys.length>0&&enrollmentAPIKeys[0].policy_id===selectedState.agentPolicyId){const enrollmentAPIKeyId=enrollmentAPIKeys[0].id;setSelectedState({agentPolicyId:selectedState.agentPolicyId,enrollmentAPIKeyId:enrollmentAPIKeyId})}}),[withKeySelection,enrollmentAPIKeys,selectedState.enrollmentAPIKeyId,selectedState.agentPolicyId]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{fullWidth:true,prepend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentStepAgentPolicy.policySelectLabel",defaultMessage:"Agent policy"})),isLoading:!agentPolicies,options:(agentPolicies||[]).map(agentPolicy=>({value:agentPolicy.id,text:agentPolicy.name})),value:selectedState.agentPolicyId||undefined,onChange:e=>setSelectedState({agentPolicyId:e.target.value,enrollmentAPIKeyId:undefined}),"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentStepAgentPolicy.policySelectAriaLabel",{defaultMessage:"Agent policy"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),selectedState.agentPolicyId&&external_kbnSharedDeps_React_default.a.createElement(AgentPolicyPackageBadges,{agentPolicyId:selectedState.agentPolicyId}),withKeySelection&&onKeyChange&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{flush:"left",iconType:isAuthenticationSettingsOpen?"arrowDown":"arrowRight",onClick:()=>setIsAuthenticationSettingsOpen(!isAuthenticationSettingsOpen)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentStepAgentPolicy.showAuthenticationSettingsButton",defaultMessage:"Authentication settings"})),isAuthenticationSettingsOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{fullWidth:true,options:enrollmentAPIKeys.map(key=>({value:key.id,text:key.name})),value:selectedState.enrollmentAPIKeyId||undefined,prepend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentStepAgentPolicy.enrollmentTokenSelectLabel",defaultMessage:"Enrollment token"})),onChange:e=>{setSelectedState({...selectedState,enrollmentAPIKeyId:e.target.value})}}))))};const DownloadStep=()=>({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentEnrollment.stepDownloadAgentTitle",{defaultMessage:"Download the Elastic Agent to your host"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.downloadDescription",defaultMessage:"You can download the agent binaries and their verification signatures from the Elastic Agent download page."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{href:"https://ela.st/download-elastic-agent",target:"_blank",iconSide:"right",iconType:"popout"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.downloadLink",defaultMessage:"Go to download page"})))});const AgentPolicySelectionStep=({agentPolicies:agentPolicies,setSelectedAPIKeyId:setSelectedAPIKeyId,setSelectedPolicyId:setSelectedPolicyId})=>({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentEnrollment.stepChooseAgentPolicyTitle",{defaultMessage:"Choose an agent policy"}),children:external_kbnSharedDeps_React_default.a.createElement(EnrollmentStepAgentPolicy,{agentPolicies:agentPolicies,withKeySelection:setSelectedAPIKeyId?true:false,onKeyChange:setSelectedAPIKeyId,onAgentPolicyChange:setSelectedPolicyId})});const ManagedInstructions=external_kbnSharedDeps_React_default.a.memo(({agentPolicies:agentPolicies})=>{var _settings$data,_settings$data$item,_settings$data2,_settings$data2$item;const{getHref:getHref}=Object(hooks["hb"])();const core=Object(hooks["mb"])();const fleetStatus=Object(hooks["N"])();const[selectedAPIKeyId,setSelectedAPIKeyId]=Object(external_kbnSharedDeps_React_["useState"])();const settings=Object(hooks["cb"])();const apiKey=Object(hooks["X"])(selectedAPIKeyId);const kibanaUrlsSettings=(_settings$data=settings.data)===null||_settings$data===void 0?void 0:(_settings$data$item=_settings$data.item)===null||_settings$data$item===void 0?void 0:_settings$data$item.kibana_urls;const kibanaUrl=kibanaUrlsSettings?kibanaUrlsSettings[0]:`${window.location.origin}${core.http.basePath.get()}`;const kibanaCASha256=(_settings$data2=settings.data)===null||_settings$data2===void 0?void 0:(_settings$data2$item=_settings$data2.item)===null||_settings$data2$item===void 0?void 0:_settings$data2$item.kibana_ca_sha256;const steps=[DownloadStep(),AgentPolicySelectionStep({agentPolicies:agentPolicies,setSelectedAPIKeyId:setSelectedAPIKeyId}),{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentEnrollment.stepEnrollAndRunAgentTitle",{defaultMessage:"Enroll and start the Elastic Agent"}),children:apiKey.data&&external_kbnSharedDeps_React_default.a.createElement(ManualInstructions,{apiKey:apiKey.data.item,kibanaUrl:kibanaUrl,kibanaCASha256:kibanaCASha256})}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.managedDescription",defaultMessage:"Enroll an Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),fleetStatus.isReady?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSteps"],{steps:steps})):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.agentsNotInitializedText",defaultMessage:"Before enrolling agents, {link}.",values:{link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getHref("fleet")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.setUpAgentsLink",defaultMessage:"set up central management for Elastic Agents"}))}})))});const RUN_INSTRUCTIONS="./elastic-agent install";const StandaloneInstructions=external_kbnSharedDeps_React_default.a.memo(({agentPolicies:agentPolicies})=>{const{getHref:getHref}=Object(hooks["hb"])();const core=Object(hooks["mb"])();const{notifications:notifications}=core;const[selectedPolicyId,setSelectedPolicyId]=Object(external_kbnSharedDeps_React_["useState"])();const[fullAgentPolicy,setFullAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])();const downloadLink=selectedPolicyId?core.http.basePath.prepend(`${services["b"].getInfoFullDownloadPath(selectedPolicyId)}?standalone=true`):undefined;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{async function fetchFullPolicy(){try{if(!selectedPolicyId){return}const res=await Object(hooks["p"])(selectedPolicyId,{standalone:true});if(res.error){throw res.error}if(!res.data){throw new Error("No data while fetching full agent policy")}setFullAgentPolicy(res.data.item)}catch(error){notifications.toasts.addError(error,{title:"Error"})}}fetchFullPolicy()},[selectedPolicyId,notifications.toasts]);const yaml=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(services["j"])(fullAgentPolicy),[fullAgentPolicy]);const steps=[DownloadStep(),AgentPolicySelectionStep({agentPolicies:agentPolicies,setSelectedPolicyId:setSelectedPolicyId}),{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentEnrollment.stepConfigureAgentTitle",{defaultMessage:"Configure the agent"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.stepConfigureAgentDescription",defaultMessage:"Copy this policy to the {fileName} on the host where the Elastic Agent is installed. Modify {ESUsernameVariable} and {ESPasswordVariable} in the {outputSection} section of {fileName} to use your Elasticsearch credentials.",values:{fileName:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"elastic-agent.yml"),ESUsernameVariable:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"ES_USERNAME"),ESPasswordVariable:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"ES_PASSWORD"),outputSection:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"outputs")}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCopy"],{textToCopy:yaml},copy=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:copy,iconType:"copyClipboard"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.copyPolicyButton",defaultMessage:"Copy to clipboard"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"download",href:downloadLink,isDisabled:!downloadLink},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.downloadPolicyButton",defaultMessage:"Download policy"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"yaml",style:{maxHeight:300},fontSize:"m"},yaml)))},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentEnrollment.stepRunAgentTitle",{defaultMessage:"Start the agent"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.stepRunAgentDescription",defaultMessage:"From the agent directory, run this command to install, enroll and start an Elastic Agent. You can reuse this command to set up agents on more than one host. Requires administrator privileges."}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{fontSize:"m"},RUN_INSTRUCTIONS),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCopy"],{textToCopy:RUN_INSTRUCTIONS},copy=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:copy,iconType:"copyClipboard"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.copyRunInstructionsButton",defaultMessage:"Copy to clipboard"})))))},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentEnrollment.stepCheckForDataTitle",{defaultMessage:"Check for data"}),children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.stepCheckForDataDescription",defaultMessage:"The agent should begin sending data. Go to {link} to view your data.",values:{link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getHref("data_streams")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.goToDataStreamsLink",defaultMessage:"data streams"}))}})))}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.standaloneDescription",defaultMessage:"Run an Elastic Agent standalone to configure and update the agent manually on the host where the agent is installed."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSteps"],{steps:steps}))});const AgentEnrollmentFlyout=({onClose:onClose,agentPolicies:agentPolicies})=>{const[mode,setMode]=Object(external_kbnSharedDeps_React_["useState"])("managed");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"l",maxWidth:880},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"FleetAgentEnrollmentFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"FleetAgentEnrollmentFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.flyoutTitle",defaultMessage:"Add agent"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.agentDescription",defaultMessage:"Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],{style:{marginBottom:"-25px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:mode==="managed",onClick:()=>setMode("managed")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.enrollFleetTabLabel",defaultMessage:"Enroll in Fleet"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:mode==="standalone",onClick:()=>setMode("standalone")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.enrollStandaloneTabLabel",defaultMessage:"Run standalone"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,mode==="managed"?external_kbnSharedDeps_React_default.a.createElement(ManagedInstructions,{agentPolicies:agentPolicies}):external_kbnSharedDeps_React_default.a.createElement(StandaloneInstructions,{agentPolicies:agentPolicies})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onClose,flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.cancelButtonLabel",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,onClick:onClose},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentEnrollment.continueButtonLabel",defaultMessage:"Continue"}))))))};const Status={Healthy:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"secondary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.healthyStatusText",defaultMessage:"Healthy"})),Offline:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"default"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.offlineStatusText",defaultMessage:"Offline"})),Inactive:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"default"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.inactiveStatusText",defaultMessage:"Inactive"})),Unhealthy:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"warning"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.unhealthyStatusText",defaultMessage:"Unhealthy"})),Updating:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"primary"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.updatingStatusText",defaultMessage:"Updating"}))};function getStatusComponent(agent){switch(agent.status){case"warning":case"error":case"degraded":return Status.Unhealthy;case"inactive":return Status.Inactive;case"offline":return Status.Offline;case"unenrolling":case"enrolling":case"updating":return Status.Updating;default:return Status.Healthy}}const AgentHealth=({agent:agent})=>{const{last_checkin:lastCheckIn}=agent;const msLastCheckIn=new Date(lastCheckIn||0).getTime();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"top",content:msLastCheckIn?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.checkInTooltipText",defaultMessage:"Last checked in {lastCheckIn}",values:{lastCheckIn:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedRelative"],{value:msLastCheckIn})}}),agent.current_error_events.map((event,idx)=>external_kbnSharedDeps_React_default.a.createElement("p",{key:idx},event.message))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentHealth.noCheckInTooltipText",defaultMessage:"Never checked in"})},getStatusComponent(agent))};const AgentUnenrollAgentModal=({onClose:onClose,agents:agents,agentCount:agentCount,useForceUnenroll:useForceUnenroll})=>{const{notifications:notifications}=Object(hooks["mb"])();const[forceUnenroll,setForceUnenroll]=Object(external_kbnSharedDeps_React_["useState"])(useForceUnenroll||false);const[isSubmitting,setIsSubmitting]=Object(external_kbnSharedDeps_React_["useState"])(false);const isSingleAgent=Array.isArray(agents)&&agents.length===1;async function onSubmit(){try{setIsSubmitting(true);const{error:error}=isSingleAgent?await Object(hooks["w"])(agents[0].id,{force:forceUnenroll}):await Object(hooks["z"])({agents:Array.isArray(agents)?agents.map(agent=>agent.id):agents,force:forceUnenroll});if(error){throw error}setIsSubmitting(false);if(forceUnenroll){const successMessage=isSingleAgent?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.unenrollAgents.successForceSingleNotificationTitle",{defaultMessage:"Agent unenrolled"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.unenrollAgents.successForceMultiNotificationTitle",{defaultMessage:"Agents unenrolled"});notifications.toasts.addSuccess(successMessage)}else{const successMessage=isSingleAgent?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.unenrollAgents.successSingleNotificationTitle",{defaultMessage:"Unenrolling agent"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.unenrollAgents.successMultiNotificationTitle",{defaultMessage:"Unenrolling agents"});notifications.toasts.addSuccess(successMessage)}onClose()}catch(error){setIsSubmitting(false);notifications.toasts.addError(error,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.unenrollAgents.fatalErrorNotificationTitle",{defaultMessage:"Error unenrolling {count, plural, one {agent} other {agents}}",values:{count:agentCount}})})}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:isSingleAgent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.deleteSingleTitle",defaultMessage:"Unenroll agent"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.forceDeleteMultipleTitle",defaultMessage:"Unenroll {count} agents",values:{count:agentCount}}),onCancel:onClose,onConfirm:onSubmit,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonDisabled:isSubmitting,confirmButtonText:isSingleAgent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.confirmSingleButtonLabel",defaultMessage:"Unenroll agent"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.confirmMultipleButtonLabel",defaultMessage:"Unenroll {count} agents",values:{count:agentCount}}),buttonColor:"danger"},external_kbnSharedDeps_React_default.a.createElement("p",null,isSingleAgent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.deleteSingleDescription",defaultMessage:'This action will remove the selected agent running on "{hostName}" from Fleet. Any data that was already sent by the agent will not be deleted. This action cannot be undone.',values:{hostName:agents[0].local_metadata.host.hostname}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.deleteMultipleDescription",defaultMessage:"This action will remove multiple agents from Fleet and prevent new data from being ingested. Any data that was already sent by these agents will not be affected. This action cannot be undone."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormFieldset"],{legend:{children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.forceUnenrollLegendText",defaultMessage:"Force unenroll {count, plural, one {agent} other {agents}}",values:{count:agentCount}})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCheckbox"],{id:"fleetForceUnenrollAgents",label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.unenrollAgents.forceUnenrollCheckboxLabel",defaultMessage:"Remove {count, plural, one {agent} other {agents}} immediately. Do not wait for agent to send any last data.",values:{count:agentCount}}),checked:forceUnenroll,onChange:e=>setForceUnenroll(e.target.checked),disabled:useForceUnenroll})))};const AgentUpgradeAgentModal=({onClose:onClose,agents:agents,agentCount:agentCount,version:version})=>{const{notifications:notifications}=Object(hooks["mb"])();const[isSubmitting,setIsSubmitting]=Object(external_kbnSharedDeps_React_["useState"])(false);const isSingleAgent=Array.isArray(agents)&&agents.length===1;async function onSubmit(){try{setIsSubmitting(true);const{error:error}=isSingleAgent?await Object(hooks["x"])(agents[0].id,{version:version}):await Object(hooks["A"])({agents:Array.isArray(agents)?agents.map(agent=>agent.id):agents,version:version});if(error){throw error}setIsSubmitting(false);const successMessage=isSingleAgent?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.upgradeAgents.successSingleNotificationTitle",{defaultMessage:"Upgrading agent"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.upgradeAgents.successMultiNotificationTitle",{defaultMessage:"Upgrading agents"});notifications.toasts.addSuccess(successMessage);onClose()}catch(error){setIsSubmitting(false);notifications.toasts.addError(error,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.upgradeAgents.fatalErrorNotificationTitle",{defaultMessage:"Error upgrading {count, plural, one {agent} other {agents}}",values:{count:agentCount}})})}}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},isSingleAgent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.deleteSingleTitle",defaultMessage:"Upgrade agent?"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.deleteMultipleTitle",defaultMessage:"Upgrade {count} agents?",values:{count:agentCount}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.experimentalLabel",defaultMessage:"Experimental"}),tooltipContent:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.experimentalLabelTooltip",defaultMessage:"Upgrade agent might change or be removed in a future release and is not subject to the support SLA."})}))),onCancel:onClose,onConfirm:onSubmit,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonDisabled:isSubmitting,confirmButtonText:isSingleAgent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.confirmSingleButtonLabel",defaultMessage:"Upgrade agent"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.confirmMultipleButtonLabel",defaultMessage:"Upgrade {count} agents",values:{count:agentCount}})},external_kbnSharedDeps_React_default.a.createElement("p",null,isSingleAgent?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.upgradeSingleDescription",defaultMessage:"This action upgrades the agent running on '{hostName}' to version {version}. You can't undo this upgrade.",values:{hostName:agents[0].local_metadata.host.hostname,version:version}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.upgradeAgents.upgradeMultipleDescription",defaultMessage:"This action upgrades multiple agents to version {version}. You can't undo this upgrade.",values:{version:version}})))};const AgentPolicyActionMenu=Object(external_kbnSharedDeps_React_["memo"])(({agentPolicy:agentPolicy,onCopySuccess:onCopySuccess,fullButton:fullButton=false,enrollmentFlyoutOpenByDefault:enrollmentFlyoutOpenByDefault=false,onCancelEnrollment:onCancelEnrollment})=>{const hasWriteCapabilities=Object(hooks["K"])().write;const[isYamlFlyoutOpen,setIsYamlFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isEnrollmentFlyoutOpen,setIsEnrollmentFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(enrollmentFlyoutOpenByDefault);const onClose=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(onCancelEnrollment){return onCancelEnrollment}else{return()=>setIsEnrollmentFlyoutOpen(false)}},[onCancelEnrollment,setIsEnrollmentFlyoutOpen]);return external_kbnSharedDeps_React_default.a.createElement(AgentPolicyCopyProvider,null,copyAgentPolicyPrompt=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isYamlFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentPolicyYamlFlyout,{policyId:agentPolicy.id,onClose:()=>setIsYamlFlyoutOpen(false)})):null,isEnrollmentFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentEnrollmentFlyout,{agentPolicies:[agentPolicy],onClose:onClose})),external_kbnSharedDeps_React_default.a.createElement(ContextMenuActions,{button:fullButton?{props:{iconType:"arrowDown",iconSide:"right"},children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyActionMenu.buttonText",defaultMessage:"Actions"})}:undefined,items:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{disabled:!hasWriteCapabilities,icon:"plusInCircle",onClick:()=>setIsEnrollmentFlyoutOpen(true),key:"enrollAgents"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyActionMenu.enrollAgentActionText",defaultMessage:"Add agent"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"inspect",onClick:()=>setIsYamlFlyoutOpen(!isYamlFlyoutOpen),key:"viewPolicy"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyActionMenu.viewPolicyText",defaultMessage:"View policy"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{disabled:!hasWriteCapabilities,icon:"copy",onClick:()=>{copyAgentPolicyPrompt(agentPolicy,onCopySuccess)},key:"copyPolicy"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyActionMenu.copyPolicyActionText",defaultMessage:"Copy policy"}))]})))});const CreatePackagePolicyPageLayout=Object(external_kbnSharedDeps_React_["memo"])(({from:from,cancelUrl:cancelUrl,onCancel:onCancel,agentPolicy:agentPolicy,packageInfo:packageInfo,children:children,"data-test-subj":dataTestSubj})=>{const pageTitle=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if((from==="package"||from==="package-edit"||from==="edit")&&packageInfo){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{packageName:(packageInfo===null||packageInfo===void 0?void 0:packageInfo.name)||"",version:(packageInfo===null||packageInfo===void 0?void 0:packageInfo.version)||"",icons:packageInfo===null||packageInfo===void 0?void 0:packageInfo.icons,size:"xl"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":`${dataTestSubj}_pageTitle`},from==="edit"||from==="package-edit"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editPackagePolicy.pageTitleWithPackageName",defaultMessage:"Edit {packageName} integration",values:{packageName:packageInfo.title}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.pageTitleWithPackageName",defaultMessage:"Add {packageName} integration",values:{packageName:packageInfo.title}})))))}return from==="edit"||from==="package-edit"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{"data-test-subj":`${dataTestSubj}_pageTitle`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editPackagePolicy.pageTitle",defaultMessage:"Edit integration"}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.pageTitle",defaultMessage:"Add integration"})))},[dataTestSubj,from,packageInfo]);const pageDescription=Object(external_kbnSharedDeps_React_["useMemo"])(()=>from==="edit"||from==="package-edit"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editPackagePolicy.pageDescription",defaultMessage:"Modify integration settings and deploy changes to the selected agent policy."}):from==="policy"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.pageDescriptionfromPolicy",defaultMessage:"Configure an integration for the selected agent policy."}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.pageDescriptionfromPackage",defaultMessage:"Follow these instructions to add this integration to an agent policy."}),[from]);const leftColumn=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:"arrowLeft",flush:"left",href:cancelUrl,onClick:onCancel,"data-test-subj":`${dataTestSubj}_cancelBackLink`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.cancelLinkText",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,pageTitle),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},pageDescription)));const rightColumn=agentPolicy&&(from==="policy"||from==="edit")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{className:"eui-textRight",textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.agentPolicyNameLabel",defaultMessage:"Agent policy"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textBreakWord"},(agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.name)||"-")):undefined;const maxWidth=770;return external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{restrictHeaderWidth:maxWidth,restrictWidth:maxWidth,leftColumn:leftColumn,rightColumn:rightColumn,rightColumnGrow:false,"data-test-subj":dataTestSubj},children)});const isAdvancedVar=varDef=>{if(varDef.show_user||varDef.required&&varDef.default===undefined){return false}return true};const hasInvalidButRequiredVar=(registryVars,packagePolicyVars)=>registryVars&&!packagePolicyVars||Boolean(registryVars&&registryVars.find(registryVar=>{var _validatePackagePolic;return registryVar.required&&(!packagePolicyVars||!packagePolicyVars[registryVar.name]||((_validatePackagePolic=validatePackagePolicyConfig(packagePolicyVars[registryVar.name],registryVar))===null||_validatePackagePolic===void 0?void 0:_validatePackagePolic.length))}));const validatePackagePolicy=(packagePolicy,packageInfo)=>{const validationResults={name:null,description:null,namespace:null,inputs:{}};const namespaceValidation=Object(services["n"])(packagePolicy.namespace);if(!packagePolicy.name.trim()){validationResults.name=[external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.nameRequiredErrorMessage",{defaultMessage:"Name is required"})]}if(!namespaceValidation.valid&&namespaceValidation.error){validationResults.namespace=[namespaceValidation.error]}if(!packageInfo.policy_templates||packageInfo.policy_templates.length===0||!packageInfo.policy_templates[0]||!packageInfo.policy_templates[0].inputs||packageInfo.policy_templates[0].inputs.length===0){validationResults.inputs=null;return validationResults}const registryInputsByType=packageInfo.policy_templates[0].inputs.reduce((inputs,registryInput)=>{inputs[registryInput.type]=registryInput;return inputs},{});const registryStreamsByDataset=(packageInfo.data_streams||[]).reduce((dataStreams,registryDataStream)=>{dataStreams[registryDataStream.dataset]=registryDataStream.streams||[];return dataStreams},{});packagePolicy.inputs.forEach(input=>{if(!input.vars&&!input.streams){return}const inputValidationResults={vars:undefined,streams:{}};const inputVarsByName=(registryInputsByType[input.type].vars||[]).reduce((vars,registryVar)=>{vars[registryVar.name]=registryVar;return vars},{});const inputConfigs=Object.entries(input.vars||{});if(inputConfigs.length){inputValidationResults.vars=inputConfigs.reduce((results,[name,configEntry])=>{results[name]=input.enabled?validatePackagePolicyConfig(configEntry,inputVarsByName[name]):null;return results},{})}else{delete inputValidationResults.vars}if(input.streams.length){input.streams.forEach(stream=>{const streamValidationResults={};if(stream.vars){const streamVarsByName=((registryStreamsByDataset[stream.data_stream.dataset].find(registryStream=>registryStream.input===input.type)||{}).vars||[]).reduce((vars,registryVar)=>{vars[registryVar.name]=registryVar;return vars},{});streamValidationResults.vars=Object.entries(stream.vars).reduce((results,[name,configEntry])=>{results[name]=input.enabled&&stream.enabled?validatePackagePolicyConfig(configEntry,streamVarsByName[name]):null;return results},{})}inputValidationResults.streams[stream.data_stream.dataset]=streamValidationResults})}else{delete inputValidationResults.streams}if(inputValidationResults.vars||inputValidationResults.streams){validationResults.inputs[input.type]=inputValidationResults}});if(Object.entries(validationResults.inputs).length===0){validationResults.inputs=null}return validationResults};const validatePackagePolicyConfig=(configEntry,varDef)=>{const errors=[];const{value:value}=configEntry;let parsedValue=value;if(typeof value==="string"){parsedValue=value.trim()}if(varDef.required){if(parsedValue===undefined||typeof parsedValue==="string"&&!parsedValue){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.requiredErrorMessage",{defaultMessage:"{fieldName} is required",values:{fieldName:varDef.title||varDef.name}}))}}if(varDef.type==="yaml"){try{parsedValue=Object(js_yaml["safeLoad"])(value)}catch(e){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.invalidYamlFormatErrorMessage",{defaultMessage:"Invalid YAML format"}))}}if(varDef.multi){if(parsedValue&&!Array.isArray(parsedValue)){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.invalidArrayErrorMessage",{defaultMessage:"Invalid format"}))}if(varDef.required&&(!parsedValue||Array.isArray(parsedValue)&&parsedValue.length===0)){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.requiredErrorMessage",{defaultMessage:"{fieldName} is required",values:{fieldName:varDef.title||varDef.name}}))}if(varDef.type==="text"&&parsedValue&&Array.isArray(parsedValue)){const invalidStrings=parsedValue.filter(cand=>/^[*&]/.test(cand));if(invalidStrings.length>0){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.quoteStringErrorMessage",{defaultMessage:"Strings starting with special YAML characters like * or & need to be enclosed in double quotes."}))}}}if(varDef.type==="text"&&parsedValue&&!Array.isArray(parsedValue)){if(/^[*&]/.test(parsedValue)){errors.push(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.packagePolicyValidation.quoteStringErrorMessage",{defaultMessage:"Strings starting with special YAML characters like * or & need to be enclosed in double quotes."}))}}return errors.length?errors:null};const countValidationErrors=validationResults=>{const flattenedValidation=Object(services["k"])(validationResults);const errors=Object.values(flattenedValidation).filter(value=>Boolean(value))||[];return errors.length};const validationHasErrors=validationResults=>countValidationErrors(validationResults)>0;var react_markdown=__webpack_require__(121);var react_markdown_default=__webpack_require__.n(react_markdown);var mode_yaml=__webpack_require__(262);var textmate=__webpack_require__(263);const PackagePolicyInputVarField=Object(external_kbnSharedDeps_React_["memo"])(({varDef:varDef,value:value,onChange:onChange,errors:varErrors,forceShowErrors:forceShowErrors})=>{const[isDirty,setIsDirty]=Object(external_kbnSharedDeps_React_["useState"])(false);const{multi:multi,required:required,type:type,title:title,name:name,description:description}=varDef;const isInvalid=(isDirty||forceShowErrors)&&!!varErrors;const errors=isInvalid?varErrors:null;const fieldLabel=title||name;const field=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(multi){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{noSuggestions:true,isInvalid:isInvalid,selectedOptions:value.map(val=>({label:val})),onCreateOption:newVal=>{onChange([...value,newVal])},onChange:newVals=>{onChange(newVals.map(val=>val.label))},onBlur:()=>setIsDirty(true)})}switch(type){case"yaml":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{width:"100%",mode:"yaml",theme:"textmate",setOptions:{minLines:10,maxLines:30,tabSize:2,showGutter:false},value:value,onChange:newVal=>onChange(newVal),onBlur:()=>setIsDirty(true)});case"bool":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:fieldLabel,checked:value,showLabel:false,onChange:e=>onChange(e.target.checked),onBlur:()=>setIsDirty(true)});case"password":return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{type:"dual",isInvalid:isInvalid,value:value===undefined?"":value,onChange:e=>onChange(e.target.value),onBlur:()=>setIsDirty(true)});default:return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{isInvalid:isInvalid,value:value===undefined?"":value,onChange:e=>onChange(e.target.value),onBlur:()=>setIsDirty(true)})}},[isInvalid,multi,onChange,type,value,fieldLabel]);const isOptional=Object(external_kbnSharedDeps_React_["useMemo"])(()=>type!=="bool"&&!required,[required,type]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{isInvalid:isInvalid,error:errors,label:fieldLabel,labelAppend:isOptional?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.inputVarFieldOptionalLabel",defaultMessage:"Optional"})):null,helpText:external_kbnSharedDeps_React_default.a.createElement(react_markdown_default.a,{source:description})},field)});const FlexItemWithMaxWidth=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FlexItemWithMaxWidth",componentId:"sc-2lf3ki-0"})(["max-width:calc(50% - ",");"],props=>props.theme.eui.euiSizeL);const PackagePolicyInputConfig=Object(external_kbnSharedDeps_React_["memo"])(({hasInputStreams:hasInputStreams,packageInputVars:packageInputVars,packagePolicyInput:packagePolicyInput,updatePackagePolicyInput:updatePackagePolicyInput,inputVarsValidationResults:inputVarsValidationResults,forceShowErrors:forceShowErrors})=>{const[isShowingAdvanced,setIsShowingAdvanced]=Object(external_kbnSharedDeps_React_["useState"])(false);const hasErrors=forceShowErrors&&validationHasErrors(inputVarsValidationResults);const requiredVars=[];const advancedVars=[];if(packageInputVars){packageInputVars.forEach(varDef=>{if(isAdvancedVar(varDef)){advancedVars.push(varDef)}else{requiredVars.push(varDef)}})}const advancedVarsWithErrorsCount=Object(external_kbnSharedDeps_React_["useMemo"])(()=>advancedVars.filter(({name:varName})=>{var _inputVarsValidationR,_inputVarsValidationR2;return(_inputVarsValidationR=inputVarsValidationResults.vars)===null||_inputVarsValidationR===void 0?void 0:(_inputVarsValidationR2=_inputVarsValidationR[varName])===null||_inputVarsValidationR2===void 0?void 0:_inputVarsValidationR2.length}).length,[advancedVars,inputVarsValidationResults.vars]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:5},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.inputSettingsTitle",defaultMessage:"Settings"}))),hasInputStreams?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.inputSettingsDescription",defaultMessage:"The following settings are applicable to all inputs below."})))):null))),external_kbnSharedDeps_React_default.a.createElement(FlexItemWithMaxWidth,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},requiredVars.map(varDef=>{const{name:varName,type:varType}=varDef;const value=packagePolicyInput.vars[varName].value;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:varName},external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputVarField,{varDef:varDef,value:value,onChange:newValue=>{updatePackagePolicyInput({vars:{...packagePolicyInput.vars,[varName]:{type:varType,value:newValue}}})},errors:inputVarsValidationResults.vars[varName],forceShowErrors:forceShowErrors}))}),advancedVars.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:isShowingAdvanced?"arrowDown":"arrowRight",onClick:()=>setIsShowingAdvanced(!isShowingAdvanced),flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.toggleAdvancedOptionsButtonText",defaultMessage:"Advanced options"}))),!isShowingAdvanced&&hasErrors&&advancedVarsWithErrorsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"danger",size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",defaultMessage:"{count, plural, one {# error} other {# errors}}",values:{count:advancedVarsWithErrorsCount}}))):null)),isShowingAdvanced?advancedVars.map(varDef=>{const{name:varName,type:varType}=varDef;const value=packagePolicyInput.vars[varName].value;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:varName},external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputVarField,{varDef:varDef,value:value,onChange:newValue=>{updatePackagePolicyInput({vars:{...packagePolicyInput.vars,[varName]:{type:varType,value:newValue}}})},errors:inputVarsValidationResults.vars[varName],forceShowErrors:forceShowErrors}))}):null):null)))});const package_policy_input_stream_FlexItemWithMaxWidth=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FlexItemWithMaxWidth",componentId:"d6l6ns-0"})(["max-width:calc(50% - ",");"],props=>props.theme.eui.euiSizeL);const PackagePolicyInputStreamConfig=Object(external_kbnSharedDeps_React_["memo"])(({packageInputStream:packageInputStream,packagePolicyInputStream:packagePolicyInputStream,updatePackagePolicyInputStream:updatePackagePolicyInputStream,inputStreamValidationResults:inputStreamValidationResults,forceShowErrors:forceShowErrors})=>{const[isShowingAdvanced,setIsShowingAdvanced]=Object(external_kbnSharedDeps_React_["useState"])();const hasErrors=forceShowErrors&&validationHasErrors(inputStreamValidationResults);const requiredVars=[];const advancedVars=[];if(packageInputStream.vars&&packageInputStream.vars.length){packageInputStream.vars.forEach(varDef=>{if(isAdvancedVar(varDef)){advancedVars.push(varDef)}else{requiredVars.push(varDef)}})}const advancedVarsWithErrorsCount=Object(external_kbnSharedDeps_React_["useMemo"])(()=>advancedVars.filter(({name:varName})=>{var _inputStreamValidatio,_inputStreamValidatio2;return(_inputStreamValidatio=inputStreamValidationResults.vars)===null||_inputStreamValidatio===void 0?void 0:(_inputStreamValidatio2=_inputStreamValidatio[varName])===null||_inputStreamValidatio2===void 0?void 0:_inputStreamValidatio2.length}).length,[advancedVars,inputStreamValidationResults.vars]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{columns:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"none",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:5},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:packageInputStream.title,checked:packagePolicyInputStream.enabled,onChange:e=>{const enabled=e.target.checked;updatePackagePolicyInputStream({enabled:enabled})}}),packageInputStream.description?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(react_markdown_default.a,{source:packageInputStream.description}))):null))),external_kbnSharedDeps_React_default.a.createElement(package_policy_input_stream_FlexItemWithMaxWidth,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},requiredVars.map(varDef=>{const{name:varName,type:varType}=varDef;const value=packagePolicyInputStream.vars[varName].value;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:varName},external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputVarField,{varDef:varDef,value:value,onChange:newValue=>{updatePackagePolicyInputStream({vars:{...packagePolicyInputStream.vars,[varName]:{type:varType,value:newValue}}})},errors:inputStreamValidationResults.vars[varName],forceShowErrors:forceShowErrors}))}),advancedVars.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:isShowingAdvanced?"arrowDown":"arrowRight",onClick:()=>setIsShowingAdvanced(!isShowingAdvanced),flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.toggleAdvancedOptionsButtonText",defaultMessage:"Advanced options"}))),!isShowingAdvanced&&hasErrors&&advancedVarsWithErrorsCount?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"danger",size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",defaultMessage:"{count, plural, one {# error} other {# errors}}",values:{count:advancedVarsWithErrorsCount}}))):null)),isShowingAdvanced?advancedVars.map(varDef=>{const{name:varName,type:varType}=varDef;const value=packagePolicyInputStream.vars[varName].value;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:varName},external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputVarField,{varDef:varDef,value:value,onChange:newValue=>{updatePackagePolicyInputStream({vars:{...packagePolicyInputStream.vars,[varName]:{type:varType,value:newValue}}})},errors:inputStreamValidationResults.vars[varName],forceShowErrors:forceShowErrors}))}):null):null)))});const ShortenedHorizontalRule=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"]).withConfig({displayName:"ShortenedHorizontalRule",componentId:"sc-3olfkf-0"})(["&&&{width:","%;margin-left:auto;}"],11/12*100);const shouldShowStreamsByDefault=(packageInput,packageInputStreams,packagePolicyInput)=>packagePolicyInput.enabled&&(hasInvalidButRequiredVar(packageInput.vars,packagePolicyInput.vars)||Boolean(packageInputStreams.find(stream=>{var _packagePolicyInput$s;return stream.enabled&&hasInvalidButRequiredVar(stream.vars,(_packagePolicyInput$s=packagePolicyInput.streams.find(pkgStream=>stream.data_stream.dataset===pkgStream.data_stream.dataset))===null||_packagePolicyInput$s===void 0?void 0:_packagePolicyInput$s.vars)})));const PackagePolicyInputPanel=Object(external_kbnSharedDeps_React_["memo"])(({packageInput:packageInput,packageInputStreams:packageInputStreams,packagePolicyInput:packagePolicyInput,updatePackagePolicyInput:updatePackagePolicyInput,inputValidationResults:inputValidationResults,forceShowErrors:forceShowErrors})=>{const[isShowingStreams,setIsShowingStreams]=Object(external_kbnSharedDeps_React_["useState"])(shouldShowStreamsByDefault(packageInput,packageInputStreams,packagePolicyInput));const errorCount=countValidationErrors(inputValidationResults);const hasErrors=forceShowErrors&&errorCount;const hasInputStreams=Object(external_kbnSharedDeps_React_["useMemo"])(()=>packageInputStreams.length>0,[packageInputStreams.length]);const inputStreams=Object(external_kbnSharedDeps_React_["useMemo"])(()=>packageInputStreams.map(packageInputStream=>({packageInputStream:packageInputStream,packagePolicyInputStream:packagePolicyInput.streams.find(stream=>stream.data_stream.dataset===packageInputStream.data_stream.dataset)})).filter(stream=>Boolean(stream.packagePolicyInputStream)),[packageInputStreams,packagePolicyInput.streams]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,packageInput.title||packageInput.type)))),checked:packagePolicyInput.enabled,onChange:e=>{const enabled=e.target.checked;updatePackagePolicyInput({enabled:enabled,streams:packagePolicyInput.streams.map(stream=>({...stream,enabled:enabled}))});if(!enabled&&isShowingStreams){setIsShowingStreams(false)}}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},hasErrors?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"danger",size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",defaultMessage:"{count, plural, one {# error} other {# errors}}",values:{count:errorCount}}))):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{iconType:isShowingStreams?"arrowUp":"arrowDown",onClick:()=>setIsShowingStreams(!isShowingStreams),color:hasErrors?"danger":"text","aria-label":isShowingStreams?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.stepConfigure.hideStreamsAriaLabel",{defaultMessage:"Hide {type} inputs",values:{type:packageInput.type}}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.stepConfigure.showStreamsAriaLabel",{defaultMessage:"Show {type} inputs",values:{type:packageInput.type}})}))))),isShowingStreams?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}):null,isShowingStreams&&packageInput.vars&&packageInput.vars.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputConfig,{hasInputStreams:hasInputStreams,packageInputVars:packageInput.vars,packagePolicyInput:packagePolicyInput,updatePackagePolicyInput:updatePackagePolicyInput,inputVarsValidationResults:{vars:inputValidationResults.vars},forceShowErrors:forceShowErrors}),hasInputStreams?external_kbnSharedDeps_React_default.a.createElement(ShortenedHorizontalRule,{margin:"m"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"})):null,isShowingStreams?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},inputStreams.map(({packageInputStream:packageInputStream,packagePolicyInputStream:packagePolicyInputStream},index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:index},external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputStreamConfig,{packageInputStream:packageInputStream,packagePolicyInputStream:packagePolicyInputStream,updatePackagePolicyInputStream:updatedStream=>{const indexOfUpdatedStream=packagePolicyInput.streams.findIndex(stream=>stream.data_stream.dataset===packageInputStream.data_stream.dataset);const newStreams=[...packagePolicyInput.streams];newStreams[indexOfUpdatedStream]={...newStreams[indexOfUpdatedStream],...updatedStream};const updatedInput={streams:newStreams};if(!packagePolicyInput.enabled&&updatedStream.enabled){updatedInput.enabled=true}else if(packagePolicyInput.enabled&&!newStreams.find(stream=>stream.enabled)){updatedInput.enabled=false}updatePackagePolicyInput(updatedInput)},inputStreamValidationResults:inputValidationResults.streams[packagePolicyInputStream.data_stream.dataset],forceShowErrors:forceShowErrors}),index!==inputStreams.length-1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(ShortenedHorizontalRule,{margin:"none"})):null))):null)});var pkg_key_from_package_info=__webpack_require__(24);const StepSelectPackage=({agentPolicyId:agentPolicyId,updateAgentPolicy:updateAgentPolicy,packageInfo:packageInfo,updatePackageInfo:updatePackageInfo,setIsLoadingSecondStep:setIsLoadingSecondStep})=>{const[selectedPkgKey,setSelectedPkgKey]=Object(external_kbnSharedDeps_React_["useState"])(packageInfo?Object(pkg_key_from_package_info["a"])(packageInfo):undefined);const[selectedPkgError,setSelectedPkgError]=Object(external_kbnSharedDeps_React_["useState"])();const{data:agentPolicyData,error:agentPolicyError,isLoading:isAgentPoliciesLoading}=Object(hooks["V"])(agentPolicyId);const[packages,setPackages]=Object(external_kbnSharedDeps_React_["useState"])([]);const{data:packagesData,error:packagesError,isLoading:isPackagesLoading}=Object(hooks["bb"])();const{data:limitedPackagesData,isLoading:isLimitedPackagesLoading}=Object(hooks["T"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(packagesData!==null&&packagesData!==void 0&&packagesData.response&&limitedPackagesData!==null&&limitedPackagesData!==void 0&&limitedPackagesData.response&&agentPolicyData!==null&&agentPolicyData!==void 0&&agentPolicyData.item){const allPackages=packagesData.response;const limitedPackages=limitedPackagesData.response;const usedLimitedPackages=agentPolicyData.item.package_policies.map(packagePolicy=>{var _packagePolicy$packag;return((_packagePolicy$packag=packagePolicy.package)===null||_packagePolicy$packag===void 0?void 0:_packagePolicy$packag.name)||""}).filter(pkgName=>limitedPackages.includes(pkgName));setPackages(allPackages.filter(pkg=>!usedLimitedPackages.includes(pkg.name)))}},[packagesData,limitedPackagesData,agentPolicyData]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(agentPolicyData&&agentPolicyData.item){updateAgentPolicy(agentPolicyData.item)}},[agentPolicyData,updateAgentPolicy]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchPackageInfo=async()=>{if(selectedPkgKey){setIsLoadingSecondStep(true);const{data:data,error:error}=await Object(hooks["s"])(selectedPkgKey);if(error){setSelectedPkgError(error);updatePackageInfo(undefined)}else if(data&&data.response){setSelectedPkgError(undefined);updatePackageInfo(data.response)}setIsLoadingSecondStep(false)}else{setSelectedPkgError(undefined);updatePackageInfo(undefined)}};if(!packageInfo||selectedPkgKey!==Object(pkg_key_from_package_info["a"])(packageInfo)){fetchPackageInfo()}},[selectedPkgKey,packageInfo,updatePackageInfo,setIsLoadingSecondStep]);if(agentPolicyError){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepSelectPackage.errorLoadingPolicyTitle",defaultMessage:"Error loading agent policy information"}),error:agentPolicyError})}if(packagesError){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepSelectPackage.errorLoadingPackagesTitle",defaultMessage:"Error loading integrations"}),error:packagesError})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelectable"],{searchable:true,allowExclusions:false,singleSelection:true,isLoading:isPackagesLoading||isLimitedPackagesLoading||isAgentPoliciesLoading,options:packages.map(({title:title,name:name,version:version,icons:icons})=>{const pkgkey=`${name}-${version}`;return{label:title||name,key:pkgkey,prepend:external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{packageName:name,version:version,icons:icons,size:"m"}),checked:selectedPkgKey===pkgkey?"on":undefined}}),listProps:{bordered:true},searchProps:{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.stepSelectPackage.filterPackagesInputPlaceholder",{defaultMessage:"Search for integrations"})},height:240,onChange:options=>{const selectedOption=options.find(option=>option.checked==="on");if(selectedOption){if(selectedOption.key!==selectedPkgKey){setSelectedPkgKey(selectedOption.key)}}else{setSelectedPkgKey(undefined)}}},(list,search)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,search,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),list))),selectedPkgError?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepSelectPackage.errorLoadingSelectedPackageTitle",defaultMessage:"Error loading selected integration"}),error:selectedPkgError})):null)};function create_agent_policy_extends(){create_agent_policy_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return create_agent_policy_extends.apply(this,arguments)}const FlyoutWithHigherZIndex=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlyout"]).withConfig({displayName:"FlyoutWithHigherZIndex",componentId:"sc-4bxzaq-0"})(["z-index:",";"],props=>props.theme.eui.euiZLevel5);const CreateAgentPolicyFlyout=({onClose:onClose,...restOfProps})=>{const{notifications:notifications}=Object(hooks["mb"])();const hasWriteCapabilites=Object(hooks["K"])().write;const[agentPolicy,setAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])({name:"",description:"",namespace:"default",is_default:undefined,monitoring_enabled:Object.values(common["dataTypes"])});const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[withSysMonitoring,setWithSysMonitoring]=Object(external_kbnSharedDeps_React_["useState"])(true);const validation=agentPolicyFormValidation(agentPolicy);const updateAgentPolicy=updatedFields=>{setAgentPolicy({...agentPolicy,...updatedFields})};const createAgentPolicy=async()=>await Object(hooks["f"])(agentPolicy,{withSysMonitoring:withSysMonitoring});const header=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"CreateAgentPolicyFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"CreateAgentPolicyFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createAgentPolicy.flyoutTitle",defaultMessage:"Create agent policy"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createAgentPolicy.flyoutTitleDescription",defaultMessage:"Agent policies are used to manage settings across a group of agents. You can add integrations to your agent policy to specify what data your agents collect. When you edit an agent policy, you can use Fleet to deploy updates to a specified group of agents."}))));const body=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(AgentPolicyForm,{agentPolicy:agentPolicy,updateAgentPolicy:updateAgentPolicy,withSysMonitoring:withSysMonitoring,updateSysMonitoring:newValue=>setWithSysMonitoring(newValue),validation:validation}));const footer=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>onClose(),flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createAgentPolicy.cancelButtonLabel",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,isLoading:isLoading,isDisabled:!hasWriteCapabilites||isLoading||Object.keys(validation).length>0,onClick:async()=>{setIsLoading(true);try{const{data:data,error:error}=await createAgentPolicy();setIsLoading(false);if(data){notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createAgentPolicy.successNotificationTitle",{defaultMessage:"Agent policy '{name}' created",values:{name:agentPolicy.name}}));onClose(data.item)}else{notifications.toasts.addDanger(error?error.message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}}catch(e){setIsLoading(false);notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createAgentPolicy.submitButtonLabel",defaultMessage:"Create agent policy"})))));return external_kbnSharedDeps_React_default.a.createElement(FlyoutWithHigherZIndex,create_agent_policy_extends({onClose:()=>onClose(),size:"l",maxWidth:400},restOfProps),header,body,footer)};const AgentPolicyWrapper=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFormRow"]).withConfig({displayName:"AgentPolicyWrapper",componentId:"sc-1qoukpq-0"})([".euiFormRow__label{width:100%;}"]);const AgentPolicyNameColumn=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"AgentPolicyNameColumn",componentId:"sc-1qoukpq-1"})(["max-width:",";overflow:hidden;"],props=>`${props.grow/9*100}%`);const AgentPolicyDescriptionColumn=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"AgentPolicyDescriptionColumn",componentId:"sc-1qoukpq-2"})(["max-width:",";overflow:hidden;"],props=>`${props.grow/9*100}%`);const StepSelectAgentPolicy=({pkgkey:pkgkey,updatePackageInfo:updatePackageInfo,agentPolicy:agentPolicy,updateAgentPolicy:updateAgentPolicy,setIsLoadingSecondStep:setIsLoadingSecondStep})=>{var _agentPoliciesById$se,_agentPoliciesById$se2;const{isReady:isFleetReady}=Object(hooks["N"])();const[selectedPolicyId,setSelectedPolicyId]=Object(external_kbnSharedDeps_React_["useState"])(agentPolicy?agentPolicy.id:undefined);const[selectedAgentPolicyError,setSelectedAgentPolicyError]=Object(external_kbnSharedDeps_React_["useState"])();const hasWriteCapabilites=Object(hooks["K"])().write;const[isCreateAgentPolicyFlyoutOpen,setIsCreateAgentPolicyFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const{data:packageInfoData,error:packageInfoError,isLoading:isPackageInfoLoading}=Object(hooks["Y"])(pkgkey);const isLimitedPackage=packageInfoData&&Object(services["m"])(packageInfoData.response)||false;const{data:agentPoliciesData,error:agentPoliciesError,isLoading:isAgentPoliciesLoading,resendRequest:refreshAgentPolicies}=Object(hooks["O"])({page:1,perPage:1e3,sortField:"name",sortOrder:"asc",full:true});const agentPolicies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>(agentPoliciesData===null||agentPoliciesData===void 0?void 0:agentPoliciesData.items)||[],[agentPoliciesData===null||agentPoliciesData===void 0?void 0:agentPoliciesData.items]);const agentPoliciesById=Object(external_kbnSharedDeps_React_["useMemo"])(()=>agentPolicies.reduce((acc,policy)=>{acc[policy.id]=policy;return acc},{}),[agentPolicies]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(packageInfoData&&packageInfoData.response){updatePackageInfo(packageInfoData.response)}},[packageInfoData,updatePackageInfo]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchAgentPolicyInfo=async()=>{if(selectedPolicyId){setIsLoadingSecondStep(true);const{data:data,error:error}=await Object(hooks["o"])(selectedPolicyId);if(error){setSelectedAgentPolicyError(error);updateAgentPolicy(undefined)}else if(data&&data.item){setSelectedAgentPolicyError(undefined);updateAgentPolicy(data.item)}}else{setSelectedAgentPolicyError(undefined);updateAgentPolicy(undefined)}setIsLoadingSecondStep(false)};if(!agentPolicy||selectedPolicyId!==agentPolicy.id){fetchAgentPolicyInfo()}},[selectedPolicyId,agentPolicy,updateAgentPolicy,setIsLoadingSecondStep]);const agentPolicyOptions=Object(external_kbnSharedDeps_React_["useMemo"])(()=>packageInfoData?agentPolicies.map(agentConf=>{const alreadyHasLimitedPackage=isLimitedPackage&&Object(services["f"])(agentConf,packageInfoData.response.name)||false;return{label:agentConf.name,value:agentConf.id,disabled:alreadyHasLimitedPackage,"data-test-subj":"agentPolicyItem"}}):[],[agentPolicies,isLimitedPackage,packageInfoData]);const selectedAgentPolicyOption=agentPolicyOptions.find(option=>option.value===selectedPolicyId);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(!selectedPolicyId&&agentPolicies.length&&agentPolicyOptions.length){const defaultAgentPolicy=agentPolicies.find(policy=>policy.is_default);if(defaultAgentPolicy){const defaultAgentPolicyOption=agentPolicyOptions.find(option=>option.value===defaultAgentPolicy.id);if(defaultAgentPolicyOption&&!defaultAgentPolicyOption.disabled){setSelectedPolicyId(defaultAgentPolicy.id)}}}},[agentPolicies,agentPolicyOptions,selectedPolicyId]);if(packageInfoError){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:packageInfoError})}if(agentPoliciesError){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingAgentPoliciesTitle",defaultMessage:"Error loading agent policies"}),error:agentPoliciesError})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isCreateAgentPolicyFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(CreateAgentPolicyFlyout,{onClose:newAgentPolicy=>{setIsCreateAgentPolicyFlyoutOpen(false);if(newAgentPolicy){refreshAgentPolicies();setSelectedPolicyId(newAgentPolicy.id)}},ownFocus:true})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(AgentPolicyWrapper,{fullWidth:true,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyLabel",defaultMessage:"Agent policy"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{disabled:!hasWriteCapabilites,onClick:()=>setIsCreateAgentPolicyFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.addButton",defaultMessage:"Create agent policy"}))))),helpText:isFleetReady&&selectedPolicyId?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyAgentsDescriptionText",defaultMessage:"{count, plural, one {# agent} other {# agents}} are enrolled with the selected agent policy.",values:{count:(_agentPoliciesById$se=(_agentPoliciesById$se2=agentPoliciesById[selectedPolicyId])===null||_agentPoliciesById$se2===void 0?void 0:_agentPoliciesById$se2.agents)!==null&&_agentPoliciesById$se!==void 0?_agentPoliciesById$se:0}}):null},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyPlaceholderText",{defaultMessage:"Select an agent policy to add this integration to"}),singleSelection:{asPlainText:true},isClearable:false,fullWidth:true,isLoading:isAgentPoliciesLoading||isPackageInfoLoading,options:agentPolicyOptions,renderOption:option=>{var _agentPoliciesById$ag,_agentPoliciesById;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(AgentPolicyNameColumn,{grow:2},external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textTruncate"},option.label)),external_kbnSharedDeps_React_default.a.createElement(AgentPolicyDescriptionColumn,{grow:isFleetReady?5:7},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{className:"eui-textTruncate",color:"subdued"},agentPoliciesById[option.value].description)),isFleetReady?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2,className:"eui-textRight"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.agentPolicyAgentsCountText",defaultMessage:"{count, plural, one {# agent} other {# agents}} enrolled",values:{count:(_agentPoliciesById$ag=(_agentPoliciesById=agentPoliciesById[option.value])===null||_agentPoliciesById===void 0?void 0:_agentPoliciesById.agents)!==null&&_agentPoliciesById$ag!==void 0?_agentPoliciesById$ag:0}}))):null)},selectedOptions:selectedAgentPolicyOption?[selectedAgentPolicyOption]:[],onChange:options=>{const selectedOption=options[0]||undefined;if(selectedOption){if(selectedOption.value!==selectedPolicyId){setSelectedPolicyId(selectedOption.value)}}else{setSelectedPolicyId(undefined)}}}))),selectedAgentPolicyError?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.StepSelectPolicy.errorLoadingSelectedAgentPolicyTitle",defaultMessage:"Error loading selected agent policy"}),error:selectedAgentPolicyError})):null))};const findStreamsForInputType=(inputType,packageInfo)=>{const streams=[];(packageInfo.data_streams||[]).forEach(dataStream=>{(dataStream.streams||[]).forEach(stream=>{if(stream.input===inputType){streams.push({...stream,data_stream:{dataset:dataStream.dataset}})}})});return streams};const StepConfigurePackagePolicy=({from:from="policy",packageInfo:packageInfo,packagePolicy:packagePolicy,packagePolicyId:packagePolicyId,updatePackagePolicy:updatePackagePolicy,validationResults:validationResults,submitAttempted:submitAttempted})=>{const renderConfigureInputs=()=>packageInfo.policy_templates&&packageInfo.policy_templates[0]&&packageInfo.policy_templates[0].inputs&&packageInfo.policy_templates[0].inputs.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"none"},packageInfo.policy_templates[0].inputs.map(packageInput=>{const packagePolicyInput=packagePolicy.inputs.find(input=>input.type===packageInput.type);const packageInputStreams=findStreamsForInputType(packageInput.type,packageInfo);return packagePolicyInput?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:packageInput.type},external_kbnSharedDeps_React_default.a.createElement(PackagePolicyInputPanel,{packageInput:packageInput,packageInputStreams:packageInputStreams,packagePolicyInput:packagePolicyInput,updatePackagePolicyInput:updatedInput=>{const indexOfUpdatedInput=packagePolicy.inputs.findIndex(input=>input.type===packageInput.type);const newInputs=[...packagePolicy.inputs];newInputs[indexOfUpdatedInput]={...newInputs[indexOfUpdatedInput],...updatedInput};updatePackagePolicy({inputs:newInputs})},inputValidationResults:validationResults.inputs[packagePolicyInput.type],forceShowErrors:submitAttempted}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],{margin:"m"})):null}))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"checkInCircleFilled",iconColor:"secondary",body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.noPolicyOptionsMessage",defaultMessage:"Nothing to configure"})))});return validationResults?renderConfigureInputs():external_kbnSharedDeps_React_default.a.createElement(Loading,null)};const StepDefinePackagePolicy=({agentPolicy:agentPolicy,packageInfo:packageInfo,packagePolicy:packagePolicy,updatePackagePolicy:updatePackagePolicy,validationResults:validationResults})=>{const[isShowingAdvanced,setIsShowingAdvanced]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const pkg=packagePolicy.package;const currentPkgKey=pkg?Object(pkg_key_from_package_info["a"])(pkg):"";const pkgKey=Object(pkg_key_from_package_info["a"])(packageInfo);if(currentPkgKey!==pkgKey){const pkgPoliciesNamePattern=new RegExp(`${packageInfo.name}-(\\d+)`);const pkgPoliciesWithMatchingNames=agentPolicy.package_policies.filter(ds=>Boolean(ds.name.match(pkgPoliciesNamePattern))).map(ds=>parseInt(ds.name.match(pkgPoliciesNamePattern)[1],10)).sort();updatePackagePolicy({name:`${packageInfo.name}-${pkgPoliciesWithMatchingNames.length?pkgPoliciesWithMatchingNames[pkgPoliciesWithMatchingNames.length-1]+1:1}`,package:{name:packageInfo.name,title:packageInfo.title,version:packageInfo.version},inputs:Object(services["q"])(packageInfo)})}if(packagePolicy.policy_id!==agentPolicy.id){updatePackagePolicy({policy_id:agentPolicy.id,namespace:agentPolicy.namespace})}},[packagePolicy.package,packagePolicy.policy_id,agentPolicy,packageInfo,updatePackagePolicy]);return validationResults?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescribedFormGroup"],{title:external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.integrationSettingsSectionTitle",defaultMessage:"Integration settings"})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.integrationSettingsSectionDescription",defaultMessage:"Choose a name and description to help identify how this integration will be used."})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{isInvalid:!!validationResults.name,error:validationResults.name,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNameInputLabel",defaultMessage:"Integration name"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{value:packagePolicy.name,onChange:e=>updatePackagePolicy({name:e.target.value}),"data-test-subj":"packagePolicyNameInput"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyDescriptionInputLabel",defaultMessage:"Description"}),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.inputVarFieldOptionalLabel",defaultMessage:"Optional"})),isInvalid:!!validationResults.description,error:validationResults.description},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{value:packagePolicy.description,onChange:e=>updatePackagePolicy({description:e.target.value}),"data-test-subj":"packagePolicyDescriptionInput"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",iconType:isShowingAdvanced?"arrowDown":"arrowRight",onClick:()=>setIsShowingAdvanced(!isShowingAdvanced),flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",defaultMessage:"Advanced options"}))),!isShowingAdvanced&&!!validationResults.namespace?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"danger",size:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.errorCountText",defaultMessage:"{count, plural, one {# error} other {# errors}}",values:{count:1}}))):null),isShowingAdvanced?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{isInvalid:!!validationResults.namespace,error:validationResults.namespace,label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.stepConfigure.packagePolicyNamespaceInputLabel",defaultMessage:"Namespace"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{noSuggestions:true,singleSelection:true,selectedOptions:packagePolicy.namespace?[{label:packagePolicy.namespace}]:[],onCreateOption:newNamespace=>{updatePackagePolicy({namespace:newNamespace})},onChange:newNamespaces=>{updatePackagePolicy({namespace:newNamespaces.length?newNamespaces[0].label:""})}}))):null)):external_kbnSharedDeps_React_default.a.createElement(Loading,null)};const UIExtensionsContext=external_kbnSharedDeps_React_default.a.createContext({});const useUIExtension=(packageName,view)=>{var _registeredExtensions;const registeredExtensions=Object(external_kbnSharedDeps_React_["useContext"])(UIExtensionsContext);if(!registeredExtensions){throw new Error("useUIExtension called outside of UIExtensionsContext")}const extension=registeredExtensions===null||registeredExtensions===void 0?void 0:(_registeredExtensions=registeredExtensions[packageName])===null||_registeredExtensions===void 0?void 0:_registeredExtensions[view];if(extension){return extension.component}};const ExtensionWrapper=Object(external_kbnSharedDeps_React_["memo"])(({children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Suspense"],{fallback:external_kbnSharedDeps_React_default.a.createElement(Loading,null)},children)));var common_constants=__webpack_require__(0);function create_package_policy_page_extends(){create_package_policy_page_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return create_package_policy_page_extends.apply(this,arguments)}const StepsWithLessPadding=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiSteps"]).withConfig({displayName:"StepsWithLessPadding",componentId:"sc-1smjujo-0"})([".euiStep__content{padding-bottom:",";}"],props=>props.theme.eui.paddingSizes.m);const CreatePackagePolicyPage=()=>{var _packagePolicy$packag,_packagePolicy$packag2;const{notifications:notifications}=Object(hooks["mb"])();const{agents:{enabled:isFleetEnabled}}=Object(hooks["M"])();const{params:{policyId:policyId,pkgkey:pkgkey}}=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();const{getHref:getHref,getPath:getPath}=Object(hooks["hb"])();const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const handleNavigateTo=useNavigateToCallback();const routeState=useIntraAppState();const from=policyId?"policy":"package";const[agentPolicy,setAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])();const[packageInfo,setPackageInfo]=Object(external_kbnSharedDeps_React_["useState"])();const[isLoadingSecondStep,setIsLoadingSecondStep]=Object(external_kbnSharedDeps_React_["useState"])(false);const agentPolicyId=agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.id;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const getAgentCount=async()=>{const{data:data}=await Object(hooks["k"])({policyId:agentPolicyId});if((data===null||data===void 0?void 0:data.results.total)!==undefined){setAgentCount(data.results.total)}};if(isFleetEnabled&&agentPolicyId){getAgentCount()}},[agentPolicyId,isFleetEnabled]);const[agentCount,setAgentCount]=Object(external_kbnSharedDeps_React_["useState"])(0);const[packagePolicy,setPackagePolicy]=Object(external_kbnSharedDeps_React_["useState"])({name:"",description:"",namespace:"",policy_id:"",enabled:true,output_id:"",inputs:[]});const[validationResults,setValidationResults]=Object(external_kbnSharedDeps_React_["useState"])();const[formState,setFormState]=Object(external_kbnSharedDeps_React_["useState"])("INVALID");const updatePackageInfo=Object(external_kbnSharedDeps_React_["useCallback"])(updatedPackageInfo=>{if(updatedPackageInfo){setPackageInfo(updatedPackageInfo);if(agentPolicy){setFormState("VALID")}}else{setFormState("INVALID");setPackageInfo(undefined)}console.debug("Package info updated",updatedPackageInfo)},[agentPolicy,setPackageInfo,setFormState]);const updateAgentPolicy=Object(external_kbnSharedDeps_React_["useCallback"])(updatedAgentPolicy=>{if(updatedAgentPolicy){setAgentPolicy(updatedAgentPolicy);if(packageInfo){setFormState("VALID")}}else{setFormState("INVALID");setAgentPolicy(undefined)}console.debug("Agent policy updated",updatedAgentPolicy)},[packageInfo,setAgentPolicy,setFormState]);const hasErrors=validationResults?validationHasErrors(validationResults):false;const updatePackagePolicyValidation=Object(external_kbnSharedDeps_React_["useCallback"])(newPackagePolicy=>{if(packageInfo){const newValidationResult=validatePackagePolicy(newPackagePolicy||packagePolicy,packageInfo);setValidationResults(newValidationResult);console.debug("Package policy validation results",newValidationResult);return newValidationResult}},[packagePolicy,packageInfo]);const updatePackagePolicy=Object(external_kbnSharedDeps_React_["useCallback"])(updatedFields=>{const newPackagePolicy={...packagePolicy,...updatedFields};setPackagePolicy(newPackagePolicy);console.debug("Package policy updated",newPackagePolicy);const newValidationResults=updatePackagePolicyValidation(newPackagePolicy);const hasPackage=newPackagePolicy.package;const hasValidationErrors=newValidationResults?validationHasErrors(newValidationResults):false;const hasAgentPolicy=newPackagePolicy.policy_id&&newPackagePolicy.policy_id!=="";if(hasPackage&&hasAgentPolicy&&!hasValidationErrors){setFormState("VALID")}},[packagePolicy,updatePackagePolicyValidation]);const handleExtensionViewOnChange=Object(external_kbnSharedDeps_React_["useCallback"])(({isValid:isValid,updatedPolicy:updatedPolicy})=>{updatePackagePolicy(updatedPolicy);setFormState(prevState=>{if(prevState==="VALID"&&!isValid){return"INVALID"}return prevState})},[updatePackagePolicy]);const cancelUrl=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(routeState&&routeState.onCancelUrl){return routeState.onCancelUrl}return from==="policy"?getHref("policy_details",{policyId:agentPolicyId||policyId}):getHref("integration_details_overview",{pkgkey:pkgkey})},[agentPolicyId,policyId,from,getHref,pkgkey,routeState]);const cancelClickHandler=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{if(routeState&&routeState.onCancelNavigateTo){ev.preventDefault();handleNavigateTo(routeState.onCancelNavigateTo)}},[routeState,handleNavigateTo]);const savePackagePolicy=async()=>{setFormState("LOADING");const result=await Object(hooks["g"])(packagePolicy);setFormState("SUBMITTED");return result};const onSubmit=async()=>{if(formState==="VALID"&&hasErrors){setFormState("INVALID");return}if(agentCount!==0&&formState!=="CONFIRM"){setFormState("CONFIRM");return}const{error:error,data:data}=await savePackagePolicy();if(!error){if(routeState&&routeState.onSaveNavigateTo){handleNavigateTo(typeof routeState.onSaveNavigateTo==="function"?routeState.onSaveNavigateTo(data.item):routeState.onSaveNavigateTo)}else{history.push(getPath("policy_details",{policyId:(agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.id)||policyId}))}notifications.toasts.addSuccess({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.addedNotificationTitle",{defaultMessage:`'{packagePolicyName}' integration added.`,values:{packagePolicyName:packagePolicy.name}}),text:agentCount&&agentPolicy?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.addedNotificationMessage",{defaultMessage:`Fleet will deploy updates to all agents that use the '{agentPolicyName}' policy.`,values:{agentPolicyName:agentPolicy.name}}):undefined,"data-test-subj":"packagePolicyCreateSuccessToast"})}else{notifications.toasts.addError(error,{title:"Error"});setFormState("VALID")}};const layoutProps={from:from,cancelUrl:cancelUrl,onCancel:cancelClickHandler,agentPolicy:agentPolicy,packageInfo:packageInfo};const stepSelectAgentPolicy=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(StepSelectAgentPolicy,{pkgkey:pkgkey,updatePackageInfo:updatePackageInfo,agentPolicy:agentPolicy,updateAgentPolicy:updateAgentPolicy,setIsLoadingSecondStep:setIsLoadingSecondStep}),[pkgkey,updatePackageInfo,agentPolicy,updateAgentPolicy]);const ExtensionView=useUIExtension((_packagePolicy$packag=(_packagePolicy$packag2=packagePolicy.package)===null||_packagePolicy$packag2===void 0?void 0:_packagePolicy$packag2.name)!==null&&_packagePolicy$packag!==void 0?_packagePolicy$packag:"","package-policy-create");const stepSelectPackage=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(StepSelectPackage,{agentPolicyId:policyId,updateAgentPolicy:updateAgentPolicy,packageInfo:packageInfo,updatePackageInfo:updatePackageInfo,setIsLoadingSecondStep:setIsLoadingSecondStep}),[policyId,updateAgentPolicy,packageInfo,updatePackageInfo]);const stepConfigurePackagePolicy=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _packagePolicy$packag3;return isLoadingSecondStep?external_kbnSharedDeps_React_default.a.createElement(Loading,null):agentPolicy&&packageInfo?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StepDefinePackagePolicy,{agentPolicy:agentPolicy,packageInfo:packageInfo,packagePolicy:packagePolicy,updatePackagePolicy:updatePackagePolicy,validationResults:validationResults}),!ExtensionView&&external_kbnSharedDeps_React_default.a.createElement(StepConfigurePackagePolicy,{packageInfo:packageInfo,packagePolicy:packagePolicy,updatePackagePolicy:updatePackagePolicy,validationResults:validationResults,submitAttempted:formState==="INVALID"}),ExtensionView&&packagePolicy.policy_id&&((_packagePolicy$packag3=packagePolicy.package)===null||_packagePolicy$packag3===void 0?void 0:_packagePolicy$packag3.name)&&external_kbnSharedDeps_React_default.a.createElement(ExtensionWrapper,null,external_kbnSharedDeps_React_default.a.createElement(ExtensionView,{newPolicy:packagePolicy,onChange:handleExtensionViewOnChange}))):external_kbnSharedDeps_React_default.a.createElement("div",null)},[isLoadingSecondStep,agentPolicy,packageInfo,packagePolicy,updatePackagePolicy,validationResults,formState,ExtensionView,handleExtensionViewOnChange]);const steps=[from==="package"?{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.stepSelectAgentPolicyTitle",{defaultMessage:"Select an agent policy"}),children:stepSelectAgentPolicy}:{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.stepSelectPackageTitle",{defaultMessage:"Select an integration"}),children:stepSelectPackage},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.createPackagePolicy.stepConfigurePackagePolicyTitle",{defaultMessage:"Configure integration"}),status:!packageInfo||!agentPolicy||isLoadingSecondStep?"disabled":undefined,"data-test-subj":"dataCollectionSetupStep",children:stepConfigurePackagePolicy}];return external_kbnSharedDeps_React_default.a.createElement(CreatePackagePolicyPageLayout,create_package_policy_page_extends({},layoutProps,{"data-test-subj":"createPackagePolicy"}),formState==="CONFIRM"&&agentPolicy&&external_kbnSharedDeps_React_default.a.createElement(ConfirmDeployAgentPolicyModal,{agentCount:agentCount,agentPolicy:agentPolicy,onConfirm:onSubmit,onCancel:()=>setFormState("VALID")}),from==="package"?packageInfo&&external_kbnSharedDeps_React_default.a.createElement(IntegrationBreadcrumb,{pkgTitle:packageInfo.title,pkgkey:Object(pkg_key_from_package_info["a"])(packageInfo)}):agentPolicy&&external_kbnSharedDeps_React_default.a.createElement(PolicyBreadcrumb,{policyName:agentPolicy.name,policyId:agentPolicy.id}),external_kbnSharedDeps_React_default.a.createElement(StepsWithLessPadding,{steps:steps}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBottomBar"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},!isLoadingSecondStep&&agentPolicy&&packageInfo&&formState==="INVALID"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.errorOnSaveText",defaultMessage:"Your integration policy has errors. Please fix them before saving."}):null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"ghost",href:cancelUrl,onClick:cancelClickHandler,"data-test-subj":"createPackagePolicyCancelButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.cancelButton",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onSubmit,isLoading:formState==="LOADING",disabled:formState!=="VALID",iconType:"save",color:"primary",fill:true,"data-test-subj":"createPackagePolicySaveButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.saveButton",defaultMessage:"Save integration"}))))))))};const PolicyBreadcrumb=({policyName:policyName,policyId:policyId})=>{Object(hooks["J"])("add_integration_from_policy",{policyName:policyName,policyId:policyId});return null};const IntegrationBreadcrumb=({pkgTitle:pkgTitle,pkgkey:pkgkey})=>{Object(hooks["J"])("add_integration_to_policy",{pkgTitle:pkgTitle,pkgkey:pkgkey});return null};const useNavigateToCallback=()=>{const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{application:{navigateToApp:navigateToApp}}=Object(hooks["mb"])();return Object(external_kbnSharedDeps_React_["useCallback"])(navigateToProps=>{if(navigateToProps[0]===common_constants["ab"]){const{path:path="",state:state}=navigateToProps[1]||{};history.push({pathname:path.charAt(0)==="#"?path.substr(1):path,state:state})}return navigateToApp(...navigateToProps)},[history,navigateToApp])};const RELEASE_BADGE_LABEL={beta:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.releaseBadge.betaLabel",{defaultMessage:"Beta"}),experimental:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.releaseBadge.experimentalLabel",{defaultMessage:"Experimental"})};const RELEASE_BADGE_DESCRIPTION={beta:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.releaseBadge.betaDescription",{defaultMessage:"This integration is not recommended for use in production environments."}),experimental:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.releaseBadge.experimentalDescription",{defaultMessage:"This integration may have breaking changes or be removed in a future release."})};const Card=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiCard"]).withConfig({displayName:"Card",componentId:"c0wp03-0"})(["color:inherit;"]);function PackageCard({description:description,name:name,title:title,version:version,release:release,status:status,icons:icons,...restProps}){const{getHref:getHref}=Object(hooks["hb"])();let urlVersion=version;if("savedObject"in restProps){urlVersion=restProps.savedObject.attributes.version||version}return external_kbnSharedDeps_React_default.a.createElement(Card,{title:title||"",description:description,icon:external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{icons:icons,packageName:name,version:version,size:"xl"}),href:getHref("integration_details_overview",{pkgkey:`${name}-${urlVersion}`}),betaBadgeLabel:release&&release!=="ga"?RELEASE_BADGE_LABEL[release]:undefined,betaBadgeTooltipContent:release&&release!=="ga"?RELEASE_BADGE_DESCRIPTION[release]:undefined})}function PackageListGrid({isLoading:isLoading,controls:controls,title:title,list:list}){const initialQuery=external_kbnSharedDeps_ElasticEui_["EuiSearchBar"].Query.MATCH_ALL;const[query,setQuery]=Object(external_kbnSharedDeps_React_["useState"])(initialQuery);const[searchTerm,setSearchTerm]=Object(external_kbnSharedDeps_React_["useState"])("");const localSearchRef=Object(epm_hooks["f"])(list);const onQueryChange=({query:query,queryText:userInput,error:error})=>{if(!error){setQuery(query);setSearchTerm(userInput)}};const controlsContent=external_kbnSharedDeps_React_default.a.createElement(ControlsColumn,{title:title,controls:controls});let gridContent;if(isLoading||!localSearchRef.current){gridContent=external_kbnSharedDeps_React_default.a.createElement(Loading,null)}else{const filteredList=searchTerm?list.filter(item=>localSearchRef.current.search(searchTerm).map(match=>match[epm_hooks["b"]]).includes(item[epm_hooks["b"]])):list;gridContent=external_kbnSharedDeps_React_default.a.createElement(GridColumn,{list:filteredList})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1},controlsContent),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:3},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSearchBar"],{query:query||undefined,box:{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.searchPackagesPlaceholder",{defaultMessage:"Search for integrations"}),incremental:true},onChange:onQueryChange}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),gridContent))}function ControlsColumn({controls:controls,title:title}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h2",null,title)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:4},controls),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1})))}function GridColumn({list:list}){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{gutterSize:"l",columns:3},list.length?list.map(item=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:Object(pkg_key_from_package_info["a"])(item)},external_kbnSharedDeps_React_default.a.createElement(PackageCard,item))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epmList.noPackagesFoundPlaceholder",defaultMessage:"No packages found"})))))}function CategoryFacets({isLoading:isLoading,categories:categories,selectedCategory:selectedCategory,onCategoryChange:onCategoryChange}){const controls=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFacetGroup"],null,isLoading?external_kbnSharedDeps_React_default.a.createElement(Loading,null):categories.map(category=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFacetButton"],{isSelected:category.id===selectedCategory,key:category.id,id:category.id,quantity:category.count,onClick:()=>onCategoryChange(category)},category.title)));return controls}const HeroCopy=Object(external_kbnSharedDeps_React_["memo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s",justifyContent:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.pageTitle",defaultMessage:"Integrations"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.pageSubtitle",defaultMessage:"Browse integrations for popular apps and services."}))))));const Illustration=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiImage"]).withConfig({displayName:"Illustration",componentId:"jzfja-0"})(["margin-bottom:-68px;width:80%;"]);const HeroImage=Object(external_kbnSharedDeps_React_["memo"])(()=>{const{toAssets:toAssets}=Object(epm_hooks["e"])();const{uiSettings:uiSettings}=Object(hooks["mb"])();const IS_DARK_THEME=uiSettings.get("theme:darkMode");return external_kbnSharedDeps_React_default.a.createElement(Illustration,{alt:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.illustrationAltText",{defaultMessage:"Illustration of an integration"}),url:IS_DARK_THEME?toAssets("illustration_integrations_darkmode.svg"):toAssets("illustration_integrations_lightmode.svg")})});function EPMHomePage(){const{params:{tabId:tabId}}=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();const{getHref:getHref}=Object(hooks["hb"])();return external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:external_kbnSharedDeps_React_default.a.createElement(HeroCopy,null),rightColumn:external_kbnSharedDeps_React_default.a.createElement(HeroImage,null),tabs:[{id:"all_packages",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.allTabText",{defaultMessage:"All integrations"}),href:getHref("integrations_all"),isSelected:tabId!=="installed"},{id:"installed_packages",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.installedTabText",{defaultMessage:"Installed integrations"}),href:getHref("integrations_installed"),isSelected:tabId==="installed"}]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integrations_installed},external_kbnSharedDeps_React_default.a.createElement(InstalledPackages,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integrations_all},external_kbnSharedDeps_React_default.a.createElement(AvailablePackages,null))))}function InstalledPackages(){Object(hooks["J"])("integrations_installed");const{data:allPackages,isLoading:isLoadingPackages}=Object(hooks["bb"])({experimental:true});const[selectedCategory,setSelectedCategory]=Object(external_kbnSharedDeps_React_["useState"])("");const title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.installedTitle",{defaultMessage:"Installed integrations"});const allInstalledPackages=allPackages&&allPackages.response?allPackages.response.filter(pkg=>pkg.status===common_constants["ib"].Installed):[];const updatablePackages=allInstalledPackages.filter(item=>"savedObject"in item&&item.version>item.savedObject.attributes.version);const categories=[{id:"",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.allFilterLinkText",{defaultMessage:"All"}),count:allInstalledPackages.length},{id:"updates_available",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.updatesAvailableFilterLinkText",{defaultMessage:"Updates available"}),count:updatablePackages.length}];const controls=external_kbnSharedDeps_React_default.a.createElement(CategoryFacets,{categories:categories,selectedCategory:selectedCategory,onCategoryChange:({id:id})=>setSelectedCategory(id)});return external_kbnSharedDeps_React_default.a.createElement(PackageListGrid,{isLoading:isLoadingPackages,controls:controls,title:title,list:selectedCategory==="updates_available"?updatablePackages:allInstalledPackages})}function AvailablePackages(){var _allPackagesRes$respo;Object(hooks["J"])("integrations_all");const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const queryParams=new URLSearchParams(Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])().search);const initialCategory=queryParams.get("category")||"";const[selectedCategory,setSelectedCategory]=Object(external_kbnSharedDeps_React_["useState"])(initialCategory);const{data:allPackagesRes,isLoading:isLoadingAllPackages}=Object(hooks["bb"])();const{data:categoryPackagesRes,isLoading:isLoadingCategoryPackages}=Object(hooks["bb"])({category:selectedCategory});const{data:categoriesRes,isLoading:isLoadingCategories}=Object(hooks["Q"])();const packages=categoryPackagesRes&&categoryPackagesRes.response?categoryPackagesRes.response:[];const title=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.allTitle",{defaultMessage:"Browse by category"});const categories=[{id:"",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epmList.allPackagesFilterLinkText",{defaultMessage:"All"}),count:(allPackagesRes===null||allPackagesRes===void 0?void 0:(_allPackagesRes$respo=allPackagesRes.response)===null||_allPackagesRes$respo===void 0?void 0:_allPackagesRes$respo.length)||0},...categoriesRes?categoriesRes.response:[]];const controls=categories?external_kbnSharedDeps_React_default.a.createElement(CategoryFacets,{isLoading:isLoadingCategories||isLoadingAllPackages,categories:categories,selectedCategory:selectedCategory,onCategoryChange:({id:id})=>{if(queryParams.get("category")){history.push({})}setSelectedCategory(id)}}):null;return external_kbnSharedDeps_React_default.a.createElement(PackageListGrid,{isLoading:isLoadingCategoryPackages,title:title,controls:controls,list:packages})}var lt=__webpack_require__(30);var lt_default=__webpack_require__.n(lt);var types=__webpack_require__(111);const UpdateIcon=({size:size="m"})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.updateAvailableTooltip",{defaultMessage:"Update available"}),size:size,type:"alert",color:"warning",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.updateAvailableTooltip",{defaultMessage:"Update available"})});const IntegrationAgentPolicyCount=Object(external_kbnSharedDeps_React_["memo"])(({packageName:packageName})=>{var _data$response$agent_;const{data:data}=Object(hooks["ab"])(packageName);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,(_data$response$agent_=data===null||data===void 0?void 0:data.response.agent_policy_count)!==null&&_data$response$agent_!==void 0?_data$response$agent_:0)});const PanelWrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"PanelWrapper",componentId:"npech1-0"})(["width:","px;height:1px;z-index:1;"],props=>parseFloat(props.theme.eui.euiSize)*6+parseFloat(props.theme.eui.euiSizeXL)*2);const Panel=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).withConfig({displayName:"Panel",componentId:"npech1-1"})(["padding:",";margin-bottom:-100%;svg,img{height:","px;width:","px;}.euiFlexItem{height:","px;justify-content:center;}"],props=>props.theme.eui.spacerSizes.xl,props=>parseFloat(props.theme.eui.euiSize)*6,props=>parseFloat(props.theme.eui.euiSize)*6,props=>parseFloat(props.theme.eui.euiSize)*6);function IconPanel({packageName:packageName,version:version,icons:icons}){const iconType=Object(hooks["ib"])({packageName:packageName,version:version,icons:icons});return external_kbnSharedDeps_React_default.a.createElement(PanelWrapper,null,external_kbnSharedDeps_React_default.a.createElement(Panel,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:iconType,size:"original"})))}function LoadingIconPanel(){return external_kbnSharedDeps_React_default.a.createElement(PanelWrapper,null,external_kbnSharedDeps_React_default.a.createElement(Panel,null,external_kbnSharedDeps_React_default.a.createElement(Loading,null)))}const Screenshots=Object(external_kbnSharedDeps_React_["memo"])(({images:images,packageName:packageName,version:version})=>{const{toPackageImage:toPackageImage}=Object(epm_hooks["e"])();const[currentImageIndex,setCurrentImageIndex]=Object(external_kbnSharedDeps_React_["useState"])(0);const maxImageIndex=Object(external_kbnSharedDeps_React_["useMemo"])(()=>images.length-1,[images.length]);const currentImageUrl=Object(external_kbnSharedDeps_React_["useMemo"])(()=>toPackageImage(images[currentImageIndex],packageName,version),[currentImageIndex,images,packageName,toPackageImage,version]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"row",alignItems:"center",gutterSize:"xs",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.screenshotsTitle",defaultMessage:"Screenshots"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPagination"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.screenshotPaginationAriaLabel",{defaultMessage:"{packageName} screenshot pagination",values:{packageName:packageName}}),pageCount:maxImageIndex+1,activePage:currentImageIndex,onPageClick:activePage=>setCurrentImageIndex(activePage),compressed:true})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,currentImageUrl?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiImage"],{allowFullScreen:true,hasShadow:true,alt:images[currentImageIndex].title||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.screenshotAltText",{defaultMessage:"{packageName} screenshot #{imageNumber}",values:{packageName:packageName,imageNumber:currentImageIndex+1}}),title:images[currentImageIndex].title,url:currentImageUrl}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.screenshotErrorText",defaultMessage:"Unable to load this screenshot"})))});const REL_NOOPENER="noopener";const REL_NOFOLLOW="nofollow";const REL_NOREFERRER="noreferrer";const markdownRenderers={root:({children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{grow:true},children),table:({children:children})=>external_kbnSharedDeps_React_default.a.createElement("table",{className:"euiTable euiTable--responsive"},children),tableRow:({children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableRow"],null,children),tableCell:({isHeader:isHeader,children:children})=>isHeader?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableHeaderCell"],null,children):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTableRowCell"],null,children),heading:({level:level,children:children})=>{switch(level){case 1:return external_kbnSharedDeps_React_default.a.createElement("h3",null,children);case 2:return external_kbnSharedDeps_React_default.a.createElement("h4",null,children);case 3:return external_kbnSharedDeps_React_default.a.createElement("h5",null,children);default:return external_kbnSharedDeps_React_default.a.createElement("h6",null,children)}},link:({children:children,href:href})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:href,target:"_blank",rel:`${REL_NOOPENER} ${REL_NOFOLLOW} ${REL_NOREFERRER}`},children),code:({language:language,value:value})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:language,isCopyable:true},value)};function Readme({readmePath:readmePath,packageName:packageName,version:version}){const[markdown,setMarkdown]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const{toRelativeImage:toRelativeImage}=Object(epm_hooks["e"])();const handleImageUri=external_kbnSharedDeps_React_default.a.useCallback(uri=>{const isRelative=uri.indexOf("http://")===0||uri.indexOf("https://")===0?false:true;const fullUri=isRelative?toRelativeImage({packageName:packageName,version:version,path:uri}):uri;return fullUri},[toRelativeImage,packageName,version]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{Object(hooks["n"])(readmePath).then(res=>{setMarkdown(res.data||"")})},[readmePath]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,markdown!==undefined?external_kbnSharedDeps_React_default.a.createElement(react_markdown_default.a,{transformImageUri:handleImageUri,renderers:markdownRenderers,source:markdown}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{lines:5})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{lines:6})),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingContent"],{lines:4}))))}const DisplayedAssets={kibana:Object.values(types["KibanaAssetType"]),elasticsearch:Object.values(types["ElasticsearchAssetType"])};const AssetTitleMap={dashboard:"Dashboard",ilm_policy:"ILM Policy",ingest_pipeline:"Ingest Pipeline",transform:"Transform",index_pattern:"Index Pattern",index_template:"Index Template",component_template:"Component Template",search:"Saved Search",visualization:"Visualization",input:"Agent input",map:"Map",data_stream_ilm_policy:"Data Stream ILM Policy",lens:"Lens"};const ServiceTitleMap={kibana:"Kibana",elasticsearch:"Elasticsearch"};const AssetIcons={dashboard:"dashboardApp",index_pattern:"indexPatternApp",search:"searchProfilerApp",visualization:"visualizeApp",map:"emsApp",lens:"lensApp"};const ServiceIcons={elasticsearch:"logoElasticsearch",kibana:"logoKibana"};const Details=Object(external_kbnSharedDeps_React_["memo"])(({packageInfo:packageInfo})=>{const{data:categoriesData,isLoading:isLoadingCategories}=Object(hooks["Q"])();const packageCategories=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!isLoadingCategories&&categoriesData&&categoriesData.response){return categoriesData.response.filter(category=>{var _packageInfo$categori;return(_packageInfo$categori=packageInfo.categories)===null||_packageInfo$categori===void 0?void 0:_packageInfo$categori.includes(category.id)}).map(category=>category.title)}return[]},[categoriesData,isLoadingCategories,packageInfo.categories]);const listItems=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _packageInfo$data_str;const items=[{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.versionLabel",defaultMessage:"Version"})),description:packageInfo.version},{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.categoryLabel",defaultMessage:"Category"})),description:packageCategories.join(", ")}];Object(types["entries"])(packageInfo.assets).forEach(([service,typeToParts])=>{const filteredTypes=Object(types["entries"])(typeToParts).reduce((acc,[asset,value])=>{if(DisplayedAssets[service].includes(asset))acc[asset]=value;return acc},{});if(Object.entries(filteredTypes).length){items.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.assetGroupTitle",defaultMessage:"{assetType} assets",values:{assetType:ServiceTitleMap[service]}})),description:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"xs"},Object(types["entries"])(filteredTypes).map(([_type,parts])=>{const type=_type;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center",justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},AssetTitleMap[type]),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiNotificationBadge"],{color:"subdued"},parts.length))))}))})}});const dataStreamTypes=[...new Set(((_packageInfo$data_str=packageInfo.data_streams)===null||_packageInfo$data_str===void 0?void 0:_packageInfo$data_str.map(dataStream=>dataStream.type))||[])];if(dataStreamTypes.length){items.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.featuresLabel",defaultMessage:"Features"})),description:dataStreamTypes.join(", ")})}if(packageInfo.license){items.push({title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.licenseLabel",defaultMessage:"License"})),description:packageInfo.license})}return items},[packageCategories,packageInfo.assets,packageInfo.data_streams,packageInfo.license,packageInfo.version]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.detailsTitle",defaultMessage:"Details"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{type:"column",compressed:true,listItems:listItems})))});const LeftColumn=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"LeftColumn",componentId:"sc-1i2iwy9-0"})(["&&&{margin-top:77px;}"]);const OverviewPage=Object(external_kbnSharedDeps_React_["memo"])(({packageInfo:packageInfo})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(LeftColumn,{grow:2}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:9},packageInfo.readme?external_kbnSharedDeps_React_default.a.createElement(Readme,{readmePath:packageInfo.readme,packageName:packageInfo.name,version:packageInfo.version}):null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:3},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"l",alignItems:"flexStart"},packageInfo.screenshots&&packageInfo.screenshots.length?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(Screenshots,{images:packageInfo.screenshots,packageName:packageInfo.name,version:packageInfo.version})):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(Details,{packageInfo:packageInfo}))))));var use_request=__webpack_require__(23);const usePackagePoliciesWithAgentPolicy=query=>{const{data:packagePoliciesData,error:error,isLoading:isLoadingPackagePolicies}=Object(hooks["Z"])(query);const agentPoliciesFilter=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!(packagePoliciesData!==null&&packagePoliciesData!==void 0&&packagePoliciesData.items.length)){return""}const includedAgentPolicies=new Set;return`${constants["c"]}.package_policies: (${packagePoliciesData.items.filter(packagePolicy=>{if(includedAgentPolicies.has(packagePolicy.policy_id)){return false}includedAgentPolicies.add(packagePolicy.policy_id);return true}).map(packagePolicy=>packagePolicy.id).join(" or ")}) `},[packagePoliciesData]);const{data:agentPoliciesData,isLoading:isLoadingAgentPolicies}=Object(use_request["c"])({path:services["b"].getListPath(),method:"get",query:{perPage:100,kuery:agentPoliciesFilter},shouldSendRequest:!!(packagePoliciesData!==null&&packagePoliciesData!==void 0&&packagePoliciesData.items.length)});const[enrichedData,setEnrichedData]=Object(external_kbnSharedDeps_React_["useState"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(isLoadingPackagePolicies||isLoadingAgentPolicies){return}if(!(packagePoliciesData!==null&&packagePoliciesData!==void 0&&packagePoliciesData.items)){setEnrichedData(undefined);return}const agentPoliciesById={};if(agentPoliciesData!==null&&agentPoliciesData!==void 0&&agentPoliciesData.items){for(const agentPolicy of agentPoliciesData.items){agentPoliciesById[agentPolicy.id]=agentPolicy}}const updatedPackageData=packagePoliciesData.items.map(packagePolicy=>({packagePolicy:packagePolicy,agentPolicy:agentPoliciesById[packagePolicy.policy_id]}));setEnrichedData({...packagePoliciesData,items:updatedPackageData})},[isLoadingAgentPolicies,isLoadingPackagePolicies,packagePoliciesData,agentPoliciesData]);return{data:enrichedData,error:error,isLoading:isLoadingPackagePolicies||isLoadingAgentPolicies}};function persona_extends(){persona_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return persona_extends.apply(this,arguments)}const persona_MIN_WIDTH={minWidth:0};const Persona=Object(external_kbnSharedDeps_React_["memo"])(({name:name,className:className,"data-test-subj":dataTestSubj,title:title,...otherAvatarProps})=>{const getTestId=Object(external_kbnSharedDeps_React_["useCallback"])(suffix=>{if(dataTestSubj){return`${dataTestSubj}-${suffix}`}},[dataTestSubj]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"baseline",style:persona_MIN_WIDTH,className:className,"data-test-subj":dataTestSubj,title:title,responsive:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAvatar"],persona_extends({name:name,"data-test-subj":getTestId("avatar")},otherAvatarProps))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textTruncate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s",className:"eui-textTruncate","data-test-subj":getTestId("name")},name)))});const IntegrationDetailsLink=Object(external_kbnSharedDeps_React_["memo"])(({packagePolicy:packagePolicy})=>{const{getHref:getHref}=Object(hooks["hb"])();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{className:"eui-textTruncate","data-test-subj":"integrationNameLink",title:packagePolicy.name,href:getHref("integration_policy_edit",{packagePolicyId:packagePolicy.id})},packagePolicy.name)});const AgentPolicyDetailLink=Object(external_kbnSharedDeps_React_["memo"])(({agentPolicyId:agentPolicyId,revision:revision,children:children})=>{const{getHref:getHref}=Object(hooks["hb"])();return external_kbnSharedDeps_React_default.a.createElement(LinkAndRevision,{className:"eui-textTruncate",revision:revision,href:getHref("policy_details",{policyId:agentPolicyId})},children)});const PackagePoliciesPage=({name:name,version:version})=>{const{getPath:getPath}=Object(hooks["hb"])();const getPackageInstallStatus=Object(epm_hooks["c"])();const packageInstallStatus=getPackageInstallStatus(name);const{pagination:pagination,pageSizeOptions:pageSizeOptions,setPagination:setPagination}=Object(hooks["nb"])();const{data:data,isLoading:isLoading}=usePackagePoliciesWithAgentPolicy({page:pagination.currentPage,perPage:pagination.pageSize,kuery:`${constants["i"]}.package.name: ${name}`});const handleTableOnChange=Object(external_kbnSharedDeps_React_["useCallback"])(({page:page})=>{setPagination({currentPage:page.index+1,pageSize:page.size})},[setPagination]);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{field:"packagePolicy.name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.packageDetails.integrationList.name",{defaultMessage:"Integration"}),render(_,{packagePolicy:packagePolicy}){return external_kbnSharedDeps_React_default.a.createElement(IntegrationDetailsLink,{packagePolicy:packagePolicy})}},{field:"packagePolicy.package.version",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.packageDetails.integrationList.version",{defaultMessage:"Version"})},{field:"packagePolicy.policy_id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.packageDetails.integrationList.agentPolicy",{defaultMessage:"Agent policy"}),truncateText:true,render(id,{agentPolicy:agentPolicy}){var _agentPolicy$name;return external_kbnSharedDeps_React_default.a.createElement(AgentPolicyDetailLink,{agentPolicyId:id,revision:agentPolicy.revision},(_agentPolicy$name=agentPolicy.name)!==null&&_agentPolicy$name!==void 0?_agentPolicy$name:id)}},{field:"",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.packageDetails.integrationList.agentCount",{defaultMessage:"Agents"}),truncateText:true,align:"right",width:"8ch",render({packagePolicy:packagePolicy,agentPolicy:agentPolicy}){var _agentPolicy$agents;return external_kbnSharedDeps_React_default.a.createElement(LinkedAgentCount,{count:(_agentPolicy$agents=agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.agents)!==null&&_agentPolicy$agents!==void 0?_agentPolicy$agents:0,agentPolicyId:packagePolicy.policy_id,className:"eui-textTruncate","data-test-subj":"rowAgentCount"})}},{field:"packagePolicy.updated_by",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.packageDetails.integrationList.updatedBy",{defaultMessage:"Last Updated By"}),truncateText:true,render(updatedBy){return external_kbnSharedDeps_React_default.a.createElement(Persona,{size:"s",name:updatedBy,title:updatedBy})}},{field:"packagePolicy.updated_at",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.packageDetails.integrationList.updatedAt",{defaultMessage:"Last Updated"}),truncateText:true,render(updatedAt){return external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textTruncate",title:updatedAt},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedRelative"],{value:updatedAt}))}}],[]);const noItemsMessage=Object(external_kbnSharedDeps_React_["useMemo"])(()=>isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.packageDetails.integrationList.loadingPoliciesMessage",defaultMessage:"Loading integration policies…"}):undefined,[isLoading]);const tablePagination=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _data$total;return{pageIndex:pagination.currentPage-1,pageSize:pagination.pageSize,totalItemCount:(_data$total=data===null||data===void 0?void 0:data.total)!==null&&_data$total!==void 0?_data$total:0,pageSizeOptions:pageSizeOptions}},[data===null||data===void 0?void 0:data.total,pageSizeOptions,pagination.currentPage,pagination.pageSize]);if(packageInstallStatus.status!==types["InstallStatus"].installed){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:getPath("integration_details_overview",{pkgkey:`${name}-${version}`})})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:6},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:(data===null||data===void 0?void 0:data.items)||[],columns:columns,loading:isLoading,"data-test-subj":"integrationPolicyTable",pagination:tablePagination,onChange:handleTableOnChange,noItemsMessage:noItemsMessage})))};const ConfirmPackageUninstall=props=>{const{onCancel:onCancel,onConfirm:onConfirm,packageName:packageName,numOfAssets:numOfAssets}=props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmUninstallModal.uninstallTitle",defaultMessage:"Uninstall {packageName}",values:{packageName:packageName}}),onCancel:onCancel,onConfirm:onConfirm,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmUninstallModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmUninstallModal.uninstallButtonLabel",defaultMessage:"Uninstall {packageName}",values:{packageName:packageName}}),defaultFocusedButton:"confirm",buttonColor:"danger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:"danger",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmUninstallModal.uninstallCallout.title",defaultMessage:"This action will remove {numOfAssets} assets",values:{numOfAssets:numOfAssets}})},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmUninstallModal.uninstallCallout.description",defaultMessage:"Kibana and Elasticsearch assets that were created by this integration will be removed. Agents policies and any data sent by your agents will not be effected."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmUninstallModal.uninstallDescription",defaultMessage:"This action cannot be undone. Are you sure you wish to continue?"})))};const ConfirmPackageInstall=props=>{const{onCancel:onCancel,onConfirm:onConfirm,packageName:packageName,numOfAssets:numOfAssets}=props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmInstallModal.installTitle",defaultMessage:"Install {packageName}",values:{packageName:packageName}}),onCancel:onCancel,onConfirm:onConfirm,cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmInstallModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmInstallModal.installButtonLabel",defaultMessage:"Install {packageName}",values:{packageName:packageName}}),defaultFocusedButton:"confirm"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{iconType:"iInCircle",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmInstallModal.installCalloutTitle",defaultMessage:"This action will install {numOfAssets} assets",values:{numOfAssets:numOfAssets}})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.confirmInstallModal.installDescription",defaultMessage:"Kibana assets will be installed in the current Space (Default) and will only be accessible to users who have permission to view this Space. Elasticsearch assets are installed globally and will be accessible to all Kibana users."})))};function InstallationButton(props){const{assets:assets,name:name,title:title,version:version,disabled:disabled=true,isUpdate:isUpdate=false}=props;const hasWriteCapabilites=Object(hooks["K"])().write;const installPackage=Object(epm_hooks["d"])();const uninstallPackage=Object(epm_hooks["h"])();const getPackageInstallStatus=Object(epm_hooks["c"])();const{status:installationStatus}=getPackageInstallStatus(name);const isInstalling=installationStatus===types["InstallStatus"].installing;const isRemoving=installationStatus===types["InstallStatus"].uninstalling;const isInstalled=installationStatus===types["InstallStatus"].installed;const showUninstallButton=isInstalled||isRemoving;const[isModalVisible,setModalVisible]=Object(external_kbnSharedDeps_React_["useState"])(false);const toggleModal=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setModalVisible(!isModalVisible)},[isModalVisible]);const handleClickInstall=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{installPackage({name:name,version:version,title:title});toggleModal()},[installPackage,name,title,toggleModal,version]);const handleClickUpdate=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{installPackage({name:name,version:version,title:title,fromUpdate:true})},[installPackage,name,title,version]);const handleClickUninstall=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{uninstallPackage({name:name,version:version,title:title});toggleModal()},[uninstallPackage,name,title,toggleModal,version]);const numOfAssets=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object.entries(assets).reduce((acc,[serviceName,serviceNameValue])=>acc+Object.entries(serviceNameValue).reduce((acc2,[assetName,assetNameValue])=>acc2+assetNameValue.length,0),0),[assets]);const installButton=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"importAction",isLoading:isInstalling,onClick:toggleModal},isInstalling?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.installPackage.installingPackageButtonLabel",defaultMessage:"Installing {title} assets",values:{title:title}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.installPackage.installPackageButtonLabel",defaultMessage:"Install {title} assets",values:{title:title}}));const updateButton=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"refresh",isLoading:isInstalling,onClick:handleClickUpdate},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.updatePackage.updatePackageButtonLabel",defaultMessage:"Update to latest version"}));const uninstallButton=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"trash",isLoading:isRemoving,onClick:toggleModal,color:"danger",disabled:disabled||isRemoving?true:false},isRemoving?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.uninstallPackage.uninstallingPackageButtonLabel",defaultMessage:"Uninstalling {title}",values:{title:title}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.uninstallPackage.uninstallPackageButtonLabel",defaultMessage:"Uninstall {title}",values:{title:title}}));const uninstallModal=external_kbnSharedDeps_React_default.a.createElement(ConfirmPackageUninstall,{numOfAssets:numOfAssets,packageName:title,onCancel:toggleModal,onConfirm:handleClickUninstall});const installModal=external_kbnSharedDeps_React_default.a.createElement(ConfirmPackageInstall,{numOfAssets:numOfAssets,packageName:title,onCancel:toggleModal,onConfirm:handleClickInstall});return hasWriteCapabilites?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,isUpdate?updateButton:showUninstallButton?uninstallButton:installButton,isModalVisible&&(isInstalled?uninstallModal:installModal)):null}function settings_extends(){settings_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return settings_extends.apply(this,arguments)}const SettingsTitleCell=external_kbnSharedDeps_StyledComponents_default.a.td.withConfig({displayName:"SettingsTitleCell",componentId:"sc-1sli6ff-0"})(["padding-right:",";padding-bottom:",";"],props=>props.theme.eui.spacerSizes.xl,props=>props.theme.eui.spacerSizes.m);const UpdatesAvailableMsgContainer=external_kbnSharedDeps_StyledComponents_default.a.span.withConfig({displayName:"UpdatesAvailableMsgContainer",componentId:"sc-1sli6ff-1"})(["padding-left:",";"],props=>props.theme.eui.spacerSizes.s);const NoteLabel=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallNoteLabel",defaultMessage:"Note:"});const UpdatesAvailableMsg=()=>external_kbnSharedDeps_React_default.a.createElement(UpdatesAvailableMsgContainer,null,external_kbnSharedDeps_React_default.a.createElement(UpdateIcon,{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.versionInfo.updatesAvailable",defaultMessage:"Updates are available"}));const SettingsPage=Object(external_kbnSharedDeps_React_["memo"])(({packageInfo:packageInfo})=>{const{name:name,title:title,removable:removable,latestVersion:latestVersion,version:version}=packageInfo;const getPackageInstallStatus=Object(epm_hooks["c"])();const{data:packagePoliciesData}=Object(hooks["Z"])({perPage:0,page:1,kuery:`${constants["i"]}.package.name:${name}`});const{status:installationStatus,version:installedVersion}=getPackageInstallStatus(name);const packageHasUsages=!!(packagePoliciesData!==null&&packagePoliciesData!==void 0&&packagePoliciesData.total);const updateAvailable=installedVersion&&lt_default()(installedVersion,latestVersion)?true:false;const isViewingOldPackage=version<latestVersion;const hideInstallOptions=installationStatus===types["InstallStatus"].notInstalled&&isViewingOldPackage||installationStatus===types["InstallStatus"].installed&&installedVersion!==version;const isUpdating=installationStatus===types["InstallStatus"].installing&&installedVersion;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:6},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageSettingsTitle",defaultMessage:"Settings"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),installedVersion!==null&&external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageVersionTitle",defaultMessage:"{title} version",values:{title:title}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("table",null,external_kbnSharedDeps_React_default.a.createElement("tbody",null,external_kbnSharedDeps_React_default.a.createElement("tr",null,external_kbnSharedDeps_React_default.a.createElement(SettingsTitleCell,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.versionInfo.installedVersion",defaultMessage:"Installed version"})),external_kbnSharedDeps_React_default.a.createElement("td",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("span",null,installedVersion)),updateAvailable&&external_kbnSharedDeps_React_default.a.createElement(UpdatesAvailableMsg,null))),external_kbnSharedDeps_React_default.a.createElement("tr",null,external_kbnSharedDeps_React_default.a.createElement(SettingsTitleCell,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.versionInfo.latestVersion",defaultMessage:"Latest version"})),external_kbnSharedDeps_React_default.a.createElement("td",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("span",null,latestVersion)))))),updateAvailable&&external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(InstallationButton,settings_extends({},packageInfo,{version:latestVersion,disabled:false,isUpdate:true})))),!hideInstallOptions&&!isUpdating&&external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),installationStatus===types["InstallStatus"].notInstalled||installationStatus===types["InstallStatus"].installing?external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageInstallTitle",defaultMessage:"Install {title}",values:{title:title}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageInstallDescription",defaultMessage:"Install this integration to setup Kibana and Elasticsearch assets designed for {title} data.",values:{title:title}}))):external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageUninstallTitle",defaultMessage:"Uninstall {title}",values:{title:title}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageUninstallDescription",defaultMessage:"Remove Kibana and Elasticsearch assets that were installed by this integration."}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(InstallationButton,settings_extends({},packageInfo,{disabled:!packagePoliciesData||removable===false?true:packageHasUsages}))))),packageHasUsages&&removable===true&&external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallNoteDetail",defaultMessage:"{strongNote} {title} cannot be uninstalled because there are active agents that use this integration. To uninstall, remove all {title} integrations from your agent policies.",values:{title:title,strongNote:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(NoteLabel,null))}})),removable===false&&external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.integrations.settings.packageUninstallNoteDescription.packageUninstallUninstallableNoteDetail",defaultMessage:"{strongNote} The {title} integration is installed by default and cannot be removed.",values:{title:title,strongNote:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_React_default.a.createElement(NoteLabel,null))}}))))))});const CustomViewPage=Object(external_kbnSharedDeps_React_["memo"])(({packageInfo:packageInfo})=>{const CustomView=useUIExtension(packageInfo.name,"package-detail-custom");const{getPath:getPath}=Object(hooks["hb"])();const pkgkey=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(pkg_key_from_package_info["a"])(packageInfo),[packageInfo]);return CustomView?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:1}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:6},external_kbnSharedDeps_React_default.a.createElement(ExtensionWrapper,null,external_kbnSharedDeps_React_default.a.createElement(CustomView,{pkgkey:pkgkey,packageInfo:packageInfo})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:getPath("integration_details_overview",{pkgkey:pkgkey})})});var detail=__webpack_require__(264);const Divider=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Divider",componentId:"sc-9vnm9c-0"})(["width:0;height:100%;border-left:",";"],props=>props.theme.eui.euiBorderThin);const FlexItemWithMinWidth=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-9vnm9c-1"})(["min-width:0px;"]);function Breadcrumbs({packageTitle:packageTitle}){Object(hooks["J"])("integration_details_overview",{pkgTitle:packageTitle});return null}function Detail(){var _packageInfoData$resp;const{pkgkey:pkgkey,panel:panel}=Object(external_kbnSharedDeps_ReactRouterDom_["useParams"])();const{getHref:getHref,getPath:getPath}=Object(hooks["hb"])();const hasWriteCapabilites=Object(hooks["K"])().write;const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const location=Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])();const[packageInfo,setPackageInfo]=Object(external_kbnSharedDeps_React_["useState"])(null);const setPackageInstallStatus=Object(epm_hooks["g"])();const getPackageInstallStatus=Object(epm_hooks["c"])();const packageInstallStatus=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(packageInfo===null||!packageInfo.name){return undefined}return getPackageInstallStatus(packageInfo.name).status},[packageInfo,getPackageInstallStatus]);const updateAvailable=packageInfo&&"savedObject"in packageInfo&&packageInfo.savedObject&&lt_default()(packageInfo.savedObject.attributes.version,packageInfo.latestVersion);const{data:packageInfoData,error:packageInfoError,isLoading:isLoading}=Object(hooks["Y"])(pkgkey);const showCustomTab=useUIExtension((_packageInfoData$resp=packageInfoData===null||packageInfoData===void 0?void 0:packageInfoData.response.name)!==null&&_packageInfoData$resp!==void 0?_packageInfoData$resp:"","package-detail-custom")!==undefined;Object(external_kbnSharedDeps_React_["useEffect"])(()=>{if(packageInfoData!==null&&packageInfoData!==void 0&&packageInfoData.response){const packageInfoResponse=packageInfoData.response;setPackageInfo(packageInfoResponse);let installedVersion;const{name:name}=packageInfoData.response;if("savedObject"in packageInfoResponse){installedVersion=packageInfoResponse.savedObject.attributes.version}const status=packageInfoResponse===null||packageInfoResponse===void 0?void 0:packageInfoResponse.status;if(name){setPackageInstallStatus({name:name,status:status,version:installedVersion||null})}}},[packageInfoData,setPackageInstallStatus,setPackageInfo]);const headerLeftContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"arrowLeft",size:"xs",flush:"left",href:getHref("integrations_all")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.browseAllButtonText",defaultMessage:"Browse all integrations"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"l"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},isLoading||!packageInfo?external_kbnSharedDeps_React_default.a.createElement(LoadingIconPanel,null):external_kbnSharedDeps_React_default.a.createElement(IconPanel,{packageName:packageInfo.name,version:packageInfo.version,icons:packageInfo.icons})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(FlexItemWithMinWidth,{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,(packageInfo===null||packageInfo===void 0?void 0:packageInfo.title)||" "))),packageInfo!==null&&packageInfo!==void 0&&packageInfo.release&&packageInfo.release!=="ga"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:RELEASE_BADGE_LABEL[packageInfo.release],tooltipContent:RELEASE_BADGE_DESCRIPTION[packageInfo.release]})):null))))),[getHref,isLoading,packageInfo]);const handleAddIntegrationPolicyClick=Object(external_kbnSharedDeps_React_["useCallback"])(ev=>{ev.preventDefault();const currentPath=history.createHref({pathname:location.pathname,search:location.search,hash:location.hash});const redirectToPath=[constants["k"],{path:currentPath}];const redirectBackRouteState={onSaveNavigateTo:redirectToPath,onCancelNavigateTo:redirectToPath,onCancelUrl:currentPath};history.push({pathname:getPath("add_integration_to_policy",{pkgkey:pkgkey}),state:redirectBackRouteState})},[getPath,history,location.hash,location.pathname,location.search,pkgkey]);const headerRightContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>packageInfo?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",direction:"row"},[{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.versionLabel",{defaultMessage:"Version"}),content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,packageInfo.version),updateAvailable?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(UpdateIcon,null)):null)},...packageInstallStatus==="installed"?[{isDivider:true},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.epm.usedByLabel",{defaultMessage:"Agent policies"}),"data-test-subj":"agentPolicyCount",content:external_kbnSharedDeps_React_default.a.createElement(IntegrationAgentPolicyCount,{packageName:packageInfo.name})}]:[],{isDivider:true},{content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,isDisabled:!hasWriteCapabilites,iconType:"plusInCircle",href:getHref("add_integration_to_policy",{pkgkey:pkgkey}),onClick:handleAddIntegrationPolicyClick,"data-test-subj":"addIntegrationPolicyButton"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.addPackagePolicyButtonText",defaultMessage:"Add {packageName}",values:{packageName:packageInfo.title}}))}].map((item,index)=>{var _item$isDivider;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,key:index,"data-test-subj":item["data-test-subj"]},((_item$isDivider=item.isDivider)!==null&&_item$isDivider!==void 0?_item$isDivider:false)?external_kbnSharedDeps_React_default.a.createElement(Divider,null):item.label?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{className:"eui-textRight",compressed:true,textStyle:"reverse"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,item.label),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,item.content)):item.content)}))):undefined,[getHref,handleAddIntegrationPolicyClick,hasWriteCapabilites,packageInfo,packageInstallStatus,pkgkey,updateAvailable]);const headerTabs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(!packageInfo){return[]}const packageInfoKey=Object(pkg_key_from_package_info["a"])(packageInfo);const tabs=[{id:"overview",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.packageDetailsNav.overviewLinkText",defaultMessage:"Overview"}),isSelected:panel==="overview","data-test-subj":`tab-overview`,href:getHref("integration_details_overview",{pkgkey:packageInfoKey})}];if(packageInstallStatus===types["InstallStatus"].installed){tabs.push({id:"policies",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.packageDetailsNav.packagePoliciesLinkText",defaultMessage:"Policies"}),isSelected:panel==="policies","data-test-subj":`tab-policies`,href:getHref("integration_details_policies",{pkgkey:packageInfoKey})})}tabs.push({id:"settings",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.packageDetailsNav.settingsLinkText",defaultMessage:"Settings"}),isSelected:panel==="settings","data-test-subj":`tab-settings`,href:getHref("integration_details_settings",{pkgkey:packageInfoKey})});if(showCustomTab){tabs.push({id:"custom",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.packageDetailsNav.packageCustomLinkText",defaultMessage:"Advanced"}),isSelected:panel==="custom","data-test-subj":`tab-custom`,href:getHref("integration_details_custom",{pkgkey:packageInfoKey})})}return tabs},[getHref,packageInfo,panel,showCustomTab,packageInstallStatus]);return external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:headerLeftContent,rightColumn:headerRightContent,rightColumnGrow:false,tabs:headerTabs,tabsClassName:"fleet__epm__shiftNavTabs"},packageInfo?external_kbnSharedDeps_React_default.a.createElement(Breadcrumbs,{packageTitle:packageInfo.title}):null,packageInfoError?external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.epm.loadingIntegrationErrorTitle",defaultMessage:"Error loading integration details"}),error:packageInfoError}):isLoading||!packageInfo?external_kbnSharedDeps_React_default.a.createElement(Loading,null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integration_details_overview},external_kbnSharedDeps_React_default.a.createElement(OverviewPage,{packageInfo:packageInfo})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integration_details_settings},external_kbnSharedDeps_React_default.a.createElement(SettingsPage,{packageInfo:packageInfo})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integration_details_policies},external_kbnSharedDeps_React_default.a.createElement(PackagePoliciesPage,{name:packageInfo.name,version:packageInfo.version})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integration_details_custom},external_kbnSharedDeps_React_default.a.createElement(CustomViewPage,{packageInfo:packageInfo})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:constants["j"].integration_details_overview})))}function edit_package_policy_page_extends(){edit_package_policy_page_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return edit_package_policy_page_extends.apply(this,arguments)}const EditPackagePolicyPage=Object(external_kbnSharedDeps_React_["memo"])(()=>{const{params:{packagePolicyId:packagePolicyId}}=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();return external_kbnSharedDeps_React_default.a.createElement(EditPackagePolicyForm,{packagePolicyId:packagePolicyId})});const EditPackagePolicyForm=Object(external_kbnSharedDeps_React_["memo"])(({packagePolicyId:packagePolicyId,from:from="edit"})=>{var _agentPolicy$id,_packagePolicy$packag,_packagePolicy$packag2;const{notifications:notifications}=Object(hooks["mb"])();const{agents:{enabled:isFleetEnabled}}=Object(hooks["M"])();const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{getHref:getHref,getPath:getPath}=Object(hooks["hb"])();const[isLoadingData,setIsLoadingData]=Object(external_kbnSharedDeps_React_["useState"])(true);const[loadingError,setLoadingError]=Object(external_kbnSharedDeps_React_["useState"])();const[agentPolicy,setAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])();const[packageInfo,setPackageInfo]=Object(external_kbnSharedDeps_React_["useState"])();const[packagePolicy,setPackagePolicy]=Object(external_kbnSharedDeps_React_["useState"])({name:"",description:"",namespace:"",policy_id:"",enabled:true,output_id:"",inputs:[],version:""});const[originalPackagePolicy,setOriginalPackagePolicy]=Object(external_kbnSharedDeps_React_["useState"])();const policyId=(_agentPolicy$id=agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.id)!==null&&_agentPolicy$id!==void 0?_agentPolicy$id:"";Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const getData=async()=>{setIsLoadingData(true);setLoadingError(undefined);try{const{data:packagePolicyData,error:packagePolicyError}=await Object(hooks["r"])(packagePolicyId);if(packagePolicyError){throw packagePolicyError}const{data:agentPolicyData,error:agentPolicyError}=await Object(hooks["o"])(packagePolicyData.item.policy_id);if(agentPolicyError){throw agentPolicyError}if(agentPolicyData!==null&&agentPolicyData!==void 0&&agentPolicyData.item){setAgentPolicy(agentPolicyData.item)}if(packagePolicyData!==null&&packagePolicyData!==void 0&&packagePolicyData.item){setOriginalPackagePolicy(packagePolicyData.item);const{id:id,revision:revision,inputs:inputs,created_by:created_by,created_at:created_at,updated_by:updated_by,updated_at:updated_at,...restOfPackagePolicy}=packagePolicyData.item;const newPackagePolicy={...restOfPackagePolicy,inputs:inputs.map(input=>{const{streams:streams,compiled_input:compiledInput,...restOfInput}=input;return{...restOfInput,streams:streams.map(stream=>{const{compiled_stream:compiled_stream,...restOfStream}=stream;return restOfStream})}})};setPackagePolicy(newPackagePolicy);if(packagePolicyData.item.package){const{data:packageData}=await Object(hooks["s"])(Object(pkg_key_from_package_info["a"])(packagePolicyData.item.package));if(packageData!==null&&packageData!==void 0&&packageData.response){setPackageInfo(packageData.response);setValidationResults(validatePackagePolicy(newPackagePolicy,packageData.response));setFormState("VALID")}}}}catch(e){setLoadingError(e)}setIsLoadingData(false)};getData()},[policyId,packagePolicyId]);const[agentCount,setAgentCount]=Object(external_kbnSharedDeps_React_["useState"])(0);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const getAgentCount=async()=>{const{data:data}=await Object(hooks["k"])({policyId:policyId});if(data!==null&&data!==void 0&&data.results.total){setAgentCount(data.results.total)}};if(isFleetEnabled&&policyId){getAgentCount()}},[policyId,isFleetEnabled]);const[validationResults,setValidationResults]=Object(external_kbnSharedDeps_React_["useState"])();const hasErrors=validationResults?validationHasErrors(validationResults):false;const updatePackagePolicyValidation=Object(external_kbnSharedDeps_React_["useCallback"])(newPackagePolicy=>{if(packageInfo){const newValidationResult=validatePackagePolicy(newPackagePolicy||packagePolicy,packageInfo);setValidationResults(newValidationResult);console.debug("Package policy validation results",newValidationResult);return newValidationResult}},[packagePolicy,packageInfo]);const updatePackagePolicy=Object(external_kbnSharedDeps_React_["useCallback"])(updatedFields=>{const newPackagePolicy={...packagePolicy,...updatedFields};setPackagePolicy(newPackagePolicy);console.debug("Package policy updated",newPackagePolicy);const newValidationResults=updatePackagePolicyValidation(newPackagePolicy);const hasValidationErrors=newValidationResults?validationHasErrors(newValidationResults):false;if(!hasValidationErrors){setFormState("VALID")}},[packagePolicy,updatePackagePolicyValidation]);const handleExtensionViewOnChange=Object(external_kbnSharedDeps_React_["useCallback"])(({isValid:isValid,updatedPolicy:updatedPolicy})=>{updatePackagePolicy(updatedPolicy);setFormState(prevState=>{if(prevState==="VALID"&&!isValid){return"INVALID"}return prevState})},[updatePackagePolicy]);const cancelUrl=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(packageInfo&&policyId){return from==="package-edit"?getHref("integration_details_policies",{pkgkey:Object(pkg_key_from_package_info["a"])(packageInfo)}):getHref("policy_details",{policyId:policyId})}return"/"},[from,getHref,packageInfo,policyId]);const successRedirectPath=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(packageInfo&&policyId){return from==="package-edit"?getPath("integration_details_policies",{pkgkey:Object(pkg_key_from_package_info["a"])(packageInfo)}):getPath("policy_details",{policyId:policyId})}return"/"},[from,getPath,packageInfo,policyId]);const[formState,setFormState]=Object(external_kbnSharedDeps_React_["useState"])("INVALID");const savePackagePolicy=async()=>{setFormState("LOADING");const result=await Object(hooks["I"])(packagePolicyId,packagePolicy);setFormState("SUBMITTED");return result};const onSubmit=async()=>{if(formState==="VALID"&&hasErrors){setFormState("INVALID");return}if(agentCount!==0&&formState!=="CONFIRM"){setFormState("CONFIRM");return}const{error:error}=await savePackagePolicy();if(!error){history.push(successRedirectPath);notifications.toasts.addSuccess({title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editPackagePolicy.updatedNotificationTitle",{defaultMessage:`Successfully updated '{packagePolicyName}'`,values:{packagePolicyName:packagePolicy.name}}),"data-test-subj":"policyUpdateSuccessToast",text:agentCount&&agentPolicy?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editPackagePolicy.updatedNotificationMessage",{defaultMessage:`Fleet will deploy updates to all agents that use the '{agentPolicyName}' policy`,values:{agentPolicyName:agentPolicy.name}}):undefined})}else{if(error.statusCode===409){notifications.toasts.addError(error,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editPackagePolicy.failedNotificationTitle",{defaultMessage:`Error updating '{packagePolicyName}'`,values:{packagePolicyName:packagePolicy.name}}),toastMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editPackagePolicy.failedConflictNotificationMessage",{defaultMessage:`Data is out of date. Refresh the page to get the latest policy.`})})}else{notifications.toasts.addError(error,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editPackagePolicy.failedNotificationTitle",{defaultMessage:`Error updating '{packagePolicyName}'`,values:{packagePolicyName:packagePolicy.name}})})}setFormState("VALID")}};const layoutProps={from:from,cancelUrl:cancelUrl,agentPolicy:agentPolicy,packageInfo:packageInfo};const ExtensionView=useUIExtension((_packagePolicy$packag=(_packagePolicy$packag2=packagePolicy.package)===null||_packagePolicy$packag2===void 0?void 0:_packagePolicy$packag2.name)!==null&&_packagePolicy$packag!==void 0?_packagePolicy$packag:"","package-policy-edit");const configurePackage=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _packagePolicy$packag3;return agentPolicy&&packageInfo?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StepDefinePackagePolicy,{agentPolicy:agentPolicy,packageInfo:packageInfo,packagePolicy:packagePolicy,updatePackagePolicy:updatePackagePolicy,validationResults:validationResults}),!ExtensionView&&external_kbnSharedDeps_React_default.a.createElement(StepConfigurePackagePolicy,{from:"edit",packageInfo:packageInfo,packagePolicy:packagePolicy,packagePolicyId:packagePolicyId,updatePackagePolicy:updatePackagePolicy,validationResults:validationResults,submitAttempted:formState==="INVALID"}),ExtensionView&&packagePolicy.policy_id&&((_packagePolicy$packag3=packagePolicy.package)===null||_packagePolicy$packag3===void 0?void 0:_packagePolicy$packag3.name)&&originalPackagePolicy&&external_kbnSharedDeps_React_default.a.createElement(ExtensionWrapper,null,external_kbnSharedDeps_React_default.a.createElement(ExtensionView,{policy:originalPackagePolicy,newPolicy:packagePolicy,onChange:handleExtensionViewOnChange}))):null},[agentPolicy,packageInfo,packagePolicy,updatePackagePolicy,validationResults,packagePolicyId,formState,originalPackagePolicy,ExtensionView,handleExtensionViewOnChange]);return external_kbnSharedDeps_React_default.a.createElement(CreatePackagePolicyPageLayout,edit_package_policy_page_extends({},layoutProps,{"data-test-subj":"editPackagePolicy"}),isLoadingData?external_kbnSharedDeps_React_default.a.createElement(Loading,null):loadingError||!agentPolicy||!packageInfo?external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editPackagePolicy.errorLoadingDataTitle",defaultMessage:"Error loading data"}),error:loadingError||external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editPackagePolicy.errorLoadingDataMessage",{defaultMessage:"There was an error loading this integration information"})}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,from==="package"||from==="package-edit"?external_kbnSharedDeps_React_default.a.createElement(IntegrationsBreadcrumb,{pkgkey:Object(pkg_key_from_package_info["a"])(packageInfo),pkgTitle:packageInfo.title,policyName:packagePolicy.name}):external_kbnSharedDeps_React_default.a.createElement(PoliciesBreadcrumb,{policyName:agentPolicy.name,policyId:policyId}),formState==="CONFIRM"&&external_kbnSharedDeps_React_default.a.createElement(ConfirmDeployAgentPolicyModal,{agentCount:agentCount,agentPolicy:agentPolicy,onConfirm:onSubmit,onCancel:()=>setFormState("VALID")}),configurePackage,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBottomBar"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},agentPolicy&&packageInfo&&formState==="INVALID"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.createPackagePolicy.errorOnSaveText",defaultMessage:"Your integration policy has errors. Please fix them before saving."}):null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"ghost",href:cancelUrl},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editPackagePolicy.cancelButton",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onSubmit,isLoading:formState==="LOADING",disabled:formState!=="VALID",iconType:"save",color:"primary",fill:true,"data-test-subj":"saveIntegration"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editPackagePolicy.saveButton",defaultMessage:"Save integration"})))))))))});const PoliciesBreadcrumb=({policyName:policyName,policyId:policyId})=>{Object(hooks["J"])("edit_integration",{policyName:policyName,policyId:policyId});return null};const IntegrationsBreadcrumb=Object(external_kbnSharedDeps_React_["memo"])(({pkgTitle:pkgTitle,policyName:policyName,pkgkey:pkgkey})=>{Object(hooks["J"])("integration_policy_edit",{policyName:policyName,pkgTitle:pkgTitle,pkgkey:pkgkey});return null});const Policy=Object(external_kbnSharedDeps_React_["memo"])(()=>{const{params:{packagePolicyId:packagePolicyId}}=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();return external_kbnSharedDeps_React_default.a.createElement(EditPackagePolicyForm,{packagePolicyId:packagePolicyId,from:"package-edit"})});const EPMApp=()=>{Object(hooks["J"])("integrations");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].add_integration_to_policy},external_kbnSharedDeps_React_default.a.createElement(CreatePackagePolicyPage,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integration_policy_edit},external_kbnSharedDeps_React_default.a.createElement(Policy,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integration_details},external_kbnSharedDeps_React_default.a.createElement(Detail,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integrations},external_kbnSharedDeps_React_default.a.createElement(EPMHomePage,null)))};const AgentPolicyListPageLayout=({children:children})=>external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.pageTitle",defaultMessage:"Agent policies"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.pageSubtitle",defaultMessage:"Use agent policies to manage your agents and the data they collect."})))))},children);const AgentPolicyListPage=()=>{var _urlParams$kuery,_agentPolicyData$tota;Object(hooks["J"])("policies_list");const{getHref:getHref,getPath:getPath}=Object(hooks["hb"])();const hasWriteCapabilites=Object(hooks["K"])().write;const{agents:{enabled:isFleetEnabled}}=Object(hooks["M"])();const{urlParams:urlParams,toUrlParams:toUrlParams}=Object(hooks["ob"])();const[search,setSearch]=Object(external_kbnSharedDeps_React_["useState"])(Array.isArray(urlParams.kuery)?urlParams.kuery[urlParams.kuery.length-1]:(_urlParams$kuery=urlParams.kuery)!==null&&_urlParams$kuery!==void 0?_urlParams$kuery:"");const{pagination:pagination,pageSizeOptions:pageSizeOptions,setPagination:setPagination}=Object(hooks["jb"])();const{sorting:sorting,setSorting:setSorting}=Object(hooks["lb"])({field:"updated_at",direction:"desc"});const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const isCreateAgentPolicyFlyoutOpen="create"in urlParams;const setIsCreateAgentPolicyFlyoutOpen=Object(external_kbnSharedDeps_React_["useCallback"])(isOpen=>{if(isOpen!==isCreateAgentPolicyFlyoutOpen){if(isOpen){history.push(`${getPath("policies_list")}?${toUrlParams({...urlParams,create:null})}`)}else{const{create:create,...params}=urlParams;history.push(`${getPath("policies_list")}?${toUrlParams(params)}`)}}},[getPath,history,isCreateAgentPolicyFlyoutOpen,toUrlParams,urlParams]);const{isLoading:isLoading,data:agentPolicyData,resendRequest:resendRequest}=Object(hooks["O"])({page:pagination.currentPage,perPage:pagination.pageSize,sortField:sorting===null||sorting===void 0?void 0:sorting.field,sortOrder:sorting===null||sorting===void 0?void 0:sorting.direction,kuery:search});const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const cols=[{field:"name",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyList.nameColumnTitle",{defaultMessage:"Name"}),width:"20%",render:(name,agentPolicy)=>external_kbnSharedDeps_React_default.a.createElement(LinkAndRevision,{href:getHref("policy_details",{policyId:agentPolicy.id}),title:name||agentPolicy.id,revision:agentPolicy.revision},name||agentPolicy.id)},{field:"description",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyList.descriptionColumnTitle",{defaultMessage:"Description"}),width:"35%",render:value=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextColor"],{color:"subdued",className:"eui-textTruncate",title:value},value)},{field:"updated_at",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyList.updatedOnColumnTitle",{defaultMessage:"Last updated on"}),render:date=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedDate"],{value:date,year:"numeric",month:"short",day:"2-digit"})},{field:"agents",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyList.agentsColumnTitle",{defaultMessage:"Agents"}),dataType:"number",render:(agents,agentPolicy)=>external_kbnSharedDeps_React_default.a.createElement(LinkedAgentCount,{count:agents,agentPolicyId:agentPolicy.id})},{field:"package_policies",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle",{defaultMessage:"Integrations"}),dataType:"number",render:packagePolicies=>packagePolicies?packagePolicies.length:0},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentPolicyList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:agentPolicy=>external_kbnSharedDeps_React_default.a.createElement(AgentPolicyActionMenu,{agentPolicy:agentPolicy,onCopySuccess:()=>resendRequest()})}]}];if(!isFleetEnabled){return cols.filter(col=>"field"in col?col.field!=="agents":true)}return cols},[getHref,isFleetEnabled,resendRequest]);const createAgentPolicyButton=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"plusInCircle",isDisabled:!hasWriteCapabilites,onClick:()=>setIsCreateAgentPolicyFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"})),[hasWriteCapabilites,setIsCreateAgentPolicyFlyoutOpen]);const emptyPrompt=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",defaultMessage:"No agent policies"})),actions:createAgentPolicyButton}),[createAgentPolicyButton]);const onTableChange=criteria=>{const newPagination={...pagination,currentPage:criteria.page.index+1,pageSize:criteria.page.size};setPagination(newPagination);setSorting(criteria.sort)};return external_kbnSharedDeps_React_default.a.createElement(AgentPolicyListPageLayout,null,isCreateAgentPolicyFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(CreateAgentPolicyFlyout,{onClose:()=>{setIsCreateAgentPolicyFlyoutOpen(false);resendRequest()}}):null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:4},external_kbnSharedDeps_React_default.a.createElement(SearchBar,{value:search,onChange:newSearch=>{setPagination({...pagination,currentPage:1});setSearch(newSearch)},fieldPrefix:constants["c"]})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",iconType:"refresh",onClick:()=>resendRequest()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",defaultMessage:"Reload"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},createAgentPolicyButton)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{loading:isLoading,hasActions:true,noItemsMessage:isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",defaultMessage:"Loading agent policies…"}):!search.trim()&&((_agentPolicyData$tota=agentPolicyData===null||agentPolicyData===void 0?void 0:agentPolicyData.total)!==null&&_agentPolicyData$tota!==void 0?_agentPolicyData$tota:0)===0?emptyPrompt:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",defaultMessage:"No agent policies found. {clearFiltersLink}",values:{clearFiltersLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>setSearch("")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentPolicyList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}),items:agentPolicyData?agentPolicyData.items:[],itemId:"id",columns:columns,isSelectable:false,pagination:{pageIndex:pagination.currentPage-1,pageSize:pagination.pageSize,totalItemCount:agentPolicyData?agentPolicyData.total:0,pageSizeOptions:pageSizeOptions},sorting:{sort:sorting},onChange:onTableChange}))};function useGetAgentStatus(policyId,options){const agentStatusRequest=Object(hooks["kb"])({path:services["c"].getStatusPath(),query:{policyId:policyId},method:"get",...options});return{isLoading:agentStatusRequest.isLoading,data:agentStatusRequest.data,error:agentStatusRequest.error,refreshAgentStatus:()=>agentStatusRequest.resendRequest}}const AgentStatusRefreshContext=external_kbnSharedDeps_React_default.a.createContext({refresh:()=>{}});function useAgentStatusRefresh(){return external_kbnSharedDeps_React_default.a.useContext(AgentStatusRefreshContext).refresh}const AgentPolicyRefreshContext=external_kbnSharedDeps_React_default.a.createContext({refresh:()=>{}});function useAgentPolicyRefresh(){return external_kbnSharedDeps_React_default.a.useContext(AgentPolicyRefreshContext).refresh}function package_policies_table_extends(){package_policies_table_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return package_policies_table_extends.apply(this,arguments)}const stringSortAscending=(a,b)=>a.localeCompare(b);const toFilterOption=value=>({name:value,value:value});const PackagePoliciesTable=({packagePolicies:originalPackagePolicies,agentPolicy:agentPolicy,...rest})=>{const{getHref:getHref}=Object(hooks["hb"])();const hasWriteCapabilities=Object(hooks["K"])().write;const refreshAgentPolicy=useAgentPolicyRefresh();const[packagePolicies,namespaces]=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const namespacesValues=[];const inputTypesValues=[];const mappedPackagePolicies=originalPackagePolicies.map(packagePolicy=>{var _packagePolicy$packag,_packagePolicy$packag2,_packagePolicy$packag3,_packagePolicy$packag4,_packagePolicy$packag5,_packagePolicy$packag6;if(packagePolicy.namespace&&!namespacesValues.includes(packagePolicy.namespace)){namespacesValues.push(packagePolicy.namespace)}return{...packagePolicy,packageName:(_packagePolicy$packag=(_packagePolicy$packag2=packagePolicy.package)===null||_packagePolicy$packag2===void 0?void 0:_packagePolicy$packag2.name)!==null&&_packagePolicy$packag!==void 0?_packagePolicy$packag:"",packageTitle:(_packagePolicy$packag3=(_packagePolicy$packag4=packagePolicy.package)===null||_packagePolicy$packag4===void 0?void 0:_packagePolicy$packag4.title)!==null&&_packagePolicy$packag3!==void 0?_packagePolicy$packag3:"",packageVersion:(_packagePolicy$packag5=(_packagePolicy$packag6=packagePolicy.package)===null||_packagePolicy$packag6===void 0?void 0:_packagePolicy$packag6.version)!==null&&_packagePolicy$packag5!==void 0?_packagePolicy$packag5:""}});namespacesValues.sort(stringSortAscending);inputTypesValues.sort(stringSortAscending);return[mappedPackagePolicies,namespacesValues.map(toFilterOption)]},[originalPackagePolicies]);const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{field:"name",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.packagePoliciesTable.nameColumnTitle",{defaultMessage:"Name"}),render:value=>external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textTruncate",title:value},value)},{field:"description",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.packagePoliciesTable.descriptionColumnTitle",{defaultMessage:"Description"}),render:value=>external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textTruncate",title:value},value)},{field:"packageTitle",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.packagePoliciesTable.packageNameColumnTitle",{defaultMessage:"Integration"}),render(packageTitle,packagePolicy){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},packagePolicy.package&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{packageName:packagePolicy.package.name,version:packagePolicy.package.version,size:"m",tryApi:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},packageTitle),packagePolicy.package&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs",className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.packagePoliciesTable.packageVersion",defaultMessage:"v{version}",values:{version:packagePolicy.package.version}}))))}},{field:"namespace",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.packagePoliciesTable.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:namespace=>namespace?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"hollow"},namespace):""},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.packagePoliciesTable.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:packagePolicy=>external_kbnSharedDeps_React_default.a.createElement(ContextMenuActions,{items:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{disabled:!hasWriteCapabilities,icon:"pencil",href:getHref("edit_integration",{policyId:agentPolicy.id,packagePolicyId:packagePolicy.id}),key:"packagePolicyEdit"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.packagePoliciesTable.editActionTitle",defaultMessage:"Edit integration"})),external_kbnSharedDeps_React_default.a.createElement(PackagePolicyDeleteProvider,{agentPolicy:agentPolicy,key:"packagePolicyDelete"},deletePackagePoliciesPrompt=>external_kbnSharedDeps_React_default.a.createElement(DangerEuiContextMenuItem,{disabled:!hasWriteCapabilities,icon:"trash",onClick:()=>{deletePackagePoliciesPrompt([packagePolicy.id],refreshAgentPolicy)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.packagePoliciesTable.deleteActionTitle",defaultMessage:"Delete integration"})))]})}]}],[agentPolicy,getHref,hasWriteCapabilities,refreshAgentPolicy]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],package_policies_table_extends({itemId:"id",items:packagePolicies,columns:columns,sorting:{sort:{field:"name",direction:"asc"}}},rest,{search:{toolsRight:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"addPackagePolicyButton",isDisabled:!hasWriteCapabilities,iconType:"plusInCircle",href:getHref("add_integration_from_policy",{policyId:agentPolicy.id})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.addPackagePolicyButtonText",defaultMessage:"Add integration"}))],box:{incremental:true,schema:true},filters:[{type:"field_value_selection",field:"namespace",name:"Namespace",options:namespaces,multiSelect:"or",operator:"exact"}]},isSelectable:false}))};const NoPackagePolicies=Object(external_kbnSharedDeps_React_["memo"])(({policyId:policyId})=>{const{getHref:getHref}=Object(hooks["hb"])();const hasWriteCapabilities=Object(hooks["K"])().write;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"plusInCircle",title:external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",defaultMessage:"Add your first integration"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",defaultMessage:"This policy does not have any integrations yet."}),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{isDisabled:!hasWriteCapabilities,fill:true,href:getHref("add_integration_from_policy",{policyId:policyId})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",defaultMessage:"Add integration"}))})});const PackagePoliciesView=Object(external_kbnSharedDeps_React_["memo"])(({agentPolicy:agentPolicy})=>{if(agentPolicy.package_policies.length===0){return external_kbnSharedDeps_React_default.a.createElement(NoPackagePolicies,{policyId:agentPolicy.id})}return external_kbnSharedDeps_React_default.a.createElement(PackagePoliciesTable,{agentPolicy:agentPolicy,packagePolicies:agentPolicy.package_policies||[]})});const FormWrapper=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"FormWrapper",componentId:"sc-1b9jodr-0"})(["max-width:800px;margin-right:auto;margin-left:auto;"]);const SettingsView=Object(external_kbnSharedDeps_React_["memo"])(({agentPolicy:originalAgentPolicy})=>{const{notifications:notifications}=Object(hooks["mb"])();const{agents:{enabled:isFleetEnabled}}=Object(hooks["M"])();const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{getPath:getPath}=Object(hooks["hb"])();const hasWriteCapabilites=Object(hooks["K"])().write;const refreshAgentPolicy=useAgentPolicyRefresh();const[agentPolicy,setAgentPolicy]=Object(external_kbnSharedDeps_React_["useState"])({...originalAgentPolicy});const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[hasChanges,setHasChanges]=Object(external_kbnSharedDeps_React_["useState"])(false);const[agentCount,setAgentCount]=Object(external_kbnSharedDeps_React_["useState"])(0);const[withSysMonitoring,setWithSysMonitoring]=Object(external_kbnSharedDeps_React_["useState"])(true);const validation=agentPolicyFormValidation(agentPolicy);const updateAgentPolicy=updatedFields=>{setAgentPolicy({...agentPolicy,...updatedFields});setHasChanges(true)};const submitUpdateAgentPolicy=async()=>{setIsLoading(true);try{const{name:name,description:description,namespace:namespace,monitoring_enabled:monitoring_enabled}=agentPolicy;const{data:data,error:error}=await Object(hooks["H"])(agentPolicy.id,{name:name,description:description,namespace:namespace,monitoring_enabled:monitoring_enabled});if(data){notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editAgentPolicy.successNotificationTitle",{defaultMessage:"Successfully updated '{name}' settings",values:{name:agentPolicy.name}}));refreshAgentPolicy();setHasChanges(false)}else{notifications.toasts.addDanger(error?error.message:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"}))}}catch(e){notifications.toasts.addDanger(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"}))}setIsLoading(false)};const onSubmit=async()=>{if(isFleetEnabled){setIsLoading(true);const{data:data}=await Object(hooks["k"])({policyId:agentPolicy.id});if(data!==null&&data!==void 0&&data.results.total){setAgentCount(data.results.total)}else{await submitUpdateAgentPolicy()}}else{await submitUpdateAgentPolicy()}};return external_kbnSharedDeps_React_default.a.createElement(FormWrapper,null,agentCount?external_kbnSharedDeps_React_default.a.createElement(ConfirmDeployAgentPolicyModal,{agentCount:agentCount,agentPolicy:agentPolicy,onConfirm:()=>{setAgentCount(0);submitUpdateAgentPolicy()},onCancel:()=>{setAgentCount(0);setIsLoading(false)}}):null,external_kbnSharedDeps_React_default.a.createElement(AgentPolicyForm,{agentPolicy:agentPolicy,updateAgentPolicy:updateAgentPolicy,withSysMonitoring:withSysMonitoring,updateSysMonitoring:newValue=>setWithSysMonitoring(newValue),validation:validation,isEditing:true,onDelete:()=>{history.push(getPath("policies_list"))}}),hasChanges?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBottomBar"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editAgentPolicy.unsavedChangesText",defaultMessage:"You have unsaved changes"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"ghost",onClick:()=>{setAgentPolicy({...originalAgentPolicy});setHasChanges(false)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editAgentPolicy.cancelButtonText",defaultMessage:"Cancel"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onSubmit,isLoading:isLoading,isDisabled:!hasWriteCapabilites||isLoading||Object.keys(validation).length>0,iconType:"save",color:"primary",fill:true},isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editAgentPolicy.savingButtonText",defaultMessage:"Saving…"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.editAgentPolicy.saveButtonText",defaultMessage:"Save changes"}))))))):null)});const details_page_Divider=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Divider",componentId:"kgzhx1-0"})(["width:0;height:100%;border-left:",";"],props=>props.theme.eui.euiBorderThin);const AgentPolicyDetailsPage=()=>{var _agentStatusRequest$d;const{params:{policyId:policyId,tabId:tabId=""}}=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();const history=Object(external_kbnSharedDeps_ReactRouterDom_["useHistory"])();const{getHref:getHref,getPath:getPath}=Object(hooks["hb"])();const agentPolicyRequest=Object(hooks["V"])(policyId);const agentPolicy=agentPolicyRequest.data?agentPolicyRequest.data.item:null;const{isLoading:isLoading,error:error,sendRequest:refreshAgentPolicy}=agentPolicyRequest;const[redirectToAgentPolicyList]=Object(external_kbnSharedDeps_React_["useState"])(false);const agentStatusRequest=useGetAgentStatus(policyId);const{refreshAgentStatus:refreshAgentStatus}=agentStatusRequest;const{application:{navigateToApp:navigateToApp}}=Object(hooks["mb"])();const routeState=useIntraAppState();const agentStatus=(_agentStatusRequest$d=agentStatusRequest.data)===null||_agentStatusRequest$d===void 0?void 0:_agentStatusRequest$d.results;const queryParams=new URLSearchParams(Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])().search);const openEnrollmentFlyoutOpenByDefault=queryParams.get("openEnrollmentFlyout")==="true";const{isReady:isFleetReady}=Object(hooks["N"])();const headerLeftContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"arrowLeft",href:getHref("policies_list"),flush:"left",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.viewAgentListTitle",defaultMessage:"View all agent policies"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:"eui-textBreakWord"},external_kbnSharedDeps_React_default.a.createElement("h1",null,isLoading?external_kbnSharedDeps_React_default.a.createElement(Loading,null):agentPolicy&&agentPolicy.name||external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.policyDetailsTitle",defaultMessage:"Policy '{id}'",values:{id:policyId}})))),agentPolicy&&agentPolicy.description?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"s",className:"eui-textBreakWord"},agentPolicy.description)):null),[getHref,isLoading,agentPolicy,policyId]);const headerRightContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _agentPolicy$revision;return agentPolicy?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd",direction:"row"},[{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.summary.revision",{defaultMessage:"Revision"}),content:(_agentPolicy$revision=agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.revision)!==null&&_agentPolicy$revision!==void 0?_agentPolicy$revision:0},{isDivider:true},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.summary.integrations",{defaultMessage:"Integrations"}),content:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:agentPolicy&&agentPolicy.package_policies&&agentPolicy.package_policies.length||0})},{isDivider:true},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.summary.usedBy",{defaultMessage:"Used by"}),content:external_kbnSharedDeps_React_default.a.createElement(LinkedAgentCount,{count:agentStatus&&agentStatus.total||0,agentPolicyId:agentPolicy&&agentPolicy.id||""})},{isDivider:true},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.summary.lastUpdated",{defaultMessage:"Last updated on"}),content:agentPolicy&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedDate"],{value:agentPolicy===null||agentPolicy===void 0?void 0:agentPolicy.updated_at,year:"numeric",month:"short",day:"2-digit"})||""},{isDivider:true},{content:agentPolicy&&external_kbnSharedDeps_React_default.a.createElement(AgentPolicyActionMenu,{agentPolicy:agentPolicy,fullButton:true,onCopySuccess:newAgentPolicy=>{history.push(getPath("policy_details",{policyId:newAgentPolicy.id}))},enrollmentFlyoutOpenByDefault:openEnrollmentFlyoutOpenByDefault,onCancelEnrollment:routeState&&routeState.onDoneNavigateTo&&isFleetReady?()=>navigateToApp(routeState.onDoneNavigateTo[0],routeState.onDoneNavigateTo[1]):undefined})}].map((item,index)=>{var _item$isDivider;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,key:index},((_item$isDivider=item.isDivider)!==null&&_item$isDivider!==void 0?_item$isDivider:false)?external_kbnSharedDeps_React_default.a.createElement(details_page_Divider,null):item.label?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{compressed:true,textStyle:"reverse",style:{textAlign:"right"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],{className:"eui-textNoWrap"},item.label),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textNoWrap"},item.content)):item.content)})):undefined},[agentPolicy,policyId,agentStatus]);const headerTabs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{id:"integrations",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.subTabs.packagePoliciesTabText",{defaultMessage:"Integrations"}),href:getHref("policy_details",{policyId:policyId,tabId:"integrations"}),isSelected:tabId===""||tabId==="integrations"},{id:"settings",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.subTabs.settingsTabText",{defaultMessage:"Settings"}),href:getHref("policy_details",{policyId:policyId,tabId:"settings"}),isSelected:tabId==="settings"}],[getHref,policyId,tabId]);const content=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(redirectToAgentPolicyList){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/"})}if(isLoading){return external_kbnSharedDeps_React_default.a.createElement(Loading,null)}if(error){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:error})}if(!agentPolicy){return external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.policyDetails.policyNotFoundErrorTitle",{defaultMessage:"Policy '{id}' not found",values:{id:policyId}})})}return external_kbnSharedDeps_React_default.a.createElement(AgentPolicyDetailsContent,{agentPolicy:agentPolicy})},[agentPolicy,policyId,error,isLoading,redirectToAgentPolicyList]);return external_kbnSharedDeps_React_default.a.createElement(AgentPolicyRefreshContext.Provider,{value:{refresh:refreshAgentPolicy}},external_kbnSharedDeps_React_default.a.createElement(AgentStatusRefreshContext.Provider,{value:{refresh:refreshAgentStatus}},external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:headerLeftContent,rightColumn:headerRightContent,tabs:headerTabs},content)))};const AgentPolicyDetailsContent=({agentPolicy:agentPolicy})=>{Object(hooks["J"])("policy_details",{policyName:agentPolicy.name});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].policy_details_settings,render:()=>external_kbnSharedDeps_React_default.a.createElement(SettingsView,{agentPolicy:agentPolicy})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].policy_details,render:()=>external_kbnSharedDeps_React_default.a.createElement(PackagePoliciesView,{agentPolicy:agentPolicy})}))};const AgentPolicyApp=()=>{Object(hooks["J"])("policies");return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["HashRouter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].edit_integration},external_kbnSharedDeps_React_default.a.createElement(EditPackagePolicyPage,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].add_integration_from_policy},external_kbnSharedDeps_React_default.a.createElement(CreatePackagePolicyPage,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].policy_details},external_kbnSharedDeps_React_default.a.createElement(AgentPolicyDetailsPage,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].policies_list},external_kbnSharedDeps_React_default.a.createElement(AgentPolicyListPage,null))))};const DataStreamRowActions=Object(external_kbnSharedDeps_React_["memo"])(({datastream:datastream})=>{const{dashboards:dashboards}=datastream;const panels=[];const actionNameSingular=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.viewDashboardActionText",defaultMessage:"View dashboard"});const actionNamePlural=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.viewDashboardsActionText",defaultMessage:"View dashboards"});const panelTitle=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.viewDashboardsPanelTitle",{defaultMessage:"View dashboards"});if(!dashboards||dashboards.length===0){panels.push({id:0,items:[{icon:"dashboardApp",disabled:true,name:actionNameSingular}]})}else if(dashboards.length===1){panels.push({id:0,items:[{icon:"dashboardApp",href:Object(hooks["eb"])(`/dashboard/${dashboards[0].id||""}`),name:actionNameSingular}]})}else{panels.push({id:0,items:[{icon:"dashboardApp",panel:1,name:actionNamePlural}]});panels.push({id:1,title:panelTitle,items:dashboards.map(dashboard=>({icon:"dashboardApp",href:Object(hooks["eb"])(`/dashboard/${dashboard.id||""}`),name:dashboard.title}))})}return external_kbnSharedDeps_React_default.a.createElement(ContextMenuActions,{panels:panels})});const DataStreamListPageLayout=({children:children})=>external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.pageTitle",defaultMessage:"Data streams"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.pageSubtitle",defaultMessage:"Manage the data created by your agents."})))))},children);const DataStreamListPage=()=>{Object(hooks["J"])("data_streams");const{data:{fieldFormats:fieldFormats}}=Object(hooks["mb"])();const{pagination:pagination,pageSizeOptions:pageSizeOptions}=Object(hooks["jb"])();const{isLoading:isLoading,data:dataStreamsData,resendRequest:resendRequest}=Object(hooks["R"])();const columns=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{const cols=[{field:"dataset",sortable:true,width:"25%",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"})},{field:"type",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"})},{field:"namespace",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:namespace=>namespace?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"hollow"},namespace):""},{field:"package",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),render(pkg,datastream){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},datastream.package_version&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{packageName:pkg,version:datastream.package_version,size:"m",tryApi:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},pkg))}},{field:"last_activity_ms",sortable:true,width:"25%",dataType:"date",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.lastActivityColumnTitle",{defaultMessage:"Last activity"}),render:date=>{try{const formatter=fieldFormats.getInstance("date");return formatter.convert(date)}catch(e){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedDate"],{value:date,year:"numeric",month:"short",day:"2-digit"})}}},{field:"size_in_bytes",sortable:true,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.sizeColumnTitle",{defaultMessage:"Size"}),render:size=>{try{const formatter=fieldFormats.getInstance("bytes");return formatter.convert(size)}catch(e){return`${size}b`}}},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:datastream=>external_kbnSharedDeps_React_default.a.createElement(DataStreamRowActions,{datastream:datastream})}]}];return cols},[fieldFormats]);const emptyPrompt=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.noDataStreamsPrompt",defaultMessage:"No data streams"}))}),[]);const filterOptions={dataset:[],type:[],namespace:[],package:[]};if(dataStreamsData&&dataStreamsData.data_streams.length){const dataValues={dataset:[],type:[],namespace:[],package:[]};dataStreamsData.data_streams.forEach(stream=>{const{dataset:dataset,type:type,namespace:namespace,package:pkg}=stream;if(!dataValues.dataset.includes(dataset)){dataValues.dataset.push(dataset)}if(!dataValues.type.includes(type)){dataValues.type.push(type)}if(!dataValues.namespace.includes(namespace)){dataValues.namespace.push(namespace)}if(!dataValues.package.includes(pkg)){dataValues.package.push(pkg)}});for(const field in dataValues){if(filterOptions[field]){filterOptions[field]=dataValues[field].sort().map(option=>({value:option,name:option}))}}}return external_kbnSharedDeps_React_default.a.createElement(DataStreamListPageLayout,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{loading:isLoading,hasActions:true,message:isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.loadingDataStreamsMessage",defaultMessage:"Loading data streams…"}):dataStreamsData&&!dataStreamsData.data_streams.length?emptyPrompt:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",defaultMessage:"No matching data streams found"}),items:dataStreamsData?dataStreamsData.data_streams:[],itemId:"index",columns:columns,pagination:{initialPageSize:pagination.pageSize,pageSizeOptions:pageSizeOptions},sorting:true,search:{toolsRight:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{key:"reloadButton",color:"primary",iconType:"refresh",onClick:()=>resendRequest()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.dataStreamList.reloadDataStreamsButtonText",defaultMessage:"Reload"}))],box:{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.searchPlaceholderTitle",{defaultMessage:"Filter data streams"}),incremental:true},filters:[{type:"field_value_selection",field:"dataset",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"}),multiSelect:"or",operator:"exact",options:filterOptions.dataset},{type:"field_value_selection",field:"type",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"}),multiSelect:"or",operator:"exact",options:filterOptions.type},{type:"field_value_selection",field:"namespace",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),multiSelect:"or",operator:"exact",options:filterOptions.namespace},{type:"field_value_selection",field:"package",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),multiSelect:"or",operator:"exact",options:filterOptions.package}]}}))};const DataStreamApp=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["HashRouter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].data_streams},external_kbnSharedDeps_React_default.a.createElement(DataStreamListPage,null))));const visColors=Object(external_kbnSharedDeps_ElasticEui_["euiPaletteColorBlindBehindText"])();const colorToHexMap={default:"#d3dae6",primary:visColors[1],secondary:visColors[0],accent:visColors[2],warning:visColors[5],danger:visColors[9]};const AGENT_STATUSES=["healthy","unhealthy","updating","offline","inactive"];function getColorForAgentStatus(agentStatus){switch(agentStatus){case"healthy":return colorToHexMap.secondary;case"offline":case"inactive":return colorToHexMap.default;case"unhealthy":return colorToHexMap.warning;case"updating":return colorToHexMap.primary;default:throw new Error(`Insuported Agent status ${agentStatus}`)}}function getLabelForAgentStatus(agentStatus){switch(agentStatus){case"healthy":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentStatus.healthyLabel",{defaultMessage:"Healthy"});case"offline":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentStatus.offlineLabel",{defaultMessage:"Offline"});case"inactive":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentStatus.inactiveLabel",{defaultMessage:"Inactive"});case"unhealthy":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentStatus.unhealthyLabel",{defaultMessage:"Unhealthy"});case"updating":return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentStatus.updatingLabel",{defaultMessage:"Updating"});default:throw new Error(`Insuported Agent status ${agentStatus}`)}}const StyledEuiColorPaletteDisplay=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiColorPaletteDisplay"]).withConfig({displayName:"StyledEuiColorPaletteDisplay",componentId:"sc-147tmhq-0"})(["&.ingest-agent-status-bar{border:none;border-radius:0;&:after{border:none;}}"]);const AgentStatusBar=({agentStatus:agentStatus})=>{const palette=Object(external_kbnSharedDeps_React_["useMemo"])(()=>AGENT_STATUSES.reduce((acc,status)=>{const previousStop=acc.length>0?acc[acc.length-1].stop:0;acc.push({stop:previousStop+(agentStatus[status]||0),color:getColorForAgentStatus(status)});return acc},[]),[agentStatus]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(StyledEuiColorPaletteDisplay,{className:"ingest-agent-status-bar",size:"s",palette:palette}))};const bulk_actions_Divider=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Divider",componentId:"sc-1ynhme7-0"})(["width:0;height:",";border-left:",";"],props=>props.theme.eui.euiSizeL,props=>props.theme.eui.euiBorderThin);const FlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FlexItem",componentId:"sc-1ynhme7-1"})(["height:",";"],props=>props.theme.eui.euiSizeL);const Button=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"]).withConfig({displayName:"Button",componentId:"sc-1ynhme7-2"})([".euiButtonEmpty__text{font-size:",";}"],props=>props.theme.eui.euiFontSizeXS);const AgentBulkActions=({totalAgents:totalAgents,totalInactiveAgents:totalInactiveAgents,selectableAgents:selectableAgents,selectionMode:selectionMode,setSelectionMode:setSelectionMode,currentQuery:currentQuery,selectedAgents:selectedAgents,setSelectedAgents:setSelectedAgents,refreshAgents:refreshAgents})=>{const kibanaVersion=Object(hooks["fb"])();const[isMenuOpen,setIsMenuOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const closeMenu=()=>setIsMenuOpen(false);const openMenu=()=>setIsMenuOpen(true);const[isReassignFlyoutOpen,setIsReassignFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isUnenrollModalOpen,setIsUnenrollModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isUpgradeModalOpen,setIsUpgradeModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const atLeastOneActiveAgentSelected=selectionMode==="manual"?!!selectedAgents.find(agent=>agent.active):totalAgents>totalInactiveAgents;const panels=[{id:0,items:[{name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.reassignPolicy",defaultMessage:"Assign to new policy"}),icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"pencil",size:"m"}),disabled:!atLeastOneActiveAgentSelected,onClick:()=>{closeMenu();setIsReassignFlyoutOpen(true)}},{name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.unenrollAgents",defaultMessage:"Unenroll agents"}),icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"trash",size:"m"}),disabled:!atLeastOneActiveAgentSelected,onClick:()=>{closeMenu();setIsUnenrollModalOpen(true)}},{name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.upgradeAgents",defaultMessage:"Upgrade agents"}),icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"refresh",size:"m"}),disabled:!atLeastOneActiveAgentSelected,onClick:()=>{closeMenu();setIsUpgradeModalOpen(true)}},{name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.clearSelection",defaultMessage:"Clear selection"}),icon:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"cross",size:"m"}),onClick:()=>{closeMenu();setSelectionMode("manual");setSelectedAgents([])}}]}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isReassignFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentReassignAgentPolicyFlyout,{agents:selectionMode==="manual"?selectedAgents:currentQuery,onClose:()=>{setIsReassignFlyoutOpen(false);refreshAgents()}})),isUnenrollModalOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentUnenrollAgentModal,{agents:selectionMode==="manual"?selectedAgents:currentQuery,agentCount:selectionMode==="manual"?selectedAgents.length:totalAgents-totalInactiveAgents,onClose:()=>{setIsUnenrollModalOpen(false);refreshAgents()}})),isUpgradeModalOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentUpgradeAgentModal,{version:kibanaVersion,agents:selectionMode==="manual"?selectedAgents:currentQuery,agentCount:selectionMode==="manual"?selectedAgents.length:totalAgents-totalInactiveAgents,onClose:()=>{setIsUpgradeModalOpen(false);refreshAgents()}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},totalAgents>constants["l"]?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.totalAgentsWithLimit",defaultMessage:"Showing {count} of {total} agents",values:{count:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedNumber"],{value:constants["l"]}),total:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedNumber"],{value:totalAgents})}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.totalAgents",defaultMessage:"Showing {count, plural, one {# agent} other {# agents}}",values:{count:totalAgents}}))),selectionMode==="manual"&&selectedAgents.length||selectionMode==="query"&&totalAgents>0?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(FlexItem,{grow:false},external_kbnSharedDeps_React_default.a.createElement(bulk_actions_Divider,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"agentBulkActionsMenu",button:external_kbnSharedDeps_React_default.a.createElement(Button,{size:"xs",iconType:"arrowDown",iconSide:"right",flush:"left",onClick:openMenu},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.agentsSelected",defaultMessage:"{count, plural, one {# agent} other {# agents}} selected",values:{count:selectionMode==="manual"?selectedAgents.length:Math.min(totalAgents-totalInactiveAgents,constants["l"])}})),isOpen:isMenuOpen,closePopover:closeMenu,panelPaddingSize:"none",anchorPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenu"],{initialPanelId:0,panels:panels}))),selectionMode==="manual"&&selectedAgents.length===selectableAgents&&selectableAgents<totalAgents?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(Button,{size:"xs",iconType:"pagesSelect",iconSide:"left",flush:"left",onClick:()=>setSelectionMode("query")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentBulkActions.selectAll",defaultMessage:"Select everything on all pages"}))):null):external_kbnSharedDeps_React_default.a.createElement(FlexItem,{grow:false})))};const AgentStatusBadges=Object(external_kbnSharedDeps_React_["memo"])(({agentStatus:agentStatus,showInactive:showInactive})=>{const agentStatuses=Object(external_kbnSharedDeps_React_["useMemo"])(()=>AGENT_STATUSES.filter(status=>showInactive?true:status!=="inactive"),[showInactive]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m"},agentStatuses.map(status=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:status,grow:false},external_kbnSharedDeps_React_default.a.createElement(AgentStatusBadge,{status:status,count:agentStatus[status]||0}))))});const AgentStatusBadge=Object(external_kbnSharedDeps_React_["memo"])(({status:status,count:count})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:getColorForAgentStatus(status)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},getLabelForAgentStatus(status)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiNotificationBadge"],{size:"s",color:"subdued"},count))))));const AgentTableHeader=({agentStatus:agentStatus,totalAgents:totalAgents,totalInactiveAgents:totalInactiveAgents,selectableAgents:selectableAgents,selectionMode:selectionMode,setSelectionMode:setSelectionMode,currentQuery:currentQuery,selectedAgents:selectedAgents,setSelectedAgents:setSelectedAgents,refreshAgents:refreshAgents,showInactive:showInactive})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(AgentBulkActions,{totalAgents:totalAgents,totalInactiveAgents:totalInactiveAgents,selectableAgents:selectableAgents,selectionMode:selectionMode,setSelectionMode:setSelectionMode,currentQuery:currentQuery,selectedAgents:selectedAgents,setSelectedAgents:setSelectedAgents,refreshAgents:refreshAgents})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},agentStatus&&external_kbnSharedDeps_React_default.a.createElement(AgentStatusBadges,{showInactive:showInactive,agentStatus:agentStatus}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),agentStatus&&external_kbnSharedDeps_React_default.a.createElement(AgentStatusBar,{agentStatus:agentStatus}));function search_and_filter_bar_extends(){search_and_filter_bar_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return search_and_filter_bar_extends.apply(this,arguments)}const statusFilters=[{status:"healthy",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.statusHealthyFilterText",{defaultMessage:"Healthy"})},{status:"unhealthy",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.statusUnhealthyFilterText",{defaultMessage:"Unhealthy"})},{status:"updating",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.statusUpdatingFilterText",{defaultMessage:"Updating"})},{status:"offline",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.statusOfflineFilterText",{defaultMessage:"Offline"})},{status:"inactive",label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.statusInactiveFilterText",{defaultMessage:"Inactive"})}];const SearchAndFilterBar=({agentPolicies:agentPolicies,draftKuery:draftKuery,onDraftKueryChange:onDraftKueryChange,onSubmitSearch:onSubmitSearch,selectedAgentPolicies:selectedAgentPolicies,onSelectedAgentPoliciesChange:onSelectedAgentPoliciesChange,selectedStatus:selectedStatus,onSelectedStatusChange:onSelectedStatusChange,showUpgradeable:showUpgradeable,onShowUpgradeableChange:onShowUpgradeableChange})=>{const config=Object(hooks["M"])();const[isAgentPoliciesFilterOpen,setIsAgentPoliciesFilterOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isStatusFilterOpen,setIsStatutsFilterOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const addAgentPolicyFilter=policyId=>{onSelectedAgentPoliciesChange([...selectedAgentPolicies,policyId])};const removeAgentPolicyFilter=policyId=>{onSelectedAgentPoliciesChange(selectedAgentPolicies.filter(agentPolicy=>agentPolicy!==policyId))};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:4},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:6},external_kbnSharedDeps_React_default.a.createElement(SearchBar,search_and_filter_bar_extends({value:draftKuery,onChange:(newSearch,submit)=>{onDraftKueryChange(newSearch);if(submit){onSubmitSearch(newSearch)}}},config.agents.fleetServerEnabled?{indexPattern:constants["a"]}:{fieldPrefix:constants["d"]}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:2},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:true,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",onClick:()=>setIsStatutsFilterOpen(!isStatusFilterOpen),isSelected:isStatusFilterOpen,hasActiveFilters:selectedStatus.length>0,numActiveFilters:selectedStatus.length,disabled:agentPolicies.length===0},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.statusFilterText",defaultMessage:"Status"})),isOpen:isStatusFilterOpen,closePopover:()=>setIsStatutsFilterOpen(false),panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement("div",{className:"euiFilterSelect__items"},statusFilters.map(({label:label,status:status},idx)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{key:idx,checked:selectedStatus.includes(status)?"on":undefined,onClick:()=>{if(selectedStatus.includes(status)){onSelectedStatusChange([...selectedStatus.filter(s=>s!==status)])}else{onSelectedStatusChange([...selectedStatus,status])}}},label)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{ownFocus:true,button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",onClick:()=>setIsAgentPoliciesFilterOpen(!isAgentPoliciesFilterOpen),isSelected:isAgentPoliciesFilterOpen,hasActiveFilters:selectedAgentPolicies.length>0,numActiveFilters:selectedAgentPolicies.length,numFilters:agentPolicies.length,disabled:agentPolicies.length===0},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.policyFilterText",defaultMessage:"Agent policy"})),isOpen:isAgentPoliciesFilterOpen,closePopover:()=>setIsAgentPoliciesFilterOpen(false),panelPaddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement("div",{className:"euiFilterSelect__items"},agentPolicies.map((agentPolicy,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{checked:selectedAgentPolicies.includes(agentPolicy.id)?"on":undefined,key:index,onClick:()=>{if(selectedAgentPolicies.includes(agentPolicy.id)){removeAgentPolicyFilter(agentPolicy.id)}else{addAgentPolicyFilter(agentPolicy.id)}}},agentPolicy.name)))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{hasActiveFilters:showUpgradeable,onClick:()=>{onShowUpgradeableChange(!showUpgradeable)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.showUpgradeableFilterLabel",defaultMessage:"Upgrade available"}))))))))};const REFRESH_INTERVAL_MS=3e4;const RowActions=external_kbnSharedDeps_React_default.a.memo(({agent:agent,refresh:refresh,onReassignClick:onReassignClick,onUnenrollClick:onUnenrollClick,onUpgradeClick:onUpgradeClick})=>{const{getHref:getHref}=Object(hooks["hb"])();const hasWriteCapabilites=Object(hooks["K"])().write;const isUnenrolling=agent.status==="unenrolling";const kibanaVersion=Object(hooks["fb"])();const[isMenuOpen,setIsMenuOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);return external_kbnSharedDeps_React_default.a.createElement(ContextMenuActions,{isOpen:isMenuOpen,onChange:isOpen=>setIsMenuOpen(isOpen),items:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"inspect",href:getHref("fleet_agent_details",{agentId:agent.id}),key:"viewAgent"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.viewActionText",defaultMessage:"View agent"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"pencil",onClick:()=>{onReassignClick()},disabled:!agent.active,key:"reassignPolicy"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{disabled:!hasWriteCapabilites||!agent.active,icon:"trash",onClick:()=>{onUnenrollClick()}},isUnenrolling?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"refresh",disabled:!Object(services["l"])(agent,kibanaVersion),onClick:()=>{onUpgradeClick()}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))]})});function safeMetadata(val){if(typeof val!=="string"){return"-"}return val}const AgentListPage=()=>{const{notifications:notifications}=Object(hooks["mb"])();Object(hooks["J"])("fleet_agent_list");const{getHref:getHref}=Object(hooks["hb"])();const defaultKuery=Object(hooks["ob"])().urlParams.kuery||"";const hasWriteCapabilites=Object(hooks["K"])().write;const isGoldPlus=Object(hooks["gb"])().isGoldPlus();const kibanaVersion=Object(hooks["fb"])();const[showUpgradeable,setShowUpgradeable]=Object(external_kbnSharedDeps_React_["useState"])(false);const[draftKuery,setDraftKuery]=Object(external_kbnSharedDeps_React_["useState"])(defaultKuery);const[search,setSearch]=Object(external_kbnSharedDeps_React_["useState"])(defaultKuery);const[selectionMode,setSelectionMode]=Object(external_kbnSharedDeps_React_["useState"])("manual");const[selectedAgents,setSelectedAgents]=Object(external_kbnSharedDeps_React_["useState"])([]);const tableRef=Object(external_kbnSharedDeps_React_["useRef"])(null);const{pagination:pagination,pageSizeOptions:pageSizeOptions,setPagination:setPagination}=Object(hooks["jb"])();const onSubmitSearch=Object(external_kbnSharedDeps_React_["useCallback"])(newKuery=>{setSearch(newKuery);setPagination({...pagination,currentPage:1})},[setSearch,pagination,setPagination]);const[selectedAgentPolicies,setSelectedAgentPolicies]=Object(external_kbnSharedDeps_React_["useState"])([]);const[selectedStatus,setSelectedStatus]=Object(external_kbnSharedDeps_React_["useState"])([]);const isUsingFilter=search.trim()||selectedAgentPolicies.length||selectedStatus.length||showUpgradeable;const clearFilters=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setDraftKuery("");setSearch("");setSelectedAgentPolicies([]);setSelectedStatus([]);setShowUpgradeable(false)},[setSearch,setDraftKuery,setSelectedAgentPolicies,setSelectedStatus,setShowUpgradeable]);const[isEnrollmentFlyoutOpen,setIsEnrollmentFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[agentToReassign,setAgentToReassign]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[agentToUnenroll,setAgentToUnenroll]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const[agentToUpgrade,setAgentToUpgrade]=Object(external_kbnSharedDeps_React_["useState"])(undefined);const kuery=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{let kueryBuilder=search.trim();if(selectedAgentPolicies.length){if(kueryBuilder){kueryBuilder=`(${kueryBuilder}) and`}kueryBuilder=`${kueryBuilder} ${constants["d"]}.policy_id : (${selectedAgentPolicies.map(agentPolicy=>`"${agentPolicy}"`).join(" or ")})`}if(selectedStatus.length){const kueryStatus=selectedStatus.map(status=>{switch(status){case"healthy":return services["a"].buildKueryForOnlineAgents();case"unhealthy":return services["a"].buildKueryForErrorAgents();case"offline":return services["a"].buildKueryForOfflineAgents();case"updating":return services["a"].buildKueryForUpdatingAgents();case"inactive":return services["a"].buildKueryForInactiveAgents()}return undefined}).filter(statusKuery=>statusKuery!==undefined).join(" or ");if(kueryBuilder){kueryBuilder=`(${kueryBuilder}) and ${kueryStatus}`}else{kueryBuilder=kueryStatus}}return kueryBuilder},[selectedStatus,selectedAgentPolicies,search]);const showInactive=Object(external_kbnSharedDeps_React_["useMemo"])(()=>selectedStatus.includes("inactive"),[selectedStatus]);const[agents,setAgents]=Object(external_kbnSharedDeps_React_["useState"])([]);const[agentsStatus,setAgentsStatus]=Object(external_kbnSharedDeps_React_["useState"])();const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[totalAgents,setTotalAgents]=Object(external_kbnSharedDeps_React_["useState"])(0);const[totalInactiveAgents,setTotalInactiveAgents]=Object(external_kbnSharedDeps_React_["useState"])(0);const currentRequestRef=Object(external_kbnSharedDeps_React_["useRef"])(0);const fetchData=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{async function fetchDataAsync(){currentRequestRef.current++;const currentRequest=currentRequestRef.current;try{setIsLoading(true);const[agentsRequest,agentsStatusRequest]=await Promise.all([Object(hooks["l"])({page:pagination.currentPage,perPage:pagination.pageSize,kuery:kuery&&kuery!==""?kuery:undefined,showInactive:showInactive,showUpgradeable:showUpgradeable}),Object(hooks["k"])({kuery:kuery&&kuery!==""?kuery:undefined})]);if(currentRequestRef.current!==currentRequest){return}if(agentsRequest.error){throw agentsRequest.error}if(!agentsRequest.data){throw new Error("Invalid GET /agents response")}if(agentsStatusRequest.error){throw agentsStatusRequest.error}if(!agentsStatusRequest.data){throw new Error("Invalid GET /agents-status response")}setAgentsStatus({healthy:agentsStatusRequest.data.results.online,unhealthy:agentsStatusRequest.data.results.error,offline:agentsStatusRequest.data.results.offline,updating:agentsStatusRequest.data.results.updating,inactive:agentsRequest.data.totalInactive});setAgents(agentsRequest.data.list);setTotalAgents(agentsRequest.data.total);setTotalInactiveAgents(agentsRequest.data.totalInactive)}catch(error){notifications.toasts.addError(error,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.errorFetchingDataTitle",{defaultMessage:"Error fetching agents"})})}setIsLoading(false)}fetchDataAsync()},[pagination,kuery,showInactive,showUpgradeable,notifications.toasts]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{fetchData();const interval=setInterval(()=>{fetchData()},REFRESH_INTERVAL_MS);return()=>clearInterval(interval)},[fetchData]);const agentPoliciesRequest=Object(hooks["O"])({page:1,perPage:1e3});const agentPolicies=Object(external_kbnSharedDeps_React_["useMemo"])(()=>agentPoliciesRequest.data?agentPoliciesRequest.data.items:[],[agentPoliciesRequest]);const agentPoliciesIndexedById=Object(external_kbnSharedDeps_React_["useMemo"])(()=>agentPolicies.reduce((acc,agentPolicy)=>{acc[agentPolicy.id]=agentPolicy;return acc},{}),[agentPolicies]);const columns=[{field:"local_metadata.host.hostname",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.hostColumnTitle",{defaultMessage:"Host"}),render:(host,agent)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getHref("fleet_agent_details",{agentId:agent.id})},safeMetadata(host))},{field:"active",width:"120px",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.statusColumnTitle",{defaultMessage:"Status"}),render:(active,agent)=>external_kbnSharedDeps_React_default.a.createElement(AgentHealth,{agent:agent})},{field:"policy_id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.policyColumnTitle",{defaultMessage:"Agent policy"}),render:(policyId,agent)=>{var _agentPolicies$find;const policyName=(_agentPolicies$find=agentPolicies.find(p=>p.id===policyId))===null||_agentPolicies$find===void 0?void 0:_agentPolicies$find.name;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",style:{minWidth:0}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textTruncate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getHref("policy_details",{policyId:policyId}),className:"eui-textTruncate",title:policyName||policyId},policyName||policyId)),agent.policy_revision&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"default",size:"xs",className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.revisionNumber",defaultMessage:"rev. {revNumber}",values:{revNumber:agent.policy_revision}}))),agent.policy_id&&agent.policy_revision&&agentPoliciesIndexedById[agent.policy_id]&&agentPoliciesIndexedById[agent.policy_id].revision>agent.policy_revision&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs",className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"m",type:"alert",color:"warning"})," ",true&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.outOfDateLabel",defaultMessage:"Out-of-date"})))))}},{field:"local_metadata.elastic.agent.version",width:"200px",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.versionTitle",{defaultMessage:"Version"}),render:(version,agent)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",style:{minWidth:0}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textNoWrap"},safeMetadata(version)),Object(services["l"])(agent,kibanaVersion)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs",className:"eui-textNoWrap"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"m",type:"alert",color:"warning"})," ",external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.agentUpgradeLabel",defaultMessage:"Upgrade available"}))):null)},{field:"last_checkin",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.lastCheckinTitle",{defaultMessage:"Last activity"}),render:(lastCheckin,agent)=>lastCheckin?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedRelative"],{value:lastCheckin}):null},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:agent=>external_kbnSharedDeps_React_default.a.createElement(RowActions,{agent:agent,refresh:()=>fetchData(),onReassignClick:()=>setAgentToReassign(agent),onUnenrollClick:()=>setAgentToUnenroll(agent),onUpgradeClick:()=>setAgentToUpgrade(agent)})}],width:"100px"}];const emptyPrompt=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.noAgentsPrompt",defaultMessage:"No agents enrolled"})),actions:hasWriteCapabilites?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"plusInCircle",onClick:()=>setIsEnrollmentFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})):null});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isEnrollmentFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(AgentEnrollmentFlyout,{agentPolicies:agentPolicies,onClose:()=>setIsEnrollmentFlyoutOpen(false)}):null,agentToReassign&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentReassignAgentPolicyFlyout,{agents:[agentToReassign],onClose:()=>{setAgentToReassign(undefined);fetchData()}})),agentToUnenroll&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentUnenrollAgentModal,{agents:[agentToUnenroll],agentCount:1,onClose:()=>{setAgentToUnenroll(undefined);fetchData()},useForceUnenroll:agentToUnenroll.status==="unenrolling"})),agentToUpgrade&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentUpgradeAgentModal,{agents:[agentToUpgrade],agentCount:1,onClose:()=>{setAgentToUpgrade(undefined);fetchData()},version:kibanaVersion})),external_kbnSharedDeps_React_default.a.createElement(SearchAndFilterBar,{agentPolicies:agentPolicies,draftKuery:draftKuery,onDraftKueryChange:setDraftKuery,onSubmitSearch:onSubmitSearch,selectedAgentPolicies:selectedAgentPolicies,onSelectedAgentPoliciesChange:setSelectedAgentPolicies,selectedStatus:selectedStatus,onSelectedStatusChange:setSelectedStatus,showUpgradeable:showUpgradeable,onShowUpgradeableChange:setShowUpgradeable}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(AgentTableHeader,{showInactive:showInactive,totalAgents:totalAgents,totalInactiveAgents:totalInactiveAgents,agentStatus:agentsStatus,selectableAgents:(agents===null||agents===void 0?void 0:agents.filter(agent=>agent.active).length)||0,selectionMode:selectionMode,setSelectionMode:setSelectionMode,currentQuery:kuery,selectedAgents:selectedAgents,setSelectedAgents:newAgents=>{if(tableRef!==null&&tableRef!==void 0&&tableRef.current){tableRef.current.setSelection(newAgents);setSelectionMode("manual")}},refreshAgents:()=>fetchData()}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{ref:tableRef,className:"fleet__agentList__table","data-test-subj":"fleetAgentListTable",loading:isLoading,hasActions:true,noItemsMessage:isLoading&&currentRequestRef.current===1?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.loadingAgentsMessage",defaultMessage:"Loading agents…"}):isUsingFilter?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.noFilteredAgentsPrompt",defaultMessage:"No agents found. {clearFiltersLink}",values:{clearFiltersLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>clearFilters()},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):emptyPrompt,items:totalAgents?agents:[],itemId:"id",columns:columns,pagination:{pageIndex:pagination.currentPage-1,pageSize:pagination.pageSize,totalItemCount:totalAgents,pageSizeOptions:pageSizeOptions},isSelectable:true,selection:isGoldPlus?{onSelectionChange:newAgents=>{setSelectedAgents(newAgents);setSelectionMode("manual")},selectable:agent=>agent.active}:undefined,onChange:({page:page})=>{const newPagination={...pagination,currentPage:page.index+1,pageSize:page.size};setPagination(newPagination)}}))};const RequirementItem=({isMissing:isMissing,children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,isMissing?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"crossInACircleFilled",color:"danger"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"checkInCircleFilled",color:"success"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,children)));const SetupPage=({refresh:refresh,missingRequirements:missingRequirements})=>{const[isFormLoading,setIsFormLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const core=Object(hooks["mb"])();const onSubmit=async()=>{setIsFormLoading(true);try{await Object(hooks["B"])({forceRecreate:true});await refresh()}catch(error){core.notifications.toasts.addDanger(error.message);setIsFormLoading(false)}};if(!missingRequirements.includes("tls_required")&&!missingRequirements.includes("api_keys")&&!missingRequirements.includes("encrypted_saved_object_encryption_key_required")){return external_kbnSharedDeps_React_default.a.createElement(WithoutHeaderLayout,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],{restrictWidth:648},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],{verticalPosition:"center",horizontalPosition:"center",className:"eui-textCenter",paddingSize:"l"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"lock",color:"subdued",size:"xl"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.enableTitle",defaultMessage:"Enable central management for Elastic Agents"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xl"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.enableText",defaultMessage:"Central management requires an Elastic user who can create API keys and write to logs-* and metrics-*."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:onSubmit,fill:true,isLoading:isFormLoading,type:"submit"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.enableCentralManagement",defaultMessage:"Create user and enable central management"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}))))}return external_kbnSharedDeps_React_default.a.createElement(WithoutHeaderLayout,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],{restrictWidth:820},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.setupPage.missingRequirementsCalloutTitle",{defaultMessage:"Missing security requirements"}),color:"warning",iconType:"alert"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.missingRequirementsCalloutDescription",defaultMessage:"To use central management for Elastic Agents, enable the following Elasticsearch and Kibana security features."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.missingRequirementsElasticsearchTitle",defaultMessage:"In your Elasticsearch policy, enable:"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(RequirementItem,{isMissing:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.elasticsearchSecurityFlagText",defaultMessage:"{esSecurityLink}. Set {securityFlag} to {true} .",values:{esSecurityLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/elasticsearch/reference/current/configuring-security.html",target:"_blank",external:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.elasticsearchSecurityLink",defaultMessage:"Elasticsearch security"})),securityFlag:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.security.enabled"),true:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"true")}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(RequirementItem,{isMissing:missingRequirements.includes("api_keys")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.elasticsearchApiKeyFlagText",defaultMessage:"{apiKeyLink}. Set {apiKeyFlag} to {true} .",values:{apiKeyFlag:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.security.authc.api_key.enabled"),true:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"true"),apiKeyLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/elasticsearch/reference/current/security-settings.html#api-key-service-settings",target:"_blank",external:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.apiKeyServiceLink",defaultMessage:"API key service"}))}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{isCopyable:true},`xpack.security.enabled: true\nxpack.security.authc.api_key.enabled: true`),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.missingRequirementsKibanaTitle",defaultMessage:"In your Kibana policy, enable:"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(RequirementItem,{isMissing:missingRequirements.includes("tls_required")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.tlsFlagText",defaultMessage:"{kibanaSecurityLink}. Set {securityFlag} to {true}. For development purposes, you can disable {tlsLink} by setting {tlsFlag} to {true} as an unsafe alternative.",values:{kibanaSecurityLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/kibana/current/using-kibana-with-security.html",target:"_blank",external:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.kibanaSecurityLink",defaultMessage:"Kibana security"})),securityFlag:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.security.enabled"),tlsLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/kibana/current/configuring-tls.html",target:"_blank",external:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.tlsLink",defaultMessage:"TLS"})),tlsFlag:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.fleet.agents.tlsCheckDisabled"),true:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"true")}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(RequirementItem,{isMissing:missingRequirements.includes("encrypted_saved_object_encryption_key_required")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.encryptionKeyFlagText",defaultMessage:"{encryptionKeyLink}. Set {keyFlag} to any alphanumeric value of at least 32 characters.",values:{encryptionKeyLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/kibana/current/fleet-settings-kb.html",target:"_blank",external:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.kibanaEncryptionLink",defaultMessage:"Kibana encryption key"})),keyFlag:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"xpack.encryptedSavedObjects.encryptionKey")}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{isCopyable:true},`xpack.security.enabled: true\nxpack.encryptedSavedObjects.encryptionKey: "something_at_least_32_characters"`),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"l"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.gettingStartedText",defaultMessage:"For more information, read our {link} guide.",values:{link:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://www.elastic.co/guide/en/fleet/current/index.html",target:"_blank",external:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.setupPage.gettingStartedLink",defaultMessage:"Getting Started"}))}}))))};const AgentRefreshContext=external_kbnSharedDeps_React_default.a.createContext({refresh:()=>{}});function useAgentRefresh(){return external_kbnSharedDeps_React_default.a.useContext(AgentRefreshContext).refresh}var kibanaUtils_public_=__webpack_require__(28);const AGENT_LOG_INDEX_PATTERN="logs-elastic_agent-*,logs-elastic_agent.*-*";const AGENT_DATASET="elastic_agent";const AGENT_DATASET_FILEBEAT="elastic_agent.filebeat";const AGENT_DATASET_METRICBEAT="elastic_agent.metricbeat";const AGENT_DATASET_PATTERN="elastic_agent.*";const AGENT_ID_FIELD={name:"elastic_agent.id",type:"string"};const DATASET_FIELD={name:"data_stream.dataset",type:"string",aggregatable:true};const LOG_LEVEL_FIELD={name:"log.level",type:"string",aggregatable:true};const DEFAULT_DATE_RANGE={start:"now-1d",end:"now"};const DEFAULT_LOGS_STATE={start:DEFAULT_DATE_RANGE.start,end:DEFAULT_DATE_RANGE.end,logLevels:[],datasets:[AGENT_DATASET],query:""};const STATE_STORAGE_KEY="_q";const STATE_DATASET_FIELD="datasets";const AGENT_LOG_LEVELS={ERROR:"error",WARNING:"warning",INFO:"info",DEBUG:"debug"};const ORDERED_FILTER_LOG_LEVELS=["error","warning","warn","notice","info","debug"];const DEFAULT_LOG_LEVEL=AGENT_LOG_LEVELS.INFO;var url=__webpack_require__(129);var url_default=__webpack_require__.n(url);var rison=__webpack_require__(273);var query_string=__webpack_require__(134);var useMeasure=__webpack_require__(275);var useMeasure_default=__webpack_require__.n(useMeasure);var gte=__webpack_require__(274);var gte_default=__webpack_require__.n(gte);var coerce=__webpack_require__(21);var coerce_default=__webpack_require__.n(coerce);var kibanaReact_public_=__webpack_require__(97);var infra_public_=__webpack_require__(104);const DatasetFilter=Object(external_kbnSharedDeps_React_["memo"])(({selectedDatasets:selectedDatasets,onToggleDataset:onToggleDataset})=>{const{data:data}=Object(hooks["mb"])();const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[datasetValues,setDatasetValues]=Object(external_kbnSharedDeps_React_["useState"])([AGENT_DATASET]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchValues=async()=>{setIsLoading(true);try{const values=await data.autocomplete.getValueSuggestions({indexPattern:{title:AGENT_LOG_INDEX_PATTERN,fields:[DATASET_FIELD]},field:DATASET_FIELD,query:""});setDatasetValues(values.sort())}catch(e){setDatasetValues([AGENT_DATASET])}setIsLoading(false)};fetchValues()},[data.autocomplete]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",onClick:()=>setIsOpen(true),isSelected:isOpen,isLoading:isLoading,numFilters:datasetValues.length,hasActiveFilters:selectedDatasets.length>0,numActiveFilters:selectedDatasets.length},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentLogs.datasetSelectText",{defaultMessage:"Dataset"})),isOpen:isOpen,closePopover:()=>setIsOpen(false),panelPaddingSize:"none"},datasetValues.map(dataset=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{checked:selectedDatasets.includes(dataset)?"on":undefined,key:dataset,onClick:()=>onToggleDataset(dataset)},dataset)))});function sortLogLevels(levels){return[...new Set([...ORDERED_FILTER_LOG_LEVELS.filter(level=>levels.includes(level)),...levels.sort()])]}const LogLevelFilter=Object(external_kbnSharedDeps_React_["memo"])(({selectedLevels:selectedLevels,onToggleLevel:onToggleLevel})=>{const{data:data}=Object(hooks["mb"])();const[isOpen,setIsOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[levelValues,setLevelValues]=Object(external_kbnSharedDeps_React_["useState"])([]);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchValues=async()=>{setIsLoading(true);try{const values=await data.autocomplete.getValueSuggestions({indexPattern:{title:AGENT_LOG_INDEX_PATTERN,fields:[LOG_LEVEL_FIELD]},field:LOG_LEVEL_FIELD,query:""});setLevelValues(sortLogLevels(values))}catch(e){setLevelValues([])}setIsLoading(false)};fetchValues()},[data.autocomplete]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{button:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterButton"],{iconType:"arrowDown",onClick:()=>setIsOpen(true),isSelected:isOpen,isLoading:isLoading,numFilters:levelValues.length,hasActiveFilters:selectedLevels.length>0,numActiveFilters:selectedLevels.length},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentLogs.logLevelSelectText",{defaultMessage:"Log level"})),isOpen:isOpen,closePopover:()=>setIsOpen(false),panelPaddingSize:"none"},levelValues.map(level=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterSelectItem"],{checked:selectedLevels.includes(level)?"on":undefined,key:level,onClick:()=>onToggleLevel(level)},level)))});const EXCLUDED_FIELDS=[AGENT_ID_FIELD.name,DATASET_FIELD.name,LOG_LEVEL_FIELD.name];const LogQueryBar=Object(external_kbnSharedDeps_React_["memo"])(({query:query,isQueryValid:isQueryValid,onUpdateQuery:onUpdateQuery})=>{const{data:data}=Object(hooks["mb"])();const[indexPatternFields,setIndexPatternFields]=Object(external_kbnSharedDeps_React_["useState"])();Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const fetchFields=async()=>{try{const fields=(await data.indexPatterns.getFieldsForWildcard({pattern:AGENT_LOG_INDEX_PATTERN})||[]).filter(field=>!EXCLUDED_FIELDS.includes(field.name));setIndexPatternFields(fields)}catch(err){setIndexPatternFields(undefined)}};fetchFields()},[data.indexPatterns]);return external_kbnSharedDeps_React_default.a.createElement(public_["QueryStringInput"],{iconType:"search",disableLanguageSwitcher:true,indexPatterns:indexPatternFields?[{title:AGENT_LOG_INDEX_PATTERN,fields:indexPatternFields}]:[],query:{query:query,language:"kuery"},isInvalid:!isQueryValid,disableAutoFocus:true,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentLogs.searchPlaceholderText",{defaultMessage:"Search logs…"}),onChange:newQuery=>{onUpdateQuery(newQuery.query)},onSubmit:newQuery=>{onUpdateQuery(newQuery.query,true)}})});const buildQuery=({agentId:agentId,datasets:datasets,logLevels:logLevels,userQuery:userQuery})=>{const agentIdQuery=`${AGENT_ID_FIELD.name}:${agentId}`;const datasetQuery=datasets.length?datasets.map(dataset=>`${DATASET_FIELD.name}:${dataset}`).join(" or "):`${DATASET_FIELD.name}:${AGENT_DATASET} or ${DATASET_FIELD.name}:${AGENT_DATASET_PATTERN}`;const logLevelQuery=logLevels.map(level=>`${LOG_LEVEL_FIELD.name}:${level}`).join(" or ");const agentQuery=`${agentIdQuery} and (${datasetQuery})`;const baseQuery=logLevelQuery?`${agentQuery} and (${logLevelQuery})`:agentQuery;const finalQuery=userQuery?`(${baseQuery}) and (${userQuery})`:baseQuery;return finalQuery};const LEVEL_VALUES=Object.values(AGENT_LOG_LEVELS);const SelectLogLevel=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent})=>{var _agent$local_metadata,_agent$local_metadata2,_agent$local_metadata3,_agent$local_metadata4;const{notifications:notifications}=Object(hooks["mb"])();const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[agentLogLevel,setAgentLogLevel]=Object(external_kbnSharedDeps_React_["useState"])((_agent$local_metadata=(_agent$local_metadata2=agent.local_metadata)===null||_agent$local_metadata2===void 0?void 0:(_agent$local_metadata3=_agent$local_metadata2.elastic)===null||_agent$local_metadata3===void 0?void 0:(_agent$local_metadata4=_agent$local_metadata3.agent)===null||_agent$local_metadata4===void 0?void 0:_agent$local_metadata4.log_level)!==null&&_agent$local_metadata!==void 0?_agent$local_metadata:DEFAULT_LOG_LEVEL);const[selectedLogLevel,setSelectedLogLevel]=Object(external_kbnSharedDeps_React_["useState"])(agentLogLevel);const onClickApply=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{setIsLoading(true);async function send(){try{const res=await Object(hooks["v"])(agent.id,{action:{type:"SETTINGS",data:{log_level:selectedLogLevel}}});if(res.error){throw res.error}setAgentLogLevel(selectedLogLevel);notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentLogs.selectLogLevel.successText",{defaultMessage:`Changed agent logging level to '{logLevel}'.`,values:{logLevel:selectedLogLevel}}))}catch(error){notifications.toasts.addError(error,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentLogs.selectLogLevel.errorTitleText",{defaultMessage:"Error updating agent logging level"})})}setIsLoading(false)}send()},[notifications,selectedLogLevel,agent.id]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormLabel"],{htmlFor:"selectAgentLogLevel"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Agent logging level"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{disabled:isLoading,compressed:true,id:"selectAgentLogLevel",value:selectedLogLevel,onChange:event=>{setSelectedLogLevel(event.target.value)},options:LEVEL_VALUES.map(level=>({text:level,value:level}))})),agentLogLevel!==selectedLogLevel&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{flush:"left",size:"xs",isLoading:isLoading,disabled:agentLogLevel===selectedLogLevel,iconType:"refresh",onClick:onClickApply},isLoading?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentLogs.updateButtonLoadingText",defaultMessage:"Applying changes..."}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentLogs.updateButtonText",defaultMessage:"Apply changes"}))))});const WrapperFlexGroup=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"]).withConfig({displayName:"WrapperFlexGroup",componentId:"mjo9ba-0"})(["height:100%;"]);const DatePickerFlexItem=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"DatePickerFlexItem",componentId:"mjo9ba-1"})(["max-width:312px;"]);const AgentLogsUrlStateHelper=Object(kibanaUtils_public_["createStateContainerReactHelpers"])();const AgentLogsUI=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent,state:state})=>{var _agent$local_metadata,_agent$local_metadata2,_agent$local_metadata3;const{data:data,application:application,http:http}=Object(hooks["mb"])();const{update:updateState}=AgentLogsUrlStateHelper.useTransitions();const getDateRangeTimestamps=Object(external_kbnSharedDeps_React_["useCallback"])(timeRange=>{const{min:min,max:max}=data.query.timefilter.timefilter.calculateBounds(timeRange);return min&&max?{start:min.valueOf(),end:max.valueOf()}:undefined},[data.query.timefilter.timefilter]);const tryUpdateDateRange=Object(external_kbnSharedDeps_React_["useCallback"])(timeRange=>{const timestamps=getDateRangeTimestamps(timeRange);if(timestamps){updateState({start:timeRange.from,end:timeRange.to})}},[getDateRangeTimestamps,updateState]);const[dateRangeTimestamps,setDateRangeTimestamps]=Object(external_kbnSharedDeps_React_["useState"])(getDateRangeTimestamps({from:state.start,to:state.end})||getDateRangeTimestamps({from:DEFAULT_DATE_RANGE.start,to:DEFAULT_DATE_RANGE.end}));Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const timestampsFromDateRange=getDateRangeTimestamps({from:state.start,to:state.end});if(!timestampsFromDateRange){tryUpdateDateRange({from:DEFAULT_DATE_RANGE.start,to:DEFAULT_DATE_RANGE.end})}else{setDateRangeTimestamps(timestampsFromDateRange)}},[state.start,state.end,getDateRangeTimestamps,tryUpdateDateRange]);const isQueryValid=Object(external_kbnSharedDeps_React_["useCallback"])(testQuery=>{try{public_["esKuery"].fromKueryExpression(testQuery);return true}catch(err){return false}},[]);const[draftQuery,setDraftQuery]=Object(external_kbnSharedDeps_React_["useState"])(state.query);const[isDraftQueryValid,setIsDraftQueryValid]=Object(external_kbnSharedDeps_React_["useState"])(isQueryValid(state.query));const onUpdateDraftQuery=Object(external_kbnSharedDeps_React_["useCallback"])((newDraftQuery,runQuery)=>{setDraftQuery(newDraftQuery);if(isQueryValid(newDraftQuery)){setIsDraftQueryValid(true);if(runQuery){updateState({query:newDraftQuery})}}else{setIsDraftQueryValid(false)}},[isQueryValid,updateState]);const logStreamQuery=Object(external_kbnSharedDeps_React_["useMemo"])(()=>buildQuery({agentId:agent.id,datasets:state.datasets,logLevels:state.logLevels,userQuery:state.query}),[agent.id,state.datasets,state.logLevels,state.query]);const viewInLogsUrl=Object(external_kbnSharedDeps_React_["useMemo"])(()=>http.basePath.prepend(url_default.a.format({pathname:"/app/logs/stream",search:Object(query_string["stringify"])({logPosition:Object(rison["encode"])({start:state.start,end:state.end,streamLive:false}),logFilter:Object(rison["encode"])({expression:logStreamQuery,kind:"kuery"})},{sort:false,encode:false})})),[http.basePath,state.start,state.end,logStreamQuery]);const agentVersion=(_agent$local_metadata=agent.local_metadata)===null||_agent$local_metadata===void 0?void 0:(_agent$local_metadata2=_agent$local_metadata.elastic)===null||_agent$local_metadata2===void 0?void 0:(_agent$local_metadata3=_agent$local_metadata2.agent)===null||_agent$local_metadata3===void 0?void 0:_agent$local_metadata3.version;const isLogFeatureAvailable=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{var _semverCoerce;if(!agentVersion){return false}const agentVersionWithPrerelease=(_semverCoerce=coerce_default()(agentVersion))===null||_semverCoerce===void 0?void 0:_semverCoerce.version;if(!agentVersionWithPrerelease){return false}return gte_default()(agentVersionWithPrerelease,"7.11.0")},[agentVersion]);const[logsPanelRef,{height:measuredlogPanelHeight}]=useMeasure_default()();const logPanelHeight=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Math.max(measuredlogPanelHeight,600),[measuredlogPanelHeight]);if(!isLogFeatureAvailable){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"m",color:"warning",title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentLogs.oldAgentWarningTitle",defaultMessage:"The Logs view requires Elastic Agent 7.11 or higher. To upgrade an agent, go to the Actions menu, or {downloadLink} a newer version.",values:{downloadLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://ela.st/download-elastic-agent",external:true,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentLogs.downloadLink",defaultMessage:"download"}))}})})}return external_kbnSharedDeps_React_default.a.createElement(WrapperFlexGroup,{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(LogQueryBar,{query:draftQuery,onUpdateQuery:onUpdateDraftQuery,isQueryValid:isDraftQueryValid})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilterGroup"],null,external_kbnSharedDeps_React_default.a.createElement(DatasetFilter,{selectedDatasets:state.datasets,onToggleDataset:dataset=>{const currentDatasets=[...state.datasets];const datasetPosition=currentDatasets.indexOf(dataset);if(datasetPosition>=0){currentDatasets.splice(datasetPosition,1);updateState({datasets:currentDatasets})}else{updateState({datasets:[...state.datasets,dataset]})}}}),external_kbnSharedDeps_React_default.a.createElement(LogLevelFilter,{selectedLevels:state.logLevels,onToggleLevel:level=>{const currentLevels=[...state.logLevels];const levelPosition=currentLevels.indexOf(level);if(levelPosition>=0){currentLevels.splice(levelPosition,1);updateState({logLevels:currentLevels})}else{updateState({logLevels:[...state.logLevels,level]})}}}))),external_kbnSharedDeps_React_default.a.createElement(DatePickerFlexItem,{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSuperDatePicker"],{showUpdateButton:false,start:state.start,end:state.end,onTimeChange:({start:start,end:end})=>{tryUpdateDateRange({from:start,to:end})}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(kibanaReact_public_["RedirectAppLinks"],{application:application},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{href:viewInLogsUrl,iconType:"popout",flush:"both"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentLogs.openInLogsUiLinkText",defaultMessage:"Open in Logs"})))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"none",panelRef:logsPanelRef},external_kbnSharedDeps_React_default.a.createElement(infra_public_["LogStream"],{height:logPanelHeight,startTimestamp:dateRangeTimestamps.start,endTimestamp:dateRangeTimestamps.end,query:logStreamQuery}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(SelectLogLevel,{agent:agent})))});const AgentLogs=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent})=>{const stateContainer=Object(external_kbnSharedDeps_React_["useMemo"])(()=>Object(kibanaUtils_public_["createStateContainer"])({...DEFAULT_LOGS_STATE,...Object(kibanaUtils_public_["getStateFromKbnUrl"])(STATE_STORAGE_KEY,window.location.href)},{update:state=>updatedState=>({...state,...updatedState})}),[]);const AgentLogsConnected=Object(external_kbnSharedDeps_React_["useMemo"])(()=>AgentLogsUrlStateHelper.connect(state=>({state:state||DEFAULT_LOGS_STATE}))(AgentLogsUI),[]);const[isSyncReady,setIsSyncReady]=Object(external_kbnSharedDeps_React_["useState"])(false);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{const stateStorage=Object(kibanaUtils_public_["createKbnUrlStateStorage"])();const{start:start,stop:stop}=Object(kibanaUtils_public_["syncState"])({storageKey:STATE_STORAGE_KEY,stateContainer:stateContainer,stateStorage:stateStorage});start();setIsSyncReady(true);return()=>{stop();stateContainer.set(DEFAULT_LOGS_STATE)}},[stateContainer]);return external_kbnSharedDeps_React_default.a.createElement(AgentLogsUrlStateHelper.Provider,{value:stateContainer},isSyncReady?external_kbnSharedDeps_React_default.a.createElement(AgentLogsConnected,{agent:agent}):null)});const AgentDetailsActionMenu=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent,assignFlyoutOpenByDefault:assignFlyoutOpenByDefault=false,onCancelReassign:onCancelReassign})=>{const hasWriteCapabilites=Object(hooks["K"])().write;const kibanaVersion=Object(hooks["fb"])();const refreshAgent=useAgentRefresh();const[isReassignFlyoutOpen,setIsReassignFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(assignFlyoutOpenByDefault);const[isUnenrollModalOpen,setIsUnenrollModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[isUpgradeModalOpen,setIsUpgradeModalOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const isUnenrolling=agent.status==="unenrolling";const onClose=Object(external_kbnSharedDeps_React_["useMemo"])(()=>{if(onCancelReassign){return onCancelReassign}else{return()=>setIsReassignFlyoutOpen(false)}},[onCancelReassign,setIsReassignFlyoutOpen]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,isReassignFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentReassignAgentPolicyFlyout,{agents:[agent],onClose:onClose})),isUnenrollModalOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentUnenrollAgentModal,{agents:[agent],agentCount:1,onClose:()=>{setIsUnenrollModalOpen(false);refreshAgent()},useForceUnenroll:isUnenrolling})),isUpgradeModalOpen&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentUpgradeAgentModal,{agents:[agent],agentCount:1,version:kibanaVersion,onClose:()=>{setIsUpgradeModalOpen(false);refreshAgent()}})),external_kbnSharedDeps_React_default.a.createElement(ContextMenuActions,{button:{props:{iconType:"arrowDown",iconSide:"right",color:"primary",fill:true},children:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.actionsButton",defaultMessage:"Actions"})},items:[external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"pencil",onClick:()=>{setIsReassignFlyoutOpen(true)},disabled:!agent.active,key:"reassignPolicy"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"cross",disabled:!hasWriteCapabilites||!agent.active,onClick:()=>{setIsUnenrollModalOpen(true)}},isUnenrolling?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuItem"],{icon:"refresh",disabled:!Object(services["l"])(agent,kibanaVersion),onClick:()=>{setIsUpgradeModalOpen(true)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))]}))});const agent_details_overview_FlexItemWithMinWidth=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-19wc892-0"})(["min-width:0px;"]);const AgentDetailsOverviewSection=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent,agentPolicy:agentPolicy})=>{var _agent$local_metadata,_agent$local_metadata2,_agent$local_metadata3,_agent$local_metadata4,_agent$local_metadata5,_agent$local_metadata6,_agent$local_metadata7,_agent$local_metadata8,_agent$local_metadata9,_agent$local_metadata10,_agent$local_metadata11,_agent$local_metadata12,_agent$local_metadata13,_agentPolicy$monitori,_agentPolicy$monitori2;const{getHref:getHref}=Object(hooks["hb"])();const kibanaVersion=Object(hooks["fb"])();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{compressed:true},[{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.hostIdLabel",{defaultMessage:"Agent ID"}),description:agent.id},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.agentPolicyLabel",{defaultMessage:"Agent policy"}),description:agentPolicy?external_kbnSharedDeps_React_default.a.createElement(LinkAndRevision,{href:getHref("policy_details",{policyId:agentPolicy.id}),title:agentPolicy.name||agent.policy_id,revision:agent.policy_revision||undefined},agentPolicy.name||agentPolicy.id):agent.policy_id||"-"},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.versionLabel",{defaultMessage:"Agent version"}),description:typeof((_agent$local_metadata=agent.local_metadata)===null||_agent$local_metadata===void 0?void 0:(_agent$local_metadata2=_agent$local_metadata.elastic)===null||_agent$local_metadata2===void 0?void 0:(_agent$local_metadata3=_agent$local_metadata2.agent)===null||_agent$local_metadata3===void 0?void 0:_agent$local_metadata3.version)==="string"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center",style:{minWidth:0}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textNoWrap"},agent.local_metadata.elastic.agent.version),Object(services["l"])(agent,kibanaVersion)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{position:"right",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentList.agentUpgradeLabel",{defaultMessage:"Upgrade available"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"alert",color:"warning"}))):null):"-"},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.integrationsLabel",{defaultMessage:"Integrations"}),description:agent.policy_id?external_kbnSharedDeps_React_default.a.createElement(AgentPolicyPackageBadges,{agentPolicyId:agent.policy_id,hideTitle:true}):null},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.hostNameLabel",{defaultMessage:"Host name"}),description:typeof((_agent$local_metadata4=agent.local_metadata)===null||_agent$local_metadata4===void 0?void 0:(_agent$local_metadata5=_agent$local_metadata4.host)===null||_agent$local_metadata5===void 0?void 0:_agent$local_metadata5.hostname)==="string"?agent.local_metadata.host.hostname:"-"},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.logLevel",{defaultMessage:"Logging level"}),description:typeof((_agent$local_metadata6=agent.local_metadata)===null||_agent$local_metadata6===void 0?void 0:(_agent$local_metadata7=_agent$local_metadata6.elastic)===null||_agent$local_metadata7===void 0?void 0:(_agent$local_metadata8=_agent$local_metadata7.agent)===null||_agent$local_metadata8===void 0?void 0:_agent$local_metadata8.log_level)==="string"?agent.local_metadata.elastic.agent.log_level:"-"},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.releaseLabel",{defaultMessage:"Agent release"}),description:typeof((_agent$local_metadata9=agent.local_metadata)===null||_agent$local_metadata9===void 0?void 0:(_agent$local_metadata10=_agent$local_metadata9.elastic)===null||_agent$local_metadata10===void 0?void 0:(_agent$local_metadata11=_agent$local_metadata10.agent)===null||_agent$local_metadata11===void 0?void 0:_agent$local_metadata11.snapshot)==="boolean"?agent.local_metadata.elastic.agent.snapshot===true?"snapshot":"stable":"-"},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"Platform"}),description:typeof((_agent$local_metadata12=agent.local_metadata)===null||_agent$local_metadata12===void 0?void 0:(_agent$local_metadata13=_agent$local_metadata12.os)===null||_agent$local_metadata13===void 0?void 0:_agent$local_metadata13.platform)==="string"?agent.local_metadata.os.platform:"-"},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.monitorLogsLabel",{defaultMessage:"Monitor logs"}),description:agentPolicy!==null&&agentPolicy!==void 0&&(_agentPolicy$monitori=agentPolicy.monitoring_enabled)!==null&&_agentPolicy$monitori!==void 0&&_agentPolicy$monitori.includes("logs")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.monitorLogsEnabledText",defaultMessage:"True"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.monitorLogsDisabledText",defaultMessage:"False"})},{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.monitorMetricsLabel",{defaultMessage:"Monitor metrics"}),description:agentPolicy!==null&&agentPolicy!==void 0&&(_agentPolicy$monitori2=agentPolicy.monitoring_enabled)!==null&&_agentPolicy$monitori2!==void 0&&_agentPolicy$monitori2.includes("metrics")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.monitorMetricsEnabledText",defaultMessage:"True"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.monitorMetricsDisabledText",defaultMessage:"False"})}].map(({title:title,description:description})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(agent_details_overview_FlexItemWithMinWidth,{grow:3},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,title)),external_kbnSharedDeps_React_default.a.createElement(agent_details_overview_FlexItemWithMinWidth,{grow:7},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],{className:"eui-textTruncate"},description))))))});function displayInputType(inputType){if(inputType==="logfile"){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetailsIntegrations.inputTypeLogText",{defaultMessage:"Logs"})}if(inputType==="endpoint"){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetailsIntegrations.inputTypeEndpointText",{defaultMessage:"Endpoint"})}if(inputType.match(/\/metrics$/)){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetailsIntegrations.inputTypeMetricsText",{defaultMessage:"Metrics"})}return inputType}function getLogsQueryByInputType(inputType){if(inputType==="logfile"){return`(${STATE_DATASET_FIELD}:!(${AGENT_DATASET_FILEBEAT}))`}if(inputType.match(/\/metrics$/)){return`(${STATE_DATASET_FIELD}:!(${AGENT_DATASET_METRICBEAT}))`}return""}const agent_details_integrations_StyledEuiAccordion=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiAccordion"]).withConfig({displayName:"StyledEuiAccordion",componentId:"sc-12a1xr8-0"})([".ingest-integration-title-button{padding:",";}&.euiAccordion-isOpen .ingest-integration-title-button{border-bottom:1px solid ",";}.euiTableRow:last-child .euiTableRowCell{border-bottom:none;}.euiIEFlexWrapFix{min-width:0;}"],props=>props.theme.eui.paddingSizes.m,props=>props.theme.eui.euiColorLightShade);const CollapsablePanel=({id:id,title:title,children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"none"},external_kbnSharedDeps_React_default.a.createElement(agent_details_integrations_StyledEuiAccordion,{id:id,arrowDisplay:"right",buttonClassName:"ingest-integration-title-button",buttonContent:title},children));const AgentDetailsIntegration=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent,agentPolicy:agentPolicy,packagePolicy:packagePolicy})=>{const{getHref:getHref}=Object(hooks["hb"])();const inputs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>packagePolicy.inputs.filter(input=>input.enabled),[packagePolicy.inputs]);const columns=[{field:"type",width:"100%",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetailsIntegrations.inputTypeLabel",{defaultMessage:"Input"}),render:inputType=>displayInputType(inputType)},{align:"right",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetailsIntegrations.actionsLabel",{defaultMessage:"Actions"}),field:"type",width:"auto",render:inputType=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetailsIntegrations.viewLogsButton",{defaultMessage:"View logs"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{href:getHref("fleet_agent_details",{agentId:agent.id,tabId:"logs",logQuery:getLogsQueryByInputType(inputType)}),iconType:"editorAlignLeft"}))}];return external_kbnSharedDeps_React_default.a.createElement(CollapsablePanel,{id:packagePolicy.id,title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},packagePolicy.package?external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{packageName:packagePolicy.package.name,version:packagePolicy.package.version,size:"l",tryApi:true}):external_kbnSharedDeps_React_default.a.createElement(PackageIcon,{size:"l",packageName:"default",version:"0"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{className:"eui-textTruncate"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{className:"eui-textTruncate",href:getHref("edit_integration",{policyId:agentPolicy.id,packagePolicyId:packagePolicy.id})},packagePolicy.name)))))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{tableLayout:"auto",items:inputs,columns:columns}))});const AgentDetailsIntegrationsSection=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent,agentPolicy:agentPolicy})=>{if(!agentPolicy||!agentPolicy.package_policies){return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},agentPolicy.package_policies.map(packagePolicy=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,key:packagePolicy.id},external_kbnSharedDeps_React_default.a.createElement(AgentDetailsIntegration,{agent:agent,agentPolicy:agentPolicy,packagePolicy:packagePolicy}))))});const agent_details_FlexItemWithMinWidth=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"]).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1svqtoc-0"})(["min-width:0px;"]);const AgentDetailsContent=Object(external_kbnSharedDeps_React_["memo"])(({agent:agent,agentPolicy:agentPolicy})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(agent_details_FlexItemWithMinWidth,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.overviewSectionTitle",defaultMessage:"Overview"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(AgentDetailsOverviewSection,{agent:agent,agentPolicy:agentPolicy})),external_kbnSharedDeps_React_default.a.createElement(agent_details_FlexItemWithMinWidth,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.integrationsSectionTitle",defaultMessage:"Integrations"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(AgentDetailsIntegrationsSection,{agent:agent,agentPolicy:agentPolicy})))));const AgentDetailsPage=()=>{var _agentData$item,_agentData$item2,_agentData$item2$loca;const{params:{agentId:agentId,tabId:tabId=""}}=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();const{getHref:getHref}=Object(hooks["hb"])();const kibanaVersion=Object(hooks["fb"])();const{isLoading:isLoading,isInitialRequest:isInitialRequest,error:error,data:agentData,resendRequest:sendAgentRequest}=Object(hooks["U"])(agentId,{pollIntervalMs:5e3});const{isLoading:isAgentPolicyLoading,data:agentPolicyData,sendRequest:sendAgentPolicyRequest}=Object(hooks["V"])(agentData===null||agentData===void 0?void 0:(_agentData$item=agentData.item)===null||_agentData$item===void 0?void 0:_agentData$item.policy_id);const{application:{navigateToApp:navigateToApp}}=Object(hooks["mb"])();const routeState=useIntraAppState();const queryParams=new URLSearchParams(Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])().search);const openReassignFlyoutOpenByDefault=queryParams.get("openReassignFlyout")==="true";const reassignCancelClickHandler=Object(external_kbnSharedDeps_React_["useCallback"])(()=>{if(routeState&&routeState.onDoneNavigateTo){navigateToApp(routeState.onDoneNavigateTo[0],routeState.onDoneNavigateTo[1])}},[routeState,navigateToApp]);const host=agentData===null||agentData===void 0?void 0:(_agentData$item2=agentData.item)===null||_agentData$item2===void 0?void 0:(_agentData$item2$loca=_agentData$item2.local_metadata)===null||_agentData$item2$loca===void 0?void 0:_agentData$item2$loca.host;const headerLeftContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s",alignItems:"flexStart"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"arrowLeft",href:getHref("fleet_agent_list"),flush:"left",size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.viewAgentListTitle",defaultMessage:"View all agents"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{className:"eui-textBreakWord"},external_kbnSharedDeps_React_default.a.createElement("h1",null,isLoading&&isInitialRequest?external_kbnSharedDeps_React_default.a.createElement(Loading,null):typeof host==="object"&&typeof(host===null||host===void 0?void 0:host.hostname)==="string"?host.hostname:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.agentDetailsTitle",defaultMessage:"Agent '{id}'",values:{id:agentId}}))))),[host,agentId,getHref,isInitialRequest,isLoading]);const headerRightContent=Object(external_kbnSharedDeps_React_["useMemo"])(()=>agentData&&agentData.item?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",direction:"row"},[{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.statusLabel",{defaultMessage:"Status"}),content:external_kbnSharedDeps_React_default.a.createElement(AgentHealth,{agent:agentData.item})},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.lastActivityLabel",{defaultMessage:"Last activity"}),content:agentData.item.last_checkin?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedRelative"],{value:new Date(agentData.item.last_checkin)}):"-"},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.policyLabel",{defaultMessage:"Policy"}),content:isAgentPolicyLoading?external_kbnSharedDeps_React_default.a.createElement(Loading,{size:"m"}):agentPolicyData!==null&&agentPolicyData!==void 0&&agentPolicyData.item?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:getHref("policy_details",{policyId:agentData.item.policy_id}),className:"eui-textBreakWord"},agentPolicyData.item.name||agentData.item.policy_id):agentData.item.policy_id||"-"},{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.agentVersionLabel",{defaultMessage:"Agent version"}),content:typeof agentData.item.local_metadata.elastic==="object"&&typeof agentData.item.local_metadata.elastic.agent==="object"&&typeof agentData.item.local_metadata.elastic.agent.version==="string"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"eui-textNoWrap"},agentData.item.local_metadata.elastic.agent.version),Object(services["l"])(agentData.item,kibanaVersion)?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.upgradeAvailableTooltip",{defaultMessage:"Upgrade available"}),size:"m",type:"alert",color:"warning",content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.upgradeAvailableTooltip",{defaultMessage:"Upgrade available"})})):null):"-"},{content:external_kbnSharedDeps_React_default.a.createElement(AgentDetailsActionMenu,{agent:agentData.item,assignFlyoutOpenByDefault:openReassignFlyoutOpenByDefault,onCancelReassign:routeState&&routeState.onDoneNavigateTo?reassignCancelClickHandler:undefined})}].map((item,index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,key:index},item.label?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"],{compressed:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,item.label),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,item.content)):item.content))):undefined,[agentPolicyData,agentData,getHref,isAgentPolicyLoading]);const headerTabs=Object(external_kbnSharedDeps_React_["useMemo"])(()=>[{id:"details",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.subTabs.detailsTab",{defaultMessage:"Agent details"}),href:getHref("fleet_agent_details",{agentId:agentId,tabId:"details"}),isSelected:!tabId||tabId==="details"},{id:"logs",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.subTabs.logsTab",{defaultMessage:"Logs"}),href:getHref("fleet_agent_details",{agentId:agentId,tabId:"logs"}),isSelected:tabId==="logs"}],[getHref,agentId,tabId]);return external_kbnSharedDeps_React_default.a.createElement(AgentRefreshContext.Provider,{value:{refresh:()=>{sendAgentRequest();sendAgentPolicyRequest()}}},external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:headerLeftContent,rightColumn:headerRightContent,tabs:headerTabs},isLoading&&isInitialRequest?external_kbnSharedDeps_React_default.a.createElement(Loading,null):error?external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.unexceptedErrorTitle",defaultMessage:"Error loading agent"}),error:error}):agentData&&agentData.item?external_kbnSharedDeps_React_default.a.createElement(AgentDetailsPageContent,{agent:agentData.item,agentPolicy:agentPolicyData===null||agentPolicyData===void 0?void 0:agentPolicyData.item}):external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentDetails.agentNotFoundErrorTitle",defaultMessage:"Agent not found"}),error:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.agentDetails.agentNotFoundErrorDescription",{defaultMessage:"Cannot find agent ID {agentId}",values:{agentId:agentId}})})))};const AgentDetailsPageContent=({agent:agent,agentPolicy:agentPolicy})=>{Object(hooks["J"])("fleet_agent_details",{agentHost:typeof agent.local_metadata.host==="object"&&typeof agent.local_metadata.host.hostname==="string"?agent.local_metadata.host.hostname:"-"});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].fleet_agent_details_logs,render:()=>external_kbnSharedDeps_React_default.a.createElement(AgentLogs,{agent:agent})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].fleet_agent_details,render:()=>external_kbnSharedDeps_React_default.a.createElement(AgentDetailsContent,{agent:agent,agentPolicy:agentPolicy})}))};const NoDataLayout=Object(external_kbnSharedDeps_ReactRouterDom_["withRouter"])(({actionSection:actionSection,title:title,modalClosePath:modalClosePath,children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"logoBeats",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,title),body:children,actions:actionSection})))));const NoAccessPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(({intl:intl})=>external_kbnSharedDeps_React_default.a.createElement(NoDataLayout,{title:intl.formatMessage({id:"xpack.fleet.noAccess.accessDeniedTitle",defaultMessage:"Access denied"}),actionSection:[]},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.noAccess.accessDeniedDescription",defaultMessage:"You are not authorized to access Elastic Fleet. To use Elastic Fleet, you need a user role that contains read or all permissions for this application."}))));function new_enrollment_key_flyout_extends(){new_enrollment_key_flyout_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return new_enrollment_key_flyout_extends.apply(this,arguments)}function useCreateApiKeyForm(policyIdDefaultValue,onSuccess){const{notifications:notifications}=Object(hooks["mb"])();const[isLoading,setIsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const apiKeyNameInput=Object(hooks["db"])("");const policyIdInput=Object(hooks["db"])(policyIdDefaultValue);const onSubmit=async event=>{event.preventDefault();setIsLoading(true);try{const res=await Object(hooks["F"])({method:"post",path:services["g"].getCreatePath(),body:JSON.stringify({name:apiKeyNameInput.value,policy_id:policyIdInput.value})});if(res.error){throw res.error}policyIdInput.clear();apiKeyNameInput.clear();setIsLoading(false);onSuccess(res.data.item.id);notifications.toasts.addSuccess(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.newEnrollmentKey.keyCreatedToasts",{defaultMessage:"Enrollment token created."}))}catch(err){notifications.toasts.addError(err,{title:"Error"});setIsLoading(false)}};return{isLoading:isLoading,onSubmit:onSubmit,policyIdInput:policyIdInput,apiKeyNameInput:apiKeyNameInput}}const NewEnrollmentTokenFlyout=({onClose:onClose,agentPolicies:agentPolicies=[]})=>{var _agentPolicies$find;const policyIdDefaultValue=(_agentPolicies$find=agentPolicies.find(agentPolicy=>agentPolicy.is_default))===null||_agentPolicies$find===void 0?void 0:_agentPolicies$find.id;const form=useCreateApiKeyForm(policyIdDefaultValue,()=>{onClose()});const body=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement("form",{onSubmit:form.onSubmit},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.newEnrollmentKey.nameLabel",{defaultMessage:"Name"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],new_enrollment_key_flyout_extends({required:true,name:"name",autoComplete:"off"},form.apiKeyNameInput.props))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.newEnrollmentKey.policyLabel",{defaultMessage:"Policy"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],new_enrollment_key_flyout_extends({required:true,defaultValue:policyIdDefaultValue},form.policyIdInput.props,{options:agentPolicies.map(agentPolicy=>({value:agentPolicy.id,text:agentPolicy.name}))}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"submit",fill:true,isLoading:form.isLoading},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.newEnrollmentKey.submitButton",defaultMessage:"Create enrollment token"}))));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:onClose,size:"l",maxWidth:640},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true,"aria-labelledby":"FleetNewEnrollmentKeyFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",{id:"FleetNewEnrollmentKeyFlyoutTitle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.newEnrollmentKey.flyoutTitle",defaultMessage:"Create enrollment token"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,body),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:onClose,flush:"left"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.newEnrollmentKey.cancelButtonLabel",defaultMessage:"Cancel"}))))))};const ConfirmEnrollmentTokenDelete=props=>{const{onCancel:onCancel,onConfirm:onConfirm,enrollmentKey:enrollmentKey}=props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokenDeleteModal.title",{defaultMessage:"Revoke enrollment token"}),onCancel:onCancel,onConfirm:onConfirm,cancelButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokenDeleteModal.cancelButton",{defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokenDeleteModal.deleteButton",{defaultMessage:"Revoke enrollment token"}),defaultFocusedButton:"confirm",buttonColor:"danger"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokenDeleteModal.description",{defaultMessage:"Are your sure you want to revoke {keyName}? New agents will no longer be able to be enrolled using this token.",values:{keyName:enrollmentKey.name}}),color:"danger"}))};function enrollment_token_list_page_extends(){enrollment_token_list_page_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return enrollment_token_list_page_extends.apply(this,arguments)}const ApiKeyField=({apiKeyId:apiKeyId})=>{const{notifications:notifications}=Object(hooks["mb"])();const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])("HIDDEN");const[key,setKey]=Object(external_kbnSharedDeps_React_["useState"])();const toggleKey=async()=>{if(state==="VISIBLE"){setState("HIDDEN")}else if(state==="HIDDEN"){try{var _res$data;setState("LOADING");const res=await Object(hooks["q"])(apiKeyId);if(res.error){throw res.error}setKey((_res$data=res.data)===null||_res$data===void 0?void 0:_res$data.item.api_key);setState("VISIBLE")}catch(err){notifications.toasts.addError(err,{title:"Error"});setState("HIDDEN")}}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},state==="VISIBLE"?key:"•••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••••")),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:state==="VISIBLE"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":state==="VISIBLE"?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),color:"text",isDisabled:state==="LOADING",onClick:toggleKey,iconType:state==="VISIBLE"?"eyeClosed":"eye"}))))};const DeleteButton=({apiKey:apiKey,refresh:refresh})=>{const{notifications:notifications}=Object(hooks["mb"])();const[state,setState]=Object(external_kbnSharedDeps_React_["useState"])("CONFIRM_HIDDEN");const onCancel=()=>setState("CONFIRM_HIDDEN");const onConfirm=async()=>{try{const res=await Object(hooks["i"])(apiKey.id);if(res.error){throw res.error}}catch(err){notifications.toasts.addError(err,{title:"Error"})}setState("CONFIRM_HIDDEN");refresh()};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,state==="CONFIRM_VISIBLE"&&external_kbnSharedDeps_React_default.a.createElement(ConfirmEnrollmentTokenDelete,{enrollmentKey:apiKey,onCancel:onCancel,onConfirm:onConfirm}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),onClick:()=>setState("CONFIRM_VISIBLE"),iconType:"trash",color:"danger"})))};const EnrollmentTokenListPage=()=>{var _enrollmentAPIKeysReq,_enrollmentAPIKeysReq2,_enrollmentAPIKeysReq3,_enrollmentAPIKeysReq4;Object(hooks["J"])("fleet_enrollment_tokens");const config=Object(hooks["M"])();const[flyoutOpen,setFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const[search,setSearch]=Object(external_kbnSharedDeps_React_["useState"])("");const{pagination:pagination,setPagination:setPagination,pageSizeOptions:pageSizeOptions}=Object(hooks["jb"])();const enrollmentAPIKeysRequest=Object(hooks["S"])({page:pagination.currentPage,perPage:pagination.pageSize,kuery:search.trim()!==""?search:undefined});const agentPoliciesRequest=Object(hooks["O"])({page:1,perPage:1e3});const agentPolicies=agentPoliciesRequest.data?agentPoliciesRequest.data.items:[];const total=(_enrollmentAPIKeysReq=enrollmentAPIKeysRequest===null||enrollmentAPIKeysRequest===void 0?void 0:(_enrollmentAPIKeysReq2=enrollmentAPIKeysRequest.data)===null||_enrollmentAPIKeysReq2===void 0?void 0:_enrollmentAPIKeysReq2.total)!==null&&_enrollmentAPIKeysReq!==void 0?_enrollmentAPIKeysReq:0;const items=(_enrollmentAPIKeysReq3=enrollmentAPIKeysRequest===null||enrollmentAPIKeysRequest===void 0?void 0:(_enrollmentAPIKeysReq4=enrollmentAPIKeysRequest.data)===null||_enrollmentAPIKeysReq4===void 0?void 0:_enrollmentAPIKeysReq4.list)!==null&&_enrollmentAPIKeysReq3!==void 0?_enrollmentAPIKeysReq3:[];const columns=[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.nameTitle",{defaultMessage:"Name"}),render:value=>external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textTruncate",title:value},value)},{field:"id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.secretTitle",{defaultMessage:"Secret"}),width:"215px",render:apiKeyId=>external_kbnSharedDeps_React_default.a.createElement(ApiKeyField,{apiKeyId:apiKeyId})},{field:"policy_id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.policyTitle",{defaultMessage:"Agent policy"}),render:policyId=>{const agentPolicy=agentPolicies.find(c=>c.id===policyId);const value=agentPolicy?agentPolicy.name:policyId;return external_kbnSharedDeps_React_default.a.createElement("span",{className:"eui-textTruncate",title:value},value)}},{field:"created_at",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.createdAtTitle",{defaultMessage:"Created on"}),width:"150px",render:createdAt=>createdAt?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedDate"],{year:"numeric",month:"short",day:"2-digit",value:createdAt}):null},{field:"active",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.activeTitle",{defaultMessage:"Active"}),width:"70px",align:"center",render:active=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{size:"m",color:active?"success":"danger",type:"dot"})},{field:"actions",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.enrollmentTokensList.actionsTitle",{defaultMessage:"Actions"}),width:"70px",render:(_,apiKey)=>apiKey.active&&external_kbnSharedDeps_React_default.a.createElement(DeleteButton,{apiKey:apiKey,refresh:()=>enrollmentAPIKeysRequest.resendRequest()})}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,flyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(NewEnrollmentTokenFlyout,{agentPolicies:agentPolicies,onClose:()=>{setFlyoutOpen(false);enrollmentAPIKeysRequest.resendRequest()}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentTokensList.pageDescription",defaultMessage:"Create and revoke enrollment tokens. An enrollment token enables one or more agents to enroll in Fleet and send data."})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(SearchBar,enrollment_token_list_page_extends({value:search,onChange:newSearch=>{setPagination({...pagination,currentPage:1});setSearch(newSearch)}},config.agents.fleetServerEnabled?{indexPattern:constants["f"]}:{fieldPrefix:constants["g"]}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{iconType:"plusInCircle",onClick:()=>setFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollmentTokensList.newKeyButton",defaultMessage:"Create enrollment token"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{loading:enrollmentAPIKeysRequest.isLoading&&enrollmentAPIKeysRequest.isInitialRequest,hasActions:true,noItemsMessage:enrollmentAPIKeysRequest.isLoading&&enrollmentAPIKeysRequest.isInitialRequest?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollemntAPIKeyList.loadingTokensMessage",defaultMessage:"Loading enrollment tokens..."}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.enrollemntAPIKeyList.emptyMessage",defaultMessage:"No enrollment tokens found."}),items:total?items:[],itemId:"id",columns:columns,pagination:{pageIndex:pagination.currentPage-1,pageSize:pagination.pageSize,totalItemCount:total,pageSizeOptions:pageSizeOptions},onChange:({page:page})=>{const newPagination={...pagination,currentPage:page.index+1,pageSize:page.size};setPagination(newPagination)}}))};const ListLayout=({children:children})=>{const{getHref:getHref}=Object(hooks["hb"])();const hasWriteCapabilites=Object(hooks["K"])().write;const[isEnrollmentFlyoutOpen,setIsEnrollmentFlyoutOpen]=external_kbnSharedDeps_React_default.a.useState(false);const headerRightColumn=hasWriteCapabilites?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"plusInCircle",onClick:()=>setIsEnrollmentFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentList.enrollButton",defaultMessage:"Add agent"})))):undefined;const headerLeftColumn=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agents.pageTitle",defaultMessage:"Agents"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agents.pageSubtitle",defaultMessage:"Manage and deploy policy updates to a group of agents of any size."})))));const agentPoliciesRequest=Object(hooks["O"])({page:1,perPage:1e3});const agentPolicies=agentPoliciesRequest.data?agentPoliciesRequest.data.items:[];const routeMatch=Object(external_kbnSharedDeps_ReactRouterDom_["useRouteMatch"])();return external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:headerLeftColumn,rightColumn:headerRightColumn,tabs:[{name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.listTabs.agentTitle",defaultMessage:"Agents"}),isSelected:routeMatch.path===constants["j"].fleet_agent_list,href:getHref("fleet_agent_list")},{name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.listTabs.enrollmentTokensTitle",defaultMessage:"Enrollment tokens"}),isSelected:routeMatch.path===constants["j"].fleet_enrollment_tokens,href:getHref("fleet_enrollment_tokens")}]},isEnrollmentFlyoutOpen?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPortal"],null,external_kbnSharedDeps_React_default.a.createElement(AgentEnrollmentFlyout,{agentPolicies:agentPolicies,onClose:()=>setIsEnrollmentFlyoutOpen(false)})):null,children)};const FleetApp=()=>{Object(hooks["J"])("fleet");const{agents:agents}=Object(hooks["M"])();const capabilities=Object(hooks["K"])();const fleetStatus=Object(hooks["N"])();if(!agents.enabled)return null;if(fleetStatus.isLoading){return external_kbnSharedDeps_React_default.a.createElement(Loading,null)}if(fleetStatus.error){return external_kbnSharedDeps_React_default.a.createElement(WithoutHeaderLayout,null,external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.agentsInitializationErrorMessageTitle",defaultMessage:"Unable to initialize central management for Elastic Agents"}),error:fleetStatus.error}))}if(fleetStatus.isReady===false){return external_kbnSharedDeps_React_default.a.createElement(SetupPage,{missingRequirements:fleetStatus.missingRequirements||[],refresh:fleetStatus.refresh})}if(!capabilities.read){return external_kbnSharedDeps_React_default.a.createElement(NoAccessPage,null)}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["HashRouter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].fleet,exact:true,render:()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:constants["j"].fleet_agent_list})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].fleet_agent_details},external_kbnSharedDeps_React_default.a.createElement(AgentDetailsPage,null)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].fleet_agent_list},external_kbnSharedDeps_React_default.a.createElement(ListLayout,null,external_kbnSharedDeps_React_default.a.createElement(AgentListPage,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].fleet_enrollment_tokens},external_kbnSharedDeps_React_default.a.createElement(ListLayout,null,external_kbnSharedDeps_React_default.a.createElement(EnrollmentTokenListPage,null)))))};const StyledPanel=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).attrs(props=>({paddingSize:"m"})).withConfig({displayName:"StyledPanel",componentId:"sc-1s2ob2x-0"})(["header{display:flex;align-items:center;justify-content:space-between;border-bottom:1px solid ",";margin:-"," -"," ",";padding:"," ",";}h2{padding:"," 0;}"],props=>props.theme.eui.euiColorLightShade,props=>props.theme.eui.paddingSizes.m,props=>props.theme.eui.paddingSizes.m,props=>props.theme.eui.paddingSizes.m,props=>props.theme.eui.paddingSizes.s,props=>props.theme.eui.paddingSizes.m,props=>props.theme.eui.paddingSizes.xs);const OverviewPanel=({title:title,tooltip:tooltip,linkToText:linkToText,linkTo:linkTo,children:children})=>external_kbnSharedDeps_React_default.a.createElement(StyledPanel,null,external_kbnSharedDeps_React_default.a.createElement("header",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"xs",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h2",null,title))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],{content:tooltip,position:"top",type:"iInCircle",color:"subdued"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",flush:"right",href:linkTo},linkToText)),children);const OverviewStats=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiDescriptionList"]).attrs(props=>({compressed:true,textStyle:"reverse",type:"column"})).withConfig({displayName:"OverviewStats",componentId:"pe4hxx-0"})(["& > *{margin-top:"," !important;&:first-child,&:nth-child(2){margin-top:0 !important;}}"],props=>props.theme.eui.paddingSizes.s);const OverviewAgentSection=()=>{var _agentStatusRequest$d,_agentStatusRequest$d2,_agentStatusRequest$d3,_agentStatusRequest$d4,_agentStatusRequest$d5,_agentStatusRequest$d6,_agentStatusRequest$d7,_agentStatusRequest$d8,_agentStatusRequest$d9,_agentStatusRequest$d10,_agentStatusRequest$d11,_agentStatusRequest$d12;const{getHref:getHref}=Object(hooks["hb"])();const agentStatusRequest=Object(hooks["P"])({});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{component:"section"},external_kbnSharedDeps_React_default.a.createElement(OverviewPanel,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageAgentsPanelTitle",{defaultMessage:"Agents"}),tooltip:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageFleetPanelTooltip",{defaultMessage:"Use Fleet to enroll agents and manage their policies from a central location."}),linkTo:getHref("fleet_agent_list"),linkToText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageFleetPanelAction",{defaultMessage:"View agents"})},external_kbnSharedDeps_React_default.a.createElement(OverviewStats,null,agentStatusRequest.isLoading?external_kbnSharedDeps_React_default.a.createElement(loading_Loading,null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewAgentTotalTitle",defaultMessage:"Total agents"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:(_agentStatusRequest$d=(_agentStatusRequest$d2=agentStatusRequest.data)===null||_agentStatusRequest$d2===void 0?void 0:(_agentStatusRequest$d3=_agentStatusRequest$d2.results)===null||_agentStatusRequest$d3===void 0?void 0:_agentStatusRequest$d3.total)!==null&&_agentStatusRequest$d!==void 0?_agentStatusRequest$d:0})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewAgentActiveTitle",defaultMessage:"Active"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:(_agentStatusRequest$d4=(_agentStatusRequest$d5=agentStatusRequest.data)===null||_agentStatusRequest$d5===void 0?void 0:(_agentStatusRequest$d6=_agentStatusRequest$d5.results)===null||_agentStatusRequest$d6===void 0?void 0:_agentStatusRequest$d6.online)!==null&&_agentStatusRequest$d4!==void 0?_agentStatusRequest$d4:0})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewAgentOfflineTitle",defaultMessage:"Offline"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:(_agentStatusRequest$d7=(_agentStatusRequest$d8=agentStatusRequest.data)===null||_agentStatusRequest$d8===void 0?void 0:(_agentStatusRequest$d9=_agentStatusRequest$d8.results)===null||_agentStatusRequest$d9===void 0?void 0:_agentStatusRequest$d9.offline)!==null&&_agentStatusRequest$d7!==void 0?_agentStatusRequest$d7:0})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewAgentErrorTitle",defaultMessage:"Error"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:(_agentStatusRequest$d10=(_agentStatusRequest$d11=agentStatusRequest.data)===null||_agentStatusRequest$d11===void 0?void 0:(_agentStatusRequest$d12=_agentStatusRequest$d11.results)===null||_agentStatusRequest$d12===void 0?void 0:_agentStatusRequest$d12.error)!==null&&_agentStatusRequest$d10!==void 0?_agentStatusRequest$d10:0}))))))};const OverviewPolicySection=({agentPolicies:agentPolicies})=>{var _packagePoliciesReque,_packagePoliciesReque2;const{getHref:getHref}=Object(hooks["hb"])();const packagePoliciesRequest=Object(hooks["Z"])({page:1,perPage:constants["l"]});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{component:"section"},external_kbnSharedDeps_React_default.a.createElement(OverviewPanel,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPagePoliciesPanelTitle",{defaultMessage:"Agent policies"}),tooltip:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPagePoliciesPanelTooltip",{defaultMessage:"Use agent policies to control the data that your agents collect."}),linkTo:getHref("policies_list"),linkToText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPagePoliciesPanelAction",{defaultMessage:"View policies"})},external_kbnSharedDeps_React_default.a.createElement(OverviewStats,null,packagePoliciesRequest.isLoading?external_kbnSharedDeps_React_default.a.createElement(loading_Loading,null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewPolicyTotalTitle",defaultMessage:"Total available"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:agentPolicies.length})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewPackagePolicyTitle",defaultMessage:"Used integrations"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:(_packagePoliciesReque=(_packagePoliciesReque2=packagePoliciesRequest.data)===null||_packagePoliciesReque2===void 0?void 0:_packagePoliciesReque2.total)!==null&&_packagePoliciesReque!==void 0?_packagePoliciesReque:0}))))))};const OverviewIntegrationSection=()=>{var _packagesRequest$data,_res$length,_res$filter$length,_res$filter,_res$filter$length2,_res$filter2;const{getHref:getHref}=Object(hooks["hb"])();const packagesRequest=Object(hooks["bb"])();const res=(_packagesRequest$data=packagesRequest.data)===null||_packagesRequest$data===void 0?void 0:_packagesRequest$data.response;const total=(_res$length=res===null||res===void 0?void 0:res.length)!==null&&_res$length!==void 0?_res$length:0;const installed=(_res$filter$length=res===null||res===void 0?void 0:(_res$filter=res.filter(p=>p.status===common_constants["ib"].Installed))===null||_res$filter===void 0?void 0:_res$filter.length)!==null&&_res$filter$length!==void 0?_res$filter$length:0;const updatablePackages=(_res$filter$length2=res===null||res===void 0?void 0:(_res$filter2=res.filter(item=>"savedObject"in item&&item.version>item.savedObject.attributes.version))===null||_res$filter2===void 0?void 0:_res$filter2.length)!==null&&_res$filter$length2!==void 0?_res$filter$length2:0;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{component:"section"},external_kbnSharedDeps_React_default.a.createElement(OverviewPanel,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageIntegrationsPanelTitle",{defaultMessage:"Integrations"}),tooltip:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageIntegrationsPanelTooltip",{defaultMessage:"Browse and install integrations for the Elastic Stack. Add integrations to your agent policies to start sending data."}),linkTo:getHref("integrations_all"),linkToText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageIntegrationsPanelAction",{defaultMessage:"View integrations"})},external_kbnSharedDeps_React_default.a.createElement(OverviewStats,null,packagesRequest.isLoading?external_kbnSharedDeps_React_default.a.createElement(loading_Loading,null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewIntegrationsTotalTitle",defaultMessage:"Total available"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:total})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewIntegrationsInstalledTitle",defaultMessage:"Installed"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:installed})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewIntegrationsUpdatesAvailableTitle",defaultMessage:"Updates available"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:updatablePackages}))))))};const OverviewDatastreamSection=()=>{var _datastreamRequest$da,_datastreamRequest$da2,_datastreamRequest$da3;const{getHref:getHref}=Object(hooks["hb"])();const datastreamRequest=Object(hooks["R"])();const{data:{fieldFormats:fieldFormats}}=Object(hooks["mb"])();const total=(_datastreamRequest$da=(_datastreamRequest$da2=datastreamRequest.data)===null||_datastreamRequest$da2===void 0?void 0:(_datastreamRequest$da3=_datastreamRequest$da2.data_streams)===null||_datastreamRequest$da3===void 0?void 0:_datastreamRequest$da3.length)!==null&&_datastreamRequest$da!==void 0?_datastreamRequest$da:0;let sizeBytes=0;const namespaces=new Set;if(datastreamRequest.data){datastreamRequest.data.data_streams.forEach(val=>{namespaces.add(val.namespace);sizeBytes+=val.size_in_bytes})}let size;try{const formatter=fieldFormats.getInstance("bytes");size=formatter.convert(sizeBytes)}catch(e){size=`${sizeBytes}b`}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{component:"section"},external_kbnSharedDeps_React_default.a.createElement(OverviewPanel,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageDataStreamsPanelTitle",{defaultMessage:"Data streams"}),tooltip:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageDataStreamsPanelTooltip",{defaultMessage:"Data that your agents collect are organized into various data streams."}),linkTo:getHref("data_streams"),linkToText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.overviewPageDataStreamsPanelAction",{defaultMessage:"View data streams"})},external_kbnSharedDeps_React_default.a.createElement(OverviewStats,null,datastreamRequest.isLoading?external_kbnSharedDeps_React_default.a.createElement(loading_Loading,null):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewDatastreamTotalTitle",defaultMessage:"Data streams"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:total})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewDatastreamNamespacesTitle",defaultMessage:"Namespaces"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiI18nNumber"],{value:namespaces.size})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewDatastreamSizeTitle",defaultMessage:"Total size"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiDescriptionListDescription"],null,size)))))};const IngestManagerOverview=()=>{Object(hooks["J"])("overview");const[isEnrollmentFlyoutOpen,setIsEnrollmentFlyoutOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const agentPoliciesRequest=Object(hooks["O"])({page:1,perPage:1e3});const agentPolicies=agentPoliciesRequest.data?agentPoliciesRequest.data.items:[];return external_kbnSharedDeps_React_default.a.createElement(WithHeaderLayout,{leftColumn:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{responsive:false,gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"l"},external_kbnSharedDeps_React_default.a.createElement("h1",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewPageTitle",defaultMessage:"Fleet"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.betaBadge.labelText",{defaultMessage:"Beta"}),tooltipContent:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.betaBadge.tooltipText",{defaultMessage:"This plugin is not recommended for production environments. Please report bugs in our Discuss forum."})})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewPageSubtitle",defaultMessage:"Manage Elastic Agents and their policies in a central location."}))))),rightColumn:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,iconType:"plusInCircle",onClick:()=>setIsEnrollmentFlyoutOpen(true)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.overviewPageEnrollAgentButton",defaultMessage:"Add agent"}))))},isEnrollmentFlyoutOpen&&external_kbnSharedDeps_React_default.a.createElement(AgentEnrollmentFlyout,{agentPolicies:agentPolicies,onClose:()=>setIsEnrollmentFlyoutOpen(false)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{gutterSize:"l",columns:2},external_kbnSharedDeps_React_default.a.createElement(OverviewIntegrationSection,null),external_kbnSharedDeps_React_default.a.createElement(OverviewPolicySection,{agentPolicies:agentPolicies}),external_kbnSharedDeps_React_default.a.createElement(OverviewAgentSection,null),external_kbnSharedDeps_React_default.a.createElement(OverviewDatastreamSection,null)))};var common_=__webpack_require__(105);const ErrorLayout=({children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(DefaultLayout,{showSettings:false},external_kbnSharedDeps_React_default.a.createElement(WithoutHeaderLayout,null,children)));const app_Panel=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).withConfig({displayName:"Panel",componentId:"sc-11e0awm-0"})(["max-width:500px;margin-right:auto;margin-left:auto;"]);const WithPermissionsAndSetup=Object(external_kbnSharedDeps_React_["memo"])(({children:children})=>{Object(hooks["J"])("base");const[isPermissionsLoading,setIsPermissionsLoading]=Object(external_kbnSharedDeps_React_["useState"])(false);const[permissionsError,setPermissionsError]=Object(external_kbnSharedDeps_React_["useState"])();const[isInitialized,setIsInitialized]=Object(external_kbnSharedDeps_React_["useState"])(false);const[initializationError,setInitializationError]=Object(external_kbnSharedDeps_React_["useState"])(null);Object(external_kbnSharedDeps_React_["useEffect"])(()=>{(async()=>{setIsPermissionsLoading(false);setPermissionsError(undefined);setIsInitialized(false);setInitializationError(null);try{var _permissionsResponse$;setIsPermissionsLoading(true);const permissionsResponse=await Object(hooks["t"])();setIsPermissionsLoading(false);if((_permissionsResponse$=permissionsResponse.data)!==null&&_permissionsResponse$!==void 0&&_permissionsResponse$.success){try{const setupResponse=await Object(hooks["G"])();if(setupResponse.error){setInitializationError(setupResponse.error)}}catch(err){setInitializationError(err)}setIsInitialized(true)}else{var _permissionsResponse$2;setPermissionsError(((_permissionsResponse$2=permissionsResponse.data)===null||_permissionsResponse$2===void 0?void 0:_permissionsResponse$2.error)||"REQUEST_ERROR")}}catch(err){setPermissionsError("REQUEST_ERROR")}})()},[]);if(isPermissionsLoading||permissionsError){return external_kbnSharedDeps_React_default.a.createElement(ErrorLayout,null,isPermissionsLoading?external_kbnSharedDeps_React_default.a.createElement(Loading,null):permissionsError==="REQUEST_ERROR"?external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.permissionsRequestErrorMessageTitle",defaultMessage:"Unable to check permissions"}),error:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.fleet.permissionsRequestErrorMessageDescription",{defaultMessage:"There was a problem checking Fleet permissions"})}):external_kbnSharedDeps_React_default.a.createElement(app_Panel,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"securityApp",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,permissionsError==="MISSING_SUPERUSER_ROLE"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.permissionDeniedErrorTitle",defaultMessage:"Permission denied"}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.securityRequiredErrorTitle",defaultMessage:"Security is not enabled"})),body:external_kbnSharedDeps_React_default.a.createElement("p",null,permissionsError==="MISSING_SUPERUSER_ROLE"?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.permissionDeniedErrorMessage",defaultMessage:"You are not authorized to access Fleet. Fleet requires {roleName} privileges.",values:{roleName:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,"superuser")}}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.securityRequiredErrorMessage",defaultMessage:"You must enable security in Kibana and Elasticsearch to use Fleet."}))})))}if(!isInitialized||initializationError){return external_kbnSharedDeps_React_default.a.createElement(ErrorLayout,null,initializationError?external_kbnSharedDeps_React_default.a.createElement(error_Error,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.fleet.initializationErrorMessageTitle",defaultMessage:"Unable to initialize Fleet"}),error:initializationError}):external_kbnSharedDeps_React_default.a.createElement(Loading,null))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,children)});const FleetAppContext=Object(external_kbnSharedDeps_React_["memo"])(({children:children,startServices:startServices,config:config,history:history,kibanaVersion:kibanaVersion,extensions:extensions,routerHistory:routerHistory})=>{const isDarkMode=useObservable_default()(startServices.uiSettings.get$("theme:darkMode"));const[routerHistoryInstance]=Object(external_kbnSharedDeps_React_["useState"])(routerHistory||Object(node_modules_history["createHashHistory"])());return external_kbnSharedDeps_React_default.a.createElement(startServices.i18n.Context,null,external_kbnSharedDeps_React_default.a.createElement(kibanaReact_public_["KibanaContextProvider"],{services:{...startServices}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiErrorBoundary"],null,external_kbnSharedDeps_React_default.a.createElement(hooks["a"].Provider,{value:config},external_kbnSharedDeps_React_default.a.createElement(hooks["c"].Provider,{value:kibanaVersion},external_kbnSharedDeps_React_default.a.createElement(common_["EuiThemeProvider"],{darkMode:isDarkMode},external_kbnSharedDeps_React_default.a.createElement(UIExtensionsContext.Provider,{value:extensions},external_kbnSharedDeps_React_default.a.createElement(hooks["b"],null,external_kbnSharedDeps_React_default.a.createElement(IntraAppStateProvider,{kibanaScopedHistory:history},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:routerHistoryInstance},external_kbnSharedDeps_React_default.a.createElement(epm_hooks["a"],{notifications:startServices.notifications},children)))))))))))});const AppRoutes=Object(external_kbnSharedDeps_React_["memo"])(()=>{const{agents:agents}=Object(hooks["M"])();return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].integrations},external_kbnSharedDeps_React_default.a.createElement(DefaultLayout,{section:"epm"},external_kbnSharedDeps_React_default.a.createElement(EPMApp,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].policies},external_kbnSharedDeps_React_default.a.createElement(DefaultLayout,{section:"agent_policy"},external_kbnSharedDeps_React_default.a.createElement(AgentPolicyApp,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:constants["j"].data_streams},external_kbnSharedDeps_React_default.a.createElement(DefaultLayout,{section:"data_stream"},external_kbnSharedDeps_React_default.a.createElement(DataStreamApp,null))),external_kbnSharedDeps_React_default.a.createElement(ProtectedRoute,{path:constants["j"].fleet,isAllowed:agents.enabled},external_kbnSharedDeps_React_default.a.createElement(DefaultLayout,{section:"fleet"},external_kbnSharedDeps_React_default.a.createElement(FleetApp,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{exact:true,path:constants["j"].overview},external_kbnSharedDeps_React_default.a.createElement(DefaultLayout,{section:"overview"},external_kbnSharedDeps_React_default.a.createElement(IngestManagerOverview,null))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/"}))});const ProtectedRoute=({isAllowed:isAllowed=false,restrictedPath:restrictedPath="/",...routeProps})=>isAllowed?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],routeProps):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:{pathname:restrictedPath}});const fleet_FleetApp=({basepath:basepath,startServices:startServices,config:config,history:history,kibanaVersion:kibanaVersion,extensions:extensions})=>external_kbnSharedDeps_React_default.a.createElement(FleetAppContext,{basepath:basepath,startServices:startServices,config:config,history:history,kibanaVersion:kibanaVersion,extensions:extensions},external_kbnSharedDeps_React_default.a.createElement(WithPermissionsAndSetup,null,external_kbnSharedDeps_React_default.a.createElement(AppRoutes,null)));function renderApp(startServices,{element:element,appBasePath:appBasePath,history:history},config,kibanaVersion,extensions){external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(fleet_FleetApp,{basepath:appBasePath,startServices:startServices,config:config,history:history,kibanaVersion:kibanaVersion,extensions:extensions}),element);return()=>{external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(element)}}const teardownFleet=coreStart=>{coreStart.chrome.docTitle.reset();coreStart.chrome.setBreadcrumbs([]);hooks["d"].stop()}}])]);