/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["enterpriseSearch_bundle_jsonpfunction"]=window["enterpriseSearch_bundle_jsonpfunction"]||[]).push([[3],{101:function(module,exports,__webpack_require__){"use strict";const strictUriEncode=__webpack_require__(338);const decodeComponent=__webpack_require__(339);const splitOnFirst=__webpack_require__(340);const isNullOrUndefined=value=>value===null||value===undefined;function encoderForArrayFormat(options){switch(options.arrayFormat){case"index":return key=>(result,value)=>{const index=result.length;if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[",index,"]"].join("")]}return[...result,[encode(key,options),"[",encode(index,options),"]=",encode(value,options)].join("")]};case"bracket":return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[]"].join("")]}return[...result,[encode(key,options),"[]=",encode(value,options)].join("")]};case"comma":case"separator":return key=>(result,value)=>{if(value===null||value===undefined||value.length===0){return result}if(result.length===0){return[[encode(key,options),"=",encode(value,options)].join("")]}return[[result,encode(value,options)].join(options.arrayFormatSeparator)]};default:return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,encode(key,options)]}return[...result,[encode(key,options),"=",encode(value,options)].join("")]}}}function parserForArrayFormat(options){let result;switch(options.arrayFormat){case"index":return(key,value,accumulator)=>{result=/\[(\d*)\]$/.exec(key);key=key.replace(/\[\d*\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]={}}accumulator[key][result[1]]=value};case"bracket":return(key,value,accumulator)=>{result=/(\[\])$/.exec(key);key=key.replace(/\[\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]=[value];return}accumulator[key]=[].concat(accumulator[key],value)};case"comma":case"separator":return(key,value,accumulator)=>{const isArray=typeof value==="string"&&value.split("").indexOf(options.arrayFormatSeparator)>-1;const newValue=isArray?value.split(options.arrayFormatSeparator).map(item=>decode(item,options)):value===null?value:decode(value,options);accumulator[key]=newValue};default:return(key,value,accumulator)=>{if(accumulator[key]===undefined){accumulator[key]=value;return}accumulator[key]=[].concat(accumulator[key],value)}}}function validateArrayFormatSeparator(value){if(typeof value!=="string"||value.length!==1){throw new TypeError("arrayFormatSeparator must be single character string")}}function encode(value,options){if(options.encode){return options.strict?strictUriEncode(value):encodeURIComponent(value)}return value}function decode(value,options){if(options.decode){return decodeComponent(value)}return value}function keysSorter(input){if(Array.isArray(input)){return input.sort()}if(typeof input==="object"){return keysSorter(Object.keys(input)).sort((a,b)=>Number(a)-Number(b)).map(key=>input[key])}return input}function removeHash(input){const hashStart=input.indexOf("#");if(hashStart!==-1){input=input.slice(0,hashStart)}return input}function getHash(url){let hash="";const hashStart=url.indexOf("#");if(hashStart!==-1){hash=url.slice(hashStart)}return hash}function extract(input){input=removeHash(input);const queryStart=input.indexOf("?");if(queryStart===-1){return""}return input.slice(queryStart+1)}function parseValue(value,options){if(options.parseNumbers&&!Number.isNaN(Number(value))&&(typeof value==="string"&&value.trim()!=="")){value=Number(value)}else if(options.parseBooleans&&value!==null&&(value.toLowerCase()==="true"||value.toLowerCase()==="false")){value=value.toLowerCase()==="true"}return value}function parse(input,options){options=Object.assign({decode:true,sort:true,arrayFormat:"none",arrayFormatSeparator:",",parseNumbers:false,parseBooleans:false},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const formatter=parserForArrayFormat(options);const ret=Object.create(null);if(typeof input!=="string"){return ret}input=input.trim().replace(/^[?#&]/,"");if(!input){return ret}for(const param of input.split("&")){let[key,value]=splitOnFirst(options.decode?param.replace(/\+/g," "):param,"=");value=value===undefined?null:["comma","separator"].includes(options.arrayFormat)?value:decode(value,options);formatter(decode(key,options),value,ret)}for(const key of Object.keys(ret)){const value=ret[key];if(typeof value==="object"&&value!==null){for(const k of Object.keys(value)){value[k]=parseValue(value[k],options)}}else{ret[key]=parseValue(value,options)}}if(options.sort===false){return ret}return(options.sort===true?Object.keys(ret).sort():Object.keys(ret).sort(options.sort)).reduce((result,key)=>{const value=ret[key];if(Boolean(value)&&typeof value==="object"&&!Array.isArray(value)){result[key]=keysSorter(value)}else{result[key]=value}return result},Object.create(null))}exports.extract=extract;exports.parse=parse;exports.stringify=(object,options)=>{if(!object){return""}options=Object.assign({encode:true,strict:true,arrayFormat:"none",arrayFormatSeparator:","},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const shouldFilter=key=>options.skipNull&&isNullOrUndefined(object[key])||options.skipEmptyString&&object[key]==="";const formatter=encoderForArrayFormat(options);const objectCopy={};for(const key of Object.keys(object)){if(!shouldFilter(key)){objectCopy[key]=object[key]}}const keys=Object.keys(objectCopy);if(options.sort!==false){keys.sort(options.sort)}return keys.map(key=>{const value=object[key];if(value===undefined){return""}if(value===null){return encode(key,options)}if(Array.isArray(value)){return value.reduce(formatter(key),[]).join("&")}return encode(key,options)+"="+encode(value,options)}).filter(x=>x.length>0).join("&")};exports.parseUrl=(input,options)=>{options=Object.assign({decode:true},options);const[url,hash]=splitOnFirst(input,"#");return Object.assign({url:url.split("?")[0]||"",query:parse(extract(input),options)},options&&options.parseFragmentIdentifier&&hash?{fragmentIdentifier:decode(hash,options)}:{})};exports.stringifyUrl=(input,options)=>{options=Object.assign({encode:true,strict:true},options);const url=removeHash(input.url).split("?")[0]||"";const queryFromUrl=exports.extract(input.url);const parsedQueryFromUrl=exports.parse(queryFromUrl,{sort:false});const query=Object.assign(parsedQueryFromUrl,input.query);let queryString=exports.stringify(query,options);if(queryString){queryString=`?${queryString}`}let hash=getHash(input.url);if(input.fragmentIdentifier){hash=`#${encode(input.fragmentIdentifier,options)}`}return`${url}${queryString}${hash}`}},21:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return FlashMessages}));__webpack_require__.d(__webpack_exports__,"b",(function(){return FlashMessagesLogic}));__webpack_require__.d(__webpack_exports__,"e",(function(){return mountFlashMessagesLogic}));__webpack_require__.d(__webpack_exports__,"d",(function(){return flashAPIErrors}));__webpack_require__.d(__webpack_exports__,"i",(function(){return setSuccessMessage}));__webpack_require__.d(__webpack_exports__,"f",(function(){return setErrorMessage}));__webpack_require__.d(__webpack_exports__,"h",(function(){return setQueuedSuccessMessage}));__webpack_require__.d(__webpack_exports__,"g",(function(){return setQueuedErrorMessage}));__webpack_require__.d(__webpack_exports__,"c",(function(){return clearFlashMessages}));var external_kbnSharedDeps_React_=__webpack_require__(8);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var index_cjs=__webpack_require__(16);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(9);var kibana=__webpack_require__(27);const convertToArray=messages=>!Array.isArray(messages)?[messages]:messages;const FlashMessagesLogic=Object(index_cjs["kea"])({path:["enterprise_search","flash_messages_logic"],actions:{setFlashMessages:messages=>({messages:convertToArray(messages)}),clearFlashMessages:()=>null,setQueuedMessages:messages=>({messages:convertToArray(messages)}),clearQueuedMessages:()=>null,setHistoryListener:historyListener=>({historyListener:historyListener})},reducers:{messages:[[],{setFlashMessages:(_,{messages:messages})=>messages,clearFlashMessages:()=>[]}],queuedMessages:[[],{setQueuedMessages:(_,{messages:messages})=>messages,clearQueuedMessages:()=>[]}],historyListener:[null,{setHistoryListener:(_,{historyListener:historyListener})=>historyListener}]},events:({values:values,actions:actions})=>({afterMount:()=>{const unlisten=kibana["a"].values.history.listen(()=>{actions.clearFlashMessages();actions.setFlashMessages(values.queuedMessages);actions.clearQueuedMessages()});actions.setHistoryListener(unlisten)},beforeUnmount:()=>{const{historyListener:removeHistoryListener}=values;if(removeHistoryListener)removeHistoryListener()}})});const mountFlashMessagesLogic=()=>{const unmount=FlashMessagesLogic.mount();return unmount};const FLASH_MESSAGE_TYPES={success:{color:"success",icon:"check"},info:{color:"primary",icon:"iInCircle"},warning:{color:"warning",icon:"alert"},error:{color:"danger",icon:"cross"}};const FlashMessages=({children:children})=>{const{messages:messages}=Object(index_cjs["useValues"])(FlashMessagesLogic);if(!messages.length)return null;return external_kbnSharedDeps_React_default.a.createElement("div",{"data-test-subj":"FlashMessages"},messages.map(({type:type,message:message,description:description},index)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],{key:index},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{color:FLASH_MESSAGE_TYPES[type].color,iconType:FLASH_MESSAGE_TYPES[type].icon,title:message},description),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null))),children)};var types=__webpack_require__(69);const flashAPIErrors=(error,{isQueued:isQueued}={})=>{var _error$body,_error$body$attribute,_error$body2,_error$body3;const defaultErrorMessage="An unexpected error occurred";const errorFlashMessages=Array.isArray(error===null||error===void 0?void 0:(_error$body=error.body)===null||_error$body===void 0?void 0:(_error$body$attribute=_error$body.attributes)===null||_error$body$attribute===void 0?void 0:_error$body$attribute.errors)?error.body.attributes.errors.map(message=>({type:"error",message:message})):[{type:"error",message:(error===null||error===void 0?void 0:(_error$body2=error.body)===null||_error$body2===void 0?void 0:_error$body2.message)||defaultErrorMessage}];if(isQueued){FlashMessagesLogic.actions.setQueuedMessages(errorFlashMessages)}else{FlashMessagesLogic.actions.setFlashMessages(errorFlashMessages)}if(!(error!==null&&error!==void 0&&(_error$body3=error.body)!==null&&_error$body3!==void 0&&_error$body3.message)){throw error}};const setSuccessMessage=message=>{FlashMessagesLogic.actions.setFlashMessages({type:"success",message:message})};const setErrorMessage=message=>{FlashMessagesLogic.actions.setFlashMessages({type:"error",message:message})};const setQueuedSuccessMessage=message=>{FlashMessagesLogic.actions.setQueuedMessages({type:"success",message:message})};const setQueuedErrorMessage=message=>{FlashMessagesLogic.actions.setQueuedMessages({type:"error",message:message})};const clearFlashMessages=()=>{FlashMessagesLogic.actions.clearFlashMessages()}},28:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Loading}));var external_kbnSharedDeps_React_=__webpack_require__(8);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(9);var loading=__webpack_require__(329);const Loading=()=>external_kbnSharedDeps_React_default.a.createElement("div",{className:"enterpriseSearchLoading"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"}))},302:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(303);case"v7light":return __webpack_require__(305);case"v8dark":return __webpack_require__(307);case"v8light":return __webpack_require__(309)}},303:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(304);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},304:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLayout {\n  display: block;\n  background-color: #1D1E24;\n  min-height: calc(100vh - 98px);\n  position: relative;\n  left: 240px;\n  width: calc(100% - 240px);\n  padding: 0; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  .enterpriseSearchLayout__sideBarToggle {\n    display: none; }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n  .enterpriseSearchLayout__sideBar {\n    z-index: 4000;\n    position: fixed;\n    margin-left: -240px;\n    margin-right: 0;\n    overflow-y: auto;\n    overflow-x: hidden;\n    height: calc(100vh - 98px);\n    width: 240px;\n    background-color: #25262E;\n    box-shadow: inset -4px 0 8px -4px rgba(0, 0, 0, 0.25); }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #343741;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #343741;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #343741;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n  .enterpriseSearchLayout__body {\n    padding: 40px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__body {\n        padding: 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n  .enterpriseSearchLayout__readOnlyMode {\n    margin: -12px 0 24px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0 0 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n",""]);module.exports=exports},305:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(306);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},306:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLayout {\n  display: block;\n  background-color: #FFF;\n  min-height: calc(100vh - 98px);\n  position: relative;\n  left: 240px;\n  width: calc(100% - 240px);\n  padding: 0; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  .enterpriseSearchLayout__sideBarToggle {\n    display: none; }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n  .enterpriseSearchLayout__sideBar {\n    z-index: 4000;\n    position: fixed;\n    margin-left: -240px;\n    margin-right: 0;\n    overflow-y: auto;\n    overflow-x: hidden;\n    height: calc(100vh - 98px);\n    width: 240px;\n    background-color: #F5F7FA;\n    box-shadow: inset -4px 0 8px -4px rgba(152, 162, 179, 0.25); }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #D3DAE6;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #D3DAE6;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #D3DAE6;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n  .enterpriseSearchLayout__body {\n    padding: 40px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__body {\n        padding: 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n  .enterpriseSearchLayout__readOnlyMode {\n    margin: -12px 0 24px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0 0 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n",""]);module.exports=exports},307:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(308);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},308:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLayout {\n  display: block;\n  background-color: #1D1E24;\n  min-height: calc(100vh - 98px);\n  position: relative;\n  left: 240px;\n  width: calc(100% - 240px);\n  padding: 0; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  .enterpriseSearchLayout__sideBarToggle {\n    display: none; }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n  .enterpriseSearchLayout__sideBar {\n    z-index: 4000;\n    position: fixed;\n    margin-left: -240px;\n    margin-right: 0;\n    overflow-y: auto;\n    overflow-x: hidden;\n    height: calc(100vh - 98px);\n    width: 240px;\n    background-color: #25262E;\n    box-shadow: inset -4px 0 8px -4px rgba(0, 0, 0, 0.25); }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #343741;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #343741;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #343741;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n  .enterpriseSearchLayout__body {\n    padding: 40px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__body {\n        padding: 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n  .enterpriseSearchLayout__readOnlyMode {\n    margin: -12px 0 24px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0 0 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n",""]);module.exports=exports},309:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(310);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},31:function(module,__webpack_exports__,__webpack_require__){"use strict";var _external_url__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(42);__webpack_require__.d(__webpack_exports__,"a",(function(){return _external_url__WEBPACK_IMPORTED_MODULE_0__["a"]}));__webpack_require__.d(__webpack_exports__,"c",(function(){return _external_url__WEBPACK_IMPORTED_MODULE_0__["c"]}));__webpack_require__.d(__webpack_exports__,"b",(function(){return _external_url__WEBPACK_IMPORTED_MODULE_0__["b"]}));__webpack_require__.d(__webpack_exports__,"d",(function(){return _external_url__WEBPACK_IMPORTED_MODULE_0__["d"]}))},310:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLayout {\n  display: block;\n  background-color: #FFF;\n  min-height: calc(100vh - 98px);\n  position: relative;\n  left: 240px;\n  width: calc(100% - 240px);\n  padding: 0; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchLayout {\n      left: auto;\n      width: 100%; } }\n  .enterpriseSearchLayout__sideBarToggle {\n    display: none; }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBarToggle {\n        display: block;\n        position: absolute;\n        right: 16px;\n        top: 38px;\n        transform: translateY(-50%) scale(0.9); }\n        .enterpriseSearchLayout__sideBarToggle .euiButton {\n          min-width: 0; } }\n  .enterpriseSearchLayout__sideBar {\n    z-index: 4000;\n    position: fixed;\n    margin-left: -240px;\n    margin-right: 0;\n    overflow-y: auto;\n    overflow-x: hidden;\n    height: calc(100vh - 98px);\n    width: 240px;\n    background-color: #F5F7FA;\n    box-shadow: inset -4px 0 8px -4px rgba(0, 0, 0, 0.25); }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #D3DAE6;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #D3DAE6;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__sideBar {\n        position: relative;\n        width: 100%;\n        height: 76px;\n        margin-left: 0;\n        overflow-y: hidden;\n        border-bottom: 1px solid #D3DAE6;\n        box-shadow: none; }\n        .enterpriseSearchLayout__sideBar--isOpen {\n          height: auto;\n          overflow-y: auto; } }\n  .enterpriseSearchLayout__body {\n    padding: 40px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__body {\n        padding: 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__body {\n        padding: 16px; } }\n  .enterpriseSearchLayout__readOnlyMode {\n    margin: -12px 0 24px; }\n    @media only screen and (min-width: 768px) and (max-width: 991px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0 0 24px; } }\n    @media only screen and (max-width: 574px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n    @media only screen and (min-width: 575px) and (max-width: 767px) {\n      .enterpriseSearchLayout__readOnlyMode {\n        margin: 0; } }\n",""]);module.exports=exports},311:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(312);case"v7light":return __webpack_require__(314);case"v8dark":return __webpack_require__(316);case"v8light":return __webpack_require__(318)}},312:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(313);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},313:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);var ___CSS_LOADER_GET_URL_IMPORT___=__webpack_require__(51);var ___CSS_LOADER_URL_IMPORT_0___=__webpack_require__(80);exports=___CSS_LOADER_API_IMPORT___(false);var ___CSS_LOADER_URL_REPLACEMENT_0___=___CSS_LOADER_GET_URL_IMPORT___(___CSS_LOADER_URL_IMPORT_0___);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchProduct {\n  display: flex;\n  align-items: center;\n  padding: 20px;\n  background-image: url("+___CSS_LOADER_URL_REPLACEMENT_0___+");\n  background-repeat: no-repeat; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  .enterpriseSearchProduct__icon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    width: 40px;\n    height: 40px;\n    margin-right: 8px;\n    background-color: #1D1E24;\n    border-radius: 50%;\n    box-shadow: 0 2px 2px -1px rgba(0, 0, 0, 0.3); }\n    .enterpriseSearchProduct__icon .euiIcon {\n      width: 20px;\n      height: 20px; }\n  .enterpriseSearchProduct__title .euiText {\n    font-weight: 500; }\n\n.enterpriseSearchNavLinks__item {\n  display: block;\n  padding: 12px 20px;\n  font-size: 14px;\n  font-weight: 500;\n  line-height: 18px; }\n  .enterpriseSearchNavLinks__item--isActive {\n    background-color: rgba(255, 255, 255, 0.05); }\n  .enterpriseSearchNavLinks__item.euiLink {\n    color: #DFE5EF;\n    font-weight: 500; }\n    .enterpriseSearchNavLinks__item.euiLink:hover {\n      color: #DFE5EF; }\n    .enterpriseSearchNavLinks__item.euiLink:focus {\n      outline: solid 0 rgba(255, 255, 255, 0.05);\n      background-color: rgba(255, 255, 255, 0.05); }\n\n.enterpriseSearchNavLinks__subNav {\n  padding-left: 20px; }\n  .enterpriseSearchNavLinks__subNav .enterpriseSearchNavLinks__item {\n    margin-left: -20px;\n    padding-left: 40px; }\n",""]);module.exports=exports},314:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(315);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},315:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);var ___CSS_LOADER_GET_URL_IMPORT___=__webpack_require__(51);var ___CSS_LOADER_URL_IMPORT_0___=__webpack_require__(80);exports=___CSS_LOADER_API_IMPORT___(false);var ___CSS_LOADER_URL_REPLACEMENT_0___=___CSS_LOADER_GET_URL_IMPORT___(___CSS_LOADER_URL_IMPORT_0___);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchProduct {\n  display: flex;\n  align-items: center;\n  padding: 20px;\n  background-image: url("+___CSS_LOADER_URL_REPLACEMENT_0___+");\n  background-repeat: no-repeat; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  .enterpriseSearchProduct__icon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    width: 40px;\n    height: 40px;\n    margin-right: 8px;\n    background-color: #FFF;\n    border-radius: 50%;\n    box-shadow: 0 2px 2px -1px rgba(152, 162, 179, 0.3); }\n    .enterpriseSearchProduct__icon .euiIcon {\n      width: 20px;\n      height: 20px; }\n  .enterpriseSearchProduct__title .euiText {\n    font-weight: 500; }\n\n.enterpriseSearchNavLinks__item {\n  display: block;\n  padding: 12px 20px;\n  font-size: 14px;\n  font-weight: 500;\n  line-height: 18px; }\n  .enterpriseSearchNavLinks__item--isActive {\n    background-color: rgba(0, 0, 0, 0.05); }\n  .enterpriseSearchNavLinks__item.euiLink {\n    color: #343741;\n    font-weight: 500; }\n    .enterpriseSearchNavLinks__item.euiLink:hover {\n      color: #343741; }\n    .enterpriseSearchNavLinks__item.euiLink:focus {\n      outline: solid 0 rgba(0, 0, 0, 0.05);\n      background-color: rgba(0, 0, 0, 0.05); }\n\n.enterpriseSearchNavLinks__subNav {\n  padding-left: 20px; }\n  .enterpriseSearchNavLinks__subNav .enterpriseSearchNavLinks__item {\n    margin-left: -20px;\n    padding-left: 40px; }\n",""]);module.exports=exports},316:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(317);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},317:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);var ___CSS_LOADER_GET_URL_IMPORT___=__webpack_require__(51);var ___CSS_LOADER_URL_IMPORT_0___=__webpack_require__(80);exports=___CSS_LOADER_API_IMPORT___(false);var ___CSS_LOADER_URL_REPLACEMENT_0___=___CSS_LOADER_GET_URL_IMPORT___(___CSS_LOADER_URL_IMPORT_0___);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchProduct {\n  display: flex;\n  align-items: center;\n  padding: 20px;\n  background-image: url("+___CSS_LOADER_URL_REPLACEMENT_0___+");\n  background-repeat: no-repeat; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  .enterpriseSearchProduct__icon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    width: 40px;\n    height: 40px;\n    margin-right: 8px;\n    background-color: #1D1E24;\n    border-radius: 50%;\n    box-shadow: 0 0.8px 0.8px rgba(0, 0, 0, 0.1), 0 2.3px 2px rgba(0, 0, 0, 0.075); }\n    .enterpriseSearchProduct__icon .euiIcon {\n      width: 20px;\n      height: 20px; }\n  .enterpriseSearchProduct__title .euiText {\n    font-weight: 500; }\n\n.enterpriseSearchNavLinks__item {\n  display: block;\n  padding: 12px 20px;\n  font-size: 14px;\n  font-weight: 500;\n  line-height: 16px; }\n  .enterpriseSearchNavLinks__item--isActive {\n    background-color: rgba(255, 255, 255, 0.05); }\n  .enterpriseSearchNavLinks__item.euiLink {\n    color: #DFE5EF;\n    font-weight: 500; }\n    .enterpriseSearchNavLinks__item.euiLink:hover {\n      color: #DFE5EF; }\n    .enterpriseSearchNavLinks__item.euiLink:focus {\n      outline: solid 0 rgba(255, 255, 255, 0.05);\n      background-color: rgba(255, 255, 255, 0.05); }\n\n.enterpriseSearchNavLinks__subNav {\n  padding-left: 20px; }\n  .enterpriseSearchNavLinks__subNav .enterpriseSearchNavLinks__item {\n    margin-left: -20px;\n    padding-left: 40px; }\n",""]);module.exports=exports},318:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(319);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},319:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);var ___CSS_LOADER_GET_URL_IMPORT___=__webpack_require__(51);var ___CSS_LOADER_URL_IMPORT_0___=__webpack_require__(80);exports=___CSS_LOADER_API_IMPORT___(false);var ___CSS_LOADER_URL_REPLACEMENT_0___=___CSS_LOADER_GET_URL_IMPORT___(___CSS_LOADER_URL_IMPORT_0___);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchProduct {\n  display: flex;\n  align-items: center;\n  padding: 20px;\n  background-image: url("+___CSS_LOADER_URL_REPLACEMENT_0___+");\n  background-repeat: no-repeat; }\n  @media only screen and (max-width: 574px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 575px) and (max-width: 767px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  @media only screen and (min-width: 768px) and (max-width: 991px) {\n    .enterpriseSearchProduct {\n      padding: 16px 20px; } }\n  .enterpriseSearchProduct__icon {\n    display: flex;\n    align-items: center;\n    justify-content: center;\n    width: 40px;\n    height: 40px;\n    margin-right: 8px;\n    background-color: #FFF;\n    border-radius: 50%;\n    box-shadow: 0 0.8px 0.8px rgba(0, 0, 0, 0.04), 0 2.3px 2px rgba(0, 0, 0, 0.03); }\n    .enterpriseSearchProduct__icon .euiIcon {\n      width: 20px;\n      height: 20px; }\n  .enterpriseSearchProduct__title .euiText {\n    font-weight: 500; }\n\n.enterpriseSearchNavLinks__item {\n  display: block;\n  padding: 12px 20px;\n  font-size: 14px;\n  font-weight: 500;\n  line-height: 16px; }\n  .enterpriseSearchNavLinks__item--isActive {\n    background-color: rgba(0, 0, 0, 0.05); }\n  .enterpriseSearchNavLinks__item.euiLink {\n    color: #343741;\n    font-weight: 500; }\n    .enterpriseSearchNavLinks__item.euiLink:hover {\n      color: #343741; }\n    .enterpriseSearchNavLinks__item.euiLink:focus {\n      outline: solid 0 rgba(0, 0, 0, 0.05);\n      background-color: rgba(0, 0, 0, 0.05); }\n\n.enterpriseSearchNavLinks__subNav {\n  padding-left: 20px; }\n  .enterpriseSearchNavLinks__subNav .enterpriseSearchNavLinks__item {\n    margin-left: -20px;\n    padding-left: 40px; }\n",""]);module.exports=exports},320:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(321);case"v7light":return __webpack_require__(323);case"v8dark":return __webpack_require__(325);case"v8light":return __webpack_require__(327)}},321:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(322);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},322:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.logo404 {\n  width: 128px;\n  height: 128px;\n  fill: #1D1E24;\n  stroke: #343741; }\n  .logo404__light {\n    fill: #343741; }\n  .logo404__dark {\n    fill: #535966; }\n",""]);module.exports=exports},323:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(324);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},324:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.logo404 {\n  width: 128px;\n  height: 128px;\n  fill: #FFF;\n  stroke: #D3DAE6; }\n  .logo404__light {\n    fill: #D3DAE6; }\n  .logo404__dark {\n    fill: #98A2B3; }\n",""]);module.exports=exports},325:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(326);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},326:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.logo404 {\n  width: 128px;\n  height: 128px;\n  fill: #1D1E24;\n  stroke: #343741; }\n  .logo404__light {\n    fill: #343741; }\n  .logo404__dark {\n    fill: #535966; }\n",""]);module.exports=exports},327:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(328);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},328:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.logo404 {\n  width: 128px;\n  height: 128px;\n  fill: #FFF;\n  stroke: #D3DAE6; }\n  .logo404__light {\n    fill: #D3DAE6; }\n  .logo404__dark {\n    fill: #98A2B3; }\n",""]);module.exports=exports},329:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(330);case"v7light":return __webpack_require__(332);case"v8dark":return __webpack_require__(334);case"v8light":return __webpack_require__(336)}},33:function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;
/*!
  Copyright (c) 2017 Jed Watson.
  Licensed under the MIT License (MIT), see
  http://jedwatson.github.io/classnames
*/(function(){"use strict";var hasOwn={}.hasOwnProperty;function classNames(){var classes=[];for(var i=0;i<arguments.length;i++){var arg=arguments[i];if(!arg)continue;var argType=typeof arg;if(argType==="string"||argType==="number"){classes.push(arg)}else if(Array.isArray(arg)&&arg.length){var inner=classNames.apply(null,arg);if(inner){classes.push(inner)}}else if(argType==="object"){for(var key in arg){if(hasOwn.call(arg,key)&&arg[key]){classes.push(key)}}}}return classes.join(" ")}if(true&&module.exports){classNames.default=classNames;module.exports=classNames}else if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return classNames}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})()},330:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(331);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},331:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLoading {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%); }\n",""]);module.exports=exports},332:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(333);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},333:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLoading {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%); }\n",""]);module.exports=exports},334:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(335);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},335:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLoading {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%); }\n",""]);module.exports=exports},336:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(337);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},337:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.enterpriseSearchLoading {\n  position: absolute;\n  top: 50%;\n  left: 50%;\n  transform: translate(-50%); }\n",""]);module.exports=exports},338:function(module,exports,__webpack_require__){"use strict";module.exports=str=>encodeURIComponent(str).replace(/[!'()*]/g,x=>`%${x.charCodeAt(0).toString(16).toUpperCase()}`)},339:function(module,exports,__webpack_require__){"use strict";var token="%[a-f0-9]{2}";var singleMatcher=new RegExp(token,"gi");var multiMatcher=new RegExp("("+token+")+","gi");function decodeComponents(components,split){try{return decodeURIComponent(components.join(""))}catch(err){}if(components.length===1){return components}split=split||1;var left=components.slice(0,split);var right=components.slice(split);return Array.prototype.concat.call([],decodeComponents(left),decodeComponents(right))}function decode(input){try{return decodeURIComponent(input)}catch(err){var tokens=input.match(singleMatcher);for(var i=1;i<tokens.length;i++){input=decodeComponents(tokens,i).join("");tokens=input.match(singleMatcher)}return input}}function customDecodeURIComponent(input){var replaceMap={"%FE%FF":"��","%FF%FE":"��"};var match=multiMatcher.exec(input);while(match){try{replaceMap[match[0]]=decodeURIComponent(match[0])}catch(err){var result=decode(match[0]);if(result!==match[0]){replaceMap[match[0]]=result}}match=multiMatcher.exec(input)}replaceMap["%C2"]="�";var entries=Object.keys(replaceMap);for(var i=0;i<entries.length;i++){var key=entries[i];input=input.replace(new RegExp(key,"g"),replaceMap[key])}return input}module.exports=function(encodedURI){if(typeof encodedURI!=="string"){throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof encodedURI+"`")}try{encodedURI=encodedURI.replace(/\+/g," ");return decodeURIComponent(encodedURI)}catch(err){return customDecodeURIComponent(encodedURI)}}},340:function(module,exports,__webpack_require__){"use strict";module.exports=(string,separator)=>{if(!(typeof string==="string"&&typeof separator==="string")){throw new TypeError("Expected the arguments to be of type `string`")}if(separator===""){return[string]}const separatorIndex=string.indexOf(separator);if(separatorIndex===-1){return[string]}return[string.slice(0,separatorIndex),string.slice(separatorIndex+separator.length)]}},40:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return LicensingLogic}));__webpack_require__.d(__webpack_exports__,"b",(function(){return mountLicensingLogic}));var index_cjs=__webpack_require__(16);const LicensingLogic=Object(index_cjs["kea"])({path:["enterprise_search","licensing_logic"],actions:{setLicense:license=>license,setLicenseSubscription:licenseSubscription=>licenseSubscription},reducers:{license:[null,{setLicense:(_,license)=>license}],licenseSubscription:[null,{setLicenseSubscription:(_,licenseSubscription)=>licenseSubscription}]},selectors:{hasPlatinumLicense:[selectors=>[selectors.license],license=>{const qualifyingLicenses=["platinum","enterprise","trial"];return(license===null||license===void 0?void 0:license.isActive)&&qualifyingLicenses.includes(license===null||license===void 0?void 0:license.type)}],hasGoldLicense:[selectors=>[selectors.license],license=>{const qualifyingLicenses=["gold","platinum","enterprise","trial"];return(license===null||license===void 0?void 0:license.isActive)&&qualifyingLicenses.includes(license===null||license===void 0?void 0:license.type)}]},events:({props:props,actions:actions,values:values})=>({afterMount:()=>{const licenseSubscription=props.license$.subscribe(async license=>{actions.setLicense(license)});actions.setLicenseSubscription(licenseSubscription)},beforeUnmount:()=>{if(values.licenseSubscription)values.licenseSubscription.unsubscribe()}})});const mountLicensingLogic=props=>{LicensingLogic(props);const unmount=LicensingLogic.mount();return unmount}},42:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return externalUrl}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getEnterpriseSearchUrl}));__webpack_require__.d(__webpack_exports__,"b",(function(){return getAppSearchUrl}));__webpack_require__.d(__webpack_exports__,"d",(function(){return getWorkplaceSearchUrl}));const externalUrl={_enterpriseSearchUrl:"",get enterpriseSearchUrl(){return this._enterpriseSearchUrl},set enterpriseSearchUrl(value){if(this._enterpriseSearchUrl){return}this._enterpriseSearchUrl=value}};const getEnterpriseSearchUrl=(path="")=>externalUrl.enterpriseSearchUrl+path;const getAppSearchUrl=(path="")=>getEnterpriseSearchUrl("/as"+path);const getWorkplaceSearchUrl=(path="")=>getEnterpriseSearchUrl("/ws"+path)},60:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Layout}));__webpack_require__.d(__webpack_exports__,"b",(function(){return SideNav}));__webpack_require__.d(__webpack_exports__,"d",(function(){return SideNavLink}));__webpack_require__.d(__webpack_exports__,"c",(function(){return SideNavItem}));var external_kbnSharedDeps_React_=__webpack_require__(8);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var classnames=__webpack_require__(33);var classnames_default=__webpack_require__.n(classnames);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(9);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var layout=__webpack_require__(302);const NavContext=external_kbnSharedDeps_React_default.a.createContext({});const Layout=({children:children,navigation:navigation,restrictWidth:restrictWidth,readOnlyMode:readOnlyMode})=>{const[isNavOpen,setIsNavOpen]=Object(external_kbnSharedDeps_React_["useState"])(false);const toggleNavigation=()=>setIsNavOpen(!isNavOpen);const closeNavigation=()=>setIsNavOpen(false);const navClasses=classnames_default()("enterpriseSearchLayout__sideBar",{"enterpriseSearchLayout__sideBar--isOpen":isNavOpen});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],{className:"enterpriseSearchLayout"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageSideBar"],{className:navClasses},external_kbnSharedDeps_React_default.a.createElement("div",{className:"enterpriseSearchLayout__sideBarToggle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",iconType:isNavOpen?"arrowDown":"arrowRight",iconSide:"right","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.nav.toggleMenu",{defaultMessage:"Toggle secondary navigation"}),"aria-expanded":isNavOpen,"aria-pressed":isNavOpen,"aria-controls":"enterpriseSearchNav",onClick:toggleNavigation,"data-test-subj":"enterpriseSearchNavToggle"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.nav.menu",{defaultMessage:"Menu"}))),external_kbnSharedDeps_React_default.a.createElement(NavContext.Provider,{value:{closeNavigation:closeNavigation}},navigation)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],{className:"enterpriseSearchLayout__body",restrictWidth:restrictWidth},readOnlyMode&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{className:"enterpriseSearchLayout__readOnlyMode",color:"warning",iconType:"lock",title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.readOnlyMode.warning",{defaultMessage:"Enterprise Search is in read-only mode. You will be unable to make changes such as creating, editing, or deleting."})}),children))};var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(11);var constants=__webpack_require__(0);var strip_slashes=__webpack_require__(151);var react_router_helpers=__webpack_require__(23);var side_nav=__webpack_require__(311);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const SideNav=({product:product,children:children})=>external_kbnSharedDeps_React_default.a.createElement("nav",{id:"enterpriseSearchNav","aria-label":external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.nav.hierarchy",{defaultMessage:"Secondary"})},external_kbnSharedDeps_React_default.a.createElement("div",{className:`enterpriseSearchProduct enterpriseSearchProduct--${product.ID}`},external_kbnSharedDeps_React_default.a.createElement("div",{className:"enterpriseSearchProduct__icon"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"logoEnterpriseSearch"})),external_kbnSharedDeps_React_default.a.createElement("div",{className:"enterpriseSearchProduct__title"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs",color:"subdued"},constants["c"].NAME),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,product.NAME)))),external_kbnSharedDeps_React_default.a.createElement("ul",{className:"enterpriseSearchNavLinks"},children));const SideNavLink=({to:to,shouldShowActiveForSubroutes:shouldShowActiveForSubroutes=false,isExternal:isExternal,children:children,className:className,isRoot:isRoot,subNav:subNav,...rest})=>{const{closeNavigation:closeNavigation}=Object(external_kbnSharedDeps_React_["useContext"])(NavContext);const{pathname:pathname}=Object(external_kbnSharedDeps_ReactRouterDom_["useLocation"])();const currentPath=Object(strip_slashes["b"])(pathname);const isActive=currentPath===to||shouldShowActiveForSubroutes&&currentPath.startsWith(to)||isRoot&&currentPath==="";const classes=classnames_default()("enterpriseSearchNavLinks__item",className,{"enterpriseSearchNavLinks__item--isActive":!isExternal&&isActive});return external_kbnSharedDeps_React_default.a.createElement("li",null,isExternal?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],_extends({},rest,{className:classes,href:to,target:"_blank",onClick:closeNavigation}),children):external_kbnSharedDeps_React_default.a.createElement(react_router_helpers["d"],_extends({},rest,{className:classes,to:to,onClick:closeNavigation}),children),subNav&&external_kbnSharedDeps_React_default.a.createElement("ul",{className:"enterpriseSearchNavLinks__subNav"},subNav))};const SideNavItem=({children:children,className:className,...rest})=>{const classes=classnames_default()("enterpriseSearchNavLinks__item",className);return external_kbnSharedDeps_React_default.a.createElement("li",_extends({},rest,{className:classes}),children)}},611:function(module,exports,__webpack_require__){switch(window.__kbnThemeTag__){case"v7dark":return __webpack_require__(612);case"v7light":return __webpack_require__(614);case"v8dark":return __webpack_require__(616);case"v8light":return __webpack_require__(618)}},612:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(613);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},613:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.truncated-content {\n  position: relative;\n  z-index: 2;\n  display: inline-block;\n  white-space: nowrap; }\n  .truncated-content__tooltip {\n    position: absolute;\n    top: 50%;\n    transform: translateY(-50%);\n    left: -3px;\n    margin-top: -1px;\n    background: #1D1E24;\n    border-radius: 2px;\n    width: calc(100% + 4px);\n    height: calc(100% + 4px);\n    padding: 0 2px;\n    display: none;\n    align-items: center;\n    box-shadow: 0 1px 3px #000;\n    border: 1px solid #343741;\n    width: auto;\n    white-space: nowrap; }\n    .truncated-content:hover .truncated-content__tooltip {\n      display: flex; }\n",""]);module.exports=exports},614:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(615);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},615:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.truncated-content {\n  position: relative;\n  z-index: 2;\n  display: inline-block;\n  white-space: nowrap; }\n  .truncated-content__tooltip {\n    position: absolute;\n    top: 50%;\n    transform: translateY(-50%);\n    left: -3px;\n    margin-top: -1px;\n    background: #FFF;\n    border-radius: 2px;\n    width: calc(100% + 4px);\n    height: calc(100% + 4px);\n    padding: 0 2px;\n    display: none;\n    align-items: center;\n    box-shadow: 0 1px 3px #000;\n    border: 1px solid #D3DAE6;\n    width: auto;\n    white-space: nowrap; }\n    .truncated-content:hover .truncated-content__tooltip {\n      display: flex; }\n",""]);module.exports=exports},616:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(617);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},617:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.truncated-content {\n  position: relative;\n  z-index: 2;\n  display: inline-block;\n  white-space: nowrap; }\n  .truncated-content__tooltip {\n    position: absolute;\n    top: 50%;\n    transform: translateY(-50%);\n    left: -3px;\n    margin-top: -1px;\n    background: #1D1E24;\n    border-radius: 2px;\n    width: calc(100% + 4px);\n    height: calc(100% + 4px);\n    padding: 0 2px;\n    display: none;\n    align-items: center;\n    box-shadow: 0 1px 3px #000;\n    border: 1px solid #343741;\n    width: auto;\n    white-space: nowrap; }\n    .truncated-content:hover .truncated-content__tooltip {\n      display: flex; }\n",""]);module.exports=exports},618:function(module,exports,__webpack_require__){var api=__webpack_require__(17);var content=__webpack_require__(619);content=content.__esModule?content.default:content;if(typeof content==="string"){content=[[module.i,content,""]]}var options={};options.insert="head";options.singleton=false;var update=api(content,options);module.exports=content.locals||{}},619:function(module,exports,__webpack_require__){var ___CSS_LOADER_API_IMPORT___=__webpack_require__(18);exports=___CSS_LOADER_API_IMPORT___(false);exports.push([module.i,"/*\n * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one\n * or more contributor license agreements. Licensed under the Elastic License\n * 2.0; you may not use this file except in compliance with the Elastic License\n * 2.0.\n */\n.truncated-content {\n  position: relative;\n  z-index: 2;\n  display: inline-block;\n  white-space: nowrap; }\n  .truncated-content__tooltip {\n    position: absolute;\n    top: 50%;\n    transform: translateY(-50%);\n    left: -3px;\n    margin-top: -1px;\n    background: #FFF;\n    border-radius: 2px;\n    width: calc(100% + 4px);\n    height: calc(100% + 4px);\n    padding: 0 2px;\n    display: none;\n    align-items: center;\n    box-shadow: 0 1px 3px #000;\n    border: 1px solid #D3DAE6;\n    width: auto;\n    white-space: nowrap; }\n    .truncated-content:hover .truncated-content__tooltip {\n      display: flex; }\n",""]);module.exports=exports},68:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return truncate}));__webpack_require__.d(__webpack_exports__,"c",(function(){return truncateBeginning}));__webpack_require__.d(__webpack_exports__,"a",(function(){return TruncatedContent}));function truncate(text,length){return`${text.substring(0,length)}…`}function truncateBeginning(text,length){return`…${text.substring(text.length-length)}`}var external_kbnSharedDeps_React_=__webpack_require__(8);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var truncated_content=__webpack_require__(611);const TruncatedContent=({content:content,length:length,beginning:beginning=false,tooltipType:tooltipType="inline"})=>{if(content.length<=length)return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,content);const inline=tooltipType==="inline";return external_kbnSharedDeps_React_default.a.createElement("span",{className:"truncated-content",title:!inline?content:""},beginning?truncateBeginning(content,length):truncate(content,length),inline&&external_kbnSharedDeps_React_default.a.createElement("span",{className:"truncated-content__tooltip"},content))}},69:function(module,exports){},80:function(module,exports){module.exports="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjQwIiBoZWlnaHQ9IjE4NSIgdmlld0JveD0iMCAwIDI0MCAxODUiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+CiAgPG1hc2sgaWQ9Im1hc2swIiBtYXNrLXR5cGU9ImFscGhhIiBtYXNrVW5pdHM9InVzZXJTcGFjZU9uVXNlIiB4PSIwIiB5PSIwIiB3aWR0aD0iMjQwIiBoZWlnaHQ9IjE4NSI+CiAgICA8cmVjdCB3aWR0aD0iMjQwIiBoZWlnaHQ9IjE4NSIgZmlsbD0iI0Y3RjhGOSIvPgogIDwvbWFzaz4KICA8ZyBtYXNrPSJ1cmwoI21hc2swKSI+CiAgICA8Y2lyY2xlIG9wYWNpdHk9IjAuMDYiIGN4PSItOCIgY3k9IjMiIHI9IjE0OSIgZmlsbD0idXJsKCNwYWludDBfbGluZWFyKSIvPgogICAgPHBhdGggZD0iTTU3IDNDNTcgMzguMzQ2MiAyNy44OTg1IDY3IC04IDY3Qy00My44OTg1IDY3IC03MyAzOC4zNDYyIC03MyAzQy03MyAtMzIuMzQ2MiAtNDMuODk4NSAtNjEgLTggLTYxQzI3Ljg5ODUgLTYxIDU3IC0zMi4zNDYyIDU3IDNaIiBmaWxsPSJ1cmwoI3BhaW50MV9saW5lYXIpIi8+CiAgICA8Y2lyY2xlIG9wYWNpdHk9IjAuMzMiIGN4PSItOCIgY3k9IjMiIHI9IjMyIiBmaWxsPSJibGFjayIvPgogICAgPGNpcmNsZSBjeD0iLTgiIGN5PSIzIiByPSIyNCIgZmlsbD0idXJsKCNwYWludDJfbGluZWFyKSIvPgogIDwvZz4KICA8ZGVmcz4KICAgIDxsaW5lYXJHcmFkaWVudCBpZD0icGFpbnQwX2xpbmVhciIgeDE9IjQ1LjUiIHkxPSItNTkuNSIgeDI9IjEwNC41IiB5Mj0iNzUiIGdyYWRpZW50VW5pdHM9InVzZXJTcGFjZU9uVXNlIj4KICAgICAgPHN0b3AvPgogICAgICA8c3RvcCBvZmZzZXQ9IjEiIHN0b3Atb3BhY2l0eT0iMCIvPgogICAgPC9saW5lYXJHcmFkaWVudD4KICAgIDxsaW5lYXJHcmFkaWVudCBpZD0icGFpbnQxX2xpbmVhciIgeDE9IjIyIiB5MT0iLTYiIHgyPSItOCIgeTI9IjY3IiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+CiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiMwMDkxODciLz4KICAgICAgPHN0b3Agb2Zmc2V0PSIxIiBzdG9wLWNvbG9yPSIjMDFCRUIyIi8+CiAgICA8L2xpbmVhckdyYWRpZW50PgogICAgPGxpbmVhckdyYWRpZW50IGlkPSJwYWludDJfbGluZWFyIiB4MT0iLTgiIHkxPSI1LjUiIHgyPSItOCIgeTI9IjI3IiBncmFkaWVudFVuaXRzPSJ1c2VyU3BhY2VPblVzZSI+CiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiNENUExMDAiLz4KICAgICAgPHN0b3Agb2Zmc2V0PSIxIiBzdG9wLWNvbG9yPSIjRkVDNTE0Ii8+CiAgICA8L2xpbmVhckdyYWRpZW50PgogIDwvZGVmcz4KPC9zdmc+Cg=="},94:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return TEXT}));__webpack_require__.d(__webpack_exports__,"a",(function(){return NUMBER}));__webpack_require__.d(__webpack_exports__,"c",(function(){return fieldTypeSelectOptions}));const TEXT="text";const NUMBER="number";const DATE="date";const GEOLOCATION="geolocation";const fieldTypeSelectOptions=[{value:TEXT,text:TEXT},{value:NUMBER,text:NUMBER},{value:DATE,text:DATE},{value:GEOLOCATION,text:GEOLOCATION}]},96:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return NotFound}));var external_kbnSharedDeps_React_=__webpack_require__(8);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var index_cjs=__webpack_require__(16);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(9);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(1);var constants=__webpack_require__(0);var kibana_chrome=__webpack_require__(25);var licensing=__webpack_require__(40);var react_router_helpers=__webpack_require__(23);var telemetry=__webpack_require__(26);const AppSearchLogo=()=>external_kbnSharedDeps_React_default.a.createElement("svg",{xmlns:"http://www.w3.org/2000/svg",width:"136",height:"136",viewBox:"0 0 136 136",className:"logo404","aria-hidden":"true"},external_kbnSharedDeps_React_default.a.createElement("rect",{x:"1",y:"1",width:"134",height:"134",rx:"67",strokeWidth:"2",strokeDasharray:"8 4"}),external_kbnSharedDeps_React_default.a.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M105.305 43.282l2.934-1.692c3.015 3.693 4.761 8.35 4.761 13.267V82.57a21 21 0 01-10.5 18.186L80 113.747V73.934c0-4.93-1.753-9.588-4.774-13.284l30.079-17.367zM66.5 55.747A21 21 0 0056 73.933v39.817l-22.5-12.993A21.001 21.001 0 0123 82.57V54.86c0-7.503 4.002-14.44 10.5-18.19l1.478-.853.022.014 33 19.05-1.5.867z",className:"logo404__light"}),external_kbnSharedDeps_React_default.a.createElement("path",{d:"M78.5 22.813a21.007 21.007 0 00-21 0L35 35.83l33 19.05 33.001-19.05-22.5-13.017z",fillRule:"evenodd",clipRule:"evenodd",className:"logo404__dark"}));const WorkplaceSearchLogo=()=>external_kbnSharedDeps_React_default.a.createElement("svg",{fill:"none",xmlns:"http://www.w3.org/2000/svg",width:"137",height:"137",viewBox:"0 0 137 137",className:"logo404","aria-hidden":"true"},external_kbnSharedDeps_React_default.a.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M136.886 72.486l-1.997-.115a67.11 67.11 0 000-7.742l1.997-.115a69.278 69.278 0 010 7.972zm-.343-11.943l-1.987.23a66.084 66.084 0 00-1.335-7.617l1.947-.46a68.478 68.478 0 011.375 7.847zm-2.404-11.696l-1.916.573a65.939 65.939 0 00-2.645-7.265l1.836-.794a67.996 67.996 0 012.725 7.486zm-4.412-11.096l-1.786.899a66.668 66.668 0 00-3.873-6.694l1.67-1.101a68.365 68.365 0 013.989 6.896zm-6.278-10.158l-1.603 1.195a66.966 66.966 0 00-4.975-5.923l1.454-1.372a68.733 68.733 0 015.124 6.1zm-7.941-8.918l-1.373 1.454a66.818 66.818 0 00-5.924-4.975l1.196-1.603a68.803 68.803 0 016.101 5.124zm-9.363-7.413l-1.101 1.67A66.34 66.34 0 0098.35 9.06l.9-1.786a68.38 68.38 0 016.895 3.99zM95.638 5.586l-.793 1.836a66 66 0 00-7.265-2.645l.573-1.916a67.995 67.995 0 017.485 2.725zM84.304 1.832l-.46 1.947a66.263 66.263 0 00-7.617-1.335l.23-1.987c2.665.309 5.284.77 7.847 1.375zM72.486.114l-.115 1.997a67.582 67.582 0 00-7.742 0L64.514.114a69.582 69.582 0 017.972 0zM60.543.457l.23 1.987c-2.588.3-5.13.747-7.617 1.335l-.46-1.947A68.267 68.267 0 0160.543.457zM48.847 2.861l.573 1.916a65.986 65.986 0 00-7.265 2.645l-.794-1.836a67.995 67.995 0 017.486-2.725zM37.75 7.273l.899 1.786a66.406 66.406 0 00-6.694 3.873l-1.101-1.67a68.42 68.42 0 016.896-3.99zM27.593 13.55l1.195 1.603a66.85 66.85 0 00-5.923 4.975l-1.372-1.454a68.853 68.853 0 016.1-5.124zm-8.918 7.941l1.454 1.373a66.866 66.866 0 00-4.975 5.924l-1.603-1.196a68.855 68.855 0 015.124-6.1zm-7.413 9.363l1.67 1.1A66.423 66.423 0 009.06 38.65l-1.786-.9a68.424 68.424 0 013.99-6.895zM5.586 41.361l1.836.794a66 66 0 00-2.645 7.265l-1.916-.573a67.995 67.995 0 012.725-7.486zM1.832 52.697l1.947.46a66.263 66.263 0 00-1.335 7.617l-1.987-.23c.309-2.665.77-5.284 1.375-7.847zM.114 64.514a69.582 69.582 0 000 7.972l1.997-.115a67.582 67.582 0 010-7.742l-1.997-.115zm.343 11.943l1.987-.23c.3 2.588.747 5.13 1.335 7.617l-1.947.46a68.267 68.267 0 01-1.375-7.847zm2.404 11.696l1.916-.573a66 66 0 002.645 7.266l-1.836.792a67.995 67.995 0 01-2.725-7.485zM7.273 99.25l1.786-.898a66.323 66.323 0 003.873 6.693l-1.67 1.101a68.378 68.378 0 01-3.99-6.895zm6.278 10.158l1.603-1.196a66.801 66.801 0 004.975 5.924l-1.454 1.373a68.803 68.803 0 01-5.124-6.101zm7.941 8.918l1.373-1.454a66.966 66.966 0 005.924 4.975l-1.196 1.603a68.734 68.734 0 01-6.1-5.124zm9.363 7.413l1.1-1.67a66.668 66.668 0 006.695 3.873l-.9 1.786a68.354 68.354 0 01-6.895-3.989zm10.506 5.676l.794-1.836a65.953 65.953 0 007.265 2.645l-.573 1.916a67.996 67.996 0 01-7.486-2.725zm11.335 3.754l.46-1.947a66.084 66.084 0 007.617 1.335l-.23 1.987a68.478 68.478 0 01-7.847-1.375zm11.818 1.718l.115-1.997a67.11 67.11 0 007.742 0l.115 1.997a69.278 69.278 0 01-7.972 0zm11.943-.343l-.23-1.987a66.084 66.084 0 007.617-1.335l.46 1.947a68.478 68.478 0 01-7.847 1.375zm11.696-2.404l-.573-1.916a65.953 65.953 0 007.266-2.645l.792 1.836a67.996 67.996 0 01-7.485 2.725zm11.096-4.412l-.898-1.786a66.584 66.584 0 006.693-3.873l1.101 1.67a68.31 68.31 0 01-6.895 3.989zm10.158-6.278l-1.196-1.603a66.918 66.918 0 005.924-4.975l1.373 1.454a68.682 68.682 0 01-6.101 5.124zm8.918-7.941l-1.454-1.373a66.918 66.918 0 004.975-5.924l1.603 1.196a68.682 68.682 0 01-5.124 6.101zm7.413-9.363l-1.67-1.101a66.584 66.584 0 003.873-6.694l1.786.9a68.31 68.31 0 01-3.989 6.895zm5.676-10.507l-1.836-.793a65.953 65.953 0 002.645-7.265l1.916.573a67.996 67.996 0 01-2.725 7.485zm3.754-11.334l-1.947-.46a66.084 66.084 0 001.335-7.617l1.987.23a68.478 68.478 0 01-1.375 7.847zM72.406 44.047c.372-.442 1-1.12 1.881-2.034 2.332-2.413 7.462-6.825 11.778-6.825h13.56v65.624H86.062c-4.313 0-8.739-3.17-11.775-6.794l-1.671-2.301 6.016-7.606c7.573-9.573 7.575-22.601.002-32.172l-6.228-7.892z",className:"logo404__light"}),external_kbnSharedDeps_React_default.a.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M38.375 100.812V35.188h12.71c3.74 0 7.328 1.719 9.596 4.593l12.808 16.232c5.683 7.181 5.683 16.839-.005 24.025L60.677 96.232c-2.269 2.868-5.852 4.58-9.582 4.58h-12.72z",className:"logo404__light"}),external_kbnSharedDeps_React_default.a.createElement("path",{fillRule:"evenodd",clipRule:"evenodd",d:"M67.653 87.447l-7.075-6.978c-6.274-7.258-6.274-17.981.005-24.767 3.357-3.585 5.711-5.946 7.065-7.083l5.84 7.083c5.77 7.405 5.634 17.471-.135 24.88l-5.703 6.863.002.002z",className:"logo404__dark"}));var logo=__webpack_require__(320);const NotFound=({product:product={},breadcrumbs:breadcrumbs})=>{const{hasGoldLicense:hasGoldLicense}=Object(index_cjs["useValues"])(licensing["a"]);const supportUrl=hasGoldLicense?constants["e"]:product.SUPPORT_URL;let Logo;let SetPageChrome;let SendTelemetry;switch(product.ID){case constants["a"].ID:Logo=AppSearchLogo;SetPageChrome=kibana_chrome["a"];SendTelemetry=telemetry["a"];break;case constants["g"].ID:Logo=WorkplaceSearchLogo;SetPageChrome=kibana_chrome["c"];SendTelemetry=telemetry["c"];break;default:return null}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(SetPageChrome,{trail:breadcrumbs}),external_kbnSharedDeps_React_default.a.createElement(SendTelemetry,{action:"error",metric:"not_found"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{title:external_kbnSharedDeps_React_default.a.createElement(Logo,null),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.notFound.title",{defaultMessage:"404 error"}))),external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.notFound.description",{defaultMessage:"The page you’re looking for was not found."}))),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(react_router_helpers["b"],{to:"/",color:"primary",fill:true},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.notFound.action1",{defaultMessage:"Back to your dashboard"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{href:supportUrl,target:"_blank"},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.enterpriseSearch.notFound.action2",{defaultMessage:"Contact support"}))))})))}}}]);