/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["canvas_bundle_jsonpfunction"]=window["canvas_bundle_jsonpfunction"]||[]).push([[1],{214:function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(237)()}},223:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ColorPickerPopover}));var external_kbnSharedDeps_React_=__webpack_require__(3);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var tinycolor=__webpack_require__(226);var tinycolor_default=__webpack_require__.n(tinycolor);const ColorDot=({value:value,children:children})=>{const tc=tinycolor_default()(value);let style={};if(tc.isValid()){style={background:value}}return external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasColorDot"},external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasColorDot__background canvasCheckered"}),external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasColorDot__foreground",style:style},children))};var components=__webpack_require__(42);const{ColorManager:strings}=components["a"];const ColorManager=({hasButtons:hasButtons=false,onAddColor:onAddColor,onChange:onChange,onRemoveColor:onRemoveColor,value:value=""})=>{const tc=tinycolor_default()(value);const validColor=tc.isValid();let buttons=null;if(hasButtons){buttons=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":strings.getAddAriaLabel(),iconType:"plusInCircle",isDisabled:!validColor||!onAddColor,onClick:()=>onAddColor&&onAddColor(value)}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonIcon"],{"aria-label":strings.getRemoveAriaLabel(),iconType:"minusInCircle",isDisabled:!validColor||!onRemoveColor,onClick:()=>onRemoveColor&&onRemoveColor(value)}))}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ColorDot,{value:validColor?value:undefined})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{style:{display:"inline-block"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{value:value,isInvalid:!validColor&&value.length>0,placeholder:strings.getCodePlaceholder(),onChange:e=>onChange(e.target.value)})),buttons)};var chroma=__webpack_require__(334);var chroma_default=__webpack_require__.n(chroma);function readableColor(background,light="#FFF",dark="#333"){try{return chroma_default.a.contrast(background,"#000")<7?light:dark}catch(e){return dark}}var Recompose=__webpack_require__(20);var external_kbnSharedDeps_Lodash_=__webpack_require__(4);const PER_ROW_DEFAULT=6;const ItemGrid=function ItemGridFunc({items:items=[],itemsPerRow:itemsPerRow=PER_ROW_DEFAULT,children:children}){const reducedRows=items.reduce((rows,item)=>{let end=Object(external_kbnSharedDeps_Lodash_["last"])(rows);if(end&&end.length>=itemsPerRow){rows.push([])}end=Object(external_kbnSharedDeps_Lodash_["last"])(rows);if(end){end.push(children(item))}return rows},[[]]);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,reducedRows.map((row,i)=>external_kbnSharedDeps_React_default.a.createElement("div",{key:`item-grid-row-${i}`,className:"item-grid-row"},row)))};const item_grid_ItemGrid=Object(Recompose["pure"])(ItemGrid);const ColorPalette=({colors:colors=[],colorsPerRow:colorsPerRow=6,onChange:onChange,value:value=""})=>{if(colors.length===0){return null}colors=colors.filter(color=>tinycolor_default()(color).isValid());return external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasColorPalette"},external_kbnSharedDeps_React_default.a.createElement(item_grid_ItemGrid,{items:colors,itemsPerRow:colorsPerRow},color=>{const match=tinycolor_default.a.equals(color,value);const icon=match?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:"check",className:"selected-color",color:readableColor(value)}):null;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{style:{fontSize:0},key:color,onClick:()=>!match&&onChange(color),className:"canvasColorPalette__dot","aria-label":tinycolor_default()(color).toName()||color},external_kbnSharedDeps_React_default.a.createElement(ColorDot,{value:color},icon))}))};const ColorPicker=({colors:colors=[],hasButtons:hasButtons=false,onAddColor:onAddColor,onChange:onChange,onRemoveColor:onRemoveColor,value:value=""})=>{const tc=tinycolor_default()(value);const isValidColor=tc.isValid();colors=colors.filter(color=>tinycolor_default()(color).isValid());let canRemove=false;let canAdd=false;if(isValidColor){const match=colors.filter(color=>tinycolor_default.a.equals(value,color));canRemove=match.length>0;canAdd=match.length===0}return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(ColorPalette,{onChange:onChange,value:value,colors:colors}),external_kbnSharedDeps_React_default.a.createElement(ColorManager,{onChange:onChange,value:value,onAddColor:canAdd?onAddColor:undefined,onRemoveColor:canRemove?onRemoveColor:undefined,hasButtons:hasButtons}))};var popover=__webpack_require__(47);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const ColorPickerPopover=props=>{const{value:value,anchorPosition:anchorPosition,ariaLabel:ariaLabel,...rest}=props;const button=handleClick=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"aria-label":`${ariaLabel} ${tinycolor_default()(value).toName()||value}`,style:{fontSize:0},onClick:handleClick},external_kbnSharedDeps_React_default.a.createElement(ColorDot,{value:value}));return external_kbnSharedDeps_React_default.a.createElement(popover["a"],{id:"color-picker-popover",panelClassName:"canvas canvasColorPickerPopover__popover",button:button,anchorPosition:anchorPosition},()=>external_kbnSharedDeps_React_default.a.createElement(ColorPicker,_extends({value:value},rest)))}},226:function(module,exports,__webpack_require__){var __WEBPACK_AMD_DEFINE_RESULT__;(function(Math){var trimLeft=/^\s+/,trimRight=/\s+$/,tinyCounter=0,mathRound=Math.round,mathMin=Math.min,mathMax=Math.max,mathRandom=Math.random;function tinycolor(color,opts){color=color?color:"";opts=opts||{};if(color instanceof tinycolor){return color}if(!(this instanceof tinycolor)){return new tinycolor(color,opts)}var rgb=inputToRGB(color);this._originalInput=color,this._r=rgb.r,this._g=rgb.g,this._b=rgb.b,this._a=rgb.a,this._roundA=mathRound(100*this._a)/100,this._format=opts.format||rgb.format;this._gradientType=opts.gradientType;if(this._r<1){this._r=mathRound(this._r)}if(this._g<1){this._g=mathRound(this._g)}if(this._b<1){this._b=mathRound(this._b)}this._ok=rgb.ok;this._tc_id=tinyCounter++}tinycolor.prototype={isDark:function(){return this.getBrightness()<128},isLight:function(){return!this.isDark()},isValid:function(){return this._ok},getOriginalInput:function(){return this._originalInput},getFormat:function(){return this._format},getAlpha:function(){return this._a},getBrightness:function(){var rgb=this.toRgb();return(rgb.r*299+rgb.g*587+rgb.b*114)/1e3},getLuminance:function(){var rgb=this.toRgb();var RsRGB,GsRGB,BsRGB,R,G,B;RsRGB=rgb.r/255;GsRGB=rgb.g/255;BsRGB=rgb.b/255;if(RsRGB<=.03928){R=RsRGB/12.92}else{R=Math.pow((RsRGB+.055)/1.055,2.4)}if(GsRGB<=.03928){G=GsRGB/12.92}else{G=Math.pow((GsRGB+.055)/1.055,2.4)}if(BsRGB<=.03928){B=BsRGB/12.92}else{B=Math.pow((BsRGB+.055)/1.055,2.4)}return.2126*R+.7152*G+.0722*B},setAlpha:function(value){this._a=boundAlpha(value);this._roundA=mathRound(100*this._a)/100;return this},toHsv:function(){var hsv=rgbToHsv(this._r,this._g,this._b);return{h:hsv.h*360,s:hsv.s,v:hsv.v,a:this._a}},toHsvString:function(){var hsv=rgbToHsv(this._r,this._g,this._b);var h=mathRound(hsv.h*360),s=mathRound(hsv.s*100),v=mathRound(hsv.v*100);return this._a==1?"hsv("+h+", "+s+"%, "+v+"%)":"hsva("+h+", "+s+"%, "+v+"%, "+this._roundA+")"},toHsl:function(){var hsl=rgbToHsl(this._r,this._g,this._b);return{h:hsl.h*360,s:hsl.s,l:hsl.l,a:this._a}},toHslString:function(){var hsl=rgbToHsl(this._r,this._g,this._b);var h=mathRound(hsl.h*360),s=mathRound(hsl.s*100),l=mathRound(hsl.l*100);return this._a==1?"hsl("+h+", "+s+"%, "+l+"%)":"hsla("+h+", "+s+"%, "+l+"%, "+this._roundA+")"},toHex:function(allow3Char){return rgbToHex(this._r,this._g,this._b,allow3Char)},toHexString:function(allow3Char){return"#"+this.toHex(allow3Char)},toHex8:function(allow4Char){return rgbaToHex(this._r,this._g,this._b,this._a,allow4Char)},toHex8String:function(allow4Char){return"#"+this.toHex8(allow4Char)},toRgb:function(){return{r:mathRound(this._r),g:mathRound(this._g),b:mathRound(this._b),a:this._a}},toRgbString:function(){return this._a==1?"rgb("+mathRound(this._r)+", "+mathRound(this._g)+", "+mathRound(this._b)+")":"rgba("+mathRound(this._r)+", "+mathRound(this._g)+", "+mathRound(this._b)+", "+this._roundA+")"},toPercentageRgb:function(){return{r:mathRound(bound01(this._r,255)*100)+"%",g:mathRound(bound01(this._g,255)*100)+"%",b:mathRound(bound01(this._b,255)*100)+"%",a:this._a}},toPercentageRgbString:function(){return this._a==1?"rgb("+mathRound(bound01(this._r,255)*100)+"%, "+mathRound(bound01(this._g,255)*100)+"%, "+mathRound(bound01(this._b,255)*100)+"%)":"rgba("+mathRound(bound01(this._r,255)*100)+"%, "+mathRound(bound01(this._g,255)*100)+"%, "+mathRound(bound01(this._b,255)*100)+"%, "+this._roundA+")"},toName:function(){if(this._a===0){return"transparent"}if(this._a<1){return false}return hexNames[rgbToHex(this._r,this._g,this._b,true)]||false},toFilter:function(secondColor){var hex8String="#"+rgbaToArgbHex(this._r,this._g,this._b,this._a);var secondHex8String=hex8String;var gradientType=this._gradientType?"GradientType = 1, ":"";if(secondColor){var s=tinycolor(secondColor);secondHex8String="#"+rgbaToArgbHex(s._r,s._g,s._b,s._a)}return"progid:DXImageTransform.Microsoft.gradient("+gradientType+"startColorstr="+hex8String+",endColorstr="+secondHex8String+")"},toString:function(format){var formatSet=!!format;format=format||this._format;var formattedString=false;var hasAlpha=this._a<1&&this._a>=0;var needsAlphaFormat=!formatSet&&hasAlpha&&(format==="hex"||format==="hex6"||format==="hex3"||format==="hex4"||format==="hex8"||format==="name");if(needsAlphaFormat){if(format==="name"&&this._a===0){return this.toName()}return this.toRgbString()}if(format==="rgb"){formattedString=this.toRgbString()}if(format==="prgb"){formattedString=this.toPercentageRgbString()}if(format==="hex"||format==="hex6"){formattedString=this.toHexString()}if(format==="hex3"){formattedString=this.toHexString(true)}if(format==="hex4"){formattedString=this.toHex8String(true)}if(format==="hex8"){formattedString=this.toHex8String()}if(format==="name"){formattedString=this.toName()}if(format==="hsl"){formattedString=this.toHslString()}if(format==="hsv"){formattedString=this.toHsvString()}return formattedString||this.toHexString()},clone:function(){return tinycolor(this.toString())},_applyModification:function(fn,args){var color=fn.apply(null,[this].concat([].slice.call(args)));this._r=color._r;this._g=color._g;this._b=color._b;this.setAlpha(color._a);return this},lighten:function(){return this._applyModification(lighten,arguments)},brighten:function(){return this._applyModification(brighten,arguments)},darken:function(){return this._applyModification(darken,arguments)},desaturate:function(){return this._applyModification(desaturate,arguments)},saturate:function(){return this._applyModification(saturate,arguments)},greyscale:function(){return this._applyModification(greyscale,arguments)},spin:function(){return this._applyModification(spin,arguments)},_applyCombination:function(fn,args){return fn.apply(null,[this].concat([].slice.call(args)))},analogous:function(){return this._applyCombination(analogous,arguments)},complement:function(){return this._applyCombination(complement,arguments)},monochromatic:function(){return this._applyCombination(monochromatic,arguments)},splitcomplement:function(){return this._applyCombination(splitcomplement,arguments)},triad:function(){return this._applyCombination(triad,arguments)},tetrad:function(){return this._applyCombination(tetrad,arguments)}};tinycolor.fromRatio=function(color,opts){if(typeof color=="object"){var newColor={};for(var i in color){if(color.hasOwnProperty(i)){if(i==="a"){newColor[i]=color[i]}else{newColor[i]=convertToPercentage(color[i])}}}color=newColor}return tinycolor(color,opts)};function inputToRGB(color){var rgb={r:0,g:0,b:0};var a=1;var s=null;var v=null;var l=null;var ok=false;var format=false;if(typeof color=="string"){color=stringInputToObject(color)}if(typeof color=="object"){if(isValidCSSUnit(color.r)&&isValidCSSUnit(color.g)&&isValidCSSUnit(color.b)){rgb=rgbToRgb(color.r,color.g,color.b);ok=true;format=String(color.r).substr(-1)==="%"?"prgb":"rgb"}else if(isValidCSSUnit(color.h)&&isValidCSSUnit(color.s)&&isValidCSSUnit(color.v)){s=convertToPercentage(color.s);v=convertToPercentage(color.v);rgb=hsvToRgb(color.h,s,v);ok=true;format="hsv"}else if(isValidCSSUnit(color.h)&&isValidCSSUnit(color.s)&&isValidCSSUnit(color.l)){s=convertToPercentage(color.s);l=convertToPercentage(color.l);rgb=hslToRgb(color.h,s,l);ok=true;format="hsl"}if(color.hasOwnProperty("a")){a=color.a}}a=boundAlpha(a);return{ok:ok,format:color.format||format,r:mathMin(255,mathMax(rgb.r,0)),g:mathMin(255,mathMax(rgb.g,0)),b:mathMin(255,mathMax(rgb.b,0)),a:a}}function rgbToRgb(r,g,b){return{r:bound01(r,255)*255,g:bound01(g,255)*255,b:bound01(b,255)*255}}function rgbToHsl(r,g,b){r=bound01(r,255);g=bound01(g,255);b=bound01(b,255);var max=mathMax(r,g,b),min=mathMin(r,g,b);var h,s,l=(max+min)/2;if(max==min){h=s=0}else{var d=max-min;s=l>.5?d/(2-max-min):d/(max+min);switch(max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break}h/=6}return{h:h,s:s,l:l}}function hslToRgb(h,s,l){var r,g,b;h=bound01(h,360);s=bound01(s,100);l=bound01(l,100);function hue2rgb(p,q,t){if(t<0)t+=1;if(t>1)t-=1;if(t<1/6)return p+(q-p)*6*t;if(t<1/2)return q;if(t<2/3)return p+(q-p)*(2/3-t)*6;return p}if(s===0){r=g=b=l}else{var q=l<.5?l*(1+s):l+s-l*s;var p=2*l-q;r=hue2rgb(p,q,h+1/3);g=hue2rgb(p,q,h);b=hue2rgb(p,q,h-1/3)}return{r:r*255,g:g*255,b:b*255}}function rgbToHsv(r,g,b){r=bound01(r,255);g=bound01(g,255);b=bound01(b,255);var max=mathMax(r,g,b),min=mathMin(r,g,b);var h,s,v=max;var d=max-min;s=max===0?0:d/max;if(max==min){h=0}else{switch(max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break}h/=6}return{h:h,s:s,v:v}}function hsvToRgb(h,s,v){h=bound01(h,360)*6;s=bound01(s,100);v=bound01(v,100);var i=Math.floor(h),f=h-i,p=v*(1-s),q=v*(1-f*s),t=v*(1-(1-f)*s),mod=i%6,r=[v,q,p,p,t,v][mod],g=[t,v,v,q,p,p][mod],b=[p,p,t,v,v,q][mod];return{r:r*255,g:g*255,b:b*255}}function rgbToHex(r,g,b,allow3Char){var hex=[pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16))];if(allow3Char&&hex[0].charAt(0)==hex[0].charAt(1)&&hex[1].charAt(0)==hex[1].charAt(1)&&hex[2].charAt(0)==hex[2].charAt(1)){return hex[0].charAt(0)+hex[1].charAt(0)+hex[2].charAt(0)}return hex.join("")}function rgbaToHex(r,g,b,a,allow4Char){var hex=[pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16)),pad2(convertDecimalToHex(a))];if(allow4Char&&hex[0].charAt(0)==hex[0].charAt(1)&&hex[1].charAt(0)==hex[1].charAt(1)&&hex[2].charAt(0)==hex[2].charAt(1)&&hex[3].charAt(0)==hex[3].charAt(1)){return hex[0].charAt(0)+hex[1].charAt(0)+hex[2].charAt(0)+hex[3].charAt(0)}return hex.join("")}function rgbaToArgbHex(r,g,b,a){var hex=[pad2(convertDecimalToHex(a)),pad2(mathRound(r).toString(16)),pad2(mathRound(g).toString(16)),pad2(mathRound(b).toString(16))];return hex.join("")}tinycolor.equals=function(color1,color2){if(!color1||!color2){return false}return tinycolor(color1).toRgbString()==tinycolor(color2).toRgbString()};tinycolor.random=function(){return tinycolor.fromRatio({r:mathRandom(),g:mathRandom(),b:mathRandom()})};function desaturate(color,amount){amount=amount===0?0:amount||10;var hsl=tinycolor(color).toHsl();hsl.s-=amount/100;hsl.s=clamp01(hsl.s);return tinycolor(hsl)}function saturate(color,amount){amount=amount===0?0:amount||10;var hsl=tinycolor(color).toHsl();hsl.s+=amount/100;hsl.s=clamp01(hsl.s);return tinycolor(hsl)}function greyscale(color){return tinycolor(color).desaturate(100)}function lighten(color,amount){amount=amount===0?0:amount||10;var hsl=tinycolor(color).toHsl();hsl.l+=amount/100;hsl.l=clamp01(hsl.l);return tinycolor(hsl)}function brighten(color,amount){amount=amount===0?0:amount||10;var rgb=tinycolor(color).toRgb();rgb.r=mathMax(0,mathMin(255,rgb.r-mathRound(255*-(amount/100))));rgb.g=mathMax(0,mathMin(255,rgb.g-mathRound(255*-(amount/100))));rgb.b=mathMax(0,mathMin(255,rgb.b-mathRound(255*-(amount/100))));return tinycolor(rgb)}function darken(color,amount){amount=amount===0?0:amount||10;var hsl=tinycolor(color).toHsl();hsl.l-=amount/100;hsl.l=clamp01(hsl.l);return tinycolor(hsl)}function spin(color,amount){var hsl=tinycolor(color).toHsl();var hue=(hsl.h+amount)%360;hsl.h=hue<0?360+hue:hue;return tinycolor(hsl)}function complement(color){var hsl=tinycolor(color).toHsl();hsl.h=(hsl.h+180)%360;return tinycolor(hsl)}function triad(color){var hsl=tinycolor(color).toHsl();var h=hsl.h;return[tinycolor(color),tinycolor({h:(h+120)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+240)%360,s:hsl.s,l:hsl.l})]}function tetrad(color){var hsl=tinycolor(color).toHsl();var h=hsl.h;return[tinycolor(color),tinycolor({h:(h+90)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+180)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+270)%360,s:hsl.s,l:hsl.l})]}function splitcomplement(color){var hsl=tinycolor(color).toHsl();var h=hsl.h;return[tinycolor(color),tinycolor({h:(h+72)%360,s:hsl.s,l:hsl.l}),tinycolor({h:(h+216)%360,s:hsl.s,l:hsl.l})]}function analogous(color,results,slices){results=results||6;slices=slices||30;var hsl=tinycolor(color).toHsl();var part=360/slices;var ret=[tinycolor(color)];for(hsl.h=(hsl.h-(part*results>>1)+720)%360;--results;){hsl.h=(hsl.h+part)%360;ret.push(tinycolor(hsl))}return ret}function monochromatic(color,results){results=results||6;var hsv=tinycolor(color).toHsv();var h=hsv.h,s=hsv.s,v=hsv.v;var ret=[];var modification=1/results;while(results--){ret.push(tinycolor({h:h,s:s,v:v}));v=(v+modification)%1}return ret}tinycolor.mix=function(color1,color2,amount){amount=amount===0?0:amount||50;var rgb1=tinycolor(color1).toRgb();var rgb2=tinycolor(color2).toRgb();var p=amount/100;var rgba={r:(rgb2.r-rgb1.r)*p+rgb1.r,g:(rgb2.g-rgb1.g)*p+rgb1.g,b:(rgb2.b-rgb1.b)*p+rgb1.b,a:(rgb2.a-rgb1.a)*p+rgb1.a};return tinycolor(rgba)};tinycolor.readability=function(color1,color2){var c1=tinycolor(color1);var c2=tinycolor(color2);return(Math.max(c1.getLuminance(),c2.getLuminance())+.05)/(Math.min(c1.getLuminance(),c2.getLuminance())+.05)};tinycolor.isReadable=function(color1,color2,wcag2){var readability=tinycolor.readability(color1,color2);var wcag2Parms,out;out=false;wcag2Parms=validateWCAG2Parms(wcag2);switch(wcag2Parms.level+wcag2Parms.size){case"AAsmall":case"AAAlarge":out=readability>=4.5;break;case"AAlarge":out=readability>=3;break;case"AAAsmall":out=readability>=7;break}return out};tinycolor.mostReadable=function(baseColor,colorList,args){var bestColor=null;var bestScore=0;var readability;var includeFallbackColors,level,size;args=args||{};includeFallbackColors=args.includeFallbackColors;level=args.level;size=args.size;for(var i=0;i<colorList.length;i++){readability=tinycolor.readability(baseColor,colorList[i]);if(readability>bestScore){bestScore=readability;bestColor=tinycolor(colorList[i])}}if(tinycolor.isReadable(baseColor,bestColor,{level:level,size:size})||!includeFallbackColors){return bestColor}else{args.includeFallbackColors=false;return tinycolor.mostReadable(baseColor,["#fff","#000"],args)}};var names=tinycolor.names={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"0ff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"00f",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",burntsienna:"ea7e5d",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"0ff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"f0f",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};var hexNames=tinycolor.hexNames=flip(names);function flip(o){var flipped={};for(var i in o){if(o.hasOwnProperty(i)){flipped[o[i]]=i}}return flipped}function boundAlpha(a){a=parseFloat(a);if(isNaN(a)||a<0||a>1){a=1}return a}function bound01(n,max){if(isOnePointZero(n)){n="100%"}var processPercent=isPercentage(n);n=mathMin(max,mathMax(0,parseFloat(n)));if(processPercent){n=parseInt(n*max,10)/100}if(Math.abs(n-max)<1e-6){return 1}return n%max/parseFloat(max)}function clamp01(val){return mathMin(1,mathMax(0,val))}function parseIntFromHex(val){return parseInt(val,16)}function isOnePointZero(n){return typeof n=="string"&&n.indexOf(".")!=-1&&parseFloat(n)===1}function isPercentage(n){return typeof n==="string"&&n.indexOf("%")!=-1}function pad2(c){return c.length==1?"0"+c:""+c}function convertToPercentage(n){if(n<=1){n=n*100+"%"}return n}function convertDecimalToHex(d){return Math.round(parseFloat(d)*255).toString(16)}function convertHexToDecimal(h){return parseIntFromHex(h)/255}var matchers=function(){var CSS_INTEGER="[-\\+]?\\d+%?";var CSS_NUMBER="[-\\+]?\\d*\\.\\d+%?";var CSS_UNIT="(?:"+CSS_NUMBER+")|(?:"+CSS_INTEGER+")";var PERMISSIVE_MATCH3="[\\s|\\(]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")\\s*\\)?";var PERMISSIVE_MATCH4="[\\s|\\(]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")[,|\\s]+("+CSS_UNIT+")\\s*\\)?";return{CSS_UNIT:new RegExp(CSS_UNIT),rgb:new RegExp("rgb"+PERMISSIVE_MATCH3),rgba:new RegExp("rgba"+PERMISSIVE_MATCH4),hsl:new RegExp("hsl"+PERMISSIVE_MATCH3),hsla:new RegExp("hsla"+PERMISSIVE_MATCH4),hsv:new RegExp("hsv"+PERMISSIVE_MATCH3),hsva:new RegExp("hsva"+PERMISSIVE_MATCH4),hex3:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex6:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,hex4:/^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,hex8:/^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/}}();function isValidCSSUnit(color){return!!matchers.CSS_UNIT.exec(color)}function stringInputToObject(color){color=color.replace(trimLeft,"").replace(trimRight,"").toLowerCase();var named=false;if(names[color]){color=names[color];named=true}else if(color=="transparent"){return{r:0,g:0,b:0,a:0,format:"name"}}var match;if(match=matchers.rgb.exec(color)){return{r:match[1],g:match[2],b:match[3]}}if(match=matchers.rgba.exec(color)){return{r:match[1],g:match[2],b:match[3],a:match[4]}}if(match=matchers.hsl.exec(color)){return{h:match[1],s:match[2],l:match[3]}}if(match=matchers.hsla.exec(color)){return{h:match[1],s:match[2],l:match[3],a:match[4]}}if(match=matchers.hsv.exec(color)){return{h:match[1],s:match[2],v:match[3]}}if(match=matchers.hsva.exec(color)){return{h:match[1],s:match[2],v:match[3],a:match[4]}}if(match=matchers.hex8.exec(color)){return{r:parseIntFromHex(match[1]),g:parseIntFromHex(match[2]),b:parseIntFromHex(match[3]),a:convertHexToDecimal(match[4]),format:named?"name":"hex8"}}if(match=matchers.hex6.exec(color)){return{r:parseIntFromHex(match[1]),g:parseIntFromHex(match[2]),b:parseIntFromHex(match[3]),format:named?"name":"hex"}}if(match=matchers.hex4.exec(color)){return{r:parseIntFromHex(match[1]+""+match[1]),g:parseIntFromHex(match[2]+""+match[2]),b:parseIntFromHex(match[3]+""+match[3]),a:convertHexToDecimal(match[4]+""+match[4]),format:named?"name":"hex8"}}if(match=matchers.hex3.exec(color)){return{r:parseIntFromHex(match[1]+""+match[1]),g:parseIntFromHex(match[2]+""+match[2]),b:parseIntFromHex(match[3]+""+match[3]),format:named?"name":"hex"}}return false}function validateWCAG2Parms(parms){var level,size;parms=parms||{level:"AA",size:"small"};level=(parms.level||"AA").toUpperCase();size=(parms.size||"small").toLowerCase();if(level!=="AA"&&level!=="AAA"){level="AA"}if(size!=="small"&&size!=="large"){size="small"}return{level:level,size:size}}if(true&&module.exports){module.exports=tinycolor}else if(true){!(__WEBPACK_AMD_DEFINE_RESULT__=function(){return tinycolor}.call(exports,__webpack_require__,exports,module),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}})(Math)},231:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ErrorBoundary}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var recompose__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(20);var recompose__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(recompose__WEBPACK_IMPORTED_MODULE_1__);var prop_types__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(214);var prop_types__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);var lodash__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);const ErrorBoundaryComponent=props=>{const{children:children,...rest}=props;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,children(rest))};ErrorBoundaryComponent.propTypes={children:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.func.isRequired,error:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object,errorInfo:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object,resetErrorState:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.func.isRequired};const errorBoundaryHoc=Object(recompose__WEBPACK_IMPORTED_MODULE_1__["compose"])(Object(recompose__WEBPACK_IMPORTED_MODULE_1__["withState"])("error","setError",null),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["withState"])("errorInfo","setErrorInfo",null),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["withHandlers"])({resetErrorState:({setError:setError,setErrorInfo:setErrorInfo})=>()=>{setError(null);setErrorInfo(null)}}),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["lifecycle"])({componentDidCatch(error,errorInfo){this.props.setError(error);this.props.setErrorInfo(errorInfo)}}),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["mapProps"])(props=>Object(lodash__WEBPACK_IMPORTED_MODULE_3__["omit"])(props,["setError","setErrorInfo"])));const ErrorBoundary=errorBoundaryHoc(ErrorBoundaryComponent)},234:function(module,exports,__webpack_require__){var getNative=__webpack_require__(248);var nativeCreate=getNative(Object,"create");module.exports=nativeCreate},235:function(module,exports,__webpack_require__){var eq=__webpack_require__(286);function assocIndexOf(array,key){var length=array.length;while(length--){if(eq(array[length][0],key)){return length}}return-1}module.exports=assocIndexOf},236:function(module,exports,__webpack_require__){var isKeyable=__webpack_require__(440);function getMapData(map,key){var data=map.__data__;return isKeyable(key)?data[typeof key=="string"?"string":"hash"]:data.map}module.exports=getMapData},237:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret=__webpack_require__(238);function emptyFunction(){}function emptyFunctionWithReset(){}emptyFunctionWithReset.resetWarningCache=emptyFunction;module.exports=function(){function shim(props,propName,componentName,location,propFullName,secret){if(secret===ReactPropTypesSecret){return}var err=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use PropTypes.checkPropTypes() to call them. "+"Read more at http://fb.me/use-check-prop-types");err.name="Invariant Violation";throw err}shim.isRequired=shim;function getShim(){return shim}var ReactPropTypes={array:shim,bool:shim,func:shim,number:shim,object:shim,string:shim,symbol:shim,any:shim,arrayOf:getShim,element:shim,elementType:shim,instanceOf:getShim,node:shim,objectOf:getShim,oneOf:getShim,oneOfType:getShim,shape:getShim,exact:getShim,checkPropTypes:emptyFunctionWithReset,resetWarningCache:emptyFunction};ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}},238:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},247:function(module,exports,__webpack_require__){exports.set=__webpack_require__(406);exports.setWith=__webpack_require__(449)},248:function(module,exports,__webpack_require__){var baseIsNative=__webpack_require__(410),getValue=__webpack_require__(417);function getNative(object,key){var value=getValue(object,key);return baseIsNative(value)?value:undefined}module.exports=getNative},249:function(module,exports,__webpack_require__){var root=__webpack_require__(250);var Symbol=root.Symbol;module.exports=Symbol},250:function(module,exports,__webpack_require__){var freeGlobal=__webpack_require__(411);var freeSelf=typeof self=="object"&&self&&self.Object===Object&&self;var root=freeGlobal||freeSelf||Function("return this")();module.exports=root},251:function(module,exports){function isObject(value){var type=typeof value;return value!=null&&(type=="object"||type=="function")}module.exports=isObject},252:function(module,exports){var isArray=Array.isArray;module.exports=isArray},253:function(module,exports,__webpack_require__){var baseGetTag=__webpack_require__(285),isObjectLike=__webpack_require__(420);var symbolTag="[object Symbol]";function isSymbol(value){return typeof value=="symbol"||isObjectLike(value)&&baseGetTag(value)==symbolTag}module.exports=isSymbol},254:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return TooltipIcon}));__webpack_require__.d(__webpack_exports__,"a",(function(){return IconType}));var external_kbnSharedDeps_React_=__webpack_require__(3);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}let IconType;(function(IconType){IconType["error"]="error";IconType["warning"]="warning";IconType["info"]="info"})(IconType||(IconType={}));const TooltipIcon=({icon:icon=IconType.info,...rest})=>{const icons={[IconType.error]:{type:"alert",color:"danger"},[IconType.warning]:{type:"alert",color:"warning"},[IconType.info]:{type:"iInCircle",color:"default"}};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIconTip"],_extends({},rest,{type:icons[icon].type,color:icons[icon].color}))}},283:function(module,exports,__webpack_require__){var assignValue=__webpack_require__(407),castPath=__webpack_require__(418),isFunction=__webpack_require__(284),isIndex=__webpack_require__(447),isObject=__webpack_require__(251),toKey=__webpack_require__(448);function baseSet(object,path,value,customizer){if(!isObject(object)){return object}path=castPath(path,object);var index=-1,length=path.length,lastIndex=length-1,nested=object;while(nested!=null&&++index<length){var key=toKey(path[index]),newValue=value;if(key=="prototype"&&isFunction(nested)){throw new Error("Illegal access of function prototype")}if(index!=lastIndex){var objValue=hasOwnProperty.call(nested,key)?nested[key]:undefined;newValue=customizer?customizer(objValue,key,nested):undefined;if(newValue===undefined){newValue=isObject(objValue)?objValue:isIndex(path[index+1])?[]:{}}}assignValue(nested,key,newValue);nested=nested[key]}return object}module.exports=baseSet},284:function(module,exports,__webpack_require__){var baseGetTag=__webpack_require__(285),isObject=__webpack_require__(251);var asyncTag="[object AsyncFunction]",funcTag="[object Function]",genTag="[object GeneratorFunction]",proxyTag="[object Proxy]";function isFunction(value){if(!isObject(value)){return false}var tag=baseGetTag(value);return tag==funcTag||tag==genTag||tag==asyncTag||tag==proxyTag}module.exports=isFunction},285:function(module,exports,__webpack_require__){var Symbol=__webpack_require__(249),getRawTag=__webpack_require__(412),objectToString=__webpack_require__(413);var nullTag="[object Null]",undefinedTag="[object Undefined]";var symToStringTag=Symbol?Symbol.toStringTag:undefined;function baseGetTag(value){if(value==null){return value===undefined?undefinedTag:nullTag}return symToStringTag&&symToStringTag in Object(value)?getRawTag(value):objectToString(value)}module.exports=baseGetTag},286:function(module,exports){function eq(value,other){return value===other||value!==value&&other!==other}module.exports=eq},334:function(module,exports,__webpack_require__){(function(module){var __WEBPACK_AMD_DEFINE_ARRAY__,__WEBPACK_AMD_DEFINE_RESULT__;
/**
 * @license
 *
 * chroma.js - JavaScript library for color conversions
 * 
 * Copyright (c) 2011-2017, Gregor Aisch
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice, this
 *    list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * 3. The name Gregor Aisch may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL GREGOR AISCH OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */(function(){var Color,DEG2RAD,LAB_CONSTANTS,PI,PITHIRD,RAD2DEG,TWOPI,_average_lrgb,_guess_formats,_guess_formats_sorted,_input,_interpolators,abs,atan2,bezier,blend,blend_f,brewer,burn,chroma,clip_rgb,cmyk2rgb,colors,cos,css2rgb,darken,dodge,each,floor,hcg2rgb,hex2rgb,hsi2rgb,hsl2css,hsl2rgb,hsv2rgb,interpolate,interpolate_hsx,interpolate_lab,interpolate_lrgb,interpolate_num,interpolate_rgb,lab2lch,lab2rgb,lab_xyz,lch2lab,lch2rgb,lighten,limit,log,luminance_x,m,max,multiply,normal,num2rgb,overlay,pow,rgb2cmyk,rgb2css,rgb2hcg,rgb2hex,rgb2hsi,rgb2hsl,rgb2hsv,rgb2lab,rgb2lch,rgb2luminance,rgb2num,rgb2temperature,rgb2xyz,rgb_xyz,rnd,root,round,screen,sin,sqrt,temperature2rgb,type,unpack,w3cx11,xyz_lab,xyz_rgb,slice=[].slice;type=function(){var classToType,len,name,o,ref;classToType={};ref="Boolean Number String Function Array Date RegExp Undefined Null".split(" ");for(o=0,len=ref.length;o<len;o++){name=ref[o];classToType["[object "+name+"]"]=name.toLowerCase()}return function(obj){var strType;strType=Object.prototype.toString.call(obj);return classToType[strType]||"object"}}();limit=function(x,min,max){if(min==null){min=0}if(max==null){max=1}if(x<min){x=min}if(x>max){x=max}return x};unpack=function(args){if(args.length>=3){return Array.prototype.slice.call(args)}else{return args[0]}};clip_rgb=function(rgb){var i,o;rgb._clipped=false;rgb._unclipped=rgb.slice(0);for(i=o=0;o<3;i=++o){if(i<3){if(rgb[i]<0||rgb[i]>255){rgb._clipped=true}if(rgb[i]<0){rgb[i]=0}if(rgb[i]>255){rgb[i]=255}}else if(i===3){if(rgb[i]<0){rgb[i]=0}if(rgb[i]>1){rgb[i]=1}}}if(!rgb._clipped){delete rgb._unclipped}return rgb};PI=Math.PI,round=Math.round,cos=Math.cos,floor=Math.floor,pow=Math.pow,log=Math.log,sin=Math.sin,sqrt=Math.sqrt,atan2=Math.atan2,max=Math.max,abs=Math.abs;TWOPI=PI*2;PITHIRD=PI/3;DEG2RAD=PI/180;RAD2DEG=180/PI;chroma=function(){if(arguments[0]instanceof Color){return arguments[0]}return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,arguments,(function(){}))};chroma["default"]=chroma;_interpolators=[];if(true&&module!==null&&module.exports!=null){module.exports=chroma}if(true){!(__WEBPACK_AMD_DEFINE_ARRAY__=[],__WEBPACK_AMD_DEFINE_RESULT__=function(){return chroma}.apply(exports,__WEBPACK_AMD_DEFINE_ARRAY__),__WEBPACK_AMD_DEFINE_RESULT__!==undefined&&(module.exports=__WEBPACK_AMD_DEFINE_RESULT__))}else{}chroma.version="1.4.1";_input={};_guess_formats=[];_guess_formats_sorted=false;Color=function(){function Color(){var arg,args,chk,len,len1,me,mode,o,w;me=this;args=[];for(o=0,len=arguments.length;o<len;o++){arg=arguments[o];if(arg!=null){args.push(arg)}}if(args.length>1){mode=args[args.length-1]}if(_input[mode]!=null){me._rgb=clip_rgb(_input[mode](unpack(args.slice(0,-1))))}else{if(!_guess_formats_sorted){_guess_formats=_guess_formats.sort((function(a,b){return b.p-a.p}));_guess_formats_sorted=true}for(w=0,len1=_guess_formats.length;w<len1;w++){chk=_guess_formats[w];mode=chk.test.apply(chk,args);if(mode){break}}if(mode){me._rgb=clip_rgb(_input[mode].apply(_input,args))}}if(me._rgb==null){console.warn("unknown format: "+args)}if(me._rgb==null){me._rgb=[0,0,0]}if(me._rgb.length===3){me._rgb.push(1)}}Color.prototype.toString=function(){return this.hex()};return Color}();chroma._input=_input;
/**
  	ColorBrewer colors for chroma.js
  
  	Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The 
  	Pennsylvania State University.
  
  	Licensed under the Apache License, Version 2.0 (the "License"); 
  	you may not use this file except in compliance with the License.
  	You may obtain a copy of the License at	
  	http://www.apache.org/licenses/LICENSE-2.0
  
  	Unless required by applicable law or agreed to in writing, software distributed
  	under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
  	CONDITIONS OF ANY KIND, either express or implied. See the License for the
  	specific language governing permissions and limitations under the License.
  
      @preserve
   */chroma.brewer=brewer={OrRd:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"],PuBu:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"],BuPu:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"],Oranges:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"],BuGn:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"],YlOrBr:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"],YlGn:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"],Reds:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"],RdPu:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"],Greens:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"],YlGnBu:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"],Purples:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"],GnBu:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"],Greys:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"],YlOrRd:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"],PuRd:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"],Blues:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"],PuBuGn:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"],Viridis:["#440154","#482777","#3f4a8a","#31678e","#26838f","#1f9d8a","#6cce5a","#b6de2b","#fee825"],Spectral:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],RdYlGn:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],RdBu:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],PiYG:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],PRGn:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],RdYlBu:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],BrBG:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],RdGy:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],PuOr:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],Set2:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"],Accent:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"],Set1:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"],Set3:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"],Dark2:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"],Paired:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"],Pastel2:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"],Pastel1:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]};(function(){var key,results;results=[];for(key in brewer){results.push(brewer[key.toLowerCase()]=brewer[key])}return results})();w3cx11={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflower:"#6495ed",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgreen:"#006400",darkgrey:"#a9a9a9",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",green:"#008000",greenyellow:"#adff2f",grey:"#808080",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",laserlemon:"#ffff54",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrod:"#fafad2",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgreen:"#90ee90",lightgrey:"#d3d3d3",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",maroon2:"#7f0000",maroon3:"#b03060",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370db",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#db7093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",purple2:"#7f007f",purple3:"#a020f0",rebeccapurple:"#663399",red:"#ff0000",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"};chroma.colors=colors=w3cx11;lab2rgb=function(){var a,args,b,g,l,r,x,y,z;args=unpack(arguments);l=args[0],a=args[1],b=args[2];y=(l+16)/116;x=isNaN(a)?y:y+a/500;z=isNaN(b)?y:y-b/200;y=LAB_CONSTANTS.Yn*lab_xyz(y);x=LAB_CONSTANTS.Xn*lab_xyz(x);z=LAB_CONSTANTS.Zn*lab_xyz(z);r=xyz_rgb(3.2404542*x-1.5371385*y-.4985314*z);g=xyz_rgb(-.969266*x+1.8760108*y+.041556*z);b=xyz_rgb(.0556434*x-.2040259*y+1.0572252*z);return[r,g,b,args.length>3?args[3]:1]};xyz_rgb=function(r){return 255*(r<=.00304?12.92*r:1.055*pow(r,1/2.4)-.055)};lab_xyz=function(t){if(t>LAB_CONSTANTS.t1){return t*t*t}else{return LAB_CONSTANTS.t2*(t-LAB_CONSTANTS.t0)}};LAB_CONSTANTS={Kn:18,Xn:.95047,Yn:1,Zn:1.08883,t0:.137931034,t1:.206896552,t2:.12841855,t3:.008856452};rgb2lab=function(){var b,g,r,ref,ref1,x,y,z;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];ref1=rgb2xyz(r,g,b),x=ref1[0],y=ref1[1],z=ref1[2];return[116*y-16,500*(x-y),200*(y-z)]};rgb_xyz=function(r){if((r/=255)<=.04045){return r/12.92}else{return pow((r+.055)/1.055,2.4)}};xyz_lab=function(t){if(t>LAB_CONSTANTS.t3){return pow(t,1/3)}else{return t/LAB_CONSTANTS.t2+LAB_CONSTANTS.t0}};rgb2xyz=function(){var b,g,r,ref,x,y,z;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];r=rgb_xyz(r);g=rgb_xyz(g);b=rgb_xyz(b);x=xyz_lab((.4124564*r+.3575761*g+.1804375*b)/LAB_CONSTANTS.Xn);y=xyz_lab((.2126729*r+.7151522*g+.072175*b)/LAB_CONSTANTS.Yn);z=xyz_lab((.0193339*r+.119192*g+.9503041*b)/LAB_CONSTANTS.Zn);return[x,y,z]};chroma.lab=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["lab"]),(function(){}))};_input.lab=lab2rgb;Color.prototype.lab=function(){return rgb2lab(this._rgb)};bezier=function(colors){var I,I0,I1,c,lab0,lab1,lab2,lab3,ref,ref1,ref2;colors=function(){var len,o,results;results=[];for(o=0,len=colors.length;o<len;o++){c=colors[o];results.push(chroma(c))}return results}();if(colors.length===2){ref=function(){var len,o,results;results=[];for(o=0,len=colors.length;o<len;o++){c=colors[o];results.push(c.lab())}return results}(),lab0=ref[0],lab1=ref[1];I=function(t){var i,lab;lab=function(){var o,results;results=[];for(i=o=0;o<=2;i=++o){results.push(lab0[i]+t*(lab1[i]-lab0[i]))}return results}();return chroma.lab.apply(chroma,lab)}}else if(colors.length===3){ref1=function(){var len,o,results;results=[];for(o=0,len=colors.length;o<len;o++){c=colors[o];results.push(c.lab())}return results}(),lab0=ref1[0],lab1=ref1[1],lab2=ref1[2];I=function(t){var i,lab;lab=function(){var o,results;results=[];for(i=o=0;o<=2;i=++o){results.push((1-t)*(1-t)*lab0[i]+2*(1-t)*t*lab1[i]+t*t*lab2[i])}return results}();return chroma.lab.apply(chroma,lab)}}else if(colors.length===4){ref2=function(){var len,o,results;results=[];for(o=0,len=colors.length;o<len;o++){c=colors[o];results.push(c.lab())}return results}(),lab0=ref2[0],lab1=ref2[1],lab2=ref2[2],lab3=ref2[3];I=function(t){var i,lab;lab=function(){var o,results;results=[];for(i=o=0;o<=2;i=++o){results.push((1-t)*(1-t)*(1-t)*lab0[i]+3*(1-t)*(1-t)*t*lab1[i]+3*(1-t)*t*t*lab2[i]+t*t*t*lab3[i])}return results}();return chroma.lab.apply(chroma,lab)}}else if(colors.length===5){I0=bezier(colors.slice(0,3));I1=bezier(colors.slice(2,5));I=function(t){if(t<.5){return I0(t*2)}else{return I1((t-.5)*2)}}}return I};chroma.bezier=function(colors){var f;f=bezier(colors);f.scale=function(){return chroma.scale(f)};return f};chroma.cubehelix=function(start,rotations,hue,gamma,lightness){var dh,dl,f;if(start==null){start=300}if(rotations==null){rotations=-1.5}if(hue==null){hue=1}if(gamma==null){gamma=1}if(lightness==null){lightness=[0,1]}dh=0;if(type(lightness)==="array"){dl=lightness[1]-lightness[0]}else{dl=0;lightness=[lightness,lightness]}f=function(fract){var a,amp,b,cos_a,g,h,l,r,sin_a;a=TWOPI*((start+120)/360+rotations*fract);l=pow(lightness[0]+dl*fract,gamma);h=dh!==0?hue[0]+fract*dh:hue;amp=h*l*(1-l)/2;cos_a=cos(a);sin_a=sin(a);r=l+amp*(-.14861*cos_a+1.78277*sin_a);g=l+amp*(-.29227*cos_a-.90649*sin_a);b=l+amp*(+1.97294*cos_a);return chroma(clip_rgb([r*255,g*255,b*255,1]))};f.start=function(s){if(s==null){return start}start=s;return f};f.rotations=function(r){if(r==null){return rotations}rotations=r;return f};f.gamma=function(g){if(g==null){return gamma}gamma=g;return f};f.hue=function(h){if(h==null){return hue}hue=h;if(type(hue)==="array"){dh=hue[1]-hue[0];if(dh===0){hue=hue[1]}}else{dh=0}return f};f.lightness=function(h){if(h==null){return lightness}if(type(h)==="array"){lightness=h;dl=h[1]-h[0]}else{lightness=[h,h];dl=0}return f};f.scale=function(){return chroma.scale(f)};f.hue(hue);return f};chroma.random=function(){var code,digits,i,o;digits="0123456789abcdef";code="#";for(i=o=0;o<6;i=++o){code+=digits.charAt(floor(Math.random()*16))}return new Color(code)};_interpolators=[];interpolate=function(col1,col2,f,m){var interpol,len,o,res;if(f==null){f=.5}if(m==null){m="rgb"}if(type(col1)!=="object"){col1=chroma(col1)}if(type(col2)!=="object"){col2=chroma(col2)}for(o=0,len=_interpolators.length;o<len;o++){interpol=_interpolators[o];if(m===interpol[0]){res=interpol[1](col1,col2,f,m);break}}if(res==null){throw"color mode "+m+" is not supported"}return res.alpha(col1.alpha()+f*(col2.alpha()-col1.alpha()))};chroma.interpolate=interpolate;Color.prototype.interpolate=function(col2,f,m){return interpolate(this,col2,f,m)};chroma.mix=interpolate;Color.prototype.mix=Color.prototype.interpolate;_input.rgb=function(){var k,ref,results,v;ref=unpack(arguments);results=[];for(k in ref){v=ref[k];results.push(v)}return results};chroma.rgb=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["rgb"]),(function(){}))};Color.prototype.rgb=function(round){if(round==null){round=true}if(round){return this._rgb.map(Math.round).slice(0,3)}else{return this._rgb.slice(0,3)}};Color.prototype.rgba=function(round){if(round==null){round=true}if(!round){return this._rgb.slice(0)}return[Math.round(this._rgb[0]),Math.round(this._rgb[1]),Math.round(this._rgb[2]),this._rgb[3]]};_guess_formats.push({p:3,test:function(n){var a;a=unpack(arguments);if(type(a)==="array"&&a.length===3){return"rgb"}if(a.length===4&&type(a[3])==="number"&&a[3]>=0&&a[3]<=1){return"rgb"}}});_input.lrgb=_input.rgb;interpolate_lrgb=function(col1,col2,f,m){var xyz0,xyz1;xyz0=col1._rgb;xyz1=col2._rgb;return new Color(sqrt(pow(xyz0[0],2)*(1-f)+pow(xyz1[0],2)*f),sqrt(pow(xyz0[1],2)*(1-f)+pow(xyz1[1],2)*f),sqrt(pow(xyz0[2],2)*(1-f)+pow(xyz1[2],2)*f),m)};_average_lrgb=function(colors){var col,f,len,o,rgb,xyz;f=1/colors.length;xyz=[0,0,0,0];for(o=0,len=colors.length;o<len;o++){col=colors[o];rgb=col._rgb;xyz[0]+=pow(rgb[0],2)*f;xyz[1]+=pow(rgb[1],2)*f;xyz[2]+=pow(rgb[2],2)*f;xyz[3]+=rgb[3]*f}xyz[0]=sqrt(xyz[0]);xyz[1]=sqrt(xyz[1]);xyz[2]=sqrt(xyz[2]);if(xyz[3]>1){xyz[3]=1}return new Color(clip_rgb(xyz))};_interpolators.push(["lrgb",interpolate_lrgb]);chroma.average=function(colors,mode){var A,alpha,c,cnt,dx,dy,first,i,l,len,o,xyz,xyz2;if(mode==null){mode="rgb"}l=colors.length;colors=colors.map((function(c){return chroma(c)}));first=colors.splice(0,1)[0];if(mode==="lrgb"){return _average_lrgb(colors)}xyz=first.get(mode);cnt=[];dx=0;dy=0;for(i in xyz){xyz[i]=xyz[i]||0;cnt.push(isNaN(xyz[i])?0:1);if(mode.charAt(i)==="h"&&!isNaN(xyz[i])){A=xyz[i]/180*PI;dx+=cos(A);dy+=sin(A)}}alpha=first.alpha();for(o=0,len=colors.length;o<len;o++){c=colors[o];xyz2=c.get(mode);alpha+=c.alpha();for(i in xyz){if(!isNaN(xyz2[i])){cnt[i]+=1;if(mode.charAt(i)==="h"){A=xyz2[i]/180*PI;dx+=cos(A);dy+=sin(A)}else{xyz[i]+=xyz2[i]}}}}for(i in xyz){if(mode.charAt(i)==="h"){A=atan2(dy/cnt[i],dx/cnt[i])/PI*180;while(A<0){A+=360}while(A>=360){A-=360}xyz[i]=A}else{xyz[i]=xyz[i]/cnt[i]}}return chroma(xyz,mode).alpha(alpha/l)};hex2rgb=function(hex){var a,b,g,r,rgb,u;if(hex.match(/^#?([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$/)){if(hex.length===4||hex.length===7){hex=hex.substr(1)}if(hex.length===3){hex=hex.split("");hex=hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2]}u=parseInt(hex,16);r=u>>16;g=u>>8&255;b=u&255;return[r,g,b,1]}if(hex.match(/^#?([A-Fa-f0-9]{8})$/)){if(hex.length===9){hex=hex.substr(1)}u=parseInt(hex,16);r=u>>24&255;g=u>>16&255;b=u>>8&255;a=round((u&255)/255*100)/100;return[r,g,b,a]}if(_input.css!=null&&(rgb=_input.css(hex))){return rgb}throw"unknown color: "+hex};rgb2hex=function(channels,mode){var a,b,g,hxa,r,str,u;if(mode==null){mode="auto"}r=channels[0],g=channels[1],b=channels[2],a=channels[3];if(mode==="auto"){mode=a<1?"rgba":"rgb"}r=Math.round(r);g=Math.round(g);b=Math.round(b);u=r<<16|g<<8|b;str="000000"+u.toString(16);str=str.substr(str.length-6);hxa="0"+round(a*255).toString(16);hxa=hxa.substr(hxa.length-2);return"#"+function(){switch(mode.toLowerCase()){case"rgba":return str+hxa;case"argb":return hxa+str;default:return str}}()};_input.hex=function(h){return hex2rgb(h)};chroma.hex=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["hex"]),(function(){}))};Color.prototype.hex=function(mode){if(mode==null){mode="auto"}return rgb2hex(this._rgb,mode)};_guess_formats.push({p:4,test:function(n){if(arguments.length===1&&type(n)==="string"){return"hex"}}});hsl2rgb=function(){var args,b,c,g,h,i,l,o,r,ref,s,t1,t2,t3;args=unpack(arguments);h=args[0],s=args[1],l=args[2];if(s===0){r=g=b=l*255}else{t3=[0,0,0];c=[0,0,0];t2=l<.5?l*(1+s):l+s-l*s;t1=2*l-t2;h/=360;t3[0]=h+1/3;t3[1]=h;t3[2]=h-1/3;for(i=o=0;o<=2;i=++o){if(t3[i]<0){t3[i]+=1}if(t3[i]>1){t3[i]-=1}if(6*t3[i]<1){c[i]=t1+(t2-t1)*6*t3[i]}else if(2*t3[i]<1){c[i]=t2}else if(3*t3[i]<2){c[i]=t1+(t2-t1)*(2/3-t3[i])*6}else{c[i]=t1}}ref=[round(c[0]*255),round(c[1]*255),round(c[2]*255)],r=ref[0],g=ref[1],b=ref[2]}if(args.length>3){return[r,g,b,args[3]]}else{return[r,g,b]}};rgb2hsl=function(r,g,b){var h,l,min,ref,s;if(r!==void 0&&r.length>=3){ref=r,r=ref[0],g=ref[1],b=ref[2]}r/=255;g/=255;b/=255;min=Math.min(r,g,b);max=Math.max(r,g,b);l=(max+min)/2;if(max===min){s=0;h=Number.NaN}else{s=l<.5?(max-min)/(max+min):(max-min)/(2-max-min)}if(r===max){h=(g-b)/(max-min)}else if(g===max){h=2+(b-r)/(max-min)}else if(b===max){h=4+(r-g)/(max-min)}h*=60;if(h<0){h+=360}return[h,s,l]};chroma.hsl=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["hsl"]),(function(){}))};_input.hsl=hsl2rgb;Color.prototype.hsl=function(){return rgb2hsl(this._rgb)};hsv2rgb=function(){var args,b,f,g,h,i,p,q,r,ref,ref1,ref2,ref3,ref4,ref5,s,t,v;args=unpack(arguments);h=args[0],s=args[1],v=args[2];v*=255;if(s===0){r=g=b=v}else{if(h===360){h=0}if(h>360){h-=360}if(h<0){h+=360}h/=60;i=floor(h);f=h-i;p=v*(1-s);q=v*(1-s*f);t=v*(1-s*(1-f));switch(i){case 0:ref=[v,t,p],r=ref[0],g=ref[1],b=ref[2];break;case 1:ref1=[q,v,p],r=ref1[0],g=ref1[1],b=ref1[2];break;case 2:ref2=[p,v,t],r=ref2[0],g=ref2[1],b=ref2[2];break;case 3:ref3=[p,q,v],r=ref3[0],g=ref3[1],b=ref3[2];break;case 4:ref4=[t,p,v],r=ref4[0],g=ref4[1],b=ref4[2];break;case 5:ref5=[v,p,q],r=ref5[0],g=ref5[1],b=ref5[2]}}return[r,g,b,args.length>3?args[3]:1]};rgb2hsv=function(){var b,delta,g,h,min,r,ref,s,v;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];min=Math.min(r,g,b);max=Math.max(r,g,b);delta=max-min;v=max/255;if(max===0){h=Number.NaN;s=0}else{s=delta/max;if(r===max){h=(g-b)/delta}if(g===max){h=2+(b-r)/delta}if(b===max){h=4+(r-g)/delta}h*=60;if(h<0){h+=360}}return[h,s,v]};chroma.hsv=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["hsv"]),(function(){}))};_input.hsv=hsv2rgb;Color.prototype.hsv=function(){return rgb2hsv(this._rgb)};num2rgb=function(num){var b,g,r;if(type(num)==="number"&&num>=0&&num<=16777215){r=num>>16;g=num>>8&255;b=num&255;return[r,g,b,1]}console.warn("unknown num color: "+num);return[0,0,0,1]};rgb2num=function(){var b,g,r,ref;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];return(r<<16)+(g<<8)+b};chroma.num=function(num){return new Color(num,"num")};Color.prototype.num=function(mode){if(mode==null){mode="rgb"}return rgb2num(this._rgb,mode)};_input.num=num2rgb;_guess_formats.push({p:1,test:function(n){if(arguments.length===1&&type(n)==="number"&&n>=0&&n<=16777215){return"num"}}});hcg2rgb=function(){var _c,_g,args,b,c,f,g,h,i,p,q,r,ref,ref1,ref2,ref3,ref4,ref5,t,v;args=unpack(arguments);h=args[0],c=args[1],_g=args[2];c=c/100;g=g/100*255;_c=c*255;if(c===0){r=g=b=_g}else{if(h===360){h=0}if(h>360){h-=360}if(h<0){h+=360}h/=60;i=floor(h);f=h-i;p=_g*(1-c);q=p+_c*(1-f);t=p+_c*f;v=p+_c;switch(i){case 0:ref=[v,t,p],r=ref[0],g=ref[1],b=ref[2];break;case 1:ref1=[q,v,p],r=ref1[0],g=ref1[1],b=ref1[2];break;case 2:ref2=[p,v,t],r=ref2[0],g=ref2[1],b=ref2[2];break;case 3:ref3=[p,q,v],r=ref3[0],g=ref3[1],b=ref3[2];break;case 4:ref4=[t,p,v],r=ref4[0],g=ref4[1],b=ref4[2];break;case 5:ref5=[v,p,q],r=ref5[0],g=ref5[1],b=ref5[2]}}return[r,g,b,args.length>3?args[3]:1]};rgb2hcg=function(){var _g,b,c,delta,g,h,min,r,ref;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];min=Math.min(r,g,b);max=Math.max(r,g,b);delta=max-min;c=delta*100/255;_g=min/(255-delta)*100;if(delta===0){h=Number.NaN}else{if(r===max){h=(g-b)/delta}if(g===max){h=2+(b-r)/delta}if(b===max){h=4+(r-g)/delta}h*=60;if(h<0){h+=360}}return[h,c,_g]};chroma.hcg=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["hcg"]),(function(){}))};_input.hcg=hcg2rgb;Color.prototype.hcg=function(){return rgb2hcg(this._rgb)};css2rgb=function(css){var aa,ab,hsl,i,m,o,rgb,w;css=css.toLowerCase();if(chroma.colors!=null&&chroma.colors[css]){return hex2rgb(chroma.colors[css])}if(m=css.match(/rgb\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*\)/)){rgb=m.slice(1,4);for(i=o=0;o<=2;i=++o){rgb[i]=+rgb[i]}rgb[3]=1}else if(m=css.match(/rgba\(\s*(\-?\d+),\s*(\-?\d+)\s*,\s*(\-?\d+)\s*,\s*([01]|[01]?\.\d+)\)/)){rgb=m.slice(1,5);for(i=w=0;w<=3;i=++w){rgb[i]=+rgb[i]}}else if(m=css.match(/rgb\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/)){rgb=m.slice(1,4);for(i=aa=0;aa<=2;i=++aa){rgb[i]=round(rgb[i]*2.55)}rgb[3]=1}else if(m=css.match(/rgba\(\s*(\-?\d+(?:\.\d+)?)%,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/)){rgb=m.slice(1,5);for(i=ab=0;ab<=2;i=++ab){rgb[i]=round(rgb[i]*2.55)}rgb[3]=+rgb[3]}else if(m=css.match(/hsl\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*\)/)){hsl=m.slice(1,4);hsl[1]*=.01;hsl[2]*=.01;rgb=hsl2rgb(hsl);rgb[3]=1}else if(m=css.match(/hsla\(\s*(\-?\d+(?:\.\d+)?),\s*(\-?\d+(?:\.\d+)?)%\s*,\s*(\-?\d+(?:\.\d+)?)%\s*,\s*([01]|[01]?\.\d+)\)/)){hsl=m.slice(1,4);hsl[1]*=.01;hsl[2]*=.01;rgb=hsl2rgb(hsl);rgb[3]=+m[4]}return rgb};rgb2css=function(rgba){var mode;mode=rgba[3]<1?"rgba":"rgb";if(mode==="rgb"){return mode+"("+rgba.slice(0,3).map(round).join(",")+")"}else if(mode==="rgba"){return mode+"("+rgba.slice(0,3).map(round).join(",")+","+rgba[3]+")"}else{}};rnd=function(a){return round(a*100)/100};hsl2css=function(hsl,alpha){var mode;mode=alpha<1?"hsla":"hsl";hsl[0]=rnd(hsl[0]||0);hsl[1]=rnd(hsl[1]*100)+"%";hsl[2]=rnd(hsl[2]*100)+"%";if(mode==="hsla"){hsl[3]=alpha}return mode+"("+hsl.join(",")+")"};_input.css=function(h){return css2rgb(h)};chroma.css=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["css"]),(function(){}))};Color.prototype.css=function(mode){if(mode==null){mode="rgb"}if(mode.slice(0,3)==="rgb"){return rgb2css(this._rgb)}else if(mode.slice(0,3)==="hsl"){return hsl2css(this.hsl(),this.alpha())}};_input.named=function(name){return hex2rgb(w3cx11[name])};_guess_formats.push({p:5,test:function(n){if(arguments.length===1&&w3cx11[n]!=null){return"named"}}});Color.prototype.name=function(n){var h,k;if(arguments.length){if(w3cx11[n]){this._rgb=hex2rgb(w3cx11[n])}this._rgb[3]=1;this}h=this.hex("rgb");for(k in w3cx11){if(h===w3cx11[k]){return k}}return h};lch2lab=function(){var c,h,l,ref;ref=unpack(arguments),l=ref[0],c=ref[1],h=ref[2];h=h*DEG2RAD;return[l,cos(h)*c,sin(h)*c]};lch2rgb=function(){var L,a,args,b,c,g,h,l,r,ref,ref1;args=unpack(arguments);l=args[0],c=args[1],h=args[2];ref=lch2lab(l,c,h),L=ref[0],a=ref[1],b=ref[2];ref1=lab2rgb(L,a,b),r=ref1[0],g=ref1[1],b=ref1[2];return[r,g,b,args.length>3?args[3]:1]};lab2lch=function(){var a,b,c,h,l,ref;ref=unpack(arguments),l=ref[0],a=ref[1],b=ref[2];c=sqrt(a*a+b*b);h=(atan2(b,a)*RAD2DEG+360)%360;if(round(c*1e4)===0){h=Number.NaN}return[l,c,h]};rgb2lch=function(){var a,b,g,l,r,ref,ref1;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];ref1=rgb2lab(r,g,b),l=ref1[0],a=ref1[1],b=ref1[2];return lab2lch(l,a,b)};chroma.lch=function(){var args;args=unpack(arguments);return new Color(args,"lch")};chroma.hcl=function(){var args;args=unpack(arguments);return new Color(args,"hcl")};_input.lch=lch2rgb;_input.hcl=function(){var c,h,l,ref;ref=unpack(arguments),h=ref[0],c=ref[1],l=ref[2];return lch2rgb([l,c,h])};Color.prototype.lch=function(){return rgb2lch(this._rgb)};Color.prototype.hcl=function(){return rgb2lch(this._rgb).reverse()};rgb2cmyk=function(mode){var b,c,f,g,k,m,r,ref,y;if(mode==null){mode="rgb"}ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];r=r/255;g=g/255;b=b/255;k=1-Math.max(r,Math.max(g,b));f=k<1?1/(1-k):0;c=(1-r-k)*f;m=(1-g-k)*f;y=(1-b-k)*f;return[c,m,y,k]};cmyk2rgb=function(){var alpha,args,b,c,g,k,m,r,y;args=unpack(arguments);c=args[0],m=args[1],y=args[2],k=args[3];alpha=args.length>4?args[4]:1;if(k===1){return[0,0,0,alpha]}r=c>=1?0:255*(1-c)*(1-k);g=m>=1?0:255*(1-m)*(1-k);b=y>=1?0:255*(1-y)*(1-k);return[r,g,b,alpha]};_input.cmyk=function(){return cmyk2rgb(unpack(arguments))};chroma.cmyk=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["cmyk"]),(function(){}))};Color.prototype.cmyk=function(){return rgb2cmyk(this._rgb)};_input.gl=function(){var i,k,o,rgb,v;rgb=function(){var ref,results;ref=unpack(arguments);results=[];for(k in ref){v=ref[k];results.push(v)}return results}.apply(this,arguments);for(i=o=0;o<=2;i=++o){rgb[i]*=255}return rgb};chroma.gl=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["gl"]),(function(){}))};Color.prototype.gl=function(){var rgb;rgb=this._rgb;return[rgb[0]/255,rgb[1]/255,rgb[2]/255,rgb[3]]};rgb2luminance=function(r,g,b){var ref;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];r=luminance_x(r);g=luminance_x(g);b=luminance_x(b);return.2126*r+.7152*g+.0722*b};luminance_x=function(x){x/=255;if(x<=.03928){return x/12.92}else{return pow((x+.055)/1.055,2.4)}};interpolate_rgb=function(col1,col2,f,m){var xyz0,xyz1;xyz0=col1._rgb;xyz1=col2._rgb;return new Color(xyz0[0]+f*(xyz1[0]-xyz0[0]),xyz0[1]+f*(xyz1[1]-xyz0[1]),xyz0[2]+f*(xyz1[2]-xyz0[2]),m)};_interpolators.push(["rgb",interpolate_rgb]);Color.prototype.luminance=function(lum,mode){var cur_lum,eps,max_iter,rgba,test;if(mode==null){mode="rgb"}if(!arguments.length){return rgb2luminance(this._rgb)}rgba=this._rgb;if(lum===0){rgba=[0,0,0,this._rgb[3]]}else if(lum===1){rgba=[255,255,255,this[3]]}else{cur_lum=rgb2luminance(this._rgb);eps=1e-7;max_iter=20;test=function(l,h){var lm,m;m=l.interpolate(h,.5,mode);lm=m.luminance();if(Math.abs(lum-lm)<eps||!max_iter--){return m}if(lm>lum){return test(l,m)}return test(m,h)};if(cur_lum>lum){rgba=test(chroma("black"),this).rgba()}else{rgba=test(this,chroma("white")).rgba()}}return chroma(rgba).alpha(this.alpha())};temperature2rgb=function(kelvin){var b,g,r,temp;temp=kelvin/100;if(temp<66){r=255;g=-155.25485562709179-.44596950469579133*(g=temp-2)+104.49216199393888*log(g);b=temp<20?0:-254.76935184120902+.8274096064007395*(b=temp-10)+115.67994401066147*log(b)}else{r=351.97690566805693+.114206453784165*(r=temp-55)-40.25366309332127*log(r);g=325.4494125711974+.07943456536662342*(g=temp-50)-28.0852963507957*log(g);b=255}return[r,g,b]};rgb2temperature=function(){var b,eps,g,maxTemp,minTemp,r,ref,rgb,temp;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];minTemp=1e3;maxTemp=4e4;eps=.4;while(maxTemp-minTemp>eps){temp=(maxTemp+minTemp)*.5;rgb=temperature2rgb(temp);if(rgb[2]/rgb[0]>=b/r){maxTemp=temp}else{minTemp=temp}}return round(temp)};chroma.temperature=chroma.kelvin=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["temperature"]),(function(){}))};_input.temperature=_input.kelvin=_input.K=temperature2rgb;Color.prototype.temperature=function(){return rgb2temperature(this._rgb)};Color.prototype.kelvin=Color.prototype.temperature;chroma.contrast=function(a,b){var l1,l2,ref,ref1;if((ref=type(a))==="string"||ref==="number"){a=new Color(a)}if((ref1=type(b))==="string"||ref1==="number"){b=new Color(b)}l1=a.luminance();l2=b.luminance();if(l1>l2){return(l1+.05)/(l2+.05)}else{return(l2+.05)/(l1+.05)}};chroma.distance=function(a,b,mode){var d,i,l1,l2,ref,ref1,sum_sq;if(mode==null){mode="lab"}if((ref=type(a))==="string"||ref==="number"){a=new Color(a)}if((ref1=type(b))==="string"||ref1==="number"){b=new Color(b)}l1=a.get(mode);l2=b.get(mode);sum_sq=0;for(i in l1){d=(l1[i]||0)-(l2[i]||0);sum_sq+=d*d}return Math.sqrt(sum_sq)};chroma.deltaE=function(a,b,L,C){var L1,L2,a1,a2,b1,b2,c1,c2,c4,dH2,delA,delB,delC,delL,f,h1,ref,ref1,ref2,ref3,sc,sh,sl,t,v1,v2,v3;if(L==null){L=1}if(C==null){C=1}if((ref=type(a))==="string"||ref==="number"){a=new Color(a)}if((ref1=type(b))==="string"||ref1==="number"){b=new Color(b)}ref2=a.lab(),L1=ref2[0],a1=ref2[1],b1=ref2[2];ref3=b.lab(),L2=ref3[0],a2=ref3[1],b2=ref3[2];c1=sqrt(a1*a1+b1*b1);c2=sqrt(a2*a2+b2*b2);sl=L1<16?.511:.040975*L1/(1+.01765*L1);sc=.0638*c1/(1+.0131*c1)+.638;h1=c1<1e-6?0:atan2(b1,a1)*180/PI;while(h1<0){h1+=360}while(h1>=360){h1-=360}t=h1>=164&&h1<=345?.56+abs(.2*cos(PI*(h1+168)/180)):.36+abs(.4*cos(PI*(h1+35)/180));c4=c1*c1*c1*c1;f=sqrt(c4/(c4+1900));sh=sc*(f*t+1-f);delL=L1-L2;delC=c1-c2;delA=a1-a2;delB=b1-b2;dH2=delA*delA+delB*delB-delC*delC;v1=delL/(L*sl);v2=delC/(C*sc);v3=sh;return sqrt(v1*v1+v2*v2+dH2/(v3*v3))};Color.prototype.get=function(modechan){var channel,i,me,mode,ref,src;me=this;ref=modechan.split("."),mode=ref[0],channel=ref[1];src=me[mode]();if(channel){i=mode.indexOf(channel);if(i>-1){return src[i]}else{return console.warn("unknown channel "+channel+" in mode "+mode)}}else{return src}};Color.prototype.set=function(modechan,value){var channel,i,me,mode,ref,src;me=this;ref=modechan.split("."),mode=ref[0],channel=ref[1];if(channel){src=me[mode]();i=mode.indexOf(channel);if(i>-1){if(type(value)==="string"){switch(value.charAt(0)){case"+":src[i]+=+value;break;case"-":src[i]+=+value;break;case"*":src[i]*=+value.substr(1);break;case"/":src[i]/=+value.substr(1);break;default:src[i]=+value}}else{src[i]=value}}else{console.warn("unknown channel "+channel+" in mode "+mode)}}else{src=value}return chroma(src,mode).alpha(me.alpha())};Color.prototype.clipped=function(){return this._rgb._clipped||false};Color.prototype.alpha=function(a){if(arguments.length){return chroma.rgb([this._rgb[0],this._rgb[1],this._rgb[2],a])}return this._rgb[3]};Color.prototype.darken=function(amount){var lab,me;if(amount==null){amount=1}me=this;lab=me.lab();lab[0]-=LAB_CONSTANTS.Kn*amount;return chroma.lab(lab).alpha(me.alpha())};Color.prototype.brighten=function(amount){if(amount==null){amount=1}return this.darken(-amount)};Color.prototype.darker=Color.prototype.darken;Color.prototype.brighter=Color.prototype.brighten;Color.prototype.saturate=function(amount){var lch,me;if(amount==null){amount=1}me=this;lch=me.lch();lch[1]+=amount*LAB_CONSTANTS.Kn;if(lch[1]<0){lch[1]=0}return chroma.lch(lch).alpha(me.alpha())};Color.prototype.desaturate=function(amount){if(amount==null){amount=1}return this.saturate(-amount)};Color.prototype.premultiply=function(){var a,rgb;rgb=this.rgb();a=this.alpha();return chroma(rgb[0]*a,rgb[1]*a,rgb[2]*a,a)};blend=function(bottom,top,mode){if(!blend[mode]){throw"unknown blend mode "+mode}return blend[mode](bottom,top)};blend_f=function(f){return function(bottom,top){var c0,c1;c0=chroma(top).rgb();c1=chroma(bottom).rgb();return chroma(f(c0,c1),"rgb")}};each=function(f){return function(c0,c1){var i,o,out;out=[];for(i=o=0;o<=3;i=++o){out[i]=f(c0[i],c1[i])}return out}};normal=function(a,b){return a};multiply=function(a,b){return a*b/255};darken=function(a,b){if(a>b){return b}else{return a}};lighten=function(a,b){if(a>b){return a}else{return b}};screen=function(a,b){return 255*(1-(1-a/255)*(1-b/255))};overlay=function(a,b){if(b<128){return 2*a*b/255}else{return 255*(1-2*(1-a/255)*(1-b/255))}};burn=function(a,b){return 255*(1-(1-b/255)/(a/255))};dodge=function(a,b){if(a===255){return 255}a=255*(b/255)/(1-a/255);if(a>255){return 255}else{return a}};blend.normal=blend_f(each(normal));blend.multiply=blend_f(each(multiply));blend.screen=blend_f(each(screen));blend.overlay=blend_f(each(overlay));blend.darken=blend_f(each(darken));blend.lighten=blend_f(each(lighten));blend.dodge=blend_f(each(dodge));blend.burn=blend_f(each(burn));chroma.blend=blend;chroma.analyze=function(data){var len,o,r,val;r={min:Number.MAX_VALUE,max:Number.MAX_VALUE*-1,sum:0,values:[],count:0};for(o=0,len=data.length;o<len;o++){val=data[o];if(val!=null&&!isNaN(val)){r.values.push(val);r.sum+=val;if(val<r.min){r.min=val}if(val>r.max){r.max=val}r.count+=1}}r.domain=[r.min,r.max];r.limits=function(mode,num){return chroma.limits(r,mode,num)};return r};chroma.scale=function(colors,positions){var _classes,_colorCache,_colors,_correctLightness,_domain,_fixed,_gamma,_max,_min,_mode,_nacol,_out,_padding,_pos,_spread,_useCache,classifyValue,f,getClass,getColor,resetCache,setColors,tmap;_mode="rgb";_nacol=chroma("#ccc");_spread=0;_fixed=false;_domain=[0,1];_pos=[];_padding=[0,0];_classes=false;_colors=[];_out=false;_min=0;_max=1;_correctLightness=false;_colorCache={};_useCache=true;_gamma=1;setColors=function(colors){var c,col,o,ref,ref1,w;if(colors==null){colors=["#fff","#000"]}if(colors!=null&&type(colors)==="string"&&chroma.brewer!=null){colors=chroma.brewer[colors]||chroma.brewer[colors.toLowerCase()]||colors}if(type(colors)==="array"){if(colors.length===1){colors=[colors[0],colors[0]]}colors=colors.slice(0);for(c=o=0,ref=colors.length-1;0<=ref?o<=ref:o>=ref;c=0<=ref?++o:--o){col=colors[c];if(type(col)==="string"){colors[c]=chroma(col)}}_pos.length=0;for(c=w=0,ref1=colors.length-1;0<=ref1?w<=ref1:w>=ref1;c=0<=ref1?++w:--w){_pos.push(c/(colors.length-1))}}resetCache();return _colors=colors};getClass=function(value){var i,n;if(_classes!=null){n=_classes.length-1;i=0;while(i<n&&value>=_classes[i]){i++}return i-1}return 0};tmap=function(t){return t};classifyValue=function(value){var i,maxc,minc,n,val;val=value;if(_classes.length>2){n=_classes.length-1;i=getClass(value);minc=_classes[0]+(_classes[1]-_classes[0])*(0+_spread*.5);maxc=_classes[n-1]+(_classes[n]-_classes[n-1])*(1-_spread*.5);val=_min+(_classes[i]+(_classes[i+1]-_classes[i])*.5-minc)/(maxc-minc)*(_max-_min)}return val};getColor=function(val,bypassMap){var c,col,i,k,o,p,ref,t;if(bypassMap==null){bypassMap=false}if(isNaN(val)||val===null){return _nacol}if(!bypassMap){if(_classes&&_classes.length>2){c=getClass(val);t=c/(_classes.length-2)}else if(_max!==_min){t=(val-_min)/(_max-_min)}else{t=1}}else{t=val}if(!bypassMap){t=tmap(t)}if(_gamma!==1){t=pow(t,_gamma)}t=_padding[0]+t*(1-_padding[0]-_padding[1]);t=Math.min(1,Math.max(0,t));k=Math.floor(t*1e4);if(_useCache&&_colorCache[k]){col=_colorCache[k]}else{if(type(_colors)==="array"){for(i=o=0,ref=_pos.length-1;0<=ref?o<=ref:o>=ref;i=0<=ref?++o:--o){p=_pos[i];if(t<=p){col=_colors[i];break}if(t>=p&&i===_pos.length-1){col=_colors[i];break}if(t>p&&t<_pos[i+1]){t=(t-p)/(_pos[i+1]-p);col=chroma.interpolate(_colors[i],_colors[i+1],t,_mode);break}}}else if(type(_colors)==="function"){col=_colors(t)}if(_useCache){_colorCache[k]=col}}return col};resetCache=function(){return _colorCache={}};setColors(colors);f=function(v){var c;c=chroma(getColor(v));if(_out&&c[_out]){return c[_out]()}else{return c}};f.classes=function(classes){var d;if(classes!=null){if(type(classes)==="array"){_classes=classes;_domain=[classes[0],classes[classes.length-1]]}else{d=chroma.analyze(_domain);if(classes===0){_classes=[d.min,d.max]}else{_classes=chroma.limits(d,"e",classes)}}return f}return _classes};f.domain=function(domain){var c,d,k,len,o,ref,w;if(!arguments.length){return _domain}_min=domain[0];_max=domain[domain.length-1];_pos=[];k=_colors.length;if(domain.length===k&&_min!==_max){for(o=0,len=domain.length;o<len;o++){d=domain[o];_pos.push((d-_min)/(_max-_min))}}else{for(c=w=0,ref=k-1;0<=ref?w<=ref:w>=ref;c=0<=ref?++w:--w){_pos.push(c/(k-1))}}_domain=[_min,_max];return f};f.mode=function(_m){if(!arguments.length){return _mode}_mode=_m;resetCache();return f};f.range=function(colors,_pos){setColors(colors,_pos);return f};f.out=function(_o){_out=_o;return f};f.spread=function(val){if(!arguments.length){return _spread}_spread=val;return f};f.correctLightness=function(v){if(v==null){v=true}_correctLightness=v;resetCache();if(_correctLightness){tmap=function(t){var L0,L1,L_actual,L_diff,L_ideal,max_iter,pol,t0,t1;L0=getColor(0,true).lab()[0];L1=getColor(1,true).lab()[0];pol=L0>L1;L_actual=getColor(t,true).lab()[0];L_ideal=L0+(L1-L0)*t;L_diff=L_actual-L_ideal;t0=0;t1=1;max_iter=20;while(Math.abs(L_diff)>.01&&max_iter-- >0){(function(){if(pol){L_diff*=-1}if(L_diff<0){t0=t;t+=(t1-t)*.5}else{t1=t;t+=(t0-t)*.5}L_actual=getColor(t,true).lab()[0];return L_diff=L_actual-L_ideal})()}return t}}else{tmap=function(t){return t}}return f};f.padding=function(p){if(p!=null){if(type(p)==="number"){p=[p,p]}_padding=p;return f}else{return _padding}};f.colors=function(numColors,out){var dd,dm,i,o,ref,result,results,samples,w;if(arguments.length<2){out="hex"}result=[];if(arguments.length===0){result=_colors.slice(0)}else if(numColors===1){result=[f(.5)]}else if(numColors>1){dm=_domain[0];dd=_domain[1]-dm;result=function(){results=[];for(var o=0;0<=numColors?o<numColors:o>numColors;0<=numColors?o++:o--){results.push(o)}return results}.apply(this).map((function(i){return f(dm+i/(numColors-1)*dd)}))}else{colors=[];samples=[];if(_classes&&_classes.length>2){for(i=w=1,ref=_classes.length;1<=ref?w<ref:w>ref;i=1<=ref?++w:--w){samples.push((_classes[i-1]+_classes[i])*.5)}}else{samples=_domain}result=samples.map((function(v){return f(v)}))}if(chroma[out]){result=result.map((function(c){return c[out]()}))}return result};f.cache=function(c){if(c!=null){_useCache=c;return f}else{return _useCache}};f.gamma=function(g){if(g!=null){_gamma=g;return f}else{return _gamma}};f.nodata=function(d){if(d!=null){_nacol=chroma(d);return f}else{return _nacol}};return f};if(chroma.scales==null){chroma.scales={}}chroma.scales.cool=function(){return chroma.scale([chroma.hsl(180,1,.9),chroma.hsl(250,.7,.4)])};chroma.scales.hot=function(){return chroma.scale(["#000","#f00","#ff0","#fff"],[0,.25,.75,1]).mode("rgb")};chroma.analyze=function(data,key,filter){var add,k,len,o,r,val,visit;r={min:Number.MAX_VALUE,max:Number.MAX_VALUE*-1,sum:0,values:[],count:0};if(filter==null){filter=function(){return true}}add=function(val){if(val!=null&&!isNaN(val)){r.values.push(val);r.sum+=val;if(val<r.min){r.min=val}if(val>r.max){r.max=val}r.count+=1}};visit=function(val,k){if(filter(val,k)){if(key!=null&&type(key)==="function"){return add(key(val))}else if(key!=null&&type(key)==="string"||type(key)==="number"){return add(val[key])}else{return add(val)}}};if(type(data)==="array"){for(o=0,len=data.length;o<len;o++){val=data[o];visit(val)}}else{for(k in data){val=data[k];visit(val,k)}}r.domain=[r.min,r.max];r.limits=function(mode,num){return chroma.limits(r,mode,num)};return r};chroma.limits=function(data,mode,num){var aa,ab,ac,ad,ae,af,ag,ah,ai,aj,ak,al,am,assignments,best,centroids,cluster,clusterSizes,dist,i,j,kClusters,limits,max_log,min,min_log,mindist,n,nb_iters,newCentroids,o,p,pb,pr,ref,ref1,ref10,ref11,ref12,ref13,ref14,ref2,ref3,ref4,ref5,ref6,ref7,ref8,ref9,repeat,sum,tmpKMeansBreaks,v,value,values,w;if(mode==null){mode="equal"}if(num==null){num=7}if(type(data)==="array"){data=chroma.analyze(data)}min=data.min;max=data.max;sum=data.sum;values=data.values.sort((function(a,b){return a-b}));if(num===1){return[min,max]}limits=[];if(mode.substr(0,1)==="c"){limits.push(min);limits.push(max)}if(mode.substr(0,1)==="e"){limits.push(min);for(i=o=1,ref=num-1;1<=ref?o<=ref:o>=ref;i=1<=ref?++o:--o){limits.push(min+i/num*(max-min))}limits.push(max)}else if(mode.substr(0,1)==="l"){if(min<=0){throw"Logarithmic scales are only possible for values > 0"}min_log=Math.LOG10E*log(min);max_log=Math.LOG10E*log(max);limits.push(min);for(i=w=1,ref1=num-1;1<=ref1?w<=ref1:w>=ref1;i=1<=ref1?++w:--w){limits.push(pow(10,min_log+i/num*(max_log-min_log)))}limits.push(max)}else if(mode.substr(0,1)==="q"){limits.push(min);for(i=aa=1,ref2=num-1;1<=ref2?aa<=ref2:aa>=ref2;i=1<=ref2?++aa:--aa){p=(values.length-1)*i/num;pb=floor(p);if(pb===p){limits.push(values[pb])}else{pr=p-pb;limits.push(values[pb]*(1-pr)+values[pb+1]*pr)}}limits.push(max)}else if(mode.substr(0,1)==="k"){n=values.length;assignments=new Array(n);clusterSizes=new Array(num);repeat=true;nb_iters=0;centroids=null;centroids=[];centroids.push(min);for(i=ab=1,ref3=num-1;1<=ref3?ab<=ref3:ab>=ref3;i=1<=ref3?++ab:--ab){centroids.push(min+i/num*(max-min))}centroids.push(max);while(repeat){for(j=ac=0,ref4=num-1;0<=ref4?ac<=ref4:ac>=ref4;j=0<=ref4?++ac:--ac){clusterSizes[j]=0}for(i=ad=0,ref5=n-1;0<=ref5?ad<=ref5:ad>=ref5;i=0<=ref5?++ad:--ad){value=values[i];mindist=Number.MAX_VALUE;for(j=ae=0,ref6=num-1;0<=ref6?ae<=ref6:ae>=ref6;j=0<=ref6?++ae:--ae){dist=abs(centroids[j]-value);if(dist<mindist){mindist=dist;best=j}}clusterSizes[best]++;assignments[i]=best}newCentroids=new Array(num);for(j=af=0,ref7=num-1;0<=ref7?af<=ref7:af>=ref7;j=0<=ref7?++af:--af){newCentroids[j]=null}for(i=ag=0,ref8=n-1;0<=ref8?ag<=ref8:ag>=ref8;i=0<=ref8?++ag:--ag){cluster=assignments[i];if(newCentroids[cluster]===null){newCentroids[cluster]=values[i]}else{newCentroids[cluster]+=values[i]}}for(j=ah=0,ref9=num-1;0<=ref9?ah<=ref9:ah>=ref9;j=0<=ref9?++ah:--ah){newCentroids[j]*=1/clusterSizes[j]}repeat=false;for(j=ai=0,ref10=num-1;0<=ref10?ai<=ref10:ai>=ref10;j=0<=ref10?++ai:--ai){if(newCentroids[j]!==centroids[i]){repeat=true;break}}centroids=newCentroids;nb_iters++;if(nb_iters>200){repeat=false}}kClusters={};for(j=aj=0,ref11=num-1;0<=ref11?aj<=ref11:aj>=ref11;j=0<=ref11?++aj:--aj){kClusters[j]=[]}for(i=ak=0,ref12=n-1;0<=ref12?ak<=ref12:ak>=ref12;i=0<=ref12?++ak:--ak){cluster=assignments[i];kClusters[cluster].push(values[i])}tmpKMeansBreaks=[];for(j=al=0,ref13=num-1;0<=ref13?al<=ref13:al>=ref13;j=0<=ref13?++al:--al){tmpKMeansBreaks.push(kClusters[j][0]);tmpKMeansBreaks.push(kClusters[j][kClusters[j].length-1])}tmpKMeansBreaks=tmpKMeansBreaks.sort((function(a,b){return a-b}));limits.push(tmpKMeansBreaks[0]);for(i=am=1,ref14=tmpKMeansBreaks.length-1;am<=ref14;i=am+=2){v=tmpKMeansBreaks[i];if(!isNaN(v)&&limits.indexOf(v)===-1){limits.push(v)}}}return limits};hsi2rgb=function(h,s,i){var args,b,g,r;args=unpack(arguments);h=args[0],s=args[1],i=args[2];if(isNaN(h)){h=0}h/=360;if(h<1/3){b=(1-s)/3;r=(1+s*cos(TWOPI*h)/cos(PITHIRD-TWOPI*h))/3;g=1-(b+r)}else if(h<2/3){h-=1/3;r=(1-s)/3;g=(1+s*cos(TWOPI*h)/cos(PITHIRD-TWOPI*h))/3;b=1-(r+g)}else{h-=2/3;g=(1-s)/3;b=(1+s*cos(TWOPI*h)/cos(PITHIRD-TWOPI*h))/3;r=1-(g+b)}r=limit(i*r*3);g=limit(i*g*3);b=limit(i*b*3);return[r*255,g*255,b*255,args.length>3?args[3]:1]};rgb2hsi=function(){var b,g,h,i,min,r,ref,s;ref=unpack(arguments),r=ref[0],g=ref[1],b=ref[2];TWOPI=Math.PI*2;r/=255;g/=255;b/=255;min=Math.min(r,g,b);i=(r+g+b)/3;s=1-min/i;if(s===0){h=0}else{h=(r-g+(r-b))/2;h/=Math.sqrt((r-g)*(r-g)+(r-b)*(g-b));h=Math.acos(h);if(b>g){h=TWOPI-h}h/=TWOPI}return[h*360,s,i]};chroma.hsi=function(){return function(func,args,ctor){ctor.prototype=func.prototype;var child=new ctor,result=func.apply(child,args);return Object(result)===result?result:child}(Color,slice.call(arguments).concat(["hsi"]),(function(){}))};_input.hsi=hsi2rgb;Color.prototype.hsi=function(){return rgb2hsi(this._rgb)};interpolate_hsx=function(col1,col2,f,m){var dh,hue,hue0,hue1,lbv,lbv0,lbv1,res,sat,sat0,sat1,xyz0,xyz1;if(m==="hsl"){xyz0=col1.hsl();xyz1=col2.hsl()}else if(m==="hsv"){xyz0=col1.hsv();xyz1=col2.hsv()}else if(m==="hcg"){xyz0=col1.hcg();xyz1=col2.hcg()}else if(m==="hsi"){xyz0=col1.hsi();xyz1=col2.hsi()}else if(m==="lch"||m==="hcl"){m="hcl";xyz0=col1.hcl();xyz1=col2.hcl()}if(m.substr(0,1)==="h"){hue0=xyz0[0],sat0=xyz0[1],lbv0=xyz0[2];hue1=xyz1[0],sat1=xyz1[1],lbv1=xyz1[2]}if(!isNaN(hue0)&&!isNaN(hue1)){if(hue1>hue0&&hue1-hue0>180){dh=hue1-(hue0+360)}else if(hue1<hue0&&hue0-hue1>180){dh=hue1+360-hue0}else{dh=hue1-hue0}hue=hue0+f*dh}else if(!isNaN(hue0)){hue=hue0;if((lbv1===1||lbv1===0)&&m!=="hsv"){sat=sat0}}else if(!isNaN(hue1)){hue=hue1;if((lbv0===1||lbv0===0)&&m!=="hsv"){sat=sat1}}else{hue=Number.NaN}if(sat==null){sat=sat0+f*(sat1-sat0)}lbv=lbv0+f*(lbv1-lbv0);return res=chroma[m](hue,sat,lbv)};_interpolators=_interpolators.concat(function(){var len,o,ref,results;ref=["hsv","hsl","hsi","hcl","lch","hcg"];results=[];for(o=0,len=ref.length;o<len;o++){m=ref[o];results.push([m,interpolate_hsx])}return results}());interpolate_num=function(col1,col2,f,m){var n1,n2;n1=col1.num();n2=col2.num();return chroma.num(n1+(n2-n1)*f,"num")};_interpolators.push(["num",interpolate_num]);interpolate_lab=function(col1,col2,f,m){var res,xyz0,xyz1;xyz0=col1.lab();xyz1=col2.lab();return res=new Color(xyz0[0]+f*(xyz1[0]-xyz0[0]),xyz0[1]+f*(xyz1[1]-xyz0[1]),xyz0[2]+f*(xyz1[2]-xyz0[2]),m)};_interpolators.push(["lab",interpolate_lab])}).call(this)}).call(this,__webpack_require__(51)(module))},406:function(module,exports,__webpack_require__){var baseSet=__webpack_require__(283);function set(object,path,value){return object==null?object:baseSet(object,path,value)}module.exports=set},407:function(module,exports,__webpack_require__){var baseAssignValue=__webpack_require__(408),eq=__webpack_require__(286);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function assignValue(object,key,value){var objValue=object[key];if(!(hasOwnProperty.call(object,key)&&eq(objValue,value))||value===undefined&&!(key in object)){baseAssignValue(object,key,value)}}module.exports=assignValue},408:function(module,exports,__webpack_require__){var defineProperty=__webpack_require__(409);function baseAssignValue(object,key,value){if(key=="__proto__"&&defineProperty){defineProperty(object,key,{configurable:true,enumerable:true,value:value,writable:true})}else{object[key]=value}}module.exports=baseAssignValue},409:function(module,exports,__webpack_require__){var getNative=__webpack_require__(248);var defineProperty=function(){try{var func=getNative(Object,"defineProperty");func({},"",{});return func}catch(e){}}();module.exports=defineProperty},410:function(module,exports,__webpack_require__){var isFunction=__webpack_require__(284),isMasked=__webpack_require__(414),isObject=__webpack_require__(251),toSource=__webpack_require__(416);var reRegExpChar=/[\\^$.*+?()[\]{}|]/g;var reIsHostCtor=/^\[object .+?Constructor\]$/;var funcProto=Function.prototype,objectProto=Object.prototype;var funcToString=funcProto.toString;var hasOwnProperty=objectProto.hasOwnProperty;var reIsNative=RegExp("^"+funcToString.call(hasOwnProperty).replace(reRegExpChar,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");function baseIsNative(value){if(!isObject(value)||isMasked(value)){return false}var pattern=isFunction(value)?reIsNative:reIsHostCtor;return pattern.test(toSource(value))}module.exports=baseIsNative},411:function(module,exports,__webpack_require__){(function(global){var freeGlobal=typeof global=="object"&&global&&global.Object===Object&&global;module.exports=freeGlobal}).call(this,__webpack_require__(52))},412:function(module,exports,__webpack_require__){var Symbol=__webpack_require__(249);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;var nativeObjectToString=objectProto.toString;var symToStringTag=Symbol?Symbol.toStringTag:undefined;function getRawTag(value){var isOwn=hasOwnProperty.call(value,symToStringTag),tag=value[symToStringTag];try{value[symToStringTag]=undefined;var unmasked=true}catch(e){}var result=nativeObjectToString.call(value);if(unmasked){if(isOwn){value[symToStringTag]=tag}else{delete value[symToStringTag]}}return result}module.exports=getRawTag},413:function(module,exports){var objectProto=Object.prototype;var nativeObjectToString=objectProto.toString;function objectToString(value){return nativeObjectToString.call(value)}module.exports=objectToString},414:function(module,exports,__webpack_require__){var coreJsData=__webpack_require__(415);var maskSrcKey=function(){var uid=/[^.]+$/.exec(coreJsData&&coreJsData.keys&&coreJsData.keys.IE_PROTO||"");return uid?"Symbol(src)_1."+uid:""}();function isMasked(func){return!!maskSrcKey&&maskSrcKey in func}module.exports=isMasked},415:function(module,exports,__webpack_require__){var root=__webpack_require__(250);var coreJsData=root["__core-js_shared__"];module.exports=coreJsData},416:function(module,exports){var funcProto=Function.prototype;var funcToString=funcProto.toString;function toSource(func){if(func!=null){try{return funcToString.call(func)}catch(e){}try{return func+""}catch(e){}}return""}module.exports=toSource},417:function(module,exports){function getValue(object,key){return object==null?undefined:object[key]}module.exports=getValue},418:function(module,exports,__webpack_require__){var isArray=__webpack_require__(252),isKey=__webpack_require__(419),stringToPath=__webpack_require__(421),toString=__webpack_require__(444);function castPath(value,object){if(isArray(value)){return value}return isKey(value,object)?[value]:stringToPath(toString(value))}module.exports=castPath},419:function(module,exports,__webpack_require__){var isArray=__webpack_require__(252),isSymbol=__webpack_require__(253);var reIsDeepProp=/\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/,reIsPlainProp=/^\w*$/;function isKey(value,object){if(isArray(value)){return false}var type=typeof value;if(type=="number"||type=="symbol"||type=="boolean"||value==null||isSymbol(value)){return true}return reIsPlainProp.test(value)||!reIsDeepProp.test(value)||object!=null&&value in Object(object)}module.exports=isKey},420:function(module,exports){function isObjectLike(value){return value!=null&&typeof value=="object"}module.exports=isObjectLike},421:function(module,exports,__webpack_require__){var memoizeCapped=__webpack_require__(422);var rePropName=/[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;var reEscapeChar=/\\(\\)?/g;var stringToPath=memoizeCapped((function(string){var result=[];if(string.charCodeAt(0)===46){result.push("")}string.replace(rePropName,(function(match,number,quote,subString){result.push(quote?subString.replace(reEscapeChar,"$1"):number||match)}));return result}));module.exports=stringToPath},422:function(module,exports,__webpack_require__){var memoize=__webpack_require__(423);var MAX_MEMOIZE_SIZE=500;function memoizeCapped(func){var result=memoize(func,(function(key){if(cache.size===MAX_MEMOIZE_SIZE){cache.clear()}return key}));var cache=result.cache;return result}module.exports=memoizeCapped},423:function(module,exports,__webpack_require__){var MapCache=__webpack_require__(424);var FUNC_ERROR_TEXT="Expected a function";function memoize(func,resolver){if(typeof func!="function"||resolver!=null&&typeof resolver!="function"){throw new TypeError(FUNC_ERROR_TEXT)}var memoized=function(){var args=arguments,key=resolver?resolver.apply(this,args):args[0],cache=memoized.cache;if(cache.has(key)){return cache.get(key)}var result=func.apply(this,args);memoized.cache=cache.set(key,result)||cache;return result};memoized.cache=new(memoize.Cache||MapCache);return memoized}memoize.Cache=MapCache;module.exports=memoize},424:function(module,exports,__webpack_require__){var mapCacheClear=__webpack_require__(425),mapCacheDelete=__webpack_require__(439),mapCacheGet=__webpack_require__(441),mapCacheHas=__webpack_require__(442),mapCacheSet=__webpack_require__(443);function MapCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}MapCache.prototype.clear=mapCacheClear;MapCache.prototype["delete"]=mapCacheDelete;MapCache.prototype.get=mapCacheGet;MapCache.prototype.has=mapCacheHas;MapCache.prototype.set=mapCacheSet;module.exports=MapCache},425:function(module,exports,__webpack_require__){var Hash=__webpack_require__(426),ListCache=__webpack_require__(432),Map=__webpack_require__(438);function mapCacheClear(){this.size=0;this.__data__={hash:new Hash,map:new(Map||ListCache),string:new Hash}}module.exports=mapCacheClear},426:function(module,exports,__webpack_require__){var hashClear=__webpack_require__(427),hashDelete=__webpack_require__(428),hashGet=__webpack_require__(429),hashHas=__webpack_require__(430),hashSet=__webpack_require__(431);function Hash(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}Hash.prototype.clear=hashClear;Hash.prototype["delete"]=hashDelete;Hash.prototype.get=hashGet;Hash.prototype.has=hashHas;Hash.prototype.set=hashSet;module.exports=Hash},427:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(234);function hashClear(){this.__data__=nativeCreate?nativeCreate(null):{};this.size=0}module.exports=hashClear},428:function(module,exports){function hashDelete(key){var result=this.has(key)&&delete this.__data__[key];this.size-=result?1:0;return result}module.exports=hashDelete},429:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(234);var HASH_UNDEFINED="__lodash_hash_undefined__";var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function hashGet(key){var data=this.__data__;if(nativeCreate){var result=data[key];return result===HASH_UNDEFINED?undefined:result}return hasOwnProperty.call(data,key)?data[key]:undefined}module.exports=hashGet},430:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(234);var objectProto=Object.prototype;var hasOwnProperty=objectProto.hasOwnProperty;function hashHas(key){var data=this.__data__;return nativeCreate?data[key]!==undefined:hasOwnProperty.call(data,key)}module.exports=hashHas},431:function(module,exports,__webpack_require__){var nativeCreate=__webpack_require__(234);var HASH_UNDEFINED="__lodash_hash_undefined__";function hashSet(key,value){var data=this.__data__;this.size+=this.has(key)?0:1;data[key]=nativeCreate&&value===undefined?HASH_UNDEFINED:value;return this}module.exports=hashSet},432:function(module,exports,__webpack_require__){var listCacheClear=__webpack_require__(433),listCacheDelete=__webpack_require__(434),listCacheGet=__webpack_require__(435),listCacheHas=__webpack_require__(436),listCacheSet=__webpack_require__(437);function ListCache(entries){var index=-1,length=entries==null?0:entries.length;this.clear();while(++index<length){var entry=entries[index];this.set(entry[0],entry[1])}}ListCache.prototype.clear=listCacheClear;ListCache.prototype["delete"]=listCacheDelete;ListCache.prototype.get=listCacheGet;ListCache.prototype.has=listCacheHas;ListCache.prototype.set=listCacheSet;module.exports=ListCache},433:function(module,exports){function listCacheClear(){this.__data__=[];this.size=0}module.exports=listCacheClear},434:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(235);var arrayProto=Array.prototype;var splice=arrayProto.splice;function listCacheDelete(key){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){return false}var lastIndex=data.length-1;if(index==lastIndex){data.pop()}else{splice.call(data,index,1)}--this.size;return true}module.exports=listCacheDelete},435:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(235);function listCacheGet(key){var data=this.__data__,index=assocIndexOf(data,key);return index<0?undefined:data[index][1]}module.exports=listCacheGet},436:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(235);function listCacheHas(key){return assocIndexOf(this.__data__,key)>-1}module.exports=listCacheHas},437:function(module,exports,__webpack_require__){var assocIndexOf=__webpack_require__(235);function listCacheSet(key,value){var data=this.__data__,index=assocIndexOf(data,key);if(index<0){++this.size;data.push([key,value])}else{data[index][1]=value}return this}module.exports=listCacheSet},438:function(module,exports,__webpack_require__){var getNative=__webpack_require__(248),root=__webpack_require__(250);var Map=getNative(root,"Map");module.exports=Map},439:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(236);function mapCacheDelete(key){var result=getMapData(this,key)["delete"](key);this.size-=result?1:0;return result}module.exports=mapCacheDelete},440:function(module,exports){function isKeyable(value){var type=typeof value;return type=="string"||type=="number"||type=="symbol"||type=="boolean"?value!=="__proto__":value===null}module.exports=isKeyable},441:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(236);function mapCacheGet(key){return getMapData(this,key).get(key)}module.exports=mapCacheGet},442:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(236);function mapCacheHas(key){return getMapData(this,key).has(key)}module.exports=mapCacheHas},443:function(module,exports,__webpack_require__){var getMapData=__webpack_require__(236);function mapCacheSet(key,value){var data=getMapData(this,key),size=data.size;data.set(key,value);this.size+=data.size==size?0:1;return this}module.exports=mapCacheSet},444:function(module,exports,__webpack_require__){var baseToString=__webpack_require__(445);function toString(value){return value==null?"":baseToString(value)}module.exports=toString},445:function(module,exports,__webpack_require__){var Symbol=__webpack_require__(249),arrayMap=__webpack_require__(446),isArray=__webpack_require__(252),isSymbol=__webpack_require__(253);var INFINITY=1/0;var symbolProto=Symbol?Symbol.prototype:undefined,symbolToString=symbolProto?symbolProto.toString:undefined;function baseToString(value){if(typeof value=="string"){return value}if(isArray(value)){return arrayMap(value,baseToString)+""}if(isSymbol(value)){return symbolToString?symbolToString.call(value):""}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}module.exports=baseToString},446:function(module,exports){function arrayMap(array,iteratee){var index=-1,length=array==null?0:array.length,result=Array(length);while(++index<length){result[index]=iteratee(array[index],index,array)}return result}module.exports=arrayMap},447:function(module,exports){var MAX_SAFE_INTEGER=9007199254740991;var reIsUint=/^(?:0|[1-9]\d*)$/;function isIndex(value,length){var type=typeof value;length=length==null?MAX_SAFE_INTEGER:length;return!!length&&(type=="number"||type!="symbol"&&reIsUint.test(value))&&(value>-1&&value%1==0&&value<length)}module.exports=isIndex},448:function(module,exports,__webpack_require__){var isSymbol=__webpack_require__(253);var INFINITY=1/0;function toKey(value){if(typeof value=="string"||isSymbol(value)){return value}var result=value+"";return result=="0"&&1/value==-INFINITY?"-0":result}module.exports=toKey},449:function(module,exports,__webpack_require__){var baseSet=__webpack_require__(283);function setWith(object,path,value,customizer){customizer=typeof customizer=="function"?customizer:undefined;return object==null?object:baseSet(object,path,value,customizer)}module.exports=setWith}}]);