/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["canvas_bundle_jsonpfunction"]=window["canvas_bundle_jsonpfunction"]||[]).push([[0],{213:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"h",(function(){return useServices}));__webpack_require__.d(__webpack_exports__,"g",(function(){return useNotifyService}));__webpack_require__.d(__webpack_exports__,"i",(function(){return withServices}));__webpack_require__.d(__webpack_exports__,"a",(function(){return ServicesProvider}));__webpack_require__.d(__webpack_exports__,"e",(function(){return services}));__webpack_require__.d(__webpack_exports__,"f",(function(){return startServices}));__webpack_require__.d(__webpack_exports__,"c",(function(){return notifyService}));__webpack_require__.d(__webpack_exports__,"d",(function(){return platformService}));__webpack_require__.d(__webpack_exports__,"b",(function(){return expressionsService}));var external_kbnSharedDeps_Lodash_=__webpack_require__(4);var public_=__webpack_require__(205);const getToast=(err,opts={})=>{const errData=Object(external_kbnSharedDeps_Lodash_["get"])(err,"response")||err;const errMsg=Object(public_["formatMsg"])(errData);const{title:title,...rest}=opts;let text;if(title){text=errMsg}return{...rest,title:title||errMsg,text:text}};const notifyServiceFactory=(setup,start)=>{const toasts=start.notifications.toasts;return{error(err,opts){toasts.addDanger(getToast(err,opts))},warning(err,opts){toasts.addWarning(getToast(err,opts))},info(err,opts){toasts.add(getToast(err,opts))},success(err,opts){toasts.addSuccess(getToast(err,opts))}}};const platformServiceFactory=(_coreSetup,coreStart)=>({getBasePath:coreStart.http.basePath.get,getBasePathInterface:()=>coreStart.http.basePath,getElasticWebsiteUrl:()=>coreStart.docLinks.ELASTIC_WEBSITE_URL,getDocLinkVersion:()=>coreStart.docLinks.DOC_LINK_VERSION,getHasWriteAccess:()=>coreStart.application.capabilities.canvas.save,getUISetting:coreStart.uiSettings.get.bind(coreStart.uiSettings),setBreadcrumbs:coreStart.chrome.setBreadcrumbs,setRecentlyAccessed:coreStart.chrome.recentlyAccessed.add,setFullscreen:coreStart.chrome.setIsVisible,getSavedObjects:()=>coreStart.savedObjects,getSavedObjectsClient:()=>coreStart.savedObjects.client,getUISettings:()=>coreStart.uiSettings});var constants=__webpack_require__(7);var storage=__webpack_require__(50);const navLinkServiceFactory=(coreSetup,_coreStart,_setupPlugins,_startPlugins,appUpdater)=>({updatePath:path=>{appUpdater.next(()=>({defaultPath:`#${path}`}));Object(storage["b"])().set(`${constants["z"]}:${coreSetup.http.basePath.get()}`,path)}});const embeddablesServiceFactory=async(_coreSetup,_coreStart,_setupPlugins,startPlugins)=>({getEmbeddableFactories:startPlugins.embeddable.getEmbeddableFactories});var common_=__webpack_require__(13);const expressionsServiceFactory=async(coreSetup,coreStart,setupPlugins,startPlugins)=>{const{expressions:expressions,bfetch:bfetch}=setupPlugins;let cached=null;const loadServerFunctionWrappers=async()=>{if(!cached){cached=(async()=>{const serverFunctionList=await coreSetup.http.get(constants["c"]);const batchedFunction=bfetch.batchedFunction({url:constants["c"]});const{serialize:serialize}=Object(common_["serializeProvider"])(expressions.getTypes());Object.keys(serverFunctionList).forEach(functionName=>{if(expressions.getFunction(functionName)){return}const fn=()=>({...serverFunctionList[functionName],fn:(input,args)=>batchedFunction({functionName:functionName,args:args,context:serialize(input)})});expressions.registerFunction(fn)})})()}return cached};await loadServerFunctionWrappers();return setupPlugins.expressions.fork()};var external_kbnSharedDeps_React_=__webpack_require__(3);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);const defaultContextValue={embeddables:{},expressions:{},notify:{},platform:{},navLink:{}};const context=Object(external_kbnSharedDeps_React_["createContext"])(defaultContextValue);const useServices=()=>Object(external_kbnSharedDeps_React_["useContext"])(context);const usePlatformService=()=>useServices().platform;const useEmbeddablesService=()=>useServices().embeddables;const useExpressionsService=()=>useServices().expressions;const useNotifyService=()=>useServices().notify;const useNavLinkService=()=>useServices().navLink;const withServices=type=>{const EnhancedType=props=>Object(external_kbnSharedDeps_React_["createElement"])(type,{...props,services:useServices()});return EnhancedType};const ServicesProvider=({providers:providers={},children:children})=>{const specifiedProviders={...services,...providers};const value={embeddables:specifiedProviders.embeddables.getService(),expressions:specifiedProviders.expressions.getService(),notify:specifiedProviders.notify.getService(),platform:specifiedProviders.platform.getService(),navLink:specifiedProviders.navLink.getService()};return external_kbnSharedDeps_React_default.a.createElement(context.Provider,{value:value},children)};function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class CanvasServiceProvider{constructor(factory){_defineProperty(this,"factory",void 0);_defineProperty(this,"service",void 0);this.factory=factory}setService(service){this.service=service}async start(coreSetup,coreStart,canvasSetupPlugins,canvasStartPlugins,appUpdater){this.service=await this.factory(coreSetup,coreStart,canvasSetupPlugins,canvasStartPlugins,appUpdater)}getService(){if(!this.service){throw new Error("Service not ready")}return this.service}stop(){this.service=undefined}}const services={embeddables:new CanvasServiceProvider(embeddablesServiceFactory),expressions:new CanvasServiceProvider(expressionsServiceFactory),notify:new CanvasServiceProvider(notifyServiceFactory),platform:new CanvasServiceProvider(platformServiceFactory),navLink:new CanvasServiceProvider(navLinkServiceFactory)};const startServices=async(coreSetup,coreStart,canvasSetupPlugins,canvasStartPlugins,appUpdater)=>{const startPromises=Object.values(services).map(provider=>provider.start(coreSetup,coreStart,canvasSetupPlugins,canvasStartPlugins,appUpdater));await Promise.all(startPromises)};const stopServices=()=>{Object.values(services).forEach(provider=>provider.stop())};const{embeddables:embeddableService,notify:notifyService,platform:platformService,navLink:navLinkService,expressions:expressionsService}=services},214:function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(237)()}},215:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return templateFromReactComponent}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var react_dom__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(5);var react_dom__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_1__);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(203);var _kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__);var _components_enhance_error_boundary__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(231);const templateFromReactComponent=Component=>{const WrappedComponent=props=>react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_components_enhance_error_boundary__WEBPACK_IMPORTED_MODULE_3__["a"],null,({error:error})=>{if(error){props.renderError();return null}return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_kbn_i18n_react__WEBPACK_IMPORTED_MODULE_2__["I18nProvider"],null,react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Component,props))});return(domNode,config,handlers)=>{try{const el=react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(WrappedComponent,config);Object(react_dom__WEBPACK_IMPORTED_MODULE_1__["render"])(el,domNode,()=>{handlers.done()});handlers.onDestroy(()=>{Object(react_dom__WEBPACK_IMPORTED_MODULE_1__["unmountComponentAtNode"])(domNode)})}catch(err){handlers.done();config.renderError()}}}},218:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getState}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getValue}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getError}));var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_0__);function getState(resolvedArg){return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["get"])(resolvedArg,"state",null)}function getValue(resolvedArg){return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["get"])(resolvedArg,"value",null)}function getError(resolvedArg){if(getState(resolvedArg)!=="error"){return null}return Object(lodash__WEBPACK_IMPORTED_MODULE_0__["get"])(resolvedArg,"error",null)}},221:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return createStatefulPropHoc}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const getDisplayName=Comp=>Comp.displayName||Comp.name||"UnnamedComponent";function createStatefulPropHoc(fieldname,updater="updateValue"){return Comp=>{class WrappedControlledInput extends react__WEBPACK_IMPORTED_MODULE_0___default.a.PureComponent{constructor(props){super(props);_defineProperty(this,"handleChange",ev=>{if(ev.target){this.setState({value:ev.target.value})}else{this.setState({value:ev})}});this.state={value:props[fieldname]}}UNSAFE_componentWillReceiveProps(nextProps){this.setState({value:nextProps[fieldname]})}render(){const passedProps={...this.props,[fieldname]:this.state.value,[updater]:this.handleChange};return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(Comp,passedProps)}}WrappedControlledInput.displayName=`statefulProp(${getDisplayName(Comp)})`;return WrappedControlledInput}}},227:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"b",(function(){return getFields}));__webpack_require__.d(__webpack_exports__,"c",(function(){return getIndices}));__webpack_require__.d(__webpack_exports__,"a",(function(){return getDefaultIndex}));var _common_lib_constants__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(7);var _common_lib_fetch__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(45);var _i18n__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(2);var _services__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(213);const{esService:strings}=_i18n__WEBPACK_IMPORTED_MODULE_2__["g"];const getApiPath=function(){const basePath=_services__WEBPACK_IMPORTED_MODULE_3__["d"].getService().getBasePath();return basePath+_common_lib_constants__WEBPACK_IMPORTED_MODULE_0__["a"]};const getSavedObjectsClient=function(){return _services__WEBPACK_IMPORTED_MODULE_3__["d"].getService().getSavedObjectsClient()};const getAdvancedSettings=function(){return _services__WEBPACK_IMPORTED_MODULE_3__["d"].getService().getUISettings()};const getFields=(index="_all")=>_common_lib_fetch__WEBPACK_IMPORTED_MODULE_1__["b"].get(`${getApiPath()}/es_fields?index=${index}`).then(({data:mapping})=>Object.keys(mapping).filter(field=>!field.startsWith("_")).sort()).catch(err=>_services__WEBPACK_IMPORTED_MODULE_3__["c"].getService().error(err,{title:strings.getFieldsFetchErrorMessage(index)}));const getIndices=()=>getSavedObjectsClient().find({type:"index-pattern",fields:["title"],searchFields:["title"],perPage:1e3}).then(resp=>resp.savedObjects.map(savedObject=>savedObject.attributes.title)).catch(err=>_services__WEBPACK_IMPORTED_MODULE_3__["c"].getService().error(err,{title:strings.getIndicesFetchErrorMessage()}));const getDefaultIndex=()=>{const defaultIndexId=getAdvancedSettings().get("defaultIndex");return defaultIndexId?getSavedObjectsClient().get("index-pattern",defaultIndexId).then(defaultIndex=>defaultIndex.attributes.title).catch(err=>_services__WEBPACK_IMPORTED_MODULE_3__["c"].getService().error(err,{title:strings.getDefaultIndexFetchErrorMessage()})):Promise.resolve("")}},231:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return ErrorBoundary}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var recompose__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(20);var recompose__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(recompose__WEBPACK_IMPORTED_MODULE_1__);var prop_types__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(214);var prop_types__WEBPACK_IMPORTED_MODULE_2___default=__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);var lodash__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(4);var lodash__WEBPACK_IMPORTED_MODULE_3___default=__webpack_require__.n(lodash__WEBPACK_IMPORTED_MODULE_3__);const ErrorBoundaryComponent=props=>{const{children:children,...rest}=props;return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(react__WEBPACK_IMPORTED_MODULE_0___default.a.Fragment,null,children(rest))};ErrorBoundaryComponent.propTypes={children:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.func.isRequired,error:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object,errorInfo:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.object,resetErrorState:prop_types__WEBPACK_IMPORTED_MODULE_2___default.a.func.isRequired};const errorBoundaryHoc=Object(recompose__WEBPACK_IMPORTED_MODULE_1__["compose"])(Object(recompose__WEBPACK_IMPORTED_MODULE_1__["withState"])("error","setError",null),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["withState"])("errorInfo","setErrorInfo",null),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["withHandlers"])({resetErrorState:({setError:setError,setErrorInfo:setErrorInfo})=>()=>{setError(null);setErrorInfo(null)}}),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["lifecycle"])({componentDidCatch(error,errorInfo){this.props.setError(error);this.props.setErrorInfo(errorInfo)}}),Object(recompose__WEBPACK_IMPORTED_MODULE_1__["mapProps"])(props=>Object(lodash__WEBPACK_IMPORTED_MODULE_3__["omit"])(props,["setError","setErrorInfo"])));const ErrorBoundary=errorBoundaryHoc(ErrorBoundaryComponent)},232:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.d(__webpack_exports__,"a",(function(){return Loading}));var react__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(3);var react__WEBPACK_IMPORTED_MODULE_0___default=__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(8);var _elastic_eui__WEBPACK_IMPORTED_MODULE_1___default=__webpack_require__.n(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__);var _common_lib_hex_to_rgb__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(55);const Loading=({animated:animated=false,text:text="",backgroundColor:backgroundColor="#000000"})=>{if(animated){return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{className:"canvasLoading"},text&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span",null,text," "),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiLoadingSpinner"],{size:"m"}))}const rgb=Object(_common_lib_hex_to_rgb__WEBPACK_IMPORTED_MODULE_2__["a"])(backgroundColor);let color="text";if(rgb&&Object(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["isColorDark"])(rgb[0],rgb[1],rgb[2])){color="ghost"}return react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("div",{className:"canvasLoading"},text&&react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement("span",null,text," "),react__WEBPACK_IMPORTED_MODULE_0___default.a.createElement(_elastic_eui__WEBPACK_IMPORTED_MODULE_1__["EuiIcon"],{color:color,type:"clock"}))};Loading.defaultProps={animated:false,backgroundColor:"#000000",text:""}},237:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret=__webpack_require__(238);function emptyFunction(){}function emptyFunctionWithReset(){}emptyFunctionWithReset.resetWarningCache=emptyFunction;module.exports=function(){function shim(props,propName,componentName,location,propFullName,secret){if(secret===ReactPropTypesSecret){return}var err=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use PropTypes.checkPropTypes() to call them. "+"Read more at http://fb.me/use-check-prop-types");err.name="Invariant Violation";throw err}shim.isRequired=shim;function getShim(){return shim}var ReactPropTypes={array:shim,bool:shim,func:shim,number:shim,object:shim,string:shim,symbol:shim,any:shim,arrayOf:getShim,element:shim,elementType:shim,instanceOf:getShim,node:shim,objectOf:getShim,oneOf:getShim,oneOfType:getShim,shape:getShim,exact:getShim,checkPropTypes:emptyFunctionWithReset,resetWarningCache:emptyFunction};ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}},238:function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},501:function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"datasourceSpecs",(function(){return datasourceSpecs}));__webpack_require__.d(__webpack_exports__,"initializeElements",(function(){return initializeElements}));__webpack_require__.d(__webpack_exports__,"modelSpecs",(function(){return modelSpecs}));__webpack_require__.d(__webpack_exports__,"viewSpecs",(function(){return viewSpecs}));__webpack_require__.d(__webpack_exports__,"viewInitializers",(function(){return viewInitializers}));__webpack_require__.d(__webpack_exports__,"initializeViews",(function(){return initializeViews}));__webpack_require__.d(__webpack_exports__,"args",(function(){return arguments_args}));__webpack_require__.d(__webpack_exports__,"initializers",(function(){return initializers}));__webpack_require__.d(__webpack_exports__,"initializeArgs",(function(){return initializeArgs}));__webpack_require__.d(__webpack_exports__,"tagSpecs",(function(){return tagSpecs}));__webpack_require__.d(__webpack_exports__,"transformSpecs",(function(){return transformSpecs}));var external_kbnSharedDeps_React_=__webpack_require__(3);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(8);var external_kbnSharedDeps_Lodash_=__webpack_require__(4);var common=__webpack_require__(9);const arg_helpers_allowedTypes=["string","number","boolean"];const badType=()=>new Error(`Arg setting helpers only support ${arg_helpers_allowedTypes.join(",")}`);const isAllowed=type=>Object(external_kbnSharedDeps_Lodash_["includes"])(arg_helpers_allowedTypes,type);function validateArg(value){const type=Object(common["getType"])(value);if(!isAllowed(type)){throw badType()}return value}function getSimpleArg(name,args){if(!args[name]){return[]}return args[name].map(astVal=>{if(!isAllowed(Object(common["getType"])(astVal))){throw badType()}return astVal})}function setSimpleArg(name,value){value=Array.isArray(value)?value:[value];return{[name]:value.map(validateArg)}}var template_from_react_component=__webpack_require__(215);var i18n=__webpack_require__(2);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const{Essql:strings}=i18n["f"];class essql_EssqlDatasource extends external_kbnSharedDeps_React_["PureComponent"]{constructor(..._args){super(..._args);_defineProperty(this,"defaultQuery",`SELECT * FROM "${this.props.defaultIndex}"`);_defineProperty(this,"getQuery",()=>getSimpleArg(this.getArgName(),this.props.args)[0]);_defineProperty(this,"getArgName",()=>{const{args:args}=this.props;if(getSimpleArg("_",args)[0]){return"_"}if(getSimpleArg("q",args)[0]){return"q"}return"query"});_defineProperty(this,"setArg",(name,value)=>{const{args:args,updateArgs:updateArgs}=this.props;updateArgs&&updateArgs({...args,...setSimpleArg(name,value)})});_defineProperty(this,"onChange",e=>{const{value:value}=e.target;this.props.setInvalid(!value.trim());this.setArg(this.getArgName(),value)})}componentDidMount(){const query=this.getQuery();if(typeof query!=="string"){this.setArg(this.getArgName(),this.defaultQuery)}else{this.props.setInvalid(!query.trim())}}render(){const{isInvalid:isInvalid}=this.props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{isInvalid:isInvalid,label:strings.getLabel(),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:i18n["l"],target:"_blank"},strings.getLabelAppend()))},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextArea"],{placeholder:this.defaultQuery,isInvalid:isInvalid,className:"canvasTextArea__code",value:this.getQuery(),onChange:this.onChange,rows:15}))}}const essql=()=>({name:"essql",displayName:strings.getDisplayName(),help:strings.getHelp(),image:"database",template:Object(template_from_react_component["a"])(essql_EssqlDatasource)});var Recompose=__webpack_require__(20);var es_service=__webpack_require__(227);const ESFieldsSelect=({selected:selected,fields:fields,onChange:onChange,onFocus:onFocus,onBlur:onBlur})=>{const options=fields.map(value=>({label:value}));const selectedOptions=selected.map(value=>({label:value}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{selectedOptions:selectedOptions,options:options,onChange:values=>onChange(values.map(({label:label})=>label)),className:"canvasFieldsSelect",onFocus:onFocus,onBlur:onBlur,compressed:true})};ESFieldsSelect.defaultProps={selected:[],fields:[]};const es_fields_select_ESFieldsSelect=Object(Recompose["compose"])(Object(Recompose["withState"])("fields","setFields",[]),Object(Recompose["lifecycle"])({componentDidMount(){if(this.props.index){Object(es_service["b"])(this.props.index).then((fields=[])=>this.props.setFields(fields))}},componentDidUpdate({index:index}){const{setFields:setFields,onChange:onChange,selected:selected}=this.props;if(this.props.index!==index){Object(es_service["b"])(this.props.index).then((fields=[])=>{setFields(fields);onChange(selected.filter(option=>fields.includes(option)))})}}}))(ESFieldsSelect);const ESFieldSelect=({value:value,fields:fields=[],onChange:onChange,onFocus:onFocus,onBlur:onBlur})=>{const selectedOption=value?[{label:value}]:[];const options=fields.map(field=>({label:field}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{selectedOptions:selectedOption,options:options,onChange:([field])=>onChange(Object(external_kbnSharedDeps_Lodash_["get"])(field,"label",null)),onSearchChange:searchValue=>{if(searchValue){onChange(null)}},onFocus:onFocus,onBlur:onBlur,singleSelection:{asPlainText:true},isClearable:false,compressed:true})};ESFieldSelect.defaultProps={fields:[]};const es_field_select_ESFieldSelect=Object(Recompose["compose"])(Object(Recompose["withState"])("fields","setFields",[]),Object(Recompose["lifecycle"])({componentDidMount(){if(this.props.index){Object(es_service["b"])(this.props.index).then(this.props.setFields)}},componentDidUpdate({index:index}){const{value:value,onChange:onChange,setFields:setFields}=this.props;if(this.props.index!==index){Object(es_service["b"])(this.props.index).then(fields=>{setFields(fields)})}if(value&&!this.props.fields.includes(value)){onChange(null)}}}))(ESFieldSelect);const es_index_select_defaultIndex="_all";const ESIndexSelect=({value:value,loading:loading,indices:indices,onChange:onChange,onFocus:onFocus,onBlur:onBlur})=>{const selectedOption=value!==es_index_select_defaultIndex?[{label:value}]:[];const options=indices.map(index=>({label:index}));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiComboBox"],{selectedOptions:selectedOption,onChange:([index])=>onChange(Object(external_kbnSharedDeps_Lodash_["get"])(index,"label",es_index_select_defaultIndex)),onSearchChange:searchValue=>{if(searchValue){onChange(es_index_select_defaultIndex)}},onBlur:onBlur,onFocus:onFocus,disabled:loading,options:options,singleSelection:{asPlainText:true},isClearable:false,onCreateOption:input=>onChange(input||es_index_select_defaultIndex),compressed:true})};ESIndexSelect.defaultProps={value:es_index_select_defaultIndex};const es_index_select_ESIndexSelect=Object(Recompose["compose"])(Object(Recompose["withState"])("loading","setLoading",true),Object(Recompose["withState"])("indices","setIndices",[]),Object(Recompose["lifecycle"])({componentDidMount(){Object(es_service["c"])().then((indices=[])=>{const{setLoading:setLoading,setIndices:setIndices,value:value,onChange:onChange}=this.props;setLoading(false);setIndices(indices.sort());if(!value&&indices.length){onChange(indices[0])}})}}))(ESIndexSelect);const{ESDocs:esdocs_strings}=i18n["f"];const EsdocsDatasource=({args:args,updateArgs:updateArgs,defaultIndex:defaultIndex})=>{const setArg=(name,value)=>{updateArgs&&updateArgs({...args,...setSimpleArg(name,value)})};const getArgName=()=>{if(getSimpleArg("_",args)[0]){return"_"}if(getSimpleArg("q",args)[0]){return"q"}return"query"};const getIndex=()=>getSimpleArg("index",args)[0]||"";const getQuery=()=>getSimpleArg(getArgName(),args)[0]||"";const getFields=()=>{const commas=getSimpleArg("fields",args)[0]||"";if(commas.length===0){return[]}return commas.split(",").map(str=>str.trim())};const getSortBy=()=>{const commas=getSimpleArg("sort",args)[0]||", DESC";return commas.split(",").map(str=>str.trim())};const fields=getFields();const[sortField,sortOrder]=getSortBy();const index=getIndex();if(!index&&defaultIndex){setArg("index",defaultIndex)}const sortOptions=[{value:"asc",text:esdocs_strings.getAscendingOption()},{value:"desc",text:esdocs_strings.getDescendingOption()}];return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:esdocs_strings.getIndexTitle(),helpText:esdocs_strings.getIndexLabel(),display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(es_index_select_ESIndexSelect,{value:index,onChange:index=>setArg("index",index)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:esdocs_strings.getFieldsTitle(),helpText:fields.length<=10?esdocs_strings.getFieldsLabel():esdocs_strings.getFieldsWarningLabel(),display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(es_fields_select_ESFieldsSelect,{index:index,onChange:fields=>setArg("fields",fields.join(", ")),selected:fields})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiAccordion"],{id:"accordionAdvancedSettings",buttonContent:"Advanced settings",className:"canvasSidebar__accordion"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:esdocs_strings.getSortFieldTitle(),display:"columnCompressed"},external_kbnSharedDeps_React_default.a.createElement(es_field_select_ESFieldSelect,{index:index,value:sortField,onChange:field=>setArg("sort",[field,sortOrder].join(", "))})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:esdocs_strings.getSortOrderTitle(),display:"columnCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{value:sortOrder.toLowerCase(),onChange:e=>setArg("sort",[sortField,e.target.value].join(", ")),options:sortOptions,compressed:true})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:esdocs_strings.getQueryTitle(),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:i18n["h"],target:"_blank"},esdocs_strings.getQueryLabel())),display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextArea"],{value:getQuery(),onChange:e=>setArg(getArgName(),e.target.value),compressed:true}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{size:"s",title:esdocs_strings.getWarningTitle(),iconType:"alert",color:"warning"},external_kbnSharedDeps_React_default.a.createElement("p",null,esdocs_strings.getWarning())))};const esdocs=()=>({name:"esdocs",displayName:esdocs_strings.getDisplayName(),help:esdocs_strings.getHelp(),image:"documents",template:Object(template_from_react_component["a"])(EsdocsDatasource)});const{DemoData:demodata_strings}=i18n["f"];const DemodataDatasource=()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:demodata_strings.getHeading(),iconType:"iInCircle"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,demodata_strings.getDescription())));const demodata=()=>({name:"demodata",displayName:demodata_strings.getDisplayName(),help:demodata_strings.getHelp(),image:"training",template:Object(template_from_react_component["a"])(DemodataDatasource)});var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(203);const{Timelion:timelion_strings}=i18n["f"];const TimelionDatasource=({args:args,updateArgs:updateArgs,defaultIndex:defaultIndex})=>{const DEFAULT_QUERY=`.es(index=${defaultIndex})`;const setArg=(name,value)=>{updateArgs&&updateArgs({...args,...setSimpleArg(name,value)})};const getArgName=()=>{if(getSimpleArg("_",args)[0]){return"_"}if(getSimpleArg("q",args)[0]){return"q"}return"query"};const argName=getArgName();const getQuery=()=>getSimpleArg(argName,args)[0]||DEFAULT_QUERY;const getInterval=()=>getSimpleArg("interval",args)[0]||"auto";return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:timelion_strings.getTipsHeading(),size:"s",iconType:"iInCircle"},external_kbnSharedDeps_React_default.a.createElement("ul",null,external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.canvas.uis.dataSources.timelion.tips.time",defaultMessage:"{timelion} requires a time range. Add a time filter element to your page or use the expression editor to pass one in.",values:{timelion:i18n["m"]}})),external_kbnSharedDeps_React_default.a.createElement("li",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.canvas.uis.dataSources.timelion.tips.functions",defaultMessage:"Some {timelion} functions, such as {functionExample}, do not translate to a {canvas} data table. However, anything todo with data manipulation should work as expected.",values:{timelion:i18n["m"],canvas:i18n["c"],functionExample:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCode"],null,".color()")}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:timelion_strings.getQueryLabel(),labelAppend:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:i18n["n"],target:"_blank"},timelion_strings.queryLabel())),display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextArea"],{className:"canvasTextArea__code",value:getQuery(),onChange:e=>setArg(argName,e.target.value),rows:15})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:timelion_strings.getIntervalLabel(),helpText:timelion_strings.getIntervalHelp(),display:"columnCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{compressed:true,value:getInterval(),onChange:e=>setArg("interval",e.target.value)})))};const timelion=()=>({name:"timelion",displayName:i18n["m"],help:timelion_strings.getHelp(),image:"visTimelion",template:Object(template_from_react_component["a"])(TimelionDatasource)});const datasourceSpecs=[essql,esdocs,demodata,timelion];var i18n_elements=__webpack_require__(61);const areaChart=()=>({name:"areaChart",displayName:"Area",help:"A line chart with a filled body",type:"chart",icon:"visArea",expression:`filters\n  | demodata\n  | pointseries x="time" y="mean(price)"\n  | plot defaultStyle={seriesStyle lines=1 fill=1}\n  | render`});const bubbleChart=()=>({name:"bubbleChart",displayName:"Bubble",type:"chart",help:"A customizable bubble chart",width:700,height:300,icon:"heatmap",expression:`filters\n| demodata\n| pointseries x="project" y="sum(price)" color="state" size="size(username)"\n| plot defaultStyle={seriesStyle points=5 fill=1}\n| render`});const debug=()=>({name:"debug",displayName:"Debug data",help:"Just dumps the configuration of the element",icon:"bug",expression:`demodata\n| render as=debug`});const dropdownFilter=()=>({name:"dropdownFilter",displayName:"Dropdown select",type:"filter",help:'A dropdown from which you can select values for an "exactly" filter',icon:"filter",height:50,expression:`demodata\n| dropdownControl valueColumn=project filterColumn=project | render`,filter:""});const filterDebug=()=>({name:"filterDebug",displayName:"Debug filter",help:"Shows the underlying global filters in a workpad",icon:"bug",expression:`filters\n| render as=debug`});const horizontalBarChart=()=>({name:"horizontalBarChart",displayName:"Bar horizontal",type:"chart",help:"A customizable horizontal bar chart",icon:"visBarHorizontal",expression:`filters\n| demodata\n| pointseries x="size(cost)" y="project" color="project"\n| plot defaultStyle={seriesStyle bars=0.75 horizontalBars=true} legend=false\n| render`});var fonts=__webpack_require__(19);const horizontalProgressBar=()=>({name:"horizontalProgressBar",displayName:"Horizontal bar",type:"progress",help:"Displays progress as a portion of a horizontal bar",width:400,height:30,expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="horizontalBar" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const horizontalProgressPill=()=>({name:"horizontalProgressPill",displayName:"Horizontal pill",type:"progress",help:"Displays progress as a portion of a horizontal pill",width:400,height:30,expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="horizontalPill" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const image_image=()=>({name:"image",displayName:"Image",type:"image",help:"A static image",icon:"image",expression:`image dataurl=null mode="contain"\n| render`});const lineChart=()=>({name:"lineChart",displayName:"Line",type:"chart",help:"A customizable line chart",icon:"visLine",expression:`filters\n| demodata\n| pointseries x="time" y="mean(price)"\n| plot defaultStyle={seriesStyle lines=3}\n| render`});const markdown=()=>({name:"markdown",displayName:"Text",type:"text",help:"Add text using Markdown",icon:"visText",expression:`filters\n| demodata\n| markdown "### Welcome to the Markdown element\n\nGood news! You're already connected to some demo data!\n\nThe data table contains\n**{{rows.length}} rows**, each containing\n the following columns:\n{{#each columns}}\n **{{name}}**\n{{/each}}\n\nYou can use standard Markdown in here, but you can also access your piped-in data using Handlebars. If you want to know more, check out the [Handlebars documentation](https://ela.st/handlebars-docs).\n\n#### Enjoy!" | render`});var public_=__webpack_require__(25);const metricElementInitializer=(core,setup)=>()=>({name:"metric",displayName:"Metric",type:"chart",help:"A number with a label",width:200,height:100,icon:"visMetric",expression:`filters\n  | demodata\n  | math "unique(country)"\n  | metric "Countries" \n    metricFont={font size=48 family="${fonts["openSans"].value}" color="#000000" align="center" lHeight=48} \n    labelFont={font size=14 family="${fonts["openSans"].value}" color="#000000" align="center"}\n    metricFormat="${core.uiSettings.get(public_["UI_SETTINGS"].FORMAT_NUMBER_DEFAULT_PATTERN)}"\n  | render`});const pie=()=>({name:"pie",displayName:"Pie",type:"chart",width:300,height:300,help:"A simple pie chart",icon:"visPie",expression:`filters\n| demodata\n| pointseries color="state" size="max(price)"\n| pie\n| render`});const plot=()=>({name:"plot",displayName:"Coordinate plot",type:"chart",help:"Mixed line, bar or dot charts",expression:`filters\n| demodata\n| pointseries x="time" y="sum(price)" color="state"\n| plot defaultStyle={seriesStyle points=5}\n| render`});const progressGauge=()=>({name:"progressGauge",displayName:"Gauge",type:"progress",help:"Displays progress as a portion of a gauge",width:200,height:200,icon:"visGoal",expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="gauge" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const progressSemicircle=()=>({name:"progressSemicircle",displayName:"Semicircle",type:"progress",help:"Displays progress as a portion of a semicircle",width:200,height:100,expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="semicircle" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const progressWheel=()=>({name:"progressWheel",displayName:"Wheel",type:"progress",help:"Displays progress as a portion of a wheel",width:200,height:200,expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="wheel" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const repeatImage=()=>({name:"repeatImage",displayName:"Image repeat",type:"image",help:"Repeats an image N times",expression:`filters\n| demodata\n| math "mean(cost)"\n| repeatImage image=null\n| render`});const revealImage=()=>({name:"revealImage",displayName:"Image reveal",type:"image",help:"Reveals a percentage of an image",expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| revealImage origin=bottom image=null\n| render`});const shape_shape=()=>({name:"shape",displayName:"Shape",type:"shape",help:"A customizable shape",width:200,height:200,icon:"node",expression:'shape "square" fill="#4cbce4" border="rgba(255,255,255,0)" borderWidth=0 maintainAspect=false | render'});const table=()=>({name:"table",displayName:"Data table",type:"chart",help:"A scrollable grid for displaying data in a tabular format",icon:"visTable",expression:`filters\n| demodata\n| table\n| render`});const timeFilter=()=>({name:"timeFilter",displayName:"Time filter",type:"filter",help:"Set a time window",icon:"calendar",height:50,expression:`timefilterControl compact=true column=@timestamp\n| render`,filter:"timefilter column=@timestamp from=now-24h to=now"});const verticalBarChart=()=>({name:"verticalBarChart",displayName:"Vertical bar chart",type:"chart",help:"A customizable vertical bar chart",icon:"visBarVertical",expression:`filters\n| demodata\n| pointseries x="project" y="size(cost)" color="project"\n| plot defaultStyle={seriesStyle bars=0.75} legend=false\n| render`});const verticalProgressBar=()=>({name:"verticalProgressBar",displayName:"Vertical progress bar",type:"progress",help:"Displays progress as a portion of a vertical bar",width:80,height:400,expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="verticalBar" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const verticalProgressPill=()=>({name:"verticalProgressPill",displayName:"Vertical progress pill",type:"progress",help:"Displays progress as a portion of a vertical pill",width:80,height:400,expression:`filters\n| demodata\n| math "mean(percent_uptime)"\n| progress shape="verticalPill" label={formatnumber 0%} font={font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}\n| render`});const elementSpecs=[areaChart,bubbleChart,debug,dropdownFilter,filterDebug,image_image,horizontalBarChart,horizontalProgressBar,horizontalProgressPill,lineChart,markdown,pie,plot,progressGauge,progressSemicircle,progressWheel,repeatImage,revealImage,shape_shape,table,timeFilter,verticalBarChart,verticalProgressBar,verticalProgressPill];const initializeElementFactories=[metricElementInitializer];const initializeElements=(core,plugins)=>{const specs=[...elementSpecs,...initializeElementFactories.map(factory=>factory(core,plugins))];return Object(i18n_elements["a"])(specs)};var resolved_arg=__webpack_require__(218);const{PointSeries:point_series_strings}=i18n["j"];const pointseries=()=>({name:"pointseries",displayName:point_series_strings.getDisplayName(),args:[{name:"x",displayName:point_series_strings.getXAxisDisplayName(),help:point_series_strings.getXAxisHelp(),argType:"datacolumn"},{name:"y",displayName:point_series_strings.getYaxisDisplayName(),help:point_series_strings.getYaxisHelp(),argType:"datacolumn"},{name:"color",displayName:point_series_strings.getColorDisplayName(),help:point_series_strings.getColorHelp(),argType:"datacolumn"},{name:"size",displayName:point_series_strings.getSizeDisplayName(),help:point_series_strings.getSizeHelp(),argType:"datacolumn"},{name:"text",displayName:point_series_strings.getTextDisplayName(),help:point_series_strings.getTextHelp(),argType:"datacolumn"}],resolve({context:context}){if(Object(resolved_arg["b"])(context)!=="ready"){return{columns:[]}}return{columns:Object(external_kbnSharedDeps_Lodash_["get"])(Object(resolved_arg["c"])(context),"columns",[])}}});const{Math:math_strings}=i18n["j"];const math=()=>({name:"math",displayName:math_strings.getDisplayName(),args:[{name:"_",displayName:math_strings.getValueDisplayName(),help:math_strings.getValueHelp(),argType:"datacolumn",options:{onlyMath:false}}],resolve({context:context}){if(Object(resolved_arg["b"])(context)!=="ready"){return{columns:[]}}return{columns:Object(external_kbnSharedDeps_Lodash_["get"])(Object(resolved_arg["c"])(context),"columns",[])}}});const modelSpecs=[pointseries,math];const{DropdownControl:dropdownControl_strings}=i18n["s"];const dropdownControl=()=>({name:"dropdownControl",displayName:dropdownControl_strings.getDisplayName(),modelArgs:[],args:[{name:"valueColumn",displayName:dropdownControl_strings.getValueDisplayName(),help:dropdownControl_strings.getValueHelp(),argType:"string",options:{confirm:"Set"}},{name:"filterColumn",displayName:dropdownControl_strings.getFilterDisplayName(),help:dropdownControl_strings.getFilterHelp(),argType:"string",options:{confirm:"Set"}},{name:"filterGroup",displayName:dropdownControl_strings.getFilterGroupDisplayName(),help:dropdownControl_strings.getFilterGroupHelp(),argType:"filterGroup"}]});const{GetCell:getCell_strings}=i18n["s"];const getCell=()=>({name:"getCell",displayName:getCell_strings.getDisplayName(),help:getCell_strings.getHelp(),modelArgs:["size"],requiresContext:true,args:[]});var elastic_logo=__webpack_require__(22);var resolve_dataurl=__webpack_require__(14);const{Image:image_strings}=i18n["s"];const views_image_image=()=>({name:"image",displayName:image_strings.getDisplayName(),modelArgs:[],requiresContext:false,args:[{name:"dataurl",argType:"imageUpload",resolve({args:args}){return{dataurl:Object(resolve_dataurl["a"])(args,elastic_logo["a"])}}},{name:"mode",displayName:image_strings.getModeDisplayName(),help:image_strings.getModeHelp(),argType:"select",options:{choices:[{value:"contain",name:image_strings.getContainMode()},{value:"cover",name:image_strings.getCoverMode()},{value:"stretch",name:image_strings.getStretchMode()}]}}]});const{Markdown:markdown_strings}=i18n["s"];const markdown_markdown=()=>({name:"markdown",displayName:markdown_strings.getDisplayName(),help:markdown_strings.getHelp(),modelArgs:[],requiresContext:false,args:[{name:"_",displayName:markdown_strings.getContentDisplayName(),help:markdown_strings.getContentHelp(),argType:"textarea",default:'""',options:{confirm:"Apply"},multi:true},{name:"font",argType:"font"},{name:"openLinksInNewTab",displayName:markdown_strings.getOpenLinksInNewTabDisplayName(),help:markdown_strings.getOpenLinksInNewTabHelp(),label:markdown_strings.getOpenLinksInNewTabLabelName(),argType:"toggle",default:false,options:{labelValue:markdown_strings.getOpenLinksInNewTabLabelName()}}]});const{Metric:metric_strings}=i18n["s"];const metricInitializer=(core,plugin)=>()=>({name:"metric",displayName:metric_strings.getDisplayName(),modelArgs:[["_",{label:metric_strings.getNumberDisplayName()}]],requiresContext:false,args:[{name:"metricFormat",displayName:metric_strings.getMetricFormatDisplayName(),help:metric_strings.getMetricFormatHelp(),argType:"numberFormat",default:`"${core.uiSettings.get(public_["UI_SETTINGS"].FORMAT_NUMBER_DEFAULT_PATTERN)}"`},{name:"_",displayName:metric_strings.getLabelDisplayName(),help:metric_strings.getLabelHelp(),argType:"string",default:'""'},{name:"metricFont",displayName:metric_strings.getMetricFontDisplayName(),help:metric_strings.getMetricFontHelp(),argType:"font",default:`{font size=48 family="${fonts["openSans"].value}" color="#000000" align=center lHeight=48}`},{name:"labelFont",displayName:metric_strings.getLabelFontDisplayName(),help:metric_strings.getLabelFontHelp(),argType:"font",default:`{font size=18 family="${fonts["openSans"].value}" color="#000000" align=center}`}]});const legendOptions=[{name:"Hidden",value:false},{name:"Top Left",value:"nw"},{name:"Top Right",value:"ne"},{name:"Bottom Left",value:"sw"},{name:"Bottom Right",value:"se"}];const{Pie:pie_strings}=i18n["s"];const pie_pie=()=>({name:"pie",displayName:pie_strings.getDisplayName(),modelArgs:[["color",{label:"Slice Labels"}],["size",{label:"Slice Angles"}]],args:[{name:"palette",argType:"palette"},{name:"legend",displayName:pie_strings.getLegendDisplayName(),help:pie_strings.getLegendHelp(),argType:"select",default:"ne",options:{choices:legendOptions}},{name:"hole",displayName:pie_strings.getHoleDisplayName(),help:pie_strings.getHoleHelp(),argType:"range",default:50,options:{min:0,max:100}},{name:"labelRadius",displayName:pie_strings.getLabelRadiusDisplayName(),help:pie_strings.getLabelRadiusHelp(),argType:"range",default:100,options:{min:0,max:100}},{name:"radius",displayName:pie_strings.getRadiusDisplayName(),help:pie_strings.getRadiusHelp(),argType:"percentage",default:1},{name:"tilt",displayName:pie_strings.getTiltDisplayName(),help:pie_strings.getTiltHelp(),argType:"percentage",default:1},{name:"labels",displayName:pie_strings.getLabelsDisplayName(),help:pie_strings.getLabelsHelp(),argType:"toggle",default:true,options:{labelValue:pie_strings.getLabelsToggleSwitch()}},{name:"seriesStyle",argType:"seriesStyle",multi:true},{name:"font",argType:"font"}],resolve({context:context}){if(Object(resolved_arg["b"])(context)!=="ready"){return{labels:[]}}return{labels:Object(external_kbnSharedDeps_Lodash_["uniq"])(Object(external_kbnSharedDeps_Lodash_["map"])(Object(resolved_arg["c"])(context).rows,"color").filter(v=>v!==undefined))}}});const{Plot:plot_strings}=i18n["s"];const styleProps=["lines","bars","points","fill","stack"];const plot_plot=()=>({name:"plot",displayName:plot_strings.getDisplayName(),modelArgs:["x","y","color","size","text"],args:[{name:"palette",argType:"palette"},{name:"legend",displayName:plot_strings.getLegendDisplayName(),help:plot_strings.getLegendHelp(),argType:"select",default:"ne",options:{choices:legendOptions}},{name:"xaxis",displayName:plot_strings.getXaxisDisplayName(),help:plot_strings.getXaxisHelp(),argType:"axisConfig",default:true},{name:"yaxis",displayName:plot_strings.getYaxisDisplayName(),help:plot_strings.getYaxisHelp(),argType:"axisConfig",default:true},{name:"font",argType:"font"},{name:"defaultStyle",displayName:plot_strings.getDefaultStyleDisplayName(),help:plot_strings.getDefaultStyleHelp(),argType:"seriesStyle",default:"{seriesStyle points=5}",options:{include:styleProps}},{name:"seriesStyle",argType:"seriesStyle",options:{include:styleProps},multi:true}],resolve({context:context}){if(Object(resolved_arg["b"])(context)!=="ready"){return{labels:[]}}return{labels:Object(external_kbnSharedDeps_Lodash_["uniqBy"])(Object(external_kbnSharedDeps_Lodash_["map"])(Object(resolved_arg["c"])(context).rows,"color").filter(v=>v!==undefined))}}});var progress_shapes=__webpack_require__(109);const{Progress:progress_strings}=i18n["s"];const progress=()=>({name:"progress",displayName:progress_strings.getDisplayName(),modelArgs:[["_",{label:"Value"}]],requiresContext:false,args:[{name:"shape",displayName:progress_strings.getShapeDisplayName(),help:progress_strings.getShapeHelp(),argType:"select",options:{choices:Object.keys(progress_shapes["a"]).map(key=>({value:key,name:key[0].toUpperCase()+key.slice(1).replace(/([A-Z])/g," $1")}))}},{name:"max",displayName:progress_strings.getMaxDisplayName(),help:progress_strings.getMaxHelp(),argType:"number",default:"1"},{name:"valueColor",displayName:progress_strings.getValueColorDisplayName(),help:progress_strings.getValueColorHelp(),argType:"color",default:`#1785b0`},{name:"valueWeight",displayName:progress_strings.getValueWeightDisplayName(),help:progress_strings.getValueWeightHelp(),argType:"number",default:"20"},{name:"barColor",displayName:progress_strings.getBarColorDisplayName(),help:progress_strings.getBarColorHelp(),argType:"color",default:`#f0f0f0`},{name:"barWeight",displayName:progress_strings.getBarWeightDisplayName(),help:progress_strings.getBarWeightHelp(),argType:"number",default:"20"},{name:"label",displayName:progress_strings.getLabelDisplayName(),help:progress_strings.getLabelHelp(),argType:"toggle",default:"true"},{name:"font",displayName:progress_strings.getFontDisplayName(),help:progress_strings.getFontHelp(),argType:"font",default:`{font size=24 family="${fonts["openSans"].value}" color="#000000" align=center}`}]});const{RepeatImage:repeatImage_strings}=i18n["s"];const repeatImage_repeatImage=()=>({name:"repeatImage",displayName:repeatImage_strings.getDisplayName(),modelArgs:[["_",{label:"Value"}]],args:[{name:"image",displayName:repeatImage_strings.getImageDisplayName(),help:repeatImage_strings.getImageHelp(),argType:"imageUpload"},{name:"emptyImage",displayName:repeatImage_strings.getEmptyImageDisplayName(),help:repeatImage_strings.getEmptyImageHelp(),argType:"imageUpload"},{name:"size",displayName:repeatImage_strings.getSizeDisplayName(),help:repeatImage_strings.getSizeHelp(),argType:"number",default:"100"},{name:"max",displayName:repeatImage_strings.getMaxDisplayName(),help:repeatImage_strings.getMaxHelp(),argType:"number",default:"1000"}]});const{RevealImage:revealImage_strings}=i18n["s"];const revealImage_revealImage=()=>({name:"revealImage",displayName:revealImage_strings.getDisplayName(),modelArgs:[["_",{label:"Value"}]],args:[{name:"image",displayName:revealImage_strings.getImageDisplayName(),help:revealImage_strings.getImageHelp(),argType:"imageUpload"},{name:"emptyImage",displayName:revealImage_strings.getEmptyImageDisplayName(),help:revealImage_strings.getEmptyImageHelp(),argType:"imageUpload"},{name:"origin",displayName:revealImage_strings.getOriginDisplayName(),help:revealImage_strings.getOriginHelp(),argType:"select",options:{choices:[{value:"top",name:revealImage_strings.getOriginTop()},{value:"left",name:revealImage_strings.getOriginLeft()},{value:"bottom",name:revealImage_strings.getOriginBottom()},{value:"right",name:revealImage_strings.getOriginRight()}]}}]});var constants=__webpack_require__(7);var i18n_constants=__webpack_require__(1);const{Render:render_strings}=i18n["s"];const render=()=>({name:"render",displayName:render_strings.getDisplayName(),help:render_strings.getHelp(),modelArgs:[],requiresContext:false,args:[{name:"containerStyle",argType:"containerStyle"},{name:"css",displayName:i18n_constants["g"],help:render_strings.getCssHelp(),argType:"textarea",default:`"${constants["p"]}"`,options:{confirm:render_strings.getCssApply()}}]});var shape_shapes=__webpack_require__(108);const{Shape:shape_strings}=i18n["s"];const views_shape_shape=()=>({name:"shape",displayName:shape_strings.getDisplayName(),modelArgs:[],requiresContext:false,args:[{name:"_",displayName:shape_strings.getShapeDisplayName(),argType:"shape",options:{shapes:shape_shapes["a"]}},{name:"fill",displayName:shape_strings.getFillDisplayName(),argType:"color",help:shape_strings.getFillHelp()},{name:"border",displayName:shape_strings.getBorderDisplayName(),argType:"color",help:shape_strings.getBorderHelp()},{name:"borderWidth",displayName:shape_strings.getBorderWidthDisplayName(),argType:"number",help:shape_strings.getBorderWidthHelp()},{name:"maintainAspect",displayName:shape_strings.getMaintainAspectDisplayName(),argType:"toggle",help:shape_strings.getMaintainAspectHelp(),options:{labelValue:shape_strings.getMaintainAspectLabelName()}}]});const{Table:table_strings}=i18n["s"];const table_table=()=>({name:"table",displayName:table_strings.getDisplayName(),help:table_strings.getHelp(),modelArgs:[],args:[{name:"font",argType:"font"},{name:"perPage",displayName:table_strings.getPerPageDisplayName(),help:table_strings.getPerPageHelp(),argType:"select",default:10,options:{choices:["",5,10,25,50,100].map(v=>({name:String(v),value:v}))}},{name:"paginate",displayName:table_strings.getPaginateDisplayName(),help:table_strings.getPaginateHelp(),argType:"toggle",default:true,options:{labelValue:table_strings.getPaginateToggleSwitch()}},{name:"showHeader",displayName:table_strings.getShowHeaderDisplayName(),help:table_strings.getShowHeaderHelp(),argType:"toggle",default:true,options:{labelValue:table_strings.getShowHeaderToggleSwitch()}}]});const{Timefilter:timefilterControl_strings}=i18n["s"];const timefilterControl=()=>({name:"timefilterControl",displayName:timefilterControl_strings.getDisplayName(),modelArgs:[],args:[{name:"column",displayName:timefilterControl_strings.getColumnDisplayName(),help:timefilterControl_strings.getColumnHelp(),argType:"string",options:{confirm:timefilterControl_strings.getColumnConfirm()}},{name:"filterGroup",displayName:timefilterControl_strings.getFilterGroupDisplayName(),help:timefilterControl_strings.getFilterGroupHelp(),argType:"filterGroup"}]});const viewSpecs=[dropdownControl,getCell,views_image_image,markdown_markdown,pie_pie,plot_plot,progress,repeatImage_repeatImage,revealImage_revealImage,render,views_shape_shape,table_table,timefilterControl];const viewInitializers=[metricInitializer];const initializeViews=(core,plugins)=>[...viewSpecs,...viewInitializers.map(initializer=>initializer(core,plugins))];const SimpleTemplate=({onValueChange:onValueChange,argValue:argValue})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,checked:Boolean(argValue),onChange:()=>onValueChange(!Boolean(argValue)),showLabel:false,label:""});SimpleTemplate.displayName="AxisConfigSimpleInput";var object_path_immutable=__webpack_require__(44);var object_path_immutable_default=__webpack_require__.n(object_path_immutable);var ui=__webpack_require__(57);function extended_template_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const{AxisConfig:extended_template_strings}=ui["a"];const{set:set}=object_path_immutable_default.a;const defaultExpression={type:"expression",chain:[{type:"function",function:"axisConfig",arguments:{}}]};class extended_template_ExtendedTemplate extends external_kbnSharedDeps_React_["PureComponent"]{constructor(...args){super(...args);extended_template_defineProperty(this,"getArgValue",(name,alt)=>Object(external_kbnSharedDeps_Lodash_["get"])(this.props.argValue,`chain.0.arguments.${name}.0`,alt));extended_template_defineProperty(this,"setArgValue",name=>ev=>{if(!ev||!ev.target){return}const val=ev.target.value;const{argValue:argValue,onValueChange:onValueChange}=this.props;const oldVal=typeof argValue==="boolean"?defaultExpression:argValue;const newValue=set(oldVal,`chain.0.arguments.${name}.0`,val);onValueChange(newValue)})}render(){const isDisabled=typeof this.props.argValue==="boolean"&&this.props.argValue===false;if(isDisabled){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued",size:"xs"},external_kbnSharedDeps_React_default.a.createElement("p",null,extended_template_strings.getDisabledText()))}const positions={xaxis:[{value:"bottom",text:extended_template_strings.getPositionBottom()},{value:"top",text:extended_template_strings.getPositionTop()}],yaxis:[{value:"left",text:extended_template_strings.getPositionLeft()},{value:"right",text:extended_template_strings.getPositionRight()}]};const argName=this.props.typeInstance.name;const position=this.getArgValue("position",positions[argName][0].value);const options=positions[argName];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:extended_template_strings.getPositionLabel(),display:"columnCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,value:position,options:options,onChange:this.setArgValue("position")})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}))}}extended_template_defineProperty(extended_template_ExtendedTemplate,"displayName","AxisConfigExtendedInput");const{AxisConfig:axis_config_strings}=i18n["b"];const axisConfig=()=>({name:"axisConfig",displayName:axis_config_strings.getDisplayName(),help:axis_config_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(SimpleTemplate),template:Object(template_from_react_component["a"])(extended_template_ExtendedTemplate)});var prop_types=__webpack_require__(214);var prop_types_default=__webpack_require__.n(prop_types);var stateful_prop=__webpack_require__(221);const{DataColumn:simple_math_function_strings}=i18n["b"];const SimpleMathFunction=({onChange:onChange,value:value,inputRef:inputRef,onlymath:onlymath})=>{const options=[{text:simple_math_function_strings.getOptionAverage(),value:"mean"},{text:simple_math_function_strings.getOptionCount(),value:"size"},{text:simple_math_function_strings.getOptionFirst(),value:"first"},{text:simple_math_function_strings.getOptionLast(),value:"last"},{text:simple_math_function_strings.getOptionMax(),value:"max"},{text:simple_math_function_strings.getOptionMedian(),value:"median"},{text:simple_math_function_strings.getOptionMin(),value:"min"},{text:simple_math_function_strings.getOptionSum(),value:"sum"},{text:simple_math_function_strings.getOptionUnique(),value:"unique"}];if(!onlymath){options.unshift({text:simple_math_function_strings.getOptionValue(),value:""})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,options:options,inputRef:inputRef,value:value,onChange:onChange})};SimpleMathFunction.defaultProps={value:""};var src=__webpack_require__(58);var unquote_string=__webpack_require__(28);function getFormObject(argValue){if(argValue===""){return{fn:"",column:""}}const mathObj=Object(src["parse"])(argValue);if(typeof mathObj==="number"){throw new Error(`Cannot render scalar values or complex math expressions`)}if(mathObj.type==="variable"){return{fn:"",column:Object(unquote_string["a"])(mathObj.value)}}if(mathObj.type==="function"&&mathObj.args.length===1&&typeof mathObj.args[0]!=="number"&&mathObj.args[0].type==="variable"){return{fn:mathObj.name,column:Object(unquote_string["a"])(mathObj.args[0].value)}}throw new Error(`Cannot render scalar values or complex math expressions`)}function datacolumn_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const{DataColumn:datacolumn_strings}=i18n["b"];const maybeQuoteValue=val=>val.match(/\s/)?`'${val}'`:val;class datacolumn_DatacolumnArgInput extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);datacolumn_defineProperty(this,"inputRefs",{})}render(){const{onValueChange:onValueChange,columns:columns,mathValue:mathValue,setMathFunction:setMathFunction,renderError:renderError,argId:argId,typeInstance:typeInstance}=this.props;if(mathValue.error){renderError();return null}const allowedTypes=typeInstance.options.allowedTypes||false;const onlyShowMathFunctions=typeInstance.options.onlyMath||false;const valueNotSet=val=>!val||val.length===0;const updateFunctionValue=()=>{const fn=this.inputRefs.fn.value;const column=this.inputRefs.column.value;if(fn==="size"){const col=column||columns[0]&&columns[0].name;if(col){return onValueChange(`${fn}(${maybeQuoteValue(col)})`)}}if(valueNotSet(column)){return setMathFunction(fn)}if(valueNotSet(fn)){return onValueChange(column)}onValueChange(`${fn}(${maybeQuoteValue(column)})`)};const column=columns.map(col=>col.name).find(colName=>colName===mathValue.column)||"";const options=[{value:"",text:"select column",disabled:true}];Object(external_kbnSharedDeps_Lodash_["sortBy"])(columns,"name").forEach(column=>{if(allowedTypes&&!allowedTypes.includes(column.type)){return}options.push({value:column.name,text:column.name})});return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",id:argId,direction:"row"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(SimpleMathFunction,{id:argId,value:mathValue.fn,inputRef:ref=>this.inputRefs.fn=ref,onlymath:onlyShowMathFunctions,onChange:updateFunctionValue})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,options:options,value:column,inputRef:ref=>this.inputRefs.column=ref,onChange:updateFunctionValue})))}}const EnhancedDatacolumnArgInput=Object(Recompose["compose"])(Object(Recompose["withPropsOnChange"])(["argValue","columns"],({argValue:argValue,columns:columns})=>({mathValue:(argValue=>{if(Object(common["getType"])(argValue)!=="string"){return{error:"argValue is not a string type"}}try{const matchedCol=columns.find(({name:name})=>argValue===name);const val=matchedCol?maybeQuoteValue(matchedCol.name):argValue;return getFormObject(val)}catch(e){return{error:e.message}}})(argValue)})),Object(stateful_prop["a"])("mathValue","setMathValue"),Object(Recompose["withHandlers"])({setMathFunction:({mathValue:mathValue,setMathValue:setMathValue})=>fn=>setMathValue({...mathValue,fn:fn})}))(datacolumn_DatacolumnArgInput);EnhancedDatacolumnArgInput.propTypes={argValue:prop_types_default.a.oneOfType([prop_types_default.a.string,prop_types_default.a.object]).isRequired,columns:prop_types_default.a.array.isRequired};const datacolumn=()=>({name:"datacolumn",displayName:datacolumn_strings.getDisplayName(),help:datacolumn_strings.getHelp(),default:'""',simpleTemplate:Object(template_from_react_component["a"])(EnhancedDatacolumnArgInput)});var external_kbnSharedDeps_Moment_=__webpack_require__(11);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);function format_select_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class format_select_FormatSelect extends external_kbnSharedDeps_React_["PureComponent"]{constructor(...args){super(...args);format_select_defineProperty(this,"state",{isCustomFormat:!this.props.formatOptions.map(({value:value})=>value).includes(this.props.argValue)});format_select_defineProperty(this,"_options",this.props.formatOptions.concat({value:"custom",text:"Custom"}));format_select_defineProperty(this,"_handleTextChange",ev=>this.props.onValueChange(ev.target.value));format_select_defineProperty(this,"_handleSelectChange",ev=>{const{onValueChange:onValueChange,defaultCustomFormat:defaultCustomFormat}=this.props;const{value:value}=this._options[ev.target.selectedIndex];if(value==="custom"){this.setState({isCustomFormat:true});return onValueChange(defaultCustomFormat)}if(this.state.isCustomFormat){this.setState({isCustomFormat:false})}return onValueChange(value)})}render(){const{argId:argId,argValue:argValue,defaultCustomFormat:defaultCustomFormat}=this.props;const{isCustomFormat:isCustomFormat}=this.state;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,id:argId,value:isCustomFormat?"custom":argValue,options:this._options,onChange:this._handleSelectChange}),isCustomFormat&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{placeholder:defaultCustomFormat,value:argValue,compressed:true,onChange:this._handleTextChange})))}}const date_format_DateFormatArgInput=({dateFormats:dateFormats,onValueChange:onValueChange,argValue:argValue,argId:argId})=>external_kbnSharedDeps_React_default.a.createElement(format_select_FormatSelect,{argId:argId,argValue:argValue,formatOptions:dateFormats,onValueChange:onValueChange,defaultCustomFormat:"M/D/YY h:ma"});const{DateFormat:date_format_strings}=i18n["b"];const dateFormatInitializer=(core,plugins)=>{const formatMap={DEFAULT:core.uiSettings.get("dateFormat"),NANOS:core.uiSettings.get("dateNanosFormat"),ISO8601:"",LOCAL_LONG:"LLLL",LOCAL_SHORT:"LLL",LOCAL_DATE:"l",LOCAL_TIME_WITH_SECONDS:"LTS"};const dateFormats=Object.values(formatMap).map(format=>({value:format,text:external_kbnSharedDeps_Moment_default.a.utc(external_kbnSharedDeps_Moment_default()()).format(format)}));const DateFormatArgInput=Object(Recompose["compose"])(Object(Recompose["withProps"])({dateFormats:dateFormats}))(date_format_DateFormatArgInput);return()=>({name:"dateFormat",displayName:date_format_strings.getDisplayName(),help:date_format_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(DateFormatArgInput)})};const{FilterGroup:filter_group_strings}=i18n["b"];const FilterGroupInput=({onValueChange:onValueChange,argValue:argValue,argId:argId,filterGroups:filterGroups})=>{const[inputValue,setInputValue]=Object(external_kbnSharedDeps_React_["useState"])("");const[addMode,setAddMode]=Object(external_kbnSharedDeps_React_["useState"])(false);const argValueChoice=argValue&&!filterGroups.includes(argValue)?[{text:argValue}]:[];const choices=[{text:"No group",value:""}].concat(argValueChoice,filterGroups.map(f=>({text:f})));const handleSelectGroup=ev=>{const selected=ev.target.value;onValueChange(selected)};const handleAddGroup=ev=>{ev.preventDefault();onValueChange(inputValue);setAddMode(false);setInputValue("")};const addForm=external_kbnSharedDeps_React_default.a.createElement("form",{onSubmit:handleAddGroup},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{autoFocus:true,compressed:true,type:"text",value:inputValue,onChange:ev=>setInputValue(ev.target.value)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"canvasSidebar__panel-noMinWidth"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"submit",size:"s",onClick:handleAddGroup},filter_group_strings.getButtonSet()))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{color:"danger",size:"xs",onClick:()=>setAddMode(!addMode),flush:"left"},filter_group_strings.getButtonCancel()));const selectForm=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_["Fragment"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,id:argId,value:argValue||"",options:choices,onChange:handleSelectGroup}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{size:"xs",onClick:()=>setAddMode(!addMode),flush:"left"},filter_group_strings.getCreateNewGroup()));return addMode?addForm:selectForm};const filterGroup=()=>({name:"filterGroup",displayName:filter_group_strings.getDisplayName(),help:filter_group_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(FilterGroupInput)});const{AssetPicker:asset_picker_strings}=i18n["e"];class asset_picker_AssetPicker extends external_kbnSharedDeps_React_["PureComponent"]{componentDidMount(){const selectedAsset=document.getElementById("canvasAssetPicker__selectedAsset");if(selectedAsset){selectedAsset.scrollIntoView()}}render(){const{assets:assets,selected:selected,onChange:onChange}=this.props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{id:"canvasAssetPicker",className:"canvasAssetPicker",gutterSize:"s",columns:4},assets.map(asset=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:asset.id,id:asset.id===selected?"canvasAssetPicker__selectedAsset":"",className:"canvasCheckered"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{className:`canvasAssetPicker__link`,disabled:asset.id===selected,onClick:()=>onChange(asset)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiImage"],{url:asset.value,alt:asset_picker_strings.getAssetAltText()}),asset.id===selected&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{className:"canvasAssetPicker__selected",type:"checkInCircleFilled"})))))}}var elastic_outline=__webpack_require__(15);var httpurl=__webpack_require__(26);var dataurl=__webpack_require__(24);const{ImageUpload:link_strings}=i18n["b"];const LinkForm=({url:url,inputRef:inputRef,onSubmit:onSubmit})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed",onSubmit:onSubmit,className:"eui-textRight"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{compressed:true,defaultValue:url,inputRef:inputRef,placeholder:link_strings.getUrlFieldPlaceholder(),"aria-label":link_strings.getUrlFieldPlaceholder()})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{type:"submit",size:"s",onClick:onSubmit},"Set"))));var loading_loading=__webpack_require__(232);const{ImageUpload:file_strings}=i18n["b"];const FileForm=({loading:loading,onChange:onChange})=>loading?external_kbnSharedDeps_React_default.a.createElement(loading_loading["a"],{animated:true,text:file_strings.getImageUploading()}):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFilePicker"],{initialPromptText:file_strings.getFileUploadPrompt(),onChange:onChange,compressed:true,display:"default",className:"canvasImageUpload",accept:"image/*"});function image_upload_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const{ImageUpload:image_upload_strings}=i18n["b"];class image_upload_ImageUpload extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);image_upload_defineProperty(this,"updateAST",assetId=>{this.props.onValueChange({type:"expression",chain:[{type:"function",function:"asset",arguments:{_:[assetId]}}]})});image_upload_defineProperty(this,"handleUpload",files=>{const{onAssetAdd:onAssetAdd}=this.props;const[file]=files;const[type,subtype]=Object(external_kbnSharedDeps_Lodash_["get"])(file,"type","").split("/");if(type==="image"&&constants["A"].indexOf(subtype)>=0){this.setState({loading:true});Object(dataurl["a"])(file).then(dataurl=>onAssetAdd("dataurl",dataurl)).then(assetId=>{this.updateAST(assetId);this._isMounted&&this.setState({loading:false})})}});image_upload_defineProperty(this,"changeUrlType",optionId=>{this.setState({urlType:optionId})});image_upload_defineProperty(this,"setSrcUrl",()=>{const{value:srcUrl}=this.inputRefs.srcUrlText;this.setState({url:srcUrl});const{onValueChange:onValueChange}=this.props;onValueChange(srcUrl)});const url=props.resolvedArgValue||null;let urlType=Object.keys(props.assets).length?"asset":"file";if(Object(httpurl["a"])(url)){urlType="link"}this.inputRefs={};this.state={loading:false,url:url,urlType:urlType}}componentDidMount(){this._isMounted=true}componentWillUnmount(){this._isMounted=false}render(){const{loading:loading,url:url,urlType:urlType}=this.state;const assets=Object.values(this.props.assets);let selectedAsset={};const urlTypeOptions=[{id:"file",label:image_upload_strings.getFileUrlType()},{id:"link",label:image_upload_strings.getLinkUrlType()}];if(assets.length){urlTypeOptions.unshift({id:"asset",label:image_upload_strings.getAssetUrlType()});selectedAsset=assets.find(({value:value})=>value===url)||{}}const selectUrlType=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonGroup"],{buttonSize:"compressed",options:urlTypeOptions,idSelected:urlType,onChange:this.changeUrlType,isFullWidth:true,className:"canvasSidebar__buttonGroup",legend:image_upload_strings.getUrlTypeChangeLegend()}));const forms={file:external_kbnSharedDeps_React_default.a.createElement(FileForm,{loading:loading,onChange:this.handleUpload}),link:external_kbnSharedDeps_React_default.a.createElement(LinkForm,{url:url,inputRef:ref=>this.inputRefs.srcUrlText=ref,onSubmit:this.setSrcUrl}),asset:external_kbnSharedDeps_React_default.a.createElement(asset_picker_AssetPicker,{assets:assets,selected:selectedAsset.id,onChange:({id:id})=>this.updateAST(id)})};return external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasSidebar__panel-noMinWidth",style:{position:"relative"}},selectUrlType,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),forms[urlType],external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}))}}const imageUpload=()=>({name:"imageUpload",displayName:image_upload_strings.getDisplayName(),help:image_upload_strings.getHelp(),resolveArgValue:true,template:Object(template_from_react_component["a"])(image_upload_ImageUpload),resolve({args:args}){return{dataurl:Object(resolve_dataurl["a"])(args,elastic_outline["a"])}}});const{Number:number_strings}=i18n["b"];const NumberArgInput=({updateValue:updateValue,value:value,confirm:confirm,commit:commit,argId:argId})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldNumber"],{compressed:true,id:argId,value:Number(value),onChange:confirm?updateValue:ev=>commit(Number(ev.target.value))})),confirm&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",onClick:()=>commit(Number(value))},confirm)));const EnhancedNumberArgInput=Object(Recompose["compose"])(Object(Recompose["withProps"])(({onValueChange:onValueChange,typeInstance:typeInstance,argValue:argValue})=>({confirm:Object(external_kbnSharedDeps_Lodash_["get"])(typeInstance,"options.confirm"),commit:onValueChange,value:argValue})),Object(stateful_prop["a"])("value"))(NumberArgInput);EnhancedNumberArgInput.propTypes={argValue:prop_types_default.a.any.isRequired,onValueChange:prop_types_default.a.func.isRequired,typeInstance:prop_types_default.a.object.isRequired};const number=()=>({name:"number",displayName:number_strings.getDisplayName(),help:number_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(EnhancedNumberArgInput),default:"0"});const number_format_NumberFormatArgInput=({numberFormats:numberFormats,onValueChange:onValueChange,argValue:argValue,argId:argId})=>external_kbnSharedDeps_React_default.a.createElement(format_select_FormatSelect,{argId:argId,argValue:argValue,formatOptions:numberFormats,onValueChange:onValueChange,defaultCustomFormat:"0.0a"});const{NumberFormat:number_format_strings}=i18n["b"];const numberFormatInitializer=(core,plugins)=>{const formatMap={NUMBER:core.uiSettings.get(public_["UI_SETTINGS"].FORMAT_NUMBER_DEFAULT_PATTERN),PERCENT:core.uiSettings.get(public_["UI_SETTINGS"].FORMAT_PERCENT_DEFAULT_PATTERN),CURRENCY:core.uiSettings.get(public_["UI_SETTINGS"].FORMAT_CURRENCY_DEFAULT_PATTERN),DURATION:"00:00:00",BYTES:core.uiSettings.get(public_["UI_SETTINGS"].FORMAT_BYTES_DEFAULT_PATTERN)};const numberFormats=[{value:formatMap.NUMBER,text:number_format_strings.getFormatNumber()},{value:formatMap.PERCENT,text:number_format_strings.getFormatPercent()},{value:formatMap.CURRENCY,text:number_format_strings.getFormatCurrency()},{value:formatMap.DURATION,text:number_format_strings.getFormatDuration()},{value:formatMap.BYTES,text:number_format_strings.getFormatBytes()}];const NumberFormatArgInput=Object(Recompose["compose"])(Object(Recompose["withProps"])({numberFormats:numberFormats}))(number_format_NumberFormatArgInput);return()=>({name:"numberFormat",displayName:number_format_strings.getDisplayName(),help:number_format_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(NumberFormatArgInput)})};var palettes=__webpack_require__(60);const{PalettePicker:palette_picker_strings}=i18n["e"];const PalettePicker=props=>{const colorPalettes=palettes["b"].map(item=>({value:item.id,title:item.label,type:item.gradient?"gradient":"fixed",palette:item.colors}));if(props.clearable){const{palette:palette,onChange:onChange=(()=>{})}=props;colorPalettes.unshift({value:"clear",title:palette_picker_strings.getEmptyPaletteLabel(),type:"text"});const onPickerChange=value=>{const canvasPalette=palettes["b"].find(item=>item.id===value);onChange(canvasPalette||null)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPalettePicker"],{id:props.id,compressed:true,palettes:colorPalettes,onChange:onPickerChange,valueOfSelected:palette?palette.id:"clear"})}const{palette:palette,onChange:onChange=(()=>{})}=props;const onPickerChange=value=>{const canvasPalette=palettes["b"].find(item=>item.id===value);if(!canvasPalette){throw new Error(palette_picker_strings.getNoPaletteFoundErrorTitle())}onChange(canvasPalette)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPalettePicker"],{id:props.id,compressed:true,palettes:colorPalettes,onChange:onPickerChange,valueOfSelected:palette.id})};var lib=__webpack_require__(49);const{Palette:palette_strings}=i18n["b"];const PaletteArgInput=({onValueChange:onValueChange,argId:argId,argValue:argValue,renderError:renderError})=>{const astToPalette=({chain:chain})=>{if(chain.length!==1||chain[0].function!=="palette"){renderError();return null}try{const colors=chain[0].arguments._.map(astObj=>{if(Object(common["getType"])(astObj)!=="string"){renderError()}return astObj});const gradient=Object(external_kbnSharedDeps_Lodash_["get"])(chain[0].arguments.gradient,"[0]");const palette=Object(lib["identifyPalette"])({colors:colors,gradient:gradient});if(palette){return palette}return{id:"custom",label:palette_strings.getCustomPaletteLabel(),colors:colors,gradient:gradient}}catch(e){renderError()}return null};const handleChange=palette=>{const astObj={type:"expression",chain:[{type:"function",function:"palette",arguments:{_:palette.colors,gradient:[palette.gradient]}}]};onValueChange(astObj)};const palette=astToPalette(argValue);if(!palette){renderError();return null}return external_kbnSharedDeps_React_default.a.createElement(PalettePicker,{id:argId,palette:palette,onChange:handleChange})};const palette_palette=()=>({name:"palette",displayName:palette_strings.getDisplayName(),help:palette_strings.getHelp(),default:"{palette #882E72 #B178A6 #D6C1DE #1965B0 #5289C7 #7BAFDE #4EB265 #90C987 #CAE0AB #F7EE55 #F6C141 #F1932D #E8601C #DC050C}",simpleTemplate:Object(template_from_react_component["a"])(PaletteArgInput)});const{Percentage:percentage_strings}=i18n["b"];const PercentageArgInput=({onValueChange:onValueChange,argValue:argValue})=>{const handleChange=ev=>onValueChange(ev.target.value/100);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{compressed:true,min:0,max:100,showLabels:true,showInput:true,value:argValue*100,onChange:handleChange})};const percentage=()=>({name:"percentage",displayName:percentage_strings.getDisplayName(),help:percentage_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(PercentageArgInput)});const{Range:range_strings}=i18n["b"];const RangeArgInput=({typeInstance:typeInstance,onValueChange:onValueChange,argValue:argValue})=>{const{min:min,max:max,step:step}=typeInstance.options;const handleChange=ev=>onValueChange(Number(ev.target.value));return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiRange"],{compressed:true,min:min,max:max,step:step,showLabels:true,showInput:true,value:argValue,onChange:handleChange})};const range=()=>({name:"range",displayName:range_strings.getDisplayName(),help:range_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(RangeArgInput)});const{Select:select_strings}=i18n["b"];const SelectArgInput=({typeInstance:typeInstance,onValueChange:onValueChange,argValue:argValue,argId:argId})=>{const choices=typeInstance.options.choices.map(({value:value,name:name})=>({value:value,text:name}));const handleChange=ev=>{const{value:value}=choices[ev.target.selectedIndex];return onValueChange(value)};return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{compressed:true,id:argId,value:argValue,options:choices,onChange:handleChange})};const select_select=()=>({name:"select",displayName:select_strings.getDisplayName(),help:select_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(SelectArgInput)});var popover=__webpack_require__(47);const ShapePreview=({shape:shape})=>{if(!shape){return external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasShapePreview"})}const weight=5;const parser=new DOMParser;const shapeSvg=parser.parseFromString(shape,"image/svg+xml").getElementsByTagName("svg").item(0);if(!shapeSvg){throw new Error("An unexpected error occurred: the SVG was not parseable")}shapeSvg.setAttribute("fill","none");shapeSvg.setAttribute("stroke","black");const viewBox=shapeSvg.getAttribute("viewBox")||"0 0 0 0";const initialViewBox=viewBox.split(" ").map(v=>parseInt(v,10));let[minX,minY,width,height]=initialViewBox;minX-=weight/2;minY-=weight/2;width+=weight;height+=weight;shapeSvg.setAttribute("viewBox",[minX,minY,width,height].join(" "));return external_kbnSharedDeps_React_default.a.createElement("div",{className:"canvasShapePreview",dangerouslySetInnerHTML:{__html:shapeSvg.outerHTML}})};const ShapePicker=({shapes:shapes,onChange:onChange=(()=>{})})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGrid"],{gutterSize:"s",columns:4,className:"canvasShapePicker"},Object.keys(shapes).sort().map(shapeKey=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:shapeKey},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>onChange(shapeKey)},external_kbnSharedDeps_React_default.a.createElement(ShapePreview,{shape:shapes[shapeKey]})))));const ShapePickerPopover=({shapes:shapes,onChange:onChange,value:value,ariaLabel:ariaLabel})=>{const button=handleClick=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPanel"],{paddingSize:"s",hasShadow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{"aria-label":ariaLabel,style:{fontSize:0},onClick:handleClick},external_kbnSharedDeps_React_default.a.createElement(ShapePreview,{shape:value?shapes[value]:undefined})));return external_kbnSharedDeps_React_default.a.createElement(popover["a"],{panelClassName:"canvas",button:button},()=>external_kbnSharedDeps_React_default.a.createElement(ShapePicker,{onChange:onChange,shapes:shapes}))};const{Shape:arguments_shape_strings}=i18n["b"];const ShapeArgInput=({onValueChange:onValueChange,argValue:argValue,typeInstance:typeInstance})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(ShapePickerPopover,{value:argValue,onChange:onValueChange,shapes:typeInstance.options.shapes,ariaLabel:typeInstance.displayName})));const arguments_shape_shape=()=>({name:"shape",displayName:arguments_shape_strings.getDisplayName(),help:arguments_shape_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(ShapeArgInput),default:'"square"'});const{String:string_strings}=i18n["b"];const StringArgInput=({updateValue:updateValue,value:value,confirm:confirm,commit:commit,argId:argId})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{compressed:true,id:argId,value:value,onChange:confirm?updateValue:ev=>commit(ev.target.value)})),confirm&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,className:"canvasSidebar__panel-noMinWidth"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",onClick:()=>commit(value)},confirm)));const EnhancedStringArgInput=Object(Recompose["compose"])(Object(Recompose["withProps"])(({onValueChange:onValueChange,typeInstance:typeInstance,argValue:argValue})=>({confirm:Object(external_kbnSharedDeps_Lodash_["get"])(typeInstance,"options.confirm"),commit:onValueChange,value:argValue})),Object(stateful_prop["a"])("value"))(StringArgInput);EnhancedStringArgInput.propTypes={argValue:prop_types_default.a.any.isRequired,onValueChange:prop_types_default.a.func.isRequired,typeInstance:prop_types_default.a.object.isRequired};const string=()=>({name:"string",displayName:string_strings.getDisplayName(),help:string_strings.getHelp(),simpleTemplate:Object(template_from_react_component["a"])(EnhancedStringArgInput)});const{Textarea:textarea_strings}=i18n["b"];const TextAreaArgInput=({updateValue:updateValue,value:value,confirm:confirm,commit:commit,renderError:renderError,argId:argId})=>{if(typeof value!=="string"){renderError();return null}return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextArea"],{className:"canvasTextArea__code",id:argId,compressed:true,rows:10,value:value,resize:"none",onChange:confirm?updateValue:ev=>commit(ev.target.value)})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"s"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",onClick:()=>commit(value)},confirm),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"xs"}))};const EnhancedTextAreaArgInput=Object(Recompose["compose"])(Object(Recompose["withProps"])(({onValueChange:onValueChange,typeInstance:typeInstance,argValue:argValue})=>({confirm:Object(external_kbnSharedDeps_Lodash_["get"])(typeInstance,"options.confirm"),commit:onValueChange,value:argValue})),Object(stateful_prop["a"])("value"))(TextAreaArgInput);EnhancedTextAreaArgInput.propTypes={argValue:prop_types_default.a.any.isRequired,onValueChange:prop_types_default.a.func.isRequired,typeInstance:prop_types_default.a.object.isRequired,renderError:prop_types_default.a.func.isRequired};const textarea_textarea=()=>({name:"textarea",displayName:textarea_strings.getDisplayName(),help:textarea_strings.getHelp(),template:Object(template_from_react_component["a"])(EnhancedTextAreaArgInput)});const{Toggle:toggle_strings}=i18n["b"];const ToggleArgInput=({onValueChange:onValueChange,argValue:argValue,argId:argId,renderError:renderError,typeInstance:typeInstance})=>{const handleChange=()=>onValueChange(!argValue);if(typeof argValue!=="boolean"){renderError();return null}return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{display:"rowCompressed"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSwitch"],{compressed:true,id:argId,checked:argValue,onChange:handleChange,className:"canvasArg__form","aria-label":typeInstance.displayName,resize:"none",label:typeInstance.options.labelValue,showLabel:true})))};const toggle=()=>({name:"toggle",displayName:toggle_strings.getDisplayName(),help:toggle_strings.getHelp(),template:Object(template_from_react_component["a"])(ToggleArgInput),default:"false"});const arguments_args=[axisConfig,datacolumn,filterGroup,imageUpload,number,palette_palette,percentage,range,select_select,arguments_shape_shape,string,textarea_textarea,toggle];const initializers=[dateFormatInitializer,numberFormatInitializer];const initializeArgs=(core,plugins)=>[...arguments_args,...initializers.map(initializer=>initializer(core,plugins))];const presentation=()=>({name:i18n["o"].presentation(),color:"#017D73"});const euiVisPalette=Object(external_kbnSharedDeps_ElasticEui_["euiPaletteColorBlind"])();const report=()=>({name:i18n["o"].report(),color:euiVisPalette[2]});const tagSpecs=[presentation,report];const{FormatDate:formatdate_strings}=i18n["p"];const formatdate=()=>({name:"formatdate",displayName:formatdate_strings.getDisplayName(),args:[{name:"format",displayName:formatdate_strings.getFormatDisplayName(),argType:"dateformat"}]});const{FormatNumber:formatnumber_strings}=i18n["p"];const formatnumber=()=>({name:"formatnumber",displayName:formatnumber_strings.getDisplayName(),args:[{name:"format",displayName:formatnumber_strings.getFormatDisplayName(),argType:"numberformat"}]});const{RoundDate:rounddate_strings}=i18n["p"];const rounddate=()=>({name:"rounddate",displayName:rounddate_strings.getDisplayName(),args:[{name:"format",displayName:rounddate_strings.getFormatDisplayName(),argType:"dateformat",help:rounddate_strings.getFormatHelp()}]});const{Sort:sort_strings}=i18n["p"];const sort=()=>({name:"sort",displayName:sort_strings.getDisplayName(),args:[{name:"_",displayName:sort_strings.getSortFieldDisplayName(),argType:"datacolumn"},{name:"reverse",displayName:sort_strings.getReverseDisplayName(),argType:"toggle"}],resolve({context:context}){if(Object(resolved_arg["b"])(context)==="ready"){return{columns:Object(external_kbnSharedDeps_Lodash_["get"])(Object(resolved_arg["c"])(context),"columns",[])}}return{columns:[]}}});const transformSpecs=[formatdate,formatnumber,rounddate,sort]}}]);