/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements. 
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(window["beatsManagement_bundle_jsonpfunction"]=window["beatsManagement_bundle_jsonpfunction"]||[]).push([[2],Array(120).concat([function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=curry;function curried(f,length,acc){return function fn(){var combined=acc.concat(Array.prototype.slice.call(arguments));return combined.length>=length?f.apply(this,combined):curried(f,length,combined)}}function curry(f){return curried(f,f.length,[])}module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(139);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(129);var _rgba2=_interopRequireDefault(_rgba);var _hsl=__webpack_require__(147);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(149);var _hsla2=_interopRequireDefault(_hsla);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var isRgb=function isRgb(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isRgba=function isRgba(color){return typeof color.red==="number"&&typeof color.green==="number"&&typeof color.blue==="number"&&typeof color.alpha==="number"};var isHsl=function isHsl(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&(typeof color.alpha!=="number"||typeof color.alpha==="undefined")};var isHsla=function isHsla(color){return typeof color.hue==="number"&&typeof color.saturation==="number"&&typeof color.lightness==="number"&&typeof color.alpha==="number"};var errMsg="Passed invalid argument to toColorString, please pass a RgbColor, RgbaColor, HslColor or HslaColor object.";function toColorString(color){if(typeof color!=="object")throw new Error(errMsg);if(isRgba(color))return(0,_rgba2.default)(color);if(isRgb(color))return(0,_rgb2.default)(color);if(isHsla(color))return(0,_hsla2.default)(color);if(isHsl(color))return(0,_hsl2.default)(color);throw new Error(errMsg)}exports.default=toColorString;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _rgbToHsl=__webpack_require__(182);var _rgbToHsl2=_interopRequireDefault(_rgbToHsl);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function parseToHsl(color){return(0,_rgbToHsl2.default)((0,_parseToRgb2.default)(color))}exports.default=parseToHsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(138);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _nameToHex=__webpack_require__(181);var _nameToHex2=_interopRequireDefault(_nameToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var hexRegex=/^#[a-fA-F0-9]{6}$/;var reducedHexRegex=/^#[a-fA-F0-9]{3}$/;var rgbRegex=/^rgb\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*\)$/;var rgbaRegex=/^rgba\(\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*(\d{1,3})\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;var hslRegex=/^hsl\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*\)$/;var hslaRegex=/^hsla\(\s*(\d{1,3})\s*,\s*(\d{1,3})%\s*,\s*(\d{1,3})%\s*,\s*([-+]?[0-9]*[.]?[0-9]+)\s*\)$/;function parseToRgb(color){if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}var normalizedColor=(0,_nameToHex2.default)(color);if(normalizedColor.match(hexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[2],16),green:parseInt(""+normalizedColor[3]+normalizedColor[4],16),blue:parseInt(""+normalizedColor[5]+normalizedColor[6],16)}}if(normalizedColor.match(reducedHexRegex)){return{red:parseInt(""+normalizedColor[1]+normalizedColor[1],16),green:parseInt(""+normalizedColor[2]+normalizedColor[2],16),blue:parseInt(""+normalizedColor[3]+normalizedColor[3],16)}}var rgbMatched=rgbRegex.exec(normalizedColor);if(rgbMatched){return{red:parseInt(""+rgbMatched[1],10),green:parseInt(""+rgbMatched[2],10),blue:parseInt(""+rgbMatched[3],10)}}var rgbaMatched=rgbaRegex.exec(normalizedColor);if(rgbaMatched){return{red:parseInt(""+rgbaMatched[1],10),green:parseInt(""+rgbaMatched[2],10),blue:parseInt(""+rgbaMatched[3],10),alpha:parseFloat(""+rgbaMatched[4])}}var hslMatched=hslRegex.exec(normalizedColor);if(hslMatched){var hue=parseInt(""+hslMatched[1],10);var saturation=parseInt(""+hslMatched[2],10)/100;var lightness=parseInt(""+hslMatched[3],10)/100;var rgbColorString="rgb("+(0,_hslToRgb2.default)(hue,saturation,lightness)+")";var hslRgbMatched=rgbRegex.exec(rgbColorString);return{red:parseInt(""+hslRgbMatched[1],10),green:parseInt(""+hslRgbMatched[2],10),blue:parseInt(""+hslRgbMatched[3],10)}}var hslaMatched=hslaRegex.exec(normalizedColor);if(hslaMatched){var _hue=parseInt(""+hslaMatched[1],10);var _saturation=parseInt(""+hslaMatched[2],10)/100;var _lightness=parseInt(""+hslaMatched[3],10)/100;var _rgbColorString="rgb("+(0,_hslToRgb2.default)(_hue,_saturation,_lightness)+")";var _hslRgbMatched=rgbRegex.exec(_rgbColorString);return{red:parseInt(""+_hslRgbMatched[1],10),green:parseInt(""+_hslRgbMatched[2],10),blue:parseInt(""+_hslRgbMatched[3],10),alpha:parseFloat(""+hslaMatched[4])}}throw new Error("Couldn't parse the color string. Please provide the color as a string in hex, rgb, rgba, hsl or hsla notation.")}exports.default=parseToRgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _capitalizeString=__webpack_require__(142);var _capitalizeString2=_interopRequireDefault(_capitalizeString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var positionMap=["Top","Right","Bottom","Left"];function generateProperty(property,position){if(!property)return position.toLowerCase();var splitProperty=property.split("-");if(splitProperty.length>1){splitProperty.splice(1,0,position);return splitProperty.reduce((function(acc,val){return""+acc+(0,_capitalizeString2.default)(val)}))}var joinedProperty=property.replace(/([a-z])([A-Z])/g,"$1"+position+"$2");return property===joinedProperty?""+property+position:joinedProperty}function generateStyles(property,valuesWithDefaults){var styles={};for(var i=0;i<valuesWithDefaults.length;i+=1){if(valuesWithDefaults[i]||valuesWithDefaults[i]===0){styles[generateProperty(property,positionMap[i])]=valuesWithDefaults[i]}}return styles}function directionalProperty(property){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}var firstValue=values[0],_values$=values[1],secondValue=_values$===undefined?firstValue:_values$,_values$2=values[2],thirdValue=_values$2===undefined?firstValue:_values$2,_values$3=values[3],fourthValue=_values$3===undefined?secondValue:_values$3;var valuesWithDefaults=[firstValue,secondValue,thirdValue,fourthValue];return generateStyles(property,valuesWithDefaults)}exports.default=directionalProperty;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function guard(lowerBoundary,upperBoundary,value){return Math.max(lowerBoundary,Math.min(upperBoundary,value))}exports.default=guard;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.Wrapper=exports.withFormsy=exports.validationRules=exports.propTypes=exports.addValidationRule=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};var _formDataToObject=__webpack_require__(212);var _formDataToObject2=_interopRequireDefault(_formDataToObject);var _propTypes=__webpack_require__(134);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(111);var _react2=_interopRequireDefault(_react);var _utils=__webpack_require__(152);var _utils2=_interopRequireDefault(_utils);var _validationRules=__webpack_require__(213);var _validationRules2=_interopRequireDefault(_validationRules);var _Wrapper=__webpack_require__(214);var _Wrapper2=_interopRequireDefault(_Wrapper);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _objectWithoutProperties(obj,keys){var target={};for(var i in obj){if(keys.indexOf(i)>=0)continue;if(!Object.prototype.hasOwnProperty.call(obj,i))continue;target[i]=obj[i]}return target}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var Formsy=function(_React$Component){_inherits(Formsy,_React$Component);function Formsy(props){_classCallCheck(this,Formsy);var _this=_possibleConstructorReturn(this,(Formsy.__proto__||Object.getPrototypeOf(Formsy)).call(this,props));_this.getChildContext=function(){return{formsy:{attachToForm:_this.attachToForm,detachFromForm:_this.detachFromForm,validate:_this.validate,isFormDisabled:_this.isFormDisabled,isValidValue:function isValidValue(component,value){return _this.runValidation(component,value).isValid}}}};_this.componentDidMount=function(){_this.validateForm()};_this.componentWillUpdate=function(){_this.prevInputNames=_this.inputs.map((function(component){return component.props.name}))};_this.componentDidUpdate=function(){if(_this.props.validationErrors&&_typeof(_this.props.validationErrors)==="object"&&Object.keys(_this.props.validationErrors).length>0){_this.setInputValidationErrors(_this.props.validationErrors)}var newInputNames=_this.inputs.map((function(component){return component.props.name}));if(_utils2.default.arraysDiffer(_this.prevInputNames,newInputNames)){_this.validateForm()}};_this.getCurrentValues=function(){return _this.inputs.reduce((function(data,component){var name=component.props.name;var dataCopy=Object.assign({},data);dataCopy[name]=component.state.value;return dataCopy}),{})};_this.getModel=function(){var currentValues=_this.getCurrentValues();return _this.mapModel(currentValues)};_this.getPristineValues=function(){return _this.inputs.reduce((function(data,component){var name=component.props.name;var dataCopy=Object.assign({},data);dataCopy[name]=component.props.value;return dataCopy}),{})};_this.setFormPristine=function(isPristine){_this.setState({formSubmitted:!isPristine});_this.inputs.forEach((function(component){component.setState({formSubmitted:!isPristine,isPristine:isPristine})}))};_this.setInputValidationErrors=function(errors){_this.inputs.forEach((function(component){var name=component.props.name;var args=[{isValid:!(name in errors),validationError:typeof errors[name]==="string"?[errors[name]]:errors[name]}];component.setState.apply(component,args)}))};_this.isFormDisabled=function(){return _this.props.disabled};_this.mapModel=function(model){if(_this.props.mapping){return _this.props.mapping(model)}return _formDataToObject2.default.toObj(Object.keys(model).reduce((function(mappedModel,key){var keyArray=key.split(".");var base=mappedModel;while(keyArray.length){var currentKey=keyArray.shift();base[currentKey]=keyArray.length?base[currentKey]||{}:model[key];base=base[currentKey]}return mappedModel}),{}))};_this.reset=function(data){_this.setFormPristine(true);_this.resetModel(data)};_this.resetInternal=function(event){event.preventDefault();_this.reset();if(_this.props.onReset){_this.props.onReset()}};_this.resetModel=function(data){_this.inputs.forEach((function(component){var name=component.props.name;if(data&&Object.prototype.hasOwnProperty.call(data,name)){component.setValue(data[name])}else{component.resetValue()}}));_this.validateForm()};_this.runValidation=function(component){var value=arguments.length>1&&arguments[1]!==undefined?arguments[1]:component.state.value;var currentValues=_this.getCurrentValues();var _component$props=component.props,validationError=_component$props.validationError,validationErrors=_component$props.validationErrors;var validationResults=_utils2.default.runRules(value,currentValues,component.validations,_validationRules2.default);var requiredResults=_utils2.default.runRules(value,currentValues,component.requiredValidations,_validationRules2.default);var isRequired=Object.keys(component.requiredValidations).length?!!requiredResults.success.length:false;var isValid=!validationResults.failed.length&&!(_this.props.validationErrors&&_this.props.validationErrors[component.props.name]);return{isRequired:isRequired,isValid:isRequired?false:isValid,error:function(){if(isValid&&!isRequired){return[]}if(validationResults.errors.length){return validationResults.errors}if(_this.props.validationErrors&&_this.props.validationErrors[component.props.name]){return typeof _this.props.validationErrors[component.props.name]==="string"?[_this.props.validationErrors[component.props.name]]:_this.props.validationErrors[component.props.name]}if(isRequired){var error=validationErrors[requiredResults.success[0]];return error?[error]:null}if(validationResults.failed.length){return validationResults.failed.map((function(failed){return validationErrors[failed]?validationErrors[failed]:validationError})).filter((function(x,pos,arr){return arr.indexOf(x)===pos}))}return undefined}()}};_this.attachToForm=function(component){if(_this.inputs.indexOf(component)===-1){_this.inputs.push(component)}_this.validate(component)};_this.detachFromForm=function(component){var componentPos=_this.inputs.indexOf(component);if(componentPos!==-1){_this.inputs=_this.inputs.slice(0,componentPos).concat(_this.inputs.slice(componentPos+1))}_this.validateForm()};_this.isChanged=function(){return!_utils2.default.isSame(_this.getPristineValues(),_this.getCurrentValues())};_this.submit=function(event){if(event&&event.preventDefault){event.preventDefault()}_this.setFormPristine(false);var model=_this.getModel();_this.props.onSubmit(model,_this.resetModel,_this.updateInputsWithError);if(_this.state.isValid){_this.props.onValidSubmit(model,_this.resetModel,_this.updateInputsWithError)}else{_this.props.onInvalidSubmit(model,_this.resetModel,_this.updateInputsWithError)}};_this.updateInputsWithError=function(errors){Object.keys(errors).forEach((function(name){var component=_utils2.default.find(_this.inputs,(function(input){return input.props.name===name}));if(!component){throw new Error("You are trying to update an input that does not exist. Verify errors object with input names. "+JSON.stringify(errors))}var args=[{isValid:_this.props.preventExternalInvalidation,externalError:typeof errors[name]==="string"?[errors[name]]:errors[name]}];component.setState.apply(component,args)}))};_this.validate=function(component){if(_this.state.canChange){_this.props.onChange(_this.getCurrentValues(),_this.isChanged())}var validation=_this.runValidation(component);component.setState({isValid:validation.isValid,isRequired:validation.isRequired,validationError:validation.error,externalError:null},_this.validateForm)};_this.validateForm=function(){var onValidationComplete=function onValidationComplete(){var allIsValid=_this.inputs.every((function(component){return component.state.isValid}));_this.setState({isValid:allIsValid});if(allIsValid){_this.props.onValid()}else{_this.props.onInvalid()}_this.setState({canChange:true})};_this.inputs.forEach((function(component,index){var validation=_this.runValidation(component);if(validation.isValid&&component.state.externalError){validation.isValid=false}component.setState({isValid:validation.isValid,isRequired:validation.isRequired,validationError:validation.error,externalError:!validation.isValid&&component.state.externalError?component.state.externalError:null},index===_this.inputs.length-1?onValidationComplete:null)}));if(!_this.inputs.length){_this.setState({canChange:true})}};_this.render=function(){var _this$props=_this.props,getErrorMessage=_this$props.getErrorMessage,getErrorMessages=_this$props.getErrorMessages,getValue=_this$props.getValue,hasValue=_this$props.hasValue,isFormDisabled=_this$props.isFormDisabled,isFormSubmitted=_this$props.isFormSubmitted,isPristine=_this$props.isPristine,isRequired=_this$props.isRequired,isValid=_this$props.isValid,isValidValue=_this$props.isValidValue,mapping=_this$props.mapping,onChange=_this$props.onChange,onInvalidSubmit=_this$props.onInvalidSubmit,onInvalid=_this$props.onInvalid,onReset=_this$props.onReset,onSubmit=_this$props.onSubmit,onValid=_this$props.onValid,onValidSubmit=_this$props.onValidSubmit,preventExternalInvalidation=_this$props.preventExternalInvalidation,resetValue=_this$props.resetValue,setValidations=_this$props.setValidations,setValue=_this$props.setValue,showError=_this$props.showError,showRequired=_this$props.showRequired,validationErrors=_this$props.validationErrors,nonFormsyProps=_objectWithoutProperties(_this$props,["getErrorMessage","getErrorMessages","getValue","hasValue","isFormDisabled","isFormSubmitted","isPristine","isRequired","isValid","isValidValue","mapping","onChange","onInvalidSubmit","onInvalid","onReset","onSubmit","onValid","onValidSubmit","preventExternalInvalidation","resetValue","setValidations","setValue","showError","showRequired","validationErrors"]);return _react2.default.createElement("form",_extends({onReset:_this.resetInternal,onSubmit:_this.submit},nonFormsyProps,{disabled:false}),_this.props.children)};_this.state={isValid:true,isSubmitting:false,canChange:false};_this.inputs=[];return _this}return Formsy}(_react2.default.Component);Formsy.displayName="Formsy";Formsy.defaultProps={children:null,disabled:false,getErrorMessage:function getErrorMessage(){},getErrorMessages:function getErrorMessages(){},getValue:function getValue(){},hasValue:function hasValue(){},isFormDisabled:function isFormDisabled(){},isFormSubmitted:function isFormSubmitted(){},isPristine:function isPristine(){},isRequired:function isRequired(){},isValid:function isValid(){},isValidValue:function isValidValue(){},mapping:null,onChange:function onChange(){},onError:function onError(){},onInvalid:function onInvalid(){},onInvalidSubmit:function onInvalidSubmit(){},onReset:function onReset(){},onSubmit:function onSubmit(){},onValid:function onValid(){},onValidSubmit:function onValidSubmit(){},preventExternalInvalidation:false,resetValue:function resetValue(){},setValidations:function setValidations(){},setValue:function setValue(){},showError:function showError(){},showRequired:function showRequired(){},validationErrors:null};Formsy.propTypes={children:_propTypes2.default.node,disabled:_propTypes2.default.bool,getErrorMessage:_propTypes2.default.func,getErrorMessages:_propTypes2.default.func,getValue:_propTypes2.default.func,hasValue:_propTypes2.default.func,isFormDisabled:_propTypes2.default.func,isFormSubmitted:_propTypes2.default.func,isPristine:_propTypes2.default.func,isRequired:_propTypes2.default.func,isValid:_propTypes2.default.func,isValidValue:_propTypes2.default.func,mapping:_propTypes2.default.func,onChange:_propTypes2.default.func,onInvalid:_propTypes2.default.func,onInvalidSubmit:_propTypes2.default.func,onReset:_propTypes2.default.func,onSubmit:_propTypes2.default.func,onValid:_propTypes2.default.func,onValidSubmit:_propTypes2.default.func,preventExternalInvalidation:_propTypes2.default.bool,resetValue:_propTypes2.default.func,setValidations:_propTypes2.default.func,setValue:_propTypes2.default.func,showError:_propTypes2.default.func,showRequired:_propTypes2.default.func,validationErrors:_propTypes2.default.object};Formsy.childContextTypes={formsy:_propTypes2.default.object};var addValidationRule=function addValidationRule(name,func){_validationRules2.default[name]=func};var withFormsy=_Wrapper2.default;var didWarnAboutWrapperDeprecation=false;var deprecatedWrapper=function deprecatedWrapper(Component){if(!didWarnAboutWrapperDeprecation){console.warn("Wrapper has been renamed to withFormsy. Importing Wrapper from formsy-react is depreacted and will be removed in the future. Please rename your Wrapper imports to withFormsy.");didWarnAboutWrapperDeprecation=true}return withFormsy(Component)};exports.addValidationRule=addValidationRule;exports.propTypes=_Wrapper.propTypes;exports.validationRules=_validationRules2.default;exports.withFormsy=withFormsy;exports.Wrapper=deprecatedWrapper;exports.default=Formsy},,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _rgb=__webpack_require__(139);var _rgb2=_interopRequireDefault(_rgb);var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgba(firstValue,secondValue,thirdValue,fourthValue){if(typeof firstValue==="string"&&typeof secondValue==="number"){var rgbValue=(0,_parseToRgb2.default)(firstValue);return"rgba("+rgbValue.red+","+rgbValue.green+","+rgbValue.blue+","+secondValue+")"}else if(typeof firstValue==="number"&&typeof secondValue==="number"&&typeof thirdValue==="number"&&typeof fourthValue==="number"){return fourthValue>=1?(0,_rgb2.default)(firstValue,secondValue,thirdValue):"rgba("+firstValue+","+secondValue+","+thirdValue+","+fourthValue+")"}else if(typeof firstValue==="object"&&secondValue===undefined&&thirdValue===undefined&&fourthValue===undefined){return firstValue.alpha>=1?(0,_rgb2.default)(firstValue.red,firstValue.green,firstValue.blue):"rgba("+firstValue.red+","+firstValue.green+","+firstValue.blue+","+firstValue.alpha+")"}throw new Error("Passed invalid arguments to rgba, please pass multiple numbers e.g. rgb(255, 205, 100, 0.75) or an object e.g. rgb({ red: 255, green: 205, blue: 100, alpha: 0.75 }).")}exports.default=rgba;module.exports=exports["default"]},,,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function _interopDefault(ex){return ex&&typeof ex==="object"&&"default"in ex?ex["default"]:ex}var React=_interopDefault(__webpack_require__(111));var createReactContext=_interopDefault(__webpack_require__(155));var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}var StateContext=createReactContext(null);var Container=function(){function Container(){var _this=this;_classCallCheck(this,Container);this._listeners=[];CONTAINER_DEBUG_CALLBACKS.forEach((function(cb){return cb(_this)}))}Container.prototype.setState=function setState(updater,callback){var _this2=this;return Promise.resolve().then((function(){var nextState=void 0;if(typeof updater==="function"){nextState=updater(_this2.state)}else{nextState=updater}if(nextState==null){if(callback)callback();return}_this2.state=Object.assign({},_this2.state,nextState);var promises=_this2._listeners.map((function(listener){return listener()}));return Promise.all(promises).then((function(){if(callback){return callback()}}))}))};Container.prototype.subscribe=function subscribe(fn){this._listeners.push(fn)};Container.prototype.unsubscribe=function unsubscribe(fn){this._listeners=this._listeners.filter((function(f){return f!==fn}))};return Container}();var DUMMY_STATE={};var Subscribe=function(_React$Component){_inherits(Subscribe,_React$Component);function Subscribe(){var _temp,_this3,_ret;_classCallCheck(this,Subscribe);for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}return _ret=(_temp=(_this3=_possibleConstructorReturn(this,_React$Component.call.apply(_React$Component,[this].concat(args))),_this3),_this3.state={},_this3.instances=[],_this3.unmounted=false,_this3.onUpdate=function(){return new Promise((function(resolve){if(!_this3.unmounted){_this3.setState(DUMMY_STATE,resolve)}else{resolve()}}))},_temp),_possibleConstructorReturn(_this3,_ret)}Subscribe.prototype.componentWillUnmount=function componentWillUnmount(){this.unmounted=true;this._unsubscribe()};Subscribe.prototype._unsubscribe=function _unsubscribe(){var _this4=this;this.instances.forEach((function(container){container.unsubscribe(_this4.onUpdate)}))};Subscribe.prototype._createInstances=function _createInstances(map,containers){var _this5=this;this._unsubscribe();if(map===null){throw new Error("You must wrap your <Subscribe> components with a <Provider>")}var safeMap=map;var instances=containers.map((function(ContainerItem){var instance=void 0;if((typeof ContainerItem==="undefined"?"undefined":_typeof(ContainerItem))==="object"&&ContainerItem instanceof Container){instance=ContainerItem}else{instance=safeMap.get(ContainerItem);if(!instance){instance=new ContainerItem;safeMap.set(ContainerItem,instance)}}instance.unsubscribe(_this5.onUpdate);instance.subscribe(_this5.onUpdate);return instance}));this.instances=instances;return instances};Subscribe.prototype.render=function render(){var _this6=this;return React.createElement(StateContext.Consumer,null,(function(map){return _this6.props.children.apply(null,_this6._createInstances(map,_this6.props.to))}))};return Subscribe}(React.Component);function Provider(props){return React.createElement(StateContext.Consumer,null,(function(parentMap){var childMap=new Map(parentMap);if(props.inject){props.inject.forEach((function(instance){childMap.set(instance.constructor,instance)}))}return React.createElement(StateContext.Provider,{value:childMap},props.children)}))}var CONTAINER_DEBUG_CALLBACKS=[];function __SUPER_SECRET_CONTAINER_DEBUG_HOOK__(callback){CONTAINER_DEBUG_CALLBACKS.push(callback)}exports.Container=Container;exports.Subscribe=Subscribe;exports.Provider=Provider;exports.__SUPER_SECRET_CONTAINER_DEBUG_HOOK__=__SUPER_SECRET_CONTAINER_DEBUG_HOOK__},,function(module,exports,__webpack_require__){if(false){var throwOnDirectAccess,ReactIs}else{module.exports=__webpack_require__(156)()}},function(module,exports){ace.define("ace/mode/yaml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],(function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextHighlightRules=acequire("./text_highlight_rules").TextHighlightRules;var YamlHighlightRules=function(){this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"list.markup",regex:/^(?:-{3}|\.{3})\s*(?=#|$)/},{token:"list.markup",regex:/^\s*[\-?](?:$|\s)/},{token:"constant",regex:"!![\\w//]+"},{token:"constant.language",regex:"[&\\*][a-zA-Z0-9-_]+"},{token:["meta.tag","keyword"],regex:/^(\s*\w.*?)(:(?=\s|$))/},{token:["meta.tag","keyword"],regex:/(\w+?)(\s*:(?=\s|$))/},{token:"keyword.operator",regex:"<<\\w*:\\w*"},{token:"keyword.operator",regex:"-\\s*(?=[{])"},{token:"string",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]'},{token:"string",regex:/[|>][-+\d\s]*$/,onMatch:function(val,state,stack,line){var indent=/^\s*/.exec(line)[0];if(stack.length<1){stack.push(this.next)}else{stack[0]="mlString"}if(stack.length<2){stack.push(indent.length)}else{stack[1]=indent.length}return this.token},next:"mlString"},{token:"string",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"constant.numeric",regex:/(\b|[+\-\.])[\d_]+(?:(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)(?=[^\d-\w]|$)/},{token:"constant.numeric",regex:/[+\-]?\.inf\b|NaN\b|0x[\dA-Fa-f_]+|0b[10_]+/},{token:"constant.language.boolean",regex:"\\b(?:true|false|TRUE|FALSE|True|False|yes|no)\\b"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:/[^\s,:\[\]\{\}]+/}],mlString:[{token:"indent",regex:/^\s*$/},{token:"indent",regex:/^\s*/,onMatch:function(val,state,stack){var curIndent=stack[1];if(curIndent>=val.length){this.next="start";stack.splice(0)}else{this.next="mlString"}return this.token},next:"mlString"},{token:"string",regex:".+"}]};this.normalizeRules()};oop.inherits(YamlHighlightRules,TextHighlightRules);exports.YamlHighlightRules=YamlHighlightRules}));ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],(function(acequire,exports,module){"use strict";var Range=acequire("../range").Range;var MatchingBraceOutdent=function(){};(function(){this.checkOutdent=function(line,input){if(!/^\s+$/.test(line))return false;return/^\s*\}/.test(input)};this.autoOutdent=function(doc,row){var line=doc.getLine(row);var match=line.match(/^(\s*\})/);if(!match)return 0;var column=match[1].length;var openBracePos=doc.findMatchingBracket({row:row,column:column});if(!openBracePos||openBracePos.row==row)return 0;var indent=this.$getIndent(doc.getLine(openBracePos.row));doc.replace(new Range(row,0,row,column-1),indent)};this.$getIndent=function(line){return line.match(/^\s*/)[0]}}).call(MatchingBraceOutdent.prototype);exports.MatchingBraceOutdent=MatchingBraceOutdent}));ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],(function(acequire,exports,module){"use strict";var oop=acequire("../../lib/oop");var BaseFoldMode=acequire("./fold_mode").FoldMode;var Range=acequire("../../range").Range;var FoldMode=exports.FoldMode=function(){};oop.inherits(FoldMode,BaseFoldMode);(function(){this.getFoldWidgetRange=function(session,foldStyle,row){var range=this.indentationBlock(session,row);if(range)return range;var re=/\S/;var line=session.getLine(row);var startLevel=line.search(re);if(startLevel==-1||line[startLevel]!="#")return;var startColumn=line.length;var maxRow=session.getLength();var startRow=row;var endRow=row;while(++row<maxRow){line=session.getLine(row);var level=line.search(re);if(level==-1)continue;if(line[level]!="#")break;endRow=row}if(endRow>startRow){var endColumn=session.getLine(endRow).length;return new Range(startRow,startColumn,endRow,endColumn)}};this.getFoldWidget=function(session,foldStyle,row){var line=session.getLine(row);var indent=line.search(/\S/);var next=session.getLine(row+1);var prev=session.getLine(row-1);var prevIndent=prev.search(/\S/);var nextIndent=next.search(/\S/);if(indent==-1){session.foldWidgets[row-1]=prevIndent!=-1&&prevIndent<nextIndent?"start":"";return""}if(prevIndent==-1){if(indent==nextIndent&&line[indent]=="#"&&next[indent]=="#"){session.foldWidgets[row-1]="";session.foldWidgets[row+1]="";return"start"}}else if(prevIndent==indent&&line[indent]=="#"&&prev[indent]=="#"){if(session.getLine(row-2).search(/\S/)==-1){session.foldWidgets[row-1]="start";session.foldWidgets[row+1]="";return""}}if(prevIndent!=-1&&prevIndent<indent)session.foldWidgets[row-1]="start";else session.foldWidgets[row-1]="";if(indent<nextIndent)return"start";else return""}}).call(FoldMode.prototype)}));ace.define("ace/mode/yaml",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/yaml_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/coffee"],(function(acequire,exports,module){"use strict";var oop=acequire("../lib/oop");var TextMode=acequire("./text").Mode;var YamlHighlightRules=acequire("./yaml_highlight_rules").YamlHighlightRules;var MatchingBraceOutdent=acequire("./matching_brace_outdent").MatchingBraceOutdent;var FoldMode=acequire("./folding/coffee").FoldMode;var Mode=function(){this.HighlightRules=YamlHighlightRules;this.$outdent=new MatchingBraceOutdent;this.foldingRules=new FoldMode;this.$behaviour=this.$defaultBehaviour};oop.inherits(Mode,TextMode);(function(){this.lineCommentStart=["#","//"];this.getNextLineIndent=function(state,line,tab){var indent=this.$getIndent(line);if(state=="start"){var match=line.match(/^.*[\{\(\[]\s*$/);if(match){indent+=tab}}return indent};this.checkOutdent=function(state,line,input){return this.$outdent.checkOutdent(line,input)};this.autoOutdent=function(state,doc,row){this.$outdent.autoOutdent(doc,row)};this.$id="ace/mode/yaml"}).call(Mode.prototype);exports.Mode=Mode}))},function(module,exports){ace.define("ace/theme/github",["require","exports","module","ace/lib/dom"],(function(acequire,exports,module){exports.isDark=false;exports.cssClass="ace-github";exports.cssText='.ace-github .ace_gutter {background: #e8e8e8;color: #AAA;}.ace-github  {background: #fff;color: #000;}.ace-github .ace_keyword {font-weight: bold;}.ace-github .ace_string {color: #D14;}.ace-github .ace_variable.ace_class {color: teal;}.ace-github .ace_constant.ace_numeric {color: #099;}.ace-github .ace_constant.ace_buildin {color: #0086B3;}.ace-github .ace_support.ace_function {color: #0086B3;}.ace-github .ace_comment {color: #998;font-style: italic;}.ace-github .ace_variable.ace_language  {color: #0086B3;}.ace-github .ace_paren {font-weight: bold;}.ace-github .ace_boolean {font-weight: bold;}.ace-github .ace_string.ace_regexp {color: #009926;font-weight: normal;}.ace-github .ace_variable.ace_instance {color: teal;}.ace-github .ace_constant.ace_language {font-weight: bold;}.ace-github .ace_cursor {color: black;}.ace-github.ace_focus .ace_marker-layer .ace_active-line {background: rgb(255, 255, 204);}.ace-github .ace_marker-layer .ace_active-line {background: rgb(245, 245, 245);}.ace-github .ace_marker-layer .ace_selection {background: rgb(181, 213, 255);}.ace-github.ace_multiselect .ace_selection.ace_start {box-shadow: 0 0 3px 0px white;}.ace-github.ace_nobold .ace_line > span {font-weight: normal !important;}.ace-github .ace_marker-layer .ace_step {background: rgb(252, 255, 0);}.ace-github .ace_marker-layer .ace_stack {background: rgb(164, 229, 101);}.ace-github .ace_marker-layer .ace_bracket {margin: -1px 0 0 -1px;border: 1px solid rgb(192, 192, 192);}.ace-github .ace_gutter-active-line {background-color : rgba(0, 0, 0, 0.07);}.ace-github .ace_marker-layer .ace_selected-word {background: rgb(250, 250, 255);border: 1px solid rgb(200, 200, 250);}.ace-github .ace_invisible {color: #BFBFBF}.ace-github .ace_print-margin {width: 1px;background: #e8e8e8;}.ace-github .ace_indent-guide {background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;}';var dom=acequire("../lib/dom");dom.importCssString(exports.cssText,exports.cssClass)}))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function stripUnit(value){var unitlessValue=parseFloat(value);if(isNaN(unitlessValue))return value;return unitlessValue}exports.default=stripUnit;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function colorToInt(color){return Math.round(color*255)}function convertToInt(red,green,blue){return colorToInt(red)+","+colorToInt(green)+","+colorToInt(blue)}function hslToRgb(hue,saturation,lightness){var convert=arguments.length>3&&arguments[3]!==undefined?arguments[3]:convertToInt;if(saturation===0){return convert(lightness,lightness,lightness)}var huePrime=hue%360/60;var chroma=(1-Math.abs(2*lightness-1))*saturation;var secondComponent=chroma*(1-Math.abs(huePrime%2-1));var red=0;var green=0;var blue=0;if(huePrime>=0&&huePrime<1){red=chroma;green=secondComponent}else if(huePrime>=1&&huePrime<2){red=secondComponent;green=chroma}else if(huePrime>=2&&huePrime<3){green=chroma;blue=secondComponent}else if(huePrime>=3&&huePrime<4){green=secondComponent;blue=chroma}else if(huePrime>=4&&huePrime<5){red=secondComponent;blue=chroma}else if(huePrime>=5&&huePrime<6){red=chroma;blue=secondComponent}var lightnessModification=lightness-chroma/2;var finalRed=red+lightnessModification;var finalGreen=green+lightnessModification;var finalBlue=blue+lightnessModification;return convert(finalRed,finalGreen,finalBlue)}exports.default=hslToRgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _reduceHexValue=__webpack_require__(145);var _reduceHexValue2=_interopRequireDefault(_reduceHexValue);var _numberToHex=__webpack_require__(146);var _numberToHex2=_interopRequireDefault(_numberToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function rgb(value,green,blue){if(typeof value==="number"&&typeof green==="number"&&typeof blue==="number"){return(0,_reduceHexValue2.default)("#"+(0,_numberToHex2.default)(value)+(0,_numberToHex2.default)(green)+(0,_numberToHex2.default)(blue))}else if(typeof value==="object"&&green===undefined&&blue===undefined){return(0,_reduceHexValue2.default)("#"+(0,_numberToHex2.default)(value.red)+(0,_numberToHex2.default)(value.green)+(0,_numberToHex2.default)(value.blue))}throw new Error("Passed invalid arguments to rgb, please pass multiple numbers e.g. rgb(255, 205, 100) or an object e.g. rgb({ red: 255, green: 205, blue: 100 }).")}exports.default=rgb;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(129);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function mix(){var weight=arguments.length>0&&arguments[0]!==undefined?arguments[0]:.5;var color=arguments[1];var otherColor=arguments[2];var parsedColor1=(0,_parseToRgb2.default)(color);var color1=_extends({},parsedColor1,{alpha:typeof parsedColor1.alpha==="number"?parsedColor1.alpha:1});var parsedColor2=(0,_parseToRgb2.default)(otherColor);var color2=_extends({},parsedColor2,{alpha:typeof parsedColor2.alpha==="number"?parsedColor2.alpha:1});var alphaDelta=color1.alpha-color2.alpha;var x=weight*2-1;var y=x*alphaDelta===-1?x:x+alphaDelta;var z=1+x*alphaDelta;var weight1=(y/z+1)/2;var weight2=1-weight1;var mixedColor={red:Math.floor(color1.red*weight1+color2.red*weight2),green:Math.floor(color1.green*weight1+color2.green*weight2),blue:Math.floor(color1.blue*weight1+color2.blue*weight2),alpha:color1.alpha+(color2.alpha-color1.alpha)*(weight/1)};return(0,_rgba2.default)(mixedColor)}var curriedMix=(0,_curry2.default)(mix);exports.default=curriedMix;module.exports=exports["default"]},,function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function capitalizeString(string){return string.charAt(0).toUpperCase()+string.slice(1)}exports.default=capitalizeString;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _endsWith=__webpack_require__(164);var _endsWith2=_interopRequireDefault(_endsWith);var _stripUnit=__webpack_require__(137);var _stripUnit2=_interopRequireDefault(_stripUnit);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var pxtoFactory=function pxtoFactory(to){return function(pxval){var base=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"16px";var newPxval=pxval;var newBase=base;if(typeof pxval==="string"){if(!(0,_endsWith2.default)(pxval,"px")){throw new Error('Expected a string ending in "px" or a number passed as the first argument to '+to+'(), got "'+pxval+'" instead.')}newPxval=(0,_stripUnit2.default)(pxval)}if(typeof base==="string"){if(!(0,_endsWith2.default)(base,"px")){throw new Error('Expected a string ending in "px" or a number passed as the second argument to '+to+'(), got "'+base+'" instead.')}newBase=(0,_stripUnit2.default)(base)}if(typeof newPxval==="string"){throw new Error('Passed invalid pixel value ("'+pxval+'") to '+to+'(), please pass a value like "12px" or 12.')}if(typeof newBase==="string"){throw new Error('Passed invalid base value ("'+base+'") to '+to+'(), please pass a value like "12px" or 12.')}return""+newPxval/newBase+to}};exports.default=pxtoFactory;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hiDPI(){var ratio=arguments.length>0&&arguments[0]!==undefined?arguments[0]:1.3;return"\n    @media only screen and (-webkit-min-device-pixel-ratio: "+ratio+"),\n    only screen and (min--moz-device-pixel-ratio: "+ratio+"),\n    only screen and (-o-min-device-pixel-ratio: "+ratio+"/1),\n    only screen and (min-resolution: "+Math.round(ratio*96)+"dpi),\n    only screen and (min-resolution: "+ratio+"dppx)\n  "}exports.default=hiDPI;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var reduceHexValue=function reduceHexValue(value){if(value.length===7&&value[1]===value[2]&&value[3]===value[4]&&value[5]===value[6]){return"#"+value[1]+value[3]+value[5]}return value};exports.default=reduceHexValue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function numberToHex(value){var hex=value.toString(16);return hex.length===1?"0"+hex:hex}exports.default=numberToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToHex=__webpack_require__(148);var _hslToHex2=_interopRequireDefault(_hslToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function hsl(value,saturation,lightness){if(typeof value==="number"&&typeof saturation==="number"&&typeof lightness==="number"){return(0,_hslToHex2.default)(value,saturation,lightness)}else if(typeof value==="object"&&saturation===undefined&&lightness===undefined){return(0,_hslToHex2.default)(value.hue,value.saturation,value.lightness)}throw new Error("Passed invalid arguments to hsl, please pass multiple numbers e.g. hsl(360, 0.75, 0.4) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75 }).")}exports.default=hsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToRgb=__webpack_require__(138);var _hslToRgb2=_interopRequireDefault(_hslToRgb);var _reduceHexValue=__webpack_require__(145);var _reduceHexValue2=_interopRequireDefault(_reduceHexValue);var _numberToHex=__webpack_require__(146);var _numberToHex2=_interopRequireDefault(_numberToHex);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function colorToHex(color){return(0,_numberToHex2.default)(Math.round(color*255))}function convertToHex(red,green,blue){return(0,_reduceHexValue2.default)("#"+colorToHex(red)+colorToHex(green)+colorToHex(blue))}function hslToHex(hue,saturation,lightness){return(0,_hslToRgb2.default)(hue,saturation,lightness,convertToHex)}exports.default=hslToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hslToHex=__webpack_require__(148);var _hslToHex2=_interopRequireDefault(_hslToHex);var _hslToRgb=__webpack_require__(138);var _hslToRgb2=_interopRequireDefault(_hslToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function hsla(value,saturation,lightness,alpha){if(typeof value==="number"&&typeof saturation==="number"&&typeof lightness==="number"&&typeof alpha==="number"){return alpha>=1?(0,_hslToHex2.default)(value,saturation,lightness):"rgba("+(0,_hslToRgb2.default)(value,saturation,lightness)+","+alpha+")"}else if(typeof value==="object"&&saturation===undefined&&lightness===undefined&&alpha===undefined){return value.alpha>=1?(0,_hslToHex2.default)(value.hue,value.saturation,value.lightness):"rgba("+(0,_hslToRgb2.default)(value.hue,value.saturation,value.lightness)+","+value.alpha+")"}throw new Error("Passed invalid arguments to hsla, please pass multiple numbers e.g. hsl(360, 0.75, 0.4, 0.7) or an object e.g. rgb({ hue: 255, saturation: 0.4, lightness: 0.75, alpha: 0.7 }).")}exports.default=hsla;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function getLuminance(color){var rgbColor=(0,_parseToRgb2.default)(color);var _Object$keys$map=Object.keys(rgbColor).map((function(key){var channel=rgbColor[key]/255;return channel<=.03928?channel/12.92:Math.pow((channel+.055)/1.055,2.4)})),r=_Object$keys$map[0],g=_Object$keys$map[1],b=_Object$keys$map[2];return.2126*r+.7152*g+.0722*b}exports.default=getLuminance;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function generateSelectors(template,state){var stateSuffix=state?":"+state:"";return template(stateSuffix)}function statefulSelectors(states,template,stateMap){if(!template)throw new Error("You must provide a template to this method.");if(states.length===0)return generateSelectors(template,null);var selectors=[];for(var i=0;i<states.length;i+=1){if(stateMap&&stateMap.indexOf(states[i])<0){throw new Error("You passed an unsupported selector state to this method.")}selectors.push(generateSelectors(template,states[i]))}selectors=selectors.join(",");return selectors}exports.default=statefulSelectors;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _typeof=typeof Symbol==="function"&&typeof Symbol.iterator==="symbol"?function(obj){return typeof obj}:function(obj){return obj&&typeof Symbol==="function"&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj};exports.default={arraysDiffer:function arraysDiffer(a,b){var _this=this;var isDifferent=false;if(a.length!==b.length){isDifferent=true}else{a.forEach((function(item,index){if(!_this.isSame(item,b[index])){isDifferent=true}}),this)}return isDifferent},objectsDiffer:function objectsDiffer(a,b){var _this2=this;var isDifferent=false;if(Object.keys(a).length!==Object.keys(b).length){isDifferent=true}else{Object.keys(a).forEach((function(key){if(!_this2.isSame(a[key],b[key])){isDifferent=true}}),this)}return isDifferent},isSame:function isSame(a,b){if((typeof a==="undefined"?"undefined":_typeof(a))!==(typeof b==="undefined"?"undefined":_typeof(b))){return false}else if(Array.isArray(a)&&Array.isArray(b)){return!this.arraysDiffer(a,b)}else if(typeof a==="function"){return a.toString()===b.toString()}else if((typeof a==="undefined"?"undefined":_typeof(a))==="object"&&a!==null&&b!==null){return!this.objectsDiffer(a,b)}return a===b},find:function find(collection,fn){for(var i=0,l=collection.length;i<l;i+=1){var item=collection[i];if(fn(item)){return item}}return null},runRules:function runRules(value,currentValues,validations,validationRules){var results={errors:[],failed:[],success:[]};if(Object.keys(validations).length){Object.keys(validations).forEach((function(validationMethod){if(validationRules[validationMethod]&&typeof validations[validationMethod]==="function"){throw new Error("Formsy does not allow you to override default validations: "+validationMethod)}if(!validationRules[validationMethod]&&typeof validations[validationMethod]!=="function"){throw new Error("Formsy does not have the validation rule: "+validationMethod)}if(typeof validations[validationMethod]==="function"){var validation=validations[validationMethod](currentValues,value);if(typeof validation==="string"){results.errors.push(validation);results.failed.push(validationMethod)}else if(!validation){results.failed.push(validationMethod)}return}else if(typeof validations[validationMethod]!=="function"){var _validation=validationRules[validationMethod](currentValues,value,validations[validationMethod]);if(typeof _validation==="string"){results.errors.push(_validation);results.failed.push(validationMethod)}else if(!_validation){results.failed.push(validationMethod)}else{results.success.push(validationMethod)}return}results.success.push(validationMethod)}))}return results}}},,,function(module,exports,__webpack_require__){"use strict";exports.__esModule=true;var _react=__webpack_require__(111);var _react2=_interopRequireDefault(_react);var _propTypes=__webpack_require__(134);var _propTypes2=_interopRequireDefault(_propTypes);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}function createEventEmitter(value){var handlers=[];return{on:function on(handler){handlers.push(handler)},off:function off(handler){handlers=handlers.filter((function(h){return h!==handler}))},get:function get(){return value},set:function set(newValue){value=newValue;handlers.forEach((function(handler){return handler(value)}))}}}function onlyChild(children){return Array.isArray(children)?children[0]:children}var uniqueId=0;function createReactContext(defaultValue){var _Provider$childContex,_Consumer$contextType;var contextProp="__create-react-context-"+uniqueId+++"__";var Provider=function(_Component){_inherits(Provider,_Component);function Provider(){var _temp,_this,_ret;_classCallCheck(this,Provider);for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}return _ret=(_temp=(_this=_possibleConstructorReturn(this,_Component.call.apply(_Component,[this].concat(args))),_this),_this.emitter=createEventEmitter(_this.props.value),_temp),_possibleConstructorReturn(_this,_ret)}Provider.prototype.getChildContext=function getChildContext(){var _ref;return _ref={},_ref[contextProp]=this.emitter,_ref};Provider.prototype.componentWillReceiveProps=function componentWillReceiveProps(nextProps){if(this.props.value!==nextProps.value){this.emitter.set(nextProps.value)}};Provider.prototype.render=function render(){return this.props.children};return Provider}(_react.Component);Provider.childContextTypes=(_Provider$childContex={},_Provider$childContex[contextProp]=_propTypes2.default.object.isRequired,_Provider$childContex);var Consumer=function(_Component2){_inherits(Consumer,_Component2);function Consumer(){var _temp2,_this2,_ret2;_classCallCheck(this,Consumer);for(var _len2=arguments.length,args=Array(_len2),_key2=0;_key2<_len2;_key2++){args[_key2]=arguments[_key2]}return _ret2=(_temp2=(_this2=_possibleConstructorReturn(this,_Component2.call.apply(_Component2,[this].concat(args))),_this2),_this2.state={value:_this2.getValue()},_this2.onUpdate=function(){_this2.setState({value:_this2.getValue()})},_temp2),_possibleConstructorReturn(_this2,_ret2)}Consumer.prototype.componentDidMount=function componentDidMount(){if(this.context[contextProp]){this.context[contextProp].on(this.onUpdate)}};Consumer.prototype.componentWillUnmount=function componentWillUnmount(){if(this.context[contextProp]){this.context[contextProp].off(this.onUpdate)}};Consumer.prototype.getValue=function getValue(){if(this.context[contextProp]){return this.context[contextProp].get()}else{return defaultValue}};Consumer.prototype.render=function render(){return onlyChild(this.props.children)(this.state.value)};return Consumer}(_react.Component);Consumer.contextTypes=(_Consumer$contextType={},_Consumer$contextType[contextProp]=_propTypes2.default.object,_Consumer$contextType);return{Provider:Provider,Consumer:Consumer}}exports.default=createReactContext;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret=__webpack_require__(157);function emptyFunction(){}function emptyFunctionWithReset(){}emptyFunctionWithReset.resetWarningCache=emptyFunction;module.exports=function(){function shim(props,propName,componentName,location,propFullName,secret){if(secret===ReactPropTypesSecret){return}var err=new Error("Calling PropTypes validators directly is not supported by the `prop-types` package. "+"Use PropTypes.checkPropTypes() to call them. "+"Read more at http://fb.me/use-check-prop-types");err.name="Invariant Violation";throw err}shim.isRequired=shim;function getShim(){return shim}var ReactPropTypes={array:shim,bool:shim,func:shim,number:shim,object:shim,string:shim,symbol:shim,any:shim,arrayOf:getShim,element:shim,elementType:shim,instanceOf:getShim,node:shim,objectOf:getShim,oneOf:getShim,oneOfType:getShim,shape:getShim,exact:getShim,checkPropTypes:emptyFunctionWithReset,resetWarningCache:emptyFunction};ReactPropTypes.PropTypes=ReactPropTypes;return ReactPropTypes}},function(module,exports,__webpack_require__){"use strict";var ReactPropTypesSecret="SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED";module.exports=ReactPropTypesSecret},function(module,exports,__webpack_require__){"use strict";const strictUriEncode=__webpack_require__(159);const decodeComponent=__webpack_require__(160);const splitOnFirst=__webpack_require__(161);const isNullOrUndefined=value=>value===null||value===undefined;function encoderForArrayFormat(options){switch(options.arrayFormat){case"index":return key=>(result,value)=>{const index=result.length;if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[",index,"]"].join("")]}return[...result,[encode(key,options),"[",encode(index,options),"]=",encode(value,options)].join("")]};case"bracket":return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,[encode(key,options),"[]"].join("")]}return[...result,[encode(key,options),"[]=",encode(value,options)].join("")]};case"comma":case"separator":return key=>(result,value)=>{if(value===null||value===undefined||value.length===0){return result}if(result.length===0){return[[encode(key,options),"=",encode(value,options)].join("")]}return[[result,encode(value,options)].join(options.arrayFormatSeparator)]};default:return key=>(result,value)=>{if(value===undefined||options.skipNull&&value===null||options.skipEmptyString&&value===""){return result}if(value===null){return[...result,encode(key,options)]}return[...result,[encode(key,options),"=",encode(value,options)].join("")]}}}function parserForArrayFormat(options){let result;switch(options.arrayFormat){case"index":return(key,value,accumulator)=>{result=/\[(\d*)\]$/.exec(key);key=key.replace(/\[\d*\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]={}}accumulator[key][result[1]]=value};case"bracket":return(key,value,accumulator)=>{result=/(\[\])$/.exec(key);key=key.replace(/\[\]$/,"");if(!result){accumulator[key]=value;return}if(accumulator[key]===undefined){accumulator[key]=[value];return}accumulator[key]=[].concat(accumulator[key],value)};case"comma":case"separator":return(key,value,accumulator)=>{const isArray=typeof value==="string"&&value.split("").indexOf(options.arrayFormatSeparator)>-1;const newValue=isArray?value.split(options.arrayFormatSeparator).map(item=>decode(item,options)):value===null?value:decode(value,options);accumulator[key]=newValue};default:return(key,value,accumulator)=>{if(accumulator[key]===undefined){accumulator[key]=value;return}accumulator[key]=[].concat(accumulator[key],value)}}}function validateArrayFormatSeparator(value){if(typeof value!=="string"||value.length!==1){throw new TypeError("arrayFormatSeparator must be single character string")}}function encode(value,options){if(options.encode){return options.strict?strictUriEncode(value):encodeURIComponent(value)}return value}function decode(value,options){if(options.decode){return decodeComponent(value)}return value}function keysSorter(input){if(Array.isArray(input)){return input.sort()}if(typeof input==="object"){return keysSorter(Object.keys(input)).sort((a,b)=>Number(a)-Number(b)).map(key=>input[key])}return input}function removeHash(input){const hashStart=input.indexOf("#");if(hashStart!==-1){input=input.slice(0,hashStart)}return input}function getHash(url){let hash="";const hashStart=url.indexOf("#");if(hashStart!==-1){hash=url.slice(hashStart)}return hash}function extract(input){input=removeHash(input);const queryStart=input.indexOf("?");if(queryStart===-1){return""}return input.slice(queryStart+1)}function parseValue(value,options){if(options.parseNumbers&&!Number.isNaN(Number(value))&&(typeof value==="string"&&value.trim()!=="")){value=Number(value)}else if(options.parseBooleans&&value!==null&&(value.toLowerCase()==="true"||value.toLowerCase()==="false")){value=value.toLowerCase()==="true"}return value}function parse(input,options){options=Object.assign({decode:true,sort:true,arrayFormat:"none",arrayFormatSeparator:",",parseNumbers:false,parseBooleans:false},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const formatter=parserForArrayFormat(options);const ret=Object.create(null);if(typeof input!=="string"){return ret}input=input.trim().replace(/^[?#&]/,"");if(!input){return ret}for(const param of input.split("&")){let[key,value]=splitOnFirst(options.decode?param.replace(/\+/g," "):param,"=");value=value===undefined?null:["comma","separator"].includes(options.arrayFormat)?value:decode(value,options);formatter(decode(key,options),value,ret)}for(const key of Object.keys(ret)){const value=ret[key];if(typeof value==="object"&&value!==null){for(const k of Object.keys(value)){value[k]=parseValue(value[k],options)}}else{ret[key]=parseValue(value,options)}}if(options.sort===false){return ret}return(options.sort===true?Object.keys(ret).sort():Object.keys(ret).sort(options.sort)).reduce((result,key)=>{const value=ret[key];if(Boolean(value)&&typeof value==="object"&&!Array.isArray(value)){result[key]=keysSorter(value)}else{result[key]=value}return result},Object.create(null))}exports.extract=extract;exports.parse=parse;exports.stringify=(object,options)=>{if(!object){return""}options=Object.assign({encode:true,strict:true,arrayFormat:"none",arrayFormatSeparator:","},options);validateArrayFormatSeparator(options.arrayFormatSeparator);const shouldFilter=key=>options.skipNull&&isNullOrUndefined(object[key])||options.skipEmptyString&&object[key]==="";const formatter=encoderForArrayFormat(options);const objectCopy={};for(const key of Object.keys(object)){if(!shouldFilter(key)){objectCopy[key]=object[key]}}const keys=Object.keys(objectCopy);if(options.sort!==false){keys.sort(options.sort)}return keys.map(key=>{const value=object[key];if(value===undefined){return""}if(value===null){return encode(key,options)}if(Array.isArray(value)){return value.reduce(formatter(key),[]).join("&")}return encode(key,options)+"="+encode(value,options)}).filter(x=>x.length>0).join("&")};exports.parseUrl=(input,options)=>{options=Object.assign({decode:true},options);const[url,hash]=splitOnFirst(input,"#");return Object.assign({url:url.split("?")[0]||"",query:parse(extract(input),options)},options&&options.parseFragmentIdentifier&&hash?{fragmentIdentifier:decode(hash,options)}:{})};exports.stringifyUrl=(input,options)=>{options=Object.assign({encode:true,strict:true},options);const url=removeHash(input.url).split("?")[0]||"";const queryFromUrl=exports.extract(input.url);const parsedQueryFromUrl=exports.parse(queryFromUrl,{sort:false});const query=Object.assign(parsedQueryFromUrl,input.query);let queryString=exports.stringify(query,options);if(queryString){queryString=`?${queryString}`}let hash=getHash(input.url);if(input.fragmentIdentifier){hash=`#${encode(input.fragmentIdentifier,options)}`}return`${url}${queryString}${hash}`}},function(module,exports,__webpack_require__){"use strict";module.exports=str=>encodeURIComponent(str).replace(/[!'()*]/g,x=>`%${x.charCodeAt(0).toString(16).toUpperCase()}`)},function(module,exports,__webpack_require__){"use strict";var token="%[a-f0-9]{2}";var singleMatcher=new RegExp(token,"gi");var multiMatcher=new RegExp("("+token+")+","gi");function decodeComponents(components,split){try{return decodeURIComponent(components.join(""))}catch(err){}if(components.length===1){return components}split=split||1;var left=components.slice(0,split);var right=components.slice(split);return Array.prototype.concat.call([],decodeComponents(left),decodeComponents(right))}function decode(input){try{return decodeURIComponent(input)}catch(err){var tokens=input.match(singleMatcher);for(var i=1;i<tokens.length;i++){input=decodeComponents(tokens,i).join("");tokens=input.match(singleMatcher)}return input}}function customDecodeURIComponent(input){var replaceMap={"%FE%FF":"��","%FF%FE":"��"};var match=multiMatcher.exec(input);while(match){try{replaceMap[match[0]]=decodeURIComponent(match[0])}catch(err){var result=decode(match[0]);if(result!==match[0]){replaceMap[match[0]]=result}}match=multiMatcher.exec(input)}replaceMap["%C2"]="�";var entries=Object.keys(replaceMap);for(var i=0;i<entries.length;i++){var key=entries[i];input=input.replace(new RegExp(key,"g"),replaceMap[key])}return input}module.exports=function(encodedURI){if(typeof encodedURI!=="string"){throw new TypeError("Expected `encodedURI` to be of type `string`, got `"+typeof encodedURI+"`")}try{encodedURI=encodedURI.replace(/\+/g," ");return decodeURIComponent(encodedURI)}catch(err){return customDecodeURIComponent(encodedURI)}}},function(module,exports,__webpack_require__){"use strict";module.exports=(string,separator)=>{if(!(typeof string==="string"&&typeof separator==="string")){throw new TypeError("Expected the arguments to be of type `string`")}if(separator===""){return[string]}const separatorIndex=string.indexOf(separator);if(separatorIndex===-1){return[string]}return[string.slice(0,separatorIndex),string.slice(separatorIndex+separator.length)]}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.wordWrap=exports.triangle=exports.transparentize=exports.transitions=exports.toColorString=exports.tint=exports.timingFunctions=exports.textInputs=exports.stripUnit=exports.size=exports.shade=exports.setSaturation=exports.setLightness=exports.setHue=exports.selection=exports.saturate=exports.rgba=exports.rgb=exports.retinaImage=exports.rem=exports.readableColor=exports.radialGradient=exports.position=exports.placeholder=exports.parseToRgb=exports.parseToHsl=exports.padding=exports.opacify=exports.normalize=exports.modularScale=exports.mix=exports.margin=exports.lighten=exports.hsla=exports.hsl=exports.hiDPI=exports.hideVisually=exports.hideText=exports.invert=exports.grayscale=exports.getLuminance=exports.fontFace=exports.em=exports.ellipsis=exports.directionalProperty=exports.desaturate=exports.darken=exports.complement=exports.clearFix=exports.buttons=exports.borderWidth=exports.borderStyle=exports.borderRadius=exports.borderColor=exports.backgrounds=exports.backgroundImages=exports.animation=exports.adjustHue=undefined;var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);var _em=__webpack_require__(163);var _em2=_interopRequireDefault(_em);var _modularScale=__webpack_require__(165);var _modularScale2=_interopRequireDefault(_modularScale);var _rem=__webpack_require__(166);var _rem2=_interopRequireDefault(_rem);var _stripUnit=__webpack_require__(137);var _stripUnit2=_interopRequireDefault(_stripUnit);var _clearFix=__webpack_require__(167);var _clearFix2=_interopRequireDefault(_clearFix);var _ellipsis=__webpack_require__(168);var _ellipsis2=_interopRequireDefault(_ellipsis);var _fontFace=__webpack_require__(169);var _fontFace2=_interopRequireDefault(_fontFace);var _hideText=__webpack_require__(170);var _hideText2=_interopRequireDefault(_hideText);var _hideVisually=__webpack_require__(171);var _hideVisually2=_interopRequireDefault(_hideVisually);var _hiDPI=__webpack_require__(144);var _hiDPI2=_interopRequireDefault(_hiDPI);var _normalize=__webpack_require__(172);var _normalize2=_interopRequireDefault(_normalize);var _placeholder=__webpack_require__(173);var _placeholder2=_interopRequireDefault(_placeholder);var _radialGradient=__webpack_require__(174);var _radialGradient2=_interopRequireDefault(_radialGradient);var _retinaImage=__webpack_require__(175);var _retinaImage2=_interopRequireDefault(_retinaImage);var _selection=__webpack_require__(176);var _selection2=_interopRequireDefault(_selection);var _timingFunctions=__webpack_require__(177);var _timingFunctions2=_interopRequireDefault(_timingFunctions);var _triangle=__webpack_require__(178);var _triangle2=_interopRequireDefault(_triangle);var _wordWrap=__webpack_require__(179);var _wordWrap2=_interopRequireDefault(_wordWrap);var _adjustHue=__webpack_require__(180);var _adjustHue2=_interopRequireDefault(_adjustHue);var _complement=__webpack_require__(183);var _complement2=_interopRequireDefault(_complement);var _darken=__webpack_require__(184);var _darken2=_interopRequireDefault(_darken);var _desaturate=__webpack_require__(185);var _desaturate2=_interopRequireDefault(_desaturate);var _getLuminance=__webpack_require__(150);var _getLuminance2=_interopRequireDefault(_getLuminance);var _grayscale=__webpack_require__(186);var _grayscale2=_interopRequireDefault(_grayscale);var _hsl=__webpack_require__(147);var _hsl2=_interopRequireDefault(_hsl);var _hsla=__webpack_require__(149);var _hsla2=_interopRequireDefault(_hsla);var _invert=__webpack_require__(187);var _invert2=_interopRequireDefault(_invert);var _lighten=__webpack_require__(188);var _lighten2=_interopRequireDefault(_lighten);var _mix=__webpack_require__(140);var _mix2=_interopRequireDefault(_mix);var _opacify=__webpack_require__(189);var _opacify2=_interopRequireDefault(_opacify);var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _readableColor=__webpack_require__(190);var _readableColor2=_interopRequireDefault(_readableColor);var _rgb=__webpack_require__(139);var _rgb2=_interopRequireDefault(_rgb);var _rgba=__webpack_require__(129);var _rgba2=_interopRequireDefault(_rgba);var _saturate=__webpack_require__(191);var _saturate2=_interopRequireDefault(_saturate);var _setHue=__webpack_require__(192);var _setHue2=_interopRequireDefault(_setHue);var _setLightness=__webpack_require__(193);var _setLightness2=_interopRequireDefault(_setLightness);var _setSaturation=__webpack_require__(194);var _setSaturation2=_interopRequireDefault(_setSaturation);var _shade=__webpack_require__(195);var _shade2=_interopRequireDefault(_shade);var _tint=__webpack_require__(196);var _tint2=_interopRequireDefault(_tint);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _transparentize=__webpack_require__(197);var _transparentize2=_interopRequireDefault(_transparentize);var _animation=__webpack_require__(198);var _animation2=_interopRequireDefault(_animation);var _backgroundImages=__webpack_require__(199);var _backgroundImages2=_interopRequireDefault(_backgroundImages);var _backgrounds=__webpack_require__(200);var _backgrounds2=_interopRequireDefault(_backgrounds);var _borderColor=__webpack_require__(201);var _borderColor2=_interopRequireDefault(_borderColor);var _borderRadius=__webpack_require__(202);var _borderRadius2=_interopRequireDefault(_borderRadius);var _borderStyle=__webpack_require__(203);var _borderStyle2=_interopRequireDefault(_borderStyle);var _borderWidth=__webpack_require__(204);var _borderWidth2=_interopRequireDefault(_borderWidth);var _buttons=__webpack_require__(205);var _buttons2=_interopRequireDefault(_buttons);var _margin=__webpack_require__(206);var _margin2=_interopRequireDefault(_margin);var _padding=__webpack_require__(207);var _padding2=_interopRequireDefault(_padding);var _position=__webpack_require__(208);var _position2=_interopRequireDefault(_position);var _size=__webpack_require__(209);var _size2=_interopRequireDefault(_size);var _textInputs=__webpack_require__(210);var _textInputs2=_interopRequireDefault(_textInputs);var _transitions=__webpack_require__(211);var _transitions2=_interopRequireDefault(_transitions);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}exports.adjustHue=_adjustHue2.default;exports.animation=_animation2.default;exports.backgroundImages=_backgroundImages2.default;exports.backgrounds=_backgrounds2.default;exports.borderColor=_borderColor2.default;exports.borderRadius=_borderRadius2.default;exports.borderStyle=_borderStyle2.default;exports.borderWidth=_borderWidth2.default;exports.buttons=_buttons2.default;exports.clearFix=_clearFix2.default;exports.complement=_complement2.default;exports.darken=_darken2.default;exports.desaturate=_desaturate2.default;exports.directionalProperty=_directionalProperty2.default;exports.ellipsis=_ellipsis2.default;exports.em=_em2.default;exports.fontFace=_fontFace2.default;exports.getLuminance=_getLuminance2.default;exports.grayscale=_grayscale2.default;exports.invert=_invert2.default;exports.hideText=_hideText2.default;exports.hideVisually=_hideVisually2.default;exports.hiDPI=_hiDPI2.default;exports.hsl=_hsl2.default;exports.hsla=_hsla2.default;exports.lighten=_lighten2.default;exports.margin=_margin2.default;exports.mix=_mix2.default;exports.modularScale=_modularScale2.default;exports.normalize=_normalize2.default;exports.opacify=_opacify2.default;exports.padding=_padding2.default;exports.parseToHsl=_parseToHsl2.default;exports.parseToRgb=_parseToRgb2.default;exports.placeholder=_placeholder2.default;exports.position=_position2.default;exports.radialGradient=_radialGradient2.default;exports.readableColor=_readableColor2.default;exports.rem=_rem2.default;exports.retinaImage=_retinaImage2.default;exports.rgb=_rgb2.default;exports.rgba=_rgba2.default;exports.saturate=_saturate2.default;exports.selection=_selection2.default;exports.setHue=_setHue2.default;exports.setLightness=_setLightness2.default;exports.setSaturation=_setSaturation2.default;exports.shade=_shade2.default;exports.size=_size2.default;exports.stripUnit=_stripUnit2.default;exports.textInputs=_textInputs2.default;exports.timingFunctions=_timingFunctions2.default;exports.tint=_tint2.default;exports.toColorString=_toColorString2.default;exports.transitions=_transitions2.default;exports.transparentize=_transparentize2.default;exports.triangle=_triangle2.default;exports.wordWrap=_wordWrap2.default},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _pxto=__webpack_require__(143);var _pxto2=_interopRequireDefault(_pxto);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var em=(0,_pxto2.default)("em");exports.default=em;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.default=function(string,suffix){return string.substr(-suffix.length)===suffix};module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.ratioNames=undefined;var _stripUnit=__webpack_require__(137);var _stripUnit2=_interopRequireDefault(_stripUnit);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var ratioNames={minorSecond:1.067,majorSecond:1.125,minorThird:1.2,majorThird:1.25,perfectFourth:1.333,augFourth:1.414,perfectFifth:1.5,minorSixth:1.6,goldenSection:1.618,majorSixth:1.667,minorSeventh:1.778,majorSeventh:1.875,octave:2,majorTenth:2.5,majorEleventh:2.667,majorTwelfth:3,doubleOctave:4};function modularScale(steps){var base=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"1em";var ratio=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"perfectFourth";if(typeof steps!=="number"){throw new Error("Please provide a number of steps to the modularScale helper.")}if(typeof ratio==="string"&&!ratioNames[ratio]){throw new Error("Please pass a number or one of the predefined scales to the modularScale helper as the ratio.")}var realBase=typeof base==="string"?(0,_stripUnit2.default)(base):base;var realRatio=typeof ratio==="string"?ratioNames[ratio]:ratio;if(typeof realBase==="string"){throw new Error('Invalid value passed as base to modularScale, expected number or em string but got "'+base+'"')}return realBase*Math.pow(realRatio,steps)+"em"}exports.ratioNames=ratioNames;exports.default=modularScale},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _pxto=__webpack_require__(143);var _pxto2=_interopRequireDefault(_pxto);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var rem=(0,_pxto2.default)("rem");exports.default=rem;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function clearFix(){var _ref;var parent=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"&";var pseudoSelector=parent+"::after";return _ref={},_ref[pseudoSelector]={clear:"both",content:'""',display:"table"},_ref}exports.default=clearFix;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function ellipsis(){var width=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"100%";return{display:"inline-block",maxWidth:width,overflow:"hidden",textOverflow:"ellipsis",whiteSpace:"nowrap",wordWrap:"normal"}}exports.default=ellipsis;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function generateFileReferences(fontFilePath,fileFormats){var fileFontReferences=fileFormats.map((function(format){return'url("'+fontFilePath+"."+format+'")'}));return fileFontReferences.join(", ")}function generateLocalReferences(localFonts){var localFontReferences=localFonts.map((function(font){return'local("'+font+'")'}));return localFontReferences.join(", ")}function generateSources(fontFilePath,localFonts,fileFormats){var fontReferences=[];if(localFonts)fontReferences.push(generateLocalReferences(localFonts));if(fontFilePath){fontReferences.push(generateFileReferences(fontFilePath,fileFormats))}return fontReferences.join(", ")}function fontFace(_ref){var fontFamily=_ref.fontFamily,fontFilePath=_ref.fontFilePath,fontStretch=_ref.fontStretch,fontStyle=_ref.fontStyle,fontVariant=_ref.fontVariant,fontWeight=_ref.fontWeight,_ref$fileFormats=_ref.fileFormats,fileFormats=_ref$fileFormats===undefined?["eot","woff2","woff","ttf","svg"]:_ref$fileFormats,localFonts=_ref.localFonts,unicodeRange=_ref.unicodeRange;if(!fontFamily)throw new Error("fontFace expects a name of a font-family.");if(!fontFilePath&&!localFonts){throw new Error("fontFace expects either the path to the font file(s) or a name of a local copy.")}if(localFonts&&!Array.isArray(localFonts)){throw new Error("fontFace expects localFonts to be an array.")}if(!Array.isArray(fileFormats)){throw new Error("fontFace expects fileFormats to be an array.")}var fontFaceDeclaration={"@font-face":{fontFamily:fontFamily,src:generateSources(fontFilePath,localFonts,fileFormats),unicodeRange:unicodeRange,fontStretch:fontStretch,fontStyle:fontStyle,fontVariant:fontVariant,fontWeight:fontWeight}};return JSON.parse(JSON.stringify(fontFaceDeclaration))}exports.default=fontFace;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hideText(){return{textIndent:"101%",overflow:"hidden",whiteSpace:"nowrap"}}exports.default=hideText;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function hideVisually(){return{border:"0",clip:"rect(0 0 0 0)",clipPath:"inset(50%)",height:"1px",margin:"-1px",overflow:"hidden",padding:"0",position:"absolute",whiteSpace:"nowrap",width:"1px"}}exports.default=hideVisually;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _opinionatedRules,_abbrTitle,_unopinionatedRules;var opinionatedRules=(_opinionatedRules={html:{fontFamily:"sans-serif"},body:{margin:"0"}},_opinionatedRules["a:active,\n  a:hover"]={outlineWidth:"0"},_opinionatedRules["button,\n  input,\n  optgroup,\n  select,\n  textarea"]={fontFamily:"sans-serif",fontSize:"100%",lineHeight:"1.15"},_opinionatedRules);var unopinionatedRules=(_unopinionatedRules={html:{lineHeight:"1.15",textSizeAdjust:"100%"}},_unopinionatedRules["article,\n  aside,\n  footer,\n  header,\n  nav,\n  section"]={display:"block"},_unopinionatedRules.h1={fontSize:"2em",margin:"0.67em 0"},_unopinionatedRules["figcaption,\n  figure,\n  main"]={display:"block"},_unopinionatedRules.figure={margin:"1em 40px"},_unopinionatedRules.hr={boxSizing:"content-box",height:"0",overflow:"visible"},_unopinionatedRules.pre={fontFamily:"monospace, monospace",fontSize:"1em"},_unopinionatedRules.a={"background-color":"transparent","-webkit-text-decoration-skip":"objects"},_unopinionatedRules["abbr[title]"]=(_abbrTitle={borderBottom:"none",textDecoration:"underline"},_abbrTitle["textDecoration"]="underline dotted",_abbrTitle),_unopinionatedRules["b,\n  strong"]={fontWeight:"inherit"},_unopinionatedRules["code,\n  kbd,\n  samp"]={fontFamily:"monospace, monospace",fontSize:"1em"},_unopinionatedRules.dfn={fontStyle:"italic"},_unopinionatedRules.mark={backgroundColor:"#ff0",color:"#000"},_unopinionatedRules.small={fontSize:"80%"},_unopinionatedRules["sub,\n  sup"]={fontSize:"75%",lineHeight:"0",position:"relative",verticalAlign:"baseline"},_unopinionatedRules.sub={bottom:"-0.25em"},_unopinionatedRules.sup={top:"-0.5em"},_unopinionatedRules["audio,\n  video"]={display:"inline-block"},_unopinionatedRules["audio:not([controls])"]={display:"none",height:"0"},_unopinionatedRules.img={borderStyle:"none"},_unopinionatedRules["svg:not(:root)"]={overflow:"hidden"},_unopinionatedRules["button,\n  input,\n  optgroup,\n  select,\n  textarea"]={margin:"0"},_unopinionatedRules["button,\n  input"]={overflow:"visible"},_unopinionatedRules["button,\n  select"]={textTransform:"none"},_unopinionatedRules['button,\n  html [type="button"],\n  [type="reset"],\n  [type="submit"]']={"-webkit-appearance":"button"},_unopinionatedRules['button::-moz-focus-inner,\n  [type="button"]::-moz-focus-inner,\n  [type="reset"]::-moz-focus-inner,\n  [type="submit"]::-moz-focus-inner']={borderStyle:"none",padding:"0"},_unopinionatedRules['button:-moz-focusring,\n  [type="button"]:-moz-focusring,\n  [type="reset"]:-moz-focusring,\n  [type="submit"]:-moz-focusring']={outline:"1px dotted ButtonText"},_unopinionatedRules.fieldset={border:"1px solid #c0c0c0",margin:"0 2px",padding:"0.35em 0.625em 0.75em"},_unopinionatedRules.legend={boxSizing:"border-box",color:"inherit",display:"table",maxWidth:"100%",padding:"0",whiteSpace:"normal"},_unopinionatedRules.progress={display:"inline-block",verticalAlign:"baseline"},_unopinionatedRules.textarea={overflow:"auto"},_unopinionatedRules['[type="checkbox"],\n  [type="radio"]']={boxSizing:"border-box",padding:"0"},_unopinionatedRules['[type="number"]::-webkit-inner-spin-button,\n  [type="number"]::-webkit-outer-spin-button']={height:"auto"},_unopinionatedRules['[type="search"]']={"-webkit-appearance":"textfield",outlineOffset:"-2px"},_unopinionatedRules['[type="search"]::-webkit-search-cancel-button,\n  [type="search"]::-webkit-search-decoration']={"-webkit-appearance":"none"},_unopinionatedRules["::-webkit-file-upload-button"]={"-webkit-appearance":"button",font:"inherit"},_unopinionatedRules["details,\n  menu"]={display:"block"},_unopinionatedRules.summary={display:"list-item"},_unopinionatedRules.canvas={display:"inline-block"},_unopinionatedRules.template={display:"none"},_unopinionatedRules["[hidden]"]={display:"none"},_unopinionatedRules);function mergeRules(baseRules,additionalRules){var mergedRules=_extends({},baseRules);Object.keys(additionalRules).forEach((function(key){if(mergedRules[key]){mergedRules[key]=_extends({},mergedRules[key],additionalRules[key])}else{mergedRules[key]=_extends({},additionalRules[key])}}));return mergedRules}function normalize(excludeOpinionated){if(excludeOpinionated)return unopinionatedRules;return mergeRules(unopinionatedRules,opinionatedRules)}exports.default=normalize;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};function placeholder(styles){var _ref;var parent=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"&";return _ref={},_ref[parent+"::-webkit-input-placeholder"]=_extends({},styles),_ref[parent+":-moz-placeholder"]=_extends({},styles),_ref[parent+"::-moz-placeholder"]=_extends({},styles),_ref[parent+":-ms-input-placeholder"]=_extends({},styles),_ref}exports.default=placeholder;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _templateObject=_taggedTemplateLiteralLoose(["radial-gradient(","","","",")"],["radial-gradient(","","","",")"]);function _taggedTemplateLiteralLoose(strings,raw){strings.raw=raw;return strings}function parseFallback(colorStops){return colorStops[0].split(" ")[0]}function constructGradientValue(literals){var template="";for(var i=0;i<literals.length;i+=1){template+=literals[i];if(i===3&&(arguments.length<=i+1?undefined:arguments[i+1])&&((arguments.length<=1?undefined:arguments[1])||(arguments.length<=2?undefined:arguments[2])||(arguments.length<=3?undefined:arguments[3]))){template=template.slice(0,-1);template+=", "+(arguments.length<=i+1?undefined:arguments[i+1])}else if(i===3&&(arguments.length<=i+1?undefined:arguments[i+1])&&!(arguments.length<=1?undefined:arguments[1])&&!(arguments.length<=2?undefined:arguments[2])&&!(arguments.length<=3?undefined:arguments[3])){template+=""+(arguments.length<=i+1?undefined:arguments[i+1])}else if(arguments.length<=i+1?undefined:arguments[i+1]){template+=(arguments.length<=i+1?undefined:arguments[i+1])+" "}}return template.trim()}function radialGradient(_ref){var colorStops=_ref.colorStops,extent=_ref.extent,fallback=_ref.fallback,position=_ref.position,shape=_ref.shape;if(!colorStops||colorStops.length<2){throw new Error("radialGradient requries at least 2 color-stops to properly render.")}return{backgroundColor:fallback||parseFallback(colorStops),backgroundImage:constructGradientValue(_templateObject,position,shape,extent,colorStops.join(", "))}}exports.default=radialGradient;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _hiDPI=__webpack_require__(144);var _hiDPI2=_interopRequireDefault(_hiDPI);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function retinaImage(filename,backgroundSize){var extension=arguments.length>2&&arguments[2]!==undefined?arguments[2]:"png";var _ref;var retinaFilename=arguments[3];var retinaSuffix=arguments.length>4&&arguments[4]!==undefined?arguments[4]:"_2x";if(!filename){throw new Error("Please supply a filename to retinaImage() as the first argument.")}var ext=extension.replace(/^\./,"");var rFilename=retinaFilename?retinaFilename+"."+ext:""+filename+retinaSuffix+"."+ext;return _ref={backgroundImage:"url("+filename+"."+ext+")"},_ref[(0,_hiDPI2.default)()]={backgroundImage:"url("+rFilename+")",backgroundSize:backgroundSize},_ref}exports.default=retinaImage;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};function selection(styles){var _ref;var parent=arguments.length>1&&arguments[1]!==undefined?arguments[1]:"";return _ref={},_ref[parent+"::-moz-selection"]=_extends({},styles),_ref[parent+"::selection"]=_extends({},styles),_ref}exports.default=selection;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var functionsMap={easeInBack:"cubic-bezier(0.600, -0.280, 0.735, 0.045)",easeInCirc:"cubic-bezier(0.600,  0.040, 0.980, 0.335)",easeInCubic:"cubic-bezier(0.550,  0.055, 0.675, 0.190)",easeInExpo:"cubic-bezier(0.950,  0.050, 0.795, 0.035)",easeInQuad:"cubic-bezier(0.550,  0.085, 0.680, 0.530)",easeInQuart:"cubic-bezier(0.895,  0.030, 0.685, 0.220)",easeInQuint:"cubic-bezier(0.755,  0.050, 0.855, 0.060)",easeInSine:"cubic-bezier(0.470,  0.000, 0.745, 0.715)",easeOutBack:"cubic-bezier(0.175,  0.885, 0.320, 1.275)",easeOutCubic:"cubic-bezier(0.215,  0.610, 0.355, 1.000)",easeOutCirc:"cubic-bezier(0.075,  0.820, 0.165, 1.000)",easeOutExpo:"cubic-bezier(0.190,  1.000, 0.220, 1.000)",easeOutQuad:"cubic-bezier(0.250,  0.460, 0.450, 0.940)",easeOutQuart:"cubic-bezier(0.165,  0.840, 0.440, 1.000)",easeOutQuint:"cubic-bezier(0.230,  1.000, 0.320, 1.000)",easeOutSine:"cubic-bezier(0.390,  0.575, 0.565, 1.000)",easeInOutBack:"cubic-bezier(0.680, -0.550, 0.265, 1.550)",easeInOutCirc:"cubic-bezier(0.785,  0.135, 0.150, 0.860)",easeInOutCubic:"cubic-bezier(0.645,  0.045, 0.355, 1.000)",easeInOutExpo:"cubic-bezier(1.000,  0.000, 0.000, 1.000)",easeInOutQuad:"cubic-bezier(0.455,  0.030, 0.515, 0.955)",easeInOutQuart:"cubic-bezier(0.770,  0.000, 0.175, 1.000)",easeInOutQuint:"cubic-bezier(0.860,  0.000, 0.070, 1.000)",easeInOutSine:"cubic-bezier(0.445,  0.050, 0.550, 0.950)"};function timingFunctions(timingFunction){return functionsMap[timingFunction]}exports.default=timingFunctions;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var getBorderWidth=function getBorderWidth(pointingDirection,height,width){switch(pointingDirection){case"top":return"0 "+width/2+"px "+height+"px "+width/2+"px";case"left":return height/2+"px "+width+"px "+height/2+"px 0";case"bottom":return height+"px "+width/2+"px 0 "+width/2+"px";case"right":return height/2+"px 0 "+height/2+"px "+width+"px";default:throw new Error("Passed invalid argument to triangle, please pass correct pointingDirection e.g. 'right'.")}};var reverseDirection={left:"Right",right:"Left",top:"Bottom",bottom:"Top"};function triangle(_ref){var _ref2;var pointingDirection=_ref.pointingDirection,height=_ref.height,width=_ref.width,foregroundColor=_ref.foregroundColor,_ref$backgroundColor=_ref.backgroundColor,backgroundColor=_ref$backgroundColor===undefined?"transparent":_ref$backgroundColor;var unitlessHeight=parseFloat(height);var unitlessWidth=parseFloat(width);if(isNaN(unitlessHeight)||isNaN(unitlessWidth)){throw new Error("Passed an invalid value to `height` or `width`. Please provide a pixel based unit")}return _ref2={borderColor:backgroundColor,width:"0",height:"0",borderWidth:getBorderWidth(pointingDirection,unitlessHeight,unitlessWidth),borderStyle:"solid"},_ref2["border"+reverseDirection[pointingDirection]+"Color"]=foregroundColor+" !important",_ref2}exports.default=triangle;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function wordWrap(){var wrap=arguments.length>0&&arguments[0]!==undefined?arguments[0]:"break-word";var wordBreak=wrap==="break-word"?"break-all":wrap;return{overflowWrap:wrap,wordWrap:wrap,wordBreak:wordBreak}}exports.default=wordWrap;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function adjustHue(degree,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{hue:(hslColor.hue+degree)%360}))}var curriedAdjustHue=(0,_curry2.default)(adjustHue);exports.default=curriedAdjustHue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var namedColorMap={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslategray:"789",lightslategrey:"789",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"0f0",limegreen:"32cd32",linen:"faf0e6",magenta:"f0f",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370db",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"db7093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"639",red:"f00",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",wheat:"f5deb3",white:"fff",whitesmoke:"f5f5f5",yellow:"ff0",yellowgreen:"9acd32"};function nameToHex(color){if(typeof color!=="string")return color;var normalizedColorName=color.toLowerCase();return namedColorMap[normalizedColorName]?"#"+namedColorMap[normalizedColorName]:color}exports.default=nameToHex;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function rgbToHsl(color){var red=color.red/255;var green=color.green/255;var blue=color.blue/255;var max=Math.max(red,green,blue);var min=Math.min(red,green,blue);var lightness=(max+min)/2;if(max===min){if(color.alpha!==undefined){return{hue:0,saturation:0,lightness:lightness,alpha:color.alpha}}else{return{hue:0,saturation:0,lightness:lightness}}}var hue=void 0;var delta=max-min;var saturation=lightness>.5?delta/(2-max-min):delta/(max+min);switch(max){case red:hue=(green-blue)/delta+(green<blue?6:0);break;case green:hue=(blue-red)/delta+2;break;default:hue=(red-green)/delta+4;break}hue*=60;if(color.alpha!==undefined){return{hue:hue,saturation:saturation,lightness:lightness,alpha:color.alpha}}return{hue:hue,saturation:saturation,lightness:lightness}}exports.default=rgbToHsl;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function complement(color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{hue:(hslColor.hue+180)%360}))}exports.default=complement;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(125);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function darken(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{lightness:(0,_guard2.default)(0,1,hslColor.lightness-amount)}))}var curriedDarken=(0,_curry2.default)(darken);exports.default=curriedDarken;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(125);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function desaturate(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{saturation:(0,_guard2.default)(0,1,hslColor.saturation-amount)}))}var curriedDesaturate=(0,_curry2.default)(desaturate);exports.default=curriedDesaturate;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function grayscale(color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{saturation:0}))}exports.default=grayscale;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function invert(color){var value=(0,_parseToRgb2.default)(color);return(0,_toColorString2.default)(_extends({},value,{red:255-value.red,green:255-value.green,blue:255-value.blue}))}exports.default=invert;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(125);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function lighten(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{lightness:(0,_guard2.default)(0,1,hslColor.lightness+amount)}))}var curriedLighten=(0,_curry2.default)(lighten);exports.default=curriedLighten;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(129);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _guard=__webpack_require__(125);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function opacify(amount,color){var parsedColor=(0,_parseToRgb2.default)(color);var alpha=typeof parsedColor.alpha==="number"?parsedColor.alpha:1;var colorWithAlpha=_extends({},parsedColor,{alpha:(0,_guard2.default)(0,1,(alpha*100+amount*100)/100)});return(0,_rgba2.default)(colorWithAlpha)}var curriedOpacify=(0,_curry2.default)(opacify);exports.default=curriedOpacify;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _getLuminance=__webpack_require__(150);var _getLuminance2=_interopRequireDefault(_getLuminance);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function readableColor(color){return(0,_getLuminance2.default)(color)>.179?"#000":"#fff"}var curriedReadableColor=(0,_curry2.default)(readableColor);exports.default=curriedReadableColor;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _guard=__webpack_require__(125);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function saturate(amount,color){var hslColor=(0,_parseToHsl2.default)(color);return(0,_toColorString2.default)(_extends({},hslColor,{saturation:(0,_guard2.default)(0,1,hslColor.saturation+amount)}))}var curriedSaturate=(0,_curry2.default)(saturate);exports.default=curriedSaturate;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function setHue(hue,color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{hue:hue}))}var curriedSetHue=(0,_curry2.default)(setHue);exports.default=curriedSetHue;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function setLightness(lightness,color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{lightness:lightness}))}var curriedSetLightness=(0,_curry2.default)(setLightness);exports.default=curriedSetLightness;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _parseToHsl=__webpack_require__(122);var _parseToHsl2=_interopRequireDefault(_parseToHsl);var _toColorString=__webpack_require__(121);var _toColorString2=_interopRequireDefault(_toColorString);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function setSaturation(saturation,color){return(0,_toColorString2.default)(_extends({},(0,_parseToHsl2.default)(color),{saturation:saturation}))}var curriedSetSaturation=(0,_curry2.default)(setSaturation);exports.default=curriedSetSaturation;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _mix=__webpack_require__(140);var _mix2=_interopRequireDefault(_mix);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function shade(percentage,color){if(typeof percentage!=="number"||percentage>1||percentage<-1){throw new Error("Passed an incorrect argument to shade, please pass a percentage less than or equal to 1 and larger than or equal to -1.")}if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}return(0,_mix2.default)(percentage,color,"rgb(0, 0, 0)")}var curriedShade=(0,_curry2.default)(shade);exports.default=curriedShade;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _mix=__webpack_require__(140);var _mix2=_interopRequireDefault(_mix);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function tint(percentage,color){if(typeof percentage!=="number"||percentage>1||percentage<-1){throw new Error("Passed an incorrect argument to tint, please pass a percentage less than or equal to 1 and larger than or equal to -1.")}if(typeof color!=="string"){throw new Error("Passed an incorrect argument to a color function, please pass a string representation of a color.")}return(0,_mix2.default)(percentage,color,"rgb(255, 255, 255)")}var curriedTint=(0,_curry2.default)(tint);exports.default=curriedTint;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _rgba=__webpack_require__(129);var _rgba2=_interopRequireDefault(_rgba);var _parseToRgb=__webpack_require__(123);var _parseToRgb2=_interopRequireDefault(_parseToRgb);var _guard=__webpack_require__(125);var _guard2=_interopRequireDefault(_guard);var _curry=__webpack_require__(120);var _curry2=_interopRequireDefault(_curry);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function transparentize(amount,color){var parsedColor=(0,_parseToRgb2.default)(color);var alpha=typeof parsedColor.alpha==="number"?parsedColor.alpha:1;var colorWithAlpha=_extends({},parsedColor,{alpha:(0,_guard2.default)(0,1,(alpha*100-amount*100)/100)});return(0,_rgba2.default)(colorWithAlpha)}var curriedTransparentize=(0,_curry2.default)(transparentize);exports.default=curriedTransparentize;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function animation(){for(var _len=arguments.length,args=Array(_len),_key=0;_key<_len;_key++){args[_key]=arguments[_key]}var multiMode=Array.isArray(args[0]);if(!multiMode&&args.length>8){throw new Error("The animation shorthand only takes 8 arguments. See the specification for more information: http://mdn.io/animation")}var code=args.map((function(arg){if(multiMode&&!Array.isArray(arg)||!multiMode&&Array.isArray(arg)){throw new Error("To pass multiple animations please supply them in arrays, e.g. animation(['rotate', '2s'], ['move', '1s'])\nTo pass a single animation please supply them in simple values, e.g. animation('rotate', '2s')")}if(Array.isArray(arg)&&arg.length>8){throw new Error("The animation shorthand arrays can only have 8 elements. See the specification for more information: http://mdn.io/animation")}return Array.isArray(arg)?arg.join(" "):arg})).join(", ");return{animation:code}}exports.default=animation;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function backgroundImages(){for(var _len=arguments.length,properties=Array(_len),_key=0;_key<_len;_key++){properties[_key]=arguments[_key]}return{backgroundImage:properties.join(", ")}}exports.default=backgroundImages;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function backgrounds(){for(var _len=arguments.length,properties=Array(_len),_key=0;_key<_len;_key++){properties[_key]=arguments[_key]}return{background:properties.join(", ")}}exports.default=backgrounds;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderColor(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["borderColor"].concat(values))}exports.default=borderColor;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _capitalizeString=__webpack_require__(142);var _capitalizeString2=_interopRequireDefault(_capitalizeString);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderRadius(side,radius){var uppercaseSide=(0,_capitalizeString2.default)(side);if(!radius&&radius!==0){throw new Error("borderRadius expects a radius value as a string or number as the second argument.")}if(uppercaseSide==="Top"||uppercaseSide==="Bottom"){var _ref;return _ref={},_ref["border"+uppercaseSide+"RightRadius"]=radius,_ref["border"+uppercaseSide+"LeftRadius"]=radius,_ref}if(uppercaseSide==="Left"||uppercaseSide==="Right"){var _ref2;return _ref2={},_ref2["borderTop"+uppercaseSide+"Radius"]=radius,_ref2["borderBottom"+uppercaseSide+"Radius"]=radius,_ref2}throw new Error('borderRadius expects one of "top", "bottom", "left" or "right" as the first argument.')}exports.default=borderRadius;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderStyle(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["borderStyle"].concat(values))}exports.default=borderStyle;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function borderWidth(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["borderWidth"].concat(values))}exports.default=borderWidth;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _statefulSelectors=__webpack_require__(151);var _statefulSelectors2=_interopRequireDefault(_statefulSelectors);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var stateMap=[undefined,null,"active","focus","hover"];function template(state){return"button"+state+',\n  input[type="button"]'+state+',\n  input[type="reset"]'+state+',\n  input[type="submit"]'+state}function buttons(){for(var _len=arguments.length,states=Array(_len),_key=0;_key<_len;_key++){states[_key]=arguments[_key]}return(0,_statefulSelectors2.default)(states,template,stateMap)}exports.default=buttons;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function margin(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["margin"].concat(values))}exports.default=margin;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function padding(){for(var _len=arguments.length,values=Array(_len),_key=0;_key<_len;_key++){values[_key]=arguments[_key]}return _directionalProperty2.default.apply(undefined,["padding"].concat(values))}exports.default=padding;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _directionalProperty=__webpack_require__(124);var _directionalProperty2=_interopRequireDefault(_directionalProperty);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var positionMap=["absolute","fixed","relative","static","sticky"];function position(positionKeyword){for(var _len=arguments.length,values=Array(_len>1?_len-1:0),_key=1;_key<_len;_key++){values[_key-1]=arguments[_key]}if(positionMap.indexOf(positionKeyword)>=0){return _extends({position:positionKeyword},_directionalProperty2.default.apply(undefined,[""].concat(values)))}else{var firstValue=positionKeyword;return _directionalProperty2.default.apply(undefined,["",firstValue].concat(values))}}exports.default=position;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function size(height){var width=arguments.length>1&&arguments[1]!==undefined?arguments[1]:height;return{height:height,width:width}}exports.default=size;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _statefulSelectors=__webpack_require__(151);var _statefulSelectors2=_interopRequireDefault(_statefulSelectors);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}var stateMap=[undefined,null,"active","focus","hover"];function template(state){return'input[type="color"]'+state+',\n    input[type="date"]'+state+',\n    input[type="datetime"]'+state+',\n    input[type="datetime-local"]'+state+',\n    input[type="email"]'+state+',\n    input[type="month"]'+state+',\n    input[type="number"]'+state+',\n    input[type="password"]'+state+',\n    input[type="search"]'+state+',\n    input[type="tel"]'+state+',\n    input[type="text"]'+state+',\n    input[type="time"]'+state+',\n    input[type="url"]'+state+',\n    input[type="week"]'+state+",\n    input:not([type])"+state+",\n    textarea"+state}function textInputs(){for(var _len=arguments.length,states=Array(_len),_key=0;_key<_len;_key++){states[_key]=arguments[_key]}return(0,_statefulSelectors2.default)(states,template,stateMap)}exports.default=textInputs;module.exports=exports["default"]},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});function transitions(){for(var _len=arguments.length,properties=Array(_len),_key=0;_key<_len;_key++){properties[_key]=arguments[_key]}return{transition:properties.join(", ")}}exports.default=transitions;module.exports=exports["default"]},function(module,exports){function toObj(source){return Object.keys(source).reduce((function(output,key){var parentKey=key.match(/[^\[]*/i);var paths=key.match(/\[.*?\]/g)||[];paths=[parentKey[0]].concat(paths).map((function(key){return key.replace(/\[|\]/g,"")}));var currentPath=output;while(paths.length){var pathKey=paths.shift();if(pathKey in currentPath){currentPath=currentPath[pathKey]}else{currentPath[pathKey]=paths.length?isNaN(paths[0])?{}:[]:source[key];currentPath=currentPath[pathKey]}}return output}),{})}function fromObj(obj){function recur(newObj,propName,currVal){if(Array.isArray(currVal)||Object.prototype.toString.call(currVal)==="[object Object]"){Object.keys(currVal).forEach((function(v){recur(newObj,propName+"["+v+"]",currVal[v])}));return newObj}newObj[propName]=currVal;return newObj}var keys=Object.keys(obj);return keys.reduce((function(newObj,propName){return recur(newObj,propName,obj[propName])}),{})}module.exports={fromObj:fromObj,toObj:toObj}},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});var _isExisty=function _isExisty(value){return value!==null&&value!==undefined};var isEmpty=function isEmpty(value){return value===""};var validations={isDefaultRequiredValue:function isDefaultRequiredValue(values,value){return value===undefined||value===null||value===""},isExisty:function isExisty(values,value){return _isExisty(value)},matchRegexp:function matchRegexp(values,value,regexp){return!_isExisty(value)||isEmpty(value)||regexp.test(value)},isUndefined:function isUndefined(values,value){return value===undefined},isEmptyString:function isEmptyString(values,value){return isEmpty(value)},isEmail:function isEmail(values,value){return validations.matchRegexp(values,value,/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/i)},isUrl:function isUrl(values,value){return validations.matchRegexp(values,value,/^(?:\w+:)?\/\/([^\s.]+\.\S{2}|localhost[:?\d]*)\S*$/i)},isTrue:function isTrue(values,value){return value===true},isFalse:function isFalse(values,value){return value===false},isNumeric:function isNumeric(values,value){if(typeof value==="number"){return true}return validations.matchRegexp(values,value,/^[-+]?(?:\d*[.])?\d+$/)},isAlpha:function isAlpha(values,value){return validations.matchRegexp(values,value,/^[A-Z]+$/i)},isAlphanumeric:function isAlphanumeric(values,value){return validations.matchRegexp(values,value,/^[0-9A-Z]+$/i)},isInt:function isInt(values,value){return validations.matchRegexp(values,value,/^(?:[-+]?(?:0|[1-9]\d*))$/)},isFloat:function isFloat(values,value){return validations.matchRegexp(values,value,/^(?:[-+]?(?:\d+))?(?:\.\d*)?(?:[eE][+-]?(?:\d+))?$/)},isWords:function isWords(values,value){return validations.matchRegexp(values,value,/^[A-Z\s]+$/i)},isSpecialWords:function isSpecialWords(values,value){return validations.matchRegexp(values,value,/^[A-Z\s\u00C0-\u017F]+$/i)},isLength:function isLength(values,value,length){return!_isExisty(value)||isEmpty(value)||value.length===length},equals:function equals(values,value,eql){return!_isExisty(value)||isEmpty(value)||value===eql},equalsField:function equalsField(values,value,field){return value===values[field]},maxLength:function maxLength(values,value,length){return!_isExisty(value)||value.length<=length},minLength:function minLength(values,value,length){return!_isExisty(value)||isEmpty(value)||value.length>=length}};exports.default=validations},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});exports.propTypes=undefined;var _extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};var _createClass=function(){function defineProperties(target,props){for(var i=0;i<props.length;i++){var descriptor=props[i];descriptor.enumerable=descriptor.enumerable||false;descriptor.configurable=true;if("value"in descriptor)descriptor.writable=true;Object.defineProperty(target,descriptor.key,descriptor)}}return function(Constructor,protoProps,staticProps){if(protoProps)defineProperties(Constructor.prototype,protoProps);if(staticProps)defineProperties(Constructor,staticProps);return Constructor}}();var _propTypes=__webpack_require__(134);var _propTypes2=_interopRequireDefault(_propTypes);var _react=__webpack_require__(111);var _react2=_interopRequireDefault(_react);var _utils=__webpack_require__(152);var _utils2=_interopRequireDefault(_utils);function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _classCallCheck(instance,Constructor){if(!(instance instanceof Constructor)){throw new TypeError("Cannot call a class as a function")}}function _possibleConstructorReturn(self,call){if(!self){throw new ReferenceError("this hasn't been initialised - super() hasn't been called")}return call&&(typeof call==="object"||typeof call==="function")?call:self}function _inherits(subClass,superClass){if(typeof superClass!=="function"&&superClass!==null){throw new TypeError("Super expression must either be null or a function, not "+typeof superClass)}subClass.prototype=Object.create(superClass&&superClass.prototype,{constructor:{value:subClass,enumerable:false,writable:true,configurable:true}});if(superClass)Object.setPrototypeOf?Object.setPrototypeOf(subClass,superClass):subClass.__proto__=superClass}var convertValidationsToObject=function convertValidationsToObject(validations){if(typeof validations==="string"){return validations.split(/,(?![^{[]*[}\]])/g).reduce((function(validationsAccumulator,validation){var args=validation.split(":");var validateMethod=args.shift();args=args.map((function(arg){try{return JSON.parse(arg)}catch(e){return arg}}));if(args.length>1){throw new Error("Formsy does not support multiple args on string validations. Use object format of validations instead.")}var validationsAccumulatorCopy=Object.assign({},validationsAccumulator);validationsAccumulatorCopy[validateMethod]=args.length?args[0]:true;return validationsAccumulatorCopy}),{})}return validations||{}};var propTypes={innerRef:_propTypes2.default.func,name:_propTypes2.default.string.isRequired,required:_propTypes2.default.oneOfType([_propTypes2.default.bool,_propTypes2.default.object,_propTypes2.default.string]),validations:_propTypes2.default.oneOfType([_propTypes2.default.object,_propTypes2.default.string]),value:_propTypes2.default.any};exports.propTypes=propTypes;exports.default=function(Component){var WrappedComponent=function(_React$Component){_inherits(WrappedComponent,_React$Component);function WrappedComponent(props){_classCallCheck(this,WrappedComponent);var _this=_possibleConstructorReturn(this,(WrappedComponent.__proto__||Object.getPrototypeOf(WrappedComponent)).call(this,props));_this.getErrorMessage=function(){var messages=_this.getErrorMessages();return messages.length?messages[0]:null};_this.getErrorMessages=function(){if(!_this.isValid()||_this.showRequired()){return _this.state.externalError||_this.state.validationError||[]}return[]};_this.getValue=function(){return _this.state.value};_this.setValidations=function(validations,required){_this.validations=convertValidationsToObject(validations)||{};_this.requiredValidations=required===true?{isDefaultRequiredValue:true}:convertValidationsToObject(required)};_this.setValue=function(value){var validate=arguments.length>1&&arguments[1]!==undefined?arguments[1]:true;if(!validate){_this.setState({value:value})}else{_this.setState({value:value,isPristine:false},(function(){_this.context.formsy.validate(_this)}))}};_this.hasValue=function(){return _this.state.value!==""};_this.isFormDisabled=function(){return _this.context.formsy.isFormDisabled()};_this.isFormSubmitted=function(){return _this.state.formSubmitted};_this.isPristine=function(){return _this.state.isPristine};_this.isRequired=function(){return!!_this.props.required};_this.isValid=function(){return _this.state.isValid};_this.isValidValue=function(value){return _this.context.formsy.isValidValue.call(null,_this,value)};_this.resetValue=function(){_this.setState({value:_this.state.pristineValue,isPristine:true},(function(){_this.context.formsy.validate(_this)}))};_this.showError=function(){return!_this.showRequired()&&!_this.isValid()};_this.showRequired=function(){return _this.state.isRequired};_this.state={value:props.value,isRequired:false,isValid:true,isPristine:true,pristineValue:props.value,validationError:[],externalError:null,formSubmitted:false};return _this}_createClass(WrappedComponent,[{key:"componentWillMount",value:function componentWillMount(){var _this2=this;var configure=function configure(){_this2.setValidations(_this2.props.validations,_this2.props.required);_this2.context.formsy.attachToForm(_this2)};if(!this.props.name){throw new Error("Form Input requires a name property when used")}configure()}},{key:"componentWillReceiveProps",value:function componentWillReceiveProps(nextProps){this.setValidations(nextProps.validations,nextProps.required)}},{key:"componentDidUpdate",value:function componentDidUpdate(prevProps){if(!_utils2.default.isSame(this.props.value,prevProps.value)){this.setValue(this.props.value)}if(!_utils2.default.isSame(this.props.validations,prevProps.validations)||!_utils2.default.isSame(this.props.required,prevProps.required)){this.context.formsy.validate(this)}}},{key:"componentWillUnmount",value:function componentWillUnmount(){this.context.formsy.detachFromForm(this)}},{key:"render",value:function render(){var innerRef=this.props.innerRef;var propsForElement=_extends({getErrorMessage:this.getErrorMessage,getErrorMessages:this.getErrorMessages,getValue:this.getValue,hasValue:this.hasValue,isFormDisabled:this.isFormDisabled,isValid:this.isValid,isPristine:this.isPristine,isFormSubmitted:this.isFormSubmitted,isRequired:this.isRequired,isValidValue:this.isValidValue,resetValue:this.resetValue,setValidations:this.setValidations,setValue:this.setValue,showRequired:this.showRequired,showError:this.showError},this.props);if(innerRef){propsForElement.ref=innerRef}return _react2.default.createElement(Component,propsForElement)}}]);return WrappedComponent}(_react2.default.Component);function getDisplayName(component){return component.displayName||component.name||(typeof component==="string"?component:"Component")}WrappedComponent.displayName="Formsy("+getDisplayName(Component)+")";WrappedComponent.contextTypes={formsy:_propTypes2.default.object};WrappedComponent.defaultProps={required:false,validationError:"",validationErrors:{},validations:null,value:Component.defaultValue};WrappedComponent.propTypes=propTypes;return WrappedComponent}},,,,,,,,,,,,,,,,,,,,,,,,,,,function(module,__webpack_exports__,__webpack_require__){"use strict";__webpack_require__.r(__webpack_exports__);__webpack_require__.d(__webpack_exports__,"renderApp",(function(){return renderApp}));var external_kbnSharedDeps_Theme_euiLightVars_=__webpack_require__(117);var external_kbnSharedDeps_Theme_euiLightVars_default=__webpack_require__.n(external_kbnSharedDeps_Theme_euiLightVars_);var external_kbnSharedDeps_KbnI18n_=__webpack_require__(0);var external_kbnSharedDeps_KbnI18nReact_=__webpack_require__(113);var external_kbnSharedDeps_React_=__webpack_require__(111);var external_kbnSharedDeps_React_default=__webpack_require__.n(external_kbnSharedDeps_React_);var external_kbnSharedDeps_ReactDom_=__webpack_require__(118);var external_kbnSharedDeps_ReactDom_default=__webpack_require__.n(external_kbnSharedDeps_ReactDom_);var external_kbnSharedDeps_ReactRouterDom_=__webpack_require__(114);var external_kbnSharedDeps_StyledComponents_=__webpack_require__(115);var external_kbnSharedDeps_StyledComponents_default=__webpack_require__.n(external_kbnSharedDeps_StyledComponents_);var unstated=__webpack_require__(132);var external_kbnSharedDeps_ElasticEui_=__webpack_require__(112);const Background=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"Background",componentId:"kzs0u8-0"})(["flex-grow:1;"]);const defaultContext={breadcrumbs:[],addCrumb:crumb=>null,removeCrumb:crumb=>null};const{Provider:Provider,Consumer:Consumer}=external_kbnSharedDeps_React_default.a.createContext(defaultContext);var kbn_services=__webpack_require__(5);function _defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class provider_BreadcrumbProvider extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);_defineProperty(this,"state",{breadcrumbs:[]});_defineProperty(this,"addCrumb",(breadcrumb,parents)=>{this.setState(({breadcrumbs:prevCrumbs})=>({breadcrumbs:[...prevCrumbs,{href:breadcrumb.href,breadcrumb:breadcrumb,parents:parents}]}))});_defineProperty(this,"removeCrumb",crumbToRemove=>{this.setState(({breadcrumbs:prevCrumbs})=>{const breadcrumbs=prevCrumbs.filter(prevCrumb=>{const{href:href}=prevCrumb;return!(crumbToRemove.href===href)});return{breadcrumbs:breadcrumbs}})})}render(){const{breadcrumbs:breadcrumbs}=this.state;const context={breadcrumbs:breadcrumbs.reduce((crumbs,crumbStorageItem)=>{if(crumbStorageItem.parents){crumbs=crumbs.concat(crumbStorageItem.parents)}crumbs.push(crumbStorageItem.breadcrumb);return crumbs},[]),addCrumb:this.addCrumb,removeCrumb:this.removeCrumb};if(this.props.useGlobalBreadcrumbs){kbn_services["a"].setBreadcrumbs(context.breadcrumbs)}return external_kbnSharedDeps_React_default.a.createElement(Provider,{value:context},this.props.children)}}var constants=__webpack_require__(8);class breadcrumb_BreadcrumbManager extends external_kbnSharedDeps_React_["Component"]{componentWillUnmount(){const{text:text,href:href,context:context}=this.props;context.removeCrumb({text:text,href:href})}componentDidMount(){const{text:text,href:href,parents:parents,context:context}=this.props;context.addCrumb({text:text,href:href},parents)}render(){return external_kbnSharedDeps_React_default.a.createElement("span",null)}}const Breadcrumb=({title:title,path:path,parentBreadcrumbs:parentBreadcrumbs})=>external_kbnSharedDeps_React_default.a.createElement(Consumer,null,context=>external_kbnSharedDeps_React_default.a.createElement(breadcrumb_BreadcrumbManager,{text:title,href:path?`#${constants["a"]}${path}`:`#${constants["a"]}`,parents:parentBreadcrumbs,context:context}));function beats_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class beats_BeatsContainer extends unstated["Container"]{constructor(libs){super();this.libs=libs;beats_defineProperty(this,"query",void 0);beats_defineProperty(this,"getBeatWithToken",async token=>{const beat=await this.libs.beats.getBeatWithToken(token);if(beat){this.setState({list:[beat,...this.state.list]});return beat}return null});beats_defineProperty(this,"reload",async kuery=>{if(kuery){this.query=kuery}else{this.query=undefined}const beats=await this.libs.beats.getAll(this.query);this.setState({list:beats})});beats_defineProperty(this,"deactivate",async beats=>{for(const beat of beats){await this.libs.beats.update(beat.id,{active:false})}setTimeout(async()=>{await this.reload(this.query)},100)});beats_defineProperty(this,"toggleTagAssignment",async(tagId,beats)=>{if(beats.some(beat=>beat.tags!==undefined&&beat.tags.some(id=>id===tagId))){await this.removeTagsFromBeats(beats,tagId);return"removed"}await this.assignTagsToBeats(beats,tagId);return"added"});beats_defineProperty(this,"removeTagsFromBeats",async(beats,tagId)=>{if(!beats.length){return false}const assignments=createBeatTagAssignments(beats,tagId);await this.libs.beats.removeTagsFromBeats(assignments);setTimeout(async()=>{await this.reload(this.query)},150)});beats_defineProperty(this,"assignTagsToBeats",async(beats,tagId)=>{if(!beats.length){return false}const assignments=createBeatTagAssignments(beats,tagId);await this.libs.beats.assignTagsToBeats(assignments);setTimeout(async()=>{await this.reload(this.query)},150)});this.state={list:[]}}}function createBeatTagAssignments(beats,tagId){if(typeof beats[0]==="string"){return beats.map(id=>({beatId:id,tag:tagId}))}else{return beats.map(({id:id})=>({beatId:id,tag:tagId}))}}function tags_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class tags_TagsContainer extends unstated["Container"]{constructor(libs){super();this.libs=libs;tags_defineProperty(this,"query",void 0);tags_defineProperty(this,"reload",async kuery=>{if(kuery){this.query=kuery}else{this.query=undefined}const tags=await this.libs.tags.getAll(this.query);this.setState({list:tags})});tags_defineProperty(this,"delete",async tags=>{const tagIds=tags.map(tag=>tag.id);const success=await this.libs.tags.delete(tagIds);if(success){this.setState({list:this.state.list.filter(tag=>tagIds.includes(tag.id))})}return success});tags_defineProperty(this,"upsertTag",async tag=>{const beatTag=await this.libs.tags.upsertTag(tag);await this.reload();return beatTag!==null});this.state={list:[]}}}var external_kbnSharedDeps_Lodash_=__webpack_require__(2);const Loading=()=>external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround"},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"xl"})));function _extends(){_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return _extends.apply(this,arguments)}const ChildRoutes=({routes:routes,useSwitch:useSwitch=true,...rest})=>{if(!routes){return null}const Parent=useSwitch?external_kbnSharedDeps_ReactRouterDom_["Switch"]:external_kbnSharedDeps_React_default.a.Fragment;return external_kbnSharedDeps_React_default.a.createElement(Parent,null,routes.map(route=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{key:route.path,path:route.path,render:routeProps=>{const Component=route.component;return external_kbnSharedDeps_React_default.a.createElement(Component,_extends({},routeProps,{routes:route.routes},rest))}})))};var query_string=__webpack_require__(158);function with_url_state_extends(){with_url_state_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return with_url_state_extends.apply(this,arguments)}function with_url_state_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class with_url_state_WithURLStateComponent extends external_kbnSharedDeps_React_default.a.Component{constructor(...args){super(...args);with_url_state_defineProperty(this,"historyListener",null);with_url_state_defineProperty(this,"setURLState",async state=>{let newState;const pastState=this.URLState;if(typeof state==="function"){newState=await state(pastState)}else{newState=state}const search=Object(query_string["stringify"])({...pastState,...newState},{sort:false});const newLocation={...this.props.history.location,search:search};this.props.history.replace(newLocation);this.forceUpdate()});with_url_state_defineProperty(this,"goTo",path=>{this.props.history.push({pathname:path,search:this.props.history.location.search})})}get URLState(){return Object(query_string["parse"])(decodeURIComponent(this.props.history.location.search).substring(1),{sort:false})}componentWillUnmount(){if(this.historyListener){this.historyListener()}}render(){return this.props.children({goTo:this.goTo,setUrlState:this.setURLState,urlState:this.URLState||{}})}}const WithURLState=Object(external_kbnSharedDeps_ReactRouterDom_["withRouter"])(with_url_state_WithURLStateComponent);function withUrlState(UnwrappedComponent){return origProps=>external_kbnSharedDeps_React_default.a.createElement(WithURLState,null,URLProps=>external_kbnSharedDeps_React_default.a.createElement(UnwrappedComponent,with_url_state_extends({},URLProps,origProps)))}var config_schemas=__webpack_require__(22);var config_schemas_translations_map=__webpack_require__(23);function connected_link_extends(){connected_link_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return connected_link_extends.apply(this,arguments)}const ConnectedLinkComponent=({location:location,path:path,query:query,disabled:disabled,children:children,...props})=>{if(disabled){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],connected_link_extends({"aria-disabled":"true"},props))}const pathname=path||Object(external_kbnSharedDeps_Lodash_["get"])(props.to,"pathname")||location.pathname;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Link"],{children:children,to:{...location,...props.to,pathname:pathname,query:query},className:`euiLink euiLink--primary ${props.className||""}`})};const ConnectedLink=Object(external_kbnSharedDeps_ReactRouterDom_["withRouter"])(ConnectedLinkComponent);const TagBadge=props=>{const{iconType:iconType,onClick:onClick,onClickAriaLabel:onClickAriaLabel,tag:tag}=props;const maxIdRenderSize=props.maxIdRenderSize||constants["c"].TRUNCATE_TAG_LENGTH;const idToRender=`${tag.name.substring(0,maxIdRenderSize)}${tag.name.length>maxIdRenderSize?"...":""}`;if(tag.disabled){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:"default",iconType:"cross"},idToRender)}else if(onClick&&onClickAriaLabel){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:tag.color||"primary",iconType:iconType,onClick:onClick,onClickAriaLabel:onClickAriaLabel},idToRender)}else{return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBadge"],{color:tag.color||"primary",iconType:iconType},idToRender)}};var yaml=__webpack_require__(135);var github=__webpack_require__(136);const config_list_pagination={pageSize:5,hidePerPageOptions:true};const ConfigListUi=props=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:props.configs.list||[],itemId:"id",pagination:{...config_list_pagination,totalItemCount:props.configs.total,pageIndex:props.configs.page},onChange:(table={page:{index:0,size:5}})=>{if(props.onTableChange){props.onTableChange(table.page.index,table.page.size)}},columns:[{field:"type",name:props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.typeColumnName",defaultMessage:"Type"}),truncateText:false,render:(type,config)=>{const translatedConfig=Object(config_schemas_translations_map["a"])(config_schemas["a"]).find(sc=>sc.id===type);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>props.onConfigClick("edit",config)},translatedConfig?translatedConfig.name:type)}},{field:"module",name:props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.moduleColumnName",defaultMessage:"Module"}),truncateText:false,render:(value,config)=>config.config._sub_type||props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.moduleColumn.notAvailibaleLabel",defaultMessage:"N/A"})},{field:"description",name:props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.descriptionColumnName",defaultMessage:"Description"})},{name:props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.actionsColumnName",defaultMessage:"Actions"}),actions:[{name:props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.actions.removeButtonAriaLabel",defaultMessage:"Remove"}),description:props.intl.formatMessage({id:"xpack.beatsManagement.tagTable.actions.removeTooltip",defaultMessage:"Remove this config from tag"}),type:"icon",icon:"trash",onClick:item=>props.onConfigClick("delete",item)}]}]});const ConfigList=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(ConfigListUi);function composeStateUpdaters(...updaters){return(state,props)=>updaters.reduce((currentState,updater)=>updater(currentState,props)||currentState,state)}var lib=__webpack_require__(162);const SuggestionItem=props=>{const{isSelected:isSelected,onClick:onClick,onMouseEnter:onMouseEnter,suggestion:suggestion}=props;return external_kbnSharedDeps_React_default.a.createElement(SuggestionItemContainer,{isSelected:isSelected,onClick:onClick,onMouseEnter:onMouseEnter},external_kbnSharedDeps_React_default.a.createElement(SuggestionItemIconField,{suggestionType:suggestion.type},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiIcon"],{type:getEuiIconType(suggestion.type)})),external_kbnSharedDeps_React_default.a.createElement(SuggestionItemTextField,null,suggestion.text),external_kbnSharedDeps_React_default.a.createElement(SuggestionItemDescriptionField,null,suggestion.description))};SuggestionItem.defaultProps={isSelected:false};const SuggestionItemContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"SuggestionItemContainer",componentId:"sc-1imxqfd-0"})(["display:flex;flex-direction:row;font-size:",";height:",";white-space:nowrap;background-color:",";"],props=>props.theme.eui.default.euiFontSizeS,props=>props.theme.eui.default.euiSizeXl,props=>props.isSelected?props.theme.eui.default.euiColorLightestShade:"transparent");const SuggestionItemField=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"SuggestionItemField",componentId:"sc-1imxqfd-1"})(["align-items:center;cursor:pointer;display:flex;flex-direction:row;height:",";padding:",";"],props=>props.theme.eui.default.euiSizeXl,props=>props.theme.eui.default.euiSizeXs);const SuggestionItemIconField=external_kbnSharedDeps_StyledComponents_default()(SuggestionItemField).withConfig({displayName:"SuggestionItemIconField",componentId:"sc-1imxqfd-2"})(["background-color:",";color:",";flex:0 0 auto;justify-content:center;width:",";"],props=>Object(lib["tint"])(.1,getEuiIconColor(props.theme,props.suggestionType)),props=>getEuiIconColor(props.theme,props.suggestionType),props=>props.theme.eui.default.euiSizeXl);const SuggestionItemTextField=external_kbnSharedDeps_StyledComponents_default()(SuggestionItemField).withConfig({displayName:"SuggestionItemTextField",componentId:"sc-1imxqfd-3"})(["flex:2 0 0;font-family:",";"],props=>props.theme.eui.default.euiCodeFontFamily);const SuggestionItemDescriptionField=external_kbnSharedDeps_StyledComponents_default()(SuggestionItemField).withConfig({displayName:"SuggestionItemDescriptionField",componentId:"sc-1imxqfd-4"})(["flex:3 0 0;p{display:inline;span{font-family:",";}}"],props=>props.theme.eui.default.euiCodeFontFamily);const getEuiIconType=suggestionType=>{switch(suggestionType){case"field":return"kqlField";case"value":return"kqlValue";case"recentSearch":return"search";case"conjunction":return"kqlSelector";case"operator":return"kqlOperand";default:return"empty"}};const getEuiIconColor=(theme,suggestionType)=>{switch(suggestionType){case"field":return theme.eui.default.euiColorVis7;case"value":return theme.eui.default.euiColorVis0;case"operator":return theme.eui.default.euiColorVis1;case"conjunction":return theme.eui.default.euiColorVis2;case"recentSearch":default:return theme.eui.default.euiColorMediumShade}};function autocomplete_field_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class autocomplete_field_AutocompleteField extends external_kbnSharedDeps_React_default.a.Component{constructor(...args){super(...args);autocomplete_field_defineProperty(this,"state",{areSuggestionsVisible:false,selectedIndex:null});autocomplete_field_defineProperty(this,"inputElement",null);autocomplete_field_defineProperty(this,"handleChangeInputRef",element=>{this.inputElement=element});autocomplete_field_defineProperty(this,"handleChange",evt=>{this.changeValue(evt.currentTarget.value)});autocomplete_field_defineProperty(this,"handleKeyDown",evt=>{const{suggestions:suggestions}=this.props;switch(evt.key){case"ArrowUp":evt.preventDefault();if(suggestions.length>0){this.setState(composeStateUpdaters(withSuggestionsVisible,withPreviousSuggestionSelected))}break;case"ArrowDown":evt.preventDefault();if(suggestions.length>0){this.setState(composeStateUpdaters(withSuggestionsVisible,withNextSuggestionSelected))}else{this.updateSuggestions()}break;case"Enter":evt.preventDefault();if(this.state.selectedIndex!==null){this.applySelectedSuggestion()}else{this.submit()}break;case"Escape":evt.preventDefault();this.setState(withSuggestionsHidden);break}});autocomplete_field_defineProperty(this,"handleKeyUp",evt=>{switch(evt.key){case"ArrowLeft":case"ArrowRight":case"Home":case"End":this.updateSuggestions();break}});autocomplete_field_defineProperty(this,"selectSuggestionAt",index=>()=>{this.setState(withSuggestionAtIndexSelected(index))});autocomplete_field_defineProperty(this,"applySelectedSuggestion",()=>{if(this.state.selectedIndex!==null){this.applySuggestionAt(this.state.selectedIndex)()}});autocomplete_field_defineProperty(this,"applySuggestionAt",index=>()=>{const{value:value,suggestions:suggestions}=this.props;const selectedSuggestion=suggestions[index];if(!selectedSuggestion){return}const newValue=value.substr(0,selectedSuggestion.start)+selectedSuggestion.text+value.substr(selectedSuggestion.end);this.setState(withSuggestionsHidden);this.changeValue(newValue);this.focusInputElement()});autocomplete_field_defineProperty(this,"changeValue",value=>{const{onChange:onChange}=this.props;if(onChange){onChange(value)}});autocomplete_field_defineProperty(this,"focusInputElement",()=>{if(this.inputElement){this.inputElement.focus()}});autocomplete_field_defineProperty(this,"showSuggestions",()=>{this.setState(withSuggestionsVisible)});autocomplete_field_defineProperty(this,"hideSuggestions",()=>{this.setState(withSuggestionsHidden)});autocomplete_field_defineProperty(this,"submit",()=>{const{isValid:isValid,onSubmit:onSubmit,value:value}=this.props;if(isValid&&onSubmit){onSubmit(value)}this.setState(withSuggestionsHidden)});autocomplete_field_defineProperty(this,"updateSuggestions",value=>{const inputCursorPosition=this.inputElement?this.inputElement.selectionStart||0:0;this.props.loadSuggestions(value||this.props.value,inputCursorPosition,10)})}render(){const{suggestions:suggestions,isLoadingSuggestions:isLoadingSuggestions,isValid:isValid,placeholder:placeholder,value:value}=this.props;const{areSuggestionsVisible:areSuggestionsVisible,selectedIndex:selectedIndex}=this.state;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiOutsideClickDetector"],{onOutsideClick:this.hideSuggestions},external_kbnSharedDeps_React_default.a.createElement(AutocompleteContainer,null,external_kbnSharedDeps_React_default.a.createElement(FixedEuiFieldSearch,{fullWidth:true,inputRef:this.handleChangeInputRef,isLoading:isLoadingSuggestions,isInvalid:!isValid,onChange:this.handleChange,onFocus:this.showSuggestions,onKeyDown:this.handleKeyDown,onKeyUp:this.handleKeyUp,onSearch:this.submit,placeholder:placeholder,value:value}),areSuggestionsVisible&&!isLoadingSuggestions&&suggestions.length>0?external_kbnSharedDeps_React_default.a.createElement(SuggestionsPanel,null,suggestions.map((suggestion,suggestionIndex)=>external_kbnSharedDeps_React_default.a.createElement(SuggestionItem,{key:suggestion.text,suggestion:suggestion,isSelected:suggestionIndex===selectedIndex,onMouseEnter:this.selectSuggestionAt(suggestionIndex),onClick:this.applySuggestionAt(suggestionIndex)}))):null))}componentDidUpdate(prevProps,prevState){const hasNewSuggestions=prevProps.suggestions!==this.props.suggestions;const hasNewValue=prevProps.value!==this.props.value;if(hasNewValue){this.updateSuggestions()}if(hasNewSuggestions){this.showSuggestions()}}}const withPreviousSuggestionSelected=(state,props)=>({...state,selectedIndex:props.suggestions.length===0?null:state.selectedIndex!==null?(state.selectedIndex+props.suggestions.length-1)%props.suggestions.length:Math.max(props.suggestions.length-1,0)});const withNextSuggestionSelected=(state,props)=>({...state,selectedIndex:props.suggestions.length===0?null:state.selectedIndex!==null?(state.selectedIndex+1)%props.suggestions.length:0});const withSuggestionAtIndexSelected=suggestionIndex=>(state,props)=>({...state,selectedIndex:props.suggestions.length===0?null:suggestionIndex>=0&&suggestionIndex<props.suggestions.length?suggestionIndex:0});const withSuggestionsVisible=state=>({...state,areSuggestionsVisible:true});const withSuggestionsHidden=state=>({...state,areSuggestionsVisible:false,selectedIndex:null});const FixedEuiFieldSearch=external_kbnSharedDeps_ElasticEui_["EuiFieldSearch"];const AutocompleteContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"AutocompleteContainer",componentId:"sgkya-0"})(["position:relative;"]);const SuggestionsPanel=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiPanel"]).attrs(()=>({paddingSize:"none",hasShadow:true})).withConfig({displayName:"SuggestionsPanel",componentId:"sgkya-1"})(["position:absolute;width:100%;margin-top:2px;overflow:hidden;z-index:1000;"]);class action_control_ActionControl extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);this.state={showModal:false}}render(){const{action:action,actionHandler:actionHandler,danger:danger,name:name,showWarning:showWarning,warningHeading:warningHeading,warningMessage:warningMessage}=this.props;return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",color:danger?"danger":"primary",disabled:this.props.disabled,onClick:showWarning?()=>this.setState({showModal:true}):()=>actionHandler(action)},name),this.state.showModal&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiConfirmModal"],{buttonColor:danger?"danger":"primary",cancelButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.confirmModal.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.confirmModal.confirmButtonLabel",defaultMessage:"Confirm"}),onConfirm:()=>{actionHandler(action);this.setState({showModal:false})},onCancel:()=>this.setState({showModal:false}),title:warningHeading?warningHeading:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.confirmModal.confirmWarningTitle",defaultMessage:"Confirm"})},warningMessage))}}var table=__webpack_require__(25);function tag_badge_list_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class tag_badge_list_TagBadgeList extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);tag_badge_list_defineProperty(this,"onButtonClick",async()=>{this.props.actionHandler(AssignmentActionType.Reload);this.setState(prevState=>({isPopoverOpen:!prevState.isPopoverOpen}))});tag_badge_list_defineProperty(this,"closePopover",()=>{this.setState({isPopoverOpen:false})});this.state={isPopoverOpen:false,items:[]}}render(){const button=external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",iconType:"arrowDown",iconSide:"right",onClick:this.onButtonClick,disabled:this.props.disabled},this.props.name);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPopover"],{id:"contentPanel",button:button,isOpen:this.state.isPopoverOpen,closePopover:this.closePopover,panelPaddingSize:"none",anchorPosition:"downLeft"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiContextMenuPanel"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{direction:"column",gutterSize:"xs",style:{margin:10}},!this.props.items&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"l"}),this.props.items&&this.props.items.length===0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,"No options avaliable"))),this.props.items&&this.props.items.map(tag=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:`${tag.id}`},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(TagBadge,{maxIdRenderSize:table["a"].TRUNCATE_TAG_LENGTH_SMALL,onClick:()=>this.props.actionHandler(AssignmentActionType.Assign,tag.id),onClickAriaLabel:tag.id,tag:tag}))))))))}}const OptionControl=props=>{switch(props.type){case ActionComponentType.Action:if(!props.action){throw Error("Action cannot be undefined")}return external_kbnSharedDeps_React_default.a.createElement(action_control_ActionControl,{actionHandler:props.actionHandler,action:props.action,danger:props.danger,name:props.name,showWarning:props.showWarning,warningHeading:props.warningHeading,warningMessage:props.warningMessage,disabled:props.disabled});case ActionComponentType.TagBadgeList:if(!props.actionDataKey){throw Error("actionDataKey cannot be undefined")}if(!props.actionData){throw Error("actionData cannot be undefined")}return external_kbnSharedDeps_React_default.a.createElement(tag_badge_list_TagBadgeList,{actionHandler:props.actionHandler,action:props.action,name:props.name,items:props.actionData[props.actionDataKey],disabled:props.disabled})}return external_kbnSharedDeps_React_default.a.createElement("div",null,"Invalid config")};function table_extends(){table_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return table_extends.apply(this,arguments)}function table_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}let AssignmentActionType;(function(AssignmentActionType){AssignmentActionType[AssignmentActionType["Add"]=0]="Add";AssignmentActionType[AssignmentActionType["Assign"]=1]="Assign";AssignmentActionType[AssignmentActionType["Delete"]=2]="Delete";AssignmentActionType[AssignmentActionType["Edit"]=3]="Edit";AssignmentActionType[AssignmentActionType["Reload"]=4]="Reload";AssignmentActionType[AssignmentActionType["Search"]=5]="Search"})(AssignmentActionType||(AssignmentActionType={}));const TableContainer=external_kbnSharedDeps_StyledComponents_default.a.div.withConfig({displayName:"TableContainer",componentId:"dqptsf-0"})(["padding:16px;"]);class table_Table extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);table_defineProperty(this,"resetSelection",()=>{this.setSelection([])});table_defineProperty(this,"setSelection",selection=>{this.setState({selection:selection})});table_defineProperty(this,"actionHandler",(action,payload)=>{if(this.props.actionHandler){this.props.actionHandler(action,payload)}});table_defineProperty(this,"onTableChange",({page:page})=>{if(this.props.onTableChange){this.props.onTableChange(page.index,page.size)}this.setState({pageIndex:page.index})});this.state={selection:[],pageIndex:0}}render(){const{actionData:actionData,actions:actions,hideTableControls:hideTableControls,items:items,kueryBarProps:kueryBarProps,type:type}=this.props;const pagination={pageIndex:this.state.pageIndex,pageSize:constants["c"].INITIAL_ROW_SIZE,pageSizeOptions:constants["c"].PAGE_SIZE_OPTIONS};const selectionOptions=hideTableControls?undefined:{onSelectionChange:this.setSelection,selectable:()=>true,selectableMessage:()=>external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.table.selectThisBeatTooltip",{defaultMessage:"Select this beat"}),selection:this.state.selection};return external_kbnSharedDeps_React_default.a.createElement(TableContainer,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",justifyContent:"spaceBetween"},actions&&actions.map(action=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false,key:action.name},external_kbnSharedDeps_React_default.a.createElement(OptionControl,table_extends({},action,{actionData:actionData,actionHandler:this.actionHandler,disabled:this.state.selection.length===0})))),kueryBarProps&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(autocomplete_field_AutocompleteField,table_extends({},kueryBarProps,{placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.table.filterResultsPlaceholder",{defaultMessage:"Filter results"})})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:items,itemId:"id",isSelectable:true,selection:selectionOptions,columns:type.columnDefinitions,pagination:{...pagination,totalItemCount:items.length},onChange:this.onTableChange}))}}let ActionComponentType;(function(ActionComponentType){ActionComponentType[ActionComponentType["Action"]=0]="Action";ActionComponentType[ActionComponentType["Popover"]=1]="Popover";ActionComponentType[ActionComponentType["SelectionCount"]=2]="SelectionCount";ActionComponentType[ActionComponentType["TagBadgeList"]=3]="TagBadgeList"})(ActionComponentType||(ActionComponentType={}));const beatsListActions=[{grow:false,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsListAssignmentOptions.unenrollButtonLabel",{defaultMessage:"Unenroll selected"}),showWarning:true,type:ActionComponentType.Action,warningHeading:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsListAssignmentOptions.unenrollBeatsWarninigTitle",{defaultMessage:"Unenroll selected beats?"}),warningMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsListAssignmentOptions.unenrollBeatsWarninigMessage",{defaultMessage:"The selected Beats will no longer use central management"}),action:AssignmentActionType.Delete,danger:true},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsListAssignmentOptions.setTagsButtonLabel",{defaultMessage:"Set tags"}),grow:false,type:ActionComponentType.TagBadgeList,actionDataKey:"tags",lazyLoad:true}];const tagListActions=[{danger:true,grow:false,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagListAssignmentOptions.removeTagsButtonLabel",{defaultMessage:"Remove selected"}),type:ActionComponentType.Action,showWarning:true,warningHeading:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagListAssignmentOptions.removeTagsWarninigTitle",{defaultMessage:"Remove tag(s)"}),warningMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagListAssignmentOptions.removeTagWarninigMessage",{defaultMessage:"Remove the tag?"}),action:AssignmentActionType.Delete}];const tagConfigActions=[{danger:true,grow:false,name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfigAssignmentOptions.removeTagsButtonLabel",{defaultMessage:"Remove tag(s)"}),type:ActionComponentType.Action,showWarning:true,warningHeading:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfigAssignmentOptions.removeTagsWarninigTitle",{defaultMessage:"Remove tag(s)"}),warningMessage:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfigAssignmentOptions.removeTagsWarninigMessage",{defaultMessage:"Remove the tag from the selected beat(s)?"}),action:AssignmentActionType.Delete}];var external_kbnSharedDeps_Moment_=__webpack_require__(116);var external_kbnSharedDeps_Moment_default=__webpack_require__.n(external_kbnSharedDeps_Moment_);const dynamicStatuses={STARTING:{color:"success",status:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.startingStatusLabel",{defaultMessage:"Starting"}),details:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.startingTooltip",{defaultMessage:"This Beat is starting."})},IN_PROGRESS:{color:"warning",status:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.updatingStatusLabel",{defaultMessage:"Updating"}),details:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.progressTooltip",{defaultMessage:"This Beat is currently reloading config from CM."})},RUNNING:{color:"success",status:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.runningStatusLabel",{defaultMessage:"Running"}),details:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.runningTooltip",{defaultMessage:"This Beat is running without issues."})},CONFIG:{color:"danger",status:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configErrorStatusLabel",{defaultMessage:"Config error"})},FAILED:{color:"danger",status:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.failedStatusLabel",{defaultMessage:"Error"}),details:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.errorTooltip",{defaultMessage:"There is an error on this beat, please check the logs for this host."})},STOPPED:{color:"danger",status:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.stoppedStatusLabel",{defaultMessage:"stopped"}),details:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.errorTooltip",{defaultMessage:"There is an error on this beat, please check the logs for this host."})}};const BeatsTableType={itemType:"Beats",columnDefinitions:[{field:"name",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.beatNameTitle",{defaultMessage:"Beat name"}),render:(name,beat)=>external_kbnSharedDeps_React_default.a.createElement(ConnectedLink,{path:`/beat/${beat.id}/details`},name),sortable:true},{field:"type",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.typeTitle",{defaultMessage:"Type"}),sortable:true},{field:"full_tags",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.tagsTitle",{defaultMessage:"Tags"}),render:(value,beat)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{wrap:true,responsive:true,gutterSize:"xs"},(Object(external_kbnSharedDeps_Lodash_["sortBy"])(beat.tags,"id")||[]).map(tag=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{key:tag.id,grow:false},external_kbnSharedDeps_React_default.a.createElement(ConnectedLink,{path:`/tag/edit/${tag.id}`},external_kbnSharedDeps_React_default.a.createElement(TagBadge,{tag:tag}))))),sortable:false},{field:"config_status",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatusTitle",{defaultMessage:"Config Status"}),render:(value,beat)=>{let color="success";let statusText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.okLabel",{defaultMessage:"OK"});let tooltipText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.okTooltip",{defaultMessage:"Beat successfully applied latest config"});if(beat.status&&external_kbnSharedDeps_Moment_default()().diff(beat.last_checkin,"minutes")<10){color=dynamicStatuses[beat.status.event.type].color;statusText=dynamicStatuses[beat.status.event.type].status;tooltipText=dynamicStatuses[beat.status.event.type].details||beat.status.event.message}else if(!beat.status&&external_kbnSharedDeps_Moment_default()().diff(beat.last_checkin,"minutes")>=10){color="danger";statusText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.offlineLabel",{defaultMessage:"Offline"});tooltipText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.noConnectionTooltip",{defaultMessage:"This Beat has not connected to kibana in over 10min"})}else if(beat.status&&external_kbnSharedDeps_Moment_default()().diff(beat.last_checkin,"minutes")>=10){color="subdued";tooltipText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.notStartedTooltip",{defaultMessage:"This Beat has not yet been started."});statusText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.notStartedLabel",{defaultMessage:"Not started"})}else{color="subdued";statusText=external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.configStatus.offlineLabel",{defaultMessage:"Offline"})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{wrap:true,responsive:true,gutterSize:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiToolTip"],{content:tooltipText},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHealth"],{color:color},statusText)))},sortable:false}],controlDefinitions:data=>({actions:[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.disenrollSelectedLabel",{defaultMessage:"Unenroll Selected"}),action:"delete",danger:true}],filters:[{type:"field_value_selection",field:"type",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatsTable.typeLabel",{defaultMessage:"Type"}),options:Object(external_kbnSharedDeps_Lodash_["uniqBy"])(data.map(({type:type})=>({value:type})),"value")}]})};const TagsTableType={itemType:"Tags",columnDefinitions:[{field:"id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagsTable.tagNameTitle",{defaultMessage:"Tag name"}),render:(id,tag)=>external_kbnSharedDeps_React_default.a.createElement(ConnectedLink,{path:`/tag/edit/${tag.id}`},external_kbnSharedDeps_React_default.a.createElement(TagBadge,{tag:tag})),sortable:true,width:"45%"},{align:"right",field:"last_updated",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagsTable.lastUpdateTitle",{defaultMessage:"Last update"}),render:lastUpdate=>external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_Moment_default()(lastUpdate).fromNow()),sortable:true}],controlDefinitions:data=>({actions:[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagsTable.removeSelectedLabel",{defaultMessage:"Remove Selected"}),action:"delete",danger:true}],filters:[]})};const BeatDetailTagsTable={itemType:"Tags",columnDefinitions:[{field:"id",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatTagsTable.tagNameTitle",{defaultMessage:"Tag name"}),render:(id,tag)=>external_kbnSharedDeps_React_default.a.createElement(ConnectedLink,{path:`/tag/edit/${tag.id}`},external_kbnSharedDeps_React_default.a.createElement(TagBadge,{tag:tag})),sortable:true,width:"55%"},{align:"right",field:"last_updated",name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatTagsTable.lastUpdateTitle",{defaultMessage:"Last update"}),render:lastUpdate=>external_kbnSharedDeps_React_default.a.createElement("span",null,external_kbnSharedDeps_Moment_default()(lastUpdate).fromNow()),sortable:true}],controlDefinitions:data=>({actions:[],filters:[],primaryActions:[{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatTagsTable.addTagLabel",{defaultMessage:"Add Tag"}),action:"add",danger:false},{name:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.beatTagsTable.removeSelectedLabel",{defaultMessage:"Remove Selected"}),action:"remove",danger:true}]})};var formsy_react_lib=__webpack_require__(126);var formsy_react_lib_default=__webpack_require__.n(formsy_react_lib);function code_editor_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class code_editor_CodeEditor extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);code_editor_defineProperty(this,"state",{allowError:false});code_editor_defineProperty(this,"handleChange",value=>{this.props.setValue(value);if(this.props.onChange){this.props.onChange(value)}if(this.props.instantValidation){this.showError()}});code_editor_defineProperty(this,"handleBlur",()=>{this.showError();if(this.props.onBlur){this.props.onBlur()}});code_editor_defineProperty(this,"showError",()=>this.setState({allowError:true}))}componentDidMount(){const{defaultValue:defaultValue,setValue:setValue}=this.props;setValue(defaultValue||"")}UNSAFE_componentWillReceiveProps(nextProps){if(nextProps.isFormSubmitted()){this.showError()}}render(){const{name:name,id:id,label:label,isReadOnly:isReadOnly,isValid:isValid,getValue:getValue,isPristine:isPristine,getErrorMessage:getErrorMessage,mode:mode,fullWidth:fullWidth,className:className,helpText:helpText}=this.props;const{allowError:allowError}=this.state;const error=!isPristine()&&!isValid()&&allowError;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:id,label:label,helpText:helpText,isInvalid:error,error:error?getErrorMessage():[]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeEditor"],{name:name,mode:mode,theme:"github",value:getValue()||"",isReadOnly:isReadOnly||false,onChange:this.handleChange,onBlur:this.handleBlur,width:fullWidth?"100%":undefined,className:className}))}}code_editor_defineProperty(code_editor_CodeEditor,"defaultProps",{passRequiredToField:true});const FormsyEuiCodeEditor=Object(formsy_react_lib["withFormsy"])(code_editor_CodeEditor);function input_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class input_FieldText extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);input_defineProperty(this,"state",{allowError:false});input_defineProperty(this,"handleChange",e=>{const{value:value}=e.currentTarget;this.props.setValue(value);if(this.props.onChange){this.props.onChange(e,e.currentTarget.value)}if(this.props.instantValidation){this.showError()}});input_defineProperty(this,"handleBlur",e=>{this.showError();if(this.props.onBlur){this.props.onBlur(e,e.currentTarget.value)}});input_defineProperty(this,"showError",()=>this.setState({allowError:true}))}componentDidMount(){const{defaultValue:defaultValue,setValue:setValue}=this.props;if(defaultValue){setValue(defaultValue)}}UNSAFE_componentWillReceiveProps(nextProps){if(nextProps.isFormSubmitted()){this.showError()}}render(){const{name:name,id:id,required:required,label:label,getValue:getValue,isValid:isValid,isPristine:isPristine,getErrorMessage:getErrorMessage,fullWidth:fullWidth,className:className,disabled:disabled,helpText:helpText,placeholder:placeholder}=this.props;const{allowError:allowError}=this.state;const error=!isPristine()&&!isValid()&&allowError;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:id,label:label,helpText:helpText,isInvalid:!disabled&&error,error:!disabled&&error?getErrorMessage():[]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{id:id,name:name,placeholder:placeholder,value:getValue()||"",isInvalid:!disabled&&error,onChange:this.handleChange,onBlur:this.handleBlur,fullWidth:fullWidth,disabled:disabled,required:required,className:className}))}}input_defineProperty(input_FieldText,"defaultProps",{passRequiredToField:true});const FormsyEuiFieldText=Object(formsy_react_lib["withFormsy"])(input_FieldText);function password_input_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class password_input_FieldPassword extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);password_input_defineProperty(this,"handleChange",e=>{const{value:value}=e.currentTarget;this.props.setValue(value);if(this.props.onChange){this.props.onChange(e,value)}if(this.props.instantValidation){this.showError()}});password_input_defineProperty(this,"handleBlur",e=>{this.showError();if(this.props.onBlur){this.props.onBlur(e,e.currentTarget.value)}});password_input_defineProperty(this,"showError",()=>this.setState({allowError:true}));this.state={allowError:false}}componentDidMount(){const{defaultValue:defaultValue,setValue:setValue}=this.props;if(defaultValue){setValue(defaultValue)}}render(){const{name:name,id:id,required:required,label:label,getValue:getValue,isValid:isValid,isPristine:isPristine,getErrorMessage:getErrorMessage,fullWidth:fullWidth,className:className,disabled:disabled,helpText:helpText,onBlur:onBlur}=this.props;const{allowError:allowError}=this.state;const error=!isPristine()&&!isValid()&&allowError;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:id,label:label,helpText:helpText,isInvalid:!disabled&&error,error:!disabled&&error?getErrorMessage():[]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldPassword"],{id:id,name:name,value:getValue()||"",isInvalid:!disabled&&error,onChange:this.handleChange,onBlur:onBlur,fullWidth:fullWidth,disabled:disabled,required:required,className:className}))}}const FormsyEuiPasswordText=Object(formsy_react_lib["withFormsy"])(password_input_FieldPassword);function multi_input_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class multi_input_MultiFieldText extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);multi_input_defineProperty(this,"state",{allowError:false});multi_input_defineProperty(this,"handleChange",e=>{const value=e.currentTarget.value.split("\n");this.props.setValue(value);if(this.props.onChange){this.props.onChange(e,value)}if(this.props.instantValidation){this.showError()}});multi_input_defineProperty(this,"handleBlur",e=>{this.showError();if(this.props.onBlur){this.props.onBlur(e,e.currentTarget.value)}});multi_input_defineProperty(this,"showError",()=>this.setState({allowError:true}))}componentDidMount(){const{defaultValue:defaultValue,setValue:setValue}=this.props;if(defaultValue){setValue(defaultValue)}}UNSAFE_componentWillReceiveProps(nextProps){if(nextProps.isFormSubmitted()){this.showError()}}render(){const{name:name,id:id,required:required,label:label,getValue:getValue,isValid:isValid,isPristine:isPristine,getErrorMessage:getErrorMessage,fullWidth:fullWidth,className:className,disabled:disabled,helpText:helpText,placeholder:placeholder}=this.props;const{allowError:allowError}=this.state;const error=!isPristine()&&!isValid()&&allowError;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:id,label:label,helpText:helpText,isInvalid:!disabled&&error,error:!disabled&&error?getErrorMessage():[]},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTextArea"],{id:id,name:name,value:getValue()?getValue().join("\n"):"",isInvalid:!disabled&&error,placeholder:placeholder,onChange:this.handleChange,onBlur:this.handleBlur,fullWidth:fullWidth,disabled:disabled,required:required,className:className}))}}multi_input_defineProperty(multi_input_MultiFieldText,"defaultProps",{passRequiredToField:true});const FormsyEuiMultiFieldText=Object(formsy_react_lib["withFormsy"])(multi_input_MultiFieldText);function select_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}const FixedSelect=external_kbnSharedDeps_ElasticEui_["EuiSelect"];class select_FieldSelect extends external_kbnSharedDeps_React_["Component"]{constructor(...args){super(...args);select_defineProperty(this,"state",{allowError:false});select_defineProperty(this,"handleChange",e=>{const{value:value}=e.currentTarget;this.props.setValue(value);if(this.props.onChange){this.props.onChange(e,e.currentTarget.value)}if(this.props.instantValidation){this.showError()}});select_defineProperty(this,"handleBlur",e=>{this.showError();if(this.props.onBlur){this.props.onBlur(e,e.currentTarget.value)}});select_defineProperty(this,"showError",()=>this.setState({allowError:true}))}componentDidMount(){const{defaultValue:defaultValue,setValue:setValue}=this.props;if(defaultValue){setValue(defaultValue)}}UNSAFE_componentWillReceiveProps(nextProps){if(nextProps.isFormSubmitted()){this.showError()}}render(){const{id:id,required:required,label:label,options:options,getValue:getValue,isValid:isValid,isPristine:isPristine,getErrorMessage:getErrorMessage,fullWidth:fullWidth,className:className,disabled:disabled,helpText:helpText}=this.props;const{allowError:allowError}=this.state;const error=!isPristine()&&!isValid()&&allowError;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{id:id,label:label,helpText:helpText,isInvalid:!disabled&&error,error:!disabled&&error?getErrorMessage():[]},external_kbnSharedDeps_React_default.a.createElement(FixedSelect,{id:id,name:name,value:getValue()||"",options:options,isInvalid:!disabled&&error,onChange:this.handleChange,onBlur:this.handleBlur,fullWidth:fullWidth,disabled:disabled,required:required,className:className}))}}select_defineProperty(select_FieldSelect,"defaultProps",{passRequiredToField:true});const FormsyEuiSelect=Object(formsy_react_lib["withFormsy"])(select_FieldSelect);function config_form_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class config_form_ConfigFormUi extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);config_form_defineProperty(this,"form",external_kbnSharedDeps_React_default.a.createRef());config_form_defineProperty(this,"enableButton",()=>{this.setState({canSubmit:true});this.props.canSubmit(true)});config_form_defineProperty(this,"disableButton",()=>{this.setState({canSubmit:false});this.props.canSubmit(false)});config_form_defineProperty(this,"submit",()=>{if(this.form.current&&this.props.onSubmit){this.form.current.click()}});config_form_defineProperty(this,"onValidSubmit",model=>{if(!this.props.onSubmit){return}this.props.onSubmit(model)});this.state={canSubmit:false}}render(){return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(formsy_react_lib_default.a,{onValidSubmit:this.onValidSubmit,onValid:this.enableButton,onInvalid:this.disableButton},this.props.schema.configs.map(schema=>{switch(schema.ui.type){case"input":return external_kbnSharedDeps_React_default.a.createElement(FormsyEuiFieldText,{key:schema.id,id:schema.id,defaultValue:Object(external_kbnSharedDeps_Lodash_["get"])(this.props,`values.config.${schema.id}`,schema.defaultValue),name:schema.id,disabled:!this.props.onSubmit,helpText:schema.ui.helpText,placeholder:schema.ui.placeholder,label:schema.ui.label,validationError:schema.error,required:schema.required||false});case"password":return external_kbnSharedDeps_React_default.a.createElement(FormsyEuiPasswordText,{key:schema.id,id:schema.id,disabled:!this.props.onSubmit,defaultValue:Object(external_kbnSharedDeps_Lodash_["get"])(this.props,`values.config.${schema.id}`,schema.defaultValue),name:schema.id,placeholder:schema.ui.placeholder,helpText:schema.ui.helpText,label:schema.ui.label,validationError:schema.error,required:schema.required||false});case"multi-input":return external_kbnSharedDeps_React_default.a.createElement(FormsyEuiMultiFieldText,{key:schema.id,id:schema.id,disabled:!this.props.onSubmit,defaultValue:Object(external_kbnSharedDeps_Lodash_["get"])(this.props,`values.config.${schema.id}`,schema.defaultValue),name:schema.id,placeholder:schema.ui.placeholder,helpText:schema.ui.helpText,label:schema.ui.label,validationError:schema.error,required:schema.required});case"select":return external_kbnSharedDeps_React_default.a.createElement(FormsyEuiSelect,{key:schema.id,id:schema.id,name:schema.id,disabled:!this.props.onSubmit,defaultValue:Object(external_kbnSharedDeps_Lodash_["get"])(this.props,`values.config.${schema.id}`,schema.defaultValue),helpText:schema.ui.helpText,label:schema.ui.label,options:[{value:"",text:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.table.selectOptionLabel",{defaultMessage:"Please Select An Option"})}].concat(schema.options||[]),validationError:schema.error,required:schema.required});case"code":return external_kbnSharedDeps_React_default.a.createElement(FormsyEuiCodeEditor,{key:`${schema.id}-${this.props.id}`,mode:"yaml",disabled:!this.props.onSubmit,id:schema.id,defaultValue:Object(external_kbnSharedDeps_Lodash_["get"])(this.props,`values.config.${schema.id}`,schema.defaultValue),name:schema.id,helpText:schema.ui.helpText,label:schema.ui.label,options:schema.options?schema.options:[],validationError:schema.error,required:schema.required})}}),this.props.schema&&external_kbnSharedDeps_React_default.a.createElement(FormsyEuiCodeEditor,{mode:"yaml",disabled:!this.props.onSubmit,id:"other",defaultValue:Object(external_kbnSharedDeps_Lodash_["get"])(this.props,`values.config.other`,""),name:"other",helpText:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.config.otherConfigDescription",{defaultMessage:"Use YAML format to specify other settings for the Filebeat Input"}),label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.config.otherConfigLabel",{defaultMessage:"Other Config"}),validationError:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.config.other.error",{defaultMessage:"Use valid YAML format"}),required:false}),this.props.onSubmit&&external_kbnSharedDeps_React_default.a.createElement("button",{type:"submit",style:{display:"none"},disabled:!this.state.canSubmit,ref:this.form})))}}const ConfigForm=config_form_ConfigFormUi;function config_view_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class config_view_ConfigViewUi extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);config_view_defineProperty(this,"form",external_kbnSharedDeps_React_default.a.createRef());config_view_defineProperty(this,"editMode",void 0);config_view_defineProperty(this,"schema",Object(config_schemas_translations_map["a"])(config_schemas["a"]));config_view_defineProperty(this,"onValueChange",field=>e=>{const value=e.currentTarget?e.currentTarget.value:e;this.setState(state=>({configBlock:{...state.configBlock,[field]:value}}))});this.editMode=props.configBlock!==undefined;this.state={valid:false,configBlock:props.configBlock||{type:this.schema[0].id}}}render(){const thisConfigSchema=this.schema.find(s=>this.state.configBlock.type===s.id);if(!thisConfigSchema){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.invalidSchema",{defaultMessage:"Error: This config is invalid, it is not supported by Beats and should be removed"})}return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyout"],{onClose:this.props.onClose},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutHeader"],{hasBorder:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"m"},external_kbnSharedDeps_React_default.a.createElement("h2",null,this.editMode?this.props.onSave?external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.editConfigurationTitle",{defaultMessage:"Edit configuration block"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate('xpack.beatsManagement.tagConfig.viewConfigurationTitle"',{defaultMessage:"View configuration block"}):external_kbnSharedDeps_KbnI18n_["i18n"].translate('xpack.beatsManagement.tagConfig.addConfigurationTitle"',{defaultMessage:"Add configuration block"})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.typeLabel",{defaultMessage:"Type"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{options:this.schema.map(s=>({value:s.id,text:s.name})),value:this.state.configBlock.type,disabled:this.editMode,onChange:this.onValueChange("type")})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.descriptionLabel",{defaultMessage:"Description"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{value:this.state.configBlock.description,disabled:!this.props.onSave,onChange:this.onValueChange("description"),placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.descriptionPlaceholder",{defaultMessage:"Description (optional)"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.configurationTypeText",{defaultMessage:"{configType} configuration",values:{configType:thisConfigSchema?thisConfigSchema.name:"Unknown"}})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(ConfigForm,{onSubmit:this.props.onSave?data=>{if(this.props.onSave){this.props.onSave({...this.state.configBlock,config:data})}this.props.onClose()}:undefined,canSubmit:canIt=>this.setState({valid:canIt}),ref:this.form,values:this.state.configBlock,id:thisConfigSchema?thisConfigSchema.name:"Undefined",schema:thisConfigSchema})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlyoutFooter"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{iconType:"cross",onClick:this.props.onClose},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.closeButtonLabel",{defaultMessage:"Close"}))),this.props.onSave&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{disabled:!this.state.valid,fill:true,onClick:()=>{if(this.form.current){this.form.current.submit()}}},external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tagConfig.saveButtonLabel",{defaultMessage:"Save"}))))))}}const ConfigView=config_view_ConfigViewUi;function tag_edit_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class tag_edit_TagEdit extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);tag_edit_defineProperty(this,"getNameError",name=>{if(name&&name!==""&&name.search(/^[a-zA-Z0-9-]+$/)===-1){return external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tag.tagName.validationErrorMessage",{defaultMessage:"Tag name must consist of letters, numbers, and dashes only"})}else{return false}});tag_edit_defineProperty(this,"handleAssignmentActions",action=>{switch(action){case AssignmentActionType.Delete:const{selection:selection}=this.state.tableRef.current.state;if(this.props.onDetachBeat){this.props.onDetachBeat(selection.map(beat=>beat.id))}}});tag_edit_defineProperty(this,"updateTag",(key,value)=>value!==undefined?this.props.onTagChange(key,value):e=>this.props.onTagChange(key,e.target?e.target.value:e));this.state={showFlyout:false,tableRef:external_kbnSharedDeps_React_default.a.createRef()}}render(){const{tag:tag,attachedBeats:attachedBeats,configuration_blocks:configuration_blocks}=this.props;return external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.tagDetailsTitle",defaultMessage:"Tag details"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.tagDetailsDescription",defaultMessage:"A tag is a group of configuration blocks that you can apply to one or more Beats."}))),external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(TagBadge,{tag:tag}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiForm"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.tagNameLabel",defaultMessage:"Tag Name"}),isInvalid:!!this.getNameError(tag.name),error:this.getNameError(tag.name)||undefined},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFieldText"],{name:"name",isInvalid:!!this.getNameError(tag.name),onChange:this.updateTag("name"),value:tag.name,placeholder:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tag.tagNamePlaceholder",{defaultMessage:"Tag name (required)"})})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFormRow"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.tag.tagColorLabel",{defaultMessage:"Tag Color"})},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiColorPicker"],{color:tag.color,onChange:this.updateTag("color")}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"stretch"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.tagConfigurationsTitle",defaultMessage:"Configuration blocks"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{color:"subdued"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.tagConfigurationsDescription",defaultMessage:"A tag can have configuration blocks for different types of Beats. For example, a tag can have two Metricbeat configuration blocks and one Filebeat input configuration block."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(ConfigList,{onTableChange:this.props.onConfigListChange,configs:configuration_blocks,onConfigClick:(action,block)=>{if(action==="delete"){this.props.onConfigRemoved(block)}else{this.setState({showFlyout:true,selectedConfig:block})}}}),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{onClick:()=>{this.setState({showFlyout:true})}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.addConfigurationButtonLabel",defaultMessage:"Add configuration block"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),attachedBeats&&external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHorizontalRule"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.beatsAssignedToTagTitle",defaultMessage:"Beats with this tag"}))),external_kbnSharedDeps_React_default.a.createElement(table_Table,{actions:tagConfigActions,actionHandler:this.handleAssignmentActions,items:attachedBeats,ref:this.state.tableRef,type:BeatsTableType})),this.state.showFlyout&&external_kbnSharedDeps_React_default.a.createElement(ConfigView,{configBlock:this.state.selectedConfig,onClose:()=>this.setState({showFlyout:false,selectedConfig:undefined}),onSave:config=>{this.setState({showFlyout:false,selectedConfig:undefined});this.props.onConfigAddOrEdit(config)}}))}}class details_BeatDetailPageUi extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);this.state={selectedConfig:null,tags:[],configuration_blocks:[],configurationBlocksPage:0}}async UNSAFE_componentWillMount(){const tags=await this.props.libs.tags.getTagsWithIds(this.props.beat.tags);const blocksResult=await this.props.libs.configBlocks.getForTags(this.props.beat.tags,this.state.configurationBlocksPage);this.setState({configuration_blocks:blocksResult.list,tags:tags})}render(){const props=this.props;const{beat:beat,intl:intl}=props;if(!beat){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.beatNotFoundErrorTitle",defaultMessage:"Beat not found"})}const configurationBlocks=!this.state.configuration_blocks?[]:this.state.configuration_blocks.map(configuration=>({module:configuration.config.type||null,tagId:configuration.tag,tagColor:((this.state.tags||[]).find(tag=>tag.id===configuration.tag)||{}).color||"grey",tagName:((this.state.tags||[]).find(tag=>tag.id===configuration.tag)||{}).name||configuration.tag,...beat,...configuration,displayValue:Object(external_kbnSharedDeps_Lodash_["get"])(Object(config_schemas_translations_map["a"])(config_schemas["a"]).find(config=>config.id===configuration.type),"text",null)}));const columns=[{field:"displayValue",name:intl.formatMessage({id:"xpack.beatsManagement.beatConfigurations.typeColumnName",defaultMessage:"Type"}),sortable:true,render:(value,configuration)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{onClick:()=>{this.setState({selectedConfig:configuration})}},value||configuration.type)},{field:"module",name:intl.formatMessage({id:"xpack.beatsManagement.beatConfigurations.moduleColumnName",defaultMessage:"Module"}),sortable:true},{field:"description",name:intl.formatMessage({id:"xpack.beatsManagement.beatConfigurations.descriptionColumnName",defaultMessage:"Description"}),sortable:true},{field:"tagId",name:intl.formatMessage({id:"xpack.beatsManagement.beatConfigurations.tagColumnName",defaultMessage:"Tag"}),render:(id,block)=>external_kbnSharedDeps_React_default.a.createElement(ConnectedLink,{path:`/tag/edit/${id}`},external_kbnSharedDeps_React_default.a.createElement(TagBadge,{maxIdRenderSize:constants["c"].TRUNCATE_TAG_LENGTH_SMALL,tag:{color:block.tagColor,id:id,name:block.tagName}})),sortable:true}];return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Breadcrumb,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.breadcrumb.beatDetails",{defaultMessage:"Beat details for: {beatId}",values:{beatId:beat.id}}),path:`/beat/${beat.id}/details`}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h4",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.detailsConfigurationTitle",defaultMessage:"Configurations"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"s"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.detailsConfigurationDescription",defaultMessage:"You can have multiple configurations applied to an individual tag. These configurations can repeat or mix types as necessary. For example, you may utilize three metricbeat configurations alongside one input and filebeat configuration."})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiInMemoryTable"],{columns:columns,items:configurationBlocks}))),this.state.selectedConfig&&external_kbnSharedDeps_React_default.a.createElement(ConfigView,{configBlock:this.state.selectedConfig,onClose:()=>this.setState({selectedConfig:null})}))}}const BeatDetailPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(details_BeatDetailPageUi);function primary_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class primary_PrimaryLayout extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);primary_defineProperty(this,"actionSection",null);primary_defineProperty(this,"renderAction",component=>{this.actionSection=component;this.forceUpdate()})}render(){const children=this.props.children;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!this.props.hideBreadcrumbs&&external_kbnSharedDeps_React_default.a.createElement(Consumer,null,({breadcrumbs:breadcrumbs})=>external_kbnSharedDeps_React_default.a.createElement(HeaderWrapper,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiHeaderBreadcrumbs"],{breadcrumbs:breadcrumbs})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPage"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeaderSection"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",null,this.props.title))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageHeaderSection"],null,this.actionSection&&this.actionSection()||this.props.actionSection)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,(children&&typeof children==="function"?children(this.renderAction):children)||external_kbnSharedDeps_React_default.a.createElement("span",null))))))}}const HeaderWrapper=external_kbnSharedDeps_StyledComponents_default()(external_kbnSharedDeps_ElasticEui_["EuiHeader"]).withConfig({displayName:"HeaderWrapper",componentId:"cwbpac-0"})(["height:29px;"]);function beat_extends(){beat_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return beat_extends.apply(this,arguments)}function beat_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class beat_BeatDetailsPageComponent extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);beat_defineProperty(this,"onSelectedTabChanged",id=>{this.props.history.push({pathname:id,search:this.props.location.search})});beat_defineProperty(this,"onTabClicked",path=>()=>{this.props.goTo(path)});this.state={beat:undefined,beatId:props.match.params.beatId,isLoading:true};this.loadBeat()}renderActionSection(beat){return beat?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.actionSectionTypeLabel",defaultMessage:"Type: {beatType}.",values:{beatType:external_kbnSharedDeps_React_default.a.createElement("strong",null,beat.type)}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.actionSectionVersionLabel",defaultMessage:"Version: {beatVersion}.",values:{beatVersion:external_kbnSharedDeps_React_default.a.createElement("strong",null,beat.version)}}))),beat.last_updated&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiText"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.lastConfigUpdateMessage",defaultMessage:"Last Config Update: {lastUpdateTime}.",values:{lastUpdateTime:external_kbnSharedDeps_React_default.a.createElement("strong",null,external_kbnSharedDeps_Moment_default()(beat.last_updated).fromNow())}})))):external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.beatNotFoundMessage",defaultMessage:"Beat not found"})}render(){const{intl:intl}=this.props;const{beat:beat}=this.state;let id;let name;if(beat){id=beat.id;name=beat.name}const title=this.state.isLoading?intl.formatMessage({id:"xpack.beatsManagement.beat.loadingTitle",defaultMessage:"Loading"}):intl.formatMessage({id:"xpack.beatsManagement.beat.beatNameAndIdTitle",defaultMessage:"Beat: {nameOrNoName} (id: {id})"},{nameOrNoName:name||intl.formatHTMLMessage({id:"xpack.beatsManagement.beat.noNameReceivedFromBeatTitle",defaultMessage:"No name received from beat"}),id:id});return external_kbnSharedDeps_React_default.a.createElement(primary_PrimaryLayout,{title:title,actionSection:this.renderActionSection(beat),hideBreadcrumbs:this.props.libs.framework.versionGreaterThen("6.7.0")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Breadcrumb,{title:`Enrolled Beats`,path:`/overview/enrolled_beats`}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:`/beat/${id}/details`===this.props.history.location.pathname,onClick:this.onTabClicked(`/beat/${id}/details`)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.configTabLabel",defaultMessage:"Config"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:`/beat/${id}/tags`===this.props.history.location.pathname,onClick:this.onTabClicked(`/beat/${id}/tags`)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beat.configurationTagsTabLabel",defaultMessage:"Configuration tags"}))),!this.state.beat&&external_kbnSharedDeps_React_default.a.createElement("div",null,"Beat not found"),this.state.beat&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,external_kbnSharedDeps_React_default.a.createElement(ChildRoutes,beat_extends({routes:this.props.routes},this.props,{beat:this.state.beat,useSwitch:false})),id&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{render:()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:`/beat/${id}/details`})}))))}async loadBeat(){const{intl:intl}=this.props;const{beatId:beatId}=this.props.match.params;let beat;try{beat=await this.props.libs.beats.get(beatId);if(!beat){throw new Error(intl.formatMessage({id:"xpack.beatsManagement.beat.beatNotFoundErrorMessage",defaultMessage:"beat not found"}))}}catch(e){throw new Error(e)}this.setState({beat:beat,isLoading:false})}}const BeatDetailsPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(beat_BeatDetailsPageComponent);function beat_tags_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class tags_BeatTagsPage extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);beat_tags_defineProperty(this,"tableRef",external_kbnSharedDeps_React_default.a.createRef());this.state={notifications:[],tags:[]}}UNSAFE_componentWillMount(){this.updateBeatsData()}async updateBeatsData(){const tags=await this.props.libs.tags.getTagsWithIds(this.props.beat.tags);this.setState({tags:tags})}render(){const{beat:beat}=this.props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Breadcrumb,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.breadcrumb.beatTags",{defaultMessage:"Beat tags for: {beatId}",values:{beatId:beat.id}}),path:`/beat/${beat.id}/tags`}),external_kbnSharedDeps_React_default.a.createElement(table_Table,{hideTableControls:true,items:this.state.tags,ref:this.tableRef,type:BeatDetailTagsTable}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiGlobalToastList"],{toasts:this.state.notifications,dismissToast:()=>this.setState({notifications:[]}),toastLifeTimeMs:5e3}))}}const NoDataLayout=Object(external_kbnSharedDeps_ReactRouterDom_["withRouter"])(({actionSection:actionSection,title:title,children:children})=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"logoBeats",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,title),body:children,actions:actionSection})))));const EnforceSecurityPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(({intl:intl})=>external_kbnSharedDeps_React_["createElement"](NoDataLayout,{title:intl.formatMessage({id:"xpack.beatsManagement.disabledSecurityTitle",defaultMessage:"Security is not enabled"}),actionSection:[]},external_kbnSharedDeps_React_["createElement"]("p",null,external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.disabledSecurityDescription",defaultMessage:"You must enable security in Kibana and Elasticsearch to use Beats central management."}))));const InvalidLicensePage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(({intl:intl})=>external_kbnSharedDeps_React_["createElement"](NoDataLayout,{title:intl.formatMessage({id:"xpack.beatsManagement.invalidLicenseTitle",defaultMessage:"Expired license"}),actionSection:[]},external_kbnSharedDeps_React_["createElement"]("p",null,external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.invalidLicenseDescription",defaultMessage:"Your current license is expired. Enrolled Beats will continue to work, but you need a valid license to access the Beats Management UI."}))));const NoAccessPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(({intl:intl})=>external_kbnSharedDeps_React_["createElement"](NoDataLayout,{title:intl.formatMessage({id:"xpack.beatsManagement.noAccess.accessDeniedTitle",defaultMessage:"Access denied"}),actionSection:[]},external_kbnSharedDeps_React_["createElement"]("p",null,external_kbnSharedDeps_React_["createElement"](external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.noAccess.accessDeniedDescription",defaultMessage:"You are not authorized to access Beats central management. To use Beats central management, you need the privileges granted by the {beatsAdminRole} role.",values:{beatsAdminRole:"`beats_admin`"}}))));function with_kuery_autocompletion_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class with_kuery_autocompletion_WithKueryAutocompletion extends external_kbnSharedDeps_React_default.a.Component{constructor(...args){super(...args);with_kuery_autocompletion_defineProperty(this,"state",{currentRequest:null,suggestions:[]});with_kuery_autocompletion_defineProperty(this,"loadSuggestions",async(expression,cursorPosition,maxSuggestions)=>{this.setState({currentRequest:{expression:expression,cursorPosition:cursorPosition},suggestions:[]});let suggestions=[];try{suggestions=await this.props.libs.elasticsearch.getSuggestions(expression,cursorPosition,this.props.fieldPrefix)}catch(e){suggestions=[]}this.setState(state=>state.currentRequest&&state.currentRequest.expression!==expression&&state.currentRequest.cursorPosition!==cursorPosition?state:{...state,currentRequest:null,suggestions:maxSuggestions?suggestions.slice(0,maxSuggestions):suggestions})})}render(){const{currentRequest:currentRequest,suggestions:suggestions}=this.state;return this.props.children({isLoadingSuggestions:currentRequest!==null,loadSuggestions:this.loadSuggestions,suggestions:suggestions})}}function configuration_tags_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class configuration_tags_TagsPageComponent extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);configuration_tags_defineProperty(this,"renderActionArea",()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",color:"primary",onClick:async()=>{this.props.goTo("/tag/create")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tags.addTagButtonLabel",defaultMessage:"Add Tag"})));configuration_tags_defineProperty(this,"handleTagsAction",async action=>{const{intl:intl}=this.props;switch(action){case AssignmentActionType.Delete:const success=await this.props.containers.tags.delete(this.getSelectedTags());if(!success){alert(intl.formatMessage({id:"xpack.beatsManagement.tags.someTagsMightBeAssignedToBeatsTitle",defaultMessage:"Some of these tags might be assigned to beats. Please ensure tags being removed are not activly assigned"}))}else{if(this.state.tableRef&&this.state.tableRef.current){this.state.tableRef.current.resetSelection()}}break}});configuration_tags_defineProperty(this,"getSelectedTags",()=>this.state.tableRef.current?this.state.tableRef.current.state.selection:[]);this.state={tableRef:external_kbnSharedDeps_React_default.a.createRef()};props.containers.tags.reload(props.urlState.tagsKBar);props.renderAction(this.renderActionArea)}render(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Breadcrumb,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.breadcrumb.configurationTags",{defaultMessage:"Configuration tags"}),path:`/overview/configuration_tags`}),external_kbnSharedDeps_React_default.a.createElement(with_kuery_autocompletion_WithKueryAutocompletion,{libs:this.props.libs,fieldPrefix:"tag"},autocompleteProps=>external_kbnSharedDeps_React_default.a.createElement(table_Table,{kueryBarProps:{...autocompleteProps,filterQueryDraft:"false",isValid:this.props.libs.elasticsearch.isKueryValid(this.props.urlState.tagsKBar||""),onChange:value=>{this.props.setUrlState({tagsKBar:value});this.props.containers.tags.reload(value)},onSubmit:()=>null,value:this.props.urlState.tagsKBar||""},actions:tagListActions,actionHandler:this.handleTagsAction,ref:this.state.tableRef,items:this.props.containers.tags.state.list,type:TagsTableType})))}}const TagsPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(configuration_tags_TagsPageComponent);function enroll_beats_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class enroll_beats_EnrollBeat extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);enroll_beats_defineProperty(this,"pinging",false);enroll_beats_defineProperty(this,"pingForBeatWithToken",async token=>{try{const beats=await this.props.getBeatWithToken(token);if(!beats){throw new Error("no beats")}return beats}catch(err){if(this.pinging){const timeout=ms=>new Promise(res=>setTimeout(res,ms));await timeout(5e3);return await this.pingForBeatWithToken(token)}}});enroll_beats_defineProperty(this,"waitForTokenToEnrollBeat",async()=>{if(this.pinging||!this.props.enrollmentToken){return}this.pinging=true;const enrolledBeat=await this.pingForBeatWithToken(this.props.enrollmentToken);this.setState({enrolledBeat:enrolledBeat});this.props.onBeatEnrolled(enrolledBeat);this.pinging=false});this.state={enrolledBeat:null,hasPolledForBeat:false,command:"sudo {{beatType}}",beatType:"filebeat"}}async componentDidMount(){if(!this.props.enrollmentToken){await this.props.createEnrollmentToken()}}render(){if(!this.props.enrollmentToken&&!this.state.enrolledBeat){return null}if(this.props.enrollmentToken&&!this.state.enrolledBeat){this.waitForTokenToEnrollBeat()}const cmdText=`${this.state.command.replace("{{beatType}}",this.state.beatType).replace("{{beatTypeInCaps}}",Object(external_kbnSharedDeps_Lodash_["upperFirst"])(this.state.beatType))} enroll ${window.location.protocol}//${window.location.host}${this.props.frameworkBasePath} ${this.props.enrollmentToken}`;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,!this.state.enrolledBeat&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.beatTypeTitle",defaultMessage:"Beat type:"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{value:this.state.beatType,options:[{value:"filebeat",text:"Filebeat"},{value:"metricbeat",text:"Metricbeat"}],onChange:e=>this.setState({beatType:e.target.value}),fullWidth:true}))),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.platformTitle",defaultMessage:"Platform:"}))))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSelect"],{value:this.state.command,options:[{value:`sudo {{beatType}}`,text:"DEB / RPM"},{value:`PS C:\\Program Files\\{{beatTypeInCaps}}> {{beatType}}.exe`,text:"Windows"},{value:`./{{beatType}}`,text:"MacOS"}],onChange:e=>this.setState({command:e.target.value}),fullWidth:true}))),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null),this.state.command&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceBetween",alignItems:"flexEnd"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.yourBeatTypeHostTitle",defaultMessage:"On the host where your {beatType} is installed, run:",values:{beatType:Object(external_kbnSharedDeps_Lodash_["upperFirst"])(this.state.beatType)}})))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{className:"homTutorial__instruction",grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCopy"],{textToCopy:cmdText},copy=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",onClick:copy},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.copyButtonLabel",defaultMessage:"Copy command"}))))),external_kbnSharedDeps_React_default.a.createElement("div",{className:"eui-textBreakAll"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCodeBlock"],{language:"sh"},`$ ${cmdText}`)),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{gutterSize:"s",alignItems:"center"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],{size:"xs"},external_kbnSharedDeps_React_default.a.createElement("h3",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.waitingBeatTypeToEnrollTitle",defaultMessage:"Waiting for {beatType} to enroll…",values:{beatType:Object(external_kbnSharedDeps_Lodash_["upperFirst"])(this.state.beatType)}}))))))),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLoadingSpinner"],{size:"l"})))),this.state.enrolledBeat&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.beatEnrolledTitle",defaultMessage:"The Beat is now enrolled in central management:"}),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBasicTable"],{items:[this.state.enrolledBeat],columns:[{field:"type",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.beatTypeColumnName",defaultMessage:"Beat Type"}),sortable:false},{field:"version",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.versionColumnName",defaultMessage:"Version"}),sortable:false},{field:"host_name",name:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.hostnameColumnName",defaultMessage:"Hostname"}),sortable:false}]}),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null)))}}function enrolled_beats_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class enrolled_beats_BeatsPageComponent extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);enrolled_beats_defineProperty(this,"tableRef",external_kbnSharedDeps_React_default.a.createRef());enrolled_beats_defineProperty(this,"renderActionArea",()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>{window.open("https://www.elastic.co/guide/en/beats/libbeat/current/getting-started.html","_newtab35628937456")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beats.installBeatsLearningButtonLabel",defaultMessage:"Learn how to install beats"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",color:"primary",onClick:async()=>{this.props.goTo(`/overview/enrolled_beats/enroll`)}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beats.enrollBeatsButtonLabel",defaultMessage:"Enroll Beats"})),this.props.location.pathname==="/overview/enrolled_beats/enroll"&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModal"],{onClose:()=>{this.props.setUrlState({enrollmentToken:""});this.props.goTo(`/overview/enrolled_beats`)},style:{width:"640px"}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeader"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalHeaderTitle"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beats.enrollNewBeatsTitle",defaultMessage:"Enroll a new Beat"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiModalBody"],null,external_kbnSharedDeps_React_default.a.createElement(enroll_beats_EnrollBeat,{frameworkBasePath:this.props.libs.framework.info.basePath,enrollmentToken:this.props.urlState.enrollmentToken,getBeatWithToken:this.props.containers.beats.getBeatWithToken,createEnrollmentToken:async()=>{const enrollmentTokens=await this.props.libs.tokens.createEnrollmentTokens();this.props.setUrlState({enrollmentToken:enrollmentTokens[0]})},onBeatEnrolled:()=>{this.props.setUrlState({enrollmentToken:""})}}),!this.props.urlState.enrollmentToken&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",color:"primary",style:{marginLeft:10},onClick:async()=>{this.props.goTo("/overview/enrolled_beats")}},"Done"))))));enrolled_beats_defineProperty(this,"notifyBeatDisenrolled",async beats=>{const{intl:intl}=this.props;let title;let text;if(beats.length===1){title=intl.formatMessage({id:"xpack.beatsManagement.beats.beatDisenrolledNotificationTitle",defaultMessage:"{firstBeatNameOrId} disenrolled"},{firstBeatNameOrId:`"${beats[0].name||beats[0].id}"`});text=intl.formatMessage({id:"xpack.beatsManagement.beats.beatDisenrolledNotificationDescription",defaultMessage:"Beat with ID {firstBeatId} was disenrolled."},{firstBeatId:`"${beats[0].id}"`})}else{title=intl.formatMessage({id:"xpack.beatsManagement.beats.disenrolledBeatsNotificationTitle",defaultMessage:"{beatsLength} beats disenrolled"},{beatsLength:beats.length})}this.setState({notifications:this.state.notifications.concat({color:"warning",id:`disenroll_${new Date}`,title:title,text:text})})});enrolled_beats_defineProperty(this,"notifyUpdatedTagAssociation",(action,beats,tag)=>{const{intl:intl}=this.props;const notificationMessage=action==="removed"?intl.formatMessage({id:"xpack.beatsManagement.beats.removedNotificationDescription",defaultMessage:"Removed tag {tag} from {assignmentsLength, plural, one {beat {beatName}} other {# beats}}."},{tag:`"${tag}"`,assignmentsLength:beats.length,beatName:`"${beats[0].name||beats[0].id}"`}):intl.formatMessage({id:"xpack.beatsManagement.beats.addedNotificationDescription",defaultMessage:"Added tag {tag} to {assignmentsLength, plural, one {beat {beatName}} other {# beats}}."},{tag:`"${tag}"`,assignmentsLength:beats.length,beatName:`"${beats[0].name||beats[0].id}"`});const notificationTitle=action==="removed"?intl.formatMessage({id:"xpack.beatsManagement.beats.removedNotificationTitle",defaultMessage:"{assignmentsLength, plural, one {Tag} other {Tags}} removed"},{assignmentsLength:beats.length}):intl.formatMessage({id:"xpack.beatsManagement.beats.addedNotificationTitle",defaultMessage:"{assignmentsLength, plural, one {Tag} other {Tags}} added"},{assignmentsLength:beats.length});this.setState({notifications:this.state.notifications.concat({color:"success",id:`tag-${external_kbnSharedDeps_Moment_default.a.now()}`,text:external_kbnSharedDeps_React_default.a.createElement("p",null,notificationMessage),title:notificationTitle})})});enrolled_beats_defineProperty(this,"getSelectedBeats",()=>{if(!this.tableRef.current){return[]}const selectedIds=this.tableRef.current.state.selection.map(beat=>beat.id);const beats=[];selectedIds.forEach(id=>{const beat=this.props.containers.beats.state.list.find(b=>b.id===id);if(beat){beats.push(beat)}});return beats});this.state={notifications:[],tags:null,beats:[],assignmentOptions:null};props.renderAction(this.renderActionArea)}componentDidMount(){if(this.props.urlState.beatsKBar){this.props.containers.beats.reload(this.props.urlState.beatsKBar)}this.updateBeatsData(this.props.urlState.beatsKBar)}async updateBeatsData(beatsKBar){const beats=Object(external_kbnSharedDeps_Lodash_["sortBy"])(await this.props.libs.beats.getAll(beatsKBar),"id")||[];const tags=await this.props.libs.tags.getTagsWithIds(Object(external_kbnSharedDeps_Lodash_["flatten"])(beats.map(beat=>beat.tags)));this.setState({tags:tags,beats:beats})}render(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(Breadcrumb,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.breadcrumb.enrolledBeats",{defaultMessage:"Enrolled Beats"}),path:`/overview/enrolled_beats`}),external_kbnSharedDeps_React_default.a.createElement(with_kuery_autocompletion_WithKueryAutocompletion,{libs:this.props.libs,fieldPrefix:"beat"},autocompleteProps=>external_kbnSharedDeps_React_default.a.createElement(table_Table,{kueryBarProps:{...autocompleteProps,filterQueryDraft:"false",isValid:this.props.libs.elasticsearch.isKueryValid(this.props.urlState.beatsKBar||""),onChange:value=>{this.props.setUrlState({beatsKBar:value});this.updateBeatsData(value)},onSubmit:()=>null,value:this.props.urlState.beatsKBar||""},actions:beatsListActions,actionData:{tags:this.state.assignmentOptions},actionHandler:async(action,payload)=>{switch(action){case AssignmentActionType.Assign:const status=await this.props.containers.beats.toggleTagAssignment(payload,this.getSelectedBeats());await this.updateBeatsData();this.notifyUpdatedTagAssociation(status,this.getSelectedBeats(),payload);break;case AssignmentActionType.Delete:await this.props.containers.beats.deactivate(this.getSelectedBeats());await this.updateBeatsData();this.notifyBeatDisenrolled(this.getSelectedBeats());break;case AssignmentActionType.Reload:const assignmentOptions=await this.props.libs.tags.getassignableTagsForBeats(this.getSelectedBeats());this.setState({assignmentOptions:assignmentOptions});break}},items:this.state.beats.map(beat=>({...beat,tags:(this.state.tags||[]).filter(tag=>beat.tags.includes(tag.id))})),ref:this.tableRef,type:BeatsTableType})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiGlobalToastList"],{toasts:this.state.notifications,dismissToast:()=>this.setState({notifications:[]}),toastLifeTimeMs:5e3}))}}const BeatsPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(enrolled_beats_BeatsPageComponent);function overview_extends(){overview_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return overview_extends.apply(this,arguments)}function overview_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class overview_MainPageComponent extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);overview_defineProperty(this,"onTabClicked",path=>()=>{this.props.goTo(path)});this.state={loadedBeatsAtLeastOnce:false,beats:[]}}render(){return external_kbnSharedDeps_React_default.a.createElement(primary_PrimaryLayout,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},"Beats"),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.overview.betaBadgeText",{defaultMessage:"Beta"})}))),hideBreadcrumbs:this.props.libs.framework.versionGreaterThen("6.7.0")},renderAction=>external_kbnSharedDeps_React_default.a.createElement(unstated["Subscribe"],{to:[beats_BeatsContainer,tags_TagsContainer]},(beats,tags)=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTabs"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:`/overview/enrolled_beats`===this.props.history.location.pathname,onClick:this.onTabClicked(`/overview/enrolled_beats`)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beats.enrolledBeatsTabTitle",defaultMessage:"Enrolled Beats"})),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTab"],{isSelected:`/overview/configuration_tags`===this.props.history.location.pathname,onClick:this.onTabClicked(`/overview/configuration_tags`)},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.beats.configurationTagsTabTitle",defaultMessage:"Configuration tags"}))),external_kbnSharedDeps_React_default.a.createElement(ChildRoutes,overview_extends({routes:this.props.routes,renderAction:renderAction},this.props,{beatsContainer:beats,tagsContainer:tags})))))}}const MainPage=withUrlState(overview_MainPageComponent);var constants_configuration_blocks=__webpack_require__(24);const randomEUIColor=euiVars=>{const rgb=Object(external_kbnSharedDeps_Lodash_["sample"])(Object.keys(euiVars).filter(key=>key.startsWith("euiColorVis")).map(key=>euiVars[key]));const matchedrgb=rgb.match(/^rgba?[\s+]?\([\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?,[\s+]?(\d+)[\s+]?/i);return matchedrgb&&matchedrgb.length===4?"#"+("0"+parseInt(matchedrgb[1],10).toString(16)).slice(-2)+("0"+parseInt(matchedrgb[2],10).toString(16)).slice(-2)+("0"+parseInt(matchedrgb[3],10).toString(16)).slice(-2):""};function create_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class create_TagCreatePageComponent extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);create_defineProperty(this,"saveTag",async()=>{const newTag=await this.props.containers.tags.upsertTag(this.state.tag);if(!newTag){return alert(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.createTag.errorSavingTagTitle",{defaultMessage:"error saving tag"}))}const createBlocksResponse=await this.props.libs.configBlocks.upsert(this.state.configuration_blocks.map(block=>({...block,tag:this.state.tag.id})));const creationError=createBlocksResponse.results.reduce((err,resp)=>!err?err=resp.error?resp.error.message:"":err,"");if(creationError){return alert(creationError)}this.props.goTo(`/overview/configuration_tags`)});create_defineProperty(this,"getNumExclusiveConfigurationBlocks",()=>this.state.configuration_blocks.map(({type:type})=>constants_configuration_blocks["a"].some(uniqueType=>uniqueType===type)).reduce((acc,cur)=>cur?acc+1:acc,0));this.state={showFlyout:false,currentConfigPage:0,tag:{id:"",name:"",color:randomEUIColor(external_kbnSharedDeps_Theme_euiLightVars_default.a),hasConfigurationBlocksTypes:[]},configuration_blocks:[]}}render(){const{intl:intl}=this.props;const blockStartingIndex=this.state.currentConfigPage*5;return external_kbnSharedDeps_React_default.a.createElement(primary_PrimaryLayout,{hideBreadcrumbs:this.props.libs.framework.versionGreaterThen("6.7.0"),title:intl.formatMessage({id:"xpack.beatsManagement.tag.createTagTitle",defaultMessage:"Create Tag"})},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(tag_edit_TagEdit,{tag:this.state.tag,configuration_blocks:{list:this.state.configuration_blocks.slice(blockStartingIndex,5+blockStartingIndex),page:this.state.currentConfigPage,total:this.state.configuration_blocks.length},onTagChange:(field,value)=>this.setState(oldState=>({tag:{...oldState.tag,[field]:value}})),onConfigListChange:index=>{this.setState({currentConfigPage:index})},onConfigAddOrEdit:block=>{this.setState(previousState=>({configuration_blocks:previousState.configuration_blocks.concat([block])}))},onConfigRemoved:block=>{this.setState(previousState=>{const selectedIndex=previousState.configuration_blocks.findIndex(c=>Object(external_kbnSharedDeps_Lodash_["isEqual"])(block,c));const blocks=[...previousState.configuration_blocks];blocks.splice(selectedIndex,1);return{configuration_blocks:blocks}})}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,disabled:this.state.tag.name.search(/^[A-Za-z0-9? ,_-]+$/)===-1||this.state.tag.name===""||this.getNumExclusiveConfigurationBlocks()>1,onClick:this.saveTag},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.saveButtonLabel",defaultMessage:"Save"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>this.props.goTo("/overview/configuration_tags")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.cancelButtonLabel",defaultMessage:"Cancel"}))))))}}const TagCreatePage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(create_TagCreatePageComponent);function edit_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class edit_TagEditPageComponent extends external_kbnSharedDeps_React_default.a.PureComponent{constructor(props){super(props);edit_defineProperty(this,"loadConfigBlocks",async(page=-1)=>{const blocksResponse=await this.props.libs.configBlocks.getForTags([this.state.tag.id],page);this.setState({configuration_blocks:blocksResponse})});edit_defineProperty(this,"loadTag",async()=>{const tags=await this.props.libs.tags.getTagsWithIds([this.props.match.params.tagid]);if(tags.length===0){}this.setState({tag:tags[0]})});edit_defineProperty(this,"loadAttachedBeats",async()=>{const beats=await this.props.libs.beats.getBeatsWithTag(this.props.match.params.tagid);const beatsTags=await this.props.libs.tags.getTagsWithIds(Object(external_kbnSharedDeps_Lodash_["flatten"])(beats.map(beat=>beat.tags)));this.setState({attachedBeats:beats,beatsTags:beatsTags})});edit_defineProperty(this,"saveTag",async()=>{await this.props.containers.tags.upsertTag(this.state.tag);this.props.goTo(`/overview/configuration_tags`)});edit_defineProperty(this,"getNumExclusiveConfigurationBlocks",()=>this.state.configuration_blocks.list.map(({type:type})=>constants["d"].some(uniqueType=>uniqueType===type)).reduce((acc,cur)=>cur?acc+1:acc,0));this.state={showFlyout:false,attachedBeats:null,beatsTags:[],tag:{id:props.match.params.tagid,name:"",color:"#fff",hasConfigurationBlocksTypes:[]},configuration_blocks:{list:[],page:0,total:0}}}UNSAFE_componentWillMount(){this.loadTag();this.loadAttachedBeats();this.loadConfigBlocks()}render(){const{intl:intl}=this.props;return external_kbnSharedDeps_React_default.a.createElement(primary_PrimaryLayout,{hideBreadcrumbs:this.props.libs.framework.versionGreaterThen("6.7.0"),title:intl.formatMessage({id:"xpack.beatsManagement.tag.updateTagTitle",defaultMessage:"Update Tag: {tagId}"},{tagId:this.state.tag.id})},external_kbnSharedDeps_React_default.a.createElement("div",null,external_kbnSharedDeps_React_default.a.createElement(tag_edit_TagEdit,{tag:this.state.tag,configuration_blocks:this.state.configuration_blocks,onDetachBeat:async beatIds=>{await this.props.containers.beats.removeTagsFromBeats(beatIds,this.state.tag.id);await this.loadAttachedBeats()},onTagChange:(field,value)=>this.setState(oldState=>({tag:{...oldState.tag,[field]:value}})),attachedBeats:(this.state.attachedBeats||[]).map(beat=>({...beat,tags:Object(external_kbnSharedDeps_Lodash_["flatten"])(beat.tags.map(tagId=>this.state.beatsTags.filter(tag=>tag.id===tagId)))})),onConfigListChange:index=>{this.loadConfigBlocks(index)},onConfigAddOrEdit:block=>{this.props.libs.configBlocks.upsert([{...block,tag:this.state.tag.id}]).catch(e=>{console.error("Error upseting config block",e)}).then(()=>{this.loadConfigBlocks(this.state.configuration_blocks.page)})},onConfigRemoved:block=>{this.props.libs.configBlocks.delete(block.id).catch(e=>{alert("Error removing block, please check your browsers console logs for more details");console.error(`Error removing block ${block.id}`,e)}).then(()=>{this.loadConfigBlocks(this.state.configuration_blocks.page)})}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],{size:"m"}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,disabled:this.state.tag.id.search(/^[A-Za-z0-9? ,_-]+$/)===-1||this.state.tag.id===""||this.getNumExclusiveConfigurationBlocks()>1,onClick:this.saveTag},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.saveButtonLabel",defaultMessage:"Save"}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButtonEmpty"],{onClick:()=>this.props.goTo("/overview/configuration_tags")},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.tag.cancelButtonLabel",defaultMessage:"Cancel"}))))))}}const TagEditPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(edit_TagEditPageComponent);function initial_beat_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class beat_BeatsInitialEnrollmentPage extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);initial_beat_defineProperty(this,"onBeatEnrolled",()=>{this.setState({readyToContinue:true})});initial_beat_defineProperty(this,"createEnrollmentToken",async()=>{const enrollmentToken=await this.props.libs.tokens.createEnrollmentTokens();this.props.setUrlState({enrollmentToken:enrollmentToken[0]})});this.state={readyToContinue:false}}render(){return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(enroll_beats_EnrollBeat,{frameworkBasePath:this.props.libs.framework.info.basePath,enrollmentToken:this.props.urlState.enrollmentToken||"",getBeatWithToken:this.props.libs.beats.getBeatWithToken,createEnrollmentToken:this.createEnrollmentToken,onBeatEnrolled:this.onBeatEnrolled}),this.state.readyToContinue&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{size:"s",color:"primary",style:{marginLeft:10},onClick:async()=>{this.props.goTo("/walkthrough/initial/tag")}},"Continue")))}}function finish_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class finish_FinishWalkthrough extends external_kbnSharedDeps_React_default.a.Component{constructor(props){super(props);finish_defineProperty(this,"assignTagToBeat",async()=>{const{intl:intl}=this.props;if(!this.props.urlState.enrollmentToken){return alert(intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.assignTagToBeatInvalidURLNoTokenFountTitle",defaultMessage:"Invalid URL, no enrollmentToken found"}))}if(!this.props.urlState.createdTag){return alert(intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.assignTagToBeatInvalidURLNoTagFoundTitle",defaultMessage:"Invalid URL, no createdTag found"}))}const beat=await this.props.libs.beats.getBeatWithToken(this.props.urlState.enrollmentToken);if(!beat){return alert(intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.assignTagToBeatNotEnrolledProperlyTitle",defaultMessage:"Error: Beat not enrolled properly"}))}await this.props.containers.beats.assignTagsToBeats([beat],this.props.urlState.createdTag);this.props.setUrlState({createdTag:"",enrollmentToken:""});return true});this.state={assigned:false}}componentDidMount(){setTimeout(async()=>{const done=await this.assignTagToBeat();if(done){this.setState({assigned:true})}},300)}render(){const{goTo:goTo}=this.props;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{justifyContent:"spaceAround"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiEmptyPrompt"],{iconType:"logoBeats",title:external_kbnSharedDeps_React_default.a.createElement("h2",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.nextStepTitle",defaultMessage:"Your Beat is enrolled. What's next?"})),body:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.nextStepDescription",defaultMessage:"Start your Beat to check for configuration errors, then click Done."}))),actions:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,disabled:!this.state.assigned,onClick:async()=>{goTo("/overview/enrolled_beats")}},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.firstBeatEnrollingDoneButtonLabel",defaultMessage:"Done"}))}))))}}const FinishWalkthroughPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(finish_FinishWalkthrough);const WalkthroughLayout=({walkthroughSteps:walkthroughSteps,title:title,activePath:activePath,goTo:goTo,children:children})=>{const indexOfCurrent=walkthroughSteps.findIndex(step=>activePath===step.id);return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContent"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiTitle"],null,external_kbnSharedDeps_React_default.a.createElement("h1",{style:{textAlign:"center"}},title)),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiStepsHorizontal"],{steps:walkthroughSteps.map((step,i)=>({title:step.name,isComplete:i<=indexOfCurrent,onClick:()=>goTo(step.id)}))}),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement("br",null),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiPageContentBody"],null,children))};function initial_extends(){initial_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return initial_extends.apply(this,arguments)}const InitialWalkthroughPageComponent=props=>{if(props.location.pathname==="/walkthrough/initial"){return external_kbnSharedDeps_React_default.a.createElement(NoDataLayout,{title:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],{alignItems:"center",gutterSize:"m"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},"Beats central management "),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiBetaBadge"],{label:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.walkthrough.initial.betaBadgeText",{defaultMessage:"Beta"})}))),actionSection:external_kbnSharedDeps_React_default.a.createElement(ConnectedLink,{path:"/walkthrough/initial/beat"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{color:"primary",fill:true},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.enrollBeatButtonLabel",defaultMessage:"Enroll Beat"})," "))},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.enrollBeat.beatsCentralManagementDescription",defaultMessage:"Manage your configurations in a central location."})))}return external_kbnSharedDeps_React_default.a.createElement(WalkthroughLayout,{title:props.intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.getStartedBeatsCentralManagementTitle",defaultMessage:"Get started with Beats central management"}),walkthroughSteps:[{id:"/walkthrough/initial/beat",name:props.intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.enrollBeatStepLabel",defaultMessage:"Enroll Beat"})},{id:"/walkthrough/initial/tag",name:props.intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.createTagStepLabel",defaultMessage:"Create tag"})},{id:"/walkthrough/initial/finish",name:props.intl.formatMessage({id:"xpack.beatsManagement.enrollBeat.finishStepLabel",defaultMessage:"Finish"})}],goTo:()=>{},activePath:props.location.pathname},external_kbnSharedDeps_React_default.a.createElement(ChildRoutes,initial_extends({routes:props.routes},props)))};const InitialWalkthroughPage=Object(external_kbnSharedDeps_KbnI18nReact_["injectI18n"])(InitialWalkthroughPageComponent);var v4=__webpack_require__(38);var v4_default=__webpack_require__.n(v4);function tag_defineProperty(obj,key,value){if(key in obj){Object.defineProperty(obj,key,{value:value,enumerable:true,configurable:true,writable:true})}else{obj[key]=value}return obj}class tag_InitialTagPage extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);tag_defineProperty(this,"loadTag",async()=>{const tags=await this.props.libs.tags.getTagsWithIds([this.state.tag.id]);if(tags.length>0){this.setState({tag:tags[0]})}});tag_defineProperty(this,"saveTag",async()=>{const newTag=await this.props.libs.tags.upsertTag(this.state.tag);if(!newTag){return alert(external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.createTag.errorSavingTagTitle",{defaultMessage:"error saving tag"}))}const createBlocksResponse=await this.props.libs.configBlocks.upsert(this.state.configuration_blocks.map(block=>({...block,tag:this.state.tag.id})));const creationError=createBlocksResponse.results.reduce((err,resp)=>!err?err=resp.error?resp.error.message:"":err,"");if(creationError){return alert(creationError)}this.props.setUrlState({createdTag:newTag.id});this.props.goTo(`/walkthrough/initial/finish`)});this.state={tag:{id:v4_default()(),name:"",color:"#DD0A73",hasConfigurationBlocksTypes:[]},configuration_blocks:[],currentConfigPage:0};if(props.urlState.createdTag){this.loadTag()}}render(){const blockStartingIndex=this.state.currentConfigPage*5;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(tag_edit_TagEdit,{tag:this.state.tag,configuration_blocks:{list:this.state.configuration_blocks.slice(blockStartingIndex,5+blockStartingIndex),page:this.state.currentConfigPage,total:this.state.configuration_blocks.length},onTagChange:(field,value)=>this.setState(oldState=>({tag:{...oldState.tag,[field]:value}})),onConfigListChange:index=>{this.setState({currentConfigPage:index})},onConfigAddOrEdit:block=>{this.setState(previousState=>({configuration_blocks:previousState.configuration_blocks.concat([block])}))},onConfigRemoved:block=>{this.setState(previousState=>{const selectedIndex=previousState.configuration_blocks.findIndex(c=>Object(external_kbnSharedDeps_Lodash_["isEqual"])(block,c));const blocks=[...previousState.configuration_blocks];blocks.splice(selectedIndex,1);return{configuration_blocks:blocks}})}}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexGroup"],null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiFlexItem"],{grow:false},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiButton"],{fill:true,disabled:this.state.tag.name.search(/^[A-Za-z0-9? ,_-]+$/)===-1||this.state.tag.name===""||this.state.configuration_blocks.length===0,onClick:this.saveTag},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.createTag.saveAndContinueButtonLabel",defaultMessage:"Save & Continue"})))))}}const routeMap=[{path:"/tag/create/:tagid?",component:TagCreatePage},{path:"/tag/edit/:tagid?",component:TagEditPage},{path:"/beat/:beatId",component:BeatDetailsPage,routes:[{path:"/beat/:beatId/details",component:BeatDetailPage},{path:"/beat/:beatId/tags",component:tags_BeatTagsPage}]},{path:"/error/enforce_security",component:EnforceSecurityPage},{path:"/error/invalid_license",component:InvalidLicensePage},{path:"/error/no_access",component:NoAccessPage},{path:"/overview",component:MainPage,routes:[{path:"/overview/configuration_tags",component:TagsPage},{path:"/overview/enrolled_beats",component:BeatsPage}]},{path:"/walkthrough/initial",component:InitialWalkthroughPage,routes:[{path:"/walkthrough/initial/beat",component:beat_BeatsInitialEnrollmentPage},{path:"/walkthrough/initial/finish",component:FinishWalkthroughPage},{path:"/walkthrough/initial/tag",component:tag_InitialTagPage}]}];function router_extends(){router_extends=Object.assign||function(target){for(var i=1;i<arguments.length;i++){var source=arguments[i];for(var key in source){if(Object.prototype.hasOwnProperty.call(source,key)){target[key]=source[key]}}}return target};return router_extends.apply(this,arguments)}class router_AppRouter extends external_kbnSharedDeps_React_["Component"]{constructor(props){super(props);this.state={loading:true}}async UNSAFE_componentWillMount(){if(this.state.loading===true){try{await this.props.beatsContainer.reload();await this.props.tagsContainer.reload()}catch(e){}this.setState({loading:false})}}render(){if(this.state.loading===true){return external_kbnSharedDeps_React_default.a.createElement(Loading,null)}const countOfEverything=this.props.beatsContainer.state.list.length+this.props.tagsContainer.state.list.length;return external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_React_default.a.Fragment,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Switch"],null,Object(external_kbnSharedDeps_Lodash_["get"])(this.props.libs.framework.info,"license.expired",true)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{render:props=>!props.location.pathname.includes("/error")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/error/invalid_license"}):null}),!Object(external_kbnSharedDeps_Lodash_["get"])(this.props.libs.framework.info,"security.enabled",true)&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{render:props=>!props.location.pathname.includes("/error")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/error/enforce_security"}):null}),!this.props.libs.framework.currentUserHasOneOfRoles(["beats_admin"].concat(this.props.libs.framework.info.settings.defaultUserRoles))&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{render:props=>!props.location.pathname.includes("/error")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/error/no_access"}):null}),countOfEverything===0&&external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{render:props=>!props.location.pathname.includes("/walkthrough")?external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/walkthrough/initial"}):null}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Route"],{path:"/",exact:true,render:()=>external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Redirect"],{to:"/overview/enrolled_beats"})})),external_kbnSharedDeps_React_default.a.createElement(WithURLState,null,URLProps=>external_kbnSharedDeps_React_default.a.createElement(ChildRoutes,router_extends({routes:routeMap},URLProps,{libs:this.props.libs,containers:{beats:this.props.beatsContainer,tags:this.props.tagsContainer}}))))}}const renderApp=({element:element,history:history},libs)=>{external_kbnSharedDeps_ReactDom_default.a.render(external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_StyledComponents_["ThemeProvider"],{theme:{eui:external_kbnSharedDeps_Theme_euiLightVars_}},external_kbnSharedDeps_React_default.a.createElement(kbn_services["a"].I18nContext,null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ReactRouterDom_["Router"],{history:history},external_kbnSharedDeps_React_default.a.createElement(unstated["Provider"],{inject:[new beats_BeatsContainer(libs),new tags_TagsContainer(libs)]},external_kbnSharedDeps_React_default.a.createElement(provider_BreadcrumbProvider,{useGlobalBreadcrumbs:libs.framework.versionGreaterThen("6.7.0")},external_kbnSharedDeps_React_default.a.createElement(unstated["Subscribe"],{to:[beats_BeatsContainer,tags_TagsContainer]},(beats,tags)=>external_kbnSharedDeps_React_default.a.createElement(Background,null,external_kbnSharedDeps_React_default.a.createElement(Breadcrumb,{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.management.breadcrumb",{defaultMessage:"Management"})}),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiCallOut"],{title:external_kbnSharedDeps_KbnI18n_["i18n"].translate("xpack.beatsManagement.management.deprecationTitle",{defaultMessage:"Beats central management has been deprecated"}),color:"warning",iconType:"help"},external_kbnSharedDeps_React_default.a.createElement("p",null,external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.management.deprecationMessage",defaultMessage:"We have ceased development on Beats central management and are working on a comprehensive solution to replace it. Thank you for participating in the beta and providing feedback. If you have any questions or concerns, please reach out to us on the {forumLink}.",values:{forumLink:external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiLink"],{href:"https://discuss.elastic.co/c/beats",external:true,target:"_blank"},external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_KbnI18nReact_["FormattedMessage"],{id:"xpack.beatsManagement.management.forumLink",defaultMessage:"Discuss forum"}))}}))),external_kbnSharedDeps_React_default.a.createElement(external_kbnSharedDeps_ElasticEui_["EuiSpacer"],null),external_kbnSharedDeps_React_default.a.createElement(router_AppRouter,{libs:libs,beatsContainer:beats,tagsContainer:tags})))))))),element);return()=>{external_kbnSharedDeps_ReactDom_default.a.unmountComponentAtNode(element)}}}])]);